

XMLTransform[{

(* Known cell styles *)
(*	"PacletName", "ShortDescription", "PacletVersion", "OtherRequirements", "Price", 
	"PreviewImage", "Categorization", "Abstract", "SearchTerms", 
	"Documentation", "ImplementationNotes" *)

{Cell, "Thumbnail"} :> 
Block[{ce},
	ce = SelectLiteral[SelectSelf[] ];
	Export["thumbnail.jpg", ce, ImageSize->{50, Automatic}];

	(*DIV[{"class"->GetStyle[]}, {
		transmogrifyImage[ ToFileName[{"Files"}, ToString@$ImageCount++ <> "_g.gif"], 
			Inline -> True, CropImage -> False, ImageSize -> {200, Automatic}] }]*)
], 

{CellGroupData, "KeyFeaturesSection" | "NewInVersionSection"} :> 
Module[{cells = First@SelectLiteral[SelectSelf[]] },
DIV[{"class"->"basicGroup"}, {
	Recurse[ First@cells],
	XMLElement["ul", {}, {Recurse[ Rest@cells]}  ]
}]],

{Cell, "NewInVersionSection" | "KeyFeaturesSection" | "SnapshotsSection" } :> 
DIV[{"class"->"basicHeading"}, { Recurse[] }],

{Cell, "NewInVersion" | "KeyFeatures"} :> 
Li[{}, {Recurse[]}],

{Cell, "Documentation" | "Categorization"} :> 
DIV[{"class"->GetStyle[]}, {
	transmogrifyImage[ ToFileName[{"Files"}, ToString@DocumentationBuild`Common`$ImageCount++ <> "_g.gif"], 
		Inline -> True, CropImage -> False] }],

{Cell, "Graphics"} :> 
DIV[{"class"->"Snapshot"}, {
	transmogrifyImage[ ToFileName[{"Files"}, ToString@DocumentationBuild`Common`$ImageCount++ <> "_g.gif"], 
		Inline -> True, ImageSize -> {100, 100}] }],

{Cell, "Snapshot"} :>
Module[{imageCell, src, w, h, imgnum, thumbnail},
imgnum = ToString@DocumentationBuild`Common`$ImageCount++;
imageCell = SelectLiteral[SelectSelf[] ];

src = ToFileName[{"Files"}, "popup_" <> imgnum <> ".jpg"];
thumbnail = ToFileName[{"Files"}, "thumbnail_" <> imgnum <> ".gif"];

(* make sure that directory is there *)
CreateDirectory[DirectoryName@src];
(* export popup images *)
Export[src, imageCell ];
Export[thumbnail, imageCell, ImageSize -> {100, Automatic}];

src = StringReplace[src, "\\"->"/"];
(* Information for popup windows *)
{w, h} = Import[src, "ImageSize"];

Span[{"class" -> "Snapshot"}, {
	A[{"href"->"javascript:setVisible('"<>imgnum<>"'"<>");", "onclick"->"javascript:setVisible('"<>imgnum<>"'"<>");return false;"}, {
    XMLElement["img", {
      "src" -> ("URL" /. #), "width" -> ("Width" /. #), "height" -> ("Height" /. #), "border"->"0"
    }, {}]&[
    BoxToImage[ thumbnail,
      imageCell,
      Inline -> True, ImageSize -> {100, Automatic}
      ]]
    }],
    DIV[{"id"->"popup"<>imgnum, "class"->"popupLayer", "style"->"top:-"<>ToString@IntegerPart[(ToExpression[h]*.31)]<>"px;left:80px"}, {
		DIV[{"class"->"popupCloseBox"}, {
			A[{"href"->"javascript:setVisible('"<>imgnum<>"'"<>");return false;", "onclick"->"javascript:setVisible('"<>imgnum<>"'"<>");return false;"}, {"X"}]
		}],
	    DIV[{"class"->"popupContent"}, { Img[{"src"->src, "border"->"0", "width"->ToString[w], "height"->ToString[h] }]
    	}]
    }]
}]
]


},

IncludeXMLTransforms -> Transmogrify`$DefaultXMLTransforms

]
