(* :Title: SolutionsPages.m *)

(* :Author:
  Greg Martel, gregm@wolfram.com
*)

(* :Mathematica Version: 7 *)
(* :Package Version: $Revision: 1.2 $ $Date: 2012/08/16 19:50:36 $ *)                  
(* :Copyright: (c) 2009, Wolfram Research, Inc. All rights reserved. *)
(* :Summary: General transform for Mathematica Solution Pages *)


XMLTransform[{

(* Transform Notebook *)
{Notebook} :>  Block[{nbExpression,title,abstractlist,abstract,label,abstractcaptions,abstractimage,sectionTitles,captions,
	captionstext,captionslist,captionscount,jscaptions,jsimages,exportjsimages,featuresection,featuresubsection,featuretabHeaders,
	featureText,featureSeeAlso,featureBox,featurecolumns,featurecol1,featurecol2,whyChooseSection,whyChooseCol1,
	whyChooseCol2,waysToUseSection,(*waysToUseBreakpoint,*)waysToUseCol1,waysToUseCol2,pageRightColumn,pageLeftColumn,
	whyChooseImage,waysToUseImage,abstractSection,gbGray,gbColor,questionnairetitle,captionGroup,captionInsert,seeAlsoSection,
	solutionsLang,langExt,titleName,summary,pageRightColumnTest, newAltTagPerPam, actionHead, actionText, actionButton, 
	actionButtonIcon, actionIcon, actionIconWidth, actionIconHeight, fileBase, extendRolloverWindowList, applianceList, advertisementlist,
	descriptionText},
	
	fileBase = GetParameter["nbFileName"];
	(* utility functions *)
	GetSectionByStyleAndCellTag[expr_, style_String, tag_String]:=
    Cases[expr, Cell[CellGroupData[{Cell[aa_, style, bb___, CellTags->tag, cc___], dd___}, ee___], ff___], Infinity];
    
    extendRolloverWindowList = {"OperationsResearch", "SocialSciences"};
    
    applianceList={"AerospaceEngineering", "Astronomy", "BiologicalSciences", "Chemistry", "DataMining", 
    	"Econometrics", "Economics", "EnvironmentalSciences", "FinancialRiskManagement", "Geosciences", "MaterialsScience", 
    	"OperationsResearch", "Statistics"};
    advertisementlist={"FinancialEngineeringAndMathematics", "ImageProcessing", "InterfaceDevelopment", "SoftwareEngineering",
    	"Statistics", "WebDevelopment"};
    	
    CleanMetaForWeb[{desc_String}]:= (
   {StringReplace[desc, {"&"->" and ", "'"->"`", "\"" -> "&quot;"}]}
   );
    CleanMetaForWeb[desc_String]:= (
   StringReplace[desc, {"&"->" and ", "'"->"`", "\"" -> "&quot;"}]
   );
    	
    GetGroupByCellTag[expr_, "LearnMoreAboutMathematicaDefault"]:=
    {{}, "LearnMoreAboutMathematicaDefault"};
    
    GetGroupByCellTag[expr_, celltag_String]:=
    {Cases[expr, Cell[CellGroupData[{Cell[aa_, "SolutionsSection", bb___, CellTags->celltag, cc___], dd___}, ee___], ff___], Infinity], celltag};
    
    WrapInULAndTransmogrify[L_List, UlClass_String, ListClass_String, styleoption_String:""]:= (
    Map[If[MemberQ[{ListClass}, #[[1,2]]]
    		, UL[If[styleoption==="",{"class"->UlClass},{"class"->UlClass, "style"->styleoption}]
    			, {Transmogrify[#]}], Transmogrify[#]]&,L]
    );
    
    GetTitleAndHrefForImage[content_, cellStyle1_String, cellStyle2_String]:=(
    	content/.CellGroupData[{Cell[TextData[{v:ButtonBox[{a__}|a__, a1__,ButtonNote->a2_, a3___]}],cellStyle1,b___], 
    			Cell[x1_,cellStyle2,x2__], e___},Open]:>
    	CellGroupData[{Cell[TextData[{v}],cellStyle1,b], 
    			Cell[x1,cellStyle2,x2,CellTags->{a2,ConvertToString[{a}]}],e},Open]
    				);
    				
    CapitalizeFirstLetter[a_String] := ToUpperCase[StringTake[a, 1]] <> StringDrop[a, 1];
    CaptalizeFirstLetterEntireString[a_String] :=  Module[{brokenList, lowercaseItemList, capitalItemList},
 		brokenList = StringSplit[a];
		lowercaseItemList = Map[CapitalizeFirstLetter[#] &, brokenList];
		capitalItemList = Riffle[lowercaseItemList, " "];
		StringReplace[StringJoin[capitalItemList], {" And"->" and"}]
 	 ];
 	 
 	  HyphenateFileName[instring_String] := Module[{newWord},
   newWord = 
    StringReplace[StringReplace[instring, 
     a___ ~~ b_ ~~ c___ /; 
       StringMatchQ[b, RegularExpression["[A-Z]"]] :> 
      a ~~ "-" <> ToLowerCase[b] ~~ c
     ], "/-"->"/"] ;
   If[StringCases[newWord, RegularExpression["[A-Z]"]] === {},
    If[StringTake[newWord, 1] === "-", StringDrop[newWord, 1], 
     newWord],
    HyphenateFileName[newWord]
    ]
   ];
   
    ChangeButtonData[in_String]:=StringReplace[HyphenateFileName[in], {"medical-engineering"->"medical-imaging", "mechanical-and-structural-engineering"->"mechanical-engineering", 
			"data-mining"->"data-analysis-and-mining"}];
    				
    fixGuillemet[sectionList_List]:= Module[{sectionListNew},
    	
    	sectionListNew = sectionList /. {
    	Cell[TextData[{a1_StyleBox,a2_String/;StringTake[a2,-1]===" ",ButtonBox["\[RightGuillemet]",BaseStyle->"Hyperlink",b__]}],c1_String/;
    		StringMatchQ[c1,"SolutionsListing"|"SolutionsMoreLink"],c2___]:>
    	Cell[TextData[{ButtonBox[{a1,StringDrop[a2,-1], StyleBox["\[RightGuillemet]", "chevron"]},BaseStyle->"Hyperlink",b]}],c1,c2],
    	Cell[TextData[{a_String,a1_StyleBox, a2_String/;StringTake[a2,-1]===" ", ButtonBox["\[RightGuillemet]",BaseStyle->"Hyperlink",b__]}],"SolutionsListing",c___]:>
    	Cell[TextData[{ButtonBox[{a,a1,StringDrop[a2,-1],StyleBox["\[RightGuillemet]", "chevron"]},BaseStyle->"Hyperlink",b]}],"SolutionsListing",c],
    	Cell[TextData[{a__String,ButtonBox["\[RightGuillemet]",BaseStyle->"Hyperlink",b__]}],"SolutionsListing",c___]:>
    	Cell[TextData[{ButtonBox[{StringTrim[a], StyleBox["\[RightGuillemet]", "chevron"]},BaseStyle->"Hyperlink",b]}],"SolutionsListing",c],
    	Cell[TextData[{a__,ButtonBox["\[RightGuillemet]",BaseStyle->"Hyperlink",b__]}],"SolutionsListing",c___]:>
    	Cell[TextData[{ButtonBox[{a, StyleBox["\[RightGuillemet]", "chevron"]},BaseStyle->"Hyperlink",b]}],"SolutionsListing",c],
    	Cell[TextData[{a__String,ButtonBox["\[RightGuillemet]",BaseStyle->"Hyperlink",b__]}],"SolutionsMoreLink",c___]:>
    	Cell[TextData[{ButtonBox[{StringTrim[a], StyleBox["\[RightGuillemet]", "chevron"]},BaseStyle->"Hyperlink",b]}],"SolutionsMoreLink",c],
    	Cell[TextData[{a__,ButtonBox["\[RightGuillemet]",BaseStyle->"Hyperlink",b__]}],"SolutionsMoreLink",c___]:>
    	Cell[TextData[{ButtonBox[{a, StyleBox["\[RightGuillemet]", "chevron"]},BaseStyle->"Hyperlink",b]}],"SolutionsMoreLink",c]
    	};

    	sectionListNew = sectionListNew /.{
    	Cell[TextData[{ButtonBox[{StyleBox[a_String,b__]," ",StyleBox["\[RightGuillemet]","chevron"]},BaseStyle->"Hyperlink",c__]}],"SolutionsListing",d__]:>
    	Cell[TextData[{ButtonBox[{StyleBox[a,b],StyleBox["\[RightGuillemet]","chevron"]},BaseStyle->"Hyperlink",c]}],"SolutionsListing",d], 
    	Cell[TextData[{ButtonBox[{a1_, StyleBox[a_String,b__]," ",StyleBox["\[RightGuillemet]","chevron"]},BaseStyle->"Hyperlink",c__]}],"SolutionsListing",d__]:>
    	Cell[TextData[{ButtonBox[{a1,StyleBox[a,b],StyleBox["\[RightGuillemet]","chevron"]},BaseStyle->"Hyperlink",c]}],"SolutionsListing",d], 
    	
    	Cell[TextData[{a__String,ButtonBox["\[RightGuillemet]"|"\[RightGuillemet] ",BaseStyle->"bluelink",b__]}],c1_String/;
    		StringMatchQ[c1, "SolutionsMoreLink"|"SolutionsListing"],c2___]:>
    	Cell[TextData[{ButtonBox[{StringTrim[a], StyleBox["\[RightGuillemet]", "chevron"]},BaseStyle->"Hyperlink",b]}],c1,c2],
    	
    	Cell[TextData[{a__String,b_StyleBox, c_String/;StringTake[c,-1]===" ", ButtonBox["\[RightGuillemet]"|"\[RightGuillemet] ",BaseStyle->"bluelink",d__]}],e1_String/;
    		StringMatchQ[e1, "SolutionsMoreLink"|"SolutionsListing"],e2___]:>
    	Cell[TextData[{ButtonBox[{a,b,StringDrop[c,-1], StyleBox["\[RightGuillemet]", "chevron"]},BaseStyle->"Hyperlink",d]}],e1,e2],
    	
    	Cell[TextData[{a__String,b_StyleBox, c_String, ButtonBox["\[RightGuillemet]"|"\[RightGuillemet] ",BaseStyle->"bluelink",d__]}],e1_String/;
    		StringMatchQ[e1, "SolutionsMoreLink"|"SolutionsListing"],e2___]:>
    	Cell[TextData[{ButtonBox[{a,b,c, StyleBox["\[RightGuillemet]", "chevron"]},BaseStyle->"Hyperlink",d]}],e1,e2],
    	
    	Cell[TextData[{a1_StyleBox, a2_String/;StringTake[a2,-1]===" ",ButtonBox["\[RightGuillemet]"|"\[RightGuillemet] ",BaseStyle->"bluelink",b__]}],c1_String/;
    		StringMatchQ[c1, "SolutionsText"|"SolutionsListing"],c2___]:>
    	Cell[TextData[{ButtonBox[{a1,StringDrop[a2,-1], StyleBox["\[RightGuillemet]", "chevron"]},BaseStyle->"Hyperlink",b]}],c1,c2],
    	
    	(*Cell[TextData[{a1_StyleBox, a2_String/;StringTake[a2,-1]===" ",a3___, ButtonBox["\[RightGuillemet]"|"\[RightGuillemet] ",BaseStyle->"bluelink",b__]}],c1_String/;
    		StringMatchQ[c1, "SolutionsText"|"SolutionsListing"],c2___]:>
    	Cell[TextData[{ButtonBox[{a1,StringDrop[a2,-1], a3, StyleBox["\[RightGuillemet]", "chevron"]},BaseStyle->"Hyperlink",b]}],c1,c2],*)
    	
    	Cell[TextData[{a1_StyleBox, a2_String/;StringTake[a2,-1]===" ",a3_StyleBox, a4_String, ButtonBox["\[RightGuillemet]"|"\[RightGuillemet] ",BaseStyle->"bluelink",b__]}],c1_String/;
    		StringMatchQ[c1, "SolutionsText"|"SolutionsListing"],c2___]:>
    	Cell[TextData[{ButtonBox[{a1,StringDrop[a2,-1], a3, a4, StyleBox["\[RightGuillemet]", "chevron"]},BaseStyle->"Hyperlink",b]}],c1,c2],
    	
    	Cell[TextData[{ButtonBox[a_String,BaseStyle->"bluelink",b__],
    		Cell[BoxData[ButtonBox["\[RightGuillemet]"|"\[RightGuillemet] ",BaseStyle->"bluelink",c__]],"InlineFormula",d__]}],d1_String/;
    		StringMatchQ[d1, "SolutionsText"|"SolutionsListing"],d2__]:>
    			Cell[TextData[{ButtonBox[{a, StyleBox["\[RightGuillemet]", "chevron"]},BaseStyle->"Hyperlink",b]}],d1, d2],
    			
    	Cell[TextData[{ButtonBox[{a1_String/;StringTake[a1,-1]===" ","\[RightGuillemet]"|"\[RightGuillemet] "},BaseStyle->"bluelink",a2__]}],a3_String/;
    		StringMatchQ[a3, "SolutionsText"|"SolutionsListing"],b__]:>
    		Cell[TextData[{ButtonBox[{StringDrop[a1,-1],StyleBox["\[RightGuillemet]", "chevron"]},BaseStyle->"Hyperlink",a2]}],a3,b],
    		
    	Cell[TextData[{a__String, b_Cell, c_String, ButtonBox["\[RightGuillemet]"|"\[RightGuillemet] ",BaseStyle->"bluelink",d__]}],e1_String/;
    		StringMatchQ[e1, "SolutionsMoreLink"|"SolutionsListing"],e2___]:>
    	Cell[TextData[{ButtonBox[{a,b,c, StyleBox["\[RightGuillemet]", "chevron"]},BaseStyle->"Hyperlink",d]}],e1,e2], 
    	
    	Cell[TextData[{a_StyleBox, b__String, c1____StyleBox, c2____String, ButtonBox["\[RightGuillemet]"|"\[RightGuillemet] ",BaseStyle->"bluelink",d__]}],e1_String/;
    		StringMatchQ[e1, "SolutionsMoreLink"|"SolutionsListing"],e2___]:>
    	Cell[TextData[{ButtonBox[{a,b,c1,c2, StyleBox["\[RightGuillemet]", "chevron"]},BaseStyle->"Hyperlink",d]}],e1,e2], 
    	
    	Cell[TextData[{a_String,b_StyleBox,c_String,d_StyleBox,e_String, ButtonBox["\[RightGuillemet]"|" \[RightGuillemet]",
    		BaseStyle->"bluelink", f___]}], "SolutionsListing",g___]:> 
    		Cell[TextData[{ButtonBox[{a,b,c,d,e, StyleBox["\[RightGuillemet]", "chevron"]}, BaseStyle->"Hyperlink",f]}], "SolutionsListing", g],
    		
    	Cell[TextData[{a_String,b_StyleBox,ButtonBox["\[RightGuillemet]"|" \[RightGuillemet]",BaseStyle->"bluelink", c___]}],"SolutionsListing",d__]:>
    		Cell[TextData[{ButtonBox[{a,b,StyleBox["\[RightGuillemet]", "chevron"]}, BaseStyle->"Hyperlink",c]}], "SolutionsListing", d],
    		
    	Cell[TextData[{a__String,b_StyleBox,c___, ButtonBox["\[RightGuillemet]"|" \[RightGuillemet]",BaseStyle->"bluelink", c1___]}],"SolutionsListing",c2__]:>
    		Cell[TextData[{ButtonBox[{a,b,c, StyleBox["\[RightGuillemet]", "chevron"]}, BaseStyle->"Hyperlink",c1]}], "SolutionsListing", c2]
    		}
    		;    	
    	sectionListNew
    	];
				
    (* end *)
    solutionsLang=GetParameter["Language"];
    langExt = Switch[solutionsLang,
    	"ChineseSimplified","zh",
    	"Spanish","es",
    	"Japanese","ja",
    	"Russian", "ru",
	    "Korean", "ko",
	    "Portuguese", "pt", 
    	_,"en"];
   
	nbExpression = SelectSelf[] /. {Cell[a__, "InternalNoteLink", b___]->"",
	Cell[TextData[StyleBox[ButtonBox[a_String,b__],"InlineFormulaListItem",c__]],
		"SolutionsListing",d__]:>
	Cell[ButtonBox[{StyleBox[a,"InlineFormulaListItem"],"\[NonBreakingSpace]",StyleBox["\[RightGuillemet]","chevron2"]},b],
		"SolutionsListing",d]};
	
	label=Cases[nbExpression, Cell[a__, "SolutionsLabel", b___]:>
		Cell[StringReplace[a, {"FINANCE AND ECONOMICS"->"Finance and Economics", "SOFTWARE AND APPLICATION DEVELOPMENT"->"Software and Application Development", 
			"DIGITAL IMAGE ANALYSIS SYSTEM"->"Digital Image Analysis System", "SCIENCE"->"Science", "ENGINEERING"->"Engineering", 
			"STATISTICS AND BUSINESS ANALYSIS"->"Statistics and Business Analysis"}], "SolutionsLabel", b], Infinity];
	title=Cases[nbExpression, Cell[a__, "SolutionsTitle", b___], Infinity];
	titleName=GetParameter["titleName"];
	questionnairetitle=ToLowerCase@CellToString[title[[1]]   ];
	abstractlist=Cases[nbExpression, Cell[a__, "SolutionsAbstract", b___], Infinity];
	abstract=abstractlist;
	
	summary = GetParameter["summary"];
	summary = ExportString[XMLElement["String", {}, { GetParameter["summary"] }], "XML", "Entities" -> "HTML"];
	summary = If[Head@summary === String,
			StringReplace[summary, {"<String>" -> "", "</String>" -> ""}],
			""];
	summary = CleanMetaForWeb[summary];
	descriptionText= CleanMetaForWeb@First[MathLink`CallFrontEnd[FrontEnd`ExportPacket[GetParameter["description"], "PlainText"]]];
    
  	Export[
   	 StringJoin[GetFileNameBase[], ".html-head"],
   	 XML`RawXML[ StringJoin[ExportString[#, "XML"] & /@ 
   	 Flatten[{
   	 XML`RawXML[ ExportString[
			If[GetParameter["altTitleName"]==={},
			XMLElement["title", {}, {Localized["Mathematica Solution for ", solutionsLang], titleName }],
			XMLElement["title", {}, {GetParameter["altTitleName"][[1]]}]
			]
		, "XML"] ],
	If[Length@GetParameter["keywords"] > 0, 
      XMLElement["meta", {
          "name"->"keywords", 
          "content"->StringList[GetParameter["keywords"]] }, {}], {}],
	If[Length@GetParameter["synonyms"] > 0, 
      XMLElement["meta", {
         "name"->"synonyms", 
         "content"->StringList[GetParameter["synonyms"]] }, {}], {}],
    If[Head@GetParameter["summary"] === String, 
      XMLElement["meta", {
          "name"->"description", 
          "content"-> descriptionText }, {}], {}],
    XML`RawXML["<link rel=\"shortcut icon\" href=\"/common/images2003/favicon.ico\" type=\"image/x-icon\" />"]
          
          (*, if re added, use XML raw to remove ending slash from empty element per rich
	  XMLElement["link", {"rel"->"stylesheet", "type"->"text/css","href"->"/solutions/css/solutions.css"}, {}]*)
   		 }]
  	  ]]
  	  , "XML", If[langExt==="ja", CharacterEncoding->"ShiftJIS", {}]
  	];


	(*Export[
	StringJoin[".htaccess"], 

	ExportString[ XML`RawXML["
SetEnv STYLE_BarType 0
SetEnv STYLE_Sidebar 0
SetEnv STYLE_PageHeader ''
SetEnv STYLE_PageHeaderHeight 1
SetEnv STYLE_PageHeaderTopHeight 1
SetEnv STYLE_PageHeaderLine 0
SetEnv STYLE_BarType 0

SetEnv STYLE_InternalPageWidth 1000
SetEnv STYLE_PaddingWidth 40

SetEnv STYLE_FooterWidth 1000
SetEnv STYLE_FooterPaddingWidth 40

SetEnv STYLE_JavascriptIncludes '<script type=\"text/javascript\" src=\"/common/javascript/jquery/plugins/addState/1.0/jquery.addState.js\"></script><link rel=\"stylesheet\" type=\"text/css\" href=\"/common/css/css2010/m8.css\"><link rel=\"stylesheet\" type=\"text/css\" href=\"/solutions/css/solutionsM8fix.css\"><script language=\"JavaScript\" type=\"text/javascript\" src=\"/common/javascript/menu.js\"></script><script language=\"JavaScript\" type=\"text/javascript\" src=\"/common/javascript/rollover.js\"></script>'
SetEnv STYLE_Body '<body id=\"forIndustry\"><script type=\"text/javascript\" src=\"/solutions/javascript/solutions.js\"></script><script type=\"text/javascript\" src=\"/solutions/javascript/questions.js\"></script><script type=\"text/javascript\" src=\"/common/javascript/jquery/plugins/wflipbook/jquery.wflipbook.js\"></script><script type=\"text/javascript\" src=\"/solutions/javascript/jquery.slideshow.js\"></script>'
SetEnv STYLE_CustomTopHeader3 ''	
	"], "XML"]
    , 
	"Text"
	];*)
	
	seeAlsoSection=Cases[nbExpression, Cell[CellGroupData[{Cell[aa_, "SolutionsSection", bb___, CellTags->"SeeAlso", cc___], dd___}, ee___], ff___]:>dd, Infinity];
	seeAlsoSection=seeAlsoSection/.{Cell[a_String,"SolutionsListing",b__]:>StyleBox[a,"SeeAlsoPullDown"],
	Cell[TextData[{a_,ButtonBox["\[RightGuillemet]",x1___, ButtonData->x2_String,b__]}],"SolutionsListing",c___]:>
	Cell[ButtonBox[{a,"\[RightGuillemet]"},x1,ButtonData->ChangeButtonData[x2],b],"SolutionsListing",c]};
	
	seeAlsoSection=seeAlsoSection/.{Cell[a_String,"SolutionsListing",b__]:>StyleBox[a,"SeeAlsoPullDown"],
	Cell[TextData[{a_,ButtonBox["\[RightGuillemet]",x1___, ButtonData->{URL[x2_String], None},b__]}],"SolutionsListing",c___]:>
	Cell[ButtonBox[{a,"\[RightGuillemet]"},x1,ButtonData->ChangeButtonData[x2],b],"SolutionsListing",c]};
	
	sectionTitles=Cases[nbExpression, Cell[CellGroupData[{Cell[aa_, "SolutionsSection", bb___, CellTags->tag_, cc___], dd___}, ee___], ff___]:>tag, Infinity];
	sectionTitles=DeleteCases[sectionTitles, "CaptionsAndImagesForSlideshow"|"MathematicaFeatures"|"SeeAlso"|"Companies"];
	pageRightColumn={"UserStories","TryASimpleExample","WolframBlog","WolframDemonstrationsProject","AuthoredInMathematica"};
	pageRightColumnTest=Intersection[sectionTitles,pageRightColumn];
	pageRightColumn=Cases[sectionTitles, a_String/;MemberQ[pageRightColumn,a]];
	pageLeftColumn=DeleteCases[sectionTitles, a_String/;MemberQ[pageRightColumn,a]];
	pageLeftColumn=If[MemberQ[pageLeftColumn, "LearnMoreAboutMathematicaDefault"|"LearnMoreAboutMathematica"]===False,
		pageLeftColumn=Append[pageLeftColumn,"LearnMoreAboutMathematicaDefault"], 
		pageLeftColumn ];
	
	
	captions=Cases[nbExpression, Cell[a__,"SolutionsAbstractGraphicsCaption",__]:>CellToString[a], Infinity];
	captionscount=Table[i, {i, Length@captions}];
	captionstext=
		Cases[nbExpression, Cell[a__,"SolutionsAbstractCaptionText",__]:>CellToString[a], Infinity];
	captionslist=Transpose[{captionscount,captions,captionstext}];
    
    abstractSection=Cases[nbExpression, Cell[CellGroupData[{Cell[aa_, "SolutionsSection", bb___, CellTags->"CaptionsAndImagesForSlideshow", cc___], dd___}, ee___], ff___]:>dd, Infinity];
    abstractSection=Partition[
	Cases[abstractSection, Cell[__,"SolutionsAbstractImage"|"SolutionsAbstractGraphicsCaption"|"SolutionsAbstractCaptionText",___], Infinity], 
	3 ];
	captionInsert=Length@abstractSection;
	jscaptions=StringDrop[StringDrop[ToString@Map[
"'#img"<>ToString[#]<>",#caption"<>ToString[#]<>",#specialcaption"<>ToString[#]<>"'"&, Table[i, {i, captionInsert}]], 1
], -1];

    featuresection=Cases[nbExpression, Cell[CellGroupData[{Cell[aa_, "SolutionsSection", bb___, CellTags->"MathematicaFeatures", cc___], dd___}, ee___], ff___]:>dd, Infinity];
    featuresection=featuresection/. ButtonBox[b__, BaseStyle->"Hyperlink", bb___]:>ButtonBox[b, BaseStyle->"bluelink", bb];
    featuresection = fixGuillemet[featuresection];
    	
    featuretabHeaders=Cases[featuresection, Cell[__,"SolutionsSubsection",__], Infinity];
    featureSeeAlso=Cases[featuresection, Cell[a__,"SolutionsMoreLink",b__]:>Cell[a,"SolutionsMoreLinkFeature",b], Infinity];
    featureSeeAlso=If[featureSeeAlso==={}," ", featureSeeAlso];
    featuresection=DeleteCases[featuresection, Cell[__,"SolutionsMoreLink",__], Infinity];
    featurecolumns=Cases[featuresection, Cell[CellGroupData[{Cell[aa_, "ColumnSubsection", bb___], dd___}, ee___], ff___], Infinity];
    featurecol1=DeleteCases[featurecolumns[[1]], Cell[_,"ColumnSubsection", __], Infinity]/. {
    	Cell[a__,"SolutionsImageShifted", b__]:> Cell[a,"SolutionsImageShiftedInline2", b],
    	Cell[a__,"SolutionsListing", b__]:> Cell[a,"SolutionsFeatureListing", b]};
    featurecol1=GetTitleAndHrefForImage[featurecol1,"SolutionsFeatureListing","SolutionsImageShiftedInline2"]; 
    	
    featurecol2=Cases[
    DeleteCases[featurecolumns[[2]], Cell[_,"ColumnSubsection", __], Infinity], 
    CellGroupData[{a__}, b___]:>a];
    featurecol2=DeleteCases[featurecol2, 
    	Cell[CellGroupData[{Cell[aa_, "SolutionsSubsubsection", bb___], dd___}, ee___], ff___], 
    	Infinity] /. {Cell[a__,"SolutionsImageShifted", b__]:> Cell[a,"SolutionsImageShiftedInline2", b],
    		Cell[a__,"SolutionsListing", b__]:> Cell[a,"SolutionsFeatureListing", b]};
    featurecol2=GetTitleAndHrefForImage[featurecol2,"SolutionsFeatureListing","SolutionsImageShiftedInline2"]; 
  
    
    featureBox=Cases[featurecolumns, Cell[CellGroupData[{Cell[aa_, "SolutionsSubsubsection",aa1___,CellTags->"BuiltInComputableData",bb___], dd___}, ee___], ff___]:>dd, Infinity];
    featureBox=featureBox /. Cell[BoxData[GraphicsBox[TagBox[RasterBox[CompressedData[a__], b__], c__], d__] , e___], "SolutionsImageShifted", f___]:>
    Cell[TextData[
     Cell[BoxData[GraphicsBox[TagBox[RasterBox[CompressedData[a], b], c], d], e], "Input"] ], "SolutionsImageShifted", f];
    featureBox= featureBox /. Cell[CellGroupData[{Cell[a__, "SolutionsListing", cc___], 
    	Cell[CellGroupData[{Cell[a1__, "SolutionsListingPlain", a11___],Cell[a2_, "SolutionsImageShifted",a22___], a33___}, a3___], y___], ee___}, ff___], gg___]:>
    	Cell[{Cell[a2, "SolutionsImageShifted", a22], Cell[{StyleBox[a,"blueBoxTitle2"],"\n", a1}, "blueBoxText", a11]}, "blueBoxItem", cc];
    featureBox=DeleteCases[featureBox, Cell[_,"SolutionsMoreLink", __], Infinity] /. {
    Cell[a__,"SolutionsText", b__]:> Cell[a,"blueBoxTitle", b]
    };
    (*Add CellTag with function name to blue box image*)
    featureBox=featureBox /. Cell[{Cell[a_,"SolutionsImageShifted",b__],
    	Cell[{StyleBox[TextData[{ButtonBox[{c1_String,c2__},d__]}],"blueBoxTitle2"],"\n",e__},"blueBoxText",f__]},"blueBoxItem",g__]:>
    Cell[{Cell[a,"SolutionsImageShifted",b, CellTags->c1],
    	Cell[{StyleBox[TextData[{ButtonBox[{c1,StyleBox["\[RightGuillemet]","chevron"]},d]}],"blueBoxTitle2"],"\n",e},"blueBoxText",f]},"blueBoxItem",g];
        
    whyChooseSection=Cases[featuresection, Cell[CellGroupData[{Cell[aa_, "SolutionsSubsection", bb___, CellTags->"WhyChooseMathematica", cc___], dd___}, ee___], ff___]:>dd, Infinity];
    whyChooseImage=If[MatchQ[whyChooseSection[[1]],Cell[_,"SolutionsImageShifted", __] ],
    	whyChooseSection[[1]]/.Cell[a_,"SolutionsImage"|"SolutionsImageShifted", b__]:>Cell[a,"SolutionsImageShiftedInline", b],{}];
    whyChooseSection = whyChooseSection /.Cell[CellGroupData[{Cell[aa_, "SolutionsListing", bb___, cc___], Cell[dd1_, "AnnotationText", dd2__]}, ee___], ff___]:>
    	Cell[{aa, "\n", StyleBox[dd1,"blueText",dd2]}, "SolutionsListing", bb, cc];
    whyChooseSection = whyChooseSection /.Cell[CellGroupData[{Cell[aa_, "SolutionsListing", bb___, cc___], Cell[dd1_, "AnnotationText", dd2__], Cell[dd3_, "AnnotationText", dd4__]}, ee___], ff___]:>
    	Cell[{aa, "\n", StyleBox[dd1,"blueText",dd2],"\n",StyleBox[dd3,"blueText",dd4]}, "SolutionsListing", bb, cc];
    whyChooseSection = whyChooseSection /. {
    	Cell[a__,"SolutionsText"|"SolutionsAbstract", b__]:> Cell[a,"SolutionsFeatureListingNoBL", b],
    	Cell[a__,"SolutionsListing", b__]:> Cell[a,"SolutionsFeatureListing", b]
    	};
    whyChooseSection=Cases[whyChooseSection, Cell[CellGroupData[{Cell[aa_, "ColumnSubsection", bb___], dd___}, ee___], ff___], Infinity];

    whyChooseCol1=DeleteCases[whyChooseSection[[1]], Cell[_,"ColumnSubsection", __], Infinity];
    whyChooseCol1=GetTitleAndHrefForImage[whyChooseCol1,"SolutionsFeatureListing","SolutionsImageShiftedInline"];
    
    whyChooseCol2=Cases[whyChooseSection[[2]], CellGroupData[{a__}, b___]:>a, Infinity];
    whyChooseCol2=GetTitleAndHrefForImage[whyChooseCol2,"SolutionsFeatureListing","SolutionsImageShiftedInline"];
    whyChooseCol2=If[MatchQ[whyChooseImage, Cell[_,"SolutionsImageShiftedInline", __]],
    	Prepend[DeleteCases[whyChooseCol2, Cell[_,"ColumnSubsection", __], Infinity], whyChooseImage],
    	DeleteCases[whyChooseCol2, Cell[_,"ColumnSubsection", __], Infinity]];
    	
    waysToUseSection=Cases[featuresection, Cell[CellGroupData[{Cell[aa_, "SolutionsSubsection", bb___, CellTags->"WaysToUse", cc___], dd___}, ee___], ff___]:>dd, Infinity];
    waysToUseImage=If[MatchQ[waysToUseSection[[1]],Cell[_,"SolutionsImageShifted", __] ],
    	waysToUseSection[[1]]/.Cell[a_,"SolutionsImage"|"SolutionsImageShifted", b__]:>Cell[a,"SolutionsImageShiftedInline", b],{}];
    waysToUseSection = waysToUseSection /.Cell[CellGroupData[{Cell[aa_, "SolutionsListing", bb___, cc___], Cell[dd1_, "AnnotationText", dd2__]}, ee___], ff___]:>
    	Cell[{aa, "\n", StyleBox[dd1,"blueText",dd2]}, "SolutionsListing", bb, cc];
    waysToUseSection = waysToUseSection /. {
    	Cell[a__,"SolutionsText"|"SolutionsAbstract", b__]:> Cell[a,"SolutionsFeatureListingNoBL", b],
    	Cell[a__,"SolutionsListing", b__]:> Cell[a,"SolutionsFeatureListing", b]
    	};
    waysToUseSection=Cases[waysToUseSection, Cell[CellGroupData[{Cell[aa_, "ColumnSubsection", bb___], dd___}, ee___], ff___], Infinity];

    waysToUseCol1=DeleteCases[waysToUseSection[[1]], Cell[_,"ColumnSubsection", __], Infinity];
    waysToUseCol1=GetTitleAndHrefForImage[waysToUseCol1,"SolutionsFeatureListing","SolutionsImageShiftedInline"];
    waysToUseCol2=Cases[waysToUseSection[[2]], CellGroupData[{a__}, b___]:>a, Infinity];
    waysToUseCol2=GetTitleAndHrefForImage[waysToUseCol2,"SolutionsFeatureListing","SolutionsImageShiftedInline"];
    waysToUseCol2=If[MatchQ[waysToUseImage, Cell[_,"SolutionsImageShiftedInline", __]],
    	Prepend[DeleteCases[waysToUseCol2, Cell[_,"ColumnSubsection", __], Infinity], waysToUseImage],
    	DeleteCases[waysToUseCol2, Cell[_,"ColumnSubsection", __], Infinity]];
    
    MakeRightColumnSection[expr_, celtag_]:= Block[{rightColumnName,rightColumnHead,rightColumnSection,rightColumnSectionHead,rightColumnContent,rightColumnimg,
    	rightColumnHref,rightColumnTop,rightColumnBottom,podBody,rightColumnSubsubectionTest,rightColTransformList,altTitleList,blogAltTitle},
    	
    	rightColumnSection=GetSectionByStyleAndCellTag[expr, "SolutionsSection", celtag]; 
        rightColumnSectionHead=Cases[rightColumnSection,
    		Cell[a__,"SolutionsSection",b___], Infinity];
    	rightColumnSectionHead=rightColumnSectionHead/. {
    		Cell[TextData[{StyleBox[a_String, a1__],b_String}], "SolutionsSection",c___]:>
 				Cell[TextData[{StyleBox[a, a1], b}], "smallpodTitle",c],
 			Cell[TextData[{b_String, StyleBox[a_String, a1__]}], "SolutionsSection",c___]:>
 				Cell[TextData[{b, StyleBox[a, a1]}], "smallpodTitle",c],
    		Cell[a_String, "SolutionsSection", b___] :>Cell[a, "smallpodTitle", b]
    	};
    	
    	blogAltTitle=If[celtag==="WolframBlog", Cases[rightColumnSection,Cell[TextData[ButtonBox[a_, b__]], "SolutionsSubsubsection", c___]:>a, Infinity],
    		""];
    	blogAltTitle=If[Head@blogAltTitle===List, First@blogAltTitle, ""];
    		
    	rightColumnSubsubectionTest=Cases[rightColumnSection, 
    	Cell[CellGroupData[{Cell[a__,"SolutionsSubsubsection",b___], c___},d___], e___], Infinity];
    	rightColumnSection=If[rightColumnSubsubectionTest==={},rightColumnSection,rightColumnSubsubectionTest];
    	rightColumnSection=rightColumnSection/. {
    		Cell[CellGroupData[{Cell[TextData[{a__, ButtonBox[aa1__, ButtonNote->aa2_]}],"SolutionsSubsubsection",b___],Cell[xx__,"SolutionsImageShifted",yy___], c___},d___], e___]:>
    		Cell[CellGroupData[{Cell[TextData[{a, ButtonBox[aa1, ButtonNote->aa2]}],"SolutionsSubsubsection",b],Cell[xx,"SolutionsImageShifted",yy,CellTags->aa2], c},d], e],
    		Cell[CellGroupData[{Cell[TextData[ButtonBox[aa1__, ButtonNote->aa2_]],"SolutionsSubsubsection",b___],Cell[xx__,"SolutionsImageShifted",yy___], c___},d___], e___]:>
    		Cell[CellGroupData[{Cell[TextData[ButtonBox[aa1, ButtonNote->aa2]],"SolutionsSubsubsection",b],Cell[xx,"SolutionsImageShifted",yy,CellTags->aa2], c},d], e], 
    		Cell[CellGroupData[{Cell[TextData[{ButtonBox[{a__}, a1__, ButtonData->{URL[aa2_],None}]}],"SolutionsSubsubsection",b___],Cell[xx__,"SolutionsImageShifted",yy___], c___},d___], e___]:>
    		Cell[CellGroupData[{Cell[TextData[{ButtonBox[{a}, a1, ButtonData->{URL[aa2],None}]}],"SolutionsSubsubsection",b],Cell[xx,"SolutionsImageShifted",yy,CellTags->aa2], c},d], e]
    		};	
    			
    	rightColumnSection = Which[celtag==="UserStories",
    		rightColumnSection /.Cell[a_, "SolutionsSubsubsection", b___] :>Cell[a, "profileTitle", b],
    				celtag==="WolframBlog",
    		rightColumnSection /.Cell[a_, "SolutionsSubsubsection", b___] :>Cell[a, "profileTitle", b],
    		True, rightColumnSection];
    	rightColumnSection = fixGuillemet[rightColumnSection];
    	
    	rightColumnSection = rightColumnSection /. {
    		Cell[a_String, "SolutionsSection", b___] :>Cell[a, "smallpodTitle", b],
    		Cell[a_, "SolutionsSubsubsection", b___] :>Cell[a, "exampleTitle", b],
    	    Cell[a_, "SolutionsQuote", b___] :>Cell[a, "profileText", b], 
    	    Cell[a_, "SolutionsAuthor", b___] :>Cell[a, "profileAuthor", b], 
    	    Cell[a_, "SolutionsAuthorTitle", b___] :>Cell[a, "profileAuthorTitle", b], 
    	    Cell[a_, "SolutionsProfileCaption", b___] :>Cell[a, "profileCaption", b], 
    	    Cell[a_, "SolutionsListing", b___] :>Cell[a, "BulletedText", b], 
    	    Cell[a_, "SolutionsMoreLink", b___] :>Cell[a, "viewAll", b]
    	};
    	
    	rightColumnSection = Which[celtag==="WolframDemonstrationsProject",
    		rightColumnSection /.Cell[a_, "profileText", b___] :>Cell[a, "demonstrationsText", b],
    		True, rightColumnSection];
    		
    	(*rightColumnSection=If[celtag==="UserStories", *)
    	rightColumnSection=If[MemberQ[{"UserStories", "WolframBlog"}, celtag], 
    		rightColumnSection /. {
    			Cell[a_, "SolutionsImageShifted", CellTags->{"popup",b1__},b2___] :>Cell[a, "profileImagePopup",CellTags->{"popup",b1},b2],
    			Cell[a_, "SolutionsImageShifted", b___] :>Cell[a, "profileImage", b]},
    		rightColumnSection /. Cell[a_, "SolutionsImageShifted", b___] :>Cell[a, "exampleImage", b]
    		];
    	
    	rightColumnTop=
    	If[celtag==="UserStories", Map[
    	Cases[#, Cell[a_, "smallpodTitle"|"profileTitle"|"profileImage"|"profileImagePopup"|"profileCaption"|"exampleTitle"|"exampleImage", b___], Infinity]&, rightColumnSection
    	] /. Cell[a_, "exampleTitle", b___]:>Cell[a, "profileTitle", b],
    	Map[
    	Cases[#, Cell[a_, "smallpodTitle"|"profileTitle"|"profileImage"|"exampleImage", b___], Infinity]&, rightColumnSection
    	] /. Cell[a_, "exampleTitle", b___]:>Cell[a, "profileTitle", b]
    	];
    	
    	rightColumnBottom=If[celtag==="UserStories",
    	Map[
    		Split[Cases[#, Cell[a_, "profileText"|"profileAuthor"|"profileAuthorTitle"|"BulletedText"|"viewAll", b___], Infinity],
    	#1[[2]]===#2[[2]]&]&, rightColumnSection
    	], 
    	Map[
    		Split[Cases[#, Cell[a_, "profileText"|"profileAuthor"|"profileAuthorTitle"|"BulletedText"|"viewAll"|"exampleTitle"|"demonstrationsText", b___], Infinity],
    	#1[[2]]===#2[[2]]&]&, rightColumnSection
    	]
    	];
    	
    	altTitleList = Switch[celtag,
    		"AuthoredInMathematica", "Authored in Mathematica",
    		"WolframDemonstrationsProject", "Wolfram Demonstrations Project",
    		"WolframBlog", "The Wolfram Blog",
    		"UserStories", Map[CellToString@#[[1]]&, 
    			  Cases[rightColumnTop,Cell[__, "profileTitle", ___], Infinity]  ],
    	    "TryASimpleExample", CellToString@rightColumnSectionHead[[1]](*Map[CellToString@#[[1]]&, 
    			  Cases[rightColumnBottom,Cell[__, "exampleTitle", ___], Infinity]  ]*),
    		True,""];
    	
		rightColTransformList=Transpose[{rightColumnTop, rightColumnBottom}];
		
    	makeRightPodBody[{rTop__,rBot__}]:=Sequence[DIV[{"class"->"profileContainer"}, {
    				Transmogrify[rTop]
    			   	}],	
    		Which[MemberQ[{"TryASimpleExample","WolframDemonstrationsProject"}, celtag], 

				DIV[{"class"->"smallpodcontainer"}, {
    					XMLElement["UL",{"class"->"blueUL"},{Transmogrify[rBot]}],
    					XML`RawXML["<div class=\"downloadCont\">
    					<div class=\"downloadImage\"><a href=\"/products/player/download.cgi\"><img src=\"/solutions/images/solutions/downloadarrow.gif\" alt=\"Download Free Player Here\" title=\"Download Free Player Here\" border=\"0\"></a></div>
						<div class=\"downloadText\"><a href=\"/cdf-player/\">"],
						Transmogrify[Localized["Download Free Player Here", solutionsLang]],
						XML`RawXML["&nbsp;<span class=\"chevron\">&raquo;</span></a></div>
						</div>"] } ],
				MemberQ[{"AuthoredInMathematica"}, celtag], 
				DIV[{"class"->"smallpodcontainer"}, {
    					XMLElement["UL",{"class"->"blueUL"},{Transmogrify[rBot]}]
						} ],
				True, DIV[{"class"->"smallpodcontainer"}, {
    				WrapInULAndTransmogrify[rBot, "blueUL", "BulletedText"]
				}]
    		]
    	];
    	
    If[rightColTransformList==={},"",
    	DIV[{"class"->"podWrapper"}, {
    		DIV[{"class"->"smallpodbackground"}, {
    			Transmogrify[rightColumnSectionHead],
    			Map[makeRightPodBody[#]&, rightColTransformList]
    		}] (* smallpodbackground *)
    		}]
    	]
    ];


    MakeSolutionsOpenCloseSection[{{}, "LearnMoreAboutMathematicaDefault"}]:=Module[{celtag},
    	celtag="LearnMoreAboutMathematicaDefault";
    	DIV[{"class"->"podWrapper"}, {
    		DIV[{"class"->"podbackground"}, {
    			XML`RawXML["<div class=\"bluetopbar\"></div>"],
    			DIV[{"class"->"overflow"}, {
    				DIV[{"class"->"podIcon2"}, {
    					A[{"href"->"/learningcenter/"}, {
    					XMLElement["img", {"class"->"titleImage","src"->"/solutions/images/solutions/GetStarted_8.jpg", "border"->"0", 
    	"alt"->"Get Started with Mathematica", "title"->"Get Started with Mathematica"}, {}]
    					}]
    					}],
    				XMLElement["div",{"class"->"podTitle"}, {    
    				XMLElement["div",{"class"->"titleImage"}, {
    					A[{"href"->"/learningcenter/"}, {
    						 Transmogrify[Localized["GET STARTED WITH MATHEMATICA", solutionsLang]],
    						 XMLElement["span", {"class"->"chevron"}, {XML`RawXML["&nbsp;"],
    						 Transmogrify[StyleBox["\[RightGuillemet]","chevron"]]
    						 }]
    						}]
					}]
    				}]
    				}]
    			}], (* end podbackground *)
    		 (* end podWrapper *)
    		
    		XMLElement["div",{}, {XMLElement["img",{"src"->"/solutions/images/solutions/bottombar.gif"(*, "alt"->" ", "title"->" "*)},{}]}]
    	}]
    	
    ];
    
    
    
    MakeSolutionsOpenCloseSection[{{cellgroupcell_Cell}, celtag_String}]:= Module[{group,openCloseIcon,openCloseImage,titleContent,
    	columns, column1, column2,column3},
    	
    	If[celtag==="LearnMoreAboutMathematicaDefault", 
    		DIV[{"class"->"podWrapper"}, {
    		DIV[{"class"->"podbackground"}, {
    			XML`RawXML["<div class=\"bluetopbar\"></div>"],
    			DIV[{"class"->"overflow"}, {
    				DIV[{"class"->"podIcon2"}, {
    					A[{"href"->"/learningcenter/"}, {
    					XMLElement["img", {"class"->"titleImage","src"->"/solutions/images/solutions/GetStarted_8.jpg", "border"->"0", 
    	"alt"->"Get Started with Mathematica", "title"->"Get Started with Mathematica"}, {}]
    					}]
    					}],
    				XMLElement["div",{"class"->"podTitle"}, {    
    				XMLElement["div",{"class"->"titleImage"}, {
    					A[{"href"->"/learningcenter/"}, {
    						 Transmogrify[Localized["GET STARTED WITH MATHEMATICA", solutionsLang]],
    						 XMLElement["span", {"class"->"chevron"}, {XML`RawXML["&nbsp;"],
    						 Transmogrify[StyleBox["\[RightGuillemet]","chevron"]]
    						 }]
    						}]
					}]
    				}]
    				}]
    			}], (* end podbackground *)
    		 (* end podWrapper *)
    		
    		XMLElement["div",{}, {XMLElement["img",{"src"->"/solutions/images/solutions/bottombar.gif"(*, "alt"->" ", "title"->" "*)},{}]}]
    	}],
    		
    	group=cellgroupcell;
    	titleContent=Cases[group, Cell[a__,"SolutionsSection", b__], Infinity];
    	titleContent=titleContent /. {
    		Cell[TextData[{a_String, StyleBox[aa_String, bb__]}],"SolutionsSection", b__]:>
    		Cell[TextData[{ToUpperCase[a], StyleBox[ToUpperCase[aa], bb]}],"SolutionsSection", b],
    		Cell[TextData[{StyleBox[aa_String, bb__],a_String}],"SolutionsSection", b__]:>
    		Cell[TextData[{StyleBox[ToUpperCase[aa], bb],ToUpperCase[a]}],"SolutionsSection", b],
    		Cell[a_String,"SolutionsSection", b__]:>Cell[ToUpperCase[a],"SolutionsSection", b]
    		};
    	columns=Cases[group, Cell[CellGroupData[{Cell[aa_, "ColumnSubsection", bb___], dd___}, ee___], ff___], Infinity];
   	
   		columns = columns /. {
   	Cell[TextData[{a_,ButtonBox["\[RightGuillemet]",
 	BaseStyle->"Hyperlink",
 	ButtonData->{URL[b_String/;
 		StringJoin[
 			Insert[ Riffle[Drop[Drop[StringSplit[b, "/"], 1], -1], "/"],  "http:/" , 1 ]
 		]==="http://reference.wolfram.com/mathematica/ref"], None}, c__]}], "SolutionsListing", d__]:>
 	Cell[TextData[ButtonBox[{StyleBox[StringTrim[a], "InlineFormulaListItem"],StyleBox["\[RightGuillemet]","chevron"]}, BaseStyle->"Hyperlink", ButtonData->{
   	URL[b], None}, c]], "SolutionsListing", d],
   	
   	Cell[TextData[{a_, ButtonBox["\[RightGuillemet]",
 	BaseStyle->"Hyperlink",
 	ButtonData->{URL[b_String/;
 		StringMatchQ[StringJoin[
 			Insert[ Riffle[Drop[Drop[StringSplit[b, "/"], 1], -1], "/"],  "http:/" , 1 ]
 		],"http://reference.wolfram.com/mathematica/"~~__~~"/ref"]], None}, c__]}], "SolutionsListing", d__]:>
 	Cell[TextData[ButtonBox[{StyleBox[StringTrim[a], "InlineFormulaListItem"],StyleBox["\[RightGuillemet]","chevron"]}, BaseStyle->"Hyperlink", ButtonData->{
   	URL[b], None}, c]], "SolutionsListing", d],
   	
   	Cell[TextData[{a_, " ", ButtonBox["\[RightGuillemet]",
 	BaseStyle->"Hyperlink",
 	ButtonData->{URL[b_String/;
 		StringJoin[
 			Insert[ Riffle[Drop[Drop[StringSplit[b, "/"], 1], -1], "/"],  "http:/" , 1 ]
 		]==="http://reference.wolfram.com/mathematica/ref"], None}, c__]}], "SolutionsListing", d__]:>
 	Cell[TextData[ButtonBox[{StyleBox[StringTrim[a], "InlineFormulaListItem"],StyleBox["\[RightGuillemet]","chevron"]}, BaseStyle->"Hyperlink", ButtonData->{
   	URL[b], None}, c]], "SolutionsListing", d],
   	
   	Cell[TextData[{a_, " ", ButtonBox["\[RightGuillemet]",
 	BaseStyle->"Hyperlink",
 	ButtonData->{URL[b_String/;
 		StringMatchQ[StringJoin[
 			Insert[ Riffle[Drop[Drop[StringSplit[b, "/"], 1], -1], "/"],  "http:/" , 1 ]
 		],"http://reference.wolfram.com/mathematica/"~~__~~"/ref"]], None}, c__]}], "SolutionsListing", d__]:>
 	Cell[TextData[ButtonBox[{StyleBox[StringTrim[a], "InlineFormulaListItem"],StyleBox["\[RightGuillemet]","chevron"]}, BaseStyle->"Hyperlink", ButtonData->{
   	URL[b], None}, c]], "SolutionsListing", d],
   	
   	Cell[TextData[{a_,ButtonBox["\[RightGuillemet]",
 	BaseStyle->"Hyperlink",
 	ButtonData->{URL[b_String/; StringMatchQ[
 		StringJoin[
 			Insert[ Riffle[Drop[Drop[StringSplit[b, "/"], 1], -1], "/"],  "http:/" , 1 ]
 		],"http://reference.wolfram.com/mathematica/"~~RegularExpression["\\w+"]~~"/ref"] ], None}, c__]}], "SolutionsListing", d__]:>
 	Cell[TextData[ButtonBox[{StyleBox[StringTrim[a], "InlineFormulaListItem"],StyleBox["\[RightGuillemet]","chevron"]}, BaseStyle->"Hyperlink", ButtonData->{
   	URL[b], None}, c]], "SolutionsListing", d]
   	};
   	
    	(* massage list spacing to guillemet *)
    	columns = columns /. {
    	Cell[TextData[{a1_StyleBox,a2_String/;StringTake[a2,-1]===" ",ButtonBox["\[RightGuillemet]",BaseStyle->"Hyperlink",b__]}],c1_String/;
    		StringMatchQ[c1,"SolutionsListing"|"SolutionsMoreLink"],c2___]:>
    	Cell[TextData[{ButtonBox[{a1,StringDrop[a2,-1], StyleBox["\[RightGuillemet]", "chevron"]},BaseStyle->"Hyperlink",b]}],c1,c2],
    	Cell[TextData[{a1_StyleBox, StyleBox[ButtonBox["\[RightGuillemet]",BaseStyle->"Hyperlink",b__], __]}],c1_String/;
    		StringMatchQ[c1,"SolutionsListing"|"SolutionsMoreLink"],c2___]:>
    	Cell[TextData[{ButtonBox[{a1, StyleBox["\[RightGuillemet]", "chevron"]},BaseStyle->"Hyperlink",b]}],c1,c2],
    	Cell[TextData[{a_String,a1_StyleBox, a2_String/;StringTake[a2,-1]===" ", ButtonBox["\[RightGuillemet]",BaseStyle->"Hyperlink",b__]}],"SolutionsListing",c___]:>
    	Cell[TextData[{ButtonBox[{a,a1,StringDrop[a2,-1],StyleBox["\[RightGuillemet]", "chevron"]},BaseStyle->"Hyperlink",b]}],"SolutionsListing",c],
    	Cell[TextData[{a__String,ButtonBox["\[RightGuillemet]",BaseStyle->"Hyperlink",b__]}],"SolutionsListing",c___]:>
    	Cell[TextData[{ButtonBox[{StringTrim[a], StyleBox["\[RightGuillemet]", "chevron"]},BaseStyle->"Hyperlink",b]}],"SolutionsListing",c],
    	Cell[TextData[{a__,ButtonBox["\[RightGuillemet]",BaseStyle->"Hyperlink",b__]}],"SolutionsListing",c___]:>
    	Cell[TextData[{ButtonBox[{a, StyleBox["\[RightGuillemet]", "chevron"]},BaseStyle->"Hyperlink",b]}],"SolutionsListing",c],
    	Cell[TextData[{a__String,ButtonBox["\[RightGuillemet]",BaseStyle->"Hyperlink",b__]}],"SolutionsMoreLink",c___]:>
    	Cell[TextData[{ButtonBox[{StringTrim[a], StyleBox["\[RightGuillemet]", "chevron"]},BaseStyle->"Hyperlink",b]}],"SolutionsMoreLink",c],
    	Cell[TextData[{a__,ButtonBox["\[RightGuillemet]",BaseStyle->"Hyperlink",b__]}],"SolutionsMoreLink",c___]:>
    	Cell[TextData[{ButtonBox[{a, StyleBox["\[RightGuillemet]", "chevron"]},BaseStyle->"Hyperlink",b]}],"SolutionsMoreLink",c]
    	};
    	
    	columns = columns /.{
    	Cell[TextData[{ButtonBox[{StyleBox[a_String,b__]," ",StyleBox["\[RightGuillemet]","chevron"]},BaseStyle->"Hyperlink",c__]}],"SolutionsListing",d__]:>
    	Cell[TextData[{ButtonBox[{StyleBox[a,b],StyleBox["\[RightGuillemet]","chevron"]},BaseStyle->"Hyperlink",c]}],"SolutionsListing",d], 
    	Cell[TextData[{ButtonBox[{a1_, StyleBox[a_String,b__]," ",StyleBox["\[RightGuillemet]","chevron"]},BaseStyle->"Hyperlink",c__]}],"SolutionsListing",d__]:>
    	Cell[TextData[{ButtonBox[{a1,StyleBox[a,b],StyleBox["\[RightGuillemet]","chevron"]},BaseStyle->"Hyperlink",c]}],"SolutionsListing",d]
    		};
    		
    	(* More replacements to add nbsp before Guillemet when there is only normal space;*)
    	columns = columns /. {
    	Cell[TextData[{ButtonBox[{a0_StyleBox,a_String,StyleBox[a2_,a3__],a4_String/;StringTake[a4,-1]===" ",StyleBox["\[RightGuillemet]","chevron"]}, d__]}],"SolutionsListing",e__]:>
    	Cell[TextData[{ButtonBox[{a0,a, StyleBox[a2,a3],StringDrop[a4, -1],"\[NonBreakingSpace]",StyleBox["\[RightGuillemet]","chevron2"]}, d]}],"SolutionsListing",e],
    	
    	Cell[TextData[{ButtonBox[{a_String,StyleBox[a2_String/;StringTake[a2,-1]===" ",a3__],StyleBox["\[RightGuillemet]","chevron"]}, d__]}],"SolutionsListing",e__]:>
    	Cell[TextData[{ButtonBox[{a, StyleBox[StringDrop[a2, -1],a3],"\[NonBreakingSpace]",StyleBox["\[RightGuillemet]","chevron2"]}, d]}],"SolutionsListing",e],
    	
    	Cell[TextData[{ButtonBox[{a_String,b_StyleBox,StyleBox["\[RightGuillemet]","chevron"]},
    			BaseStyle->"Hyperlink",c__]}],d_String/; StringMatchQ[d,"SolutionsListing"|"SolutionsMoreLink"],e___]:>
    	Cell[TextData[{ButtonBox[{a,b,"\[NonBreakingSpace]",StyleBox["\[RightGuillemet]","chevron"]},
    			BaseStyle->"Hyperlink",c]}],d,e],
    			
    	Cell[TextData[{ButtonBox[{a_String,b_StyleBox,c_String, StyleBox[d1_String/;StringTake[d1,-1]===" ",d2__],StyleBox["\[RightGuillemet]","chevron"]},
    			e__]}],f_String/; StringMatchQ[f,"SolutionsListing"|"SolutionsMoreLink"],g__]:>
    	Cell[TextData[{ButtonBox[{a,b,c,StyleBox[StringDrop[d1, -1],d2],StyleBox["\[RightGuillemet]","chevron"]},e]}],f,g],
    	
    	Cell[TextData[{ButtonBox[{a_String,a1_StyleBox,a2_String,a3_StyleBox,b_String/;StringTake[b,-1]===" ",StyleBox["\[RightGuillemet]","chevron"]},
    			g__]}],h_String/; StringMatchQ[h,"SolutionsListing"|"SolutionsMoreLink"],i__]:>
    	Cell[TextData[{ButtonBox[{a,a1,a2,a3,StringDrop[b,-1],StyleBox["\[RightGuillemet]","chevron"]}, g]}],h,i], 
    	
    	Cell[TextData[{a_String, b__StyleBox, StyleBox[ButtonBox["\[RightGuillemet]",c___], ___]}], "SolutionsListing",d___]:>
		Cell[TextData[{ButtonBox[{a,b,StyleBox["\[RightGuillemet]","chevron"]}, c]}], "SolutionsListing", d],
		
		Cell[TextData[{a_String/;StringTake[a,-1]=!=" ", ButtonBox[" \[RightGuillemet]",c___]}], "SolutionsListing",d___]:>
		Cell[TextData[{ButtonBox[{a, " ", StyleBox["\[RightGuillemet]","chevron"]}, c]}], "SolutionsListing", d]
    	};
    		
    	columns=DeleteCases[columns, Cell[_, "ColumnSubsection", ___], Infinity];
    	columns=If[celtag==="RelatedDocumentation",DeleteCases[columns, Cell[_, "SolutionsMoreLink", ___], Infinity],columns];
    	columns=columns /. {
    		Cell[aa_, "SolutionsImageShifted"|"SolutionsImage", bb___]:>Cell[aa, "showCaseImage", bb],
    		Cell[aa_, "SolutionsSubsubsection", bb___]:>Cell[aa, "ULtitle", bb],
    		Cell[aa_, "SolutionsMoreLink", bb___]:>Cell[aa, "BulletedText", bb],
    		Cell[aa_, "SolutionsListing", bb___]:>Cell[aa, "BulletedText", bb]
    	};
    	    	
    	column1=If[
    		celtag==="LearnMoreAboutMathematica", 
    		{Cell["dummytext", "showCaseImageGettingStarted"]},
    		DeleteCases[columns[[1]], Cell[_, "SolutionsText", ___], Infinity]
    	];
    	
    	column2=Cases[columns[[2]], Cell[_, "BulletedText"|"ULtitle"|"SolutionsMoreLink", ___], Infinity];
    	column2=Split[column2, #1[[2]]===#2[[2]]&];
    	column3=Cases[columns[[3]], Cell[_, "BulletedText"|"ULtitle"|"SolutionsMoreLink", ___], Infinity];
    	column3=Split[column3, #1[[2]]===#2[[2]]&];
    
    TitleCaseString[s_String] := Module[{lcs, ccs, sss},
    lcs = ToLowerCase[s];
    sss = StringSplit[lcs, " "];
    ccs = Map[
     StringReplace[#, 
       StartOfString ~~ a_ ~~ b___ :> ToUpperCase[a] <> b]&, 
     sss];
    ccs = StringJoin@@Riffle[ccs, " "]
    ];
   
    newAltTagPerPam =  
    TitleCaseString[Transmogrify`ConvertToString[titleContent[[1,1]]] ];

    openCloseIcon =Switch[celtag,
    "CaseStudies", {"usersIcon", newAltTagPerPam},
    "RelatedDocumentation", {"docIcon", "Related Documentation"},
    "OtherResources", {"resourcesIcon", "Other Resources"},
    "LearnMoreAboutMathematica", {"experienceIcon", "Get Started with Mathematica"},
    _, {"usersIcon", "Case Studies"}
    ];

    openCloseImage=XMLElement["img", {"class"->"titleImage","src"->"/solutions/images/solutions/"<>openCloseIcon[[1]]<>".gif", 
    	"alt"->openCloseIcon[[2]], "title"->openCloseIcon[[2]]}, {}];
    	
    	DIV[{"class"->"podWrapper"}, {
    		DIV[{"class"->"podbackground"}, {
    			XML`RawXML["<div class=\"bluetopbar\"></div>"],
    			DIV[{"class"->"overflow"}, {
    				DIV[{"class"->"podIcon"}, {openCloseImage
    					}],
    				XMLElement["div",{"class"->"podTitle titleImage"}, {Transmogrify[titleContent]}]
    				}], (* end overflow *)
    				XML`RawXML["<div class=\"seeExample seeExampleUp\">
    				<img src=\"/common/images/spacer.gif\" alt=\""],
    				Localized["See Examples",solutionsLang],
    				XML`RawXML["\" title=\""],
    				Localized["See Examples",solutionsLang],
    				XML`RawXML["\" border=\"0\" height=\"10\" width=\"80\">
    				</div>"]
    			}], (* end podbackground *)
    		DIV[{"class"->"container"}, {
    			DIV[{"class"->"bigpod"}, {XMLElement["hr",{},{}]}],
    			DIV[{"class"->"ulcontainer"}, {
    				    DIV[{"class"->"showcase"}, {Transmogrify[column1]}],
    					DIV[{"class"->"ulcol"}, {WrapInULAndTransmogrify[column2, "nodotUL", "BulletedText", "margin-bottom:20px;"]}],
						DIV[{"class"->"ulcol"}, {WrapInULAndTransmogrify[column3, "nodotUL", "BulletedText", "margin-bottom:20px;"]}]
    			}],(* end ulcontainer *)
    			 		If[celtag==="RelatedDocumentation", DIV[{"class"->"viewMore"}, {
    			(* A[{"href"->"http://reference.wolfram.com/"}, {"More documentation"}] *)
    			A[{"href"->"http://reference.wolfram.com/"}, {Localized["More documentation",solutionsLang]}]
    			}], XML`RawXML["<br>"]]
    		}], (* end podWrapper *)
    		
    		XMLElement["div",{}, {XMLElement["img",{"src"->"/solutions/images/solutions/bottombar.gif"(*, "alt"->" ", "title"->" "*)},{}]}]
    	}] (* end podWrapper *)
    	
    	]
    ];

FillInLayout[
    GetParameter["layoutfile"],
    "Text",
    
	"jsSlideshow"->
	ExportString[XML`RawXML[jscaptions],
		"XML", "AttributeQuoting"->"\"", "Entities"->{"\[LongDash]"->"&mdash;"}, "ElementFormatting"->All],
		
	"topnav"->
		ExportString[
			Switch[langExt,
				"ja", XML`RawXML["<!--#include virtual=\"/solutions/includes/topnav.ja.html\"-->"],
				"zh", XML`RawXML["<!--#include virtual=\"/solutions/includes/topnav.zh.html\"-->"],
				"es", XML`RawXML["<!--#include virtual=\"/solutions/includes/topnav.es.html\"-->"],
				"ko", XML`RawXML["<!--#include virtual=\"/solutions/includes/topnav.ko.html\"-->"],
				"pt", XML`RawXML["<!--#include virtual=\"/solutions/includes/topnav.pt.html\"-->"],
				"ru", XML`RawXML["<!--#include virtual=\"/solutions/includes/topnav.ru.html\"-->"],
				_, XML`RawXML["<!--#include virtual=\"/solutions/includes/topnav.html\"-->"]
			],
		"XML", "AttributeQuoting"->"\"", "Entities"->{"\[LongDash]"->"&mdash;"}, "ElementFormatting"->All],
		
	MakeFooter[adList_List, base_String, lang_String]:=If[lang==="en",
		
	If[MemberQ[adList, base], 
					XML`RawXML["<!--#include virtual=\"/solutions/includes/dobbs.html\"--><!--#include virtual=\"/common/includes/m8/footer-industry.html\"-->"], 
					XML`RawXML["<!--#include virtual=\"/common/includes/m8/footer-industry.html\"-->"]],
	
	If[MemberQ[adList, base], 
					XML`RawXML["<!--#include virtual=\"/solutions/includes/dobbs."<>lang<>".html\"--><!--#include virtual=\"/common/includes/m8/footer-industry."<>lang<>".html\"-->"], 
					XML`RawXML["<!--#include virtual=\"/common/includes/m8/footer-industry."<>lang<>".html\"-->"]]
	];
	
	
					
		
	"footer"-> ExportString[MakeFooter[advertisementlist,fileBase,langExt],
		"XML", "AttributeQuoting"->"\"", "Entities"->{"\[LongDash]"->"&mdash;"}, "ElementFormatting"->All],
		
	(*"footer"->			
	ExportString[
			Switch[langExt,
				"ja", XML`RawXML["<!--#include virtual=\"/common/includes/m8/footer-industry.ja.html\"-->"],
				"zh", XML`RawXML["<!--#include virtual=\"/common/includes/m8/footer-industry.zh.html\"-->"],
				"es", XML`RawXML["<!--#include virtual=\"/common/includes/m8/footer-industry.es.html\"-->"],
				"ko", XML`RawXML["<!--#include virtual=\"/common/includes/m8/footer-industry.ko.html\"-->"],
				"pt", XML`RawXML["<!--#include virtual=\"/common/includes/m8/footer-industry.pt.html\"-->"],
				"ru", XML`RawXML["<!--#include virtual=\"/common/includes/m8/footer-industry.ru.html\"-->"],
				_, If[MemberQ[advertisementlist, fileBase], 
					XML`RawXML["<!--#include virtual=\"/solutions/includes/dobbs.html\"--><!--#include virtual=\"/common/includes/m8/footer-industry.html\"-->"], 
					XML`RawXML["<!--#include virtual=\"/common/includes/m8/footer-industry.html\"-->"]]
			],
		"XML", "AttributeQuoting"->"\"", "Entities"->{"\[LongDash]"->"&mdash;"}, "ElementFormatting"->All],*)
		
    "body"->
       ExportString[
       	 DIV[{"class"->"wrapper", Switch[langExt,
       	 	"en","id"->"en",
       	 	"es","id"->"es",
       	    "zh","id"->"zh",
       	    "ko","id"->"ko",
       	    "pt","id"->"pt",
       	    "ru","id"->"ru",
       	 	_,"id"->"ja"]}, {

DIV[{"class"->"other otherSol"},{
DIV[{"class"->"otherPadding"},{
XML`RawXML["<div class=\"otherTitle\">"],
Transmogrify[Localized["Other Mathematica Solutions", solutionsLang]],
XML`RawXML["&nbsp;<span class=\"chevron\">&raquo;</span></div>"],
Transmogrify[seeAlsoSection]
}], 

(* Still need to add link around the text of this one *)
XML`RawXML["<div class=\"otherBlue\"><a href=\"/solutions/\">"],
Transmogrify[Localized["Other Mathematica Solutions", solutionsLang]],
XML`RawXML["&nbsp;<span class=\"chevron\">&raquo;</span></a></div>"]
}],
Transmogrify[label], 


If[fileBase==="ControlSystems", XMLElement["img", 
	(*Which[langExt==="ja", "/solutions/images/solutions/NewIn8Banner.ja.png",
			langExt==="zh", "/solutions/images/solutions/NewIn8Banner.zh.png",
			langExt==="es", "/solutions/images/solutions/NewIn8Banner.es.png",
			True, "/solutions/images/solutions/NewIn8Banner.png"]*)
		{"src"->"/solutions/images/solutions/NewIn8Banner."<>langExt<>".png",
		"alt"->"New In Eight", "title"->"New In Eight", "class"->"NewInEightTopBanner"}, {}], {}],
		
Transmogrify[title], 

	DIV[{"class"->"headerContainer"}, {
		XML`RawXML["<div class=\"headerbluetopbar\"></div>"],
	    DIV[{"class"->"headerTextCont"}, {
	    	DIV[{"class"->"headerText"}, {
	    	Transmogrify[abstract]
	    	}]
	    	}],
	    	
(*.rollOver {
float: left;
width:503px;
height:280px;
margin:0 0 0 0;
position:relative;
background-color:#fff;
}*)

	   If[MemberQ[extendRolloverWindowList, fileBase],
	     DIV[{"class"->"rollover", "style"->"height:295px;"}, {
	    	XML`RawXML["<div id=\"sel\"></div>"], 
	    	Transmogrify[abstractSection]
		 }],
		 DIV[{"class"->"rollover"}, {
	    	XML`RawXML["<div id=\"sel\"></div>"], 
	    	Transmogrify[abstractSection]
		 }]
		 ]
	    	
	    	
	    (*DIV[{"class"->"rollover"}, {
	    	XML`RawXML["<div id=\"sel\"></div>"], 
	    	Transmogrify[abstractSection]
		 }]*)
		
		}],
		
		DIV[{"class"->"leftcol"}, {
			DIV[{"class"->"toggleTabs1"}, {
				XMLElement["div", {"class"->"capability1"}, {Localized["KEY CAPABILITIES", solutionsLang]}],
				XMLElement["div", {"class"->"choose2"}, {Transmogrify@Localized["WHY CHOOSE MATHEMATICA", solutionsLang]} ],
				XMLElement["div", {"class"->"use2"}, {Localized["WAYS TO USE", solutionsLang]} ],
				DIV[{"class"->"podWrapper", "style"->"clear:both;"}, {	
				DIV[{"class"->"podbackground"}, {
				DIV[{"class"->"tabInfoCont"}, {	
				
				UL[{"class"->"graydot"}, {Transmogrify[featurecol1]}],
				UL[{"class"->"graydot"}, {If[featureBox=!={},  
					XMLElement["li", {"class"->"nobullet"}, {
						XMLElement["div", {"class"->"blueBox"}, {
							Transmogrify[featureBox]
							}]
						}], ""
					],
					Transmogrify[featurecol2], 
					XML`RawXML["<li class=\"nobullet why\">"],
					Transmogrify@Localized["Next:", solutionsLang],
						XML`RawXML["<div class=\"button\">"],
						XML`RawXML["<span class=\"whitebuttonLeft\"><!-- --></span>"],
						(*XML`RawXML["<span class=\"whitebuttonRight\">Why Choose <em>Mathematica</em></span>"],*)
						XML`RawXML["<span class=\"whitebuttonRight\">"],
						Transmogrify@Localized["Next: Why Choose Mathematica", solutionsLang],
						XML`RawXML["</span>"],
						XML`RawXML["<div class=\"clearingFloats\"></div>"],
						XML`RawXML["</div>"],
						XML`RawXML["</li>"]			
							
					}]

				}] (* end tabInfoCont *)
				}], (* end podbackground *)
				DIV[{}, {XMLElement["img", {"src"->"/solutions/images/solutions/bottombar.gif"(*, "alt"->"", "title"->""*)}, {}]}]
				}] (* end podWrapper *)
				}], (* end ToggleTabs1 *)
				
				DIV[{"class"->"toggleTabs2"}, {
				XMLElement["div", {"class"->"capability2"},  {Localized["KEY CAPABILITIES", solutionsLang]}],
				XMLElement["div", {"class"->"choose1"}, {Transmogrify@Localized["WHY CHOOSE MATHEMATICA", solutionsLang]} ],
				XMLElement["div", {"class"->"use2"}, {Localized["WAYS TO USE", solutionsLang]} ],
				DIV[{"class"->"podWrapper", "style"->"clear:both;"}, {	
				DIV[{"class"->"podbackground"}, {
				DIV[{"class"->"tabInfoCont"}, {
					UL[{"class"->"graydot"}, {Transmogrify[whyChooseCol1]}],
					UL[{"class"->"graydot"}, {Transmogrify[whyChooseCol2], 
						
						XML`RawXML["<li class=\"nobullet ways\">"],
						Transmogrify@Localized["Next:", solutionsLang],
						XML`RawXML["<div class=\"button\">"],
						XML`RawXML["<span class=\"whitebuttonLeft\"><!-- --></span>"],
						(*XML`RawXML["<span class=\"whitebuttonRight\">Ways to Use</span>"],*)
						XML`RawXML["<span class=\"whitebuttonRight\">"],
						Transmogrify@Localized["Next: Ways to Use", solutionsLang],
						XML`RawXML["</span>"],
						XML`RawXML["<div class=\"clearingFloats\"></div>"],
						XML`RawXML["</div>"],
						XML`RawXML["</li>"]
	
					}]
				}] (* end tabInfoCont *)
				}], (* end podbackground *)
				DIV[{}, {XMLElement["img", {"src"->"/solutions/images/solutions/bottombar.gif"(*, "alt"->"", "title"->""*)}, {}]}]
				}] (* end podWrapper *)
				
				}], (* end ToggleTabs2 *)
				
				DIV[{"class"->"toggleTabs3"}, {
				XMLElement["div", {"class"->"capability2"}, {Localized["KEY CAPABILITIES", solutionsLang]}],
				XMLElement["div", {"class"->"choose2"}, {Transmogrify@Localized["WHY CHOOSE MATHEMATICA", solutionsLang]} ],
				XMLElement["div", {"class"->"use1"}, {Localized["WAYS TO USE", solutionsLang]} ],
				DIV[{"class"->"podWrapper", "style"->"clear:both;"}, {	
				DIV[{"class"->"podbackground"}, {
				DIV[{"class"->"tabInfoCont"}, {
					UL[{"class"->"graydot"}, {Transmogrify[waysToUseCol1]}],
					UL[{"class"->"graydot"}, {Transmogrify[waysToUseCol2], 
						
						
						XML`RawXML["<li class=\"nobullet key\">"],
						Transmogrify@Localized["Next:", solutionsLang],
						XML`RawXML["<div class=\"button\">"],
						XML`RawXML["<span class=\"whitebuttonLeft\"><!-- --></span>"],
						(*XML`RawXML["<span class=\"whitebuttonRight\">Key Capabilities</span>"],*)
						XML`RawXML["<span class=\"whitebuttonRight\">"],
						Transmogrify@Localized["Next: Key Capabilities", solutionsLang],
						XML`RawXML["</span>"],
						XML`RawXML["<div class=\"clearingFloats\"></div>"],
						XML`RawXML["</div>"],
						XML`RawXML["</li>"]	
	
					}]
				}] (* end tabInfoCont *)	
				}], (* end podbackground *)
				DIV[{}, {XMLElement["img", {"src"->"/solutions/images/solutions/bottombar.gif"(*, "alt"->"", "title"->""*)}, {}]}]
				}] (* end podWrapper *)
				
				}],  (* end toggleTabs3 *)
				
				Map[MakeSolutionsOpenCloseSection[GetGroupByCellTag[nbExpression, #]]&, pageLeftColumn]

			}], (* end leftcol *)	
			
			createRightColumn[nbExpr_, rcSections_List]:=
				Map[MakeRightColumnSection[nbExpr, #] &, rcSections];
				
				
			setActionIcon[name_String]:=Module[{category, WhitePaperWorkbench, OnlineImageProcessing, OnlineStatisticsAndData, TechnicalDemo, 
				OnlineWebMOverview, InfoKitMedicalImaging, InfoKitClinicalTrials, InfoKitElevationMapping, InfoKitRandD, InfoKitReliability, 
				AerospaceInfoKit, InfoKitRandDEnvironment},
				TechnicalDemo={"OperationsResearch", "ElectronicPublishing", "InterfaceDevelopment", "VisualArts", "Econometrics", "Economics", 
					"FinancialEngineeringAndMathematics", "FinancialRiskManagement"};
				OnlineStatisticsAndData={"ActuarialSciences", "DataMining", "Statistics"};
				OnlineWebMOverview={"WebDevelopment"};
				OnlineImageProcessing={"ImageProcessing"};
				WhitePaperWorkbench={"SoftwareEngineering"};
				InfoKitMedicalImaging={"MedicalImaging"};
				InfoKitClinicalTrials={"BiologicalSciences"};
				InfoKitElevationMapping={"Geosciences"};
				InfoKitRandD={"ChemicalEngineering", "ElectricalEngineering", "IndustrialEngineering", "MaterialsScience", "Optics", 
"PetroleumEngineering", "Bioinformatics", "Chemistry", (*"EnvironmentalSciences",*) "SocialSciences"};
				InfoKitRandDEnvironment={"EnvironmentalSciences"};

				InfoKitReliability={"MechanicalAndStructuralEngineering"};
				AerospaceInfoKit={"AerospaceEngineering"};
			
				category=Which[
					MemberQ[TechnicalDemo, name], "TechnicalDemo",
					MemberQ[OnlineStatisticsAndData, name], "OnlineStatisticsAndData",
					MemberQ[OnlineWebMOverview, name], "OnlineWebMOverview",
					MemberQ[OnlineImageProcessing, name], "OnlineImageProcessing",
					MemberQ[WhitePaperWorkbench, name], "WhitePaperWorkbench",
					MemberQ[InfoKitMedicalImaging, name], "InfoKitMedicalImaging",
					MemberQ[InfoKitClinicalTrials, name], "InfoKitClinicalTrials",
					MemberQ[InfoKitElevationMapping, name], "InfoKitElevationMapping",
					MemberQ[InfoKitRandD, name], "InfoKitRandD",
					MemberQ[InfoKitRandDEnvironment, name], "InfoKitRandDEnvironment",
					MemberQ[InfoKitReliability, name], "InfoKitReliability",
					MemberQ[AerospaceInfoKit, name], "AerospaceInfoKit",
					True, "TechnicalDemo"];
				Switch[
				category,
				"TechnicalDemo", {"TechnicalDemo", "CalltoAction_Icon.png"},
				"OnlineStatisticsAndData", {"OnlineStatisticsAndData", "CalltoAction_Icon_OnlineDemo.png"},
				"OnlineWebMOverview", {"OnlineWebMOverview", "CalltoAction_Icon_OnlineDemo.png"},
				"OnlineImageProcessing", {"OnlineImageProcessing", "CalltoAction_Icon_OnlineDemo.png"},
				"WhitePaperWorkbench", {"WhitePaperWorkbench", "CalltoAction_Icon_WhitePaper.png"},
				"InfoKitMedicalImaging", {"InfoKitMedicalImaging", "CalltoAction_Icon_InformationKit.png"},
				"InfoKitClinicalTrials", {"InfoKitClinicalTrials", "CalltoAction_Icon_InformationKit.png"},
				"InfoKitElevationMapping", {"InfoKitElevationMapping", "CalltoAction_Icon_InformationKit.png"},
				"InfoKitRandD", {"InfoKitRandD", "CalltoAction_Icon_InformationKit.png"},
				"InfoKitRandDEnvironment", {"InfoKitRandDEnvironment", "CalltoAction_Icon_InformationKit.png"},
				"InfoKitReliability", {"InfoKitReliability", "CalltoAction_Icon_InformationKit.png"},
				"AerospaceInfoKit", {"AerospaceInfoKit", "CalltoAction_Icon_InformationKit.png"},
				_, {"TechnicalDemo", "CalltoAction_Icon.png"}
				]
			];

			actionHead = setActionIcon[fileBase][[1]]<>"Head";
			actionText = setActionIcon[fileBase][[1]]<>"Text";
			actionButton = setActionIcon[fileBase][[1]]<>"Button"; Print@actionButton;
			(*actionButtonIcon = setActionIcon[fileBase][[2]];*)
			actionButtonIcon = StringReplace[Last@Drop[StringSplit[setActionIcon[fileBase][[2]], {"_", "."}], -1], "Icon"->""];
			actionIcon = Extract[StringSplit[actionButtonIcon, {".","_"}], -2];
			actionIconWidth = Switch[actionIcon,
			"OnlineDemo","60",
			"WhitePaper","60",
			"InformationKit","60",
			"Icon","51"
			];
			actionIconHeight = Switch[actionIcon,
			"OnlineDemo","43",
			"WhitePaper","48",
			"InformationKit","48",
			"Icon","60"
			];
			
			DIV[{"class"->"rightcol"}, {
				XMLElement["p", {"class"->"actionspace"}, {
				XMLElement["div", {"class"->"actioncontainerX"}, {
				XMLElement["div", {"class"->"profileActionContainer"<>actionButtonIcon}, {
					
				(*XMLElement["img", {"class"->"actionIcon", "src"->"/solutions/images/"<>actionButtonIcon, "width"->actionIconWidth, "height"->actionIconHeight}, {}],*)
				(*XMLElement["div", {"style"->"text-align:left; margin-left:62px"}, {*)
				XMLElement["div", {"style"->"text-align:left; margin-left:76px;"}, {
					XML`RawXML["<h3>"],
					Localized[actionHead, solutionsLang],
			
				XML`RawXML["</h3>"],

				XMLElement["div", {"class"->"captionText"}, {Transmogrify@Localized[actionText, solutionsLang]}],	
						XML`RawXML["<div class=\"button\">"],
						XML`RawXML["<span class=\"buttonLeft\"><!-- --></span>"],
						XML`RawXML["<span class=\"buttonRight\">"],
						Localized[actionButton, solutionsLang],
						XML`RawXML["</span>"],
						XML`RawXML["</div>"]	
				}]	
				}]	
			}]
			}],
			If[MemberQ[applianceList, fileBase], 
			{createRightColumn[nbExpression,pageRightColumn],
				Switch[langExt,
				"ja", XML`RawXML["<!--#include virtual=\"/solutions/includes/wa-appliance.ja.html\"-->"],
				"zh", XML`RawXML["<!--#include virtual=\"/solutions/includes/wa-appliance.zh.html\"-->"],
				"es", XML`RawXML["<!--#include virtual=\"/solutions/includes/wa-appliance.es.html\"-->"],
				"ko", XML`RawXML["<!--#include virtual=\"/solutions/includewa-appliancen.ko.html\"-->"],
				"pt", XML`RawXML["<!--#include virtual=\"/solutions/includes/wa-appliance.pt.html\"-->"],
				"ru", XML`RawXML["<!--#include virtual=\"/solutions/includes/wa-appliance.ru.html\"-->"],
				_, XML`RawXML["<!--#include virtual=\"/solutions/includes/wa-appliance.html\"-->"]
				]}, 
			createRightColumn[nbExpression,pageRightColumn]]
			
			,
			
			Switch[langExt,
				"ja", XML`RawXML["<!--#include virtual=\"/solutions/includes/newsletterlink.ja.html\"-->"],
				"zh", XML`RawXML["<!--#include virtual=\"/solutions/includes/newsletterlink.zh.html\"-->"],
				"es", XML`RawXML["<!--#include virtual=\"/solutions/includes/newsletterlink.es.html\"-->"],
				"ko", XML`RawXML["<!--#include virtual=\"/solutions/includes/newsletterlink.ko.html\"-->"],
				"pt", XML`RawXML["<!--#include virtual=\"/solutions/includes/newsletterlink.pt.html\"-->"],
				"ru", XML`RawXML["<!--#include virtual=\"/solutions/includes/newsletterlink.ru.html\"-->"],
				_, XML`RawXML["<!--#include virtual=\"/solutions/includes/newsletterlink.en.html\"-->"]
			]
			(*,
			XMLElement["div", {"id"->"newsletters"}, {
			XMLElement["table",{"border"->"0", "cellpadding"->"0", "cellspacing"->"0"},{
				XMLElement["tr",{},{
					XMLElement["td",{},{
						XMLElement["img",{"src"->"/mathematica/images/signupIcon.png"},{}]
						}],
					XMLElement["td",{},{
						XMLElement["h3",{},{"Free newsletters"}],
						XMLElement["div",{"class"->"captionText"},{
							XML`RawXML["<a href=\"/news/newsletter/\">"],
								XML`RawXML["Sign up for useful news, resources, <br>and advice&nbsp;<span class=\"chevron\">&raquo;</span>"],
							XML`RawXML["</a>"]
							}]
						}]
					}]
				}]
			}]*)


    (*
       <a href="">/a>
    *)


			(*XMLElement["div",{},{"Hello"}]*)
				}]
				
			(*DIV[{"class"->"rightcol"}, {
				XMLElement["p", {"class"->"actionspace"}, {
				XMLElement["div", {"class"->"actioncontainer"}, {
				XMLElement["div", {"class"->"profileContainer"}, {
					
				XMLElement["img", {"class"->"actionIcon", "src"->"/solutions/images/"<>actionButtonIcon, "width"->actionIconWidth, "height"->actionIconHeight}, {}],
				XMLElement["div", {"style"->"text-align:left"}, {
					XML`RawXML["<h3>"],
					Localized[actionHead, solutionsLang],
			
				XML`RawXML["</h3>"],

				XMLElement["div", {"class"->"captionText"}, {Transmogrify@Localized[actionText, solutionsLang]}],	
						XML`RawXML["<div class=\"button\">"],
						XML`RawXML["<span class=\"buttonLeft\"><!-- --></span>"],
						XML`RawXML["<span class=\"buttonRight\">"],
						Localized[actionButton, solutionsLang],
						XML`RawXML["</span>"],
						XML`RawXML["</div>"]	
				}]	
				}]	
			}]
			}],
			
			createRightColumn[nbExpression,pageRightColumn]
				}]*)

       	 	}], "XML",
          "AttributeQuoting"->"\"", "Entities"->{"\[LongDash]"->"&mdash;"}, "ElementFormatting"->None]
  ]

],



(* Abstract and o styles *)

{Cell, "SolutionsLabel"}:>Module[{forcedLabel},
forcedLabel=If[HasOption[CellLabel], GetOption[CellLabel], ""];
If[forcedLabel==="ForcedSolutionsLabel",
		XMLElement["h1", {"class"->"aboveheader"}, {Recurse[]}],
	If[MemberQ[{"Japanese","ChineseSimplified"},solutionsLang], 
		XMLElement["h1", {"class"->"aboveheader"}, {Recurse[], Localized["Industry Solutions for ", solutionsLang] }]   , 
		XMLElement["h1", {"class"->"aboveheader"}, {Localized["Industry Solutions for ", solutionsLang], Recurse[] }] 
		]  
	]
],

{Cell, "SolutionsTitle"}:>XMLElement["div", {"class"->"pageGroup"}, { XMLElement["h1", {}, {Recurse[] } ]   }],
{Cell, "SolutionsAbstract"|"SolutionsAbstractSpaced"}:> XMLElement["div", {"class"->"headerParagraph"}, {Recurse[] }],
{Cell, "SolutionsAbstractCaption"}:>DIV[{"class"->"SolutionsAbstractCaption"}, {Recurse[] } ],
{Cell, "SolutionsAbstractCaptionHead"}:>DIV[{"class"->"SolutionsAbstractCaptionHead"}, {Recurse[] } ],
(* end abstract styles *)
	

(* Features section *)
{Cell, "SolutionsSection"}:>XMLElement["div", {"class"->"titleImage"}, {Recurse[] } ],
{Cell, "SolutionsSubsubsection"}:>XMLElement["div", {"class"->"SolutionsSubsubsection"}, {Recurse[] } ],
{Cell, "SolutionsFeatureListing"}:> WithParameters[{"newline2br"->True}, XMLElement["li", {}, {Recurse[]} ]],
{Cell, "SolutionsFeatureListingNoBL"}:> XMLElement["li", {"class"->"nobullet"}, { P[{}, {Recurse[]}]} ],
{StyleBox, "blueBoxTitle2"}:> XMLElement["span", {"class"->"blueBoxTitle2"}, {Recurse[]} ],
{StyleBox, "blueText"}:> XMLElement["span", {"class"->"blueText"}, {Recurse[]} ],
{StyleBox, "InlineFormulaListItem"}:> XMLElement["tt", {}, {Recurse[]	} ],
{StyleBox, "chevron"}:> XMLElement["span", {"class"->"chevron"}, {XML`RawXML["&nbsp;"], Recurse[]} ],
{StyleBox, "chevron2"}:> XMLElement["span", {"class"->"chevron"}, {Recurse[]} ],
(*{StyleBox, "NewInEight"}:> XMLElement["span", {"class"->"inlineImage"}, {
	XMLElement["img", {"src"->"/solutions/images/solutions/NewIn8.jpg", "alt"->"New In Eight", "title"->"New In Eight", "align"->"right", "style"->"border:none;"}, {}]
	} ],
{StyleBox, "Enhanced"}:> XMLElement["span", {"class"->"inlineImage", "align"->"right"}, {
	XMLElement["img", {"src"->"/solutions/images/solutions/EnhancedIn8.jpg", "alt"->"Enhanced In Eight", "title"->"Enhanced In Eight", "align"->"right", "style"->"border:none;"}, {}]
	} ],*)
{StyleBox, "NewInEight"}:> XMLElement["span", {"class"->"inlineImage"}, {
	XMLElement["img", {"src"->"/solutions/images/solutions/NewIn8Alt."<>langExt<>".png", "alt"->"New In Eight", "title"->"New In Eight", "align"->"right", "style"->"border:none;"}, {}]
	} ],
{StyleBox, "Enhanced"}:> XMLElement["span", {"class"->"inlineImage", "align"->"right"}, {
	XMLElement["img", {"src"->"/solutions/images/solutions/EnhancedAlt."<>langExt<>".png", "alt"->"Enhanced In Eight", "title"->"Enhanced In Eight", "align"->"right", "style"->"border:none;"}, {}]
	} ],


(*{StyleBox, "SeeAlsoPullDown"}:> XMLElement["a", {"href"->GetOption[CellTags]}, {Recurse[], 
	XML`RawXML["<br>"]} ],*)
{StyleBox, "SeeAlsoPullDown"}:> Recurse[],



{Cell, "blueBoxTitle"}:> XMLElement["div", {"class"->"blueBoxTitle"}, {Recurse[]} ],
{Cell, "blueBoxItem"}:> WithParameters[{"newline2br"->True}, XMLElement["div", {"class"->"blueBoxItem"}, {Recurse[]} ] ],
{Cell, "ULtitle"}:> XMLElement["div", {"class"->"ULtitle"}, {Recurse[]} ],
(* End features section *)


(* Sidebar section *)
{Cell, "SolutionsAbstractGraphicsCaption"} :> Module[{capCount,displayState},
	capCount=IncrementCounter["caption"];
	displayState=If[capCount==="1","box","none"];
	XMLElement["div", {"class"->"slideshowTitle","style"->"display: "<>displayState<>";", "id"->"caption"<>capCount}, { Recurse[] }]
],
{Cell, "SolutionsAbstractCaptionText"} :> Module[{cap2Count,displayState},
	cap2Count=IncrementCounter["subcaption"];
	displayState=If[cap2Count==="1","box","none"];
	XMLElement["div", {"class"->"slideshowCaption","style"->"display: "<>displayState<>";","id"->"specialcaption"<>cap2Count}, { Recurse[] }]
],
{Cell, "smallpodTitle"} :> XMLElement["div", {"class"->"smallpodTitle"}, { Recurse[] }],
{Cell, "profileTitle"} :> XMLElement["div", {"class"->"profileTitle"}, { Recurse[] }],
{Cell, "exampleImage"} :> Module[{imgCount,altTag,rightColumnHrefcheck,rightColumnHref},
	imgCount=ToExpression[IncrementCounter["exampleImage"]];
	altTag=Which[
	altTitleList==="Authored in Mathematica", altTitleList,
	True, CaptalizeFirstLetterEntireString[ToLowerCase@StringTrim[ altTitleList ] ]
	];
	rightColumnHrefcheck=GetOption[CellTags];
	rightColumnHref=If[rightColumnHrefcheck===None,"",rightColumnHrefcheck];
	
	If[rightColumnHref==="",
	XMLElement["div", {"class"->"exampleImage"}, { 
    						(XMLElement["img", { "class" -> "showCaseImage", "src" -> ("URL" /. #), "border"->"0", "title" -> altTag, 
      						"alt" -> altTag  }, {}]&[
      						BoxToImage[ToFileName[{"images."<>langExt},"profile" <> IncrementCounter["showCaseImage"] <> ".gif"], "TransparentColor"->White]])
      						}],
      XMLElement["div", {"class"->"profileImage"}, { 
    					XMLElement["a", {"href"->rightColumnHref}, {
    						(XMLElement["img", { "class" -> "showCaseImage", "src" -> ("URL" /. #), "border"->"0",
      						"alt" -> altTag, "title" -> altTag }, {}]&[
      						BoxToImage[ToFileName[{"images."<>langExt},"profile" <> IncrementCounter["showCaseImage"] <> ".gif"], "TransparentColor"->White]])}]
    				 }]
			] (* end if *)
		],
{Cell, "profileImage"} :> Module[{rightColumnHrefcheck, rightColumnHref,imgCount,altTag},
	imgCount=ToExpression[IncrementCounter["profileImage"]];
	altTag=If[altTitleList==="The Wolfram Blog", blogAltTitle, StringTrim[ altTitleList[[imgCount]] ]
	];
	rightColumnHrefcheck=GetOption[CellTags];
	rightColumnHref=If[rightColumnHrefcheck===None,"",rightColumnHrefcheck];
    				XMLElement["div", {"class"->"profileImage"}, { 
    					XMLElement["a", {"href"->rightColumnHref}, {
    						(XMLElement["img", { "class" -> "showCaseImage", "src" -> ("URL" /. #), "border"->"0", 
      						"alt" -> altTag, "title" -> altTag }, {}]&[
      						BoxToImage[ToFileName[{"images."<>langExt},"profile" <> IncrementCounter["showCaseImage"] <> ".gif"], "TransparentColor"->White]])}]
    				 }]
],

{Cell, "profileImagePopup"} :> Module[{rightColumnHrefcheck, rightColumnHref, rightColumnJS},
	rightColumnHrefcheck=GetOption[CellTags];
	rightColumnHref=rightColumnHrefcheck[[2]];
	rightColumnJS=rightColumnHrefcheck[[3]];
    				XMLElement["div", {"class"->"profileImage"}, { 
    					XMLElement["a", {"href"->rightColumnHref, 
    						"onclick"->rightColumnJS}, {
    						(XMLElement["img", { "class" -> "showCaseImage", "src" -> ("URL" /. #), "border"->"0"}, {}]&[
      						BoxToImage[ToFileName[{"images."<>langExt},"profile" <> IncrementCounter["showCaseImage"] <> ".gif"], "TransparentColor"->White]])}]
    				 }]
],

{Cell, "profileAuthor"} :> XMLElement["div", {"class"->"profileAuthor"}, { Recurse[] }],
{Cell, "profileAuthorTitle"} :> XMLElement["div", {"class"->"profileAuthorTitle"}, { Recurse[] }],
{Cell, "profileCaption"} :> XMLElement["div", {"class"->"profileCaption"}, { Recurse[] }],
{Cell, "profileText"} :> XMLElement["div", {"class"->"profileText"}, { Recurse[] }],
{Cell, "demonstrationsText"} :> XMLElement["div", {"class"->"demonstrationsText"}, { Recurse[] }],
(* End sidebar section *)

(* Images  section *)
{Cell, "showCaseImage"}:> Module[{theimage, imagename(*, graphics*)},
	imagename = ToFileName[{"images."<>langExt},"showcase" <> IncrementCounter["showCaseImage"] <> ".png"];
	theimage=Export[imagename, Rasterize[SelectSelf[], Background->None]];
	XMLElement["img", { "class" -> "showCaseImage", "src" -> StringReplace[imagename, "\\"->"/"](*, 
      "alt" -> " "*)  }, {}]  
      ],
     
{Cell, "showCaseImageGettingStarted"}:> 
	XMLElement["img", { "class" -> "showCaseImage", "src" -> "/solutions/images/solutions/getStartedImage.gif"(*, 
      "alt" -> "" *) }, {}],
      
{Cell, "SolutionsAbstractImage"}:> Module[{imgCount, displayState},
    	imgCount=IncrementCounter["Inline"];
    	displayState=If[imgCount==="1","box","none"];
    	(XMLElement["img", {"id"->"img"<>imgCount, "style"->"display: "<>displayState<>";", "src" -> ("URL" /. #)}, {}]&[
      BoxToImage[ToFileName[{"images."<>langExt},"rollover" <> imgCount <> ".gif"]
      ]])
    ],
	
{Cell, "SolutionsImageShifted"}:>Module[{data},
	 (data=GetOption[CellTags];
XMLElement["img", { "class" -> "blueBoxImage", "src" -> ("URL" /. #), 
      "alt" -> data, "title" -> data}, {}]&[
      BoxToImage[ToFileName[{"images."<>langExt},"feature_img" <> IncrementCounter["Feature"] <> ".gif"]
      ]])
], 
    


{Cell, "SolutionsImageShiftedInline"}:>Module[{label,theimage, imagename, cell},
	
	imagename = ToFileName[{"images."<>langExt},"feature_img" <> IncrementCounter["Feature"] <> ".gif"];
	cell= DeleteCases[SelectSelf[], Rule[CellLabel,_], Infinity];
	theimage=Export[imagename, Rasterize[SelectSelf[], Background->None]];
	
	label=GetOption[CellLabel];
	If[label==="NewInEight",
		XMLElement["li", {"class"->"nobullet"}, {
	XMLElement["div", {"class"->"ImposeGraphicLabel"}, {
	XMLElement["div", {"class"->"ImposeGraphicLabelInner"}, {
	XMLElement["img", {"src"->"/solutions/images/solutions/NewIn8Alt.png", 
		"alt"->"New In Eight", "title"->"New In Eight",  
		"style"->"border:none;"}, {}]
		}],
	
	
	XMLElement["img", { "class" -> "NewEightImage", "src" -> StringReplace[imagename, "\\"->"/"], 
      "alt" -> "Image"  }, {}]
	
      }]
      } ], 
	
	XMLElement["li", {"class"->"nobullet"}, {
	(XMLElement["img", {"src" -> ("URL" /. #)(*, 
      "alt" -> " "*)  }, {}]&[
      BoxToImage[ToFileName[{"images."<>langExt},"feature_img" <> IncrementCounter["Feature"] <> ".gif"]
      ]])} ]]
],
      
 {Cell, "SolutionsImageShiftedInline2"}:>Module[{data,data2},
	data=GetOption[CellTags];
	data2=If[Head[data[[2]]]===String,
		StringReplace[data[[2]], "\[RightGuillemet]"->""],
		data];
	Which[data===None,
		XMLElement["li", {"class"->"keyCapImage"}, {
	(XMLElement["img", {"src" -> ("URL" /. #)(*, 
      "alt" -> " "*)  }, {}]&[
      BoxToImage[ToFileName[{"images."<>langExt},"feature_img" <> IncrementCounter["Feature"] <> ".gif"]
      ]])} ],
      
     MatchQ[data,{"",_String}],
      XMLElement["li", {"class"->"keyCapImage"}, {(XMLElement["img", {"src" -> ("URL" /. #), 
      "alt" -> data2, "title" -> data2, "border"->"0"}, {}]&[
      BoxToImage[ToFileName[{"images."<>langExt},"feature_img" <> IncrementCounter["Feature"] <> ".gif"]
      ]])
     } ],
     
     True, 
      XMLElement["li", {"class"->"keyCapImage"}, {
      	A[{"href"->data[[1]]}, {
	(XMLElement["img", {"src" -> ("URL" /. #), 
      "alt" -> data2, "title" -> data2, "border"->"0"}, {}]&[
      BoxToImage[ToFileName[{"images."<>langExt},"feature_img" <> IncrementCounter["Feature"] <> ".gif"]
      ]])
      	}]     } ]
	]
  ],
      
    
(* Generic lists *)
{Cell, "SolutionsText"}:>WithParameters[{"newline2br" -> True},
	Module[{featureCount},
	featureCount=IncrementCounter["SolutionsText"];
	If[featureCount==="1",
		XMLElement["li", {"class"->"nobullet"}, {XML`RawXML["<p>"],Recurse[],XML`RawXML["</p>"] } ],
		XMLElement["li", {"class"->"nobullet"}, {Recurse[] } ]
		]
]
],
{Cell, "exampleTitle"}:>WithParameters[{"newline2br" -> True},
						XMLElement["li", {"class"->"exampleTitle"}, {Recurse[] } ]
								],
{Cell, "BulletedText"}:> WithParameters[{"newline2br" -> True},
	If[GetOption[FontSlant]==="Italic", 
	XMLElement["li", {}, {
		XMLElement["i",{}, {Recurse[] }]
		} ], 
	XMLElement["li", {}, {Recurse[]} ]]
],

{Cell, "SolutionsMoreLinkFeature"}:>Recurse[],

{FormBox}:>Block[{traditionalFormQ},
	traditionalFormQ = If[GetStyle[] === TraditionalForm, True, False];
Recurse[]
]


}, 

IncludeXMLTransforms -> {{"HTML","Components","Includes.m"}},
DefaultParameters -> { "newline2br" -> False, "newline2div" -> False}

]
