(* :Title: Functions.m *)

(* :Author:
  Andrew Hunt, andy@wolfram.com
  Greg Martel, gregm@wolfram.com
*)

(* :Mathematica Version: 5 *)
(* :Package Version: $Revision: 1.5.2.1 $ $Date: 2016/08/16 20:56:46 $ *)                  
(* :Copyright: (c) 2005, Wolfram Research, Inc. All rights reserved. *)
(* :Summary: Add-ons specific rules and general transform for Mathematica Documentation *)

(* :Title: Functions.m *)

XMLTransform[{

(* Remove in-product decorations *)

{Cell, "NotebookImage"} :> 
DIV[{"class"->"NotebookImage"}, {
  transmogrifyImage[ToFileName[{"Files", GetFileNameBase[]},
   IncrementCounter["Image"] <> ".gif"], {"alt"->"", "title"->""},
   Inline -> True
  ]
}],
(*{Cell, "NotebookImage"} :> 
Span[{"class"->"NotebookImage"}, {
  transmogrifyImage[ToFileName[{"Files", GetFileNameBase[]},
   IncrementCounter["Image"] <> ".gif"],
   Inline -> True
  ]
}],*)

{Cell, "PackageHeader"} :> Unevaluated[Sequence[]],

{Cell, "ObjectNameGrid"} :>  Block[{objgrid = True}, Recurse[] ],
  

{Cell, "ObjectName" | "ObjectNameSmall" | "ObjectNameAlt"} :> 
 XMLElement["h1", {}, {Recurse[]}],
 
 
{Cell, "IndicatorUsage"} :> XMLElement["div", {"class"->"indicatorIntroWrap"}, {XMLElement["div", {"class"->"indicatorIntro"}, {Recurse[]}]}],
 
 {CellGroupData, "IndicatorUsage"} :>  {Transmogrify[First[SelectChildren[]]],
	XMLElement["ul", {"class"->"functionList afterIntro"}, {Transmogrify[Rest[SelectChildren[]]]}]},  

{Cell, "IndicatorUsage"} :>  Module[{}, XMLElement["div", {"class"->"indicatorIntroWrap"}, 
	{XMLElement["div", {"class"->"indicatorIntro"}, {Recurse[]}]}]],
	
(* HowTo styles *)
{Cell, "HowToTitle"} :> H1[{}, {Recurse[]}],
{Cell, "HowToTitlePrefix"} :> {XMLElement["span", {}, {Recurse[]}], XMLElement["span", {"class"->"titleSep"}, {XML`RawXML["|"]}]},
{Cell, "HowToAbstract"} :> P[{"class" -> "intro"}, {Recurse[]}],
{Cell, "HowToScreencastLink"} :> Module[{iconText,iconSource,bdata,h="100px",w="100px"},
  bdata = First[Cases[SelectSelf[], (ButtonData->{URL[bbdd_], _}) :> bbdd, Infinity, 1]];
  XMLElement["div", {"class"->"embedWrap"}, {
      	XML`RawXML["<script language=\"JavaScript\" type=\"text/javascript\" src=\"/common/javascript/swfobject.js\" ></script>"],
      	XML`RawXML["<!--#include virtual=\"/common/includes/flash/vdbembed.cgi?v="<>StringReplace[StringCases[bdata,"video=" ~~ DigitCharacter ..], "video="->""]<>"&o=74&db=prd\"-->"],
      	 XMLElement["div", {"id"->"videoplayer"}, {XML`RawXML[""]}]
      	}]
],

{Cell, "DeviceSubtitle"} :> XMLElement["span", {"class"->"DeviceSubtitle"}, {Recurse[]}],
{Cell, "InterpreterSubtitle"} :> XMLElement["span", {"class"->"InterpreterSubtitle"}, {Recurse[]}],

{Cell, "ServiceSubtitle"} :> XMLElement["span", {"class"->"ServiceSubtitle"}, {Recurse[]}],

{Cell, "ScreencastPointerText"} :> P[{"class" -> GetStyle[]}, {Recurse[]}],
(* end howto styles *)
{Cell, "HowToText"} :> P[{"class" -> GetStyle[]}, {Recurse[]}],

{Cell, "HowToDelimiter"} :> XMLElement["div", {"class"->"HowToDelimiter"}, {Recurse[]}],

{Cell, "History"} :>  
If[MemberQ[exceptionsList, GetParameter["entityType"] ],
  DIV[{"class"->"modified"}, {Recurse[]}], 
  DIV[{"class"->"modified"}, {Recurse[]}]   
  ],
  
  
 {Cell, "AwaitingReviewNote"} :>  XMLElement["div", {"class"->"AwaitingReviewNote"}, {Recurse[]}],


{Cell, "CharacterImage"}:> 
Block[{CharacterImageData, CharacterImageDataLeft, CharacterImageDataRight},
CharacterImageData = SelectSelf[];
CharacterImageDataLeft={Transmogrify[Cell[BoxData[CharacterImageData[[1, 1, 1, 1, 1]]], "CharacterImageLeftSide"]]};
CharacterImageDataRight={Transmogrify[Cases[CharacterImageData[[1, 1, 1, 1, 2]], Cell[___, "CharacterNotes", ___], Infinity]]};
XMLElement["div", {"class"->"functionIntroWrap"}, {
	XMLElement["div", {"class"->"functionIntro"}, 
	{XMLElement["table", {}, {XMLElement["tr", {}, Flatten[{XMLElement["td", {"class"->"character-img"}, Flatten[{CharacterImageDataLeft}]], 
	XMLElement["td", {}, {XMLElement["ul", {"class"->"functionList afterIntro"}, Flatten[{CharacterImageDataRight}]]}]}]]}]}]}]
 ],   


{Cell, "CharacterImageLeftSide"}:> transmogrifyImage[ToFileName[{"Files", GetFileNameBase[]},
   "characterimage_"<>IncrementCounter["CharacterImage"] <> ".gif"], {"alt"->"", "title"->""},
   Inline -> True
  ],
  
{Cell, "CharacterNotes"}:> XMLElement["li", {}, {Recurse[]}],

{Cell, "CharacterName"}:> H1[{}, {Recurse[]} ],
 



{Cell, "1ColumnTableMod" | "2ColumnTable" | "3ColumnTable" | "2ColumnTableMod" | "3ColumnTableMod" | "3ColumnIllustratedTableMod"} :> Li[{"class"->"NotesTable"}, {Recurse[]}], 


{Cell,  "AlphabeticalListingTable"} :>
P[ {"class" -> "MathTable", "name" -> (GetStyle[]/.None->"FIXME")}, 
  {Recurse[]}
], 


(***** Cell Definitions *****)

{Cell, "Usage" | "DeviceDoubleUsage"} :> (
usageContent := XMLElement["div", {"class" -> "functionIntroWrap"},
Block[{usagegrid = True},
    Module[{xml = {Recurse[]}, pos, repl, first = True, versionNumber, modinfobackground,modinfoposition},
    modinfobackground=Cases[GetOption[GridBoxOptions], Rule["Rows", a__]:>a, Infinity];
    modinfobackground=Map[MemberQ[{#}, Dynamic[__]] &, Flatten[modinfobackground]];
    versionNumber = StringSplit[$Version, "."][[1]];
    pos = Position[xml, XMLElement["tr", _, _], Infinity];
    modinfoposition=Pick[pos, modinfobackground];
    repl = Map[
        Module[{tr, attr, children, modinfo},
            tr = Extract[xml, #];
            modinfo = False;
            modinfo = If[MemberQ[modinfoposition, #], True, False];
            attr = Join[
                DeleteCases[tr[[2]], _["name"|"id", _]],
                If[modinfo, {}(*{"name"->"ModInfo_"<>versionNumber, "id"->"ModInfo_"<>versionNumber}*), {}] ];
            If[first,
                first = False,
                attr = Join[
                    DeleteCases[attr, _["class", _]],
                    {}]];
            children = Map[
                Function[{td}, Module[{attr},
                    attr = td[[2]];
                    If[MatchQ[attr, {___, "class" -> _, ___}],
                        attr = ReplaceAll[attr, _["class", _] -> ("class" -> "UM")],
                        attr = Join[attr, {}]];
                    attr = Join[
                        DeleteCases[attr, _["name"|"id", _]],
                        If[modinfo, {"name"->"ModInfo_"<>versionNumber, "id"->"ModInfo_"<>versionNumber}, {}] ];
                    XMLElement["p", {}, td[[3]]]
                ]],
                Rest[tr[[3]]] ];
            XMLElement["div", {"class"->"functionIntro"<>If[modinfo, " modified-text", ""]}, children]
        ]&,
        pos];
        repl]]
];

usageContent
), 


{StyleBox, "GuideFunctionsSubsection"} :> Recurse[],

{Cell, "GuideAbstract"} :> 
Module[{flag = GetParameter["flag"]}, 
  If[flag =!= "RootGuidePage",
    WithParameters[{"newline2br" -> False, "newline2div" -> True, "styleUsageMessageBreak" -> "<span class='br'>&nbsp;</span>"},P[{"class"->"intro"}, {Recurse[]} ]],
    DIV[{},{}]
  ]
],

{Cell, "GuideFunctionsSubsection"} :> 
Module[{flag = GetParameter["flag"]},
  If[flag =!= "RootGuidePage",
    H3[If[HasOption[CellTags], 
		{"id"->StringReplace[ToString[Flatten[{GetOption[CellTags]}]], {"{"->"", "}"->""}]}, {}], {Recurse[]} ],
    DIV[{},{}]
  ]
],

{Cell, "GuideFunctionsSubsubsection"} :> 
Module[{flag = GetParameter["flag"]}, 
  If[flag =!= "RootGuidePage",
    H4[{}, {Recurse[]} ],
    DIV[{},{}]
  ]
],


{Cell, "GuideDelimiterSubsection"} :> 
Module[{flag = GetParameter["flag"]}, 
  If[flag =!= "RootGuidePage",
    XMLElement["div", {"class"->"GuideDelimiterSubsection"}, {XML`RawXML["<!-- -->"]} ],
    DIV[{},{}]
  ]
],

{Cell, "InlineGuideFunction"} :> 
Span[{"class"->"InlineGuideFunction"}, {Recurse[]} ],


{Cell, "InlineGuideFunctionListing"} :> 
Module[{ml},
  ml = Recurse[];
  If[(Length@{ml} === 1) && (Head@ml === String),
   ml = StringSplit[ml, RegularExpression["\\s+\\.\\s+"] ];
   ml = Span[{"class"->"InlineGuideFunction"}, 
          {XMLElement["span", {}, {#}] }]&/@ ml;
   ml = Riffle[ml,  
     Span[{"class" -> "inlineBullet"}, {XML`RawXML["&nbsp;"], XML`RawXML["&#9642;"], XML`RawXML["&nbsp;"]}]
     ] ];
  P[{"class"->"inlineFunctionList"}, Flatten@{ml}]
],

{Cell, "GuideText"} :> 
Module[{flag = GetParameter["flag"]},
  If[flag =!= "RootGuidePage",
    P[{"class"->"singleFunction"},  { Recurse[] }],
    Module[{guidelinks,guidelinksNew678,class="left"},
      guidelinks = Cases[SelectSelf[], _ButtonBox, Infinity];
      (*guidelinksNew678 = Insert[Take[guidelinks, {-3, -2, -1}], " | ", 2];*)
      guidelinksNew678 = Riffle[Take[guidelinks, {-3, -1}], " | "];
      guidelinks=Join[Drop[guidelinks, -3], {guidelinksNew678}];
	  guidelinks=If[EvenQ@Length@guidelinks === True, guidelinks, Append[guidelinks, {}]];
	  guidelinks = Partition[guidelinks, 2];
	  guidelinks = Transpose[guidelinks];
      guidelinks = Map[
        XMLElement["ul", {"class" -> (class="right";#)&[class]}, {Map[Li[{}, {Transmogrify[#]}]&, #]}]&,
        guidelinks];
      XMLElement["div",{
          "class" -> "accordion-content "<> GetCounter["RootSection"]
        }, {
        XMLElement["tr",{}, {
        TD[{"class"->"rootLinkCol"}, {guidelinks[[1]]}],
        TD[{"class"->"rootLinkCol"}, {DeleteCases[guidelinks[[2]], XMLElement["li",{__},{}], Infinity]}]
        }]
      }]
    ]
]],

{StyleBox, "InlineSeparator"} :>If[StringReplace[GetFileNameBase[], {".en"->"", ".ja"->""}]==="Mathematica",
Span[{"class" -> "inlineBullet"}, {XML`RawXML["&nbsp;"], XML`RawXML["&#9642;"], XML`RawXML["&nbsp;"]}],
Span[{"class" -> "inlineBullet"}, {XML`RawXML["&nbsp;"], XML`RawXML["&#9642;"], XML`RawXML["&nbsp;"]}]
],


{StyleBox, "LeadingBullet"} :>
Span[{"class" -> "LeadingBullet"}, {
    Img[{"src" -> htmlBase<>"/mathematicaImages/bullet.gif", "width"->"4", "height"->"4", "style"->"vertical-align:middle;", "alt"->"bullet", "title"->"bullet"}] }],

{Cell, "InlineListing"} :>
DIV[{"class" -> "InlineListing"}, {Recurse[] }],
{Cell, "InlineListing3Col"} :>
DIV[{"class" -> "InlineListing3Col"}, {Recurse[] }],
{Cell, "InlineListing4Col"} :>
DIV[{"class" -> "InlineListing4Col"}, {Recurse[] }],


{CellGroupData, "UsageSection" | 
	"LegacyMaterialSection" | 
	"ApplicationNotesSection" | 
	"ExtensionsSection" | 
	"DesignDiscussionSection"  | 
	"TutorialMoreAboutSection" | 
	"TutorialCollectionSection"} :> 
Recurse[],  

{Cell, "ServiceAbstract"} :> 
Module[{flag = GetParameter["flag"]}, 
  If[flag =!= "RootGuidePage",
    WithParameters[{"newline2br" -> False, "newline2div" -> True, "styleUsageMessageBreak" -> "<span class='br'>&nbsp;</span>"},P[{"class"->"intro"}, {Recurse[]} ]],
    DIV[{},{}]
  ]
],

{CellGroupData, "SeeAlsoSection"} :> XMLElement["div", {"class"->"expandWrap", "id"->"SeeAlso"},
	{XMLElement["div", {"class"->"expandOuter"},{
		XMLElement["h2", {"class"->"expandInner"}, {
			XMLElement["a", {"class"->"expand hide", "title"->Localized["show", GetParameter["language"]], "href"->"#"},{Localized["SeeAlsoSectionText", GetParameter["language"]]}], 
			XMLElement["a", {"class"->"collapse", "title"->Localized["hide", GetParameter["language"]], "href"->"#"},{Localized["SeeAlsoSectionText", GetParameter["language"]]}]}], 
			XMLElement["div",{"class"->"expanded"},{Recurse[]}]}]}], 


{CellGroupData, "TutorialsSection"} :> XMLElement["div", {"class"->"expandWrap", "id"->"Tutorials"},
	{XMLElement["div", {"class"->"expandOuter"},{
		XMLElement["h2", {"class"->"expandInner"}, {
			XMLElement["a", {"class"->"expand hide", "title"->Localized["show", GetParameter["language"]], "href"->"#"},{Localized["TutorialsSectionText", GetParameter["language"]]}], 
			XMLElement["a", {"class"->"collapse", "title"->Localized["hide", GetParameter["language"]], "href"->"#"},{Localized["TutorialsSectionText", GetParameter["language"]]}]}], 
			XMLElement["div",{"class"->"expanded"},{XMLElement["ul",{"class"->"functionList"},{Recurse[]}]}]}]}], 
			
{CellGroupData, "RelatedTutorialsSection"} :> XMLElement["div", {"class"->"expandWrap", "id"->"RelatedTutorials"},
	{XMLElement["div", {"class"->"expandOuter"},{
		XMLElement["h2", {"class"->"expandInner"}, {
			XMLElement["a", {"class"->"expand hide", "title"->Localized["show", GetParameter["language"]], "href"->"#"},{Localized["RelatedTutorialsSectionText", GetParameter["language"]]}], 
			XMLElement["a", {"class"->"collapse", "title"->Localized["hide", GetParameter["language"]], "href"->"#"},{Localized["RelatedTutorialsSectionText", GetParameter["language"]]}]}], 
			XMLElement["div",{"class"->"expanded"},{XMLElement["ul",{"class"->"functionList"},{Recurse[]}]}]}]}], 

{CellGroupData, "RelatedLinksSection" | "TutorialRelatedLinksSection"} :> XMLElement["div", {"class"->"expandWrap", "id"->"RelatedLinks"},
	{XMLElement["div", {"class"->"expandOuter"},{
		XMLElement["h2", {"class"->"expandInner"}, {
			XMLElement["a", {"class"->"expand hide", "title"->Localized["show", GetParameter["language"]], "href"->"#"},{Localized["RelatedLinksSectionText", GetParameter["language"]]}], 
			XMLElement["a", {"class"->"collapse", "title"->Localized["hide", GetParameter["language"]], "href"->"#"},{Localized["RelatedLinksSectionText", GetParameter["language"]]}]}], 
			XMLElement["div",{"class"->"expanded"},{XMLElement["ul",{"class"->"functionList"},{Recurse[]}]}]}]}],
			
{CellGroupData, "MoreAboutSection"} :> XMLElement["div", {"class"->"expandWrap", "id"->"RelatedGuides"},
	{XMLElement["div", {"class"->"expandOuter"},{
		XMLElement["h2", {"class"->"expandInner"}, {
			XMLElement["a", {"class"->"expand hide", "title"->Localized["show", GetParameter["language"]], "href"->"#"},{Localized["MoreAboutSectionText", GetParameter["language"]]}], 
			XMLElement["a", {"class"->"collapse", "title"->Localized["hide", GetParameter["language"]], "href"->"#"},{Localized["MoreAboutSectionText", GetParameter["language"]]}]}], 
			XMLElement["div",{"class"->"expanded"},{XMLElement["ul",{"class"->"functionList"},{Recurse[]}]}]}]}], 

{CellGroupData, "NotesSection" } :> Module[{nstitle}, nstitle = Flatten[{Transmogrify[First[SelectChildren[]]]}];
	XMLElement["div", {"class"->"expandWrap closed", "id"->"DetailsAndOptions"},
	{XMLElement["div", {"class"->"expandOuter"},{
		XMLElement["h2", {"class"->"expandInner"<>If[GetParameter["modifiednotesQ"]==="True", " modified-text", ""]}, {
			XMLElement["a", {"class"->"expand hide", "title"->Localized["show", GetParameter["language"]], "href"->"#"},nstitle], 
			XMLElement["a", {"class"->"collapse", "title"->Localized["hide", GetParameter["language"]], "href"->"#"},nstitle]}], 
			XMLElement["div",{"class"->"expanded"},{XMLElement["ul",{"class"->"functionList"}, Flatten[{Transmogrify[Rest[SelectChildren[]]]}]]}]}]}]],

{CellGroupData, "ImportExportSection" } :> XMLElement["div", {"class"->"expandWrap closed", "id"->"ImportAndExport"},
	{XMLElement["div", {"class"->"expandOuter"},{
		XMLElement["h2", {"class"->"expandInner"}, {
			XMLElement["a", {"class"->"expand hide", "title"->Localized["show", GetParameter["language"]], "href"->"#"},{Localized["ImportExportSectionText", GetParameter["language"]]}], 
			XMLElement["a", {"class"->"collapse", "title"->Localized["hide", GetParameter["language"]], "href"->"#"},{Localized["ImportExportSectionText", GetParameter["language"]]}]}], 
			XMLElement["div",{"class"->"expanded"},{XMLElement["ul",{"class"->"functionList"},{Recurse[]}]}]}]}],

{CellGroupData, "ElementsSection" } :> XMLElement["div", {"class"->"expandWrap", "id"->"Elements"},
	{XMLElement["div", {"class"->"expandOuter"},{
		XMLElement["h2", {"class"->"expandInner"}, {
			XMLElement["a", {"class"->"expand hide", "title"->Localized["show", GetParameter["language"]], "href"->"#"},{Localized["ElementsSectionText", GetParameter["language"]]}], 
			XMLElement["a", {"class"->"collapse", "title"->Localized["hide", GetParameter["language"]], "href"->"#"},{Localized["ElementsSectionText", GetParameter["language"]]}]}], 
			XMLElement["div",{"class"->"expanded"},{XMLElement["ul",{"class"->"functionList"},{Recurse[]}]}]}]}],

{CellGroupData, "OptionsSection" } :> XMLElement["div", {"class"->"expandWrap closed", "id"->"Options"},
	{XMLElement["div", {"class"->"expandOuter"},{
		XMLElement["h2", {"class"->"expandInner"}, {
			XMLElement["a", {"class"->"expand hide", "title"->Localized["show", GetParameter["language"]], "href"->"#"},{Localized["OptionsSectionText", GetParameter["language"]]}], 
			XMLElement["a", {"class"->"collapse", "title"->Localized["hide", GetParameter["language"]], "href"->"#"},{Localized["OptionsSectionText", GetParameter["language"]]}]}], 
			XMLElement["div",{"class"->"expanded"},{XMLElement["ul",{"class"->"functionList"},{Recurse[]}]}]}]}],
			
{CellGroupData, "NotebookInterfaceSection" } :> XMLElement["div", {"class"->"expandWrap closed", "id"->"NotebookInterface"},
	{XMLElement["div", {"class"->"expandOuter"},{
		XMLElement["h2", {"class"->"expandInner"}, {
			XMLElement["a", {"class"->"expand hide", "title"->Localized["show", GetParameter["language"]], "href"->"#"},{Localized["NotebookInterfaceSectionText", GetParameter["language"]]}], 
			XMLElement["a", {"class"->"collapse", "title"->Localized["hide", GetParameter["language"]], "href"->"#"},{Localized["NotebookInterfaceSectionText", GetParameter["language"]]}]}], 
			XMLElement["div",{"class"->"expanded"},{XMLElement["ul",{"class"->"functionList"},{Recurse[]}]}]}]}],

{CellGroupData, "DeviceSubsection" } :> Module[{dstitle}, dstitle = Flatten[{Transmogrify[First[First[SelectChildren[]]]]}];
	XMLElement["div", {"class"->"expandWrap", "id"->"Elements"},
	{XMLElement["div", {"class"->"expandOuter"},{
		XMLElement["h2", {"class"->"expandInner"}, {
			XMLElement["a", {"class"->"expand hide", "title"->Localized["show", GetParameter["language"]], "href"->"#"},dstitle], 
			XMLElement["a", {"class"->"collapse", "title"->Localized["hide", GetParameter["language"]], "href"->"#"},dstitle]}], 
			XMLElement["div",{"class"->"expanded"},{XMLElement["ul",{"class"->"functionList"},{Recurse[]}]}]}]}]],

{CellGroupData, "ServiceSubsection" } :> Module[{dstitle}, dstitle = Flatten[{Transmogrify[First[First[SelectChildren[]]]]}];
	XMLElement["div", {"class"->"expandWrap closed", "id"->"Elements"},
	{XMLElement["div", {"class"->"expandOuter"},{
		XMLElement["h2", {"class"->"expandInner"}, {
			XMLElement["a", {"class"->"expand", "title"->Localized["show", GetParameter["language"]], "href"->"#"},dstitle], 
			XMLElement["a", {"class"->"collapse hide", "title"->Localized["hide", GetParameter["language"]], "href"->"#"},dstitle]}], 
			XMLElement["div",{"class"->"expanded"},{XMLElement["ul",{"class"->"functionList"},{Recurse[]}]}]}]}]],

{CellGroupData, "RelatedDemonstrationsSection"} :> XMLElement["div", {"class"->"expandWrap", "id"->"RelatedDemonstrations"},
	{XMLElement["div", {"class"->"expandOuter"},{
		XMLElement["h2", {"class"->"expandInner"}, {
			XMLElement["a", {"class"->"expand hide", "title"->Localized["show", GetParameter["language"]], "href"->"#"},{"Related Demonstrations"}], 
			XMLElement["a", {"class"->"collapse", "title"->Localized["hide", GetParameter["language"]], "href"->"#"},{"Related Demonstrations"}]}], 
			XMLElement["div",{"class"->"expanded"},{XMLElement["ul",{"class"->"functionList"},{Recurse[]}]}]}]}], 

{Cell, "UsageSection" | "LegacyMaterialSection" | "ApplicationNotesSection" | "DesignDiscussionSection" | "ExtensionsSection" 
} :> 
Module[{name, style, ex, versionNumber},
versionNumber = StringSplit[$Version, "."][[1]];
style = GetStyle[];
Which[ style === "ElementsSection", name = "ELMS",  
style === "ExtensionsSection", name = "EXTS",  
True, name = StringJoin@Flatten@{If[First@ToCharacterCode[#] < 91, #, ""] & /@ Characters[ GetStyle[] ]};
];
ex = If[MemberQ[
  {"NotesSection", "ImportExportSection", "NotebookInterfaceSection", "ElementsSection", "DeviceSubsection", "ServiceSubsection", "OptionsSection"},
  style], "closed", "open"];
A[{"name" -> GetStyle[], "id"->"hello" }, {
  DIV[ 
  	(*If[name==="NS",{"class" -> name<>"H", "id"->"ModInfo_"<>versionNumber, "name"->"ModInfo_"<>versionNumber},{"class" -> name<>"H" }]*)
  	{"class" -> name<>"H"}
  	, {
    A[{"href" -> ("javascript:toggle('" <> name <> "')"), "onmouseover" -> "javascript:return(true);" }, {
    Img[{"src"->(GetParameter["htmlBase"]<>"/mathematicaImages/"<>ex<>"SectionGroup.gif"), "id"->name<>"_", "border"->"0", "width"->"8", "height"->"8", "alt"->""}], 
      " ",
      Span[{"class"->name<>"Span"}, { Recurse[] }]
    }]
  }]
}] ],

{Cell, "DeviceSubsection" |  "ServiceSubsection" | "MoreAboutSection" | "SeeAlsoSection" | "TutorialsSection" | "RelatedLinksSection" | "RelatedTutorialsSection" | "TutorialRelatedLinksSection" | "TutorialMoreAboutSection" | "RelatedDemonstrationsSection" | "TutorialCollectionSection" | "ElementsSection" | "ImportExportSection" | "NotebookInterfaceSection" | "OptionsSection"} :> Unevaluated[Sequence[]],

{Cell,"NotesSection"} :> Recurse[],

(* for some reason <p class="ExampleDelimiter" /> doesn't bode well with browsers.
   therefore, I have added a " " *)
{Cell, "ExampleDelimiter"} :> 
DIV[{"class" -> "ExLine"}, {XML`RawXML["<!-- -->"]}],


{Cell, "ExampleDelimiterInput"} :> 
DIV[{"class" -> "ExLineI"}, {XML`RawXML["<!-- -->"]}],
  

{Cell, "MoreAbout" | "TutorialMoreAbout" | "Tutorials" | "RelatedDemonstrations" | "RelatedLinks" | "LegacyMaterial" | 
"ApplicationNotes" | "DesignDiscussion" | "Extensions"} :> 
  Li[{}, {Recurse[]}],
  
{Cell, "TutorialCollection"} :> Unevaluated[Sequence[]],
(* Scale picture smaller *)
(* TODO find more suitable alt & title tags for GraphicsData and RawData *)
{Cell, "Picture"} :> (
XMLElement["img", {
            "src" -> ("URL" /. #), "width" -> ("Width" /. #), 
            "height" -> ("Height" /. #), 
            "class"->If[GetParameter["entityType"]==="HowTo","HowToPicture",""],
            (*"width" -> ToString[Floor[.89 ToExpression["Width" /. #]]],
            "height" -> ToString[Floor[.89 ToExpression["Height" /. #]]],*)
            "alt" -> ""
          }, {}]&[
           BoxToImage[ToFileName[{"Files", GetFileNameBase[]},
              "Image_" <> IncrementCounter["Image"] <> ".gif"],
            Inline -> False, MaxImageSize->580, CropImage -> False]
          ]),


{Cell, "FlushInput"} :>
  WithParameters[{"newline2br" -> True},
    XMLElement["p", {"class" -> "StandardForm", "id" -> GetStyle[]}, {
      XMLElement["b", {}, {Recurse[]}]}
      ] ],


(* Change bullets between 'see also' items *)

{StyleBox, "InlineSeparator"} :> 
  Span[{"class" -> "inlineSeparator"}, {
    Img[{"src" -> GetParameter["htmlBase"]<>"/mathematicaImages/bullet.gif", "style"->"vertical-align:middle;", "width"->"4", "height"->"4", "alt"->"bullet", "title"->"bullet"}] }],

{Cell, "SeeAlso"} :> XMLElement["p", {"class"->"inlineFunctionList"}, {Recurse[]}],
   

{FormBox} :> Module[{boxChildren,traditionalFormQ,altTag},
boxChildren=SelectChildren[];
traditionalFormQ = If[GetStyle[] === TraditionalForm, True, False];
altTag = DocumentationBuild`Utils`CellToString@SelectSelf[];
If[MatchQ[boxChildren, {"Mathematica"}],Transmogrify[StyleBox["Mathematica", FontSlant->"Italic"]],
If[MatchQ[boxChildren, {StyleBox[_, "KeyEvent", ___]}], Transmogrify[boxChildren],
transmogrifyImage[ToFileName[{"Files", GetFileNameBase[]},
  IncrementCounter["Image"] <> ".png"], {"style"->"vertical-align:middle;", "alt"->altTag, "title"->altTag}, Inline -> True, ImageFormat -> "PNG", TransparentBackground->True, ConversionOptions->{Background->None}
]
]
]
],

 
(* TODO find more suitable alt & title tags for GraphicsData and RawData *)
{GraphicsData | RawData} :>  
transmogrifyImage[ToFileName[{"Files", GetFileNameBase[]},
  IncrementCounter["Image"] <> ".gif"], {"alt" -> "", "title" -> ""},
  Inline -> True
],


{OutputFormData} :> Transmogrify[SelectChildren[][[2]]]  

},

IncludeXMLTransforms -> {{"HTML","Components","Includes.m"}},

DefaultParameters -> {
  (*  "newline2br" -> False,  *)
  "newline2br" -> False,
  "newline2div" -> False,
  "styleUsageMessageBreak" -> "</div>\n<div class=\"usageDelimiter\" > </div><div class=\"UM\">",


  (* No Operation code *)
  "noop" -> {
    $CreateCompleteHTMLFile = False;
    $LanguageExtension := Switch[GetParameter["language"], "Japanese", "ja", "ChineseSimplified", "zh", 
    	"Spanish", "es", _, "en"];
(* exceptionsList:= {True}, *)
    exceptionsList:= {"Symbol", "Menu Item", "File", "System Program", "Front End Object", 
    	"MathLink C Function", "LibraryLink C Function","System Program", "Widget", "Message", "Indicator"}; 
  }
},

CounterReassignments -> {{"Chapter", "Section"}, {"Section", "Subsection"}, {"Subsection", "Subsubsection"}}

]