XMLTransform[{
    {Notebook} :> Block[{marketingnblink}, {Recurse[]}],
    {CellGroupData, "MarketingCategoryTitle"} :> 
     Module[{recursed}, 
      ResetCounters["MarketingCategorySubpageSection"]; 
      IncrementCounter["MarketingCategoryTitle"]; 
      recursed = 
       Recurse[]; {First[{recursed}], {"whatsnew1" <> 
         DocumentationBuild`Utils`NumberToLetter[
          GetCounter["MarketingCategoryTitle"]] <> "_sub", 
        Drop[{recursed}, 1]}}],
    {Cell, "MarketingCategoryTitle"} :> 
     Module[{}, {"whatsnew1" <> 
        DocumentationBuild`Utils`NumberToLetter[
         GetCounter["MarketingCategoryTitle"]], ToString[Recurse[]], 
       "/mathematica/new-in-9/" <> 
        DocumentationBuild`Utils`titlemaker[
         ToString[SelectSelf[][[1]]]] <> ".html"}], 
    {Cell, "MarketingCategoryTitleCaption"} :> Sequence[],
    {Cell, "FeaturedContentSection"} :> Sequence[],
    {Cell, "Input"} :> Sequence[],
    {Cell, "MarketingNBLink"} :> Sequence[],
    {Cell, "MarketingCategoryText"} :> Sequence[],
    {Cell, "Output"} :> Sequence[],
    {Cell, "MarketingCategoryDetail"} :> Sequence[],
    {CellGroupData, "MarketingCategorySubpageSection"} :> 
     Module[{}, 
      marketingnblink = 
       Transmogrify`ConvertToString[
        Cases[Get[
           FileNameJoin[
            Flatten[{FileNameSplit[
               GetParameter["marketingpagefolder"]], 
              ToString[
               Cases[SelectSelf[], 
                 Cell[nblink___, "MarketingNBLink", ___] :> nblink, 
                 Infinity][[1]]]}]]], 
          Cell[___, "MarketingTitle", ___], Infinity][[1]]];
      Recurse[]],
    {Cell, 
      "MarketingCategorySubpageSection"} :> {"whatsnew1" <> 
       DocumentationBuild`Utils`NumberToLetter[
        GetCounter["MarketingCategoryTitle"]] <> 
       IncrementCounter["MarketingCategorySubpageSection"], 
      marketingnblink, 
      "/mathematica/new-in-9/" <> 
       DocumentationBuild`Utils`titlemaker[marketingnblink] <> 
       "/index.html"},
    {Cell, "Delimiter"} :> Sequence[],
    {Cell, "HistoryData"} :> Sequence[],
    {Cell, "History"} :> Sequence[],
    {Cell, "KeywordsSection"} :> Sequence[],
    {Cell, "Keywords"} :> Sequence[],
    {String} :> 
     Module[{stringContent, stringTest}, 
      stringContent = ReplaceSpecialCharacters[SelectSelf[]];
      stringTest[x_] := 
       Which[Head[x] === XMLElement, x, Head[x] === RawXML, x, 
        StringLength[x] === 1 && 
         StringMatchQ[x, RegularExpression["[a-z]"]], 
        XMLElement["I", {}, {x}], True, x];
      (*handle inline formatted strings...*)
      Which[InlineFormattedQ[SelectLiteral[SelectSelf[]]], 
       Transmogrify[FromInlineString[SelectSelf[]]], 
       traditionalFormQ === True, 
       Sequence @@ Map[stringTest[#] &, {stringContent}], True, 
       stringContent]]
    },
   IncludeXMLTransforms -> {{"HTML", "Components", "Includes.m"}}, 
   DefaultParameters -> {"newline2br" -> False, "newline2div" -> False}
   ]