(* :Title: Insider.m *)

(* :Author:
  Greg Martel, gregm@wolfram.com
*)

(* :Mathematica Version: 8 *)
(* :Package Version: $Revision: 1.118 $ $Date: 2012/03/23 22:37:45 $ *)                  
(* :Copyright: (c) 2011, Wolfram Research, Inc. All rights reserved. *)
(* :Summary: Web transform for Wolfram Insider Pages *)


XMLTransform[{

(* Transform Notebook *)
{Notebook} :>  Block[{nbExpression,title,fileBase,pageType,leftColumn,rightColumn,newsLang,langExt,
	summary,descriptionText, insertHR, cellsForTextVersion, textVersion, textVersionSectionDelimiter,
	textFileName, tocList, deleteleftcolumlisttextversion, texttaglinecell, titleText, imagePath, isReleaseBuild, pageTypeContent,
	pageTitle, htmlContent},
	
	deleteleftcolumlisttextversion={"operations","wolframblog","upcomingevents","wolframtraining","store","news","more"};

	(* utility functions *)
	GetSectionByStyleAndCellTag[expr_, style_String, tag_String]:=
    Cases[expr, Cell[CellGroupData[{Cell[aa_, style, bb___, CellTags->tag, cc___], dd___}, ee___], ff___], Infinity];
    
    GetSectionByStyle[expr_, style_String]:=
    Cases[expr, Cell[CellGroupData[{Cell[aa_, style, cc___], dd___}, ee___], ff___], Infinity];
    
    CleanMetaForWeb[{desc_String}]:= (
   {StringReplace[desc, {"&"->" and ", "'"->"`", "\"" -> "&quot;"}]}
   );
    CleanMetaForWeb[desc_String]:= (
   StringReplace[desc, {"&"->" and ", "'"->"`", "\"" -> "&quot;"}]
   );
   
    ExtractSectionTags[expr_, style_String, lang_String]:=
    Cases[expr, Cell[CellGroupData[{Cell[aa_, style, bb___, CellTags->tag_String, cc___], dd___}, ee___], ff___]:>
    		tag, Infinity];	
    		
    fixGuillemet[sectionList_List]:= Module[{sectionListNew,hyperlinkStyleAlternatives,cellStyleAlternatives},
    	
    	hyperlinkStyleAlternatives="Hyperlink"|"HyperlinkNew";
    	cellStyleAlternatives= "WolframInsiderSection"|"WolframInsiderHeading2";
    	
    	sectionListNew = sectionList /. {
    		
    		TextData[{a_String,
    		ButtonBox["\[RightGuillemet]",BaseStyle->"Hyperlink",
    			b__]}]:>
    		TextData[
    		ButtonBox[a<>"\[RightGuillemet]",BaseStyle->"NewHyperlink",
    			b]]
    	};
    	
    	sectionListNew
    	];
    		
    		
(* end utility functions *)
		
	insertHR = 	XML`RawXML["<hr style=\"border-left:none; border-bottom:none; border-right:none; border-top :solid;border-width:1px; border-color:#CCCCCC; text-align:left;width:100%; margin-top:25px; margin-bottom:10px; margin-right:auto; margin-left:auto;\">"];
    
    newsLang=GetParameter["Language"];Print@newsLang;
    langExt = Switch[newsLang,
    	"Japanese","ja",
    	_,"en"];Print@langExt;
   
   	fileBase = GetParameter["fileName"];
   	
   	pageType = GetParameter["type"];
   	
   	pageTitle = GetParameter["pageTitle"];
   	
	nbExpression = SelectSelf[];
	
    leftColumn = Cases[nbExpression, Cell[CellGroupData[{Cell["Column 1", "WolframInsiderLeftSide",a___], b___}, 
    	c___], d___], Infinity];
    rightColumn = Cases[nbExpression, Cell[CellGroupData[{Cell["Column 2", "WolframInsiderRightSide",a___], b___}, 
    	c___], d___], Infinity];

	title=Cases[nbExpression, Cell[a__, "WolframInsiderIssue", b___], Infinity];
	
	summary = GetParameter["summary"];
	summary = ExportString[XMLElement["String", {}, { GetParameter["summary"] }], "XML", "Entities" -> "HTML"];
	summary = If[Head@summary === String,
			StringReplace[summary, {"<String>" -> "", "</String>" -> ""}],
			""];
	summary = CleanMetaForWeb[summary];
	descriptionText = CleanMetaForWeb@First[MathLink`CallFrontEnd[FrontEnd`ExportPacket[GetParameter["description"], "PlainText"]]];
    (*imagePath = StringSplit[StringReplace[GetParameter["imagepath"], "http://"->""], {"/","\\"}];*)
    imagePath = GetParameter["imagepath"];
    isReleaseBuild = GetParameter["releaseBuild"];

	cellsForTextVersion = Cases[
	 	DeleteCases[SelectSelf[], 
	 		Cell[__, "WolframInsiderImage", __]|Cell[__, "WolframInsiderLeftSide", __]|Cell[__,"WolframInsiderImageTitle",__]|
	 		Cell[__, "WolframInsiderRightSide", __]|Cell[__, "WolframInsiderColumn", __], Infinity ], 
	 		Cell[_,a_String/; StringMatchQ[a, "WolframInsider"~~__], ___], Infinity];
	 		
  (*pageTypeContent = Which[pageType,
  	"Salespartner, "Wolfram Insider for Sales Partners", 
  	"Publisher", "Wolfram Insider for Publishers", 
  	True, ""
  ];*)
  
	 		
   texttaglinecell = "Wolfram Insider "<>CellToString[Take[cellsForTextVersion, {1}]]; 

   tocList = Prepend[Map[Cell["* "<>#, "WolframInsiderText"]&, 
   	Map[Localized[#<>"_Insider", newsLang]&, 
   	DeleteCases[
   		ExtractSectionTags[nbExpression, "WolframInsiderSection", newsLang],
   		Alternatives@@deleteleftcolumlisttextversion]
   ]
   ], Cell["\n\nIn This Issue", "WolframInsiderText"]
   ];
	 	
	textVersion = Module[{styleList},
		
		styleList={"WolframInsiderText", "WolframInsiderHeading2", "WolframInsiderHeading4", "WolframInsiderListItem",
		"WolframInsiderListItem2", "WolframInsiderListItemDateLocation", "WolframInsiderListAnswer"};
		
		Map[
	CleanMetaForWeb@First[MathLink`CallFrontEnd[FrontEnd`ExportPacket[#, "PlainText"]]]&,
	 ReplaceAll[Insert[cellsForTextVersion, {tocList, Cell[TextData[{"\n","\n"}]]}, 2] , {
	 	
	 	 
	 
	 	Cell[a__, "WolframInsiderSection",b__]->
	 Cell[TextData[{"\n\n-----------------------------\n",a,"\n-----------------------------\n"}], "WolframInsiderSection",b],
	 
	 
	 Cell[x:TextData[{a___, ButtonBox[a2__, ButtonData->b1_, ___], a3___}], a1_/;MemberQ[styleList,a1], b__]:>
	 {Cell[x], Cell[TextData[{"\n", b1,"\n", "\n"}], "WolframInsiderText"]},
	 
	 
	 Cell[a_String, a1_/;MemberQ[styleList,a1], b__]->
	 Cell[TextData[{"\n",a,"\n"}], a1, b],
	 	
	 	Cell[a_String, a1_/;MemberQ[styleList,a1], b__]->
	 Cell[TextData[{"\n",a,"\n"}], a1, b],
	 
	 	Cell[TextData[{a__}], a1_/;MemberQ[styleList,a1], b__]->
	 Cell[TextData[{"\n",a,"\n"}], a1, b],
	 	 
	 	Cell[TextData[a__], a1_/;MemberQ[styleList,a1], b__]->
	 Cell[TextData[{"\n",a,"\n"}], a1, b]
	 
	 }]
	]
	];
	
	
	textVersion = Export[fileBase<>".txt",
			StringReplace[
			ExportString[
"To:nobody@wolfram.com\n"<>
"From:nobody@wolfram.com\n"<>
"Subject: "<> texttaglinecell <>"\n"<> 
"MIME-Version: 1.0:\n"<>
"Content-Type: multipart/alternative; boundary=\"frontier\"\n
This is a message with multiple parts in MIME format.\n
--frontier
Content-Type: text/plain; charset=utf-8\n\n"<>
				textVersion<>
"\n\n----------------------
Wolfram Research, Inc.: 100 Trade Centre Drive, Champaign, IL 61820
1-800-WOLFRAM
1-217-398-0700
http://www.wolfram.com

To view our privacy policy, click here:
http://www.wolfram.com/legal/privacy/wolfram-research.html

To update your email, click here:
http://www.wolfram.com/emailchange

Copyright 2011 Wolfram Research, Inc. Mathematica is a registered trademark of Wolfram Research, Inc. All other trademarks are the property of their respective owners. Mathematica is not associated with Mathematica Policy Research, Inc.


--frontier
Content-Type: text/html; charset=utf-8\n"

<>texttaglinecell<>

"\n
--frontier", "Text"],
		{"&quot;"->"\"", "\[RightGuillemet]"->"", "\[CapitalAHat]"->"", "\\[LongDash]"->""}], "Table"(*"Text"*)
	];

	
	CreateTOC[nb_Notebook, language_String]:= Module[{leftcolumlist,rawtags,tags,contents,feedlist,
		fontsize, lineheight},
	leftcolumlist={"wolframblog","qanda","upcomingevents","tip","wolframtraining","store","news","more","collab","journal"};
    rawtags=ExtractSectionTags[nb, "WolframInsiderSection", language];
    tags=DeleteCases[rawtags,Alternatives@@leftcolumlist];
	contents = Map[Localized[#<>"_Insider", language]&, tags];
	feedlist=Transpose[{tags,contents}]; 
	fontsize = "11px";
	lineheight = If[language==="Japanese","13px","11px"];
	putIntoTableRows[{tag_String, con_String}]:=
	XMLElement["tr", {}, {
		XMLElement["td", {"valign"->"top","style"->"padding-bottom:10px;padding-right:5px;padding-left:2px;"}, {
			XMLElement["a", {"href"->"#"<>tag, "style"->"color:#666666; outline:none; text-decoration:none;"}, {
				XMLElement["img", {"src"->"http://msgcache.wolfram.com/wolfram-insider/images/arrowbullet.gif",
					"alt"->"", "border"->"0"}, {}]     }]
			}],
		XMLElement["td", {"valign"->"top", "style"->"padding-bottom:10px;"}, {
			XMLElement["div", {"style"->"font-family:Arial,Verdana,sans-serif;font-size:"<>fontsize<>";line-height:"<>lineheight<>";"}, {
				(*XMLElement["a", {"href"->"#"<>tag, "style"->"color:#666666; outline:none; text-decoration:none;"}, {con}]*)
				XMLElement["a", {"href"->"#"<>tag, "style"->"color:#666666; outline:none; text-decoration:none;"}, Flatten@{StringSplit[con, " Mathematica "->XMLElement["i", {}, {" Mathematica "}]] }]
				}]
				}]       }];
											
											
	XMLElement["div", {}, {	
	XMLElement["h2", {"style"->
		"background-color:#ffffff; font-family:Arial,Verdana,sans-serif; color:#222222; font-size:13px; font-weight:bold; margin-bottom:8px; margin-top:0px; margin-left:15px;"},
		{Localized["ISSUE_Insider", language]}],
	XMLElement["table", {"width"->"210","border"->"0","cellpadding"->"0","cellspacing"->"0","style"->
		"margin-left:15px; background-color:#ffffff;"}, Flatten@{
		Map[
			putIntoTableRows[#]&, feedlist
			]
		}]
	}]

	];
									
  

    MakeBodyTable[expr_, language_String]:= Module[
    	{border, width, padding,spacing,style,logoImage,logoAlt,logoTitle},
    	border="0";
    	width="728";
    	padding="0";
    	spacing="0";
    	style="table-layout:fixed; padding-top:0px; padding-bottom:0px; text-align:left;background-color: #ffffff;border-left-width:1px;border-left-style:solid;border-left-color:#c3c3c3;border-right-width:1px;border-right-style:solid;border-right-color:#c3c3c3;border-bottom-width:1px;border-bottom-style:solid;border-bottom-color:#c3c3c3;";
    	logoImage=Switch[pageType,
    	"Academic","http://msgcache.wolfram.com/wolfram-insider/images/logo-academic2.gif",
    	"Salespartner","http://msgcache.wolfram.com/wolfram-insider/images/logo-sales.gif",
    	"Publishing","http://msgcache.wolfram.com/wolfram-insider/images/logo-publishing.gif",
    	"Commercial", "http://msgcache.wolfram.com/wolfram-insider/images/logo.gif",
    	_, "http://msgcache.wolfram.com/wolfram-insider/images/no-image.gif"
    	];
    	logoAlt=Switch[pageType,
    	"Academic","Wolfram Insider: Academic Edition",
    	"Salespartner","Wolfram Insider for Sales Partners",
    	"Publishing","Wolfram Publishing News",
    	"Commercial","Wolfram Insider", 
    	_, "No Logo Alt"
    	];
    	logoTitle=Switch[pageType,
    	"Academic","Wolfram Insider: Academic Edition",
    	"Salespartner","Wolfram Insider for Sales Partners",
    	"Publishing","Wolfram Publishing News",
    	"Commercial","Wolfram Insider",
    	_, "No Logo Title"
    	];
    	
    	XMLElement["table",
    		{"border"->border,"width"->width,"cellpadding"->padding,"cellspacing"->spacing,"style"->style},
    		 {
    		 	XMLElement["tr", {}, {
    		 		XMLElement["td", {"valign"->"top","width"->"410","style"->"padding-right:15px;padding-left:25px;padding-top:10px;padding-bottom:50px;"}, {
    		 			Transmogrify[title],
    		 			Which[pageType==="Salespartner",
    		 				XMLElement["a", {"href"->"http://reseller.wolfram.com/","target"->"_blank"}, {
    		 					XMLElement["img",{"src"->logoImage, "alt"->logoAlt, "title"->logoTitle, "style"->"border-style:none;"},{}]
    		 				}],
    		 				pageType==="Publishing",
    		 				XMLElement["img",{"src"->logoImage, "alt"->logoAlt, "title"->logoTitle},{}], 
    		 				True,
    		 				XMLElement["a", {"href"->"http://www.wolfram.com/news/newsletter/","target"->"_blank"}, {
    		 					XMLElement["img",{"src"->logoImage, "alt"->logoAlt, "title"->logoTitle, "style"->"border-style:none;"},{}]
    		 				}]
    		 				]
    		 			,
    		 			Transmogrify[leftColumn]
    		 		}],
    		 		XMLElement["td",{"valign"->"top", "width"-> "250px", "style"->
    		 			"padding-left:15px; padding-right:15px; padding-top:15px; background-color:#f6f6f6; border-left-width:1px;border-left-style:solid;border-left-color:#c3c3c3;"},{
    		 			XMLElement["div", {"style"->"margin-bottom:20px; background-color:#ffffff; border-left-width:1px;border-left-style:solid;border-left-color:#c3c3c3;border-right-width:1px;border-right-style:solid;border-right-color:#c3c3c3;border-bottom-width:1px;border-bottom-style:solid;border-bottom-color:#c3c3c3;border-top-width:1px;border-top-style:solid;border-top-color:#c3c3c3;"}, {
    		 				XML`RawXML["<img src=\"http://www.wolfram.com/common/images/spacer.gif\" height=\"15\" width=\"1\" border=\"0\">"], 
    		 				CreateTOC[nbExpression, language]
    		 				}],
    		 				Module[{feedbacklocation},
    		 					
    		 				feedbacklocation = Switch[pageType,
    							"Academic","edu-feedback/",
    							"Commercial","comm-feedback/", 
    							_, "comm-feedback"
    						];
    		 					
    		 					If[MemberQ[{"Commercial","Academic"},pageType],
    		 				XMLElement["div", {"style"->"font-family:Arial,Verdana,sans-serif; text-align:right; margin-top:8px;"}, {
								XMLElement["a", {"target"->"_blank", "href"->"http://www.wolfram.com/news/newsletter/"<>feedbacklocation,
									"style"->"color:#e00400; font-size:11px; outline:none; text-decoration:none;"},
									{"Feedback \[RightGuillemet]"}], 
									XML`RawXML["<br><br>"]
								}], ""]
    		 				],
    		 				Transmogrify[rightColumn]
    		 		}]
    		 	}]
    		 	}]		 
	];



    
    
    
    htmlContent = FillInLayout[
    GetParameter["layoutfile"],
    "Text",
    
    titleText = ExportString[
    			XMLElement["title", {}, {pageTitle}  ],
    				"XML"];
	"title"-> titleText, 

    "bodyTable"->ExportString[
		MakeBodyTable[nbExpression, newsLang], "XML", "AttributeQuoting"->"\"", 
          "Entities"->
          If[GetParameter["Language"]==="Japanese",
          {"\r"->"", "\n"->"", "\[LongDash]"->"&mdash;"},
          {"\[LongDash]"->"&mdash;"}], "ElementFormatting"->Automatic]
          
  ];
  
  
  
    
    	cellsForTextVersion = Cases[
	 	DeleteCases[SelectSelf[], 
	 		Cell[__, "WolframInsiderImage", __]|Cell[__, "WolframInsiderLeftSide", __]|Cell[__,"WolframInsiderImageTitle",__]|
	 		Cell[__, "WolframInsiderRightSide", __]|Cell[__, "WolframInsiderColumn", __], Infinity ], 
	 		Cell[_,a_String/; StringMatchQ[a, "WolframInsider"~~__], ___], Infinity];
	 		
  (*pageTypeContent = Which[pageType,
  	"Salespartner, "Wolfram Insider for Sales Partners", 
  	"Publisher", "Wolfram Insider for Publishers", 
  	True, ""
  ];*)
  
	 		
   texttaglinecell = "Wolfram Insider "<>CellToString[Take[cellsForTextVersion, {1}]]; 

   tocList = Prepend[Map[Cell["* "<>#, "WolframInsiderText"]&, 
   	Map[Localized[#<>"_Insider", newsLang]&, 
   	DeleteCases[
   		ExtractSectionTags[nbExpression, "WolframInsiderSection", newsLang],
   		Alternatives@@deleteleftcolumlisttextversion]
   ]
   ], Cell["\n\nIn This Issue", "WolframInsiderText"]
   ];
	 	
	textVersion = Module[{styleList},
		
		styleList={"WolframInsiderText", "WolframInsiderHeading2", "WolframInsiderHeading4", "WolframInsiderListItem",
		"WolframInsiderListItem2", "WolframInsiderListItemDateLocation", "WolframInsiderListAnswer"};
		
		Map[
	CleanMetaForWeb@First[MathLink`CallFrontEnd[FrontEnd`ExportPacket[#, "PlainText"]]]&,
	 ReplaceAll[Insert[cellsForTextVersion, {tocList, Cell[TextData[{"\n","\n"}]]}, 2] , {
	 	
	 	 
	 
	 	Cell[a__, "WolframInsiderSection",b__]->
	 Cell[TextData[{"\n\n-----------------------------\n",a,"\n-----------------------------\n"}], "WolframInsiderSection",b],
	 
	 
	 Cell[x:TextData[{a___, ButtonBox[a2__, ButtonData->b1_, ___], a3___}], a1_/;MemberQ[styleList,a1], b__]:>
	 {Cell[x], Cell[TextData[{"\n", b1,"\n", "\n"}], "WolframInsiderText"]},
	 
	 
	 Cell[a_String, a1_/;MemberQ[styleList,a1], b__]->
	 Cell[TextData[{"\n",a,"\n"}], a1, b],
	 	
	 	Cell[a_String, a1_/;MemberQ[styleList,a1], b__]->
	 Cell[TextData[{"\n",a,"\n"}], a1, b],
	 
	 	Cell[TextData[{a__}], a1_/;MemberQ[styleList,a1], b__]->
	 Cell[TextData[{"\n",a,"\n"}], a1, b],
	 	 
	 	Cell[TextData[a__], a1_/;MemberQ[styleList,a1], b__]->
	 Cell[TextData[{"\n",a,"\n"}], a1, b]
	 
	 }]
	]
	];
	
	
	textVersion = Export[fileBase<>".txt",
			StringReplace[
			ExportString[
"To:nobody@wolfram.com\n"<>
"From:nobody@wolfram.com\n"<>
"Subject: "<> texttaglinecell <>"\n"<> 
"MIME-Version: 1.0:\n"<>
"Content-Type: multipart/alternative; boundary=\"frontier\"\n
This is a message with multiple parts in MIME format.\n
--frontier
Content-Type: text/plain; charset=utf-8\n\n"<>
				textVersion<>
"\n\n----------------------
Wolfram Research, Inc.: 100 Trade Centre Drive, Champaign, IL 61820
1-800-WOLFRAM
1-217-398-0700
http://www.wolfram.com

To view our privacy policy, click here:
http://www.wolfram.com/legal/privacy/wolfram-research.html

To update your email, click here:
http://www.wolfram.com/emailchange

Copyright 2011 Wolfram Research, Inc. Mathematica is a registered trademark of Wolfram Research, Inc. All other trademarks are the property of their respective owners. Mathematica is not associated with Mathematica Policy Research, Inc.


--frontier
Content-Type: text/html; charset=utf-8\n"

<>htmlContent<>

"\n
--frontier", "Text"],
		{"&quot;"->"\"", "\[RightGuillemet]"->"", "\[CapitalAHat]"->"", "\\[LongDash]"->""}], "Table"(*"Text"*)
	];
	
	
	htmlContent



],



(* Cell styles *)
{Cell, "WolframInsiderIssue"}:>XMLElement["h3", {"style"->
	"color:#e00400; font-size:17px; font-weight:bold; margin-top:0px; margin-bottom:10px; margin-right:0px; margin-left:0px;"}, {Recurse[]}],

{CellGroupData, "WolframInsiderSection"}:> Module[{tag},
	tag=Cases[SelectChildren[Cell, "WolframInsiderSection"], Rule[CellTags, a_]:>a, Infinity][[1]];
	If[tag==="wolframtraining", Unevaluated@Sequence[],
	{insertHR,
	XMLElement["div",{},{
		XMLElement["a", {"name" -> tag}, {""}],
		Recurse[]}]}
	]
],

{Cell, "WolframInsiderSection"}:>Module[{tag, titleimgsrc, alt, langexts},
	tag=GetOption[CellTags] (*/. None->"follow"*);
	alt=Localized[tag<>"_Insider", newsLang];
	langexts=If[newsLang==="Japanese","_jp", ""];
	titleimgsrc="http://msgcache.wolfram.com/wolfram-insider/images/"<>
	Switch[tag,
		"applicationupdates", "application",
		"topic", "topic",
		"topics", "topics",
		"books", "books",
		"programs", "programs",
		"partnerinfo", "partner-info",
	 	"partnertraining", "sales-partner-training",
	    "products", "product",
	    "profile", "profile",
	    "resources", "resources", 
	    "resourcetraining", "resourcetraining",
	    "updatedresources", "updated", 
	    "tmj", "tmj", 
	    "journal", "journal", 
	    "cdfhighlights","cdf",
	    "demonstrations","demonstrations",
	    "didyouknow", "know",
	    "solutions", "solutions",
	    "operations", "options",
	    "wolframblog", "blog",
	    "newinblog", "new",
	    "upcomingevents", "events",
	    "wolframtraining", "training",
	    "store", "newinstore",
	    "news", "news",
	    "follow", "follow",
	    "qanda", "qa",
	    "more", "more",
	    "tip", "tip",
	    "collab", "collab",
		_, "follow"
	] <> langexts <> ".gif";
	
	
	
	Sequence[
	insertHR,
	XMLElement["a", {"name" -> tag}, {""}],
	If[Head[tag]===Symbol, {insertHR,
		XMLElement["img", {"src"->titleimgsrc, "title"->"Follow Us", "alt"->"Follow Us"}, {}],
		XML`RawXML["<br> <br>"],
		XMLElement["table", {"border"->"0","cellpadding"->"0","cellspacing"->"0"}, {
			XMLElement["tbody", {}, {
				XMLElement["tr", {}, {
					XMLElement["td", {"style"->"padding-right: 10px;"}, {
						XMLElement["a", {"href"->"http://www.facebook.com/mathematica","target"->"_blank"}, {
							XMLElement["img", {"src"->"http://msgcache.wolfram.com/wolfram-insider/images/facebook.gif","alt"->"Facebook","title"->"Facebook","border"->"0"}, {}]
							}]
							}],
					XMLElement["td", {"style"->"padding-right: 10px;"}, {
						XMLElement["a", {"href"->"http://twitter.com/wolframresearch","target"->"_blank"}, {
							XMLElement["img", {"src"->"http://msgcache.wolfram.com/wolfram-insider/images/twitter.gif","alt"->"Twitter","title"->"Twitter","border"->"0"}, {}]
							}]
							}],
					XMLElement["td", {"style"->"padding-right: 10px;"}, {
						XMLElement["a", {"href"->"http://www.linkedin.com/company/wolfram-research","target"->"_blank"}, {
							XMLElement["img", {"src"->"http://msgcache.wolfram.com/wolfram-insider/images/linkedIn.gif","alt"->"LinkedIn","title"->"LinkedIn","border"->"0"}, {}]
							}]
							}],
					XMLElement["td", {}, {
						XMLElement["a", {"href"->"http://www.youtube.com/user/WolframResearch","target"->"_blank"}, {
							XMLElement["img", {"src"->"http://msgcache.wolfram.com/wolfram-insider/images/youtube.gif","alt"->"YouTube","title"->"YouTube","border"->"0"}, {}]
							}]
							}]
					}]
				}]
			}]
								}, 
		
		If[tag==="more",
			XMLElement["div", {}, {
				XMLElement["img", {"src"->titleimgsrc, "title"->alt, "alt"->alt}, {}],
			XML`RawXML["<br> <br>"]
			}] ,
			XMLElement["img", {"src"->titleimgsrc, "title"->alt, "alt"->alt}, {}]]
		
		]
	]

],

{CellGroupData, "WolframInsiderImage"}:>
Module[{self, alttitlecell, alttitle, body, imageButton},
	self=SelectSelf[];
	alttitlecell=SelectChildren[Cell,"WolframInsiderImageTitle"];
	alttitle=First[MathLink`CallFrontEnd[FrontEnd`ExportPacket[alttitlecell, "PlainText"]]];
	body=Flatten[{SelectChildren[Cell,"WolframInsiderImage"], SelectChildren[Cell,"WolframInsiderFeatureText"],
	SelectChildren[Cell,"WolframInsiderFeatureListItemDateLocation"]}];
	
	imageButton=Cases[self, ButtonBox[_GraphicsBox, BaseStyle -> "Hyperlink", __], Infinity];
	imageButton=Cases[imageButton, Rule[ButtonData,a_String]:>a, Infinity];
	
	WithParameters[{
		"imageAlt" -> alttitle,
		"buttonData" -> imageButton},

	Transmogrify[body]
	
	]
],

{Cell, "WolframInsiderImage"}:>Module[{altTag,cellTag,bData,image, number},
	altTag=GetParameter["imageAlt"];
	altTag=If[StringQ[altTag], altTag, ""];
	cellTag=GetOption[CellTags];
	bData=If[GetParameter["buttonData"]==={},"",GetParameter["buttonData"][[1]]];
	number=IncrementCounter["Image"];
	
	image=XMLElement["img", {"src" -> ("URL" /. #), "border"->"0",
      			"alt" -> altTag, "title" -> altTag }, {}]&[
      			If[isReleaseBuild===False,
      			BoxToImage[ToFileName[{"images."<>langExt},"image" <> number <> ".gif"], 
      				"TransparentColor"->White],
      			BoxToImage[imagePath<>"/images."<>langExt<>"/image" <> number <> ".gif", 
      				"TransparentColor"->White]
      			]
      				
      				];
    image=If[bData==="", image,
    	XMLElement["a", {"href"->bData, "target"->"_blank"}, {image}]];
	
	If[cellTag==="ModifyFeatureImage",
	XMLElement["p", {"style"->"margin-top:5px; margin-bottom:0px; margin-left:15px;margin-right:15px;"}, {
		    image
      			}],	
      	    image
	]					
],


{Cell, "WolframInsiderImageFeature"}:>Module[{altTag,number},
	altTag=GetParameter["imageAlt"];
	altTag=If[StringQ[altTag], altTag, ""]; 
	number=IncrementCounter["Image"]; 
	
			XMLElement["p", {"style"->"margin: 5px 15px 0px;"}, {
    		XMLElement["img", {"src" -> ("URL" /. #), "border"->"0",
      			"alt" -> altTag, "title" -> altTag }, {}]
			}]&[
			If[isReleaseBuild===False,
				BoxToImage[ToFileName[{"images."<>langExt},"image" <> number <> ".gif"], 
      				"TransparentColor"->White], 
      			BoxToImage[imagePath<>"/images."<>langExt<>"/image" <> number <> ".gif", 
      				"TransparentColor"->White]
      				]
      			]
      						
],


{Cell, "WolframInsiderText"}:>
XMLElement["p", {"style"->"font-family:Arial,Verdana,sans-serif; font-size:13px; (*margin-top:10px;*) margin-bottom:10px; color:#222;"}, {
	
	Transmogrify[
		fixGuillemet[SelectChildren[] ]   ]
	} ],

{Cell, "WolframInsiderTextRight"}:>XMLElement["div", 
	{"style"->"font-family: Arial,Verdana,sans-serif;(*text-align:right;*)margin-top:12px;margin-bottom:12px;font-size:13px;line-height:16px;"}, 
	{Recurse[] } ],

{Cell, "WolframInsiderLeftSide"|"WolframInsiderRightSide"}:>Unevaluated@Sequence[],

{CellGroupData, "WolframInsiderColumn"}:> Module[{attList},
	
	attList = If[GetSectionByStyle[SelectSelf[], "WolframInsiderImage"]==={},
		{"valign"->"top"},
		{"valign"->"top", "width"->"130"}];
		
	XMLElement["td", attList, {Recurse[]}]
		
],


{CellGroupData, "WolframInsiderTable"}:> XMLElement["table", {"width"->"100%","border"->"0",
	"cellpadding"->"0","cellspacing"->"0","style"->"margin-top:20px"}, {
		XMLElement["tr",{}, {Recurse[]}]
		}], 

{Cell, "WolframInsiderHeading2"}:> XMLElement["h2",{"style"->
	"font-family:Arial,Verdana,sans-serif; font-size:14px; font-weight:bold; margin-bottom:15px; (*margin-top:15px;*)"}, {
	
	Transmogrify@fixGuillemet[
	SelectChildren[]
	]
	
	}],

{Cell, "WolframInsiderHeading4"}:> XMLElement["p",{"style"->
	"font-family:Arial,Verdana,sans-serif; font-size:13px; margin-top:10px; color:#222; font-weight:bold;"}, {Recurse[]}],


{CellGroupData, "WolframInsiderListItem"}:> 
XMLElement["table", {
    "border"->"0", "cellpadding"->"0", "cellspacing"->"0", "width"->"100%"}, {
    XMLElement["tbody", {}, {Recurse[]}]
    }],


{Cell, "WolframInsiderListItem"}:> 
XMLElement["tr", {}, {
    XMLElement["td", {"valign"->"top"}, {
        XMLElement["img", {"src"->"http://msgcache.wolfram.com/wolfram-insider/images/bullet-grey.gif", "alt"->""}, {}]
    }],
    XMLElement["td", {"style"->"padding-bottom: 7px;", "valign"->"top"}, {
        XMLElement["p",{"style"->
    "font-family: Arial,Verdana,sans-serif; font-size: 13px; margin-top: 0px; margin-bottom: 0px;"}, 
    {
    	Transmogrify[
		fixGuillemet[SelectChildren[] ]   ]

    	}]
    }]
}], 


{Cell, "NewGroup"}:> XMLElement["table", {"width"->"100%","border"->"0",
	"cellpadding"->"0","cellspacing"->"0","style"->"margin-top:20px"}, {
		Recurse[]
		}], 
		
{CellGroupData, "WolframInsiderListItem2"}:> XMLElement["tr",{}, {
	XMLElement["td", {"valign"->"top"}, {
		XMLElement["img", {"src"->"http://msgcache.wolfram.com/wolfram-insider/images/bullet-grey.gif","alt"->""}, {}]
	}],			
	XMLElement["td", {"valign"->"top", "style"->"padding-bottom:7px;"}, {Recurse[]}]
	}],

{Cell, "WolframInsiderListItem2"}:> 
XMLElement["p", {"style"->"font-family:Arial,Verdana,sans-serif; font-size:13px; margin-top:0px; margin-bottom:0px;"},
	{Recurse[] }],
	
{CellGroupData, "WolframInsiderListItem3"}:> XMLElement["tr",{}, {
	XMLElement["td", {"valign"->"top"}, {
		XMLElement["img", {"src"->"http://www.wolfram.com/common/images/spacer.gif","alt"->""}, {}]
	}],			
	XMLElement["td", {"valign"->"top", "style"->"padding-bottom:7px;"}, {Recurse[]}]
	}],

{Cell, "WolframInsiderListItem3"}:> 
XMLElement["p", {"style"->"font-family:Arial,Verdana,sans-serif; font-size:13px; margin-top:0px; margin-bottom:0px;"},
	{Recurse[] }],


{Cell, "WolframInsiderListItemDateLocation"}:> 
XMLElement["p",{"style"->
    "font-family:Arial,Verdana,sans-serif; font-size:11px; margin-top:0px; margin-bottom:10px; color:#666;"}, 
    {Recurse[]}], 
    
    
{Cell, "WolframInsiderListAnswer"}:> 
XMLElement["p",{"style"->
    "font-family:Arial,Verdana,sans-serif; font-size:11px; margin-top:0px; margin-bottom:10px; color:#666;"}, 
    {Recurse[]}], 
    
    
{CellGroupData, "WolframInsiderFeatureSection"}:> Module[{langexts,self,head,body,featuretype,featureimage,
	featureimagealt},
    langexts=If[newsLang==="Japanese","_jp", ""];
    self=SelectSelf[];
    head=Cases[self,Cell[a_, "WolframInsiderFeatureSection", b___], Infinity];
    featuretype=Cases[self,Cell[a__, "WolframInsiderFeatureSection", b___, CellTags->c_, d___]:>c, Infinity][[1]];
    featureimage=Switch[featuretype, 
    	"featuredblog", "featuredBlog", 
    	"featuredevent", "featuredEvent",
    	"featuredtraining", "featuredTraining",
    	_, "featuredEvent.gif"]<> langexts <>".gif";
    featureimagealt=Localized[featuretype<>"_Insider", newsLang];
    body=DeleteCases[self,Cell[a_, "WolframInsiderFeatureSection", b___], Infinity];
    
    
    XMLElement["div", {}, {
    XML`RawXML["<br>"],
    XMLElement["div", {"style"->"background-color:#ffffff; border-left-width:1px;border-left-style:solid;border-left-color:#c3c3c3;border-right-width:1px;border-right-style:solid;border-right-color:#c3c3c3;border-bottom-width:1px;border-bottom-style:solid;border-bottom-color:#c3c3c3;border-top-width:1px;border-top-style:solid;border-top-color:#c3c3c3;"}, {
    	XMLElement["img", {"src"->"http://www.wolfram.com/common/images/spacer.gif","height"->"15","width"->"1","border"->"0"}, {}],
    	XML`RawXML["<br>"],
		XMLElement["img", {"src"->"http://msgcache.wolfram.com/wolfram-insider/images/"<>featureimage,"alt"->featureimagealt,"title"->featureimagealt}, {}],
    	Transmogrify[body],
    	XMLElement["img", {"src"->"http://www.wolfram.com/common/images/spacer.gif","height"->"15","width"->"1","border"->"0"}, {}]
    	}],
     XML`RawXML["<br>"]
    }]

],

{Cell, "NewFeatureGroup"}:> Module[{self,head,body,featuretype,featureimage,
	featureimagealt},
	
    self=SelectSelf[];
    head=Cases[self,Cell[a_, "WolframInsiderFeatureSection", b___], Infinity];
    featuretype=Cases[self,Cell[a_, "WolframInsiderFeatureSection", b___]:>a, Infinity];
    featuretype=Flatten[StringSplit[featuretype, " "]][[2]];
    featureimage=If[featuretype==="Blog", "featuredBlog.gif", "featuredTraining.gif"];
    featureimagealt=If[featuretype==="Blog", "Featured Blog Post", "Featured Training Event"];
    body=DeleteCases[self,Cell[a_, "WolframInsiderFeatureSection", b___], Infinity];
    
    XMLElement["div", {}, {
    XML`RawXML["<br>"],
    XMLElement["div", {"style"->"background-color:#ffffff; border-left-width:1px;border-left-style:solid;border-left-color:#c3c3c3;border-right-width:1px;border-right-style:solid;border-right-color:#c3c3c3;border-bottom-width:1px;border-bottom-style:solid;border-bottom-color:#c3c3c3;border-top-width:1px;border-top-style:solid;border-top-color:#c3c3c3;"}, {
    	XMLElement["img", {"src"->"http://www.wolfram.com/common/images/spacer.gif","height"->"15","width"->"1","border"->"0"}, {}],
    	XML`RawXML["<br>"],
		XMLElement["img", {"src"->"http://msgcache.wolfram.com/wolfram-insider/images/"<>featureimage,"alt"->featureimagealt,"title"->featureimagealt}, {}],
    	Transmogrify[body],
    	XMLElement["img", {"src"->"http://www.wolfram.com/common/images/spacer.gif","height"->"15","width"->"1","border"->"0"}, {}]
    	}],
     XML`RawXML["<br>"]
    }]

],
								
{Cell, "WolframInsiderFeatureSection"}:>XMLElement["img", {"src"->"http://msgcache.wolfram.com/wolfram-insider/images/blog.gif", "alt"->"From the Wolfram Blog", "title"->"From the Wolfram Blog"},{}],
	
{Cell, "WolframInsiderFeatureText"}:>XMLElement["p", {"style"->"font-family: Arial,Verdana,sans-serif; font-size: 13px; margin: 0px 15px; padding-top: 8px;"}, {
	Recurse[]}],
	
{Cell, "WolframInsiderFeatureListItemDateLocation"}:>XMLElement["p", {"style"->"font-family: Arial,Verdana,sans-serif; font-size: 11px; margin: 0px 15px; color: rgb(102, 102, 102);"}, {
	Recurse[]}],


{Cell, "WolframInsiderColumn"}:> Unevaluated@Sequence[],


{Cell, "WolframInsiderColumn"}:> Unevaluated@Sequence[],
{Cell, "WolframInsiderTable"}:> Unevaluated@Sequence[], 
{Cell, "WolframInsiderTableSeparator"}:> Unevaluated@Sequence[],
{Cell, "WolframInsiderImageTitle"}:> Unevaluated@Sequence[],




{ButtonBox}:> Module[{bdata,buttonStyle},
	
	buttonStyle=GetOption[BaseStyle];
	bdata=GetOption[ButtonData]; 
	
	RewriteHyperlinkString[a_String]:= Module[{char},
		char="\[RightGuillemet]";
		If[StringFreeQ[a, char], a, 
			Which[StringTake[a, -1]==="\[RightGuillemet]", 
				XMLElement["span", {}, {StringDrop[a, -1], XMLElement["span", {"style"->"color: rgb(224, 4, 0);"}, {char
					}]  }],
			True, a]
			]
	];
	
	RewriteHyperlinkString[b__XMLElement]:=b; 
	
	RewriteHyperlinkString[a__String, b:XMLElement["br",{},{}], c__String]:= Which[StringTake[c, -1]==="\[RightGuillemet]", 
				XMLElement["span", {}, {a, b, StringDrop[c, -1], XMLElement["span", {"style"->"color: rgb(224, 4, 0);"}, {"\[RightGuillemet]"
					}]  }],
				True, XMLElement["span", {"style"->"color: rgb(224, 4, 0);"}, {a,b,c}
					]];
	
	RewriteHyperlinkString[a__String, b__XMLElement, c___String]:= Apply[RewriteHyperlinkString[#]&, {a,b,c}];
	
	RewriteHyperlinkString[a:XML`RawXML[__], b__String]:=Apply[RewriteHyperlinkString[#]&, {a,b}];
	
	RewriteHyperlinkString[a:XML`RawXML[__], b__String]:=Sequence[RewriteHyperlinkString[a], RewriteHyperlinkString[b]];
	
	RewriteHyperlinkString[a:XML`RawXML[_]]:=a;
	
			
	Switch[buttonStyle,
		"H2Hyperlink",
	XMLElement["a", {"href"->bdata, "target"->"_blank", "style"->"color: rgb(0, 0, 0); outline: medium none; text-decoration: none;"}, {
		Recurse[]}],
		"H3Hyperlink",
	XMLElement["a", {"href"->bdata, "target"->"_blank", "style"->"color: rgb(0, 0, 0); outline: medium none; text-decoration: none;"}, {
		Recurse[]}],
		"NewHyperlink", 
	XMLElement["a", {"href" ->bdata, "target"->"_blank", "style"->"color: rgb(34, 34, 34); outline: medium none; text-decoration: none;"}, {
		RewriteHyperlinkString[ Recurse[] ]}], 
	    "InternalPageLink",  
	XMLElement["a", {"href"->bdata, "style"->"color: rgb(224, 4, 0); outline: medium none; text-decoration: none;"}, {
		Recurse[]}],
		_,
	XMLElement["a", {"href"->bdata, "target"->"_blank", "style"->"color: rgb(224, 4, 0); outline: medium none; text-decoration: none;"}, {
		Recurse[]}]
	]
	

],




{FormBox}:>Block[{traditionalFormQ},
	traditionalFormQ = If[GetStyle[] === TraditionalForm, True, False];
Recurse[]
]


}, 

IncludeXMLTransforms -> {{"HTML","Components","Includes.m"}},
DefaultParameters -> { "newline2br" -> False, "newline2div" -> False}

]
