(* :Title: Functions.m *)

(* :Author:
  Andrew Hunt, andy@wolfram.com
  Greg Martel, gregm@wolfram.com
*)

(* :Mathematica Version: 5 *)
(* :Package Version: $Revision: 1.54.2.3 $ $Date: 2016/11/05 23:47:27 $ *)                  
(* :Copyright: (c) 2005, Wolfram Research, Inc. All rights reserved. *)
(* :Summary: Add-ons specific rules and general transform for Mathematica Documentation *)

(* :Title: Functions.m *)

XMLTransform[{

(* Remove in-product decorations *)

{Cell, "NotebookImage"} :> 
DIV[{"class"->"NotebookImage"}, {
  transmogrifyImage[ToFileName[{"Files", GetFileNameBase[]},
   IncrementCounter["Image"] <> ".gif"], {"alt"->"", "title"->""},
   Inline -> True
  ]
}],
(*{Cell, "NotebookImage"} :> 
Span[{"class"->"NotebookImage"}, {
  transmogrifyImage[ToFileName[{"Files", GetFileNameBase[]},
   IncrementCounter["Image"] <> ".gif"],
   Inline -> True
  ]
}],*)

{Cell, "PackageHeader"} :> Unevaluated[Sequence[]],

{Cell, "ObjectNameGrid"} :>  Block[{objgrid = True}, Recurse[] ],
  

{Cell, "ObjectName" | "ObjectNameSmall" | "ObjectNameAlt"} :> 
 XMLElement["h1", {}, {Recurse[]}],
 
 
{Cell, "IndicatorUsage"} :> XMLElement["div", {"class"->"indicatorIntroWrap"}, {XMLElement["div", {"class"->"indicatorIntro"}, {Recurse[]}]}],
 
 {CellGroupData, "IndicatorUsage"} :>  {Transmogrify[First[SelectChildren[]]],
	XMLElement["ul", {"class"->"functionList afterIntro"}, {Transmogrify[Rest[SelectChildren[]]]}]},  

{Cell, "IndicatorUsage"} :>  Module[{}, XMLElement["div", {"class"->"indicatorIntroWrap"}, 
	{XMLElement["div", {"class"->"indicatorIntro"}, {Recurse[]}]}]],
	
(* HowTo styles *)
{Cell, "HowToTitle"} :> H1[{}, {Recurse[]}],
{Cell, "HowToTitlePrefix"} :> {XMLElement["span", {}, {Recurse[]}], XMLElement["span", {"class"->"titleSep"}, {XML`RawXML["|"]}]},
{Cell, "HowToAbstract"} :> P[{"class" -> "intro"}, {Recurse[]}],
{Cell, "HowToScreencastLink"} :> Module[{iconText,iconSource,bdata,h,w},
  bdata = First[Cases[SelectSelf[], (ButtonData->{URL[bbdd_], _}) :> bbdd, Infinity, 1]];
  {w,h} = First[Cases[SelectSelf[], Rule[ImageSizeRaw,{width_, height_}] :> {ToString[width], ToString[height]}, Infinity, 1]];
  If[StringMatchQ[bdata, __~~"vimeo"~~__],
  XMLElement["div", {"class"->"embedWrap"}, {
      	XMLElement["iframe", {"src"->"//player.vimeo.com/video/"<>Last[StringSplit[bdata, "/"]], "width"->w, "height"->h, "frameborder"->"0", "webkitallowfullscreen"->"","mozallowfullscreen"->"","allowfullscreen"->""}, {""}]
      	}],
      	XMLElement["div", {"class"->"embedWrap"}, {
      	XML`RawXML["<!--#include virtual=\"/common/video/includes/embed.php?v="<>StringReplace[StringCases[bdata,"v=" ~~ DigitCharacter ..], "v="->""]<>"&share=false\"-->"],
      	 XMLElement["div", {"id"->"videoplayer"}, {XML`RawXML[""]}]
      	}]]
],

{Cell, "DeviceSubtitle"} :> XMLElement["span", {"class"->"DeviceSubtitle"}, {Recurse[]}],
{Cell, "InterpreterSubtitle"} :> XMLElement["span", {"class"->"InterpreterSubtitle"}, {Recurse[]}],

{CellGroupData, "DeviceList"} :> XMLElement["ul", {"class"->"DeviceList"}, {Recurse[]}],

{Cell, "DeviceList"} :> Sequence[],

{CellGroupData, "FormatList"} :> XMLElement["ul", {"class"->"FormatList"}, {Recurse[]}],

{Cell, "FormatList"} :> Sequence[],

{Cell, "ScreencastPointerText"} :> P[{"class" -> GetStyle[]}, {Recurse[]}],
(* end howto styles *)
{Cell, "HowToText"} :> P[{"class" -> GetStyle[]}, {Recurse[]}],

{Cell, "HowToDelimiter"} :> XMLElement["div", {"class"->"HowToDelimiter"}, {Recurse[]}],

{Cell, "History"} :>  
If[MemberQ[exceptionsList, GetParameter["entityType"] ],
  DIV[{"class"->"modified"}, {Recurse[]}], 
  DIV[{"class"->"modified"}, {Recurse[]}]   
  ],
  
  
 {Cell, "AwaitingReviewNote"} :>  XMLElement["div", {"class"->"AwaitingReviewNote"}, {Recurse[]}],


{Cell, "CharacterImage"}:> 
Block[{CharacterImageData, CharacterImageDataLeft, CharacterImageDataRight},
CharacterImageData = SelectSelf[];
CharacterImageDataLeft={Transmogrify[Cell[BoxData[CharacterImageData[[1, 1, 1, 1, 1]]], "CharacterImageLeftSide"]]};
CharacterImageDataRight={Transmogrify[Cases[CharacterImageData[[1, 1, 1, 1, 2]], Cell[___, "CharacterNotes", ___], Infinity]]};
XMLElement["div", {"class"->"functionIntroWrap"}, {
	XMLElement["div", {"class"->"functionIntro"}, 
	{XMLElement["table", {}, {XMLElement["tr", {}, Flatten[{XMLElement["td", {"class"->"character-img"}, Flatten[{CharacterImageDataLeft}]], 
	XMLElement["td", {}, {XMLElement["ul", {"class"->"functionList afterIntro"}, Flatten[{CharacterImageDataRight}]]}]}]]}]}]}]
 ],   


{Cell, "CharacterImageLeftSide"}:> transmogrifyImage[ToFileName[{"Files", GetFileNameBase[]},
   "characterimage_"<>IncrementCounter["CharacterImage"] <> ".gif"], {"alt"->"", "title"->""},
   Inline -> True
  ],
  
{Cell, "CharacterNotes"}:> XMLElement["li", {}, {Recurse[]}],

{Cell, "CharacterName"}:> H1[{}, {Recurse[]} ],
 



{Cell, "1ColumnTableMod"
  | "2ColumnTable"
  | "3ColumnTable"
  | "2ColumnTableMod"
  | "3ColumnTableMod"
  | "3ColumnIllustratedTableMod"} :> Li[{"class"->"NotesTable"}, {DocumentationBuild`Utils`AddSpans[Recurse[]]}], 


{Cell,  "AlphabeticalListingTable"} :>
P[ {"class" -> "MathTable", "name" -> (GetStyle[]/.None->"FIXME")}, 
  {Recurse[]}
], 


(***** Cell Definitions *****)

{Cell, "Usage" | "DeviceDoubleUsage"} :> (
usageContent := XMLElement["div", {"class" -> "functionIntroWrap"},
Block[{usagegrid = True},
    Module[{xml = {Recurse[]}, pos, repl, first = True, versionNumber, modinfobackground,modinfoposition},
    modinfobackground=Cases[GetOption[GridBoxOptions], Rule["Rows", a__]:>a, Infinity];
    modinfobackground=Map[MemberQ[{#}, Dynamic[__]] &, Flatten[modinfobackground]];
    versionNumber = StringSplit[$Version, "."][[1]];
    pos = Position[xml, XMLElement["tr", _, _], Infinity];
    modinfoposition=Pick[pos, modinfobackground];
    repl = Map[
        Module[{tr, attr, children, modinfo},
            tr = Extract[xml, #];
            modinfo = False;
            modinfo = If[MemberQ[modinfoposition, #], True, False];
            attr = Join[
                DeleteCases[tr[[2]], _["name"|"id", _]],
                If[modinfo, {}(*{"name"->"ModInfo_"<>versionNumber, "id"->"ModInfo_"<>versionNumber}*), {}] ];
            If[first,
                first = False,
                attr = Join[
                    DeleteCases[attr, _["class", _]],
                    {}]];
            children = Map[
                Function[{td}, Module[{attr},
                    attr = td[[2]];
                    If[MatchQ[attr, {___, "class" -> _, ___}],
                        attr = ReplaceAll[attr, _["class", _] -> ("class" -> "UM")],
                        attr = Join[attr, {}]];
                    attr = Join[
                        DeleteCases[attr, _["name"|"id", _]],
                        If[modinfo, {"name"->"ModInfo_"<>versionNumber, "id"->"ModInfo_"<>versionNumber}, {}] ];
                    XMLElement["p", {}, td[[3]]]
                ]],
                Rest[tr[[3]]] ];
            XMLElement["div", {"class"->"functionIntro"<>If[modinfo, " modified-text", ""]}, children]
        ]&,
        pos];
        repl]]
];

usageContent
), 




{CellGroupData, "UsageSection" | 
	"LegacyMaterialSection" | 
	"ApplicationNotesSection" | 
	"ExtensionsSection" | 
	"DesignDiscussionSection"  | 
	"TutorialMoreAboutSection" | 
	"TutorialCollectionSection"} :> 
Recurse[],  

{CellGroupData, "SeeAlsoSection"} :> XMLElement["div", {"class"->"expandWrap", "id"->"SeeAlso"},
	{XMLElement["div", {"class"->"expandOuter"},{
		XMLElement["h2", {"class"->"expandInner"}, {
			XMLElement["a", {"class"->"expand hide", "title"->Localized["show", GetParameter["language"]], "href"->"#"},{Localized["SeeAlsoSectionText", GetParameter["language"]]}], 
			XMLElement["a", {"class"->"collapse", "title"->Localized["hide", GetParameter["language"]], "href"->"#"},{Localized["SeeAlsoSectionText", GetParameter["language"]]}]}], 
			XMLElement["div",{"class"->"expanded"},{Recurse[]}]}]}], 


{CellGroupData, "TutorialsSection"} :> XMLElement["div", {"class"->"expandWrap", "id"->"Tutorials"},
	{XMLElement["div", {"class"->"expandOuter"},{
		XMLElement["h2", {"class"->"expandInner"}, {
			XMLElement["a", {"class"->"expand hide", "title"->Localized["show", GetParameter["language"]], "href"->"#"},{Localized["TutorialsSectionText", GetParameter["language"]]}], 
			XMLElement["a", {"class"->"collapse", "title"->Localized["hide", GetParameter["language"]], "href"->"#"},{Localized["TutorialsSectionText", GetParameter["language"]]}]}], 
			XMLElement["div",{"class"->"expanded"},{XMLElement["ul",{"class"->"functionList"},{Recurse[]}]}]}]}], 
			
{CellGroupData, "RelatedTutorialsSection"} :> XMLElement["div", {"class"->"expandWrap", "id"->"RelatedTutorials"},
	{XMLElement["div", {"class"->"expandOuter"},{
		XMLElement["h2", {"class"->"expandInner"}, {
			XMLElement["a", {"class"->"expand hide", "title"->Localized["show", GetParameter["language"]], "href"->"#"},{Localized["RelatedTutorialsSectionText", GetParameter["language"]]}], 
			XMLElement["a", {"class"->"collapse", "title"->Localized["hide", GetParameter["language"]], "href"->"#"},{Localized["RelatedTutorialsSectionText", GetParameter["language"]]}]}], 
			XMLElement["div",{"class"->"expanded"},{XMLElement["ul",{"class"->"functionList"},{Recurse[]}]}]}]}], 

{CellGroupData, "RelatedLinksSection" | "TutorialRelatedLinksSection"} :> XMLElement["div", {"class"->"expandWrap", "id"->"RelatedLinks"},
	{XMLElement["div", {"class"->"expandOuter"},{
		XMLElement["h2", {"class"->"expandInner"}, {
			XMLElement["a", {"class"->"expand hide", "title"->Localized["show", GetParameter["language"]], "href"->"#"},{Localized["RelatedLinksSectionText", GetParameter["language"]]}], 
			XMLElement["a", {"class"->"collapse", "title"->Localized["hide", GetParameter["language"]], "href"->"#"},{Localized["RelatedLinksSectionText", GetParameter["language"]]}]}], 
			XMLElement["div",{"class"->"expanded"},{XMLElement["ul",{"class"->"functionList"},{Recurse[]}]}]}]}],
			
{CellGroupData, "MoreAboutSection"} :> XMLElement["div", {"class"->"expandWrap", "id"->"RelatedGuides"},
	{XMLElement["div", {"class"->"expandOuter"},{
		XMLElement["h2", {"class"->"expandInner"}, {
			XMLElement["a", {"class"->"expand hide", "title"->Localized["show", GetParameter["language"]], "href"->"#"},{Localized["MoreAboutSectionText", GetParameter["language"]]}], 
			XMLElement["a", {"class"->"collapse", "title"->Localized["hide", GetParameter["language"]], "href"->"#"},{Localized["MoreAboutSectionText", GetParameter["language"]]}]}], 
			XMLElement["div",{"class"->"expanded"},{XMLElement["ul",{"class"->"functionList"},{Recurse[]}]}]}]}], 

{CellGroupData, "NotesSection" } :> Module[{nstitle}, nstitle = Flatten[{Transmogrify[First[SelectChildren[]]]}];
	XMLElement["div", {"class"->"expandWrap closed", "id"->"DetailsAndOptions"},
	{XMLElement["div", {"class"->"expandOuter"},{
		XMLElement["h2", {"class"->"expandInner"<>If[GetParameter["modifiednotesQ"]==="True", " modified-text", ""]}, {
			XMLElement["a", {"class"->"expand hide", "title"->Localized["show", GetParameter["language"]], "href"->"#"},nstitle], 
			XMLElement["a", {"class"->"collapse", "title"->Localized["hide", GetParameter["language"]], "href"->"#"},nstitle]}], 
			XMLElement["div",{"class"->"expanded"},{XMLElement["ul",{"class"->"functionList"}, Flatten[{Transmogrify[Rest[SelectChildren[]]]}]]}]}]}]],

{CellGroupData, "FunctionEssaySection" } :> Module[{nstitle}, nstitle = Flatten[{Transmogrify[First[SelectChildren[]]]}];
	XMLElement["div", {"class"->"expandWrap closed", "id"->"FunctionEssay"},
	{XMLElement["div", {"class"->"expandOuter"},{
		XMLElement["h2", {"class"->"expandInner"}, {
			XMLElement["a", {"class"->"expand hide", "title"->Localized["show", GetParameter["language"]], "href"->"#"},nstitle], 
			XMLElement["a", {"class"->"collapse", "title"->Localized["hide", GetParameter["language"]], "href"->"#"},nstitle]}], 
			XMLElement["div",{"class"->"expanded"},{XMLElement["ul",{"class"->"functionList"}, Flatten[{Transmogrify[Rest[SelectChildren[]]]}]]}]}]}]],

{CellGroupData, "FormatBackground" } :> Module[{},
	XMLElement["div", {"class"->"expandWrap closed", "id"->"FormatBackground"},
	{XMLElement["div", {"class"->"expandOuter"},{
		XMLElement["h2", {"class"->"expandInner"}, {
			XMLElement["a", {"class"->"expand hide", "title"->Localized["show", GetParameter["language"]], "href"->"#"},{Localized["FormatBackgroundSectionText", GetParameter["language"]]}], 
			XMLElement["a", {"class"->"collapse", "title"->Localized["hide", GetParameter["language"]], "href"->"#"},{Localized["FormatBackgroundSectionText", GetParameter["language"]]}]}], 
			XMLElement["div",{"class"->"expanded"},{XMLElement["ul",{"class"->"functionList"}, Flatten[{Transmogrify[Rest[SelectChildren[]]]}]]}]}]}]],

{CellGroupData, "EmbeddingFormatSection" } :> Module[{efstitle}, efstitle = Flatten[{Transmogrify[First[First[First[SelectChildren[]]]]]}];
	XMLElement["div", {"class"->"expandWrap closed"},
	{XMLElement["div", {"class"->"expandOuter"},{
		XMLElement["h2", {"class"->"expandInner"}, {
			XMLElement["a", {"class"->"expand hide", "title"->Localized["show", GetParameter["language"]], "href"->"#"},efstitle], 
			XMLElement["a", {"class"->"collapse", "title"->Localized["hide", GetParameter["language"]], "href"->"#"},efstitle]}], 
			XMLElement["div",{"class"->"expanded"},{XMLElement["ul",{"class"->"functionList"}, Flatten[{Transmogrify[Rest[SelectChildren[]]]}]]}]}]}]],

{CellGroupData, "ImportExportSection" } :> XMLElement["div", {"class"->"expandWrap closed", "id"->"ImportAndExport"},
	{XMLElement["div", {"class"->"expandOuter"},{
		XMLElement["h2", {"class"->"expandInner"}, {
			XMLElement["a", {"class"->"expand hide", "title"->Localized["show", GetParameter["language"]], "href"->"#"},{Localized["ImportExportSectionText", GetParameter["language"]]}], 
			XMLElement["a", {"class"->"collapse", "title"->Localized["hide", GetParameter["language"]], "href"->"#"},{Localized["ImportExportSectionText", GetParameter["language"]]}]}], 
			XMLElement["div",{"class"->"expanded"},{XMLElement["ul",{"class"->"functionList"},{Recurse[]}]}]}]}],

{CellGroupData, "ElementsSection" } :> 
    XMLElement["div", {"class"->"expandWrap", "id"->"Elements"},
	{XMLElement["div", {"class"->"expandOuter"},{
		XMLElement["h2", {"class"->"expandInner"}, {
			XMLElement["a", {"class"->"expand hide", "title"->Localized["show", GetParameter["language"]], "href"->"#"},{Localized["ElementsSectionText", GetParameter["language"]]}], 
			XMLElement["a", {"class"->"collapse", "title"->Localized["hide", GetParameter["language"]], "href"->"#"},{Localized["ElementsSectionText", GetParameter["language"]]}]}], 
			XMLElement["div",{"class"->"expanded"},{XMLElement["ul",{"class"->"functionList"},{Recurse[]}]}]}]}],

{CellGroupData, "OptionsSection" } :> XMLElement["div", {"class"->"expandWrap closed", "id"->"Options"},
	{XMLElement["div", {"class"->"expandOuter"},{
		XMLElement["h2", {"class"->"expandInner"}, {
			XMLElement["a", {"class"->"expand hide", "title"->Localized["show", GetParameter["language"]], "href"->"#"},{Localized["OptionsSectionText", GetParameter["language"]]}], 
			XMLElement["a", {"class"->"collapse", "title"->Localized["hide", GetParameter["language"]], "href"->"#"},{Localized["OptionsSectionText", GetParameter["language"]]}]}], 
			XMLElement["div",{"class"->"expanded"},{XMLElement["ul",{"class"->"functionList"},{Recurse[]}]}]}]}],
			
{CellGroupData, "NotebookInterfaceSection" } :> XMLElement["div", {"class"->"expandWrap closed", "id"->"NotebookInterface"},
	{XMLElement["div", {"class"->"expandOuter"},{
		XMLElement["h2", {"class"->"expandInner"}, {
			XMLElement["a", {"class"->"expand hide", "title"->Localized["show", GetParameter["language"]], "href"->"#"},{Localized["NotebookInterfaceSectionText", GetParameter["language"]]}], 
			XMLElement["a", {"class"->"collapse", "title"->Localized["hide", GetParameter["language"]], "href"->"#"},{Localized["NotebookInterfaceSectionText", GetParameter["language"]]}]}], 
			XMLElement["div",{"class"->"expanded"},{XMLElement["ul",{"class"->"functionList"},{Recurse[]}]}]}]}],

{CellGroupData, "DeviceSubsection" } :> Module[{dstitle}, dstitle = Flatten[{Transmogrify[First[First[SelectChildren[]]]]}];
	XMLElement["div", {"class"->"expandWrap", "id"->"Elements"},
	{XMLElement["div", {"class"->"expandOuter"},{
		XMLElement["h2", {"class"->"expandInner"}, {
			XMLElement["a", {"class"->"expand hide", "title"->Localized["show", GetParameter["language"]], "href"->"#"},dstitle], 
			XMLElement["a", {"class"->"collapse", "title"->Localized["hide", GetParameter["language"]], "href"->"#"},dstitle]}], 
			XMLElement["div",{"class"->"expanded"},{XMLElement["ul",{"class"->"functionList"},{Recurse[]}]}]}]}]],

{CellGroupData, "RelatedInterpreterSection" } :> Module[{dstitle}, dstitle = Flatten[{Transmogrify[First[First[SelectChildren[]]]]}];
	XMLElement["div", {"class"->"expandWrap"},
	{XMLElement["div", {"class"->"expandOuter"},{
		XMLElement["h2", {"class"->"expandInner"}, {
			XMLElement["a", {"class"->"expand hide", "title"->Localized["show", GetParameter["language"]], "href"->"#"},dstitle], 
			XMLElement["a", {"class"->"collapse", "title"->Localized["hide", GetParameter["language"]], "href"->"#"},dstitle]}], 
			XMLElement["div",{"class"->"expanded"},{XMLElement["ul",{"class"->"functionList"},{Recurse[]}]}]}]}]],

{CellGroupData, "InterpreterSection" } :> Module[{dstitle}, dstitle = Flatten[{Transmogrify[First[First[SelectChildren[]]]]}];
	XMLElement["div", {"class"->"expandWrap closed"},
	{XMLElement["div", {"class"->"expandOuter"},{
		XMLElement["h2", {"class"->"expandInner"}, {
			XMLElement["a", {"class"->"expand hide", "title"->Localized["show", GetParameter["language"]], "href"->"#"},dstitle], 
			XMLElement["a", {"class"->"collapse", "title"->Localized["hide", GetParameter["language"]], "href"->"#"},dstitle]}], 
			XMLElement["div",{"class"->"expanded"},{XMLElement["ul",{"class"->"functionList"},{Recurse[]}]}]}]}]],
	
{CellGroupData, "RelatedDemonstrationsSection"} :> XMLElement["div", {"class"->"expandWrap", "id"->"RelatedDemonstrations"},
	{XMLElement["div", {"class"->"expandOuter"},{
		XMLElement["h2", {"class"->"expandInner"}, {
			XMLElement["a", {"class"->"expand hide", "title"->Localized["show", GetParameter["language"]], "href"->"#"},{"Related Demonstrations"}], 
			XMLElement["a", {"class"->"collapse", "title"->Localized["hide", GetParameter["language"]], "href"->"#"},{"Related Demonstrations"}]}], 
			XMLElement["div",{"class"->"expanded"},{XMLElement["ul",{"class"->"functionList"},{Recurse[]}]}]}]}], 

{Cell, "UsageSection" | "LegacyMaterialSection" | "ApplicationNotesSection" | "DesignDiscussionSection" | "ExtensionsSection" 
} :> 
Module[{name, style, ex, versionNumber},
versionNumber = StringSplit[$Version, "."][[1]];
style = GetStyle[];
Which[ style === "ElementsSection", name = "ELMS",  
style === "ExtensionsSection", name = "EXTS",  
True, name = StringJoin@Flatten@{If[First@ToCharacterCode[#] < 91, #, ""] & /@ Characters[ GetStyle[] ]};
];
ex = If[MemberQ[
  {"NotesSection", "ImportExportSection", "NotebookInterfaceSection", "ElementsSection", "DeviceSubsection", "OptionsSection"},
  style], "closed", "open"];
A[{"name" -> GetStyle[], "id"->"hello" }, {
  DIV[ 
  	(*If[name==="NS",{"class" -> name<>"H", "id"->"ModInfo_"<>versionNumber, "name"->"ModInfo_"<>versionNumber},{"class" -> name<>"H" }]*)
  	{"class" -> name<>"H"}
  	, {
    A[{"href" -> ("javascript:toggle('" <> name <> "')"), "onmouseover" -> "javascript:return(true);" }, {
    Img[{"src"->(GetParameter["htmlBase"]<>"/mathematicaImages/"<>ex<>"SectionGroup.gif"), "id"->name<>"_", "border"->"0", "width"->"8", "height"->"8", "alt"->""}], 
      " ",
      Span[{"class"->name<>"Span"}, { Recurse[] }]
    }]
  }]
}] ],

{Cell, "RelatedInterpreterSection" | "InterpreterSection" | "EmbeddingFormatSection" | "DeviceSubsection" | "MoreAboutSection" | "SeeAlsoSection" | "TutorialsSection" | "RelatedLinksSection" | "RelatedTutorialsSection" | "TutorialRelatedLinksSection" | "TutorialMoreAboutSection" | "RelatedDemonstrationsSection" | "TutorialCollectionSection" | "ElementsSection" | "ImportExportSection" | "NotebookInterfaceSection" | "OptionsSection"} :> Unevaluated[Sequence[]],

{Cell,"NotesSection"} :> Recurse[],

(* for some reason <p class="ExampleDelimiter" /> doesn't bode well with browsers.
   therefore, I have added a " " *)
{Cell, "ExampleDelimiter"} :> 
DIV[{"class" -> "ExLine"}, {XML`RawXML["<!-- -->"]}],

{Cell, "ExampleDelimiterInput"} :> 
DIV[{"class" -> "ExLineI"}, {XML`RawXML["<!-- -->"]}],

{Cell, "MoreAbout" | "TutorialMoreAbout" | "Tutorials" | "RelatedDemonstrations" | "RelatedLinks" | "LegacyMaterial" | 
"ApplicationNotes" | "DesignDiscussion" | "Extensions"} :> 
  Li[{}, {Recurse[]}],
  
{Cell, "TutorialCollection"} :> Unevaluated[Sequence[]],
(* Scale picture smaller *)
(* TODO find more suitable alt & title tags for GraphicsData and RawData *)
{Cell, "Picture"} :> (
XMLElement["img", {
            "src" -> ("URL" /. #), "width" -> ("Width" /. #), 
            "height" -> ("Height" /. #), 
            "class"->If[GetParameter["entityType"]==="HowTo","HowToPicture",""],
            (*"width" -> ToString[Floor[.89 ToExpression["Width" /. #]]],
            "height" -> ToString[Floor[.89 ToExpression["Height" /. #]]],*)
            "alt" -> ""
          }, {}]&[
           BoxToImage[ToFileName[{"Files", GetFileNameBase[]},
              "Image_" <> IncrementCounter["Image"] <> ".gif"],
            Inline -> False, MaxImageSize->580, CropImage -> False]
          ]),


{Cell, "FlushInput"} :>
  WithParameters[{"newline2br" -> True},
    XMLElement["p", {"class" -> "StandardForm", "id" -> GetStyle[]}, {
      XMLElement["b", {}, {Recurse[]}]}
      ] ],


(* Change bullets between 'see also' items *)

{StyleBox, "InlineSeparator"} :> 
  Span[{"class" -> "inlineSeparator"}, {
    Img[{"src" -> GetParameter["htmlBase"]<>"/mathematicaImages/bullet.gif", "style"->"vertical-align:middle;", "width"->"4", "height"->"4", "alt"->"bullet", "title"->"bullet"}] }],

{Cell, "SeeAlso"} :> XMLElement["p", {"class"->"inlineFunctionList"}, {Recurse[]}],

{Cell, "RelatedInterpreters"} :> XMLElement["p", {"class"->"inlineFunctionList"}, {Recurse[]}],

{FormBox} :> Module[{boxChildren,traditionalFormQ,altTag},
boxChildren=SelectChildren[];
traditionalFormQ = If[GetStyle[] === TraditionalForm, True, False];
altTag = DocumentationBuild`Utils`CellToString@SelectSelf[];
If[MatchQ[boxChildren, {"Mathematica"}],Transmogrify[StyleBox["Mathematica", FontSlant->"Italic"]],
If[MatchQ[boxChildren, {StyleBox[_, "KeyEvent", ___]}], Transmogrify[boxChildren],
transmogrifyImage[ToFileName[{"Files", GetFileNameBase[]},
  IncrementCounter["Image"] <> ".png"], {"style"->"vertical-align:middle;", "alt"->altTag, "title"->altTag}, Inline -> True, ImageFormat -> "PNG", TransparentBackground->True, ConversionOptions->{Background->None}
]
]
]
],

 
(* TODO find more suitable alt & title tags for GraphicsData and RawData *)
{GraphicsData | RawData} :>  
transmogrifyImage[ToFileName[{"Files", GetFileNameBase[]},
  IncrementCounter["Image"] <> ".gif"], {"alt" -> "", "title" -> ""},
  Inline -> True
],


{OutputFormData} :> Transmogrify[SelectChildren[][[2]]],

(* wolframscript *)

{Cell, "ProgramName"} :> DIV[{"class" -> "main-heading"}, {H1[ {}, {Recurse[]}]}],
{Cell, "ProgramSection"} :> H2[ {}, {Recurse[]}],
{Cell, "ProgramSubsection"} :> H3[ {}, {Recurse[]}],
{Cell, "ProgramCodeText"} :> XMLElement["code", {}, {Recurse[]}],
{StyleBox, "ProgramCodeText"} :> XMLElement["strong", {}, {XMLElement["code", {}, {Recurse[]}]}],
{Cell, "ProgramInputOnly"} :> XMLElement["pre", {}, {XMLElement["code", {}, {Recurse[]}]}],
{Cell, "Script"} :> DIV[{"class" -> "with-file"}, {Span[{"class" -> "file-name"}, {"file.wls"}], XMLElement["pre", {}, {XMLElement["code", {}, {Recurse[]}]}]}],

{Cell, "ProgramNotes"} :> P[{"class" -> "code"}, {Recurse[]}],
{Cell, "ProgramNotesDescriptionSection"} :> P[{}, {Recurse[]}],
{Cell, "ProgramNotesExamplesSection"} :> P[{}, {Recurse[]}],
{Cell, "ProgramNotesDetailsSection"} :> P[{}, {Recurse[]}]

},

IncludeXMLTransforms -> {{"HTML","Components","Includes.m"}},

DefaultParameters -> {
  (*  "newline2br" -> False,  *)
  "newline2br" -> False,
  "newline2div" -> False,
  "styleUsageMessageBreak" -> "</div>\n<div class=\"usageDelimiter\" > </div><div class=\"UM\">",


  (* No Operation code *)
  "noop" -> {
    $CreateCompleteHTMLFile = False;
    $LanguageExtension := Switch[GetParameter["language"], "Japanese", "ja", "ChineseSimplified", "zh", 
    	"Spanish", "es", _, "en"];
(* exceptionsList:= {True}, *)
    exceptionsList:= {"Symbol", "Menu Item", "File", "System Program", "Front End Object", 
    	"MathLink C Function", "LibraryLink C Function","System Program", "Widget", "Message", "Indicator"}; 
  }
},

CounterReassignments -> {{"Chapter", "Section"}, {"Section", "Subsection"}, {"Subsection", "Subsubsection"}}

]