XMLTransform[{

{GridBox} :> Block[{neaCell,tablestyle,gridboxdividers},
neaCell=SelectNearestAncestor[Cell];
tablestyle=GetStyle[neaCell];
gridboxdividers = Cases[neaCell, rl:Rule[GridBoxDividers,x__List], Infinity];

WithParameters[{
    "text-align" -> Module[{align, rowc, colc},
      align = GetOption[GridBoxAlignment];
      If[MatchQ[align, {___, "Columns" -> _, ___}],
        align = "Columns" /. align,
        align = GetOption[ColumnAlignments]
      ];
      If[!ListQ[align], align = {align}];
      align = If[ListQ[#], #, {#}]& /@ align;
      If[align==={{Right},{Left}}&&MemberQ[{"FramedBox","DefinitionBox"}, tablestyle],
      Table[Flatten[align], {i, Length[SelectGridRows[]]}],
      Table[(#[[Mod[c, Length[#]] + 1]])&[align[[Mod[r, Length[align]] + 1]] ],
        {r, 0, Length[SelectGridRows[]] - 1},
        {c, 0, Length[SelectGridColumns[]] - 1}]
      ]
    ],
	"widths" -> Block[{cInfo},
	
	cInfo=Cases[neaCell, rl:Rule["Columns",x_List]/;MatchQ[ x[[1]], Scaled[_]], Infinity];
	cInfo=If[cInfo==={},False,cInfo[[1,2]]];
	cInfo=If[cInfo===False,False,Flatten@Map[Cases[#, _]&, cInfo]];
	If[cInfo===False, (GetStyle[neaCell] /. tableColumnWidths /. _String -> None), cInfo]
],
	"rowlinesinit" -> Block[{gbDividerInfo},
		gbDividerInfo=Cases[neaCell, rl:Rule[GridBoxDividers,x__List], Infinity ];
		gbDividerInfo=
		If[gbDividerInfo==={}||MemberQ[{"2ColumnTableMod","3ColumnTableMod","3ColumnIllustratedTableMod""Usage"},tablestyle],{},First@Cases[gbDividerInfo, rul:Rule["Rows",x__List]->x, Infinity ]];
	gbDividerInfo],   
	"checklist" -> Take[SelectGridRows[], 1],
	"tablestyle" ->  tablestyle
	},
	
	WithParameters[{
	Module[{rowlinesinit(*,rangeLength,rangey,iList*)},
		rowlinesinit = Flatten[GetParameter["rowlinesinit"]];
		
	"rowlines" -> Map[
			Switch[rowlinesinit,
				None | {}, False,
				_List, rowlinesinit[[Mod[#-1, Length[rowlinesinit]] + 1]],
				_, rowlinesinit
			]&,
			Range[Length[SelectGridRows[]]]
		]   
	] 
	},

	Block[{rowspans, colspans, versionNumber},
		versionNumber = StringSplit[$Version, "."][[1]];
		Module[{rowtop, coltop},
			rowspans[_] := 0;
			colspans[_] := 0;
			MapIndexed[
				Function[{cont, pos}, Which[
					cont === "\[SpanFromLeft]", colspans[rowtop]++,
					cont === "\[SpanFromAbove]", rowspans[coltop[Last[pos]]]++,
					cont =!= "\[SpanFromBoth]", (
						rowtop = coltop[Last[pos]] = pos;
						rowspans[pos] = colspans[pos] = 1;
				)]],   
				First[SelectSelf[]], {2}];
		];

If[MemberQ[{"ObjectNameGrid","GuideTitleGrid"}, GetParameter["tablestyle"]],
XMLElement["div", {"class"->"main-heading"}, Flatten[{Map[Block[
			{rownum = #}, Transmogrify[SelectGridRows[][[#]]  ] 
			]&,Range[Length[SelectGridRows[]]]
	]}]],
	XMLElement["table", If[Length[gridboxdividers]===0, {"class"->"nogridboxdividers"}, {}], Flatten@{
	Map[
		XMLElement["col",
            If[GetParameter["widths"] =!= None,
			Switch[GetParameter["widths"][[#]],
				_Integer, {"width" -> ToString[GetParameter["widths"][[#]]]},
				_Real, {"width" -> ToString[Floor[GetParameter["widths"][[#]] * 100]] <> "%"},
				_, {}
			], {}], {}]&,
		Range[Length[SelectGridColumns[]]]
	],

	Map[
		XMLElement["tr", 
		If[MatchQ[SelectGridRows[][[#, 1]], Cell["\[FilledVerySmallSquare]", ___]],
            {"class"->"CRI modified-text"}, {
             "class" -> StringJoin[
				If[GetParameter["rowlines"][[#]] === True,
				"topBorder ", ""], 
				Which[
					MemberQ[{"Usage", "ObjectNameGrid", "GuideTitleGrid"}, GetParameter["tablestyle"]], "",
					SelectGridRows[][[#, 1]]=== "\[FilledVerySmallSquare]",  "CRI",   
					colspans[{#, 2}] > 1 && SelectGridRows[][[#]] === First[GetParameter["checklist"]], 						"lineAboveSpanColumn", 
					SelectGridRows[][[#]] === First[GetParameter["checklist"]], "lineAbove", 
					colspans[{#, 2}] < 1, "SpanColumn",
					True,  ""
					] (*  End Which  *)
				],
		"style" -> StringJoin[
				Switch[GetOption[RowAlignments],
					Top, "vertical-align: top;",
					Bottom, "vertical-align: bottom",
					Center, "vertical-align: middle",
					Baseline, "vertical-align: baseline",
					_List, Switch[GetOption[RowAlignments][[
							Mod[#-1, Length[GetOption[RowAlignments]]]+1]],
						Top, "vertical-align: top;",
						Bottom, "vertical-align: bottom",
						Center, "vertical-align: middle",
						Baseline, "vertical-align: baseline",
						_, ""
				], _, ""] 
		]
	
}], (* end If *) (*  end tr attributes  *)
			
			Block[
			{rownum = #}, Transmogrify[SelectGridRows[][[#]]  ] 
			]  
		]&,
		Range[Length[SelectGridRows[]]]
	]
}]]]]]
],



{GridRow} :>
Which[GetParameter["tablestyle"] === "DoubleBox",
Map[
 XMLElement["td", {"style" -> "text-align:left;"}, 
 Flatten@{Transmogrify[SelectChildren[][[#]] ]}  ]&, Range[Length[SelectChildren[]]]
 ],
 GetParameter["tablestyle"] === "ObjectNameGrid",
 Map[If[colspans[{rownum, #}] != 0, Flatten@{Transmogrify[SelectChildren[][[#]]]},""]&, Range[Length[SelectChildren[]]]],
True,
Map[
  If[colspans[{rownum, #}] != 0,
    XMLElement["td", Join[
      If[#===1 && objgrid=!=True, {}, {}],
      If[objgrid === True,
        If[#=!=1, {"style" -> "text-align: right"}, {}],
        Switch[GetParameter["text-align"][[rownum, #]],
          Left, {"style" -> "text-align: left;"},
          Right, {"style" -> "text-align: right;"},
          Center, {"style" -> "text-align: center;"},
          _, {}
      ]],
      If[colspans[{rownum, #}] > 1,
        {"colspan" -> ToString[colspans[{rownum, #}]]}, {}],
      If[rowspans[{rownum, #}] > 1,
        {"rowspan" -> ToString[rowspans[{rownum, #}]]}, {}]
    ], Flatten@{Transmogrify[SelectChildren[][[#]]]}  ],
    ""]&,
  Range[Length[SelectChildren[]]]
]


]
},
DefaultParameters -> {
	"noop" -> (
	tableColumnWidths = {
	    "RootGrid" -> {.5, .5},
		"DefinitionBox" -> {.4, .6},
	    "PrecedenceTable" -> {.35, .35, .15, .15}, 
		"ObjectNameGrid" -> {.5, .5},
		"GuideTitleGrid" -> {.5, .5},
		"Usage" -> {.95, .05},
		"3ColumnSmallBox" -> {.24, .24, .24},
		"2ColumnSmallBox" -> {.35, .35},
		"DefinitionBox3Col" -> {.35, .2, .45}, 
		"DefinitionBox4Col" -> {.15, .35, .15, .35}, 
		"DefinitionBox5Col" -> {.2, .2, .2, .2, .2}, 
		"DefinitionBox6Col" -> {.18, .19, .18, .19, .18, .19}, 
		"TopBox" -> {.31, .62}, 
		"MiddleBox" -> {.31, .62}, 
		"BottomBox" -> {.31, .62}, 
		"TopSpanBox" -> {.9, .03}, 
		"MiddleSpanBox" -> {.31, .62}, 
		"3ColumnTable" -> {.28, .28, .43},
    "3ColumnTableStandalone" -> {.28, .28, .43},
    "3ColumnTableModStandalone" -> {.28, .28, .43},
    "3ColumnIllustratedTableModStandalone" -> {.28, .28, .43},
		"2ColumnTable" -> {.35, .50},
    "2ColumnTableStandalone" -> {.35, .50},
		"3ColumnTableMod" -> {.01, .28, .28, .43},
		"3ColumnIllustratedTableMod" -> {.01, .28, .28, .43},
		"2ColumnTableMod" -> {.01, .35, .50},
    "2ColumnTableModStandalone" -> {.01, .35, .50},
		"AlphabeticalListing" -> {.3, .3, .3}
	};
	
	functionOptionTableStyles = {"2ColumnTable", "2ColumnTableStandalone", "2ColumnEvenTable", "3ColumnTable", "3ColumnTableStandalone" };
	)
}
]