(* :Title: CoreHTMLRules.m *)

(* :Author:
  Andrew Hunt, andy@wolfram.com
  Greg Martel, gregm@wolfram.com
    Stephen Layland, layland@wolfram.com
*)

(* :Mathematica Version: 5.1 *)
(* :Mathematica Version: 6.0 *)
(* :Package Version: $Revision: 1.226.2.5 $ $Date: 2016/11/02 15:06:07 $ *)                  
(* :Copyright: (c) 2005, Wolfram Research, Inc. All rights reserved. *)
(* :Summary: CoreTransformRules for Mathematica Documentation *)

(* This includes the other *Box files in the Components directory *)


XMLTransform[{

{Notebook} :> 
Module[ {pagetitle, pagetitlemodifier, searchquerystring, citehead, language, languagepage, languageimage, buildNumber, 
	history, l, completeHTMLQ, htmlBase, urlBaseRemote, linkTrail, dashboard, summary, fileBase, searchHeader, tagrules, 
	flag, versionNumber, keywords, specialKeywords,insertedKeywords,listLength,listDivisor, subtractor, buildmode, tutorialcollection, 
	marketingBlurb, entityrules, filledinlayoutexpr, featuredexampledata, relativeBase, NotFullySupported},

entityrules = {"\[LongDash]"->"&mdash;", "\[FilledRightTriangle]"->"&#9658;", "\[FilledLeftTriangle]"->"&#9668;"};

versionNumber = StringSplit[$Version, "."][[1]];

pagetitlemodifier = GetParameter["titlemodifier"];
pagetitle = GetParameter["title"];
pagetitle = Which[
	pagetitlemodifier==="",
	StringReplace[pagetitle, {"\""->"", " - Wolfram Mathematica"->""}],
	pagetitlemodifier==="XXXX", 
	StringReplace[pagetitle, {"\""->"", " - Wolfram Mathematica"->""}],
	True, 
	StringReplace[pagetitle<>" "<>pagetitlemodifier, {"\""->"", " - Wolfram Mathematica"->""}]
	];
pagetitle = If[StringQ[pagetitle], StringReplace[pagetitle, " ("~~_~~")"->""], pagetitle];
pagetitle = StringReplace[pagetitle, 
	Prepend[Get[ToFileName[{$DocumentationBuildDirectory}, "TextCharacterReplacementRules.m"]], "\[Rule]"->"->"] ];

keywords=GetParameter["keywords"];
specialKeywords=GetParameter["specialKeywords"];
keywords=Complement[Flatten[{StringSplit[keywords, ","]}],specialKeywords];
listLength=Length[keywords];
listDivisor=If[listLength>0, Round[Extract[Solve[listLength/x == 20, x], {{1, 1, 2}}]][[1]], 1];
subtractor=listDivisor-1;
keywords=If[Length@keywords<24,keywords,
	Extract[keywords, 
Partition[Table[listDivisor(i)-subtractor, {i,Round[listLength/listDivisor]}], 1] ]];
insertedKeywords=ToStringList[keywords];

buildmode = GetParameter["buildmode"];
buildNumber = GetParameter["BuildNumber"];
history = GetParameter["HistoryData"];
IsManipulate = GetParameter["IsManipulate"];
cache = GetParameter["Cache"];
cachelocation = GetParameter["CacheLocation"];
featuredexampledata = GetParameter["featuredexampledata"];
language = GetParameter["language"];
htmlBase = GetParameter["htmlBase"];
urlBaseRemote = GetParameter["urlBaseRemote"];
completeHTMLQ = GetParameter["CompleteHTMLQ"];
NotFullySupported = GetParameter["NotFullySupported"];
dashboard = GetParameter["dashboard"];
linkTrail = Which[pagetitle==="webMathematica",
{Cell[CellGroupData[{Cell[TextData[{ButtonBox["webMathematica",ButtonData->"paclet:webMathematica/guide/webMathematica",
BaseStyle->{"Link","LinkTrail"}],StyleBox[">","LinkTrailSeparator"]}],"LinkTrail",CellID->0]}]]},
GetParameter["entityType"]==="HowTo",
{Cell[CellGroupData[{Cell[TextData[{StyleBox[ButtonBox["Mathematica",ButtonData->"paclet:guide/Mathematica",
BaseStyle->{"Link","LinkTrail"}], FontSlant->"Italic"],StyleBox[">","LinkTrailSeparator"]
}],"LinkTrail",CellID->0]}]]},
	True, GetParameter["linkTrail"]];
Print@buildmode;

fudgeValignProp[x_]:= Module[{var,newvar},
    	var=ToExpression[x];
    	newvar=Which[
    	var<14, "-10",
    	13<var<18, "-12",
    	17<var<20, "-16",
    	19<var<23, "-22",
    	22<var<27, "-35",
    	26<var<30, "-45",
    	29<var<32, "-55",
        31<var<35, "-65",
    	True, "-75"
    ];
    newvar
    ];

(* convert charaacters to entities - IE Windows won't render pages if meta description contains escaped characters *)
summary = GetParameter["summary"];
summary = ExportString[XMLElement["String", {}, { GetParameter["summary"] }], "XML", "Entities" -> "HTML"];
summary = If[Head@summary === String,
			StringReplace[summary, {"<String>" -> "", "</String>" -> ""}],
			""];
summary = CleanSummaryForWeb[summary];
fileBase = GetFileNameBase[];
searchHeader = Localized["SEARCH", language];
marketingBlurb = Localized["RootWebMarketingText", language];
tagrules=GetOption[TaggingRules];
flag=Extract[tagrules, Position[tagrules, "status"->a_String]][[1,2]];
tutorialcollection = GetParameter["tutorialcollection"];
tutorialcollection = If[tutorialcollection==={{}}||tutorialcollection==={}, {},
StringSplit[Map[StringReplace[#, "\n"->","]&, tutorialcollection[[1]]], ","]];


linkTrail = 
If[ !MemberQ[{None, {}, $Failed, ""}, linkTrail], 
	 Which[
	 	MatchQ[linkTrail, {Cell[CellGroupData[{}]]}], "", 
	 	GetParameter["entityType"]==="Note", "",
	 	True, ExportString[ DIV[ {"class" -> "breadcrumb"}, {Recurse@linkTrail}], "XML", "AttributeQuoting"->"\"", "Entities"->entityrules, "ElementFormatting" -> DocumentationBuild`Utils`Private`indentFunction]], 
"" ];

WithParameters[
  { "FileName"-> StringReplace[GetAbsoluteFileName[], {".en"->"", ".ja"->""}], 
    "context" ->  XMLElement["span", {"class" ->"contextName"}, 
      {
        Recurse[GetParameter["contextName"]]
      } ] 
},  


(

(* create a .html-conf file if there's a filename *)
If[(fileBase =!= "") && (completeHTMLQ =!= True) && (
	StringReplace[fileBase, {".en"->"", ".ja"->"", ".zh"->""}] === "Mathematica" && GetParameter["entityType"]==="Guide"), 

	Export[StringJoin[fileBase, ".html-conf"],  
"#SetEnv STYLE_CustomHeaderFile $$DOCUMENT_ROOT$$/mathematicaIncludes/mathematicaHead.html
#SetEnv STYLE_CustomFooterFile $$DOCUMENT_ROOT$$/mathematicaIncludes/mathematicaFoot.html
#SetEnv STYLE_CustomFooterFile 0
SetEnv STYLE_InternalPageWidth 100%

SetEnv STYLE_Body '<body style=\"margin:0px;\" onLoad=\"javascript:set_domain()\">'", 
"TEXT"]
];
  
Block[{styleswitch},
    
  (* fill in layout file with content *)

styleswitch = GetParameter["entityType"];

Switch[$LanguageExtension,
  "ja", 
     (citehead = "Cite this as";
      languageimage = "english.gif"; ),
   "zh",
     (citehead = "Cite this as";
      languageimage = "english.gif"; ),
   _,
     (citehead = "Cite this as";
      languageimage = "japanese.gif"; )
];
languagepage = fileBase <> ".html";
languagepage = (
  l = If[ $LanguageExtension === "ja", ".en.", ".ja."];
  ex = "."<>$LanguageExtension<>".";
  StringReplace[languagepage, {ex -> l }] );


  (* symbolic XML template *)
 filledinlayoutexpr = FillInLayout[
    GetParameter["layoutfile"],
    "Text",
    "externalPageLink" -> "http://reference.wolfram.com"<>GetParameter["url"], 
    "develContent"->"[ Internal Document ]",
    "searchquerystring" -> searchquerystring,
    "pageTitle" -> pagetitle,
    "CiteHead" -> citehead,
    "CitePageName" -> pagetitle,
    "languagePage" -> languagepage, 
    "languageImage" -> languageimage,
    "BuildNumber" -> buildNumber,
    "title" -> ExportString[XMLElement["title", {}, {
        If[GetParameter["pacletName"] === "Wolfram SystemModeler" || GetParameter["pacletName"] === "Wolfram SystemModeler Library",
            (* WSM documentation, do not touch title *)
            pagetitle,
            (* Wolfram Language documentation, make sure title ends with "Wolfram Language Documentation" *)
            If[StringFreeQ[pagetitle, "Wolfram Mathematica Documentation Center"|"Wolfram Mathematica: Documentation Center"], 
            pagetitle <>"\[LongDash]"<>Localized["TitleV10WebHeading",GetParameter["language"]], 
            StringReplace[pagetitle, "Wolfram Mathematica: Documentation Center"|"Wolfram Mathematica Documentation Center"->"Wolfram Language Documentation"]]
        ]}], "XML", "Entities"->entityrules],
    "metabuildnumber" -> "<meta name=\"buildnumber\" content=\""<>buildNumber<>"\" />",
    "metahistorydata" -> ExportString[XMLElement["meta", {"name"->"historydata","content"->ToString[history] }, {}], "XML", "AttributeQuoting"->"\"", "Entities"->entityrules],
    "metakeywords" ->If[Length@keywords > 0, ExportString[XMLElement["meta", {"name"->"keywords", "content"->insertedKeywords}, {}], "XML", "AttributeQuoting"->"\"", "Entities"->entityrules], ""],
	"metasynonyms" ->If[Length@GetParameter["synonyms"] > 0, ExportString[XMLElement["meta", {"name"->"synonyms", "content"->ToStringList[GetParameter["synonyms"]] }, {}], "XML", "AttributeQuoting"->"\"", "Entities"->entityrules], ""],
    "metadescription" ->If[GetParameter["url"]==="guide/Mathematica", ExportString[XMLElement["meta", {"name"->"description", "content"->Localized["RootGuideMetaDataDescription", GetParameter["language"]] }, {}], "XML", "AttributeQuoting"->"\"", "Entities"->entityrules], If[MatchQ[summary, List[_String]|_String], ExportString[XMLElement["meta", {"name"->"description", "content"->If[MatchQ[summary, List[_String]], summary[[1]], summary] }, {}], "XML", "AttributeQuoting"->"\"", "Entities"->entityrules], ""]],
    "baselangline" -> ExportString[XMLElement["script", {"language" -> "JavaScript", "type" -> "text/javascript"},{XML`RawXML["baselang='"<>fileBase<>"';"]}], "XML", "AttributeQuoting"->"\"", "Entities"->entityrules],
    "packagename" -> ExportString[XMLElement["script", {"language" -> "JavaScript", "type" -> "text/javascript"},{XML`RawXML["packagename='"<>GetParameter["pacletName"]<>"';"]}], "XML", "AttributeQuoting"->"\"", "Entities"->entityrules],
    "htmlBase" -> htmlBase,
    "WebRootHeadingText" ->Localized["RootWebHeading", GetParameter["language"]],
    "WebRootGetStartedText" ->Localized["RootGSVideos", GetParameter["language"]],
    "WebRootWhatsNewText" ->Localized["RootWhatsNew", GetParameter["language"]],
    "WebRootHowTosText" ->Localized["RootHowTo", GetParameter["language"]],
    "WebRootFooterLinks" ->Localized["WebRootFooterLinks", GetParameter["language"]],    
    "linkTrail" -> linkTrail,
    "search" -> ExportString[searchHeader,
        "XML",
    "AttributeQuoting"->"\"", "Entities"->{"\[LongDash]"->"&mdash;", "\[FilledRightTriangle]"->"&#9658;", "\[FilledLeftTriangle]"->"&#9668;"},    
"ElementFormatting" -> DocumentationBuild`Utils`Private`indentFunction],
    "langTag" -> "\""<>If[language==="Japanese","ja","en"]<>"\"",
    "dashboard" -> dashboard,
    "keywords" -> insertedKeywords,
    "searchSSI" -> GetParameter["searchSSI"],
    "footerSSI" -> GetParameter["footerSSI"],
    "copyrightSSI" -> GetParameter["copyrightSSI"],
    "languageLinkSSI" -> GetParameter["languageLinkSSI"],
    "header" -> Which[flag==="FutureFlag" && buildmode==="Future", 
    	ExportString[DIV[{"class"->"FutureFlag"},{"This page is flagged as Future documentation."}], "XML"],
    	flag==="ExcisedFlag" && buildmode==="Future", 
    	ExportString[DIV[{"class"->"ExcisedFlag"},{"This page is flagged as Excised documentation."}], "XML"],
    	flag==="InternalFlag" && buildmode==="Future", 
    	ExportString[DIV[{"class"->"InternalFlag"},{"This page is flagged as Internal documentation."}], "XML"],
    	flag==="ObsoleteFlag" && buildmode==="Future", 
    	ExportString[DIV[{"class"->"ObsoleteFlag"},{"This page is flagged as Obsolete documentation."}], "XML"],
    	(*flag==="TemporaryFlag" && buildmode==="Future", 
    	ExportString[DIV[{"class"->"TemporaryFlag"},{"This page is flagged as Temporary documentation."}], "XML"],*)
    	flag==="AwaitingFutureDesignReviewFlag" && buildmode==="Future", 
    	ExportString[DIV[{"class"->"AwaitingFutureDesignReviewFlag"},{"This page is flagged as Awaiting Future Design Review documentation."}], "XML"],
    	(*flag==="PreviewFlag" && buildmode==="Future", 
    	ExportString[DIV[{"class"->"PreviewFlag"},{"This page is flagged as Preview documentation."}], "XML"],*)
    True,  GetParameter["htmlHeader"]
    ]
    ,
    "footer" -> If[GetParameter["CompleteHTMLQ"]===False, GetParameter["htmlFooter"], ""],
    "RootGuideHeaderURL" -> htmlBase<>"/mathematicaImages/root/rootGuideHeader.gif",

   "bodystyle" -> Switch[
GetParameter["language"],  
"Japanese", ExportString[XML`RawXML["<div class=\"MainRoot\" width = \"727\" id=\"ja\">"], "XML"],
"ChineseSimplified", ExportString[XML`RawXML["<div class=\"MainRoot\" width = \"727\" id=\"zh\">"], "XML"], 
"Spanish", ExportString[XML`RawXML["<div class=\"MainRoot\" width = \"727\" id=\"es\">"], "XML"], 
_, ExportString[XML`RawXML["<div class=\"MainRoot\" width = \"727\">"], "XML"]
],  

"logo" -> Which[
language=== "Spanish" && versionNumber==="8", 
ExportString[XML`RawXML["<img src=\"/mathematicaImages/RootWebHeadv8_es.gif\" id=\"logo\" alt=\"Wolfram Mathematica Documentation Center\" title=\"Wolfram Mathematica Documentation Center\">"], "XML"],
language=== "ChineseSimplified" && versionNumber==="8", 
ExportString[XML`RawXML["<img src=\"/mathematicaImages/RootWebHeadv8_zh.gif\" id=\"logo\" alt=\"Wolfram Mathematica Documentation Center\" title=\"Wolfram Mathematica Documentation Center\">"], "XML"],
language=== "Japanese" && versionNumber==="8", 
ExportString[XML`RawXML["<img src=\"/mathematicaImages/RootWebHeadv8_jp.gif\" id=\"logo\" alt=\"Wolfram Mathematica Documentation Center\" title=\"Wolfram Mathematica Documentation Center\">"], "XML"],
language=== "English" && versionNumber==="8", 
ExportString[XML`RawXML["<img src=\"/mathematicaImages/RootWebHeadv8.gif\" id=\"logo\" alt=\"Wolfram Mathematica Documentation Center\" title=\"Wolfram Mathematica Documentation Center\">"], "XML"],
language=== "ChineseSimplified", 
ExportString[XML`RawXML["<img src=\"/mathematicaImages/logo_zh.gif\" id=\"logo\" alt=\"Wolfram Mathematica Documentation Center\" title=\"Wolfram Mathematica Documentation Center\">"], "XML"],
language=== "Japanese", 
ExportString[XML`RawXML["<img src=\"/mathematicaImages/logo_jp.gif\" id=\"logo\" alt=\"Wolfram Mathematica Documentation Center\" title=\"Wolfram Mathematica Documentation Center\">"], "XML"],
True, 
ExportString[XML`RawXML["<img src=\"/mathematicaImages/logo.gif\" id=\"logo\" alt=\"Wolfram Mathematica Documentation Center\" title=\"Wolfram Mathematica Documentation Center\">"], "XML"]
],  

	"blurb"->ExportString[marketingBlurb, "XML"],
	
	
	"gs"->ExportString[XMLElement["span",{"class"->"RootFootSpan"},{Localized["RootGSVideos", language]}], "XML", "Entities"->{"'"->"&#39;"}],
	"path"->ExportString[XMLElement["span",{"class"->"RootFootSpan"},{Localized["RootLearningPath", language]}], "XML", "Entities"->{"'"->"&#39;"}],
	"howto"->ExportString[XMLElement["span",{"class"->"RootFootSpan"},{Localized["RootHowTo", language]}], "XML", "Entities"->{"'"->"&#39;"}],
	
	

    "body"-> If[
   MemberQ[exceptionsList, GetParameter["entityType"]], 

   StringJoin@Map[ExportString[#,
        "XML",
     "AttributeQuoting"->"\"", "Entities"->{"\[LongDash]"->"&mdash;", "\[FilledRightTriangle]"->"&#9658;", "\[FilledLeftTriangle]"->"&#9668;"},    
"ElementFormatting" -> DocumentationBuild`Utils`Private`indentFunction]&, 
	{XMLElement["div", {"class"-> "mainContent"}, {Transmogrify[SelectChildren[] //. Cell[linkContent__, "LinkTrail", linkOptions___] :> Unevaluated[Sequence[]](* Cell["","FooterCell"]  *) ]}]
		 }],
      ExportString[
        If[GetParameter["flag"] =!= "RootGuidePage", 
        Which[
        	MemberQ[{"Guide Overview" | "Standard Extra Packages"}, GetParameter["entityType"]], 
        	XMLElement["div", {"class"-> "mainContent"}, {Transmogrify[SelectChildren[] //. Cell[linkContent__, "LinkTrail", linkOptions___] :> Unevaluated[Sequence[]](* Cell["","FooterCell"]  *) ]}],
             MemberQ[{"HowTo"}, GetParameter["entityType"]],
             XMLElement["div", {"class"-> "mainContent"}, AddFirstAndLastToexpandWraps[{Transmogrify[SelectChildren[] //. Cell[linkContent__, "LinkTrail", linkOptions___] :> Unevaluated[Sequence[]](* Cell["","FooterCell"]  *) ]}]],
             True,    
             XMLElement["div", {"class"-> "mainContent"}, {Transmogrify[SelectChildren[] //. Cell[linkContent__, "LinkTrail", linkOptions___] :> Unevaluated[Sequence[]](* Cell["","FooterCell"]  *) ]}] 
              ],
      XMLElement["ROOTGUIDETAG", {}, Flatten[{Recurse[]}]]
        ],
        "XML",
     "AttributeQuoting"->"\"", "Entities"->{"\[RightGuillemet]"->"<span class=\"rightguillemet\">&#187;</span>", "\[LongDash]"->"&mdash;", "\[FilledRightTriangle]"->"&#9658;", "\[FilledLeftTriangle]"->"&#9668;"},    
"ElementFormatting" -> DocumentationBuild`Utils`Private`indentFunction] 
] 

];

filledinlayoutexpr = StringReplace[filledinlayoutexpr, {
	"<span class=\"specialcharacters\"><span class=\"verticalbar\">|</span></span>"->"<span class=\"verticalbar\">|</span>",
	"<span class=\"specialcharacters\"><span class=\"comma\">,</span></span>"->"<span class=\"comma\">,</span>",
	"<span class=\"specialcharacters\"><span class=\"semicolon\">;</span></span>"->"<span class=\"semicolon\">;</span>",
	"<span class=\"specialcharacters\"><span class=\"openbrace\">{</span></span>"->"<span class=\"openbrace\">{</span>",
	"<span class=\"specialcharacters\"><span class=\"closebrace\">}</span></span>"->"<span class=\"closebrace\">}</span>",
	"<span class=\"specialcharacters\"><span class=\"openbracket\">[</span></span>"->"<span class=\"openbracket\">[</span>",
	"<span class=\"specialcharacters\"><span class=\"closebracket\">]</span></span>"->"<span class=\"closebracket\">]</span>",
	"<span class=\"specialcharacters\"><span class=\"openparenthesis\">(</span></span>"->"<span class=\"openparenthesis\">(</span>",
	"<span class=\"specialcharacters\"><span class=\"closeparenthesis\">)</span></span>"->"<span class=\"closeparenthesis\">)</span>",
	"<ROOTGUIDETAG>"->"", "</ROOTGUIDETAG>"->"","<div class=\"rootfooter\">"->"</div>\n<div class=\"footer\">", 
	"&#160;<span class=\"inlineBullet\">&nbsp;&#9642;&nbsp;</span> <"->"<span class=\"inlineBullet\">&nbsp;&#9642; </span><", 
	"<span class=\"ThinSpace\"><!-- --></span>"->"<span class=\"ThinSpace\"></span>",
	"&#160;&#160;<span>("->"&#160;<span>(",
	"<ul class=\"dropdown\" />"->"",
	"<span class=\"MenuNameDelimiter\"> &#9658; </span>"->"<span class=\"MenuNameDelimiter\">&nbsp;&#9658;&nbsp;</span>",
	"<div class=\"breadcrumb\">
 <div class=\"wrapper\">
  <em><a href=\"/language/guide/Mathematica.html\">Mathematica</a></em>
 </div>
</div>"->"", "<div class=\"breadcrumb\">
 <div class=\"wrapper\">
  <em><a href=\"/language/guide/Mathematica.html\">Mathematica</a></em>
 </div>
</div>"->"", "<em><a href=\"/language/guide/Mathematica.html\">Mathematica</a></em>
  <span class=\"breadcrumbSep\">&gt;</span>"->"", "(<a href=\"http://www.wolframscience.com/nksonline/\">A New Kind of Science</a>)"->"(<a href=\"http://www.wolframscience.com/nksonline/\"><em>A New Kind of Science</em></a>)"}];

filledinlayoutexpr= If[
	    Length[StringCases[filledinlayoutexpr, "<span class=\"NewIn10Graphic\"></span>"]]>0, 
		Which[
			NotFullySupported == "Desktop",
		         StringReplace[filledinlayoutexpr, {"<span class=\"NewIn10Graphic\"></span>"->"", "</h1>"->"<span class=\"iconography\"><span class=\"NewIn10Graphic-inside\"></span><!--#include virtual=\"/2013/includes/NotFullySupportedDesktopIcon.html\"--></span></h1><!--#include virtual=\"/2013/includes/NotFullySupportedDesktopBanner.html\"-->"}],
		    NotFullySupported == "Cloud",
		         StringReplace[filledinlayoutexpr, {"<span class=\"NewIn10Graphic\"></span>"->"", "</h1>"->"<span class=\"iconography\"><span class=\"NewIn10Graphic-inside\"></span><!--#include virtual=\"/2013/includes/NotFullySupportedCloudIcon.html\"--></span></h1><!--#include virtual=\"/2013/includes/NotFullySupportedCloudBanner.html\"-->"}],    
		    NotFullySupported == "PublicCloud",
		         StringReplace[filledinlayoutexpr, {"<span class=\"NewIn10Graphic\"></span>"->"", "</h1>"->"<span class=\"iconography\"><span class=\"NewIn10Graphic-inside\"></span><!--#include virtual=\"/2013/includes/NotFullySupportedPublicCloudIcon.html\"--></span></h1><!--#include virtual=\"/2013/includes/NotFullySupportedPublicCloudBanner.html\"-->"}],    
		    True, 
		         StringReplace[filledinlayoutexpr, {"<span class=\"NewIn10Graphic\"></span>"->"", "</h1>"->"<span class=\"iconography\"><span class=\"NewIn10Graphic-inside\"></span></span></h1>"}]
		     ],
		 If[Length[StringCases[filledinlayoutexpr, "<a href=\"#\" class=\"highlight-link\"></a>"]]>0, 
		 filledinlayoutexpr, 
		 Which[
			NotFullySupported == "Desktop",
		         StringReplace[filledinlayoutexpr, {"</h1>"->"<span class=\"iconography\"><!--#include virtual=\"/2013/includes/NotFullySupportedDesktopIcon.html\"--></span></h1><!--#include virtual=\"/2013/includes/NotFullySupportedDesktopBanner.html\"-->"}],
		    NotFullySupported == "Cloud",
		         StringReplace[filledinlayoutexpr, {"</h1>"->"<span class=\"iconography\"><!--#include virtual=\"/2013/includes/NotFullySupportedCloudIcon.html\"--></span></h1><!--#include virtual=\"/2013/includes/NotFullySupportedCloudBanner.html\"-->"}],    
		    NotFullySupported == "PublicCloud",
		         StringReplace[filledinlayoutexpr, {"</h1>"->"<span class=\"iconography\"><!--#include virtual=\"/2013/includes/NotFullySupportedPublicCloudIcon.html\"--></span></h1><!--#include virtual=\"/2013/includes/NotFullySupportedPublicCloudBanner.html\"-->"}],    
		    True, 
		         filledinlayoutexpr
		     ]
		 ]
	    ];
	
filledinlayoutexpr= If[
	Length[StringCases[filledinlayoutexpr, "<a href=\"#\" class=\"highlight-link\"></a>"]]>0, 
	Which[
		NotFullySupported == "Desktop",
	        StringReplace[filledinlayoutexpr, {"<a href=\"#\" class=\"highlight-link\"></a>"->"", "</h1>"->"<span class=\"iconography\"><a href=\"#\" class=\"highlight-link\"></a><!--#include virtual=\"/2013/includes/NotFullySupportedDesktopIcon.html\"--></span></h1><!--#include virtual=\"/2013/includes/NotFullySupportedDesktopBanner.html\"-->"}],
	    NotFullySupported == "Cloud",
	        StringReplace[filledinlayoutexpr, {"<a href=\"#\" class=\"highlight-link\"></a>"->"", "</h1>"->"<span class=\"iconography\"><a href=\"#\" class=\"highlight-link\"></a><!--#include virtual=\"/2013/includes/NotFullySupportedCloudIcon.html\"--></span></h1><!--#include virtual=\"/2013/includes/NotFullySupportedCloudBanner.html\"-->"}],    
	    NotFullySupported == "PublicCloud",
	        StringReplace[filledinlayoutexpr, {"<a href=\"#\" class=\"highlight-link\"></a>"->"", "</h1>"->"<span class=\"iconography\"><a href=\"#\" class=\"highlight-link\"></a><!--#include virtual=\"/2013/includes/NotFullySupportedPublicCloudIcon.html\"--></span></h1><!--#include virtual=\"/2013/includes/NotFullySupportedPublicCloudBanner.html\"-->"}],    
	    True, 
	        StringReplace[filledinlayoutexpr, {"<a href=\"#\" class=\"highlight-link\"></a>"->"", "</h1>"->"<span class=\"iconography\"><a href=\"#\" class=\"highlight-link\"></a></span></h1>"}]
         ],
    If[ Length[StringCases[filledinlayoutexpr, "<span class=\"NewIn10Graphic\"></span>"]]>0 || Length[StringCases[filledinlayoutexpr, "<span class=\"iconography\">"]]>0,
    	filledinlayoutexpr, 
    	Which[
		NotFullySupported == "Desktop",
	        StringReplace[filledinlayoutexpr, {"</h1>"->"<span class=\"iconography\"><!--#include virtual=\"/2013/includes/NotFullySupportedDesktopIcon.html\"--></span></h1><!--#include virtual=\"/2013/includes/NotFullySupportedDesktopBanner.html\"-->"}],
	    NotFullySupported == "Cloud",
	        StringReplace[filledinlayoutexpr, {"</h1>"->"<span class=\"iconography\"><!--#include virtual=\"/2013/includes/NotFullySupportedCloudIcon.html\"--></span></h1><!--#include virtual=\"/2013/includes/NotFullySupportedCloudBanner.html\"-->"}],    
	    NotFullySupported == "PublicCloud",
	        StringReplace[filledinlayoutexpr, {"</h1>"->"<span class=\"iconography\"><!--#include virtual=\"/2013/includes/NotFullySupportedPublicCloudIcon.html\"--></span></h1><!--#include virtual=\"/2013/includes/NotFullySupportedPublicCloudBanner.html\"-->"}],    
	    True, 
	        filledinlayoutexpr
         ]
    ]
	];

relativeBase = Which[
  MatchQ[GetParameter["pacletName"], Alternatives["Wolfram SystemModeler", "Wolfram SystemModeler Library"]]
,
  "../Resources/minimal/"
,
  completeHTMLQ,
  "/webMathematica/Resources/Documentation/English/",
,
  True,
  StringJoin @@ Flatten@{ Table["../", { (Length@StringCases[GetParameter["url"], "/"])-1 }] }
];

filledinlayoutexpr = If[
   (* webMathematica's in-product documentation, for example *)
  completeHTMLQ === True
, 
  StringReplace[filledinlayoutexpr, {
		"<!--#include virtual=\"/2013/includes/global-head2.html\"-->" :>
    "<meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\" />
<!--[if IE]>
<style type=\"text/css\">
/* doctype problem overrides */
#menu .searchboxsub, #menu .searchboxsub-on { padding-bottom: 0; }
#menu .headerSearchSubmit { margin-bottom: 4px; }

/*
.WRIdropMenu .WRImenuContents { margin-top: -2px; margin-left: -2px; }
.WRIdropMenu .WRImenuContents .WRImenuContents { margin: 0; }
*/
</style>
<![endif]-->
<link rel=\"stylesheet\" href=\""<>relativeBase<>"css/reference.css\" />

<script src=\""<>relativeBase<>"javascript/reference.js\"></script>
<script src=\""<>relativeBase<>"javascript/documentation-search.js\"></script>
<script src=\""<>relativeBase<>"javascript/faster-page-load.js\"></script>
<script src=\""<>relativeBase<>"javascript/hyperlink-filter.js\"></script>
<script src=\""<>relativeBase<>"javascript/brokenlinks.js\"></script>
<script src=\""<>relativeBase<>"javascript/clipboard.js\"></script>
<script src=\""<>relativeBase<>"javascript/image-swap.js\"></script>
",

    "<!--#include virtual=\"/2013/includes/global-head1.html\"-->" :>
    "<!DOCTYPE html>\n <html>\n <head>\n <meta charset=\"UTF-8\">\n",

		"<!--#include virtual=\"/common/includes/gl-header.html\"-->" :> "",

		"<!--#include virtual=\"/2013/includes/reference-header.html\"-->" :> "<div class=\"outer-wrapper\">",

		"<!--#include virtual=\"/2013/includes/reference-footer.html\"-->" :> "",

		"<!--#include virtual=\"/common/includes/gl-footer.html\"-->" :> "",

		"<!--#include virtual=\"/common/includes/gl-footer-includes.html\"-->" :> "",

		"<!--#include virtual=\"/2013/includes/global-footer.html\"-->" :> "</body></html>",

		"(<a href=\"http://www.wolframscience.com/nksonline/\">A New Kind of Science</a>)" :>
    "(<a href=\"http://www.wolframscience.com/nksonline/\"><em>A New Kind of Science</em></a>)"
  }]
,
  filledinlayoutexpr
];
	
filledinlayoutexpr = If[GetParameter["pacletName"]=="Wolfram SystemModeler" || GetParameter["pacletName"]=="Wolfram SystemModeler Library", 
	StringReplace[filledinlayoutexpr,
		{"<link rel=\"stylesheet\" type=\"text/css\" href=\""<>relativeBase<>"css/reference.css\" />"->
			"<link rel=\"stylesheet\" type=\"text/css\" href=\""<>relativeBase<>"css/reference.css\" />
			<link rel=\"stylesheet\" type=\"text/css\" href=\""<>relativeBase<>"css/systemmodeler.css\" />"}],
	filledinlayoutexpr];

filledinlayoutexpr = If[completeHTMLQ===False && (StringMatchQ[GetParameter["pacletName"], a___~~"SystemModeler"~~b___]), 
	StringReplace[filledinlayoutexpr,
		{ "<!--#include virtual=\"/2013/includes/global-head2.html\"-->"->"<!--#include virtual=\"/system-modeler/includes/reference-head.html\"-->",
		 "<!--#include virtual=\"/2013/includes/reference-header.html\"-->"->"<!--#include virtual=\"/system-modeler/includes/header.html\"-->",
		 "<!--#include virtual=\"/2013/includes/global-footer.html\"-->"->"</body></html>", "/language/WSMLink/"->"/system-modeler/WSMLink/"}],
	filledinlayoutexpr]
	 
	 
  ]
)
]  (* end WithParam *)
], (* end Module *)

{Cell, "UnfinishedDraft"} :> XMLElement["span", {"class"->"UnfinishedDraft"},{""}],

{Cell, "GuideColorBar" | "SymbolColorBar" | "TutorialColorBar"} :> Unevaluated[Sequence[]],

(* define how top handle box types *)
{Cell, "DefinitionBox" | "DefinitionBox1Col" |"DefinitionBox3Col" | "DefinitionBox4Col" | "DefinitionBox6Col" | "OptionBox3Col" | "DoubleBox"| "FramedBox" | "1ColumnBox" | "2ColumnBox" | "3ColumnBox" | "4ColumnBox" | 
"4ColumnBoxClean" |"2ColumnSmallBox" | "2ColumnTable" | "6ColumnBox" | "43Picture" | "PrecedenceTable" | 
"47Picture" | "47PictureLeft"} :> 
DIV[ {"class" -> "MathTable "<>GetStyle[]}, {DocumentationBuild`Utils`AddSpans[Recurse[] ]} ],

{Cell, "1ColumnTableModStandalone"
  | "2ColumnTableStandalone"
  | "3ColumnTableStandalone"
  | "2ColumnTableModStandalone"
  | "3ColumnTableModStandalone"
  | "3ColumnIllustratedTableModStandalone"} :>
  XMLElement[
    "ul",
    {"class" -> "functionList"},
    Li[
      {"class" -> "NotesTable"},
      {DocumentationBuild`Utils`AddSpans[Recurse[]]}
    ]
  ], 

{Cell, "AlphabeticalListing"} :> 
DIV[ {"class" -> "AlphabeticalListing"}, {Recurse[]} ],

{Cell, "LinkTrail"} :>
DIV[ {"class" -> "wrapper"}, {Recurse[]}],

(* TODO use brendan's CellToStringCode to add sensible Alt/Title tags  *)
FractionBox | RadicalBox | SqrtBox | OverscriptBox | UnderscriptBox | UnderoverscriptBox | SubsuperscriptBox :>
transmogrifyImage[ToFileName[{"Files", GetFileNameBase[]},
  IncrementCounter["Image"] <> ".png"], {"style"->"vertical-align:middle;", "alt"->"", "title"->""},
  Inline -> True, CropImage -> False, ImageFormat -> "PNG", TransparentBackground->True, ConversionOptions->{Background->None}
], 


(* TODO How to add sensible Alt/Title tags?  *)
SliderBox | Slider2DBox | OpenerBox :>
(
Export[ToFileName[{"Files", GetFileNameBase[]},
  "Control_" <> IncrementCounter["Image"] <> ".gif"],
  SelectLiteral[ SelectSelf[] ]
]
), 


(***** Cell Definitions *****)


{CellGroupData, "TOCChapter"} :> 
Block[{name, style, ex, count},
count = IncrementCounter["TOCChapter"];
style = "TOC";
name = "TOC"; 
(*ex = If[GetParameter["pacletName"]==="Alpha","_Ex","_Co"];*)
ex = If[MemberQ[{"Alpha", "webMathematica"},GetParameter["pacletName"]],"_Ex","_Co"];
(*ex =  "_Co";*) (* ex =  "_Ex"; *)

DIV[{"class" -> name<>ex, "name" -> name<>count, "id" -> name<>count}, {
Transmogrify[First[SelectChildren[]]],
DIV[{"class" -> name, "name" -> name<>"G", "id" -> name<>"G" },{
  Transmogrify[Rest[SelectChildren[]]] }]
}] ], 


{Cell, "TOCChapter" | "TOCPart"} :> 
Module[{
name, style, ex, newcount},
newcount = Switch[Head[count], 
		Symbol, "",
		String, count];
style === "TOCH";
name = "TOC";
ex = "closed";

Switch[Head[count], 
Symbol, H1[ {"id" -> name<>"H"}, {Recurse[]}],
String, 

  DIV[ {"class" -> name<>"H", "name" -> name<>newcount<>"H"}, {
H1[{"class" -> "TOCChapter"}, {
    A[{"href" -> ("javascript:toggle('" <> name <> newcount <> "')"),
       "onmouseover" -> "javascript:return(true);" }, {
    Img[{"src"->(GetParameter["htmlBase"]<>"/mathematicaImages/"<>ex<>"SectionGroup.gif"), "id"->name<>newcount<>"_", "border"->"0", "width"->"8", "height"->"8", "alt"->""}], 
      " ",
      Span[{"class"->name<>"Span"}, { Recurse[] }]
    }]
}] (* end h1 *)
}] (* end Div *)

] (* end Switch *)
], 


{Cell, "UnderDevelopment"} :> 
  DIV[{"class"->"UnderDevelopment"}, {"U N D E R ", XML`RawXML["&nbsp;"], " ", XML`RawXML["&nbsp;"], "D E V E L O P M E N T"}],
  
{CellGroupData, "TOCChapter" | (*"TOCSection" |*) (* "TOCSubsection" |*) "TOCSubsubsection"} :> 
	DIV[{"class"->GetStyle[]}, {Recurse[]}],

{CellGroupData, "TOCSection"} :> 
Block[{name, style, ex, tocSectionCount},
tocSectionCount = IncrementCounter["TOCSection"];
style = "TOCSEC";
name = "TOCSEC"; 
(*ex =  "_Co";*)
(*ex =  If[GetParameter["pacletName"]=== "Alpha", "_Ex", "_Co"];*)
ex =  If[MemberQ[{"Alpha","webMathematica"}, GetParameter["pacletName"]], "_Ex", "_Co"];

DIV[{"class" -> name<>ex, "name" -> name<>tocSectionCount, "id" -> name<>tocSectionCount}, {
Transmogrify[First[SelectChildren[]]],
DIV[{"class" -> name, "name" -> name<>"G", "id" -> name<>"G" },{
  Transmogrify[Rest[SelectChildren[]]] }]
}] ], 


{Cell, "TOCSection"} :> 
Module[{
name, style, ex, newcount},
newcount = Switch[Head[tocSectionCount], 
		Symbol, "",
		String, tocSectionCount];
style === "TOCSECH";
name = "TOCSEC";
ex = "closed";

Switch[Head[tocSectionCount], 
Symbol, H2[ {"id" -> name<>"H"}, {Recurse[]}],
String, 

  DIV[ {"class" -> name<>"H", "name" -> name<>newcount<>"H"}, {
H2[{"class" -> "TOCSection"}, {
    A[{"href" -> ("javascript:toggle('" <> name <> newcount <> "')"),
       "onmouseover" -> "javascript:return(true);" }, {
    Img[{"src"->(GetParameter["htmlBase"]<>"/mathematicaImages/"<>ex<>"SectionGroup.gif"), "id"->name<>newcount<>"_", "border"->"0", "width"->"8", "height"->"8", "alt"->""}], 
      " ",
      Span[{"class"->name<>"Span"}, { Recurse[] }]
    }]
}] (* end h1 *)
}] (* end Div *)

] (* end Switch *)
], 


{CellGroupData, "TOCSubsection"} :> 
Block[{name, style, ex, tocSubsectionCount},
tocSubsectionCount = IncrementCounter["TOCSubsection"];
style = "TOCSU";
name = "TOCSU"; 
ex =  "_Co"; (* ex =  "_Ex"; *)

DIV[{"class" -> name<>ex, "name" -> name<>tocSubsectionCount, "id" -> name<>tocSubsectionCount}, {
Transmogrify[First[SelectChildren[]]],
DIV[{"class" -> name, "name" -> name<>"G", "id" -> name<>"G" },{
  Transmogrify[Rest[SelectChildren[]]] }]
}] ], 


{Cell, "TOCSubsection"} :> 
Module[{
name, style, ex, newcount},
newcount = Switch[Head[tocSubsectionCount], 
		Symbol, "",
		String, tocSubsectionCount];
style === "TOCSUH";
name = "TOCSU";
ex = "closed";

Switch[Head[tocSubsectionCount], 
Symbol, H2[ {"id" -> name<>"H"}, {Recurse[]}],
String, 

  DIV[ {"class" -> name<>"H", "name" -> name<>newcount<>"H"}, {
H2[{"class" -> "TOCSubsection"}, {
    A[{"href" -> ("javascript:toggle('" <> name <> newcount <> "')"),
       "onmouseover" -> "javascript:return(true);" }, {
    Img[{"src"->(GetParameter["htmlBase"]<>"/mathematicaImages/"<>ex<>"SectionGroup.gif"), "id"->name<>newcount<>"_", "border"->"0", "width"->"8", "height"->"8", "alt"->""}], 
      " ",
      Span[{"class"->name<>"Span"}, { Recurse[] }]
    }]
}] (* end h1 *)
}] (* end Div *)

] (* end Switch *)
], 

{CellGroupData, "GuideReferenceSection"} :> XMLElement["div", {"class"->"expandWrap", "id"->"Reference"},
	{XMLElement["div", {"class"->"expandOuter"},{
		XMLElement["h2", {"class"->"expandInner"}, {
			XMLElement["a", {"class"->"expand hide", "title"->Localized["show", GetParameter["language"]], "href"->"#"},{Localized["GuideReferenceSectionText", GetParameter["language"]]}], 
			XMLElement["a", {"class"->"collapse", "title"->Localized["hide", GetParameter["language"]], "href"->"#"},{Localized["GuideReferenceSectionText", GetParameter["language"]]}]}], 
			XMLElement["div",{"class"->"expanded"}, 
				Flatten[{If[
					Length[Cases[First[SelectChildren[][[2]]], Cell[___, "GuideFunctionsSubsection", ___], Infinity]] > 0,
					 {}, 
					 XMLElement["div", {"class" -> "GuideDelimiterTop"}, {XML`RawXML["<!-- -->"]}]], Recurse[]}]]}]}],
			
{Cell, "GuideReferenceSection"} :> Unevaluated[Sequence[]],

{Cell, "MathCaption"} :> WithParameters[{"newline2br" -> True},
	DIV[{"class" -> "MCap"}, {Recurse[]}]  ],

{Cell, "TOCChapter" | "TOCSection" | "TOCSubsection" | "TOCSubsubsection"} :> Ol[{"class"->GetStyle[]}, {
Li[{"class"->GetStyle[]}, {Recurse[]}]
}], 

{Cell, "InlineCharacterDisplay"} :> 
  Span[{"class"->"InlineCharacterDisplay"}, {Recurse[]}],

{Cell, "FooterCell"} :> Unevaluated[Sequence[]],

{Cell, "TI"} :> Span[{"class"->GetStyle[]}, Recurse[]],

{CheckboxBox | RadioButtonBox} :> 
transmogrifyImage[ToFileName[{"Files", GetFileNameBase[]},
          "CellNone_" <> IncrementCounter["Image"] <> ".png"], {"alt"->"","style" -> "vertical-align:middle;"},
          Inline -> True, CropImage -> False, ImageFormat -> "PNG", TransparentBackground->True, ConversionOptions->{Background->None}
        ], 

{Cell,None} :> Module[{
  tmp1=SelectChildren[],
  tmp2=Recurse[]
  (*tmp3=SelectAncestors[Cell] *)
},
  If[
    Head[tmp1[[1]]]===CellGroupData, 
    If[Cases[tmp1, __]==={CellGroupData[{}, Open]}, "", tmp2 ],
    If[tmp2===Null, "",
    Which[htmlBoxesQ[SelectLiteral[SelectSelf[]]], tmp2, 
		Cases[tmp1, _CheckboxBox, Infinity]=!={}, tmp2,
		Cases[tmp1, _RadioButtonBox, Infinity]=!={}, tmp2,
		True,
        transmogrifyImage[ToFileName[{"Files", GetFileNameBase[]},
          "CellNone_" <> IncrementCounter["Image"] <> ".png"], {"alt"->"","style" -> "vertical-align:middle;"},
          Inline -> True, CropImage -> False, ImageFormat -> "PNG", TransparentBackground->True, ConversionOptions->{Background->None}
        ]
      ]
  ]
  ]

],  


(* Remove from parsing *)
{Cell, "FooterCell"} :> Unevaluated[Sequence[]],

(* TODO How to add sensible Alt/Title tags? *)
{Cell, "Graphics"} :> 
DIV[{"class"->GetStyle[]}, {
transmogrifyImage[ToFileName[{"Files", GetFileNameBase[]},
    IncrementCounter["Graphics"] <> "_g.gif"],{"alt"->""},
    Inline -> True, CropImage -> False
]}], 

{Cell, "ItemizedPicture" | "ItemPicture"} :> 
DIV[{"class"->GetStyle[]}, {
transmogrifyImage[ToFileName[{"Files", GetFileNameBase[]},
    IncrementCounter["Graphics"] <> "_g.gif"],{"alt"->""},
    Inline -> True, CropImage -> False
]}], 

(* spacer added by Greg for InputCells with no Output followed by ExampleDelimiter *)
{Cell, "WeakDivider" | "StrongDivider" | "InternalFlag" | "ImportExportSection" |
"ImportExportSection" | "NotebookInterfaceSection" | "ElementsSection" | "Spacer" | "TableHeader"} :> 
DIV[ {"class" -> (GetStyle[]/.None->"FIXME")
}, {Recurse[]}],


 {Cell, "ObsolescenceNote"} :>  XMLElement["div", {"class"->"ObsolescenceNote"}, {Recurse[]}],


{Cell, "TableRowIcon"}:>  Sequence[],
{Cell, "CloudIconGraphic"}:> Sequence[],

{Cell, "BrighterFlag"}:> DIV[{"class"->"BrighterFlag"},{
	XMLElement["img", {"src"->"/mathematicaImages/FutureFlag.gif"}, {}]}
	],

{Cell, "MenuName"} :>
Span[ {"class" -> "MenuName"}, {Recurse[]}],

{Cell, "InlineCharacterName"} :>
Span[ {"class" -> "ICN"}, {Recurse[]}],

(* not changed *)
{Cell, "ModInfo"} :> 
Span[ {"class" -> "ModInfo", "id" -> "ModInfo_"<>"8", "name" -> "ModInfo_"<>"8"}, {Recurse[]}],


{Cell, "TableText"} :> 
Span[ {"class" -> "TT"}, {Recurse[] } ],


(* not changed *)
{Cell, "ListNoteBox"} :> 
DIV[ {"class" -> "MathTable"}, {DocumentationBuild`Utils`AddSpans[Recurse[] ]} ], 



(*   removed: ExampleText should be handled by the Cell, All rule.  *)


(* not changed *)
{Cell, "Caption" | "CaptionText"} :> 
P[ {"class" -> "Caption"}, {Recurse[]} ], 

{Cell, "UpgradeLabel"} :> 
P[{"class" -> "UpgradeLabel"}, {Recurse[]} ], 

{Cell, "UpgradeDetail"} :> 
P[{"class" -> "UpgradeDetail"}, {Recurse[]} ],

{Cell, "Text"} :>Module[{cellPrintQ},
cellPrintQ = 
	If[ StringQ[preservedInputForm],
		TrueQ[StringTake[preservedInputForm, 9]==="CellPrint"||StringTake[preservedInputForm, 12]==="Do[CellPrint"],
		False
	];

If[cellPrintQ,
	XMLElement["img", {
            "src" -> ("URL" /. #), "width" -> ("Width" /. #), 
            "height" -> ("Height" /. #), "alt" -> ""
          }, {}]&[
           BoxToImage[ToFileName[{"Files", GetFileNameBase[]},
              "oText_" <> IncrementCounter["oText"] <> ".gif"],
            Inline -> False, MaxImageSize->580, CropImage -> False]
          ]
	, DIV[ {"class" -> "Text"}, {Recurse[]} ]]

], 

{Cell, "ExampleText"} :> P[{}, {Recurse[]} ], 

{Cell, "CR" | "CompactText" | "GroupDivider" | (*"Item" |*) "Leader"} :>
P[ {"class" -> "Text"}, {Recurse[]} ], 


{Cell, "DisplayText" | "Compact12Text" (* | "DisplayFormula" *)} :>
P[ {"class" -> "DT"}, {Recurse[]} ], 


(* not changed *)
{CellGroupData, "BulletedList" | "BulletedText" } :> XMLElement["ul", {}, {Recurse[]}  ],

{Cell, "Item" } :> XMLElement["ul", {"class"->"Text"}, {Li[{"class" -> (GetStyle[]/.None->"FIXME")}, {Recurse[]} ]}  ],

{Cell, "Subitem" } :> XMLElement["ul", {"class"->"Text"}, {Li[{"class" -> "Subitem"}, {Recurse[]} ]}  ],

{Cell, "Subsubitem" } :> XMLElement["ul", {"class"->"Text"}, {Li[{"class" -> "Subsubitem"}, {Recurse[]} ]}  ],

(* not changed *)
{CellGroupData, (* "ItemizedText" | *)"ItemizedList" | "ItemizedSubList"} :>
Ol[{"class" -> (GetStyle[]/.None->"FIXME")}, {Recurse[]} ],


{Cell, "BulletText" | "BulletedList" | (* "ItemizedText" | *)"ItemizedList" | "ItemizedSubList"} :>
Li[{"class" -> (GetStyle[]/.None->"FIXME")}, {Recurse[]} ], 


{Cell, "ItemizedText"} :> P[{"class" -> (GetStyle[]/.None->"FIXME")}, 
Sequence@{XMLElement["span", {}, {IncrementCounter["ItemizedText"] <> ". ", XML`RawXML["&nbsp;"]}],
Recurse[]
} ],

{Cell, "ItemNumbered"} :> P[{"class" -> (GetStyle[]/.None->"FIXME")}, 
Sequence@{XMLElement["span", {}, {IncrementCounter["ItemNumbered"] <> ". ", XML`RawXML["&nbsp;"]}],
Recurse[]
} ],

{Cell, "ItemParagraph"} :> P[{"class" -> (GetStyle[]/.None->"FIXME")}, {Recurse[]} ], 

{Cell, "SectionHowTo"} :> H2[{"class" -> "SectionHowTo"}, {Recurse[]}],
{Cell, "SubsectionHowTo"} :> H3[{"class" -> "SubsectionHowTo"}, {Recurse[]}],
{Cell, "SubsubsectionHowTo"} :> H4[{"class" -> "SubsubsectionHowTo"}, {Recurse[]}],

{Cell, "DeviceSection"} :> H2[{"class" -> "SectionHowTo"}, {Recurse[]}],
{Cell, "DeviceSubsection"} :> H3[{"class" -> "SubsectionHowTo"}, {Recurse[]}],
{Cell, "DeviceSubsubsection"} :> H4[{"class" -> "SubsubsectionHowTo"}, {Recurse[]}],

{Cell, "BulletedText"} :>
UL[{}, {
Li[{"class" -> (GetStyle[]/.None->"FIXME")}, {Recurse[]} ]
}], 


{Cell, "Notes"} :> Li[Flatten[
	{If[HasOption[Background], 
          If[MatchQ[ GetOption[Background], _Dynamic], {"class" -> "modified-text"}, {}], {}]}
          ], {Recurse[]}],

{Cell, "MessageNote"} :> Li[Flatten[
	{If[HasOption[Background], 
          If[MatchQ[ GetOption[Background], _Dynamic], {"class" -> "modified-text"}, {"class"->"MessageNote"}], {"class"->"MessageNote"}]}
          ], {Recurse[]}],

{Cell, "FormatNotes"} :>
  Li[Flatten[
	{If[HasOption[Background], 
          If[MatchQ[ GetOption[Background], _Dynamic], {"class" -> "modified-text"}, {}], {}]}
          ], {Recurse[]}],
          
{Cell, "InterpreterNotes"} :>
  Li[Flatten[
	{If[HasOption[Background], 
          If[MatchQ[ GetOption[Background], _Dynamic], {"class" -> "modified-text"}, {}], {}]}
          ], {Recurse[]}], 

{Cell, "DeviceNotes"} :>
  Li[Flatten[
	{If[HasOption[Background], 
          If[MatchQ[ GetOption[Background], _Dynamic], {"class" -> "modified-text"}, {}], {}]}
          ], {Recurse[]}], 

{Cell, "FormatNotesFirst"} :>
  XMLElement["ul", {If[
        HasOption[CellDingbat], 
          If[MatchQ[ GetOption[CellDingbat], (Cell["6+","ModInfo"] | StyleBox[_, "ModInfo", ___])],
           Sequence@@{"class" -> "FN1", "id"->"ModInfo_"<>"8", "name"->"ModInfo_"<>"8"}, 
            "class" -> "FN1"],   
        "class" -> "FN1"]}, {   
      XMLElement["li", {}, {Recurse[]}] 
  }], 



(* not changed *)
{Cell,  "ItemizedTextNote" | "ItemizedNote" | "ListNote"} :> 
P[ {"class" -> "Item2", "name" -> (GetStyle[]/.None->"FIXME")}, {Recurse[]} ],

{Cell,  "FunctionEssay"} :> 
Module[{functionessaycells}, 
	functionessaycells = Flatten[Cases[SelectSelf[], If[_, a_, b_] :> {a}, Infinity]];
	functionessaycells = Flatten[functionessaycells /. Cell[BoxData[{w___}], "FunctionEssay"]:>{w}];
	If[Length[Cases[functionessaycells, StyleBox["Show Less \[LeftGuillemet]", "FunctionEssay"], Infinity]] > 0,
	    {},
		If[Length[functionessaycells]>0,
		Transmogrify[functionessaycells],
		Li[ {"class" -> "functionessay"}, {Recurse[]} ]
		]
	]
],

{Cell, "IndentedText" | "NotesList" | "TextBelow" | "Item1" | "Contents"} :>
(* P[ {"class" -> "IndentedText", "name" -> (GetStyle[]/.None->"FIXME")}, {Recurse[]} ], *)
P[ {"class" -> "IndTex", "name" -> (GetStyle[]/.None->"FIXME")}, {Recurse[]} ],



(* not changed *)
{Cell, "TextSans" | "SmallTextSans" | "S9" | "HelpLabels"} :>
P[ {"class" -> "TextSans", "name" -> (GetStyle[]/.None->"FIXME")}, {Recurse[]} ],


(* not changed *)
{Cell, "SmallText" | "CopyrightText"} :>
P[ {"class" -> "SmallText", "name" -> (GetStyle[]/.None->"FIXME")}, {Recurse[]} ],



{Cell, "IndexSection" | "Reference" | "LineHead"} :>
(* P[ {"class" -> "IndexSection", "name" -> (GetStyle[]/.None->"FIXME")}, {Recurse[]} ], *)
P[ {"class" -> "IS"<>" "<>GetStyle[]/.None->"FIXME"}, {Recurse[]} ],


{Cell, "Program" | "Code"} :>
WithParameters[{"newline2br" -> True},

If[  htmlBoxesQ[SelectLiteral[SelectSelf[]]],
XMLElement["div", {"class" -> (GetStyle[]/.None->"FIXME")}, {
	XMLElement["pre", {}, Flatten@{
  If[HasOption[CellTags],
  Flatten[ {
    Map[
    (XMLElement["a", {"name" -> #}, {}])&, Flatten[{GetOption[CellTags]}] ],
    Recurse[]  }],
  {Recurse[]  }  ]    }]} ],

DIV[{"class" -> GetStyle[]}, {
  (
    XMLElement["img", { 
      "class" -> "FlushInput", "src" -> ("URL" /. #), 
      "width" -> ("Width" /. #), "height" -> ("Height" /. #),  
      "alt" -> " "  }, {}]&[
      BoxToImage[ToFileName[{"Files", GetFileNameBase[]},
    "Box_" <> IncrementCounter["Inline"] <> ".gif"],
    Inline -> False, CropImage -> False]
    ]
  )}]
]
],


{Cell, "Sound"} :>
A[{"href" ->
    WithParameters[{"href" ->
          (StringReplace[GetFileNameBase[], ".en" -> ""] <> "_" <> IncrementCounter["Sound"] <> ".wav")}, 
      Export[GetParameter["href"], SelectSelf[], "WAV"];
      GetParameter["href"]
  ]}, {Recurse[]} 
],  

{Cell, "SectionHeaderSpacer"}:>Unevaluated[Sequence[]],
{Cell, "SectionFooterSpacer"}:>Unevaluated[Sequence[]],

{Cell, "Chapter" | "Title" | "ChapTitle"} :>
P[ {"class" -> "Title", "name" -> (GetStyle[]/.None->"FIXME")}, {Recurse[]} ],


{Cell, "Section" | "SelArg" | "F12" | "Line1" | "LineSpace" |
"MagicInlineCellMarker" | "PathText" | "SectionFirst" | "SymbolicExpression" | "TOCPage" | 
"TOCSection" | "TOCSubsection" | "TOCSectionDingbat" | "TOCSubsectionDingbat" | "TOCTitle" |
"TOCTitleDingbat" | "TOCTitleDingbat2" | "ObjectName" | "ObjectNameSmall"} :> 
H1[{"class" -> If[styleswitch==="HowTo",(GetStyle[]/.None->"FIXME")<>styleswitch,(GetStyle[]/.None->"FIXME")]}, {Recurse[]}],


{Cell, "Subsection" | "SubsectionIcon" | "SubsectionFirst" | "Command" | 
"ContentsTitle" | "InspectorLevel1"} :>
H2[{"class" -> If[styleswitch==="HowTo",(GetStyle[]/.None->"FIXME")<>styleswitch,(GetStyle[]/.None->"FIXME")]}, {Recurse[]}],

{Cell, "Subsubsection" | "SubsubsectionIcon" | "InspectorLevel2"} :>
If[styleswitch==="HowTo",
	DIV[{"class" -> "howto-main-links"}, {Recurse[]}],
	H3[{"class" -> (GetStyle[]/.None->"FIXME")}, {Recurse[]}]],

{Cell, "Subsubtitle" | "Subsubsubsection" | "ItemDingbat"} :>
WithParameters[{"newline2br" -> True},
	H4[{"class" -> (GetStyle[]/.None->"FIXME")}, {Recurse[]}]
],

{Cell, "NotesSubsection"} :> XMLElement["h5", {}, {Recurse[]}],

{Cell, "SessionLabel"} :> XMLElement["h3", {}, {Recurse[]}],

{Cell, "Subtitle"} :> WithParameters[{"newline2br" -> True},
H3[{"class" -> (GetStyle[]/.None->"FIXME")}, {
	XMLElement["font", {"color" -> "#000066", "face" -> "italic"}, {Recurse[]}] 
	} ]
],  


{Cell, "SubsubsectionColor"} :> WithParameters[{"newline2br" -> True},
H3[{"class" -> (GetStyle[]/.None->"FIXME")}, {
	XMLElement["font", {"color" -> "#330066"}, {Recurse[]}] 
	} ]
],  


{Cell, "CharacterName" | "CharacterObjectWarningMessages"} :>
(*  P[ {"class" -> "CharacterObjectName"}, {Recurse[]} ],   *)
P[ {"class" -> "CON"}, {Recurse[]} ], 


{Cell, "CopyrightHead"} :>
  WithParameters[{"newline2br" -> True},
    P[{"class" -> "SmallText"}, {
      XMLElement["b", {}, {Recurse[]}]
    }]  ],


{Cell, "Header"} :>
  WithParameters[{"newline2br" -> True},
    P[{"class" -> "SmallText"}, {
      XMLElement["i", {}, {Recurse[]}]
    }]  ],
  
{Cell, "KeyEvent"} :>XMLElement["span", {"class"->"KeyEvent"}, {Recurse[]}],

(* TODO use Brendan's code to add sensible Alt/title tags. *)
{Cell, "Message" | "StandardForm"} :>
transmogrifyImage[ToFileName[{"Files", GetFileNameBase[]},
    IncrementCounter["Image"] <> ".gif"],{"alt"->"", "class"->"Message"},
    Inline -> True, CropImage -> False],


(* TODO use Brendan's code to add sensible Alt/title tags. *)
{Cell, "Print"} :>
(*DIV[{"class" -> "Print"}, {
  transmogrifyImage[ToFileName[{"Files", GetFileNameBase[]},
    IncrementCounter["Image"] <> ".gif"],
    Inline -> False, CropImage -> False]
}],*)
DIV[{"class" -> "Print"}, {
  (
    XMLElement["img", { 
      "class" -> "FlushInput", "src" -> ("URL" /. #), 
      (*"width" -> ("Width" /. #), "height" -> ("Height" /. #),  *)
      "alt" -> " "  }, {}]&[
      BoxToImage[ToFileName[{"Files", GetFileNameBase[]},
    "Image_" <> IncrementCounter["Image"] <> ".gif"],
    Inline -> False, CropImage -> False]
    ]
  )}],


{TextData, All} :> Recurse[],



(** Input/Ouput Cell Groups **)
{CellGroupData, "Input"} :> 
Module[{allCellIDs},
  allCellIDs = ToString /@ Cases[SelectLiteral[ SelectSelf[] ], Cell[___, CellID->id_, ___]:>id, Infinity];
  DIV[ {"class"->"IO"}, {Recurse[]} ]
],


(** Input Cells **)
(* TODO use Brendan's code to add sensible Alt/title tags to 'InlineInput'. *)
{Cell, "InlineInput"} :>
If[
  htmlBoxesQ[ SelectLiteral[ SelectSelf[] ] ], 
  Transmogrify[ SelectChildren[] ],
  (
    XMLElement["img", { 
      (* "style" -> "vertical-align:-20%", *)
      "style" -> "vertical-align:middle",
      "class" -> "FlushInput", "src" -> ("URL" /. #), 
      "width" -> ("Width" /. #), "height" -> ("Height" /. #), 
      "alt" -> " "  }, {}]&[
      BoxToImage[ToFileName[{"Files", GetFileNameBase[]},
    "Box_" <> IncrementCounter["Inline"] <> ".gif"],
    Inline -> True, CropImage -> False]
    ]
  )
],



(** Input Cells **)
(* TODO USe Brendan's code to add sensible Alt/Title tags to Deemphasis. *)
(* TODO Update to use transmogrifyImage[]. *)
{Cell, "Deemphasis"(* | "Code"  *)} :>
DIV[{"class" -> GetStyle[]}, {
  (
    XMLElement["img", { 
      "class" -> "FlushInput", "src" -> ("URL" /. #), 
      "width" -> ("Width" /. #), "height" -> ("Height" /. #),  
      "alt" -> " "  }, {}]&[
      BoxToImage[ToFileName[{"Files", GetFileNameBase[]},
    "Box_" <> IncrementCounter["Inline"] <> ".gif"],
    Inline -> False, CropImage -> False]
    ]
  )}],





{Cell, "IndexSection" | "Reference" | "LineHead"} :>
(* P[{"class" -> "IndexSection", "name" -> (GetStyle[]/.None->"FIXME")},  *)
P[{"class" -> "IS", "name" -> (GetStyle[]/.None->"FIXME")}, 
  If[HasOption[CellTags],
  Flatten[ {
    Map[
    (XMLElement["a", {"name" -> #}, {"yyyyyyy"}])&, Flatten[{GetOption[CellTags]}] ],
    Recurse[]  }],
  {Recurse[]}  ]    
],


{Cell, "FilenameExtension"} :> Span[{"class"->"FilenameExtension"}, { Recurse[] }],

(* TODO USe Brendan's code to add sensible Alt/Title tags to LegacyInput. *)
{Cell, "LegacyInput"} :>
Module[{iForm},
iForm = CreateInputForm[ SelectSelf[] ];
iForm = If[Head@iForm === String, iForm, ToString@iForm];

DIV[{"class" -> "LegacyInput"}, 
	{XMLElement["span", {"class"->"LegacyVersion"}, {"Version 5.2"}], transmogrifyImage[ToFileName[{"Files", GetFileNameBase[]}, 
          "legacy_" <> IncrementCounter["legacy"] <> ".gif"],
      {"alt" -> iForm},
          Inline -> True, CropImage -> False]}]
],

{Cell, "LegacyInputV7"} :>
Module[{iForm},
iForm = CreateInputForm[ SelectSelf[] ];
iForm = If[Head@iForm === String, iForm, ToString@iForm];

DIV[{"class" -> "LegacyInputV7"}, 
	{XMLElement["span", {"class"->"LegacyVersion"}, {"Version 6.0"}], transmogrifyImage[ToFileName[{"Files", GetFileNameBase[]}, 
          "legacy_" <> IncrementCounter["legacy"] <> ".gif"],
      {"alt" -> iForm},
          Inline -> True, CropImage -> False]}]
],

{Cell, "LegacyInputV8"} :>
Module[{iForm},
iForm = CreateInputForm[ SelectSelf[] ];
iForm = If[Head@iForm === String, iForm, ToString@iForm];

DIV[{"class" -> "LegacyInputV7"}, 
	{XMLElement["span", {"class"->"LegacyVersion"}, {"Version 7.0"}], transmogrifyImage[ToFileName[{"Files", GetFileNameBase[]}, 
          "legacy_" <> IncrementCounter["legacy"] <> ".gif"],
      {"alt" -> iForm},
          Inline -> True, CropImage -> False]}]
],

{Cell, "LegacyInputV9"} :>
Module[{iForm},
iForm = CreateInputForm[ SelectSelf[] ];
iForm = If[Head@iForm === String, iForm, ToString@iForm];

DIV[{"class" -> "LegacyInputV7"}, 
	{XMLElement["span", {"class"->"LegacyVersion"}, {"Version 8.0"}], transmogrifyImage[ToFileName[{"Files", GetFileNameBase[]}, 
          "legacy_" <> IncrementCounter["legacy"] <> ".gif"],
      {"alt" -> iForm},
          Inline -> True, CropImage -> False]}]
],

{Cell, "LegacyInputWE"} :>
Module[{iForm},
iForm = CreateInputForm[ SelectSelf[] ];
iForm = If[Head@iForm === String, iForm, ToString@iForm];

DIV[{"class" -> "LegacyInputV7"}, 
	{XMLElement["span", {"class"->"LegacyVersion"}, {"Wavelet Explorer"}], transmogrifyImage[ToFileName[{"Files", GetFileNameBase[]}, 
          "legacy_" <> IncrementCounter["legacy"] <> ".gif"],
      {"alt" -> iForm},
          Inline -> True, CropImage -> False]}]
],

{Cell, "LegacyInputError"} :>
Module[{iForm},
iForm = CreateInputForm[ SelectSelf[] ];
iForm = If[Head@iForm === String, iForm, ToString@iForm];

DIV[{"class" -> "LegacyInputError"}, 
	{XMLElement["span", {"class"->"LegacyVersion"}, {"Version 5.2"}], transmogrifyImage[ToFileName[{"Files", GetFileNameBase[]}, 
          "legacy_" <> IncrementCounter["legacy"] <> ".gif"],
      {"alt" -> iForm},
          Inline -> True, CropImage -> False], XMLElement["span", {"class"->"LegacyError"}, {"returns unevaluated"}]}]
],

{Cell, "LegacyInputErrorV7"} :>
Module[{iForm},
iForm = CreateInputForm[ SelectSelf[] ];
iForm = If[Head@iForm === String, iForm, ToString@iForm];

DIV[{"class" -> "LegacyInputErrorV7"}, 
	{XMLElement["span", {"class"->"LegacyVersion"}, {"Version 6.0"}], transmogrifyImage[ToFileName[{"Files", GetFileNameBase[]}, 
          "legacy_" <> IncrementCounter["legacy"] <> ".gif"],
      {"alt" -> iForm},
          Inline -> True, CropImage -> False], XMLElement["span", {"class"->"LegacyError"}, {"returns unevaluated"}]}]
],

{Cell, "LegacyInputErrorV8"} :>
Module[{iForm},
iForm = CreateInputForm[ SelectSelf[] ];
iForm = If[Head@iForm === String, iForm, ToString@iForm];

DIV[{"class" -> "LegacyInputErrorV7"}, 
	{XMLElement["span", {"class"->"LegacyVersion"}, {"Version 7.0"}], transmogrifyImage[ToFileName[{"Files", GetFileNameBase[]}, 
          "legacy_" <> IncrementCounter["legacy"] <> ".gif"],
      {"alt" -> iForm},
          Inline -> True, CropImage -> False], XMLElement["span", {"class"->"LegacyError"}, {"returns unevaluated"}]}]
],

{Cell, "LegacyInputErrorV9"} :>
Module[{iForm},
iForm = CreateInputForm[ SelectSelf[] ];
iForm = If[Head@iForm === String, iForm, ToString@iForm];

DIV[{"class" -> "LegacyInputErrorV7"}, 
	{XMLElement["span", {"class"->"LegacyVersion"}, {"Version 8.0"}], transmogrifyImage[ToFileName[{"Files", GetFileNameBase[]}, 
          "legacy_" <> IncrementCounter["legacy"] <> ".gif"],
      {"alt" -> iForm},
          Inline -> True, CropImage -> False], XMLElement["span", {"class"->"LegacyError"}, {"returns unevaluated"}]}]
],

(* TODO USe Brendan's code to add sensible Alt/Title tags to SetterBox. *)
SetterBox :>
Span[{"class" -> ""}, 
	{( transmogrifyImage[ToFileName[{"Files", GetFileNameBase[]}, 
          "I_" <> IncrementCounter["Image"] <> ".gif"],
      {"alt" -> "Setter"},
          Inline -> True, CropImage -> False]
    )}],


CounterBox :> Span[
{"class"->"RefNumber"}, {IncrementCounter["CounterBox"]}   ],


(* TODO USe popup info as alt/title tags? *)
(* TODO test for links & add a/link wrapper if positive test. *)
{Cell, "FlushInput" | "Input" | "InputOnly" | "InputDeemphasis"} :> Module[
  {
    iId = StringJoin["i_", IncrementCounter["iInner"]],
    iInner, iOuter, inputForm, inputFormQueue, isManipulate, id, urlOrig, urlEncoded,
    inputVals, base, inBase, celtag, url
  },

  iInner = StringJoin[iId, "_in"];
  iOuter = StringJoin[iId, "_out"];
  inputForm = CreateInputForm[ SelectSelf[] ];
  preservedInputForm = inputForm;
  inputForm = If[Head@inputForm === String, inputForm, ToString@inputForm];
  inputFormQueue = inputQueue[inputForm, GetOption[CellLabel]];
  celtag = If[HasOption[CellTags], GetOption[CellTags], False];
  url = GetParameter["url"];

  isManipulate = If[
    IsManipulate === True
  , 
    (DocumentationBuild`Utils`IsManipulateQ[ SelectLiteral[SelectSelf[] ]] (*&& GetParameter["entityType"] === "Symbol"*)  )
  ,
    False
  ];

  id = If[HasOption[CellID], "#"<>ToString@GetOption[CellID], ""];
  urlOrig = "http://reference.wolfram.com/language/" <> GetParameter["url"] <> ".html" <> id;
  urlOrig = If[!StringFreeQ[urlOrig, "FIXME"], False, urlOrig];
  urlEncoded = If[StringQ[urlOrig], Pubs`ShortenURL@urlOrig, ""];


  Sequence@@{  
    XMLElement["table", {"class" -> If[celtag==="ErrorCellBracket","InCellBracket","InCell"]},  {  
      XMLElement["tr", {}, {

        (* cell label <td> *)
        XMLElement["td", {"class" -> "lab" (* , ""-""<> *)}, 
          Sequence @@ {
            If[
              HasOption[CellTags]
            ,
              Flatten[{
                If[
                  HasOption[CellLabel]
                ,
                  (* fill it with the CellLabel text *)
                  { GetOption[CellLabel] }
                ,
                  (* otherwise it's empty *)
                  {}
                ] (* end If *)
              }]
            ,  
              If[
                HasOption[CellLabel]
              ,
                (* fill it with the CellLabel text *)
                { GetOption[CellLabel] }
              ,
                (* otherwise it's empty *)
                {}
              ]
            ] 
          }
        ],
    
        (* input <td> *)
        XMLElement["td", {"class" -> "Input"}, {

          (* hidden input layer *)
          DIV[{}, {
            (* Check for Manipulate *) 
            If[
              isManipulate
            ,
              transmogrifyImage[
                ToFileName[{"Files", GetFileNameBase[]}, "I_" <> IncrementCounter["iInner"] <> ".png"],
                { "alt" -> "Click for copyable input" },
                Inline -> True, CropImage -> False, ImageFormat -> "PNG"
              ]
            ,
              transmogrifyImage[
                ToFileName[{"Files", GetFileNameBase[]}, "I_" <> IncrementCounter["iInner"] <> ".png"],
                {"alt" -> "Click for copyable input" },
                Inline -> True, CropImage -> False, ImageFormat -> "PNG"
              ]
            ]
          }], (* end <div> *) 

          Module[{str, inputForm, inputFormQueue},
            (* get fresh input-form stuff to avoid the expr coming out as $Failed *)
            inputForm = ToString[CreateInputForm[ SelectSelf[] ]];
            inputFormQueue = DocumentationBuild`Export`inputQueue[inputForm, GetOption[CellLabel]];

            str = StringJoin @@ Map[
              ExportString[#, "XML"]&,
              {
                XMLElement["pre", {"name" -> iInner,  "id" -> iInner,  "class"->"IFT" }, {inputFormQueue}],
                DIV[{"class"->"IFU" }, { urlEncoded }]
              }
            ];
            CreateDirectory[ToFileName[{"Files", GetFileNameBase[]}]];
            Export[ToFileName[{"Files", GetFileNameBase[]}, iId<>".txt"], str, "Text"];    
            XMLElement["div", {"id" -> iOuter, "class"->"IFL"}, {""}]
          ]
        }], (* end <td> *) 

        If[
          celtag==="ErrorCellBracket"
        ,
          XMLElement["td", {"class" -> "RedCellBracket"}, {}]
        ,
          Unevaluated@Sequence[]
        ]
      }] (* end <tr> *) 
    }] (* end <table> *)
  }
],
    
(** 
  Output Cells
  right now turn all output cells into images.
**)

(* TODO USe Brendan's code alt/title tags? *)
(* TODO test for links & add a/link wrapper if positive test. *)

{Cell, "Output" | "OutputOnly" | "Echo"} :> Module[
  {
    outCell, isEcho, isManipulate, isSound, isSoundNote, soundPath,
    soundID, soundExpr, manipulateExpr, manipulatetiming, ret, val,
    outputVals, outBase, multipleSWFQ, optMaxImageSize = 580
  },

  outCell = SelectLiteral[SelectSelf[] ];

  multipleSWFQ = If[StringLength@preservedInputForm > 9, 
    TrueQ[StringTake[preservedInputForm,10]==="Manipulate"], 
    False];

  isManipulate = If[IsManipulate===True, 
    (DocumentationBuild`Utils`IsManipulateQ[ outCell] && (*GetParameter["entityType"] === "Symbol" &&*) multipleSWFQ),
    False];

  isSound = DocumentationBuild`Utils`IsSoundQ[ outCell];
  isSoundNote = !FreeQ[ outCell, _SoundNote];
  isEcho = Positive @ Count[{outCell}, Cell[_, "Echo", ___]];

  (* Use ImageList[...] to obtain Baseline value *)
  (* TODO *)
  (*
  outputVals=First@Cases[ImageList[
        BoxToImage[ToFileName[{"Files", GetFileNameBase[]},
      "Box_" <> IncrementCounter["Inline"] <> ".gif"],
      Inline -> True, CropImage -> False]
  ], _];
  outBase=StringDrop[Cases[outputVals, "Baseline"~(Rule|RuleDelayed)~x_ -> x], -1];
  *)

  If[
    HasOption[CellLabel] && StringMatchQ[GetOption[CellLabel], "*Form*" |"*Short*"],
    
    (* true clause *)
    If[StringMatchQ[GetOption[CellLabel], "*TableForm*"],
      optMaxImageSize = Infinity];

    (* handle //*Form output *)
    XMLElement["table", {"class"->"OCell"}, {
      XMLElement["tr", {}, {
        XMLElement["td", {"colspan" -> "2"}, {
        (* this extra span just snags the inline styles from the celllabel block styles. width is overridden in the colspan="2" attribute *)
          If[
            HasOption[CellLabel]
          , 
            XMLElement[
              "div",
              {"class" -> "celllabelTableForm"},
              (* https://jira.wolfram.com/jira/browse/WLDOCS-1056 *)
              If[StringContainsQ[GetOption[CellLabel], "//MatrixForm="] ,
                {StringReplace[GetOption[CellLabel], "//MatrixForm=" -> ""], XMLElement["span", {}, {"//MatrixForm="}]} ,
                {GetOption[CellLabel]}
              ]
            ]
          ,
            XMLElement["div", {"class" -> "celllabelTableForm"}, {}]
          ]
        }] 
      }], (* end tr  *)

      XMLElement["tr", {}, {
        (* empty td for fixed width *)
        XMLElement["td", {"class" -> "lab"}, {" "}],
          XMLElement["td", {"class" -> If[isEcho, "Echo", "Output"]}, {
            (
              If[MemberQ[{"XXXXXXX"}, StringDrop[GetFileNameBase[], -3]], 
                (* true (this clause is an old kludge) *)
                Module[{imageName, imageExport, imageSizes, xportInfo},
                  imageName = ToFileName[{"Files", GetFileNameBase[]}, "O_" <> IncrementCounter["iOutput"] <> ".png"];  
                  xportInfo = System`ConvertersDump`ToRasterDataPacket[
                    Evaluate[DeleteCases[Transmogrify`Private`mangleCell[SelectSelf[], True], Rule[GridBoxOptions, __], Infinity]],
                    "PNG"
                  ];
                  imageExport = Export[
                    imageName,
                    System`ConvertersDump`FromRasterDataPacket[ReplacePart[xportInfo, Take[xportInfo[[3]], All, Min[550, Dimensions[xportInfo[[3]]][[2]]]], 3]],
                    "PNG"
                  ];
                  imageSizes = Import[ToFileName[{Directory[]}, imageName], "ImageSize"];

                  XMLElement["img", {
                    "src" -> StringReplace[imageName, {"\\"->"/"}],
                    "width" -> ToString@First@imageSizes, 
                    "height" -> ToString@Last@imageSizes,
                    "alt" -> ""
                  }, {}]

                ]
              , 
                (* false *)
                If[StringMatchQ[GetOption[CellLabel], "*TableForm*"],
                  (* true: we're working with a TableForm cell, wrap with div to allow for wide images *)
                  XMLElement["div", {"class"->"TableForm"}, {
                    XMLElement["img", {
                      "src" -> ("URL" /. #),
                      "width" -> ("Width" /. #), 
                      "height" -> ("Height" /. #),
                      "alt" -> ""
                    }, {}]& [
                      BoxToImage[
                        ToFileName[{"Files", GetFileNameBase[]}, "O_" <> IncrementCounter["iOutput"] <> ".png"],
                        Inline -> True,
                        MaxImageSize->optMaxImageSize,
                        CropImage -> False,
                        ImageFormat -> "PNG"
                      ]
                    ] 
                  }],
                  (* false *)
                  XMLElement["img", {
                    "src" -> ("URL" /. #),
                    "width" -> ("Width" /. #), 
                    "height" -> ("Height" /. #),
                    "alt" -> ""
                  }, {}]& [
                    BoxToImage[
                      ToFileName[{"Files", GetFileNameBase[]}, "O_" <> IncrementCounter["iOutput"] <> ".png"],
                      Inline -> True,
                      MaxImageSize->optMaxImageSize,
                      CropImage -> False,
                      ImageFormat -> "PNG"
                    ]
                  ] (* close false clause *)
                ] (* close If TableForm *)
              ] (* close If {"XXXXXXX"} *)
            ) (* close Output td body *)
            }] (*  close Output td *)
          }] (*  close tr *)
      }] (*  close OCell table *)
  ,

  (* otherwise handle normal output *)
  XMLElement["table",
    {"class"->"OCell"}, {
      XMLElement["tr",
        {}, {
          (* cell label <td> *)
          XMLElement["td",
            {"class" -> "lab"}, 
            If[HasOption[CellLabel],
              (* fill it with the CellLabel text *)
              {GetOption[CellLabel]}
            ,
              (* otherwise it's empty *)
              {}
            ] (* end If *)
          ], (* end cell label <td> *)

          XMLElement["td",
            {"class" -> If[isEcho, "Echo", "Output"]}, {
              Which[

                isManipulate, (
                  (*Print["<" <> GetFileNameBase[] <> ": Manipulate Output cell>"];*) 
                  flashID = "Flash_" <> IncrementCounter["flash"];
                  swfPath = StringReplace[ToFileName[{"Files", GetFileNameBase[]}, flashID <> ".swf"],  {"\\" -> "/"}];
                  opts = {"ShowControls" -> True, "ControlAppearance" -> Automatic,  "AnimationParameters"->Hold[val] };
                  manipulateExpr = ReleaseHold@MakeExpression[First@SelectLiteral[SelectChildren[]], StandardForm];
                  If[cache,
                    (* true clause: caching is turned on *)
                    AntLog["caching is set"]; 
                    If[
                      (* test clause: is a cached swf unavailable? *)
                      ToString[Quiet[Import[
                        "http://reference.devel2.wolfram.com/language/cache/"
                        <> ToString[Hash[manipulateExpr, "MD5"]]
                        <> "_"
                        <> ToString[Hash[SystemInformation["Kernel", "ReleaseID"], "MD5"]]
                        <> ".swf", "Byte"]]
                      ] === "$Failed"
                    , 
                      (* true clause: generate an swf and cache it *)
                      manipulatetiming=AbsoluteTiming[ret = Export[swfPath, manipulateExpr, Sequence @@ opts]];
                      AntLog["Manipulate conversion time: "<>ToString[manipulatetiming]];

                      CreateDirectory[FileNameJoin[Flatten[{FileNameSplit[cachelocation], "cache"}]]]; 

                      CopyFile[
                        ret,
                        FileNameJoin[Flatten[{
                          FileNameSplit[cachelocation],
                          "cache",
                          ToString[Hash[manipulateExpr, "MD5"]]
                          <> "_"
                          <> ToString[Hash[SystemInformation["Kernel", "ReleaseID"], "MD5"]]
                          <> ".swf"}]]
                      ];

                      Export[
                        FileNameJoin[Flatten[{
                          FileNameSplit[cachelocation],
                          "cache",
                          ToString[Hash[manipulateExpr, "MD5"]]
                          <> "_"
                          <> ToString[Hash[SystemInformation["Kernel", "ReleaseID"], "MD5"]]
                          <> ".swf.txt"
                        }]],
                        ImageSize /. val,
                        "CSV"
                      ];
                      {width, height} = ImageSize /. val;
                      AntLog["cached in cache folder"];
                    ,
                      (* false clause: use the cached swf from devel2 *)
                      AntLog["using cached swf from devel2"]; 
                      ret = Export[
                        swfPath,
                        Import[
                          "http://reference.devel2.wolfram.com/language/cache/"
                          <> ToString[Hash[manipulateExpr, "MD5"]]
                          <> "_"
                          <> ToString[Hash[SystemInformation["Kernel", "ReleaseID"], "MD5"]]
                          <> ".swf",
                          "Byte"
                        ],
                        "Byte"
                      ];

                      {{width}, {height}} = Import[
                        "http://reference.devel2.wolfram.com/language/cache/"
                        <> ToString[Hash[manipulateExpr, "MD5"]]
                        <> "_"
                        <> ToString[Hash[SystemInformation["Kernel", "ReleaseID"], "MD5"]]
                        <> ".swf.txt",
                        "CSV"
                      ];
                    ] (* end If: is a cached swf unavailable? *)
                  , 
                    (* false clause: caching is turned off *)
                    ret = Export[swfPath, manipulateExpr, Sequence @@ opts];
                  ];
     
                (* and now write the results to the xml output *)
                A[
                  {
                    "href" -> "javascript:swap(this,"
                    <> ToString[width]
                    <> ","
                    <> ToString[height]
                    <> ",'"
                    <> swfPath
                    <> "','"
                    <> flashID
                    <> "')"
                  },
                  {
                    Span[{"class" -> "playAnimation"}, {"Play Animation"}],
                    Span[
                      {"id"->flashID},
                      {transmogrifyImage[ToFileName[{"Files", GetFileNameBase[]}, IncrementCounter["Image"] <> ".png"],{"alt"->""}, Inline -> True, CropImage -> False, ImageFormat -> "PNG"]}
                    ]
                  }
                ]
              ),  (* end isManipuate branch of the Output td *)

              isSoundNote, (
                (*Print["<" <> GetFileNameBase[] <> ": SoundNote Output cell>"]; *)
                soundID = "SoundNote_" <> IncrementCounter["soundnote"];
                soundPath = StringReplace[ToFileName[{"Files", GetFileNameBase[]}, soundID <> ".mid"],  {"\\" -> "/"}];
                If[
                  (* test clause *)
                  Length[Cases[First@outCell, _Sound, Infinity]] === 1
                ,
                  (* true clause *)
                  soundExpr = First@Cases[outCell, _Sound, Infinity];
                  ret = Export[soundPath, soundExpr];
                  A[
                    {"href"->soundPath},
                    {
                      XMLElement[
                        "span",
                        {"id"->soundID},
                        {transmogrifyImage[ToFileName[{"Files", GetFileNameBase[]}, IncrementCounter["Image"] <> ".png"], {"alt"->""}, Inline -> True, CropImage -> False, ImageFormat -> "PNG"]}
                      ]
                    }
                  ]
                ,
                  (* false clause *)
                  XMLElement[
                    "span",
                    {"id"->soundID},
                    {transmogrifyImage[ToFileName[{"Files", GetFileNameBase[]}, IncrementCounter["Image"] <> ".png"],{"alt"->""}, Inline -> True, CropImage -> False, ImageFormat -> "PNG"]}
                  ]
                ]
              ), (* end isSoundNote branch of the Output td *)

              isSound, (
                (*Print["<" <> GetFileNameBase[] <> ": Sound Output cell>"]; *)
                soundID = "Sound_" <> IncrementCounter["sound"];
                soundPath = StringReplace[ToFileName[{"Files", GetFileNameBase[]}, soundID <> ".wav"],  {"\\" -> "/"}];
                Which[

                  StringDrop[GetFileNameBase[], -3] === "Music",
                  XMLElement[
                    "span",
                    {"id"->soundID},
                    {transmogrifyImage[ToFileName[{"Files", GetFileNameBase[]}, IncrementCounter["Image"] <> ".png"], {"alt"->""}, Inline -> True, CropImage -> False, ImageFormat -> "PNG"]}]
                ,

                  Length[Cases[First@outCell, _Sound, Infinity]] === 1,
                  soundExpr=Sound@@Cases[First@outCell, _Sound, Infinity];
                  Quiet[ret = Export[soundPath, soundExpr]];
                  A[
                    {"href"->soundPath}, {
                      XMLElement[
                        "span",
                        {"id"->soundID},
                        {transmogrifyImage[ToFileName[{"Files", GetFileNameBase[]}, IncrementCounter["Image"] <> ".png"], {"alt"->""}, Inline -> True, CropImage -> False, ImageFormat -> "PNG"]}]}]
                ,

                  (* Length@Cases[outCell, CompressedData[a__], Infinity]>0, Last@Cases[outCell, _Sound, Infinity],*)
                  True,
                  XMLElement[
                    "span",
                    {"id"->soundID},
                    {transmogrifyImage[ToFileName[{"Files", GetFileNameBase[]}, IncrementCounter["Image"] <> ".png"], {"alt"->""}, Inline -> True, CropImage -> False, ImageFormat -> "PNG"]}]
                ] (* end isSound Which *)
              ), (* end isSound branch of the Output td *)

          True, (
            (* automatically provide a horizontal scrollbar for images wider than the css output-image width *)
            optMaxImageSize = Infinity;
            XMLElement["div",
              {"class" -> "output-image"}, {
                transmogrifyImage[
                  ToFileName[{"Files", GetFileNameBase[]}, "O_" <> IncrementCounter["iOutput"] <> ".png"],
                  {"alt"->""},
                  Inline -> True,
                  MaxImageSize->optMaxImageSize,
                  CropImage -> False,
                  ImageFormat -> "PNG"
                ]
              }
            ]
          )
       ] 

    }] (* end Output <td> *)

    }] (*  close tr  *)  
  }] (*  close table  *) 
] ], (* end "Output" rule *)


{Cell, "InlineFormulaTableText"} :> XMLElement["span", {"class"->"IF"}, {Recurse[]}],

(* https://jira.wolfram.com/jira/browse/WLDOCS-790 *)
{Cell, "InlineFormula"} :> 
  Span[
    {"class" -> If[GetStyle[] === "InlineMath", "IM", "IF"]}, 
    {DocumentationBuild`Utils`AddSpans[Recurse[] ]}
  ],

{Cell, "InlineCode" | "InlineOutput" | "InlineMath" | "FunctionTemplate"} :> 
Module[{thestyle},
thestyle = GetStyle[];
Span[{"class"->
If[thestyle==="InlineMath", "IM", "IF"]}, 
  If[Cases[SelectSelf[], _ButtonBox|_TemplateBox, Infinity]==={}, 
  	{
  		transmogrifyImage[ToFileName[{"Files", GetFileNameBase[]},
         IncrementCounter["Image"] <> ".png"], {"alt"->""},
         Inline -> True, CropImage -> False, ImageFormat -> "PNG", TransparentBackground->True, ConversionOptions->{Background->None}
      ]
    }, 
    {DocumentationBuild`Utils`AddSpans[Recurse[] ]}
  ]
  (*If[htmlBoxesQ[SelectLiteral[SelectSelf[]]],
    {DocumentationBuild`Utils`AddSpaces[ Recurse[] ]},
    { transmogrifyImage[ToFileName[{"Files", GetFileNameBase[]},
         IncrementCounter["Image"] <> ".gif"], {"style" -> "vertical-align:middle;"}, "TransparentColor" -> White, 
         Inline -> True, CropImage -> False
      ]
    }
  ]*)
]
], 


{Cell, "DisplayFormula" | "DisplayMath"} :> 
DIV[{"class"->"DisplayFormula"}, 
    { transmogrifyImage[ToFileName[{"Files", GetFileNameBase[]},
         IncrementCounter["Image"] <> ".gif"],{"alt"->""},
         Inline -> False, CropImage -> False
      ]
    }
  ], 



(* Sans version of InlineFormula *)
{Cell, "InlineFunctionSans"} :>
  Span[{"class"->"IFSans"}, { Recurse[] }],


{BoxData}:> Recurse[],

  
{SuperscriptBox} :> Sequence@@{
  Transmogrify[SelectChildren[][[1]] ],
  XMLElement["sup", {} , {Transmogrify[SelectChildren[][[2]]]} ]
},


{SubscriptBox} :> Sequence@@{
  Transmogrify[SelectChildren[][[1]] ],
  XMLElement["sub", {}, {Transmogrify[SelectChildren[][[2]]]} ]
},



{CellGroupData, "PictureGroup"} :>
(
  If[HasOption[First[SelectChildren[Cell]], AnimationCycleRepetitions],
  {
  XMLElement["p", {"class" -> "Animation"}, {
    WithParameters[{"src" -> ToFileName[{"Files", GetFileNameBase[]},
        "A_" <> IncrementCounter["Animation"] <> ".gif"]},
      CreateDirectory[DirectoryName[GetParameter["src"]]];
      Export[GetParameter["src"],
        SelectLiteral[SelectChildren[]], "GIF", 
        ConversionOptions -> {"Loop" -> 3}];
      XMLElement["img", {
        "src" -> StringReplace[GetParameter["src"], $PathnameSeparator -> "/"]
      }, {}]
    ]
  }]

   }
   ,
   
   XMLElement["p", If[GetStyle===None, {}, {"class"->GetStyle[]}], 
    {
    XMLElement["img", {
      "src" -> ("URL" /. #),
      "width" -> ("Width" /. #), "height" -> ("Height" /. #), "alt" -> " "
        }, {}]&[BoxToImage[ToFileName[{"Files", GetFileNameBase[]},
      "A_" <> IncrementCounter["Animation"] <> ".gif"],
      Inline -> False ]]
    }
  ]
]
),

{Cell, "Usage"} :> DIV[{"id" -> "UT"},
Block[{usagegrid = True},
    Module[{xml = {Recurse[]}, pos, repl, first = True},
    pos = Position[xml, XMLElement["tr", _, _], Infinity];
    repl = Map[
        Module[{tr, attr, children, modinfo},
            tr = Extract[xml, #];
            modinfo = False;
            modinfo = MatchQ[tr[[3, 1]],
                XMLElement["td", _, {
                    XMLElement["span", {___, "id"->"ModInfo_"<>"8", ___}, _] }] ];
            attr = Join[
                DeleteCases[tr[[2]], _["name"|"id", _]],
                If[modinfo, {"name"->"ModInfo_"<>"8", "id"->"ModInfo_"<>"8"}, {}] ];
            If[first,
                first = False,
                attr = Join[
                    DeleteCases[attr, _["class", _]],
                    {"class" -> ("class" /. attr /. {"class" -> ""}) <> " lineAbove"}]];
            children = Map[
                Function[{td}, Module[{attr},
                    attr = td[[2]];
                    If[MatchQ[attr, {___, "class" -> _, ___}],
                        attr = ReplaceAll[attr, _["class", _] -> ("class" -> "UM")],
                        attr = Join[attr, {"class" -> "UM"}]];
                    attr = Join[
                        DeleteCases[attr, _["name"|"id", _]],
                        If[modinfo, {"name"->"ModInfo_"<>"8", "id"->"ModInfo_"<>"8"}, {}] ];
                    XMLElement["td", attr, td[[3]]]
                ]],
                Rest[tr[[3]]] ];
            (# -> XMLElement["tr", attr, children])
        ]&,
        pos];
    ReplacePart[xml, repl] ]]
], (* end block  *)

{CellGroupData, "FormatUsage"} :>  If[GetParameter["entityType"]=="Interpreter", 
	                                      {Recurse[]}, 
	                                      {Transmogrify[First[SelectChildren[]]], 
	                                      	  XMLElement["ul", {"class"->"functionList afterIntro"}, {Transmogrify[Rest[SelectChildren[]]]}]}
	                                  ],

{Cell, "FormatUsage"} :>  Module[{}, XMLElement["div", {"class"->"formatIntroWrap"}, 
	{XMLElement["div", {"class"->"formatIntro"}, {Recurse[]}]}]],
	
{CellGroupData, "InterpreterUsage"} :>  {Recurse[]},

{Cell, "InterpreterUsage"} :>  Module[{}, XMLElement["div", {"class"->"formatIntroWrap"}, 
	{XMLElement["div", {"class"->"formatIntro"}, {Recurse[]}]}]],  

{CellGroupData, "DeviceUsage"} :>  {Transmogrify[First[SelectChildren[]]],
	XMLElement["ul", {"class"->"functionList afterIntro"}, {Transmogrify[Rest[SelectChildren[]]]}]},  

{Cell, "DeviceUsage"} :>  Module[{}, XMLElement["div", {"class"->"formatIntroWrap"}, 
	{XMLElement["div", {"class"->"formatIntro"}, {Recurse[]}]}]], 

{Cell, "AnchorBarGrid" } :> 
Module[{MenuCounter, SeeAlsoFunctionList, MoreAboutGuideList, ExampleSectionList, TutorialList, GuideMoreAboutList, GuideTutorialList, 
	GuideFunctionList, AnchorBarData, TutorialFunctionList, TutorialMoreAboutList, RelatedTutorialsList, thisElementContent, 
	uriDepth, uri = GetParameter["url"], pulldownmenu,tutorialcollection,tutorialCollectionQ,tcLength,pulldowncontent,
	newAnchorBarData,context, urlBaseRemote = GetParameter["urlBaseRemote"]},
   
   
   breakDownMenuCell[a_Cell] := Module[{menuType, menuList,menuStyle},
   menuType = Cases[a, _FrameBox, Infinity][[1, 1]];
   menuList = DeleteCases[a, _FrameBox, Infinity][[1, 1, 1]];
   menuStyle=StringReplace[Cases[a, z:Rule[MenuStyle,_], Infinity][[1,2]], "Section"->""]; 
   {menuStyle,ToExpression[menuType],
    Map[{ToExpression[#[[1]]], StringReplace[#[[2, 1]], "paclet:"->""]} &, menuList]}
   ];
   
	
	pulldowncontent=Cases[SelectSelf[], Cell[BoxData[ActionMenuBox[___]],___], Infinity];
  pulldowncontent=DeleteCases[pulldowncontent, Cell[BoxData[ActionMenuBox[___, Rule[MenuStyle, "TranslationMenu" | "URLMenu"], ___], ___], ___], Infinity];
   newAnchorBarData = Map[breakDownMenuCell[#]&,pulldowncontent];
   context = Cases[SelectSelf[], Cell[_, "PacletNameCell", ___], Infinity];
	
MenuCounter = IncrementCounter["MenuCounter"];
SeeAlsoFunctionList = GetParameter["seeAlsoFunctions"];
TutorialFunctionList = GetParameter["tutorialFunctions"];
MoreAboutGuideList = GetParameter["moreAboutGuides"];
ExampleSectionList = GetParameter["exampleSections"];
TutorialList = GetParameter["tutorials"];
TutorialMoreAboutList = GetParameter["tutorialMoreAbout"];
RelatedTutorialsList = GetParameter["relatedTutorials"];

GuideMoreAboutList = GetParameter["guideMoreAbout"];
GuideFunctionList = GetParameter["guideFunctions"];
GuideTutorialList = GetParameter["guideTutorials"];

uriDepth = If[Head@uri === String, Length@StringSplit[uri, "/"] ];
tutorialcollection=GetParameter["tutorialcollection"];
tcLength = Length[tutorialcollection];

tutorialCollectionQ = If[
	MemberQ[{"Tutorial", "Overview"},GetParameter["entityType"]]
	&& (tcLength === 1), True , False];

AnchorBarData = 
  Switch[ GetParameter["entityType"],
    "Indicator" | "Symbol" | "HowTo" | "Format" | "Embedding Format"| "Interpreter" | "Character" | "Device Connection" | "Service Connection" | "Character Name" | "Menu Item" | "LibraryLink C Function" | "MathLink C Function" | "Front End Object" | 
    "Upgrade Information" | "System Program" | "Program" | "Note" | "Method" | "Message" | "AppleScript" | "File",
      {{"Examples", ExampleSectionText},
       {"Tutorials", TutorialList},
       (* Drop "paclet:" *)
       {"SeeAlso", {First[#], StringDrop[Last[#], 7]}& /@ SeeAlsoFunctionList},
       {"MoreAbout", MoreAboutGuideList}},
    "Tutorial"|"Overview",
    If[tcLength===2,
	{ {"Functions", TutorialFunctionList}, 
       {"Tutorials", RelatedTutorialsList},
       {"MoreAbout", TutorialMoreAboutList},
       {"PDF", tutorialcollection} },
       { {"Functions", TutorialFunctionList}, 
       {"Tutorials", RelatedTutorialsList},
       {"MoreAbout", TutorialMoreAboutList} }],
    "Guide" | "Guide Overview" | "Standard Extra Packages" | "Example",
    If[tcLength===2,
	{ {"Functions", GuideFunctionList}, 
       {"Tutorials", GuideTutorialList},
       {"MoreAbout", GuideMoreAboutList},
       {"PDF", tutorialcollection} },
       { {"Functions", GuideFunctionList}, 
       {"Tutorials", GuideTutorialList},
       {"MoreAbout", GuideMoreAboutList} }]
      ,
    _, {}
  ]; 
  
  thisElementContent := 
    XMLElement["div", {"class" -> "topContentWrap"}, {
    	XMLElement["div", {"class"->"ribbonWrap"}, {
    		XMLElement["span", {"class"->"ribbonOuter"}, {Recurse[context]}]}],
        If[AnchorBarData =!= {}, pulldownmenu=
          Flatten@Map[
            Function[{data}, Module[{dataid = First[data] /. {
            	"GuideFunction"->Localized["FunctionsSectionText", GetParameter["language"]], 
            	"GuideTutorials"->Localized["TutorialsSectionText", GetParameter["language"]], 
            	"GuideTutorial"->Localized["TutorialsSectionText", GetParameter["language"]], 
            	"GuideMoreAbout"->Localized["MoreAboutSectionText", GetParameter["language"]], 
            	"FeaturedExampleMoreAbout"->Localized["MoreAboutSectionText", GetParameter["language"]], 
            	"TutorialFunction"->Localized["FunctionsSectionText", GetParameter["language"]], 
            	"TutorialMoreAbout"->Localized["MoreAboutSectionText", GetParameter["language"]],
            	"RelatedTutorials"->Localized["TutorialsSectionText", GetParameter["language"]], 
            	"Functions"->Localized["FunctionsSectionText", GetParameter["language"]], 
            	"Tutorials"->Localized["TutorialsSectionText", GetParameter["language"]],
            	"SeeAlso"->Localized["SeeAlsoSectionText", GetParameter["language"]], 
            	"MoreAbout"->Localized["MoreAboutSectionText", GetParameter["language"]]}, 
            	datalist = Last[data]},
              
              If[(Length[datalist] > 0) && (datalist =!= {{}}), {Flatten@{
                XMLElement["li",{}, {
                	XMLElement["a",{"href"->"#"},{dataid}],
                	XMLElement["ul", {"class"->"sub_menu"},
                      Map[
                        XMLElement["li", {}, {A[{"href"->
                        Which[
                        	(GetParameter["pacletName"] === "webMathematica") && (completeHTMLQ === True), 
                        	DocumentationBuild`Utils`DotHTML[
                        	StringReplace[#[[2]], 
                        		If[ (completeHTMLQ === True),
		                  {GetParameter["pacletName"]<>"/"->StringJoin @@ Flatten@Table[{"../"}, {uriDepth - 2}], StartOfString~~"ref"->urlBaseRemote<>"ref", StartOfString~~"guide"->urlBaseRemote<>"guide", StartOfString~~"tutorial"->urlBaseRemote<>"tutorial"},
		                  {"paclet://"->urlBaseRemote, "paclet:"->urlBaseRemote}
	                	]]
	                	], 
	                	GetParameter["pacletName"] === "Alpha", 
	                	Module[{bdata},
                        	bdata=#[[2]];
                        	bdata=If[StringTake[bdata, 6]==="Alpha/", StringDrop[bdata,6]];
                        	If[dataid==="PDF",
                        	bdata, 
                        	If[StringMatchQ[bdata, "http://"~~__], bdata, 
                        	DocumentationBuild`Utils`DotHTML["/documentation/"<>bdata]
                        	  ]]
                        ],
                        True, Module[{bdata},
                        	bdata=#[[2]];
                        	If[dataid==="PDF",
                        	bdata, 
                        	If[StringMatchQ[bdata, "http://"~~__], bdata, 
                        	DocumentationBuild`Utils`DotHTML[ 
                        		StringReplace[StringReplace[StringReplace[StringReplace["/language/"<>#[[2]], 
                        			{"JLink/ref/java/"->"JLink/ref/java/com/wolfram/jlink/"}], 
                      {"NETLink/ref/net/"->"NETLink/ref/net/Wolfram.NETLink.","IKernelLink/" -> "IKernelLink."}], 
                      	{"NETLink/ref/net/Wolfram.NETLink.NETLink" ->"NETLink/ref/net/Wolfram.NETLink", 
                      	"Wolfram.NETLink.IKernelLink.EvaluateToOutputForm"->"Wolfram.NETLink.IKernelLink.EvaluateToOutputForm_overloads",
                      	"Wolfram.NETLink.IKernelLink.EvaluateToImage"->"Wolfram.NETLink.IKernelLink.EvaluateToImage_overloads",
                      	"Wolfram.NETLink.IKernelLink.Evaluate"->"Wolfram.NETLink.IKernelLink.Evaluate_overloads",
                      	"Wolfram.NETLink.IKernelLink.GetInteger"->"Wolfram.NETLink.IMathLink.GetInteger",
                      	"Wolfram.NETLink.ConsoleWindow"->"Wolfram.NETLink.UI.ConsoleWindow",
                      	"Wolfram.NETLink.DoubleBufferedPanel"->"Wolfram.NETLink.UI.DoubleBufferedPanel",
                      	"Wolfram.NETLink.MathPictureBox"->"Wolfram.NETLink.UI.MathPictureBox",
                      	"Wolfram.NETLink.MathLinkFactory/CreateKernelLink"->"Wolfram.NETLink.MathLinkFactory.CreateKernelLink_overloads",
                      	(*"Wolfram.NETLink.NETLink"<>""->"index",*)
                      	"NETLink/ref/net/DotNETInterface"->"NETLink/guide/DotNETInterface"
                      	}], {"/language/WSMLink/"->"/system-modeler/WSMLink/"}]]]]
                        ]
                        ]
                        
                        }, {XMLElement["span", {"class"->"dropdownPad"}, {Transmogrify[#[[1]]]}]}]}]&,  
                        datalist]]
                        }]
              }}, {}]
            ]],
            newAnchorBarData]; 
              XMLElement["ul", {"class"->"dropdown"}, Flatten@{pulldownmenu}],
          {}],XMLElement["div", {"class"->"clear"}, {XML`RawXML["<!-- -->"]}] }];


thisElementContent
], 








{br} -> XMLElement["br", {}, {}],  
{Cell, "OpenCloseItemizedPicture"} :> "",
{Cell, "PacletNameCell"}:>Span[{"class"->"ribbonInner"}, {Recurse[]}],
{Cell, "ItemizedPicture" | "ItemPicture"} :> 
transmogrifyImage[ToFileName[{"Files", GetFileNameBase[]},
    IncrementCounter["Image"] <> ".gif"],{"alt"->""},
    Inline -> True, CropImage -> False
], 

{Cell, "HeaderCell"} :> "",
{CellGroupData, All} :> Recurse[], 

{Cell, "LaTex"} :> Span[{"class"-> GetStyle[]}, {Recurse[]}],

{AdjustmentBox}:>
Which[HasOption[BoxBaselineShift],
	XMLElement["sub", {"style" -> "vertical-align:-10%;"}, {Recurse[]} ],
	True, Recurse[]
	],


{DynamicBox}:>(
testDynamicBox[a_DynamicBox] := Module[{strip,strip2},

  strip=Cases[a, b_If :> Apply[List, Defer[b], 1], Infinity][[1]];
  strip2=Evaluate[strip][[1]];
  strip2[[3]]
   ];
   testDynamicBox[SelectSelf[]]
),


{Cell, All} :>
Module[{id},
id = If[HasOption[CellID], "id" -> ToString[GetOption[CellID]], Hold[Sequence[]]];
Which[GetStyle[]===None && !HasOption[CellID], Recurse[],
	GetStyle[]===None, 
  XMLElement["div", {ReleaseHold[id]}, 
    If[HasOption[CellTags],
    Flatten[{
      Map[
      (XMLElement["a", {"name" -> #}, {}])&, Flatten[{GetOption[CellTags]}] ],
      Recurse[] }],
    {Recurse[]} ] 
  ],  
  True, 
  DIV[{"class" -> GetStyle[], ReleaseHold[id]}, {Recurse[]}]
]],



(***** Other Box structures *****)
{RawData} :>  
transmogrifyImage[ToFileName[{"Files", GetFileNameBase[]},
    IncrementCounter["Image"] <> ".gif"],{"alt"->""},
    Inline -> True, CropImage -> False
], 


{PopupMenuBox} :>  Span[{}, {XMLElement["img", { 
      "src" -> ("URL" /. #), "style" -> "vertical-align:middle;", 
      "width" -> ("Width" /. #), "height" -> ("Height" /. #),  
      "alt" -> " "  }, {}]&[
      BoxToImage[ToFileName[{"Files", GetFileNameBase[]},
    "Popup_" <> IncrementCounter["Popup"] <> ".gif"],
    Inline -> True, CropImage -> False]
    ] } 
], 


{TooltipBox} :> Block[{tooltip = SelectChildren[][[2]]}, 
	Which[Length[Cases[SelectSelf[], "TradFormChar", Infinity]]>0, 
		transmogrifyImage[ToFileName[{"Files", GetFileNameBase[]},
    IncrementCounter["Image"] <> ".gif"],{"alt"->""},
    Inline -> True, CropImage -> False
], 
Length[Cases[SelectSelf[], "StandFormChar", Infinity]]>0,
transmogrifyImage[ToFileName[{"Files", GetFileNameBase[]},
    IncrementCounter["Image"] <> ".gif"],{"alt"->""},
    Inline -> True, CropImage -> False
],
Length[Cases[SelectSelf[], GraphicsBox[___, Rule[FrameStyle, ___], ___], Infinity]]>0,
transmogrifyImage[ToFileName[{"Files", GetFileNameBase[]},
    IncrementCounter["Image"] <> ".gif"],{"alt"->""},
    Inline -> True, CropImage -> False
],
True, Transmogrify[SelectChildren[][[1]]]]
],


{GraphicsBox | PanelBox | PaneBox | Graphics3DBox} :> 
(transmogrifyImage[ToFileName[{"Files", GetFileNameBase[]},
    IncrementCounter["Image"] <> ".gif"],{"alt"->""},
    Inline -> True, CropImage -> False
]
), 


{DynamicBox } :> Module[{dBoxContent}, 
dBoxContent=SelectSelf[][[1]];
If[MatchQ[Head@dBoxContent, String], StringReplace[dBoxContent, "\""->""],
transmogrifyImage[ToFileName[{"Files", GetFileNameBase[]},
    IncrementCounter["Image"] <> ".gif"],{"alt"->""},
    Inline -> True, CropImage -> False
]
]
], 


{Cell, "Picture"} :> 
transmogrifyImage[ToFileName[{"Files", GetFileNameBase[]},
    IncrementCounter["Image"] <> ".gif"],{"alt"->""},
    Inline -> True, CropImage -> False
], 


(* If graphics are wider/taller than n, create popup window *)
{GraphicsData} :> 
(XMLElement["img", { 
      "src" -> ("URL" /. #), 
      "width" -> ("Width" /. #), "height" -> ("Height" /. #),  
      "alt" -> " "  }, {}]&[
      BoxToImage[ToFileName[{"Files", GetFileNameBase[]},
    "Box_" <> IncrementCounter["GraphicsData"] <> ".gif"],
    Inline -> False, CropImage -> False]
    ] ),


{OutputFormData} :> Transmogrify[SelectChildren[][[2]]],

ValueBox["Year"] :> ToString[Date[][[1]]],

{InterpretationBox} :> Transmogrify[SelectChildren[]],

{FormBox} :> 
Module[{boxChildren,traditionalFormQ,altTag,image,height,inc,fudge,
	filedir,filepath,width, url},
boxChildren=SelectChildren[];
traditionalFormQ = If[GetStyle[] === TraditionalForm, True, False];
altTag = DocumentationBuild`Utils`CellToString@SelectSelf[];
inc = IncrementCounter["Image"];
filedir = GetFileNameBase[];
filepath = "Files";
image = BoxToImage[ToFileName[{"Files", GetFileNameBase[]}, "Image_"<> inc <> ".png"],  ImageFormat -> "PNG", TransparentBackground->True, ConversionOptions->{Background->None}, 
            Inline -> If[GetStyle[]===TraditionalForm, True, False], MaxImageSize->580, CropImage -> False];  
height = ("Height" /. #)&[image];
width = ("Width" /. #)&[image];
url = ("URL" /. #)&[image];
fudge = fudgeValignProp[height];
If[MatchQ[boxChildren, {"Mathematica"}],Transmogrify[StyleBox["Mathematica", FontSlant->"Italic"]],
If[MatchQ[boxChildren, {StyleBox[_, "KeyEvent", ___]}], Transmogrify[boxChildren],
	XMLElement["img", {"style"->"vertical-align:middle;", "title"->altTag, 
			"src" -> url, "width" -> width, 
            "height" -> height, "alt"->altTag
          }, {}]&[image]
]
]
],


(*{FormBox} :> Module[{boxChildren,traditionalFormQ,altTag},
boxChildren=SelectChildren[];
traditionalFormQ = If[GetStyle[] === TraditionalForm, True, False];
altTag = DocumentationBuild`Utils`CellToString@SelectSelf[];
If[MatchQ[boxChildren, {"Mathematica"}],Transmogrify[StyleBox["Mathematica", FontSlant->"Italic"]],
If[MatchQ[boxChildren, {StyleBox[_, "KeyEvent", ___]}], Transmogrify[boxChildren],
transmogrifyImage[ToFileName[{"Files", GetFileNameBase[]},
  IncrementCounter["Image"] <> ".gif"], {"style"->"vertical-align:middle;", "alt"->altTag, "title"->altTag}, "TransparentColor" -> White, 
  Inline -> If[GetStyle[]===TraditionalForm, True, False]
]
]
]
],*)


(***** String *****)
{String} :> Module[{stringContent, stringTest}, 
	
	stringContent=ReplaceSpecialCharacters[SelectSelf[]];
	stringTest[x_] := Which[
		Head[x] === XMLElement, x,
		Head[x] === RawXML, x,
  StringLength[x] === 1 && StringMatchQ[x, RegularExpression["[a-z]"]], XMLElement["I", {}, {x}], 
  		True, x];
	
  (* handle inline formatted strings... *)
  Which[InlineFormattedQ[SelectLiteral[SelectSelf[]]],
    		Transmogrify[FromInlineString[SelectSelf[]]],
    	
    	traditionalFormQ === True, 
			Sequence@@Map[stringTest[#]&,  {stringContent}],
    
    True, stringContent
    
  ]
]

}]