(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[    694744,      14700]
NotebookOptionsPosition[    687381,      14465]
NotebookOutlinePosition[    688300,      14495]
CellTagsIndexPosition[    688257,      14492]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Language translations", "Section",
 InitializationCell->True,
 CellChangeTimes->{{3.509128698976028*^9, 3.5091287030561037`*^9}, {
  3.517921240914071*^9, 3.5179212560201473`*^9}, {3.5202729125318813`*^9, 
  3.520272922240465*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"CDFlocalization", "=", 
   RowBox[{"{", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"\"\<EXAMPLES\>\"", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"\"\<English\>\"", "\[Rule]", "\"\<EXAMPLES\>\""}], ",", " ", 
        
        RowBox[{"\"\<Japanese\>\"", "\[Rule]", "\"\<\:4f8b\:984c\>\""}], ",", 
        " ", 
        RowBox[{
        "\"\<ChineseSimplified\>\"", "\[Rule]", "\"\<\:8303\:4f8b\>\""}]}], 
       "}"}]}], ",", "\[IndentingNewLine]", 
     RowBox[{"\"\<Format:\>\"", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"\"\<English\>\"", "\[Rule]", "\"\<Format:\>\""}], ",", " ", 
        RowBox[{
        "\"\<Japanese\>\"", "\[Rule]", 
         "\"\<\:30d5\:30a9\:30fc\:30de\:30c3\:30c8:\>\""}], ",", 
        RowBox[{
        "\"\<ChineseSimplified\>\"", "\[Rule]", "\"\<\:683c\:5f0f:\>\""}]}], 
       "}"}]}], ",", "\[IndentingNewLine]", 
     RowBox[{"\"\<OPEN ALL\>\"", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"\"\<English\>\"", "\[Rule]", "\"\<OPEN ALL\>\""}], ",", " ", 
        
        RowBox[{
        "\"\<Japanese\>\"", "\[Rule]", 
         "\"\<\:3059\:3079\:3066\:958b\:304f\>\""}], ",", 
        RowBox[{
        "\"\<ChineseSimplified\>\"", "\[Rule]", 
         "\"\<\:5173\:95ed\:6240\:6709\:5355\:5143\>\""}]}], "}"}]}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"\"\<CLOSE ALL\>\"", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"\"\<English\>\"", "\[Rule]", "\"\<CLOSE ALL\>\""}], ",", " ", 
        RowBox[{
        "\"\<Japanese\>\"", "\[Rule]", 
         "\"\<\:3059\:3079\:3066\:9589\:3058\:308b\>\""}], ",", 
        RowBox[{
        "\"\<ChineseSimplified\>\"", "\[Rule]", 
         "\"\<\:6253\:5f00\:6240\:6709\:5355\:5143\>\""}]}], "}"}]}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"\"\<More Information\>\"", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"\"\<English\>\"", "\[Rule]", 
         RowBox[{"RowBox", "[", 
          RowBox[{"{", 
           RowBox[{
           "\"\<MORE\>\"", ",", "\"\< \>\"", ",", "\"\<INFORMATION\>\""}], 
           "}"}], "]"}]}], ",", " ", 
        RowBox[{"\"\<Japanese\>\"", "\[Rule]", 
         RowBox[{"RowBox", "[", 
          RowBox[{"{", "\"\<\:8a73\:7d30\>\"", "}"}], "]"}]}], ",", 
        RowBox[{"\"\<ChineseSimplified\>\"", "\[Rule]", 
         RowBox[{"RowBox", "[", 
          RowBox[{"{", "\"\<\:66f4\:591a\:4fe1\:606f\>\"", "}"}], "]"}]}]}], 
       "}"}]}], ",", "\[IndentingNewLine]", 
     RowBox[{"\"\<OPEN ALL/CLOSE ALL\>\"", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"\"\<English\>\"", "\[Rule]", 
         RowBox[{"Dynamic", "[", 
          RowBox[{"FE`Evaluate", "[", 
           RowBox[{"FEPrivate`If", "[", 
            RowBox[{
             RowBox[{"FrontEnd`CurrentValue", "[", 
              RowBox[{
               RowBox[{"FrontEnd`ButtonNotebook", "[", "]"}], ",", 
               RowBox[{"{", 
                RowBox[{"TaggingRules", ",", "\"\<ExamplesClosed\>\""}], 
                "}"}], ",", "True"}], "]"}], ",", "\"\<OPEN ALL\>\"", ",", 
             "\"\<CLOSE ALL\>\"", ",", "\"\<CLOSE ALL\>\""}], "]"}], "]"}], 
          "]"}]}], ",", " ", 
        RowBox[{"\"\<Japanese\>\"", "\[Rule]", 
         RowBox[{"Dynamic", "[", 
          RowBox[{"FE`Evaluate", "[", 
           RowBox[{"FEPrivate`If", "[", 
            RowBox[{
             RowBox[{"FrontEnd`CurrentValue", "[", 
              RowBox[{
               RowBox[{"FrontEnd`ButtonNotebook", "[", "]"}], ",", 
               RowBox[{"{", 
                RowBox[{"TaggingRules", ",", "\"\<ExamplesClosed\>\""}], 
                "}"}], ",", "True"}], "]"}], ",", 
             "\"\<\:3059\:3079\:3066\:958b\:304f\>\"", ",", 
             "\"\<\:3059\:3079\:3066\:9589\:3058\:308b\>\"", ",", 
             "\"\<\:3059\:3079\:3066\:9589\:3058\:308b\>\""}], "]"}], "]"}], 
          "]"}]}], ",", 
        RowBox[{"\"\<ChineseSimplified\>\"", "\[Rule]", 
         RowBox[{"Dynamic", "[", 
          RowBox[{"FE`Evaluate", "[", 
           RowBox[{"FEPrivate`If", "[", 
            RowBox[{
             RowBox[{"FrontEnd`CurrentValue", "[", 
              RowBox[{
               RowBox[{"FrontEnd`ButtonNotebook", "[", "]"}], ",", 
               RowBox[{"{", 
                RowBox[{"TaggingRules", ",", "\"\<ExamplesClosed\>\""}], 
                "}"}], ",", "True"}], "]"}], ",", 
             "\"\<\:5173\:95ed\:6240\:6709\:5355\:5143\>\"", ",", 
             "\"\<\:6253\:5f00\:6240\:6709\:5355\:5143\>\"", ",", 
             "\"\<\:6253\:5f00\:6240\:6709\:5355\:5143\>\""}], "]"}], "]"}], 
          "]"}]}]}], "}"}]}], ",", "\[IndentingNewLine]", 
     RowBox[{"\"\<playermessage1\>\"", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"\"\<English\>\"", "\[Rule]", 
         RowBox[{"TextData", "[", 
          RowBox[{"{", 
           RowBox[{
           "\"\<Some of the examples in this document may not work in Wolfram \
\>\"", ",", " ", 
            RowBox[{"StyleBox", "[", 
             RowBox[{"\"\<CDF Player\>\"", ",", "\n", "  ", 
              RowBox[{"FontSlant", "->", "\"\<Italic\>\""}]}], "]"}], ",", 
            "\"\<.\>\""}], "}"}], "]"}]}], ",", " ", 
        RowBox[{"\"\<Japanese\>\"", "\[Rule]", 
         RowBox[{"TextData", "[", 
          RowBox[{"{", 
           RowBox[{
           "\"\<\:3053\:306e\:30c9\:30ad\:30e5\:30e1\:30f3\:30c8\:306e\:4f8b\
\:984c\:306e\:4e2d\:306b\:306fWolfram \>\"", ",", 
            RowBox[{"StyleBox", "[", 
             RowBox[{"\"\<CDF Player\>\"", ",", "\n", "  ", 
              RowBox[{"FontSlant", "->", "\"\<Italic\>\""}]}], "]"}], ",", 
            "\"\<\:3067\:306f\:3046\:307e\:304f\:52d5\:4f5c\:3057\:306a\:3044\
\:3082\:306e\:304c\:3042\:308b\:3053\:3068\:304c\:3042\:308a\:307e\:3059\:ff0e\
\>\""}], "}"}], "]"}]}], ",", 
        RowBox[{"\"\<ChineseSimplified\>\"", "\[Rule]", 
         RowBox[{"TextData", "[", 
          RowBox[{"{", 
           RowBox[{
           "\"\<\:672c\:6587\:6863\:4e2d\:7684\:67d0\:4e9b\:8303\:4f8b\:53ef\
\:80fd\:65e0\:6cd5\:5728 Wolfram \>\"", ",", 
            RowBox[{"StyleBox", "[", 
             RowBox[{"\"\<CDF Player\>\"", ",", "\n", "  ", 
              RowBox[{"FontSlant", "->", "\"\<Italic\>\""}]}], "]"}], ",", 
            "\"\< \:4e2d\:8fd0\:884c\:3002\>\""}], "}"}], "]"}]}]}], "}"}]}], 
     ",", "\[IndentingNewLine]", 
     RowBox[{"\"\<playermessage2\>\"", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"\"\<English\>\"", "\[Rule]", 
         RowBox[{"TextData", "[", 
          RowBox[{
          "{", "\"\<Some of the examples in this document may not work in the \
browser plugin.\>\"", "}"}], "]"}]}], ",", " ", 
        RowBox[{"\"\<Japanese\>\"", "\[Rule]", 
         RowBox[{"TextData", "[", 
          RowBox[{
          "{", "\"\<\:3053\:306e\:30c9\:30ad\:30e5\:30e1\:30f3\:30c8\:306e\
\:4f8b\:984c\:306e\:4e2d\:306b\:306f\:30d6\:30e9\:30a6\:30b6\:30d7\:30e9\:30b0\
\:30a4\:30f3\:3067\:306f\:3046\:307e\:304f \:52d5\:4f5c\:3057\:306a\:3044\
\:3082\:306e\:304c\:3042\:308b\:3053\:3068\:304c\:3042\:308a\:307e\:3059\:ff0e\
\>\"", "}"}], "]"}]}], ",", 
        RowBox[{"\"\<ChineseSimplified\>\"", "\[Rule]", 
         RowBox[{"TextData", "[", 
          RowBox[{
          "{", "\"\<\:672c\:6587\:6863\:4e2d\:7684\:67d0\:4e9b\:8303\:4f8b\
\:53ef\:80fd\:65e0\:6cd5\:5728\:6d4f\:89c8\:5668\:63d2\:4ef6\:4e2d\:8fd0\:884c\
\:3002\>\"", "}"}], "]"}]}]}], "}"}]}], ",", "\[IndentingNewLine]", 
     RowBox[{"\"\<playermessage3a\>\"", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"\"\<English\>\"", "\[Rule]", 
         RowBox[{"TextData", "[", 
          RowBox[{
          "{", "\"\<Some of the examples in this document may not work in the \
browser plugin.\>\"", "}"}], "]"}]}], ",", " ", 
        RowBox[{"\"\<Japanese\>\"", "\[Rule]", 
         RowBox[{"TextData", "[", 
          RowBox[{
          "{", "\"\<\:3053\:306e\:30c9\:30ad\:30e5\:30e1\:30f3\:30c8\:306e\
\:4f8b\:984c\:306e\:4e2d\:306b\:306f\:30d6\:30e9\:30a6\:30b6\:30d7\:30e9\:30b0\
\:30a4\:30f3\:3067\:306f\:3046\:307e\:304f\:52d5\:4f5c\:3057\:306a\:3044\:3082\
\:306e\:304c\:3042\:308b\:3053\:3068\:304c\:3042\:308a\:307e\:3059\:ff0e\>\"",
            "}"}], "]"}]}], ",", 
        RowBox[{"\"\<ChineseSimplified\>\"", "\[Rule]", 
         RowBox[{"TextData", "[", 
          RowBox[{
          "{", "\"\<\:672c\:6587\:6863\:4e2d\:7684\:67d0\:4e9b\:8303\:4f8b\
\:53ef\:80fd\:65e0\:6cd5\:5728\:6d4f\:89c8\:5668\:63d2\:4ef6\:4e2d\:8fd0\:884c\
\:3002\>\"", "}"}], "]"}]}]}], "}"}]}], ",", "\[IndentingNewLine]", 
     RowBox[{"\"\<playermessage3b\>\"", "\[Rule]", 
      RowBox[{"{", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"\"\<English\>\"", "\[Rule]", 
         RowBox[{"TextData", "[", 
          RowBox[{"{", 
           RowBox[{"\"\<Open the Documentation Center in \>\"", ",", " ", 
            RowBox[{"StyleBox", "[", 
             RowBox[{"\"\<Mathematica\>\"", ",", "\n", "  ", 
              RowBox[{"FontSlant", "->", "\"\<Italic\>\""}]}], "]"}], ",", 
            "\"\< to access full functionality.\>\""}], "}"}], "]"}]}], ",", 
        " ", "\[IndentingNewLine]", 
        RowBox[{"\"\<Japanese\>\"", "\[Rule]", 
         RowBox[{"TextData", "[", 
          RowBox[{"{", 
           RowBox[{
           "\"\<\:305d\:306e\:3088\:3046\:306a\:5834\:5408\:306f \>\"", ",", 
            RowBox[{"StyleBox", "[", 
             RowBox[{"\"\<Mathematica\>\"", ",", "\n", "  ", 
              RowBox[{"FontSlant", "->", "\"\<Italic\>\""}]}], "]"}], ",", 
            "\"\< \:306e\:30c9\:30ad\:30e5\:30e1\:30f3\:30c8\:30bb\:30f3\:30bf\
\:30fc\:3092\:304a\:4f7f\:3044\:304f\:3060\:3055\:3044\:ff0e\>\""}], "}"}], 
          "]"}]}], ",", "\[IndentingNewLine]", 
        RowBox[{"\"\<ChineseSimplified\>\"", "\[Rule]", 
         RowBox[{"TextData", "[", 
          RowBox[{"{", 
           RowBox[{"\"\<\:5728 \>\"", ",", 
            RowBox[{"StyleBox", "[", 
             RowBox[{"\"\<Mathematica\>\"", ",", "\n", "  ", 
              RowBox[{"FontSlant", "->", "\"\<Italic\>\""}]}], "]"}], ",", 
            "\"\< \:4e2d\:6253\:5f00\:53c2\:8003\:8d44\:6599\:4e2d\:5fc3\:ff0c\
\:4ee5\:83b7\:5f97\:5168\:90e8\:529f\:80fd\:3002\>\""}], "}"}], "]"}]}]}], 
       "}"}]}], ",", "\[IndentingNewLine]", 
     RowBox[{"\"\<\\<\\\"Click to Interact\\\"\\>\>\"", "\[Rule]", " ", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
        "\"\<English\>\"", "\[Rule]", 
         "\"\<\\<\\\"Click to Interact\\\"\\>\>\""}], ",", " ", 
        RowBox[{
        "\"\<Japanese\>\"", "\[Rule]", 
         "\"\<\\<\\\"\:30af\:30ea\:30c3\:30af\:3057\:3066\:30a4\:30f3\:30bf\
\:30e9\:30af\:30c6\:30a3\:30d6\:306b\:3059\:308b\\\"\\>\>\""}], ",", 
        RowBox[{
        "\"\<ChineseSimplified\>\"", "\[Rule]", 
         "\"\<\\<\\\"\:70b9\:51fb\:4ee5\:4e92\:52a8\\\"\\>\>\""}]}], "}"}]}], 
     ",", "\[IndentingNewLine]", 
     RowBox[{"\"\<SEARCH\>\"", "\[Rule]", " ", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"\"\<English\>\"", "\[Rule]", "\"\<SEARCH\>\""}], ",", " ", 
        RowBox[{"\"\<Japanese\>\"", "\[Rule]", "\"\<\:691c\:7d22\>\""}], ",", 
        
        RowBox[{
        "\"\<ChineseSimplified\>\"", "\[Rule]", "\"\<\:641c\:5bfb\>\""}]}], 
       "}"}]}], ",", "\[IndentingNewLine]", 
     RowBox[{
     "\"\<Getting Started Videos\[NonBreakingSpace]\[RightGuillemet]\>\"", 
      "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
        "\"\<English\>\"", "\[Rule]", 
         "\"\<Getting Started \
Videos\[NonBreakingSpace]\[RightGuillemet]\>\""}], ",", " ", 
        RowBox[{
        "\"\<Japanese\>\"", "\[Rule]", 
         "\"\<Getting Started \:30d3\:30c7\:30aa \[RightGuillemet]\>\""}], 
        ",", 
        RowBox[{
        "\"\<ChineseSimplified\>\"", "\[Rule]", 
         "\"\<\:5165\:95e8\:89c6\:9891 \[RightGuillemet]\>\""}]}], "}"}]}], 
     ",", "\[IndentingNewLine]", 
     RowBox[{
     "\"\<Find Your Learning Path\[NonBreakingSpace]\[RightGuillemet]\>\"", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
        "\"\<English\>\"", "\[Rule]", 
         "\"\<Find Your Learning \
Path\[NonBreakingSpace]\[RightGuillemet]\>\""}], ",", " ", 
        RowBox[{
        "\"\<Japanese\>\"", "\[Rule]", 
         "\"\<\:5b66\:7fd2\:30ea\:30bd\:30fc\:30b9 \[RightGuillemet]\>\""}], 
        ",", 
        RowBox[{
        "\"\<ChineseSimplified\>\"", "\[Rule]", 
         "\"\<\:5bfb\:627e\:5b66\:4e60\:9014\:5f84 \[RightGuillemet]\>\""}]}],
        "}"}]}], ",", "\[IndentingNewLine]", 
     RowBox[{"\"\<'How to' Topics\[NonBreakingSpace]\[RightGuillemet]\>\"", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
        "\"\<English\>\"", "\[Rule]", 
         "\"\<'How to' Topics\[NonBreakingSpace]\[RightGuillemet]\>\""}], ",",
         " ", 
        RowBox[{
        "\"\<Japanese\>\"", "\[Rule]", 
         "\"\<\:300cHow to\:300d\:30c8\:30d4\:30c3\:30af \
\[RightGuillemet]\>\""}], ",", 
        RowBox[{
        "\"\<ChineseSimplified\>\"", "\[Rule]", 
         "\"\<How to \:4e3b\:9898 \[RightGuillemet]\>\""}]}], "}"}]}]}], 
    "\[IndentingNewLine]", "}"}]}], ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{
  3.508678581170425*^9, 3.508688897269216*^9, 3.5091981766179123`*^9, {
   3.5110104883385153`*^9, 3.5110104956161633`*^9}, {3.516456481613875*^9, 
   3.516456490045637*^9}, {3.51975492787122*^9, 3.519754928435738*^9}, {
   3.5202729344848948`*^9, 3.520272935010249*^9}, {3.520273133850048*^9, 
   3.520273214591887*^9}, {3.5202733412580967`*^9, 3.520273400120229*^9}, {
   3.520354987844651*^9, 3.5203550854713*^9}, {3.520355350440988*^9, 
   3.5203553756335506`*^9}, {3.520355411645212*^9, 3.520355425659197*^9}, {
   3.520355637803937*^9, 3.520355693540677*^9}, {3.520355727767222*^9, 
   3.520355768539853*^9}, {3.5203569073678637`*^9, 3.520356965965517*^9}, 
   3.520357039331438*^9, {3.520360437371649*^9, 3.5203604538235064`*^9}, 
   3.5203607302605658`*^9, {3.5206003415555983`*^9, 3.520600365099847*^9}, {
   3.520600443619604*^9, 3.520600552838078*^9}, {3.520612595087161*^9, 
   3.520612605896693*^9}, {3.520612694585815*^9, 3.520612701230225*^9}, {
   3.52061274989392*^9, 3.520612750982849*^9}, {3.520612806123958*^9, 
   3.520612854464307*^9}, {3.520612918007279*^9, 3.520613027214848*^9}, {
   3.52061306618714*^9, 3.5206131100898933`*^9}, {3.520613146652762*^9, 
   3.5206132692931433`*^9}, {3.520616838190683*^9, 3.520616845123892*^9}, {
   3.5206169911509113`*^9, 3.52061700000593*^9}, {3.5206170467653313`*^9, 
   3.5206171584558477`*^9}, {3.5206177189097767`*^9, 3.520617757553854*^9}, {
   3.520617868875503*^9, 3.520617910785202*^9}, {3.52068267945581*^9, 
   3.520682681456871*^9}, 3.520683417837022*^9, {3.520956074682865*^9, 
   3.520956119803781*^9}, {3.520956159026718*^9, 3.5209561744364443`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"CDFLocalized", "[", 
    RowBox[{"key_", ",", "lang_", ",", "args___"}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"vals", ",", "val"}], "}"}], ",", 
     RowBox[{
      RowBox[{"vals", "=", 
       RowBox[{"key", "/.", "CDFlocalization"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"vals", "===", "key"}], ",", 
        RowBox[{
         RowBox[{"Message", "[", 
          RowBox[{
           RowBox[{"CDFLocalized", "::", "nokey"}], ",", "key"}], "]"}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"Return", "[", "None", "]"}]}]}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"MatchQ", "[", 
         RowBox[{"vals", ",", 
          RowBox[{"{", 
           RowBox[{"___", ",", 
            RowBox[{"lang", "\[Rule]", "_"}], ",", "___"}], "}"}]}], "]"}], 
        ",", 
        RowBox[{"val", "=", 
         RowBox[{"lang", "/.", "vals"}]}], ",", 
        RowBox[{
         RowBox[{"Message", "[", 
          RowBox[{
           RowBox[{"CDFLocalized", "::", "nolang"}], ",", "lang", ",", 
           "key"}], "]"}], ";", "\[IndentingNewLine]", 
         RowBox[{"val", "=", 
          RowBox[{"\"\<English\>\"", "/.", "vals"}]}]}]}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Length", "[", 
          RowBox[{"{", "args", "}"}], "]"}], ">", "0"}], ",", 
        RowBox[{"val", "[", "args", "]"}], ",", "val"}], "]"}]}]}], "]"}]}], 
  ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.52027322526379*^9, 3.520273269832975*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Action Menu Filter", "Section",
 InitializationCell->True,
 CellChangeTimes->{{3.509128698976028*^9, 3.5091287030561037`*^9}, {
  3.517921240914071*^9, 3.5179212560201473`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"MakeCDFActionMenu", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"caption_String", ",", "dat_List"}], "}"}], ",", 
     RowBox[{"opts___", "?", "OptionQ"}]}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"outList", "=", 
        RowBox[{"{", "}"}]}], ",", "uri", ",", "action"}], "}"}], ",", 
     RowBox[{
      RowBox[{"appear", "=", "None"}], ";", "\[IndentingNewLine]", 
      RowBox[{"ClearAttributes", "[", 
       RowBox[{"RuleDelayed", ",", "HoldRest"}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"Scan", "[", 
       RowBox[{
        RowBox[{"Function", "[", 
         RowBox[{
          RowBox[{"{", "i", "}"}], ",", 
          RowBox[{
           RowBox[{"uri", "=", 
            RowBox[{"If", "[", 
             RowBox[{
              RowBox[{"StringMatchQ", "[", 
               RowBox[{
                RowBox[{
                 RowBox[{"dat", "[", 
                  RowBox[{"[", "i", "]"}], "]"}], "[", 
                 RowBox[{"[", "2", "]"}], "]"}], ",", "\"\<paclet*\>\""}], 
               "]"}], ",", 
              RowBox[{
               RowBox[{"dat", "[", 
                RowBox[{"[", "i", "]"}], "]"}], "[", 
               RowBox[{"[", "2", "]"}], "]"}], ",", 
              RowBox[{"\"\<paclet:\>\"", "<>", 
               RowBox[{
                RowBox[{"dat", "[", 
                 RowBox[{"[", "i", "]"}], "]"}], "[", 
                RowBox[{"[", "2", "]"}], "]"}]}]}], "]"}]}], ";", 
           "\[IndentingNewLine]", 
           RowBox[{"action", "=", 
            RowBox[{"ActionXXXX", "[", 
             RowBox[{"{", 
              RowBox[{"ActionYYYY", "[", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"URL", "[", 
                  RowBox[{
                   RowBox[{"StringReplace", "[", 
                    RowBox[{"uri", ",", 
                    RowBox[{
                    "\"\<paclet:\>\"", "\[Rule]", 
                    "\"\<http://reference.wolfram.com/mathematica/\>\""}]}], 
                    "]"}], "<>", "\"\<.cdf\>\""}], "]"}], ",", "None"}], 
                "}"}], "]"}], "}"}], "]"}]}], ";", "\[IndentingNewLine]", 
           RowBox[{"AppendTo", "[", 
            RowBox[{"outList", ",", 
             RowBox[{
              RowBox[{
               RowBox[{"dat", "[", 
                RowBox[{"[", "i", "]"}], "]"}], "[", 
               RowBox[{"[", "1", "]"}], "]"}], "\[RuleDelayed]", "action"}]}],
             "]"}], ";"}]}], "]"}], ",", 
        RowBox[{"Range", "[", 
         RowBox[{"Length", "[", "dat", "]"}], "]"}]}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"SetAttributes", "[", 
       RowBox[{"RuleDelayed", ",", "HoldRest"}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"outList", "=", 
       RowBox[{"outList", "/.", 
        RowBox[{"ActionXXXX", "\[Rule]", "FrontEndExecute"}]}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"outList", "=", 
       RowBox[{"outList", "/.", 
        RowBox[{"ActionYYYY", "\[Rule]", "NotebookLocate"}]}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"ActionMenuBox", "[", 
       RowBox[{
        RowBox[{"FrameBox", "[", "caption", "]"}], ",", "outList", ",", 
        RowBox[{"Appearance", "\[Rule]", "appear"}], ",", 
        RowBox[{"MenuAppearance", "\[Rule]", "Automatic"}]}], "]"}]}]}], 
    "]"}]}], ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{
  3.508678581170425*^9, 3.508688897269216*^9, 3.5091981766179123`*^9, {
   3.5110104883385153`*^9, 3.5110104956161633`*^9}, {3.516456481613875*^9, 
   3.516456490045637*^9}, {3.51975492787122*^9, 3.519754928435738*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Button Data Filter", "Section",
 InitializationCell->True,
 CellChangeTimes->{{3.5136176345738163`*^9, 3.513617636447405*^9}, {
  3.517921466715361*^9, 3.517921467786944*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"ButtonDataConversion", "[", "bd_", "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", "}"}], ",", 
    RowBox[{"Which", "[", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{
       RowBox[{"StringQ", "[", "bd", "]"}], "&&", 
       RowBox[{"StringMatchQ", "[", 
        RowBox[{"bd", ",", "\"\<*NETLink/example/Part1/*\>\""}], "]"}]}], ",", 
      RowBox[{
      "\"\<http://reference.wolfram.com/mathematica/notebooks/\>\"", "<>", 
       "bd"}], ",", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"StringQ", "[", "bd", "]"}], "&&", 
       RowBox[{"StringMatchQ", "[", 
        RowBox[{"bd", ",", "\"\<*JLink/example/Part1/*\>\""}], "]"}]}], ",", 
      RowBox[{
      "\"\<http://reference.wolfram.com/mathematica/notebooks/\>\"", "<>", 
       "bd"}], ",", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"StringQ", "[", "bd", "]"}], "&&", 
       RowBox[{"StringMatchQ", "[", 
        RowBox[{"bd", ",", "\"\<*JLink/ref/java/*\>\""}], "]"}]}], ",", 
      RowBox[{
       RowBox[{"StringReplace", "[", 
        RowBox[{
         RowBox[{"StringReplace", "[", 
          RowBox[{"bd", ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{
             "\"\<paclet:\>\"", "\[Rule]", 
              "\"\<http://reference.wolfram.com/mathematica/\>\""}], ",", 
             RowBox[{
             "\"\<JLink/ref/java/\>\"", "\[Rule]", 
              "\"\<JLink/ref/java/com/wolfram/jlink/\>\""}]}], "}"}]}], "]"}],
          ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{
           "\"\<JLink/ref/java/com/wolfram/jlink/BracketMatcher\>\"", 
            "\[Rule]", 
            "\"\<JLink/ref/java/com/wolfram/jlink/ui/BracketMatcher\>\""}], 
           ",", 
           RowBox[{
           "\"\<JLink/ref/java/com/wolfram/jlink/ConsoleWindow\>\"", 
            "\[Rule]", 
            "\"\<JLink/ref/java/com/wolfram/jlink/ui/ConsoleWindow\>\""}], 
           ",", 
           RowBox[{
           "\"\<JLink/ref/java/com/wolfram/jlink/InterruptDialog\>\"", 
            "\[Rule]", 
            "\"\<JLink/ref/java/com/wolfram/jlink/ui/InterruptDialog\>\""}], 
           ",", 
           RowBox[{
           "\"\<JLink/ref/java/com/wolfram/jlink/MathSessionPane\>\"", 
            "\[Rule]", 
            "\"\<JLink/ref/java/com/wolfram/jlink/ui/MathSessionPane\>\""}], 
           ",", 
           RowBox[{
           "\"\<JLink/ref/java/com/wolfram/jlink/SyntaxTokenizer\>\"", 
            "\[Rule]", 
            "\"\<JLink/ref/java/com/wolfram/jlink/ui/SyntaxTokenizer\>\""}], 
           ",", 
           RowBox[{
           "\"\<JLink/ref/java/com/wolfram/jlink/LinkSnooper\>\"", "\[Rule]", 
            "\"\<JLink/ref/java/com/wolfram/jlink/util/LinkSnooper\>\""}], 
           ",", 
           RowBox[{
           "\"\<JLink/ref/java/com/wolfram/jlink/MathematicaTask\>\"", 
            "\[Rule]", 
            "\"\<JLink/ref/java/com/wolfram/jlink/util/MathematicaTask\>\""}]}\
], "}"}]}], "]"}], "<>", "\"\<.html\>\""}], ",", 
      RowBox[{
       RowBox[{"StringQ", "[", "bd", "]"}], "&&", 
       RowBox[{"StringMatchQ", "[", 
        RowBox[{"bd", ",", "\"\<*NETLink/ref/net/*\>\""}], "]"}]}], ",", 
      RowBox[{
       RowBox[{"StringReplace", "[", 
        RowBox[{
         RowBox[{"StringReplace", "[", 
          RowBox[{"bd", ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{
             "\"\<paclet:\>\"", "\[Rule]", 
              "\"\<http://reference.wolfram.com/mathematica/\>\""}], ",", 
             RowBox[{
             "\"\<NETLink/ref/net/\>\"", "\[Rule]", 
              "\"\<NETLink/ref/net/Wolfram.NETLink.\>\""}], ",", 
             RowBox[{
             "\"\<IKernelLink/\>\"", "\[Rule]", "\"\<IKernelLink.\>\""}]}], 
            "}"}]}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{
           "\"\<NETLink/ref/net/Wolfram.NETLink.NETLink\>\"", "\[Rule]", 
            "\"\<NETLink/ref/net/Wolfram.NETLink\>\""}], ",", 
           RowBox[{
           "\"\<Wolfram.NETLink.IKernelLink.EvaluateToOutputForm\>\"", 
            "\[Rule]", 
            "\"\<Wolfram.NETLink.IKernelLink.EvaluateToOutputForm_overloads\>\
\""}], ",", 
           RowBox[{
           "\"\<Wolfram.NETLink.IKernelLink.EvaluateToImage\>\"", "\[Rule]", 
            "\"\<Wolfram.NETLink.IKernelLink.EvaluateToImage_overloads\>\""}],
            ",", 
           RowBox[{
           "\"\<Wolfram.NETLink.IKernelLink.Evaluate\>\"", "\[Rule]", 
            "\"\<Wolfram.NETLink.IKernelLink.Evaluate_overloads\>\""}], ",", 
           RowBox[{
           "\"\<Wolfram.NETLink.IKernelLink.GetInteger\>\"", "\[Rule]", 
            "\"\<Wolfram.NETLink.IMathLink.GetInteger\>\""}], ",", 
           RowBox[{
           "\"\<Wolfram.NETLink.ConsoleWindow\>\"", "\[Rule]", 
            "\"\<Wolfram.NETLink.UI.ConsoleWindow\>\""}], ",", 
           RowBox[{
           "\"\<Wolfram.NETLink.DoubleBufferedPanel\>\"", "\[Rule]", 
            "\"\<Wolfram.NETLink.UI.DoubleBufferedPanel\>\""}], ",", 
           RowBox[{
           "\"\<Wolfram.NETLink.MathPictureBox\>\"", "\[Rule]", 
            "\"\<Wolfram.NETLink.UI.MathPictureBox\>\""}], ",", 
           RowBox[{
           "\"\<Wolfram.NETLink.MathLinkFactory/CreateKernelLink\>\"", 
            "\[Rule]", 
            "\"\<Wolfram.NETLink.MathLinkFactory.CreateKernelLink_overloads\>\
\""}], ",", 
           RowBox[{"(*", 
            RowBox[{
             RowBox[{
              RowBox[{"\"\<Wolfram.NETLink.NETLink\>\"", "<>", "\"\<\>\""}], 
              "\[Rule]", "\"\<index\>\""}], ","}], "*)"}], 
           RowBox[{
           "\"\<NETLink/ref/net/DotNETInterface\>\"", "\[Rule]", 
            "\"\<NETLink/guide/DotNETInterface\>\""}]}], "}"}]}], "]"}], 
       "<>", "\"\<.html\>\""}], ",", "True", ",", 
      RowBox[{
       RowBox[{"StringReplace", "[", 
        RowBox[{
         RowBox[{"First", "[", 
          RowBox[{"StringSplit", "[", 
           RowBox[{"bd", ",", "\"\<#\>\""}], "]"}], "]"}], ",", 
         RowBox[{
         "\"\<paclet:\>\"", "\[Rule]", 
          "\"\<http://reference.wolfram.com/mathematica/\>\""}]}], "]"}], 
       "<>", "\"\<.cdf\>\""}]}], "]"}]}], "]"}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.513618793500648*^9, 3.513618806526678*^9}, {
  3.516456513499893*^9, 3.516456547368885*^9}, {3.519754933760872*^9, 
  3.519754957111451*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Primary Example Filter (Open/Close All)", "Section",
 InitializationCell->True,
 CellChangeTimes->{{3.5091286882951527`*^9, 3.509128688999133*^9}, {
  3.514721803432283*^9, 3.5147218049446993`*^9}, {3.517921616319525*^9, 
  3.517921627966589*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"primaryexamplecell", "[", "lang_", "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", "}"}], ",", 
    RowBox[{"Cell", "[", 
     RowBox[{
      RowBox[{"BoxData", "[", 
       RowBox[{"GridBox", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"Cell", "[", 
             RowBox[{"BoxData", "[", 
              RowBox[{"ButtonBox", "[", 
               RowBox[{
                RowBox[{"StyleBox", "[", 
                 RowBox[{
                  RowBox[{"CDFLocalized", "[", 
                   RowBox[{"\"\<EXAMPLES\>\"", ",", "lang"}], "]"}], ",", 
                  RowBox[{"FontSize", "\[Rule]", 
                   RowBox[{"Switch", "[", 
                    RowBox[{
                    "lang", ",", " ", "\"\<English\>\"", ",", "9", ",", " ", 
                    "\"\<Japanese\>\"", ",", " ", "12", ",", 
                    "\"\<ChineseSimplified\>\"", ",", " ", "12", ",", " ", 
                    "_", ",", " ", "9"}], "]"}]}], ",", 
                  RowBox[{"FontFamily", "\[Rule]", "\"\<Verdana\>\""}], ",", 
                  RowBox[{"FontTracking", "\[Rule]", "\"\<Wide\>\""}]}], 
                 "]"}], ",", "\n", " ", 
                RowBox[{"BaseStyle", "->", "None"}], ",", "\n", " ", 
                RowBox[{"Appearance", "->", 
                 RowBox[{"{", 
                  RowBox[{"Automatic", ",", " ", "None"}], "}"}]}], ",", "\n",
                 " ", 
                RowBox[{"Evaluator", "->", "None"}], ",", "\n", " ", 
                RowBox[{"Method", "->", "\"\<Preemptive\>\""}], ",", "\n", 
                " ", 
                RowBox[{"ButtonFunction", ":>", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"FrontEndExecute", "[", 
                    RowBox[{"{", "\n", "    ", 
                    RowBox[{
                    RowBox[{"FrontEnd`SelectionMove", "[", "\n", "     ", 
                    RowBox[{
                    RowBox[{"FrontEnd`SelectedNotebook", "[", "]"}], ",", " ",
                     "All", ",", " ", "ButtonCell"}], "]"}], ",", " ", "\n", 
                    "    ", 
                    RowBox[{
                    "FrontEndToken", "[", "\"\<OpenCloseGroup\>\"", "]"}], 
                    ",", " ", "\n", "    ", 
                    RowBox[{"FrontEnd`SelectionMove", "[", "\n", "     ", 
                    RowBox[{
                    RowBox[{"FrontEnd`SelectedNotebook", "[", "]"}], ",", " ",
                     "After", ",", " ", "CellContents"}], "]"}]}], "}"}], 
                    "]"}], "&"}], " ", ")"}]}]}], "]"}], "]"}], "]"}], ",", 
            "\n", "    ", 
            RowBox[{"Cell", "[", 
             RowBox[{"BoxData", "[", 
              RowBox[{"ToBoxes", "[", 
               RowBox[{"Button", "[", "\n", "     ", 
                RowBox[{
                 RowBox[{"Style", "[", 
                  RowBox[{
                   RowBox[{"CDFLocalized", "[", 
                    RowBox[{"\"\<OPEN ALL/CLOSE ALL\>\"", ",", "lang"}], 
                    "]"}], ",", 
                   RowBox[{"FontColor", "\[Rule]", "Black"}], ",", 
                   RowBox[{"FontFamily", "\[Rule]", "\"\<Verdana\>\""}], ",", 
                   
                   RowBox[{"FontSize", "->", 
                    RowBox[{"Switch", "[", 
                    RowBox[{
                    "lang", ",", " ", "\"\<English\>\"", ",", "9", ",", " ", 
                    "\"\<Japanese\>\"", ",", " ", "10", ",", 
                    "\"\<ChineseSimplified\>\"", ",", " ", "10", ",", " ", 
                    "_", ",", " ", "9"}], "]"}]}], ",", 
                   RowBox[{"FontTracking", "\[Rule]", "\"\<Wide\>\""}]}], 
                  "]"}], ",", "\n", "  ", 
                 RowBox[{"If", "[", 
                  RowBox[{
                   RowBox[{"CurrentValue", "[", 
                    RowBox[{
                    RowBox[{"ButtonNotebook", "[", "]"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"TaggingRules", ",", "\"\<ExamplesClosed\>\""}], 
                    "}"}]}], "]"}], ",", "\n", "       ", 
                   RowBox[{
                    RowBox[{"FrontEndExecute", "[", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"FrontEnd`NotebookFind", "[", 
                    RowBox[{
                    RowBox[{"FrontEnd`ButtonNotebook", "[", "]"}], ",", 
                    "\"\<ExampleSection\>\"", ",", "All", ",", "CellStyle", 
                    ",", 
                    RowBox[{"AutoScroll", "->", "False"}]}], "]"}], ",", 
                    "     ", 
                    RowBox[{"FrontEnd`SelectionMove", "[", 
                    RowBox[{
                    RowBox[{"FrontEnd`ButtonNotebook", "[", "]"}], ",", "All",
                     ",", "CellGroup", ",", 
                    RowBox[{"AutoScroll", "->", "False"}]}], "]"}], ",", 
                    RowBox[{"FrontEndToken", "[", 
                    RowBox[{
                    RowBox[{"ButtonNotebook", "[", "]"}], ",", 
                    "\"\<SelectionOpenAllGroups\>\""}], "]"}]}], "}"}], "]"}],
                     ";", 
                    RowBox[{
                    RowBox[{"CurrentValue", "[", 
                    RowBox[{
                    RowBox[{"ButtonNotebook", "[", "]"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"TaggingRules", ",", "\"\<ExamplesClosed\>\""}], 
                    "}"}]}], "]"}], "=", "False"}]}], ",", "\n", "       ", 
                   RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"FrontEndExecute", "[", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"FrontEnd`NotebookFind", "[", 
                    RowBox[{
                    RowBox[{"FrontEnd`ButtonNotebook", "[", "]"}], ",", "#", 
                    ",", "All", ",", "CellStyle", ",", 
                    RowBox[{"AutoScroll", "\[Rule]", "False"}]}], "]"}], ",", 
                    
                    RowBox[{"FrontEndToken", "[", 
                    RowBox[{
                    RowBox[{"FrontEnd`ButtonNotebook", "[", "]"}], ",", 
                    "\"\<SelectionCloseAllGroups\>\""}], "]"}]}], "}"}], 
                    "]"}], "&"}], ")"}], "/@", 
                    RowBox[{"{", 
                    RowBox[{
                    "\"\<ExampleSubsection\>\"", ",", 
                    "\"\<ExampleSection\>\""}], "}"}]}], ";", 
                    RowBox[{
                    RowBox[{"CurrentValue", "[", 
                    RowBox[{
                    RowBox[{"ButtonNotebook", "[", "]"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"TaggingRules", ",", "\"\<ExamplesClosed\>\""}], 
                    "}"}]}], "]"}], "=", "True"}]}]}], "]"}], ",", 
                 RowBox[{"Appearance", "->", "None"}], ",", 
                 RowBox[{"Evaluator", "\[Rule]", "Automatic"}]}], "]"}], 
               "]"}], "]"}], "]"}]}], "}"}], "}"}], ",", "\n", "       ", 
         RowBox[{"GridBoxAlignment", "->", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"\"\<Columns\>\"", "\[Rule]", 
             RowBox[{"{", 
              RowBox[{"Left", ",", 
               RowBox[{"{", "Right", "}"}]}], "}"}]}], ",", 
            RowBox[{"\"\<ColumnsIndexed\>\"", "\[Rule]", 
             RowBox[{"{", "}"}]}], ",", 
            RowBox[{"\"\<Rows\>\"", "\[Rule]", 
             RowBox[{"{", 
              RowBox[{"{", "Center", "}"}], "}"}]}], ",", 
            RowBox[{"\"\<RowsIndexed\>\"", "\[Rule]", 
             RowBox[{"{", "}"}]}]}], "}"}]}]}], "]"}], "\n", "     ", "\n", 
       " ", "]"}], ",", " ", "\"\<PrimaryExamplesSection\>\"", ",", "\n", " ", 
      RowBox[{"CellTags", "->", "\"\<PrimaryExamplesSection\>\""}]}], "]"}]}],
    "]"}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.51093121018039*^9, 3.510931229063138*^9}, {
   3.511104534954422*^9, 3.511104539453843*^9}, {3.5136121158122787`*^9, 
   3.513612117049645*^9}, {3.520272361342845*^9, 3.520272389653757*^9}, {
   3.5202726161122828`*^9, 3.520272627334251*^9}, 3.52027270024968*^9, 
   3.5202733277580767`*^9, {3.520273412816657*^9, 3.520273439017825*^9}, {
   3.5206171951822987`*^9, 3.5206172076144238`*^9}, 3.5213085898168583`*^9, 
   3.5213089163682747`*^9, {3.521309113189192*^9, 3.521309113754225*^9}, {
   3.521309203339033*^9, 3.521309203768745*^9}, {3.521309275869914*^9, 
   3.521309389395911*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Buttons to PaneSelectors", "Section",
 InitializationCell->True,
 CellChangeTimes->{{3.513697209471097*^9, 3.513697213745091*^9}, {
  3.5179215050315104`*^9, 3.5179215145905447`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"PaneSelectorMakerWithBaseStyle", "[", 
    RowBox[{
    "label_", ",", " ", "basestyles_", ",", " ", "dockedlinktraillength_"}], 
    "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", "}"}], ",", 
     RowBox[{"TagBox", "[", "\n", "       ", 
      RowBox[{
       RowBox[{"PaneSelectorBox", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"False", "->", "\n", "        ", 
            RowBox[{"StyleBox", "[", 
             RowBox[{"label", ",", " ", 
              RowBox[{"Sequence", "@", 
               RowBox[{"If", "[", 
                RowBox[{
                 RowBox[{"dockedlinktraillength", "<", "1"}], ",", 
                 RowBox[{"Flatten", "[", 
                  RowBox[{"{", 
                   RowBox[{"\"\<Hyperlink\>\"", ",", 
                    RowBox[{"DeleteCases", "[", 
                    RowBox[{"basestyles", ",", " ", 
                    RowBox[{"\"\<Hyperlink\>\"", "|", "None"}]}], "]"}]}], 
                   "}"}], "]"}], ",", 
                 RowBox[{"{", 
                  RowBox[{
                  "\"\<Hyperlink\>\"", ",", " ", "\"\<DockedLinkTrail\>\""}], 
                  "}"}]}], "]"}]}], ",", "\n", "         ", 
              RowBox[{"StripOnInput", "->", "False"}]}], "]"}]}], ",", " ", 
           RowBox[{"True", "->", 
            RowBox[{"StyleBox", "[", 
             RowBox[{"label", ",", " ", 
              RowBox[{"Sequence", "@", 
               RowBox[{"If", "[", 
                RowBox[{
                 RowBox[{"dockedlinktraillength", "<", "1"}], ",", 
                 RowBox[{"Flatten", "[", 
                  RowBox[{"{", 
                   RowBox[{"\"\<HyperlinkActive\>\"", ",", 
                    RowBox[{"DeleteCases", "[", 
                    RowBox[{"basestyles", ",", " ", 
                    RowBox[{"\"\<Hyperlink\>\"", "|", "None"}]}], "]"}], ",", 
                    " ", 
                    RowBox[{"StripOnInput", "->", "False"}], ",", "\n", 
                    "         ", 
                    RowBox[{"LineColor", "->", 
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0.82352", ",", "0.49", ",", "0.1333"}], "]"}]}], 
                    ",", "\n", "         ", 
                    RowBox[{"FrontFaceColor", "->", 
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0.82352", ",", "0.49", ",", "0.1333"}], "]"}]}], 
                    ",", "\n", "         ", 
                    RowBox[{"BackFaceColor", "->", 
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0.82352", ",", "0.49", ",", "0.1333"}], "]"}]}], 
                    ",", "\n", "         ", 
                    RowBox[{"GraphicsColor", "->", 
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0.82352", ",", "0.49", ",", "0.1333"}], "]"}]}], 
                    ",", "\n", "         ", 
                    RowBox[{"FontColor", "->", 
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0.82352", ",", "0.49", ",", "0.1333"}], 
                    "]"}]}]}], "}"}], "]"}], ",", 
                 RowBox[{"{", 
                  RowBox[{
                  "\"\<HyperlinkActive\>\"", ",", " ", 
                   "\"\<DockedLinkTrail\>\"", ",", " ", 
                   RowBox[{"StripOnInput", "->", "False"}], ",", "\n", 
                   "         ", 
                   RowBox[{"LineColor", "->", 
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0.82352", ",", "0.49", ",", "0.1333"}], "]"}]}], 
                   ",", "\n", "         ", 
                   RowBox[{"FrontFaceColor", "->", 
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0.82352", ",", "0.49", ",", "0.1333"}], "]"}]}], 
                   ",", "\n", "         ", 
                   RowBox[{"BackFaceColor", "->", 
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0.82352", ",", "0.49", ",", "0.1333"}], "]"}]}], 
                   ",", "\n", "         ", 
                   RowBox[{"GraphicsColor", "->", 
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0.82352", ",", "0.49", ",", "0.1333"}], "]"}]}], 
                   ",", "\n", "         ", 
                   RowBox[{"FontColor", "->", 
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0.82352", ",", "0.49", ",", "0.1333"}], 
                    "]"}]}]}], "}"}]}], "]"}]}]}], "]"}]}]}], "}"}], ",", " ", 
         RowBox[{"Dynamic", "[", "\n", "         ", 
          RowBox[{"CurrentValue", "[", "\"\<MouseOver\>\"", "]"}], "]"}], ",",
          "\n", "        ", 
         RowBox[{"FrameMargins", "->", "0"}], ",", "\n", "        ", 
         RowBox[{"ImageSize", "->", "Automatic"}]}], "]"}], ",", "\n", 
       "       ", 
       RowBox[{"MouseAppearanceTag", "[", "\"\<LinkHand\>\"", "]"}]}], 
      "]"}]}], "]"}]}], ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.513691265358251*^9, 3.513691331153736*^9}, {
   3.513691413096942*^9, 3.5136914173520527`*^9}, {3.5177447462847013`*^9, 
   3.51774477880829*^9}, 3.519496494146194*^9, {3.5196490761152678`*^9, 
   3.51964907948619*^9}}],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{
   RowBox[{"PaneSelectorMakerWithBaseStyle", "[", 
    RowBox[{
     RowBox[{"PaneSelectorBox", "[", "label___", "]"}], ",", " ", 
     "basestyles_", ",", " ", "dockedlinktraillength_"}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", "}"}], ",", 
     RowBox[{"PaneSelectorBox", "[", "label", "]"}]}], "]"}]}], " ", 
  "*)"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.517771776137973*^9, 3.5177717875935307`*^9}, {
  3.5177719343805943`*^9, 3.5177719367784777`*^9}, {3.517772040466414*^9, 
  3.517772043869936*^9}, {3.517773179146563*^9, 3.5177731831441517`*^9}}],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{
   RowBox[{"PaneSelectorMakerWithBaseStyle", "[", 
    RowBox[{
     RowBox[{"PaneSelectorBox", "[", "label___", "]"}], ",", " ", 
     "dockedlinktraillength_"}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", "}"}], ",", 
     RowBox[{"PaneSelectorBox", "[", "label", "]"}]}], "]"}]}], " ", 
  "*)"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.517772020992104*^9, 3.5177720461061897`*^9}, {
  3.517773185968564*^9, 3.5177731903362093`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"PaneSelectorMakerWithOutBaseStyle", "[", 
    RowBox[{"label_", ",", " ", "dockedlinktraillength_"}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", "}"}], ",", 
     RowBox[{"TagBox", "[", "\n", "       ", 
      RowBox[{
       RowBox[{"PaneSelectorBox", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"False", "->", "\n", "        ", 
            RowBox[{"StyleBox", "[", 
             RowBox[{"label", ",", " ", 
              RowBox[{"If", "[", 
               RowBox[{
                RowBox[{"dockedlinktraillength", "<", "1"}], ",", 
                RowBox[{"{", "\"\<Hyperlink\>\"", "}"}], ",", 
                RowBox[{"{", 
                 RowBox[{
                 "\"\<Hyperlink\>\"", ",", " ", "\"\<DockedLinkTrail\>\""}], 
                 "}"}]}], "]"}], ",", "\n", "         ", 
              RowBox[{"StripOnInput", "->", "False"}]}], "]"}]}], ",", " ", 
           RowBox[{"True", "->", "\n", "        ", 
            RowBox[{"StyleBox", "[", 
             RowBox[{"label", ",", " ", 
              RowBox[{"If", "[", 
               RowBox[{
                RowBox[{"dockedlinktraillength", "<", "1"}], ",", 
                RowBox[{"{", "\"\<HyperlinkActive\>\"", "}"}], ",", 
                RowBox[{"{", 
                 RowBox[{
                 "\"\<HyperlinkActive\>\"", ",", " ", 
                  "\"\<DockedLinkTrail\>\"", ",", " ", 
                  RowBox[{"LineColor", "->", 
                   RowBox[{"RGBColor", "[", 
                    RowBox[{"0.82352", ",", "0.49", ",", "0.1333"}], "]"}]}], 
                  ",", "\n", "         ", 
                  RowBox[{"FrontFaceColor", "->", 
                   RowBox[{"RGBColor", "[", 
                    RowBox[{"0.82352", ",", "0.49", ",", "0.1333"}], "]"}]}], 
                  ",", "\n", "         ", 
                  RowBox[{"BackFaceColor", "->", 
                   RowBox[{"RGBColor", "[", 
                    RowBox[{"0.82352", ",", "0.49", ",", "0.1333"}], "]"}]}], 
                  ",", "\n", "         ", 
                  RowBox[{"GraphicsColor", "->", 
                   RowBox[{"RGBColor", "[", 
                    RowBox[{"0.82352", ",", "0.49", ",", "0.1333"}], "]"}]}], 
                  ",", "\n", "         ", 
                  RowBox[{"FontColor", "->", 
                   RowBox[{"RGBColor", "[", 
                    RowBox[{"0.82352", ",", "0.49", ",", "0.1333"}], 
                    "]"}]}]}], "}"}]}], "]"}], ",", "\n", "         ", 
              RowBox[{"StripOnInput", "->", "False"}]}], "]"}]}]}], "}"}], 
         ",", " ", 
         RowBox[{"Dynamic", "[", "\n", "         ", 
          RowBox[{"CurrentValue", "[", "\"\<MouseOver\>\"", "]"}], "]"}], ",",
          "\n", "        ", 
         RowBox[{"FrameMargins", "->", "0"}], ",", "\n", "        ", 
         RowBox[{"ImageSize", "->", "Automatic"}]}], "]"}], ",", "\n", 
       "       ", 
       RowBox[{"MouseAppearanceTag", "[", "\"\<LinkHand\>\"", "]"}]}], 
      "]"}]}], "]"}]}], ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.513691440591947*^9, 3.513691452237349*^9}, {
   3.517744781707795*^9, 3.517744783147222*^9}, 3.519496492594425*^9, {
   3.519649082473002*^9, 3.5196490837207413`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"ButtonToPaneSelector", "[", 
    RowBox[{"label_", ",", "b___"}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"dockedlinktraillength", "=", 
        RowBox[{"Length", "[", 
         RowBox[{"Cases", "[", 
          RowBox[{
           RowBox[{"{", "b", "}"}], ",", "\"\<DockedLinkTrail\>\"", ",", " ", 
           "Infinity"}], "]"}], "]"}]}], ",", "\[IndentingNewLine]", 
       RowBox[{"basestyles", "=", 
        RowBox[{"Flatten", "[", 
         RowBox[{"Cases", "[", 
          RowBox[{
           RowBox[{"{", "b", "}"}], ",", 
           RowBox[{
            RowBox[{"Rule", "[", 
             RowBox[{"BaseStyle", ",", " ", "c_"}], "]"}], "\[RuleDelayed]", 
            "c"}], ",", " ", "Infinity"}], "]"}], "]"}]}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"buttondata", "=", 
        RowBox[{"Cases", "[", 
         RowBox[{
          RowBox[{"{", "b", "}"}], ",", 
          RowBox[{
           RowBox[{"Rule", "[", 
            RowBox[{"ButtonData", ",", " ", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"URL", "[", "c_String", "]"}], ",", "None"}], "}"}]}], 
            "]"}], "\[RuleDelayed]", "c"}], ",", " ", "Infinity"}], "]"}]}]}],
       "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"Length", "[", "basestyles", "]"}], ">", "0"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"Length", "[", "buttondata", "]"}], ">", "0"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{"MemberQ", "[", 
            RowBox[{"basestyles", ",", " ", "\"\<ExampleLink\>\""}], "]"}], 
           ",", "\[IndentingNewLine]", 
           RowBox[{"ButtonBox", "[", 
            RowBox[{"label", ",", "b"}], "]"}], ",", 
           RowBox[{"ButtonBox", "[", 
            RowBox[{
             RowBox[{"Cell", "[", 
              RowBox[{
               RowBox[{"BoxData", "[", 
                RowBox[{"FormBox", "[", 
                 RowBox[{
                  RowBox[{"ButtonBox", "[", "\n", "      ", 
                   RowBox[{
                    RowBox[{"PaneSelectorMakerWithBaseStyle", "[", 
                    RowBox[{
                    "label", ",", " ", "basestyles", ",", " ", 
                    "dockedlinktraillength"}], "]"}], ",", "\n", "      ", 
                    RowBox[{"BaseStyle", "->", "\"\<Hyperlink\>\""}], ",", 
                    RowBox[{"ButtonNote", "\[Rule]", 
                    RowBox[{"buttondata", "[", 
                    RowBox[{"[", "1", "]"}], "]"}]}]}], "]"}], ",", 
                  "TextForm"}], "]"}], "]"}], ",", " ", 
               RowBox[{"CellFrame", "\[Rule]", "False"}]}], "]"}], ",", "b"}],
             "]"}]}], " ", "]"}], ",", "\[IndentingNewLine]", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{"MemberQ", "[", 
            RowBox[{"basestyles", ",", " ", "\"\<ExampleLink\>\""}], "]"}], 
           ",", "\[IndentingNewLine]", 
           RowBox[{"ButtonBox", "[", 
            RowBox[{"label", ",", "b"}], "]"}], ",", 
           RowBox[{"ButtonBox", "[", 
            RowBox[{
             RowBox[{"Cell", "[", 
              RowBox[{
               RowBox[{"BoxData", "[", 
                RowBox[{"FormBox", "[", 
                 RowBox[{
                  RowBox[{"ButtonBox", "[", "\n", "      ", 
                   RowBox[{
                    RowBox[{"PaneSelectorMakerWithBaseStyle", "[", 
                    RowBox[{
                    "label", ",", " ", "basestyles", ",", " ", 
                    "dockedlinktraillength"}], "]"}], ",", "\n", "      ", 
                    RowBox[{"BaseStyle", "->", "\"\<Hyperlink\>\""}]}], "]"}],
                   ",", "TextForm"}], "]"}], "]"}], ",", " ", 
               RowBox[{"CellFrame", "\[Rule]", "False"}]}], "]"}], ",", "b"}],
             "]"}]}], "]"}]}], "]"}], "\[IndentingNewLine]", ",", 
       "\[IndentingNewLine]", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"Length", "[", "buttondata", "]"}], ">", "0"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"ButtonBox", "[", 
          RowBox[{
           RowBox[{"Cell", "[", 
            RowBox[{
             RowBox[{"BoxData", "[", 
              RowBox[{"FormBox", "[", 
               RowBox[{
                RowBox[{"ButtonBox", "[", 
                 RowBox[{
                  RowBox[{"ButtonBox", "[", "\n", "      ", 
                   RowBox[{
                    RowBox[{"PaneSelectorMakerWithOutBaseStyle", "[", 
                    RowBox[{"label", ",", " ", "dockedlinktraillength"}], 
                    "]"}], ",", "\n", "      ", 
                    RowBox[{"BaseStyle", "->", "\"\<Hyperlink\>\""}], ",", 
                    " ", 
                    RowBox[{"ButtonNote", "->", 
                    RowBox[{"buttondata", "[", 
                    RowBox[{"[", "1", "]"}], "]"}]}]}], "]"}], ",", 
                  RowBox[{"BaseStyle", "\[Rule]", "\"\<Hyperlink\>\""}]}], 
                 "]"}], ",", "TextForm"}], "]"}], "]"}], ",", " ", 
             RowBox[{"CellFrame", "\[Rule]", "False"}]}], "]"}], ",", "b"}], 
          "]"}], ",", 
         RowBox[{"ButtonBox", "[", 
          RowBox[{
           RowBox[{"Cell", "[", 
            RowBox[{
             RowBox[{"BoxData", "[", 
              RowBox[{"FormBox", "[", 
               RowBox[{
                RowBox[{"ButtonBox", "[", 
                 RowBox[{
                  RowBox[{"ButtonBox", "[", "\n", "      ", 
                   RowBox[{
                    RowBox[{"PaneSelectorMakerWithOutBaseStyle", "[", 
                    RowBox[{"label", ",", " ", "dockedlinktraillength"}], 
                    "]"}], ",", "\n", "      ", 
                    RowBox[{"BaseStyle", "->", "\"\<Hyperlink\>\""}]}], "]"}],
                   ",", 
                  RowBox[{"BaseStyle", "\[Rule]", "\"\<Hyperlink\>\""}]}], 
                 "]"}], ",", "TextForm"}], "]"}], "]"}], ",", " ", 
             RowBox[{"CellFrame", "\[Rule]", "False"}]}], "]"}], ",", "b"}], 
          "]"}]}], "]"}]}], "]"}]}], "]"}]}], ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.513689660469426*^9, 3.5136897002613487`*^9}, {
   3.51368976044029*^9, 3.513689783221876*^9}, {3.5136898147224083`*^9, 
   3.5136899054454527`*^9}, {3.513689941000765*^9, 3.51368994919417*^9}, 
   3.5136899804043016`*^9, {3.5136900202072153`*^9, 3.5136900271219883`*^9}, {
   3.513690634686338*^9, 3.513690644338212*^9}, {3.513690704528988*^9, 
   3.513690796863077*^9}, 3.513690830500176*^9, {3.5136909027504272`*^9, 
   3.513690943311927*^9}, 3.51369097367976*^9, {3.513691021283513*^9, 
   3.5136911114213333`*^9}, {3.513691358143968*^9, 3.5136913704162683`*^9}, 
   3.5136914261027822`*^9, {3.513691462400529*^9, 3.5136914664553347`*^9}, {
   3.513697038592045*^9, 3.513697118479342*^9}, {3.513697236418043*^9, 
   3.5136972375057592`*^9}, {3.513697277644569*^9, 3.5136972779789057`*^9}, {
   3.51403467815558*^9, 3.51403468785046*^9}, 3.516456334378129*^9, {
   3.516467427785907*^9, 3.5164674296695623`*^9}, 3.519496497928561*^9, {
   3.519663224178999*^9, 3.519663229939864*^9}, {3.519663292026504*^9, 
   3.519663292744317*^9}, 3.519670352825666*^9, {3.5197466765894327`*^9, 
   3.519746770757325*^9}, {3.519747041537994*^9, 3.519747047897958*^9}, {
   3.519747210581249*^9, 3.519747219940413*^9}, {3.519747266537648*^9, 
   3.5197473471907053`*^9}, {3.519747404541501*^9, 3.519747442165792*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Special Banner Messages", "Section",
 InitializationCell->True,
 CellChangeTimes->{{3.517249303427477*^9, 3.517249316562405*^9}, {
   3.517921354019293*^9, 3.517921355883257*^9}, {3.517921530985145*^9, 
   3.517921551577141*^9}, 3.517922342923003*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"playerspikey", "=", 
   GraphicsBox[
    TagBox[RasterBox[CompressedData["
1:eJzFlntQlOcVxrde2qi1tWIUUcAFuYhyFQ2o0RATTcbLRGjUpFFjMk1noqYd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      "], {{0, 33}, {32, 0}}, {0, 255},
      ColorFunction->RGBColor],
     BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
     Selectable->False],
    BaseStyle->"ImageGraphics",
    ImageSizeRaw->{32, 33},
    PlotRange->{{0, 32}, {0, 33}}]}], ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.5178393914258213`*^9, 3.517839402424006*^9}, 
   3.517853182288397*^9, 3.5178544463444853`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"playerslice", "=", 
   RowBox[{"ImageData", "[", 
    GraphicsBox[
     TagBox[
      RasterBox[{{{226, 226, 226}}, {{252, 252, 252}}, {{250, 250, 250}}, {{
       249, 249, 249}}, {{249, 249, 249}}, {{249, 249, 249}}, {{249, 249, 
       249}}, {{250, 250, 250}}, {{248, 248, 248}}, {{249, 249, 249}}, {{248, 
       248, 248}}, {{248, 248, 248}}, {{248, 248, 248}}, {{247, 247, 247}}, {{
       246, 246, 246}}, {{247, 247, 247}}, {{246, 246, 246}}, {{245, 245, 
       245}}, {{245, 245, 245}}, {{245, 245, 245}}, {{244, 244, 244}}, {{244, 
       244, 244}}, {{243, 243, 243}}, {{242, 242, 242}}, {{239, 239, 239}}, {{
       237, 237, 237}}, {{235, 235, 235}}, {{235, 235, 235}}, {{235, 235, 
       235}}, {{235, 235, 235}}, {{235, 235, 235}}, {{235, 235, 235}}, {{235, 
       235, 235}}, {{235, 235, 235}}, {{235, 235, 235}}, {{235, 235, 235}}, {{
       235, 235, 235}}, {{235, 235, 235}}, {{235, 235, 235}}, {{235, 235, 
       235}}, {{235, 235, 235}}, {{235, 235, 235}}, {{235, 235, 235}}, {{235, 
       235, 235}}, {{234, 234, 234}}, {{238, 238, 238}}, {{205, 205, 
       205}}}, {{0, 47}, {1, 0}}, {0, 255},
       ColorFunction->RGBColor],
      BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
      Selectable->False],
     BaseStyle->"ImageGraphics",
     ImageSize->Automatic,
     ImageSizeRaw->{1, 47},
     PlotRange->{{0, 1}, {0, 47}}], "]"}]}], ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.5178393826213083`*^9, 3.517839407782792*^9}, {
   3.5178394588025703`*^9, 3.517839471187499*^9}, 3.517853196021352*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"playermessage1", "[", "lang_", "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", "}"}], ",", 
     RowBox[{"Cell", "[", 
      RowBox[{
       RowBox[{"BoxData", "[", 
        RowBox[{"ToBoxes", "[", 
         RowBox[{"Style", "[", 
          RowBox[{
           RowBox[{"Overlay", "[", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"With", "[", 
                RowBox[{
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"w", "=", "800"}], ",", 
                   RowBox[{"h", "=", "47"}]}], "}"}], ",", 
                 RowBox[{"Graphics", "[", 
                  RowBox[{
                   RowBox[{"Raster", "[", 
                    RowBox[{
                    RowBox[{"Reverse", "@", "playerslice"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"0", ",", "0"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"w", ",", "h"}], "}"}]}], "}"}]}], "]"}], ",", 
                   RowBox[{"ImageSize", "\[Rule]", 
                    RowBox[{"{", 
                    RowBox[{"w", ",", "h"}], "}"}]}], ",", 
                   RowBox[{"PlotRangePadding", "\[Rule]", "None"}], ",", 
                   RowBox[{"ImagePadding", "\[Rule]", "None"}]}], "]"}]}], 
                "]"}], ",", 
               RowBox[{"Graphics", "[", 
                RowBox[{
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"Inset", "[", 
                    RowBox[{
                    RowBox[{"Deploy", "[", 
                    RowBox[{"Show", "[", "playerspikey", "]"}], "]"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"25", ",", "23"}], "}"}], ",", 
                    RowBox[{"ContentSelectable", "\[Rule]", "True"}]}], "]"}],
                    ",", "\[IndentingNewLine]", 
                   RowBox[{"Inset", "[", 
                    RowBox[{
                    RowBox[{"Graphics", "[", 
                    RowBox[{"Rasterize", "[", 
                    RowBox[{
                    RowBox[{"Cell", "[", 
                    RowBox[{
                    RowBox[{"CDFLocalized", "[", 
                    RowBox[{"\"\<playermessage1\>\"", ",", "lang"}], "]"}], 
                    ",", " ", "\"\<Text\>\"", ",", " ", 
                    RowBox[{"Hyphenation", "->", "False"}], ",", "\n", " ", 
                    RowBox[{"ParagraphSpacing", "->", 
                    RowBox[{"{", 
                    RowBox[{"0.7000000000000001", ",", " ", "0"}], "}"}]}], 
                    ",", "\n", " ", 
                    RowBox[{"StyleMenuListing", "->", "None"}], ",", "\n", 
                    " ", 
                    RowBox[{"FontFamily", "->", "\"\<Verdana\>\""}], ",", 
                    "\n", " ", 
                    RowBox[{"FontSize", "\[Rule]", 
                    RowBox[{"Switch", "[", 
                    RowBox[{
                    "lang", ",", "\"\<English\>\"", ",", "11", ",", 
                    "\"\<Japanese\>\"", ",", " ", "11", ",", 
                    "\"\<ChineseSimplified\>\"", ",", " ", "10", ",", " ", 
                    "_", ",", " ", "11"}], "]"}]}]}], "]"}], ",", 
                    RowBox[{"Background", "\[Rule]", "None"}]}], "]"}], "]"}],
                     ",", 
                    RowBox[{"Switch", "[", 
                    RowBox[{"lang", ",", "\"\<English\>\"", ",", 
                    RowBox[{"{", 
                    RowBox[{"267", ",", "23"}], "}"}], ",", 
                    "\"\<Japanese\>\"", ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"315", ",", "23"}], "}"}], ",", 
                    "\"\<ChineseSimplified\>\"", ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"200", ",", "23"}], "}"}], ",", " ", "_", ",", 
                    " ", 
                    RowBox[{"{", 
                    RowBox[{"267", ",", "23"}], "}"}]}], "]"}], ",", 
                    RowBox[{"ContentSelectable", "\[Rule]", "True"}]}], 
                    "]"}]}], "}"}], ",", 
                 RowBox[{"ContentSelectable", "\[Rule]", "True"}], ",", 
                 RowBox[{"PlotRange", "->", 
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{"{", 
                    RowBox[{"0", ",", "800"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"0", ",", "47"}], "}"}]}], "}"}]}], ",", 
                 RowBox[{"ImageSize", "\[Rule]", 
                  RowBox[{"{", 
                   RowBox[{"800", ",", "47"}], "}"}]}]}], "]"}]}], "}"}], ",",
              "All", ",", "2"}], "]"}], ",", 
           RowBox[{"ShowSelection", "\[Rule]", "False"}]}], "]"}], "]"}], 
        "]"}], ",", 
       RowBox[{"Deployed", "\[Rule]", "True"}], ",", 
       RowBox[{"ShowCellBracket", "\[Rule]", "False"}]}], " ", "]"}]}], 
    "]"}]}], ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.5178392969832277`*^9, 3.517839348478322*^9}, {
   3.517839483598159*^9, 3.517839490356883*^9}, {3.517839530624546*^9, 
   3.517839558282106*^9}, {3.5178395896993723`*^9, 3.517839711499296*^9}, {
   3.517839754070266*^9, 3.5178398508994904`*^9}, {3.517839897952956*^9, 
   3.5178398982148657`*^9}, {3.517839947068872*^9, 3.5178400364632072`*^9}, {
   3.5178400708635263`*^9, 3.5178400776514597`*^9}, {3.517840204058653*^9, 
   3.5178402176151457`*^9}, {3.517840270695778*^9, 3.51784032365853*^9}, 
   3.517840355091716*^9, {3.5178403882310877`*^9, 3.517840445272234*^9}, {
   3.517840505190928*^9, 3.51784054442383*^9}, {3.517840631291741*^9, 
   3.517840634539927*^9}, {3.5178407295105143`*^9, 3.5178407612788553`*^9}, {
   3.5178408342406816`*^9, 3.517840875149872*^9}, {3.517840947142164*^9, 
   3.517841115692984*^9}, {3.5178412042963943`*^9, 3.517841226526826*^9}, 
   3.517841271941093*^9, {3.5178415864830637`*^9, 3.517841595978133*^9}, {
   3.5178417335644712`*^9, 3.517841807334827*^9}, {3.51784184670893*^9, 
   3.51784186689214*^9}, {3.517846699805991*^9, 3.5178467269661694`*^9}, {
   3.517853220093696*^9, 3.517853220893256*^9}, {3.5178544831740923`*^9, 
   3.517854575972452*^9}, {3.5178564466344423`*^9, 3.517856477385271*^9}, {
   3.517856709299039*^9, 3.5178567256842823`*^9}, {3.5194794325481453`*^9, 
   3.5194794352120047`*^9}, {3.51947951669956*^9, 3.519479527548388*^9}, {
   3.519479654080389*^9, 3.5194797166413813`*^9}, {3.51949651319634*^9, 
   3.5194965135759773`*^9}, {3.520354935368094*^9, 3.520354954640204*^9}, {
   3.520355098059451*^9, 3.520355109249963*^9}, {3.520355160329933*^9, 
   3.520355274462347*^9}, {3.520615590596471*^9, 3.520615626748025*^9}, {
   3.520683116550474*^9, 3.520683136439437*^9}, 3.52087970797383*^9, {
   3.520879765145453*^9, 3.520879765612282*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"playermessage2", "[", "lang_", "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", "}"}], ",", 
     RowBox[{"Cell", "[", 
      RowBox[{
       RowBox[{"BoxData", "[", 
        RowBox[{"ToBoxes", "[", 
         RowBox[{"Style", "[", 
          RowBox[{
           RowBox[{"Overlay", "[", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"With", "[", 
                RowBox[{
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"w", "=", "800"}], ",", 
                   RowBox[{"h", "=", "47"}]}], "}"}], ",", 
                 RowBox[{"Graphics", "[", 
                  RowBox[{
                   RowBox[{"Raster", "[", 
                    RowBox[{
                    RowBox[{"Reverse", "@", "playerslice"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"0", ",", "0"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"w", ",", "h"}], "}"}]}], "}"}]}], "]"}], ",", 
                   RowBox[{"ImageSize", "\[Rule]", 
                    RowBox[{"{", 
                    RowBox[{"w", ",", "h"}], "}"}]}], ",", 
                   RowBox[{"PlotRangePadding", "\[Rule]", "None"}], ",", 
                   RowBox[{"ImagePadding", "\[Rule]", "None"}]}], "]"}]}], 
                "]"}], ",", 
               RowBox[{"Graphics", "[", 
                RowBox[{
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"Inset", "[", 
                    RowBox[{
                    RowBox[{"Deploy", "[", 
                    RowBox[{"Show", "[", "playerspikey", "]"}], "]"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"25", ",", "23"}], "}"}], ",", 
                    RowBox[{"ContentSelectable", "\[Rule]", "True"}]}], "]"}],
                    ",", "\[IndentingNewLine]", 
                   RowBox[{"Inset", "[", 
                    RowBox[{
                    RowBox[{"Graphics", "[", 
                    RowBox[{"Rasterize", "[", 
                    RowBox[{
                    RowBox[{"Cell", "[", 
                    RowBox[{
                    RowBox[{"CDFLocalized", "[", 
                    RowBox[{"\"\<playermessage2\>\"", ",", "lang"}], "]"}], 
                    ",", " ", "\"\<Text\>\"", ",", "\n", " ", 
                    RowBox[{"Hyphenation", "->", "False"}], ",", "\n", " ", 
                    RowBox[{"ParagraphSpacing", "->", 
                    RowBox[{"{", 
                    RowBox[{"0.7000000000000001", ",", " ", "0"}], "}"}]}], 
                    ",", "\n", " ", 
                    RowBox[{"StyleMenuListing", "->", "None"}], ",", "\n", 
                    " ", 
                    RowBox[{"FontFamily", "->", "\"\<Verdana\>\""}], ",", 
                    "\n", " ", 
                    RowBox[{"FontSize", "->", 
                    RowBox[{"Switch", "[", 
                    RowBox[{
                    "lang", ",", "\"\<English\>\"", ",", "11", ",", 
                    "\"\<Japanese\>\"", ",", " ", "11", ",", 
                    "\"\<ChineseSimplified\>\"", ",", " ", "10", ",", " ", 
                    "_", ",", " ", "11"}], "]"}]}]}], " ", "]"}], ",", 
                    RowBox[{"Background", "\[Rule]", "None"}]}], "]"}], "]"}],
                     ",", 
                    RowBox[{"Switch", "[", 
                    RowBox[{"lang", ",", "\"\<English\>\"", ",", 
                    RowBox[{"{", 
                    RowBox[{"264", ",", "23"}], "}"}], ",", 
                    "\"\<Japanese\>\"", ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"313", ",", "23"}], "}"}], ",", 
                    "\"\<ChineseSimplified\>\"", ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"169", ",", "23"}], "}"}], ",", " ", "_", ",", 
                    " ", 
                    RowBox[{"{", 
                    RowBox[{"264", ",", "23"}], "}"}]}], "]"}], ",", 
                    RowBox[{"ContentSelectable", "\[Rule]", "True"}]}], 
                    "]"}]}], "}"}], ",", 
                 RowBox[{"ContentSelectable", "\[Rule]", "True"}], ",", 
                 RowBox[{"PlotRange", "->", 
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{"{", 
                    RowBox[{"0", ",", "800"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"0", ",", "47"}], "}"}]}], "}"}]}], ",", 
                 RowBox[{"ImageSize", "\[Rule]", 
                  RowBox[{"{", 
                   RowBox[{"800", ",", "47"}], "}"}]}]}], "]"}]}], "}"}], ",",
              "All", ",", "2"}], "]"}], ",", 
           RowBox[{"ShowSelection", "\[Rule]", "False"}]}], "]"}], "]"}], 
        "]"}], ",", 
       RowBox[{"Deployed", "\[Rule]", "True"}], ",", 
       RowBox[{"ShowCellBracket", "\[Rule]", "False"}]}], " ", "]"}]}], 
    "]"}]}], ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.5178392969832277`*^9, 3.517839348478322*^9}, {
   3.517839483598159*^9, 3.517839490356883*^9}, {3.517839530624546*^9, 
   3.517839558282106*^9}, {3.5178395896993723`*^9, 3.517839711499296*^9}, {
   3.517839754070266*^9, 3.5178398508994904`*^9}, {3.517839897952956*^9, 
   3.5178398982148657`*^9}, {3.517839947068872*^9, 3.5178400364632072`*^9}, {
   3.5178400708635263`*^9, 3.5178400776514597`*^9}, {3.517840204058653*^9, 
   3.5178402176151457`*^9}, {3.517840270695778*^9, 3.51784032365853*^9}, 
   3.517840355091716*^9, {3.5178403882310877`*^9, 3.517840445272234*^9}, {
   3.517840505190928*^9, 3.51784054442383*^9}, {3.517840631291741*^9, 
   3.517840634539927*^9}, {3.5178407295105143`*^9, 3.5178407612788553`*^9}, {
   3.5178408342406816`*^9, 3.517840875149872*^9}, {3.517840947142164*^9, 
   3.517841115692984*^9}, {3.5178412042963943`*^9, 3.517841226526826*^9}, 
   3.517841271941093*^9, {3.5178415864830637`*^9, 3.517841595978133*^9}, {
   3.5178417335644712`*^9, 3.517841807334827*^9}, {3.51784184670893*^9, 
   3.51784186689214*^9}, {3.517846699805991*^9, 3.517846775954939*^9}, {
   3.5178546375549793`*^9, 3.5178546873259993`*^9}, {3.517854804894066*^9, 
   3.517854805620427*^9}, 3.517856441555141*^9, {3.5178565074699507`*^9, 
   3.517856533031438*^9}, 3.5178565726035957`*^9, {3.517856661624351*^9, 
   3.5178566834745398`*^9}, {3.5194794639742928`*^9, 3.519479464619006*^9}, {
   3.519479533036207*^9, 3.5194795478753967`*^9}, 3.519479648868204*^9, {
   3.519496516370267*^9, 3.519496516675034*^9}, {3.520355295993516*^9, 
   3.520355338139217*^9}, {3.520355506216626*^9, 3.520355512408985*^9}, {
   3.520615645686462*^9, 3.520615650472638*^9}, {3.5206156859300623`*^9, 
   3.5206157250273333`*^9}, {3.520683142829864*^9, 3.520683164213763*^9}, 
   3.520879702196971*^9, {3.520879770607444*^9, 3.520879771280161*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"playermessage3", "[", "lang_", "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", "}"}], ",", 
     RowBox[{"Cell", "[", 
      RowBox[{
       RowBox[{"BoxData", "[", 
        RowBox[{"ToBoxes", "[", 
         RowBox[{"Style", "[", 
          RowBox[{
           RowBox[{"Overlay", "[", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"With", "[", 
                RowBox[{
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"w", "=", "800"}], ",", 
                   RowBox[{"h", "=", "47"}]}], "}"}], ",", 
                 RowBox[{"Graphics", "[", 
                  RowBox[{
                   RowBox[{"Raster", "[", 
                    RowBox[{
                    RowBox[{"Reverse", "@", "playerslice"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"0", ",", "0"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"w", ",", "h"}], "}"}]}], "}"}]}], "]"}], ",", 
                   RowBox[{"ImageSize", "\[Rule]", 
                    RowBox[{"{", 
                    RowBox[{"w", ",", "h"}], "}"}]}], ",", 
                   RowBox[{"PlotRangePadding", "\[Rule]", "None"}], ",", 
                   RowBox[{"ImagePadding", "\[Rule]", "None"}]}], "]"}]}], 
                "]"}], ",", 
               RowBox[{"Graphics", "[", 
                RowBox[{
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"Inset", "[", 
                    RowBox[{
                    RowBox[{"Deploy", "[", 
                    RowBox[{"Show", "[", "playerspikey", "]"}], "]"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"25", ",", "23"}], "}"}], ",", 
                    RowBox[{"ContentSelectable", "\[Rule]", "True"}]}], "]"}],
                    ",", "\[IndentingNewLine]", 
                   RowBox[{"Inset", "[", 
                    RowBox[{
                    RowBox[{"Graphics", "[", 
                    RowBox[{"Rasterize", "[", 
                    RowBox[{
                    RowBox[{"Cell", "[", 
                    RowBox[{
                    RowBox[{"CDFLocalized", "[", 
                    RowBox[{"\"\<playermessage3a\>\"", ",", "lang"}], "]"}], 
                    ",", " ", "\"\<Text\>\"", ",", "\n", " ", 
                    RowBox[{"Hyphenation", "->", "False"}], ",", "\n", " ", 
                    RowBox[{"ParagraphSpacing", "->", 
                    RowBox[{"{", 
                    RowBox[{"0.7000000000000001", ",", " ", "0"}], "}"}]}], 
                    ",", "\n", " ", 
                    RowBox[{"StyleMenuListing", "->", "None"}], ",", "\n", 
                    " ", 
                    RowBox[{"FontFamily", "->", "\"\<Verdana\>\""}], ",", 
                    "\n", " ", 
                    RowBox[{"FontSize", "\[Rule]", 
                    RowBox[{"Switch", "[", 
                    RowBox[{
                    "lang", ",", "\"\<English\>\"", ",", "11", ",", 
                    "\"\<Japanese\>\"", ",", " ", "11", ",", 
                    "\"\<ChineseSimplified\>\"", ",", " ", "10", ",", " ", 
                    "_", ",", " ", "11"}], "]"}]}]}], " ", "]"}], ",", " ", 
                    RowBox[{"Background", "\[Rule]", "None"}]}], "]"}], "]"}],
                     ",", 
                    RowBox[{"Switch", "[", 
                    RowBox[{"lang", ",", "\"\<English\>\"", ",", 
                    RowBox[{"{", 
                    RowBox[{"265", ",", "32"}], "}"}], ",", 
                    "\"\<Japanese\>\"", ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"313", ",", "32"}], "}"}], ",", 
                    "\"\<ChineseSimplified\>\"", ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"170", ",", "32"}], "}"}], ",", " ", "_", ",", 
                    " ", 
                    RowBox[{"{", 
                    RowBox[{"265", ",", "32"}], "}"}]}], "]"}], ",", 
                    RowBox[{"ContentSelectable", "\[Rule]", "True"}]}], "]"}],
                    ",", "\[IndentingNewLine]", 
                   RowBox[{"Inset", "[", 
                    RowBox[{
                    RowBox[{"Graphics", "[", 
                    RowBox[{"Rasterize", "[", 
                    RowBox[{
                    RowBox[{"Cell", "[", 
                    RowBox[{
                    RowBox[{"CDFLocalized", "[", 
                    RowBox[{"\"\<playermessage3b\>\"", ",", "lang"}], "]"}], 
                    ",", " ", "\"\<Text\>\"", ",", "\n", " ", 
                    RowBox[{"Hyphenation", "->", "False"}], ",", "\n", " ", 
                    RowBox[{"ParagraphSpacing", "->", 
                    RowBox[{"{", 
                    RowBox[{"0.7000000000000001", ",", " ", "0"}], "}"}]}], 
                    ",", "\n", " ", 
                    RowBox[{"StyleMenuListing", "->", "None"}], ",", "\n", 
                    " ", 
                    RowBox[{"FontFamily", "->", "\"\<Verdana\>\""}], ",", 
                    "\n", " ", 
                    RowBox[{"FontSize", "\[Rule]", 
                    RowBox[{"Switch", "[", 
                    RowBox[{
                    "lang", ",", "\"\<English\>\"", ",", "11", ",", 
                    "\"\<Japanese\>\"", ",", " ", "11", ",", 
                    "\"\<ChineseSimplified\>\"", ",", " ", "10", ",", " ", 
                    "_", ",", " ", "11"}], "]"}]}]}], " ", "]"}], ",", 
                    RowBox[{"Background", "\[Rule]", "None"}]}], "]"}], "]"}],
                     ",", 
                    RowBox[{"Switch", "[", 
                    RowBox[{"lang", ",", "\"\<English\>\"", ",", 
                    RowBox[{"{", 
                    RowBox[{"262", ",", "17"}], "}"}], ",", 
                    "\"\<Japanese\>\"", ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"244", ",", "17"}], "}"}], ",", 
                    "\"\<ChineseSimplified\>\"", ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"186", ",", "17"}], "}"}], ",", " ", "_", ",", 
                    " ", 
                    RowBox[{"{", 
                    RowBox[{"262", ",", "17"}], "}"}]}], "]"}], ",", 
                    RowBox[{"ContentSelectable", "\[Rule]", "True"}]}], 
                    "]"}]}], "}"}], ",", 
                 RowBox[{"ContentSelectable", "\[Rule]", "True"}], ",", 
                 RowBox[{"PlotRange", "->", 
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{"{", 
                    RowBox[{"0", ",", "800"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"0", ",", "47"}], "}"}]}], "}"}]}], ",", 
                 RowBox[{"ImageSize", "\[Rule]", 
                  RowBox[{"{", 
                   RowBox[{"800", ",", "47"}], "}"}]}]}], "]"}]}], "}"}], ",",
              "All", ",", "2"}], "]"}], ",", 
           RowBox[{"ShowSelection", "\[Rule]", "False"}]}], "]"}], "]"}], 
        "]"}], ",", 
       RowBox[{"Deployed", "\[Rule]", "True"}], ",", 
       RowBox[{"ShowCellBracket", "\[Rule]", "False"}]}], " ", "]"}]}], 
    "]"}]}], ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.517846805236952*^9, 3.517846990515308*^9}, {
   3.5178547229240294`*^9, 3.517854842026141*^9}, {3.517856431821372*^9, 
   3.517856433497463*^9}, {3.517856617016345*^9, 3.517856629738902*^9}, {
   3.5179291919650517`*^9, 3.517929208796218*^9}, {3.5194795830565147`*^9, 
   3.519479628574642*^9}, {3.519496525004799*^9, 3.519496525428673*^9}, {
   3.5203555304793253`*^9, 3.5203555802493143`*^9}, {3.520355611166176*^9, 
   3.52035562796817*^9}, {3.520355794195372*^9, 3.520355803751828*^9}, {
   3.520355858653207*^9, 3.520355885567045*^9}, {3.520615756927127*^9, 
   3.520615769853269*^9}, {3.520615803455954*^9, 3.5206159035474577`*^9}, {
   3.5206826441685343`*^9, 3.520682657024191*^9}, {3.520682722676731*^9, 
   3.520682727845387*^9}, {3.520682913853097*^9, 3.520682986167741*^9}, {
   3.520683046462716*^9, 3.520683089414648*^9}, {3.520878458790694*^9, 
   3.520878502791996*^9}, {3.5208786633265457`*^9, 3.520878667894108*^9}, {
   3.520878701478402*^9, 3.520878706132986*^9}, {3.52087877657495*^9, 
   3.52087877955581*^9}, 3.5208791822833977`*^9, {3.520879312101252*^9, 
   3.520879324869493*^9}, {3.520879359839518*^9, 3.5208793615984983`*^9}, {
   3.520879462001442*^9, 3.520879558127934*^9}, {3.5208797481811533`*^9, 
   3.520879748509042*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"TaggingRulesAdd", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
     "PlayerMessage_", ",", " ", "PluginPlayerMessage_", ",", " ", 
      "PluginMathematicaMessage_", ",", " ", "MathematicaMessage_"}], "}"}], 
    ",", "lang_"}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", "}"}], ",", 
    RowBox[{"Pick", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"\"\<PlayerMessage\>\"", "\[Rule]", 
         RowBox[{"playermessage1", "[", "lang", "]"}]}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"\"\<PluginPlayerMessage\>\"", "\[Rule]", 
         RowBox[{"playermessage2", "[", "lang", "]"}]}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"\"\<PluginMathematicaMessage\>\"", "\[Rule]", 
         RowBox[{"playermessage3", "[", "lang", "]"}]}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"\"\<MathematicaMessage\>\"", "\[Rule]", "\"\<\>\""}]}], 
       "\[IndentingNewLine]", "}"}], ",", " ", 
      RowBox[{"{", 
       RowBox[{
       "PlayerMessage", ",", " ", "PluginPlayerMessage", ",", " ", 
        "PluginMathematicaMessage", ",", " ", "MathematicaMessage"}], "}"}]}],
      "]"}]}], "]"}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.5172493319997053`*^9, 3.517249442144075*^9}, {
   3.517249608620471*^9, 3.517249619403306*^9}, {3.517249694952136*^9, 
   3.517249741684616*^9}, 3.5172497767944927`*^9, {3.517250644102022*^9, 
   3.517250668247548*^9}, 3.5172507445254393`*^9, {3.517327659905072*^9, 
   3.517327662119256*^9}, {3.517328429294326*^9, 3.517328430586442*^9}, {
   3.517328555736017*^9, 3.51732855839052*^9}, {3.5175871222235813`*^9, 
   3.517587141751534*^9}, {3.517847019867594*^9, 3.517847036907639*^9}, {
   3.520356173319292*^9, 3.5203561862751417`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"TaggingRulesAddTest", "=", 
   RowBox[{"TaggingRulesAdd", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"True", ",", " ", "True", ",", " ", "True", ",", " ", "False"}],
       "}"}], ",", " ", "\"\<English\>\""}], "]"}]}], ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.5172498039839287`*^9, 3.5172498128547277`*^9}, {
  3.5179223859494667`*^9, 3.517922417031955*^9}, {3.520356222729829*^9, 
  3.520356226344069*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["BannerMessagesQ", "Section",
 InitializationCell->True,
 CellChangeTimes->{{3.5176828129076223`*^9, 3.517682827745676*^9}, {
  3.517682928497231*^9, 3.517682929857049*^9}, {3.517921377333816*^9, 
  3.51792144181723*^9}, {3.517922304023615*^9, 3.517922322551421*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"BannerMessageQ", "[", "nbexpr_", "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", "doesntwork", "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"doesntwork", "=", 
       RowBox[{"{", 
        RowBox[{
        "\"\<BinaryRead\>\"", ",", "\"\<BinaryReadList\>\"", ",", 
         "\"\<BinaryWrite\>\"", ",", "\"\<ColorSetter\>\"", ",", 
         "\"\<CopyDirectory\>\"", ",", "\"\<CreateDialog\>\"", ",", 
         "\"\<CreateArchive\>\"", ",", " ", "\"\<CreateDirectory\>\"", ",", 
         "\"\<CreateIntermediateDirectories\>\"", ",", 
         "\"\<CreateDocument\>\"", ",", " ", "\"\<CreatePalette\>\"", ",", 
         "\"\<CreateWindow\>\"", ",", "\"\<DeleteDirectory\>\"", ",", " ", 
         "\"\<DumpGet\>\"", ",", "\"\<DumpSave\>\"", ",", " ", 
         "\"\<Export\>\"", ",", "\"\<ExportPacket\>\"", ",", 
         "\"\<ExportString\>\"", ",", "\"\<FileByteCount\>\"", ",", " ", 
         "\"\<FileDate\>\"", ",", " ", "\"\<FileExistsQ\>\"", ",", 
         "\"\<FileFormat\>\"", ",", "\"\<FileHash\>\"", ",", " ", 
         "\"\<FileInformation\>\"", ",", "\"\<FileNames\>\"", ",", 
         "\"\<FileNameSetter\>\"", ",", "\"\<FilePrint\>\"", ",", 
         "\"\<FileType\>\"", ",", " ", "\"\<FindFile\>\"", ",", " ", 
         "\"\<Get\>\"", ",", "\"\<HTMLSave\>\"", ",", "\"\<Import\>\"", ",", 
         "\"\<InputString\>\"", ",", "\"\<Install\>\"", ",", 
         "\"\<LinkLaunch\>\"", ",", "\"\<LinkActivate\>\"", ",", 
         "\"\<LinkClose\>\"", ",", "\"\<LinkConnect\>\"", ",", 
         "\"\<LinkConnectedQ\>\"", ",", "\"\<LinkCreate\>\"", ",", 
         "\"\<LinkError\>\"", ",", "\"\<LinkFlush\>\"", ",", 
         "\"\<LinkFunction\>\"", ",", "\"\<LinkHost\>\"", ",", 
         "\"\<LinkInterrupt\>\"", ",", "\"\<LinkLaunch\>\"", ",", 
         "\"\<LinkMode\>\"", ",", "\"\<LinkObject\>\"", ",", 
         "\"\<LinkOpen\>\"", ",", "\"\<LinkOptions\>\"", ",", 
         "\"\<LinkPatterns\>\"", ",", "\"\<LinkProtocol\>\"", ",", 
         "\"\<LinkRead\>\"", ",", "\"\<LinkReadHeld\>\"", ",", 
         "\"\<LinkReadyQ\>\"", ",", "\"\<Links\>\"", ",", "\"\<LinkWrite\>\"",
          ",", "\"\<LinkWriteHeld\>\"", ",", "\"\<NotebookClose\>\"", ",", 
         "\"\<NotebookCreate\>\"", ",", "\"\<NotebookCreateReturnObject\>\"", 
         ",", "\"\<NotebookDirectory\>\"", ",", "\"\<NotebookEvaluate\>\"", 
         ",", "\"\<NotebookFileName\>\"", ",", "\"\<NotebookInformation\>\"", 
         ",", "\"\<NotebookObject\>\"", ",", "\"\<NotebookOpen\>\"", ",", 
         "\"\<NotebookPrint\>\"", ",", "\"\<NotebookPut\>\"", ",", " ", 
         "\"\<NotebookSave\>\"", ",", "\"\<OpenAppend\>\"", ",", 
         "\"\<OpenRead\>\"", ",", "\"\<OpenWrite\>\"", ",", 
         "\"\<ParallelArray\>\"", ",", "\"\<ParallelCombine\>\"", ",", 
         "\"\<ParallelDo\>\"", ",", "\"\<ParallelEvaluate\>\"", ",", 
         "\"\<Parallelization\>\"", ",", "\"\<Parallelize\>\"", ",", 
         "\"\<ParallelMap\>\"", ",", "\"\<ParallelNeeds\>\"", ",", 
         "\"\<ParallelProduct\>\"", ",", "\"\<ParallelSubmit\>\"", ",", 
         "\"\<ParallelSum\>\"", ",", "\"\<ParallelTable\>\"", ",", 
         "\"\<ParallelTry\>\"", ",", "\"\<ParentDirectory\>\"", ",", 
         "\"\<PopupWindow\>\"", ",", "\"\<Put\>\"", ",", "\"\<PutAppend\>\"", 
         ",", "\"\<Read\>\"", ",", "\"\<ReadList\>\"", ",", 
         "\"\<RenameDirectory\>\"", ",", "\"\<RenameFile\>\"", ",", 
         "\"\<Run\>\"", ",", "\"\<RunThrough\>\"", ",", "\"\<Save\>\"", ",", 
         "\"\<SetFileDate\>\"", ",", "\"\<SystemOpen\>\"", ",", 
         "\"\<Splice\>\"", ",", "\"\<TeXSave\>\"", ",", "\"\<Uninstall\>\"", 
         ",", "\"\<V2Get\>\"", ",", "\"\<Write\>\"", ",", 
         "\"\<$DefaultImagingDevice\>\"", ",", "\"\<$ImagingDevices\>\"", 
         ",", "\"\<$LibraryPath\>\"", ",", " ", 
         "\"\<\\\"\\<CUDALink`\\>\\\"\>\"", ",", 
         "\"\<\\\"\\<CCodeGenerator`\\>\\\"\>\"", ",", 
         "\"\<\\\"\\<CCompilerDriver`\\>\\\"\>\"", ",", " ", 
         "\"\<\\\"\\<CompiledFunctionTools`\\>\\\"\>\"", ",", 
         "\"\<\\\"\\<DatabaseLink`\\>\\\"\>\"", ",", " ", 
         "\"\<\\\"\\<DifferentialEquations`NDSolveProblems`\\>\\\"\>\"", ",", 
         "\"\<\\\"\\<DifferentialEquations`NDSolveUtilities`\\>\\\"\>\"", ",",
          " ", "\"\<\\\"\\<GUIKit`\\>\\\"\>\"", ",", " ", 
         "\"\<\\\"\\<LibraryLink`\\>\\\"\>\"", ",", 
         "\"\<\\\"\\<LightweightGridClient`\\>\\\"\>\"", ",", 
         "\"\<\\\"\\<NETLink`\\>\\\"\>\"", ",", 
         "\"\<\\\"\\<OpenCLLink`\\>\\\"\>\"", ",", 
         "\"\<\\\"\\<SymbolicC`\\>\\\"\>\"", ",", 
         "\"\<\\\"\\<TetGenLink`\\>\\\"\>\"", ",", " ", 
         "\"\<WebServices`\>\""}], "}"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Count", "[", 
          RowBox[{
           RowBox[{"Union", "[", 
            RowBox[{"Map", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"FreeQ", "[", 
                RowBox[{"#", ",", 
                 RowBox[{"Alternatives", "@@", "doesntwork"}]}], "]"}], "&"}],
               ",", 
              RowBox[{"Cases", "[", 
               RowBox[{"nbexpr", ",", " ", 
                RowBox[{"Cell", "[", 
                 RowBox[{"___", ",", "\"\<Input\>\"", " ", ",", "___"}], 
                 "]"}], ",", " ", "Infinity"}], "]"}]}], "]"}], "]"}], ",", 
           " ", "False"}], "]"}], ">", "0"}], ",", " ", "True", ",", " ", 
        "False"}], "]"}]}]}], "]"}]}], ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.5176828892759027`*^9, 3.517682971914865*^9}, {
   3.517683005382557*^9, 3.517683020492395*^9}, {3.517764279606346*^9, 
   3.5177643271122713`*^9}, {3.517764424408478*^9, 3.5177644262876253`*^9}, {
   3.5177646369044313`*^9, 3.5177646396138477`*^9}, {3.517764673337983*^9, 
   3.517764676584434*^9}, {3.517764816034531*^9, 3.517764839990766*^9}, {
   3.51776509393023*^9, 3.5177650960755796`*^9}, {3.517765173275227*^9, 
   3.51776517432274*^9}, {3.517765345790563*^9, 3.51776535826368*^9}, {
   3.5177653934197893`*^9, 3.5177653959050083`*^9}, {3.517765806304199*^9, 
   3.5177658077963667`*^9}, {3.5177658441221037`*^9, 3.517765869871521*^9}, {
   3.517765941505719*^9, 3.517765942421485*^9}, {3.517765985477353*^9, 
   3.5177659859349823`*^9}, {3.517766065213086*^9, 3.517766069915421*^9}, {
   3.517766100074122*^9, 3.51776612006528*^9}, {3.517766356995083*^9, 
   3.51776635742655*^9}, {3.517766424757957*^9, 3.517766440761641*^9}, {
   3.517766512230356*^9, 3.517766532880535*^9}, {3.517766596585949*^9, 
   3.51776663859832*^9}, {3.517771074011742*^9, 3.517771075377961*^9}, 
   3.519496543272099*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell["Add Banner Messages to Special Cells", "Section",
 InitializationCell->True,
 CellChangeTimes->{{3.517249303427477*^9, 3.517249316562405*^9}, {
   3.517921354019293*^9, 3.517921355883257*^9}, {3.517921530985145*^9, 
   3.517921551577141*^9}, 3.517922342923003*^9, {3.517922525791607*^9, 
   3.517922543974863*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"additionalMessageCell", "[", 
    RowBox[{"Cell", "[", 
     RowBox[{"a___", ",", "\"\<ObjectNameGrid\>\"", ",", "b___"}], "]"}], 
    "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", "}"}], ",", 
     RowBox[{"Cell", "[", 
      RowBox[{"CellGroupData", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Cell", "[", 
           RowBox[{"a", ",", "\"\<ObjectNameGrid\>\"", ",", "b", ",", 
            RowBox[{"CellGroupingRules", "\[Rule]", 
             RowBox[{"{", 
              RowBox[{"\"\<GroupTogetherGrouping\>\"", ",", "10000."}], 
              "}"}]}]}], "]"}], ",", 
          RowBox[{"Cell", "[", 
           RowBox[{
            RowBox[{"BoxData", "[", 
             RowBox[{"DynamicBox", "[", 
              RowBox[{
               RowBox[{"FrontEnd`CurrentValue", "[", 
                RowBox[{
                 RowBox[{"FrontEnd`EvaluationNotebook", "[", "]"}], ",", 
                 RowBox[{"FEPrivate`If", "[", 
                  RowBox[{
                   RowBox[{"FEPrivate`SameQ", "[", 
                    RowBox[{
                    RowBox[{
                    "FrontEnd`CurrentValue", "[", "\"\<PluginEnabled\>\"", 
                    "]"}], ",", "True"}], "]"}], ",", 
                   RowBox[{"FEPrivate`If", "[", 
                    RowBox[{
                    RowBox[{"FEPrivate`MemberQ", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "\"\<Player\>\"", ",", "\"\<Player Pro\>\"", ",", 
                    "\"\<Unauthorized PlayerPro\>\""}], "}"}], ",", 
                    "FrontEnd`$NotebookLicenseType"}], "]"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    "TaggingRules", ",", "\"\<PluginPlayerMessage\>\""}], 
                    "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    "TaggingRules", ",", "\"\<PluginMathematicaMessage\>\""}],
                     "}"}]}], "]"}], ",", 
                   RowBox[{"FEPrivate`If", "[", 
                    RowBox[{
                    RowBox[{"FEPrivate`MemberQ", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "\"\<Player\>\"", ",", "\"\<Player Pro\>\"", ",", 
                    "\"\<Unauthorized PlayerPro\>\""}], "}"}], ",", 
                    "FrontEnd`$NotebookLicenseType"}], "]"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"TaggingRules", ",", "\"\<PlayerMessage\>\""}], 
                    "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    "TaggingRules", ",", "\"\<MathematicaMessage\>\""}], 
                    "}"}]}], "]"}]}], "]"}], ",", "\"\<\>\""}], "]"}], ",", 
               RowBox[{"ImageSizeCache", "\[Rule]", 
                RowBox[{"{", 
                 RowBox[{"4.", ",", 
                  RowBox[{"{", 
                   RowBox[{"0.", ",", "0."}], "}"}]}], "}"}]}]}], "]"}], 
             "]"}], ",", "\"\<Text\>\"", ",", 
            RowBox[{"Editable", "->", "False"}], ",", "\n", " ", 
            RowBox[{"ShowCellBracket", "\[Rule]", "False"}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"PageWidth", "\[Rule]", "775"}], ",", "\n", " ", 
            RowBox[{"CellMargins", "->", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{"72", ",", " ", "0"}], "}"}], ",", " ", 
               RowBox[{"{", 
                RowBox[{"6", ",", " ", "3"}], "}"}]}], "}"}]}], " ", ",", 
            RowBox[{"CellGroupingRules", "\[Rule]", 
             RowBox[{"{", 
              RowBox[{"\"\<GroupTogetherGrouping\>\"", ",", "10000."}], 
              "}"}]}], ",", 
            RowBox[{"AllowGroupClose", "\[Rule]", "False"}], ",", " ", 
            RowBox[{"AllowReverseGroupClose", "\[Rule]", "False"}], ",", 
            RowBox[{"ShowCellBracket", "\[Rule]", "False"}]}], "]"}]}], "}"}],
         ",", 
        RowBox[{"Dynamic", "[", 
         RowBox[{
          RowBox[{"FEPrivate`If", "[", 
           RowBox[{
            RowBox[{"FEPrivate`Not", "[", 
             RowBox[{"FEPrivate`MemberQ", "[", 
              RowBox[{
               RowBox[{"{", "\"\<\>\"", "}"}], ",", 
               RowBox[{"FrontEnd`CurrentValue", "[", 
                RowBox[{
                 RowBox[{"FrontEnd`EvaluationNotebook", "[", "]"}], ",", 
                 RowBox[{"FEPrivate`If", "[", 
                  RowBox[{
                   RowBox[{"FEPrivate`SameQ", "[", 
                    RowBox[{
                    RowBox[{
                    "FrontEnd`CurrentValue", "[", "\"\<PluginEnabled\>\"", 
                    "]"}], ",", "True"}], "]"}], ",", 
                   RowBox[{"FEPrivate`If", "[", 
                    RowBox[{
                    RowBox[{"FEPrivate`MemberQ", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "\"\<Player\>\"", ",", "\"\<Player Pro\>\"", ",", 
                    "\"\<Unauthorized PlayerPro\>\""}], "}"}], ",", 
                    "FrontEnd`$NotebookLicenseType"}], "]"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    "TaggingRules", ",", "\"\<PluginPlayerMessage\>\""}], 
                    "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    "TaggingRules", ",", "\"\<PluginMathematicaMessage\>\""}],
                     "}"}]}], "]"}], ",", 
                   RowBox[{"FEPrivate`If", "[", 
                    RowBox[{
                    RowBox[{"FEPrivate`MemberQ", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "\"\<Player\>\"", ",", "\"\<Player Pro\>\"", ",", 
                    "\"\<Unauthorized PlayerPro\>\""}], "}"}], ",", 
                    "FrontEnd`$NotebookLicenseType"}], "]"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"TaggingRules", ",", "\"\<PlayerMessage\>\""}], 
                    "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    "TaggingRules", ",", "\"\<MathematicaMessage\>\""}], 
                    "}"}]}], "]"}]}], "]"}]}], "]"}]}], "]"}], "]"}], ",", 
            "Open", ",", " ", "Closed"}], "]"}], ",", "\"\<\>\""}], "]"}]}], 
       "]"}], "]"}]}], "]"}]}], ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.517592809858536*^9, 3.517592885311414*^9}, 
   3.5175929313871927`*^9, {3.517592972144199*^9, 3.517593016169677*^9}, {
   3.517683761119445*^9, 3.517683770880046*^9}, {3.5178481477230797`*^9, 
   3.517848229525708*^9}, {3.5178484821469*^9, 3.517848499941824*^9}, 
   3.5179224268574343`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"additionalMessageCell", "[", 
    RowBox[{"Cell", "[", 
     RowBox[{"a___", ",", "\"\<ObjectName\>\"", ",", "b___"}], "]"}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", "}"}], ",", 
     RowBox[{"Cell", "[", 
      RowBox[{"CellGroupData", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Cell", "[", 
           RowBox[{"a", ",", "\"\<ObjectName\>\"", ",", "b", ",", 
            RowBox[{"CellGroupingRules", "\[Rule]", 
             RowBox[{"{", 
              RowBox[{"\"\<GroupTogetherGrouping\>\"", ",", "10000."}], 
              "}"}]}]}], "]"}], ",", 
          RowBox[{"Cell", "[", 
           RowBox[{
            RowBox[{"BoxData", "[", 
             RowBox[{"DynamicBox", "[", 
              RowBox[{
               RowBox[{"FrontEnd`CurrentValue", "[", 
                RowBox[{
                 RowBox[{"FrontEnd`EvaluationNotebook", "[", "]"}], ",", 
                 RowBox[{"FEPrivate`If", "[", 
                  RowBox[{
                   RowBox[{"FEPrivate`SameQ", "[", 
                    RowBox[{
                    RowBox[{
                    "FrontEnd`CurrentValue", "[", "\"\<PluginEnabled\>\"", 
                    "]"}], ",", "True"}], "]"}], ",", 
                   RowBox[{"FEPrivate`If", "[", 
                    RowBox[{
                    RowBox[{"FEPrivate`MemberQ", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "\"\<Player\>\"", ",", "\"\<Player Pro\>\"", ",", 
                    "\"\<Unauthorized PlayerPro\>\""}], "}"}], ",", 
                    "FrontEnd`$NotebookLicenseType"}], "]"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    "TaggingRules", ",", "\"\<PluginPlayerMessage\>\""}], 
                    "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    "TaggingRules", ",", "\"\<PluginMathematicaMessage\>\""}],
                     "}"}]}], "]"}], ",", 
                   RowBox[{"FEPrivate`If", "[", 
                    RowBox[{
                    RowBox[{"FEPrivate`MemberQ", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "\"\<Player\>\"", ",", "\"\<Player Pro\>\"", ",", 
                    "\"\<Unauthorized PlayerPro\>\""}], "}"}], ",", 
                    "FrontEnd`$NotebookLicenseType"}], "]"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"TaggingRules", ",", "\"\<PlayerMessage\>\""}], 
                    "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    "TaggingRules", ",", "\"\<MathematicaMessage\>\""}], 
                    "}"}]}], "]"}]}], "]"}], ",", "\"\<\>\""}], "]"}], ",", 
               RowBox[{"ImageSizeCache", "\[Rule]", 
                RowBox[{"{", 
                 RowBox[{"4.", ",", 
                  RowBox[{"{", 
                   RowBox[{"0.", ",", "0."}], "}"}]}], "}"}]}]}], "]"}], 
             "]"}], ",", "\"\<Text\>\"", ",", 
            RowBox[{"Editable", "->", "False"}], ",", "\n", " ", 
            RowBox[{"ShowCellBracket", "\[Rule]", "False"}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"PageWidth", "\[Rule]", "775"}], ",", "\n", " ", 
            RowBox[{"CellMargins", "->", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{"72", ",", " ", "0"}], "}"}], ",", " ", 
               RowBox[{"{", 
                RowBox[{"6", ",", " ", "3"}], "}"}]}], "}"}]}], ",", "\n", 
            RowBox[{"CellGroupingRules", "\[Rule]", 
             RowBox[{"{", 
              RowBox[{"\"\<GroupTogetherGrouping\>\"", ",", "10000."}], 
              "}"}]}], ",", 
            RowBox[{"AllowGroupClose", "\[Rule]", "False"}], ",", " ", 
            RowBox[{"AllowReverseGroupClose", "\[Rule]", "False"}], ",", 
            RowBox[{"ShowCellBracket", "\[Rule]", "False"}]}], "]"}]}], "}"}],
         ",", 
        RowBox[{"Dynamic", "[", 
         RowBox[{
          RowBox[{"FEPrivate`If", "[", 
           RowBox[{
            RowBox[{"FEPrivate`Not", "[", 
             RowBox[{"FEPrivate`MemberQ", "[", 
              RowBox[{
               RowBox[{"{", "\"\<\>\"", "}"}], ",", 
               RowBox[{"FrontEnd`CurrentValue", "[", 
                RowBox[{
                 RowBox[{"FrontEnd`EvaluationNotebook", "[", "]"}], ",", 
                 RowBox[{"FEPrivate`If", "[", 
                  RowBox[{
                   RowBox[{"FEPrivate`SameQ", "[", 
                    RowBox[{
                    RowBox[{
                    "FrontEnd`CurrentValue", "[", "\"\<PluginEnabled\>\"", 
                    "]"}], ",", "True"}], "]"}], ",", 
                   RowBox[{"FEPrivate`If", "[", 
                    RowBox[{
                    RowBox[{"FEPrivate`MemberQ", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "\"\<Player\>\"", ",", "\"\<Player Pro\>\"", ",", 
                    "\"\<Unauthorized PlayerPro\>\""}], "}"}], ",", 
                    "FrontEnd`$NotebookLicenseType"}], "]"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    "TaggingRules", ",", "\"\<PluginPlayerMessage\>\""}], 
                    "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    "TaggingRules", ",", "\"\<PluginMathematicaMessage\>\""}],
                     "}"}]}], "]"}], ",", 
                   RowBox[{"FEPrivate`If", "[", 
                    RowBox[{
                    RowBox[{"FEPrivate`MemberQ", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "\"\<Player\>\"", ",", "\"\<Player Pro\>\"", ",", 
                    "\"\<Unauthorized PlayerPro\>\""}], "}"}], ",", 
                    "FrontEnd`$NotebookLicenseType"}], "]"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"TaggingRules", ",", "\"\<PlayerMessage\>\""}], 
                    "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    "TaggingRules", ",", "\"\<MathematicaMessage\>\""}], 
                    "}"}]}], "]"}]}], "]"}]}], "]"}]}], "]"}], "]"}], ",", 
            "Open", ",", " ", "Closed"}], "]"}], ",", "\"\<\>\""}], "]"}]}], 
       "]"}], "]"}]}], "]"}]}], ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.517592809858536*^9, 3.517592885311414*^9}, 
   3.5175929313871927`*^9, {3.517592972144199*^9, 3.517593016169677*^9}, {
   3.517683761119445*^9, 3.517683770880046*^9}, {3.5178481477230797`*^9, 
   3.517848229525708*^9}, {3.5178484821469*^9, 3.517848499941824*^9}, {
   3.5179224268574343`*^9, 3.517922432368896*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"additionalMessageCell", "[", 
    RowBox[{"Cell", "[", 
     RowBox[{"a___", ",", "\"\<Title\>\"", ",", "b___"}], "]"}], "]"}], ":=", 
   
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", "}"}], ",", 
     RowBox[{"Cell", "[", 
      RowBox[{"CellGroupData", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Cell", "[", 
           RowBox[{"a", ",", "\"\<Title\>\"", ",", "b", ",", 
            RowBox[{"CellGroupingRules", "\[Rule]", 
             RowBox[{"{", 
              RowBox[{"\"\<GroupTogetherGrouping\>\"", ",", "10000."}], 
              "}"}]}]}], "]"}], ",", 
          RowBox[{"Cell", "[", 
           RowBox[{
            RowBox[{"BoxData", "[", 
             RowBox[{"DynamicBox", "[", 
              RowBox[{
               RowBox[{"FrontEnd`CurrentValue", "[", 
                RowBox[{
                 RowBox[{"FrontEnd`EvaluationNotebook", "[", "]"}], ",", 
                 RowBox[{"FEPrivate`If", "[", 
                  RowBox[{
                   RowBox[{"FEPrivate`SameQ", "[", 
                    RowBox[{
                    RowBox[{
                    "FrontEnd`CurrentValue", "[", "\"\<PluginEnabled\>\"", 
                    "]"}], ",", "True"}], "]"}], ",", 
                   RowBox[{"FEPrivate`If", "[", 
                    RowBox[{
                    RowBox[{"FEPrivate`MemberQ", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "\"\<Player\>\"", ",", "\"\<Player Pro\>\"", ",", 
                    "\"\<Unauthorized PlayerPro\>\""}], "}"}], ",", 
                    "FrontEnd`$NotebookLicenseType"}], "]"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    "TaggingRules", ",", "\"\<PluginPlayerMessage\>\""}], 
                    "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    "TaggingRules", ",", "\"\<PluginMathematicaMessage\>\""}],
                     "}"}]}], "]"}], ",", 
                   RowBox[{"FEPrivate`If", "[", 
                    RowBox[{
                    RowBox[{"FEPrivate`MemberQ", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "\"\<Player\>\"", ",", "\"\<Player Pro\>\"", ",", 
                    "\"\<Unauthorized PlayerPro\>\""}], "}"}], ",", 
                    "FrontEnd`$NotebookLicenseType"}], "]"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"TaggingRules", ",", "\"\<PlayerMessage\>\""}], 
                    "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    "TaggingRules", ",", "\"\<MathematicaMessage\>\""}], 
                    "}"}]}], "]"}]}], "]"}], ",", "\"\<\>\""}], "]"}], ",", 
               RowBox[{"ImageSizeCache", "\[Rule]", 
                RowBox[{"{", 
                 RowBox[{"4.", ",", 
                  RowBox[{"{", 
                   RowBox[{"0.", ",", "0."}], "}"}]}], "}"}]}]}], "]"}], 
             "]"}], ",", "\"\<Text\>\"", ",", 
            RowBox[{"Editable", "->", "False"}], ",", "\n", " ", 
            RowBox[{"ShowCellBracket", "\[Rule]", "False"}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"PageWidth", "\[Rule]", "775"}], ",", "\n", " ", 
            RowBox[{"CellMargins", "->", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{"72", ",", " ", "0"}], "}"}], ",", " ", 
               RowBox[{"{", 
                RowBox[{"6", ",", " ", "3"}], "}"}]}], "}"}]}], " ", ",", 
            RowBox[{"CellGroupingRules", "\[Rule]", 
             RowBox[{"{", 
              RowBox[{"\"\<GroupTogetherGrouping\>\"", ",", "10000."}], 
              "}"}]}], ",", 
            RowBox[{"AllowGroupClose", "\[Rule]", "False"}], ",", " ", 
            RowBox[{"AllowReverseGroupClose", "\[Rule]", "False"}], ",", 
            RowBox[{"ShowCellBracket", "\[Rule]", "False"}]}], "]"}]}], "}"}],
         ",", 
        RowBox[{"Dynamic", "[", 
         RowBox[{
          RowBox[{"FEPrivate`If", "[", 
           RowBox[{
            RowBox[{"FEPrivate`Not", "[", 
             RowBox[{"FEPrivate`MemberQ", "[", 
              RowBox[{
               RowBox[{"{", "\"\<\>\"", "}"}], ",", 
               RowBox[{"FrontEnd`CurrentValue", "[", 
                RowBox[{
                 RowBox[{"FrontEnd`EvaluationNotebook", "[", "]"}], ",", 
                 RowBox[{"FEPrivate`If", "[", 
                  RowBox[{
                   RowBox[{"FEPrivate`SameQ", "[", 
                    RowBox[{
                    RowBox[{
                    "FrontEnd`CurrentValue", "[", "\"\<PluginEnabled\>\"", 
                    "]"}], ",", "True"}], "]"}], ",", 
                   RowBox[{"FEPrivate`If", "[", 
                    RowBox[{
                    RowBox[{"FEPrivate`MemberQ", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "\"\<Player\>\"", ",", "\"\<Player Pro\>\"", ",", 
                    "\"\<Unauthorized PlayerPro\>\""}], "}"}], ",", 
                    "FrontEnd`$NotebookLicenseType"}], "]"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    "TaggingRules", ",", "\"\<PluginPlayerMessage\>\""}], 
                    "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    "TaggingRules", ",", "\"\<PluginMathematicaMessage\>\""}],
                     "}"}]}], "]"}], ",", 
                   RowBox[{"FEPrivate`If", "[", 
                    RowBox[{
                    RowBox[{"FEPrivate`MemberQ", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "\"\<Player\>\"", ",", "\"\<Player Pro\>\"", ",", 
                    "\"\<Unauthorized PlayerPro\>\""}], "}"}], ",", 
                    "FrontEnd`$NotebookLicenseType"}], "]"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"TaggingRules", ",", "\"\<PlayerMessage\>\""}], 
                    "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    "TaggingRules", ",", "\"\<MathematicaMessage\>\""}], 
                    "}"}]}], "]"}]}], "]"}]}], "]"}]}], "]"}], "]"}], ",", 
            "Open", ",", " ", "Closed"}], "]"}], ",", "\"\<\>\""}], "]"}]}], 
       "]"}], "]"}]}], "]"}]}], ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.517592809858536*^9, 3.517592885311414*^9}, 
   3.5175929313871927`*^9, {3.517592972144199*^9, 3.517593016169677*^9}, {
   3.517683761119445*^9, 3.517683770880046*^9}, {3.5178481477230797`*^9, 
   3.517848229525708*^9}, {3.5178484821469*^9, 3.517848499941824*^9}, {
   3.5179224268574343`*^9, 3.517922432368896*^9}, 3.519496554881227*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"additionalMessageCell", "[", 
    RowBox[{"Cell", "[", 
     RowBox[{"a___", ",", "\"\<HowToTitle\>\"", ",", "b___"}], "]"}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", "}"}], ",", 
     RowBox[{"Cell", "[", 
      RowBox[{"CellGroupData", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Cell", "[", 
           RowBox[{"a", ",", "\"\<HowToTitle\>\"", ",", "b", ",", 
            RowBox[{"CellGroupingRules", "\[Rule]", 
             RowBox[{"{", 
              RowBox[{"\"\<GroupTogetherGrouping\>\"", ",", "10000."}], 
              "}"}]}]}], "]"}], ",", 
          RowBox[{"Cell", "[", 
           RowBox[{
            RowBox[{"BoxData", "[", 
             RowBox[{"DynamicBox", "[", 
              RowBox[{
               RowBox[{"FrontEnd`CurrentValue", "[", 
                RowBox[{
                 RowBox[{"FrontEnd`EvaluationNotebook", "[", "]"}], ",", 
                 RowBox[{"FEPrivate`If", "[", 
                  RowBox[{
                   RowBox[{"FEPrivate`SameQ", "[", 
                    RowBox[{
                    RowBox[{
                    "FrontEnd`CurrentValue", "[", "\"\<PluginEnabled\>\"", 
                    "]"}], ",", "True"}], "]"}], ",", 
                   RowBox[{"FEPrivate`If", "[", 
                    RowBox[{
                    RowBox[{"FEPrivate`MemberQ", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "\"\<Player\>\"", ",", "\"\<Player Pro\>\"", ",", 
                    "\"\<Unauthorized PlayerPro\>\""}], "}"}], ",", 
                    "FrontEnd`$NotebookLicenseType"}], "]"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    "TaggingRules", ",", "\"\<PluginPlayerMessage\>\""}], 
                    "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    "TaggingRules", ",", "\"\<PluginMathematicaMessage\>\""}],
                     "}"}]}], "]"}], ",", 
                   RowBox[{"FEPrivate`If", "[", 
                    RowBox[{
                    RowBox[{"FEPrivate`MemberQ", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "\"\<Player\>\"", ",", "\"\<Player Pro\>\"", ",", 
                    "\"\<Unauthorized PlayerPro\>\""}], "}"}], ",", 
                    "FrontEnd`$NotebookLicenseType"}], "]"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"TaggingRules", ",", "\"\<PlayerMessage\>\""}], 
                    "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    "TaggingRules", ",", "\"\<MathematicaMessage\>\""}], 
                    "}"}]}], "]"}]}], "]"}], ",", "\"\<\>\""}], "]"}], ",", 
               RowBox[{"ImageSizeCache", "\[Rule]", 
                RowBox[{"{", 
                 RowBox[{"4.", ",", 
                  RowBox[{"{", 
                   RowBox[{"0.", ",", "0."}], "}"}]}], "}"}]}]}], "]"}], 
             "]"}], ",", "\"\<Text\>\"", ",", 
            RowBox[{"Editable", "->", "False"}], ",", "\n", " ", 
            RowBox[{"ShowCellBracket", "\[Rule]", "False"}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"PageWidth", "\[Rule]", "775"}], ",", "\n", " ", 
            RowBox[{"CellMargins", "->", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{"72", ",", " ", "0"}], "}"}], ",", " ", 
               RowBox[{"{", 
                RowBox[{"6", ",", " ", "3"}], "}"}]}], "}"}]}], " ", ",", 
            RowBox[{"CellGroupingRules", "\[Rule]", 
             RowBox[{"{", 
              RowBox[{"\"\<GroupTogetherGrouping\>\"", ",", "10000."}], 
              "}"}]}], ",", 
            RowBox[{"AllowGroupClose", "\[Rule]", "False"}], ",", " ", 
            RowBox[{"AllowReverseGroupClose", "\[Rule]", "False"}], ",", 
            RowBox[{"ShowCellBracket", "\[Rule]", "False"}]}], "]"}]}], "}"}],
         ",", 
        RowBox[{"Dynamic", "[", 
         RowBox[{
          RowBox[{"FEPrivate`If", "[", 
           RowBox[{
            RowBox[{"FEPrivate`Not", "[", 
             RowBox[{"FEPrivate`MemberQ", "[", 
              RowBox[{
               RowBox[{"{", "\"\<\>\"", "}"}], ",", 
               RowBox[{"FrontEnd`CurrentValue", "[", 
                RowBox[{
                 RowBox[{"FrontEnd`EvaluationNotebook", "[", "]"}], ",", 
                 RowBox[{"FEPrivate`If", "[", 
                  RowBox[{
                   RowBox[{"FEPrivate`SameQ", "[", 
                    RowBox[{
                    RowBox[{
                    "FrontEnd`CurrentValue", "[", "\"\<PluginEnabled\>\"", 
                    "]"}], ",", "True"}], "]"}], ",", 
                   RowBox[{"FEPrivate`If", "[", 
                    RowBox[{
                    RowBox[{"FEPrivate`MemberQ", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "\"\<Player\>\"", ",", "\"\<Player Pro\>\"", ",", 
                    "\"\<Unauthorized PlayerPro\>\""}], "}"}], ",", 
                    "FrontEnd`$NotebookLicenseType"}], "]"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    "TaggingRules", ",", "\"\<PluginPlayerMessage\>\""}], 
                    "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    "TaggingRules", ",", "\"\<PluginMathematicaMessage\>\""}],
                     "}"}]}], "]"}], ",", 
                   RowBox[{"FEPrivate`If", "[", 
                    RowBox[{
                    RowBox[{"FEPrivate`MemberQ", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "\"\<Player\>\"", ",", "\"\<Player Pro\>\"", ",", 
                    "\"\<Unauthorized PlayerPro\>\""}], "}"}], ",", 
                    "FrontEnd`$NotebookLicenseType"}], "]"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"TaggingRules", ",", "\"\<PlayerMessage\>\""}], 
                    "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    "TaggingRules", ",", "\"\<MathematicaMessage\>\""}], 
                    "}"}]}], "]"}]}], "]"}]}], "]"}]}], "]"}], "]"}], ",", 
            "Open", ",", " ", "Closed"}], "]"}], ",", "\"\<\>\""}], "]"}]}], 
       "]"}], "]"}]}], "]"}]}], ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.521308494414401*^9, 3.521308499055984*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"additionalMessageCell", "[", 
    RowBox[{"Cell", "[", 
     RowBox[{"a___", ",", "\"\<ObjectNameAlt\>\"", ",", "b___"}], "]"}], 
    "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", "}"}], ",", 
     RowBox[{"Cell", "[", 
      RowBox[{"CellGroupData", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Cell", "[", 
           RowBox[{"a", ",", "\"\<ObjectNameAlt\>\"", ",", "b", ",", 
            RowBox[{"CellGroupingRules", "\[Rule]", 
             RowBox[{"{", 
              RowBox[{"\"\<GroupTogetherGrouping\>\"", ",", "10000."}], 
              "}"}]}]}], "]"}], ",", 
          RowBox[{"Cell", "[", 
           RowBox[{
            RowBox[{"BoxData", "[", 
             RowBox[{"DynamicBox", "[", 
              RowBox[{
               RowBox[{"FrontEnd`CurrentValue", "[", 
                RowBox[{
                 RowBox[{"FrontEnd`EvaluationNotebook", "[", "]"}], ",", 
                 RowBox[{"FEPrivate`If", "[", 
                  RowBox[{
                   RowBox[{"FEPrivate`SameQ", "[", 
                    RowBox[{
                    RowBox[{
                    "FrontEnd`CurrentValue", "[", "\"\<PluginEnabled\>\"", 
                    "]"}], ",", "True"}], "]"}], ",", 
                   RowBox[{"FEPrivate`If", "[", 
                    RowBox[{
                    RowBox[{"FEPrivate`MemberQ", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "\"\<Player\>\"", ",", "\"\<Player Pro\>\"", ",", 
                    "\"\<Unauthorized PlayerPro\>\""}], "}"}], ",", 
                    "FrontEnd`$NotebookLicenseType"}], "]"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    "TaggingRules", ",", "\"\<PluginPlayerMessage\>\""}], 
                    "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    "TaggingRules", ",", "\"\<PluginMathematicaMessage\>\""}],
                     "}"}]}], "]"}], ",", 
                   RowBox[{"FEPrivate`If", "[", 
                    RowBox[{
                    RowBox[{"FEPrivate`MemberQ", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "\"\<Player\>\"", ",", "\"\<Player Pro\>\"", ",", 
                    "\"\<Unauthorized PlayerPro\>\""}], "}"}], ",", 
                    "FrontEnd`$NotebookLicenseType"}], "]"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"TaggingRules", ",", "\"\<PlayerMessage\>\""}], 
                    "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    "TaggingRules", ",", "\"\<MathematicaMessage\>\""}], 
                    "}"}]}], "]"}]}], "]"}], ",", "\"\<\>\""}], "]"}], ",", 
               RowBox[{"ImageSizeCache", "\[Rule]", 
                RowBox[{"{", 
                 RowBox[{"4.", ",", 
                  RowBox[{"{", 
                   RowBox[{"0.", ",", "0."}], "}"}]}], "}"}]}]}], "]"}], 
             "]"}], ",", "\"\<Text\>\"", ",", 
            RowBox[{"Editable", "->", "False"}], ",", "\n", " ", 
            RowBox[{"ShowCellBracket", "\[Rule]", "False"}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"PageWidth", "\[Rule]", "775"}], ",", "\n", " ", 
            RowBox[{"CellMargins", "->", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{"72", ",", " ", "0"}], "}"}], ",", " ", 
               RowBox[{"{", 
                RowBox[{"6", ",", " ", "3"}], "}"}]}], "}"}]}], " ", ",", 
            RowBox[{"CellGroupingRules", "\[Rule]", 
             RowBox[{"{", 
              RowBox[{"\"\<GroupTogetherGrouping\>\"", ",", "10000."}], 
              "}"}]}], ",", 
            RowBox[{"AllowGroupClose", "\[Rule]", "False"}], ",", " ", 
            RowBox[{"AllowReverseGroupClose", "\[Rule]", "False"}], ",", 
            RowBox[{"ShowCellBracket", "\[Rule]", "False"}]}], "]"}]}], "}"}],
         ",", 
        RowBox[{"Dynamic", "[", 
         RowBox[{
          RowBox[{"FEPrivate`If", "[", 
           RowBox[{
            RowBox[{"FEPrivate`Not", "[", 
             RowBox[{"FEPrivate`MemberQ", "[", 
              RowBox[{
               RowBox[{"{", "\"\<\>\"", "}"}], ",", 
               RowBox[{"FrontEnd`CurrentValue", "[", 
                RowBox[{
                 RowBox[{"FrontEnd`EvaluationNotebook", "[", "]"}], ",", 
                 RowBox[{"FEPrivate`If", "[", 
                  RowBox[{
                   RowBox[{"FEPrivate`SameQ", "[", 
                    RowBox[{
                    RowBox[{
                    "FrontEnd`CurrentValue", "[", "\"\<PluginEnabled\>\"", 
                    "]"}], ",", "True"}], "]"}], ",", 
                   RowBox[{"FEPrivate`If", "[", 
                    RowBox[{
                    RowBox[{"FEPrivate`MemberQ", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "\"\<Player\>\"", ",", "\"\<Player Pro\>\"", ",", 
                    "\"\<Unauthorized PlayerPro\>\""}], "}"}], ",", 
                    "FrontEnd`$NotebookLicenseType"}], "]"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    "TaggingRules", ",", "\"\<PluginPlayerMessage\>\""}], 
                    "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    "TaggingRules", ",", "\"\<PluginMathematicaMessage\>\""}],
                     "}"}]}], "]"}], ",", 
                   RowBox[{"FEPrivate`If", "[", 
                    RowBox[{
                    RowBox[{"FEPrivate`MemberQ", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "\"\<Player\>\"", ",", "\"\<Player Pro\>\"", ",", 
                    "\"\<Unauthorized PlayerPro\>\""}], "}"}], ",", 
                    "FrontEnd`$NotebookLicenseType"}], "]"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"TaggingRules", ",", "\"\<PlayerMessage\>\""}], 
                    "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    "TaggingRules", ",", "\"\<MathematicaMessage\>\""}], 
                    "}"}]}], "]"}]}], "]"}]}], "]"}]}], "]"}], "]"}], ",", 
            "Open", ",", " ", "Closed"}], "]"}], ",", "\"\<\>\""}], "]"}]}], 
       "]"}], "]"}]}], "]"}]}], ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.521308404153707*^9, 3.521308416723475*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Color Bar Cells", "Section",
 InitializationCell->True,
 CellChangeTimes->{{3.5091286882951527`*^9, 3.509128688999133*^9}, {
  3.514721803432283*^9, 3.5147218049446993`*^9}, {3.517921616319525*^9, 
  3.517921661760709*^9}, {3.51792178176928*^9, 3.517921786073371*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"symbolbar", "=", 
   RowBox[{"Cell", "[", 
    RowBox[{"\"\< \>\"", ",", "\[IndentingNewLine]", 
     RowBox[{"Editable", "\[Rule]", "False"}], ",", 
     RowBox[{"CellFrame", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0", ",", "0"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "3"}], "}"}]}], "}"}]}], ",", 
     RowBox[{"ShowCellBracket", "\[Rule]", "False"}], ",", 
     RowBox[{"CellElementSpacings", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"\"\<CellMinHeight\>\"", "\[Rule]", "2"}], "}"}]}], ",", 
     RowBox[{"Deployed", "\[Rule]", "True"}], ",", 
     RowBox[{"CellFrameMargins", "\[Rule]", "2"}], ",", 
     RowBox[{"CellFrameColor", "\[Rule]", 
      RowBox[{"RGBColor", "[", 
       RowBox[{"0.48", ",", "0.52", ",", "0.83"}], "]"}]}], ",", 
     RowBox[{"FormatType", "\[Rule]", "\"\<InputForm\>\""}], ",", 
     RowBox[{"StyleMenuListing", "\[Rule]", "None"}], ",", 
     RowBox[{"FontFamily", "\[Rule]", "\"\<Verdana\>\""}], ",", 
     RowBox[{"FontSize", "\[Rule]", "2"}], ",", 
     RowBox[{"CellMargins", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"72", ",", "25"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "0"}], "}"}]}], "}"}]}]}], "]"}]}], ";"}]], "Input",\

 InitializationCell->True,
 CellChangeTimes->{{3.511117427319393*^9, 3.511117454116016*^9}, 
   3.5111175394625673`*^9, 3.5111177205467663`*^9, 3.511187296600357*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"guidebar", "=", 
   RowBox[{"Cell", "[", 
    RowBox[{"\"\< \>\"", ",", "\[IndentingNewLine]", 
     RowBox[{"Editable", "\[Rule]", "False"}], ",", 
     RowBox[{"CellFrame", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0", ",", "0"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "3"}], "}"}]}], "}"}]}], ",", 
     RowBox[{"ShowCellBracket", "\[Rule]", "False"}], ",", 
     RowBox[{"CellElementSpacings", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"\"\<CellMinHeight\>\"", "\[Rule]", "2"}], "}"}]}], ",", 
     RowBox[{"Deployed", "\[Rule]", "True"}], ",", 
     RowBox[{"CellFrameMargins", "\[Rule]", "2"}], ",", 
     RowBox[{"CellFrameColor", "\[Rule]", 
      RowBox[{"RGBColor", "[", 
       RowBox[{"1", ",", "0.6", ",", "0"}], "]"}]}], ",", 
     RowBox[{"FormatType", "\[Rule]", "\"\<InputForm\>\""}], ",", 
     RowBox[{"StyleMenuListing", "\[Rule]", "None"}], ",", 
     RowBox[{"FontFamily", "\[Rule]", "\"\<Verdana\>\""}], ",", 
     RowBox[{"FontSize", "\[Rule]", "2"}], ",", 
     RowBox[{"CellMargins", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"72", ",", "25"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "0"}], "}"}]}], "}"}]}]}], "]"}]}], ";"}]], "Input",\

 InitializationCell->True,
 CellChangeTimes->{{3.511117440380218*^9, 3.511117458100009*^9}, 
   3.511117556823626*^9, 3.511117722550679*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"tutorialbar", "=", 
   RowBox[{"Cell", "[", 
    RowBox[{"\"\< \>\"", ",", "\[IndentingNewLine]", 
     RowBox[{"Editable", "\[Rule]", "False"}], ",", 
     RowBox[{"CellFrame", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0", ",", "0"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "3"}], "}"}]}], "}"}]}], ",", 
     RowBox[{"ShowCellBracket", "\[Rule]", "False"}], ",", 
     RowBox[{"CellElementSpacings", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"\"\<CellMinHeight\>\"", "\[Rule]", "2"}], "}"}]}], ",", 
     RowBox[{"Deployed", "\[Rule]", "True"}], ",", 
     RowBox[{"CellFrameMargins", "\[Rule]", "2"}], ",", 
     RowBox[{"CellFrameColor", "\[Rule]", 
      RowBox[{"RGBColor", "[", 
       RowBox[{"0.641154", ",", "0.223011", ",", "0.0623026"}], "]"}]}], ",", 
     
     RowBox[{"FormatType", "\[Rule]", "\"\<InputForm\>\""}], ",", 
     RowBox[{"StyleMenuListing", "\[Rule]", "None"}], ",", 
     RowBox[{"FontFamily", "\[Rule]", "\"\<Verdana\>\""}], ",", 
     RowBox[{"FontSize", "\[Rule]", "2"}], ",", 
     RowBox[{"CellMargins", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"72", ",", "25"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "0"}], "}"}]}], "}"}]}]}], "]"}]}], ";"}]], "Input",\

 InitializationCell->True,
 CellChangeTimes->{{3.511117445900503*^9, 3.5111174604920273`*^9}, {
   3.511117637646262*^9, 3.511117638610105*^9}, 3.511117725223954*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"howtobar", "=", 
   RowBox[{"Cell", "[", 
    RowBox[{"\"\< \>\"", ",", "\[IndentingNewLine]", 
     RowBox[{"Editable", "\[Rule]", "False"}], ",", 
     RowBox[{"CellFrame", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0", ",", "0"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "3"}], "}"}]}], "}"}]}], ",", 
     RowBox[{"ShowCellBracket", "\[Rule]", "False"}], ",", 
     RowBox[{"CellElementSpacings", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"\"\<CellMinHeight\>\"", "\[Rule]", "2"}], "}"}]}], ",", 
     RowBox[{"Deployed", "\[Rule]", "True"}], ",", 
     RowBox[{"CellFrameMargins", "\[Rule]", "2"}], ",", 
     RowBox[{"CellFrameColor", "\[Rule]", 
      RowBox[{"RGBColor", "[", 
       RowBox[{"0.641154", ",", "0.223011", ",", "0.0623026"}], "]"}]}], ",", 
     
     RowBox[{"FormatType", "\[Rule]", "\"\<InputForm\>\""}], ",", 
     RowBox[{"StyleMenuListing", "\[Rule]", "None"}], ",", 
     RowBox[{"FontFamily", "\[Rule]", "\"\<Verdana\>\""}], ",", 
     RowBox[{"FontSize", "\[Rule]", "2"}], ",", 
     RowBox[{"CellMargins", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"72", ",", "25"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "0"}], "}"}]}], "}"}]}]}], "]"}]}], ";"}]], "Input",\

 InitializationCell->True,
 CellChangeTimes->{{3.5111174665103807`*^9, 3.511117468341161*^9}, {
  3.511117701831211*^9, 3.511117729264907*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Black Header Cell", "Section",
 InitializationCell->True,
 CellChangeTimes->{{3.5091286882951527`*^9, 3.509128688999133*^9}, {
  3.514721803432283*^9, 3.5147218049446993`*^9}, {3.517921616319525*^9, 
  3.517921661760709*^9}, {3.517921772033362*^9, 3.51792178014533*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"blackheadercellen", "=", 
   RowBox[{"Cell", "[", 
    RowBox[{
     RowBox[{"BoxData", "[", 
      RowBox[{"ToBoxes", "[", 
       RowBox[{"Style", "[", 
        RowBox[{
         RowBox[{"DynamicModule", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"searchstr", "=", "Null"}], "}"}], ",", 
           RowBox[{"Overlay", "[", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"Show", "[", 
                GraphicsBox[
                 TagBox[RasterBox[CompressedData["
1:eJztfXuwnfdVnWM7cUDBMgGZ4mtqJbGTSva9siXbsiRLsWzLkq3HlS1L1iO2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                   "], {{0, 54}, {3000, 0}}, {0, 255},
                   ColorFunction->RGBColor],
                  BoxForm`ImageTag[
                  "Byte", ColorSpace -> "RGB", Interleaving -> True],
                  Selectable->False],
                 BaseStyle->"ImageGraphics",
                 ImageSizeRaw->{3000, 54},
                 PlotRange->{{0, 3000}, {0, 54}}], "]"}], ",", 
               RowBox[{"Deploy", "[", 
                RowBox[{"Graphics", "[", 
                 RowBox[{
                  RowBox[{"{", 
                   RowBox[{"Inset", "[", 
                    RowBox[{
                    RowBox[{"Grid", "[", 
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"Spacer", "[", "14", "]"}], ",", 
                    "\[IndentingNewLine]", 
                    RowBox[{"Hyperlink", "[", 
                    RowBox[{
                    RowBox[{"Rasterize", "[", 
                    RowBox[{
                    RowBox[{"Graphics", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "0", "]"}], ",", 
                    RowBox[{"Raster", "[", 
                    RowBox[{"{", 
                    RowBox[{"{", "1", "}"}], "}"}], "]"}]}], "}"}], ",", 
                    RowBox[{"ImageSize", "\[Rule]", 
                    RowBox[{"{", 
                    RowBox[{"125", ",", "30"}], "}"}]}]}], "]"}], ",", " ", 
                    RowBox[{"Background", "\[Rule]", "None"}]}], "]"}], ",", 
                    " ", "\"\<http://www.wolfram.com/\>\""}], "]"}], ",", " ",
                     "\[IndentingNewLine]", 
                    RowBox[{"Spacer", "[", "19", "]"}], ",", 
                    "\[IndentingNewLine]", 
                    RowBox[{"Mouseover", "[", 
                    RowBox[{
                    RowBox[{"Hyperlink", "[", 
                    RowBox[{
                    RowBox[{"Rasterize", "[", 
                    RowBox[{
                    RowBox[{"Graphics", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"White", ",", 
                    RowBox[{"FontSize", "\[Rule]", "11"}], ",", 
                    RowBox[{"FontFamily", "\[Rule]", "\"\<Arial\>\""}], ",", 
                    RowBox[{"Opacity", "[", "1", "]"}], ",", 
                    RowBox[{"Text", "[", "\"\<PRODUCTS\>\"", "]"}]}], "}"}], 
                    ",", 
                    RowBox[{"ImageSize", "\[Rule]", 
                    RowBox[{"{", 
                    RowBox[{"66", ",", "30"}], "}"}]}]}], "]"}], ",", 
                    RowBox[{"Background", "\[Rule]", "None"}]}], "]"}], ",", 
                    " ", "\"\<http://www.wolfram.com/products/\>\""}], "]"}], 
                    ",", 
                    RowBox[{"Hyperlink", "[", 
                    RowBox[{
                    RowBox[{"Rasterize", "[", 
                    RowBox[{
                    RowBox[{"Graphics", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"RGBColor", "[", 
                    RowBox[{".86", ",", ".01", ",", "0"}], "]"}], ",", 
                    RowBox[{"FontSize", "\[Rule]", "11"}], ",", 
                    RowBox[{"FontFamily", "\[Rule]", "\"\<Arial\>\""}], ",", 
                    RowBox[{"Opacity", "[", "1", "]"}], ",", 
                    RowBox[{"Text", "[", "\"\<PRODUCTS\>\"", "]"}]}], "}"}], 
                    ",", 
                    RowBox[{"ImageSize", "\[Rule]", 
                    RowBox[{"{", 
                    RowBox[{"66", ",", "30"}], "}"}]}]}], "]"}], ",", 
                    RowBox[{"Background", "\[Rule]", "None"}]}], "]"}], ",", 
                    " ", "\"\<http://www.wolfram.com/products/\>\""}], 
                    "]"}]}], "]"}], ",", " ", "\[IndentingNewLine]", 
                    RowBox[{"Spacer", "[", "3", "]"}], ",", 
                    "\[IndentingNewLine]", 
                    RowBox[{"Mouseover", "[", 
                    RowBox[{
                    RowBox[{"Hyperlink", "[", 
                    RowBox[{
                    RowBox[{"Rasterize", "[", 
                    RowBox[{
                    RowBox[{"Graphics", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"White", ",", 
                    RowBox[{"FontSize", "\[Rule]", "11"}], ",", 
                    RowBox[{"FontFamily", "\[Rule]", "\"\<Arial\>\""}], ",", 
                    RowBox[{"Opacity", "[", "1", "]"}], ",", 
                    RowBox[{"Text", "[", "\"\<SOLUTIONS\>\"", "]"}]}], "}"}], 
                    ",", 
                    RowBox[{"ImageSize", "\[Rule]", 
                    RowBox[{"{", 
                    RowBox[{"64", ",", "30"}], "}"}]}]}], "]"}], ",", 
                    RowBox[{"Background", "\[Rule]", "None"}]}], "]"}], ",", 
                    " ", "\"\<http://www.wolfram.com/solutions/\>\""}], "]"}],
                     ",", 
                    RowBox[{"Hyperlink", "[", 
                    RowBox[{
                    RowBox[{"Rasterize", "[", 
                    RowBox[{
                    RowBox[{"Graphics", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"RGBColor", "[", 
                    RowBox[{".86", ",", ".01", ",", "0"}], "]"}], ",", 
                    RowBox[{"FontSize", "\[Rule]", "11"}], ",", 
                    RowBox[{"FontFamily", "\[Rule]", "\"\<Arial\>\""}], ",", 
                    RowBox[{"Opacity", "[", "1", "]"}], ",", 
                    RowBox[{"Text", "[", "\"\<SOLUTIONS\>\"", "]"}]}], "}"}], 
                    ",", 
                    RowBox[{"ImageSize", "\[Rule]", 
                    RowBox[{"{", 
                    RowBox[{"64", ",", "30"}], "}"}]}]}], "]"}], ",", 
                    RowBox[{"Background", "\[Rule]", "None"}]}], "]"}], ",", 
                    " ", "\"\<http://www.wolfram.com/solutions/\>\""}], 
                    "]"}]}], "]"}], ",", " ", "\[IndentingNewLine]", 
                    RowBox[{"Spacer", "[", "4", "]"}], ",", 
                    "\[IndentingNewLine]", 
                    RowBox[{"Mouseover", "[", 
                    RowBox[{
                    RowBox[{"Hyperlink", "[", 
                    RowBox[{
                    RowBox[{"Rasterize", "[", 
                    RowBox[{
                    RowBox[{"Graphics", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"White", ",", 
                    RowBox[{"FontSize", "\[Rule]", "11"}], ",", 
                    RowBox[{"FontFamily", "\[Rule]", "\"\<Arial\>\""}], ",", 
                    RowBox[{"Opacity", "[", "1", "]"}], ",", 
                    RowBox[{"Text", "[", "\"\<PURCHASE\>\"", "]"}]}], "}"}], 
                    ",", " ", 
                    RowBox[{"ImageSize", "\[Rule]", 
                    RowBox[{"{", 
                    RowBox[{"62", ",", "30"}], "}"}]}]}], "]"}], ",", 
                    RowBox[{"Background", "\[Rule]", "None"}]}], "]"}], ",", 
                    " ", "\"\<http://www.wolfram.com/mathematica/how-to-buy/\>\
\""}], "]"}], ",", 
                    RowBox[{"Hyperlink", "[", 
                    RowBox[{
                    RowBox[{"Rasterize", "[", 
                    RowBox[{
                    RowBox[{"Graphics", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"RGBColor", "[", 
                    RowBox[{".86", ",", ".01", ",", "0"}], "]"}], ",", 
                    RowBox[{"FontSize", "\[Rule]", "11"}], ",", 
                    RowBox[{"FontFamily", "\[Rule]", "\"\<Arial\>\""}], ",", 
                    RowBox[{"Opacity", "[", "1", "]"}], ",", 
                    RowBox[{"Text", "[", "\"\<PURCHASE\>\"", "]"}]}], "}"}], 
                    ",", " ", 
                    RowBox[{"ImageSize", "\[Rule]", 
                    RowBox[{"{", 
                    RowBox[{"62", ",", "30"}], "}"}]}]}], "]"}], ",", 
                    RowBox[{"Background", "\[Rule]", "None"}]}], "]"}], ",", 
                    " ", "\"\<http://www.wolfram.com/mathematica/how-to-buy/\>\
\""}], "]"}]}], "]"}], ",", " ", "\[IndentingNewLine]", 
                    RowBox[{"Spacer", "[", "1", "]"}], ",", 
                    RowBox[{"Mouseover", "[", 
                    RowBox[{
                    RowBox[{"Hyperlink", "[", 
                    RowBox[{
                    RowBox[{"Rasterize", "[", 
                    RowBox[{
                    RowBox[{"Graphics", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"White", ",", 
                    RowBox[{"FontSize", "\[Rule]", "11"}], ",", 
                    RowBox[{"FontFamily", "\[Rule]", "\"\<Arial\>\""}], ",", 
                    RowBox[{"Opacity", "[", "1", "]"}], ",", 
                    RowBox[{"Text", "[", "\"\<SUPPORT\>\"", "]"}]}], "}"}], 
                    ",", " ", 
                    RowBox[{"ImageSize", "\[Rule]", 
                    RowBox[{"{", 
                    RowBox[{"55", ",", "30"}], "}"}]}]}], "]"}], ",", 
                    RowBox[{"Background", "\[Rule]", "None"}]}], "]"}], ",", 
                    " ", "\"\<http://www.wolfram.com/support/\>\""}], "]"}], 
                    ",", " ", 
                    RowBox[{"Hyperlink", "[", 
                    RowBox[{
                    RowBox[{"Rasterize", "[", 
                    RowBox[{
                    RowBox[{"Graphics", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"RGBColor", "[", 
                    RowBox[{".86", ",", ".01", ",", "0"}], "]"}], ",", 
                    RowBox[{"FontSize", "\[Rule]", "11"}], ",", 
                    RowBox[{"FontFamily", "\[Rule]", "\"\<Arial\>\""}], ",", 
                    RowBox[{"Opacity", "[", "1", "]"}], ",", 
                    RowBox[{"Text", "[", "\"\<SUPPORT\>\"", "]"}]}], "}"}], 
                    ",", " ", 
                    RowBox[{"ImageSize", "\[Rule]", 
                    RowBox[{"{", 
                    RowBox[{"55", ",", "30"}], "}"}]}]}], "]"}], ",", 
                    RowBox[{"Background", "\[Rule]", "None"}]}], "]"}], ",", 
                    " ", "\"\<http://www.wolfram.com/support/\>\""}], "]"}]}],
                     "]"}], ",", " ", "\[IndentingNewLine]", 
                    RowBox[{"Spacer", "[", "3", "]"}], ",", 
                    RowBox[{"Mouseover", "[", 
                    RowBox[{
                    RowBox[{"Hyperlink", "[", 
                    RowBox[{
                    RowBox[{"Rasterize", "[", 
                    RowBox[{
                    RowBox[{"Graphics", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"White", ",", 
                    RowBox[{"FontSize", "\[Rule]", "11"}], ",", 
                    RowBox[{"FontFamily", "\[Rule]", "\"\<Arial\>\""}], ",", 
                    RowBox[{"Opacity", "[", "1", "]"}], ",", 
                    RowBox[{"Text", "[", "\"\<COMPANY\>\"", "]"}]}], "}"}], 
                    ",", " ", 
                    RowBox[{"ImageSize", "\[Rule]", 
                    RowBox[{"{", 
                    RowBox[{"56", ",", "30"}], "}"}]}]}], "]"}], ",", 
                    RowBox[{"Background", "\[Rule]", "None"}]}], "]"}], ",", 
                    " ", "\"\<http://www.wolfram.com/company/\>\""}], "]"}], 
                    ",", " ", 
                    RowBox[{"Hyperlink", "[", 
                    RowBox[{
                    RowBox[{"Rasterize", "[", 
                    RowBox[{
                    RowBox[{"Graphics", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"RGBColor", "[", 
                    RowBox[{".86", ",", ".01", ",", "0"}], "]"}], ",", 
                    RowBox[{"FontSize", "\[Rule]", "11"}], ",", 
                    RowBox[{"FontFamily", "\[Rule]", "\"\<Arial\>\""}], ",", 
                    RowBox[{"Opacity", "[", "1", "]"}], ",", 
                    RowBox[{"Text", "[", "\"\<COMPANY\>\"", "]"}]}], "}"}], 
                    ",", " ", 
                    RowBox[{"ImageSize", "\[Rule]", 
                    RowBox[{"{", 
                    RowBox[{"56", ",", "30"}], "}"}]}]}], "]"}], ",", 
                    RowBox[{"Background", "\[Rule]", "None"}]}], "]"}], ",", 
                    " ", "\"\<http://www.wolfram.com/company/\>\""}], "]"}]}],
                     "]"}], ",", " ", "\[IndentingNewLine]", 
                    RowBox[{"Spacer", "[", "6", "]"}], ",", 
                    RowBox[{"Mouseover", "[", 
                    RowBox[{
                    RowBox[{"Hyperlink", "[", 
                    RowBox[{
                    RowBox[{"Rasterize", "[", 
                    RowBox[{
                    RowBox[{"Graphics", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"White", ",", 
                    RowBox[{"FontSize", "\[Rule]", "11"}], ",", 
                    RowBox[{"FontFamily", "\[Rule]", "\"\<Arial\>\""}], ",", 
                    RowBox[{"Opacity", "[", "1", "]"}], ",", 
                    RowBox[{"Text", "[", "\"\<OUR SITES\>\"", "]"}]}], "}"}], 
                    ",", " ", 
                    RowBox[{"ImageSize", "\[Rule]", 
                    RowBox[{"{", 
                    RowBox[{"59", ",", "30"}], "}"}]}]}], "]"}], ",", 
                    RowBox[{"Background", "\[Rule]", "None"}]}], "]"}], ",", 
                    " ", "\"\<http://www.wolfram.com/webresources.html\>\""}],
                     "]"}], ",", " ", 
                    RowBox[{"Hyperlink", "[", 
                    RowBox[{
                    RowBox[{"Rasterize", "[", 
                    RowBox[{
                    RowBox[{"Graphics", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"RGBColor", "[", 
                    RowBox[{".86", ",", ".01", ",", "0"}], "]"}], ",", 
                    RowBox[{"FontSize", "\[Rule]", "11"}], ",", 
                    RowBox[{"FontFamily", "\[Rule]", "\"\<Arial\>\""}], ",", 
                    RowBox[{"Opacity", "[", "1", "]"}], ",", 
                    RowBox[{"Text", "[", "\"\<OUR SITES\>\"", "]"}]}], "}"}], 
                    ",", " ", 
                    RowBox[{"ImageSize", "\[Rule]", 
                    RowBox[{"{", 
                    RowBox[{"59", ",", "30"}], "}"}]}]}], "]"}], ",", 
                    RowBox[{"Background", "\[Rule]", "None"}]}], "]"}], ",", 
                    " ", "\"\<http://www.wolfram.com/webresources.html\>\""}],
                     "]"}]}], "]"}], ",", "\[IndentingNewLine]", 
                    RowBox[{"Spacer", "[", "154", "]"}], ",", 
                    RowBox[{"Deploy", "[", 
                    RowBox[{"Graphics", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"Inset", "[", 
                    RowBox[{
                    RowBox[{"EventHandler", "[", 
                    RowBox[{
                    RowBox[{"Framed", "[", 
                    RowBox[{
                    RowBox[{"Style", "[", 
                    RowBox[{
                    RowBox[{"InputField", "[", 
                    RowBox[{
                    RowBox[{"Dynamic", "[", "searchstr", "]"}], ",", " ", 
                    "String", ",", 
                    RowBox[{"Appearance", "\[Rule]", "None"}], ",", 
                    RowBox[{"ContinuousAction", "\[Rule]", "True"}], ",", 
                    RowBox[{"FieldSize", "\[Rule]", 
                    RowBox[{"{", 
                    RowBox[{"20", ",", 
                    RowBox[{"{", 
                    RowBox[{"1", ",", "1"}], "}"}]}], "}"}]}], ",", 
                    RowBox[{"FieldHintStyle", "\[Rule]", 
                    RowBox[{"{", "12", "}"}]}], ",", " ", 
                    RowBox[{"FieldHint", "\[Rule]", "\"\<SEARCH\>\""}], ",", 
                    RowBox[{"DefaultFieldHintStyle", "\[Rule]", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0.73", ",", "0.73", ",", "0.73"}], "]"}], ",", 
                    RowBox[{"FontSize", "\[Rule]", "12"}], ",", 
                    RowBox[{"FontFamily", "\[Rule]", "\"\<Arial\>\""}]}], 
                    "}"}]}], ",", 
                    RowBox[{"BaseStyle", "\[Rule]", 
                    RowBox[{"{", 
                    RowBox[{"White", ",", " ", 
                    RowBox[{"FontSize", "\[Rule]", "12"}], ",", 
                    RowBox[{"FontFamily", "\[Rule]", "\"\<Arial\>\""}]}], 
                    "}"}]}], ",", 
                    RowBox[{"FieldHintStyle", "\[Rule]", 
                    RowBox[{"{", 
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0.73", ",", "0.73", ",", "0.73"}], "]"}], 
                    "}"}]}]}], "]"}], ",", " ", 
                    RowBox[{"ShowSelection", "\[Rule]", "True"}]}], "]"}], 
                    ",", 
                    RowBox[{"Background", "\[Rule]", 
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0.33", ",", "0.33", ",", "0.33"}], "]"}]}]}], 
                    "]"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"\"\<ReturnKeyDown\>\"", "\[RuleDelayed]", 
                    RowBox[{"NotebookLocate", "[", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"URL", "[", 
                    RowBox[{"\"\<http://search.wolfram.com/?query=\>\"", "<>", 
                    RowBox[{"ToString", "[", "searchstr", "]"}], "<>", 
                    "\"\<&x=0&y=0\>\""}], "]"}], ",", "None"}], "}"}], 
                    "]"}]}], ",", "\[IndentingNewLine]", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "\"\<MenuCommand\>\"", ",", "\"\<HandleShiftReturn\>\""}],
                     "}"}], "\[RuleDelayed]", 
                    RowBox[{"NotebookLocate", "[", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"URL", "[", 
                    RowBox[{"\"\<http://search.wolfram.com/?query=\>\"", "<>", 
                    RowBox[{"ToString", "[", "searchstr", "]"}], "<>", 
                    "\"\<&x=0&y=0\>\""}], "]"}], ",", "None"}], "}"}], 
                    "]"}]}], ",", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "\"\<MenuCommand\>\"", ",", "\"\<EvaluateCells\>\""}], 
                    "}"}], "\[RuleDelayed]", 
                    RowBox[{"NotebookLocate", "[", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"URL", "[", 
                    RowBox[{"\"\<http://search.wolfram.com/?query=\>\"", "<>", 
                    RowBox[{"ToString", "[", "searchstr", "]"}], "<>", 
                    "\"\<&x=0&y=0\>\""}], "]"}], ",", "None"}], "}"}], 
                    "]"}]}]}], "}"}]}], "]"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"105", ",", "8"}], "}"}]}], "]"}], ",", 
                    RowBox[{"Inset", "[", 
                    RowBox[{
                    RowBox[{"Button", "[", 
                    RowBox[{
                    RowBox[{"Rasterize", "[", 
                    RowBox[{
                    RowBox[{"Style", "[", 
                    RowBox[{"\"\<\[RightGuillemet]\>\"", ",", " ", 
                    RowBox[{"FontColor", "\[Rule]", "Gray"}], ",", 
                    RowBox[{"FontSize", "\[Rule]", "18"}]}], "]"}], ",", 
                    RowBox[{"Background", "\[Rule]", "None"}]}], "]"}], ",", 
                    " ", 
                    RowBox[{"NotebookLocate", "[", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"URL", "[", 
                    RowBox[{"\"\<http://search.wolfram.com/?query=\>\"", "<>", 
                    RowBox[{"ToString", "[", "searchstr", "]"}], "<>", 
                    "\"\<&x=0&y=0\>\""}], "]"}], ",", "None"}], "}"}], "]"}], 
                    ",", 
                    RowBox[{"Appearance", "\[Rule]", "None"}]}], "]"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"192", ",", "9"}], "}"}], ",", 
                    RowBox[{"ContentSelectable", "\[Rule]", "True"}]}], 
                    "]"}]}], "}"}], ",", " ", 
                    RowBox[{"ImageSize", "\[Rule]", 
                    RowBox[{"{", 
                    RowBox[{"200", ",", "15"}], "}"}]}], ",", 
                    RowBox[{"PlotRange", "->", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"0", ",", "200"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"0", ",", "15"}], "}"}]}], "}"}]}]}], "]"}], 
                    "]"}]}], "}"}], "}"}], "]"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"500", ",", "23"}], "}"}], ",", 
                    RowBox[{"ContentSelectable", "\[Rule]", "True"}]}], "]"}],
                    "}"}], ",", " ", 
                  RowBox[{"PlotRange", "->", 
                   RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"0", ",", "3000"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"0", ",", "53"}], "}"}]}], "}"}]}], ",", 
                  RowBox[{"ImageSize", "\[Rule]", 
                   RowBox[{"{", 
                    RowBox[{"3000", ",", "53"}], "}"}]}]}], "]"}], "]"}]}], 
              "}"}], ",", "All", ",", "2"}], "]"}]}], "]"}], ",", 
         RowBox[{"ShowSelection", "\[Rule]", "False"}]}], "]"}], "]"}], "]"}],
      ",", 
     RowBox[{"ShowCellBracket", "\[Rule]", "False"}], ",", 
     RowBox[{"CellMargins", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0", ",", "0"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "0"}], "}"}]}], "}"}]}], ",", 
     RowBox[{"PageWidth", "\[Rule]", "WindowWidth"}], ",", 
     RowBox[{"CellBracketOptions", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"\"\<Margins\>\"", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"0", ",", "2"}], "}"}]}], "}"}]}]}], " ", "]"}]}], 
  ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.5122401021670094`*^9, 3.512240110297106*^9}, {
   3.512405414799321*^9, 3.512405415527144*^9}, {3.51240570978638*^9, 
   3.512405726531995*^9}, {3.512579450693511*^9, 3.5125794605083017`*^9}, {
   3.512579492216831*^9, 3.5125795185792418`*^9}, 3.51257982377693*^9, {
   3.5125799374171143`*^9, 3.512579937758955*^9}, 3.512580117188386*^9, {
   3.513604190444318*^9, 3.513604207855176*^9}, {3.516457243288559*^9, 
   3.516457250150181*^9}, {3.516459604682117*^9, 3.516459605651228*^9}, {
   3.517921744375928*^9, 3.517921767367454*^9}, {3.520356033189868*^9, 
   3.520356033347864*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"blackheadercellja", "=", 
   RowBox[{"Cell", "[", 
    RowBox[{
     RowBox[{"BoxData", "[", 
      RowBox[{"ToBoxes", "[", 
       RowBox[{"Style", "[", 
        RowBox[{
         RowBox[{"DynamicModule", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"searchstr", "=", "Null"}], "}"}], ",", 
           RowBox[{"Overlay", "[", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"Show", "[", 
                GraphicsBox[
                 TagBox[RasterBox[CompressedData["
1:eJztfXuwnfdVnWM7cUDBMgGZ4mtqJbGTSva9siXbsiRLsWzLkq3HlS1L1iO2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                   "], {{0, 54}, {3000, 0}}, {0, 255},
                   ColorFunction->RGBColor],
                  BoxForm`ImageTag[
                  "Byte", ColorSpace -> "RGB", Interleaving -> True],
                  Selectable->False],
                 BaseStyle->"ImageGraphics",
                 ImageSizeRaw->{3000, 54},
                 PlotRange->{{0, 3000}, {0, 54}}], "]"}], ",", 
               RowBox[{"Deploy", "[", 
                RowBox[{"Graphics", "[", 
                 RowBox[{
                  RowBox[{"{", 
                   RowBox[{"Inset", "[", 
                    RowBox[{
                    RowBox[{"Grid", "[", 
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"Spacer", "[", "5", "]"}], ",", 
                    "\[IndentingNewLine]", 
                    RowBox[{"Hyperlink", "[", 
                    RowBox[{
                    RowBox[{"Rasterize", "[", 
                    RowBox[{
                    RowBox[{"Graphics", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "0", "]"}], ",", 
                    RowBox[{"Raster", "[", 
                    RowBox[{"{", 
                    RowBox[{"{", "1", "}"}], "}"}], "]"}]}], "}"}], ",", 
                    RowBox[{"ImageSize", "\[Rule]", 
                    RowBox[{"{", 
                    RowBox[{"130", ",", "30"}], "}"}]}]}], "]"}], ",", " ", 
                    RowBox[{"Background", "\[Rule]", "None"}]}], "]"}], ",", 
                    " ", "\"\<http://www.wolfram.com/\>\""}], "]"}], ",", 
                    "\[IndentingNewLine]", 
                    RowBox[{"Spacer", "[", "25", "]"}], ",", 
                    RowBox[{"Mouseover", "[", 
                    RowBox[{
                    RowBox[{"Hyperlink", "[", 
                    RowBox[{
                    RowBox[{"Rasterize", "[", 
                    RowBox[{
                    RowBox[{"Graphics", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"White", ",", 
                    RowBox[{"FontSize", "\[Rule]", "11"}], ",", 
                    RowBox[{"FontFamily", "\[Rule]", "\"\<Arial\>\""}], ",", 
                    RowBox[{"Opacity", "[", "1", "]"}], ",", 
                    RowBox[{"Text", "[", "\"\<\:88fd\:54c1\>\"", "]"}]}], 
                    "}"}], ",", 
                    RowBox[{"ImageSize", "\[Rule]", 
                    RowBox[{"{", 
                    RowBox[{"27", ",", "30"}], "}"}]}]}], "]"}], ",", 
                    RowBox[{"Background", "\[Rule]", "None"}]}], "]"}], ",", 
                    " ", "\"\<http://www.wolfram.com/products/\>\""}], "]"}], 
                    ",", 
                    RowBox[{"Hyperlink", "[", 
                    RowBox[{
                    RowBox[{"Rasterize", "[", 
                    RowBox[{
                    RowBox[{"Graphics", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"RGBColor", "[", 
                    RowBox[{".86", ",", ".01", ",", "0"}], "]"}], ",", 
                    RowBox[{"FontSize", "\[Rule]", "11"}], ",", 
                    RowBox[{"FontFamily", "\[Rule]", "\"\<Arial\>\""}], ",", 
                    RowBox[{"Opacity", "[", "1", "]"}], ",", 
                    RowBox[{"Text", "[", "\"\<\:88fd\:54c1\>\"", "]"}]}], 
                    "}"}], ",", 
                    RowBox[{"ImageSize", "\[Rule]", 
                    RowBox[{"{", 
                    RowBox[{"27", ",", "30"}], "}"}]}]}], "]"}], ",", 
                    RowBox[{"Background", "\[Rule]", "None"}]}], "]"}], ",", 
                    " ", "\"\<http://www.wolfram.com/products/\>\""}], 
                    "]"}]}], "]"}], ",", "\[IndentingNewLine]", 
                    RowBox[{"Spacer", "[", "5", "]"}], ",", 
                    "\[IndentingNewLine]", 
                    RowBox[{"Mouseover", "[", 
                    RowBox[{
                    RowBox[{"Hyperlink", "[", 
                    RowBox[{
                    RowBox[{"Rasterize", "[", 
                    RowBox[{
                    RowBox[{"Graphics", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"White", ",", 
                    RowBox[{"FontSize", "\[Rule]", "11"}], ",", 
                    RowBox[{"FontFamily", "\[Rule]", "\"\<Arial\>\""}], ",", 
                    RowBox[{"Opacity", "[", "1", "]"}], ",", 
                    RowBox[{
                    "Text", "[", 
                    "\"\<\:30bd\:30ea\:30e5\:30fc\:30b7\:30e7\:30f3\>\"", 
                    "]"}]}], "}"}], ",", 
                    RowBox[{"ImageSize", "\[Rule]", 
                    RowBox[{"{", 
                    RowBox[{"75", ",", "30"}], "}"}]}]}], "]"}], ",", 
                    RowBox[{"Background", "\[Rule]", "None"}]}], "]"}], ",", 
                    " ", "\"\<http://www.wolfram.com/solutions/\>\""}], "]"}],
                     ",", 
                    RowBox[{"Hyperlink", "[", 
                    RowBox[{
                    RowBox[{"Rasterize", "[", 
                    RowBox[{
                    RowBox[{"Graphics", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"RGBColor", "[", 
                    RowBox[{".86", ",", ".01", ",", "0"}], "]"}], ",", 
                    RowBox[{"FontSize", "\[Rule]", "11"}], ",", 
                    RowBox[{"FontFamily", "\[Rule]", "\"\<Arial\>\""}], ",", 
                    RowBox[{"Opacity", "[", "1", "]"}], ",", 
                    RowBox[{
                    "Text", "[", 
                    "\"\<\:30bd\:30ea\:30e5\:30fc\:30b7\:30e7\:30f3\>\"", 
                    "]"}]}], "}"}], ",", 
                    RowBox[{"ImageSize", "\[Rule]", 
                    RowBox[{"{", 
                    RowBox[{"75", ",", "30"}], "}"}]}]}], "]"}], ",", 
                    RowBox[{"Background", "\[Rule]", "None"}]}], "]"}], ",", 
                    " ", "\"\<http://www.wolfram.com/solutions/\>\""}], 
                    "]"}]}], "]"}], ",", " ", "\[IndentingNewLine]", 
                    RowBox[{"Spacer", "[", "9", "]"}], ",", 
                    "\[IndentingNewLine]", 
                    RowBox[{"Mouseover", "[", 
                    RowBox[{
                    RowBox[{"Hyperlink", "[", 
                    RowBox[{
                    RowBox[{"Rasterize", "[", 
                    RowBox[{
                    RowBox[{"Graphics", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"White", ",", 
                    RowBox[{"FontSize", "\[Rule]", "11"}], ",", 
                    RowBox[{"FontFamily", "\[Rule]", "\"\<Arial\>\""}], ",", 
                    RowBox[{"Opacity", "[", "1", "]"}], ",", 
                    RowBox[{
                    "Text", "[", "\"\<\:3054\:8cfc\:5165\>\"", "]"}]}], "}"}],
                     ",", " ", 
                    RowBox[{"ImageSize", "\[Rule]", 
                    RowBox[{"{", 
                    RowBox[{"30", ",", "30"}], "}"}]}]}], "]"}], ",", 
                    RowBox[{"Background", "\[Rule]", "None"}]}], "]"}], ",", 
                    " ", "\"\<http://www.wolfram.com/mathematica/how-to-buy/\>\
\""}], "]"}], ",", 
                    RowBox[{"Hyperlink", "[", 
                    RowBox[{
                    RowBox[{"Rasterize", "[", 
                    RowBox[{
                    RowBox[{"Graphics", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"RGBColor", "[", 
                    RowBox[{".86", ",", ".01", ",", "0"}], "]"}], ",", 
                    RowBox[{"FontSize", "\[Rule]", "11"}], ",", 
                    RowBox[{"FontFamily", "\[Rule]", "\"\<Arial\>\""}], ",", 
                    RowBox[{"Opacity", "[", "1", "]"}], ",", 
                    RowBox[{"Text", "[", "\"\<\:3054\:8cfc\:5165\>\"", 
                    "]"}]}], "}"}], ",", " ", 
                    RowBox[{"ImageSize", "\[Rule]", 
                    RowBox[{"{", 
                    RowBox[{"30", ",", "30"}], "}"}]}]}], "]"}], ",", 
                    RowBox[{"Background", "\[Rule]", "None"}]}], "]"}], ",", 
                    " ", "\"\<http://www.wolfram.com/mathematica/how-to-buy/\>\
\""}], "]"}]}], "]"}], ",", " ", "\[IndentingNewLine]", 
                    RowBox[{"Spacer", "[", "7", "]"}], ",", 
                    RowBox[{"Mouseover", "[", 
                    RowBox[{
                    RowBox[{"Hyperlink", "[", 
                    RowBox[{
                    RowBox[{"Rasterize", "[", 
                    RowBox[{
                    RowBox[{"Graphics", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"White", ",", 
                    RowBox[{"FontSize", "\[Rule]", "11"}], ",", 
                    RowBox[{"FontFamily", "\[Rule]", "\"\<Arial\>\""}], ",", 
                    RowBox[{"Opacity", "[", "1", "]"}], ",", 
                    RowBox[{
                    "Text", "[", "\"\<\:30b5\:30dd\:30fc\:30c8\>\"", "]"}]}], 
                    "}"}], ",", " ", 
                    RowBox[{"ImageSize", "\[Rule]", 
                    RowBox[{"{", 
                    RowBox[{"45", ",", "30"}], "}"}]}]}], "]"}], ",", 
                    RowBox[{"Background", "\[Rule]", "None"}]}], "]"}], ",", 
                    " ", "\"\<http://www.wolfram.com/support/\>\""}], "]"}], 
                    ",", " ", 
                    RowBox[{"Hyperlink", "[", 
                    RowBox[{
                    RowBox[{"Rasterize", "[", 
                    RowBox[{
                    RowBox[{"Graphics", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"RGBColor", "[", 
                    RowBox[{".86", ",", ".01", ",", "0"}], "]"}], ",", 
                    RowBox[{"FontSize", "\[Rule]", "11"}], ",", 
                    RowBox[{"FontFamily", "\[Rule]", "\"\<Arial\>\""}], ",", 
                    RowBox[{"Opacity", "[", "1", "]"}], ",", 
                    RowBox[{
                    "Text", "[", "\"\<\:30b5\:30dd\:30fc\:30c8\>\"", "]"}]}], 
                    "}"}], ",", " ", 
                    RowBox[{"ImageSize", "\[Rule]", 
                    RowBox[{"{", 
                    RowBox[{"45", ",", "30"}], "}"}]}]}], "]"}], ",", 
                    RowBox[{"Background", "\[Rule]", "None"}]}], "]"}], ",", 
                    " ", "\"\<http://www.wolfram.com/support/\>\""}], "]"}]}],
                     "]"}], ",", " ", "\[IndentingNewLine]", 
                    RowBox[{"Spacer", "[", "3", "]"}], ",", 
                    RowBox[{"Mouseover", "[", 
                    RowBox[{
                    RowBox[{"Hyperlink", "[", 
                    RowBox[{
                    RowBox[{"Rasterize", "[", 
                    RowBox[{
                    RowBox[{"Graphics", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"White", ",", 
                    RowBox[{"FontSize", "\[Rule]", "11"}], ",", 
                    RowBox[{"FontFamily", "\[Rule]", "\"\<Arial\>\""}], ",", 
                    RowBox[{"Opacity", "[", "1", "]"}], ",", 
                    RowBox[{
                    "Text", "[", "\"\<\:4f1a\:793e\:6982\:8981\>\"", "]"}]}], 
                    "}"}], ",", " ", 
                    RowBox[{"ImageSize", "\[Rule]", 
                    RowBox[{"{", 
                    RowBox[{"45", ",", "30"}], "}"}]}]}], "]"}], ",", 
                    RowBox[{"Background", "\[Rule]", "None"}]}], "]"}], ",", 
                    " ", "\"\<http://www.wolfram.com/company/\>\""}], "]"}], 
                    ",", " ", 
                    RowBox[{"Hyperlink", "[", 
                    RowBox[{
                    RowBox[{"Rasterize", "[", 
                    RowBox[{
                    RowBox[{"Graphics", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"RGBColor", "[", 
                    RowBox[{".86", ",", ".01", ",", "0"}], "]"}], ",", 
                    RowBox[{"FontSize", "\[Rule]", "11"}], ",", 
                    RowBox[{"FontFamily", "\[Rule]", "\"\<Arial\>\""}], ",", 
                    RowBox[{"Opacity", "[", "1", "]"}], ",", 
                    RowBox[{
                    "Text", "[", "\"\<\:4f1a\:793e\:6982\:8981\>\"", "]"}]}], 
                    "}"}], ",", " ", 
                    RowBox[{"ImageSize", "\[Rule]", 
                    RowBox[{"{", 
                    RowBox[{"45", ",", "30"}], "}"}]}]}], "]"}], ",", 
                    RowBox[{"Background", "\[Rule]", "None"}]}], "]"}], ",", 
                    " ", "\"\<http://www.wolfram.com/company/\>\""}], "]"}]}],
                     "]"}], ",", " ", "\[IndentingNewLine]", 
                    RowBox[{"Spacer", "[", "6", "]"}], ",", 
                    RowBox[{"Mouseover", "[", 
                    RowBox[{
                    RowBox[{"Hyperlink", "[", 
                    RowBox[{
                    RowBox[{"Rasterize", "[", 
                    RowBox[{
                    RowBox[{"Graphics", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"White", ",", 
                    RowBox[{"FontSize", "\[Rule]", "11"}], ",", 
                    RowBox[{"FontFamily", "\[Rule]", "\"\<Arial\>\""}], ",", 
                    RowBox[{"Opacity", "[", "1", "]"}], ",", 
                    RowBox[{
                    "Text", "[", "\"\<Wolfram Web\:30b5\:30a4\:30c8\>\"", 
                    "]"}]}], "}"}], ",", " ", 
                    RowBox[{"ImageSize", "\[Rule]", 
                    RowBox[{"{", 
                    RowBox[{"102", ",", "30"}], "}"}]}]}], "]"}], ",", 
                    RowBox[{"Background", "\[Rule]", "None"}]}], "]"}], ",", 
                    " ", "\"\<http://www.wolfram.com/webresources.html\>\""}],
                     "]"}], ",", " ", 
                    RowBox[{"Hyperlink", "[", 
                    RowBox[{
                    RowBox[{"Rasterize", "[", 
                    RowBox[{
                    RowBox[{"Graphics", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"RGBColor", "[", 
                    RowBox[{".86", ",", ".01", ",", "0"}], "]"}], ",", 
                    RowBox[{"FontSize", "\[Rule]", "11"}], ",", 
                    RowBox[{"FontFamily", "\[Rule]", "\"\<Arial\>\""}], ",", 
                    RowBox[{"Opacity", "[", "1", "]"}], ",", 
                    RowBox[{
                    "Text", "[", "\"\<Wolfram Web\:30b5\:30a4\:30c8\>\"", 
                    "]"}]}], "}"}], ",", " ", 
                    RowBox[{"ImageSize", "\[Rule]", 
                    RowBox[{"{", 
                    RowBox[{"102", ",", "30"}], "}"}]}]}], "]"}], ",", 
                    RowBox[{"Background", "\[Rule]", "None"}]}], "]"}], ",", 
                    " ", "\"\<http://www.wolfram.com/webresources.html\>\""}],
                     "]"}]}], "]"}], ",", "\[IndentingNewLine]", 
                    RowBox[{"Spacer", "[", "154", "]"}], ",", 
                    RowBox[{"Deploy", "[", 
                    RowBox[{"Graphics", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"Inset", "[", 
                    RowBox[{
                    RowBox[{"EventHandler", "[", 
                    RowBox[{
                    RowBox[{"Framed", "[", 
                    RowBox[{
                    RowBox[{"Style", "[", 
                    RowBox[{
                    RowBox[{"InputField", "[", 
                    RowBox[{
                    RowBox[{"Dynamic", "[", "searchstr", "]"}], ",", " ", 
                    "String", ",", 
                    RowBox[{"Appearance", "\[Rule]", "None"}], ",", 
                    RowBox[{"ContinuousAction", "\[Rule]", "True"}], ",", 
                    RowBox[{"FieldSize", "\[Rule]", 
                    RowBox[{"{", 
                    RowBox[{"20", ",", 
                    RowBox[{"{", 
                    RowBox[{"1", ",", "1"}], "}"}]}], "}"}]}], ",", 
                    RowBox[{"FieldHintStyle", "\[Rule]", 
                    RowBox[{"{", "12", "}"}]}], ",", " ", 
                    RowBox[{"FieldHint", "\[Rule]", "\"\<\:691c\:7d22\>\""}], 
                    ",", 
                    RowBox[{"DefaultFieldHintStyle", "\[Rule]", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0.73", ",", "0.73", ",", "0.73"}], "]"}], ",", 
                    RowBox[{"FontSize", "\[Rule]", "12"}], ",", 
                    RowBox[{"FontFamily", "\[Rule]", "\"\<Arial\>\""}]}], 
                    "}"}]}], ",", 
                    RowBox[{"BaseStyle", "\[Rule]", 
                    RowBox[{"{", 
                    RowBox[{"White", ",", " ", 
                    RowBox[{"FontSize", "\[Rule]", "12"}], ",", 
                    RowBox[{"FontFamily", "\[Rule]", "\"\<Arial\>\""}]}], 
                    "}"}]}], ",", 
                    RowBox[{"FieldHintStyle", "\[Rule]", 
                    RowBox[{"{", 
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0.73", ",", "0.73", ",", "0.73"}], "]"}], 
                    "}"}]}]}], "]"}], ",", " ", 
                    RowBox[{"ShowSelection", "\[Rule]", "True"}]}], "]"}], 
                    ",", 
                    RowBox[{"Background", "\[Rule]", 
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0.33", ",", "0.33", ",", "0.33"}], "]"}]}]}], 
                    "]"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"\"\<ReturnKeyDown\>\"", "\[RuleDelayed]", 
                    RowBox[{"NotebookLocate", "[", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"URL", "[", 
                    RowBox[{"\"\<http://search.wolfram.com/?query=\>\"", "<>", 
                    RowBox[{"ToString", "[", "searchstr", "]"}], "<>", 
                    "\"\<&x=0&y=0\>\""}], "]"}], ",", "None"}], "}"}], 
                    "]"}]}], ",", "\[IndentingNewLine]", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "\"\<MenuCommand\>\"", ",", "\"\<HandleShiftReturn\>\""}],
                     "}"}], "\[RuleDelayed]", 
                    RowBox[{"NotebookLocate", "[", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"URL", "[", 
                    RowBox[{"\"\<http://search.wolfram.com/?query=\>\"", "<>", 
                    RowBox[{"ToString", "[", "searchstr", "]"}], "<>", 
                    "\"\<&x=0&y=0\>\""}], "]"}], ",", "None"}], "}"}], 
                    "]"}]}], ",", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "\"\<MenuCommand\>\"", ",", "\"\<EvaluateCells\>\""}], 
                    "}"}], "\[RuleDelayed]", 
                    RowBox[{"NotebookLocate", "[", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"URL", "[", 
                    RowBox[{"\"\<http://search.wolfram.com/?query=\>\"", "<>", 
                    RowBox[{"ToString", "[", "searchstr", "]"}], "<>", 
                    "\"\<&x=0&y=0\>\""}], "]"}], ",", "None"}], "}"}], 
                    "]"}]}]}], "}"}]}], "]"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"105", ",", "8"}], "}"}]}], "]"}], ",", 
                    RowBox[{"Inset", "[", 
                    RowBox[{
                    RowBox[{"Button", "[", 
                    RowBox[{
                    RowBox[{"Rasterize", "[", 
                    RowBox[{
                    RowBox[{"Style", "[", 
                    RowBox[{"\"\<\[RightGuillemet]\>\"", ",", " ", 
                    RowBox[{"FontColor", "\[Rule]", "Gray"}], ",", 
                    RowBox[{"FontSize", "\[Rule]", "18"}]}], "]"}], ",", 
                    RowBox[{"Background", "\[Rule]", "None"}]}], "]"}], ",", 
                    " ", 
                    RowBox[{"NotebookLocate", "[", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"URL", "[", 
                    RowBox[{"\"\<http://search.wolfram.com/?query=\>\"", "<>", 
                    RowBox[{"ToString", "[", "searchstr", "]"}], "<>", 
                    "\"\<&x=0&y=0\>\""}], "]"}], ",", "None"}], "}"}], "]"}], 
                    ",", 
                    RowBox[{"Appearance", "\[Rule]", "None"}]}], "]"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"192", ",", "9"}], "}"}], ",", 
                    RowBox[{"ContentSelectable", "\[Rule]", "True"}]}], 
                    "]"}]}], "}"}], ",", " ", 
                    RowBox[{"ImageSize", "\[Rule]", 
                    RowBox[{"{", 
                    RowBox[{"200", ",", "15"}], "}"}]}], ",", 
                    RowBox[{"PlotRange", "->", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"0", ",", "200"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"0", ",", "15"}], "}"}]}], "}"}]}]}], "]"}], 
                    "]"}]}], "}"}], "}"}], "]"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"490", ",", "23"}], "}"}], ",", 
                    RowBox[{"ContentSelectable", "\[Rule]", "True"}]}], "]"}],
                    "}"}], ",", " ", 
                  RowBox[{"PlotRange", "->", 
                   RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"0", ",", "3000"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"0", ",", "53"}], "}"}]}], "}"}]}], ",", 
                  RowBox[{"ImageSize", "\[Rule]", 
                   RowBox[{"{", 
                    RowBox[{"3000", ",", "53"}], "}"}]}]}], "]"}], "]"}]}], 
              "}"}], ",", "All", ",", "2"}], "]"}]}], "]"}], ",", 
         RowBox[{"ShowSelection", "\[Rule]", "False"}]}], "]"}], "]"}], "]"}],
      ",", 
     RowBox[{"ShowCellBracket", "\[Rule]", "False"}], ",", 
     RowBox[{"CellMargins", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0", ",", "0"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "0"}], "}"}]}], "}"}]}], ",", 
     RowBox[{"PageWidth", "\[Rule]", "WindowWidth"}], ",", 
     RowBox[{"CellBracketOptions", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"\"\<Margins\>\"", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"0", ",", "2"}], "}"}]}], "}"}]}]}], " ", "]"}]}], 
  ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.520356029048579*^9, 3.5203560292415237`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"blackheadercellzh", "=", 
   RowBox[{"Cell", "[", 
    RowBox[{
     RowBox[{"BoxData", "[", 
      RowBox[{"ToBoxes", "[", 
       RowBox[{"Style", "[", 
        RowBox[{
         RowBox[{"DynamicModule", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"searchstr", "=", "Null"}], "}"}], ",", 
           RowBox[{"Overlay", "[", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"Show", "[", 
                GraphicsBox[
                 TagBox[RasterBox[CompressedData["
1:eJztfXuwnfdVnWM7cUDBMgGZ4mtqJbGTSva9siXbsiRLsWzLkq3HlS1L1iO2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                   "], {{0, 54}, {3000, 0}}, {0, 255},
                   ColorFunction->RGBColor],
                  BoxForm`ImageTag[
                  "Byte", ColorSpace -> "RGB", Interleaving -> True],
                  Selectable->False],
                 BaseStyle->"ImageGraphics",
                 ImageSizeRaw->{3000, 54},
                 PlotRange->{{0, 3000}, {0, 54}}], "]"}], ",", 
               RowBox[{"Deploy", "[", 
                RowBox[{"Graphics", "[", 
                 RowBox[{
                  RowBox[{"{", 
                   RowBox[{"Inset", "[", 
                    RowBox[{
                    RowBox[{"Grid", "[", 
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"Spacer", "[", "32", "]"}], ",", 
                    "\[IndentingNewLine]", 
                    RowBox[{"Hyperlink", "[", 
                    RowBox[{
                    RowBox[{"Rasterize", "[", 
                    RowBox[{
                    RowBox[{"Graphics", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "0", "]"}], ",", 
                    RowBox[{"Raster", "[", 
                    RowBox[{"{", 
                    RowBox[{"{", "1", "}"}], "}"}], "]"}]}], "}"}], ",", 
                    RowBox[{"ImageSize", "\[Rule]", 
                    RowBox[{"{", 
                    RowBox[{"130", ",", "30"}], "}"}]}]}], "]"}], ",", " ", 
                    RowBox[{"Background", "\[Rule]", "None"}]}], "]"}], ",", 
                    " ", "\"\<http://www.wolfram.com/\>\""}], "]"}], ",", 
                    "\[IndentingNewLine]", 
                    RowBox[{"Spacer", "[", "35", "]"}], ",", 
                    RowBox[{"Mouseover", "[", 
                    RowBox[{
                    RowBox[{"Hyperlink", "[", 
                    RowBox[{
                    RowBox[{"Rasterize", "[", 
                    RowBox[{
                    RowBox[{"Graphics", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"White", ",", 
                    RowBox[{"FontSize", "\[Rule]", "11"}], ",", 
                    RowBox[{"FontFamily", "\[Rule]", "\"\<Arial\>\""}], ",", 
                    RowBox[{"Opacity", "[", "1", "]"}], ",", 
                    RowBox[{"Text", "[", "\"\<\:4ea7\:54c1\>\"", "]"}]}], 
                    "}"}], ",", 
                    RowBox[{"ImageSize", "\[Rule]", 
                    RowBox[{"{", 
                    RowBox[{"24", ",", "30"}], "}"}]}]}], "]"}], ",", 
                    RowBox[{"Background", "\[Rule]", "None"}]}], "]"}], ",", 
                    " ", "\"\<http://www.wolfram.com/products/\>\""}], "]"}], 
                    ",", 
                    RowBox[{"Hyperlink", "[", 
                    RowBox[{
                    RowBox[{"Rasterize", "[", 
                    RowBox[{
                    RowBox[{"Graphics", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"RGBColor", "[", 
                    RowBox[{".86", ",", ".01", ",", "0"}], "]"}], ",", 
                    RowBox[{"FontSize", "\[Rule]", "11"}], ",", 
                    RowBox[{"FontFamily", "\[Rule]", "\"\<Arial\>\""}], ",", 
                    RowBox[{"Opacity", "[", "1", "]"}], ",", 
                    RowBox[{"Text", "[", "\"\<\:4ea7\:54c1\>\"", "]"}]}], 
                    "}"}], ",", 
                    RowBox[{"ImageSize", "\[Rule]", 
                    RowBox[{"{", 
                    RowBox[{"24", ",", "30"}], "}"}]}]}], "]"}], ",", 
                    RowBox[{"Background", "\[Rule]", "None"}]}], "]"}], ",", 
                    " ", "\"\<http://www.wolfram.com/products/\>\""}], 
                    "]"}]}], "]"}], ",", "\[IndentingNewLine]", 
                    RowBox[{"Spacer", "[", "25", "]"}], ",", 
                    "\[IndentingNewLine]", 
                    RowBox[{"Mouseover", "[", 
                    RowBox[{
                    RowBox[{"Hyperlink", "[", 
                    RowBox[{
                    RowBox[{"Rasterize", "[", 
                    RowBox[{
                    RowBox[{"Graphics", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"White", ",", 
                    RowBox[{"FontSize", "\[Rule]", "11"}], ",", 
                    RowBox[{"FontFamily", "\[Rule]", "\"\<Arial\>\""}], ",", 
                    RowBox[{"Opacity", "[", "1", "]"}], ",", 
                    RowBox[{
                    "Text", "[", "\"\<\:89e3\:51b3\:65b9\:6848\>\"", "]"}]}], 
                    "}"}], ",", 
                    RowBox[{"ImageSize", "\[Rule]", 
                    RowBox[{"{", 
                    RowBox[{"48", ",", "30"}], "}"}]}]}], "]"}], ",", 
                    RowBox[{"Background", "\[Rule]", "None"}]}], "]"}], ",", 
                    " ", "\"\<http://www.wolfram.com/solutions/\>\""}], "]"}],
                     ",", 
                    RowBox[{"Hyperlink", "[", 
                    RowBox[{
                    RowBox[{"Rasterize", "[", 
                    RowBox[{
                    RowBox[{"Graphics", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"RGBColor", "[", 
                    RowBox[{".86", ",", ".01", ",", "0"}], "]"}], ",", 
                    RowBox[{"FontSize", "\[Rule]", "11"}], ",", 
                    RowBox[{"FontFamily", "\[Rule]", "\"\<Arial\>\""}], ",", 
                    RowBox[{"Opacity", "[", "1", "]"}], ",", 
                    RowBox[{
                    "Text", "[", "\"\<\:89e3\:51b3\:65b9\:6848\>\"", "]"}]}], 
                    "}"}], ",", 
                    RowBox[{"ImageSize", "\[Rule]", 
                    RowBox[{"{", 
                    RowBox[{"48", ",", "30"}], "}"}]}]}], "]"}], ",", 
                    RowBox[{"Background", "\[Rule]", "None"}]}], "]"}], ",", 
                    " ", "\"\<http://www.wolfram.com/solutions/\>\""}], 
                    "]"}]}], "]"}], ",", " ", "\[IndentingNewLine]", 
                    RowBox[{"Spacer", "[", "25", "]"}], ",", 
                    "\[IndentingNewLine]", 
                    RowBox[{"Mouseover", "[", 
                    RowBox[{
                    RowBox[{"Hyperlink", "[", 
                    RowBox[{
                    RowBox[{"Rasterize", "[", 
                    RowBox[{
                    RowBox[{"Graphics", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"White", ",", 
                    RowBox[{"FontSize", "\[Rule]", "11"}], ",", 
                    RowBox[{"FontFamily", "\[Rule]", "\"\<Arial\>\""}], ",", 
                    RowBox[{"Opacity", "[", "1", "]"}], ",", 
                    RowBox[{"Text", "[", "\"\<\:8d2d\:4e70\>\"", "]"}]}], 
                    "}"}], ",", " ", 
                    RowBox[{"ImageSize", "\[Rule]", 
                    RowBox[{"{", 
                    RowBox[{"24", ",", "30"}], "}"}]}]}], "]"}], ",", 
                    RowBox[{"Background", "\[Rule]", "None"}]}], "]"}], ",", 
                    " ", "\"\<http://www.wolfram.com/mathematica/how-to-buy/\>\
\""}], "]"}], ",", 
                    RowBox[{"Hyperlink", "[", 
                    RowBox[{
                    RowBox[{"Rasterize", "[", 
                    RowBox[{
                    RowBox[{"Graphics", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"RGBColor", "[", 
                    RowBox[{".86", ",", ".01", ",", "0"}], "]"}], ",", 
                    RowBox[{"FontSize", "\[Rule]", "11"}], ",", 
                    RowBox[{"FontFamily", "\[Rule]", "\"\<Arial\>\""}], ",", 
                    RowBox[{"Opacity", "[", "1", "]"}], ",", 
                    RowBox[{"Text", "[", "\"\<\:8d2d\:4e70\>\"", "]"}]}], 
                    "}"}], ",", " ", 
                    RowBox[{"ImageSize", "\[Rule]", 
                    RowBox[{"{", 
                    RowBox[{"24", ",", "30"}], "}"}]}]}], "]"}], ",", 
                    RowBox[{"Background", "\[Rule]", "None"}]}], "]"}], ",", 
                    " ", "\"\<http://www.wolfram.com/mathematica/how-to-buy/\>\
\""}], "]"}]}], "]"}], ",", " ", "\[IndentingNewLine]", 
                    RowBox[{"Spacer", "[", "25", "]"}], ",", 
                    RowBox[{"Mouseover", "[", 
                    RowBox[{
                    RowBox[{"Hyperlink", "[", 
                    RowBox[{
                    RowBox[{"Rasterize", "[", 
                    RowBox[{
                    RowBox[{"Graphics", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"White", ",", 
                    RowBox[{"FontSize", "\[Rule]", "11"}], ",", 
                    RowBox[{"FontFamily", "\[Rule]", "\"\<Arial\>\""}], ",", 
                    RowBox[{"Opacity", "[", "1", "]"}], ",", 
                    RowBox[{
                    "Text", "[", "\"\<\:6280\:672f\:652f\:6301\>\"", "]"}]}], 
                    "}"}], ",", " ", 
                    RowBox[{"ImageSize", "\[Rule]", 
                    RowBox[{"{", 
                    RowBox[{"48", ",", "30"}], "}"}]}]}], "]"}], ",", 
                    RowBox[{"Background", "\[Rule]", "None"}]}], "]"}], ",", 
                    " ", "\"\<http://www.wolfram.com/support/\>\""}], "]"}], 
                    ",", " ", 
                    RowBox[{"Hyperlink", "[", 
                    RowBox[{
                    RowBox[{"Rasterize", "[", 
                    RowBox[{
                    RowBox[{"Graphics", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"RGBColor", "[", 
                    RowBox[{".86", ",", ".01", ",", "0"}], "]"}], ",", 
                    RowBox[{"FontSize", "\[Rule]", "11"}], ",", 
                    RowBox[{"FontFamily", "\[Rule]", "\"\<Arial\>\""}], ",", 
                    RowBox[{"Opacity", "[", "1", "]"}], ",", 
                    RowBox[{
                    "Text", "[", "\"\<\:6280\:672f\:652f\:6301\>\"", "]"}]}], 
                    "}"}], ",", " ", 
                    RowBox[{"ImageSize", "\[Rule]", 
                    RowBox[{"{", 
                    RowBox[{"48", ",", "30"}], "}"}]}]}], "]"}], ",", 
                    RowBox[{"Background", "\[Rule]", "None"}]}], "]"}], ",", 
                    " ", "\"\<http://www.wolfram.com/support/\>\""}], "]"}]}],
                     "]"}], ",", " ", "\[IndentingNewLine]", 
                    RowBox[{"Spacer", "[", "25", "]"}], ",", 
                    RowBox[{"Mouseover", "[", 
                    RowBox[{
                    RowBox[{"Hyperlink", "[", 
                    RowBox[{
                    RowBox[{"Rasterize", "[", 
                    RowBox[{
                    RowBox[{"Graphics", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"White", ",", 
                    RowBox[{"FontSize", "\[Rule]", "11"}], ",", 
                    RowBox[{"FontFamily", "\[Rule]", "\"\<Arial\>\""}], ",", 
                    RowBox[{"Opacity", "[", "1", "]"}], ",", 
                    RowBox[{
                    "Text", "[", "\"\<\:516c\:53f8\:6982\:51b5\>\"", "]"}]}], 
                    "}"}], ",", " ", 
                    RowBox[{"ImageSize", "\[Rule]", 
                    RowBox[{"{", 
                    RowBox[{"48", ",", "30"}], "}"}]}]}], "]"}], ",", 
                    RowBox[{"Background", "\[Rule]", "None"}]}], "]"}], ",", 
                    " ", "\"\<http://www.wolfram.com/company/\>\""}], "]"}], 
                    ",", " ", 
                    RowBox[{"Hyperlink", "[", 
                    RowBox[{
                    RowBox[{"Rasterize", "[", 
                    RowBox[{
                    RowBox[{"Graphics", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"RGBColor", "[", 
                    RowBox[{".86", ",", ".01", ",", "0"}], "]"}], ",", 
                    RowBox[{"FontSize", "\[Rule]", "11"}], ",", 
                    RowBox[{"FontFamily", "\[Rule]", "\"\<Arial\>\""}], ",", 
                    RowBox[{"Opacity", "[", "1", "]"}], ",", 
                    RowBox[{
                    "Text", "[", "\"\<\:516c\:53f8\:6982\:51b5\>\"", "]"}]}], 
                    "}"}], ",", " ", 
                    RowBox[{"ImageSize", "\[Rule]", 
                    RowBox[{"{", 
                    RowBox[{"48", ",", "30"}], "}"}]}]}], "]"}], ",", 
                    RowBox[{"Background", "\[Rule]", "None"}]}], "]"}], ",", 
                    " ", "\"\<http://www.wolfram.com/company/\>\""}], "]"}]}],
                     "]"}], ",", " ", "\[IndentingNewLine]", 
                    RowBox[{"Spacer", "[", "25", "]"}], ",", 
                    RowBox[{"Mouseover", "[", 
                    RowBox[{
                    RowBox[{"Hyperlink", "[", 
                    RowBox[{
                    RowBox[{"Rasterize", "[", 
                    RowBox[{
                    RowBox[{"Graphics", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"White", ",", 
                    RowBox[{"FontSize", "\[Rule]", "11"}], ",", 
                    RowBox[{"FontFamily", "\[Rule]", "\"\<Arial\>\""}], ",", 
                    RowBox[{"Opacity", "[", "1", "]"}], ",", 
                    RowBox[{
                    "Text", "[", "\"\<\:516c\:53f8\:7f51\:7ad9\>\"", "]"}]}], 
                    "}"}], ",", " ", 
                    RowBox[{"ImageSize", "\[Rule]", 
                    RowBox[{"{", 
                    RowBox[{"48", ",", "30"}], "}"}]}]}], "]"}], ",", 
                    RowBox[{"Background", "\[Rule]", "None"}]}], "]"}], ",", 
                    " ", "\"\<http://www.wolfram.com/webresources.html\>\""}],
                     "]"}], ",", " ", 
                    RowBox[{"Hyperlink", "[", 
                    RowBox[{
                    RowBox[{"Rasterize", "[", 
                    RowBox[{
                    RowBox[{"Graphics", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"RGBColor", "[", 
                    RowBox[{".86", ",", ".01", ",", "0"}], "]"}], ",", 
                    RowBox[{"FontSize", "\[Rule]", "11"}], ",", 
                    RowBox[{"FontFamily", "\[Rule]", "\"\<Arial\>\""}], ",", 
                    RowBox[{"Opacity", "[", "1", "]"}], ",", 
                    RowBox[{
                    "Text", "[", "\"\<\:516c\:53f8\:7f51\:7ad9\>\"", "]"}]}], 
                    "}"}], ",", " ", 
                    RowBox[{"ImageSize", "\[Rule]", 
                    RowBox[{"{", 
                    RowBox[{"48", ",", "30"}], "}"}]}]}], "]"}], ",", 
                    RowBox[{"Background", "\[Rule]", "None"}]}], "]"}], ",", 
                    " ", "\"\<http://www.wolfram.com/webresources.html\>\""}],
                     "]"}]}], "]"}], ",", "\[IndentingNewLine]", 
                    RowBox[{"Spacer", "[", "154", "]"}], ",", 
                    RowBox[{"Deploy", "[", 
                    RowBox[{"Graphics", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"Inset", "[", 
                    RowBox[{
                    RowBox[{"EventHandler", "[", 
                    RowBox[{
                    RowBox[{"Framed", "[", 
                    RowBox[{
                    RowBox[{"Style", "[", 
                    RowBox[{
                    RowBox[{"InputField", "[", 
                    RowBox[{
                    RowBox[{"Dynamic", "[", "searchstr", "]"}], ",", " ", 
                    "String", ",", 
                    RowBox[{"Appearance", "\[Rule]", "None"}], ",", 
                    RowBox[{"ContinuousAction", "\[Rule]", "True"}], ",", 
                    RowBox[{"FieldSize", "\[Rule]", 
                    RowBox[{"{", 
                    RowBox[{"20", ",", 
                    RowBox[{"{", 
                    RowBox[{"1", ",", "1"}], "}"}]}], "}"}]}], ",", 
                    RowBox[{"FieldHintStyle", "\[Rule]", 
                    RowBox[{"{", "12", "}"}]}], ",", " ", 
                    RowBox[{"FieldHint", "\[Rule]", "\"\<\:67e5\:627e\>\""}], 
                    ",", 
                    RowBox[{"DefaultFieldHintStyle", "\[Rule]", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0.73", ",", "0.73", ",", "0.73"}], "]"}], ",", 
                    RowBox[{"FontSize", "\[Rule]", "12"}], ",", 
                    RowBox[{"FontFamily", "\[Rule]", "\"\<Arial\>\""}]}], 
                    "}"}]}], ",", 
                    RowBox[{"BaseStyle", "\[Rule]", 
                    RowBox[{"{", 
                    RowBox[{"White", ",", " ", 
                    RowBox[{"FontSize", "\[Rule]", "12"}], ",", 
                    RowBox[{"FontFamily", "\[Rule]", "\"\<Arial\>\""}]}], 
                    "}"}]}], ",", 
                    RowBox[{"FieldHintStyle", "\[Rule]", 
                    RowBox[{"{", 
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0.73", ",", "0.73", ",", "0.73"}], "]"}], 
                    "}"}]}]}], "]"}], ",", " ", 
                    RowBox[{"ShowSelection", "\[Rule]", "True"}]}], "]"}], 
                    ",", 
                    RowBox[{"Background", "\[Rule]", 
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0.33", ",", "0.33", ",", "0.33"}], "]"}]}]}], 
                    "]"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"\"\<ReturnKeyDown\>\"", "\[RuleDelayed]", 
                    RowBox[{"NotebookLocate", "[", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"URL", "[", 
                    RowBox[{"\"\<http://search.wolfram.com/?query=\>\"", "<>", 
                    RowBox[{"ToString", "[", "searchstr", "]"}], "<>", 
                    "\"\<&x=0&y=0\>\""}], "]"}], ",", "None"}], "}"}], 
                    "]"}]}], ",", "\[IndentingNewLine]", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "\"\<MenuCommand\>\"", ",", "\"\<HandleShiftReturn\>\""}],
                     "}"}], "\[RuleDelayed]", 
                    RowBox[{"NotebookLocate", "[", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"URL", "[", 
                    RowBox[{"\"\<http://search.wolfram.com/?query=\>\"", "<>", 
                    RowBox[{"ToString", "[", "searchstr", "]"}], "<>", 
                    "\"\<&x=0&y=0\>\""}], "]"}], ",", "None"}], "}"}], 
                    "]"}]}], ",", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "\"\<MenuCommand\>\"", ",", "\"\<EvaluateCells\>\""}], 
                    "}"}], "\[RuleDelayed]", 
                    RowBox[{"NotebookLocate", "[", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"URL", "[", 
                    RowBox[{"\"\<http://search.wolfram.com/?query=\>\"", "<>", 
                    RowBox[{"ToString", "[", "searchstr", "]"}], "<>", 
                    "\"\<&x=0&y=0\>\""}], "]"}], ",", "None"}], "}"}], 
                    "]"}]}]}], "}"}]}], "]"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"105", ",", "8"}], "}"}]}], "]"}], ",", 
                    RowBox[{"Inset", "[", 
                    RowBox[{
                    RowBox[{"Button", "[", 
                    RowBox[{
                    RowBox[{"Rasterize", "[", 
                    RowBox[{
                    RowBox[{"Style", "[", 
                    RowBox[{"\"\<\[RightGuillemet]\>\"", ",", " ", 
                    RowBox[{"FontColor", "\[Rule]", "Gray"}], ",", 
                    RowBox[{"FontSize", "\[Rule]", "18"}]}], "]"}], ",", 
                    RowBox[{"Background", "\[Rule]", "None"}]}], "]"}], ",", 
                    " ", 
                    RowBox[{"NotebookLocate", "[", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"URL", "[", 
                    RowBox[{"\"\<http://search.wolfram.com/?query=\>\"", "<>", 
                    RowBox[{"ToString", "[", "searchstr", "]"}], "<>", 
                    "\"\<&x=0&y=0\>\""}], "]"}], ",", "None"}], "}"}], "]"}], 
                    ",", 
                    RowBox[{"Appearance", "\[Rule]", "None"}]}], "]"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"192", ",", "9"}], "}"}], ",", 
                    RowBox[{"ContentSelectable", "\[Rule]", "True"}]}], 
                    "]"}]}], "}"}], ",", " ", 
                    RowBox[{"ImageSize", "\[Rule]", 
                    RowBox[{"{", 
                    RowBox[{"200", ",", "15"}], "}"}]}], ",", 
                    RowBox[{"PlotRange", "->", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"0", ",", "200"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"0", ",", "15"}], "}"}]}], "}"}]}]}], "]"}], 
                    "]"}]}], "}"}], "}"}], "]"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"490", ",", "23"}], "}"}], ",", 
                    RowBox[{"ContentSelectable", "\[Rule]", "True"}]}], "]"}],
                    "}"}], ",", " ", 
                  RowBox[{"PlotRange", "->", 
                   RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"0", ",", "3000"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"0", ",", "53"}], "}"}]}], "}"}]}], ",", 
                  RowBox[{"ImageSize", "\[Rule]", 
                   RowBox[{"{", 
                    RowBox[{"3000", ",", "53"}], "}"}]}]}], "]"}], "]"}]}], 
              "}"}], ",", "All", ",", "2"}], "]"}]}], "]"}], ",", 
         RowBox[{"ShowSelection", "\[Rule]", "False"}]}], "]"}], "]"}], "]"}],
      ",", 
     RowBox[{"ShowCellBracket", "\[Rule]", "False"}], ",", 
     RowBox[{"CellMargins", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0", ",", "0"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "0"}], "}"}]}], "}"}]}], ",", 
     RowBox[{"PageWidth", "\[Rule]", "WindowWidth"}], ",", 
     RowBox[{"CellBracketOptions", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"\"\<Margins\>\"", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"0", ",", "2"}], "}"}]}], "}"}]}]}], " ", "]"}]}], 
  ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.520613398546525*^9, 3.520613505981382*^9}, 
   3.520613538376358*^9, {3.520614693880183*^9, 3.520614705496594*^9}, {
   3.5206148093271217`*^9, 3.520614878986607*^9}, {3.520614912569417*^9, 
   3.5206150669429483`*^9}, {3.5206151014942503`*^9, 3.520615203042798*^9}, {
   3.52061523887073*^9, 3.520615253588773*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"blackheadercell", "[", "lang_", "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", "}"}], ",", 
    RowBox[{"Switch", "[", 
     RowBox[{
     "lang", ",", "\"\<English\>\"", ",", " ", "blackheadercellen", ",", 
      "\"\<Japanese\>\"", ",", "blackheadercellja", ",", 
      "\"\<ChineseSimplified\>\"", ",", "blackheadercellzh", ",", " ", "_", 
      ",", "blackheadercellen"}], " ", "]"}]}], "]"}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.520356052796907*^9, 3.520356117234844*^9}, {
  3.520613551288581*^9, 3.52061356156845*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Powered by CDF Technology Cell", "Section",
 InitializationCell->True,
 CellChangeTimes->{{3.5091286882951527`*^9, 3.509128688999133*^9}, {
  3.514721803432283*^9, 3.5147218049446993`*^9}, {3.517921616319525*^9, 
  3.517921661760709*^9}, {3.517921772033362*^9, 3.51792178014533*^9}, {
  3.5179218571204987`*^9, 3.5179218665591927`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"poweredbybanneren", "=", 
   GraphicsBox[
    TagBox[RasterBox[CompressedData["
1:eJztmnts29UVx29Wt0QNbRzYugIdDaVaJ6aNQPdo/2B4nQoTSMNjSCAktgyJ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      "], {{0, 24}, {217, 0}}, {0, 255},
      ColorFunction->RGBColor],
     BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
     Selectable->False],
    BaseStyle->"ImageGraphics",
    ImageSize->Magnification[1],
    ImageSizeRaw->{217, 24},
    PlotRange->{{0, 217}, {0, 24}}]}], ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.520613956612843*^9, 3.520613956796636*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"poweredbybannerzh", "=", 
   GraphicsBox[RasterBox[CompressedData["
1:eJzdmntsU9cdx08Wh1pJk8jtxqCwrrhoTJ22Qr0H/MGmMdNNrTRYV6uof2xa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     "], {{0, 0}, {217, 24}}, {0, 
     255},
     ColorFunction->RGBColor],
    ImageSize->{217, 24},
    PlotRange->{{0, 217}, {0, 24}}]}], ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.520614120087305*^9, 3.5206141232323027`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"poweredbybanner", "[", "lang_", "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", "}"}], ",", 
     RowBox[{"Switch", "[", 
      RowBox[{
      "lang", ",", " ", "\"\<English\>\"", ",", "poweredbybanneren", ",", 
       " ", "\"\<Japanese\>\"", ",", " ", "poweredbybanneren", ",", " ", 
       "\"\<ChineseSimplified\>\"", ",", " ", "poweredbybannerzh", ",", " ", 
       "_", ",", " ", "poweredbybanneren"}], "]"}]}], "]"}]}], ";"}]], "Input",\

 InitializationCell->True,
 CellChangeTimes->{{3.520614001151877*^9, 3.520614050997161*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"poweredbybannercell", "[", "lang_", "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", "}"}], ",", 
     RowBox[{"Cell", "[", 
      RowBox[{
       RowBox[{"BoxData", "[", 
        RowBox[{"ToBoxes", "[", 
         RowBox[{"Style", "[", 
          RowBox[{
           RowBox[{"Graphics", "[", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"Inset", "[", 
               RowBox[{
                RowBox[{"Deploy", "[", 
                 RowBox[{"MouseAppearance", "[", 
                  RowBox[{
                   RowBox[{"Hyperlink", "[", 
                    RowBox[{
                    RowBox[{"Show", "[", 
                    RowBox[{"poweredbybanner", "[", "lang", "]"}], "]"}], ",",
                     " ", "\"\<http://www.wolfram.com/cdf\>\""}], "]"}], ",", 
                   " ", "\"\<LinkHand\>\""}], "]"}], "]"}], ",", 
                RowBox[{"{", 
                 RowBox[{"867", ",", "12"}], "}"}], ",", 
                RowBox[{"ContentSelectable", "\[Rule]", "True"}]}], "]"}], 
              "}"}], ",", 
             RowBox[{"ContentSelectable", "\[Rule]", "True"}], ",", 
             RowBox[{"PlotRange", "->", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"0", ",", "3000"}], "}"}], ",", 
                RowBox[{"{", 
                 RowBox[{"0", ",", "24"}], "}"}]}], "}"}]}], ",", 
             RowBox[{"ImageSize", "\[Rule]", 
              RowBox[{"{", 
               RowBox[{"3000", ",", "24"}], "}"}]}]}], "]"}], ",", 
           RowBox[{"ShowSelection", "\[Rule]", "False"}]}], "]"}], "]"}], 
        "]"}], ",", 
       RowBox[{"Deployed", "\[Rule]", "True"}], ",", 
       RowBox[{"ShowCellBracket", "\[Rule]", "False"}], ",", " ", 
       RowBox[{"CellFrame", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"0", ",", "0"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", "3"}], "}"}]}], "}"}]}], ",", " ", 
       RowBox[{"CellFrameColor", "\[Rule]", 
        RowBox[{"RGBColor", "[", 
         RowBox[{"0.89012", ",", "0", ",", "0"}], "]"}]}], ",", 
       RowBox[{"CellFrameLabelMargins", "\[Rule]", "0"}], ",", " ", 
       RowBox[{"CellMargins", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"0", ",", "0"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", "0"}], "}"}]}], "}"}]}], ",", 
       RowBox[{"CellFrameMargins", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"0", ",", "0"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", "0"}], "}"}]}], "}"}]}], " ", ",", 
       RowBox[{"PageWidth", "\[Rule]", "WindowWidth"}], ",", 
       RowBox[{"CellBracketOptions", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"\"\<Margins\>\"", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{"0", ",", "2"}], "}"}]}], "}"}]}]}], "]"}]}], "]"}]}], 
  ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.517857977312848*^9, 3.517858033204917*^9}, 
   3.51785807744814*^9, {3.517858136835784*^9, 3.5178581542129993`*^9}, 
   3.520179053021678*^9, 3.520179724663528*^9, {3.52018051398958*^9, 
   3.520180521332951*^9}, {3.520180905992872*^9, 3.520180924784134*^9}, {
   3.5201810820926247`*^9, 3.520181087180098*^9}, {3.520181193521717*^9, 
   3.520181206492909*^9}, {3.520181346871564*^9, 3.520181348253916*^9}, {
   3.5201814227013893`*^9, 3.5201814234195833`*^9}, {3.520181566687315*^9, 
   3.520181580670587*^9}, {3.520274469122252*^9, 3.520274581390231*^9}, {
   3.520613984462244*^9, 3.52061399550205*^9}, {3.5206141762934313`*^9, 
   3.520614177721498*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Large Documentation Search Cell", "Section",
 InitializationCell->True,
 CellChangeTimes->{{3.5091286882951527`*^9, 3.509128688999133*^9}, {
  3.514721803432283*^9, 3.5147218049446993`*^9}, {3.517921616319525*^9, 
  3.517921661760709*^9}, {3.517921772033362*^9, 3.51792178014533*^9}, {
  3.5179218571204987`*^9, 3.5179218937774153`*^9}, {3.5179219591500473`*^9, 
  3.517921961349888*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"searchbackgrounden", "=", 
   GraphicsBox[
    TagBox[RasterBox[CompressedData["
1:eJztnX1wVNXdxzvP88z06d86/qGtkEFCq6A+TlQGiROEOsWXR4i1CgEphFQG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      "], {{0, 86}, {
      717, 0}}, {0, 255},
      ColorFunction->RGBColor],
     BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
     Selectable->False],
    BaseStyle->"ImageGraphics",
    ImageSizeRaw->{717, 86},
    PlotRange->{{0, 717}, {0, 86}}]}], ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.520357303393323*^9, 3.520357334186804*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"searchbackgroundja", "=", 
   GraphicsBox[
    TagBox[RasterBox[CompressedData["
1:eJztnQtwVdW9h5l770xHrZUhMCiER0iCjYC5IBlRIy8jIIkKtFFBpFSsqJRW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      "], {{0, 86}, {717, 0}}, {0, 255},
      ColorFunction->RGBColor],
     BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
     Selectable->False],
    BaseStyle->"ImageGraphics",
    ImageSize->Automatic,
    ImageSizeRaw->{717, 86},
    PlotRange->{{0, 717}, {0, 86}}]}], ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.520357329047188*^9, 3.5203573487533617`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"searchbackgroundzh", "=", 
   GraphicsBox[
    TagBox[RasterBox[CompressedData["
1:eJztnXtwVeW5hzvnnJn2/OE4/FOrbUVIiCSQQuEkouRwwJJRUSqkgwoRLUFq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      "], {{0, 86}, {717, 0}}, {0, 255},
      ColorFunction->RGBColor],
     BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
     Selectable->False],
    BaseStyle->"ImageGraphics",
    ImageSizeRaw->{717, 86},
    PlotRange->{{0, 717}, {0, 86}}]}], ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.520960853941896*^9, 3.5209608540999517`*^9}, 
   3.520961482195919*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"searchbackground", "[", "lang_", "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", "}"}], ",", 
    RowBox[{"Switch", "[", 
     RowBox[{
     "lang", ",", " ", "\"\<English\>\"", ",", "searchbackgrounden", ",", 
      " ", "\"\<Japanese\>\"", ",", " ", "searchbackgroundja", ",", 
      "\"\<ChineseSimplified\>\"", ",", " ", "searchbackgroundzh", ",", " ", 
      "_", ",", " ", "searchbackgrounden"}], "]"}]}], "]"}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.52035735511547*^9, 3.520357409183249*^9}, {
  3.520960859697589*^9, 3.520960871705496*^9}, {3.521218783022956*^9, 
  3.521218784413209*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"searchworden", "=", 
   GraphicsBox[RasterBox[CompressedData["
1:eJztlvdKbVcQh4X8m5fIK+UR7gvkMRSx9+6xd8Xeu9ixd8Wu2HvBuvNl/3Cx
7y4nyYUEEs6Ah3H2KrPmm5m1fvn226/ffoqKivqZvxB/f+hWRCISkf+dvL29
XV1dfXx8OI2fn593d3f8Oo339/evr6//rnc+glfX19d/y5Pn5+eXl5d/zqUg
ub29dcXwx8QXh0uKiopCoVBJSUlZWdna2pqMY2Nj8fHxtbW1BQUF8/PzMk5N
TeXm5paXl2dmZp6cnGB5eHjIy8tjblJS0tDQEJaVlZXh4WEURi4tLUnhNy4u
LvQlLS0tWPLz89/f3y07yMnJyevr69olLS1NysTExPj4uHSSLTU1lV/009PT
qqoq2RcXFwcGBlC2t7dZhCOUlpZ2dHSQlixbXFysYQcHB9HR0VjMqW9ubmpq
ajg723V1dWkMpzBOTk9P45IWR0ZHR3FYutMB76zj4+OGhgZ9xQ28cqYca7JO
U1MTYcR5LBUVFVjMCoeHh9XV1WY8X7Gw3fn5uSzEWWHx4igsLISIhvX09Kyu
roovOYDy9PTEAEqAf81IQor++PiI27BmDEZ0+TA4OAgFMcJJpojv5eUlLumY
4puVleXKK8OX8GZnZ3v5yo1PW/ja2NjoDa/hS5qdnZ3J2N7eTqIavgSZM6an
pzv54r/ylgPi59HREaSUeE4WWpxyw5Mgvq5ZTr4KqfMrOOQGv3zCNwiSbM4x
RIyAc2p+MzIyUJx8Ozs7Nzc3fXGE52vZJbOwsDAzM0O6mu3gRRixqDAl1Ca+
1dXVmX2pmp2dHfFlMMHBc1I3PF8Sj4rr7+/38kX4hM+sQzPZ2Njwhld8Ly4u
Kisrzay9vb3W1lbDl5piDLrhS8QSExPVDRCuoQNbgvjW19cT0r/Ol69kOF4x
3aSl9iVVULgUiDORt+wKdfGlQsGKnV8wYWHBra0t1mRx4oPii+NP+c7OzjKL
glpeXjZzGUbO9PX14ZKLEfGn3p0Lii92yNLkCZHpz0VfwhjDl96Oz8TBly+Z
NjIywlIpKSkGh5cv1UrNmllkNZuKL+elORBPJ1/+pae5zqJOa5wEuvjS+akO
XA3Tn52zOA5c2tra4E5WK8hGaDLqqAwgAcSXStR08hwLdsagcN3QnMWXHGMK
dwoHIRS+ONRkCm3hXvDybW5u5jjYnTkJbpYif5xG/iUbffniBhe3/GRBOqcV
UL+kEzcRehBf9TcqV8OC+AKRkJoB4MZV8cWBubk5jE6+CoWpGo5AF/Kt397e
XlKFg4ThG6Y/U61mloTIEDrp+/v7ll/9yj02JQ30dnL2Z1oTjvniCF+/VD2x
pViIKo8ZbcrbGB0/sRNDbgSM3Fbqh758qTXzJGPxMP2Z7dSvgvjqaNS4ac5W
wP1LCShuutHoV9CkCWNXiFx86YF0BsvumZRn0P3LCnp9/RhfXOLJ5PwKHb2F
dnd3KQQrgC+tj1OrOVvf82VBlvXFEcSXkPL8yMnJManFdQMRdRI98xCatoxs
rb7hy5eXqvZFaCMiGxsbm/QltBrL5qsnt2XzJSVSbYmJiZGiU7N7QkKCmjOF
iZ3Ow2oonNTwpTGCEn84RXd3N9SgiSeEUVu4+KITE93v5v3sdHJyclJ89YYR
X68D3lnw5TLKsIXomZBKYMGOxJywMFJ82UXTKQ0NI+1xnsGGL9uxIJiInqLh
xeHLNyIRich/V34HZTZlqA==
     "], {{0, 0}, {160, 12}}, {0, 255},
     ColorFunction->RGBColor],
    ImageSize->{160, 12},
    PlotRange->{{0, 160}, {0, 12}}]}], ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.5212185762071447`*^9, 3.521218594207148*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"searchwordja", "=", 
   RowBox[{"ImageTake", "[", 
    RowBox[{
     RowBox[{"Rasterize", "[", 
      RowBox[{"Cell", "[", 
       RowBox[{
       "\"\<\:30c9\:30ad\:30e5\:30e1\:30f3\:30c8\:30bb\:30f3\:30bf\:30fc\:691c\
\:7d22\>\"", ",", " ", "\"\<Text\>\"", ",", " ", 
        RowBox[{"FontColor", "\[Rule]", 
         RowBox[{"GrayLevel", "[", ".66", "]"}]}], ",", " ", 
        RowBox[{"CellMargins", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"0", ",", "0"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"0", ",", "0"}], "}"}]}], "}"}]}]}], "]"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "14"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", " ", "144"}], "}"}]}], "]"}]}], ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.521218602257146*^9, 3.521218609442594*^9}, {
   3.5212186405715303`*^9, 3.521218642703031*^9}, {3.521218894139901*^9, 
   3.5212189763309727`*^9}, {3.521219037680955*^9, 3.521219040159339*^9}, 
   3.521219091756831*^9, {3.521219126041336*^9, 3.52121918029027*^9}, {
   3.521219810464089*^9, 3.521219819887039*^9}, {3.5212198500836477`*^9, 
   3.521219854465723*^9}, {3.521220136597949*^9, 3.521220137094265*^9}, {
   3.521220248359226*^9, 3.521220351926399*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"searchwordzh", "=", 
   RowBox[{"Rasterize", "[", 
    RowBox[{"Cell", "[", 
     RowBox[{
     "\"\<\:53c2\:8003\:8d44\:6599\:4e2d\:5fc3\:641c\:7d22\>\"", ",", " ", 
      "\"\<Text\>\"", ",", " ", 
      RowBox[{"FontColor", "\[Rule]", 
       RowBox[{"GrayLevel", "[", ".66", "]"}]}]}], "]"}], "]"}]}], 
  ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.521218619666431*^9, 3.521218652509159*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"searchword", "[", "lang_", "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", "}"}], ",", 
    RowBox[{"Switch", "[", 
     RowBox[{
     "lang", ",", " ", "\"\<English\>\"", ",", "searchworden", ",", " ", 
      "\"\<Japanese\>\"", ",", " ", "searchwordja", ",", 
      "\"\<ChineseSimplified\>\"", ",", " ", "searchwordzh", ",", " ", "_", 
      ",", " ", "searchworden"}], "]"}]}], "]"}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.521218665324953*^9, 3.521218684727936*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"searchcell", "[", "lang_", "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", "}"}], ",", 
     RowBox[{"Cell", "[", 
      RowBox[{
       RowBox[{"BoxData", "[", 
        RowBox[{"ToBoxes", "[", 
         RowBox[{"Style", "[", 
          RowBox[{
           RowBox[{"DynamicModule", "[", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"searchrefstr", "=", "Null"}], "}"}], ",", 
             RowBox[{"Overlay", "[", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"Show", "[", 
                  RowBox[{"searchbackground", "[", "lang", "]"}], "]"}], ",", 
                 
                 RowBox[{"Graphics", "[", 
                  RowBox[{
                   RowBox[{"{", 
                    RowBox[{
                    RowBox[{"Inset", "[", 
                    RowBox[{
                    RowBox[{"Deploy", "[", 
                    RowBox[{"Style", "[", 
                    RowBox[{
                    RowBox[{"Grid", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{"Deploy", "[", 
                    RowBox[{"Button", "[", 
                    RowBox[{
                    RowBox[{"Style", "[", 
                    RowBox[{"Graphics", "[", 
                    RowBox[{
                    RowBox[{"{", "}"}], ",", 
                    RowBox[{"ImageSize", "\[Rule]", 
                    RowBox[{"{", 
                    RowBox[{"230", ",", "45"}], "}"}]}]}], "]"}], "]"}], ",", 
                    " ", 
                    RowBox[{"NotebookLocate", "[", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    "URL", "[", 
                    "\"\<http://reference.wolfram.com/mathematica/guide/\
Mathematica.cdf\>\"", "]"}], ",", "None"}], "}"}], "]"}], ",", 
                    RowBox[{"Appearance", "\[Rule]", "None"}]}], "]"}], "]"}],
                     "}"}], "}"}], ",", 
                    RowBox[{"Spacings", "\[Rule]", 
                    RowBox[{"{", 
                    RowBox[{"0", ",", "0"}], "}"}]}], ",", 
                    RowBox[{"Alignment", "\[Rule]", "Left"}]}], "]"}], ",", 
                    RowBox[{"ShowSelection", "\[Rule]", "True"}]}], "]"}], 
                    "]"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"132", ",", "45"}], "}"}], ",", 
                    RowBox[{"ContentSelectable", "\[Rule]", "True"}]}], "]"}],
                     ",", 
                    RowBox[{"Inset", "[", 
                    RowBox[{
                    RowBox[{"Deploy", "[", 
                    RowBox[{"Style", "[", 
                    RowBox[{
                    RowBox[{"Grid", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"Deploy", "[", 
                    RowBox[{"Graphics", "[", 
                    RowBox[{
                    RowBox[{"{", "}"}], ",", 
                    RowBox[{"ImageSize", "\[Rule]", 
                    RowBox[{"{", 
                    RowBox[{"200", ",", "22"}], "}"}]}]}], "]"}], "]"}], 
                    "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"searchword", "[", "lang", "]"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"EventHandler", "[", 
                    RowBox[{
                    RowBox[{"Framed", "[", 
                    RowBox[{
                    RowBox[{"InputField", "[", 
                    RowBox[{
                    RowBox[{"Dynamic", "[", "searchrefstr", "]"}], ",", 
                    "String", ",", 
                    RowBox[{"Appearance", "\[Rule]", "None"}], ",", 
                    RowBox[{"ContinuousAction", "\[Rule]", "True"}], ",", 
                    RowBox[{"BaseStyle", "\[Rule]", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"GrayLevel", "[", "0", "]"}], ",", 
                    RowBox[{"FontSize", "\[Rule]", "12"}], ",", 
                    RowBox[{"FontFamily", "\[Rule]", "\"\<Helvetica\>\""}]}], 
                    "}"}]}], ",", 
                    RowBox[{"FieldHintStyle", "\[Rule]", 
                    RowBox[{"{", "}"}]}], ",", 
                    RowBox[{"FieldSize", "\[Rule]", "28"}], ",", " ", 
                    RowBox[{"ImageSize", "\[Rule]", "280"}]}], "]"}], ",", 
                    RowBox[{"FrameMargins", "\[Rule]", "0"}], ",", 
                    RowBox[{"FrameStyle", "\[Rule]", 
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0.73", ",", "0.73", ",", "0.73"}], "]"}]}]}], 
                    "]"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"\"\<ReturnKeyDown\>\"", "\[RuleDelayed]", 
                    RowBox[{"NotebookLocate", "[", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"URL", "[", 
                    RowBox[{
                    "\"\<http://reference.wolfram.com/search.html?collection=\
reference&lang=en&query=\>\"", "<>", 
                    RowBox[{"ToString", "[", "searchrefstr", "]"}], "<>", 
                    "\"\<&cdf=true\>\""}], "]"}], ",", "None"}], "}"}], 
                    "]"}]}], ",", "\[IndentingNewLine]", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "\"\<MenuCommand\>\"", ",", "\"\<HandleShiftReturn\>\""}],
                     "}"}], "\[RuleDelayed]", 
                    RowBox[{"NotebookLocate", "[", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"URL", "[", 
                    RowBox[{
                    "\"\<http://reference.wolfram.com/search.html?collection=\
reference&lang=en&query=\>\"", "<>", 
                    RowBox[{"ToString", "[", "searchrefstr", "]"}], "<>", 
                    "\"\<&cdf=true\>\""}], "]"}], ",", "None"}], "}"}], 
                    "]"}]}], ",", "\[IndentingNewLine]", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "\"\<MenuCommand\>\"", ",", "\"\<EvaluateCells\>\""}], 
                    "}"}], "\[RuleDelayed]", 
                    RowBox[{"NotebookLocate", "[", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"URL", "[", 
                    RowBox[{
                    "\"\<http://reference.wolfram.com/search.html?collection=\
reference&lang=en&query=\>\"", "<>", 
                    RowBox[{"ToString", "[", "searchrefstr", "]"}], "<>", 
                    "\"\<&cdf=true\>\""}], "]"}], ",", "None"}], "}"}], 
                    "]"}]}]}], "}"}]}], "]"}], "}"}]}], "}"}], ",", 
                    RowBox[{"Spacings", "\[Rule]", 
                    RowBox[{"{", 
                    RowBox[{"0", ",", "0"}], "}"}]}], ",", 
                    RowBox[{"Alignment", "\[Rule]", "Left"}]}], "]"}], ",", 
                    RowBox[{"ShowSelection", "\[Rule]", "True"}]}], "]"}], 
                    "]"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"549", ",", "55"}], "}"}], ",", 
                    RowBox[{"ContentSelectable", "\[Rule]", "True"}]}], "]"}],
                     ",", 
                    RowBox[{"Inset", "[", 
                    RowBox[{
                    RowBox[{"Button", "[", 
                    RowBox[{
                    RowBox[{"Style", "[", 
                    RowBox[{"\"\<\[RightGuillemet]\>\"", ",", " ", 
                    RowBox[{"FontColor", "\[Rule]", "Gray"}], ",", 
                    RowBox[{"FontSize", "\[Rule]", "14"}]}], "]"}], ",", " ", 
                    
                    RowBox[{"NotebookLocate", "[", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"URL", "[", 
                    RowBox[{
                    
                    "\"\<http://reference.wolfram.com/search.html?collection=\
reference&lang=en&query=\>\"", "<>", 
                    RowBox[{"ToString", "[", "searchrefstr", "]"}], "<>", 
                    "\"\<&cdf=true\>\""}], "]"}], ",", "None"}], "}"}], "]"}],
                     ",", 
                    RowBox[{"Appearance", "\[Rule]", "None"}]}], "]"}], ",", 
                    " ", 
                    RowBox[{"{", 
                    RowBox[{"685", ",", "40"}], "}"}], ",", 
                    RowBox[{"ContentSelectable", "\[Rule]", "True"}]}], 
                    "]"}]}], "}"}], ",", 
                   RowBox[{"ContentSelectable", "\[Rule]", "True"}], ",", 
                   RowBox[{"PlotRange", "->", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"0", ",", "717"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"0", ",", "86"}], "}"}]}], "}"}]}], ",", 
                   RowBox[{"ImageSize", "\[Rule]", 
                    RowBox[{"{", 
                    RowBox[{"717", ",", "86"}], "}"}]}]}], "]"}]}], "}"}], 
               ",", "All", ",", "2"}], "]"}]}], "]"}], ",", 
           RowBox[{"ShowSelection", "\[Rule]", "False"}]}], "]"}], "]"}], 
        "]"}], ",", 
       RowBox[{"CellMargins", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"64", ",", "0"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", "20"}], "}"}]}], "}"}]}], ",", 
       RowBox[{"Deployed", "\[Rule]", "True"}], ",", 
       RowBox[{"ShowCellBracket", "\[Rule]", "False"}]}], " ", "]"}]}], 
    "]"}]}], ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.512222318583869*^9, 3.51222231858664*^9}, {
   3.512222374927518*^9, 3.512222405814343*^9}, 3.512222685356122*^9, {
   3.512222770340972*^9, 3.5122227739639797`*^9}, {3.512223868013253*^9, 
   3.512223896830401*^9}, 3.512224000018216*^9, {3.512224053771718*^9, 
   3.512224064497752*^9}, {3.512224383792429*^9, 3.512224411740226*^9}, 
   3.512404956437654*^9, {3.512412381256789*^9, 3.512412409295314*^9}, 
   3.513016838515954*^9, 3.513017028885898*^9, {3.513017156817594*^9, 
   3.51301715711189*^9}, {3.516457276304205*^9, 3.51645728626054*^9}, {
   3.516459635629591*^9, 3.516459637198277*^9}, {3.5197549619850807`*^9, 
   3.5197549951522923`*^9}, {3.520357274417348*^9, 3.520357288273177*^9}, {
   3.5203574184403257`*^9, 3.520357420296275*^9}, {3.521218693912094*^9, 
   3.521218695173325*^9}, {3.521219296053945*^9, 3.521219360285407*^9}, {
   3.521219423206493*^9, 3.521219428851821*^9}, {3.5212194603349648`*^9, 
   3.521219546023031*^9}, {3.521219658955682*^9, 3.52121966422803*^9}, 
   3.521219698038891*^9, {3.521219771308465*^9, 3.5212198015186853`*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Format: HTML | CDF Toggle Cell", "Section",
 InitializationCell->True,
 CellChangeTimes->{{3.5091286882951527`*^9, 3.509128688999133*^9}, {
  3.514721803432283*^9, 3.5147218049446993`*^9}, {3.517921616319525*^9, 
  3.517921661760709*^9}, {3.517921772033362*^9, 3.51792178014533*^9}, {
  3.5179218571204987`*^9, 3.5179218937774153`*^9}, {3.5179219273015537`*^9, 
  3.517921946709152*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"VersionCDFCell", "[", 
    RowBox[{"uri_String", ",", " ", "lang_"}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", "}"}], ",", 
     RowBox[{"Cell", "[", 
      RowBox[{
       RowBox[{"TextData", "[", 
        RowBox[{"{", "\n", " ", 
         RowBox[{
          RowBox[{"StyleBox", "[", 
           RowBox[{
            RowBox[{"CDFLocalized", "[", 
             RowBox[{"\"\<Format:\>\"", ",", " ", "lang"}], "]"}], ",", "\n", 
            "  ", 
            RowBox[{"FontFamily", "->", "\"\<Arial Bold\>\""}], ",", "\n", 
            "  ", 
            RowBox[{"FontSize", "\[Rule]", "10"}], ",", "\n", "  ", 
            RowBox[{"FontColor", "->", 
             RowBox[{"GrayLevel", "[", "0.6", "]"}]}]}], "]"}], ",", "\n", 
          " ", "\"\<  \>\"", ",", 
          RowBox[{"Cell", "[", 
           RowBox[{
            RowBox[{"BoxData", "[", "\n", "  ", 
             RowBox[{"TagBox", "[", "\n", "   ", 
              RowBox[{
               RowBox[{"ButtonBox", "[", "\n", "    ", 
                RowBox[{
                 RowBox[{"PaneSelectorBox", "[", 
                  RowBox[{
                   RowBox[{"{", 
                    RowBox[{
                    RowBox[{"False", "->", 
                    RowBox[{"StyleBox", "[", 
                    RowBox[{
                    "\"\<\\<\\\"HTML\\\"\\>\>\"", ",", " ", 
                    "\"\<HyperlinkActive\>\""}], "]"}]}], ",", " ", 
                    RowBox[{"True", "->", "\n", "     ", 
                    RowBox[{"StyleBox", "[", 
                    RowBox[{
                    "\"\<\\<\\\"HTML\\\"\\>\>\"", ",", " ", 
                    "\"\<HyperlinkActive\>\""}], "]"}]}]}], "}"}], ",", " ", 
                   RowBox[{"Dynamic", "[", "\n", "      ", 
                    RowBox[{"CurrentValue", "[", "\"\<MouseOver\>\"", "]"}], 
                    "]"}], ",", "\n", "     ", 
                   RowBox[{"BaseStyle", "->", 
                    RowBox[{"{", "\"\<Hyperlink\>\"", "}"}]}], ",", "\n", 
                   "     ", 
                   RowBox[{"BaselinePosition", "->", "Baseline"}], ",", "\n", 
                   "     ", 
                   RowBox[{"FrameMargins", "->", "0"}], ",", "\n", "     ", 
                   RowBox[{"ImageSize", "->", "Automatic"}]}], "]"}], ",", 
                 "\n", "    ", 
                 RowBox[{"BaseStyle", "->", "\"\<Hyperlink\>\""}], ",", "\n", 
                 "    ", 
                 RowBox[{"ButtonData", "->", 
                  RowBox[{"{", "\n", "      ", 
                   RowBox[{
                    RowBox[{"URL", "[", 
                    RowBox[{
                    "\"\<http://reference.wolfram.com/mathematica/\>\"", "<>",
                     "uri", "<>", "\"\<.html\>\""}], "]"}], ",", " ", 
                    "None"}], "}"}]}], ",", "\n", "    ", 
                 RowBox[{"ButtonNote", "->", 
                  RowBox[{
                  "\"\<http://reference.wolfram.com/mathematica/\>\"", "<>", 
                   "uri", "<>", "\"\<.html\>\""}]}]}], "]"}], ",", "\n", 
               "   ", 
               RowBox[{
                RowBox[{"Annotation", "[", 
                 RowBox[{"#", ",", " ", "\n", "    ", 
                  RowBox[{
                  "\"\<http://reference.wolfram.com/mathematica/\>\"", "<>", 
                   "uri", "<>", "\"\<.html\>\""}], ",", " ", 
                  "\"\<Hyperlink\>\""}], "]"}], "&"}]}], " ", "]"}], "]"}], 
            ",", "\n", "  ", 
            RowBox[{"FontFamily", "->", "\"\<Arial Bold\>\""}], ",", "\n", 
            "  ", 
            RowBox[{"FontSize", "\[Rule]", "10"}]}], "]"}], ",", "\n", " ", 
          RowBox[{"StyleBox", "[", 
           RowBox[{"\"\< \>\"", ",", "\n", "  ", 
            RowBox[{"FontSize", "->", "11"}]}], "]"}], ",", "\n", " ", 
          RowBox[{"StyleBox", "[", 
           RowBox[{"\"\<|\>\"", ",", "\n", "  ", 
            RowBox[{"FontFamily", "->", "\"\<Arial Bold\>\""}], ",", "\n", 
            "  ", 
            RowBox[{"FontSize", "\[Rule]", "12"}], ",", 
            RowBox[{"FontColor", "->", 
             RowBox[{"GrayLevel", "[", "0.6", "]"}]}]}], "]"}], ",", "\n", 
          " ", 
          RowBox[{"StyleBox", "[", 
           RowBox[{"\"\< \>\"", ",", "\n", "  ", 
            RowBox[{"FontSize", "->", "11"}]}], "]"}], ",", "\n", " ", 
          RowBox[{"StyleBox", "[", 
           RowBox[{"\"\<CDF\>\"", ",", "\n", "  ", 
            RowBox[{"FontFamily", "->", "\"\<Arial Bold\>\""}], ",", "\n", 
            "  ", 
            RowBox[{"FontSize", "\[Rule]", "10"}], ",", "\n", "  ", 
            RowBox[{"FontColor", "->", 
             RowBox[{"GrayLevel", "[", "0.6", "]"}]}]}], "]"}]}], "\n", "}"}],
         "]"}], ",", " ", "\"\<Text\>\"", ",", "\n", " ", 
       RowBox[{"ShowCellBracket", "->", "False"}], ",", "\n", " ", 
       RowBox[{"CellMargins", "\[Rule]", 
        RowBox[{"Switch", "[", 
         RowBox[{"lang", ",", "\"\<English\>\"", ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"668", ",", " ", "0"}], "}"}], ",", " ", 
            RowBox[{"{", 
             RowBox[{"15", ",", " ", "0"}], "}"}]}], "}"}], ",", " ", 
          "\"\<Japanese\>\"", ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"641", ",", " ", "0"}], "}"}], ",", " ", 
            RowBox[{"{", 
             RowBox[{"15", ",", " ", "0"}], "}"}]}], "}"}], ",", 
          "\"\<ChineseSimplified\>\"", ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"681", ",", " ", "0"}], "}"}], ",", " ", 
            RowBox[{"{", 
             RowBox[{"15", ",", " ", "0"}], "}"}]}], "}"}], ",", "_", ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"668", ",", " ", "0"}], "}"}], ",", " ", 
            RowBox[{"{", 
             RowBox[{"15", ",", " ", "0"}], "}"}]}], "}"}]}], "]"}]}], ",", 
       " ", 
       RowBox[{"CellFrame", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"0", ",", "0"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", "0"}], "}"}]}], "}"}]}], ",", 
       RowBox[{"CellFrameLabelMargins", "\[Rule]", "0"}], ",", 
       RowBox[{"CellFrameMargins", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"0", ",", "0"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", "0"}], "}"}]}], "}"}]}]}], "]"}]}], "]"}]}], 
  ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.5130169297233763`*^9, 3.513017008894533*^9}, {
   3.516456568624971*^9, 3.516456577211369*^9}, {3.516461118396451*^9, 
   3.516461160084289*^9}, {3.516461193282889*^9, 3.516461222848865*^9}, 
   3.517745276651363*^9, {3.5179205799757833`*^9, 3.5179206507717857`*^9}, 
   3.5179206861650963`*^9, {3.517920750346005*^9, 3.517920843010648*^9}, {
   3.517920876971575*^9, 3.517920910658679*^9}, {3.517920980289379*^9, 
   3.517921106266857*^9}, {3.517922797578589*^9, 3.517922814401458*^9}, 
   3.5179229152582407`*^9, {3.517923376353744*^9, 3.5179233777057037`*^9}, 
   3.517923422839755*^9, 3.519496591118946*^9, {3.519754996243412*^9, 
   3.519754997679542*^9}, {3.5203568545340033`*^9, 3.520356893814604*^9}, {
   3.5203570761817627`*^9, 3.520357131395028*^9}, {3.520615403342782*^9, 
   3.520615417201004*^9}, {3.520615447370154*^9, 3.520615481285375*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Click to Interact", "Section",
 InitializationCell->True,
 CellChangeTimes->{{3.5091286882951527`*^9, 3.509128688999133*^9}, {
  3.514721803432283*^9, 3.5147218049446993`*^9}, {3.517921616319525*^9, 
  3.517921661760709*^9}, {3.517921772033362*^9, 3.51792178014533*^9}, {
  3.5179218571204987`*^9, 3.5179218937774153`*^9}, {3.5179219273015537`*^9, 
  3.517921946709152*^9}, {3.5206179829867973`*^9, 3.520617986032956*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"ClicktoInteract", "[", 
    RowBox[{
     RowBox[{"{", "lang_", "}"}], ",", 
     RowBox[{"{", "a___", "}"}], ",", 
     RowBox[{"{", "b___", "}"}], ",", 
     RowBox[{"{", "c___", "}"}], ",", 
     RowBox[{"{", "d___", "}"}]}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", "}"}], ",", 
     RowBox[{"Switch", "[", 
      RowBox[{"lang", ",", "\"\<English\>\"", ",", 
       RowBox[{"Cell", "[", 
        RowBox[{
         RowBox[{"BoxData", "[", 
          RowBox[{"ToBoxes", "[", 
           RowBox[{"Button", "[", 
            RowBox[{
             RowBox[{"DynamicModule", "[", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{"display", "=", 
                 RowBox[{"{", "1", "}"}]}], "}"}], ",", 
               RowBox[{"EventHandler", "[", 
                RowBox[{
                 RowBox[{"Dynamic", "[", 
                  RowBox[{"Overlay", "[", 
                   RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"RawBoxes", "[", 
                    RowBox[{"Cell", "[", 
                    RowBox[{
                    "a", ",", "\"\<Output\>\"", ",", "b", ",", "c", ",", 
                    "d"}], "]"}], "]"}], ",", 
                    RowBox[{"RawBoxes", "[", 
                    RowBox[{"Cell", "[", 
                    RowBox[{"BoxData", "[", 
                    RowBox[{"FrameBox", "[", 
                    RowBox[{
                    RowBox[{"StyleBox", "[", 
                    RowBox[{
                    "\"\<\\<\\\"Click to Interact\\\"\\>\>\"", ",", 
                    "\"\<Label\>\"", ",", 
                    RowBox[{"StripOnInput", "\[Rule]", "False"}], ",", 
                    RowBox[{"LineColor", "\[Rule]", 
                    RowBox[{"GrayLevel", "[", "1", "]"}]}], ",", 
                    RowBox[{"FrontFaceColor", "\[Rule]", 
                    RowBox[{"GrayLevel", "[", "1", "]"}]}], ",", 
                    RowBox[{"BackFaceColor", "\[Rule]", 
                    RowBox[{"GrayLevel", "[", "1", "]"}]}], ",", 
                    RowBox[{"GraphicsColor", "\[Rule]", 
                    RowBox[{"GrayLevel", "[", "1", "]"}]}], ",", 
                    RowBox[{"FontSize", "\[Rule]", "11.5"}], ",", 
                    RowBox[{"FontColor", "\[Rule]", 
                    RowBox[{"GrayLevel", "[", "1", "]"}]}]}], "]"}], ",", 
                    RowBox[{"Background", "\[Rule]", 
                    RowBox[{"GrayLevel", "[", 
                    RowBox[{"0", ",", "0.4"}], "]"}]}], ",", 
                    RowBox[{"FrameMargins", "\[Rule]", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"5", ",", "5"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"3", ",", "3"}], "}"}]}], "}"}]}], ",", 
                    RowBox[{"FrameStyle", "\[Rule]", "None"}], ",", 
                    RowBox[{"RoundingRadius", "\[Rule]", "5"}], ",", 
                    RowBox[{"StripOnInput", "\[Rule]", "False"}]}], "]"}], 
                    "]"}], "]"}], "]"}]}], "}"}], ",", "display", ",", 
                    RowBox[{"Alignment", "\[Rule]", "Center"}]}], "]"}], 
                  "]"}], ",", 
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"\"\<MouseEntered\>\"", "\[RuleDelayed]", 
                    RowBox[{"(", 
                    RowBox[{"display", "=", 
                    RowBox[{"{", 
                    RowBox[{"1", ",", "2"}], "}"}]}], ")"}]}], ",", 
                   RowBox[{"\"\<MouseExited\>\"", "\[RuleDelayed]", 
                    RowBox[{"(", 
                    RowBox[{"display", "=", 
                    RowBox[{"{", "1", "}"}]}], ")"}]}]}], "}"}]}], "]"}]}], 
              "]"}], ",", 
             RowBox[{
              RowBox[{"SelectionMove", "[", 
               RowBox[{
                RowBox[{"ButtonNotebook", "[", "]"}], ",", "All", ",", 
                "ButtonCell"}], "]"}], ";", "\[IndentingNewLine]", 
              RowBox[{"SelectionMove", "[", 
               RowBox[{
                RowBox[{"ButtonNotebook", "[", "]"}], ",", "All", ",", 
                "CellGroup", ",", "2"}], "]"}], ";", "\[IndentingNewLine]", 
              RowBox[{"SelectionEvaluate", "[", 
               RowBox[{"EvaluationNotebook", "[", "]"}], "]"}]}], ",", 
             RowBox[{"Appearance", "\[Rule]", "None"}]}], "]"}], "]"}], "]"}],
          ",", " ", "\"\<Output\>\"", ",", "b", ",", "c", ",", "d"}], "]"}], 
       ",", "\[IndentingNewLine]", "\"\<Japanese\>\"", ",", 
       RowBox[{"Cell", "[", 
        RowBox[{
         RowBox[{"BoxData", "[", 
          RowBox[{"ToBoxes", "[", 
           RowBox[{"Button", "[", 
            RowBox[{
             RowBox[{"DynamicModule", "[", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{"display", "=", 
                 RowBox[{"{", "1", "}"}]}], "}"}], ",", 
               RowBox[{"EventHandler", "[", 
                RowBox[{
                 RowBox[{"Dynamic", "[", 
                  RowBox[{"Overlay", "[", 
                   RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"RawBoxes", "[", 
                    RowBox[{"Cell", "[", 
                    RowBox[{
                    "a", ",", "\"\<Output\>\"", ",", "b", ",", "c", ",", 
                    "d"}], "]"}], "]"}], ",", 
                    RowBox[{"RawBoxes", "[", 
                    RowBox[{"Cell", "[", 
                    RowBox[{"BoxData", "[", 
                    RowBox[{"FrameBox", "[", 
                    RowBox[{
                    RowBox[{"StyleBox", "[", 
                    RowBox[{
                    "\"\<\\<\\\"\:30af\:30ea\:30c3\:30af\:3057\:3066\:30a4\
\:30f3\:30bf\:30e9\:30af\:30c6\:30a3\:30d6\:306b\:3059\:308b\\\"\\>\>\"", 
                    ",", "\"\<Label\>\"", ",", 
                    RowBox[{"StripOnInput", "\[Rule]", "False"}], ",", 
                    RowBox[{"LineColor", "\[Rule]", 
                    RowBox[{"GrayLevel", "[", "1", "]"}]}], ",", 
                    RowBox[{"FrontFaceColor", "\[Rule]", 
                    RowBox[{"GrayLevel", "[", "1", "]"}]}], ",", 
                    RowBox[{"BackFaceColor", "\[Rule]", 
                    RowBox[{"GrayLevel", "[", "1", "]"}]}], ",", 
                    RowBox[{"GraphicsColor", "\[Rule]", 
                    RowBox[{"GrayLevel", "[", "1", "]"}]}], ",", 
                    RowBox[{"FontSize", "\[Rule]", "11.5"}], ",", 
                    RowBox[{"FontColor", "\[Rule]", 
                    RowBox[{"GrayLevel", "[", "1", "]"}]}]}], "]"}], ",", 
                    RowBox[{"Background", "\[Rule]", 
                    RowBox[{"GrayLevel", "[", 
                    RowBox[{"0", ",", "0.4"}], "]"}]}], ",", 
                    RowBox[{"FrameMargins", "\[Rule]", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"5", ",", "5"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"3", ",", "3"}], "}"}]}], "}"}]}], ",", 
                    RowBox[{"FrameStyle", "\[Rule]", "None"}], ",", 
                    RowBox[{"RoundingRadius", "\[Rule]", "5"}], ",", 
                    RowBox[{"StripOnInput", "\[Rule]", "False"}]}], "]"}], 
                    "]"}], "]"}], "]"}]}], "}"}], ",", "display", ",", 
                    RowBox[{"Alignment", "\[Rule]", "Center"}]}], "]"}], 
                  "]"}], ",", 
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"\"\<MouseEntered\>\"", "\[RuleDelayed]", 
                    RowBox[{"(", 
                    RowBox[{"display", "=", 
                    RowBox[{"{", 
                    RowBox[{"1", ",", "2"}], "}"}]}], ")"}]}], ",", 
                   RowBox[{"\"\<MouseExited\>\"", "\[RuleDelayed]", 
                    RowBox[{"(", 
                    RowBox[{"display", "=", 
                    RowBox[{"{", "1", "}"}]}], ")"}]}]}], "}"}]}], "]"}]}], 
              "]"}], ",", 
             RowBox[{
              RowBox[{"SelectionMove", "[", 
               RowBox[{
                RowBox[{"ButtonNotebook", "[", "]"}], ",", "All", ",", 
                "ButtonCell"}], "]"}], ";", "\[IndentingNewLine]", 
              RowBox[{"SelectionMove", "[", 
               RowBox[{
                RowBox[{"ButtonNotebook", "[", "]"}], ",", "All", ",", 
                "CellGroup", ",", "2"}], "]"}], ";", "\[IndentingNewLine]", 
              RowBox[{"SelectionEvaluate", "[", 
               RowBox[{"EvaluationNotebook", "[", "]"}], "]"}]}], ",", 
             RowBox[{"Appearance", "\[Rule]", "None"}]}], "]"}], "]"}], "]"}],
          ",", " ", "\"\<Output\>\"", ",", "b", ",", "c", ",", "d"}], "]"}], 
       ",", "\[IndentingNewLine]", "\"\<ChineseSimplified\>\"", ",", 
       RowBox[{"Cell", "[", 
        RowBox[{
         RowBox[{"BoxData", "[", 
          RowBox[{"ToBoxes", "[", 
           RowBox[{"Button", "[", 
            RowBox[{
             RowBox[{"DynamicModule", "[", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{"display", "=", 
                 RowBox[{"{", "1", "}"}]}], "}"}], ",", 
               RowBox[{"EventHandler", "[", 
                RowBox[{
                 RowBox[{"Dynamic", "[", 
                  RowBox[{"Overlay", "[", 
                   RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"RawBoxes", "[", 
                    RowBox[{"Cell", "[", 
                    RowBox[{
                    "a", ",", "\"\<Output\>\"", ",", "b", ",", "c", ",", 
                    "d"}], "]"}], "]"}], ",", 
                    RowBox[{"RawBoxes", "[", 
                    RowBox[{"Cell", "[", 
                    RowBox[{"BoxData", "[", 
                    RowBox[{"FrameBox", "[", 
                    RowBox[{
                    RowBox[{"StyleBox", "[", 
                    RowBox[{
                    "\"\<\\<\\\"\:70b9\:51fb\:4ee5\:4e92\:52a8\\\"\\>\>\"", 
                    ",", "\"\<Label\>\"", ",", 
                    RowBox[{"StripOnInput", "\[Rule]", "False"}], ",", 
                    RowBox[{"LineColor", "\[Rule]", 
                    RowBox[{"GrayLevel", "[", "1", "]"}]}], ",", 
                    RowBox[{"FrontFaceColor", "\[Rule]", 
                    RowBox[{"GrayLevel", "[", "1", "]"}]}], ",", 
                    RowBox[{"BackFaceColor", "\[Rule]", 
                    RowBox[{"GrayLevel", "[", "1", "]"}]}], ",", 
                    RowBox[{"GraphicsColor", "\[Rule]", 
                    RowBox[{"GrayLevel", "[", "1", "]"}]}], ",", 
                    RowBox[{"FontSize", "\[Rule]", "11.5"}], ",", 
                    RowBox[{"FontColor", "\[Rule]", 
                    RowBox[{"GrayLevel", "[", "1", "]"}]}]}], "]"}], ",", 
                    RowBox[{"Background", "\[Rule]", 
                    RowBox[{"GrayLevel", "[", 
                    RowBox[{"0", ",", "0.4"}], "]"}]}], ",", 
                    RowBox[{"FrameMargins", "\[Rule]", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"5", ",", "5"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"3", ",", "3"}], "}"}]}], "}"}]}], ",", 
                    RowBox[{"FrameStyle", "\[Rule]", "None"}], ",", 
                    RowBox[{"RoundingRadius", "\[Rule]", "5"}], ",", 
                    RowBox[{"StripOnInput", "\[Rule]", "False"}]}], "]"}], 
                    "]"}], "]"}], "]"}]}], "}"}], ",", "display", ",", 
                    RowBox[{"Alignment", "\[Rule]", "Center"}]}], "]"}], 
                  "]"}], ",", 
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"\"\<MouseEntered\>\"", "\[RuleDelayed]", 
                    RowBox[{"(", 
                    RowBox[{"display", "=", 
                    RowBox[{"{", 
                    RowBox[{"1", ",", "2"}], "}"}]}], ")"}]}], ",", 
                   RowBox[{"\"\<MouseExited\>\"", "\[RuleDelayed]", 
                    RowBox[{"(", 
                    RowBox[{"display", "=", 
                    RowBox[{"{", "1", "}"}]}], ")"}]}]}], "}"}]}], "]"}]}], 
              "]"}], ",", 
             RowBox[{
              RowBox[{"SelectionMove", "[", 
               RowBox[{
                RowBox[{"ButtonNotebook", "[", "]"}], ",", "All", ",", 
                "ButtonCell"}], "]"}], ";", "\[IndentingNewLine]", 
              RowBox[{"SelectionMove", "[", 
               RowBox[{
                RowBox[{"ButtonNotebook", "[", "]"}], ",", "All", ",", 
                "CellGroup", ",", "2"}], "]"}], ";", "\[IndentingNewLine]", 
              RowBox[{"SelectionEvaluate", "[", 
               RowBox[{"EvaluationNotebook", "[", "]"}], "]"}]}], ",", 
             RowBox[{"Appearance", "\[Rule]", "None"}]}], "]"}], "]"}], "]"}],
          ",", " ", "\"\<Output\>\"", ",", "b", ",", "c", ",", "d"}], "]"}], 
       ",", "\[IndentingNewLine]", "_", ",", 
       RowBox[{"Cell", "[", 
        RowBox[{
         RowBox[{"BoxData", "[", 
          RowBox[{"ToBoxes", "[", 
           RowBox[{"Button", "[", 
            RowBox[{
             RowBox[{"DynamicModule", "[", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{"display", "=", 
                 RowBox[{"{", "1", "}"}]}], "}"}], ",", 
               RowBox[{"EventHandler", "[", 
                RowBox[{
                 RowBox[{"Dynamic", "[", 
                  RowBox[{"Overlay", "[", 
                   RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"RawBoxes", "[", 
                    RowBox[{"Cell", "[", 
                    RowBox[{
                    "a", ",", "\"\<Output\>\"", ",", "b", ",", "c", ",", 
                    "d"}], "]"}], "]"}], ",", 
                    RowBox[{"RawBoxes", "[", 
                    RowBox[{"Cell", "[", 
                    RowBox[{"BoxData", "[", 
                    RowBox[{"FrameBox", "[", 
                    RowBox[{
                    RowBox[{"StyleBox", "[", 
                    RowBox[{
                    "\"\<\\<\\\"Click to Interact\\\"\\>\>\"", ",", 
                    "\"\<Label\>\"", ",", 
                    RowBox[{"StripOnInput", "\[Rule]", "False"}], ",", 
                    RowBox[{"LineColor", "\[Rule]", 
                    RowBox[{"GrayLevel", "[", "1", "]"}]}], ",", 
                    RowBox[{"FrontFaceColor", "\[Rule]", 
                    RowBox[{"GrayLevel", "[", "1", "]"}]}], ",", 
                    RowBox[{"BackFaceColor", "\[Rule]", 
                    RowBox[{"GrayLevel", "[", "1", "]"}]}], ",", 
                    RowBox[{"GraphicsColor", "\[Rule]", 
                    RowBox[{"GrayLevel", "[", "1", "]"}]}], ",", 
                    RowBox[{"FontSize", "\[Rule]", "11.5"}], ",", 
                    RowBox[{"FontColor", "\[Rule]", 
                    RowBox[{"GrayLevel", "[", "1", "]"}]}]}], "]"}], ",", 
                    RowBox[{"Background", "\[Rule]", 
                    RowBox[{"GrayLevel", "[", 
                    RowBox[{"0", ",", "0.4"}], "]"}]}], ",", 
                    RowBox[{"FrameMargins", "\[Rule]", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"5", ",", "5"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"3", ",", "3"}], "}"}]}], "}"}]}], ",", 
                    RowBox[{"FrameStyle", "\[Rule]", "None"}], ",", 
                    RowBox[{"RoundingRadius", "\[Rule]", "5"}], ",", 
                    RowBox[{"StripOnInput", "\[Rule]", "False"}]}], "]"}], 
                    "]"}], "]"}], "]"}]}], "}"}], ",", "display", ",", 
                    RowBox[{"Alignment", "\[Rule]", "Center"}]}], "]"}], 
                  "]"}], ",", 
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"\"\<MouseEntered\>\"", "\[RuleDelayed]", 
                    RowBox[{"(", 
                    RowBox[{"display", "=", 
                    RowBox[{"{", 
                    RowBox[{"1", ",", "2"}], "}"}]}], ")"}]}], ",", 
                   RowBox[{"\"\<MouseExited\>\"", "\[RuleDelayed]", 
                    RowBox[{"(", 
                    RowBox[{"display", "=", 
                    RowBox[{"{", "1", "}"}]}], ")"}]}]}], "}"}]}], "]"}]}], 
              "]"}], ",", 
             RowBox[{
              RowBox[{"SelectionMove", "[", 
               RowBox[{
                RowBox[{"ButtonNotebook", "[", "]"}], ",", "All", ",", 
                "ButtonCell"}], "]"}], ";", "\[IndentingNewLine]", 
              RowBox[{"SelectionMove", "[", 
               RowBox[{
                RowBox[{"ButtonNotebook", "[", "]"}], ",", "All", ",", 
                "CellGroup", ",", "2"}], "]"}], ";", "\[IndentingNewLine]", 
              RowBox[{"SelectionEvaluate", "[", 
               RowBox[{"EvaluationNotebook", "[", "]"}], "]"}]}], ",", 
             RowBox[{"Appearance", "\[Rule]", "None"}]}], "]"}], "]"}], "]"}],
          ",", " ", "\"\<Output\>\"", ",", "b", ",", "c", ",", "d"}], "]"}]}],
       "]"}]}], "]"}]}], ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.5130169297233763`*^9, 3.513017008894533*^9}, {
   3.516456568624971*^9, 3.516456577211369*^9}, {3.516461118396451*^9, 
   3.516461160084289*^9}, {3.516461193282889*^9, 3.516461222848865*^9}, 
   3.517745276651363*^9, {3.5179205799757833`*^9, 3.5179206507717857`*^9}, 
   3.5179206861650963`*^9, {3.517920750346005*^9, 3.517920843010648*^9}, {
   3.517920876971575*^9, 3.517920910658679*^9}, {3.517920980289379*^9, 
   3.517921106266857*^9}, {3.517922797578589*^9, 3.517922814401458*^9}, 
   3.5179229152582407`*^9, {3.517923376353744*^9, 3.5179233777057037`*^9}, 
   3.517923422839755*^9, 3.519496591118946*^9, {3.519754996243412*^9, 
   3.519754997679542*^9}, {3.5203568545340033`*^9, 3.520356893814604*^9}, {
   3.5203570761817627`*^9, 3.520357131395028*^9}, {3.520615403342782*^9, 
   3.520615417201004*^9}, {3.520615447370154*^9, 3.520615481285375*^9}, {
   3.52061799105401*^9, 3.520618152120304*^9}, {3.520618632040884*^9, 
   3.520618648488604*^9}, {3.520618779474105*^9, 3.520618782696989*^9}, {
   3.520618826924366*^9, 3.520618827586369*^9}, {3.520618988964222*^9, 
   3.520619010048395*^9}, {3.52079293150078*^9, 3.520792948519577*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Standard Footer Cell", "Section",
 InitializationCell->True,
 CellChangeTimes->{{3.5091286882951527`*^9, 3.509128688999133*^9}, {
  3.514721803432283*^9, 3.5147218049446993`*^9}, {3.517921616319525*^9, 
  3.517921661760709*^9}, {3.517921772033362*^9, 3.51792178014533*^9}, {
  3.5179218571204987`*^9, 3.5179218937774153`*^9}, {3.5179219273015537`*^9, 
  3.517921946709152*^9}, {3.5179219797127*^9, 3.517921980911112*^9}, {
  3.5179220264267607`*^9, 3.517922028826651*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"footercell", "[", 
    RowBox[{"uri_String", ",", "lang_"}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", "}"}], ",", 
     RowBox[{"Switch", "[", 
      RowBox[{"lang", ",", " ", "\"\<English\>\"", ",", 
       RowBox[{"Cell", "[", 
        RowBox[{
         RowBox[{"BoxData", "[", 
          RowBox[{"StyleBox", "[", 
           RowBox[{
            RowBox[{"RowBox", "[", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"ButtonBox", "[", 
                RowBox[{
                 RowBox[{"RowBox", "[", 
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{"RowBox", "[", 
                    RowBox[{"{", 
                    RowBox[{
                    "\"\<\[Copyright]\>\"", ",", "\"\< \>\"", ",", 
                    "\"\<2011\>\"", ",", "\"\< \>\"", ",", "\"\<Wolfram\>\"", 
                    ",", "\"\< \>\"", ",", "\"\<Research\>\""}], "}"}], "]"}],
                     ",", "\"\<,\>\"", ",", "\"\< \>\"", ",", 
                    RowBox[{"RowBox", "[", 
                    RowBox[{"{", 
                    RowBox[{"\"\<Inc\>\"", ",", "\"\<.\>\""}], "}"}], "]"}]}],
                    "}"}], "]"}], ",", 
                 RowBox[{"BaseStyle", "\[Rule]", 
                  RowBox[{"{", 
                   RowBox[{"\"\<Hyperlink\>\"", ",", 
                    RowBox[{"GrayLevel", "[", "0.5", "]"}]}], "}"}]}], ",", 
                 RowBox[{"ButtonData", "\[Rule]", 
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{
                    "URL", "[", 
                    "\"\<http://www.wolfram.com/company/contact.cgi\>\"", 
                    "]"}], ",", "None"}], "}"}]}], ",", 
                 RowBox[{
                 "ButtonNote", "\[Rule]", 
                  "\"\<http://www.wolfram.com/company/contact.cgi\>\""}]}], 
                "]"}], ",", "\"\<  \>\"", ",", "\"\<\[Bullet]\>\"", ",", 
               "\"\<  \>\"", ",", 
               RowBox[{"ButtonBox", "[", 
                RowBox[{
                 RowBox[{"RowBox", "[", 
                  RowBox[{"{", 
                   RowBox[{
                   "\"\<Terms\>\"", ",", "\"\< \>\"", ",", "\"\<of\>\"", ",", 
                    "\"\< \>\"", ",", "\"\<Use\>\"", ",", "\"\< \>\""}], 
                   "}"}], "]"}], ",", 
                 RowBox[{"BaseStyle", "\[Rule]", 
                  RowBox[{"{", 
                   RowBox[{"\"\<Hyperlink\>\"", ",", 
                    RowBox[{"GrayLevel", "[", "0.5", "]"}]}], "}"}]}], ",", 
                 RowBox[{"ButtonData", "\[Rule]", 
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{
                    "URL", "[", 
                    "\"\<http://www.wolfram.com/legal/terms/wolfram-research.\
html\>\"", "]"}], ",", "None"}], "}"}]}], ",", 
                 RowBox[{
                 "ButtonNote", "\[Rule]", 
                  "\"\<http://www.wolfram.com/legal/terms/wolfram-research.\
html\>\""}]}], "]"}], ",", "\"\< \>\"", ",", "\"\<\[Bullet]\>\"", ",", 
               "\"\<  \>\"", ",", 
               RowBox[{"ButtonBox", "[", 
                RowBox[{
                 RowBox[{"RowBox", "[", 
                  RowBox[{"{", 
                   RowBox[{
                   "\"\<Privacy\>\"", ",", "\"\< \>\"", ",", 
                    "\"\<Policy\>\""}], "}"}], "]"}], ",", 
                 RowBox[{"BaseStyle", "\[Rule]", 
                  RowBox[{"{", 
                   RowBox[{"\"\<Hyperlink\>\"", ",", 
                    RowBox[{"GrayLevel", "[", "0.5", "]"}]}], "}"}]}], ",", 
                 RowBox[{"ButtonData", "\[Rule]", 
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{
                    "URL", "[", 
                    "\"\<http://www.wolfram.com/legal/privacy/wolfram-\
research.html\>\"", "]"}], ",", "None"}], "}"}]}], ",", 
                 RowBox[{
                 "ButtonNote", "\[Rule]", 
                  "\"\<http://www.wolfram.com/legal/privacy/wolfram-research.\
html\>\""}]}], "]"}], ",", "\"\<  \>\"", ",", "\"\<\[Bullet]\>\"", ",", 
               "\"\<  \>\"", ",", 
               RowBox[{"ButtonBox", "[", 
                RowBox[{
                 RowBox[{"RowBox", "[", 
                  RowBox[{"{", 
                   RowBox[{
                   "\"\<Site\>\"", ",", "\"\< \>\"", ",", "\"\<Index\>\""}], 
                   "}"}], "]"}], ",", 
                 RowBox[{"BaseStyle", "\[Rule]", 
                  RowBox[{"{", 
                   RowBox[{"\"\<Hyperlink\>\"", ",", 
                    RowBox[{"GrayLevel", "[", "0.5", "]"}]}], "}"}]}], ",", 
                 RowBox[{"ButtonData", "\[Rule]", 
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{
                    "URL", "[", 
                    "\"\<http://reference.wolfram.com/alphaindex/\>\"", "]"}],
                     ",", "None"}], "}"}]}], ",", 
                 RowBox[{
                 "ButtonNote", "\[Rule]", 
                  "\"\<http://reference.wolfram.com/alphaindex/\>\""}]}], 
                "]"}], ",", "\"\<               \>\"", ",", "\"\<Choose\>\"", 
               ",", "\"\< \>\"", ",", "\"\<Language\>\"", ",", 
               "\"\<     \>\"", ",", 
               RowBox[{"ButtonBox", "[", 
                RowBox[{
                 RowBox[{"StyleBox", "[", 
                  RowBox[{"\"\<\:65e5\:672c\:8a9e\>\"", ",", 
                   RowBox[{"FontSize", "\[Rule]", "11"}]}], "]"}], ",", 
                 RowBox[{"BaseStyle", "\[Rule]", 
                  RowBox[{"{", 
                   RowBox[{"\"\<Hyperlink\>\"", ",", 
                    RowBox[{"GrayLevel", "[", "0.5", "]"}]}], "}"}]}], ",", 
                 RowBox[{"ButtonData", "\[Rule]", 
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{"URL", "[", 
                    RowBox[{
                    "\"\<http://reference.wolfram.com/mathematica/\>\"", "<>",
                     "uri", "<>", "\"\<.ja.cdf\>\""}], "]"}], ",", "None"}], 
                   "}"}]}], ",", "\[IndentingNewLine]", 
                 RowBox[{"ButtonNote", "\[Rule]", 
                  RowBox[{
                  "\"\<http://reference.wolfram.com/mathematica/\>\"", "<>", 
                   "uri", "<>", "\"\<.ja.cdf\>\""}]}]}], "]"}], ",", " ", 
               "\"\<\[FilledRightTriangle]\>\"", ",", "\"\<     \>\"", ",", 
               " ", 
               RowBox[{"ButtonBox", "[", 
                RowBox[{
                 RowBox[{"StyleBox", "[", 
                  RowBox[{"\"\<\:4e2d\:6587\>\"", ",", 
                   RowBox[{"FontSize", "\[Rule]", "11"}]}], "]"}], ",", 
                 RowBox[{"BaseStyle", "\[Rule]", 
                  RowBox[{"{", 
                   RowBox[{"\"\<Hyperlink\>\"", ",", 
                    RowBox[{"GrayLevel", "[", "0.5", "]"}]}], "}"}]}], ",", 
                 RowBox[{"ButtonData", "\[Rule]", 
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{"URL", "[", 
                    RowBox[{
                    "\"\<http://reference.wolfram.com/mathematica/\>\"", "<>",
                     "uri", "<>", "\"\<.zh.cdf\>\""}], "]"}], ",", "None"}], 
                   "}"}]}], ",", 
                 RowBox[{"ButtonNote", "\[Rule]", 
                  RowBox[{
                  "\"\<http://reference.wolfram.com/mathematica/\>\"", "<>", 
                   "uri", "<>", "\"\<.zh.cdf\>\""}]}]}], "]"}], ",", " ", 
               "\"\<\[FilledRightTriangle]\>\""}], "}"}], "]"}], ",", 
            RowBox[{"StripOnInput", "\[Rule]", "False"}], ",", 
            RowBox[{"LineColor", "\[Rule]", 
             RowBox[{"GrayLevel", "[", "0.5", "]"}]}], ",", 
            RowBox[{"FrontFaceColor", "\[Rule]", 
             RowBox[{"GrayLevel", "[", "0.5", "]"}]}], ",", 
            RowBox[{"BackFaceColor", "\[Rule]", 
             RowBox[{"GrayLevel", "[", "0.5", "]"}]}], ",", 
            RowBox[{"GraphicsColor", "\[Rule]", 
             RowBox[{"GrayLevel", "[", "0.5", "]"}]}], ",", 
            RowBox[{"FontFamily", "\[Rule]", "\"\<Arial\>\""}], ",", 
            RowBox[{"FontSize", "\[Rule]", "9"}], ",", 
            RowBox[{"FontColor", "\[Rule]", 
             RowBox[{"GrayLevel", "[", "0.5", "]"}]}]}], "]"}], "]"}], ",", 
         "\"\<History\>\"", ",", 
         RowBox[{"CellFrame", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"0", ",", "0"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}], ",", 
         RowBox[{"CellMargins", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"72", ",", "25"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"20", ",", "0"}], "}"}]}], "}"}]}], ",", 
         RowBox[{"CellFrameColor", "\[Rule]", 
          RowBox[{"GrayLevel", "[", "0.8", "]"}]}]}], "]"}], ",", " ", 
       "\"\<Japanese\>\"", ",", " ", 
       RowBox[{"Cell", "[", 
        RowBox[{
         RowBox[{"BoxData", "[", 
          RowBox[{"StyleBox", "[", 
           RowBox[{
            RowBox[{"RowBox", "[", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"ButtonBox", "[", 
                RowBox[{
                 RowBox[{"RowBox", "[", 
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{"RowBox", "[", 
                    RowBox[{"{", 
                    RowBox[{
                    "\"\<\[Copyright]\>\"", ",", "\"\< \>\"", ",", 
                    "\"\<2011\>\"", ",", "\"\< \>\"", ",", "\"\<Wolfram\>\"", 
                    ",", "\"\< \>\"", ",", "\"\<Research\>\""}], "}"}], "]"}],
                     ",", "\"\<,\>\"", ",", "\"\< \>\"", ",", 
                    RowBox[{"RowBox", "[", 
                    RowBox[{"{", 
                    RowBox[{"\"\<Inc\>\"", ",", "\"\<.\>\""}], "}"}], "]"}]}],
                    "}"}], "]"}], ",", 
                 RowBox[{"BaseStyle", "\[Rule]", 
                  RowBox[{"{", 
                   RowBox[{"\"\<Hyperlink\>\"", ",", 
                    RowBox[{"GrayLevel", "[", "0.5", "]"}]}], "}"}]}], ",", 
                 RowBox[{"ButtonData", "\[Rule]", 
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{
                    "URL", "[", 
                    "\"\<http://www.wolfram.com/company/contact.cgi\>\"", 
                    "]"}], ",", "None"}], "}"}]}], ",", 
                 RowBox[{
                 "ButtonNote", "\[Rule]", 
                  "\"\<http://www.wolfram.com/company/contact.cgi\>\""}]}], 
                "]"}], ",", "\"\<  \>\"", ",", "\"\<\[Bullet]\>\"", ",", 
               "\"\<  \>\"", ",", 
               RowBox[{"ButtonBox", "[", 
                RowBox[{
                 RowBox[{"RowBox", "[", 
                  RowBox[{"{", 
                   RowBox[{
                   "\"\<Terms\>\"", ",", "\"\< \>\"", ",", "\"\<of\>\"", ",", 
                    "\"\< \>\"", ",", "\"\<Use\>\"", ",", "\"\< \>\""}], 
                   "}"}], "]"}], ",", 
                 RowBox[{"BaseStyle", "\[Rule]", 
                  RowBox[{"{", 
                   RowBox[{"\"\<Hyperlink\>\"", ",", 
                    RowBox[{"GrayLevel", "[", "0.5", "]"}]}], "}"}]}], ",", 
                 RowBox[{"ButtonData", "\[Rule]", 
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{
                    "URL", "[", 
                    "\"\<http://www.wolfram.com/legal/terms/wolfram-research.\
html\>\"", "]"}], ",", "None"}], "}"}]}], ",", 
                 RowBox[{
                 "ButtonNote", "\[Rule]", 
                  "\"\<http://www.wolfram.com/legal/terms/wolfram-research.\
html\>\""}]}], "]"}], ",", "\"\< \>\"", ",", "\"\<\[Bullet]\>\"", ",", 
               "\"\<  \>\"", ",", 
               RowBox[{"ButtonBox", "[", 
                RowBox[{
                 RowBox[{"RowBox", "[", 
                  RowBox[{"{", 
                   RowBox[{
                   "\"\<Privacy\>\"", ",", "\"\< \>\"", ",", 
                    "\"\<Policy\>\""}], "}"}], "]"}], ",", 
                 RowBox[{"BaseStyle", "\[Rule]", 
                  RowBox[{"{", 
                   RowBox[{"\"\<Hyperlink\>\"", ",", 
                    RowBox[{"GrayLevel", "[", "0.5", "]"}]}], "}"}]}], ",", 
                 RowBox[{"ButtonData", "\[Rule]", 
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{
                    "URL", "[", 
                    "\"\<http://www.wolfram.com/legal/privacy/wolfram-\
research.html\>\"", "]"}], ",", "None"}], "}"}]}], ",", 
                 RowBox[{
                 "ButtonNote", "\[Rule]", 
                  "\"\<http://www.wolfram.com/legal/privacy/wolfram-research.\
html\>\""}]}], "]"}], ",", "\"\<  \>\"", ",", "\"\<\[Bullet]\>\"", ",", 
               "\"\<  \>\"", ",", 
               RowBox[{"ButtonBox", "[", 
                RowBox[{
                 RowBox[{"RowBox", "[", 
                  RowBox[{
                  "{", "\"\<\:30b5\:30a4\:30c8\:30a4\:30f3\:30c7\:30c3\:30af\
\:30b9\>\"", "}"}], "]"}], ",", 
                 RowBox[{"BaseStyle", "\[Rule]", 
                  RowBox[{"{", 
                   RowBox[{"\"\<Hyperlink\>\"", ",", 
                    RowBox[{"GrayLevel", "[", "0.5", "]"}]}], "}"}]}], ",", 
                 RowBox[{"ButtonData", "\[Rule]", 
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{
                    "URL", "[", 
                    "\"\<http://reference.wolfram.com/alphaindex/\>\"", "]"}],
                     ",", "None"}], "}"}]}], ",", 
                 RowBox[{
                 "ButtonNote", "\[Rule]", 
                  "\"\<http://reference.wolfram.com/alphaindex/\>\""}]}], 
                "]"}], ",", "\"\<               \>\"", ",", 
               "\"\<\:8a00\:8a9e\>\"", ",", "\"\<     \>\"", ",", 
               RowBox[{"ButtonBox", "[", 
                RowBox[{
                 RowBox[{"StyleBox", "[", 
                  RowBox[{"\"\<English\>\"", ",", 
                   RowBox[{"FontSize", "\[Rule]", "11"}]}], "]"}], ",", 
                 RowBox[{"BaseStyle", "\[Rule]", 
                  RowBox[{"{", 
                   RowBox[{"\"\<Hyperlink\>\"", ",", 
                    RowBox[{"GrayLevel", "[", "0.5", "]"}]}], "}"}]}], ",", 
                 RowBox[{"ButtonData", "\[Rule]", 
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{"URL", "[", 
                    RowBox[{
                    "\"\<http://reference.wolfram.com/mathematica/\>\"", "<>",
                     "uri", "<>", "\"\<.en.cdf\>\""}], "]"}], ",", "None"}], 
                   "}"}]}], ",", "\[IndentingNewLine]", 
                 RowBox[{"ButtonNote", "\[Rule]", 
                  RowBox[{
                  "\"\<http://reference.wolfram.com/mathematica/\>\"", "<>", 
                   "uri", "<>", "\"\<.en.cdf\>\""}]}]}], "]"}], ",", " ", 
               "\"\<\[FilledRightTriangle]\>\"", ",", "\"\<     \>\"", ",", 
               " ", 
               RowBox[{"ButtonBox", "[", 
                RowBox[{
                 RowBox[{"StyleBox", "[", 
                  RowBox[{"\"\<\:4e2d\:6587\>\"", ",", 
                   RowBox[{"FontSize", "\[Rule]", "11"}]}], "]"}], ",", 
                 RowBox[{"BaseStyle", "\[Rule]", 
                  RowBox[{"{", 
                   RowBox[{"\"\<Hyperlink\>\"", ",", 
                    RowBox[{"GrayLevel", "[", "0.5", "]"}]}], "}"}]}], ",", 
                 RowBox[{"ButtonData", "\[Rule]", 
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{"URL", "[", 
                    RowBox[{
                    "\"\<http://reference.wolfram.com/mathematica/\>\"", "<>",
                     "uri", "<>", "\"\<.zh.cdf\>\""}], "]"}], ",", "None"}], 
                   "}"}]}], ",", 
                 RowBox[{"ButtonNote", "\[Rule]", 
                  RowBox[{
                  "\"\<http://reference.wolfram.com/mathematica/\>\"", "<>", 
                   "uri", "<>", "\"\<.zh.cdf\>\""}]}]}], "]"}], ",", " ", 
               "\"\<\[FilledRightTriangle]\>\""}], "}"}], "]"}], ",", 
            RowBox[{"StripOnInput", "\[Rule]", "False"}], ",", 
            RowBox[{"LineColor", "\[Rule]", 
             RowBox[{"GrayLevel", "[", "0.5", "]"}]}], ",", 
            RowBox[{"FrontFaceColor", "\[Rule]", 
             RowBox[{"GrayLevel", "[", "0.5", "]"}]}], ",", 
            RowBox[{"BackFaceColor", "\[Rule]", 
             RowBox[{"GrayLevel", "[", "0.5", "]"}]}], ",", 
            RowBox[{"GraphicsColor", "\[Rule]", 
             RowBox[{"GrayLevel", "[", "0.5", "]"}]}], ",", 
            RowBox[{"FontFamily", "\[Rule]", "\"\<Arial\>\""}], ",", 
            RowBox[{"FontSize", "\[Rule]", "10"}], ",", 
            RowBox[{"FontColor", "\[Rule]", 
             RowBox[{"GrayLevel", "[", "0.5", "]"}]}]}], "]"}], "]"}], ",", 
         "\"\<History\>\"", ",", 
         RowBox[{"CellFrame", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"0", ",", "0"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}], ",", 
         RowBox[{"CellMargins", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"72", ",", "25"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"20", ",", "0"}], "}"}]}], "}"}]}], ",", 
         RowBox[{"CellFrameColor", "\[Rule]", 
          RowBox[{"GrayLevel", "[", "0.8", "]"}]}]}], "]"}], ",", " ", 
       "\"\<ChineseSimplified\>\"", ",", " ", 
       RowBox[{"Cell", "[", 
        RowBox[{
         RowBox[{"BoxData", "[", 
          RowBox[{"StyleBox", "[", 
           RowBox[{
            RowBox[{"RowBox", "[", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"ButtonBox", "[", 
                RowBox[{
                 RowBox[{"RowBox", "[", 
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{"RowBox", "[", 
                    RowBox[{"{", 
                    RowBox[{
                    "\"\<\[Copyright]\>\"", ",", "\"\< \>\"", ",", 
                    "\"\<2011\>\"", ",", "\"\< \>\"", ",", "\"\<Wolfram\>\"", 
                    ",", "\"\< \>\"", ",", "\"\<Research\>\""}], "}"}], "]"}],
                     ",", "\"\<,\>\"", ",", "\"\< \>\"", ",", 
                    RowBox[{"RowBox", "[", 
                    RowBox[{"{", 
                    RowBox[{"\"\<Inc\>\"", ",", "\"\<.\>\""}], "}"}], "]"}]}],
                    "}"}], "]"}], ",", 
                 RowBox[{"BaseStyle", "\[Rule]", 
                  RowBox[{"{", 
                   RowBox[{"\"\<Hyperlink\>\"", ",", 
                    RowBox[{"GrayLevel", "[", "0.5", "]"}]}], "}"}]}], ",", 
                 RowBox[{"ButtonData", "\[Rule]", 
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{
                    "URL", "[", 
                    "\"\<http://www.wolfram.com/company/contact.cgi\>\"", 
                    "]"}], ",", "None"}], "}"}]}], ",", 
                 RowBox[{
                 "ButtonNote", "\[Rule]", 
                  "\"\<http://www.wolfram.com/company/contact.cgi\>\""}]}], 
                "]"}], ",", "\"\<  \>\"", ",", "\"\<\[Bullet]\>\"", ",", 
               "\"\<  \>\"", ",", 
               RowBox[{"ButtonBox", "[", 
                RowBox[{
                 RowBox[{"RowBox", "[", 
                  RowBox[{"{", "\"\<\:4f7f\:7528\:6761\:6b3e\>\"", "}"}], 
                  "]"}], ",", 
                 RowBox[{"BaseStyle", "\[Rule]", 
                  RowBox[{"{", 
                   RowBox[{"\"\<Hyperlink\>\"", ",", 
                    RowBox[{"GrayLevel", "[", "0.5", "]"}]}], "}"}]}], ",", 
                 RowBox[{"ButtonData", "\[Rule]", 
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{
                    "URL", "[", 
                    "\"\<http://www.wolfram.com/legal/terms/wolfram-research.\
html\>\"", "]"}], ",", "None"}], "}"}]}], ",", 
                 RowBox[{
                 "ButtonNote", "\[Rule]", 
                  "\"\<http://www.wolfram.com/legal/terms/wolfram-research.\
html\>\""}]}], "]"}], ",", "\"\< \>\"", ",", "\"\<\[Bullet]\>\"", ",", 
               "\"\<  \>\"", ",", 
               RowBox[{"ButtonBox", "[", 
                RowBox[{
                 RowBox[{"RowBox", "[", 
                  RowBox[{"{", "\"\<\:9690\:79c1\:653f\:7b56\>\"", "}"}], 
                  "]"}], ",", 
                 RowBox[{"BaseStyle", "\[Rule]", 
                  RowBox[{"{", 
                   RowBox[{"\"\<Hyperlink\>\"", ",", 
                    RowBox[{"GrayLevel", "[", "0.5", "]"}]}], "}"}]}], ",", 
                 RowBox[{"ButtonData", "\[Rule]", 
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{
                    "URL", "[", 
                    "\"\<http://www.wolfram.com/legal/privacy/wolfram-\
research.html\>\"", "]"}], ",", "None"}], "}"}]}], ",", 
                 RowBox[{
                 "ButtonNote", "\[Rule]", 
                  "\"\<http://www.wolfram.com/legal/privacy/wolfram-research.\
html\>\""}]}], "]"}], ",", "\"\<  \>\"", ",", "\"\<\[Bullet]\>\"", ",", 
               "\"\<  \>\"", ",", 
               RowBox[{"ButtonBox", "[", 
                RowBox[{
                 RowBox[{"RowBox", "[", 
                  RowBox[{"{", "\"\<\:7f51\:7ad9\:7d22\:5f15\>\"", "}"}], 
                  "]"}], ",", 
                 RowBox[{"BaseStyle", "\[Rule]", 
                  RowBox[{"{", 
                   RowBox[{"\"\<Hyperlink\>\"", ",", 
                    RowBox[{"GrayLevel", "[", "0.5", "]"}]}], "}"}]}], ",", 
                 RowBox[{"ButtonData", "\[Rule]", 
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{
                    "URL", "[", 
                    "\"\<http://reference.wolfram.com/alphaindex/\>\"", "]"}],
                     ",", "None"}], "}"}]}], ",", 
                 RowBox[{
                 "ButtonNote", "\[Rule]", 
                  "\"\<http://reference.wolfram.com/alphaindex/\>\""}]}], 
                "]"}], ",", "\"\<               \>\"", ",", 
               "\"\<\:9009\:62e9\:8bed\:8a00\>\"", ",", "\"\<     \>\"", ",", 
               
               RowBox[{"ButtonBox", "[", 
                RowBox[{
                 RowBox[{"StyleBox", "[", 
                  RowBox[{"\"\<English\>\"", ",", 
                   RowBox[{"FontSize", "\[Rule]", "11"}]}], "]"}], ",", 
                 RowBox[{"BaseStyle", "\[Rule]", 
                  RowBox[{"{", 
                   RowBox[{"\"\<Hyperlink\>\"", ",", 
                    RowBox[{"GrayLevel", "[", "0.5", "]"}]}], "}"}]}], ",", 
                 RowBox[{"ButtonData", "\[Rule]", 
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{"URL", "[", 
                    RowBox[{
                    "\"\<http://reference.wolfram.com/mathematica/\>\"", "<>",
                     "uri", "<>", "\"\<.en.cdf\>\""}], "]"}], ",", "None"}], 
                   "}"}]}], ",", "\[IndentingNewLine]", 
                 RowBox[{"ButtonNote", "\[Rule]", 
                  RowBox[{
                  "\"\<http://reference.wolfram.com/mathematica/\>\"", "<>", 
                   "uri", "<>", "\"\<.en.cdf\>\""}]}]}], "]"}], ",", " ", 
               "\"\<\[FilledRightTriangle]\>\"", ",", "\"\<     \>\"", ",", 
               " ", 
               RowBox[{"ButtonBox", "[", 
                RowBox[{
                 RowBox[{"StyleBox", "[", 
                  RowBox[{"\"\<\:65e5\:672c\:8a9e\>\"", ",", 
                   RowBox[{"FontSize", "\[Rule]", "11"}]}], "]"}], ",", 
                 RowBox[{"BaseStyle", "\[Rule]", 
                  RowBox[{"{", 
                   RowBox[{"\"\<Hyperlink\>\"", ",", 
                    RowBox[{"GrayLevel", "[", "0.5", "]"}]}], "}"}]}], ",", 
                 RowBox[{"ButtonData", "\[Rule]", 
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{"URL", "[", 
                    RowBox[{
                    "\"\<http://reference.wolfram.com/mathematica/\>\"", "<>",
                     "uri", "<>", "\"\<.ja.cdf\>\""}], "]"}], ",", "None"}], 
                   "}"}]}], ",", 
                 RowBox[{"ButtonNote", "\[Rule]", 
                  RowBox[{
                  "\"\<http://reference.wolfram.com/mathematica/\>\"", "<>", 
                   "uri", "<>", "\"\<.ja.cdf\>\""}]}]}], "]"}], ",", " ", 
               "\"\<\[FilledRightTriangle]\>\""}], "}"}], "]"}], ",", 
            RowBox[{"StripOnInput", "\[Rule]", "False"}], ",", 
            RowBox[{"LineColor", "\[Rule]", 
             RowBox[{"GrayLevel", "[", "0.5", "]"}]}], ",", 
            RowBox[{"FrontFaceColor", "\[Rule]", 
             RowBox[{"GrayLevel", "[", "0.5", "]"}]}], ",", 
            RowBox[{"BackFaceColor", "\[Rule]", 
             RowBox[{"GrayLevel", "[", "0.5", "]"}]}], ",", 
            RowBox[{"GraphicsColor", "\[Rule]", 
             RowBox[{"GrayLevel", "[", "0.5", "]"}]}], ",", 
            RowBox[{"FontFamily", "\[Rule]", "\"\<Arial\>\""}], ",", 
            RowBox[{"FontSize", "\[Rule]", "10"}], ",", 
            RowBox[{"FontColor", "\[Rule]", 
             RowBox[{"GrayLevel", "[", "0.5", "]"}]}]}], "]"}], "]"}], ",", 
         "\"\<History\>\"", ",", 
         RowBox[{"CellFrame", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"0", ",", "0"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}], ",", 
         RowBox[{"CellMargins", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"72", ",", "25"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"20", ",", "0"}], "}"}]}], "}"}]}], ",", 
         RowBox[{"CellFrameColor", "\[Rule]", 
          RowBox[{"GrayLevel", "[", "0.8", "]"}]}]}], "]"}], ",", " ", "_", 
       ",", 
       RowBox[{"Cell", "[", 
        RowBox[{
         RowBox[{"BoxData", "[", 
          RowBox[{"StyleBox", "[", 
           RowBox[{
            RowBox[{"RowBox", "[", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"ButtonBox", "[", 
                RowBox[{
                 RowBox[{"RowBox", "[", 
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{"RowBox", "[", 
                    RowBox[{"{", 
                    RowBox[{
                    "\"\<\[Copyright]\>\"", ",", "\"\< \>\"", ",", 
                    "\"\<2011\>\"", ",", "\"\< \>\"", ",", "\"\<Wolfram\>\"", 
                    ",", "\"\< \>\"", ",", "\"\<Research\>\""}], "}"}], "]"}],
                     ",", "\"\<,\>\"", ",", "\"\< \>\"", ",", 
                    RowBox[{"RowBox", "[", 
                    RowBox[{"{", 
                    RowBox[{"\"\<Inc\>\"", ",", "\"\<.\>\""}], "}"}], "]"}]}],
                    "}"}], "]"}], ",", 
                 RowBox[{"BaseStyle", "\[Rule]", 
                  RowBox[{"{", 
                   RowBox[{"\"\<Hyperlink\>\"", ",", 
                    RowBox[{"GrayLevel", "[", "0.5", "]"}]}], "}"}]}], ",", 
                 RowBox[{"ButtonData", "\[Rule]", 
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{
                    "URL", "[", 
                    "\"\<http://www.wolfram.com/company/contact.cgi\>\"", 
                    "]"}], ",", "None"}], "}"}]}], ",", 
                 RowBox[{
                 "ButtonNote", "\[Rule]", 
                  "\"\<http://www.wolfram.com/company/contact.cgi\>\""}]}], 
                "]"}], ",", "\"\<  \>\"", ",", "\"\<\[Bullet]\>\"", ",", 
               "\"\<  \>\"", ",", 
               RowBox[{"ButtonBox", "[", 
                RowBox[{
                 RowBox[{"RowBox", "[", 
                  RowBox[{"{", 
                   RowBox[{
                   "\"\<Terms\>\"", ",", "\"\< \>\"", ",", "\"\<of\>\"", ",", 
                    "\"\< \>\"", ",", "\"\<Use\>\"", ",", "\"\< \>\""}], 
                   "}"}], "]"}], ",", 
                 RowBox[{"BaseStyle", "\[Rule]", 
                  RowBox[{"{", 
                   RowBox[{"\"\<Hyperlink\>\"", ",", 
                    RowBox[{"GrayLevel", "[", "0.5", "]"}]}], "}"}]}], ",", 
                 RowBox[{"ButtonData", "\[Rule]", 
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{
                    "URL", "[", 
                    "\"\<http://www.wolfram.com/legal/terms/wolfram-research.\
html\>\"", "]"}], ",", "None"}], "}"}]}], ",", 
                 RowBox[{
                 "ButtonNote", "\[Rule]", 
                  "\"\<http://www.wolfram.com/legal/terms/wolfram-research.\
html\>\""}]}], "]"}], ",", "\"\< \>\"", ",", "\"\<\[Bullet]\>\"", ",", 
               "\"\<  \>\"", ",", 
               RowBox[{"ButtonBox", "[", 
                RowBox[{
                 RowBox[{"RowBox", "[", 
                  RowBox[{"{", 
                   RowBox[{
                   "\"\<Privacy\>\"", ",", "\"\< \>\"", ",", 
                    "\"\<Policy\>\""}], "}"}], "]"}], ",", 
                 RowBox[{"BaseStyle", "\[Rule]", 
                  RowBox[{"{", 
                   RowBox[{"\"\<Hyperlink\>\"", ",", 
                    RowBox[{"GrayLevel", "[", "0.5", "]"}]}], "}"}]}], ",", 
                 RowBox[{"ButtonData", "\[Rule]", 
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{
                    "URL", "[", 
                    "\"\<http://www.wolfram.com/legal/privacy/wolfram-\
research.html\>\"", "]"}], ",", "None"}], "}"}]}], ",", 
                 RowBox[{
                 "ButtonNote", "\[Rule]", 
                  "\"\<http://www.wolfram.com/legal/privacy/wolfram-research.\
html\>\""}]}], "]"}], ",", "\"\<  \>\"", ",", "\"\<\[Bullet]\>\"", ",", 
               "\"\<  \>\"", ",", 
               RowBox[{"ButtonBox", "[", 
                RowBox[{
                 RowBox[{"RowBox", "[", 
                  RowBox[{"{", 
                   RowBox[{
                   "\"\<Site\>\"", ",", "\"\< \>\"", ",", "\"\<Index\>\""}], 
                   "}"}], "]"}], ",", 
                 RowBox[{"BaseStyle", "\[Rule]", 
                  RowBox[{"{", 
                   RowBox[{"\"\<Hyperlink\>\"", ",", 
                    RowBox[{"GrayLevel", "[", "0.5", "]"}]}], "}"}]}], ",", 
                 RowBox[{"ButtonData", "\[Rule]", 
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{
                    "URL", "[", 
                    "\"\<http://reference.wolfram.com/alphaindex/\>\"", "]"}],
                     ",", "None"}], "}"}]}], ",", 
                 RowBox[{
                 "ButtonNote", "\[Rule]", 
                  "\"\<http://reference.wolfram.com/alphaindex/\>\""}]}], 
                "]"}], ",", "\"\<               \>\"", ",", "\"\<Choose\>\"", 
               ",", "\"\< \>\"", ",", "\"\<Language\>\"", ",", 
               "\"\<     \>\"", ",", 
               RowBox[{"ButtonBox", "[", 
                RowBox[{
                 RowBox[{"StyleBox", "[", 
                  RowBox[{"\"\<\:65e5\:672c\:8a9e\>\"", ",", 
                   RowBox[{"FontSize", "\[Rule]", "11"}]}], "]"}], ",", 
                 RowBox[{"BaseStyle", "\[Rule]", 
                  RowBox[{"{", 
                   RowBox[{"\"\<Hyperlink\>\"", ",", 
                    RowBox[{"GrayLevel", "[", "0.5", "]"}]}], "}"}]}], ",", 
                 RowBox[{"ButtonData", "\[Rule]", 
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{"URL", "[", 
                    RowBox[{
                    "\"\<http://reference.wolfram.com/mathematica/\>\"", "<>",
                     "uri", "<>", "\"\<.ja.cdf\>\""}], "]"}], ",", "None"}], 
                   "}"}]}], ",", "\[IndentingNewLine]", 
                 RowBox[{"ButtonNote", "\[Rule]", 
                  RowBox[{
                  "\"\<http://reference.wolfram.com/mathematica/\>\"", "<>", 
                   "uri", "<>", "\"\<.ja.cdf\>\""}]}]}], "]"}], ",", " ", 
               "\"\<\[FilledRightTriangle]\>\"", ",", "\"\<     \>\"", ",", 
               " ", 
               RowBox[{"ButtonBox", "[", 
                RowBox[{
                 RowBox[{"StyleBox", "[", 
                  RowBox[{"\"\<\:4e2d\:6587\>\"", ",", 
                   RowBox[{"FontSize", "\[Rule]", "11"}]}], "]"}], ",", 
                 RowBox[{"BaseStyle", "\[Rule]", 
                  RowBox[{"{", 
                   RowBox[{"\"\<Hyperlink\>\"", ",", 
                    RowBox[{"GrayLevel", "[", "0.5", "]"}]}], "}"}]}], ",", 
                 RowBox[{"ButtonData", "\[Rule]", 
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{"URL", "[", 
                    RowBox[{
                    "\"\<http://reference.wolfram.com/mathematica/\>\"", "<>",
                     "uri", "<>", "\"\<.zh.cdf\>\""}], "]"}], ",", "None"}], 
                   "}"}]}], ",", 
                 RowBox[{"ButtonNote", "\[Rule]", 
                  RowBox[{
                  "\"\<http://reference.wolfram.com/mathematica/\>\"", "<>", 
                   "uri", "<>", "\"\<.zh.cdf\>\""}]}]}], "]"}], ",", " ", 
               "\"\<\[FilledRightTriangle]\>\""}], "}"}], "]"}], ",", 
            RowBox[{"StripOnInput", "\[Rule]", "False"}], ",", 
            RowBox[{"LineColor", "\[Rule]", 
             RowBox[{"GrayLevel", "[", "0.5", "]"}]}], ",", 
            RowBox[{"FrontFaceColor", "\[Rule]", 
             RowBox[{"GrayLevel", "[", "0.5", "]"}]}], ",", 
            RowBox[{"BackFaceColor", "\[Rule]", 
             RowBox[{"GrayLevel", "[", "0.5", "]"}]}], ",", 
            RowBox[{"GraphicsColor", "\[Rule]", 
             RowBox[{"GrayLevel", "[", "0.5", "]"}]}], ",", 
            RowBox[{"FontFamily", "\[Rule]", "\"\<Arial\>\""}], ",", 
            RowBox[{"FontSize", "\[Rule]", "9"}], ",", 
            RowBox[{"FontColor", "\[Rule]", 
             RowBox[{"GrayLevel", "[", "0.5", "]"}]}]}], "]"}], "]"}], ",", 
         "\"\<History\>\"", ",", 
         RowBox[{"CellFrame", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"0", ",", "0"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}], ",", 
         RowBox[{"CellMargins", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"72", ",", "25"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"20", ",", "0"}], "}"}]}], "}"}]}], ",", 
         RowBox[{"CellFrameColor", "\[Rule]", 
          RowBox[{"GrayLevel", "[", "0.8", "]"}]}]}], "]"}]}], " ", "]"}]}], 
    "]"}]}], ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.511109846479323*^9, 3.511109859288004*^9}, 
   3.511109959193722*^9, 3.511110099790739*^9, {3.511110400568446*^9, 
   3.5111104122553177`*^9}, {3.511110649705925*^9, 3.511110692782452*^9}, {
   3.5111108580928183`*^9, 3.5111108968837147`*^9}, {3.5111109988650827`*^9, 
   3.5111110548106117`*^9}, {3.511111180152874*^9, 3.511111180487296*^9}, {
   3.5111112311002283`*^9, 3.511111231306942*^9}, {3.512582800520733*^9, 
   3.512582948856386*^9}, {3.516456582423481*^9, 3.5164565876463957`*^9}, {
   3.5179250396181*^9, 3.517925064964864*^9}, {3.5197549988657417`*^9, 
   3.51975500114688*^9}, {3.520861476963334*^9, 3.5208615511708317`*^9}, {
   3.52086163627929*^9, 3.520861682754484*^9}, {3.5209601629020443`*^9, 
   3.5209601910127993`*^9}, {3.520960227840453*^9, 3.520960229125185*^9}, {
   3.520960574876033*^9, 3.520960654582156*^9}, {3.520960764881983*^9, 
   3.520960806904159*^9}, {3.5212183704561777`*^9, 3.521218391458714*^9}, 
   3.5212204482845793`*^9, 3.5212205011777477`*^9, {3.5213110399669533`*^9, 
   3.521311046045609*^9}}],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{
   RowBox[{
    RowBox[{"footercell", "[", "uri_String", "]"}], ":=", 
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", "}"}], ",", 
      RowBox[{"Cell", "[", 
       RowBox[{
        RowBox[{"BoxData", "[", 
         RowBox[{"StyleBox", "[", 
          RowBox[{
           RowBox[{"RowBox", "[", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"ButtonBox", "[", 
               RowBox[{
                RowBox[{"RowBox", "[", 
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"RowBox", "[", 
                    RowBox[{"{", 
                    RowBox[{
                    "\"\<\[Copyright]\>\"", ",", "\"\< \>\"", ",", 
                    "\"\<2011\>\"", ",", "\"\< \>\"", ",", "\"\<Wolfram\>\"", 
                    ",", "\"\< \>\"", ",", "\"\<Research\>\""}], "}"}], "]"}],
                    ",", "\"\<,\>\"", ",", "\"\< \>\"", ",", 
                   RowBox[{"RowBox", "[", 
                    RowBox[{"{", 
                    RowBox[{"\"\<Inc\>\"", ",", "\"\<.\>\""}], "}"}], "]"}]}],
                   "}"}], "]"}], ",", 
                RowBox[{"BaseStyle", "\[Rule]", 
                 RowBox[{"{", 
                  RowBox[{"\"\<Hyperlink\>\"", ",", 
                   RowBox[{"GrayLevel", "[", "0.5", "]"}]}], "}"}]}], ",", 
                RowBox[{"ButtonData", "\[Rule]", 
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{
                   "URL", "[", 
                    "\"\<http://www.wolfram.com/company/contact.cgi\>\"", 
                    "]"}], ",", "None"}], "}"}]}], ",", 
                RowBox[{
                "ButtonNote", "\[Rule]", 
                 "\"\<http://www.wolfram.com/company/contact.cgi\>\""}]}], 
               "]"}], ",", "\"\<  \>\"", ",", "\"\<\[Bullet]\>\"", ",", 
              "\"\<  \>\"", ",", 
              RowBox[{"ButtonBox", "[", 
               RowBox[{
                RowBox[{"RowBox", "[", 
                 RowBox[{"{", 
                  RowBox[{
                  "\"\<Terms\>\"", ",", "\"\< \>\"", ",", "\"\<of\>\"", ",", 
                   "\"\< \>\"", ",", "\"\<Use\>\"", ",", "\"\< \>\""}], "}"}],
                  "]"}], ",", 
                RowBox[{"BaseStyle", "\[Rule]", 
                 RowBox[{"{", 
                  RowBox[{"\"\<Hyperlink\>\"", ",", 
                   RowBox[{"GrayLevel", "[", "0.5", "]"}]}], "}"}]}], ",", 
                RowBox[{"ButtonData", "\[Rule]", 
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{
                   "URL", "[", 
                    "\"\<http://www.wolfram.com/company/terms.html\>\"", 
                    "]"}], ",", "None"}], "}"}]}], ",", 
                RowBox[{
                "ButtonNote", "\[Rule]", 
                 "\"\<http://www.wolfram.com/company/terms.html\>\""}]}], 
               "]"}], ",", "\"\< \>\"", ",", "\"\<\[Bullet]\>\"", ",", 
              "\"\<  \>\"", ",", 
              RowBox[{"ButtonBox", "[", 
               RowBox[{
                RowBox[{"RowBox", "[", 
                 RowBox[{"{", 
                  RowBox[{
                  "\"\<Privacy\>\"", ",", "\"\< \>\"", ",", 
                   "\"\<Policy\>\""}], "}"}], "]"}], ",", 
                RowBox[{"BaseStyle", "\[Rule]", 
                 RowBox[{"{", 
                  RowBox[{"\"\<Hyperlink\>\"", ",", 
                   RowBox[{"GrayLevel", "[", "0.5", "]"}]}], "}"}]}], ",", 
                RowBox[{"ButtonData", "\[Rule]", 
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{
                   "URL", "[", 
                    "\"\<http://www.wolfram.com/company/privacypolicy.html\>\"\
", "]"}], ",", "None"}], "}"}]}], ",", 
                RowBox[{
                "ButtonNote", "\[Rule]", 
                 "\"\<http://www.wolfram.com/company/privacypolicy.html\>\""}]\
}], "]"}], ",", "\"\<  \>\"", ",", "\"\<\[Bullet]\>\"", ",", "\"\<  \>\"", 
              ",", 
              RowBox[{"ButtonBox", "[", 
               RowBox[{
                RowBox[{"RowBox", "[", 
                 RowBox[{"{", 
                  RowBox[{
                  "\"\<Site\>\"", ",", "\"\< \>\"", ",", "\"\<Index\>\""}], 
                  "}"}], "]"}], ",", 
                RowBox[{"BaseStyle", "\[Rule]", 
                 RowBox[{"{", 
                  RowBox[{"\"\<Hyperlink\>\"", ",", 
                   RowBox[{"GrayLevel", "[", "0.5", "]"}]}], "}"}]}], ",", 
                RowBox[{"ButtonData", "\[Rule]", 
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{
                   "URL", "[", 
                    "\"\<http://reference.wolfram.com/alphaindex/\>\"", "]"}],
                    ",", "None"}], "}"}]}], ",", 
                RowBox[{
                "ButtonNote", "\[Rule]", 
                 "\"\<http://reference.wolfram.com/alphaindex/\>\""}]}], 
               "]"}]}], "}"}], "]"}], ",", 
           RowBox[{"StripOnInput", "\[Rule]", "False"}], ",", 
           RowBox[{"LineColor", "\[Rule]", 
            RowBox[{"GrayLevel", "[", "0.5", "]"}]}], ",", 
           RowBox[{"FrontFaceColor", "\[Rule]", 
            RowBox[{"GrayLevel", "[", "0.5", "]"}]}], ",", 
           RowBox[{"BackFaceColor", "\[Rule]", 
            RowBox[{"GrayLevel", "[", "0.5", "]"}]}], ",", 
           RowBox[{"GraphicsColor", "\[Rule]", 
            RowBox[{"GrayLevel", "[", "0.5", "]"}]}], ",", 
           RowBox[{"FontFamily", "\[Rule]", "\"\<Arial\>\""}], ",", 
           RowBox[{"FontSize", "\[Rule]", "9"}], ",", 
           RowBox[{"FontColor", "\[Rule]", 
            RowBox[{"GrayLevel", "[", "0.5", "]"}]}]}], "]"}], "]"}], ",", 
        "\"\<History\>\"", ",", 
        RowBox[{"CellFrame", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"0", ",", "0"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}], ",", 
        RowBox[{"CellMargins", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"72", ",", "25"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"20", ",", "0"}], "}"}]}], "}"}]}], ",", 
        RowBox[{"CellFrameColor", "\[Rule]", 
         RowBox[{"GrayLevel", "[", "0.8", "]"}]}]}], "]"}]}], "]"}]}], ";"}], 
  " ", "*)"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.517929370413823*^9, 3.51792938750905*^9}, {
  3.520861458651335*^9, 3.520861462533155*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Main Guide Page Footer Cell", "Section",
 InitializationCell->True,
 CellChangeTimes->{{3.5091286882951527`*^9, 3.509128688999133*^9}, {
  3.514721803432283*^9, 3.5147218049446993`*^9}, {3.517921616319525*^9, 
  3.517921661760709*^9}, {3.517921772033362*^9, 3.51792178014533*^9}, {
  3.5179218571204987`*^9, 3.5179218937774153`*^9}, {3.5179219273015537`*^9, 
  3.517921946709152*^9}, {3.5179219797127*^9, 3.517921980911112*^9}, {
  3.5179220199795923`*^9, 3.517922033723228*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"mainguidefootercell", "[", 
    RowBox[{"uri_String", ",", " ", "lang_"}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{"Switch", "[", 
      RowBox[{"lang", ",", " ", "\"\<English\>\"", ",", 
       RowBox[{"Cell", "[", 
        RowBox[{
         RowBox[{"BoxData", "[", 
          RowBox[{"StyleBox", "[", 
           RowBox[{
            RowBox[{"RowBox", "[", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"ButtonBox", "[", 
                RowBox[{
                 RowBox[{"RowBox", "[", 
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{"RowBox", "[", 
                    RowBox[{"{", 
                    RowBox[{
                    "\"\<\[Copyright]\>\"", ",", "\"\< \>\"", ",", 
                    "\"\<2011\>\"", ",", "\"\< \>\"", ",", "\"\<Wolfram\>\"", 
                    ",", "\"\< \>\"", ",", "\"\<Research\>\""}], "}"}], "]"}],
                     ",", "\"\<,\>\"", ",", "\"\< \>\"", ",", 
                    RowBox[{"RowBox", "[", 
                    RowBox[{"{", 
                    RowBox[{"\"\<Inc\>\"", ",", "\"\<.\>\""}], "}"}], "]"}]}],
                    "}"}], "]"}], ",", 
                 RowBox[{"BaseStyle", "\[Rule]", 
                  RowBox[{"{", 
                   RowBox[{"\"\<Hyperlink\>\"", ",", 
                    RowBox[{"GrayLevel", "[", "0.5", "]"}]}], "}"}]}], ",", 
                 RowBox[{"ButtonData", "\[Rule]", 
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{
                    "URL", "[", 
                    "\"\<http://www.wolfram.com/company/contact.cgi\>\"", 
                    "]"}], ",", "None"}], "}"}]}], ",", 
                 RowBox[{
                 "ButtonNote", "\[Rule]", 
                  "\"\<http://www.wolfram.com/company/contact.cgi\>\""}]}], 
                "]"}], ",", "\"\<  \>\"", ",", "\"\<\[Bullet]\>\"", ",", 
               "\"\<  \>\"", ",", 
               RowBox[{"ButtonBox", "[", 
                RowBox[{
                 RowBox[{"RowBox", "[", 
                  RowBox[{"{", 
                   RowBox[{
                   "\"\<Terms\>\"", ",", "\"\< \>\"", ",", "\"\<of\>\"", ",", 
                    "\"\< \>\"", ",", "\"\<Use\>\"", ",", "\"\< \>\""}], 
                   "}"}], "]"}], ",", 
                 RowBox[{"BaseStyle", "\[Rule]", 
                  RowBox[{"{", 
                   RowBox[{"\"\<Hyperlink\>\"", ",", 
                    RowBox[{"GrayLevel", "[", "0.5", "]"}]}], "}"}]}], ",", 
                 RowBox[{"ButtonData", "\[Rule]", 
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{
                    "URL", "[", 
                    "\"\<http://www.wolfram.com/legal/terms/wolfram-research.\
html\>\"", "]"}], ",", "None"}], "}"}]}], ",", 
                 RowBox[{
                 "ButtonNote", "\[Rule]", 
                  "\"\<http://www.wolfram.com/legal/terms/wolfram-research.\
html\>\""}]}], "]"}], ",", "\"\< \>\"", ",", "\"\<\[Bullet]\>\"", ",", 
               "\"\<  \>\"", ",", 
               RowBox[{"ButtonBox", "[", 
                RowBox[{
                 RowBox[{"RowBox", "[", 
                  RowBox[{"{", 
                   RowBox[{
                   "\"\<Privacy\>\"", ",", "\"\< \>\"", ",", 
                    "\"\<Policy\>\""}], "}"}], "]"}], ",", 
                 RowBox[{"BaseStyle", "\[Rule]", 
                  RowBox[{"{", 
                   RowBox[{"\"\<Hyperlink\>\"", ",", 
                    RowBox[{"GrayLevel", "[", "0.5", "]"}]}], "}"}]}], ",", 
                 RowBox[{"ButtonData", "\[Rule]", 
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{
                    "URL", "[", 
                    "\"\<http://www.wolfram.com/legal/privacy/wolfram-\
research.html\>\"", "]"}], ",", "None"}], "}"}]}], ",", 
                 RowBox[{
                 "ButtonNote", "\[Rule]", 
                  "\"\<http://www.wolfram.com/legal/privacy/wolfram-research.\
html\>\""}]}], "]"}], ",", "\"\<  \>\"", ",", "\"\<\[Bullet]\>\"", ",", 
               "\"\<  \>\"", ",", 
               RowBox[{"ButtonBox", "[", 
                RowBox[{
                 RowBox[{"RowBox", "[", 
                  RowBox[{"{", 
                   RowBox[{
                   "\"\<Site\>\"", ",", "\"\< \>\"", ",", "\"\<Index\>\""}], 
                   "}"}], "]"}], ",", 
                 RowBox[{"BaseStyle", "\[Rule]", 
                  RowBox[{"{", 
                   RowBox[{"\"\<Hyperlink\>\"", ",", 
                    RowBox[{"GrayLevel", "[", "0.5", "]"}]}], "}"}]}], ",", 
                 RowBox[{"ButtonData", "\[Rule]", 
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{
                    "URL", "[", 
                    "\"\<http://reference.wolfram.com/alphaindex/\>\"", "]"}],
                     ",", "None"}], "}"}]}], ",", 
                 RowBox[{
                 "ButtonNote", "\[Rule]", 
                  "\"\<http://reference.wolfram.com/alphaindex/\>\""}]}], 
                "]"}], ",", 
               RowBox[{"StyleBox", "[", 
                RowBox[{"\"\<  |  \>\"", ",", 
                 RowBox[{"FontSize", "\[Rule]", "9"}]}], "]"}], ",", 
               "\"\<Choose\>\"", ",", "\"\< \>\"", ",", "\"\<Language\>\"", 
               ",", "\"\<     \>\"", ",", 
               RowBox[{"ButtonBox", "[", 
                RowBox[{
                 RowBox[{"StyleBox", "[", 
                  RowBox[{"\"\<\:65e5\:672c\:8a9e\>\"", ",", 
                   RowBox[{"FontSize", "\[Rule]", "11"}]}], "]"}], ",", 
                 RowBox[{"BaseStyle", "\[Rule]", 
                  RowBox[{"{", 
                   RowBox[{"\"\<Hyperlink\>\"", ",", 
                    RowBox[{"GrayLevel", "[", "0.5", "]"}]}], "}"}]}], ",", 
                 RowBox[{"ButtonData", "\[Rule]", 
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{"URL", "[", 
                    RowBox[{
                    "\"\<http://reference.wolfram.com/mathematica/\>\"", "<>",
                     "uri", "<>", "\"\<.ja.cdf\>\""}], "]"}], ",", "None"}], 
                   "}"}]}], ",", "\[IndentingNewLine]", 
                 RowBox[{"ButtonNote", "\[Rule]", 
                  RowBox[{
                  "\"\<http://reference.wolfram.com/mathematica/\>\"", "<>", 
                   "uri", "<>", "\"\<.ja.cdf\>\""}]}]}], "]"}], ",", " ", 
               "\"\<\[FilledRightTriangle]\>\"", ",", "\"\<     \>\"", ",", 
               " ", 
               RowBox[{"ButtonBox", "[", 
                RowBox[{
                 RowBox[{"StyleBox", "[", 
                  RowBox[{"\"\<\:4e2d\:6587\>\"", ",", 
                   RowBox[{"FontSize", "\[Rule]", "11"}]}], "]"}], ",", 
                 RowBox[{"BaseStyle", "\[Rule]", 
                  RowBox[{"{", 
                   RowBox[{"\"\<Hyperlink\>\"", ",", 
                    RowBox[{"GrayLevel", "[", "0.5", "]"}]}], "}"}]}], ",", 
                 RowBox[{"ButtonData", "\[Rule]", 
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{"URL", "[", 
                    RowBox[{
                    "\"\<http://reference.wolfram.com/mathematica/\>\"", "<>",
                     "uri", "<>", "\"\<.zh.cdf\>\""}], "]"}], ",", "None"}], 
                   "}"}]}], ",", 
                 RowBox[{"ButtonNote", "\[Rule]", 
                  RowBox[{
                  "\"\<http://reference.wolfram.com/mathematica/\>\"", "<>", 
                   "uri", "<>", "\"\<.zh.cdf\>\""}]}]}], "]"}], ",", " ", 
               "\"\<\[FilledRightTriangle]\>\""}], "}"}], "]"}], ",", 
            RowBox[{"StripOnInput", "\[Rule]", "False"}], ",", 
            RowBox[{"LineColor", "\[Rule]", 
             RowBox[{"GrayLevel", "[", "0.5", "]"}]}], ",", 
            RowBox[{"FrontFaceColor", "\[Rule]", 
             RowBox[{"GrayLevel", "[", "0.5", "]"}]}], ",", 
            RowBox[{"BackFaceColor", "\[Rule]", 
             RowBox[{"GrayLevel", "[", "0.5", "]"}]}], ",", 
            RowBox[{"GraphicsColor", "\[Rule]", 
             RowBox[{"GrayLevel", "[", "0.5", "]"}]}], ",", 
            RowBox[{"FontFamily", "\[Rule]", "\"\<Arial\>\""}], ",", 
            RowBox[{"FontSize", "\[Rule]", "9"}], ",", 
            RowBox[{"FontColor", "\[Rule]", 
             RowBox[{"GrayLevel", "[", "0.5", "]"}]}]}], "]"}], "]"}], ",", 
         "\"\<History\>\"", ",", 
         RowBox[{"CellFrame", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"0", ",", "0"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}], ",", 
         RowBox[{"CellMargins", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"145", ",", "120"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"20", ",", "0"}], "}"}]}], "}"}]}], ",", 
         RowBox[{"CellFrameColor", "\[Rule]", 
          RowBox[{"GrayLevel", "[", "0.8", "]"}]}]}], "]"}], ",", " ", 
       "\"\<Japanese\>\"", ",", " ", 
       RowBox[{"Cell", "[", 
        RowBox[{
         RowBox[{"BoxData", "[", 
          RowBox[{"StyleBox", "[", 
           RowBox[{
            RowBox[{"RowBox", "[", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"ButtonBox", "[", 
                RowBox[{
                 RowBox[{"RowBox", "[", 
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{"RowBox", "[", 
                    RowBox[{"{", 
                    RowBox[{
                    "\"\<\[Copyright]\>\"", ",", "\"\< \>\"", ",", 
                    "\"\<2011\>\"", ",", "\"\< \>\"", ",", "\"\<Wolfram\>\"", 
                    ",", "\"\< \>\"", ",", "\"\<Research\>\""}], "}"}], "]"}],
                     ",", "\"\<,\>\"", ",", "\"\< \>\"", ",", 
                    RowBox[{"RowBox", "[", 
                    RowBox[{"{", 
                    RowBox[{"\"\<Inc\>\"", ",", "\"\<.\>\""}], "}"}], "]"}]}],
                    "}"}], "]"}], ",", 
                 RowBox[{"BaseStyle", "\[Rule]", 
                  RowBox[{"{", 
                   RowBox[{"\"\<Hyperlink\>\"", ",", 
                    RowBox[{"GrayLevel", "[", "0.5", "]"}]}], "}"}]}], ",", 
                 RowBox[{"ButtonData", "\[Rule]", 
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{
                    "URL", "[", 
                    "\"\<http://www.wolfram.com/company/contact.cgi\>\"", 
                    "]"}], ",", "None"}], "}"}]}], ",", 
                 RowBox[{
                 "ButtonNote", "\[Rule]", 
                  "\"\<http://www.wolfram.com/company/contact.cgi\>\""}]}], 
                "]"}], ",", "\"\<  \>\"", ",", "\"\<\[Bullet]\>\"", ",", 
               "\"\<  \>\"", ",", 
               RowBox[{"ButtonBox", "[", 
                RowBox[{
                 RowBox[{"RowBox", "[", 
                  RowBox[{"{", 
                   RowBox[{
                   "\"\<Terms\>\"", ",", "\"\< \>\"", ",", "\"\<of\>\"", ",", 
                    "\"\< \>\"", ",", "\"\<Use\>\"", ",", "\"\< \>\""}], 
                   "}"}], "]"}], ",", 
                 RowBox[{"BaseStyle", "\[Rule]", 
                  RowBox[{"{", 
                   RowBox[{"\"\<Hyperlink\>\"", ",", 
                    RowBox[{"GrayLevel", "[", "0.5", "]"}]}], "}"}]}], ",", 
                 RowBox[{"ButtonData", "\[Rule]", 
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{
                    "URL", "[", 
                    "\"\<http://www.wolfram.com/legal/terms/wolfram-research.\
html\>\"", "]"}], ",", "None"}], "}"}]}], ",", 
                 RowBox[{
                 "ButtonNote", "\[Rule]", 
                  "\"\<http://www.wolfram.com/legal/terms/wolfram-research.\
html\>\""}]}], "]"}], ",", "\"\< \>\"", ",", "\"\<\[Bullet]\>\"", ",", 
               "\"\<  \>\"", ",", 
               RowBox[{"ButtonBox", "[", 
                RowBox[{
                 RowBox[{"RowBox", "[", 
                  RowBox[{"{", 
                   RowBox[{
                   "\"\<Privacy\>\"", ",", "\"\< \>\"", ",", 
                    "\"\<Policy\>\""}], "}"}], "]"}], ",", 
                 RowBox[{"BaseStyle", "\[Rule]", 
                  RowBox[{"{", 
                   RowBox[{"\"\<Hyperlink\>\"", ",", 
                    RowBox[{"GrayLevel", "[", "0.5", "]"}]}], "}"}]}], ",", 
                 RowBox[{"ButtonData", "\[Rule]", 
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{
                    "URL", "[", 
                    "\"\<http://www.wolfram.com/legal/privacy/wolfram-\
research.html\>\"", "]"}], ",", "None"}], "}"}]}], ",", 
                 RowBox[{
                 "ButtonNote", "\[Rule]", 
                  "\"\<http://www.wolfram.com/legal/privacy/wolfram-research.\
html\>\""}]}], "]"}], ",", "\"\<  \>\"", ",", "\"\<\[Bullet]\>\"", ",", 
               "\"\<  \>\"", ",", 
               RowBox[{"ButtonBox", "[", 
                RowBox[{
                 RowBox[{"RowBox", "[", 
                  RowBox[{
                  "{", "\"\<\:30b5\:30a4\:30c8\:30a4\:30f3\:30c7\:30c3\:30af\
\:30b9\>\"", "}"}], "]"}], ",", 
                 RowBox[{"BaseStyle", "\[Rule]", 
                  RowBox[{"{", 
                   RowBox[{"\"\<Hyperlink\>\"", ",", 
                    RowBox[{"GrayLevel", "[", "0.5", "]"}]}], "}"}]}], ",", 
                 RowBox[{"ButtonData", "\[Rule]", 
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{
                    "URL", "[", 
                    "\"\<http://reference.wolfram.com/alphaindex/\>\"", "]"}],
                     ",", "None"}], "}"}]}], ",", 
                 RowBox[{
                 "ButtonNote", "\[Rule]", 
                  "\"\<http://reference.wolfram.com/alphaindex/\>\""}]}], 
                "]"}], ",", 
               RowBox[{"StyleBox", "[", 
                RowBox[{"\"\<  |  \>\"", ",", 
                 RowBox[{"FontSize", "\[Rule]", "9"}]}], "]"}], ",", 
               "\"\<\:8a00\:8a9e\>\"", ",", "\"\<     \>\"", ",", 
               RowBox[{"ButtonBox", "[", 
                RowBox[{
                 RowBox[{"StyleBox", "[", 
                  RowBox[{"\"\<English\>\"", ",", 
                   RowBox[{"FontSize", "\[Rule]", "11"}]}], "]"}], ",", 
                 RowBox[{"BaseStyle", "\[Rule]", 
                  RowBox[{"{", 
                   RowBox[{"\"\<Hyperlink\>\"", ",", 
                    RowBox[{"GrayLevel", "[", "0.5", "]"}]}], "}"}]}], ",", 
                 RowBox[{"ButtonData", "\[Rule]", 
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{"URL", "[", 
                    RowBox[{
                    "\"\<http://reference.wolfram.com/mathematica/\>\"", "<>",
                     "uri", "<>", "\"\<.en.cdf\>\""}], "]"}], ",", "None"}], 
                   "}"}]}], ",", "\[IndentingNewLine]", 
                 RowBox[{"ButtonNote", "\[Rule]", 
                  RowBox[{
                  "\"\<http://reference.wolfram.com/mathematica/\>\"", "<>", 
                   "uri", "<>", "\"\<.en.cdf\>\""}]}]}], "]"}], ",", " ", 
               "\"\<\[FilledRightTriangle]\>\"", ",", "\"\<     \>\"", ",", 
               " ", 
               RowBox[{"ButtonBox", "[", 
                RowBox[{
                 RowBox[{"StyleBox", "[", 
                  RowBox[{"\"\<\:4e2d\:6587\>\"", ",", 
                   RowBox[{"FontSize", "\[Rule]", "11"}]}], "]"}], ",", 
                 RowBox[{"BaseStyle", "\[Rule]", 
                  RowBox[{"{", 
                   RowBox[{"\"\<Hyperlink\>\"", ",", 
                    RowBox[{"GrayLevel", "[", "0.5", "]"}]}], "}"}]}], ",", 
                 RowBox[{"ButtonData", "\[Rule]", 
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{"URL", "[", 
                    RowBox[{
                    "\"\<http://reference.wolfram.com/mathematica/\>\"", "<>",
                     "uri", "<>", "\"\<.zh.cdf\>\""}], "]"}], ",", "None"}], 
                   "}"}]}], ",", 
                 RowBox[{"ButtonNote", "\[Rule]", 
                  RowBox[{
                  "\"\<http://reference.wolfram.com/mathematica/\>\"", "<>", 
                   "uri", "<>", "\"\<.zh.cdf\>\""}]}]}], "]"}], ",", " ", 
               "\"\<\[FilledRightTriangle]\>\""}], "}"}], "]"}], ",", 
            RowBox[{"StripOnInput", "\[Rule]", "False"}], ",", 
            RowBox[{"LineColor", "\[Rule]", 
             RowBox[{"GrayLevel", "[", "0.5", "]"}]}], ",", 
            RowBox[{"FrontFaceColor", "\[Rule]", 
             RowBox[{"GrayLevel", "[", "0.5", "]"}]}], ",", 
            RowBox[{"BackFaceColor", "\[Rule]", 
             RowBox[{"GrayLevel", "[", "0.5", "]"}]}], ",", 
            RowBox[{"GraphicsColor", "\[Rule]", 
             RowBox[{"GrayLevel", "[", "0.5", "]"}]}], ",", 
            RowBox[{"FontFamily", "\[Rule]", "\"\<Arial\>\""}], ",", 
            RowBox[{"FontSize", "\[Rule]", "10"}], ",", 
            RowBox[{"FontColor", "\[Rule]", 
             RowBox[{"GrayLevel", "[", "0.5", "]"}]}]}], "]"}], "]"}], ",", 
         "\"\<History\>\"", ",", 
         RowBox[{"CellFrame", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"0", ",", "0"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}], ",", 
         RowBox[{"CellMargins", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"145", ",", "120"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"20", ",", "0"}], "}"}]}], "}"}]}], ",", 
         RowBox[{"CellFrameColor", "\[Rule]", 
          RowBox[{"GrayLevel", "[", "0.8", "]"}]}]}], "]"}], ",", " ", 
       "\"\<ChineseSimplified\>\"", ",", " ", 
       RowBox[{"Cell", "[", 
        RowBox[{
         RowBox[{"BoxData", "[", 
          RowBox[{"StyleBox", "[", 
           RowBox[{
            RowBox[{"RowBox", "[", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"ButtonBox", "[", 
                RowBox[{
                 RowBox[{"RowBox", "[", 
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{"RowBox", "[", 
                    RowBox[{"{", 
                    RowBox[{
                    "\"\<\[Copyright]\>\"", ",", "\"\< \>\"", ",", 
                    "\"\<2011\>\"", ",", "\"\< \>\"", ",", "\"\<Wolfram\>\"", 
                    ",", "\"\< \>\"", ",", "\"\<Research\>\""}], "}"}], "]"}],
                     ",", "\"\<,\>\"", ",", "\"\< \>\"", ",", 
                    RowBox[{"RowBox", "[", 
                    RowBox[{"{", 
                    RowBox[{"\"\<Inc\>\"", ",", "\"\<.\>\""}], "}"}], "]"}]}],
                    "}"}], "]"}], ",", 
                 RowBox[{"BaseStyle", "\[Rule]", 
                  RowBox[{"{", 
                   RowBox[{"\"\<Hyperlink\>\"", ",", 
                    RowBox[{"GrayLevel", "[", "0.5", "]"}]}], "}"}]}], ",", 
                 RowBox[{"ButtonData", "\[Rule]", 
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{
                    "URL", "[", 
                    "\"\<http://www.wolfram.com/company/contact.cgi\>\"", 
                    "]"}], ",", "None"}], "}"}]}], ",", 
                 RowBox[{
                 "ButtonNote", "\[Rule]", 
                  "\"\<http://www.wolfram.com/company/contact.cgi\>\""}]}], 
                "]"}], ",", "\"\<  \>\"", ",", "\"\<\[Bullet]\>\"", ",", 
               "\"\<  \>\"", ",", 
               RowBox[{"ButtonBox", "[", 
                RowBox[{
                 RowBox[{"RowBox", "[", 
                  RowBox[{"{", 
                   RowBox[{
                   "\"\<\:4f7f\:7528\:6761\:6b3e\>\"", ",", "\"\< \>\""}], 
                   "}"}], "]"}], ",", 
                 RowBox[{"BaseStyle", "\[Rule]", 
                  RowBox[{"{", 
                   RowBox[{"\"\<Hyperlink\>\"", ",", 
                    RowBox[{"GrayLevel", "[", "0.5", "]"}]}], "}"}]}], ",", 
                 RowBox[{"ButtonData", "\[Rule]", 
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{
                    "URL", "[", 
                    "\"\<http://www.wolfram.com/legal/terms/wolfram-research.\
html\>\"", "]"}], ",", "None"}], "}"}]}], ",", 
                 RowBox[{
                 "ButtonNote", "\[Rule]", 
                  "\"\<http://www.wolfram.com/legal/terms/wolfram-research.\
html\>\""}]}], "]"}], ",", "\"\< \>\"", ",", "\"\<\[Bullet]\>\"", ",", 
               "\"\<  \>\"", ",", 
               RowBox[{"ButtonBox", "[", 
                RowBox[{
                 RowBox[{"RowBox", "[", 
                  RowBox[{"{", "\"\<\:9690\:79c1\:653f\:7b56\>\"", "}"}], 
                  "]"}], ",", 
                 RowBox[{"BaseStyle", "\[Rule]", 
                  RowBox[{"{", 
                   RowBox[{"\"\<Hyperlink\>\"", ",", 
                    RowBox[{"GrayLevel", "[", "0.5", "]"}]}], "}"}]}], ",", 
                 RowBox[{"ButtonData", "\[Rule]", 
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{
                    "URL", "[", 
                    "\"\<http://www.wolfram.com/legal/privacy/wolfram-\
research.html\>\"", "]"}], ",", "None"}], "}"}]}], ",", 
                 RowBox[{
                 "ButtonNote", "\[Rule]", 
                  "\"\<http://www.wolfram.com/legal/privacy/wolfram-research.\
html\>\""}]}], "]"}], ",", "\"\<  \>\"", ",", "\"\<\[Bullet]\>\"", ",", 
               "\"\<  \>\"", ",", 
               RowBox[{"ButtonBox", "[", 
                RowBox[{
                 RowBox[{"RowBox", "[", 
                  RowBox[{"{", "\"\<\:7f51\:7ad9\:7d22\:5f15\>\"", "}"}], 
                  "]"}], ",", 
                 RowBox[{"BaseStyle", "\[Rule]", 
                  RowBox[{"{", 
                   RowBox[{"\"\<Hyperlink\>\"", ",", 
                    RowBox[{"GrayLevel", "[", "0.5", "]"}]}], "}"}]}], ",", 
                 RowBox[{"ButtonData", "\[Rule]", 
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{
                    "URL", "[", 
                    "\"\<http://reference.wolfram.com/alphaindex/\>\"", "]"}],
                     ",", "None"}], "}"}]}], ",", 
                 RowBox[{
                 "ButtonNote", "\[Rule]", 
                  "\"\<http://reference.wolfram.com/alphaindex/\>\""}]}], 
                "]"}], ",", 
               RowBox[{"StyleBox", "[", 
                RowBox[{"\"\<  |  \>\"", ",", 
                 RowBox[{"FontSize", "\[Rule]", "9"}]}], "]"}], ",", 
               "\"\<\:9009\:62e9\:8bed\:8a00\>\"", ",", "\"\<     \>\"", ",", 
               
               RowBox[{"ButtonBox", "[", 
                RowBox[{
                 RowBox[{"StyleBox", "[", 
                  RowBox[{"\"\<English\>\"", ",", 
                   RowBox[{"FontSize", "\[Rule]", "11"}]}], "]"}], ",", 
                 RowBox[{"BaseStyle", "\[Rule]", 
                  RowBox[{"{", 
                   RowBox[{"\"\<Hyperlink\>\"", ",", 
                    RowBox[{"GrayLevel", "[", "0.5", "]"}]}], "}"}]}], ",", 
                 RowBox[{"ButtonData", "\[Rule]", 
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{"URL", "[", 
                    RowBox[{
                    "\"\<http://reference.wolfram.com/mathematica/\>\"", "<>",
                     "uri", "<>", "\"\<.en.cdf\>\""}], "]"}], ",", "None"}], 
                   "}"}]}], ",", "\[IndentingNewLine]", 
                 RowBox[{"ButtonNote", "\[Rule]", 
                  RowBox[{
                  "\"\<http://reference.wolfram.com/mathematica/\>\"", "<>", 
                   "uri", "<>", "\"\<.en.cdf\>\""}]}]}], "]"}], ",", " ", 
               "\"\<\[FilledRightTriangle]\>\"", ",", "\"\<     \>\"", ",", 
               " ", 
               RowBox[{"ButtonBox", "[", 
                RowBox[{
                 RowBox[{"StyleBox", "[", 
                  RowBox[{"\"\<\:65e5\:672c\:8a9e\>\"", ",", 
                   RowBox[{"FontSize", "\[Rule]", "11"}]}], "]"}], ",", 
                 RowBox[{"BaseStyle", "\[Rule]", 
                  RowBox[{"{", 
                   RowBox[{"\"\<Hyperlink\>\"", ",", 
                    RowBox[{"GrayLevel", "[", "0.5", "]"}]}], "}"}]}], ",", 
                 RowBox[{"ButtonData", "\[Rule]", 
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{"URL", "[", 
                    RowBox[{
                    "\"\<http://reference.wolfram.com/mathematica/\>\"", "<>",
                     "uri", "<>", "\"\<.ja.cdf\>\""}], "]"}], ",", "None"}], 
                   "}"}]}], ",", 
                 RowBox[{"ButtonNote", "\[Rule]", 
                  RowBox[{
                  "\"\<http://reference.wolfram.com/mathematica/\>\"", "<>", 
                   "uri", "<>", "\"\<.ja.cdf\>\""}]}]}], "]"}], ",", " ", 
               "\"\<\[FilledRightTriangle]\>\""}], "}"}], "]"}], ",", 
            RowBox[{"StripOnInput", "\[Rule]", "False"}], ",", 
            RowBox[{"LineColor", "\[Rule]", 
             RowBox[{"GrayLevel", "[", "0.5", "]"}]}], ",", 
            RowBox[{"FrontFaceColor", "\[Rule]", 
             RowBox[{"GrayLevel", "[", "0.5", "]"}]}], ",", 
            RowBox[{"BackFaceColor", "\[Rule]", 
             RowBox[{"GrayLevel", "[", "0.5", "]"}]}], ",", 
            RowBox[{"GraphicsColor", "\[Rule]", 
             RowBox[{"GrayLevel", "[", "0.5", "]"}]}], ",", 
            RowBox[{"FontFamily", "\[Rule]", "\"\<Arial\>\""}], ",", 
            RowBox[{"FontSize", "\[Rule]", "10"}], ",", 
            RowBox[{"FontColor", "\[Rule]", 
             RowBox[{"GrayLevel", "[", "0.5", "]"}]}]}], "]"}], "]"}], ",", 
         "\"\<History\>\"", ",", 
         RowBox[{"CellFrame", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"0", ",", "0"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}], ",", 
         RowBox[{"CellMargins", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"145", ",", "120"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"20", ",", "0"}], "}"}]}], "}"}]}], ",", 
         RowBox[{"CellFrameColor", "\[Rule]", 
          RowBox[{"GrayLevel", "[", "0.8", "]"}]}]}], "]"}], ",", " ", "_", 
       ",", 
       RowBox[{"Cell", "[", 
        RowBox[{
         RowBox[{"BoxData", "[", 
          RowBox[{"StyleBox", "[", 
           RowBox[{
            RowBox[{"RowBox", "[", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"ButtonBox", "[", 
                RowBox[{
                 RowBox[{"RowBox", "[", 
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{"RowBox", "[", 
                    RowBox[{"{", 
                    RowBox[{
                    "\"\<\[Copyright]\>\"", ",", "\"\< \>\"", ",", 
                    "\"\<2011\>\"", ",", "\"\< \>\"", ",", "\"\<Wolfram\>\"", 
                    ",", "\"\< \>\"", ",", "\"\<Research\>\""}], "}"}], "]"}],
                     ",", "\"\<,\>\"", ",", "\"\< \>\"", ",", 
                    RowBox[{"RowBox", "[", 
                    RowBox[{"{", 
                    RowBox[{"\"\<Inc\>\"", ",", "\"\<.\>\""}], "}"}], "]"}]}],
                    "}"}], "]"}], ",", 
                 RowBox[{"BaseStyle", "\[Rule]", 
                  RowBox[{"{", 
                   RowBox[{"\"\<Hyperlink\>\"", ",", 
                    RowBox[{"GrayLevel", "[", "0.5", "]"}]}], "}"}]}], ",", 
                 RowBox[{"ButtonData", "\[Rule]", 
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{
                    "URL", "[", 
                    "\"\<http://www.wolfram.com/company/contact.cgi\>\"", 
                    "]"}], ",", "None"}], "}"}]}], ",", 
                 RowBox[{
                 "ButtonNote", "\[Rule]", 
                  "\"\<http://www.wolfram.com/company/contact.cgi\>\""}]}], 
                "]"}], ",", "\"\<  \>\"", ",", "\"\<\[Bullet]\>\"", ",", 
               "\"\<  \>\"", ",", 
               RowBox[{"ButtonBox", "[", 
                RowBox[{
                 RowBox[{"RowBox", "[", 
                  RowBox[{"{", 
                   RowBox[{
                   "\"\<Terms\>\"", ",", "\"\< \>\"", ",", "\"\<of\>\"", ",", 
                    "\"\< \>\"", ",", "\"\<Use\>\"", ",", "\"\< \>\""}], 
                   "}"}], "]"}], ",", 
                 RowBox[{"BaseStyle", "\[Rule]", 
                  RowBox[{"{", 
                   RowBox[{"\"\<Hyperlink\>\"", ",", 
                    RowBox[{"GrayLevel", "[", "0.5", "]"}]}], "}"}]}], ",", 
                 RowBox[{"ButtonData", "\[Rule]", 
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{
                    "URL", "[", 
                    "\"\<http://www.wolfram.com/legal/terms/wolfram-research.\
html\>\"", "]"}], ",", "None"}], "}"}]}], ",", 
                 RowBox[{
                 "ButtonNote", "\[Rule]", 
                  "\"\<http://www.wolfram.com/legal/terms/wolfram-research.\
html\>\""}]}], "]"}], ",", "\"\< \>\"", ",", "\"\<\[Bullet]\>\"", ",", 
               "\"\<  \>\"", ",", 
               RowBox[{"ButtonBox", "[", 
                RowBox[{
                 RowBox[{"RowBox", "[", 
                  RowBox[{"{", 
                   RowBox[{
                   "\"\<Privacy\>\"", ",", "\"\< \>\"", ",", 
                    "\"\<Policy\>\""}], "}"}], "]"}], ",", 
                 RowBox[{"BaseStyle", "\[Rule]", 
                  RowBox[{"{", 
                   RowBox[{"\"\<Hyperlink\>\"", ",", 
                    RowBox[{"GrayLevel", "[", "0.5", "]"}]}], "}"}]}], ",", 
                 RowBox[{"ButtonData", "\[Rule]", 
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{
                    "URL", "[", 
                    "\"\<http://www.wolfram.com/legal/privacy/wolfram-\
research.html\>\"", "]"}], ",", "None"}], "}"}]}], ",", 
                 RowBox[{
                 "ButtonNote", "\[Rule]", 
                  "\"\<http://www.wolfram.com/legal/privacy/wolfram-research.\
html\>\""}]}], "]"}], ",", "\"\<  \>\"", ",", "\"\<\[Bullet]\>\"", ",", 
               "\"\<  \>\"", ",", 
               RowBox[{"ButtonBox", "[", 
                RowBox[{
                 RowBox[{"RowBox", "[", 
                  RowBox[{"{", 
                   RowBox[{
                   "\"\<Site\>\"", ",", "\"\< \>\"", ",", "\"\<Index\>\""}], 
                   "}"}], "]"}], ",", 
                 RowBox[{"BaseStyle", "\[Rule]", 
                  RowBox[{"{", 
                   RowBox[{"\"\<Hyperlink\>\"", ",", 
                    RowBox[{"GrayLevel", "[", "0.5", "]"}]}], "}"}]}], ",", 
                 RowBox[{"ButtonData", "\[Rule]", 
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{
                    "URL", "[", 
                    "\"\<http://reference.wolfram.com/alphaindex/\>\"", "]"}],
                     ",", "None"}], "}"}]}], ",", 
                 RowBox[{
                 "ButtonNote", "\[Rule]", 
                  "\"\<http://reference.wolfram.com/alphaindex/\>\""}]}], 
                "]"}], ",", 
               RowBox[{"StyleBox", "[", 
                RowBox[{"\"\<  |  \>\"", ",", 
                 RowBox[{"FontSize", "\[Rule]", "9"}]}], "]"}], ",", 
               "\"\<Choose\>\"", ",", "\"\< \>\"", ",", "\"\<Language\>\"", 
               ",", "\"\<     \>\"", ",", 
               RowBox[{"ButtonBox", "[", 
                RowBox[{
                 RowBox[{"StyleBox", "[", 
                  RowBox[{"\"\<\:65e5\:672c\:8a9e\>\"", ",", 
                   RowBox[{"FontSize", "\[Rule]", "11"}]}], "]"}], ",", 
                 RowBox[{"BaseStyle", "\[Rule]", 
                  RowBox[{"{", 
                   RowBox[{"\"\<Hyperlink\>\"", ",", 
                    RowBox[{"GrayLevel", "[", "0.5", "]"}]}], "}"}]}], ",", 
                 RowBox[{"ButtonData", "\[Rule]", 
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{"URL", "[", 
                    RowBox[{
                    "\"\<http://reference.wolfram.com/mathematica/\>\"", "<>",
                     "uri", "<>", "\"\<.ja.cdf\>\""}], "]"}], ",", "None"}], 
                   "}"}]}], ",", "\[IndentingNewLine]", 
                 RowBox[{"ButtonNote", "\[Rule]", 
                  RowBox[{
                  "\"\<http://reference.wolfram.com/mathematica/\>\"", "<>", 
                   "uri", "<>", "\"\<.ja.cdf\>\""}]}]}], "]"}], ",", " ", 
               "\"\<\[FilledRightTriangle]\>\"", ",", "\"\<     \>\"", ",", 
               " ", 
               RowBox[{"ButtonBox", "[", 
                RowBox[{
                 RowBox[{"StyleBox", "[", 
                  RowBox[{"\"\<\:4e2d\:6587\>\"", ",", 
                   RowBox[{"FontSize", "\[Rule]", "11"}]}], "]"}], ",", 
                 RowBox[{"BaseStyle", "\[Rule]", 
                  RowBox[{"{", 
                   RowBox[{"\"\<Hyperlink\>\"", ",", 
                    RowBox[{"GrayLevel", "[", "0.5", "]"}]}], "}"}]}], ",", 
                 RowBox[{"ButtonData", "\[Rule]", 
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{"URL", "[", 
                    RowBox[{
                    "\"\<http://reference.wolfram.com/mathematica/\>\"", "<>",
                     "uri", "<>", "\"\<.zh.cdf\>\""}], "]"}], ",", "None"}], 
                   "}"}]}], ",", 
                 RowBox[{"ButtonNote", "\[Rule]", 
                  RowBox[{
                  "\"\<http://reference.wolfram.com/mathematica/\>\"", "<>", 
                   "uri", "<>", "\"\<.zh.cdf\>\""}]}]}], "]"}], ",", " ", 
               "\"\<\[FilledRightTriangle]\>\""}], "}"}], "]"}], ",", 
            RowBox[{"StripOnInput", "\[Rule]", "False"}], ",", 
            RowBox[{"LineColor", "\[Rule]", 
             RowBox[{"GrayLevel", "[", "0.5", "]"}]}], ",", 
            RowBox[{"FrontFaceColor", "\[Rule]", 
             RowBox[{"GrayLevel", "[", "0.5", "]"}]}], ",", 
            RowBox[{"BackFaceColor", "\[Rule]", 
             RowBox[{"GrayLevel", "[", "0.5", "]"}]}], ",", 
            RowBox[{"GraphicsColor", "\[Rule]", 
             RowBox[{"GrayLevel", "[", "0.5", "]"}]}], ",", 
            RowBox[{"FontFamily", "\[Rule]", "\"\<Arial\>\""}], ",", 
            RowBox[{"FontSize", "\[Rule]", "9"}], ",", 
            RowBox[{"FontColor", "\[Rule]", 
             RowBox[{"GrayLevel", "[", "0.5", "]"}]}]}], "]"}], "]"}], ",", 
         "\"\<History\>\"", ",", 
         RowBox[{"CellFrame", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"0", ",", "0"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}], ",", 
         RowBox[{"CellMargins", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"145", ",", "120"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"20", ",", "0"}], "}"}]}], "}"}]}], ",", 
         RowBox[{"CellFrameColor", "\[Rule]", 
          RowBox[{"GrayLevel", "[", "0.8", "]"}]}]}], "]"}]}], " ", "]"}]}], 
    "]"}]}], ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmViYGCQBGIQ7ZUn6rVJ+5Vjej6nP4j2+J4cCqKXZKuEgejt25bH
geikm7fA9Ctbn3QQXSV+F0wHx24uBtEOgZ0lILpH+FEliP5y9QOYLmQKbV6r
88qxgjGlE0QfyRO6JG38yjGafS2YFprqGp9m+cox5WwimFYxv8+22vqVo5OU
MzuIzpnqxAOiFao7wfQza09hEN0VsVUWRG/ztbAG0bt7doDplGq/OBA9QV44
AURfc1UuAevb/aAURMve8OsG0adSpk0A0bdS+leD6Ffc6htA9GyPT7tBNIOV
/l6wunNrLoLoVf8uXwfRDdsLn4Lozrjq52A6sPfBJiD9xOvdYxCtVmP6EUTP
uBP5GUQ/it34HUTPl5dn3Qyk6+ou5hvZvHK8uv9oMYjeIfhfMw5Il6g3a4Fo
AEqGxhE=
  "]]
}, Closed]],

Cell[CellGroupData[{

Cell["Style Definitions", "Section",
 InitializationCell->True,
 CellChangeTimes->{{3.5091286882951527`*^9, 3.509128688999133*^9}, {
  3.510334625912217*^9, 3.510334629678709*^9}, {3.517922213537799*^9, 
  3.5179222169917793`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"styles", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Cell", "[", 
      RowBox[{
       RowBox[{"StyleData", "[", "\"\<1ColumnTableMod\>\"", "]"}], ",", 
       RowBox[{"ShowCellBracket", "\[Rule]", "False"}], ",", 
       RowBox[{"CellMargins", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"95", ",", "50"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"12", ",", 
            RowBox[{"-", "1"}]}], "}"}]}], "}"}]}], ",", " ", 
       RowBox[{"AllowGroupClose", "\[Rule]", "False"}], ",", 
       RowBox[{"AllowReverseGroupClose", "\[Rule]", "False"}]}], "]"}], ",", 
     RowBox[{"Cell", "[", 
      RowBox[{
       RowBox[{"StyleData", "[", "\"\<2ColumnTable\>\"", "]"}], ",", 
       RowBox[{"ShowCellBracket", "\[Rule]", "False"}], ",", 
       RowBox[{"CellMargins", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"119", ",", "50"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"12", ",", 
            RowBox[{"-", "1"}]}], "}"}]}], "}"}]}], ",", " ", 
       RowBox[{"AllowGroupClose", "\[Rule]", "False"}], ",", 
       RowBox[{"AllowReverseGroupClose", "\[Rule]", "False"}]}], "]"}], ",", 
     RowBox[{"Cell", "[", 
      RowBox[{
       RowBox[{"StyleData", "[", "\"\<2ColumnTableMod\>\"", "]"}], ",", 
       RowBox[{"ShowCellBracket", "\[Rule]", "False"}], ",", 
       RowBox[{"CellMargins", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"95", ",", "50"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"12", ",", 
            RowBox[{"-", "1"}]}], "}"}]}], "}"}]}], ",", " ", 
       RowBox[{"AllowGroupClose", "\[Rule]", "False"}], ",", 
       RowBox[{"AllowReverseGroupClose", "\[Rule]", "False"}]}], "]"}], ",", 
     RowBox[{"Cell", "[", 
      RowBox[{
       RowBox[{"StyleData", "[", "\"\<3ColumnTableMod\>\"", "]"}], ",", 
       RowBox[{"ShowCellBracket", "\[Rule]", "False"}], ",", 
       RowBox[{"CellMargins", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"95", ",", "50"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"12", ",", 
            RowBox[{"-", "1"}]}], "}"}]}], "}"}]}], ",", " ", 
       RowBox[{"AllowGroupClose", "\[Rule]", "False"}], ",", 
       RowBox[{"AllowReverseGroupClose", "\[Rule]", "False"}]}], "]"}], ",", 
     RowBox[{"Cell", "[", 
      RowBox[{
       RowBox[{"StyleData", "[", "\"\<AlphabeticalListing\>\"", "]"}], ",", 
       RowBox[{"ShowCellBracket", "\[Rule]", "False"}], ",", 
       RowBox[{"CellMargins", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"74", ",", "24"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"6", ",", "1"}], "}"}]}], "}"}]}], ",", " ", 
       RowBox[{"AllowGroupClose", "\[Rule]", "False"}], ",", 
       RowBox[{"AllowReverseGroupClose", "\[Rule]", "False"}]}], "]"}], ",", 
     RowBox[{"Cell", "[", 
      RowBox[{
       RowBox[{"StyleData", "[", "\"\<AwaitingReviewNote\>\"", "]"}], ",", 
       RowBox[{"ShowCellBracket", "\[Rule]", "False"}], ",", 
       RowBox[{"CellMargins", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"74", ",", "22"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"12", ",", "6"}], "}"}]}], "}"}]}], ",", " ", 
       RowBox[{"AllowGroupClose", "\[Rule]", "False"}], ",", 
       RowBox[{"AllowReverseGroupClose", "\[Rule]", "False"}]}], "]"}], ",", 
     RowBox[{"Cell", "[", 
      RowBox[{
       RowBox[{"StyleData", "[", "\"\<BulletedText\>\"", "]"}], ",", 
       RowBox[{"ShowCellBracket", "\[Rule]", "False"}], ",", 
       RowBox[{"CellMargins", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"104", ",", "27"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"4", ",", "4"}], "}"}]}], "}"}]}], ",", " ", 
       RowBox[{"AllowGroupClose", "\[Rule]", "False"}], ",", 
       RowBox[{"AllowReverseGroupClose", "\[Rule]", "False"}]}], "]"}], ",", 
     RowBox[{"Cell", "[", 
      RowBox[{
       RowBox[{"StyleData", "[", "\"\<Caption\>\"", "]"}], ",", 
       RowBox[{"ShowCellBracket", "\[Rule]", "False"}], ",", 
       RowBox[{"CellMargins", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"92", ",", "36"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"12", ",", "6"}], "}"}]}], "}"}]}], ",", " ", 
       RowBox[{"AllowGroupClose", "\[Rule]", "False"}], ",", 
       RowBox[{"AllowReverseGroupClose", "\[Rule]", "False"}]}], "]"}], ",", 
     RowBox[{"Cell", "[", 
      RowBox[{
       RowBox[{"StyleData", "[", "\"\<CharacterImage\>\"", "]"}], ",", 
       RowBox[{"ShowCellBracket", "\[Rule]", "False"}], ",", 
       RowBox[{"CellMargins", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"78", ",", "12"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"7", ",", "12"}], "}"}]}], "}"}]}], ",", " ", 
       RowBox[{"AllowGroupClose", "\[Rule]", "False"}], ",", 
       RowBox[{"AllowReverseGroupClose", "\[Rule]", "False"}]}], "]"}], ",", 
     RowBox[{"Cell", "[", 
      RowBox[{
       RowBox[{"StyleData", "[", "\"\<CharacterName\>\"", "]"}], ",", 
       RowBox[{"ShowCellBracket", "\[Rule]", "False"}], ",", 
       RowBox[{"CellMargins", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"88", ",", "12"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"20", ",", "7"}], "}"}]}], "}"}]}], ",", " ", 
       RowBox[{"AllowGroupClose", "\[Rule]", "False"}], ",", 
       RowBox[{"AllowReverseGroupClose", "\[Rule]", "False"}]}], "]"}], ",", 
     RowBox[{"Cell", "[", 
      RowBox[{
       RowBox[{"StyleData", "[", "\"\<Code\>\"", "]"}], ",", 
       RowBox[{"ShowCellBracket", "\[Rule]", "False"}], ",", 
       RowBox[{"CellMargins", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"116", ",", "10"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"5", ",", "10"}], "}"}]}], "}"}]}], ",", " ", 
       RowBox[{"AllowGroupClose", "\[Rule]", "False"}], ",", 
       RowBox[{"AllowReverseGroupClose", "\[Rule]", "False"}]}], "]"}], ",", 
     RowBox[{"Cell", "[", 
      RowBox[{
       RowBox[{"StyleData", "[", "\"\<ContractInterval\>\"", "]"}], ",", 
       RowBox[{"ShowCellBracket", "\[Rule]", "False"}], ",", 
       RowBox[{"CellMargins", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"57", ",", "3"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"4", ",", "4"}], "}"}]}], "}"}]}], ",", " ", 
       RowBox[{"AllowGroupClose", "\[Rule]", "False"}], ",", 
       RowBox[{"AllowReverseGroupClose", "\[Rule]", "False"}]}], "]"}], ",", 
     RowBox[{"Cell", "[", 
      RowBox[{
       RowBox[{"StyleData", "[", "\"\<ConversionLockdown\>\"", "]"}], ",", 
       RowBox[{"ShowCellBracket", "\[Rule]", "True"}], ",", 
       RowBox[{"CellMargins", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"130", ",", "10"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"5", ",", "7"}], "}"}]}], "}"}]}], ",", " ", 
       RowBox[{"AllowGroupClose", "\[Rule]", "False"}], ",", 
       RowBox[{"AllowReverseGroupClose", "\[Rule]", "False"}]}], "]"}], ",", 
     RowBox[{"Cell", "[", 
      RowBox[{
       RowBox[{"StyleData", "[", "\"\<CorrelationDissimilarity\>\"", "]"}], 
       ",", 
       RowBox[{"ShowCellBracket", "\[Rule]", "False"}], ",", 
       RowBox[{"CellMargins", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"57", ",", "3"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"4", ",", "4"}], "}"}]}], "}"}]}], ",", " ", 
       RowBox[{"AllowGroupClose", "\[Rule]", "False"}], ",", 
       RowBox[{"AllowReverseGroupClose", "\[Rule]", "False"}]}], "]"}], ",", 
     RowBox[{"Cell", "[", 
      RowBox[{
       RowBox[{"StyleData", "[", "\"\<CosineAngleDissimilarity\>\"", "]"}], 
       ",", 
       RowBox[{"ShowCellBracket", "\[Rule]", "False"}], ",", 
       RowBox[{"CellMargins", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"57", ",", "3"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"4", ",", "4"}], "}"}]}], "}"}]}], ",", " ", 
       RowBox[{"AllowGroupClose", "\[Rule]", "False"}], ",", 
       RowBox[{"AllowReverseGroupClose", "\[Rule]", "False"}]}], "]"}], ",", 
     RowBox[{"Cell", "[", 
      RowBox[{
       RowBox[{"StyleData", "[", "\"\<DefinitionBox\>\"", "]"}], ",", 
       RowBox[{"ShowCellBracket", "\[Rule]", "False"}], ",", 
       RowBox[{"CellMargins", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"77", ",", "27"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", "8"}], "}"}]}], "}"}]}], ",", " ", 
       RowBox[{"AllowGroupClose", "\[Rule]", "False"}], ",", 
       RowBox[{"AllowReverseGroupClose", "\[Rule]", "False"}]}], "]"}], ",", 
     RowBox[{"Cell", "[", 
      RowBox[{
       RowBox[{"StyleData", "[", "\"\<DefinitionBox1Col\>\"", "]"}], ",", 
       RowBox[{"ShowCellBracket", "\[Rule]", "False"}], ",", 
       RowBox[{"CellMargins", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"77", ",", "27"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", "8"}], "}"}]}], "}"}]}], ",", " ", 
       RowBox[{"AllowGroupClose", "\[Rule]", "False"}], ",", 
       RowBox[{"AllowReverseGroupClose", "\[Rule]", "False"}]}], "]"}], ",", 
     RowBox[{"Cell", "[", 
      RowBox[{
       RowBox[{"StyleData", "[", "\"\<DefinitionBox3Col\>\"", "]"}], ",", 
       RowBox[{"ShowCellBracket", "\[Rule]", "False"}], ",", 
       RowBox[{"CellMargins", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"77", ",", "27"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", "8"}], "}"}]}], "}"}]}], ",", " ", 
       RowBox[{"AllowGroupClose", "\[Rule]", "False"}], ",", 
       RowBox[{"AllowReverseGroupClose", "\[Rule]", "False"}]}], "]"}], ",", 
     RowBox[{"Cell", "[", 
      RowBox[{
       RowBox[{"StyleData", "[", "\"\<DefinitionBox4Col\>\"", "]"}], ",", 
       RowBox[{"ShowCellBracket", "\[Rule]", "False"}], ",", 
       RowBox[{"CellMargins", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"77", ",", "27"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", "8"}], "}"}]}], "}"}]}], ",", " ", 
       RowBox[{"AllowGroupClose", "\[Rule]", "False"}], ",", 
       RowBox[{"AllowReverseGroupClose", "\[Rule]", "False"}]}], "]"}], ",", 
     RowBox[{"Cell", "[", 
      RowBox[{
       RowBox[{"StyleData", "[", "\"\<DefinitionBox6Col\>\"", "]"}], ",", 
       RowBox[{"ShowCellBracket", "\[Rule]", "False"}], ",", 
       RowBox[{"CellMargins", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"77", ",", "27"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", "8"}], "}"}]}], "}"}]}], ",", " ", 
       RowBox[{"AllowGroupClose", "\[Rule]", "False"}], ",", 
       RowBox[{"AllowReverseGroupClose", "\[Rule]", "False"}]}], "]"}], ",", 
     RowBox[{"Cell", "[", 
      RowBox[{
       RowBox[{"StyleData", "[", "\"\<Description\>\"", "]"}], ",", 
       RowBox[{"ShowCellBracket", "\[Rule]", "False"}], ",", 
       RowBox[{"CellMargins", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"57", ",", "3"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"4", ",", "4"}], "}"}]}], "}"}]}], ",", " ", 
       RowBox[{"AllowGroupClose", "\[Rule]", "False"}], ",", 
       RowBox[{"AllowReverseGroupClose", "\[Rule]", "False"}]}], "]"}], ",", 
     RowBox[{"Cell", "[", 
      RowBox[{
       RowBox[{"StyleData", "[", "\"\<DisplayMath\>\"", "]"}], ",", 
       RowBox[{"ShowCellBracket", "\[Rule]", "False"}], ",", 
       RowBox[{"CellMargins", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"112", ",", "39"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"8", ",", "12"}], "}"}]}], "}"}]}], ",", " ", 
       RowBox[{"AllowGroupClose", "\[Rule]", "False"}], ",", 
       RowBox[{"AllowReverseGroupClose", "\[Rule]", "False"}]}], "]"}], ",", 
     RowBox[{"Cell", "[", 
      RowBox[{
       RowBox[{"StyleData", "[", "\"\<DockedCell\>\"", "]"}], ",", 
       RowBox[{"ShowCellBracket", "\[Rule]", "False"}], ",", 
       RowBox[{"CellMargins", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"50", ",", "0"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", "0"}], "}"}]}], "}"}]}], ",", " ", 
       RowBox[{"AllowGroupClose", "\[Rule]", "False"}], ",", 
       RowBox[{"AllowReverseGroupClose", "\[Rule]", "False"}]}], "]"}], ",", 
     RowBox[{"Cell", "[", 
      RowBox[{
       RowBox[{"StyleData", "[", "\"\<DoubleBox\>\"", "]"}], ",", 
       RowBox[{"ShowCellBracket", "\[Rule]", "False"}], ",", 
       RowBox[{"CellMargins", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"77", ",", "12"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", "8"}], "}"}]}], "}"}]}], ",", " ", 
       RowBox[{"AllowGroupClose", "\[Rule]", "False"}], ",", 
       RowBox[{"AllowReverseGroupClose", "\[Rule]", "False"}]}], "]"}], ",", 
     RowBox[{"Cell", "[", 
      RowBox[{
       RowBox[{"StyleData", "[", "\"\<ElementsSection\>\"", "]"}], ",", 
       RowBox[{"ShowCellBracket", "\[Rule]", "False"}], ",", 
       RowBox[{"CellMargins", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"74", ",", "24"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"6", ",", "18"}], "}"}]}], "}"}]}], ",", " ", 
       RowBox[{"AllowGroupClose", "\[Rule]", "True"}], ",", 
       RowBox[{"AllowReverseGroupClose", "\[Rule]", "True"}]}], "]"}], ",", 
     RowBox[{"Cell", "[", 
      RowBox[{
       RowBox[{"StyleData", "[", "\"\<ExampleDelimiter\>\"", "]"}], ",", 
       RowBox[{"ShowCellBracket", "\[Rule]", "False"}], ",", 
       RowBox[{"CellMargins", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"130", ",", "24"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "6"}], ",", "0"}], "}"}]}], "}"}]}], ",", " ", 
       RowBox[{"AllowGroupClose", "\[Rule]", "False"}], ",", 
       RowBox[{"AllowReverseGroupClose", "\[Rule]", "False"}]}], "]"}], ",", 
     RowBox[{"Cell", "[", 
      RowBox[{
       RowBox[{"StyleData", "[", "\"\<ExampleSection\>\"", "]"}], ",", 
       RowBox[{"ShowCellBracket", "\[Rule]", "False"}], ",", 
       RowBox[{"CellMargins", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"100", ",", "24"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", "14"}], "}"}]}], "}"}]}], ",", " ", 
       RowBox[{"AllowGroupClose", "\[Rule]", "True"}], ",", 
       RowBox[{"AllowReverseGroupClose", "\[Rule]", "True"}]}], "]"}], ",", 
     RowBox[{"Cell", "[", 
      RowBox[{
       RowBox[{"StyleData", "[", "\"\<ExampleSubsection\>\"", "]"}], ",", 
       RowBox[{"ShowCellBracket", "\[Rule]", "False"}], ",", 
       RowBox[{"CellMargins", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"115", ",", "24"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"2", ",", "6"}], "}"}]}], "}"}]}], ",", " ", 
       RowBox[{"AllowGroupClose", "\[Rule]", "True"}], ",", 
       RowBox[{"AllowReverseGroupClose", "\[Rule]", "True"}]}], "]"}], ",", 
     RowBox[{"Cell", "[", 
      RowBox[{
       RowBox[{"StyleData", "[", "\"\<ExampleSubsubsection\>\"", "]"}], ",", 
       RowBox[{"ShowCellBracket", "\[Rule]", "False"}], ",", 
       RowBox[{"CellMargins", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"130", ",", "24"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"2", ",", "4"}], "}"}]}], "}"}]}], ",", " ", 
       RowBox[{"AllowGroupClose", "\[Rule]", "True"}], ",", 
       RowBox[{"AllowReverseGroupClose", "\[Rule]", "True"}]}], "]"}], ",", 
     RowBox[{"Cell", "[", 
      RowBox[{
       RowBox[{"StyleData", "[", "\"\<ExampleText\>\"", "]"}], ",", 
       RowBox[{"ShowCellBracket", "\[Rule]", "False"}], ",", 
       RowBox[{"CellMargins", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"130", ",", "40"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"6", ",", "14"}], "}"}]}], "}"}]}], ",", " ", 
       RowBox[{"AllowGroupClose", "\[Rule]", "False"}], ",", 
       RowBox[{"AllowReverseGroupClose", "\[Rule]", "False"}]}], "]"}], ",", 
     RowBox[{"Cell", "[", 
      RowBox[{
       RowBox[{"StyleData", "[", "\"\<ExponentialSmoothing\>\"", "]"}], ",", 
       RowBox[{"ShowCellBracket", "\[Rule]", "False"}], ",", 
       RowBox[{"CellMargins", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"57", ",", "3"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"4", ",", "4"}], "}"}]}], "}"}]}], ",", " ", 
       RowBox[{"AllowGroupClose", "\[Rule]", "False"}], ",", 
       RowBox[{"AllowReverseGroupClose", "\[Rule]", "False"}]}], "]"}], ",", 
     RowBox[{"Cell", "[", 
      RowBox[{
       RowBox[{"StyleData", "[", "\"\<Extensions\>\"", "]"}], ",", 
       RowBox[{"ShowCellBracket", "\[Rule]", "False"}], ",", 
       RowBox[{"CellMargins", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"100", ",", "12"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"2", ",", "2"}], "}"}]}], "}"}]}], ",", " ", 
       RowBox[{"AllowGroupClose", "\[Rule]", "False"}], ",", 
       RowBox[{"AllowReverseGroupClose", "\[Rule]", "False"}]}], "]"}], ",", 
     RowBox[{"Cell", "[", 
      RowBox[{
       RowBox[{"StyleData", "[", "\"\<Fade\>\"", "]"}], ",", 
       RowBox[{"ShowCellBracket", "\[Rule]", "False"}], ",", 
       RowBox[{"CellMargins", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"57", ",", "3"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"4", ",", "4"}], "}"}]}], "}"}]}], ",", " ", 
       RowBox[{"AllowGroupClose", "\[Rule]", "False"}], ",", 
       RowBox[{"AllowReverseGroupClose", "\[Rule]", "False"}]}], "]"}], ",", 
     RowBox[{"Cell", "[", 
      RowBox[{
       RowBox[{"StyleData", "[", "\"\<FooterCell\>\"", "]"}], ",", 
       RowBox[{"ShowCellBracket", "\[Rule]", "False"}], ",", 
       RowBox[{"CellMargins", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"77", ",", "27"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"8", ",", "20"}], "}"}]}], "}"}]}], ",", " ", 
       RowBox[{"AllowGroupClose", "\[Rule]", "False"}], ",", 
       RowBox[{"AllowReverseGroupClose", "\[Rule]", "False"}]}], "]"}], ",", 
     RowBox[{"Cell", "[", 
      RowBox[{
       RowBox[{"StyleData", "[", "\"\<FormatNotes\>\"", "]"}], ",", 
       RowBox[{"ShowCellBracket", "\[Rule]", "False"}], ",", 
       RowBox[{"CellMargins", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"100", ",", "24"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"7", ",", "5"}], "}"}]}], "}"}]}], ",", " ", 
       RowBox[{"AllowGroupClose", "\[Rule]", "False"}], ",", 
       RowBox[{"AllowReverseGroupClose", "\[Rule]", "False"}]}], "]"}], ",", 
     RowBox[{"Cell", "[", 
      RowBox[{
       RowBox[{"StyleData", "[", "\"\<FormatUsage\>\"", "]"}], ",", 
       RowBox[{"ShowCellBracket", "\[Rule]", "False"}], ",", 
       RowBox[{"CellMargins", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"74", ",", "8"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"6", ",", "6"}], "}"}]}], "}"}]}], ",", " ", 
       RowBox[{"AllowGroupClose", "\[Rule]", "False"}], ",", 
       RowBox[{"AllowReverseGroupClose", "\[Rule]", "False"}]}], "]"}], ",", 
     RowBox[{"Cell", "[", 
      RowBox[{
       RowBox[{"StyleData", "[", "\"\<FramedBox\>\"", "]"}], ",", 
       RowBox[{"ShowCellBracket", "\[Rule]", "False"}], ",", 
       RowBox[{"CellMargins", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"77", ",", "12"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", "8"}], "}"}]}], "}"}]}], ",", " ", 
       RowBox[{"AllowGroupClose", "\[Rule]", "False"}], ",", 
       RowBox[{"AllowReverseGroupClose", "\[Rule]", "False"}]}], "]"}], ",", 
     RowBox[{"Cell", "[", 
      RowBox[{
       RowBox[{"StyleData", "[", "\"\<Graphics\>\"", "]"}], ",", 
       RowBox[{"ShowCellBracket", "\[Rule]", "False"}], ",", 
       RowBox[{"CellMargins", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"130", ",", "10"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"16", ",", "5"}], "}"}]}], "}"}]}], ",", " ", 
       RowBox[{"AllowGroupClose", "\[Rule]", "False"}], ",", 
       RowBox[{"AllowReverseGroupClose", "\[Rule]", "False"}]}], "]"}], ",", 
     RowBox[{"Cell", "[", 
      RowBox[{
       RowBox[{"StyleData", "[", "\"\<GuideAbstract\>\"", "]"}], ",", 
       RowBox[{"ShowCellBracket", "\[Rule]", "False"}], ",", 
       RowBox[{"CellMargins", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"74", ",", "24"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"20", ",", "9"}], "}"}]}], "}"}]}], ",", " ", 
       RowBox[{"AllowGroupClose", "\[Rule]", "False"}], ",", 
       RowBox[{"AllowReverseGroupClose", "\[Rule]", "False"}]}], "]"}], ",", 
     RowBox[{"Cell", "[", 
      RowBox[{
       RowBox[{"StyleData", "[", "\"\<GuideDelimiter\>\"", "]"}], ",", 
       RowBox[{"ShowCellBracket", "\[Rule]", "False"}], ",", 
       RowBox[{"CellMargins", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"74", ",", "24"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"4", ",", "10"}], "}"}]}], "}"}]}], ",", " ", 
       RowBox[{"AllowGroupClose", "\[Rule]", "False"}], ",", 
       RowBox[{"AllowReverseGroupClose", "\[Rule]", "False"}]}], "]"}], ",", 
     RowBox[{"Cell", "[", 
      RowBox[{
       RowBox[{"StyleData", "[", "\"\<GuideDelimiterSubsection\>\"", "]"}], 
       ",", 
       RowBox[{"ShowCellBracket", "\[Rule]", "False"}], ",", 
       RowBox[{"CellMargins", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"74", ",", "24"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "1"}], ",", "10"}], "}"}]}], "}"}]}], ",", " ", 
       RowBox[{"AllowGroupClose", "\[Rule]", "False"}], ",", 
       RowBox[{"AllowReverseGroupClose", "\[Rule]", "False"}]}], "]"}], ",", 
     RowBox[{"Cell", "[", 
      RowBox[{
       RowBox[{"StyleData", "[", "\"\<GuideFunctionsSection\>\"", "]"}], ",", 
       
       RowBox[{"ShowCellBracket", "\[Rule]", "False"}], ",", 
       RowBox[{"CellMargins", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"74", ",", "24"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"10", ",", "36"}], "}"}]}], "}"}]}], ",", " ", 
       RowBox[{"AllowGroupClose", "\[Rule]", "False"}], ",", 
       RowBox[{"AllowReverseGroupClose", "\[Rule]", "False"}]}], "]"}], ",", 
     RowBox[{"Cell", "[", 
      RowBox[{
       RowBox[{"StyleData", "[", "\"\<GuideFunctionsSubsection\>\"", "]"}], 
       ",", 
       RowBox[{"ShowCellBracket", "\[Rule]", "False"}], ",", 
       RowBox[{"CellMargins", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"74", ",", "24"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"5", ",", "10"}], "}"}]}], "}"}]}], ",", " ", 
       RowBox[{"AllowGroupClose", "\[Rule]", "False"}], ",", 
       RowBox[{"AllowReverseGroupClose", "\[Rule]", "False"}]}], "]"}], ",", 
     RowBox[{"Cell", "[", 
      RowBox[{
       RowBox[{"StyleData", "[", "\"\<GuideMoreAbout\>\"", "]"}], ",", 
       RowBox[{"ShowCellBracket", "\[Rule]", "False"}], ",", 
       RowBox[{"CellMargins", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"86", ",", "24"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"2", ",", "2"}], "}"}]}], "}"}]}], ",", " ", 
       RowBox[{"AllowGroupClose", "\[Rule]", "False"}], ",", 
       RowBox[{"AllowReverseGroupClose", "\[Rule]", "False"}]}], "]"}], ",", 
     RowBox[{"Cell", "[", 
      RowBox[{
       RowBox[{"StyleData", "[", "\"\<GuideMoreAboutSection\>\"", "]"}], ",", 
       
       RowBox[{"ShowCellBracket", "\[Rule]", "False"}], ",", 
       RowBox[{"CellFrameMargins", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"0", ",", "0"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", "10"}], "}"}]}], "}"}]}], ",", " ", 
       RowBox[{"CellMargins", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"74", ",", "24"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"12", ",", "33"}], "}"}]}], "}"}]}], ",", " ", 
       RowBox[{"AllowGroupClose", "\[Rule]", "False"}], ",", 
       RowBox[{"AllowReverseGroupClose", "\[Rule]", "False"}]}], "]"}], ",", 
     RowBox[{"Cell", "[", 
      RowBox[{
       RowBox[{"StyleData", "[", "\"\<GuideMoreAboutSub\>\"", "]"}], ",", 
       RowBox[{"ShowCellBracket", "\[Rule]", "False"}], ",", 
       RowBox[{"CellMargins", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"86", ",", "24"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"2", ",", "2"}], "}"}]}], "}"}]}], ",", " ", 
       RowBox[{"AllowGroupClose", "\[Rule]", "False"}], ",", 
       RowBox[{"AllowReverseGroupClose", "\[Rule]", "False"}]}], "]"}], ",", 
     RowBox[{"Cell", "[", 
      RowBox[{
       RowBox[{"StyleData", "[", "\"\<GuideRelatedLinks\>\"", "]"}], ",", 
       RowBox[{"ShowCellBracket", "\[Rule]", "False"}], ",", 
       RowBox[{"CellMargins", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"86", ",", "24"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"2", ",", "2"}], "}"}]}], "}"}]}], ",", " ", 
       RowBox[{"AllowGroupClose", "\[Rule]", "False"}], ",", 
       RowBox[{"AllowReverseGroupClose", "\[Rule]", "False"}]}], "]"}], ",", 
     RowBox[{"Cell", "[", 
      RowBox[{
       RowBox[{"StyleData", "[", "\"\<GuideRelatedLinksSection\>\"", "]"}], 
       ",", 
       RowBox[{"ShowCellBracket", "\[Rule]", "False"}], ",", 
       RowBox[{"CellFrameMargins", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"0", ",", "0"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", "10"}], "}"}]}], "}"}]}], ",", " ", 
       RowBox[{"CellMargins", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"74", ",", "24"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"12", ",", "33"}], "}"}]}], "}"}]}], ",", " ", 
       RowBox[{"AllowGroupClose", "\[Rule]", "False"}], ",", 
       RowBox[{"AllowReverseGroupClose", "\[Rule]", "False"}]}], "]"}], ",", 
     RowBox[{"Cell", "[", 
      RowBox[{
       RowBox[{"StyleData", "[", "\"\<GuideText\>\"", "]"}], ",", 
       RowBox[{"ShowCellBracket", "\[Rule]", "False"}], ",", 
       RowBox[{"CellMargins", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"74", ",", "24"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"6", ",", "1"}], "}"}]}], "}"}]}], ",", " ", 
       RowBox[{"AllowGroupClose", "\[Rule]", "False"}], ",", 
       RowBox[{"AllowReverseGroupClose", "\[Rule]", "False"}]}], "]"}], ",", 
     RowBox[{"Cell", "[", 
      RowBox[{
       RowBox[{"StyleData", "[", "\"\<GuideTitle\>\"", "]"}], ",", 
       RowBox[{"ShowCellBracket", "\[Rule]", "False"}], ",", 
       RowBox[{"CellMargins", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"74", ",", "24"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"4", ",", "37"}], "}"}]}], "}"}]}], ",", " ", 
       RowBox[{"AllowGroupClose", "\[Rule]", "False"}], ",", 
       RowBox[{"AllowReverseGroupClose", "\[Rule]", "False"}]}], "]"}], ",", 
     RowBox[{"Cell", "[", 
      RowBox[{
       RowBox[{"StyleData", "[", "\"\<GuideTOCAbstract\>\"", "]"}], ",", 
       RowBox[{"ShowCellBracket", "\[Rule]", "False"}], ",", 
       RowBox[{"CellMargins", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"74", ",", "24"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"30", ",", "9"}], "}"}]}], "}"}]}], ",", " ", 
       RowBox[{"AllowGroupClose", "\[Rule]", "False"}], ",", 
       RowBox[{"AllowReverseGroupClose", "\[Rule]", "False"}]}], "]"}], ",", 
     RowBox[{"Cell", "[", 
      RowBox[{
       RowBox[{"StyleData", "[", "\"\<GuideTOCLink\>\"", "]"}], ",", 
       RowBox[{"ShowCellBracket", "\[Rule]", "False"}], ",", 
       RowBox[{"CellMargins", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"88", ",", "24"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"8", ",", "6"}], "}"}]}], "}"}]}], ",", " ", 
       RowBox[{"AllowGroupClose", "\[Rule]", "False"}], ",", 
       RowBox[{"AllowReverseGroupClose", "\[Rule]", "False"}]}], "]"}], ",", 
     RowBox[{"Cell", "[", 
      RowBox[{
       RowBox[{"StyleData", "[", "\"\<GuideTOCTitle\>\"", "]"}], ",", 
       RowBox[{"ShowCellBracket", "\[Rule]", "False"}], ",", 
       RowBox[{"CellMargins", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"74", ",", "24"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"4", ",", "50"}], "}"}]}], "}"}]}], ",", " ", 
       RowBox[{"AllowGroupClose", "\[Rule]", "False"}], ",", 
       RowBox[{"AllowReverseGroupClose", "\[Rule]", "False"}]}], "]"}], ",", 
     RowBox[{"Cell", "[", 
      RowBox[{
       RowBox[{"StyleData", "[", "\"\<GuideTutorial\>\"", "]"}], ",", 
       RowBox[{"ShowCellBracket", "\[Rule]", "False"}], ",", 
       RowBox[{"CellMargins", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"86", ",", "24"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"2", ",", "2"}], "}"}]}], "}"}]}], ",", " ", 
       RowBox[{"AllowGroupClose", "\[Rule]", "False"}], ",", 
       RowBox[{"AllowReverseGroupClose", "\[Rule]", "False"}]}], "]"}], ",", 
     RowBox[{"Cell", "[", 
      RowBox[{
       RowBox[{"StyleData", "[", "\"\<GuideTutorialCollection\>\"", "]"}], 
       ",", 
       RowBox[{"ShowCellBracket", "\[Rule]", "False"}], ",", 
       RowBox[{"CellMargins", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"86", ",", "24"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"2", ",", "2"}], "}"}]}], "}"}]}], ",", " ", 
       RowBox[{"AllowGroupClose", "\[Rule]", "False"}], ",", 
       RowBox[{"AllowReverseGroupClose", "\[Rule]", "False"}]}], "]"}], ",", 
     RowBox[{"Cell", "[", 
      RowBox[{
       RowBox[{
       "StyleData", "[", "\"\<GuideTutorialCollectionSection\>\"", "]"}], ",", 
       RowBox[{"ShowCellBracket", "\[Rule]", "False"}], ",", 
       RowBox[{"CellFrameMargins", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"0", ",", "0"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", "10"}], "}"}]}], "}"}]}], ",", " ", 
       RowBox[{"CellMargins", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"74", ",", "24"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"12", ",", "33"}], "}"}]}], "}"}]}], ",", " ", 
       RowBox[{"AllowGroupClose", "\[Rule]", "False"}], ",", 
       RowBox[{"AllowReverseGroupClose", "\[Rule]", "False"}]}], "]"}], ",", 
     RowBox[{"Cell", "[", 
      RowBox[{
       RowBox[{"StyleData", "[", "\"\<GuideTutorialsSection\>\"", "]"}], ",", 
       
       RowBox[{"ShowCellBracket", "\[Rule]", "False"}], ",", 
       RowBox[{"CellFrameMargins", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"0", ",", "0"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", "10"}], "}"}]}], "}"}]}], ",", " ", 
       RowBox[{"CellMargins", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"74", ",", "24"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"12", ",", "33"}], "}"}]}], "}"}]}], ",", " ", 
       RowBox[{"AllowGroupClose", "\[Rule]", "False"}], ",", 
       RowBox[{"AllowReverseGroupClose", "\[Rule]", "False"}]}], "]"}], ",", 
     RowBox[{"Cell", "[", 
      RowBox[{
       RowBox[{"StyleData", "[", "\"\<HighlightColor\>\"", "]"}], ",", 
       RowBox[{"ShowCellBracket", "\[Rule]", "False"}], ",", 
       RowBox[{"CellMargins", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"57", ",", "3"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"4", ",", "4"}], "}"}]}], "}"}]}], ",", " ", 
       RowBox[{"AllowGroupClose", "\[Rule]", "False"}], ",", 
       RowBox[{"AllowReverseGroupClose", "\[Rule]", "False"}]}], "]"}], ",", 
     RowBox[{"Cell", "[", 
      RowBox[{
       RowBox[{"StyleData", "[", "\"\<History\>\"", "]"}], ",", 
       RowBox[{"ShowCellBracket", "\[Rule]", "False"}], ",", 
       RowBox[{"CellMargins", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"74", ",", "24"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"9", ",", "18"}], "}"}]}], "}"}]}], ",", " ", 
       RowBox[{"AllowGroupClose", "\[Rule]", "False"}], ",", 
       RowBox[{"AllowReverseGroupClose", "\[Rule]", "False"}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"Cell", "[", 
      RowBox[{
       RowBox[{"StyleData", "[", "\"\<Horner\>\"", "]"}], ",", 
       RowBox[{"ShowCellBracket", "\[Rule]", "False"}], ",", 
       RowBox[{"CellMargins", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"57", ",", "3"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"4", ",", "4"}], "}"}]}], "}"}]}], ",", " ", 
       RowBox[{"AllowGroupClose", "\[Rule]", "False"}], ",", 
       RowBox[{"AllowReverseGroupClose", "\[Rule]", "False"}]}], "]"}], ",", 
     RowBox[{"Cell", "[", 
      RowBox[{
       RowBox[{"StyleData", "[", "\"\<HowToAbstract\>\"", "]"}], ",", 
       RowBox[{"ShowCellBracket", "\[Rule]", "False"}], ",", 
       RowBox[{"CellMargins", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"86", ",", "27"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"20", ",", "0"}], "}"}]}], "}"}]}], ",", " ", 
       RowBox[{"AllowGroupClose", "\[Rule]", "False"}], ",", 
       RowBox[{"AllowReverseGroupClose", "\[Rule]", "False"}]}], "]"}], ",", 
     RowBox[{"Cell", "[", 
      RowBox[{
       RowBox[{"StyleData", "[", "\"\<HowToDelimiter\>\"", "]"}], ",", 
       RowBox[{"ShowCellBracket", "\[Rule]", "False"}], ",", 
       RowBox[{"CellMargins", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"86", ",", "10"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", "3"}], "}"}]}], "}"}]}], ",", " ", 
       RowBox[{"AllowGroupClose", "\[Rule]", "False"}], ",", 
       RowBox[{"AllowReverseGroupClose", "\[Rule]", "False"}]}], "]"}], ",", 
     RowBox[{"Cell", "[", 
      RowBox[{
       RowBox[{"StyleData", "[", "\"\<HowToText\>\"", "]"}], ",", 
       RowBox[{"ShowCellBracket", "\[Rule]", "False"}], ",", 
       RowBox[{"CellMargins", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"86", ",", "27"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"4", ",", "20"}], "}"}]}], "}"}]}], ",", " ", 
       RowBox[{"AllowGroupClose", "\[Rule]", "False"}], ",", 
       RowBox[{"AllowReverseGroupClose", "\[Rule]", "False"}]}], "]"}], ",", 
     RowBox[{"Cell", "[", 
      RowBox[{
       RowBox[{"StyleData", "[", "\"\<HowToTitle\>\"", "]"}], ",", 
       RowBox[{"ShowCellBracket", "\[Rule]", "False"}], ",", 
       RowBox[{"CellMargins", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"86", ",", "27"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"10", ",", "20"}], "}"}]}], "}"}]}], ",", " ", 
       RowBox[{"AllowGroupClose", "\[Rule]", "False"}], ",", 
       RowBox[{"AllowReverseGroupClose", "\[Rule]", "False"}]}], "]"}], ",", 
     RowBox[{"Cell", "[", 
      RowBox[{
       RowBox[{"StyleData", "[", "\"\<ImportExportSection\>\"", "]"}], ",", 
       RowBox[{"ShowCellBracket", "\[Rule]", "False"}], ",", 
       RowBox[{"CellFrameMargins", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"0", ",", "0"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", "10"}], "}"}]}], "}"}]}], ",", " ", 
       RowBox[{"CellMargins", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"74", ",", "24"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"12", ",", "33"}], "}"}]}], "}"}]}], ",", " ", 
       RowBox[{"AllowGroupClose", "\[Rule]", "True"}], ",", 
       RowBox[{"AllowReverseGroupClose", "\[Rule]", "True"}]}], "]"}], ",", 
     RowBox[{"Cell", "[", 
      RowBox[{
       RowBox[{"StyleData", "[", "\"\<IndentedText\>\"", "]"}], ",", 
       RowBox[{"ShowCellBracket", "\[Rule]", "False"}], ",", 
       RowBox[{"CellMargins", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"112", ",", "36"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"8", ",", "12"}], "}"}]}], "}"}]}], ",", " ", 
       RowBox[{"AllowGroupClose", "\[Rule]", "False"}], ",", 
       RowBox[{"AllowReverseGroupClose", "\[Rule]", "False"}]}], "]"}], ",", 
     RowBox[{"Cell", "[", 
      RowBox[{
       RowBox[{"StyleData", "[", "\"\<IndicatorExampleSection\>\"", "]"}], 
       ",", 
       RowBox[{"ShowCellBracket", "\[Rule]", "False"}], ",", 
       RowBox[{"CellFrameMargins", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"0", ",", "0"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", "10"}], "}"}]}], "}"}]}], ",", 
       RowBox[{"CellMargins", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"74", ",", "24"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"12", ",", "33"}], "}"}]}], "}"}]}], ",", " ", 
       RowBox[{"AllowGroupClose", "\[Rule]", "True"}], ",", 
       RowBox[{"AllowReverseGroupClose", "\[Rule]", "True"}]}], "]"}], ",", 
     RowBox[{"Cell", "[", 
      RowBox[{
       RowBox[{"StyleData", "[", "\"\<IndicatorUsage\>\"", "]"}], ",", 
       RowBox[{"ShowCellBracket", "\[Rule]", "False"}], ",", 
       RowBox[{"CellMargins", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"74", ",", "8"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"6", ",", "6"}], "}"}]}], "}"}]}], ",", " ", 
       RowBox[{"AllowGroupClose", "\[Rule]", "False"}], ",", 
       RowBox[{"AllowReverseGroupClose", "\[Rule]", "False"}]}], "]"}], ",", 
     RowBox[{"Cell", "[", 
      RowBox[{
       RowBox[{"StyleData", "[", "\"\<InfoCell\>\"", "]"}], ",", 
       RowBox[{"ShowCellBracket", "\[Rule]", "False"}], ",", 
       RowBox[{"CellMargins", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"57", ",", "3"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"4", ",", "4"}], "}"}]}], "}"}]}], ",", " ", 
       RowBox[{"AllowGroupClose", "\[Rule]", "False"}], ",", 
       RowBox[{"AllowReverseGroupClose", "\[Rule]", "False"}]}], "]"}], ",", 
     RowBox[{"Cell", "[", 
      RowBox[{
       RowBox[{"StyleData", "[", "\"\<InlineCode\>\"", "]"}], ",", 
       RowBox[{"ShowCellBracket", "\[Rule]", "False"}], ",", 
       RowBox[{"CellMargins", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"57", ",", "3"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"4", ",", "4"}], "}"}]}], "}"}]}], ",", " ", 
       RowBox[{"AllowGroupClose", "\[Rule]", "False"}], ",", 
       RowBox[{"AllowReverseGroupClose", "\[Rule]", "False"}]}], "]"}], ",", 
     RowBox[{"Cell", "[", 
      RowBox[{
       RowBox[{"StyleData", "[", "\"\<InlineGuideFunctionListing\>\"", "]"}], 
       ",", 
       RowBox[{"ShowCellBracket", "\[Rule]", "False"}], ",", 
       RowBox[{"CellMargins", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"74", ",", "24"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"5", ",", "1"}], "}"}]}], "}"}]}], ",", " ", 
       RowBox[{"AllowGroupClose", "\[Rule]", "False"}], ",", 
       RowBox[{"AllowReverseGroupClose", "\[Rule]", "False"}]}], "]"}], ",", 
     RowBox[{"Cell", "[", 
      RowBox[{
       RowBox[{"StyleData", "[", "\"\<Input\>\"", "]"}], ",", 
       RowBox[{"ShowCellBracket", "\[Rule]", "True"}], ",", 
       RowBox[{"CellMargins", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"130", ",", "10"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"5", ",", "7"}], "}"}]}], "}"}]}], ",", " ", 
       RowBox[{"AllowGroupClose", "\[Rule]", "True"}], ",", 
       RowBox[{"AllowReverseGroupClose", "\[Rule]", "True"}]}], "]"}], ",", 
     RowBox[{"Cell", "[", 
      RowBox[{
       RowBox[{"StyleData", "[", "\"\<InputLarge\>\"", "]"}], ",", 
       RowBox[{"ShowCellBracket", "\[Rule]", "False"}], ",", 
       RowBox[{"CellMargins", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"57", ",", "3"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"4", ",", "4"}], "}"}]}], "}"}]}], ",", " ", 
       RowBox[{"AllowGroupClose", "\[Rule]", "False"}], ",", 
       RowBox[{"AllowReverseGroupClose", "\[Rule]", "False"}]}], "]"}], ",", 
     RowBox[{"Cell", "[", 
      RowBox[{
       RowBox[{"StyleData", "[", "\"\<InputOnly\>\"", "]"}], ",", 
       RowBox[{"ShowCellBracket", "\[Rule]", "False"}], ",", 
       RowBox[{"CellMargins", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"116", ",", "10"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"7", ",", "7"}], "}"}]}], "}"}]}], ",", " ", 
       RowBox[{"AllowGroupClose", "\[Rule]", "False"}], ",", 
       RowBox[{"AllowReverseGroupClose", "\[Rule]", "False"}]}], "]"}], ",", 
     RowBox[{"Cell", "[", 
      RowBox[{
       RowBox[{"StyleData", "[", "\"\<ItemizedPicture\>\"", "]"}], ",", 
       RowBox[{"ShowCellBracket", "\[Rule]", "False"}], ",", 
       RowBox[{"CellMargins", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"136", ",", "36"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"8", ",", "12"}], "}"}]}], "}"}]}], ",", " ", 
       RowBox[{"AllowGroupClose", "\[Rule]", "False"}], ",", 
       RowBox[{"AllowReverseGroupClose", "\[Rule]", "False"}]}], "]"}], ",", 
     RowBox[{"Cell", "[", 
      RowBox[{
       RowBox[{"StyleData", "[", "\"\<ItemizedText\>\"", "]"}], ",", 
       RowBox[{"ShowCellBracket", "\[Rule]", "False"}], ",", 
       RowBox[{"CellMargins", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"136", ",", "36"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"8", ",", "12"}], "}"}]}], "}"}]}], ",", " ", 
       RowBox[{"AllowGroupClose", "\[Rule]", "False"}], ",", 
       RowBox[{"AllowReverseGroupClose", "\[Rule]", "False"}]}], "]"}], ",", 
     RowBox[{"Cell", "[", 
      RowBox[{
       RowBox[{"StyleData", "[", "\"\<ItemizedTextParagraph\>\"", "]"}], ",", 
       
       RowBox[{"ShowCellBracket", "\[Rule]", "False"}], ",", 
       RowBox[{"CellMargins", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"112", ",", "36"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"8", ",", "12"}], "}"}]}], "}"}]}], ",", " ", 
       RowBox[{"AllowGroupClose", "\[Rule]", "False"}], ",", 
       RowBox[{"AllowReverseGroupClose", "\[Rule]", "False"}]}], "]"}], ",", 
     RowBox[{"Cell", "[", 
      RowBox[{
       RowBox[{"StyleData", "[", "\"\<Leaf 1\>\"", "]"}], ",", 
       RowBox[{"ShowCellBracket", "\[Rule]", "False"}], ",", 
       RowBox[{"CellMargins", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"57", ",", "3"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"4", ",", "4"}], "}"}]}], "}"}]}], ",", " ", 
       RowBox[{"AllowGroupClose", "\[Rule]", "False"}], ",", 
       RowBox[{"AllowReverseGroupClose", "\[Rule]", "False"}]}], "]"}], ",", 
     RowBox[{"Cell", "[", 
      RowBox[{
       RowBox[{"StyleData", "[", "\"\<Level 1\>\"", "]"}], ",", 
       RowBox[{"ShowCellBracket", "\[Rule]", "False"}], ",", 
       RowBox[{"CellMargins", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"57", ",", "3"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"4", ",", "4"}], "}"}]}], "}"}]}], ",", " ", 
       RowBox[{"AllowGroupClose", "\[Rule]", "False"}], ",", 
       RowBox[{"AllowReverseGroupClose", "\[Rule]", "False"}]}], "]"}], ",", 
     RowBox[{"Cell", "[", 
      RowBox[{
       RowBox[{"StyleData", "[", "\"\<MathCaption\>\"", "]"}], ",", 
       RowBox[{"ShowCellBracket", "\[Rule]", "False"}], ",", 
       RowBox[{"CellMargins", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"92", ",", "36"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"6", ",", "12"}], "}"}]}], "}"}]}], ",", " ", 
       RowBox[{"AllowGroupClose", "\[Rule]", "False"}], ",", 
       RowBox[{"AllowReverseGroupClose", "\[Rule]", "False"}]}], "]"}], ",", 
     RowBox[{"Cell", "[", 
      RowBox[{
       RowBox[{"StyleData", "[", "\"\<Message\>\"", "]"}], ",", 
       RowBox[{"ShowCellBracket", "\[Rule]", "True"}], ",", 
       RowBox[{"CellMargins", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"130", ",", "10"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"5", ",", "7"}], "}"}]}], "}"}]}], ",", " ", 
       RowBox[{"AllowGroupClose", "\[Rule]", "False"}], ",", 
       RowBox[{"AllowReverseGroupClose", "\[Rule]", "False"}]}], "]"}], ",", 
     RowBox[{"Cell", "[", 
      RowBox[{
       RowBox[{"StyleData", "[", "\"\<MoreAbout\>\"", "]"}], ",", 
       RowBox[{"ShowCellBracket", "\[Rule]", "False"}], ",", 
       RowBox[{"CellMargins", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"100", ",", "12"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"2", ",", "2"}], "}"}]}], "}"}]}], ",", " ", 
       RowBox[{"AllowGroupClose", "\[Rule]", "False"}], ",", 
       RowBox[{"AllowReverseGroupClose", "\[Rule]", "False"}]}], "]"}], ",", 
     RowBox[{"Cell", "[", 
      RowBox[{
       RowBox[{"StyleData", "[", "\"\<MoreAboutSection\>\"", "]"}], ",", 
       RowBox[{"ShowCellBracket", "\[Rule]", "False"}], ",", 
       RowBox[{"CellFrameMargins", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"0", ",", "0"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", "10"}], "}"}]}], "}"}]}], ",", " ", 
       RowBox[{"CellMargins", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"74", ",", "24"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"12", ",", "33"}], "}"}]}], "}"}]}], ",", " ", 
       RowBox[{"AllowGroupClose", "\[Rule]", "True"}], ",", 
       RowBox[{"AllowReverseGroupClose", "\[Rule]", "True"}]}], "]"}], ",", 
     RowBox[{"Cell", "[", 
      RowBox[{
       RowBox[{"StyleData", "[", "\"\<MSG\>\"", "]"}], ",", 
       RowBox[{"ShowCellBracket", "\[Rule]", "True"}], ",", 
       RowBox[{"CellMargins", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"130", ",", "10"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"5", ",", "7"}], "}"}]}], "}"}]}], ",", " ", 
       RowBox[{"AllowGroupClose", "\[Rule]", "False"}], ",", 
       RowBox[{"AllowReverseGroupClose", "\[Rule]", "False"}]}], "]"}], ",", 
     RowBox[{"Cell", "[", 
      RowBox[{
       RowBox[{"StyleData", "[", "\"\<NotebookImage\>\"", "]"}], ",", 
       RowBox[{"ShowCellBracket", "\[Rule]", "False"}], ",", 
       RowBox[{"CellMargins", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"88", ",", "12"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"8", ",", "2"}], "}"}]}], "}"}]}], ",", " ", 
       RowBox[{"AllowGroupClose", "\[Rule]", "False"}], ",", 
       RowBox[{"AllowReverseGroupClose", "\[Rule]", "False"}]}], "]"}], ",", 
     RowBox[{"Cell", "[", 
      RowBox[{
       RowBox[{"StyleData", "[", "\"\<NotebookInterfaceSection\>\"", "]"}], 
       ",", 
       RowBox[{"ShowCellBracket", "\[Rule]", "False"}], ",", 
       RowBox[{"CellMargins", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"74", ",", "24"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"6", ",", "18"}], "}"}]}], "}"}]}], ",", " ", 
       RowBox[{"AllowGroupClose", "\[Rule]", "True"}], ",", 
       RowBox[{"AllowReverseGroupClose", "\[Rule]", "True"}]}], "]"}], ",", 
     RowBox[{"Cell", "[", 
      RowBox[{
       RowBox[{"StyleData", "[", "\"\<Notes\>\"", "]"}], ",", 
       RowBox[{"ShowCellBracket", "\[Rule]", "False"}], ",", 
       RowBox[{"CellMargins", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"100", ",", "24"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"9", ",", "7"}], "}"}]}], "}"}]}], ",", " ", 
       RowBox[{"AllowGroupClose", "\[Rule]", "False"}], ",", 
       RowBox[{"AllowReverseGroupClose", "\[Rule]", "False"}]}], "]"}], ",", 
     RowBox[{"Cell", "[", 
      RowBox[{
       RowBox[{"StyleData", "[", "\"\<NotesSection\>\"", "]"}], ",", 
       RowBox[{"ShowCellBracket", "\[Rule]", "False"}], ",", 
       RowBox[{"CellMargins", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"74", ",", "24"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"6", ",", "6"}], "}"}]}], "}"}]}], ",", " ", 
       RowBox[{"AllowGroupClose", "\[Rule]", "True"}], ",", 
       RowBox[{"AllowReverseGroupClose", "\[Rule]", "True"}]}], "]"}], ",", 
     RowBox[{"Cell", "[", 
      RowBox[{
       RowBox[{"StyleData", "[", "\"\<NumberedEquation\>\"", "]"}], ",", 
       RowBox[{"ShowCellBracket", "\[Rule]", "False"}], ",", 
       RowBox[{"CellMargins", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"112", ",", "39"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"8", ",", "12"}], "}"}]}], "}"}]}], ",", " ", 
       RowBox[{"AllowGroupClose", "\[Rule]", "False"}], ",", 
       RowBox[{"AllowReverseGroupClose", "\[Rule]", "False"}]}], "]"}], ",", 
     RowBox[{"Cell", "[", 
      RowBox[{
       RowBox[{"StyleData", "[", "\"\<ObjectName\>\"", "]"}], ",", 
       RowBox[{"ShowCellBracket", "\[Rule]", "False"}], ",", 
       RowBox[{"CellMargins", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"74", ",", "22"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"16", ",", "35"}], "}"}]}], "}"}]}], ",", " ", 
       RowBox[{"AllowGroupClose", "\[Rule]", "False"}], ",", 
       RowBox[{"AllowReverseGroupClose", "\[Rule]", "False"}]}], "]"}], ",", 
     RowBox[{"Cell", "[", 
      RowBox[{
       RowBox[{"StyleData", "[", "\"\<ObjectNameAlt\>\"", "]"}], ",", 
       RowBox[{"ShowCellBracket", "\[Rule]", "False"}], ",", 
       RowBox[{"CellMargins", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"74", ",", "22"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"6", ",", "16"}], "}"}]}], "}"}]}], ",", " ", 
       RowBox[{"AllowGroupClose", "\[Rule]", "False"}], ",", 
       RowBox[{"AllowReverseGroupClose", "\[Rule]", "False"}]}], "]"}], ",", 
     RowBox[{"Cell", "[", 
      RowBox[{
       RowBox[{"StyleData", "[", "\"\<ObjectNameGrid\>\"", "]"}], ",", 
       RowBox[{"ShowCellBracket", "\[Rule]", "False"}], ",", 
       RowBox[{"CellMargins", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"74", ",", "22"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"6", ",", "16"}], "}"}]}], "}"}]}], ",", " ", 
       RowBox[{"AllowGroupClose", "\[Rule]", "False"}], ",", 
       RowBox[{"AllowReverseGroupClose", "\[Rule]", "False"}]}], "]"}], ",", 
     RowBox[{"Cell", "[", 
      RowBox[{
       RowBox[{"StyleData", "[", "\"\<ObsolescenceNote\>\"", "]"}], ",", 
       RowBox[{"ShowCellBracket", "\[Rule]", "False"}], ",", 
       RowBox[{"CellMargins", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"74", ",", "22"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"12", ",", "6"}], "}"}]}], "}"}]}], ",", " ", 
       RowBox[{"AllowGroupClose", "\[Rule]", "False"}], ",", 
       RowBox[{"AllowReverseGroupClose", "\[Rule]", "False"}]}], "]"}], ",", 
     RowBox[{"Cell", "[", 
      RowBox[{
       RowBox[{"StyleData", "[", "\"\<OptionsSection\>\"", "]"}], ",", 
       RowBox[{"ShowCellBracket", "\[Rule]", "False"}], ",", 
       RowBox[{"CellMargins", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"74", ",", "24"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"6", ",", "18"}], "}"}]}], "}"}]}], ",", " ", 
       RowBox[{"AllowGroupClose", "\[Rule]", "True"}], ",", 
       RowBox[{"AllowReverseGroupClose", "\[Rule]", "True"}]}], "]"}], ",", 
     RowBox[{"Cell", "[", 
      RowBox[{
       RowBox[{"StyleData", "[", "\"\<Output\>\"", "]"}], ",", 
       RowBox[{"ShowCellBracket", "\[Rule]", "True"}], ",", 
       RowBox[{"CellMargins", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"130", ",", "10"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"16", ",", "5"}], "}"}]}], "}"}]}], ",", " ", 
       RowBox[{"AllowGroupClose", "\[Rule]", "True"}], ",", 
       RowBox[{"AllowReverseGroupClose", "\[Rule]", "True"}]}], "]"}], ",", 
     RowBox[{"Cell", "[", 
      RowBox[{
       RowBox[{"StyleData", "[", "\"\<Pade\>\"", "]"}], ",", 
       RowBox[{"ShowCellBracket", "\[Rule]", "False"}], ",", 
       RowBox[{"CellMargins", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"57", ",", "3"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"4", ",", "4"}], "}"}]}], "}"}]}], ",", " ", 
       RowBox[{"AllowGroupClose", "\[Rule]", "False"}], ",", 
       RowBox[{"AllowReverseGroupClose", "\[Rule]", "False"}]}], "]"}], ",", 
     RowBox[{"Cell", "[", 
      RowBox[{
       RowBox[{"StyleData", "[", "\"\<Picture\>\"", "]"}], ",", 
       RowBox[{"ShowCellBracket", "\[Rule]", "False"}], ",", 
       RowBox[{"CellMargins", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"92", ",", "3"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"4", ",", "4"}], "}"}]}], "}"}]}], ",", " ", 
       RowBox[{"AllowGroupClose", "\[Rule]", "False"}], ",", 
       RowBox[{"AllowReverseGroupClose", "\[Rule]", "False"}]}], "]"}], ",", 
     RowBox[{"Cell", "[", 
      RowBox[{
       RowBox[{"StyleData", "[", "\"\<PrecedenceTable\>\"", "]"}], ",", 
       RowBox[{"ShowCellBracket", "\[Rule]", "False"}], ",", 
       RowBox[{"CellMargins", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"77", ",", "27"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", "8"}], "}"}]}], "}"}]}], ",", " ", 
       RowBox[{"AllowGroupClose", "\[Rule]", "False"}], ",", 
       RowBox[{"AllowReverseGroupClose", "\[Rule]", "False"}]}], "]"}], ",", 
     RowBox[{"Cell", "[", 
      RowBox[{
       RowBox[{"StyleData", "[", "\"\<PrimaryExamplesSection\>\"", "]"}], ",", 
       RowBox[{"ShowCellBracket", "\[Rule]", "False"}], ",", 
       RowBox[{"CellMargins", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"74", ",", "24"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", "18"}], "}"}]}], "}"}]}], ",", " ", 
       RowBox[{"AllowGroupClose", "\[Rule]", "True"}], ",", 
       RowBox[{"AllowReverseGroupClose", "\[Rule]", "True"}]}], "]"}], ",", 
     RowBox[{"Cell", "[", 
      RowBox[{
       RowBox[{"StyleData", "[", "\"\<Print\>\"", "]"}], ",", 
       RowBox[{"ShowCellBracket", "\[Rule]", "True"}], ",", 
       RowBox[{"CellMargins", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"130", ",", "10"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"5", ",", "7"}], "}"}]}], "}"}]}], ",", " ", 
       RowBox[{"AllowGroupClose", "\[Rule]", "False"}], ",", 
       RowBox[{"AllowReverseGroupClose", "\[Rule]", "False"}]}], "]"}], ",", 
     RowBox[{"Cell", "[", 
      RowBox[{
       RowBox[{"StyleData", "[", "\"\<PrintTemporary\>\"", "]"}], ",", 
       RowBox[{"ShowCellBracket", "\[Rule]", "False"}], ",", 
       RowBox[{"CellMargins", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"110", ",", "3"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"4", ",", "4"}], "}"}]}], "}"}]}], ",", " ", 
       RowBox[{"AllowGroupClose", "\[Rule]", "False"}], ",", 
       RowBox[{"AllowReverseGroupClose", "\[Rule]", "False"}]}], "]"}], ",", 
     RowBox[{"Cell", "[", 
      RowBox[{
       RowBox[{"StyleData", "[", "\"\<PrintUsage\>\"", "]"}], ",", 
       RowBox[{"ShowCellBracket", "\[Rule]", "True"}], ",", 
       RowBox[{"CellMargins", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"130", ",", "10"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"5", ",", "7"}], "}"}]}], "}"}]}], ",", " ", 
       RowBox[{"AllowGroupClose", "\[Rule]", "False"}], ",", 
       RowBox[{"AllowReverseGroupClose", "\[Rule]", "False"}]}], "]"}], ",", 
     RowBox[{"Cell", "[", 
      RowBox[{
       RowBox[{"StyleData", "[", "\"\<Program\>\"", "]"}], ",", 
       RowBox[{"ShowCellBracket", "\[Rule]", "False"}], ",", 
       RowBox[{"CellMargins", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"80", ",", "27"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"5", ",", "7"}], "}"}]}], "}"}]}], ",", " ", 
       RowBox[{"AllowGroupClose", "\[Rule]", "False"}], ",", 
       RowBox[{"AllowReverseGroupClose", "\[Rule]", "False"}]}], "]"}], ",", 
     RowBox[{"Cell", "[", 
      RowBox[{
       RowBox[{"StyleData", "[", "\"\<RealRootIntervals\>\"", "]"}], ",", 
       RowBox[{"ShowCellBracket", "\[Rule]", "False"}], ",", 
       RowBox[{"CellMargins", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"57", ",", "3"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"4", ",", "4"}], "}"}]}], "}"}]}], ",", " ", 
       RowBox[{"AllowGroupClose", "\[Rule]", "False"}], ",", 
       RowBox[{"AllowReverseGroupClose", "\[Rule]", "False"}]}], "]"}], ",", 
     RowBox[{"Cell", "[", 
      RowBox[{
       RowBox[{"StyleData", "[", "\"\<Reference\>\"", "]"}], ",", 
       RowBox[{"ShowCellBracket", "\[Rule]", "False"}], ",", 
       RowBox[{"CellMargins", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"92", ",", "36"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"8", ",", "8"}], "}"}]}], "}"}]}], ",", " ", 
       RowBox[{"AllowGroupClose", "\[Rule]", "False"}], ",", 
       RowBox[{"AllowReverseGroupClose", "\[Rule]", "False"}]}], "]"}], ",", 
     RowBox[{"Cell", "[", 
      RowBox[{
       RowBox[{"StyleData", "[", "\"\<RelatedDemonstrations\>\"", "]"}], ",", 
       
       RowBox[{"ShowCellBracket", "\[Rule]", "False"}], ",", 
       RowBox[{"CellMargins", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"100", ",", "12"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"2", ",", "2"}], "}"}]}], "}"}]}], ",", " ", 
       RowBox[{"AllowGroupClose", "\[Rule]", "False"}], ",", 
       RowBox[{"AllowReverseGroupClose", "\[Rule]", "False"}]}], "]"}], ",", 
     RowBox[{"Cell", "[", 
      RowBox[{
       RowBox[{
       "StyleData", "[", "\"\<RelatedDemonstrationsSection\>\"", "]"}], ",", 
       RowBox[{"ShowCellBracket", "\[Rule]", "False"}], ",", 
       RowBox[{"CellFrameMargins", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"0", ",", "0"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", "10"}], "}"}]}], "}"}]}], ",", " ", 
       RowBox[{"CellMargins", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"74", ",", "24"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"12", ",", "33"}], "}"}]}], "}"}]}], ",", " ", 
       RowBox[{"AllowGroupClose", "\[Rule]", "True"}], ",", 
       RowBox[{"AllowReverseGroupClose", "\[Rule]", "True"}]}], "]"}], ",", 
     RowBox[{"Cell", "[", 
      RowBox[{
       RowBox[{"StyleData", "[", "\"\<RelatedLinks\>\"", "]"}], ",", 
       RowBox[{"ShowCellBracket", "\[Rule]", "False"}], ",", 
       RowBox[{"CellMargins", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"100", ",", "12"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"2", ",", "2"}], "}"}]}], "}"}]}], ",", " ", 
       RowBox[{"AllowGroupClose", "\[Rule]", "False"}], ",", 
       RowBox[{"AllowReverseGroupClose", "\[Rule]", "False"}]}], "]"}], ",", 
     RowBox[{"Cell", "[", 
      RowBox[{
       RowBox[{"StyleData", "[", "\"\<RelatedLinksSection\>\"", "]"}], ",", 
       RowBox[{"ShowCellBracket", "\[Rule]", "False"}], ",", 
       RowBox[{"CellFrameMargins", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"0", ",", "0"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", "10"}], "}"}]}], "}"}]}], ",", 
       RowBox[{"CellMargins", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"74", ",", "24"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"12", ",", "33"}], "}"}]}], "}"}]}], ",", " ", 
       RowBox[{"AllowGroupClose", "\[Rule]", "True"}], ",", 
       RowBox[{"AllowReverseGroupClose", "\[Rule]", "True"}]}], "]"}], ",", 
     RowBox[{"Cell", "[", 
      RowBox[{
       RowBox[{"StyleData", "[", "\"\<RelatedTutorials\>\"", "]"}], ",", 
       RowBox[{"ShowCellBracket", "\[Rule]", "False"}], ",", 
       RowBox[{"CellMargins", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"106", ",", "12"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"2", ",", "2"}], "}"}]}], "}"}]}], ",", " ", 
       RowBox[{"AllowGroupClose", "\[Rule]", "False"}], ",", 
       RowBox[{"AllowReverseGroupClose", "\[Rule]", "False"}]}], "]"}], ",", 
     RowBox[{"Cell", "[", 
      RowBox[{
       RowBox[{"StyleData", "[", "\"\<RelatedTutorialsSection\>\"", "]"}], 
       ",", 
       RowBox[{"ShowCellBracket", "\[Rule]", "False"}], ",", 
       RowBox[{"CellGroupingRules", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"\"\<SectionGrouping\>\"", ",", "30"}], "}"}]}], ",", 
       RowBox[{"CellFrameMargins", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"0", ",", "0"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", "10"}], "}"}]}], "}"}]}], ",", " ", 
       RowBox[{"CellMargins", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"74", ",", "24"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"12", ",", "33"}], "}"}]}], "}"}]}], ",", " ", 
       RowBox[{"AllowGroupClose", "\[Rule]", "True"}], ",", 
       RowBox[{"AllowReverseGroupClose", "\[Rule]", "True"}]}], "]"}], ",", 
     RowBox[{"Cell", "[", 
      RowBox[{
       RowBox[{"StyleData", "[", "\"\<RussleRaoDissimilarity\>\"", "]"}], ",", 
       RowBox[{"ShowCellBracket", "\[Rule]", "False"}], ",", 
       RowBox[{"CellMargins", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"57", ",", "3"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"4", ",", "4"}], "}"}]}], "}"}]}], ",", " ", 
       RowBox[{"AllowGroupClose", "\[Rule]", "False"}], ",", 
       RowBox[{"AllowReverseGroupClose", "\[Rule]", "False"}]}], "]"}], ",", 
     RowBox[{"Cell", "[", 
      RowBox[{
       RowBox[{"StyleData", "[", "\"\<ScreencastPointerText\>\"", "]"}], ",", 
       
       RowBox[{"ShowCellBracket", "\[Rule]", "False"}], ",", 
       RowBox[{"CellMargins", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"86", ",", "27"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"4", ",", "20"}], "}"}]}], "}"}]}], ",", " ", 
       RowBox[{"AllowGroupClose", "\[Rule]", "False"}], ",", 
       RowBox[{"AllowReverseGroupClose", "\[Rule]", "False"}]}], "]"}], ",", 
     RowBox[{"Cell", "[", 
      RowBox[{
       RowBox[{"StyleData", "[", "\"\<Section\>\"", "]"}], ",", 
       RowBox[{"ShowCellBracket", "\[Rule]", "False"}], ",", 
       RowBox[{"CellMargins", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"92", ",", "27"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"9", ",", "24"}], "}"}]}], "}"}]}], ",", " ", 
       RowBox[{"AllowGroupClose", "\[Rule]", "False"}], ",", 
       RowBox[{"AllowReverseGroupClose", "\[Rule]", "False"}]}], "]"}], ",", 
     RowBox[{"Cell", "[", 
      RowBox[{
       RowBox[{"StyleData", "[", "\"\<SectionDescription\>\"", "]"}], ",", 
       RowBox[{"ShowCellBracket", "\[Rule]", "False"}], ",", 
       RowBox[{"CellMargins", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"57", ",", "3"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"4", ",", "4"}], "}"}]}], "}"}]}], ",", " ", 
       RowBox[{"AllowGroupClose", "\[Rule]", "False"}], ",", 
       RowBox[{"AllowReverseGroupClose", "\[Rule]", "False"}]}], "]"}], ",", 
     RowBox[{"Cell", "[", 
      RowBox[{
       RowBox[{"StyleData", "[", "\"\<SeeAlso\>\"", "]"}], ",", 
       RowBox[{"ShowCellBracket", "\[Rule]", "False"}], ",", 
       RowBox[{"CellMargins", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"100", ",", "24"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"2", ",", "2"}], "}"}]}], "}"}]}], ",", " ", 
       RowBox[{"AllowGroupClose", "\[Rule]", "False"}], ",", 
       RowBox[{"AllowReverseGroupClose", "\[Rule]", "False"}]}], "]"}], ",", 
     RowBox[{"Cell", "[", 
      RowBox[{
       RowBox[{"StyleData", "[", "\"\<SeeAlsoSection\>\"", "]"}], ",", 
       RowBox[{"ShowCellBracket", "\[Rule]", "False"}], ",", 
       RowBox[{"CellFrameMargins", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"0", ",", "0"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", "10"}], "}"}]}], "}"}]}], ",", " ", 
       RowBox[{"CellMargins", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"74", ",", "24"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"12", ",", "33"}], "}"}]}], "}"}]}], ",", " ", 
       RowBox[{"AllowGroupClose", "\[Rule]", "True"}], ",", 
       RowBox[{"AllowReverseGroupClose", "\[Rule]", "True"}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"Cell", "[", 
      RowBox[{
       RowBox[{"StyleData", "[", "\"\<SessionLabel\>\"", "]"}], ",", 
       RowBox[{"ShowCellBracket", "\[Rule]", "False"}], ",", 
       RowBox[{"CellMargins", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"77", ",", "4"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", "18"}], "}"}]}], "}"}]}], ",", " ", 
       RowBox[{"AllowGroupClose", "\[Rule]", "False"}], ",", 
       RowBox[{"AllowReverseGroupClose", "\[Rule]", "False"}]}], "]"}], ",", 
     RowBox[{"Cell", "[", 
      RowBox[{
       RowBox[{"StyleData", "[", "\"\<Subsection\>\"", "]"}], ",", 
       RowBox[{"ShowCellBracket", "\[Rule]", "False"}], ",", 
       RowBox[{"CellMargins", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"92", ",", "27"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"9", ",", "24"}], "}"}]}], "}"}]}], ",", " ", 
       RowBox[{"AllowGroupClose", "\[Rule]", "False"}], ",", 
       RowBox[{"AllowReverseGroupClose", "\[Rule]", "False"}]}], "]"}], ",", 
     RowBox[{"Cell", "[", 
      RowBox[{
       RowBox[{"StyleData", "[", "\"\<Subsubsection\>\"", "]"}], ",", 
       RowBox[{"ShowCellBracket", "\[Rule]", "False"}], ",", 
       RowBox[{"CellMargins", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"92", ",", "27"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", "16"}], "}"}]}], "}"}]}], ",", " ", 
       RowBox[{"AllowGroupClose", "\[Rule]", "False"}], ",", 
       RowBox[{"AllowReverseGroupClose", "\[Rule]", "False"}]}], "]"}], ",", 
     RowBox[{"Cell", "[", 
      RowBox[{
       RowBox[{"StyleData", "[", "\"\<Subsubsubsection\>\"", "]"}], ",", 
       RowBox[{"ShowCellBracket", "\[Rule]", "False"}], ",", 
       RowBox[{"CellMargins", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"92", ",", "27"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"6", ",", "14"}], "}"}]}], "}"}]}], ",", " ", 
       RowBox[{"AllowGroupClose", "\[Rule]", "False"}], ",", 
       RowBox[{"AllowReverseGroupClose", "\[Rule]", "False"}]}], "]"}], ",", 
     RowBox[{"Cell", "[", 
      RowBox[{
       RowBox[{"StyleData", "[", "\"\<SupDistance\>\"", "]"}], ",", 
       RowBox[{"ShowCellBracket", "\[Rule]", "False"}], ",", 
       RowBox[{"CellMargins", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"57", ",", "3"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"4", ",", "4"}], "}"}]}], "}"}]}], ",", " ", 
       RowBox[{"AllowGroupClose", "\[Rule]", "False"}], ",", 
       RowBox[{"AllowReverseGroupClose", "\[Rule]", "False"}]}], "]"}], ",", 
     RowBox[{"Cell", "[", 
      RowBox[{
       RowBox[{"StyleData", "[", "\"\<Table\>\"", "]"}], ",", 
       RowBox[{"ShowCellBracket", "\[Rule]", "False"}], ",", 
       RowBox[{"CellMargins", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"57", ",", "3"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"4", ",", "4"}], "}"}]}], "}"}]}], ",", " ", 
       RowBox[{"AllowGroupClose", "\[Rule]", "False"}], ",", 
       RowBox[{"AllowReverseGroupClose", "\[Rule]", "False"}]}], "]"}], ",", 
     RowBox[{"Cell", "[", 
      RowBox[{
       RowBox[{"StyleData", "[", "\"\<Text\>\"", "]"}], ",", 
       RowBox[{"ShowCellBracket", "\[Rule]", "False"}], ",", 
       RowBox[{"CellMargins", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"92", ",", "36"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"8", ",", "8"}], "}"}]}], "}"}]}], ",", " ", 
       RowBox[{"AllowGroupClose", "\[Rule]", "False"}], ",", 
       RowBox[{"AllowReverseGroupClose", "\[Rule]", "False"}]}], "]"}], ",", 
     RowBox[{"Cell", "[", 
      RowBox[{
       RowBox[{"StyleData", "[", "\"\<TextEmphasisNote\>\"", "]"}], ",", 
       RowBox[{"ShowCellBracket", "\[Rule]", "False"}], ",", 
       RowBox[{"CellMargins", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"84", ",", "28"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"8", ",", "8"}], "}"}]}], "}"}]}], ",", " ", 
       RowBox[{"AllowGroupClose", "\[Rule]", "False"}], ",", 
       RowBox[{"AllowReverseGroupClose", "\[Rule]", "False"}]}], "]"}], ",", 
     RowBox[{"Cell", "[", 
      RowBox[{
       RowBox[{"StyleData", "[", "\"\<Title\>\"", "]"}], ",", 
       RowBox[{"ShowCellBracket", "\[Rule]", "False"}], ",", 
       RowBox[{"CellMargins", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"74", ",", "27"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"10", ",", "16"}], "}"}]}], "}"}]}], ",", " ", 
       RowBox[{"AllowGroupClose", "\[Rule]", "False"}], ",", 
       RowBox[{"AllowReverseGroupClose", "\[Rule]", "False"}]}], "]"}], ",", 
     RowBox[{"Cell", "[", 
      RowBox[{
       RowBox[{"StyleData", "[", "\"\<TOCChapter\>\"", "]"}], ",", 
       RowBox[{"ShowCellBracket", "\[Rule]", "False"}], ",", 
       RowBox[{"CellMargins", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"92", ",", "27"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"4", ",", "24"}], "}"}]}], "}"}]}], ",", " ", 
       RowBox[{"AllowGroupClose", "\[Rule]", "False"}], ",", 
       RowBox[{"AllowReverseGroupClose", "\[Rule]", "False"}]}], "]"}], ",", 
     RowBox[{"Cell", "[", 
      RowBox[{
       RowBox[{"StyleData", "[", "\"\<TOCDocumentTitle\>\"", "]"}], ",", 
       RowBox[{"ShowCellBracket", "\[Rule]", "False"}], ",", 
       RowBox[{"CellMargins", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"92", ",", "27"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"10", ",", "16"}], "}"}]}], "}"}]}], ",", " ", 
       RowBox[{"AllowGroupClose", "\[Rule]", "False"}], ",", 
       RowBox[{"AllowReverseGroupClose", "\[Rule]", "False"}]}], "]"}], ",", 
     RowBox[{"Cell", "[", 
      RowBox[{
       RowBox[{"StyleData", "[", "\"\<TOCSection\>\"", "]"}], ",", 
       RowBox[{"ShowCellBracket", "\[Rule]", "False"}], ",", 
       RowBox[{"CellMargins", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"110", ",", "27"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"4", ",", "8"}], "}"}]}], "}"}]}], ",", " ", 
       RowBox[{"AllowGroupClose", "\[Rule]", "True"}], ",", 
       RowBox[{"AllowReverseGroupClose", "\[Rule]", "True"}]}], "]"}], ",", 
     RowBox[{"Cell", "[", 
      RowBox[{
       RowBox[{"StyleData", "[", "\"\<TOCSubsection\>\"", "]"}], ",", 
       RowBox[{"ShowCellBracket", "\[Rule]", "False"}], ",", 
       RowBox[{"CellMargins", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"128", ",", "27"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"2", ",", "2"}], "}"}]}], "}"}]}], ",", " ", 
       RowBox[{"AllowGroupClose", "\[Rule]", "True"}], ",", 
       RowBox[{"AllowReverseGroupClose", "\[Rule]", "True"}]}], "]"}], ",", 
     RowBox[{"Cell", "[", 
      RowBox[{
       RowBox[{"StyleData", "[", "\"\<TOCSubsubsection\>\"", "]"}], ",", 
       RowBox[{"ShowCellBracket", "\[Rule]", "False"}], ",", 
       RowBox[{"CellMargins", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"146", ",", "27"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"2", ",", "3"}], "}"}]}], "}"}]}], ",", " ", 
       RowBox[{"AllowGroupClose", "\[Rule]", "True"}], ",", 
       RowBox[{"AllowReverseGroupClose", "\[Rule]", "True"}]}], "]"}], ",", 
     RowBox[{"Cell", "[", 
      RowBox[{
       RowBox[{"StyleData", "[", "\"\<TOCSubsubsubsection\>\"", "]"}], ",", 
       RowBox[{"ShowCellBracket", "\[Rule]", "False"}], ",", 
       RowBox[{"CellMargins", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"164", ",", "27"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"2", ",", "3"}], "}"}]}], "}"}]}], ",", " ", 
       RowBox[{"AllowGroupClose", "\[Rule]", "True"}], ",", 
       RowBox[{"AllowReverseGroupClose", "\[Rule]", "True"}]}], "]"}], ",", 
     RowBox[{"Cell", "[", 
      RowBox[{
       RowBox[{"StyleData", "[", "\"\<TutorialAbstract\>\"", "]"}], ",", 
       RowBox[{"ShowCellBracket", "\[Rule]", "False"}], ",", 
       RowBox[{"CellMargins", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"77", ",", "27"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"9", ",", "9"}], "}"}]}], "}"}]}], ",", " ", 
       RowBox[{"AllowGroupClose", "\[Rule]", "False"}], ",", 
       RowBox[{"AllowReverseGroupClose", "\[Rule]", "False"}]}], "]"}], ",", 
     RowBox[{"Cell", "[", 
      RowBox[{
       RowBox[{"StyleData", "[", "\"\<TutorialCollection\>\"", "]"}], ",", 
       RowBox[{"ShowCellBracket", "\[Rule]", "False"}], ",", 
       RowBox[{"CellMargins", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"100", ",", "12"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"2", ",", "2"}], "}"}]}], "}"}]}], ",", " ", 
       RowBox[{"AllowGroupClose", "\[Rule]", "False"}], ",", 
       RowBox[{"AllowReverseGroupClose", "\[Rule]", "False"}]}], "]"}], ",", 
     RowBox[{"Cell", "[", 
      RowBox[{
       RowBox[{"StyleData", "[", "\"\<TutorialCollectionSection\>\"", "]"}], 
       ",", 
       RowBox[{"ShowCellBracket", "\[Rule]", "False"}], ",", 
       RowBox[{"CellFrameMargins", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"0", ",", "0"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", "10"}], "}"}]}], "}"}]}], ",", " ", 
       RowBox[{"CellMargins", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"74", ",", "24"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"12", ",", "33"}], "}"}]}], "}"}]}], ",", " ", 
       RowBox[{"AllowGroupClose", "\[Rule]", "False"}], ",", 
       RowBox[{"AllowReverseGroupClose", "\[Rule]", "False"}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"Cell", "[", 
      RowBox[{
       RowBox[{"StyleData", "[", "\"\<TutorialLevel 1\>\"", "]"}], ",", 
       RowBox[{"ShowCellBracket", "\[Rule]", "False"}], ",", 
       RowBox[{"CellMargins", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"57", ",", "3"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"4", ",", "4"}], "}"}]}], "}"}]}], ",", " ", 
       RowBox[{"AllowGroupClose", "\[Rule]", "False"}], ",", 
       RowBox[{"AllowReverseGroupClose", "\[Rule]", "False"}]}], "]"}], ",", 
     RowBox[{"Cell", "[", 
      RowBox[{
       RowBox[{"StyleData", "[", "\"\<TutorialMoreAbout\>\"", "]"}], ",", 
       RowBox[{"ShowCellBracket", "\[Rule]", "False"}], ",", 
       RowBox[{"CellMargins", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"106", ",", "12"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"2", ",", "2"}], "}"}]}], "}"}]}], ",", " ", 
       RowBox[{"AllowGroupClose", "\[Rule]", "False"}], ",", 
       RowBox[{"AllowReverseGroupClose", "\[Rule]", "False"}]}], "]"}], ",", 
     RowBox[{"Cell", "[", 
      RowBox[{
       RowBox[{"StyleData", "[", "\"\<TutorialMoreAboutSection\>\"", "]"}], 
       ",", 
       RowBox[{"ShowCellBracket", "\[Rule]", "False"}], ",", 
       RowBox[{"CellGroupingRules", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"\"\<SectionGrouping\>\"", ",", "30"}], "}"}]}], ",", 
       RowBox[{"CellFrameMargins", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"0", ",", "0"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", "10"}], "}"}]}], "}"}]}], ",", 
       RowBox[{"CellMargins", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"74", ",", "24"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"12", ",", "33"}], "}"}]}], "}"}]}], ",", " ", 
       RowBox[{"AllowGroupClose", "\[Rule]", "False"}], ",", 
       RowBox[{"AllowReverseGroupClose", "\[Rule]", "False"}]}], "]"}], ",", 
     RowBox[{"Cell", "[", 
      RowBox[{
       RowBox[{"StyleData", "[", "\"\<TutorialRelatedLinks\>\"", "]"}], ",", 
       RowBox[{"ShowCellBracket", "\[Rule]", "False"}], ",", 
       RowBox[{"CellMargins", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"106", ",", "12"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"2", ",", "2"}], "}"}]}], "}"}]}], ",", " ", 
       RowBox[{"AllowGroupClose", "\[Rule]", "False"}], ",", 
       RowBox[{"AllowReverseGroupClose", "\[Rule]", "False"}]}], "]"}], ",", 
     RowBox[{"Cell", "[", 
      RowBox[{
       RowBox[{"StyleData", "[", "\"\<TutorialRelatedLinksSection\>\"", "]"}],
        ",", 
       RowBox[{"ShowCellBracket", "\[Rule]", "False"}], ",", 
       RowBox[{"CellGroupingRules", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"\"\<SectionGrouping\>\"", ",", "30"}], "}"}]}], ",", 
       RowBox[{"CellFrameMargins", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"0", ",", "0"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", "10"}], "}"}]}], "}"}]}], ",", 
       RowBox[{"CellMargins", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"74", ",", "24"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"12", ",", "33"}], "}"}]}], "}"}]}], ",", " ", 
       RowBox[{"AllowGroupClose", "\[Rule]", "False"}], ",", 
       RowBox[{"AllowReverseGroupClose", "\[Rule]", "False"}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"Cell", "[", 
      RowBox[{
       RowBox[{"StyleData", "[", "\"\<Tutorials\>\"", "]"}], ",", 
       RowBox[{"ShowCellBracket", "\[Rule]", "False"}], ",", 
       RowBox[{"CellMargins", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"100", ",", "12"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"2", ",", "2"}], "}"}]}], "}"}]}], ",", " ", 
       RowBox[{"AllowGroupClose", "\[Rule]", "False"}], ",", 
       RowBox[{"AllowReverseGroupClose", "\[Rule]", "False"}]}], "]"}], ",", 
     RowBox[{"Cell", "[", 
      RowBox[{
       RowBox[{"StyleData", "[", "\"\<TutorialsSection\>\"", "]"}], ",", 
       RowBox[{"ShowCellBracket", "\[Rule]", "False"}], ",", 
       RowBox[{"CellFrameMargins", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"0", ",", "0"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", "10"}], "}"}]}], "}"}]}], ",", " ", 
       RowBox[{"CellMargins", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"74", ",", "24"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"12", ",", "33"}], "}"}]}], "}"}]}], ",", " ", 
       RowBox[{"AllowGroupClose", "\[Rule]", "True"}], ",", 
       RowBox[{"AllowReverseGroupClose", "\[Rule]", "True"}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"Cell", "[", 
      RowBox[{
       RowBox[{
       "StyleData", "[", "\"\<TutorialsTutorialCollectionSection\>\"", "]"}], 
       ",", 
       RowBox[{"ShowCellBracket", "\[Rule]", "False"}], ",", 
       RowBox[{"CellFrameMargins", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"0", ",", "0"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", "10"}], "}"}]}], "}"}]}], ",", 
       RowBox[{"CellMargins", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"74", ",", "24"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"12", ",", "33"}], "}"}]}], "}"}]}], ",", " ", 
       RowBox[{"AllowGroupClose", "\[Rule]", "False"}], ",", 
       RowBox[{"AllowReverseGroupClose", "\[Rule]", "False"}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"Cell", "[", 
      RowBox[{
       RowBox[{"StyleData", "[", "\"\<UpperCell\>\"", "]"}], ",", 
       RowBox[{"ShowCellBracket", "\[Rule]", "False"}], ",", 
       RowBox[{"CellMargins", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"57", ",", "3"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"4", ",", "4"}], "}"}]}], "}"}]}], ",", " ", 
       RowBox[{"AllowGroupClose", "\[Rule]", "False"}], ",", 
       RowBox[{"AllowReverseGroupClose", "\[Rule]", "False"}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"Cell", "[", 
      RowBox[{
       RowBox[{"StyleData", "[", "\"\<Usage\>\"", "]"}], ",", 
       RowBox[{"ShowCellBracket", "\[Rule]", "False"}], ",", 
       RowBox[{"CellMargins", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"74", ",", "22"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"12", ",", "6"}], "}"}]}], "}"}]}], ",", " ", 
       RowBox[{"AllowGroupClose", "\[Rule]", "False"}], ",", 
       RowBox[{"AllowReverseGroupClose", "\[Rule]", "False"}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"Cell", "[", 
      RowBox[{
       RowBox[{"StyleData", "[", "\"\<WeakDivider\>\"", "]"}], ",", 
       RowBox[{"ShowCellBracket", "\[Rule]", "False"}], ",", 
       RowBox[{"CellMargins", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"101", ",", "8"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"4", ",", "10"}], "}"}]}], "}"}]}], ",", " ", 
       RowBox[{"AllowGroupClose", "\[Rule]", "False"}], ",", 
       RowBox[{"AllowReverseGroupClose", "\[Rule]", "False"}]}], "]"}], ",", 
     RowBox[{"Cell", "[", 
      RowBox[{
       RowBox[{"StyleData", "[", "\"\<WolframAlphaLong\>\"", "]"}], ",", 
       RowBox[{"ShowCellBracket", "\[Rule]", "False"}], ",", 
       RowBox[{"CellMargins", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"116", ",", "10"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"5", ",", "10"}], "}"}]}], "}"}]}], ",", " ", 
       RowBox[{"AllowGroupClose", "\[Rule]", "False"}], ",", 
       RowBox[{"AllowReverseGroupClose", "\[Rule]", "False"}]}], "]"}], ",", 
     RowBox[{"Cell", "[", 
      RowBox[{
       RowBox[{"StyleData", "[", "\"\<WolframAlphaShortInput\>\"", "]"}], ",", 
       RowBox[{"ShowCellBracket", "\[Rule]", "False"}], ",", 
       RowBox[{"CellMargins", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"116", ",", "10"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"5", ",", "10"}], "}"}]}], "}"}]}], ",", " ", 
       RowBox[{"AllowGroupClose", "\[Rule]", "False"}], ",", 
       RowBox[{"AllowReverseGroupClose", "\[Rule]", "False"}]}], "]"}], ",", 
     RowBox[{"Cell", "[", 
      RowBox[{
       RowBox[{"StyleData", "[", "\"\< \[EmptyVerySmallSquare] \>\"", "]"}], 
       ",", 
       RowBox[{"ShowCellBracket", "\[Rule]", "False"}], ",", 
       RowBox[{"CellMargins", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"57", ",", "3"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"4", ",", "4"}], "}"}]}], "}"}]}], ",", " ", 
       RowBox[{"AllowGroupClose", "\[Rule]", "False"}], ",", 
       RowBox[{"AllowReverseGroupClose", "\[Rule]", "False"}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"Cell", "[", 
      RowBox[{
       RowBox[{"StyleData", "[", "\"\<ExampleLink\>\"", "]"}], ",", 
       RowBox[{"Background", "\[Rule]", "None"}], ",", " ", 
       RowBox[{"AllowGroupClose", "\[Rule]", "False"}], ",", 
       RowBox[{"AllowReverseGroupClose", "\[Rule]", "False"}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"Cell", "[", 
      RowBox[{
       RowBox[{"StyleData", "[", "\"\<DockedLinkTrail\>\"", "]"}], ",", 
       RowBox[{"Background", "\[Rule]", "None"}], ",", " ", 
       RowBox[{"AllowGroupClose", "\[Rule]", "False"}], ",", 
       RowBox[{"AllowReverseGroupClose", "\[Rule]", "False"}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"Cell", "[", 
      RowBox[{
       RowBox[{"StyleData", "[", "\"\<DockedLinkTrailSeparator\>\"", "]"}], 
       ",", 
       RowBox[{"FontColor", "\[Rule]", "Black"}], ",", 
       RowBox[{"Background", "\[Rule]", "None"}], ",", " ", 
       RowBox[{"AllowGroupClose", "\[Rule]", "False"}], ",", 
       RowBox[{"AllowReverseGroupClose", "\[Rule]", "False"}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"Cell", "[", 
      RowBox[{
       RowBox[{"StyleData", "[", "\"\<LinkTrail\>\"", "]"}], ",", 
       RowBox[{"CellFrame", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"0", ",", "0"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", "0"}], "}"}]}], "}"}]}], ",", 
       RowBox[{"Background", "\[Rule]", 
        RowBox[{"RGBColor", "[", 
         RowBox[{"1", ",", "1", ",", "1"}], "]"}]}], ",", " ", 
       RowBox[{"CellMargins", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"72", ",", "22"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"6", ",", "16"}], "}"}]}], "}"}]}], ",", " ", 
       RowBox[{"AllowGroupClose", "\[Rule]", "False"}], ",", 
       RowBox[{"AllowReverseGroupClose", "\[Rule]", "False"}], ",", " ", 
       RowBox[{"PageWidth", "\[Rule]", "1200"}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"Cell", "[", 
      RowBox[{
       RowBox[{"StyleData", "[", "\"\<PluginDockedCell\>\"", "]"}], ",", 
       RowBox[{"CellBracketOptions", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"\"\<Margins\>\"", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{"0", ",", "2"}], "}"}]}], "}"}]}], ",", 
       RowBox[{"AllowGroupClose", "\[Rule]", "False"}], ",", 
       RowBox[{"AllowReverseGroupClose", "\[Rule]", "False"}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"Cell", "[", 
      RowBox[{
       RowBox[{"StyleData", "[", "\"\<PacletNameCell\>\"", "]"}], ",", " ", 
       RowBox[{"FontColor", "\[Rule]", "Black"}], ",", " ", 
       RowBox[{"AllowGroupClose", "\[Rule]", "False"}], ",", 
       RowBox[{"AllowReverseGroupClose", "\[Rule]", "False"}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"Cell", "[", 
      RowBox[{
       RowBox[{"StyleData", "[", "\"\<HiddenExampleDelimiter\>\"", "]"}], ",", 
       RowBox[{"Editable", "\[Rule]", "False"}], ",", 
       RowBox[{"ShowCellBracket", "\[Rule]", "False"}], ",", 
       RowBox[{"CellMargins", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"130", ",", "24"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "6"}], ",", "0"}], "}"}]}], "}"}]}], ",", 
       RowBox[{"Evaluatable", "\[Rule]", "False"}], ",", 
       RowBox[{"CellGroupingRules", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"\"\<SectionGrouping\>\"", ",", "58"}], "}"}]}], ",", 
       RowBox[{"ShowCellLabel", "\[Rule]", "False"}], ",", 
       RowBox[{"CellLabelAutoDelete", "\[Rule]", "True"}], ",", 
       RowBox[{"TabFilling", "\[Rule]", "None"}], ",", 
       RowBox[{"TabSpacings", "\[Rule]", 
        RowBox[{"{", "68", "}"}]}], ",", 
       RowBox[{"StyleMenuListing", "\[Rule]", "None"}], ",", 
       RowBox[{"FontFamily", "\[Rule]", "\"\<Verdana\>\""}], ",", 
       RowBox[{"FontSize", "\[Rule]", "9"}], ",", 
       RowBox[{"FontWeight", "\[Rule]", "\"\<Plain\>\""}], ",", 
       RowBox[{"FontSlant", "\[Rule]", "\"\<Plain\>\""}], ",", " ", 
       RowBox[{"AllowGroupClose", "\[Rule]", "False"}], ",", 
       RowBox[{"AllowReverseGroupClose", "\[Rule]", "False"}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"Cell", "[", 
      RowBox[{
       RowBox[{"StyleData", "[", "\"\<AnchorBarGrid\>\"", "]"}], ",", 
       RowBox[{"ShowCellBracket", "\[Rule]", "False"}], ",", 
       RowBox[{"CellMargins", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"72", ",", "0"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", "0"}], "}"}]}], "}"}]}], ",", 
       RowBox[{"AllowGroupClose", "\[Rule]", "False"}], ",", 
       RowBox[{"AllowReverseGroupClose", "\[Rule]", "False"}]}], "]"}]}], 
    "\[IndentingNewLine]", "}"}]}], ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.511029497710202*^9, 3.5110295980834*^9}, {
   3.511087729028697*^9, 3.5110877304999733`*^9}, {3.511087806238812*^9, 
   3.511087826266522*^9}, {3.51110497500426*^9, 3.511104986838606*^9}, {
   3.5111130086371727`*^9, 3.511113010040497*^9}, {3.5111131696301527`*^9, 
   3.511113169943084*^9}, {3.511113296394415*^9, 3.511113296638556*^9}, 
   3.511113489096407*^9, {3.511113595235558*^9, 3.511113595686186*^9}, 
   3.5111136575235243`*^9, {3.51111388052693*^9, 3.511113918790309*^9}, {
   3.511113966306469*^9, 3.5111139665995893`*^9}, {3.511114109185501*^9, 
   3.511114110037648*^9}, {3.5111142144549522`*^9, 3.5111142153840113`*^9}, {
   3.511114297999052*^9, 3.511114318735579*^9}, {3.5111150491746473`*^9, 
   3.511115049474353*^9}, {3.511115108006433*^9, 3.511115117573566*^9}, {
   3.5111152174736147`*^9, 3.511115231420567*^9}, {3.511115342852466*^9, 
   3.511115352253511*^9}, {3.5111154470593767`*^9, 3.5111154567262363`*^9}, 
   3.5111170440856113`*^9, {3.511117090844558*^9, 3.511117130864563*^9}, {
   3.5111171654731627`*^9, 3.511117238948969*^9}, {3.511119104145837*^9, 
   3.511119117115431*^9}, {3.5111191496385508`*^9, 3.5111191507699842`*^9}, {
   3.5111192235682793`*^9, 3.511119229003757*^9}, {3.511119318847496*^9, 
   3.511119346852672*^9}, {3.511119406876466*^9, 3.511119414189396*^9}, {
   3.516454009496502*^9, 3.516454016932764*^9}, {3.516454061910972*^9, 
   3.516454410960857*^9}, 3.516454477984028*^9, 3.516454515086461*^9, {
   3.516454568432227*^9, 3.516454602312557*^9}, {3.5164556098693743`*^9, 
   3.516455612961525*^9}, {3.516455832130231*^9, 3.516455838524516*^9}, {
   3.5164573538158073`*^9, 3.516457621405793*^9}, {3.517745107272409*^9, 
   3.517745107596138*^9}, {3.517745160067621*^9, 3.5177451603527822`*^9}, {
   3.517922137280778*^9, 3.517922185321569*^9}, {3.5212205956405687`*^9, 
   3.52122059765617*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"styledefs", "[", "lang_", "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", "}"}], ",", 
     RowBox[{"Switch", "[", 
      RowBox[{"lang", ",", " ", "\"\<English\>\"", ",", " ", 
       RowBox[{"Notebook", "[", 
        RowBox[{"Join", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"Cell", "[", 
            RowBox[{"StyleData", "[", 
             RowBox[{"StyleDefinitions", "\[Rule]", 
              RowBox[{"FrontEnd`FileName", "[", 
               RowBox[{
                RowBox[{"{", "\"\<Wolfram\>\"", "}"}], ",", 
                "\"\<Reference.nb\>\""}], "]"}]}], "]"}], "]"}], "}"}], ",", 
          "styles"}], "]"}], "]"}], ",", " ", "\"\<Japanese\>\"", ",", " ", 
       RowBox[{"Notebook", "[", 
        RowBox[{"Join", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"Cell", "[", 
            RowBox[{"StyleData", "[", 
             RowBox[{"StyleDefinitions", "\[Rule]", 
              RowBox[{"FrontEnd`FileName", "[", 
               RowBox[{
                RowBox[{"{", "\"\<Wolfram\>\"", "}"}], ",", 
                "\"\<Reference-ja.nb\>\""}], "]"}]}], "]"}], "]"}], "}"}], 
          ",", "styles"}], "]"}], "]"}], ",", " ", 
       "\"\<ChineseSimplified\>\"", ",", 
       RowBox[{"Notebook", "[", 
        RowBox[{"Join", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"Cell", "[", 
            RowBox[{"StyleData", "[", 
             RowBox[{"StyleDefinitions", "\[Rule]", 
              RowBox[{"FrontEnd`FileName", "[", 
               RowBox[{
                RowBox[{"{", "\"\<Wolfram\>\"", "}"}], ",", 
                "\"\<Reference-ja.nb\>\""}], "]"}]}], "]"}], "]"}], "}"}], 
          ",", "styles"}], "]"}], "]"}], ",", " ", "_", ",", " ", 
       RowBox[{"Notebook", "[", 
        RowBox[{"Join", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"Cell", "[", 
            RowBox[{"StyleData", "[", 
             RowBox[{"StyleDefinitions", "\[Rule]", 
              RowBox[{"FrontEnd`FileName", "[", 
               RowBox[{
                RowBox[{"{", "\"\<Wolfram\>\"", "}"}], ",", 
                "\"\<Reference.nb\>\""}], "]"}]}], "]"}], "]"}], "}"}], ",", 
          "styles"}], "]"}], "]"}]}], "]"}]}], "]"}]}], ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.5212206271414833`*^9, 3.521220649590794*^9}, {
  3.5213086384941196`*^9, 3.521308639230538*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["NotebookSign and outputcelldb", "Section",
 InitializationCell->True,
 CellChangeTimes->{{3.519734622202305*^9, 3.519734656786418*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Install", "[", "\"\</Volumes/disk0s3/NotebookSign.exe\>\"", "]"}], 
  ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{3.519054397776667*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"outputcelldbvaluesen", "=", 
   RowBox[{"Get", "[", "\"\</Volumes/disk0s3/outputcelldb.m\>\"", "]"}]}], 
  ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{
  3.5194816072615747`*^9, {3.520861924231945*^9, 3.520861924465418*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"outputcelldbvaluesja", "=", 
   RowBox[{"Get", "[", "\"\</Volumes/disk0s3/outputcelldbja.m\>\"", "]"}]}], 
  ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.5208619279424343`*^9, 3.5208619339190702`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"outputcelldbvalueszh", "=", 
   RowBox[{"Get", "[", "\"\</Volumes/disk0s3/outputcelldbzh.m\>\"", "]"}]}], 
  ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.520861929619488*^9, 3.520861937070674*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"outputcelldbvalues", "[", "lang_", "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", "}"}], ",", 
     RowBox[{"Switch", "[", 
      RowBox[{
      "lang", ",", " ", "\"\<English\>\"", ",", " ", "outputcelldbvaluesen", 
       ",", " ", "\"\<Japanese\>\"", ",", " ", "outputcelldbvaluesja", ",", 
       " ", "\"\<ChineseSimplified\>\"", ",", "outputcelldbvalueszh", ",", 
       " ", "_", ",", " ", "outputcelldbvaluesen"}], "]"}]}], "]"}]}], 
  ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.520861959673428*^9, 3.520861983714252*^9}, {
  3.5208620187031*^9, 3.520862053457931*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " guide"
}], "Section",
 InitializationCell->True,
 CellChangeTimes->{{3.5091275056467133`*^9, 3.509127508652862*^9}, 
   3.509128105017721*^9, {3.509190291644957*^9, 3.509190292821233*^9}, {
   3.511186030598137*^9, 3.511186033224094*^9}, {3.5197342044789963`*^9, 
   3.519734206099761*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"mainguideheader", "[", "lang_", "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", "headerimage", "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"headerimage", "=", 
       RowBox[{"Switch", "[", 
        RowBox[{
        "lang", ",", "\"\<English\>\"", ",", 
         "\"\<http://reference.wolfram.com/mathematicaImages/RootWebHeadv8.\
gif\>\"", ",", "\"\<Japanese\>\"", ",", 
         "\"\<http://reference.wolfram.com/mathematicaImages/RootWebHeadv8_jp.\
gif\>\"", ",", "\"\<ChineseSimplified\>\"", ",", 
         "\"\<http://reference.wolfram.com/mathematicaImages/RootWebHeadv8_zh.\
gif\>\"", ",", "_", ",", 
         "\"\<http://reference.wolfram.com/mathematicaImages/RootWebHeadv8.\
gif\>\""}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"Cell", "[", 
       RowBox[{
        RowBox[{"BoxData", "[", 
         RowBox[{"ToBoxes", "[", 
          RowBox[{"Style", "[", 
           RowBox[{
            RowBox[{"Graphics", "[", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{
                RowBox[{"Inset", "[", 
                 RowBox[{
                  RowBox[{"Deploy", "[", 
                   RowBox[{"MouseAppearance", "[", 
                    RowBox[{
                    RowBox[{"Hyperlink", "[", 
                    RowBox[{
                    RowBox[{"Show", "[", 
                    RowBox[{"poweredbybanner", "[", "lang", "]"}], "]"}], ",",
                     " ", "\"\<http://www.wolfram.com/cdf\>\""}], "]"}], ",", 
                    " ", "\"\<LinkHand\>\""}], "]"}], "]"}], ",", 
                  RowBox[{"{", 
                   RowBox[{"867", ",", "131"}], "}"}], ",", 
                  RowBox[{"ContentSelectable", "\[Rule]", "True"}]}], "]"}], 
                ",", 
                RowBox[{"Inset", "[", 
                 RowBox[{
                  RowBox[{"Cell", "[", 
                   RowBox[{
                    RowBox[{"BoxData", "[", 
                    RowBox[{"ToBoxes", "[", 
                    RowBox[{"Import", "[", 
                    RowBox[{"headerimage", ",", " ", "\"\<Graphics\>\""}], 
                    "]"}], "]"}], "]"}], ",", " ", 
                    RowBox[{"ShowCellBracket", "\[Rule]", "False"}]}], "]"}], 
                  ",", 
                  RowBox[{"{", 
                   RowBox[{"387", ",", "72"}], "}"}], ",", 
                  RowBox[{"ContentSelectable", "\[Rule]", "True"}]}], "]"}]}],
                "}"}], ",", 
              RowBox[{"ContentSelectable", "\[Rule]", "True"}], ",", 
              RowBox[{"PlotRange", "->", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"{", 
                  RowBox[{"0", ",", "3000"}], "}"}], ",", 
                 RowBox[{"{", 
                  RowBox[{"0", ",", "143"}], "}"}]}], "}"}]}], ",", 
              RowBox[{"ImageSize", "\[Rule]", 
               RowBox[{"{", 
                RowBox[{"3000", ",", "143"}], "}"}]}]}], "]"}], ",", 
            RowBox[{"ShowSelection", "\[Rule]", "False"}]}], "]"}], "]"}], 
         "]"}], ",", 
        RowBox[{"Deployed", "\[Rule]", "True"}], ",", 
        RowBox[{"ShowCellBracket", "\[Rule]", "False"}], ",", 
        RowBox[{"PageWidth", "->", "WindowWidth"}], ",", 
        RowBox[{"CellBracketOptions", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{"\"\<Margins\>\"", "\[Rule]", 
           RowBox[{"{", 
            RowBox[{"0", ",", "2"}], "}"}]}], "}"}]}], ",", " ", 
        RowBox[{"CellFrame", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"0", ",", "0"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"0", ",", "3"}], "}"}]}], "}"}]}], ",", " ", 
        RowBox[{"CellFrameColor", "\[Rule]", 
         RowBox[{"RGBColor", "[", 
          RowBox[{"0.89012", ",", "0", ",", "0"}], "]"}]}], ",", 
        RowBox[{"CellFrameLabelMargins", "\[Rule]", "0"}], ",", " ", 
        RowBox[{"CellMargins", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"0", ",", "0"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"0", ",", "0"}], "}"}]}], "}"}]}], ",", 
        RowBox[{"CellFrameMargins", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"0", ",", "0"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"0", ",", "0"}], "}"}]}], "}"}]}]}], " ", "]"}]}]}], 
    "]"}]}], ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.517857977312848*^9, 3.517858033204917*^9}, 
   3.51785807744814*^9, {3.517858136835784*^9, 3.5178581542129993`*^9}, {
   3.519733625769581*^9, 3.519733669744318*^9}, {3.519733709770565*^9, 
   3.519733903839514*^9}, {3.5197339431065903`*^9, 3.519733948136855*^9}, 
   3.51973398215812*^9, 3.519734089638535*^9, 3.519755005481429*^9, 
   3.520179111841507*^9, 3.520179775013879*^9, {3.520180548753088*^9, 
   3.5201805494641743`*^9}, {3.5201816063324747`*^9, 3.520181624867782*^9}, {
   3.520274807289772*^9, 3.520274823104987*^9}, {3.520600111138461*^9, 
   3.520600220338106*^9}, {3.520613339069312*^9, 3.5206133589566383`*^9}, {
   3.520614160424678*^9, 3.520614162126902*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"mainguidedescriptioncell", "[", "lang_", "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", "}"}], ",", 
     RowBox[{"Switch", "[", 
      RowBox[{"lang", ",", "\"\<English\>\"", ",", 
       RowBox[{"Cell", "[", 
        RowBox[{
         RowBox[{"TextData", "[", 
          RowBox[{"{", "\n", " ", 
           RowBox[{
            RowBox[{"StyleBox", "[", 
             RowBox[{"\"\<Learn how to use \>\"", ",", "\n", "  ", 
              RowBox[{"FontSize", "\[Rule]", "12"}], ",", "\n", "  ", 
              RowBox[{"FontColor", "->", 
               RowBox[{"GrayLevel", "[", "0.5", "]"}]}]}], "]"}], ",", "\n", 
            " ", 
            RowBox[{"StyleBox", "[", 
             RowBox[{"\"\<Mathematica\>\"", ",", "\n", "  ", 
              RowBox[{"FontSize", "\[Rule]", "12"}], ",", "\n", "  ", 
              RowBox[{"FontSlant", "->", "\"\<Italic\>\""}], ",", "\n", "  ", 
              
              RowBox[{"FontColor", "->", 
               RowBox[{"GrayLevel", "[", "0.5", "]"}]}]}], "]"}], ",", "\n", 
            " ", 
            RowBox[{"StyleBox", "[", 
             RowBox[{
             "\"\< with the definitive guide: 10,000 pages with \>\"", ",", 
              "\n", "  ", 
              RowBox[{"FontSize", "\[Rule]", "12"}], ",", "\n", "  ", 
              RowBox[{"FontColor", "->", 
               RowBox[{"GrayLevel", "[", "0.5", "]"}]}]}], "]"}], ",", "\n", 
            " ", 
            RowBox[{"StyleBox", "[", 
             RowBox[{"\"\<Mathematica\>\"", ",", "\n", "  ", 
              RowBox[{"FontSize", "\[Rule]", "12"}], ",", "\n", "  ", 
              RowBox[{"FontSlant", "->", "\"\<Italic\>\""}], ",", "\n", "  ", 
              
              RowBox[{"FontColor", "->", 
               RowBox[{"GrayLevel", "[", "0.5", "]"}]}]}], "]"}], ",", "\n", 
            " ", 
            RowBox[{"StyleBox", "[", 
             RowBox[{
             "\"\< functions and tutorials and more than 100,000 \>\"", ",", 
              "\n", "  ", 
              RowBox[{"FontSize", "\[Rule]", "12"}], ",", "\n", "  ", 
              RowBox[{"FontColor", "->", 
               RowBox[{"GrayLevel", "[", "0.5", "]"}]}]}], "]"}], ",", "\n", 
            " ", 
            RowBox[{"StyleBox", "[", 
             RowBox[{"\"\<Mathematica\>\"", ",", "\n", "  ", 
              RowBox[{"FontSize", "\[Rule]", "12"}], ",", "\n", "  ", 
              RowBox[{"FontSlant", "->", "\"\<Italic\>\""}], ",", "\n", "  ", 
              
              RowBox[{"FontColor", "->", 
               RowBox[{"GrayLevel", "[", "0.5", "]"}]}]}], "]"}], ",", "\n", 
            " ", 
            RowBox[{"StyleBox", "[", 
             RowBox[{"\"\< examples.\>\"", ",", "\n", "  ", 
              RowBox[{"FontSize", "\[Rule]", "12"}], ",", "\n", "  ", 
              RowBox[{"FontColor", "->", 
               RowBox[{"GrayLevel", "[", "0.5", "]"}]}]}], "]"}]}], "\n", 
           "}"}], "]"}], ",", " ", "\"\<Text\>\"", ",", 
         RowBox[{"ShowCellBracket", "\[Rule]", "False"}], ",", " ", 
         RowBox[{"CellMargins", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"150", ",", "120"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"0", ",", "0"}], "}"}]}], "}"}]}]}], "]"}], ",", " ", 
       "\"\<Japanese\>\"", ",", 
       RowBox[{"Cell", "[", 
        RowBox[{
         RowBox[{"TextData", "[", 
          RowBox[{"{", "\n", " ", 
           RowBox[{
            RowBox[{"StyleBox", "[", 
             RowBox[{
             "\"\<\:5b8c\:5168\:306a\:30ac\:30a4\:30c9\:3067\>\"", ",", " ", 
              RowBox[{"FontSize", "\[Rule]", "12"}], ",", "\n", "  ", 
              RowBox[{"FontColor", "->", 
               RowBox[{"GrayLevel", "[", "0.5", "]"}]}]}], "]"}], ",", 
            RowBox[{"StyleBox", "[", 
             RowBox[{"\"\<Mathematica\>\"", ",", "\n", "  ", 
              RowBox[{"FontSize", "\[Rule]", "12"}], ",", "\n", "  ", 
              RowBox[{"FontSlant", "->", "\"\<Italic\>\""}], ",", "\n", "  ", 
              
              RowBox[{"FontColor", "->", 
               RowBox[{"GrayLevel", "[", "0.5", "]"}]}]}], "]"}], ",", 
            RowBox[{"StyleBox", "[", 
             RowBox[{
             "\"\<\:306e\:4f7f\:3044\:65b9\:3092\:5b66\:3073\:307e\:3057\:3087\
\:3046\:ff0e\>\"", ",", " ", 
              RowBox[{"FontSize", "\[Rule]", "12"}], ",", "\n", "  ", 
              RowBox[{"FontColor", "->", 
               RowBox[{"GrayLevel", "[", "0.5", "]"}]}]}], "]"}], ",", 
            RowBox[{"StyleBox", "[", 
             RowBox[{
             "\"\<                                                       \
\>\"", ",", " ", 
              RowBox[{"FontSize", "\[Rule]", "12"}], ",", "\n", "  ", 
              RowBox[{"FontColor", "->", 
               RowBox[{"GrayLevel", "[", "0.5", "]"}]}]}], "]"}], ",", 
            RowBox[{"StyleBox", "[", 
             RowBox[{
             "\"\<10,000\:30da\:30fc\:30b8\:306b\:304a\:3088\:3076\>\"", ",", 
              " ", 
              RowBox[{"FontSize", "\[Rule]", "12"}], ",", "\n", "  ", 
              RowBox[{"FontColor", "->", 
               RowBox[{"GrayLevel", "[", "0.5", "]"}]}]}], "]"}], ",", 
            RowBox[{"StyleBox", "[", 
             RowBox[{"\"\<Mathematica\>\"", ",", "\n", "  ", 
              RowBox[{"FontSize", "\[Rule]", "12"}], ",", "\n", "  ", 
              RowBox[{"FontSlant", "->", "\"\<Italic\>\""}], ",", "\n", "  ", 
              
              RowBox[{"FontColor", "->", 
               RowBox[{"GrayLevel", "[", "0.5", "]"}]}]}], "]"}], ",", 
            RowBox[{"StyleBox", "[", 
             RowBox[{
             "\"\<\:95a2\:6570\:3068\:30c1\:30e5\:30fc\:30c8\:30ea\:30a2\:30eb\
\:ff0e\:4f8b\:984c\:6570\:306f100,000\:3092\:8d85\:3048\:307e\:3059\:ff0e\>\"\
", ",", " ", 
              RowBox[{"FontSize", "\[Rule]", "12"}], ",", "\n", "  ", 
              RowBox[{"FontColor", "->", 
               RowBox[{"GrayLevel", "[", "0.5", "]"}]}]}], "]"}]}], "\n", 
           "}"}], "]"}], ",", " ", "\"\<Text\>\"", ",", 
         RowBox[{"ShowCellBracket", "\[Rule]", "False"}], ",", " ", 
         RowBox[{"CellMargins", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"150", ",", "120"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"0", ",", "0"}], "}"}]}], "}"}]}]}], "]"}], ",", 
       "\"\<ChineseSimplified\>\"", ",", " ", 
       RowBox[{"Cell", "[", 
        RowBox[{
         RowBox[{"TextData", "[", 
          RowBox[{"{", "\n", " ", 
           RowBox[{
            RowBox[{"StyleBox", "[", 
             RowBox[{
             "\"\<\:5229\:7528\:529f\:80fd\:6307\:5357\:ff0c\:4e86\:89e3\:5982\
\:4f55\:4f7f\:7528\>\"", ",", " ", 
              RowBox[{"FontSize", "\[Rule]", "12"}], ",", "\n", "  ", 
              RowBox[{"FontColor", "->", 
               RowBox[{"GrayLevel", "[", "0.5", "]"}]}]}], "]"}], ",", " ", 
            RowBox[{"StyleBox", "[", 
             RowBox[{"\"\<Mathematica\>\"", ",", "\n", "  ", 
              RowBox[{"FontSize", "\[Rule]", "12"}], ",", "\n", "  ", 
              RowBox[{"FontSlant", "->", "\"\<Italic\>\""}], ",", "\n", "  ", 
              
              RowBox[{"FontColor", "->", 
               RowBox[{"GrayLevel", "[", "0.5", "]"}]}]}], "]"}], ",", 
            RowBox[{"StyleBox", "[", 
             RowBox[{
             "\"\<\:ff1a\:8fd9\:91cc\:63d0\:4f9b\:4e86\:957f\:8fbe10,000\:9875\
\:7684 \>\"", ",", " ", 
              RowBox[{"FontSize", "\[Rule]", "12"}], ",", "\n", "  ", 
              RowBox[{"FontColor", "->", 
               RowBox[{"GrayLevel", "[", "0.5", "]"}]}]}], "]"}], ",", "\n", 
            RowBox[{"StyleBox", "[", 
             RowBox[{"\"\<Mathematica\>\"", ",", "\n", "  ", 
              RowBox[{"FontSize", "\[Rule]", "12"}], ",", "\n", "  ", 
              RowBox[{"FontSlant", "->", "\"\<Italic\>\""}], ",", "\n", "  ", 
              
              RowBox[{"FontColor", "->", 
               RowBox[{"GrayLevel", "[", "0.5", "]"}]}]}], "]"}], ",", 
            RowBox[{"StyleBox", "[", 
             RowBox[{
             "\"\< \:51fd\:6570\:4fe1\:606f\:548c\:76f8\:5173\:6559\:7a0b\
\:ff0c\:4ee5\:53ca\:8d85\:8fc710\:4e07\:4e2a\:8303\:4f8b.\>\"", ",", " ", 
              RowBox[{"FontSize", "\[Rule]", "12"}], ",", "\n", "  ", 
              RowBox[{"FontColor", "->", 
               RowBox[{"GrayLevel", "[", "0.5", "]"}]}]}], "]"}]}], "\n", 
           "}"}], "]"}], ",", " ", "\"\<Text\>\"", ",", 
         RowBox[{"ShowCellBracket", "\[Rule]", "False"}], ",", " ", 
         RowBox[{"CellMargins", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"150", ",", "120"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"0", ",", "0"}], "}"}]}], "}"}]}]}], "]"}], ",", " ", 
       "_", ",", " ", 
       RowBox[{"Cell", "[", 
        RowBox[{
         RowBox[{"TextData", "[", 
          RowBox[{"{", "\n", " ", 
           RowBox[{
            RowBox[{"StyleBox", "[", 
             RowBox[{"\"\<Learn how to use \>\"", ",", "\n", "  ", 
              RowBox[{"FontSize", "\[Rule]", "12"}], ",", "\n", "  ", 
              RowBox[{"FontColor", "->", 
               RowBox[{"GrayLevel", "[", "0.5", "]"}]}]}], "]"}], ",", "\n", 
            " ", 
            RowBox[{"StyleBox", "[", 
             RowBox[{"\"\<Mathematica\>\"", ",", "\n", "  ", 
              RowBox[{"FontSize", "\[Rule]", "12"}], ",", "\n", "  ", 
              RowBox[{"FontSlant", "->", "\"\<Italic\>\""}], ",", "\n", "  ", 
              
              RowBox[{"FontColor", "->", 
               RowBox[{"GrayLevel", "[", "0.5", "]"}]}]}], "]"}], ",", "\n", 
            " ", 
            RowBox[{"StyleBox", "[", 
             RowBox[{
             "\"\< with the definitive guide: 10,000 pages with \>\"", ",", 
              "\n", "  ", 
              RowBox[{"FontSize", "\[Rule]", "12"}], ",", "\n", "  ", 
              RowBox[{"FontColor", "->", 
               RowBox[{"GrayLevel", "[", "0.5", "]"}]}]}], "]"}], ",", "\n", 
            " ", 
            RowBox[{"StyleBox", "[", 
             RowBox[{"\"\<Mathematica\>\"", ",", "\n", "  ", 
              RowBox[{"FontSize", "\[Rule]", "12"}], ",", "\n", "  ", 
              RowBox[{"FontSlant", "->", "\"\<Italic\>\""}], ",", "\n", "  ", 
              
              RowBox[{"FontColor", "->", 
               RowBox[{"GrayLevel", "[", "0.5", "]"}]}]}], "]"}], ",", "\n", 
            " ", 
            RowBox[{"StyleBox", "[", 
             RowBox[{
             "\"\< functions and tutorials and more than 100,000 \>\"", ",", 
              "\n", "  ", 
              RowBox[{"FontSize", "\[Rule]", "12"}], ",", "\n", "  ", 
              RowBox[{"FontColor", "->", 
               RowBox[{"GrayLevel", "[", "0.5", "]"}]}]}], "]"}], ",", "\n", 
            " ", 
            RowBox[{"StyleBox", "[", 
             RowBox[{"\"\<Mathematica\>\"", ",", "\n", "  ", 
              RowBox[{"FontSize", "\[Rule]", "12"}], ",", "\n", "  ", 
              RowBox[{"FontSlant", "->", "\"\<Italic\>\""}], ",", "\n", "  ", 
              
              RowBox[{"FontColor", "->", 
               RowBox[{"GrayLevel", "[", "0.5", "]"}]}]}], "]"}], ",", "\n", 
            " ", 
            RowBox[{"StyleBox", "[", 
             RowBox[{"\"\< examples.\>\"", ",", "\n", "  ", 
              RowBox[{"FontSize", "\[Rule]", "12"}], ",", "\n", "  ", 
              RowBox[{"FontColor", "->", 
               RowBox[{"GrayLevel", "[", "0.5", "]"}]}]}], "]"}]}], "\n", 
           "}"}], "]"}], ",", " ", "\"\<Text\>\"", ",", 
         RowBox[{"ShowCellBracket", "\[Rule]", "False"}], ",", " ", 
         RowBox[{"CellMargins", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"150", ",", "120"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"0", ",", "0"}], "}"}]}], "}"}]}]}], "]"}]}], "]"}]}], 
    "]"}]}], ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.5125655683477297`*^9, 3.512565617921015*^9}, {
   3.512565725185368*^9, 3.5125657742426853`*^9}, {3.512565824160314*^9, 
   3.512565830816577*^9}, {3.512565868051507*^9, 3.512565916148758*^9}, 
   3.513084653284584*^9, {3.5205996561617193`*^9, 3.520599721298053*^9}, {
   3.520599772541041*^9, 3.5205998134315443`*^9}, {3.52059986627186*^9, 
   3.5205998939419737`*^9}, {3.52059996628456*^9, 3.520600000463808*^9}, {
   3.520607439996002*^9, 3.520607455581377*^9}, {3.5206082126451893`*^9, 
   3.52060822622367*^9}, {3.520608407357452*^9, 3.5206085130385*^9}, {
   3.520613607946135*^9, 3.520613742634112*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"HowToFootIcon", "=", 
   RowBox[{
   "Import", "[", 
    "\"\<http://reference.wolfram.com/mathematicaImages/HowToFootIcon.gif\>\"\
", "]"}]}], ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{
  3.513084799798604*^9, {3.513084838249352*^9, 3.5130848452178793`*^9}, 
   3.519755006467676*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"mainguidesearch", "[", "lang_", "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", "}"}], ",", 
     RowBox[{"Cell", "[", 
      RowBox[{
       RowBox[{"BoxData", "[", 
        RowBox[{"ToBoxes", "[", 
         RowBox[{"Style", "[", 
          RowBox[{
           RowBox[{"DynamicModule", "[", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"searchrefstr", "=", "Null"}], "}"}], ",", 
             RowBox[{"Overlay", "[", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"Show", "[", 
                  RowBox[{"With", "[", 
                   RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"w", "=", "500"}], ",", 
                    RowBox[{"h", "=", "29"}]}], "}"}], ",", 
                    RowBox[{"Graphics", "[", 
                    RowBox[{
                    RowBox[{"Raster", "[", 
                    RowBox[{
                    RowBox[{"Reverse", "@", 
                    RowBox[{"ImageData", "[", 
                    RowBox[{
                    "Import", "[", 
                    "\"\<http://reference.wolfram.com/css/redbar.gif\>\"", 
                    "]"}], "]"}]}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"0", ",", "0"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"w", ",", "h"}], "}"}]}], "}"}]}], "]"}], ",", 
                    RowBox[{"ImageSize", "\[Rule]", 
                    RowBox[{"{", 
                    RowBox[{"w", ",", "h"}], "}"}]}], ",", 
                    RowBox[{"PlotRangePadding", "\[Rule]", "None"}], ",", 
                    RowBox[{"ImagePadding", "\[Rule]", "None"}]}], "]"}]}], 
                   "]"}], "]"}], ",", 
                 RowBox[{"Graphics", "[", 
                  RowBox[{
                   RowBox[{"{", 
                    RowBox[{
                    RowBox[{"Inset", "[", 
                    RowBox[{
                    RowBox[{"Graphics", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"White", ",", 
                    RowBox[{"FontSize", "\[Rule]", "13"}], ",", 
                    RowBox[{"FontFamily", "\[Rule]", "\"\<Helvetica\>\""}], 
                    ",", 
                    RowBox[{"Opacity", "[", "1", "]"}], ",", 
                    RowBox[{"Text", "[", 
                    RowBox[{"CDFLocalized", "[", 
                    RowBox[{"\"\<SEARCH\>\"", ",", "lang"}], "]"}], "]"}]}], 
                    "}"}], ",", 
                    RowBox[{"ImageSize", "\[Rule]", 
                    RowBox[{"{", 
                    RowBox[{"100", ",", "29"}], "}"}]}]}], "]"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"100", ",", "14"}], "}"}]}], "]"}], ",", 
                    RowBox[{"Inset", "[", 
                    RowBox[{
                    RowBox[{"EventHandler", "[", 
                    RowBox[{
                    RowBox[{"Framed", "[", 
                    RowBox[{
                    RowBox[{"Style", "[", 
                    RowBox[{
                    RowBox[{"InputField", "[", 
                    RowBox[{
                    RowBox[{"Dynamic", "[", "searchrefstr", "]"}], ",", 
                    "String", ",", 
                    RowBox[{"Appearance", "\[Rule]", "None"}], ",", 
                    RowBox[{"ContinuousAction", "\[Rule]", "True"}], ",", 
                    RowBox[{"BaseStyle", "\[Rule]", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"GrayLevel", "[", "0", "]"}], ",", 
                    RowBox[{"FontSize", "\[Rule]", "12"}], ",", 
                    RowBox[{"FontFamily", "\[Rule]", "\"\<Helvetica\>\""}]}], 
                    "}"}]}], ",", 
                    RowBox[{"FieldHintStyle", "\[Rule]", 
                    RowBox[{"{", "}"}]}], ",", 
                    RowBox[{"FieldSize", "\[Rule]", 
                    RowBox[{"{", 
                    RowBox[{"28", ",", 
                    RowBox[{"{", 
                    RowBox[{"1", ",", "1"}], "}"}]}], "}"}]}], ",", " ", 
                    RowBox[{"ImageSize", "\[Rule]", "250"}], ",", " ", 
                    RowBox[{"Background", "\[Rule]", "White"}]}], "]"}], ",", 
                    
                    RowBox[{"ShowSelection", "\[Rule]", "True"}]}], "]"}], 
                    ",", 
                    RowBox[{"Background", "\[Rule]", "White"}], ",", 
                    RowBox[{"FrameMargins", "\[Rule]", "0"}], ",", 
                    RowBox[{"ImageSize", "\[Rule]", 
                    RowBox[{"{", 
                    RowBox[{"250", ",", "20"}], "}"}]}], ",", 
                    RowBox[{"FrameStyle", "\[Rule]", 
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0.83", ",", "0.83", ",", "0.83"}], "]"}]}]}], 
                    "]"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"\"\<ReturnKeyDown\>\"", "\[RuleDelayed]", 
                    RowBox[{"NotebookLocate", "[", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"URL", "[", 
                    RowBox[{
                    "\"\<http://reference.wolfram.com/search.html?collection=\
reference&lang=en&query=\>\"", "<>", 
                    RowBox[{"ToString", "[", "searchrefstr", "]"}], "<>", 
                    "\"\<&cdf=true\>\""}], "]"}], ",", "None"}], "}"}], 
                    "]"}]}], ",", "\[IndentingNewLine]", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "\"\<MenuCommand\>\"", ",", "\"\<HandleShiftReturn\>\""}],
                     "}"}], "\[RuleDelayed]", 
                    RowBox[{"NotebookLocate", "[", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"URL", "[", 
                    RowBox[{
                    "\"\<http://reference.wolfram.com/search.html?collection=\
reference&lang=en&query=\>\"", "<>", 
                    RowBox[{"ToString", "[", "searchrefstr", "]"}], "<>", 
                    "\"\<&cdf=true\>\""}], "]"}], ",", "None"}], "}"}], 
                    "]"}]}], ",", "\[IndentingNewLine]", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "\"\<MenuCommand\>\"", ",", "\"\<EvaluateCells\>\""}], 
                    "}"}], "\[RuleDelayed]", 
                    RowBox[{"NotebookLocate", "[", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"URL", "[", 
                    RowBox[{
                    "\"\<http://reference.wolfram.com/search.html?collection=\
reference&lang=en&query=\>\"", "<>", 
                    RowBox[{"ToString", "[", "searchrefstr", "]"}], "<>", 
                    "\"\<&cdf=true\>\""}], "]"}], ",", "None"}], "}"}], 
                    "]"}]}]}], "}"}]}], "]"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"260", ",", "15"}], "}"}], ",", 
                    RowBox[{"ContentSelectable", "\[Rule]", "True"}]}], "]"}],
                     ",", 
                    RowBox[{"Inset", "[", 
                    RowBox[{
                    RowBox[{"Button", "[", 
                    RowBox[{
                    GraphicsBox[
                    TagBox[RasterBox[CompressedData["
1:eJxt0M1rFVcYBvCA/4CbrlwUN4UiSbWGUtNuJBbU6MK22SQUJC0JhaDJQhd2
4ao0SwXFKhoSbUyprSQQWgsxhMTc3Dt3vs58nTlfc86c+bhz70zuTYzSjaBX
uh34PfAu3hdensNjl78eO9DT0/NBNwe7eT+rZ0bB91PB+EQpOD5JfpwOxn6I
JibA0Fm1f5DNz70N/M5eu1TrdePlfr7fif7L+a5RiRf+ktRsvSmKfL9UY7/T
zl9Fe3tJZ7fdLnZR2G5GQSySIin1Mk3f8nbR6jTSIttpNotkL4raYStLG6Vw
EeRJUxa5bOQ8CUkepJLzIMripJRoxpksGmGeiZ2MyDiWzZaEEZdxuWYgJc9a
IkviVtYdYxH5Fk1EEmWldmSAsjBthLDJ4gyHMZE0oFJiQbM4rD2ee/zR8T/P
DxtWbfvW3YXez9auXxPSTbOE2QFJUkvy//eZzMKQU+ls3r7z8NAXSyMTCVRW
Ryfv9R6v3n8QxkwmrQ6JI8w4IogFCdqhgiOB2ki8mP754cefb1/5ia1Vng0O
zfae1B88ImEYWF7IBQaO6bjUpDbE2PRd23E2/7135NOVU9/WPX1jZPTJhwMr
F6cqhmpTqAHTVQ1VM6q1TcN0NQVUtOe/DV+YOzawsTi7cePm4icnFodGtCd/
1LG9ubHmKaqnmbpuerai6SZYryx9893KoaN/T1/d+ufps6Onf+37sr68VEOq
YVtMUetbW75h2cCxVNN1zLWF+d/7vlodvQRNZfn6zFz/OeXufVWrGtixdcvX
jbpndv/3HGjAmAOd+Fump6qu4xAHuwACgKFJPew7LvAQ9BzHA4DqAWIIu6UA
oT4lBkGSYcskkCFVetzA3ZNSwmXdGhEiEYIOwJijJA3tQFIiSsWIM4io6LYP
uZBC+JFesxiEyC/lIv997RRZXpVzJjUF/jJD7HWu1UoFVYUAAwOLGRVaqXqz
i+8AS+8n9w==
                    "], {{0, 21}, {16, 0}}, {0, 255},
                    ColorFunction->RGBColor],
                    BoxForm`ImageTag[
                    "Byte", ColorSpace -> "RGB", Interleaving -> True],
                    Selectable->False],
                    BaseStyle->"ImageGraphics",
                    ImageSize->Automatic,
                    ImageSizeRaw->{16, 21},
                    PlotRange->{{0, 16}, {0, 21}}], ",", " ", 
                    RowBox[{"NotebookLocate", "[", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"URL", "[", 
                    RowBox[{
                    "\"\<http://reference.wolfram.com/search.html?collection=\
reference&lang=en&query=\>\"", "<>", 
                    RowBox[{"ToString", "[", "searchrefstr", "]"}], "<>", 
                    "\"\<&cdf=true\>\""}], "]"}], ",", "None"}], "}"}], "]"}],
                     ",", 
                    RowBox[{"Appearance", "\[Rule]", "None"}]}], "]"}], ",", 
                    " ", 
                    RowBox[{"{", 
                    RowBox[{"405", ",", "15"}], "}"}], ",", 
                    RowBox[{"ContentSelectable", "\[Rule]", "True"}]}], 
                    "]"}]}], "}"}], ",", 
                   RowBox[{"ContentSelectable", "\[Rule]", "True"}], ",", 
                   RowBox[{"PlotRange", "\[Rule]", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"0", ",", "500"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"0", ",", "29"}], "}"}]}], "}"}]}], ",", 
                   RowBox[{"ImageSize", "\[Rule]", 
                    RowBox[{"{", 
                    RowBox[{"500", ",", "29"}], "}"}]}]}], "]"}]}], "}"}], 
               ",", "All", ",", "2"}], "]"}]}], "]"}], ",", 
           RowBox[{"ShowSelection", "\[Rule]", "False"}]}], "]"}], "]"}], 
        "]"}], ",", 
       RowBox[{"CellMargins", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"150", ",", "0"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"18", ",", "0"}], "}"}]}], "}"}]}], ",", 
       RowBox[{"ShowCellBracket", "\[Rule]", "False"}]}], " ", "]"}]}], 
    "]"}]}], ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.512572633573265*^9, 3.512572638450489*^9}, 
   3.512572790254793*^9, {3.5125728724183397`*^9, 3.512572908101696*^9}, {
   3.5125758414240227`*^9, 3.512575846701885*^9}, 3.5125759371192493`*^9, {
   3.512576059642345*^9, 3.512576063089025*^9}, {3.5125762188860607`*^9, 
   3.512576230710649*^9}, {3.512576346496169*^9, 3.512576346973661*^9}, {
   3.51257740704187*^9, 3.512577408288722*^9}, 3.512577470308876*^9, {
   3.512577657132471*^9, 3.512577663963044*^9}, {3.5125776962784777`*^9, 
   3.512577901595316*^9}, {3.512577991508168*^9, 3.512578004099375*^9}, {
   3.512578059044243*^9, 3.512578130379685*^9}, {3.512578171559558*^9, 
   3.512578204976284*^9}, {3.512578291565887*^9, 3.512578336842822*^9}, {
   3.512578539041584*^9, 3.512578542400586*^9}, {3.512578724312593*^9, 
   3.512578764241181*^9}, {3.512578796799768*^9, 3.512578826117539*^9}, {
   3.5125789103249702`*^9, 3.512578910578714*^9}, {3.512578979446015*^9, 
   3.512578979715975*^9}, {3.512579088986718*^9, 3.512579089272277*^9}, {
   3.5130845864670963`*^9, 3.513084595636326*^9}, {3.5136040869329967`*^9, 
   3.5136041013399067`*^9}, {3.516457302412208*^9, 3.5164573078093452`*^9}, {
   3.5164596548934107`*^9, 3.5164596566272917`*^9}, {3.519755007723733*^9, 
   3.519755011162772*^9}, {3.5206003143138113`*^9, 3.520600327247129*^9}, {
   3.5206003803967752`*^9, 3.520600388723727*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"headergrid", "[", "lang_", "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", "}"}], ",", 
     RowBox[{"Cell", "[", 
      RowBox[{
       RowBox[{"BoxData", "[", 
        RowBox[{"GridBox", "[", 
         RowBox[{"{", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"Cell", "[", 
             RowBox[{"BoxData", "[", 
              RowBox[{"ButtonBox", "[", 
               RowBox[{
                RowBox[{"PaneSelectorBox", "[", 
                 RowBox[{
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{"False", "\[Rule]", 
                    RowBox[{"RowBox", "[", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"Cell", "[", 
                    RowBox[{"BoxData", "[", 
                    RowBox[{"GraphicsBox", "[", 
                    RowBox[{
                    RowBox[{"RasterBox", "[", 
                    RowBox[{
                    RowBox[{
                    "CompressedData", "[", 
                    "\"\<\\n1:eJzNlN9PE0EQx0n8K/\
TNf8k3jRBTlOQELJQECSiBRNAXnkwgMTEm/A1ESHtt\\n2qrBklrCj7YEeGuRPrXa6+\
3t7Y87v3erl217PsmDk3azOzv7uZnZ2bmbSN5L\\n3BoZGbmN/x38g7l/0+\
KFgomUUgih5kqgUQaRpVJCMFe7atRpA2TdwOuXWGeG\\\
nNd1ut9FonJ2d1Wq1er1erVaPjo6qQ3J6eooRBicnJ19DwbLX6+modrtt2/aw\\\
nS7EJiZYq3svLSwB1/dXVldpC3lzXhRKTII2MB4nE0hPK2GU03OK+kLBkjHEp\\\
nCoWiTgMcNlHm1XX8Xvo+sYkXui08SW3CBBN+oMAPNBh/Ln7SacfHxwqCJecc\\\
nI6UUE1I6oPbPgMkFpQ40AHrwihDHceAzd6HjppnWc3J+fq5CAxlmqk4syyLL\\\
nL9jGhlsP0sIEx5ZLWQD3ACeu6yBQIf1CoaDTECkPBRA3lCBFrtuZS4kpgy0u\\\
n2NvbTrMBpd2zbNKDeyJIMYUNcJlMVo8UN678wS48VEAE252bEZMT7PE4Nyb4\\n0qK9s8M7bU/\
6gvtw0/eQFlcIrvsGCIpHQQghKnUklE7qGZ+e4oYhxsf42ANu\\nPBWv39DKN08i/QzJowxf5x93d/\
VIUbQgKMcg6gqg/5FM8icJ+eihSIyKqUlh\\\
nGHL0Pk9OdrM54TGXCh4kjuXzed033IIfJ53VZbG4JGZn2Pw8n52RqWnyas2q\\\
n1iIDeIgUDdDwmmJp3c23bH1NLDznqSRbXXFwyqHRqYiWyWQG7jSWZm9u8vU1\\nvvKSvv/\
AvregEbKvn6jqLZVK+qnDw8N42tYW23rnlMv+H4jsbxjKt3S6r3or\\\
nlUosjZQPpGXpmqgz6L4Vi0XdZn9/P5YWPtO+WfDeh2gDx6+vr5G6Vqulvq6a\\\
nQ9AfuKQO8YPCDx6UFfrp2AT1AzM8NDQfvPGLi4sIpb7SbDYBxO2gsHHjpmlm\\ns9lcroAxm8/\
lzJyZzuS/FPb29mCAXUSHsVwuo8cC+5fQ/lViu/1/QrtB+QWK\\n+S+z\\n               \
\>\"", "]"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"0", ",", "0"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"26", ",", "25"}], "}"}]}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"0", ",", "255"}], "}"}], ",", 
                    RowBox[{"ColorFunction", "\[Rule]", "RGBColor"}]}], "]"}],
                     ",", 
                    RowBox[{"ImageSize", "\[Rule]", 
                    RowBox[{"{", 
                    RowBox[{"26", ",", "25"}], "}"}]}], ",", 
                    RowBox[{"PlotRange", "\[Rule]", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"0", ",", "26"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"0", ",", "25"}], "}"}]}], "}"}]}]}], "]"}], 
                    "]"}], "]"}], ",", "\"\<\[ThickSpace]\>\"", ",", 
                    RowBox[{"Cell", "[", 
                    RowBox[{
                    RowBox[{"CDFLocalized", "[", 
                    RowBox[{
                    "\"\<Getting Started Videos\[NonBreakingSpace]\
\[RightGuillemet]\>\"", ",", " ", "lang"}], "]"}], ",", 
                    "\"\<RootFooterMainLink\>\""}], "]"}]}], "}"}], "]"}]}], 
                    ",", 
                    RowBox[{"True", "\[Rule]", 
                    RowBox[{"RowBox", "[", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"Cell", "[", 
                    RowBox[{"BoxData", "[", 
                    RowBox[{"GraphicsBox", "[", 
                    RowBox[{
                    RowBox[{"RasterBox", "[", 
                    RowBox[{
                    RowBox[{
                    "CompressedData", "[", 
                    "\"\<\\n1:eJzNlN9PE0EQx0n8K/\
TNf8k3jRBTlOQELJQECSiBRNAXnkwgMTEm/A1ESHtt\\n2qrBklrCj7YEeGuRPrXa6+\
3t7Y87v3erl217PsmDk3azOzv7uZnZ2bmbSN5L\\n3BoZGbmN/x38g7l/0+\
KFgomUUgih5kqgUQaRpVJCMFe7atRpA2TdwOuXWGeG\\\
nNd1ut9FonJ2d1Wq1er1erVaPjo6qQ3J6eooRBicnJ19DwbLX6+modrtt2/aw\\\
nS7EJiZYq3svLSwB1/dXVldpC3lzXhRKTII2MB4nE0hPK2GU03OK+kLBkjHEp\\\
nCoWiTgMcNlHm1XX8Xvo+sYkXui08SW3CBBN+oMAPNBh/Ln7SacfHxwqCJecc\\\
nI6UUE1I6oPbPgMkFpQ40AHrwihDHceAzd6HjppnWc3J+fq5CAxlmqk4syyLL\\\
nL9jGhlsP0sIEx5ZLWQD3ACeu6yBQIf1CoaDTECkPBRA3lCBFrtuZS4kpgy0u\\\
n2NvbTrMBpd2zbNKDeyJIMYUNcJlMVo8UN678wS48VEAE252bEZMT7PE4Nyb4\\n0qK9s8M7bU/\
6gvtw0/eQFlcIrvsGCIpHQQghKnUklE7qGZ+e4oYhxsf42ANu\\nPBWv39DKN08i/QzJowxf5x93d/\
VIUbQgKMcg6gqg/5FM8icJ+eihSIyKqUlh\\\
nGHL0Pk9OdrM54TGXCh4kjuXzed033IIfJ53VZbG4JGZn2Pw8n52RqWnyas2q\\\
n1iIDeIgUDdDwmmJp3c23bH1NLDznqSRbXXFwyqHRqYiWyWQG7jSWZm9u8vU1\\nvvKSvv/\
AvregEbKvn6jqLZVK+qnDw8N42tYW23rnlMv+H4jsbxjKt3S6r3or\\\
nlUosjZQPpGXpmqgz6L4Vi0XdZn9/P5YWPtO+WfDeh2gDx6+vr5G6Vqulvq6a\\\
nQ9AfuKQO8YPCDx6UFfrp2AT1AzM8NDQfvPGLi4sIpb7SbDYBxO2gsHHjpmlm\\ns9lcroAxm8/\
lzJyZzuS/FPb29mCAXUSHsVwuo8cC+5fQ/lViu/1/QrtB+QWK\\n+S+z\\n               \
\>\"", "]"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"0", ",", "0"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"26", ",", "25"}], "}"}]}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"0", ",", "255"}], "}"}], ",", 
                    RowBox[{"ColorFunction", "\[Rule]", "RGBColor"}]}], "]"}],
                     ",", 
                    RowBox[{"ImageSize", "\[Rule]", 
                    RowBox[{"{", 
                    RowBox[{"26", ",", "25"}], "}"}]}], ",", 
                    RowBox[{"PlotRange", "\[Rule]", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"0", ",", "26"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"0", ",", "25"}], "}"}]}], "}"}]}]}], "]"}], 
                    "]"}], "]"}], ",", "\"\<\[ThickSpace]\>\"", ",", 
                    RowBox[{"Cell", "[", 
                    RowBox[{
                    RowBox[{"CDFLocalized", "[", 
                    RowBox[{
                    "\"\<Getting Started Videos\[NonBreakingSpace]\
\[RightGuillemet]\>\"", ",", " ", "lang"}], "]"}], ",", 
                    "\"\<RootFooterRedLink\>\""}], "]"}]}], "}"}], "]"}]}]}], 
                   "}"}], ",", 
                  RowBox[{"Dynamic", "[", 
                   RowBox[{"CurrentValue", "[", "\"\<MouseOver\>\"", "]"}], 
                   "]"}]}], "]"}], ",", 
                RowBox[{"BaseStyle", "\[Rule]", 
                 RowBox[{"{", 
                  RowBox[{
                  "\"\<RootFooterMainLink\>\"", ",", "\"\<Hyperlink\>\""}], 
                  "}"}]}], ",", 
                RowBox[{"ButtonData", "\[Rule]", 
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{
                   "URL", "[", 
                    "\"\<http://www.wolfram.com/support/learn/get-started-\
with-mathematica\>\"", "]"}], ",", "None"}], "}"}]}], ",", 
                RowBox[{"ButtonNote", "\[Rule]", "None"}]}], "]"}], "]"}], 
             "]"}], ",", 
            RowBox[{"Cell", "[", 
             RowBox[{"BoxData", "[", 
              RowBox[{"ButtonBox", "[", 
               RowBox[{
                RowBox[{"PaneSelectorBox", "[", 
                 RowBox[{
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{"False", "\[Rule]", 
                    RowBox[{"RowBox", "[", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"Cell", "[", 
                    RowBox[{"BoxData", "[", 
                    RowBox[{"GraphicsBox", "[", 
                    RowBox[{
                    RowBox[{"RasterBox", "[", 
                    RowBox[{
                    RowBox[{
                    "CompressedData", "[", 
                    "\"\<\\n1:eJy1k91L02EUx3/\
QH9BdEXTTC3RXEkheRF115QyaxShhkYUUNKVpbzRibYR2\\\
n4YyGL6FLNys104vlbKslyipMyQwraS0IwXLZ1ib9tvnT/T5tOpxOvdDoPJyH\\ncx7O+\
Z6X55xthSXKwg2CIGxJ8MYEJ2XWQvJ/ozWlsQ6SpeisGJ354Y94Rz+1\\ntb2tMQcGBqO/\
gyQjZ0Zf0ONh0e95MeFwBD090lRg/m21EDPBwM8HloDLKX7+\\nOhsOLSAtr02W43/\
ESKDbMVZfF3rukmKzq2HGE97fxrh0liJVJDc7knuABvOK\\\
n9aXY0UyOwC6B3QJZAsrtxKaX1jQvz6k2A4c3s3cH+7ei2En+JoYH4pmwc5Zv\\netGpUOZwaE/\
yLtiHOhttEZKYka0cnOSWBoOaEwc5p6BYQUkeZXkUZNHWCEsr\\\
ntdtouIBehU5JpZqqIipOcvM4xmNo8/GPpy1jEawGbJcxnaHdiLuaPgtPqrCW\\nUa/\
lxlFedafTCIVpLaexlA49Xje/vAS/8P0d/Y94eI07p+hrTyNPx7CbaCql\\n1cBwJ+MjjH/E95qX9+\
k00nCF9570PCTOkJN7GmrP01xMVznuu9gr6DDQcp0W\\\
nPeHJ1K8RT3ZSkugyYzqC9SKuOnpqeHobq5YmDaP9KcjFXyhO8away2m6K+mt\\\
n5bGO1qt4Bxd1bck0yQn3CR8jbj448Q0hBlcYjWW0rmX7pw39CxYT8tA=\\n               \>\
\"", "]"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"0", ",", "0"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"15", ",", "25"}], "}"}]}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"0", ",", "255"}], "}"}], ",", 
                    RowBox[{"ColorFunction", "\[Rule]", "RGBColor"}]}], "]"}],
                     ",", 
                    RowBox[{"ImageSize", "\[Rule]", 
                    RowBox[{"{", 
                    RowBox[{"15", ",", "25"}], "}"}]}], ",", 
                    RowBox[{"PlotRange", "\[Rule]", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"0", ",", "15"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"0", ",", "25"}], "}"}]}], "}"}]}]}], "]"}], 
                    "]"}], "]"}], ",", "\"\<\[ThickSpace]\>\"", ",", 
                    RowBox[{"Cell", "[", 
                    RowBox[{
                    RowBox[{"CDFLocalized", "[", 
                    RowBox[{
                    "\"\<Find Your Learning Path\[NonBreakingSpace]\
\[RightGuillemet]\>\"", ",", "lang"}], "]"}], ",", 
                    "\"\<RootFooterMainLink\>\""}], "]"}]}], "}"}], "]"}]}], 
                    ",", 
                    RowBox[{"True", "\[Rule]", 
                    RowBox[{"RowBox", "[", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"Cell", "[", 
                    RowBox[{"BoxData", "[", 
                    RowBox[{"GraphicsBox", "[", 
                    RowBox[{
                    RowBox[{"RasterBox", "[", 
                    RowBox[{
                    RowBox[{
                    "CompressedData", "[", 
                    "\"\<\\n1:eJy1k91L02EUx3/\
QH9BdEXTTC3RXEkheRF115QyaxShhkYUUNKVpbzRibYR2\\\
n4YyGL6FLNys104vlbKslyipMyQwraS0IwXLZ1ib9tvnT/T5tOpxOvdDoPJyH\\ncx7O+\
Z6X55xthSXKwg2CIGxJ8MYEJ2XWQvJ/ozWlsQ6SpeisGJ354Y94Rz+1\\ntb2tMQcGBqO/\
gyQjZ0Zf0ONh0e95MeFwBD090lRg/m21EDPBwM8HloDLKX7+\\nOhsOLSAtr02W43/\
ESKDbMVZfF3rukmKzq2HGE97fxrh0liJVJDc7knuABvOK\\\
n9aXY0UyOwC6B3QJZAsrtxKaX1jQvz6k2A4c3s3cH+7ei2En+JoYH4pmwc5Zv\\netGpUOZwaE/\
yLtiHOhttEZKYka0cnOSWBoOaEwc5p6BYQUkeZXkUZNHWCEsr\\\
ntdtouIBehU5JpZqqIipOcvM4xmNo8/GPpy1jEawGbJcxnaHdiLuaPgtPqrCW\\nUa/\
lxlFedafTCIVpLaexlA49Xje/vAS/8P0d/Y94eI07p+hrTyNPx7CbaCql\\n1cBwJ+MjjH/E95qX9+\
k00nCF9570PCTOkJN7GmrP01xMVznuu9gr6DDQcp0W\\\
nPeHJ1K8RT3ZSkugyYzqC9SKuOnpqeHobq5YmDaP9KcjFXyhO8away2m6K+mt\\\
n5bGO1qt4Bxd1bck0yQn3CR8jbj448Q0hBlcYjWW0rmX7pw39CxYT8tA=\\n               \>\
\"", "]"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"0", ",", "0"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"15", ",", "25"}], "}"}]}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"0", ",", "255"}], "}"}], ",", 
                    RowBox[{"ColorFunction", "\[Rule]", "RGBColor"}]}], "]"}],
                     ",", 
                    RowBox[{"ImageSize", "\[Rule]", 
                    RowBox[{"{", 
                    RowBox[{"15", ",", "25"}], "}"}]}], ",", 
                    RowBox[{"PlotRange", "\[Rule]", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"0", ",", "15"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"0", ",", "25"}], "}"}]}], "}"}]}]}], "]"}], 
                    "]"}], "]"}], ",", "\"\<\[ThickSpace]\>\"", ",", 
                    RowBox[{"Cell", "[", 
                    RowBox[{
                    RowBox[{"CDFLocalized", "[", 
                    RowBox[{
                    "\"\<Find Your Learning Path\[NonBreakingSpace]\
\[RightGuillemet]\>\"", ",", "lang"}], "]"}], ",", 
                    "\"\<RootFooterRedLink\>\""}], "]"}]}], "}"}], "]"}]}]}], 
                   "}"}], ",", 
                  RowBox[{"Dynamic", "[", 
                   RowBox[{"CurrentValue", "[", "\"\<MouseOver\>\"", "]"}], 
                   "]"}]}], "]"}], ",", 
                RowBox[{"BaseStyle", "\[Rule]", 
                 RowBox[{"{", 
                  RowBox[{
                  "\"\<RootFooterMainLink\>\"", ",", "\"\<Hyperlink\>\""}], 
                  "}"}]}], ",", "\[IndentingNewLine]", 
                RowBox[{"ButtonData", "\[Rule]", 
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{
                   "URL", "[", "\"\<http://www.wolfram.com/support/learn\>\"",
                     "]"}], ",", "None"}], "}"}]}], ",", 
                RowBox[{"ButtonNote", "\[Rule]", "None"}]}], "]"}], "]"}], 
             "]"}], ",", 
            RowBox[{"Cell", "[", 
             RowBox[{"BoxData", "[", 
              RowBox[{"ButtonBox", "[", 
               RowBox[{
                RowBox[{"PaneSelectorBox", "[", 
                 RowBox[{
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{"False", "\[Rule]", 
                    RowBox[{"RowBox", "[", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"Cell", "[", 
                    RowBox[{"BoxData", "[", 
                    RowBox[{"ToBoxes", "[", "HowToFootIcon", "]"}], "]"}], 
                    "]"}], ",", "\"\<\[ThickSpace]\>\"", ",", 
                    RowBox[{"Cell", "[", 
                    RowBox[{
                    RowBox[{"CDFLocalized", "[", 
                    RowBox[{
                    "\"\<'How to' \
Topics\[NonBreakingSpace]\[RightGuillemet]\>\"", ",", "lang"}], "]"}], ",", 
                    "\"\<RootFooterMainLink\>\""}], "]"}]}], "}"}], "]"}]}], 
                    ",", 
                    RowBox[{"True", "\[Rule]", 
                    RowBox[{"RowBox", "[", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"Cell", "[", 
                    RowBox[{"BoxData", "[", 
                    RowBox[{"ToBoxes", "[", "HowToFootIcon", "]"}], "]"}], 
                    "]"}], ",", "\"\<\[ThickSpace]\>\"", ",", 
                    RowBox[{"Cell", "[", 
                    RowBox[{
                    RowBox[{"CDFLocalized", "[", 
                    RowBox[{
                    "\"\<'How to' \
Topics\[NonBreakingSpace]\[RightGuillemet]\>\"", ",", "lang"}], "]"}], ",", 
                    "\"\<RootFooterRedLink\>\""}], "]"}]}], "}"}], "]"}]}]}], 
                   "}"}], ",", 
                  RowBox[{"Dynamic", "[", 
                   RowBox[{"CurrentValue", "[", "\"\<MouseOver\>\"", "]"}], 
                   "]"}]}], "]"}], ",", 
                RowBox[{"BaseStyle", "\[Rule]", 
                 RowBox[{"{", 
                  RowBox[{
                  "\"\<RootFooterMainLink\>\"", ",", "\"\<Hyperlink\>\""}], 
                  "}"}]}], ",", 
                RowBox[{
                "ButtonData", "\[Rule]", "\"\<paclet:guide/HowToTopics\>\""}],
                 ",", 
                RowBox[{"ButtonNote", "\[Rule]", "None"}], ",", 
                RowBox[{"Evaluator", "\[Rule]", "Automatic"}]}], "]"}], "]"}],
              "]"}]}], "}"}], "}"}], "]"}], "]"}], ",", 
       "\"\<RootHeaderGrid\>\""}], "]"}]}], "]"}]}], ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.512567228250004*^9, 3.512567260889347*^9}, {
  3.512567401492041*^9, 3.512567413501751*^9}, {3.512567449858144*^9, 
  3.512567478469162*^9}, {3.512567611462324*^9, 3.512567625315939*^9}, {
  3.512568005530452*^9, 3.51256803012232*^9}, {3.512568099266314*^9, 
  3.512568102166376*^9}, {3.51256815931579*^9, 3.51256816553124*^9}, {
  3.512568889081471*^9, 3.512568892437097*^9}, {3.512568962507601*^9, 
  3.512568965501463*^9}, {3.512569019590982*^9, 3.5125690315733557`*^9}, {
  3.51257188817169*^9, 3.5125718917078*^9}, {3.520600403690977*^9, 
  3.520600422693913*^9}, {3.520600591218349*^9, 3.5206006526191187`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"ConvertNBToCDFMathematicaGuide", "[", 
   RowBox[{"inputNB_", ",", " ", "outputCDFdir_", ",", " ", "lang_"}], "]"}], 
  ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
     "nb", ",", "nbexprtemp", ",", "nbexpr", ",", " ", "linktrailexpr", ",", 
      "urimetadata", ",", " ", "bob", ",", " ", "langext"}], "}"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"nb", "=", 
      RowBox[{"NotebookOpen", "[", "inputNB", "]"}]}], ";", "\n", 
     RowBox[{"nbexprtemp", "=", 
      RowBox[{"NotebookGet", "[", "nb", "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"NotebookClose", "[", "nb", "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{"Export", "[", 
      RowBox[{"\"\</tmp/test.nb\>\"", ",", "nbexprtemp", ",", "\"\<NB\>\""}], 
      "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{"nbexpr", "=", 
      RowBox[{"Get", "[", "\"\</tmp/test.nb\>\"", "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"DeleteFile", "[", "\"\</tmp/test.nb\>\"", "]"}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"langext", "=", 
      RowBox[{"Switch", "[", 
       RowBox[{
       "lang", ",", "\"\<English\>\"", ",", " ", "\"\<.en\>\"", ",", " ", 
        "\"\<Japanese\>\"", ",", "\"\<.ja\>\"", ",", " ", 
        "\"\<ChineseSimplified\>\"", ",", " ", "\"\<.zh\>\"", ",", " ", "_", 
        ",", " ", "\"\<.en\>\""}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"urimetadata", "=", 
      RowBox[{
       RowBox[{"Cases", "[", 
        RowBox[{"nbexpr", ",", 
         RowBox[{
          RowBox[{"Rule", "[", 
           RowBox[{"\"\<uri\>\"", ",", "a_"}], "]"}], "\[RuleDelayed]", "a"}],
          ",", "Infinity"}], "]"}], "[", 
       RowBox[{"[", "1", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"bob", "=", 
      RowBox[{"Delete", "[", 
       RowBox[{"nbexpr", ",", 
        RowBox[{"{", 
         RowBox[{"1", ",", "1"}], "}"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"bob", "=", 
      RowBox[{"Insert", "[", 
       RowBox[{"bob", ",", 
        RowBox[{"mainguidesearch", "[", "lang", "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"1", ",", "2"}], "}"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"bob", "=", 
      RowBox[{"Insert", "[", 
       RowBox[{"bob", ",", 
        RowBox[{"mainguidedescriptioncell", "[", "lang", "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"1", ",", "1"}], "}"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"bob", "=", 
      RowBox[{"Insert", "[", 
       RowBox[{"bob", ",", " ", 
        RowBox[{"mainguideheader", "[", "lang", "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"1", ",", "1"}], "}"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"bob", "=", 
      RowBox[{"bob", "/.", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Cell", "[", 
          RowBox[{"_", ",", "\"\<RootHeaderGrid\>\""}], "]"}], 
         "\[RuleDelayed]", 
         RowBox[{"headergrid", "[", "lang", "]"}]}], "}"}]}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"bob", "=", 
      RowBox[{"bob", "/.", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Cell", "[", 
          RowBox[{
          "\"\<Add\[Hyphen]Ons and Packages\[NonBreakingSpace]\
\[RightGuillemet]\>\"", ",", "a___"}], "]"}], ":>", 
         RowBox[{"Cell", "[", 
          RowBox[{
          "\"\<Legacy Documentation\[NonBreakingSpace]\[RightGuillemet]\>\"", 
           ",", "a"}], "]"}]}], "}"}]}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"bob", "=", 
      RowBox[{"bob", "/.", 
       RowBox[{
        RowBox[{"Rule", "[", 
         RowBox[{"ButtonData", ",", "b_String"}], "]"}], "\[RuleDelayed]", 
        RowBox[{"Rule", "[", 
         RowBox[{"ButtonData", ",", 
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{"StringFreeQ", "[", 
             RowBox[{"b", ",", 
              RowBox[{"\"\<http\>\"", "~~", "___"}]}], "]"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"URL", "[", 
               RowBox[{"\"\<http://reference.wolfram.com/mathematica/\>\"", "<>", 
                RowBox[{"StringReplace", "[", 
                 RowBox[{"b", ",", 
                  RowBox[{"\"\<paclet:\>\"", "\[Rule]", "\"\<\>\""}]}], "]"}],
                 "<>", "\"\<.cdf\>\""}], "]"}], ",", "None"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"URL", "[", "b", "]"}], ",", "None"}], "}"}]}], "]"}]}],
          "]"}]}]}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"bob", "=", 
      RowBox[{"bob", "/.", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Rule", "[", 
          RowBox[{"BaseStyle", ",", 
           RowBox[{"b_String", "/;", 
            RowBox[{"StringMatchQ", "[", 
             RowBox[{"b", ",", "\"\<RootLink\>\""}], "]"}]}]}], "]"}], 
         "\[RuleDelayed]", 
         RowBox[{"Rule", "[", 
          RowBox[{"BaseStyle", ",", 
           RowBox[{"StringReplace", "[", 
            RowBox[{"b", ",", 
             RowBox[{"{", 
              RowBox[{
              "\"\<RootLink\>\"", "\[Rule]", "\"\<RootFooterHyperlink\>\""}], 
              "}"}]}], "]"}]}], "]"}]}], "}"}]}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"bob", "=", 
      RowBox[{"bob", "/.", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Rule", "[", 
          RowBox[{"BaseStyle", ",", 
           RowBox[{"b_String", "/;", 
            RowBox[{"StringMatchQ", "[", 
             RowBox[{"b", ",", "\"\<RootFooterLink\>\""}], "]"}]}]}], "]"}], 
         "\[RuleDelayed]", 
         RowBox[{"Rule", "[", 
          RowBox[{"BaseStyle", ",", 
           RowBox[{"StringReplace", "[", 
            RowBox[{"b", ",", 
             RowBox[{"{", 
              RowBox[{
              "\"\<RootFooterLink\>\"", "\[Rule]", 
               "\"\<RootFooterHyperlink\>\""}], "}"}]}], "]"}]}], "]"}]}], 
        "}"}]}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"bob", "=", 
      RowBox[{"bob", "/.", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Rule", "[", 
          RowBox[{"BaseStyle", ",", 
           RowBox[{"b_String", "/;", 
            RowBox[{"StringMatchQ", "[", 
             RowBox[{"b", ",", "\"\<RootNewInLink\>\""}], "]"}]}]}], "]"}], 
         "\[RuleDelayed]", 
         RowBox[{"Rule", "[", 
          RowBox[{"BaseStyle", ",", 
           RowBox[{"StringReplace", "[", 
            RowBox[{"b", ",", 
             RowBox[{"{", 
              RowBox[{
              "\"\<RootNewInLink\>\"", "\[Rule]", 
               "\"\<RootFooterHyperlink\>\""}], "}"}]}], "]"}]}], "]"}]}], 
        "}"}]}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"bob", "=", 
      RowBox[{"bob", "/.", 
       RowBox[{
        RowBox[{"Rule", "[", 
         RowBox[{"Background", ",", 
          RowBox[{"GrayLevel", "[", "0.96", "]"}]}], "]"}], "\[RuleDelayed]", 
        
        RowBox[{"Rule", "[", 
         RowBox[{"Background", ",", "None"}], "]"}]}]}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"bob", "=", 
      RowBox[{"bob", "/.", 
       RowBox[{
        RowBox[{"Cell", "[", 
         RowBox[{"a___", ",", "\"\<RootSearch\>\"", ",", "b___"}], "]"}], 
        "\[RuleDelayed]", 
        RowBox[{"Cell", "[", 
         RowBox[{"a", ",", "\"\<RootSearch\>\"", ",", "b", ",", 
          RowBox[{"GridBoxOptions", "\[Rule]", 
           RowBox[{"{", 
            RowBox[{"GridBoxDividers", "\[Rule]", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"\"\<Columns\>\"", "\[Rule]", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"GrayLevel", "[", "1", "]"}], ",", 
                  RowBox[{"{", "None", "}"}], ",", 
                  RowBox[{"GrayLevel", "[", "1", "]"}]}], "}"}]}], ",", 
               RowBox[{"\"\<Rows\>\"", "\[Rule]", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"{", "None", "}"}], ",", 
                  RowBox[{"GrayLevel", "[", "1", "]"}]}], "}"}]}]}], "}"}]}], 
            "}"}]}]}], "]"}]}]}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"bob", "=", 
      RowBox[{"bob", "/.", 
       RowBox[{
        RowBox[{"Cell", "[", 
         RowBox[{"a___", ",", "\"\<RootFooter\>\"", ",", "b___"}], "]"}], 
        "\[RuleDelayed]", 
        RowBox[{"Cell", "[", 
         RowBox[{"a", ",", "\"\<RootFooter\>\"", ",", "b", ",", 
          RowBox[{"GridBoxOptions", "\[Rule]", 
           RowBox[{"{", 
            RowBox[{"GridBoxDividers", "\[Rule]", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"\"\<Columns\>\"", "\[Rule]", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"GrayLevel", "[", "1", "]"}], ",", 
                  RowBox[{"{", "None", "}"}], ",", 
                  RowBox[{"GrayLevel", "[", "1", "]"}]}], "}"}]}], ",", 
               RowBox[{"\"\<Rows\>\"", "\[Rule]", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"{", "None", "}"}], ",", 
                  RowBox[{"GrayLevel", "[", "1", "]"}]}], "}"}]}]}], "}"}]}], 
            "}"}]}]}], "]"}]}]}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"bob", "=", 
      RowBox[{"bob", "/.", 
       RowBox[{
        RowBox[{"Cell", "[", 
         RowBox[{"a___", ",", "\"\<RootHeader\>\"", ",", "b___"}], "]"}], 
        "\[RuleDelayed]", 
        RowBox[{"Cell", "[", 
         RowBox[{"a", ",", "\"\<RootHeader\>\"", ",", "b", ",", 
          RowBox[{"GridBoxOptions", "\[Rule]", 
           RowBox[{"{", 
            RowBox[{"GridBoxDividers", "\[Rule]", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"\"\<Columns\>\"", "\[Rule]", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"GrayLevel", "[", "1", "]"}], ",", 
                  RowBox[{"{", "None", "}"}], ",", 
                  RowBox[{"GrayLevel", "[", "1", "]"}]}], "}"}]}], ",", 
               RowBox[{"\"\<Rows\>\"", "\[Rule]", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"{", "None", "}"}], ",", "None"}], "}"}]}]}], 
              "}"}]}], "}"}]}]}], "]"}]}]}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"bob", "=", 
      RowBox[{"bob", "/.", 
       RowBox[{
        RowBox[{"Cell", "[", 
         RowBox[{"a___", ",", "\"\<RootSection\>\"", ",", "b___"}], "]"}], 
        "\[RuleDelayed]", 
        RowBox[{"Cell", "[", 
         RowBox[{"a", ",", "\"\<RootSection\>\"", ",", "b", ",", 
          RowBox[{"GridBoxOptions", "\[Rule]", 
           RowBox[{"{", 
            RowBox[{"GridBoxDividers", "\[Rule]", 
             RowBox[{"{", 
              RowBox[{"\"\<Columns\>\"", "\[Rule]", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"GrayLevel", "[", "1", "]"}], ",", 
                 RowBox[{"{", "None", "}"}], ",", 
                 RowBox[{"GrayLevel", "[", "1", "]"}]}], "}"}]}], "}"}]}], 
            "}"}]}]}], "]"}]}]}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"bob", "=", 
      RowBox[{"bob", "/.", 
       RowBox[{
        RowBox[{"Cell", "[", 
         RowBox[{"a___", ",", "\"\<RootCell\>\"", ",", "b___"}], "]"}], 
        "\[RuleDelayed]", 
        RowBox[{"Cell", "[", 
         RowBox[{"a", ",", "\"\<RootCell\>\"", ",", "b", ",", 
          RowBox[{"GridBoxOptions", "\[Rule]", 
           RowBox[{"{", 
            RowBox[{"GridBoxDividers", "\[Rule]", 
             RowBox[{"{", 
              RowBox[{"\"\<Columns\>\"", "\[Rule]", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"GrayLevel", "[", "1", "]"}], ",", 
                 RowBox[{"{", "None", "}"}], ",", 
                 RowBox[{"GrayLevel", "[", "1", "]"}]}], "}"}]}], "}"}]}], 
            "}"}]}]}], "]"}]}]}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"bob", "=", 
      RowBox[{"bob", "/.", 
       RowBox[{
        RowBox[{"Cell", "[", 
         RowBox[{"a___", ",", "\"\<RootLinks\>\"", ",", "b___"}], "]"}], 
        "\[RuleDelayed]", 
        RowBox[{"Cell", "[", 
         RowBox[{"a", ",", "\"\<RootLinks\>\"", ",", "b", ",", 
          RowBox[{"GridBoxOptions", "\[Rule]", 
           RowBox[{"{", 
            RowBox[{"GridBoxDividers", "\[Rule]", 
             RowBox[{"{", 
              RowBox[{"\"\<Columns\>\"", "\[Rule]", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"GrayLevel", "[", "1", "]"}], ",", 
                 RowBox[{"{", "None", "}"}], ",", 
                 RowBox[{"GrayLevel", "[", "1", "]"}]}], "}"}]}], "}"}]}], 
            "}"}]}]}], "]"}]}]}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"bob", "=", 
      RowBox[{"bob", "/.", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{
         "URL", "[", 
          "\"\<http://reference.wolfram.com/mathematica/guide/InstalledAddOns.\
cdf\>\"", "]"}], ":>", 
         RowBox[{
         "URL", "[", "\"\<http://reference.wolfram.com/legacy/\>\"", "]"}]}], 
        "}"}]}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"bob", "=", 
      RowBox[{"bob", "/.", 
       RowBox[{"Map", "[", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{"cell", ":", "#"}], ")"}], "\[RuleDelayed]", 
           RowBox[{"(", 
            RowBox[{"cell", "/.", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"ButtonBox", "[", 
                RowBox[{"label_", ",", "b___", ",", 
                 RowBox[{"Rule", "[", 
                  RowBox[{"ButtonData", ",", " ", 
                   RowBox[{"{", 
                    RowBox[{
                    RowBox[{"URL", "[", "c_String", "]"}], ",", "None"}], 
                    "}"}]}], "]"}], ",", "d___"}], "]"}], "\[RuleDelayed]", 
               RowBox[{"(", "\[IndentingNewLine]", 
                RowBox[{"ButtonBox", "[", 
                 RowBox[{"label", ",", "b", ",", 
                  RowBox[{"Rule", "[", 
                   RowBox[{"ButtonData", ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"URL", "[", "c", "]"}], ",", "None"}], "}"}]}], 
                   "]"}], ",", 
                  RowBox[{"ButtonNote", "\[Rule]", "c"}], ",", "d"}], "]"}], 
                ")"}]}], "}"}]}], ")"}]}], "&"}], ",", 
         RowBox[{"Cases", "[", 
          RowBox[{"bob", ",", 
           RowBox[{
            RowBox[{"Cell", "[", 
             RowBox[{"contents_", ",", "rest___"}], "]"}], "/;", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"MemberQ", "[", 
               RowBox[{"contents", ",", 
                RowBox[{"ButtonBox", "[", "___", "]"}], ",", "Infinity"}], 
               "]"}], "&&", 
              RowBox[{"!", 
               RowBox[{"MemberQ", "[", 
                RowBox[{
                 RowBox[{"{", "rest", "}"}], ",", 
                 RowBox[{
                 "\"\<Input\>\"", "|", "\"\<Output\>\"", "|", "\"\<MSG\>\"", 
                  "|", "\"\<Message\>\"", "|", "\"\<Print\>\"", "|", 
                  "\"\<PrintUsage\>\"", "|", "\"\<ConversionLockdown\>\""}], 
                 ",", "Infinity"}], "]"}]}], "&&", 
              RowBox[{"!", 
               RowBox[{"MemberQ", "[", 
                RowBox[{
                 RowBox[{"{", "contents", "}"}], ",", 
                 RowBox[{"Cell", "[", 
                  RowBox[{"___", ",", 
                   RowBox[{
                   "\"\<Input\>\"", "|", "\"\<Output\>\"", "|", "\"\<MSG\>\"",
                     "|", "\"\<Message\>\"", "|", "\"\<Print\>\"", "|", 
                    "\"\<PrintUsage\>\"", "|", "\"\<ConversionLockdown\>\""}],
                    ",", "___"}], "]"}], ",", "Infinity"}], "]"}]}], "&&", 
              RowBox[{"!", 
               RowBox[{"MemberQ", "[", 
                RowBox[{
                 RowBox[{"{", "contents", "}"}], ",", 
                 RowBox[{"Rule", "[", 
                  RowBox[{"Appearance", ",", 
                   RowBox[{
                   "\"\<DialogBox\>\"", "|", "\"\<DefaultButton\>\""}]}], 
                  "]"}], ",", "Infinity"}], "]"}]}], "&&", 
              "\[IndentingNewLine]", 
              RowBox[{"!", 
               RowBox[{"MemberQ", "[", 
                RowBox[{
                 RowBox[{"{", 
                  RowBox[{"contents", ",", "rest"}], "}"}], ",", 
                 RowBox[{"Rule", "[", 
                  RowBox[{"CellID", ",", 
                   RowBox[{"1653826644", "|", "1475850354"}]}], "]"}], ",", 
                 "Infinity"}], "]"}]}]}], ")"}]}], ",", "Infinity"}], "]"}]}],
         "]"}]}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"bob", "=", 
      RowBox[{"bob", "/.", 
       RowBox[{
        RowBox[{"Notebook", "[", "a___", "]"}], "\[Rule]", 
        RowBox[{"Notebook", "[", 
         RowBox[{"a", ",", 
          RowBox[{"DockedCells", "\[Rule]", 
           RowBox[{"Dynamic", "[", 
            RowBox[{"FEPrivate`If", "[", 
             RowBox[{
              RowBox[{"FEPrivate`SameQ", "[", 
               RowBox[{
                RowBox[{"FrontEnd`CurrentValue", "[", 
                 RowBox[{
                  RowBox[{"FrontEnd`InputNotebook", "[", "]"}], ",", 
                  RowBox[{"{", 
                   RowBox[{"TaggingRules", ",", "\"\<showdockedcell\>\""}], 
                   "}"}]}], "]"}], ",", "True"}], "]"}], ",", 
              RowBox[{"FEPrivate`FrontEndResource", "[", 
               RowBox[{
               "\"\<FEExpressions\>\"", ",", "\"\<PluginToolbar\>\""}], "]"}],
               ",", " ", 
              RowBox[{"{", "}"}]}], "]"}], "]"}]}], ",", 
          RowBox[{"StyleDefinitions", "\[Rule]", 
           RowBox[{"styledefs", "[", "lang", "]"}]}], ",", 
          RowBox[{"WindowElements", "\[Rule]", "\"\<VerticalScrollBar\>\""}], 
          ",", " ", 
          RowBox[{"ScrollingOptions", "\[Rule]", 
           RowBox[{"{", 
            RowBox[{"\"\<HorizontalScrollRange\>\"", "\[Rule]", "0"}], 
            "}"}]}], ",", 
          RowBox[{"PrivateNotebookOptions", "\[Rule]", 
           RowBox[{"{", 
            RowBox[{"\"\<PluginToolbarEnabled\>\"", "\[Rule]", "False"}], 
            "}"}]}], ",", 
          RowBox[{"PageWidth", "\[Rule]", "800"}], ",", 
          RowBox[{"CellBracketOptions", "\[Rule]", 
           RowBox[{"{", 
            RowBox[{"\"\<Margins\>\"", "\[Rule]", 
             RowBox[{"{", 
              RowBox[{"0", ",", 
               RowBox[{"Dynamic", "[", 
                RowBox[{"FEPrivate`If", "[", 
                 RowBox[{
                  RowBox[{"FEPrivate`Less", "[", 
                   RowBox[{
                    RowBox[{"FrontEnd`AbsoluteCurrentValue", "[", 
                    RowBox[{"{", 
                    RowBox[{"WindowSize", ",", "1"}], "}"}], "]"}], ",", 
                    "800"}], "]"}], ",", "2", ",", 
                  RowBox[{
                   RowBox[{"FrontEnd`AbsoluteCurrentValue", "[", 
                    RowBox[{"{", 
                    RowBox[{"WindowSize", ",", "1"}], "}"}], "]"}], "-", 
                   "800"}]}], "]"}], "]"}]}], "}"}]}], "}"}]}]}], "]"}]}]}]}],
      ";", "\[IndentingNewLine]", 
     RowBox[{"bob", "=", 
      RowBox[{"bob", "/.", 
       RowBox[{
        RowBox[{"Rule", "[", 
         RowBox[{"TaggingRules", ",", 
          RowBox[{"{", "a___", "}"}]}], "]"}], ":>", 
        RowBox[{"Rule", "[", 
         RowBox[{"TaggingRules", ",", 
          RowBox[{"{", 
           RowBox[{"a", ",", 
            RowBox[{"\"\<showdockedcell\>\"", "\[Rule]", "False"}]}], "}"}]}],
          "]"}]}]}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"bob", "=", 
      RowBox[{"Append", "[", 
       RowBox[{"bob", ",", 
        RowBox[{"NotebookEventActions", "->", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"\"\<MenuCommand\>\"", ",", "\"\<FindExpression\>\""}], 
            "}"}], "\[RuleDelayed]", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"CurrentValue", "[", 
               RowBox[{
                RowBox[{"InputNotebook", "[", "]"}], ",", 
                RowBox[{"{", 
                 RowBox[{"TaggingRules", ",", "\"\<showdockedcell\>\""}], 
                 "}"}]}], "]"}], "=", 
              RowBox[{"!", 
               RowBox[{"(", 
                RowBox[{"CurrentValue", "[", 
                 RowBox[{
                  RowBox[{"InputNotebook", "[", "]"}], ",", 
                  RowBox[{"{", 
                   RowBox[{"TaggingRules", ",", "\"\<showdockedcell\>\""}], 
                   "}"}]}], "]"}], ")"}]}]}], ";", 
             RowBox[{"MathLink`CallFrontEnd", "[", 
              RowBox[{"FrontEnd`BoxReferenceFind", "[", 
               RowBox[{
                RowBox[{"FE`BoxReference", "[", 
                 RowBox[{
                  RowBox[{"InputNotebook", "[", "]"}], ",", 
                  RowBox[{"{", 
                   RowBox[{"{", "\"\<PluginToolbarSearchField\>\"", "}"}], 
                   "}"}], ",", 
                  RowBox[{"FE`BoxOffset", "\[Rule]", 
                   RowBox[{"{", 
                    RowBox[{"FE`BoxChild", "[", "1", "]"}], "}"}]}]}], "]"}], 
                ",", 
                RowBox[{
                "FE`SearchStart", "\[Rule]", 
                 "\"\<StartFromFirstDockedCell\>\""}]}], "]"}], "]"}]}], 
            ")"}]}], "}"}]}]}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"bob", "=", 
      RowBox[{"Insert", "[", 
       RowBox[{"bob", ",", " ", 
        RowBox[{"blackheadercell", "[", "lang", "]"}], ",", " ", 
        RowBox[{"{", 
         RowBox[{"1", ",", "1"}], "}"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"bob", "=", 
      RowBox[{"Insert", "[", 
       RowBox[{"bob", ",", " ", 
        RowBox[{"mainguidefootercell", "[", 
         RowBox[{"urimetadata", ",", "lang"}], "]"}], ",", " ", 
        RowBox[{"{", 
         RowBox[{"1", ",", " ", 
          RowBox[{"-", "2"}]}], "}"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
     
     RowBox[{"CreateDirectory", "[", 
      RowBox[{"DirectoryName", "[", 
       RowBox[{"outputCDFdir", "<>", "urimetadata", "<>", "\"\<.cdf\>\""}], 
       "]"}], "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{"Export", "[", 
      RowBox[{
       RowBox[{
       "outputCDFdir", "<>", "urimetadata", "<>", "langext", "<>", 
        "\"\<.cdf\>\""}], ",", "bob", ",", "\"\<CDF\>\""}], "]"}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"(*", 
      RowBox[{"Export", "[", 
       RowBox[{
        RowBox[{"\"\</tmp/mathematica/ref/\>\"", "<>", 
         RowBox[{"FileBaseName", "[", 
          RowBox[{"fns", "[", 
           RowBox[{"[", "i", "]"}], "]"}], "]"}], "<>", "\"\<.nb\>\""}], ",", 
        "bob", ",", "\"\<NB\>\""}], "]"}], "*)"}], "\[IndentingNewLine]", 
     RowBox[{"NotebookSign`PlayerProSecure", "[", 
      RowBox[{
      "outputCDFdir", "<>", "urimetadata", "<>", "langext", "<>", 
       "\"\<.cdf\>\""}], "]"}]}]}], "]"}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.508070826871502*^9, 3.5080708282018633`*^9}, {
   3.50807098469381*^9, 3.508071025898211*^9}, {3.5080740970801973`*^9, 
   3.508074100888381*^9}, {3.5080741738929873`*^9, 3.508074196842502*^9}, {
   3.508074261434032*^9, 3.508074269415628*^9}, {3.508074911562907*^9, 
   3.5080749124508753`*^9}, {3.508075155484838*^9, 3.508075159829122*^9}, 
   3.508588135442083*^9, 3.508588232060596*^9, {3.508589414389152*^9, 
   3.5085894146116543`*^9}, {3.508593494581781*^9, 3.508593534187914*^9}, {
   3.508593675597851*^9, 3.5085937947288227`*^9}, 3.508593852876461*^9, {
   3.508595915093731*^9, 3.508595982796049*^9}, 3.508596103671444*^9, {
   3.508596252258738*^9, 3.508596265689382*^9}, {3.508596302865732*^9, 
   3.508596338912752*^9}, {3.508596375996743*^9, 3.508596380562315*^9}, 
   3.5085964413292093`*^9, {3.5085964870270042`*^9, 3.508596487356316*^9}, {
   3.508596522733943*^9, 3.508596528179408*^9}, 3.508596560057311*^9, {
   3.5085969322140713`*^9, 3.508596966151431*^9}, 3.508596999214734*^9, {
   3.508597101473096*^9, 3.5085971631409388`*^9}, {3.508597198864313*^9, 
   3.508597213654977*^9}, {3.508597358836434*^9, 3.5085973732527637`*^9}, {
   3.508597685229528*^9, 3.508597693442877*^9}, {3.5086011890179996`*^9, 
   3.508601200220957*^9}, {3.508602616075048*^9, 3.508602624970497*^9}, {
   3.5086026676143417`*^9, 3.5086027258057833`*^9}, {3.508678354096799*^9, 
   3.508678412325329*^9}, {3.508678446367002*^9, 3.508678478659257*^9}, {
   3.508678571404517*^9, 3.508678589468144*^9}, {3.508678656828698*^9, 
   3.50867868947614*^9}, 3.508679434238147*^9, {3.5086972901758347`*^9, 
   3.5086972914693117`*^9}, {3.508759867482954*^9, 3.50875987458852*^9}, {
   3.508759913412125*^9, 3.5087599145086107`*^9}, {3.5087599797142143`*^9, 
   3.5087599801621943`*^9}, {3.508760626229103*^9, 3.508760630486541*^9}, {
   3.5087606778773403`*^9, 3.508760699717183*^9}, {3.508760754364643*^9, 
   3.508760762140029*^9}, {3.5087612995631933`*^9, 3.508761302617775*^9}, {
   3.508761834855218*^9, 3.508761868171669*^9}, {3.508761899926964*^9, 
   3.508761912612585*^9}, {3.5087620279543333`*^9, 3.5087620374138927`*^9}, {
   3.508762079284809*^9, 3.5087620874514933`*^9}, {3.508763821625393*^9, 
   3.508763833570747*^9}, {3.5087644959073668`*^9, 3.5087645868587523`*^9}, {
   3.508765245832066*^9, 3.5087652461506987`*^9}, {3.508765290548779*^9, 
   3.508765292500285*^9}, {3.508765389126528*^9, 3.5087653992289133`*^9}, {
   3.5087654837480583`*^9, 3.508765506902656*^9}, {3.508766215759344*^9, 
   3.508766221894505*^9}, {3.5087662926262693`*^9, 3.508766300162915*^9}, 
   3.508766399904499*^9, {3.5087665316624403`*^9, 3.50876653515102*^9}, {
   3.5091230667373657`*^9, 3.50912311227678*^9}, {3.509123231244851*^9, 
   3.509123237582858*^9}, {3.5091235297231407`*^9, 3.5091235444494762`*^9}, 
   3.509125182638022*^9, {3.509125268707711*^9, 3.5091252696019087`*^9}, {
   3.509125415853553*^9, 3.509125416538525*^9}, {3.509127553851531*^9, 
   3.509127554619492*^9}, {3.5091280742499123`*^9, 3.509128121810918*^9}, {
   3.509128209890005*^9, 3.509128227321157*^9}, {3.509128290384459*^9, 
   3.509128290727098*^9}, {3.50912834227577*^9, 3.509128350794723*^9}, {
   3.509128399264235*^9, 3.509128399949739*^9}, {3.509128571974666*^9, 
   3.509128640978799*^9}, {3.509128794347818*^9, 3.509128824734899*^9}, 
   3.509128866474682*^9, {3.5091290279753532`*^9, 3.509129028245089*^9}, {
   3.509129144667532*^9, 3.509129152772421*^9}, {3.509129435520856*^9, 
   3.509129436940878*^9}, 3.509187096913912*^9, {3.5091902668638*^9, 
   3.5091902717385798`*^9}, {3.509190327217113*^9, 3.509190356604814*^9}, {
   3.5110105599193907`*^9, 3.511010560285615*^9}, {3.5110106166408978`*^9, 
   3.51101062398903*^9}, {3.511029674852326*^9, 3.511029688463814*^9}, 
   3.511031636381299*^9, {3.511032087417955*^9, 3.511032118237255*^9}, 
   3.511032201413834*^9, {3.51103231429648*^9, 3.511032321355534*^9}, {
   3.511117384981182*^9, 3.511117396812982*^9}, {3.5111177438015127`*^9, 
   3.511117746566491*^9}, {3.511175474355365*^9, 3.511175484993688*^9}, 
   3.511175526819906*^9, {3.511186106276402*^9, 3.5111861720618677`*^9}, {
   3.511186671770754*^9, 3.511186723736184*^9}, {3.5125656544012623`*^9, 
   3.512565667857543*^9}, {3.512566602382492*^9, 3.5125666521888514`*^9}, {
   3.5125668265400743`*^9, 3.512566906009639*^9}, {3.512567533713852*^9, 
   3.512567557617566*^9}, {3.512567819522235*^9, 3.512567835719103*^9}, {
   3.51256936851156*^9, 3.512569374758881*^9}, {3.51256957042822*^9, 
   3.5125695958219767`*^9}, {3.512569771340658*^9, 3.512569815440764*^9}, {
   3.512570045048975*^9, 3.5125701021814413`*^9}, {3.512570183363718*^9, 
   3.5125702137709007`*^9}, {3.512570276862157*^9, 3.512570315131722*^9}, 
   3.5125704961494617`*^9, 3.512570935324271*^9, {3.512571522011682*^9, 
   3.512571534666526*^9}, {3.512572479786737*^9, 3.512572489787694*^9}, {
   3.5125766520307903`*^9, 3.512576683244801*^9}, {3.512576737543131*^9, 
   3.512576784603516*^9}, {3.512576865171321*^9, 3.512576894146904*^9}, 
   3.5125784927309923`*^9, {3.51308503700429*^9, 3.513085045209197*^9}, {
   3.513085087951758*^9, 3.51308509056087*^9}, {3.513611489849887*^9, 
   3.513611523197657*^9}, 3.5136116245292883`*^9, {3.5179218115238543`*^9, 
   3.5179218144504013`*^9}, {3.519734160851468*^9, 3.519734168265582*^9}, {
   3.519734437567037*^9, 3.519734453783188*^9}, {3.519734490159739*^9, 
   3.519734568009667*^9}, {3.519735152391739*^9, 3.5197351530720587`*^9}, {
   3.520181852391008*^9, 3.520181858101219*^9}, 3.5201822376252413`*^9, {
   3.5201825168201923`*^9, 3.520182529378067*^9}, {3.5201826997077503`*^9, 
   3.5201827321910467`*^9}, {3.520182785293586*^9, 3.5201828541408577`*^9}, 
   3.520182925080224*^9, {3.520272723457765*^9, 3.520272725313623*^9}, {
   3.520356130660975*^9, 3.520356132122737*^9}, {3.520599432618195*^9, 
   3.5205994674214153`*^9}, {3.5206002438888893`*^9, 3.520600259119523*^9}, {
   3.520600686667835*^9, 3.520600696897933*^9}, {3.5209444021874*^9, 
   3.520944405049364*^9}, {3.521220673399604*^9, 3.5212206752913847`*^9}, {
   3.521558270134912*^9, 3.521558270571793*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["ConvertNBToCDF", "Section",
 InitializationCell->True,
 CellChangeTimes->{{3.5091275056467133`*^9, 3.509127508652862*^9}, 
   3.509128105017721*^9, {3.509198237707512*^9, 3.509198239649578*^9}, {
   3.514721741770131*^9, 3.514721783538807*^9}, {3.519053931668655*^9, 
   3.5190539351173897`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"ConvertNBToCDF", "[", 
    RowBox[{"inputNB_", ",", " ", "outputCDFdir_", ",", " ", "lang_"}], "]"}],
    ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "nb", ",", "nbexprtemp", ",", "nbexpr", ",", " ", "linktrailexpr", ",", 
       "urimetadata", ",", " ", "bob", ",", "langext"}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"langext", "=", 
       RowBox[{"Switch", "[", 
        RowBox[{
        "lang", ",", "\"\<English\>\"", ",", " ", "\"\<.en\>\"", ",", " ", 
         "\"\<Japanese\>\"", ",", "\"\<.ja\>\"", ",", " ", 
         "\"\<ChineseSimplified\>\"", ",", " ", "\"\<.zh\>\"", ",", " ", "_", 
         ",", " ", "\"\<.en\>\""}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"FileBaseName", "[", "inputNB", "]"}], "===", 
         "\"\<Mathematica\>\""}], ",", "\[IndentingNewLine]", 
        RowBox[{"ConvertNBToCDFMathematicaGuide", "[", 
         RowBox[{"inputNB", ",", " ", "outputCDFdir", ",", "lang"}], "]"}], 
        ",", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"nb", "=", 
          RowBox[{"NotebookOpen", "[", "inputNB", "]"}]}], ";", "\n", 
         "          ", 
         RowBox[{"nbexprtemp", "=", 
          RowBox[{"NotebookGet", "[", "nb", "]"}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"NotebookClose", "[", "nb", "]"}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"Export", "[", 
          RowBox[{
          "\"\</tmp/test.nb\>\"", ",", "nbexprtemp", ",", "\"\<NB\>\""}], 
          "]"}], ";", "\[IndentingNewLine]", 
         RowBox[{"nbexpr", "=", 
          RowBox[{"Get", "[", "\"\</tmp/test.nb\>\"", "]"}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"DeleteFile", "[", "\"\</tmp/test.nb\>\"", "]"}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"linktrailexpr", "=", 
          RowBox[{
           RowBox[{"Cases", "[", 
            RowBox[{"nbexpr", ",", " ", 
             RowBox[{
              RowBox[{"Rule", "[", 
               RowBox[{"\"\<LinkTrails\>\"", ",", "a_"}], "]"}], 
              "\[RuleDelayed]", 
              RowBox[{"Cell", "[", 
               RowBox[{
                RowBox[{"BoxData", "[", "a", "]"}], ",", 
                "\"\<LinkTrail\>\""}], "]"}]}], ",", "Infinity"}], "]"}], "[", 
           RowBox[{"[", "1", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
         RowBox[{"urimetadata", "=", 
          RowBox[{
           RowBox[{"Cases", "[", 
            RowBox[{"nbexpr", ",", 
             RowBox[{
              RowBox[{"Rule", "[", 
               RowBox[{"\"\<uri\>\"", ",", "a_"}], "]"}], "\[RuleDelayed]", 
              "a"}], ",", "Infinity"}], "]"}], "[", 
           RowBox[{"[", "1", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
         RowBox[{"bob", "=", 
          RowBox[{"DeleteCases", "[", 
           RowBox[{"nbexpr", ",", " ", 
            RowBox[{"Cell", "[", 
             RowBox[{"\"\< \>\"", ",", " ", 
              RowBox[{
              "\"\<GuideColorBar\>\"", "|", "\"\<SymbolColorBar\>\"", "|", 
               "\"\<TutorialColorBar\>\""}]}], "]"}], ",", " ", "Infinity"}], 
           "]"}]}], ";", "\[IndentingNewLine]", 
         RowBox[{"bob", "=", 
          RowBox[{"Insert", "[", 
           RowBox[{"bob", ",", " ", 
            RowBox[{"Which", "[", 
             RowBox[{
              RowBox[{"StringMatchQ", "[", 
               RowBox[{"urimetadata", ",", 
                RowBox[{"___", "~~", "\"\<ref/\>\"", "~~", "___"}]}], "]"}], 
              ",", "symbolbar", ",", 
              RowBox[{"StringMatchQ", "[", 
               RowBox[{"urimetadata", ",", 
                RowBox[{"___", "~~", "\"\<tutorial/\>\"", "~~", "___"}]}], 
               "]"}], ",", "tutorialbar", ",", 
              RowBox[{"StringMatchQ", "[", 
               RowBox[{"urimetadata", ",", 
                RowBox[{"___", "~~", "\"\<guide/\>\"", "~~", "___"}]}], "]"}],
               ",", "guidebar", ",", 
              RowBox[{"StringMatchQ", "[", 
               RowBox[{"urimetadata", ",", 
                RowBox[{"___", "~~", "\"\<howto/\>\"", "~~", "___"}]}], "]"}],
               ",", "howtobar", ",", "True", ",", "symbolbar"}], "]"}], ",", 
            " ", 
            RowBox[{"{", 
             RowBox[{"1", ",", "1"}], "}"}]}], "]"}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"bob", "=", 
          RowBox[{"DeleteCases", "[", 
           RowBox[{"bob", ",", 
            RowBox[{"Rule", "[", 
             RowBox[{"\"\<LinkTrails\>\"", ",", "a_"}], "]"}], ",", 
            "Infinity"}], "]"}]}], ";", "\[IndentingNewLine]", 
         RowBox[{"bob", "=", 
          RowBox[{"Insert", "[", 
           RowBox[{"bob", ",", " ", "linktrailexpr", ",", " ", 
            RowBox[{"{", 
             RowBox[{"1", ",", "1"}], "}"}]}], "]"}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"(*", 
          RowBox[{
           RowBox[{"bob", "=", 
            RowBox[{"bob", "/.", 
             RowBox[{"{", 
              RowBox[{"w_TextData", "\[Rule]", 
               RowBox[{"ConvertTextData", "[", "w", "]"}]}], "}"}]}]}], ";"}],
           "*)"}], "\[IndentingNewLine]", 
         RowBox[{"bob", "=", 
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{"BannerMessageQ", "[", "bob", "]"}], ",", 
            RowBox[{"If", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"Length", "[", 
                RowBox[{"Cases", "[", 
                 RowBox[{"bob", ",", " ", 
                  RowBox[{"Cell", "[", 
                   RowBox[{
                   "a___", ",", "\"\<ObjectNameGrid\>\"", ",", "b___"}], 
                   "]"}], ",", " ", "Infinity"}], "]"}], "]"}], ">", "0"}], 
              ",", 
              RowBox[{"bob", "/.", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"Cell", "[", 
                  RowBox[{
                  "a___", ",", "\"\<ObjectNameGrid\>\"", ",", "b___"}], "]"}],
                  ":>", 
                 RowBox[{"additionalMessageCell", "[", 
                  RowBox[{"Cell", "[", 
                   RowBox[{"a", ",", "\"\<ObjectNameGrid\>\"", ",", "b"}], 
                   "]"}], "]"}]}], "}"}]}], ",", "\[IndentingNewLine]", 
              RowBox[{"bob", "/.", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"Cell", "[", 
                  RowBox[{"a___", ",", "\"\<ObjectName\>\"", ",", "b___"}], 
                  "]"}], ":>", 
                 RowBox[{"additionalMessageCell", "[", 
                  RowBox[{"Cell", "[", 
                   RowBox[{"a", ",", "\"\<ObjectName\>\"", ",", "b"}], "]"}], 
                  "]"}]}], "}"}]}]}], "\[IndentingNewLine]", "]"}], ",", " ", 
            "bob"}], "]"}]}], ";", "\[IndentingNewLine]", 
         RowBox[{"bob", "=", 
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{"BannerMessageQ", "[", "bob", "]"}], ",", 
            RowBox[{"If", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"Length", "[", 
                RowBox[{"Cases", "[", 
                 RowBox[{"bob", ",", " ", 
                  RowBox[{"Cell", "[", 
                   RowBox[{"a___", ",", "\"\<Title\>\"", ",", "b___"}], "]"}],
                   ",", " ", "Infinity"}], "]"}], "]"}], ">", "0"}], ",", 
              RowBox[{"bob", "/.", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"Cell", "[", 
                  RowBox[{"a___", ",", "\"\<Title\>\"", ",", "b___"}], "]"}], 
                 ":>", 
                 RowBox[{"additionalMessageCell", "[", 
                  RowBox[{"Cell", "[", 
                   RowBox[{"a", ",", "\"\<Title\>\"", ",", "b"}], "]"}], 
                  "]"}]}], "}"}]}], ",", "bob"}], "\[IndentingNewLine]", 
             "]"}], ",", " ", "bob"}], "]"}]}], ";", "\[IndentingNewLine]", 
         RowBox[{"bob", "=", 
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{"BannerMessageQ", "[", "bob", "]"}], ",", 
            RowBox[{"If", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"Length", "[", 
                RowBox[{"Cases", "[", 
                 RowBox[{"bob", ",", " ", 
                  RowBox[{"Cell", "[", 
                   RowBox[{"a___", ",", "\"\<HowToTitle\>\"", ",", "b___"}], 
                   "]"}], ",", " ", "Infinity"}], "]"}], "]"}], ">", "0"}], 
              ",", 
              RowBox[{"bob", "/.", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"Cell", "[", 
                  RowBox[{"a___", ",", "\"\<HowToTitle\>\"", ",", "b___"}], 
                  "]"}], ":>", 
                 RowBox[{"additionalMessageCell", "[", 
                  RowBox[{"Cell", "[", 
                   RowBox[{"a", ",", "\"\<HowToTitle\>\"", ",", "b"}], "]"}], 
                  "]"}]}], "}"}]}], ",", "bob"}], "\[IndentingNewLine]", 
             "]"}], ",", " ", "bob"}], "]"}]}], ";", "\[IndentingNewLine]", 
         RowBox[{"bob", "=", 
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{"BannerMessageQ", "[", "bob", "]"}], ",", 
            RowBox[{"If", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"Length", "[", 
                RowBox[{"Cases", "[", 
                 RowBox[{"bob", ",", " ", 
                  RowBox[{"Cell", "[", 
                   RowBox[{
                   "a___", ",", "\"\<ObjectNameAlt\>\"", ",", "b___"}], "]"}],
                   ",", " ", "Infinity"}], "]"}], "]"}], ">", "0"}], ",", 
              RowBox[{"bob", "/.", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"Cell", "[", 
                  RowBox[{"a___", ",", "\"\<ObjectNameAlt\>\"", ",", "b___"}],
                   "]"}], ":>", 
                 RowBox[{"additionalMessageCell", "[", 
                  RowBox[{"Cell", "[", 
                   RowBox[{"a", ",", "\"\<ObjectNameAlt\>\"", ",", "b"}], 
                   "]"}], "]"}]}], "}"}]}], ",", "bob"}], 
             "\[IndentingNewLine]", "]"}], ",", " ", "bob"}], "]"}]}], ";", 
         "\n", 
         RowBox[{"bob", "=", 
          RowBox[{"bob", "/.", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{
              RowBox[{"ButtonBox", "[", 
               RowBox[{"a___", ",", " ", 
                RowBox[{"Rule", "[", 
                 RowBox[{"BaseStyle", ",", " ", "\"\<Link\>\""}], "]"}], ",", 
                "c___"}], "]"}], ":>", 
              RowBox[{"ButtonBox", "[", 
               RowBox[{"a", ",", " ", "\[IndentingNewLine]", 
                RowBox[{"Rule", "[", 
                 RowBox[{"BaseStyle", ",", " ", "\"\<Hyperlink\>\""}], "]"}], 
                ",", "c"}], "]"}]}], ",", 
             RowBox[{
              RowBox[{"ButtonBox", "[", 
               RowBox[{"a___", ",", " ", 
                RowBox[{"Rule", "[", 
                 RowBox[{"BaseStyle", ",", " ", 
                  RowBox[{"{", 
                   RowBox[{"jj___", ",", "\"\<Link\>\"", ",", "ww___"}], 
                   "}"}]}], "]"}], ",", "c___"}], "]"}], ":>", 
              RowBox[{"ButtonBox", "[", 
               RowBox[{"a", ",", " ", "\[IndentingNewLine]", 
                RowBox[{"Rule", "[", 
                 RowBox[{"BaseStyle", ",", " ", 
                  RowBox[{"{", 
                   RowBox[{"jj", ",", "\"\<Hyperlink\>\"", ",", "ww"}], 
                   "}"}]}], "]"}], ",", "c"}], "]"}]}], ",", 
             "\[IndentingNewLine]", 
             RowBox[{
              RowBox[{"ButtonBox", "[", 
               RowBox[{"a___", ",", " ", 
                RowBox[{"Rule", "[", 
                 RowBox[{"BaseStyle", ",", " ", 
                  RowBox[{"{", 
                   RowBox[{"\"\<Link\>\"", ",", "ww___"}], "}"}]}], "]"}], 
                ",", "c___"}], "]"}], ":>", 
              RowBox[{"ButtonBox", "[", 
               RowBox[{"a", ",", " ", "\[IndentingNewLine]", 
                RowBox[{"Rule", "[", 
                 RowBox[{"BaseStyle", ",", " ", 
                  RowBox[{"{", 
                   RowBox[{"\"\<Hyperlink\>\"", ",", "ww"}], "}"}]}], "]"}], 
                ",", "c"}], "]"}]}], ",", "\[IndentingNewLine]", 
             RowBox[{
              RowBox[{"ButtonBox", "[", 
               RowBox[{"a___", ",", " ", 
                RowBox[{"Rule", "[", 
                 RowBox[{"BaseStyle", ",", " ", 
                  RowBox[{"{", 
                   RowBox[{"jj___", ",", "\"\<Link\>\""}], "}"}]}], "]"}], 
                ",", "c___"}], "]"}], ":>", 
              RowBox[{"ButtonBox", "[", 
               RowBox[{"a", ",", " ", "\[IndentingNewLine]", 
                RowBox[{"Rule", "[", 
                 RowBox[{"BaseStyle", ",", " ", 
                  RowBox[{"{", 
                   RowBox[{"jj", ",", "\"\<Hyperlink\>\""}], "}"}]}], "]"}], 
                ",", "c"}], "]"}]}], ",", "\[IndentingNewLine]", 
             RowBox[{
              RowBox[{"ButtonBox", "[", 
               RowBox[{"a___", ",", " ", 
                RowBox[{"Rule", "[", 
                 RowBox[{"BaseStyle", ",", " ", 
                  RowBox[{"{", 
                   RowBox[{"jj___", ",", "\"\<Link\>\"", ",", "ww___"}], 
                   "}"}]}], "]"}]}], "]"}], ":>", 
              RowBox[{"ButtonBox", "[", 
               RowBox[{"a", ",", " ", "\[IndentingNewLine]", 
                RowBox[{"Rule", "[", 
                 RowBox[{"BaseStyle", ",", " ", 
                  RowBox[{"{", 
                   RowBox[{"jj", ",", "\"\<Hyperlink\>\"", ",", "ww"}], 
                   "}"}]}], "]"}]}], "]"}]}], ",", "\[IndentingNewLine]", 
             RowBox[{
              RowBox[{"ButtonBox", "[", 
               RowBox[{"a___", ",", " ", 
                RowBox[{"Rule", "[", 
                 RowBox[{"BaseStyle", ",", " ", 
                  RowBox[{"{", 
                   RowBox[{"\"\<Link\>\"", ",", "ww___"}], "}"}]}], "]"}]}], 
               "]"}], ":>", 
              RowBox[{"ButtonBox", "[", 
               RowBox[{"a", ",", " ", "\[IndentingNewLine]", 
                RowBox[{"Rule", "[", 
                 RowBox[{"BaseStyle", ",", " ", 
                  RowBox[{"{", 
                   RowBox[{"\"\<Hyperlink\>\"", ",", "ww"}], "}"}]}], "]"}]}],
                "]"}]}], ",", "\[IndentingNewLine]", 
             RowBox[{
              RowBox[{"ButtonBox", "[", 
               RowBox[{"a___", ",", " ", 
                RowBox[{"Rule", "[", 
                 RowBox[{"BaseStyle", ",", " ", 
                  RowBox[{"{", 
                   RowBox[{"jj___", ",", "\"\<Link\>\""}], "}"}]}], "]"}]}], 
               "]"}], ":>", 
              RowBox[{"ButtonBox", "[", 
               RowBox[{"a", ",", " ", "\[IndentingNewLine]", 
                RowBox[{"Rule", "[", 
                 RowBox[{"BaseStyle", ",", " ", 
                  RowBox[{"{", 
                   RowBox[{"jj", ",", "\"\<Hyperlink\>\""}], "}"}]}], "]"}]}],
                "]"}]}]}], "}"}]}]}], ";", "\[IndentingNewLine]", 
         RowBox[{"bob", "=", 
          RowBox[{"bob", "/.", 
           RowBox[{"Map", "[", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{"cell", ":", "#"}], ")"}], "\[RuleDelayed]", 
               RowBox[{"(", 
                RowBox[{"cell", "/.", 
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"Rule", "[", 
                    RowBox[{"ButtonData", ",", " ", "b_String"}], "]"}], 
                   "\[RuleDelayed]", 
                   RowBox[{"(", "\[IndentingNewLine]", 
                    RowBox[{"Rule", "[", 
                    RowBox[{"ButtonData", ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"URL", "[", 
                    RowBox[{"ButtonDataConversion", "[", 
                    RowBox[{"First", "[", 
                    RowBox[{"StringSplit", "[", 
                    RowBox[{"b", ",", "\"\<#\>\""}], "]"}], "]"}], "]"}], 
                    "]"}], ",", "None"}], "}"}]}], "]"}], ")"}]}], "}"}]}], 
                ")"}]}], "&"}], ",", 
             RowBox[{"Cases", "[", 
              RowBox[{"bob", ",", 
               RowBox[{
                RowBox[{"Cell", "[", 
                 RowBox[{"contents_", ",", "rest___"}], "]"}], "/;", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"MemberQ", "[", 
                   RowBox[{"contents", ",", 
                    RowBox[{"ButtonBox", "[", "___", "]"}], ",", "Infinity"}],
                    "]"}], "&&", 
                  RowBox[{"!", 
                   RowBox[{"MemberQ", "[", 
                    RowBox[{
                    RowBox[{"{", "rest", "}"}], ",", 
                    RowBox[{
                    "\"\<Input\>\"", "|", "\"\<Output\>\"", "|", 
                    "\"\<MSG\>\"", "|", "\"\<Message\>\"", "|", 
                    "\"\<Print\>\"", "|", "\"\<PrintUsage\>\"", "|", 
                    "\"\<ConversionLockdown\>\""}], ",", "Infinity"}], 
                    "]"}]}], "&&", 
                  RowBox[{"!", 
                   RowBox[{"MemberQ", "[", 
                    RowBox[{
                    RowBox[{"{", "contents", "}"}], ",", 
                    RowBox[{"Cell", "[", 
                    RowBox[{"___", ",", 
                    RowBox[{
                    "\"\<Input\>\"", "|", "\"\<Output\>\"", "|", 
                    "\"\<MSG\>\"", "|", "\"\<Message\>\"", "|", 
                    "\"\<Print\>\"", "|", "\"\<PrintUsage\>\"", "|", 
                    "\"\<ConversionLockdown\>\""}], ",", "___"}], "]"}], ",", 
                    "Infinity"}], "]"}]}], "&&", 
                  RowBox[{"!", 
                   RowBox[{"MemberQ", "[", 
                    RowBox[{
                    RowBox[{"{", "contents", "}"}], ",", 
                    RowBox[{"Rule", "[", 
                    RowBox[{"Appearance", ",", 
                    RowBox[{
                    "\"\<DialogBox\>\"", "|", "\"\<DefaultButton\>\""}]}], 
                    "]"}], ",", "Infinity"}], "]"}]}], "&&", 
                  "\[IndentingNewLine]", 
                  RowBox[{"!", 
                   RowBox[{"MemberQ", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"contents", ",", "rest"}], "}"}], ",", 
                    RowBox[{"Rule", "[", 
                    RowBox[{"CellID", ",", 
                    RowBox[{"1653826644", "|", "1475850354"}]}], "]"}], ",", 
                    "Infinity"}], "]"}]}]}], ")"}]}], ",", "Infinity"}], 
              "]"}]}], "]"}]}]}], ";", "\[IndentingNewLine]", 
         RowBox[{"bob", "=", 
          RowBox[{"bob", "/.", 
           RowBox[{"Map", "[", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{"cell", ":", "#"}], ")"}], "\[RuleDelayed]", 
               RowBox[{"(", 
                RowBox[{"cell", "/.", 
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"RuleDelayed", "[", 
                    RowBox[{"ButtonData", ",", " ", "b_String"}], "]"}], 
                   "\[RuleDelayed]", 
                   RowBox[{"(", "\[IndentingNewLine]", 
                    RowBox[{"Rule", "[", 
                    RowBox[{"ButtonData", ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"URL", "[", 
                    RowBox[{"ButtonDataConversion", "[", 
                    RowBox[{"First", "[", 
                    RowBox[{"StringSplit", "[", 
                    RowBox[{"b", ",", "\"\<#\>\""}], "]"}], "]"}], "]"}], 
                    "]"}], ",", "None"}], "}"}]}], "]"}], ")"}]}], "}"}]}], 
                ")"}]}], "&"}], ",", 
             RowBox[{"Cases", "[", 
              RowBox[{"bob", ",", 
               RowBox[{
                RowBox[{"Cell", "[", 
                 RowBox[{"contents_", ",", "rest___"}], "]"}], "/;", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"MemberQ", "[", 
                   RowBox[{"contents", ",", 
                    RowBox[{"ButtonBox", "[", "___", "]"}], ",", "Infinity"}],
                    "]"}], "&&", 
                  RowBox[{"!", 
                   RowBox[{"MemberQ", "[", 
                    RowBox[{
                    RowBox[{"{", "rest", "}"}], ",", 
                    RowBox[{
                    "\"\<Input\>\"", "|", "\"\<Output\>\"", "|", 
                    "\"\<MSG\>\"", "|", "\"\<Message\>\"", "|", 
                    "\"\<Print\>\"", "|", "\"\<PrintUsage\>\"", "|", 
                    "\"\<ConversionLockdown\>\""}], ",", "Infinity"}], 
                    "]"}]}], "&&", 
                  RowBox[{"!", 
                   RowBox[{"MemberQ", "[", 
                    RowBox[{
                    RowBox[{"{", "contents", "}"}], ",", 
                    RowBox[{"Cell", "[", 
                    RowBox[{"___", ",", 
                    RowBox[{
                    "\"\<Input\>\"", "|", "\"\<Output\>\"", "|", 
                    "\"\<MSG\>\"", "|", "\"\<Message\>\"", "|", 
                    "\"\<Print\>\"", "|", "\"\<PrintUsage\>\"", "|", 
                    "\"\<ConversionLockdown\>\""}], ",", "___"}], "]"}], ",", 
                    "Infinity"}], "]"}]}], "&&", "\[IndentingNewLine]", 
                  RowBox[{"!", 
                   RowBox[{"MemberQ", "[", 
                    RowBox[{
                    RowBox[{"{", "contents", "}"}], ",", 
                    RowBox[{"Rule", "[", 
                    RowBox[{"Appearance", ",", 
                    RowBox[{
                    "\"\<DialogBox\>\"", "|", "\"\<DefaultButton\>\""}]}], 
                    "]"}], ",", "Infinity"}], "]"}]}], "&&", 
                  "\[IndentingNewLine]", 
                  RowBox[{"!", 
                   RowBox[{"MemberQ", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"contents", ",", "rest"}], "}"}], ",", 
                    RowBox[{"Rule", "[", 
                    RowBox[{"CellID", ",", 
                    RowBox[{"1653826644", "|", "1475850354"}]}], "]"}], ",", 
                    "Infinity"}], "]"}]}]}], ")"}]}], ",", "Infinity"}], 
              "]"}]}], "]"}]}]}], ";", "\[IndentingNewLine]", 
         RowBox[{"bob", "=", 
          RowBox[{"bob", "/.", 
           RowBox[{"Map", "[", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{"cell", ":", "#"}], ")"}], "\[RuleDelayed]", 
               RowBox[{"(", 
                RowBox[{"cell", "/.", 
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"ButtonBox", "[", 
                    RowBox[{"label_", ",", "b__"}], "]"}], "\[RuleDelayed]", 
                   RowBox[{"(", "\[IndentingNewLine]", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Length", "[", 
                    RowBox[{"Cases", "[", 
                    RowBox[{
                    RowBox[{"{", "b", "}"}], ",", 
                    RowBox[{
                    RowBox[{"Rule", "[", 
                    RowBox[{"ButtonData", ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"URL", "[", "c_String", "]"}], ",", " ", "None"}],
                     "}"}]}], "]"}], "\[RuleDelayed]", "c"}], ",", " ", 
                    "Infinity"}], "]"}], "]"}], ">", "0"}], ",", 
                    "\[IndentingNewLine]", 
                    RowBox[{"ButtonBox", "[", 
                    RowBox[{"label", ",", "b", ",", 
                    RowBox[{"ButtonNote", "\[Rule]", 
                    RowBox[{
                    RowBox[{"Cases", "[", 
                    RowBox[{
                    RowBox[{"{", "b", "}"}], ",", 
                    RowBox[{
                    RowBox[{"Rule", "[", 
                    RowBox[{"ButtonData", ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"URL", "[", "c_String", "]"}], ",", " ", "None"}],
                     "}"}]}], "]"}], "\[RuleDelayed]", "c"}], ",", " ", 
                    "Infinity"}], "]"}], "[", 
                    RowBox[{"[", "1", "]"}], "]"}]}]}], " ", "]"}], ",", " ", 
                    
                    RowBox[{"ButtonBox", "[", 
                    RowBox[{"label", ",", "b"}], " ", "]"}]}], "]"}], ")"}]}],
                   "}"}]}], ")"}]}], "&"}], ",", 
             RowBox[{"Cases", "[", 
              RowBox[{"bob", ",", 
               RowBox[{
                RowBox[{"Cell", "[", 
                 RowBox[{"contents_", ",", "rest___"}], "]"}], "/;", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"MemberQ", "[", 
                   RowBox[{"contents", ",", 
                    RowBox[{"ButtonBox", "[", "___", "]"}], ",", "Infinity"}],
                    "]"}], "&&", 
                  RowBox[{"!", 
                   RowBox[{"MemberQ", "[", 
                    RowBox[{
                    RowBox[{"{", "rest", "}"}], ",", 
                    RowBox[{
                    "\"\<Input\>\"", "|", "\"\<Output\>\"", "|", 
                    "\"\<MSG\>\"", "|", "\"\<Message\>\"", "|", 
                    "\"\<Print\>\"", "|", "\"\<PrintUsage\>\"", "|", 
                    "\"\<ConversionLockdown\>\""}], ",", "Infinity"}], 
                    "]"}]}], "&&", 
                  RowBox[{"!", 
                   RowBox[{"MemberQ", "[", 
                    RowBox[{
                    RowBox[{"{", "contents", "}"}], ",", 
                    RowBox[{"Cell", "[", 
                    RowBox[{"___", ",", 
                    RowBox[{
                    "\"\<Input\>\"", "|", "\"\<Output\>\"", "|", 
                    "\"\<MSG\>\"", "|", "\"\<Message\>\"", "|", 
                    "\"\<Print\>\"", "|", "\"\<PrintUsage\>\"", "|", 
                    "\"\<ConversionLockdown\>\""}], ",", "___"}], "]"}], ",", 
                    "Infinity"}], "]"}]}], "&&", 
                  RowBox[{"!", 
                   RowBox[{"MemberQ", "[", 
                    RowBox[{
                    RowBox[{"{", "contents", "}"}], ",", 
                    RowBox[{"Rule", "[", 
                    RowBox[{"Appearance", ",", 
                    RowBox[{
                    "\"\<DialogBox\>\"", "|", "\"\<DefaultButton\>\""}]}], 
                    "]"}], ",", "Infinity"}], "]"}]}], "&&", 
                  "\[IndentingNewLine]", 
                  RowBox[{"!", 
                   RowBox[{"MemberQ", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"contents", ",", "rest"}], "}"}], ",", 
                    RowBox[{"Rule", "[", 
                    RowBox[{"CellID", ",", 
                    RowBox[{"1653826644", "|", "1475850354"}]}], "]"}], ",", 
                    "Infinity"}], "]"}]}]}], ")"}]}], ",", "Infinity"}], 
              "]"}]}], "]"}]}]}], ";", "\[IndentingNewLine]", 
         RowBox[{"bob", "=", 
          RowBox[{"bob", "/.", 
           RowBox[{"Map", "[", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{"cell", ":", "#"}], ")"}], "\[RuleDelayed]", 
               RowBox[{"(", 
                RowBox[{"cell", "/.", 
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"ButtonBox", "[", 
                    RowBox[{"label_", ",", "b___"}], "]"}], "\[RuleDelayed]", 
                   
                   RowBox[{"(", "\[IndentingNewLine]", 
                    RowBox[{"ButtonToPaneSelector", "[", 
                    RowBox[{"label", ",", "b"}], "]"}], ")"}]}], "}"}]}], 
                ")"}]}], "&"}], ",", 
             RowBox[{"Cases", "[", 
              RowBox[{"bob", ",", 
               RowBox[{
                RowBox[{"Cell", "[", 
                 RowBox[{"contents_", ",", "rest___"}], "]"}], "/;", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"MemberQ", "[", 
                   RowBox[{"contents", ",", 
                    RowBox[{"ButtonBox", "[", "___", "]"}], ",", "Infinity"}],
                    "]"}], "&&", 
                  RowBox[{"!", 
                   RowBox[{"MemberQ", "[", 
                    RowBox[{
                    RowBox[{"{", "rest", "}"}], ",", 
                    RowBox[{
                    "\"\<Input\>\"", "|", "\"\<Output\>\"", "|", 
                    "\"\<MSG\>\"", "|", "\"\<Message\>\"", "|", 
                    "\"\<Print\>\"", "|", "\"\<PrintUsage\>\"", "|", 
                    "\"\<ConversionLockdown\>\""}], ",", "Infinity"}], 
                    "]"}]}], "&&", 
                  RowBox[{"!", 
                   RowBox[{"MemberQ", "[", 
                    RowBox[{
                    RowBox[{"{", "contents", "}"}], ",", 
                    RowBox[{"Cell", "[", 
                    RowBox[{"___", ",", 
                    RowBox[{
                    "\"\<Input\>\"", "|", "\"\<Output\>\"", "|", 
                    "\"\<MSG\>\"", "|", "\"\<Message\>\"", "|", 
                    "\"\<Print\>\"", "|", "\"\<PrintUsage\>\"", "|", 
                    "\"\<ConversionLockdown\>\""}], ",", "___"}], "]"}], ",", 
                    "Infinity"}], "]"}]}], "&&", 
                  RowBox[{"!", 
                   RowBox[{"MemberQ", "[", 
                    RowBox[{
                    RowBox[{"{", "contents", "}"}], ",", 
                    RowBox[{"Rule", "[", 
                    RowBox[{"Appearance", ",", 
                    RowBox[{
                    "\"\<DialogBox\>\"", "|", "\"\<DefaultButton\>\""}]}], 
                    "]"}], ",", "Infinity"}], "]"}]}], "&&", 
                  "\[IndentingNewLine]", 
                  RowBox[{"!", 
                   RowBox[{"MemberQ", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"contents", ",", "rest"}], "}"}], ",", 
                    RowBox[{"Rule", "[", 
                    RowBox[{"CellID", ",", 
                    RowBox[{"1653826644", "|", "1475850354"}]}], "]"}], ",", 
                    "Infinity"}], "]"}]}]}], ")"}]}], ",", "Infinity"}], 
              "]"}]}], "]"}]}]}], ";", "\[IndentingNewLine]", 
         RowBox[{"bob", "=", 
          RowBox[{"bob", "/.", 
           RowBox[{
            RowBox[{"Cell", "[", 
             RowBox[{
              RowBox[{"TextData", "[", 
               RowBox[{"ButtonBox", "[", 
                RowBox[{
                 RowBox[{"Cell", "[", 
                  RowBox[{
                   RowBox[{"BoxData", "[", 
                    RowBox[{"FormBox", "[", 
                    RowBox[{
                    RowBox[{"ButtonBox", "[", 
                    RowBox[{
                    RowBox[{"TagBox", "[", 
                    RowBox[{
                    RowBox[{"PaneSelectorBox", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"Rule", "[", 
                    RowBox[{"False", ",", 
                    RowBox[{"StyleBox", "[", 
                    RowBox[{"a_", ",", "___"}], "]"}]}], "]"}], ",", "___"}], 
                    "}"}], ",", "___"}], "]"}], ",", "___"}], "]"}], ",", 
                    "___"}], "]"}], ",", "___"}], "]"}], "]"}], ",", "___"}], 
                  "]"}], ",", "___"}], "]"}], "]"}], ",", 
              RowBox[{"b", ":", 
               RowBox[{"(", 
                RowBox[{
                "\"\<ElementsSection\>\"", "|", "\"\<ExampleSection\>\"", 
                 "|", "\"\<ExampleSubsection\>\"", "|", 
                 "\"\<ExampleSubsubsection\>\"", "|", 
                 "\"\<ExtendedExamplesSection\>\"", "|", 
                 "\"\<GuideRelatedLinksSection\>\"", "|", 
                 "\"\<GuideTutorialsSection\>\"", "|", 
                 "\"\<GuideMoreAboutSection\>\"", "|", 
                 "\"\<ImportExportSection\>\"", "|", 
                 "\"\<NotebookInterfaceSection\>\"", "|", 
                 "\"\<MoreAboutSection\>\"", "|", 
                 "\"\<MoreToExploreSection\>\"", "|", 
                 "\"\<MoreInformationSection\>\"", "|", 
                 "\"\<OptionsSection\>\"", "|", 
                 "\"\<PrimaryExamplesSection\>\"", "|", 
                 "\"\<RelatedLinksSection\>\"", "|", 
                 "\"\<RelatedTutorialsSection\>\"", "|", 
                 "\"\<SeeAlsoSection\>\"", "|", "\"\<TutorialsSection\>\"", 
                 "|", "\"\<TutorialCollectionSection\>\"", "|", 
                 "\"\<TutorialsTutorialCollectionSection\>\"", "|", 
                 "\"\<TutorialRelatedLinksSection\>\"", "|", 
                 "\"\<UsageDetailsSection\>\"", "|", "\"\<NotesSection\>\""}],
                 ")"}]}], ",", "c___"}], "]"}], ":>", 
            RowBox[{"Cell", "[", 
             RowBox[{
              RowBox[{"TextData", "[", 
               RowBox[{"ButtonBox", "[", 
                RowBox[{
                 RowBox[{"StringReplace", "[", 
                  RowBox[{"a", ",", 
                   RowBox[{"\"\<\\\"\>\"", "\[Rule]", "\"\<\>\""}]}], "]"}], 
                 ",", 
                 RowBox[{"BaseStyle", "\[Rule]", "None"}], ",", 
                 RowBox[{"ButtonFunction", "\[RuleDelayed]", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"FrontEndExecute", "[", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"FrontEnd`SelectionMove", "[", 
                    RowBox[{
                    RowBox[{"FrontEnd`SelectedNotebook", "[", "]"}], ",", 
                    "All", ",", "ButtonCell"}], "]"}], ",", 
                    RowBox[{
                    "FrontEndToken", "[", "\"\<OpenCloseGroup\>\"", "]"}], 
                    ",", 
                    RowBox[{"FrontEnd`SelectionMove", "[", 
                    RowBox[{
                    RowBox[{"FrontEnd`SelectedNotebook", "[", "]"}], ",", 
                    "After", ",", "CellContents"}], "]"}]}], "}"}], "]"}], 
                    "&"}], ")"}]}], ",", 
                 RowBox[{"ButtonFrame", "\[Rule]", "\"\<None\>\""}], ",", 
                 RowBox[{"Evaluator", "\[Rule]", "None"}], ",", 
                 RowBox[{"Method", "\[Rule]", "\"\<Preemptive\>\""}]}], "]"}],
                "]"}], ",", "b", ",", "c"}], "]"}]}]}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"bob", "=", 
          RowBox[{"bob", "/.", 
           RowBox[{"{", " ", 
            RowBox[{
             RowBox[{"Cell", "[", 
              RowBox[{"a___", ",", 
               RowBox[{"c", ":", "\"\<NotesSection\>\""}], ",", "b___"}], 
              "]"}], "\[RuleDelayed]", 
             RowBox[{"Cell", "[", 
              RowBox[{
               RowBox[{"TextData", "[", 
                RowBox[{"Cell", "[", 
                 RowBox[{"BoxData", "[", 
                  RowBox[{"ButtonBox", "[", 
                   RowBox[{
                    RowBox[{"FrameBox", "[", 
                    RowBox[{
                    RowBox[{"StyleBox", "[", 
                    RowBox[{
                    RowBox[{"CDFLocalized", "[", 
                    RowBox[{"\"\<More Information\>\"", ",", "lang"}], "]"}], 
                    ",", "\"\<NotesFrameText\>\""}], "]"}], ",", 
                    RowBox[{"StripOnInput", "\[Rule]", "False"}]}], "]"}], 
                    ",", 
                    RowBox[{"Appearance", "\[Rule]", 
                    RowBox[{"{", 
                    RowBox[{"Automatic", ",", "None"}], "}"}]}], ",", 
                    RowBox[{"BaseStyle", "\[Rule]", "None"}], ",", 
                    RowBox[{"ButtonFunction", "\[RuleDelayed]", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"FrontEndExecute", "[", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"FrontEnd`SelectionMove", "[", 
                    RowBox[{
                    RowBox[{"FrontEnd`SelectedNotebook", "[", "]"}], ",", 
                    "All", ",", "ButtonCell"}], "]"}], ",", 
                    RowBox[{
                    "FrontEndToken", "[", "\"\<OpenCloseGroup\>\"", "]"}], 
                    ",", 
                    RowBox[{"FrontEnd`SelectionMove", "[", 
                    RowBox[{
                    RowBox[{"FrontEnd`SelectedNotebook", "[", "]"}], ",", 
                    "After", ",", "CellContents"}], "]"}]}], "}"}], "]"}], 
                    "&"}], ")"}]}], ",", 
                    RowBox[{"Evaluator", "\[Rule]", "None"}], ",", 
                    RowBox[{"Method", "\[Rule]", "\"\<Preemptive\>\""}]}], 
                   "]"}], "]"}], "]"}], "]"}], ",", "c", ",", 
               RowBox[{"WholeCellGroupOpener", "\[Rule]", "True"}], ",", 
               RowBox[{"CellGroupingRules", "\[Rule]", 
                RowBox[{"{", 
                 RowBox[{"\"\<SectionGrouping\>\"", ",", "50"}], "}"}]}]}], 
              "]"}]}], "}"}]}]}], ";", "\[IndentingNewLine]", 
         RowBox[{"(*", 
          RowBox[{
           RowBox[{"bob", "=", 
            RowBox[{"bob", "/.", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"Rule", "[", 
                RowBox[{"ButtonData", ",", " ", "b_String"}], "]"}], ":>", 
               RowBox[{"Rule", "[", 
                RowBox[{"ButtonData", ",", " ", 
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"URL", "[", 
                    RowBox[{
                    RowBox[{"StringReplace", "[", 
                    RowBox[{
                    RowBox[{"First", "[", 
                    RowBox[{"StringSplit", "[", 
                    RowBox[{"b", ",", "\"\<#\>\""}], "]"}], "]"}], ",", 
                    RowBox[{
                    "\"\<paclet:\>\"", "\[Rule]", "\"\</mathematica/\>\""}]}],
                     "]"}], "<>", "\"\<.cdf\>\""}], "]"}], ",", "None"}], 
                  "}"}]}], "]"}]}], "}"}]}]}], ";", "\[IndentingNewLine]", 
           RowBox[{"bob", "=", 
            RowBox[{"bob", "/.", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"RuleDelayed", "[", 
                RowBox[{"ButtonData", ",", " ", "b_String"}], "]"}], ":>", 
               RowBox[{"Rule", "[", 
                RowBox[{"ButtonData", ",", " ", 
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"URL", "[", 
                    RowBox[{
                    RowBox[{"StringReplace", "[", 
                    RowBox[{
                    RowBox[{"First", "[", 
                    RowBox[{"StringSplit", "[", 
                    RowBox[{"b", ",", "\"\<#\>\""}], "]"}], "]"}], ",", 
                    RowBox[{
                    "\"\<paclet:\>\"", "\[Rule]", "\"\</mathematica/\>\""}]}],
                     "]"}], "<>", "\"\<.cdf\>\""}], "]"}], ",", "None"}], 
                  "}"}]}], "]"}]}], "}"}]}]}], ";"}], "*)"}], 
         "\[IndentingNewLine]", 
         RowBox[{"bob", "=", 
          RowBox[{"bob", "/.", 
           RowBox[{
            RowBox[{"RuleDelayed", "[", 
             RowBox[{"j_", ",", 
              RowBox[{"Documentation`HelpLookup", "[", "k_", "]"}]}], "]"}], 
            "\[Rule]", 
            RowBox[{"{", 
             RowBox[{"j", ",", "k"}], "}"}]}]}]}], ";", "\[IndentingNewLine]", 
         RowBox[{"bob", "=", 
          RowBox[{"bob", "/.", 
           RowBox[{
            RowBox[{"ActionMenuBox", "[", 
             RowBox[{
              RowBox[{"FrameBox", "[", 
               RowBox[{
               "\"\<\\<\\\"URL \[RightGuillemet]\\\"\\>\>\"", ",", "d___"}], 
               "]"}], ",", "b_", ",", "c___"}], "]"}], "\[Rule]", 
            "\"\<\>\""}]}]}], ";", "\[IndentingNewLine]", 
         RowBox[{"bob", "=", 
          RowBox[{"bob", "/.", 
           RowBox[{
            RowBox[{"ActionMenuBox", "[", 
             RowBox[{
              RowBox[{"FrameBox", "[", 
               RowBox[{"a_", ",", "d___"}], "]"}], ",", "b_", ",", "c___"}], 
             "]"}], "->", 
            RowBox[{"MakeCDFActionMenu", "[", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"a", ",", "b"}], "}"}], ",", "c"}], "]"}]}]}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"bob", "=", 
          RowBox[{"bob", "/.", 
           RowBox[{
            RowBox[{"Cell", "[", 
             RowBox[{
             "___", ",", "\"\<PrimaryExamplesSection\>\"", ",", "___"}], 
             "]"}], ":>", 
            RowBox[{"primaryexamplecell", "[", "lang", "]"}]}]}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"bob", "=", 
          RowBox[{"bob", "/.", 
           RowBox[{
            RowBox[{"Cell", "[", 
             RowBox[{
              RowBox[{"CellGroupData", "[", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"Cell", "[", 
                   RowBox[{
                   "a___", ",", "\"\<ExampleSection\>\"", ",", "b___"}], 
                   "]"}], ",", "c___"}], "}"}], ",", "d___"}], "]"}], ",", 
              "e___"}], "]"}], ":>", 
            RowBox[{"Cell", "[", 
             RowBox[{
              RowBox[{"CellGroupData", "[", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"Cell", "[", 
                   RowBox[{"a", ",", "\"\<ExampleSection\>\"", ",", "b"}], 
                   "]"}], ",", 
                  RowBox[{"Cell", "[", 
                   RowBox[{
                    RowBox[{"BoxData", "[", 
                    RowBox[{"InterpretationBox", "[", 
                    RowBox[{
                    RowBox[{"Cell", "[", 
                    RowBox[{
                    "\"\<\\t\>\"", ",", "\"\<HiddenExampleDelimiter\>\""}], 
                    "]"}], ",", 
                    RowBox[{
                    RowBox[{"$Line", "=", "0"}], ";", "Null"}]}], "]"}], 
                    "]"}], ",", "\"\<HiddenExampleDelimiter\>\""}], "]"}], 
                  ",", "c"}], "}"}], ",", "d"}], "]"}], ",", "e"}], 
             "]"}]}]}]}], ";", "\[IndentingNewLine]", 
         RowBox[{"bob", "=", 
          RowBox[{"bob", "/.", 
           RowBox[{
            RowBox[{"Cell", "[", 
             RowBox[{
              RowBox[{"CellGroupData", "[", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"Cell", "[", 
                   RowBox[{
                   "a___", ",", "\"\<ExampleSubsection\>\"", ",", "b___"}], 
                   "]"}], ",", "c___"}], "}"}], ",", "d___"}], "]"}], ",", 
              "e___"}], "]"}], ":>", 
            RowBox[{"Cell", "[", 
             RowBox[{
              RowBox[{"CellGroupData", "[", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"Cell", "[", 
                   RowBox[{"a", ",", "\"\<ExampleSubsection\>\"", ",", "b"}], 
                   "]"}], ",", 
                  RowBox[{"Cell", "[", 
                   RowBox[{
                    RowBox[{"BoxData", "[", 
                    RowBox[{"InterpretationBox", "[", 
                    RowBox[{
                    RowBox[{"Cell", "[", 
                    RowBox[{
                    "\"\<\\t\>\"", ",", "\"\<HiddenExampleDelimiter\>\""}], 
                    "]"}], ",", 
                    RowBox[{
                    RowBox[{"$Line", "=", "0"}], ";", "Null"}]}], "]"}], 
                    "]"}], ",", "\"\<HiddenExampleDelimiter\>\""}], "]"}], 
                  ",", "c"}], "}"}], ",", "d"}], "]"}], ",", "e"}], 
             "]"}]}]}]}], ";", "\[IndentingNewLine]", 
         RowBox[{"bob", "=", 
          RowBox[{"bob", "/.", 
           RowBox[{
            RowBox[{"Cell", "[", 
             RowBox[{
              RowBox[{"CellGroupData", "[", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"Cell", "[", 
                   RowBox[{
                   "a___", ",", "\"\<ExampleSubsubsection\>\"", ",", "b___"}],
                    "]"}], ",", "c___"}], "}"}], ",", "d___"}], "]"}], ",", 
              "e___"}], "]"}], ":>", 
            RowBox[{"Cell", "[", 
             RowBox[{
              RowBox[{"CellGroupData", "[", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"Cell", "[", 
                   RowBox[{
                   "a", ",", "\"\<ExampleSubsubsection\>\"", ",", "b"}], 
                   "]"}], ",", 
                  RowBox[{"Cell", "[", 
                   RowBox[{
                    RowBox[{"BoxData", "[", 
                    RowBox[{"InterpretationBox", "[", 
                    RowBox[{
                    RowBox[{"Cell", "[", 
                    RowBox[{
                    "\"\<\\t\>\"", ",", "\"\<HiddenExampleDelimiter\>\""}], 
                    "]"}], ",", 
                    RowBox[{
                    RowBox[{"$Line", "=", "0"}], ";", "Null"}]}], "]"}], 
                    "]"}], ",", "\"\<HiddenExampleDelimiter\>\""}], "]"}], 
                  ",", "c"}], "}"}], ",", "d"}], "]"}], ",", "e"}], 
             "]"}]}]}]}], ";", "\[IndentingNewLine]", 
         RowBox[{"ids", "=", 
          RowBox[{"Cases", "[", 
           RowBox[{
            RowBox[{"outputcelldbvalues", "[", "lang", "]"}], ",", " ", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"urimetadata", ",", " ", "a_"}], "}"}], 
             "\[RuleDelayed]", "a"}], ",", " ", "Infinity"}], "]"}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"Length", "[", "ids", "]"}], "=!=", "1"}], ",", " ", 
           RowBox[{"ids", "=", 
            RowBox[{"{", 
             RowBox[{"{", "}"}], "}"}]}]}], "]"}], ";", "\[IndentingNewLine]", 
         RowBox[{"bob", "=", 
          RowBox[{"bob", "/.", 
           RowBox[{
            RowBox[{"Cell", "[", 
             RowBox[{"a___", ",", "\"\<Output\>\"", ",", "b___", ",", 
              RowBox[{"c", ":", 
               RowBox[{"Rule", "[", " ", 
                RowBox[{"CellID", ",", 
                 RowBox[{"Except", "[", 
                  RowBox[{"Alternatives", "@@", 
                   RowBox[{"ids", "[", 
                    RowBox[{"[", "1", "]"}], "]"}]}], "]"}]}], "]"}]}], ",", 
              " ", "d___"}], "]"}], "\[RuleDelayed]", 
            RowBox[{"ClicktoInteract", "[", 
             RowBox[{
              RowBox[{"{", "lang", "}"}], ",", 
              RowBox[{"{", "a", "}"}], ",", 
              RowBox[{"{", "b", "}"}], ",", 
              RowBox[{"{", "c", "}"}], ",", 
              RowBox[{"{", "d", "}"}]}], "]"}]}]}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"bob", "=", 
          RowBox[{"bob", "/.", 
           RowBox[{
            RowBox[{"Notebook", "[", "a___", "]"}], "\[Rule]", 
            RowBox[{"Notebook", "[", 
             RowBox[{"a", ",", 
              RowBox[{"DockedCells", "\[Rule]", 
               RowBox[{"Dynamic", "[", 
                RowBox[{"FEPrivate`If", "[", 
                 RowBox[{
                  RowBox[{"FEPrivate`SameQ", "[", 
                   RowBox[{
                    RowBox[{"FrontEnd`CurrentValue", "[", 
                    RowBox[{
                    RowBox[{"FrontEnd`InputNotebook", "[", "]"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"TaggingRules", ",", "\"\<showdockedcell\>\""}], 
                    "}"}]}], "]"}], ",", "True"}], "]"}], ",", 
                  RowBox[{"FEPrivate`FrontEndResource", "[", 
                   RowBox[{
                   "\"\<FEExpressions\>\"", ",", "\"\<PluginToolbar\>\""}], 
                   "]"}], ",", " ", 
                  RowBox[{"{", "}"}]}], "]"}], "]"}]}], ",", 
              RowBox[{"StyleDefinitions", "\[Rule]", 
               RowBox[{"styledefs", "[", "lang", "]"}]}], ",", 
              RowBox[{
              "WindowElements", "\[Rule]", "\"\<VerticalScrollBar\>\""}], ",",
               " ", 
              RowBox[{"ScrollingOptions", "\[Rule]", 
               RowBox[{"{", 
                RowBox[{"\"\<HorizontalScrollRange\>\"", "\[Rule]", "0"}], 
                "}"}]}], ",", 
              RowBox[{"PrivateNotebookOptions", "\[Rule]", 
               RowBox[{"{", 
                RowBox[{"\"\<PluginToolbarEnabled\>\"", "\[Rule]", "False"}], 
                "}"}]}], ",", 
              RowBox[{"PageWidth", "\[Rule]", "800"}], ",", 
              RowBox[{"CellBracketOptions", "\[Rule]", 
               RowBox[{"{", 
                RowBox[{"\"\<Margins\>\"", "\[Rule]", 
                 RowBox[{"{", 
                  RowBox[{"0", ",", 
                   RowBox[{"Dynamic", "[", 
                    RowBox[{"FEPrivate`If", "[", 
                    RowBox[{
                    RowBox[{"FEPrivate`Less", "[", 
                    RowBox[{
                    RowBox[{"FrontEnd`AbsoluteCurrentValue", "[", 
                    RowBox[{"{", 
                    RowBox[{"WindowSize", ",", "1"}], "}"}], "]"}], ",", 
                    "800"}], "]"}], ",", "2", ",", 
                    RowBox[{
                    RowBox[{"FrontEnd`AbsoluteCurrentValue", "[", 
                    RowBox[{"{", 
                    RowBox[{"WindowSize", ",", "1"}], "}"}], "]"}], "-", 
                    "800"}]}], "]"}], "]"}]}], "}"}]}], "}"}]}]}], 
             "]"}]}]}]}], ";", "\[IndentingNewLine]", 
         RowBox[{"bob", "=", 
          RowBox[{"bob", "/.", 
           RowBox[{
            RowBox[{"Rule", "[", 
             RowBox[{"TaggingRules", ",", 
              RowBox[{"{", "a___", "}"}]}], "]"}], ":>", 
            RowBox[{"Rule", "[", 
             RowBox[{"TaggingRules", ",", 
              RowBox[{"Flatten", "[", 
               RowBox[{"{", 
                RowBox[{"a", ",", 
                 RowBox[{"\"\<showdockedcell\>\"", "\[Rule]", "False"}], ",", 
                 
                 RowBox[{"If", "[", 
                  RowBox[{
                   RowBox[{"BannerMessageQ", "[", "bob", "]"}], ",", 
                   RowBox[{"TaggingRulesAdd", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"True", ",", "True", ",", "True", ",", "False"}], 
                    "}"}], ",", " ", "lang"}], "]"}], ",", 
                   RowBox[{"{", "}"}]}], "]"}]}], "}"}], "]"}]}], "]"}]}]}]}],
          ";", "\[IndentingNewLine]", 
         RowBox[{"bob", "=", 
          RowBox[{"Append", "[", 
           RowBox[{"bob", ",", 
            RowBox[{"NotebookEventActions", "->", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{
                "\"\<MenuCommand\>\"", ",", "\"\<FindExpression\>\""}], "}"}],
                "\[RuleDelayed]", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{
                  RowBox[{"CurrentValue", "[", 
                   RowBox[{
                    RowBox[{"InputNotebook", "[", "]"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"TaggingRules", ",", "\"\<showdockedcell\>\""}], 
                    "}"}]}], "]"}], "=", 
                  RowBox[{"!", 
                   RowBox[{"(", 
                    RowBox[{"CurrentValue", "[", 
                    RowBox[{
                    RowBox[{"InputNotebook", "[", "]"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"TaggingRules", ",", "\"\<showdockedcell\>\""}], 
                    "}"}]}], "]"}], ")"}]}]}], ";", 
                 RowBox[{"MathLink`CallFrontEnd", "[", 
                  RowBox[{"FrontEnd`BoxReferenceFind", "[", 
                   RowBox[{
                    RowBox[{"FE`BoxReference", "[", 
                    RowBox[{
                    RowBox[{"InputNotebook", "[", "]"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"{", "\"\<PluginToolbarSearchField\>\"", "}"}], 
                    "}"}], ",", 
                    RowBox[{"FE`BoxOffset", "\[Rule]", 
                    RowBox[{"{", 
                    RowBox[{"FE`BoxChild", "[", "1", "]"}], "}"}]}]}], "]"}], 
                    ",", 
                    RowBox[{
                    "FE`SearchStart", "\[Rule]", 
                    "\"\<StartFromFirstDockedCell\>\""}]}], "]"}], "]"}]}], 
                ")"}]}], "}"}]}]}], "]"}]}], ";", "\[IndentingNewLine]", 
         RowBox[{"bob", "=", 
          RowBox[{"Insert", "[", 
           RowBox[{"bob", ",", " ", 
            RowBox[{"VersionCDFCell", "[", 
             RowBox[{"urimetadata", ",", " ", "lang"}], "]"}], ",", " ", 
            RowBox[{"{", 
             RowBox[{"1", ",", "1"}], "}"}]}], "]"}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"bob", "=", 
          RowBox[{"Insert", "[", 
           RowBox[{"bob", ",", 
            RowBox[{"searchcell", "[", "lang", "]"}], ",", 
            RowBox[{"{", 
             RowBox[{"1", ",", "1"}], "}"}]}], "]"}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"bob", "=", 
          RowBox[{"Insert", "[", 
           RowBox[{"bob", ",", 
            RowBox[{"poweredbybannercell", "[", "lang", "]"}], ",", 
            RowBox[{"{", 
             RowBox[{"1", ",", "1"}], "}"}]}], "]"}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"bob", "=", 
          RowBox[{"Insert", "[", 
           RowBox[{"bob", ",", " ", 
            RowBox[{"blackheadercell", "[", "lang", "]"}], ",", " ", 
            RowBox[{"{", 
             RowBox[{"1", ",", "1"}], "}"}]}], "]"}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"bob", "=", 
          RowBox[{"Insert", "[", 
           RowBox[{"bob", ",", " ", 
            RowBox[{"footercell", "[", 
             RowBox[{"urimetadata", ",", "lang"}], "]"}], ",", " ", 
            RowBox[{"{", 
             RowBox[{"1", ",", " ", 
              RowBox[{"-", "1"}]}], "}"}]}], "]"}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"CreateDirectory", "[", 
          RowBox[{"DirectoryName", "[", 
           RowBox[{
           "outputCDFdir", "<>", "urimetadata", "<>", "\"\<.cdf\>\""}], "]"}],
           "]"}], ";", "\[IndentingNewLine]", 
         RowBox[{"Export", "[", 
          RowBox[{
           RowBox[{
           "outputCDFdir", "<>", "urimetadata", "<>", "langext", "<>", 
            "\"\<.cdf\>\""}], ",", "bob", ",", "\"\<CDF\>\""}], "]"}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"(*", 
          RowBox[{"Export", "[", 
           RowBox[{
            RowBox[{"\"\</tmp/mathematica/ref/\>\"", "<>", 
             RowBox[{"FileBaseName", "[", 
              RowBox[{"fns", "[", 
               RowBox[{"[", "i", "]"}], "]"}], "]"}], "<>", "\"\<.nb\>\""}], 
            ",", "bob", ",", "\"\<NB\>\""}], "]"}], "*)"}], 
         "\[IndentingNewLine]", 
         RowBox[{"NotebookSign`PlayerProSecure", "[", 
          RowBox[{
          "outputCDFdir", "<>", "urimetadata", "<>", "langext", "<>", 
           "\"\<.cdf\>\""}], "]"}]}]}], "]"}]}]}], "]"}]}], ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{
  3.519054039355648*^9, 3.519054404530919*^9, {3.5194800572668743`*^9, 
   3.5194800945613728`*^9}, 3.519480274590991*^9, {3.519481644353881*^9, 
   3.519481676739374*^9}, {3.519481832568493*^9, 3.519481840199024*^9}, 
   3.519481904469208*^9, {3.519482015947811*^9, 3.5194820178568563`*^9}, 
   3.5194820605032187`*^9, 3.519482150561009*^9, {3.51948224902839*^9, 
   3.519482254504331*^9}, {3.5194912691224403`*^9, 3.5194912733968363`*^9}, 
   3.51966828957029*^9, {3.519734667335526*^9, 3.519734738301816*^9}, {
   3.5197347785172863`*^9, 3.519734783210829*^9}, {3.51973484244118*^9, 
   3.519734861064466*^9}, {3.519746828739368*^9, 3.519746830176207*^9}, 
   3.519747651189796*^9, {3.519747729426662*^9, 3.519747733903647*^9}, {
   3.5197477894260063`*^9, 3.519747791780699*^9}, {3.5197478897621117`*^9, 
   3.519747895895033*^9}, {3.519748059206291*^9, 3.519748073432733*^9}, {
   3.519748135355893*^9, 3.519748139938464*^9}, 3.519748240342288*^9, {
   3.519748292150567*^9, 3.519748292837037*^9}, {3.519748459787771*^9, 
   3.519748466575541*^9}, {3.5197485760026903`*^9, 3.519748582559237*^9}, {
   3.520272403756082*^9, 3.5202724314452667`*^9}, {3.520272477829336*^9, 
   3.520272600886704*^9}, {3.52027271122894*^9, 3.520272712724888*^9}, {
   3.520356137099938*^9, 3.52035613948098*^9}, {3.52035623240783*^9, 
   3.520356235323361*^9}, {3.520357164554775*^9, 3.5203571672835073`*^9}, {
   3.52035775749113*^9, 3.5203577601471663`*^9}, {3.520360414059073*^9, 
   3.520360426356186*^9}, {3.520614167104463*^9, 3.520614168715734*^9}, {
   3.5206179478608437`*^9, 3.5206179572109137`*^9}, {3.520618165924947*^9, 
   3.520618173418531*^9}, {3.5206188047892313`*^9, 3.520618808595592*^9}, {
   3.520618963861277*^9, 3.520618978624311*^9}, {3.5208617656263313`*^9, 
   3.5208617667313623`*^9}, {3.520862065381124*^9, 3.5208620672695007`*^9}, {
   3.520956190968421*^9, 3.520956204894709*^9}, {3.52122068033248*^9, 
   3.5212206821056347`*^9}, {3.5213083316973343`*^9, 3.5213083472478657`*^9}, 
   3.521308382858687*^9, {3.521308464048764*^9, 3.521308474060987*^9}, {
   3.521558276436919*^9, 3.5215582944431953`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"CDFpackageloaded", "=", "True"}], ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.519497037243113*^9, 3.519497062832004*^9}}]
}, Closed]]
},
WindowSize->{1156, 829},
WindowMargins->{{8, Automatic}, {Automatic, 0}},
ShowSelection->True,
TaggingRules->{
 "DocuToolsSettings" -> {
   "$ApplicationName" -> "sweet", "$LinkBase" -> "sweet", 
    "$DocumentationDirectory" -> 
    "/Applications/Mathematica.app/Documentation/English/", 
    "$ApplicationDirectory" -> 
    "/Users/brendan/WolframWorkspaces/Base/sweet/sweet"}, "ExamplesClosed" -> 
  True},
FrontEndVersion->"8.0 for Mac OS X x86 (32-bit, 64-bit Kernel) (February 23, \
2011)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[StyleDefinitions -> "Default.nb"]]}, Visible -> False, 
  FrontEndVersion -> 
  "8.0 for Mac OS X x86 (32-bit, 64-bit Kernel) (February 23, 2011)", 
  StyleDefinitions -> "PrivateStylesheetFormatting.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[579, 22, 237, 4, 67, "Section",
 InitializationCell->True],
Cell[819, 28, 14843, 317, 874, "Input",
 InitializationCell->True],
Cell[15665, 347, 1731, 48, 103, "Input",
 InitializationCell->True]
}, Closed]],
Cell[CellGroupData[{
Cell[17433, 400, 183, 3, 37, "Section",
 InitializationCell->True],
Cell[17619, 405, 3718, 92, 148, "Input",
 InitializationCell->True]
}, Closed]],
Cell[CellGroupData[{
Cell[21374, 502, 181, 3, 37, "Section",
 InitializationCell->True],
Cell[21558, 507, 6435, 152, 388, "Input",
 InitializationCell->True]
}, Closed]],
Cell[CellGroupData[{
Cell[28030, 664, 253, 4, 37, "Section",
 InitializationCell->True],
Cell[28286, 670, 8610, 176, 478, "Input",
 InitializationCell->True]
}, Closed]],
Cell[CellGroupData[{
Cell[36933, 851, 189, 3, 37, "Section",
 InitializationCell->True],
Cell[37125, 856, 5274, 109, 347, "Input",
 InitializationCell->True],
Cell[42402, 967, 654, 15, 43, "Input",
 InitializationCell->True],
Cell[43059, 984, 530, 14, 27, "Input",
 InitializationCell->True],
Cell[43592, 1000, 3320, 70, 238, "Input",
 InitializationCell->True],
Cell[46915, 1072, 7687, 165, 343, "Input",
 InitializationCell->True]
}, Closed]],
Cell[CellGroupData[{
Cell[54639, 1242, 257, 4, 37, "Section",
 InitializationCell->True],
Cell[54899, 1248, 3007, 55, 50, "Input",
 InitializationCell->True],
Cell[57909, 1305, 1611, 29, 64, "Input",
 InitializationCell->True],
Cell[59523, 1336, 6898, 137, 268, "Input",
 InitializationCell->True],
Cell[66424, 1475, 6929, 137, 283, "Input",
 InitializationCell->True],
Cell[73356, 1614, 8596, 173, 403, "Input",
 InitializationCell->True],
Cell[81955, 1789, 1814, 40, 103, "Input",
 InitializationCell->True],
Cell[83772, 1831, 477, 11, 27, "Input",
 InitializationCell->True]
}, Closed]],
Cell[CellGroupData[{
Cell[84286, 1847, 272, 4, 37, "Section",
 InitializationCell->True],
Cell[84561, 1853, 6729, 114, 343, "Input",
 InitializationCell->True]
}, Closed]],
Cell[CellGroupData[{
Cell[91327, 1972, 320, 5, 37, "Section",
 InitializationCell->True],
Cell[91650, 1979, 6898, 152, 313, "Input",
 InitializationCell->True],
Cell[98551, 2133, 6910, 151, 313, "Input",
 InitializationCell->True],
Cell[105464, 2286, 6925, 152, 313, "Input",
 InitializationCell->True],
Cell[112392, 2440, 6637, 147, 313, "Input",
 InitializationCell->True],
Cell[119032, 2589, 6648, 148, 313, "Input",
 InitializationCell->True]
}, Closed]],
Cell[CellGroupData[{
Cell[125717, 2742, 274, 4, 37, "Section",
 InitializationCell->True],
Cell[125994, 2748, 1517, 36, 73, "Input",
 InitializationCell->True],
Cell[127514, 2786, 1483, 36, 73, "Input",
 InitializationCell->True],
Cell[129000, 2824, 1538, 37, 73, "Input",
 InitializationCell->True],
Cell[130541, 2863, 1512, 37, 73, "Input",
 InitializationCell->True]
}, Closed]],
Cell[CellGroupData[{
Cell[132090, 2905, 276, 4, 37, "Section",
 InitializationCell->True],
Cell[132369, 2911, 49879, 913, 748, "Input",
 InitializationCell->True],
Cell[182251, 3826, 49746, 916, 917, "Input",
 InitializationCell->True],
Cell[232000, 4744, 49900, 917, 896, "Input",
 InitializationCell->True],
Cell[281903, 5663, 607, 14, 58, "Input",
 InitializationCell->True]
}, Closed]],
Cell[CellGroupData[{
Cell[282547, 5682, 342, 5, 37, "Section",
 InitializationCell->True],
Cell[282892, 5689, 5062, 89, 41, "Input",
 InitializationCell->True],
Cell[287957, 5780, 4181, 73, 41, "Input",
 InitializationCell->True],
Cell[292141, 5855, 609, 15, 58, "Input",
 InitializationCell->True],
Cell[292753, 5872, 3776, 88, 178, "Input",
 InitializationCell->True]
}, Closed]],
Cell[CellGroupData[{
Cell[296566, 5965, 394, 6, 37, "Section",
 InitializationCell->True],
Cell[296963, 5973, 10811, 183, 27, "Input",
 InitializationCell->True],
Cell[307777, 6158, 10239, 174, 27, "Input",
 InitializationCell->True],
Cell[318019, 6334, 10475, 178, 27, "Input",
 InitializationCell->True],
Cell[328497, 6514, 676, 15, 43, "Input",
 InitializationCell->True],
Cell[329176, 6531, 2080, 38, 29, "Input",
 InitializationCell->True],
Cell[331259, 6571, 1337, 30, 33, "Input",
 InitializationCell->True],
Cell[332599, 6603, 453, 12, 33, "Input",
 InitializationCell->True],
Cell[333055, 6617, 549, 13, 27, "Input",
 InitializationCell->True],
Cell[333607, 6632, 10946, 232, 433, "Input",
 InitializationCell->True]
}, Closed]],
Cell[CellGroupData[{
Cell[344590, 6869, 393, 6, 37, "Section",
 InitializationCell->True],
Cell[344986, 6877, 7525, 163, 583, "Input",
 InitializationCell->True]
}, Closed]],
Cell[CellGroupData[{
Cell[352548, 7045, 428, 6, 37, "Section",
 InitializationCell->True],
Cell[352979, 7053, 18590, 376, 927, "Input",
 InitializationCell->True]
}, Closed]],
Cell[CellGroupData[{
Cell[371606, 7434, 478, 7, 37, "Section",
 InitializationCell->True],
Cell[372087, 7443, 36228, 764, 1561, "Input",
 InitializationCell->True],
Cell[408318, 8209, 6567, 150, 253, "Input",
 InitializationCell->True]
}, Closed]],
Cell[CellGroupData[{
Cell[414922, 8364, 485, 7, 37, "Section",
 InitializationCell->True],
Cell[415410, 8373, 36261, 773, 1577, "Input",
 InitializationCell->True]
}, Closed]],
Cell[CellGroupData[{
Cell[451708, 9151, 231, 4, 37, "Section",
 InitializationCell->True],
Cell[451942, 9157, 95795, 2237, 2833, "Input",
 InitializationCell->True],
Cell[547740, 11396, 2469, 60, 88, "Input",
 InitializationCell->True]
}, Closed]],
Cell[CellGroupData[{
Cell[550246, 11461, 141, 2, 37, "Section",
 InitializationCell->True],
Cell[550390, 11465, 190, 5, 27, "Input",
 InitializationCell->True],
Cell[550583, 11472, 278, 7, 27, "Input",
 InitializationCell->True],
Cell[550864, 11481, 257, 6, 27, "Input",
 InitializationCell->True],
Cell[551124, 11489, 253, 6, 27, "Input",
 InitializationCell->True],
Cell[551380, 11497, 672, 16, 58, "Input",
 InitializationCell->True]
}, Closed]],
Cell[CellGroupData[{
Cell[552089, 11518, 358, 9, 37, "Section",
 InitializationCell->True],
Cell[552450, 11529, 5247, 117, 208, "Input",
 InitializationCell->True],
Cell[557700, 11648, 12707, 264, 1252, "Input",
 InitializationCell->True],
Cell[570410, 11914, 341, 10, 27, "Input",
 InitializationCell->True],
Cell[570754, 11926, 12265, 252, 479, "Input",
 InitializationCell->True],
Cell[583022, 12180, 17075, 357, 1183, "Input",
 InitializationCell->True],
Cell[600100, 12539, 29098, 637, 1128, "Input",
 InitializationCell->True]
}, Closed]],
Cell[CellGroupData[{
Cell[629235, 13181, 302, 5, 37, "Section",
 InitializationCell->True],
Cell[629540, 13188, 57644, 1268, 2231, "Input",
 InitializationCell->True],
Cell[687187, 14458, 178, 4, 27, "Input",
 InitializationCell->True]
}, Closed]]
}
]
*)

(* End of internal cache information *)
