
(*
  These tests cover the basic templates that are in DocuTools 
  If we get message errors from these,  we should fix, that might 
  show a mismatch between DocuTools and DocumentationBuild
*)

Needs[ "DocumentationBuild`"]
Needs["DocuTools`"]

docuToolsDir = DocuTools`Private`$AppDir

docsToolsBaseDir = 
	ToFileName[ {docuToolsDir, "FrontEnd"},"TextResources"]
	
language = "English"
	

Test[
	FileType[docsToolsBaseDir]
	,
	Directory
	,
	TestID->"DocuToolsConversion-20080207-W1F5M9"
]



(*
 Tests for the stylesheet of a converted notebook
*)	

testConvertDocuToolsNotebook1[ nbName_, entityTypeValue_, pageTypeValue_] :=
	Module[ {infFile, entityType, nbExpr, testExtra, inFile},
		testExtra = "_" <> nbName;
		inFile = ToFileName[ {docsToolsBaseDir}, nbName];
		Test[	
			FileType[inFile]
			,
			File
			,
			TestID->"DocuToolsConversion-20080207-X2S9V2" <> testExtra
		];
		Test[
			entityType = DocumentationBuild`Info`GetNotebookCategorization[inFile, "Entity Type"]
			,
			entityTypeValue
			,
			TestID->"DocuToolsConversion-20080207-J2R3G4" <> testExtra
		];
		Test[
			DocumentationBuild`Info`GetNotebookCategorization[inFile, "URI"]
			,
			"XXXX"
			,
			TestID->"DocuToolsConversion-20080207-X5H0P8" <> testExtra
		];
		Test[
			nbExpr = DocumentationBuild`Make`MakeNotebook[inFile];
			Head[nbExpr]
			,
			Notebook
			,
			TestID->"DocuToolsConversion-20080207-D5R8B6" <> testExtra
		];
		Test[
			DocumentationBuild`Info`GetNotebookFlag[nbExpr]
			,
			None
			,
			TestID->"DocuToolsConversion-20080212-X5H0P8" <> testExtra
		];
		Test[
			MatchQ[ nbExpr,  Notebook[ _, ___?OptionQ]] 
			,  
			True
			,
			TestID->"DocuToolsConversion-20080207-O7I3T4" <> testExtra
		];
		
		testStyleSheet[ testExtra, nbExpr, entityTypeValue];
	]


(*
 These definitions should ultimately move into a separate file of testing tools.
*)
generalDocStyleSheetExpr = FrontEnd`FileName[{"Wolfram"}, "Reference.nb"];
tutorialDocStyleSheetExpr = 
	Notebook[{Cell[
   		StyleData[
    		StyleDefinitions -> 
     			FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
  				Cell[StyleData["Input"], CellContext -> "Global`"], 
  				Cell[StyleData["Output"], CellContext -> "Global`"]}]


getNotebookOption[ testExtra_, nbExpr_, option_] :=
	Module[ {},
		Test[
			MatchQ[ nbExpr,  Notebook[ _, ___?OptionQ]] 
			,  
			True
			,
			TestID->"DocuToolsConversion-20080207-A4B6J4" <> testExtra
		];
		option /. Apply[ List, Drop[ nbExpr, 1]]
	]
	
(*
 Tests for the stylesheet of a converted notebook
*)	
testStyleSheet[ testExtra_, nbExpr_, entityType_] :=
	Module[ {styleDefs, styleExpr},
		styleDefs = getNotebookOption[ testExtra, nbExpr, StyleDefinitions];
		styleExpr = If[ entityType === "Tutorial", 
						tutorialDocStyleSheetExpr, generalDocStyleSheetExpr];
		Test[
			styleDefs
			,
			styleExpr
			,
			TestID->"DocuToolsConversion-20080207-T3D0W1" <> testExtra
		];
	]	
	

testConvertDocuToolsNotebook1[ "GuideBaseTemplateExt.nb", "Guide", "guides"]
testConvertDocuToolsNotebook1[ "TutorialBaseTemplateExt.nb", "Tutorial", "tutorials"]
testConvertDocuToolsNotebook1[ "FunctionBaseTemplateExt.nb", "Symbol", "functions"]

testConvertDocuToolsNotebook1[ "GuideBaseTemplate.nb", "Guide", "guides"]
testConvertDocuToolsNotebook1[ "TutorialBaseTemplate.nb", "Tutorial", "tutorials"]
testConvertDocuToolsNotebook1[ "FunctionBaseTemplate.nb", "Symbol", "functions"]


