

(*
  Tests of actual conversions,  these tests actually compare 
  notebooks.  If we get failures then this would mean that 
  DocumentationBuild is building a different result.  Since 
  this could be a source of errors we should track it down.
  
  Note that some of the tests don't really test the output, 
  but they *will* pick up any messages that are generated. 
  This is important.
  
*)

Needs[ "DocumentationBuild`"]

documentationToolsDir = DocumentationBuild`Common`$DocumentationBuildDirectory



(*
 Some file operation utilities
*)
mkdirTempDocsDir[] :=
	Module[ {tmp},
		tmp = CreateDirectory[];
		ToFileName[ tmp, "DocBuildTemp"]
	]
	
getFileNameSegment[filename_, num_] := 
	Module[{segs, pos = num}, 
		segs = StringSplit[filename, "/" | "\\"];
  		If[pos < 0, pos = Length[segs] + pos + 1];
  		If[pos < 1 || pos > Length[segs], 
  			$Failed, 
  			segs[[pos]]]
  	]

getFileNameSegments[filename_] := 
	StringSplit[filename, "/" | "\\"]
	

(*
  Canonicalize the notebook by stripping parts of it that 
  can change over time.  This includes the built metadata, 
  it also involves all the CellIDs. 
  
  TODO  check with Andy about stripping the CellIDs.
*)
canonicalizeNotebook[ nb_] :=
	Module[ {nbn},
		nbn = 
			Replace[ nb, 
				Notebook[ a1_, a2___, 
					TaggingRules -> 
						{b1___, "Metadata" -> { c1___, "built" -> _, c2___} , b2___}, a3___] ->
				Notebook[ a1, a2, 
					TaggingRules -> {b1, 
						"Metadata" -> { c1, c2}, b2}, a3]];
		nbn = Replace[ nbn,
				Notebook[ a1__, FrontEndVersion -> _,a2___] -> Notebook[a1,a2]];				
		nbn = Replace[ nbn,
				Notebook[ a1__, StyleDefinitions -> 
						Notebook[b1__, FrontEndVersion -> _,b2___],a2___] -> 
							Notebook[a1,StyleDefinitions ->Notebook[b1, b2], a2]];				
		nbn = Replace[ nbn,
				Notebook[ a1__, StyleDefinitions -> 
							FrontEnd`FileName[f1_, f2_,CharacterEncoding -> _], a2___] :> 
							Notebook[a1,StyleDefinitions ->
								FrontEnd`FileName[f1,f2], a2]];				
		nbn = nbn /. (CellID -> _) -> (CellID -> 1) ;			
		nbn
	]


(*
 Test function that compares the contents of two notebook files. 
 It checks that they are both notebooks and that they are both 
 equal,  it needs to canonicalize the notebook with canonicalizeNotebook.
*)	

testCompareDocumentationNotebook[ testExtra_, nbFile1_, nbFile2_] :=
	Module[ {nb1, nb2},
		Test[ 
			nb1 = Get[ nbFile1];
			nb1 = canonicalizeNotebook[ nb1];
			MatchQ[ nb1, Notebook[__]]
			,
			True
			,
			TestID->"DocuToolsConversion-20080213-T3W9U8" <> testExtra
		];
		Test[ 
			nb2 = Get[ nbFile2];
			nb2 = canonicalizeNotebook[ nb2];
			MatchQ[ nb2, Notebook[__]]
			,
			True
			,
			TestID->"DocuToolsConversion-20080213-O4K8R1" <> testExtra
		];
		Test[ 
			nb1
			,
			Evaluate[nb2]
			,
			TestID->"DocuToolsConversion-20080213-L0B2I4" <> testExtra
		];
	]



(*
  Runs a build for the notebooks found in rootDir, 
  this is pretty  similar to the build run by 
  BuildDocumentation.xml
*)

testBuild[ testExtra_, rootDir_] :=
	Module[ {inputDir, testDir, outputDir, indexDir, indexSpellDir, files},
		inputDir = ToFileName[ rootDir, "input"];
		testDir = ToFileName[ rootDir, "test"];
		outputDir = mkdirTempDocsDir[];
		indexDir = ToFileName[ outputDir, "Index"];
        Needs["DocumentationSearch`"];
		DocumentationBuild`indexer = DocumentationSearch`NewDocumentationNotebookIndexer[indexDir];
		Test[
			Head@DocumentationBuild`indexer
			,
			DocumentationNotebookIndexer
			,
			TestID->"DocuToolsConversion-20080212-Z0W8W1" <> testExtra
		];
		indexSpellDir = ToFileName[outputDir, "SpellIndex"];
		Print[files];
		Scan[ testFile[ testExtra, inputDir, outputDir, testDir, #]&, files];
		Test[
			DocumentationSearch`CloseDocumentationNotebookIndexer[DocumentationBuild`indexer]
			,
			Null
			,
			TestID->"DocuToolsConversion-20080213-P3F3V0" <> testExtra
		];
		Test[
			DocumentationSearch`CreateSpellIndex[indexDir, indexSpellDir]
			,
			Null
			,
			TestID->"DocuToolsConversion-20080213-P1T9V4" <> testExtra
		];
		Test[
			DeleteDirectory[outputDir, DeleteContents -> True]
			,
			Null
			,
			TestID->"BuildDocumentation-20080213-V2N8I2" <> testExtra
		];
		
	]
	
	
(*
 Do the actual build on one file
*)

testFile[ testExtraIn_, inputDir_, outputDir_, testDir_, inFile_] :=
	Module[ {testExtra, fname, entityType, outFile, 
				testFile, expr, res, metaData, plainText},
		fname = getFileNameSegment[ inFile, -1];
		testExtra = testExtraIn <> ":" <> fname;
		outFile = StringJoin[outputDir, StringReplace[inFile, {inputDir->""}] ];
		testFile = StringJoin[testDir, StringReplace[inFile, {inputDir->""}] ];
		entityType = DocumentationBuild`Info`GetNotebookCategorization[inFile, "Entity Type"];
		(*
		 Actually do the conversion
		*)
		Test[
			expr = DocumentationBuild`Make`MakeNotebook[inFile];
			Head[ expr]
			,
			Notebook
			,
			TestID->"DocuToolsConversion-20080212-X6O7J6" <> testExtra
		];
		Test[ 
			DocumentationBuild`Common`PubsEvaluateWithFE[
                    DocumentationBuild`Utils`FESaveNotebook[ outFile, expr]];
			,
			Null
			,
			TestID->"DocuToolsConversion-20080212-K9I4H7" <> testExtra
		];
		(*
		 Verify the converted notebook
		*)
		testCompareDocumentationNotebook[ testExtra, testFile, outFile];
		Test[
			plainText = Import[outFile, "Plaintext"];
			Head[ plainText]
			,
			String
			,
			TestID->"DocuToolsConversion-20080213-P6V8P1" <> testExtra
		];
		Test[
			metaData = DocumentationBuild`Utils`GetSearchMetaDataList[ expr];
			Head[metaData]
			,
			List
			,
			TestID->"DocuToolsConversion-20080213-K1Q5O2" <> testExtra
		];
		Test[
			DocumentationSearch`AddDocumentationNotebook[
                    DocumentationBuild`indexer, outFile];
			,
			Null
			,
			TestID->"DocuToolsConversion-20080213-D2H2Y8" <> testExtra
		];

 		
	]




(*
 These set up the build for the given input folder
*)
conversionBaseFolder = 
  ToFileName[ {documentationToolsDir, "Tests", "testdocs"}, "BasicExternal1"];
  
inputDir = 
  ToFileName[ {conversionBaseFolder, "Documentation"}, "English"];

language = "English"

rootDir = conversionBaseFolder;

Test[
	files = DocumentationBuild`Common`notebookFileNames[ ToFileName[ rootDir, "input"]];
	Sort[Map[Last[StringSplit[#, "/" | "\\"]] &, files]]
	,
	{"FunctionBaseTemplateExt.nb", "FunctionBaseTemplate.nb", 
	  "GuideBaseTemplateExt.nb", "GuideBaseTemplate.nb", 
	  "TutorialBaseTemplateExt.nb", "TutorialBaseTemplate.nb"}
	,
	TestID->"DocuToolsConversion-20080211-I8L5C5"
]

(*
 Run the build tests for the given input folder
*)


testBuild[ "_BasicExternal1", rootDir]







