#!/bin/sh


infiles='';
outdir='./';
basedir='';

function nearestdir {
    if [ "x$basedir" == "x" ]; then basedir=$1; return; fi;
    nbasedir='/';
    ndir=`(cd $1 && pwd)`'/';
    ndir=`echo $ndir | sed -e 's/\/\//\//g'`;
    for d in `echo $basedir | sed -e 's/\// /g'`; do
	this=$nbasedir$d'/';
	that=`echo $ndir | cut -c-${#this}`;
	if [ "x$this" == "x$that" ]; then
	    nbasedir=$this
	else
	    break;
	fi;
    done;
    basedir=$nbasedir;
}

i=0
while shift $i; do
    i=1;
    if [ "x$1" == "x-o" ]; then
	shift;
	outdir="$1";
    elif [ -f "$1" ]; then
	infiles=$infiles' '$1;
	nearestdir `dirname $1`;
    elif [ -d "$1" ]; then
	newfiles=`find $1 -name '*.nb'`;
	if [ "x$newfiles" != "x" ]; then
	    infiles=$infiles' '$newfiles;
	    nearestdir "$1";
	fi;
    fi;
done;

i=0;
numfiles=`echo $infiles | sed -e 's/ /\n/g' | wc -l`;
while [ $i -lt ${numfiles} ]; do
    tenfiles=`echo $infiles | cut -d' ' -f$(($i+1))-$((i+10))`
    ((i = i+10));
    for file in $tenfiles; do
	base=`basename $file | sed -e 's/\.nb//'`;
	fdir=`dirname $file`;
	fdir=`(cd $fdir && pwd)`'/';
	fdir=`echo $fdir | sed -e 's/\/\//\//g'`;
	if echo $fdir | grep -q '/English/'; then lang='.en';
	elif echo $fdir | grep -q '/Japanese/'; then lang='.ja';
	else lang=''; fi;
	aftdir=`echo $fdir | cut -c${#basedir}-`;
	echo $aftdir$base$lang
    done;
    (
	echo 'Needs["DocumentationBuild`"];';
	for file in $tenfiles; do
	    base=`basename $file | sed -e 's/\.nb//'`;
	    fdir=`dirname $file`;
	    fdir=`(cd $fdir && pwd)`'/';
	    fdir=`echo $fdir | sed -e 's/\/\//\//g'`;
	    if echo $fdir | grep -q '/English/'; then lang='.en';
	    elif echo $fdir | grep -q '/Japanese/'; then lang='.ja';
	    else lang=''; fi;
	    if echo $fdir | grep -q '/Guides/'; then func='MakeOnlineGuideNotebook';
	    elif echo $fdir | grep -q '/Tutorials/'; then func='MakeOnlineTutorialNotebook';
	    elif echo $fidr | grep -q '/Characters/'; then func='MakeOnlineCharacterNotebook';
	    elif echo $fdir | grep -q '/Formats/'; then func='MakeOnlineFormatNotebook';
	    elif echo $fdir | grep -q '/Messages/'; then func='MakeOnlineMessageNotebook';
	    else func='MakeOnlineSymbolNotebook'; fi;
	    aftdir=`echo $fdir | cut -c${#basedir}-`;
	    odir=$outdir$aftdir;
	    ps=$outdir$aftdir$base$lang'.ps';
	    mkdir -p $odir;
	    echo 'Developer`UseFrontEnd[';
	    echo 'nbo=NotebookPut['$func'["'$file'"]];';
	    echo 'SelectionMove[nbo,All,Notebook];';
	    echo 'FrontEndTokenExecute[nbo,"SelectionOpenAllGroups"];';
	    echo 'NotebookPrint[nbo,"'$ps'"];NotebookClose[nbo];';
	    echo 'LinkWrite[First@$FrontEnd, FrontEnd`Value["Time"]];';
	    echo 'LinkRead[First@$FrontEnd];';
	    echo '];'
	done;
    ) | math 2>&1 >/dev/null;
    for file in $tenfiles; do
	base=`basename $file | sed -e 's/\.nb//'`;
	fdir=`dirname $file`;
	fdir=`(cd $fdir && pwd)`'/';
	fdir=`echo $fdir | sed -e 's/\/\//\//g'`;
	if echo $fdir | grep -q '/English/'; then lang='.en';
	elif echo $fdir | grep -q '/Japanese/'; then lang='.ja';
	else lang=''; fi;
	aftdir=`echo $fdir | cut -c${#basedir}-`;
	odir=$outdir$aftdir;
	(cd $odir && ps2pdf $base$lang'.ps' && rm $base$lang'.ps')
    done;
done;
exit 0;
if [ -f "$srcdir" ]; then
    nbs="$srcdir";
    srcdir=`dirname $srcdir`;
else
    nbs=`find $srcdir -name '*.nb'`;
fi;

srclen=$((${#srcdir}+1));

for nb in $nbs; do
    aft=`echo $nb | cut -c${srclen}-`;
    aftdir=`dirname $outdir$aft`;
    mkdir -p $aftdir;
    base=`echo $outdir$aft | sed -e 's/\.nb//'`;
    ps=$base$lang'.ps';
    psfile=`basename $ps`;
    echo `basename $base`;
    (
	echo 'Needs["DocumentationBuild`"];';
	echo 'Developer`UseFrontEnd[';
	echo 'nbo=NotebookPut[MakeOnlineSymbolNotebook["'$nb'"]];';
	echo 'SelectionMove[nbo,All,Notebook];';
	echo 'FrontEndTokenExecute[nbo,"SelectionOpenAllGroups"];';
	echo 'NotebookPrint[nbo,"'$ps'"];NotebookClose[nbo];';
	echo 'LinkWrite[First@$FrontEnd, FrontEnd`Value["Time"]];';
	echo 'LinkRead[First@$FrontEnd];';
	echo '];'
    ) | math 2>&1 >/dev/null;
    (cd $aftdir && ps2pdf $psfile && rm $psfile);
done;
