// popup

// form is hidden initially in style sheet

$(document).ready(function() {
	// Write the form to the end of the body tag

	appendForm();

	// Initalize the form... clear values and make the form visible

	initForm();

	$('.openPopUpForm').click(function () {
		// Set the height of the gray overlay to the document height
		$('#feedbackpopOuter').height($(document).height());

		// Use the vCenter plugin to vertically/horizontally center the inner layer
		$('#feedbackpopInner').vCenter();   

		// Display the gray overlay and the inner layer
		//$('#feedbackpopOuter').show();
		$('#feedbackpopInner').show();

		// Put the cursor in the suggested field textarea
		//$("#suggested_field").focus();

		return false;
	});

	$('#closeButton').click(function () { 
		//$('#feedbackpopOuter').hide();
		$('#feedbackpopInner').hide();
		return false;
	});

    $('#feedbackFormform').submit(submitForm);
	function submitForm()
	{
		
		 // Start Validation //
		var error = "";
		var hasError = false;
                if (!$('#suggested_field').val())
                {
                       	hasError = true;
			$('#suggested_field').css("backgroundColor","#FFEFEF");
                }

		if (!$('#first_name').val())
                {
                        hasError = true;
			$('#first_name').css("backgroundColor","#FFEFEF");
                }

		if (!$('#last_name').val())
                {
			hasError = true;
                        $('#last_name').css("backgroundColor","#FFEFEF");
                }

		if (!$('input[name="captcha_sum"]').val())
		{
			hasError = true;
			$('input[name="captcha_sum"]').css("backgroundColor", "#FFEFEF");
		}

		if(hasError)
		{
			error = "Please fill out all required fields.<br>";
		}

                var emailRegex = new RegExp('^(.*)@(.*)\.[a-zA-Z]+$');
        
                if(!$('#email').val().match(emailRegex))
                {
                        error = error + "Please give a valid email address.<br>";
                        $('#email').css("backgroundColor","#FFEFEF");
                }

                if(error.length > 0)
                {
                    $('#feedbackError').html(error);
                    return false;
                }
                // End Validation //

		// Hide the form and display a message saying the form is being processed
		$('#feedbackFormfull').hide();
		$('#feedbackComments').show();
		$("#feedbackComments").html('Processing...');

		// Put together the string of inputs
		var inputs = 'suggested_field=' + $('#suggested_field').val() +
					'&question=' + $('#question').val() +
					'&first_name=' + $('#first_name').val() +
					'&last_name=' + $('#last_name').val() +
					'&email=' + $('#email').val() +
                    '&captcha_sum=' + $('input[name="captcha_sum"]').val() + 
                    '&captcha_key=' + $('input[name="captcha_key"]').val();

//
	var captchaFail = false;


		// The AJAX request that processes the form
        jQuery.ajax
		({
			type: "POST",
		    url: "includes/submit.cgi",
            data: inputs,
            timeout: 5000,
            error: function()
			{
                $("#feedbackComments").html("There was a problem, please try again " );
            },
            success: function(r)
			{
		//looking to match the successful submission message
		var tyRegex = new RegExp('Thank you');
		if(!r.match(tyRegex)) {
			captchaFail = true;
			error = "Incorrect answer to anti-spam question";
		}
	        $("#feedbackComments").html(r);
		
            }
        });
		// Wait 4 seconds to hide the inner and outer div and reinitialize form
		$('#feedbackComments').animate({ opacity: 1.0}, 4000, 'linear', function ()
		{
			if(captchaFail)
				resumeForm();
			else
				initForm();
			$("#feedbackFormform").bind("submit", submitForm);
		});
		

        // Return false so it doesn't redirect the user.
        return false;
    }
});

//Hide divs, set form element background colors to white
//Make the form visible, try to retain info
function resumeForm()
{
	$("#feedbackFormform").each(function() {
          $(':input', this).css("backgroundColor", "#FFFFFF");
	});

        // Hide the comments and clear the html
        $('#feedbackComments').hide();
        $("#feedbackComments").html('');

        // Clear the error html
        //$("#feedbackError").html('');
	$("#feedbackError").html('Incorrect answer to anti-spam question.<br>');

        // Generate the Captcha

        $.get("/solutions/includes/captcha.cgi", function(data){
                $("#captcha").html(data);
                $(".comment").prepend("<span class=\"required\">*</span>&nbsp;");
		$('input[name="captcha_sum"]').css("backgroundColor", "#FFEFEF");
        });

        // Make the form visible
        $('#feedbackFormfull').show();
}

// Hide divs, clears the form, sets form element background colors to white
// Make the form visible
function initForm()
{
	// Clear the form
	$.fn.clearForm = function() {
	  return this.each(function() {
		var type = this.type, tag = this.tagName.toLowerCase();
		if (tag == 'form')
		  return $(':input',this).clearForm();
		if (type == 'text' || type == 'password' || tag == 'textarea')
		  this.value = '';
		else if (type == 'checkbox' || type == 'radio')
		  this.checked = false;
		else if (tag == 'select')
		  this.selectedIndex = -1;

		this.style.backgroundColor="#FFFFFF";
	  });
	};
	
	// Hide the outer and inner divs
	//$('#feedbackpopOuter').hide();
	$('#feedbackpopInner').hide();

	// Hide the comments and clear the html
	$('#feedbackComments').hide();
	$("#feedbackComments").html('');

	// Clear the error html
	$("#feedbackError").html('');

	// Clear all the form elements

	$(':input').clearForm()

    // Generate the Captcha
//    $("#captcha").load("/solutions/includes/captcha.cgi"); 
	
	$.get("/solutions/includes/captcha.cgi", function(data){
		$("#captcha").html(data);
		$(".comment").prepend("<span class=\"required\">*</span>&nbsp;");
	});


	// Make the form visible
	$('#feedbackFormfull').show();
}

// Append the outer, inner divs, close button, comments to the body

// Append the feedback form to the body

function appendForm()
{
	$('body').append(
	//'<div id="feedbackpopOuter"></div>\n' +
    '<div id="feedbackpopInner">\n' +
    ' 	<div id="closeButton"><img src="/solutions/images/solutions/closebutton.gif" title="close window" alt="close window"></div>\n' +
    '	<div id="feedbackComments"></div>\n' +
    '	<div id="feedbackFormfull">\n' +
    '		<form id="feedbackFormform">\n' +
    '			<h3 id="feedbackTitle">Suggestions & Feedback</h3>\n' +
    '			<hr class="feedbackRule" />\n' +
    '				<div id="feedbackError" class="error"></div>\n' +
    '				<table id="feedbackTable" border="0">\n' +
    '					<tr>\n' +
    '						<td>\n' +
    '							<span class="required">*</span>&nbsp;<span class="feedbackFieldTitle">Suggest&nbsp;a&nbsp;field:</span>\n' +
    '						</td>\n' + 
    '						<td>\n' +
    '							<input class="textbox" type="text" id="suggested_field" name="suggested_field">\n' +
    '						</td>\n' +
    '					</tr>\n' +
    '					<tr>\n' +
    '						<td colspan="2" class="alignLeft">\n' +
    '							<span class="feedbackFieldTitle">Questions and comments:</span><br />\n' +
    '							<textarea class="feedback_textarea" cols="50" rows="5" id="question" name="question"></textarea>\n' +
    '						</td>\n' +
    '					</tr>\n' +
    '					<tr>\n' +
    '					<td>\n' +
    '							<span class="required">*</span>&nbsp;<span class="feedbackFieldTitle">First&nbsp;name:</span>\n' +
    '						</td>\n' +
    '						<td>\n' +
    '							<input class="textbox" type="text" id="first_name" name="first_name">\n' +
    '						</td>\n' +
    '					</tr>\n' +
    '					<tr>\n' +
    '						<td>\n' +
    '							<span class="required">*</span>&nbsp;<span class="feedbackFieldTitle">Last&nbsp;name:</span>\n' +
    '						</td>\n' +
    '						<td>\n' +
    '							<input class="textbox" type="text" id="last_name" name="last_name">\n' +
    '						</td>\n' +
    '					</tr>\n' +
    '					<tr>\n' +
    '						<td>\n' +
    '							<span class="required">*</span>&nbsp;<span class="feedbackFieldTitle">Email:</span>\n' +
    '						</td>\n' +
    '						<td>\n' +
    '							<input class="textbox" type="text" id="email" name="email">\n' +
    '						</td>\n' +
    '					</tr>\n' +
    '               </table>\n' +
    '               <table id="submitTable" border="0">\n' +
    '					<tr id="submitRow">\n' +
    '						<td>\n' +
    '							<div id="captcha"></div>\n' +
    '						</td>\n' +
    '						<td>\n' +
    '							<input id="feedbackFormform" type="image" name="submit" value="submit" src="/solutions/images/solutions/sendbutton_blue.gif" alt="Send" title="Send" border="0">\n' +
    '						</td>\n' +
    '					</tr>\n' +
    '					<tr>\n' +
    '						<td colspan="2">\n' +
    '							<span class="required">*</span>&nbsp;<b>Note:</b> Required field\n' +
    '						</td>\n' +
    '					</tr>\n' +
    '				</table>\n' +
    '		</form>\n' +
    '	</div>\n');



}
