/*
* jquery.simpleslide.js
* A relatively simplistic plugin to allow pages to make simple image
* 'slideshow' elements.
* jschoenick@wolfram.com 3/26/09
*/

// elements - an array of image URLs - ex. ['./img1.png', './img2.png']
// options (optional) 
//	- a hash of options, see first bit of function for definable options.
jQuery.simpleSlide = function(elements, options)
{
	var obj = jQuery.extend(
	{
		autoTransition : 3000, // milliseconds, 0 for off
		loopForever : false, // Default behavior is to stop autoTransition-ing after one loop
		fadeTime : 1000, // milliseconds for a complete fade, 0 for instant
		switchBoxClass : null,
		switchBoxClassActive : null,
		switchBoxContent : '',
		switchBoxWrapper : null, // an object that the list of switchboxes will be prepended into.
		// The following are used internally and shouldn't be set as
		// options unless you know what you are doing
		
		hasLooped : false,
		switching : false,
		eleList : elements,
		switchBoxes : new Array(),
		eleIndex : 0,
		pendingThink : null,
		resetThink : function()
		{
			var obj = this;
			if (obj.pendingThink)
			{
				window.clearTimeout(obj.pendingThink);
				obj.pendingThink = null;
			}
			if (obj.autoTransition)
				obj.pendingThink = window.setTimeout(function() { obj.think() }, obj.autoTransition);
		},
		finishSwitch : function()
		{
			var obj = this;
			obj.switchBoxes[obj.eleIndex].addClass(obj.switchBoxClassActive);
			var ele = $(obj.eleList[obj.eleIndex]);
			ele.fadeIn(obj.fadeTime/2);
			obj.switching = false;
		},
		switchTo : function(index)
		{
			var obj = this;
			if (!obj.switching)
			{
				obj.switching = true;
				var ele = $(obj.eleList[obj.eleIndex]);
				obj.switchBoxes[obj.eleIndex].removeClass(obj.switchBoxClassActive);
				obj.eleIndex = index;
				ele.fadeOut(obj.fadeTime/2, function () { obj.finishSwitch() });
			}
		},
		think : function()
		{
			var obj = this;
			if (obj.autoTransition && ((obj.loopForever == true) || (obj.hasLooped == false)))
			{
				if (obj.eleList.length <= obj.eleIndex + 1)
				{
					obj.switchTo(0);
					obj.hasLooped = true;
				}
				else
					obj.switchTo(obj.eleIndex + 1);
			}
			obj.resetThink();
		}
	}, options);
	
	if (obj.switchBoxWrapper)
	{
		// create switchBoxes
		for (var i in obj.eleList)
		{
			i = parseInt(i);
			var img = obj.eleList[i];
			var newObj = $('<div>' + obj.switchBoxContent + '<!-- -->' + '</div>');
			newObj.data('simpleslide_index', i);
			newObj.data('simpleslide_obj', obj);
			newObj.click(function ()
			{
				var obj = $(this).data('simpleslide_obj');
				var idx = $(this).data('simpleslide_index');
				if (idx != obj.eleIndex)
					obj.switchTo(idx);
				obj.resetThink();
			});
			newObj.addClass(obj.switchBoxClass);
			if (i == 0)
				newObj.addClass(obj.switchBoxClassActive);
			newObj.appendTo(obj.switchBoxWrapper);
			obj.switchBoxes[i] = newObj;
		}
	}
	
	obj.resetThink();
	return obj;
};

