#!/usr/local/bin/perl

# PURPOSE: Contact form for Solutions Fields Inquiry

use strict;


#---------------------------- INCLUDES -------------------------
use strict;
use lib qw(/www/proj/libs);
use CGI;
use WRI::WebForms;
use WRI::Captcha;
use Data::Dumper;



#--------------------------- VARIABLES -------------------------

my $formname              = 'Solutions_Fields_Inquiry';
my $sub_email             = 'solutionsfeedback@wolfram.com'; # Email address for form submissions
#my $sub_email             = 'seanj@wolfram.com'; # Email address for form submissions
my $view_submissions_url	= qq(https://bizi.wolfram.com/wbi/webforms/formData.cgi?formname=Solutions_Fields_Inquiry);
my $form = CGI->new->Vars;
my $sid  = $form->{'sid'} || '';
my $webform = WRI::WebForms->new('prd');

my $referer;
if (!$ENV{HTTP_REFERER} && !$form->{'referer'})
{
	$referer = "No referer";
} 
else
{
	$referer = $form->{'referer'} || $ENV{HTTP_REFERER};
}

my $type = $form->{'type'} || $ENV{QUERY_STRING};
#-------------------------- MAIN CODE --------------------------



print qq(Content-type: text/html\n\n);

unless ($form->{submit}) {
	print_head();
	print_form();
} else {
	# validate data - check for url in comment field, check required fields, check for valid email address
	my $errors = checkValid($form);

	if (keys %$errors) { 
		print_head();
		print_form($form,$errors);
	} else {	
		$sid = $webform->insertSubmissions($formname, $form);
		send_email($form,$sid);
		print_head();
		print_thankyou();
}
}
	
#---------------------------- INCLUDES -------------------------


sub print_head {
	print <<EOF;
	
<html>
<head>
<title>
Mathematica Solutions: Suggest a Field
</title>
<meta name="description" content="Suggest a new field for Mathematica Solutions">
</head>
<body>

EOF
}

sub print_form {
    my ($form, $errors) = @_;
    
    print <<EOF;
	<h1>SUGGEST A FIELD</h1>
<div id="content">


<table cellpadding=0 cellspacing=0 border=0> <tr> <td valign=top>
  <div class="object">
    <form method="post">
    <div class="subBox">


      <div class="dl_field1">$errors->{'suggested_field'}<span class="required">*</span>Suggest a field&nbsp;&nbsp;<input type="text" name="suggested_field" value="$form->{'suggested_field'}"></div>

      <div class="dl_comm_bar">$errors->{'question'}
        Questions and comments:<br><textarea cols="50" rows="5" name="question">$form->{'question'}</textarea>
      </div>

      <hr>
			
      <div class="dl_field1">$errors->{'first_name'}<span class="required">*</span>First name&nbsp;&nbsp;<input type="text" name="first_name" value="$form->{'first_name'}"></div>
      <div class="dl_field1">$errors->{'last_name'}<span class="required">*</span>Last name&nbsp;&nbsp;<input type="text" name="last_name" value="$form->{'last_name'}"></div>
      <div class="dl_field1">$errors->{'email'}<span class="required">*</span>Email&nbsp;&nbsp;<input type="text" name="email" value="$form->{'email'}"></div>


      <div class="dl_submit">


$errors->{'Captcha'}
EOF
	print WRI::Captcha->new()->printform();
	print <<EOF;

      <input type="hidden" name="submit" value="submit">
      <input type="hidden" name="referer" value="$referer">
      <input type="hidden" name="type" value="$type">
	  <input class="submit" type="image" name="submit" value="submit" src="images/solutions/sendbutton_blue.gif" alt="Send" title="Send" border="0">
      <br><br></div>
    </div>
   </form>
  </div>
</tr> </table>
<p><span class="required"><b>*</b></span><b>Note:</b> Required field</p>
</div>
EOF
}

sub send_email {
    my ($form,$sid) = @_;

    my $message = qq(
First name: $form->{'first_name'}
Last name: $form->{'last_name'}
Email: $form->{'email'}
Suggested Field: $form->{'suggested_field'}
Question: $form->{'question'}
   	); 

	$message .= "\nRemoteAddress: $ENV{REMOTE_ADDR}\n";
	$message .= "Time: " . `date` . "\n\r";
	$message .= "\nAll current submissions can be viewed at:\r";
	$message .= "https://bizi.wolfram.com/wbi/webforms/formData.cgi/$formname\n\r";

	my $SUBJECT = "$formname SID: $sid";
    my $SENDMAIL = '/usr/sbin/sendmail';

   	open(MAIL, "| $SENDMAIL -ti") || die "Error opening sendmail: $!";
   	my $sel = select(MAIL);

    print <<EOF;
To: $sub_email
From: $formname <webmaster>
Subject: $SUBJECT

$message

This email is generated automatically by a web form at:
http://$ENV{HTTP_HOST}$ENV{SCRIPT_NAME}

EOF

	select ($sel);
	close(MAIL);
    	
}


sub print_thankyou {
    print <<EOF;
<h1>SUGGEST A FIELD</h1>
<p>
<b>Thank you for your submission. You will receive an individualized response from Wolfram Research.</b>
</p>
<p>
Click <a href="/solutions/">here</a> to return to the <i>Mathematica</i> Solutions home page.
</p>
EOF
}

sub checkValid{
    my $form = shift @_;

	my @ordered_req = (
		'first_name',
		'last_name',
		'email',
        'suggested_field'
	);
	
#	my @all_fields = (
#		'first_name',
#		'last_name',
#		'organization',
#		'email',
#		'country',
#		'affiliation',
#		'phone',
#		'question'
#	);

	my $errors = {};

	my $standard_error = qq(<br><img src="/common/images/error.gif" height="12" width="12" hspace="1" alt="Error"> <b><font color="#bb0000" class="smalltext">This field must be completed</font></b><br>);

	unless (WRI::Captcha->new($form->{'captcha_key'})->check($form->{'captcha_sum'})) {
		$errors->{'Captcha'} = qq(<img src="/common/images/error.gif" height="12" width="12" hspace="1" alt="Error"> <b><font color="#bb0000" class="smalltext">Incorrect answer to anti-spam question</font></b><br>);
	}

	unless (($form->{'email'}) && (($form->{'email'}) =~ /\S+\@\S+\.\S+/g) && !(($form->{'email'}) =~ ('\n'))){
	    $errors->{'email'}= qq(<img src="/common/images/error.gif" height="12" width="12" hspace="1" alt="Error"> <b><font color="#bb0000" class="smalltext">Please enter a valid email address</font></b><br>);           
	}

	foreach my $req_name(@ordered_req) {
	    $errors->{$req_name} = $standard_error unless($form->{$req_name});
	}

	return ($errors);
}
