(* ::Package:: *)

ANOVA`ANOVA::usage = "\!\(\*RowBox[{\"ANOVA\", \"[\", StyleBox[\"data\", \"TI\"], \"]\"}]\) performs a one\[Hyphen]way analysis of variance.\n\!\(\*RowBox[{\"ANOVA\", \"[\", RowBox[{StyleBox[\"data\", \"TI\"], \",\", StyleBox[\"model\", \"TI\"], \",\", StyleBox[\"vars\", \"TI\"]}], \"]\"}]\) performs an analysis of variance for \!\(\*StyleBox[\"model\", \"TI\"]\) as a function of the categorical variables \!\(\*StyleBox[\"vars\", \"TI\"]\)."
ANOVA`Bonferroni::usage = "Bonferroni is a possible value for the PostTests option for ANOVA."
ANOVA`CellMeans::usage = "CellMeans is an option for ANOVA which specifies whether cell means should be included in the output."
ANOVA`Duncan::usage = "Duncan is a possible value for the PostTests option for ANOVA."
ANOVA`Dunnett::usage = "Dunnett is a possible value for the PostTests option for ANOVA."
ANOVA`PostTests::usage = "PostTests is an option for ANOVA that specifies which significance tests to perform."
ANOVA`StudentNewmanKeuls::usage = "StudentNewmanKeuls is a possible value for the PostTests option for ANOVA."
ANOVA`Tukey::usage = "Tukey is a possible value for the PostTests option for ANOVA."
Audio`AmplitudeModulation::usage = "\!\(\*RowBox[{\"AmplitudeModulation\", \"[\", RowBox[{SubscriptBox[StyleBox[\"f\", \"TI\"], StyleBox[\"c\", \"TI\"]], \",\", SubscriptBox[StyleBox[\"f\", \"TI\"], StyleBox[\"m\", \"TI\"]], \",\", SubscriptBox[StyleBox[\"m\", \"TI\"], StyleBox[\"i\", \"TI\"]], \",\", StyleBox[\"dur\", \"TI\"]}], \"]\"}]\) creates a Sound object that is an amplitude modulated sinusoid, having carrier and modulating frequencies \!\(\*SubscriptBox[StyleBox[\"f\", \"TI\"], StyleBox[\"c\", \"TI\"]]\) and \!\(\*SubscriptBox[StyleBox[\"f\", \"TI\"], StyleBox[\"m\", \"TI\"]]\), measured in hertz, a modulation index of \!\(\*SubscriptBox[StyleBox[\"m\", \"TI\"], StyleBox[\"i\", \"TI\"]]\), and a duration of \!\(\*StyleBox[\"dur\", \"TI\"]\) seconds.\n\!\(\*RowBox[{\"AmplitudeModulation\", \"[\", RowBox[{SubscriptBox[StyleBox[\"f\", \"TI\"], StyleBox[\"c\", \"TI\"]], \",\", SubscriptBox[StyleBox[\"f\", \"TI\"], StyleBox[\"m\", \"TI\"]], \",\", SubscriptBox[StyleBox[\"m\", \"TI\"], StyleBox[\"i\", \"TI\"]], \",\", StyleBox[\"dur\", \"TI\"], \",\", RowBox[{\"RingModulation\", \"->\", \"True\"}]}], \"]\"}]\) creates a ring modulated sinusoid"
Audio`Cascade::usage = "Cascade is a setting of ModulationType, an option of function FrequencyModulation. "
Audio`FrequencyModulation::usage = "\!\(\*RowBox[{\"FrequencyModulation\", \"[\", RowBox[{SubscriptBox[StyleBox[\"f\", \"TI\"], StyleBox[\"c\", \"TI\"]], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"f\", \"TI\"], StyleBox[\"m\", \"TI\"]], \",\", StyleBox[\"pd\", \"TI\"]}], \"}\"}], \",\", StyleBox[\"dur\", \"TI\"]}], \"]\"}]\) creates a Sound object that is a frequency-modulated sinusoid, having carrier and modulating frequencies \!\(\*SubscriptBox[StyleBox[\"f\", \"TI\"], StyleBox[\"c\", \"TI\"]]\) and \!\(\*SubscriptBox[StyleBox[\"f\", \"TI\"], StyleBox[\"m\", \"TI\"]]\), measured in hertz, peak deviation \!\(\*StyleBox[\"pd\", \"TI\"]\) hertz, and a duration of \!\(\*StyleBox[\"dur\", \"TI\"]\) seconds.\n\!\(\*RowBox[{\"FrequencyModulation\", \"[\", RowBox[{SubscriptBox[StyleBox[\"f\", \"TI\"], StyleBox[\"c\", \"TI\"]], \",\", RowBox[{\"{\", RowBox[{RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"f\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"pd\", \"TI\"], StyleBox[\"1\", \"TR\"]]}], \"}\"}], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"f\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"pd\", \"TI\"], StyleBox[\"2\", \"TR\"]]}], \"}\"}], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \",\", StyleBox[\"dur\", \"TI\"], \",\", RowBox[{\"ModulationType\", \"->\", \"Cascade\"}]}], \"]\"}]\) creates a cascade frequency-modulated sinusoid, where \!\(\*SubscriptBox[StyleBox[\"pd\", \"TI\"], StyleBox[\"i\", \"TI\"]]\) is the peak deviation associated with modulating frequency \!\(\*SubscriptBox[StyleBox[\"f\", \"TI\"], StyleBox[\"i\", \"TI\"]]\).\n\!\(\*RowBox[{\"FrequencyModulation\", \"[\", RowBox[{SubscriptBox[StyleBox[\"f\", \"TI\"], StyleBox[\"c\", \"TI\"]], \",\", RowBox[{\"{\", RowBox[{RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"f\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"pd\", \"TI\"], StyleBox[\"1\", \"TR\"]]}], \"}\"}], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"f\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"pd\", \"TI\"], StyleBox[\"2\", \"TR\"]]}], \"}\"}], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \",\", StyleBox[\"dur\", \"TI\"], \",\", RowBox[{\"ModulationType\", \"->\", \"Parallel\"}]}], \"]\"}]\) creates a parallel frequency-modulated sinusoid, where \!\(\*SubscriptBox[StyleBox[\"pd\", \"TI\"], StyleBox[\"i\", \"TI\"]]\) is the peak deviation associated with modulating frequency \!\(\*SubscriptBox[StyleBox[\"f\", \"TI\"], StyleBox[\"i\", \"TI\"]]\)."
Audio`ListWaveform::usage = "\!\(\*RowBox[{\"ListWaveform\", \"[\", RowBox[{RowBox[{\"{\", RowBox[{RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"f\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"a\", \"TI\"], StyleBox[\"1\", \"TR\"]]}], \"}\"}], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"f\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"a\", \"TI\"], StyleBox[\"2\", \"TR\"]]}], \"}\"}], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \",\", StyleBox[\"freq\", \"TI\"], \",\", StyleBox[\"dur\", \"TI\"]}], \"]\"}]\) creates a Sound object with fundamental frequency of \!\(\*StyleBox[\"freq\", \"TI\"]\) hertz, lasting for \!\(\*StyleBox[\"dur\", \"TI\"]\) seconds, with a spectrum in which relative frequency \!\(\*SubscriptBox[StyleBox[\"f\", \"TI\"], StyleBox[\"i\", \"TI\"]]\) has relative amplitude \!\(\*SubscriptBox[StyleBox[\"a\", \"TI\"], StyleBox[\"i\", \"TI\"]]\)."
Audio`ModulationType::usage = "ModulationType is an option of FrequencyModulation, specifying the type of modulation."
Audio`Overtones::usage = "Overtones is an option to Waveform that specifies the number of overtones to be present in a standard waveform when created with Fourier summation."
Audio`Parallel::usage = "Parallel is a setting of ModulationType, an option of function FrequencyModulation. "
Audio`RingModulation::usage = "RingModulation is an option to AmplitudeModulation which specifies whether to use ring modulation. "
Audio`Ring::usage = "Ring is an an option to AmplitudeModulation."
Audio`Sawtooth::usage = "Sawtooth is a type of waveform."
Audio`Sinusoid::usage = "Sinusoid is a type of waveform."
Audio`Square::usage = "Square is a type of waveform."
Audio`Standard::usage = "Standard is a setting of ModulationType, an option of function FrequencyModulation."
Audio`Triangle::usage = "Triangle is a type of waveform."
Audio`Waveform::usage = "\!\(\*RowBox[{\"Waveform\", \"[\", RowBox[{StyleBox[\"type\", \"TI\"], \",\", StyleBox[\"freq\", \"TI\"], \",\", StyleBox[\"dur\", \"TI\"]}], \"]\"}]\) creates a Sound object that is a standard waveform of type \!\(\*StyleBox[\"type\", \"TI\"]\), having a fundamental frequency of \!\(\*StyleBox[\"freq\", \"TI\"]\) hertz, and a duration of \!\(\*StyleBox[\"dur\", \"TI\"]\) seconds."
BarCharts`BarChart3D::usage = "\!\(\*RowBox[{\"BarChart3D\", \"[\", RowBox[{\"{\", RowBox[{RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"z\", \"TI\"], StyleBox[\"11\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"z\", \"TI\"], StyleBox[\"12\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"z\", \"TI\"], StyleBox[\"21\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"z\", \"TI\"], StyleBox[\"22\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \"]\"}]\) generates a three-dimensional bar chart using the matrix of heights \!\(\*SubscriptBox[StyleBox[\"z\", \"TI\"], StyleBox[\"ij\", \"TI\"]]\).\n\!\(\*RowBox[{\"BarChart3D\", \"[\", RowBox[{\"{\", RowBox[{RowBox[{\"{\", RowBox[{RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"z\", \"TI\"], StyleBox[\"11\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"style\", \"TI\"], StyleBox[\"11\", \"TR\"]]}], \"}\"}], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \"]\"}]\) uses a specific style for each bar.\n\!\(\*RowBox[{\"BarChart3D\", \"[\", RowBox[{\"{\", RowBox[{RowBox[{\"{\", RowBox[{RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"y\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"z\", \"TI\"], StyleBox[\"1\", \"TR\"]]}], \"}\"}], \",\", SubscriptBox[StyleBox[\"style\", \"TI\"], StyleBox[\"1\", \"TR\"]]}], \"}\"}], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \"]\"}]\) generates a bar chart of bars scattered at specific \!\(\*StyleBox[\"x\", \"TI\"]\) and \!\(\*StyleBox[\"y\", \"TI\"]\) coordinates with height \!\(\*StyleBox[\"z\", \"TI\"]\) and a specific \!\(\*StyleBox[\"style\", \"TI\"]\)."
BarCharts`BarChart::usage = "\!\(\*RowBox[{\"BarChart\", \"[\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"y\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"y\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \"]\"}]\) generates a bar chart of the values \!\(\*RowBox[{SubscriptBox[StyleBox[\"y\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"y\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}]\).\n\!\(\*RowBox[{\"BarChart\", \"[\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"list\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"list\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TI\"]}], \"}\"}], \"]\"}]\) generates a bar chart of the data in the lists."
BarCharts`BarEdges::usage = "BarEdges is an option for bar charts that determines whether edges are to be drawn around the bars."
BarCharts`BarEdgeStyle::usage = "BarEdgeStyle is an option for bar charts that determines the style for the edges."
BarCharts`BarGroupSpacing::usage = "BarGroupSpacing is an option for BarChart that determines the spacing between groups of bars."
BarCharts`BarLabels::usage = "BarLabels is an option for BarChart, StackedBarChart, and PercentileBarChart, that allows a label to be placed at the tick mark for each bar (or group of bars for multiple data sets). Labels are specified in a list."
BarCharts`BarOrientation::usage = "BarOrientation is an option for BarChart that determines whether the bars are oriented vertically or horizontally."
BarCharts`BarSpacing::usage = "BarSpacing is an option for bar charts that determines the fraction of the bar width to space the bars in a group of bars."
BarCharts`BarStyle::usage = "BarStyle is an option for bar charts that determines the default style for the bars. "
BarCharts`BarValues::usage = "BarValues is an option for BarChart and GeneralizedBarChart that allows the length of the bar to be displayed above each bar."
BarCharts`GeneralizedBarChart3D::usage = "\!\(\*RowBox[{\"GeneralizedBarChart3D\", \"[\", RowBox[{\"{\", RowBox[{RowBox[{\"{\", RowBox[{RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"xpos\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"ypos\", \"TI\"], StyleBox[\"1\", \"TR\"]]}], \"}\"}], \",\", SubscriptBox[StyleBox[\"height\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"xwidth\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"ywidth\", \"TI\"], StyleBox[\"1\", \"TR\"]]}], \"}\"}]}], \"}\"}], \",\", RowBox[{\"{\", RowBox[{RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"xpos\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"ypos\", \"TI\"], StyleBox[\"2\", \"TR\"]]}], \"}\"}], \",\", SubscriptBox[StyleBox[\"height\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"xwidth\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"ywidth\", \"TI\"], StyleBox[\"2\", \"TR\"]]}], \"}\"}]}], \"}\"}], \",\", StyleBox[\"\[Ellipsis]\", \"TI\"]}], \"}\"}], \"]\"}]\) generates a three-dimensional bar chart with the solid bars at the given positions, heights, and widths."
BarCharts`GeneralizedBarChart::usage = "\!\(\*RowBox[{\"GeneralizedBarChart\", \"[\", RowBox[{\"{\", RowBox[{RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"pos\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"height\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"width\", \"TI\"], StyleBox[\"1\", \"TR\"]]}], \"}\"}], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"pos\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"height\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"width\", \"TI\"], StyleBox[\"2\", \"TR\"]]}], \"}\"}], \",\", RowBox[{StyleBox[\"\[Ellipsis]\", \"TR\"], RowBox[{\"}\", \"]\"}]}]}]}]}]\) generates a bar chart with the bars at the given positions, and with given heights and widths.\n\!\(\*RowBox[{\"GeneralizedBarChart\", \"[\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"list\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"list\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], StyleBox[\"}\", \"TR\"]}], \"]\"}]\) generates a bar chart from lists of data."
BarCharts`PercentileBarChart::usage = "\!\(\*RowBox[{\"PercentileBarChart\", \"[\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"list\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"list\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \"]\"}]\) generates a stacked bar chart of the data in the lists. The data for each group of bars is scaled so that the sum of the absolute values in a group of bars is 1."
BarCharts`StackedBarChart::usage = "\!\(\*RowBox[{\"StackedBarChart\", \"[\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"list\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"list\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \"]\"}]\) generates a stacked bar chart of the data in the lists."
Benchmarking`Benchmark::usage = "\!\(\*RowBox[{\"Benchmark\", \"[\", \"]\"}]\) runs the \!\(\*StyleBox[\"MathematicaMark6\", FontSlant -> \"Italic\"]\) benchmark. "
Benchmarking`BenchmarkReport::usage = "\!\(\*RowBox[{\"BenchmarkReport\", \"[\", \"]\"}]\) runs the \!\(\*StyleBox[\"MathematicaMark6\", FontSlant -> \"Italic\"]\) benchmark and produces a report in a separate notebook comparing this system to a selection of reference systems. \n\!\(\*RowBox[{\"BenchmarkReport\", \"[\", RowBox[{SubscriptBox[StyleBox[\"system\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"system\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"], \",\", SubscriptBox[StyleBox[\"data\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"data\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) produces a custom report comparing the specified systems from $BenchmarkSystems and the specified data returned from Benchmark."
Benchmarking`$BenchmarkSystems::usage = "$BenchmarkSystems gives the names of systems for which the \!\(\*StyleBox[\"MathematicaMark6\", FontSlant -> \"Italic\"]\) benchmark data is known."
BlackBodyRadiation`BlackBodyProfile::usage = "\!\(\*RowBox[{\"BlackBodyProfile\", \"[\", RowBox[{SubscriptBox[StyleBox[\"temp\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"temp\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TI\"]}], \"]\"}]\) generates a plot of black-body spectral distribution profiles at the specified temperatures \!\(\*RowBox[{SubscriptBox[StyleBox[\"temp\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"temp\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}]\)."
BlackBodyRadiation`MaxPower::usage = "\!\(\*RowBox[{\"MaxPower\", \"[\", RowBox[{StyleBox[\"temp\", \"TI\"], \",\", StyleBox[\"band\", \"TI\"]}], \"]\"}]\) gives the radiative power emitted by a black body in the specified wavelength band \!\(\*StyleBox[\"band\", \"TI\"]\) about the peak wavelength, at the specified temperature \!\(\*StyleBox[\"temp\", \"TI\"]\)."
BlackBodyRadiation`PeakWavelength::usage = "\!\(\*RowBox[{\"PeakWavelength\", \"[\", StyleBox[\"temp\", \"TI\"], \"]\"}]\) gives the wavelength of the maximum emission of a black body at the specified temperature \!\(\*StyleBox[\"temp\", \"TI\"]\)."
BlackBodyRadiation`TotalPower::usage = "\!\(\*RowBox[{\"TotalPower\", \"[\", StyleBox[\"temp\", \"TI\"], \"]\"}]\) gives the total radiative power emitted by a black body at the specified temperature \!\(\*StyleBox[\"temp\", \"TI\"]\)."
Calendar`CalendarChange::usage = "\!\(\*RowBox[{\"CalendarChange\", \"[\", RowBox[{RowBox[{\"{\", RowBox[{StyleBox[\"year\", \"TI\"], \",\", StyleBox[\"month\", \"TI\"], \",\", StyleBox[\"day\", \"TI\"]}], \"}\"}], \",\", SubscriptBox[StyleBox[\"calendar\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"calendar\", \"TI\"], StyleBox[\"2\", \"TR\"]]}], \"]\"}]\) converts the date \!\(\*RowBox[{\"{\", RowBox[{StyleBox[\"year\", \"TI\"], \",\", StyleBox[\"month\", \"TI\"], \",\", StyleBox[\"day\", \"TI\"]}], \"}\"}]\) given in calendar \!\(\*SubscriptBox[StyleBox[\"calendar\", \"TI\"], StyleBox[\"1\", \"TR\"]]\) into a date given in calendar \!\(\*RowBox[{SubscriptBox[StyleBox[\"calendar\", \"TI\"], StyleBox[\"2\", \"TR\"]], \".\"}]\)\n\!\(\*RowBox[{\"CalendarChange\", \"[\", RowBox[{RowBox[{\"{\", RowBox[{StyleBox[\"year\", \"TI\"], \",\", StyleBox[\"month\", \"TI\"], \",\", StyleBox[\"day\", \"TI\"], \",\", StyleBox[\"hour\", \"TI\"], \",\", StyleBox[\"minute\", \"TI\"], \",\", StyleBox[\"second\", \"TI\"]}], \"}\"}], \",\", SubscriptBox[StyleBox[\"calendar\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"calendar\", \"TI\"], StyleBox[\"2\", \"TR\"]]}], \"]\"}]\) converts the given date \!\(\*RowBox[{\"{\", RowBox[{StyleBox[\"year\", \"TI\"], \",\", StyleBox[\"month\", \"TI\"], \",\", StyleBox[\"day\", \"TI\"], \",\", StyleBox[\"hour\", \"TI\"], \",\", StyleBox[\"minute\", \"TI\"], \",\", StyleBox[\"second\", \"TI\"]}], \"}\"}]\)."
Calendar`Calendar::usage = "Calendar is an option for calendar functions which specifies which calendar system to use."
Calendar`DateQ::usage = "\!\(\*RowBox[{\"DateQ\", \"[\", RowBox[{\"{\", RowBox[{StyleBox[\"year\", \"TI\"], \",\", StyleBox[\"month\", \"TI\"], \",\", StyleBox[\"day\", \"TI\"]}], \"}\"}], \"]\"}]\) yields True if date \!\(\*RowBox[{\"{\", RowBox[{StyleBox[\"year\", \"TI\"], \",\", StyleBox[\"month\", \"TI\"], \",\", StyleBox[\"day\", \"TI\"]}], \"}\"}]\) is a valid date in the current calendar system, and yields False otherwise. \n\!\(\*RowBox[{\"DateQ\", \"[\", RowBox[{\"{\", RowBox[{StyleBox[\"year\", \"TI\"], \",\", StyleBox[\"month\", \"TI\"], \",\", StyleBox[\"day\", \"TI\"], \",\", StyleBox[\"hour\", \"TI\"], \",\", StyleBox[\"minute\", \"TI\"], \",\", StyleBox[\"second\", \"TI\"]}], \"}\"}], \"]\"}]\) date given in long form \!\(\*RowBox[{\"{\", RowBox[{StyleBox[\"year\", \"TI\"], \",\", StyleBox[\"month\", \"TI\"], \",\", StyleBox[\"day\", \"TI\"], \",\", StyleBox[\"hour\", \"TI\"], \",\", StyleBox[\"minute\", \"TI\"], \",\", StyleBox[\"second\", \"TI\"]}], \"}\"}]\)."
Calendar`DayOfWeek::usage = "\!\(\*RowBox[{\"DayOfWeek\", \"[\", RowBox[{\"{\", RowBox[{StyleBox[\"year\", \"TI\"], \",\", StyleBox[\"month\", \"TI\"], \",\", StyleBox[\"day\", \"TI\"]}], \"}\"}], \"]\"}]\) gives the day of the week on which the given date \!\(\*RowBox[{\"{\", RowBox[{StyleBox[\"year\", \"TI\"], \",\", StyleBox[\"month\", \"TI\"], \",\", StyleBox[\"day\", \"TI\"]}], \"}\"}]\) occurred.\n\!\(\*RowBox[{\"DayOfWeek\", \"[\", RowBox[{\"{\", RowBox[{StyleBox[\"year\", \"TI\"], \",\", StyleBox[\"month\", \"TI\"], \",\", StyleBox[\"day\", \"TI\"], \",\", StyleBox[\"hour\", \"TI\"], \",\", StyleBox[\"minute\", \"TI\"], \",\", StyleBox[\"second\", \"TI\"]}], \"}\"}], \"]\"}]\) gives the day of the week for the given date."
Calendar`DaysBetween::usage = "\!\(\*RowBox[{\"DaysBetween\", \"[\", RowBox[{RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"year\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"month\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"day\", \"TI\"], StyleBox[\"1\", \"TR\"]]}], \"}\"}], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"year\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"month\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"day\", \"TI\"], StyleBox[\"2\", \"TR\"]]}], \"}\"}]}], \"]\"}]\) gives the number of days between the dates \!\(\*RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"year\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"month\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"day\", \"TI\"], StyleBox[\"1\", \"TR\"]]}], \"}\"}]\) and \!\(\*RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"year\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"month\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"day\", \"TI\"], StyleBox[\"2\", \"TR\"]]}], \"}\"}]\). \n\!\(\*RowBox[{\"DaysBetween\", \"[\", RowBox[{RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"year\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"month\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"day\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"hour\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"minute\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"second\", \"TI\"], StyleBox[\"1\", \"TR\"]]}], \"}\"}], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"year\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"month\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"day\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"hour\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"minute\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"second\", \"TI\"], StyleBox[\"2\", \"TR\"]]}], \"}\"}]}], \"]\"}]\) gives the number of days between the given dates."
Calendar`DaysPlus::usage = "\!\(\*RowBox[{\"DaysPlus\", \"[\", RowBox[{RowBox[{\"{\", RowBox[{StyleBox[\"year\", \"TI\"], \",\", StyleBox[\"month\", \"TI\"], \",\", StyleBox[\"day\", \"TI\"]}], \"}\"}], \",\", StyleBox[\"n\", \"TI\"]}], \"]\"}]\) gives the date \!\(\*StyleBox[\"n\", \"TI\"]\) days after the date \!\(\*RowBox[{\"{\", RowBox[{StyleBox[\"year\", \"TI\"], \",\", StyleBox[\"month\", \"TI\"], \",\", StyleBox[\"day\", \"TI\"]}], \"}\"}]\).\n\!\(\*RowBox[{\"DaysPlus\", \"[\", RowBox[{RowBox[{\"{\", RowBox[{StyleBox[\"year\", \"TI\"], \",\", StyleBox[\"month\", \"TI\"], \",\", StyleBox[\"day\", \"TI\"], \",\", StyleBox[\"hour\", \"TI\"], \",\", StyleBox[\"minute\", \"TI\"], \",\", StyleBox[\"second\", \"TI\"]}], \"}\"}], \",\", StyleBox[\"n\", \"TI\"]}], \"]\"}]\) gives the date \!\(\*StyleBox[\"n\", \"TI\"]\) days after the date \!\(\*RowBox[{\"{\", RowBox[{StyleBox[\"year\", \"TI\"], \",\", StyleBox[\"month\", \"TI\"], \",\", StyleBox[\"day\", \"TI\"], \",\", StyleBox[\"hour\", \"TI\"], \",\", StyleBox[\"minute\", \"TI\"], \",\", StyleBox[\"second\", \"TI\"]}], \"}\"}]\)."
Calendar`EasterSundayGreekOrthodox::usage = "\!\(\*RowBox[{\"EasterSundayGreekOrthodox\", \"[\", StyleBox[\"year\", \"TI\"], \"]\"}]\) gives the date of Easter Sunday according to the Greek Orthodox Church using the Gregorian system."
Calendar`EasterSunday::usage = "\!\(\*RowBox[{\"EasterSunday\", \"[\", StyleBox[\"year\", \"TI\"], \"]\"}]\) gives the date of Easter Sunday in the Gregorian calendar system."
Calendar`Friday::usage = "Friday is a day of the week."
Calendar`Gregorian::usage = "Gregorian represents the Gregorian calendar system."
Calendar`Islamic::usage = "Islamic represents the Islamic calendar system."
Calendar`Jewish::usage = "Jewish represents the Jewish calendar system. "
Calendar`JewishNewYear::usage = "\!\(\*RowBox[{\"JewishNewYear\", \"[\", StyleBox[\"year\", \"TI\"], \"]\"}]\) gives the date of the Jewish New Year occurring in Gregorian years between 1900 and 2099."
Calendar`Julian::usage = "Julian represents the Julian calendar system."
Calendar`Monday::usage = "Monday is a day of the week."
Calendar`Saturday::usage = "Saturday is a day of the week."
Calendar`Sunday::usage = "Sunday is a day of the week."
Calendar`Thursday::usage = "Thursday is a day of the week."
Calendar`Tuesday::usage = "Tuesday is a day of the week."
Calendar`Wednesday::usage = "Wednesday is a day of the week."
Combinatorica`AcyclicQ::usage = "\!\(\*RowBox[{\"AcyclicQ\", \"[\", StyleBox[\"g\", \"TI\"], \"]\"}]\) yields True if graph \!\(\*StyleBox[\"g\", \"TI\"]\) is acyclic."
Combinatorica`AddEdge::usage = "\!\(\*RowBox[{\"AddEdge\", \"[\", RowBox[{StyleBox[\"g\", \"TI\"], \",\", StyleBox[\"e\", \"TI\"]}], \"]\"}]\) returns a graph g with the new edge e added. e can have the form \!\(\*RowBox[{\"{\", RowBox[{\"a\", \",\", \"b\"}], \"}\"}]\) or the form \!\(\*RowBox[{\"{\", RowBox[{RowBox[{\"{\", RowBox[{\"a\", \",\", \"b\"}], \"}\"}], \",\", StyleBox[\"options\", \"TI\"]}], \"}\"}]\)."
Combinatorica`AddEdges::usage = "\!\(\*RowBox[{\"AddEdges\", \"[\", RowBox[{StyleBox[\"g\", \"TI\"], \",\", StyleBox[\"edgeList\", \"TI\"]}], \"]\"}]\) gives graph g with the new edges in \!\(\*StyleBox[\"edgeList\", \"TI\"]\) added. \!\(\*StyleBox[\"edgeList\", \"TI\"]\) can have the form \!\(\*RowBox[{\"{\", RowBox[{\"a\", \",\", \"b\"}], \"}\"}]\) to add a single edge \!\(\*RowBox[{\"{\", RowBox[{\"a\", \",\", \"b\"}], \"}\"}]\) or the form \!\(\*RowBox[{\"{\", RowBox[{RowBox[{\"{\", RowBox[{\"a\", \",\", \"b\"}], \"}\"}], \",\", RowBox[{\"{\", RowBox[{\"c\", \",\", \"d\"}], \"}\"}], \",\", \"\[Ellipsis]\"}], \"}\"}]\), to add edges \!\(\*RowBox[{RowBox[{\"{\", RowBox[{\"a\", \",\", \"b\"}], \"}\"}], \",\", RowBox[{\"{\", RowBox[{\"c\", \",\", \"d\"}], \"}\"}], \",\", \"\[Ellipsis]\"}]\) or the form \!\(\*RowBox[{\"{\", RowBox[{RowBox[{\"{\", RowBox[{RowBox[{\"{\", RowBox[{\"a\", \",\", \"b\"}], \"}\"}], \",\", \"x\"}], \"}\"}], \",\", RowBox[{\"{\", RowBox[{RowBox[{\"{\", RowBox[{\"c\", \",\", \"d\"}], \"}\"}], \",\", \"y\"}], \"}\"}], \",\", \"\[Ellipsis]\"}], \"}\"}]\), where x and y can specify graphics information associated with \!\(\*RowBox[{\"{\", RowBox[{\"a\", \",\", \"b\"}], \"}\"}]\) and \!\(\*RowBox[{\"{\", RowBox[{\"c\", \",\", \"d\"}], \"}\"}]\), respectively."
Combinatorica`AddVertex::usage = "\!\(\*RowBox[{\"AddVertex\", \"[\", StyleBox[\"g\", \"TI\"], \"]\"}]\) adds one disconnected vertex to graph g. \n\!\(\*RowBox[{\"AddVertex\", \"[\", RowBox[{StyleBox[\"g\", \"TI\"], \",\", StyleBox[\"v\", \"TI\"]}], \"]\"}]\) adds to g a vertex with coordinates specified by v."
Combinatorica`AddVertices::usage = "\!\(\*RowBox[{\"AddVertices\", \"[\", RowBox[{StyleBox[\"g\", \"TI\"], \",\", StyleBox[\"n\", \"TI\"]}], \"]\"}]\) adds \!\(\*StyleBox[\"n\", \"TI\"]\) disconnected vertices to graph \!\(\*StyleBox[\"g\", \"TI\"]\). \n\!\(\*RowBox[{\"AddVertices\", \"[\", RowBox[{StyleBox[\"g\", \"TI\"], \",\", StyleBox[\"vList\", \"TI\"]}], \"]\"}]\) adds vertices in \!\(\*StyleBox[\"vList\", \"TI\"]\) to g. \!\(\*StyleBox[\"vList\", \"TI\"]\) contains embedding and graphics information and can have the form \!\(\*RowBox[{\"{\", RowBox[{\"x\", \",\", \"y\"}], \"}\"}]\) or \!\(\*RowBox[{\"{\", RowBox[{RowBox[{\"{\", RowBox[{SubscriptBox[\"x\", \"1\"], \",\", SubscriptBox[\"y\", \"1\"]}], \"}\"}], \",\", RowBox[{RowBox[{\"{\", RowBox[{SubscriptBox[\"x\", \"2\"], \",\", SubscriptBox[\"y\", \"2\"]}], \"}\"}], \" \", \"\[Ellipsis]\"}]}], \"}\"}]\) or the form \!\(\*RowBox[{\"{\", RowBox[{RowBox[{\"{\", RowBox[{RowBox[{\"{\", RowBox[{SubscriptBox[\"x\", \"1\"], \",\", SubscriptBox[\"y\", \"1\"]}], \"}\"}], \",\", SubscriptBox[\"g\", \"1\"]}], \"}\"}], \",\", RowBox[{\"{\", RowBox[{RowBox[{\"{\", RowBox[{SubscriptBox[\"x\", \"2\"], \",\", SubscriptBox[\"y\", \"2\"]}], \"}\"}], \",\", SubscriptBox[\"g\", \"2\"]}], \"}\"}], \",\", \"\[Ellipsis]\"}], \"}\"}]\), where \!\(\*RowBox[{\"{\", RowBox[{\"x\", \",\", \"y\"}], \"}\"}]\), \!\(\*RowBox[{\"{\", RowBox[{SubscriptBox[\"x\", \"1\"], \",\", SubscriptBox[\"y\", \"1\"]}], \"}\"}]\), and \!\(\*RowBox[{\"{\", RowBox[{SubscriptBox[\"x\", \"2\"], \",\", SubscriptBox[\"y\", \"2\"]}], \"}\"}]\) are point coordinates and \!\(\*SubscriptBox[\"g\", \"1\"]\) and \!\(\*SubscriptBox[\"g\", \"2\"]\) are graphics information associated with vertices."
Combinatorica`Algorithm::usage = "Algorithm is an option that informs functions such as ShortestPath, VertexColoring, and VertexCover about which algorithm to use."
Combinatorica`AllPairsShortestPath::usage = "\!\(\*RowBox[{\"AllPairsShortestPath\", \"[\", StyleBox[\"g\", \"TI\"], \"]\"}]\) gives a matrix, where the \!\(\*RowBox[{\"(\", RowBox[{\"i\", \",\", \"j\"}], \")\"}]\)\!\(\*SuperscriptBox[\"\[Null]\", \"th\"]\) entry is the length of a shortest path in g between vertices i and j. \n\!\(\*RowBox[{\"AllPairsShortestPath\", \"[\", RowBox[{StyleBox[\"g\", \"TI\"], \",\", \"Parent\"}], \"]\"}]\) returns a three-dimensional matrix with dimensions \!\(\*RowBox[{StyleBox[\"2\", \"TR\"], \"*\", RowBox[{\"V\", \"[\", StyleBox[\"g\", \"TI\"], \"]\"}], \"*\", RowBox[{\"V\", \"[\", StyleBox[\"g\", \"TI\"], \"]\"}]}]\), in which the \!\(\*RowBox[{\"(\", RowBox[{\"1\", \",\", \"i\", \",\", \"j\"}], \")\"}]\)\!\(\*SuperscriptBox[\"\[Null]\", \"th\"]\) entry is the length of a shortest path from i to j and the \!\(\*RowBox[{\"(\", RowBox[{\"2\", \",\", \"i\", \",\", \"j\"}], \")\"}]\)\!\(\*SuperscriptBox[\"\[Null]\", \"th\"]\) entry is the predecessor of j in a shortest path from i to j."
Combinatorica`AlternatingGroupIndex::usage = "\!\(\*RowBox[{\"AlternatingGroupIndex\", \"[\", RowBox[{StyleBox[\"n\", \"TI\"], \",\", StyleBox[\"x\", \"TI\"]}], \"]\"}]\) gives the cycle index of the alternating group of size n permutations as a polynomial in the symbols \!\(\*RowBox[{RowBox[{RowBox[{\"x\", \"[\", \"1\", \"]\"}], \",\", RowBox[{\"x\", \"[\", \"2\", \"]\"}], \",\", \"\[Ellipsis]\", \",\", RowBox[{\"x\", \"[\", \"n\", \"]\"}]}], \"}\"}]\)."
Combinatorica`AlternatingGroup::usage = "\!\(\*RowBox[{\"AlternatingGroup\", \"[\", StyleBox[\"n\", \"TI\"], \"]\"}]\) generates the set of even-size n permutations, the alternating group on n symbols. \n\!\(\*RowBox[{\"AlternatingGroup\", \"[\", StyleBox[\"l\", \"TI\"], \"]\"}]\) generates the set of even permutations of the list l."
Combinatorica`AlternatingPaths::usage = "\!\(\*RowBox[{\"AlternatingPaths\", \"[\", RowBox[{StyleBox[\"g\", \"TI\"], \",\", StyleBox[\"start\", \"TI\"], \",\", StyleBox[\"ME\", \"TI\"]}], \"]\"}]\) returns the alternating paths in graph g with respect to the matching \!\(\*StyleBox[\"ME\", \"TI\"]\), starting at the vertices in the list \!\(\*StyleBox[\"start\", \"TI\"]\). The paths are returned in the form of a forest containing trees rooted at vertices in \!\(\*StyleBox[\"start\", \"TI\"]\)."
Combinatorica`AnimateGraph::usage = "\!\(\*RowBox[{\"AnimateGraph\", \"[\", RowBox[{StyleBox[\"g\", \"TI\"], \",\", StyleBox[\"l\", \"TI\"]}], \"]\"}]\) displays graph g with each element in the list l successively highlighted. Here l is a list containing vertices and edges of g. An optional flag, which takes on the values All and One, can be used to inform the function about whether objects highlighted earlier will continue to be highlighted or not. The default value of flag is All. All the options allowed by the function Highlight are permitted by AnimateGraph, as well. See the usage message of Highlight for more details."
Combinatorica`AntiSymmetricQ::usage = "\!\(\*RowBox[{\"AntiSymmetricQ\", \"[\", StyleBox[\"g\", \"TI\"], \"]\"}]\) yields True if the adjacency matrix of g represents an anti-symmetric binary relation."
Combinatorica`Approximate::usage = "Approximate is a value that the option Algorithm can take in calls to functions such as VertexCover, telling it to use an approximation algorithm."
Combinatorica`ApproximateVertexCover::usage = "\!\(\*RowBox[{\"ApproximateVertexCover\", \"[\", StyleBox[\"g\", \"TI\"], \"]\"}]\) produces a vertex cover of graph g whose size is guaranteed to be within twice the optimal size."
Combinatorica`ArticulationVertices::usage = "\!\(\*RowBox[{\"ArticulationVertices\", \"[\", StyleBox[\"g\", \"TI\"], \"]\"}]\) gives a list of all articulation vertices in graph g. These are vertices whose removal will disconnect the graph."
Combinatorica`Automorphisms::usage = "\!\(\*RowBox[{\"Automorphisms\", \"[\", StyleBox[\"g\", \"TI\"], \"]\"}]\) gives the automorphism group of the graph g."
Combinatorica`Backtrack::usage = "\!\(\*RowBox[{\"Backtrack\", \"[\", RowBox[{StyleBox[\"s\", \"TI\"], \",\", StyleBox[\"partialQ\", \"TI\"], \",\", StyleBox[\"solutionQ\", \"TI\"]}], \"]\"}]\) performs a backtrack search of the state space s, expanding a partial solution so long as \!\(\*StyleBox[\"partialQ\", \"TI\"]\) is True and returning the first complete solution, as identified by \!\(\*StyleBox[\"solutionQ\", \"TI\"]\)."
Combinatorica`BellmanFord::usage = "\!\(\*RowBox[{\"BellmanFord\", \"[\", RowBox[{StyleBox[\"g\", \"TI\"], \",\", StyleBox[\"v\", \"TI\"]}], \"]\"}]\) gives a shortest-path spanning tree and associated distances from vertex v of graph g. The shortest-path spanning tree is given by a list in which element i is the predecessor of vertex i in the shortest-path spanning tree. BellmanFord works correctly even when the edge weights are negative, provided there are no negative cycles."
Combinatorica`BiconnectedComponents::usage = "\!\(\*RowBox[{\"BiconnectedComponents\", \"[\", StyleBox[\"g\", \"TI\"], \"]\"}]\) gives a list of the biconnected components of graph g. If g is directed, the underlying undirected graph is used."
Combinatorica`BiconnectedQ::usage = "\!\(\*RowBox[{\"BiconnectedQ\", \"[\", StyleBox[\"g\", \"TI\"], \"]\"}]\) yields True if graph g is biconnected. If g is directed, the underlying undirected graph is used."
Combinatorica`BinarySearch::usage = "\!\(\*RowBox[{\"BinarySearch\", \"[\", RowBox[{StyleBox[\"l\", \"TI\"], \",\", StyleBox[\"k\", \"TI\"]}], \"]\"}]\) searches sorted list l for key k and gives the position of l containing k, if k is present in l. Otherwise, if k is absent in l, the function returns \!\(\*RowBox[{\"(\", RowBox[{\"p\", \"+\", RowBox[{\"1\", \"/\", \"2\"}]}], \")\"}]\) where k falls between the elements of l in positions p and \!\(\*RowBox[{\"p\", \"+\", \"1\"}]\). \n\!\(\*RowBox[{\"BinarySearch\", \"[\", RowBox[{StyleBox[\"l\", \"TI\"], \",\", StyleBox[\"k\", \"TI\"], \",\", StyleBox[\"f\", \"TI\"]}], \"]\"}]\) gives the position of k in the list obtained from l by applying f to each element in l."
Combinatorica`BinarySubsets::usage = "\!\(\*RowBox[{\"BinarySubsets\", \"[\", StyleBox[\"l\", \"TI\"], \"]\"}]\) gives all subsets of l ordered according to the binary string defining each subset. For any positive integer n, \!\(\*RowBox[{\"BinarySubsets\", \"[\", StyleBox[\"n\", \"TI\"], \"]\"}]\) gives all subsets of \!\(\*RowBox[{\"{\", RowBox[{\"1\", \",\", \"2\", \",\", \"\[Ellipsis]\", \",\", \"n\"}], \"}\"}]\) ordered according to the binary string defining each subset."
Combinatorica`BipartiteMatchingAndCover::usage = "\!\(\*RowBox[{\"BipartiteMatchingAndCover\", \"[\", StyleBox[\"g\", \"TI\"], \"]\"}]\) takes a bipartite graph g and returns a matching with maximum weight along with the dual vertex cover. If the graph is not weighted, it is assumed that all edge weights are 1."
Combinatorica`BipartiteMatching::usage = "\!\(\*RowBox[{\"BipartiteMatching\", \"[\", StyleBox[\"g\", \"TI\"], \"]\"}]\) gives the list of edges associated with a maximum matching in bipartite graph g. If the graph is edge weighted, then the function returns a matching with maximum total weight."
Combinatorica`BipartiteQ::usage = "\!\(\*RowBox[{\"BipartiteQ\", \"[\", StyleBox[\"g\", \"TI\"], \"]\"}]\) yields True if graph g is bipartite."
Combinatorica`BooleanAlgebra::usage = "\!\(\*RowBox[{\"BooleanAlgebra\", \"[\", StyleBox[\"n\", \"TI\"], \"]\"}]\) gives a Hasse diagram for the Boolean algebra on n elements. The function takes two options: Type and VertexLabel, with default values Undirected and False, respectively. When Type is set to Directed, the function produces the underlying directed acyclic graph. When VertexLabel is set to True, labels are produced for the vertices."
Combinatorica`BreadthFirstTraversal::usage = "\!\(\*RowBox[{\"BreadthFirstTraversal\", \"[\", RowBox[{StyleBox[\"g\", \"TI\"], \",\", StyleBox[\"v\", \"TI\"]}], \"]\"}]\) performs a breadth-first traversal of graph g starting from vertex \!\(\*StyleBox[\"v\", \"TI\"]\), and gives the breadth-first numbers of the vertices. \n\!\(\*RowBox[{RowBox[{\"BreadthFirstTraversal\", \"[\"}], StyleBox[\"g\", \"TI\"], \",\", StyleBox[\"v\", \"TI\"], \",\", RowBox[{\"Edge\", \"]\"}]}]\) returns the edges of the graph that are traversed by breadth-first traversal. \n\!\(\*RowBox[{RowBox[{\"BreadthFirstTraversal\", \"[\"}], StyleBox[\"g\", \"TI\"], \",\", StyleBox[\"v\", \"TI\"], \",\", RowBox[{\"Tree\", \"]\"}]}]\) returns the breadth-first search tree. \n\!\(\*RowBox[{RowBox[{\"BreadthFirstTraversal\", \"[\"}], StyleBox[\"g\", \"TI\"], \",\", StyleBox[\"v\", \"TI\"], \",\", RowBox[{\"Level\", \"]\"}]}]\) returns the level number of the vertices."
Combinatorica`BrelazColoring::usage = "\!\(\*RowBox[{\"BrelazColoring\", \"[\", StyleBox[\"g\", \"TI\"], \"]\"}]\) returns a vertex coloring in which vertices are greedily colored with the smallest available color in decreasing order of vertex degree."
Combinatorica`Brelaz::usage = "Brelaz is a value that the option Algorithm can take when used in the function VertexColoring."
Combinatorica`Bridges::usage = "\!\(\*RowBox[{\"Bridges\", \"[\", StyleBox[\"g\", \"TI\"], \"]\"}]\) gives a list of the bridges of graph g, where each bridge is an edge whose removal disconnects the graph."
Combinatorica`ButterflyGraph::usage = "\!\(\*RowBox[{\"ButterflyGraph\", \"[\", StyleBox[\"n\", \"TI\"], \"]\"}]\) returns the n-dimensional butterfly graph, a directed graph whose vertices are pairs \!\(\*RowBox[{\"(\", RowBox[{\"w\", \",\", \"i\"}], \")\"}]\), where w is a binary string of length n and i is an integer in the range 0 through n and whose edges go from vertex \!\(\*RowBox[{\"(\", RowBox[{\"w\", \",\", \"i\"}], \")\"}]\) to \!\(\*RowBox[{\"(\", RowBox[{SuperscriptBox[\"w\", \"\[Prime]\"], \",\", RowBox[{\"i\", \"+\", \"1\"}]}], \")\"}]\), if \!\(\*SuperscriptBox[\"w\", \"\[Prime]\", MultilineFunction -> None]\) is identical to \!\(\*StyleBox[\"w\", \"TI\"]\) in all bits with the possible exception of the \!\(\*RowBox[{\"(\", RowBox[{\"i\", \"+\", \"1\"}], \")\"}]\)\!\(\*SuperscriptBox[\"\[Null]\", \"th\"]\) bit. Here bits are counted left to right. An option VertexLabel, with default setting False, is allowed. When this option is set to True, vertices are labeled with strings \!\(\*RowBox[{\"(\", RowBox[{\"w\", \",\", \"i\"}], \")\"}]\)."
Combinatorica`CageGraph::usage = "\!\(\*RowBox[{\"CageGraph\", \"[\", RowBox[{StyleBox[\"k\", \"TI\"], \",\", StyleBox[\"r\", \"TI\"]}], \"]\"}]\) gives a smallest k-regular graph of girth r for certain small values of k and r. \n\!\(\*RowBox[{\"CageGraph\", \"[\", StyleBox[\"r\", \"TI\"], \"]\"}]\) gives \!\(\*RowBox[{RowBox[{\"CageGraph\", \"[\", RowBox[{\"3\", \",\"}]}], StyleBox[\"r\", \"TI\"], \"]\"}]\). For \!\(\*RowBox[{\"k\", \"=\", \"3\"}]\), r can be 3, 4, 5, 6, 7, 8, or 10. For \!\(\*RowBox[{\"k\", \"=\", \"4\"}]\) or 5, r can be 3, 4, 5, or 6."
Combinatorica`CartesianProduct::usage = "\!\(\*RowBox[{\"CartesianProduct\", \"[\", RowBox[{SubscriptBox[StyleBox[\"l\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"l\", \"TI\"], StyleBox[\"2\", \"TR\"]]}], \"]\"}]\) gives the Cartesian product of lists \!\(\*SubscriptBox[\"l\", \"1\"]\) and \!\(\*SubscriptBox[\"l\", \"2\"]\)."
Combinatorica`ChangeEdges::usage = "\!\(\*RowBox[{\"ChangeEdges\", \"[\", RowBox[{StyleBox[\"g\", \"TI\"], \",\", StyleBox[\"e\", \"TI\"]}], \"]\"}]\) replaces the edges of graph g with the edges in e. e can have the form \!\(\*RowBox[{\"{\", RowBox[{RowBox[{\"{\", RowBox[{SubscriptBox[\"s\", \"1\"], \",\", SubscriptBox[\"t\", \"1\"]}], \"}\"}], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[\"s\", \"2\"], \",\", SubscriptBox[\"t\", \"2\"]}], \"}\"}], \",\", \"\[Ellipsis]\"}], \"}\"}]\) or the form \!\(\*RowBox[{\"{\", RowBox[{RowBox[{\"{\", RowBox[{RowBox[{\"{\", RowBox[{SubscriptBox[\"s\", \"1\"], \",\", SubscriptBox[\"t\", \"1\"]}], \"}\"}], \",\", SubscriptBox[\"gr\", \"1\"]}], \"}\"}], \",\", RowBox[{\"{\", RowBox[{RowBox[{\"{\", RowBox[{SubscriptBox[\"s\", \"2\"], \",\", SubscriptBox[\"t\", \"2\"]}], \"}\"}], \",\", SubscriptBox[\"gr\", \"2\"]}], \"}\"}], \",\", \"\[Ellipsis]\"}], \"}\"}]\), where \!\(\*RowBox[{RowBox[{\"{\", RowBox[{SubscriptBox[\"s\", \"1\"], \",\", SubscriptBox[\"t\", \"1\"]}], \"}\"}], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[\"s\", \"2\"], \",\", SubscriptBox[\"t\", \"2\"]}], \"}\"}], \",\", \"\[Ellipsis]\"}]\) are endpoints of edges and \!\(\*RowBox[{SubscriptBox[\"gr\", \"1\"], \",\", SubscriptBox[\"gr\", \"2\"], \",\", \"\[Ellipsis]\"}]\), are graphics information associated with edges."
Combinatorica`ChangeVertices::usage = "\!\(\*RowBox[{\"ChangeVertices\", \"[\", RowBox[{StyleBox[\"g\", \"TI\"], \",\", StyleBox[\"v\", \"TI\"]}], \"]\"}]\) replaces the vertices of graph g with the vertices in the given list v. v can have the form \!\(\*RowBox[{\"{\", RowBox[{RowBox[{\"{\", RowBox[{SubscriptBox[\"x\", \"1\"], \",\", SubscriptBox[\"y\", \"1\"]}], \"}\"}], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[\"x\", \"2\"], \",\", SubscriptBox[\"y\", \"2\"]}], \"}\"}], \",\", \"\[Ellipsis]\"}], \"}\"}]\) or the form \!\(\*RowBox[{\"{\", RowBox[{RowBox[{\"{\", RowBox[{RowBox[{\"{\", RowBox[{SubscriptBox[\"x\", \"1\"], \",\", SubscriptBox[\"y\", \"1\"]}], \"}\"}], \",\", SubscriptBox[\"gr\", \"1\"]}], \"}\"}], \",\", RowBox[{\"{\", RowBox[{RowBox[{\"{\", RowBox[{SubscriptBox[\"x\", \"2\"], \",\", SubscriptBox[\"y\", \"2\"]}], \"}\"}], \",\", SubscriptBox[\"gr\", \"2\"]}], \"}\"}], \",\", \"\[Ellipsis]\"}], \"}\"}]\), where \!\(\*RowBox[{RowBox[{\"{\", RowBox[{SubscriptBox[\"x\", \"1\"], \",\", SubscriptBox[\"y\", \"1\"]}], \"}\"}], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[\"x\", \"2\"], \",\", SubscriptBox[\"y\", \"2\"]}], \"}\"}], \",\", \"\[Ellipsis]\"}]\) are coordinates of points and \!\(\*RowBox[{SubscriptBox[\"gr\", \"1\"], \",\", SubscriptBox[\"gr\", \"2\"], \",\", \"\[Ellipsis]\"}]\) are graphics information associated with vertices."
Combinatorica`ChromaticNumber::usage = "\!\(\*RowBox[{\"ChromaticNumber\", \"[\", StyleBox[\"g\", \"TI\"], \"]\"}]\) gives the chromatic number of the graph, which is the fewest number of colors necessary to color the graph."
Combinatorica`ChromaticPolynomial::usage = "\!\(\*RowBox[{\"ChromaticPolynomial\", \"[\", RowBox[{StyleBox[\"g\", \"TI\"], \",\", StyleBox[\"z\", \"TI\"]}], \"]\"}]\) gives the chromatic polynomial \!\(\*RowBox[{\"P\", \"(\", \"z\", \")\"}]\) of graph g, which counts the number of ways to color g with, at most, z colors."
Combinatorica`ChvatalGraph::usage = "ChvatalGraph returns a smallest triangle-free, 4-regular, 4-chromatic graph."
Combinatorica`CirculantGraph::usage = "\!\(\*RowBox[{\"CirculantGraph\", \"[\", RowBox[{StyleBox[\"n\", \"TI\"], \",\", StyleBox[\"l\", \"TI\"]}], \"]\"}]\) constructs a circulant graph on n vertices, meaning the i\!\(\*SuperscriptBox[\"\[Null]\", \"th\"]\) vertex is adjacent to the \!\(\*RowBox[{\"(\", RowBox[{\"i\", \"+\", \"j\"}], \")\"}]\)\!\(\*SuperscriptBox[\"\[Null]\", \"th\"]\) and \!\(\*RowBox[{\"(\", RowBox[{\"i\", \"-\", \"j\"}], \")\"}]\)\!\(\*SuperscriptBox[\"\[Null]\", \"th\"]\) vertices, for each j in list l. \n\!\(\*RowBox[{\"CirculantGraph\", \"[\", RowBox[{StyleBox[\"n\", \"TI\"], \",\", StyleBox[\"l\", \"TI\"]}], \"]\"}]\) returns the graph with n vertices in which each i is adjacent to \!\(\*RowBox[{\"(\", RowBox[{\"i\", \"+\", \"l\"}], \")\"}]\) and \!\(\*RowBox[{\"(\", RowBox[{\"i\", \"-\", \"l\"}], \")\"}]\), where l must be an integer."
Combinatorica`CircularEmbedding::usage = "\!\(\*RowBox[{\"CircularEmbedding\", \"[\", StyleBox[\"n\", \"TI\"], \"]\"}]\) constructs a list of n points equally spaced on a circle. \n\!\(\*RowBox[{\"CircularEmbedding\", \"[\", StyleBox[\"g\", \"TI\"], \"]\"}]\) embeds the vertices of g equally spaced on a circle."
Combinatorica`CircularVertices::usage = "\!\(\*RowBox[{\"CircularVertices\", \"[\", StyleBox[\"n\", \"TI\"], \"]\"}]\) constructs a list of n points equally spaced on a circle. \n\!\(\*RowBox[{\"CircularVertices\", \"[\", StyleBox[\"g\", \"TI\"], \"]\"}]\) embeds the vertices of g equally spaced on a circle."
Combinatorica`CliqueQ::usage = "\!\(\*RowBox[{\"CliqueQ\", \"[\", RowBox[{StyleBox[\"g\", \"TI\"], \",\", StyleBox[\"c\", \"TI\"]}], \"]\"}]\) yields True if the list of vertices c defines a clique in graph g."
Combinatorica`CoarserSetPartitionQ::usage = "\!\(\*RowBox[{\"CoarserSetPartitionQ\", \"[\", RowBox[{StyleBox[\"a\", \"TI\"], \",\", StyleBox[\"b\", \"TI\"]}], \"]\"}]\) yields True if set partition b is coarser than set partition a; that is, every block in a is contained in some block in b."
Combinatorica`CodeToLabeledTree::usage = "\!\(\*RowBox[{\"CodeToLabeledTree\", \"[\", StyleBox[\"l\", \"TI\"], \"]\"}]\) constructs the unique labeled tree on n vertices from the Pr\[UDoubleDot]fer code l, which consists of a list of \!\(\*RowBox[{\"n\", \"-\", \"2\"}]\) integers between 1 and n."
Combinatorica`Cofactor::usage = "\!\(\*RowBox[{\"Cofactor\", \"[\", RowBox[{StyleBox[\"m\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{StyleBox[\"i\", \"TI\"], \",\", StyleBox[\"j\", \"TI\"]}], \"}\"}]}], \"]\"}]\) calculates the \!\(\*RowBox[{\"(\", RowBox[{\"i\", \",\", \"j\"}], \")\"}]\)\!\(\*SuperscriptBox[\"\[Null]\", \"th\"]\) cofactor of matrix m."
Combinatorica`CompleteBinaryTree::usage = "\!\(\*RowBox[{\"CompleteBinaryTree\", \"[\", StyleBox[\"n\", \"TI\"], \"]\"}]\) returns a complete binary tree on n vertices."
Combinatorica`CompleteGraph::usage = "\!\(\*RowBox[{\"CompleteGraph\", \"[\", StyleBox[\"n\", \"TI\"], \"]\"}]\) creates a complete graph on n vertices. An option Type that takes on the values Directed or Undirected is allowed. The default setting for this option is \!\(\*RowBox[{\"Type\", \"->\", \"Undirected\"}]\). \n\!\(\*RowBox[{\"CompleteGraph\", \"[\", RowBox[{StyleBox[\"a\", \"TI\"], \",\", StyleBox[\"b\", \"TI\"], \",\", StyleBox[\"c\", \"TI\"], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) creates a complete k-partite graph of the prescribed shape. The use of CompleteGraph to create a complete k-partite graph is obsolete; use CompleteKPartiteGraph instead."
Combinatorica`CompleteKaryTree::usage = "\!\(\*RowBox[{\"CompleteKaryTree\", \"[\", RowBox[{StyleBox[\"n\", \"TI\"], \",\", StyleBox[\"k\", \"TI\"]}], \"]\"}]\) returns a complete k-ary tree on n vertices."
Combinatorica`CompleteKPartiteGraph::usage = "\!\(\*RowBox[{\"CompleteKPartiteGraph\", \"[\", RowBox[{StyleBox[\"a\", \"TI\"], \",\", StyleBox[\"b\", \"TI\"], \",\", StyleBox[\"c\", \"TI\"], \",\", StyleBox[\"\[Ellipsis]\", \"TI\"]}], \"]\"}]\) creates a complete k-partite graph of the prescribed shape, provided the k arguments \!\(\*RowBox[{\"a\", \",\", \"b\", \",\", \"c\", \",\", \"\[Ellipsis]\"}]\) are positive integers. An option Type that takes on the values Directed or Undirected is allowed. The default setting for this option is \!\(\*RowBox[{\"Type\", \"->\", \"Undirected\"}]\)."
Combinatorica`CompleteQ::usage = "\!\(\*RowBox[{\"CompleteQ\", \"[\", StyleBox[\"g\", \"TI\"], \"]\"}]\) yields True if graph g is complete. This means that between any pair of vertices there is an undirected edge or two directed edges going in opposite directions."
Combinatorica`Compositions::usage = "\!\(\*RowBox[{\"Compositions\", \"[\", RowBox[{StyleBox[\"n\", \"TI\"], \",\", StyleBox[\"k\", \"TI\"]}], \"]\"}]\) gives a list of all compositions of integer n into k parts."
Combinatorica`ConnectedComponents::usage = "\!\(\*RowBox[{\"ConnectedComponents\", \"[\", StyleBox[\"g\", \"TI\"], \"]\"}]\) gives the vertices of graph g partitioned into connected components."
Combinatorica`ConnectedQ::usage = "\!\(\*RowBox[{\"ConnectedQ\", \"[\", StyleBox[\"g\", \"TI\"], \"]\"}]\) yields True if undirected graph g is connected. If g is directed, the function returns True if the underlying undirected graph is connected. \n\!\(\*RowBox[{\"ConnectedQ\", \"[\", RowBox[{StyleBox[\"g\", \"TI\"], \",\", \"Strong\"}], \"]\"}]\) yields True if the directed graph g is strongly connected.\n\!\(\*RowBox[{\"ConnectedQ\", \"[\", RowBox[{StyleBox[\"g\", \"TI\"], \",\", \"Weak\"}], \"]\"}]\) yields True if the directed graph g is weakly connected."
Combinatorica`ConstructTableau::usage = "\!\(\*RowBox[{\"ConstructTableau\", \"[\", StyleBox[\"p\", \"TI\"], \"]\"}]\) performs the bumping algorithm repeatedly on each element of permutation p, resulting in a distinct Young tableau."
Combinatorica`Contract::usage = "\!\(\*RowBox[{\"Contract\", \"[\", RowBox[{StyleBox[\"g\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"y\", \"TI\"]}], \"}\"}]}], \"]\"}]\) gives the graph resulting from contracting the pair of vertices \!\(\*RowBox[{\"{\", RowBox[{\"x\", \",\", \"y\"}], \"}\"}]\) of graph g."
Combinatorica`CostOfPath::usage = "\!\(\*RowBox[{\"CostOfPath\", \"[\", RowBox[{StyleBox[\"g\", \"TI\"], \",\", StyleBox[\"p\", \"TI\"]}], \"]\"}]\) sums up the weights of the edges in graph g defined by the path p."
Combinatorica`CoxeterGraph::usage = "CoxeterGraph gives a non-Hamiltonian graph with a high degree of symmetry such that there is a graph automorphism taking any path of length 3 to any other."
Combinatorica`CubeConnectedCycle::usage = "\!\(\*RowBox[{\"CubeConnectedCycle\", \"[\", StyleBox[\"d\", \"TI\"], \"]\"}]\) returns the graph obtained by replacing each vertex in a d-dimensional hypercube by a cycle of length d. Cube-connected cycles share many properties with hypercubes but have the additional desirable property that for \!\(\*RowBox[{\"d\", \">\", \"1\"}]\) every vertex has degree 3."
Combinatorica`CubicalGraph::usage = "CubicalGraph returns the graph corresponding to the cube, a Platonic solid."
Combinatorica`Cut::usage = "Cut is a tag that can be used in a call to NetworkFlow to tell it to return the minimum cut."
Combinatorica`CycleIndex::usage = "\!\(\*RowBox[{\"CycleIndex\", \"[\", RowBox[{StyleBox[\"pg\", \"TI\"], \",\", StyleBox[\"x\", \"TI\"]}], \"]\"}]\) returns the polynomial in \!\(\*RowBox[{RowBox[{\"x\", \"[\", \"1\", \"]\"}], \",\", RowBox[{\"x\", \"[\", \"2\", \"]\"}], \",\", \"\[Ellipsis]\", \",\", RowBox[{\"x\", \"[\", RowBox[{StyleBox[\"index\", \"TI\"], \"[\", StyleBox[\"pg\", \"TI\"], \"]\"}], \"]\"}]}]\) that is the cycle index of the permutation group \!\(\*StyleBox[\"pg\", \"TI\"]\). Here \!\(\*RowBox[{StyleBox[\"index\", \"TI\"], \"[\", StyleBox[\"pg\", \"TI\"], \"]\"}]\) refers to the length of each permutation in \!\(\*StyleBox[\"pg\", \"TI\"]\)."
Combinatorica`Cycle::usage = "\!\(\*RowBox[{\"Cycle\", \"[\", StyleBox[\"n\", \"TI\"], \"]\"}]\) constructs the cycle on n vertices, the 2-regular connected graph. An option Type that takes on values Directed or Undirected is allowed. The default setting is \!\(\*RowBox[{\"Type\", \"->\", \"Undirected\"}]\)."
Combinatorica`Cycles::usage = "Cycles is an optional argument for the function Involutions."
Combinatorica`CycleStructure::usage = "\!\(\*RowBox[{\"CycleStructure\", \"[\", RowBox[{StyleBox[\"p\", \"TI\"], \",\", StyleBox[\"x\", \"TI\"]}], \"]\"}]\) returns the monomial in \!\(\*RowBox[{\"x\", \"[\", \"1\", \"]\"}]\), \!\(\*RowBox[{\"x\", \"[\", \"2\", \"]\"}]\), \[Ellipsis], \!\(\*RowBox[{RowBox[{StyleBox[\"x\", \"TI\"], \"[\", RowBox[{RowBox[{\"Length\", \"[\"}], StyleBox[\"p\", \"TI\"]}], \"]\"}], \"]\"}]\) that is the cycle structure of the permutation p."
Combinatorica`CyclicGroupIndex::usage = "\!\(\*RowBox[{\"CyclicGroupIndex\", \"[\", RowBox[{StyleBox[\"n\", \"TI\"], \",\", StyleBox[\"x\", \"TI\"]}], \"]\"}]\) returns the cycle index of the cyclic group on n symbols, expressed as a polynomial in \!\(\*RowBox[{RowBox[{\"x\", \"[\", \"1\", \"]\"}], \",\", RowBox[{\"x\", \"[\", \"2\", \"]\"}], \",\", \"\[Ellipsis]\", \",\", RowBox[{\"x\", \"[\", \"n\", \"]\"}]}]\)."
Combinatorica`CyclicGroup::usage = "\!\(\*RowBox[{\"CyclicGroup\", \"[\", StyleBox[\"n\", \"TI\"], \"]\"}]\) returns the cyclic group of permutations on n symbols."
Combinatorica`Cyclic::usage = "Cyclic is an argument to the Polya-theoretic functions ListNecklaces, NumberOfNecklaces, and NecklacePolynomial, which count or enumerate distinct necklaces. Cyclic refers to the cyclic group acting on necklaces to make equivalent necklaces that can be obtained from each other by rotation."
Combinatorica`DeBruijnGraph::usage = "\!\(\*RowBox[{\"DeBruijnGraph\", \"[\", RowBox[{StyleBox[\"m\", \"TI\"], \",\", StyleBox[\"n\", \"TI\"]}], \"]\"}]\) constructs the n-dimensional De Bruijn graph with m symbols for integers \!\(\*RowBox[{\"m\", \">\", \"0\"}]\) and \!\(\*RowBox[{\"n\", \">\", \"1\"}]\). \n\!\(\*RowBox[{\"DeBruijnGraph\", \"[\", RowBox[{StyleBox[\"alph\", \"TI\"], \",\", StyleBox[\"n\", \"TI\"]}], \"]\"}]\) constructs the n-dimensional De Bruijn graph with symbols from \!\(\*StyleBox[\"alph\", \"TI\"]\). Here \!\(\*StyleBox[\"alph\", \"TI\"]\) is nonempty and \!\(\*RowBox[{\"n\", \">\", \"1\"}]\) is an integer. In the latter form, the function accepts an option VertexLabel, with default value False, which can be set to True, if users want to associate strings on \!\(\*StyleBox[\"alph\", \"TI\"]\) to the vertices as labels."
Combinatorica`DeBruijnSequence::usage = "\!\(\*RowBox[{\"DeBruijnSequence\", \"[\", RowBox[{StyleBox[\"a\", \"TI\"], \",\", StyleBox[\"n\", \"TI\"]}], \"]\"}]\) returns a De Bruijn sequence on the alphabet a, a shortest sequence in which every string of length n on alphabet a occurs as a contiguous subsequence."
Combinatorica`DegreeSequence::usage = "\!\(\*RowBox[{\"DegreeSequence\", \"[\", StyleBox[\"g\", \"TI\"], \"]\"}]\) gives the sorted degree sequence of graph g."
Combinatorica`Degrees::usage = "\!\(\*RowBox[{\"Degrees\", \"[\", StyleBox[\"g\", \"TI\"], \"]\"}]\) returns the degrees of vertex \!\(\*RowBox[{\"1\", \",\", \"2\", \",\", \"3\", \",\", \"\[Ellipsis]\"}]\) in that order."
Combinatorica`DegreesOf2Neighborhood::usage = "\!\(\*RowBox[{\"DegreesOf2Neighborhood\", \"[\", RowBox[{StyleBox[\"g\", \"TI\"], \",\", StyleBox[\"v\", \"TI\"]}], \"]\"}]\) returns the sorted list of degrees of vertices of graph g within a distance of 2 from v."
Combinatorica`DeleteCycle::usage = "\!\(\*RowBox[{\"DeleteCycle\", \"[\", RowBox[{StyleBox[\"g\", \"TI\"], \",\", StyleBox[\"c\", \"TI\"]}], \"]\"}]\) deletes a simple cycle c from graph g. c is specified as a sequence of vertices in which the first and last vertices are identical. g can be directed or undirected. If g does not contain c, it is returned unchanged; otherwise g is returned with c deleted."
Combinatorica`DeleteEdge::usage = "\!\(\*RowBox[{\"DeleteEdge\", \"[\", RowBox[{StyleBox[\"g\", \"TI\"], \",\", StyleBox[\"e\", \"TI\"]}], \"]\"}]\) gives graph g minus e. If g is undirected, then e is treated as an undirected edge, otherwise it is treated as a directed edge. If there are multiple edges between the specified vertices, only one edge is deleted. \n\!\(\*RowBox[{\"DeleteEdge\", \"[\", RowBox[{StyleBox[\"g\", \"TI\"], \",\", StyleBox[\"e\", \"TI\"], \",\", \"All\"}], \"]\"}]\) will delete all edges between the specified pair of vertices. Using the tag Directed as a third argument in DeleteEdge is now obsolete."
Combinatorica`DeleteEdges::usage = "\!\(\*RowBox[{\"DeleteEdges\", \"[\", RowBox[{StyleBox[\"g\", \"TI\"], \",\", StyleBox[\"edgeList\", \"TI\"]}], \"]\"}]\) gives graph g minus the list of edges \!\(\*StyleBox[\"edgeList\", \"TI\"]\). If g is undirected, then the edges in \!\(\*StyleBox[\"edgeList\", \"TI\"]\) are treated as undirected edges, otherwise they are treated as directed edges. If there are multiple edges that qualify, then only one edge is deleted. \n\!\(\*RowBox[{RowBox[{\"DeleteEdges\", \"[\"}], StyleBox[\"g\", \"TI\"], \",\", StyleBox[\"edgeList\", \"TI\"], \",\", RowBox[{\"All\", \"]\"}]}]\) will delete all edges that qualify. If only one edge is to be deleted, then \!\(\*StyleBox[\"edgeList\", \"TI\"]\) can have the form \!\(\*RowBox[{\"{\", RowBox[{\"s\", \",\", \"t\"}], \"}\"}]\), otherwise it has the form \!\(\*RowBox[{\"{\", RowBox[{RowBox[{\"{\", RowBox[{SubscriptBox[\"s\", \"1\"], \",\", SubscriptBox[\"t\", \"1\"]}], \"}\"}], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[\"s\", \"2\"], \",\", SubscriptBox[\"t\", \"2\"]}], \"}\"}], \",\", \"\[Ellipsis]\"}], \"}\"}]\)."
Combinatorica`DeleteFromTableau::usage = "\!\(\*RowBox[{\"DeleteFromTableau\", \"[\", RowBox[{StyleBox[\"t\", \"TI\"], \",\", StyleBox[\"r\", \"TI\"]}], \"]\"}]\) deletes the last element of row r from Young tableau t."
Combinatorica`DeleteVertex::usage = "\!\(\*RowBox[{\"DeleteVertex\", \"[\", RowBox[{StyleBox[\"g\", \"TI\"], \",\", StyleBox[\"v\", \"TI\"]}], \"]\"}]\) deletes a single vertex v from graph g. Here v is a vertex number."
Combinatorica`DeleteVertices::usage = "\!\(\*RowBox[{\"DeleteVertices\", \"[\", RowBox[{StyleBox[\"g\", \"TI\"], \",\", StyleBox[\"vList\", \"TI\"]}], \"]\"}]\) deletes vertices in \!\(\*StyleBox[\"vList\", \"TI\"]\) from graph g. \!\(\*StyleBox[\"vList\", \"TI\"]\) has the form \!\(\*RowBox[{\"{\", RowBox[{\"i\", \",\", \"j\", \",\", \"\[Ellipsis]\"}], \"}\"}]\), where \!\(\*RowBox[{\"i\", \",\", \"j\", \",\", \"\[Ellipsis]\"}]\) are vertex numbers."
Combinatorica`DepthFirstTraversal::usage = "\!\(\*RowBox[{\"DepthFirstTraversal\", \"[\", RowBox[{StyleBox[\"g\", \"TI\"], \",\", StyleBox[\"v\", \"TI\"]}], \"]\"}]\) performs a depth-first traversal of graph g starting from vertex v, and gives a list of vertices in the order in which they were encountered. \n\!\(\*RowBox[{\"DepthFirstTraversal\", \"[\", RowBox[{StyleBox[\"g\", \"TI\"], \",\", StyleBox[\"v\", \"TI\"], \",\", \"Edge\"}], \"]\"}]\) returns the edges of the graph that are traversed by the depth-first traversal in the order in which they are traversed. \n\!\(\*RowBox[{\"DepthFirstTraversal\", \"[\", RowBox[{StyleBox[\"g\", \"TI\"], \",\", StyleBox[\"v\", \"TI\"], \",\", \"Tree\"}], \"]\"}]\) returns the depth-first tree of the graph."
Combinatorica`DerangementQ::usage = "\!\(\*RowBox[{\"DerangementQ\", \"[\", StyleBox[\"p\", \"TI\"], \"]\"}]\) tests whether permutation p is a derangement, that is, a permutation without a fixed point."
Combinatorica`Derangements::usage = "\!\(\*RowBox[{\"Derangements\", \"[\", StyleBox[\"p\", \"TI\"], \"]\"}]\) constructs all derangements of permutation p."
Combinatorica`Diameter::usage = "\!\(\*RowBox[{\"Diameter\", \"[\", StyleBox[\"g\", \"TI\"], \"]\"}]\) gives the diameter of graph g, the maximum length, among all pairs of vertices in g, of a shortest path between each pair."
Combinatorica`DihedralGroupIndex::usage = "\!\(\*RowBox[{\"DihedralGroupIndex\", \"[\", RowBox[{StyleBox[\"n\", \"TI\"], \",\", StyleBox[\"x\", \"TI\"]}], \"]\"}]\) returns the cycle index of the dihedral group on n symbols, expressed as a polynomial in \!\(\*RowBox[{RowBox[{\"x\", \"[\", \"1\", \"]\"}], \",\", RowBox[{\"x\", \"[\", \"2\", \"]\"}], \",\", \"\[Ellipsis]\", \",\", RowBox[{\"x\", \"[\", \"n\", \"]\"}]}]\)."
Combinatorica`DihedralGroup::usage = "\!\(\*RowBox[{\"DihedralGroup\", \"[\", StyleBox[\"n\", \"TI\"], \"]\"}]\) returns the dihedral group on n symbols. Note that the order of this group is \!\(\*RowBox[{\"2\", \"n\"}]\)."
Combinatorica`Dihedral::usage = "Dihedral is an argument to the Polya-theoretic functions ListNecklaces, NumberOfNecklaces, and NecklacePolynomial, which count or enumerate distinct necklaces. \nDihedral refers to the dihedral group acting on necklaces to make equivalent necklaces that can be obtained from each other by a rotation or a flip."
Combinatorica`Dijkstra::usage = "\!\(\*RowBox[{\"Dijkstra\", \"[\", RowBox[{StyleBox[\"g\", \"TI\"], \",\", StyleBox[\"v\", \"TI\"]}], \"]\"}]\) gives a shortest-path spanning tree and associated distances from vertex v of graph g. The shortest-path spanning tree is given by a list in which element i is the predecessor of vertex i in the shortest-path spanning tree. Dijkstra does not work correctly when the edge weights are negative; BellmanFord should be used in this case."
Combinatorica`DilateVertices::usage = "\!\(\*RowBox[{\"DilateVertices\", \"[\", RowBox[{StyleBox[\"v\", \"TI\"], \",\", StyleBox[\"d\", \"TI\"]}], \"]\"}]\) multiplies each coordinate of each vertex position in list v by d, thus dilating the embedding. \n\!\(\*RowBox[{\"DilateVertices\", \"[\", RowBox[{StyleBox[\"g\", \"TI\"], \",\", StyleBox[\"d\", \"TI\"]}], \"]\"}]\) dilates the embedding of graph g by the factor d."
Combinatorica`Directed::usage = "Directed is an option value for Type."
Combinatorica`Distances::usage = "\!\(\*RowBox[{\"Distances\", \"[\", RowBox[{StyleBox[\"g\", \"TI\"], \",\", StyleBox[\"v\", \"TI\"]}], \"]\"}]\) returns the distances in nondecreasing order from vertex v to all vertices in g, treating g as an unweighted graph."
Combinatorica`DistinctPermutations::usage = "\!\(\*RowBox[{\"DistinctPermutations\", \"[\", StyleBox[\"l\", \"TI\"], \"]\"}]\) gives all permutations of the multiset described by list l."
Combinatorica`Distribution::usage = "\!\(\*RowBox[{\"Distribution\", \"[\", RowBox[{StyleBox[\"l\", \"TI\"], \",\", StyleBox[\"set\", \"TI\"]}], \"]\"}]\) lists the frequency of each element of \!\(\*StyleBox[\"set\", \"TI\"]\) in list l."
Combinatorica`DodecahedralGraph::usage = "DodecahedralGraph returns the graph corresponding to the dodecahedron, a Platonic solid."
Combinatorica`DominatingIntegerPartitionQ::usage = "\!\(\*RowBox[{\"DominatingIntegerPartitionQ\", \"[\", RowBox[{StyleBox[\"a\", \"TI\"], \",\", StyleBox[\"b\", \"TI\"]}], \"]\"}]\) yields True if integer partition a dominates integer partition b, that is, the sum of a size-t prefix of a is no smaller than the sum of a size-t prefix of b for every t."
Combinatorica`DominationLattice::usage = "\!\(\*RowBox[{\"DominationLattice\", \"[\", StyleBox[\"n\", \"TI\"], \"]\"}]\) returns a Hasse diagram of the partially ordered set on integer partitions of n in which \!\(\*RowBox[{\"p\", \"<\", \"q\"}]\) if q dominates p. The function takes two options: Type and VertexLabel, with default values Undirected and False, respectively. When Type is set to Directed, the function produces the underlying directed acyclic graph. When VertexLabel is set to True, labels are produced for the vertices."
Combinatorica`DurfeeSquare::usage = "\!\(\*RowBox[{\"DurfeeSquare\", \"[\", StyleBox[\"p\", \"TI\"], \"]\"}]\) gives the number of rows involved in the Durfee square of partition p, the side of the largest-sized square contained within the Ferrers diagram of p."
Combinatorica`Eccentricity::usage = "\!\(\*RowBox[{\"Eccentricity\", \"[\", StyleBox[\"g\", \"TI\"], \"]\"}]\) gives the eccentricity of each vertex v of graph g, the maximum length among all shortest paths from v."
Combinatorica`EdgeChromaticNumber::usage = "\!\(\*RowBox[{\"EdgeChromaticNumber\", \"[\", StyleBox[\"g\", \"TI\"], \"]\"}]\) gives the fewest number of colors necessary to color each edge of graph g, so that no two edges incident on the same vertex have the same color."
Combinatorica`EdgeColoring::usage = "\!\(\*RowBox[{\"EdgeColoring\", \"[\", StyleBox[\"g\", \"TI\"], \"]\"}]\) uses Brelaz's heuristic to find a good, but not necessarily minimal, edge coloring of graph g."
Combinatorica`EdgeColor::usage = "EdgeColor is an option that allows the user to associate colors with edges. Black is the default color. EdgeColor can be set as part of the graph data structure or in ShowGraph."
Combinatorica`EdgeConnectivity::usage = "\!\(\*RowBox[{\"EdgeConnectivity\", \"[\", StyleBox[\"g\", \"TI\"], \"]\"}]\) gives the minimum number of edges whose deletion from graph g disconnects it. \n\!\(\*RowBox[{\"EdgeConnectivity\", \"[\", RowBox[{StyleBox[\"g\", \"TI\"], \",\", \"Cut\"}], \"]\"}]\) gives a set of edges of minimum size whose deletion disconnects the graph."
Combinatorica`EdgeDirection::usage = "EdgeDirection is an option that takes on values True or False allowing the user to specify whether the graph is directed or not. EdgeDirection can be set as part of the graph data structure or in ShowGraph."
Combinatorica`EdgeLabelColor::usage = "EdgeLabelColor is an option that allows the user to associate different colors to edge labels. Black is the default color. EdgeLabelColor can be set as part of the graph data structure or in ShowGraph."
Combinatorica`EdgeLabel::usage = "EdgeLabel is an option that can take on values True or False, allowing the user to associate labels to edges. By default, there are no edge labels. The EdgeLabel option can be set as part of the graph data structure or in ShowGraph."
Combinatorica`EdgeLabelPosition::usage = "EdgeLabelPosition is an option that allows the user to place an edge label in a certain position relative to the midpoint of the edge. LowerLeft is the default value of this option. EdgeLabelPosition can be set as part of the graph data structure or in ShowGraph."
Combinatorica`Edge::usage = "Edge is an optional argument to inform certain functions to work with edges instead of vertices."
Combinatorica`Edges::usage = "\!\(\*RowBox[{\"Edges\", \"[\", StyleBox[\"g\", \"TI\"], \"]\"}]\) gives the list of edges in g. \n\!\(\*RowBox[{\"Edges\", \"[\", RowBox[{StyleBox[\"g\", \"TI\"], \",\", \"All\"}], \"]\"}]\) gives the edges of g along with the graphics options associated with each edge. \n\!\(\*RowBox[{\"Edges\", \"[\", RowBox[{StyleBox[\"g\", \"TI\"], \",\", \"EdgeWeight\"}], \"]\"}]\) returns the list of edges in g along with their edge weights."
Combinatorica`EdgeStyle::usage = "EdgeStyle is an option that allows the user to associate different sizes and shapes to edges. A line segment is the default edge. EdgeStyle can be set as part of the graph data structure or in ShowGraph."
Combinatorica`EdgeWeight::usage = "EdgeWeight is an option that allows the user to associate weights with edges. 1 is the default weight. EdgeWeight can be set as part of the graph data structure."
Combinatorica`EmptyGraph::usage = "\!\(\*RowBox[{\"EmptyGraph\", \"[\", StyleBox[\"n\", \"TI\"], \"]\"}]\) generates an empty graph on n vertices. An option Type that can take on values Directed or Undirected is provided. The default setting is \!\(\*RowBox[{\"Type\", \"->\", \"Undirected\"}]\)."
Combinatorica`EmptyQ::usage = "\!\(\*RowBox[{\"EmptyQ\", \"[\", StyleBox[\"g\", \"TI\"], \"]\"}]\) yields True if graph g contains no edges."
Combinatorica`EncroachingListSet::usage = "\!\(\*RowBox[{\"EncroachingListSet\", \"[\", StyleBox[\"p\", \"TI\"], \"]\"}]\) constructs the encroaching list set associated with permutation p."
Combinatorica`EquivalenceClasses::usage = "\!\(\*RowBox[{\"EquivalenceClasses\", \"[\", StyleBox[\"r\", \"TI\"], \"]\"}]\) identifies the equivalence classes among the elements of matrix r."
Combinatorica`EquivalenceRelationQ::usage = "\!\(\*RowBox[{\"EquivalenceRelationQ\", \"[\", StyleBox[\"r\", \"TI\"], \"]\"}]\) yields True if the matrix r defines an equivalence relation. \n\!\(\*RowBox[{\"EquivalenceRelationQ\", \"[\", StyleBox[\"g\", \"TI\"], \"]\"}]\) tests whether the adjacency matrix of graph g defines an equivalence relation."
Combinatorica`Equivalences::usage = "\!\(\*RowBox[{\"Equivalences\", \"[\", RowBox[{StyleBox[\"g\", \"TI\"], \",\", StyleBox[\"h\", \"TI\"]}], \"]\"}]\) lists the vertex equivalence classes between graphs g and h defined by their vertex degrees. \n\!\(\*RowBox[{\"Equivalences\", \"[\", StyleBox[\"g\", \"TI\"], \"]\"}]\) lists the vertex equivalences for graph g defined by the vertex degrees. \n\!\(\*RowBox[{\"Equivalences\", \"[\", RowBox[{StyleBox[\"g\", \"TI\"], \",\", StyleBox[\"h\", \"TI\"], \",\", SubscriptBox[StyleBox[\"f\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"f\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TI\"]}], \"]\"}]\) and \!\(\*RowBox[{\"Equivalences\", \"[\", RowBox[{StyleBox[\"g\", \"TI\"], \",\", SubscriptBox[StyleBox[\"f\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"f\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TI\"]}], \"]\"}]\) can also be used, where \!\(\*RowBox[{SubscriptBox[\"f\", \"1\"], \",\", SubscriptBox[\"f\", \"2\"], \",\", \"\[Ellipsis]\"}]\) are functions that compute other vertex invariants. It is expected that for each function \!\(\*SubscriptBox[\"f\", \"i\"]\), the call \!\(\*RowBox[{SubscriptBox[\"f\", \"i\"], \"[\", RowBox[{\"g\", \",\", \"v\"}], \"]\"}]\) returns the corresponding invariant at vertex v in graph g. The functions \!\(\*RowBox[{SubscriptBox[\"f\", \"1\"], \",\", SubscriptBox[\"f\", \"2\"], \",\", \"\[Ellipsis]\"}]\) are evaluated in order, and the evaluation stops either when all functions have been evaluated or when an empty equivalence class is found. Three vertex invariants, DegreesOf2Neighborhood, NumberOf2Paths, and Distances are \!\(\*StyleBox[\"Combinatorica\", FontSlant -> \"Italic\"]\) functions and can be used to refine the equivalences."
Combinatorica`Euclidean::usage = "Euclidean is an option for SetEdgeWeights."
Combinatorica`EulerianCycle::usage = "\!\(\*RowBox[{\"EulerianCycle\", \"[\", StyleBox[\"g\", \"TI\"], \"]\"}]\) finds an Eulerian cycle of g if one exists."
Combinatorica`Eulerian::usage = "\!\(\*RowBox[{\"Eulerian\", \"[\", RowBox[{StyleBox[\"n\", \"TI\"], \",\", StyleBox[\"k\", \"TI\"]}], \"]\"}]\) gives the number of permutations of length n with k runs."
Combinatorica`EulerianQ::usage = "\!\(\*RowBox[{\"EulerianQ\", \"[\", StyleBox[\"g\", \"TI\"], \"]\"}]\) yields True if graph g is Eulerian, meaning there exists a tour that includes each edge exactly once."
Combinatorica`ExactRandomGraph::usage = "\!\(\*RowBox[{\"ExactRandomGraph\", \"[\", RowBox[{StyleBox[\"n\", \"TI\"], \",\", StyleBox[\"e\", \"TI\"]}], \"]\"}]\) constructs a random labeled graph of exactly e edges and n vertices."
Combinatorica`ExpandGraph::usage = "\!\(\*RowBox[{\"ExpandGraph\", \"[\", RowBox[{StyleBox[\"g\", \"TI\"], \",\", StyleBox[\"n\", \"TI\"]}], \"]\"}]\) expands graph g to n vertices by adding disconnected vertices. This is obsolete; use \!\(\*RowBox[{\"AddVertices\", \"[\", RowBox[{StyleBox[\"g\", \"TI\"], \",\", StyleBox[\"n\", \"TI\"]}], \"]\"}]\) instead."
Combinatorica`ExtractCycles::usage = "\!\(\*RowBox[{\"ExtractCycles\", \"[\", StyleBox[\"g\", \"TI\"], \"]\"}]\) gives a maximal list of edge-disjoint cycles in graph g."
Combinatorica`FerrersDiagram::usage = "\!\(\*RowBox[{\"FerrersDiagram\", \"[\", StyleBox[\"p\", \"TI\"], \"]\"}]\) draws a Ferrers diagram of integer partition p."
Combinatorica`FindCycle::usage = "\!\(\*RowBox[{\"FindCycle\", \"[\", StyleBox[\"g\", \"TI\"], \"]\"}]\) finds a list of vertices that define a cycle in graph g."
Combinatorica`FindSet::usage = "\!\(\*RowBox[{\"FindSet\", \"[\", RowBox[{StyleBox[\"n\", \"TI\"], \",\", StyleBox[\"s\", \"TI\"]}], \"]\"}]\) gives the root of the set containing n in union-find data structure s."
Combinatorica`FiniteGraphs::usage = "FiniteGraphs produces a convenient list of all the interesting, finite, parameterless graphs built into \!\(\*StyleBox[\"Combinatorica\", FontSlant -> \"Italic\"]\)."
Combinatorica`FirstLexicographicTableau::usage = "\!\(\*RowBox[{\"FirstLexicographicTableau\", \"[\", StyleBox[\"p\", \"TI\"], \"]\"}]\) constructs the first Young tableau with shape described by partition p."
Combinatorica`FolkmanGraph::usage = "FolkmanGraph returns a smallest graph that is edge-transitive but not vertex-transitive."
Combinatorica`FranklinGraph::usage = "FranklinGraph returns a 12-vertex graph that represents a 6-chromatic map on the Klein bottle. It is the sole counterexample to Heawood's map-coloring conjecture."
Combinatorica`FromAdjacencyLists::usage = "\!\(\*RowBox[{\"FromAdjacencyLists\", \"[\", StyleBox[\"l\", \"TI\"], \"]\"}]\) constructs an edge list representation for a graph from the given adjacency lists l, using a circular embedding. \n\!\(\*RowBox[{\"FromAdjacencyLists\", \"[\", RowBox[{StyleBox[\"l\", \"TI\"], \",\", StyleBox[\"v\", \"TI\"]}], \"]\"}]\) uses v as the embedding for the resulting graph. An option called Type that takes on the values Directed or Undirected can be used to affect the type of graph produced. The default value of Type is Undirected."
Combinatorica`FromAdjacencyMatrix::usage = "\!\(\*RowBox[{\"FromAdjacencyMatrix\", \"[\", StyleBox[\"m\", \"TI\"], \"]\"}]\) constructs a graph from a given adjacency matrix m, using a circular embedding. \n\!\(\*RowBox[{\"FromAdjacencyMatrix\", \"[\", RowBox[{StyleBox[\"m\", \"TI\"], \",\", StyleBox[\"v\", \"TI\"]}], \"]\"}]\) uses v as the embedding for the resulting graph. An option Type that takes on the values Directed or Undirected can be used to affect the type of graph produced. The default value of Type is Undirected. \n\!\(\*RowBox[{\"FromAdjacencyMatrix\", \"[\", RowBox[{StyleBox[\"m\", \"TI\"], \",\", \"EdgeWeight\"}], \"]\"}]\) interprets the entries in m as edge weights, with infinity representing missing edges, and from this constructs a weighted graph using a circular embedding. \n\!\(\*RowBox[{\"FromAdjacencyMatrix\", \"[\", RowBox[{StyleBox[\"m\", \"TI\"], \",\", StyleBox[\"v\", \"TI\"], \",\", \"EdgeWeight\"}], \"]\"}]\) uses v as the embedding for the resulting graph. The option Type can be used along with the EdgeWeight tag."
Combinatorica`FromCycles::usage = "\!\(\*RowBox[{\"FromCycles\", \"[\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"c\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"c\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TI\"]}], \"}\"}], \"]\"}]\) gives the permutation that has the given cycle structure."
Combinatorica`FromInversionVector::usage = "\!\(\*RowBox[{\"FromInversionVector\", \"[\", StyleBox[\"v\", \"TI\"], \"]\"}]\) reconstructs the unique permutation with inversion vector v."
Combinatorica`FromOrderedPairs::usage = "\!\(\*RowBox[{\"FromOrderedPairs\", \"[\", StyleBox[\"l\", \"TI\"], \"]\"}]\) constructs an edge list representation from a list of ordered pairs l, using a circular embedding. \n\!\(\*RowBox[{\"FromOrderedPairs\", \"[\", RowBox[{StyleBox[\"l\", \"TI\"], \",\", StyleBox[\"v\", \"TI\"]}], \"]\"}]\) uses v as the embedding for the resulting graph. The option Type that takes on values Undirected or Directed can be used to affect the kind of graph produced. The default value of Type is Directed. \!\(\*RowBox[{\"Type\", \"->\", \"Undirected\"}]\) results in the underlying undirected graph."
Combinatorica`FromUnorderedPairs::usage = "\!\(\*RowBox[{\"FromUnorderedPairs\", \"[\", StyleBox[\"l\", \"TI\"], \"]\"}]\) constructs an edge list representation from a list of unordered pairs l, using a circular embedding.\n\!\(\*RowBox[{\"FromUnorderedPairs\", \"[\", RowBox[{StyleBox[\"l\", \"TI\"], \",\", StyleBox[\"v\", \"TI\"]}], \"]\"}]\) uses v as the embedding for the resulting graph. The option Type that takes on values Undirected or Directed can be used to affect the kind of graph produced."
Combinatorica`FruchtGraph::usage = "FruchtGraph returns the smallest 3-regular graph whose automorphism group consists of only the identity."
Combinatorica`FunctionalGraph::usage = "\!\(\*RowBox[{\"FunctionalGraph\", \"[\", RowBox[{StyleBox[\"f\", \"TI\"], \",\", StyleBox[\"v\", \"TI\"]}], \"]\"}]\) takes a set v and a function f from v to v and constructs a directed graph with vertex set v and edges \!\(\*RowBox[{\"(\", RowBox[{\"x\", \",\", RowBox[{\"f\", \"[\", \"x\", \"]\"}]}], \")\"}]\) for each x in v. \n\!\(\*RowBox[{\"FunctionalGraph\", \"[\", RowBox[{RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"f\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"f\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \",\", StyleBox[\"v\", \"TI\"]}], \"]\"}]\) constructs a graph with vertex set v and edge set \!\(\*RowBox[{\"(\", RowBox[{\"x\", \",\", RowBox[{SubscriptBox[\"f\", \"i\"], \"[\", \"x\", \"]\"}]}], \")\"}]\) for each \!\(\*SubscriptBox[\"f\", \"i\"]\). An option called Type that takes on the values Directed and Undirected is allowed. \!\(\*RowBox[{\"Type\", \"->\", \"Directed\"}]\) is the default, while \!\(\*RowBox[{\"Type\", \"->\", \"Undirected\"}]\) returns the corresponding underlying undirected graph. \n\!\(\*RowBox[{\"FunctionalGraph\", \"[\", RowBox[{StyleBox[\"f\", \"TI\"], \",\", StyleBox[\"n\", \"TI\"]}], \"]\"}]\) takes a nonnegative integer n and a function f from \!\(\*RowBox[{\"{\", RowBox[{\"0\", \",\", \"1\", \",\", \"\[Ellipsis]\", \",\", RowBox[{\"n\", \"-\", \"1\"}]}], \"}\"}]\) onto itself and produces the directed graph with vertex set \!\(\*RowBox[{\"{\", RowBox[{\"0\", \",\", \"1\", \",\", \"\[Ellipsis]\", \",\", RowBox[{\"n\", \"-\", \"1\"}]}], \"}\"}]\) and edge set \!\(\*RowBox[{\"{\", RowBox[{\"x\", \",\", RowBox[{\"f\", \"[\", \"x\", \"]\"}]}], \"}\"}]\) for each vertex x."
Combinatorica`GeneralizedPetersenGraph::usage = "\!\(\*RowBox[{\"GeneralizedPetersenGraph\", \"[\", RowBox[{StyleBox[\"n\", \"TI\"], \",\", StyleBox[\"k\", \"TI\"]}], \"]\"}]\) returns the generalized Petersen graph, for integers \!\(\*RowBox[{\"n\", \">\", \"1\"}]\) and \!\(\*RowBox[{\"k\", \">\", \"0\"}]\), which is the graph with vertices \!\(\*RowBox[{\"{\", RowBox[{SubscriptBox[\"u\", \"1\"], \",\", SubscriptBox[\"u\", \"2\"], \",\", \"\[Ellipsis]\", \",\", SubscriptBox[\"u\", \"n\"]}], \"}\"}]\) and \!\(\*RowBox[{\"{\", RowBox[{SubscriptBox[\"v\", \"1\"], \",\", SubscriptBox[\"v\", \"2\"], \",\", \"\[Ellipsis]\", \",\", SubscriptBox[\"v\", \"n\"]}], \"}\"}]\) and edges \!\(\*RowBox[{RowBox[{\"{\", RowBox[{SubscriptBox[\"u\", \"i\"], \",\", RowBox[{\"u\", RowBox[{\"(\", RowBox[{\"i\", \"+\", \"1\"}], \")\"}]}]}], \"}\"}], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[\"v\", \"i\"], \",\", RowBox[{\"v\", RowBox[{\"(\", RowBox[{\"i\", \"+\", \"k\"}], \")\"}]}]}], \"}\"}]}]\), and \!\(\*RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"u\", \"TI\"], StyleBox[\"i\", \"TI\"]], \",\", SubscriptBox[StyleBox[\"v\", \"TI\"], StyleBox[\"i\", \"TI\"]]}], \"}\"}]\). The Petersen graph is identical to the generalized Petersen graph with \!\(\*RowBox[{\"n\", \"=\", \"5\"}]\) and \!\(\*RowBox[{\"k\", \"=\", \"2\"}]\)."
Combinatorica`GetEdgeLabels::usage = "\!\(\*RowBox[{\"GetEdgeLabels\", \"[\", StyleBox[\"g\", \"TI\"], \"]\"}]\) returns the list of labels of the edges of g. \n\!\(\*RowBox[{RowBox[{RowBox[{RowBox[{\"GetEdgeLabels\", \"[\"}], StyleBox[\"g\", \"TI\"]}], \",\", StyleBox[\"e\", \"TI\"]}], \"]\"}]\) returns the list of labels in graph g of the edges in e."
Combinatorica`GetEdgeWeights::usage = "\!\(\*RowBox[{\"GetEdgeWeights\", \"[\", StyleBox[\"g\", \"TI\"], \"]\"}]\) returns the list of weights of the edges of g. \n\!\(\*RowBox[{\"GetEdgeWeights\", \"[\", RowBox[{StyleBox[\"g\", \"TI\"], \",\", StyleBox[\"e\", \"TI\"]}], \"]\"}]\) returns the list of weights in graph g of the edges in e."
Combinatorica`GetVertexLabels::usage = "\!\(\*RowBox[{\"GetVertexLabels\", \"[\", StyleBox[\"g\", \"TI\"], \"]\"}]\) returns the list of labels of vertices of g. \n\!\(\*RowBox[{\"GetVertexLabels\", \"[\", RowBox[{StyleBox[\"g\", \"TI\"], \",\", StyleBox[\"v\", \"TI\"]}], \"]\"}]\) returns the list of labels in graph g of the vertices specified in list v."
Combinatorica`GetVertexWeights::usage = "\!\(\*RowBox[{\"GetVertexWeights\", \"[\", StyleBox[\"g\", \"TI\"], \"]\"}]\) returns the list of weights of vertices of g. \n\!\(\*RowBox[{\"GetVertexWeights\", \"[\", RowBox[{StyleBox[\"g\", \"TI\"], \",\", StyleBox[\"v\", \"TI\"]}], \"]\"}]\) returns the list of weights in graph g of the vertices in v."
Combinatorica`Girth::usage = "\!\(\*RowBox[{\"Girth\", \"[\", StyleBox[\"g\", \"TI\"], \"]\"}]\) gives the length of a shortest cycle in a simple graph g."
Combinatorica`GraphCenter::usage = "\!\(\*RowBox[{\"GraphCenter\", \"[\", StyleBox[\"g\", \"TI\"], \"]\"}]\) gives a list of the vertices of graph g with minimum eccentricity."
Combinatorica`GraphComplement::usage = "\!\(\*RowBox[{\"GraphComplement\", \"[\", StyleBox[\"g\", \"TI\"], \"]\"}]\) gives the complement of graph g."
Combinatorica`GraphDifference::usage = "\!\(\*RowBox[{\"GraphDifference\", \"[\", RowBox[{StyleBox[\"g\", \"TI\"], \",\", StyleBox[\"h\", \"TI\"]}], \"]\"}]\) constructs the graph resulting from subtracting the edges of graph h from the edges of graph g."
Combinatorica`GraphicQ::usage = "\!\(\*RowBox[{\"GraphicQ\", \"[\", StyleBox[\"s\", \"TI\"], \"]\"}]\) yields True if the list of integers s is a graphic sequence, and thus represents a degree sequence of some graph."
Combinatorica`GraphIntersection::usage = "\!\(\*RowBox[{\"GraphIntersection\", \"[\", RowBox[{SubscriptBox[StyleBox[\"g\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"g\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) constructs the graph defined by the edges that are in all the graphs \!\(\*RowBox[{SubscriptBox[\"g\", \"1\"], \",\", SubscriptBox[\"g\", \"2\"], \",\", \"\[Ellipsis]\"}]\)."
Combinatorica`GraphJoin::usage = "\!\(\*RowBox[{\"GraphJoin\", \"[\", RowBox[{SubscriptBox[StyleBox[\"g\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"g\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TI\"]}], \"]\"}]\) constructs the join of graphs \!\(\*SubscriptBox[\"g\", \"1\"]\), \!\(\*SubscriptBox[\"g\", \"2\"]\), and so on. This is the graph obtained by adding all possible edges between different graphs to the graph union of \!\(\*RowBox[{SubscriptBox[\"g\", \"1\"], \",\", SubscriptBox[\"g\", \"2\"], \",\", \"\[Ellipsis]\"}]\)."
Combinatorica`Graph::usage = "\!\(\*RowBox[{\"Graph\", \"[\", RowBox[{StyleBox[\"e\", \"TI\"], \",\", StyleBox[\"v\", \"TI\"], \",\", StyleBox[\"opts\", \"TI\"]}], \"]\"}]\) represents a graph object where e is the list of edges annotated with graphics options, v is a list of vertices annotated with graphics options, and \!\(\*StyleBox[\"opts\", \"TI\"]\) is a set of global graph options."
Combinatorica`GraphOptions::usage = "\!\(\*RowBox[{\"GraphOptions\", \"[\", StyleBox[\"g\", \"TI\"], \"]\"}]\) returns the display options associated with g. \n\!\(\*RowBox[{\"GraphOptions\", \"[\", RowBox[{StyleBox[\"g\", \"TI\"], \",\", StyleBox[\"v\", \"TI\"]}], \"]\"}]\) returns the display options associated with vertex v in g. \n\!\(\*RowBox[{\"GraphOptions\", \"[\", RowBox[{StyleBox[\"g\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{StyleBox[\"u\", \"TI\"], \",\", StyleBox[\"v\", \"TI\"]}], \"}\"}]}], \"]\"}]\) returns the display options associated with edge \!\(\*RowBox[{\"{\", RowBox[{\"u\", \",\", \"v\"}], \"}\"}]\) in g."
Combinatorica`GraphPolynomial::usage = "\!\(\*RowBox[{\"GraphPolynomial\", \"[\", RowBox[{StyleBox[\"n\", \"TI\"], \",\", StyleBox[\"x\", \"TI\"]}], \"]\"}]\) returns a polynomial in x in which the coefficient of \!\(\*SuperscriptBox[\"x\", \"m\"]\) is the number of nonisomorphic graphs with n vertices and m edges. \n\!\(\*RowBox[{\"GraphPolynomial\", \"[\", RowBox[{StyleBox[\"n\", \"TI\"], \",\", StyleBox[\"x\", \"TI\"], \",\", \"Directed\"}], \"]\"}]\) returns a polynomial in x in which the coefficient of \!\(\*SuperscriptBox[\"x\", \"m\"]\) is the number of nonisomorphic directed graphs with n vertices and m edges."
Combinatorica`GraphPower::usage = "\!\(\*RowBox[{\"GraphPower\", \"[\", RowBox[{StyleBox[\"g\", \"TI\"], \",\", StyleBox[\"k\", \"TI\"]}], \"]\"}]\) gives the k\!\(\*SuperscriptBox[\"\[Null]\", \"th\"]\) power of graph g. This is the graph whose vertex set is identical to the vertex set of g and that contains an edge between vertices i and j for each path in g between vertices i and j of length at most k."
Combinatorica`GraphProduct::usage = "\!\(\*RowBox[{\"GraphProduct\", \"[\", RowBox[{SubscriptBox[StyleBox[\"g\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"g\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) constructs the product of graphs \!\(\*SubscriptBox[\"g\", \"1\"]\), \!\(\*SubscriptBox[\"g\", \"2\"]\), and so forth."
Combinatorica`GraphSum::usage = "\!\(\*RowBox[{\"GraphSum\", \"[\", RowBox[{SubscriptBox[StyleBox[\"g\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"g\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) constructs the graph resulting from joining the edge lists of graphs \!\(\*SubscriptBox[\"g\", \"1\"]\), \!\(\*SubscriptBox[\"g\", \"2\"]\), and so forth."
Combinatorica`GraphUnion::usage = "\!\(\*RowBox[{\"GraphUnion\", \"[\", RowBox[{SubscriptBox[StyleBox[\"g\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"g\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) constructs the union of graphs \!\(\*SubscriptBox[\"g\", \"1\"]\), \!\(\*SubscriptBox[\"g\", \"2\"]\), and so forth. \n\!\(\*RowBox[{\"GraphUnion\", \"[\", RowBox[{StyleBox[\"n\", \"TI\"], \",\", StyleBox[\"g\", \"TI\"]}], \"]\"}]\) constructs n copies of graph g, for any nonnegative integer n."
Combinatorica`GrayCodeKSubsets::usage = "\!\(\*RowBox[{\"GrayCodeKSubsets\", \"[\", RowBox[{StyleBox[\"l\", \"TI\"], \",\", StyleBox[\"k\", \"TI\"]}], \"]\"}]\) generates k-subsets of l in Gray code order."
Combinatorica`GrayCode::usage = "\!\(\*RowBox[{\"GrayCode\", \"[\", StyleBox[\"l\", \"TI\"], \"]\"}]\) constructs a binary reflected Gray code on set l."
Combinatorica`GrayCodeSubsets::usage = "\!\(\*RowBox[{\"GrayCodeSubsets\", \"[\", StyleBox[\"l\", \"TI\"], \"]\"}]\) constructs a binary reflected Gray code on set l."
Combinatorica`GrayGraph::usage = "GrayGraph returns a 3-regular, 54-vertex graph that is edge-transitive but not vertex-transitive; the smallest known such example."
Combinatorica`Greedy::usage = "Greedy is a value that the option Algorithm can take in calls to functions such as VertexCover, telling the function to use a greedy algorithm."
Combinatorica`GreedyVertexCover::usage = "\!\(\*RowBox[{\"GreedyVertexCover\", \"[\", StyleBox[\"g\", \"TI\"], \"]\"}]\) returns a vertex cover of graph g constructed using the greedy algorithm. This is a natural heuristic for constructing a vertex cover, but it can produce poor vertex covers."
Combinatorica`GridGraph::usage = "\!\(\*RowBox[{\"GridGraph\", \"[\", RowBox[{StyleBox[\"n\", \"TI\"], \",\", StyleBox[\"m\", \"TI\"]}], \"]\"}]\) constructs an \!\(\*RowBox[{\"n\", \"*\", \"m\"}]\) grid graph, the product of paths on n and m vertices. \n\!\(\*RowBox[{\"GridGraph\", \"[\", RowBox[{StyleBox[\"p\", \"TI\"], \",\", StyleBox[\"q\", \"TI\"], \",\", StyleBox[\"r\", \"TI\"]}], \"]\"}]\) constructs a \!\(\*RowBox[{\"p\", \"*\", \"q\", \"*\", \"r\"}]\) grid graph, the product of \!\(\*RowBox[{\"GridGraph\", \"[\", RowBox[{StyleBox[\"p\", \"TI\"], \",\", StyleBox[\"q\", \"TI\"]}], \"]\"}]\) and a path of length r."
Combinatorica`GroetzschGraph::usage = "GroetzschGraph returns the smallest triangle-free graph with chromatic number 4. This is identical to \!\(\*RowBox[{\"MycielskiGraph\", \"[\", StyleBox[\"4\", \"TR\"], \"]\"}]\)."
Combinatorica`GrotztschGraph::usage = "GrotztschGraph returns the smallest triangle-free graph with chromatic number 4. This is identical to \!\(\*RowBox[{\"MycielskiGraph\", \"[\", StyleBox[\"4\", \"TR\"], \"]\"}]\)."
Combinatorica`HamiltonianCycle::usage = "\!\(\*RowBox[{\"HamiltonianCycle\", \"[\", StyleBox[\"g\", \"TI\"], \"]\"}]\) finds a Hamiltonian cycle in graph g if one exists. \n\!\(\*RowBox[{\"HamiltonianCycle\", \"[\", RowBox[{StyleBox[\"g\", \"TI\"], \",\", \"All\"}], \"]\"}]\) gives all Hamiltonian cycles of graph g."
Combinatorica`HamiltonianPath::usage = "\!\(\*RowBox[{\"HamiltonianPath\", \"[\", StyleBox[\"g\", \"TI\"], \"]\"}]\) finds a Hamiltonian path in graph g if one exists. \n\!\(\*RowBox[{\"HamiltonianPath\", \"[\", RowBox[{StyleBox[\"g\", \"TI\"], \",\", \"All\"}], \"]\"}]\) gives all Hamiltonian paths of graph g."
Combinatorica`HamiltonianQ::usage = "\!\(\*RowBox[{\"HamiltonianQ\", \"[\", StyleBox[\"g\", \"TI\"], \"]\"}]\) yields True if there exists a Hamiltonian cycle in graph g, or in other words, if there exists a cycle that visits each vertex exactly once."
Combinatorica`Harary::usage = "\!\(\*RowBox[{\"Harary\", \"[\", RowBox[{StyleBox[\"k\", \"TI\"], \",\", StyleBox[\"n\", \"TI\"]}], \"]\"}]\) constructs the minimal k-connected graph on n vertices."
Combinatorica`HasseDiagram::usage = "\!\(\*RowBox[{\"HasseDiagram\", \"[\", StyleBox[\"g\", \"TI\"], \"]\"}]\) constructs a Hasse diagram of the relation defined by directed acyclic graph g."
Combinatorica`Heapify::usage = "\!\(\*RowBox[{\"Heapify\", \"[\", StyleBox[\"p\", \"TI\"], \"]\"}]\) builds a heap from permutation p."
Combinatorica`HeapSort::usage = "\!\(\*RowBox[{\"HeapSort\", \"[\", StyleBox[\"l\", \"TI\"], \"]\"}]\) performs a heap sort on the items of list l."
Combinatorica`HeawoodGraph::usage = "HeawoodGraph returns a smallest \!\(\*RowBox[{\"(\", RowBox[{\"6\", \",\", \"3\"}], \")\"}]\)-cage, a 3-regular graph with girth 6."
Combinatorica`HerschelGraph::usage = "HerschelGraph returns a graph object that represents a Herschel graph."
Combinatorica`HideCycles::usage = "\!\(\*RowBox[{\"HideCycles\", \"[\", StyleBox[\"c\", \"TI\"], \"]\"}]\) canonically encodes the cycle structure c into a unique permutation."
Combinatorica`HighlightedEdgeColors::usage = "HighlightedEdgeColors is an option to Highlight that determines which colors are used for the highlighted edges."
Combinatorica`HighlightedEdgeStyle::usage = "HighlightedEdgeStyle is an option to Highlight that determines how the highlighted edges are drawn."
Combinatorica`HighlightedVertexColors::usage = "HighlightedVertexColors is an option to Highlight that determines which colors are used for the highlighted vertices."
Combinatorica`HighlightedVertexStyle::usage = "HighlightedVertexStyle is an option to Highlight that determines how the highlighted vertices are drawn."
Combinatorica`Highlight::usage = "\!\(\*RowBox[{\"Highlight\", \"[\", RowBox[{StyleBox[\"g\", \"TI\"], \",\", StyleBox[\"p\", \"TI\"]}], \"]\"}]\) displays g with elements in p highlighted. The second argument p has the form \!\(\*RowBox[{\"{\", RowBox[{SubscriptBox[\"s\", \"1\"], \",\", SubscriptBox[\"s\", \"2\"], \",\", \"\[Ellipsis]\"}], \"}\"}]\), where the \!\(\*SubscriptBox[\"s\", \"i\"]\) are disjoint subsets of vertices and edges of g."
Combinatorica`Hypercube::usage = "\!\(\*RowBox[{\"Hypercube\", \"[\", StyleBox[\"n\", \"TI\"], \"]\"}]\) constructs an n-dimensional hypercube."
Combinatorica`IcosahedralGraph::usage = "IcosahedralGraph returns the graph corresponding to the icosahedron, a Platonic solid."
Combinatorica`IdenticalQ::usage = "\!\(\*RowBox[{\"IdenticalQ\", \"[\", RowBox[{StyleBox[\"g\", \"TI\"], \",\", StyleBox[\"h\", \"TI\"]}], \"]\"}]\) yields True if graphs g and h have identical edge lists, even though the associated graphics information need not be the same."
Combinatorica`IdentityPermutation::usage = "\!\(\*RowBox[{\"IdentityPermutation\", \"[\", StyleBox[\"n\", \"TI\"], \"]\"}]\) gives the size-n identity permutation."
Combinatorica`IncidenceMatrix::usage = "\!\(\*RowBox[{\"IncidenceMatrix\", \"[\", StyleBox[\"g\", \"TI\"], \"]\"}]\) returns the \!\(\*RowBox[{\"(\", RowBox[{\"0\", \",\", \"1\"}], \")\"}]\)-matrix of graph g, which has a row for each vertex and a column for each edge and \!\(\*RowBox[{RowBox[{\"(\", RowBox[{\"v\", \",\", \"e\"}], \")\"}], \"=\", \"1\"}]\) if and only if vertex v is incident upon edge e. For a directed graph, \!\(\*RowBox[{RowBox[{\"(\", RowBox[{\"v\", \",\", \"e\"}], \")\"}], \"=\", \"1\"}]\) if edge e is outgoing from v."
Combinatorica`InDegree::usage = "\!\(\*RowBox[{\"InDegree\", \"[\", RowBox[{StyleBox[\"g\", \"TI\"], \",\", StyleBox[\"n\", \"TI\"]}], \"]\"}]\) returns the in-degree of vertex \!\(\*StyleBox[\"n\", \"TI\"]\) in directed graph g. \n\!\(\*RowBox[{\"InDegree\", \"[\", StyleBox[\"g\", \"TI\"], \"]\"}]\) returns the sequence of in-degrees of the vertices in directed graph g."
Combinatorica`IndependentSetQ::usage = "\!\(\*RowBox[{\"IndependentSetQ\", \"[\", RowBox[{StyleBox[\"g\", \"TI\"], \",\", StyleBox[\"i\", \"TI\"]}], \"]\"}]\) yields True if the vertices in list i define an independent set in graph g."
Combinatorica`Index::usage = "\!\(\*RowBox[{\"Index\", \"[\", StyleBox[\"p\", \"TI\"], \"]\"}]\) gives the index of permutation p, the sum of all subscripts j such that \!\(\*RowBox[{\"p\", \"\[LeftDoubleBracket]\", \"j\", \"\[RightDoubleBracket]\"}]\) is greater than \!\(\*RowBox[{\"p\", \"\[LeftDoubleBracket]\", RowBox[{\"j\", \"+\", \"1\"}], \"\[RightDoubleBracket]\"}]\)."
Combinatorica`InduceSubgraph::usage = "\!\(\*RowBox[{\"InduceSubgraph\", \"[\", RowBox[{StyleBox[\"g\", \"TI\"], \",\", StyleBox[\"s\", \"TI\"]}], \"]\"}]\) constructs the subgraph of graph g induced by the list of vertices s."
Combinatorica`InitializeUnionFind::usage = "\!\(\*RowBox[{\"InitializeUnionFind\", \"[\", StyleBox[\"n\", \"TI\"], \"]\"}]\) initializes a union-find data structure for n elements."
Combinatorica`InsertIntoTableau::usage = "\!\(\*RowBox[{\"InsertIntoTableau\", \"[\", RowBox[{StyleBox[\"e\", \"TI\"], \",\", StyleBox[\"t\", \"TI\"]}], \"]\"}]\) inserts integer e into Young tableau t using the bumping algorithm. \n\!\(\*RowBox[{\"InsertIntoTableau\", \"[\", RowBox[{StyleBox[\"e\", \"TI\"], \",\", StyleBox[\"t\", \"TI\"], \",\", \"All\"}], \"]\"}]\) inserts e into Young tableau t and returns the new tableau as well as the row whose size is expanded as a result of the insertion."
Combinatorica`IntervalGraph::usage = "\!\(\*RowBox[{\"IntervalGraph\", \"[\", StyleBox[\"l\", \"TI\"], \"]\"}]\) constructs the interval graph defined by the list of intervals l."
Combinatorica`Invariants::usage = "Invariants is an option to the functions Isomorphism and IsomorphicQ that informs these functions about which vertex invariants to use in computing equivalences between vertices."
Combinatorica`InversePermutation::usage = "\!\(\*RowBox[{\"InversePermutation\", \"[\", StyleBox[\"p\", \"TI\"], \"]\"}]\) yields the multiplicative inverse of permutation p."
Combinatorica`InversionPoset::usage = "\!\(\*RowBox[{\"InversionPoset\", \"[\", StyleBox[\"n\", \"TI\"], \"]\"}]\) returns a Hasse diagram of the partially ordered set on size-n permutations in which \!\(\*RowBox[{\"p\", \"<\", \"q\"}]\) if q can be obtained from p by an adjacent transposition that places the larger element before the smaller."
Combinatorica`Inversions::usage = "\!\(\*RowBox[{\"Inversions\", \"[\", StyleBox[\"p\", \"TI\"], \"]\"}]\) counts the number of inversions in permutation p."
Combinatorica`InvolutionQ::usage = "\!\(\*RowBox[{\"InvolutionQ\", \"[\", StyleBox[\"p\", \"TI\"], \"]\"}]\) yields True if permutation p is its own inverse."
Combinatorica`Involutions::usage = "\!\(\*RowBox[{\"Involutions\", \"[\", StyleBox[\"l\", \"TI\"], \"]\"}]\) gives the list of involutions of the elements in the list l. \n\!\(\*RowBox[{\"Involutions\", \"[\", RowBox[{StyleBox[\"l\", \"TI\"], \",\", \"Cycles\"}], \"]\"}]\) gives the involutions in their cycle representation. \n\!\(\*RowBox[{\"Involution\", \"[\", StyleBox[\"n\", \"TI\"], \"]\"}]\) gives size-n involutions. \n\!\(\*RowBox[{\"Involutions\", \"[\", RowBox[{StyleBox[\"n\", \"TI\"], \",\", \"Cycles\"}], \"]\"}]\) gives size-n involutions in their cycle representation."
Combinatorica`IsomorphicQ::usage = "\!\(\*RowBox[{\"IsomorphicQ\", \"[\", RowBox[{StyleBox[\"g\", \"TI\"], \",\", StyleBox[\"h\", \"TI\"]}], \"]\"}]\) yields True if graphs g and h are isomorphic. "
Combinatorica`Isomorphism::usage = "\!\(\*RowBox[{\"Isomorphism\", \"[\", RowBox[{StyleBox[\"g\", \"TI\"], \",\", StyleBox[\"h\", \"TI\"]}], \"]\"}]\) gives an isomorphism between graphs g and h if one exists. \n\!\(\*RowBox[{\"Isomorphism\", \"[\", RowBox[{StyleBox[\"g\", \"TI\"], \",\", StyleBox[\"h\", \"TI\"], \",\", \"All\"}], \"]\"}]\) gives all isomorphisms between graphs g and h. \n\!\(\*RowBox[{\"Isomorphism\", \"[\", StyleBox[\"g\", \"TI\"], \"]\"}]\) gives the automorphism group of g. "
Combinatorica`IsomorphismQ::usage = "\!\(\*RowBox[{\"IsomorphismQ\", \"[\", RowBox[{StyleBox[\"g\", \"TI\"], \",\", StyleBox[\"h\", \"TI\"], \",\", StyleBox[\"p\", \"TI\"]}], \"]\"}]\) tests if permutation p defines an isomorphism between graphs g and h."
Combinatorica`Josephus::usage = "\!\(\*RowBox[{\"Josephus\", \"[\", RowBox[{StyleBox[\"n\", \"TI\"], \",\", StyleBox[\"m\", \"TI\"]}], \"]\"}]\) generates the inverse of the permutation defined by executing every m\!\(\*SuperscriptBox[\"\[Null]\", \"th\"]\) member in a circle of n members."
Combinatorica`KnightsTourGraph::usage = "\!\(\*RowBox[{\"KnightsTourGraph\", \"[\", RowBox[{StyleBox[\"m\", \"TI\"], \",\", StyleBox[\"n\", \"TI\"]}], \"]\"}]\) returns a graph with \!\(\*StyleBox[\"mn\", \"TI\"]\) vertices in which each vertex represents a square in an m\[Times]n chessboard and each edge corresponds to a legal move by a knight from one square to another."
Combinatorica`KSetPartitions::usage = "\!\(\*RowBox[{\"KSetPartitions\", \"[\", RowBox[{StyleBox[\"set\", \"TI\"], \",\", StyleBox[\"k\", \"TI\"]}], \"]\"}]\) returns the list of set partitions of \!\(\*StyleBox[\"set\", \"TI\"]\) with k blocks. \n\!\(\*RowBox[{\"KSetPartitions\", \"[\", RowBox[{StyleBox[\"n\", \"TI\"], \",\", StyleBox[\"k\", \"TI\"]}], \"]\"}]\) returns the list of set partitions of \!\(\*RowBox[{\"{\", RowBox[{\"1\", \",\", \"2\", \",\", \"\[Ellipsis]\", \",\", \"n\"}], \"}\"}]\) with k blocks. If all set partitions of a set are needed, use the function SetPartitions."
Combinatorica`KSubsetGroupIndex::usage = "\!\(\*RowBox[{\"KSubsetGroupIndex\", \"[\", RowBox[{StyleBox[\"g\", \"TI\"], \",\", StyleBox[\"s\", \"TI\"], \",\", StyleBox[\"x\", \"TI\"]}], \"]\"}]\) returns the cycle index of the k-subset group on s expressed as a polynomial in \!\(\*RowBox[{RowBox[{\"x\", \"[\", \"1\", \"]\"}], \",\", RowBox[{\"x\", \"[\", \"2\", \"]\"}], \",\", \"\[Ellipsis]\"}]\). This function also takes the optional argument Type that tells the function whether the elements of s should be treated as sets or tuples."
Combinatorica`KSubsetGroup::usage = "\!\(\*RowBox[{\"KSubsetGroup\", \"[\", RowBox[{StyleBox[\"pg\", \"TI\"], \",\", StyleBox[\"s\", \"TI\"]}], \"]\"}]\) returns the group induced by a permutation group \!\(\*StyleBox[\"pg\", \"TI\"]\) on the set s of k-subsets of \!\(\*RowBox[{\"[\", \"n\", \"]\"}]\), where n is the index of \!\(\*StyleBox[\"pg\", \"TI\"]\). The optional argument Type can be Ordered or Unordered and depending on the value of \!\(\*RowBox[{\"Type\", StyleBox[\"s\", \"TI\"]}]\) is treated as a set of k-subsets or k-tuples."
Combinatorica`KSubsets::usage = "\!\(\*RowBox[{\"KSubsets\", \"[\", RowBox[{StyleBox[\"l\", \"TI\"], \",\", StyleBox[\"k\", \"TI\"]}], \"]\"}]\) gives all subsets of set l containing exactly k elements, ordered lexicographically."
Combinatorica`LabeledTreeToCode::usage = "\!\(\*RowBox[{\"LabeledTreeToCode\", \"[\", StyleBox[\"g\", \"TI\"], \"]\"}]\) reduces the tree g to its Pr\[UDoubleDot]fer code."
Combinatorica`LastLexicographicTableau::usage = "\!\(\*RowBox[{\"LastLexicographicTableau\", \"[\", StyleBox[\"p\", \"TI\"], \"]\"}]\) constructs the last Young tableau with shape described by partition p."
Combinatorica`LeviGraph::usage = "LeviGraph returns the unique \!\(\*RowBox[{\"(\", RowBox[{\"8\", \",\", \"3\"}], \")\"}]\)-cage, a 3-regular graph whose girth is 8."
Combinatorica`LexicographicPermutations::usage = "\!\(\*RowBox[{\"LexicographicPermutations\", \"[\", StyleBox[\"l\", \"TI\"], \"]\"}]\) constructs all permutations of list l in lexicographic order."
Combinatorica`LexicographicSubsets::usage = "\!\(\*RowBox[{\"LexicographicSubsets\", \"[\", StyleBox[\"l\", \"TI\"], \"]\"}]\) gives all subsets of set l in lexicographic order. \n\!\(\*RowBox[{\"LexicographicSubsets\", \"[\", StyleBox[\"n\", \"TI\"], \"]\"}]\) returns all subsets of \!\(\*RowBox[{\"{\", RowBox[{\"1\", \",\", \"2\", \",\", \"\[Ellipsis]\", \",\", \"n\"}], \"}\"}]\) in lexicographic order."
Combinatorica`LineGraph::usage = "\!\(\*RowBox[{\"LineGraph\", \"[\", StyleBox[\"g\", \"TI\"], \"]\"}]\) constructs the line graph of graph g."
Combinatorica`ListGraphs::usage = "\!\(\*RowBox[{\"ListGraphs\", \"[\", RowBox[{StyleBox[\"n\", \"TI\"], \",\", StyleBox[\"m\", \"TI\"]}], \"]\"}]\) returns all nonisomorphic undirected graphs with n vertices and m edges. \n\!\(\*RowBox[{\"ListGraphs\", \"[\", RowBox[{StyleBox[\"n\", \"TI\"], \",\", StyleBox[\"m\", \"TI\"], \",\", \"Directed\"}], \"]\"}]\) returns all nonisomorphic directed graphs with n vertices and m edges. \n\!\(\*RowBox[{\"ListGraphs\", \"[\", StyleBox[\"n\", \"TI\"], \"]\"}]\) returns all nonisomorphic undirected graphs with n vertices. \n\!\(\*RowBox[{\"ListGraphs\", \"[\", RowBox[{StyleBox[\"n\", \"TI\"], \",\", \"Directed\"}], \"]\"}]\) returns all nonisomorphic directed graphs with n vertices."
Combinatorica`ListNecklaces::usage = "\!\(\*RowBox[{\"ListNecklaces\", \"[\", RowBox[{StyleBox[\"n\", \"TI\"], \",\", StyleBox[\"c\", \"TI\"], \",\", \"Cyclic\"}], \"]\"}]\) returns all distinct necklaces whose beads are colored by colors from c. Here c is a list of n, not necessarily distinct colors, and two colored necklaces are considered equivalent if one can be obtained by rotating the other. \n\!\(\*RowBox[{RowBox[{RowBox[{RowBox[{\"ListNecklaces\", \"[\"}], StyleBox[\"n\", \"TI\"]}], \",\", StyleBox[\"c\", \"TI\"], \",\", \"Dihedral\"}], \"]\"}]\) is similar except that two necklaces are considered equivalent if one can be obtained from the other by a rotation or a flip."
Combinatorica`LNorm::usage = "\!\(\*RowBox[{\"LNorm\", \"[\", StyleBox[\"p\", \"TI\"], \"]\"}]\) is a value that the option WeightingFunction, used in the function SetEdgeWeights, can take. Here p can be any integer or Infinity."
Combinatorica`LongestIncreasingSubsequence::usage = "\!\(\*RowBox[{\"LongestIncreasingSubsequence\", \"[\", StyleBox[\"p\", \"TI\"], \"]\"}]\) finds the longest increasing scattered subsequence of permutation p."
Combinatorica`LoopPosition::usage = "LoopPosition is an option to ShowGraph whose values tell ShowGraph where to position a loop around a vertex. This option can take on values UpperLeft, UpperRight, LowerLeft, and LowerRight."
Combinatorica`LowerLeft::usage = "LowerLeft is a value that options VertexNumberPosition, VertexLabelPosition, and EdgeLabelPosition can take on in ShowGraph."
Combinatorica`LowerRight::usage = "LowerRight is a value that options VertexNumberPosition, VertexLabelPosition, and EdgeLabelPosition can take on in ShowGraph."
Combinatorica`MakeDirected::usage = "\!\(\*RowBox[{\"MakeDirected\", \"[\", StyleBox[\"g\", \"TI\"], \"]\"}]\) constructs a directed graph from a given undirected graph g by replacing each undirected edge in g by two directed edges pointing in opposite directions. "
Combinatorica`MakeGraph::usage = "\!\(\*RowBox[{\"MakeGraph\", \"[\", RowBox[{StyleBox[\"v\", \"TI\"], \",\", StyleBox[\"f\", \"TI\"]}], \"]\"}]\) constructs the graph whose vertices correspond to v and edges between pairs of vertices x and y in v for which the binary relation defined by the Boolean function f is True."
Combinatorica`MakeSimple::usage = "\!\(\*RowBox[{\"MakeSimple\", \"[\", StyleBox[\"g\", \"TI\"], \"]\"}]\) gives the undirected graph, free of multiple edges and self-loops derived from graph g."
Combinatorica`MakeUndirected::usage = "\!\(\*RowBox[{\"MakeUndirected\", \"[\", StyleBox[\"g\", \"TI\"], \"]\"}]\) gives the underlying undirected graph of the given directed graph g."
Combinatorica`MaximalMatching::usage = "\!\(\*RowBox[{\"MaximalMatching\", \"[\", StyleBox[\"g\", \"TI\"], \"]\"}]\) gives the list of edges associated with a maximal matching of graph g."
Combinatorica`MaximumAntichain::usage = "\!\(\*RowBox[{\"MaximumAntichain\", \"[\", StyleBox[\"g\", \"TI\"], \"]\"}]\) gives a largest set of unrelated vertices in partial order g."
Combinatorica`MaximumClique::usage = "\!\(\*RowBox[{\"MaximumClique\", \"[\", StyleBox[\"g\", \"TI\"], \"]\"}]\) finds a largest clique in graph g. \n\!\(\*RowBox[{\"MaximumClique\", \"[\", RowBox[{StyleBox[\"g\", \"TI\"], \",\", StyleBox[\"k\", \"TI\"]}], \"]\"}]\) returns a k-clique, if such a thing exists in g; otherwise it returns \!\(\*RowBox[{\"{\", \"}\"}]\)."
Combinatorica`MaximumIndependentSet::usage = "\!\(\*RowBox[{\"MaximumIndependentSet\", \"[\", StyleBox[\"g\", \"TI\"], \"]\"}]\) finds a largest independent set of graph g."
Combinatorica`MaximumSpanningTree::usage = "\!\(\*RowBox[{\"MaximumSpanningTree\", \"[\", StyleBox[\"g\", \"TI\"], \"]\"}]\) uses Kruskal's algorithm to find a maximum spanning tree of graph g."
Combinatorica`McGeeGraph::usage = "McGeeGraph returns the unique \!\(\*RowBox[{\"(\", RowBox[{\"7\", \",\", \"3\"}], \")\"}]\)-cage, a 3-regular graph with girth 7."
Combinatorica`MeredithGraph::usage = "MeredithGraph returns a 4-regular, 4-connected graph that is not Hamiltonian, providing a counterexample to a conjecture by C. St. J. A. Nash\[Dash]Williams."
Combinatorica`MinimumChainPartition::usage = "\!\(\*RowBox[{\"MinimumChainPartition\", \"[\", StyleBox[\"g\", \"TI\"], \"]\"}]\) partitions partial-order g into a minimum number of chains."
Combinatorica`MinimumChangePermutations::usage = "\!\(\*RowBox[{\"MinimumChangePermutations\", \"[\", StyleBox[\"l\", \"TI\"], \"]\"}]\) constructs all permutations of list l such that adjacent permutations differ by only one transposition."
Combinatorica`MinimumSpanningTree::usage = "\!\(\*RowBox[{\"MinimumSpanningTree\", \"[\", StyleBox[\"g\", \"TI\"], \"]\"}]\) uses Kruskal's algorithm to find a minimum spanning tree of graph g."
Combinatorica`MinimumVertexColoring::usage = "\!\(\*RowBox[{\"MinimumVertexColoring\", \"[\", StyleBox[\"g\", \"TI\"], \"]\"}]\) returns a minimum vertex coloring of g. \n\!\(\*RowBox[{\"MinimumVertexColoring\", \"[\", RowBox[{StyleBox[\"g\", \"TI\"], \",\", StyleBox[\"k\", \"TI\"]}], \"]\"}]\) returns a k-coloring of g, if one exists."
Combinatorica`MinimumVertexCover::usage = "\!\(\*RowBox[{\"MinimumVertexCover\", \"[\", StyleBox[\"g\", \"TI\"], \"]\"}]\) finds a minimum vertex cover of graph g. "
Combinatorica`M::usage = "\!\(\*RowBox[{\"M\", \"[\", StyleBox[\"g\", \"TI\"], \"]\"}]\) gives the number of edges in the graph g. \n\!\(\*RowBox[{\"M\", \"[\", RowBox[{StyleBox[\"g\", \"TI\"], \",\", \"Directed\"}], \"]\"}]\) is obsolete because \!\(\*RowBox[{\"M\", \"[\", StyleBox[\"g\", \"TI\"], \"]\"}]\) works for directed as well as undirected graphs."
Combinatorica`MultipleEdgesQ::usage = "\!\(\*RowBox[{\"MultipleEdgesQ\", \"[\", StyleBox[\"g\", \"TI\"], \"]\"}]\) yields True if g has multiple edges between pairs of vertices. It yields False otherwise."
Combinatorica`MultiplicationTable::usage = "\!\(\*RowBox[{\"MultiplicationTable\", \"[\", RowBox[{StyleBox[\"l\", \"TI\"], \",\", StyleBox[\"f\", \"TI\"]}], \"]\"}]\) constructs the complete transition table defined by the binary relation function f on the elements of list l."
Combinatorica`MycielskiGraph::usage = "\!\(\*RowBox[{\"MycielskiGraph\", \"[\", StyleBox[\"k\", \"TI\"], \"]\"}]\) returns a triangle-free graph with chromatic number k, for any positive integer k."
Combinatorica`NecklacePolynomial::usage = "\!\(\*RowBox[{\"NecklacePolynomial\", \"[\", RowBox[{StyleBox[\"n\", \"TI\"], \",\", StyleBox[\"c\", \"TI\"], \",\", \"Cyclic\"}], \"]\"}]\) returns a polynomial in the colors in c whose coefficients represent numbers of ways of coloring an n-bead necklace with colors chosen from c, assuming that two colorings are equivalent if one can be obtained from the other by a rotation. \n\!\(\*RowBox[{\"NecklacePolynomial\", \"[\", RowBox[{StyleBox[\"n\", \"TI\"], \",\", StyleBox[\"c\", \"TI\"], \",\", \"Dihedral\"}], \"]\"}]\) is different in that it considers two colorings equivalent if one can be obtained from the other by a rotation or a flip or both."
Combinatorica`Neighborhood::usage = "\!\(\*RowBox[{\"Neighborhood\", \"[\", RowBox[{StyleBox[\"g\", \"TI\"], \",\", StyleBox[\"v\", \"TI\"], \",\", StyleBox[\"k\", \"TI\"]}], \"]\"}]\) returns the subset of vertices in g that are at a distance of k or less from vertex v. \n\!\(\*RowBox[{\"Neighborhood\", \"[\", RowBox[{StyleBox[\"al\", \"TI\"], \",\", StyleBox[\"v\", \"TI\"], \",\", StyleBox[\"k\", \"TI\"]}], \"]\"}]\) behaves identically, except that it takes as input an adjacency list \!\(\*StyleBox[\"al\", \"TI\"]\)."
Combinatorica`NetworkFlowEdges::usage = "\!\(\*RowBox[{\"NetworkFlowEdges\", \"[\", RowBox[{StyleBox[\"g\", \"TI\"], \",\", StyleBox[\"source\", \"TI\"], \",\", StyleBox[\"sink\", \"TI\"]}], \"]\"}]\) returns the edges of the graph with positive flow, showing the distribution of a maximum flow from \!\(\*StyleBox[\"source\", \"TI\"]\) to \!\(\*StyleBox[\"sink\", \"TI\"]\) in graph \!\(\*StyleBox[\"g\", \"TI\"]\)."
Combinatorica`NetworkFlow::usage = "\!\(\*RowBox[{\"NetworkFlow\", \"[\", RowBox[{StyleBox[\"g\", \"TI\"], \",\", StyleBox[\"source\", \"TI\"], \",\", StyleBox[\"sink\", \"TI\"]}], \"]\"}]\) returns the value of a maximum flow through graph g from \!\(\*StyleBox[\"source\", \"TI\"]\) to \!\(\*StyleBox[\"sink\", \"TI\"]\). \n\!\(\*RowBox[{\"NetworkFlow\", \"[\", RowBox[{StyleBox[\"g\", \"TI\"], \",\", StyleBox[\"source\", \"TI\"], \",\", StyleBox[\"sink\", \"TI\"], \",\", \"Edge\"}], \"]\"}]\) returns the edges in g that have positive flow along with their flows in a maximum flow from \!\(\*StyleBox[\"source\", \"TI\"]\) to \!\(\*StyleBox[\"sink\", \"TI\"]\). \n\!\(\*RowBox[{\"NetworkFlow\", \"[\", RowBox[{StyleBox[\"g\", \"TI\"], \",\", StyleBox[\"source\", \"TI\"], \",\", StyleBox[\"sink\", \"TI\"], \",\", \"Cut\"}], \"]\"}]\) returns a minimum cut between \!\(\*StyleBox[\"source\", \"TI\"]\) and \!\(\*StyleBox[\"sink\", \"TI\"]\). \n\!\(\*RowBox[{\"NetworkFlow\", \"[\", RowBox[{StyleBox[\"g\", \"TI\"], \",\", StyleBox[\"source\", \"TI\"], \",\", StyleBox[\"sink\", \"TI\"], \",\", \"All\"}], \"]\"}]\) returns the adjacency list of g along with flows on each edge in a maximum flow from \!\(\*StyleBox[\"source\", \"TI\"]\) to \!\(\*StyleBox[\"sink\", \"TI\"]\)."
Combinatorica`NextBinarySubset::usage = "\!\(\*RowBox[{\"NextBinarySubset\", \"[\", RowBox[{StyleBox[\"l\", \"TI\"], \",\", StyleBox[\"s\", \"TI\"]}], \"]\"}]\) constructs the subset of l following subset s in the order obtained by interpreting subsets as binary string representations of integers."
Combinatorica`NextComposition::usage = "\!\(\*RowBox[{\"NextComposition\", \"[\", StyleBox[\"l\", \"TI\"], \"]\"}]\) constructs the integer composition that follows l in a canonical order."
Combinatorica`NextGrayCodeSubset::usage = "\!\(\*RowBox[{\"NextGrayCodeSubset\", \"[\", RowBox[{StyleBox[\"l\", \"TI\"], \",\", StyleBox[\"s\", \"TI\"]}], \"]\"}]\) constructs the successor of s in the Gray code of set l."
Combinatorica`NextKSubset::usage = "\!\(\*RowBox[{\"NextKSubset\", \"[\", RowBox[{StyleBox[\"l\", \"TI\"], \",\", StyleBox[\"s\", \"TI\"]}], \"]\"}]\) gives the k-subset of list l, following the k-subset s in lexicographic order."
Combinatorica`NextLexicographicSubset::usage = "\!\(\*RowBox[{\"NextLexicographicSubset\", \"[\", RowBox[{StyleBox[\"l\", \"TI\"], \",\", StyleBox[\"s\", \"TI\"]}], \"]\"}]\) gives the lexicographic successor of subset s of set l."
Combinatorica`NextPartition::usage = "\!\(\*RowBox[{\"NextPartition\", \"[\", StyleBox[\"p\", \"TI\"], \"]\"}]\) gives the integer partition following p in reverse lexicographic order."
Combinatorica`NextPermutation::usage = "\!\(\*RowBox[{\"NextPermutation\", \"[\", StyleBox[\"p\", \"TI\"], \"]\"}]\) gives the permutation following p in lexicographic order."
Combinatorica`NextSubset::usage = "\!\(\*RowBox[{\"NextSubset\", \"[\", RowBox[{StyleBox[\"l\", \"TI\"], \",\", StyleBox[\"s\", \"TI\"]}], \"]\"}]\) constructs the subset of l following subset \!\(\*StyleBox[\"s\", \"TI\"]\) in canonical order."
Combinatorica`NextTableau::usage = "\!\(\*RowBox[{\"NextTableau\", \"[\", StyleBox[\"t\", \"TI\"], \"]\"}]\) gives the tableau of shape t, following t in lexicographic order."
Combinatorica`NoMultipleEdges::usage = "NoMultipleEdges is an option value for Type."
Combinatorica`NonLineGraphs::usage = "NonLineGraphs returns a graph whose connected components are the 9 graphs whose presence as a vertex-induced subgraph in a graph g makes g a nonline graph."
Combinatorica`NoPerfectMatchingGraph::usage = "NoPerfectMatchingGraph returns a connected graph with 16 vertices that contains no perfect matching."
Combinatorica`NormalDashed::usage = "NormalDashed is a value that the option EdgeStyle can take on in the graph data structure or in ShowGraph."
Combinatorica`NormalizeVertices::usage = "\!\(\*RowBox[{\"NormalizeVertices\", \"[\", StyleBox[\"v\", \"TI\"], \"]\"}]\) gives a list of vertices with a similar embedding as v but with the coordinates of all points scaled to be between 0 and 1."
Combinatorica`NoSelfLoops::usage = "NoSelfLoops is an option value for Type."
Combinatorica`NthPair::usage = "\!\(\*RowBox[{\"NthPair\", \"[\", StyleBox[\"n\", \"TI\"], \"]\"}]\) returns the n\!\(\*SuperscriptBox[\"\[Null]\", \"th\"]\) unordered pair of distinct positive integers, when sequenced to minimize the size of the larger integer. Pairs that have the same larger integer are sequenced in increasing order of their smaller integer."
Combinatorica`NthPermutation::usage = "\!\(\*RowBox[{\"NthPermutation\", \"[\", RowBox[{StyleBox[\"n\", \"TI\"], \",\", StyleBox[\"l\", \"TI\"]}], \"]\"}]\) gives the n\!\(\*SuperscriptBox[\"\[Null]\", \"th\"]\) lexicographic permutation of list l."
Combinatorica`NthSubset::usage = "\!\(\*RowBox[{\"NthSubset\", \"[\", RowBox[{StyleBox[\"n\", \"TI\"], \",\", StyleBox[\"l\", \"TI\"]}], \"]\"}]\) gives the n\!\(\*SuperscriptBox[\"\[Null]\", \"th\"]\) subset of list l in canonical order."
Combinatorica`NumberOf2Paths::usage = "\!\(\*RowBox[{\"NumberOf2Paths\", \"[\", RowBox[{StyleBox[\"g\", \"TI\"], \",\", StyleBox[\"v\", \"TI\"]}], \"]\"}]\) returns a sorted list that contains the number of paths of length 2 to different vertices of g from v."
Combinatorica`NumberOfCompositions::usage = "\!\(\*RowBox[{\"NumberOfCompositions\", \"[\", RowBox[{StyleBox[\"n\", \"TI\"], \",\", StyleBox[\"k\", \"TI\"]}], \"]\"}]\) counts the number of distinct compositions of integer n into k parts."
Combinatorica`NumberOfDerangements::usage = "\!\(\*RowBox[{\"NumberOfDerangements\", \"[\", StyleBox[\"n\", \"TI\"], \"]\"}]\) counts the derangements on n elements, that is, the permutations without any fixed points."
Combinatorica`NumberOfDirectedGraphs::usage = "\!\(\*RowBox[{\"NumberOfDirectedGraphs\", \"[\", StyleBox[\"n\", \"TI\"], \"]\"}]\) returns the number of nonisomorphic directed graphs with n vertices. \n\!\(\*RowBox[{\"NumberOfDirectedGraphs\", \"[\", RowBox[{StyleBox[\"n\", \"TI\"], \",\", StyleBox[\"m\", \"TI\"]}], \"]\"}]\) returns the number of nonisomorphic directed graphs with n vertices and m edges."
Combinatorica`NumberOfGraphs::usage = "\!\(\*RowBox[{\"NumberOfGraphs\", \"[\", StyleBox[\"n\", \"TI\"], \"]\"}]\) returns the number of nonisomorphic undirected graphs with n vertices. \n\!\(\*RowBox[{\"NumberOfGraphs\", \"[\", RowBox[{StyleBox[\"n\", \"TI\"], \",\", StyleBox[\"m\", \"TI\"]}], \"]\"}]\) returns the number of nonisomorphic undirected graphs with n vertices and m edges."
Combinatorica`NumberOfInvolutions::usage = "\!\(\*RowBox[{\"NumberOfInvolutions\", \"[\", StyleBox[\"n\", \"TI\"], \"]\"}]\) counts the number of involutions on n elements."
Combinatorica`NumberOfKPaths::usage = "\!\(\*RowBox[{\"NumberOfKPaths\", \"[\", RowBox[{StyleBox[\"g\", \"TI\"], \",\", StyleBox[\"v\", \"TI\"], \",\", StyleBox[\"k\", \"TI\"]}], \"]\"}]\) returns a sorted list that contains the number of paths of length k to different vertices of g from v.\n\!\(\*RowBox[{\"NumberOfKPaths\", \"[\", RowBox[{StyleBox[\"al\", \"TI\"], \",\", StyleBox[\"v\", \"TI\"], \",\", StyleBox[\"k\", \"TI\"]}], \"]\"}]\) behaves identically, except that it takes an adjacency list \!\(\*StyleBox[\"al\", \"TI\"]\) as input."
Combinatorica`NumberOfNecklaces::usage = "\!\(\*RowBox[{\"NumberOfNecklaces\", \"[\", RowBox[{StyleBox[\"n\", \"TI\"], \",\", StyleBox[\"nc\", \"TI\"], \",\", \"Cyclic\"}], \"]\"}]\) returns the number of distinct ways in which an n-bead necklace can be colored with \!\(\*StyleBox[\"nc\", \"TI\"]\) colors, assuming that two colorings are equivalent if one can be obtained from the other by a rotation. \n\!\(\*RowBox[{\"NumberOfNecklaces\", \"[\", RowBox[{StyleBox[\"n\", \"TI\"], \",\", StyleBox[\"nc\", \"TI\"], \",\", \"Dihedral\"}], \"]\"}]\) returns the number of distinct ways in which an n-bead necklace can be colored with \!\(\*StyleBox[\"nc\", \"TI\"]\) colors, assuming that two colorings are equivalent if one can be obtained from the other by a rotation or a flip."
Combinatorica`NumberOfPartitions::usage = "\!\(\*RowBox[{\"NumberOfPartitions\", \"[\", StyleBox[\"n\", \"TI\"], \"]\"}]\) counts the number of integer partitions of n."
Combinatorica`NumberOfPermutationsByCycles::usage = "\!\(\*RowBox[{\"NumberOfPermutationsByCycles\", \"[\", RowBox[{StyleBox[\"n\", \"TI\"], \",\", StyleBox[\"m\", \"TI\"]}], \"]\"}]\) gives the number of permutations of length \!\(\*StyleBox[\"n\", \"TI\"]\) with exactly m cycles."
Combinatorica`NumberOfPermutationsByInversions::usage = "\!\(\*RowBox[{\"NumberOfPermutationsByInversions\", \"[\", RowBox[{StyleBox[\"n\", \"TI\"], \",\", StyleBox[\"k\", \"TI\"]}], \"]\"}]\) gives the number of permutations of length n with exactly k inversions. \n\!\(\*RowBox[{\"NumberOfPermutationsByInversions\", \"[\", StyleBox[\"n\", \"TI\"], \"]\"}]\) gives a table of the number of length-n permutations with k inversions, for all k."
Combinatorica`NumberOfPermutationsByType::usage = "\!\(\*RowBox[{\"NumberOfPermutationsByTypes\", \"[\", StyleBox[\"l\", \"TI\"], \"]\"}]\) gives the number of permutations of type l."
Combinatorica`NumberOfSpanningTrees::usage = "\!\(\*RowBox[{\"NumberOfSpanningTrees\", \"[\", StyleBox[\"g\", \"TI\"], \"]\"}]\) gives the number of labeled spanning trees of graph g."
Combinatorica`NumberOfTableaux::usage = "\!\(\*RowBox[{\"NumberOfTableaux\", \"[\", StyleBox[\"p\", \"TI\"], \"]\"}]\) uses the hook length formula to count the number of Young tableaux with shape defined by partition p."
Combinatorica`OctahedralGraph::usage = "OctahedralGraph returns the graph corresponding to the octahedron, a Platonic solid."
Combinatorica`OddGraph::usage = "\!\(\*RowBox[{\"OddGraph\", \"[\", StyleBox[\"n\", \"TI\"], \"]\"}]\) returns the graph whose vertices are the size-\!\(\*RowBox[{\"(\", RowBox[{\"n\", \"-\", \"1\"}], \")\"}]\) subsets of a size-\!\(\*RowBox[{\"(\", RowBox[{\"2\", \"n\", FormBox[\"\[Dash]\", TraditionalForm], \"1\"}], \")\"}]\) set and whose edges connect pairs of vertices that correspond to disjoint subsets. "
Combinatorica`One::usage = "One is a tag used in several functions to inform the functions that only one object need be considered or only one solution be produced, as opposed to all objects or all solutions."
Combinatorica`Optimum::usage = "Optimum is a value that the option Algorithm can take on when used in functions VertexColoring and VertexCover."
Combinatorica`OrbitInventory::usage = "\!\(\*RowBox[{\"OrbitInventory\", \"[\", RowBox[{StyleBox[\"ci\", \"TI\"], \",\", StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"w\", \"TI\"]}], \"]\"}]\) returns the value of the cycle index \!\(\*StyleBox[\"ci\", \"TI\"]\) when each formal variable \!\(\*RowBox[{\"x\", \"[\", \"i\", \"]\"}]\) is replaced by w. \n\!\(\*RowBox[{\"OrbitInventory\", \"[\", RowBox[{StyleBox[\"ci\", \"TI\"], \",\", StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"weights\", \"TI\"]}], \"]\"}]\) returns the inventory of orbits induced on a set of functions by the action of a group with cycle index \!\(\*StyleBox[\"ci\", \"TI\"]\). It is assumed that each element in the range of the functions is assigned a weight in list \!\(\*StyleBox[\"weights\", \"TI\"]\)."
Combinatorica`OrbitRepresentatives::usage = "\!\(\*RowBox[{\"OrbitRepresentatives\", \"[\", RowBox[{StyleBox[\"pg\", \"TI\"], \",\", StyleBox[\"x\", \"TI\"]}], \"]\"}]\) returns a representative of each orbit of x induced by the action of the group \!\(\*StyleBox[\"pg\", \"TI\"]\) on x."
Combinatorica`Orbits::usage = "\!\(\*RowBox[{\"Orbits\", \"[\", RowBox[{StyleBox[\"pg\", \"TI\"], \",\", StyleBox[\"x\", \"TI\"]}], \"]\"}]\) returns the orbits of x induced by the action of the group \!\(\*StyleBox[\"pg\", \"TI\"]\) on x."
Combinatorica`Ordered::usage = "Ordered is an option to the functions KSubsetGroup and KSubsetGroupIndex that tells the functions whether they should treat the input as sets or tuples."
Combinatorica`OrientGraph::usage = "\!\(\*RowBox[{\"OrientGraph\", \"[\", StyleBox[\"g\", \"TI\"], \"]\"}]\) assigns a direction to each edge of a bridgeless, undirected graph \!\(\*StyleBox[\"g\", \"TI\"]\), so that the graph is strongly connected."
Combinatorica`OutDegree::usage = "\!\(\*RowBox[{\"OutDegree\", \"[\", RowBox[{StyleBox[\"g\", \"TI\"], \",\", StyleBox[\"n\", \"TI\"]}], \"]\"}]\) returns the out-degree of vertex n in directed graph g. \n\!\(\*RowBox[{\"OutDegree\", \"[\", StyleBox[\"g\", \"TI\"], \"]\"}]\) returns the sequence of out-degrees of the vertices in directed graph g."
Combinatorica`PairGroupIndex::usage = "\!\(\*RowBox[{\"PairGroupIndex\", \"[\", RowBox[{StyleBox[\"g\", \"TI\"], \",\", StyleBox[\"x\", \"TI\"]}], \"]\"}]\) returns the cycle index of the pair group induced by g as a polynomial in \!\(\*RowBox[{RowBox[{\"x\", \"[\", \"1\", \"]\"}], \",\", RowBox[{\"x\", \"[\", \"2\", \"]\"}], \",\", \"\[Ellipsis]\"}]\).\n\!\(\*RowBox[{\"PairGroupIndex\", \"[\", RowBox[{StyleBox[\"ci\", \"TI\"], \",\", StyleBox[\"x\", \"TI\"]}], \"]\"}]\) takes the cycle index \!\(\*StyleBox[\"ci\", \"TI\"]\) of a group g with formal variables \!\(\*RowBox[{RowBox[{\"x\", \"[\", \"1\", \"]\"}], \",\", RowBox[{\"x\", \"[\", \"2\", \"]\"}], \",\", \"\[Ellipsis]\"}]\), and returns the cycle index of the pair group induced by g. \n\!\(\*RowBox[{\"PairGroupIndex\", \"[\", RowBox[{StyleBox[\"g\", \"TI\"], \",\", StyleBox[\"x\", \"TI\"], \",\", \"Ordered\"}], \"]\"}]\) returns the cycle index of the ordered pair group induced by g as a polynomial in \!\(\*RowBox[{RowBox[{\"x\", \"[\", \"1\", \"]\"}], \",\", RowBox[{\"x\", \"[\", \"2\", \"]\"}], \",\", \"\[Ellipsis]\"}]\).\n\!\(\*RowBox[{\"PairGroupIndex\", \"[\", RowBox[{StyleBox[\"ci\", \"TI\"], \",\", StyleBox[\"x\", \"TI\"], \",\", \"Ordered\"}], \"]\"}]\) takes the cycle index \!\(\*StyleBox[\"ci\", \"TI\"]\) of a group g with formal variables \!\(\*RowBox[{RowBox[{\"x\", \"[\", \"1\", \"]\"}], \",\", RowBox[{\"x\", \"[\", \"2\", \"]\"}], \",\", \"\[Ellipsis]\"}]\), and returns the cycle index of the ordered pair group induced by g."
Combinatorica`PairGroup::usage = "\!\(\*RowBox[{\"PairGroup\", \"[\", StyleBox[\"g\", \"TI\"], \"]\"}]\) returns the group induced on 2-sets by the permutation group g. \n\!\(\*RowBox[{\"PairGroup\", \"[\", RowBox[{StyleBox[\"g\", \"TI\"], \",\", \"Ordered\"}], \"]\"}]\) returns the group induced on ordered pairs with distinct elements by the permutation group g."
Combinatorica`Parent::usage = "Parent is a tag used as an argument to the function AllPairsShortestPath in order to inform this function that information about parents in the shortest paths is also wanted."
Combinatorica`ParentsToPaths::usage = "\!\(\*RowBox[{\"ParentsToPaths\", \"[\", RowBox[{StyleBox[\"l\", \"TI\"], \",\", StyleBox[\"i\", \"TI\"], \",\", StyleBox[\"j\", \"TI\"]}], \"]\"}]\) takes a list of parents l and returns the path from i to j encoded in the parent list. \n\!\(\*RowBox[{\"ParentsToPaths\", \"[\", RowBox[{StyleBox[\"l\", \"TI\"], \",\", StyleBox[\"i\", \"TI\"]}], \"]\"}]\) returns the paths from i to all vertices."
Combinatorica`PartialOrderQ::usage = "\!\(\*RowBox[{\"PartialOrderQ\", \"[\", StyleBox[\"g\", \"TI\"], \"]\"}]\) yields True if the binary relation defined by edges of the graph g is a partial order, meaning it is transitive, reflexive, and antisymmetric. \n\!\(\*RowBox[{\"PartialOrderQ\", \"[\", StyleBox[\"r\", \"TI\"], \"]\"}]\) yields True if the binary relation defined by the square matrix r is a partial order."
Combinatorica`PartitionLattice::usage = "\!\(\*RowBox[{\"PartitionLattice\", \"[\", StyleBox[\"n\", \"TI\"], \"]\"}]\) returns a Hasse diagram of the partially ordered set on set partitions of 1 through n in which \!\(\*RowBox[{\"p\", \"<\", \"q\"}]\) if q is finer than p, that is, each block in q is contained in some block in p. "
Combinatorica`PartitionQ::usage = "\!\(\*RowBox[{\"PartitionQ\", \"[\", StyleBox[\"p\", \"TI\"], \"]\"}]\) yields True if p is an integer partition. \n\!\(\*RowBox[{\"PartitionQ\", \"[\", RowBox[{StyleBox[\"n\", \"TI\"], \",\", StyleBox[\"p\", \"TI\"]}], \"]\"}]\) yields True if p is a partition of n."
Combinatorica`Partitions::usage = "\!\(\*RowBox[{\"Partitions\", \"[\", StyleBox[\"n\", \"TI\"], \"]\"}]\) constructs all partitions of integer n in reverse lexicographic order. \n\!\(\*RowBox[{\"Partitions\", \"[\", RowBox[{StyleBox[\"n\", \"TI\"], \",\", StyleBox[\"k\", \"TI\"]}], \"]\"}]\) constructs all partitions of the integer n with maximum part at most k, in reverse lexicographic order."
Combinatorica`PathConditionGraph::usage = "PathConditionGraph is obsolete. This functionality is no longer supported in \!\(\*StyleBox[\"Combinatorica\", FontSlant -> \"Italic\"]\)."
Combinatorica`Path::usage = "\!\(\*RowBox[{\"Path\", \"[\", StyleBox[\"n\", \"TI\"], \"]\"}]\) constructs a tree consisting only of a path on n vertices"
Combinatorica`PerfectQ::usage = "\!\(\*RowBox[{\"PerfectQ\", \"[\", StyleBox[\"g\", \"TI\"], \"]\"}]\) yields True if g is a perfect graph, meaning that for every induced subgraph of g the size of a largest clique equals the chromatic number."
Combinatorica`PermutationGraph::usage = "\!\(\*RowBox[{\"PermutationGraph\", \"[\", StyleBox[\"p\", \"TI\"], \"]\"}]\) gives the permutation graph for the permutation p."
Combinatorica`PermutationGroupQ::usage = "\!\(\*RowBox[{\"PermutationGroupQ\", \"[\", StyleBox[\"l\", \"TI\"], \"]\"}]\) yields True if the list of permutations l forms a permutation group."
Combinatorica`PermutationQ::usage = "\!\(\*RowBox[{\"PermutationQ\", \"[\", StyleBox[\"p\", \"TI\"], \"]\"}]\) yields True if \!\(\*StyleBox[\"p\", \"TI\"]\) is a list representing a permutation and False otherwise."
Combinatorica`PermutationToTableaux::usage = "\!\(\*RowBox[{\"PermutationToTableaux\", \"[\", StyleBox[\"p\", \"TI\"], \"]\"}]\) returns the tableaux pair that can be constructed from p using the Robinson\[Dash]Schensted\[Dash]Knuth correspondence."
Combinatorica`PermutationType::usage = "\!\(\*RowBox[{\"PermutationType\", \"[\", StyleBox[\"p\", \"TI\"], \"]\"}]\) returns the type of permutation p."
Combinatorica`PermutationWithCycle::usage = "\!\(\*RowBox[{\"PermutationWithCycle\", \"[\", RowBox[{StyleBox[\"n\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{StyleBox[\"i\", \"TI\"], \",\", StyleBox[\"j\", \"TI\"], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}]}], \"]\"}]\) gives a size-n permutation in which \!\(\*RowBox[{\"{\", RowBox[{\"i\", \",\", \"j\", \",\", \"\[Ellipsis]\"}], \"}\"}]\) is a cycle and all other elements are fixed points."
Combinatorica`Permute::usage = "\!\(\*RowBox[{\"Permute\", \"[\", RowBox[{StyleBox[\"l\", \"TI\"], \",\", StyleBox[\"p\", \"TI\"]}], \"]\"}]\) permutes list l according to permutation p."
Combinatorica`PermuteSubgraph::usage = "\!\(\*RowBox[{\"PermuteSubgraph\", \"[\", RowBox[{StyleBox[\"g\", \"TI\"], \",\", StyleBox[\"p\", \"TI\"]}], \"]\"}]\) permutes the vertices of a subgraph of g induced by p according to p."
Combinatorica`PetersenGraph::usage = "PetersenGraph returns the Petersen graph, a graph whose vertices can be viewed as the size-2 subsets of a size-5 set with edges connecting disjoint subsets."
Combinatorica`PlanarQ::usage = "\!\(\*RowBox[{\"PlanarQ\", \"[\", StyleBox[\"g\", \"TI\"], \"]\"}]\) yields True if graph g is planar, meaning it can be drawn in the plane so no two edges cross."
Combinatorica`PointsAndLines::usage = "PointsAndLines is now obsolete."
Combinatorica`Polya::usage = "\!\(\*RowBox[{\"Polya\", \"[\", RowBox[{StyleBox[\"g\", \"TI\"], \",\", StyleBox[\"m\", \"TI\"]}], \"]\"}]\) returns the polynomial giving the number of colorings, with m colors, of a structure defined by the permutation group g."
Combinatorica`PseudographQ::usage = "\!\(\*RowBox[{\"PseudographQ\", \"[\", StyleBox[\"g\", \"TI\"], \"]\"}]\) yields True if graph g is a pseudograph, meaning it contains self-loops."
Combinatorica`RadialEmbedding::usage = "\!\(\*RowBox[{\"RadialEmbedding\", \"[\", RowBox[{StyleBox[\"g\", \"TI\"], \",\", StyleBox[\"v\", \"TI\"]}], \"]\"}]\) constructs a radial embedding of the graph g in which vertices are placed on concentric circles around v depending on their distance from v. \n\!\(\*RowBox[{\"RadialEmbedding\", \"[\", StyleBox[\"g\", \"TI\"], \"]\"}]\) constructs a radial embedding of graph g, radiating from the center of the graph."
Combinatorica`Radius::usage = "\!\(\*RowBox[{\"Radius\", \"[\", StyleBox[\"g\", \"TI\"], \"]\"}]\) gives the radius of graph g, the minimum eccentricity of any vertex of g."
Combinatorica`RandomComposition::usage = "\!\(\*RowBox[{\"RandomComposition\", \"[\", RowBox[{StyleBox[\"n\", \"TI\"], \",\", StyleBox[\"k\", \"TI\"]}], \"]\"}]\) constructs a random composition of integer n into k parts."
Combinatorica`RandomGraph::usage = "\!\(\*RowBox[{\"RandomGraph\", \"[\", RowBox[{StyleBox[\"n\", \"TI\"], \",\", StyleBox[\"p\", \"TI\"]}], \"]\"}]\) constructs a random labeled graph on n vertices with an edge probability of p. "
Combinatorica`RandomHeap::usage = "\!\(\*RowBox[{\"RandomHeap\", \"[\", StyleBox[\"n\", \"TI\"], \"]\"}]\) constructs a random heap on n elements."
Combinatorica`RandomInteger::usage = "RandomInteger is a value that the WeightingFunction option of the function SetEdgeWeights can take."
Combinatorica`RandomKSetPartition::usage = "\!\(\*RowBox[{\"RandomKSetPartition\", \"[\", RowBox[{StyleBox[\"set\", \"TI\"], \",\", StyleBox[\"k\", \"TI\"]}], \"]\"}]\) returns a random set partition of \!\(\*StyleBox[\"set\", \"TI\"]\) with k blocks. \n\!\(\*RowBox[{\"RandomKSetPartition\", \"[\", RowBox[{StyleBox[\"n\", \"TI\"], \",\", StyleBox[\"k\", \"TI\"]}], \"]\"}]\) returns a random set partition of the first n natural numbers into k blocks."
Combinatorica`RandomKSubset::usage = "\!\(\*RowBox[{\"RandomKSubset\", \"[\", RowBox[{StyleBox[\"l\", \"TI\"], \",\", StyleBox[\"k\", \"TI\"]}], \"]\"}]\) gives a random subset of set l with exactly k elements."
Combinatorica`RandomPartition::usage = "\!\(\*RowBox[{\"RandomPartition\", \"[\", StyleBox[\"n\", \"TI\"], \"]\"}]\) constructs a random partition of integer n."
Combinatorica`RandomPermutation1::usage = "RandomPermutation1 is now obsolete. Use RandomPermutation instead."
Combinatorica`RandomPermutation2::usage = "RandomPermutation2 is now obsolete. Use RandomPermutation instead."
Combinatorica`RandomPermutation::usage = "\!\(\*RowBox[{\"RandomPermutation\", \"[\", StyleBox[\"n\", \"TI\"], \"]\"}]\) generates a random permutation of the first n natural numbers."
Combinatorica`RandomRGF::usage = "\!\(\*RowBox[{\"RandomRGF\", \"[\", StyleBox[\"n\", \"TI\"], \"]\"}]\) returns a random restricted growth function (RGF) defined on the first n natural numbers. \n\!\(\*RowBox[{\"RandomRGF\", \"[\", RowBox[{StyleBox[\"n\", \"TI\"], \",\", StyleBox[\"k\", \"TI\"]}], \"]\"}]\) returns a random RGF defined on the first n natural numbers having maximum element equal to k."
Combinatorica`RandomSetPartition::usage = "\!\(\*RowBox[{\"RandomSetPartition\", \"[\", StyleBox[\"set\", \"TI\"], \"]\"}]\) returns a random set partition of \!\(\*StyleBox[\"set\", \"TI\"]\). \n\!\(\*RowBox[{\"RandomSetPartition\", \"[\", StyleBox[\"n\", \"TI\"], \"]\"}]\) returns a random set partition of the first n natural numbers."
Combinatorica`RandomSubset::usage = "\!\(\*RowBox[{\"RandomSubset\", \"[\", StyleBox[\"l\", \"TI\"], \"]\"}]\) creates a random subset of set l."
Combinatorica`RandomTableau::usage = "\!\(\*RowBox[{\"RandomTableau\", \"[\", StyleBox[\"p\", \"TI\"], \"]\"}]\) constructs a random Young tableau of shape p."
Combinatorica`RandomTree::usage = "\!\(\*RowBox[{\"RandomTree\", \"[\", StyleBox[\"n\", \"TI\"], \"]\"}]\) constructs a random labeled tree on n vertices."
Combinatorica`RandomVertices::usage = "\!\(\*RowBox[{\"RandomVertices\", \"[\", StyleBox[\"g\", \"TI\"], \"]\"}]\) assigns a random embedding to graph g."
Combinatorica`RankBinarySubset::usage = "\!\(\*RowBox[{\"RankBinarySubset\", \"[\", RowBox[{StyleBox[\"l\", \"TI\"], \",\", StyleBox[\"s\", \"TI\"]}], \"]\"}]\) gives the rank of subset s of set l in the ordering of subsets of l, obtained by interpreting these subsets as binary string representations of integers."
Combinatorica`RankedEmbedding::usage = "\!\(\*RowBox[{\"RankedEmbedding\", \"[\", StyleBox[\"l\", \"TI\"], \"]\"}]\) takes a set partition l of vertices \!\(\*RowBox[{\"{\", RowBox[{\"1\", \",\", \"2\", \",\", \"\[Ellipsis]\", \",\", \"n\"}], \"}\"}]\) and returns an embedding of the vertices in the plane such that the vertices in each block occur on a vertical line with block 1 vertices on the leftmost line, block 2 vertices in the next line, and so on. \n\!\(\*RowBox[{\"RankedEmbedding\", \"[\", RowBox[{StyleBox[\"g\", \"TI\"], \",\", StyleBox[\"l\", \"TI\"]}], \"]\"}]\) takes a graph g and a set partition l of the vertices of g and returns the graph g with vertices embedded according to \!\(\*RowBox[{RowBox[{\"RankedEmbedding\", \"[\"}], StyleBox[\"l\", \"TI\"], \"]\"}]\). \n\!\(\*RowBox[{\"RankedEmbedding\", \"[\", RowBox[{StyleBox[\"g\", \"TI\"], \",\", StyleBox[\"s\", \"TI\"]}], \"]\"}]\) takes a graph g and a set s of vertices of g and returns a ranked embedding of \!\(\*StyleBox[\"g\", \"TI\"]\) in which vertices in s are in block 1, vertices at distance 1 from any vertex in block 1 are in block 2, and so on."
Combinatorica`RankGraph::usage = "\!\(\*RowBox[{\"RankGraph\", \"[\", RowBox[{StyleBox[\"g\", \"TI\"], \",\", StyleBox[\"l\", \"TI\"]}], \"]\"}]\) partitions the vertices into classes based on the shortest geodesic distance to a member of list l."
Combinatorica`RankGrayCodeSubset::usage = "\!\(\*RowBox[{\"RankGrayCodeSubset\", \"[\", RowBox[{StyleBox[\"l\", \"TI\"], \",\", StyleBox[\"s\", \"TI\"]}], \"]\"}]\) gives the rank of subset s of set l in the Gray code ordering of the subsets of l."
Combinatorica`RankKSetPartition::usage = "\!\(\*RowBox[{\"RankKSetPartition\", \"[\", RowBox[{StyleBox[\"sp\", \"TI\"], \",\", StyleBox[\"s\", \"TI\"]}], \"]\"}]\) ranks \!\(\*StyleBox[\"sp\", \"TI\"]\) in the list of all k-block set partitions of s. \n\!\(\*RowBox[{RowBox[{\"RankSetPartition\", \"[\"}], StyleBox[\"sp\", \"TI\"], \"]\"}]\) ranks \!\(\*StyleBox[\"sp\", \"TI\"]\) in the list of all k-block set partitions of the set of elements that appear in any subset in \!\(\*StyleBox[\"sp\", \"TI\"]\)."
Combinatorica`RankKSubset::usage = "\!\(\*RowBox[{\"RankKSubset\", \"[\", RowBox[{StyleBox[\"s\", \"TI\"], \",\", StyleBox[\"l\", \"TI\"]}], \"]\"}]\) gives the rank of k-subset s of set l in the lexicographic ordering of the k-subsets of l."
Combinatorica`RankPermutation::usage = "\!\(\*RowBox[{\"RankPermutation\", \"[\", StyleBox[\"p\", \"TI\"], \"]\"}]\) gives the rank of permutation p in lexicographic order."
Combinatorica`RankRGF::usage = "\!\(\*RowBox[{\"RankRGF\", \"[\", StyleBox[\"f\", \"TI\"], \"]\"}]\) returns the rank of a restricted growth function (RGF) f in the lexicographic order of all RGFs."
Combinatorica`RankSetPartition::usage = "\!\(\*RowBox[{\"RankSetPartition\", \"[\", RowBox[{StyleBox[\"sp\", \"TI\"], \",\", StyleBox[\"s\", \"TI\"]}], \"]\"}]\) ranks \!\(\*StyleBox[\"sp\", \"TI\"]\) in the list of all set partitions of set s. \n\!\(\*RowBox[{\"RankSetPartition\", \"[\", StyleBox[\"sp\", \"TI\"], \"]\"}]\) ranks \!\(\*StyleBox[\"sp\", \"TI\"]\) in the list of all set partitions of the set of elements that appear in any subset in \!\(\*StyleBox[\"sp\", \"TI\"]\)."
Combinatorica`RankSubset::usage = "\!\(\*RowBox[{\"RankSubset\", \"[\", RowBox[{StyleBox[\"l\", \"TI\"], \",\", StyleBox[\"s\", \"TI\"]}], \"]\"}]\) gives the rank, in canonical order, of subset s of set l."
Combinatorica`ReadGraph::usage = "\!\(\*RowBox[{\"ReadGraph\", \"[\", StyleBox[\"f\", \"TI\"], \"]\"}]\) reads a graph represented as edge lists from file f and returns a graph object."
Combinatorica`RealizeDegreeSequence::usage = "\!\(\*RowBox[{\"RealizeDegreeSequence\", \"[\", StyleBox[\"s\", \"TI\"], \"]\"}]\) constructs a semirandom graph with degree sequence s."
Combinatorica`ReflexiveQ::usage = "\!\(\*RowBox[{\"ReflexiveQ\", \"[\", StyleBox[\"g\", \"TI\"], \"]\"}]\) yields True if the adjacency matrix of g represents a reflexive binary relation."
Combinatorica`RegularGraph::usage = "\!\(\*RowBox[{\"RegularGraph\", \"[\", RowBox[{StyleBox[\"k\", \"TI\"], \",\", StyleBox[\"n\", \"TI\"]}], \"]\"}]\) constructs a semirandom k-regular graph on n vertices, if such a graph exists."
Combinatorica`RegularQ::usage = "\!\(\*RowBox[{\"RegularQ\", \"[\", StyleBox[\"g\", \"TI\"], \"]\"}]\) yields True if g is a regular graph."
Combinatorica`RemoveMultipleEdges::usage = "\!\(\*RowBox[{\"RemoveMultipleEdges\", \"[\", StyleBox[\"g\", \"TI\"], \"]\"}]\) returns the graph obtained by deleting multiple edges from g."
Combinatorica`RemoveSelfLoops::usage = "\!\(\*RowBox[{\"RemoveSelfLoops\", \"[\", StyleBox[\"g\", \"TI\"], \"]\"}]\) returns the graph obtained by deleting self-loops in g."
Combinatorica`ResidualFlowGraph::usage = "\!\(\*RowBox[{\"ResidualFlowGraph\", \"[\", RowBox[{StyleBox[\"g\", \"TI\"], \",\", StyleBox[\"flow\", \"TI\"]}], \"]\"}]\) returns the directed residual flow graph for graph g with respect to \!\(\*StyleBox[\"flow\", \"TI\"]\)."
Combinatorica`RevealCycles::usage = "\!\(\*RowBox[{\"RevealCycles\", \"[\", StyleBox[\"p\", \"TI\"], \"]\"}]\) unveils the canonical hidden cycle structure of permutation p."
Combinatorica`ReverseEdges::usage = "\!\(\*RowBox[{\"ReverseEdges\", \"[\", StyleBox[\"g\", \"TI\"], \"]\"}]\) flips the directions of all edges in a directed graph."
Combinatorica`RGFQ::usage = "\!\(\*RowBox[{\"RGFQ\", \"[\", StyleBox[\"l\", \"TI\"], \"]\"}]\) yields True if l is a restricted growth function. It yields False otherwise."
Combinatorica`RGFs::usage = "\!\(\*RowBox[{\"RGFs\", \"[\", StyleBox[\"n\", \"TI\"], \"]\"}]\) lists all restricted growth functions on the first n natural numbers in lexicographic order."
Combinatorica`RGFToSetPartition::usage = "\!\(\*RowBox[{\"RGFToSetPartition\", \"[\", RowBox[{StyleBox[\"rgf\", \"TI\"], \",\", StyleBox[\"set\", \"TI\"]}], \"]\"}]\) converts the restricted growth function \!\(\*StyleBox[\"rgf\", \"TI\"]\) into the corresponding set partition of \!\(\*StyleBox[\"set\", \"TI\"]\). "
Combinatorica`RobertsonGraph::usage = "RobertsonGraph returns a 19-vertex graph that is the unique \!\(\*RowBox[{\"(\", RowBox[{\"4\", \",\", \"5\"}], \")\"}]\)-cage graph."
Combinatorica`RootedEmbedding::usage = "\!\(\*RowBox[{\"RootedEmbedding\", \"[\", RowBox[{StyleBox[\"g\", \"TI\"], \",\", StyleBox[\"v\", \"TI\"]}], \"]\"}]\) constructs a rooted embedding of graph g with vertex v as the root. \n\!\(\*RowBox[{\"RootedEmbedding\", \"[\", StyleBox[\"g\", \"TI\"], \"]\"}]\) constructs a rooted embedding with a center of g as the root."
Combinatorica`RotateVertices::usage = "\!\(\*RowBox[{\"RotateVertices\", \"[\", RowBox[{StyleBox[\"v\", \"TI\"], \",\", StyleBox[\"\[Theta]\", \"TR\"]}], \"]\"}]\) rotates each vertex position in list v by \[Theta] radians about the origin \!\(\*RowBox[{\"(\", RowBox[{\"0\", \",\", \"0\"}], \")\"}]\). \n\!\(\*RowBox[{\"RotateVertices\", \"[\", RowBox[{StyleBox[\"g\", \"TI\"], \",\", StyleBox[\"\[Theta]\", \"TR\"]}], \"]\"}]\) rotates the embedding of the graph g by \[Theta] radians about the origin \!\(\*RowBox[{\"(\", RowBox[{\"0\", \",\", \"0\"}], \")\"}]\). "
Combinatorica`Runs::usage = "\!\(\*RowBox[{\"Runs\", \"[\", StyleBox[\"p\", \"TI\"], \"]\"}]\) partitions p into contiguous increasing subsequences."
Combinatorica`SamenessRelation::usage = "\!\(\*RowBox[{\"SamenessRelation\", \"[\", StyleBox[\"l\", \"TI\"], \"]\"}]\) constructs a binary relation from a list l of permutations, which is an equivalence relation if l is a permutation group."
Combinatorica`SelectionSort::usage = "\!\(\*RowBox[{\"SelectionSort\", \"[\", RowBox[{StyleBox[\"l\", \"TI\"], \",\", StyleBox[\"f\", \"TI\"]}], \"]\"}]\) sorts list l using ordering function f."
Combinatorica`SelfComplementaryQ::usage = "\!\(\*RowBox[{\"SelfComplementaryQ\", \"[\", StyleBox[\"g\", \"TI\"], \"]\"}]\) yields True if graph g is self-complementary, meaning it is isomorphic to its complement."
Combinatorica`SelfLoopsQ::usage = "\!\(\*RowBox[{\"SelfLoopsQ\", \"[\", StyleBox[\"g\", \"TI\"], \"]\"}]\) yields True if graph g has self-loops."
Combinatorica`SetEdgeLabels::usage = "\!\(\*RowBox[{\"SetEdgeLabels\", \"[\", RowBox[{StyleBox[\"g\", \"TI\"], \",\", StyleBox[\"l\", \"TI\"]}], \"]\"}]\) assigns the labels in l to edges of g. "
Combinatorica`SetEdgeWeights::usage = "\!\(\*RowBox[{\"SetEdgeWeights\", \"[\", StyleBox[\"g\", \"TI\"], \"]\"}]\) assigns random real weights in the range \!\(\*RowBox[{\"[\", RowBox[{\"0\", \",\", \"1\"}], \"]\"}]\) to edges in g. \n\!\(\*RowBox[{\"SetEdgeWeights\", \"[\", RowBox[{StyleBox[\"g\", \"TI\"], \",\", StyleBox[\"e\", \"TI\"]}], \"]\"}]\) assigns edge weights to the edges in the edge list e. \n\!\(\*RowBox[{\"SetEdgeWeights\", \"[\", RowBox[{StyleBox[\"g\", \"TI\"], \",\", StyleBox[\"w\", \"TI\"]}], \"]\"}]\) assigns the weights in the weight list w to the edges of g. \n\!\(\*RowBox[{\"SetEdgeWeights\", \"[\", RowBox[{StyleBox[\"g\", \"TI\"], \",\", StyleBox[\"e\", \"TI\"], \",\", StyleBox[\"w\", \"TI\"]}], \"]\"}]\) assigns the weights in the weight list w to the edges in edge list e."
Combinatorica`SetGraphOptions::usage = "\!\(\*RowBox[{\"SetGraphOptions\", \"[\", RowBox[{StyleBox[\"g\", \"TI\"], \",\", StyleBox[\"opts\", \"TI\"]}], \"]\"}]\) returns g with the options \!\(\*StyleBox[\"opts\", \"TI\"]\) set. \n\!\(\*RowBox[{\"SetGraphOptions\", \"[\", RowBox[{StyleBox[\"g\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"v\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"v\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TI\"], \",\", SubscriptBox[StyleBox[\"v\", \"TI\"], StyleBox[\"opts\", \"TI\"]]}], \"}\"}], \",\", SubscriptBox[StyleBox[\"g\", \"TI\"], StyleBox[\"opts\", \"TI\"]]}], \"]\"}]\) returns the graph with the options \!\(\*SubscriptBox[StyleBox[\"v\", \"TI\"], StyleBox[\"opts\", \"TI\"]]\) set for vertices \!\(\*RowBox[{SubscriptBox[\"v\", \"1\"], \",\", SubscriptBox[\"v\", \"2\"], \",\", \"\[Ellipsis]\"}]\) and the options \!\(\*SubscriptBox[StyleBox[\"g\", \"TI\"], StyleBox[\"opts\", \"TI\"]]\) set for the graph g. \n\!\(\*RowBox[{\"SetGraphOptions\", \"[\", RowBox[{StyleBox[\"g\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"e\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"e\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TI\"], \",\", SubscriptBox[StyleBox[\"e\", \"TI\"], StyleBox[\"opts\", \"TI\"]]}], \"}\"}], \",\", SubscriptBox[StyleBox[\"g\", \"TI\"], StyleBox[\"opts\", \"TI\"]]}], \"]\"}]\) with edges \!\(\*RowBox[{SubscriptBox[\"e\", \"1\"], \",\", SubscriptBox[\"e\", \"2\"], \",\", \"\[Ellipsis]\"}]\), works similarly. \n\!\(\*RowBox[{\"SetGraphOptions\", \"[\", RowBox[{StyleBox[\"g\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"elements\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"opts\", \"TI\"], StyleBox[\"1\", \"TR\"]]}], \"}\"}], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"elements\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"opts\", \"TI\"], StyleBox[\"2\", \"TR\"]]}], \"}\"}], \",\", RowBox[{StyleBox[\"\[Ellipsis]\", \"TR\"], RowBox[{\"}\", \",\"}], StyleBox[\"opts\", \"TI\"]}]}]}]}], \"]\"}]\) returns g with the options \!\(\*SubscriptBox[StyleBox[\"opts\", \"TI\"], StyleBox[\"1\", \"TR\"]]\) set for the elements in the sequence \!\(\*SubscriptBox[StyleBox[\"elements\", \"TI\"], StyleBox[\"1\", \"TR\"]]\), the options \!\(\*SubscriptBox[StyleBox[\"opts\", \"TI\"], StyleBox[\"2\", \"TR\"]]\) set for the elements in the sequence \!\(\*SubscriptBox[StyleBox[\"elements\", \"TI\"], StyleBox[\"2\", \"TR\"]]\), and so on. "
Combinatorica`SetPartitionListViaRGF::usage = "\!\(\*RowBox[{\"SetPartitionListViaRGF\", \"[\", StyleBox[\"n\", \"TI\"], \"]\"}]\) lists all set partitions of the first n natural numbers, by first listing all restricted growth functions (RGFs) on these and then mapping the RGFs to corresponding set partitions. \n\!\(\*RowBox[{\"SetPartitionListViaRGF\", \"[\", RowBox[{StyleBox[\"n\", \"TI\"], \",\", StyleBox[\"k\", \"TI\"]}], \"]\"}]\) lists all RGFs on the first n natural numbers whose maximum element is k and then maps these RGFs into the corresponding set partitions, all of which contain exactly k blocks."
Combinatorica`SetPartitionQ::usage = "\!\(\*RowBox[{\"SetPartitionQ\", \"[\", RowBox[{StyleBox[\"sp\", \"TI\"], \",\", StyleBox[\"s\", \"TI\"]}], \"]\"}]\) determines if \!\(\*StyleBox[\"sp\", \"TI\"]\) is a set partition of set s. \n\!\(\*RowBox[{\"SetPartitionQ\", \"[\", StyleBox[\"sp\", \"TI\"], \"]\"}]\) tests if \!\(\*StyleBox[\"sp\", \"TI\"]\) is a set of disjoint sets."
Combinatorica`SetPartitions::usage = "\!\(\*RowBox[{\"SetPartitions\", \"[\", StyleBox[\"set\", \"TI\"], \"]\"}]\) returns the list of set partitions of \!\(\*StyleBox[\"set\", \"TI\"]\). \n\!\(\*RowBox[{\"SetPartitions\", \"[\", StyleBox[\"n\", \"TI\"], \"]\"}]\) returns the list of set partitions of \!\(\*RowBox[{\"{\", RowBox[{\"1\", \",\", \"2\", \",\", \"\[Ellipsis]\", \",\", \"n\"}], \"}\"}]\). "
Combinatorica`SetPartitionToRGF::usage = "\!\(\*RowBox[{\"SetPartitionToRGF\", \"[\", RowBox[{StyleBox[\"sp\", \"TI\"], \",\", StyleBox[\"set\", \"TI\"]}], \"]\"}]\) converts the set partition \!\(\*StyleBox[\"sp\", \"TI\"]\) of \!\(\*StyleBox[\"set\", \"TI\"]\) into the corresponding restricted growth function. "
Combinatorica`SetVertexLabels::usage = "\!\(\*RowBox[{\"SetVertexLabels\", \"[\", RowBox[{StyleBox[\"g\", \"TI\"], \",\", StyleBox[\"l\", \"TI\"]}], \"]\"}]\) assigns the labels in l to vertices of g. "
Combinatorica`SetVertexWeights::usage = "\!\(\*RowBox[{\"SetVertexWeights\", \"[\", StyleBox[\"g\", \"TI\"], \"]\"}]\) assigns random real weights in the range \!\(\*RowBox[{\"[\", RowBox[{\"0\", \",\", \"1\"}], \"]\"}]\) to vertices in g. \n\!\(\*RowBox[{\"SetVertexWeights\", \"[\", RowBox[{StyleBox[\"g\", \"TI\"], \",\", StyleBox[\"w\", \"TI\"]}], \"]\"}]\) assigns the weights in the weight list w to the vertices of g. \n\!\(\*RowBox[{\"SetVertexWeights\", \"[\", RowBox[{StyleBox[\"g\", \"TI\"], \",\", StyleBox[\"vs\", \"TI\"], \",\", StyleBox[\"w\", \"TI\"]}], \"]\"}]\) assigns the weights in the weight list w to the vertices in the vertex list \!\(\*StyleBox[\"vs\", \"TI\"]\)."
Combinatorica`ShakeGraph::usage = "\!\(\*RowBox[{\"ShakeGraph\", \"[\", RowBox[{StyleBox[\"g\", \"TI\"], \",\", StyleBox[\"d\", \"TI\"]}], \"]\"}]\) performs a random perturbation of the vertices of graph g, with each vertex moving, at most, a distance d from its original position."
Combinatorica`ShortestPath::usage = "\!\(\*RowBox[{\"ShortestPath\", \"[\", RowBox[{StyleBox[\"g\", \"TI\"], \",\", StyleBox[\"start\", \"TI\"], \",\", StyleBox[\"end\", \"TI\"]}], \"]\"}]\) finds a shortest path between vertices \!\(\*StyleBox[\"start\", \"TI\"]\) and \!\(\*StyleBox[\"end\", \"TI\"]\) in graph g. "
Combinatorica`ShortestPathSpanningTree::usage = "\!\(\*RowBox[{\"ShortestPathSpanningTree\", \"[\", RowBox[{StyleBox[\"g\", \"TI\"], \",\", StyleBox[\"v\", \"TI\"]}], \"]\"}]\) constructs a shortest-path spanning tree rooted at v, so that a shortest path in graph g from v to any other vertex is a path in the tree. "
Combinatorica`ShowGraphArray::usage = "\!\(\*RowBox[{\"ShowGraphArray\", \"[\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"g\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"g\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TI\"]}], \"}\"}], \"]\"}]\) displays a row of graphs. \n\!\(\*RowBox[{\"ShowGraphArray\", \"[\", RowBox[{\"{\", RowBox[{RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"g\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TI\"]}], \"}\"}], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"g\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TI\"]}], \"}\"}], \",\", StyleBox[\"\[Ellipsis]\", \"TI\"]}], \"}\"}], \"]\"}]\) displays a two-dimensional table of graphs."
Combinatorica`ShowGraph::usage = "\!\(\*RowBox[{\"ShowGraph\", \"[\", StyleBox[\"g\", \"TI\"], \"]\"}]\) displays the graph g. \n\!\(\*RowBox[{\"ShowGraph\", \"[\", RowBox[{StyleBox[\"g\", \"TI\"], \",\", \"Directed\"}], \"]\"}]\) is obsolete and it is currently identical to \!\(\*RowBox[{\"ShowGraph\", \"[\", StyleBox[\"g\", \"TI\"], \"]\"}]\). "
Combinatorica`ShowLabeledGraph::usage = "\!\(\*RowBox[{\"ShowLabeledGraph\", \"[\", StyleBox[\"g\", \"TI\"], \"]\"}]\) displays graph g according to its embedding, with each vertex labeled with its vertex number.\n\!\(\*RowBox[{\"ShowLabeledGraph\", \"[\", RowBox[{StyleBox[\"g\", \"TI\"], \",\", StyleBox[\"l\", \"TI\"]}], \"]\"}]\) uses the i\!\(\*SuperscriptBox[\"\[Null]\", \"th\"]\) element of list l as the label for vertex i."
Combinatorica`ShuffleExchangeGraph::usage = "\!\(\*RowBox[{\"ShuffleExchangeGraph\", \"[\", StyleBox[\"n\", \"TI\"], \"]\"}]\) returns the n-dimensional shuffle-exchange graph whose vertices are length n binary strings with an edge from w to \!\(\*SuperscriptBox[\"w\", \"\[Prime]\", MultilineFunction -> None]\) if (i) \!\(\*SuperscriptBox[\"w\", \"\[Prime]\", MultilineFunction -> None]\) differs from \!\(\*SuperscriptBox[\"w\", \"\[Prime]\", MultilineFunction -> None]\) in its last bit or (ii) \!\(\*SuperscriptBox[\"w\", \"\[Prime]\", MultilineFunction -> None]\) is obtained from w by a cyclic shift left or a cyclic shift right. "
Combinatorica`SignaturePermutation::usage = "\!\(\*RowBox[{\"SignaturePermutation\", \"[\", StyleBox[\"p\", \"TI\"], \"]\"}]\) gives the signature of permutation p."
Combinatorica`SimpleQ::usage = "\!\(\*RowBox[{\"SimpleQ\", \"[\", StyleBox[\"g\", \"TI\"], \"]\"}]\) yields True if g is a simple graph, meaning it has no multiple edges and contains no self-loops."
Combinatorica`SmallestCyclicGroupGraph::usage = "SmallestCyclicGroupGraph returns a smallest nontrivial graph whose automorphism group is cyclic."
Combinatorica`Spectrum::usage = "\!\(\*RowBox[{\"Spectrum\", \"[\", StyleBox[\"g\", \"TI\"], \"]\"}]\) gives the eigenvalues of graph g."
Combinatorica`SpringEmbedding::usage = "\!\(\*RowBox[{\"SpringEmbedding\", \"[\", StyleBox[\"g\", \"TI\"], \"]\"}]\) beautifies the embedding of graph g by modeling the embedding as a system of springs. \n\!\(\*RowBox[{\"SpringEmbedding\", \"[\", RowBox[{StyleBox[\"g\", \"TI\"], \",\", StyleBox[\"step\", \"TI\"], \",\", StyleBox[\"increment\", \"TI\"]}], \"]\"}]\) can be used to refine the algorithm. "
Combinatorica`StableMarriage::usage = "\!\(\*RowBox[{\"StableMarriage\", \"[\", RowBox[{StyleBox[\"mpref\", \"TI\"], \",\", StyleBox[\"fpref\", \"TI\"]}], \"]\"}]\) finds the male optimal stable marriage defined by lists of permutations describing male and female preferences."
Combinatorica`Star::usage = "\!\(\*RowBox[{\"Star\", \"[\", StyleBox[\"n\", \"TI\"], \"]\"}]\) constructs a star on n vertices, which is a tree with one vertex of degree \!\(\*RowBox[{\"n\", \"-\", \"1\"}]\)"
Combinatorica`StirlingFirst::usage = "\!\(\*RowBox[{\"StirlingFirst\", \"[\", RowBox[{StyleBox[\"n\", \"TI\"], \",\", StyleBox[\"k\", \"TI\"]}], \"]\"}]\) returns the Stirling number of the first kind."
Combinatorica`StirlingSecond::usage = "\!\(\*RowBox[{\"StirlingSecond\", \"[\", RowBox[{StyleBox[\"n\", \"TI\"], \",\", StyleBox[\"k\", \"TI\"]}], \"]\"}]\) returns the Stirling number of the second kind."
Combinatorica`Strings::usage = "\!\(\*RowBox[{\"Strings\", \"[\", RowBox[{StyleBox[\"l\", \"TI\"], \",\", StyleBox[\"n\", \"TI\"]}], \"]\"}]\) constructs all possible strings of length n from the elements of list l."
Combinatorica`StronglyConnectedComponents::usage = "\!\(\*RowBox[{\"StronglyConnectedComponents\", \"[\", StyleBox[\"g\", \"TI\"], \"]\"}]\) gives the strongly connected components of directed graph g as lists of vertices."
Combinatorica`Strong::usage = "Strong is an option to ConnectedQ that seeks to determine if a directed graph is strongly connected."
Combinatorica`SymmetricGroupIndex::usage = "\!\(\*RowBox[{\"SymmetricGroupIndex\", \"[\", RowBox[{StyleBox[\"n\", \"TI\"], \",\", StyleBox[\"x\", \"TI\"]}], \"]\"}]\) returns the cycle index of the symmetric group on n symbols, expressed as a polynomial in \!\(\*RowBox[{RowBox[{\"x\", \"[\", \"1\", \"]\"}], \",\", RowBox[{\"x\", \"[\", \"2\", \"]\"}], \",\", \"\[Ellipsis]\", \",\", RowBox[{\"x\", \"[\", \"n\", \"]\"}]}]\)."
Combinatorica`SymmetricGroup::usage = "\!\(\*RowBox[{\"SymmetricGroup\", \"[\", StyleBox[\"n\", \"TI\"], \"]\"}]\) returns the symmetric group on n symbols."
Combinatorica`SymmetricQ::usage = "\!\(\*RowBox[{\"SymmetricQ\", \"[\", StyleBox[\"r\", \"TI\"], \"]\"}]\) tests if a given square matrix r represents a symmetric relation. \n\!\(\*RowBox[{\"SymmetricQ\", \"[\", StyleBox[\"g\", \"TI\"], \"]\"}]\) tests if the edges of a given graph represent a symmetric relation."
Combinatorica`TableauClasses::usage = "\!\(\*RowBox[{\"TableauClasses\", \"[\", StyleBox[\"p\", \"TI\"], \"]\"}]\) partitions the elements of permutation p into classes according to their initial columns during Young tableaux construction."
Combinatorica`TableauQ::usage = "\!\(\*RowBox[{\"TableauQ\", \"[\", StyleBox[\"t\", \"TI\"], \"]\"}]\) yields True if and only if t represents a Young tableau."
Combinatorica`Tableaux::usage = "\!\(\*RowBox[{\"Tableaux\", \"[\", StyleBox[\"p\", \"TI\"], \"]\"}]\) constructs all tableaux having a shape given by integer partition p."
Combinatorica`TableauxToPermutation::usage = "\!\(\*RowBox[{\"TableauxToPermutation\", \"[\", RowBox[{SubscriptBox[StyleBox[\"t\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"t\", \"TI\"], StyleBox[\"2\", \"TR\"]]}], \"]\"}]\) constructs the unique permutation associated with Young tableaux \!\(\*SubscriptBox[\"t\", \"1\"]\) and \!\(\*SubscriptBox[\"t\", \"2\"]\), where both tableaux have the same shape."
Combinatorica`TetrahedralGraph::usage = "TetrahedralGraph returns the graph corresponding to the tetrahedron, a Platonic solid."
Combinatorica`ThickDashed::usage = "ThickDashed is a value that the option EdgeStyle can take on in the graph data structure or in ShowGraph."
Combinatorica`Thick::usage = "Thick is a value that the option EdgeStyle can take on in the graph data structure or in ShowGraph."
Combinatorica`ThinDashed::usage = "ThinDashed is a value that the option EdgeStyle can take on in the graph data structure or in ShowGraph."
Combinatorica`Thin::usage = "Thin is a value that the option EdgeStyle can take on in the graph data structure or in ShowGraph."
Combinatorica`ThomassenGraph::usage = "ThomassenGraph returns a hypotraceable graph, a graph G that has no Hamiltonian path but whose subgraph \!\(\*RowBox[{\"G\", \"-\", \"v\"}]\) for every vertex v has a Hamiltonian path."
Combinatorica`ToAdjacencyLists::usage = "\!\(\*RowBox[{\"ToAdjacencyLists\", \"[\", StyleBox[\"g\", \"TI\"], \"]\"}]\) constructs an adjacency list representation for graph g. \n\!\(\*RowBox[{\"ToAdjacencyLists\", \"[\", RowBox[{StyleBox[\"g\", \"TI\"], \",\", \"EdgeWeight\"}], \"]\"}]\) returns an adjacency list representation along with edge weights."
Combinatorica`ToAdjacencyMatrix::usage = "\!\(\*RowBox[{\"ToAdjacencyMatrix\", \"[\", StyleBox[\"g\", \"TI\"], \"]\"}]\) constructs an adjacency matrix representation for graph g. \n\!\(\*RowBox[{RowBox[{RowBox[{RowBox[{\"ToAdjacencyMatrix\", \"[\"}], StyleBox[\"g\", \"TI\"]}], \",\", \"EdgeWeight\"}], \"]\"}]\) returns edge weights as entries of the adjacency matrix with Infinity representing missing edges."
Combinatorica`ToCanonicalSetPartition::usage = "\!\(\*RowBox[{\"ToCanonicalSetPartition\", \"[\", RowBox[{StyleBox[\"sp\", \"TI\"], \",\", StyleBox[\"set\", \"TI\"]}], \"]\"}]\) reorders \!\(\*StyleBox[\"sp\", \"TI\"]\) into a canonical order with respect to \!\(\*StyleBox[\"set\", \"TI\"]\). \n\!\(\*RowBox[{\"ToCanonicalSetPartition\", \"[\", StyleBox[\"sp\", \"TI\"], \"]\"}]\) reorders \!\(\*StyleBox[\"sp\", \"TI\"]\) into canonical order, assuming that \!\(\*StyleBox[\"Mathematica\", FontSlant -> \"Italic\"]\) knows the underlying order on the set for which \!\(\*StyleBox[\"sp\", \"TI\"]\) is a set partition."
Combinatorica`ToCycles::usage = "\!\(\*RowBox[{\"ToCycles\", \"[\", StyleBox[\"p\", \"TI\"], \"]\"}]\) gives the cycle structure of permutation p as a list of cyclic permutations."
Combinatorica`ToInversionVector::usage = "\!\(\*RowBox[{\"ToInversionVector\", \"[\", StyleBox[\"p\", \"TI\"], \"]\"}]\) gives the inversion vector associated with permutation p."
Combinatorica`ToOrderedPairs::usage = "\!\(\*RowBox[{\"ToOrderedPairs\", \"[\", StyleBox[\"g\", \"TI\"], \"]\"}]\) constructs a list of ordered pairs representing the edges of the graph g. "
Combinatorica`TopologicalSort::usage = "\!\(\*RowBox[{\"TopologicalSort\", \"[\", StyleBox[\"g\", \"TI\"], \"]\"}]\) gives a permutation of the vertices of the directed acyclic graph g such that an edge \!\(\*RowBox[{\"(\", RowBox[{\"i\", \",\", \"j\"}], \")\"}]\) implies that vertex i appears before vertex j."
Combinatorica`ToUnorderedPairs::usage = "\!\(\*RowBox[{\"ToUnorderedPairs\", \"[\", StyleBox[\"g\", \"TI\"], \"]\"}]\) constructs a list of unordered pairs representing the edges of graph g. Each edge, directed or undirected, results in a pair in which the smaller vertex appears first. "
Combinatorica`TransitiveClosure::usage = "\!\(\*RowBox[{\"TransitiveClosure\", \"[\", StyleBox[\"g\", \"TI\"], \"]\"}]\) finds the transitive closure of graph g, the supergraph of g that contains edge \!\(\*RowBox[{\"{\", RowBox[{\"x\", \",\", \"y\"}], \"}\"}]\) if and only if there is a path from x to y."
Combinatorica`TransitiveQ::usage = "\!\(\*RowBox[{\"TransitiveQ\", \"[\", StyleBox[\"g\", \"TI\"], \"]\"}]\) yields True if graph g defines a transitive relation."
Combinatorica`TransitiveReduction::usage = "\!\(\*RowBox[{\"TransitiveReduction\", \"[\", StyleBox[\"g\", \"TI\"], \"]\"}]\) finds a smallest graph that has the same transitive closure as g."
Combinatorica`TranslateVertices::usage = "\!\(\*RowBox[{\"TranslateVertices\", \"[\", RowBox[{StyleBox[\"v\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"y\", \"TI\"]}], \"}\"}]}], \"]\"}]\) adds the vector \!\(\*RowBox[{\"{\", RowBox[{\"x\", \",\", \"y\"}], \"}\"}]\) to the vertex embedding location of each vertex in list v. \n\!\(\*RowBox[{\"TranslateVertices\", \"[\", RowBox[{StyleBox[\"g\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"y\", \"TI\"]}], \"}\"}]}], \"]\"}]\) translates the embedding of the graph g by the vector \!\(\*RowBox[{\"{\", RowBox[{\"x\", \",\", \"y\"}], \"}\"}]\)."
Combinatorica`TransposePartition::usage = "\!\(\*RowBox[{\"TransposePartition\", \"[\", StyleBox[\"p\", \"TI\"], \"]\"}]\) reflects a partition p of k parts along the main diagonal, creating a partition with maximum part k."
Combinatorica`TransposeTableau::usage = "\!\(\*RowBox[{\"TransposeTableau\", \"[\", StyleBox[\"t\", \"TI\"], \"]\"}]\) reflects a Young tableau t along the main diagonal, creating a different tableau."
Combinatorica`TravelingSalesmanBounds::usage = "\!\(\*RowBox[{\"TravelingSalesmanBounds\", \"[\", StyleBox[\"g\", \"TI\"], \"]\"}]\) gives upper and lower bounds on a minimum-cost traveling salesman tour of graph g."
Combinatorica`TravelingSalesman::usage = "\!\(\*RowBox[{\"TravelingSalesman\", \"[\", StyleBox[\"g\", \"TI\"], \"]\"}]\) finds an optimal traveling salesman tour in graph g."
Combinatorica`TreeIsomorphismQ::usage = "\!\(\*RowBox[{\"TreeIsomorphismQ\", \"[\", RowBox[{SubscriptBox[StyleBox[\"t\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"t\", \"TI\"], StyleBox[\"2\", \"TR\"]]}], \"]\"}]\) yields True if the trees \!\(\*SubscriptBox[\"t\", \"1\"]\) and \!\(\*SubscriptBox[\"t\", \"2\"]\) are isomorphic. It yields False otherwise."
Combinatorica`Tree::usage = "Tree is an option that informs certain functions that the user wants the output to be a tree."
Combinatorica`TreeQ::usage = "\!\(\*RowBox[{\"TreeQ\", \"[\", StyleBox[\"g\", \"TI\"], \"]\"}]\) yields True if graph g is a tree."
Combinatorica`TreeToCertificate::usage = "\!\(\*RowBox[{\"TreeToCertificate\", \"[\", StyleBox[\"t\", \"TI\"], \"]\"}]\) returns a binary string that is a certificate for the tree t such that trees have the same certificate if and only if they are isomorphic."
Combinatorica`TriangleInequalityQ::usage = "\!\(\*RowBox[{\"TriangleInequalityQ\", \"[\", StyleBox[\"g\", \"TI\"], \"]\"}]\) yields True if the weights assigned to the edges of graph g satisfy the triangle inequality."
Combinatorica`Turan::usage = "\!\(\*RowBox[{\"Turan\", \"[\", RowBox[{StyleBox[\"n\", \"TI\"], \",\", StyleBox[\"p\", \"TI\"]}], \"]\"}]\) constructs the Tur\[AAcute]n graph, the extremal graph on n vertices that does not contain \!\(\*RowBox[{\"CompleteGraph\", \"[\", StyleBox[\"p\", \"TI\"], \"]\"}]\)."
Combinatorica`TutteGraph::usage = "TutteGraph returns the Tutte graph, the first known example of a 3-connected, 3-regular, planar graph that is non-Hamiltonian."
Combinatorica`TwoColoring::usage = "\!\(\*RowBox[{\"TwoColoring\", \"[\", StyleBox[\"g\", \"TI\"], \"]\"}]\) finds a two-coloring of graph g if g is bipartite. It returns a list of the labels 1 and 2 corresponding to the vertices. "
Combinatorica`Undirected::usage = "Undirected is an option to inform certain functions that the graph is undirected."
Combinatorica`UndirectedQ::usage = "\!\(\*RowBox[{\"UndirectedQ\", \"[\", StyleBox[\"g\", \"TI\"], \"]\"}]\) yields True if graph g is undirected."
Combinatorica`UnionSet::usage = "\!\(\*RowBox[{\"UnionSet\", \"[\", RowBox[{StyleBox[\"a\", \"TI\"], \",\", StyleBox[\"b\", \"TI\"], \",\", StyleBox[\"s\", \"TI\"]}], \"]\"}]\) merges the sets containing a and b in union-find data structure s."
Combinatorica`Uniquely3ColorableGraph::usage = "Uniquely3ColorableGraph returns a 12-vertex, triangle-free graph with chromatic number 3 that is uniquely 3-colorable."
Combinatorica`UnitransitiveGraph::usage = "UnitransitiveGraph returns a 20-vertex, 3-unitransitive graph discovered by Coxeter, that is not isomorphic to a 4-cage or a 5-cage."
Combinatorica`UnrankBinarySubset::usage = "\!\(\*RowBox[{\"UnrankBinarySubset\", \"[\", RowBox[{StyleBox[\"n\", \"TI\"], \",\", StyleBox[\"l\", \"TI\"]}], \"]\"}]\) gives the n\!\(\*SuperscriptBox[\"\[Null]\", \"th\"]\) subset of list l, listed in increasing order of integers corresponding to the binary representations of the subsets."
Combinatorica`UnrankGrayCodeSubset::usage = "\!\(\*RowBox[{\"UnrankGrayCodeSubset\", \"[\", RowBox[{StyleBox[\"n\", \"TI\"], \",\", StyleBox[\"l\", \"TI\"]}], \"]\"}]\) gives the n\!\(\*SuperscriptBox[\"\[Null]\", \"th\"]\) subset of list l, listed in Gray code order."
Combinatorica`UnrankKSetPartition::usage = "\!\(\*RowBox[{\"UnrankSetPartition\", \"[\", RowBox[{StyleBox[\"r\", \"TI\"], \",\", StyleBox[\"s\", \"TI\"], \",\", StyleBox[\"k\", \"TI\"]}], \"]\"}]\) finds a k-block set partition of s with rank r. \n\!\(\*RowBox[{\"UnrankSetPartition\", \"[\", RowBox[{StyleBox[\"r\", \"TI\"], \",\", StyleBox[\"n\", \"TI\"], \",\", StyleBox[\"k\", \"TI\"]}], \"]\"}]\) finds a k-block set partition of \!\(\*RowBox[{\"{\", RowBox[{\"1\", \",\", \"2\", \",\", \"\[Ellipsis]\", \",\", \"n\"}], \"}\"}]\) with rank r."
Combinatorica`UnrankKSubset::usage = "\!\(\*RowBox[{\"UnrankKSubset\", \"[\", RowBox[{StyleBox[\"m\", \"TI\"], \",\", StyleBox[\"k\", \"TI\"], \",\", StyleBox[\"l\", \"TI\"]}], \"]\"}]\) gives the m\!\(\*SuperscriptBox[\"\[Null]\", \"th\"]\) k-subset of set l, listed in lexicographic order."
Combinatorica`UnrankPermutation::usage = "\!\(\*RowBox[{\"UnrankPermutation\", \"[\", RowBox[{StyleBox[\"r\", \"TI\"], \",\", StyleBox[\"l\", \"TI\"]}], \"]\"}]\) gives the r\!\(\*SuperscriptBox[\"\[Null]\", \"th\"]\) permutation in the lexicographic list of permutations of list l. \n\!\(\*RowBox[{\"UnrankPermutation\", \"[\", RowBox[{StyleBox[\"r\", \"TI\"], \",\", StyleBox[\"n\", \"TI\"]}], \"]\"}]\) gives the r\!\(\*SuperscriptBox[\"\[Null]\", \"th\"]\) permutation in the lexicographic list of permutations of \!\(\*RowBox[{\"{\", RowBox[{\"1\", \",\", \"2\", \",\", \"\[Ellipsis]\", \",\", \"n\"}], \"}\"}]\)."
Combinatorica`UnrankRGF::usage = "\!\(\*RowBox[{\"UnrankRGF\", \"[\", RowBox[{StyleBox[\"r\", \"TI\"], \",\", StyleBox[\"n\", \"TI\"]}], \"]\"}]\) returns a restricted growth function defined on the first n natural numbers whose rank is r."
Combinatorica`UnrankSetPartition::usage = "\!\(\*RowBox[{\"UnrankSetPartition\", \"[\", RowBox[{StyleBox[\"r\", \"TI\"], \",\", StyleBox[\"set\", \"TI\"]}], \"]\"}]\) finds a set partition of \!\(\*StyleBox[\"set\", \"TI\"]\) with rank r. \n\!\(\*RowBox[{\"UnrankSetPartition\", \"[\", RowBox[{StyleBox[\"r\", \"TI\"], \",\", StyleBox[\"n\", \"TI\"]}], \"]\"}]\) finds a set partition of \!\(\*RowBox[{\"{\", RowBox[{\"1\", \",\", \"2\", \",\", \"\[Ellipsis]\", \",\", \"n\"}], \"}\"}]\) with rank r."
Combinatorica`UnrankSubset::usage = "\!\(\*RowBox[{\"UnrankSubset\", \"[\", RowBox[{StyleBox[\"n\", \"TI\"], \",\", StyleBox[\"l\", \"TI\"]}], \"]\"}]\) gives the \!\(\*StyleBox[\"n\", \"TI\"]\)\!\(\*SuperscriptBox[\"\[Null]\", \"th\"]\) subset of list l, listed in some canonical order."
Combinatorica`UnweightedQ::usage = "\!\(\*RowBox[{\"UnweightedQ\", \"[\", StyleBox[\"g\", \"TI\"], \"]\"}]\) yields True if all edge weights are 1 and False otherwise."
Combinatorica`UpperLeft::usage = "UpperLeft is a value that options VertexNumberPosition, VertexLabelPosition, and EdgeLabelPosition can take on in ShowGraph."
Combinatorica`UpperRight::usage = "UpperRight is a value that options VertexNumberPosition, VertexLabelPosition, and EdgeLabelPosition can take on in ShowGraph."
Combinatorica`VertexColoring::usage = "\!\(\*RowBox[{\"VertexColoring\", \"[\", StyleBox[\"g\", \"TI\"], \"]\"}]\) uses Brelaz's heuristic to find a good, but not necessarily minimal, vertex coloring of graph g. "
Combinatorica`VertexColor::usage = "VertexColor is an option that allows the user to associate colors with vertices. "
Combinatorica`VertexConnectivityGraph::usage = "\!\(\*RowBox[{\"VertexConnectivityGraph\", \"[\", StyleBox[\"g\", \"TI\"], \"]\"}]\) returns a directed graph that contains an edge corresponding to each vertex in g and in which edge disjoint paths correspond to vertex disjoint paths in g."
Combinatorica`VertexConnectivity::usage = "\!\(\*RowBox[{\"VertexConnectivity\", \"[\", StyleBox[\"g\", \"TI\"], \"]\"}]\) gives the minimum number of vertices whose deletion from graph g disconnects it. \n\!\(\*RowBox[{\"VertexConnectivity\", \"[\", RowBox[{StyleBox[\"g\", \"TI\"], \",\", \"Cut\"}], \"]\"}]\) gives a set of vertices of minimum size whose removal disconnects the graph."
Combinatorica`VertexCover::usage = "\!\(\*RowBox[{\"VertexCover\", \"[\", StyleBox[\"g\", \"TI\"], \"]\"}]\) returns a vertex cover of the graph g. "
Combinatorica`VertexCoverQ::usage = "\!\(\*RowBox[{\"VertexCoverQ\", \"[\", RowBox[{StyleBox[\"g\", \"TI\"], \",\", StyleBox[\"c\", \"TI\"]}], \"]\"}]\) yields True if the vertices in list c define a vertex cover of graph g."
Combinatorica`VertexLabelColor::usage = "VertexLabelColor is an option that allows the user to associate different colors to vertex labels."
Combinatorica`VertexLabel::usage = "VertexLabel is an option that can take on values True or False, allowing the user to set and display vertex labels. "
Combinatorica`VertexLabelPosition::usage = "VertexLabelPosition is an option that allows the user to place a vertex label in a certain position relative to the vertex. "
Combinatorica`VertexNumberColor::usage = "VertexNumberColor is an option that can be used in ShowGraph to associate different colors to vertex numbers. "
Combinatorica`VertexNumber::usage = "VertexNumber is an option that can take on values True or False. This can be used in ShowGraph to display or suppress vertex numbers. "
Combinatorica`VertexNumberPosition::usage = "VertexNumberPosition is an option that can be used in ShowGraph to display a vertex number in a certain position relative to the vertex. "
Combinatorica`VertexStyle::usage = "VertexStyle is an option that allows the user to associate different sizes and shapes to vertices."
Combinatorica`VertexWeight::usage = "VertexWeight is an option that allows the user to associate weights with vertices. "
Combinatorica`Vertices::usage = "\!\(\*RowBox[{\"Vertices\", \"[\", StyleBox[\"g\", \"TI\"], \"]\"}]\) gives the coordinates of each vertex of graph g embedded in a plane.\n\!\(\*RowBox[{\"Vertices\", \"[\", RowBox[{StyleBox[\"g\", \"TI\"], \",\", \"All\"}], \"]\"}]\) gives the embedding of the graph along with graphics options associated with each vertex."
Combinatorica`V::usage = "\!\(\*RowBox[{\"V\", \"[\", StyleBox[\"g\", \"TI\"], \"]\"}]\) gives the order or number of vertices of the graph g."
Combinatorica`WaltherGraph::usage = "WaltherGraph returns the Walther graph."
Combinatorica`WeaklyConnectedComponents::usage = "\!\(\*RowBox[{\"WeaklyConnectedComponents\", \"[\", StyleBox[\"g\", \"TI\"], \"]\"}]\) gives the weakly connected components of directed graph g as lists of vertices."
Combinatorica`Weak::usage = "Weak is an option to ConnectedQ that seeks to determine if a directed graph is weakly connected."
Combinatorica`WeightingFunction::usage = "WeightingFunction is an option to the functions SetEdgeWeights and SetVertexWeights that tells the functions how to compute edge weights and vertex weights, respectively. "
Combinatorica`WeightRange::usage = "WeightRange is an option to the functions SetEdgeWeights and SetVertexWeights that gives the range for these weights. "
Combinatorica`Wheel::usage = "\!\(\*RowBox[{\"Wheel\", \"[\", StyleBox[\"n\", \"TI\"], \"]\"}]\) constructs a wheel on n vertices, which is the join of \!\(\*RowBox[{\"CompleteGraph\", \"[\", StyleBox[\"1\", \"TR\"], \"]\"}]\) and \!\(\*RowBox[{\"Cycle\", \"[\", RowBox[{StyleBox[\"n\", \"TI\"], \"-\", StyleBox[\"1\", \"TR\"]}], \"]\"}]\)."
Combinatorica`WriteGraph::usage = "\!\(\*RowBox[{\"WriteGraph\", \"[\", RowBox[{StyleBox[\"g\", \"TI\"], \",\", StyleBox[\"f\", \"TI\"]}], \"]\"}]\) writes graph g to file f using an edge list representation."
Combinatorica`Zoom::usage = "\!\(\*RowBox[{\"Zoom\", \"[\", RowBox[{\"{\", RowBox[{StyleBox[\"i\", \"TI\"], \",\", StyleBox[\"j\", \"TI\"], \",\", StyleBox[\"k\", \"TI\"], \",\", StyleBox[\"\[Ellipsis]\", \"TI\"]}], \"}\"}], \"]\"}]\) is a value that the PlotRange option can take on in ShowGraph. Setting PlotRange to this value zooms the display to contain the specified subset of vertices, \!\(\*RowBox[{\"i\", \",\", \"j\", \",\", \"k\", \",\", \"\[Ellipsis]\"}]\)."
ComputationalGeometry`AllPoints::usage = "AllPoints is an option to ConvexHull that specifies whether all distinct points on the hull or only the minimum set of points needed to define the hull are returned."
ComputationalGeometry`BoundedDiagram::usage = "\!\(\*RowBox[{\"BoundedDiagram\", \"[\", RowBox[{RowBox[{\"{\", RowBox[{RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"a\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"b\", \"TI\"], StyleBox[\"1\", \"TR\"]]}], \"}\"}], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \",\", RowBox[{\"{\", RowBox[{RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"y\", \"TI\"], StyleBox[\"1\", \"TR\"]]}], \"}\"}], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}]}], \"]\"}]\) yields the bounded Voronoi diagram of the points \!\(\*RowBox[{RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"y\", \"TI\"], StyleBox[\"1\", \"TR\"]]}], \"}\"}], \",\", RowBox[{RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"y\", \"TI\"], StyleBox[\"2\", \"TR\"]]}], \"}\"}], StyleBox[\"\[Ellipsis]\", \"TR\"]}]}]\), where the bound is the convex polygon formed from the points \!\(\*RowBox[{\"{\", RowBox[{RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"a\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"b\", \"TI\"], StyleBox[\"1\", \"TR\"]]}], \"}\"}], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}]\).\n\!\(\*RowBox[{\"BoundedDiagram\", \"[\", RowBox[{RowBox[{\"{\", RowBox[{RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"a\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"b\", \"TI\"], StyleBox[\"1\", \"TR\"]]}], \"}\"}], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \",\", RowBox[{\"{\", RowBox[{RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"y\", \"TI\"], StyleBox[\"1\", \"TR\"]]}], \"}\"}], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \",\", StyleBox[\"val\", \"TI\"]}], \"]\"}]\) takes \!\(\*StyleBox[\"val\", \"TI\"]\) to be the Delaunay triangulation vertex adjacency list.\n\!\(\*RowBox[{\"BoundedDiagram\", \"[\", RowBox[{RowBox[{\"{\", RowBox[{RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"a\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"b\", \"TI\"], StyleBox[\"1\", \"TR\"]]}], \"}\"}], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \",\", RowBox[{\"{\", RowBox[{RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"y\", \"TI\"], StyleBox[\"1\", \"TR\"]]}], \"}\"}], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \",\", StyleBox[\"val\", \"TI\"], StyleBox[\",\", \"TI\"], StyleBox[\"hull\", \"TI\"]}], \"]\"}]\) takes \!\(\*StyleBox[\"hull\", \"TI\"]\) to be the convex hull index list."
ComputationalGeometry`ConvexHullArea::usage = "\!\(\*RowBox[{\"ConvexHullArea\", \"[\", RowBox[{\"{\", RowBox[{RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"y\", \"TI\"], StyleBox[\"1\", \"TR\"]]}], \"}\"}], \",\", StyleBox[\"\[Ellipsis]\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"n\", \"TI\"]], \",\", SubscriptBox[StyleBox[\"y\", \"TI\"], StyleBox[\"n\", \"TI\"]]}], \"}\"}]}], \"}\"}], \"]\"}]\) gives the area of the convex hull of the bivariate data."
ComputationalGeometry`ConvexHullMedian::usage = "\!\(\*RowBox[{\"ConvexHullMedian\", \"[\", RowBox[{\"{\", RowBox[{RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"y\", \"TI\"], StyleBox[\"1\", \"TR\"]]}], \"}\"}], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"n\", \"TI\"]], \",\", SubscriptBox[StyleBox[\"y\", \"TI\"], StyleBox[\"n\", \"TI\"]]}], \"}\"}]}], \"}\"}], \"]\"}]\) estimates the median to be the mean of the bivariate data points lying on the innermost layer of the convex layers of the data."
ComputationalGeometry`ConvexHull::usage = "\!\(\*RowBox[{\"ConvexHull\", \"[\", RowBox[{\"{\", RowBox[{RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"y\", \"TI\"], StyleBox[\"1\", \"TR\"]]}], \"}\"}], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"y\", \"TI\"], StyleBox[\"2\", \"TR\"]]}], \"}\"}], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \"]\"}]\) yields the planar convex hull of the points \!\(\*RowBox[{\"{\", RowBox[{RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"y\", \"TI\"], StyleBox[\"1\", \"TR\"]]}], \"}\"}], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}]\), represented as a list of point indices arranged in counterclockwise order."
ComputationalGeometry`DelaunayTriangulation::usage = "\!\(\*RowBox[{\"DelaunayTriangulation\", \"[\", RowBox[{\"{\", RowBox[{RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"y\", \"TI\"], StyleBox[\"1\", \"TR\"]]}], \"}\"}], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"y\", \"TI\"], StyleBox[\"2\", \"TR\"]]}], \"}\"}], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \"]\"}]\) yields the planar Delaunay triangulation of the points \!\(\*RowBox[{\"{\", RowBox[{RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"y\", \"TI\"], StyleBox[\"1\", \"TR\"]]}], \"}\"}], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}]\)."
ComputationalGeometry`DelaunayTriangulationQ::usage = "\!\(\*RowBox[{\"DelaunayTriangulationQ\", \"[\", RowBox[{RowBox[{\"{\", RowBox[{RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"y\", \"TI\"], StyleBox[\"1\", \"TR\"]]}], \"}\"}], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"y\", \"TI\"], StyleBox[\"2\", \"TR\"]]}], \"}\"}], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \",\", StyleBox[\"val\", \"TI\"]}], \"]\"}]\) gives True if the triangulation of the points \!\(\*RowBox[{\"{\", RowBox[{RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"y\", \"TI\"], StyleBox[\"1\", \"TR\"]]}], \"}\"}], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}]\) represented by the vertex adjacency list \!\(\*StyleBox[\"val\", \"TI\"]\) is a Delaunay triangulation and False otherwise. \n\!\(\*RowBox[{\"DelaunayTriangulationQ\", \"[\", RowBox[{RowBox[{\"{\", RowBox[{RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"y\", \"TI\"], StyleBox[\"1\", \"TR\"]]}], \"}\"}], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"y\", \"TI\"], StyleBox[\"2\", \"TR\"]]}], \"}\"}], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \",\", StyleBox[\"val\", \"TI\"], \",\", StyleBox[\"hull\", \"TI\"]}], \"]\"}]\) takes \!\(\*StyleBox[\"hull\", \"TI\"]\) to be the convex hull index list."
ComputationalGeometry`DiagramPlot::usage = "\!\(\*RowBox[{\"DiagramPlot\", \"[\", RowBox[{\"{\", RowBox[{RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"y\", \"TI\"], StyleBox[\"1\", \"TR\"]]}], \"}\"}], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"y\", \"TI\"], StyleBox[\"2\", \"TR\"]]}], \"}\"}], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \"]\"}]\) plots the Voronoi diagram of the points \!\(\*RowBox[{\"{\", RowBox[{RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"y\", \"TI\"], StyleBox[\"1\", \"TR\"]]}], \"}\"}], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}]\). \n\!\(\*RowBox[{\"DiagramPlot\", \"[\", RowBox[{RowBox[{\"{\", RowBox[{RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"y\", \"TI\"], StyleBox[\"1\", \"TR\"]]}], \"}\"}], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"y\", \"TI\"], StyleBox[\"2\", \"TR\"]]}], \"}\"}], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"q\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"q\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \",\", StyleBox[\"val\", \"TI\"]}], \"]\"}]\) plots the points \!\(\*RowBox[{\"{\", RowBox[{RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"y\", \"TI\"], StyleBox[\"1\", \"TR\"]]}], \"}\"}], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}]\) as well as the diagram described by the vertices \!\(\*RowBox[{SubscriptBox[StyleBox[\"q\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"q\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}]\) and the vertex adjacency list \!\(\*StyleBox[\"val\", \"TI\"]\)."
ComputationalGeometry`Hull::usage = "Hull is an option to DelaunayTriangulation that specifies whether the convex hull \!\(\*StyleBox[\"hull\", \"TI\"]\) is to be returned in addition to the vertex adjacency list \!\(\*StyleBox[\"val\", \"TI\"]\) describing the triangulation. "
ComputationalGeometry`LabelPoints::usage = "LabelPoints is an option to the DiagramPlot and PlanarGraphPlot that specifies whether to label points according to their position in the input list."
ComputationalGeometry`NearestNeighbor::usage = "\!\(\*RowBox[{\"NearestNeighbor\", \"[\", RowBox[{RowBox[{\"{\", RowBox[{StyleBox[\"a\", \"TI\"], \",\", StyleBox[\"b\", \"TI\"]}], \"}\"}], \",\", RowBox[{\"{\", RowBox[{RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"y\", \"TI\"], StyleBox[\"1\", \"TR\"]]}], \"}\"}], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"y\", \"TI\"], StyleBox[\"2\", \"TR\"]]}], \"}\"}], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}]}], \"]\"}]\) is an obsolete function."
ComputationalGeometry`PlanarGraphPlot::usage = "\!\(\*RowBox[{\"PlanarGraphPlot\", \"[\", RowBox[{\"{\", RowBox[{RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"y\", \"TI\"], StyleBox[\"1\", \"TR\"]]}], \"}\"}], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"y\", \"TI\"], StyleBox[\"2\", \"TR\"]]}], \"}\"}], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \"]\"}]\) plots the Delaunay triangulation of the points \!\(\*RowBox[{\"{\", RowBox[{RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"y\", \"TI\"], StyleBox[\"1\", \"TR\"]]}], \"}\"}], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}]\).\n\!\(\*RowBox[{RowBox[{\"PlanarGraphPlot\", \"[\", RowBox[{RowBox[{\"{\", RowBox[{RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"y\", \"TI\"], StyleBox[\"1\", \"TR\"]]}], \"}\"}], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"y\", \"TI\"], StyleBox[\"2\", \"TR\"]]}], \"}\"}], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \",\", StyleBox[\"g\", \"TI\"]}], \"]\"}], \"]\"}]\) plots the points \!\(\*RowBox[{\"{\", RowBox[{RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"y\", \"TI\"], StyleBox[\"1\", \"TR\"]]}], \"}\"}], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}]\) as well as the planar graph described by the vertex adjacency list or circuit \!\(\*StyleBox[\"g\", \"TI\"]\)."
ComputationalGeometry`Ray::usage = "\!\(\*RowBox[{\"Ray\", \"[\", RowBox[{RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"y\", \"TI\"], StyleBox[\"1\", \"TR\"]]}], \"}\"}], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"y\", \"TI\"], StyleBox[\"2\", \"TR\"]]}], \"}\"}]}], \"]\"}]\) is an object representing the infinite ray beginning at \!\(\*RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"y\", \"TI\"], StyleBox[\"1\", \"TR\"]]}], \"}\"}]\)in the direction of the point \!\(\*RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"y\", \"TI\"], StyleBox[\"2\", \"TR\"]]}], \"}\"}]\)."
ComputationalGeometry`TileAreas::usage = "\!\(\*RowBox[{\"TileAreas\", \"[\", RowBox[{RowBox[{\"{\", RowBox[{RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"y\", \"TI\"], StyleBox[\"1\", \"TR\"]]}], \"}\"}], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"y\", \"TI\"], StyleBox[\"2\", \"TR\"]]}], \"}\"}], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"q\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"q\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \",\", StyleBox[\"val\", \"TI\"]}], \"]\"}]\) finds the areas of the tiles centered on \!\(\*RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"i\", \"TI\"]], \",\", SubscriptBox[StyleBox[\"y\", \"TI\"], StyleBox[\"i\", \"TI\"]]}], \"}\"}]\) and having vertices \!\(\*SubscriptBox[StyleBox[\"q\", \"TI\"], StyleBox[\"j\", \"TI\"]]\) as stipulated by the vertex adjacency list \!\(\*StyleBox[\"val\", \"TI\"]\)."
ComputationalGeometry`TriangularSurfacePlot::usage = "\!\(\*RowBox[{\"TriangularSurfacePlot\", \"[\", RowBox[{\"{\", RowBox[{RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"y\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"z\", \"TI\"], StyleBox[\"1\", \"TR\"]]}], \"}\"}], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"x\", \"TI\"], \"2\"], \",\", SubscriptBox[StyleBox[\"y\", \"TI\"], \"2\"], \",\", SubscriptBox[StyleBox[\"z\", \"TI\"], \"2\"]}], \"}\"}], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \"]\"}]\) plots the surface according to the Delaunay triangulation established by projecting the points onto the \!\(\*StyleBox[\"x\", \"TI\"]\)-\!\(\*StyleBox[\"y\", \"TI\"]\) plane.\n\!\(\*RowBox[{\"TriangularSurfacePlot\", \"[\", RowBox[{\"{\", RowBox[{RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"y\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"z\", \"TI\"], StyleBox[\"1\", \"TR\"]]}], \"}\"}], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"y\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"z\", \"TI\"], StyleBox[\"2\", \"TR\"]]}], \"}\"}], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \"]\"}]\) plots the surface according to the triangulation given by the vertex adjacency list \!\(\*StyleBox[\"val\", \"TI\"]\)."
ComputationalGeometry`TrimPoints::usage = "TrimPoints is an option to DiagramPlot that specifies which diagram outlier vertex lies on the PlotRange limit."
ComputationalGeometry`VoronoiDiagram::usage = "\!\(\*RowBox[{\"VoronoiDiagram\", \"[\", RowBox[{\"{\", RowBox[{RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"y\", \"TI\"], StyleBox[\"1\", \"TR\"]]}], \"}\"}], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"y\", \"TI\"], StyleBox[\"2\", \"TR\"]]}], \"}\"}], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \"]\"}]\) yields the planar Voronoi diagram of the points \!\(\*RowBox[{RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"y\", \"TI\"], StyleBox[\"1\", \"TR\"]]}], \"}\"}], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"y\", \"TI\"], StyleBox[\"2\", \"TR\"]]}], \"}\"}], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}]\)\n\!\(\*RowBox[{\"VoronoiDiagram\", \"[\", RowBox[{RowBox[{\"{\", RowBox[{RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"y\", \"TI\"], StyleBox[\"1\", \"TR\"]]}], \"}\"}], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"y\", \"TI\"], StyleBox[\"2\", \"TR\"]]}], \"}\"}], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \",\", StyleBox[\"val\", \"TI\"]}], \"]\"}]\) takes \!\(\*StyleBox[\"val\", \"TI\"]\) to be the Delaunay triangulation vertex adjacency list.\n\!\(\*RowBox[{\"VoronoiDiagram\", \"[\", RowBox[{RowBox[{\"{\", RowBox[{RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"y\", \"TI\"], StyleBox[\"1\", \"TR\"]]}], \"}\"}], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"y\", \"TI\"], StyleBox[\"2\", \"TR\"]]}], \"}\"}], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \",\", StyleBox[\"val\", \"TI\"], \",\", StyleBox[\"hull\", \"TI\"]}], \"]\"}]\) takes \!\(\*StyleBox[\"hull\", \"TI\"]\) to be the convex hull index list."
ComputerArithmetic`Arithmetic::usage = "\!\(\*RowBox[{RowBox[{\"Arithmetic\", \"[\"}], \"]\"}]\) gives a list containing the number of digits of precision, the base, and the options and option values of the arithmetic currently in effect."
ComputerArithmetic`ComputerNumber::usage = "\!\(\*RowBox[{\"ComputerNumber\", \"[\", StyleBox[\"x\", \"TI\"], \"]\"}]\) gives the ComputerNumber object equivalent to the ordinary number \!\(\*StyleBox[\"x\", \"TI\"]\) in the arithmetic currently in effect.\n\!\(\*RowBox[{\"ComputerNumber\", \"[\", RowBox[{StyleBox[\"sign\", \"TI\"], \",\", StyleBox[\"mantissa\", \"TI\"], \",\", StyleBox[\"exp\", \"TI\"]}], \"]\"}]\) gives the ComputerNumber object whose value is \!\(\*RowBox[{StyleBox[\"sign\", \"TI\"], StyleBox[\" \", \"TI\"], StyleBox[\"mantissa\", \"TI\"], StyleBox[\" \", \"TI\"], SuperscriptBox[StyleBox[\"b\", \"TI\"], StyleBox[\"exp\", \"TI\"]]}]\), where \!\(\*StyleBox[\"b\", \"TI\"]\) is the base in the arithmetic currently in effect.\n\!\(\*RowBox[{\"ComputerNumber\", \"[\", RowBox[{StyleBox[\"sign\", \"TI\"], \",\", StyleBox[\"mantissa\", \"TI\"], \",\", StyleBox[\"exp\", \"TI\"], \",\", StyleBox[\"value\", \"TI\"], \",\", StyleBox[\"x\", \"TI\"]}], \"]\"}]\) is the complete data object that makes up a computer number."
ComputerArithmetic`ExponentRange::usage = "ExponentRange is an option to SetArithmetic that specifies the range of exponents that are to be allowed."
ComputerArithmetic`IdealDivide::usage = "\!\(\*RowBox[{\"IdealDivide\", \"[\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"y\", \"TI\"]}], \"]\"}]\) gives the correctly rounded result of \!\(\*StyleBox[\"x\", \"TI\"]\) divided by \!\(\*StyleBox[\"y\", \"TI\"]\) involving a single rounding error."
ComputerArithmetic`IdealDivision::usage = "IdealDivision is an option to SetArithmetic that specifies whether $PreRead should be used to translate the default '/' division operator to use IdealDivide."
ComputerArithmetic`MachineError::usage = "\!\(\*RowBox[{\"MachineError\", \"[\", RowBox[{StyleBox[\"f\", \"TI\"], \",\", RowBox[{StyleBox[\"x\", \"TI\"], \"->\", StyleBox[\"a\", \"TI\"]}]}], \"]\"}]\) gives the error involved in evaluating \!\(\*StyleBox[\"f\", \"TI\"]\) at \!\(\*RowBox[{StyleBox[\"x\", \"TI\"], \"=\", StyleBox[\"a\", \"TI\"]}]\) using machine arithmetic."
ComputerArithmetic`MicroscopePlot::usage = "\!\(\*RowBox[{\"MicroscopePlot\", \"[\", RowBox[{StyleBox[\"f\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"a\", \"TI\"]}], \"}\"}]}], \"]\"}]\) plots the expression \!\(\*StyleBox[\"f\", \"TI\"]\) in a small neighborhood of \!\(\*StyleBox[\"a\", \"TI\"]\) using machine arithmetic.\n\!\(\*RowBox[{\"MicroscopePlot\", \"[\", RowBox[{StyleBox[\"f\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"a\", \"TI\"], \",\", StyleBox[\"n\", \"TI\"]}], \"}\"}]}], \"]\"}]\) plots \!\(\*StyleBox[\"f\", \"TI\"]\) from \!\(\*RowBox[{StyleBox[\"a\", \"TI\"], \"-\", StyleBox[\"n\", \"TI\"]}]\) ulps to \!\(\*RowBox[{StyleBox[\"a\", \"TI\"], \"+\", StyleBox[\"n\", \"TI\"]}]\) ulps."
ComputerArithmetic`MicroscopicErrorPlot::usage = "\!\(\*RowBox[{\"MicroscopicErrorPlot\", \"[\", RowBox[{StyleBox[\"f\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"a\", \"TI\"]}], \"}\"}]}], \"]\"}]\) plots the error incurred by using machine arithmetic to evaluate the expression \!\(\*StyleBox[\"f\", \"TI\"]\) in a small neighborhood of \!\(\*StyleBox[\"a\", \"TI\"]\).\n\!\(\*RowBox[{\"MicroscopicErrorPlot\", \"[\", RowBox[{StyleBox[\"f\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"a\", \"TI\"], \",\", StyleBox[\"n\", \"TI\"]}], \"}\"}]}], \"]\"}]\) plots the error from \!\(\*RowBox[{StyleBox[\"a\", \"TI\"], \"-\", StyleBox[\"n\", \"TI\"]}]\) ulps to \!\(\*RowBox[{StyleBox[\"a\", \"TI\"], \"+\", StyleBox[\"n\", \"TI\"]}]\) ulps."
ComputerArithmetic`MixedMode::usage = "MixedMode is an option to SetArithmetic that specifies whether mixed\[Dash]mode arithmetic is to be allowed. The default is False."
ComputerArithmetic`NaN::usage = "NaN is the symbol used by the functions in the Computer Arithmetic Package to represent a nonrepresentable number."
ComputerArithmetic`RoundingRule::usage = "RoundingRule is an option to SetArithmetic that specifies the rounding scheme to use."
ComputerArithmetic`RoundToEven::usage = "RoundToEven is a setting for the option RoundingRule of SetArithmetic that specifies rounding to the nearest representable number and, in the case of a tie, rounding to the one represented by an even mantissa."
ComputerArithmetic`RoundToInfinity::usage = "RoundToInfinity is a setting for the option RoundingRule of SetArithmetic that specifies rounding to the nearest representable number and, in the case of a tie, rounding away from 0."
ComputerArithmetic`SetArithmetic::usage = "\!\(\*RowBox[{\"SetArithmetic\", \"[\", StyleBox[\"d\", \"TI\"], \"]\"}]\) sets the number of digits of precision \!\(\*StyleBox[\"d\", \"TI\"]\) to be used in ComputerNumber objects.\n\!\(\*RowBox[{\"SetArithmetic\", \"[\", RowBox[{StyleBox[\"d\", \"TI\"], \",\", StyleBox[\"b\", \"TI\"]}], \"]\"}]\) sets the number of digits of precision \!\(\*StyleBox[\"d\", \"TI\"]\) and the base \!\(\*StyleBox[\"b\", \"TI\"]\) to be used in ComputerNumber objects."
ComputerArithmetic`Truncation::usage = "Truncation is a setting for the option RoundingRule of SetArithmetic that specifies rounding by discarding excess digits."
ComputerArithmetic`Ulp::usage = "\!\(\*RowBox[{\"Ulp\", \"[\", StyleBox[\"x\", \"TI\"], \"]\"}]\) gives the size of an ulp for numbers near \!\(\*StyleBox[\"x\", \"TI\"]\)."
ComputerArithmetic`Ulps::usage = "Ulps is a unit of error in machine arithmetic. "
DatabaseLink`CloseSQLConnection::usage = " \!\(\*RowBox[{\"CloseSQLConnection\", \"[\", StyleBox[\"conn\", \"TI\"], \"]\"}]\) disconnects the current connection associated with a data source."
DatabaseLink`DatabaseExplorer::usage = "\!\(\*RowBox[{\"DatabaseExplorer\", \"[\", \"]\"}]\) \!\(\*StyleBox[\"launches a graphical user interface to \", \"Text\"]\)\!\(\*StyleBox[\"DatabaseLink\", FontSlant -> \"Italic\"]\)\!\(\*StyleBox[\".\", \"Text\"]\)"
DatabaseLink`DatabaseResourcesPath::usage = "\!\(\*RowBox[{\"DatabaseResourcesPath\", \"[\", \"]\"}]\) gives the list of directories that are searched to find database resources."
DatabaseLink`DataSourceNames::usage = "\!\(\*RowBox[{\"DataSourceNames\", \"[\", \"]\"}]\) returns a list of the names of data sources made available through DatabaseResourcesPath."
DatabaseLink`DataSources::usage = "\!\(\*RowBox[{\"DataSources\", \"[\", \"]\"}]\) returns a list of information about named data sources made available through DatabaseResourcesPath.\n\!\(\*RowBox[{\"DataSources\", \"[\", StyleBox[\"name\", \"TI\"], \"]\"}]\) returns a list of information about the data sources called \!\(\*StyleBox[\"name\", \"TI\"]\)."
DatabaseLink`JDBCDriverNames::usage = "\!\(\*RowBox[{\"JDBCDriverNames\", \"[\", \"]\"}]\) returns a list of the names of databases for which JDBC drivers are available through DatabaseResourcesPath."
DatabaseLink`JDBCDriver::usage = "\!\(\*RowBox[{\"JDBCDriver\", \"[\", StyleBox[\"args\", \"TI\"], \"]\"}]\) specifies the configuration for connecting to a database produced by a specific vendor."
DatabaseLink`JDBCDrivers::usage = "\!\(\*RowBox[{\"JDBCDrivers\", \"[\", \"]\"}]\) returns a list of information about JDBC drivers available through DatabaseResourcesPath.\n\!\(\*RowBox[{\"JDBCDrivers\", \"[\", StyleBox[\"name\", \"TI\"], \"]\"}]\) returns a list of information about the JDBC driver called \!\(\*StyleBox[\"name\", \"TI\"]\)."
DatabaseLink`JDBC::usage = "\!\(\*RowBox[{\"JDBC\", \"[\", StyleBox[\"args\", \"TI\"], \"]\"}]\) is an object that holds parameters for making a JDBC connection to a database."
DatabaseLink`OpenSQLConnection::usage = "\!\(\*RowBox[{\"OpenSQLConnection\", \"[\", StyleBox[RowBox[{\"src\", \",\", \"opts\"}], \"TI\"], \"]\"}]\) makes a connection to a data source.\n\!\(\*RowBox[{\"OpenSQLConnection\", \"[\", \"]\"}]\) opens a GUI that helps to make a connection to a data source."
DatabaseLink`SQLArgument::usage = "\!\(\*RowBox[{\"SQLArgument\", \"[\", RowBox[{StyleBox[\"arg1\", \"TI\"], \",\", \" \", StyleBox[\"arg2\", \"TI\"], \",\", \" \", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) \!\(\*StyleBox[\"holds a sequence of arguments to an SQL query.\", \"Text\"]\)"
DatabaseLink`SQLBeginTransaction::usage = "\!\(\*RowBox[{\"SQLBeginTransaction\", \"[\", StyleBox[\"conn\", \"TI\"], \"]\"}]\) \!\(\*StyleBox[\"initiates an SQL transaction. \", \"Text\"]\)"
DatabaseLink`SQLBinary::usage = "\!\(\*RowBox[{\"SQLBinary\", \"[\", StyleBox[\"data\", \"TI\"], \"]\"}]\) \!\(\*StyleBox[\"represents raw binary data that can be stored in a database.\", \"Text\"]\)"
DatabaseLink`SQLCatalogNames::usage = "\!\(\*RowBox[{\"SQLCatalogNames\", \"[\", StyleBox[\"conn\", \"TI\"], \"]\"}]\) returns the names of the catalogs in an SQL connection."
DatabaseLink`SQLColumnInformation::usage = "\!\(\*RowBox[{\"SQLColumnInformation\", \"[\", StyleBox[\"conn\", \"TI\"], \"]\"}]\) returns a list of information about the columns in an SQL connection."
DatabaseLink`SQLColumnNames::usage = "\!\(\*RowBox[{\"SQLColumnNames\", \"[\", StyleBox[\"conn\", \"TI\"], \"]\"}]\) returns a list of \!\(\*RowBox[{\"{\", RowBox[{StyleBox[\"table\", \"TI\"], \",\", StyleBox[\"name\", \"TI\"]}], \"}\"}]\) pairs for each column in an SQL connection."
DatabaseLink`SQLColumn::usage = "\!\(\*RowBox[{\"SQLColumn\", \"[\", StyleBox[\"args\", \"TI\"], \"]\"}]\) represents a column in an SQL table."
DatabaseLink`SQLColumnPrivileges::usage = "\!\(\*RowBox[{\"SQLColumnPrivileges\", \"[\", StyleBox[\"conn\", \"TI\"], \"]\"}]\) returns a table of access rights about the columns in an SQL connection."
DatabaseLink`SQLColumns::usage = "\!\(\*RowBox[{\"SQLColumns\", \"[\", StyleBox[\"conn\", \"TI\"], \"]\"}]\) returns the SQLColumn objects for each column in an SQL connection."
DatabaseLink`SQLCommitTransaction::usage = "\!\(\*RowBox[{\"SQLCommitTransaction\", \"[\", StyleBox[\"conn\", \"TI\"], \"]\"}]\) \!\(\*StyleBox[\"commits an SQL transaction. \", \"Text\"]\)"
DatabaseLink`SQLConnectionInformation::usage = "\!\(\*RowBox[{\"SQLConnectionInformation\", \"[\", StyleBox[\"conn\", \"TI\"], \"]\"}]\) returns a list of information about the SQL connection."
DatabaseLink`SQLConnection::usage = "\!\(\*RowBox[{\"SQLConnection\", \"[\", StyleBox[\"args\", \"TI\"], \"]\"}]\) is an object that represents a connection to a data source."
DatabaseLink`SQLConnectionPoolClose::usage = "\!\(\*RowBox[{\"SQLConnectionPoolClose\", \"[\", StyleBox[\"args\", \"TI\"], \"]\"}]\) closes a connection pool."
DatabaseLink`SQLConnectionPool::usage = "\!\(\*RowBox[{\"SQLConnectionPool\", \"[\", StyleBox[\"args\", \"TI\"], \"]\"}]\) is an object that represents a connection pool to a data source."
DatabaseLink`SQLConnectionPools::usage = "\!\(\*RowBox[{\"SQLConnectionPools\", \"[\", \"]\"}]\) returns a list of the open connection pools.\n\!\(\*RowBox[{\"SQLConnectionPools\", \"[\", StyleBox[\"conn\", \"TI\"], \"]\"}]\) returns the connection pool used for a connection."
DatabaseLink`SQLConnections::usage = "\!\(\*RowBox[{\"SQLConnections\", \"[\", \"]\"}]\) returns a list of the open SQLConnection objects."
DatabaseLink`SQLCreateTable::usage = "\!\(\*RowBox[{\"SQLCreateTable\", \"[\", RowBox[{StyleBox[\"conn\", \"TI\"], \",\", StyleBox[\"table\", \"TI\"], \",\", StyleBox[\"columns\", \"TI\"], \",\", StyleBox[\"opts\", \"TI\"]}], \"]\"}]\) creates a new table in an SQL connection."
DatabaseLink`SQLDataTypeInformation::usage = "\!\(\*RowBox[{\"SQLDataTypeInformation\", \"[\", StyleBox[\"conn\", \"TI\"], \"]\"}]\) \!\(\*StyleBox[\"returns information about the data types that can be stored in an SQL connection.\", \"Text\"]\)"
DatabaseLink`SQLDataTypeNames::usage = "\!\(\*RowBox[{\"SQLDataTypeNames\", \"[\", StyleBox[\"conn\", \"TI\"], \"]\"}]\) \!\(\*StyleBox[\"returns the names of data types that can be stored in an SQL connection.\", \"Text\"]\)"
DatabaseLink`SQLDateTime::usage = "\!\(\*RowBox[{\"SQLDateTime\", \"[\", StyleBox[\"datetime\", \"TI\"], \"]\"}]\) \!\(\*StyleBox[\"represents date and time information that can be stored in a database.\", \"Text\"]\)"
DatabaseLink`SQLDelete::usage = "\!\(\*RowBox[{\"SQLDelete\", \"[\", RowBox[{StyleBox[\"conn\", \"TI\"], \",\", StyleBox[\"table\", \"TI\"]}], \"]\"}]\) deletes the data in a table in an SQL connection.\n\!\(\*RowBox[{\"SQLDelete\", \"[\", RowBox[{StyleBox[\"conn\", \"TI\"], \",\", StyleBox[\"table\", \"TI\"], \",\", StyleBox[\"cond\", \"TI\"]}], \"]\"}]\) deletes data that matches \!\(\*StyleBox[\"cond\", \"TI\"]\). "
DatabaseLink`SQLDropTable::usage = "\!\(\*RowBox[{\"SQLDropTable\", \"[\", RowBox[{StyleBox[\"conn\", \"TI\"], \",\", StyleBox[\"table\", \"TI\"]}], \"]\"}]\) drops a table in an SQL connection. "
DatabaseLink`SQLExecute::usage = "\!\(\*RowBox[{\"SQLExecute\", \"[\", RowBox[{StyleBox[\"conn\", \"TI\"], \",\", StyleBox[\"command\", \"TI\"], \",\", StyleBox[\"args\", \"TI\"]}], \"]\"}]\) executes a command in an SQL connection."
DatabaseLink`SQLExpr::usage = "\!\(\*RowBox[{\"SQLExpr\", \"[\", StyleBox[\"expr\", \"TI\"], \"]\"}]\) \!\(\*StyleBox[\"allows a \", \"Text\"]\)\!\(\*StyleBox[\"Mathematica\", \"Text\", FontSlant -> \"Italic\"]\)\!\(\*StyleBox[\" expression to be stored in a database.\", \"Text\"]\)"
DatabaseLink`SQLInsert::usage = "\!\(\*RowBox[{\"SQLInsert\", \"[\", RowBox[{StyleBox[\"conn\", \"TI\"], \",\", StyleBox[\"table\", \"TI\"], \",\", StyleBox[\"cols\", \"TI\"], \",\", StyleBox[\"data\", \"TI\"]}], \"]\"}]\) inserts data into a table in an SQL connection."
DatabaseLink`SQLMemberQ::usage = "\!\(\*RowBox[{\"SQLMemberQ\", \"[\", RowBox[{StyleBox[\"data\", \"TI\"], \",\", StyleBox[\"column\", \"TI\"]}], \"]\"}]\) specifies a condition in an SQL query used to test whether an element of a list matches the value of a column."
DatabaseLink`SQLResultSetClose::usage = "\!\(\*RowBox[{\"SQLResultSetClose\", \"[\", StyleBox[\"rs\", \"TI\"], \"]\"}]\) \!\(\*StyleBox[\"closes a result set.\", \"Text\"]\)"
DatabaseLink`SQLResultSetColumnNames::usage = "\!\(\*RowBox[{\"SQLResultSetColumnNames\", \"[\", StyleBox[\"rs\", \"TI\"], \"]\"}]\) returns a list of \!\(\*RowBox[{\"{\", RowBox[{StyleBox[\"table\", \"TI\"], \",\", StyleBox[\"column\", \"TI\"]}], \"}\"}]\) pairs for each column in a result set."
DatabaseLink`SQLResultSetCurrent::usage = "\!\(\*RowBox[{\"SQLResultSetCurrent\", \"[\", StyleBox[\"rs\", \"TI\"], \"]\"}]\) reads the current row from a result set."
DatabaseLink`SQLResultSetGoto::usage = "\!\(\*RowBox[{\"SQLResultSetGoto\", \"[\", RowBox[{StyleBox[\"rs\", \"TI\"], \",\", StyleBox[\"pos\", \"TI\"]}], \"]\"}]\) sets the current position of a result set to \!\(\*StyleBox[\"pos\", \"TI\"]\)."
DatabaseLink`SQLResultSetOpen::usage = "\!\(\*RowBox[{\"SQLResultSetOpen\", \"[\", RowBox[{StyleBox[\"query\", \"TI\"], \",\", \" \", StyleBox[\"opts\", \"TI\"]}], \"]\"}]\) \!\(\*StyleBox[\"makes a result set from an SQL query.\", \"Text\"]\)"
DatabaseLink`SQLResultSetPosition::usage = "\!\(\*RowBox[{\"SQLResultSetPosition\", \"[\", StyleBox[\"rs\", \"TI\"], \"]\"}]\) returns an integer that specifies the current position in a result set."
DatabaseLink`SQLResultSetRead::usage = "\!\(\*RowBox[{\"SQLResultSetRead\", \"[\", StyleBox[\"rs\", \"TI\"], \"]\"}]\) shifts the current position and then reads a row from a result set.\n\!\(\*RowBox[{\"SQLResultSetRead\", \"[\", RowBox[{StyleBox[\"rs\", \"TI\"], \",\", \" \", StyleBox[\"num\", \"TI\"]}], \"]\"}]\) reads \!\(\*StyleBox[\"num\", \"TI\"]\) rows from a result set."
DatabaseLink`SQLResultSetShift::usage = "\!\(\*RowBox[{\"SQLResultSetShift\", \"[\", RowBox[{StyleBox[\"rs\", \"TI\"], \",\", \" \", StyleBox[\"num\", \"TI\"]}], \"]\"}]\) shifts the current position of a result set by \!\(\*StyleBox[\"num\", \"TI\"]\)."
DatabaseLink`SQLResultSets::usage = " \!\(\*RowBox[{\"SQLResultSets\", \"[\", \"]\"}]\) returns a list of the open SQLResultSet objects."
DatabaseLink`SQLResultSetTake::usage = "\!\(\*RowBox[{\"SQLResultSetTake\", \"[\", RowBox[{StyleBox[\"rs\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{StyleBox[\"m\", \"TI\"], \",\", StyleBox[\"n\", \"TI\"]}], \"}\"}]}], \"]\"}]\) reads rows \!\(\*StyleBox[\"m\", \"TI\"]\) through \!\(\*StyleBox[\"n\", \"TI\"]\) from a result set."
DatabaseLink`SQLRollbackTransaction::usage = "\!\(\*RowBox[{\"SQLRollbackTransaction\", \"[\", StyleBox[\"conn\", \"TI\"], \"]\"}]\) \!\(\*StyleBox[\"terminates an SQL transaction. \", \"Text\"]\)\!\(\*RowBox[{\"SQLRollbackTransaction\", \"[\", RowBox[{StyleBox[\"conn\", \"TI\"], \",\", \" \", StyleBox[\"savepoint\", \"TI\"]}], \"]\"}]\) \!\(\*StyleBox[\"returns to an \", \"Text\"]\)SQLSavepoint\!\(\*StyleBox[\".\", \"Text\"]\)"
DatabaseLink`SQLSavepoint::usage = "\!\(\*RowBox[{\"SQLSavepoint\", \"[\", StyleBox[\"args\", \"TI\"], \"]\"}]\) is an object that represents a savepoint in an SQL transaction."
DatabaseLink`SQLSchemaInformation::usage = "\!\(\*RowBox[{\"SQLSchemaInformation\", \"[\", StyleBox[\"conn\", \"TI\"], \"]\"}]\) returns information about the schemas available through an SQL connection."
DatabaseLink`SQLSchemaNames::usage = "\!\(\*RowBox[{\"SQLSchemaNames\", \"[\", StyleBox[\"conn\", \"TI\"], \"]\"}]\) returns the names of the schema in an SQL connection."
DatabaseLink`SQLSelect::usage = "\!\(\*RowBox[{\"SQLSelect\", \"[\", RowBox[{StyleBox[\"conn\", \"TI\"], \",\", StyleBox[\"table\", \"TI\"]}], \"]\"}]\) extracts data from a table in an SQL connection. \n\!\(\*RowBox[{\"SQLSelect\", \"[\", RowBox[{StyleBox[\"conn\", \"TI\"], \",\", StyleBox[\"table\", \"TI\"], \",\", StyleBox[\"cols\", \"TI\"]}], \"]\"}]\) extracts data from particular columns.\n\!\(\*RowBox[{\"SQLSelect\", \"[\", RowBox[{StyleBox[\"conn\", \"TI\"], \",\", StyleBox[\"table\", \"TI\"], \",\", StyleBox[\"cols\", \"TI\"], \",\", StyleBox[\"cond\", \"TI\"]}], \"]\"}]\) only extracts data that matches \!\(\*StyleBox[\"cond\", \"TI\"]\)."
DatabaseLink`SQLServerInformation::usage = "\!\(\*RowBox[{\"SQLServerInformation\", \"[\", \"server\", \"]\"}]\) returns a list of information about the SQL server."
DatabaseLink`SQLServerLaunch::usage = "\!\(\*RowBox[{\"SQLServerLaunch\", \"[\", RowBox[{\"{\", RowBox[{RowBox[{StyleBox[\"name\", \"TI\"], \"->\", StyleBox[\"location\", \"TI\"]}], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \"]\"}]\) launches a database server that hosts access to the databases specified in the parameters."
DatabaseLink`SQLServer::usage = "\!\(\*RowBox[{\"SQLServer\", \"[\", StyleBox[\"args\", \"TI\"], \"]\"}]\) is an object that represents a server process started in \!\(\*StyleBox[\"Mathematica\", FontSlant -> Italic]\)."
DatabaseLink`SQLServerShutdown::usage = "\!\(\*RowBox[{\"SQLServerShutdown\", \"[\", StyleBox[\"server\", \"TI\"], \"]\"}]\) shuts down an active SQLServer started in \!\(\*StyleBox[\"Mathematica\", FontSlant -> \"Italic\"]\)."
DatabaseLink`SQLServers::usage = "\!\(\*RowBox[{\"SQLServers\", \"[\", \"]\"}]\) returns a list of the open SQLServer objects."
DatabaseLink`SQLSetSavepoint::usage = "\!\(\*RowBox[{\"SQLSetSavepoint\", \"[\", RowBox[{StyleBox[\"conn\", \"TI\"], \",\", StyleBox[\"name\", \"TI\"]}], \"]\"}]\) \!\(\*StyleBox[\"creates a savepoint to be used as part of an SQL transaction.\", \"Text\"]\)"
DatabaseLink`SQLStringMatchQ::usage = "\!\(\*RowBox[{\"SQLStringMatchQ\", \"[\", RowBox[{StyleBox[\"col\", \"TI\"], \",\", StyleBox[\"patt\", \"TI\"]}], \"]\"}]\) specifies a condition in an SQL query used to test whether the value of a column matches a pattern. The actual format for the pattern varies from one database to another."
DatabaseLink`SQLTableExportedKeys::usage = "\!\(\*RowBox[{\"SQLTableExportedKeys\", \"[\", StyleBox[\"conn\", \"TI\"], \"]\"}]\) returns a table of foreign key descriptions that reference the table's primary key."
DatabaseLink`SQLTableImportedKeys::usage = "\!\(\*RowBox[{\"SQLTableImportedKeys\", \"[\", StyleBox[\"conn\", \"TI\"], \"]\"}]\) returns a table of primary key descriptions that are referenced by the table's foreign key."
DatabaseLink`SQLTableIndexInformation::usage = "\!\(\*RowBox[{\"SQLTableIndexInformation\", \"[\", StyleBox[\"conn\", \"TI\"], \"]\"}]\) returns a table of indices and statistics for a table."
DatabaseLink`SQLTableInformation::usage = "\!\(\*RowBox[{\"SQLTableInformation\", \"[\", StyleBox[\"conn\", \"TI\"], \"]\"}]\) returns a list of information about the tables in an SQL connection. "
DatabaseLink`SQLTableNames::usage = "\!\(\*RowBox[{\"SQLTableNames\", \"[\", StyleBox[\"conn\", \"TI\"], \"]\"}]\) returns the names of each table in an SQL connection."
DatabaseLink`SQLTable::usage = "\!\(\*RowBox[{\"SQLTable\", \"[\", StyleBox[\"args\", \"TI\"], \"]\"}]\) represents a table in an SQL connection."
DatabaseLink`SQLTablePrimaryKeys::usage = "\!\(\*RowBox[{\"SQLTablePrimaryKeys\", \"[\", StyleBox[\"conn\", \"TI\"], \"]\"}]\) returns a table of primary key descriptions."
DatabaseLink`SQLTablePrivileges::usage = "\!\(\*RowBox[{\"SQLTablePrivileges\", \"[\", StyleBox[\"conn\", \"TI\"], \"]\"}]\) returns a table of access rights about the tables in an SQL connection."
DatabaseLink`SQLTables::usage = "\!\(\*RowBox[{\"SQLTables\", \"[\", StyleBox[\"conn\", \"TI\"], \"]\"}]\) returns the SQLTable objects for each table in an SQL connection."
DatabaseLink`SQLTableTypeNames::usage = "\!\(\*RowBox[{\"SQLTableTypeNames\", \"[\", StyleBox[\"conn\", \"TI\"], \"]\"}]\) returns the types of table supported in an SQL connection."
DatabaseLink`SQLUpdate::usage = "\!\(\*RowBox[{\"SQLUpdate\", \"[\", RowBox[{StyleBox[\"conn\", \"TI\"], \",\", StyleBox[\"table\", \"TI\"], \",\", StyleBox[\"cols\", \"TI\"], \",\", StyleBox[\"data\", \"TI\"]}], \"]\"}]\) updates data in a table in an SQL connection."
DatabaseLink`WriteDataSource::usage = "\!\(\*RowBox[{\"WriteDataSource\", \"[\", StyleBox[\"name\", \"TI\"], \"]\"}]\) writes a new HSQL data source \!\(\*StyleBox[\"name\", \"TI\"]\).\n\!\(\*RowBox[{\"WriteDataSource\", \"[\", RowBox[{StyleBox[\"name\", \"TI\"], \",\", StyleBox[\"database\", \"TI\"]}], \"]\"}]\) writes a new data source to \!\(\*StyleBox[\"database\", \"TI\"]\).\n\!\(\*RowBox[{\"WriteDataSource\", \"[\", RowBox[{StyleBox[\"name\", \"TI\"], \",\", StyleBox[\"opts\", \"TI\"]}], \"]\"}]\) writes a new data source with settings \!\(\*StyleBox[\"opts\", \"TI\"]\)\!\(\*StyleBox[\".\", FontSlant -> \"Italic\"]\)"
DatabaseLink`$DatabaseLinkDirectory::usage = "$DatabaseLinkDirectory gives the directory where \!\(\*StyleBox[\"DatabaseLink\", FontSlant -> \"Italic\"]\) is installed."
DatabaseLink`$SQLTimeout::usage = "$SQLTimeout gives the default time in seconds that \!\(\*StyleBox[\"DatabaseLink\", FontSlant -> \"Italic\"]\) waits while opening connections and executing database queries."
DatabaseLink`$SQLUseConnectionPool::usage = "$SQLUseConnectionPool gives the default setting that specifies whether a connection pool is used to retrieve a connection."
Developer`BesselSimplify::usage = "\!\(\*RowBox[{\"BesselSimplify\", \"[\", StyleBox[\"expr\", \"TI\"], \"]\"}]\) transforms Bessel functions in \!\(\*StyleBox[\"expr\", \"TI\"]\), trying to either decrease the number of Bessel functions, or convert Bessel functions into more elementary functions. "
Developer`BoundingBox::usage = "\!\(\*RowBox[{BoundingBox, \"[\", StyleBox[\"expr\", \"TI\"], \"]\"}]\) gives the absolute size in printer\[CloseCurlyQuote]s points of the bounding box for the displayed version of \!\(\*StyleBox[\"expr\", \"TI\"]\). \n\!\(\*RowBox[{BoundingBox, \"[\", RowBox[{StyleBox[\"expr\", \"TI\"], \",\", StyleBox[\"\\\"\\!\\(\\*StyleBox[\\\"env\\\",\\\"TI\\\"]\\)\\\"\", ShowStringCharacters->True]}], \"]\"}]\) gives the bounding box for the version obtained in the specified style environment. "
Developer`CellInformation::usage = "\!\(\*RowBox[{\"CellInformation\", \"[\", StyleBox[\"obj\", \"TI\"], \"]\"}]\) gives information about selected cells in the notebook represented by the notebook object \!\(\*StyleBox[\"obj\", \"TI\"]\). "
Developer`DefinitionList::usage = "\!\(\*RowBox[{\"DefinitionList\", \"[\", StyleBox[\"symbols\", \"TI\"], \"]\"}]\) gives a held list of all definitions given for a symbol. "
Developer`FibonacciSimplify::usage = "\!\(\*RowBox[{\"FibonacciSimplify\", \"[\", RowBox[{StyleBox[\"expr\", \"TI\"], \",\", StyleBox[\"assum\", \"TI\"]}], \"]\"}]\) tries to simplify combinations of symbolic Fibonacci numbers in \!\(\*StyleBox[\"expr\", \"TI\"]\) using assumptions \!\(\*StyleBox[\"assum\", \"TI\"]\). "
Developer`FindDivisions::usage = "\!\(\*RowBox[{\"FindDivisions\", \"[\", RowBox[{RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"min\", \"TI\"]], \",\", SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"max\", \"TI\"]]}], \"}\"}], \",\", StyleBox[\"n\", \"TI\"]}], \"]\"}]\) finds a list of about \!\(\*StyleBox[\"n\", \"TI\"]\) \[OpenCurlyDoubleQuote]nice\[CloseCurlyDoubleQuote] numbers that divide the interval around \!\(\*SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"min\", \"TI\"]]\) to \!\(\*SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"max\", \"TI\"]]\) into equally spaced parts. \n\!\(\*RowBox[{\"FindDivisions\", \"[\", RowBox[{RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"min\", \"TI\"]], \",\", SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"max\", \"TI\"]], \",\", StyleBox[\"dx\", \"TI\"]}], \"}\"}], \",\", StyleBox[\"n\", \"TI\"]}], \"]\"}]\) makes the parts always have lengths that are integer multiples of \!\(\*StyleBox[\"dx\", \"TI\"]\). \n\!\(\*RowBox[{\"FindDivisions\", \"[\", RowBox[{RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"min\", \"TI\"]], \",\", SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"max\", \"TI\"]]}], \"}\"}], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"n\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"n\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}]}], \"]\"}]\) finds successive subdivisions into about \!\(\*SubscriptBox[StyleBox[\"n\", \"TI\"], StyleBox[\"1\", \"TR\"]]\), \!\(\*SubscriptBox[StyleBox[\"n\", \"TI\"], StyleBox[\"2\", \"TR\"]]\), \[Ellipsis] parts. \n\!\(\*RowBox[{\"FindDivisions\", \"[\", RowBox[{RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"min\", \"TI\"]], \",\", SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"max\", \"TI\"]], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"dx\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"dx\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}]}], \"}\"}], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"n\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"n\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}]}], \"]\"}]\) uses spacings that are forced to be multiples of \!\(\*SubscriptBox[StyleBox[\"dx\", \"TI\"], StyleBox[\"1\", \"TR\"]]\), \!\(\*SubscriptBox[StyleBox[\"dx\", \"TI\"], StyleBox[\"2\", \"TR\"]]\), \[Ellipsis] . \n\!\(\*RowBox[{\"FindDivisions\", \"[\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"min\", \"TI\"]], \",\", SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"max\", \"TI\"]], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"dx\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"dx\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}]}], \"}\"}], \"]\"}]\) gives all numbers in the interval with spacings \!\(\*SubscriptBox[StyleBox[\"dx\", \"TI\"], StyleBox[\"i\", \"TI\"]]\). "
Developer`FromPackedArray::usage = "\!\(\*RowBox[{\"FromPackedArray\", \"[\", StyleBox[\"expr\", \"TI\"], \"]\"}]\) unpacks \!\(\*StyleBox[\"expr\", \"TI\"]\) so that its internal representation is not a packed array. "
Developer`GammaSimplify::usage = "\!\(\*RowBox[{\"GammaSimplify\", \"[\", StyleBox[\"expr\", \"TI\"], \"]\"}]\) transforms gamma functions in \!\(\*StyleBox[\"expr\", \"TI\"]\), trying to either decrease the number of gamma functions, or convert combinations of them into more elementary functions. "
Developer`MachineIntegerQ::usage = "\!\(\*RowBox[{\"MachineIntegerQ\", \"[\", StyleBox[\"expr\", \"TI\"], \"]\"}]\) returns True if \!\(\*StyleBox[\"expr\", \"TI\"]\) corresponds to a machine\[Hyphen]sized integer, and False otherwise. "
Developer`NotebookConvert::usage = "\!\(\*RowBox[{\"NotebookConvert\", \"[\", StyleBox[\"\\\"\\!\\(\\*StyleBox[\\\"name\\\",\\\"TI\\\"]\\)\\\"\", ShowStringCharacters->True], \"]\"}]\) converts a \!\(\*StyleBox[\"Mathematica\", FontSlant -> \"Italic\"]\) notebook from a previous version of \!\(\*StyleBox[\"Mathematica\", FontSlant -> \"Italic\"]\) to one for the current version."
Developer`PackedArrayForm::usage = "\!\(\*RowBox[{\"PackedArrayForm\", \"[\", StyleBox[\"expr\", \"TI\"], \"]\"}]\) prints with packed arrays in \!\(\*StyleBox[\"expr\", \"TI\"]\) shown in summary form, without all of their elements explicitly given. "
Developer`PackedArrayQ::usage = "\!\(\*RowBox[{\"PackedArrayQ\", \"[\", StyleBox[\"expr\", \"TI\"], \"]\"}]\) returns True if \!\(\*StyleBox[\"expr\", \"TI\"]\) is a packed array in its internal representation, and returns False otherwise. \n\!\(\*RowBox[{\"PackedArrayQ\", \"[\", RowBox[{StyleBox[\"expr\", \"TI\"], \",\", StyleBox[\"type\", \"TI\"]}], \"]\"}]\) returns True if \!\(\*StyleBox[\"expr\", \"TI\"]\) is a packed array of objects of the specified type. \n\!\(\*RowBox[{\"PackedArrayQ\", \"[\", RowBox[{StyleBox[\"expr\", \"TI\"], \",\", StyleBox[\"type\", \"TI\"], \",\", StyleBox[\"rank\", \"TI\"]}], \"]\"}]\) returns True if \!\(\*StyleBox[\"expr\", \"TI\"]\) is a packed array of the specified rank. "
Developer`PartitionMap::usage = "\!\(\*RowBox[{\"PartitionMap\", \"[\", RowBox[{StyleBox[\"f\", \"TI\"], \",\", StyleBox[\"list\", \"TI\"], \",\", StyleBox[\"n\", \"TI\"]}], \"]\"}]\) applies \!\(\*StyleBox[\"f\", \"TI\"]\) to \!\(\*StyleBox[\"list\", \"TI\"]\) after partitioning into non\[Hyphen]overlapping sublists of length \!\(\*StyleBox[\"n\", \"TI\"]\). \n\!\(\*RowBox[{\"PartitionMap\", \"[\", RowBox[{StyleBox[\"f\", \"TI\"], \",\", StyleBox[\"list\", \"TI\"], \",\", StyleBox[\"n\", \"TI\"], \",\", StyleBox[\"d\", \"TI\"]}], \"]\"}]\) applies \!\(\*StyleBox[\"f\", \"TI\"]\) to sublists obtained by partitioning with offset \!\(\*StyleBox[\"d\", \"TI\"]\). \n\!\(\*RowBox[{\"PartitionMap\", \"[\", RowBox[{StyleBox[\"f\", \"TI\"], \",\", StyleBox[\"list\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"n\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"n\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}]}], \"]\"}]\) applies \!\(\*StyleBox[\"f\", \"TI\"]\) after partitioning a nested list into blocks of size \!\(\*RowBox[{SubscriptBox[\"n\", \"1\"], \"\[Cross]\", SubscriptBox[\"n\", \"2\"], \"\[Cross]\", RowBox[{\"\[Ellipsis]\", \" \"}]}]\). \n\!\(\*RowBox[{\"PartitionMap\", \"[\", RowBox[{StyleBox[\"f\", \"TI\"], \",\", StyleBox[\"list\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"n\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"n\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"d\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"d\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}]}], \"]\"}]\) applies \!\(\*StyleBox[\"f\", \"TI\"]\) after partitioning using offset \!\(\*SubscriptBox[StyleBox[\"d\", \"TI\"], StyleBox[\"i\", \"TI\"]]\) at level \!\(\*StyleBox[\"i\", \"TI\"]\). \n\!\(\*RowBox[{\"PartitionMap\", \"[\", RowBox[{StyleBox[\"f\", \"TI\"], \",\", StyleBox[\"list\", \"TI\"], \",\", StyleBox[\"n\", \"TI\"], \",\", StyleBox[\"d\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"k\", \"TI\"], StyleBox[\"L\", \"TI\"]], \",\", SubscriptBox[StyleBox[\"k\", \"TI\"], StyleBox[\"R\", \"TI\"]]}], \"}\"}]}], \"]\"}]\) specifies where sublists should begin and end. \n\!\(\*RowBox[{\"PartitionMap\", \"[\", RowBox[{StyleBox[\"f\", \"TI\"], \",\", StyleBox[\"list\", \"TI\"], \",\", StyleBox[\"n\", \"TI\"], \",\", StyleBox[\"d\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"k\", \"TI\"], StyleBox[\"L\", \"TI\"]], \",\", SubscriptBox[StyleBox[\"k\", \"TI\"], StyleBox[\"R\", \"TI\"]]}], \"}\"}], \",\", StyleBox[\"padding\", \"TI\"]}], \"]\"}]\) specifies what padding should be used. "
Developer`PolyGammaSimplify::usage = "\!\(\*RowBox[{\"PolyGammaSimplify\", \"[\", StyleBox[\"expr\", \"TI\"], \"]\"}]\) transforms polygamma functions in \!\(\*StyleBox[\"expr\", \"TI\"]\), trying to either decrease the number of polygamma functions, or convert combinations of them into more elementary functions. "
Developer`PolyLogSimplify::usage = "\!\(\*RowBox[{\"PolyLogSimplify\", \"[\", StyleBox[\"expr\", \"TI\"], \"]\"}]\) transforms polylogarithm functions in \!\(\*StyleBox[\"expr\", \"TI\"]\), trying to either decrease the number of polylogarithm functions, or convert combinations of them into more elementary functions. "
Developer`ReplaceAllUnheld::usage = "\!\(\*RowBox[{\"ReplaceAllUnheld\", \"[\", RowBox[{StyleBox[\"expr\", \"TI\"], \",\", StyleBox[\"rules\", \"TI\"]}], \"]\"}]\) applies a rule or list of rules in an attempt to transform each subpart of \!\(\*StyleBox[\"expr\", \"TI\"]\) that would be automatically evaluated. "
Developer`ToPackedArray::usage = "\!\(\*RowBox[{\"ToPackedArray\", \"[\", StyleBox[\"expr\", \"TI\"], \"]\"}]\) uses packed arrays if possible in the internal representation of \!\(\*StyleBox[\"expr\", \"TI\"]\). "
Developer`TrigToRadicals::usage = "\!\(\*RowBox[{\"TrigToRadicals\", \"[\", StyleBox[\"expr\", \"TI\"], \"]\"}]\) converts trigonometric functions to radicals whenever possible in \!\(\*StyleBox[\"expr\", \"TI\"]\). "
Developer`ZeroQ::usage = "\!\(\*RowBox[{\"ZeroQ\", \"[\", StyleBox[\"expr\", \"TI\"], \"]\"}]\) returns True if built\[Hyphen]in transformations allow it to be determined that \!\(\*StyleBox[\"expr\", \"TI\"]\) is numerically equal to zero, and returns False otherwise. "
Developer`ZetaSimplify::usage = "\!\(\*RowBox[{\"ZetaSimplify\", \"[\", StyleBox[\"expr\", \"TI\"], \"]\"}]\) transforms zeta functions in \!\(\*StyleBox[\"expr\", \"TI\"]\), trying to either decrease the number of zeta functions, or convert combinations of them into more elementary functions. "
Developer`$MaxMachineInteger::usage = "$MaxMachineInteger gives the maximum integer that is represented internally as a single atomic data element on your computer system. "
EquationTrekker`DifferentialEquationTrek::usage = "DifferentialEquationTrek is a setting for the option TrekGenerator that specifies that treks are generated from the phase space of the numerical solution of a differential equation."
EquationTrekker`EquationTrekker::usage = "\!\(\*RowBox[{\"EquationTrekker\", \"[\", RowBox[{StyleBox[\"eqn\", \"TI\"], \",\", StyleBox[\"x\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{StyleBox[\"t\", \"TI\"], \",\", SubscriptBox[StyleBox[\"t\", \"TI\"], StyleBox[\"min\", \"TI\"]], \",\", SubscriptBox[StyleBox[\"t\", \"TI\"], StyleBox[\"max\", \"TI\"]]}], \"}\"}]}], \"]\"}]\) opens a graphical interface for specifying initial conditions and plotting the resulting numerical solution to the first or second order ordinary differential equation \!\(\*StyleBox[\"eqn\", \"TI\"]\) for the function \!\(\*StyleBox[\"x\", \"TI\"]\) with the independent variable \!\(\*StyleBox[\"t\", \"TI\"]\) in the range \!\(\*SubscriptBox[StyleBox[\"t\", \"TI\"], StyleBox[\"min\", \"TI\"]]\) to \!\(\*SubscriptBox[StyleBox[\"t\", \"TI\"], StyleBox[\"max\", \"TI\"]]\).\n\!\(\*RowBox[{\"EquationTrekker\", \"[\", RowBox[{StyleBox[\"eqns\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"y\", \"TI\"]}], \"}\"}], \",\", RowBox[{\"{\", RowBox[{StyleBox[\"t\", \"TI\"], \",\", SubscriptBox[StyleBox[\"t\", \"TI\"], StyleBox[\"min\", \"TI\"]], \",\", SubscriptBox[StyleBox[\"t\", \"TI\"], StyleBox[\"max\", \"TI\"]]}], \"}\"}]}], \"]\"}]\) opens a graphical interface for specifying initial conditions and plotting the resulting numerical solution to the system of two first order ordinary differential equations \!\(\*StyleBox[\"eqns\", \"TI\"]\) for the functions \!\(\*StyleBox[\"x\", \"TI\"]\) and \!\(\*StyleBox[\"y\", \"TI\"]\).\n\!\(\*RowBox[{\"EquationTrekker\", \"[\", StyleBox[\"state\", \"TI\"], \"]\"}]\) reopens a graphical interface with the treks saved in the EquationTrekkerState object \!\(\*StyleBox[\"state\", \"TI\"]\)."
EquationTrekker`EquationTrekkerNonModal::usage = "EquationTrekkerNonModal is the non\[Dash]modal dialog version of EquationTrekker."
EquationTrekker`EquationTrekkerState::usage = "\!\(\*RowBox[{\"EquationTrekkerState\", \"[\", RowBox[{RowBox[{\"{\", RowBox[{StyleBox[\"eqns\", \"TI\"], \",\", StyleBox[\"dvars\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{StyleBox[\"t\", \"TI\"], \",\", SubscriptBox[StyleBox[\"t\", \"TI\"], StyleBox[\"min\", \"TI\"]], \",\", SubscriptBox[StyleBox[\"t\", \"TI\"], StyleBox[\"max\", \"TI\"]]}], \"}\"}]}], \"}\"}], \",\", StyleBox[\"params\", \"TI\"], \",\", StyleBox[\"treks\", \"TI\"], \",\", StyleBox[\"opts\", \"TI\"]}], \"]\"}]\) is the data object returned by the function EquationTrekker, that contains the information needed to restore the graphical interface to the state it was in when the EquationTrekker window was closed."
EquationTrekker`InitializeGenerator::usage = "\!\(\*RowBox[{\"InitializeGenerator\", \"[\", RowBox[{StyleBox[\"gen\", \"TI\"], \",\", StyleBox[\"problem\", \"TI\"], \",\", StyleBox[\"dvars\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{StyleBox[\"t\", \"TI\"], \",\", SubscriptBox[StyleBox[\"t\", \"TI\"], StyleBox[\"min\", \"TI\"]], \",\", SubscriptBox[StyleBox[\"t\", \"TI\"], StyleBox[\"max\", \"TI\"]]}], \"}\"}], \",\", StyleBox[\"opts\", \"TI\"]}], \"]\"}]\) returns the trek generator \!\(\*RowBox[{StyleBox[\"gen\", \"TI\"], \"[\", StyleBox[\"data\", \"TI\"], \"]\"}]\) when called by EquationTrekker. The specific form of \!\(\*StyleBox[\"data\", \"TI\"]\) depends on the trek generator \!\(\*StyleBox[\"gen\", \"TI\"]\).\n\!\(\*RowBox[{\"IntializeGenerator\", \"[\", RowBox[{StyleBox[\"gen\", \"TI\"], \",\", StyleBox[\"problem\", \"TI\"], \",\", StyleBox[\"dvars\", \"TI\"], \",\", StyleBox[\"opts\", \"TI\"]}], \"]\"}]\) returns a trek generator which does not use an independent variable."
EquationTrekker`PoincareSection::usage = "PoincareSection is a setting for the option TrekGenerator that specifies that the Poincare section for differential equations is used to generate treks."
EquationTrekker`TrekData::usage = "\!\(\*RowBox[{\"TrekData\", \"[\", RowBox[{StyleBox[\"tag\", \"TI\"], \",\", StyleBox[\"data\", \"TI\"]}], \"]\"}]\) is a data object that contains the information necessary to recreate the trek associated with the tag \!\(\*StyleBox[\"tag\", \"TI\"]\) in a graphical interface created by EquationTrekker."
EquationTrekker`TrekGenerator::usage = "TrekGenerator is an option to EquationTrekker that specifies the method used to generate treks."
EquationTrekker`TrekParameters::usage = "TrekParameters is an option to EquationTrekker that specifies the dynamic parameters and their ranges."
ErrorBarPlots`ErrorBarFunction::usage = "ErrorBarFunction is an option for ErrorListPlot that specifies a function to apply to determine the shape of error bars. "
ErrorBarPlots`ErrorBar::usage = "\!\(\*RowBox[{RowBox[{\"ErrorBar\", \"[\", \"{\"}], StyleBox[\"negerror\", \"TI\"], \",\", StyleBox[\"poserror\", \"TI\"], RowBox[{\"}\", \"]\"}]}]\) error in the positive and negative directions.\n\!\(\*RowBox[{\"ErrorBar\", \"[\", StyleBox[\"yerr\", \"TI\"], \"]\"}]\) error \!\(\*StyleBox[\"yerr\", \"TI\"]\) in both the positive and negative directions\n\!\(\*RowBox[{\"ErrorBar\", \"[\", RowBox[{StyleBox[\"xerr\", \"TI\"], \",\", StyleBox[\"yerr\", \"TI\"]}], \"]\"}]\) errors specified for both the x and the y coordinates"
ErrorBarPlots`ErrorListPlot::usage = "\!\(\*RowBox[{\"ErrorListPlot\", \"[\", RowBox[{\"{\", RowBox[{RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"y\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"dy\", \"TI\"], StyleBox[\"1\", \"TR\"]]}], \"}\"}], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"y\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"dy\", \"TI\"], StyleBox[\"2\", \"TR\"]]}], \"}\"}], \",\", StyleBox[\"\[Ellipsis]\", \"TI\"]}], \"}\"}], \"]\"}]\) plots points corresponding to a list of values \!\(\*RowBox[{SubscriptBox[StyleBox[\"y\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", \" \", SubscriptBox[StyleBox[\"y\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", \" \", StyleBox[\"\[Ellipsis]\", \"TR\"]}]\), with corresponding error bars. The errors have magnitudes \!\(\*RowBox[{SubscriptBox[StyleBox[\"dy\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"dy\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}]\).\n\!\(\*RowBox[{\"ErrorListPlot\", \"[\", RowBox[{\"{\", RowBox[{RowBox[{\"{\", RowBox[{RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"y\", \"TI\"], StyleBox[\"1\", \"TR\"]]}], \"}\"}], \",\", RowBox[{\"ErrorBar\", \"[\", SubscriptBox[StyleBox[\"err\", \"TI\"], \"1\"], \"]\"}]}], \"}\"}], \",\", RowBox[{\"{\", RowBox[{RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"y\", \"TI\"], StyleBox[\"2\", \"TR\"]]}], \"}\"}], \",\", RowBox[{\"ErrorBar\", \"[\", SubscriptBox[StyleBox[\"err\", \"TI\"], StyleBox[\"2\", \"TR\"]], \"]\"}]}], \"}\"}], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \"]\"}]\) plots points with specified \!\(\*StyleBox[\"x\", \"TI\"]\) and \!\(\*StyleBox[\"y\", \"TI\"]\) coordinates and error magnitudes."
Experimental`AsynchronousEvaluate::usage = "\!\(\*RowBox[{\"Monitor\", \"[\", RowBox[{StyleBox[\"expr\", \"TI\"], \",\", StyleBox[\"mon\", \"TI\"], \",\", StyleBox[\"t\", \"TI\"]}], \"]\"}]\) evaluates \!\(\*StyleBox[\"expr\", \"TI\"]\), every \!\(\*StyleBox[\"t\", \"TI\"]\) seconds evaluating \!\(\*StyleBox[\"mon\", \"TI\"]\). \n\!\(\*RowBox[{\"Monitor\", \"[\", RowBox[{StyleBox[\"expr\", \"TI\"], \",\", StyleBox[\"mon\", \"TI\"], \",\", StyleBox[\"t\", \"TI\"], \",\", StyleBox[\"n\", \"TI\"]}], \"]\"}]\) evaluates \!\(\*StyleBox[\"mon\", \"TI\"]\) at most \!\(\*StyleBox[\"n\", \"TI\"]\) times. "
Experimental`CompileEvaluate::usage = "\!\(\*RowBox[{\"CompileEvaluate\", \"[\", StyleBox[\"expr\", \"TI\"], \"]\"}]\) compiles \!\(\*StyleBox[\"expr\", \"TI\"]\) and then evaluates the resulting compiled code. "
Experimental`ExistsRealQ::usage = "\!\(\*RowBox[{\"ExistsRealQ\", \"[\", RowBox[{StyleBox[\"ineqs\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}]}], \"]\"}]\) tests whether there exist real values of the \!\(\*SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"i\", \"TI\"]]\) for which the inequalities and equations \!\(\*StyleBox[\"ineqs\", \"TI\"]\) are satisfied. "
Experimental`ForAllRealQ::usage = "\!\(\*RowBox[{\"ForAllRealQ\", \"[\", RowBox[{StyleBox[\"ineqs\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}]}], \"]\"}]\) tests whether for all real values of the \!\(\*SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"i\", \"TI\"]]\) the inequalities and equations \!\(\*StyleBox[\"ineqs\", \"TI\"]\) are satisfied. "
Experimental`ImpliesQ::usage = "\!\(\*RowBox[{\"ImpliesQ\", \"[\", RowBox[{SubscriptBox[StyleBox[\"expr\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"expr\", \"TI\"], StyleBox[\"2\", \"TR\"]]}], \"]\"}]\) tests whether the expression \!\(\*SubscriptBox[StyleBox[\"expr\", \"TI\"], StyleBox[\"1\", \"TR\"]]\) implies \!\(\*SubscriptBox[StyleBox[\"expr\", \"TI\"], StyleBox[\"2\", \"TR\"]]\). "
Experimental`ImpliesRealQ::usage = "\!\(\*RowBox[{\"ImpliesRealQ\", \"[\", RowBox[{SubscriptBox[StyleBox[\"ineqs\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"ineqs\", \"TI\"], StyleBox[\"2\", \"TR\"]]}], \"]\"}]\) tests whether the inequalities and equations \!\(\*SubscriptBox[StyleBox[\"ineqs\", \"TI\"], StyleBox[\"1\", \"TR\"]]\) imply the \!\(\*SubscriptBox[StyleBox[\"ineqs\", \"TI\"], StyleBox[\"2\", \"TR\"]]\) for all real values of all variables. "
Experimental`ValueFunction::usage = "\!\(\*RowBox[{\"ValueFunction\", \"[\", StyleBox[\"symb\", \"TI\"], \"]\"}]\) represents a function to be applied whenever the symbol \!\(\*StyleBox[\"symb\", \"TI\"]\) gets a new value. "
FiniteFields`Characteristic::usage = "\!\(\*RowBox[{\"Characteristic\", \"[\", StyleBox[\"f\", \"TI\"], \"]\"}]\) gives the characteristic of the field \!\(\*StyleBox[\"f\", \"TI\"]\)."
FiniteFields`ElementToPolynomial::usage = "\!\(\*RowBox[{\"ElementToPolynomial\", \"[\", RowBox[{StyleBox[\"e\", \"TI\"], \",\", StyleBox[\"s\", \"TI\"]}], \"]\"}]\) gives a polynomial in the symbol \!\(\*StyleBox[\"s\", \"TI\"]\) corresponding to the field element \!\(\*StyleBox[\"e\", \"TI\"]\).\n\!\(\*RowBox[{\"ElementToPolynomial\", \"[\", RowBox[{StyleBox[\"f\", \"TI\"], \",\", StyleBox[\"s\", \"TI\"]}], \"]\"}]\) gives the irreducible polynomial in \!\(\*StyleBox[\"s\", \"TI\"]\) of the field \!\(\*StyleBox[\"f\", \"TI\"]\)."
FiniteFields`ExtensionDegree::usage = "\!\(\*RowBox[{\"ExtensionDegree\", \"[\", StyleBox[\"f\", \"TI\"], \"]\"}]\) gives the degree of the extension of the field \!\(\*StyleBox[\"f\", \"TI\"]\) over its base field."
FiniteFields`FieldExp::usage = "\!\(\*RowBox[{\"FieldExp\", \"[\", RowBox[{StyleBox[\"f\", \"TI\"], \",\", StyleBox[\"n\", \"TI\"]}], \"]\"}]\) gives the value of the discrete exponential of \!\(\*StyleBox[\"n\", \"TI\"]\) associated with the field \!\(\*StyleBox[\"f\", \"TI\"]\)."
FiniteFields`FieldInd::usage = "\!\(\*RowBox[{\"FieldInd\", \"[\", StyleBox[\"e\", \"TI\"], \"]\"}]\) gives the value of the discrete logarithm of \!\(\*StyleBox[\"e\", \"TI\"]\)."
FiniteFields`FieldIrreducible::usage = "\!\(\*RowBox[{\"FieldIrreducible\", \"[\", RowBox[{StyleBox[\"f\", \"TI\"], \",\", StyleBox[\"s\", \"TI\"]}], \"]\"}]\) gives the irreducible polynomial in the symbol \!\(\*StyleBox[\"s\", \"TI\"]\) associated with the field \!\(\*StyleBox[\"f\", \"TI\"]\)."
FiniteFields`FromElementCode::usage = "\!\(\*RowBox[{\"FromElementCode\", \"[\", RowBox[{StyleBox[\"f\", \"TI\"], \",\", StyleBox[\"code\", \"TI\"]}], \"]\"}]\) gives the field element of \!\(\*StyleBox[\"f\", \"TI\"]\) associated with \!\(\*StyleBox[\"code\", \"TI\"]\), a non-negative integer less than the field size of \!\(\*StyleBox[\"f\", \"TI\"]\)."
FiniteFields`FunctionOfCode::usage = "\!\(\*RowBox[{\"FunctionOfCode\", \"[\", StyleBox[\"g\", \"TI\"], \"]\"}]\) is a setting for the option FormatType that specifies the format \!\(\*RowBox[{StyleBox[\"g\", \"TI\"], \"[\", StyleBox[\"c\", \"TI\"], \"]\"}]\) for an element, where \!\(\*StyleBox[\"c\", \"TI\"]\) is the integer code for the element."
FiniteFields`FunctionOfCoefficients::usage = "\!\(\*RowBox[{\"FunctionOfCoefficients\", \"[\", StyleBox[\"g\", \"TI\"], \"]\"}]\) is a setting for the option FormatType that specifies the format \!\(\*RowBox[{StyleBox[\"g\", \"TI\"], \"[\", RowBox[{SubscriptBox[StyleBox[\"c\", \"TI\"], StyleBox[\"0\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"c\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) for an element, where \!\(\*RowBox[{SubscriptBox[StyleBox[\"c\", \"TI\"], StyleBox[\"0\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"c\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}]\) are the coefficients in the polynomial representation of the element."
FiniteFields`GF::usage = "\!\(\*RowBox[{\"GF\", \"[\", RowBox[{StyleBox[\"p\", \"TI\"], \",\", StyleBox[\"d\", \"TI\"]}], \"]\"}]\) gives the Galois field that is a degree \!\(\*StyleBox[\"d\", \"TI\"]\) extension of the prime field of \!\(\*StyleBox[\"p\", \"TI\"]\) elements.\n\!\(\*RowBox[{\"GF\", \"[\", StyleBox[\"q\", \"TI\"], \"]\"}]\) gives, for \!\(\*StyleBox[\"q\", \"TI\"]\) a prime power, the Galois field with \!\(\*StyleBox[\"q\", \"TI\"]\) elements.\n\!\(\*RowBox[{\"GF\", \"[\", RowBox[{StyleBox[\"p\", \"TI\"], \",\", StyleBox[\"ilist\", \"TI\"]}], StyleBox[\"]\", \"TI\"]}]\) represents the Galois field with prime characteristic \!\(\*StyleBox[\"p\", \"TI\"]\) and irreducible polynomial whose coefficient list is given by \!\(\*StyleBox[\"ilist\", \"TI\"]\).\n\!\(\*RowBox[{RowBox[{\"GF\", \"[\", RowBox[{StyleBox[\"p\", \"TI\"], \",\", StyleBox[\"ilist\", \"TI\"]}], \"]\"}], \"[\", StyleBox[\"elist\", \"TI\"], \"]\"}]\) represents an element of the Galois field \!\(\*RowBox[{\"GF\", \"[\", RowBox[{StyleBox[\"p\", \"TI\"], \",\", StyleBox[\"ilist\", \"TI\"]}], \"]\"}]\) whose polynomial representation has coefficient list \!\(\*StyleBox[\"elist\", \"TI\"]\)."
FiniteFields`IrreduciblePolynomial::usage = "\!\(\*RowBox[{\"IrreduciblePolynomial\", \"[\", RowBox[{StyleBox[\"s\", \"TI\"], \",\", StyleBox[\"p\", \"TI\"], \",\", StyleBox[\"d\", \"TI\"]}], \"]\"}]\) gives an irreducible polynomial in the symbol \!\(\*StyleBox[\"s\", \"TI\"]\) of degree \!\(\*StyleBox[\"d\", \"TI\"]\) over the integers modulo the prime \!\(\*StyleBox[\"p\", \"TI\"]\)."
FiniteFields`PerfectPowerQ::usage = "\!\(\*RowBox[{\"PerfectPowerQ\", \"[\", RowBox[{StyleBox[\"e\", \"TI\"], \",\", StyleBox[\"n\", \"TI\"]}], \"]\"}]\) gives True if \!\(\*StyleBox[\"e\", \"TI\"]\) is a perfect \!\(\*SuperscriptBox[StyleBox[\"n\", \"TI\"], \"th\"]\) power in its field, and False otherwise."
FiniteFields`PolynomialToElement::usage = "\!\(\*RowBox[{\"PolynomialToElement\", \"[\", RowBox[{StyleBox[\"f\", \"TI\"], \",\", StyleBox[\"poly\", \"TI\"]}], \"]\"}]\) gives an element in the field \!\(\*StyleBox[\"f\", \"TI\"]\) corresponding to the univariate polynomial \!\(\*StyleBox[\"poly\", \"TI\"]\) with integer coefficients."
FiniteFields`PowerList::usage = "\!\(\*RowBox[{\"PowerList\", \"[\", StyleBox[\"f\", \"TI\"], \"]\"}]\) gives a list of the data parts of the nonzero elements of the field \!\(\*StyleBox[\"f\", \"TI\"]\)."
FiniteFields`PowerListQ::usage = "\!\(\*RowBox[{\"PowerListQ\", \"[\", StyleBox[\"f\", \"TI\"], \"]\"}]\) gives True if the list representing the powers of a primitive element of the field is used to do field arithmetic, and False otherwise."
FiniteFields`PowerListToField::usage = "\!\(\*RowBox[{\"PowerListToField\", \"[\", StyleBox[\"list\", \"TI\"], \"]\"}]\) gives the field associated with list of element data parts \!\(\*StyleBox[\"list\", \"TI\"]\), where the elements are generated by successive powers of a primitive element."
FiniteFields`ReduceElement::usage = "\!\(\*RowBox[{\"ReduceElement\", \"[\", StyleBox[\"e\", \"TI\"], \"]\"}]\) gives a field element in reduced form."
FiniteFields`SetFieldFormat::usage = "\!\(\*RowBox[{\"SetFieldFormat\", \"[\", StyleBox[\"f\", \"TI\"], \"]\"}]\) sets the output form of elements in the field \!\(\*StyleBox[\"f\", \"TI\"]\)."
FiniteFields`Successor::usage = "\!\(\*RowBox[{\"Successor\", \"[\", StyleBox[\"e\", \"TI\"], \"]\"}]\) gives the next element in a canonical ordering of the field elements."
FiniteFields`ToElementCode::usage = "\!\(\*RowBox[{\"ToElementCode\", \"[\", StyleBox[\"e\", \"TI\"], \"]\"}]\) gives a nonnegative integer code, less than the field size, associated with the element \!\(\*StyleBox[\"e\", \"TI\"]\)."
FourierSeries`DTFourierTransform::usage = "\!\(\*RowBox[{\"DTFourierTransform\", \"[\", RowBox[{StyleBox[\"expr\", \"TI\"], \",\", StyleBox[\"n\", \"TI\"], \",\", StyleBox[\"\[Omega]\", \"TR\"]}], \"]\"}]\) gives the discrete time Fourier transform of \!\(\*StyleBox[\"expr\", \"TI\"]\) as a function of \!\(\*StyleBox[\"\[Omega]\", \"TR\"]\), where \!\(\*StyleBox[\"expr\", \"TI\"]\) is a function of \!\(\*StyleBox[\"n\", \"TI\"]\)."
FourierSeries`InverseDTFourierTransform::usage = "\!\(\*RowBox[{\"InverseDTFourierTransform\", \"[\", RowBox[{StyleBox[\"expr\", \"TI\"], \",\", StyleBox[\"\[Omega]\", \"TR\"], \",\", StyleBox[\"n\", \"TI\"]}], \"]\"}]\) gives the inverse discrete time Fourier transform of \!\(\*StyleBox[\"expr\", \"TI\"]\), where \!\(\*StyleBox[\"expr\", \"TI\"]\) is a periodic function of \!\(\*StyleBox[\"\[Omega]\", \"TR\"]\) with period 1."
FourierSeries`InverseFourierCoefficient::usage = "\!\(\*RowBox[{\"InverseFourierCoefficient\", \"[\", RowBox[{StyleBox[\"expr\", \"TI\"], \",\", StyleBox[\"n\", \"TI\"], \",\", StyleBox[\"t\", \"TI\"]}], \"]\"}]\) gives the function of \!\(\*StyleBox[\"t\", \"TI\"]\) whose Fourier exponential series representation has coefficients given by \!\(\*StyleBox[\"expr\", \"TI\"]\), where \!\(\*StyleBox[\"expr\", \"TI\"]\) is a function of \!\(\*StyleBox[\"n\", \"TI\"]\)."
FourierSeries`NDTFourierTransform::usage = "\!\(\*RowBox[{\"NDTFourierTransform\", \"[\", RowBox[{StyleBox[\"expr\", \"TI\"], \",\", StyleBox[\"n\", \"TI\"], \",\", StyleBox[\"\[Omega]\", \"TI\"]}], \"]\"}]\) gives a numerical approximation to the discrete time Fourier transform of \!\(\*StyleBox[\"expr\", \"TI\"]\) evaluated at the numerical value \!\(\*StyleBox[\"\[Omega]\", \"TR\"]\), where \!\(\*StyleBox[\"expr\", \"TI\"]\) is a function of \!\(\*StyleBox[\"n\", \"TI\"]\)."
FourierSeries`NFourierCoefficient::usage = "\!\(\*RowBox[{\"NFourierCoefficient\", \"[\", RowBox[{StyleBox[\"expr\", \"TI\"], \",\", StyleBox[\"t\", \"TI\"], \",\", StyleBox[\"n\", \"TI\"]}], \"]\"}]\) gives a numerical approximation to the \!\(\*SuperscriptBox[StyleBox[\"n\", \"TI\"], \"th\"]\) coefficient in the Fourier exponential series expansion of \!\(\*StyleBox[\"expr\", \"TI\"]\), where \!\(\*StyleBox[\"expr\", \"TI\"]\) is a periodic function of \!\(\*StyleBox[\"t\", \"TI\"]\) with period \!\(\*StyleBox[\"2 \[Pi]\", \"TR\"]\)."
FourierSeries`NFourierCosCoefficient::usage = "\!\(\*RowBox[{\"NFourierCosCoefficient\", \"[\", RowBox[{StyleBox[\"expr\", \"TI\"], \",\", StyleBox[\"t\", \"TI\"], \",\", StyleBox[\"n\", \"TI\"]}], \"]\"}]\) gives a numerical approximation to the \!\(\*SuperscriptBox[StyleBox[\"n\", \"TI\"], \"th\"]\) coefficient in the Fourier cosine series expansion of \!\(\*StyleBox[\"expr\", \"TI\"]\), where \!\(\*StyleBox[\"expr\", \"TI\"]\) is a periodic function of \!\(\*StyleBox[\"t\", \"TI\"]\) with period \!\(\*StyleBox[\"2 \[Pi]\", \"TR\"]\)."
FourierSeries`NFourierCosTransform::usage = "\!\(\*RowBox[{\"NFourierCosTransform\", \"[\", RowBox[{StyleBox[\"expr\", \"TI\"], \",\", StyleBox[\"t\", \"TI\"], \",\", StyleBox[\"\[Omega]\", \"TR\"]}], \"]\"}]\) gives a numerical approximation to the Fourier cosine transform of \!\(\*StyleBox[\"expr\", \"TI\"]\) evaluated at the numerical value \!\(\*StyleBox[\"\[Omega]\", \"TR\"]\), where \!\(\*StyleBox[\"expr\", \"TI\"]\) is a function of \!\(\*StyleBox[\"n\", \"TI\"]\)."
FourierSeries`NFourierSeries::usage = "\!\(\*RowBox[{\"NFourierSeries\", \"[\", RowBox[{StyleBox[\"expr\", \"TI\"], \",\", StyleBox[\"t\", \"TI\"], \",\", StyleBox[\"n\", \"TI\"]}], \"]\"}]\) gives a numerical approximation to the order \!\(\*StyleBox[\"n\", \"TI\"]\) Fourier exponential series expansion of \!\(\*StyleBox[\"expr\", \"TI\"]\), where \!\(\*StyleBox[\"expr\", \"TI\"]\) is a periodic function of \!\(\*StyleBox[\"t\", \"TI\"]\) with period \!\(\*StyleBox[\"2 \[Pi]\", \"TR\"]\).."
FourierSeries`NFourierSinCoefficient::usage = "\!\(\*RowBox[{\"NFourierSinCoefficient\", \"[\", RowBox[{StyleBox[\"expr\", \"TI\"], \",\", StyleBox[\"t\", \"TI\"], \",\", StyleBox[\"n\", \"TI\"]}], \"]\"}]\) gives a numerical approximation to the \!\(\*SuperscriptBox[StyleBox[\"n\", \"TI\"], \"th\"]\) coefficient in the Fourier sine series expansion of \!\(\*StyleBox[\"expr\", \"TI\"]\), where \!\(\*StyleBox[\"expr\", \"TI\"]\) is a periodic function of \!\(\*StyleBox[\"t\", \"TI\"]\) with period \!\(\*StyleBox[\"2 \[Pi]\", \"TR\"]\)."
FourierSeries`NFourierSinTransform::usage = "\!\(\*RowBox[{\"NFourierSinTransform\", \"[\", RowBox[{StyleBox[\"expr\", \"TI\"], \",\", StyleBox[\"t\", \"TI\"], \",\", StyleBox[\"\[Omega]\", \"TR\"]}], \"]\"}]\) gives a numerical approximation to the Fourier sine transform of \!\(\*StyleBox[\"expr\", \"TI\"]\) evaluated at the numerical value \!\(\*StyleBox[\"\[Omega]\", \"TR\"]\), where \!\(\*StyleBox[\"expr\", \"TI\"]\) is a function of \!\(\*StyleBox[\"n\", \"TI\"]\)."
FourierSeries`NFourierTransform::usage = "\!\(\*RowBox[{RowBox[{\"NFourierTransform\", \"[\"}], StyleBox[\"expr\", \"TI\"], \",\", StyleBox[\"t\", \"TI\"], \",\", StyleBox[\"w\", \"TI\"], \"]\"}]\) gives a numerical approximation to the Fourier transform of \!\(\*StyleBox[\"expr\", \"TI\"]\) evaluated at the numerical value \!\(\*StyleBox[\"\[Omega]\", \"TR\"]\), where \!\(\*StyleBox[\"expr\", \"TI\"]\) is a function of \!\(\*StyleBox[\"t\", \"TI\"]\)."
FourierSeries`NFourierTrigSeries::usage = "\!\(\*RowBox[{RowBox[{\"NFourierTrigSeries\", \"[\"}], StyleBox[\"expr\", \"TI\"], \",\", StyleBox[\"t\", \"TI\"], \",\", StyleBox[\"k\", \"TI\"], \"]\"}]\) gives a numerical approximation to the order \!\(\*StyleBox[\"n\", \"TI\"]\) Fourier trigonometric series expansion of \!\(\*StyleBox[\"expr\", \"TI\"]\), where \!\(\*StyleBox[\"expr\", \"TI\"]\) is a periodic function of \!\(\*StyleBox[\"t\", \"TI\"]\) with period \!\(\*StyleBox[\"2 \[Pi]\", \"TR\"]\).."
FourierSeries`NInverseDTFourierTransform::usage = "\!\(\*RowBox[{\"NInverseDTFourierTransform\", \"[\", RowBox[{StyleBox[\"expr\", \"TI\"], \",\", StyleBox[\"\[Omega]\", \"TR\"], \",\", StyleBox[\"n\", \"TI\"]}], \"]\"}]\) gives a numerical approximation to the inverse discrete time Fourier transform of \!\(\*StyleBox[\"expr\", \"TI\"]\) evaluated at the integer \!\(\*StyleBox[\"n\", \"TI\"]\), where \!\(\*StyleBox[\"expr\", \"TI\"]\) is a periodic function of \!\(\*StyleBox[\"\[Omega]\", \"TR\"]\) with period 1."
FourierSeries`NInverseFourierCoefficient::usage = "\!\(\*RowBox[{\"NInverseFourierCoefficient\", \"[\", RowBox[{StyleBox[\"expr\", \"TI\"], \",\", StyleBox[\"n\", \"TI\"], \",\", StyleBox[\"t\", \"TI\"]}], \"]\"}]\) gives a numerical approximation to the function, evaluated at \!\(\*StyleBox[\"t\", \"TI\"]\), whose Fourier exponential series representation has coefficients given by \!\(\*StyleBox[\"expr\", \"TI\"]\), where \!\(\*StyleBox[\"expr\", \"TI\"]\) is a function of \!\(\*StyleBox[\"n\", \"TI\"]\)."
FourierSeries`NInverseFourierCosTransform::usage = "\!\(\*RowBox[{\"NInverseFourierCosTransform\", \"[\", RowBox[{StyleBox[\"expr\", \"TI\"], \",\", StyleBox[\"\[Omega]\", \"TR\"], \",\", StyleBox[\"t\", \"TI\"]}], \"]\"}]\) gives a numerical approximation to the inverse Fourier cosine transform of \!\(\*StyleBox[\"expr\", \"TI\"]\) evaluated at the numerical value \!\(\*StyleBox[\"t\", \"TI\"]\), where \!\(\*StyleBox[\"expr\", \"TI\"]\) is a function of \!\(\*StyleBox[\"\[Omega]\", \"TR\"]\)."
FourierSeries`NInverseFourierSinTransform::usage = "\!\(\*RowBox[{\"NInverseFourierSinTransform\", \"[\", RowBox[{StyleBox[\"expr\", \"TI\"], \",\", StyleBox[\"\[Omega]\", \"TR\"], \",\", StyleBox[\"t\", \"TI\"]}], \"]\"}]\) gives a numerical approximation to the inverse Fourier sine transform of \!\(\*StyleBox[\"expr\", \"TI\"]\) evaluated at the numerical value \!\(\*StyleBox[\"t\", \"TI\"]\), where \!\(\*StyleBox[\"expr\", \"TI\"]\) is a function of \!\(\*StyleBox[\"\[Omega]\", \"TR\"]\)."
FourierSeries`NInverseFourierTransform::usage = "\!\(\*RowBox[{\"NInverseFourierTransform\", \"[\", RowBox[{StyleBox[\"expr\", \"TI\"], \",\", StyleBox[\"\[Omega]\", \"TR\"], \",\", StyleBox[\"t\", \"TI\"]}], \"]\"}]\) gives a numerical approximation to the inverse Fourier transform of \!\(\*StyleBox[\"expr\", \"TI\"]\) evaluated at the numerical value \!\(\*StyleBox[\"t\", \"TI\"]\), where \!\(\*StyleBox[\"expr\", \"TI\"]\) is a function of \!\(\*StyleBox[\"\[Omega]\", \"TR\"]\)."
FunctionApproximations`Bias::usage = "Bias is an option to RationalInterpolation, GeneralRationalInterpolation, MiniMaxApproximation, and GeneralMiniMaxApproximation that specifies the bias to apply when automatically picking interpolation points."
FunctionApproximations`Brake::usage = "Brake is an option to MiniMaxApproximation and GeneralMiniMaxApproximation that specifies how changes from one iteration to the next are to be restricted."
FunctionApproximations`Derivatives::usage = "Derivatives is an option to MiniMaxApproximation and GeneralMiniMaxApproximation that specifies an expression that evaluates to a list containing the function and its first two derivatives."
FunctionApproximations`EconomizedRationalApproximation::usage = "\!\(\*RowBox[{\"EconomizedRationalApproximation\", \"[\", RowBox[{StyleBox[\"expr\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"0\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"1\", \"TR\"]]}], \"}\"}], \",\", StyleBox[\"m\", \"TI\"], \",\", StyleBox[\"n\", \"TI\"]}], \"}\"}]}], \"]\"}]\) gives the economized rational approximation to \!\(\*StyleBox[\"expr\", \"TI\"]\) that is good over the interval \!\(\*SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"0\", \"TR\"]]\) to \!\(\*SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"1\", \"TR\"]]\), with numerator order \!\(\*StyleBox[\"m\", \"TI\"]\) and denominator order \!\(\*StyleBox[\"n\", \"TI\"]\)."
FunctionApproximations`GeneralMiniMaxApproximation::usage = "\!\(\*RowBox[{\"GeneralMiniMaxApproximation\", \"[\", RowBox[{RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"f\", \"TI\"], StyleBox[\"x\", \"TI\"]], \",\", SubscriptBox[StyleBox[\"f\", \"TI\"], StyleBox[\"y\", \"TI\"]]}], \"}\"}], \",\", RowBox[{\"{\", RowBox[{StyleBox[\"t\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"t\", \"TI\"], StyleBox[\"0\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"t\", \"TI\"], StyleBox[\"1\", \"TR\"]]}], \"}\"}], \",\", StyleBox[\"m\", \"TI\"], \",\", StyleBox[\"n\", \"TI\"]}], \"}\"}], \",\", StyleBox[\"x\", \"TI\"]}], \"]\"}]\) finds the rational polynomial function of \!\(\*StyleBox[\"x\", \"TI\"]\), with numerator order \!\(\*StyleBox[\"m\", \"TI\"]\) and denominator order \!\(\*StyleBox[\"n\", \"TI\"]\), that gives a mini-max approximation to the curve with \!\(\*StyleBox[\"x\", \"TI\"]\) and \!\(\*StyleBox[\"y\", \"TI\"]\) coordinates \!\(\*SubscriptBox[StyleBox[\"f\", \"TI\"], StyleBox[\"x\", \"TI\"]]\) and \!\(\*SubscriptBox[StyleBox[\"f\", \"TI\"], StyleBox[\"y\", \"TI\"]]\) generated as a function of \!\(\*StyleBox[\"t\", \"TI\"]\) on the interval \!\(\*SubscriptBox[StyleBox[\"t\", \"TI\"], StyleBox[\"0\", \"TR\"]]\) to \!\(\*SubscriptBox[StyleBox[\"t\", \"TI\"], StyleBox[\"1\", \"TR\"]]\).\n\!\(\*RowBox[{\"GeneralMiniMaxApproximation\", \"[\", RowBox[{RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"f\", \"TI\"], StyleBox[\"x\", \"TI\"]], \",\", SubscriptBox[StyleBox[\"f\", \"TI\"], StyleBox[\"y\", \"TI\"]]}], \"}\"}], \",\", StyleBox[\"approx\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{StyleBox[\"t\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"t\", \"TI\"], StyleBox[\"0\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"t\", \"TI\"], StyleBox[\"1\", \"TR\"]]}], \"}\"}], \",\", StyleBox[\"m\", \"TI\"], \",\", StyleBox[\"n\", \"TI\"]}], \"}\"}], \",\", StyleBox[\"x\", \"TI\"]}], \"]\"}]\) finds the mini-max approximation, starting the iterative algorithm with \!\(\*StyleBox[\"approx\", \"TI\"]\)."
FunctionApproximations`GeneralRationalInterpolation::usage = "\!\(\*RowBox[{RowBox[{\"GeneralRationalInterpolation\", \"[\", RowBox[{RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"f\", \"TI\"], StyleBox[\"x\", \"TI\"]], \",\", SubscriptBox[StyleBox[\"f\", \"TI\"], StyleBox[\"y\", \"TI\"]]}], \"}\"}], \",\", RowBox[{\"{\", RowBox[{StyleBox[\"t\", \"TI\"], \",\", StyleBox[\"m\", \"TI\"], \",\", StyleBox[\"n\", \"TI\"]}], \"}\"}], \",\", StyleBox[\"x\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"t\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"], \",\", SubscriptBox[StyleBox[\"t\", \"TI\"], RowBox[{StyleBox[\"m\", \"TI\"], \"+\", StyleBox[\"n\", \"TI\"], \"+\", \"1\"}]]}], \"}\"}]}], \"]\"}], \"]\"}]\) gives the rational polynomial function of \!\(\*StyleBox[\"x\", \"TI\"]\), with numerator order \!\(\*StyleBox[\"m\", \"TI\"]\) and denominator order \!\(\*StyleBox[\"n\", \"TI\"]\), that interpolates the curve with \!\(\*StyleBox[\"x\", \"TI\"]\) and \!\(\*StyleBox[\"y\", \"TI\"]\) coordinates \!\(\*SubscriptBox[StyleBox[\"f\", \"TI\"], StyleBox[\"x\", \"TI\"]]\) and \!\(\*SubscriptBox[StyleBox[\"f\", \"TI\"], StyleBox[\"y\", \"TI\"]]\) generated as a function of \!\(\*StyleBox[\"t\", \"TI\"]\), at the interpolation points \!\(\*RowBox[{SubscriptBox[StyleBox[\"t\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"t\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}]\). \n\!\(\*RowBox[{\"GeneralRationalInterpolation\", \"[\", RowBox[{RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"f\", \"TI\"], StyleBox[\"x\", \"TI\"]], \",\", SubscriptBox[StyleBox[\"f\", \"TI\"], StyleBox[\"y\", \"TI\"]]}], \"}\"}], \",\", RowBox[{\"{\", RowBox[{StyleBox[\"t\", \"TI\"], \",\", StyleBox[\"m\", \"TI\"], \",\", StyleBox[\"n\", \"TI\"]}], \"}\"}], \",\", StyleBox[\"x\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{StyleBox[\"t\", \"TI\"], \",\", SubscriptBox[StyleBox[\"t\", \"TI\"], StyleBox[\"0\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"t\", \"TI\"], StyleBox[\"1\", \"TR\"]]}], \"}\"}]}], \"]\"}]\) gives the rational interpolant with the interpolation points chosen automatically from the interval \!\(\*SubscriptBox[StyleBox[\"t\", \"TI\"], StyleBox[\"0\", \"TR\"]]\) to \!\(\*SubscriptBox[StyleBox[\"t\", \"TI\"], StyleBox[\"1\", \"TR\"]]\)."
FunctionApproximations`InterpolateRoot::usage = "\!\(\*RowBox[{\"InterpolateRoot\", \"[\", RowBox[{RowBox[{StyleBox[\"lhs\", \"TI\"], \"==\", StyleBox[\"rhs\", \"TI\"]}], \",\", RowBox[{\"{\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"0\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"1\", \"TR\"]]}], \"}\"}]}], \"]\"}]\) searches for a numerical solution to the equation \!\(\*RowBox[{StyleBox[\"lhs\", \"TI\"], \"==\", StyleBox[\"rhs\", \"TI\"]}]\) using \!\(\*SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"0\", \"TR\"]]\) and \!\(\*SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"1\", \"TR\"]]\) as the first two values of \!\(\*StyleBox[\"x\", \"TI\"]\)."
FunctionApproximations`ListIntegrate::usage = "\!\(\*RowBox[{\"ListIntegrate\", \"[\", RowBox[{RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"y\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TI\"], \",\", SubscriptBox[StyleBox[\"y\", \"TI\"], StyleBox[\"n\", \"TI\"]]}], \"}\"}], \",\", StyleBox[\"h\", \"TI\"], \",\", StyleBox[\"k\", \"TI\"]}], \"]\"}]\) is an obsolete function that uses an InterpolatingFunction object of order \!\(\*StyleBox[\"k\", \"TI\"]\) to give an approximation to the integral of a function with values \!\(\*RowBox[{SubscriptBox[StyleBox[\"y\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"], \",\", SubscriptBox[StyleBox[\"y\", \"TI\"], StyleBox[\"n\", \"TI\"]]}]\) at points equally spaced a distance \!\(\*StyleBox[\"h\", \"TI\"]\) apart.\n\!\(\*RowBox[{\"ListIntegrate\", \"[\", RowBox[{RowBox[{\"{\", RowBox[{RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"y\", \"TI\"], StyleBox[\"1\", \"TR\"]]}], \"}\"}], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"n\", \"TI\"]], \",\", SubscriptBox[StyleBox[\"y\", \"TI\"], StyleBox[\"n\", \"TI\"]]}], \"}\"}]}], \"}\"}], \",\", StyleBox[\"k\", \"TI\"]}], \"]\"}]\) approximates the integral of a function with values \!\(\*RowBox[{SubscriptBox[StyleBox[\"y\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"], \",\", SubscriptBox[StyleBox[\"y\", \"TI\"], StyleBox[\"n\", \"TI\"]]}]\) at the points \!\(\*RowBox[{SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"], \",\", SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"n\", \"TI\"]]}]\)."
FunctionApproximations`MiniMaxApproximation::usage = "\!\(\*RowBox[{\"MiniMaxApproximation\", \"[\", RowBox[{StyleBox[\"expr\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"0\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"1\", \"TR\"]]}], \"}\"}], \",\", StyleBox[\"m\", \"TI\"], \",\", StyleBox[\"n\", \"TI\"]}], \"}\"}]}], \"]\"}]\) finds the rational polynomial function of \!\(\*StyleBox[\"x\", \"TI\"]\), with numerator order \!\(\*StyleBox[\"m\", \"TI\"]\) and denominator order \!\(\*StyleBox[\"n\", \"TI\"]\), that gives a mini-max approximation to \!\(\*StyleBox[\"expr\", \"TI\"]\) on the interval \!\(\*SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"0\", \"TR\"]]\) to \!\(\*SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"1\", \"TR\"]]\).\n\!\(\*RowBox[{\"MiniMaxApproximation\", \"[\", RowBox[{StyleBox[\"expr\", \"TI\"], \",\", StyleBox[\"approx\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"0\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"1\", \"TR\"]]}], \"}\"}], \",\", StyleBox[\"m\", \"TI\"], \",\", StyleBox[\"n\", \"TI\"]}], \"}\"}]}], \"]\"}]\) finds the mini-max approximation to \!\(\*StyleBox[\"expr\", \"TI\"]\), starting the iterative algorithm with \!\(\*StyleBox[\"approx\", \"TI\"]\)."
FunctionApproximations`NIntegrateInterpolatingFunction::usage = "\!\(\*RowBox[{RowBox[{\"NIntegrateInterpolatingFunction\", \"[\", RowBox[{StyleBox[\"f\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"min\", \"TI\"]], \",\", SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"max\", \"TI\"]]}], \"}\"}]}], \"]\"}], \"]\"}]\) gives a numerical approximation to an integral with InterpolatingFunction objects in the integrand.\n\!\(\*RowBox[{\"NIntegrateInterpolatingFunction\", \"[\", RowBox[{StyleBox[\"f\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"min\", \"TI\"]], \",\", SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"max\", \"TI\"]]}], \"}\"}], \",\", RowBox[{\"{\", RowBox[{StyleBox[\"y\", \"TI\"], \",\", SubscriptBox[StyleBox[\"y\", \"TI\"], StyleBox[\"min\", \"TI\"]], \",\", SubscriptBox[StyleBox[\"y\", \"TI\"], StyleBox[\"max\", \"TI\"]]}], \"}\"}], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) gives a numerical approximation to a multidimensional integral."
FunctionApproximations`OrderStarInterpolation::usage = "OrderStarInterpolation is an option to OrderStarPlot that specifies whether interpolation points of an approximant to a function should be displayed. "
FunctionApproximations`OrderStarKind::usage = "OrderStarKind is an option to OrderStarPlot that specifies the type of order star to be displayed. "
FunctionApproximations`OrderStarLegend::usage = "OrderStarLegend is an option to OrderStarPlot that specifies whether to display the legend of symbols used to represent zeros, poles and interpolation points. "
FunctionApproximations`OrderStarPlot::usage = "\!\(\*RowBox[{\"OrderStarPlot\", \"[\", RowBox[{StyleBox[\"r\", \"TI\"], \",\", StyleBox[\"f\", \"TI\"]}], \"]\"}]\) draws the order star depicting the region where \!\(\*RowBox[{StyleBox[\"|\", \"TI\"], RowBox[{StyleBox[\"r\", \"TI\"], \"/\", StyleBox[\"f\", \"TI\"]}], StyleBox[\"|\", \"TI\"], RowBox[{\"<\", \"1\"}]}]\) for the functions \!\(\*StyleBox[\"r\", \"TI\"]\) and \!\(\*StyleBox[\"f\", \"TI\"]\).\n\!\(\*RowBox[{\"OrderStarPlot\", \"[\", RowBox[{StyleBox[\"r\", \"TI\"], \",\", StyleBox[\"f\", \"TI\"], \",\", StyleBox[\"z\", \"TI\"]}], \"]\"}]\) draws the order star where \!\(\*StyleBox[\"r\", \"TI\"]\) and \!\(\*StyleBox[\"f\", \"TI\"]\) are functions of \!\(\*StyleBox[\"z\", \"TI\"]\)."
FunctionApproximations`OrderStarPoles::usage = "OrderStarPoles is an option to OrderStarPlot that specifies whether poles of an approximant and the function to be approximated should be displayed. "
FunctionApproximations`OrderStarSymbolSize::usage = "OrderStarSymbolSize is an option to OrderStarPlot that specifies the size of the symbols used to represent poles, zeros and interpolation points."
FunctionApproximations`OrderStarSymbolThickness::usage = "OrderStarSymbolThickness is an option to OrderStarPlot that specifies the thickness of the outline of the symbols used to represent interpolation points, poles and zeros."
FunctionApproximations`OrderStarZeros::usage = "OrderStarZeros is an option to OrderStarPlot that specifies whether zeros of an approximant and the function to be approximated should be displayed."
FunctionApproximations`PlotFlag::usage = "PlotFlag is an option to MiniMaxApproximation and GeneralMiniMaxApproximation that specifies whether plots of the relative error of successive iterates in the approximation algorithm are to be drawn."
FunctionApproximations`PrintFlag::usage = "PrintFlag is an option to MiniMaxApproximation and GeneralMiniMaxApproximation that specifies whether data from the successive iterates in the approximation algorithm are to be shown."
FunctionApproximations`RationalInterpolation::usage = "\!\(\*RowBox[{\"RationalInterpolation\", \"[\", RowBox[{StyleBox[\"expr\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"m\", \"TI\"], \",\", StyleBox[\"n\", \"TI\"]}], \"}\"}], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TI\"], \",\", SubscriptBox[StyleBox[\"x\", \"TI\"], RowBox[{StyleBox[\"n\", \"TI\"], \"+\", StyleBox[\"m\", \"TI\"], \"+\", \"1\"}]]}], \"}\"}]}], \"]\"}]\) gives the rational interpolant to \!\(\*StyleBox[\"expr\", \"TI\"]\) with numerator order \!\(\*StyleBox[\"m\", \"TI\"]\) and denominator order \!\(\*StyleBox[\"n\", \"TI\"]\), where \!\(\*RowBox[{SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}]\) are the abscissas of the interpolation points.\n\!\(\*RowBox[{\"RationalInterpolation\", \"[\", RowBox[{StyleBox[\"expr\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"m\", \"TI\"], \",\", StyleBox[\"n\", \"TI\"]}], \"}\"}], \",\", RowBox[{\"{\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"0\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"1\", \"TR\"]]}], \"}\"}]}], \"]\"}]\) gives the rational interpolant with the interpolation points chosen automatically on the interval \!\(\*SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"0\", \"TR\"]]\) to \!\(\*SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"1\", \"TR\"]]\)."
Geodesy`Eccentricity::usage = "Eccentricity is an option for SpheroidalDistance which specifies the eccentricity of the ellipsoid in the spheroidal model."
Geodesy`GeodeticToAuthalic::usage = "\!\(\*RowBox[{\"GeodeticToAuthalic\", \"[\", RowBox[{RowBox[{\"{\", RowBox[{StyleBox[\"latitude\", \"TI\"], \",\", StyleBox[\"longitude\", \"TI\"]}], \"}\"}], \",\", StyleBox[\"eccentricity\", \"TI\"]}], \"]\"}]\) gives the coordinates of the corresponding point on an authalic sphere given the latitude and longitude of a point on a spheroid with specified eccentricity."
Geodesy`SemimajorAxis::usage = "SemimajorAxis is an option for SpheroidalDistance which specifies the length of the semi-major axis in the spheroidal model."
Geodesy`SphericalDistance::usage = "\!\(\*RowBox[{\"SphericalDistance\", \"[\", RowBox[{SubscriptBox[StyleBox[\"pt\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"pt\", \"TI\"], StyleBox[\"2\", \"TR\"]]}], \"]\"}]\) gives the distance between points \!\(\*SubscriptBox[StyleBox[\"pt\", \"TI\"], StyleBox[\"1\", \"TR\"]]\) and \!\(\*SubscriptBox[StyleBox[\"pt\", \"TI\"], StyleBox[\"2\", \"TR\"]]\) on the Earth using a spherical model of the planet. "
Geodesy`SpheroidalDistance::usage = "\!\(\*RowBox[{\"SpheroidalDistance\", \"[\", RowBox[{SubscriptBox[StyleBox[\"pt\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"pt\", \"TI\"], StyleBox[\"2\", \"TR\"]]}], \"]\"}]\) gives the distance between points \!\(\*SubscriptBox[StyleBox[\"pt\", \"TI\"], StyleBox[\"1\", \"TR\"]]\) and \!\(\*SubscriptBox[StyleBox[\"pt\", \"TI\"], StyleBox[\"2\", \"TR\"]]\) on the Earth using the spheroidal model of the planet."
Geodesy`ToAuthalicRadius::usage = "\!\(\*RowBox[{\"ToAuthalicRadius\", \"[\", RowBox[{StyleBox[\"semimajor\", \"TI\"], \",\", StyleBox[\"eccentricity\", \"TI\"]}], \"]\"}]\) gives the radius of the authalic sphere based on the spheroid with semi-major axis \!\(\*StyleBox[\"semimajor\", \"TI\"]\) and eccentricity \!\(\*StyleBox[\"eccentricity\", \"TI\"]\)."
Geodesy`ToDegrees::usage = "\!\(\*RowBox[{\"ToDegrees\", \"[\", RowBox[{\"{\", RowBox[{StyleBox[\"degrees\", \"TI\"], \",\", StyleBox[\"minutes\", \"TI\"], \",\", StyleBox[\"seconds\", \"TI\"]}], \"}\"}], \"]\"}]\) converts a coordinate in degree-minute-second format to degrees.\n\!\(\*RowBox[{\"ToDegrees\", \"[\", RowBox[{\"{\", RowBox[{StyleBox[\"degrees\", \"TI\"], \",\", StyleBox[\"minutes\", \"TI\"]}], \"}\"}], \"]\"}]\) converts from degrees-minutes format to degrees."
Geodesy`ToDMS::usage = "\!\(\*RowBox[{\"ToDMS\", \"[\", StyleBox[\"degrees\", \"TI\"], \"]\"}]\) converts a coordinate in degrees to degree-minute-second format."
GraphUtilities`AdjacencyMatrix::usage = "\!\(\*RowBox[{\"AdjacencyMatrix\", \"[\", StyleBox[\"g\", \"TI\"], \"]\"}]\) gives the SparseArray object representing the graph \!\(\*StyleBox[\"g\", \"TI\"]\).\n\!\(\*RowBox[{\"AdjacencyMatrix\", \"[\", RowBox[{StyleBox[\"g\", \"TI\"], \",\", StyleBox[\"n\", \"TI\"]}], \"]\"}]\) gives the SparseArray object representing the graph \!\(\*StyleBox[\"g\", \"TI\"]\), adding additional unconnected vertices, if necessary, to create a graph with \!\(\*StyleBox[\"n\", \"TI\"]\) vertices."
GraphUtilities`Aggressive::usage = "Aggressive is an option to PseudoDiameter that specifies whether an extra iteration is to be carried out."
GraphUtilities`Bicomponents::usage = "\!\(\*RowBox[{\"Bicomponents\", \"[\", StyleBox[\"g\", \"TI\"], \"]\"}]\) gives the biconnected components of the undirected graph \!\(\*StyleBox[\"g\", \"TI\"]\)."
GraphUtilities`CommunityModularity::usage = "\!\(\*RowBox[{\"CommunityModularity\", \"[\", RowBox[{StyleBox[\"g\", \"TI\"], \",\", StyleBox[\"partition\", \"TI\"]}], \"]\"}]\) gives the community modularity of a partition.\n\!\(\*RowBox[{\"CommunityModularity\", \"[\", RowBox[{StyleBox[\"g\", \"TI\"], \",\", StyleBox[\"assignment\", \"TI\"]}], \"]\"}]\) gives the community modularity of an assignment."
GraphUtilities`CommunityStructureAssignment::usage = "\!\(\*RowBox[{\"CommunityStructureAssignment\", \"[\", StyleBox[\"g\", \"TI\"], \"]\"}]\) gives the assignment of vertices of a graph \!\(\*StyleBox[\"g\", \"TI\"]\) into communities. "
GraphUtilities`CommunityStructurePartition::usage = "\!\(\*RowBox[{\"CommunityStructurePartition\", \"[\", StyleBox[\"g\", \"TI\"], \"]\"}]\) gives the partition of a graph \!\(\*StyleBox[\"g\", \"TI\"]\) into communities. "
GraphUtilities`ExpressionTreePlot::usage = "\!\(\*RowBox[{\"ExpressionTree\", \"[\", StyleBox[\"e\", \"TI\"], \"]\"}]\) plots the expression tree of \!\(\*StyleBox[\"e.\", \"TI\"]\)\n\!\(\*RowBox[{\"ExpressionTreePlot\", \"[\", RowBox[{StyleBox[\"e\", \"TI\"], \",\", \" \", StyleBox[\"pos\", \"TI\"]}], \"]\"}]\) plots the expression tree of \!\(\*StyleBox[\"e \", \"TI\"]\) with its root placed at position \!\(\*RowBox[{StyleBox[\"pos\", \"TI\"], \".\"}]\)\n\!\(\*RowBox[{\"ExpressionTreePlot\", \"[\", RowBox[{StyleBox[\"e\", \"TI\"], \",\", \" \", StyleBox[\"pos\", \"TI\"], StyleBox[\",\", \"TI\"], StyleBox[\" \", \"TI\"], StyleBox[\"lev\", \"TI\"]}], \"]\"}]\) plots the expression tree of \!\(\*StyleBox[\"e \", \"TI\"]\) up to level \!\(\*StyleBox[\"lev\", \"TI\"]\) with its root placed at position \!\(\*RowBox[{StyleBox[\"pos\", \"TI\"], \".\"}]\)"
GraphUtilities`GraphCoordinates3D::usage = "\!\(\*RowBox[{\"GraphCoordinates3D\", \"[\", RowBox[{StyleBox[\"g\", \"TI\"], \",\", StyleBox[\"options\", \"TI\"]}], \"]\"}]\) calculates a visually appealing 3D layout of the vertices of a graph \!\(\*StyleBox[\"g\", \"TI\"]\) and returns the coordinates of the vertices."
GraphUtilities`GraphCoordinates::usage = "\!\(\*RowBox[{\"GraphCoordinates\", \"[\", RowBox[{StyleBox[\"g\", \"TI\"], \",\", StyleBox[\"options\", \"TI\"]}], \"]\"}]\) calculates a visually appealing 2D layout of the vertices of a graph \!\(\*StyleBox[\"g\", \"TI\"]\) and returns the coordinates of the vertices."
GraphUtilities`GraphEdit::usage = "\!\(\*RowBox[{\"GraphEdit\", \"[\", \"]\"}]\) opens a window on which graph can be inputted interactively.\n\!\(\*RowBox[{\"GraphEdit\", \"[\", StyleBox[\"g\", \"TI\"], \"]\"}]\) opens a window and plot the graph g in the window, which can be edited interactively."
GraphUtilities`GraphPath::usage = "\!\(\*RowBox[{\"GraphPath\", \"[\", RowBox[{StyleBox[\"g\", \"TI\"], \",\", \" \", StyleBox[\"start\", \"TI\"], \",\", \" \", StyleBox[\"end\", \"TI\"]}], \"]\"}]\) finds a shortest path between vertices \!\(\*StyleBox[\"start\", \"TI\"]\) and \!\(\*StyleBox[\"end\", \"TI\"]\) in graph \!\(\*StyleBox[\"g\", \"TI\"]\)"
GraphUtilities`LineScaledCoordinate::usage = "\!\(\*RowBox[{\"LineScaledCoordinate\", \"[\", RowBox[{RowBox[{\"{\", RowBox[{RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"y\", \"TI\"], StyleBox[\"1\", \"TR\"]]}], \"}\"}], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"y\", \"TI\"], StyleBox[\"2\", \"TR\"]]}], \"}\"}], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"k\", \"TI\"]], \",\", SubscriptBox[StyleBox[\"y\", \"TI\"], StyleBox[\"k\", \"TI\"]]}], \"}\"}]}], \"}\"}], \",\", \" \", StyleBox[\"r\", \"TI\"]}], \"]\"}]\) gives the coordinate of a point in the polyline \!\(\*RowBox[{\"{\", RowBox[{RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"y\", \"TI\"], StyleBox[\"1\", \"TR\"]]}], \"}\"}], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"y\", \"TI\"], StyleBox[\"2\", \"TR\"]]}], \"}\"}], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"k\", \"TI\"]], \",\", SubscriptBox[StyleBox[\"y\", \"TI\"], StyleBox[\"k\", \"TI\"]]}], \"}\"}]}], \"}\"}]\), at a scaled distance of \!\(\*StyleBox[\"r\", \"TI\"]\) from point \!\(\*RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"y\", \"TI\"], StyleBox[\"1\", \"TR\"]]}], \"}\"}]\).\n\!\(\*RowBox[{RowBox[{\"LineScaledCoordinate\", \"[\", RowBox[{\"{\", RowBox[{RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"y\", \"TI\"], StyleBox[\"1\", \"TR\"]]}], \"}\"}], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"y\", \"TI\"], StyleBox[\"2\", \"TR\"]]}], \"}\"}], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"k\", \"TI\"]], \",\", SubscriptBox[StyleBox[\"y\", \"TI\"], StyleBox[\"k\", \"TI\"]]}], \"}\"}]}], \"}\"}], \"]\"}], \" \"}]\) is the same as \!\(\*RowBox[{\"LineScaledCoordinate\", \"[\", RowBox[{RowBox[{\"{\", RowBox[{RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"y\", \"TI\"], StyleBox[\"1\", \"TR\"]]}], \"}\"}], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"y\", \"TI\"], StyleBox[\"2\", \"TR\"]]}], \"}\"}], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"k\", \"TI\"]], \",\", SubscriptBox[StyleBox[\"y\", \"TI\"], StyleBox[\"k\", \"TI\"]]}], \"}\"}]}], \"}\"}], \",\", \" \", \"0.5\"}], \"]\"}]\)."
GraphUtilities`LinkRankMatrix::usage = "\!\(\*RowBox[{\"LinkRankMatrix\", \"[\", StyleBox[\"g\", \"TI\"], \"]\"}]\) returns the LinkRank of the graph \!\(\*StyleBox[\"g\", \"TI\"]\), in the form of a sparse matrix. The LinkRank of an edge \!\(\*RowBox[{StyleBox[\"u\", \"TI\"], \"->\", StyleBox[\"v\", \"TI\"]}]\) is defined as the PageRanks of \!\(\*StyleBox[\"u\", \"TI\"]\), divided by the outer-degree of \!\(\*StyleBox[\"u\", \"TI\"]\)."
GraphUtilities`LinkRanks::usage = "\!\(\*RowBox[{\"LinkRanks\", \"[\", StyleBox[\"g\", \"TI\"], \"]\"}]\) gives the link ranks of the directed graph \!\(\*StyleBox[\"g\", \"TI\"]\) as a rule list."
GraphUtilities`MaximalBipartiteMatching::usage = "\!\(\*RowBox[{\"MaximalBipartiteMatching\", \"[\", StyleBox[\"g\", \"TI\"], \"]\"}]\) gives the maximal matching of the bipartite graph g."
GraphUtilities`MaximalIndependentEdgeSet::usage = "\!\(\*RowBox[{\"MaximalIndepndentEdgeSet\", \"[\", StyleBox[\"g\", \"TI\"], \"]\"}]\) gives a maximal independent edge set of an undirected graph \!\(\*StyleBox[\"g\", \"TI\"]\)."
GraphUtilities`MaximalIndependentVertexSet::usage = "\!\(\*RowBox[{\"MaximalIndependentVertexSet\", \"[\", StyleBox[\"g\", \"TI\"], \"]\"}]\) gives a maximal independent vertex set of an undirected graph \!\(\*StyleBox[\"g\", \"TI\"]\).\n\!\(\*RowBox[{\"MaximalIndependentVertexSet\", \"[\", RowBox[{StyleBox[\"g\", \"TI\"], \",\", StyleBox[\"w\", \"TI\"]}], \"]\"}]\) gives a maximal independent vertex set of \!\(\*StyleBox[\"g\", \"TI\"]\) with vertices weighted by \!\(\*StyleBox[\"w\", \"TI\"]\)."
GraphUtilities`MinCut::usage = "\!\(\*RowBox[{\"MinCut\", \"[\", RowBox[{StyleBox[\"g\", \"TI\"], \",\", StyleBox[\"k\", \"TI\"]}], \"]\"}]\) partitions the undirected graph \!\(\*StyleBox[\"g\", \"TI\"]\) into \!\(\*StyleBox[\"k\", \"TI\"]\) parts where the number of edge cuts is approximately minimized."
GraphUtilities`MinimumBandwidthOrdering::usage = "\!\(\*RowBox[{\"MinimumBandwidthOrdering\", \"[\", StyleBox[\"g\", \"TI\"], \"]\"}]\) attempts to find a vertex ordering that minimizes the bandwidth of the undirected graph \!\(\*StyleBox[\"g\", \"TI\"]\).\n\!\(\*RowBox[{\"MinimumBandwidthOrdering\", \"[\", StyleBox[\"m\", \"TI\"], \"]\"}]\) attempts to find row and column permutations that minimize the bandwidth of the matrix \!\(\*StyleBox[\"m\", \"TI\"]\)."
GraphUtilities`PageRanks::usage = "\!\(\*RowBox[{\"PageRanks\", \"[\", StyleBox[\"g\", \"TI\"], \"]\"}]\) gives the PageRank of the graph \!\(\*StyleBox[\"g\", \"TI\"]\) as a rule list."
GraphUtilities`PageRankVector::usage = "\!\(\*RowBox[{\"PageRankVector\", \"[\", StyleBox[\"g\", \"TI\"], \"]\"}]\) returns the PageRank of graph \!\(\*StyleBox[\"g\", \"TI\"]\)."
GraphUtilities`PseudoDiameter::usage = "\!\(\*RowBox[{\"PseudoDiameter\", \"[\", StyleBox[\"g\", \"TI\"], \"]\"}]\) gives the pseudo diameter of the undirected graph \!\(\*StyleBox[\"g\", \"TI\"]\), and the two vertices that achieve this diameter."
GraphUtilities`RecursionMethod::usage = "RecursionMethod is an option to MinimumBandwidthOrdering that specifies whether to employ a multilevel process to find a minimal bandwidth ordering."
GraphUtilities`RefinementMethod::usage = "RefinementMethod is an option to MinimumBandwidthOrdering that specifies the refinement method used to further improve the bandwidth ordering."
GraphUtilities`RemoveSinks::usage = "RemoveSinks is an option of PageRanks, PageRankVector, LinkRanks and LinkRankMatrix. It specifies whether sinks are removed by linking with all vertices. The default value is True."
GraphUtilities`StrongComponents::usage = "\!\(\*RowBox[{\"StrongComponents\", \"[\", StyleBox[\"g\", \"TI\"], \"]\"}]\) gives a list of all strongly connected components in the directed graph \!\(\*StyleBox[\"g\", \"TI\"]\)."
GraphUtilities`TeleportProbability::usage = "TeleportProbability is an option to PageRanks, PageRankVector, LinkRanks, and LinkRankMatrix that specifies the probability that an internet user may choose to visit a vertex at random instead of choosing an out-link."
GraphUtilities`ToCombinatoricaGraph::usage = "\!\(\*RowBox[{\"ToCombinatoricaGraph\", \"[\", StyleBox[\"g\", \"TI\"], \"]\"}]\) returns the Combinatorica representation of the graph \!\(\*StyleBox[\"g\", \"TI\"]\).\n\!\(\*RowBox[{\"ToCombinatoricaGraph\", \"[\", RowBox[{StyleBox[\"g\", \"TI\"], \",\", StyleBox[\"n\", \"TI\"]}], \"]\"}]\) returns the graph \!\(\*StyleBox[\"g\", \"TI\"]\), adding additional unconnected vertices, if necessary, to create a graph with \!\(\*StyleBox[\"n\", \"TI\"]\) vertices."
GraphUtilities`WeakComponents::usage = "\!\(\*RowBox[{\"WeakComponents\", \"[\", StyleBox[\"g\", \"TI\"], \"]\"}]\) gives a list of all weakly connected components in the undirected graph \!\(\*StyleBox[\"g\", \"TI\"]\)."
GraphUtilities`Weighted::usage = "Weighted is an option to MaximalIndependentEdgeSet that specifies whether edges with higher weights are preferred during matching, with values True or False (the default); it is option of CommunityStructureAssignment, CommunityStructurePartition and CommunityModularity, that specifies whether vertices linked by edges with higher weights are preferably kept in the same community, with values True or False (the default); it is also an option of ShortestPath, GraphDistance, GraphDistanceMatrix and ClosenessCentrality, it specifies whether edge weight is to be used in calculating distance, with possible values True (the default except for GraphDistance) or False (the default for GraphDistance)."
GUIKit`BindEvent::usage = "\!\(\*RowBox[{\"BindEvent\", \"[\", RowBox[{RowBox[{StyleBox[\"name\", \"TI\"], \"|\", RowBox[{\"{\", RowBox[{StyleBox[\"target\", \"TI\"], \",\", StyleBox[\"name\", \"TI\"]}], \"}\"}], \"|\", RowBox[{\"{\", RowBox[{StyleBox[\"target\", \"TI\"], \",\", StyleBox[\"name\", \"TI\"], \",\", StyleBox[\"filter\", \"TI\"]}], \"}\"}]}], \",\", RowBox[{StyleBox[\"object\", \"TI\"], \"|\", StyleBox[\"script\", \"TI\"], \"|\", StyleBox[\"call\", \"TI\"]}], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) binds an event from one object to a listener or to a script."
GUIKit`CloseGUIObject::usage = "\!\(\*RowBox[{\"CloseGUIObject\", \"[\", StyleBox[\"interface\", \"TI\"], \"]\"}]\) closes a live GUIObject instance.\n\!\(\*RowBox[{\"CloseGUIObject\", \"[\", \"]\"}]\) requests that an interface close, when called within a Script block."
GUIKit`ExposeWidgetReferences::usage = "ExposeWidgetReferences is an option to Widget which specifies a list of normally internal \:f3b5children widget reference names to include as publicly available instances."
GUIKit`GUIInformation::usage = "\!\(\*RowBox[{\" GUIInformation \", \"[\", StyleBox[\" obj \", \" TI \"], \"]\"}]\) returns information about a live interface object.\n\!\(\*RowBox[{\" GUIInformation \", \"[\", RowBox[{StyleBox[\" obj \", \" TI \"], \",\", StyleBox[\" target \", \" TI \"]}], \"]\"}]\) returns information about a specific widget in the interface.\n\!\(\*RowBox[{\" GUIInformation \", \"[\", RowBox[{StyleBox[\" obj \", \" TI \"], \",\", StyleBox[\" target \", \" TI \"], \",\", StyleBox[\" sets \", \" TI \"]}], \"]\"}]\) returns only specific rule sets of information."
GUIKit`GUILoad::usage = "\!\(\*RowBox[{\" GUILoad \", \"[\", StyleBox[\" src \", \" TI \"], \"]\"}]\) loads an interface definition and returns immediately with a GUIObject result.\n\!\(\*RowBox[{\" GUILoad \", \"[\", RowBox[{StyleBox[\" src \", \" TI \"], \",\", StyleBox[\" args \", \" TI \"]}], \"]\"}]\) passes arguments to the interface definition."
GUIKit`GUIObject::usage = "\!\(\*RowBox[{\" GUIObject \", \"[\", RowBox[{StyleBox[\" root \", \" TI \"], \",\", StyleBox[\" args \", \" TI \"]}], \"]\"}]\) represents a live interface instance with root widget \!\(\*StyleBox[\" root \", \" TI \"]\), wrapping the active widgets and environment."
GUIKit`GUIObjectQ::usage = "\!\(\*RowBox[{\" GUIObjectQ \", \"[\", StyleBox[\" ref \", \" TI \"], \"]\"}]\) returns True if \!\(\*StyleBox[\" ref \", \" TI \"]\) is an active GUIObject and otherwise returns False."
GUIKit`GUIResolve::usage = "\!\(\*RowBox[{\" GUIResolve \", \"[\", StyleBox[\" src \", \" TI \"], \"]\"}]\) resolves an interface definition to its top-level completely loaded widget and enclosing widgets.\n\!\(\*RowBox[{\" GUIResolve \", \"[\", RowBox[{StyleBox[\" src \", \" TI \"], \",\", StyleBox[\" args \", \" TI \"]}], \"]\"}]\) passes arguments to the interface definition."
GUIKit`GUIRunModal::usage = "\!\(\*RowBox[{\" GUIRunModal \", \"[\", RowBox[{StyleBox[\" src \", \" TI \"], \",\", StyleBox[\" args \", \" TI \"], \",\", StyleBox[\" opts \", \" TI \"]}], \"]\"}]\) loads and runs a user interface definition in a modal state with the kernel and returns a result when finished."
GUIKit`GUIRun::usage = "\!\(\*RowBox[{\" GUIRun \", \"[\", StyleBox[\" src \", \" TI \"], \"]\"}]\) loads and runs an interface definition in a modeless state and returns immediately with a GUIObject expression that represents the live interface.\n\!\(\*RowBox[{\" GUIRun \", \"[\", RowBox[{StyleBox[\" src \", \" TI \"], \",\", StyleBox[\" args \", \" TI \"]}], \"]\"}]\) passes arguments to the interface definition."
GUIKit`GUIScreenShot::usage = "\!\(\*RowBox[{\" GUIScreenShot \", \"[\", StyleBox[\" interface \", \" TI \"], \"]\"}]\) generates a graphic that captures the current state of the runtime user interface."
GUIKit`IncludedScriptContexts::usage = "IncludedScriptContexts is an option to GUIRun and related functions that can extend the active $ContextPath that Script blocks within a definition will use."
GUIKit`InitialArguments::usage = "InitialArguments is an option to Widget which specifies the argument list to use when instantiating this widget definition."
GUIKit`InvokeMethod::usage = "\!\(\*RowBox[{\" InvokeMethod \", \"[\", RowBox[{StyleBox[\" name \", \" TI \"], \",\", RowBox[{RowBox[{\" {\", \"}\"}], \"|\", StyleBox[\" content \", \" TI \"]}]}], \"]\"}]\) calls a widget method on the wrapping contexted widget.\n\!\(\*RowBox[{\" InvokeMethod \", \"[\", RowBox[{RowBox[{\" {\", RowBox[{StyleBox[\" target \", \" TI \"], \",\", StyleBox[\" name \", \" TI \"]}], StyleBox[\"}\", \" TI \"]}], \",\", StyleBox[\" content \", \" TI \"]}], \"]\"}]\) calls a widget method on the specified target widget."
GUIKit`InvokeThread::usage = "InvokeThread is an option to \!\(\*StyleBox[\" GUIKit \", FontSlant -> \" Italic \"]\) symbols which specifies what thread the invocation should execute on."
GUIKit`InvokeWait::usage = "InvokeWait is an option to \!\(\*StyleBox[\" GUIKit \", FontSlant -> \" Italic \"]\) symbols which determines whether a threaded invocation should wait for a result or continue on immediately without a response."
GUIKit`Name::usage = "Name is an option to \!\(\*StyleBox[\" GUIKit \", FontSlant -> \" Italic \"]\) expression functions and identifies a string name with which to register the widget instance in the active widget registry."
GUIKit`PropertyValue::usage = "\!\(\*RowBox[{\" PropertyValue \", \"[\", StyleBox[\" name \", \" TI \"], \"]\"}]\) gets a widget property value.\n\!\(\*RowBox[{\" PropertyValue \", \"[\", RowBox[{\" {\", RowBox[{StyleBox[\" target \", \" TI \"], \",\", StyleBox[\" name \", \" TI \"]}], \"}\"}], \"]\"}]\) gets a widget property value, specifying the target widget.\n\!\(\*RowBox[{\" PropertyValue \", \"[\", RowBox[{\" {\", RowBox[{StyleBox[\" target \", \" TI \"], \",\", StyleBox[\" name \", \" TI \"], \",\", StyleBox[\" index \", \" TI \"]}], \"}\"}], \"]\"}]\) gets an indexed widget property value, specifying the target widget."
GUIKit`ReleaseGUIObject::usage = "\!\(\*RowBox[{\" ReleaseGUIObject \", \"[\", StyleBox[\" obj \", \" TI \"], \"]\"}]\) closes and terminates all resources of a live GUIObject instance."
GUIKit`ReleaseMethod::usage = "ReleaseMethod is an option to GUIRun and related functions that determines when a GUIObject is released."
GUIKit`ReturnScript::usage = "ReturnScript is an option to GUIRunModal which specifies a string version of \!\(\*StyleBox[\" Mathematica \", FontSlant -> \" Italic \"]\) code to execute when the window ends its modal session and becomes the return value of the GUIRunModal call."
GUIKit`Script::usage = "\!\(\*RowBox[{\" Script \", \"[\", RowBox[{StyleBox[\" scriptcode \", \" TI \"], \",\", StyleBox[\" opts \", \" TI \"]}], \"]\"}]\) defines a script to be used either on load or during an event.\n\!\(\*RowBox[{\" Script \", \"[\", RowBox[{RowBox[{\" {\", \"}\"}], \",\", RowBox[{\" ScriptSource \", \"->\", StyleBox[\" file \", \" TI \"]}]}], \"]\"}]\) uses code stored in an external file as the source for script code."
GUIKit`ScriptSource::usage = "ScriptSource is an option to Script which specifies a location to load the script code from."
GUIKit`SetPropertyValue::usage = "\!\(\*RowBox[{\" SetPropertyValue \", \"[\", RowBox[{StyleBox[\" name \", \" TI \"], \",\", StyleBox[\" value \", \" TI \"]}], \"]\"}]\) sets a widget property value.\n\!\(\*RowBox[{\" SetPropertyValue \", \"[\", RowBox[{RowBox[{\" {\", RowBox[{StyleBox[\" target \", \" TI \"], \",\", StyleBox[\" name \", \" TI \"]}], StyleBox[\"}\", \" TI \"]}], \",\", StyleBox[\" value \", \" TI \"]}], \"]\"}]\) or \!\(\*RowBox[{\" SetPropertyValue \", \"[\", RowBox[{RowBox[{\" {\", RowBox[{StyleBox[\" target \", \" TI \"], \",\", StyleBox[\" name \", \" TI \"]}], StyleBox[\"}\", \" TI \"]}], \"->\", StyleBox[\" value \", \" TI \"]}], \"]\"}]\) sets a widget property value, specifying the target widget.\n\!\(\*RowBox[{\" SetPropertyValue \", \"[\", RowBox[{RowBox[{\" {\", RowBox[{StyleBox[\" target \", \" TI \"], \",\", StyleBox[\" name \", \" TI \"], \",\", StyleBox[\" index \", \" TI \"]}], \"}\"}], \",\", StyleBox[\" value \", \" TI \"]}], \"]\"}]\) or \!\(\*RowBox[{\" SetPropertyValue \", \"[\", RowBox[{RowBox[{\" {\", RowBox[{StyleBox[\" target \", \" TI \"], \",\", StyleBox[\" name \", \" TI \"], \",\", StyleBox[\" index \", \" TI \"]}], \"}\"}], \"->\", StyleBox[\" value \", \" TI \"]}], \"]\"}]\) sets an indexed widget property value, specifying the target widget."
GUIKit`SetWidgetReference::usage = "\!\(\*RowBox[{\" SetWidgetReference \", \"[\", RowBox[{StyleBox[\" name \", \" TI \"], \",\", StyleBox[\" value \", \" TI \"]}], \"]\"}]\) registers a widget with string \!\(\*StyleBox[\" name \", \" TI \"]\) in the widget registry for the current interface."
GUIKit`SymbolicGUIKitXMLToWidget::usage = "\!\(\*RowBox[{\" SymbolicGUIKitXMLToWidget \", \"[\", StyleBox[\" body \", \" TI \"], \"]\"}]\) converts a GUIKitXML representation into the equivalent user interface expression."
GUIKit`Tabs::usage = "Tabs is an option value for WidgetLayout."
GUIKit`UnsetWidgetReference::usage = "\!\(\*RowBox[{\" UnsetWidgetReference \", \"[\", StyleBox[\" name \", \" TI \"], \"]\"}]\) removes a widget from the registry with a name in the current interface."
GUIKit`WidgetAlign::usage = "\!\(\*RowBox[{\" WidgetAlign \", \"[\", \"]\"}]\) is a widget layout placeholder that provides an alignment marker. \n\!\(\*RowBox[{\" WidgetAlign \", \"[\", RowBox[{RowBox[{\" {\", RowBox[{StyleBox[\" ref \", \" TI \"], \",\", \" After \"}], \"}\"}], \",\", \" Before \"}], \"]\"}]\) makes a specific request for the next widget to align to another widget by named reference \!\(\*StyleBox[\" ref \", \" TI \"]\), and aligned based on Before and After specifications on both widgets."
GUIKit`WidgetFill::usage = "\!\(\*RowBox[{\" WidgetFill \", \"[\", \"]\"}]\) is a widget layout placeholder used when adjacent widgets should not dominate the layout space."
GUIKit`WidgetGroup::usage = "\!\(\*RowBox[{\" WidgetGroup \", \"[\", RowBox[{RowBox[{\" {\", StyleBox[\" content \", \" TI \"], \"}\"}], \",\", StyleBox[\" opts \", \" TI \"]}], \"]\"}]\) specifies custom layout settings for how the content widgets are displayed."
GUIKit`WidgetLayout::usage = "WidgetLayout is an option to Widget, WidgetReference, and WidgetGroup that contains suboptions controlling layout."
GUIKit`Widget::usage = "\!\(\*RowBox[{\" Widget \", \"[\", RowBox[{RowBox[{StyleBox[\" class \", \" TI \"], \":\", RowBox[{StyleBox[\" class \", \" TI \"], \"|\", StyleBox[\" path \", \" TI \"], \"|\", RowBox[{\" URL \", \"[\", StyleBox[\" path \", \" TI \"], \"]\"}]}]}], \",\", RowBox[{\" {\", StyleBox[\" content \", \" TI \"], \"}\"}]}], \"]\"}]\) defines a new widget instance."
GUIKit`WidgetReference::usage = "\!\(\*RowBox[{\" WidgetReference \", \"[\", StyleBox[\" id \", \" TI \"], \"]\"}]\) looks up an existing widget instance using identifier \!\(\*StyleBox[\" id \", \" TI \"]\) and return the underlying object."
GUIKit`WidgetSpace::usage = "\!\(\*RowBox[{\" WidgetSpace \", \"[\", \"]\"}]\) is a widget layout placeholder used when spacing is needed between widgets."
GUIKit`WidgetToSymbolicGUIKitXML::usage = "\!\(\*RowBox[{\" WidgetToSymbolicGUIKitXML \", \"[\", StyleBox[\" expr \", \" TI \"], \"]\"}]\) converts a user interface expression to a GUIKitXML SymbolicXML expression."
GUIKit`$GUIPath::usage = "\!\(\*StyleBox[\" $GUIPath \", \" Program \"]\) lists the directories searched in attempting to find interface files."
HierarchicalClustering`Agglomerate::usage = "\!\(\*RowBox[{\" Agglomerate \", \"[\", RowBox[{\" {\", RowBox[{SubscriptBox[StyleBox[\" e \", \" TI \"], StyleBox[\" 1\", \" TR \"]], \",\", SubscriptBox[StyleBox[\" e \", \" TI \"], StyleBox[\" 2\", \" TR \"]], \",\", \" \[Ellipsis] \"}], \"}\"}], \"]\"}]\) gives an hierarchical clustering of the elements \!\(\*RowBox[{SubscriptBox[StyleBox[\" e \", \" TI \"], StyleBox[\" 1\", \" TR \"]], \",\", SubscriptBox[StyleBox[\" e \", \" TI \"], StyleBox[\" 2\", \" TR \"]], \",\", \" \[Ellipsis] \"}]\).\n\!\(\*RowBox[{\" Agglomerate \", \"[\", RowBox[{\" {\", RowBox[{RowBox[{SubscriptBox[StyleBox[\" e \", \" TI \"], StyleBox[\" 1\", \" TR \"]], \"->\", SubscriptBox[StyleBox[\" v \", \" TI \"], StyleBox[\" 1\", \" TR \"]]}], \",\", RowBox[{SubscriptBox[StyleBox[\" e \", \" TI \"], StyleBox[\" 2\", \" TR \"]], \"->\", SubscriptBox[StyleBox[\" v \", \" TI \"], StyleBox[\" 2\", \" TR \"]]}], \",\", \" \[Ellipsis] \"}], \"}\"}], \"]\"}]\) represents \!\(\*SubscriptBox[StyleBox[\" e \", \" TI \"], StyleBox[\" i \", \" TI \"]]\) with \!\(\*SubscriptBox[StyleBox[\" v \", \" TI \"], StyleBox[\" i \", \" TI \"]]\) in each cluster. \n\!\(\*RowBox[{\" Agglomerate \", \"[\", RowBox[{RowBox[{\" {\", RowBox[{SubscriptBox[StyleBox[\" e \", \" TI \"], StyleBox[\" 1\", \" TR \"]], \",\", SubscriptBox[StyleBox[\" e \", \" TI \"], StyleBox[\" 2\", \" TR \"]], \",\", StyleBox[\" \[Ellipsis] \", \" TI \"]}], \"}\"}], \"->\", RowBox[{\" {\", RowBox[{SubscriptBox[StyleBox[\" v \", \" TI \"], StyleBox[\" 1\", \" TR \"]], \",\", SubscriptBox[StyleBox[\" v \", \" TI \"], StyleBox[\" 2\", \" TR \"]], \",\", StyleBox[\" \[Ellipsis] \", \" TI \"]}], \"}\"}]}], \"]\"}]\) represents \!\(\*SubscriptBox[StyleBox[\" e \", \" TI \"], StyleBox[\" i \", \" TI \"]]\) with \!\(\*SubscriptBox[StyleBox[\" v \", \" TI \"], StyleBox[\" i \", \" TI \"]]\) in each cluster."
HierarchicalClustering`ClusterFlatten::usage = "\!\(\*RowBox[{\" ClusterFlatten \", \"[\", StyleBox[\" c \", \" TI \"], \"]\"}]\) gives a flat list of the data elements contained in the cluster \!\(\*StyleBox[\" c \", \" TI \"]\)."
HierarchicalClustering`Cluster::usage = "\!\(\*RowBox[{\" Cluster \", \"[\", RowBox[{SubscriptBox[StyleBox[\" c \", \" TI \"], StyleBox[\" 1\", \" TR \"]], \",\", SubscriptBox[StyleBox[\" c \", \" TI \"], StyleBox[\" 2\", \" TR \"]], \",\", StyleBox[\" d \", \" TI \"], \",\", SubscriptBox[StyleBox[\" n \", \" TI \"], StyleBox[\" 1\", \" TR \"]], \",\", SubscriptBox[StyleBox[\" n \", \" TI \"], StyleBox[\" 2\", \" TR \"]]}], \"]\"}]\) represents a merger of the clusters \!\(\*SubscriptBox[StyleBox[\" c \", \" TI \"], StyleBox[\" 1\", \" TR \"]]\) and \!\(\*SubscriptBox[StyleBox[\" c \", \" TI \"], StyleBox[\" 2\", \" TR \"]]\) with dissimilarity \!\(\*StyleBox[\" d \", \" TI \"]\) and \!\(\*SubscriptBox[StyleBox[\" n \", \" TI \"], StyleBox[\" 1\", \" TR \"]]\) and \!\(\*SubscriptBox[StyleBox[\" n \", \" TI \"], StyleBox[\" 2\", \" TR \"]]\) data elements respectively."
HierarchicalClustering`ClusterSplit::usage = "\!\(\*RowBox[{\" ClusterSplit \", \"[\", RowBox[{StyleBox[\" c \", \" TI \"], \",\", StyleBox[\" n \", \" TI \"]}], \"]\"}]\) splits the cluster \!\(\*StyleBox[\" c \", \" TI \"]\) into \!\(\*StyleBox[\" n \", \" TI \"]\) clusters."
HierarchicalClustering`DendrogramPlot::usage = "\!\(\*RowBox[{\" DendrogramPlot \", \"[\", StyleBox[\" list \", \" TI \"], \"]\"}]\) constructs a dendrogram from the hierarchical clustering of \!\(\*StyleBox[\" list \", \" TI \"]\).\n\!\(\*RowBox[{\" DendrogramPlot \", \"[\", StyleBox[\" c \", \" TI \"], \"]\"}]\) constructs a dendrogram from the Cluster object \!\(\*StyleBox[\" c \", \" TI \"]\)."
HierarchicalClustering`DirectAgglomerate::usage = "\!\(\*RowBox[{\" DirectAgglomerate \", \"[\", StyleBox[\" m \", \" TI \"], \"]\"}]\) constructs a cluster hierarchy based on the distance or dissimilarity matrix \!\(\*StyleBox[\" m \", \" TI \"]\).\n\!\(\*RowBox[{\" DirectAgglomerate \", \"[\", RowBox[{StyleBox[\" m \", \" TI \"], \",\", StyleBox[\" list \", \" TI \"]}], \"]\"}]\) associates the elements of \!\(\*StyleBox[\" list \", \" TI \"]\) with the rows of the matrix \!\(\*StyleBox[\" m \", \" TI \"]\) in the cluster hierarchy."
HierarchicalClustering`DistanceMatrix::usage = "\!\(\*RowBox[{\" DistanceMatrix \", \"[\", StyleBox[\" list \", \" TI \"], \"]\"}]\) gives a matrix of distances or dissimilarities between the elements of \!\(\*StyleBox[\" list \", \" TI \"]\)."
HierarchicalClustering`HighlightLevel::usage = "HighlightLevel is an option for DendrogramPlot that specifies the level at which to highlight the dendrogram."
HierarchicalClustering`HighlightStyle::usage = "HighlightStyle is an option for DendrogramPlot that specifies the style for highlighted clusters."
HierarchicalClustering`LeafLabels::usage = "LeafLabels is an option for DendrogramPlot that specifies labels for the dendrogram leaves."
HierarchicalClustering`Linkage::usage = "Linkage is an option for Agglomerate and DendrogramPlot that specifies the linkage method for agglomerative clustering."
HierarchicalClustering`Orientation::usage = "Orientation is an option for DendrogramPlot that specifies the orientation of the dendrogram."
HierarchicalClustering`TruncateDendrogram::usage = "TruncateDendrogram is an option for DendrogramPlot that specifies the fusion levels at which to truncate the dendrogram."
Histograms`ApproximateIntervals::usage = "ApproximateIntervals is an option of histogram functions that specifies whether the HistogramCategories or HistogramRange settings should be adjusted so that the interval boundaries are described by simple numbers."
Histograms`FrequencyData::usage = "FrequencyData is an option of histogram functions that specifies whether the data argument represents the original data or the frequencies with which the original data fall in the respective categories."
Histograms`Histogram3D::usage = "\!\(\*RowBox[{\" Histogram3D \", \"[\", RowBox[{\" {\", RowBox[{RowBox[{\" {\", RowBox[{SubscriptBox[StyleBox[\" x \", \" TI \"], StyleBox[\" 1\", \" TR \"]], \",\", SubscriptBox[StyleBox[\" y \", \" TI \"], StyleBox[\" 1\", \" TR \"]]}], \"}\"}], \",\", RowBox[{\" {\", RowBox[{SubscriptBox[StyleBox[\" x \", \" TI \"], StyleBox[\" 2\", \" TR \"]], \",\", SubscriptBox[StyleBox[\" y \", \" TI \"], StyleBox[\" 2\", \" TR \"]]}], \"}\"}], \",\", StyleBox[\" \[Ellipsis] \", \" TI \"]}], \"}\"}], \"]\"}]\) generates a three dimensional bar graph representing a histogram of the bivariate data \!\(\*RowBox[{\" {\", RowBox[{RowBox[{\" {\", RowBox[{SubscriptBox[StyleBox[\" x \", \" TI \"], StyleBox[\" 1\", \" TR \"]], \",\", SubscriptBox[StyleBox[\" y \", \" TI \"], StyleBox[\" 1\", \" TR \"]]}], \"}\"}], \",\", RowBox[{\" {\", RowBox[{SubscriptBox[StyleBox[\" x \", \" TI \"], StyleBox[\" 2\", \" TR \"]], \",\", SubscriptBox[StyleBox[\" y \", \" TI \"], StyleBox[\" 2\", \" TR \"]]}], \"}\"}], \",\", StyleBox[\" \[Ellipsis] \", \" TI \"]}], \"}\"}]\).\n\!\(\*RowBox[{\" Histogram3D \", \"[\", RowBox[{RowBox[{\" {\", RowBox[{RowBox[{\" {\", RowBox[{SubscriptBox[StyleBox[\" f \", \" TI \"], StyleBox[\" 11\", \" TR \"]], \",\", SubscriptBox[StyleBox[\" f \", \" TI \"], StyleBox[\" 12\", \" TR \"]], \",\", StyleBox[\" \[Ellipsis] \", \" TR \"], \",\", SubscriptBox[StyleBox[\" f \", \" TI \"], StyleBox[RowBox[{\" 1\", \" l \"}], \" TI \"]]}], \"}\"}], \",\", StyleBox[\" \[Ellipsis] \", \" TR \"], \",\", RowBox[{\" {\", RowBox[{SubscriptBox[StyleBox[\" f \", \" TI \"], StyleBox[\" k1 \", \" TI \"]], \",\", SubscriptBox[StyleBox[\" f \", \" TI \"], StyleBox[\" k2 \", \" TI \"]], \",\", StyleBox[\" \[Ellipsis] \", \" TR \"], \",\", SubscriptBox[StyleBox[\" f \", \" TI \"], StyleBox[\" kl \", \" TI \"]]}], \"}\"}]}], \"}\"}], \",\", RowBox[{\" FrequencyData \", \"->\", \" True \"}]}], \"]\"}]\) generates a histogram of the bivariate data, where \!\(\*SubscriptBox[StyleBox[\" f \", \" TI \"], StyleBox[\" ij \", \" TI \"]]\) is the frequency with which the original data falls in the category \!\(\*RowBox[{\" {\", RowBox[{StyleBox[\" i \", \" TI \"], \",\", StyleBox[\" j \", \" TI \"]}], \"}\"}]\)."
Histograms`HistogramCategories::usage = "HistogramCategories is an option of histogram functions that specifies the categories in the histogram."
Histograms`Histogram::usage = "\!\(\*RowBox[{\" Histogram \", \"[\", RowBox[{\" {\", RowBox[{SubscriptBox[StyleBox[\" x \", \" TI \"], StyleBox[\" 1\", \" TR \"]], \",\", SubscriptBox[StyleBox[\" x \", \" TI \"], StyleBox[\" 2\", \" TR \"]], \",\", StyleBox[\" \[Ellipsis] \", \" TI \"]}], \"}\"}], \"]\"}]\) generates a histogram of the univariate data \!\(\*RowBox[{\" {\", RowBox[{SubscriptBox[StyleBox[\" x \", \" TI \"], StyleBox[\" 1\", \" TR \"]], \",\", SubscriptBox[StyleBox[\" x \", \" TI \"], StyleBox[\" 2\", \" TR \"]], \",\", StyleBox[\" \[Ellipsis] \", \" TR \"]}], \"}\"}]\).\n\!\(\*RowBox[{\" Histogram \", \"[\", RowBox[{RowBox[{\" {\", RowBox[{SubscriptBox[StyleBox[\" f \", \" TI \"], StyleBox[\" 1\", \" TR \"]], \",\", SubscriptBox[StyleBox[\" f \", \" TI \"], StyleBox[\" 2\", \" TR \"]], \",\", StyleBox[\" \[Ellipsis] \", \" TR \"]}], \"}\"}], \",\", RowBox[{\" FrequencyData \", \"->\", \" True \"}]}], \"]\"}]\) generates a histogram of the univariate frequency data \!\(\*RowBox[{\" {\", RowBox[{SubscriptBox[StyleBox[\" f \", \" TI \"], StyleBox[\" 1\", \" TR \"]], \",\", SubscriptBox[StyleBox[\" f \", \" TI \"], StyleBox[\" 2\", \" TR \"]], \",\", StyleBox[\" \[Ellipsis] \", \" TR \"]}], \"}\"}]\), where \!\(\*SubscriptBox[StyleBox[\" f \", \" TI \"], StyleBox[\" i \", \" TI \"]]\) is the frequency with which the original data occurs in category \!\(\*StyleBox[\" i \", \" TI \"]\)."
Histograms`HistogramRange::usage = "HistogramRange is an option of histogram functions that specifies the lower and upper limits of the points to be included in the histogram."
Histograms`HistogramScale::usage = "HistogramScale is an option of histogram functions that specifies the way in which the bar heights are to be scaled."
HypothesisTesting`ChiSquareCI::usage = "\!\(\*RowBox[{\" ChiSquareCI \", \"[\", RowBox[{StyleBox[\" var \", \" TI \"], \",\", StyleBox[\" df \", \" TI \"]}], \"]\"}]\) gives a confidence interval based on a \!\(\*SuperscriptBox[StyleBox[\" \[Chi] \", \" TR \"], \" 2\"]\) distribution with \!\(\*StyleBox[\" df \", \" TI \"]\) degrees of freedom."
HypothesisTesting`ChiSquarePValue::usage = "\!\(\*RowBox[{\" ChiSquarePValue \", \"[\", RowBox[{StyleBox[\" x \", \" TI \"], \",\", StyleBox[\" df \", \" TI \"]}], \"]\"}]\) gives the cumulative probability beyond \!\(\*StyleBox[\" x \", \" TI \"]\) for the \!\(\*SuperscriptBox[StyleBox[\" \[Chi] \", \" TR \"], \" 2\"]\) distribution with \!\(\*StyleBox[\" df \", \" TI \"]\) degrees of freedom."
HypothesisTesting`EqualVariances::usage = "EqualVariances is an option to statistical confidence interval and hypothesis test functions of two samples that specifies that unknown population variances are equal."
HypothesisTesting`FRatioCI::usage = "\!\(\*RowBox[{\" FRatioCI \", \"[\", RowBox[{StyleBox[\" ratio \", \" TI \"], \",\", StyleBox[\" n \", \" TI \"], \",\", StyleBox[\" m \", \" TI \"]}], \"]\"}]\) gives a confidence interval based on an F-ratio distribution with \!\(\*StyleBox[\" n \", \" TI \"]\) and \!\(\*StyleBox[\" m \", \" TI \"]\) degrees of freedom."
HypothesisTesting`FRatioPValue::usage = "\!\(\*RowBox[{\" FRatioPValue \", \"[\", RowBox[{StyleBox[\" x \", \" TI \"], \",\", StyleBox[\" n \", \" TI \"], \",\", StyleBox[\" m \", \" TI \"]}], \"]\"}]\) gives the cumulative probability beyond \!\(\*StyleBox[\" x \", \" TI \"]\) for the F-ratio distribution with \!\(\*StyleBox[\" n \", \" TI \"]\) and \!\(\*StyleBox[\" m \", \" TI \"]\) degrees of freedom."
HypothesisTesting`FullReport::usage = "FullReport is an option to hypothesis test functions that specifies whether all report information should be returned."
HypothesisTesting`KnownVariance::usage = "KnownVariance is an option to statistical confidence interval and hypothesis test functions that specifies the value of the population variance."
HypothesisTesting`MeanCI::usage = "\!\(\*RowBox[{\" MeanCI \", \"[\", StyleBox[\" list \", \" TI \"], \"]\"}]\) gives a confidence interval for the population mean estimated from \!\(\*StyleBox[\" list \", \" TI \"]\)."
HypothesisTesting`MeanDifferenceCI::usage = "\!\(\*RowBox[{\" MeanDifferenceCI \", \"[\", RowBox[{SubscriptBox[StyleBox[\" list \", \" TI \"], StyleBox[\" 1\", \" TR \"]], \",\", SubscriptBox[StyleBox[\" list \", \" TI \"], StyleBox[\" 2\", \" TR \"]]}], \"]\"}]\) gives a confidence interval for the difference between the population means estimated from \!\(\*SubscriptBox[StyleBox[\" list \", \" TI \"], \" 1\"]\) and \!\(\*SubscriptBox[StyleBox[\" list \", \" TI \"], StyleBox[\" 2\", \" TR \"]]\)."
HypothesisTesting`MeanDifferenceTest::usage = "\!\(\*RowBox[{\" MeanDifferenceTest \", \"[\", RowBox[{SubscriptBox[StyleBox[\" list \", \" TI \"], StyleBox[\" 1\", \" TR \"]], \",\", SubscriptBox[StyleBox[\" list \", \" TI \"], StyleBox[\" 2\", \" TR \"]], \",\", SubscriptBox[StyleBox[\" \[CapitalDelta]\[Mu] \", \" TR \"], StyleBox[\" 0\", \" TR \"]]}], \"]\"}]\) performs a test with null hypothesis \!\(\*RowBox[{RowBox[{SubscriptBox[StyleBox[\" \[Mu] \", \" TR \"], \" 1\"], \"-\", SubscriptBox[\" \[Mu] \", \" 2\"]}], \"=\", SubscriptBox[\" \[CapitalDelta]\[Mu] \", StyleBox[\" 0\", \" TR \"]]}]\)."
HypothesisTesting`MeanTest::usage = "\!\(\*RowBox[{\" MeanTest \", \"[\", RowBox[{StyleBox[\" list \", \" TI \"], \",\", SubscriptBox[StyleBox[\" \[Mu] \", \" TR \"], StyleBox[\" 0\", \" TR \"]]}], \"]\"}]\) performs a test with null hypothesis \!\(\*RowBox[{StyleBox[\" \[Mu] \", \" TR \"], \"=\", SubscriptBox[StyleBox[\" \[Mu] \", \" TR \"], StyleBox[\" 0\", \" TR \"]]}]\)."
HypothesisTesting`NormalCI::usage = "\!\(\*RowBox[{\" NormalCI \", \"[\", RowBox[{StyleBox[\" \[Mu] \", \" TR \"], \",\", StyleBox[\" \[Sigma] \", \" TR \"]}], \"]\"}]\) gives a confidence interval based on a normal distribution."
HypothesisTesting`NormalPValue::usage = "\!\(\*RowBox[{\" NormalPValue \", \"[\", StyleBox[\" x \", \" TI \"], \"]\"}]\) gives the cumulative density beyond \!\(\*StyleBox[\" x \", \" TI \"]\) for a normal distribution with zero mean and unit variance."
HypothesisTesting`OneSidedPValue::usage = "OneSidedPValue is an element in hypothesis test output for one-sided tests."
HypothesisTesting`StudentTCI::usage = "\!\(\*RowBox[{\" StudentTCI \", \"[\", RowBox[{StyleBox[\" \[Mu] \", \" TR \"], \",\", StyleBox[\" \[Sigma] \", \" TR \"], \",\", StyleBox[\" df \", \" TI \"]}], \"]\"}]\) gives a confidence interval based on Student's \!\(\*StyleBox[\" t \", \" TI \"]\) distribution with \!\(\*StyleBox[\" df \", \" TI \"]\) degrees of freedom."
HypothesisTesting`StudentTPValue::usage = "\!\(\*RowBox[{\" StudentTPValue \", \"[\", RowBox[{StyleBox[\" x \", \" TI \"], \",\", StyleBox[\" df \", \" TI \"]}], \"]\"}]\) gives the cumulative probability beyond \!\(\*StyleBox[\" x \", \" TI \"]\) for Student's \!\(\*StyleBox[\" t \", \" TI \"]\) distribution with \!\(\*StyleBox[\" df \", \" TI \"]\) degrees of freedom."
HypothesisTesting`TwoSided::usage = "TwoSided is an option to hypothesis test functions that specifies whether the test should be two-sided."
HypothesisTesting`TwoSidedPValue::usage = "TwoSidedPValue is an element in hypothesis test output for two-sided tests."
HypothesisTesting`VarianceCI::usage = "\!\(\*RowBox[{\" VarianceCI \", \"[\", StyleBox[\" list \", \" TI \"], \"]\"}]\) gives a confidence interval for the population variance estimated from \!\(\*StyleBox[\" list \", \" TI \"]\)."
HypothesisTesting`VarianceRatioCI::usage = "\!\(\*RowBox[{\" VarianceRatioCI \", \"[\", RowBox[{SubscriptBox[StyleBox[\" list \", \" TI \"], StyleBox[\" 1\", \" TR \"]], \",\", SubscriptBox[StyleBox[\" list \", \" TI \"], StyleBox[\" 2\", \" TR \"]]}], \"]\"}]\) gives a confidence interval for the ratio of the population variances estimated from \!\(\*SubscriptBox[StyleBox[\" list \", \" TI \"], StyleBox[\" 1\", \" TR \"]]\) and from \!\(\*SubscriptBox[StyleBox[\" list \", \" TI \"], StyleBox[\" 2\", \" TR \"]]\)."
HypothesisTesting`VarianceRatioTest::usage = "\!\(\*RowBox[{\" VarianceRatioTest \", \"[\", RowBox[{SubscriptBox[StyleBox[\" list \", \" TI \"], StyleBox[\" 1\", \" TR \"]], \",\", SubscriptBox[StyleBox[\" list \", \" TI \"], StyleBox[\" 2\", \" TR \"]], \",\", StyleBox[\" r \", \" TI \"]}], \"]\"}]\) performs a test with null hypothesis \!\(\*RowBox[{RowBox[{SuperscriptBox[SubscriptBox[StyleBox[\" \[Sigma] \", \" TR \"], StyleBox[\" 1\", \" TR \"]], \" 2\"], \"/\", SuperscriptBox[SubscriptBox[StyleBox[\" \[Sigma] \", \" TR \"], StyleBox[\" 2\", \" TR \"]], \" 2\"]}], \"=\", StyleBox[\" r \", \" TI \"]}]\)."
JLink`AddPeriodical::usage = "\!\(\*RowBox[{\" AddPeriodical \", \"[\", RowBox[{StyleBox[\" expr \", \" TI \"], \",\", \" \", StyleBox[\" interval \", \" TI \"]}], \"]\"}]\) adds the computation \!\(\*StyleBox[\" expr \", \" TI \"]\) to the set of operations that are periodically performed automatically."
JLink`AddToClassPath::usage = "\!\(\*RowBox[{\" AddToClassPath \", \"[\", RowBox[{SubscriptBox[StyleBox[\" path \", \" TI \"], StyleBox[\" 1\", \" TR \"]], \",\", SubscriptBox[StyleBox[\" path \", \" TI \"], StyleBox[\" 2\", \" TR \"]], \",\", \"...\"}], \"]\"}]\) adds the specified full paths to directories and jar or zip files to the \!\(\*StyleBox[\" J/Link\", FontSlant -> \" Italic \"]\) class search path. "
JLink`AllowRaggedArrays::usage = "\!\(\*RowBox[{\" AllowRaggedArrays \", \"[\", \" True \", \"]\"}]\) lets you pass ragged (i.e., non rectangular) arrays to Java.\n\!\(\*RowBox[{\" AllowRaggedArrays \", \"[\", \" False \", \"]\"}]\) restores the default behavior."
JLink`AppletViewer::usage = "\!\(\*RowBox[{\" AppletViewer \", \"[\", RowBox[{StyleBox[\" javaclass \", \" TI \"], \",\", StyleBox[\" parameters \", \" TI \"]}], \"]\"}]\) displays a window with an applet of the specified JavaClass running in it. \n\!\(\*RowBox[{\" AppletViewer \", \"[\", RowBox[{StyleBox[\" \\ \" \\!\\ (\\*StyleBox[\\ \" classname \\ \",\\ \" TI \\ \"]\\)\\ \" \", ShowStringCharacters->True], \",\", StyleBox[\" parameters \", \" TI \"]}], \"]\"}]\) displays a window running an applet of the named class."
JLink`BeginJavaBlock::usage = "\!\(\*RowBox[{\" BeginJavaBlock \", \"[\", \"]\"}]\) begins an evaluation block equivalent to a JavaBlock, except that it works across a larger span than the evaluation of a single expression."
JLink`ClassName::usage = "\!\(\*RowBox[{\" ClassName \", \"[\", StyleBox[\" javaclass \", \" TI \"], \"]\"}]\) returns, as a string, the fully qualified name of the specified JavaClass.\n\!\(\*RowBox[{\" ClassName \", \"[\", StyleBox[\" javaobject \", \" TI \"], \"]\"}]\) returns the fully qualified name of the Java class of the specified JavaObject. "
JLink`CloseFrontEnd::usage = "\!\(\*RowBox[{\" CloseFrontEnd \", \"[\", \"]\"}]\) closes the link to the front end that was opened by \!\(\*RowBox[{RowBox[{\" UseFrontEnd \", \"[\", \"]\"}], \" \"}]\)or \!\(\*RowBox[{\" ConnectToFrontEnd \", \"[\", \"]\"}]\)."
JLink`ConnectToFrontEnd::usage = "\!\(\*RowBox[{\" ConnectToFrontEnd \", \"[\", \"]\"}]\) establishes a link to the notebook front end for use by the \!\(\*RowBox[{\" UseFrontEnd \", \"[\", \"]\"}]\) function."
JLink`Constructors::usage = "\!\(\*RowBox[{\" Constructors \", \"[\", StyleBox[\" javaclass \", \" TI \"], \"]\"}]\) returns a list of the Java declarations for all constructors of the specified JavaClass. \n\!\(\*RowBox[{\" Constructors \", \"[\", \" StyleBox[classname, TI]StyleBox[\", TI], \"]\"}]\) lists the constructor for the named class.\n\!\(\*RowBox[{RowBox[{\" Constructors \", \"[\", StyleBox[\" javaobject \", \" TI \"], \"]\"}], \" \"}]\) lists the constructors for the class of the specified JavaObject."
JLink`DoModal::usage = "\!\(\*RowBox[{\" DoModal \", \"[\", \"]\"}]\) does not return until the Java side sends an expression of the form \!\(\*RowBox[{\" EvaluatePacket \", \"[\", RowBox[{\" EndModal \", \"[\", StyleBox[\" args \", \" TI \"], \"]\"}], \"]\"}]\)."
JLink`EndJavaBlock::usage = "\!\(\*RowBox[{\" EndJavaBlock \", \"[\", \"]\"}]\) ends an evaluation block equivalent to a JavaBlock, except that it works across a larger span than the evaluation of a single expression."
JLink`EndModal::usage = "\!\(\*RowBox[{\" EndModal \", \"[\", \"]\"}]\) is the head of an expression sent by Java to signal the end of a \!\(\*RowBox[{\" DoModal \", \"[\", \"]\"}]\) loop."
JLink`Fields::usage = "\!\(\*RowBox[{\" Fields \", \"[\", StyleBox[\" javaclass \", \" TI \"], \"]\"}]\) returns a list of the Java declarations for all fields of the specified JavaClass.\n\!\(\*RowBox[{\" Fields \", \"[\", StyleBox[\" \\ \" \\!\\ (\\*StyleBox[\\ \" classname \\ \",\\ \" TI \\ \"]\\)\\ \" \", ShowStringCharacters->True], \"]\"}]\) lists the fields for the named class.\n\!\(\*RowBox[{\" Fields \", \"[\", StyleBox[\" javaobject \", \" TI \"], \"]\"}]\) lists the fields for the class of the specified JavaObject. "
JLink`FrontEndLink::usage = "\!\(\*RowBox[{\" FrontEndLink \", \"[\", \"]\"}]\) returns the link to the front end that will be used by \!\(\*RowBox[{\" UseFrontEnd \", \"[\", \"]\"}]\)."
JLink`FrontEndSharedQ::usage = "\!\(\*RowBox[{\" FrontEndSharedQ \", \"[\", StyleBox[\" link \", \" TI \"], \"]\"}]\) returns True if the front end is being shared with a specified link, and returns False otherwise."
JLink`GetClass::usage = "\!\(\*RowBox[{\" GetClass \", \"[\", StyleBox[\" javaobject \", \" TI \"], \"]\"}]\) returns the JavaClass that identifies the object's class."
JLink`GetComplexClass::usage = "\!\(\*RowBox[{\" GetComplexClass \", \"[\", \"]\"}]\) returns the Java class used for complex numbers sent from, and returned to, \!\(\*StyleBox[\" Mathematica.\", FontSlant -> \" Italic \"]\)"
JLink`GetJavaException::usage = "\!\(\*RowBox[{\" GetJavaException \", \"[\", \"]\"}]\) returns the Java \!\(\*StyleBox[\" Exception \", \" InlineCode \"]\) object that was thrown in the most recent call from \!\(\*StyleBox[\" Mathematica \", FontSlant -> \" Italic \"]\) to Java."
JLink`GetJVM::usage = "\!\(\*RowBox[{\" GetJVM \", \"[\", StyleBox[\" link \", \" TI \"], \"]\"}]\) returns the JVM expression that corresponds to \!\(\*StyleBox[\" link \", \" TI \"]\), which was returned from InstallJava."
JLink`ImplementJavaInterface::usage = "\!\(\*RowBox[{\" ImplementJavaInterface \", \"[\", StyleBox[RowBox[{\" interfaces \", \",\", \" mappings \"}], \" TI \"], \"]\"}]\) uses the Dynamic Proxy facility of Java to create a new Java class and return an object of that class that implements the named interface or list of interfaces by calling back into \!\(\*StyleBox[\" Mathematica \", FontSlant -> \" Italic \"]\). In short, it lets you create a Java object that implements a given Java interface entirely in \!\(\*StyleBox[\" Mathematica \", FontSlant -> \" Italic \"]\) code."
JLink`InstallJava::usage = "\!\(\*RowBox[{\" InstallJava \", \"[\", \"]\"}]\) launches the Java runtime and prepares it to be used from \!\(\*StyleBox[\" Mathematica \", FontSlant -> \" Italic \"]\)."
JLink`InstanceOf::usage = "\!\(\*RowBox[{\" InstanceOf \", \"[\", RowBox[{StyleBox[\" javaobject \", \" TI \"], \",\", StyleBox[\" javaclass \", \" TI \"]}], \"]\"}]\) gives True if \!\(\*StyleBox[\" javaobject \", \" TI \"]\) is an instance of the class or interface \!\(\*StyleBox[\" javaclass \", \" TI \"]\), or a subclass. Otherwise, it returns False.\n\!\(\*RowBox[{\" InstanceOf \", \"[\", RowBox[{StyleBox[\" javaobject \", \" TI \"], \",\", StyleBox[\" \\ \" \\!\\ (\\*StyleBox[\\ \" classname \\ \",\\ \" TI \\ \"]\\)\\ \" \", ShowStringCharacters->True]}], \"]\"}]\) gives True if \!\(\*StyleBox[\" javaobject \", \" TI \"]\) is an instance of the named class or interface, or a subclass."
JLink`JavaBlock::usage = "\!\(\*RowBox[{\" JavaBlock \", \"[\", StyleBox[\" expr \", \" TI \"], \"]\"}]\) causes all new Java objects returned to \!\(\*StyleBox[\" Mathematica \", FontSlant -> \" Italic \"]\) during the evaluation of \!\(\*StyleBox[\" expr \", \" TI \"]\) to be released when \!\(\*StyleBox[\" expr \", \" TI \"]\) finishes. It is an error to refer to such an object after JavaBlock ends."
JLink`JavaClass::usage = "\!\(\*RowBox[{\" JavaClass \", \"[\", RowBox[{StyleBox[\" classname \", \" TI \"], \",\", StyleBox[\" n \", \" TI \"]}], \"]\"}]\) represents a Java class with the specified name. "
JLink`JavaClassPath::usage = "\!\(\*RowBox[{\" JavaClassPath \", \"[\", \"]\"}]\) returns the class search path in use by the Java runtime. This includes classes specified via the CLASSPATH environment variable (if any), directories and files added by the user with AddToClassPath, and those directories automatically searched by \!\(\*StyleBox[\" J/Link\", FontSlant -> \" Italic \"]\). "
JLink`JavaLink::usage = "\!\(\*RowBox[{\" JavaLink \", \"[\", \"]\"}]\) returns the \!\(\*StyleBox[\" MathLink \", FontSlant -> \" Italic \"]\) LinkObject that is used to communicate with the \!\(\*StyleBox[\" J/Link\", FontSlant -> \" Italic \"]\) Java runtime. "
JLink`JavaNew::usage = "\!\(\*RowBox[{\" JavaNew \", \"[\", StyleBox[\" javaclass \", \" TI \"], \"]\"}]\) constructs a Java object of the specified JavaClass.\n\!\(\*RowBox[{\" JavaNew \", \"[\", RowBox[{StyleBox[\" javaclass \", \" TI \"], \",\", \" \", StyleBox[\" args \", \" TI \"]}], \"]\"}]\) constructs a Java object of the specified JavaClass, passing the arguments \!\(\*StyleBox[\" args \", \" TI \"]\) to its constructor. \n\!\(\*RowBox[{\" JavaNew \", \"[\", RowBox[{StyleBox[\" classname \", \" TI \"], \",\", \" \", StyleBox[\" args \", \" TI \"]}], \"]\"}]\) constructs a Java object of the named class, first loading the class if necessary."
JLink`JavaObject::usage = "\!\(\*RowBox[{\" JavaObject \", \"[\", \"]\"}]\) is used to denote an expression that refers to an object residing in Java."
JLink`JavaObjectQ::usage = "\!\(\*RowBox[{\" JavaObjectQ \", \"[\", StyleBox[\" expr \", \" TI \"], \"]\"}]\) gives True if \!\(\*StyleBox[\" expr \", \" TI \"]\) is a reference to a Java object or Null, and gives False otherwise. "
JLink`JavaObjectToExpression::usage = "\!\(\*RowBox[{\" JavaObjectToExpression \", \"[\", StyleBox[\" javaobject \", \" TI \"], \"]\"}]\) converts the specified Java object reference into its value as a \" native \" \!\(\*StyleBox[\" Mathematica \", FontSlant -> \" Italic \"]\) expression. "
JLink`JavaShow::usage = "\!\(\*RowBox[{\" JavaShow \", \"[\", StyleBox[\" window \", \" TI \"], \"]\"}]\) causes the specified Java window to be brought to the foreground, so that it appears in front of notebook windows. "
JLink`JavaThrow::usage = "\!\(\*RowBox[{\" JavaThrow \", \"[\", StyleBox[\" \\ \" \\!\\ (\\*StyleBox[\\ \" exception \\ \",\\ \" TI \\ \"]\\)\\ \" \", ShowStringCharacters->True], \"]\"}]\) causes an exception of the specified class to be thrown in the Java thread that called the \!\(\*StyleBox[\" Mathematica \", FontSlant -> \" Italic \"]\) program in which JavaThrow occurred.\n\!\(\*RowBox[{\" JavaThrow \", \"[\", RowBox[{StyleBox[\" \\ \" \\!\\ (\\*StyleBox[\\ \" exception \\ \",\\ \" TI \\ \"]\\)\\ \" \", ShowStringCharacters->True], \",\", StyleBox[\" \\ \" \\!\\ (\\*StyleBox[\\ \" message \\ \",\\ \" TI \\ \"]\\)\\ \" \", ShowStringCharacters->True]}], \"]\"}]\) specifies an optional detail message for the exception.\n\!\(\*RowBox[{\" JavaThrow \", \"[\", StyleBox[\" object \", \" TI \"], \"]\"}]\) causes the specified Java \!\(\*StyleBox[\" Exception \", \" InlineCode \"]\) object to be thrown."
JLink`JavaUILink::usage = "\!\(\*RowBox[{\" JavaUILink \", \"[\", \"]\"}]\) returns the \!\(\*StyleBox[\" MathLink \", FontSlant -> \" Italic \"]\) LinkObject used by calls to \!\(\*StyleBox[\" Mathematica \", FontSlant -> \" Italic \"]\) that originate from Java user-interface actions, or Null if no such link is present."
JLink`JVM::usage = "JVM is the head of an expression that identifies a particular Java runtime installed into the current \!\(\*StyleBox[\" Mathematica \", FontSlant -> \" Italic \"]\) session via InstallJava."
JLink`KeepJavaObject::usage = "\!\(\*RowBox[{\" KeepJavaObject \", \"[\", StyleBox[\" object \", \" TI \"], \"]\"}]\) causes the specified object or objects not to be released when the current JavaBlock ends.\n\!\(\*RowBox[{\" KeepJavaObject \", \"[\", RowBox[{StyleBox[\" object \", \" TI \"], \",\", \" Manual \"}], \"]\"}]\) causes the specified object to escape from all enclosing JavaBlock blocks, meaning that the object will only be released if you manually call ReleaseJavaObject."
JLink`LoadedJavaClasses::usage = "\!\(\*RowBox[{\" LoadedJavaClasses \", \"[\", \"]\"}]\) returns a list of the classes currently loaded into Java by \!\(\*StyleBox[\" Mathematica \", FontSlant -> \" Italic \"]\)."
JLink`LoadedJavaObjects::usage = "\!\(\*RowBox[{\" LoadedJavaObjects \", \"[\", \"]\"}]\) returns a list of the Java objects that have been sent to \!\(\*StyleBox[\" Mathematica \", FontSlant -> \" Italic \"]\) (and not yet released with ReleaseJavaObject). "
JLink`LoadJavaClass::usage = "\!\(\*RowBox[{\" LoadJavaClass \", \"[\", StyleBox[\" classname \", \" TI \"], \"]\"}]\) loads the specified class into Java and sets up definitions so that it can be used from \!\(\*StyleBox[\" Mathematica \", FontSlant -> \" Italic \"]\)."
JLink`MakeJavaExpr::usage = "\!\(\*RowBox[{\" MakeJavaExpr \", \"[\", StyleBox[\" expr \", \" TI \"], \"]\"}]\) constructs a new Java object of the \!\(\*StyleBox[\" J/Link\", FontSlant -> \" Italic \"]\) \!\(\*StyleBox[\" Expr \", \" InlineCode \"]\) class that represents the \!\(\*StyleBox[\" Mathematica \", FontSlant -> \" Italic \"]\) expression \!\(\*StyleBox[\" expr \", \" TI \"]\)."
JLink`MakeJavaObject::usage = "\!\(\*RowBox[{\" MakeJavaObject \", \"[\", StyleBox[\" expr \", \" TI \"], \"]\"}]\) constructs a new Java object whose \" value \" is \!\(\*StyleBox[\" expr \", \" TI \"]\). "
JLink`Methods::usage = "\!\(\*RowBox[{\" Methods \", \"[\", StyleBox[\" javaclass \", \" TI \"], \"]\"}]\) returns a list of the Java declarations for all methods of the specified JavaClass.\n\!\(\*RowBox[{\" Methods \", \"[\", StyleBox[\" \\ \" \\!\\ (\\*StyleBox[\\ \" classname \\ \",\\ \" TI \\ \"]\\)\\ \" \", ShowStringCharacters->True], \"]\"}]\) lists the methods for the named class.\n\!\(\*RowBox[{\" Methods \", \"[\", StyleBox[\" javaobject \", \" TI \"], \"]\"}]\) lists the methods for the class of the specified JavaObject. "
JLink`ParentClass::usage = "\!\(\*RowBox[{\" ParentClass \", \"[\", StyleBox[\" javaclass \", \" TI \"], \"]\"}]\) returns the JavaClass expression representing the parent class of the specified JavaClass.\n\!\(\*RowBox[{\" ParentClass \", \"[\", StyleBox[\" javaobject \", \" TI \"], \"]\"}]\) returns the parent class for the class of the specified JavaObject."
JLink`Periodical::usage = "\!\(\*RowBox[{\" Periodical \", \"[\", StyleBox[\" id \", \" TI \"], \"]\"}]\) returns information about the periodical task corresponding to the specified integer \!\(\*StyleBox[\" id \", \" TI \"]\). "
JLink`Periodicals::usage = "\!\(\*RowBox[{\" Periodicals \", \"[\", \"]\"}]\) returns a list of integer ID numbers corresponding to the set of operations that are periodically performed automatically when the kernel is not busy with another computation."
JLink`ReinstallJava::usage = "\!\(\*RowBox[{\" ReinstallJava \", \"[\", \"]\"}]\) is a convenience function that calls UninstallJava followed by InstallJava."
JLink`ReleaseJavaObject::usage = "\!\(\*RowBox[{\" ReleaseJavaObject \", \"[\", StyleBox[\" javaobject \", \" TI \"], \"]\"}]\) tells the Java memory-management system to forget about any references to the specified JavaObject that are being maintained solely for the sake of \!\(\*StyleBox[\" Mathematica \", FontSlant -> \" Italic \"]\)."
JLink`RemovePeriodical::usage = "\!\(\*RowBox[{\" RemovePeriodical \", \"[\", StyleBox[\" id \", \" TI \"], \"]\"}]\) removes the computation corresponding to the integer \!\(\*StyleBox[\" id \", \" TI \"]\) from the set of operations that are periodically performed automatically."
JLink`ReturnAsJavaObject::usage = "\!\(\*RowBox[{\" ReturnAsJavaObject \", \"[\", StyleBox[\" expr \", \" TI \"], \"]\"}]\) causes a Java method call or field access during the evaluation of \!\(\*StyleBox[\" expr \", \" TI \"]\) to return its result as an object reference (a JavaObject expression), not a value. "
JLink`SameObjectQ::usage = "\!\(\*RowBox[{\" SameObjectQ \", \"[\", RowBox[{SubscriptBox[StyleBox[\" object \", \" TI \"], StyleBox[\" 1\", \" TR \"]], \",\", SubscriptBox[StyleBox[\" object \", \" TI \"], StyleBox[\" 2\", \" TR \"]]}], \"]\"}]\) returns True if and only if the JavaObject expressions \!\(\*SubscriptBox[StyleBox[\" object \", \" TI \"], StyleBox[\" 1\", \" TR \"]]\) and \!\(\*SubscriptBox[StyleBox[\" object \", \" TI \"], StyleBox[\" 2\", \" TR \"]]\) refer to the same Java object. "
JLink`SetComplexClass::usage = "\!\(\*RowBox[{\" SetComplexClass \", \"[\", StyleBox[\" classname \", \" TI \"], \"]\"}]\) specifies the Java class to use for complex numbers sent from, and returned to, \!\(\*StyleBox[\" Mathematica \", FontSlant -> \" Italic \"]\)."
JLink`SetField::usage = "\!\(\*RowBox[{\" SetField \", \"[\", RowBox[{RowBox[{StyleBox[\" obj \", \" TI \"], \"@\", StyleBox[\" field \", \" TI \"]}], \",\", StyleBox[\" val \", \" TI \"]}], \"]\"}]\) sets a value of an object field. "
JLink`SetInternetProxy::usage = "\!\(\*RowBox[{\" SetInternetProxy \", \"[\", RowBox[{StyleBox[\" host \", \" TI \"], \",\", StyleBox[\" port \", \" TI \"]}], \"]\"}]\) sets proxy information in your Java session for accessing the internet. "
JLink`SetPeriodicalInterval::usage = "\!\(\*RowBox[{\" SetPeriodicalInterval \", \"[\", RowBox[{StyleBox[\" id \", \" TI \"], \",\", StyleBox[\" interval \", \" TI \"]}], \"]\"}]\) resets the time interval for the periodical task with the given \!\(\*StyleBox[\" id \", \" TI \"]\)."
JLink`ShowJavaConsole::usage = "\!\(\*RowBox[{\" ShowJavaConsole \", \"[\", \"]\"}]\) displays the Java console window and begins capturing output sent to the Java \!\(\*RowBox[{\" System \", \".\", \" out \"}]\) and \!\(\*RowBox[{\" System \", \".\", \" err \"}]\) streams. \n\!\(\*RowBox[{\" ShowJavaConsole \", \"[\", StyleBox[\" \\ \" stdout \\ \" \",ShowStringCharacters->True], \"]\"}]\) captures only \!\(\*RowBox[{\" System \", \".\", \" out \"}]\).\n\!\(\*RowBox[{\" ShowJavaConsole \", \"[\", StyleBox[\" \\ \" stederr \\ \" \",ShowStringCharacters->True], \"]\"}]\) captures only \!\(\*RowBox[{\" System \", \".\", \" err \"}]\)."
JLink`UninstallJava::usage = "\!\(\*RowBox[{\" UninstallJava \", \"[\", \"]\"}]\) shuts down the Java runtime that was started by InstallJava. "
JLink`UseFrontEnd::usage = "\!\(\*RowBox[{\" UseFrontEnd \", \"[\", StyleBox[\" expr \", \" TI \"], \"]\"}]\) evaluates \!\(\*StyleBox[\" expr \", \" TI \"]\) in an environment where the kernel can make use of the services of the notebook front end."
JLink`UseJVM::usage = "\!\(\*RowBox[{\" UseJVM \", \"[\", RowBox[{StyleBox[\" jvm \", \" TI \"], \",\", StyleBox[\" body \", \" TI \"]}], \"]\"}]\) acts like a wrapper that causes all \!\(\*StyleBox[\" J/Link\", FontSlant -> \" Italic \"]\) calls in \!\(\*StyleBox[\" body \", \" TI \"]\) to use the specified JVM as the default Java runtime."
JLink`$FrontEndInitializationFunction::usage = "$FrontEndInitializationFunction is a function that you can assign to execute when the front end link is first established by \!\(\*RowBox[{\" ConnectToFrontEnd \", \"[\", \"]\"}]\)."
JLink`$FrontEndLaunchCommand::usage = "$FrontEndLaunchCommand specifies the command line that will be used by \!\(\*RowBox[{\" ConnectToFrontEnd \", \"[\", \"]\"}]\) to launch the front end."
JLink`$JavaExceptionHandler::usage = "$JavaExceptionHandler allows you to control how exceptions thrown in Java are handled in \!\(\*StyleBox[\" Mathematica \", FontSlant -> \" Italic \"]\)."
JLink`$RelaxedTypeChecking::usage = "$RelaxedTypeChecking is a flag that can be set to True to speed up the validation performed in \!\(\*StyleBox[\" Mathematica \", FontSlant -> \" Italic \"]\) (via pattern tests) on arrays of data being sent as arguments to Java calls. "
LinearRegression`BasisNames::usage = "BasisNames is an option for Regress and DesignedRegress which specifies headings for basis functions in the output."
LinearRegression`DesignedRegress::usage = "\!\(\*RowBox[{\" DesignedRegress \", \"[\", RowBox[{StyleBox[\" matrix \", \" TI \"], \",\", StyleBox[\" vector \", \" TI \"]}], \"]\"}]\) finds a least\[Dash]squares fit given the design matrix \!\(\*StyleBox[\" matrix \", \" TI \"]\) and response vector \!\(\*StyleBox[\" vector \", \" TI \"]\).\n\!\(\*RowBox[{\" DesignedRegress \", \"[\", RowBox[{StyleBox[\" svd \", \" TI \"], \",\", StyleBox[\" vector \", \" TI \"]}], \"]\"}]\) finds a fit given the singular value decomposition \!\(\*StyleBox[\" svd \", \" TI \"]\) of a design matrix."
LinearRegression`DesignMatrix::usage = "\!\(\*RowBox[{\" DesignMatrix \", \"[\", RowBox[{StyleBox[\" data \", \" TI \"], \",\", StyleBox[\" funs \", \" TI \"], \",\", StyleBox[\" vars \", \" TI \"]}], \"]\"}]\) gives the design matrix for \!\(\*StyleBox[\" data \", \" TI \"]\) as a linear combination of the functions \!\(\*StyleBox[\" funs \", \" TI \"]\) of the variables \!\(\*StyleBox[\" vars \", \" TI \"]\)."
LinearRegression`IncludeConstant::usage = "IncludeConstant is an option for Regress and DesignMatrix that specifies whether a constant term is automatically included in the model."
LinearRegression`Regress::usage = "\!\(\*RowBox[{\" Regress \", \"[\", RowBox[{StyleBox[\" data \", \" TI \"], \",\", StyleBox[\" funs \", \" TI \"], \",\", StyleBox[\" vars \", \" TI \"]}], \"]\"}]\) finds a least\[Dash]squares fit to a list of \!\(\*StyleBox[\" data \", \" TI \"]\) as a linear combination of the functions \!\(\*StyleBox[\" funs \", \" TI \"]\) of variables \!\(\*StyleBox[\" vars \", \" TI \"]\)."
MultivariateStatistics`EllipsoidProbability::usage = "\!\(\*RowBox[{\" EllipsoidProbability \", \"[\", RowBox[{StyleBox[\" dist \", \" TI \"], \",\", StyleBox[\" ellipse \", \" TI \"]}], \"]\"}]\) gives the cumulative probability of \!\(\*StyleBox[\" dist \", \" TI \"]\) over \!\(\*StyleBox[\" ellipse \", \" TI \"]\) centered at the mean of \!\(\*StyleBox[\" dist \", \" TI \"]\)."
MultivariateStatistics`EllipsoidQuantile::usage = "\!\(\*RowBox[{\" EllipsoidQuantile \", \"[\", RowBox[{StyleBox[\" matrix \", \" TI \"], \",\", StyleBox[\" q \", \" TI \"]}], \"]\"}]\) gives the ellipsoidal locus of the \!\(\*StyleBox[\" q \", \" TI \"]\)\!\(\*SuperscriptBox[\" \[Null] \", \" th \"]\) quantile of \!\(\*StyleBox[\" matrix \", \" TI \"]\).\n\!\(\*RowBox[{\" EllipsoidQuantile \", \"[\", RowBox[{StyleBox[\" matrix \", \" TI \"], \",\", RowBox[{\" {\", RowBox[{SubscriptBox[StyleBox[\" q \", \" TI \"], StyleBox[\" 1\", \" TR \"]], \",\", SubscriptBox[StyleBox[\" q \", \" TI \"], StyleBox[\" 2\", \" TR \"]], \",\", StyleBox[\" \[Ellipsis] \", \" TR \"]}], \"}\"}]}], \"]\"}]\) gives ellipsoidal loci for multiple quantiles \!\(\*SubscriptBox[StyleBox[\" q \", \" TI \"], StyleBox[\" 1\", \" TR \"]]\), \!\(\*SubscriptBox[StyleBox[\" q \", \" TI \"], StyleBox[\" 2\", \" TR \"]]\), \[Ellipsis]."
MultivariateStatistics`EllipsoidQuartiles::usage = "\!\(\*RowBox[{\" EllipsoidQuartiles \", \"[\", StyleBox[\" matrix \", \" TI \"], \"]\"}]\) gives the ellipsoidal loci of the quartiles of \!\(\*StyleBox[\" matrix \", \" TI \"]\)."
MultivariateStatistics`GeneralizedVariance::usage = "\!\(\*RowBox[{\" GeneralizedVariance \", \"[\", StyleBox[\" matrix \", \" TI \"], \"]\"}]\) gives the generalized variance for \!\(\*StyleBox[\" matrix \", \" TI \"]\)."
MultivariateStatistics`KendallRankCorrelation::usage = "\!\(\*RowBox[{\" KendallRankCorrelation \", \"[\", RowBox[{StyleBox[\" xlist \", \" TI \"], \",\", StyleBox[\" ylist \", \" TI \"]}], \"]\"}]\) gives Kendall's rank correlation coefficient \[Tau] for the real-valued vectors \!\(\*StyleBox[\" xlist \", \" TI \"]\) and \!\(\*StyleBox[\" ylist \", \" TI \"]\)."
MultivariateStatistics`MedianMethod::usage = "MedianMethod is an option for MultivariateMedianDeviation that specifies the multivariate median to use."
MultivariateStatistics`MultiPoissonDistribution::usage = "\!\(\*RowBox[{\" MultiPoissonDistribution \", \"[\", RowBox[{SubscriptBox[StyleBox[\" \[Mu] \", \" TR \"], StyleBox[\" 0\", \" TR \"]], \",\", StyleBox[\" \[Mu] \", \" TR \"]}], \"]\"}]\) represents a multivariate Poisson distribution with mean vector \!\(\*RowBox[{SubscriptBox[StyleBox[\" \[Mu] \", \" TR \"], StyleBox[\" 0\", \" TR \"]], \"+\", StyleBox[\" \[Mu] \", \" TR \"]}]\)."
MultivariateStatistics`MultivariateKurtosis::usage = "\!\(\*RowBox[{\" MultivariateKurtosis \", \"[\", StyleBox[\" matrix \", \" TI \"], \"]\"}]\) gives a multivariate kurtosis coefficient for \!\(\*StyleBox[\" matrix \", \" TI \"]\)."
MultivariateStatistics`MultivariateMeanDeviation::usage = "\!\(\*RowBox[{\" MultivariateMeanDeviation \", \"[\", StyleBox[\" matrix \", \" TI \"], \"]\"}]\) gives the mean of the Euclidean distances between the elements of \!\(\*StyleBox[\" matrix \", \" TI \"]\) and their mean."
MultivariateStatistics`MultivariateMedianDeviation::usage = "\!\(\*RowBox[{\" MultivariateMedianDeviation \", \"[\", StyleBox[\" matrix \", \" TI \"], \"]\"}]\) gives the median Euclidean distance from the median of the elements in \!\(\*StyleBox[\" matrix \", \" TI \"]\)."
MultivariateStatistics`MultivariateSkewness::usage = "\!\(\*RowBox[{\" MultivariateSkewness \", \"[\", StyleBox[\" matrix \", \" TI \"], \"]\"}]\) gives a multivariate coefficient of skewness for \!\(\*StyleBox[\" matrix \", \" TI \"]\)."
MultivariateStatistics`MultivariateTrimmedMean::usage = "\!\(\*RowBox[{\" MultivariateTrimmedMean \", \"[\", RowBox[{StyleBox[\" matrix \", \" TI \"], \",\", StyleBox[\" f \", \" TI \"]}], \"]\"}]\) gives the mean of the bivariate data \!\(\*StyleBox[\" matrix \", \" TI \"]\) after dropping a fraction \!\(\*StyleBox[\" f \", \" TI \"]\) of the outermost vectors. "
MultivariateStatistics`Polytope::usage = "\!\(\*RowBox[{\" Polytope \", \"[\", RowBox[{RowBox[{\" {\", RowBox[{SubscriptBox[StyleBox[\" v \", \" TI \"], StyleBox[\" 1\", \" TR \"]], \",\", SubscriptBox[StyleBox[\" v \", \" TI \"], StyleBox[\" 2\", \" TR \"]], \",\", StyleBox[\" \[Ellipsis] \", \" TR \"]}], \"}\"}], \",\", StyleBox[\" connectivity \", \" TI \"]}], \"]\"}]\) represents a \!\(\*StyleBox[\" p \", \" TI \"]\)-dimensional polytope with \!\(\*StyleBox[\" p \", \" TI \"]\)-variate vertices \!\(\*RowBox[{SubscriptBox[StyleBox[\" v \", \" TI \"], StyleBox[\" 1\", \" TR \"]], \",\", SubscriptBox[StyleBox[\" v \", \" TI \"], StyleBox[\" 2\", \" TR \"]], \",\", StyleBox[\" \[Ellipsis] \", \" TR \"]}]\), where the connections between the vertices is specified by \!\(\*StyleBox[\" connectivity \", \" TI \"]\)."
MultivariateStatistics`PolytopeQuantile::usage = "\!\(\*RowBox[{\" PolytopeQuantile \", \"[\", RowBox[{RowBox[{\" {\", RowBox[{RowBox[{\" {\", RowBox[{SubscriptBox[StyleBox[\" x \", \" TI \"], StyleBox[\" 11\", \" TR \"]], \",\", SubscriptBox[StyleBox[\" x \", \" TI \"], StyleBox[\" 12\", \" TR \"]]}], \"}\"}], \",\", StyleBox[\" \[Ellipsis] \", \" TI \"], \",\", RowBox[{\" {\", RowBox[{SubscriptBox[StyleBox[\" x \", \" TI \"], RowBox[{StyleBox[\" n \", \" TI \"], \"\", StyleBox[\" 1\", \" TR \"]}]], \",\", SubscriptBox[StyleBox[\" x \", \" TI \"], RowBox[{StyleBox[\" n \", \" TI \"], \"\", StyleBox[\" 2\", \" TR \"]}]]}], \"}\"}]}], \"}\"}], \",\", StyleBox[\" q \", \" TI \"]}], \"]\"}]\) gives the locus of the \!\(\*StyleBox[\" q \", \" TI \"]\)\!\(\*SuperscriptBox[\" \[Null] \", \" th \"]\) quantile of the bivariate data, where the data have been ordered using convex hulls centered on \!\(\*RowBox[{\" ConvexHullMedian \", \"[\", RowBox[{\" {\", RowBox[{RowBox[{\" {\", RowBox[{SubscriptBox[StyleBox[\" x \", \" TI \"], StyleBox[\" 11\", \" TR \"]], \",\", SubscriptBox[StyleBox[\" x \", \" TI \"], StyleBox[\" 12\", \" TR \"]]}], \"}\"}], \",\", StyleBox[\" \[Ellipsis] \", \" TI \"], \",\", RowBox[{\" {\", RowBox[{SubscriptBox[StyleBox[\" x \", \" TI \"], RowBox[{StyleBox[\" n \", \" TI \"], \"\", StyleBox[\" 1\", \" TR \"]}]], \",\", SubscriptBox[StyleBox[\" x \", \" TI \"], RowBox[{StyleBox[\" n \", \" TI \"], \"\", StyleBox[\" 2\", \" TR \"]}]]}], \"}\"}]}], \"}\"}], \"]\"}]\)."
MultivariateStatistics`PolytopeQuartiles::usage = "\!\(\*RowBox[{\" PolytopeQuartiles \", \"[\", RowBox[{\" {\", RowBox[{SubscriptBox[StyleBox[\" x \", \" TI \"], StyleBox[\" 1\", \" TR \"]], \",\", StyleBox[\" \[Ellipsis] \", \" TR \"], \",\", SubscriptBox[StyleBox[\" x \", \" TI \"], StyleBox[\" n \", \" TI \"]]}], \"}\"}], \"]\"}]\) gives a list of the loci of the quartiles of the bivariate data \!\(\*RowBox[{SubscriptBox[StyleBox[\" x \", \" TI \"], StyleBox[\" 1\", \" TR \"]], \",\", SubscriptBox[StyleBox[\" x \", \" TI \"], StyleBox[\" 2\", \" TR \"]], \",\", StyleBox[\" \[Ellipsis] \", \" TR \"]}]\), where the data have been ordered using convex hulls centered on \!\(\*RowBox[{\" ConvexHullMedian \", \"[\", RowBox[{\" {\", RowBox[{SubscriptBox[StyleBox[\" x \", \" TI \"], StyleBox[\" 1\", \" TR \"]], \",\", StyleBox[\" \[Ellipsis] \", \" TR \"], \",\", SubscriptBox[StyleBox[\" x \", \" TI \"], StyleBox[\" n \", \" TI \"]]}], \"}\"}], \"]\"}]\)."
MultivariateStatistics`QuadraticFormDistribution::usage = "\!\(\*RowBox[{\" QuadraticFormDistribution \", \"[\", RowBox[{RowBox[{\" {\", RowBox[{StyleBox[\" a \", \" TI \"], \",\", StyleBox[\" b \", \" TI \"], \",\", StyleBox[\" c \", \" TI \"]}], \"}\"}], \",\", RowBox[{\" {\", RowBox[{StyleBox[\" \[Mu] \", \" TR \"], \",\", StyleBox[\" \[CapitalSigma] \", \" TR \"]}], \"}\"}]}], \"]\"}]\) represents the distribution of a quadratic form \!\(\*RowBox[{RowBox[{StyleBox[\" z \", \" TI \"], \".\", StyleBox[\" a \", \" TI \"], \".\", StyleBox[\" z \", \" TI \"]}], \"+\", RowBox[{StyleBox[\" b \", \" TI \"], \".\", StyleBox[\" z \", \" TI \"]}], \"+\", StyleBox[\" c \", \" TI \"]}]\) for multivariate normal \!\(\*StyleBox[\" z \", \" TI \"]\)."
MultivariateStatistics`SimplexMedian::usage = "\!\(\*RowBox[{\" SimplexMedian \", \"[\", StyleBox[\" matrix \", \" TI \"], \"]\"}]\) gives a simplex median of the elements in \!\(\*StyleBox[\" matrix \", \" TI \"]\)."
MultivariateStatistics`SpatialMedian::usage = "\!\(\*RowBox[{\" SpatialMedian \", \"[\", StyleBox[\" matrix \", \" TI \"], \"]\"}]\) gives the spatial median of the elements in \!\(\*StyleBox[\" matrix \", \" TI \"]\)."
MultivariateStatistics`SpearmanRankCorrelation::usage = "\!\(\*RowBox[{\" SpearmanRankCorrelation \", \"[\", RowBox[{StyleBox[\" xlist \", \" TI \"], \",\", StyleBox[\" ylist \", \" TI \"]}], \"]\"}]\) gives Spearman's rank correlation coefficient \!\(\*StyleBox[\" \[Rho] \", \" TR \"]\) for the real-valued vectors \!\(\*StyleBox[\" xlist \", \" TI \"]\) and \!\(\*StyleBox[\" ylist \", \" TI \"]\)."
MultivariateStatistics`TotalVariation::usage = "\!\(\*RowBox[{\" TotalVariation \", \"[\", StyleBox[\" matrix \", \" TI \"], \"]\"}]\) gives the total variation for \!\(\*StyleBox[\" matrix \", \" TI \"]\)."
MultivariateStatistics`WishartDistribution::usage = "\!\(\*RowBox[{\" WishartDistribution \", \"[\", RowBox[{StyleBox[\" \[CapitalSigma] \", \" TR \"], \",\", StyleBox[\" m \", \" TI \"]}], \"]\"}]\) represents a Wishart distribution with scale matrix \!\(\*StyleBox[\" \[CapitalSigma] \", \" TR \"]\) and degrees of freedom parameter \!\(\*StyleBox[\" m \", \" TI \"]\)."
Music`A0::usage = "A0 gives the frequency of the note A in octave 0."
Music`A1::usage = "A1 gives the frequency of the note A in octave 1."
Music`A2::usage = "A2 gives the frequency of the note A in octave 2."
Music`A3::usage = "A3 gives the frequency of the note A in octave 3."
Music`A4::usage = "A4 gives the frequency of the note A in octave 4."
Music`A5::usage = "A5 gives the frequency of the note A in octave 5."
Music`A6::usage = "A6 gives the frequency of the note A in octave 6."
Music`A7::usage = "A7 gives the frequency of the note A in octave 7."
Music`Aflat0::usage = "Aflat0 gives the frequency of the note A-flat in octave 0."
Music`Aflat1::usage = "Aflat1 gives the frequency of the note A-flat in octave 1."
Music`Aflat2::usage = "Aflat2 gives the frequency of the note A-flat in octave 2."
Music`Aflat3::usage = "Aflat3 gives the frequency of the note A-flat in octave 3."
Music`Aflat4::usage = "Aflat4 gives the frequency of the note A-flat in octave 4."
Music`Aflat5::usage = "Aflat5 gives the frequency of the note A-flat in octave 5."
Music`Aflat6::usage = "Aflat6 gives the frequency of the note A-flat in octave 6."
Music`Aflat7::usage = "Aflat7 gives the frequency of the note A-flat in octave 7."
Music`Asharp0::usage = "Asharp0 gives the frequency of the note A-sharp in octave 0."
Music`Asharp1::usage = "Asharp1 gives the frequency of the note A-sharp in octave 1."
Music`Asharp2::usage = "Asharp2 gives the frequency of the note A-sharp in octave 2."
Music`Asharp3::usage = "Asharp3 gives the frequency of the note A-sharp in octave 3."
Music`Asharp4::usage = "Asharp4 gives the frequency of the note A-sharp in octave 4."
Music`Asharp5::usage = "Asharp5 gives the frequency of the note A-sharp in octave 5."
Music`Asharp6::usage = "Asharp6 gives the frequency of the note A-sharp in octave 6."
Music`Asharp7::usage = "Asharp7 gives the frequency of the note A-sharp in octave 7."
Music`B0::usage = "B0 gives the frequency of the note B in octave 0."
Music`B1::usage = "B1 gives the frequency of the note B in octave 1."
Music`B2::usage = "B2 gives the frequency of the note B in octave 2."
Music`B3::usage = "B3 gives the frequency of the note B in octave 3."
Music`B4::usage = "B4 gives the frequency of the note B in octave 4."
Music`B5::usage = "B5 gives the frequency of the note B in octave 5."
Music`B6::usage = "B6 gives the frequency of the note B in octave 6."
Music`B7::usage = "B7 gives the frequency of the note B in octave 7."
Music`Bflat0::usage = "Bflat0 gives the frequency of the note B-flat in octave 0."
Music`Bflat1::usage = "Bflat1 gives the frequency of the note B-flat in octave 1."
Music`Bflat2::usage = "Bflat2 gives the frequency of the note B-flat in octave 2."
Music`Bflat3::usage = "Bflat3 gives the frequency of the note B-flat in octave 3."
Music`Bflat4::usage = "Bflat4 gives the frequency of the note B-flat in octave 4."
Music`Bflat5::usage = "Bflat5 gives the frequency of the note B-flat in octave 5."
Music`Bflat6::usage = "Bflat6 gives the frequency of the note B-flat in octave 6."
Music`Bflat7::usage = "Bflat7 gives the frequency of the note B-flat in octave 7."
Music`Bsharp0::usage = "Bsharp0 gives the frequency of the note B-sharp in octave 0."
Music`Bsharp1::usage = "Bsharp1 gives the frequency of the note B-sharp in octave 1."
Music`Bsharp2::usage = "Bsharp2 gives the frequency of the note B-sharp in octave 2."
Music`Bsharp3::usage = "Bsharp3 gives the frequency of the note B-sharp in octave 3."
Music`Bsharp4::usage = "Bsharp4 gives the frequency of the note B-sharp in octave 4."
Music`Bsharp5::usage = "Bsharp5 gives the frequency of the note B-sharp in octave 5."
Music`Bsharp6::usage = "Bsharp6 gives the frequency of the note B-sharp in octave 6."
Music`Bsharp7::usage = "Bsharp7 gives the frequency of the note B-sharp in octave 7."
Music`C0::usage = "C0 gives the frequency of the note C in octave 0."
Music`C1::usage = "C1 gives the frequency of the note C in octave 1."
Music`C2::usage = "C2 gives the frequency of the note C in octave 2."
Music`C3::usage = "C3 gives the frequency of the note C in octave 3."
Music`C4::usage = "C4 gives the frequency of the note C in octave 4."
Music`C5::usage = "C5 gives the frequency of the note C in octave 5."
Music`C6::usage = "C6 gives the frequency of the note C in octave 6."
Music`C7::usage = "C7 gives the frequency of the note C in octave 7."
Music`CentsToHertz::usage = "\!\(\*RowBox[{\" CentsToHertz \", \"[\", RowBox[{\" {\", RowBox[{SubscriptBox[StyleBox[\" i \", \" TI \"], StyleBox[\" 1\", \" TR \"]], \",\", SubscriptBox[StyleBox[\" i \", \" TI \"], StyleBox[\" 2\", \" TR \"]], \",\", StyleBox[\" \[Ellipsis] \", \" TR \"]}], \"}\"}], \"]\"}]\) converts a list of intervals \!\(\*RowBox[{SubscriptBox[StyleBox[\" i \", \" TI \"], StyleBox[\" 1\", \" TR \"]], \",\", SubscriptBox[StyleBox[\" i \", \" TI \"], StyleBox[\" 2\", \" TR \"]], \",\", StyleBox[\" \[Ellipsis] \", \" TR \"]}]\), measured in cents to a list of frequencies measured in Hertz, beginning at 440 Hertz.\n\!\(\*RowBox[{\" CentsToHertz \", \"[\", RowBox[{RowBox[{\" {\", RowBox[{SubscriptBox[StyleBox[\" i \", \" TI \"], StyleBox[\" 1\", \" TR \"]], \",\", SubscriptBox[StyleBox[\" i \", \" TI \"], StyleBox[\" 2\", \" TR \"]], \",\", StyleBox[\" \[Ellipsis] \", \" TR \"]}], \"}\"}], \",\", StyleBox[\" freq \", \" TI \"]}], \"]\"}]\) gives a list of frequencies beginning at frequency \!\(\*StyleBox[\" freq \", \" TI \"]\)."
Music`Cflat0::usage = "Cflat0 gives the frequency of the note C-flat in octave 0."
Music`Cflat1::usage = "Cflat1 gives the frequency of the note C-flat in octave 1."
Music`Cflat2::usage = "Cflat2 gives the frequency of the note C-flat in octave 2."
Music`Cflat3::usage = "Cflat3 gives the frequency of the note C-flat in octave 3."
Music`Cflat4::usage = "Cflat4 gives the frequency of the note C-flat in octave 4."
Music`Cflat5::usage = "Cflat5 gives the frequency of the note C-flat in octave 5."
Music`Cflat6::usage = "Cflat6 gives the frequency of the note C-flat in octave 6."
Music`Cflat7::usage = "Cflat7 gives the frequency of the note C-flat in octave 7."
Music`Csharp0::usage = "Csharp0 gives the frequency of the note C-sharp in octave 0."
Music`Csharp1::usage = "Csharp1 gives the frequency of the note C-sharp in octave 1."
Music`Csharp2::usage = "Csharp2 gives the frequency of the note C-sharp in octave 2."
Music`Csharp3::usage = "Csharp3 gives the frequency of the note C-sharp in octave 3."
Music`Csharp4::usage = "Csharp4 gives the frequency of the note C-sharp in octave 4."
Music`Csharp5::usage = "Csharp5 gives the frequency of the note C-sharp in octave 5."
Music`Csharp6::usage = "Csharp6 gives the frequency of the note C-sharp in octave 6."
Music`Csharp7::usage = "Csharp7 gives the frequency of the note C-sharp in octave 7."
Music`D0::usage = "D0 gives the frequency of the note D in octave 0."
Music`D1::usage = "D1 gives the frequency of the note D in octave 1."
Music`D2::usage = "D2 gives the frequency of the note D in octave 2."
Music`D3::usage = "D3 gives the frequency of the note D in octave 3."
Music`D4::usage = "D4 gives the frequency of the note D in octave 4."
Music`D5::usage = "D5 gives the frequency of the note D in octave 5."
Music`D6::usage = "D6 gives the frequency of the note D in octave 6."
Music`D7::usage = "D7 gives the frequency of the note D in octave 7."
Music`Dflat0::usage = "Dflat0 gives the frequency of the note D-flat in octave 0."
Music`Dflat1::usage = "Dflat1 gives the frequency of the note D-flat in octave 1."
Music`Dflat2::usage = "Dflat2 gives the frequency of the note D-flat in octave 2."
Music`Dflat3::usage = "Dflat3 gives the frequency of the note D-flat in octave 3."
Music`Dflat4::usage = "Dflat4 gives the frequency of the note D-flat in octave 4."
Music`Dflat5::usage = "Dflat5 gives the frequency of the note D-flat in octave 5."
Music`Dflat6::usage = "Dflat6 gives the frequency of the note D-flat in octave 6."
Music`Dflat7::usage = "Dflat7 gives the frequency of the note D-flat in octave 7."
Music`Dsharp0::usage = "Dsharp0 gives the frequency of the note D-sharp in octave 0. "
Music`Dsharp1::usage = "Dsharp1 gives the frequency of the note D-sharp in octave 1."
Music`Dsharp2::usage = "Dsharp2 gives the frequency of the note D-sharp in octave 2."
Music`Dsharp3::usage = "Dsharp3 gives the frequency of the note D-sharp in octave 3."
Music`Dsharp4::usage = "Dsharp4 gives the frequency of the note D-sharp in octave 4."
Music`Dsharp5::usage = "Dsharp5 gives the frequency of the note D-sharp in octave 5."
Music`Dsharp6::usage = "Dsharp6 gives the frequency of the note D-sharp in octave 6."
Music`Dsharp7::usage = "Dsharp7 gives the frequency of the note D-sharp in octave 7."
Music`E0::usage = "E0 gives the frequency of the note E in octave 0."
Music`E1::usage = "E1 gives the frequency of the note E in octave 1."
Music`E2::usage = "E2 gives the frequency of the note E in octave 2."
Music`E3::usage = "E3 gives the frequency of the note E in octave 3."
Music`E4::usage = "E4 gives the frequency of the note E in octave 4."
Music`E5::usage = "E5 gives the frequency of the note E in octave 5."
Music`E6::usage = "E6 gives the frequency of the note E in octave 6."
Music`E7::usage = "E7 gives the frequency of the note E in octave 7."
Music`Eflat0::usage = "Eflat0 gives the frequency of the note E-flat in octave 0."
Music`Eflat1::usage = "Eflat1 gives the frequency of the note E-flat in octave 1."
Music`Eflat2::usage = "Eflat2 gives the frequency of the note E-flat in octave 2."
Music`Eflat3::usage = "Eflat3 gives the frequency of the note E-flat in octave 3."
Music`Eflat4::usage = "Eflat4 gives the frequency of the note E-flat in octave 4."
Music`Eflat5::usage = "Eflat5 gives the frequency of the note E-flat in octave 5."
Music`Eflat6::usage = "Eflat6 gives the frequency of the note E-flat in octave 6."
Music`Eflat7::usage = "Eflat7 gives the frequency of the note E-flat in octave 7."
Music`Esharp0::usage = "Esharp0 gives the frequency of the note E-sharp in octave 0."
Music`Esharp1::usage = "Esharp1 gives the frequency of the note E-sharp in octave 1."
Music`Esharp2::usage = "Esharp2 gives the frequency of the note E-sharp in octave 2."
Music`Esharp3::usage = "Esharp3 gives the frequency of the note E-sharp in octave 3."
Music`Esharp4::usage = "Esharp4 gives the frequency of the note E-sharp in octave 4."
Music`Esharp5::usage = "Esharp5 gives the frequency of the note E-sharp in octave 5."
Music`Esharp6::usage = "Esharp6 gives the frequency of the note E-sharp in octave 6."
Music`Esharp7::usage = "Esharp7 gives the frequency of the note E-sharp in octave 7."
Music`F0::usage = "F0 gives the frequency of the note F in octave 0."
Music`F1::usage = "F1 gives the frequency of the note F in octave 1."
Music`F2::usage = "F2 gives the frequency of the note F in octave 2."
Music`F3::usage = "F3 gives the frequency of the note F in octave 3."
Music`F4::usage = "F4 gives the frequency of the note F in octave 4."
Music`F5::usage = "F5 gives the frequency of the note F in octave 5."
Music`F6::usage = "F6 gives the frequency of the note F in octave 6."
Music`F7::usage = "F7 gives the frequency of the note F in octave 7."
Music`Fflat0::usage = "Fflat0 gives the frequency of the note F-flat in octave 0."
Music`Fflat1::usage = "Fflat1 gives the frequency of the note F-flat in octave 1."
Music`Fflat2::usage = "Fflat2 gives the frequency of the note F-flat in octave 2."
Music`Fflat3::usage = "Fflat3 gives the frequency of the note F-flat in octave 3."
Music`Fflat4::usage = "Fflat4 gives the frequency of the note F-flat in octave 4."
Music`Fflat5::usage = "Fflat5 gives the frequency of the note F-flat in octave 5."
Music`Fflat6::usage = "Fflat6 gives the frequency of the note F-flat in octave 6."
Music`Fflat7::usage = "Fflat7 gives the frequency of the note F-flat in octave 7."
Music`Fsharp0::usage = "Fsharp0 gives the frequency of the note F-sharp in octave 0."
Music`Fsharp1::usage = "Fsharp1 gives the frequency of the note F-sharp in octave 1."
Music`Fsharp2::usage = "Fsharp2 gives the frequency of the note F-sharp in octave 2."
Music`Fsharp3::usage = "Fsharp3 gives the frequency of the note F-sharp in octave 3."
Music`Fsharp4::usage = "Fsharp4 gives the frequency of the note F-sharp in octave 4."
Music`Fsharp5::usage = "Fsharp5 gives the frequency of the note F-sharp in octave 5."
Music`Fsharp6::usage = "Fsharp6 gives the frequency of the note F-sharp in octave 6."
Music`Fsharp7::usage = "Fsharp7 gives the frequency of the note F-sharp in octave 7."
Music`G0::usage = "G0 gives the frequency of the note G in octave 0."
Music`G1::usage = "G1 gives the frequency of the note G in octave 1."
Music`G2::usage = "G2 gives the frequency of the note G in octave 2."
Music`G3::usage = "G3 gives the frequency of the note G in octave 3."
Music`G4::usage = "G4 gives the frequency of note G in octave 4."
Music`G5::usage = "G5 gives the frequency of the note G in octave 5."
Music`G6::usage = "G6 gives the frequency of the note G in octave 6."
Music`G7::usage = "G7 gives the frequency of the note G in octave 7."
Music`Gflat0::usage = "Gflat0 gives the frequency of the note G-flat in octave 0."
Music`Gflat1::usage = "Gflat1 gives the frequency of the note G-flat in octave 1."
Music`Gflat2::usage = "Gflat2 gives the frequency of the note G-flat in octave 2."
Music`Gflat3::usage = "Gflat3 gives the frequency of the note G-flat in octave 3."
Music`Gflat4::usage = "Gflat4 gives the frequency of the note G-flat in octave 4."
Music`Gflat5::usage = "Gflat5 gives the frequency of the note G-flat in octave 5."
Music`Gflat6::usage = "Gflat6 gives the frequency of the note G-flat in octave 6."
Music`Gflat7::usage = "Gflat7 gives the frequency of the note G-flat in octave 7."
Music`Gsharp0::usage = "Gsharp0 gives the frequency of the note G-sharp in octave 0."
Music`Gsharp1::usage = "Gsharp1 gives the frequency of the note G-sharp in octave 1."
Music`Gsharp2::usage = "Gsharp2 gives the frequency of the note G-sharp in octave 2."
Music`Gsharp3::usage = "Gsharp3 gives the frequency of the note G-sharp in octave 3."
Music`Gsharp4::usage = "Gsharp4 gives the frequency of the note G-sharp in octave 4."
Music`Gsharp5::usage = "Gsharp5 gives the frequency of the note G-sharp in octave 5."
Music`Gsharp6::usage = "Gsharp6 gives the frequency of the note G-sharp in octave 6."
Music`Gsharp7::usage = "Gsharp7 gives the frequency of the note G-sharp in octave 7."
Music`HertzToCents::usage = "\!\(\*RowBox[{\" HertzToCents \", \"[\", RowBox[{\" {\", RowBox[{SubscriptBox[StyleBox[\" freq \", \" TI \"], StyleBox[\" 1\", \" TR \"]], \",\", SubscriptBox[StyleBox[\" freq \", \" TI \"], StyleBox[\" 2\", \" TR \"]], \",\", StyleBox[\" \[Ellipsis] \", \" TR \"]}], \"}\"}], \"]\"}]\) converts a list of frequencies \!\(\*RowBox[{SubscriptBox[StyleBox[\" freq \", \" TI \"], StyleBox[\" 1\", \" TR \"]], \",\", SubscriptBox[StyleBox[\" freq \", \" TI \"], StyleBox[\" 2\", \" TR \"]], \",\", StyleBox[\" \[Ellipsis] \", \" TR \"]}]\), measured in Hertz to a list of intervals measured in cents."
Music`JustMajor::usage = "JustMajor is an interval list for the Just Major scale."
Music`JustMinor::usage = "JustMinor is an interval list for the minor version of the Just Major scale."
Music`MeanChromatic::usage = "MeanChromatic is an interval list for the Mean Chromatic scale."
Music`MeanMajor::usage = "MeanMajor is an interval list derived from the Mean Chromatic scale."
Music`MeanMinor::usage = "MeanMinor is an interval list derived from the Mean Chromatic scale."
Music`MusicScale::usage = "\!\(\*RowBox[{\" MusicScale \", \"[\", RowBox[{RowBox[{\" {\", RowBox[{SubscriptBox[StyleBox[\" i \", \" TI \"], StyleBox[\" 1\", \" TR \"]], \",\", SubscriptBox[StyleBox[\" i \", \" TI \"], StyleBox[\" 2\", \" TR \"]], \",\", StyleBox[\" \[Ellipsis] \", \" TR \"]}], \"}\"}], \",\", StyleBox[\" freq \", \" TI \"], \",\", StyleBox[\" dur \", \" TI \"]}], \"]\"}]\) creates a Sound object that is a sequence of pitches corresponding to numbers \!\(\*RowBox[{SubscriptBox[StyleBox[\" i \", \" TI \"], StyleBox[\" 1\", \" TR \"]], \",\", SubscriptBox[StyleBox[\" i \", \" TI \"], StyleBox[\" 2\", \" TR \"]], \",\", StyleBox[\" \[Ellipsis] \", \" TR \"]}]\), a list of intervals measured in cents, starting at \!\(\*StyleBox[\" freq \", \" TI \"]\) Hertz and lasting \!\(\*StyleBox[\" dur \", \" TI \"]\) seconds."
Music`PythagoreanChromatic::usage = "PythagoreanChromatic is an interval list for the Pythagorean Chromatic scale."
Music`PythagoreanMajor::usage = "PythagoreanMajor is an interval list for the Pythagorean Major scale."
Music`QuarterTone::usage = "QuarterTone is an interval list in which each semitone (100 cents) is split in two."
Music`SixthTone::usage = "SixthTone is an interval list in which each semitone (100 cents) is split in three."
Music`TemperedChromatic::usage = "TemperedChromatic is an interval list corresponding to an equal tempered scale. "
Music`TemperedMajor::usage = "TemperedMajor is an interval list derived from the Tempered Chromatic scale."
Music`TemperedMinor::usage = "TemperedMinor is an interval list derived from the Tempered Chromatic scale."
NETLink`ActivateWindow::usage = "ActivateWindow is an option to DoNETModeless that specifies whether to make the window visible."
NETLink`AddEventHandler::usage = "\!\(\*RowBox[{\" AddEventHandler \", \"[\", RowBox[{StyleBox[RowBox[{\" obj \", \"@\", \" event \"}], \" TI \"], \",\", StyleBox[\" func \", \" TI \"]}], \"]\"}]\) assigns the specified \!\(\*StyleBox[\" Mathematica \", FontSlant -> \" Italic \"]\) function \!\(\*StyleBox[\" func \", \" TI \"]\) to be called when the given event \!\(\*StyleBox[\" event \", \" TI \"]\) fires."
NETLink`AllowShortContext::usage = "AllowShortContext is an option to LoadJavaClass (in \!\(\*StyleBox[\" J/Link\", FontSlant -> \" Italic \"]\)) and LoadNETType (in \!\(\*StyleBox[\".NET/Link\", FontSlant -> \" Italic \"]\)) that specifies whether the class-specific context in which static method and field definitions are created should be placed on $ContextPath."
NETLink`BeginNETBlock::usage = "\!\(\*RowBox[{\" BeginNETBlock \", \"[\", \"]\"}]\) and \!\(\*RowBox[{\" EndNETBlock \", \"[\", \"]\"}]\) are equivalent to the NETBlock function, except that they work across a larger span than the evaluation of a single expression."
NETLink`CallingConvention::usage = "CallingConvention is an option to DefineDLLFunction that specifies what calling convention the DLL function uses."
NETLink`CastNETObject::usage = "\!\(\*RowBox[{\" CastNETObject \", \"[\", RowBox[{StyleBox[\" obj \", \" TI \"], \",\", StyleBox[\" type \", \" TI \"]}], \"]\"}]\) casts the specified object to a different type."
NETLink`CreateCOMObject::usage = "\!\(\*RowBox[{\" CreateCOMObject \", \"[\", StyleBox[\" str \", \" TI \"], \"]\"}]\) creates a COM object specified by the string \!\(\*StyleBox[\" str \", \" TI \"]\)."
NETLink`DefineDLLFunction::usage = "\!\(\*RowBox[{\" DefineDLLFunction \", \"[\", RowBox[{StyleBox[\" \\ \" \\!\\ (\\*StyleBox[\\ \" func \\ \",\\ \" TI \\ \"]\\)\\ \" \", ShowStringCharacters->True], \",\", StyleBox[\" \\ \" \\!\\ (\\*StyleBox[\\ \" dll \\ \",\\ \" TI \\ \"]\\)\\ \" \", ShowStringCharacters->True], \",\", StyleBox[\" rtype \", \" TI \"], \",\", StyleBox[\" atypes \", \" TI \"]}], \"]\"}]\) returns a \!\(\*StyleBox[\" Mathematica \", FontSlant -> \" Italic \"]\) function that calls the specified function \!\(\*StyleBox[\" func \", \" TI \"]\) with argument types \!\(\*StyleBox[\" atypes \", \" TI \"]\) and return type \!\(\*StyleBox[\" rtype \", \" TI \"]\) in the specified unmanaged DLL \!\(\*StyleBox[\" dll \", \" TI \"]\).\n\!\(\*RowBox[{\" DefineDLLFunction \", \"[\", StyleBox[\" \\ \" \\!\\ (\\*StyleBox[\\ \" declaration \\ \",\\ \" TI \\ \"]\\)\\ \" \", ShowStringCharacters->True], \"]\"}]\) lets you write a full C #-syntax \!\(\*StyleBox[\"'extern'\", \" InlineCode \"]\) function declaration. Use this form when you need to write a complex function declaration that requires features not available using options to DefineDLLFunction, such as specific \!\(\*StyleBox[StyleBox[\" \\ \" MarshalAs \\ \" \",ShowStringCharacters->True], \" InlineCode \"]\) attributes on each of the parameters."
NETLink`DefineNETDelegate::usage = "\!\(\*RowBox[{\" DefineNETDelegate \", \"[\", RowBox[{StyleBox[\" name \", \" TI \"], \",\", StyleBox[\" rtype \", \" TI \"], \",\", StyleBox[\" ptypes \", \" TI \"]}], \"]\"}]\) creates a new .NET delegate type with the given name \!\(\*StyleBox[\" name \", \" TI \"]\), return type \!\(\*StyleBox[\" rtype \", \" TI \"]\), and parameter types \!\(\*StyleBox[\" ptypes \", \" TI \"]\)."
NETLink`DoNETModal::usage = "\!\(\*RowBox[{\" DoNETModal \", \"[\", StyleBox[\" form \", \" TI \"], \"]\"}]\) displays the specified .NET form in the foreground and does not return until the form window is closed.\n\!\(\*RowBox[{\" DoNETModal \", \"[\", RowBox[{StyleBox[\" form \", \" TI \"], \",\", \" \", StyleBox[\" expr \", \" TI \"]}], \"]\"}]\) evaluates \!\(\*StyleBox[\" expr \", \" TI \"]\) just before the form is closed and returns the result."
NETLink`DoNETModeless::usage = "\!\(\*RowBox[{\" DoNETModeless \", \"[\", StyleBox[\" form \", \" TI \"], \"]\"}]\) displays the specified .NET form in the foreground and then returns."
NETLink`EndNETBlock::usage = "\!\(\*RowBox[{\" EndNETBlock \", \"[\", \"]\"}]\) and a preceding BeginNETBlock are equivalent to the NETBlock function, except that they work across a larger span than the evaluation of a single expression."
NETLink`FixCRLF::usage = "\!\(\*RowBox[{\" FixCRLF \", \"[\", StyleBox[\" \\ \" \\!\\ (\\*StyleBox[\\ \" str \\ \",\\ \" TI \\ \"]\\)\\ \" \", ShowStringCharacters->True], \"]\"}]\) changes the linefeeds in the given string to the CR/LF Windows convention."
NETLink`FormStartPosition::usage = "FormStartPosition is an option to DoNETModal, DoNETModeless, ShowNETWindow, and ShowNETConsole that controls the onscreen location of the form when it first appears."
NETLink`GetActiveCOMObject::usage = "\!\(\*RowBox[{\" GetActiveCOMObject \", \"[\", StyleBox[\" string \", \" TI \"], \"]\"}]\) acquires an already-running COM object specified by \!\(\*StyleBox[\" string \", \" TI \"]\), which can be either a ProgID (such as \!\(\*StyleBox[\" \" Excel.Application\" \", \" InlineCode \"]\)) or a CLSID (such as \!\(\*StyleBox[\" \" {8E27C92B-1264-101C-8A2F-040224009C02}\" \", \" InlineCode \"]\))."
NETLink`GetAssemblyObject::usage = "\!\(\*RowBox[{\" GetAssemblyObject \", \"[\", StyleBox[\" asm \", \" TI \"], \"\", \"]\"}]\) returns the .NET Assembly object corresponding to the specified NETAssembly expression \!\(\*StyleBox[\" asm \", \" TI \"]\)."
NETLink`GetComplexType::usage = "\!\(\*RowBox[{\" GetComplexType \", \"[\", \"]\"}]\) returns the .NET type that is currently mapped to \!\(\*StyleBox[\" Mathematica \", FontSlant -> \" Italic \"]\) Complex numbers."
NETLink`GetNETException::usage = "\!\(\*RowBox[{\" GetNETException \", \"[\", \"]\"}]\) returns the .NET exception object that was thrown in the most recent call from \!\(\*StyleBox[\" Mathematica \", FontSlant -> \" Italic \"]\) to .NET."
NETLink`GetTypeObject::usage = "\!\(\*RowBox[{\" GetTypeObject \", \"[\", RowBox[{StyleBox[\" type \", \" TI \"], \"\", StyleBox[\" _ \", \" MR \"], StyleBox[\" NETType \", \" MR \"]}], \"]\"}]\) returns the .NET Type object corresponding to the specified NETType expression."
NETLink`InstallNET::usage = "\!\(\*RowBox[{\" InstallNET \", \"[\", \"]\"}]\) launches the .NET runtime and prepares it to be used from \!\(\*StyleBox[\" Mathematica \", FontSlant -> \" Italic \"]\)."
NETLink`InstanceOf::usage = "\!\(\*RowBox[{\" InstanceOf \", \"[\", RowBox[{StyleBox[\" netobject \", \" TI \"], \",\", \" \", StyleBox[\" nettype \", \" TI \"]}], \"]\"}]\) gives True if \!\(\*StyleBox[\" netobject \", \" TI \"]\) is an instance of the type \!\(\*StyleBox[\" nettype \", \" TI \"]\), or a subtype, and False otherwise."
NETLink`KeepNETObject::usage = "\!\(\*RowBox[{\" KeepNETObject \", \"[\", StyleBox[\" object \", \" TI \"], \"]\"}]\) causes the specified object (s) not to be released when the current NETBlock ends. \n\!\(\*RowBox[{\" KeepNETObject \", \"[\", RowBox[{StyleBox[\" object \", \" TI \"], StyleBox[\",\", \" TI \"], StyleBox[\" \", \" TI \"], \" Manual \"}], \"]\"}]\) causes the specified object to escape from all enclosing NETBlock expressions, meaning that the object will only be released if you manually call ReleaseNETObject."
NETLink`LanguageSyntax::usage = "LanguageSyntax is an option to NETTypeInfo that specifies which language syntax will be used to display the type information."
NETLink`LoadCOMTypeLibrary::usage = "\!\(\*RowBox[{\" LoadCOMTypeLibrary \", \"[\", StyleBox[\" library \", \" TI \"], \"]\"}]\) creates a so-called \" interop \" assembly from the named type library and loads that assembly. "
NETLink`LoadedNETAssemblies::usage = "\!\(\*RowBox[{\" LoadedNETAssemblies \", \"[\", \"]\"}]\) returns a list of all the .NET assemblies that have been loaded into the current session."
NETLink`LoadedNETObjects::usage = "\!\(\*RowBox[{\" LoadedNETObjects \", \"[\", \"]\"}]\) returns a list of all the .NET objects that have been loaded into the current session."
NETLink`LoadedNETTypes::usage = "\!\(\*RowBox[{\" LoadedNETTypes \", \"[\", \"]\"}]\) returns a list of all the .NET types that have been loaded into the current session."
NETLink`LoadNETAssembly::usage = "\!\(\*RowBox[{\" LoadNETAssembly \", \"[\", StyleBox[\" assembly \", \" TI \"], \"]\"}]\) loads the specified assembly into the .NET runtime and returns a NETAssembly expression that can be used to identify the assembly. \n\!\(\*RowBox[{\" LoadNETAssembly \", \"[\", StyleBox[\" \\ \" \\!\\ (\\*StyleBox[\\ \" directory \\ \",\\ \" TI \\ \"]\\)\\ \" \", ShowStringCharacters->True], \"]\"}]\) loads all the assemblies in the given directory and returns a list of NETAssembly expressions.\n\!\(\*RowBox[{\" LoadNETAssembly \", \"[\", StyleBox[\" \\ \" \\!\\ (\\*StyleBox[\\ \" context \\ \",\\ \" TI \\ \"]\\)` \\ \" \", ShowStringCharacters->True], \"]\"}]\) loads all the assemblies in the \" assembly \" subdirectory of the main application directory corresponding to the given context.\n\!\(\*RowBox[{\" LoadNETAssembly \", \"[\", RowBox[{StyleBox[\" \\ \" \\!\\ (\\*StyleBox[\\ \" name \\ \",\\ \" TI \\ \"]\\)\\ \" \", ShowStringCharacters->True], \",\", StyleBox[\" \\ \" \\!\\ (\\*StyleBox[\\ \" directory \\ \",\\ \" TI \\ \"]\\)\\ \" \", ShowStringCharacters->True]}], \"]\"}]\) loads the named assembly from the given directory, if possible. \n\!\(\*RowBox[{\" LoadNETAssembly \", \"[\", RowBox[{StyleBox[\" \\ \" \\!\\ (\\*StyleBox[\\ \" name \\ \",\\ \" TI \\ \"]\\)\\ \" \", ShowStringCharacters->True], \",\", StyleBox[\" \\ \" \\!\\ (\\*StyleBox[\\ \" context \\ \",\\ \" TI \\ \"]\\)` \\ \" \", ShowStringCharacters->True]}], \"]\"}]\) loads the named assembly from the \" assembly \" subdirectory of the main application directory corresponding to the given context, if possible."
NETLink`LoadNETType::usage = "\!\(\*RowBox[{\" LoadNETType \", \"[\", StyleBox[\" \\ \" \\!\\ (\\*StyleBox[\\ \" type \\ \",\\ \" TI \\ \"]\\)\\ \" \", ShowStringCharacters->True], \"]\"}]\) loads the specified type into the .NET runtime and returns a NETType expression that can be used to identify the type.\n\!\(\*RowBox[{\" LoadNETType \", \"[\", RowBox[{StyleBox[\" \\ \" \\!\\ (\\*StyleBox[\\ \" type \\ \",\\ \" TI \\ \"]\\)\\ \" \", ShowStringCharacters->True], \",\", \" \", StyleBox[\" assembly \", \" TI \"]}], \"]\"}]\) loads the type from the given assembly. "
NETLink`MakeNETObject::usage = "\!\(\*RowBox[{\" MakeNETObject \", \"[\", StyleBox[\" expr \", \" TI \"], \"]\"}]\) constructs a .NET object that represents the given \!\(\*StyleBox[\" Mathematica \", FontSlant -> \" Italic \"]\) expression. \n\!\(\*RowBox[{\" MakeNETObject \", \"[\", RowBox[{StyleBox[\" expr \", \" TI \"], \",\", \" \", StyleBox[\" type \", \" TI \"]}], \"]\"}]\) creates an object of the specified type from \!\(\*StyleBox[\" expr \", \" TI \"]\)."
NETLink`MarshalStringsAs::usage = "MarshalStringsAs is an option to DefineDLLFunction that specifies how string arguments should be marshaled into the DLL function. This applies to any arguments that are mapped to the System.String class, which includes types specified in your declaration as \" char*\", \" string \", or \" ByVal As String \"."
NETLink`NETAssembly::usage = "\!\(\*RowBox[{\" NETAssembly \", \"[\", RowBox[{StyleBox[\" \\ \" \\!\\ (\\*StyleBox[\\ \" name \\ \",\\ \" TI \\ \"]\\)\\ \" \", ShowStringCharacters->True], \",\", StyleBox[\" n \", \" TI \"]}], \"]\"}]\) represents a .NET assembly with the specified name."
NETLink`NETBlock::usage = "\!\(\*RowBox[{\" NETBlock \", \"[\", StyleBox[\" expr \", \" TI \"], \"]\"}]\) causes all new .NET objects returned to \!\(\*StyleBox[\" Mathematica \", FontSlant -> \" Italic \"]\) during the evaluation of \!\(\*StyleBox[\" expr \", \" TI \"]\) to be released when \!\(\*StyleBox[\" expr \", \" TI \"]\) finishes."
NETLink`NETLink::usage = "\!\(\*RowBox[{\" NETLink \", \"[\", \"]\"}]\) returns the \!\(\*StyleBox[\" MathLink \", FontSlant -> \" Italic \"]\) LinkObject that is used to communicate with the \!\(\*StyleBox[\".NET/Link\", FontSlant -> \" Italic \"]\) .NET runtime. "
NETLink`NETNewDelegate::usage = "\!\(\*RowBox[{\" NETNewDelegate \", \"[\", RowBox[{StyleBox[\" type \", \" TI \"], \",\", StyleBox[\" func \", \" TI \"]}], \"]\"}]\) creates a new instance of the specified .NET delegate type whose action is to call the named \!\(\*StyleBox[\" Mathematica \", FontSlant -> \" Italic \"]\) function when triggered."
NETLink`NETNew::usage = "\!\(\*RowBox[{\" NETNew \", \"[\", RowBox[{StyleBox[\" type \", \" TI \"], \",\", StyleBox[\" args \", \" TI \"]}], \"]\"}]\) constructs a new object of the specified .NET type, passing the supplied argument sequence to the constructor. \n\!\(\*RowBox[{\" NETNew \", \"[\", RowBox[{RowBox[{\" {\", RowBox[{StyleBox[\" \\ \" \\!\\ (\\*StyleBox[\\ \" type \\ \",\\ \" TI \\ \"]\\)\\ \" \", ShowStringCharacters->True], \",\", StyleBox[\" assembly \", \" TI \"]}], \"}\"}], \",\", StyleBox[\" args \", \" TI \"]}], \"]\"}]\) constructs the object from the named type in the specified assembly. \n\!\(\*RowBox[{\" NETNew \", \"[\", RowBox[{RowBox[{\" {\", RowBox[{StyleBox[\" \\ \" \\!\\ (\\*StyleBox[\\ \" type \\ \",\\ \" TI \\ \"]\\)\\ \" \", ShowStringCharacters->True], \",\", StyleBox[\" \\ \" \\!\\ (\\*StyleBox[\\ \" assembly \\ \",\\ \" TI \\ \"]\\)\\ \" \", ShowStringCharacters->True], \",\", StyleBox[\" \\ \" \\!\\ (\\*StyleBox[\\ \" dir \\ \",\\ \" TI \\ \"]\\)\\ \" \", ShowStringCharacters->True]}], \"}\"}], \",\", StyleBox[\" args \", \" TI \"]}], \"]\"}]\) uses the named assembly from the specified directory, if possible.\n\!\(\*RowBox[{\" NETNew \", \"[\", RowBox[{RowBox[{\" {\", RowBox[{StyleBox[\" \\ \" \\!\\ (\\*StyleBox[\\ \" type \\ \",\\ \" TI \\ \"]\\)\\ \" \", ShowStringCharacters->True], \",\", StyleBox[\" \\ \" \\!\\ (\\*StyleBox[\\ \" assembly \\ \",\\ \" TI \\ \"]\\)\\ \" \", ShowStringCharacters->True], \",\", StyleBox[\" \\ \" \\!\\ (\\*StyleBox[\\ \" context \\ \",\\ \" TI \\ \"]\\)\\ \" \", ShowStringCharacters->True]}], \"}\"}], \",\", StyleBox[\" args \", \" TI \"]}], \"]\"}]\) uses the named assembly from the \" assembly \" subdirectory of the main application directory corresponding to the given context, if possible."
NETLink`NETObjectQ::usage = "\!\(\*RowBox[{\" NETObjectQ \", \"[\", StyleBox[\" expr \", \" TI \"], \"]\"}]\) gives True if \!\(\*StyleBox[\" expr \", \" TI \"]\) is a valid reference to a .NET object, and False otherwise."
NETLink`NETObjectToExpression::usage = "\!\(\*RowBox[{\" NETObjectToExpression \", \"[\", StyleBox[\" netObject \", \" TI \"], \"]\"}]\) converts the specified .NET object reference into its value as a \" native \" \!\(\*StyleBox[\" Mathematica \", FontSlant -> \" Italic \"]\) expression. "
NETLink`NETTypeInfo::usage = "\!\(\*RowBox[{\" NETTypeInfo \", \"[\", StyleBox[\" type \", \" TI \"], \"]\"}]\) prints information about the specified type, including its inheritance hierarchy, assembly name, and its public members (constructors, methods, properties, and so on). \n\!\(\*RowBox[{\" NETTypeInfo \", \"[\", StyleBox[\" obj \", \" TI \"], \"]\"}]\) prints information about the object's type.\n\!\(\*RowBox[{\" NETTypeInfo \", \"[\", StyleBox[\" assembly \", \" TI \"], \"]\"}]\) prints information about the types in the assembly specified by the given NETAssembly expression.\n\!\(\*RowBox[{\" NETTypeInfo \", \"[\", RowBox[{StyleBox[\" type \", \" TI \"], \",\", StyleBox[\" members \", \" TI \"]}], \"]\"}]\) prints information about only the specified members, which can be any of the following strings (or a list of them): \" \!\(\*StyleBox[\" Type \", \" MR \"]\)\", \" \!\(\*StyleBox[\" Constructors \", \" MR \"]\)\", \" \!\(\*StyleBox[\" Methods \", \" MR \"]\)\", \" \!\(\*StyleBox[\" Fields \", \" MR \"]\)\", \" \!\(\*StyleBox[\" Properties \", \" MR \"]\)\", or \" \!\(\*StyleBox[\" Events \", \" MR \"]\)\". \n\!\(\*RowBox[{\" NETTypeInfo \", \"[\", RowBox[{StyleBox[\" type \", \" TI \"], \",\", StyleBox[\" members \", \" TI \"], \",\", StyleBox[\" pattern \", \" TI \"]}], \"]\"}]\) prints only the members whose names match the given string pattern."
NETLink`NETType::usage = "\!\(\*RowBox[{\" NETType \", \"[\", RowBox[{StyleBox[\" \\ \" \\!\\ (\\*StyleBox[\\ \" name \\ \",\\ \" TI \\ \"]\\)\\ \" \", ShowStringCharacters->True], \",\", StyleBox[\" n \", \" TI \"]}], \"]\"}]\) represents a .NET type with the specified name."
NETLink`NETUILink::usage = "\!\(\*RowBox[{\" NETUILink \", \"[\", \"]\"}]\) returns the \!\(\*StyleBox[\" MathLink \", FontSlant -> \" Italic \"]\) LinkObject used by calls to \!\(\*StyleBox[\" Mathematica \", FontSlant -> \" Italic \"]\) that originate from .NET user-interface actions, or Null if no such link is present."
NETLink`ReferencedAssemblies::usage = "ReferencedAssemblies is an option to DefineDLLFunction that specifies assemblies needed to compile your function declaration."
NETLink`ReinstallNET::usage = "\!\(\*RowBox[{\" ReinstallNET \", \"[\", \"]\"}]\) is a convenience function that calls \!\(\*RowBox[{\" UninstallNET \", \"[\", \"]\"}]\) and then \!\(\*RowBox[{\" InstallNET \", \"[\", \"]\"}]\)."
NETLink`ReleaseCOMObject::usage = "\!\(\*RowBox[{\" ReleaseCOMObject \", \"[\", StyleBox[\" obj \", \" TI \"], \"]\"}]\) releases COM resources held by the specified .NET object."
NETLink`ReleaseNETObject::usage = "\!\(\*RowBox[{\" ReleaseNETObject \", \"[\", StyleBox[\" obj \", \" TI \"], \"]\"}]\) tells the .NET memory-management system to forget any references to the specified NETObject that are being maintained solely for the sake of \!\(\*StyleBox[\" Mathematica \", FontSlant -> \" Italic \"]\)."
NETLink`RemoveEventHandler::usage = "\!\(\*RowBox[{\" RemoveEventHandler \", \"[\", RowBox[{StyleBox[RowBox[{\" obj \", \"@\", \" event \"}], \" TI \"], \",\", StyleBox[\" delegate \", \" TI \"]}], \"]\"}]\) removes the specified delegate from the named event."
NETLink`ReturnAsNETObject::usage = "\!\(\*RowBox[{\" ReturnAsNETObject \", \"[\", StyleBox[\" expr \", \" TI \"], \"]\"}]\) causes a .NET call during the evaluation of \!\(\*StyleBox[\" expr \", \" TI \"]\) to return its result as an object reference (i.e., a NETObject expression), not a value."
NETLink`SafeArrayAsArray::usage = "SafeArrayAsArray is an option to LoadCOMTypeLibrary that specifies whether to import all SAFEARRAYs as System.Array rather than a typed, single-dimensional managed array."
NETLink`SameObjectQ::usage = "\!\(\*RowBox[{\" SameObjectQ \", \"[\", RowBox[{SubscriptBox[StyleBox[\" object \", \" TI \"], StyleBox[\" 1\", \" TR \"]], \",\", SubscriptBox[StyleBox[\" object \", \" TI \"], StyleBox[\" 2\", \" TR \"]]}], \"]\"}]\) returns True if and only if the NETObject expressions \!\(\*SubscriptBox[StyleBox[\" object \", \" TI \"], StyleBox[\" 1\", \" TR \"]]\) and \!\(\*SubscriptBox[StyleBox[\" object \", \" TI \"], StyleBox[\" 2\", \" TR \"]]\) refer to the same .NET object."
NETLink`SaveAssemblyAs::usage = "SaveAssemblyAs is an option to LoadCOMTypeLibrary that allows you to specify a filename into which to write the interop assembly that gets generated."
NETLink`SendDelegateArguments::usage = "SendDelegateArguments is an option to AddEventHandler and NETNewDelegate that specifies which of the delegate arguments you want to be passed to your \!\(\*StyleBox[\" Mathematica \", FontSlant -> \" Italic \"]\) callback function."
NETLink`SetComplexType::usage = "\!\(\*RowBox[{\" SetComplexType \", \"[\", StyleBox[\" type \", \" TI \"], \"]\"}]\) tells \!\(\*StyleBox[\".NET/Link\", FontSlant -> \" Italic \"]\) to map the specified type to \!\(\*StyleBox[\" Mathematica \", FontSlant -> \" Italic \"]\) Complex numbers."
NETLink`ShowNETConsole::usage = "\!\(\*RowBox[{\" ShowNETConsole \", \"[\", \"]\"}]\) displays the .NET console window and begins capturing output sent to the \!\(\*StyleBox[\" Console.Out\", \" InlineCode \"]\) and \!\(\*StyleBox[\" Console.Error\", \" InlineCode \"]\) streams.\n\!\(\*RowBox[{\" ShowNETConsole \", \"[\", StyleBox[\" \\ \" stdout \\ \" \",ShowStringCharacters->True], \"]\"}]\) captures only \!\(\*StyleBox[\" Console.out\", \" InlineCode \"]\).\n\!\(\*RowBox[{\" ShowNETConsole \", \"[\", StyleBox[\" \\ \" stderr \\ \" \",ShowStringCharacters->True], \"]\"}]\) captures only \!\(\*StyleBox[\" Console.Error\", \" InlineCode \"]\)."
NETLink`ShowNETWindow::usage = "\!\(\*RowBox[{\" ShowNETWindow \", \"[\", StyleBox[\" form \", \" TI \"], \"]\"}]\) displays the specified .NET form in the foreground."
NETLink`StaticsVisible::usage = "StaticsVisible is an option to LoadNETType that specifies whether the class-specific context in which static method and field definitions are created should be placed on $ContextPath."
NETLink`UninstallNET::usage = "\!\(\*RowBox[{\" UninstallNET \", \"[\", \"]\"}]\) shuts down the .NET runtime that was started by InstallNET."
NETLink`WrapInNETBlock::usage = "WrapInNETBlock is an option to AddEventHandler and NETNewDelegate that specifies whether or not the \!\(\*StyleBox[\" Mathematica \", FontSlant -> \" Italic \"]\) callback function assigned to the delegate should be implicitly wrapped in NETBlock."
NETLink`$NETExceptionHandler::usage = "$NETExceptionHandler allows you to control how exceptions thrown in .NET are handled in \!\(\*StyleBox[\" Mathematica \", FontSlant -> \" Italic \"]\)."
NonlinearRegression`NonlinearRegress::usage = "\!\(\*RowBox[{\" NonlinearRegress \", \"[\", RowBox[{StyleBox[\" data \", \" TI \"], \",\", StyleBox[\" expr \", \" TI \"], \",\", StyleBox[\" pars \", \" TI \"], \",\", StyleBox[\" vars \", \" TI \"]}], \"]\"}]\) finds numerical values of the parameters \!\(\*StyleBox[\" pars \", \" TI \"]\) that make the model \!\(\*StyleBox[\" expr \", \" TI \"]\) give a best fit to \!\(\*StyleBox[\" data \", \" TI \"]\) as a function of \!\(\*StyleBox[\" vars \", \" TI \"]\) and provides diagnostics for the fitting.\n\!\(\*RowBox[{\" NonlinearRegress \", \"[\", RowBox[{StyleBox[\" data \", \" TI \"], \",\", RowBox[{\" {\", RowBox[{StyleBox[\" expr \", \" TI \"], \",\", StyleBox[\" cons \", \" TI \"]}], \"}\"}], \",\", StyleBox[\" pars \", \" TI \"], \",\", StyleBox[\" vars \", \" TI \"]}], \"]\"}]\) finds a best fit and provides diagnostics subject to the constraints \!\(\*StyleBox[\" cons \", \" TI \"]\)."
Notation`Action::usage = "Action is an option of Notation, Symbolize and InfixNotation that defines what action will be performed with the given notation statement."
Notation`ActiveInputAliases::usage = "\!\(\*RowBox[{\" ActiveInputAliases \", \"[\", \"]\"}]\) returns a list of all active aliases in the current notebook. \n\!\(\*RowBox[{\" ActiveInputAliases \", \"[\", StyleBox[\" notebook \", \" TI \"], \"]\"}]\) returns a list of all active aliases in the notebook \!\(\*StyleBox[\" notebook \", \" TI \"]\)."
Notation`AddInputAlias::usage = "\!\(\*RowBox[{\" AddInputAlias \", \"[\", RowBox[{StyleBox[\" boxes \", \" TI \"], \",\", StyleBox[\" alias \", \" TI \"]}], \"]\"}]\) adds the alias \[EscapeKey] \!\(\*StyleBox[\" alias \", \" TI \"]\)\[EscapeKey] for \!\(\*StyleBox[\" boxes \", \" TI \"]\) to the aliases in the current notebook. \n\!\(\*RowBox[{\" AddInputAlias \", \"[\", RowBox[{StyleBox[\" boxes \", \" TI \"], \",\", StyleBox[\" alias \", \" TI \"], \",\", StyleBox[\" notebook \", \" TI \"]}], \"]\"}]\) adds the alias to the notebook \!\(\*StyleBox[\" notebook \", \" TI \"]\)."
Notation`AutoLoadNotationPalette::usage = "AutoLoadNotationPalette specifies whether the Notation palette is opened when the Notation package is loaded."
Notation`ClearNotations::usage = "\!\(\*RowBox[{\" ClearNotations \", \"[\", \"]\"}]\) will remove all notations, symbolizations and infix notations."
Notation`CreateNotationRules::usage = "CreateNotationRules is a possible value for the Action option to Notation, Symbolize and InfixNotation."
Notation`InfixNotation::usage = "\!\(\*RowBox[{\" InfixNotation \", \"[\", RowBox[{StyleBox[\" op \", \" TI \"], \",\", StyleBox[\" func \", \" TI \"]}], \"]\"}]\) forces the box structure \!\(\*StyleBox[\" op \", \" TI \"]\) to be treated as an infix operator representing the function \!\(\*StyleBox[\" func \", \" TI \"]\) in input and output."
Notation`NotationBoxTag::usage = "NotationBoxTag This is provided for compatibility with previous versions of saved notation files. It has been superseded by the use of the string tag \" NotationTemplateTag \" and by ParsedBoxWrapper."
Notation`NotationMadeBoxesTag::usage = "NotationMadeBoxesTag This is provided for compatibility with previous versions of saved notation files. It has been superseded by the use of the string tag \" NotationMadeBoxesTag \" and by ParsedBoxWrapper."
Notation`NotationMakeBoxes::usage = "NotationMakeBoxes is a private version of MakeBoxes."
Notation`NotationMakeExpression::usage = "NotationMakeExpression is a private version of MakeExpression."
Notation`Notation::usage = "\!\(\*RowBox[{\" Notation \", \"[\", RowBox[{StyleBox[\" boxes \", \" TI \"], \" \", \"\[DoubleLongLeftRightArrow]\", \" \", StyleBox[\" expr \", \" TI \"]}], \"]\"}]\) parses any input box structure \!\(\*StyleBox[\" boxes \", \" TI \"]\) internally as \!\(\*StyleBox[\" expr \", \" TI \"]\), and formats any expression matching \!\(\*StyleBox[\" expr \", \" TI \"]\) as \!\(\*StyleBox[\" boxes \", \" TI \"]\) in output.\n\!\(\*RowBox[{\" Notation \", \"[\", RowBox[{StyleBox[\" boxes \", \" TI \"], \"\[DoubleLongRightArrow]\", StyleBox[\" expr \", \" TI \"]}], \"]\"}]\) restricts Notation to only parsing.\n\!\(\*RowBox[{\" Notation \", \"[\", RowBox[{StyleBox[\" boxes \", \" TI \"], \"\[DoubleLongLeftArrow]\", StyleBox[\" expr \", \" TI \"]}], \"]\"}]\) restricts Notation to only formatting."
Notation`NotationPatternTag::usage = "NotationPatternTag This is provided for compatibility with previous versions of saved notation files. It has been superseded by the use of the string tag \" NotationPatternTag \"."
Notation`ParsedBoxWrapper::usage = "ParsedBoxWrapper is a wrapper that wraps parsed boxes which come from the TagBox expressions that are embedded in Notation, Symbolize and InfixNotation statements."
Notation`PrintNotationRules::usage = "PrintNotationRules is a possible value for the Action option to Notation, Symbolize and InfixNotation."
Notation`RemoveInfixNotation::usage = "\!\(\*RowBox[{\" RemoveInfixNotation \", \"[\", RowBox[{StyleBox[\" op \", \" TI \"], \",\", StyleBox[\" func \", \" TI \"]}], \"]\"}]\) removes the infix operator \!\(\*StyleBox[\" op \", \" TI \"]\)."
Notation`RemoveNotation::usage = "\!\(\*RowBox[{\" RemoveNotation \", \"[\", RowBox[{StyleBox[\" boxes \", \" TI \"], \" \", \"\[DoubleLongLeftRightArrow]\", \" \", StyleBox[\" expr \", \" TI \"]}], \"]\"}]\) removes the notation \!\(\*StyleBox[\" boxes \", \" TI \"]\) \[DoubleLongLeftRightArrow] \!\(\*StyleBox[\" expr \", \" TI \"]\).\n\!\(\*RowBox[{\" RemoveNotation \", \"[\", RowBox[{StyleBox[\" boxes \", \" TI \"], \"\[DoubleLongRightArrow]\", StyleBox[\" expr \", \" TI \"]}], \"]\"}]\) removes only the parsing.\n\!\(\*RowBox[{\" RemoveNotation \", \"[\", RowBox[{StyleBox[\" boxes \", \" TI \"], \"\[DoubleLongLeftArrow]\", StyleBox[\" expr \", \" TI \"]}], \"]\"}]\) removes only the formatting."
Notation`RemoveNotationRules::usage = "RemoveNotationRules is a possible value for the Action option to Notation, Symbolize and InfixNotation."
Notation`RemoveSymbolize::usage = "\!\(\*RowBox[{\" RemoveSymbolize \", \"[\", StyleBox[\" boxes \", \" TI \"], \"]\"}]\) removes the symbolization of \!\(\*StyleBox[\" boxes \", \" TI \"]\)."
Notation`Symbolize::usage = "\!\(\*RowBox[{\" Symbolize \", \"[\", StyleBox[\" boxes \", \" TI \"], \"]\"}]\) forces any box structure matching \!\(\*StyleBox[\" boxes \", \" TI \"]\) to be treated internally as a single symbol anywhere it appears in an input expression."
Notation`SymbolizeRootName::usage = "SymbolizeRootName is an option for Symbolize specifying the name to be used internally for the symbolized boxes."
Notation`UpdateNotebookStyles::usage = "\!\(\*RowBox[{\" UpdateNotebookStyles \", \"[\", \"]\"}]\) is a function that will add the styles and input aliases the Notation package defines to your current notebook.\n\!\(\*RowBox[{\" UpdateNotebookStyles \", \"[\", StyleBox[\" notebook \", \" TI \"], \"]\"}]\) will update the stylesheet of the notebook \!\(\*StyleBox[\" notebook \", \" TI \"]\)."
Notation`WorkingForm::usage = "WorkingForm is an option of Notation, Symbolize and InfixNotation that defines which form the notation will be defined in."
NumericalCalculus`EulerRatio::usage = "EulerRatio is an option to EulerSum, which specifies the parameter to use in the generalized Euler transformation."
NumericalCalculus`EulerSum::usage = "\!\(\*RowBox[{\" EulerSum \", \"[\", RowBox[{StyleBox[\" f \", \" TI \"], \",\", RowBox[{\" {\", RowBox[{StyleBox[\" i \", \" TI \"], \",\", SubscriptBox[StyleBox[\" i \", \" TI \"], StyleBox[\" min \", \" TI \"]], \",\", SubscriptBox[StyleBox[\" i \", \" TI \"], StyleBox[\" max \", \" TI \"]]}], \"}\"}]}], \"]\"}]\) gives a numerical approximation to the sum \!\(\*RowBox[{UnderoverscriptBox[\" \[Sum]\", RowBox[{StyleBox[\" i \", \" TI \"], \"=\", SubscriptBox[StyleBox[\" i \", \" TI \"], StyleBox[\" min \", \" TI \"]]}], SubscriptBox[StyleBox[\" i \", \" TI \"], StyleBox[\" max \", \" TI \"]]], StyleBox[\" f \", \" TI \"]}]\) using Euler\[CloseCurlyQuote]s transformation.\n\!\(\*RowBox[{\" EulerSum \", \"[\", RowBox[{StyleBox[\" f \", \" TI \"], \",\", RowBox[{\" {\", RowBox[{StyleBox[\" i \", \" TI \"], \",\", SubscriptBox[StyleBox[\" i \", \" TI \"], StyleBox[\" min \", \" TI \"]], \",\", SubscriptBox[StyleBox[\" i \", \" TI \"], StyleBox[\" max \", \" TI \"]], \",\", StyleBox[\" di \", \" TI \"]}], \"}\"}]}], \"]\"}]\) uses a step \!\(\*StyleBox[\" di \", \" TI \"]\) in the sum."
NumericalCalculus`ExtraTerms::usage = "ExtraTerms is an option to EulerSum that specifies the number of terms to be used in the extrapolation process."
NumericalCalculus`ND::usage = "\!\(\*RowBox[{\" ND \", \"[\", RowBox[{StyleBox[\" expr \", \" TI \"], \",\", StyleBox[\" x \", \" TI \"], \",\", SubscriptBox[StyleBox[\" x \", \" TI \"], StyleBox[\" 0\", \" TR \"]]}], \"]\"}]\) gives a numerical approximation to the derivative of \!\(\*StyleBox[\" expr \", \" TI \"]\) with respect to \!\(\*StyleBox[\" x \", \" TI \"]\) at the point \!\(\*SubscriptBox[StyleBox[\" x \", \" TI \"], StyleBox[\" 0\", \" TR \"]]\).\n\!\(\*RowBox[{\" ND \", \"[\", RowBox[{StyleBox[\" expr \", \" TI \"], \",\", RowBox[{\" {\", RowBox[{StyleBox[\" x \", \" TI \"], \",\", StyleBox[\" n \", \" TI \"]}], \"}\"}], \",\", SubscriptBox[StyleBox[\" x \", \" TI \"], StyleBox[\" 0\", \" TR \"]]}], \"]\"}]\) gives a numerical approximation to the \!\(\*SuperscriptBox[StyleBox[\" n \", \" TI \"], \" th \"]\) derivative of \!\(\*StyleBox[\" expr \", \" TI \"]\)."
NumericalCalculus`NLimit::usage = "\!\(\*RowBox[{\" NLimit \", \"[\", RowBox[{StyleBox[\" expr \", \" TI \"], \",\", RowBox[{StyleBox[\" z \", \" TI \"], \"->\", SubscriptBox[StyleBox[\" z \", \" TI \"], StyleBox[\" 0\", \" TR \"]]}]}], \"]\"}]\) numerically finds the limiting value of \!\(\*StyleBox[\" expr \", \" TI \"]\) as \!\(\*StyleBox[\" z \", \" TI \"]\) approaches \!\(\*SubscriptBox[StyleBox[\" z \", \" TI \"], StyleBox[\" 0\", \" TR \"]]\)."
NumericalCalculus`NResidue::usage = "\!\(\*RowBox[{\" NResidue \", \"[\", RowBox[{StyleBox[\" expr \", \" TI \"], \",\", RowBox[{\" {\", RowBox[{StyleBox[\" z \", \" TI \"], \",\", SubscriptBox[StyleBox[\" z \", \" TI \"], StyleBox[\" 0\", \" TR \"]]}], \"}\"}]}], \"]\"}]\) numerically finds the residue of \!\(\*StyleBox[\" expr \", \" TI \"]\) near the point \!\(\*RowBox[{StyleBox[\" z \", \" TI \"], \"=\", SubscriptBox[StyleBox[\" z \", \" TI \"], StyleBox[\" 0\", \" TR \"]]}]\)."
NumericalCalculus`NSeries::usage = "\!\(\*RowBox[{\" NSeries \", \"[\", RowBox[{StyleBox[\" f \", \" TI \"], \",\", RowBox[{\" {\", RowBox[{StyleBox[\" x \", \" TI \"], \",\", SubscriptBox[StyleBox[\" x \", \" TI \"], StyleBox[\" 0\", \" TR \"]], \",\", StyleBox[\" n \", \" TI \"]}], \"}\"}]}], \"]\"}]\) gives a numerical approximation to the series expansion of \!\(\*StyleBox[\" f \", \" TI \"]\) about the point \!\(\*RowBox[{StyleBox[\" x \", \" TI \"], \"=\", SubscriptBox[StyleBox[\" x \", \" TI \"], StyleBox[\" 0\", \" TR \"]]}]\) including the terms \!\(\*SuperscriptBox[RowBox[{\" (\", RowBox[{StyleBox[\" x \", \" TI \"], \"-\", SubscriptBox[StyleBox[\" x \", \" TI \"], StyleBox[\" 0\", \" TR \"]]}], \")\"}], RowBox[{\"-\", StyleBox[\" n \", \" TI \"]}]]\) through \!\(\*SuperscriptBox[RowBox[{\" (\", RowBox[{StyleBox[\" x \", \" TI \"], \"-\", SubscriptBox[StyleBox[\" x \", \" TI \"], StyleBox[\" 0\", \" TR \"]]}], \")\"}], StyleBox[\" n \", \" TI \"]]\)."
NumericalCalculus`Radius::usage = "Radius is an option to NSeries that specifies the radius of the circle around which the function is to be sampled."
NumericalCalculus`Scale::usage = "Scale is an option to NLimit and ND that specifies the scale at which variations are expected."
NumericalCalculus`Terms::usage = "Terms is an option to EulerSum, NLimit, and ND that specifies the total number of terms to be used."
NumericalIntegrationAnalysis`ButcherAlpha::usage = "\!\(\*RowBox[{\" ButcherAlpha \", \"[\", StyleBox[\" tree \", \" TI \"], \"]\"}]\) gives the number of ways of labeling the vertices of \!\(\*StyleBox[\" tree \", \" TI \"]\) with a totally ordered set of labels such that if \!\(\*RowBox[{\" (\", RowBox[{StyleBox[\" m \", \" TI \"], \",\", StyleBox[\" n \", \" TI \"]}], \")\"}]\) is an edge, then \!\(\*RowBox[{StyleBox[\" m \", \" TI \"], \"<\", StyleBox[\" n \", \" TI \"]}]\)."
NumericalIntegrationAnalysis`ButcherBetaBar::usage = "\!\(\*RowBox[{\" ButcherBetaBar \", \"[\", StyleBox[\" tree \", \" TI \"], \"]\"}]\) gives the number of ways of labeling \!\(\*StyleBox[\" tree \", \" TI \"]\) with \!\(\*RowBox[{\" ButcherOrder \", \"[\", StyleBox[\" tree \", \" TI \"], \"]\"}]\) distinct labels such that every vertex is labeled.\n\!\(\*RowBox[{\" ButcherBetaBar \", \"[\", RowBox[{StyleBox[\" n \", \" TI \"], \",\", StyleBox[\" tree \", \" TI \"]}], \"]\"}]\) gives the number of ways of labeling \!\(\*StyleBox[\" n \", \" TI \"]\) of the vertices of \!\(\*StyleBox[\" tree \", \" TI \"]\) with \!\(\*StyleBox[\" n \", \" TI \"]\) distinct labels such that every leaf is labeled."
NumericalIntegrationAnalysis`ButcherBeta::usage = "\!\(\*RowBox[{\" ButcherBeta \", \"[\", StyleBox[\" tree \", \" TI \"], \"]\"}]\) gives the number of ways of labeling \!\(\*StyleBox[\" tree \", \" TI \"]\) with \!\(\*RowBox[{RowBox[{\" ButcherOrder \", \"[\", StyleBox[\" tree \", \" TI \"], \"]\"}], \"-\", \" 1\"}]\) distinct labels such that the root is not labeled, but every other vertex is labeled. \n\!\(\*RowBox[{\" ButcherBeta \", \"[\", RowBox[{StyleBox[\" n \", \" TI \"], \",\", StyleBox[\" tree \", \" TI \"]}], \"]\"}]\) gives the number of ways of labeling \!\(\*StyleBox[\" n \", \" TI \"]\) of the vertices of \!\(\*StyleBox[\" tree \", \" TI \"]\) with \!\(\*StyleBox[\" n \", \" TI \"]\) distinct labels such that every leaf is labeled and the root is not labeled."
NumericalIntegrationAnalysis`ButcherColumnConditions::usage = "\!\(\*RowBox[{\" ButcherColumnConditions \", \"[\", RowBox[{StyleBox[\" p \", \" TI \"], \",\", StyleBox[\" s \", \" TI \"]}], \"]\"}]\) gives the column simplifying conditions up to and including order \!\(\*StyleBox[\" p \", \" TI \"]\) for \!\(\*StyleBox[\" s \", \" TI \"]\) stages. \n\!\(\*RowBox[{\" ButcherColumnConditions \", \"[\", StyleBox[\" p \", \" TI \"], \"]\"}]\) gives the column simplifying conditions in stage independent tensor notation."
NumericalIntegrationAnalysis`ButcherGamma::usage = "\!\(\*RowBox[{\" ButcherGamma \", \"[\", StyleBox[\" tree \", \" TI \"], \"]\"}]\) gives the density of \!\(\*StyleBox[\" tree \", \" TI \"]\)."
NumericalIntegrationAnalysis`ButcherHeight::usage = "\!\(\*RowBox[{\" ButcherHeight \", \"[\", StyleBox[\" tree \", \" TI \"], \"]\"}]\) gives the height of \!\(\*StyleBox[\" tree \", \" TI \"]\)."
NumericalIntegrationAnalysis`ButcherOrder::usage = "\!\(\*RowBox[{\" ButcherOrder \", \"[\", StyleBox[\" tree \", \" TI \"], \"]\"}]\) gives the number of vertices in \!\(\*StyleBox[\" tree \", \" TI \"]\)."
NumericalIntegrationAnalysis`ButcherPhi::usage = "\!\(\*RowBox[{\" ButcherPhi \", \"[\", RowBox[{StyleBox[\" tree \", \" TI \"], \",\", StyleBox[\" s \", \" TI \"]}], \"]\"}]\) gives the weight of \!\(\*StyleBox[\" tree \", \" TI \"]\) in an \!\(\*StyleBox[\" s \", \" TI \"]\)-stage Runge\[Dash]Kutta method. \n\!\(\*RowBox[{\" ButcherPhi \", \"[\", StyleBox[\" tree \", \" TI \"], \"]\"}]\) gives the weight of \!\(\*StyleBox[\" tree \", \" TI \"]\) in stage independent tensor notation."
NumericalIntegrationAnalysis`ButcherPlotColumns::usage = "ButcherPlotColumns is an option to ButcherPlot that specifies the number of columns in the array of Butcher tree plots."
NumericalIntegrationAnalysis`ButcherPlotLabel::usage = "ButcherPlotLabel is an option to ButcherPlot that specifies a list of plot labels."
NumericalIntegrationAnalysis`ButcherPlot::usage = "\!\(\*RowBox[{\" ButcherPlot \", \"[\", StyleBox[\" tree \", \" TI \"], \"]\"}]\) gives a plot of \!\(\*StyleBox[\" tree \", \" TI \"]\).\n\!\(\*RowBox[{\" ButcherPlot \", \"[\", RowBox[{\" {\", RowBox[{SubscriptBox[StyleBox[\" tree \", \" TI \"], StyleBox[\" 1\", \" TR \"]], \",\", SubscriptBox[StyleBox[\" tree \", \" TI \"], StyleBox[\" 2\", \" TR \"]], \",\", StyleBox[\" \[Ellipsis] \", \" TR \"]}], \"}\"}], \"]\"}]\) gives an array of plots of \!\(\*RowBox[{SubscriptBox[StyleBox[\" tree \", \" TI \"], \" 1\"], \",\", SubscriptBox[StyleBox[\" tree \", \" TI \"], StyleBox[\" 2\", \" TR \"]], \",\", StyleBox[\" \[Ellipsis] \", \" TR \"]}]\)"
NumericalIntegrationAnalysis`ButcherPlotNodeSize::usage = "ButcherPlotNodeSize is an option to ButcherPlot that specifies a scaling factor for the nodes of the trees in the plot."
NumericalIntegrationAnalysis`ButcherPlotRootSize::usage = "ButcherPlotRootSize is an option to ButcherPlot that specifies a scaling factor for the circle highlighting the root."
NumericalIntegrationAnalysis`ButcherPrincipalError::usage = "\!\(\*RowBox[{\" ButcherPrincipalError \", \"[\", RowBox[{StyleBox[\" p \", \" TI \"], \",\", StyleBox[\" s \", \" TI \"]}], \"]\"}]\) gives the principal error for a method of order \!\(\*StyleBox[\" p \", \" TI \"]\) with \!\(\*StyleBox[\" s \", \" TI \"]\) stages. \n\!\(\*RowBox[{\" ButcherPrincipalError \", \"[\", StyleBox[\" p \", \" TI \"], \"]\"}]\) gives the principal error using stage independent tensor notation."
NumericalIntegrationAnalysis`ButcherQuadratureConditions::usage = "\!\(\*RowBox[{\" ButcherQuadratureConditions \", \"[\", RowBox[{StyleBox[\" p \", \" TI \"], \",\", StyleBox[\" s \", \" TI \"]}], \"]\"}]\) gives the quadrature conditions up to and including order \!\(\*StyleBox[\" p \", \" TI \"]\) for \!\(\*StyleBox[\" s \", \" TI \"]\) stages. \n\!\(\*RowBox[{\" ButcherQuadratureConditions \", \"[\", StyleBox[\" p \", \" TI \"], \"]\"}]\) gives the quadrature conditions in stage independent tensor notation."
NumericalIntegrationAnalysis`ButcherRowConditions::usage = "\!\(\*RowBox[{\" ButcherRowConditions \", \"[\", RowBox[{StyleBox[\" p \", \" TI \"], \",\", StyleBox[\" s \", \" TI \"]}], \"]\"}]\) gives the row simplifying conditions up to and including order \!\(\*StyleBox[\" p \", \" TI \"]\) for \!\(\*StyleBox[\" s \", \" TI \"]\) stages. \n\!\(\*RowBox[{\" ButcherRowConditions \", \"[\", StyleBox[\" p \", \" TI \"], \"]\"}]\) gives the row simplifying conditions in stage\[Dash]independent tensor notation."
NumericalIntegrationAnalysis`ButcherRowSum::usage = "ButcherRowSum is an option to RungeKuttaOrderConditions that specifies whether the row\[Dash]sum conditions for the \!\(\*RowBox[{StyleBox[\" c \", \" TI \"], \"[\", StyleBox[\" i \", \" TI \"], \"]\"}]\) should be added to the list of order conditions."
NumericalIntegrationAnalysis`ButcherSigma::usage = "\!\(\*RowBox[{\" ButcherSigma \", \"[\", StyleBox[\" tree \", \" TI \"], \"]\"}]\) gives the order of the symmetry group of isomorphisms of \!\(\*StyleBox[\" tree \", \" TI \"]\) with itself."
NumericalIntegrationAnalysis`ButcherSimplify::usage = "ButcherSimplify is an option to RungeKuttaOrderConditions that specifies whether to apply Butcher\[CloseCurlyQuote]s row and column simplifying conditions."
NumericalIntegrationAnalysis`ButcherTreeCount::usage = "\!\(\*RowBox[{\" ButcherTreeCount \", \"[\", StyleBox[\" p \", \" TI \"], \"]\"}]\) gives a list of the number of trees through order \!\(\*StyleBox[\" p \", \" TI \"]\)."
NumericalIntegrationAnalysis`ButcherTreeQ::usage = "\!\(\*RowBox[{\" ButcherTreeQ \", \"[\", StyleBox[\" tree \", \" TI \"], \"]\"}]\) gives True if \!\(\*StyleBox[\" tree \", \" TI \"]\) is a valid Butcher tree, and False otherwise."
NumericalIntegrationAnalysis`ButcherTreeSimplify::usage = "\!\(\*RowBox[{\" ButcherTreeSimplify \", \"[\", RowBox[{StyleBox[\" p \", \" TI \"], \",\", StyleBox[\" \[Eta] \", \" TR \"], \",\", StyleBox[\" \[Xi] \", \" TR \"]}], \"]\"}]\) gives the set of trees through order \!\(\*StyleBox[\" p \", \" TI \"]\) that are not reduced by Butcher\[CloseCurlyQuote]s quadrature conditions through order \!\(\*StyleBox[\" p \", \" TI \"]\), row simplifying conditions through order \!\(\*StyleBox[\" \[Eta] \", \" TR \"]\) and column simplifying conditions through order \!\(\*StyleBox[\" \[Xi] \", \" TR \"]\)."
NumericalIntegrationAnalysis`ButcherTrees::usage = "\!\(\*RowBox[{\" ButcherTrees \", \"[\", StyleBox[\" p \", \" TI \"], \"]\"}]\) gives a list, partitioned by order, of the trees for any Runge\[Dash]Kutta method of order \!\(\*StyleBox[\" p \", \" TI \"]\)."
NumericalIntegrationAnalysis`ButcherWidth::usage = "\!\(\*RowBox[{\" ButcherWidth \", \"[\", StyleBox[\" tree \", \" TI \"], \"]\"}]\) gives the width of \!\(\*StyleBox[\" tree \", \" TI \"]\)."
NumericalIntegrationAnalysis`ContinuousExtension::usage = "ContinuousExtension is an option to RungeKuttaOrderConditions and related functions that specifies whether to generate order conditions for continuous extensions of Runge\[Dash]Kutta methods."
NumericalIntegrationAnalysis`DiagonallyImplicit::usage = "DiagonallyImplicit is a setting for the option RungeKuttaMethod specifying the type of Runge\[Dash]Kutta method to be generated."
NumericalIntegrationAnalysis`Explicit::usage = "Explicit is a setting for the option RungeKuttaMethod specifying the type of Runge\[Dash]Kutta method to be generated."
NumericalIntegrationAnalysis`GaussianQuadratureError::usage = "\!\(\*RowBox[{\" GaussianQuadratureError \", \"[\", RowBox[{StyleBox[\" n \", \" TI \"], \",\", StyleBox[\" f \", \" TI \"], \",\", StyleBox[\" a \", \" TI \"], \",\", StyleBox[\" b \", \" TI \"]}], \"]\"}]\) gives the leading term in the error of the elementary \!\(\*StyleBox[\" n \", \" TI \"]\)-point Gaussian quadrature formula for the function \!\(\*StyleBox[\" f \", \" TI \"]\) on an interval from \!\(\*StyleBox[\" a \", \" TI \"]\) to \!\(\*StyleBox[\" b \", \" TI \"]\).\n\!\(\*RowBox[{\" GaussianQuadratureError \", \"[\", RowBox[{StyleBox[\" n \", \" TI \"], \",\", StyleBox[\" f \", \" TI \"], \",\", StyleBox[\" a \", \" TI \"], \",\", StyleBox[\" b \", \" TI \"], \",\", StyleBox[\" prec \", \" TI \"]}], \"]\"}]\) attempts to give a result with \!\(\*StyleBox[\" prec \", \" TI \"]\) digits of precision."
NumericalIntegrationAnalysis`GaussianQuadratureWeights::usage = "\!\(\*RowBox[{\" GaussianQuadratureWeights \", \"[\", RowBox[{StyleBox[\" n \", \" TI \"], \",\", StyleBox[\" a \", \" TI \"], \",\", StyleBox[\" b \", \" TI \"]}], \"]\"}]\) gives a list of the \!\(\*StyleBox[\" n \", \" TI \"]\) pairs \!\(\*RowBox[{\" {\", RowBox[{SubscriptBox[StyleBox[\" x \", \" TI \"], StyleBox[\" i \", \" TI \"]], \",\", SubscriptBox[StyleBox[\" w \", \" TI \"], StyleBox[\" i \", \" TI \"]]}], \"}\"}]\) of the elementary \!\(\*StyleBox[\" n \", \" TI \"]\)-point Gaussian formula for quadrature on the interval \!\(\*StyleBox[\" a \", \" TI \"]\) to \!\(\*StyleBox[\" b \", \" TI \"]\), where \!\(\*SubscriptBox[StyleBox[\" w \", \" TI \"], StyleBox[\" i \", \" TI \"]]\) is the weight of the abscissa \!\(\*SubscriptBox[StyleBox[\" x \", \" TI \"], StyleBox[\" i \", \" TI \"]]\).\n\!\(\*RowBox[{\" GaussianQuadratureWeights \", \"[\", RowBox[{StyleBox[\" n \", \" TI \"], \",\", StyleBox[\" a \", \" TI \"], \",\", StyleBox[\" b \", \" TI \"], \",\", StyleBox[\" prec \", \" TI \"]}], \"]\"}]\) attempts to give a result with \!\(\*StyleBox[\" prec \", \" TI \"]\) digits of precision."
NumericalIntegrationAnalysis`Implicit::usage = "Implicit is a setting for the option RungeKuttaMethod specifying the type of Runge\[Dash]Kutta method to be generated."
NumericalIntegrationAnalysis`NewtonCotesError::usage = "\!\(\*RowBox[{\" NewtonCotesError \", \"[\", RowBox[{StyleBox[\" n \", \" TI \"], \",\", StyleBox[\" f \", \" TI \"], \",\", StyleBox[\" a \", \" TI \"], \",\", StyleBox[\" b \", \" TI \"]}], \"]\"}]\) gives the error in the elementary \!\(\*StyleBox[\" n \", \" TI \"]\)-point Newton-Cotes quadrature formula for the function \!\(\*StyleBox[\" f \", \" TI \"]\) on an interval from \!\(\*StyleBox[\" a \", \" TI \"]\) to \!\(\*StyleBox[\" b \", \" TI \"]\)."
NumericalIntegrationAnalysis`NewtonCotesWeights::usage = "\!\(\*RowBox[{\" NewtonCotesWeights \", \"[\", RowBox[{StyleBox[\" n \", \" TI \"], \",\", StyleBox[\" a \", \" TI \"], \",\", StyleBox[\" b \", \" TI \"]}], \"]\"}]\) gives a list of the \!\(\*StyleBox[\" n \", \" TI \"]\) pairs \!\(\*RowBox[{\" {\", RowBox[{SubscriptBox[StyleBox[\" x \", \" TI \"], StyleBox[\" i \", \" TI \"]], \",\", SubscriptBox[StyleBox[\" w \", \" TI \"], StyleBox[\" i \", \" TI \"]]}], \"}\"}]\) of the elementary \!\(\*StyleBox[\" n \", \" TI \"]\)-point Newton-Cotes formula for quadrature on the interval \!\(\*StyleBox[\" a \", \" TI \"]\) to \!\(\*StyleBox[\" b \", \" TI \"]\), where \!\(\*SubscriptBox[StyleBox[\" w \", \" TI \"], StyleBox[\" i \", \" TI \"]]\) is the weight of the abscissa \!\(\*SubscriptBox[StyleBox[\" x \", \" TI \"], StyleBox[\" i \", \" TI \"]]\)."
NumericalIntegrationAnalysis`QuadratureType::usage = "QuadratureType is an option to NewtonCotesWeights and NewtonCotesError that specifies whether the endpoints are to be included as abscissas."
NumericalIntegrationAnalysis`RungeKuttaMethod::usage = "RungeKuttaMethod is an option to ButcherPhi and related functions that specifies the type of method to be generated."
NumericalIntegrationAnalysis`RungeKuttaOrderConditions::usage = "\!\(\*RowBox[{\" RungeKuttaOrderConditions \", \"[\", RowBox[{StyleBox[\" p \", \" TI \"], \",\", StyleBox[\" s \", \" TI \"]}], \"]\"}]\) gives a list of the order conditions that any \!\(\*StyleBox[\" s \", \" TI \"]\)-stage Runge\[Dash]Kutta method of order \!\(\*StyleBox[\" p \", \" TI \"]\) must satisfy. \n\!\(\*RowBox[{\" RungeKuttaOrderConditions \", \"[\", StyleBox[\" p \", \" TI \"], \"]\"}]\) gives the order conditions using stage independent tensor notation."
NumericalIntegrationAnalysis`$ContinuousExtension::usage = "$ContinuousExtension is a global environment setting, specifying whether to generate conditions for continuous extensions of Runge\[Dash]Kutta methods."
NumericalIntegrationAnalysis`$RungeKuttaMethod::usage = "$RungeKuttaMethod is a global environment setting, specifying the type of method to be generated by \!\(\*RowBox[{\" ButcherPhi \", \" \"}]\)and related functions."
PhysicalConstants`AccelerationDueToGravity::usage = "AccelerationDueToGravity is the acceleration of a body freely falling in a vacuum on Earth at sea level."
PhysicalConstants`AgeOfUniverse::usage = "AgeOfUniverse is the age of the Universe, a physical constant."
PhysicalConstants`AvogadroConstant::usage = "AvogadroConstant is the number of molecules in one mole or gram molecular weight of a substance."
PhysicalConstants`BohrRadius::usage = "BohrRadius is the Bohr radius, an atomic constant."
PhysicalConstants`BoltzmannConstant::usage = "BoltzmannConstant is the ratio of the universal gas constant (MolarGasConstant) to Avogadro\[CloseCurlyQuote]s number (AvogadroConstant)."
PhysicalConstants`ClassicalElectronRadius::usage = "ClassicalElectronRadius is the classical electron radius, an atomic constant."
PhysicalConstants`CosmicBackgroundTemperature::usage = "CosmicBackgroundTemperature is the temperature of the cosmic background radiation."
PhysicalConstants`DeuteronMagneticMoment::usage = "DeuteronMagneticMoment is the deuteron magnetic moment."
PhysicalConstants`DeuteronMass::usage = "DeuteronMass is the mass of a deuteron."
PhysicalConstants`EarthMass::usage = "EarthMass is the mass of the Earth, a physical constant."
PhysicalConstants`EarthRadius::usage = "EarthRadius is the radius of the Earth, a physical constant."
PhysicalConstants`ElectronCharge::usage = "ElectronCharge is the elementary charge on the electron, an electromagnetic constant."
PhysicalConstants`ElectronComptonWavelength::usage = "ElectronComptonWavelength is the electron Compton wavelength."
PhysicalConstants`ElectronGFactor::usage = "ElectronGFactor is the electron g\[Dash]factor."
PhysicalConstants`ElectronMagneticMoment::usage = "ElectronMagneticMoment is the electron magnetic moment."
PhysicalConstants`ElectronMass::usage = "ElectronMass is the mass of an electron."
PhysicalConstants`FaradayConstant::usage = "FaradayConstant is the product of the Avogadro constant (AvogadroConstant) and the elementary charge (ElectronCharge)."
PhysicalConstants`FineStructureConstant::usage = "FineStructureConstant is the fine structure constant, an atomic constant."
PhysicalConstants`GalacticUnit::usage = "GalacticUnit is the approximate distance of the Sun from the center of the Milky Way Galaxy."
PhysicalConstants`GravitationalConstant::usage = "GravitationalConstant is the coefficient of proportionality in Newton's law of gravitation."
PhysicalConstants`HubbleConstant::usage = "HubbleConstant is a measure of the rate at which the expansion of the Universe varies with distance."
PhysicalConstants`IcePoint::usage = "IcePoint is the temperature at which a mixture of air\[Dash]saturated pure water and pure ice may exist in equilibrium at a pressure of one standard atmosphere."
PhysicalConstants`MagneticFluxQuantum::usage = "MagneticFluxQuantum is magnetic flux quantum, an electromagnetic constant."
PhysicalConstants`MolarGasConstant::usage = "MolarGasConstant is a physico\[Dash]chemical constant."
PhysicalConstants`MolarVolume::usage = "MolarVolume is the volume occupied by a mole or a gram molecular weight of any gas measured at standard conditions."
PhysicalConstants`MuonGFactor::usage = "MuonGFactor is the muon \!\(\*StyleBox[\" g \", \" TI \"]\)\[Dash]factor."
PhysicalConstants`MuonMagneticMoment::usage = "MuonMagneticMoment is the muon magnetic moment."
PhysicalConstants`MuonMass::usage = "MuonMass is the mass of a muon."
PhysicalConstants`NeutronComptonWavelength::usage = "NeutronComptonWavelength is the neutron Compton wavelength."
PhysicalConstants`NeutronMagneticMoment::usage = "NeutronMagneticMoment is the neutron magnetic moment."
PhysicalConstants`NeutronMass::usage = "NeutronMass is the mass of a neutron."
PhysicalConstants`PlanckConstant::usage = "PlanckConstant is a universal constant of nature which relates the energy of a quantum of radiation to the frequency of the oscillator which emitted it."
PhysicalConstants`PlanckConstantReduced::usage = "PlanckConstantReduced is a universal constant, equal to \!\(\*RowBox[{\" PlanckConstant \", \"/\", RowBox[{\" (\", RowBox[{\" 2\", \" \", \" Pi \"}], \")\"}]}]\)."
PhysicalConstants`PlanckMass::usage = "PlanckMass is a universal constant."
PhysicalConstants`ProtonComptonWavelength::usage = "ProtonComptonWavelength is the proton Compton wavelength."
PhysicalConstants`ProtonMagneticMoment::usage = "ProtonMagneticMoment is the proton magnetic moment."
PhysicalConstants`ProtonMass::usage = "ProtonMass is the mass of a proton."
PhysicalConstants`QuantizedHallConductance::usage = "QuantizedHallConductance is the quantized Hall conductance, an electromagnetic constant."
PhysicalConstants`RydbergConstant::usage = "RydbergConstant is an atomic constant appearing in the Rydberg formula expressing the wave\[Dash]numbers of the lines in a spectral series."
PhysicalConstants`SackurTetrodeConstant::usage = "SackurTetrodeConstant is the absolute entropy constant, a physico\[Dash]chemical constant."
PhysicalConstants`SolarConstant::usage = "SolarConstant is the rate at which solar radiation is received outside the Earth\[CloseCurlyQuote]s atmosphere on a surface normal to the incident radiation and at the Earth\[CloseCurlyQuote]s mean distance from the Sun."
PhysicalConstants`SolarLuminosity::usage = "SolarLuminosity is a physical constant."
PhysicalConstants`SolarRadius::usage = "SolarRadius is a physical constant."
PhysicalConstants`SolarSchwarzschildRadius::usage = "SolarSchwarzschildRadius is a physical constant."
PhysicalConstants`SpeedOfLight::usage = "SpeedOfLight is the speed of light in a vacuum, a universal constant."
PhysicalConstants`SpeedOfSound::usage = "SpeedOfSound is the speed of sound at sea level in the standard atmosphere."
PhysicalConstants`StefanConstant::usage = "StefanConstant is the Stefan\[Dash]Boltzmann constant, a universal constant of proportionality between the radiant emittance of a black body and the fourth power of the body\[CloseCurlyQuote]s absolute temperature."
PhysicalConstants`ThomsonCrossSection::usage = "ThomsonCrossSection is the Thomson cross section, an atomic constant."
PhysicalConstants`VacuumPermeability::usage = "VacuumPermeability is the permeability of vacuum, a universal constant."
PhysicalConstants`VacuumPermittivity::usage = "VacuumPermittivity is the permittivity of vacuum, a universal constant."
PhysicalConstants`WeakMixingAngle::usage = "WeakMixingAngle is a physical constant."
PieCharts`PieChart::usage = "\!\(\*RowBox[{\" PieChart \", \"[\", RowBox[{\" {\", RowBox[{SubscriptBox[StyleBox[\" y \", \" TI \"], StyleBox[\" 1\", \" TR \"]], \",\", SubscriptBox[StyleBox[\" y \", \" TI \"], StyleBox[\" 2\", \" TR \"]], \",\", StyleBox[\" \[Ellipsis] \", \" TI \"]}], \"}\"}], \"]\"}]\) generates a pie chart of the positive values \!\(\*SubscriptBox[StyleBox[\" y \", \" TI \"], StyleBox[\" i \", \" TI \"]]\)."
PieCharts`PieEdgeStyle::usage = "PieEdgeStyle is an option for PieChart that specifies the styles for lines in the pie chart."
PieCharts`PieExploded::usage = "PieExploded is an option for PieChart that specifies the distance to move wedges outwards radially in the pie chart."
PieCharts`PieLabels::usage = "PieLabels is an option for PieChart that specifies the labels on the pie wedges."
PieCharts`PieOrientation::usage = "PieOrientation is an option for PieChart that determines the placement of the first piece of data."
PieCharts`PieStyle::usage = "PieStyle is an option for PieChart that specifies a style for each wedge of the pie chart."
PlotLegends`LegendBackground::usage = "LegendBackground is an option for Legend, which specifies the style of background to use with a legend. "
PlotLegends`LegendBorder::usage = "LegendBorder is an option for Legend, which specifies the style of the line surrounding key boxes and text in a legend."
PlotLegends`LegendBorderSpace::usage = "LegendBorderSpace is an option for Legend which sets the space around the entire set of key boxes and text in the legend."
PlotLegends`LegendLabel::usage = "LegendLabel is an option for Legend, which specifies the text to be used as the label for the legend box. "
PlotLegends`LegendLabelSpace::usage = "LegendLabelSpace is an option for Legend, which specifies the space for LegendLabel. "
PlotLegends`Legend::usage = "\!\(\*RowBox[{\" Legend \", \"[\", RowBox[{RowBox[{\" {\", RowBox[{RowBox[{\" {\", RowBox[{SubscriptBox[StyleBox[\" box \", \" TI \"], StyleBox[\" 1\", \" TR \"]], \",\", SubscriptBox[StyleBox[\" text \", \" TI \"], StyleBox[\" 1\", \" TR \"]]}], \"}\"}], \",\", StyleBox[\" \[Ellipsis] \", \" TR \"]}], \"}\"}], \",\", StyleBox[\" options \", \" TI \"]}], \"]\"}]\) generates a legend with the specified boxes and text.\n\!\(\*RowBox[{\" Legend \", \"[\", RowBox[{StyleBox[\" func \", \" TI \"], \",\", StyleBox[\" num \", \" TI \"], \",\", StyleBox[\" options \", \" TI \"]}], \"]\"}]\) generates a legend by applying \!\(\*StyleBox[\" func \", \" TI \"]\) to numbers between 0 and 1, incremented by the number of boxes \!\(\*RowBox[{StyleBox[\" num \", \" TI \"], \"-\", \" 1\"}]\).\n\!\(\*RowBox[{\" Legend \", \"[\", RowBox[{StyleBox[\" func \", \" TI \"], \",\", StyleBox[\" num \", \" TI \"], \",\", StyleBox[\" mintext \", \" TI \"], \",\", StyleBox[\" maxtext \", \" TI \"], \",\", StyleBox[\" options \", \" TI \"]}], \"]\"}]\) labels the first and last boxes with \!\(\*StyleBox[\" mintext \", \" TI \"]\) and \!\(\*StyleBox[\" maxtext \", \" TI \"]\) respectively."
PlotLegends`LegendOrientation::usage = "LegendOrientation is an option for Legend, which specifies the direction in which key boxes are laid out. "
PlotLegends`LegendPosition::usage = "LegendPosition is an option for Legend, which specifies the location of the lower\[Dash]left corner of a legend box. "
PlotLegends`LegendShadow::usage = "LegendShadow is an option for Legend which specifies the shadowing drawn around the legend."
PlotLegends`LegendSize::usage = "LegendSize is an option for Legend which specifies the size of a legend box."
PlotLegends`LegendSpacing::usage = "LegendSpacing is an option for Legend which specifies the amount of space around each key box on a scale where the box is 1."
PlotLegends`LegendTextDirection::usage = "LegendTextDirection is an option for Legend, which specifies the direction of text next to the key box. "
PlotLegends`LegendTextOffset::usage = "LegendTextOffset is an option for Legend, which specifies the offset of text next to the key box."
PlotLegends`LegendTextSpace::usage = "LegendTextSpace is an option for Legend, which specifies the space in the legend box for text."
PlotLegends`PlotLegend::usage = "PlotLegend is an option for Plot, which assigns text to lines in a 2D plot to create a legend for that plot. "
PlotLegends`ShadowBackground::usage = "ShadowBackground is an option for ShadowBox or Legend, which specifies the style for a drop shadow. "
PlotLegends`ShadowBorder::usage = "ShadowBorder is an option for ShadowBox, which specifies the style of the border around the rectangle above a shadow. "
PlotLegends`ShadowBox::usage = "\!\(\*RowBox[{ShadowBox, \"[\", RowBox[{RowBox[{\" {\", RowBox[{StyleBox[\" x \", \" TI \"], \",\", StyleBox[\" y \", \" TI \"]}], \"}\"}], \",\", RowBox[{\" {\", RowBox[{StyleBox[\" xlength \", \" TI \"], \",\", StyleBox[\" ylength \", \" TI \"]}], \"}\"}], \",\", StyleBox[\" options \", \" TI \"]}], \"]\"}]\) generates a box with a drop shadow."
PlotLegends`ShadowForeground::usage = "ShadowForeground is an option for ShadowBox, which specifies a style for the foreground of a shadow box. "
PlotLegends`ShadowOffset::usage = "ShadowOffset is an option for ShadowBox, which sets the offset of a shadow from the rest of the box. "
PlotLegends`ShowLegend::usage = "\!\(\*RowBox[{\" ShowLegend \", \"[\", RowBox[{StyleBox[\" graphics \", \" TI \"], \",\", SubscriptBox[StyleBox[\" legend \", \" TI \"], StyleBox[\" 1\", \" TR \"]], \",\", SubscriptBox[StyleBox[\" legend \", \" TI \"], StyleBox[\" 2\", \" TR \"]], \",\", StyleBox[\" \[Ellipsis] \", \" TR \"]}], \"]\"}]\) places the \!\(\*RowBox[{SubscriptBox[StyleBox[\" legend \", \" TI \"], StyleBox[\" 1\", \" TR \"]], \",\", SubscriptBox[StyleBox[\" legend \", \" TI \"], StyleBox[\" 2\", \" TR \"]], \",\", StyleBox[\" \[Ellipsis] \", \" TR \"]}]\), in the given graphic \!\(\*StyleBox[\" graphics \", \" TI \"]\)."
PolyhedronOperations`Geodesate::usage = "\!\(\*RowBox[{\" Geodesate \", \"[\", RowBox[{StyleBox[\" expr \", \" TI \"], \",\", StyleBox[\" n \", \" TI \"]}], \"]\"}]\) replaces each polygon in graphics expression \!\(\*StyleBox[\" expr \", \" TI \"]\) by the projection onto the circumscribed sphere of the order \!\(\*StyleBox[\" n \", \" TI \"]\) regular tessellation of that polygon.\n\!\(\*RowBox[{\" Geodesate \", \"[\", RowBox[{StyleBox[\" expr \", \" TI \"], \",\", StyleBox[\" n \", \" TI \"], \",\", RowBox[{\" {\", RowBox[{StyleBox[\" x \", \" TI \"], \",\", StyleBox[\" y \", \" TI \"], \",\", StyleBox[\" z \", \" TI \"]}], \"}\"}], \",\", StyleBox[\" radius \", \" TI \"]}], \"]\"}]\) does the projection onto the sphere of radius \!\(\*StyleBox[\" radius \", \" TI \"]\) centered at \!\(\*RowBox[{\" {\", RowBox[{StyleBox[\" x \", \" TI \"], \",\", StyleBox[\" y \", \" TI \"], \",\", StyleBox[\" z \", \" TI \"]}], \"}\"}]\)."
PolyhedronOperations`OpenTruncate::usage = "\!\(\*RowBox[{\" OpenTruncate \", \"[\", StyleBox[\" expr \", \" TI \"], \"]\"}]\) truncates each edge of each polygon in graphics expression \!\(\*StyleBox[\" expr \", \" TI \"]\) without filling in with a polygon.\n\!\(\*RowBox[{\" OpenTruncate \", \"[\", RowBox[{StyleBox[\" expr \", \" TI \"], \",\", StyleBox[\" ratio \", \" TI \"]}], \"]\"}]\) truncates to the specified \!\(\*StyleBox[\" ratio \", \" TI \"]\) of the edge length."
PolyhedronOperations`Stellate::usage = "\!\(\*RowBox[{\" Stellate \", \"[\", StyleBox[\" expr \", \" TI \"], \"]\"}]\) replaces each polygon in graphics expression \!\(\*StyleBox[\" expr \", \" TI \"]\) by a pyramid with the polygon as its base.\n\!\(\*RowBox[{\" Stellate \", \"[\", RowBox[{StyleBox[\" expr \", \" TI \"], \",\", StyleBox[\" ratio \", \" TI \"]}], \"]\"}]\) uses a stellation ratio \!\(\*StyleBox[\" ratio \", \" TI \"]\)."
PolyhedronOperations`Truncate::usage = "\!\(\*RowBox[{\" Truncate \", \"[\", StyleBox[\" expr \", \" TI \"], \"]\"}]\) truncates each edge of each polygon in graphics expression \!\(\*StyleBox[\" expr \", \" TI \"]\).\n\!\(\*RowBox[{\" Truncate \", \"[\", RowBox[{StyleBox[\" expr \", \" TI \"], \",\", StyleBox[\" ratio \", \" TI \"]}], \"]\"}]\) truncates to the specified \!\(\*StyleBox[\" ratio \", \" TI \"]\) of the edge length."
Polytopes`Area::usage = "\!\(\*RowBox[{\" Area \", \"[\", StyleBox[\" polygon \", \" TI \"], \"]\"}]\) gives the area of polygon \!\(\*StyleBox[\" polygon \", \" TI \"]\), when the edges of \!\(\*StyleBox[\" polygon \", \" TI \"]\) have unit length."
Polytopes`CircumscribedRadius::usage = "\!\(\*RowBox[{\" CircumscribedRadius \", \"[\", StyleBox[\" polygon \", \" TI \"], \"]\"}]\) gives the radius of a circumscribed circle of polygon \!\(\*StyleBox[\" polygon \", \" TI \"]\), when the edges of \!\(\*StyleBox[\" polygon \", \" TI \"]\) have unit length."
Polytopes`Decagon::usage = "Decagon is a regular polygon with ten edges, for use with polytope functions."
Polytopes`Digon::usage = "Digon is a regular polygon with two edges, for use with polytope functions."
Polytopes`Dodecagon::usage = "Dodecagon is a regular polygon with twelve edges, for use with polytope functions."
Polytopes`Faces::usage = "\!\(\*RowBox[{\" Faces \", \"[\", StyleBox[\" polytope \", \" TI \"], \"]\"}]\) gives a list of the faces of \!\(\*StyleBox[\" polytope \", \" TI \"]\). "
Polytopes`Heptagon::usage = "Heptagon is a regular polygon with seven edges, for use with polytope functions."
Polytopes`Hexagon::usage = "Hexagon is a regular polygon with six edges, for use with polytope functions."
Polytopes`InscribedRadius::usage = "\!\(\*RowBox[{\" InscribedRadius \", \"[\", StyleBox[\" polygon \", \" TI \"], \"]\"}]\) gives the radius of an inscribed circle of polygon \!\(\*StyleBox[\" polygon \", \" TI \"]\), when the edges of \!\(\*StyleBox[\" polygon \", \" TI \"]\) have unit length."
Polytopes`Nonagon::usage = "Nonagon is a regular polygon with nine edges, for use with polytope functions."
Polytopes`NumberOfEdges::usage = "\!\(\*RowBox[{\" NumberOfEdges \", \"[\", StyleBox[\" polytope \", \" TI \"], \"]\"}]\) gives the number of edges of \!\(\*StyleBox[\" polytope \", \" TI \"]\)."
Polytopes`NumberOfFaces::usage = "\!\(\*RowBox[{\" NumberOfFaces \", \"[\", StyleBox[\" polytope \", \" TI \"], \"]\"}]\) gives the number of faces of \!\(\*StyleBox[\" polytope \", \" TI \"]\)."
Polytopes`NumberOfVertices::usage = "\!\(\*RowBox[{\" NumberOfVertices \", \"[\", StyleBox[\" polytope \", \" TI \"], \"]\"}]\) gives the number of vertices of \!\(\*StyleBox[\" polytope \", \" TI \"]\)."
Polytopes`Octagon::usage = "Octagon is a regular polygon with eight edges, for use with polytope functions."
Polytopes`Pentagon::usage = "Pentagon is a regular polygon with five edges, for use with polytope functions."
Polytopes`Undecagon::usage = "Undecagon is a regular polygon with eleven edges, for use with polytope functions."
Polytopes`Vertices::usage = "\!\(\*RowBox[{\" Vertices \", \"[\", StyleBox[\" polytope \", \" TI \"], \"]\"}]\) gives a list of the vertex coordinates of \!\(\*StyleBox[\" polytope \", \" TI \"]\). "
PrimalityProving`PrimeQCertificateCheck::usage = "\!\(\*RowBox[{\" PrimeQCertificateCheck \", \"[\", RowBox[{StyleBox[\" cert \", \" TI \"], \",\", StyleBox[\" n \", \" TI \"]}], \"]\"}]\) gives True if \!\(\*StyleBox[\" cert \", \" TI \"]\) is a valid certificate for the primality or compositeness of \!\(\*StyleBox[\" n \", \" TI \"]\), and False otherwise."
PrimalityProving`PrimeQCertificate::usage = "\!\(\*RowBox[{\" PrimeQCertificate \", \"[\", StyleBox[\" n \", \" TI \"], \"]\"}]\) gives a certificate that \!\(\*StyleBox[\" n \", \" TI \"]\) is prime or that \!\(\*StyleBox[\" n \", \" TI \"]\) is composite."
PrimalityProving`ProvablePrimeQ::usage = "\!\(\*RowBox[{\" ProvablePrimeQ \", \"[\", StyleBox[\" n \", \" TI \"], \"]\"}]\) gives True if \!\(\*StyleBox[\" n \", \" TI \"]\) is provably prime, and False otherwise."
Quaternions`AbsIJK::usage = "\!\(\*RowBox[{\" AbsIJK \", \"[\", StyleBox[\" q \", \" TI \"], \"]\"}]\) gives the absolute value of the pure quaternion part of \!\(\*StyleBox[\" q \", \" TI \"]\)."
Quaternions`AdjustedSignIJK::usage = "\!\(\*RowBox[{\" AdjustedSignIJK \", \"[\", StyleBox[\" q \", \" TI \"], \"]\"}]\) gives the sign of the pure quaternion part of \!\(\*StyleBox[\" q \", \" TI \"]\), adjusted so its first nonzero component is positive."
Quaternions`FromQuaternion::usage = "\!\(\*RowBox[{\" FromQuaternion \", \"[\", StyleBox[\" q \", \" TI \"], \"]\"}]\) transforms the Quaternion object \!\(\*StyleBox[\" q \", \" TI \"]\) to the symbolic form \!\(\*RowBox[{StyleBox[\" a \", \" TI \"], \"+\", RowBox[{\" I \", \" \", StyleBox[\" b \", \" TI \"]}], \"+\", RowBox[{\" J \", \" \", StyleBox[\" c \", \" TI \"]}], \"+\", RowBox[{\" K \", \" \", StyleBox[\" d \", \" TI \"]}]}]\)."
Quaternions`IntegerQuaternionQ::usage = "\!\(\*RowBox[{\" IntegerQuaternionQ \", \"[\", StyleBox[\" q \", \" TI \"], \"]\"}]\) gives True if \!\(\*StyleBox[\" q \", \" TI \"]\) is an integer quaternion and False otherwise."
Quaternions`J::usage = "J represents a quaternion unit with \!\(\*RowBox[{SuperscriptBox[\" J \", \" 2\"], \"==\", RowBox[{\"-\", \" 1\"}]}]\)."
Quaternions`LeftAssociates::usage = "\!\(\*RowBox[{\" LeftAssociates \", \"[\", StyleBox[\" q \", \" TI \"], \"]\"}]\) gives a list of the 24 left associates of the quaternion \!\(\*StyleBox[\" q \", \" TI \"]\)."
Quaternions`LeftGCD::usage = "\!\(\*RowBox[{\" LeftGCD \", \"[\", RowBox[{StyleBox[\" a \", \" TI \"], \",\", StyleBox[\" b \", \" TI \"]}], \"]\"}]\) gives the greatest common left divisor of the quaternions \!\(\*StyleBox[\" a \", \" TI \"]\) and \!\(\*StyleBox[\" b \", \" TI \"]\)."
Quaternions`PrimaryLeftAssociate::usage = "\!\(\*RowBox[{\" PrimaryLeftAssociate \", \"[\", StyleBox[\" q \", \" TI \"], \"]\"}]\) gives the left associate of the quaternion \!\(\*StyleBox[\" q \", \" TI \"]\) with the largest scalar component."
Quaternions`PrimaryRightAssociate::usage = "\!\(\*RowBox[{\" PrimaryRightAssociate \", \"[\", StyleBox[\" q \", \" TI \"], \"]\"}]\) gives the right associate of the quaternion \!\(\*StyleBox[\" q \", \" TI \"]\) with the largest scalar component."
Quaternions`Quaternion::usage = "\!\(\*RowBox[{\" Quaternion \", \"[\", RowBox[{StyleBox[\" a \", \" TI \"], \",\", StyleBox[\" b \", \" TI \"], \",\", StyleBox[\" c \", \" TI \"], \",\", StyleBox[\" d \", \" TI \"]}], \"]\"}]\) represents the quaternion \!\(\*RowBox[{StyleBox[\" a \", \" TI \"], \"+\", RowBox[{\" I \", \" \", StyleBox[\" b \", \" TI \"]}], \"+\", RowBox[{\" J \", \" \", StyleBox[\" c \", \" TI \"]}], \"+\", RowBox[{\" K \", \" \", StyleBox[\" d \", \" TI \"]}]}]\)."
Quaternions`QuaternionQ::usage = "\!\(\*RowBox[{\" QuaternionQ \", \"[\", StyleBox[\" q \", \" TI \"], \"]\"}]\) gives True if \!\(\*StyleBox[\" q \", \" TI \"]\) is a quaternion and False otherwise."
Quaternions`Quaternions::usage = "Quaternions is an option for PrimeQ which specifies whether factorization should be done over the quaternions."
Quaternions`RightAssociates::usage = "\!\(\*RowBox[{\" RightAssociates \", \"[\", StyleBox[\" q \", \" TI \"], \"]\"}]\) gives a list of the 24 right associates of the quaternion \!\(\*StyleBox[\" q \", \" TI \"]\)."
Quaternions`RightGCD::usage = "\!\(\*RowBox[{\" RightGCD \", \"[\", RowBox[{StyleBox[\" a \", \" TI \"], \",\", StyleBox[\" b \", \" TI \"]}], \"]\"}]\) gives the greatest common right divisor of the quaternions \!\(\*StyleBox[\" a \", \" TI \"]\) and \!\(\*StyleBox[\" b \", \" TI \"]\)."
Quaternions`ScalarQ::usage = "\!\(\*RowBox[{\" ScalarQ \", \"[\", StyleBox[\" q \", \" TI \"], \"]\"}]\) gives True if \!\(\*StyleBox[\" q \", \" TI \"]\) is a real numeric quantity and False otherwise."
Quaternions`ToQuaternion::usage = "\!\(\*RowBox[{\" ToQuaternion \", \"[\", StyleBox[\" q \", \" TI \"], \"]\"}]\) transforms \!\(\*StyleBox[\" q \", \" TI \"]\) into a Quaternion object if possible."
Quaternions`UnitQuaternionQ::usage = "\!\(\*RowBox[{\" UnitQuaternionQ \", \"[\", StyleBox[\" q \", \" TI \"], \"]\"}]\) gives True if \!\(\*StyleBox[\" q \", \" TI \"]\) is a unit quaternion and False otherwise."
Quaternions`UnitQuaternions::usage = "UnitQuaternions gives a list of the 24 units in the ring of integer quaternions."
RegressionCommon`AdjustedRSquared::usage = "AdjustedRSquared is a possible value for the RegressionReport option to Regress and DesignedRegress which represents the adjusted coefficient of determination."
RegressionCommon`ANOVATable::usage = "ANOVATable is a possible value for the RegressionReport option for regression functions which represents the analysis of variance table."
RegressionCommon`AsymptoticCorrelationMatrix::usage = "AsymptoticCorrelationMatrix is a possible value for the RegressionReport option for NonlinearRegress which represents the estimated correlation matrix of the fit parameters."
RegressionCommon`AsymptoticCovarianceMatrix::usage = "AsymptoticCovarianceMatrix is a possible value for the RegressionReport option for NonlinearRegress which represents the estimated covariance matrix of the fit parameters."
RegressionCommon`BestFit::usage = "BestFit is a possible value for the RegressionReport option which represents the fitted function."
RegressionCommon`BestFitParametersDelta::usage = "BestFitParametersDelta is a possible value for the RegressionReport option for Regress and DesignedRegress which represents the effect on parameter values if data points are omitted."
RegressionCommon`BestFitParameters::usage = "BestFitParameters is a possible value for the RegressionReport option which represents the fitted parameter vector."
RegressionCommon`CatcherMatrix::usage = "CatcherMatrix is a possible value for the RegressionReport option for Regress and DesignedRegress which represents the catcher matrix."
RegressionCommon`CoefficientOfVariation::usage = "CoefficientOfVariation is a possible value for the RegressionReport option for Regress and DesignedRegress which represents the coefficient of variation."
RegressionCommon`CookD::usage = "CookD is a possible value for the RegressionReport option for Regress and DesignedRegress which represents a list of Cook's distances."
RegressionCommon`CorrelationMatrix::usage = "CorrelationMatrix is a possible value for the RegressionReport option for Regress and DesignedRegress which represents the estimated correlation matrix of the fit parameters."
RegressionCommon`CovarianceMatrixDetRatio::usage = "CovarianceMatrixDetRatio is a possible value for the RegressionReport option for Regress and DesignedRegress which represents the covariance determinant ratio diagnostic."
RegressionCommon`CovarianceMatrix::usage = "CovarianceMatrix is a possible value for the RegressionReport option for Regress and DesignedRegress which represents the estimated covariance matrix of the fit parameters."
RegressionCommon`DurbinWatsonD::usage = "DurbinWatsonD is a possible value for the RegressionReport option for Regress and DesignedRegress which represents the Durbin-Watson \!\(\*StyleBox[\" d \", \" TI \"]\) statistic for autocorrelation."
RegressionCommon`EigenstructureTable::usage = "EigenstructureTable is a possible value for the RegressionReport option for Regress and DesignedRegress which represents tabular information about the eigenstructure of the parameter correlation matrix."
RegressionCommon`Ellipsoid::usage = "\!\(\*RowBox[{\" Ellipsoid \", \"[\", RowBox[{RowBox[{\" {\", RowBox[{SubscriptBox[StyleBox[\" x \", \" TI \"], StyleBox[\" 1\", \" TR \"]], \",\", StyleBox[\" \[Ellipsis] \", \" TR \"], \",\", SubscriptBox[StyleBox[\" x \", \" TI \"], StyleBox[\" p \", \" TI \"]]}], \"}\"}], \",\", RowBox[{\" {\", RowBox[{SubscriptBox[StyleBox[\" r \", \" TI \"], StyleBox[\" 1\", \" TR \"]], \",\", StyleBox[\" \[Ellipsis] \", \" TR \"], \",\", SubscriptBox[StyleBox[\" r \", \" TI \"], StyleBox[\" p \", \" TI \"]]}], \"}\"}]}], \"]\"}]\) represents a \!\(\*StyleBox[\" p \", \" TI \"]\)-dimensional ellipsoid centered at the point \!\(\*RowBox[{\" {\", RowBox[{SubscriptBox[StyleBox[\" x \", \" TI \"], StyleBox[\" 1\", \" TR \"]], \",\", StyleBox[\" \[Ellipsis] \", \" TR \"], \",\", SubscriptBox[StyleBox[\" x \", \" TI \"], StyleBox[\" p \", \" TI \"]]}], \"}\"}]\) with semi-axis radii \!\(\*SubscriptBox[StyleBox[\" r \", \" TI \"], StyleBox[\" i \", \" TI \"]]\) aligned with the coordinate axes.\n\!\(\*RowBox[{\" Ellipsoid \", \"[\", RowBox[{RowBox[{\" {\", RowBox[{SubscriptBox[StyleBox[\" x \", \" TI \"], StyleBox[\" 1\", \" TR \"]], \",\", StyleBox[\" \[Ellipsis] \", \" TR \"], \",\", SubscriptBox[StyleBox[\" x \", \" TI \"], StyleBox[\" p \", \" TI \"]]}], \"}\"}], \",\", RowBox[{\" {\", RowBox[{SubscriptBox[StyleBox[\" r \", \" TI \"], StyleBox[\" 1\", \" TR \"]], \",\", StyleBox[\" \[Ellipsis] \", \" TR \"], \",\", SubscriptBox[StyleBox[\" r \", \" TI \"], StyleBox[\" p \", \" TI \"]]}], \"}\"}], \",\", RowBox[{\" {\", RowBox[{SubscriptBox[StyleBox[\" d \", \" TI \"], StyleBox[\" 1\", \" TR \"]], \",\", StyleBox[\" \[Ellipsis] \", \" TR \"], \",\", SubscriptBox[StyleBox[\" d \", \" TI \"], StyleBox[\" p \", \" TI \"]]}], \"}\"}]}], \"]\"}]\) represents a \!\(\*StyleBox[\" p \", \" TI \"]\)-dimensional ellipsoid with semi-axis radii \!\(\*SubscriptBox[StyleBox[\" r \", \" TI \"], StyleBox[\" i \", \" TI \"]]\) aligned with the direction \!\(\*SubscriptBox[StyleBox[\" d \", \" TI \"], StyleBox[\" i \", \" TI \"]]\)."
RegressionCommon`EstimatedVariance::usage = "EstimatedVariance is a possible value for the RegressionReport option which represents the estimated error variance."
RegressionCommon`FitCurvatureTable::usage = "FitCurvatureTable is a possible value for the RegressionReport option for NonlinearRegress which represents a table of curvature diagnostics."
RegressionCommon`FitResiduals::usage = "FitResiduals is a possible value for the RegressionReport option which represents the residual errors for the fitted values."
RegressionCommon`HatDiagonal::usage = "HatDiagonal is a possible value for the RegressionReport option which represents the diagonal of the hat matrix."
RegressionCommon`JackknifedVariance::usage = "JackknifedVariance is a possible value for the RegressionReport option for Regress and DesignedRegress which represents the list of jackknifed variance estimates."
RegressionCommon`MeanPredictionCITable::usage = "MeanPredictionCITable is a possible value for the RegressionReport option which represents a table of confidence intervals for the mean predicted responses."
RegressionCommon`ParameterBias::usage = "ParameterBias is a possible value for the RegressionReport option for NonlinearRegress which represents the the estimated bias in the parameter estimates."
RegressionCommon`ParameterCITable::usage = "ParameterCITable is a possible value for the RegressionReport option which represents a table of confidence interval information for the fitted parameters."
RegressionCommon`ParameterConfidenceRegion::usage = "ParameterConfidenceRegion is a possible value for the RegressionReport option which represents the elliptically shaped joint confidence region for parameter estimates."
RegressionCommon`ParameterTable::usage = "ParameterTable is a possible value for the RegressionReport option which represents a table of fitted parameter information."
RegressionCommon`PartialSumOfSquares::usage = "PartialSumOfSquares is a possible value for the RegressionReport to Regress and DesignedRegress which represents the change in model sum of squares as nonconstant basis functions are removed."
RegressionCommon`PredictedResponseDelta::usage = "PredictedResponseDelta is a possible value for the RegressionReport option for Regress and DesignedRegress which represents the effect on predicted values if data points are omitted."
RegressionCommon`PredictedResponse::usage = "PredictedResponse is a possible value for the RegressionReport option which represents the fitted values for the data."
RegressionCommon`RegressionReport::usage = "RegressionReport is an option for Regress, DesignedRegress and NonlinearRegress which specifies the report values to return."
RegressionCommon`RegressionReportValues::usage = "\!\(\*RowBox[{\" RegressionReportValues \", \"[\", StyleBox[\" f \", \" TI \"], \"]\"}]\) gives a list of the possible report values for the regression function \!\(\*StyleBox[\" f \", \" TI \"]\)."
RegressionCommon`RSquared::usage = "RSquared is a possible value for the RegressionReport option for Regress and DesignedRegress which represents the coefficient of determination \!\(\*SuperscriptBox[\" R \", \" 2\"]\)."
RegressionCommon`SequentialSumOfSquares::usage = "SequentialSumOfSquares is a possible value for the RegressionReport option for Regress and DesignedRegress which represents the model sum of squares partitioned componentwise."
RegressionCommon`SinglePredictionCITable::usage = "SinglePredictionCITable is a possible value for the RegressionReport option which represents a table of confidence intervals for the predicted response of single observations."
RegressionCommon`StandardizedResiduals::usage = "StandardizedResiduals is a possible value for the RegressionReport option which represents the list of standardized residuals."
RegressionCommon`StartingParameters::usage = "StartingParameters is a possible value for the RegressionReport option for NonlinearRegress which represents the starting point in the optimization."
RegressionCommon`StudentizedResiduals::usage = "StudentizedResiduals is a possible value for the RegressionReport option for Regress and DesignedRegress which represents the list of studentized residuals."
RegressionCommon`SummaryReport::usage = "SummaryReport is a possible value for the RegressionReport option for regression functions."
RegressionCommon`VarianceInflation::usage = "VarianceInflation is a possible value for the RegressionReport option for Regress and DesignedRegress that represents variance inflation factors."
RegressionCommon`Weights::usage = "Weights is an option for Regress and NonlinearRegress which specifies weights for the input data."
ResonanceAbsorptionLines`AirWavelength::usage = "\!\(\*RowBox[{\" AirWavelength \", \"[\", StyleBox[\" element \", \" TI \"], \"]\"}]\) gives a list of \!\(\*RowBox[{\" {\", RowBox[{SubscriptBox[StyleBox[\" wavelength \", \" TI \"], StyleBox[\" v \", \" TI \"]], \",\", SubscriptBox[StyleBox[\" wavelength \", \" TI \"], StyleBox[\" a \", \" TI \"]]}], \"}\"}]\) pairs, where \!\(\*SubscriptBox[StyleBox[\" wavelength \", \" TI \"], StyleBox[\" v \", \" TI \"]]\) is the wavelength in vacuum and \!\(\*SubscriptBox[StyleBox[\" wavelength \", \" TI \"], StyleBox[\" a \", \" TI \"]]\) is the wavelength in air, for the resonance absorption lines produced by element \!\(\*StyleBox[\" element \", \" TI \"]\).\n\!\(\*RowBox[{\" AirWavelength \", \"[\", RowBox[{StyleBox[\" element \", \" TI \"], \",\", StyleBox[\" ionstage \", \" TI \"]}], \"]\"}]\) gives wavelengths for the lines of the ionization level \!\(\*StyleBox[\" ionstage \", \" TI \"]\)."
ResonanceAbsorptionLines`AtomicData::usage = "\!\(\*RowBox[{\" AtomicData \", \"[\", StyleBox[\" element \", \" TI \"], \"]\"}]\) gives the spectral data of the resonance absorption lines produced by element \!\(\*StyleBox[\" element \", \" TI \"]\).\n\!\(\*RowBox[{\" AtomicData \", \"[\", RowBox[{StyleBox[\" element \", \" TI \"], \",\", StyleBox[\" ionstage \", \" TI \"]}], \"]\"}]\) gives the data for the lines of the ionization level \!\(\*StyleBox[\" ionstage \", \" TI \"]\). "
ResonanceAbsorptionLines`DampingConstant::usage = "\!\(\*RowBox[{\" DampingConstant \", \"[\", StyleBox[\" element \", \" TI \"], \"]\"}]\) gives a list of \!\(\*RowBox[{\" {\", RowBox[{SubscriptBox[StyleBox[\" wavelength \", \" TI \"], StyleBox[\" v \", \" TI \"]], \",\", StyleBox[\" damping \", \" TI \"]}], \"}\"}]\) pairs, where \!\(\*SubscriptBox[StyleBox[\" wavelength \", \" TI \"], StyleBox[\" v \", \" TI \"]]\) is the wavelength in vacuum and \!\(\*StyleBox[\" damping \", \" TI \"]\) is the natural damping constant of the resonance absorption lines produced by element \!\(\*StyleBox[\" element \", \" TI \"]\).\n\!\(\*RowBox[{\" DampingConstant \", \"[\", RowBox[{StyleBox[\" element \", \" TI \"], \",\", StyleBox[\" ionstage \", \" TI \"]}], \"]\"}]\) gives a list of pairs for the lines of the ionization level \!\(\*StyleBox[\" ionstage \", \" TI \"]\)."
ResonanceAbsorptionLines`Deuterium::usage = "Deuterium is an isotope of hydrogen."
ResonanceAbsorptionLines`ElementAbsorptionMap::usage = "\!\(\*RowBox[{\" ElementAbsorptionMap \", \"[\", StyleBox[\" element \", \" TI \"], \"]\"}]\) generates a plot of the absorption map of the element \!\(\*StyleBox[\" element \", \" TI \"]\).\n\!\(\*RowBox[{\" ElementAbsorptionMap \", \"[\", RowBox[{StyleBox[\" element \", \" TI \"], \",\", StyleBox[\" ionstage \", \" TI \"]}], \"]\"}]\) generates a plot for the ionization level \!\(\*StyleBox[\" ionstage \", \" TI \"]\)."
ResonanceAbsorptionLines`FindIons::usage = "\!\(\*RowBox[{\" FindIons \", \"[\", RowBox[{SubscriptBox[StyleBox[\" wavelength \", \" TI \"], StyleBox[\" 1\", \" TR \"]], \",\", SubscriptBox[StyleBox[\" wavelength \", \" TI \"], StyleBox[\" 2\", \" TR \"]]}], \"]\"}]\) gives the resonance absorption lines in the wavelength range between \!\(\*SubscriptBox[StyleBox[\" wavelength \", \" TI \"], StyleBox[\" 1\", \" TR \"]]\) to \!\(\*SubscriptBox[StyleBox[\" wavelength \", \" TI \"], StyleBox[\" 2\", \" TR \"]]\)."
ResonanceAbsorptionLines`IonStage::usage = "IonStage is the ionization level of the element producing resonance absorption lines."
ResonanceAbsorptionLines`LowerStatisticalWeight::usage = "\!\(\*RowBox[{\" LowerStatisticalWeight \", \"[\", StyleBox[\" element \", \" TI \"], \"]\"}]\) gives a list of \!\(\*RowBox[{\" {\", RowBox[{SubscriptBox[StyleBox[\" wavelength \", \" TI \"], StyleBox[\" v \", \" TI \"]], \",\", StyleBox[\" weight \", \" TI \"]}], \"}\"}]\) pairs, where \!\(\*SubscriptBox[StyleBox[\" wavelength \", \" TI \"], StyleBox[\" v \", \" TI \"]]\) is the wavelength in vacuum and \!\(\*StyleBox[\" weight \", \" TI \"]\) is the statistical weight of the lower level of the resonance absorption lines produced by element \!\(\*StyleBox[\" element \", \" TI \"]\).\n\!\(\*RowBox[{\" LowerStatisticalWeight \", \"[\", RowBox[{StyleBox[\" element \", \" TI \"], \",\", StyleBox[\" ionstage \", \" TI \"]}], \"]\"}]\) gives a list of pairs for the lines of the ionization level \!\(\*StyleBox[\" ionstage \", \" TI \"]\)."
ResonanceAbsorptionLines`LowerTermFineStructureEnergy::usage = "\!\(\*RowBox[{\" LowerTermFineStructureEnergy \", \"[\", StyleBox[\" element \", \" TI \"], \"]\"}]\) gives a list of \!\(\*RowBox[{\" {\", RowBox[{SubscriptBox[StyleBox[\" wavelength \", \" TI \"], StyleBox[\" v \", \" TI \"]], \",\", StyleBox[\" energy \", \" TI \"]}], \"}\"}]\) pairs, where \!\(\*SubscriptBox[StyleBox[\" wavelength \", \" TI \"], StyleBox[\" v \", \" TI \"]]\) is the wavelength in vacuum and \!\(\*StyleBox[\" energy \", \" TI \"]\) is the energy of the fine\[Dash]structure level in the lower term of the resonance absorption lines produced by element \!\(\*StyleBox[\" element \", \" TI \"]\).\n\!\(\*RowBox[{\" LowerTermFineStructureEnergy \", \"[\", RowBox[{StyleBox[\" element \", \" TI \"], \",\", StyleBox[\" ionstage \", \" TI \"]}], \"]\"}]\) gives a list of pairs for the lines of the ionization level \!\(\*StyleBox[\" ionstage \", \" TI \"]\)."
ResonanceAbsorptionLines`OscillatorStrength::usage = "\!\(\*RowBox[{\" OscillatorStrength \", \"[\", StyleBox[\" element \", \" TI \"], \"]\"}]\) gives a list of \!\(\*RowBox[{\" {\", RowBox[{SubscriptBox[StyleBox[\" wavelength \", \" TI \"], StyleBox[\" v \", \" TI \"]], \",\", StyleBox[\" strength \", \" TI \"]}], \"}\"}]\) pairs, where \!\(\*SubscriptBox[StyleBox[\" wavelength \", \" TI \"], StyleBox[\" v \", \" TI \"]]\) is the wavelength in vacuum and \!\(\*StyleBox[\" strength \", \" TI \"]\) is the oscillator strength of the resonance absorption lines produced by element \!\(\*StyleBox[\" element \", \" TI \"]\).\n\!\(\*RowBox[{\" OscillatorStrength \", \"[\", RowBox[{StyleBox[\" element \", \" TI \"], \",\", StyleBox[\" ionstage \", \" TI \"]}], \"]\"}]\) gives a list of pairs for the lines of the ionization level \!\(\*StyleBox[\" ionstage \", \" TI \"]\)."
ResonanceAbsorptionLines`RelativeStrength::usage = "\!\(\*RowBox[{\" RelativeStrength \", \"[\", StyleBox[\" element \", \" TI \"], \"]\"}]\) gives a list of \!\(\*RowBox[{\" {\", RowBox[{SubscriptBox[StyleBox[\" wavelength \", \" TI \"], StyleBox[\" v \", \" TI \"]], \",\", StyleBox[\" strength \", \" TI \"]}], \"}\"}]\) pairs, where \!\(\*SubscriptBox[StyleBox[\" wavelength \", \" TI \"], StyleBox[\" v \", \" TI \"]]\) is the wavelength in vacuum and \!\(\*StyleBox[\" strength \", \" TI \"]\) is the relative strength of the resonance absorption lines in the multiplets produced by element \!\(\*StyleBox[\" element \", \" TI \"]\).\n\!\(\*RowBox[{\" RelativeStrength \", \"[\", StyleBox[\" element \", \" TI \"], \"]\"}]\) gives a list of pairs for the lines of the ionization level \!\(\*StyleBox[\" ionstage \", \" TI \"]\)."
ResonanceAbsorptionLines`TransitionProbability::usage = "\!\(\*RowBox[{\" TransitionProbability \", \"[\", StyleBox[\" element \", \" TI \"], \"]\"}]\) gives a list of \!\(\*RowBox[{\" {\", RowBox[{SubscriptBox[StyleBox[\" wavelength \", \" TI \"], StyleBox[\" v \", \" TI \"]], \",\", StyleBox[\" prob \", \" TI \"]}], \"}\"}]\) pairs, where \!\(\*SubscriptBox[StyleBox[\" wavelength \", \" TI \"], StyleBox[\" v \", \" TI \"]]\) is the wavelength in vacuum and \!\(\*StyleBox[\" prob \", \" TI \"]\) is the spontaneous transition probability of the resonance absorption lines produced by the element \!\(\*StyleBox[\" element \", \" TI \"]\).\n\!\(\*RowBox[{\" TransitionProbability \", \"[\", RowBox[{StyleBox[\" element \", \" TI \"], \",\", StyleBox[\" ionstage \", \" TI \"]}], \"]\"}]\) gives a list of pairs for the lines of the ionization level \!\(\*StyleBox[\" ionstage \", \" TI \"]\)."
ResonanceAbsorptionLines`UpperStatisticalWeight::usage = "\!\(\*RowBox[{\" UpperStatisticalWeight \", \"[\", StyleBox[\" element \", \" TI \"], \"]\"}]\) gives a list of \!\(\*RowBox[{\" {\", RowBox[{SubscriptBox[StyleBox[\" wavelength \", \" TI \"], StyleBox[\" v \", \" TI \"]], \",\", StyleBox[\" weight \", \" TI \"]}], \"}\"}]\) pairs, where \!\(\*SubscriptBox[StyleBox[\" wavelength \", \" TI \"], StyleBox[\" v \", \" TI \"]]\) is the wavelength in vacuum and \!\(\*StyleBox[\" weight \", \" TI \"]\) is the statistical weight of the upper level of the resonance absorption lines produced by element \!\(\*StyleBox[\" element \", \" TI \"]\).\n\!\(\*RowBox[{\" UpperStatisticalWeight \", \"[\", RowBox[{StyleBox[\" element \", \" TI \"], \",\", StyleBox[\" ionstage \", \" TI \"]}], \"]\"}]\) gives a list of pairs for the lines of the ionization level \!\(\*StyleBox[\" ionstage \", \" TI \"]\)."
ResonanceAbsorptionLines`VacuumWavelength::usage = "\!\(\*RowBox[{\" VacuumWavelength \", \"[\", StyleBox[\" element \", \" TI \"], \"]\"}]\) gives a list of the wavelengths in vacuum of the resonance absorption lines produced by the specified \!\(\*StyleBox[\" element \", \" TI \"]\).\n\!\(\*RowBox[{\" VacuumWavelength \", \"[\", RowBox[{StyleBox[\" element \", \" TI \"], \",\", StyleBox[\" ionstage \", \" TI \"]}], \"]\"}]\) gives the wavelength in vacuum for the lines of the ionization level \!\(\*StyleBox[\" ionstage \", \" TI \"]\)."
ResonanceAbsorptionLines`WavelengthAbsorptionMap::usage = "\!\(\*RowBox[{\" WavelengthAbsorptionMap \", \"[\", RowBox[{SubscriptBox[StyleBox[\" wavelength \", \" TI \"], StyleBox[\" 1\", \" TR \"]], \",\", SubscriptBox[StyleBox[\" wavelength \", \" TI \"], StyleBox[\" 2\", \" TR \"]]}], \"]\"}]\) generates a plot of the absorption map in the wavelength range between \!\(\*SubscriptBox[StyleBox[\" wavelength \", \" TI \"], StyleBox[\" 1\", \" TR \"]]\) and \!\(\*RowBox[{SubscriptBox[StyleBox[\" wavelength \", \" TI \"], StyleBox[\" 2\", \" TR \"]], \".\"}]\)"
Splines`Bezier::usage = "Bezier is a setting specifying the type of spline generated by Spline and SplineFit."
Splines`CompositeBezier::usage = "CompositeBezier is a setting specifying the type of spline generated by Spline and SplineFit."
Splines`Cubic::usage = "Cubic is a setting specifying the type of spline generated by Spline and SplineFit."
Splines`RenderSpline::usage = "\!\(\*RowBox[{\" RenderSpline \", \"[\", RowBox[{RowBox[{\" {\", RowBox[{SubscriptBox[StyleBox[\" pt \", \" TI \"], StyleBox[\" 1\", \" TR \"]], \",\", SubscriptBox[StyleBox[\" pt \", \" TI \"], StyleBox[\" 2\", \" TR \"]], \",\", StyleBox[\" \[Ellipsis] \", \" TR \"]}], \"}\"}], \",\", StyleBox[\" type \", \" TI \"], \",\", StyleBox[\" splinefunction \", \" TI \"]}], \"]\"}]\) is an alternative rendering method for splines."
Splines`SplineDivision::usage = "SplineDivision is an option for Spline which specifies the maximum number of subdivisions to be used in attempting to generate a smooth spline."
Splines`SplineDots::usage = "SplineDots is an option for Spline that specifies a style for a point. "
Splines`SplineFit::usage = "\!\(\*RowBox[{\" SplineFit \", \"[\", RowBox[{RowBox[{\" {\", RowBox[{SubscriptBox[StyleBox[\" pt \", \" TI \"], StyleBox[\" 1\", \" TR \"]], \",\", SubscriptBox[StyleBox[\" pt \", \" TI \"], StyleBox[\" 2\", \" TR \"]], \",\", StyleBox[\" \[Ellipsis] \", \" TR \"]}], \"}\"}], \",\", StyleBox[\" type \", \" TI \"]}], \"]\"}]\) generates a SplineFunction object of the specified \!\(\*StyleBox[\" type \", \" TI \"]\) from the points \!\(\*RowBox[{SubscriptBox[StyleBox[\" pt \", \" TI \"], StyleBox[\" 1\", \" TR \"]], \",\", SubscriptBox[StyleBox[\" pt \", \" TI \"], StyleBox[\" 2\", \" TR \"]], \",\", StyleBox[\" \[Ellipsis] \", \" TR \"]}]\)."
Splines`SplineFunction::usage = "\!\(\*RowBox[{\" SplineFunction \", \"[\", RowBox[{StyleBox[\" type \", \" TI \"], \",\", StyleBox[\" domain \", \" TI \"], \",\", StyleBox[\" internal \", \" TI \"]}], \"]\"}]\) represents a spline function created by the SplineFit function parametrizing a curve with the parameter in the specified \!\(\*StyleBox[\" domain \", \" TI \"]\). When given a parameter value as an argument it returns the corresponding point on the curve."
Splines`Spline::usage = "\!\(\*RowBox[{\" Spline \", \"[\", RowBox[{RowBox[{\" {\", RowBox[{SubscriptBox[StyleBox[\" pt \", \" TI \"], StyleBox[\" 1\", \" TR \"]], \",\", SubscriptBox[StyleBox[\" pt \", \" TI \"], StyleBox[\" 2\", \" TR \"]], \",\", StyleBox[\" \[Ellipsis] \", \" TR \"]}], \"}\"}], \",\", StyleBox[\" type \", \" TI \"]}], \"]\"}]\) is a two-dimensional graphics primitive which represents a spline of type \!\(\*StyleBox[\" type \", \" TI \"]\) through (or controlled by) points \!\(\*RowBox[{SubscriptBox[StyleBox[\" pt \", \" TI \"], StyleBox[\" 1\", \" TR \"]], \",\", \" \", SubscriptBox[StyleBox[\" pt \", \" TI \"], StyleBox[\" 2\", \" TR \"]], \",\", \" \", StyleBox[\" \[Ellipsis] \", \" TR \"]}]\). "
Splines`SplinePoints::usage = "SplinePoints is an option for Spline which determines the number of initial samples for rendering a spline. "
StandardAtmosphere`AtmosphericPlot::usage = "\!\(\*RowBox[{\" AtmosphericPlot \", \"[\", StyleBox[\" property \", \" TI \"], \"]\"}]\) generates a plot of the specified property \!\(\*StyleBox[\" property \", \" TI \"]\) as a function of geometric altitude. "
StandardAtmosphere`CollisionFrequency::usage = "\!\(\*RowBox[{\" CollisionFrequency \", \"[\", StyleBox[\" altitude \", \" TI \"], \"]\"}]\) gives the collision frequency at the specified altitude \!\(\*StyleBox[\" altitude \", \" TI \"]\)."
StandardAtmosphere`DynamicViscosity::usage = "\!\(\*RowBox[{\" DynamicViscosity \", \"[\", StyleBox[\" altitude \", \" TI \"], \"]\"}]\) gives the coefficient of dynamic viscosity at the specified altitude \!\(\*StyleBox[\" altitude \", \" TI \"]\)."
StandardAtmosphere`GravityAcceleration::usage = "\!\(\*RowBox[{\" GravityAcceleration \", \"[\", StyleBox[\" altitude \", \" TI \"], \"]\"}]\) gives the 45 degree latitude acceleration of gravity at the specified altitude \!\(\*StyleBox[\" altitude \", \" TI \"]\)."
StandardAtmosphere`KinematicViscosity::usage = "\!\(\*RowBox[{\" KinematicViscosity \", \"[\", StyleBox[\" altitude \", \" TI \"], \"]\"}]\) gives the kinematic viscosity at the specified altitude \!\(\*StyleBox[\" altitude \", \" TI \"]\)."
StandardAtmosphere`KineticTemperature::usage = "\!\(\*RowBox[{\" KineticTemperature \", \"[\", StyleBox[\" altitude \", \" TI \"], \"]\"}]\) gives the kinetic temperature at the specified altitude \!\(\*StyleBox[\" altitude \", \" TI \"]\)."
StandardAtmosphere`MeanDensity::usage = "\!\(\*RowBox[{\" MeanDensity \", \"[\", StyleBox[\" altitude \", \" TI \"], \"]\"}]\) gives the mean density of air at the specified altitude \!\(\*StyleBox[\" altitude \", \" TI \"]\)."
StandardAtmosphere`MeanFreePath::usage = "\!\(\*RowBox[{\" MeanFreePath \", \"[\", StyleBox[\" altitude \", \" TI \"], \"]\"}]\) gives the mean free path at the specified altitude \!\(\*StyleBox[\" altitude \", \" TI \"]\)."
StandardAtmosphere`MeanMolecularWeight::usage = "\!\(\*RowBox[{\" MeanMolecularWeight \", \"[\", StyleBox[\" altitude \", \" TI \"], \"]\"}]\) gives the mean molecular weight at the specified altitude \!\(\*StyleBox[\" altitude \", \" TI \"]\)."
StandardAtmosphere`MeanParticleSpeed::usage = "\!\(\*RowBox[{\" MeanParticleSpeed \", \"[\", StyleBox[\" altitude \", \" TI \"], \"]\"}]\) gives the mean particle speed at the specified altitude \!\(\*StyleBox[\" altitude \", \" TI \"]\)."
StandardAtmosphere`NumberDensity::usage = "\!\(\*RowBox[{\" NumberDensity \", \"[\", StyleBox[\" altitude \", \" TI \"], \"]\"}]\) gives the total number density of the mixture of neutral atmospheric gas particles at the specified altitude \!\(\*StyleBox[\" altitude \", \" TI \"]\)."
StandardAtmosphere`Pressure::usage = "\!\(\*RowBox[{\" Pressure \", \"[\", StyleBox[\" altitude \", \" TI \"], \"]\"}]\) gives the total atmospheric pressure at the specified altitude \!\(\*StyleBox[\" altitude \", \" TI \"]\)."
StandardAtmosphere`PressureScaleHeight::usage = "\!\(\*RowBox[{\" PressureScaleHeight \", \"[\", StyleBox[\" altitude \", \" TI \"], \"]\"}]\) gives the local pressure scale height of the mixture of gases comprising the atmosphere at the specified altitude \!\(\*StyleBox[\" altitude \", \" TI \"]\)."
StandardAtmosphere`SoundSpeed::usage = "\!\(\*RowBox[{\" SoundSpeed \", \"[\", StyleBox[\" altitude \", \" TI \"], \"]\"}]\) gives the speed of sound at the specified altitude \!\(\*StyleBox[\" altitude \", \" TI \"]\)."
StandardAtmosphere`ThermalConductivityCoefficient::usage = "\!\(\*RowBox[{\" ThermalConductivityCoefficient \", \"[\", StyleBox[\" altitude \", \" TI \"], \"]\"}]\) gives the coefficient of thermal conductivity at the specified altitude \!\(\*StyleBox[\" altitude \", \" TI \"]\)."
StatisticalPlots`BoxExtraSpacing::usage = "BoxExtraSpacing is an option for BoxWhiskerPlot which specifies spacing adjustments to be applied when plotting multiple boxes."
StatisticalPlots`BoxFillingStyle::usage = "BoxFillingStyle is an option for BoxWhiskerPlot which specifies a color to be used in drawing the box."
StatisticalPlots`BoxLabels::usage = "BoxLabels is an option for BoxWhiskerPlot which specifies labels to be given for each of the data sets."
StatisticalPlots`BoxLineStyle::usage = "BoxLineStyle is an option for BoxWhiskerPlot which specifies styles to be applied to the lines drawn in the plot."
StatisticalPlots`BoxMedianStyle::usage = "BoxMedianStyle is an option for BoxWhiskerPlot which specifies additional styles to be applied specifically to the median lines in the plot."
StatisticalPlots`BoxOrientation::usage = "BoxOrientation is an option for BoxWhiskerPlot which specifies the orientation of the boxes."
StatisticalPlots`BoxOutlierMarkers::usage = "BoxOutlierMarkers is an option for BoxWhiskerPlot which specifies markers to be used for outliers."
StatisticalPlots`BoxOutliers::usage = "BoxOutliers is an option for BoxWhiskerPlot which specifies the outliers to draw."
StatisticalPlots`BoxQuantile::usage = "BoxQuantile is an option for BoxWhiskerPlot which specifies how far the box extends from the median."
StatisticalPlots`BoxWhiskerPlot::usage = "\!\(\*RowBox[{BoxWhiskerPlot, \"[\", StyleBox[\" data \", \" TI \"], \"]\"}]\) creates a box-and-whisker plot of the given vector of \!\(\*StyleBox[\" data \", \" TI \"]\). \n\!\(\*RowBox[{BoxWhiskerPlot, \"[\", RowBox[{SubscriptBox[StyleBox[\" data \", \" TI \"], StyleBox[\" 1\", \" TR \"]], \",\", SubscriptBox[StyleBox[\" data \", \" TI \"], StyleBox[\" 2\", \" TR \"]], \",\", StyleBox[\" \[Ellipsis] \", \" TI \"]}], \"]\"}]\) creates multiple box-and-whisker plots. \n\!\(\*RowBox[{BoxWhiskerPlot, \"[\", StyleBox[\" matrix \", \" TI \"], \"]\"}]\) also creates multiple box-and-whisker plots, with each column of the \!\(\*StyleBox[\" matrix \", \" TI \"]\) used for a separate box."
StatisticalPlots`ColumnLabels::usage = "ColumnLabels is an option for StemLeafPlot which specifies the labels for columns."
StatisticalPlots`DataLabels::usage = "DataLabels is an option for PairwiseScatterPlot which specifies labels for each column of data."
StatisticalPlots`DataRanges::usage = "DataRanges is an option for PairwiseScatterPlot which specifies range limits for each column of data."
StatisticalPlots`DataSpacing::usage = "DataSpacing is an option for PairwiseScatterPlot which specifies spacing between the subplots."
StatisticalPlots`DataTicks::usage = "DataTicks is an option for PairwiseScatterPlot which specifies ticks to place on the plot for each column of data."
StatisticalPlots`IncludeEmptyStems::usage = "IncludeEmptyStems is an option for StemLeafPlot which specifies whether stems with no leaves should be included in the plot."
StatisticalPlots`IncludeStemCounts::usage = "IncludeStemCounts is an option for StemLeafPlot which specifies whether a column of counts for each stem should be included."
StatisticalPlots`IncludeStemUnits::usage = "IncludeStemUnits is an option for StemLeafPlot which specifies whether the units of the stems should be included with the plot."
StatisticalPlots`Leaves::usage = "Leaves is an option for StemLeafPlot that specifies how leaves should be displayed."
StatisticalPlots`PairwiseScatterPlot::usage = "\!\(\*RowBox[{\" PairwiseScatterPlot \", \"[\", StyleBox[\" m \", \" TI \"], StyleBox[\"]\", \" TI \"]}]\) creates a matrix of scatter plots comparing the data in each column of \!\(\*StyleBox[\" m \", \" TI \"]\) against columns of \!\(\*StyleBox[\" m \", \" TI \"]\)."
StatisticalPlots`ParetoPlot::usage = "\!\(\*RowBox[{\" ParetoPlot \", \"[\", StyleBox[\" list \", \" TI \"], \"]\"}]\) creates a Pareto plot from the frequencies of the elements in \!\(\*StyleBox[\" list \", \" TI \"]\).\n\!\(\*RowBox[{\" ParetoPlot \", \"[\", RowBox[{\" {\", RowBox[{RowBox[{\" {\", RowBox[{SubscriptBox[StyleBox[\" cat \", \" TI \"], StyleBox[\" 1\", \" TR \"]], \",\", SubscriptBox[StyleBox[\" freq \", \" TI \"], StyleBox[\" 1\", \" TR \"]]}], \"}\"}], \",\", RowBox[{\" {\", RowBox[{SubscriptBox[StyleBox[\" cat \", \" TI \"], StyleBox[\" 2\", \" TR \"]], \",\", SubscriptBox[StyleBox[\" freq \", \" TI \"], StyleBox[\" 2\", \" TR \"]]}], \"}\"}], \",\", StyleBox[\" \[Ellipsis] \", \" TR \"]}], \"}\"}], \"]\"}]\) creates a Pareto plot from categories \!\(\*SubscriptBox[StyleBox[\" cat \", \" TI \"], StyleBox[\" i \", \" TI \"]]\) with frequencies \!\(\*SubscriptBox[StyleBox[\" freq \", \" TI \"], StyleBox[\" i \", \" TI \"]]\)."
StatisticalPlots`PlotDirection::usage = "PlotDirection is an option for PairwiseScatterPlot which specifies the direction in which scatter plots are generated."
StatisticalPlots`StemExponent::usage = "StemExponent is an option for StemLeafPlot which specifies the integer power of 10 to be used as the stem unit."
StatisticalPlots`StemLeafPlot::usage = "\!\(\*RowBox[{\" StemLeafPlot \", \"[\", StyleBox[\" data \", \" TI \"], \"]\"}]\) creates a stem-and-leaf plot for the real-valued vector \!\(\*StyleBox[\" data \", \" TI \"]\).\n\!\(\*RowBox[{\" StemLeafPlot \", \"[\", RowBox[{SubscriptBox[StyleBox[\" data \", \" TI \"], StyleBox[\" 1\", \" TR \"]], \",\", SubscriptBox[StyleBox[\" data \", \" TI \"], StyleBox[\" 2\", \" TR \"]]}], \"]\"}]\) creates a side-by-side stem-and-leaf plot for the vectors \!\(\*SubscriptBox[StyleBox[\" data \", \" TI \"], StyleBox[\" 1\", \" TR \"]]\) and \!\(\*SubscriptBox[StyleBox[\" data \", \" TI \"], StyleBox[\" 2\", \" TR \"]]\)."
Units`Abampere::usage = "Abampere is a unit of electric current in the CGS system."
Units`Abcoulomb::usage = "Abcoulomb is a unit of electric charge in the CGS system."
Units`Abfarad::usage = "Abfarad is a unit of electric capacitance in the CGS system."
Units`Abhenry::usage = "Abhenry is a unit of inductance in the CGS system."
Units`Abmho::usage = "Abmho is a unit of electric conductance in the CGS system."
Units`Abohm::usage = "Abohm is a unit of electric resistance in the CGS system."
Units`Abvolt::usage = "Abvolt is a unit of electric potential difference in the CGS system."
Units`Acre::usage = "Acre is a unit of area."
Units`Ampere::usage = "Ampere is the fundamental SI unit of electric current."
Units`Amp::usage = "Amp is an abbreviation for Ampere."
Units`AMU::usage = "AMU is a unit of mass. "
Units`Angstrom::usage = "Angstrom is a unit of length."
Units`Apostilb::usage = "Apostilb is a unit of luminance (photometric brightness)."
Units`ArcMinute::usage = "ArcMinute is a unit multiplier."
Units`ArcSecond::usage = "ArcSecond is a unit multiplier."
Units`Are::usage = "Are is a unit of area."
Units`AssayTon::usage = "AssayTon is a unit of mass."
Units`AstronomicalUnit::usage = "AstronomicalUnit is a unit of length."
Units`Atmosphere::usage = "Atmosphere is a unit of pressure."
Units`AtomicMassUnit::usage = "AtomicMassUnit is a unit of mass."
Units`Atto::usage = "Atto is the SI unit prefix denoting \!\(\*SuperscriptBox[StyleBox[\" 10\", \" TR \"], StyleBox[RowBox[{\"-\", \" 18\"}], \" TR \"]]\)."
Units`AU::usage = "AU is a unit of length."
Units`AvoirdupoisOunce::usage = "AvoirdupoisOunce is a unit of weight."
Units`AvoirdupoisPound::usage = "AvoirdupoisPound is a unit of weight."
Units`Bag::usage = "Bag is a unit of volume."
Units`BakersDozen::usage = "BakersDozen is a unit multiplier."
Units`Bale::usage = "Bale is a unit of weight."
Units`Bar::usage = "Bar is a unit of pressure."
Units`Barn::usage = "Barn is a unit of area."
Units`Barrel::usage = "Barrel is a unit of volume."
Units`Barye::usage = "Barye is a unit of pressure."
Units`Baud::usage = "Baud is a unit of information."
Units`Becquerel::usage = "Becquerel is the derived SI unit of radioactivity."
Units`Biot::usage = "Biot is a unit of electric current."
Units`Bit::usage = "Bit is the fundamental unit of information."
Units`BoardFoot::usage = "BoardFoot is a unit of volume."
Units`BohrMagneton::usage = "BohrMagneton is a unit of magnetic moment."
Units`Bolt::usage = "Bolt is a unit of length."
Units`BritishThermalUnit::usage = "BritishThermalUnit is a unit of energy."
Units`BTU::usage = "BTU is a unit of energy."
Units`Bucket::usage = "Bucket is a unit of volume."
Units`Bushel::usage = "Bushel is a unit of volume."
Units`Butt::usage = "Butt is a unit of volume."
Units`Cable::usage = "Cable is a unit of length."
Units`Caliber::usage = "Caliber is a unit of length."
Units`Calorie::usage = "Calorie is a unit of energy."
Units`Candela::usage = "Candela is the fundamental SI unit of luminous intensity."
Units`Candle::usage = "Candle is a unit of luminous intensity."
Units`Carat::usage = "Carat is a unit of weight."
Units`Celsius::usage = "Celsius is a unit of temperature."
Units`Cental::usage = "Cental is a unit of weight."
Units`Centigrade::usage = "Centigrade is a unit of temperature."
Units`Centimeter::usage = "Centimeter is the fundamental CGS unit of length."
Units`Centi::usage = "Centi is the SI unit prefix denoting \!\(\*SuperscriptBox[StyleBox[\" 10\", \" TR \"], RowBox[{\"-\", StyleBox[\" 2\", \" TR \"]}]]\)."
Units`Century::usage = "Century is a unit of time."
Units`CGS::usage = "\!\(\*RowBox[{\" CGS \", \"[\", StyleBox[\" expr \", \" TI \"], \"]\"}]\) converts \!\(\*StyleBox[\" expr \", \" TI \"]\) to CGS units (centimeter/gram/second)."
Units`Chain::usage = "Chain is a unit of length."
Units`ChevalVapeur::usage = "ChevalVapeur is a unit of power."
Units`Cicero::usage = "Cicero is a unit of length."
Units`Convert::usage = "\!\(\*RowBox[{\" Convert \", \"[\", RowBox[{StyleBox[\" expr \", \" TI \"], \",\", StyleBox[\" newunits \", \" TI \"]}], \"]\"}]\) converts \!\(\*StyleBox[\" expr \", \" TI \"]\) to a form involving a combination of units \!\(\*StyleBox[\" newunits \", \" TI \"]\)."
Units`ConvertTemperature::usage = "\!\(\*RowBox[{\" ConvertTemperature \", \"[\", RowBox[{StyleBox[\" temp \", \" TI \"], \",\", StyleBox[\" oldscale \", \" TI \"], \",\", StyleBox[\" newscale \", \" TI \"]}], \"]\"}]\) converts temperature \!\(\*StyleBox[\" temp \", \" TI \"]\) from temperature scale \!\(\*StyleBox[\" oldscale \", \" TI \"]\) to scale \!\(\*StyleBox[\" newscale \", \" TI \"]\)."
Units`Cord::usage = "Cord is a unit of volume."
Units`Coulomb::usage = "Coulomb is the derived SI unit of electric charge."
Units`Cubit::usage = "Cubit is a unit of length."
Units`Curie::usage = "Curie is a unit of radioactivity."
Units`Dalton::usage = "Dalton is a unit of mass."
Units`Day::usage = "Day is a unit of time."
Units`Decade::usage = "Decade is a unit of time."
Units`Deca::usage = "Deca is the SI unit prefix denoting \!\(\*SuperscriptBox[\" 10\", \" 1\"]\)."
Units`Deci::usage = "Deci is the SI unit prefix denoting \!\(\*FractionBox[\" 1\", \" 10\"]\)."
Units`Denier::usage = "Denier is a unit of fineness for yarn or thread."
Units`Didot::usage = "Didot is a unit of length."
Units`DidotPoint::usage = "DidotPoint is a unit of length."
Units`Diopter::usage = "Diopter is a unit of inverse length."
Units`Dozen::usage = "Dozen is a unit multiplier."
Units`Drachma::usage = "Drachma is a unit of weight."
Units`Dyne::usage = "Dyne is the derived CGS unit of force."
Units`ElectronVolt::usage = "ElectronVolt is a unit of energy."
Units`Ell::usage = "Ell is a unit of length."
Units`Ephah::usage = "Ephah is a unit of volume."
Units`Erg::usage = "Erg is the derived CGS unit of energy."
Units`Exa::usage = "Exa is the SI unit prefix denoting \!\(\*SuperscriptBox[\" 10\", \" 18\"]\)."
Units`Fahrenheit::usage = "Fahrenheit is a unit of temperature."
Units`Farad::usage = "Farad is the derived SI unit of electric capacitance."
Units`Fathom::usage = "Fathom is a unit of length."
Units`Feet::usage = "Feet is a unit of length."
Units`Femto::usage = "Femto is the SI unit prefix denoting \!\(\*SuperscriptBox[\" 10\", RowBox[{\"-\", \" 15\"}]]\)."
Units`Fermi::usage = "Fermi is a unit of length."
Units`Fifth::usage = "Fifth is a unit of volume."
Units`Firkin::usage = "Firkin is a unit of volume."
Units`FluidDram::usage = "FluidDram is a unit of volume."
Units`FluidOunce::usage = "FluidOunce is a unit of volume."
Units`FootCandle::usage = "FootCandle is a unit of illumination (illuminance)."
Units`Foot::usage = "Foot is a unit of length."
Units`Fortnight::usage = "Fortnight is a unit of time."
Units`Furlong::usage = "Furlong is a unit of length."
Units`Gallon::usage = "Gallon is a US volume unit."
Units`Gal::usage = "Gal is the derived CGS measure of acceleration due to gravity."
Units`Gauss::usage = "Gauss is the derived CGS unit of magnetic flux density."
Units`Geepound::usage = "Geepound is a unit of mass."
Units`Giga::usage = "Giga is the SI unit prefix denoting \!\(\*SuperscriptBox[\" 10\", \" 9\"]\)."
Units`Gilbert::usage = "Gilbert is a unit of magnetomotive force."
Units`Gill::usage = "Gill is a unit of volume."
Units`Grade::usage = "Grade is a unit multiplier."
Units`Grain::usage = "Grain is a unit of weight."
Units`Gram::usage = "Gram is the fundamental CGS unit of mass."
Units`GramWeight::usage = "GramWeight is a unit of force."
Units`Gravity::usage = "Gravity is a measure of the acceleration due to gravity."
Units`GrayDose::usage = "GrayDose is the derived SI unit of absorbed dose of radiation."
Units`GrossHundredweight::usage = "GrossHundredweight is a unit of weight."
Units`Gross::usage = "Gross is a unit multiplier."
Units`Hand::usage = "Hand is a unit of length."
Units`Hectare::usage = "Hectare is a unit of area."
Units`Hecto::usage = "Hecto is the SI unit prefix denoting \!\(\*SuperscriptBox[\" 10\", \" 2\"]\)."
Units`Hefner::usage = "Hefner is a unit of luminous intensity."
Units`Henry::usage = "Henry is the derived SI unit of inductance."
Units`Hertz::usage = "Hertz is the derived SI unit of frequency."
Units`Hogshead::usage = "Hogshead is a unit of volume."
Units`Horsepower::usage = "Horsepower is a unit of power."
Units`Hour::usage = "Hour is a unit of time."
Units`Hundredweight::usage = "Hundredweight is a unit of weight."
Units`ImperialGallon::usage = "ImperialGallon is a British volume unit."
Units`ImperialPint::usage = "ImperialPint is a British volume unit."
Units`InchMercury::usage = "InchMercury is a unit of pressure."
Units`Inch::usage = "Inch is a unit of length."
Units`Jeroboam::usage = "Jeroboam is a unit of volume."
Units`Jigger::usage = "Jigger is a unit of volume."
Units`Joule::usage = "Joule is the derived SI unit of energy."
Units`Kayser::usage = "Kayser is a unit of inverse length."
Units`Kelvin::usage = "Kelvin is the fundamental SI unit of thermodynamic temperature."
Units`KilogramForce::usage = "KilogramForce is a unit of force."
Units`Kilogram::usage = "Kilogram is the fundamental SI unit of mass."
Units`KilogramWeight::usage = "KilogramWeight is a unit of force."
Units`Kilo::usage = "Kilo is the SI unit prefix denoting \!\(\*SuperscriptBox[\" 10\", \" 3\"]\)."
Units`Knot::usage = "Knot is a unit of speed."
Units`Lambert::usage = "Lambert is a unit of luminance (photometric brightness)."
Units`League::usage = "League is a unit of length."
Units`Libra::usage = "Libra is a unit of weight."
Units`LightYear::usage = "LightYear is a unit of length."
Units`Link::usage = "Link is a unit of length."
Units`Liter::usage = "Liter is a unit of volume."
Units`LongTon::usage = "LongTon is a unit of weight."
Units`Lumen::usage = "Lumen is the derived SI unit of luminous flux."
Units`Lumerg::usage = "Lumerg is a unit of luminous energy (quantity of light)."
Units`Lux::usage = "Lux is the derived SI unit of illumination (illuminance)."
Units`Magnum::usage = "Magnum is a unit of volume."
Units`Maxwell::usage = "Maxwell is the derived CGS unit of magnetic flux."
Units`Mega::usage = "Mega is the SI unit prefix denoting \!\(\*SuperscriptBox[\" 10\", \" 6\"]\)."
Units`Meter::usage = "Meter is the fundamental SI unit of length."
Units`MetricTon::usage = "MetricTon is a unit of mass."
Units`Mho::usage = "Mho is a unit of electric conductance."
Units`Micro::usage = "Micro is the SI unit prefix denoting \!\(\*SuperscriptBox[\" 10\", RowBox[{\"-\", \" 6\"}]]\)."
Units`Micron::usage = "Micron is a unit of length."
Units`Mile::usage = "Mile is a unit of length."
Units`Millennium::usage = "Millennium is a unit of time."
Units`MillimeterMercury::usage = "MillimeterMercury is a unit of pressure."
Units`Milli::usage = "Milli is the SI unit prefix denoting \!\(\*SuperscriptBox[\" 10\", RowBox[{\"-\", \" 3\"}]]\)."
Units`Mil::usage = "Mil is a unit of length."
Units`Mina::usage = "Mina is a unit of weight."
Units`Minim::usage = "Minim is a unit of volume."
Units`Minute::usage = "Minute is a unit of time."
Units`MKS::usage = "\!\(\*RowBox[{\" MKS \", \"[\", StyleBox[\" expr \", \" TI \"], \"]\"}]\) converts \!\(\*StyleBox[\" expr \", \" TI \"]\) to MKS units (meter/kilogram/second)."
Units`Mole::usage = "Mole is the fundamental SI unit of amount of substance."
Units`Month::usage = "Month is a unit of time."
Units`Nano::usage = "Nano is the SI unit prefix denoting \!\(\*SuperscriptBox[\" 10\", RowBox[{\"-\", \" 9\"}]]\)."
Units`NauticalMile::usage = "NauticalMile is a unit of length."
Units`NetHundredweight::usage = "NetHundredweight is a unit of weight."
Units`Newton::usage = "Newton is the derived SI unit of force."
Units`Nibble::usage = "Nibble is a unit of information."
Units`Nit::usage = "Nit is a unit of luminance (photometric brightness)."
Units`Noggin::usage = "Noggin is a unit of volume."
Units`NuclearMagneton::usage = "NuclearMagneton is a unit of magnetic moment."
Units`Obolos::usage = "Obolos is a unit of weight."
Units`Oersted::usage = "Oersted is the derived CGS unit of magnetic intensity."
Units`Ohm::usage = "Ohm is the derived SI unit of electric resistance."
Units`Omer::usage = "Omer is a unit of volume."
Units`Ounce::usage = "Ounce is a unit of weight."
Units`Parsec::usage = "Parsec is a unit of length."
Units`Pascal::usage = "Pascal is the derived SI unit of pressure."
Units`Peck::usage = "Peck is a unit of volume."
Units`Pennyweight::usage = "Pennyweight is a unit of weight."
Units`Percent::usage = "Percent is a unit multiplier."
Units`Perch::usage = "Perch is a unit of length."
Units`Peta::usage = "Peta is the SI unit prefix denoting \!\(\*SuperscriptBox[\" 10\", \" 15\"]\)."
Units`Phot::usage = "Phot is the derived CGS unit of illumination (illuminance)."
Units`Pica::usage = "Pica is a unit of length."
Units`Pico::usage = "Pico is the SI unit prefix denoting \!\(\*SuperscriptBox[\" 10\", RowBox[{\"-\", \" 12\"}]]\)."
Units`Pint::usage = "Pint is a unit of volume."
Units`Poise::usage = "Poise is the derived CGS unit of absolute viscosity."
Units`Pole::usage = "Pole is a unit of length."
Units`Pondus::usage = "Pondus is a unit of weight."
Units`Pony::usage = "Pony is a unit of volume."
Units`Poundal::usage = "Poundal is a unit of force."
Units`PoundForce::usage = "PoundForce is a unit of force."
Units`Pound::usage = "Pound is a unit of weight."
Units`PoundsPerSquareInch::usage = "PoundsPerSquareInch is a unit of pressure."
Units`PoundWeight::usage = "PoundWeight is a unit of force."
Units`PrintersPoint::usage = "PrintersPoint is a unit of length."
Units`PSI::usage = "PSI is a unit of pressure."
Units`Puncheon::usage = "Puncheon is a unit of volume."
Units`Quadrant::usage = "Quadrant is a unit multiplier."
Units`Quart::usage = "Quart is a unit of volume."
Units`Quintal::usage = "Quintal is a unit of mass."
Units`Radian::usage = "Radian is a dimensionless measure of plane angle."
Units`Rad::usage = "Rad is a unit of absorbed dose of radiation."
Units`Rankine::usage = "Rankine is a unit of temperature."
Units`RegisterTon::usage = "RegisterTon is a unit of volume."
Units`Reyn::usage = "Reyn is a unit of absolute viscosity."
Units`Rhes::usage = "Rhes is a unit of viscosity."
Units`RightAngle::usage = "RightAngle is a unit multiplier."
Units`Rod::usage = "Rod is a unit of length."
Units`Roentgen::usage = "Roentgen is a unit of exposure to X or gamma radiation."
Units`Rontgen::usage = "Rontgen is a unit of exposure to X or gamma radiation."
Units`Rood::usage = "Rood is a unit of area."
Units`Rope::usage = "Rope is a unit of length."
Units`Rutherford::usage = "Rutherford is a unit of radioactivity."
Units`Rydberg::usage = "Rydberg is a unit of energy."
Units`Seam::usage = "Seam is a unit of volume."
Units`Second::usage = "Second is the fundamental SI unit of time."
Units`Section::usage = "Section is a unit of area."
Units`Shekel::usage = "Shekel is a unit of weight."
Units`ShortHundredweight::usage = "ShortHundredweight is a unit of weight."
Units`ShortTon::usage = "ShortTon is a unit of weight."
Units`Shot::usage = "Shot is a unit of volume."
Units`SiderealSecond::usage = "SiderealSecond is a unit of time."
Units`SiderealYear::usage = "SiderealYear is a unit of time."
Units`Siemens::usage = "Siemens is the derived SI unit of electric conductance."
Units`SI::usage = "\!\(\*RowBox[{\" SI \", \"[\", StyleBox[\" expr \", \" TI \"], \"]\"}]\) converts \!\(\*StyleBox[\" expr \", \" TI \"]\) to SI units (International System)."
Units`Skein::usage = "Skein is a unit of length."
Units`Slug::usage = "Slug is a unit of mass."
Units`SolarMass::usage = "SolarMass is a unit of mass."
Units`Stadion::usage = "Stadion is a unit of length."
Units`Stadium::usage = "Stadium is a unit of length."
Units`Statampere::usage = "Statampere is a unit of electric current."
Units`Statcoulomb::usage = "Statcoulomb is a unit of electric charge."
Units`Statfarad::usage = "Statfarad is a unit of electric capacitance."
Units`Stathenry::usage = "Stathenry is a unit of inductance."
Units`Statohm::usage = "Statohm is a unit of electric resistance."
Units`StatuteMile::usage = "StatuteMile is a unit of length."
Units`Statvolt::usage = "Statvolt is a unit of electric potential difference."
Units`Steradian::usage = "Steradian is a dimensionless measure of solid angle."
Units`Stere::usage = "Stere is a unit of volume."
Units`Stilb::usage = "Stilb is the derived CGS unit of luminance (photometric brightness)."
Units`Stokes::usage = "Stokes is the derived CGS unit of kinematic viscosity."
Units`Stone::usage = "Stone is a unit of weight."
Units`SurveyMile::usage = "SurveyMile is a unit of length."
Units`Tablespoon::usage = "Tablespoon is a unit of volume."
Units`Talbot::usage = "Talbot is a unit of luminous energy (quantity of light)."
Units`Talent::usage = "Talent is a unit of weight."
Units`Teaspoon::usage = "Teaspoon is a unit of volume."
Units`Tera::usage = "Tera is the SI unit prefix denoting \!\(\*SuperscriptBox[\" 10\", \" 12\"]\)."
Units`Tesla::usage = "Tesla is the derived SI unit of magnetic flux density."
Units`Therm::usage = "Therm is a unit of energy."
Units`TonForce::usage = "TonForce is a unit of force."
Units`Ton::usage = "Ton is a unit of weight."
Units`Tonne::usage = "Tonne is a unit of mass."
Units`Torr::usage = "Torr is a unit of pressure."
Units`Township::usage = "Township is a unit of area."
Units`TropicalYear::usage = "TropicalYear is a unit of time."
Units`TroyOunce::usage = "TroyOunce is a unit of weight."
Units`Tun::usage = "Tun is a unit of volume."
Units`UKGallon::usage = "UKGallon is a British volume unit."
Units`UKPint::usage = "UKPint is a British volume unit."
Units`Volt::usage = "Volt is the derived SI unit of electric potential difference."
Units`Watt::usage = "Watt is the derived SI unit of power."
Units`Weber::usage = "Weber is the derived SI unit of magnetic flux."
Units`Week::usage = "Week is a unit of time."
Units`Wey::usage = "Wey is a unit of weight."
Units`WineBottle::usage = "WineBottle is a unit of volume."
Units`XUnit::usage = "XUnit is a unit of length."
Units`Yard::usage = "Yard is a unit of length."
Units`Year::usage = "Year is a unit of time."
Units`Yocto::usage = "Yocto is the SI unit prefix denoting \!\(\*SuperscriptBox[\" 10\", RowBox[{\"-\", \" 24\"}]]\)."
Units`Yotta::usage = "Yotta is the SI unit prefix denoting \!\(\*SuperscriptBox[\" 10\", \" 24\"]\)."
Units`Zepto::usage = "Zepto is the SI unit prefix denoting \!\(\*SuperscriptBox[\" 10\", RowBox[{\"-\", \" 21\"}]]\)."
Units`Zetta::usage = "Zetta is the SI unit prefix denoting \!\(\*SuperscriptBox[\" 10\", \" 21\"]\)."
VariationalMethods`EulerEquations::usage = "\!\(\*RowBox[{\" EulerEquations \", \"[\", RowBox[{StyleBox[\" f \", \" TI \"], \",\", RowBox[{StyleBox[\" u \", \" TI \"], \"[\", RowBox[{StyleBox[\" x \", \" TI \"], RowBox[{\"]\", \",\"}], StyleBox[\" x \", \" TI \"]}], \"]\"}]}]}]\) returns the Euler-Lagrange differential equation obeyed by \!\(\*RowBox[{StyleBox[\" u \", \" TI \"], \"[\", StyleBox[\" x \", \" TI \"], \"]\"}]\) derived from the functional \!\(\*StyleBox[\" f \", \" TI \"]\), where \!\(\*StyleBox[\" f \", \" TI \"]\) depends on the function \!\(\*RowBox[{StyleBox[\" u \", \" TI \"], \"[\", StyleBox[\" x \", \" TI \"], \"]\"}]\) and its derivatives as well as the independent variable \!\(\*StyleBox[\" x \", \" TI \"]\).\n\!\(\*RowBox[{\" EulerEquations \", \"[\", RowBox[{StyleBox[\" f \", \" TI \"], \",\", RowBox[{StyleBox[\" u \", \" TI \"], \"[\", RowBox[{StyleBox[\" x \", \" TI \"], \",\", StyleBox[\" y \", \" TI \"], \",\", StyleBox[\" \[Ellipsis] \", \" TR \"]}], \"]\"}], \",\", RowBox[{\" {\", RowBox[{StyleBox[\" x \", \" TI \"], \",\", StyleBox[\" y \", \" TI \"], \",\", StyleBox[\" \[Ellipsis] \", \" TR \"]}], \"}\"}]}], \"]\"}]\) returns the Euler-Lagrange differential equation obeyed by \!\(\*RowBox[{StyleBox[\" u \", \" TI \"], \"[\", RowBox[{StyleBox[\" x \", \" TI \"], \",\", StyleBox[\" y \", \" TI \"], \",\", StyleBox[\" \[Ellipsis] \", \" TR \"]}], \"]\"}]\).\n\!\(\*RowBox[{\" EulerEquations \", \"[\", RowBox[{StyleBox[\" f \", \" TI \"], \",\", RowBox[{\" {\", RowBox[{RowBox[{StyleBox[\" u \", \" TI \"], \"[\", RowBox[{StyleBox[\" x \", \" TI \"], \",\", StyleBox[\" y \", \" TI \"], \",\", StyleBox[\" \[Ellipsis] \", \" TR \"]}], \"]\"}], \",\", RowBox[{StyleBox[\" v \", \" TI \"], \"[\", RowBox[{StyleBox[\" x \", \" TI \"], \",\", StyleBox[\" y \", \" TI \"], \",\", StyleBox[\" \[Ellipsis] \", \" TR \"]}], \"]\"}], \",\", StyleBox[\" \[Ellipsis] \", \" TR \"]}], \"}\"}], \",\", RowBox[{\" {\", RowBox[{StyleBox[\" x \", \" TI \"], \",\", StyleBox[\" y \", \" TI \"], \",\", StyleBox[\" \[Ellipsis] \", \" TR \"]}], \"}\"}]}], \"]\"}]\) returns a list of Euler-Lagrange differential equations obeyed by \!\(\*RowBox[{RowBox[{StyleBox[\" u \", \" TI \"], \"[\", RowBox[{StyleBox[\" x \", \" TI \"], \",\", StyleBox[\" y \", \" TI \"], \",\", StyleBox[\" \[Ellipsis] \", \" TR \"]}], \"]\"}], \",\", RowBox[{StyleBox[\" v \", \" TI \"], \"[\", RowBox[{StyleBox[\" x \", \" TI \"], \",\", StyleBox[\" y \", \" TI \"], \",\", StyleBox[\" \[Ellipsis] \", \" TR \"]}], \"]\"}], \",\", StyleBox[\" \[Ellipsis] \", \" TR \"]}]\)."
VariationalMethods`FirstIntegral::usage = "\!\(\*RowBox[{\" FirstIntegral \", \"[\", StyleBox[\" u \", \" TI \"], \"]\"}]\) represents a first integral associated with the variable \!\(\*StyleBox[\" u \", \" TI \"]\) in the output of the function FirstIntegrals."
VariationalMethods`FirstIntegrals::usage = "\!\(\*RowBox[{\" FirstIntegrals \", \"[\", RowBox[{StyleBox[\" f \", \" TI \"], \",\", RowBox[{StyleBox[\" x \", \" TI \"], \"[\", StyleBox[\" t \", \" TI \"], \"]\"}], \",\", StyleBox[\" t \", \" TI \"]}], \"]\"}]\) returns a list of first integrals corresponding to the coordinate \!\(\*RowBox[{StyleBox[\" x \", \" TI \"], \"[\", StyleBox[\" t \", \" TI \"], \"]\"}]\) and independent variable \!\(\*StyleBox[\" t \", \" TI \"]\) of the integrand \!\(\*StyleBox[\" f \", \" TI \"]\).\n\!\(\*RowBox[{\" FirstIntegrals \", \"[\", RowBox[{StyleBox[\" f \", \" TI \"], \",\", RowBox[{\" {\", RowBox[{RowBox[{StyleBox[\" x \", \" TI \"], \"[\", StyleBox[\" t \", \" TI \"], \"]\"}], \",\", RowBox[{StyleBox[\" y \", \" TI \"], \"[\", StyleBox[\" t \", \" TI \"], \"]\"}], \",\", StyleBox[\" \[Ellipsis] \", \" TR \"]}], \"}\"}], \",\", StyleBox[\" t \", \" TI \"]}], \"]\"}]\) returns a list of first integrals corresponding to the coordinates \!\(\*RowBox[{StyleBox[\" x \", \" TI \"], \",\", StyleBox[\" y \", \" TI \"], \",\", StyleBox[\" \[Ellipsis] \", \" TR \"]}]\) and independent variable \!\(\*StyleBox[\" t \", \" TI \"]\)."
VariationalMethods`NVariationalBound::usage = "\!\(\*RowBox[{\" NVariationalBound \", \"[\", RowBox[{StyleBox[\" f \", \" TI \"], \",\", RowBox[{StyleBox[\" u \", \" TI \"], \"[\", RowBox[{RowBox[{StyleBox[\" x \", \" TI \"], RowBox[{\"]\", \",\"}], RowBox[{\" {\", RowBox[{StyleBox[\" x \", \" TI \"], \",\", SubscriptBox[StyleBox[\" x \", \" TI \"], StyleBox[\" min \", \" TI \"]], \",\", SubscriptBox[StyleBox[\" x \", \" TI \"], StyleBox[\" max \", \" TI \"]]}], \"}\"}]}], \",\", SubscriptBox[StyleBox[\" u \", \" TI \"], StyleBox[\" t \", \" TI \"]], \",\", RowBox[{\" {\", RowBox[{StyleBox[\" a \", \" TI \"], \",\", SubscriptBox[StyleBox[\" a \", \" TI \"], StyleBox[\" 0\", \" TR \"]]}], \"}\"}], \",\", RowBox[{\" {\", RowBox[{StyleBox[\" b \", \" TI \"], \",\", SubscriptBox[StyleBox[\" b \", \" TI \"], StyleBox[\" 0\", \" TR \"]]}], \"}\"}], \",\", StyleBox[\" \[Ellipsis] \", \" TI \"]}], \"]\"}]}]}]\) numerically searches for values of the parameters \!\(\*RowBox[{StyleBox[\" a \", \" TI \"], \",\", StyleBox[\" b \", \" TI \"], \",\", StyleBox[\" \[Ellipsis] \", \" TR \"]}]\) of a trial function \!\(\*SubscriptBox[StyleBox[\" u \", \" TI \"], StyleBox[\" t \", \" TI \"]]\), starting from \!\(\*RowBox[{RowBox[{StyleBox[\" a \", \" TI \"], \"=\", SubscriptBox[StyleBox[\" a \", \" TI \"], StyleBox[\" 0\", \" TR \"]]}], \",\", RowBox[{StyleBox[\" b \", \" TI \"], \"=\", SubscriptBox[StyleBox[\" b \", \" TI \"], StyleBox[\" 0\", \" TR \"]]}], \",\", StyleBox[\" \[Ellipsis] \", \" TR \"]}]\), that extremize the functional \!\(\*RowBox[{SubsuperscriptBox[\" \[Integral]\", SubscriptBox[StyleBox[\" x \", \" TI \"], StyleBox[\" min \", \" TI \"]], SubscriptBox[StyleBox[\" x \", \" TI \"], StyleBox[\" max \", \" TI \"]]], RowBox[{UnderscriptBox[StyleBox[\" f \", \" TI \"], \"\"], RowBox[{\" \[DifferentialD]\", StyleBox[\" x \", \" TI \"]}]}]}]\), where the integrand \!\(\*StyleBox[\" f \", \" TI \"]\) is a function of \!\(\*StyleBox[\" u \", \" TI \"]\), its derivatives, and \!\(\*StyleBox[\" x \", \" TI \"]\).\n\!\(\*RowBox[{\" NVariationalBound \", \"[\", RowBox[{StyleBox[\" f \", \" TI \"], \",\", RowBox[{StyleBox[\" u \", \" TI \"], \"[\", RowBox[{StyleBox[\" x \", \" TI \"], \",\", StyleBox[\" y \", \" TI \"], \",\", StyleBox[\" \[Ellipsis] \", \" TR \"]}], \"]\"}], \",\", RowBox[{\" {\", RowBox[{RowBox[{\" {\", RowBox[{StyleBox[\" x \", \" TI \"], \",\", SubscriptBox[StyleBox[\" x \", \" TI \"], StyleBox[\" min \", \" TI \"]], \",\", SubscriptBox[StyleBox[\" x \", \" TI \"], StyleBox[\" max \", \" TI \"]]}], \"}\"}], \",\", StyleBox[\" \[Ellipsis] \", \" TR \"]}], \"}\"}], \",\", SubscriptBox[StyleBox[\" u \", \" TI \"], StyleBox[\" t \", \" TI \"]], \",\", RowBox[{\" {\", RowBox[{StyleBox[\" a \", \" TI \"], \",\", SubscriptBox[StyleBox[\" a \", \" TI \"], StyleBox[\" 0\", \" TR \"]]}], \"}\"}], \",\", RowBox[{\" {\", RowBox[{StyleBox[\" b \", \" TI \"], \",\", SubscriptBox[StyleBox[\" b \", \" TI \"], StyleBox[\" 0\", \" TR \"]]}], \"}\"}], \",\", StyleBox[\" \[Ellipsis] \", \" TR \"]}], \"]\"}]\) searches for values of the parameters of a trial function of two or more variables.\n\!\(\*RowBox[{\" NVariationalBound \", \"[\", RowBox[{RowBox[{\" {\", RowBox[{StyleBox[\" f \", \" TI \"], \",\", StyleBox[\" g \", \" TI \"]}], \"}\"}], \",\", RowBox[{StyleBox[\" u \", \" TI \"], \"[\", StyleBox[\" x \", \" TI \"], \"]\"}], \",\", RowBox[{\" {\", RowBox[{StyleBox[\" x \", \" TI \"], \",\", SubscriptBox[StyleBox[\" x \", \" TI \"], StyleBox[\" min \", \" TI \"]], \",\", SubscriptBox[StyleBox[\" x \", \" TI \"], StyleBox[\" max \", \" TI \"]]}], \"}\"}], \",\", SubscriptBox[StyleBox[\" u \", \" TI \"], StyleBox[\" t \", \" TI \"]], \",\", RowBox[{\" {\", RowBox[{StyleBox[\" a \", \" TI \"], \",\", SubscriptBox[StyleBox[\" a \", \" TI \"], StyleBox[\" 0\", \" TR \"]]}], \"}\"}], \",\", RowBox[{\" {\", RowBox[{StyleBox[\" b \", \" TI \"], \",\", SubscriptBox[StyleBox[\" b \", \" TI \"], StyleBox[\" 0\", \" TR \"]]}], \"}\"}], \",\", StyleBox[\" \[Ellipsis] \", \" TR \"]}], \"]\"}]\) searches for values of the parameters that extremize the ratio \!\(\*RowBox[{SubsuperscriptBox[\" \[Integral]\", SubscriptBox[StyleBox[\" x \", \" TI \"], StyleBox[\" min \", \" TI \"]], SubscriptBox[StyleBox[\" x \", \" TI \"], StyleBox[\" max \", \" TI \"]]], RowBox[{UnderscriptBox[StyleBox[\" f \", \" TI \"], \"\"], RowBox[{RowBox[{\" \[DifferentialD]\", StyleBox[\" x \", \" TI \"]}], StyleBox[\"/\", \" TI \"], RowBox[{SubsuperscriptBox[\" \[Integral]\", SubscriptBox[StyleBox[\" x \", \" TI \"], StyleBox[\" min \", \" TI \"]], SubscriptBox[StyleBox[\" x \", \" TI \"], StyleBox[\" max \", \" TI \"]]], RowBox[{UnderscriptBox[StyleBox[\" g \", \" TI \"], \"\"], RowBox[{\" \[DifferentialD]\", StyleBox[\" x \", \" TI \"]}]}]}]}]}]}]\), where the integrands \!\(\*StyleBox[\" f \", \" TI \"]\) and \!\(\*StyleBox[\" g \", \" TI \"]\) are functions of \!\(\*StyleBox[\" u \", \" TI \"]\), its derivatives, and \!\(\*StyleBox[\" x \", \" TI \"]\)."
VariationalMethods`VariationalBound::usage = "\!\(\*RowBox[{\" VariationalBound \", \"[\", RowBox[{StyleBox[\" f \", \" TI \"], \",\", RowBox[{StyleBox[\" u \", \" TI \"], \"[\", RowBox[{RowBox[{StyleBox[\" x \", \" TI \"], RowBox[{\"]\", \",\"}], RowBox[{\" {\", RowBox[{StyleBox[\" x \", \" TI \"], \",\", SubscriptBox[StyleBox[\" x \", \" TI \"], StyleBox[\" min \", \" TI \"]], \",\", SubscriptBox[StyleBox[\" x \", \" TI \"], StyleBox[\" max \", \" TI \"]]}], \"}\"}]}], \",\", SubscriptBox[StyleBox[\" u \", \" TI \"], StyleBox[\" t \", \" TI \"]], \",\", RowBox[{\" {\", StyleBox[\" a \", \" TI \"], \"}\"}], \",\", RowBox[{\" {\", StyleBox[\" b \", \" TI \"], \"}\"}], \",\", StyleBox[\" \[Ellipsis] \", \" TI \"]}], \"]\"}]}]}]\) finds values of the parameters \!\(\*RowBox[{StyleBox[\" a \", \" TI \"], \",\", StyleBox[\" b \", \" TI \"], \",\", StyleBox[\" \[Ellipsis] \", \" TR \"]}]\) of a trial function \!\(\*SubscriptBox[StyleBox[\" u \", \" TI \"], StyleBox[\" t \", \" TI \"]]\) that extremize the functional \!\(\*RowBox[{SubsuperscriptBox[\" \[Integral]\", SubscriptBox[StyleBox[\" x \", \" TI \"], StyleBox[\" min \", \" TI \"]], SubscriptBox[StyleBox[\" x \", \" TI \"], StyleBox[\" max \", \" TI \"]]], RowBox[{UnderscriptBox[StyleBox[\" f \", \" TI \"], \"\"], RowBox[{\" \[DifferentialD]\", StyleBox[\" x \", \" TI \"]}]}]}]\), where the integrand \!\(\*StyleBox[\" f \", \" TI \"]\) is a function of \!\(\*StyleBox[\" u \", \" TI \"]\), its derivatives, and \!\(\*StyleBox[\" x \", \" TI \"]\).\n\!\(\*RowBox[{\" VariationalBound \", \"[\", RowBox[{StyleBox[\" f \", \" TI \"], \",\", RowBox[{StyleBox[\" u \", \" TI \"], \"[\", RowBox[{StyleBox[\" x \", \" TI \"], \",\", StyleBox[\" y \", \" TI \"], \",\", StyleBox[\" \[Ellipsis] \", \" TR \"]}], \"]\"}], \",\", RowBox[{\" {\", RowBox[{RowBox[{\" {\", RowBox[{StyleBox[\" x \", \" TI \"], \",\", SubscriptBox[StyleBox[\" x \", \" TI \"], StyleBox[\" min \", \" TI \"]], \",\", SubscriptBox[StyleBox[\" x \", \" TI \"], StyleBox[\" max \", \" TI \"]]}], \"}\"}], \",\", RowBox[{\" {\", RowBox[{StyleBox[\" y \", \" TI \"], \",\", SubscriptBox[StyleBox[\" y \", \" TI \"], StyleBox[\" min \", \" TI \"]], \",\", SubscriptBox[StyleBox[\" y \", \" TI \"], StyleBox[\" max \", \" TI \"]]}], \"}\"}], \",\", StyleBox[\" \[Ellipsis] \", \" TR \"]}], \"}\"}], \",\", SubscriptBox[StyleBox[\" u \", \" TI \"], StyleBox[\" t \", \" TI \"]], \",\", RowBox[{\" {\", StyleBox[\" a \", \" TI \"], \"}\"}], \",\", RowBox[{\" {\", StyleBox[\" b \", \" TI \"], \"}\"}], \",\", StyleBox[\" \[Ellipsis] \", \" TR \"]}], \"]\"}]\) finds values of the parameters of a trial function of two or more variables.\n\!\(\*RowBox[{\" VariationalBound \", \"[\", RowBox[{RowBox[{\" {\", RowBox[{StyleBox[\" f \", \" TI \"], \",\", StyleBox[\" g \", \" TI \"]}], \"}\"}], \",\", RowBox[{StyleBox[\" u \", \" TI \"], \"[\", StyleBox[\" x \", \" TI \"], \"]\"}], \",\", RowBox[{\" {\", RowBox[{StyleBox[\" x \", \" TI \"], \",\", SubscriptBox[StyleBox[\" x \", \" TI \"], StyleBox[\" min \", \" TI \"]], \",\", SubscriptBox[StyleBox[\" x \", \" TI \"], StyleBox[\" max \", \" TI \"]]}], \"}\"}], \",\", SubscriptBox[StyleBox[\" u \", \" TI \"], StyleBox[\" t \", \" TI \"]], \",\", RowBox[{\" {\", StyleBox[\" a \", \" TI \"], \"}\"}], \",\", RowBox[{\" {\", StyleBox[\" b \", \" TI \"], \"}\"}], \",\", StyleBox[\" \[Ellipsis] \", \" TR \"]}], \"]\"}]\) finds values of the parameters that extremize the ratio \!\(\*RowBox[{SubsuperscriptBox[\" \[Integral]\", SubscriptBox[StyleBox[\" x \", \" TI \"], StyleBox[\" min \", \" TI \"]], SubscriptBox[StyleBox[\" x \", \" TI \"], StyleBox[\" max \", \" TI \"]]], RowBox[{UnderscriptBox[StyleBox[\" f \", \" TI \"], \"\"], RowBox[{RowBox[{\" \[DifferentialD]\", StyleBox[\" x \", \" TI \"]}], StyleBox[\"/\", \" TI \"], RowBox[{SubsuperscriptBox[\" \[Integral]\", SubscriptBox[StyleBox[\" x \", \" TI \"], StyleBox[\" min \", \" TI \"]], SubscriptBox[StyleBox[\" x \", \" TI \"], StyleBox[\" max \", \" TI \"]]], RowBox[{UnderscriptBox[StyleBox[\" g \", \" TI \"], \"\"], RowBox[{\" \[DifferentialD]\", StyleBox[\" x \", \" TI \"]}]}]}]}]}]}]\), where the integrands \!\(\*StyleBox[\" f \", \" TI \"]\) and \!\(\*StyleBox[\" g \", \" TI \"]\) are functions of \!\(\*StyleBox[\" u \", \" TI \"]\), its derivatives, and \!\(\*StyleBox[\" x \", \" TI \"]\)."
VariationalMethods`VariationalD::usage = "\!\(\*RowBox[{\" VariationalD \", \"[\", RowBox[{StyleBox[\" f \", \" TI \"], \",\", RowBox[{StyleBox[\" u \", \" TI \"], \"[\", RowBox[{StyleBox[\" x \", \" TI \"], RowBox[{\"]\", \",\"}], StyleBox[\" x \", \" TI \"]}], \"]\"}]}]}]\) returns the variational derivative of the integral \!\(\*RowBox[{\" \[Integral]\", RowBox[{StyleBox[\" f \", \" TI \"], RowBox[{\" \[DifferentialD]\", StyleBox[\" x \", \" TI \"]}]}]}]\) with respect to \!\(\*RowBox[{StyleBox[\" u \", \" TI \"], \"[\", StyleBox[\" x \", \" TI \"], \"]\"}]\), where the integrand \!\(\*StyleBox[\" f \", \" TI \"]\) is a function of \!\(\*StyleBox[\" u \", \" TI \"]\), its derivatives, and \!\(\*StyleBox[\" x \", \" TI \"]\).\n\!\(\*RowBox[{\" VariationalD \", \"[\", RowBox[{StyleBox[\" f \", \" TI \"], \",\", RowBox[{StyleBox[\" u \", \" TI \"], \"[\", RowBox[{StyleBox[\" x \", \" TI \"], \",\", StyleBox[\" y \", \" TI \"], \",\", StyleBox[\" \[Ellipsis] \", \" TR \"]}], \"]\"}], \",\", RowBox[{\" {\", RowBox[{StyleBox[\" x \", \" TI \"], \",\", StyleBox[\" y \", \" TI \"], \",\", StyleBox[\" \[Ellipsis] \", \" TR \"]}], \"}\"}]}], \"]\"}]\) returns the variational derivative of the multiple integral \!\(\*RowBox[{\" \[Integral]\", RowBox[{StyleBox[\" f \", \" TI \"], RowBox[{\" \[DifferentialD]\", StyleBox[\" x \", \" TI \"]}], RowBox[{\" \[DifferentialD]\", StyleBox[\" y \", \" TI \"]}], \" \", StyleBox[\" \[Ellipsis] \", \" TR \"]}]}]\) with respect to \!\(\*RowBox[{StyleBox[\" u \", \" TI \"], \"[\", RowBox[{StyleBox[\" x \", \" TI \"], \",\", StyleBox[\" y \", \" TI \"], \",\", StyleBox[\" \[Ellipsis] \", \" TR \"]}], \"]\"}]\), where \!\(\*StyleBox[\" f \", \" TI \"]\) is a function of \!\(\*StyleBox[\" u \", \" TI \"]\), its derivatives and the coordinates \!\(\*RowBox[{StyleBox[\" x \", \" TI \"], \",\", StyleBox[\" y \", \" TI \"], \",\", StyleBox[\" \[Ellipsis] \", \" TR \"]}]\).\n\!\(\*RowBox[{\" VariationalD \", \"[\", RowBox[{StyleBox[\" f \", \" TI \"], \",\", RowBox[{\" {\", RowBox[{RowBox[{StyleBox[\" u \", \" TI \"], \"[\", RowBox[{StyleBox[\" x \", \" TI \"], \",\", StyleBox[\" y \", \" TI \"], \",\", StyleBox[\" \[Ellipsis] \", \" TR \"]}], \"]\"}], \",\", RowBox[{StyleBox[\" v \", \" TI \"], \"[\", RowBox[{StyleBox[\" x \", \" TI \"], \",\", StyleBox[\" y \", \" TI \"], \",\", StyleBox[\" \[Ellipsis] \", \" TR \"]}], \"]\"}], \",\", StyleBox[\" \[Ellipsis] \", \" TR \"]}], \"}\"}], \",\", RowBox[{\" {\", RowBox[{StyleBox[\" x \", \" TI \"], \",\", StyleBox[\" y \", \" TI \"], \",\", StyleBox[\" \[Ellipsis] \", \" TR \"]}], \"}\"}]}], \"]\"}]\) gives a list of variational derivatives with respect to \!\(\*RowBox[{StyleBox[\" u \", \" TI \"], \",\", StyleBox[\" v \", \" TI \"], \",\", StyleBox[\" \[Ellipsis] \", \" TR \"]}]\)."
VectorAnalysis`ArcLengthFactor::usage = "\!\(\*RowBox[{\" ArcLengthFactor \", \"[\", RowBox[{RowBox[{\" {\", RowBox[{SubscriptBox[StyleBox[\" f \", \" TI \"], \" 1\"], \",\", SubscriptBox[StyleBox[\" f \", \" TI \"], \" 2\"], \",\", SubscriptBox[StyleBox[\" f \", \" TI \"], \" 3\"]}], \"}\"}], \",\", StyleBox[\" t \", \" TI \"]}], \"]\"}]\) gives the derivative of the arc length of the curve described by the parametrized curve coordinates \!\(\*RowBox[{\" {\", RowBox[{SubscriptBox[StyleBox[\" f \", \" TI \"], \" 1\"], \",\", SubscriptBox[StyleBox[\" f \", \" TI \"], \" 2\"], \",\", SubscriptBox[StyleBox[\" f \", \" TI \"], \" 3\"]}], \"}\"}]\) with respect to the parameter \!\(\*StyleBox[\" t \", \" TI \"]\) in the default coordinate system. \n\!\(\*RowBox[{\" ArcLengthFactor \", \"[\", RowBox[{RowBox[{\" {\", RowBox[{SubscriptBox[StyleBox[\" f \", \" TI \"], \" 1\"], \",\", SubscriptBox[StyleBox[\" f \", \" TI \"], \" 2\"], \",\", SubscriptBox[StyleBox[\" f \", \" TI \"], \" 3\"]}], \"}\"}], \",\", StyleBox[\" t \", \" TI \"], \",\", StyleBox[\" coordsys \", \" TI \"]}], \"]\"}]\) gives the derivative of the arc length of a curve in the coordinate system \!\(\*StyleBox[\" coordsys \", \" TI \"]\)."
VectorAnalysis`Biharmonic::usage = "\!\(\*RowBox[{\" Biharmonic \", \"[\", StyleBox[\" f \", \" TI \"], \"]\"}]\) gives the biharmonic, \!\(\*RowBox[{SuperscriptBox[\" \[Del]\", \" 4\"], StyleBox[\" f \", \" TI \"]}]\), of the scalar function \!\(\*StyleBox[\" f \", \" TI \"]\) in the default coordinate system. \n\!\(\*RowBox[{\" Biharmonic \", \"[\", RowBox[{StyleBox[\" f \", \" TI \"], \",\", StyleBox[\" coordsys \", \" TI \"]}], \"]\"}]\) gives the biharmonic of \!\(\*StyleBox[\" f \", \" TI \"]\) in the coordinate system \!\(\*StyleBox[\" coordsys \", \" TI \"]\)."
VectorAnalysis`Bipolar::usage = "Bipolar represents the bipolar coordinate system with default variables Uu, Vv, and Zz and default parameter value \!\(\*StyleBox[\" 1\", \" TR \"]\). \n\!\(\*RowBox[{\" Bipolar \", \"[\", RowBox[{StyleBox[\" u \", \" TI \"], \",\", StyleBox[\" v \", \" TI \"], \",\", StyleBox[\" z \", \" TI \"]}], \"]\"}]\) represents the bipolar coordinate system with variables \!\(\*StyleBox[\" u \", \" TI \"]\), \!\(\*StyleBox[\" v \", \" TI \"]\), and \!\(\*StyleBox[\" z \", \" TI \"]\) and default parameter value \!\(\*StyleBox[\" 1\", \" TR \"]\). \n\!\(\*RowBox[{\" Bipolar \", \"[\", RowBox[{StyleBox[\" u \", \" TI \"], \",\", StyleBox[\" v \", \" TI \"], \",\", StyleBox[\" z \", \" TI \"], \",\", StyleBox[\" a \", \" TI \"]}], \"]\"}]\) represents the bipolar coordinate system with variables \!\(\*StyleBox[\" u \", \" TI \"]\), \!\(\*StyleBox[\" v \", \" TI \"]\), and \!\(\*StyleBox[\" z \", \" TI \"]\), and parameter \!\(\*StyleBox[\" a \", \" TI \"]\)."
VectorAnalysis`Bispherical::usage = "Bispherical represents the bispherical coordinate system with default variables \!\(\*RowBox[{\" Uu \", \",\", \" Vv \"}]\), and Pphi and default parameter value \!\(\*StyleBox[\" 1\", \" TR \"]\). \n\!\(\*RowBox[{\" Bispherical \", \"[\", RowBox[{StyleBox[\" u \", \" TI \"], \",\", StyleBox[\" v \", \" TI \"], \",\", StyleBox[\" \[Phi] \", \" TR \"]}], \"]\"}]\) represents the bispherical coordinate system with variables \!\(\*StyleBox[\" u \", \" TI \"]\), \!\(\*StyleBox[\" v \", \" TI \"]\), and \!\(\*StyleBox[\" \[Phi] \", \" TR \"]\) and default parameter value \!\(\*StyleBox[\" 1\", \" TR \"]\). \n\!\(\*RowBox[{\" Bispherical \", \"[\", RowBox[{StyleBox[\" u \", \" TI \"], \",\", StyleBox[\" v \", \" TI \"], \",\", StyleBox[\" \[Phi] \", \" TR \"], \",\", StyleBox[\" a \", \" TI \"]}], \"]\"}]\) represents the bispherical coordinate system with variables \!\(\*StyleBox[\" u \", \" TI \"]\), \!\(\*StyleBox[\" v \", \" TI \"]\), and \!\(\*StyleBox[\" \[Phi] \", \" TR \"]\) and parameter \!\(\*StyleBox[\" a \", \" TI \"]\)."
VectorAnalysis`Cartesian::usage = "Cartesian represents the Cartesian coordinate system with default variables \!\(\*RowBox[{\" Xx \", \",\", \" Yy \"}]\) and Zz.\n\!\(\*RowBox[{\" Cartesian \", \"[\", RowBox[{StyleBox[\" x \", \" TI \"], \",\", StyleBox[\" y \", \" TI \"], \",\", StyleBox[\" z \", \" TI \"]}], \"]\"}]\) represents the Cartesian coordinate system with variables \!\(\*StyleBox[\" x \", \" TI \"]\), \!\(\*StyleBox[\" y \", \" TI \"]\), and \!\(\*StyleBox[\" z \", \" TI \"]\)."
VectorAnalysis`ConfocalEllipsoidal::usage = "ConfocalEllipsoidal represents the confocal ellipsoidal coordinate system with default variables \!\(\*RowBox[{\" Llambda \", \",\", \" Mmu \"}]\) and Nnu and default parameter values \!\(\*StyleBox[\" 3\", \" TR \"]\), \!\(\*StyleBox[\" 2\", \" TR \"]\), and \!\(\*StyleBox[\" 1\", \" TR \"]\). \n\!\(\*RowBox[{\" ConfocalEllipsoidal \", \"[\", RowBox[{StyleBox[\" \[Lambda] \", \" TR \"], \",\", StyleBox[\" \[Mu] \", \" TR \"], \",\", StyleBox[\" \[Nu] \", \" TR \"]}], \"]\"}]\) represents the confocal ellipsoidal coordinate system with variables \!\(\*RowBox[{StyleBox[\" \[Lambda] \", \" TR \"], \",\", StyleBox[\" \[Mu] \", \" TR \"]}]\) and \[Nu] and default parameter values 3, 2, and 1. \n \!\(\*RowBox[{\" ConfocalEllipsoidal \", \"[\", RowBox[{StyleBox[\" \[Lambda] \", \" TR \"], \",\", StyleBox[\" \[Mu] \", \" TR \"], \",\", StyleBox[\" \[Nu] \", \" TR \"], \",\", StyleBox[\" a \", \" TI \"], \",\", StyleBox[\" b \", \" TI \"], \",\", StyleBox[\" c \", \" TI \"]}], \"]\"}]\) represents the confocal ellipsoidal coordinate system with variables \!\(\*RowBox[{StyleBox[\" \[Lambda] \", \" TR \"], \",\", StyleBox[\" \[Mu] \", \" TR \"]}]\) and \[Nu] and parameters \!\(\*StyleBox[\" a \", \" TI \"]\), \!\(\*StyleBox[\" b \", \" TI \"]\), and \!\(\*StyleBox[\" c \", \" TI \"]\)."
VectorAnalysis`ConfocalParaboloidal::usage = "ConfocalParaboloidal represents the confocal paraboloidal coordinate system with default variables \!\(\*RowBox[{\" Llambda \", \",\", \" Mmu \"}]\) and Nnu and default parameter values \!\(\*StyleBox[\" 2\", \" TR \"]\) and \!\(\*StyleBox[\" 1\", \" TR \"]\). \n\!\(\*RowBox[{\" ConfocalParaboloidal \", \"[\", RowBox[{StyleBox[\" \[Lambda] \", \" TR \"], \",\", StyleBox[\" \[Mu] \", \" TR \"], \",\", StyleBox[\" \[Nu] \", \" TR \"]}], \"]\"}]\) represents the confocal paraboloidal coordinate system with variables \!\(\*RowBox[{StyleBox[\" \[Lambda] \", \" TR \"], \",\", StyleBox[\" \[Mu] \", \" TR \"]}]\) and \!\(\*StyleBox[\" \[Nu] \", \" TR \"]\) and default parameter values \!\(\*StyleBox[\" 2\", \" TR \"]\) and \!\(\*StyleBox[\" 1\", \" TR \"]\).\n\!\(\*RowBox[{\" ConfocalParaboloidal \", \"[\", RowBox[{StyleBox[\" \[Lambda] \", \" TR \"], \",\", StyleBox[\" \[Mu] \", \" TR \"], \",\", StyleBox[\" \[Nu] \", \" TR \"], \",\", StyleBox[\" a \", \" TI \"], \",\", StyleBox[\" b \", \" TI \"]}], \"]\"}]\) represents the confocal paraboloidal coordinate system with variables \!\(\*RowBox[{StyleBox[\" \[Lambda] \", \" TR \"], \",\", StyleBox[\" \[Mu] \", \" TR \"]}]\) and \!\(\*StyleBox[\" \[Nu] \", \" TR \"]\) and parameters \!\(\*StyleBox[\" a \", \" TI \"]\) and \!\(\*StyleBox[\" b \", \" TI \"]\)."
VectorAnalysis`Conical::usage = "Conical represents the conical coordinate system with default variables \!\(\*RowBox[{\" LLambda \", \",\", \" Mmu \"}]\) and Nnu and default parameter values \!\(\*StyleBox[\" 1\", \" TR \"]\) and \!\(\*StyleBox[\" 2\", \" TR \"]\). \n\!\(\*RowBox[{\" Conical \", \"[\", RowBox[{StyleBox[\" \[Lambda] \", \" TR \"], \",\", StyleBox[\" \[Mu] \", \" TR \"], \",\", StyleBox[\" \[Nu] \", \" TR \"]}], \"]\"}]\) represents the conical coordinate system with variables \!\(\*RowBox[{StyleBox[\" \[Lambda] \", \" TR \"], \",\", StyleBox[\" \[Mu] \", \" TR \"]}]\) and \!\(\*StyleBox[\" \[Nu] \", \" TR \"]\) and default parameter values 1 and 2. \n \!\(\*RowBox[{\" Conical \", \"[\", RowBox[{StyleBox[\" \[Lambda] \", \" TR \"], \",\", StyleBox[\" \[Mu] \", \" TR \"], \",\", StyleBox[\" \[Nu] \", \" TR \"], \",\", StyleBox[\" a \", \" TI \"], \",\", StyleBox[\" b \", \" TI \"]}], \"]\"}]\) represents the conical coordinate system with variables \!\(\*RowBox[{StyleBox[\" \[Lambda] \", \" TR \"], \",\", StyleBox[\" \[Mu] \", \" TR \"]}]\) and \!\(\*StyleBox[\" \[Nu] \", \" TR \"]\) and parameters \!\(\*StyleBox[\" a \", \" TI \"]\) and \!\(\*StyleBox[\" b \", \" TI \"]\)."
VectorAnalysis`CoordinateRanges::usage = "\!\(\*RowBox[{\" CoordinateRanges \", \"[\", \"]\"}]\) gives the intervals over which each of the coordinates in the default coordinate system may range. \n\!\(\*RowBox[{\" CoordinateRanges \", \"[\", StyleBox[\" coordsys \", \" TI \"], \"]\"}]\) gives the ranges for each of the coordinates in the coordinate system \!\(\*StyleBox[\" coordsys \", \" TI \"]\)."
VectorAnalysis`CoordinatesFromCartesian::usage = "\!\(\*RowBox[{\" CoordinatesFromCartesian \", \"[\", StyleBox[\" pt \", \" TI \"], \"]\"}]\) gives the coordinates in the default coordinate system of the point \!\(\*StyleBox[\" pt \", \" TI \"]\) given in Cartesian coordinates. \n\!\(\*RowBox[{\" CoordinatesFromCartesian \", \"[\", RowBox[{StyleBox[\" pt \", \" TI \"], \",\", StyleBox[\" coordsys \", \" TI \"]}], \"]\"}]\) gives the coordinates in the coordinate system \!\(\*StyleBox[\" coordsys \", \" TI \"]\) of the point given in Cartesian coordinates."
VectorAnalysis`Coordinates::usage = "\!\(\*RowBox[{\" Coordinates \", \"[\", \"]\"}]\) gives a list of the default coordinate variables in the default coordinate system. \n\!\(\*RowBox[{\" Coordinates \", \"[\", StyleBox[\" coordsys \", \" TI \"], \"]\"}]\) gives a list of the default coordinate variables in the coordinate system \!\(\*StyleBox[\" coordsys \", \" TI \"]\)."
VectorAnalysis`CoordinatesToCartesian::usage = "\!\(\*RowBox[{\" CoordinatesToCartesian \", \"[\", StyleBox[\" pt \", \" TI \"], \"]\"}]\) gives the Cartesian coordinates of the point \!\(\*StyleBox[\" pt \", \" TI \"]\) given in the default coordinate system. \n\!\(\*RowBox[{\" CoordinatesToCartesian \", \"[\", RowBox[{StyleBox[\" pt \", \" TI \"], \",\", StyleBox[\" coordsys \", \" TI \"]}], \"]\"}]\) gives the Cartesian coordinates of the point given in the coordinate system \!\(\*StyleBox[\" coordsys \", \" TI \"]\)."
VectorAnalysis`CoordinateSystem::usage = "CoordinateSystem gives the name of the default coordinate system."
VectorAnalysis`CrossProduct::usage="\!\(\*RowBox[{\"CrossProduct\", \"[\", RowBox[{SubscriptBox[StyleBox[\"v\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"v\", \"TI\"], StyleBox[\"2\", \"TR\"]]}], \"]\"}]\) gives the cross product of the two 3-vectors \!\(\*SubscriptBox[StyleBox[\"v\", \"TI\"], StyleBox[\"1\", \"TR\"]]\), \!\(\*SubscriptBox[StyleBox[\"v\", \"TI\"], StyleBox[\"2\", \"TR\"]]\) in the default coordinate system. \n\!\(\*RowBox[{\"CrossProduct\", \"[\", RowBox[{SubscriptBox[StyleBox[\"v\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"v\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"coordsys\", \"TI\"]}], \"]\"}]\) gives the cross product of \!\(\*SubscriptBox[StyleBox[\"v\", \"TI\"], StyleBox[\"1\", \"TR\"]]\) and \!\(\*SubscriptBox[StyleBox[\"v\", \"TI\"], StyleBox[\"2\", \"TR\"]]\) in the coordinate system \!\(\*StyleBox[\"coordsys\", \"TI\"]\)."
VectorAnalysis`Cylindrical::usage = "Cylindrical represents the cylindrical coordinate system with default variables \!\(\*RowBox[{\" Rr \", \",\", \" Ttheta \"}]\) and Zz.\n\!\(\*RowBox[{\" Cylindrical \", \"[\", RowBox[{StyleBox[\" r \", \" TI \"], \",\", StyleBox[\" \[Theta] \", \" TR \"], \",\", StyleBox[\" z \", \" TI \"]}], \"]\"}]\) represents the cylindrical coordinate system with variables \!\(\*RowBox[{StyleBox[\" r \", \" TI \"], \",\", StyleBox[\" \[Theta] \", \" TR \"]}]\) and \!\(\*StyleBox[\" z \", \" TI \"]\)."
VectorAnalysis`Div::usage = "\!\(\*RowBox[{\" Div \", \"[\", StyleBox[\" f \", \" TI \"], \"]\"}]\) gives the divergence, \!\(\*RowBox[{\" \[Del]\", RowBox[{\"\[CenterDot]\", StyleBox[\" f \", \" TI \"]}]}]\), of the vector field \!\(\*StyleBox[\" f \", \" TI \"]\) in the default coordinate system. \n\!\(\*RowBox[{\" Div \", \"[\", RowBox[{StyleBox[\" f \", \" TI \"], \",\", StyleBox[\" coordsys \", \" TI \"]}], \"]\"}]\) gives the divergence of \!\(\*StyleBox[\" f \", \" TI \"]\) in the coordinate system \!\(\*StyleBox[\" coordsys \", \" TI \"]\)."
VectorAnalysis`DotProduct::usage = "\!\(\*RowBox[{\" DotProduct \", \"[\", RowBox[{SubscriptBox[StyleBox[\" v \", \" TI \"], StyleBox[\" 1\", \" TR \"]], \",\", SubscriptBox[StyleBox[\" v \", \" TI \"], StyleBox[\" 2\", \" TR \"]]}], \"]\"}]\) gives the dot product of the two 3-vectors \!\(\*RowBox[{SubscriptBox[StyleBox[\" v \", \" TI \"], StyleBox[\" 1\", \" TR \"]], \",\", SubscriptBox[StyleBox[\" v \", \" TI \"], StyleBox[\" 2\", \" TR \"]]}]\) in the default coordinate system. \n\!\(\*RowBox[{\" DotProduct \", \"[\", RowBox[{SubscriptBox[StyleBox[\" v \", \" TI \"], StyleBox[\" 1\", \" TR \"]], \",\", SubscriptBox[StyleBox[\" v \", \" TI \"], StyleBox[\" 2\", \" TR \"]], \",\", StyleBox[\" coordsys \", \" TI \"]}], \"]\"}]\) gives the dot product of \!\(\*SubscriptBox[StyleBox[\" v \", \" TI \"], StyleBox[\" 1\", \" TR \"]]\) and \!\(\*SubscriptBox[StyleBox[\" v \", \" TI \"], StyleBox[\" 2\", \" TR \"]]\) in the coordinate system \!\(\*StyleBox[\" coordsys \", \" TI \"]\)."
VectorAnalysis`Eeta::usage = "Eeta is one of the default coordinates for the ProlateSpheroidal and OblateSpheroidal coordinate systems."
VectorAnalysis`EllipticCylindrical::usage = "EllipticCylindrical represents the elliptic cylindrical coordinate system with default variables \!\(\*RowBox[{\" Uu \", \",\", \" Vv \"}]\) and Zz and default parameter value \!\(\*StyleBox[\" 1\", \" TR \"]\). \n\!\(\*RowBox[{\" EllipticCylindrical \", \"[\", RowBox[{StyleBox[\" u \", \" TI \"], \",\", StyleBox[\" v \", \" TI \"], \",\", StyleBox[\" z \", \" TI \"]}], \"]\"}]\) represents the elliptic cylindrical coordinate system with variables \!\(\*StyleBox[\" u \", \" TI \"]\), \!\(\*StyleBox[\" v \", \" TI \"]\), and \!\(\*StyleBox[\" z \", \" TI \"]\) and default parameter value \!\(\*StyleBox[\" 1\", \" TR \"]\). \n\!\(\*RowBox[{\" EllipticCylindrical \", \"[\", RowBox[{StyleBox[\" u \", \" TI \"], \",\", StyleBox[\" v \", \" TI \"], \",\", StyleBox[\" z \", \" TI \"], \",\", StyleBox[\" a \", \" TI \"]}], \"]\"}]\) represents the elliptic cylindrical coordinate system with variables \!\(\*StyleBox[\" u \", \" TI \"]\), \!\(\*StyleBox[\" v \", \" TI \"]\), and \!\(\*StyleBox[\" z \", \" TI \"]\) and parameter \!\(\*StyleBox[\" a \", \" TI \"]\)."
VectorAnalysis`Grad::usage = "\!\(\*RowBox[{\" Grad \", \"[\", StyleBox[\" f \", \" TI \"], \"]\"}]\) gives the gradient, \!\(\*RowBox[{\" \[Del]\", StyleBox[\" f \", \" TI \"]}]\), of the scalar function \!\(\*StyleBox[\" f \", \" TI \"]\) in the default coordinate system. \n\!\(\*RowBox[{\" Grad \", \"[\", RowBox[{StyleBox[\" f \", \" TI \"], \",\", StyleBox[\" coordsys \", \" TI \"]}], \"]\"}]\) gives the gradient of \!\(\*StyleBox[\" f \", \" TI \"]\) in the coordinate system \!\(\*StyleBox[\" coordsys \", \" TI \"]\)."
VectorAnalysis`JacobianDeterminant::usage = "\!\(\*RowBox[{\" JacobianDeterminant \", \"[\", StyleBox[\" pt \", \" TI \"], \"]\"}]\) gives the determinant of the Jacobian matrix of the transformation from the default coordinate system to the Cartesian coordinate system at the point \!\(\*StyleBox[\" pt \", \" TI \"]\). \n\!\(\*RowBox[{\" JacobianDeterminant \", \"[\", RowBox[{StyleBox[\" pt \", \" TI \"], \",\", StyleBox[\" coordsys \", \" TI \"]}], \"]\"}]\) gives the determinant of the Jacobian matrix of the transformation from the coordinate system \!\(\*StyleBox[\" coordsys \", \" TI \"]\) to the Cartesian coordinate system at the point \!\(\*StyleBox[\" pt \", \" TI \"]\)."
VectorAnalysis`JacobianMatrix::usage = "\!\(\*RowBox[{\" JacobianMatrix \", \"[\", StyleBox[\" pt \", \" TI \"], \"]\"}]\) gives the Jacobian matrix of the transformation from the default coordinate system to the Cartesian coordinate system at the point \!\(\*StyleBox[\" pt \", \" TI \"]\). \n\!\(\*RowBox[{\" JacobianMatrix \", \"[\", RowBox[{StyleBox[\" pt \", \" TI \"], \",\", StyleBox[\" coordsys \", \" TI \"]}], \"]\"}]\) gives the Jacobian matrix of the transformation from the coordinate system \!\(\*StyleBox[\" coordsys \", \" TI \"]\) to the Cartesian coordinate system at the point \!\(\*StyleBox[\" pt \", \" TI \"]\)."
VectorAnalysis`Laplacian::usage = "\!\(\*RowBox[{\" Laplacian \", \"[\", StyleBox[\" f \", \" TI \"], \"]\"}]\) gives the Laplacian, \!\(\*RowBox[{SuperscriptBox[\" \[Del]\", \" 2\"], StyleBox[\" f \", \" TI \"]}]\), of the scalar function or vector field \!\(\*StyleBox[\" f \", \" TI \"]\) in the default coordinate system. \n\!\(\*RowBox[{\" Laplacian \", \"[\", RowBox[{StyleBox[\" f \", \" TI \"], \",\", StyleBox[\" coordsys \", \" TI \"]}], \"]\"}]\) gives the Laplacian of \!\(\*StyleBox[\" f \", \" TI \"]\) in the coordinate system \!\(\*StyleBox[\" coordsys \", \" TI \"]\)."
VectorAnalysis`Llambda::usage = "Llambda is one of the default coordinates for the Conical, ConfocalEllipsoidal, and ConfocalParaboloidal coordinate systems."
VectorAnalysis`Mmu::usage = "Mmu is one of the default coordinates for the Conical, ConfocalEllipsoidal, and ConfocalParaboloidal coordinate systems."
VectorAnalysis`Nnu::usage = "Nnu is one of the default coordinates for the Conical, ConfocalEllipsoidal, and ConfocalParaboloidal coordinate systems."
VectorAnalysis`OblateSpheroidal::usage = "OblateSpheroidal represents the oblate spheroidal coordinate system with default variables \!\(\*RowBox[{\" Xxi \", \",\", \" Eeta \"}]\), and Pphi and default parameter value \!\(\*StyleBox[\" 1\", \" TR \"]\). \n\!\(\*RowBox[{\" OblateSpheroidal \", \"[\", RowBox[{StyleBox[\" \[Xi] \", \" TR \"], \",\", StyleBox[\" \[Eta] \", \" TR \"], \",\", StyleBox[\" \[Phi] \", \" TR \"]}], \"]\"}]\) represents the oblate spheroidal coordinate system with variables \!\(\*RowBox[{StyleBox[\" \[Xi] \", \" TR \"], \",\", StyleBox[\" \[Eta] \", \" TR \"]}]\) and \!\(\*StyleBox[\" \[Phi] \", \" TR \"]\) and default parameter value \!\(\*StyleBox[\" 1\", \" TR \"]\). \n\!\(\*RowBox[{\" OblateSpheroidal \", \"[\", RowBox[{StyleBox[\" \[Xi] \", \" TR \"], \",\", StyleBox[\" \[Eta] \", \" TR \"], \",\", StyleBox[\" \[Phi] \", \" TR \"], \",\", StyleBox[\" a \", \" TI \"]}], \"]\"}]\) represents the oblate spheroidal coordinate system with variables \!\(\*RowBox[{StyleBox[\" \[Xi] \", \" TR \"], \",\", StyleBox[\" \[Eta] \", \" TR \"]}]\) and \!\(\*StyleBox[\" \[Phi] \", \" TR \"]\) and parameter \!\(\*StyleBox[\" a \", \" TI \"]\)."
VectorAnalysis`ParabolicCylindrical::usage = "ParabolicCylindrical represents the parabolic cylindrical coordinate system with default variables \!\(\*RowBox[{\" Uu \", \",\", \" Vv \"}]\) and Zz. \n\!\(\*RowBox[{\" ParabolicCylindrical \", \"[\", RowBox[{StyleBox[\" u \", \" TI \"], \",\", StyleBox[\" v \", \" TI \"], \",\", StyleBox[\" z \", \" TI \"]}], \"]\"}]\) represents the parabolic cylindrical coordinate system with variables \!\(\*StyleBox[\" u \", \" TI \"]\), \!\(\*StyleBox[\" v \", \" TI \"]\), and \!\(\*StyleBox[\" z \", \" TI \"]\)."
VectorAnalysis`Paraboloidal::usage = "Paraboloidal represents the paraboloidal coordinate system with default variables \!\(\*RowBox[{\" Uu \", \",\", \" Vv \"}]\) and Pphi.\n\!\(\*RowBox[{\" Paraboloidal \", \"[\", RowBox[{StyleBox[\" u \", \" TI \"], \",\", StyleBox[\" v \", \" TI \"], \",\", StyleBox[\" \[Phi] \", \" TI \"]}], \"]\"}]\) represents the paraboloidal coordinate system with variables \!\(\*StyleBox[\" u \", \" TI \"]\), \!\(\*StyleBox[\" v \", \" TI \"]\), and \!\(\*StyleBox[\" \[Phi] \", \" TR \"]\)."
VectorAnalysis`ParameterRanges::usage = "\!\(\*RowBox[{\" ParameterRanges \", \"[\", \"]\"}]\) gives the intervals over which each the of the parameters in the default coordinate system may range. \n\!\(\*RowBox[{\" ParameterRanges \", \"[\", StyleBox[\" coordsys \", \" TI \"], \"]\"}]\) gives the ranges for each of the parameters in the coordinate system \!\(\*StyleBox[\" coordsys \", \" TI \"]\)."
VectorAnalysis`Parameters::usage = "\!\(\*RowBox[{\" Parameters \", \"[\", \"]\"}]\) gives a list of the default parameters of the default coordinate system. \n\!\(\*RowBox[{\" Parameters \", \"[\", StyleBox[\" coordsys \", \" TI \"], \"]\"}]\) gives a list of the default parameters in the coordinate system \!\(\*StyleBox[\" coordsys \", \" TI \"]\)."
VectorAnalysis`Pphi::usage = "Pphi is one of the default coordinates for the Bispherical, OblateSpheroidal, Paraboloidal, ProlateSpheroidal, Spherical and Toroidal coordinate systems."
VectorAnalysis`ProlateSpheroidal::usage = "ProlateSpheroidal represents the prolate spheroidal coordinate system with default variables \!\(\*RowBox[{\" Xxi \", \",\", \" Eeta \"}]\) and Pphi and default parameter value 1. \n \!\(\*RowBox[{\" ProlateSpheroidal \", \"[\", RowBox[{StyleBox[\" \[Xi] \", \" TR \"], \",\", StyleBox[\" \[Eta] \", \" TR \"], \",\", StyleBox[\" \[Phi] \", \" TR \"]}], \"]\"}]\) represents the prolate spheroidal coordinate system with variables \!\(\*RowBox[{StyleBox[\" \[Xi] \", \" TR \"], \",\", StyleBox[\" \[Eta] \", \" TR \"]}]\) and \!\(\*StyleBox[\" \[Phi] \", \" TR \"]\) and default parameter value 1. \n \!\(\*RowBox[{\" ProlateSpheroidal \", \"[\", RowBox[{StyleBox[\" \[Xi] \", \" TR \"], \",\", StyleBox[\" \[Eta] \", \" TR \"], \",\", StyleBox[\" \[Phi] \", \" TR \"], \",\", StyleBox[\" a \", \" TI \"]}], \"]\"}]\) represents the prolate spheroidal coordinate system with variables \!\(\*RowBox[{StyleBox[\" \[Xi] \", \" TR \"], \",\", StyleBox[\" \[Eta] \", \" TR \"]}]\) and \!\(\*StyleBox[\" \[Phi] \", \" TR \"]\) and parameter \!\(\*StyleBox[\" a \", \" TI \"]\)."
VectorAnalysis`Rr::usage = "Rr is one of the default coordinates for the Cylindrical and Spherical coordinate systems."
VectorAnalysis`ScalarTripleProduct::usage = "\!\(\*RowBox[{\" ScalarTripleProduct \", \"[\", RowBox[{SubscriptBox[StyleBox[\" v \", \" TI \"], StyleBox[\" 1\", \" TR \"]], \",\", SubscriptBox[StyleBox[\" v \", \" TI \"], StyleBox[\" 2\", \" TR \"]], \",\", SubscriptBox[StyleBox[\" v \", \" TI \"], StyleBox[\" 3\", \" TR \"]]}], \"]\"}]\) gives the scalar triple product of the three 3-vectors \!\(\*RowBox[{SubscriptBox[StyleBox[\" v \", \" TI \"], StyleBox[\" 1\", \" TR \"]], \",\", SubscriptBox[StyleBox[\" v \", \" TI \"], StyleBox[\" 2\", \" TR \"]]}]\) and \!\(\*SubscriptBox[StyleBox[\" v \", \" TI \"], StyleBox[\" 3\", \" TR \"]]\) in the default coordinate system. \n\!\(\*RowBox[{\" ScalarTripleProduct \", \"[\", RowBox[{SubscriptBox[StyleBox[\" v \", \" TI \"], StyleBox[\" 1\", \" TR \"]], \",\", SubscriptBox[StyleBox[\" v \", \" TI \"], StyleBox[\" 2\", \" TR \"]], \",\", SubscriptBox[StyleBox[\" v \", \" TI \"], StyleBox[\" 3\", \" TR \"]], \",\", StyleBox[\" coordsys \", \" TI \"]}], \"]\"}]\) gives the scalar triple product of \!\(\*RowBox[{SubscriptBox[StyleBox[\" v \", \" TI \"], StyleBox[\" 1\", \" TR \"]], \",\", SubscriptBox[StyleBox[\" v \", \" TI \"], StyleBox[\" 2\", \" TR \"]]}]\) and \!\(\*SubscriptBox[StyleBox[\" v \", \" TI \"], StyleBox[\" 3\", \" TR \"]]\) in the coordinate system \!\(\*StyleBox[\" coordsys \", \" TI \"]\)."
VectorAnalysis`ScaleFactors::usage = "\!\(\*RowBox[{\" ScaleFactors \", \"[\", StyleBox[\" pt \", \" TI \"], \"]\"}]\) gives a list of the scale factors at the point \!\(\*StyleBox[\" pt \", \" TI \"]\) in the default coordinate system. \n\!\(\*RowBox[{\" ScaleFactors \", \"[\", RowBox[{StyleBox[\" pt \", \" TI \"], \",\", StyleBox[\" coordsys \", \" TI \"]}], \"]\"}]\) gives a list of the scale factors in the coordinate system \!\(\*StyleBox[\" coordsys \", \" TI \"]\)."
VectorAnalysis`SetCoordinates::usage = "\!\(\*RowBox[{\" SetCoordinates \", \"[\", StyleBox[\" coordsys \", \" TI \"], \"]\"}]\) sets the default coordinate system to be \!\(\*StyleBox[\" coordsys \", \" TI \"]\) with default variables. \n\!\(\*RowBox[{\" SetCoordinates \", \"[\", RowBox[{StyleBox[\" coordsys \", \" TI \"], \"[\", RowBox[{SubscriptBox[StyleBox[\" c \", \" TI \"], StyleBox[\" 1\", \" TR \"]], \",\", SubscriptBox[StyleBox[\" c \", \" TI \"], StyleBox[\" 2\", \" TR \"]], \",\", SubscriptBox[StyleBox[\" c \", \" TI \"], StyleBox[\" 3\", \" TR \"]]}], \"]\"}], \"]\"}]\) sets the default coordinate system to be \!\(\*StyleBox[\" coordsys \", \" TI \"]\) with variables \!\(\*RowBox[{SubscriptBox[StyleBox[\" c \", \" TI \"], StyleBox[\" 1\", \" TR \"]], \",\", SubscriptBox[StyleBox[\" c \", \" TI \"], StyleBox[\" 2\", \" TR \"]]}]\), and \!\(\*SubscriptBox[StyleBox[\" c \", \" TI \"], StyleBox[\" 3\", \" TR \"]]\)."
VectorAnalysis`Spherical::usage = "Spherical represents the spherical coordinate system with default variables \!\(\*RowBox[{\" Rr \", \",\", \" Ttheta \"}]\) and Pphi. \n\!\(\*RowBox[{\" Spherical \", \"[\", RowBox[{StyleBox[\" r \", \" TI \"], \",\", StyleBox[\" \[Theta] \", \" TR \"], \",\", StyleBox[\" \[Phi] \", \" TR \"]}], \"]\"}]\) represents the spherical coordinate system with variables \!\(\*RowBox[{StyleBox[\" r \", \" TI \"], \",\", StyleBox[\" \[Theta] \", \" TR \"]}]\) and \!\(\*StyleBox[\" \[Phi] \", \" TR \"]\)."
VectorAnalysis`Toroidal::usage = "Toroidal represents the toroidal coordinate system with default variables \!\(\*RowBox[{\" Uu \", \",\", \" Vv \"}]\) and Pphi and default parameter value \!\(\*StyleBox[\" 1\", \" TR \"]\). \n\!\(\*RowBox[{\" Toroidal \", \"[\", RowBox[{StyleBox[\" u \", \" TI \"], \",\", StyleBox[\" v \", \" TI \"], \",\", StyleBox[\" \[Phi] \", \" TR \"]}], \"]\"}]\) represents the toroidal coordinate system with variables \!\(\*StyleBox[\" u \", \" TI \"]\), \!\(\*StyleBox[\" v \", \" TI \"]\), and \!\(\*StyleBox[\" \[Phi] \", \" TR \"]\) and default parameter value \!\(\*StyleBox[\" 1\", \" TR \"]\).\n\!\(\*RowBox[{\" Toroidal \", \"[\", RowBox[{StyleBox[\" u \", \" TI \"], \",\", StyleBox[\" v \", \" TI \"], \",\", StyleBox[\" \[Phi] \", \" TR \"], \",\", StyleBox[\" a \", \" TI \"]}], \"]\"}]\) represents the toroidal coordinate system with variables \!\(\*StyleBox[\" u \", \" TI \"]\), \!\(\*StyleBox[\" v \", \" TI \"]\), and \!\(\*StyleBox[\" \[Phi] \", \" TR \"]\) and parameter \!\(\*StyleBox[\" a \", \" TI \"]\)."
VectorAnalysis`Ttheta::usage = "Ttheta is one of the default coordinates for the Cylindrical and Spherical coordinate systems."
VectorAnalysis`Uu::usage = "Uu is one of the default coordinates for the Bipolar, Bispherical, ParabolicCylindrical, Paraboloidal, EllipticCylindrical, and Toroidal coordinate systems."
VectorAnalysis`Vv::usage = "Vv is one of the default coordinates for the Bipolar, Bispherical, ParabolicCylindrical, Paraboloidal, EllipticCylindrical, and Toroidal coordinate systems."
VectorAnalysis`Xxi::usage = "Xxi is one of the default coordinates for the ProlateSpheroidal and OblateSpheroidal coordinate systems."
VectorAnalysis`Xx::usage = "Xx is one of the default coordinates for the Cartesian coordinate system."
VectorAnalysis`Yy::usage = "Yy is one of the default coordinates for the Cartesian coordinate system."
VectorAnalysis`Zz::usage = "Zz is one of the default coordinates for the Bipolar, Cartesian, Cylindrical, EllipticCylindrical and ParabolicCylindrical coordinate systems."
VectorFieldPlots`GradientFieldPlot3D::usage = "\!\(\*RowBox[{\" GradientFieldPlot3D \", \"[\", RowBox[{StyleBox[\" f \", \" TI \"], \",\", RowBox[{\" {\", RowBox[{StyleBox[\" x \", \" TI \"], \",\", SubscriptBox[StyleBox[\" x \", \" TI \"], StyleBox[\" min \", \" TI \"]], \",\", SubscriptBox[StyleBox[\" x \", \" TI \"], StyleBox[\" max \", \" TI \"]]}], \"}\"}], \",\", RowBox[{\" {\", RowBox[{StyleBox[\" y \", \" TI \"], \",\", SubscriptBox[StyleBox[\" y \", \" TI \"], StyleBox[\" min \", \" TI \"]], \",\", SubscriptBox[StyleBox[\" y \", \" TI \"], StyleBox[\" max \", \" TI \"]]}], \"}\"}], \",\", RowBox[{\" {\", RowBox[{StyleBox[\" z \", \" TI \"], \",\", SubscriptBox[StyleBox[\" z \", \" TI \"], StyleBox[\" min \", \" TI \"]], \",\", SubscriptBox[StyleBox[\" z \", \" TI \"], StyleBox[\" max \", \" TI \"]]}], \"}\"}]}], \"]\"}]\) generates a three-dimensional plot of the gradient vector field of the scalar function \!\(\*StyleBox[\" f \", \" TI \"]\) as a function of \!\(\*StyleBox[\" x \", \" TI \"]\), \!\(\*StyleBox[\" y \", \" TI \"]\) and \!\(\*StyleBox[\" z \", \" TI \"]\).\n\!\(\*RowBox[{\" GradientFieldPlot3D \", \"[\", RowBox[{StyleBox[\" f \", \" TI \"], \",\", RowBox[{\" {\", RowBox[{StyleBox[\" x \", \" TI \"], \",\", SubscriptBox[StyleBox[\" x \", \" TI \"], StyleBox[\" min \", \" TI \"]], \",\", SubscriptBox[StyleBox[\" x \", \" TI \"], StyleBox[\" max \", \" TI \"]], \",\", StyleBox[\" dx \", \" TI \"]}], \"}\"}], \",\", RowBox[{\" {\", RowBox[{StyleBox[\" y \", \" TI \"], \",\", SubscriptBox[StyleBox[\" y \", \" TI \"], StyleBox[\" min \", \" TI \"]], \",\", SubscriptBox[StyleBox[\" y \", \" TI \"], StyleBox[\" max \", \" TI \"]], \",\", StyleBox[\" dy \", \" TI \"]}], \"}\"}], \",\", RowBox[{\" {\", RowBox[{StyleBox[\" z \", \" TI \"], \",\", SubscriptBox[StyleBox[\" z \", \" TI \"], StyleBox[\" min \", \" TI \"]], \",\", SubscriptBox[StyleBox[\" z \", \" TI \"], StyleBox[\" max \", \" TI \"]], \",\", StyleBox[\" dz \", \" TI \"]}], \"}\"}]}], \"]\"}]\) uses steps \!\(\*StyleBox[\" dx \", \" TI \"]\), \!\(\*StyleBox[\" dy \", \" TI \"]\) and \!\(\*StyleBox[\" dz \", \" TI \"]\) in variables \!\(\*StyleBox[\" x \", \" TI \"]\), \!\(\*StyleBox[\" y \", \" TI \"]\) and \!\(\*StyleBox[\" z \", \" TI \"]\) respectively."
VectorFieldPlots`GradientFieldPlot::usage = "\!\(\*RowBox[{\" GradientFieldPlot \", \"[\", RowBox[{StyleBox[\" f \", \" TI \"], \",\", RowBox[{\" {\", RowBox[{StyleBox[\" x \", \" TI \"], \",\", SubscriptBox[StyleBox[\" x \", \" TI \"], StyleBox[\" min \", \" TI \"]], \",\", SubscriptBox[StyleBox[\" x \", \" TI \"], StyleBox[\" max \", \" TI \"]]}], \"}\"}], \",\", RowBox[{\" {\", RowBox[{StyleBox[\" y \", \" TI \"], \",\", SubscriptBox[StyleBox[\" y \", \" TI \"], StyleBox[\" min \", \" TI \"]], \",\", SubscriptBox[StyleBox[\" y \", \" TI \"], StyleBox[\" max \", \" TI \"]]}], \"}\"}]}], \"]\"}]\) generates a plot of the gradient vector field of the scalar function \!\(\*StyleBox[\" f \", \" TI \"]\).\n\!\(\*RowBox[{\" GradientFieldPlot \", \"[\", RowBox[{StyleBox[\" f \", \" TI \"], \",\", RowBox[{\" {\", RowBox[{StyleBox[\" x \", \" TI \"], \",\", SubscriptBox[StyleBox[\" x \", \" TI \"], StyleBox[\" min \", \" TI \"]], \",\", SubscriptBox[StyleBox[\" x \", \" TI \"], StyleBox[\" max \", \" TI \"]], \",\", StyleBox[\" dx \", \" TI \"]}], \"}\"}], \",\", RowBox[{\" {\", RowBox[{StyleBox[\" y \", \" TI \"], \",\", SubscriptBox[StyleBox[\" y \", \" TI \"], StyleBox[\" min \", \" TI \"]], \",\", SubscriptBox[StyleBox[\" y \", \" TI \"], StyleBox[\" max \", \" TI \"]], \",\", StyleBox[\" dy \", \" TI \"]}], \"}\"}]}], \"]\"}]\) uses steps \!\(\*StyleBox[\" dx \", \" TI \"]\) in variable \!\(\*StyleBox[\" x \", \" TI \"]\), and steps \!\(\*StyleBox[\" dy \", \" TI \"]\) in variable \!\(\*StyleBox[\" y \", \" TI \"]\)."
VectorFieldPlots`HamiltonianFieldPlot::usage = "\!\(\*RowBox[{\" HamiltonianFieldPlot \", \"[\", RowBox[{StyleBox[\" f \", \" TI \"], \",\", RowBox[{\" {\", RowBox[{StyleBox[\" x \", \" TI \"], \",\", SubscriptBox[StyleBox[\" x \", \" TI \"], StyleBox[\" min \", \" TI \"]], \",\", SubscriptBox[StyleBox[\" x \", \" TI \"], StyleBox[\" max \", \" TI \"]]}], \"}\"}], \",\", RowBox[{\" {\", RowBox[{StyleBox[\" y \", \" TI \"], \",\", SubscriptBox[StyleBox[\" y \", \" TI \"], StyleBox[\" min \", \" TI \"]], \",\", SubscriptBox[StyleBox[\" y \", \" TI \"], StyleBox[\" max \", \" TI \"]]}], \"}\"}]}], \"]\"}]\) generates a plot of the Hamiltonian vector field of the scalar-valued function \!\(\*StyleBox[\" f \", \" TI \"]\) as a function of \!\(\*StyleBox[\" x \", \" TI \"]\) and \!\(\*StyleBox[\" y \", \" TI \"]\).\n\!\(\*RowBox[{\" HamiltonianFieldPlot \", \"[\", RowBox[{StyleBox[\" f \", \" TI \"], \",\", RowBox[{\" {\", RowBox[{StyleBox[\" x \", \" TI \"], \",\", SubscriptBox[StyleBox[\" x \", \" TI \"], StyleBox[\" min \", \" TI \"]], \",\", SubscriptBox[StyleBox[\" x \", \" TI \"], StyleBox[\" max \", \" TI \"]], \",\", StyleBox[\" dx \", \" TI \"]}], \"}\"}], \",\", RowBox[{\" {\", RowBox[{StyleBox[\" y \", \" TI \"], \",\", SubscriptBox[StyleBox[\" y \", \" TI \"], StyleBox[\" min \", \" TI \"]], \",\", SubscriptBox[StyleBox[\" y \", \" TI \"], StyleBox[\" max \", \" TI \"]], \",\", StyleBox[\" dy \", \" TI \"]}], \"}\"}]}], \"]\"}]\) uses steps \!\(\*StyleBox[\" dx \", \" TI \"]\) in variable \!\(\*StyleBox[\" x \", \" TI \"]\), and steps \!\(\*StyleBox[\" dy \", \" TI \"]\) in variable \!\(\*StyleBox[\" y \", \" TI \"]\)."
VectorFieldPlots`ListVectorFieldPlot3D::usage = "\!\(\*RowBox[{\" ListVectorFieldPlot3D \", \"[\", RowBox[{\" {\", RowBox[{RowBox[{\" {\", RowBox[{SubscriptBox[StyleBox[\" pt \", \" TI \"], StyleBox[\" 1\", \" TR \"]], \",\", SubscriptBox[StyleBox[\" vec \", \" TI \"], StyleBox[\" 1\", \" TR \"]]}], \"}\"}], \",\", RowBox[{\" {\", RowBox[{SubscriptBox[StyleBox[\" pt \", \" TI \"], StyleBox[\" 2\", \" TR \"]], \",\", SubscriptBox[StyleBox[\" vec \", \" TI \"], StyleBox[\" 2\", \" TR \"]]}], \"}\"}], \",\", StyleBox[\" \[Ellipsis] \", \" TR \"]}], \"}\"}], \"]\"}]\) generates a three-dimensional plot of the list of vectors \!\(\*RowBox[{SubscriptBox[StyleBox[\" vec \", \" TI \"], StyleBox[\" 1\", \" TR \"]], \",\", \" \", SubscriptBox[StyleBox[\" vec \", \" TI \"], StyleBox[\" 2\", \" TR \"]], \",\", \" \", StyleBox[\" \[Ellipsis] \", \" TR \"]}]\), with each vector based at a corresponding point \!\(\*RowBox[{SubscriptBox[StyleBox[\" pt \", \" TI \"], StyleBox[\" 1\", \" TR \"]], \",\", \" \", SubscriptBox[StyleBox[\" pt \", \" TI \"], StyleBox[\" 2\", \" TR \"]], \",\", \" \", StyleBox[\" \[Ellipsis] \", \" TR \"]}]\)."
VectorFieldPlots`ListVectorFieldPlot::usage = "\!\(\*RowBox[{\" ListVectorFieldPlot \", \"[\", RowBox[{\" {\", RowBox[{RowBox[{\" {\", RowBox[{RowBox[{\" {\", RowBox[{SubscriptBox[StyleBox[\" x \", \" TI \"], StyleBox[\" 11\", \" TR \"]], \",\", SubscriptBox[StyleBox[\" y \", \" TI \"], StyleBox[\" 11\", \" TR \"]]}], \"}\"}], \",\", RowBox[{\" {\", RowBox[{SubscriptBox[StyleBox[\" x \", \" TI \"], StyleBox[\" 12\", \" TR \"]], \",\", SubscriptBox[StyleBox[\" y \", \" TI \"], StyleBox[\" 12\", \" TR \"]]}], \"}\"}], \",\", StyleBox[\" \[Ellipsis] \", \" TR \"]}], \"}\"}], \",\", StyleBox[\" \[Ellipsis] \", \" TR \"]}], \"}\"}], \"]\"}]\) generates a plot of the vector field corresponding to the array of vectors \!\(\*RowBox[{\" {\", RowBox[{RowBox[{\" {\", RowBox[{RowBox[{\" {\", RowBox[{SubscriptBox[StyleBox[\" x \", \" TI \"], StyleBox[\" 11\", \" TR \"]], \",\", SubscriptBox[StyleBox[\" y \", \" TI \"], StyleBox[\" 11\", \" TR \"]]}], \"}\"}], \",\", StyleBox[\" \[Ellipsis] \", \" TR \"]}], \"}\"}], \",\", StyleBox[\" \[Ellipsis] \", \" TR \"]}], \"}\"}]\).\n\!\(\*RowBox[{\" ListVectorFieldPlot \", \"[\", RowBox[{\" {\", RowBox[{RowBox[{\" {\", RowBox[{SubscriptBox[StyleBox[\" pt \", \" TI \"], StyleBox[\" 1\", \" TR \"]], \",\", SubscriptBox[StyleBox[\" vec \", \" TI \"], StyleBox[\" 1\", \" TR \"]]}], \"}\"}], \",\", RowBox[{\" {\", RowBox[{SubscriptBox[StyleBox[\" pt \", \" TI \"], StyleBox[\" 2\", \" TR \"]], \",\", SubscriptBox[StyleBox[\" vec \", \" TI \"], StyleBox[\" 2\", \" TR \"]]}], \"}\"}], \",\", StyleBox[\" \[Ellipsis] \", \" TR \"]}], \"}\"}], \"]\"}]\) generates a plot of a list of vectors, each based at the corresponding point."
VectorFieldPlots`MaxArrowLength::usage = "MaxArrowLength is an option for the vector field visualization functions that determines the longest vector to be drawn."
VectorFieldPlots`PolyaFieldPlot::usage = "\!\(\*RowBox[{\" PolyaFieldPlot \", \"[\", RowBox[{StyleBox[\" f \", \" TI \"], \",\", RowBox[{\" {\", RowBox[{StyleBox[\" x \", \" TI \"], \",\", SubscriptBox[StyleBox[\" x \", \" TI \"], StyleBox[\" min \", \" TI \"]], \",\", SubscriptBox[StyleBox[\" x \", \" TI \"], StyleBox[\" max \", \" TI \"]]}], \"}\"}], \",\", RowBox[{\" {\", RowBox[{StyleBox[\" y \", \" TI \"], \",\", SubscriptBox[StyleBox[\" y \", \" TI \"], StyleBox[\" min \", \" TI \"]], \",\", SubscriptBox[StyleBox[\" y \", \" TI \"], StyleBox[\" max \", \" TI \"]]}], \"}\"}]}], \"]\"}]\) generates a plot of the complex-valued function \!\(\*StyleBox[\" f \", \" TI \"]\) in the complex plane using the Polya representation.\n\!\(\*RowBox[{\" PolyaFieldPlot \", \"[\", RowBox[{StyleBox[\" f \", \" TI \"], \",\", RowBox[{\" {\", RowBox[{StyleBox[\" x \", \" TI \"], \",\", SubscriptBox[StyleBox[\" x \", \" TI \"], StyleBox[\" min \", \" TI \"]], \",\", SubscriptBox[StyleBox[\" x \", \" TI \"], StyleBox[\" max \", \" TI \"]], \",\", StyleBox[\" dx \", \" TI \"]}], \"}\"}], \",\", RowBox[{\" {\", RowBox[{StyleBox[\" y \", \" TI \"], \",\", SubscriptBox[StyleBox[\" y \", \" TI \"], StyleBox[\" min \", \" TI \"]], \",\", SubscriptBox[StyleBox[\" y \", \" TI \"], StyleBox[\" max \", \" TI \"]], \",\", StyleBox[\" dy \", \" TI \"]}], \"}\"}]}], \"]\"}]\) uses steps \!\(\*StyleBox[\" dx \", \" TI \"]\) in real component \!\(\*StyleBox[\" x \", \" TI \"]\) and steps \!\(\*StyleBox[\" dy \", \" TI \"]\) in imaginary component \!\(\*StyleBox[\" y \", \" TI \"]\)."
VectorFieldPlots`ScaleFactor::usage = "ScaleFactor is an option for the vector field visualization functions that scales the vectors so that the longest vector displayed is of the length specified."
VectorFieldPlots`ScaleFunction::usage = "ScaleFunction is an option for the vector field visualization functions that rescales each vector to a length determined by applying a pure function to the current length of that vector."
VectorFieldPlots`VectorFieldPlot3D::usage = "\!\(\*RowBox[{\" VectorFieldPlot3D \", \"[\", RowBox[{RowBox[{\" {\", RowBox[{SubscriptBox[StyleBox[\" f \", \" TI \"], StyleBox[\" x \", \" TI \"]], \",\", SubscriptBox[StyleBox[\" f \", \" TI \"], StyleBox[\" y \", \" TI \"]], \",\", SubscriptBox[StyleBox[\" f \", \" TI \"], StyleBox[\" z \", \" TI \"]]}], \"}\"}], \",\", RowBox[{\" {\", RowBox[{StyleBox[\" x \", \" TI \"], \",\", SubscriptBox[StyleBox[\" x \", \" TI \"], StyleBox[\" min \", \" TI \"]], \",\", SubscriptBox[StyleBox[\" x \", \" TI \"], StyleBox[\" max \", \" TI \"]]}], \"}\"}], \",\", RowBox[{\" {\", RowBox[{StyleBox[\" y \", \" TI \"], \",\", SubscriptBox[StyleBox[\" y \", \" TI \"], StyleBox[\" min \", \" TI \"]], \",\", SubscriptBox[StyleBox[\" y \", \" TI \"], StyleBox[\" max \", \" TI \"]]}], \"}\"}], \",\", RowBox[{\" {\", RowBox[{StyleBox[\" z \", \" TI \"], \",\", SubscriptBox[StyleBox[\" z \", \" TI \"], StyleBox[\" min \", \" TI \"]], \",\", SubscriptBox[StyleBox[\" z \", \" TI \"], StyleBox[\" max \", \" TI \"]]}], \"}\"}]}], \"]\"}]\) generates a three-dimensional plot of the vector field given by the vector-valued function \!\(\*RowBox[{\" {\", RowBox[{SubscriptBox[StyleBox[\" f \", \" TI \"], StyleBox[\" x \", \" TI \"]], \",\", SubscriptBox[StyleBox[\" f \", \" TI \"], StyleBox[\" y \", \" TI \"]], \",\", SubscriptBox[StyleBox[\" f \", \" TI \"], StyleBox[\" z \", \" TI \"]]}], \"}\"}]\) as a function of \!\(\*StyleBox[\" x \", \" TI \"]\) and \!\(\*StyleBox[\" y \", \" TI \"]\) and \!\(\*StyleBox[\" z \", \" TI \"]\).\n\!\(\*RowBox[{\" VectorFieldPlot3D \", \"[\", RowBox[{RowBox[{\" {\", RowBox[{SubscriptBox[StyleBox[\" f \", \" TI \"], StyleBox[\" x \", \" TI \"]], \",\", SubscriptBox[StyleBox[\" f \", \" TI \"], StyleBox[\" y \", \" TI \"]], \",\", SubscriptBox[StyleBox[\" f \", \" TI \"], StyleBox[\" z \", \" TI \"]]}], \"}\"}], \",\", RowBox[{\" {\", RowBox[{StyleBox[\" x \", \" TI \"], \",\", SubscriptBox[StyleBox[\" x \", \" TI \"], StyleBox[\" min \", \" TI \"]], \",\", SubscriptBox[StyleBox[\" x \", \" TI \"], StyleBox[\" max \", \" TI \"]], \",\", StyleBox[\" dx \", \" TI \"]}], \"}\"}], \",\", RowBox[{StyleBox[\" {\", \" TR \"], RowBox[{StyleBox[\" y \", \" TR \"], \",\", SubscriptBox[StyleBox[\" y \", \" TI \"], StyleBox[\" min \", \" TI \"]], \",\", SubscriptBox[StyleBox[\" y \", \" TI \"], StyleBox[\" max \", \" TI \"]], \",\", StyleBox[\" dy \", \" TI \"]}], \"}\"}], \",\", RowBox[{\" {\", RowBox[{StyleBox[\" z \", \" TI \"], \",\", SubscriptBox[StyleBox[\" z \", \" TI \"], StyleBox[\" min \", \" TI \"]], \",\", SubscriptBox[StyleBox[\" z \", \" TI \"], StyleBox[\" max \", \" TI \"]], \",\", StyleBox[\" dz \", \" TI \"]}], \"}\"}]}], \"]\"}]\) uses steps \!\(\*StyleBox[\" dx \", \" TI \"]\), \!\(\*StyleBox[\" dy \", \" TI \"]\) and \!\(\*StyleBox[\" dz \", \" TI \"]\) for variables \!\(\*StyleBox[\" x \", \" TI \"]\), \!\(\*StyleBox[\" y \", \" TI \"]\) and \!\(\*StyleBox[\" z \", \" TI \"]\) respectively."
VectorFieldPlots`VectorFieldPlot::usage = "\!\(\*RowBox[{\" VectorFieldPlot \", \"[\", RowBox[{RowBox[{\" {\", RowBox[{SubscriptBox[StyleBox[\" f \", \" TI \"], StyleBox[\" x \", \" TI \"]], \",\", SubscriptBox[StyleBox[\" f \", \" TI \"], StyleBox[\" y \", \" TI \"]]}], \"}\"}], \",\", RowBox[{\" {\", RowBox[{StyleBox[\" x \", \" TI \"], \",\", SubscriptBox[StyleBox[\" x \", \" TI \"], StyleBox[\" min \", \" TI \"]], \",\", SubscriptBox[StyleBox[\" x \", \" TI \"], StyleBox[\" max \", \" TI \"]]}], \"}\"}], \",\", RowBox[{\" {\", RowBox[{StyleBox[\" y \", \" TI \"], \",\", SubscriptBox[StyleBox[\" y \", \" TI \"], StyleBox[\" min \", \" TI \"]], \",\", SubscriptBox[StyleBox[\" y \", \" TI \"], StyleBox[\" max \", \" TI \"]]}], \"}\"}]}], \"]\"}]\) generates a plot of the vector field given by the vector valued function \!\(\*RowBox[{\" {\", RowBox[{SubscriptBox[StyleBox[\" f \", \" TI \"], StyleBox[\" x \", \" TI \"]], \",\", SubscriptBox[StyleBox[\" f \", \" TI \"], StyleBox[\" y \", \" TI \"]]}], \"}\"}]\) as a function of \!\(\*StyleBox[\" x \", \" TI \"]\) and \!\(\*StyleBox[\" y \", \" TI \"]\).\n\!\(\*RowBox[{\" VectorFieldPlot \", \"[\", RowBox[{RowBox[{\" {\", RowBox[{SubscriptBox[StyleBox[\" f \", \" TI \"], StyleBox[\" x \", \" TI \"]], \",\", SubscriptBox[StyleBox[\" f \", \" TI \"], StyleBox[\" y \", \" TI \"]]}], \"}\"}], \",\", RowBox[{\" {\", RowBox[{StyleBox[\" x \", \" TI \"], \",\", SubscriptBox[StyleBox[\" x \", \" TI \"], StyleBox[\" min \", \" TI \"]], \",\", SubscriptBox[StyleBox[\" x \", \" TI \"], StyleBox[\" max \", \" TI \"]], \",\", StyleBox[\" dx \", \" TI \"]}], \"}\"}], \",\", RowBox[{\" {\", RowBox[{StyleBox[\" y \", \" TI \"], \",\", SubscriptBox[StyleBox[\" y \", \" TI \"], StyleBox[\" min \", \" TI \"]], \",\", SubscriptBox[StyleBox[\" y \", \" TI \"], StyleBox[\" max \", \" TI \"]], \",\", StyleBox[\" dy \", \" TI \"]}], \"}\"}]}], \"]\"}]\) uses steps \!\(\*StyleBox[\" dx \", \" TI \"]\) in variable \!\(\*StyleBox[\" x \", \" TI \"]\), and steps \!\(\*StyleBox[\" dy \", \" TI \"]\) in variable \!\(\*StyleBox[\" y \", \" TI \"]\)."
VectorFieldPlots`VectorHeads::usage = "VectorHeads is an option for the three-dimensional vector field functions, including VectorFieldPlot3D, that determines whether the vectors will be displayed with heads. "
WebServices`FromServiceResponse::usage = "\!\(\*RowBox[{\" FromServiceResponse \", \"[\", StyleBox[\" response \", \" TI \"], \"]\"}]\) converts a response message into a \!\(\*StyleBox[\" Mathematica \", FontSlant -> \" Italic \"]\) expression. "
WebServices`InstallServiceOperation::usage = "\!\(\*RowBox[{\" InstallServiceOperation \", \"[\", RowBox[{StyleBox[\" name \", \" TI \"], \",\", StyleBox[\" endpoint \", \" TI \"], \",\", StyleBox[\" arguments \", \" TI \"], \",\", StyleBox[\" options \", \" TI \"]}], \"]\"}]\) creates a function for the web service operation using the end point, arguments, and options. "
WebServices`InvokeServiceOperation::usage = "\!\(\*RowBox[{\" InvokeServiceOperation \", \"[\", RowBox[{StyleBox[RowBox[{\" \" \", \" url \", \" \" \"}], \" TI \"], \",\", StyleBox[\" request \", \" TI \"], \",\", StyleBox[\" options \", \" TI \"]}], \"]\"}]\) invokes a web service operation using the request message \!\(\*StyleBox[\" request \", \" TI \"]\). The message is sent to the end point specified in \!\(\*StyleBox[RowBox[{\" \" \", \" url \", \" \" \"}], \" TI \"]\). \n\!\(\*RowBox[{\" InvokeServiceOperation \", \"[\", RowBox[{StyleBox[\" symbol \", \" TI \"], \",\", StyleBox[\" parameters \", \" TI \"], \",\", StyleBox[\" options \", \" TI \"]}], \"]\"}]\) builds a request message using \!\(\*StyleBox[\" parameters \", \" TI \"]\) and invokes a web service operation using the request message and information linked with \!\(\*StyleBox[\" symbol \", \" TI \"]\). \n\!\(\*RowBox[{\" InvokeServiceOperation \", \"[\", RowBox[{StyleBox[\" symbol \", \" TI \"], \",\", StyleBox[\" request \", \" TI \"], \",\", StyleBox[\" options \", \" TI \"]}], \"]\"}]\) invokes a web service operation using the request message \!\(\*StyleBox[\" request \", \" TI \"]\) and information linked with \!\(\*StyleBox[\" symbol \", \" TI \"]\). "
WebServices`ToServiceRequest::usage = "\!\(\*RowBox[{\" ToServiceRequest \", \"[\", RowBox[{StyleBox[\" parameters \", \" TI \"], \",\", StyleBox[\" options \", \" TI \"]}], \"]\"}]\) builds a request message using input provided in the parameters. \n\!\(\*RowBox[{\" ToServiceRequest \", \"[\", RowBox[{StyleBox[\" symbol \", \" TI \"], \",\", StyleBox[\" parameters \", \" TI \"]}], \"]\"}]\) builds the request message for a web service operation using input provided in the parameters and information linked with the symbol. "
WebServices`$InstalledServices::usage = "$InstalledServices is a list of the installed web service operations."
WebServices`$PrintServiceRequest::usage = "$PrintServiceRequest uses the \!\(\*StyleBox[\" Mathematica \", FontSlant -> \" Italic \"]\) Print function to print the message sent to a web service. "
WebServices`$PrintServiceResponse::usage = "$PrintServiceResponse uses the \!\(\*StyleBox[\" Mathematica \", FontSlant -> \" Italic \"]\) Print function to print the message received from a web service before it is deserialized into a Rule syntax expression. "
WebServices`$PrintShortErrorMessages::usage = "$PrintShortErrorMessages specifies whether error messages from the web service operations will be shortened for the user to avoid long, intimidating error messages."
WebServices`$PrintWSDLDebug::usage = "$PrintWSDLDebug specifies whether WSDL debugging information will be printed when installing a web service. "
WorldPlot`Albers::usage = "\!\(\*RowBox[{\" Albers \", \"[\", RowBox[{SubscriptBox[StyleBox[\" p \", \" TI \"], StyleBox[\" 1\", \" TR \"]], \",\", SubscriptBox[StyleBox[\" p \", \" TI \"], StyleBox[\" 2\", \" TR \"]]}], \"]\"}]\) is a map projection for use with WorldGraphics, where \!\(\*SubscriptBox[StyleBox[\" p \", \" TI \"], StyleBox[\" 1\", \" TR \"]]\), \!\(\*SubscriptBox[StyleBox[\" p \", \" TI \"], StyleBox[\" 2\", \" TR \"]]\) specify the primary latitudes to be used for the projection."
WorldPlot`Equirectangular::usage = "Equirectangular is a map projection for use with WorldGraphics. Directly maps longitude to \!\(\*StyleBox[\" x \", \" TI \"]\), latitude to \!\(\*StyleBox[\" y \", \" TI \"]\). It is the simplest projection, mathematically."
WorldPlot`LambertAzimuthal::usage = "LambertAzimuthal is a map projection for use with WorldGraphics. Warning: with this projection, you cannot represent the point opposite your viewpoint."
WorldPlot`LambertCylindrical::usage = "LambertCylindrical is a map projection for use with WorldGraphics."
WorldPlot`Mercator::usage = "Mercator is a map projection for use with WorldGraphics. Warning: Mercator goes to Infinity at the poles."
WorldPlot`Mollweide::usage = "Mollweide is a map projection for use with WorldGraphics."
WorldPlot`Orthographic::usage = "Orthographic is a map projection for use with WorldGraphics. Warning: the projection is only good for a single hemisphere; ranges must be carefully chosen."
WorldPlot`RandomColors::usage = "RandomColors is a function to produce random colors."
WorldPlot`RandomGrays::usage = "RandomGrays is a function to produce random grayscales."
WorldPlot`ShowTooltips::usage = "ShowTooltips is an option for WorldPlot that indicates whether or not to display Tooltip labels for each country."
WorldPlot`Simple::usage = "Simple is an argument for the option WorldClipping."
WorldPlot`Sinusoidal::usage = "Sinusoidal is a map projection for use with WorldGraphics."
WorldPlot`ToMinutes::usage = "\!\(\*RowBox[{RowBox[{\" ToMinutes \", \"[\"}], StyleBox[\" degs \", \" TI \"], \"]\"}]\) converts degrees to minutes. \n\!\(\*RowBox[{RowBox[{\" ToMinutes \", \"[\", \" {\"}], StyleBox[\" degs \", \" TI \"], \",\", StyleBox[\" mins \", \" TI \"], \",\", StyleBox[\" secs \", \" TI \"], RowBox[{\"}\", \"]\"}]}]\) converts from DMS form to minutes. \n\!\(\*RowBox[{RowBox[{RowBox[{\" ToMinutes \", \"[\", RowBox[{RowBox[{RowBox[{\" {\", RowBox[{\" {\", \" {\"}]}], StyleBox[\" d \", \" TI \"]}], \",\", StyleBox[\" m \", \" TI \"], \",\", RowBox[{StyleBox[\" s \", \" TI \"], RowBox[{\"}\", \",\", \" {\"}], StyleBox[\" d \", \" TI \"]}], \",\", StyleBox[\" m \", \" TI \"], \",\", RowBox[{StyleBox[\" s \", \" TI \"], RowBox[{RowBox[{\"}\", \"}\"}], \",\"}], RowBox[{\" {\", \" {\"}], StyleBox[\" d \", \" TI \"]}], \",\", StyleBox[\" m \", \" TI \"], \",\", RowBox[{StyleBox[\" s \", \" TI \"], RowBox[{\"}\", \",\", \" {\"}], StyleBox[\" d \", \" TI \"]}], \",\", StyleBox[\" m \", \" TI \"], \",\", RowBox[{StyleBox[\" s \", \" TI \"], RowBox[{\"}\", \"}\"}], StyleBox[\" \[Ellipsis] \", \" TR \"]}]}]}], \"}\"}], \"]\"}]\) converts to \!\(\*RowBox[{\" {\", RowBox[{RowBox[{\" {\", RowBox[{StyleBox[\" lat \", \" TI \"], \",\", StyleBox[\" long \", \" TI \"]}], \"}\"}], \",\", RowBox[{RowBox[{\" {\", RowBox[{StyleBox[\" lat \", \" TI \"], \",\", StyleBox[\" long \", \" TI \"]}], \"}\"}], StyleBox[\" \[Ellipsis] \", \" TI \"]}]}], \"}\"}]\) with the coordinates in minutes."
WorldPlot`WorldBackground::usage = "WorldBackground is an option for WorldGraphics. \n\!\(\*RowBox[{\" WorldBackground \", \"->\", \" None \"}]\) specifies no background. \n\!\(\*RowBox[{\" WorldBackground \", \"->\", StyleBox[\" style \", \" TI \"]}]\) specifies the style of polygon representing background (the ocean, for instance)."
WorldPlot`WorldBorders::usage = "WorldBorders is an option for WorldPlot that can specify a style for the borders, or either of the following: None means do not put borders around polygons, while Automatic means not to put borders if a shading function or explicit shadings are present."
WorldPlot`WorldClipping::usage = "WorldClipping is an option for WorldGraphics that expresses the type of clipping to be done on polygons (in the interest of computational efficiency)."
WorldPlot`WorldCountries::usage = "WorldCountries is an option for WorldPlot that specifies the list of names of polygon sets (countries) in the database, where the names are usually specified as strings."
WorldPlot`WorldDatabase::usage = "WorldDatabase is an option for WorldPlot that specifies the symbol in which polygon data are stored. The default is WorldData."
WorldPlot`WorldFrame::usage = "WorldFrame is an option for WorldGraphics. \n\!\(\*RowBox[{\" WorldFrame \", \"->\", \" None \"}]\) specifies no frame. \n\!\(\*RowBox[{\" WorldFrame \", \"->\", StyleBox[\" style \", \" TI \"]}]\) specifies the style of line around the edge of the map."
WorldPlot`WorldFrameParts::usage = "WorldFrameParts is an option for WorldGraphics."
WorldPlot`WorldGraphics::usage = "\!\(\*RowBox[{RowBox[{\" WorldGraphics \", \"[\"}], StyleBox[\" primitives \", \" TI \"], \",\", StyleBox[\" options \", \" TI \"], \"]\"}]\) represents a planetary map. It applies to standard graphics \!\(\*StyleBox[\" primitives \", \" TI \"]\). "
WorldPlot`WorldGridBehind::usage = "WorldGridBehind is an option for WorldGraphics; it specifies whether the lines of longitude and latitude should be rendered behind or in front of the graphic; the default is True (behind)."
WorldPlot`WorldGrid::usage = "WorldGrid is an option for WorldGraphics that places lines of latitude and longitude at specified locations."
WorldPlot`WorldGridStyle::usage = "WorldGridStyle is an option for WorldGraphics that specifies the style of lines of latitude and longitude."
WorldPlot`WorldPlot::usage = "\!\(\*RowBox[{RowBox[{\" WorldPlot \", \"[\"}], StyleBox[\" list \", \" TI \"], \"]\"}]\) is a function to generate maps of the world that draw data from a specified database, where \!\(\*StyleBox[\" list \", \" TI \"]\) is a \!\(\*StyleBox[\" list \", \" TI \"]\) of countries from the database.\n\!\(\*RowBox[{RowBox[{\" WorldPlot \", \"[\", \" {\"}], StyleBox[\" list \", \" TI \"], \",\", StyleBox[\" shading \", \" TI \"], RowBox[{\"}\", \"]\"}]}]\) produces a map where \!\(\*StyleBox[\" shading \", \" TI \"]\) is either a function applied to each name in \!\(\*StyleBox[\" list \", \" TI \"]\), producing a color or grayscale, or is a list of shades, one per name in \!\(\*StyleBox[\" list \", \" TI \"]\)."
WorldPlot`WorldPoints::usage = "WorldPoints is an option for WorldGraphics that specifies the number of divisions between the minimum and maximum longitudes of the range, with the latitude scaled accordingly. "
WorldPlot`WorldProjection::usage = "WorldProjection is an option for WorldGraphics specified as a pure function that takes two arguments and returns a list, where the arguments are the latitude and longitude of a point, and the list is the x and y coordinates of the projection."
WorldPlot`WorldRange::usage = "WorldRange is an option for WorldGraphics that specifies the range of latitude and longitude that will be plotted."
WorldPlot`WorldRotatedRange::usage = "WorldRotatedRange is an option for WorldGraphics. "
WorldPlot`WorldRotation::usage = "WorldRotation is an option for WorldGraphics that turns any given projection into a Transverse or Oblique projection."
WorldPlot`WorldToGraphics::usage = "WorldToGraphics is an option for WorldPlot that determines whether a Graphics or WorldGraphics object is produced. "
XML`BoxesToMathML::usage = "\!\(\*RowBox[{BoxesToMathML, \"[\", StyleBox[\" boxes \", \" TI \"], \"]\"}]\) converts the \!\(\*StyleBox[\" Mathematica \", FontSlant -> \" Italic \"]\) box structure, \!\(\*StyleBox[\" boxes \", \" TI \"]\), into a MathML-flavored XML text string. "
XML`BoxesToSymbolicMathML::usage = "\!\(\*RowBox[{BoxesToSymbolicMathML, \"[\", StyleBox[\" boxes \", \" TI \"], \"]\"}]\) converts the \!\(\*StyleBox[\" Mathematica \", FontSlant -> \" Italic \"]\) box structure, \!\(\*StyleBox[\" boxes \", \" TI \"]\), into a MathML-flavored SymbolicXML structure."
XML`ExpressionToMathML::usage = "\!\(\*RowBox[{\" ExpressionToMathML \", \"[\", StyleBox[\" expr \", \" TI \"], \"]\"}]\) converts the \!\(\*StyleBox[\" Mathematica \", FontSlant -> \" Italic \"]\) expression, \!\(\*StyleBox[\" expr \", \" TI \"]\), into a MathML-flavored XML text string. "
XML`ExpressionToSymbolicExpressionML::usage = "\!\(\*RowBox[{\" ExpressionToSymbolicExpressionML \", \"[\", StyleBox[\" expr \", \" TI \"], \"]\"}]\) converts \!\(\*StyleBox[\" expr \", \" TI \"]\) to ExpressionML and returns the corresponding SymbolicXML. "
XML`ExpressionToSymbolicMathML::usage = "\!\(\*RowBox[{\" ExpressionToSymbolicMathML \", \"[\", StyleBox[\" expr \", \" TI \"], \"]\"}]\) converts the \!\(\*StyleBox[\" Mathematica \", FontSlant -> \" Italic \"]\) expression, \!\(\*StyleBox[\" expr \", \" TI \"]\), into a MathML-flavored SymbolicXML structure. "
XML`FromSymbolicXML::usage = "\!\(\*RowBox[{\" FromSymbolicXML \", \"[\", StyleBox[\" expr \", \" TI \"], \"]\"}]\) converts a SymbolicXML expression \!\(\*StyleBox[\" expr \", \" TI \"]\) to a more native format, if one is available."
XML`InitializeXMLParser::usage = "\!\(\*RowBox[{\" InitializeXMLParser \", \"[\", RowBox[{StyleBox[\" root \", \" TI \"], \",\", StyleBox[RowBox[{\" \" \", \" file \", \" \" \"}], \" TI \"]}], \"]\"}]\) creates an XMLParser object that has a list of entities corresponding to the contents of \" \!\(\*\nStyleBox[\" file \", \" TI \"]\)\" and can be used on XML documents that have a root element \!\(\*StyleBox[\" root \", \" TI \"]\)."
XML`MathMLToBoxes::usage = "\!\(\*RowBox[{MathMLToBoxes, \"[\", StyleBox[\" string \", \" TI \"], \"]\"}]\) converts the string containing MathML-flavored XML text into a \!\(\*StyleBox[\" Mathematica \", FontSlant -> \" Italic \"]\) box expression."
XML`MathMLToExpression::usage = "\!\(\*RowBox[{\" MathMLToExpression \", \"[\", StyleBox[\" string \", \" TI \"], \"]\"}]\) converts the string containing MathML-flavored XML text into a \!\(\*StyleBox[\" Mathematica \", FontSlant -> \" Italic \"]\) expression."
XML`NotebookToSymbolicNotebookML::usage = "\!\(\*RowBox[{\" NotebookToSymbolicNotebookML \", \"[\", StyleBox[\" expr \", \" TI \"], \"]\"}]\) converts \!\(\*StyleBox[\" expr \", \" TI \"]\) to NotebookML and returns the corresponding SymbolicXML. "
XML`RawXML::usage = "\!\(\*RowBox[{\" RawXML \", \"[\", StyleBox[\" \\ \" string \\ \" \",\" TI \",ShowStringCharacters->True], \"]\"}]\) represents a raw string fragment of XML that can be used inside a SymbolicXML expression. "
XML`ReleaseXMLParser::usage = "\!\(\*RowBox[{\" ReleaseXMLParser \", \"[\", StyleBox[\" parser \", \" TI \"], \"]\"}]\) frees up resources associated with the XMLParser object \!\(\*StyleBox[\" parser \", \" TI \"]\)."
XML`SymbolicExpressionMLToExpression::usage = "\!\(\*RowBox[{\" SymbolicExpressionMLToExpression \", \"[\", StyleBox[\" expr \", \" TI \"], \"]\"}]\) takes a SymbolicXML expression \!\(\*StyleBox[\" expr \", \" TI \"]\) that represents an ExpressionML document and returns the corresponding expression. "
XML`SymbolicMathMLToBoxes::usage = "\!\(\*RowBox[{SymbolicMathMLToBoxes, \"[\", StyleBox[\" smml \", \" TI \"], \"]\"}]\) converts the MathML-flavored SymbolicXML structure, \!\(\*StyleBox[\" smml \", \" TI \"]\), into a \!\(\*StyleBox[\" Mathematica \", FontSlant -> \" Italic \"]\) box expression."
XML`SymbolicMathMLToExpression::usage = "\!\(\*RowBox[{\" SymbolicMathMLToExpression \", \"[\", StyleBox[\" smml \", \" TI \"], \"]\"}]\) converts the MathML-flavored SymbolicXML structure, \!\(\*StyleBox[\" smml \", \" TI \"]\), into a \!\(\*StyleBox[\" Mathematica \", FontSlant -> \" Italic \"]\) expression. The output is in the form of content MathML, wherever possible."
XML`SymbolicNotebookMLToNotebook::usage = "\!\(\*RowBox[{\" SymbolicNotebookMLToNotebook \", \"[\", StyleBox[\" expr \", \" TI \"], \"]\"}]\) takes a SymbolicXML expression \!\(\*StyleBox[\" expr \", \" TI \"]\) that represents a NotebookML document and returns the corresponding notebook expression. "
XML`SymbolicXMLErrors::usage = "\!\(\*RowBox[{\" SymbolicXMLErrors \", \"[\", StyleBox[\" expr \", \" TI \"], \"]\"}]\) returns a list of part specifications indicating where there are errors in the SymbolicXML expression \!\(\*StyleBox[\" expr \", \" TI \"]\) and a message about the nature of each error."
XML`SymbolicXMLQ::usage = "\!\(\*RowBox[{\" SymbolicXMLQ \", \"[\", StyleBox[\" expr \", \" TI \"], \"]\"}]\) returns True if the expression \!\(\*StyleBox[\" expr \", \" TI \"]\) matches some basic patterns for a SymbolicXML expression and False otherwise.\n\!\(\*RowBox[{\" SymbolicXMLQ \", \"[\", RowBox[{StyleBox[\" expr \", \" TI \"], \",\", \" True \"}], \"]\"}]\) performs a complete test on \!\(\*StyleBox[\" expr \", \" TI \"]\) to determine if it is a well-formed SymbolicXML expression. \n\!\(\*RowBox[{\" SymbolicXMLQ \", \"[\", RowBox[{StyleBox[\" expr \", \" TI \"], \",\", \" False \"}], \"]\"}]\) is equivalent to \!\(\*RowBox[{\" SymbolicXMLQ \", \"[\", StyleBox[\" expr \", \" TI \"], \"]\"}]\)."
XML`ToCompactXML::usage = "\!\(\*RowBox[{RowBox[{\" ToCompactXML \", \"[\", StyleBox[\" expr \", \" TI \"], \"]\"}], \" \"}]\) generates an equivalent SymbolicXML expression that suppresses all the redundant namespace information for elements and attributes in \!\(\*StyleBox[\" expr \", \" TI \"]\). \n\!\(\*RowBox[{\" ToCompactXML \", \"[\", RowBox[{StyleBox[\" expr \", \" TI \"], \",\", StyleBox[\" patt \", \" TI \"]}], \"]\"}]\) suppresses only namespaces that match \!\(\*StyleBox[\" patt \", \" TI \"]\)."
XML`ToSymbolicXML::usage = "\!\(\*RowBox[{\" ToSymbolicXML \", \"[\", StyleBox[\" expr \", \" TI \"], \"]\"}]\) converts an expression \!\(\*StyleBox[\" expr \", \" TI \"]\) to an appropriate XML format and returns the result as SymbolicXML."
XML`ToVerboseXML::usage = "\!\(\*RowBox[{\" ToVerboseXML \", \"[\", StyleBox[\" expr \", \" TI \"], \"]\"}]\) generates an equivalent SymbolicXML expression that explicitly exposes all the namespace information for elements and attributes in \!\(\*StyleBox[\" expr \", \" TI \"]\). \n\!\(\*RowBox[{\" ToVerboseXML \", \"[\", RowBox[{StyleBox[\" expr \", \" TI \"], \",\", StyleBox[\" pattern \", \" TI \"]}], \"]\"}]\) exposes only namespaces that match \!\(\*StyleBox[\" pattern \", \" TI \"]\)."
XML`XMLGet::usage = "\!\(\*RowBox[{\" XMLGet \", \"[\", StyleBox[\" \\ \" \\!\\ (\\*StyleBox[\\ \" file \\ \",\\ \" TI \\ \"]\\)\\ \" \", ShowStringCharacters->True], \"]\"}]\) returns the XML expression tree corresponding to the contents of \" \!\(\*\nStyleBox[\" file \", \" TI \"]\)\".\n\!\(\*RowBox[{\" XMLGet \", \"[\", RowBox[{StyleBox[StyleBox[\" \\ \" file \\ \" \",ShowStringCharacters->True], \" TI \"], \",\", StyleBox[\" parser \", \" TI \"]}], \"]\"}]\) uses the pre-initialized XMLParser object to parse the file. \n\!\(\*RowBox[{\" XMLGet \", \"[\", RowBox[{StyleBox[\" \\ \" http://\\!\\ (\\*StyleBox[\\ \" url \\ \",\\ \" TI \\ \"]\\)\\ \" \",ShowStringCharacters->True], \",\", \" \", \" \[Ellipsis] \"}], \"]\"}]\) reads from a URL. "
XML`XMLGetString::usage = "\!\(\*RowBox[{\" XMLGetString \", \"[\", StyleBox[\" \\ \" \\!\\ (\\*StyleBox[\\ \" data \\ \",\\ \" TI \\ \"]\\)\\ \" \", ShowStringCharacters->True], \"]\"}]\) returns the XML expression tree corresponding to a string.\n\!\(\*RowBox[{\" XMLGetString \", \"[\", RowBox[{StyleBox[\" \\ \" \\!\\ (\\*StyleBox[\\ \" data \\ \",\\ \" TI \\ \"]\\)\\ \" \", ShowStringCharacters->True], \",\", StyleBox[\" parser \", \" TI \"]}], \"]\"}]\) uses the pre-initialized XMLParser object to parse the string. "
XML`XMLParser::usage = "\!\(\*RowBox[{\" XMLParser \", \"[\", RowBox[{StyleBox[\" root \", \" TI \"], \",\", StyleBox[\" \\ \" \\!\\ (\\*StyleBox[\\ \" file \\ \",\\ \" TI \\ \"]\\)\\ \" \", ShowStringCharacters->True]}], \"]\"}]\) represents a parser object created by InitializeXMLParser for XML documents with a root element \!\(\*StyleBox[\" root \", \" TI \"]\) and corresponding to the DTD \" \!\(\*\nStyleBox[\" file \", \" TI \"]\)\"."
