(* :Title: CharacterReplacements.m *)

(* :Author:
	Andrew Hunt
	andy@wolfram.com
*)

(* :Package Version: 1.0 *)

(* :Mathematica Version: 4.2 *)
                     
(* :Copyright: (c) 2002, Wolfram Research, Inc. All rights reserved. *)

(* :Discussion:
	Mathematica Long name Character Replacements
*)



BeginPackage["DocumentationBuild`DocumentationConversion`CharacterReplacements`"]


(*$characterBaseURL = "http://documents.wolfram.com/MathematicaCharacters/";*)
$characterBaseURL = "/chars/";
$characterBaseURL::usage = "$characterBaseURL is the base url for characterReplacementRules.";
$characterBaseURL::notes = "See also: characterReplacementRules";

characterReplacementRules::usage = "characterReplacementRules is a list of replacement rules which convert Mathematica LongName characters to html image tags. Results are returned in SymbolicXML[].";
characterReplacementRules::notes = "See also: characterReplacementRules";


(* these are split up for fast string replacement *)
twoCharacterReplacementRules = {
      "!=" -> XMLElement["span",  {"class" -> "special-character NotEqual"},  {XML`RawXML["&#8800;"]}], 
      "==" -> XMLElement["span",  {"class" -> "special-character Equal"},  {XML`RawXML["&#62513;"]}],
      ":>" ->  XMLElement["span",  {"class" -> "special-character RuleDelayed"},  {XML`RawXML["&#62751;"]}]
};


(*
Greek Characters
*)
                          (* Dispatch@ *)
characterReplacementRules = {

    (* Spaces,  punctuation, and Invisibles *)

    "\t" -> "\[NonBreakingSpace]\[NonBreakingSpace]\[NonBreakingSpace]\[NonBreakingSpace]", 
    "'" -> XML`RawXML["&#39;"],
    "\[AliasIndicator]" -> XMLElement["span", {"class"->"KeyEvent"}, {"Esc"}],
    "\[AliasDelimiter]" -> XMLElement["span", {"class"->"KeyEvent"}, {"Esc"}],
    "\[LineSeparator]" -> XMLElement["br", {}, {}], 
	"\:f35f" -> "",
    "\[IndentingNewLine]" -> XMLElement["br", {}, {}],
    "\[ParagraphSeparator]" -> XMLElement["p", {}, {}], 
    "\[ThinSpace]" -> XMLElement["span", {"class"->"ThinSpace"}, {XML`RawXML["<!-- -->"]}], 
  
    (* using Mathematica fonts *)
  
	"\[AAcute]" -> XMLElement["span",  {"class" -> "special-character AAcute"},  {XML`RawXML["&#225;"]}],
	"\[ABar]" -> XMLElement["span",  {"class" -> "special-character ABar"},  {XML`RawXML["&#257;"]}],
	"\[ACup]" -> XMLElement["span",  {"class" -> "special-character ACup"},  {XML`RawXML["&#259;"]}],
	"\[ADoubleDot]" -> XMLElement["span",  {"class" -> "special-character ADoubleDot"},  {XML`RawXML["&#228;"]}],
	"\[AE]" -> XMLElement["span",  {"class" -> "special-character AE"},  {XML`RawXML["&#230;"]}],
	"\[AGrave]" -> XMLElement["span",  {"class" -> "special-character AGrave"},  {XML`RawXML["&#224;"]}],
	"\[AHat]" -> XMLElement["span",  {"class" -> "special-character AHat"},  {XML`RawXML["&#226;"]}],
	"\[Akuz]" -> XMLElement["span",  {"class" -> "special-character Akuz"},  {XML`RawXML["&#63272;"]}],
	"\[Aleph]" -> XMLElement["span",  {"class" -> "special-character Aleph"},  {XML`RawXML["&#8501;"]}],
	"\[AliasDelimiter]" -> XMLElement["span",  {"class" -> "special-character AliasDelimiter"},  {XML`RawXML["&#63332;"]}],
	"\[AliasIndicator]" -> XMLElement["span",  {"class" -> "special-character AliasIndicator"},  {XML`RawXML["&#63336;"]}],
	"\[AlignmentMarker]" -> XMLElement["span",  {"class" -> "special-character AlignmentMarker"},  {" "}],
	"\[Alpha]" -> XMLElement["span",  {"class" -> "special-character Alpha"},  {XML`RawXML["&#945;"]}],
	"\[AltKey]" -> XMLElement["span",  {"class" -> "special-character AltKey"},  {XML`RawXML["&#63441;"]}],
	"\[And]" -> XMLElement["span",  {"class" -> "special-character And"},  {XML`RawXML["&#8743;"]}],
	"\[Andy]" -> XMLElement["span",  {"class" -> "special-character Andy"},  {XML`RawXML["&#63273;"]}],
	"\[Angle]" -> XMLElement["span",  {"class" -> "special-character Angle"},  {XML`RawXML["&#8736;"]}],
	"\[Angstrom]" -> XMLElement["span",  {"class" -> "special-character Angstrom"},  {XML`RawXML["&#8491;"]}],
	"\[AquariusSign]" -> XMLElement["span",  {"class" -> "special-character AquariusSign"},  {XML`RawXML["&#9810;"]}],
	"\[AriesSign]" -> XMLElement["span",  {"class" -> "special-character AriesSign"},  {XML`RawXML["&#9800;"]}],
	"\[ARing]" -> XMLElement["span",  {"class" -> "special-character ARing"},  {XML`RawXML["&#229;"]}],
	"\[AscendingEllipsis]" -> XMLElement["span",  {"class" -> "special-character AscendingEllipsis"},  {XML`RawXML["&#8944;"]}],
	"\[ATilde]" -> XMLElement["span",  {"class" -> "special-character ATilde"},  {XML`RawXML["&#227;"]}],
	"\[AutoLeftMatch]" -> XMLElement["span",  {"class" -> "special-character AutoLeftMatch"},  {" "}],
	"\[AutoOperand]" -> XMLElement["span",  {"class" -> "special-character AutoOperand"},  {" "}],
	"\[AutoPlaceholder]" -> XMLElement["span",  {"class" -> "special-character AutoPlaceholder"},  {XML`RawXML["&#62372;"]}],
	"\[AutoRightMatch]" -> XMLElement["span",  {"class" -> "special-character AutoRightMatch"},  {" "}],
	"\[AutoSpace]" -> XMLElement["span",  {"class" -> "special-character AutoSpace"},  {" "}],
	"\[Backslash]" -> XMLElement["span",  {"class" -> "special-character Backslash"},  {XML`RawXML["&#8726;"]}],
	"\[BeamedEighthNote]" -> XMLElement["span",  {"class" -> "special-character BeamedEighthNote"},  {XML`RawXML["&#9835;"]}],
	"\[BeamedSixteenthNote]" -> XMLElement["span",  {"class" -> "special-character BeamedSixteenthNote"},  {XML`RawXML["&#9836;"]}],
	"\[Because]" -> XMLElement["span",  {"class" -> "special-character Because"},  {XML`RawXML["&#8757;"]}],
	"\[Bet]" -> XMLElement["span",  {"class" -> "special-character Bet"},  {XML`RawXML["&#8502;"]}],
	"\[Beta]" -> XMLElement["span",  {"class" -> "special-character Beta"},  {XML`RawXML["&#946;"]}],
	"\[BlackBishop]" -> XMLElement["span",  {"class" -> "special-character BlackBishop"},  {XML`RawXML["&#9821;"]}],
	"\[BlackKing]" -> XMLElement["span",  {"class" -> "special-character BlackKing"},  {XML`RawXML["&#9818;"]}],
	"\[BlackKnight]" -> XMLElement["span",  {"class" -> "special-character BlackKnight"},  {XML`RawXML["&#9822;"]}],
	"\[BlackPawn]" -> XMLElement["span",  {"class" -> "special-character BlackPawn"},  {XML`RawXML["&#9823;"]}],
	"\[BlackQueen]" -> XMLElement["span",  {"class" -> "special-character BlackQueen"},  {XML`RawXML["&#9819;"]}],
	"\[BlackRook]" -> XMLElement["span",  {"class" -> "special-character BlackRook"},  {XML`RawXML["&#9820;"]}],
	"\[Breve]" -> XMLElement["span",  {"class" -> "special-character Breve"},  {XML`RawXML["&#728;"]}],
	"\[Bullet]" -> XMLElement["span",  {"class" -> "special-character Bullet"},  {XML`RawXML["&#8226;"]}],
	"\[CAcute]" -> XMLElement["span",  {"class" -> "special-character CAcute"},  {XML`RawXML["&#263;"]}],
	"\[CancerSign]" -> XMLElement["span",  {"class" -> "special-character CancerSign"},  {XML`RawXML["&#9803;"]}],
	"\[Cap]" -> XMLElement["span",  {"class" -> "special-character Cap"},  {XML`RawXML["&#8994;"]}],
	"\[CapitalAAcute]" -> XMLElement["span",  {"class" -> "special-character CapitalAAcute"},  {XML`RawXML["&#193;"]}],
	"\[CapitalABar]" -> XMLElement["span",  {"class" -> "special-character CapitalABar"},  {XML`RawXML["&#256;"]}],
	"\[CapitalACup]" -> XMLElement["span",  {"class" -> "special-character CapitalACup"},  {XML`RawXML["&#258;"]}],
	"\[CapitalADoubleDot]" -> XMLElement["span",  {"class" -> "special-character CapitalADoubleDot"},  {XML`RawXML["&#196;"]}],
	"\[CapitalAE]" -> XMLElement["span",  {"class" -> "special-character CapitalAE"},  {XML`RawXML["&#198;"]}],
	"\[CapitalAGrave]" -> XMLElement["span",  {"class" -> "special-character CapitalAGrave"},  {XML`RawXML["&#192;"]}],
	"\[CapitalAHat]" -> XMLElement["span",  {"class" -> "special-character CapitalAHat"},  {XML`RawXML["&#194;"]}],
	"\[CapitalAlpha]" -> XMLElement["span",  {"class" -> "special-character CapitalAlpha"},  {XML`RawXML["&#913;"]}],
	"\[CapitalARing]" -> XMLElement["span",  {"class" -> "special-character CapitalARing"},  {XML`RawXML["&#197;"]}],
	"\[CapitalATilde]" -> XMLElement["span",  {"class" -> "special-character CapitalATilde"},  {XML`RawXML["&#195;"]}],
	"\[CapitalBeta]" -> XMLElement["span",  {"class" -> "special-character CapitalBeta"},  {XML`RawXML["&#914;"]}],
	"\[CapitalCAcute]" -> XMLElement["span",  {"class" -> "special-character CapitalCAcute"},  {XML`RawXML["&#262;"]}],
	"\[CapitalCCedilla]" -> XMLElement["span",  {"class" -> "special-character CapitalCCedilla"},  {XML`RawXML["&#199;"]}],
	"\[CapitalCHacek]" -> XMLElement["span",  {"class" -> "special-character CapitalCHacek"},  {XML`RawXML["&#268;"]}],
	"\[CapitalChi]" -> XMLElement["span",  {"class" -> "special-character CapitalChi"},  {XML`RawXML["&#935;"]}],
	"\[CapitalDelta]" -> XMLElement["span",  {"class" -> "special-character CapitalDelta"},  {XML`RawXML["&#916;"]}],
	"\[CapitalDHacek]" -> XMLElement["span",  {"class" -> "special-character CapitalDHacek"},  {XML`RawXML["&#270;"]}],
	"\[CapitalDifferentialD]" -> XMLElement["span",  {"class" -> "special-character CapitalDifferentialD"},  {XML`RawXML["&#63307;"]}],
	"\[CapitalDigamma]" -> XMLElement["span",  {"class" -> "special-character CapitalDigamma"},  {XML`RawXML["&#988;"]}],
	"\[CapitalEAcute]" -> XMLElement["span",  {"class" -> "special-character CapitalEAcute"},  {XML`RawXML["&#201;"]}],
	"\[CapitalEBar]" -> XMLElement["span",  {"class" -> "special-character CapitalEBar"},  {XML`RawXML["&#274;"]}],
	"\[CapitalECup]" -> XMLElement["span",  {"class" -> "special-character CapitalECup"},  {XML`RawXML["&#276;"]}],
	"\[CapitalEDoubleDot]" -> XMLElement["span",  {"class" -> "special-character CapitalEDoubleDot"},  {XML`RawXML["&#203;"]}],
	"\[CapitalEGrave]" -> XMLElement["span",  {"class" -> "special-character CapitalEGrave"},  {XML`RawXML["&#200;"]}],
	"\[CapitalEHacek]" -> XMLElement["span",  {"class" -> "special-character CapitalEHacek"},  {XML`RawXML["&#282;"]}],
	"\[CapitalEHat]" -> XMLElement["span",  {"class" -> "special-character CapitalEHat"},  {XML`RawXML["&#202;"]}],
	"\[CapitalEpsilon]" -> XMLElement["span",  {"class" -> "special-character CapitalEpsilon"},  {XML`RawXML["&#917;"]}],
	"\[CapitalEta]" -> XMLElement["span",  {"class" -> "special-character CapitalEta"},  {XML`RawXML["&#919;"]}],
	"\[CapitalEth]" -> XMLElement["span",  {"class" -> "special-character CapitalEth"},  {XML`RawXML["&#208;"]}],
	"\[CapitalGamma]" -> XMLElement["span",  {"class" -> "special-character CapitalGamma"},  {XML`RawXML["&#915;"]}],
	"\[CapitalIAcute]" -> XMLElement["span",  {"class" -> "special-character CapitalIAcute"},  {XML`RawXML["&#205;"]}],
	"\[CapitalICup]" -> XMLElement["span",  {"class" -> "special-character CapitalICup"},  {XML`RawXML["&#300;"]}],
	"\[CapitalIDoubleDot]" -> XMLElement["span",  {"class" -> "special-character CapitalIDoubleDot"},  {XML`RawXML["&#207;"]}],
	"\[CapitalIGrave]" -> XMLElement["span",  {"class" -> "special-character CapitalIGrave"},  {XML`RawXML["&#204;"]}],
	"\[CapitalIHat]" -> XMLElement["span",  {"class" -> "special-character CapitalIHat"},  {XML`RawXML["&#206;"]}],
	"\[CapitalIota]" -> XMLElement["span",  {"class" -> "special-character CapitalIota"},  {XML`RawXML["&#921;"]}],
	"\[CapitalKappa]" -> XMLElement["span",  {"class" -> "special-character CapitalKappa"},  {XML`RawXML["&#922;"]}],
	"\[CapitalKoppa]" -> XMLElement["span",  {"class" -> "special-character CapitalKoppa"},  {XML`RawXML["&#990;"]}],
	"\[CapitalLambda]" -> XMLElement["span",  {"class" -> "special-character CapitalLambda"},  {XML`RawXML["&#923;"]}],
	"\[CapitalLSlash]" -> XMLElement["span",  {"class" -> "special-character CapitalLSlash"},  {XML`RawXML["&#321;"]}],
	"\[CapitalMu]" -> XMLElement["span",  {"class" -> "special-character CapitalMu"},  {XML`RawXML["&#924;"]}],
	"\[CapitalNHacek]" -> XMLElement["span",  {"class" -> "special-character CapitalNHacek"},  {XML`RawXML["&#327;"]}],
	"\[CapitalNTilde]" -> XMLElement["span",  {"class" -> "special-character CapitalNTilde"},  {XML`RawXML["&#209;"]}],
	"\[CapitalNu]" -> XMLElement["span",  {"class" -> "special-character CapitalNu"},  {XML`RawXML["&#925;"]}],
	"\[CapitalOAcute]" -> XMLElement["span",  {"class" -> "special-character CapitalOAcute"},  {XML`RawXML["&#211;"]}],
	"\[CapitalODoubleAcute]" -> XMLElement["span",  {"class" -> "special-character CapitalODoubleAcute"},  {XML`RawXML["&#336;"]}],
	"\[CapitalODoubleDot]" -> XMLElement["span",  {"class" -> "special-character CapitalODoubleDot"},  {XML`RawXML["&#214;"]}],
	"\[CapitalOE]" -> XMLElement["span",  {"class" -> "special-character CapitalOE"},  {XML`RawXML["&#338;"]}],
	"\[CapitalOGrave]" -> XMLElement["span",  {"class" -> "special-character CapitalOGrave"},  {XML`RawXML["&#210;"]}],
	"\[CapitalOHat]" -> XMLElement["span",  {"class" -> "special-character CapitalOHat"},  {XML`RawXML["&#212;"]}],
	"\[CapitalOmega]" -> XMLElement["span",  {"class" -> "special-character CapitalOmega"},  {XML`RawXML["&#937;"]}],
	"\[CapitalOmicron]" -> XMLElement["span",  {"class" -> "special-character CapitalOmicron"},  {XML`RawXML["&#927;"]}],
	"\[CapitalOSlash]" -> XMLElement["span",  {"class" -> "special-character CapitalOSlash"},  {XML`RawXML["&#216;"]}],
	"\[CapitalOTilde]" -> XMLElement["span",  {"class" -> "special-character CapitalOTilde"},  {XML`RawXML["&#213;"]}],
	"\[CapitalPhi]" -> XMLElement["span",  {"class" -> "special-character CapitalPhi"},  {XML`RawXML["&#934;"]}],
	"\[CapitalPi]" -> XMLElement["span",  {"class" -> "special-character CapitalPi"},  {XML`RawXML["&#928;"]}],
	"\[CapitalPsi]" -> XMLElement["span",  {"class" -> "special-character CapitalPsi"},  {XML`RawXML["&#936;"]}],
	"\[CapitalRHacek]" -> XMLElement["span",  {"class" -> "special-character CapitalRHacek"},  {XML`RawXML["&#344;"]}],
	"\[CapitalRho]" -> XMLElement["span",  {"class" -> "special-character CapitalRho"},  {XML`RawXML["&#929;"]}],
	"\[CapitalSampi]" -> XMLElement["span",  {"class" -> "special-character CapitalSampi"},  {XML`RawXML["&#992;"]}],
	"\[CapitalSHacek]" -> XMLElement["span",  {"class" -> "special-character CapitalSHacek"},  {XML`RawXML["&#352;"]}],
	"\[CapitalSigma]" -> XMLElement["span",  {"class" -> "special-character CapitalSigma"},  {XML`RawXML["&#931;"]}],
	"\[CapitalStigma]" -> XMLElement["span",  {"class" -> "special-character CapitalStigma"},  {XML`RawXML["&#986;"]}],
	"\[CapitalTau]" -> XMLElement["span",  {"class" -> "special-character CapitalTau"},  {XML`RawXML["&#932;"]}],
	"\[CapitalTHacek]" -> XMLElement["span",  {"class" -> "special-character CapitalTHacek"},  {XML`RawXML["&#356;"]}],
	"\[CapitalTheta]" -> XMLElement["span",  {"class" -> "special-character CapitalTheta"},  {XML`RawXML["&#920;"]}],
	"\[CapitalThorn]" -> XMLElement["span",  {"class" -> "special-character CapitalThorn"},  {XML`RawXML["&#222;"]}],
	"\[CapitalUAcute]" -> XMLElement["span",  {"class" -> "special-character CapitalUAcute"},  {XML`RawXML["&#218;"]}],
	"\[CapitalUDoubleAcute]" -> XMLElement["span",  {"class" -> "special-character CapitalUDoubleAcute"},  {XML`RawXML["&#368;"]}],
	"\[CapitalUDoubleDot]" -> XMLElement["span",  {"class" -> "special-character CapitalUDoubleDot"},  {XML`RawXML["&#220;"]}],
	"\[CapitalUGrave]" -> XMLElement["span",  {"class" -> "special-character CapitalUGrave"},  {XML`RawXML["&#217;"]}],
	"\[CapitalUHat]" -> XMLElement["span",  {"class" -> "special-character CapitalUHat"},  {XML`RawXML["&#219;"]}],
	"\[CapitalUpsilon]" -> XMLElement["span",  {"class" -> "special-character CapitalUpsilon"},  {XML`RawXML["&#933;"]}],
	"\[CapitalURing]" -> XMLElement["span",  {"class" -> "special-character CapitalURing"},  {XML`RawXML["&#366;"]}],
	"\[CapitalXi]" -> XMLElement["span",  {"class" -> "special-character CapitalXi"},  {XML`RawXML["&#926;"]}],
	"\[CapitalYAcute]" -> XMLElement["span",  {"class" -> "special-character CapitalYAcute"},  {XML`RawXML["&#221;"]}],
	"\[CapitalZeta]" -> XMLElement["span",  {"class" -> "special-character CapitalZeta"},  {XML`RawXML["&#918;"]}],
	"\[CapitalZHacek]" -> XMLElement["span",  {"class" -> "special-character CapitalZHacek"},  {XML`RawXML["&#381;"]}],
	"\[CapricornSign]" -> XMLElement["span",  {"class" -> "special-character CapricornSign"},  {XML`RawXML["&#9809;"]}],
	"\[CCedilla]" -> XMLElement["span",  {"class" -> "special-character CCedilla"},  {XML`RawXML["&#231;"]}],
	"\[Cedilla]" -> XMLElement["span",  {"class" -> "special-character Cedilla"},  {XML`RawXML["&#184;"]}],
	"\[Cent]" -> XMLElement["span",  {"class" -> "special-character Cent"},  {XML`RawXML["&#162;"]}],
	"\[CenterDot]" -> XMLElement["span",  {"class" -> "special-character CenterDot"},  {XML`RawXML["&#183;"]}],
	"\[CenterEllipsis]" -> XMLElement["span",  {"class" -> "special-character CenterEllipsis"},  {XML`RawXML["&#8943;"]}],
	"\[CHacek]" -> XMLElement["span",  {"class" -> "special-character CHacek"},  {XML`RawXML["&#269;"]}],
	"\[CheckedBox]" -> XMLElement["span",  {"class" -> "special-character CheckedBox"},  {XML`RawXML["&#9746;"]}],
	"\[Checkmark]" -> XMLElement["span",  {"class" -> "special-character Checkmark"},  {XML`RawXML["&#10003;"]}],
	"\[CheckmarkedBox]" -> XMLElement["span",  {"class" -> "special-character CheckmarkedBox"},  {XML`RawXML["&#9745;"]}],
	"\[Chi]" -> XMLElement["span",  {"class" -> "special-character Chi"},  {XML`RawXML["&#967;"]}],
	"\[CircleDot]" -> XMLElement["span",  {"class" -> "special-character CircleDot"},  {XML`RawXML["&#8857;"]}],
	"\[CircleMinus]" -> XMLElement["span",  {"class" -> "special-character CircleMinus"},  {XML`RawXML["&#8854;"]}],
	"\[CirclePlus]" -> XMLElement["span",  {"class" -> "special-character CirclePlus"},  {XML`RawXML["&#8853;"]}],
	"\[CircleTimes]" -> XMLElement["span",  {"class" -> "special-character CircleTimes"},  {XML`RawXML["&#8855;"]}],
	"\[ClockwiseContourIntegral]" -> XMLElement["span",  {"class" -> "special-character ClockwiseContourIntegral"},  {XML`RawXML["&#8754;"]}],
	"\[CloseCurlyDoubleQuote]" -> XMLElement["span",  {"class" -> "special-character CloseCurlyDoubleQuote"},  {XML`RawXML["&#8221;"]}],
	"\[CloseCurlyQuote]" -> XMLElement["span",  {"class" -> "special-character CloseCurlyQuote"},  {XML`RawXML["&#8217;"]}],
	"\[CloverLeaf]" -> XMLElement["span",  {"class" -> "special-character CloverLeaf"},  {XML`RawXML["&#8984;"]}],
	"\[ClubSuit]" -> XMLElement["span",  {"class" -> "special-character ClubSuit"},  {XML`RawXML["&#9827;"]}],
	"\[Colon]" -> XMLElement["span",  {"class" -> "special-character Colon"},  {XML`RawXML["&#8758;"]}],
	"\[CommandKey]" -> XMLElement["span",  {"class" -> "special-character CommandKey"},  {XML`RawXML["&#63338;"]}],
	"\[Conditioned]" -> XMLElement["span",  {"class" -> "special-character Conditioned"},  {XML`RawXML["&#62419;"]}],
	"\[Congruent]" -> XMLElement["span",  {"class" -> "special-character Congruent"},  {XML`RawXML["&#8801;"]}],
	"\[Conjugate]" -> XMLElement["span",  {"class" -> "special-character Conjugate"},  {XML`RawXML["&#62408;"]}],
	"\[ConjugateTranspose]" -> XMLElement["span",  {"class" -> "special-character ConjugateTranspose"},  {XML`RawXML["&#62409;"]}],
	"\[ConstantC]" -> XMLElement["span",  {"class" -> "special-character ConstantC"},  {XML`RawXML["&#63450;"]}],
	"\[Continuation]" -> XMLElement["span",  {"class" -> "special-character Continuation"},  {XML`RawXML["&#62385;"]}],
	"\[ContinuedFractionK]" -> XMLElement["span",  {"class" -> "special-character ContinuedFractionK"},  {XML`RawXML["&#62425;"]}],
	"\[ContourIntegral]" -> XMLElement["span",  {"class" -> "special-character ContourIntegral"},  {XML`RawXML["&#8750;"]}],
	"\[ControlKey]" -> XMLElement["span",  {"class" -> "special-character ControlKey"},  {XML`RawXML["&#63331;"]}],
	"\[Coproduct]" -> XMLElement["span",  {"class" -> "special-character Coproduct"},  {XML`RawXML["&#8720;"]}],
	"\[Copyright]" -> XMLElement["span",  {"class" -> "special-character Copyright"},  {XML`RawXML["&#169;"]}],
	"\[CounterClockwiseContourIntegral]" -> XMLElement["span",  {"class" -> "special-character CounterClockwiseContourIntegral"},  {XML`RawXML["&#8755;"]}],
	"\[Cross]" -> XMLElement["span",  {"class" -> "special-character Cross"},  {XML`RawXML["&#62624;"]}],
	"\[Cup]" -> XMLElement["span",  {"class" -> "special-character Cup"},  {XML`RawXML["&#8995;"]}],
	"\[CupCap]" -> XMLElement["span",  {"class" -> "special-character CupCap"},  {XML`RawXML["&#8781;"]}],
	"\[Curl]" -> XMLElement["span",  {"class" -> "special-character Curl"},  {XML`RawXML["&#62424;"]}],
	"\[CurlyCapitalUpsilon]" -> XMLElement["span",  {"class" -> "special-character CurlyCapitalUpsilon"},  {XML`RawXML["&#978;"]}],
	"\[CurlyEpsilon]" -> XMLElement["span",  {"class" -> "special-character CurlyEpsilon"},  {XML`RawXML["&#949;"]}],
	"\[CurlyKappa]" -> XMLElement["span",  {"class" -> "special-character CurlyKappa"},  {XML`RawXML["&#1008;"]}],
	"\[CurlyPhi]" -> XMLElement["span",  {"class" -> "special-character CurlyPhi"},  {XML`RawXML["&#966;"]}],
	"\[CurlyPi]" -> XMLElement["span",  {"class" -> "special-character CurlyPi"},  {XML`RawXML["&#982;"]}],
	"\[CurlyRho]" -> XMLElement["span",  {"class" -> "special-character CurlyRho"},  {XML`RawXML["&#1009;"]}],
	"\[CurlyTheta]" -> XMLElement["span",  {"class" -> "special-character CurlyTheta"},  {XML`RawXML["&#977;"]}],
	"\[Currency]" -> XMLElement["span",  {"class" -> "special-character Currency"},  {XML`RawXML["&#164;"]}],
	"\[Dagger]" -> XMLElement["span",  {"class" -> "special-character Dagger"},  {XML`RawXML["&#8224;"]}],
	"\[Dalet]" -> XMLElement["span",  {"class" -> "special-character Dalet"},  {XML`RawXML["&#8504;"]}],
	"\[Dash]" -> XMLElement["span",  {"class" -> "special-character Dash"},  {XML`RawXML["&#8211;"]}],
	"\[Degree]" -> XMLElement["span",  {"class" -> "special-character Degree"},  {XML`RawXML["&#176;"]}],
	"\[Del]" -> XMLElement["span",  {"class" -> "special-character Del"},  {XML`RawXML["&#8711;"]}],
	"\[DeleteKey]" -> XMLElement["span",  {"class" -> "special-character DeleteKey"},  {XML`RawXML["&#63440;"]}],
	"\[Delta]" -> XMLElement["span",  {"class" -> "special-character Delta"},  {XML`RawXML["&#948;"]}],
	"\[DescendingEllipsis]" -> XMLElement["span",  {"class" -> "special-character DescendingEllipsis"},  {XML`RawXML["&#8945;"]}],
	"\[DHacek]" -> XMLElement["span",  {"class" -> "special-character DHacek"},  {XML`RawXML["&#271;"]}],
	"\[Diameter]" -> XMLElement["span",  {"class" -> "special-character Diameter"},  {XML`RawXML["&#8960;"]}],
	"\[Diamond]" -> XMLElement["span",  {"class" -> "special-character Diamond"},  {XML`RawXML["&#8900;"]}],
	"\[DiamondSuit]" -> XMLElement["span",  {"class" -> "special-character DiamondSuit"},  {XML`RawXML["&#9826;"]}],
	"\[DifferenceDelta]" -> XMLElement["span",  {"class" -> "special-character DifferenceDelta"},  {XML`RawXML["&#62628;"]}],
	"\[DifferentialD]" -> XMLElement["span",  {"class" -> "special-character DifferentialD"},  {XML`RawXML["&#63308;"]}],
	"\[Digamma]" -> XMLElement["span",  {"class" -> "special-character Digamma"},  {XML`RawXML["&#989;"]}],
	"\[DirectedEdge]" -> XMLElement["span",  {"class" -> "special-character DirectedEdge"},  {XML`RawXML["&#62421;"]}],
	"\[DiscreteRatio]" -> XMLElement["span",  {"class" -> "special-character DiscreteRatio"},  {XML`RawXML["&#62629;"]}],
	"\[DiscreteShift]" -> XMLElement["span",  {"class" -> "special-character DiscreteShift"},  {XML`RawXML["&#62627;"]}],
	"\[DiscretionaryHyphen]" -> XMLElement["span",  {"class" -> "special-character DiscretionaryHyphen"},  {" "}],
	"\[DiscretionaryLineSeparator]" -> XMLElement["span",  {"class" -> "special-character DiscretionaryLineSeparator"},  {" "}],
	"\[DiscretionaryPageBreakAbove]" -> XMLElement["span",  {"class" -> "special-character DiscretionaryPageBreakAbove"},  {XML`RawXML["&#62399;"]}],
	"\[DiscretionaryPageBreakBelow]" -> XMLElement["span",  {"class" -> "special-character DiscretionaryPageBreakBelow"},  {XML`RawXML["&#62406;"]}],
	"\[DiscretionaryParagraphSeparator]" -> XMLElement["span",  {"class" -> "special-character DiscretionaryParagraphSeparator"},  {" "}],
	"\[Distributed]" -> XMLElement["span",  {"class" -> "special-character Distributed"},  {XML`RawXML["&#62418;"]}],
	"\[Divergence]" -> XMLElement["span",  {"class" -> "special-character Divergence"},  {XML`RawXML["&#62423;"]}],
	"\[Divide]" -> XMLElement["span",  {"class" -> "special-character Divide"},  {XML`RawXML["&#247;"]}],
	"\[Divides]" -> XMLElement["span",  {"class" -> "special-character Divides"},  {XML`RawXML["&#8739;"]}],
	"\[DivisionSlash]" -> XMLElement["span",  {"class" -> "special-character DivisionSlash"},  {XML`RawXML["&#8725;"]}],
	"\[DotEqual]" -> XMLElement["span",  {"class" -> "special-character DotEqual"},  {XML`RawXML["&#8784;"]}],
	"\[DotlessI]" -> XMLElement["span",  {"class" -> "special-character DotlessI"},  {XML`RawXML["&#305;"]}],
	"\[DotlessJ]" -> XMLElement["span",  {"class" -> "special-character DotlessJ"},  {XML`RawXML["&#63232;"]}],
	"\[DottedSquare]" -> XMLElement["span",  {"class" -> "special-character DottedSquare"},  {XML`RawXML["&#63313;"]}],
	"\[DoubleContourIntegral]" -> XMLElement["span",  {"class" -> "special-character DoubleContourIntegral"},  {XML`RawXML["&#8751;"]}],
	"\[DoubleDagger]" -> XMLElement["span",  {"class" -> "special-character DoubleDagger"},  {XML`RawXML["&#8225;"]}],
	"\[DoubledGamma]" -> XMLElement["span",  {"class" -> "special-character DoubledGamma"},  {XML`RawXML["&#63306;"]}],
	"\[DoubleDot]" -> XMLElement["span",  {"class" -> "special-character DoubleDot"},  {XML`RawXML["&#168;"]}],
	"\[DoubleDownArrow]" -> XMLElement["span",  {"class" -> "special-character DoubleDownArrow"},  {XML`RawXML["&#8659;"]}],
	"\[DoubledPi]" -> XMLElement["span",  {"class" -> "special-character DoubledPi"},  {XML`RawXML["&#63305;"]}],
	"\[DoubleLeftArrow]" -> XMLElement["span",  {"class" -> "special-character DoubleLeftArrow"},  {XML`RawXML["&#8656;"]}],
	"\[DoubleLeftRightArrow]" -> XMLElement["span",  {"class" -> "special-character DoubleLeftRightArrow"},  {XML`RawXML["&#8660;"]}],
	"\[DoubleLeftTee]" -> XMLElement["span",  {"class" -> "special-character DoubleLeftTee"},  {XML`RawXML["&#10980;"]}],
	"\[DoubleLongLeftArrow]" -> XMLElement["span",  {"class" -> "special-character DoubleLongLeftArrow"},  {XML`RawXML["&#10232;"]}],
	"\[DoubleLongLeftRightArrow]" -> XMLElement["span",  {"class" -> "special-character DoubleLongLeftRightArrow"},  {XML`RawXML["&#10234;"]}],
	"\[DoubleLongRightArrow]" -> XMLElement["span",  {"class" -> "special-character DoubleLongRightArrow"},  {XML`RawXML["&#10233;"]}],
	"\[DoublePrime]" -> XMLElement["span",  {"class" -> "special-character DoublePrime"},  {XML`RawXML["&#8243;"]}],
	"\[DoubleRightArrow]" -> XMLElement["span",  {"class" -> "special-character DoubleRightArrow"},  {XML`RawXML["&#8658;"]}],
	"\[DoubleRightTee]" -> XMLElement["span",  {"class" -> "special-character DoubleRightTee"},  {XML`RawXML["&#8872;"]}],
	"\[DoubleStruckA]" -> XMLElement["span",  {"class" -> "special-character DoubleStruckA"},  {XML`RawXML["&#63206;"]}],
	"\[DoubleStruckB]" -> XMLElement["span",  {"class" -> "special-character DoubleStruckB"},  {XML`RawXML["&#63207;"]}],
	"\[DoubleStruckC]" -> XMLElement["span",  {"class" -> "special-character DoubleStruckC"},  {XML`RawXML["&#63208;"]}],
	"\[DoubleStruckCapitalA]" -> XMLElement["span",  {"class" -> "special-character DoubleStruckCapitalA"},  {XML`RawXML["&#63396;"]}],
	"\[DoubleStruckCapitalB]" -> XMLElement["span",  {"class" -> "special-character DoubleStruckCapitalB"},  {XML`RawXML["&#63397;"]}],
	"\[DoubleStruckCapitalC]" -> XMLElement["span",  {"class" -> "special-character DoubleStruckCapitalC"},  {XML`RawXML["&#63398;"]}],
	"\[DoubleStruckCapitalD]" -> XMLElement["span",  {"class" -> "special-character DoubleStruckCapitalD"},  {XML`RawXML["&#63399;"]}],
	"\[DoubleStruckCapitalE]" -> XMLElement["span",  {"class" -> "special-character DoubleStruckCapitalE"},  {XML`RawXML["&#63400;"]}],
	"\[DoubleStruckCapitalF]" -> XMLElement["span",  {"class" -> "special-character DoubleStruckCapitalF"},  {XML`RawXML["&#63401;"]}],
	"\[DoubleStruckCapitalG]" -> XMLElement["span",  {"class" -> "special-character DoubleStruckCapitalG"},  {XML`RawXML["&#63402;"]}],
	"\[DoubleStruckCapitalH]" -> XMLElement["span",  {"class" -> "special-character DoubleStruckCapitalH"},  {XML`RawXML["&#63403;"]}],
	"\[DoubleStruckCapitalI]" -> XMLElement["span",  {"class" -> "special-character DoubleStruckCapitalI"},  {XML`RawXML["&#63404;"]}],
	"\[DoubleStruckCapitalJ]" -> XMLElement["span",  {"class" -> "special-character DoubleStruckCapitalJ"},  {XML`RawXML["&#63405;"]}],
	"\[DoubleStruckCapitalK]" -> XMLElement["span",  {"class" -> "special-character DoubleStruckCapitalK"},  {XML`RawXML["&#63406;"]}],
	"\[DoubleStruckCapitalL]" -> XMLElement["span",  {"class" -> "special-character DoubleStruckCapitalL"},  {XML`RawXML["&#63407;"]}],
	"\[DoubleStruckCapitalM]" -> XMLElement["span",  {"class" -> "special-character DoubleStruckCapitalM"},  {XML`RawXML["&#63408;"]}],
	"\[DoubleStruckCapitalN]" -> XMLElement["span",  {"class" -> "special-character DoubleStruckCapitalN"},  {XML`RawXML["&#63409;"]}],
	"\[DoubleStruckCapitalO]" -> XMLElement["span",  {"class" -> "special-character DoubleStruckCapitalO"},  {XML`RawXML["&#63410;"]}],
	"\[DoubleStruckCapitalP]" -> XMLElement["span",  {"class" -> "special-character DoubleStruckCapitalP"},  {XML`RawXML["&#63411;"]}],
	"\[DoubleStruckCapitalQ]" -> XMLElement["span",  {"class" -> "special-character DoubleStruckCapitalQ"},  {XML`RawXML["&#63412;"]}],
	"\[DoubleStruckCapitalR]" -> XMLElement["span",  {"class" -> "special-character DoubleStruckCapitalR"},  {XML`RawXML["&#63413;"]}],
	"\[DoubleStruckCapitalS]" -> XMLElement["span",  {"class" -> "special-character DoubleStruckCapitalS"},  {XML`RawXML["&#63414;"]}],
	"\[DoubleStruckCapitalT]" -> XMLElement["span",  {"class" -> "special-character DoubleStruckCapitalT"},  {XML`RawXML["&#63415;"]}],
	"\[DoubleStruckCapitalU]" -> XMLElement["span",  {"class" -> "special-character DoubleStruckCapitalU"},  {XML`RawXML["&#63416;"]}],
	"\[DoubleStruckCapitalV]" -> XMLElement["span",  {"class" -> "special-character DoubleStruckCapitalV"},  {XML`RawXML["&#63417;"]}],
	"\[DoubleStruckCapitalW]" -> XMLElement["span",  {"class" -> "special-character DoubleStruckCapitalW"},  {XML`RawXML["&#63418;"]}],
	"\[DoubleStruckCapitalX]" -> XMLElement["span",  {"class" -> "special-character DoubleStruckCapitalX"},  {XML`RawXML["&#63419;"]}],
	"\[DoubleStruckCapitalY]" -> XMLElement["span",  {"class" -> "special-character DoubleStruckCapitalY"},  {XML`RawXML["&#63420;"]}],
	"\[DoubleStruckCapitalZ]" -> XMLElement["span",  {"class" -> "special-character DoubleStruckCapitalZ"},  {XML`RawXML["&#63421;"]}],
	"\[DoubleStruckD]" -> XMLElement["span",  {"class" -> "special-character DoubleStruckD"},  {XML`RawXML["&#63209;"]}],
	"\[DoubleStruckE]" -> XMLElement["span",  {"class" -> "special-character DoubleStruckE"},  {XML`RawXML["&#63210;"]}],
	"\[DoubleStruckEight]" -> XMLElement["span",  {"class" -> "special-character DoubleStruckEight"},  {XML`RawXML["&#63459;"]}],
	"\[DoubleStruckF]" -> XMLElement["span",  {"class" -> "special-character DoubleStruckF"},  {XML`RawXML["&#63211;"]}],
	"\[DoubleStruckFive]" -> XMLElement["span",  {"class" -> "special-character DoubleStruckFive"},  {XML`RawXML["&#63456;"]}],
	"\[DoubleStruckFour]" -> XMLElement["span",  {"class" -> "special-character DoubleStruckFour"},  {XML`RawXML["&#63455;"]}],
	"\[DoubleStruckG]" -> XMLElement["span",  {"class" -> "special-character DoubleStruckG"},  {XML`RawXML["&#63212;"]}],
	"\[DoubleStruckH]" -> XMLElement["span",  {"class" -> "special-character DoubleStruckH"},  {XML`RawXML["&#63213;"]}],
	"\[DoubleStruckI]" -> XMLElement["span",  {"class" -> "special-character DoubleStruckI"},  {XML`RawXML["&#63214;"]}],
	"\[DoubleStruckJ]" -> XMLElement["span",  {"class" -> "special-character DoubleStruckJ"},  {XML`RawXML["&#63215;"]}],
	"\[DoubleStruckK]" -> XMLElement["span",  {"class" -> "special-character DoubleStruckK"},  {XML`RawXML["&#63216;"]}],
	"\[DoubleStruckL]" -> XMLElement["span",  {"class" -> "special-character DoubleStruckL"},  {XML`RawXML["&#63217;"]}],
	"\[DoubleStruckM]" -> XMLElement["span",  {"class" -> "special-character DoubleStruckM"},  {XML`RawXML["&#63218;"]}],
	"\[DoubleStruckN]" -> XMLElement["span",  {"class" -> "special-character DoubleStruckN"},  {XML`RawXML["&#63219;"]}],
	"\[DoubleStruckNine]" -> XMLElement["span",  {"class" -> "special-character DoubleStruckNine"},  {XML`RawXML["&#63460;"]}],
	"\[DoubleStruckO]" -> XMLElement["span",  {"class" -> "special-character DoubleStruckO"},  {XML`RawXML["&#63220;"]}],
	"\[DoubleStruckOne]" -> XMLElement["span",  {"class" -> "special-character DoubleStruckOne"},  {XML`RawXML["&#63452;"]}],
	"\[DoubleStruckP]" -> XMLElement["span",  {"class" -> "special-character DoubleStruckP"},  {XML`RawXML["&#63221;"]}],
	"\[DoubleStruckQ]" -> XMLElement["span",  {"class" -> "special-character DoubleStruckQ"},  {XML`RawXML["&#63222;"]}],
	"\[DoubleStruckR]" -> XMLElement["span",  {"class" -> "special-character DoubleStruckR"},  {XML`RawXML["&#63223;"]}],
	"\[DoubleStruckS]" -> XMLElement["span",  {"class" -> "special-character DoubleStruckS"},  {XML`RawXML["&#63224;"]}],
	"\[DoubleStruckSeven]" -> XMLElement["span",  {"class" -> "special-character DoubleStruckSeven"},  {XML`RawXML["&#63458;"]}],
	"\[DoubleStruckSix]" -> XMLElement["span",  {"class" -> "special-character DoubleStruckSix"},  {XML`RawXML["&#63457;"]}],
	"\[DoubleStruckT]" -> XMLElement["span",  {"class" -> "special-character DoubleStruckT"},  {XML`RawXML["&#63225;"]}],
	"\[DoubleStruckThree]" -> XMLElement["span",  {"class" -> "special-character DoubleStruckThree"},  {XML`RawXML["&#63454;"]}],
	"\[DoubleStruckTwo]" -> XMLElement["span",  {"class" -> "special-character DoubleStruckTwo"},  {XML`RawXML["&#63453;"]}],
	"\[DoubleStruckU]" -> XMLElement["span",  {"class" -> "special-character DoubleStruckU"},  {XML`RawXML["&#63226;"]}],
	"\[DoubleStruckV]" -> XMLElement["span",  {"class" -> "special-character DoubleStruckV"},  {XML`RawXML["&#63227;"]}],
	"\[DoubleStruckW]" -> XMLElement["span",  {"class" -> "special-character DoubleStruckW"},  {XML`RawXML["&#63228;"]}],
	"\[DoubleStruckX]" -> XMLElement["span",  {"class" -> "special-character DoubleStruckX"},  {XML`RawXML["&#63229;"]}],
	"\[DoubleStruckY]" -> XMLElement["span",  {"class" -> "special-character DoubleStruckY"},  {XML`RawXML["&#63230;"]}],
	"\[DoubleStruckZ]" -> XMLElement["span",  {"class" -> "special-character DoubleStruckZ"},  {XML`RawXML["&#63231;"]}],
	"\[DoubleStruckZero]" -> XMLElement["span",  {"class" -> "special-character DoubleStruckZero"},  {XML`RawXML["&#63451;"]}],
	"\[DoubleUpArrow]" -> XMLElement["span",  {"class" -> "special-character DoubleUpArrow"},  {XML`RawXML["&#8657;"]}],
	"\[DoubleUpDownArrow]" -> XMLElement["span",  {"class" -> "special-character DoubleUpDownArrow"},  {XML`RawXML["&#8661;"]}],
	"\[DoubleVerticalBar]" -> XMLElement["span",  {"class" -> "special-character DoubleVerticalBar"},  {XML`RawXML["&#8741;"]}],
	"\[DownArrow]" -> XMLElement["span",  {"class" -> "special-character DownArrow"},  {XML`RawXML["&#8595;"]}],
	"\[DownArrowBar]" -> XMLElement["span",  {"class" -> "special-character DownArrowBar"},  {XML`RawXML["&#10515;"]}],
	"\[DownArrowUpArrow]" -> XMLElement["span",  {"class" -> "special-character DownArrowUpArrow"},  {XML`RawXML["&#8693;"]}],
	"\[DownBreve]" -> XMLElement["span",  {"class" -> "special-character DownBreve"},  {XML`RawXML["&#63317;"]}],
	"\[DownExclamation]" -> XMLElement["span",  {"class" -> "special-character DownExclamation"},  {XML`RawXML["&#161;"]}],
	"\[DownLeftRightVector]" -> XMLElement["span",  {"class" -> "special-character DownLeftRightVector"},  {XML`RawXML["&#10576;"]}],
	"\[DownLeftTeeVector]" -> XMLElement["span",  {"class" -> "special-character DownLeftTeeVector"},  {XML`RawXML["&#10590;"]}],
	"\[DownLeftVector]" -> XMLElement["span",  {"class" -> "special-character DownLeftVector"},  {XML`RawXML["&#8637;"]}],
	"\[DownLeftVectorBar]" -> XMLElement["span",  {"class" -> "special-character DownLeftVectorBar"},  {XML`RawXML["&#10582;"]}],
	"\[DownPointer]" -> XMLElement["span",  {"class" -> "special-character DownPointer"},  {XML`RawXML["&#9662;"]}],
	"\[DownQuestion]" -> XMLElement["span",  {"class" -> "special-character DownQuestion"},  {XML`RawXML["&#191;"]}],
	"\[DownRightTeeVector]" -> XMLElement["span",  {"class" -> "special-character DownRightTeeVector"},  {XML`RawXML["&#10591;"]}],
	"\[DownRightVector]" -> XMLElement["span",  {"class" -> "special-character DownRightVector"},  {XML`RawXML["&#8641;"]}],
	"\[DownRightVectorBar]" -> XMLElement["span",  {"class" -> "special-character DownRightVectorBar"},  {XML`RawXML["&#10583;"]}],
	"\[DownTee]" -> XMLElement["span",  {"class" -> "special-character DownTee"},  {XML`RawXML["&#8868;"]}],
	"\[DownTeeArrow]" -> XMLElement["span",  {"class" -> "special-character DownTeeArrow"},  {XML`RawXML["&#8615;"]}],
	"\[EAcute]" -> XMLElement["span",  {"class" -> "special-character EAcute"},  {XML`RawXML["&#233;"]}],
	"\[Earth]" -> XMLElement["span",  {"class" -> "special-character Earth"},  {XML`RawXML["&#62431;"]}],
	"\[EBar]" -> XMLElement["span",  {"class" -> "special-character EBar"},  {XML`RawXML["&#275;"]}],
	"\[ECup]" -> XMLElement["span",  {"class" -> "special-character ECup"},  {XML`RawXML["&#277;"]}],
	"\[EDoubleDot]" -> XMLElement["span",  {"class" -> "special-character EDoubleDot"},  {XML`RawXML["&#235;"]}],
	"\[EGrave]" -> XMLElement["span",  {"class" -> "special-character EGrave"},  {XML`RawXML["&#232;"]}],
	"\[EHacek]" -> XMLElement["span",  {"class" -> "special-character EHacek"},  {XML`RawXML["&#283;"]}],
	"\[EHat]" -> XMLElement["span",  {"class" -> "special-character EHat"},  {XML`RawXML["&#234;"]}],
	"\[EighthNote]" -> XMLElement["span",  {"class" -> "special-character EighthNote"},  {XML`RawXML["&#9834;"]}],
	"\[Element]" -> XMLElement["span",  {"class" -> "special-character Element"},  {XML`RawXML["&#8712;"]}],
	"\[Ellipsis]" -> XMLElement["span",  {"class" -> "special-character Ellipsis"},  {XML`RawXML["&#8230;"]}],
	"\[EmptyCircle]" -> XMLElement["span",  {"class" -> "special-character EmptyCircle"},  {XML`RawXML["&#9675;"]}],
	"\[EmptyDiamond]" -> XMLElement["span",  {"class" -> "special-character EmptyDiamond"},  {XML`RawXML["&#9671;"]}],
	"\[EmptyDownTriangle]" -> XMLElement["span",  {"class" -> "special-character EmptyDownTriangle"},  {XML`RawXML["&#9661;"]}],
	"\[EmptyRectangle]" -> XMLElement["span",  {"class" -> "special-character EmptyRectangle"},  {XML`RawXML["&#9647;"]}],
	"\[EmptySet]" -> XMLElement["span",  {"class" -> "special-character EmptySet"},  {XML`RawXML["&#8709;"]}],
	"\[EmptySmallCircle]" -> XMLElement["span",  {"class" -> "special-character EmptySmallCircle"},  {XML`RawXML["&#9702;"]}],
	"\[EmptySmallSquare]" -> XMLElement["span",  {"class" -> "special-character EmptySmallSquare"},  {XML`RawXML["&#9723;"]}],
	"\[EmptySquare]" -> XMLElement["span",  {"class" -> "special-character EmptySquare"},  {XML`RawXML["&#9633;"]}],
	"\[EmptyUpTriangle]" -> XMLElement["span",  {"class" -> "special-character EmptyUpTriangle"},  {XML`RawXML["&#9651;"]}],
	"\[EmptyVerySmallSquare]" -> XMLElement["span",  {"class" -> "special-character EmptyVerySmallSquare"},  {XML`RawXML["&#9643;"]}],
	"\[EnterKey]" -> XMLElement["span",  {"class" -> "special-character EnterKey"},  {XML`RawXML["&#63444;"]}],
	"\[EntityEnd]" -> XMLElement["span",  {"class" -> "special-character EntityEnd"},  {XML`RawXML["&#62393;"]}],
	"\[EntityStart]" -> XMLElement["span",  {"class" -> "special-character EntityStart"},  {XML`RawXML["&#62392;"]}],
	"\[Epsilon]" -> XMLElement["span",  {"class" -> "special-character Epsilon"},  {XML`RawXML["&#1013;"]}],
	"\[Equal]" -> XMLElement["span",  {"class" -> "special-character Equal"},  {XML`RawXML["&#62513;"]}],
	"\[EqualTilde]" -> XMLElement["span",  {"class" -> "special-character EqualTilde"},  {XML`RawXML["&#8770;"]}],
	"\[Equilibrium]" -> XMLElement["span",  {"class" -> "special-character Equilibrium"},  {XML`RawXML["&#8652;"]}],
	"\[Equivalent]" -> XMLElement["span",  {"class" -> "special-character Equivalent"},  {XML`RawXML["&#10726;"]}],
	"\[ErrorIndicator]" -> XMLElement["span",  {"class" -> "special-character ErrorIndicator"},  {XML`RawXML["&#63335;"]}],
	"\[EscapeKey]" -> XMLElement["span",  {"class" -> "special-character EscapeKey"},  {XML`RawXML["&#63337;"]}],
	"\[Eta]" -> XMLElement["span",  {"class" -> "special-character Eta"},  {XML`RawXML["&#951;"]}],
	"\[Eth]" -> XMLElement["span",  {"class" -> "special-character Eth"},  {XML`RawXML["&#240;"]}],
	"\[Euro]" -> XMLElement["span",  {"class" -> "special-character Euro"},  {XML`RawXML["&#8364;"]}],
	"\[Exists]" -> XMLElement["span",  {"class" -> "special-character Exists"},  {XML`RawXML["&#8707;"]}],
	"\[ExpectationE]" -> XMLElement["span",  {"class" -> "special-character ExpectationE"},  {XML`RawXML["&#62429;"]}],
	"\[ExponentialE]" -> XMLElement["span",  {"class" -> "special-character ExponentialE"},  {XML`RawXML["&#63309;"]}],
	"\[FiLigature]" -> XMLElement["span",  {"class" -> "special-character FiLigature"},  {XML`RawXML["&#64257;"]}],
	"\[FilledCircle]" -> XMLElement["span",  {"class" -> "special-character FilledCircle"},  {XML`RawXML["&#9679;"]}],
	"\[FilledDiamond]" -> XMLElement["span",  {"class" -> "special-character FilledDiamond"},  {XML`RawXML["&#9670;"]}],
	"\[FilledDownTriangle]" -> XMLElement["span",  {"class" -> "special-character FilledDownTriangle"},  {XML`RawXML["&#9660;"]}],
	"\[FilledLeftTriangle]" -> XMLElement["span",  {"class" -> "special-character FilledLeftTriangle"},  {XML`RawXML["&#9664;"]}],
	"\[FilledRectangle]" -> XMLElement["span",  {"class" -> "special-character FilledRectangle"},  {XML`RawXML["&#9646;"]}],
	"\[FilledRightTriangle]" -> XMLElement["span",  {"class" -> "special-character FilledRightTriangle"},  {XML`RawXML["&#9654;"]}],
	"\[FilledSmallCircle]" -> XMLElement["span",  {"class" -> "special-character FilledSmallCircle"},  {XML`RawXML["&#63312;"]}],
	"\[FilledSmallSquare]" -> XMLElement["span",  {"class" -> "special-character FilledSmallSquare"},  {XML`RawXML["&#9632;"]}],
	"\[FilledSquare]" -> XMLElement["span",  {"class" -> "special-character FilledSquare"},  {XML`RawXML["&#9632;"]}],
	"\[FilledUpTriangle]" -> XMLElement["span",  {"class" -> "special-character FilledUpTriangle"},  {XML`RawXML["&#9650;"]}],
	"\[FilledVerySmallSquare]" -> XMLElement["span",  {"class" -> "special-character FilledVerySmallSquare"},  {XML`RawXML["&#9642;"]}],
	"\[FinalSigma]" -> XMLElement["span",  {"class" -> "special-character FinalSigma"},  {XML`RawXML["&#962;"]}],
	"\[FirstPage]" -> XMLElement["span",  {"class" -> "special-character FirstPage"},  {XML`RawXML["&#63482;"]}],
	"\[FivePointedStar]" -> XMLElement["span",  {"class" -> "special-character FivePointedStar"},  {XML`RawXML["&#9733;"]}],
	"\[Flat]" -> XMLElement["span",  {"class" -> "special-character Flat"},  {XML`RawXML["&#9837;"]}],
	"\[FlLigature]" -> XMLElement["span",  {"class" -> "special-character FlLigature"},  {XML`RawXML["&#64258;"]}],
	"\[Florin]" -> XMLElement["span",  {"class" -> "special-character Florin"},  {XML`RawXML["&#402;"]}],
	"\[ForAll]" -> XMLElement["span",  {"class" -> "special-character ForAll"},  {XML`RawXML["&#8704;"]}],
	"\[FormalA]" -> XMLElement["span",  {"class" -> "special-character formalcharacter FormalA"},  {"a"}],
	"\[FormalAlpha]" -> XMLElement["span",  {"class" -> "special-character formalcharacter FormalAlpha"},  {XML`RawXML["&#945;"]}],
	"\[FormalB]" -> XMLElement["span",  {"class" -> "special-character formalcharacter FormalB"},  {"b"}],
	"\[FormalBeta]" -> XMLElement["span",  {"class" -> "special-character formalcharacter FormalBeta"},  {XML`RawXML["&#946;"]}],
	"\[FormalC]" -> XMLElement["span",  {"class" -> "special-character formalcharacter FormalC"},  {"c"}],
	"\[FormalCapitalA]" -> XMLElement["span",  {"class" -> "special-character formalcharacter FormalCapitalA"},  {"A"}],
	"\[FormalCapitalAlpha]" -> XMLElement["span",  {"class" -> "special-character formalcharacter FormalCapitalAlpha"},  {XML`RawXML["&#913;"]}],
	"\[FormalCapitalB]" -> XMLElement["span",  {"class" -> "special-character formalcharacter FormalCapitalB"},  {"B"}],
	"\[FormalCapitalBeta]" -> XMLElement["span",  {"class" -> "special-character formalcharacter FormalCapitalBeta"},  {XML`RawXML["&#914;"]}],
	"\[FormalCapitalC]" -> XMLElement["span",  {"class" -> "special-character formalcharacter FormalCapitalC"},  {"C"}],
	"\[FormalCapitalChi]" -> XMLElement["span",  {"class" -> "special-character formalcharacter FormalCapitalChi"},  {XML`RawXML["&#935;"]}],
	"\[FormalCapitalD]" -> XMLElement["span",  {"class" -> "special-character formalcharacter FormalCapitalD"},  {"D"}],
	"\[FormalCapitalDelta]" -> XMLElement["span",  {"class" -> "special-character formalcharacter FormalCapitalDelta"},  {XML`RawXML["&#916;"]}],
	"\[FormalCapitalDigamma]" -> XMLElement["span",  {"class" -> "special-character formalcharacter FormalCapitalDigamma"},  {XML`RawXML["&#988;"]}],
	"\[FormalCapitalE]" -> XMLElement["span",  {"class" -> "special-character formalcharacter FormalCapitalE"},  {"E"}],
	"\[FormalCapitalEpsilon]" -> XMLElement["span",  {"class" -> "special-character formalcharacter FormalCapitalEpsilon"},  {XML`RawXML["&#917;"]}],
	"\[FormalCapitalEta]" -> XMLElement["span",  {"class" -> "special-character formalcharacter FormalCapitalEta"},  {XML`RawXML["&#919;"]}],
	"\[FormalCapitalF]" -> XMLElement["span",  {"class" -> "special-character formalcharacter FormalCapitalF"},  {"F"}],
	"\[FormalCapitalG]" -> XMLElement["span",  {"class" -> "special-character formalcharacter FormalCapitalG"},  {"G"}],
	"\[FormalCapitalGamma]" -> XMLElement["span",  {"class" -> "special-character formalcharacter FormalCapitalGamma"},  {XML`RawXML["&#915;"]}],
	"\[FormalCapitalH]" -> XMLElement["span",  {"class" -> "special-character formalcharacter FormalCapitalH"},  {"H"}],
	"\[FormalCapitalI]" -> XMLElement["span",  {"class" -> "special-character formalcharacter FormalCapitalI"},  {"I"}],
	"\[FormalCapitalIota]" -> XMLElement["span",  {"class" -> "special-character formalcharacter FormalCapitalIota"},  {XML`RawXML["&#921;"]}],
	"\[FormalCapitalJ]" -> XMLElement["span",  {"class" -> "special-character formalcharacter FormalCapitalJ"},  {"J"}],
	"\[FormalCapitalK]" -> XMLElement["span",  {"class" -> "special-character formalcharacter FormalCapitalK"},  {"K"}],
	"\[FormalCapitalKappa]" -> XMLElement["span",  {"class" -> "special-character formalcharacter FormalCapitalKappa"},  {XML`RawXML["&#922;"]}],
	"\[FormalCapitalKoppa]" -> XMLElement["span",  {"class" -> "special-character formalcharacter FormalCapitalKoppa"},  {XML`RawXML["&#990;"]}],
	"\[FormalCapitalL]" -> XMLElement["span",  {"class" -> "special-character formalcharacter FormalCapitalL"},  {"L"}],
	"\[FormalCapitalLambda]" -> XMLElement["span",  {"class" -> "special-character formalcharacter FormalCapitalLambda"},  {XML`RawXML["&#923;"]}],
	"\[FormalCapitalM]" -> XMLElement["span",  {"class" -> "special-character formalcharacter FormalCapitalM"},  {"M"}],
	"\[FormalCapitalMu]" -> XMLElement["span",  {"class" -> "special-character formalcharacter FormalCapitalMu"},  {XML`RawXML["&#924;"]}],
	"\[FormalCapitalN]" -> XMLElement["span",  {"class" -> "special-character formalcharacter FormalCapitalN"},  {"N"}],
	"\[FormalCapitalNu]" -> XMLElement["span",  {"class" -> "special-character formalcharacter FormalCapitalNu"},  {XML`RawXML["&#925;"]}],
	"\[FormalCapitalO]" -> XMLElement["span",  {"class" -> "special-character formalcharacter FormalCapitalO"},  {"O"}],
	"\[FormalCapitalOmega]" -> XMLElement["span",  {"class" -> "special-character formalcharacter FormalCapitalOmega"},  {XML`RawXML["&#937;"]}],
	"\[FormalCapitalOmicron]" -> XMLElement["span",  {"class" -> "special-character formalcharacter FormalCapitalOmicron"},  {XML`RawXML["&#927;"]}],
	"\[FormalCapitalP]" -> XMLElement["span",  {"class" -> "special-character formalcharacter FormalCapitalP"},  {"P"}],
	"\[FormalCapitalPhi]" -> XMLElement["span",  {"class" -> "special-character formalcharacter FormalCapitalPhi"},  {XML`RawXML["&#934;"]}],
	"\[FormalCapitalPi]" -> XMLElement["span",  {"class" -> "special-character formalcharacter FormalCapitalPi"},  {XML`RawXML["&#928;"]}],
	"\[FormalCapitalPsi]" -> XMLElement["span",  {"class" -> "special-character formalcharacter FormalCapitalPsi"},  {XML`RawXML["&#936;"]}],
	"\[FormalCapitalQ]" -> XMLElement["span",  {"class" -> "special-character formalcharacter FormalCapitalQ"},  {"Q"}],
	"\[FormalCapitalR]" -> XMLElement["span",  {"class" -> "special-character formalcharacter FormalCapitalR"},  {"R"}],
	"\[FormalCapitalRho]" -> XMLElement["span",  {"class" -> "special-character formalcharacter FormalCapitalRho"},  {XML`RawXML["&#929;"]}],
	"\[FormalCapitalS]" -> XMLElement["span",  {"class" -> "special-character formalcharacter FormalCapitalS"},  {"S"}],
	"\[FormalCapitalSampi]" -> XMLElement["span",  {"class" -> "special-character formalcharacter FormalCapitalSampi"},  {XML`RawXML["&#992;"]}],
	"\[FormalCapitalSigma]" -> XMLElement["span",  {"class" -> "special-character formalcharacter FormalCapitalSigma"},  {XML`RawXML["&#931;"]}],
	"\[FormalCapitalStigma]" -> XMLElement["span",  {"class" -> "special-character formalcharacter FormalCapitalStigma"},  {XML`RawXML["&#986;"]}],
	"\[FormalCapitalT]" -> XMLElement["span",  {"class" -> "special-character formalcharacter FormalCapitalT"},  {"T"}],
	"\[FormalCapitalTau]" -> XMLElement["span",  {"class" -> "special-character formalcharacter FormalCapitalTau"},  {XML`RawXML["&#932;"]}],
	"\[FormalCapitalTheta]" -> XMLElement["span",  {"class" -> "special-character formalcharacter FormalCapitalTheta"},  {XML`RawXML["&#920;"]}],
	"\[FormalCapitalU]" -> XMLElement["span",  {"class" -> "special-character formalcharacter FormalCapitalU"},  {"U"}],
	"\[FormalCapitalUpsilon]" -> XMLElement["span",  {"class" -> "special-character formalcharacter FormalCapitalUpsilon"},  {XML`RawXML["&#933;"]}],
	"\[FormalCapitalV]" -> XMLElement["span",  {"class" -> "special-character formalcharacter FormalCapitalV"},  {"V"}],
	"\[FormalCapitalW]" -> XMLElement["span",  {"class" -> "special-character formalcharacter FormalCapitalW"},  {"W"}],
	"\[FormalCapitalX]" -> XMLElement["span",  {"class" -> "special-character formalcharacter FormalCapitalX"},  {"X"}],
	"\[FormalCapitalXi]" -> XMLElement["span",  {"class" -> "special-character formalcharacter FormalCapitalXi"},  {XML`RawXML["&#926;"]}],
	"\[FormalCapitalY]" -> XMLElement["span",  {"class" -> "special-character formalcharacter FormalCapitalY"},  {"Y"}],
	"\[FormalCapitalZ]" -> XMLElement["span",  {"class" -> "special-character formalcharacter FormalCapitalZ"},  {"Z"}],
	"\[FormalCapitalZeta]" -> XMLElement["span",  {"class" -> "special-character formalcharacter FormalCapitalZeta"},  {XML`RawXML["&#918;"]}],
	"\[FormalChi]" -> XMLElement["span",  {"class" -> "special-character formalcharacter FormalChi"},  {XML`RawXML["&#967;"]}],
	"\[FormalCurlyCapitalUpsilon]" -> XMLElement["span",  {"class" -> "special-character formalcharacter FormalCurlyCapitalUpsilon"},  {XML`RawXML["&#978;"]}],
	"\[FormalCurlyEpsilon]" -> XMLElement["span",  {"class" -> "special-character formalcharacter FormalCurlyEpsilon"},  {XML`RawXML["&#949;"]}],
	"\[FormalCurlyKappa]" -> XMLElement["span",  {"class" -> "special-character formalcharacter FormalCurlyKappa"},  {XML`RawXML["&#1008;"]}],
	"\[FormalCurlyPhi]" -> XMLElement["span",  {"class" -> "special-character formalcharacter FormalCurlyPhi"},  {XML`RawXML["&#966;"]}],
	"\[FormalCurlyPi]" -> XMLElement["span",  {"class" -> "special-character formalcharacter FormalCurlyPi"},  {XML`RawXML["&#982;"]}],
	"\[FormalCurlyRho]" -> XMLElement["span",  {"class" -> "special-character formalcharacter FormalCurlyRho"},  {XML`RawXML["&#1009;"]}],
	"\[FormalCurlyTheta]" -> XMLElement["span",  {"class" -> "special-character formalcharacter FormalCurlyTheta"},  {XML`RawXML["&#977;"]}],
	"\[FormalD]" -> XMLElement["span",  {"class" -> "special-character formalcharacter FormalD"},  {"d"}],
	"\[FormalDelta]" -> XMLElement["span",  {"class" -> "special-character formalcharacter FormalDelta"},  {XML`RawXML["&#948;"]}],
	"\[FormalDigamma]" -> XMLElement["span",  {"class" -> "special-character formalcharacter FormalDigamma"},  {XML`RawXML["&#989;"]}],
	"\[FormalE]" -> XMLElement["span",  {"class" -> "special-character formalcharacter FormalE"},  {"e"}],
	"\[FormalEpsilon]" -> XMLElement["span",  {"class" -> "special-character formalcharacter FormalEpsilon"},  {XML`RawXML["&#1013;"]}],
	"\[FormalEta]" -> XMLElement["span",  {"class" -> "special-character formalcharacter FormalEta"},  {XML`RawXML["&#951;"]}],
	"\[FormalF]" -> XMLElement["span",  {"class" -> "special-character formalcharacter FormalF"},  {"f"}],
	"\[FormalFinalSigma]" -> XMLElement["span",  {"class" -> "special-character formalcharacter FormalFinalSigma"},  {XML`RawXML["&#962;"]}],
	"\[FormalG]" -> XMLElement["span",  {"class" -> "special-character formalcharacter FormalG"},  {"g"}],
	"\[FormalGamma]" -> XMLElement["span",  {"class" -> "special-character formalcharacter FormalGamma"},  {XML`RawXML["&#947;"]}],
	"\[FormalH]" -> XMLElement["span",  {"class" -> "special-character formalcharacter FormalH"},  {"h"}],
	"\[FormalI]" -> XMLElement["span",  {"class" -> "special-character formalcharacter FormalI"},  {"i"}],
	"\[FormalIota]" -> XMLElement["span",  {"class" -> "special-character formalcharacter FormalIota"},  {XML`RawXML["&#953;"]}],
	"\[FormalJ]" -> XMLElement["span",  {"class" -> "special-character formalcharacter FormalJ"},  {"j"}],
	"\[FormalK]" -> XMLElement["span",  {"class" -> "special-character formalcharacter FormalK"},  {"k"}],
	"\[FormalKappa]" -> XMLElement["span",  {"class" -> "special-character formalcharacter FormalKappa"},  {XML`RawXML["&#954;"]}],
	"\[FormalKoppa]" -> XMLElement["span",  {"class" -> "special-character formalcharacter FormalKoppa"},  {XML`RawXML["&#991;"]}],
	"\[FormalL]" -> XMLElement["span",  {"class" -> "special-character formalcharacter FormalL"},  {"l"}],
	"\[FormalLambda]" -> XMLElement["span",  {"class" -> "special-character formalcharacter FormalLambda"},  {XML`RawXML["&#955;"]}],
	"\[FormalM]" -> XMLElement["span",  {"class" -> "special-character formalcharacter FormalM"},  {"m"}],
	"\[FormalMu]" -> XMLElement["span",  {"class" -> "special-character formalcharacter FormalMu"},  {XML`RawXML["&#956;"]}],
	"\[FormalN]" -> XMLElement["span",  {"class" -> "special-character formalcharacter FormalN"},  {"n"}],
	"\[FormalNu]" -> XMLElement["span",  {"class" -> "special-character formalcharacter FormalNu"},  {XML`RawXML["&#957;"]}],
	"\[FormalO]" -> XMLElement["span",  {"class" -> "special-character formalcharacter FormalO"},  {"o"}],
	"\[FormalOmega]" -> XMLElement["span",  {"class" -> "special-character formalcharacter FormalOmega"},  {XML`RawXML["&#969;"]}],
	"\[FormalOmicron]" -> XMLElement["span",  {"class" -> "special-character formalcharacter FormalOmicron"},  {XML`RawXML["&#959;"]}],
	"\[FormalP]" -> XMLElement["span",  {"class" -> "special-character formalcharacter FormalP"},  {"p"}],
	"\[FormalPhi]" -> XMLElement["span",  {"class" -> "special-character formalcharacter FormalPhi"},  {XML`RawXML["&#981;"]}],
	"\[FormalPi]" -> XMLElement["span",  {"class" -> "special-character formalcharacter FormalPi"},  {XML`RawXML["&#960;"]}],
	"\[FormalPsi]" -> XMLElement["span",  {"class" -> "special-character formalcharacter FormalPsi"},  {XML`RawXML["&#968;"]}],
	"\[FormalQ]" -> XMLElement["span",  {"class" -> "special-character formalcharacter FormalQ"},  {"q"}],
	"\[FormalR]" -> XMLElement["span",  {"class" -> "special-character formalcharacter FormalR"},  {"r"}],
	"\[FormalRho]" -> XMLElement["span",  {"class" -> "special-character formalcharacter FormalRho"},  {XML`RawXML["&#961;"]}],
	"\[FormalS]" -> XMLElement["span",  {"class" -> "special-character formalcharacter FormalS"},  {"s"}],
	"\[FormalSampi]" -> XMLElement["span",  {"class" -> "special-character formalcharacter FormalSampi"},  {XML`RawXML["&#993;"]}],
	"\[FormalSigma]" -> XMLElement["span",  {"class" -> "special-character formalcharacter FormalSigma"},  {XML`RawXML["&#963;"]}],
	"\[FormalStigma]" -> XMLElement["span",  {"class" -> "special-character formalcharacter FormalStigma"},  {XML`RawXML["&#987;"]}],
	"\[FormalT]" -> XMLElement["span",  {"class" -> "special-character formalcharacter FormalT"},  {"t"}],
	"\[FormalTau]" -> XMLElement["span",  {"class" -> "special-character formalcharacter FormalTau"},  {XML`RawXML["&#964;"]}],
	"\[FormalTheta]" -> XMLElement["span",  {"class" -> "special-character formalcharacter FormalTheta"},  {XML`RawXML["&#952;"]}],
	"\[FormalU]" -> XMLElement["span",  {"class" -> "special-character formalcharacter FormalU"},  {"u"}],
	"\[FormalUpsilon]" -> XMLElement["span",  {"class" -> "special-character formalcharacter FormalUpsilon"},  {XML`RawXML["&#965;"]}],
	"\[FormalV]" -> XMLElement["span",  {"class" -> "special-character formalcharacter FormalV"},  {"v"}],
	"\[FormalW]" -> XMLElement["span",  {"class" -> "special-character formalcharacter FormalW"},  {"w"}],
	"\[FormalX]" -> XMLElement["span",  {"class" -> "special-character formalcharacter FormalX"},  {"x"}],
	"\[FormalXi]" -> XMLElement["span",  {"class" -> "special-character formalcharacter FormalXi"},  {XML`RawXML["&#958;"]}],
	"\[FormalY]" -> XMLElement["span",  {"class" -> "special-character formalcharacter FormalY"},  {"y"}],
	"\[FormalZ]" -> XMLElement["span",  {"class" -> "special-character formalcharacter FormalZ"},  {"z"}],
	"\[FormalZeta]" -> XMLElement["span",  {"class" -> "special-character formalcharacter FormalZeta"},  {XML`RawXML["&#950;"]}],
	"\[FreakedSmiley]" -> XMLElement["span",  {"class" -> "special-character FreakedSmiley"},  {XML`RawXML["&#63265;"]}],
	"\[Function]" -> XMLElement["span",  {"class" -> "special-character Function"},  {XML`RawXML["&#62625;"]}],
	"\[Gamma]" -> XMLElement["span",  {"class" -> "special-character Gamma"},  {XML`RawXML["&#947;"]}],
	"\[GeminiSign]" -> XMLElement["span",  {"class" -> "special-character GeminiSign"},  {XML`RawXML["&#9802;"]}],
	"\[Gimel]" -> XMLElement["span",  {"class" -> "special-character Gimel"},  {XML`RawXML["&#8503;"]}],
	"\[GothicA]" -> XMLElement["span",  {"class" -> "special-character GothicA"},  {XML`RawXML["&#63180;"]}],
	"\[GothicB]" -> XMLElement["span",  {"class" -> "special-character GothicB"},  {XML`RawXML["&#63181;"]}],
	"\[GothicC]" -> XMLElement["span",  {"class" -> "special-character GothicC"},  {XML`RawXML["&#63182;"]}],
	"\[GothicCapitalA]" -> XMLElement["span",  {"class" -> "special-character GothicCapitalA"},  {XML`RawXML["&#63370;"]}],
	"\[GothicCapitalB]" -> XMLElement["span",  {"class" -> "special-character GothicCapitalB"},  {XML`RawXML["&#63371;"]}],
	"\[GothicCapitalC]" -> XMLElement["span",  {"class" -> "special-character GothicCapitalC"},  {XML`RawXML["&#8493;"]}],
	"\[GothicCapitalD]" -> XMLElement["span",  {"class" -> "special-character GothicCapitalD"},  {XML`RawXML["&#63373;"]}],
	"\[GothicCapitalE]" -> XMLElement["span",  {"class" -> "special-character GothicCapitalE"},  {XML`RawXML["&#63374;"]}],
	"\[GothicCapitalF]" -> XMLElement["span",  {"class" -> "special-character GothicCapitalF"},  {XML`RawXML["&#63375;"]}],
	"\[GothicCapitalG]" -> XMLElement["span",  {"class" -> "special-character GothicCapitalG"},  {XML`RawXML["&#63376;"]}],
	"\[GothicCapitalH]" -> XMLElement["span",  {"class" -> "special-character GothicCapitalH"},  {XML`RawXML["&#8460;"]}],
	"\[GothicCapitalI]" -> XMLElement["span",  {"class" -> "special-character GothicCapitalI"},  {XML`RawXML["&#8465;"]}],
	"\[GothicCapitalJ]" -> XMLElement["span",  {"class" -> "special-character GothicCapitalJ"},  {XML`RawXML["&#63379;"]}],
	"\[GothicCapitalK]" -> XMLElement["span",  {"class" -> "special-character GothicCapitalK"},  {XML`RawXML["&#63380;"]}],
	"\[GothicCapitalL]" -> XMLElement["span",  {"class" -> "special-character GothicCapitalL"},  {XML`RawXML["&#63381;"]}],
	"\[GothicCapitalM]" -> XMLElement["span",  {"class" -> "special-character GothicCapitalM"},  {XML`RawXML["&#63382;"]}],
	"\[GothicCapitalN]" -> XMLElement["span",  {"class" -> "special-character GothicCapitalN"},  {XML`RawXML["&#63383;"]}],
	"\[GothicCapitalO]" -> XMLElement["span",  {"class" -> "special-character GothicCapitalO"},  {XML`RawXML["&#63384;"]}],
	"\[GothicCapitalP]" -> XMLElement["span",  {"class" -> "special-character GothicCapitalP"},  {XML`RawXML["&#63385;"]}],
	"\[GothicCapitalQ]" -> XMLElement["span",  {"class" -> "special-character GothicCapitalQ"},  {XML`RawXML["&#63386;"]}],
	"\[GothicCapitalR]" -> XMLElement["span",  {"class" -> "special-character GothicCapitalR"},  {XML`RawXML["&#8476;"]}],
	"\[GothicCapitalS]" -> XMLElement["span",  {"class" -> "special-character GothicCapitalS"},  {XML`RawXML["&#63388;"]}],
	"\[GothicCapitalT]" -> XMLElement["span",  {"class" -> "special-character GothicCapitalT"},  {XML`RawXML["&#63389;"]}],
	"\[GothicCapitalU]" -> XMLElement["span",  {"class" -> "special-character GothicCapitalU"},  {XML`RawXML["&#63390;"]}],
	"\[GothicCapitalV]" -> XMLElement["span",  {"class" -> "special-character GothicCapitalV"},  {XML`RawXML["&#63391;"]}],
	"\[GothicCapitalW]" -> XMLElement["span",  {"class" -> "special-character GothicCapitalW"},  {XML`RawXML["&#63392;"]}],
	"\[GothicCapitalX]" -> XMLElement["span",  {"class" -> "special-character GothicCapitalX"},  {XML`RawXML["&#63393;"]}],
	"\[GothicCapitalY]" -> XMLElement["span",  {"class" -> "special-character GothicCapitalY"},  {XML`RawXML["&#63394;"]}],
	"\[GothicCapitalZ]" -> XMLElement["span",  {"class" -> "special-character GothicCapitalZ"},  {XML`RawXML["&#8488;"]}],
	"\[GothicD]" -> XMLElement["span",  {"class" -> "special-character GothicD"},  {XML`RawXML["&#63183;"]}],
	"\[GothicE]" -> XMLElement["span",  {"class" -> "special-character GothicE"},  {XML`RawXML["&#63184;"]}],
	"\[GothicEight]" -> XMLElement["span",  {"class" -> "special-character GothicEight"},  {XML`RawXML["&#63469;"]}],
	"\[GothicF]" -> XMLElement["span",  {"class" -> "special-character GothicF"},  {XML`RawXML["&#63185;"]}],
	"\[GothicFive]" -> XMLElement["span",  {"class" -> "special-character GothicFive"},  {XML`RawXML["&#63466;"]}],
	"\[GothicFour]" -> XMLElement["span",  {"class" -> "special-character GothicFour"},  {XML`RawXML["&#63465;"]}],
	"\[GothicG]" -> XMLElement["span",  {"class" -> "special-character GothicG"},  {XML`RawXML["&#63186;"]}],
	"\[GothicH]" -> XMLElement["span",  {"class" -> "special-character GothicH"},  {XML`RawXML["&#63187;"]}],
	"\[GothicI]" -> XMLElement["span",  {"class" -> "special-character GothicI"},  {XML`RawXML["&#63188;"]}],
	"\[GothicJ]" -> XMLElement["span",  {"class" -> "special-character GothicJ"},  {XML`RawXML["&#63189;"]}],
	"\[GothicK]" -> XMLElement["span",  {"class" -> "special-character GothicK"},  {XML`RawXML["&#63190;"]}],
	"\[GothicL]" -> XMLElement["span",  {"class" -> "special-character GothicL"},  {XML`RawXML["&#63191;"]}],
	"\[GothicM]" -> XMLElement["span",  {"class" -> "special-character GothicM"},  {XML`RawXML["&#63192;"]}],
	"\[GothicN]" -> XMLElement["span",  {"class" -> "special-character GothicN"},  {XML`RawXML["&#63193;"]}],
	"\[GothicNine]" -> XMLElement["span",  {"class" -> "special-character GothicNine"},  {XML`RawXML["&#63471;"]}],
	"\[GothicO]" -> XMLElement["span",  {"class" -> "special-character GothicO"},  {XML`RawXML["&#63194;"]}],
	"\[GothicOne]" -> XMLElement["span",  {"class" -> "special-character GothicOne"},  {XML`RawXML["&#63462;"]}],
	"\[GothicP]" -> XMLElement["span",  {"class" -> "special-character GothicP"},  {XML`RawXML["&#63195;"]}],
	"\[GothicQ]" -> XMLElement["span",  {"class" -> "special-character GothicQ"},  {XML`RawXML["&#63196;"]}],
	"\[GothicR]" -> XMLElement["span",  {"class" -> "special-character GothicR"},  {XML`RawXML["&#63197;"]}],
	"\[GothicS]" -> XMLElement["span",  {"class" -> "special-character GothicS"},  {XML`RawXML["&#63198;"]}],
	"\[GothicSeven]" -> XMLElement["span",  {"class" -> "special-character GothicSeven"},  {XML`RawXML["&#63468;"]}],
	"\[GothicSix]" -> XMLElement["span",  {"class" -> "special-character GothicSix"},  {XML`RawXML["&#63467;"]}],
	"\[GothicT]" -> XMLElement["span",  {"class" -> "special-character GothicT"},  {XML`RawXML["&#63199;"]}],
	"\[GothicThree]" -> XMLElement["span",  {"class" -> "special-character GothicThree"},  {XML`RawXML["&#63464;"]}],
	"\[GothicTwo]" -> XMLElement["span",  {"class" -> "special-character GothicTwo"},  {XML`RawXML["&#63463;"]}],
	"\[GothicU]" -> XMLElement["span",  {"class" -> "special-character GothicU"},  {XML`RawXML["&#63200;"]}],
	"\[GothicV]" -> XMLElement["span",  {"class" -> "special-character GothicV"},  {XML`RawXML["&#63201;"]}],
	"\[GothicW]" -> XMLElement["span",  {"class" -> "special-character GothicW"},  {XML`RawXML["&#63202;"]}],
	"\[GothicX]" -> XMLElement["span",  {"class" -> "special-character GothicX"},  {XML`RawXML["&#63203;"]}],
	"\[GothicY]" -> XMLElement["span",  {"class" -> "special-character GothicY"},  {XML`RawXML["&#63204;"]}],
	"\[GothicZ]" -> XMLElement["span",  {"class" -> "special-character GothicZ"},  {XML`RawXML["&#63205;"]}],
	"\[GothicZero]" -> XMLElement["span",  {"class" -> "special-character GothicZero"},  {XML`RawXML["&#63461;"]}],
	"\[Gradient]" -> XMLElement["span",  {"class" -> "special-character Gradient"},  {XML`RawXML["&#62422;"]}],
	"\[GrayCircle]" -> XMLElement["span",  {"class" -> "special-character GrayCircle"},  {XML`RawXML["&#9679;"]}],
	"\[GraySquare]" -> XMLElement["span",  {"class" -> "special-character GraySquare"},  {XML`RawXML["&#9632;"]}],
	"\[GreaterEqual]" -> XMLElement["span",  {"class" -> "special-character GreaterEqual"},  {XML`RawXML["&#8805;"]}],
	"\[GreaterEqualLess]" -> XMLElement["span",  {"class" -> "special-character GreaterEqualLess"},  {XML`RawXML["&#8923;"]}],
	"\[GreaterFullEqual]" -> XMLElement["span",  {"class" -> "special-character GreaterFullEqual"},  {XML`RawXML["&#8807;"]}],
	"\[GreaterGreater]" -> XMLElement["span",  {"class" -> "special-character GreaterGreater"},  {XML`RawXML["&#8811;"]}],
	"\[GreaterLess]" -> XMLElement["span",  {"class" -> "special-character GreaterLess"},  {XML`RawXML["&#8823;"]}],
	"\[GreaterSlantEqual]" -> XMLElement["span",  {"class" -> "special-character GreaterSlantEqual"},  {XML`RawXML["&#10878;"]}],
	"\[GreaterTilde]" -> XMLElement["span",  {"class" -> "special-character GreaterTilde"},  {XML`RawXML["&#8819;"]}],
	"\[Hacek]" -> XMLElement["span",  {"class" -> "special-character Hacek"},  {XML`RawXML["&#711;"]}],
	"\[HappySmiley]" -> XMLElement["span",  {"class" -> "special-character HappySmiley"},  {XML`RawXML["&#9786;"]}],
	"\[HBar]" -> XMLElement["span",  {"class" -> "special-character HBar"},  {XML`RawXML["&#8463;"]}],
	"\[HeartSuit]" -> XMLElement["span",  {"class" -> "special-character HeartSuit"},  {XML`RawXML["&#9825;"]}],
	"\[HermitianConjugate]" -> XMLElement["span",  {"class" -> "special-character HermitianConjugate"},  {XML`RawXML["&#62414;"]}],
	"\[HorizontalLine]" -> XMLElement["span",  {"class" -> "special-character HorizontalLine"},  {XML`RawXML["&#9472;"]}],
	"\[HumpDownHump]" -> XMLElement["span",  {"class" -> "special-character HumpDownHump"},  {XML`RawXML["&#8782;"]}],
	"\[HumpEqual]" -> XMLElement["span",  {"class" -> "special-character HumpEqual"},  {XML`RawXML["&#8783;"]}],
	"\[Hyphen]" -> XMLElement["span",  {"class" -> "special-character Hyphen"},  {XML`RawXML["&#8208;"]}],
	"\[IAcute]" -> XMLElement["span",  {"class" -> "special-character IAcute"},  {XML`RawXML["&#237;"]}],
	"\[ICup]" -> XMLElement["span",  {"class" -> "special-character ICup"},  {XML`RawXML["&#301;"]}],
	"\[IDoubleDot]" -> XMLElement["span",  {"class" -> "special-character IDoubleDot"},  {XML`RawXML["&#239;"]}],
	"\[IGrave]" -> XMLElement["span",  {"class" -> "special-character IGrave"},  {XML`RawXML["&#236;"]}],
	"\[IHat]" -> XMLElement["span",  {"class" -> "special-character IHat"},  {XML`RawXML["&#238;"]}],
	"\[ImaginaryI]" -> XMLElement["span",  {"class" -> "special-character ImaginaryI"},  {XML`RawXML["&#63310;"]}],
	"\[ImaginaryJ]" -> XMLElement["span",  {"class" -> "special-character ImaginaryJ"},  {XML`RawXML["&#63311;"]}],
	"\[ImplicitPlus]" -> XMLElement["span",  {"class" -> "special-character ImplicitPlus"},  {" "}],
	"\[Implies]" -> XMLElement["span",  {"class" -> "special-character Implies"},  {XML`RawXML["&#62755;"]}],
	"\[IndentingNewLine]" -> XMLElement["span",  {"class" -> "special-character IndentingNewLine"},  {XML`RawXML["&#62371;"]}],
	"\[Infinity]" -> XMLElement["span",  {"class" -> "special-character Infinity"},  {XML`RawXML["&#8734;"]}],
	"\[InlinePart]" -> XMLElement["span",  {"class" -> "special-character InlinePart"},  {XML`RawXML["&#62750;"]}],
	"\[Integral]" -> XMLElement["span",  {"class" -> "special-character Integral"},  {XML`RawXML["&#8747;"]}],
	"\[Intersection]" -> XMLElement["span",  {"class" -> "special-character Intersection"},  {XML`RawXML["&#8898;"]}],
	"\[InvisibleApplication]" -> XMLElement["span",  {"class" -> "special-character InvisibleApplication"},  {" "}],
	"\[InvisibleComma]" -> XMLElement["span",  {"class" -> "special-character InvisibleComma"},  {" "}],
	"\[InvisiblePostfixScriptBase]" -> XMLElement["span",  {"class" -> "special-character InvisiblePostfixScriptBase"},  {" "}],
	"\[InvisiblePrefixScriptBase]" -> XMLElement["span",  {"class" -> "special-character InvisiblePrefixScriptBase"},  {" "}],
	"\[InvisibleSpace]" -> XMLElement["span",  {"class" -> "special-character InvisibleSpace"},  {" "}],
	"\[InvisibleTimes]" -> XMLElement["span",  {"class" -> "special-character InvisibleTimes"},  {" "}],
	"\[Iota]" -> XMLElement["span",  {"class" -> "special-character Iota"},  {XML`RawXML["&#953;"]}],
	"\[Jupiter]" -> XMLElement["span",  {"class" -> "special-character Jupiter"},  {XML`RawXML["&#9795;"]}],
	"\[Kappa]" -> XMLElement["span",  {"class" -> "special-character Kappa"},  {XML`RawXML["&#954;"]}],
	"\[KernelIcon]" -> XMLElement["span",  {"class" -> "special-character KernelIcon"},  {XML`RawXML["&#63318;"]}],
	"\[KeyBar]" -> XMLElement["span",  {"class" -> "special-character KeyBar"},  {XML`RawXML["&#63443;"]}],
	"\[Koppa]" -> XMLElement["span",  {"class" -> "special-character Koppa"},  {XML`RawXML["&#991;"]}],
	"\[Lambda]" -> XMLElement["span",  {"class" -> "special-character Lambda"},  {XML`RawXML["&#955;"]}],
	"\[Laplacian]" -> XMLElement["span",  {"class" -> "special-character Laplacian"},  {XML`RawXML["&#8710;"]}],
	"\[LastPage]" -> XMLElement["span",  {"class" -> "special-character LastPage"},  {XML`RawXML["&#63483;"]}],
	"\[LeftAngleBracket]" -> XMLElement["span",  {"class" -> "special-character LeftAngleBracket"},  {XML`RawXML["&#9001;"]}],
	"\[LeftArrow]" -> XMLElement["span",  {"class" -> "special-character LeftArrow"},  {XML`RawXML["&#8592;"]}],
	"\[LeftArrowBar]" -> XMLElement["span",  {"class" -> "special-character LeftArrowBar"},  {XML`RawXML["&#8676;"]}],
	"\[LeftArrowRightArrow]" -> XMLElement["span",  {"class" -> "special-character LeftArrowRightArrow"},  {XML`RawXML["&#8646;"]}],
	"\[LeftAssociation]" -> XMLElement["span",  {"class" -> "special-character LeftAssociation"},  {XML`RawXML["&#61715;"]}],
	"\[LeftBracketingBar]" -> XMLElement["span",  {"class" -> "special-character LeftBracketingBar"},  {XML`RawXML["&#62979;"]}],
	"\[LeftCeiling]" -> XMLElement["span",  {"class" -> "special-character LeftCeiling"},  {XML`RawXML["&#8968;"]}],
	"\[LeftDoubleBracket]" -> XMLElement["span",  {"class" -> "special-character LeftDoubleBracket"},  {XML`RawXML["&#12314;"]}],
	"\[LeftDoubleBracketingBar]" -> XMLElement["span",  {"class" -> "special-character LeftDoubleBracketingBar"},  {XML`RawXML["&#62981;"]}],
	"\[LeftDownTeeVector]" -> XMLElement["span",  {"class" -> "special-character LeftDownTeeVector"},  {XML`RawXML["&#10593;"]}],
	"\[LeftDownVector]" -> XMLElement["span",  {"class" -> "special-character LeftDownVector"},  {XML`RawXML["&#8643;"]}],
	"\[LeftDownVectorBar]" -> XMLElement["span",  {"class" -> "special-character LeftDownVectorBar"},  {XML`RawXML["&#10585;"]}],
	"\[LeftFloor]" -> XMLElement["span",  {"class" -> "special-character LeftFloor"},  {XML`RawXML["&#8970;"]}],
	"\[LeftGuillemet]" -> XMLElement["span",  {"class" -> "special-character LeftGuillemet"},  {XML`RawXML["&#171;"]}],
	"\[LeftModified]" -> XMLElement["span",  {"class" -> "special-character LeftModified"},  {XML`RawXML["&#63339;"]}],
	"\[LeftPointer]" -> XMLElement["span",  {"class" -> "special-character LeftPointer"},  {XML`RawXML["&#9666;"]}],
	"\[LeftRightArrow]" -> XMLElement["span",  {"class" -> "special-character LeftRightArrow"},  {XML`RawXML["&#8596;"]}],
	"\[LeftRightVector]" -> XMLElement["span",  {"class" -> "special-character LeftRightVector"},  {XML`RawXML["&#10574;"]}],
	"\[LeftSkeleton]" -> XMLElement["span",  {"class" -> "special-character LeftSkeleton"},  {XML`RawXML["&#63329;"]}],
	"\[LeftTee]" -> XMLElement["span",  {"class" -> "special-character LeftTee"},  {XML`RawXML["&#8867;"]}],
	"\[LeftTeeArrow]" -> XMLElement["span",  {"class" -> "special-character LeftTeeArrow"},  {XML`RawXML["&#8612;"]}],
	"\[LeftTeeVector]" -> XMLElement["span",  {"class" -> "special-character LeftTeeVector"},  {XML`RawXML["&#10586;"]}],
	"\[LeftTriangle]" -> XMLElement["span",  {"class" -> "special-character LeftTriangle"},  {XML`RawXML["&#8882;"]}],
	"\[LeftTriangleBar]" -> XMLElement["span",  {"class" -> "special-character LeftTriangleBar"},  {XML`RawXML["&#10703;"]}],
	"\[LeftTriangleEqual]" -> XMLElement["span",  {"class" -> "special-character LeftTriangleEqual"},  {XML`RawXML["&#8884;"]}],
	"\[LeftUpDownVector]" -> XMLElement["span",  {"class" -> "special-character LeftUpDownVector"},  {XML`RawXML["&#10577;"]}],
	"\[LeftUpTeeVector]" -> XMLElement["span",  {"class" -> "special-character LeftUpTeeVector"},  {XML`RawXML["&#10592;"]}],
	"\[LeftUpVector]" -> XMLElement["span",  {"class" -> "special-character LeftUpVector"},  {XML`RawXML["&#8639;"]}],
	"\[LeftUpVectorBar]" -> XMLElement["span",  {"class" -> "special-character LeftUpVectorBar"},  {XML`RawXML["&#10584;"]}],
	"\[LeftVector]" -> XMLElement["span",  {"class" -> "special-character LeftVector"},  {XML`RawXML["&#8636;"]}],
	"\[LeftVectorBar]" -> XMLElement["span",  {"class" -> "special-character LeftVectorBar"},  {XML`RawXML["&#10578;"]}],
	"\[LeoSign]" -> XMLElement["span",  {"class" -> "special-character LeoSign"},  {XML`RawXML["&#9804;"]}],
	"\[LessEqual]" -> XMLElement["span",  {"class" -> "special-character LessEqual"},  {XML`RawXML["&#8804;"]}],
	"\[LessEqualGreater]" -> XMLElement["span",  {"class" -> "special-character LessEqualGreater"},  {XML`RawXML["&#8922;"]}],
	"\[LessFullEqual]" -> XMLElement["span",  {"class" -> "special-character LessFullEqual"},  {XML`RawXML["&#8806;"]}],
	"\[LessGreater]" -> XMLElement["span",  {"class" -> "special-character LessGreater"},  {XML`RawXML["&#8822;"]}],
	"\[LessLess]" -> XMLElement["span",  {"class" -> "special-character LessLess"},  {XML`RawXML["&#8810;"]}],
	"\[LessSlantEqual]" -> XMLElement["span",  {"class" -> "special-character LessSlantEqual"},  {XML`RawXML["&#10877;"]}],
	"\[LessTilde]" -> XMLElement["span",  {"class" -> "special-character LessTilde"},  {XML`RawXML["&#8818;"]}],
	"\[LetterSpace]" -> XMLElement["span",  {"class" -> "special-character LetterSpace"},  {" "}],
	"\[LibraSign]" -> XMLElement["span",  {"class" -> "special-character LibraSign"},  {XML`RawXML["&#9806;"]}],
	"\[LightBulb]" -> XMLElement["span",  {"class" -> "special-character LightBulb"},  {XML`RawXML["&#63267;"]}],
	"\[LineSeparator]" -> XMLElement["span",  {"class" -> "special-character LineSeparator"},  {" "}],
	"\[LongDash]" -> XMLElement["span",  {"class" -> "special-character LongDash"},  {XML`RawXML["&#8212;"]}],
	"\[LongEqual]" -> XMLElement["span",  {"class" -> "special-character LongEqual"},  {XML`RawXML["&#63449;"]}],
	"\[LongLeftArrow]" -> XMLElement["span",  {"class" -> "special-character LongLeftArrow"},  {XML`RawXML["&#10229;"]}],
	"\[LongLeftRightArrow]" -> XMLElement["span",  {"class" -> "special-character LongLeftRightArrow"},  {XML`RawXML["&#10231;"]}],
	"\[LongRightArrow]" -> XMLElement["span",  {"class" -> "special-character LongRightArrow"},  {XML`RawXML["&#10230;"]}],
	"\[LowerLeftArrow]" -> XMLElement["span",  {"class" -> "special-character LowerLeftArrow"},  {XML`RawXML["&#8601;"]}],
	"\[LowerRightArrow]" -> XMLElement["span",  {"class" -> "special-character LowerRightArrow"},  {XML`RawXML["&#8600;"]}],
	"\[LSlash]" -> XMLElement["span",  {"class" -> "special-character LSlash"},  {XML`RawXML["&#322;"]}],
	"\[Mars]" -> XMLElement["span",  {"class" -> "special-character Mars"},  {XML`RawXML["&#9794;"]}],
	"\[MathematicaIcon]" -> XMLElement["span",  {"class" -> "special-character MathematicaIcon"},  {XML`RawXML["&#63319;"]}],
	"\[MeasuredAngle]" -> XMLElement["span",  {"class" -> "special-character MeasuredAngle"},  {XML`RawXML["&#8737;"]}],
	"\[MediumSpace]" -> XMLElement["span",  {"class" -> "special-character MediumSpace"},  {XML`RawXML["&#8287;"]}],
	"\[Mercury]" -> XMLElement["span",  {"class" -> "special-character Mercury"},  {XML`RawXML["&#9791;"]}],
	"\[Mho]" -> XMLElement["span",  {"class" -> "special-character Mho"},  {XML`RawXML["&#8487;"]}],
	"\[Micro]" -> XMLElement["span",  {"class" -> "special-character Micro"},  {XML`RawXML["&#181;"]}],
	"\[Minus]" -> XMLElement["span",  {"class" -> "special-character Minus"},  {XML`RawXML["&#8722;"]}],
	"\[MinusPlus]" -> XMLElement["span",  {"class" -> "special-character MinusPlus"},  {XML`RawXML["&#8723;"]}],
	"\[Mod1Key]" -> XMLElement["span",  {"class" -> "special-character Mod1Key"},  {XML`RawXML["&#63446;"]}],
	"\[Mod2Key]" -> XMLElement["span",  {"class" -> "special-character Mod2Key"},  {XML`RawXML["&#63447;"]}],
	"\[Moon]" -> XMLElement["span",  {"class" -> "special-character Moon"},  {XML`RawXML["&#9790;"]}],
	"\[Mu]" -> XMLElement["span",  {"class" -> "special-character Mu"},  {XML`RawXML["&#956;"]}],
	"\[Nand]" -> XMLElement["span",  {"class" -> "special-character Nand"},  {XML`RawXML["&#8892;"]}],
	"\[Natural]" -> XMLElement["span",  {"class" -> "special-character Natural"},  {XML`RawXML["&#9838;"]}],
	"\[NegativeMediumSpace]" -> XMLElement["span",  {"class" -> "special-character NegativeMediumSpace"},  {" "}],
	"\[NegativeThickSpace]" -> XMLElement["span",  {"class" -> "special-character NegativeThickSpace"},  {" "}],
	"\[NegativeThinSpace]" -> XMLElement["span",  {"class" -> "special-character NegativeThinSpace"},  {" "}],
	"\[NegativeVeryThinSpace]" -> XMLElement["span",  {"class" -> "special-character NegativeVeryThinSpace"},  {" "}],
	"\[Neptune]" -> XMLElement["span",  {"class" -> "special-character Neptune"},  {XML`RawXML["&#9798;"]}],
	"\[NestedGreaterGreater]" -> XMLElement["span",  {"class" -> "special-character NestedGreaterGreater"},  {XML`RawXML["&#10914;"]}],
	"\[NestedLessLess]" -> XMLElement["span",  {"class" -> "special-character NestedLessLess"},  {XML`RawXML["&#10913;"]}],
	"\[NeutralSmiley]" -> XMLElement["span",  {"class" -> "special-character NeutralSmiley"},  {XML`RawXML["&#63266;"]}],
	"\[NewLine]" -> XMLElement["span",  {"class" -> "special-character NewLine"},  {XML`RawXML["&#10;"]}],
	"\[NHacek]" -> XMLElement["span",  {"class" -> "special-character NHacek"},  {XML`RawXML["&#328;"]}],
	"\[NoBreak]" -> XMLElement["span",  {"class" -> "special-character NoBreak"},  {" "}],
	"\[NonBreakingSpace]" -> XMLElement["span",  {"class" -> "special-character NonBreakingSpace"},  {XML`RawXML["&#160;"]}],
	"\[Nor]" -> XMLElement["span",  {"class" -> "special-character Nor"},  {XML`RawXML["&#8893;"]}],
	"\[Not]" -> XMLElement["span",  {"class" -> "special-character Not"},  {XML`RawXML["&#172;"]}],
	"\[NotCongruent]" -> XMLElement["span",  {"class" -> "special-character NotCongruent"},  {XML`RawXML["&#8802;"]}],
	"\[NotCupCap]" -> XMLElement["span",  {"class" -> "special-character NotCupCap"},  {XML`RawXML["&#8813;"]}],
	"\[NotDoubleVerticalBar]" -> XMLElement["span",  {"class" -> "special-character NotDoubleVerticalBar"},  {XML`RawXML["&#8742;"]}],
	"\[NotElement]" -> XMLElement["span",  {"class" -> "special-character NotElement"},  {XML`RawXML["&#8713;"]}],
	"\[NotEqual]" -> XMLElement["span",  {"class" -> "special-character NotEqual"},  {XML`RawXML["&#8800;"]}],
	"\[NotEqualTilde]" -> XMLElement["span",  {"class" -> "special-character NotEqualTilde"},  {XML`RawXML["&#62464;"]}],
	"\[NotExists]" -> XMLElement["span",  {"class" -> "special-character NotExists"},  {XML`RawXML["&#8708;"]}],
	"\[NotGreater]" -> XMLElement["span",  {"class" -> "special-character NotGreater"},  {XML`RawXML["&#8815;"]}],
	"\[NotGreaterEqual]" -> XMLElement["span",  {"class" -> "special-character NotGreaterEqual"},  {XML`RawXML["&#8817;"]}],
	"\[NotGreaterFullEqual]" -> XMLElement["span",  {"class" -> "special-character NotGreaterFullEqual"},  {XML`RawXML["&#8809;"]}],
	"\[NotGreaterGreater]" -> XMLElement["span",  {"class" -> "special-character NotGreaterGreater"},  {XML`RawXML["&#62503;"]}],
	"\[NotGreaterLess]" -> XMLElement["span",  {"class" -> "special-character NotGreaterLess"},  {XML`RawXML["&#8825;"]}],
	"\[NotGreaterSlantEqual]" -> XMLElement["span",  {"class" -> "special-character NotGreaterSlantEqual"},  {XML`RawXML["&#62505;"]}],
	"\[NotGreaterTilde]" -> XMLElement["span",  {"class" -> "special-character NotGreaterTilde"},  {XML`RawXML["&#8821;"]}],
	"\[NotHumpDownHump]" -> XMLElement["span",  {"class" -> "special-character NotHumpDownHump"},  {XML`RawXML["&#62466;"]}],
	"\[NotHumpEqual]" -> XMLElement["span",  {"class" -> "special-character NotHumpEqual"},  {XML`RawXML["&#62465;"]}],
	"\[NotLeftTriangle]" -> XMLElement["span",  {"class" -> "special-character NotLeftTriangle"},  {XML`RawXML["&#8938;"]}],
	"\[NotLeftTriangleBar]" -> XMLElement["span",  {"class" -> "special-character NotLeftTriangleBar"},  {XML`RawXML["&#62482;"]}],
	"\[NotLeftTriangleEqual]" -> XMLElement["span",  {"class" -> "special-character NotLeftTriangleEqual"},  {XML`RawXML["&#8940;"]}],
	"\[NotLess]" -> XMLElement["span",  {"class" -> "special-character NotLess"},  {XML`RawXML["&#8814;"]}],
	"\[NotLessEqual]" -> XMLElement["span",  {"class" -> "special-character NotLessEqual"},  {XML`RawXML["&#8816;"]}],
	"\[NotLessFullEqual]" -> XMLElement["span",  {"class" -> "special-character NotLessFullEqual"},  {XML`RawXML["&#8808;"]}],
	"\[NotLessGreater]" -> XMLElement["span",  {"class" -> "special-character NotLessGreater"},  {XML`RawXML["&#8824;"]}],
	"\[NotLessLess]" -> XMLElement["span",  {"class" -> "special-character NotLessLess"},  {XML`RawXML["&#62498;"]}],
	"\[NotLessSlantEqual]" -> XMLElement["span",  {"class" -> "special-character NotLessSlantEqual"},  {XML`RawXML["&#62500;"]}],
	"\[NotLessTilde]" -> XMLElement["span",  {"class" -> "special-character NotLessTilde"},  {XML`RawXML["&#8820;"]}],
	"\[NotNestedGreaterGreater]" -> XMLElement["span",  {"class" -> "special-character NotNestedGreaterGreater"},  {XML`RawXML["&#62504;"]}],
	"\[NotNestedLessLess]" -> XMLElement["span",  {"class" -> "special-character NotNestedLessLess"},  {XML`RawXML["&#62499;"]}],
	"\[NotPrecedes]" -> XMLElement["span",  {"class" -> "special-character NotPrecedes"},  {XML`RawXML["&#8832;"]}],
	"\[NotPrecedesEqual]" -> XMLElement["span",  {"class" -> "special-character NotPrecedesEqual"},  {XML`RawXML["&#62507;"]}],
	"\[NotPrecedesSlantEqual]" -> XMLElement["span",  {"class" -> "special-character NotPrecedesSlantEqual"},  {XML`RawXML["&#8928;"]}],
	"\[NotPrecedesTilde]" -> XMLElement["span",  {"class" -> "special-character NotPrecedesTilde"},  {XML`RawXML["&#8936;"]}],
	"\[NotReverseElement]" -> XMLElement["span",  {"class" -> "special-character NotReverseElement"},  {XML`RawXML["&#8716;"]}],
	"\[NotRightTriangle]" -> XMLElement["span",  {"class" -> "special-character NotRightTriangle"},  {XML`RawXML["&#8939;"]}],
	"\[NotRightTriangleBar]" -> XMLElement["span",  {"class" -> "special-character NotRightTriangleBar"},  {XML`RawXML["&#62483;"]}],
	"\[NotRightTriangleEqual]" -> XMLElement["span",  {"class" -> "special-character NotRightTriangleEqual"},  {XML`RawXML["&#8941;"]}],
	"\[NotSquareSubset]" -> XMLElement["span",  {"class" -> "special-character NotSquareSubset"},  {XML`RawXML["&#62510;"]}],
	"\[NotSquareSubsetEqual]" -> XMLElement["span",  {"class" -> "special-character NotSquareSubsetEqual"},  {XML`RawXML["&#8930;"]}],
	"\[NotSquareSuperset]" -> XMLElement["span",  {"class" -> "special-character NotSquareSuperset"},  {XML`RawXML["&#62511;"]}],
	"\[NotSquareSupersetEqual]" -> XMLElement["span",  {"class" -> "special-character NotSquareSupersetEqual"},  {XML`RawXML["&#8931;"]}],
	"\[NotSubset]" -> XMLElement["span",  {"class" -> "special-character NotSubset"},  {XML`RawXML["&#8836;"]}],
	"\[NotSubsetEqual]" -> XMLElement["span",  {"class" -> "special-character NotSubsetEqual"},  {XML`RawXML["&#8840;"]}],
	"\[NotSucceeds]" -> XMLElement["span",  {"class" -> "special-character NotSucceeds"},  {XML`RawXML["&#8833;"]}],
	"\[NotSucceedsEqual]" -> XMLElement["span",  {"class" -> "special-character NotSucceedsEqual"},  {XML`RawXML["&#62509;"]}],
	"\[NotSucceedsSlantEqual]" -> XMLElement["span",  {"class" -> "special-character NotSucceedsSlantEqual"},  {XML`RawXML["&#8929;"]}],
	"\[NotSucceedsTilde]" -> XMLElement["span",  {"class" -> "special-character NotSucceedsTilde"},  {XML`RawXML["&#8937;"]}],
	"\[NotSuperset]" -> XMLElement["span",  {"class" -> "special-character NotSuperset"},  {XML`RawXML["&#8837;"]}],
	"\[NotSupersetEqual]" -> XMLElement["span",  {"class" -> "special-character NotSupersetEqual"},  {XML`RawXML["&#8841;"]}],
	"\[NotTilde]" -> XMLElement["span",  {"class" -> "special-character NotTilde"},  {XML`RawXML["&#8769;"]}],
	"\[NotTildeEqual]" -> XMLElement["span",  {"class" -> "special-character NotTildeEqual"},  {XML`RawXML["&#8772;"]}],
	"\[NotTildeFullEqual]" -> XMLElement["span",  {"class" -> "special-character NotTildeFullEqual"},  {XML`RawXML["&#8775;"]}],
	"\[NotTildeTilde]" -> XMLElement["span",  {"class" -> "special-character NotTildeTilde"},  {XML`RawXML["&#8777;"]}],
	"\[NotVerticalBar]" -> XMLElement["span",  {"class" -> "special-character NotVerticalBar"},  {XML`RawXML["&#62417;"]}],
	"\[NTilde]" -> XMLElement["span",  {"class" -> "special-character NTilde"},  {XML`RawXML["&#241;"]}],
	"\[Nu]" -> XMLElement["span",  {"class" -> "special-character Nu"},  {XML`RawXML["&#957;"]}],
	"\[Null]" -> XMLElement["span",  {"class" -> "special-character Null"},  {" "}],
	"\[NumberSign]" -> XMLElement["span",  {"class" -> "special-character NumberSign"},  {XML`RawXML["&#63268;"]}],
	"\[OAcute]" -> XMLElement["span",  {"class" -> "special-character OAcute"},  {XML`RawXML["&#243;"]}],
	"\[ODoubleAcute]" -> XMLElement["span",  {"class" -> "special-character ODoubleAcute"},  {XML`RawXML["&#337;"]}],
	"\[ODoubleDot]" -> XMLElement["span",  {"class" -> "special-character ODoubleDot"},  {XML`RawXML["&#246;"]}],
	"\[OE]" -> XMLElement["span",  {"class" -> "special-character OE"},  {XML`RawXML["&#339;"]}],
	"\[OGrave]" -> XMLElement["span",  {"class" -> "special-character OGrave"},  {XML`RawXML["&#242;"]}],
	"\[OHat]" -> XMLElement["span",  {"class" -> "special-character OHat"},  {XML`RawXML["&#244;"]}],
	"\[Omega]" -> XMLElement["span",  {"class" -> "special-character Omega"},  {XML`RawXML["&#969;"]}],
	"\[Omicron]" -> XMLElement["span",  {"class" -> "special-character Omicron"},  {XML`RawXML["&#959;"]}],
	"\[OpenCurlyDoubleQuote]" -> XMLElement["span",  {"class" -> "special-character OpenCurlyDoubleQuote"},  {XML`RawXML["&#8220;"]}],
	"\[OpenCurlyQuote]" -> XMLElement["span",  {"class" -> "special-character OpenCurlyQuote"},  {XML`RawXML["&#8216;"]}],
	"\[OptionKey]" -> XMLElement["span",  {"class" -> "special-character OptionKey"},  {XML`RawXML["&#63442;"]}],
	"\[Or]" -> XMLElement["span",  {"class" -> "special-character Or"},  {XML`RawXML["&#8744;"]}],
	"\[OSlash]" -> XMLElement["span",  {"class" -> "special-character OSlash"},  {XML`RawXML["&#248;"]}],
	"\[OTilde]" -> XMLElement["span",  {"class" -> "special-character OTilde"},  {XML`RawXML["&#245;"]}],
	"\[OverBrace]" -> XMLElement["span",  {"class" -> "special-character OverBrace"},  {XML`RawXML["&#65079;"]}],
	"\[OverBracket]" -> XMLElement["span",  {"class" -> "special-character OverBracket"},  {XML`RawXML["&#9140;"]}],
	"\[OverParenthesis]" -> XMLElement["span",  {"class" -> "special-character OverParenthesis"},  {XML`RawXML["&#65077;"]}],
	"\[PageBreakAbove]" -> XMLElement["span",  {"class" -> "special-character PageBreakAbove"},  {XML`RawXML["&#62397;"]}],
	"\[PageBreakBelow]" -> XMLElement["span",  {"class" -> "special-character PageBreakBelow"},  {XML`RawXML["&#62398;"]}],
	"\[Paragraph]" -> XMLElement["span",  {"class" -> "special-character Paragraph"},  {XML`RawXML["&#182;"]}],
	"\[ParagraphSeparator]" -> XMLElement["span",  {"class" -> "special-character ParagraphSeparator"},  {XML`RawXML["&#8233;"]}],
	"\[PartialD]" -> XMLElement["span",  {"class" -> "special-character PartialD"},  {XML`RawXML["&#8706;"]}],
	"\[PermutationProduct]" -> XMLElement["span",  {"class" -> "special-character PermutationProduct"},  {XML`RawXML["&#62430;"]}],
	"\[Perpendicular]" -> XMLElement["span",  {"class" -> "special-character Perpendicular"},  {XML`RawXML["&#10178;"]}],
	"\[Phi]" -> XMLElement["span",  {"class" -> "special-character Phi"},  {XML`RawXML["&#981;"]}],
	"\[Pi]" -> XMLElement["span",  {"class" -> "special-character Pi"},  {XML`RawXML["&#960;"]}],
	"\[Piecewise]" -> XMLElement["span",  {"class" -> "special-character Piecewise"},  {XML`RawXML["&#62305;"]}],
	"\[PiscesSign]" -> XMLElement["span",  {"class" -> "special-character PiscesSign"},  {XML`RawXML["&#9811;"]}],
	"\[Placeholder]" -> XMLElement["span",  {"class" -> "special-character Placeholder"},  {XML`RawXML["&#62760;"]}],
	"\[PlusMinus]" -> XMLElement["span",  {"class" -> "special-character PlusMinus"},  {XML`RawXML["&#177;"]}],
	"\[Pluto]" -> XMLElement["span",  {"class" -> "special-character Pluto"},  {XML`RawXML["&#9799;"]}],
	"\[Precedes]" -> XMLElement["span",  {"class" -> "special-character Precedes"},  {XML`RawXML["&#8826;"]}],
	"\[PrecedesEqual]" -> XMLElement["span",  {"class" -> "special-character PrecedesEqual"},  {XML`RawXML["&#10927;"]}],
	"\[PrecedesSlantEqual]" -> XMLElement["span",  {"class" -> "special-character PrecedesSlantEqual"},  {XML`RawXML["&#8828;"]}],
	"\[PrecedesTilde]" -> XMLElement["span",  {"class" -> "special-character PrecedesTilde"},  {XML`RawXML["&#8830;"]}],
	"\[Prime]" -> XMLElement["span",  {"class" -> "special-character Prime"},  {XML`RawXML["&#8242;"]}],
	"\[ProbabilityPr]" -> XMLElement["span",  {"class" -> "special-character ProbabilityPr"},  {XML`RawXML["&#62428;"]}],
	"\[Product]" -> XMLElement["span",  {"class" -> "special-character Product"},  {XML`RawXML["&#8719;"]}],
	"\[Proportion]" -> XMLElement["span",  {"class" -> "special-character Proportion"},  {XML`RawXML["&#8759;"]}],
	"\[Proportional]" -> XMLElement["span",  {"class" -> "special-character Proportional"},  {XML`RawXML["&#8733;"]}],
	"\[Psi]" -> XMLElement["span",  {"class" -> "special-character Psi"},  {XML`RawXML["&#968;"]}],
	"\[QuarterNote]" -> XMLElement["span",  {"class" -> "special-character QuarterNote"},  {XML`RawXML["&#9833;"]}],
	"\[RawAmpersand]" -> XMLElement["span",  {"class" -> "special-character RawAmpersand"},  {XML`RawXML["&#38;"]}],
	"\[RawAt]" -> XMLElement["span",  {"class" -> "special-character RawAt"},  {XML`RawXML["&#64;"]}],
	"\[RawBackquote]" -> XMLElement["span",  {"class" -> "special-character RawBackquote"},  {XML`RawXML["&#96;"]}],
	(*"\[RawBackslash]" -> XMLElement["span",  {"class" -> "special-character RawBackslash"},  {XML`RawXML["&#92;"]}],*)
	"\[RawColon]" -> XMLElement["span",  {"class" -> "special-character RawColon"},  {XML`RawXML["&#58;"]}],
	"\[RawComma]" -> XMLElement["span",  {"class" -> "special-character RawComma"},  {XML`RawXML["&#44;"]}],
	"\[RawDash]" -> XMLElement["span",  {"class" -> "special-character RawDash"},  {XML`RawXML["&#45;"]}],
	"\[RawDollar]" -> XMLElement["span",  {"class" -> "special-character RawDollar"},  {XML`RawXML["&#36;"]}],
	"\[RawDot]" -> XMLElement["span",  {"class" -> "special-character RawDot"},  {XML`RawXML["&#46;"]}],
	(*"\[RawDoubleQuote]" -> XMLElement["span",  {"class" -> "special-character RawDoubleQuote"},  {XML`RawXML["&#34;"]}],*)
	"\[RawEqual]" -> XMLElement["span",  {"class" -> "special-character RawEqual"},  {XML`RawXML["&#61;"]}],
	"\[RawEscape]" -> XMLElement["span",  {"class" -> "special-character RawEscape"},  {XML`RawXML["&#27;"]}],
	"\[RawExclamation]" -> XMLElement["span",  {"class" -> "special-character RawExclamation"},  {XML`RawXML["&#33;"]}],
	"\[RawGreater]" -> XMLElement["span",  {"class" -> "special-character RawGreater"},  {XML`RawXML["&#62;"]}],
	"\[RawLeftBrace]" -> XMLElement["span",  {"class" -> "special-character RawLeftBrace"},  {XML`RawXML["&#123;"]}],
	"\[RawLeftBracket]" -> XMLElement["span",  {"class" -> "special-character RawLeftBracket"},  {XML`RawXML["&#91;"]}],
	"\[RawLeftParenthesis]" -> XMLElement["span",  {"class" -> "special-character RawLeftParenthesis"},  {XML`RawXML["&#40;"]}],
	"\[RawLess]" -> XMLElement["span",  {"class" -> "special-character RawLess"},  {XML`RawXML["&#60;"]}],
	"\[RawNumberSign]" -> XMLElement["span",  {"class" -> "special-character RawNumberSign"},  {XML`RawXML["&#35;"]}],
	"\[RawPercent]" -> XMLElement["span",  {"class" -> "special-character RawPercent"},  {XML`RawXML["&#37;"]}],
	"\[RawPlus]" -> XMLElement["span",  {"class" -> "special-character RawPlus"},  {XML`RawXML["&#43;"]}],
	"\[RawQuestion]" -> XMLElement["span",  {"class" -> "special-character RawQuestion"},  {XML`RawXML["&#63;"]}],
	"\[RawQuote]" -> XMLElement["span",  {"class" -> "special-character RawQuote"},  {XML`RawXML["&#39;"]}],
	"\[RawReturn]" -> XMLElement["span",  {"class" -> "special-character RawReturn"},  {XML`RawXML["&#13;"]}],
	"\[RawRightBrace]" -> XMLElement["span",  {"class" -> "special-character RawRightBrace"},  {XML`RawXML["&#125;"]}],
	"\[RawRightBracket]" -> XMLElement["span",  {"class" -> "special-character RawRightBracket"},  {XML`RawXML["&#93;"]}],
	"\[RawRightParenthesis]" -> XMLElement["span",  {"class" -> "special-character RawRightParenthesis"},  {XML`RawXML["&#41;"]}],
	"\[RawSemicolon]" -> XMLElement["span",  {"class" -> "special-character RawSemicolon"},  {XML`RawXML["&#59;"]}],
	"\[RawSlash]" -> XMLElement["span",  {"class" -> "special-character RawSlash"},  {XML`RawXML["&#47;"]}],
	"\[RawSpace]" -> XMLElement["span",  {"class" -> "special-character RawSpace"},  {XML`RawXML["&#32;"]}],
	"\[RawStar]" -> XMLElement["span",  {"class" -> "special-character RawStar"},  {XML`RawXML["&#42;"]}],
	"\[RawTab]" -> XMLElement["span",  {"class" -> "special-character RawTab"},  {XML`RawXML["&#9;"]}],
	"\[RawTilde]" -> XMLElement["span",  {"class" -> "special-character RawTilde"},  {XML`RawXML["&#126;"]}],
	"\[RawUnderscore]" -> XMLElement["span",  {"class" -> "special-character RawUnderscore"},  {XML`RawXML["&#95;"]}],
	"\[RawVerticalBar]" -> XMLElement["span",  {"class" -> "special-character RawVerticalBar"},  {XML`RawXML["&#124;"]}],
	"\[RawWedge]" -> XMLElement["span",  {"class" -> "special-character RawWedge"},  {XML`RawXML["&#94;"]}],
	"\[RegisteredTrademark]" -> XMLElement["span",  {"class" -> "special-character RegisteredTrademark"},  {XML`RawXML["&#174;"]}],
	"\[ReturnIndicator]" -> XMLElement["span",  {"class" -> "special-character ReturnIndicator"},  {XML`RawXML["&#8629;"]}],
	"\[ReturnKey]" -> XMLElement["span",  {"class" -> "special-character ReturnKey"},  {XML`RawXML["&#63334;"]}],
	"\[ReverseDoublePrime]" -> XMLElement["span",  {"class" -> "special-character ReverseDoublePrime"},  {XML`RawXML["&#8246;"]}],
	"\[ReverseElement]" -> XMLElement["span",  {"class" -> "special-character ReverseElement"},  {XML`RawXML["&#8715;"]}],
	"\[ReverseEquilibrium]" -> XMLElement["span",  {"class" -> "special-character ReverseEquilibrium"},  {XML`RawXML["&#8651;"]}],
	"\[ReversePrime]" -> XMLElement["span",  {"class" -> "special-character ReversePrime"},  {XML`RawXML["&#8245;"]}],
	"\[ReverseUpEquilibrium]" -> XMLElement["span",  {"class" -> "special-character ReverseUpEquilibrium"},  {XML`RawXML["&#10607;"]}],
	"\[RHacek]" -> XMLElement["span",  {"class" -> "special-character RHacek"},  {XML`RawXML["&#345;"]}],
	"\[Rho]" -> XMLElement["span",  {"class" -> "special-character Rho"},  {XML`RawXML["&#961;"]}],
	"\[RightAngle]" -> XMLElement["span",  {"class" -> "special-character RightAngle"},  {XML`RawXML["&#8735;"]}],
	"\[RightAngleBracket]" -> XMLElement["span",  {"class" -> "special-character RightAngleBracket"},  {XML`RawXML["&#9002;"]}],
	"\[RightArrow]" -> XMLElement["span",  {"class" -> "special-character RightArrow"},  {XML`RawXML["&#8594;"]}],
	"\[RightArrowBar]" -> XMLElement["span",  {"class" -> "special-character RightArrowBar"},  {XML`RawXML["&#8677;"]}],
	"\[RightArrowLeftArrow]" -> XMLElement["span",  {"class" -> "special-character RightArrowLeftArrow"},  {XML`RawXML["&#8644;"]}],
	"\[RightAssociation]" -> XMLElement["span",  {"class" -> "special-character RightAssociation"},  {XML`RawXML["&#61716;"]}],
	"\[RightBracketingBar]" -> XMLElement["span",  {"class" -> "special-character RightBracketingBar"},  {XML`RawXML["&#62980;"]}],
	"\[RightCeiling]" -> XMLElement["span",  {"class" -> "special-character RightCeiling"},  {XML`RawXML["&#8969;"]}],
	"\[RightDoubleBracket]" -> XMLElement["span",  {"class" -> "special-character RightDoubleBracket"},  {XML`RawXML["&#12315;"]}],
	"\[RightDoubleBracketingBar]" -> XMLElement["span",  {"class" -> "special-character RightDoubleBracketingBar"},  {XML`RawXML["&#62982;"]}],
	"\[RightDownTeeVector]" -> XMLElement["span",  {"class" -> "special-character RightDownTeeVector"},  {XML`RawXML["&#10589;"]}],
	"\[RightDownVector]" -> XMLElement["span",  {"class" -> "special-character RightDownVector"},  {XML`RawXML["&#8642;"]}],
	"\[RightDownVectorBar]" -> XMLElement["span",  {"class" -> "special-character RightDownVectorBar"},  {XML`RawXML["&#10581;"]}],
	"\[RightFloor]" -> XMLElement["span",  {"class" -> "special-character RightFloor"},  {XML`RawXML["&#8971;"]}],
	"\[RightGuillemet]" -> XMLElement["span",  {"class" -> "special-character RightGuillemet"},  {XML`RawXML["&#187;"]}],
	"\[RightModified]" -> XMLElement["span",  {"class" -> "special-character RightModified"},  {XML`RawXML["&#63340;"]}],
	"\[RightPointer]" -> XMLElement["span",  {"class" -> "special-character RightPointer"},  {XML`RawXML["&#9656;"]}],
	"\[RightSkeleton]" -> XMLElement["span",  {"class" -> "special-character RightSkeleton"},  {XML`RawXML["&#63330;"]}],
	"\[RightTee]" -> XMLElement["span",  {"class" -> "special-character RightTee"},  {XML`RawXML["&#8866;"]}],
	"\[RightTeeArrow]" -> XMLElement["span",  {"class" -> "special-character RightTeeArrow"},  {XML`RawXML["&#8614;"]}],
	"\[RightTeeVector]" -> XMLElement["span",  {"class" -> "special-character RightTeeVector"},  {XML`RawXML["&#10587;"]}],
	"\[RightTriangle]" -> XMLElement["span",  {"class" -> "special-character RightTriangle"},  {XML`RawXML["&#8883;"]}],
	"\[RightTriangleBar]" -> XMLElement["span",  {"class" -> "special-character RightTriangleBar"},  {XML`RawXML["&#10704;"]}],
	"\[RightTriangleEqual]" -> XMLElement["span",  {"class" -> "special-character RightTriangleEqual"},  {XML`RawXML["&#8885;"]}],
	"\[RightUpDownVector]" -> XMLElement["span",  {"class" -> "special-character RightUpDownVector"},  {XML`RawXML["&#10575;"]}],
	"\[RightUpTeeVector]" -> XMLElement["span",  {"class" -> "special-character RightUpTeeVector"},  {XML`RawXML["&#10588;"]}],
	"\[RightUpVector]" -> XMLElement["span",  {"class" -> "special-character RightUpVector"},  {XML`RawXML["&#8638;"]}],
	"\[RightUpVectorBar]" -> XMLElement["span",  {"class" -> "special-character RightUpVectorBar"},  {XML`RawXML["&#10580;"]}],
	"\[RightVector]" -> XMLElement["span",  {"class" -> "special-character RightVector"},  {XML`RawXML["&#8640;"]}],
	"\[RightVectorBar]" -> XMLElement["span",  {"class" -> "special-character RightVectorBar"},  {XML`RawXML["&#10579;"]}],
	"\[RoundImplies]" -> XMLElement["span",  {"class" -> "special-character RoundImplies"},  {XML`RawXML["&#10608;"]}],
	"\[RoundSpaceIndicator]" -> XMLElement["span",  {"class" -> "special-character RoundSpaceIndicator"},  {XML`RawXML["&#62386;"]}],
	"\[Rule]" -> XMLElement["span",  {"class" -> "special-character Rule"},  {XML`RawXML["&#62754;"]}],
	"\[RuleDelayed]" -> XMLElement["span",  {"class" -> "special-character RuleDelayed"},  {XML`RawXML["&#62751;"]}],
	"\[Rupee]" -> XMLElement["span",  {"class" -> "special-character Rupee"},  {XML`RawXML["&#8377;"]}],
	"\[SadSmiley]" -> XMLElement["span",  {"class" -> "special-character SadSmiley"},  {XML`RawXML["&#9785;"]}],
	"\[SagittariusSign]" -> XMLElement["span",  {"class" -> "special-character SagittariusSign"},  {XML`RawXML["&#9808;"]}],
	"\[Sampi]" -> XMLElement["span",  {"class" -> "special-character Sampi"},  {XML`RawXML["&#993;"]}],
	"\[Saturn]" -> XMLElement["span",  {"class" -> "special-character Saturn"},  {XML`RawXML["&#9796;"]}],
	"\[ScorpioSign]" -> XMLElement["span",  {"class" -> "special-character ScorpioSign"},  {XML`RawXML["&#9807;"]}],
	"\[ScriptA]" -> XMLElement["span",  {"class" -> "special-character ScriptA"},  {XML`RawXML["&#63154;"]}],
	"\[ScriptB]" -> XMLElement["span",  {"class" -> "special-character ScriptB"},  {XML`RawXML["&#63155;"]}],
	"\[ScriptC]" -> XMLElement["span",  {"class" -> "special-character ScriptC"},  {XML`RawXML["&#63156;"]}],
	"\[ScriptCapitalA]" -> XMLElement["span",  {"class" -> "special-character ScriptCapitalA"},  {XML`RawXML["&#63344;"]}],
	"\[ScriptCapitalB]" -> XMLElement["span",  {"class" -> "special-character ScriptCapitalB"},  {XML`RawXML["&#8492;"]}],
	"\[ScriptCapitalC]" -> XMLElement["span",  {"class" -> "special-character ScriptCapitalC"},  {XML`RawXML["&#63346;"]}],
	"\[ScriptCapitalD]" -> XMLElement["span",  {"class" -> "special-character ScriptCapitalD"},  {XML`RawXML["&#63347;"]}],
	"\[ScriptCapitalE]" -> XMLElement["span",  {"class" -> "special-character ScriptCapitalE"},  {XML`RawXML["&#8496;"]}],
	"\[ScriptCapitalF]" -> XMLElement["span",  {"class" -> "special-character ScriptCapitalF"},  {XML`RawXML["&#8497;"]}],
	"\[ScriptCapitalG]" -> XMLElement["span",  {"class" -> "special-character ScriptCapitalG"},  {XML`RawXML["&#63350;"]}],
	"\[ScriptCapitalH]" -> XMLElement["span",  {"class" -> "special-character ScriptCapitalH"},  {XML`RawXML["&#8459;"]}],
	"\[ScriptCapitalI]" -> XMLElement["span",  {"class" -> "special-character ScriptCapitalI"},  {XML`RawXML["&#8464;"]}],
	"\[ScriptCapitalJ]" -> XMLElement["span",  {"class" -> "special-character ScriptCapitalJ"},  {XML`RawXML["&#63353;"]}],
	"\[ScriptCapitalK]" -> XMLElement["span",  {"class" -> "special-character ScriptCapitalK"},  {XML`RawXML["&#63354;"]}],
	"\[ScriptCapitalL]" -> XMLElement["span",  {"class" -> "special-character ScriptCapitalL"},  {XML`RawXML["&#8466;"]}],
	"\[ScriptCapitalM]" -> XMLElement["span",  {"class" -> "special-character ScriptCapitalM"},  {XML`RawXML["&#8499;"]}],
	"\[ScriptCapitalN]" -> XMLElement["span",  {"class" -> "special-character ScriptCapitalN"},  {XML`RawXML["&#63357;"]}],
	"\[ScriptCapitalO]" -> XMLElement["span",  {"class" -> "special-character ScriptCapitalO"},  {XML`RawXML["&#63358;"]}],
	"\[ScriptCapitalP]" -> XMLElement["span",  {"class" -> "special-character ScriptCapitalP"},  {XML`RawXML["&#63359;"]}],
	"\[ScriptCapitalQ]" -> XMLElement["span",  {"class" -> "special-character ScriptCapitalQ"},  {XML`RawXML["&#63360;"]}],
	"\[ScriptCapitalR]" -> XMLElement["span",  {"class" -> "special-character ScriptCapitalR"},  {XML`RawXML["&#8475;"]}],
	"\[ScriptCapitalS]" -> XMLElement["span",  {"class" -> "special-character ScriptCapitalS"},  {XML`RawXML["&#63362;"]}],
	"\[ScriptCapitalT]" -> XMLElement["span",  {"class" -> "special-character ScriptCapitalT"},  {XML`RawXML["&#63363;"]}],
	"\[ScriptCapitalU]" -> XMLElement["span",  {"class" -> "special-character ScriptCapitalU"},  {XML`RawXML["&#63364;"]}],
	"\[ScriptCapitalV]" -> XMLElement["span",  {"class" -> "special-character ScriptCapitalV"},  {XML`RawXML["&#63365;"]}],
	"\[ScriptCapitalW]" -> XMLElement["span",  {"class" -> "special-character ScriptCapitalW"},  {XML`RawXML["&#63366;"]}],
	"\[ScriptCapitalX]" -> XMLElement["span",  {"class" -> "special-character ScriptCapitalX"},  {XML`RawXML["&#63367;"]}],
	"\[ScriptCapitalY]" -> XMLElement["span",  {"class" -> "special-character ScriptCapitalY"},  {XML`RawXML["&#63368;"]}],
	"\[ScriptCapitalZ]" -> XMLElement["span",  {"class" -> "special-character ScriptCapitalZ"},  {XML`RawXML["&#63369;"]}],
	"\[ScriptD]" -> XMLElement["span",  {"class" -> "special-character ScriptD"},  {XML`RawXML["&#63157;"]}],
	"\[ScriptDotlessI]" -> XMLElement["span",  {"class" -> "special-character ScriptDotlessI"},  {XML`RawXML["&#63280;"]}],
	"\[ScriptDotlessJ]" -> XMLElement["span",  {"class" -> "special-character ScriptDotlessJ"},  {XML`RawXML["&#63281;"]}],
	"\[ScriptE]" -> XMLElement["span",  {"class" -> "special-character ScriptE"},  {XML`RawXML["&#8495;"]}],
	"\[ScriptEight]" -> XMLElement["span",  {"class" -> "special-character ScriptEight"},  {XML`RawXML["&#63480;"]}],
	"\[ScriptF]" -> XMLElement["span",  {"class" -> "special-character ScriptF"},  {XML`RawXML["&#63159;"]}],
	"\[ScriptFive]" -> XMLElement["span",  {"class" -> "special-character ScriptFive"},  {XML`RawXML["&#63477;"]}],
	"\[ScriptFour]" -> XMLElement["span",  {"class" -> "special-character ScriptFour"},  {XML`RawXML["&#63476;"]}],
	"\[ScriptG]" -> XMLElement["span",  {"class" -> "special-character ScriptG"},  {XML`RawXML["&#8458;"]}],
	"\[ScriptH]" -> XMLElement["span",  {"class" -> "special-character ScriptH"},  {XML`RawXML["&#63161;"]}],
	"\[ScriptI]" -> XMLElement["span",  {"class" -> "special-character ScriptI"},  {XML`RawXML["&#63162;"]}],
	"\[ScriptJ]" -> XMLElement["span",  {"class" -> "special-character ScriptJ"},  {XML`RawXML["&#63163;"]}],
	"\[ScriptK]" -> XMLElement["span",  {"class" -> "special-character ScriptK"},  {XML`RawXML["&#63164;"]}],
	"\[ScriptL]" -> XMLElement["span",  {"class" -> "special-character ScriptL"},  {XML`RawXML["&#8467;"]}],
	"\[ScriptM]" -> XMLElement["span",  {"class" -> "special-character ScriptM"},  {XML`RawXML["&#63166;"]}],
	"\[ScriptN]" -> XMLElement["span",  {"class" -> "special-character ScriptN"},  {XML`RawXML["&#63167;"]}],
	"\[ScriptNine]" -> XMLElement["span",  {"class" -> "special-character ScriptNine"},  {XML`RawXML["&#63481;"]}],
	"\[ScriptO]" -> XMLElement["span",  {"class" -> "special-character ScriptO"},  {XML`RawXML["&#8500;"]}],
	"\[ScriptOne]" -> XMLElement["span",  {"class" -> "special-character ScriptOne"},  {XML`RawXML["&#63473;"]}],
	"\[ScriptP]" -> XMLElement["span",  {"class" -> "special-character ScriptP"},  {XML`RawXML["&#63169;"]}],
	"\[ScriptQ]" -> XMLElement["span",  {"class" -> "special-character ScriptQ"},  {XML`RawXML["&#63170;"]}],
	"\[ScriptR]" -> XMLElement["span",  {"class" -> "special-character ScriptR"},  {XML`RawXML["&#63171;"]}],
	"\[ScriptS]" -> XMLElement["span",  {"class" -> "special-character ScriptS"},  {XML`RawXML["&#63172;"]}],
	"\[ScriptSeven]" -> XMLElement["span",  {"class" -> "special-character ScriptSeven"},  {XML`RawXML["&#63479;"]}],
	"\[ScriptSix]" -> XMLElement["span",  {"class" -> "special-character ScriptSix"},  {XML`RawXML["&#63478;"]}],
	"\[ScriptT]" -> XMLElement["span",  {"class" -> "special-character ScriptT"},  {XML`RawXML["&#63173;"]}],
	"\[ScriptThree]" -> XMLElement["span",  {"class" -> "special-character ScriptThree"},  {XML`RawXML["&#63475;"]}],
	"\[ScriptTwo]" -> XMLElement["span",  {"class" -> "special-character ScriptTwo"},  {XML`RawXML["&#63474;"]}],
	"\[ScriptU]" -> XMLElement["span",  {"class" -> "special-character ScriptU"},  {XML`RawXML["&#63174;"]}],
	"\[ScriptV]" -> XMLElement["span",  {"class" -> "special-character ScriptV"},  {XML`RawXML["&#63175;"]}],
	"\[ScriptW]" -> XMLElement["span",  {"class" -> "special-character ScriptW"},  {XML`RawXML["&#63176;"]}],
	"\[ScriptX]" -> XMLElement["span",  {"class" -> "special-character ScriptX"},  {XML`RawXML["&#63177;"]}],
	"\[ScriptY]" -> XMLElement["span",  {"class" -> "special-character ScriptY"},  {XML`RawXML["&#63178;"]}],
	"\[ScriptZ]" -> XMLElement["span",  {"class" -> "special-character ScriptZ"},  {XML`RawXML["&#63179;"]}],
	"\[ScriptZero]" -> XMLElement["span",  {"class" -> "special-character ScriptZero"},  {XML`RawXML["&#63472;"]}],
	"\[Section]" -> XMLElement["span",  {"class" -> "special-character Section"},  {XML`RawXML["&#167;"]}],
	"\[SelectionPlaceholder]" -> XMLElement["span",  {"class" -> "special-character SelectionPlaceholder"},  {XML`RawXML["&#62759;"]}],
	"\[SHacek]" -> XMLElement["span",  {"class" -> "special-character SHacek"},  {XML`RawXML["&#353;"]}],
	"\[Shah]" -> XMLElement["span",  {"class" -> "special-character Shah"},  {XML`RawXML["&#61725;"]}],
	"\[Sharp]" -> XMLElement["span",  {"class" -> "special-character Sharp"},  {XML`RawXML["&#9839;"]}],
	"\[ShiftKey]" -> XMLElement["span",  {"class" -> "special-character ShiftKey"},  {XML`RawXML["&#63445;"]}],
	"\[ShortDownArrow]" -> XMLElement["span",  {"class" -> "special-character ShortDownArrow"},  {XML`RawXML["&#62763;"]}],
	"\[ShortLeftArrow]" -> XMLElement["span",  {"class" -> "special-character ShortLeftArrow"},  {XML`RawXML["&#62758;"]}],
	"\[ShortRightArrow]" -> XMLElement["span",  {"class" -> "special-character ShortRightArrow"},  {XML`RawXML["&#62757;"]}],
	"\[ShortUpArrow]" -> XMLElement["span",  {"class" -> "special-character ShortUpArrow"},  {XML`RawXML["&#62762;"]}],
	"\[Sigma]" -> XMLElement["span",  {"class" -> "special-character Sigma"},  {XML`RawXML["&#963;"]}],
	"\[SixPointedStar]" -> XMLElement["span",  {"class" -> "special-character SixPointedStar"},  {XML`RawXML["&#10038;"]}],
	"\[SkeletonIndicator]" -> XMLElement["span",  {"class" -> "special-character SkeletonIndicator"},  {XML`RawXML["&#8259;"]}],
	"\[SmallCircle]" -> XMLElement["span",  {"class" -> "special-character SmallCircle"},  {XML`RawXML["&#8728;"]}],
	"\[SpaceIndicator]" -> XMLElement["span",  {"class" -> "special-character SpaceIndicator"},  {XML`RawXML["&#9251;"]}],
	"\[SpaceKey]" -> XMLElement["span",  {"class" -> "special-character SpaceKey"},  {XML`RawXML["&#63423;"]}],
	"\[SpadeSuit]" -> XMLElement["span",  {"class" -> "special-character SpadeSuit"},  {XML`RawXML["&#9824;"]}],
	"\[SpanFromAbove]" -> XMLElement["span",  {"class" -> "special-character SpanFromAbove"},  {XML`RawXML["&#62395;"]}],
	"\[SpanFromBoth]" -> XMLElement["span",  {"class" -> "special-character SpanFromBoth"},  {XML`RawXML["&#62396;"]}],
	"\[SpanFromLeft]" -> XMLElement["span",  {"class" -> "special-character SpanFromLeft"},  {XML`RawXML["&#62394;"]}],
	"\[SphericalAngle]" -> XMLElement["span",  {"class" -> "special-character SphericalAngle"},  {XML`RawXML["&#8738;"]}],
	"\[Spooky]" -> XMLElement["span",  {"class" -> "special-character Spooky"},  {XML`RawXML["&#63274;"]}],
	"\[Sqrt]" -> XMLElement["span",  {"class" -> "special-character Sqrt"},  {XML`RawXML["&#8730;"]}],
	"\[Square]" -> XMLElement["span",  {"class" -> "special-character Square"},  {XML`RawXML["&#62752;"]}],
	"\[SquareIntersection]" -> XMLElement["span",  {"class" -> "special-character SquareIntersection"},  {XML`RawXML["&#8851;"]}],
	"\[SquareSubset]" -> XMLElement["span",  {"class" -> "special-character SquareSubset"},  {XML`RawXML["&#8847;"]}],
	"\[SquareSubsetEqual]" -> XMLElement["span",  {"class" -> "special-character SquareSubsetEqual"},  {XML`RawXML["&#8849;"]}],
	"\[SquareSuperset]" -> XMLElement["span",  {"class" -> "special-character SquareSuperset"},  {XML`RawXML["&#8848;"]}],
	"\[SquareSupersetEqual]" -> XMLElement["span",  {"class" -> "special-character SquareSupersetEqual"},  {XML`RawXML["&#8850;"]}],
	"\[SquareUnion]" -> XMLElement["span",  {"class" -> "special-character SquareUnion"},  {XML`RawXML["&#8852;"]}],
	"\[Star]" -> XMLElement["span",  {"class" -> "special-character Star"},  {XML`RawXML["&#8902;"]}],
	"\[StepperDown]" -> XMLElement["span",  {"class" -> "special-character StepperDown"},  {XML`RawXML["&#62413;"]}],
	"\[StepperLeft]" -> XMLElement["span",  {"class" -> "special-character StepperLeft"},  {XML`RawXML["&#62411;"]}],
	"\[StepperRight]" -> XMLElement["span",  {"class" -> "special-character StepperRight"},  {XML`RawXML["&#62410;"]}],
	"\[StepperUp]" -> XMLElement["span",  {"class" -> "special-character StepperUp"},  {XML`RawXML["&#62412;"]}],
	"\[Sterling]" -> XMLElement["span",  {"class" -> "special-character Sterling"},  {XML`RawXML["&#163;"]}],
	"\[Stigma]" -> XMLElement["span",  {"class" -> "special-character Stigma"},  {XML`RawXML["&#987;"]}],
	"\[Subset]" -> XMLElement["span",  {"class" -> "special-character Subset"},  {XML`RawXML["&#8834;"]}],
	"\[SubsetEqual]" -> XMLElement["span",  {"class" -> "special-character SubsetEqual"},  {XML`RawXML["&#8838;"]}],
	"\[Succeeds]" -> XMLElement["span",  {"class" -> "special-character Succeeds"},  {XML`RawXML["&#8827;"]}],
	"\[SucceedsEqual]" -> XMLElement["span",  {"class" -> "special-character SucceedsEqual"},  {XML`RawXML["&#10928;"]}],
	"\[SucceedsSlantEqual]" -> XMLElement["span",  {"class" -> "special-character SucceedsSlantEqual"},  {XML`RawXML["&#8829;"]}],
	"\[SucceedsTilde]" -> XMLElement["span",  {"class" -> "special-character SucceedsTilde"},  {XML`RawXML["&#8831;"]}],
	"\[SuchThat]" -> XMLElement["span",  {"class" -> "special-character SuchThat"},  {XML`RawXML["&#8717;"]}],
	"\[Sum]" -> XMLElement["span",  {"class" -> "special-character Sum"},  {XML`RawXML["&#8721;"]}],
	"\[Sun]" -> XMLElement["span",  {"class" -> "special-character Sun"},  {XML`RawXML["&#9737;"]}],
	"\[Superset]" -> XMLElement["span",  {"class" -> "special-character Superset"},  {XML`RawXML["&#8835;"]}],
	"\[SupersetEqual]" -> XMLElement["span",  {"class" -> "special-character SupersetEqual"},  {XML`RawXML["&#8839;"]}],
	"\[SystemEnterKey]" -> XMLElement["span",  {"class" -> "special-character SystemEnterKey"},  {XML`RawXML["&#63327;"]}],
	"\[SystemsModelDelay]" -> XMLElement["span",  {"class" -> "special-character SystemsModelDelay"},  {XML`RawXML["&#62383;"]}],
	"\[SZ]" -> XMLElement["span",  {"class" -> "special-character SZ"},  {XML`RawXML["&#223;"]}],
	"\[TabKey]" -> XMLElement["span",  {"class" -> "special-character TabKey"},  {XML`RawXML["&#63422;"]}],
	"\[Tau]" -> XMLElement["span",  {"class" -> "special-character Tau"},  {XML`RawXML["&#964;"]}],
	"\[TaurusSign]" -> XMLElement["span",  {"class" -> "special-character TaurusSign"},  {XML`RawXML["&#9801;"]}],
	"\[TensorProduct]" -> XMLElement["span",  {"class" -> "special-character TensorProduct"},  {XML`RawXML["&#62426;"]}],
	"\[TensorWedge]" -> XMLElement["span",  {"class" -> "special-character TensorWedge"},  {XML`RawXML["&#62427;"]}],
	"\[THacek]" -> XMLElement["span",  {"class" -> "special-character THacek"},  {XML`RawXML["&#357;"]}],
	"\[Therefore]" -> XMLElement["span",  {"class" -> "special-character Therefore"},  {XML`RawXML["&#8756;"]}],
	"\[Theta]" -> XMLElement["span",  {"class" -> "special-character Theta"},  {XML`RawXML["&#952;"]}],
	"\[ThickSpace]" -> XMLElement["span",  {"class" -> "special-character ThickSpace"},  {XML`RawXML["&#8197;"]}],
	"\[ThinSpace]" -> XMLElement["span",  {"class" -> "special-character ThinSpace"},  {XML`RawXML["&#8201;"]}],
	"\[Thorn]" -> XMLElement["span",  {"class" -> "special-character Thorn"},  {XML`RawXML["&#254;"]}],
	"\[Tilde]" -> XMLElement["span",  {"class" -> "special-character Tilde"},  {XML`RawXML["&#8764;"]}],
	"\[TildeEqual]" -> XMLElement["span",  {"class" -> "special-character TildeEqual"},  {XML`RawXML["&#8771;"]}],
	"\[TildeFullEqual]" -> XMLElement["span",  {"class" -> "special-character TildeFullEqual"},  {XML`RawXML["&#8773;"]}],
	"\[TildeTilde]" -> XMLElement["span",  {"class" -> "special-character TildeTilde"},  {XML`RawXML["&#8776;"]}],
	"\[Times]" -> XMLElement["span",  {"class" -> "special-character Times"},  {XML`RawXML["&#215;"]}],
	"\[Trademark]" -> XMLElement["span",  {"class" -> "special-character Trademark"},  {XML`RawXML["&#8482;"]}],
	"\[Transpose]" -> XMLElement["span",  {"class" -> "special-character Transpose"},  {XML`RawXML["&#62407;"]}],
	"\[TripleDot]" -> XMLElement["span",  {"class" -> "special-character TripleDot"},  {XML`RawXML["&#63320;"]}],
	"\[UAcute]" -> XMLElement["span",  {"class" -> "special-character UAcute"},  {XML`RawXML["&#250;"]}],
	"\[UDoubleAcute]" -> XMLElement["span",  {"class" -> "special-character UDoubleAcute"},  {XML`RawXML["&#369;"]}],
	"\[UDoubleDot]" -> XMLElement["span",  {"class" -> "special-character UDoubleDot"},  {XML`RawXML["&#252;"]}],
	"\[UGrave]" -> XMLElement["span",  {"class" -> "special-character UGrave"},  {XML`RawXML["&#249;"]}],
	"\[UHat]" -> XMLElement["span",  {"class" -> "special-character UHat"},  {XML`RawXML["&#251;"]}],
	"\[UnderBrace]" -> XMLElement["span",  {"class" -> "special-character UnderBrace"},  {XML`RawXML["&#65080;"]}],
	"\[UnderBracket]" -> XMLElement["span",  {"class" -> "special-character UnderBracket"},  {XML`RawXML["&#9141;"]}],
	"\[UnderParenthesis]" -> XMLElement["span",  {"class" -> "special-character UnderParenthesis"},  {XML`RawXML["&#65078;"]}],
	"\[UndirectedEdge]" -> XMLElement["span",  {"class" -> "special-character UndirectedEdge"},  {XML`RawXML["&#62420;"]}],
	"\[Union]" -> XMLElement["span",  {"class" -> "special-character Union"},  {XML`RawXML["&#8899;"]}],
	"\[UnionPlus]" -> XMLElement["span",  {"class" -> "special-character UnionPlus"},  {XML`RawXML["&#8846;"]}],
	"\[UnknownGlyph]" -> XMLElement["span",  {"class" -> "special-character UnknownGlyph"},  {XML`RawXML["&#65533;"]}],
	"\[UpArrow]" -> XMLElement["span",  {"class" -> "special-character UpArrow"},  {XML`RawXML["&#8593;"]}],
	"\[UpArrowBar]" -> XMLElement["span",  {"class" -> "special-character UpArrowBar"},  {XML`RawXML["&#10514;"]}],
	"\[UpArrowDownArrow]" -> XMLElement["span",  {"class" -> "special-character UpArrowDownArrow"},  {XML`RawXML["&#8645;"]}],
	"\[UpDownArrow]" -> XMLElement["span",  {"class" -> "special-character UpDownArrow"},  {XML`RawXML["&#8597;"]}],
	"\[UpEquilibrium]" -> XMLElement["span",  {"class" -> "special-character UpEquilibrium"},  {XML`RawXML["&#10606;"]}],
	"\[UpperLeftArrow]" -> XMLElement["span",  {"class" -> "special-character UpperLeftArrow"},  {XML`RawXML["&#8598;"]}],
	"\[UpperRightArrow]" -> XMLElement["span",  {"class" -> "special-character UpperRightArrow"},  {XML`RawXML["&#8599;"]}],
	"\[UpPointer]" -> XMLElement["span",  {"class" -> "special-character UpPointer"},  {XML`RawXML["&#9652;"]}],
	"\[Upsilon]" -> XMLElement["span",  {"class" -> "special-character Upsilon"},  {XML`RawXML["&#965;"]}],
	"\[UpTee]" -> XMLElement["span",  {"class" -> "special-character UpTee"},  {XML`RawXML["&#8869;"]}],
	"\[UpTeeArrow]" -> XMLElement["span",  {"class" -> "special-character UpTeeArrow"},  {XML`RawXML["&#8613;"]}],
	"\[Uranus]" -> XMLElement["span",  {"class" -> "special-character Uranus"},  {XML`RawXML["&#9954;"]}],
	"\[URing]" -> XMLElement["span",  {"class" -> "special-character URing"},  {XML`RawXML["&#367;"]}],
	"\[Vee]" -> XMLElement["span",  {"class" -> "special-character Vee"},  {XML`RawXML["&#8897;"]}],
	"\[Venus]" -> XMLElement["span",  {"class" -> "special-character Venus"},  {XML`RawXML["&#9792;"]}],
	"\[VerticalBar]" -> XMLElement["span",  {"class" -> "special-character VerticalBar"},  {XML`RawXML["&#62416;"]}],
	"\[VerticalEllipsis]" -> XMLElement["span",  {"class" -> "special-character VerticalEllipsis"},  {XML`RawXML["&#8942;"]}],
	"\[VerticalLine]" -> XMLElement["span",  {"class" -> "special-character VerticalLine"},  {XML`RawXML["&#9474;"]}],
	"\[VerticalSeparator]" -> XMLElement["span",  {"class" -> "special-character VerticalSeparator"},  {XML`RawXML["&#62514;"]}],
	"\[VerticalTilde]" -> XMLElement["span",  {"class" -> "special-character VerticalTilde"},  {XML`RawXML["&#8768;"]}],
	"\[VeryThinSpace]" -> XMLElement["span",  {"class" -> "special-character VeryThinSpace"},  {XML`RawXML["&#8202;"]}],
	"\[Villa]" -> XMLElement["span",  {"class" -> "special-character Villa"},  {XML`RawXML["&#63271;"]}],
	"\[VirgoSign]" -> XMLElement["span",  {"class" -> "special-character VirgoSign"},  {XML`RawXML["&#9805;"]}],
	"\[WarningSign]" -> XMLElement["span",  {"class" -> "special-character WarningSign"},  {XML`RawXML["&#63269;"]}],
	"\[WatchIcon]" -> XMLElement["span",  {"class" -> "special-character WatchIcon"},  {XML`RawXML["&#8986;"]}],
	"\[Wedge]" -> XMLElement["span",  {"class" -> "special-character Wedge"},  {XML`RawXML["&#8896;"]}],
	"\[WeierstrassP]" -> XMLElement["span",  {"class" -> "special-character WeierstrassP"},  {XML`RawXML["&#8472;"]}],
	"\[WhiteBishop]" -> XMLElement["span",  {"class" -> "special-character WhiteBishop"},  {XML`RawXML["&#9815;"]}],
	"\[WhiteKing]" -> XMLElement["span",  {"class" -> "special-character WhiteKing"},  {XML`RawXML["&#9812;"]}],
	"\[WhiteKnight]" -> XMLElement["span",  {"class" -> "special-character WhiteKnight"},  {XML`RawXML["&#9816;"]}],
	"\[WhitePawn]" -> XMLElement["span",  {"class" -> "special-character WhitePawn"},  {XML`RawXML["&#9817;"]}],
	"\[WhiteQueen]" -> XMLElement["span",  {"class" -> "special-character WhiteQueen"},  {XML`RawXML["&#9813;"]}],
	"\[WhiteRook]" -> XMLElement["span",  {"class" -> "special-character WhiteRook"},  {XML`RawXML["&#9814;"]}],
	"\[Wolf]" -> XMLElement["span",  {"class" -> "special-character Wolf"},  {XML`RawXML["&#63264;"]}],
	"\[WolframLanguageLogo]" -> XMLElement["span",  {"class" -> "special-character WolframLanguageLogo"},  {XML`RawXML["&#61726;"]}],
	"\[WolframLanguageLogoCircle]" -> XMLElement["span",  {"class" -> "special-character WolframLanguageLogoCircle"},  {XML`RawXML["&#61727;"]}],
	"\[Xi]" -> XMLElement["span",  {"class" -> "special-character Xi"},  {XML`RawXML["&#958;"]}],
	"\[Xnor]" -> XMLElement["span",  {"class" -> "special-character Xnor"},  {XML`RawXML["&#62626;"]}],
	"\[Xor]" -> XMLElement["span",  {"class" -> "special-character Xor"},  {XML`RawXML["&#8891;"]}],
	"\[YAcute]" -> XMLElement["span",  {"class" -> "special-character YAcute"},  {XML`RawXML["&#253;"]}],
	"\[YDoubleDot]" -> XMLElement["span",  {"class" -> "special-character YDoubleDot"},  {XML`RawXML["&#255;"]}],
	"\[Yen]" -> XMLElement["span",  {"class" -> "special-character Yen"},  {XML`RawXML["&#165;"]}],
	"\[Zeta]" -> XMLElement["span",  {"class" -> "special-character Zeta"},  {XML`RawXML["&#950;"]}],
	"\[ZHacek]" -> XMLElement["span",  {"class" -> "special-character ZHacek"},  {XML`RawXML["&#382;"]}]
      }

EndPackage[]
