/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.rtf;

import org.apache.fop.apps.FOPException;
import org.apache.fop.datatypes.ColorType;
import org.apache.fop.datatypes.Length;
import org.apache.fop.fo.FONode;
import org.apache.fop.fo.FOText;
import org.apache.fop.fo.flow.Block;
import org.apache.fop.fo.flow.BlockContainer;
import org.apache.fop.fo.flow.Inline;
import org.apache.fop.fo.flow.PageNumber;
import org.apache.fop.fo.properties.ColorTypeProperty;
import org.apache.fop.fo.properties.CommonBorderPaddingBackground;
import org.apache.fop.fo.properties.CommonFont;
import org.apache.fop.fo.properties.CommonMarginBlock;
import org.apache.fop.fo.properties.CommonTextDecoration;
import org.apache.fop.render.rtf.BorderAttributesConverter;
import org.apache.fop.render.rtf.FOPRtfAttributes;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfAttributes;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfColorTable;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfFontManager;

class TextAttributesConverter {
    TextAttributesConverter() {
    }

    public static RtfAttributes convertAttributes(Block fobj) throws FOPException {
        FOPRtfAttributes attrib = new FOPRtfAttributes();
        TextAttributesConverter.attrFont(fobj.getCommonFont(), attrib);
        TextAttributesConverter.attrFontColor(fobj.getColor(), attrib);
        TextAttributesConverter.attrBlockBackgroundColor(fobj.getCommonBorderPaddingBackground(), attrib);
        TextAttributesConverter.attrBlockMargin(fobj.getCommonMarginBlock(), attrib);
        TextAttributesConverter.attrBlockTextAlign(fobj.getTextAlign(), attrib);
        TextAttributesConverter.attrBorder(fobj.getCommonBorderPaddingBackground(), attrib, fobj);
        return attrib;
    }

    public static RtfAttributes convertBlockContainerAttributes(BlockContainer fobj) throws FOPException {
        FOPRtfAttributes attrib = new FOPRtfAttributes();
        TextAttributesConverter.attrBackgroundColor(fobj.getCommonBorderPaddingBackground(), attrib);
        TextAttributesConverter.attrBlockMargin(fobj.getCommonMarginBlock(), attrib);
        TextAttributesConverter.attrBorder(fobj.getCommonBorderPaddingBackground(), attrib, fobj);
        return attrib;
    }

    public static RtfAttributes convertCharacterAttributes(FOText fobj) throws FOPException {
        FOPRtfAttributes attrib = new FOPRtfAttributes();
        TextAttributesConverter.attrFont(fobj.getCommonFont(), attrib);
        TextAttributesConverter.attrFontColor(fobj.getColor(), attrib);
        TextAttributesConverter.attrTextDecoration(fobj.getTextDecoration(), attrib);
        TextAttributesConverter.attrBaseLineShift(fobj.getBaseLineShift(), attrib);
        return attrib;
    }

    public static RtfAttributes convertCharacterAttributes(PageNumber fobj) throws FOPException {
        FOPRtfAttributes attrib = new FOPRtfAttributes();
        TextAttributesConverter.attrFont(fobj.getCommonFont(), attrib);
        TextAttributesConverter.attrTextDecoration(fobj.getTextDecoration(), attrib);
        TextAttributesConverter.attrBackgroundColor(fobj.getCommonBorderPaddingBackground(), attrib);
        return attrib;
    }

    public static RtfAttributes convertCharacterAttributes(Inline fobj) throws FOPException {
        FOPRtfAttributes attrib = new FOPRtfAttributes();
        TextAttributesConverter.attrFont(fobj.getCommonFont(), attrib);
        TextAttributesConverter.attrFontColor(fobj.getColor(), attrib);
        TextAttributesConverter.attrBackgroundColor(fobj.getCommonBorderPaddingBackground(), attrib);
        TextAttributesConverter.attrInlineBorder(fobj.getCommonBorderPaddingBackground(), attrib);
        return attrib;
    }

    private static void attrFont(CommonFont font, FOPRtfAttributes rtfAttr) {
        rtfAttr.set("f", RtfFontManager.getInstance().getFontNumber(font.getFirstFontFamily()));
        rtfAttr.setHalfPoints("fs", font.fontSize);
        if (font.fontWeight == 174 || font.fontWeight == 175 || font.fontWeight == 176) {
            rtfAttr.set("b", 1);
        } else {
            rtfAttr.set("b", 0);
        }
        if (font.fontStyle == 164) {
            rtfAttr.set("i", 1);
        } else {
            rtfAttr.set("i", 0);
        }
    }

    private static void attrFontColor(ColorType colorType, RtfAttributes rtfAttr) {
        if (colorType != null && (colorType.getAlpha() != 0.0f || colorType.getRed() != 0.0f || colorType.getGreen() != 0.0f || colorType.getBlue() != 0.0f)) {
            rtfAttr.set("cf", TextAttributesConverter.convertFOPColorToRTF(colorType));
        }
    }

    private static void attrTextDecoration(CommonTextDecoration textDecoration, RtfAttributes rtfAttr) {
        if (textDecoration == null) {
            return;
        }
        if (textDecoration.hasUnderline()) {
            rtfAttr.set("ul", 1);
        } else {
            rtfAttr.set("ul", 0);
        }
        if (textDecoration.hasLineThrough()) {
            rtfAttr.set("strike", 1);
        } else {
            rtfAttr.set("strike", 0);
        }
    }

    private static void attrBlockMargin(CommonMarginBlock cmb, FOPRtfAttributes rtfAttr) {
        rtfAttr.setTwips("sb", cmb.spaceBefore.getOptimum(null).getLength());
        rtfAttr.setTwips("sa", cmb.spaceAfter.getOptimum(null).getLength());
        rtfAttr.setTwips("li", cmb.startIndent);
        rtfAttr.setTwips("ri", cmb.endIndent);
    }

    private static void attrBlockTextAlign(int alignment, RtfAttributes rtfAttr) {
        String rtfValue = null;
        switch (alignment) {
            case 23: {
                rtfValue = "qc";
                break;
            }
            case 39: {
                rtfValue = "qr";
                break;
            }
            case 70: {
                rtfValue = "qj";
                break;
            }
            default: {
                rtfValue = "ql";
            }
        }
        rtfAttr.set(rtfValue);
    }

    private static void attrBlockBackgroundColor(CommonBorderPaddingBackground bpb, RtfAttributes rtfAttr) {
        if (bpb.hasBackground()) {
            rtfAttr.set("shading", 10000);
            rtfAttr.set("cfpat", TextAttributesConverter.convertFOPColorToRTF(bpb.backgroundColor));
        }
    }

    private static void attrBorder(CommonBorderPaddingBackground bpb, RtfAttributes rtfAttr, FONode fobj) {
        if (TextAttributesConverter.hasBorder(fobj.getParent())) {
            TextAttributesConverter.attrInlineBorder(bpb, rtfAttr);
            return;
        }
        BorderAttributesConverter.makeBorder(bpb, 0, rtfAttr, "brdrt");
        BorderAttributesConverter.makeBorder(bpb, 1, rtfAttr, "brdrb");
        BorderAttributesConverter.makeBorder(bpb, 2, rtfAttr, "brdrl");
        BorderAttributesConverter.makeBorder(bpb, 3, rtfAttr, "brdrr");
    }

    private static boolean hasBorder(FONode node) {
        while (node != null) {
            CommonBorderPaddingBackground commonBorderPaddingBackground = null;
            if (node instanceof Block) {
                Block block = (Block)node;
                commonBorderPaddingBackground = block.getCommonBorderPaddingBackground();
            } else if (node instanceof BlockContainer) {
                BlockContainer container = (BlockContainer)node;
                commonBorderPaddingBackground = container.getCommonBorderPaddingBackground();
            }
            if (commonBorderPaddingBackground != null && commonBorderPaddingBackground.hasBorder()) {
                return true;
            }
            node = node.getParent();
        }
        return false;
    }

    private static void attrInlineBorder(CommonBorderPaddingBackground bpb, RtfAttributes rtfAttr) {
        BorderAttributesConverter.makeBorder(bpb, 0, rtfAttr, "chbrdr");
    }

    private static void attrBackgroundColor(CommonBorderPaddingBackground bpb, RtfAttributes rtfAttr) {
        ColorType fopValue = bpb.backgroundColor;
        int rtfColor = 0;
        if (fopValue == null || fopValue.getRed() == 0.0f && fopValue.getGreen() == 0.0f && fopValue.getBlue() == 0.0f && fopValue.getAlpha() == 0.0f) {
            return;
        }
        rtfColor = TextAttributesConverter.convertFOPColorToRTF(fopValue);
        rtfAttr.set("chcbpat", rtfColor);
    }

    private static void attrBaseLineShift(Length baselineShift, RtfAttributes rtfAttr) {
        int s = baselineShift.getEnum();
        if (s == 138) {
            rtfAttr.set("super");
        } else if (s == 137) {
            rtfAttr.set("sub");
        }
    }

    public static int convertFOPColorToRTF(ColorType fopColor) {
        int redComponent = ColorTypeProperty.convertChannelToInteger(fopColor.getRed());
        int greenComponent = ColorTypeProperty.convertChannelToInteger(fopColor.getGreen());
        int blueComponent = ColorTypeProperty.convertChannelToInteger(fopColor.getBlue());
        return RtfColorTable.getInstance().getColorNumber(redComponent, greenComponent, blueComponent);
    }
}

