/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.rtf;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.impl.SimpleLog;
import org.apache.fop.apps.FOPException;
import org.apache.fop.datatypes.ColorType;
import org.apache.fop.fo.flow.Table;
import org.apache.fop.fo.flow.TableBody;
import org.apache.fop.fo.flow.TableCell;
import org.apache.fop.fo.flow.TableRow;
import org.apache.fop.fo.properties.CommonBorderPaddingBackground;
import org.apache.fop.render.rtf.BorderAttributesConverter;
import org.apache.fop.render.rtf.FOPRtfAttributes;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfAttributes;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfColorTable;

public class TableAttributesConverter {
    private static Log log = new SimpleLog("FOP/RTF");

    private TableAttributesConverter() {
    }

    static RtfAttributes convertTableAttributes(Table fobj) throws FOPException {
        FOPRtfAttributes attrib = new FOPRtfAttributes();
        attrib.setTwips("trleft", fobj.getCommonMarginBlock().marginLeft);
        return attrib;
    }

    static RtfAttributes convertTableBodyAttributes(TableBody fobj) throws FOPException {
        FOPRtfAttributes attrib = new FOPRtfAttributes();
        return attrib;
    }

    static RtfAttributes convertCellAttributes(TableCell fobj) throws FOPException {
        int n;
        int padding;
        RtfColorTable colorTable = RtfColorTable.getInstance();
        FOPRtfAttributes attrib = new FOPRtfAttributes();
        boolean isBorderPresent = false;
        CommonBorderPaddingBackground border = fobj.getCommonBorderPaddingBackground();
        ColorType color = border.backgroundColor;
        if (color != null && (color.getAlpha() != 0.0f || color.getRed() != 0.0f || color.getGreen() != 0.0f || color.getBlue() != 0.0f)) {
            attrib.set("clcbpat", color);
        }
        BorderAttributesConverter.makeBorder(border, 0, attrib, "clbrdrt");
        BorderAttributesConverter.makeBorder(border, 1, attrib, "clbrdrb");
        BorderAttributesConverter.makeBorder(border, 2, attrib, "clbrdrl");
        BorderAttributesConverter.makeBorder(border, 3, attrib, "clbrdrr");
        boolean reproduceMSWordBug = true;
        if (reproduceMSWordBug) {
            padding = border.getPaddingStart(false, null);
            if (padding != 0) {
                attrib.setTwips("clpadt", padding);
                attrib.set("clpadft", 3);
            }
            if ((padding = border.getPaddingBefore(false, null)) != 0) {
                attrib.setTwips("clpadl", padding);
                attrib.set("clpadfl", 3);
            }
        } else {
            padding = border.getPaddingStart(false, null);
            if (padding != 0) {
                attrib.setTwips("clpadl", padding);
                attrib.set("clpadfl", 3);
            }
            if ((padding = border.getPaddingBefore(false, null)) != 0) {
                attrib.setTwips("clpadt", padding);
                attrib.set("clpadft", 3);
            }
        }
        if ((padding = border.getPaddingEnd(false, null)) != 0) {
            attrib.setTwips("clpadr", padding);
            attrib.set("clpadfr", 3);
        }
        if ((padding = border.getPaddingAfter(false, null)) != 0) {
            attrib.setTwips("clpadb", padding);
            attrib.set("clpadfb", 3);
        }
        if ((n = fobj.getNumberColumnsSpanned()) > 1) {
            attrib.set("number-columns-spanned", n);
        }
        return attrib;
    }

    static RtfAttributes convertRowAttributes(TableRow fobj, RtfAttributes rtfatts) throws FOPException {
        RtfColorTable colorTable = RtfColorTable.getInstance();
        RtfAttributes attrib = null;
        attrib = rtfatts == null ? new RtfAttributes() : rtfatts;
        boolean isBorderPresent = false;
        if (fobj.getKeepTogether().getWithinPage().getEnum() == 7) {
            attrib.set("trkeep");
        }
        if (fobj.getKeepWithNext().getWithinPage().getEnum() == 7) {
            attrib.set("knext");
        }
        if (fobj.getKeepWithPrevious().getWithinPage().getEnum() == 7) {
            attrib.set("kprevious");
        }
        if (fobj.getHeight().getEnum() != 9) {
            attrib.set("trrh", fobj.getHeight().getValue() / 50);
        }
        CommonBorderPaddingBackground border = fobj.getCommonBorderPaddingBackground();
        BorderAttributesConverter.makeBorder(border, 0, attrib, "clbrdrt");
        BorderAttributesConverter.makeBorder(border, 1, attrib, "clbrdrb");
        BorderAttributesConverter.makeBorder(border, 2, attrib, "clbrdrl");
        BorderAttributesConverter.makeBorder(border, 3, attrib, "clbrdrr");
        return attrib;
    }
}

