/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.rtf;

import org.apache.fop.fo.properties.CommonBorderPaddingBackground;
import org.apache.fop.render.rtf.FOPRtfAttributes;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfAttributes;

public class BorderAttributesConverter {
    public static void makeBorder(CommonBorderPaddingBackground border, int side, RtfAttributes attributes, String controlWord) {
        int styleEnum = border.getBorderStyle(side);
        if (styleEnum != 95) {
            FOPRtfAttributes attrs = new FOPRtfAttributes();
            attrs.set("brdrcf", border.getBorderColor(side));
            attrs.set(BorderAttributesConverter.convertAttributetoRtf(styleEnum));
            attrs.set("brdrw", border.getBorderWidth(side, false) / 50);
            attributes.set(controlWord, attrs);
            attrs.setTwips("brsp", border.getPadding(side, false, null));
            attributes.set(controlWord, attrs);
        } else {
            double paddingPt = (double)border.getPadding(side, false, null) / 1000.0;
            int padding = (int)Math.round(paddingPt * 20.0);
            if (side == 0) {
                attributes.addIntegerValue(padding, "sb");
            } else if (side == 1) {
                attributes.addIntegerValue(padding, "sa");
            }
        }
    }

    public static String convertAttributetoRtf(int iBorderStyle) {
        if (iBorderStyle == 95) {
            return "brdrnil";
        }
        if (iBorderStyle == 133) {
            return "brdrs";
        }
        if (iBorderStyle == 37) {
            return "brdrdb";
        }
        if (iBorderStyle == 36) {
            return "brdrdot";
        }
        if (iBorderStyle == 31) {
            return "brdrdash";
        }
        return null;
    }
}

