/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.ps;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.image.EPSImage;
import org.apache.fop.image.FopImage;
import org.apache.fop.image.JpegImage;
import org.apache.fop.render.ps.PSGenerator;
import org.apache.fop.render.ps.PSProcSets;
import org.apache.fop.render.ps.PSResource;
import org.apache.fop.util.ASCII85OutputStream;
import org.apache.fop.util.Finalizable;
import org.apache.fop.util.FlateEncodeOutputStream;
import org.apache.fop.util.RunLengthEncodeOutputStream;

public class PSImageUtils {
    protected static Log log = LogFactory.getLog((Class)(class$org$apache$fop$render$ps$PSImageUtils == null ? (class$org$apache$fop$render$ps$PSImageUtils = PSImageUtils.class$("org.apache.fop.render.ps.PSImageUtils")) : class$org$apache$fop$render$ps$PSImageUtils));
    static /* synthetic */ Class class$org$apache$fop$render$ps$PSImageUtils;

    public static void renderBitmapImage(FopImage img, float x, float y, float w, float h, PSGenerator gen) throws IOException {
        if (img instanceof JpegImage) {
            if (!img.load(2)) {
                gen.commentln("%JPEG image could not be processed: " + img);
                return;
            }
        } else if (!img.load(4)) {
            gen.commentln("%Bitmap image could not be processed: " + img);
            return;
        }
        boolean iscolor = img.getColorSpace().getType() != 1003;
        byte[] imgmap = img.getBitmapsSize() > 0 ? img.getBitmaps() : img.getRessourceBytes();
        gen.saveGraphicsState();
        gen.writeln(x + " " + y + " translate");
        gen.writeln(w + " " + h + " scale");
        gen.commentln("%FOPBeginBitmap: " + img.getMimeType() + " " + img.getOriginalURI());
        if (img.getColorSpace().getType() == 9) {
            gen.writeln("/DeviceCMYK setcolorspace");
        } else if (img.getColorSpace().getType() == 1003) {
            gen.writeln("/DeviceGray setcolorspace");
        } else {
            gen.writeln("/DeviceRGB setcolorspace");
        }
        gen.writeln("{{");
        if (img instanceof JpegImage) {
            gen.writeln("/RawData currentfile /ASCII85Decode filter def");
            gen.writeln("/Data RawData << >> /DCTDecode filter def");
        } else if (gen.getPSLevel() >= 3) {
            gen.writeln("/RawData currentfile /ASCII85Decode filter def");
            gen.writeln("/Data RawData /FlateDecode filter def");
        } else {
            gen.writeln("/RawData currentfile /ASCII85Decode filter def");
            gen.writeln("/Data RawData /RunLengthDecode filter def");
        }
        gen.writeln("<<");
        gen.writeln("  /ImageType 1");
        gen.writeln("  /Width " + img.getWidth());
        gen.writeln("  /Height " + img.getHeight());
        gen.writeln("  /BitsPerComponent 8");
        if (img.getColorSpace().getType() == 9) {
            gen.writeln("  /Decode [0 1 0 1 0 1 0 1]");
        } else if (iscolor) {
            gen.writeln("  /Decode [0 1 0 1 0 1]");
        } else {
            gen.writeln("  /Decode [0 1]");
        }
        gen.writeln("  /ImageMatrix [" + img.getWidth() + " 0 0 " + img.getHeight() + " 0 0]");
        gen.writeln("  /DataSource Data");
        gen.writeln(">>");
        gen.writeln("image");
        gen.writeln("} stopped {handleerror} if");
        gen.writeln("  RawData flushfile");
        gen.writeln("} exec");
        OutputStream out = gen.getOutputStream();
        out = new ASCII85OutputStream(out);
        if (!(img instanceof JpegImage)) {
            out = gen.getPSLevel() >= 3 ? new FlateEncodeOutputStream(out) : new RunLengthEncodeOutputStream(out);
        }
        out.write(imgmap);
        if (out instanceof Finalizable) {
            ((Finalizable)((Object)out)).finalizeStream();
        } else {
            out.flush();
        }
        gen.writeln("");
        gen.commentln("%FOPEndBitmap");
        gen.restoreGraphicsState();
    }

    public static void renderEPS(EPSImage img, float x, float y, float w, float h, PSGenerator gen) {
        try {
            if (!img.load(2)) {
                gen.commentln("%EPS image could not be processed: " + img);
                return;
            }
            int[] bbox = img.getBBox();
            int bboxw = bbox[2] - bbox[0];
            int bboxh = bbox[3] - bbox[1];
            String name = img.getDocName();
            if (name == null || name.length() == 0) {
                name = img.getOriginalURI();
            }
            PSImageUtils.renderEPS(img.getEPSImage(), name, x, y, w, h, bbox[0], bbox[1], bboxw, bboxh, gen);
        }
        catch (Exception e) {
            log.error((Object)("PSRenderer.renderImageArea(): Error rendering bitmap (" + e.getMessage() + ")"), (Throwable)e);
        }
    }

    public static void renderEPS(byte[] rawEPS, String name, float x, float y, float w, float h, int bboxx, int bboxy, int bboxw, int bboxh, PSGenerator gen) throws IOException {
        gen.notifyResourceUsage(PSProcSets.EPS_PROCSET, false);
        gen.writeln("%FOPBeginEPS: " + name);
        gen.writeln("BeginEPSF");
        gen.writeln(gen.formatDouble(x) + " " + gen.formatDouble(y) + " translate");
        gen.writeln("0 " + gen.formatDouble(h) + " translate");
        gen.writeln("1 -1 scale");
        float sx = w / (float)bboxw;
        float sy = h / (float)bboxh;
        if (sx != 1.0f || sy != 1.0f) {
            gen.writeln(gen.formatDouble(sx) + " " + gen.formatDouble(sy) + " scale");
        }
        if (bboxx != 0 || bboxy != 0) {
            gen.writeln(gen.formatDouble(-bboxx) + " " + gen.formatDouble(-bboxy) + " translate");
        }
        gen.writeln(gen.formatDouble(bboxy) + " " + gen.formatDouble(bboxy) + " " + gen.formatDouble(bboxw) + " " + gen.formatDouble(bboxh) + " re clip");
        gen.writeln("newpath");
        PSResource res = new PSResource("file", name);
        gen.notifyResourceUsage(res, false);
        gen.writeDSCComment("BeginDocument", res.getName());
        gen.writeByteArr(rawEPS);
        gen.writeDSCComment("EndDocument");
        gen.writeln("EndEPSF");
        gen.writeln("%FOPEndEPS");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

