/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.layoutmgr;

import java.util.LinkedList;
import java.util.List;
import org.apache.fop.area.Area;
import org.apache.fop.area.Block;
import org.apache.fop.area.RegionReference;
import org.apache.fop.fo.pagination.PageSequence;
import org.apache.fop.fo.pagination.SideRegion;
import org.apache.fop.fo.pagination.StaticContent;
import org.apache.fop.layoutmgr.AbstractBreaker;
import org.apache.fop.layoutmgr.AreaAdditionUtil;
import org.apache.fop.layoutmgr.BlockStackingLayoutManager;
import org.apache.fop.layoutmgr.ElementListObserver;
import org.apache.fop.layoutmgr.LayoutContext;
import org.apache.fop.layoutmgr.LayoutManager;
import org.apache.fop.layoutmgr.PageBreakingAlgorithm;
import org.apache.fop.layoutmgr.PageSequenceLayoutManager;
import org.apache.fop.layoutmgr.PositionIterator;
import org.apache.fop.layoutmgr.SpaceResolver;

public class StaticContentLayoutManager
extends BlockStackingLayoutManager {
    private RegionReference targetRegion;
    private Block targetBlock;
    private SideRegion regionFO;
    private int contentAreaIPD = 0;
    private int contentAreaBPD = -1;

    public StaticContentLayoutManager(PageSequenceLayoutManager pslm, StaticContent node, SideRegion reg) {
        super(node);
        this.setParent(pslm);
        this.regionFO = reg;
        this.targetRegion = this.getCurrentPV().getRegionReference(this.regionFO.getNameId());
    }

    public StaticContentLayoutManager(PageSequenceLayoutManager pslm, StaticContent node, Block block) {
        super(node);
        this.setParent(pslm);
        this.targetBlock = block;
    }

    public LinkedList getNextKnuthElements(LayoutContext context, int alignment) {
        throw new UnsupportedOperationException("Shouldn't this method be emptied because it's never called at all?");
    }

    public void addAreas(PositionIterator parentIter, LayoutContext layoutContext) {
        AreaAdditionUtil.addAreas(this, parentIter, layoutContext);
        this.flush();
        this.targetRegion = null;
    }

    public void addChildArea(Area childArea) {
        if (this.getStaticContentFO().getFlowName().equals("xsl-footnote-separator")) {
            this.targetBlock.addBlock((Block)childArea);
        } else {
            this.targetRegion.addBlock((Block)childArea);
        }
    }

    public Area getParentArea(Area childArea) {
        if (this.getStaticContentFO().getFlowName().equals("xsl-footnote-separator")) {
            return this.targetBlock;
        }
        return this.targetRegion;
    }

    public void doLayout() {
        int targetIPD = 0;
        int targetBPD = 0;
        int targetAlign = 9;
        boolean autoHeight = false;
        if (this.getStaticContentFO().getFlowName().equals("xsl-footnote-separator")) {
            targetIPD = this.targetBlock.getIPD();
            targetBPD = this.targetBlock.getBPD();
            if (targetBPD == 0) {
                autoHeight = true;
            }
            targetAlign = 13;
        } else {
            targetIPD = this.targetRegion.getIPD();
            targetBPD = this.targetRegion.getBPD();
            targetAlign = this.regionFO.getDisplayAlign();
        }
        this.setContentAreaIPD(targetIPD);
        this.setContentAreaBPD(targetBPD);
        StaticContentBreaker breaker = new StaticContentBreaker(this, targetIPD, targetAlign);
        breaker.doLayout(targetBPD, autoHeight);
        if (breaker.isOverflow() && !autoHeight) {
            if (this.regionFO.getOverflow() == 42) {
                // empty if block
            }
            log.warn((Object)"static-content overflows the available area.");
        }
    }

    protected StaticContent getStaticContentFO() {
        return (StaticContent)this.fobj;
    }

    public int getContentAreaIPD() {
        return this.contentAreaIPD;
    }

    protected void setContentAreaIPD(int contentAreaIPD) {
        this.contentAreaIPD = contentAreaIPD;
    }

    public int getContentAreaBPD() {
        return this.contentAreaBPD;
    }

    private void setContentAreaBPD(int contentAreaBPD) {
        this.contentAreaBPD = contentAreaBPD;
    }

    private class StaticContentBreaker
    extends AbstractBreaker {
        private StaticContentLayoutManager lm;
        private int displayAlign;
        private int ipd;
        private boolean overflow = false;

        public StaticContentBreaker(StaticContentLayoutManager lm, int ipd, int displayAlign) {
            this.lm = lm;
            this.ipd = ipd;
            this.displayAlign = displayAlign;
        }

        protected void observeElementList(List elementList) {
            String elementListID = StaticContentLayoutManager.this.getStaticContentFO().getFlowName();
            String pageSequenceID = ((PageSequence)this.lm.getParent().getFObj()).getId();
            if (pageSequenceID != null && pageSequenceID.length() > 0) {
                elementListID = elementListID + "-" + pageSequenceID;
            }
            ElementListObserver.observe(elementList, "static-content", elementListID);
        }

        protected boolean isPartOverflowRecoveryActivated() {
            return false;
        }

        public boolean isOverflow() {
            return this.overflow;
        }

        protected LayoutManager getTopLevelLM() {
            return this.lm;
        }

        protected LayoutContext createLayoutContext() {
            LayoutContext lc = super.createLayoutContext();
            lc.setRefIPD(this.ipd);
            return lc;
        }

        protected LinkedList getNextKnuthElements(LayoutContext context, int alignment) {
            LayoutManager curLM;
            LinkedList returnList = new LinkedList();
            while ((curLM = StaticContentLayoutManager.this.getChildLM()) != null) {
                LayoutContext childLC = new LayoutContext(0);
                childLC.setStackLimit(context.getStackLimit());
                childLC.setRefIPD(context.getRefIPD());
                childLC.setWritingMode(context.getWritingMode());
                LinkedList returnedList = null;
                if (!curLM.isFinished()) {
                    returnedList = curLM.getNextKnuthElements(childLC, alignment);
                }
                if (returnedList == null) continue;
                this.lm.wrapPositionElements(returnedList, returnList);
            }
            SpaceResolver.resolveElementList(returnList);
            StaticContentLayoutManager.this.setFinished(true);
            return returnList;
        }

        protected int getCurrentDisplayAlign() {
            return this.displayAlign;
        }

        protected boolean hasMoreContent() {
            return !this.lm.isFinished();
        }

        protected void addAreas(PositionIterator posIter, LayoutContext context) {
            AreaAdditionUtil.addAreas(this.lm, posIter, context);
        }

        protected void doPhase3(PageBreakingAlgorithm alg, int partCount, AbstractBreaker.BlockSequence originalList, AbstractBreaker.BlockSequence effectiveList) {
            this.addAreas(alg, partCount, originalList, effectiveList);
            if (partCount > 1) {
                this.overflow = true;
            }
        }

        protected void finishPart(PageBreakingAlgorithm alg, AbstractBreaker.PageBreakPosition pbp) {
        }

        protected LayoutManager getCurrentChildLM() {
            return null;
        }
    }
}

