/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.layoutmgr;

import java.util.ArrayList;
import org.apache.fop.layoutmgr.KnuthElement;
import org.apache.fop.layoutmgr.KnuthGlue;
import org.apache.fop.layoutmgr.KnuthPenalty;
import org.apache.fop.layoutmgr.Position;

public class KnuthSequence
extends ArrayList {
    public int ignoreAtStart = 0;
    public int ignoreAtEnd = 0;
    private boolean isInlineSequence = false;

    public KnuthSequence() {
    }

    public KnuthSequence(boolean isInlineSequence) {
        this.isInlineSequence = isInlineSequence;
    }

    public void startSequence() {
    }

    public KnuthSequence endSequence() {
        return this.endSequence(null);
    }

    public KnuthSequence endSequence(Position breakPosition) {
        while (this.size() > this.ignoreAtStart && !((KnuthElement)this.get(this.size() - 1)).isBox()) {
            this.remove(this.size() - 1);
        }
        if (this.size() > this.ignoreAtStart) {
            this.add(new KnuthPenalty(0, 1000, false, null, false));
            this.add(new KnuthGlue(0, 10000000, 0, null, false));
            this.add(new KnuthPenalty(0, -1000, false, breakPosition, false));
            this.ignoreAtEnd = 3;
            return this;
        }
        this.clear();
        return null;
    }

    public KnuthElement getLast() {
        int idx = this.size();
        if (idx == 0) {
            return null;
        }
        return (KnuthElement)this.get(idx - 1);
    }

    public KnuthElement removeLast() {
        int idx = this.size();
        if (idx == 0) {
            return null;
        }
        return (KnuthElement)this.remove(idx - 1);
    }

    public KnuthElement getElement(int index) {
        return (KnuthElement)this.get(index);
    }

    public boolean isInlineSequence() {
        return this.isInlineSequence;
    }
}

