/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.hyphenation;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.hyphenation.Hyphenation;
import org.apache.fop.hyphenation.HyphenationException;
import org.apache.fop.hyphenation.HyphenationTree;

public class Hyphenator {
    protected static Log log = LogFactory.getLog((Class)(class$org$apache$fop$hyphenation$Hyphenator == null ? (class$org$apache$fop$hyphenation$Hyphenator = Hyphenator.class$("org.apache.fop.hyphenation.Hyphenator")) : class$org$apache$fop$hyphenation$Hyphenator));
    private static Hashtable hyphenTrees = new Hashtable();
    private static Set missingHyphenationTrees;
    private HyphenationTree hyphenTree = null;
    private int remainCharCount = 2;
    private int pushCharCount = 2;
    private static boolean errorDump;
    static /* synthetic */ Class class$org$apache$fop$hyphenation$Hyphenator;
    static /* synthetic */ Class class$java$lang$Thread;

    public Hyphenator(String lang, String country, int leftMin, int rightMin) {
        this.hyphenTree = Hyphenator.getHyphenationTree(lang, country);
        this.remainCharCount = leftMin;
        this.pushCharCount = rightMin;
    }

    public static HyphenationTree getHyphenationTree(String lang, String country) {
        String hyphenDir;
        String key = lang;
        if (country != null && !country.equals("none")) {
            key = key + "_" + country;
        }
        if (missingHyphenationTrees != null && missingHyphenationTrees.contains(key)) {
            return null;
        }
        if (hyphenTrees.containsKey(key)) {
            return (HyphenationTree)hyphenTrees.get(key);
        }
        if (hyphenTrees.containsKey(lang)) {
            return (HyphenationTree)hyphenTrees.get(lang);
        }
        HyphenationTree hTree = Hyphenator.getFopHyphenationTree(key);
        if (hTree == null && (hyphenDir = "/hyph") != null) {
            hTree = Hyphenator.getUserHyphenationTree(key, hyphenDir);
        }
        if (hTree != null) {
            hyphenTrees.put(key, hTree);
        } else {
            log.error((Object)("Couldn't find hyphenation pattern " + key));
            if (missingHyphenationTrees == null) {
                missingHyphenationTrees = new HashSet();
            }
            missingHyphenationTrees.add(key);
        }
        return hTree;
    }

    private static InputStream getResourceStream(String key) {
        InputStream is = null;
        try {
            Method getCCL = (class$java$lang$Thread == null ? (class$java$lang$Thread = Hyphenator.class$("java.lang.Thread")) : class$java$lang$Thread).getMethod("getContextClassLoader", new Class[0]);
            if (getCCL != null) {
                ClassLoader contextClassLoader = (ClassLoader)getCCL.invoke((Object)Thread.currentThread(), new Object[0]);
                is = contextClassLoader.getResourceAsStream("hyph/" + key + ".hyp");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (is == null) {
            is = (class$org$apache$fop$hyphenation$Hyphenator == null ? (class$org$apache$fop$hyphenation$Hyphenator = Hyphenator.class$("org.apache.fop.hyphenation.Hyphenator")) : class$org$apache$fop$hyphenation$Hyphenator).getResourceAsStream("/hyph/" + key + ".hyp");
        }
        return is;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static HyphenationTree getFopHyphenationTree(String key) {
        InputStream is;
        ObjectInputStream ois;
        HyphenationTree hTree;
        block14: {
            block15: {
                hTree = null;
                ois = null;
                is = null;
                is = Hyphenator.getResourceStream(key);
                if (is != null) break block14;
                if (key.length() != 5) break block15;
                is = Hyphenator.getResourceStream(key.substring(0, 2));
                if (is != null) break block14;
                if (errorDump) {
                    // empty if block
                }
                HyphenationTree hyphenationTree = null;
                Object var6_7 = null;
                if (ois == null) return hyphenationTree;
                try {
                    ois.close();
                    return hyphenationTree;
                }
                catch (IOException e2) {
                    // empty catch block
                }
                return hyphenationTree;
            }
            if (errorDump) {
                // empty if block
            }
            HyphenationTree hyphenationTree = null;
            Object var6_8 = null;
            if (ois == null) return hyphenationTree;
            try {
                ois.close();
                return hyphenationTree;
            }
            catch (IOException e2) {
                // empty catch block
            }
            return hyphenationTree;
        }
        ois = new ObjectInputStream(is);
        hTree = (HyphenationTree)ois.readObject();
        Object var6_9 = null;
        if (ois == null) return hTree;
        try {
            ois.close();
            return hTree;
        }
        catch (IOException e2) {}
        return hTree;
        {
            catch (Exception e) {
                e.printStackTrace();
                Object var6_10 = null;
                if (ois == null) return hTree;
                try {
                    ois.close();
                    return hTree;
                }
                catch (IOException e2) {}
                return hTree;
            }
        }
        catch (Throwable throwable) {
            Object var6_11 = null;
            if (ois == null) throw throwable;
            try {
                ois.close();
                throw throwable;
            }
            catch (IOException e2) {
                // empty catch block
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static HyphenationTree getUserHyphenationTree(String key, String hyphenDir) {
        HyphenationTree hTree = null;
        File hyphenFile = new File(hyphenDir, key + ".hyp");
        if (hyphenFile.exists()) {
            ObjectInputStream ois = null;
            ois = new ObjectInputStream(new BufferedInputStream(new FileInputStream(hyphenFile)));
            hTree = (HyphenationTree)ois.readObject();
            Object var7_6 = null;
            if (ois == null) return hTree;
            try {
                ois.close();
                return hTree;
            }
            catch (IOException e2) {}
            return hTree;
            {
                catch (Exception e) {
                    log.error((Object)"Error while loading the hyphenation file", (Throwable)e);
                    Object var7_7 = null;
                    if (ois == null) return hTree;
                    try {
                        ois.close();
                        return hTree;
                    }
                    catch (IOException e2) {}
                    return hTree;
                }
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                if (ois == null) throw throwable;
                try {
                    ois.close();
                    throw throwable;
                }
                catch (IOException e2) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        hyphenFile = new File(hyphenDir, key + ".xml");
        if (hyphenFile.exists()) {
            hTree = new HyphenationTree();
            if (errorDump) {
                // empty if block
            }
            try {
                hTree.loadPatterns(hyphenFile.getPath());
                if (!errorDump) return hTree;
                System.out.println("Stats: ");
                hTree.printStats();
                return hTree;
            }
            catch (HyphenationException ex) {
                if (!errorDump) return null;
                return null;
            }
        }
        if (!errorDump) return null;
        return null;
    }

    public static Hyphenation hyphenate(String lang, String country, String word, int leftMin, int rightMin) {
        HyphenationTree hTree = Hyphenator.getHyphenationTree(lang, country);
        if (hTree == null) {
            return null;
        }
        return hTree.hyphenate(word, leftMin, rightMin);
    }

    public static Hyphenation hyphenate(String lang, String country, char[] word, int offset, int len, int leftMin, int rightMin) {
        HyphenationTree hTree = Hyphenator.getHyphenationTree(lang, country);
        if (hTree == null) {
            return null;
        }
        return hTree.hyphenate(word, offset, len, leftMin, rightMin);
    }

    public void setMinRemainCharCount(int min) {
        this.remainCharCount = min;
    }

    public void setMinPushCharCount(int min) {
        this.pushCharCount = min;
    }

    public void setLanguage(String lang, String country) {
        this.hyphenTree = Hyphenator.getHyphenationTree(lang, country);
    }

    public Hyphenation hyphenate(char[] word, int offset, int len) {
        if (this.hyphenTree == null) {
            return null;
        }
        return this.hyphenTree.hyphenate(word, offset, len, this.remainCharCount, this.pushCharCount);
    }

    public Hyphenation hyphenate(String word) {
        if (this.hyphenTree == null) {
            return null;
        }
        return this.hyphenTree.hyphenate(word, this.remainCharCount, this.pushCharCount);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        errorDump = false;
    }
}

