/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.properties;

import org.apache.fop.datatypes.Numeric;
import org.apache.fop.datatypes.PercentBaseContext;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.properties.ColorTypeProperty;
import org.apache.fop.fo.properties.EnumNumber;
import org.apache.fop.fo.properties.EnumProperty;
import org.apache.fop.fo.properties.Property;
import org.apache.fop.fo.properties.PropertyMaker;

public class NumberProperty
extends Property
implements Numeric {
    private Number number;

    public NumberProperty(Number num) {
        this.number = num;
    }

    public NumberProperty(double num) {
        this.number = new Double(num);
    }

    public NumberProperty(int num) {
        this.number = new Integer(num);
    }

    public int getDimension() {
        return 0;
    }

    public double getNumericValue() {
        return this.number.doubleValue();
    }

    public double getNumericValue(PercentBaseContext context) {
        return this.getNumericValue();
    }

    public int getValue() {
        return this.number.intValue();
    }

    public int getValue(PercentBaseContext context) {
        return this.getValue();
    }

    public boolean isAbsolute() {
        return true;
    }

    public Number getNumber() {
        return this.number;
    }

    public Object getObject() {
        return this.number;
    }

    public Numeric getNumeric() {
        return this;
    }

    public ColorTypeProperty getColorType() {
        return new ColorTypeProperty(0.0f, 0.0f, 0.0f);
    }

    public static class Maker
    extends PropertyMaker {
        public Maker(int propId) {
            super(propId);
        }

        public Property convertProperty(Property p, PropertyList propertyList, FObj fo) {
            if (p instanceof NumberProperty) {
                return p;
            }
            if (p instanceof EnumProperty) {
                return new EnumNumber(p);
            }
            Number val = p.getNumber();
            if (val != null) {
                return new NumberProperty(val);
            }
            return this.convertPropertyDatatype(p, propertyList, fo);
        }
    }
}

