/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.flow;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import org.apache.fop.apps.FOPException;
import org.apache.fop.datatypes.Length;
import org.apache.fop.fo.FONode;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.ValidationException;
import org.apache.fop.fo.flow.TableBody;
import org.apache.fop.fo.flow.TableCell;
import org.apache.fop.fo.flow.TableFObj;
import org.apache.fop.fo.properties.CommonAccessibility;
import org.apache.fop.fo.properties.CommonAural;
import org.apache.fop.fo.properties.CommonBorderPaddingBackground;
import org.apache.fop.fo.properties.CommonRelativePosition;
import org.apache.fop.fo.properties.KeepProperty;
import org.apache.fop.fo.properties.LengthRangeProperty;
import org.xml.sax.Locator;

public class TableRow
extends TableFObj {
    private CommonAccessibility commonAccessibility;
    private LengthRangeProperty blockProgressionDimension;
    private CommonAural commonAural;
    private CommonBorderPaddingBackground commonBorderPaddingBackground;
    private CommonRelativePosition commonRelativePosition;
    private int breakAfter;
    private int breakBefore;
    private Length height;
    private String id;
    private KeepProperty keepTogether;
    private KeepProperty keepWithNext;
    private KeepProperty keepWithPrevious;
    private int visibility;
    private boolean setup = false;
    private List pendingSpans;
    private BitSet usedColumnIndices;
    private int columnIndex = 1;

    public TableRow(FONode parent) {
        super(parent);
    }

    public void bind(PropertyList pList) throws FOPException {
        this.commonAccessibility = pList.getAccessibilityProps();
        this.blockProgressionDimension = pList.get(17).getLengthRange();
        this.commonAural = pList.getAuralProps();
        this.commonBorderPaddingBackground = pList.getBorderPaddingBackgroundProps();
        this.commonRelativePosition = pList.getRelativePositionProps();
        this.breakAfter = pList.get(58).getEnum();
        this.breakBefore = pList.get(59).getEnum();
        this.id = pList.get(113).getString();
        this.height = pList.get(106).getLength();
        this.keepTogether = pList.get(118).getKeep();
        this.keepWithNext = pList.get(119).getKeep();
        this.keepWithPrevious = pList.get(120).getKeep();
        this.visibility = pList.get(235).getEnum();
        super.bind(pList);
    }

    protected void addReplacedCell(TableCell cell) {
        if (this.childNodes == null) {
            this.childNodes = new ArrayList();
        }
        this.childNodes.add(cell);
    }

    protected void startOfNode() throws FOPException {
        this.pendingSpans = ((TableBody)this.parent).pendingSpans;
        this.usedColumnIndices = ((TableBody)this.parent).usedColumnIndices;
        while (this.usedColumnIndices.get(this.columnIndex - 1)) {
            ++this.columnIndex;
        }
        this.checkId(this.id);
        this.getFOEventHandler().startRow(this);
    }

    protected void endOfNode() throws FOPException {
        if (this.childNodes == null) {
            this.missingChildElementError("(table-cell+)");
        }
        if (((TableBody)this.parent).isFirst(this) && this.getTable().columns == null) {
            ((TableBody)this.parent).pendingSpans = this.pendingSpans;
        }
        ((TableBody)this.parent).resetColumnIndex();
        this.pendingSpans = null;
        this.usedColumnIndices = null;
        this.getFOEventHandler().endRow(this);
    }

    protected void validateChildNode(Locator loc, String nsURI, String localName) throws ValidationException {
        if (!"http://www.w3.org/1999/XSL/Format".equals(nsURI) || !localName.equals("table-cell")) {
            this.invalidChildError(loc, nsURI, localName);
        }
    }

    protected void addChildNode(FONode child) throws FOPException {
        TableCell cell = (TableCell)child;
        int rowSpan = cell.getNumberRowsSpanned();
        int colSpan = cell.getNumberColumnsSpanned();
        if (((TableBody)this.parent).isFirst(this) && this.getTable().columns == null) {
            if (this.pendingSpans == null) {
                this.pendingSpans = new ArrayList();
            }
            this.pendingSpans.add(null);
            if (this.usedColumnIndices == null) {
                this.usedColumnIndices = new BitSet();
            }
        }
        if (rowSpan > 1) {
            int i = colSpan;
            while (--i >= 0) {
                this.pendingSpans.set(this.columnIndex - 1 + i, new TableFObj.PendingSpan(rowSpan));
            }
        }
        int startIndex = this.columnIndex - 1;
        int endIndex = startIndex + colSpan;
        if (this.getTable().columns != null) {
            List cols = this.getTable().columns;
            int tmpIndex = endIndex;
            for (int i = startIndex; i <= tmpIndex; ++i) {
                if (i >= cols.size() || cols.get(i) != null) continue;
                ++endIndex;
            }
        }
        for (int i = startIndex; i < endIndex; ++i) {
            this.usedColumnIndices.set(i);
        }
        while (this.usedColumnIndices.get(this.columnIndex - 1)) {
            ++this.columnIndex;
        }
        super.addChildNode(cell);
    }

    public String getId() {
        return this.id;
    }

    public int getBreakAfter() {
        return this.breakAfter;
    }

    public int getBreakBefore() {
        return this.breakBefore;
    }

    public KeepProperty getKeepWithPrevious() {
        return this.keepWithPrevious;
    }

    public KeepProperty getKeepWithNext() {
        return this.keepWithNext;
    }

    public KeepProperty getKeepTogether() {
        return this.keepTogether;
    }

    public boolean mustKeepTogether() {
        return !this.getKeepTogether().getWithinPage().isAuto() || !this.getKeepTogether().getWithinColumn().isAuto();
    }

    public boolean mustKeepWithNext() {
        return !this.getKeepWithNext().getWithinPage().isAuto() || !this.getKeepWithNext().getWithinColumn().isAuto();
    }

    public boolean mustKeepWithPrevious() {
        return !this.getKeepWithPrevious().getWithinPage().isAuto() || !this.getKeepWithPrevious().getWithinColumn().isAuto();
    }

    public LengthRangeProperty getBlockProgressionDimension() {
        return this.blockProgressionDimension;
    }

    public Length getHeight() {
        return this.height;
    }

    public CommonBorderPaddingBackground getCommonBorderPaddingBackground() {
        return this.commonBorderPaddingBackground;
    }

    public String getLocalName() {
        return "table-row";
    }

    public int getNameId() {
        return 54;
    }

    public int getCurrentColumnIndex() {
        return this.columnIndex;
    }

    public void setCurrentColumnIndex(int newIndex) {
        this.columnIndex = newIndex;
    }

    protected boolean isColumnNumberUsed(int colNr) {
        return this.usedColumnIndices.get(colNr - 1);
    }
}

