/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.flow;

import org.apache.fop.apps.FOPException;
import org.apache.fop.datatypes.Length;
import org.apache.fop.datatypes.Numeric;
import org.apache.fop.fo.FONode;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.ValidationException;
import org.apache.fop.fo.flow.TableFObj;
import org.apache.fop.fo.properties.CommonAccessibility;
import org.apache.fop.fo.properties.CommonAural;
import org.apache.fop.fo.properties.CommonBorderPaddingBackground;
import org.apache.fop.fo.properties.CommonRelativePosition;
import org.apache.fop.fo.properties.LengthPairProperty;
import org.apache.fop.fo.properties.LengthRangeProperty;
import org.xml.sax.Locator;

public class TableCell
extends TableFObj {
    private CommonAccessibility commonAccessibility;
    private CommonAural commonAural;
    private CommonBorderPaddingBackground commonBorderPaddingBackground;
    private CommonRelativePosition commonRelativePosition;
    private LengthRangeProperty blockProgressionDimension;
    private int borderCollapse;
    private LengthPairProperty borderSeparation;
    private Numeric columnNumber;
    private int displayAlign;
    private int relativeAlign;
    private int emptyCells;
    private int endsRow;
    private Length height;
    private String id;
    private LengthRangeProperty inlineProgressionDimension;
    private Numeric numberColumnsSpanned;
    private Numeric numberRowsSpanned;
    private int startsRow;
    private Length width;
    private boolean blockItemFound = false;
    protected int startOffset;
    protected int beforeOffset = 0;
    protected int startAdjust = 0;
    protected int widthAdjust = 0;
    protected int borderHeight = 0;
    protected int top;
    private boolean bDone = false;

    public TableCell(FONode parent) {
        super(parent);
    }

    public void bind(PropertyList pList) throws FOPException {
        this.commonAccessibility = pList.getAccessibilityProps();
        this.commonAural = pList.getAuralProps();
        this.commonBorderPaddingBackground = pList.getBorderPaddingBackgroundProps();
        this.commonRelativePosition = pList.getRelativePositionProps();
        this.blockProgressionDimension = pList.get(17).getLengthRange();
        this.borderCollapse = pList.get(31).getEnum();
        this.borderSeparation = pList.get(45).getLengthPair();
        this.columnNumber = pList.get(70).getNumeric();
        this.displayAlign = pList.get(81).getEnum();
        this.relativeAlign = pList.get(182).getEnum();
        this.emptyCells = pList.get(84).getEnum();
        this.endsRow = pList.get(86).getEnum();
        this.height = pList.get(106).getLength();
        this.id = pList.get(113).getString();
        this.inlineProgressionDimension = pList.get(116).getLengthRange();
        this.numberColumnsSpanned = pList.get(149).getNumeric();
        this.numberRowsSpanned = pList.get(150).getNumeric();
        this.startsRow = pList.get(213).getEnum();
        this.width = pList.get(241).getLength();
        super.bind(pList);
        int i = -1;
        int columnIndex = this.columnNumber.getValue();
        while (++i < this.getNumberColumnsSpanned()) {
            if (this.getTable().columns != null) {
                while (columnIndex <= this.getTable().columns.size() && !this.getTable().isColumnNumberUsed(columnIndex)) {
                    ++columnIndex;
                }
            }
            if (!((TableFObj)this.parent).isColumnNumberUsed(columnIndex)) continue;
            throw new FOPException("fo:table-cell overlaps in column " + columnIndex, this.locator);
        }
    }

    protected void startOfNode() throws FOPException {
        this.checkId(this.id);
        this.getFOEventHandler().startCell(this);
    }

    protected void endOfNode() throws FOPException {
        if (!this.blockItemFound) {
            if (this.getUserAgent().validateStrictly()) {
                this.missingChildElementError("marker* (%block;)+");
            } else if (this.childNodes != null && this.childNodes.size() > 0) {
                this.getLogger().warn((Object)"fo:table-cell content that is not enclosed by a fo:block will be dropped/ignored.");
            }
        }
        if ((this.startsRow() || this.endsRow()) && this.getParent().getNameId() == 54) {
            this.getLogger().warn((Object)"starts-row/ends-row for fo:table-cells non-applicable for children of an fo:table-row.");
        }
        this.getFOEventHandler().endCell(this);
    }

    protected void validateChildNode(Locator loc, String nsURI, String localName) throws ValidationException {
        if ("http://www.w3.org/1999/XSL/Format".equals(nsURI) && localName.equals("marker")) {
            if (this.blockItemFound) {
                this.nodesOutOfOrderError(loc, "fo:marker", "(%block;)");
            }
        } else if (!this.isBlockItem(nsURI, localName)) {
            this.invalidChildError(loc, nsURI, localName);
        } else {
            this.blockItemFound = true;
        }
    }

    public void setStartOffset(int offset) {
        this.startOffset = offset;
    }

    public CommonBorderPaddingBackground getCommonBorderPaddingBackground() {
        return this.commonBorderPaddingBackground;
    }

    public int getColumnNumber() {
        return this.columnNumber.getValue();
    }

    public boolean showEmptyCells() {
        return this.emptyCells == 130;
    }

    public int getBorderCollapse() {
        return this.borderCollapse;
    }

    public boolean isSeparateBorderModel() {
        return this.getBorderCollapse() == 129;
    }

    public LengthPairProperty getBorderSeparation() {
        return this.borderSeparation;
    }

    public String getId() {
        return this.id;
    }

    public int getNumberColumnsSpanned() {
        return Math.max(this.numberColumnsSpanned.getValue(), 1);
    }

    public int getNumberRowsSpanned() {
        return Math.max(this.numberRowsSpanned.getValue(), 1);
    }

    public LengthRangeProperty getBlockProgressionDimension() {
        return this.blockProgressionDimension;
    }

    public int getDisplayAlign() {
        return this.displayAlign;
    }

    public boolean startsRow() {
        return this.startsRow == 149;
    }

    public boolean endsRow() {
        return this.endsRow == 149;
    }

    public String getLocalName() {
        return "table-cell";
    }

    public int getNameId() {
        return 50;
    }
}

