/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.flow;

import org.apache.fop.apps.FOPException;
import org.apache.fop.fo.FONode;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.ValidationException;
import org.apache.fop.fo.flow.ListItemBody;
import org.apache.fop.fo.flow.ListItemLabel;
import org.apache.fop.fo.flow.Marker;
import org.apache.fop.fo.properties.CommonAccessibility;
import org.apache.fop.fo.properties.CommonAural;
import org.apache.fop.fo.properties.CommonBorderPaddingBackground;
import org.apache.fop.fo.properties.CommonMarginBlock;
import org.apache.fop.fo.properties.CommonRelativePosition;
import org.apache.fop.fo.properties.KeepProperty;
import org.xml.sax.Locator;

public class ListItem
extends FObj {
    private CommonAccessibility commonAccessibility;
    private CommonAural commonAural;
    private CommonBorderPaddingBackground commonBorderPaddingBackground;
    private CommonMarginBlock commonMarginBlock;
    private CommonRelativePosition commonRelativePosition;
    private int breakAfter;
    private int breakBefore;
    private String id;
    private int intrusionDisplace;
    private KeepProperty keepTogether;
    private KeepProperty keepWithNext;
    private KeepProperty keepWithPrevious;
    private int relativeAlign;
    private ListItemLabel label = null;
    private ListItemBody body = null;

    public ListItem(FONode parent) {
        super(parent);
    }

    public void bind(PropertyList pList) throws FOPException {
        this.commonAccessibility = pList.getAccessibilityProps();
        this.commonAural = pList.getAuralProps();
        this.commonBorderPaddingBackground = pList.getBorderPaddingBackgroundProps();
        this.commonMarginBlock = pList.getMarginBlockProps();
        this.commonRelativePosition = pList.getRelativePositionProps();
        this.breakAfter = pList.get(58).getEnum();
        this.breakBefore = pList.get(59).getEnum();
        this.id = pList.get(113).getString();
        this.intrusionDisplace = pList.get(247).getEnum();
        this.keepTogether = pList.get(118).getKeep();
        this.keepWithNext = pList.get(119).getKeep();
        this.keepWithPrevious = pList.get(120).getKeep();
        this.relativeAlign = pList.get(182).getEnum();
    }

    protected void startOfNode() throws FOPException {
        this.checkId(this.id);
        this.getFOEventHandler().startListItem(this);
    }

    protected void endOfNode() throws FOPException {
        if (this.label == null || this.body == null) {
            this.missingChildElementError("marker* (list-item-label,list-item-body)");
        }
        this.getFOEventHandler().endListItem(this);
    }

    protected void validateChildNode(Locator loc, String nsURI, String localName) throws ValidationException {
        if ("http://www.w3.org/1999/XSL/Format".equals(nsURI) && localName.equals("marker")) {
            if (this.label != null) {
                this.nodesOutOfOrderError(loc, "fo:marker", "fo:list-item-label");
            }
        } else if ("http://www.w3.org/1999/XSL/Format".equals(nsURI) && localName.equals("list-item-label")) {
            if (this.label != null) {
                this.tooManyNodesError(loc, "fo:list-item-label");
            }
        } else if ("http://www.w3.org/1999/XSL/Format".equals(nsURI) && localName.equals("list-item-body")) {
            if (this.label == null) {
                this.nodesOutOfOrderError(loc, "fo:list-item-label", "fo:list-item-body");
            } else if (this.body != null) {
                this.tooManyNodesError(loc, "fo:list-item-body");
            }
        } else {
            this.invalidChildError(loc, nsURI, localName);
        }
    }

    public void addChildNode(FONode child) {
        int nameId = ((FObj)child).getNameId();
        if (nameId == 23) {
            this.label = (ListItemLabel)child;
        } else if (nameId == 22) {
            this.body = (ListItemBody)child;
        } else if (nameId == 24) {
            this.addMarker((Marker)child);
        }
    }

    public CommonMarginBlock getCommonMarginBlock() {
        return this.commonMarginBlock;
    }

    public CommonBorderPaddingBackground getCommonBorderPaddingBackground() {
        return this.commonBorderPaddingBackground;
    }

    public int getBreakAfter() {
        return this.breakAfter;
    }

    public int getBreakBefore() {
        return this.breakBefore;
    }

    public KeepProperty getKeepWithNext() {
        return this.keepWithNext;
    }

    public KeepProperty getKeepWithPrevious() {
        return this.keepWithPrevious;
    }

    public KeepProperty getKeepTogether() {
        return this.keepTogether;
    }

    public String getId() {
        return this.id;
    }

    public ListItemLabel getLabel() {
        return this.label;
    }

    public ListItemBody getBody() {
        return this.body;
    }

    public String getLocalName() {
        return "list-item";
    }

    public int getNameId() {
        return 21;
    }
}

