/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo;

import java.awt.geom.Point2D;
import java.util.HashMap;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.fop.apps.FOPException;
import org.apache.fop.fo.FONode;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.ValidationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;

public abstract class XMLObj
extends FONode {
    private Attributes attr = null;
    protected Element element;
    protected Document doc;
    protected String name;
    private static HashMap ns = new HashMap();

    public XMLObj(FONode parent) {
        super(parent);
    }

    protected void validateChildNode(Locator loc, String nsURI, String localName) throws ValidationException {
        if ("http://www.w3.org/1999/XSL/Format".equals(nsURI)) {
            this.invalidChildError(loc, nsURI, localName);
        }
    }

    public void processNode(String elementName, Locator locator, Attributes attlist, PropertyList propertyList) throws FOPException {
        this.setLocator(locator);
        this.name = elementName;
        this.attr = attlist;
    }

    public Document getDOMDocument() {
        return this.doc;
    }

    public Point2D getDimension(Point2D view) {
        return null;
    }

    public String getLocalName() {
        return this.name;
    }

    public void addElement(Document doc, Element parent) {
        this.doc = doc;
        this.element = doc.createElementNS(this.getNamespaceURI(), this.name);
        for (int count = 0; count < this.attr.getLength(); ++count) {
            String rf = this.attr.getValue(count);
            String qname = this.attr.getQName(count);
            int idx = qname.indexOf(":");
            if (idx == -1) {
                this.element.setAttribute(qname, rf);
                continue;
            }
            String pref = qname.substring(0, idx);
            String tail = qname.substring(idx + 1);
            if (pref.equals("xmlns")) {
                ns.put(tail, rf);
                continue;
            }
            this.element.setAttributeNS((String)ns.get(pref), tail, rf);
        }
        this.attr = null;
        parent.appendChild(this.element);
    }

    public void buildTopLevel(Document doc, Element svgRoot) {
        for (int count = 0; count < this.attr.getLength(); ++count) {
            String rf = this.attr.getValue(count);
            String qname = this.attr.getQName(count);
            int idx = qname.indexOf(":");
            if (idx == -1) {
                this.element.setAttribute(qname, rf);
                continue;
            }
            String pref = qname.substring(0, idx);
            String tail = qname.substring(idx + 1);
            if (pref.equals("xmlns")) {
                ns.put(tail, rf);
                continue;
            }
            this.element.setAttributeNS((String)ns.get(pref), tail, rf);
        }
    }

    public Document createBasicDocument() {
        this.doc = null;
        this.element = null;
        try {
            DocumentBuilderFactory fact = DocumentBuilderFactory.newInstance();
            fact.setNamespaceAware(true);
            this.doc = fact.newDocumentBuilder().newDocument();
            Element el = this.doc.createElement(this.name);
            this.doc.appendChild(el);
            this.element = this.doc.getDocumentElement();
            this.buildTopLevel(this.doc, this.element);
        }
        catch (Exception e) {
            log.error((Object)"Error while trying to instantiate a DOM Document", (Throwable)e);
        }
        return this.doc;
    }

    protected void addChildNode(FONode child) {
        if (child instanceof XMLObj) {
            ((XMLObj)child).addElement(this.doc, this.element);
        } else {
            this.getLogger().debug((Object)("Invalid element: " + child.getName() + " inside foreign xml markup"));
        }
    }

    protected void addCharacters(char[] data, int start, int length, PropertyList pList, Locator locator) {
        String str = new String(data, start, length - start);
        Text text = this.doc.createTextNode(str);
        this.element.appendChild(text);
    }

    static {
        ns.put("xlink", "http://www.w3.org/1999/xlink");
    }
}

