/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.area;

import java.util.ArrayList;
import java.util.List;
import org.apache.fop.area.Area;
import org.apache.fop.area.inline.InlineArea;

public class LineArea
extends Area {
    private LineAdjustingInfo adjustingInfo = null;
    private int stacking = 0;
    private int startIndent;
    private int baseLine;
    private List inlineAreas = new ArrayList();

    public LineArea() {
    }

    public LineArea(int alignment, int diff, int stretch, int shrink) {
        this.adjustingInfo = new LineAdjustingInfo(alignment, diff, stretch, shrink);
    }

    public void addChildArea(Area childArea) {
        if (childArea instanceof InlineArea) {
            this.addInlineArea((InlineArea)childArea);
            ((InlineArea)childArea).setParentArea(this);
        }
    }

    public void addInlineArea(InlineArea area) {
        this.inlineAreas.add(area);
    }

    public List getInlineAreas() {
        return this.inlineAreas;
    }

    public void setStartIndent(int si) {
        this.startIndent = si;
    }

    public int getStartIndent() {
        return this.startIndent;
    }

    public void updateExtentsFromChildren() {
        int ipd = 0;
        int bpd = 0;
        int len = this.inlineAreas.size();
        for (int i = 0; i < len; ++i) {
            ipd = Math.max(ipd, ((InlineArea)this.inlineAreas.get(i)).getAllocIPD());
            bpd += ((InlineArea)this.inlineAreas.get(i)).getAllocBPD();
        }
        this.setIPD(ipd);
        this.setBPD(bpd);
    }

    public void handleIPDVariation(int ipdVariation) {
        switch (this.adjustingInfo.lineAlignment) {
            case 135: {
                break;
            }
            case 23: {
                this.startIndent -= ipdVariation / 2;
                break;
            }
            case 39: {
                this.startIndent -= ipdVariation;
                break;
            }
            case 70: {
                this.adjustingInfo.variationFactor *= (float)(this.adjustingInfo.difference - ipdVariation) / (float)this.adjustingInfo.difference;
                this.adjustingInfo.difference -= ipdVariation;
                if (!this.adjustingInfo.bAddedToAreaTree) break;
                this.finalize();
                break;
            }
            default: {
                throw new RuntimeException();
            }
        }
    }

    public void finalize() {
        if (this.adjustingInfo.lineAlignment == 70) {
            boolean bUnresolvedAreasPresent = false;
            int len = this.inlineAreas.size();
            for (int i = 0; i < len; ++i) {
                bUnresolvedAreasPresent |= ((InlineArea)this.inlineAreas.get(i)).applyVariationFactor(this.adjustingInfo.variationFactor, this.adjustingInfo.availableStretch, this.adjustingInfo.availableShrink);
            }
            if (!bUnresolvedAreasPresent) {
                this.adjustingInfo = null;
            } else {
                if (!this.adjustingInfo.bAddedToAreaTree) {
                    this.adjustingInfo.bAddedToAreaTree = true;
                }
                this.adjustingInfo.variationFactor = 1.0;
            }
        }
    }

    private class LineAdjustingInfo {
        private int lineAlignment;
        private int difference;
        private int availableStretch;
        private int availableShrink;
        private double variationFactor;
        private boolean bAddedToAreaTree;

        private LineAdjustingInfo(int alignment, int diff, int stretch, int shrink) {
            this.lineAlignment = alignment;
            this.difference = diff;
            this.availableStretch = stretch;
            this.availableShrink = shrink;
            this.variationFactor = 1.0;
            this.bAddedToAreaTree = false;
        }
    }
}

