/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.area;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.fop.apps.FOPException;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.area.PageViewport;
import org.apache.fop.area.RenderPagesModel;
import org.apache.fop.fonts.FontInfo;

public class CachedRenderPagesModel
extends RenderPagesModel {
    private Map pageMap = new HashMap();

    public CachedRenderPagesModel(FOUserAgent userAgent, String outputFormat, FontInfo fontInfo, OutputStream stream) throws FOPException {
        super(userAgent, outputFormat, fontInfo, stream);
    }

    protected boolean checkPreparedPages(PageViewport newpage, boolean renderUnresolved) {
        Iterator iter = this.prepared.iterator();
        while (iter.hasNext()) {
            PageViewport p = (PageViewport)iter.next();
            if (p.isResolved() || renderUnresolved) {
                if (p != newpage) {
                    try {
                        String name = (String)this.pageMap.get(p);
                        File temp = new File(name);
                        log.debug((Object)("page serialized to: " + temp.length()));
                        ObjectInputStream in = new ObjectInputStream(new BufferedInputStream(new FileInputStream(temp)));
                        p.loadPage(in);
                        in.close();
                        temp.delete();
                        this.pageMap.remove(p);
                    }
                    catch (Exception e) {
                        log.error((Object)e);
                    }
                }
                try {
                    this.renderer.renderPage(p);
                    if (!p.isResolved()) {
                        String[] idrefs = p.getIDRefs();
                        for (int count = 0; count < idrefs.length; ++count) {
                            log.warn((Object)("Page " + p.getPageNumberString() + ": Unresolved id reference \"" + idrefs[count] + "\" found."));
                        }
                    }
                }
                catch (Exception e) {
                    log.error((Object)e);
                }
                p.clear();
                iter.remove();
                continue;
            }
            if (this.renderer.supportsOutOfOrder()) continue;
            break;
        }
        if (newpage != null && newpage.getPage() != null) {
            this.savePage(newpage);
        }
        return this.renderer.supportsOutOfOrder() || this.prepared.isEmpty();
    }

    protected void savePage(PageViewport page) {
        try {
            String fname = "page" + page.toString() + ".ser";
            ObjectOutputStream tempstream = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(fname)));
            page.savePage(tempstream);
            tempstream.close();
            this.pageMap.put(page, fname);
        }
        catch (Exception e) {
            log.error((Object)e);
        }
    }
}

