(* -------------------------------------------------------------------------- *

   Description: Notebook Transmogrification Utility Initialization File

   Context: Transmogrify`

   Authors: Stephen Layland

   Version: $Id: init.m,v 1.21 2007/12/30 03:01:37 andy Exp $

   Summary:

   This is the inialization file for Transmogrify, the notebook -> XML 
   conversion utility.  For usage information and introduction see help browser
   documentation (Transmogrify/Documentation/English/Transmogrify.nb)

   This file only declares the Transmogrify` context, sets up some package 
   globals, and finally loads the following implementation files:

     ImportCache.m
     Layout.m
     Literalize.m
     Transmogrify.m
     Utilities.m

   See the appropriate files for implementation details.

   This file was created using an automated system.
 * ---------------------------------------------------------------------------- *)

BeginPackage["Transmogrify`"]
Unprotect["Transmogrify`*"]

(* ------------------------- 
     i n f o r m a t i o n   
   ------------------------- *)

`Information`$VersionNumber = 2.0
`Information`$ReleaseNumber = 0
`Information`$Version = "Transmogrify Version 2.0.0"
`Information`$CreationDate = {2006, 7, 6, 20, 8, 8.721745}
`Information`$CreationID = 20060706200809

$TransmogrifyDirectory = StringReplace[
    DirectoryName[ System`Private`$InputFileName ],
    RegularExpression["(.*).Kernel.?$"] -> "$1"
]

(* ----------------------------------- 
     u s a g e   s t a t e m e n t s   
   ----------------------------------- *)


(* ---------------------------------------------------------- *
                    from Layout.m
 * ---------------------------------------------------------- *)

FillInLayout::usage = "FillInLayout is a utility which allows you to create a\
 structure based file of your choosing, and interpolate specially formatted text\
 as arbitary Mathematica code.  The following different methods exist for interpolating\
 variables from the default scope, from a list, or from a context, respectively:\n
 FillInLayout[\"layoutfile\",\"format\",opts]\n\
 FillInLayout[\"layoutfile\",\"format\",{varlist},opts]\n\
 FillInLayout[\"layoutfile\",\"format\",\"context`\",opts],\n\
 where {varlist} is of the form {\"var1\"->var1,...}, or {\"var1\", \"var2\"->val2,...}.";
 
EmbeddedCodeRule::usage = "This options is a rule that will convert either a\
 string, or a Mathematica expression, of your choice into a _String_ that denotes\
 arbitrary Mathematica code that will be passed off to ToExpression.  Setting this to\
 Automatic causes FillInLayout to recognize <!-- {mcode} --> as Mathematica code for all\
 files imported as SymbolicXML (default), and uses ${mcode} for regular text files. See\
 FillInLayout.nb for examples.";


(* ---------------------------------------------------------- *
                    from Literalize.m
 * ---------------------------------------------------------- *)

Literalize::usage = "Literalize[nb] converts all CounterBoxes in nb to corresponding literal values."
Literalize::notes = "See also: PreProcessNotebook";
 

(* ---------------------------------------------------------- *
                    from Utilities.m
 * ---------------------------------------------------------- *)

InlineFormattedQ::usage = "Tests if a string has inline formatted characters"
FromInlineString::usage = "Turns an inline formatted string into its StandardForm box\
 structure"
FromInlineStringTests::usage = "FromInlineStringTests is a set of rules to test changes\
 to FromInlineString.  Evaluating the LHS should give the RHS."

ConvertToString::usage = "ConvertToString[expr] takes an expr and returns a string.";

(* ----------------------------------- 
        Load Implementation Code       
   ----------------------------------- *)

(* all new contexts will now be subcontexts of Transmogrify` *)
Scan[
  Get[ToFileName[{$TransmogrifyDirectory,"Kernel"},#]]&,
  {
    "ImportCache.m",
    "Layout.m",
    "Literalize.m",
    "Transmogrify.m",
    "Utilities.m"
  }
]

(* Protect all variables.  Unprotect the userwriteable ones. *)
SetAttributes[#,ReadProtected]&/@(
  ToExpression["Unevaluated["<>#<>"]"]&/@Protect["Transmogrify`*"])
ClearAttributes[#,ReadProtected]&/@(
  ToExpression["Unevaluated["<>#<>"]"]&/@
    Unprotect@@Transmogrify`Private`$WriteableSymbols)

EndPackage[]
