(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     40621,       1207]
NotebookOptionsPosition[     34945,        994]
NotebookOutlinePosition[     35357,       1010]
CellTagsIndexPosition[     35314,       1007]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[TextData[{
 "New in: ",
 Cell["6.1", "HistoryData",
  CellTags->"New"],
 " | Modified in: ",
 Cell[" ", "HistoryData",
  CellTags->"Modified"],
 " | Obsolete in: ",
 Cell[" ", "HistoryData",
  CellTags->"Obsolete"],
 " | Excised in: ",
 Cell[" ", "HistoryData",
  CellTags->"Excised"]
}], "History",
 CellChangeTimes->{{3.39358269310471*^9, 3.3935826934279337`*^9}},
 CellID->1247902091],

Cell[CellGroupData[{

Cell["Categorization", "CategorizationSection",
 CellID->1122911449],

Cell["Tutorial", "Categorization",
 CellLabel->"Entity Type",
 CellID->686433507],

Cell["Transmogrify", "Categorization",
 CellChangeTimes->{{3.393582700784326*^9, 3.3935827102021093`*^9}},
 CellLabel->"Paclet Name",
 CellID->605800465],

Cell["Transmogrify`", "Categorization",
 CellChangeTimes->{{3.393582711752283*^9, 3.393582712197106*^9}},
 CellLabel->"Context",
 CellID->468444828],

Cell["Transmogrify/tutorial/WorkingWithSelectors", "Categorization",
 CellChangeTimes->{{3.415984540502644*^9, 3.415984550323105*^9}},
 CellLabel->"URI",
 CellID->198121836]
}, Closed]],

Cell[CellGroupData[{

Cell["Synonyms", "SynonymsSection",
 CellID->1427418553],

Cell["XXXX", "Synonyms",
 CellID->1251652828]
}, Closed]],

Cell[CellGroupData[{

Cell["Keywords", "KeywordsSection",
 CellID->1427428552],

Cell["xsl", "Keywords",
 CellChangeTimes->{{3.393582726306532*^9, 3.393582726855266*^9}},
 CellID->1251852827],

Cell["xslt", "Keywords",
 CellChangeTimes->{{3.393582728732102*^9, 3.393582730354396*^9}},
 CellID->152954738]
}, Closed]],

Cell[CellGroupData[{

Cell["Details", "DetailsSection",
 CellID->1234044802],

Cell["XXXX", "Details",
 CellLabel->"Developers",
 CellID->193924488],

Cell["XXXX", "Details",
 CellLabel->"Comments",
 CellID->1556177317]
}, Closed]],

Cell["Working with Selectors", "Title",
 CellChangeTimes->{{3.393582578934505*^9, 3.393582593495398*^9}, {
  3.393582894688936*^9, 3.393582896405136*^9}, {3.398360341445615*^9, 
  3.398360367597557*^9}},
 CellID->509267359],

Cell[CellGroupData[{

Cell["Initialization", "Section",
 CellChangeTimes->{{3.396264598957924*^9, 3.396264601184581*^9}, {
  3.397302921967804*^9, 3.397302922746282*^9}, {3.397309809477876*^9, 
  3.397309812858204*^9}},
 CellID->1499027298],

Cell[BoxData[
 RowBox[{
  RowBox[{"Needs", "[", "\"\<Transmogrify`\>\"", "]"}], ";"}]], "Input",
 CellChangeTimes->{{3.396264546906055*^9, 3.39626455117904*^9}},
 CellID->2021134529],

Cell[BoxData[
 RowBox[{
  RowBox[{"Successes", "=", 
   RowBox[{"{", "}"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.397309821027435*^9, 3.397309829967105*^9}},
 CellID->311700657]
}, Open  ]],

Cell[CellGroupData[{

Cell["SelectSiblings", "Section",
 CellChangeTimes->{{3.396264598957924*^9, 3.396264601184581*^9}, {
  3.397302921967804*^9, 3.397302922746282*^9}},
 CellID->1322515262],

Cell[BoxData[
 RowBox[{
  RowBox[{"nb", "=", 
   RowBox[{"Notebook", "[", 
    RowBox[{"{", "\[IndentingNewLine]", 
     RowBox[{"Cell", "[", 
      RowBox[{"CellGroupData", "[", 
       RowBox[{
        RowBox[{"{", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"Cell", "[", 
           RowBox[{"\"\<Section\>\"", ",", "\"\<Section\>\""}], "]"}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{"Cell", "[", 
           RowBox[{"\"\<Text1\>\"", ",", "\"\<Text\>\""}], "]"}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{"Cell", "[", 
           RowBox[{"\"\<Text2\>\"", ",", "\"\<Text\>\""}], "]"}]}], 
         "\[IndentingNewLine]", "}"}], ",", "Open"}], "]"}], "]"}], "}"}], 
    "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.396264554826269*^9, 3.396264587662932*^9}},
 CellID->1058261984],

Cell[BoxData[
 RowBox[{
  RowBox[{"tr", "=", 
   RowBox[{"XMLTransform", "[", 
    RowBox[{"{", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"_Notebook", "\[RuleDelayed]", 
       RowBox[{"{", 
        RowBox[{"Recurse", "[", "]"}], "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"_CellGroupData", "\[RuleDelayed]", 
       RowBox[{"Section", "[", 
        RowBox[{"Recurse", "[", "]"}], "]"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"Cell", ",", "\"\<Section\>\""}], "}"}], "\[RuleDelayed]", 
       RowBox[{"Cell", "[", 
        RowBox[{"Transmogrify", "[", 
         RowBox[{"SelectSiblings", "[", "]"}], "]"}], "]"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"Cell", ",", "\"\<Text\>\""}], "}"}], "\[RuleDelayed]", 
       RowBox[{"Cell", "[", 
        RowBox[{"Recurse", "[", "]"}], "]"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"_String", "\[RuleDelayed]", 
       RowBox[{"SelectSelf", "[", "]"}]}]}], "\[IndentingNewLine]", "}"}], 
    "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.396264605366451*^9, 3.396264705897106*^9}, {
  3.396280394317347*^9, 3.396280397360627*^9}, {3.397241618823776*^9, 
  3.397241623045589*^9}, {3.397321595792407*^9, 3.397321677335697*^9}},
 CellID->749600634],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"out", "=", 
  RowBox[{"Transmogrify", "[", 
   RowBox[{"nb", ",", "tr"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.39626471021947*^9, 3.396264715397411*^9}, {
  3.396276429928081*^9, 3.396276432034564*^9}, {3.397309876381732*^9, 
  3.39730987672963*^9}},
 CellID->1398782336],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"Section", "[", 
   RowBox[{
    RowBox[{"Cell", "[", 
     RowBox[{
      RowBox[{"Cell", "[", "\<\"Text1\"\>", "]"}], ",", 
      RowBox[{"Cell", "[", "\<\"Text2\"\>", "]"}]}], "]"}], ",", 
    RowBox[{"Cell", "[", "\<\"Text1\"\>", "]"}], ",", 
    RowBox[{"Cell", "[", "\<\"Text2\"\>", "]"}]}], "]"}], "}"}]], "Output",
 CellChangeTimes->{{3.397241394428795*^9, 3.397241422325166*^9}, 
   3.39724146727796*^9, 3.397241520776672*^9, 3.397241568842939*^9, {
   3.397241612166366*^9, 3.397241625686529*^9}, 3.397302929956855*^9, 
   3.397309955706036*^9, 3.397310001446889*^9, 3.39732161443147*^9, {
   3.397321652781498*^9, 3.397321680092719*^9}, 3.397322097271284*^9, 
   3.397324326456416*^9, {3.398122577005699*^9, 3.398122583543393*^9}},
 CellID->831237443]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AppendTo", "[", 
  RowBox[{"Successes", ",", 
   RowBox[{"out", "===", 
    RowBox[{"{", 
     RowBox[{"Section", "[", 
      RowBox[{
       RowBox[{"Cell", "[", 
        RowBox[{
         RowBox[{"Cell", "[", "\"\<Text1\>\"", "]"}], ",", 
         RowBox[{"Cell", "[", "\"\<Text2\>\"", "]"}]}], "]"}], ",", 
       RowBox[{"Cell", "[", "\"\<Text1\>\"", "]"}], ",", 
       RowBox[{"Cell", "[", "\"\<Text2\>\"", "]"}]}], "]"}], "}"}]}]}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.397309881808419*^9, 3.397309909232645*^9}, 
   3.397309948876062*^9, 3.397321685678121*^9},
 CellID->1226580766],

Cell[BoxData[
 RowBox[{"{", "True", "}"}]], "Output",
 CellChangeTimes->{
  3.397309956555601*^9, 3.397310002291806*^9, 3.397321686360163*^9, 
   3.39732209757345*^9, 3.397324326543611*^9, {3.3981225771349173`*^9, 
   3.3981225836457043`*^9}},
 CellID->1447406609]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["SelectParent", "Section",
 CellChangeTimes->{{3.396264598957924*^9, 3.396264601184581*^9}, {
  3.397302921967804*^9, 3.397302941682596*^9}},
 CellID->2015607894],

Cell[BoxData[
 RowBox[{
  RowBox[{"nb", "=", 
   RowBox[{"Notebook", "[", 
    RowBox[{"{", "\[IndentingNewLine]", 
     RowBox[{"Cell", "[", 
      RowBox[{"CellGroupData", "[", 
       RowBox[{
        RowBox[{"{", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"Cell", "[", 
           RowBox[{"\"\<Section\>\"", ",", "\"\<Section\>\""}], "]"}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{"Cell", "[", 
           RowBox[{"\"\<Text1\>\"", ",", "\"\<Text\>\""}], "]"}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{"Cell", "[", 
           RowBox[{"\"\<Text2\>\"", ",", "\"\<Text\>\""}], "]"}]}], 
         "\[IndentingNewLine]", "}"}], ",", "Open"}], "]"}], "]"}], "}"}], 
    "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.396264554826269*^9, 3.396264587662932*^9}},
 CellID->1914826680],

Cell[BoxData[
 RowBox[{
  RowBox[{"tr", "=", 
   RowBox[{"XMLTransform", "[", 
    RowBox[{"{", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"_Notebook", "\[RuleDelayed]", 
       RowBox[{"{", 
        RowBox[{"Recurse", "[", "]"}], "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"_CellGroupData", "\[RuleDelayed]", 
       RowBox[{"Section", "[", 
        RowBox[{"Recurse", "[", "]"}], "]"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"Cell", ",", "\"\<Section\>\""}], "}"}], "\[RuleDelayed]", 
       RowBox[{"Title", "[", "\[IndentingNewLine]", 
        RowBox[{"Map", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"ToString", "[", 
            RowBox[{"Head", "[", 
             RowBox[{"SelectParent", "[", "#", "]"}], "]"}], "]"}], "&"}], 
          ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", "1", ",", "2"}], "}"}]}], "]"}], "]"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"Cell", ",", "\"\<Text\>\""}], "}"}], "\[RuleDelayed]", 
       RowBox[{"Cell", "[", 
        RowBox[{"Recurse", "[", "]"}], "]"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"_String", "\[RuleDelayed]", 
       RowBox[{"SelectSelf", "[", "]"}]}]}], "\[IndentingNewLine]", "}"}], 
    "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.396264605366451*^9, 3.396264705897106*^9}, {
  3.396280394317347*^9, 3.396280397360627*^9}, {3.397241618823776*^9, 
  3.397241623045589*^9}, {3.397302956123774*^9, 3.397302966892352*^9}, {
  3.397303340933926*^9, 3.397303385995206*^9}, {3.397321695434911*^9, 
  3.397321725702579*^9}},
 CellID->302076818],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"out", "=", 
  RowBox[{"Transmogrify", "[", 
   RowBox[{"nb", ",", "tr"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.39626471021947*^9, 3.396264715397411*^9}, {
  3.396276429928081*^9, 3.396276432034564*^9}, {3.397309967069274*^9, 
  3.397309967417078*^9}},
 CellID->353738618],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"Section", "[", 
   RowBox[{
    RowBox[{"Title", "[", 
     RowBox[{"{", 
      RowBox[{"\<\"CellGroupData\"\>", ",", "\<\"Cell\"\>", 
       ",", "\<\"Notebook\"\>"}], "}"}], "]"}], ",", 
    RowBox[{"Cell", "[", "\<\"Text1\"\>", "]"}], ",", 
    RowBox[{"Cell", "[", "\<\"Text2\"\>", "]"}]}], "]"}], "}"}]], "Output",
 CellChangeTimes->{{3.397241394428795*^9, 3.397241422325166*^9}, 
   3.39724146727796*^9, 3.397241520776672*^9, 3.397241568842939*^9, {
   3.397241612166366*^9, 3.397241625686529*^9}, 3.397302929956855*^9, 
   3.397303320671218*^9, 3.39730338154784*^9, {3.39730998362683*^9, 
   3.397310005194518*^9}, 3.397321731601547*^9, 3.397322097913055*^9, 
   3.397324326663033*^9, 3.398122583965749*^9},
 CellID->1050217830]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AppendTo", "[", 
  RowBox[{"Successes", ",", 
   RowBox[{"out", "===", 
    RowBox[{"{", 
     RowBox[{"Section", "[", 
      RowBox[{
       RowBox[{"Title", "[", 
        RowBox[{"{", 
         RowBox[{
         "\"\<CellGroupData\>\"", ",", "\"\<Cell\>\"", ",", 
          "\"\<Notebook\>\""}], "}"}], "]"}], ",", 
       RowBox[{"Cell", "[", "\"\<Text1\>\"", "]"}], ",", 
       RowBox[{"Cell", "[", "\"\<Text2\>\"", "]"}]}], "]"}], "}"}]}]}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.397309971163352*^9, 3.397309991974687*^9}, 
   3.397321739998021*^9},
 CellID->842974117],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"True", ",", "True"}], "}"}]], "Output",
 CellChangeTimes->{{3.39730998365157*^9, 3.397310005887697*^9}, 
   3.397321740527943*^9, 3.39732209795426*^9, 3.397324326753178*^9, 
   3.398122584051138*^9},
 CellID->916365160]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["SelectAncestors", "Section",
 CellChangeTimes->{{3.396276450006078*^9, 3.396276458222018*^9}},
 CellID->1744011483],

Cell[BoxData[
 RowBox[{
  RowBox[{"nb", "=", 
   RowBox[{"Notebook", "[", 
    RowBox[{"{", "\[IndentingNewLine]", 
     RowBox[{"Cell", "[", 
      RowBox[{"CellGroupData", "[", 
       RowBox[{
        RowBox[{"{", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"Cell", "[", 
           RowBox[{"\"\<Section\>\"", ",", "\"\<Section\>\""}], "]"}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{"Cell", "[", 
           RowBox[{"\"\<Text1\>\"", ",", "\"\<Text\>\""}], "]"}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{"Cell", "[", 
           RowBox[{"\"\<Text2\>\"", ",", "\"\<Text\>\""}], "]"}]}], 
         "\[IndentingNewLine]", "}"}], ",", "Open"}], "]"}], "]"}], "}"}], 
    "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.396264554826269*^9, 3.396264587662932*^9}},
 CellID->596696878],

Cell[BoxData[
 RowBox[{
  RowBox[{"tr", "=", 
   RowBox[{"XMLTransform", "[", 
    RowBox[{"{", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"_Notebook", "\[RuleDelayed]", 
       RowBox[{"{", 
        RowBox[{"Recurse", "[", "]"}], "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"_CellGroupData", "\[RuleDelayed]", 
       RowBox[{"Section", "[", 
        RowBox[{"Recurse", "[", "]"}], "]"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"Cell", ",", "\"\<Section\>\""}], "}"}], "\[RuleDelayed]", 
       RowBox[{"Title", "[", "\[IndentingNewLine]", 
        RowBox[{"ToString", "[", 
         RowBox[{
          RowBox[{"SelectAncestors", "[", "Cell", "]"}], "[", 
          RowBox[{"[", 
           RowBox[{"1", ",", "1", ",", "0"}], "]"}], "]"}], "]"}], 
        "\[IndentingNewLine]", "]"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"Cell", ",", "\"\<Text\>\""}], "}"}], "\[RuleDelayed]", 
       RowBox[{"Cell", "[", 
        RowBox[{"Recurse", "[", "]"}], "]"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"_String", "\[RuleDelayed]", 
       RowBox[{"SelectSelf", "[", "]"}]}]}], "\[IndentingNewLine]", "}"}], 
    "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.396276459894061*^9, 3.396276573653199*^9}, {
  3.397305882184185*^9, 3.397305926906646*^9}, {3.397321748080033*^9, 
  3.39732177070888*^9}},
 CellID->2083280703],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"out", "=", 
  RowBox[{"Transmogrify", "[", 
   RowBox[{"nb", ",", "tr"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.39626471021947*^9, 3.396264715397411*^9}, {
  3.396276429928081*^9, 3.396276432034564*^9}, {3.397310020685061*^9, 
  3.397310021064815*^9}},
 CellID->1125394633],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"Section", "[", 
   RowBox[{
    RowBox[{"Title", "[", "\<\"CellGroupData\"\>", "]"}], ",", 
    RowBox[{"Cell", "[", "\<\"Text1\"\>", "]"}], ",", 
    RowBox[{"Cell", "[", "\<\"Text2\"\>", "]"}]}], "]"}], "}"}]], "Output",
 CellChangeTimes->{{3.396276562560695*^9, 3.396276576258481*^9}, {
   3.397305915051658*^9, 3.397305929275153*^9}, 3.397310039448889*^9, 
   3.39732177220915*^9, 3.3973220983339*^9, 3.397324326870503*^9, 
   3.398122584236662*^9},
 CellID->1619117702]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AppendTo", "[", 
  RowBox[{"Successes", ",", "\[IndentingNewLine]", 
   RowBox[{"out", "===", 
    RowBox[{"{", 
     RowBox[{"Section", "[", 
      RowBox[{
       RowBox[{"Title", "[", "\"\<CellGroupData\>\"", "]"}], ",", 
       RowBox[{"Cell", "[", "\"\<Text1\>\"", "]"}], ",", 
       RowBox[{"Cell", "[", "\"\<Text2\>\"", "]"}]}], "]"}], "}"}]}]}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.397310026141004*^9, 3.397310035277353*^9}, 
   3.397321810785413*^9},
 CellID->1745926377],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"True", ",", "True", ",", "True"}], "}"}]], "Output",
 CellChangeTimes->{3.397310039471739*^9, 3.397321812154018*^9, 
  3.397322098640386*^9, 3.397324326897861*^9, 3.398122584330453*^9},
 CellID->568065631]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["SelectDescendants", "Section",
 CellChangeTimes->{{3.396276450006078*^9, 3.396276458222018*^9}, {
  3.397309570468206*^9, 3.397309572393563*^9}},
 CellID->1914249302],

Cell[BoxData[
 RowBox[{
  RowBox[{"nb", "=", 
   RowBox[{"Notebook", "[", 
    RowBox[{"{", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"Cell", "[", 
       RowBox[{"CellGroupData", "[", 
        RowBox[{
         RowBox[{"{", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"Cell", "[", 
            RowBox[{"\"\<Section1\>\"", ",", "\"\<Section\>\""}], "]"}], ",", 
           "\[IndentingNewLine]", 
           RowBox[{"Cell", "[", 
            RowBox[{"CellGroupData", "[", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"Cell", "[", 
                RowBox[{"\"\<Section11\>\"", ",", "\"\<Section\>\""}], "]"}], 
               "}"}], ",", "Open"}], "]"}], "]"}], ",", "\[IndentingNewLine]",
            
           RowBox[{"Cell", "[", 
            RowBox[{"CellGroupData", "[", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"Cell", "[", 
                RowBox[{"\"\<Section12\>\"", ",", "\"\<Section\>\""}], "]"}], 
               "}"}], ",", "Open"}], "]"}], "]"}]}], "\[IndentingNewLine]", 
          "}"}], ",", "Open"}], "]"}], "]"}], ",", "\[IndentingNewLine]", 
      RowBox[{"Cell", "[", 
       RowBox[{"CellGroupData", "[", 
        RowBox[{
         RowBox[{"{", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"Cell", "[", 
            RowBox[{"\"\<Section2\>\"", ",", "\"\<Section\>\""}], "]"}], ",", 
           "\[IndentingNewLine]", 
           RowBox[{"Cell", "[", 
            RowBox[{"CellGroupData", "[", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"Cell", "[", 
                RowBox[{"\"\<Section21\>\"", ",", "\"\<Section\>\""}], "]"}], 
               "}"}], ",", "Open"}], "]"}], "]"}], ",", "\[IndentingNewLine]",
            
           RowBox[{"Cell", "[", 
            RowBox[{"CellGroupData", "[", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"Cell", "[", 
                RowBox[{"\"\<Section22\>\"", ",", "\"\<Section\>\""}], "]"}], 
               "}"}], ",", "Open"}], "]"}], "]"}]}], "\[IndentingNewLine]", 
          "}"}], ",", "Open"}], "]"}], "]"}]}], "\[IndentingNewLine]", "}"}], 
    "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.396264554826269*^9, 3.396264587662932*^9}, {
  3.397309610150793*^9, 3.397309635845675*^9}, {3.397309713614921*^9, 
  3.397309744985901*^9}, {3.397313226030961*^9, 3.397313230987143*^9}, {
  3.397313354930436*^9, 3.397313373774547*^9}},
 CellID->1335503007],

Cell[BoxData[
 RowBox[{
  RowBox[{"tr", "=", 
   RowBox[{"XMLTransform", "[", 
    RowBox[{"{", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"_Notebook", "\[RuleDelayed]", 
       RowBox[{"{", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"Transmogrify", "[", "\[IndentingNewLine]", 
          RowBox[{"SelectDescendants", "[", 
           RowBox[{"{", 
            RowBox[{"CellGroupData", ",", "\"\<Section\>\""}], "}"}], "]"}], 
          "\[IndentingNewLine]", "]"}], ",", "\[IndentingNewLine]", 
         RowBox[{"Transmogrify", "[", "\[IndentingNewLine]", 
          RowBox[{"SelectNearestDescendants", "[", 
           RowBox[{"{", 
            RowBox[{"CellGroupData", ",", "\"\<Section\>\""}], "}"}], "]"}], 
          "\[IndentingNewLine]", "]"}]}], "}"}]}], ",", "\[IndentingNewLine]",
       
      RowBox[{"_CellGroupData", "\[RuleDelayed]", 
       RowBox[{"Section", "[", 
        RowBox[{"Recurse", "[", "]"}], "]"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"Cell", ",", "All"}], "}"}], "\[RuleDelayed]", 
       RowBox[{"Recurse", "[", "]"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"_String", "\[RuleDelayed]", 
       RowBox[{"SelectSelf", "[", "]"}]}]}], "\[IndentingNewLine]", "}"}], 
    "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.396276459894061*^9, 3.396276573653199*^9}, {
  3.397305882184185*^9, 3.397305926906646*^9}, {3.39731261596732*^9, 
  3.397312707434303*^9}, {3.397313239205361*^9, 3.397313242129468*^9}, {
  3.397313776599507*^9, 3.397313906149907*^9}, {3.397321535143468*^9, 
  3.397321536375877*^9}},
 CellID->299960205],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"out", "=", 
  RowBox[{"Transmogrify", "[", 
   RowBox[{"nb", ",", "tr"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.39626471021947*^9, 3.396264715397411*^9}, {
  3.396276429928081*^9, 3.396276432034564*^9}, {3.397313119386471*^9, 
  3.397313119802107*^9}},
 CellID->1287045926],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Section", "[", 
    RowBox[{"\<\"Section1\"\>", ",", 
     RowBox[{"Section", "[", "\<\"Section11\"\>", "]"}], ",", 
     RowBox[{"Section", "[", "\<\"Section12\"\>", "]"}]}], "]"}], ",", 
   RowBox[{"Section", "[", "\<\"Section11\"\>", "]"}], ",", 
   RowBox[{"Section", "[", "\<\"Section12\"\>", "]"}], ",", 
   RowBox[{"Section", "[", 
    RowBox[{"\<\"Section2\"\>", ",", 
     RowBox[{"Section", "[", "\<\"Section21\"\>", "]"}], ",", 
     RowBox[{"Section", "[", "\<\"Section22\"\>", "]"}]}], "]"}], ",", 
   RowBox[{"Section", "[", "\<\"Section21\"\>", "]"}], ",", 
   RowBox[{"Section", "[", "\<\"Section22\"\>", "]"}], ",", 
   RowBox[{"Section", "[", 
    RowBox[{"\<\"Section1\"\>", ",", 
     RowBox[{"Section", "[", "\<\"Section11\"\>", "]"}], ",", 
     RowBox[{"Section", "[", "\<\"Section12\"\>", "]"}]}], "]"}], ",", 
   RowBox[{"Section", "[", 
    RowBox[{"\<\"Section2\"\>", ",", 
     RowBox[{"Section", "[", "\<\"Section21\"\>", "]"}], ",", 
     RowBox[{"Section", "[", "\<\"Section22\"\>", "]"}]}], "]"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{
  3.397313748798105*^9, {3.397313792167267*^9, 3.397313908602822*^9}, 
   3.397321541239536*^9, 3.397322098972151*^9, 3.39732432702944*^9, 
   3.398122584780095*^9},
 CellID->1925585698]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AppendTo", "[", 
  RowBox[{"Successes", ",", "\[IndentingNewLine]", 
   RowBox[{"out", "===", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Section", "[", 
       RowBox[{"\"\<Section1\>\"", ",", 
        RowBox[{"Section", "[", "\"\<Section11\>\"", "]"}], ",", 
        RowBox[{"Section", "[", "\"\<Section12\>\"", "]"}]}], "]"}], ",", 
      RowBox[{"Section", "[", "\"\<Section11\>\"", "]"}], ",", 
      RowBox[{"Section", "[", "\"\<Section12\>\"", "]"}], ",", 
      RowBox[{"Section", "[", 
       RowBox[{"\"\<Section2\>\"", ",", 
        RowBox[{"Section", "[", "\"\<Section21\>\"", "]"}], ",", 
        RowBox[{"Section", "[", "\"\<Section22\>\"", "]"}]}], "]"}], ",", 
      RowBox[{"Section", "[", "\"\<Section21\>\"", "]"}], ",", 
      RowBox[{"Section", "[", "\"\<Section22\>\"", "]"}], ",", 
      RowBox[{"Section", "[", 
       RowBox[{"\"\<Section1\>\"", ",", 
        RowBox[{"Section", "[", "\"\<Section11\>\"", "]"}], ",", 
        RowBox[{"Section", "[", "\"\<Section12\>\"", "]"}]}], "]"}], ",", 
      RowBox[{"Section", "[", 
       RowBox[{"\"\<Section2\>\"", ",", 
        RowBox[{"Section", "[", "\"\<Section21\>\"", "]"}], ",", 
        RowBox[{"Section", "[", "\"\<Section22\>\"", "]"}]}], "]"}]}], 
     "}"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.397313928185955*^9, 3.397313945168966*^9}, {
   3.397321523084567*^9, 3.397321529851626*^9}, 3.397321583538417*^9},
 CellID->740265996],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"True", ",", "True", ",", "True", ",", "True"}], "}"}]], "Output",
 CellChangeTimes->{3.397313946431448*^9, 3.39732158424436*^9, 
  3.39732209960119*^9, 3.397324327052297*^9, 3.398122584883772*^9},
 CellID->1277827701]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["RowBox", "Section",
 CellChangeTimes->{{3.396276450006078*^9, 3.396276458222018*^9}, {
  3.397309570468206*^9, 3.397309572393563*^9}, {3.397321834584257*^9, 
  3.39732183542964*^9}},
 CellID->1613700707],

Cell[BoxData[
 RowBox[{
  RowBox[{"nb", "=", 
   RowBox[{"Notebook", "[", 
    RowBox[{"{", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"Cell", "[", 
       RowBox[{"BoxData", "[", 
        RowBox[{"RowBox", "[", 
         RowBox[{"{", 
          RowBox[{"\"\<2\>\"", ",", "\"\<+\>\"", ",", "\"\<2\>\""}], "}"}], 
         "]"}], "]"}], "]"}], ",", "\[IndentingNewLine]", 
      RowBox[{"Cell", "[", 
       RowBox[{"BoxData", "[", 
        RowBox[{"RowBox", "[", 
         RowBox[{"{", 
          RowBox[{"\"\<2\>\"", ",", "\"\<+\>\"", ",", "\"\<3\>\""}], "}"}], 
         "]"}], "]"}], "]"}], ",", "\[IndentingNewLine]", 
      RowBox[{"Cell", "[", 
       RowBox[{"BoxData", "[", 
        RowBox[{"RowBox", "[", 
         RowBox[{"{", 
          RowBox[{"\"\<2\>\"", ",", "\"\<+\>\"", ",", "\"\<2\>\""}], "}"}], 
         "]"}], "]"}], "]"}]}], "\[IndentingNewLine]", "}"}], "]"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.396264554826269*^9, 3.396264587662932*^9}, {
  3.397309610150793*^9, 3.397309635845675*^9}, {3.397309713614921*^9, 
  3.397309744985901*^9}, {3.397313226030961*^9, 3.397313230987143*^9}, {
  3.397313354930436*^9, 3.397313373774547*^9}, {3.397321839805054*^9, 
  3.39732185391768*^9}, {3.397321922981592*^9, 3.3973219422446*^9}},
 CellID->896804586],

Cell[BoxData[
 RowBox[{
  RowBox[{"tr", "=", 
   RowBox[{"XMLTransform", "[", 
    RowBox[{"{", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"_Notebook", "\[RuleDelayed]", 
       RowBox[{"{", 
        RowBox[{"Recurse", "[", "]"}], "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"_Cell", "\[RuleDelayed]", 
       RowBox[{"Recurse", "[", "]"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"_BoxData", "\[RuleDelayed]", 
       RowBox[{"Recurse", "[", "]"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"_RowBox", "\[RuleDelayed]", 
       RowBox[{
        RowBox[{"Head", "[", 
         RowBox[{"SelectParent", "[", "]"}], "]"}], "[", 
        RowBox[{"Recurse", "[", "]"}], "]"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"_String", "\[RuleDelayed]", 
       RowBox[{"SelectSelf", "[", "]"}]}]}], "\[IndentingNewLine]", "}"}], 
    "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.396276459894061*^9, 3.396276573653199*^9}, {
  3.397305882184185*^9, 3.397305926906646*^9}, {3.39731261596732*^9, 
  3.397312707434303*^9}, {3.397313239205361*^9, 3.397313242129468*^9}, {
  3.397313776599507*^9, 3.397313906149907*^9}, {3.397321535143468*^9, 
  3.397321536375877*^9}, {3.397321860633043*^9, 3.397321907105089*^9}, {
  3.397400781960878*^9, 3.397400798197074*^9}},
 CellID->1554442256],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"out", "=", 
  RowBox[{"Transmogrify", "[", 
   RowBox[{"nb", ",", "tr"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.39626471021947*^9, 3.396264715397411*^9}, {
  3.396276429928081*^9, 3.396276432034564*^9}, {3.397313119386471*^9, 
  3.397313119802107*^9}},
 CellID->1372430837],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"BoxData", "[", 
    RowBox[{"\<\"2\"\>", ",", "\<\"+\"\>", ",", "\<\"2\"\>"}], "]"}], ",", 
   RowBox[{"BoxData", "[", 
    RowBox[{"\<\"2\"\>", ",", "\<\"+\"\>", ",", "\<\"3\"\>"}], "]"}], ",", 
   RowBox[{"BoxData", "[", 
    RowBox[{"\<\"2\"\>", ",", "\<\"+\"\>", ",", "\<\"2\"\>"}], "]"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{
  3.397313748798105*^9, {3.397313792167267*^9, 3.397313908602822*^9}, 
   3.397321541239536*^9, 3.397321909024365*^9, 3.397321947143669*^9, 
   3.397322101776722*^9, 3.397324327662201*^9, 3.397400750904029*^9, 
   3.397400799657397*^9, 3.397400865819717*^9, 3.397400903294192*^9, 
   3.39740111585959*^9, 3.397401757917233*^9, 3.397401804444208*^9, {
   3.397401844812114*^9, 3.397401870767847*^9}, 3.39740196316819*^9, 
   3.397402054935797*^9, 3.397402087601506*^9, 3.397402445242035*^9, 
   3.398122585086914*^9},
 CellID->323225032]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AppendTo", "[", 
  RowBox[{"Successes", ",", "\[IndentingNewLine]", 
   RowBox[{"out", "===", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"BoxData", "[", 
       RowBox[{"\"\<2\>\"", ",", "\"\<+\>\"", ",", "\"\<2\>\""}], "]"}], ",", 
      
      RowBox[{"BoxData", "[", 
       RowBox[{"\"\<2\>\"", ",", "\"\<+\>\"", ",", "\"\<3\>\""}], "]"}], ",", 
      
      RowBox[{"BoxData", "[", 
       RowBox[{"\"\<2\>\"", ",", "\"\<+\>\"", ",", "\"\<2\>\""}], "]"}]}], 
     "}"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.397313928185955*^9, 3.397313945168966*^9}, {
   3.397321523084567*^9, 3.397321529851626*^9}, 3.397321583538417*^9, 
   3.397321918302557*^9, {3.397321966207042*^9, 3.397321971373601*^9}},
 CellID->1456969561],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"True", ",", "True", ",", "True", ",", "True", ",", "True"}], 
  "}"}]], "Output",
 CellChangeTimes->{3.397313946431448*^9, 3.39732158424436*^9, 
  3.397321918952704*^9, 3.397321972526995*^9, 3.397322102746074*^9, 
  3.397324327805783*^9, 3.397402447865802*^9, 3.3981225851996803`*^9},
 CellID->1678868633]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["GetStyle", "Section",
 CellChangeTimes->{{3.396276450006078*^9, 3.396276458222018*^9}, {
  3.397309570468206*^9, 3.397309572393563*^9}, {3.397321834584257*^9, 
  3.39732183542964*^9}, {3.397324143653502*^9, 3.397324145210337*^9}},
 CellID->957476898],

Cell[BoxData[
 RowBox[{
  RowBox[{"nb", "=", 
   RowBox[{"Notebook", "[", 
    RowBox[{"{", "\[IndentingNewLine]", 
     RowBox[{"Cell", "[", 
      RowBox[{
       RowBox[{"ButtonBox", "[", 
        RowBox[{"\"\<CLICK\>\"", ",", 
         RowBox[{"BaseStyle", "\[Rule]", "\"\<Button\>\""}]}], "]"}], ",", 
       "\"\<Text\>\""}], "]"}], "\[IndentingNewLine]", "}"}], "]"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.396264554826269*^9, 3.396264587662932*^9}, {
  3.397309610150793*^9, 3.397309635845675*^9}, {3.397309713614921*^9, 
  3.397309744985901*^9}, {3.397313226030961*^9, 3.397313230987143*^9}, {
  3.397313354930436*^9, 3.397313373774547*^9}, {3.397321839805054*^9, 
  3.39732185391768*^9}, {3.397321922981592*^9, 3.3973219422446*^9}, {
  3.397324150586135*^9, 3.397324172343927*^9}},
 CellID->1219257715],

Cell[BoxData[
 RowBox[{
  RowBox[{"tr", "=", 
   RowBox[{"XMLTransform", "[", 
    RowBox[{"{", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"_Notebook", "\[RuleDelayed]", 
       RowBox[{"{", 
        RowBox[{"Recurse", "[", "]"}], "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"_Cell", "\[RuleDelayed]", 
       RowBox[{
        RowBox[{"GetStyle", "[", "]"}], "[", 
        RowBox[{"Recurse", "[", "]"}], "]"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"_ButtonBox", "\[RuleDelayed]", 
       RowBox[{
        RowBox[{"GetStyle", "[", "]"}], "[", 
        RowBox[{"Recurse", "[", "]"}], "]"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"_String", "\[RuleDelayed]", 
       RowBox[{"SelectSelf", "[", "]"}]}]}], "\[IndentingNewLine]", "}"}], 
    "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.396276459894061*^9, 3.396276573653199*^9}, {
  3.397305882184185*^9, 3.397305926906646*^9}, {3.39731261596732*^9, 
  3.397312707434303*^9}, {3.397313239205361*^9, 3.397313242129468*^9}, {
  3.397313776599507*^9, 3.397313906149907*^9}, {3.397321535143468*^9, 
  3.397321536375877*^9}, {3.397321860633043*^9, 3.397321907105089*^9}, {
  3.397324211266286*^9, 3.39732423063571*^9}},
 CellID->775456331],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"out", "=", 
  RowBox[{"Transmogrify", "[", 
   RowBox[{"nb", ",", "tr"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.39626471021947*^9, 3.396264715397411*^9}, {
  3.396276429928081*^9, 3.396276432034564*^9}, {3.397313119386471*^9, 
  3.397313119802107*^9}},
 CellID->16301474],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"Text\"\>", "[", 
   RowBox[{"\<\"Button\"\>", "[", "\<\"CLICK\"\>", "]"}], "]"}], 
  "}"}]], "Output",
 CellChangeTimes->{
  3.397313748798105*^9, {3.397313792167267*^9, 3.397313908602822*^9}, 
   3.397321541239536*^9, 3.397321909024365*^9, 3.397321947143669*^9, 
   3.397322101776722*^9, 3.397324248283614*^9, 3.39732429667459*^9, 
   3.397324327913908*^9, 3.398122585380432*^9},
 CellID->1248450349]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AppendTo", "[", 
  RowBox[{"Successes", ",", "\[IndentingNewLine]", 
   RowBox[{"out", "===", 
    RowBox[{"{", 
     RowBox[{"\"\<Text\>\"", "[", 
      RowBox[{"\"\<Button\>\"", "[", "\"\<CLICK\>\"", "]"}], "]"}], "}"}]}]}],
   "]"}]], "Input",
 CellChangeTimes->{{3.397313928185955*^9, 3.397313945168966*^9}, {
   3.397321523084567*^9, 3.397321529851626*^9}, 3.397321583538417*^9, 
   3.397321918302557*^9, {3.397321966207042*^9, 3.397321971373601*^9}, {
   3.397324237720119*^9, 3.397324245662292*^9}},
 CellID->1789784453],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "True", ",", "True", ",", "True", ",", "True", ",", "True", ",", "True"}], 
  "}"}]], "Output",
 CellChangeTimes->{
  3.397313946431448*^9, 3.39732158424436*^9, 3.397321918952704*^9, 
   3.397321972526995*^9, 3.397322102746074*^9, 3.397324250935864*^9, {
   3.397324309360762*^9, 3.397324327924054*^9}, 3.39812258545656*^9},
 CellID->1103858042]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Successes", "Section",
 CellChangeTimes->{{3.396276450006078*^9, 3.396276458222018*^9}, {
  3.397309570468206*^9, 3.397309572393563*^9}, {3.397310066233133*^9, 
  3.397310067561025*^9}},
 CellID->430885461],

Cell[CellGroupData[{

Cell[BoxData["Successes"], "Input",
 CellChangeTimes->{{3.397322135186371*^9, 3.397322137760337*^9}},
 CellID->577085343],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "True", ",", "True", ",", "True", ",", "True", ",", "True", ",", "True"}], 
  "}"}]], "Output",
 CellChangeTimes->{3.397322138328351*^9, 3.397324328012801*^9, 
  3.398122585766966*^9},
 CellID->1037209949]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"And", "@@", "Successes"}]], "Input",
 CellChangeTimes->{{3.397310073098598*^9, 3.397310075429987*^9}},
 CellID->1262850144],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{3.397310076467726*^9, 3.397322139907511*^9, 
  3.39732432803448*^9, 3.398122585853766*^9},
 CellID->1141486907]
}, Open  ]],

Cell[CellGroupData[{

Cell["More About", "TutorialMoreAboutSection",
 CellID->23220180],

Cell["XXXX", "TutorialMoreAbout",
 CellID->1567025153]
}, Open  ]],

Cell[CellGroupData[{

Cell["Related Tutorials", "RelatedTutorialsSection",
 CellID->415694126],

Cell["XXXX", "RelatedTutorials",
 CellID->806871991]
}, Open  ]],

Cell[CellGroupData[{

Cell["Related Wolfram Education Group Courses", "TutorialRelatedLinksSection",
 CellID->415694148],

Cell["XXXX", "TutorialRelatedLinks",
 CellID->415694149]
}, Open  ]]
}, Open  ]]
},
WindowSize->{640, 710},
WindowMargins->{{-1, Automatic}, {Automatic, 0}},
FrontEndVersion->"6.1 for Mac OS X x86 (32-bit) (March 24, 2008)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "TutorialPageStyles.nb", 
  CharacterEncoding -> "UTF-8"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[545, 20, 392, 15, 23, "History",
 CellID->1247902091],
Cell[CellGroupData[{
Cell[962, 39, 68, 1, 27, "CategorizationSection",
 CellID->1122911449],
Cell[1033, 42, 81, 2, 30, "Categorization",
 CellID->686433507],
Cell[1117, 46, 153, 3, 30, "Categorization",
 CellID->605800465],
Cell[1273, 51, 148, 3, 30, "Categorization",
 CellID->468444828],
Cell[1424, 56, 173, 3, 30, "Categorization",
 CellID->198121836]
}, Closed]],
Cell[CellGroupData[{
Cell[1634, 64, 56, 1, 17, "SynonymsSection",
 CellID->1427418553],
Cell[1693, 67, 45, 1, 17, "Synonyms",
 CellID->1251652828]
}, Closed]],
Cell[CellGroupData[{
Cell[1775, 73, 56, 1, 17, "KeywordsSection",
 CellID->1427428552],
Cell[1834, 76, 110, 2, 17, "Keywords",
 CellID->1251852827],
Cell[1947, 80, 110, 2, 17, "Keywords",
 CellID->152954738]
}, Closed]],
Cell[CellGroupData[{
Cell[2094, 87, 54, 1, 17, "DetailsSection",
 CellID->1234044802],
Cell[2151, 90, 69, 2, 30, "Details",
 CellID->193924488],
Cell[2223, 94, 68, 2, 30, "Details",
 CellID->1556177317]
}, Closed]],
Cell[2306, 99, 223, 4, 104, "Title",
 CellID->509267359],
Cell[CellGroupData[{
Cell[2554, 107, 218, 4, 41, "Section",
 CellID->1499027298],
Cell[2775, 113, 182, 4, 23, "Input",
 CellID->2021134529],
Cell[2960, 119, 180, 5, 23, "Input",
 CellID->311700657]
}, Open  ]],
Cell[CellGroupData[{
Cell[3177, 129, 169, 3, 41, "Section",
 CellID->1322515262],
Cell[3349, 134, 833, 21, 99, "Input",
 CellID->1058261984],
Cell[4185, 157, 1310, 30, 114, "Input",
 CellID->749600634],
Cell[CellGroupData[{
Cell[5520, 191, 299, 7, 23, "Input",
 CellID->1398782336],
Cell[5822, 200, 801, 16, 22, "Output",
 CellID->831237443]
}, Open  ]],
Cell[CellGroupData[{
Cell[6660, 221, 618, 16, 54, "Input",
 CellID->1226580766],
Cell[7281, 239, 264, 6, 22, "Output",
 CellID->1447406609]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[7594, 251, 167, 3, 41, "Section",
 CellID->2015607894],
Cell[7764, 256, 833, 21, 99, "Input",
 CellID->1914826680],
Cell[8600, 279, 1655, 39, 129, "Input",
 CellID->302076818],
Cell[CellGroupData[{
Cell[10280, 322, 299, 7, 23, "Input",
 CellID->353738618],
Cell[10582, 331, 775, 16, 38, "Output",
 CellID->1050217830]
}, Open  ]],
Cell[CellGroupData[{
Cell[11394, 352, 603, 17, 54, "Input",
 CellID->842974117],
Cell[12000, 371, 259, 6, 22, "Output",
 CellID->916365160]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[12308, 383, 121, 2, 41, "Section",
 CellID->1744011483],
Cell[12432, 387, 832, 21, 99, "Input",
 CellID->596696878],
Cell[13267, 410, 1427, 33, 144, "Input",
 CellID->2083280703],
Cell[CellGroupData[{
Cell[14719, 447, 300, 7, 23, "Input",
 CellID->1125394633],
Cell[15022, 456, 514, 11, 22, "Output",
 CellID->1619117702]
}, Open  ]],
Cell[CellGroupData[{
Cell[15573, 472, 511, 13, 39, "Input",
 CellID->1745926377],
Cell[16087, 487, 245, 5, 22, "Output",
 CellID->568065631]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[16381, 498, 172, 3, 41, "Section",
 CellID->1914249302],
Cell[16556, 503, 2489, 59, 189, "Input",
 CellID->1335503007],
Cell[19048, 564, 1629, 35, 189, "Input",
 CellID->299960205],
Cell[CellGroupData[{
Cell[20702, 603, 300, 7, 23, "Input",
 CellID->1287045926],
Cell[21005, 612, 1311, 28, 98, "Output",
 CellID->1925585698]
}, Open  ]],
Cell[CellGroupData[{
Cell[22353, 645, 1446, 29, 129, "Input",
 CellID->740265996],
Cell[23802, 676, 257, 5, 22, "Output",
 CellID->1277827701]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[24108, 687, 209, 4, 41, "Section",
 CellID->1613700707],
Cell[24320, 693, 1285, 30, 84, "Input",
 CellID->896804586],
Cell[25608, 725, 1300, 27, 114, "Input",
 CellID->1554442256],
Cell[CellGroupData[{
Cell[26933, 756, 300, 7, 23, "Input",
 CellID->1372430837],
Cell[27236, 765, 925, 19, 22, "Output",
 CellID->323225032]
}, Open  ]],
Cell[CellGroupData[{
Cell[28198, 789, 755, 18, 54, "Input",
 CellID->1456969561],
Cell[28956, 809, 345, 7, 22, "Output",
 CellID->1678868633]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[29350, 822, 256, 4, 41, "Section",
 CellID->957476898],
Cell[29609, 828, 818, 18, 54, "Input",
 CellID->1219257715],
Cell[30430, 848, 1215, 26, 99, "Input",
 CellID->775456331],
Cell[CellGroupData[{
Cell[31670, 878, 298, 7, 23, "Input",
 CellID->16301474],
Cell[31971, 887, 445, 10, 22, "Output",
 CellID->1248450349]
}, Open  ]],
Cell[CellGroupData[{
Cell[32453, 902, 551, 12, 39, "Input",
 CellID->1789784453],
Cell[33007, 916, 387, 9, 22, "Output",
 CellID->1103858042]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[33443, 931, 212, 4, 41, "Section",
 CellID->430885461],
Cell[CellGroupData[{
Cell[33680, 939, 121, 2, 23, "Input",
 CellID->577085343],
Cell[33804, 943, 247, 7, 22, "Output",
 CellID->1037209949]
}, Open  ]],
Cell[CellGroupData[{
Cell[34088, 955, 147, 3, 23, "Input",
 CellID->1262850144],
Cell[34238, 960, 162, 3, 22, "Output",
 CellID->1141486907]
}, Open  ]],
Cell[CellGroupData[{
Cell[34437, 968, 65, 1, 71, "TutorialMoreAboutSection",
 CellID->23220180],
Cell[34505, 971, 54, 1, 20, "TutorialMoreAbout",
 CellID->1567025153]
}, Open  ]],
Cell[CellGroupData[{
Cell[34596, 977, 72, 1, 71, "RelatedTutorialsSection",
 CellID->415694126],
Cell[34671, 980, 52, 1, 20, "RelatedTutorials",
 CellID->806871991]
}, Open  ]],
Cell[CellGroupData[{
Cell[34760, 986, 98, 1, 71, "TutorialRelatedLinksSection",
 CellID->415694148],
Cell[34861, 989, 56, 1, 20, "TutorialRelatedLinks",
 CellID->415694149]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
