(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 7.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    124137,       3615]
NotebookOptionsPosition[    106990,       3199]
NotebookOutlinePosition[    115721,       3409]
CellTagsIndexPosition[    115566,       3402]
WindowTitle->DocumentationTools
WindowFrame->Palette*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[GridBox[{
   {
    TooltipBox[
     ButtonBox[
      RowBox[{"F", "      "}],
      BaseStyle->"PaletteTabSelected",
      ButtonData:>"FunctionsExternal"],
     "Function page features.",
     TooltipDelay->0.35], 
    TooltipBox[
     ButtonBox[
      RowBox[{"G", "       "}],
      BaseStyle->"PaletteTab",
      ButtonData:>"GuidesExternal"],
     "Guide page features.",
     TooltipDelay->0.35], 
    TooltipBox[
     ButtonBox[
      RowBox[{"T", "       "}],
      BaseStyle->"PaletteTab",
      ButtonData:>"TutorialsExternal"],
     "Tutorial page features.",
     TooltipDelay->0.35], 
    TooltipBox[
     ButtonBox["\[UpDownArrow]",
      BaseStyle->"ScrollToggle"],
     "Turn vertical scroll bar on or off.",
     TooltipDelay->0.35]}
  },
  GridBoxItemSize->{"Columns" -> {
      Scaled[0.3], 
      Scaled[0.285], 
      Scaled[0.285], 
      Scaled[0.17], {
       Scaled[0.11]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
    "RowsIndexed" -> {}},
  GridBoxSpacings->{"Columns" -> {
      Offset[0.27999999999999997`], {
       Offset[0.]}, 
      Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
      Offset[0.2], {
       Offset[0.]}, 
      Offset[0.2]}, "RowsIndexed" -> {}}]], "PaletteTabCell",
 PageBreakAbove->False,
 CellTags->"FunctionsExternal"],

Cell[BoxData[GridBox[{
   {
    TooltipBox[
     ButtonBox[
      RowBox[{"New", " ", "Function", " ", "Page"}],
      BaseStyle->"BoldButton",
      ButtonData:>Hold[
        DocumentationTools`CreateNewPageDialog["Reference"]],
      Method->"Queued"],
     "Start new function document.\nSet version number string using \
$MVersion.\nUse FunctionPageForSymbol to create function page templates \
programmatically.",
     TooltipDelay->0.35]},
   {
    TooltipBox[
     ButtonBox[
      RowBox[{"Sample", " ", "Function", " ", "Page", "\[VeryThinSpace]"}],
      BaseStyle->"MediumButtonDark",
      ButtonData:>Hold[
        NotebookOpen[
         ToFileName[{DocumentationTools`$DocuToolsDir, "Examples"}, 
          "FunctionExample.nb"]]]],
     "Sample function page.",
     TooltipDelay->0.35]},
   {GridBox[{
      {
       TooltipBox[
        ButtonBox[
         RowBox[{
          RowBox[{
           RowBox[{"Set", " ", "Paclet", " ", "Name"}], " ", "&"}], " ", 
          "Path"}],
         BaseStyle->"TinyButtonDark",
         ButtonData->
          "DocumentationTools`DocumentationDirSelect[\"Interactive\"\[Rule]\
True]",
         Method->"Queued"],
        "Use this to select the paclet (application pack) directory \
containing your working documentation source file layout.\nYour selection is \
stored in the front end init.m as $DocumentationDirectory, from which \
$ApplicationName is derived for configuring the link base in hyperlinks to \
other documents in the same paclet layout.\nThe paclet's parent directory \
also becomes part of $DocumentationPath to support links to documents in \
other paclet projects on the path.",
        TooltipDelay->0.35], 
       TooltipBox[
        ButtonBox[
         StyleBox["M",
          FontWeight->"Bold",
          FontColor->GrayLevel[0.7]],
         Background->GrayLevel[0.4],
         BaseStyle->"TinyButtonDark",
         ButtonData->"DocumentationTools`SetPacletVariables",
         Method->"Queued"],
        "Use this to configure $ApplicationName and $LinkBase manually, \
primarily when the link base is not the same as your application name.",
        TooltipDelay->0.35]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
        "RowsIndexed" -> {}},
     GridBoxItemSize->{"Columns" -> {
         Scaled[0.9], {
          Scaled[0.09]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}]},
   {
    TooltipBox[
     ButtonBox[
      RowBox[{"Double", " ", "Usage", " ", "Line"}],
      BaseStyle->"BigButton",
      ButtonData:>Hold[DocumentationTools`DoubleUsageLinesInsert]],
     "Use this to insert a new usage message template directly after the \
cursor position.\nEsc\[Dash]ls\[Dash]Esc inserts a line separator (soft \
carriage return)\nwhich separates the function template from the second line \
of text.",
     TooltipDelay->0.35]},
   {
    TooltipBox[
     ButtonBox[
      RowBox[{"Template", " ", "Input"}],
      BaseStyle->"BigButton",
      ButtonData:>Hold[DocumentationTools`FunctionTemplateToggle]],
     "Use this for function templates. Lower case words will be italic.\n\
xxx$yyy makes yyy a subscript. $$ gives ...\nFunction names will become links \
when appropriate.\nRefer to format menu for shortcut (custom menu items are \
in brackets).\nUse shortcut after typing for autoselection.\nApplying this in \
series toggles formatted and raw template text.",
     TooltipDelay->0.35]},
   {
    TooltipBox[
     ButtonBox[
      RowBox[{"Inline", " ", "Listing", " ", "Toggle"}],
      BaseStyle->"BigButton",
      ButtonData:>Hold[
        DocumentationTools`InlineListingToggle["TargetStyle" -> Automatic]]],
     "Toggles formatting back and forth between plain text and inline listing \
with hyperlinks and formatted delimiters appropriate for the cell the \
selection is in.\nTo make a link to a function page for a symbol in another \
application, list it along with the other symbols to be linked as \
otherapplicationlinkbase/ref/symbol.\nInsertion between cells creates See \
Also listing template.\nUse space.space to indicate delimiters.",
     TooltipDelay->0.35]}
  }]], "PaletteGridCell",
 GridBoxOptions->{ColumnsEqual->True,
 GridBoxDividers->{
  "Columns" -> {False, {True}, False}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, {True}, False}, "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {{
      Scaled[0.999]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{"Columns" -> {
     Offset[0.27999999999999997`], {
      Offset[-0.06999999999999999]}, 
     Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
     Offset[0.2], 
     Offset[0.12], 
     Offset[0.], 
     Offset[0.8], 
     Offset[0.2], {
      Offset[0.4]}, 
     Offset[0.2]}, "RowsIndexed" -> {}}}],

Cell["\<\
 







\
\>", "Spacer"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {
    TooltipBox[
     ButtonBox[
      RowBox[{"Notes", "  ", "\[FilledDownTriangle]"}],
      BaseStyle->"ButtonGroupHead"],
     "Choices for inserting notes table templates.\nUse Text button to insert \
table with pure text format inline cells as elements.\nSelect the entire \
inline cell element and delete to restore normal input format placeholder.",
     TooltipDelay->0.35]}
  },
  GridBoxItemSize->{"Columns" -> {{
       Scaled[0.999]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
    "RowsIndexed" -> {}}]], "ButtonGroupHead",
 CellGroupingRules->{"GroupTogetherNestedGrouping", 100}],

Cell[CellGroupData[{

Cell[" ", "Spacer",
 CellGroupingRules->{"GroupTogetherNestedGrouping", 101}],

Cell[" ", "Spacer",
 CellGroupingRules->{"GroupTogetherNestedGrouping", 101}],

Cell[BoxData[GridBox[{
   {
    TooltipBox[
     ButtonBox["Note",
      BaseStyle->"SmallButton",
      ButtonData:>Hold[
        DocumentationTools`StyleApply["Notes"]]],
     "Insert Notes cell or apply Notes style to selection.",
     TooltipDelay->0.35]},
   {
    TooltipBox[
     ButtonBox[
      RowBox[{"Options", " ", "Table"}],
      BaseStyle->"MediumButton",
      ButtonData->"DocumentationTools`OptionsTableCreate",
      Method->"Queued"],
     "A dialog lets you select options in table inserted in the notes area.",
     TooltipDelay->0.35]},
   {
    TooltipBox[
     ButtonBox["TableTools",
      Active->False,
      BaseStyle->"ButtonSubGroupHead"],
     "Various tools for table construction.",
     TooltipDelay->0.35]},
   {GridBox[{
      {
       ButtonBox[
        RowBox[{"1", " ", "Col"}],
        BaseStyle->"MediumButton",
        ButtonData:>Hold[
          DocumentationTools`TableInsert[
          2, DocumentationTools`PlaceholderObject -> {
             Cell["      ", "ModInfo"], "XXXX"}]]], 
       ButtonBox[
        RowBox[{"1", " ", "Text"}],
        BaseStyle->"MediumButton",
        ButtonData:>Hold[
          DocumentationTools`TableInsert[2]]]},
      {
       ButtonBox[
        RowBox[{"2", " ", "Col"}],
        BaseStyle->"MediumButton",
        ButtonData:>Hold[
          DocumentationTools`TableInsert[3]]], 
       ButtonBox[
        RowBox[{"2", " ", "Text"}],
        BaseStyle->"MediumButton",
        ButtonData:>Hold[
          DocumentationTools`TableInsert[
          3, DocumentationTools`PlaceholderObject -> {
             Cell["      ", "ModInfo"], 
             Cell["XXXX", "TableText"]}]]]},
      {
       ButtonBox[
        RowBox[{"3", " ", "Col"}],
        BaseStyle->"MediumButton",
        ButtonData:>Hold[
          DocumentationTools`TableInsert[4]]], 
       ButtonBox[
        RowBox[{"3", " ", "Text"}],
        BaseStyle->"MediumButton",
        ButtonData:>Hold[
          DocumentationTools`TableInsert[
          4, DocumentationTools`PlaceholderObject -> {
             Cell["      ", "ModInfo"], 
             Cell["XXXX", "TableText"]}]]]}
     },
     GridBoxDividers->{
      "Columns" -> {False, {True}, False}, "ColumnsIndexed" -> {}, 
       "Rows" -> {False, {True}, False}, "RowsIndexed" -> {}},
     GridBoxItemSize->{"Columns" -> {{
          Scaled[0.5]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}]},
   {
    TooltipBox[
     ButtonBox[
      RowBox[{"Insert", " ", "Custom", " ", "Table"}],
      BaseStyle->"MediumButton",
      ButtonData:>Hold[DocumentationTools`TableInsertDialog]],
     "Insert a table with user specified number of rows.\nAlso indicate \
whether text only and 2 or 3 columns.",
     TooltipDelay->0.35]},
   {
    TooltipBox[
     ButtonBox[
      RowBox[{"Add", " ", "Row"}],
      BaseStyle->"SmallButton",
      ButtonData:>Hold[DocumentationTools`TableAddRow]],
     "Adds new rows maintaining the same structure.\nTo add new row before \
first row, position the cursor at the beginning of the entire cell contents, \
or before all the contents of the first row.",
     TooltipDelay->0.35]},
   {
    TooltipBox[
     ButtonBox[
      RowBox[{"Add", " ", "Column"}],
      BaseStyle->"SmallButton",
      ButtonData:>Hold[DocumentationTools`TableAddColumn]],
     "Adds new column maintaining the same structure of nearest column.",
     TooltipDelay->0.35]},
   {
    TooltipBox[
     ButtonBox[
      RowBox[{"Span", " ", "First", " ", "Column"}],
      BaseStyle->"SmallButton",
      ButtonData:>Hold[DocumentationTools`TableSpanToggle]],
     "Select row to convert to spanning first column, or select spanning \
element and row to convert back to single row.",
     TooltipDelay->0.35]},
   {
    TooltipBox[
     ButtonBox[
      RowBox[{"Switch", " ", "Format"}],
      BaseStyle->"SmallButton",
      ButtonData:>Hold[DocumentationTools`TableInlineCellsToggle]],
     "Toggles selection within table from plain input style to inline text \
format and back.\nSelect one element or a column, row, or parts of either.",
     TooltipDelay->0.35]},
   {
    TooltipBox[
     ButtonBox[
      RowBox[{"Sort", " ", "Table"}],
      BaseStyle->"SmallButton",
      ButtonData:>Hold[DocumentationTools`TableSort]],
     "Sorts on the first column of a table.",
     TooltipDelay->0.35]},
   {
    TooltipBox[
     ButtonBox[
      RowBox[{"Merge", " ", "Tables"}],
      BaseStyle->"SmallButton",
      ButtonData:>Hold[DocumentationTools`TableMerge]],
     "Combines two table cells into one.",
     TooltipDelay->0.35]}
  }]], "PaletteGridCell",
 CellGroupingRules->{"GroupTogetherNestedGrouping", 101},
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, {True}, False}, "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {{
      Scaled[0.999]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{"Columns" -> {
     Offset[0.27999999999999997`], {
      Offset[-0.06999999999999999]}, 
     Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
     Offset[0.2], 
     Offset[0.4], 
     Offset[0.6], 
     Offset[0.2], 
     Offset[0.2], 
     Offset[0.2], 
     Offset[0.2], 
     Offset[0.2], 
     Offset[0.2], {
      Offset[0.2]}, 
     Offset[0.2]}, "RowsIndexed" -> {}}}]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {
    TooltipBox[
     ButtonBox[
      RowBox[{"Examples", "  ", "\[FilledDownTriangle]"}],
      BaseStyle->"ButtonGroupHead"],
     "Templates and formatting tools for creating examples.",
     TooltipDelay->0.35]}
  },
  GridBoxItemSize->{"Columns" -> {{
       Scaled[0.999]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
    "RowsIndexed" -> {}}]], "ButtonGroupHead",
 CellGroupingRules->{"GroupTogetherNestedGrouping", 99}],

Cell[CellGroupData[{

Cell[" ", "Spacer",
 CellGroupingRules->{"GroupTogetherNestedGrouping", 100}],

Cell[BoxData[GridBox[{
   {
    TooltipBox[
     ButtonBox[
      RowBox[{"Insert", " ", "Delimiter"}],
      BaseStyle->"BigButton",
      ButtonData:>Hold[DocumentationTools`DocDelimiter]],
     "This divides example groups and resets the input history. Shortcut key \
is control+y on Windows.",
     TooltipDelay->0.35]},
   {
    TooltipBox[
     ButtonBox[
      RowBox[{"Insert", " ", "Text"}],
      BaseStyle->"BigButton",
      ButtonData:>Hold[
        DocumentationTools`StyleApply["ExampleText"]]],
     "\"Optional text for examples. Style menu shortcut number 5.\"",
     TooltipDelay->0.35]},
   {
    TooltipBox[
     ButtonBox[
      RowBox[{"Insert", " ", "Needs"}],
      BaseStyle->"SmallButton",
      ButtonData:>Hold[
        DocumentationTools`NeedsStatementInsert[
        DocumentationTools`Deemphasis -> False]]],
     "Inserts needs statement with context pulled from metadata.\nFor package \
function pages primarily.",
     TooltipDelay->0.35]},
   {GridBox[{
      {
       TooltipBox[
        ButtonBox["Section",
         BaseStyle->"SmallButton",
         ButtonData:>Hold[
           DocumentationTools`StyleApply["ExampleSection"]]],
        "Section heading for examples.",
        TooltipDelay->0.35], 
       TooltipBox[
        ButtonBox["Subsec",
         BaseStyle->"SmallButton",
         ButtonData:>Hold[
           DocumentationTools`StyleApply["ExampleSubsection"]]],
        "Subheading for examples.",
        TooltipDelay->0.35], 
       TooltipBox[
        ButtonBox["Subsub",
         BaseStyle->"SmallButton",
         ButtonData:>Hold[
           DocumentationTools`StyleApply["ExampleSubsubsection"]]],
        "Subsubheading for examples.",
        TooltipDelay->0.35]}
     },
     GridBoxItemSize->{"Columns" -> {
         Scaled[0.35], {
          Scaled[0.33]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
       "RowsIndexed" -> {}}]},
   {
    TooltipBox[
     ButtonBox[
      RowBox[{"Options", " ", "for", " ", "Function"}],
      BaseStyle->"SmallButton",
      ButtonData->"DocumentationTools`OptionsInspector",
      Method->"Queued"],
     "Compares current listed options in Options section of a function page \
to\nthose returned by Options[] for the function being documented.\nA dialog \
lets you select any missing options to add.",
     TooltipDelay->0.35]}
  }]], "PaletteGridCell",
 CellMargins->{{0, 0}, {0, 1}},
 CellGroupingRules->{"GroupTogetherNestedGrouping", 100},
 GridBoxOptions->{ColumnsEqual->True,
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, {True}, False}, "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {{
      Scaled[0.999]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{"Columns" -> {
     Offset[0.27999999999999997`], {
      Offset[-0.06999999999999999]}, 
     Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
     Offset[0.2], 
     Offset[0.4], 
     Offset[0.2], 
     Offset[0.2], 
     Offset[0.2], {
      Offset[0.4]}, 
     Offset[0.2]}, "RowsIndexed" -> {}}}]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {
    TooltipBox[
     ButtonBox[
      RowBox[{"Links", "  ", "\[FilledDownTriangle]"}],
      BaseStyle->"ButtonGroupHead"],
     "Choices for setting selection as hyperlink.",
     TooltipDelay->0.35]}
  },
  GridBoxItemSize->{"Columns" -> {{
       Scaled[0.999]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
    "RowsIndexed" -> {}}]], "ButtonGroupHead",
 CellGroupingRules->{"GroupTogetherNestedGrouping", 96}],

Cell[CellGroupData[{

Cell[" ", "Spacer",
 CellGroupingRules->{"GroupTogetherNestedGrouping", 97}],

Cell[" ", "Spacer",
 CellGroupingRules->{"GroupTogetherNestedGrouping", 97}],

Cell[BoxData[GridBox[{
   {GridBox[{
      {
       TooltipBox[
        ButtonBox[
         RowBox[{"Link", " ", "to", " ", "Guide"}],
         BaseStyle->"BigButton",
         ButtonData->
          "DocumentationTools`CustomLink[\"guide\",Interactive\[Rule]False,\
DocumentationTools`LinkBase\[Rule]DocumentationTools`$LinkBase]",
         Method->"Queued"],
        "Create guide page link of the selection.",
        TooltipDelay->0.35], 
       TooltipBox[
        ButtonBox[
         RowBox[{"B", "\[VeryThinSpace]"}],
         BaseStyle->"BigButton",
         ButtonData->
          "DocumentationTools`CustomLink[\"PacletDocSelect\",\"guide\"]",
         Method->"Queued"],
        "Browse for a file to be hyperlinked from your selection as a guide \
page link.",
        TooltipDelay->0.35]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxItemSize->{"Columns" -> {
         Scaled[0.84], {
          Scaled[0.14]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.06999999999999999]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}]},
   {GridBox[{
      {
       TooltipBox[
        ButtonBox[
         RowBox[{"Link", " ", "to", " ", "Tutorial"}],
         BaseStyle->"BigButton",
         ButtonData->
          "DocumentationTools`CustomLink[\"tutorial\",Interactive\[Rule]False,\
DocumentationTools`LinkBase\[Rule]DocumentationTools`$LinkBase]",
         Method->"Queued"],
        "Create tutorial link of the selection.",
        TooltipDelay->0.35], 
       TooltipBox[
        ButtonBox[
         RowBox[{"\[VeryThinSpace]", "B"}],
         BaseStyle->"BigButton",
         ButtonData->
          "DocumentationTools`CustomLink[\"PacletDocSelect\",\"tutorial\"]",
         Method->"Queued"],
        "Browse for a file to be hyperlinked from your selection as a \
tutorial link.",
        TooltipDelay->0.35]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxItemSize->{"Columns" -> {
         Scaled[0.84], {
          Scaled[0.14]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.06999999999999999]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}]},
   {GridBox[{
      {
       TooltipBox[
        ButtonBox[
         RowBox[{"Link", " ", "to", " ", "Symbol"}],
         BaseStyle->"BigButton",
         ButtonData->
          "DocumentationTools`CustomLink[\"ref\",Interactive\[Rule]False,\
DocumentationTools`LinkBase\[Rule]DocumentationTools`$LinkBase]",
         Method->"Queued"],
        "Create function page link of the selection.",
        TooltipDelay->0.35], 
       TooltipBox[
        ButtonBox[
         RowBox[{"B", "\[VeryThinSpace]"}],
         BaseStyle->"BigButton",
         ButtonData->
          "DocumentationTools`CustomLink[\"PacletDocSelect\",\"ref\"]",
         Method->"Queued"],
        "Browse for a file to be hyperlinked from your selection as a \
function page link.",
        TooltipDelay->0.35]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxItemSize->{"Columns" -> {
         Scaled[0.84], {
          Scaled[0.14]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.06999999999999999]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}]},
   {
    TooltipBox[
     ButtonBox[
      RowBox[{"Link", " ", "to", " ", "URL"}],
      BaseStyle->"BigButton",
      ButtonData->
       "DocumentationTools`CustomLink[DocumentationTools`Target->\"URL\"]",
      Method->"Queued"],
     "Insert URL to be hyperlinked from your selection.",
     TooltipDelay->0.35]},
   {
    TooltipBox[
     ButtonBox[
      RowBox[{"Edit", " ", "Link"}],
      BaseStyle->"MediumButton",
      ButtonData->"DocumentationTools`ButtonEdit",
      Method->"Queued"],
     "\"Use this to edit the contents of a link if it can't be edited inline.\
\nPlace the cursor after the link before applying.\"",
     TooltipDelay->0.35]}
  }]], "PaletteGridCell",
 CellGroupingRules->{"GroupTogetherNestedGrouping", 99},
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, {True}, False}, "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {{
      Scaled[0.999]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{"Columns" -> {
     Offset[0.27999999999999997`], {
      Offset[0.5599999999999999]}, 
     Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
     Offset[0.2], 
     Offset[0.2], 
     Offset[0.2], {
      Offset[0.4]}, 
     Offset[0.2]}, "RowsIndexed" -> {}}}],

Cell[" ", "Spacer",
 CellGroupingRules->{"GroupTogetherNestedGrouping", 97}],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {
    TooltipBox[
     ButtonBox[
      RowBox[{
      "More", " ", "Link", " ", "Tools", " ", "\[FilledDownTriangle]"}],
      BaseStyle->"ButtonSubGroupHead"],
     "Choices for setting selection as specific type of hyperlink.",
     TooltipDelay->0.35]}
  },
  GridBoxItemSize->{"Columns" -> {{
       Scaled[0.999]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
    "RowsIndexed" -> {}}]], "ButtonSubGroupHead",
 CellGroupingRules->{"GroupTogetherNestedGrouping", 98}],

Cell[" ", "Spacer",
 CellGroupingRules->{"GroupTogetherNestedGrouping", 98}],

Cell[" ", "Spacer",
 CellGroupingRules->{"GroupTogetherNestedGrouping", 98}],

Cell[BoxData[GridBox[{
   {GridBox[{
      {
       TooltipBox[
        ButtonBox[
         RowBox[{"Make", " ", "Sel", "\[ThinSpace]"}],
         BaseStyle->"MediumButton",
         ButtonData:>Hold[
           DocumentationTools`InsertLink["PreserveSelectionContent" -> True]]],
        "Creates a link to the selected cell and saves the data in a form \
that can be used by the button to the right of this one. First select a cell \
in a saved notebook and then use the button to the right of this one to make \
selected text in a notebook into a link using the data obtained.",
        TooltipDelay->0.35], 
       TooltipBox[
        ButtonBox[
         RowBox[{"Make", " ", "Link", "\[ThinSpace]"}],
         BaseStyle->"MediumButton",
         ButtonData->"DocumentationTools`LinkSelection"],
        "Inserts a link over selected text. Use the button to the left of \
this one first.",
        TooltipDelay->0.35]}
     },
     GridBoxItemSize->{"Columns" -> {
         Scaled[0.49], {
          Scaled[0.49]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.06999999999999999]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}]},
   {
    TooltipBox[
     ButtonBox[
      RowBox[{"Link", " ", "to", " ", "Document"}],
      BaseStyle->"BigButton",
      ButtonData->"DocumentationTools`CustomLink[\"PacletDocSelect\"]",
      Method->"Queued"],
     "Browse your package layout for a notebook or PDF file to be linked from \
your selection.\nRelies on $ApplicationName, and target documents can reside \
in any directory under Documentation/$Language.",
     TooltipDelay->0.35]},
   {GridBox[{
      {
       TooltipBox[
        ButtonBox[
         RowBox[{"Custom", " ", "URI"}],
         BaseStyle->"BigButton",
         ButtonData->
          "DocumentationTools`CustomLink[DocumentationTools`PacletInteractive\
\[Rule]True]",
         Method->"Queued"],
        "Creates a link based on the paclet URI you provide interactively.",
        TooltipDelay->0.35], 
       TooltipBox[
        ButtonBox[
         RowBox[{"A", "\[VeryThinSpace]"}],
         BaseStyle->"NotchButton",
         ButtonData->
          "DocumentationTools`CustomLink[DocumentationTools`PacletInteractive \
-> Automatic]"],
        "Apply preset paclet URI automatically.",
        TooltipDelay->0.35], 
       TooltipBox[
        ButtonBox[
         RowBox[{"S", "\[VeryThinSpace]"}],
         BaseStyle->"NotchButton",
         ButtonData->"DocumentationTools`Set$PacletURI",
         Method->"Queued"],
        "Preset a paclet URI by entering it directly. If the paclet URI is \
not the same as the directory location, you can set the directory location \
separately using $TargetDocumentDir.",
        TooltipDelay->0.35], 
       TooltipBox[
        ButtonBox[
         RowBox[{"B", "\[VeryThinSpace]"}],
         BaseStyle->"NotchButton",
         ButtonData->"DocumentationTools`Set$PacletURI[\"Browse\"]",
         Method->"Queued"],
        "Browse to preset paclet URI. If URI is not the same as the directory \
location, you can set the directory location separately using \
$TargetDocumentDir.",
        TooltipDelay->0.35]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxItemSize->{"Columns" -> {
         Scaled[0.77], {
          Scaled[0.07]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.13999999999999999`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}]}
  }]], "PaletteGridCell",
 CellGroupingRules->{"GroupTogetherNestedGrouping", 98},
 GridBoxOptions->{ColumnsEqual->True,
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, {True}, False}, "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {{
      Scaled[0.999]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{"Columns" -> {
     Offset[0.27999999999999997`], {
      Offset[-0.06999999999999999]}, 
     Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {{
      Offset[0.2]}}, "RowsIndexed" -> {}}}]
}, Closed]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {
    TooltipBox[
     ButtonBox[
      RowBox[{"Formatting", "  ", "\[FilledDownTriangle]"}],
      BaseStyle->"ButtonGroupHead"],
     "Choices for formatting and special characters.",
     TooltipDelay->0.35]}
  },
  GridBoxItemSize->{"Columns" -> {{
       Scaled[0.999]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
    "RowsIndexed" -> {}}]], "ButtonGroupHead",
 CellGroupingRules->{"GroupTogetherNestedGrouping", 95}],

Cell[CellGroupData[{

Cell[" ", "Spacer",
 CellGroupingRules->{"GroupTogetherNestedGrouping", 96}],

Cell[" ", "Spacer",
 CellGroupingRules->{"GroupTogetherNestedGrouping", 96}],

Cell[BoxData[GridBox[{
   {
    TooltipBox[
     ButtonBox[
      RowBox[{"Special", " ", "Formatting"}],
      BaseStyle->"BigButton",
      ButtonData:>Hold[
        DocumentationTools`DocumentSample["SpecialForms.nb"]]],
     "A palette of additional input forms.",
     TooltipDelay->0.35]},
   {
    TooltipBox[
     ButtonBox[
      RowBox[{"Default", " ", "Format"}],
      BaseStyle->"BigButton",
      ButtonData:>Hold[DocumentationTools`RestoreDefault]],
     "Use this to return to the default format of the current cell while \
typing, or to remove formatting on the selection.",
     TooltipDelay->0.35]},
   {
    TooltipBox[
     ButtonBox[
      RowBox[{"Literal", " ", "Input"}],
      BaseStyle->"MediumButton",
      ButtonData:>Hold[
        DocumentationTools`FunctionTemplate["Plain"]]],
     "Use this for literal Mathematica input format in text. Same as doing \
CTRL+9 (for inline cell).",
     TooltipDelay->0.35]},
   {
    TooltipBox[
     ButtonBox[
      RowBox[{"Code", " ", "Cell"}],
      BaseStyle->"MediumButton",
      ButtonData:>Hold[
        DocumentationTools`StyleApply["Code"]]],
     "Use this for code examples in stand\[Hyphen]alone cells.",
     TooltipDelay->0.35]},
   {
    TooltipBox[
     ButtonBox[
      RowBox[{"Code", " ", "Inline"}],
      BaseStyle->"MediumButton",
      ButtonData:>Hold[
        DocumentationTools`StyleApply["InlineCode"]]],
     "Use this for code or other computer voice elements inline in text.",
     TooltipDelay->0.35]},
   {
    TooltipBox[
     ButtonBox[
      RowBox[{"Italic", " ", "Input"}],
      BaseStyle->"SmallButton",
      ButtonData:>Hold[
        DocumentationTools`StyleApply["TI"]]],
     "Use this to make italics in function templates only (e.g. for function \
arguments)",
     TooltipDelay->0.35]},
   {
    TooltipBox[
     ButtonBox[
      RowBox[{"Plain", " ", "Text"}],
      BaseStyle->"SmallButton",
      ButtonData:>Hold[
        DocumentationTools`StyleApply["TR"]]],
     "Use this to make plain text in function templates only (e.g. for \
function arguments).",
     TooltipDelay->0.35]},
   {
    TooltipBox[
     ButtonBox[
      RowBox[{"Traditional", " ", "Math"}],
      BaseStyle->"MediumButton",
      ButtonData:>Hold[DocumentationTools`TraditionalFormCell]],
     "Use this to begin or apply Mathematica TraditionalForm.",
     TooltipDelay->0.35]},
   {
    TooltipBox[
     ButtonBox[
      RowBox[{"Converted", " ", "TeX"}],
      BaseStyle->"MediumButton",
      ButtonData:>Hold[DocumentationTools`ConvertTeX]],
     "Use this to make math from TeX input, with $ $ delimiters.\nRefer to \
bottom of format menu for shortcut.\nUse shortcut after typing for \
autoselection.",
     TooltipDelay->0.35]},
   {
    TooltipBox[
     ButtonBox[
      RowBox[{
       CheckboxBox[Dynamic[
         DocumentationTools`UndeploymentSetting[
          InputNotebook[]]], {False, True, Blank[]}], "\[ThickSpace]\[ThickSpace]",
        "Undeploy"}],
      BaseStyle->"MediumButton",
      ButtonFunction:>DocumentationTools`UndeploymentSetter[
        InputNotebook[]]],
     "Toggle setting of input notebook to be left untouched by documentation \
build processes.",
     TooltipDelay->0.35]},
   {
    TooltipBox[
     ButtonBox["Tentative",
      Background->RGBColor[0.6, 0.9, 0.95],
      BaseStyle->"TinyButton",
      ButtonData->"DocumentationTools`StyleAppend[\"TentativeExample\"]"],
     "Mark cells waiting for confirmation to add to the current documentation \
build.\nToggles setting on/off.",
     TooltipDelay->0.35]},
   {GridBox[{
      {
       TooltipBox[
        ButtonBox["Annotate",
         Background->GrayLevel[0.8],
         BaseStyle->"TinyButton",
         ButtonData:>Hold[
           DocumentationTools`AnnotationInsert[]]],
        "Dialog for annotating a cell or editing a cell's annotation.",
        TooltipDelay->0.35], 
       TooltipBox[
        ButtonBox[
         StyleBox["\[FilledDownTriangle]",
          FontSize->9],
         BaseStyle->"NotchButton",
         ButtonData:>Hold[
           DocumentationTools`AnnotationSearch["Down"]]],
        "Searches down in the input notebook for the next annotation cell.",
        TooltipDelay->0.35], 
       TooltipBox[
        ButtonBox[
         StyleBox["\[FilledUpTriangle]",
          FontSize->9],
         BaseStyle->"NotchButton",
         ButtonData:>Hold[
           DocumentationTools`AnnotationSearch["Up"]]],
        "Searches up in the input notebook for the next annotation cell.",
        TooltipDelay->0.35], 
       TooltipBox[
        ButtonBox[
         RowBox[{"D", "\[VeryThinSpace]"}],
         Background->GrayLevel[0.8],
         BaseStyle->"NotchButton",
         ButtonData:>Hold[
           DocumentationTools`AnnotationRemove[]]],
        "Remove a cell's annotation.",
        TooltipDelay->0.35]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxItemSize->{"Columns" -> {
         Scaled[0.75], {
          Scaled[0.07]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.06999999999999999]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}]}
  }]], "PaletteGridCell",
 CellGroupingRules->{"GroupTogetherNestedGrouping", 96},
 GridBoxOptions->{ColumnsEqual->True,
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, {True}, False}, "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {{
      Scaled[0.999]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{"Columns" -> {
     Offset[0.27999999999999997`], {
      Offset[-0.06999999999999999]}, 
     Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
     Offset[0.2], 
     Offset[0.2], 
     Offset[0.4], 
     Offset[0.2], 
     Offset[0.4], 
     Offset[0.2], 
     Offset[0.4], 
     Offset[0.2], 
     Offset[0.2], 
     Offset[0.4], 
     Offset[0.4], {
      Offset[0.2]}, 
     Offset[0.2]}, "RowsIndexed" -> {}}}]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {
    TooltipBox[
     ButtonBox[
      RowBox[{"Utilities", "  ", "\[FilledDownTriangle]"}],
      BaseStyle->"ButtonGroupHead"],
     "Choices for setting selection as hyperlink.",
     TooltipDelay->0.35]}
  },
  GridBoxItemSize->{"Columns" -> {{
       Scaled[0.999]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
    "RowsIndexed" -> {}}]], "ButtonGroupHead",
 CellGroupingRules->{"GroupTogetherNestedGrouping", 94}],

Cell[CellGroupData[{

Cell[" ", "Spacer",
 CellGroupingRules->{"GroupTogetherNestedGrouping", 95}],

Cell[" ", "Spacer",
 CellGroupingRules->{"GroupTogetherNestedGrouping", 95}]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    TooltipBox[
     ButtonBox[
      RowBox[{"Generate", " ", "Function", " ", "Pages"}],
      BaseStyle->"BigButton2",
      ButtonData->"DocumentationTools`CreateReferencePages",
      Method->"Queued"],
     "Generate function pages in the selected directory for all symbols with \
usage messages in the application.\nAny existing notebooks are placed in the \
OriginalReferencePages directory within the selected directory.",
     TooltipDelay->0.35]},
   {
    TooltipBox[
     ButtonBox[
      RowBox[{"Fix", " ", "Links", " ", "to", " ", "Symbols"}],
      BaseStyle->"BigButton",
      ButtonData->"DocumentationTools`ApplicationSymbolsLinkFix",
      Method->"Queued"],
     "Add button data to application symbol buttons as needed in all \
notebooks in a directory.\nOriginal  notebooks are placed in the \
OriginalNotebooks directory within the selected directory.\nUse either \
$IncludedApplicationSymbols or $ExcludedApplicationSymbols if not all package \
sysmbols are to be handled automatically.",
     TooltipDelay->0.35]},
   {
    TooltipBox[
     ButtonBox[
      RowBox[{"Replace", " ", "Paclet", " ", "Base"}],
      BaseStyle->"BigButton",
      ButtonData->"DocumentationTools`ReplacePacletBase",
      Method->"Queued"],
     "Change the package name, context and uri in metadata as well as the \
link base used in button data in all notebooks in a directory.\nOriginal \
notebooks are placed in the OriginalNotebooks directory within the selected \
directory.",
     TooltipDelay->0.35]}
  }]], "PaletteGridCell",
 CellGroupingRules->{"GroupTogetherNestedGrouping", 94},
 GridBoxOptions->{ColumnsEqual->True,
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, {True}, False}, "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {{
      Scaled[0.999]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{"Columns" -> {
     Offset[0.27999999999999997`], {
      Offset[-0.06999999999999999]}, 
     Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
     Offset[0.2], 
     Offset[0.8], {
      Offset[0.2]}, 
     Offset[0.2]}, "RowsIndexed" -> {}}}]
}, Closed]],

Cell["\<\
 











\
\>", "Spacer"],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     TooltipBox[
      ButtonBox[
       StyleBox[
        RowBox[{"Paclet", " ", "Monitor"}], "GrayText"],
       Appearance->{Automatic, None},
       BaseStyle->"SmallButton",
       ButtonData->"DocumentationTools`CurrentPacletMonitorOpen",
       Method->"Queued"],
      "Paclet Monitor is a small indicator tracking the current settings for \
$ApplicationName and $LinkBase.",
      TooltipDelay->0.35], 
     StyleBox["|", "GrayText",
      FontSize->14], 
     TooltipBox[
      ButtonBox[
       StyleBox["Prompt", "GrayText"],
       Appearance->{Automatic, None},
       BaseStyle->"SmallButton",
       ButtonData->"DocumentationTools`PacletVariablesPromptRestore",
       Method->"Queued"],
      "Activate prompt at start up of DocumentationTools for displaying the \
current settings for $ApplicationName and $LinkBase.",
      TooltipDelay->0.35]}]},
   {
    TooltipBox[Cell["Creation Date", "GrayText"],
     "Date of palette creation \[LongRightArrow] 2010:5:24:11:2:52",
     TooltipDelay->0.35]},
   {Cell["\<\
 

\
\>", "Spacer"]}
  }]], "PaletteGridCell",
 CellMargins->{{0, 0}, {0, 8}},
 GridBoxOptions->{ColumnsEqual->True,
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, {True}, False}, "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {{
      Scaled[0.999]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{"Columns" -> {
     Offset[0.27999999999999997`], {
      Offset[0.]}, 
     Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
     Offset[0.2], {
      Offset[2.]}, 
     Offset[0.2]}, "RowsIndexed" -> {}}}],

Cell[BoxData[GridBox[{
   {
    TooltipBox[
     ButtonBox[
      RowBox[{"F", "      "}],
      BaseStyle->"PaletteTab",
      ButtonData:>"FunctionsExternal"],
     "Function page features.",
     TooltipDelay->0.35], 
    TooltipBox[
     ButtonBox[
      RowBox[{"G", "       "}],
      BaseStyle->"PaletteTabSelected",
      ButtonData:>"GuidesExternal"],
     "Guide page features.",
     TooltipDelay->0.35], 
    TooltipBox[
     ButtonBox[
      RowBox[{"T", "       "}],
      BaseStyle->"PaletteTab",
      ButtonData:>"TutorialsExternal"],
     "Tutorial page features.",
     TooltipDelay->0.35], 
    TooltipBox[
     ButtonBox["\[UpDownArrow]",
      BaseStyle->"ScrollToggle"],
     "Turn vertical scroll bar on or off.",
     TooltipDelay->0.35]}
  },
  GridBoxItemSize->{"Columns" -> {
      Scaled[0.3], 
      Scaled[0.285], 
      Scaled[0.285], 
      Scaled[0.17], {
       Scaled[0.11]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
    "RowsIndexed" -> {}},
  GridBoxSpacings->{"Columns" -> {
      Offset[0.27999999999999997`], {
       Offset[0.]}, 
      Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
      Offset[0.2], {
       Offset[0.]}, 
      Offset[0.2]}, "RowsIndexed" -> {}}]], "PaletteTabCell",
 CellTags->"GuidesExternal"],

Cell[BoxData[GridBox[{
   {
    TooltipBox[
     ButtonBox[
      RowBox[{"New", " ", "Guide", " ", "Page"}],
      BaseStyle->"BoldButton",
      ButtonData:>Hold[
        DocumentationTools`CreateNewPageDialog["Guide"]],
      Method->"Queued"],
     "Start guide page.",
     TooltipDelay->0.35]},
   {
    TooltipBox[
     ButtonBox[
      RowBox[{"Sample", " ", "Guide", " ", "Page"}],
      BaseStyle->"MediumButtonDark",
      ButtonData:>Hold[
        NotebookOpen[
         ToFileName[{DocumentationTools`$DocuToolsDir, "Examples"}, 
          "GuideExample.nb"]]],
      ButtonMargins->2],
     "Sample guide page.",
     TooltipDelay->0.35]},
   {GridBox[{
      {
       TooltipBox[
        ButtonBox[
         RowBox[{
          RowBox[{
           RowBox[{"Set", " ", "Paclet", " ", "Name"}], " ", "&"}], " ", 
          "Path"}],
         BaseStyle->"TinyButtonDark",
         ButtonData->
          "DocumentationTools`DocumentationDirSelect[\"Interactive\"\[Rule]\
True]",
         Method->"Queued"],
        "Use this to select the paclet (application pack) directory \
containing your working documentation source file layout.\nYour selection is \
stored in the front end init.m as $DocumentationDirectory, from which \
$ApplicationName is derived for configuring the link base in hyperlinks to \
other documents in the same paclet layout.\nThe paclet's parent directory \
also becomes part of $DocumentationPath to support links to documents in \
other paclet projects on the path.",
        TooltipDelay->0.35], 
       TooltipBox[
        ButtonBox[
         StyleBox["M",
          FontWeight->"Bold",
          FontColor->GrayLevel[0.7]],
         Background->GrayLevel[0.4],
         BaseStyle->"TinyButtonDark",
         ButtonData->"DocumentationTools`SetPacletVariables",
         Method->"Queued"],
        "Use this to configure $ApplicationName and $LinkBase manually, \
primarily when the link base is not the same as your application name.",
        TooltipDelay->0.35]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
        "RowsIndexed" -> {}},
     GridBoxItemSize->{"Columns" -> {
         Scaled[0.9], {
          Scaled[0.09]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.06999999999999999]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}]},
   {
    TooltipBox[
     ButtonBox[
      RowBox[{"1", " ", "Line", " ", "Function", " ", "Listing"}],
      BaseStyle->"BigButton",
      ButtonData->"DocumentationTools`OneLineFunction"],
     "Select between cells to insert a 1-line function template.\n Toggles \
between formatted and unformatted states when used on or in text of a \
preexisting 1-line function cell.",
     TooltipDelay->0.35]},
   {
    TooltipBox[
     ButtonBox["Delimiter",
      BaseStyle->"BigButton",
      ButtonData:>Hold[DocumentationTools`DocDelimiter]],
     "Item separator for function listing area.",
     TooltipDelay->0.35]},
   {
    TooltipBox[
     ButtonBox[
      RowBox[{"Functions", " ", "Inline", " ", "Listing"}],
      BaseStyle->"BigButton",
      ButtonData:>Hold[
        DocumentationTools`InlineListingToggle["TargetStyle" -> Automatic]]],
     "Use <space>.<space> to delimit elements. Function names will be \
autolinked.\nTo make a link to a function page for a symbol in another \
application, list it along with the other symbols to be linked as \
otherapplicationlinkbase/ref/symbol.\nToggles format on/off for easy editing. \
Use Plain Text button for comments that should not be bold or buttonized.",
     TooltipDelay->0.35]},
   {
    TooltipBox[
     ButtonBox[
      RowBox[{"Insert", " ", "Artwork", " ", "Banner", " ", "Cell"}],
      BaseStyle->"BigButton",
      ButtonData:>Hold[DocumentationTools`BannerInsert]],
     "Inserts a template cell for placement of product branding artwork.",
     TooltipDelay->0.35]},
   {
    TooltipBox[
     ButtonBox["Subsection",
      BaseStyle->"MediumButton",
      ButtonData:>Hold[
        DocumentationTools`StyleApply["GuideFunctionsSubsection"]]],
     "Subsection heading for functions listing.",
     TooltipDelay->0.35]},
   {
    TooltipBox[
     ButtonBox["GuideText",
      BaseStyle->"MediumButton",
      ButtonData:>Hold[
        DocumentationTools`StyleApply["GuideText"]]],
     "Guide text cell.",
     TooltipDelay->0.35]}
  }]], "PaletteGridCell",
 GridBoxOptions->{ColumnsEqual->True,
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, {True}, False}, "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {{
      Scaled[0.999]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{"Columns" -> {
     Offset[0.27999999999999997`], {
      Offset[0.]}, 
     Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
     Offset[0.2], 
     Offset[0.12], 
     Offset[0.], 
     Offset[0.8], 
     Offset[0.2], 
     Offset[0.4], 
     Offset[0.2], 
     Offset[0.2], 
     Offset[0.4], 
     Offset[0.2], 
     Offset[0.2], {
      Offset[0.8]}, 
     Offset[0.2]}, "RowsIndexed" -> {}}}],

Cell["\<\
 







\
\>", "Spacer"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {
    TooltipBox[
     ButtonBox[
      RowBox[{"Links", "  ", "\[FilledDownTriangle]"}],
      BaseStyle->"ButtonGroupHead"],
     "Choices for setting selection as hyperlink.",
     TooltipDelay->0.35]}
  },
  GridBoxItemSize->{"Columns" -> {{
       Scaled[0.999]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
    "RowsIndexed" -> {}}]], "ButtonGroupHead",
 CellGroupingRules->{"GroupTogetherNestedGrouping", 96}],

Cell[CellGroupData[{

Cell[" ", "Spacer",
 CellGroupingRules->{"GroupTogetherNestedGrouping", 97}],

Cell[" ", "Spacer",
 CellGroupingRules->{"GroupTogetherNestedGrouping", 97}],

Cell[BoxData[GridBox[{
   {GridBox[{
      {
       TooltipBox[
        ButtonBox[
         RowBox[{"Link", " ", "to", " ", "Guide"}],
         BaseStyle->"BigButton",
         ButtonData->
          "DocumentationTools`CustomLink[\"guide\",Interactive\[Rule]False,\
DocumentationTools`LinkBase\[Rule]DocumentationTools`$LinkBase]",
         Method->"Queued"],
        "Create guide page link of the selection.",
        TooltipDelay->0.35], 
       TooltipBox[
        ButtonBox[
         RowBox[{"B", "\[VeryThinSpace]"}],
         BaseStyle->"BigButton",
         ButtonData->
          "DocumentationTools`CustomLink[\"PacletDocSelect\",\"guide\"]",
         Method->"Queued"],
        "Browse for a file to be hyperlinked from your selection as a guide \
page link.",
        TooltipDelay->0.35]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxItemSize->{"Columns" -> {
         Scaled[0.84], {
          Scaled[0.14]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.06999999999999999]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}]},
   {GridBox[{
      {
       TooltipBox[
        ButtonBox[
         RowBox[{"Link", " ", "to", " ", "Tutorial"}],
         BaseStyle->"BigButton",
         ButtonData->
          "DocumentationTools`CustomLink[\"tutorial\",Interactive\[Rule]False,\
DocumentationTools`LinkBase\[Rule]DocumentationTools`$LinkBase]",
         Method->"Queued"],
        "Create tutorial link of the selection.",
        TooltipDelay->0.35], 
       TooltipBox[
        ButtonBox[
         RowBox[{"\[VeryThinSpace]", "B"}],
         BaseStyle->"BigButton",
         ButtonData->
          "DocumentationTools`CustomLink[\"PacletDocSelect\",\"tutorial\"]",
         Method->"Queued"],
        "Browse for a file to be hyperlinked from your selection as a \
tutorial link.",
        TooltipDelay->0.35]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxItemSize->{"Columns" -> {
         Scaled[0.84], {
          Scaled[0.14]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.06999999999999999]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}]},
   {GridBox[{
      {
       TooltipBox[
        ButtonBox[
         RowBox[{"Link", " ", "to", " ", "Symbol"}],
         BaseStyle->"BigButton",
         ButtonData->
          "DocumentationTools`CustomLink[\"ref\",Interactive\[Rule]False,\
DocumentationTools`LinkBase\[Rule]DocumentationTools`$LinkBase]",
         Method->"Queued"],
        "Create function page link of the selection.",
        TooltipDelay->0.35], 
       TooltipBox[
        ButtonBox[
         RowBox[{"B", "\[VeryThinSpace]"}],
         BaseStyle->"BigButton",
         ButtonData->
          "DocumentationTools`CustomLink[\"PacletDocSelect\",\"ref\"]",
         Method->"Queued"],
        "Browse for a file to be hyperlinked from your selection as a \
function page link.",
        TooltipDelay->0.35]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxItemSize->{"Columns" -> {
         Scaled[0.84], {
          Scaled[0.14]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.06999999999999999]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}]},
   {
    TooltipBox[
     ButtonBox[
      RowBox[{"Link", " ", "to", " ", "URL"}],
      BaseStyle->"BigButton",
      ButtonData->
       "DocumentationTools`CustomLink[DocumentationTools`Target->\"URL\"]",
      Method->"Queued"],
     "Insert URL to be hyperlinked from your selection.",
     TooltipDelay->0.35]},
   {
    TooltipBox[
     ButtonBox[
      RowBox[{"Edit", " ", "Link"}],
      BaseStyle->"MediumButton",
      ButtonData->"DocumentationTools`ButtonEdit",
      Method->"Queued"],
     "\"Use this to edit the contents of a link if it can't be edited inline.\
\nPlace the cursor after the link before applying.\"",
     TooltipDelay->0.35]}
  }]], "PaletteGridCell",
 CellGroupingRules->{"GroupTogetherNestedGrouping", 99},
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, {True}, False}, "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {{
      Scaled[0.999]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{"Columns" -> {
     Offset[0.27999999999999997`], {
      Offset[0.5599999999999999]}, 
     Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
     Offset[0.2], 
     Offset[0.2], 
     Offset[0.2], {
      Offset[0.4]}, 
     Offset[0.2]}, "RowsIndexed" -> {}}}],

Cell[" ", "Spacer",
 CellGroupingRules->{"GroupTogetherNestedGrouping", 97}],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {
    TooltipBox[
     ButtonBox[
      RowBox[{
      "More", " ", "Link", " ", "Tools", " ", "\[FilledDownTriangle]"}],
      BaseStyle->"ButtonSubGroupHead"],
     "Choices for setting selection as specific type of hyperlink.",
     TooltipDelay->0.35]}
  },
  GridBoxItemSize->{"Columns" -> {{
       Scaled[0.999]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
    "RowsIndexed" -> {}}]], "ButtonSubGroupHead",
 CellGroupingRules->{"GroupTogetherNestedGrouping", 98}],

Cell[" ", "Spacer",
 CellGroupingRules->{"GroupTogetherNestedGrouping", 98}],

Cell[" ", "Spacer",
 CellGroupingRules->{"GroupTogetherNestedGrouping", 98}],

Cell[BoxData[GridBox[{
   {GridBox[{
      {
       TooltipBox[
        ButtonBox[
         RowBox[{"Make", " ", "Sel", "\[ThinSpace]"}],
         BaseStyle->"MediumButton",
         ButtonData:>Hold[
           DocumentationTools`InsertLink["PreserveSelectionContent" -> True]]],
        "Creates a link to the selected cell and saves the data in a form \
that can be used by the button to the right of this one. First select a cell \
in a saved notebook and then use the button to the right of this one to make \
selected text in a notebook into a link using the data obtained.",
        TooltipDelay->0.35], 
       TooltipBox[
        ButtonBox[
         RowBox[{"Make", " ", "Link", "\[ThinSpace]"}],
         BaseStyle->"MediumButton",
         ButtonData->"DocumentationTools`LinkSelection"],
        "Inserts a link over selected text. Use the button to the left of \
this one first.",
        TooltipDelay->0.35]}
     },
     GridBoxItemSize->{"Columns" -> {
         Scaled[0.49], {
          Scaled[0.49]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.06999999999999999]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}]},
   {
    TooltipBox[
     ButtonBox[
      RowBox[{"Link", " ", "to", " ", "Document"}],
      BaseStyle->"BigButton",
      ButtonData->"DocumentationTools`CustomLink[\"PacletDocSelect\"]",
      Method->"Queued"],
     "Browse your package layout for a notebook or PDF file to be linked from \
your selection.\nRelies on $ApplicationName, and target documents can reside \
in any directory under Documentation/$Language.",
     TooltipDelay->0.35]},
   {GridBox[{
      {
       TooltipBox[
        ButtonBox[
         RowBox[{"Custom", " ", "URI"}],
         BaseStyle->"BigButton",
         ButtonData->
          "DocumentationTools`CustomLink[DocumentationTools`PacletInteractive\
\[Rule]True]",
         Method->"Queued"],
        "Creates a link based on the paclet URI you provide interactively.",
        TooltipDelay->0.35], 
       TooltipBox[
        ButtonBox[
         RowBox[{"A", "\[VeryThinSpace]"}],
         BaseStyle->"NotchButton",
         ButtonData->
          "DocumentationTools`CustomLink[DocumentationTools`PacletInteractive \
-> Automatic]"],
        "Apply preset paclet URI automatically.",
        TooltipDelay->0.35], 
       TooltipBox[
        ButtonBox[
         RowBox[{"S", "\[VeryThinSpace]"}],
         BaseStyle->"NotchButton",
         ButtonData->"DocumentationTools`Set$PacletURI",
         Method->"Queued"],
        "Preset a paclet URI by entering it directly. If the paclet URI is \
not the same as the directory location, you can set the directory location \
separately using $TargetDocumentDir.",
        TooltipDelay->0.35], 
       TooltipBox[
        ButtonBox[
         RowBox[{"B", "\[VeryThinSpace]"}],
         BaseStyle->"NotchButton",
         ButtonData->"DocumentationTools`Set$PacletURI[\"Browse\"]",
         Method->"Queued"],
        "Browse to preset paclet URI. If URI is not the same as the directory \
location, you can set the directory location separately using \
$TargetDocumentDir.",
        TooltipDelay->0.35]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxItemSize->{"Columns" -> {
         Scaled[0.77], {
          Scaled[0.07]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.13999999999999999`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}]}
  }]], "PaletteGridCell",
 CellGroupingRules->{"GroupTogetherNestedGrouping", 98},
 GridBoxOptions->{ColumnsEqual->True,
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, {True}, False}, "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {{
      Scaled[0.999]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{"Columns" -> {
     Offset[0.27999999999999997`], {
      Offset[-0.06999999999999999]}, 
     Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {{
      Offset[0.2]}}, "RowsIndexed" -> {}}}]
}, Closed]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {
    TooltipBox[
     ButtonBox[
      RowBox[{"Formatting", "  ", "\[FilledDownTriangle]"}],
      BaseStyle->"ButtonGroupHead"],
     "Choices for formatting and special characters.",
     TooltipDelay->0.35]}
  },
  GridBoxItemSize->{"Columns" -> {{
       Scaled[0.999]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
    "RowsIndexed" -> {}}]], "ButtonGroupHead",
 CellGroupingRules->{"GroupTogetherNestedGrouping", 95}],

Cell[CellGroupData[{

Cell[" ", "Spacer",
 CellGroupingRules->{"GroupTogetherNestedGrouping", 96}],

Cell[" ", "Spacer",
 CellGroupingRules->{"GroupTogetherNestedGrouping", 96}],

Cell[BoxData[GridBox[{
   {
    TooltipBox[
     ButtonBox[
      RowBox[{"Special", " ", "Formatting"}],
      BaseStyle->"BigButton",
      ButtonData:>Hold[
        DocumentationTools`DocumentSample["SpecialForms.nb"]]],
     "A palette of additional input forms.",
     TooltipDelay->0.35]},
   {
    TooltipBox[
     ButtonBox[
      RowBox[{"Default", " ", "Format"}],
      BaseStyle->"BigButton",
      ButtonData:>Hold[DocumentationTools`RestoreDefault]],
     "Use this to return to the default format of the current cell while \
typing, or to remove formatting on the selection.",
     TooltipDelay->0.35]},
   {
    TooltipBox[
     ButtonBox[
      RowBox[{"Literal", " ", "Input"}],
      BaseStyle->"MediumButton",
      ButtonData:>Hold[
        DocumentationTools`FunctionTemplate["Plain"]]],
     "Use this for literal Mathematica input format in text. Same as doing \
CTRL+9 (for inline cell).",
     TooltipDelay->0.35]},
   {
    TooltipBox[
     ButtonBox[
      RowBox[{"Code", " ", "Cell"}],
      BaseStyle->"MediumButton",
      ButtonData:>Hold[
        DocumentationTools`StyleApply["Code"]]],
     "Use this for code examples in stand\[Hyphen]alone cells.",
     TooltipDelay->0.35]},
   {
    TooltipBox[
     ButtonBox[
      RowBox[{"Code", " ", "Inline"}],
      BaseStyle->"MediumButton",
      ButtonData:>Hold[
        DocumentationTools`StyleApply["InlineCode"]]],
     "Use this for code or other computer voice elements inline in text.",
     TooltipDelay->0.35]},
   {
    TooltipBox[
     ButtonBox[
      RowBox[{"Italic", " ", "Input"}],
      BaseStyle->"SmallButton",
      ButtonData:>Hold[
        DocumentationTools`StyleApply["TI"]]],
     "Use this to make italics in function templates only (e.g. for function \
arguments)",
     TooltipDelay->0.35]},
   {
    TooltipBox[
     ButtonBox[
      RowBox[{"Plain", " ", "Text"}],
      BaseStyle->"SmallButton",
      ButtonData:>Hold[
        DocumentationTools`StyleApply["TR"]]],
     "Use this to make plain text in function templates only (e.g. for \
function arguments).",
     TooltipDelay->0.35]},
   {
    TooltipBox[
     ButtonBox[
      RowBox[{"Traditional", " ", "Math"}],
      BaseStyle->"MediumButton",
      ButtonData:>Hold[DocumentationTools`TraditionalFormCell]],
     "Use this to begin or apply Mathematica TraditionalForm.",
     TooltipDelay->0.35]},
   {
    TooltipBox[
     ButtonBox[
      RowBox[{"Converted", " ", "TeX"}],
      BaseStyle->"MediumButton",
      ButtonData:>Hold[DocumentationTools`ConvertTeX]],
     "Use this to make math from TeX input, with $ $ delimiters.\nRefer to \
bottom of format menu for shortcut.\nUse shortcut after typing for \
autoselection.",
     TooltipDelay->0.35]},
   {
    TooltipBox[
     ButtonBox[
      RowBox[{
       CheckboxBox[Dynamic[
         DocumentationTools`UndeploymentSetting[
          InputNotebook[]]], {False, True, Blank[]}], "\[ThickSpace]\[ThickSpace]",
        "Undeploy"}],
      BaseStyle->"MediumButton",
      ButtonFunction:>DocumentationTools`UndeploymentSetter[
        InputNotebook[]]],
     "Toggle setting of input notebook to be left untouched by documentation \
build processes.",
     TooltipDelay->0.35]},
   {
    TooltipBox[
     ButtonBox["Tentative",
      Background->RGBColor[0.6, 0.9, 0.95],
      BaseStyle->"TinyButton",
      ButtonData->"DocumentationTools`StyleAppend[\"TentativeExample\"]"],
     "Mark cells waiting for confirmation to add to the current documentation \
build.\nToggles setting on/off.",
     TooltipDelay->0.35]},
   {GridBox[{
      {
       TooltipBox[
        ButtonBox["Annotate",
         Background->GrayLevel[0.8],
         BaseStyle->"TinyButton",
         ButtonData:>Hold[
           DocumentationTools`AnnotationInsert[]]],
        "Dialog for annotating a cell or editing a cell's annotation.",
        TooltipDelay->0.35], 
       TooltipBox[
        ButtonBox[
         StyleBox["\[FilledDownTriangle]",
          FontSize->9],
         BaseStyle->"NotchButton",
         ButtonData:>Hold[
           DocumentationTools`AnnotationSearch["Down"]]],
        "Searches down in the input notebook for the next annotation cell.",
        TooltipDelay->0.35], 
       TooltipBox[
        ButtonBox[
         StyleBox["\[FilledUpTriangle]",
          FontSize->9],
         BaseStyle->"NotchButton",
         ButtonData:>Hold[
           DocumentationTools`AnnotationSearch["Up"]]],
        "Searches up in the input notebook for the next annotation cell.",
        TooltipDelay->0.35], 
       TooltipBox[
        ButtonBox[
         RowBox[{"D", "\[VeryThinSpace]"}],
         Background->GrayLevel[0.8],
         BaseStyle->"NotchButton",
         ButtonData:>Hold[
           DocumentationTools`AnnotationRemove[]]],
        "Remove a cell's annotation.",
        TooltipDelay->0.35]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxItemSize->{"Columns" -> {
         Scaled[0.75], {
          Scaled[0.07]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.06999999999999999]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}]}
  }]], "PaletteGridCell",
 CellGroupingRules->{"GroupTogetherNestedGrouping", 96},
 GridBoxOptions->{ColumnsEqual->True,
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, {True}, False}, "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {{
      Scaled[0.999]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{"Columns" -> {
     Offset[0.27999999999999997`], {
      Offset[-0.06999999999999999]}, 
     Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
     Offset[0.2], 
     Offset[0.2], 
     Offset[0.4], 
     Offset[0.2], 
     Offset[0.4], 
     Offset[0.2], 
     Offset[0.4], 
     Offset[0.2], 
     Offset[0.2], 
     Offset[0.4], 
     Offset[0.4], {
      Offset[0.2]}, 
     Offset[0.2]}, "RowsIndexed" -> {}}}]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {
    TooltipBox[
     ButtonBox[
      RowBox[{"Utilities", "  ", "\[FilledDownTriangle]"}],
      BaseStyle->"ButtonGroupHead"],
     "Choices for setting selection as hyperlink.",
     TooltipDelay->0.35]}
  },
  GridBoxItemSize->{"Columns" -> {{
       Scaled[0.999]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
    "RowsIndexed" -> {}}]], "ButtonGroupHead",
 CellGroupingRules->{"GroupTogetherNestedGrouping", 94}],

Cell[CellGroupData[{

Cell[" ", "Spacer",
 CellGroupingRules->{"GroupTogetherNestedGrouping", 95}],

Cell[" ", "Spacer",
 CellGroupingRules->{"GroupTogetherNestedGrouping", 95}]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    TooltipBox[
     ButtonBox[
      RowBox[{"Fix", " ", "Links", " ", "to", " ", "Symbols"}],
      BaseStyle->"BigButton",
      ButtonData->"DocumentationTools`ApplicationSymbolsLinkFix",
      Method->"Queued"],
     "Add button data to application symbol buttons as needed in all \
notebooks in a directory.\nResulting  notebooks are placed in \
NotebooksWithModifiedButtons directory within the selected directory.\nUse \
either $IncludedApplicationSymbols or $ExcludedApplicationSymbols if not all \
package sysmbols are to be handled automatically.",
     TooltipDelay->0.35]},
   {
    TooltipBox[
     ButtonBox[
      RowBox[{"Replace", " ", "Paclet", " ", "Base"}],
      BaseStyle->"BigButton",
      ButtonData->"DocumentationTools`ReplacePacletBase",
      Method->"Queued"],
     "Change the context and package name in metadata as well as the \
application name used in button data in all notebooks in a directory.\n\
Resulting  notebooks are placed in NotebooksWithPacletBaseReplaced directory \
within the selected directory.",
     TooltipDelay->0.35]}
  }]], "PaletteGridCell",
 CellGroupingRules->{"GroupTogetherNestedGrouping", 94},
 GridBoxOptions->{ColumnsEqual->True,
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, {True}, False}, "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {{
      Scaled[0.999]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{"Columns" -> {
     Offset[0.27999999999999997`], {
      Offset[-0.06999999999999999]}, 
     Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {{
      Offset[0.2]}}, "RowsIndexed" -> {}}}]
}, Closed]],

Cell["\<\
 











\
\>", "Spacer"],

Cell[BoxData[GridBox[{
   {
    TooltipBox[
     ButtonBox[
      RowBox[{"F", "      "}],
      BaseStyle->"PaletteTab",
      ButtonData:>"FunctionsExternal"],
     "Function page features.",
     TooltipDelay->0.35], 
    TooltipBox[
     ButtonBox[
      RowBox[{"G", "       "}],
      BaseStyle->"PaletteTab",
      ButtonData:>"GuidesExternal"],
     "Guide page features.",
     TooltipDelay->0.35], 
    TooltipBox[
     ButtonBox[
      RowBox[{"T", "       "}],
      BaseStyle->"PaletteTabSelected",
      ButtonData:>"TutorialsExternal"],
     "Tutorial page features.",
     TooltipDelay->0.35], 
    TooltipBox[
     ButtonBox["\[UpDownArrow]",
      BaseStyle->"ScrollToggle"],
     "Turn vertical scroll bar on or off.",
     TooltipDelay->0.35]}
  },
  GridBoxItemSize->{"Columns" -> {
      Scaled[0.3], 
      Scaled[0.285], 
      Scaled[0.285], 
      Scaled[0.17], {
       Scaled[0.11]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
    "RowsIndexed" -> {}},
  GridBoxSpacings->{"Columns" -> {
      Offset[0.27999999999999997`], {
       Offset[0.]}, 
      Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
      Offset[0.2], {
       Offset[0.]}, 
      Offset[0.2]}, "RowsIndexed" -> {}}]], "PaletteTabCell",
 CellTags->"TutorialsExternal"],

Cell[BoxData[GridBox[{
   {
    TooltipBox[
     ButtonBox[
      RowBox[{"New", " ", "Tutorial"}],
      BaseStyle->"BoldButton",
      ButtonData:>Hold[
        DocumentationTools`CreateNewPageDialog["Tutorial"]],
      Method->"Queued"],
     "Start tutorial page.",
     TooltipDelay->0.35]},
   {
    TooltipBox[
     ButtonBox[
      RowBox[{"Sample", " ", "Tutorial", " ", "Page", "\[VeryThinSpace]"}],
      BaseStyle->"MediumButtonDark",
      ButtonData:>Hold[
        NotebookOpen[
         ToFileName[{DocumentationTools`$DocuToolsDir, "Examples"}, 
          "TutorialExample.nb"]]],
      ButtonMargins->2],
     "Sample tutorial page.",
     TooltipDelay->0.35]},
   {GridBox[{
      {
       TooltipBox[
        ButtonBox[
         RowBox[{
          RowBox[{
           RowBox[{"Set", " ", "Paclet", " ", "Name"}], " ", "&"}], " ", 
          "Path"}],
         BaseStyle->"TinyButtonDark",
         ButtonData->
          "DocumentationTools`DocumentationDirSelect[\"Interactive\"\[Rule]\
True]",
         Method->"Queued"],
        "Use this to select the paclet (application pack) directory \
containing your working documentation source file layout.\nYour selection is \
stored in the front end init.m as $DocumentationDirectory, from which \
$ApplicationName is derived for configuring the link base in hyperlinks to \
other documents in the same paclet layout.\nThe paclet's parent directory \
also becomes part of $DocumentationPath to support links to documents in \
other paclet projects on the path.",
        TooltipDelay->0.35], 
       TooltipBox[
        ButtonBox[
         StyleBox["M",
          FontWeight->"Bold",
          FontColor->GrayLevel[0.7]],
         Background->GrayLevel[0.4],
         BaseStyle->"TinyButtonDark",
         ButtonData->"DocumentationTools`SetPacletVariables",
         Method->"Queued"],
        "Use this to configure $ApplicationName and $LinkBase manually, \
primarily when the link base is not the same as your application name.",
        TooltipDelay->0.35]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
        "RowsIndexed" -> {}},
     GridBoxItemSize->{"Columns" -> {
         Scaled[0.9], {
          Scaled[0.09]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.06999999999999999]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}]},
   {GridBox[{
      {
       TooltipBox[
        ButtonBox[
         RowBox[{"Definition", " ", "Boxes"}],
         Active->False,
         BaseStyle->"ButtonSubGroupHead"],
        "Use the buttons in the row below to insert and work with definition \
boxes.",
        TooltipDelay->0.35]}
     },
     GridBoxItemSize->{"Columns" -> {{
          Scaled[0.999]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
       "RowsIndexed" -> {}}]},
   {GridBox[{
      {
       TooltipBox[
        ButtonBox[
         RowBox[{"2", " ", "Col"}],
         BaseStyle->"BigButton",
         ButtonFunction:>NotebookWrite[
           InputNotebook[], {
            Cell[
             BoxData[
              GridBox[{{"XXXX", 
                 Cell["XXXX", "TableText"]}, {"XXXX", 
                 Cell["XXXX", "TableText"]}, {"XXXX", 
                 Cell["XXXX", "TableText"]}}]], "DefinitionBox"], 
            Cell["XXXX.", "Caption"]}]],
        "Insert two column definition box. Use button at right to add row.",
        TooltipDelay->0.35], 
       TooltipBox[
        ButtonBox[
         RowBox[{"3", " ", "Col"}],
         BaseStyle->"BigButton",
         ButtonFunction:>NotebookWrite[
           InputNotebook[], {
            Cell[
             BoxData[
              GridBox[{{"XXXX", "XXXX", 
                 Cell["XXXX", "TableText"]}, {"XXXX", "XXXX", 
                 Cell["XXXX", "TableText"]}, {"XXXX", "XXXX", 
                 Cell["XXXX", "TableText"]}}]], "DefinitionBox3Col"], 
            Cell["XXXX.", "Caption"]}]],
        "Insert three column definition box. Use button at right to add row.",
        TooltipDelay->0.35], 
       TooltipBox[
        ButtonBox["A",
         BaseStyle->"NotchButton",
         ButtonData:>Hold[DocumentationTools`TableAddRow]],
        "Adds new row of the same structure as the rest of the table or \
definition box.",
        TooltipDelay->0.35], 
       TooltipBox[
        ButtonBox["M",
         BaseStyle->"NotchButton",
         ButtonData:>Hold[DocumentationTools`TableMerge]],
        "Combines two selected definition box cells into one cell.",
        TooltipDelay->0.35], 
       TooltipBox[
        ButtonBox["D",
         BaseStyle->"NotchButton",
         ButtonData:>Hold[DocumentationTools`TablePartDelete]],
        "Delete selection within definition box.",
        TooltipDelay->0.35], 
       TooltipBox[
        ButtonBox["T",
         BaseStyle->"NotchButton",
         ButtonData:>Hold[
           DocumentationTools`TableSpanToggle["StrictSelection" -> True]]],
        "Change selected row to spanning format, or restore spanning format \
to single row.",
        TooltipDelay->0.35]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxItemSize->{"Columns" -> {
         Scaled[0.34], 
         Scaled[0.34], {
          Scaled[0.07]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.06999999999999999]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}]},
   {GridBox[{
      {
       TooltipBox[
        ButtonBox[
         RowBox[{"Math", " ", "Caption"}],
         BaseStyle->"BigButton",
         ButtonData:>Hold[
           DocumentationTools`StyleApply["MathCaption"]]],
        "Begin math caption cell or change selection to math caption.",
        TooltipDelay->0.35], 
       TooltipBox[
        ButtonBox[
         StyleBox[
          RowBox[{"I", "\[ThinSpace]"}],
          FontSize->8.5],
         BaseStyle->{"NotchButton", FontSize -> 10},
         ButtonFunction:>(SelectionMove[
            InputNotebook[], After, Cell]; NotebookWrite[
            InputNotebook[], {
             Cell["XXXX", "MathCaption"], 
             Cell[
              BoxData[
               RowBox[{"2", "+", "2"}]], "Input"]}]; SelectionMove[
            InputNotebook[], Previous, Cell]; SelectionMove[
            InputNotebook[], All, CellContents])],
        "\"Insert Input cell with MathCaption cell.\"",
        TooltipDelay->0.35]}
     },
     GridBoxItemSize->{"Columns" -> {
         Scaled[0.9], {
          Scaled[0.08]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.06999999999999999]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}]},
   {
    TooltipBox[
     ButtonBox["Section",
      BaseStyle->"BigButton",
      ButtonData:>Hold[
        DocumentationTools`StyleApply["Section"]]],
     "Insert Section or apply Section style to selection.",
     TooltipDelay->0.35]},
   {
    TooltipBox[
     ButtonBox["Subsection",
      BaseStyle->"BigButton",
      ButtonData:>Hold[
        DocumentationTools`StyleApply["Subsection"]]],
     "Insert Subsection or apply Subsection style to selection.",
     TooltipDelay->0.35]},
   {
    TooltipBox[
     ButtonBox["Text",
      BaseStyle->"BigButton",
      ButtonData:>Hold[
        DocumentationTools`StyleApply["Text"]]],
     "Begin text cell or change selection to text.",
     TooltipDelay->0.35]},
   {
    TooltipBox[
     ButtonBox[
      RowBox[{"Template", " ", "Input"}],
      BaseStyle->"MediumButton",
      ButtonData:>Hold[DocumentationTools`FunctionTemplate]],
     "Use this for function templates. Lower case words will be italic.\n\
xxx$yyy makes yyy a subscript. $$ gives ...\nFunction names will become links \
when appropriate.\nRefer to bottom of format menu for shortcut.\nUse shortcut \
after typing for autoselection.",
     TooltipDelay->0.35]}
  }]], "PaletteGridCell",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, {True}, False}, "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {{
      Scaled[0.999]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{"Columns" -> {
     Offset[0.27999999999999997`], {
      Offset[0.5599999999999999]}, 
     Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
     Offset[0.2], 
     Offset[0.12], 
     Offset[0.], 
     Offset[0.8], 
     Offset[0.04], 
     Offset[1.], 
     Offset[0.2], 
     Offset[0.2], 
     Offset[0.2], 
     Offset[0.4], {
      Offset[0.2]}, 
     Offset[0.2]}, "RowsIndexed" -> {}}}],

Cell["\<\
 







\
\>", "Spacer"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {
    TooltipBox[
     ButtonBox[
      RowBox[{"Links", "  ", "\[FilledDownTriangle]"}],
      BaseStyle->"ButtonGroupHead"],
     "Choices for setting selection as hyperlink.",
     TooltipDelay->0.35]}
  },
  GridBoxItemSize->{"Columns" -> {{
       Scaled[0.999]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
    "RowsIndexed" -> {}}]], "ButtonGroupHead",
 CellGroupingRules->{"GroupTogetherNestedGrouping", 96}],

Cell[CellGroupData[{

Cell[" ", "Spacer",
 CellGroupingRules->{"GroupTogetherNestedGrouping", 97}],

Cell[" ", "Spacer",
 CellGroupingRules->{"GroupTogetherNestedGrouping", 97}],

Cell[BoxData[GridBox[{
   {GridBox[{
      {
       TooltipBox[
        ButtonBox[
         RowBox[{"Link", " ", "to", " ", "Guide"}],
         BaseStyle->"BigButton",
         ButtonData->
          "DocumentationTools`CustomLink[\"guide\",Interactive\[Rule]False,\
DocumentationTools`LinkBase\[Rule]DocumentationTools`$LinkBase]",
         Method->"Queued"],
        "Create guide page link of the selection.",
        TooltipDelay->0.35], 
       TooltipBox[
        ButtonBox[
         RowBox[{"B", "\[VeryThinSpace]"}],
         BaseStyle->"BigButton",
         ButtonData->
          "DocumentationTools`CustomLink[\"PacletDocSelect\",\"guide\"]",
         Method->"Queued"],
        "Browse for a file to be hyperlinked from your selection as a guide \
page link.",
        TooltipDelay->0.35]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxItemSize->{"Columns" -> {
         Scaled[0.84], {
          Scaled[0.14]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.06999999999999999]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}]},
   {GridBox[{
      {
       TooltipBox[
        ButtonBox[
         RowBox[{"Link", " ", "to", " ", "Tutorial"}],
         BaseStyle->"BigButton",
         ButtonData->
          "DocumentationTools`CustomLink[\"tutorial\",Interactive\[Rule]False,\
DocumentationTools`LinkBase\[Rule]DocumentationTools`$LinkBase]",
         Method->"Queued"],
        "Create tutorial link of the selection.",
        TooltipDelay->0.35], 
       TooltipBox[
        ButtonBox[
         RowBox[{"\[VeryThinSpace]", "B"}],
         BaseStyle->"BigButton",
         ButtonData->
          "DocumentationTools`CustomLink[\"PacletDocSelect\",\"tutorial\"]",
         Method->"Queued"],
        "Browse for a file to be hyperlinked from your selection as a \
tutorial link.",
        TooltipDelay->0.35]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxItemSize->{"Columns" -> {
         Scaled[0.84], {
          Scaled[0.14]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.06999999999999999]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}]},
   {GridBox[{
      {
       TooltipBox[
        ButtonBox[
         RowBox[{"Link", " ", "to", " ", "Symbol"}],
         BaseStyle->"BigButton",
         ButtonData->
          "DocumentationTools`CustomLink[\"ref\",Interactive\[Rule]False,\
DocumentationTools`LinkBase\[Rule]DocumentationTools`$LinkBase]",
         Method->"Queued"],
        "Create function page link of the selection.",
        TooltipDelay->0.35], 
       TooltipBox[
        ButtonBox[
         RowBox[{"B", "\[VeryThinSpace]"}],
         BaseStyle->"BigButton",
         ButtonData->
          "DocumentationTools`CustomLink[\"PacletDocSelect\",\"ref\"]",
         Method->"Queued"],
        "Browse for a file to be hyperlinked from your selection as a \
function page link.",
        TooltipDelay->0.35]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxItemSize->{"Columns" -> {
         Scaled[0.84], {
          Scaled[0.14]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.06999999999999999]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}]},
   {
    TooltipBox[
     ButtonBox[
      RowBox[{"Link", " ", "to", " ", "URL"}],
      BaseStyle->"BigButton",
      ButtonData->
       "DocumentationTools`CustomLink[DocumentationTools`Target->\"URL\"]",
      Method->"Queued"],
     "Insert URL to be hyperlinked from your selection.",
     TooltipDelay->0.35]},
   {
    TooltipBox[
     ButtonBox[
      RowBox[{"Edit", " ", "Link"}],
      BaseStyle->"MediumButton",
      ButtonData->"DocumentationTools`ButtonEdit",
      Method->"Queued"],
     "\"Use this to edit the contents of a link if it can't be edited inline.\
\nPlace the cursor after the link before applying.\"",
     TooltipDelay->0.35]}
  }]], "PaletteGridCell",
 CellGroupingRules->{"GroupTogetherNestedGrouping", 99},
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, {True}, False}, "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {{
      Scaled[0.999]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{"Columns" -> {
     Offset[0.27999999999999997`], {
      Offset[0.5599999999999999]}, 
     Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
     Offset[0.2], 
     Offset[0.2], 
     Offset[0.2], {
      Offset[0.4]}, 
     Offset[0.2]}, "RowsIndexed" -> {}}}],

Cell[" ", "Spacer",
 CellGroupingRules->{"GroupTogetherNestedGrouping", 97}],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {
    TooltipBox[
     ButtonBox[
      RowBox[{
      "More", " ", "Link", " ", "Tools", " ", "\[FilledDownTriangle]"}],
      BaseStyle->"ButtonSubGroupHead"],
     "Choices for setting selection as specific type of hyperlink.",
     TooltipDelay->0.35]}
  },
  GridBoxItemSize->{"Columns" -> {{
       Scaled[0.999]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
    "RowsIndexed" -> {}}]], "ButtonSubGroupHead",
 CellGroupingRules->{"GroupTogetherNestedGrouping", 98}],

Cell[" ", "Spacer",
 CellGroupingRules->{"GroupTogetherNestedGrouping", 98}],

Cell[" ", "Spacer",
 CellGroupingRules->{"GroupTogetherNestedGrouping", 98}],

Cell[BoxData[GridBox[{
   {GridBox[{
      {
       TooltipBox[
        ButtonBox[
         RowBox[{"Make", " ", "Sel", "\[ThinSpace]"}],
         BaseStyle->"MediumButton",
         ButtonData:>Hold[
           DocumentationTools`InsertLink["PreserveSelectionContent" -> True]]],
        "Creates a link to the selected cell and saves the data in a form \
that can be used by the button to the right of this one. First select a cell \
in a saved notebook and then use the button to the right of this one to make \
selected text in a notebook into a link using the data obtained.",
        TooltipDelay->0.35], 
       TooltipBox[
        ButtonBox[
         RowBox[{"Make", " ", "Link", "\[ThinSpace]"}],
         BaseStyle->"MediumButton",
         ButtonData->"DocumentationTools`LinkSelection"],
        "Inserts a link over selected text. Use the button to the left of \
this one first.",
        TooltipDelay->0.35]}
     },
     GridBoxItemSize->{"Columns" -> {
         Scaled[0.49], {
          Scaled[0.49]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.06999999999999999]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}]},
   {
    TooltipBox[
     ButtonBox[
      RowBox[{"Link", " ", "to", " ", "Document"}],
      BaseStyle->"BigButton",
      ButtonData->"DocumentationTools`CustomLink[\"PacletDocSelect\"]",
      Method->"Queued"],
     "Browse your package layout for a notebook or PDF file to be linked from \
your selection.\nRelies on $ApplicationName, and target documents can reside \
in any directory under Documentation/$Language.",
     TooltipDelay->0.35]},
   {GridBox[{
      {
       TooltipBox[
        ButtonBox[
         RowBox[{"Custom", " ", "URI"}],
         BaseStyle->"BigButton",
         ButtonData->
          "DocumentationTools`CustomLink[DocumentationTools`PacletInteractive\
\[Rule]True]",
         Method->"Queued"],
        "Creates a link based on the paclet URI you provide interactively.",
        TooltipDelay->0.35], 
       TooltipBox[
        ButtonBox[
         RowBox[{"A", "\[VeryThinSpace]"}],
         BaseStyle->"NotchButton",
         ButtonData->
          "DocumentationTools`CustomLink[DocumentationTools`PacletInteractive \
-> Automatic]"],
        "Apply preset paclet URI automatically.",
        TooltipDelay->0.35], 
       TooltipBox[
        ButtonBox[
         RowBox[{"S", "\[VeryThinSpace]"}],
         BaseStyle->"NotchButton",
         ButtonData->"DocumentationTools`Set$PacletURI",
         Method->"Queued"],
        "Preset a paclet URI by entering it directly. If the paclet URI is \
not the same as the directory location, you can set the directory location \
separately using $TargetDocumentDir.",
        TooltipDelay->0.35], 
       TooltipBox[
        ButtonBox[
         RowBox[{"B", "\[VeryThinSpace]"}],
         BaseStyle->"NotchButton",
         ButtonData->"DocumentationTools`Set$PacletURI[\"Browse\"]",
         Method->"Queued"],
        "Browse to preset paclet URI. If URI is not the same as the directory \
location, you can set the directory location separately using \
$TargetDocumentDir.",
        TooltipDelay->0.35]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxItemSize->{"Columns" -> {
         Scaled[0.77], {
          Scaled[0.07]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.13999999999999999`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}]}
  }]], "PaletteGridCell",
 CellGroupingRules->{"GroupTogetherNestedGrouping", 98},
 GridBoxOptions->{ColumnsEqual->True,
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, {True}, False}, "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {{
      Scaled[0.999]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{"Columns" -> {
     Offset[0.27999999999999997`], {
      Offset[-0.06999999999999999]}, 
     Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {{
      Offset[0.2]}}, "RowsIndexed" -> {}}}]
}, Closed]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {
    TooltipBox[
     ButtonBox[
      RowBox[{"Formatting", "  ", "\[FilledDownTriangle]"}],
      BaseStyle->"ButtonGroupHead"],
     "Choices for formatting and special characters.",
     TooltipDelay->0.35]}
  },
  GridBoxItemSize->{"Columns" -> {{
       Scaled[0.999]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
    "RowsIndexed" -> {}}]], "ButtonGroupHead",
 CellGroupingRules->{"GroupTogetherNestedGrouping", 95}],

Cell[CellGroupData[{

Cell[" ", "Spacer",
 CellGroupingRules->{"GroupTogetherNestedGrouping", 96}],

Cell[" ", "Spacer",
 CellGroupingRules->{"GroupTogetherNestedGrouping", 96}],

Cell[BoxData[GridBox[{
   {
    TooltipBox[
     ButtonBox[
      RowBox[{"Special", " ", "Formatting"}],
      BaseStyle->"BigButton",
      ButtonData:>Hold[
        DocumentationTools`DocumentSample["SpecialForms.nb"]]],
     "A palette of additional input forms.",
     TooltipDelay->0.35]},
   {
    TooltipBox[
     ButtonBox[
      RowBox[{"Default", " ", "Format"}],
      BaseStyle->"BigButton",
      ButtonData:>Hold[DocumentationTools`RestoreDefault]],
     "Use this to return to the default format of the current cell while \
typing, or to remove formatting on the selection.",
     TooltipDelay->0.35]},
   {
    TooltipBox[
     ButtonBox[
      RowBox[{"Literal", " ", "Input"}],
      BaseStyle->"MediumButton",
      ButtonData:>Hold[
        DocumentationTools`FunctionTemplate["Plain"]]],
     "Use this for literal Mathematica input format in text. Same as doing \
CTRL+9 (for inline cell).",
     TooltipDelay->0.35]},
   {
    TooltipBox[
     ButtonBox[
      RowBox[{"Code", " ", "Cell"}],
      BaseStyle->"MediumButton",
      ButtonData:>Hold[
        DocumentationTools`StyleApply["Code"]]],
     "Use this for code examples in stand\[Hyphen]alone cells.",
     TooltipDelay->0.35]},
   {
    TooltipBox[
     ButtonBox[
      RowBox[{"Code", " ", "Inline"}],
      BaseStyle->"MediumButton",
      ButtonData:>Hold[
        DocumentationTools`StyleApply["InlineCode"]]],
     "Use this for code or other computer voice elements inline in text.",
     TooltipDelay->0.35]},
   {
    TooltipBox[
     ButtonBox[
      RowBox[{"Italic", " ", "Input"}],
      BaseStyle->"SmallButton",
      ButtonData:>Hold[
        DocumentationTools`StyleApply["TI"]]],
     "Use this to make italics in function templates only (e.g. for function \
arguments)",
     TooltipDelay->0.35]},
   {
    TooltipBox[
     ButtonBox[
      RowBox[{"Plain", " ", "Text"}],
      BaseStyle->"SmallButton",
      ButtonData:>Hold[
        DocumentationTools`StyleApply["TR"]]],
     "Use this to make plain text in function templates only (e.g. for \
function arguments).",
     TooltipDelay->0.35]},
   {
    TooltipBox[
     ButtonBox[
      RowBox[{"Traditional", " ", "Math"}],
      BaseStyle->"MediumButton",
      ButtonData:>Hold[DocumentationTools`TraditionalFormCell]],
     "Use this to begin or apply Mathematica TraditionalForm.",
     TooltipDelay->0.35]},
   {
    TooltipBox[
     ButtonBox[
      RowBox[{"Converted", " ", "TeX"}],
      BaseStyle->"MediumButton",
      ButtonData:>Hold[DocumentationTools`ConvertTeX]],
     "Use this to make math from TeX input, with $ $ delimiters.\nRefer to \
bottom of format menu for shortcut.\nUse shortcut after typing for \
autoselection.",
     TooltipDelay->0.35]},
   {
    TooltipBox[
     ButtonBox[
      RowBox[{
       CheckboxBox[Dynamic[
         DocumentationTools`UndeploymentSetting[
          InputNotebook[]]], {False, True, Blank[]}], "\[ThickSpace]\[ThickSpace]",
        "Undeploy"}],
      BaseStyle->"MediumButton",
      ButtonFunction:>DocumentationTools`UndeploymentSetter[
        InputNotebook[]]],
     "Toggle setting of input notebook to be left untouched by documentation \
build processes.",
     TooltipDelay->0.35]},
   {
    TooltipBox[
     ButtonBox["Tentative",
      Background->RGBColor[0.6, 0.9, 0.95],
      BaseStyle->"TinyButton",
      ButtonData->"DocumentationTools`StyleAppend[\"TentativeExample\"]"],
     "Mark cells waiting for confirmation to add to the current documentation \
build.\nToggles setting on/off.",
     TooltipDelay->0.35]},
   {GridBox[{
      {
       TooltipBox[
        ButtonBox["Annotate",
         Background->GrayLevel[0.8],
         BaseStyle->"TinyButton",
         ButtonData:>Hold[
           DocumentationTools`AnnotationInsert[]]],
        "Dialog for annotating a cell or editing a cell's annotation.",
        TooltipDelay->0.35], 
       TooltipBox[
        ButtonBox[
         StyleBox["\[FilledDownTriangle]",
          FontSize->9],
         BaseStyle->"NotchButton",
         ButtonData:>Hold[
           DocumentationTools`AnnotationSearch["Down"]]],
        "Searches down in the input notebook for the next annotation cell.",
        TooltipDelay->0.35], 
       TooltipBox[
        ButtonBox[
         StyleBox["\[FilledUpTriangle]",
          FontSize->9],
         BaseStyle->"NotchButton",
         ButtonData:>Hold[
           DocumentationTools`AnnotationSearch["Up"]]],
        "Searches up in the input notebook for the next annotation cell.",
        TooltipDelay->0.35], 
       TooltipBox[
        ButtonBox[
         RowBox[{"D", "\[VeryThinSpace]"}],
         Background->GrayLevel[0.8],
         BaseStyle->"NotchButton",
         ButtonData:>Hold[
           DocumentationTools`AnnotationRemove[]]],
        "Remove a cell's annotation.",
        TooltipDelay->0.35]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxItemSize->{"Columns" -> {
         Scaled[0.75], {
          Scaled[0.07]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.06999999999999999]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}]}
  }]], "PaletteGridCell",
 CellGroupingRules->{"GroupTogetherNestedGrouping", 96},
 GridBoxOptions->{ColumnsEqual->True,
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, {True}, False}, "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {{
      Scaled[0.999]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{"Columns" -> {
     Offset[0.27999999999999997`], {
      Offset[-0.06999999999999999]}, 
     Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
     Offset[0.2], 
     Offset[0.2], 
     Offset[0.4], 
     Offset[0.2], 
     Offset[0.4], 
     Offset[0.2], 
     Offset[0.4], 
     Offset[0.2], 
     Offset[0.2], 
     Offset[0.4], 
     Offset[0.4], {
      Offset[0.2]}, 
     Offset[0.2]}, "RowsIndexed" -> {}}}]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {
    TooltipBox[
     ButtonBox[
      RowBox[{"Overview", " ", "Tools", "  ", "\[FilledDownTriangle]"}],
      BaseStyle->"ButtonGroupHead"],
     "Construct overviews one cell at a time.",
     TooltipDelay->0.35]}
  },
  GridBoxItemSize->{"Columns" -> {{
       Scaled[0.999]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
    "RowsIndexed" -> {}}]], "ButtonGroupHead",
 CellGroupingRules->{"GroupTogetherNestedGrouping", 94}],

Cell[CellGroupData[{

Cell[" ", "Spacer",
 CellGroupingRules->{"GroupTogetherNestedGrouping", 95}],

Cell[" ", "Spacer",
 CellGroupingRules->{"GroupTogetherNestedGrouping", 95}],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {
    TooltipBox[
     ButtonBox[
      RowBox[{"Generate", " ", "Overview"}],
      BaseStyle->"BigButton",
      ButtonData->"DocumentationTools`GenerateOverviewDialog",
      Method->"Queued"],
     "Create an overview page of a selected list of tutorial files.",
     TooltipDelay->0.35]},
   {
    TooltipBox[
     ButtonBox[
      RowBox[{"New", " ", "Overview", " ", "Page"}],
      BaseStyle->"BigButton",
      ButtonData->Hold[
        DocumentationTools`CreateNewPageDialog["Overview"]],
      Method->"Queued"],
     "Start new Overview page.",
     TooltipDelay->0.35]},
   {
    TooltipBox[
     ButtonBox["TOCChapter",
      BaseStyle->"MediumButton",
      ButtonData->Hold[
        DocumentationTools`StyleApply["TOCChapter"]],
      Method->"Queued"],
     "Insert TOCChapter cell or apply style to a cell.",
     TooltipDelay->0.35]},
   {
    TooltipBox[
     ButtonBox["TOCSection",
      BaseStyle->"MediumButton",
      ButtonData->Hold[
        DocumentationTools`StyleApply["TOCSection"]],
      Method->"Queued"],
     "Insert TOCSection cell or apply style to a cell.",
     TooltipDelay->0.35]},
   {
    TooltipBox[
     ButtonBox["TOCSubsection",
      BaseStyle->"MediumButton",
      ButtonData->Hold[
        DocumentationTools`StyleApply["TOCSubsection"]],
      Method->"Queued"],
     "Insert TOCSubsection cell or apply style to a cell.",
     TooltipDelay->0.35]},
   {
    TooltipBox[
     ButtonBox["TOCSubsubsection",
      BaseStyle->"MediumButton",
      ButtonData->Hold[
        DocumentationTools`StyleApply["TOCSubsubsection"]],
      Method->"Queued"],
     "Insert TOCSubsubsection cell or apply style to a cell.",
     TooltipDelay->0.35]}
  }]], "PaletteGridCell",
 CellGroupingRules->{"GroupTogetherNestedGrouping", 400},
 GridBoxOptions->{ColumnsEqual->True,
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, {True}, False}, "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {{
      Scaled[0.999]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{"Columns" -> {
     Offset[0.27999999999999997`], {
      Offset[0.]}, 
     Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
     Offset[0.2], 
     Offset[0.4], 
     Offset[0.4], {
      Offset[0.08]}, 
     Offset[0.2]}, "RowsIndexed" -> {}}}],

Cell[" ", "Spacer",
 CellGroupingRules->{"GroupTogetherNestedGrouping", 400}],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {
    TooltipBox[
     ButtonBox[
      RowBox[{"TOC", " ", "Link", " ", "Tools"}],
      Active->False,
      BaseStyle->"ButtonSubGroupHead"],
     "Link cells in an overview to tutorial cells.",
     TooltipDelay->0.35]}
  },
  GridBoxItemSize->{"Columns" -> {{
       Scaled[0.999]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
    "RowsIndexed" -> {}}]], "ButtonSubGroupHead",
 CellGroupingRules->{"GroupTogetherNestedGrouping", 401}],

Cell[" ", "Spacer",
 CellGroupingRules->{"GroupTogetherNestedGrouping", 401}],

Cell[" ", "Spacer",
 CellGroupingRules->{"GroupTogetherNestedGrouping", 401}],

Cell[BoxData[GridBox[{
   {
    ButtonBox[
     RowBox[{"1", "\[VeryThinSpace]"}],
     Active->False,
     BaseStyle->"MediumButton"], 
    TooltipBox[
     ButtonBox["Browse",
      BaseStyle->"MediumButton",
      ButtonData:>Hold[DocumentationTools`BrowseToTutorialAndOpen],
      Method->"Queued"],
     "Browse for a tutorial to link to its headings.",
     TooltipDelay->0.35]},
   {
    ButtonBox["2",
     Active->False,
     BaseStyle->"MediumButton"], 
    TooltipBox[
     ButtonBox[
      RowBox[{"Select", " ", "Cell"}],
      BaseStyle->"MediumButton",
      ButtonData:>Hold[DocumentationTools`CopyTutorialCellData],
      Method->"Queued"],
     "Select a cell bracket in the browsed for tutorial and then click this \
button.",
     TooltipDelay->0.35]},
   {
    ButtonBox[
     RowBox[{"3", "\[VeryThinSpace]"}],
     Active->False,
     BaseStyle->"MediumButton"], 
    TooltipBox[
     ButtonBox["Paste",
      BaseStyle->"MediumButton",
      ButtonData:>Hold[DocumentationTools`PasteTutorialCell],
      Method->"Queued"],
     "Click on a cell bracket or between cells in the overview being \
constructed and then click this button.",
     TooltipDelay->0.35]}
  },
  GridBoxAlignment->{
   "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
    "RowsIndexed" -> {}},
  GridBoxDividers->{
   "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
    "Rows" -> {False, {True}, False}, "RowsIndexed" -> {}},
  GridBoxItemSize->{"Columns" -> {
      Scaled[0.1], {
       Scaled[0.88]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
    "RowsIndexed" -> {}},
  GridBoxSpacings->{"Columns" -> {
      Offset[0.27999999999999997`], {
       Offset[0.06999999999999999]}, 
      Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
      Offset[0.2], {
       Offset[0.08]}, 
      Offset[0.2]}, "RowsIndexed" -> {}}]], "PaletteGridCell",
 CellGroupingRules->{"GroupTogetherNestedGrouping", 401}]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {
    TooltipBox[
     ButtonBox[
      RowBox[{"Utilities", "  ", "\[FilledDownTriangle]"}],
      BaseStyle->"ButtonGroupHead"],
     "Choices for setting selection as hyperlink.",
     TooltipDelay->0.35]}
  },
  GridBoxItemSize->{"Columns" -> {{
       Scaled[0.999]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
    "RowsIndexed" -> {}}]], "ButtonGroupHead",
 CellGroupingRules->{"GroupTogetherNestedGrouping", 93}],

Cell[CellGroupData[{

Cell[" ", "Spacer",
 CellGroupingRules->{"GroupTogetherNestedGrouping", 94}],

Cell[" ", "Spacer",
 CellGroupingRules->{"GroupTogetherNestedGrouping", 94}]
}, Open  ]],

Cell[BoxData[GridBox[{
   {GridBox[{
      {
       TooltipBox[
        ButtonBox[
         RowBox[{"Extract", " ", "Tutorials"}],
         BaseStyle->"BigButton",
         ButtonData->"DocumentationTools`DivideTutorials",
         Method->"Queued"],
        "Generate tutorial files from a collection of documentation files.\n\
Resulting  notebooks are placed in Tutorials directory within the selected \
directory.\nAn overview for the new notebooks is also created.",
        TooltipDelay->0.35], 
       TooltipBox[
        ButtonBox[
         StyleBox[
          RowBox[{"I", "\[ThinSpace]"}],
          FontSize->8.5],
         BaseStyle->"NotchButton",
         ButtonData->
          "DocumentationTools`DivideTutorials[DocumentationTools`\
DivideTutorialsScope\[Rule]File]",
         Method->"Queued"],
        "Generate tutorial files from input notebook.",
        TooltipDelay->0.35]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxItemSize->{"Columns" -> {
         Scaled[0.9], {
          Scaled[0.08]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.06999999999999999]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}]},
   {
    TooltipBox[
     ButtonBox[
      RowBox[{"Fix", " ", "Table", " ", "Formatting"}],
      BaseStyle->"BigButton",
      ButtonData->"DocumentationTools`GenerateTransformedTable",
      Method->"Queued"],
     "Select a table cell in a tutorial. This function attempts to fix table \
formatting.\nA reformatted table is provided in a separate notebook for \
replacement of the original table.",
     TooltipDelay->0.35]},
   {
    TooltipBox[
     ButtonBox[
      RowBox[{"Fix", " ", "Links", " ", "to", " ", "Symbols"}],
      BaseStyle->"BigButton",
      ButtonData->"DocumentationTools`ApplicationSymbolsLinkFix",
      Method->"Queued"],
     "Add button data to application symbol buttons as needed in all \
notebooks in a directory.\nResulting  notebooks are placed in \
NotebooksWithModifiedButtons directory within the selected directory.\nUse \
either $IncludedApplicationSymbols or $ExcludedApplicationSymbols if not all \
package sysmbols are to be handled automatically.",
     TooltipDelay->0.35]},
   {
    TooltipBox[
     ButtonBox[
      RowBox[{"Replace", " ", "Paclet", " ", "Base"}],
      BaseStyle->"BigButton",
      ButtonData->"DocumentationTools`ReplacePacletBase",
      Method->"Queued"],
     "Change the context and package name in metadata as well as the \
application name used in button data in all notebooks in a directory.\n\
Resulting  notebooks are placed in NotebooksWithPacletBaseReplaced directory \
within the selected directory.",
     TooltipDelay->0.35]}
  }]], "PaletteGridCell",
 CellGroupingRules->{"GroupTogetherNestedGrouping", 93},
 GridBoxOptions->{ColumnsEqual->True,
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, {True}, False}, "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {{
      Scaled[0.999]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{"Columns" -> {
     Offset[0.27999999999999997`], {
      Offset[-0.06999999999999999]}, 
     Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
     Offset[0.2], 
     Offset[0.8], 
     Offset[0.8], {
      Offset[0.2]}, 
     Offset[0.2]}, "RowsIndexed" -> {}}}]
}, Closed]],

Cell["\<\
 











\
\>", "Spacer"]
},
ClosingAutoSave->True,
Editable->False,
Saveable->False,
WindowToolbars->{},
NotebookDynamicExpression:>(SetOptions[
   Part[
    Notebooks["DocumentationTools"], 1], WindowMargins -> {{Automatic, 0}, {
      If[
       StringMatchQ[$System, 
        StringExpression["Linux", 
         BlankNullSequence[]]], 100, 0], 0}}]; Needs["DocumentationTools`"]),
Selectable->False,
WindowSize->{152, Automatic},
WindowMargins->{{Automatic, 0}, {0, 0}},
WindowFrame->"Palette",
WindowElements->{},
WindowFrameElements->"CloseBox",
WindowFloating->True,
WindowClickSelect->False,
WindowTitle->"DocumentationTools",
ScrollingOptions->{"PagewiseDisplay"->True,
"PagewiseScrolling"->False,
"VerticalScrollRange"->Fit},
ShowCellBracket->False,
CellMargins->{{0, 0}, {0, 0}},
Active->True,
AutoMultiplicationSymbol->False,
FontProperties->{"ScreenResolution"->72},
Background->GrayLevel[0.7],
ButtonBoxOptions->{ButtonFunction:>(FrontEnd`MessagesToConsole[
 Needs["DocumentationTools`"]; DocumentationTools`DocuToolsLoader[]; 
  Function[$CellContext`e, 
    ReleaseHold[
     If[
      StringQ[$CellContext`e], 
      ToExpression[$CellContext`e], $CellContext`e][]], HoldFirst][#2][]]& )},
FrontEndVersion->"7.0 for Microsoft Windows (32-bit) (February 18, 2009)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData["PaletteTabCell"], PageWidth -> 153, 
    CellFrame -> {{0, 0}, {1, 0}}, CellMargins -> {{0, 0}, {-1, 0}}, 
    PageBreakAbove -> True, CellFrameMargins -> -1, FontSize -> 9, Background -> 
    GrayLevel[0.7]], 
   Cell[
    StyleData["PaletteTab"], FontFamily -> "Verdana", FontWeight -> "Bold", 
    FontColor -> GrayLevel[1], 
    ButtonBoxOptions -> {
     Active -> True, Appearance -> {Automatic, "Palette"}, Background -> 
      GrayLevel[0.7], ButtonFunction :> (FrontEndExecute[{
         NotebookLocate[#2]}]& ), ButtonMargins -> 2}], 
   Cell[
    StyleData["PaletteTabSelected"], FontFamily -> "Verdana", FontWeight -> 
    "Bold", FontColor -> GrayLevel[0.5], 
    ButtonBoxOptions -> {
     Appearance -> {Automatic, "Palette"}, Background -> GrayLevel[0], 
      ButtonFunction :> Null, ButtonMargins -> 2}], 
   Cell[
    StyleData["PaletteGridCell"], PageWidth -> 153, 
    CellMargins -> {{0, 0}, {0, -1}}, FontFamily -> "Verdana", FontSize -> 11,
     FontWeight -> "Plain", FontColor -> GrayLevel[0.7], 
    ButtonBoxOptions -> {
     Appearance -> {Automatic, "Palette"}, Evaluator -> Automatic, Method -> 
      "Preemptive"}], 
   Cell[
    StyleData["ButtonGroupHead"], PageWidth -> 153, 
    CellMargins -> {{0, 0}, {0, 6}}, FontFamily -> "Verdana", FontSize -> 9, 
    FontWeight -> "Bold", FontColor -> GrayLevel[1], 
    ButtonBoxOptions -> {
     Active -> True, Appearance -> {Automatic, "Palette"}, Background -> 
      GrayLevel[0.5], ButtonData :> DocumentationTools`CellGroupToggle, 
      ButtonMargins -> 2, Evaluator -> Automatic, Method -> "Preemptive"}], 
   Cell[
    StyleData["ButtonGroupHeadNonToggle"], PageWidth -> 153, 
    CellMargins -> {{0, 0}, {0, 6}}, FontFamily -> "Verdana", FontSize -> 9, 
    FontWeight -> "Bold", FontColor -> GrayLevel[1], 
    ButtonBoxOptions -> {
     Active -> True, Appearance -> {Automatic, "Palette"}, Background -> 
      GrayLevel[0.5], ButtonMargins -> 2, Evaluator -> Automatic}], 
   Cell[
    StyleData["ButtonSubGroupHead"], PageWidth -> 153, 
    CellMargins -> {{0, 0}, {0, 6}}, FontFamily -> "Verdana", FontSize -> 9, 
    FontWeight -> "Bold", FontColor -> GrayLevel[1], 
    ButtonBoxOptions -> {
     Active -> True, Appearance -> {Automatic, "Palette"}, Background -> 
      GrayLevel[0.6], ButtonData :> DocumentationTools`CellGroupToggle, 
      ButtonMargins -> 1, Evaluator -> Automatic, Method -> "Preemptive"}], 
   Cell[
    StyleData["BoldButton"], FontFamily -> "Verdana", FontSize -> 10, 
    FontWeight -> "Bold", FontColor -> GrayLevel[1], 
    ButtonBoxOptions -> {
     Background -> GrayLevel[0], ButtonMargins -> 6, Evaluator -> Automatic, 
      Method -> "Preemptive"}], 
   Cell[
    StyleData["BigButton"], FontFamily -> "Verdana", FontSize -> 10, 
    FontColor -> GrayLevel[0], 
    ButtonBoxOptions -> {
     Appearance -> {Automatic, "FramedPalette"}, ButtonMargins -> 5, 
      Evaluator -> Automatic, Method -> "Preemptive"}], 
   Cell[
    StyleData["BigButton2"], FontFamily -> "Verdana", FontSize -> 10, 
    FontColor -> GrayLevel[0], 
    ButtonBoxOptions -> {
     Appearance -> {Automatic, "FramedPalette"}, ButtonMargins -> 3.5, 
      Evaluator -> Automatic, Method -> "Preemptive"}], 
   Cell[
    StyleData["MediumButton"], FontFamily -> "Verdana", FontSize -> 10, 
    FontColor -> GrayLevel[0], 
    ButtonBoxOptions -> {
     Appearance -> {Automatic, "FramedPalette"}, ButtonMargins -> 3.5, 
      Evaluator -> Automatic, Method -> "Preemptive"}], 
   Cell[
    StyleData["MediumButtonDark"], FontFamily -> "Verdana", FontSize -> 10, 
    FontColor -> GrayLevel[0.7], 
    ButtonBoxOptions -> {
     Background -> GrayLevel[0.2], ButtonMargins -> 3.5, Evaluator -> 
      Automatic, Method -> "Preemptive"}], 
   Cell[
    StyleData["SmallButton"], FontFamily -> "Verdana", FontSize -> 10, 
    FontColor -> GrayLevel[0], 
    ButtonBoxOptions -> {
     Appearance -> {Automatic, "FramedPalette"}, ButtonMargins -> 2, 
      Evaluator -> Automatic, Method -> "Preemptive"}], 
   Cell[
    StyleData["SmallButtonDark"], FontFamily -> "Verdana", FontSize -> 10, 
    FontColor -> GrayLevel[0.7], 
    ButtonBoxOptions -> {
     Background -> GrayLevel[0.2], ButtonMargins -> 1, Evaluator -> Automatic,
       Method -> "Preemptive"}], 
   Cell[
    StyleData["TinyButton"], FontFamily -> "Verdana", FontSize -> 9, 
    FontColor -> GrayLevel[0], 
    ButtonBoxOptions -> {
     Appearance -> {Automatic, "FramedPalette"}, ButtonMargins -> 1, 
      Evaluator -> Automatic, Method -> "Queued"}], 
   Cell[
    StyleData["TinyButtonDark"], FontFamily -> "Verdana", FontSize -> 9, 
    FontColor -> GrayLevel[0.7], 
    ButtonBoxOptions -> {
     Background -> GrayLevel[0.4], ButtonMargins -> 0, Evaluator -> Automatic,
       Method -> "Preemptive"}], 
   Cell[
    StyleData["NotchButton"], FontFamily -> "Verdana", FontSize -> 8, 
    FontColor -> GrayLevel[0], 
    ButtonBoxOptions -> {
     Appearance -> {Automatic, "FramedPalette"}, ButtonMargins -> 1, 
      Evaluator -> Automatic}], 
   Cell[
    StyleData["NotchButtonDark"], FontFamily -> "Verdana", FontSize -> 8, 
    FontColor -> GrayLevel[0], 
    ButtonBoxOptions -> {
     Background -> GrayLevel[0.7], ButtonMargins -> 1, Evaluator -> 
      Automatic}], 
   Cell[
    StyleData["NotchButtonTiny"], FontFamily -> "Verdana", FontSize -> 8, 
    FontColor -> GrayLevel[0], 
    ButtonBoxOptions -> {ButtonMargins -> 0, Evaluator -> Automatic}], 
   Cell[
    StyleData["GrayText"], FontFamily -> "Verdana", FontSize -> 10, FontColor -> 
    GrayLevel[0.5]], 
   Cell[
    StyleData["ScrollToggle"], FontFamily -> "Verdana", FontWeight -> "Bold", 
    FontColor -> GrayLevel[1], 
    ButtonBoxOptions -> {
     Active -> True, Appearance -> {Automatic, "Palette"}, Background -> 
      GrayLevel[0.7], ButtonData :> DocumentationTools`ScrollBarToggle, 
      ButtonMargins -> 2, Evaluator -> Automatic, Method -> "Preemptive"}], 
   Cell[
    StyleData["PaletteHelpExt"], FontFamily -> "Verdana", FontWeight -> 
    "Bold", FontColor -> GrayLevel[1], 
    ButtonBoxOptions -> {
     Active -> True, Appearance -> {Automatic, "Palette"}, Background -> 
      GrayLevel[0.7], ButtonFunction :> NotebookOpen[
        ToFileName[{
         DocumentationTools`$DocuToolsDir, "Documentation", "English", 
          "Guides"}, "AuthoringUsingDocumentationTools.nb"]], ButtonMargins -> 
      2, Evaluator -> Automatic, Method -> "Preemptive"}], 
   Cell[
    StyleData["Spacer"], CellMargins -> {{0, 0}, {0, 0}}, 
    CellElementSpacings -> {"CellMinHeight" -> 2}, FontSize -> 2], 
   Cell[
    StyleData["FunctionField"], FontSize -> 9, FontColor -> GrayLevel[0]]}, 
  Visible -> False, FrontEndVersion -> 
  "7.0 for Microsoft Windows (32-bit) (February 18, 2009)", StyleDefinitions -> 
  "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "FunctionsExternal"->{
  Cell[578, 21, 1308, 44, 15, "PaletteTabCell",
   PageBreakAbove->False,
   CellTags->"FunctionsExternal"]},
 "GuidesExternal"->{
  Cell[40274, 1199, 1281, 43, 15, "PaletteTabCell",
   CellTags->"GuidesExternal"]},
 "TutorialsExternal"->{
  Cell[67797, 2023, 1284, 43, 15, "PaletteTabCell",
   CellTags->"TutorialsExternal"]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"FunctionsExternal", 115215, 3389},
 {"GuidesExternal", 115346, 3393},
 {"TutorialsExternal", 115455, 3396}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[578, 21, 1308, 44, 15, "PaletteTabCell",
 PageBreakAbove->False,
 CellTags->"FunctionsExternal"],
Cell[1889, 67, 5135, 127, 133, "PaletteGridCell"],
Cell[7027, 196, 35, 10, 26, "Spacer"],
Cell[CellGroupData[{
Cell[7087, 210, 623, 14, 22, "ButtonGroupHead",
 CellGroupingRules->{"GroupTogetherNestedGrouping", 100}],
Cell[CellGroupData[{
Cell[7735, 228, 77, 1, 2, "Spacer",
 CellGroupingRules->{"GroupTogetherNestedGrouping", 101}],
Cell[7815, 231, 77, 1, 2, "Spacer",
 CellGroupingRules->{"GroupTogetherNestedGrouping", 101}],
Cell[7895, 234, 5626, 165, 233, "PaletteGridCell",
 CellGroupingRules->{"GroupTogetherNestedGrouping", 101}]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[13570, 405, 455, 12, 20, "ButtonGroupHead",
 CellGroupingRules->{"GroupTogetherNestedGrouping", 99}],
Cell[CellGroupData[{
Cell[14050, 421, 77, 1, 2, "Spacer",
 CellGroupingRules->{"GroupTogetherNestedGrouping", 100}],
Cell[14130, 424, 3082, 89, 100, "PaletteGridCell",
 CellGroupingRules->{"GroupTogetherNestedGrouping", 100}]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[17261, 519, 442, 12, 20, "ButtonGroupHead",
 CellGroupingRules->{"GroupTogetherNestedGrouping", 96}],
Cell[CellGroupData[{
Cell[17728, 535, 76, 1, 2, "Spacer",
 CellGroupingRules->{"GroupTogetherNestedGrouping", 97}],
Cell[17807, 538, 76, 1, 2, "Spacer",
 CellGroupingRules->{"GroupTogetherNestedGrouping", 97}],
Cell[17886, 541, 5466, 149, 116, "PaletteGridCell",
 CellGroupingRules->{"GroupTogetherNestedGrouping", 99}],
Cell[23355, 692, 76, 1, 2, "Spacer",
 CellGroupingRules->{"GroupTogetherNestedGrouping", 97}],
Cell[CellGroupData[{
Cell[23456, 697, 497, 13, 21, "ButtonSubGroupHead",
 CellGroupingRules->{"GroupTogetherNestedGrouping", 98}],
Cell[23956, 712, 76, 1, 70, "Spacer",
 CellGroupingRules->{"GroupTogetherNestedGrouping", 98}],
Cell[24035, 715, 76, 1, 70, "Spacer",
 CellGroupingRules->{"GroupTogetherNestedGrouping", 98}],
Cell[24114, 718, 4566, 114, 70, "PaletteGridCell",
 CellGroupingRules->{"GroupTogetherNestedGrouping", 98}]
}, Closed]]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[28741, 839, 450, 12, 20, "ButtonGroupHead",
 CellGroupingRules->{"GroupTogetherNestedGrouping", 95}],
Cell[CellGroupData[{
Cell[29216, 855, 76, 1, 2, "Spacer",
 CellGroupingRules->{"GroupTogetherNestedGrouping", 96}],
Cell[29295, 858, 76, 1, 2, "Spacer",
 CellGroupingRules->{"GroupTogetherNestedGrouping", 96}],
Cell[29374, 861, 6256, 185, 235, "PaletteGridCell",
 CellGroupingRules->{"GroupTogetherNestedGrouping", 96}]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[35679, 1052, 446, 12, 20, "ButtonGroupHead",
 CellGroupingRules->{"GroupTogetherNestedGrouping", 94}],
Cell[CellGroupData[{
Cell[36150, 1068, 76, 1, 2, "Spacer",
 CellGroupingRules->{"GroupTogetherNestedGrouping", 95}],
Cell[36229, 1071, 76, 1, 2, "Spacer",
 CellGroupingRules->{"GroupTogetherNestedGrouping", 95}]
}, Open  ]],
Cell[36320, 1075, 2203, 53, 70, "PaletteGridCell",
 CellGroupingRules->{"GroupTogetherNestedGrouping", 94}]
}, Closed]],
Cell[38538, 1131, 39, 14, 38, "Spacer"],
Cell[38580, 1147, 1691, 50, 97, "PaletteGridCell"],
Cell[40274, 1199, 1281, 43, 15, "PaletteTabCell",
 CellTags->"GuidesExternal"],
Cell[41558, 1244, 5356, 149, 194, "PaletteGridCell"],
Cell[46917, 1395, 35, 10, 26, "Spacer"],
Cell[CellGroupData[{
Cell[46977, 1409, 442, 12, 22, "ButtonGroupHead",
 CellGroupingRules->{"GroupTogetherNestedGrouping", 96}],
Cell[CellGroupData[{
Cell[47444, 1425, 76, 1, 2, "Spacer",
 CellGroupingRules->{"GroupTogetherNestedGrouping", 97}],
Cell[47523, 1428, 76, 1, 2, "Spacer",
 CellGroupingRules->{"GroupTogetherNestedGrouping", 97}],
Cell[47602, 1431, 5466, 149, 116, "PaletteGridCell",
 CellGroupingRules->{"GroupTogetherNestedGrouping", 99}],
Cell[53071, 1582, 76, 1, 2, "Spacer",
 CellGroupingRules->{"GroupTogetherNestedGrouping", 97}],
Cell[CellGroupData[{
Cell[53172, 1587, 497, 13, 21, "ButtonSubGroupHead",
 CellGroupingRules->{"GroupTogetherNestedGrouping", 98}],
Cell[53672, 1602, 76, 1, 70, "Spacer",
 CellGroupingRules->{"GroupTogetherNestedGrouping", 98}],
Cell[53751, 1605, 76, 1, 70, "Spacer",
 CellGroupingRules->{"GroupTogetherNestedGrouping", 98}],
Cell[53830, 1608, 4566, 114, 70, "PaletteGridCell",
 CellGroupingRules->{"GroupTogetherNestedGrouping", 98}]
}, Closed]]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[58457, 1729, 450, 12, 20, "ButtonGroupHead",
 CellGroupingRules->{"GroupTogetherNestedGrouping", 95}],
Cell[CellGroupData[{
Cell[58932, 1745, 76, 1, 2, "Spacer",
 CellGroupingRules->{"GroupTogetherNestedGrouping", 96}],
Cell[59011, 1748, 76, 1, 2, "Spacer",
 CellGroupingRules->{"GroupTogetherNestedGrouping", 96}],
Cell[59090, 1751, 6256, 185, 235, "PaletteGridCell",
 CellGroupingRules->{"GroupTogetherNestedGrouping", 96}]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[65395, 1942, 446, 12, 20, "ButtonGroupHead",
 CellGroupingRules->{"GroupTogetherNestedGrouping", 94}],
Cell[CellGroupData[{
Cell[65866, 1958, 76, 1, 2, "Spacer",
 CellGroupingRules->{"GroupTogetherNestedGrouping", 95}],
Cell[65945, 1961, 76, 1, 2, "Spacer",
 CellGroupingRules->{"GroupTogetherNestedGrouping", 95}]
}, Open  ]],
Cell[66036, 1965, 1704, 39, 44, "PaletteGridCell",
 CellGroupingRules->{"GroupTogetherNestedGrouping", 94}]
}, Closed]],
Cell[67755, 2007, 39, 14, 38, "Spacer"],
Cell[67797, 2023, 1284, 43, 15, "PaletteTabCell",
 CellTags->"TutorialsExternal"],
Cell[69084, 2068, 9263, 257, 221, "PaletteGridCell"],
Cell[78350, 2327, 35, 10, 26, "Spacer"],
Cell[CellGroupData[{
Cell[78410, 2341, 442, 12, 22, "ButtonGroupHead",
 CellGroupingRules->{"GroupTogetherNestedGrouping", 96}],
Cell[CellGroupData[{
Cell[78877, 2357, 76, 1, 2, "Spacer",
 CellGroupingRules->{"GroupTogetherNestedGrouping", 97}],
Cell[78956, 2360, 76, 1, 2, "Spacer",
 CellGroupingRules->{"GroupTogetherNestedGrouping", 97}],
Cell[79035, 2363, 5466, 149, 116, "PaletteGridCell",
 CellGroupingRules->{"GroupTogetherNestedGrouping", 99}],
Cell[84504, 2514, 76, 1, 2, "Spacer",
 CellGroupingRules->{"GroupTogetherNestedGrouping", 97}],
Cell[CellGroupData[{
Cell[84605, 2519, 497, 13, 21, "ButtonSubGroupHead",
 CellGroupingRules->{"GroupTogetherNestedGrouping", 98}],
Cell[85105, 2534, 76, 1, 70, "Spacer",
 CellGroupingRules->{"GroupTogetherNestedGrouping", 98}],
Cell[85184, 2537, 76, 1, 70, "Spacer",
 CellGroupingRules->{"GroupTogetherNestedGrouping", 98}],
Cell[85263, 2540, 4566, 114, 70, "PaletteGridCell",
 CellGroupingRules->{"GroupTogetherNestedGrouping", 98}]
}, Closed]]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[89890, 2661, 450, 12, 20, "ButtonGroupHead",
 CellGroupingRules->{"GroupTogetherNestedGrouping", 95}],
Cell[CellGroupData[{
Cell[90365, 2677, 76, 1, 2, "Spacer",
 CellGroupingRules->{"GroupTogetherNestedGrouping", 96}],
Cell[90444, 2680, 76, 1, 2, "Spacer",
 CellGroupingRules->{"GroupTogetherNestedGrouping", 96}],
Cell[90523, 2683, 6256, 185, 235, "PaletteGridCell",
 CellGroupingRules->{"GroupTogetherNestedGrouping", 96}]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[96828, 2874, 455, 12, 20, "ButtonGroupHead",
 CellGroupingRules->{"GroupTogetherNestedGrouping", 94}],
Cell[CellGroupData[{
Cell[97308, 2890, 76, 1, 2, "Spacer",
 CellGroupingRules->{"GroupTogetherNestedGrouping", 95}],
Cell[97387, 2893, 76, 1, 2, "Spacer",
 CellGroupingRules->{"GroupTogetherNestedGrouping", 95}],
Cell[CellGroupData[{
Cell[97488, 2898, 2378, 73, 121, "PaletteGridCell",
 CellGroupingRules->{"GroupTogetherNestedGrouping", 400}],
Cell[99869, 2973, 77, 1, 2, "Spacer",
 CellGroupingRules->{"GroupTogetherNestedGrouping", 400}],
Cell[CellGroupData[{
Cell[99971, 2978, 465, 13, 21, "ButtonSubGroupHead",
 CellGroupingRules->{"GroupTogetherNestedGrouping", 401}],
Cell[100439, 2993, 77, 1, 2, "Spacer",
 CellGroupingRules->{"GroupTogetherNestedGrouping", 401}],
Cell[100519, 2996, 77, 1, 2, "Spacer",
 CellGroupingRules->{"GroupTogetherNestedGrouping", 401}],
Cell[100599, 2999, 1943, 57, 56, "PaletteGridCell",
 CellGroupingRules->{"GroupTogetherNestedGrouping", 401}]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[102615, 3064, 446, 12, 20, "ButtonGroupHead",
 CellGroupingRules->{"GroupTogetherNestedGrouping", 93}],
Cell[CellGroupData[{
Cell[103086, 3080, 76, 1, 2, "Spacer",
 CellGroupingRules->{"GroupTogetherNestedGrouping", 94}],
Cell[103165, 3083, 76, 1, 2, "Spacer",
 CellGroupingRules->{"GroupTogetherNestedGrouping", 94}]
}, Open  ]],
Cell[103256, 3087, 3676, 93, 105, "PaletteGridCell",
 CellGroupingRules->{"GroupTogetherNestedGrouping", 93}]
}, Closed]],
Cell[106947, 3183, 39, 14, 38, "Spacer"]
}
]
*)

(* End of internal cache information *)

