(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     59125,       2072]
NotebookOptionsPosition[     46480,       1622]
NotebookOutlinePosition[     51098,       1761]
CellTagsIndexPosition[     51055,       1758]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[TextData[{
 "New in: ",
 Cell["1", "HistoryData",
  CellTags->"New"],
 " | Modified in: ",
 Cell[" ", "HistoryData",
  CellTags->"Modified"],
 " | Obsolete in: ",
 Cell[" ", "HistoryData",
  CellTags->"Obsolete"],
 " | Excised in: ",
 Cell[" ", "HistoryData",
  CellTags->"Excised"]
}], "History",
 CellChangeTimes->{3.410894606249012*^9},
 CellID->6298],

Cell[CellGroupData[{

Cell["Categorization", "CategorizationSection",
 CellLabel->
  "Categorization: metadata such as page URI, context, and type of \
documentation page",
 CellID->1122911449],

Cell["Tutorial", "Categorization",
 CellLabel->"Entity Type",
 CellID->686433507],

Cell["NumericalAnalysis", "Categorization",
 CellChangeTimes->{{3.410888631979097*^9, 3.4108886398616886`*^9}, {
  3.4108896172604647`*^9, 3.41088961873242*^9}},
 CellLabel->"Paclet Name",
 CellID->605800465],

Cell["NumericalAnalysis`", "Categorization",
 CellChangeTimes->{{3.410888643096857*^9, 3.4108886502482805`*^9}},
 CellLabel->"Context",
 CellID->468444828],

Cell["NumericalAnalysis/tutorial/NumericalAnalysis", "Categorization",
 CellChangeTimes->{{3.410888656057561*^9, 3.410888667776281*^9}, {
  3.410889114121377*^9, 3.410889140194822*^9}},
 CellLabel->"URI",
 CellID->31593272]
}, Closed]],

Cell[CellGroupData[{

Cell["Keywords", "KeywordsSection",
 CellLabel->
  "Keywords: contains a list of words or phrases to be used as keywords for \
this page when indexing",
 CellID->1427428552],

Cell["XXXX", "Keywords",
 CellID->1251852827]
}, Closed]],

Cell[CellGroupData[{

Cell["Details", "DetailsSection",
 CellLabel->
  "Details: metadata on developer(s) for the functionality described on this \
page, along with any general comments about the page",
 CellID->344402025],

Cell["XXXX", "Details",
 CellLabel->"Developers"],

Cell["XXXX", "Details",
 CellLabel->"Comments"]
}, Closed]],

Cell[CellGroupData[{

Cell["Numerical Calculus Package", "Title",
 CellChangeTimes->{{3.3703737277355022`*^9, 3.370373730760312*^9}},
 CellLabel->"The page title",
 CellID->509267359],

Cell[TextData[{
 "The functions defined in the ",
 Cell[BoxData["NumericalAnalysis`"], "InlineFormula"],
 " context provide support for finding numerical solutions to \
calculus-related problems."
}], "Text",
 CellChangeTimes->{{3.37037403234172*^9, 3.37037409038132*^9}, {
  3.370374124997839*^9, 3.370374145895282*^9}, {3.3703741768275433`*^9, 
  3.370374200249484*^9}, {3.370374237820455*^9, 3.3703742862092257`*^9}, {
  3.37037439746717*^9, 3.3703744514220657`*^9}, {3.3703744870521812`*^9, 
  3.3703745205839233`*^9}, {3.3703746567421103`*^9, 3.3703746611861277`*^9}, {
  3.370374771466187*^9, 3.370374807057295*^9}, {3.370374840689292*^9, 
  3.370374840756846*^9}, {3.370374936611534*^9, 3.370374937681251*^9}},
 CellLabel->
  "A paragraph describing overall functionality of the package, goals, etc.",
 CellID->1534169418],

Cell[CellGroupData[{

Cell["This loads the package:", "MathCaption",
 CellChangeTimes->{{3.3703745915818357`*^9, 3.37037459387849*^9}},
 CellID->1825449234],

Cell[BoxData[
 RowBox[{"<<", "NumericalAnalysis`"}]], "Input",
 CellChangeTimes->{{3.3703745980265493`*^9, 3.370374602095455*^9}},
 CellLabel->"In[1]:=",
 CellID->1373894796]
}, Open  ]],

Cell[CellGroupData[{

Cell["Numerical Calculation of Limits", "Section",
 CellChangeTimes->{{3.3702661238247538`*^9, 3.370266130890768*^9}, 
   3.371301959371707*^9, {3.3751044240283327`*^9, 3.375104428916211*^9}},
 CellLabel->
  "Tutorials are typically broken down into sections using headers like this",
 CellID->2591],

Cell[TextData[{
 "The built\[Hyphen]in function ",
 Cell[BoxData[
  ButtonBox["Limit",
   BaseStyle->"Link"]], "InlineFormula"],
 " computes limits using symbolic and analytic methods. The function ",
 Cell[BoxData[
  ButtonBox["NLimit",
   BaseStyle->"Link",
   ButtonData->"paclet:NumericalAnalysis/ref/NLimit"]], "InlineFormula"],
 " contained in the ",
 Cell[BoxData[
  ButtonBox["NumericalAnalysis",
   BaseStyle->"Link",
   ButtonData->"paclet:NumericalAnalysis/guide/NumericalCalculusPackage"]], 
  "InlineFormula"],
 " package works by numerically evaluating a short sequence of function \
values as the argument approaches the specified point. The result of this \
calculation is passed to a routine that uses either Wynn\[CloseCurlyQuote]s ",
 Cell[BoxData[
  FormBox["\[Epsilon]", TraditionalForm]], "InlineFormula"],
 "\[Hyphen]algorithm or a generalized Euler transformation to find an \
approximation to the limit. "
}], "Text",
 CellChangeTimes->{{3.370266383267888*^9, 3.370266396180509*^9}, {
  3.371302130018546*^9, 3.37130215414326*^9}, {3.3752017953356285`*^9, 
  3.3752017953356285`*^9}},
 CellLabel->"Each section can be introduced by a descriptive paragraph",
 CellID->16706],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["NLimit",
      BaseStyle->"Link",
      ButtonData->"paclet:NumericalAnalysis/ref/NLimit"], "[", 
     StyleBox["expr", "TI"], ",", 
     StyleBox["x", "TI"], "->", 
     SubscriptBox[
      StyleBox["x", "TI"], "0"], "]"}], Cell[TextData[{
     "numerically find the limit as ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     " approaches ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["x", "TI"], "0"]], "InlineFormula"]
    }], "TableText"]}
  }]], "DefinitionBox",
 CellChangeTimes->{{3.37130212252412*^9, 3.37130212267759*^9}},
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
   "RowsIndexed" -> {}}},
 CellLabel->
  "Two-column Definition Boxes typically appear in tutorials to describe the \
functionality and usage of one or more symbols",
 CellID->19362],

Cell["Computing numerical limits.", "Caption",
 CellLabel->"Each definition box should have a caption",
 CellID->19031],

Cell[CellGroupData[{

Cell["Here is the numerical computation of a limit. ", "MathCaption",
 CellLabel->
  "Examples are necessary for a useful tutorial. This is the caption for an \
example, with the example evaluated below.",
 CellID->6421],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NLimit", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Zeta", "[", "s", "]"}], "-", 
    FractionBox["1", 
     RowBox[{"s", "-", "1"}]]}], ",", 
   RowBox[{"s", "\[Rule]", "1"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->27111],

Cell[BoxData["0.577215659712782`"], "Output",
 CellChangeTimes->{3.3517256300625*^9},
 CellLabel->"Out[2]=",
 CellID->191037609]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
The limit gives the number known as Euler\[CloseCurlyQuote]s gamma. \
\>", "MathCaption",
 CellID->7348],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", "EulerGamma", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->3464],

Cell[BoxData["0.5772156649015329`"], "Output",
 CellChangeTimes->{3.351725630125*^9},
 CellLabel->"Out[3]=",
 CellID->498198997]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "You can also compute limits as ",
 Cell[BoxData[
  FormBox[
   StyleBox["x", "TI"], TraditionalForm]], "InlineFormula"],
 " approaches infinity. "
}], "MathCaption",
 CellID->25569],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NLimit", "[", 
  RowBox[{
   FractionBox[
    RowBox[{
     RowBox[{"2", " ", 
      SuperscriptBox["x", "3"]}], "+", 
     RowBox[{"Sin", "[", "x", "]"}]}], 
    RowBox[{
     RowBox[{"5", " ", 
      SuperscriptBox["x", "3"]}], "+", 
     RowBox[{"Log", "[", "x", "]"}]}]], ",", 
   RowBox[{"x", "\[Rule]", "\[Infinity]"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->2989],

Cell[BoxData["0.3999999999999999`"], "Output",
 CellChangeTimes->{3.35172563020313*^9},
 CellLabel->"Out[4]=",
 CellID->654426462]
}, Open  ]]
}, Open  ]],

Cell[BoxData[GridBox[{
   {Cell["option name", "TableHeader"], Cell["default value", "TableHeader"], 
    " "},
   {
    ButtonBox["WorkingPrecision",
     BaseStyle->"Link"], 
    ButtonBox["MachinePrecision",
     BaseStyle->"Link"], Cell[
    "number of digits of precision to be used ", "TableText"]},
   {
    ButtonBox["Scale",
     BaseStyle->"Link",
     ButtonData->"paclet:NumericalAnalysis/ref/Scale"], "1", Cell[
    "initial step size ", "TableText"]},
   {
    ButtonBox["Terms",
     BaseStyle->"Link",
     ButtonData->"paclet:NumericalAnalysis/ref/Terms"], "7", Cell[
    "total number of terms generated in the sequence ", "TableText"]},
   {
    ButtonBox["Method",
     BaseStyle->"Link"], 
    ButtonBox["EulerSum",
     BaseStyle->"Link",
     ButtonData->"paclet:NumericalAnalysis/ref/EulerSum"], Cell[TextData[{
     "method of evaluation, either ",
     StyleBox[ButtonBox["EulerSum",
      BaseStyle->"Link",
      ButtonData->"paclet:NumericalAnalysis/ref/EulerSum"], "InlineCode"],
     " or SequenceLimit "
    }], "TableText"]},
   {"WynnDegree", "1", Cell["degree to use in the Wynn method", "TableText"]}
  }]], "DefinitionBox3Col",
 CellChangeTimes->{3.381326327103237*^9, 3.3853088702752132`*^9},
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, True, {False}, False}, "RowsIndexed" -> {}}},
 CellLabel->
  "Three-column Definition Boxes typically appear in tutorials to list \
options, their default values, and a description of each",
 CellID->2017],

Cell[TextData[{
 "Options for ",
 Cell[BoxData[
  ButtonBox["NLimit",
   BaseStyle->"Link",
   ButtonData->"paclet:NumericalAnalysis/ref/NLimit"]], "InlineFormula"],
 "."
}], "Caption",
 CellID->21763],

Cell[TextData[{
 "There are many specialized techniques for accelerating the convergence of a \
series. Faster convergence means that in a numerical evaluation fewer terms \
are needed to give a result of the desired accuracy. One such technique, \
Euler\[CloseCurlyQuote]s transformation, is used by ",
 Cell[BoxData[
  ButtonBox["EulerSum",
   BaseStyle->"Link",
   ButtonData->"paclet:NumericalAnalysis/ref/EulerSum"]], "InlineFormula"],
 ". "
}], "Text",
 CellChangeTimes->{{3.371302109903091*^9, 3.371302110013589*^9}},
 CellID->17753],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["EulerSum",
   BaseStyle->"Link",
   ButtonData->"paclet:NumericalAnalysis/ref/EulerSum"]], "InlineFormula"],
 " is particularly good for working with alternating series and series whose \
terms have the form ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["p", "TI"], 
    RowBox[{"(", 
     StyleBox["n", "TI"], ")"}], 
    SuperscriptBox[
     StyleBox["r", "TI"], 
     StyleBox["n", "TI"]]}], TraditionalForm]], "InlineFormula"],
 " where ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["p", "TI"], 
    RowBox[{"(", 
     StyleBox["n", "TI"], ")"}]}], TraditionalForm]], "InlineFormula"],
 " is a polynomial in ",
 Cell[BoxData[
  FormBox[
   StyleBox["n", "TI"], TraditionalForm]], "InlineFormula"],
 ". It is a useful adjunct to the built\[Hyphen]in ",
 Cell[BoxData[
  ButtonBox["NSum",
   BaseStyle->"Link"]], "InlineFormula"],
 ", which is designed to be an effective general case algorithm. "
}], "Text",
 CellID->27158],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["EulerSum",
      BaseStyle->"Link",
      ButtonData->"paclet:NumericalAnalysis/ref/EulerSum"], "[", 
     StyleBox["f", "TI"], ",", "{", 
     StyleBox["i", "TI"], ",", 
     StyleBox["imin", "TI"], ",", 
     ButtonBox["Infinity",
      BaseStyle->"Link"], "}", "]"}], Cell[TextData[{
     "use Euler\[CloseCurlyQuote]s transformation to numerically evaluate ",
     Cell[BoxData[
      RowBox[{
       UnderoverscriptBox["\[Sum]", 
        StyleBox["imin", "TI"], "\[Infinity]",
        LimitsPositioning->True], " ", 
       StyleBox["f", "TI"]}]], "InlineFormula"],
     " "
    }], "TableText"]}
  }]], "DefinitionBox",
 CellChangeTimes->{{3.37130209733302*^9, 3.37130209746881*^9}},
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
   "RowsIndexed" -> {}}},
 CellID->25550],

Cell["\<\
Numerical evaluation of sums using Euler\[CloseCurlyQuote]s transformation. \
\>", "Caption",
 CellID->9037],

Cell[BoxData[GridBox[{
   {Cell["option name", "TableHeader"], Cell["default value", "TableHeader"], 
    " "},
   {
    ButtonBox["WorkingPrecision",
     BaseStyle->"Link"], 
    ButtonBox["MachinePrecision",
     BaseStyle->"Link"], Cell[
    "number of digits of precision to be used ", "TableText"]},
   {
    ButtonBox["Terms",
     BaseStyle->"Link",
     ButtonData->"paclet:NumericalAnalysis/ref/Terms"], "5", Cell[
    "total number of terms generated before extrapolation ", "TableText"]},
   {
    ButtonBox["ExtraTerms",
     BaseStyle->"Link",
     ButtonData->"paclet:NumericalAnalysis/ref/ExtraTerms"], "7", Cell["\<\
number of terms to be used in the extrapolation process; must be at least 2\
\>", "TableText"]},
   {
    ButtonBox["EulerRatio",
     BaseStyle->"Link",
     ButtonData->"paclet:NumericalAnalysis/ref/EulerRatio"], 
    ButtonBox["Automatic",
     BaseStyle->"Link"], Cell[
    "the fixed ratio to be used in the transformation ", "TableText"]}
  }]], "DefinitionBox3Col",
 CellChangeTimes->{3.3813263320582747`*^9},
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, True, {False}, False}, "RowsIndexed" -> {}}},
 CellID->29072],

Cell[TextData[{
 "Options for ",
 Cell[BoxData[
  ButtonBox["EulerSum",
   BaseStyle->"Link",
   ButtonData->"paclet:NumericalAnalysis/ref/EulerSum"]], "InlineFormula"],
 "."
}], "Caption",
 CellID->26739],

Cell[CellGroupData[{

Cell[TextData[{
 "This uses ",
 Cell[BoxData[
  ButtonBox["EulerSum",
   BaseStyle->"Link",
   ButtonData->"paclet:NumericalAnalysis/ref/EulerSum"]], "InlineFormula"],
 " to compute a numerical approximation to the sum of an alternating series. "
}], "MathCaption",
 CellID->1781],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"EulerSum", "[", 
  RowBox[{
   FractionBox[
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"-", "1"}], ")"}], "k"], 
    RowBox[{
     RowBox[{"2", " ", "k"}], "+", "1"}]], ",", 
   RowBox[{"{", 
    RowBox[{"k", ",", "0", ",", "\[Infinity]"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->26975],

Cell[BoxData["0.7853983570594825`"], "Output",
 CellChangeTimes->{3.35172563028125*^9},
 CellLabel->"Out[5]=",
 CellID->705840830]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Increasing the precision and the number of terms does not change the answer \
in the first six decimal places. This provides a check on the accuracy of the \
numerically computed result. \
\>", "MathCaption",
 CellID->19289],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"EulerSum", "[", 
  RowBox[{
   FractionBox[
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"-", "1"}], ")"}], "k"], 
    RowBox[{
     RowBox[{"2", " ", "k"}], "+", "1"}]], ",", 
   RowBox[{"{", 
    RowBox[{"k", ",", "0", ",", "\[Infinity]"}], "}"}], ",", 
   RowBox[{"WorkingPrecision", "\[Rule]", "40"}], ",", 
   RowBox[{"Terms", "\[Rule]", "30"}], ",", 
   RowBox[{"ExtraTerms", "\[Rule]", "30"}]}], "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->7358],

Cell[BoxData["0.7853981633974483096156608457913032254024560638073841639228`39.\
14491374808192"], "Output",
 CellChangeTimes->{3.351725630375*^9},
 CellLabel->"Out[6]=",
 CellID->230069580]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
The result is also in good agreement with the known exact result. \
\>", "MathCaption",
 CellID->27254],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "-", 
  RowBox[{"N", "[", 
   RowBox[{
    FractionBox["\[Pi]", "4"], ",", "40"}], "]"}]}]], "Input",
 CellLabel->"In[7]:=",
 CellID->23509],

Cell[BoxData[
 RowBox[{"-", 
  "2.85724956468362860363922913235`10.649016130894474*^-29"}]], "Output",
 CellChangeTimes->{3.35172563045313*^9},
 CellLabel->"Out[7]=",
 CellID->211871406]
}, Open  ]]
}, Open  ]],

Cell[TextData[{
 "There are occasionally instances in which it is difficult or impossible to \
analytically compute the derivative of a function. In these cases you can \
compute the derivative using the function ",
 Cell[BoxData[
  ButtonBox["ND",
   BaseStyle->"Link",
   ButtonData->"paclet:NumericalAnalysis/ref/ND"]], "InlineFormula"],
 " instead of the built\[Hyphen]in function ",
 Cell[BoxData[
  ButtonBox["D",
   BaseStyle->"Link"]], "InlineFormula"],
 ". "
}], "Text",
 CellID->26307],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["ND",
      BaseStyle->"Link",
      ButtonData->"paclet:NumericalAnalysis/ref/ND"], "[", 
     StyleBox["f", "TI"], ",", 
     StyleBox["x", "TI"], ",", 
     SubscriptBox[
      StyleBox["x", "TI"], "0"], "]"}], Cell[TextData[{
     "give a numerical approximation to ",
     Cell[BoxData[
      FractionBox[
       RowBox[{"\[PartialD]", 
        StyleBox["f", "TI"]}], 
       RowBox[{"\[PartialD]", 
        StyleBox["x", "TI"]}]]], "InlineFormula"],
     " evaluated at the point\[NonBreakingSpace]",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["x", "TI"], "0"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["ND",
      BaseStyle->"Link",
      ButtonData->"paclet:NumericalAnalysis/ref/ND"], "[", 
     StyleBox["f", "TI"], ",", "{", 
     StyleBox["x", "TI"], ",", 
     StyleBox["n", "TI"], "}", ",", 
     SubscriptBox[
      StyleBox["x", "TI"], "0"], "]"}], Cell[TextData[{
     "give the ",
     Cell[BoxData[
      SuperscriptBox[
       StyleBox["n", "TI"], "th"]], "InlineFormula"],
     " derivative"
    }], "TableText"]}
  }]], "DefinitionBox",
 CellChangeTimes->{{3.37130208309307*^9, 3.37130208658474*^9}},
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
   "RowsIndexed" -> {}}},
 CellID->6442],

Cell["Numerical computation of derivatives. ", "Caption",
 CellID->27758],

Cell[CellGroupData[{

Cell[TextData[{
 "Here is a numerical approximation of the derivative of ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox[
    StyleBox["e", "TI"], 
    RowBox[{"sin", 
     RowBox[{"(", 
      StyleBox["x", "TI"], ")"}]}]], TraditionalForm]], "InlineFormula"],
 " at ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["x", "TI"], "=", "2"}], TraditionalForm]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->6249],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ND", "[", 
  RowBox[{
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{"Sin", "[", "x", "]"}]], ",", "x", ",", "2"}], "]"}]], "Input",
 CellLabel->"In[8]:=",
 CellID->13196],

Cell[BoxData[
 RowBox[{"-", "1.0331168751058337`"}]], "Output",
 CellChangeTimes->{3.35172563051563*^9},
 CellLabel->"Out[8]=",
 CellID->143307490]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "After increasing the setting of the option ",
 Cell[BoxData[
  ButtonBox["Terms",
   BaseStyle->"Link",
   ButtonData->"paclet:NumericalAnalysis/ref/Terms"]], "InlineFormula"],
 ", the difference between the symbolically computed result and the numerical \
result for a third derivative is quite small. "
}], "MathCaption",
 CellID->29449],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"ND", "[", 
   RowBox[{
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{"Sin", "[", "x", "]"}]], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "3"}], "}"}], ",", "2", ",", 
    RowBox[{"Terms", "\[Rule]", "10"}]}], "]"}], "-", 
  RowBox[{"N", "[", 
   RowBox[{
    RowBox[{
     SubscriptBox["\[PartialD]", 
      RowBox[{"{", 
       RowBox[{"x", ",", "3"}], "}"}]], 
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{"Sin", "[", "x", "]"}]]}], "/.", "\[InvisibleSpace]", 
    RowBox[{"x", "\[Rule]", "2"}]}], "]"}]}]], "Input",
 CellLabel->"In[9]:=",
 CellID->23083],

Cell[BoxData["2.239886525146062`*^-7"], "Output",
 CellChangeTimes->{3.35172563059375*^9},
 CellLabel->"Out[9]=",
 CellID->187596744]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
This is the error in the numerical derivative using Cauchy\[CloseCurlyQuote]s \
integral formula. \
\>", "MathCaption",
 CellID->15204],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"ND", "[", 
   RowBox[{
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{"Sin", "[", "x", "]"}]], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "3"}], "}"}], ",", "2", ",", 
    RowBox[{"Method", "\[Rule]", "NIntegrate"}]}], "]"}], "-", 
  RowBox[{"N", "[", 
   RowBox[{
    RowBox[{
     SubscriptBox["\[PartialD]", 
      RowBox[{"{", 
       RowBox[{"x", ",", "3"}], "}"}]], 
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{"Sin", "[", "x", "]"}]]}], "/.", "\[InvisibleSpace]", 
    RowBox[{"x", "\[Rule]", "2"}]}], "]"}]}]], "Input",
 CellLabel->"In[10]:=",
 CellID->31242],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "1.3500311979441904`*^-13"}], "+", 
  RowBox[{"1.790234627208065`*^-15", " ", "\[ImaginaryI]"}]}]], "Output",
 CellChangeTimes->{3.35172563079688*^9},
 CellLabel->"Out[10]=",
 CellID->556571991]
}, Open  ]]
}, Open  ]],

Cell[BoxData[GridBox[{
   {Cell["option name", "TableHeader"], Cell["default value", "TableHeader"], 
    " "},
   {
    ButtonBox["WorkingPrecision",
     BaseStyle->"Link"], 
    ButtonBox["MachinePrecision",
     BaseStyle->"Link"], Cell[
    "number of digits of precision to be used", "TableText"]},
   {
    ButtonBox["Scale",
     BaseStyle->"Link",
     ButtonData->"paclet:NumericalAnalysis/ref/Scale"], "1", Cell[
    "size of steps in the evaluation ", "TableText"]},
   {
    ButtonBox["Terms",
     BaseStyle->"Link",
     ButtonData->"paclet:NumericalAnalysis/ref/Terms"], "7", Cell[
    "total number of terms generated in the sequence ", "TableText"]},
   {
    ButtonBox["Method",
     BaseStyle->"Link"], 
    ButtonBox["EulerSum",
     BaseStyle->"Link",
     ButtonData->"paclet:NumericalAnalysis/ref/EulerSum"], Cell[TextData[{
     "method of evaluation, either ",
     StyleBox[ButtonBox["EulerSum",
      BaseStyle->"Link",
      ButtonData->"paclet:NumericalAnalysis/ref/EulerSum"], "InlineCode"],
     " (numerical limit of difference quotients) or ",
     StyleBox[ButtonBox["NIntegrate",
      BaseStyle->"Link"], "InlineCode"],
     " (Cauchy\[CloseCurlyQuote]s integral formula) "
    }], "TableText"]}
  }]], "DefinitionBox3Col",
 CellChangeTimes->{3.3813263377502966`*^9},
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, True, {False}, False}, "RowsIndexed" -> {}}},
 CellID->5317],

Cell[TextData[{
 "Options for ",
 Cell[BoxData[
  ButtonBox["ND",
   BaseStyle->"Link",
   ButtonData->"paclet:NumericalAnalysis/ref/ND"]], "InlineFormula"],
 "."
}], "Caption",
 CellID->32656],

Cell[TextData[{
 "You should realize that with sufficiently pathological examples, the \
algorithms used for ",
 Cell[BoxData[
  ButtonBox["EulerSum",
   BaseStyle->"Link",
   ButtonData->"paclet:NumericalAnalysis/ref/EulerSum"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["NLimit",
   BaseStyle->"Link",
   ButtonData->"paclet:NumericalAnalysis/ref/NLimit"]], "InlineFormula"],
 ", or ",
 Cell[BoxData[
  ButtonBox["ND",
   BaseStyle->"Link",
   ButtonData->"paclet:NumericalAnalysis/ref/ND"]], "InlineFormula"],
 " can give wrong answers. In most cases, you can test your answer by looking \
at the sensitivity to changes in the setting of options. "
}], "Text",
 CellChangeTimes->{{3.371302060147728*^9, 3.3713020678100157`*^9}},
 CellID->11452]
}, Open  ]],

Cell[CellGroupData[{

Cell["Numerical Calculation of Residues", "Section",
 CellChangeTimes->{{3.370266424261531*^9, 3.370266427710905*^9}, 
   3.371301971380026*^9, {3.375104442750279*^9, 3.375104448600815*^9}},
 CellID->30767],

Cell[TextData[{
 "The ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " function ",
 Cell[BoxData[
  ButtonBox["Residue",
   BaseStyle->"Link"]], "InlineFormula"],
 " symbolically finds the residue of an expression at a point in the complex \
plane. Because it is symbolic in nature it is sometimes unable to get a \
result. "
}], "Text",
 CellChangeTimes->{3.36346208289706*^9},
 CellID->3951],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["NResidue",
   BaseStyle->"Link",
   ButtonData->"paclet:NumericalAnalysis/ref/NResidue"]], "InlineFormula"],
 " is the numerical version of ",
 Cell[BoxData[
  ButtonBox["Residue",
   BaseStyle->"Link"]], "InlineFormula"],
 ". It works by numerically integrating around a small circle centered at the \
point at which the residue is being sought. The obvious problem with this \
approach is that it in fact finds the sum of the residues at all of the \
points contained within the circle. By making the radius of the circle \
sufficiently small you can exclude all singularities but the one in question. "
}], "Text",
 CellChangeTimes->{{3.371302052671845*^9, 3.371302052953608*^9}},
 CellID->16117],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["NResidue",
      BaseStyle->"Link",
      ButtonData->"paclet:NumericalAnalysis/ref/NResidue"], "[", 
     StyleBox["expr", "TI"], ",", "{", 
     StyleBox["x", "TI"], ",", 
     SubscriptBox[
      StyleBox["x", "TI"], "0"], "}", "]"}], Cell[TextData[{
     "numerically find the residue of ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " at the point ",
     Cell[BoxData[
      RowBox[{
       StyleBox["x", "TI"], "="}]], "InlineFormula"],
     " ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["x", "TI"], "0"]], "InlineFormula"],
     " "
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
   "RowsIndexed" -> {}}},
 CellID->8707],

Cell["Numerical evaluation of residues. ", "Caption",
 CellID->28587],

Cell[BoxData[GridBox[{
   {
    ButtonBox["Radius",
     BaseStyle->"Link",
     ButtonData->"paclet:NumericalAnalysis/ref/Radius"], Cell["\<\
specifies the radius of the circle around which the integration is performed \
\>", "TableText"]},
   {
    ButtonBox["PrecisionGoal",
     BaseStyle->"Link"], Cell[TextData[{
     "the ",
     StyleBox[ButtonBox["PrecisionGoal",
      BaseStyle->"Link"], "InlineCode"],
     " to be used by ",
     StyleBox[ButtonBox["NIntegrate",
      BaseStyle->"Link"], "InlineCode"],
     " "
    }], "TableText"]},
   {
    ButtonBox["WorkingPrecision",
     BaseStyle->"Link"], Cell[TextData[{
     "the ",
     StyleBox[ButtonBox["WorkingPrecision",
      BaseStyle->"Link"], "InlineCode"],
     " to be used by ",
     StyleBox[ButtonBox["NIntegrate",
      BaseStyle->"Link"], "InlineCode"],
     " "
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
   "RowsIndexed" -> {}}},
 CellID->32556],

Cell[TextData[{
 "Options for ",
 Cell[BoxData[
  ButtonBox["NResidue",
   BaseStyle->"Link",
   ButtonData->"paclet:NumericalAnalysis/ref/NResidue"]], "InlineFormula"],
 ". "
}], "Caption",
 CellID->4207],

Cell[CellGroupData[{

Cell[TextData[{
 "Find the residue of ",
 Cell[BoxData[
  FormBox[
   RowBox[{"1", "/", 
    StyleBox["z", "TI"]}], TraditionalForm]], "InlineFormula"],
 " at the origin. "
}], "MathCaption",
 CellID->16622],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NResidue", "[", 
  RowBox[{
   FractionBox["1", "z"], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", "0"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->16390],

Cell[BoxData["1.`"], "Output",
 CellChangeTimes->{3.351725754875*^9},
 CellLabel->"Out[2]=",
 CellID->7936742]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Define an expression whose residue you will find. ", "MathCaption",
 CellID->22729],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "=", 
  FractionBox["1", 
   RowBox[{"Expand", "[", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"z", "-", "1.7"}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{"z", "+", ".2", "+", 
       RowBox[{".5", " ", "\[ImaginaryI]"}]}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{"z", "+", ".2", "-", 
       RowBox[{".5", " ", "\[ImaginaryI]"}]}], ")"}]}], "]"}]]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->27477],

Cell[BoxData[
 RowBox[{"1", "/", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "0.493`"}], "-", 
      RowBox[{"7.209944447028604`*^-18", " ", "\[ImaginaryI]"}]}], ")"}], "-", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"0.39`", "\[InvisibleSpace]", "+", 
       RowBox[{"0.`", " ", "\[ImaginaryI]"}]}], ")"}], " ", "z"}], "-", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"1.3`", "\[InvisibleSpace]", "+", 
       RowBox[{"0.`", " ", "\[ImaginaryI]"}]}], ")"}], " ", 
     SuperscriptBox["z", "2"]}], "+", 
    SuperscriptBox["z", "3"]}], ")"}]}]], "Output",
 CellChangeTimes->{3.35172575495313*^9},
 CellLabel->"Out[3]=",
 CellID->264026320]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "Find the residue. Strictly speaking, ",
 StyleBox["f", "MR"],
 " has no singularity at ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["z", "TI"], "=", "1.7"}], TraditionalForm]], "InlineFormula"],
 ", but it has one very near to 1.7. "
}], "MathCaption",
 CellID->20455],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Residue", "[", 
  RowBox[{"f", ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", "1.7"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->20334],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{3.35172575521875*^9},
 CellLabel->"Out[4]=",
 CellID->998948]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Numerically find the residue. ", "MathCaption",
 CellID->23883],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NResidue", "[", 
  RowBox[{"f", ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", "1.7"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->19662],

Cell[BoxData[
 RowBox[{"0.2590673575129538`", "\[InvisibleSpace]", "-", 
  RowBox[{"3.296178321255481`*^-17", " ", "\[ImaginaryI]"}]}]], "Output",
 CellChangeTimes->{3.35172575542188*^9},
 CellLabel->"Out[5]=",
 CellID->174038953]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["This is another way to find the residue. ", "MathCaption",
 CellID->13284],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  FractionBox["1", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"z", "+", ".2", "+", 
      RowBox[{".5", " ", "\[ImaginaryI]"}]}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{"z", "+", ".2", "-", 
      RowBox[{".5", " ", "\[ImaginaryI]"}]}], ")"}]}]], "/.", 
  "\[InvisibleSpace]", 
  RowBox[{"z", "\[Rule]", "1.7"}]}]], "Input",
 CellLabel->"In[6]:=",
 CellID->29804],

Cell[BoxData[
 RowBox[{"0.25906735751295334`", "\[InvisibleSpace]", "+", 
  RowBox[{"0.`", " ", "\[ImaginaryI]"}]}]], "Output",
 CellChangeTimes->{3.35172575553125*^9},
 CellLabel->"Out[6]=",
 CellID->58319039]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Numerical Calculation of Series Expansions", "Section",
 CellChangeTimes->{{3.370266462551441*^9, 3.370266465749034*^9}, 
   3.371301977847693*^9, {3.375104457032721*^9, 3.375104466977242*^9}},
 CellID->32197],

Cell[TextData[{
 "The ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " function ",
 Cell[BoxData[
  ButtonBox["Series",
   BaseStyle->"Link"]], "InlineFormula"],
 " finds a power series expansion of a function about a point by evaluating \
derivatives. However, sometimes you only want a numerical approximation to a \
series and the derivatives are difficult to evaluate. You could use ",
 Cell[BoxData[
  ButtonBox["ND",
   BaseStyle->"Link",
   ButtonData->"paclet:NumericalAnalysis/ref/ND"]], "InlineFormula"],
 " to evaluate the derivatives, but that would involve repeating most of the \
work (",
 StyleBox["i.e.",
  FontSlant->"Italic"],
 ", evaluating the function itself at several points) for each derivative. If \
the function is analytic and can be evaluated in the complex plane, the \
solution is to use the ",
 Cell[BoxData[
  ButtonBox["NSeries",
   BaseStyle->"Link",
   ButtonData->"paclet:NumericalAnalysis/ref/NSeries"]], "InlineFormula"],
 ". "
}], "Text",
 CellChangeTimes->{{3.36346214646159*^9, 3.36346215752445*^9}, {
  3.371302008579761*^9, 3.3713020137087317`*^9}},
 CellID->19192],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["NSeries",
      BaseStyle->"Link",
      ButtonData->"paclet:NumericalAnalysis/ref/NSeries"], "[", 
     StyleBox["f", "TI"], ",", "{", 
     StyleBox["x", "TI"], ",", 
     SubscriptBox[
      StyleBox["x", "TI"], "0"], ",", 
     StyleBox["n", "TI"], "}", "]"}], Cell[TextData[{
     "give a numerical approximation to the series expansion of ",
     Cell[BoxData[
      StyleBox["f", "TI"]], "InlineFormula"],
     " about ",
     Cell[BoxData[
      RowBox[{
       StyleBox["x", "TI"], "=", 
       SubscriptBox[
        StyleBox["x", "TI"], "0"]}]], "InlineFormula"],
     " including the terms ",
     Cell[BoxData[
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         StyleBox["x", "TI"], "-", 
         SubscriptBox[
          StyleBox["x", "TI"], "0"]}], ")"}], 
       RowBox[{"-", 
        StyleBox["n", "TI"]}]]], "InlineFormula"],
     " through ",
     Cell[BoxData[
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         StyleBox["x", "TI"], "-", 
         SubscriptBox[
          StyleBox["x", "TI"], "0"]}], ")"}], 
       StyleBox["n", "TI"]]], "InlineFormula"],
     " "
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
   "RowsIndexed" -> {}}},
 CellID->19045],

Cell["Numerically finding series expansions. ", "Caption",
 CellID->7357],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["NSeries",
   BaseStyle->"Link",
   ButtonData->"paclet:NumericalAnalysis/ref/NSeries"]], "InlineFormula"],
 " works by evaluating the function at discrete points on a circle centered \
at the expansion point. It then uses ",
 Cell[BoxData[
  ButtonBox["InverseFourier",
   BaseStyle->"Link"]], "InlineFormula"],
 " to express the function as a sum of orthogonal basis functions, each of \
which is trivial to integrate around the circle. By Cauchy\[CloseCurlyQuote]s \
integral formula it is seen that ",
 Cell[BoxData[
  ButtonBox["InverseFourier",
   BaseStyle->"Link"]], "InlineFormula"],
 " essentially gives us the required series coefficients; very little \
additional work is required and ",
 Cell[BoxData[
  ButtonBox["NSeries",
   BaseStyle->"Link",
   ButtonData->"paclet:NumericalAnalysis/ref/NSeries"]], "InlineFormula"],
 " does it all for you. Because it is based on Cauchy\[CloseCurlyQuote]s \
integral formula, care should be taken to ensure that no singularities of the \
function occur inside the circle of sample points. "
}], "Text",
 CellChangeTimes->{{3.371302021619685*^9, 3.3713020310474997`*^9}},
 CellID->25290],

Cell[BoxData[GridBox[{
   {Cell["option name", "TableHeader"], Cell["default value", "TableHeader"], 
    " "},
   {
    ButtonBox["WorkingPrecision",
     BaseStyle->"Link"], 
    ButtonBox["MachinePrecision",
     BaseStyle->"Link"], Cell[
    "precision of the arithmetic to use in calculations ", "TableText"]},
   {
    ButtonBox["Radius",
     BaseStyle->"Link",
     ButtonData->"paclet:NumericalAnalysis/ref/Radius"], "1", Cell[
    "radius of the circle on which the function is sampled ", "TableText"]}
  }]], "DefinitionBox3Col",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, True, {False}, False}, "RowsIndexed" -> {}}},
 CellID->3225],

Cell[TextData[{
 "Options for ",
 Cell[BoxData[
  ButtonBox["NSeries",
   BaseStyle->"Link",
   ButtonData->"paclet:NumericalAnalysis/ref/NSeries"]], "InlineFormula"],
 "."
}], "Caption",
 CellID->16825],

Cell[CellGroupData[{

Cell[TextData[{
 "This gives an approximation to the series expansion of ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox[
    StyleBox["e", "TI"], 
    StyleBox["x", "TI"]], TraditionalForm]], "InlineFormula"],
 " about the origin. Note that ",
 Cell[BoxData[
  ButtonBox["NSeries",
   BaseStyle->"Link",
   ButtonData->"paclet:NumericalAnalysis/ref/NSeries"]], "InlineFormula"],
 " is unable to recognize small numbers that should in fact be zero. "
}], "MathCaption",
 CellID->26053],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NSeries", "[", 
  RowBox[{
   SuperscriptBox["\[ExponentialE]", "x"], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "3"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->19391],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   FractionBox[
    RowBox[{"1.605902378646316`*^-10", "+", 
     RowBox[{"9.357319639010834`*^-17", " ", "\[ImaginaryI]"}]}], 
    SuperscriptBox["x", "3"]], "+", 
   FractionBox[
    RowBox[{"1.1470626338827344`*^-11", "-", 
     RowBox[{"4.7362466919702726`*^-17", " ", "\[ImaginaryI]"}]}], 
    SuperscriptBox["x", "2"]], "+", 
   FractionBox[
    RowBox[{"7.647002927662619`*^-13", "-", 
     RowBox[{"6.792549346518558`*^-17", " ", "\[ImaginaryI]"}]}], "x"], "+", 
   RowBox[{"(", 
    RowBox[{"1.0000000000000477`", "\[InvisibleSpace]", "-", 
     RowBox[{"1.6266193360102852`*^-17", " ", "\[ImaginaryI]"}]}], ")"}], "+", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"1.0000000000000027`", "\[InvisibleSpace]", "-", 
      RowBox[{"1.7179883785287495`*^-16", " ", "\[ImaginaryI]"}]}], ")"}], 
    " ", "x"}], "+", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"0.5000000000000002`", "\[InvisibleSpace]", "-", 
      RowBox[{"9.770671717270932`*^-17", " ", "\[ImaginaryI]"}]}], ")"}], " ", 
    SuperscriptBox["x", "2"]}], "+", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"0.1666666666666667`", "\[InvisibleSpace]", "-", 
      RowBox[{"3.904336402970845`*^-17", " ", "\[ImaginaryI]"}]}], ")"}], " ", 
    SuperscriptBox["x", "3"]}], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], "4"],
    SeriesData[$CellContext`x, 0, {}, -3, 4, 1],
    Editable->False]}],
  SeriesData[$CellContext`x, 0, {
    Complex[1.60590237864632*^-10, 9.35731963901083*^-17], 
    Complex[1.14706263388273*^-11, -4.73624669197027*^-17], 
    Complex[7.64700292766262*^-13, -6.79254934651856*^-17], 
    Complex[1.00000000000005, -1.62661933601029*^-17], 
    Complex[1., -1.71798837852875*^-16], 
    Complex[0.5, -9.77067171727093*^-17], 
    Complex[0.166666666666667, -3.90433640297085*^-17]}, -3, 4, 1],
  Editable->False]], "Output",
 CellChangeTimes->{3.35172585282813*^9},
 CellLabel->"Out[2]=",
 CellID->342387]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Chop",
   BaseStyle->"Link"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Rationalize",
   BaseStyle->"Link"]], "InlineFormula"],
 " can often clean up the result. "
}], "MathCaption",
 CellID->27664],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Rationalize", "[", 
  RowBox[{"Chop", "[", "%", "]"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->6364],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   FractionBox["1.605902378646316`*^-10", 
    SuperscriptBox["x", "3"]], "+", "1", "+", "x", "+", 
   FractionBox[
    SuperscriptBox["x", "2"], "2"], "+", 
   FractionBox[
    SuperscriptBox["x", "3"], "6"], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], "4"],
    SeriesData[$CellContext`x, 0, {}, -3, 4, 1],
    Editable->False]}],
  SeriesData[$CellContext`x, 0, {1.60590237864632*^-10, 0, 0, 1, 1, 
    Rational[1, 2], 
    Rational[1, 6]}, -3, 4, 1],
  Editable->False]], "Output",
 CellChangeTimes->{3.35172585290625*^9},
 CellLabel->"Out[3]=",
 CellID->48540072]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["If the radius is too small, cancellation becomes a problem. ", \
"MathCaption",
 CellID->6827],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Rationalize", "[", 
  RowBox[{"Chop", "[", 
   RowBox[{"NSeries", "[", 
    RowBox[{
     SuperscriptBox["\[ExponentialE]", "x"], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", "5"}], "}"}], ",", 
     RowBox[{"Radius", "\[Rule]", 
      FractionBox["1", "8"]}]}], "]"}], "]"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->17078],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"1", "+", "x", "+", 
   FractionBox[
    SuperscriptBox["x", "2"], "2"], "+", 
   FractionBox[
    SuperscriptBox["x", "3"], "6"], "+", 
   RowBox[{"0.04166666666663863`", " ", 
    SuperscriptBox["x", "4"]}], "+", 
   RowBox[{"0.008333333333300637`", " ", 
    SuperscriptBox["x", "5"]}], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], "6"],
    SeriesData[$CellContext`x, 0, {}, 0, 6, 1],
    Editable->False]}],
  SeriesData[$CellContext`x, 0, {1, 1, 
    Rational[1, 2], 
    Rational[1, 6], 0.0416666666666386, 0.00833333333330064}, 0, 6, 1],
  Editable->False]], "Output",
 CellChangeTimes->{3.35172585301563*^9},
 CellLabel->"Out[4]=",
 CellID->688756]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "Increasing the ",
 Cell[BoxData[
  ButtonBox["WorkingPrecision",
   BaseStyle->"Link"]], "InlineFormula"],
 " will usually solve this problem. "
}], "MathCaption",
 CellID->6182],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Rationalize", "[", 
  RowBox[{"Chop", "[", 
   RowBox[{"NSeries", "[", 
    RowBox[{
     SuperscriptBox["\[ExponentialE]", "x"], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", "5"}], "}"}], ",", 
     RowBox[{"WorkingPrecision", "\[Rule]", "40"}], ",", 
     RowBox[{"Radius", "\[Rule]", 
      FractionBox["1", "8"]}]}], "]"}], "]"}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->25862],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"1", "+", "x", "+", 
   FractionBox[
    SuperscriptBox["x", "2"], "2"], "+", 
   FractionBox[
    SuperscriptBox["x", "3"], "6"], "+", 
   FractionBox[
    SuperscriptBox["x", "4"], "24"], "+", 
   FractionBox[
    SuperscriptBox["x", "5"], "120"], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], "6"],
    SeriesData[$CellContext`x, 0, {}, 0, 6, 1],
    Editable->False]}],
  SeriesData[$CellContext`x, 0, {1, 1, 
    Rational[1, 2], 
    Rational[1, 6], 
    Rational[1, 24], 
    Rational[1, 120]}, 0, 6, 1],
  Editable->False]], "Output",
 CellChangeTimes->{3.351725853125*^9},
 CellLabel->"Out[5]=",
 CellID->210061539]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
If the radius is too large, the sample points become too scattered and it \
starts looking like poles exist. \
\>", "MathCaption",
 CellID->20963],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Rationalize", "[", 
  RowBox[{"Chop", "[", 
   RowBox[{"NSeries", "[", 
    RowBox[{
     SuperscriptBox["\[ExponentialE]", "x"], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", "5"}], "}"}], ",", 
     RowBox[{"Radius", "\[Rule]", "4"}]}], "]"}], "]"}], "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->31555],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   FractionBox["1.6929016799505088`*^-9", 
    SuperscriptBox["x", "5"]], "+", "1", "+", "x", "+", 
   FractionBox[
    SuperscriptBox["x", "2"], "2"], "+", 
   FractionBox[
    SuperscriptBox["x", "3"], "6"], "+", 
   FractionBox[
    SuperscriptBox["x", "4"], "24"], "+", 
   FractionBox[
    SuperscriptBox["x", "5"], "120"], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], "6"],
    SeriesData[$CellContext`x, 0, {}, -5, 6, 1],
    Editable->False]}],
  SeriesData[$CellContext`x, 0, {1.69290167995051*^-9, 0, 0, 0, 0, 1, 1, 
    Rational[1, 2], 
    Rational[1, 6], 
    Rational[1, 24], 
    Rational[1, 120]}, -5, 6, 1],
  Editable->False]], "Output",
 CellChangeTimes->{3.35172585321875*^9},
 CellLabel->"Out[6]=",
 CellID->111197973]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["NSeries",
   BaseStyle->"Link",
   ButtonData->"paclet:NumericalAnalysis/ref/NSeries"]], "InlineFormula"],
 " also recognizes poles. "
}], "MathCaption",
 CellID->23438],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Chop", "[", 
  RowBox[{"NSeries", "[", 
   RowBox[{
    RowBox[{"Zeta", "[", "s", "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"s", ",", "1", ",", "5"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[7]:=",
 CellID->14136],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   FractionBox["1", 
    RowBox[{"s", "-", "1"}]], "+", "0.5772156649015326`", "+", 
   RowBox[{"0.07281584548367676`", " ", 
    RowBox[{"(", 
     RowBox[{"s", "-", "1"}], ")"}]}], "-", 
   RowBox[{"0.004845181596436386`", " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"s", "-", "1"}], ")"}], "2"]}], "-", 
   RowBox[{"0.00034230573671693886`", " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"s", "-", "1"}], ")"}], "3"]}], "+", 
   RowBox[{"0.00009689041939406385`", " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"s", "-", "1"}], ")"}], "4"]}], "-", 
   RowBox[{"6.611031810638576`*^-6", " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"s", "-", "1"}], ")"}], "5"]}], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", 
      RowBox[{"s", "-", "1"}], "]"}], "6"],
    SeriesData[$CellContext`s, 1, {}, -1, 6, 1],
    Editable->False]}],
  SeriesData[$CellContext`s, 1, {1., 0.577215664901533, 
   0.0728158454836768, -0.00484518159643639, -0.000342305736716939, 
   0.0000968904193940638, -6.61103181063858*^-6}, -1, 6, 1],
  Editable->False]], "Output",
 CellChangeTimes->{3.3517258533125*^9},
 CellLabel->"Out[7]=",
 CellID->634463235]
}, Open  ]]
}, Open  ]],

Cell["More About", "TutorialMoreAboutSection",
 CellLabel->"More About: links to related guide pages",
 CellID->113667996],

Cell["Related Tutorials", "RelatedTutorialsSection",
 CellLabel->"Related Tutorials: links to related tutorials",
 CellID->133707239],

Cell["Related Wolfram Education Group Courses", "TutorialRelatedLinksSection",
 CellLabel->
  "The Wolfram Education Group provides classes and seminars to educate and \
inform users about Mathematica.\nSome tutorials may link to relevent class \
web pages.",
 CellID->28437217]
}, Open  ]]
}, Open  ]]
},
WindowSize->{718, 734},
WindowMargins->{{-1, Automatic}, {Automatic, 0}},
FrontEndVersion->"7.0 for Microsoft Windows (32-bit) (February 18, 2009)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> 
     FrontEnd`FileName[{"Wolfram"}, "TutorialPageStyles.nb", 
       CharacterEncoding -> "WindowsANSI"]]], 
   Cell[
    CellGroupData[{
      Cell[
       StyleData["CategorizationSection"], 
       CellLabelMargins -> {{28, Inherited}, {Inherited, Inherited}}], 
      Cell[
       StyleData["CategorizationSection", "Printout"], 
       CellLabelMargins -> {{24, Inherited}, {Inherited, Inherited}}]}, 
     Closed]], 
   Cell[
    CellGroupData[{
      Cell[
       StyleData["KeywordsSection"], 
       CellLabelMargins -> {{28, Inherited}, {Inherited, Inherited}}], 
      Cell[
       StyleData["KeywordsSection", "Printout"], 
       CellLabelMargins -> {{24, Inherited}, {Inherited, Inherited}}]}, 
     Closed]], 
   Cell[
    CellGroupData[{
      Cell[
       StyleData["DetailsSection"], 
       CellLabelMargins -> {{28, Inherited}, {Inherited, Inherited}}], 
      Cell[
       StyleData["DetailsSection", "Printout"], 
       CellLabelMargins -> {{24, Inherited}, {Inherited, Inherited}}]}, 
     Closed]], 
   Cell[
    CellGroupData[{
      Cell[
       StyleData["Title"], 
       CellLabelMargins -> {{27, Inherited}, {Inherited, Inherited}}], 
      Cell[
       StyleData["Title", "Printout"], 
       CellLabelMargins -> {{2, Inherited}, {Inherited, Inherited}}]}, 
     Closed]], 
   Cell[
    CellGroupData[{
      Cell[
       StyleData["Section"], 
       CellLabelMargins -> {{27, Inherited}, {Inherited, Inherited}}], 
      Cell[
       StyleData["Section", "Printout"], 
       CellLabelMargins -> {{2, Inherited}, {Inherited, Inherited}}]}, 
     Closed]], 
   Cell[
    CellGroupData[{
      Cell[
       StyleData["Text"], 
       CellLabelMargins -> {{28, Inherited}, {Inherited, Inherited}}], 
      Cell[
       StyleData["Text", "Printout"], 
       CellLabelMargins -> {{2, Inherited}, {Inherited, Inherited}}]}, 
     Closed]], 
   Cell[
    CellGroupData[{
      Cell[
       StyleData["DefinitionBox"], 
       CellLabelMargins -> {{27, Inherited}, {Inherited, Inherited}}], 
      Cell[
       StyleData["DefinitionBox", "Printout"], 
       CellLabelMargins -> {{2, Inherited}, {Inherited, Inherited}}]}, 
     Closed]], 
   Cell[
    CellGroupData[{
      Cell[
       StyleData["DefinitionBox3Col"], 
       CellLabelMargins -> {{27, Inherited}, {Inherited, Inherited}}], 
      Cell[
       StyleData["DefinitionBox3Col", "Printout"], 
       CellLabelMargins -> {{2, Inherited}, {Inherited, Inherited}}]}, 
     Closed]], 
   Cell[
    CellGroupData[{
      Cell[
       StyleData["Caption"], 
       CellLabelMargins -> {{27, Inherited}, {Inherited, Inherited}}], 
      Cell[
       StyleData["Caption", "Printout"], 
       CellMargins -> {{3, Inherited}, {Inherited, Inherited}}, 
       CellLabelMargins -> {{2, Inherited}, {Inherited, Inherited}}]}, Open]], 
   Cell[
    CellGroupData[{
      Cell[
       StyleData["MathCaption"], 
       CellLabelMargins -> {{74, Inherited}, {Inherited, Inherited}}], 
      Cell[
       StyleData["MathCaption", "Printout"], 
       CellLabelMargins -> {{39, Inherited}, {Inherited, Inherited}}]}, 
     Closed]], 
   Cell[
    CellGroupData[{
      Cell[
       StyleData["TutorialMoreAboutSection"], 
       CellLabelMargins -> {{36, Inherited}, {Inherited, Inherited}}], 
      Cell[
       StyleData["TutorialMoreAboutSection", "Printout"], 
       CellLabelMargins -> {{24, Inherited}, {Inherited, Inherited}}]}, 
     Closed]], 
   Cell[
    CellGroupData[{
      Cell[
       StyleData["RelatedTutorialsSection"], 
       CellLabelMargins -> {{36, Inherited}, {Inherited, Inherited}}], 
      Cell[
       StyleData["RelatedTutorialsSection", "Printout"], 
       CellLabelMargins -> {{24, Inherited}, {Inherited, Inherited}}]}, 
     Closed]], 
   Cell[
    CellGroupData[{
      Cell[
       StyleData["TutorialRelatedLinksSection"], 
       CellLabelMargins -> {{36, Inherited}, {Inherited, Inherited}}], 
      Cell[
       StyleData["TutorialRelatedLinksSection", "Printout"], 
       CellLabelMargins -> {{24, Inherited}, {Inherited, Inherited}}]}, 
     Closed]]}, Visible -> False, FrontEndVersion -> 
  "7.0 for Microsoft Windows (32-bit) (February 18, 2009)", StyleDefinitions -> 
  "PrivateStylesheetFormatting.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[545, 20, 359, 15, 22, "History",
 CellID->6298],
Cell[CellGroupData[{
Cell[929, 39, 171, 4, 41, "CategorizationSection",
 CellID->1122911449],
Cell[1103, 45, 81, 2, 31, "Categorization",
 CellID->686433507],
Cell[1187, 49, 208, 4, 31, "Categorization",
 CellID->605800465],
Cell[1398, 55, 155, 3, 31, "Categorization",
 CellID->468444828],
Cell[1556, 60, 223, 4, 31, "Categorization",
 CellID->31593272]
}, Closed]],
Cell[CellGroupData[{
Cell[1816, 69, 173, 4, 31, "KeywordsSection",
 CellID->1427428552],
Cell[1992, 75, 45, 1, 17, "Keywords",
 CellID->1251852827]
}, Closed]],
Cell[CellGroupData[{
Cell[2074, 81, 200, 4, 31, "DetailsSection",
 CellID->344402025],
Cell[2277, 87, 49, 1, 31, "Details"],
Cell[2329, 90, 47, 1, 31, "Details"]
}, Closed]],
Cell[CellGroupData[{
Cell[2413, 96, 161, 3, 119, "Title",
 CellID->509267359],
Cell[2577, 101, 829, 15, 52, "Text",
 CellID->1534169418],
Cell[CellGroupData[{
Cell[3431, 120, 134, 2, 37, "MathCaption",
 CellID->1825449234],
Cell[3568, 124, 174, 4, 27, "Input",
 CellID->1373894796]
}, Open  ]],
Cell[CellGroupData[{
Cell[3779, 133, 299, 5, 54, "Section",
 CellID->2591],
Cell[4081, 140, 1198, 28, 101, "Text",
 CellID->16706],
Cell[5282, 170, 917, 27, 56, "DefinitionBox",
 CellID->19362],
Cell[6202, 199, 119, 2, 41, "Caption",
 CellID->19031],
Cell[CellGroupData[{
Cell[6346, 205, 220, 4, 51, "MathCaption",
 CellID->6421],
Cell[CellGroupData[{
Cell[6591, 213, 257, 9, 43, "Input",
 CellID->27111],
Cell[6851, 224, 128, 3, 25, "Output",
 CellID->191037609]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[7028, 233, 114, 3, 37, "MathCaption",
 CellID->7348],
Cell[CellGroupData[{
Cell[7167, 240, 101, 3, 27, "Input",
 CellID->3464],
Cell[7271, 245, 128, 3, 25, "Output",
 CellID->498198997]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[7448, 254, 199, 7, 39, "MathCaption",
 CellID->25569],
Cell[CellGroupData[{
Cell[7672, 265, 406, 14, 48, "Input",
 CellID->2989],
Cell[8081, 281, 130, 3, 25, "Output",
 CellID->654426462]
}, Open  ]]
}, Open  ]],
Cell[8238, 288, 1547, 41, 190, "DefinitionBox3Col",
 CellID->2017],
Cell[9788, 331, 201, 8, 29, "Caption",
 CellID->21763],
Cell[9992, 341, 540, 12, 53, "Text",
 CellID->17753],
Cell[10535, 355, 987, 33, 55, "Text",
 CellID->27158],
Cell[11525, 390, 899, 26, 43, "DefinitionBox",
 CellID->25550],
Cell[12427, 418, 118, 3, 27, "Caption",
 CellID->9037],
Cell[12548, 423, 1223, 33, 167, "DefinitionBox3Col",
 CellID->29072],
Cell[13774, 458, 205, 8, 29, "Caption",
 CellID->26739],
Cell[CellGroupData[{
Cell[14004, 470, 280, 8, 53, "MathCaption",
 CellID->1781],
Cell[CellGroupData[{
Cell[14309, 482, 339, 12, 47, "Input",
 CellID->26975],
Cell[14651, 496, 130, 3, 25, "Output",
 CellID->705840830]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[14830, 505, 234, 5, 65, "MathCaption",
 CellID->19289],
Cell[CellGroupData[{
Cell[15089, 514, 489, 15, 47, "Input",
 CellID->7358],
Cell[15581, 531, 189, 4, 25, "Output",
 CellID->230069580]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[15819, 541, 113, 3, 37, "MathCaption",
 CellID->27254],
Cell[CellGroupData[{
Cell[15957, 548, 168, 6, 41, "Input",
 CellID->23509],
Cell[16128, 556, 186, 5, 25, "Output",
 CellID->211871406]
}, Open  ]]
}, Open  ]],
Cell[16341, 565, 495, 14, 55, "Text",
 CellID->26307],
Cell[16839, 581, 1375, 44, 89, "DefinitionBox",
 CellID->6442],
Cell[18217, 627, 73, 1, 27, "Caption",
 CellID->27758],
Cell[CellGroupData[{
Cell[18315, 632, 420, 16, 39, "MathCaption",
 CellID->6249],
Cell[CellGroupData[{
Cell[18760, 652, 198, 6, 29, "Input",
 CellID->13196],
Cell[18961, 660, 147, 4, 25, "Output",
 CellID->143307490]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[19157, 670, 357, 9, 67, "MathCaption",
 CellID->29449],
Cell[CellGroupData[{
Cell[19539, 683, 611, 19, 29, "Input",
 CellID->23083],
Cell[20153, 704, 133, 3, 25, "Output",
 CellID->187596744]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[20335, 713, 145, 4, 37, "MathCaption",
 CellID->15204],
Cell[CellGroupData[{
Cell[20505, 721, 621, 19, 29, "Input",
 CellID->31242],
Cell[21129, 742, 233, 6, 25, "Output",
 CellID->556571991]
}, Open  ]]
}, Open  ]],
Cell[21389, 752, 1476, 40, 172, "DefinitionBox3Col",
 CellID->5317],
Cell[22868, 794, 193, 8, 29, "Caption",
 CellID->32656],
Cell[23064, 804, 758, 21, 55, "Text",
 CellID->11452]
}, Open  ]],
Cell[CellGroupData[{
Cell[23859, 830, 206, 3, 40, "Section",
 CellID->30767],
Cell[24068, 835, 399, 13, 38, "Text",
 CellID->3951],
Cell[24470, 850, 743, 16, 83, "Text",
 CellID->16117],
Cell[25216, 868, 839, 28, 42, "DefinitionBox",
 CellID->8707],
Cell[26058, 898, 69, 1, 27, "Caption",
 CellID->28587],
Cell[26130, 901, 1037, 34, 100, "DefinitionBox",
 CellID->32556],
Cell[27170, 937, 205, 8, 29, "Caption",
 CellID->4207],
Cell[CellGroupData[{
Cell[27400, 949, 207, 8, 39, "MathCaption",
 CellID->16622],
Cell[CellGroupData[{
Cell[27632, 961, 194, 7, 43, "Input",
 CellID->16390],
Cell[27829, 970, 110, 3, 25, "Output",
 CellID->7936742]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[27988, 979, 89, 1, 37, "MathCaption",
 CellID->22729],
Cell[CellGroupData[{
Cell[28102, 984, 443, 14, 45, "Input",
 CellID->27477],
Cell[28548, 1000, 682, 20, 28, "Output",
 CellID->264026320]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[29279, 1026, 295, 10, 53, "MathCaption",
 CellID->20455],
Cell[CellGroupData[{
Cell[29599, 1040, 173, 6, 27, "Input",
 CellID->20334],
Cell[29775, 1048, 109, 3, 25, "Output",
 CellID->998948]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[29933, 1057, 69, 1, 37, "MathCaption",
 CellID->23883],
Cell[CellGroupData[{
Cell[30027, 1062, 174, 6, 27, "Input",
 CellID->19662],
Cell[30204, 1070, 230, 5, 25, "Output",
 CellID->174038953]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[30483, 1081, 80, 1, 37, "MathCaption",
 CellID->13284],
Cell[CellGroupData[{
Cell[30588, 1086, 393, 13, 45, "Input",
 CellID->29804],
Cell[30984, 1101, 210, 5, 25, "Output",
 CellID->58319039]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[31255, 1113, 215, 3, 40, "Section",
 CellID->32197],
Cell[31473, 1118, 1114, 30, 102, "Text",
 CellID->19192],
Cell[32590, 1150, 1376, 46, 58, "DefinitionBox",
 CellID->19045],
Cell[33969, 1198, 73, 1, 27, "Caption",
 CellID->7357],
Cell[34045, 1201, 1181, 27, 104, "Text",
 CellID->25290],
Cell[35229, 1230, 712, 19, 109, "DefinitionBox3Col",
 CellID->3225],
Cell[35944, 1251, 203, 8, 29, "Caption",
 CellID->16825],
Cell[CellGroupData[{
Cell[36172, 1263, 484, 14, 55, "MathCaption",
 CellID->26053],
Cell[CellGroupData[{
Cell[36681, 1281, 220, 7, 29, "Input",
 CellID->19391],
Cell[36904, 1290, 1980, 48, 108, "Output",
 CellID->342387]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[38933, 1344, 257, 10, 39, "MathCaption",
 CellID->27664],
Cell[CellGroupData[{
Cell[39215, 1358, 133, 4, 27, "Input",
 CellID->6364],
Cell[39351, 1364, 652, 20, 45, "Output",
 CellID->48540072]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[40052, 1390, 100, 2, 37, "MathCaption",
 CellID->6827],
Cell[CellGroupData[{
Cell[40177, 1396, 370, 11, 43, "Input",
 CellID->17078],
Cell[40550, 1409, 739, 22, 45, "Output",
 CellID->688756]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[41338, 1437, 196, 7, 39, "MathCaption",
 CellID->6182],
Cell[CellGroupData[{
Cell[41559, 1448, 428, 12, 43, "Input",
 CellID->25862],
Cell[41990, 1462, 704, 24, 45, "Output",
 CellID->210061539]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[42743, 1492, 156, 4, 51, "MathCaption",
 CellID->20963],
Cell[CellGroupData[{
Cell[42924, 1500, 345, 10, 29, "Input",
 CellID->31555],
Cell[43272, 1512, 822, 26, 45, "Output",
 CellID->111197973]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[44143, 1544, 213, 7, 39, "MathCaption",
 CellID->23438],
Cell[CellGroupData[{
Cell[44381, 1555, 248, 8, 27, "Input",
 CellID->14136],
Cell[44632, 1565, 1254, 36, 62, "Output",
 CellID->634463235]
}, Open  ]]
}, Open  ]],
Cell[45913, 1605, 122, 2, 84, "TutorialMoreAboutSection",
 CellID->113667996],
Cell[46038, 1609, 133, 2, 78, "RelatedTutorialsSection",
 CellID->133707239],
Cell[46174, 1613, 278, 5, 91, "TutorialRelatedLinksSection",
 CellID->28437217]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
