(* :Name: DocumentationTools` *)

(* :CVS Keywords:  $Id: DocumentationTools.m,v 1.58 2013/10/29 20:40:42 jayw Exp $ *)

(* :Title: Utilities for Documentation Creation Palettes  *)

(* :Author: Andre Kuzniarek, Buddy Ritchie, Jerry Walsh, Jay Warendorff *)

(* :Copyright: (c) 2005-07, Wolfram Research, Inc. All rights reserved. *)

(* :Mathematica Version: 6.0 *)

(* :Package Version: 0.01 *)

(* :Summary: Utilities for Documentation Creation Palettes. *)


BeginPackage[ "DocumentationTools`"]

System`MenuPosition (* Declaring this here as a hack to avoid problems with Notebooks running through the kernel *)
$NewModInfoFormat = True;

NotebookID::usage = "Derives notebook path for identification purposes.";
OldNotebookRead::usage = "Same as NotebookRead but uses the option \"WrapBoxesWithBoxData\" -> True to get the old behavior.";
MessageToConsole::usage = "Utility function for sending messages to the Messages notebook.";
DocumentTemplate::usage = "Creates a new template notebook based on a template in the paclet FrontEnd/TextResources directory, takes file name as argument.";
DocumentSample::usage = "Opens a sample notebook from the paclet FrontEnd/TextResources directory, takes file name as argument.";
AuxiliaryPalette::usage = "Opens a file from the paclet FrontEnd/Palettes directory, takes file name as argument.";
NotebookDirectoryOpen::usage = "Opens a file browser to the directory specified as argument, and allows only notebooks to be selected for opening."; 
DoubleUsageLinesInsert::usage = "Does the right thing for inserting new usage lines into usage cells, depending on selection position.";
UsageLineAdd::usage = "Adds a usage line in a usage cell corresponding to the cursor's position.";
BannerInsert::usage = "Inserts a template for paclet identity artwork into guide page.";
ForceDelete::usage = "Delete selection even if it contains cells or styled objects set to Deletable->False";
FunctionLink::usage = "Creates a hyperlink for function names, exludes anything that is not of the form of a simple function name.";

InlineListingToggle::usage =
"Formats inline strings as buttons or restores unformatted text, with
delimiters as specified by the option \"Delimiter\".  Applies unformatted
placeholder when cursor is between cells. Takes cell style as argument
(default: \"SeeAlso\").  Options (defaults in []'s):
  \[Bullet] \"ButtonStyle\" -> _String [\"Link\"]
  \[Bullet] \"Delimiter\" -> {in: (_String | {__String}), out_String} \
[{\" . \", \" \[EmptyVerySmallSquare] \"}]
  \[Bullet] \"DocumentPath\" -> (_String | None) [None]
If 'in' of \"Delimiter\" is a list, any of the listed strings will act as
delimiter on formatting;  when unformatting, the first will be restored.
\"DocumentPath\", if a String, sets ButtonData for each button to
\"paclet://DDD/NNN\", where DDD is \"DocumentPath\" value and NNN is the
delimited text.";

InlineListingToggle::badsel =
"You've attempted to use InlineListingToggle on a \"GuideText\"-style cell.
Perhaps you intended to use OneLineFunction (\"1 Line Function Listing\")?"

InlineListingToggle::unsuptarg =
"Value of the \"TargetStyle\" option (`1`) is not a supported style.";

InlineListingToggle::badsheet =
"\"TargetStyle\" -> Automatic was set, but the target document is not of
one of the standard styles.";

InlineCharacterListingToggle::usage =
"Formats inline character strings as buttons with delimiters of, or
restores unformatted text. Applies unformatted placeholder when cursor is
between cells. Takes cell style as argument, default is \"SeeAlso\".
Accepts following options:
  \[Bullet] \"ButtonStyle\", default is \"Link\",
  \[Bullet] \"Delimiter\", default is {\" . \", \" \[EmptyVerySmallSquare] \"} ({in_, out_}).";
FunctionTemplate::usage = "Initiates a function template, also formats a function template string selection into the proper format. With the argument \"RestoreText\" an \"InlineFormula\" function template is converted back into a string. This will occur if the cursor is inside or selecting part of an \"InlineFormula\" function template. With the cursor at the cell bracket, all \"InlineFormula\" function templates within the cell are converted into strings. When $MathematicaDocs returns False and $ApplicationName and $LinkBase are set, attempting to templatize a text expression will bring up a dialog asking if the user wants to format the expression with or without the head linked as a symbol in their package. If loading the package (if it exists) corresponding to $LinkBase shows that the head is a package symbol, automatic linking and formatting takes place. The no argument form of FunctionTemplate takes the options CalledFromDialog and JustFormat.";
CalledFromDialog::usage = "Option of FunctionTemplate that specifies it should be called from a dialog. The default is False.";
JustFormat::usage = "Option of FunctionTemplate that specifies it should format, but not try to buttonize a possible application symbol. Only used when FunctionTemplate has CalledFromDialog -> True. The default is False.";
FunctionTemplateToggle::usage = "Toggles between using FunctionTemplate[] and FunctionTemplate[\"RestoreText\"].";
$FunctionTemplateFormatting::usage = "Global variable used by CallFunctionTemplateFromDialog[].";
ExampleOpen::usage = "ExampleOpen[] opens an examples notebook if any from the directory DocumentationTools`$ExampleDirectory. ExampleOpen[\"SetDirectory\"] opens a browser to reset DocumentationTools`$ExampleDirectory.";
$PacletURI::usage = "";
$PacletURIFieldValue::usage = "Content of the input field in the Set$PacletURI dialog.";
Set$PacletURI::usage = "Generates a dialog for setting $PacletURI.";
OK$PacletURI::usage = "OK button function for the Set$PacletURI dialog.";
$TargetDocumentDir::usage = "Directory where the user is developing documentation.";
Set$TargetDocumentDir::usage = "Opens a directory browser for setting $TargetDocumentDir. If $DocumentationDirectory is set, the selected directory must be contained in $DocumentationDirectory. If $DocumentationDirectory is not set the selected directory must contain the string \"Documentation\".";
CacheLastDirectory::usage = "Option of CustomLink. The default is False. When set to True, DocumentationTools`$DefaultFileBrowserPath is set to the directory containing the last file that the user attempted to make a link to.";
Interactive::usage = "Option of CustomLink. The default is True. When set to True, a file browser opens. A file may be selected in $DocumentationDirectory or a subdirectory if $DocumentationDirectory is set and if not $TargetDocumentDir must be set and the file must contain $TargetDocumentDir in its path. When $DocumentationDirectory is set the paclet path is from after $DocumentationDirectory. Similarly for $TargetDocumentdir.";
PacletInteractive::usage = "Option of CustomLink. The default is False. When set to True a dialog opens with $PacletURI <> \"/\" <> (string in argument of CustomLink) <> \"/\" in the input field enabling the user to edit the paclet URI. With plain text selected (if the text appearing in the input field was not edited) a link is made with ButtonData -> \"paclet:\"<>$PacletURI<>\"/Guides/\"<>(selected text with first letter capitalized and spaces removed) by clicking the dialog's OK button. With PacletInteractive -> True the selected text is automatically replaced by a button with the paclet expression just indicated.";
TargetPreset::usage = "Option of CustomLink. The default is False. When set to True, a file browser opens. When a notebook is selected, a paclet link to the notebook with ButtonData of the form \"paclet:\" <> $TargetDocumentDir<>\"/\"<>(argument of CustomLink)<>\"/\"<>(file's name) if CustomLink has an argument and \"paclet:\" <> $TargetDocumentDir<>\"/\"<>(file's name) otherwise is written to the selection in the input notebook.";
LinkBase::usage = "Option of CustomLink. The default is None. Otherwise it should be set to $LinkBase. LinkBase must be specified in particular for applications";
$PacletInteractiveFieldValue::usage = "Value in the input field of the dialog generated by SetPacletInteractive.";
SetPacletInteractive::usage = "With PacletInteractive -> True, CustomLink generates a dialog via SetPacletInteractive. The dialog opens with $PacletURI <> (string in argument of CustomLink) <> \"/\" allowing the user to edit $PacletURI for the link being made. Clicking the OK button makes a paclet link at the selection in the input notebook if appropriate.";
OKPacletInteractive::usage = "Button function for the dialog generated by SetPacletInteractive.";
$ApplicationGuidesFile::usage = "The application guide notebook set via CustomLink[\"PacletDocSelect\", \"guide\"].";
$ApplicationHowToFile::usage = "The application how to notebook set via CustomLink[\"PacletDocSelect\", \"howto\"].";
$ApplicationTutorialsFile::usage = "The application tutorial notebook set via CustomLink[\"PacletDocSelect\", \"tutorial\"].";
$ApplicationReferencePageFile::usage = "The application reference page notebook set via CustomLink[\"PacletDocSelect\", \"ref\"].";
$ApplicationDocument::usage = "The application notebook or pdf file set via CustomLink[\"PacletDocSelect\"]";
CustomLink::usage = 
  "CustomLink makes links to urls or files. When a portion of a cell's \
content or a cell is selected, CustomLink[\"PacletDocSelect\", filetype] \
with filetype being \"guide\", \"howto\", \"tutorial\" or \"ref\" brings up a file \
browser to select a notebook corresponding to filetype to link to. The \
notebook chosen should have a file path of the form \
.../application/Documentation/$Language/filetypedir/filename.nb, \
.../application/$Language/filetypedir/filename.nb or \
.../application/filetypedir/filename.nb where filetypedir is \"Guides\", \"HowTos\", \
\"Tutorials\" or \"ReferencePages\" <> $PathnameSeparator <> \"Symbols\" \
depending on whether filetype is \"guide\", \"howto\", \"tutorial\" or \"ref\". \
CustomLink puts $LinkBase into the button data. \
$ApplicationGuidesFile (respectively $ApplicationHowToFile, $ApplicationTutorialsFile or \
$ApplicationReferencePageFile) is set to the file path if the file is a \
guide (respectively tutorial or reference page). CustomLink[\"PacletDocSelect\"] \
enables links to be made to notebooks or pdf files in directories of the form \
.../application/Documentation/$Language/.../filename.nb. \
CustomLink[\"ConfigureApply\", \"guide\" | \"howto\" | \"ref\" | \"tutorial\"] brings up \
a dialog to set or change $LinkBase and to make the selection become a \
Guide, HowTo, Reference Page or Tutorial link with link base $LinkBase. When a string, \
style box, sequence of style boxes and strings or a cell just containing a string\
is selected CustomLink automatically makes a link, opens a browser to link to a \
file or opens a dialog to specify a url or edit a paclet path that will become \
part of the button data of the link. The optional string argument if specified \
is included in the paclet expression for the link. CustomLink takes the options \
CacheLastDirectory, Interactive, ButtonContentsSelection, Target, ContentLabels, \
AddedLabel, PacletInteractive, TargetPreset and LinkBase.";
OKCustomLinkConfigureApply::usage = "OK button function for \
CustomLink[\"ConfigureApply\", _] dialog."
ReplacePacletBase::usage = "ReplacePacletBase[] brings up a directory and then a dialog for modifying the context and application name in metadata as well as the link base used in button data of all notebooks in the directory chosen. ReplacePacletBase[dir] performs the replacements on the directory dir. In the case where the old paclet base field is left empty, the new paclet base is inserted in paclet URIs where \"paclet:\" is followed by a lower case letter. When the old paclet base field is nonempty, paclet bases are also replaced.";
auxReplacePacletBase::usage = "Brings up a dialog asking the user if he wants to proceed in the case where the ReplacePacletBase dialog's old paclet base field was not filled in and so the new paclet base will just be inserted in paclet URIs where \"paclet:\" is followed by a lower case letter."
CancelReplacePacletBaseDialog::usage = "";
$ReplacePacletBaseDirectory::usage = "";
$PackageName::usage = "";
$NewPackageName::usage = "";
$PresentContext::usage = "";
$NewContext::usage = "";
$PacletBase::usage = "";
$NewPacletBase::usage = ".";
$NewSymbolName::usage = "Global variable used by CreateNewPageDialog.";
$NewGuideTitle::usage = "Global variable used by CreateNewPageDialog.";
$NewOverviewTitle::usage = "Global variable used by CreateNewPageDialog.";
$NewTutorialTitle::usage = "Global variable used by CreateNewPageDialog.";
CreateNewPageDialog::usage = "CreateNewPageDialog[pagetype] creates a dialog, where pagetype is \"Reference\", \"Guide\", \"Overview\" or \"Tutorial\", enabling the user to input a symbol name, guide title, overview title or tutorial title. Clicking OK produces a corresponding saved template notebook with filled in metadata, title or object name and inserts the symbol name into a function template in the case of a \"Reference\" page. Also when the page is created, the metadata section is opened and a dialog with some commentary on metadata appears in front of the created page. The message also contains a Don't Show Again button which permanently dismisses the message. The NewPageDialog also has an Ignore button which brings up a blank template page.";
AuxiliaryCreateNewPageDialog::usage = "Used by NotebookEventActions in CreateNewPageDialog.";
DisplayBlankPage::usage = "Button function used by CreateNewPageDialog.";
CreateNewPage::usage = "Button function used by CreateNewPageDialog.";
$Templatize::usage = "Global variable used by CreateReferencePages with default value True. When True, CreateReferencePages formats template expressions involving application symbols.";
CreateReferencePages::usage = 
  "CreateReferencePages[] opens a directory browser and then a dialog \
for creating reference pages for a package. The reference pages are \
created in the directory browsed to and assigned the symbol\
$ReferencePagesDirectory. AuxiliaryCreateReferencePages[$ReferencePagesDirectory] \
creates the reference pages once $LinkBase has been specified \
using the dialog. If there were any notebooks previously in \
$ReferencePagesDirectory they were moved to \
$ReferencePagesDirectory <> \"OriginalReferencePages\". When making \
reference pages, symbols that include characters in their names have \
the corresponding character names inserted as their file names. The \
application must be properly configured so that \
Names[$ApplicationName <> \"`*\"] or Names[$ApplicationName <> \"`*`*\"] \
yields application symbols that have usage messages.";
JustAddNonexistingPages::usage = "Option of AuxiliaryCreateReferencePages with default value False. When set to True, AuxiliaryCreateReferencePages will not create an OriginalReferencePages directory if $ReferencePagesDirectory is nonempty, but will just add symbol pages that do not already exist there.";
OverwriteSymbolPages::usage = "Option of AuxiliaryCreateReferencePages with default value False. When set to True, AuxiliaryCreateReferencePages will overwrite any pages in $ReferencePagesDirectory that exists.";
AuxiliaryCreateReferencePages::usage = "AuxiliaryCreateReferencePages[dir], where dir is a directory, creates reference pages corresponding to $LinkBase in dir. AuxiliaryCreateReferencePages[{functionname1, functionname2, ...}] creates a reference page for the strings functionnamei where functionnamei are symbols of $LinkBase and $ReferencePagesDirectory as well as $ApplicationName and $LinkBase have already been defined. The reference pages are created in $ReferencePagesDirectory. In addition, $ApplicationSymbolsWithUsage should be computed before using AuxiliaryCreateReferencePages via $ApplicationSymbolsWithUsage = Sort[SymbolsWithUsage[$ApplicationName], StringLength@#1 > StringLength@#2 &] after $LinkBase has been loaded.";
$ApplicationSymbolsWithUsage::usage = "Symbols with usage messages corresponding to the application $ApplicationName.";
SymbolsWithUsage::usage = "SymbolsWithUsage[$ApplicationName] gives the symbols with usage corresponding to $ApplicationName. SymbolsWithUsage assumes that the package corresponding to $ApplicationName has already been loaded.";
$ReferencePagesDirectory::usage = "The directory chosen by the CreateReferencePages[] directory browser.";
UpdatePacletVariables::usage = "Button function used by several dialogs to update variables associated with $ApplicationName and $LinkBase.";
CancelSetPacletVariables::usage = "Cancel button function used by SetPacletVariables's dialog.";
SetPacletVariables::usage = "SetPacletVariables[] brings up a dialog for setting $ApplicationName and $LinkBase. If the Cancel button is clicked, $ApplicationName and $LinkBase retain the values they had when the dialog was opened.";
WriteApplicationSymbolsToPrefs::usage = "Write paclet variables to ToFileName[$UserBaseDirectory, \"DocuToolsPrefs\"].";

$ButtonLabelTopic = "Symbol used by the Related Links dialog.";
$SearchTopic::usage = "Symbol used by the Related Links dialog.";
$SymbolToAdd::usage = "Symbol used by the Related Links dialog.";
$SymbolList::usage = "Symbol used by the Related Links dialog.";
$ButtonList::usage = "Symbol used by the Related Links dialog.";
$RelatedLinksGuideWindowTitle::usage = "Symbol used by the Related Links dialog.";
AddToList::usage = "Button function in the Related Links dialog.";
RelatedLinksOK::usage = "Button function in the Related Links dialog.";
TestRelatedLinkData::usage = "Button function in the Related Links dialog.";
RelatedLinksDialogOpen::usage = "Opens the Related Links dialog.";
JustUpdateSymbols::usage = "Option of RelatedLinksDialogOpen.";

PackageSettingApply::usage = 
  "PackageSettingApply takes the option \"Interactive\" with default value \
False. With \"Interactive\"->False the package context as specified by the \
input notebook's metadata is inserted into the input notebook as the tagging \
rule \"NeededPackages\" -> {\"context name`\"}. With \"Interactive\"->True a \
dialog is generated containing the context as specified by the \"Context\" cell \
and overwrites the \"NeededPackages\" tagging rule if there is a conflict. If \
the Context cell is empty the dialog displays what is in the \"NeededPackages\" \
tagging rule if already specified. If not specified in the \"NeededPackages\" \
tagging rule the dialog comes up with nothing in its input field. Clicking the \
OK button inserts the context specified in the input field into the Context cell \
as well as the \"NeededPackages\" tagging rule of the working notebook";
$packagecontext::usage = "";
$contextnotebook::usage = "";
$contextdialog::usage = "";
InsertContextFromDialog::usage = "Button function for the PackageSettingApply dialog.";

CloseNotebook::usage = "";
ButtonContentsSelection::usage = "";
Target::usage = "";
ContentLabels::usage = "Option for CustomLink. The default is All which allows the user to make use of any of the labels in the URL link dialog. With the value None the URL link dialog appears with no button label options and uses the selected text for button content. ContentLabels may also be set to a list of 2 or more strings in which case the URL dialog gets generated with radio buttons corresponding to those strings as possible values for button content.";
AddedLabel::usage = "";
StyleApply::usage = "Applies the argument as style name to selection, also creates a template cell or style box with of the given style.";

StyleAppend::usage = "Appends the argument as an additional style to selection, and deletes same when already applied.";

StyleAppend::nocellid = "One of the cells in a multiple selection has no
CellID option (necessary for navigation).  You must apply the function to
each cell individually.  [`1`]";

StatusSet::usage = "StatusSet[\"TentativeObject\"] sets the status of a notebook to Tentative.";
UntentifyNotebook::usage = "UntentifyNotebook[nb] untentify's a notebook with notebook object nb.";
TentifyToggle::usage = "Toggles the \"TentativeExample\" secondary style in \"Usage\" and table cells as well as cells whose style definitions contain the tagging rule \"CanTentify\" -> True. When the style \"TentativeExample\" is inserted, a ModInfo cell is also inserted (in a tooltip box with the user's login) if not already present. When the style \"TentativeExample\" is present,  ModInfo cells are left when toggling the \"TentativeExample\" off.";

SetSourcePageOrCellStatus::usage = "SetSourcePageOrCellStatus[status] (intended to be used in a palette's button), where status is either \"MathematicaDocument\" or \"Alpha&MathematicaDocument\", applies the \"MathematicaDocument\" or \"Alpha&MathematicaDocument\" label to the top of a source information page and sets the corresponding screen environment if there is no selection. In each case they also act as toggles. When the cursor is in a cell or at a cell bracket a similar behavior takes place -- appending cell styles and adding cell tags. There is likewise toggling at the cell level.";
GraphicInsert::usage = "GraphicInsert is intended for writing and overwriting graphics in Solutions pages. The cursor must initially be between cells in a \"SolutionsSection\" section or at the cell bracket of a \"SolutionsAbstractImage\" or \"SolutionsImageShifted\" cell. A file chooser will open, enabling the user to select a \".gif\", \".tif\", \".jpg\" or \".png\" graphic to insert at the cursor location. If a graphics cell has the style \"SolutionsAbstractImage\" or \"SolutionsImageShifted\", the new graphic will be inserted in a cell of the same style. If the cursor is between cells in a solutions section with cell tag \"CaptionsAndImagesForSlideshow\" the style of the cell containing the new graphic will be \"SolutionsAbstractImage\". In other solutions sections, it will be \"SolutionsImageShifted\". If the cursor is between cells elsewhere a message is issued.";
MoveToCellBracketOfButton::usage = "Option of GraphicInsert with default value False. With MoveToCellBracketOfButton -> True, GraphicInsert is intended to be called from a placeholder graphics button and will first move the cursor to the cell bracket before opening a file browser.";
$ApplicationGraphicsFile::usage = "Symbol used by GraphicInsert.";

CharacterToLongName::usage = "Converts a special character into a button with contents: \\[character name].";
RestoreDefault::usage = "Restores default cell style";
KeywordLabelApply::usage = "Adds a cell label to a keyword or synonym cell or to a collection of keyword cells or to a collection of synonym cells.";
ClearKeywordLabel::usage = "Removes a cell label from a keyword or synonym cell or from a collection of keyword cells or from a collection of synonym cells.";
TraditionalFormCell::usage = "Converts the word preceding the cursor into an inline TraditionalForm cell.";
SyntaxTemplateException::usage = "Takes \"Exclusion\" and \"Inclusion\" as arguments. Toggles the selected function template in usage block to be excluded from, or selected function template in notes to be included in, the syntax template gathering system. Applies a color change as indicator.";
SyntaxTemplateInsert::usage = "SyntaxTemplateInsert[] inserts a function template into a function page.";
SyntaxTemplatesInspector::usage = "Generates the Syntax Inspector.";  
SetColumnWidths::usage = "SetColumnWidths[r, s]  sets \"ColumnWidths\" in a 2 column definition box to be {r, s}. Here r and s are each of the form .xy where both x and y are from 0 to 9 inclusive and r + s = 1.00.";
TwoColumnToggle::usage = "Creates a two column table of inline cells from a sequence of cells whose brackets are selected and a sequence of cells from a two column table.";
TableInsert::usage = "Inserts a table template of the number of columns provided as argument. Default is 3. TableInsert has the options \"ModInfoColumn\", NumberOfRows, TableStyle, and PlaceholderObject. The default for \"ModInfoColumn\" is True and in that case a leftmost column with \"ModInfo\" cells is disregarded when specifying the style.";
NumberOfRows::usage = "Option for TableInsert. The default is 2. This option gives the number of rows in the inserted table.";
PlaceholderObject::usage = "Option for TableInsert and TableAddColumn. The default is Automatic for TableInsert and \"XXXX\" for TableAddColumn. For TableInsert with PlaceholderObject -> Automatic, when a one column table is inserted each table element is Cell[\"XXXX\",\"TableText\"], when a two column table is inserted, elements in the first column are Cell[\"      \", \"ModInfo\"] and elements in the second column are Cell[\"XXXX\",\"TableText\"] and when a three or more column table is inserted, the first and last columns are the same as when a two column table is inserted and the other table elements are \"XXXX\". For TableInsert PlaceholderObject also may be set to a list of table elements.";
TableInsertDialog::usage = "TableInsertDialog[] brings up a dialog for a inserting a table with the number of rows as specified by the user in the input field. There are radio buttons to also specify if the table has 2 or 3 columns and whether the table is \"Regular\" or \"Text\".";
TableAddColumn::usage = "Adds a column consisting of placeholder objects (such as \"XXXX\" or Cell[\"XXXX\",\"TableText\"]) at the appropriate place in a table corresponding to a cursor position. TableAddColumn takes the options \"ModInfoColumn\", PlaceholderObject, ColumnPosition and TableStyle. The default for \"ModInfoColumn\" is True and in that case a leftmost column with \"ModInfo\" cells is disregarded when specifying the style of the table with the added column.";
ColumnPosition::usage = "An option of TableAddColumn with default None. When a positive integer a column will be inserted at that position among the columns of the table regardless of the cursor position within the table.";
TableStyle::usage = "An option of TableAddColumn and TableInsert with default Automatic. If TableStyle is not Automatic, it should be set to a cell style as a string or a list of cell styles.";
TableAddRow::usage = "Adds new row as appropriate for number of columns in selected table. TableAddRow takes the option \"SelectionPosition\". The default is 2.";
TablePartDelete::usage = "Deletes a selected column, row, subgrid or complete element of a table.";
TableInlineCellsToggle::usage = "With a subgrid in a table selected, TableInlineCellsToggle makes all table elements in the selection inline if none are, all cells into strings if all table elements in the selection are simple inline cells and when the table elements in the selection are a mix, all become strings. TableInlineCellsToggle takes the string option \"InlineCellStyle\" with default \"TableText\"."
TableInlineCellsToggleUndo::usage = "Undoes TableInlineCellsToggle";
TableSort::usage = "Sorts rows of tables based on column number provided as argument, default is 1. With a first column of \"ModInfo\" cells, TableSort[n] sorts on column n + 1. TableSort groups the rows whose nth column appear as symbols and strings (with quotes) into two groups and sorts within those groups. Symbols, strings, symbols or strings in buttons, symbols with arguments and symbols or strings in lists are supported (by TableSort) as elements of the nth column. A given symbol, the same symbol with arguments and then that symbol as the first element of a list are grouped together in that order.";
TableMerge::usage = "Merges selection of two cells of similar tables into one cell";

InsertOptions::usage = "Inserts cells corresponding to a symbol's options if any in the \"Options\" section of a notebook. The symbol is obtained from the \"ObjectName\" cell. InsertOptions updates the \"Options\" section as needed if options cells are already present."
PreviewOptionsToInsert::usage = "Generates a preview of the list of options cells that will be inserted into a function page by a Functions Options Inspector dialog.";
InsertOptionsFromDialog::usage = "Inserts checked options into a notebook in the appropriate section from a Functions Options Inspector dialog.";
RefreshOptionsInspectorDialog::usage = "Refreshes a Functions Options Inspector dialog.";
OptionsInspector::usage = "With a function page as input notebook, OptionsInspector[] brings up a dialog corresponding to a function page. The dialog contains check boxes and labels corresponding to all options for the symbol described on the function page but not listed in the Options section.";
OptionsTableCreate::usage = "OptionsTableCreate[] brings up a dialog for creating and inserting an options table corresponding to a System symbol.";
$frontend::usage = "A symbol used by OptionsTableCreate[].";
$rowboxnb::usage = "A symbol used by OptionsTableCreate[].";
PreviewOptionsTable::usage = "Function used by the options table creation dialog for giving a preview of an options table corresponding to the settings in the dialog as specified by the user.";
InsertOptionsTable::usage = "Function used by the options table creation dialog for inserting an options table corresponding to the data in the dialog as specified by a user into a symbol's notebook.";
RefreshOptionsTableCreate::usage = "Function used by the options table creation dialog to refresh its content.";
oppositeCheck::usage = "Checkbox function for the Syntax Inspector."; 
AddTemplateField::usage = "A button function for the Syntax Inspector."; 
TemplatesInspector::usage = "The Syntax Inspector dialog.";
$templatenb::usage = "A symbol for an invisible notebook used by the Syntax Inspector.";
UpdateTemplatesInInputNotebook::usage = "A button function for the Syntax Inspector."; 
RefreshTemplatesDialog::usage = "A button function for the Syntax Inspector."; 
ButtonStyleApply::usage = "Replaces the existing style of a button with the style in the argument of ButtonStyleApply. ButtonStyleApply takes the option ToggleAppend.";
ToggleAppend::usage = "Option of ButtonStyleApply with default value False.";
DeactivateControls::usage = 
  "Makes controls of a given input notebook's \"Usage\" and \"Notes\" cells 
inert. The following controls are affected: Animator, Checkbox, ColorPicker,
InputField, Opener, RadioButton, Setter, Slider2D, Slider, TabView and 
Toggler.";
DocDelimiter::usage = "Inserts ExampleDelimeter cell in function pages, GuideDelimiter in guide pages, or GuideMoreAboutDelimiter in guide More About sections.";
NeedsStatementInsert::usage = "Inserts a Needs cell with the context obtained from the \"Context\" cell in the Categorization metadata of a function page when the context is not System`.";
Deemphasis::usage = "Option of NeedsStatementInsert. The default is True.";
KeyWordsSort::usage = "Sorts key word cells. The words in the cells are sorted according to the precedence: space, hyphen, letter. In addition capitalization is disregarded. Either an entire key word group or a single key word cell may be selected.";

InsertLink::usage = "InsertLink[options_?OptionQ].
Stores a link button on the clipboard targeting the currently selected
cell, ready for pasting. (The cell is targeted by its CellID option value.)
Option \"ButtonText\" sets the label of the link button (if Automatic, uses
the link tag). With option \"Example\" -> True, also installs a backlink
button within the cell. (Note that \"Example\" -> True is incompatible with
non-Automatic \"ButtonText\", since the backlink depends on the presence of
the link tag in the label.)"

$SelectedCellData::usage = "Symbol used to store a uri when InsertLink is used with the option \"PreserveSelectionContent\" -> False.";

InsertLink::badURI =
"Could not derive a paclet URI for the selected notebook; reverting to
short form.  Possible causes:
\t\[Bullet] Notebook is unsaved.
\t\[Bullet] Notebook is no longer open.
Diagnostics: [`1`]";

LinkSelection::usage = "Used after InsertLink has set $SelectedCellData to a uri to link selected text.";

ClearLink::usage = "ClearLink[options_?OptionQ].
Clears link-related artifacts (i.e., backlinks) from the currently selected
cell."

FindExampleLink::usage = "FindExampleLink[id_Integer].
ButtonFunction for \"ExampleLink\"-style buttons.  'id', provided by
ButtonData, is the CellID of the targeted example.";

FindBacklink::usage = "FindBacklink[label_String].
ButtonFunction for the backlink (\"ExampleBacklink\") buttons.  The target
of the backlink is taken to be a button of the form
     ButtonBox[label, BaseStyle -> \"ExampleLink\"]
(modulo some options).  'label' is typically provided via the ButtonData of
the backlink button.";

$FlaggedVersion::usage = "Variable for setting ModInfo version number threshold for bright flag.";

BrightFlagFlip::usage = "BrightFlagFlip[nb_NotebookObject, options___].
Modulates the \"BrightFlag\" setting for selected cell(s) in the designated
notebook.  (Default value for 'nb' is InputNotebook[].)
Takes the option \"Flag\", with values and meanings:
\tTrue -> turns flag on
\tFalse -> turns it off
\tAutomatic -> toggles its value
\tInherited -> leaves value as is.";

VersionAnnotate::usage = "VersionAnnotate[label_String, options___].\n
Sets the CellDingbat or ModInfo inline cell (used for versioning info) of
the currently selected cell of InputNotebook[].\n
Options:\n
\t\"Flag\" -> (True | False | Inherited | None)\n
\t\tWhether or not to apply the \"BrightFlag\" option (Inherited retains the
current setting).\n
\t\"VersionFlagging\" -> (_?NumberQ | None)\n
\t\tFlag versions at or above the given number (overriden by an explicit
\"Flag\" option).\n
\t\"IgnoreUsageAndTables\" -> (True | False)\n
\t\tIf within a Usage cell or table, do nothing.";

GenerateVersionAnnotateProceedDialog::usage = "Called by VersionAnnotateNew when the cursor in not inside the input notebook or between cells in the input notebook.";
VersionAnnotateProceed::usage = "Button function for GenerateVersionAnnotateProceedDialog's OK button.";
VersionAnnotateNew::usage = "The new VersionAnnotate being developed.";

EditVersionHistory::usage = "EditVersionHistory[].\n
Launchs a dialog to edit the version history of the currently selected cell
of InputNotebook[].\n
NOTE:  Currently only works for ModInfo cells (CellDingbat cases to come).";

ImageSizeApply::usage = "ImageSizeApply[width_?NumberQ, nb_NotebookObject].\n
  Sets the width of the currently selected graphic cell in notebook 'nb' to 'width', attempting to maintain the current aspect ratio.  'nb' is optional (defaults to InputNotebook[]).";
CellSort::usage =
"CellSort[] sorts the selected set of cells into alphabetical order.
If a single cell is selected, delimited words/phrases are sorted.
Option \"Delimiter\" specifies the delimiting string(s).";
CellFunctionApply::usage =
"CellFunctionApply[f_Function] applies 'f' over delimited words/phrases
within the selected cell. Option \"Delimiter\" specifies the delimiting
string(s).";
ConvertTeX::usage = "Converts selection or previous word from inline TeX syntax to TraditionalForm inline cell.";
ScrollBarCheck::usage = "Sets vertical scroll bar on EvaluationNotebook if notebook exceeds height of available screen space.";
ScrollBarToggle::usage = "Toggles setting of vertical scroll bar. Takes argument \"Automatic\" (same as no arg), or \"On\" which turns scrolling on if not already on, and \"Off\" which turn scrolling off if not already off.";
CellGroupToggle::usage = "Toggles opening/closing of cell group.";
RaisedOrdinal::usage = "Inserts superscripted rd, th, etc, depending on argument.";
DynamicGraphic1::usage = "Function to use as RHS for CellEvaluationFunction option, and switches all output of graphics evaluations to dynamic (thereby minimizing output).
Switch is based on graphics heads listed in $GraphicHeadList. This method will not work for evaluations such as x = Plot[...].";
DynamicGraphic2::usage = "Function to use as RHS for CellEvaluationFunction option, and switches all output of graphics evaluations to dynamic (thereby minimizing output).
Switch is based on analysis of output, and is therefore less efficient than DynamicGraphic1, since it evaluates things twice when switching, but it is inherently more robust."

$GraphicsEvaluationSlownessLimit::usage =
"$GraphicsEvaluationSlownessLimit is the number of seconds that a graphics
evaluation can take before DocuTools decides not to try to produce a
dynamic form of output. When a graphics dynamicizer is in use, set
$GraphicsEvaluationSlownessLimit to a higher value to get dynamic outputs
for slower graphics computations."

$GraphicsOutputTolerableSize::usage =
"$GraphicsOutputTolerableSize is a byte count cutoff for graphics
output expressions, below which the output is not a candidate for
substitution of a dynamic output display."

WolframDocumentProlog::usage = "WolframDocumentProlog[] is to be
evaluated as cell prolog for input cells in a Wolfram documentation
source notebook."

`Private`DynamicGraphicOutputProlog::usage =
"DynamicGraphicOutputProlog[]
stores the current time in a variable,
so that it can be later referred to by
DynamicGraphicOutputEpilog[].
DynamicGraphicsOutputProlog[]
is intended as a value for the
CellProlog
notebook option when an author is working on documentation notebooks."

`Private`DynamicGraphicOutputEpilog::usage =
"DynamicGraphicOutputEpilog[]
gauges whether the preceding output merits rendering as a dynamic object
in the shipping version of a documentation notebook,
and if so,
it stores information for creating that dynamic object in the author's notebook."

DynamicOutputToggle::usage = "Toggles environment that sets Input style with CellEvaluationFunction for Dynamic function. Accepts string as argument to indicate normal environment to return to, default is \"Brackets\".";
DynamicOutputStatus::usage = "This should is used in a DynamicBox within TooltipBox for DynamicOutputToggle button to display the setting of the current InputNotebook[]."; 

$GraphicHeadList::usage = "Variable for listing graphics heads for DynamicGraphic1 to test/switch on.";

BitmapOutputApply::usage = "Set selected graphics output cell to bitmap if doing so saves storage space. \"All\" argument runs on all appropriate cells in notebook.";

FileNameAppend::usage = "Appends the second argument to the file name of the notebook object in the first argument, ahead of the .nb extension.";
SymbolStatusSet::usage = "Sets screen environment appropriately for status of sysmbol. Takes \"Internal\" and \"Future\" as arguments, toggles each on/off.";
TableSpanToggle::usage = "Allows an overly-long first column to span the table, moving the original second column down to a new row.  \
If a single table row is selected, is does this break out.  If two rows resulting from this action are selected, returns them to their original state.";

ButtonEdit::usage = "Launches a dialog to change the button content or button data of the button/link selected or directly left of the cursor.";

GuideTextToggle::usage = "Toggles between 1- and 2-line forms of GuideText cells.";

$URLValue::usage = "";
$CustomLinkmatch::usage = "";
$custom::usage = "";
$customcontent::usage = "";

$customDialog::usage = "";
$closeNB::usage = "";

OpenNotebookSearchDialog::usage = "OpenNotebookSearchDialog[] opens a dialog for using NotebookSearch.";
StartCopernicSearch::usage = "";
OpenNotebookSearchDialog::noresults = "No files found corresponding to the search string.";
OpenNotebookSearchDialog::notWindows = "The OS is not Windows XP so neither Copernic Desktop Search nor Google Desktop Search can be used.";
OpenNotebookSearchDialog::noNET = "The .NET framework has not been installed so neither Copernic Desktop Search nor Google Desktop Search can be used.";
OpenNotebookSearchDialog::updateNET = "Install a more recent version of the .NET framework.";
OpenNotebookSearchDialog::noGoogle = "Either Google Desktop Search, the Wolfram Notebook Indexer or the .NET framework is not installed.";
OpenNotebookSearchDialog::noCopernic = "Either Copernic Desktop Search, the Wolfram Notebook Indexer or the .NET framework is not installed.";
OpenNotebookSearchDialog::browerr = "Enter a nonempty string in the search field and choose a directory. You may need to set $FunctionDirectory, $GuideDirectory, $TutorialDirectory or $ExampleDirectory to paths on your computer.";
OpenNotebookSearchDialog::notimpl = "This option cannot be changed since WordSearch -> True is not properly implemented in NotebookSearch at this time.";
$sort::usage = "";
$results::usage = "";
$resultsnumber::usage = "";
$number::usage = "";
$viewnumber::usage = "";
$purpled::usage = "";
$gitem::usage = ""; 
$gbackground::usage = "";
$gall::usage = "";
$gfunction::usage = "";
$gtutorial::usage = "";
$gguide::usage = "";
$gexample::usage = "";
$gcustom::usage = "";
$background::usage = "";
$selecteddirectory = "";
$SearchFieldValue::usage = ""; 
$match::usage = ""; 
$item::usage = "";
$all::usage = ""; 
$function::usage = ""; 
$tutorial::usage = ""; 
$guide::usage = ""; 
$example::usage = ""; 
$custom::usage = ""; 
$Tab::usage = ""; 
$sall::usage = ""; 
$text::usage = ""; 
$exampletext::usage = ""; 
$mathcaption::usage = ""; 
$input::usage = "";
$output::usage = ""; 
$usage::usage = ""; 
$casesensitive::usage = ""; 
$matchentire::usage = ""; 
$highlight::usage = "";
$searchnested::usage = ""; 
$windowElements::usage = "";
$state::usage = "";
$preTab::usage = "";
$size::usage = "";
$netlink::usage = "";
searchURL::usage = "";
copernicAvailable::usage = "";
googleAvailable::usage = "";
$NotebookSearchDialog = "";
$height = "";
FunctionLinkableQ::usage = "FunctionLinkableQ[expr] returns True if
expr is a string that probably ought to be represented in documentation
as a FunctionLink button.";
$MakeLinks::usage = "$MakeLinks is a global variable specifying whether
formatting constructors like FunctionTemplate should make links
for symbol names that look like built-in function names.";

FindFileOnPath::usage = 
"FindFileOnPath[file_,path_] finds files matching file_ in any of the
directories listed in path_. file_ can be any string pattern accepted by
FileNames[]. An element of path_ can be a string or a pair, {string,
depth}, meaning to search subdirectories to the specified depth (depth can
be Infinity). path_ can be a single such element or a list of them.";

OneLineFunction::usage = "Function for the \"1 Line Function Listing\" palette button";
TwoLineFunction::usage = "Function for the \"2 Line Function Listing\" palette button";

DocuTools::nosel = "You must select a `2` before using `1`.";
DocuTools::badsel = "You must select within a `2` before using `1`.";
DocuTools::oversel = "You must select only one `2` before using `1`.";
DocuTools::assertion = "Should not have reached this point. `1`";
ImageSizeApply::unsupsize = "ImageSizeApply currently only accepts numerical values or Automatic for ImageSize parameters.";
(*
TableSpanToggle::nosel = "You must select row(s) of a table before using TableSpanToggle.";
TableSpanToggle::oversel = "You must select either one or two rows of a table when using TableSpanToggle.";
TableSpanToggle::nospan = "The two rows selected aren't currently spanning.";
*)
TraditionalFormCell::badmath = "The word preceding the cursor is not a valid math expression.";
TraditionalFormCell::nocellsel = "The selection or cursor must be within a cell before using TraditionalFormCell.";
GuideTextFormat::usage = "Function to toggle between formatted and unformatted 1-line function listing.  (Assumes selection is in or on a \"GuideText\" cell.)";

FormatAll::usage = "FormatAll[\"Format\" | \"Unformat\" | \"Toggle\"]. Performs a full-notebook format or unformat on the InputNotebook[], according to the argument.  For \"Toggle\", checks the notebook for the last action performed (see $FormattedTag) and reverses it.";
$FormattedTag::usage = "Name of the notebook-level TaggingRule to store the last action performed by FormatAll. $FormattedTag -> (True | False) indicates formatted/unformatted, respectively.";
$DefaultFormatToggleAction::usage = "Action to take for FormatAll[\"Toggle\"] if no TaggingRule (cf $FormattedTag) is present.";

SelectionWordSort::usage = "SelectionWordSort sorts a list of comma delimited words beginning with upper case letters and writes back to the selection. The sorting still takes place if a space occurs after the comma. SelectionWordSort also sorts a sequence of cells consisting of strings."

SelectionCapture::usage = "Generates screen capture of selected cells with notebook framing. Only works on Windows. \
$WindowWidth variable can be set to desired dimension. $WindowName variable can be set to any string.";
NotebookCaptureInsert::usage = "Inserts captured image of stand-alone notebook.";
$WindowWidth::usage = "Variable for setting window size of SelectionCapture result, default is 470.";
$WindowName::usage = "Variable for setting window name of SelectionCapture result, default is Automatic.";
$CapturedImage::usage = "Variable for storing captured notebook image.";
$VisibleSelection::usage = "Variable for setting ShowSelection True or False, default is Automatic.";
$NotebookCapturePaletteFrame::usage = "$NotebookCapturePaletteFrame is a variable referred to by SelectionCapture, indicating whether the captured notebook's window frame should be set to \"Palette\".";
NotebookImageTempOptions::usage =
"NotebookImageTempOptions[ opts, cellSel, modFlag, nb]
returns a list of options to be set in the notebook nb, whose image
is being captured by SelectionCapture.  The opts argument is a list of
the notebook's current option settings.  The cellSel argument is True if
the current selection in the notebook is a cell.  The modFlag argument is
True if the notebook has unsaved modifications. The nb argument is the
NotebookObject corresponding to the notebook being captured, and is
provided so that NotebookImageTempOptions can check other properties of
the notebook that might pertain to the choice of options for the capture.";

ExampleStatusStamp::usage = "Checkbox function for Example Status metadata.";
ExampleStatusSummary::usage = "Example status compiling function.";
ExampleStatus::usage = "Variable for example status compiling function.";
ExampleStatusShow::usage = "Finds and opens the example status group.";
ExampleStatusAuthorInsert::usage = "Inserts new example status author cells in correct place.";

UndeploymentSetter::usage = "Toggles the setting of TaggingRules with \"UndeployInDocsBuild\" -> True, indicating whether or not notebook should be ignored by documentation build processing system. InputNotebook[] is the default argument.";
UndeploymentSetting::usage = "Indicates whether or not notebook should be undeployed (ignored) by documentation build processing system. True indicates notebook should be ignored, False indicates notebook should be processed. InputNotebook[] is the default argument.";
$UndeploymentRefresh::usage = "Variable tracked by dynamic expression executing UndeploymentSetting, to force rerendering of status indicator (check box).";

GenerateNotebookWithLinksToCellsContainingUndefinedStyles::usage = "GenerateNotebookWithLinksToCellsContainingUndefinedStyles[dir], where dir is a directory, generates a notebook whose headings are the undefined styles (from the standpoint of TutorialPageStyles.nb) in the notebooks contained in dir. Under each heading \"style\", links are given to all cells that occur in notebooks in dir containing \"style\" at the cell level, in inline cells or style boxes within the cell. The link labels give the notebook names and cell IDs. $DocuToolsDir must first be set. If all styles are defined {} is returned.";

GenerateOverview::usage = "GenerateOverview[tutorialdir, linkbase, application] generates an overview corresponding to tutorialdir, a directory of tutorials for application with corresponding linkbase. The overview is created inside tutorialdir.";
BrowseToTutorialAndOpen::usage = "BrowseToTutorialAndOpen[] opens a browser to select a notebook in the Tutorials directory corresponding to $LinkBase.";
CopyTutorialCellData::usage = "The button function CopyTutorialCellData[] copies and sets $CellData = {cell's content, style, cell's ID} for a cell with plain or styled text in a notebook in the Tutorials directory corresponding to $LinkBase.";
PasteTutorialCell::usage = "Intended for use in constructing tutorial overviews. When $CellData has first been obtained, the button function PasteTutorialCell[] constructs a cell from $CellData that has a link to the cell specified by $LinkBase, the cell ID in $CellData and $ApplicationTutorialsFile. If the cursor was between cells in the overview being constructed, it is necessary that the style specified by $CellData be \"Section\", \"Subsection\" or \"Subsubsection\". If a cell in the overview being constructed is selected, the style specified by $CellData is irrelevant.";
ReplaceStyles::usage = "Replacement function used by the Undefined styles replacements dialog OK button.";
UndefinedStyleReplacementsDialog::usage = "UndefinedStyleReplacementsDialog[dir] generates a dialog for replacing styles not defined in Core.nb or TutorialPageStyles.nb but which appear in one or more of the tutorials in the directory dir.";
$UndefinedStyleDialogData::usage = "A list such as {{1, 1, \"Title\"}, {2, 0, 0}, {3, 0, \"Text\"}} used by the the Undefined styles replacements dialog. The 1 of the first element in position 2 shows that the first button in the undefined styles section of the dialog was the last clicked on. The styles in the third position of the first and third elements shows that the first and third undefined styles have been given the substitutions \"Title\" and \"Text\".";
$UndefinedStyleData::usage = "A list of form {{tutorialpath1, {undefinedstyle11, undefinedstyle12,...}}, {tutorialpath2, {undefinedstyle21, undefinedstyle22,...}}, ...} where tutorialpathi is a tutorial constructed by TutorialDivider and having undefined styles undefinedstylei1, undefinedstylei2,....";
$Undefinedstyles::usage = "List of styles not defined in Core.nb and TutorialPageStyles.nb and present in the tutorials being divided.";
$ButtonNumber::usage = "Number of button last clicked on in undefined styles section of the Undefined styles replacements dialog.";
$ButtonNumber2::usage = "Number of button last clicked on in defined styles section of the Undefined styles replacements dialog..";
TutorialDivider::usage = "TutorialDivider[SourceDirectory, OutputDirectory, tutorialDivider] divides tutorials in SourceDirectory by cells which have style tutorialDivider. The resulting notebooks are created in OutputDirectory.";
$StyleReplacements::usage = "A list of the form {string11 -> string12, string21 -> string22, ...}. The default is {}. When nonempty, $StyleReplacements specifies the style replacements that TutorialDivider will make when generating the subdivided tutorials";
$StripTutorialDividerNumberPrefixing::usage = "Global variable used by TutorialDivider.";
$RetainOriginalTableFormatting::usage = "Global variable used by TutorialDivider.";
$RetainOriginalTextCellFormatting::usage = "Global variable used by TutorialDivider.";
StripSectionNumbering::usage = "Option for TutorialDivider with default value False. When set to True, section numbering is stripped from heading titles when constructing the file names of the subdivided tutorials from the tutorial divider headings.";
RetainOriginalTableFormatting::usage = "Option for TutorialDivider with default value False. When set to False, virtually all table formatting is removed. Application symbols not followed by [ are buttonized. The case of application symbols followed by [ ] is also formatted.";
RetainOriginalTextCellFormatting::usage = "Option for TutorialDivider with default value False. When set to False, virtually all formatting in text cells is removed. Application symbols not followed by [ are buttonized. The case of application symbols followed by [ ] is also formatted.";
DivideTutorialsScope::usage = "Option for DivideTutorials with default value Directory. When set to Directory, all notebooks in the directory $SourceDirectory are divided. Otherwise just the input notebook will be divided if saved.";
$SourceDirectory::usage = "Directory to apply TutorialDivider to.";
Set$SourceDirectory::usage = "Set$SourceDirectory[\"Browse\"] brings up a directory chooser to set $SourceDirectory.";
$OutputDirectory::usage = "Directory to create the output notebooks as a result of applying TutorialDivider.";
Set$OutputDirectory::usage = "Set$OutputDirectory[\"Browse\"] brings up a directory chooser to set $OutputDirectory.";
$SystemSymbolExceptions::usage = "$SystemSymbolExceptions is the list of System` symbols to be excluded from the list of System` symbols that GenerateTransformedTable makes buttons for without button data. This is done when an application has some of the same symbols as System`. All of those symbols should be listed as strings and $SystemSymbolExceptions should be set to that list before GenerateTransformedTable is called.";
GenerateTransformedTable::usage = "With the cursor in a \"DefinitionBox\" or \"DefinitionBox3Col\" table GenerateTransformedTable[] generates a regularized version of the table in a preview notebook with a button enabling the user to overwrite the original table with the regularized one if so desired.";
InsertTransformedTable::usage = "Button function in the preview notebook generated by GenerateTransformedTable.";
RevertTransformedTable::usage = "Button function in the preview notebook generated by GenerateTransformedTable.";
$TableCell::usage = "$TableCell is the transformed cell expression constructed by GenerateTransformedTable.";
$OldTableCell::usage = "$OldTableCell is the old cell expression used by GenerateTransformedTable.";
$TutorialDivider::usage = "The style of cells, usually a heading, that TutorialDivider uses as its basis for breaking up notebooks into smaller ones.";
$AdditionalTutorialDividerSections::usage = "Additional section types for tutorial subdivision. The default is {}.";
$File::usage = "File to apply TutorialDivider to for a notebook.";
DivideTutorials::usage = "DivideTutorials[] brings up a dialog enabling a user to select $SourceDirectory and $OutputDirectory and to set $TutorialDivider as well as to decide whether section numbering will be stripped or not. If there is an input notebook $SourceDirectory will be set to the input notebook's directory and $OutputDirectory will be set to $SourceDirectory <> \"Tutorials\". Clicking the OK button will create notebooks in $OutputDirectory from those in $SourceDirectory corresponding to $TutorialDivider. If $SourceDirectory <> \"Tutorials\" does not exist and is being used as $OutputDirectory then $SourceDirectory <> \"Tutorials\" will be created. $StyleReplacements and/or $AdditionalTutorialDividerSections may be specified to modify the default behavior. With the option setting DivideTutorialsScope -> File, DivideTutorials will divide just the input notebook if saved.";

$ApplicationSymbolsLinkFixDirectory::usage = "Directory for FixApplicationSymbolsLinks to act on.";
ApplicationSymbolsLinkFix::usage = "ApplicationSymbolsLinkFix[] brings up a directory and then a dialog for use with FixApplicationSymbolsLinks which is designed to add button data to application symbol buttons as needed.";
$ExcludedApplicationSymbols::usage = "Symbols in a package to ignore when FixApplicationSymbolsLinks is applied to a directory.";
$IncludedApplicationSymbols::usage = "Symbols in a package to recognize when FixApplicationSymbolsLinks is applied to a directory.";
FixApplicationSymbolsLinks::usage = "FixApplicationSymbolsLinks[dir], where dir is a directory of application notebooks such as reference pages or tutorials, adds button data as needed to buttons with button content in $IncludedApplicationSymbols if $IncludedApplicationSymbols =!= {} or does the same thing with Complement[Names[$ApplicationName<>\"`*\"], $ExcludedApplicationSymbols] or Complement[Names[$ApplicationName <> \"`*`*\"], $ExcludedApplicationSymbols]. In addition FixApplicationSymbolsLinks will remove the button wrapper around symbols in $ExcludedApplicationSymbols. The modified notebooks are created inside $ApplicationSymbolsLinkFixDirectory <> \"NotebooksWithModifiedButtons\".";

CycleNotebookSelection::usage =
"CycleNotebookSelection[] cyclically selects among the open notebooks.
Options:
\t\"Clickable\" -> (True | False)
\t\tCycle only among \"clickable\" notebooks (WindowClickSelect -> True.)
\t\"Visible\" -> (True | False)
\t\tCycle only among visible notebooks (Visible -> True).";

TraditionalFormSelectionConvert::usage = "Converts string equations that are selected into inline TraditionalForm cells.";


FunctionPageForSymbol::usage =
"FunctionPageForSymbol[symbol_String] generates a (proto) function page for
'symbol', based off its usage message, Options values, etc.";

FunctionPageForSymbol::notemplate =
"WARNING:  The \"TemplateFile\" option specified
\t`1`
does not exist as either an absolute file path or a path relative to the
TextResources subdirectory
\t`2`
Using default template
\t`3`
instead.";

CopyExample::usage =
"Copies the selected example cell(s), translating to \"newdocs\" styles.
Drops most explicit options, except for CellLabels of In/Out cells.";


FileSelectorDialog::usage =
"FileSelectorDialog[title_String, OKlabel_String, OKaction_] creates a
multiple file selector dialog, with a dialog window 'title' and an OK
button with the specified label and action.  Overall design is two
side-by-side panels:  a directory listing on the left and a list of
selected files on the right.  Filenames in the listings are buttons which,
when clicked, move the file to the other list.  List of selected files is
returned in the global variable $SelectedFiles. FileSelectorDialog[title_String,
inputfieldlabel_String, OKlabel_String, OKaction_] also contains an input
field with label inputfieldlabel.";

$SelectedFiles::usage =
"List of selected files returned by FileSelectorDialog.";

$Directory::usage =
"Current directory as selected by FileSelectorDialog.";

$FileSelectorDialogFieldInput::usage = "Global variable used by the 4 argument form of FileSelectorDialog.";

SourceBrowser::usage =
"SourceBrowser[options___] creates a file browser with filtering features.
Filenames in the listings are buttons which, when clicked, select or
deselect the file (more than one file can be selected).  List of selected
files is returned in the global variable $SelectedFiles.

Options:
  \"Title\" -> _String
    ...Dialog title.
  \"OKlabel\" -> _String
    ...Label for the \"OK\" button.
  \"OKaction\" -> _Function
    ...Action to perform when \"OK\" button clicked.
  \"VersionInitial\" -> (All | {__String})
    ...Initial version filter settings.
  \"StatusInitial\" -> (All | {__String})
    ...Initial status filter settings.  Recognized status settings are:
      \"None\", \"Obsolete\", \"Internal\", \"Temporary\", \"Future\",
      \"AwaitingFutureDesignReview\", \"Preview\", \"Excised\"";

SourceBrowse::usage = 
"Shortcut form of activating source browser with preconfigured parameters.
Currently takes string of document type as first argument, and string of 
version number as second."

GenerateOverviewDialog::usage =
"GenerateOverviewDialog[] creates a dialog for generating a tutorial
Overview.  Selection of files to include in the overview is done via
FileSelectorDialog.";
GenerateOverviewFromList::usage = "Button function used by the Generate Overview Dialog."; 

CreateRegularizedRefGuide::usage = "CreateRegularizedRefGuide[refguidepath] produces a regularized refguide from one that has the structure of the Geometrica RefGuide. The result is then suitable for running DivideRefGuide on.";

$RefGuidePath::usage = "File path of an applications refguide.";
DivideRefGuide::usage = "DivideRefGuide[] opens a dialog for dividing an open refguide into reference pages or if no input refguide is open, opens a file chooser for choosing a refguide after which a dialog for dividing the refguide is opened.";
CancelCreateReferencePagesFromRefGuideDialogVariables::usage = "Cancel function for the DivideRefGuide dialog.";
CreateReferencePagesFromRefGuide::usage = "CreateReferencePagesFromRefGuide[refguide] creates reference pages corresponding to refguide which is a refguide path inside DirectoryName[refguide] <> \"ReferencePages\".";

(*
ConvertApplicationRefGuideEntry::usage = "For applications.";
ExportApplicationRefGuideEntry::usage = "For applications.";
ExportApplicationRefGuideEntryNotebooks::usage = "Similar to ExportRefGuideEntryNotebooks, but for applications.";
ForceImport::usage = "option for ParseRefGuide[\"f\"] that forces it to reimport the file.  See also imported" 

$FunctionNames::usage = "list of all function names in the RefGuide.nb"


imported::usage = "imported[filename] is True when filename has been imported.  set to False if you want to import the same file again"
*)
MergeRefGuideNotebooks::usage = "MergeRefGuideNotebooks[listofnbpaths, outnbpath] merges a list of nbs into one.";
(*
ParseApplicationRefGuide::usage = "Similar to ParseRefGuide, but for appliactions.";
RefGuide::usage = "Option for the *RefGuideEntry* functions.  Tells you what RefGuide file you want to use if it hasn't already been loaded by ParseRefGuide[]."
$Application::usage = "Application name.";

$DocEntry::usage = "$DocEntry[thing] is a Cell template for the new Help browser format for\
 the section thing.  You can only change the hardcoded ones.  See the code for what that\
 means.  Everything else is defined during ConvertApplicationRefGuideEntry[]." *)

(* $DocEntry entries *)
(*category;
keywords;
status;
usagemessages;
history;
templates;
allowableopts;
attributes;
errormessages;
title;
usage;
notes;
examples;
seealso;
tutorials;
legacy;
relatedlinks;
appnotes;
designdisc;
packages;
content;
maincomplex;
windowTitler;*)

Begin["`Private`"]


$CVSRevision = " $Id: DocumentationTools.m,v 1.58 2013/10/29 20:40:42 jayw Exp $ "

$LoadedDocuTools = "DocuTools"


NotebookID[] := ToFileName[ ReplaceAll["FileName", NotebookInformation[]]]
                                    
OldNotebookRead[nb_]:= NotebookRead[nb, "WrapBoxesWithBoxData" -> True]

Unprotect[System`OpenBrowse]
Clear[System`OpenBrowse]
System`OpenBrowse[] := SystemDialogInput["FileOpen"]
System`OpenBrowse[loc_] := SystemDialogInput["FileOpen", loc]
System`OpenBrowse[loc_, filters_] :=
 SystemDialogInput["FileOpen", {loc, filters}]
Protect[System`OpenBrowse]
                                    
SetAttributes[MessageToConsole, HoldFirst]

MessageToConsole[symbolWithValue_, values___] :=
 Module[{presetMessageOptionsValues, newMessageOptionsValues, cs},
        (* Get current MessageOptions to restore after message is sent to console. *)
        presetMessageOptionsValues = MessageOptions /. Options[$FrontEnd, MessageOptions];
        
        (* New MessageOptions has "KernelMessageAction" with "PrintToConsole". *)
        newMessageOptionsValues = If[(cs = Cases[presetMessageOptionsValues, a : ("KernelMessageAction" -> _)]; cs) === {}, 
                                  Append[presetMessageOptionsValues, "KernelMessageAction" -> {"Beep", "PrintToNotebook"}],
        presetMessageOptionsValues /. ("KernelMessageAction" -> a_) :> ("KernelMessageAction" -> 
                  If[StringQ[a],"PrintToConsole", Append[DeleteCases[a,"PrintToNotebook"],"PrintToConsole"]])]; 
        SetOptions[$FrontEnd, MessageOptions -> newMessageOptionsValues]; 
        Message[symbolWithValue, values];
        SetSelectedNotebook[MessagesNotebook[]];
        (* Restore previous MessageOptions. *)
        SetOptions[$FrontEnd, MessageOptions -> presetMessageOptionsValues]]



DocumentTemplate[ file_String] :=
  NotebookPut[Get[ToFileName[{$DocuToolsDir, "FrontEnd", "TextResources"}, file]] /. "DocumentationTools`$MVersion" -> DocumentationTools`$MVersion]

DocumentTemplate[ file_String, "Open"] :=
  NotebookOpen[ ToFileName[{$DocuToolsDir, "FrontEnd", "TextResources"}, file]]

DocumentSample[ file_String] :=
  NotebookOpen[ToFileName[{$DocuToolsDir, "FrontEnd", "TextResources"}, file]]

AuxiliaryPalette[ file_String] :=
  NotebookOpen[ToFileName[{$DocuToolsDir, "FrontEnd", "TextResources"}, file]]
    
NotebookDirectoryOpen[ path_String:""] := If[# =!= $Canceled,
                                            If[ StringMatchQ[ #, "*.nb"],
                                              NotebookOpen[#]
                                              ]] & [ OpenBrowse[ path]]


DoubleUsageLinesInsert::badcell = "Cursor must be within a Usage cell.";
DoubleUsageLinesInsert::badpos = "Cursor position must be before, after, or within an existing usage text line, not within inline cells nor a selection spanning any content.";

DoubleUsageLinesInsert[] := Module[{nb = InputNotebook[], selPos, inlinePos, cellSty, nextPosModInfo},
       
       If[ CellInfo[ nb] === $Failed,
         MessageToConsole[ DoubleUsageLinesInsert::badcell];
         Abort[]];
       
       If[ ("CursorPosition" /. CellInfo[ nb]) === {"CellBracket"},
         FrontEndTokenExecute[ nb, "MoveNext"]];
       
       selPos = Flatten @ ("CursorPosition" /. CellInfo[ nb]);
       inlinePos = ("InlineCellPosition" /. CellInfo[ nb]) =!= {"InlineCellPosition"};
       cellSty = First @ ("Style" /. CellInfo[ nb]);
       
       FrontEndTokenExecute[ nb, "MoveNext"];
       If[ # =!= $Failed,
         nextPosModInfo = ("Style" /. #) === {"ModInfo"},
         nextPosModInfo = False] & [ CellInfo[ nb]];
       FrontEndTokenExecute[ nb, "MovePrevious"];
       
       Which[
         inlinePos,
           MessageToConsole[ DoubleUsageLinesInsert::badpos];
           Abort[],
         cellSty =!= "Usage",
           MessageToConsole[ DoubleUsageLinesInsert::badcell];
           Abort[],
         !SameQ @@ selPos,
           MessageToConsole[ DoubleUsageLinesInsert::badpos];
           Abort[],
         nextPosModInfo,
           NotebookWrite[ nb,
             TextData[{ Cell["      ", "ModInfo"],
                        Cell[BoxData[ RowBox[{"XXXX", "[", "]"}]], "InlineFormula"],
                        "\[LineSeparator]XXXX", 
                        "\n"}]],
         True,
           NotebookWrite[ nb,
             TextData[{
               "\n", 
               Cell["      ", "ModInfo"], 
               Cell[BoxData[ RowBox[{"XXXX", "[", "]"}]], "InlineFormula"],
               "\[LineSeparator]XXXX"}]]
         ];
         
       FrontEndExecute[{
         FrontEnd`FrontEndToken[ nb, "MovePreviousWord"],
         FrontEnd`FrontEndToken[ nb, "MovePreviousWord"],
         FrontEnd`FrontEndToken[ nb, "MoveNextWord"],
         FrontEnd`FrontEndToken[ nb, "MovePrevious"],
         FrontEnd`FrontEndToken[ nb, "SelectPrevious"],
         FrontEnd`FrontEndToken[ nb, "SelectPrevious"],
         FrontEnd`FrontEndToken[ nb, "SelectPreviousWord"]}]

       ]
       
       
UsageLineAdd::noin = "There is no open input notebook.";
UsageLineAdd::betwcells = "The cursor is between cells or not inside an input notebook.";
UsageLineAdd::cellbrac = "The cursor is at the cell bracket but should be inside a usage cell.";
UsageLineAdd::mulcell = "Multiple cells have been selected.";
UsageLineAdd::notusage = "The cursor is not in a usage cell.";

UsageLineAdd[] := 
 Module[{nb = InputNotebook[], ci, a, style, ReadPart, pos, re, UsageWithAddedLine},
  Catch[If[(* There is no input notebook.*) nb === $Failed, 
           Throw[MessageToConsole[UsageLineAdd::noin]]];
           
        ci = CellInfo[nb];
        
        If[(* The cursor is between cells or not inside an input notebook. *)
           ci === $Failed, Throw[MessageToConsole[UsageLineAdd::betwcells]]];
           
        If[(* The cursor is at the cell bracket. *)("CursorPosition" /. ci) === {"CellBracket"}, 
           Throw[MessageToConsole[UsageLineAdd::cellbrac]]];
           
        If[multipleCellBracketsSelected[ci], 
           Throw[MessageToConsole[UsageLineAdd::mulcell]]];
           
        If[(* The cursor is inside a ModInfo cell. *)("Style" /. ci) === {"ModInfo"} && NotebookRead[nb] === {}, 
           SelectionMove[nb, All, Cell];
           FrontEndExecute[{FrontEndToken[nb, "MoveNext"]}]];
           
        If[(* The cursor is selecting part of a ModInfo cell. *)
           MatchQ[NotebookRead[nb], Cell[_, "ModInfo", ___]], 
           FrontEndExecute[{FrontEndToken[nb, "MoveNext"]}]]; 
           ci = CellInfo[nb];
           If[Cases[ci, a : ("InlineCellPosition" -> _), Infinity] =!= {},
              While[(*The cursor is in an inline cell.*)
                    Cases[ci, a : ("InlineCellPosition" -> _), Infinity] =!= {}, 
                    FrontEndExecute[{FrontEnd`FrontEndToken[nb, "ExpandSelection"]}];
                    ci = CellInfo[nb]]];
                    
        style = ("Style" /. CellInfo[nb])[[1]];
        
        If[(*The cursor is not in a usage cell.*)style =!= "Usage", 
           Throw[MessageToConsole[UsageLineAdd::notusage]]];
           
        ReadPart = NotebookRead[nb]; 
        If[ReadPart === {}, 
        
           ExpandToCell[nb];
           UsageWithAddedLine = Insert[NotebookRead[nb], 
                                       {Cell["   ", "ModInfo"], 
                                       Cell[TextData[{Cell[BoxData[RowBox[{"XXXX", "[", "]"}]], "InlineFormula"], " \[LineSeparator]XXXX"}]]}, 
                                       {1, 1, 1, -1}] /. ("Rows" -> r_) :> ("Rows" -> Insert[r, None, -1]),
                                       
           NotebookWrite[nb, "ToReplace"]; 
           SelectionMove[nb, All, Cell]; 
           re = NotebookRead[nb]; 
           pos = Position[re[[1, 1, 1]], {_, "ToReplace"}][[1, 1]]; 
           UsageWithAddedLine = Insert[re, 
                                       {Cell["   ", "ModInfo"], 
                                        Cell[TextData[{Cell[BoxData[RowBox[{"XXXX", "[", "]"}]], "InlineFormula"], " \[LineSeparator]XXXX"}]]}, 
                                       {1, 1, 1, pos + 1}] /. {"ToReplace" -> ReadPart, ("Rows" -> r_) :> ("Rows" -> Insert[r, None, pos + 1])}];
                                       
        NotebookWrite[nb, UsageWithAddedLine, All]]]


BannerInsert::badtarget = "Insertion of banner template is limited to guide pages.";
BannerInsert::missingobject = "Banner template must precede an GuideTitle cell.";

BannerInsert[] := Module[ {nb = InputNotebook[], styDef, tmplExp},
  styDef  = Options[ nb, StyleDefinitions];
  tmplExp = Cell[BoxData[
               ButtonBox[
                  GraphicsBox[
                  {EdgeForm[GrayLevel[0]], FaceForm[GrayLevel[1]], 
                   RectangleBox[{0, 0}, {1, 0.135}], InsetBox[
                     StyleBox["\<\"Replace this with your product branding artwork.\"\>",
                       FontFamily->"Verdana",
                       FontSize->14], {0.5, 0.08}], 
                   InsetBox[
                     StyleBox["\<\"Use a bitmap image 742 x 100 pixels.\"\>",
                       FontFamily->"Verdana",
                       FontSize->11,
                       FontColor->GrayLevel[0.5]], {0.5, 0.055}]},
                   ImageSize->780],
                 Active->False,
                 BaseStyle->{Editable -> True},
                 ButtonFrame->None]], "BannerImage"];      
  If[ FreeQ[ styDef, "GuidePageStyles.nb"],
    MessageToConsole[ BannerInsert::badtarget],
   (SetOptions[ $FrontEnd, FindSettings -> {"Wraparound" -> True}];
    If[ $Failed === NotebookFind[ nb, "GuideTitle", Next, CellStyle],
      MessageToConsole[ BannerInsert::missingobject],
      FrontEndExecute[{
        SelectionMove[ nb, Before, Cell],
        FrontEnd`FrontEndToken[ nb, "MovePrevious"],
        NotebookWrite[ nb, tmplExp] }]
      ])]
  ]



$PathElement = (_String | {_String, (_Integer?Positive | Infinity)});
$PathPattern = {$PathElement...};

FindFileOnPath::badfile = "file_ (1st arg) must be a string.";
FindFileOnPath::badpath = "path_ (2nd arg) must match " <>
  ToString[$PathElement] <> " or a list of same.";

FindFileOnPath[file_String, path : $PathPattern] :=
  Flatten[
    FileNames[file, Sequence @@ Flatten[{#}]]& /@ path
  ];

FindFileOnPath[file_String, path : $PathElement] :=
  FindFileOnPath[file, {path}];

FindFileOnPath[_, ($PathPattern | $PathElement)] := 
  MessageToConsole[FindFileOnPath::badfile];

FindFileOnPath[_String, ___] :=
  MessageToConsole[FindFileOnPath::badpath];




ForceDelete::noin = "There is no input notebook.";
ForceDelete::stylesht = "There is no external stylesheet.";
ForceDelete::betwcells = "The cursor is between cells or not inside an input notebook.";
ForceDelete::empty = "The selection is empty.";

ForceDelete[] := Module[{stylesheetpath, nb, ci, re, re2}, 
        nb = InputNotebook[];
        Catch[
          If[ nb === $Failed,     (* There is no input notebook. *)
            Throw[ MessageToConsole[ ForceDelete::noin]]];
          styledef = Options[ nb, StyleDefinitions]; 
          If[ Not @ MatchQ[ styledef, {StyleDefinitions -> _, ___}], 
            Throw[ MessageToConsole[ ForceDelete::stylesht]]];
          ci = DocuTools`CellInfo[ nb];
          If[ ci === $Failed,     (* The cursor is between cells. *)
            Throw[ MessageToConsole[ ForceDelete::betwcells]]];
          If[Not@MatchQ[("CursorPosition" /. ci), {{___, a_Integer, b_Integer}} /; a =!= b],
             Throw[ MessageToConsole[ ForceDelete::empty]]];

          Which[
            MatchQ[ styledef, {StyleDefinitions -> Notebook[__], ___}],
              SetOptions[ nb, StyleDefinitions -> (styledef[[1, 2]] /. (Deletable -> _) -> (Deletable -> True))],
            MatchQ[ styledef, {StyleDefinitions -> FrontEnd`FileName[{_}, _String, ___]}],
              SetOptions[ nb, StyleDefinitions -> 
                                 Notebook[{Cell[ StyleData[StyleDefinitions -> Cases[styledef, FrontEnd`FileName[{"Wolfram"}, __], Infinity][[1]]]], 
                                   Cell[ StyleData["ModInfo"], Deletable -> True, CellSize -> {22, 12}, 
                                     StyleMenuListing -> None, FontFamily -> "Verdana", 
                                     FontSize -> Inherited 0.9, FontWeight -> "Plain", 
                                     FontColor -> RGBColor[0.269993, 0.308507, 0.6]], 
                                   Cell[StyleData["TableText"], Deletable -> True, 
                                     StyleMenuListing -> None, FontFamily -> "Verdana", 
                                     FontSize -> Inherited 0.952]}]]
            ];
      re = OldNotebookRead[nb];
      Which[ 
        MatchQ[re, _String],
          Null,
        Not@MatchQ[re, {Cell[_String, "ModInfo"], __}],
         (FrontEndExecute[{FrontEnd`FrontEndToken[nb, "SelectPrevious"]}];
          re2 = OldNotebookRead[nb];
          If[ Not@MatchQ[Complement[re2, re], {Cell[_String, "ModInfo"]}], 
            FrontEndTokenExecute["SelectNext"]])
         ];
       NotebookWrite[nb, "", All];   (* Hack to get deletion to work first time, synchronization issue *)
       NotebookDelete[ nb];
       If[("Style" /. CellInfo[nb]) === {"Usage"},
             FrontEndExecute[{FrontEnd`FrontEndToken[nb, "SelectNext"]}];
             If[ValueQ[re2] && MatchQ[Complement[re2, re], {Cell[_String, "ModInfo"]}], 
                FrontEndExecute[{FrontEnd`FrontEndToken[nb, "SelectNext"]}]];
             If[MemberQ[{"\n", " \n"}, OldNotebookRead[nb]], 
                NotebookDelete[nb], 
            FrontEndExecute[{FrontEnd`FrontEndToken[nb, "MovePrevious"]}];
            FrontEndExecute[{FrontEnd`FrontEndToken[nb, "SelectNext"]}]; 
            If[MemberQ[{"\n", " \n"}, OldNotebookRead[nb]], 
               NotebookDelete[nb], 
               FrontEndExecute[{FrontEnd`FrontEndToken[nb, "MoveNext"]}]]]];
          SetOptions[ nb, StyleDefinitions -> styledef[[1, 2]]]
          ]]





(* Auxiliary functions for FunctionLink: *)

tableStyleQ[z_] := MatchQ["Style" /. z, {x_ /; StringMatchQ[x, Alternatives @@ $AcceptableTableStyles]}]

inlineStyle[x_] := Module[{cs}, (cs = ("Style" /. x); If[MatchQ[cs, {_String}], cs[[1]], "InlineFormula"])]

getString[x_] := Module[{cs}, cs = Cases[x, _String, {0, Infinity}]; If[cs =!= {}, cs[[1]], Abort[]]]

IdentifyAndWriteButtonIfString[re_, nb_] := 
 Which[StringQ[re], 
       NotebookWrite[nb, TextData[ButtonBox[re, BaseStyle -> "Link"]]];
       FrontEndExecute[{FrontEnd`FrontEndToken[nb, "MoveNext"]}], 
       MatchQ[re, ButtonBox[_String, __]], 
       FrontEndExecute[{FrontEnd`FrontEndToken[nb, "MoveNext"], FrontEnd`FrontEndToken[nb, "MoveNext"]}]]

(* The following will need error handling, as per usage message: *)

FunctionLink::reposcur = "An error has occurred. Reposition the cursor and try again.";

FunctionLink[linkstyle_String] := 
 Module[{nb = InputNotebook[], ci, re, str, re1, ci2, st},
 
  ci = CellInfo[nb];
  
  Which[ci === $Failed,
  
        Abort[],
        
        ("CursorPosition" /. ci) === {"CellBracket"} && ("Style" /. ci) === {"InlineGuideFunction"},
        
        CellFunctionApply[ButtonBox[#, BaseStyle -> linkstyle] &, "Notebook" -> nb], 
        
        True,
        
        If[(* Cursor all the way to the left in a table. *)
        
           tableStyleQ[ci] && ("CursorPosition" /. ci) === {{0, 0}}, 
           Abort[]];
           
        re = OldNotebookRead[nb];
           
        If[(*If something is selected we reduce it to the case where nothing is selected.*)
        
           re =!= {}, 
           FrontEndExecute[{FrontEnd`FrontEndToken[nb, "MoveNext"]}]; 
           ci = CellInfo[nb]];
           
        Which[(* Cursor is at {0, 0}, not in an inline cell and not in a table cell. *)
        
              Not@tableStyleQ[ci] && ("CursorPosition" /. ci) === {{0, 0}} && (("ContentData" /. ci) === {TextData} || 
              ("ContentData" /. ci) === {BoxData}) && 
                                                     ("Style" /. ci) =!= {"TableText"} && FreeQ[ci, "InlineCellPosition"],
              
              FrontEndExecute[{FrontEnd`FrontEndToken[nb, "MoveNext"]}]; 
              ci2 = CellInfo[nb];
              
              Which[(* In inline cell. *)
              
                    MatchQ["InlineCellPosition" /. ci2, {{_Integer}}] && ("ContentData" /. ci2) === {BoxData},
                    
                    st = inlineStyle[ci2]; 
                    FrontEndExecute[{FrontEnd`SelectionMove[nb, All, Word]}]; 
                    re1 = OldNotebookRead[nb]; 
                    NotebookWrite[nb, Cell[BoxData[ButtonBox[re1[[1]], BaseStyle -> linkstyle]], st], All];
                    FrontEndExecute[{FrontEnd`FrontEndToken[nb, "MoveNext"]}],
                    
                    (* In text or string BoxData. *)
                    
                    Not@MatchQ["InlineCellPosition" /. ci2, {{_Integer}}] && 
                     (("ContentData" /. ci2) === {TextData} || ("ContentData" /. ci2) === {BoxData}),
                    
                    FrontEndExecute[{FrontEnd`FrontEndToken[nb, "MovePrevious"]}]; 
                    FrontEndExecute[{FrontEnd`SelectionMove[nb, All, Word]}]; 
                    re = OldNotebookRead[nb]; 
                    Which[StringQ[re], 
                          NotebookWrite[nb, Cell[BoxData[ButtonBox[re, BaseStyle -> linkstyle]], "InlineFormula"], All]; 
                          FrontEndExecute[{FrontEnd`FrontEndToken[nb, "MoveNext"]}],
                          MatchQ[re, BoxData[_String]], 
                          NotebookWrite[nb, MapAt[ButtonBox[#, BaseStyle -> linkstyle] &, re, {1}], All]; 
                          FrontEndExecute[{FrontEnd`FrontEndToken[nb, "MoveNext"]}]]],
                       
              (* Cursor not in a table. *)
              
              Not@tableStyleQ[ci] && ("Style" /. ci) =!= {"TableText"},
              
        Catch[Which[(* Cursor was in a text cell and in an inline cell. *)
              
                    MatchQ["InlineCellPosition" /. ci, {{_Integer}}] && ("ContentData" /. ci) === {BoxData},
                    
                    st = inlineStyle[ci]; 
                    FrontEndExecute[{FrontEnd`SelectionMove[nb, All, Word]}];
                    If[(* To get around bug 59384 *)
                       OldNotebookRead[nb] === {}, 
                       FrontEndExecute[{FrontEnd`FrontEndToken[nb, "ExpandSelection"]}]];
                    If[(* This situation arises when a word among several was initially selected in an inline cell. *)
                       OldNotebookRead[nb] === BoxData[" "], 
               FrontEndExecute[{FrontEnd`FrontEndToken[nb, "MovePrevious"]}]; 
                       FrontEndExecute[{FrontEnd`FrontEndToken[nb, "SelectPreviousWord"]}]];
                    re1 = OldNotebookRead[nb]; 
                    NotebookWrite[nb, Cell[BoxData[ButtonBox[re1[[1]], BaseStyle -> linkstyle]], st], All];
                    FrontEndExecute[{FrontEnd`FrontEndToken[nb, "MoveNext"]}],
                    
                    (* Cursor was inside text. *)
                    
                    Not@MatchQ["InlineCellPosition" /. ci, {{_Integer}}] && ("ContentData" /. ci) === {TextData},
                    
                    FrontEndExecute[{FrontEndToken[nb, "MovePrevious"]}];
                    FrontEndExecute[{FrontEnd`SelectionMove[nb, All, Word]}]; 
                    re = OldNotebookRead[nb];
                    
                    Which[StringQ[re],
                    
                          NotebookWrite[nb, Cell[BoxData[ButtonBox[re, BaseStyle -> linkstyle]], "InlineFormula"], All]; 
                          FrontEndExecute[{FrontEnd`FrontEndToken[nb, "MoveNext"]}],
                          
                          MatchQ[re, BoxData[_String]], 
                          
                          FrontEndExecute[{FrontEnd`FrontEndToken[nb, "MoveNext"]}];
                          FrontEndExecute[{FrontEnd`FrontEndToken[nb, "MovePrevious"]}];
                          ci2 = CellInfo[nb];
                          st = inlineStyle[ci2];
                          FrontEndExecute[{FrontEnd`SelectionMove[nb, All, Word]}];
                          NotebookWrite[nb, Cell[BoxData[ButtonBox[re[[1]], BaseStyle -> linkstyle]], st], All];
                          FrontEndExecute[{FrontEnd`FrontEndToken[nb, "MoveNext"]}];
                          If[(* Might be needed because of bug 59384. *)
                             MatchQ[CellInfo[nb], {{"InlineCellPosition" -> {_}, __}}], 
                             FrontEndExecute[{FrontEnd`FrontEndToken[nb, "MoveNext"]}]],
                             
                          MatchQ[re, StyleBox[_String, __]],
                          
                          NotebookWrite[nb, 
                                        TextData[Cell[BoxData[MapAt[ButtonBox[#, BaseStyle -> linkstyle] &, re, {1}]], 
                                                      "InlineFormula"]], All];
                          FrontEndExecute[{FrontEnd`FrontEndToken[nb, "MoveNext"]}]],
                             
                    (* Cursor inside BoxData cell but not in a table. *)
                    
                    ((Not@MatchQ["InlineCellPosition" /. ci, {{_Integer}}] && ("ContentData" /. ci) === {BoxData}) || 
                     (MatchQ["InlineCellPosition" /. ci, {{_Integer}}] && inlineStyle[ci] =!= "TableText")) && 
                                                                                                        Not@tableStyleQ[ci],
                     
                    ci2 = CellInfo[nb];
                    If[FreeQ[ci2, "InlineCellPosition"], 
                       FrontEndExecute[{FrontEndToken[nb, "MovePrevious"]}]; 
                       ci2 = CellInfo[nb]];
                    If[ci2 =!= $Failed && FreeQ[ci2, "InlineCellPosition"], 
                       FrontEndExecute[{FrontEndToken[nb, "MovePrevious"]}]; 
                       ci2 = CellInfo[nb]];
                    If[ci2 =!= $Failed && Not@FreeQ[ci2, "InlineCellPosition"], 
                       FrontEndExecute[{FrontEnd`SelectionMove[nb, All, Word]}];
                       re = OldNotebookRead[nb];
                       
                       (* Special handling for style "ExampleSubsection" and structures of a special form. *)
                       
                       If[("Style" /. ci2) === {"ExampleSubsection"} && 
                           (StringQ[re] || 
                    MatchQ[re, BoxData[Cell[_String, "ExampleSubsection"]]] || 
                    MatchQ[re, BoxData[InterpretationBox[Cell[_String, "ExampleSubsection"], $Line = 0;]]]),
                    
                Which[StringQ[re], 
                      Do[FrontEndExecute[{FrontEndToken[nb, "ExpandSelection"]}], {2}], 
                      MatchQ[re, BoxData[Cell[_String, "ExampleSubsection"]]], 
                      FrontEndExecute[{FrontEndToken[nb, "ExpandSelection"]}]];
                      
                Throw[Which[MatchQ[(re = OldNotebookRead[nb]), 
                                   BoxData[InterpretationBox[Cell[_String, "ExampleSubsection"], $Line = 0;]]], 
                            NotebookWrite[nb, 
                   re /. (BoxData[InterpretationBox[Cell[a_, "ExampleSubsection"], $Line = 0;]] :> 
        BoxData[InterpretationBox[Cell[BoxData[ButtonBox[a, BaseStyle -> lk]], "InlineFormula"], ($Line = 0; Null)]] /. 
                                          lk -> linkstyle), All], 
                            MatchQ[re, BoxData[InterpretationBox[Cell[BoxData[ButtonBox[_String, 
                                                                                        BaseStyle -> _]], 
                                                                      "InlineFormula"], $Line = 0;]]], 
                            Return[], 
                            True, 
                                    MessageToConsole[FunctionLink::reposcur]]]];
                       
                       IdentifyAndWriteButtonIfString[re, nb],
                       
                       If[(* Cursor had for example been to the right of a BoxData string. *)
                          ("ContentData" /. ci2) === {BoxData}, 
                          Do[FrontEndExecute[{FrontEndToken[nb, "MoveNext"]}], {2}]; 
                          FrontEndExecute[{FrontEnd`SelectionMove[nb, All, Word]}]; 
                          re = OldNotebookRead[nb];
                          
                          Which[MatchQ[re, BoxData[_String]],
                          
                                NotebookWrite[nb, 
                                           Cell[BoxData[ButtonBox[re[[1]], BaseStyle -> linkstyle]], 
                                                inlineStyle[ci2]], All];
                                FrontEndExecute[{FrontEnd`FrontEndToken[nb, "MoveNext"]}],
                                
                                MatchQ[re, BoxData[StyleBox[_String, __]]],
                                
                                NotebookWrite[nb, 
                 MapAt[ButtonBox[#, BaseStyle -> linkstyle] &, re, {1, 1}], All];
                                FrontEndExecute[{FrontEnd`FrontEndToken[nb, "MoveNext"]}]]]];
                       
                    If[ci2 === $Failed, 
                       FrontEndExecute[{FrontEnd`FrontEndToken[nb, "MoveNext"], 
                                        FrontEnd`FrontEndToken[nb, "MoveNext"]}]; 
                       ci2 = CellInfo[nb]; 
                       If[Not@FreeQ[ci2, "InlineCellPosition"], 
                          FrontEndExecute[{FrontEnd`SelectionMove[nb, All, Word]}];
                          re = OldNotebookRead[nb]; 
                          IdentifyAndWriteButtonIfString[re, nb], 
                          FrontEndExecute[{FrontEnd`FrontEndToken[nb, "MoveNext"]}]; 
                          ci2 = CellInfo[nb]; 
                          If[Not@FreeQ[ci2, "InlineCellPosition"], 
                             FrontEndExecute[{FrontEnd`SelectionMove[nb, All, Word]}];
                             re = OldNotebookRead[nb]; 
                             IdentifyAndWriteButtonIfString[re, nb]]]]]], 
                          
              (* Cursor was in a table. *)
              
              True,
              
              Which[(* Cursor left of upper left element of table. *)
              
                    tableStyleQ[ci] && ("ContentData" /. ci) === {BoxData} && ("CursorPosition" /. ci) === {{1, 1}},
                    
                    FrontEndExecute[{FrontEnd`FrontEndToken[nb, "MoveNext"]}]; 
                    ci2 = CellInfo[nb]; 
                    If[FreeQ[ci2, "InlineCellPosition"], 
                       FrontEndExecute[{FrontEnd`FrontEndToken[nb, "MovePrevious"]}]; 
                       FrontEndExecute[{FrontEnd`SelectionMove[nb, All, Word]}]; 
                       re = OldNotebookRead[nb];
                       
                       If[MatchQ[re, BoxData[StyleBox[_String, __]]], 
                  NotebookWrite[nb, 
                                MapAt[ButtonBox[#, BaseStyle -> linkstyle] &, re, {1, 1}], All];
                          FrontEndExecute[{FrontEnd`FrontEndToken[nb, "MoveNext"]}]; Abort[]];
                       
                       If[Not@MatchQ[re, BoxData[_String]], Abort[]];
                       
                       str = getString[re]; 
                       NotebookWrite[nb, TextData[ButtonBox[str, BaseStyle -> linkstyle]], All]; 
                       FrontEndExecute[{FrontEnd`FrontEndToken[nb, "MoveNext"]}]],
                       
                    (* Cursor in table but not in inline cell. *)
                    
                    tableStyleQ[ci] && ("ContentData" /. ci) === {BoxData} && ("CursorPosition" /. ci) =!= {{1, 1}} && 
                                                                                       FreeQ[("Style" /. ci), "TableText"],
                    
                    FrontEndExecute[{FrontEnd`FrontEndToken[nb, "MoveNext"]}]; 
                    ci2 = CellInfo[nb];
                    
                    Do[FrontEndExecute[{FrontEnd`FrontEndToken[nb, "MovePrevious"]}], {2}]; 
                    If[(* So cursor was to the right and outside of an element in the third column of a table. *)
                    
                       MatchQ[CellInfo[nb], {{"InlineCellPosition" -> {_}, "Style" -> "TableText", __}}],
                       
               FrontEndExecute[{FrontEnd`SelectionMove[nb, All, Word]}]; 
               re = OldNotebookRead[nb]; 
               If[StringQ[re], 
                  NotebookWrite[nb, Cell[BoxData[ButtonBox[re, BaseStyle -> linkstyle]], "InlineFormula"], All]; 
                  FrontEndExecute[{FrontEnd`FrontEndToken[nb, "MoveNext"]}]],
                  
                          Do[FrontEndExecute[{FrontEnd`FrontEndToken[nb, "MoveNext"]}], {2}];
                          If[FreeQ[ci2, "InlineCellPosition"],
                    
                             FrontEndExecute[{FrontEnd`FrontEndToken[nb, "MovePrevious"]}]; 
                             (*FrontEndExecute[{FrontEnd`FrontEndToken[nb, "ExpandSelection"]}];*)
                             FrontEndExecute[{FrontEnd`FrontEndToken[nb, "SelectPreviousWord"]}];
                             re = OldNotebookRead[nb];
                             If[(* This happens when a part of a plain text element of a table was selected originally
                                   and when it was created it became part of a row box. *)
                                re === BoxData[" "], 
                    FrontEndExecute[{FrontEnd`FrontEndToken[nb, "MovePrevious"]}]; 
                    re = OldNotebookRead[nb]];
                             If[(* Case where cursor was initially outside of an inline cell in last column of table. *)
                                re === {}, 
                                FrontEndExecute[{FrontEnd`FrontEndToken[nb, "SelectPreviousWord"]}]];
                                
                             re = OldNotebookRead[nb];
                             
                             If[MatchQ[re, BoxData[StyleBox[_String, __]]], 
                    NotebookWrite[nb, 
                                  MapAt[ButtonBox[#, BaseStyle -> linkstyle] &, re, {1, 1}], All];
                                FrontEndExecute[{FrontEnd`FrontEndToken[nb, "MoveNext"]}]; Abort[]];
                             
                             If[Not@MatchQ[re, BoxData[_String] | _String], Abort[]]; 
                             str = getString[re]; 
                             NotebookWrite[nb, TextData[ButtonBox[str, BaseStyle -> linkstyle]], All]; 
                             FrontEndExecute[{FrontEnd`FrontEndToken[nb, "MoveNext"]}],
                       
                             If[(* The cursor has moved into a "TableText" cell. *)
                                Not@FreeQ[("Style" /. ci2), "TableText"], 
                                FrontEndExecute[{FrontEnd`SelectionMove[nb, All, Word]}]; 
                                re = OldNotebookRead[nb]; 
                                If[StringQ[re], 
                                   NotebookWrite[nb, Cell[BoxData[ButtonBox[re, BaseStyle -> linkstyle]], "InlineFormula"], All]; 
                                   FrontEndExecute[{FrontEnd`FrontEndToken[nb, "MoveNext"]}]]]]],
                       
                    (* Cursor left and outside of element in third column of table. *)
                    
                    tableStyleQ[ci] && ("ContentData" /. ci) === {BoxData} && ("CursorPosition" /. ci) =!= {{1, 1}},
                    
                    FrontEndExecute[{FrontEnd`FrontEndToken[nb, "MoveNext"]}]; 
                    ci2 = CellInfo[nb]; 
                    If[(* Moved into inline "TableText" cell *)
                       Not@FreeQ[ci2, "InlineCellPosition"] && ("Style" /. ci2) === {"TableText"}, 
                       FrontEndExecute[{FrontEnd`SelectionMove[nb, All, Word]}]; 
                       re = OldNotebookRead[nb]; 
                       If[StringQ[re], 
                          NotebookWrite[nb, Cell[BoxData[ButtonBox[re, BaseStyle -> linkstyle]], "InlineFormula"], All]; 
                          FrontEndExecute[{FrontEnd`FrontEndToken[nb, "MoveNext"]}]]],
                          
                    (* Cursor inside inline "TableText" cell. *)
                    
                    Not@FreeQ[ci, "InlineCellPosition"] && ("Style" /. ci) === {"TableText"} && 
                                                                                      ("ContentData" /. ci) === {TextData},
                                                                                      
                    FrontEndExecute[{FrontEnd`SelectionMove[nb, All, Word]}]; 
                    re = OldNotebookRead[nb]; 
                    Which[StringQ[re], 
                          NotebookWrite[nb, Cell[BoxData[ButtonBox[re, BaseStyle -> linkstyle]], "InlineFormula"], All]; 
                          FrontEndExecute[{FrontEnd`FrontEndToken[nb, "MoveNext"]}],
                          MatchQ[re, StyleBox[_String, __]],
                          NotebookWrite[nb, 
                                        MapAt[ButtonBox[#, BaseStyle -> linkstyle] &, 
                                              Cell[BoxData[re], "InlineFormula"], {1, 1, 1}], All];
                          FrontEndExecute[{FrontEnd`FrontEndToken[nb, "MoveNext"]}]]]]]]
     
FunctionLink[] := FunctionLink["Link"]

FunctionLink[ "GuideInlineListing"] := Module[{ nb = InputNotebook[]},
       If[ DocumentationTools`CellInfo[ nb] === $Failed, 
        (NotebookWrite[ nb, Cell[ "XXXX . XXXX . ", "InlineGuideFunction"], All];
         SelectionMove[ nb, All, CellContents]), 
        (SelectionMove[ nb, All, Cell];
         DocumentationTools`StyleApply[ "InlineGuideFunction"];
         DocumentationTools`CellFunctionApply[ ButtonBox[ #, BaseStyle -> "Link"]&,
           "Notebook" -> nb])]
       ]


$CellToLinkStyle =
  {
    "RelatedLinks" -> "Link",
    "SeeAlso" -> "Link",
    "Extensions" -> "Link",
    "InlineGuideFunctionListing" -> "Link"
  };

Options[InlineListingToggle] =
  {
    "Notebook" -> Automatic,
      (* Document notebook (default: InputNotebook[]). *)
    "Action" -> "Toggle",
      (* Action to perform:
         "Format"    - Always format
         "Unformat"  - Always unformat
         "Toggle"    - Toggle between the two states
      *)
    "ButtonStyle" -> "Link",
      (* Style for buttons when formatted. *)
    "Delimiter" -> {{" . ", ", ", " ."}, " \[EmptyVerySmallSquare] "},
      (* Delimiters in unformatted and formatted states. *)
    "DocumentPath" :> 
      If[$MathematicaDocs, None, DocumentationTools`$LinkBase <> "/ref"],
      (* Sets paclet:// path in ButtonData. *)
    "TargetStyle" -> None
      (* Style of target notebook:
          None       - No assumption;  use other options.
          _String    - Style of target (with "...PageStyles.nb" removed).
          Automatic  - Get style from stylesheet setting of target.
        NOTE:  Settings other than None override all other options.
      *)
  }

InlineListingToggle[
  cellSty: (_String | Automatic) :"SeeAlso",
  options___?OptionQ
] :=
  Module[
    {
      optNotebook, optAction, btnSty, optDelimiter, docPath,
      optTargetStyle, dlm, dlmSty, nb, nbStyle, info, style
    },
    {optNotebook, optAction, btnSty, optDelimiter, docPath,
    optTargetStyle} =
      {"Notebook", "Action", "ButtonStyle", "Delimiter", "DocumentPath",
      "TargetStyle"}
        /. {options} /. Options[InlineListingToggle];
    {dlm, dlmSty} = ParseDelimiter[optDelimiter];
    If[dlm === $Failed, Return[$Failed]];
    nb =
      If[optNotebook === Automatic,
        InputNotebook[],
        optNotebook
      ];
    If[optTargetStyle =!= None,
      Switch[optTargetStyle,
        "Function" | "Migration" | "HowTo",
          InlineListingToggle["TargetStyle" -> None, options],
        "Guide",
          InlineListingToggle["InlineGuideFunctionListing",
            "TargetStyle" -> None, options],
        "Format",
          InlineListingToggle["DocumentPath" -> "Formats",
            "TargetStyle" -> None, options],
        "Character",
          InlineCharacterListingToggle[],
        _String,
          MessageToConsole[InlineListingToggle::unsuptarg, optTargetStyle];
          Return[$Failed],
        Automatic,
          (* nbStyle = StyleDefinitions /. Options[nb] /. StyleDefinitions -> None
	                /. FrontEnd`FileName[dir_, name_, ___] :> name; *)
	  nbStyle = If[# === {}, {}, #[[1]]] &@Cases[StyleDefinitions /. Options[nb], 
                                                     FrontEnd`FileName[{"Wolfram"}, name_String, ___] :> name, {0, Infinity}];
          If[Head[nbStyle] =!= String
              || ! StringMatchQ[nbStyle, "*PageStyles.nb"],
            MessageToConsole[InlineListingToggle::badsheet];
            Return[$Failed];
          ];
          InlineListingToggle[
            "TargetStyle" -> StringReplace[nbStyle, "PageStyles.nb" -> ""],
            Sequence@@DeleteCases[{options},"TargetStyle"->_]
          ]
      ];
      Return[];
    ];
    info = DocumentationTools`CellInfo[nb];
    Which[
      info === $Failed, (* selection between cells *)
        style = If[cellSty === Automatic, "SeeAlso", cellSty];
        NotebookWrite[nb,
          Cell[ "XXXX" <> dlm[[1]] <> "XXXX" <> dlm[[1]], style], All];
        SelectionMove[nb, All, CellContents];
      ,
      Length[info] > 1,
        MessageToConsole[DocuTools::oversel,
          "InlineListingToggle", "cell"];
        Return[$Failed];
      ,
      ("Style" /. Flatten[{info}]) == "GuideText",
        MessageToConsole[InlineListingToggle::badsel];
        Return[$Failed];
      ,
      True,
        SelectionMove[nb, All, Cell];
        If[cellSty === Automatic
          ,
          style = "Style" /. First[info];
          ,
          style = cellSty;
          DocumentationTools`StyleApply[cellSty];
        ];
        btnSty = style /. Append[$CellToLinkStyle, _ -> btnSty];
        CheckForEnclosingLinkedHead[nb];
        DocumentationTools`CellFunctionApply[
          InlineListingButtons[#, btnSty, "InlineFormula", docPath]&,
          "Notebook" -> nb, "Action" -> optAction,
          "Delimiter" -> {dlm, dlmSty}
        ];
        FrontEndTokenExecute[nb, "MovePrevious"];
    ]
  ]


InlineListingButtons["(", ___] := " (";
InlineListingButtons[")", ___] := ")";
  (* ...to allow formatting of already formatted expressions w/o effect. *)
  
ApplicationDefinedQ[] := 
 And[ValueQ[$ApplicationName], Not@StringMatchQ[$ApplicationName, "" | Whitespace], 
     ValueQ[$LinkBase], Not@StringMatchQ[$LinkBase, "" | Whitespace]]

SymbolInApplication[potentialsymbol_String] := 
(Quiet[Needs[$LinkBase <> "`"]];
  MemberQ[DeleteCases[Union[Names[$ApplicationName <> "`*"], Names[$ApplicationName <> "`*" <> "`*"]], 
                      x_ /; StringMatchQ[x, __ ~~ "Private" ~~ __]], potentialsymbol])
                      
LinkAsApplicationSymbol[potentialsymbol_String] := 
 Module[{sysnames = Names["System`*"]},
 Which[$MathematicaDocs && ApplicationDefinedQ[] && SymbolInApplication[#] && Not[MemberQ[sysnames, #]], 
       True, 
       $MathematicaDocs && ApplicationDefinedQ[] && SymbolInApplication[#] && MemberQ[sysnames, #], 
       False,
       $MathematicaDocs && ApplicationDefinedQ[] && Not@SymbolInApplication[#], 
       False,
       $MathematicaDocs && Not@ApplicationDefinedQ[],
       False, 
       Not@$MathematicaDocs && ApplicationDefinedQ[] && SymbolInApplication[#],
       True, 
       Not@$MathematicaDocs && ApplicationDefinedQ[] && Not[SymbolInApplication[#]] && Not[MemberQ[sysnames, #]],
       True, 
       Not[ApplicationDefinedQ[]],
       False,
       True,
       False] &[potentialsymbol]]

InlineListingButtons[s_String, buttonStyle_, cellStyle_, docPath_] :=
  Module[
    {data, mainButton, specOpButton},
    data =
      StringCases[s, {
        name__ ~~ "(" ~~ so__ ~~ ")" :> TrimWhiteSpace /@ {name, so},
        name__ :> TrimWhiteSpace /@ {name}
      }];
    data = If[Length[data] > 0, First[data]];
    mainButton =
      If[Length[data] < 1
        ,
        Sequence @@ {}
        ,
        Cell[BoxData[
          ButtonBox[Which[StringMatchQ[#, __ ~~ "/ref/" ~~ __],
                          StringReplace[#, __ ~~ "/ref/" -> ""],
                          StringMatchQ[#, "ref/" ~~ __],
                          StringDrop[#, 4],
                          True,
                          #] &[data[[1]]],
            If[NameQ[data[[1]]]; True (* deactivating autoflagging *),
              BaseStyle -> buttonStyle,
              BaseStyle -> {buttonStyle, "BrighterFlag"}
            ],
            Which[StringMatchQ[data[[1]], __ ~~ "/ref/" ~~ __],
                  ButtonData -> "paclet:" <> data[[1]],
                  Head[docPath] === String && (If[StringMatchQ[#, "ref/" ~~ __],
                                                  False, 
                                                  LinkAsApplicationSymbol[#]] &[data[[1]]]),
                  ButtonData -> MakePacletURI[docPath, data[[1]]],
                  True,
                  Sequence @@ {}
            ]
          ]
        ], cellStyle]
      ];
    specOpButton =
      If[Length[data] < 2
        ,
        Sequence @@ {}
        ,
        Sequence @@ {
          " (", Cell[BoxData[data[[2]]], cellStyle], ")"
        }
      ];
    {mainButton, specOpButton}
  ];

InlineListingButtons[bb_ButtonBox, _, cellStyle_, _] :=
  Cell[BoxData[bb], cellStyle];

InlineListingButtons[
  StyleBox[s_String, etc___], buttonStyle_, cellStyle_, _
] := 
  Cell[BoxData[
    StyleBox[ButtonBox[s,
      If[NameQ[s]; True (* deactivating autoflagging *),
        BaseStyle -> buttonStyle,
        BaseStyle -> {buttonStyle, "BrighterFlag"}
      ]
    ], etc]
  ], cellStyle];

InlineListingButtons[StyleBox[bb_ButtonBox, etc___], _, cellStyle_, _] :=
  Cell[BoxData[StyleBox[bb, etc]], cellStyle];

InlineListingButtons[other_, ___] := other;


MakePacletURI[path_String, name_String] :=
  "paclet:" <>
    Switch[path,
      "Formats",
        Module[
          {
            newname, file
          },
          newname = StringReplace[name, "\"" -> ""];
          file = ToFileName[{$DocumentationDirectory,
            "System", "ReferencePages", "Formats"}, newname <> ".nb"];
          If[FileType[file] =!= File,
            MessageToConsole[MakePacletURI::noformatfile, file]
          ];
          "ref/format/" <> newname
        ],
      _,
        path <> "/" <> name
    ];

MakePacletURI::noformatfile = "Warning: The target of this Formats link
(`1`) doesn't exist.";


Options[InlineCharacterListingToggle] =
  Options[InlineListingToggle];

InlineCharacterListingToggle[cellSty : (_String | Automatic) : "SeeAlso"] :=
   Module[
      {
         nb = InputNotebook[],
         btnSty, optDelimiter,
         dlm, dlmSty, info, style, part
       },
      {btnSty, optDelimiter} =
         {"ButtonStyle", "Delimiter"}
            /. Options[InlineCharacterListingToggle];
      {dlm, dlmSty} = ParseDelimiter[optDelimiter];
      If[dlm === $Failed, Return[$Failed]];
      info = DocumentationTools`CellInfo[nb];
      Which[
         info === $Failed,
           style = If[cellSty === Automatic, "SeeAlso", cellSty];
           NotebookWrite[nb,
              Cell[ "XXXX" <> dlm[[1]] <> "XXXX" <> dlm[[1]], style], All];
           SelectionMove[nb, All, CellContents];
         ,
         Length[info] > 1,
           MessageToConsole[DocuTools::oversel,
             "InlineListingToggle", "cell"];
           Return[$Failed];
         ,
         True,
           SelectionMove[nb, All, Cell];
           If[cellSty === Automatic
              ,
              style = "Style" /. First[info];
              ,
              style = cellSty;
              DocumentationTools`StyleApply[cellSty];
           ];
           btnSty = style /. Append[$CellToLinkStyle, _ -> btnSty];
           DocumentationTools`CellFunctionApply[
              If[Head[#] === String
                ,
                part = StringTake[
                  ToString[#, InputForm, CharacterEncoding -> None],
                  {4, -3}
                ];
                Cell[TextData[ButtonBox[
                  "\\[" <> part <> "]", 
                  RuleDelayed @@
                    (ButtonData -> "paclet:ref/character/" <> part), 
                  BaseStyle -> btnSty
                ]], "InlineCharacterName"]
                ,
                #
              ]&,
              "Notebook" -> nb,
              "Delimiter" -> {dlm, dlmSty}
           ];
           FrontEndTokenExecute[nb, "MovePrevious"];
      ]
   ]

(* The argument of CursorInsideCellButEmptySelection and CursorInsideCellAndNonEmptySelection is designed to take
   the expression returned by CellInfo. *)

CursorInsideCellButEmptySelection[x_] := 
 Module[{curpos}, 
  MatchQ[x, {{"Style" -> _, __}}] && (curpos = ("CursorPosition" /. x)[[1]];
    ListQ[curpos] && SameQ @@ curpos)]

CursorInsideCellAndNonEmptySelection[x_] := 
 Module[{curpos}, 
  MatchQ[x, {{"Style" -> _, __}}] && (curpos = ("CursorPosition" /. x)[[1]];
    ListQ[curpos] && Not[SameQ @@ curpos])]

FunctionTemplate["Plain"] := Module[{nb = InputNotebook[], ci}, 
 ci = CellInfo[nb];
 If[("ContentData" /. CellInfo[nb]) === {BoxData}, Abort[]];
 
 Which[CursorInsideCellAndNonEmptySelection[ci], 
  FrontEndExecute[{
    FrontEnd`FrontEndToken[ nb, "CreateInlineCell"], 
    FrontEnd`FrontEndToken[ nb, "MoveNext"], 
    FrontEnd`FrontEndToken[ nb, "MoveNext"]}],

  CursorInsideCellButEmptySelection[ci],

(*  FrontEndExecute[FrontEndToken[nb, "SelectPreviousWord"]];
  If[(ci2 = CellInfo[nb]; CursorInsideCellAndNonEmptySelection[ci2]), 
     FrontEndExecute[{
       FrontEnd`FrontEndToken[ nb, "CreateInlineCell"], 
       FrontEnd`FrontEndToken[ nb, "MoveNext"], 
       FrontEnd`FrontEndToken[nb, "MoveNext"]}]] *)

    FrontEndExecute[{FrontEnd`FrontEndToken[nb, "CreateInlineCell"]}]]]
    

FunctionTemplateToggle::noin = "There is no input notebook.";
FunctionTemplateToggle::betwcells = "The cursor is between cells or not inside an input notebook.";
FunctionTemplateToggle::cellbrac = "A cell bracket is selected.";
FunctionTemplateToggle::mulcell = "Multiple cells have been selected.";
FunctionTemplateToggle::inappsel = "The cursor must be inside an \"InlineFormula\" cell, selecting part of such a cell or selecting a cell bracket.";

FunctionTemplateToggle[] := 
 Module[{nb = InputNotebook[], ci, ci2, re}, 
  Catch[If[nb === $Failed, 
           Throw[MessageToConsole[FunctionTemplateToggle::noin]]];
           
        ci = CellInfo[nb];
        
        If[ci === $Failed, 
           Throw[MessageToConsole[FunctionTemplateToggle::betwcells]]];
           
        If[MatchQ[ci, {{__, "CursorPosition" -> "CellBracket", __}}], 
           Throw[MessageToConsole[FunctionTemplateToggle::cellbrac]]];
           
        If[multipleCellBracketsSelected[ci], 
           Throw[MessageToConsole[FunctionTemplateToggle::mulcell]]];
           
        If[("ContentData" /. ci) === {TextData} && MatchQ[("CursorPosition" /. ci), {{a_Integer, a_Integer}}],
        
           FrontEndExecute[{FrontEnd`FrontEndToken[nb, "MovePrevious"]}]; 
           ci2 = CellInfo[nb];
           
           If[(ci /. ("CursorPosition" -> _) -> Sequence[]) === (ci2 /. ("CursorPosition" -> _) -> Sequence[]), 
           
              FrontEndExecute[{FrontEnd`FrontEndToken[nb, "MoveNext"]}]; 
              FrontEndExecute[{FrontEnd`FrontEndToken[nb, "SelectPreviousWord"]}];
              re = OldNotebookRead[nb];
              
              If[FreeQ[re, "InlineFormula"], 
                 FunctionTemplate[], 
                 FunctionTemplate["RestoreText"]],
                 
              If[("Style" /. ci2) === {"InlineFormula"},
              
                 FrontEndExecute[{FrontEnd`FrontEndToken[nb, "MoveNext"]}]; 
                 FrontEndExecute[{FrontEnd`FrontEndToken[nb, "SelectPreviousWord"]}]; 
                 FunctionTemplate["RestoreText"],
                 
                 FrontEndExecute[{FrontEnd`FrontEndToken[nb, "MoveNext"]}]; 
                 FunctionTemplate[]]],
                 
           FunctionTemplate[]]]]


FunctionTemplate::noin = "There is no input notebook.";
FunctionTemplate::betwcells = "The cursor is between cells or not inside an input notebook.";
FunctionTemplate::mulcell = "Multiple cells have been selected.";
FunctionTemplate::inappsel = "The cursor must be inside an \"InlineFormula\" cell, selecting part of such a cell or selecting a cell bracket.";
FunctionTemplate::inappstruc = "The expression in the selection has a form which cannot be handled by this function.";
FunctionTemplate::inappstruc2 = "One or more \"InlineFormula\" expressions in the selected cell have forms which cannot be handled by this function.";

restoreText[x_] := Module[{expr}, expr = (((((((x /. Cell[BoxData[ButtonBox[a_, BaseStyle -> _]], _String] :> a) /. 
         ButtonBox[a_, ___] :> a) /. StyleBox["\[Ellipsis]", "TR"] :> "$$") /. 
          SubscriptBox[StyleBox[a_String, _], b_String] :> a <> "$" <> b) /. 
        SubscriptBox[StyleBox[a_String, _], StyleBox[b_String, _]] :> 
         a <> "$" <> b) /. StyleBox[a_String, _] :> a) //. 
    RowBox[{a__String}] :> StringJoin[a]); If[MatchQ[expr, {__String}], StringJoin@@expr, expr[[1]]]]
    
FunctionTemplate["RestoreText"] := 
 Module[{nb = InputNotebook[], ci, re},
 
  Catch[If[(* There is no input notebook. *)
           nb === $Failed, 
           Throw[MessageToConsole[FunctionTemplate::noin]]];
           
        ci = CellInfo[nb];
        If[(* The cursor is between cells. *)
           ci === $Failed, 
           Throw[MessageToConsole[FunctionTemplate::betwcells]]];
           
        If[multipleCellBracketsSelected[ci], 
           Throw[MessageToConsole[FunctionTemplate::mulcell]]];
           
        Which[("Style" /. ci) === {"InlineFormula"},
        
              While[("Style" /. CellInfo[nb]) === {"InlineFormula"}, 
                    FrontEndExecute[{FrontEndToken[nb, "ExpandSelection"]}]];
              re = restoreText[OldNotebookRead[nb]];
              If[StringQ[re] || 
                 MatchQ[re, RowBox[{___String, SuperscriptBox[_String, _String], ___String}]],
                 NotebookWrite[nb, re, All],
                 MessageToConsole[FunctionTemplate::inappstruc]],
              
              ("CursorPosition" /. ci) === {"CellBracket"},
              
              re = OldNotebookRead[nb] /. Cell[TextData[{a__}], b___] :> 
                             Cell[TextData[If[MatchQ[#, Cell[_, "InlineFormula"]], restoreText[#[[1]]], #] & /@ {a}], b];
              If[MatchQ[re, Cell[TextData[{__String}], __]],
                 NotebookWrite[nb, re, All],
                 MessageToConsole[FunctionTemplate::inappstruc2]],
                 
              re = OldNotebookRead[nb];
              MatchQ[re, BoxData[_]],
              
              re = restoreText[re];
              NotebookWrite[nb, re, All],
              
              MatchQ[re, {(Cell[BoxData[ButtonBox[_String, BaseStyle -> _]], _String] | _String) ..}],
              
              re = restoreText[re];
              NotebookWrite[nb, re, All],
              
              True,
              
              MessageToConsole[FunctionTemplate::inappsel]]]]



(* Temporary alias for FunctionTemplate[] in order to force FE not to mislabel the context when
   called from the custom menu expression:  *)
(* Apparently no longer needed with recent splitting of package and related loading reconfiguration: *)
   
FunctionTemplateHack[] := FunctionTemplateToggle[]


$FunctionTemplateFormatting = "FormatAndLink";

CallFunctionTemplateFromDialog[] := 
 SetSelectedNotebook[NotebookPut@Notebook[{
   Cell[""],
   Cell[BoxData[
     GridBox[{{RadioButtonBox[Dynamic[$FunctionTemplateFormatting], {"FormatAndLink"}], 
               RowBox[{"Format the selection as a symbol in the application: ", 
          StyleBox[ToBoxes@Dynamic[Refresh[If[$LinkBase === "" || Union[Characters[$LinkBase]] === {" "} || Not[ValueQ[$LinkBase]], 
                                              "not defined", 
                                              $LinkBase], 
                                           UpdateInterval -> .5]], 
                   FontWeight -> "Bold", FontColor -> GrayLevel[0.3]],
          "."}]},
              {RadioButtonBox[Dynamic[$FunctionTemplateFormatting], {"JustFormat"}], 
               "Format the selection without linking to any application."},
              {"", "If the symbol is in a package and should be formatted as a link,\nclick Cancel and load the package before using template input."},
               {"", "If the package is your project, be sure to first configure your\napplication data as needed."}}, 
             GridBoxAlignment -> {"Columns" -> {{Right, Left}}, "Rows" -> {{Center}}}, 
             GridBoxSpacings -> {"Columns" -> {1}, "Rows" -> {{1.5}}}, 
             GridBoxItemSize -> {"ColumnsIndexed" -> {1 -> 7, 2 -> 100}}]], 
        CellMargins -> {{0, 12}, {2, 2}}, 
        FontFamily -> "Helvetica", 
        FontSize -> 12, 
        ShowStringCharacters -> False], Cell[""], 
   Cell[BoxData[RowBox[{ButtonBox[StyleBox["OK", FontWeight -> "Bold"], 
                                  ButtonFunction :> (If[$FunctionTemplateFormatting === "FormatAndLink", 
                                                        FunctionTemplate[CalledFromDialog -> True], 
                                                        FunctionTemplate[CalledFromDialog -> True, JustFormat -> True]]; 
                                                     NotebookClose[EvaluationNotebook[]])], 
                        ButtonBox[StyleBox["Cancel", FontWeight -> "Bold"], 
                                  ButtonFunction :> NotebookClose[EvaluationNotebook[]]]}]], 
        TextAlignment -> Center], 
   Cell[""]}, 
                                          Selectable -> False, 
                                          Deletable -> False, 
                                          WindowSize -> {500, FitAll}, 
                                          WindowMargins -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
                                          WindowFrame -> "Palette", 
                                          WindowElements -> {}, 
                                          WindowFrameElements -> {}, 
                                          ShowCellBracket -> False, 
                                          ClosingAutoSave -> False, 
                                          WindowTitle -> "Template Input", 
                                          NotebookEventActions -> {"ReturnKeyDown" :> (If[$FunctionTemplateFormatting === "FormatAndLink", 
                                                                                          FunctionTemplate[CalledFromDialog -> True], 
                                                                                          FunctionTemplate[CalledFromDialog -> True, JustFormat -> True]];
                                                                                          NotebookClose[EvaluationNotebook[]])}, 
                                          ButtonBoxOptions -> {Evaluator -> Automatic, Active -> True, Method -> "Queued", Appearance -> "DialogBox"},
                                          CellContext -> "Global`"]]
            
(* PotentialSymbolTest is for situations where the package corresponding to $LinkBase cannot be loaded -- developer is writing documentation
   ahead of package development. (It also handles the situation where the package exists and so can be loaded -- We want to autolink package symbols
   and enable the user to make a choice for other potential symbols.) A dialog will be generated by FunctionTemplate for potential symbols enabling
   the user to specify if they want to proceed as if what might be a symbol in the (expansion of the) selection is actually such in the package that
   they will be writing and as such, it should be linked. *)

$InPackage = False

PotentialSymbolTest[re_] := 
 Module[{nms = Names["System`*"], pnms, cs}, 
  StringQ[$ApplicationName] && StringQ[$LinkBase] && 
   Not@MemberQ[{$ApplicationName, $LinkBase}, ""] && 
    (Quiet[Needs[$LinkBase <> "`"]; 
    pnms = DeleteCases[Union[Names[$ApplicationName <> "`*"], Names[$ApplicationName <> "`*" <> "`*"]], 
                       x_ /; StringMatchQ[x, __ ~~ "Private" ~~ __]]];
    (If[StringQ[re] && Not@StringFreeQ[re, "["], 
          If[Not[MemberQ[nms, StringReplace[re, "[" ~~ __ -> ""]]], 
             $PotentialSymbol = StringReplace[re, "[" ~~ __ -> ""]; 
             $InPackage = MemberQ[pnms, $PotentialSymbol]; 
             True, 
             $InPackage = False], 
        $InPackage = False] || 
     If[StringQ@re && StringFreeQ[re, "["], 
        If[Not[MemberQ[nms, re]], 
           $PotentialSymbol = re;
           $InPackage = MemberQ[pnms, $PotentialSymbol];
           True, 
           $InPackage = False], 
        $InPackage = False] || 
     If[(cs = Cases[re, _String, Infinity]) =!= {}, 
         If[Not[MemberQ[nms, cs[[1]]]], 
            $PotentialSymbol = cs[[1]];
            $InPackage = MemberQ[pnms, $PotentialSymbol];
            True, 
            $InPackage = False], 
        $InPackage = False]))]
(*                                                          
NotASymbolTest[re_] := 
 Module[{nms = Names["System`*"], packagenames, str, cs}, 
  If[StringQ[$LinkBase] && ($LinkBase =!= "") && StringQ[$ApplicationName] && ($ApplicationName =!= ""), 
     Quiet[Needs[$LinkBase <> "`"]]; 
     packagenames = DeleteCases[Union[Names[$ApplicationName <> "`*"], Names[$ApplicationName <> "`*" <> "`*"]], 
                                x_ /; StringMatchQ[x, __ ~~ "Private" ~~ __]]];
  Which[StringQ[re] && StringFreeQ[re, "["] && Not[MemberQ[Union[nms, packagenames], re]], 
        $NotASymbol = re; True, 
        StringQ[re] && StringMatchQ[re, __ ~~ "[" ~~ __] && Not[MemberQ[Union[nms, packagenames], str = StringReplace[re, "[" ~~ ___ -> ""]]], 
        $NotASymbol = str; True, 
        (cs = Cases[re, _String, Infinity]) =!= {} && Not[MemberQ[Union[nms, packagenames], cs[[1]]]], 
        $NotASymbol = cs[[1]]; True, 
        True, 
        False]]
*)

ContextInspectionAttempt[re_String] := 
 Module[{hed, context},
  $ContextName = If[Quiet[StringQ[context = (hed[re] /. hed -> Context)]], 
                    If[StringCount[context, "`"] === 1, 
                       StringReplace[context, "`" -> ""], 
                       None], 
                    None]]

Options[FunctionTemplate] = {CalledFromDialog -> False, JustFormat -> False}

FunctionTemplate[opts___] := 
 Catch[Module[{nbo = NextNotebook[], celinf, calledFromDialog, justFormat,
               objName = GuessObjectName[InputNotebook[]], threeparts, re},
   celinf = CellInfo[nbo];
   calledFromDialog = CalledFromDialog /. {opts} /. Options[FunctionTemplate];
   justFormat = JustFormat /. {opts} /. Options[FunctionTemplate];
   If[Not[MatchQ[celinf, {{___}}]], Throw[$Failed, BadSelection]]; 
   threeparts = {"ContentData", "CursorPosition", "InlineCellPosition"} /. First@celinf;
   Replace[threeparts, 
   
          {{TextData, cp_, icp_} :> (If[MatchQ[cp, {p_, p_}], FrontEndTokenExecute[nbo, "SelectPreviousWord"]];
          
       re = OldNotebookRead@nbo;
       If[Not@$MathematicaDocs && Not@calledFromDialog && PotentialSymbolTest[re] && Not@$InPackage && ContextInspectionAttempt[$PotentialSymbol] === None, 
          CallFunctionTemplateFromDialog[],
          Replace[re, 
               {s_String :> NotebookWrite[nbo, 
                                          Which[(calledFromDialog && Not@justFormat) || $InPackage,
                                          
                                                # /. 
                                                b : ButtonBox[$PotentialSymbol, _] :> Insert[b, ButtonData -> "paclet:" <> $LinkBase <> "/ref/" <> $PotentialSymbol, -1],
                                                
                                                Not@justFormat && $ContextName =!= None && StringQ[$ContextName],
                                                
                                                # /.
                                                b : ButtonBox[$PotentialSymbol, _] :> Insert[b, ButtonData -> "paclet:" <> $ContextName <> "/ref/" <> $PotentialSymbol, -1],
                                                
                                                calledFromDialog,
                                                
                                                # /. ButtonBox[$PotentialSymbol, _] -> $PotentialSymbol,
                                               
                                                True,
                                                
                                                #]&[Cell[BoxData[ParseTextTemplate[s, objName]], "InlineFormula", ShowStringCharacters -> False]], 
                                          All],
                                          
                b_BoxData :> NotebookWrite[nbo, 
                                           Which[(calledFromDialog && Not@justFormat) || $InPackage,
                                          
                                                 # /. 
                                                 bu : ButtonBox[$PotentialSymbol, _] :> Insert[bu, ButtonData -> "paclet:" <> $LinkBase <> "/ref/" <> $PotentialSymbol, -1],
                                                
                                                 Not@justFormat && $ContextName =!= None && StringQ[$ContextName],
                                                
                                                 # /.
                                                 bu : ButtonBox[$PotentialSymbol, _] :> Insert[bu, ButtonData -> "paclet:" <> $ContextName <> "/ref/" <> $PotentialSymbol, -1],
                                               
                                                 calledFromDialog,
                                                
                                                 # /. ButtonBox[$PotentialSymbol, _] -> $PotentialSymbol,
                                               
                                                True,
                                                
                                                #]&[Cell[ReplaceAll[b, {btn_ButtonBox :> btn, st_StyleBox :> st, 
                                                               objName -> objName, c_Cell :> c, 
                                                               strg_String :> StylizeTemplatePart[strg], 
                                   RowBox[{msgObjName_String, "::", msgTag : Except["tag", _String]}] :> StylizeMessageName[msgObjName, msgTag, objName]}], 
                                                     "InlineFormula", ShowStringCharacters -> False]], 
                                           All], 
               {umi : Cell[_, "ModInfo" | "UsageModInfo", ___], s_String} :> (SetOptions[NotebookSelection@nbo, Deletable -> True];
           NotebookWrite[nbo,
           
                         Which[(calledFromDialog && Not@justFormat) || $InPackage,
                                          
                               # /. 
                               b : ButtonBox[$PotentialSymbol, _] :> Insert[b, ButtonData -> "paclet:" <> $LinkBase <> "/ref/" <> $PotentialSymbol, -1],
                                                
                               Not@justFormat && $ContextName =!= None && StringQ[$ContextName],
                                                
                               # /.
                               b : ButtonBox[$PotentialSymbol, _] :> Insert[b, ButtonData -> "paclet:" <> $ContextName <> "/ref/" <> $PotentialSymbol, -1],
                                               
                               calledFromDialog,
                                                
                               # /. ButtonBox[$PotentialSymbol, _] -> $PotentialSymbol,
                                               
                               True,
                                                
                               #]&[TextData[{umi, Cell[BoxData[ParseTextTemplate[s, objName]], "InlineFormula", ShowStringCharacters -> False]}]],
                         
                         All])}];
           SetOptions[NotebookSelection[nbo], ShowStringCharacters -> Inherited];
           SelectionMove[nbo, After, Character]]),
           
                       {BoxData, cp_, icp_} :> (If[MatchQ[cp, {p_, p_}], SelectionMove[nbo, All, If[icp === "InlineCellPosition", Cell, CellContents]]];
                       
       re = OldNotebookRead@nbo;
       If[Not@$MathematicaDocs && Not@calledFromDialog && PotentialSymbolTest[re] && Not@$InPackage && ContextInspectionAttempt[$PotentialSymbol] === None, 
          CallFunctionTemplateFromDialog[], 
          With[{before = Replace[OldNotebookRead@nbo, {BoxData[_GridBox] :> Throw[$Failed, BadSelection], Cell[cont_, ___] :> cont}]}, 
               If[MatchQ[cp, {p_, p_}] && icp === "InlineCellPosition", SelectionMove[nbo, All, CellContents]];
               NotebookWrite[nbo,(* Wrapping with a Cell here to avoid bad box-embedded-in-string pasting behavior that just cropped up. walsh, 14 Jan.*)
               
                             Which[(calledFromDialog && Not@justFormat) || $InPackage,
                                          
                                   # /. 
                                   b : ButtonBox[$PotentialSymbol, _] :> Insert[b, ButtonData -> "paclet:" <> $LinkBase <> "/ref/" <> $PotentialSymbol, -1],
                                                
                                   Not@justFormat && $ContextName =!= None && StringQ[$ContextName],
                                                
                                   # /.
                                   b : ButtonBox[$PotentialSymbol, _] :> Insert[b, ButtonData -> "paclet:" <> $ContextName <> "/ref/" <> $PotentialSymbol, -1],
                                               
                                   calledFromDialog,
                                                
                                   # /. ButtonBox[$PotentialSymbol, _] -> $PotentialSymbol,
                                               
                                   True,
                                                
                                   #]&[Cell[ReplaceAll[before, {btn_ButtonBox :> btn, st_StyleBox :> st, objName -> objName, c_Cell :> c, 
                                                                SubscriptBox[base_, sub_] :> StylizeSubscriptedArgument[base, sub], 
                                                                strg_String :> StylizeTemplatePart[strg], 
                                   RowBox[{msgObjName_String, "::", msgTag : Except["tag", _String]}] :> StylizeMessageName[msgObjName, msgTag, objName]}], 
                                  "InlineFormula", ShowStringCharacters -> False]], 
                             All]];
               SelectionMove[nbo, After, Character];
              (* If the original selection was a point within an inline cell, do a MoveNext to leave the insertion point just outside the inline cell.*)
              If[MatchQ[cp, {p_, p_}] && icp =!= "InlineCellPosition", 
                 FrontEndExecute[FrontEndToken[nbo, "MoveNext"]]]])}]], 
  BadSelection]

GuessObjectName[ nbo_NotebookObject] :=
Replace[
   "FileName" /. NotebookInformation @ nbo,
{
   FrontEnd`FileName[ l_List, fn_String, ___] :> StringReplace[ fn, ".nb" -> ""],
   _ :>
      Replace[
         Cases[ NotebookGet @ nbo, Cell[ s_String, "ObjectName", ___] :> s, -1, 2],
      {
         {} -> $Failed,
         {one_} :> StringReplace[ one, " " ~~ ___ :> ""],
         _ -> $Failed
      }]
}]


StylizeArgumentLabel[ s_String, stringContent_:False] :=
Replace[
   StringSplit[ s, "$", 2],
{
   {one_} :>
      If[ TrueQ @ stringContent,
         Replace[ StringSplit[ one, "."],
         {
            {fileBase_, fileExts__} :>
               RowBox @
                  ReplaceRepeated[
                     Riffle[
                        Join[
                           {Italicization @ fileBase},
                           Replace[{fileExts}, "ext" -> Italicization @ "ext", {1}]
                        ],
                        "."
                     ],
                     {a___, b1_String, b2__String, c___} :> {a, StringJoin[ b1, b2], c}
                  ],
            _ -> Italicization[ one]
         }],
         Italicization[ one]  (* This could be simply (one) if we used
LowerCaseStyle, but for now we are not. --walsh, June 2006 *)
      ],
   {base_, sub_} :> StylizeSubscriptedArgument[ base, sub]
}]

StylizeSubscriptedArgument[ base_, sub_] :=
SubscriptBox[ Italicization @ base, Italicization @ sub]

StylizeTemplatePart[ strg_String, opts___?OptionQ] := 
If[ StringLength[ strg] > 2 && "\"\"" === StringDrop[ strg, {2, -2}],
(* walsh, April 2005.
This is an attempt to get italics within quotation marks right.
*)
   Replace[
      If[ MemberQ[ $ArgLabelInitialLetters, StringTake[ strg, {2, 2}] ], 
         StylizeArgumentLabel[ StringTake[ strg, {2, -2}], True]
      , (* else *)
         strg
      ],
   {
      s_String :> NonSymbolReferenceLink @ strg,
      StyleBox[ s_String, sty_String] :>
         "\"\<\!\(\*StyleBox[\"" <>
         s <>
         "\",\"" <>
         sty <>
         "\"]\)\>\"",
      SubscriptBox[
         StyleBox[ s1_String, sty1_String],
         StyleBox[ s2_String, sty2_String]
      ] :>
         "\"\<\!\(\*SubscriptBox[StyleBox[\"" <>
         s1 <>
         "\",\"" <>
         sty1 <>
         "\"],StyleBox[\"" <>
         s2 <>
         "\",\"" <>
         sty2 <>
         "\"]]\)\>\"",
      RowBox[pieces:{(StyleBox[ _String, _String] | _String)..}] :>
         StringJoin[
            "\"\<",
            StringEmbed /@ pieces,
            "\>\""
         ]
      ,
      _ :> RowBox[{"\"", StylizeTemplatePart[ StringTake[ strg, {2, -2}], opts], "\""}]
   }]
(*
   RowBox[{"\"", StylizeTemplatePart[ StringTake[ strg, {2, -2}], opts], "\""}]
*)
, (* else *)
   If[ MemberQ[ $ArgLabelInitialLetters, StringTake[ strg, 1] ], 
      StylizeArgumentLabel @ strg
   , (* else *)

    (*** If we prefer non-button format in demos, change to this code:
    If[ (StyleDefinitions /. Options[ InputNotebook[], StyleDefinitions]) === "DemoStyles.nb", (* Not making buttons in Demos: *)
      strg,
      If[ FunctionLinkableQ[ strg],
        FunctionLinkButton[ strg, FunctionLinkData[ strg] ]
        , (* else *)
        strg
      ]]  ****)
      
    If[ FunctionLinkableQ[ strg],
      FunctionLinkButton[ strg, FunctionLinkData[ strg] ]
      , (* else *)
      strg
      ]

   ]
]

NonSymbolReferenceLink[ strg_] :=
With[ {refType = ReferenceType[ strg]},
   Replace[ refType, {
      None -> strg,
      t_String :>
         ButtonBox[ strg,
            BaseStyle -> "Link",
            ButtonData ->
               "paclet:ref/" <> refType <> "/" <> StringTake[ strg, {2, -2}]
         ]
   }]
]

ReferenceType[ strg_ /; StringDrop[ strg, {2, -2}] === "\"\""] :=
Replace[ StringTake[ strg, {2, -2}], Append[ ReferenceNames[], _ -> None] ]

ReferenceType[ _ ] := None

ReferenceNames[] := ReferenceNames[] =
Map[
   Apply[ Alternatives,
      StringReplace[ #, {DirectoryName[#] -> "", ".nb" -> ""}]& /@
         FileNames["*.nb",
            ToFileName[{$DocumentationDirectory, "System", "ReferencePages"}, #]
         ]
   ]
      -> (# /. $ReferenceSubcategoryUriSubstring)
&
,
   {"Methods", "Formats"}
]

$ReferenceSubcategoryUriSubstring = {
   s_String :> ToLowerCase[ StringDrop[ s, -1] ]
}


StringEmbed[ s_String] := s

StringEmbed[ StyleBox[ s_String, sty_String] ] :=
"\!\(\*StyleBox[\"" <>
   s <>
   "\",\"" <>
   sty <>
   "\"]\)"


$MakeLinks = True

ApplicationContext[] :=
Replace[ DocumentationTools`$ApplicationName, {
   _Symbol -> None,
   s_String :> StringReplace[ s, "/" -> "`"] <> "`"
}]

FunctionLinkableQ[ expr_] :=
$MakeLinks &&
   AtomQ[ expr] &&
   Head[ expr] === String &&
   StringMatchQ[ expr, (WordCharacter | "$")..] &&
   Not @ MemberQ[ $ExcludedApplicationSymbols, expr] &&
   (
      Names["System`" <> expr] =!= {} ||
      MemberQ[ $IncludedApplicationSymbols, expr] ||
      MemberQ[ $ApplicationSymbolsWithUsage, expr] ||
      If[
         StringQ[ ApplicationContext[]] &&
            Names[ ApplicationContext[] <> expr] =!= {},
         $IncludedApplicationSymbols === {},
         MemberQ[ $BuiltInSymbolInitialLetters, StringTake[ expr, 1] ]
      ]
   )

FunctionLinkData[ expr_] :=
If[And[ValueQ[DocumentationTools`$ApplicationName],Not[StringMatchQ[DocumentationTools`$ApplicationName, "" | Whitespace]],
       ValueQ[DocumentationTools`$LinkBase],Not[StringMatchQ[DocumentationTools`$LinkBase, "" | Whitespace]]], 
    Quiet[Needs[$LinkBase <> "`"]];
$ApplicationSymbolsWithUsage = SymbolsWithUsage[DocumentationTools`$ApplicationName];

If[
   MemberQ[
      Union[ $IncludedApplicationSymbols, $ApplicationSymbolsWithUsage],
      expr
   ] ||
   StringQ[ DocumentationTools`$LinkBase] &&
      Not@StringMatchQ[DocumentationTools`$LinkBase, "" | (" "..)] &&
       StringQ[ ApplicationContext[]] &&
      Names[ ApplicationContext[] <> expr] =!= {} &&
      $IncludedApplicationSymbols ==={} &&
      Not[ MemberQ[ $ExcludedApplicationSymbols, expr]],
   "paclet:" <> DocumentationTools`$LinkBase <> "/ref/" <> expr, 
   None
]]

StylizeTemplatePart["$$"] = StyleBox["\[Ellipsis]", "TR"]

$ArgLabelInitialLetters = Join[
   CharacterRange["a", "z"],
   $GreekLowerCase,
   $GreekUpperCase
]

$BuiltInSymbolInitialLetters = Join[
   CharacterRange["A", "Z"],
   {"$"}
]

Italicization[ strg_String] :=
StyleBox[ strg, If[ GreekLetterQ @ strg || DigitQ @ strg, "TR", "TI"] ]

(* Might not need this. --walsh, May 2006
SubscriptStylization[ strg_String] :=
If[ DigitQ @ strg, StyleBox[ strg, "TR"], strg]
*)

Italicization[ other_] := other

GreekLetterQ[ strg_String] :=
Complement[ Characters @ strg, $GreekUpperCase, $GreekLowerCase] === {}

$GreekLowerCase =
{
"\[Alpha]",
"\[Beta]",
"\[Gamma]",
"\[Delta]",
"\[Epsilon]",
"\[CurlyEpsilon]",
"\[Zeta]",
"\[Xi]",
"\[Eta]",
"\[Theta]",
"\[Iota]",
"\[Kappa]",
"\[Lambda]",
"\[Mu]",
"\[Nu]",
"\[Omicron]",
"\[Pi]",
"\[Rho]",
"\[Sigma]",
"\[Tau]",
"\[Upsilon]",
"\[Phi]",
"\[CurlyPhi]",
"\[Psi]",
"\[Chi]",
"\[Omega]"
}

$GreekUpperCase =
{
"\[CapitalAlpha]",
"\[CapitalBeta]",
"\[CapitalGamma]",
"\[CapitalDelta]",
"\[CapitalEpsilon]",
"\[CapitalZeta]",
"\[CapitalXi]",
"\[CapitalEta]",
"\[CapitalTheta]",
"\[CapitalIota]",
"\[CapitalKappa]",
"\[CapitalLambda]",
"\[CapitalMu]",
"\[CapitalNu]",
"\[CapitalOmicron]",
"\[CapitalPi]",
"\[CapitalRho]",
"\[CapitalSigma]",
"\[CapitalTau]",
"\[CapitalUpsilon]",
"\[CapitalPhi]",
"\[CapitalPsi]",
"\[CapitalChi]",
"\[CapitalOmega]"
}


ParseTextTemplate[ tpl_String, thisObject_:""] :=
If[ True || SyntaxQ @ tpl,
   ReplaceAll[
      MathLink`CallFrontEnd @ FrontEnd`ReparseBoxStructurePacket @ tpl,
(*
      Replace[
         With[{sn = ScratchNotebook[]
         },
            NotebookWrite[ sn, tpl, All];
            First @ {OldNotebookRead[ sn], NotebookDelete[sn]}
         ],
         BoxData[ bx_] :> bx
      ],
*)
   {
      thisObject -> thisObject,
      strg_String :> StylizeTemplatePart[ strg],
(* Special handling for message names, to keep tag part in computer-voice
style, unless it is literally "tag", which should be treated as an
argument placeholder.
*)
      RowBox[{objName_String, "::", msgTag:Except[ "tag", _String]}] :>
         StylizeMessageName[ objName, msgTag, thisObject]
   }]

, (* else *)
   With[{
      qzones =
         Apply[ Interval,
            Map[ # + {1, -1} &,
(*          Map[ # &, *)
 (* walsh, April 2005. Is it right to keep the "'s out of the quoted word interval? *)
               Select[
                  Partition[ First /@ StringPosition[ tpl, "\""], 2],
                  # . {-1, 1} > 1 &
               ]
            ]
         ]
   },
      With[{
         wordData =
            {First@#, Length@#} & /@ 
               Split[
                  MapIndexed[
                     IntervalMemberQ[ qzones, First @ #2] ||
                        LetterQ[#1] ||
                        DigitQ[#1] ||
                        SameQ[#1, "$"]
                     &,
                     Characters[ tpl]
                  ]
               ]
      }, 
         RowBox[
            Part[
               Reap[
                  Fold[
                     (
                     Sow[
                        Replace[ StringTake[#1, Last @ #2], {
            (* remainder of tpl, how many characters to take off *)
                           thisObject -> thisObject,
                           w_ /; First @ #2 :> StylizeTemplatePart @ w,
                           w_ :> StringReplace[ w, " " -> ""]
                        }],
                        ParseTextTemplate
                     ]; 
                     StringDrop[#, Last@#2]
                     ) &,
                     tpl,
                     wordData
                  ],
                  ParseTextTemplate
               ],
               -1,
               -1
            ]
         ]
      ]
   ]
]

(* Special handling for message names, to keep tag part in computer-voice
style, unless it is literally "tag", which should be treated as an
argument placeholder.
*)
StylizeMessageName[ objName_, msgTag_, thisObject_:""] :=
RowBox[{
   Replace[ objName, {
      thisObject -> thisObject,
      _ :> StylizeTemplatePart[ objName]
   }],
   "::",
   msgTag
}]

ScratchNotebook[] :=
If[ MemberQ[ Notebooks[], $ScratchNotebook],
   $ScratchNotebook
, (* else *)
   $ScratchNotebook =
      NotebookPut[
         Notebook[{
            Cell[ BoxData[""], "Input", InputAutoReplacements->{}]
         },
            StyleDefinitions ->
              FrontEnd`FileName[{"Wolfram"}, "FunctionPageStyles.nb"],
            Saveable -> False,
            Visible -> False
         ]
      ]
]



ExampleOpen::nodir = "The directory specified by DocuTools for $ExampleDirectory does not exist on this machine. Specify a directory and then click the button again.";
ExampleOpen::noin="There is no open input notebook.";
ExampleOpen::objnam="There is no \"ObjectName\" cell in the notebook.";
ExampleOpen::objnamnum="There is more than one \"ObjectName\" cell in the notebook.";
ExampleOpen::cellstruc="The \"ObjectName\" cell has incorrect structure.";
ExampleOpen::nonb="A corresponding examples notebook does not exist in directory set.";
ExampleOpen::nosel="No file was selected to set a directory.";

ExampleOpen[]:=
 Module[{nb=InputNotebook[],gt,cs,name,filepath},
  Catch[If[FileType[$ExampleDirectory] === None, 
           Throw[MessageToConsole[ExampleOpen::nodir]]];
        If[nb===$Failed, Throw[MessageToConsole[ExampleOpen::noin]]];
        gt = NotebookGet[nb];
        If[(cs = Cases[gt, Cell[_, "ObjectName", ___], Infinity];cs)==={},
           Throw[MessageToConsole[ExampleOpen::objnam]]];
        If[Not@MatchQ[cs,{Cell[__]}],
           Throw[MessageToConsole[ExampleOpen::objnamnum]]];
        If[Not@MatchQ[cs,{Cell[_String,"ObjectName", ___]}],
           Throw[MessageToConsole[ExampleOpen::cellstruc]]];
        name=StringSplit[cs[[1,1]]][[1]];
        filepath=$ExampleDirectory<>name<>".nb";
        If[NotebookOpen[filepath]===$Failed,
           Throw[MessageToConsole[ExampleOpen::nonb]]]]]

ExampleOpen["SetDirectory"]:=
 Module[{filepath},filepath=OpenBrowse[$ExampleDirectory];
  Catch[If[Not@StringQ[filepath]||StringLength[filepath]===0,
           Throw[MessageToConsole[ExampleOpen::nosel]]];
           $ExampleDirectory=DirectoryName[filepath]]]

multipleCellBracketsSelected[x_]:=
 MatchQ[x,{{"Style"\[Rule]_,__},{"Style"\[Rule]_,__},___}]
 
$PacletURI = ""

$PacletURIFieldValue = ""

Set$PacletURI::nocont = "The input field has no content.";

OK$PacletURI[] :=
 If[Not@StringMatchQ[$PacletURIFieldValue, "" | " " ..], 
    $PacletURI = $PacletURIFieldValue; 
    $TargetDocumentDir = $PacletURI;
    NotebookClose[EvaluationNotebook[]], 
    MessageToConsole[Set$PacletURI::nocont]]
    

Set$PacletURI[] :=
 Module[{nb},
  If[Not@StringMatchQ[$PacletURI, "" | " " ..], $PacletURIFieldValue = ReduceToPacletPath@$PacletURI];
  nb = NotebookPut[
   Notebook[{Cell["",FontSize->1,CellElementSpacings->{"CellMinHeight"->1},Selectable->False],
    Cell[
     BoxData[ToBoxes@
       Style[Grid[{{Style["paclet: ", Bold, Editable -> False, Selectable -> False], 
                    InputField[Dynamic[$PacletURIFieldValue], String, 
                               FieldSize -> {58, {1, Infinity}}]}, 
                   {Style["", Editable -> False, Selectable -> False], 
                    OldRow[{Button[Style["OK", Editable -> False, Deletable -> False, Bold], OK$PacletURI[], Method -> "Queued"], 
                            Button[Style["Cancel", Editable -> False, Deletable -> False, Bold], NotebookClose[EvaluationNotebook[]], 
                                   Method -> "Queued"]}, RowAlignments -> Center]}}, 
                  ColumnAlignments -> Left, ColumnSpacings -> .2], 
             FontFamily -> "Helvetica"]]],
            Cell["",FontSize->1,CellElementSpacings->{"CellMinHeight"->1},Selectable->False]}, 
           WindowSize -> FitAll, 
           WindowMargins -> {{Automatic, 100}, {Automatic, Automatic}}, 
           WindowFrame -> "Palette", 
           WindowElements -> {}, 
           WindowFrameElements -> {}, 
           ShowCellBracket -> False, 
           ClosingAutoSave -> False, 
           WindowTitle -> "Set $PacletURI", 
           Saveable -> False, 
           ShowStringCharacters -> False]];
    SelectionMove[nb, Before, Notebook]; 
    SelectionMove[nb, Next, Cell, 2]; 
    SelectionMove[nb, After, CellContents]; 
    FrontEndTokenExecute[nb, "Tab"];
    SetSelectedNotebook[nb]]
           
           
Set$PacletURI["Browse"] := Module[{dir},
  If[# =!= Null,
    (dir = StringReplace[#, $DocumentationDirectory -> ""];
     dir = StringReplace[dir, $PathnameSeparator -> "/"];
     dir = If[ StringMatchQ[ dir, "/*"], dir = StringDrop[ dir, 1], dir]),
     Abort[]] &[ MathLink`CallFrontEnd[ FrontEnd`DirectoryBrowse[ $DocumentationDirectory, "Select a directory."]]];
  $PacletURI = ReduceToPacletPath@dir;
  $TargetDocumentDir = dir;
  ]
  

$TargetDocumentDir = ""

Set$TargetDocumentDir::nodir = "A directory was not set.";
Set$TargetDocumentDir::notsubdir = "The directory you have selected is not in the documentation path currently set as: `1`.";
Set$TargetDocumentDir::setdocpath = "The selected directory is not a documentation directory. Set $DocumentationDirectory and then browse for a subdirectory of $DocumentationDirectory or select a subdirectory containing `1` in its path.";

Set$TargetDocumentDir[] := 
 Module[{root = If[$OperatingSystem === "Windows", 
                   StringSplit[$InstallationDirectory, $PathnameSeparator][[1]] <> $PathnameSeparator, 
                   "/"], sysdir, dir},
                   
        Off[FileType::"fstr"];
        
        sysdir = StringReplace[$TargetDocumentDir, "/" -> $PathnameSeparator];
        
        dir = If[FileType[sysdir] =!= Directory, 
                 MathLink`CallFrontEnd[FrontEnd`DirectoryBrowse[root, "Select a directory."]], 
                 MathLink`CallFrontEnd[FrontEnd`DirectoryBrowse[sysdir, "Select a directory."]]];
                 
        If[Not@StringQ[dir] || StringLength[dir] === 0,
        
           MessageToConsole[Set$TargetDocumentDir::nodir],
           
           Which[(* $DocumentationDirectory is set and the browse selected directory is contained in the $DocumentationDirectory
                    directory. *)
                 FileType[$DocumentationDirectory] === Directory && StringMatchQ[dir, $DocumentationDirectory ~~ __],
                 $TargetDocumentDir = GenericizePath@StringReplace[dir, $DocumentationDirectory -> ""];
                 $PacletURI = $TargetDocumentDir,
                 (* $DocumentationDirectory is set and the browse selected directory is not contained in the $DocumentationDirectory
                    directory. *)
                 FileType[$DocumentationDirectory] === Directory,
                 MessageToConsole[Set$TargetDocumentDir::notsubdir, $DocumentationDirectory],
                 (* $DocumentationDirectory is not set and the browse selected directory contains the string "Documentation". *)
                 FileType[$DocumentationDirectory] =!= Directory && StringMatchQ[dir, __~~"Documentation"~~$PathnameSeparator~~$Language],
                 $TargetDocumentDir = GenericizePath@StringReplace[dir, LongestMatch[__ ~~ "Documentation"~~$PathnameSeparator~~$Language] -> ""];
                 $PacletURI = $TargetDocumentDir,
                 (* $DocumentationDirectory is not set and the browse selected directory does not contain the string
                    "Documentation"~~$PathnameSeparator~~$Language. *)
                 True,
                 MessageToConsole[Set$TargetDocumentDir::setdocpath, "Documentation"<>$PathnameSeparator<>$Language]]];
                 
         On[FileType::"fstr"]]

 
GenericizePath[path_]:=StringReplace[path, $PathnameSeparator -> "/"]

writeURLLink[nb_,re_,url_,linkstyle_]:=
 NotebookWrite[nb, TextData[ButtonBox[re,ButtonData->{URL[url],None}, BaseStyle->"Hyperlink"]],All]
 
writeURLLinkInsideBoxData[nb_,re_,url_,linkstyle_]:=
 NotebookWrite[nb, ButtonBox[re,ButtonData->{URL[url],None}, BaseStyle->"Hyperlink"],All]
 
writeStyledURLLink[nb_,newbuttoncontent_,re_,url_,linkstyle_]:=
 NotebookWrite[nb, TextData[StyleBox[ButtonBox[newbuttoncontent,ButtonData->{URL[url],None}, BaseStyle->"Hyperlink"], Sequence@@Take[re, {2, -1}]]],All]
 
writeComboURLLink[nb_, buttoncontent_, re_, url_, linkstyle_] :=
 If[StringQ@buttoncontent,
    NotebookWrite[nb, TextData[ButtonBox[buttoncontent,ButtonData->{URL[url],None}, BaseStyle->"Hyperlink"]],All],
    NotebookWrite[nb, 
     TextData[If[StringQ[#], 
                 ButtonBox[#, ButtonData -> {URL[url], None}, BaseStyle -> "Hyperlink"], 
                 StyleBox[ButtonBox[#[[1]], ButtonData -> {URL[url], None}, BaseStyle -> "Hyperlink"], 
                          Sequence @@ Take[#, {2, -1}]]] & /@ re], All]]

writeQueryURLLink[nb_,re_,URL_]:=
 NotebookWrite[nb, TextData[ButtonBox[re,ButtonData->{URL, None}, BaseStyle->"Hyperlink"]],All]
 
writeQueryURLLinkBoxData[nb_,re_,URL_]:=
 NotebookWrite[nb, ButtonBox[re,ButtonData->{URL, None}, BaseStyle->"Hyperlink"],All]
 
writeStyledQueryURLLink[nb_,re_,URL_]:=
 NotebookWrite[nb, TextData[StyleBox[ButtonBox[re[[1]],ButtonData->{URL, None}, BaseStyle->"Hyperlink"], 
                                     Sequence@@Take[re, {2, -1}]]],All]
                                     
writeComboQueryURLLink[nb_, re_, URL_] := 
 NotebookWrite[nb, 
  TextData[If[StringQ[#], 
              ButtonBox[#, ButtonData -> {URL, None}, BaseStyle -> "Hyperlink"], 
              StyleBox[ButtonBox[#[[1]], ButtonData -> {URL, None}, BaseStyle -> "Hyperlink"], 
                       Sequence @@ Take[#, {2, -1}]]] & /@ re], All]

writeURLLink[nb_,re_,url_,linkstyle_,cellStyleAndOpts_]:=
 NotebookWrite[nb, Cell[TextData[ButtonBox[re,ButtonData->{URL[url],None},BaseStyle->"Hyperlink"]],
                        Sequence@@cellStyleAndOpts],All]

writeQueryURLLink[nb_,re_,URL_,cellStyleAndOpts_]:=
 NotebookWrite[nb, Cell[TextData[ButtonBox[re,ButtonData->{URL,None},BaseStyle->"Hyperlink"]],Sequence@@cellStyleAndOpts],All]

writeLink[nb_,re_,filepath_,linkstyle_]:=
 NotebookWrite[nb, TextData[ButtonBox[re,ButtonData->{GenericizePath@filepath,None},BaseStyle->"Hyperlink"]],All]
 
writeLink[nb_,re_,filepath_,linkstyle_,cellStyleAndOpts_]:=
 NotebookWrite[nb, Cell[TextData[ButtonBox[re,ButtonData->{GenericizePath@filepath,None},BaseStyle->"Hyperlink"]],Sequence@@cellStyleAndOpts],All]

DocumentationTools`$DefaultFileBrowserPath="H:\\Mathematica\\Documentation\\WolframNetwork";

CustomLink::nourl = "A URL is not specified";
CustomLink::nocusvalue = "Custom button contents is not specified.";

CustomLink::noin = "There is no open input notebook.";
CustomLink::mulcell = "Multiple cells have been selected";
CustomLink::nosel = "No file was selected to set a directory.";
CustomLink::betwcells = "The cursor is between cells.";
CustomLink::emptysel = "The selection has no content.";
CustomLink::stringsel = "A non-empty selection must be a string, style box, a sequence of style boxes and strings or a cell consisting of just a string or the interior of a BoxData expression.";
CustomLink::sysdoc = "This is a System document."; 
CustomLink::wrongdir = "The file chosen should be of the form .../application/Documentation/$Language/`1`/filename.nb, .../application/$Language/`1`/filename.nb or .../application/`1`/filename.nb.";
CustomLink::$ApplicationNamenotset = "$ApplicationName needs to be set.";
CustomLink::$LinkBasenotset = "$LinkBase needs to be set.";
CustomLink::pacletsymbsnotset = "$ApplicationName and/or $LinkBase need to be set.";
CustomLink::wrongdir2 = "Links can be made to notebooks or pdf files in the application's Tutorials, Guides or Symbols directories or in any directories parallel to those directories.";
CustomLink::nonbsel = "The selected file must be a notebook.";
CustomLink::notdoc = "The selected notebook is not in the documentation tree. It must have `1` contained in its path.";
CustomLink::setdocpath = "You must set $TargetDocumentDir and the selected file must have $TargetDocumentDir in its path or `1` must be in the path of the selected file.";
CustomLink::documentdirnotset = "$TargetDocumentDir has not been set.";
CustomLink::pathsnotset = "Neither $DocumentationDirectory nor $TargetDocumentDir are set.";
CustomLink::filelocation = "The file chosen must be in the directory `1`.";
CustomLink::targetdocdir = "The file chosen must have `1` as part of its path.";

Options[CustomLink]={ButtonContentsSelection->"ButtonContents", ContentLabels -> All, CacheLastDirectory->False, 
                     Interactive->False, Target->"File", AddedLabel -> None, PacletInteractive -> False, 
                     TargetPreset -> False, LinkBase -> None};
                     
$URLValue = "";
$CustomLinkmatch = "ButtonContents";
$custom = False;
$customcontent = "";

Options[buttonContent] = {AddLabel -> None, Contentlabels -> None, FromBoxData -> False}

buttonContent[x_, opts___] := 
 Module[{addLabel, contentlabels, fromBoxData},
        addLabel = AddLabel /. {opts} /. Options[buttonContent];
        contentlabels = Contentlabels /. {opts} /. Options[buttonContent];
        fromBoxData = FromBoxData /. {opts} /. Options[buttonContent];
        If[contentlabels === None,
           If[addLabel === None,
              Switch[$CustomLinkmatch, "ButtonContents", If[StringQ@x || ListQ@x || fromBoxData, x, x[[1]]], "MoreInfo", "[more info]", 
                     "URL", $URLValue, "Custom", $customcontent],
              Switch[$CustomLinkmatch, "ButtonContents", If[StringQ@x || ListQ@x || fromBoxData, x, x[[1]]], "MoreInfo", "[more info]", 
                     "URL", $URLValue, addLabel, addLabel, "Custom", $customcontent]],
           $CustomLinkmatch]]
                            
(* Workaround for bug 59834. *)
                            
CloseNotebook[] := ($customDialog = EvaluationNotebook[]; 
  $closeNB = NotebookPut[Notebook[{Cell[BoxData[RowBox[{"NotebookClose", "[", "$customDialog", "]"}]], "Input"], 
                                Cell[BoxData[RowBox[{"NotebookClose", "[", RowBox[{"EvaluationNotebook", "[", "]"}], "]"}]],
                                     "Input"]}, 
                                 Visible -> False]]; 
                    FrontEndExecute[{FrontEndToken[$closeNB, "EvaluateNotebook"]}])
                    
(*    Introduces a recursion problem:

CustomLink[linkstyle_String, opts1___, Interactive -> True, opts2___]:= CustomLink[linkstyle, Interactive -> True]

CustomLink[opts1___, Interactive -> True, opts2___]:= CustomLink[Interactive -> True]
*)

                       
restoreDefault[nb_] := 
 Module[{ci},
        SetSelectedNotebook[nb];
        ci = CellInfo[nb];
        If[MatchQ["CursorPosition" /. ci, {{___, a_, b_}} /; a =!= b],
           If[("ContentData" /. ci) === {BoxData}, 
              FrontEndExecute[{FrontEnd`FrontEndToken[nb, "ExpandSelection"]}]];
           FrontEndExecute[{FrontEnd`FrontEndToken[nb, "MoveNext"]}]];
           NotebookWrite[nb, Cell[" "], All];
           NotebookWrite[nb, ""]]
                       
Options[OKCustomLink] = {AddedLabel -> None, Contentlbls -> None}

OKCustomLink[linkstyle_String, opts__]:=
  Module[{nb = NextNotebook[], ci, addedLabel, contentlabels, re, cellStyleAndOpts},
   Catch[
    If[(* No input notebook exists. *)
       nb === None, Throw[MessageToConsole[CustomLink::noin]]];
       
    ci = CellInfo[nb];
    
    If[(* Multiple cell brackets are selected. *)
    multipleCellBracketsSelected[ci], Throw[MessageToConsole[CustomLink::mulcell]]];
    
   If[(* The cursor is between cells. *)
      ci === $Failed, Throw[MessageToConsole[CustomLink::betwcells]]];
      
   If[StringMatchQ[$URLValue, "" | " " ..], Throw[MessageToConsole[CustomLink::nourl]]];
   
   If[$custom && StringMatchQ[$customcontent, "" | " " ..], Throw[MessageToConsole[CustomLink::nocusvalue]]];
   
   addedLabel = AddedLabel /. {opts} /. Options[OKCustomLink];
   contentlabels = Contentlbls /. {opts} /. Options[OKCustomLink];
   
   re = OldNotebookRead[nb];
   re2 = NotebookRead[nb];
   
   If[Not@StringMatchQ[$URLValue, "http://*"] && StringFreeQ[$URLValue, "https://"], $URLValue = "http://"<>$URLValue];
   
   If[(* The cursor is inside a cell or selecting a cell with no content. *)
      MatchQ[re, {} | Cell["", __]],
      Throw[MessageToConsole[CustomLink::emptysel]]];
               
   If[Not[MatchQ[re, _String | StyleBox[__] | {(StyleBox[__] | _String)..} | Cell[_String, __]] || 
                                                               (MatchQ[re, BoxData[_]] && Not@MatchQ[re2, BoxData[_]])], 
      Throw[MessageToConsole[CustomLink::stringsel]]];
      
   If[MatchQ[re, _String | StyleBox[__] | {(StyleBox[__] | _String)..} | Cell[_String, __]] || 
                                                               (MatchQ[re, BoxData[_]] && Not@MatchQ[re2, BoxData[_]]), 
      Which[MatchQ[re, _String],
            writeURLLink[nb, buttonContent[re, AddLabel -> addedLabel, Contentlabels -> contentlabels], 
                         $URLValue, "Hyperlink"];
            restoreDefault[nb],
            MatchQ[re, BoxData[_]] && Not@MatchQ[re2, BoxData[_]],
            writeURLLinkInsideBoxData[nb, buttonContent[re2, AddLabel -> addedLabel, Contentlabels -> contentlabels, 
                                                        FromBoxData -> True], 
                                 $URLValue, "Hyperlink"];
            restoreDefault[nb],
            MatchQ[re, StyleBox[__]],
            writeStyledURLLink[nb, buttonContent[re, AddLabel -> addedLabel, Contentlabels -> contentlabels], 
                               re, $URLValue, "Hyperlink"];
            restoreDefault[nb],
            MatchQ[re, {(StyleBox[__] | _String)..}],
            writeComboURLLink[nb, buttonContent[re, AddLabel -> addedLabel, Contentlabels -> contentlabels], 
                              re, $URLValue, "Hyperlink"];
            restoreDefault[nb],
            True,
            cellStyleAndOpts = Take[re, {2, -1}];
            writeURLLink[nb, buttonContent[re[[1]], AddLabel -> addedLabel, Contentlabels -> contentlabels], 
                         $URLValue, "Hyperlink", cellStyleAndOpts]]]]]
         

RemoveLeftForwardSlashes[x_] := StringReplace[x, StartOfString ~~ LongestMatch["/" ..] ~~ a__ :> a]

RemoveOutsideQuotes[s_] := If[StringQ@s && StringMatchQ[s, "\"" ~~ __ ~~ "\""], StringTake[s, {2, -2}], s]

writeLinkpac[nb_, re_, filepath_, linkstyle_] := 
 NotebookWrite[nb, 
  TextData[ButtonBox[re, 
    ButtonData -> 
     ReplaceAmpersand["paclet:" <> If[linkstyle =!= "", linkstyle <> "/", ""] <> 
      StringReplace[filepath, {DirectoryName[filepath] -> "", ".nb" -> ""}]], 
    BaseStyle -> "Link"]], All]
    
writeLinkpacDocPath[nb_, re_, targetpathfragment_, filepath_, linkstyle_] := 
 NotebookWrite[nb, 
  TextData[ButtonBox[re, 
    ButtonData -> 
     ReplaceAmpersand["paclet:" <> RemoveLeftForwardSlashes[If[StringMatchQ[targetpathfragment, "" | (" "..)], "", targetpathfragment <> "/"] <> If[linkstyle =!= "", linkstyle <> "/", ""] <> 
      StringReplace[filepath, {DirectoryName[filepath] -> "", ".nb" -> ""}]]], 
    BaseStyle -> "Link"]], All]
    
writeLinkpacDocPathBoxData[nb_, re_, targetpathfragment_, filepath_, linkstyle_] := 
 NotebookWrite[nb, 
  ButtonBox[re, 
    ButtonData -> 
     ReplaceAmpersand["paclet:" <> RemoveLeftForwardSlashes[If[StringMatchQ[targetpathfragment, "" | (" "..)], "", targetpathfragment <> "/"] <> If[linkstyle =!= "", linkstyle <> "/", ""] <> 
      StringReplace[filepath, {DirectoryName[filepath] -> "", ".nb" -> ""}]]], 
    BaseStyle -> "Link"], All]
    
writeComboLinkpacDocPath[nb_, re_, targetpathfragment_, filepath_, linkstyle_] := 
 Module[{paclet}, 
  paclet = ReplaceAmpersand["paclet:" <> RemoveLeftForwardSlashes[If[StringMatchQ[targetpathfragment, "" | (" " ..)], "", targetpathfragment <> "/"] <> 
    If[linkstyle =!= "", linkstyle <> "/", ""] <> StringReplace[filepath, {DirectoryName[filepath] -> "", ".nb" -> ""}]]]; 
  NotebookWrite[nb, 
   TextData[If[StringQ[#], 
               ButtonBox[#, ButtonData -> paclet, BaseStyle -> "Link"], 
               StyleBox[ButtonBox[#[[1]], ButtonData -> paclet, BaseStyle -> "Link"], 
                        Sequence @@ Take[#, {2, -1}]]] & /@ re], All]]
    
writeStyledLinkpacDocPath[nb_, re_, targetpathfragment_, filepath_, linkstyle_] := 
 NotebookWrite[nb, 
  TextData[StyleBox[ButtonBox[re[[1]], 
    ButtonData -> 
     ReplaceAmpersand["paclet:" <> RemoveLeftForwardSlashes[If[StringMatchQ[targetpathfragment, "" | (" "..)], "", targetpathfragment <> "/"] <> If[linkstyle =!= "", linkstyle <> "/", ""] <> 
      StringReplace[filepath, {DirectoryName[filepath] -> "", ".nb" -> ""}]]], 
    BaseStyle -> "Link"], Sequence@@Take[re, {2, -1}]]], All]
    
writeLinkpac[nb_, re_, filepath_, linkstyle_, cellStyleAndOpts_] := 
 NotebookWrite[nb, 
  Cell[TextData[
    ButtonBox[re, 
     ButtonData -> 
      ReplaceAmpersand["paclet:" <> If[linkstyle =!= "", linkstyle <> "/", ""] <> 
       StringReplace[filepath, {DirectoryName[filepath] -> "", ".nb" -> ""}]], 
     BaseStyle -> "Link"]], Sequence @@ cellStyleAndOpts], All]
     
writeLinkpacDocPath[nb_, re_, targetpathfragment_, filepath_, linkstyle_, cellStyleAndOpts_] := 
 NotebookWrite[nb, 
  Cell[TextData[
    ButtonBox[re, 
     ButtonData -> 
      ReplaceAmpersand["paclet:" <> RemoveLeftForwardSlashes[If[StringMatchQ[targetpathfragment, "" | (" "..)], "", targetpathfragment <> "/"] <> If[linkstyle =!= "", linkstyle <> "/", ""] <> 
       StringReplace[filepath, {DirectoryName[filepath] -> "", ".nb" -> ""}]]], 
     BaseStyle -> "Link"]], Sequence @@ cellStyleAndOpts], All]
     
writeLinkpac2[nb_, re_, linkstyle_] := 
 NotebookWrite[nb, 
  TextData[ButtonBox[re, 
    ButtonData -> 
     ReplaceAmpersand["paclet:" <> If[linkstyle =!= "", linkstyle <> "/", ""] <> StringReplace[FilenameFromButtonCont[RemoveOutsideQuotes@re], ".nb" -> ""]], 
    BaseStyle -> "Link"]], All]
    
writeLinkpac2app[nb_, re_, linkstyle_, application_] :=
Module[{presetMessageOptionsValues, cs, newMessageOptionsValues, hed},
presetMessageOptionsValues = MessageOptions /. Options[$FrontEnd, MessageOptions];
   (* New MessageOptions has "KernelMessageAction" with "PrintToConsole". *)
newMessageOptionsValues = 
   If[(cs = Cases[presetMessageOptionsValues, a : ("KernelMessageAction" -> _)]; cs) === {}, 
   	     Append[presetMessageOptionsValues, "KernelMessageAction" -> {"Beep", "PrintToNotebook"}], 
   	presetMessageOptionsValues /. ("KernelMessageAction" -> a_) :> ("KernelMessageAction" -> 
   	       If[StringQ[a], "PrintToConsole", Append[DeleteCases[a, "PrintToNotebook"], "PrintToConsole"]])];
           SetOptions[$FrontEnd, MessageOptions -> newMessageOptionsValues];

           Quiet[Needs[DocumentationTools`$LinkBase <> "`"]];
           
           SetSelectedNotebook[MessagesNotebook[]];
   	(*Restore previous MessageOptions.*)
        SetOptions[$FrontEnd, MessageOptions -> presetMessageOptionsValues];
        
 If[Quiet[StringMatchQ[hed[re] /. hed -> Context, DocumentationTools`$ApplicationName ~~ __]] && StringQ[ToExpression[re <> "::usage"]],
 NotebookWrite[nb, 
    Cell[BoxData[ButtonBox[re, 
      ButtonData -> 
       ReplaceAmpersand["paclet:" <> application <> "/" <> If[linkstyle =!= "", linkstyle <> "/", ""] <> StringReplace[If[Length@StringSplit[#]>1,
                                                                                                         If[linkstyle =!= "ref", FilenameFromButtonCont[#], #],
                                                                                                         #]&[RemoveOutsideQuotes@re], ".nb" -> ""]], 
    BaseStyle -> "Link"]], "InlineFormula"], All],
 NotebookWrite[nb, 
  TextData[ButtonBox[re, 
    ButtonData -> 
     ReplaceAmpersand["paclet:" <> If[Quiet[(hed[re] /. hed -> Context) === "System`"], "", application <> "/"] <> If[linkstyle =!= "", linkstyle <> "/", ""] <> StringReplace[If[Length@StringSplit[#]>1,
                                                                                                         If[linkstyle =!= "ref", FilenameFromButtonCont[#], #],
                                                                                                         #]&[RemoveOutsideQuotes@re], ".nb" -> ""]], 
    BaseStyle -> "Link"]], All]];
    
 restoreDefault[nb]]
    
writeLinkpac2BoxData[nb_, re_, linkstyle_] := 
 NotebookWrite[nb, 
  ButtonBox[re, 
    ButtonData -> 
     ReplaceAmpersand["paclet:" <> If[linkstyle =!= "", linkstyle <> "/", ""] <> If[StringQ@re, StringReplace[FilenameFromButtonCont[RemoveOutsideQuotes@re], ".nb" -> ""], ""]], 
    BaseStyle -> "Link"], All]
    
writeLinkpac2BoxDataapp[nb_, re_, linkstyle_, application_] := 
 Module[{hed}, NotebookWrite[nb, 
  ButtonBox[re, 
    ButtonData -> 
     ReplaceAmpersand["paclet:" <> If[Quiet[(hed[re] /. hed -> Context) === "System`"], "", application <> "/"] <> If[linkstyle =!= "", linkstyle <> "/", ""] <> If[StringQ@re, StringReplace[If[linkstyle =!= "ref", FilenameFromButtonCont[#], #] &[RemoveOutsideQuotes@re], ".nb" -> ""], ""]], 
    BaseStyle -> "Link"], All]]
    
writeComboLinkpac2[nb_, re_, linkstyle_] := 
 Module[{keystring, str},
 keystring = StringJoin[re /. StyleBox[a_, __] :> a];
 str = StringReplace[FilenameFromButtonCont[keystring], ".nb" -> ""];
 NotebookWrite[nb, 
  TextData[If[StringQ[#], 
              ButtonBox[#, ButtonData -> ReplaceAmpersand["paclet:" <> RemoveLeftForwardSlashes[If[linkstyle =!= "", linkstyle <> "/", ""] <> 
               str]], BaseStyle -> "Link"], 
              StyleBox[ButtonBox[#[[1]], ButtonData -> ReplaceAmpersand["paclet:" <> RemoveLeftForwardSlashes[If[linkstyle =!= "", linkstyle <> "/", ""] <> 
               str]], BaseStyle -> "Link"], Sequence @@ Take[#, {2, -1}]]] & /@ re], All]]
               
writeComboLinkpac2app[nb_, re_, linkstyle_, application_] := 
 Module[{keystring, str},
 keystring = StringJoin[re /. StyleBox[a_, __] :> a];
 str = StringReplace[If[linkstyle =!= "ref", FilenameFromButtonCont[#], #] &[keystring], ".nb" -> ""];
 NotebookWrite[nb, 
  TextData[If[StringQ[#], 
              ButtonBox[#, ButtonData -> ReplaceAmpersand["paclet:" <> application <> "/" <> RemoveLeftForwardSlashes[If[linkstyle =!= "", linkstyle <> "/", ""] <> 
               str]], BaseStyle -> "Link"], 
              StyleBox[ButtonBox[#[[1]], ButtonData -> ReplaceAmpersand["paclet:" <> application <> "/" <> RemoveLeftForwardSlashes[If[linkstyle =!= "", linkstyle <> "/", ""] <> 
               str]], BaseStyle -> "Link"], Sequence @@ Take[#, {2, -1}]]] & /@ re], All]]
    
writeStyledLinkpac2[nb_, re_, linkstyle_] := 
 NotebookWrite[nb, 
  TextData[StyleBox[ButtonBox[re[[1]], 
    ButtonData -> 
     ReplaceAmpersand["paclet:" <> If[linkstyle =!= "", linkstyle <> "/", ""] <> StringReplace[FilenameFromButtonCont[RemoveOutsideQuotes[re[[1]]]], ".nb" -> ""]], 
    BaseStyle -> "Link"], Sequence@@Take[re, {2, -1}]]], All]
    
writeStyledLinkpac2app[nb_, re_, linkstyle_, application_] := 
 NotebookWrite[nb, 
  TextData[StyleBox[ButtonBox[re[[1]], 
    ButtonData -> 
     ReplaceAmpersand["paclet:" <> application <> "/" <> If[linkstyle =!= "", linkstyle <> "/", ""] <> StringReplace[If[linkstyle =!= "ref", FilenameFromButtonCont[#], #] &[RemoveOutsideQuotes[re[[1]]]], ".nb" -> ""]], 
    BaseStyle -> "Link"], Sequence@@Take[re, {2, -1}]]], All]
    
writeLinkpac2[nb_, re_, linkstyle_, cellStyleAndOpts_] := 
 NotebookWrite[nb, 
  Cell[TextData[
    ButtonBox[re, 
     ButtonData -> 
      ReplaceAmpersand["paclet:" <> If[linkstyle =!= "", linkstyle <> "/", ""] <> StringReplace[FilenameFromButtonCont[RemoveOutsideQuotes@re], ".nb" -> ""]], 
     BaseStyle -> "Link"]], Sequence @@ cellStyleAndOpts], All]
     
writeLinkpac2[nb_, re_, linkstyle_, application_, cellStyleAndOpts_] := 
 Module[{hed}, NotebookWrite[nb, 
  Cell[TextData[
    ButtonBox[re, 
     ButtonData -> 
      ReplaceAmpersand["paclet:" <> If[Quiet[(hed[re] /. hed -> Context) === "System`"], "", application <> "/"] <> If[linkstyle =!= "", linkstyle <> "/", ""] <> StringReplace[If[linkstyle =!= "ref", FilenameFromButtonCont[#], #] &[RemoveOutsideQuotes@re], ".nb" -> ""]], 
     BaseStyle -> "Link"]], Sequence @@ cellStyleAndOpts], All]]

(*     
RemoveWhiteSpaceAndCapitalize[x_]:= 
 StringReplace[StringReplace[If[StringQ[x], x, x[[1]]], Whitespace -> ""], LongestMatch[a_ ~~ b___] :> ToUpperCase[a] ~~ b]
*)

RemoveWhiteSpaceAndCapitalize[x_]:= StringReplace[FilenameFromButtonCont[x], ".nb" -> ""]

writeLinkpac3[nb_, re_, pac_] := 
 NotebookWrite[nb, 
  TextData[ButtonBox[re, 
    ButtonData -> 
     ReplaceAmpersand["paclet:" <> pac], 
    BaseStyle -> "Link"]], All]
    
writeLinkpac3InsideBoxData[nb_, re_, pac_] := 
 NotebookWrite[nb, 
  ButtonBox[re, 
    ButtonData -> 
     ReplaceAmpersand["paclet:" <> pac], 
    BaseStyle -> "Link"], All]
    
writeStyledLinkpac3[nb_, re_, pac_] := 
 NotebookWrite[nb, 
  TextData[StyleBox[ButtonBox[re[[1]], 
    ButtonData -> 
     ReplaceAmpersand["paclet:" <> pac], 
    BaseStyle -> "Link"], Sequence@@Take[re, {2, -1}]]], All]
    
writeComboLinkpac3[nb_, re_, pac_]:=
 Module[{paclet},
  paclet = ReplaceAmpersand["paclet:" <> pac];
  NotebookWrite[nb, 
      TextData[If[StringQ[#], 
                  ButtonBox[#, ButtonData -> paclet, BaseStyle -> "Link"], 
                  StyleBox[ButtonBox[#[[1]], ButtonData -> paclet, BaseStyle -> "Link"], 
                           Sequence @@ Take[#, {2, -1}]]] & /@ re], All]]
                           
writecomboLinkpac3[nb_, re_, pac_]:=
 Module[{paclet},
  paclet = ReplaceAmpersand["paclet:" <> pac <> If[StringMatchQ[pac, "*/"], 
                                  RemoveWhiteSpaceAndCapitalize@StringJoin[re /. StyleBox[a_, __] :> a], 
                                  "/" <> RemoveWhiteSpaceAndCapitalize@StringJoin[re /. StyleBox[a_, __] :> a]]];
  NotebookWrite[nb, 
      TextData[If[StringQ[#], 
                  ButtonBox[#, ButtonData -> paclet, BaseStyle -> "Link"], 
                  StyleBox[ButtonBox[#[[1]], ButtonData -> paclet, BaseStyle -> "Link"], 
                           Sequence @@ Take[#, {2, -1}]]] & /@ re], All]]
    
writeLinkpac3[nb_, re_, pac_, cellStyleAndOpts_] := 
 NotebookWrite[nb, 
   Cell[TextData[
     ButtonBox[re, 
      ButtonData -> 
       ReplaceAmpersand["paclet:" <> pac],
     BaseStyle -> "Link"]], Sequence @@ cellStyleAndOpts], All]
     
writeLinkpac4[nb_, re_, pac_] := 
 NotebookWrite[nb, 
  TextData[ButtonBox[re, 
    ButtonData -> 
     ReplaceAmpersand["paclet:" <> pac], 
    BaseStyle -> "Link"]], All]
    
writeLinkpac4BoxData[nb_, re_, pac_] := 
 NotebookWrite[nb, 
  ButtonBox[re, 
    ButtonData -> 
     ReplaceAmpersand["paclet:" <> pac], 
    BaseStyle -> "Link"], All]
    
writeStyledLinkpac4[nb_, re_, pac_] := 
 NotebookWrite[nb, 
  TextData[StyleBox[ButtonBox[re[[1]], 
    ButtonData -> 
     ReplaceAmpersand["paclet:" <> pac], 
    BaseStyle -> "Link"], Sequence@@Take[re, {2, -1}]]], All]
    
writeComboLinkpac4[nb_, re_, pac_] := 
 NotebookWrite[nb, 
  TextData[If[StringQ[#], 
              ButtonBox[#, ButtonData -> ReplaceAmpersand["paclet:" <> pac], BaseStyle -> "Link"], 
              StyleBox[ButtonBox[#[[1]], ButtonData -> ReplaceAmpersand["paclet:" <> pac], BaseStyle -> "Link"], 
                       Sequence @@ Take[#, {2, -1}]]] & /@ re], All]
    
writeLinkpac4[nb_, re_, pac_, cellStyleAndOpts_] := 
 NotebookWrite[nb, 
   Cell[TextData[
     ButtonBox[re, 
      ButtonData -> 
       ReplaceAmpersand["paclet:" <> pac],
     BaseStyle -> "Link"]], Sequence @@ cellStyleAndOpts], All]

ReduceToPacletPath[x_] := 
 ReplaceAmpersand@Switch[x,
        _?(StringMatchQ[#, ___ ~~ "GUIKit/ReferencePages/Widgets/" ~~ ___] &),
        StringReplace[x, ___ ~~ "GUIKit/ReferencePages/Widgets/" ~~ b___ :> "GUIKit/widget/" ~~ b],
        _?(StringMatchQ[#, "*Packages*/" ~~ (Except["/"] ..) ~~ "/Guides/*"] &), 
        StringReplace[x, ___ ~~ "Packages" ~~ ___ ~~ "/" ~~ a : (Except["/"] ..) ~~ "/Guides/" ~~ b___ :> a ~~ "/guide/" ~~ b],
        _?(StringMatchQ[#, "*Packages*/" ~~ (Except["/"] ..) ~~ "/" ~~ __ ~~ "/Guides/*"] &), 
        StringReplace[x, ___ ~~ "Packages" ~~ ___ ~~ "/" ~~ a : (Except["/"] ..) ~~ __ ~~ "/Guides/" ~~ b___ :> a ~~ "/guide/" ~~ b],
        _?(StringMatchQ[#, "*Packages*/" ~~ (Except["/"] ..) ~~ "/Tutorials/*"] &), 
        StringReplace[x, ___ ~~ "Packages" ~~ ___ ~~ "/" ~~ a : (Except["/"] ..) ~~ "/Tutorials/" ~~ b___ :> a ~~ "/tutorial/" ~~ b],
        _?(StringMatchQ[#, "*Packages*/" ~~ (Except["/"] ..) ~~ "/" ~~ __ ~~ "/Tutorials/*"] &), 
        StringReplace[x, ___ ~~ "Packages" ~~ ___ ~~ "/" ~~ a : (Except["/"] ..) ~~ "/" ~~ __ ~~ "/Tutorials/" ~~ b___ :> a ~~ "/tutorial/" ~~ b],
        _?(StringMatchQ[#, "*Packages*/" ~~ (Except["/"] ..) ~~ "/HowTos/*"] &), 
        StringReplace[x, ___ ~~ "Packages" ~~ ___ ~~ "/" ~~ a : (Except["/"] ..) ~~ "/HowTos/" ~~ b___ :> a ~~ "/howto/" ~~ b],
        _?(StringMatchQ[#, "*Packages*/" ~~ (Except["/"] ..) ~~ "/" ~~ __ ~~ "/HowTos/*"] &), 
        StringReplace[x, ___ ~~ "Packages" ~~ ___ ~~ "/" ~~ a : (Except["/"] ..) ~~ "/" ~~ __ ~~ "/HowTos/" ~~ b___ :> a ~~ "/howto/" ~~ b],
        _?(StringMatchQ[#, "*Packages*/" ~~ (Except["/"] ..) ~~ "/ReferencePages/Symbols/*"] &), 
    StringReplace[x, ___ ~~ "Packages" ~~ ___ ~~ "/" ~~ a : (Except["/"] ..) ~~ "/ReferencePages/Symbols/" ~~ b___ :> a ~~ "/ref/" ~~ b],
        _?(StringMatchQ[#, "*Packages*/" ~~ (Except["/"] ..) ~~ "/" ~~ __ ~~ "/ReferencePages/Symbols/*"] &), 
    StringReplace[x, ___ ~~ "Packages" ~~ ___ ~~ "/" ~~ a : (Except["/"] ..) ~~ "/" ~~ __ ~~ "/ReferencePages/Symbols/" ~~ b___ :> a ~~ "/ref/" ~~ b],
        _?(StringMatchQ[#, "*System/Guides/*"] &), 
        StringReplace[x, ___ ~~ "System/Guides/" ~~ b___ :> "guide/" ~~ b], 
        _?(StringMatchQ[#, "*System/Tutorials/*"] &), 
        StringReplace[x, ___ ~~ "System/Tutorials/" ~~ b___ :> "tutorial/" ~~ b], 
        _?(StringMatchQ[#, "*System/HowTos/*"] &), 
        StringReplace[x, ___ ~~ "System/HowTos/" ~~ b___ :> "howto/" ~~ b], 
        _?(StringMatchQ[#, "*System/ReferencePages/Symbols/*"] &), 
        StringReplace[x, ___ ~~ "System/ReferencePages/Symbols/" ~~ b___ :> "ref/" ~~ b], 
        _?(StringMatchQ[#, "*System/ReferencePages/Messages/" ~~ (Except["/"] ..) ~~ "/" ~~ b___] &), 
      StringReplace[x, ___ ~~ "System/ReferencePages/Messages/" ~~ a : (Except["/"] ..) ~~ "/" ~~b___ :> 
                                                                                          "ref/message/" ~~ a ~~ "/" ~~ b], 
        _?(StringMatchQ[#, ___ ~~ "System/ReferencePages/" ~~ ("AppleScript" | "C") ~~ "/" ~~ b___] &),
        StringReplace[x, ___ ~~ "System/ReferencePages/" ~~ a:("AppleScript" | "C") ~~ "/" ~~ b___ :> 
                                                                       "ref/" ~~ If[a==="C", "c", "applescript"]~~"/" ~~ b],
        _?(StringMatchQ[#, "*System/ReferencePages/" ~~ (Except["/"] ..) ~~ "/" ~~ b___] &),
        StringReplace[x, ___ ~~ "System/ReferencePages/" ~~ a : (Except["/"] ..) ~~ "/" ~~ b___ :> 
                              "ref/" ~~ StringReplace[a, LongestMatch[c__ ~~ "s"] :> ToLowerCase[c]] ~~"/" ~~ b],
        _?(StringMatchQ[#, "*/ReferencePages/Symbols/*"] &),
        StringReplace[x, "ReferencePages/Symbols"->"ref"],
        _?(StringMatchQ[#, "*/Guides/*"] &),
        StringReplace[x, "Guides"->"guide"],
        _?(StringMatchQ[#, "*/Tutorials/*"] &),
        StringReplace[x, "Tutorials"->"tutorial"],
        _?(StringMatchQ[#, "*/HowTos/*"] &),
        StringReplace[x, "HowTos"->"howto"],
        _, 
        x]
        
ReplaceAmpersand[x_String] := StringReplace[x, "&"->"And"]
     
$PacletInteractiveFieldValue = ""

SetPacletInteractive::nocont = "The input field has no content.";
SetPacletInteractive::noin = "There is no open input notebook.";
SetPacletInteractive::mulcell = "Multiple cells have been selected";
SetPacletInteractive::betwcells = "The cursor is between cells.";
SetPacletInteractive::emptysel = "The selection has no content.";
SetPacletInteractive::stringsel = "A non-empty selection must be a string, style box, a sequence of style boxes or a cell consisting of just a string or the interior of a BoxData expression.";

SetPacletInteractive[customlinkarg_String, sel_String] := 
 Module[{nb},
  $PacletInteractiveFieldValue = $PacletURI <> If[StringMatchQ[$PacletURI, "*/" | (" "..) | ""], "", "/"] <> customlinkarg <> If[customlinkarg =!= "", "/", ""]  <> ReplaceAmpersand@RemoveWhiteSpaceAndCapitalize@RemoveOutsideQuotes@sel; 
  $PacletInteractiveFieldValue = ReduceToPacletPath[$PacletInteractiveFieldValue];
  nb = NotebookPut[
   Notebook[{Cell["",FontSize->1,CellElementSpacings->{"CellMinHeight"->1},Selectable->False],
             Cell[BoxData[ToBoxes@Style[Grid[{{Style["paclet:", Bold, Editable -> False, Selectable -> False], 
                                               InputField[Dynamic[$PacletInteractiveFieldValue], String, 
                                                          FieldSize -> {58, {1, Infinity}},
                                                          ContinuousAction->True]}, 
                                              {Style["", Editable -> False, Selectable -> False], 
                                               OldRow[{Button[Style["OK", Editable -> False, Deletable -> False, Bold],
                                                              OKPacletInteractive[], Method -> "Queued"], 
                                                       Button[Style["Cancel", Editable -> False, Deletable -> False, Bold],
                                                              NotebookClose[EvaluationNotebook[]], 
                                                              Method -> "Queued"]}]}}, ColumnAlignments -> Left], 
                                        FontFamily -> "Helvetica"]]],
             Cell["",FontSize->1,CellElementSpacings->{"CellMinHeight"->1},Selectable->False]}, 
            WindowSize -> FitAll, 
            WindowMargins -> {{Automatic, 100}, {Automatic, Automatic}}, 
            WindowFrame -> "Palette", 
            WindowElements -> {}, 
            WindowFrameElements -> {},
            ShowCellBracket -> False, 
            ClosingAutoSave -> False, 
            WindowTitle -> "Edit paclet path",
            WindowFloating -> False,
            Saveable -> False,
            NotebookEventActions -> {"ReturnKeyDown" :> OKPacletInteractive[]},
            ShowStringCharacters -> False]];
   SelectionMove[nb, Before, Notebook];
   SelectionMove[nb, Next, Cell, 2];
   SelectionMove[nb, After, CellContents];
   FrontEndTokenExecute[nb, "Tab"];
   SetSelectedNotebook[nb]]
   
SetPacletInteractive[customlinkarg_String] := 
 Module[{nb},
  $PacletInteractiveFieldValue = $PacletURI <> If[StringMatchQ[$PacletURI, "*/" | (" "..) | ""], "", "/"] <> customlinkarg <> If[customlinkarg =!= "", "/", ""]; 
  $PacletInteractiveFieldValue = ReduceToPacletPath[$PacletInteractiveFieldValue];
  nb = NotebookPut[
   Notebook[{Cell["",FontSize->1,CellElementSpacings->{"CellMinHeight"->1},Selectable->False],
             Cell[BoxData[ToBoxes@Style[Grid[{{Style["paclet:", Bold, Editable -> False, Selectable -> False], 
                                               InputField[Dynamic[$PacletInteractiveFieldValue], String, 
                                                          FieldSize -> {58, {1, Infinity}},
                                                          ContinuousAction->True]}, 
                                              {Style["", Editable -> False, Selectable -> False], 
                                               OldRow[{Button[Style["OK", Editable -> False, Deletable -> False, Bold], 
                                                              OKPacletInteractive[], Method -> "Queued"], 
                                                       Button[Style["Cancel", Editable -> False, Deletable -> False, Bold],
                                                              NotebookClose[EvaluationNotebook[]], 
                                                              Method -> "Queued"]}]}}, ColumnAlignments -> Left], 
                                        FontFamily -> "Helvetica"]]],
             Cell["",FontSize->1,CellElementSpacings->{"CellMinHeight"->1},Selectable->False]}, 
            WindowSize -> FitAll, 
            WindowMargins -> {{Automatic, 100}, {Automatic, Automatic}}, 
            WindowFrame -> "Palette", 
            WindowElements -> {}, 
            WindowFrameElements -> {},
            ShowCellBracket -> False, 
            ClosingAutoSave -> False, 
            WindowTitle -> "Edit paclet path",
            WindowFloating -> False,
            Saveable -> False,
            NotebookEventActions -> {"ReturnKeyDown" :> OKPacletInteractive[]}, 
            ShowStringCharacters -> False]];
   SelectionMove[nb, Before, Notebook];
   SelectionMove[nb, Next, Cell, 2];
   SelectionMove[nb, After, CellContents];
   FrontEndTokenExecute[nb, "Tab"];
   SetSelectedNotebook[nb]]


OKPacletInteractive[] := 
 Module[{nb, ci, re, re2}, 
  Catch[If[Not@StringMatchQ[$PacletInteractiveFieldValue, "" | " "..],
  
           nb = NextNotebook[]; 
        If[nb === None, 
           Throw[MessageToConsole[SetPacletInteractive::noin]]]; 
        ci = CellInfo[nb];
        If[(* Multiple cell brackets are selected. *)
           multipleCellBracketsSelected[ci], 
           Throw[MessageToConsole[SetPacletInteractive::mulcell]]];
        If[(* The cursor is between cells. *)
           ci === $Failed, 
           Throw[MessageToConsole[SetPacletInteractive::betwcells]]];
        re = OldNotebookRead[nb];
        re2 = NotebookRead[nb];
        If[(* The cursor is inside a cell or selecting a cell with no content. *)
           MatchQ[re, {} | Cell["", __]], 
           Throw[MessageToConsole[SetPacletInteractive::emptysel]]];
        If[Not[MatchQ[re, _String | StyleBox[__] | {(StyleBox[__] | _String)..} | Cell[_String, __]] || 
                                                               (MatchQ[re, BoxData[_]] && Not@MatchQ[re2, BoxData[_]])], 
           Throw[MessageToConsole[SetPacletInteractive::stringsel]]]; 
        Which[MatchQ[re, Cell[__]], 
              writeLinkpac3[nb, re[[1]], $PacletInteractiveFieldValue, Take[re, {2, -1}]],
              MatchQ[re, _String],
              writeLinkpac3[nb, re, $PacletInteractiveFieldValue];
              restoreDefault[nb],
              MatchQ[re, BoxData[_]] && Not@MatchQ[re2, BoxData[_]],
          writeLinkpac3InsideBoxData[nb, re2, $PacletInteractiveFieldValue];
          restoreDefault[nb],
              MatchQ[re, {(StyleBox[__] | _String)..}],
              writeComboLinkpac3[nb, re, $PacletInteractiveFieldValue];
              restoreDefault[nb],
              True,
              writeStyledLinkpac3[nb, re, $PacletInteractiveFieldValue];
              restoreDefault[nb]];
        SetSelectedNotebook[nb];
        NotebookClose[EvaluationNotebook[]],
        
        MessageToConsole[SetPacletInteractive::nocont]]]]
        
OKCustomLinkConfigureApply::$LinkBasenotset = "$LinkBase needs to be set.";
OKCustomLinkConfigureApply::pacletsymbsnotset = "$ApplicationName and/or $LinkBase need to be set.";
        
OKCustomLinkConfigureApply[d_, previousapplicationname_, previouslinkbase_]:= 
 Which[d === "ref" && (StringMatchQ[$ApplicationName, Whitespace | ""] || StringMatchQ[$LinkBase, Whitespace | ""]),
       MessageToConsole[OKCustomLinkConfigureApply::pacletsymbsnotset],
       StringMatchQ[$LinkBase, Whitespace | ""],
       MessageToConsole[OKCustomLinkConfigureApply::$LinkBasenotset],
       True,
       If[d === "ref",
          UpdatePacletVariables[previousapplicationname, previouslinkbase],
          If[previouslinkbase =!= $LinkBase && $LinkBase =!= $ApplicationName, 
             DocumentationTools`Utilities`$LinkBase = $LinkBase;
             SetDocuToolsParametersInFEInit[{"$LinkBase" -> $LinkBase}]]];
        CustomLink[d, Interactive -> False, LinkBase -> $LinkBase];
        NotebookClose[EvaluationNotebook[]]]

CustomLink["ConfigureApply", d : ("guide" | "ref" | "tutorial" | "howto")] := 
 Module[{nb, s, a, b, u, v}, a = DocumentationTools`$ApplicationName; b = DocumentationTools`$LinkBase;
  nb = NotebookPut[Notebook[{Cell["", FontSize -> 1, CellElementSpacings -> {"CellMinHeight" -> 1}, Selectable -> False],
                             Cell[TextData[{"Make a ", 
                                            StyleBox[Switch[d, "guide", "Guide", "howto", "How To", "tutorial", "Tutorial", "ref", "Reference Page"], FontWeight->"Bold"], 
                                            " link."}], "Text", Selectable -> False, CellMargins -> {{7, 10}, {5, 5}}],
      Cell[BoxData[ToBoxes@Style[Grid[{If[MatchQ[d, "guide" | "howto" | "tutorial"],
                                       {Style["Link Base: ", Bold, Editable -> False, Selectable -> False], 
                                        InputField[Dynamic[DocumentationTools`$LinkBase], String, FieldSize -> {58, {1, Infinity}}]},
                                       Unevaluated[Sequence[{Style["Application Name: ", Bold, Editable -> False, Selectable -> False], 
                                        InputField[Dynamic[DocumentationTools`$ApplicationName], String, FieldSize -> {58, {1, Infinity}}]},
                                       {Style["Link Base: ", Bold, Editable -> False, Selectable -> False], 
                                        InputField[Dynamic[DocumentationTools`$LinkBase], String, FieldSize -> {58, {1, Infinity}}]}]]], 
                                       {Style["", Editable -> False, Selectable -> False], 
                                        OldRow[{Button[Style["OK", Editable -> False, Deletable -> False, Bold], 
                                                       OKCustomLinkConfigureApply[s, u, v], 
                                                       Method -> "Queued"] /. {s -> d, u -> a, v -> b}, 
                                                Button[Style["Cancel", Editable -> False, Deletable -> False, Bold], 
                                                       (DocumentationTools`$ApplicationName = u; DocumentationTools`$LinkBase = v;
                                                       NotebookClose[EvaluationNotebook[]]), 
                                                       Method -> "Queued"] /. {u -> a, v -> b}}, 
                                               RowAlignments -> Center]}}, 
                                               ColumnAlignments -> Left, ColumnSpacings -> .2], 
           FontFamily -> "Helvetica"]]], 
      Cell["", FontSize -> 1, CellElementSpacings -> {"CellMinHeight" -> 1}, Selectable -> False]}, 
                            WindowSize -> FitAll, 
                            WindowMargins -> {{Automatic, 100}, {Automatic, Automatic}}, 
                            WindowFrame -> "Palette", WindowElements -> {}, 
                            WindowFrameElements -> {}, 
                            ShowCellBracket -> False, 
                            ClosingAutoSave -> False, 
                            WindowTitle -> If[d === "ref", "Set $ApplicationName and $LinkBase and Link to Selection", "Set $LinkBase and Link to Selection"], 
                            Saveable -> False, 
                            ShowStringCharacters -> False]];
  SelectionMove[nb, Before, Notebook];
  SelectionMove[nb, Next, Cell, 2];
  SelectionMove[nb, After, CellContents];
  FrontEndTokenExecute[nb, "Tab"];
  SetSelectedNotebook[nb]]
  

$ApplicationGuidesFile = ""
$ApplicationHowToFile = ""
$ApplicationTutorialsFile = ""
$ApplicationReferencePageFile = ""

CustomLink["PacletDocSelect", d : ("guide" | "howto" | "tutorial" | "ref")] := 
 Module[{nb = NextNotebook[], ci, re, re2, documentpath, e, rules, application, filename, presetMessageOptionsValues, newMessageOptionsValues,
         cellStyleAndOpts, cs, application2, hed}, 
  Catch[If[(*No input notebook exists.*)nb === $Failed, 
           Throw[MessageToConsole[CustomLink::noin]]];
        ci = CellInfo[nb];
        If[(*Multiple cell brackets are selected.*)
           multipleCellBracketsSelected[ci], 
           Throw[MessageToConsole[CustomLink::mulcell]]];
        If[(*The cursor is between cells.*)ci === $Failed, 
           Throw[MessageToConsole[CustomLink::betwcells]]];
        re = OldNotebookRead[nb];
        re2 = NotebookRead[nb];
        If[(*The cursor is inside a cell or selecting a cell with no content.*)MatchQ[re, {} | Cell["", __]], 
           Throw[MessageToConsole[CustomLink::emptysel]]];
        If[Not[MatchQ[re, _String | StyleBox[__] | {(StyleBox[__] | _String) ..} | Cell[_String, __]] || 
                (MatchQ[re, BoxData[_]] && Not@MatchQ[re2, BoxData[_]])], 
           Throw[MessageToConsole[CustomLink::stringsel]]];
        If[(* $ApplicationName is not set. *)StringMatchQ[DocumentationTools`$ApplicationName, "" | Whitespace], 
	   Throw[MessageToConsole[CustomLink::$ApplicationNamenotset]]];
	If[(* $LinkBase is not set. *)StringMatchQ[DocumentationTools`$LinkBase, "" | Whitespace], 
           Throw[MessageToConsole[CustomLink::$LinkBasenotset]]];
        DocumentationDirSelect[$DocumentationDirectory];
     Quiet[Switch[d, 
                  "guide", 
                 If[# =!= Null && # =!= $Canceled, 
                    $ApplicationGuidesFile = #, 
                    Abort[]] &[SystemDialogInput["FileOpen", $GuideDirectory, WindowTitle -> "Browse for guide link file"]], 
                 "howto", 
                 If[# =!= Null && # =!= $Canceled, 
                    $ApplicationHowToFile = #, 
                    Abort[]] &[SystemDialogInput["FileOpen", $HowToDirectory, WindowTitle -> "Browse for how to link file"]], 
                 "tutorial", 
                 If[# =!= Null && # =!= $Canceled, 
                    $ApplicationTutorialsFile = #, 
                    Abort[]] &[SystemDialogInput["FileOpen", $TutorialDirectory, WindowTitle -> "Browse for tutorial link file"]], 
                 "ref", 
                 If[# =!= Null && # =!= $Canceled, 
                    $ApplicationReferencePageFile = #, 
                    Abort[]] &[SystemDialogInput["FileOpen", $FunctionDirectory, WindowTitle -> "Browse for reference link file"]]], 
           FileType::"fstr"];
      documentpath = Switch[d, "guide", $ApplicationGuidesFile, "howto", $ApplicationHowToFile, "tutorial", $ApplicationTutorialsFile,
                        _, $ApplicationReferencePageFile];
      If[StringMatchQ[documentpath,
                      __ ~~ $PathnameSeparator ~~ "System" ~~ $PathnameSeparator ~~ __], 
         Throw[MessageToConsole[CustomLink::sysdoc]]];
     If[(d === "guide" || d === "howto" || d === "tutorial") && Not@StringMatchQ[documentpath,
        (__ ~~ $PathnameSeparator ~~ (Except[$PathnameSeparator] ..) ~~ $PathnameSeparator ~~ "Documentation" ~~ $PathnameSeparator ~~ $Language ~~ $PathnameSeparator ~~ Switch[d, "guide", "Guides", "howto", "HowTos", _, "Tutorials"] ~~ $PathnameSeparator ~~ (Except[$PathnameSeparator] ..) ~~ ".nb") | 
         (__ ~~ $PathnameSeparator ~~ (Except[$PathnameSeparator] ..) ~~ $PathnameSeparator ~~ $Language ~~ $PathnameSeparator ~~ Switch[d, "guide", "Guides", "howto", "HowTos", _, "Tutorials"] ~~ $PathnameSeparator ~~ (Except[$PathnameSeparator] ..) ~~ ".nb") | 
         (__ ~~ $PathnameSeparator ~~ (Except[$PathnameSeparator] ..) ~~ $PathnameSeparator ~~ Switch[d, "guide", "Guides", "howto", "HowTos", _, "Tutorials"] ~~ $PathnameSeparator ~~ (Except[$PathnameSeparator] ..) ~~ ".nb")], 
    Throw[MessageToConsole[CustomLink::wrongdir, If[d === "guide", "Guides", "Tutorials"]]]];
     If[d === "ref" && Not@StringMatchQ[documentpath,
             (__ ~~ $PathnameSeparator ~~ (Except[$PathnameSeparator] ..) ~~ $PathnameSeparator ~~ "Documentation" ~~ $PathnameSeparator ~~ $Language ~~ $PathnameSeparator ~~ "ReferencePages" ~~ $PathnameSeparator ~~ "Symbols" ~~ $PathnameSeparator ~~ (Except[$PathnameSeparator] ..) ~~ ".nb") | 
              (__ ~~ $PathnameSeparator ~~ (Except[$PathnameSeparator] ..) ~~ $PathnameSeparator ~~ $Language ~~ $PathnameSeparator ~~ "ReferencePages" ~~ $PathnameSeparator ~~ "Symbols" ~~ $PathnameSeparator ~~ (Except[$PathnameSeparator] ..) ~~ ".nb") | 
              (__ ~~ $PathnameSeparator ~~ (Except[$PathnameSeparator] ..) ~~ $PathnameSeparator ~~ "ReferencePages" ~~ $PathnameSeparator ~~ "Symbols" ~~ $PathnameSeparator ~~ (Except[$PathnameSeparator] ..) ~~ ".nb")], 
    Throw[MessageToConsole[CustomLink::wrongdir, "ReferencePages/Symbols"]]];
     e = Switch[d, "guide", "Guides", "howto", "HowTos", "tutorial", "Tutorials", _, "ReferencePages" ~~ $PathnameSeparator ~~ "Symbols"]; 
   rules = {__ ~~ $PathnameSeparator ~~ ap : (Except[$PathnameSeparator] ..) ~~ $PathnameSeparator ~~ "Documentation" ~~ $PathnameSeparator ~~ $Language ~~ $PathnameSeparator ~~ e ~~ $PathnameSeparator ~~ a__ ~~ ".nb" :> {ap, a}, 
            __ ~~ $PathnameSeparator ~~ ap : (Except[$PathnameSeparator] ..) ~~ $PathnameSeparator ~~ $Language ~~ $PathnameSeparator ~~ e ~~ $PathnameSeparator ~~ a__ ~~ ".nb" :> {ap, a}, 
            __ ~~ $PathnameSeparator ~~ ap : (Except[$PathnameSeparator] ..) ~~ $PathnameSeparator ~~ e ~~ $PathnameSeparator ~~ a__ ~~ ".nb" :> {ap, a}}; 
   {application, filename} = StringReplace[documentpath, rules][[1]];
   
If[d === "ref",
   
   presetMessageOptionsValues = MessageOptions /. Options[$FrontEnd, MessageOptions];
   (* New MessageOptions has "KernelMessageAction" with "PrintToConsole". *)
   newMessageOptionsValues = 
   If[(cs = Cases[presetMessageOptionsValues, a : ("KernelMessageAction" -> _)]; cs) === {}, 
   	     Append[presetMessageOptionsValues, "KernelMessageAction" -> {"Beep", "PrintToNotebook"}], 
   	presetMessageOptionsValues /. ("KernelMessageAction" -> a_) :> ("KernelMessageAction" -> 
   	       If[StringQ[a], "PrintToConsole", Append[DeleteCases[a, "PrintToNotebook"], "PrintToConsole"]])];
           SetOptions[$FrontEnd, MessageOptions -> newMessageOptionsValues];
           
           Quiet[Needs[DocumentationTools`$LinkBase <> "`"]];
           
           SetSelectedNotebook[MessagesNotebook[]];
   	(*Restore previous MessageOptions.*)
        SetOptions[$FrontEnd, MessageOptions -> presetMessageOptionsValues]];
        
   application2 = If[DocumentationTools`$LinkBase === application, DocumentationTools`$LinkBase, application];
        
   Which[MatchQ[re, _String],
         If[d === "ref" && Quiet[Head[(hed[re] /. hed -> Context)] =!= Context, 
                         Context::"notfound"] && StringMatchQ[hed[re] /. hed -> Context, DocumentationTools`$ApplicationName ~~ __] && StringQ[ToExpression[re <> "::usage"]],
            NotebookWrite[nb, Cell[BoxData[ButtonBox[re, 
                  ButtonData -> "paclet:" <> application2 <> "/" <> d <> "/" <> filename, BaseStyle -> "Link"]],
                                   "InlineFormula"], All],
            NotebookWrite[nb, TextData[ButtonBox[re, 
                  ButtonData -> "paclet:" <> application2 <> "/" <> d <> "/" <> filename, BaseStyle -> "Link"]], All]];
         restoreDefault[nb], 
         (MatchQ[re, BoxData[_]] && Not@MatchQ[re2, BoxData[_]]), 
         NotebookWrite[nb, ButtonBox[re2, 
                   ButtonData -> "paclet:" <> application2 <> "/" <> d <> "/" <> filename, BaseStyle -> "Link"], All];
         restoreDefault[nb], 
         MatchQ[re, Cell[_String, __]], 
         cellStyleAndOpts = Take[re, {2, -1}];
         NotebookWrite[nb, Cell[TextData[ButtonBox[re, 
        ButtonData -> "paclet:" <> application2 <> "/" <> d <> "/" <> filename, BaseStyle -> "Link"]], 
                                                                                        Sequence @@ cellStyleAndOpts], All], 
         MatchQ[re, {(StyleBox[__] | _String) ..}], 
         NotebookWrite[nb, 
           TextData[If[StringQ[#], 
             ButtonBox[#, ButtonData -> "paclet:" <> application2 <> "/" <> d <> "/" <> filename, BaseStyle -> "Link"], 
             StyleBox[ButtonBox[#[[1]], ButtonData -> "paclet:" <> application2 <> "/" <> d <> "/" <> filename, BaseStyle -> "Link"], 
          Sequence @@ Take[#, {2, -1}]]] & /@ re], All]; 
         restoreDefault[nb], 
         True, 
         NotebookWrite[nb, TextData[StyleBox[ButtonBox[re[[1]], 
                          ButtonData -> "paclet:" <> application2 <> "/" <> d <> "/" <> filename, BaseStyle -> "Link"], 
          Sequence @@ Take[re, {2, -1}]]], All];
         restoreDefault[nb]]]]
         
$ApplicationDocument = "";

ReduceDirectoryName[dir_] := 
 If[StringCount[dir, _?UpperCaseQ] > 1, 
    dir, 
    If[StringMatchQ[dir, __ ~~ "s"], ToLowerCase[StringDrop[dir, -1]], ToLowerCase[dir]]]
    

CustomLink["PacletDocSelect"] := 
 Module[{nb = NextNotebook[], ci, re, re2, documentpath, rule, paclet, cellStyleAndOpts}, 
  Catch[If[(* No input notebook exists. *)nb === $Failed, 
           Throw[MessageToConsole[CustomLink::noin]]];
        ci = CellInfo[nb];
        If[(* Multiple cell brackets are selected. *)multipleCellBracketsSelected[ci], 
           Throw[MessageToConsole[CustomLink::mulcell]]];
        If[(*The cursor is between cells.*)ci === $Failed, 
           Throw[MessageToConsole[CustomLink::betwcells]]];
        re = OldNotebookRead[nb];
        re2 = NotebookRead[nb];
        If[(* The cursor is inside a cell or selecting a cell with no content. *)MatchQ[re, {} | Cell["", __]], 
           Throw[MessageToConsole[CustomLink::emptysel]]];
        If[Not[MatchQ[re, _String | StyleBox[__] | {(StyleBox[__] | _String) ..} | Cell[_String, __]] || 
            (MatchQ[re, BoxData[_]] && Not@MatchQ[re2, BoxData[_]])], 
           Throw[MessageToConsole[CustomLink::stringsel]]]; 
        If[(* $ApplicationName is not set. *)StringMatchQ[DocumentationTools`$ApplicationName, "" | Whitespace], 
           Throw[MessageToConsole[CustomLink::$ApplicationNamenotset]]];
        If[(* $LinkBase is not set. *)StringMatchQ[DocumentationTools`$LinkBase, "" | Whitespace], 
           Throw[MessageToConsole[CustomLink::$LinkBasenotset]]];
           
        Quiet[If[$ApplicationDocument =!= "" && FileType[$ApplicationDocument] === File, 
                 If[# =!= Null && # =!= $Canceled, $ApplicationDocument = #, Abort[]] &[
                  SystemDialogInput["FileOpen", {$ApplicationDocument, {".nb" -> {"*.nb"}, ".pdf" -> {"*.pdf"}}}, 
                                    WindowTitle -> "Select notebook or pdf file for document link"]], 
                 While[FileType[$ApplicationDocument] =!= File, 
                       If[# =!= Null && # =!= $Canceled, $ApplicationDocument = #, Abort[]] &[
                        SystemDialogInput["FileOpen", {$ApplicationDocument, {".nb" -> {"*.nb"}, ".pdf" -> {"*.pdf"}}}, 
                                          WindowTitle -> "Select notebook or pdf file for document link"]]]], 
              FileType::"fstr"];
              
        documentpath = $ApplicationDocument;
        
   If[StringMatchQ[documentpath, __ ~~ $PathnameSeparator ~~ "System" ~~ $PathnameSeparator ~~ __], 
      Throw[MessageToConsole[CustomLink::sysdoc]]];
           
   If[Not@StringMatchQ[documentpath, 
   (__ ~~ $PathnameSeparator ~~ (Except[$PathnameSeparator] ..) ~~ $PathnameSeparator ~~ "Documentation" ~~ $PathnameSeparator ~~ $Language ~~ $PathnameSeparator ~~ __ ~~ $PathnameSeparator ~~ (Except[$PathnameSeparator] ..) ~~ (".nb" | ".pdf"))], 
      Throw[MessageToConsole[CustomLink::wrongdir2]]];
      
   rule = (__ ~~ $PathnameSeparator ~~ application:(Except[$PathnameSeparator] ..) ~~ $PathnameSeparator ~~ "Documentation" ~~ $PathnameSeparator ~~ $Language ~~ $PathnameSeparator ~~ dir__ ~~ $PathnameSeparator ~~ f : (Except[$PathnameSeparator] ..) ~~ (".nb" | ".pdf")) :> {If[DocumentationTools`$LinkBase === application, DocumentationTools`$LinkBase, application], ReduceDirectoryName /@ StringSplit[dir, $PathnameSeparator], f};
            
   paclet = If[StringMatchQ[documentpath, __~~".pdf"], StringJoin[#, ".pdf"], #]&[StringJoin@@Riffle[Flatten[(StringReplace[documentpath, rule] /. {"ReferencePages", "symbol"} -> {"ref"})[[1]]], "/"]];
   
   Which[MatchQ[re, _String], 
         NotebookWrite[nb, TextData[ButtonBox[re, ButtonData -> "paclet:" <> paclet, BaseStyle -> "Link"]], All];
         restoreDefault[nb], 
         (MatchQ[re, BoxData[_]] && Not@MatchQ[re2, BoxData[_]]), 
         NotebookWrite[nb, ButtonBox[re, ButtonData -> "paclet:" <> paclet, BaseStyle -> "Link"], All];
         restoreDefault[nb], 
         MatchQ[re, Cell[_String, __]], 
         cellStyleAndOpts = Take[re, {2, -1}];
         NotebookWrite[nb, Cell[TextData[ButtonBox[re, ButtonData -> "paclet:" <> paclet, BaseStyle -> "Link"]], 
                                Sequence @@ cellStyleAndOpts], All], 
         MatchQ[re, {(StyleBox[__] | _String) ..}], 
         NotebookWrite[nb, 
                       TextData[If[StringQ[#], 
                                   ButtonBox[#, ButtonData -> "paclet:" <> paclet, BaseStyle -> "Link"], 
                                   StyleBox[ButtonBox[#[[1]], ButtonData -> "paclet:" <> paclet, BaseStyle -> "Link"], 
                                            Sequence @@ Take[#, {2, -1}]]] & /@ re], All];
         restoreDefault[nb], 
         True, 
         NotebookWrite[nb, TextData[StyleBox[ButtonBox[re[[1]], ButtonData -> "paclet:" <> paclet, 
                                                       BaseStyle -> "Link"], Sequence @@ Take[re, {2, -1}]]], All];
         restoreDefault[nb]]]]
     
CustomLink[]:= CustomLink[Interactive -> True]

CustomLink[linkstyle_String]:= CustomLink[linkstyle, Interactive -> True]

CustomLink[linkstyle_String, opts__]:=
 Module[{target, contentlabels, addedLabel, str, cachedDirectory, interactive, pacletInteractive, targetPreset, 
         application, nb=NextNotebook[], ci, filepath, path, targetpathfragment, re, re2, dnb, cellStyleAndOpts, pac, docpath, patt},

        target = Target /. {opts} /. Options[CustomLink];
        contentlabels = ContentLabels /. {opts} /. Options[CustomLink];
        $CustomLinkmatch = ButtonContentsSelection /. {opts} /. Options[CustomLink];
        addedLabel = AddedLabel /. {opts} /. Options[CustomLink];

        cachedDirectory = CacheLastDirectory/.{opts}/.Options[CustomLink];
        interactive = Interactive/.{opts}/.Options[CustomLink];
        pacletInteractive = PacletInteractive/.{opts}/.Options[CustomLink];
        targetPreset = TargetPreset/.{opts}/.Options[CustomLink];
        
        application = LinkBase/.{opts}/.Options[CustomLink];
        
        If[interactive, pacletInteractive = False; targetPreset = False];
        
  Catch[If[(* No input notebook exists. *)
           nb===$Failed,
           Throw[MessageToConsole[CustomLink::noin]]];
           
        ci=CellInfo[nb];
        
        If[(* Multiple cell brackets are selected. *)
           multipleCellBracketsSelected[ci],
           Throw[MessageToConsole[CustomLink::mulcell]]];
           
        If[(* The cursor is between cells. *)
           ci === $Failed, 
           Throw[MessageToConsole[CustomLink::betwcells]]];
                 
        re=OldNotebookRead[nb];
        re2 = NotebookRead[nb];
        
        If[(* The cursor is inside a cell or selecting a cell with no content. *)
           MatchQ[re, {} | Cell["", __]],
           Throw[MessageToConsole[CustomLink::emptysel]]];
           
        If[Not[MatchQ[re, _String | StyleBox[__] | {(StyleBox[__] | _String)..} | Cell[_String, __]] || 
                                                               (MatchQ[re, BoxData[_]] && Not@MatchQ[re2, BoxData[_]])],
           Throw[MessageToConsole[CustomLink::stringsel]]];
           
     If[target === "URL",
     
        (* $CustomLinkLength gives the dialog length. *)
        $CustomLinkLength = If[addedLabel =!= None, Fit, 509];
        If[addedLabel =!=None, $CustomLinkmatch = addedLabel];
        If[$CustomLinkmatch === "Custom", $custom = True, $custom = False];
dnb = NotebookPut[Notebook[{Cell["",FontSize->1,CellElementSpacings->{"CellMinHeight"->1},Selectable->False], 
                        Cell[BoxData[ToBoxes@Style[Column[{OldRow[{Style["URL:", Bold, Editable -> False, 
                                                                         Selectable -> False], 
                InputField[Dynamic[$URLValue], String, FieldSize -> {58, {1, Infinity}}]}, 
               ColumnSpacings -> .2, RowAlignments -> Center],
        Which[contentlabels === None, 
              $custom = False; Unevaluated[Sequence[]],
              MatchQ[contentlabels, {_String, _String..}],
              $CustomLinkmatch = contentlabels[[1]];
              OldRow[Prepend[OldRow[#, ColumnSpacings -> .1, RowAlignments -> Center] & /@ 
   Partition[Flatten[Transpose[{RadioButton[Dynamic[$CustomLinkmatch, ($CustomLinkmatch = #;
             $custom = False;
             SetOptions[EvaluationNotebook[], WindowSize -> FitAll]) &], #] & /@ contentlabels, 
                                Style[#, Editable -> False, Selectable -> False] &/@ contentlabels}]], 2], 
                             Style["Button Contents:", Bold, Editable -> False, Selectable -> False]], 
 ColumnSpacings -> .2, RowAlignments -> Center],
              True,
           OldRow[Prepend[OldRow[#, ColumnSpacings -> .1, RowAlignments -> Center] & /@ 
    Partition[Flatten[Transpose[{RadioButton[Dynamic[$CustomLinkmatch, 
                                                     ($CustomLinkmatch = #; 
                                                      If[$CustomLinkmatch === "Custom", 
                                                         $custom = True; 
                                                         SetOptions[EvaluationNotebook[], WindowSize -> FitAll,
                                                                    ScrollingOptions -> {"VerticalScrollRange" -> Fit}], 
                                                         $custom = False; 
                                                         SetOptions[EvaluationNotebook[], 
                                                         WindowSize -> FitAll]]) &], #] & /@ 
     If[addedLabel === None, 
        {"ButtonContents", "MoreInfo", "URL", "Custom"},
        {"ButtonContents", "MoreInfo", "URL", addedLabel, "Custom"}], 
       
     If[addedLabel === None,
        Style[#, Editable -> False, Selectable -> False] &/@{"Leave button contents", "[more info]", "URL", "Custom"},
        Style[#, Editable -> False, Selectable -> False] &/@{"Leave button contents", "[more info]", "URL", addedLabel, 
                                                             "Custom"}]}]], 2], 
                       Style["Button Contents:", Bold, Editable -> False, Selectable -> False]], 
               ColumnSpacings -> .2, RowAlignments -> Center]], 
           Dynamic[If[$custom, 
                      Column[{OldRow[{Style["Custom Contents:", Bold, Editable -> False, Selectable -> False], 
                              InputField[Dynamic[$customcontent], String, FieldSize -> {48, {1, Infinity}}]}, 
                                  ColumnSpacings -> .2, RowAlignments -> Center], 
                              OldRow[{Button[Style["OK", Bold], OKCustomLink[linkstyle, AddedLabel -> addedLabel];
                                                             NotebookClose[EvaluationNotebook[]],
                                          Method -> "Queued"], 
                                   Button[Style["Cancel", Bold], NotebookClose[EvaluationNotebook[]],
                                          Method -> "Queued"]}, 
                                   RowAlignments -> Center]}], 
                      OldRow[{Button[Style["OK", Bold], OKCustomLink[linkstyle, AddedLabel -> addedLabel, 
                                                                     Contentlbls -> If[MatchQ[contentlabels, 
                                                                                              {_String, _String..}], 
                                                                                       True, 
                                                                                       None]];
                                                     NotebookClose[EvaluationNotebook[]];
                                                     If[# =!= None, SetSelectedNotebook[#], Null] &[NextNotebook[]],
                                  Method -> "Queued"], 
                           Button[Style["Cancel", Bold], NotebookClose[EvaluationNotebook[]];
                                                         If[# =!= None, SetSelectedNotebook[#], Null] &[NextNotebook[]],
                                  Method -> "Queued"]}, 
                          RowAlignments -> Center]]]}], 
                                                   FontFamily -> "Helvetica"]]],
                     Cell["",FontSize->1,CellElementSpacings->{"CellMinHeight"->1},Selectable->False]}, 
                       WindowSize -> FitAll, 
                       WindowMargins -> {{Automatic, 100}, {Automatic, Automatic}}, 
                       WindowFrame -> "Palette", 
                       WindowElements -> {}, 
                       WindowFrameElements -> {}, 
                       ShowCellBracket -> False, 
                       ClosingAutoSave -> False, 
                       WindowTitle -> "Custom URL Link", 
                       Saveable -> False,
                       ShowStringCharacters -> False]];
                   SelectionMove[dnb, Before, Notebook]; 
                   SelectionMove[dnb, Next, Cell, 2]; 
                   SelectionMove[dnb, After, CellContents]; 
                   FrontEndTokenExecute[dnb, "Tab"], 
 
        Which[MatchQ[re, _String | StyleBox[__] | {(StyleBox[__] | _String)..} | Cell[_String, __]] && pacletInteractive === True,
              str = Switch[re, _String, re, StyleBox[__] | Cell[_String, __], re[[1]], {(StyleBox[__] | _String) ..}, 
                           StringJoin @@ (If[MatchQ[#, StyleBox[__]], #[[1]], #] & /@ re)];
              Throw[SetPacletInteractive[linkstyle, str]],
              (MatchQ[re, BoxData[_]] && Not@MatchQ[re2, BoxData[_]]) && pacletInteractive === True,
              Throw[If[StringQ[re2], 
                       SetPacletInteractive[linkstyle, re2], 
                       SetPacletInteractive[linkstyle]]]];
           
        Which[MatchQ[re, _String | StyleBox[__] | {(StyleBox[__] | _String)..} | Cell[_String, __]] && pacletInteractive === Automatic,
              str = Switch[re, _String, re, StyleBox[__] | Cell[_String, __], re[[1]], {(StyleBox[__] | _String) ..}, 
                           StringJoin @@ (If[MatchQ[#, StyleBox[__]], #[[1]], #] & /@ re)];
              Throw[pac = ReplaceAmpersand@ReduceToPacletPath[$PacletURI <> If[StringMatchQ[$PacletURI, "*/" | (" "..) | ""], "", "/"] <> linkstyle <> If[linkstyle =!= "", "/", ""]  <> RemoveWhiteSpaceAndCapitalize@RemoveOutsideQuotes@str];
                    Which[MatchQ[re, Cell[__]], 
                          writeLinkpac3[nb, re[[1]], pac, Take[re, {2, -1}]],
                          MatchQ[re, _String],
                          writeLinkpac3[nb, re, pac];
                          restoreDefault[nb],
                          MatchQ[re, {(StyleBox[__] | _String)..}],
                          writeComboLinkpac3[nb, re, pac];
                          restoreDefault[nb],
                          True,
                          writeStyledLinkpac3[nb, re, pac];
                          restoreDefault[nb]]],
              (MatchQ[re, BoxData[_]] && Not@MatchQ[re2, BoxData[_]]) && pacletInteractive === Automatic,
              Throw[pac = ReplaceAmpersand@ReduceToPacletPath[$PacletURI <> If[StringMatchQ[$PacletURI, "*/" | (" "..) | ""], "", "/"] <> linkstyle <> If[linkstyle =!= "", "/", ""]  <> If[StringQ@re2, RemoveWhiteSpaceAndCapitalize@RemoveOutsideQuotes@re2, ""]];
                    writeLinkpac3InsideBoxData[nb, re2, pac];
                restoreDefault[nb]]];
           
        docpath = If[StringMatchQ[$DocumentationDirectory, "*" <> $PathnameSeparator], 
                                  $DocumentationDirectory, 
                                  $DocumentationDirectory <> $PathnameSeparator];
        
        If[(MatchQ[re, _String | StyleBox[__] | {(StyleBox[__] | _String)..} | Cell[_String, __]] || 
            (MatchQ[re, BoxData[_]] && Not@MatchQ[re2, BoxData[_]])) && targetPreset,
           Throw[If[StringMatchQ[$TargetDocumentDir, ""|" "..],
                    Throw[MessageToConsole[CustomLink::documentdirnotset]]];
           
                 filepath = OpenBrowse[$DocumentationDirectory <> StringReplace[$TargetDocumentDir, "/" -> $PathnameSeparator]];
           
                 If[Not@StringQ[filepath]||StringLength[filepath]===0,
                    Throw[Null]];
              
                 If[Not[StringMatchQ[filepath,"*.nb"]],
                    Throw[If[cachedDirectory,
                             DocumentationTools`$DefaultFileBrowserPath=DirectoryName[filepath]];
                             MessageToConsole[CustomLink::nonbsel]]];
                 If[cachedDirectory,
                    DocumentationTools`$DefaultFileBrowserPath=DirectoryName[filepath]];
                    
                 If[Not@StringMatchQ[GenericizePath@filepath, "*" <> $TargetDocumentDir <> "*"],
                    Throw[MessageToConsole[CustomLink::targetdocdir, $TargetDocumentDir]]];
                    
                 targetpathfragment = StringReplace[StringReplace[$TargetDocumentDir, 
                                                                  $PathnameSeparator -> "/"], 
                                                    {LongestMatch["/" ~~ a__ ~~ "/"] :> a, 
                                                     LongestMatch[a__ ~~ "/"] :> a, 
                                                     LongestMatch["/" ~~ a__] :> a}];
                 
                 Which[MatchQ[re, _String],
                       writeLinkpacDocPath[nb, re, targetpathfragment, filepath, linkstyle];
                       restoreDefault[nb],
                       (MatchQ[re, BoxData[_]] && Not@MatchQ[re2, BoxData[_]]),
                       writeLinkpacDocPathBoxData[nb, re2, targetpathfragment, filepath, linkstyle];
                       restoreDefault[nb],
                       MatchQ[re, Cell[_String, __]],
                       cellStyleAndOpts=Take[re,{2,-1}];
                       writeLinkpacDocPath[nb, re[[1]], targetpathfragment, filepath, linkstyle, cellStyleAndOpts],
                       MatchQ[re, {(StyleBox[__] | _String)..}],
                       writeComboLinkpacDocPath[nb, re, targetpathfragment, filepath, linkstyle],
                       True,
                       writeStyledLinkpacDocPath[nb, re, targetpathfragment, filepath, linkstyle];
                       restoreDefault[nb]]]];
           
        If[(MatchQ[re, _String | StyleBox[__] | {(StyleBox[__] | _String)..} | Cell[_String, __]] || 
            (MatchQ[re, BoxData[_]] && Not@MatchQ[re2, BoxData[_]])) && Not@interactive,

           Which[MatchQ[re, _String],
                  Which[linkstyle === "MathWorldLink",
                        writeQueryURLLink[nb, re, $MathWorldDirectory],
                        linkstyle === "FunctionsSiteLink",
                        writeQueryURLLink[nb, re, $FunctionsSiteDirectory],
                        linkstyle === "NKSLink",
                        writeQueryURLLink[nb, re, $NKSDirectory],
                        True,
                        If[application === None,
                           writeLinkpac2[nb, re, linkstyle],
                           If[If[linkstyle === "ref", 
                                 StringMatchQ[DocumentationTools`$ApplicationName, "" | Whitespace] || StringMatchQ[DocumentationTools`$LinkBase, "" | Whitespace], 
                                 StringMatchQ[DocumentationTools`$LinkBase, "" | Whitespace]], 
                              Throw[CustomLink["ConfigureApply", linkstyle]],
                              writeLinkpac2app[nb, re, linkstyle, DocumentationTools`$LinkBase]]]];
                  restoreDefault[nb],
                 MatchQ[re, BoxData[_]] && Not@MatchQ[re2, BoxData[_]],
                  Which[linkstyle === "MathWorldLink",
                writeQueryURLLinkBoxData[nb, re2, $MathWorldDirectory],
                linkstyle === "FunctionsSiteLink",
                writeQueryURLLinkBoxData[nb, re2, $FunctionsSiteDirectory],
                linkstyle === "NKSLink",
                writeQueryURLLinkBoxData[nb, re2, $NKSDirectory],
                True,
                If[application === None,
                   writeLinkpac2BoxData[nb, re2, linkstyle],
                   If[If[linkstyle === "ref", 
                         StringMatchQ[DocumentationTools`$ApplicationName, "" | Whitespace] || StringMatchQ[DocumentationTools`$LinkBase, "" | Whitespace], 
                         StringMatchQ[DocumentationTools`$LinkBase, "" | Whitespace]], 
                      Throw[CustomLink["ConfigureApply", linkstyle]],
                      writeLinkpac2BoxDataapp[nb, re2, linkstyle, DocumentationTools`$LinkBase]]]];
                  restoreDefault[nb],
                 MatchQ[re, Cell[_String, __]],
                  cellStyleAndOpts = Take[re, {2, -1}];
                  Which[linkstyle === "MathWorldLink",
                writeQueryURLLink[nb, re, $MathWorldDirectory, cellStyleAndOpts],
                linkstyle === "FunctionsSiteLink",
                writeQueryURLLink[nb, re, $FunctionsSiteDirectory, cellStyleAndOpts],
                linkstyle === "NKSLink",
                writeQueryURLLink[nb, re, $NKSDirectory, cellStyleAndOpts],
                        True,
                        If[application === None,
                           writeLinkpac2[nb, re[[1]], linkstyle, cellStyleAndOpts],
                           If[If[linkstyle === "ref", 
                                 StringMatchQ[DocumentationTools`$ApplicationName, "" | Whitespace] || StringMatchQ[DocumentationTools`$LinkBase, "" | Whitespace], 
                                 StringMatchQ[DocumentationTools`$LinkBase, "" | Whitespace]], 
                              Throw[CustomLink["ConfigureApply", linkstyle]],
                              writeLinkpac2[nb, re[[1]], linkstyle, DocumentationTools`$LinkBase, cellStyleAndOpts]]]],
                 MatchQ[re, {(StyleBox[__] | _String)..}],
                  Which[linkstyle === "MathWorldLink",
                        writeComboQueryURLLink[nb, re, $MathWorldDirectory],
                        linkstyle === "FunctionsSiteLink",
                        writeComboQueryURLLink[nb, re, $FunctionsSiteDirectory],
                        linkstyle === "NKSLink",
                        writeComboQueryURLLink[nb, re, $NKSDirectory],
                        True,
                        If[application === None,
                           writeComboLinkpac2[nb, re, linkstyle],
                           If[If[linkstyle === "ref", 
                                 StringMatchQ[DocumentationTools`$ApplicationName, "" | Whitespace] || StringMatchQ[DocumentationTools`$LinkBase, "" | Whitespace], 
                                 StringMatchQ[DocumentationTools`$LinkBase, "" | Whitespace]], 
                              Throw[CustomLink["ConfigureApply", linkstyle]],
                              writeComboLinkpac2app[nb, re, linkstyle, DocumentationTools`$LinkBase]]]];
                  restoreDefault[nb], 
                 True,
                  Which[linkstyle === "MathWorldLink",
                        writeStyledQueryURLLink[nb, re, $MathWorldDirectory],
                        linkstyle === "FunctionsSiteLink",
                        writeStyledQueryURLLink[nb, re, $FunctionsSiteDirectory],
                        linkstyle === "NKSLink",
                        writeStyledQueryURLLink[nb, re, $NKSDirectory],
                        True,
                        If[application === None,
                           writeStyledLinkpac2[nb, re, linkstyle],
                           If[If[linkstyle === "ref", 
                                 StringMatchQ[DocumentationTools`$ApplicationName, "" | Whitespace] || StringMatchQ[DocumentationTools`$LinkBase, "" | Whitespace], 
                                 StringMatchQ[DocumentationTools`$LinkBase, "" | Whitespace]], 
                              Throw[CustomLink["ConfigureApply", linkstyle]],
                              writeStyledLinkpac2app[nb, re, linkstyle, DocumentationTools`$LinkBase]]]];
                  restoreDefault[nb]]];
                       
        If[(MatchQ[re, _String | StyleBox[__] | {(StyleBox[__] | _String)..} | Cell[_String, __]] || 
            (MatchQ[re, BoxData[_]] && Not@MatchQ[re2, BoxData[_]])) && interactive,
            
           Quiet[Switch[linkstyle, 
                        "Guides", 
                        If[# =!= Null && # =!= $Canceled, filepath = #, Abort[]] &[SystemDialogInput["FileOpen", $GuideDirectory, 
                                                                                                     WindowTitle -> "Browse for guide link file"]], 
                        "HowTos", 
                        If[# =!= Null && # =!= $Canceled, filepath = #, Abort[]] &[SystemDialogInput["FileOpen", $HowToDirectory, 
                                                                                                     WindowTitle -> "Browse for how to link file"]], 
                        "Tutorials",
                        If[# =!= Null && # =!= $Canceled, filepath = #, Abort[]] &[SystemDialogInput["FileOpen", $TutorialDirectory, 
                                                                                                     WindowTitle -> "Browse for tutorial link file"]], 
                        "Symbols", 
                        If[# =!= Null && # =!= $Canceled, filepath = #, Abort[]] &[SystemDialogInput["FileOpen", $FunctionDirectory, 
                                                                                                     WindowTitle -> "Browse for reference page link file"]], 
                        _, 
                        filepath = If[linkstyle =!= "" && FileType[path = docpath <> linkstyle] === Directory, 
                                      OpenBrowse[path <> $PathnameSeparator], 
                                      OpenBrowse[docpath]]], 
                 FileType::"fstr"];
           
           If[Not@StringQ[filepath]||StringLength[filepath]===0,
              Throw[Null]];
                     
       If[Not[StringMatchQ[filepath,"*.nb"]],
          Throw[If[cachedDirectory,
                   DocumentationTools`$DefaultFileBrowserPath=DirectoryName[filepath]];
                MessageToConsole[CustomLink::nonbsel]]];
          If[cachedDirectory,
                 DocumentationTools`$DefaultFileBrowserPath=DirectoryName[filepath]];
           
           Off[FileType::"fstr"];
           Which[FileType[$DocumentationDirectory] === Directory && StringMatchQ[filepath, $DocumentationDirectory ~~ __],
             pac = ReplaceAmpersand@ReduceToPacletPath@GenericizePath@StringReplace[filepath, docpath ~~ a__ ~~ ".nb" :> a],
             FileType[$DocumentationDirectory] === Directory,
             Throw[MessageToConsole[CustomLink::notdoc, $DocumentationDirectory]],
                 StringMatchQ[filepath, ""|" "..],
                 Throw[MessageToConsole[CustomLink::pathsnotset]],
                 StringMatchQ[filepath, ___ ~~ $TargetDocumentDir ~~ ___],
                 patt = If[StringMatchQ[$TargetDocumentDir, "*"<>$PathnameSeparator], 
                           $TargetDocumentDir, 
                           $TargetDocumentDir <> $PathnameSeparator]; 
                 pac = ReplaceAmpersand@ReduceToPacletPath@GenericizePath@StringReplace[filepath, {___ ~~ patt -> "", ".nb" -> ""}]];
           On[FileType::"fstr"];
           
           If[linkstyle =!= "" && Not@StringMatchQ[GenericizePath@DirectoryName[filepath], __ ~~ linkstyle ~~ "/"~~___],  
                                                                                          (* Opening this up a bit as the flexibility is useful, 
                                                                                             particularly for link to package guide button. -- AK 6/22/06 *)
              Throw[MessageToConsole[CustomLink::filelocation, linkstyle]]];

           Which[MatchQ[re, _String],
           
                 writeLinkpac4[nb, re, pac];
                 restoreDefault[nb],
                 
                 (MatchQ[re, BoxData[_]] && Not@MatchQ[re2, BoxData[_]]),
                 
                 writeLinkpac4BoxData[nb, re2, pac];
                 restoreDefault[nb],
                 
                 MatchQ[re, Cell[_String, __]],
              
                 cellStyleAndOpts = Take[re, {2, -1}];
                 writeLinkpac4[nb, re[[1]], pac, cellStyleAndOpts],
                 
                 MatchQ[re, {(StyleBox[__] | _String)..}],
                 
                 writeComboLinkpac4[nb, re, pac];
                 restoreDefault[nb],
                 
                 True,
                 
                 writeStyledLinkpac4[nb, re, pac];
                 restoreDefault[nb]]]]]]
              
CustomLink[opts__] /; MatchQ[{opts}, {(_->_)..}] && MemberQ[{opts}, Target -> "URL"]:= CustomLink["Hyperlink", opts]
                 
CustomLink[opts__]/; MatchQ[{opts}, {(_->_)..}] && Not@MemberQ[{opts}, Target -> "URL"]:= CustomLink["", opts]


(******** Related Links Dialog ************************************************************************************)


$ButtonLabelTopic = "";
$SearchTopic = "";
$SymbolToAdd = "";
$SymbolList = {};
$ButtonList = {};
$RelatedLinksGuideWindowTitle = "";

DeleteFromList[symbol_] := 
 Module[{sym}, $SymbolList = 
   DeleteCases[$SymbolList, symbol]; 
   $ButtonList = (Button[Style[#, Blue], 
                         DeleteFromList[sym], Alignment -> Left, ImageSize -> Automatic, ButtonFrame -> "None"] /. sym -> #) & /@ $SymbolList]
                         
AddToList::empinput = "The input field is empty.";
AddToList::notsystemsym = "The input field contains a non-System symbol.";

AddToList[symbol_] := 
 Module[{sym}, 
  Which[StringMatchQ[$SymbolToAdd, "" | Whitespace], 
        MessageToConsole[AddToList::empinput], 
        Not@MemberQ[Names["System`*"], symbol], 
        MessageToConsole[AddToList::notsystemsym], 
        True, 
        $SymbolList = Union@Append[$SymbolList, symbol]; 
        $ButtonList = (Button[Style[#, Blue], 
                              DeleteFromList[sym], Alignment -> Left, ImageSize -> Automatic, ButtonFrame -> "None"] /. sym -> #) & /@ $SymbolList]]
                              
RelatedLinksOK::noinputnotebook = "There is no input notebook.";
RelatedLinksOK::noguidelinksec = "The input notebook does not contain a Related Links section.";
RelatedLinksOK::nolabel = "You must specify the topic for the link label.";
RelatedLinksOK::nosymbolslisted = "There are no symbols listed.";

RelatedLinksOK[] := 
 Module[{nb = NextNotebook[]}, 
  Which[nb === $Failed, 
        MessageToConsole[RelatedLinksOK::noinputnotebook], 
        NotebookFind[nb, "GuideRelatedLinksSection", All, CellStyle] === $Failed, 
        MessageToConsole[RelatedLinksOK::noguidelinksec],
        StringMatchQ[$ButtonLabelTopic, "" | Whitespace],
        MessageToConsole[RelatedLinksOK::nolabel],
        $SymbolList === {},
        MessageToConsole[RelatedLinksOK::nosymbolslisted],
        True,
        If[NotebookFind[nb, "GuideRelatedLinks", All, CellStyle] === $Failed, SelectionMove[nb, After, Cell]]; 
        NotebookWrite[nb, Cell[TextData[{ButtonBox["Demonstrations related to " <> $ButtonLabelTopic, BaseStyle -> "Hyperlink", 
         ButtonData -> {URL[If[StringMatchQ[$SearchTopic, "" | Whitespace], 
                              "http://demonstrations.wolfram.com/search.html?query=symbols%3A" <> StringJoin @@ Riffle[$SymbolList, "+OR+"], 
                              "http://demonstrations.wolfram.com/search.html?query=topics%3A" <> $SearchTopic <> " " <> "content%3A" <> StringJoin @@ Riffle[$SymbolList, "+OR+"]]], None}, 
         ButtonNote -> None], " (", ButtonBox["The Wolfram Demonstrations Project", BaseStyle -> "Hyperlink", 
                                              ButtonData -> {URL["http://demonstrations.wolfram.com/"], None}, 
                                              ButtonNote -> None], ")"}], "GuideRelatedLinks"], 
                      All]]]
                      
DemonstrationsSearchPath[SearchTopic_String, 
  SymbolList_?(VectorQ[#, StringQ] &)] := 
 If[StringMatchQ[SearchTopic, "" | Whitespace], 
    "http://demonstrations.wolfram.com/search.html?query=symbols%3A" <> StringJoin @@ Riffle[$SymbolList, "+OR+"], 
    "http://demonstrations.wolfram.com/search.html?query=topics%3A" <> SearchTopic <> " " <> "content%3A" <> StringJoin @@ Riffle[SymbolList, "+OR+"]]
                      
TestRelatedLinkData::emptysymlist = "There are no symbols listed.";

TestRelatedLinkData[] := 
 If[$SymbolList === {},
    MessageToConsole[TestRelatedLinkData::emptysymlist],
    FrontEndExecute[{NotebookLocate[{URL[DemonstrationsSearchPath[$SearchTopic, $SymbolList]], None}]}]]

ScrollingPanelForRelatedLinks[expr_, {w_, h_}, opts___] := 
  DynamicModule[{x = -1, y = 1}, 
   Grid[{{Tooltip[Panel[expr, ImageSize -> {w, h}, Alignment -> Dynamic[{x, y}], opts], "Click on any listed name to remove it."], 
          VerticalSlider[Dynamic[y], {-1, 1}, ImageSize -> {Small, h}]}}]]
          
RelatedLinksDialog[] := 
 Notebook[{Cell["", FontSize -> 1, CellElementSpacings -> {"CellMinHeight" -> 1}, Selectable -> False], 
   Cell[BoxData[ToBoxes@Style[Grid[{{"Notebook", Dynamic[$RelatedLinksGuideWindowTitle], ""}, 
                                    {"Search Topic", InputField[Dynamic[$SearchTopic], String, FieldSize -> {If[$SystemID === "Windows",
                                                                                                                33.5,
                                                                                                                43.5], {1, Infinity}}], 
                                     Tooltip[Button["Topics", 
                                     FrontEndExecute[{NotebookLocate[{URL["https://demonstrations.internal.wolfram.com/admin/setcategories.jsp"], None}]}], Method -> "Queued"], 
                                             "Enter a topic from the web page that opens or leave blank."]},
                                    {"Label Topic", InputField[Dynamic[$ButtonLabelTopic], String, FieldSize -> {If[$SystemID === "Windows",
                                                                                                                    33.5,
                                                                                                                    43.5], {1, Infinity}}], ""},
                                    {"Symbol To Add", InputField[Dynamic[$SymbolToAdd], String, FieldSize -> {If[$SystemID === "Windows",
                                                                                                                33.5,
                                                                                                                43.5], {1, Infinity}}], ""}, 
                                    {"", OldRow[{Tooltip[Button["Add To List", AddToList[$SymbolToAdd], Method -> "Queued", 
                                                                                                        ImageSize -> {If[$SystemID === "Windows",
                                                                                                                         85,
                                                                                                                         100], 22}], 
                                                         "Type a symbol in the input field and click this button to add a symbol to the list below to be inserted into the related link."], 
                                                 Tooltip[Button["OK", RelatedLinksOK[], Method -> "Queued", ImageSize -> {If[$SystemID === "Windows",
                                                                                                                             35,
                                                                                                                             45], 22}], 
                                                         "Update the link on the guide page"], 
                                                 Tooltip[Button["Test", TestRelatedLinkData[], ImageSize -> {If[$SystemID === "Windows",
                                                                                                                45,
                                                                                                                50], 22}], "Test search data."], 
                                                 Tooltip[Button["Refresh", RelatedLinksDialogOpen[JustUpdateSymbols -> True], 
                                                                Method -> "Queued", 
                                                                ImageSize -> {If[$SystemID === "Windows",
                                                                                 60,
                                                                                 70], 22}], 
                                                         "Display the list corresponding to another guide\npage. It must be the top input notebook."], 
                                                 Button["Cancel", NotebookClose[EvaluationNotebook[]], 
                                                        ImageSize -> {If[$SystemID === "Windows",
                                                                         55,
                                                                         62], 22}]}, RowAlignments -> Center], 
                                     ""}, 
                                    {"", ScrollingPanelForRelatedLinks[Dynamic@Column[$ButtonList], {If[$SystemID === "Windows",
                                                                                                        288,
                                                                                                        410], 300}], ""}, 
                                    {"", "Click on a listed name to remove it from the list.", ""}}, 
                                   Alignment -> {{Right, Left}, {Top}}], 
        FontFamily -> "Verdana", FontSize -> 11]]], 
           Cell["", FontSize -> 1, CellElementSpacings -> {"CellMinHeight" -> 1}, Selectable -> False]}, 
          WindowMargins -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
          WindowFrame -> "Palette", 
          WindowElements -> {}, 
          WindowFrameElements -> {}, 
          ShowCellBracket -> False, 
          ClosingAutoSave -> False, 
          WindowTitle -> "Modify Or Insert Related Links Button", 
          Saveable -> False, 
          ShowStringCharacters -> False, 
          Selectable -> False, 
          WindowSize -> {If[$SystemID === "Windows", 470, 620], FitAll}]
          
RelatedLinksDialogOpen::noinputnotebook = "There is no input notebook.";
RelatedLinksDialogOpen::nowindowtitle = "The input notebook does not have a window title.";
RelatedLinksDialogOpen::noguidelinksec = "The input notebook does not contain a Related Link.";
RelatedLinksDialogOpen::notguidelinkcellstruc = "The Related Link does not have the correct structure.";

Options[RelatedLinksDialogOpen] = {JustUpdateSymbols -> False}

RelatedLinksDialogOpen[opts___] := 
 Module[{nb = NextNotebook[], justupdate, wt, NoLink, re, r4, r7, sym},
  justupdate = JustUpdateSymbols /. {opts} /. Options[RelatedLinksDialogOpen];
  Catch[Which[nb === $Failed, 
        MessageToConsole[RelatedLinksDialogOpen::noinputnotebook], 
        (wt = WindowTitle /. AbsoluteOptions[nb, WindowTitle]; Not@StringQ@wt), 
        MessageToConsole[RelatedLinksDialogOpen::nowindowtitle], 
        NotebookFind[nb, "GuideRelatedLinksSection", All, CellStyle] === $Failed, 
        MessageToConsole[RelatedLinksDialogOpen::noguidelinksec],
        True,
        If[NotebookFind[nb, "GuideRelatedLinks", All, CellStyle] =!= $Failed, 
           NoLink = False;
           If[(re = NotebookRead[nb];
               Not[MatchQ[re, Cell[TextData[{ButtonBox[_String, BaseStyle -> "Hyperlink", ButtonData -> {URL[_String], None}, ButtonNote -> None], 
                                            " (" | PatternSequence[" ", "("], 
                                            ButtonBox["The Wolfram Demonstrations Project", BaseStyle -> "Hyperlink", 
                                                      ButtonData -> {URL["http://demonstrations.wolfram.com/"], None}, ButtonNote -> None], ")"}], 
                                  "GuideRelatedLinks", ___]] && (r4 = re[[1, 1, 1, 1]];
                 StringMatchQ[r4, "Demonstrations related to " ~~ __]) && (r7 = re[[1, 1, 1, 3, 2, 1, 1]];
                  StringMatchQ[r7, Alternatives["http://demonstrations.wolfram.com/search.html?query=topics%3A" ~~ __ ~~ "content%3A" ~~ __, 
                                                "http://demonstrations.wolfram.com/search.html?query=symbols%3A" ~~ __]])]), 
              Throw[MessageToConsole[RelatedLinksDialogOpen::notguidelinkcellstruc]]],
              NoLink = True]; 
        $RelatedLinksGuideWindowTitle = wt; 
        $SearchTopic = If[Not@NoLink,
                        If[StringMatchQ[r7, "http://demonstrations.wolfram.com/search.html?query=topics%3A" ~~ __ ~~ "content%3A" ~~ __], 
                          StringReplace[r7, 
                            "http://demonstrations.wolfram.com/search.html?query=topics%3A" ~~ a__ ~~ "content%3A" ~~ __ :> StringReplace[a, "+" -> " "]],
                          ""], ""]; 
        $ButtonLabelTopic = If[Not@NoLink,
                               StringReplace[re[[1, 1, 1, 1]], "Demonstrations related to " -> ""],
                               ""];
        $SymbolList = If[Not@NoLink,
                         StringSplit[StringSplit[r7, "%3A"][[-1]], "+OR+"],
                         {}];
        $ButtonList = If[Not@NoLink,
                         (Button[Style[#, Blue], 
                              DeleteFromList[sym], Alignment -> Left, ImageSize -> Automatic, ButtonFrame -> "None"] /. sym -> #) & /@ $SymbolList,
                         {}];
        $SymbolToAdd = "";
        If[Not@justupdate, NotebookPut[RelatedLinksDialog[]]]]]]
        

(******** End Code for Related Links Dialog ************************************************************************************)


CloseNotebook[dialogname_String] := 
($closeNB = 
   NotebookPut[
    Notebook[{Cell[BoxData[RowBox[{"NotebookClose", "[", dialogname, "]"}]], "Input"], 
      Cell[BoxData[RowBox[{"Clear", "[", dialogname, "]"}]], "Input"], 
      Cell[BoxData[RowBox[{"NotebookClose", "[", RowBox[{"EvaluationNotebook", "[", "]"}], "]"}]], "Input"]}, 
             Visible -> False]];
 FrontEndExecute[{FrontEndToken[$closeNB, "EvaluateNotebook"]}])
 
$packagecontext = "";
$contextnotebook = None;

PackageSettingApply::noin = "There is no input notebook.";
PackageSettingApply::nocontcell = "There is no context cell in the input notebook.";
PackageSettingApply::contcellempt = "The context cell in the input notebook is empty.";
PackageSettingApply::contcellstruc = "The context cell in the input notebook has inappropriate structure.";
PackageSettingApply::contstruc = "What is specified in the context cell is not a context.";
PackageSettingApply::conflict = "There is a conflict between the context as indicated by the input notebook's Categorization Context cell and the context in the input notebook's tagging rules. The tagging rule is being overwritten by the content of the Context cell. The Context dialog displays the content of the Context cell.";

Options[PackageSettingApply] = {"Interactive" -> False};

(* The code may later be extended to work with more than one package. *)

PackageSettingApply[opts___] :=
  Module[{nb, interactive, gt, cs, package}, 
         nb = InputNotebook[];
   Catch[If[(*There is no input notebook.*) nb === $Failed,
            Throw[MessageToConsole[PackageSettingApply::noin]]];
            
         interactive = "Interactive" /. {opts} /. Options[PackageSettingApply];
         gt = NotebookGet[nb];
         cs = Cases[gt, Cell[context_, "Categorization", ___, CellLabel -> "Context", ___] :> context, Infinity];
         package = getTaggingRulesOption[nb, "NeededPackages"];
         
         If[Not@interactive,
         
            If[cs === {}, Throw[MessageToConsole[PackageSettingApply::nocontcell]]];
            If[cs === {""}, Throw[MessageToConsole[PackageSettingApply::contcellempt]]];
            If[Not@StringQ[cs[[1]]], Throw[MessageToConsole[PackageSettingApply::contcellstruc]]];
            If[StringMatchQ[cs[[1]], (" " ... ~~ "`")] || (Not@StringMatchQ[cs[[1]], " "... | ""] && 
                                                                                                StringFreeQ[cs[[1]], "`"]), 
               Throw[MessageToConsole[PackageSettingApply::contstruc]]];
            setTaggingRulesOption[nb, "NeededPackages" -> {cs[[1]]}],
            
            If[cs === {}, Throw[MessageToConsole[PackageSettingApply::nocontcell]]]; 
            If[Not@StringQ[cs[[1]]], Throw[MessageToConsole[PackageSettingApply::contcellstruc]]]; 
            If[StringMatchQ[cs[[1]], (" " ... ~~ "`")] || (Not@StringMatchQ[cs[[1]], " "... | ""] && 
                                                                                                StringFreeQ[cs[[1]], "`"]), 
               Throw[MessageToConsole[PackageSettingApply::contstruc]]]; 
            If[(package =!= None) && (cs =!= package && Not[StringMatchQ[cs[[1]]," "...|""]]), MessageToConsole[PackageSettingApply::conflict]]; 
            $packagecontext = Which[(* There is no tagging rule setting and the Context cell contains a context. *)
                                    package === None && StringMatchQ[cs[[1]], __ ~~ "`"], 
                                    setTaggingRulesOption[nb, "NeededPackages"->cs];
                                    cs[[1]], 
                                    package === None, 
                                    "",
                                    (package =!= None) && (cs =!= package && Not[StringMatchQ[cs[[1]]," "...|""]]),
                                    setTaggingRulesOption[nb, "NeededPackages"->cs];
                                    cs[[1]],
                                    True, 
                                    package[[1]]]; 
            $contextnotebook = nb; 
            GenerateContextInsertionDialog[]]]]
            
GenerateContextInsertionDialog[] := 
 Module[{nb},
 $frontend = $FrontEnd; 
  $contextdialog = 
   nb = NotebookPut[
    Notebook[{Cell["",FontSize->1,CellElementSpacings->{"CellMinHeight"->1},Selectable->False],
      Cell[
       BoxData[ToBoxes@Style[Grid[{{Style["Context to insert:", Bold, Editable -> False, Selectable -> False], 
                                    InputField[Dynamic[$packagecontext], String, 
                                               FieldSize -> {58, {1, Infinity}}]},
                                   {Style["", Editable -> False, Selectable -> False],
                       Dynamic[OldRow[{Button[Style["OK", Bold], InsertContextFromDialog[]; 
                                                                 NotebookClose[ButtonNotebook[]], Method -> "Queued"], 
                                    Button[Style["Cancel", Bold], Clear[$contextdialog]; NotebookClose[ButtonNotebook[]], 
                                           Method -> "Queued"]}]]}}, ColumnAlignments -> Left], 
               FontSize -> 12, 
               FontFamily -> "Helvetica"]]],
              Cell["",FontSize->1,CellElementSpacings->{"CellMinHeight"->1},Selectable->False]}, 
             WindowSize -> FitAll, 
             WindowMargins -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
             WindowFrame -> "Palette", 
             WindowElements -> {}, 
             WindowFrameElements -> {}, 
             ShowCellBracket -> False, 
             ClosingAutoSave -> False, 
             WindowTitle -> "Context", 
             Saveable -> False,
             ShowStringCharacters -> False]];
   SelectionMove[nb, Before, Notebook];
   SelectionMove[nb, Next, Cell, 2];
   SelectionMove[nb, After, CellContents];
   FrontEndTokenExecute[nb, "Tab"]]
             
PackageSettingApply::pacnotebookclosed = "The working notebook was closed.";
PackageSettingApply::notcont = "Enter a context in the input field. The string must end with a backtick (`).";

InsertContextFromDialog[] :=
 Module[{gt},
 Catch[If[Not@MemberQ[Notebooks[] /. FrontEndObject[_] -> $frontend, $contextnotebook], 
          Throw[MessageToConsole[PackageSettingApply::pacnotebookclosed]; 
                CloseNotebook["$contextdialog"]; Clear[$contextdialog]]];
       If[StringMatchQ[$packagecontext, (" " ... ~~ "`") | " " .. | ""] || Not@StringMatchQ[$packagecontext, __ ~~ "`"], 
          Throw[MessageToConsole[PackageSettingApply::notcont]; Abort[]]];
       setTaggingRulesOption[$contextnotebook, "NeededPackages" -> {$packagecontext}];
       gt = NotebookGet[$contextnotebook]; 
       If[Not@MatchQ[Cases[gt, Cell[_, "Categorization", CellLabel -> "Context", ___], Infinity][[1]], 
                     Cell[$packagecontext, __]],
          NotebookFind[$contextnotebook, "Context", All, CellLabel];
          NotebookWrite[$contextnotebook, 
                        NotebookRead[$contextnotebook] /. 
                         Cell[a_, b__] :> Cell[$packagecontext, b], All]]
       ]]


(* StyleApply needs to handle various selection conditions, kind of like CellWriteStyle, but nowhere near
   as extensive right now. When selection contains text, apply style box. When selection is between characters, 
   initiate style box with XXXX content. When selection is on cell bracket, apply cell style. When selection 
   is between cells, initiate new cell with XXXX content: *)
   
(* On OS X, InputNotebook[] does not refocus after clicking the palette, which is surely a bug. We can work
   around it by adding SetSelectedNotebook[] after each every function in this package that writes or modifies
   the InputNotebook[]. However, since this is probably a temporary problem, I think we should rather set
   that in the palette, where we can strip out again much easier than doing so here. -- AK 4/5/05  *)

StyleApply[ sty_String]:= Module[{ nb = InputNotebook[], info, sel},
    info = CellInfo[nb]; 
    sel = OldNotebookRead[nb];
    Which[
      info === $Failed,
        NotebookWrite[ nb, Cell["XXXX", sty], All];
        SelectionMove[nb, All, CellContents],
      info =!= $Failed && sel === {},
        NotebookWrite[ nb, TextData[ StyleBox[ "XXXX", sty]], All],
      info =!= $Failed && sel =!= {},
        FrontEndExecute[{ FrontEnd`FrontEndToken[ nb, "Style", sty]}]
      ]]

StyleApply[ "ExampleSection"]:= Module[{ nb = InputNotebook[], info, sel},
    info = CellInfo[nb]; 
    sel = OldNotebookRead[nb];
    If[ info === $Failed,
       (NotebookWrite[ nb, 
          Cell[ BoxData[
            InterpretationBox[Cell["XXXX", "ExampleSection"], ($Line = 0; Null)]], "ExampleSection"], All];
            SelectionMove[ nb, Before, CellContents];
        FrontEndExecute[{
          FrontEnd`FrontEndToken[nb, "MoveNext"], 
          FrontEnd`FrontEndToken[nb, "MoveNext"],
          FrontEnd`FrontEndToken[nb, "SelectNextWord"]}])]
      ]

StyleApply[ "ExampleSubsection"]:= Module[{ nb = InputNotebook[], info, sel},
    info = CellInfo[nb]; 
    sel = OldNotebookRead[nb];
    If[ info === $Failed,
       (NotebookWrite[ nb, 
          Cell[ BoxData[
            InterpretationBox[Cell["XXXX", "ExampleSubsection"], ($Line = 0; Null)]], "ExampleSubsection"], All];
        SelectionMove[ nb, Before, CellContents];
        FrontEndExecute[{
          FrontEnd`FrontEndToken[nb, "MoveNext"], 
          FrontEnd`FrontEndToken[nb, "MoveNext"],
          FrontEnd`FrontEndToken[nb, "SelectNextWord"]}])]
      ]

StyleApply[ "ExampleSubsubsection"]:= Module[{ nb = InputNotebook[], info, sel},
    info = CellInfo[nb]; 
    sel = OldNotebookRead[nb];
    If[ info === $Failed,
       (NotebookWrite[ nb, 
          Cell[ BoxData[
            InterpretationBox[Cell["XXXX", "ExampleSubsubsection"], ($Line = 0; Null)]], "ExampleSubsubsection"], All];
        SelectionMove[ nb, Before, CellContents];
        FrontEndExecute[{
          FrontEnd`FrontEndToken[nb, "MoveNext"], 
          FrontEnd`FrontEndToken[nb, "MoveNext"],
          FrontEnd`FrontEndToken[nb, "SelectNextWord"]}])]
      ]

StyleApply[ "GuidePlainText"] := Module[{nb = InputNotebook[]},
        NotebookWrite[ nb, 
          ReplaceAll[ OldNotebookRead[ nb], {
            ButtonBox[ cont_, ___] -> TextData[ StyleBox[ cont, "GuideText"]], 
            cont_ -> TextData[ StyleBox[ cont, "GuideText"]]
          }]]
        ]
        
(* Tempory alias for StyleApply[] in order to force FE not to mislabel the context when
   called from the custom menu expression:  *)
(* Apparently no longer needed with recent splitting of package and related loading reconfiguration: *)
    
StyleApplyHack[ styl_String] := StyleApply[ styl]



StyleAppend[styl_String] := StyleAppend[styl, InputNotebook[]];

StyleAppend[styl_String, nb_NotebookObject] :=
  Module[
    {
      info, selSty, cellSel, sel, tableSel, cInf, objSel, buttonSty,
      otherstyl, newdata
    },
    If[nb === $Failed, Abort[]];
    info = CellInfo[nb];
    If[info === $Failed,
      Abort[],
      selSty = Flatten["Style" /. info]
    ];
    tableSel = False;
    objSel = False;
    cellSel = False;
    Which[
      MemberQ[("CursorPosition" /. info), "CellBracket"],
        cellSel = True,
      MemberQ[selSty, s_String /; StringMatchQ[s, "*Table*"]],
        (
          If[FreeQ[NotebookRead[nb], "ModInfo"],
            While[!MemberQ[Flatten["Style" /. CellInfo[nb]], "ModInfo"],
              FrontEndTokenExecute[nb, "MovePrevious"]
            ]
          ];
          While[MemberQ[Flatten["Style" /. CellInfo[nb]], "ModInfo"],
            FrontEndTokenExecute[nb, "ExpandSelection"]
          ];
          tableSel = True
        ),
      MemberQ[selSty, "ModInfo"],
        (
          While[MemberQ[Flatten["Style" /. CellInfo[nb]], "ModInfo"],
            FrontEndTokenExecute[nb, "ExpandSelection"]
          ];
          tableSel = True
        ),
      MemberQ[selSty,
          "InlineGuideFunction" | "GuideText" |
          "InlineGuideFunctionListing" | "InlineFormula" | "InlineCode"],
        (
          FrontEndTokenExecute[nb, "MoveNext"];
          If[CellInfo[nb] === $Failed,
            FrontEndTokenExecute[nb, "MovePrevious"]
          ];
          While[
            FreeQ[
              If[# =!= $Failed, "Style" /. #, #]& (cInf = CellInfo[ nb]),
              "InlineFormula" | "InlineCode" | "InlineGuideFunction"
            ],
            If[cInf =!= $Failed,
              FrontEndTokenExecute[ nb, "MovePrevious"], Abort[]
            ]
          ];
          If[cInf =!= $Failed,
            FrontEndTokenExecute[nb, "ExpandSelection"];
            objSel = True
          ];
          If[cInf =!= $Failed && FreeQ[OldNotebookRead[nb], ButtonBox],
            FrontEndTokenExecute[nb, "ExpandSelection"];
            objSel = True
          ]
        ),
      MatchQ[styl, "ExcludedObject" | "TOCExcludedObject" | "PrimaryObject"],
        (* If using "ExcludedObject" et al tagging button and selection
          test gets this far, selection is wrong. *)
        Abort[],
      !MemberQ[("CursorPosition" /. info), "CellBracket"],
        SelectionMove[nb, All, Cell];
        cellSel = True
    ];
    sel = OldNotebookRead[nb];
    Which[
      FreeQ[sel, styl],
        Which[
          tableSel && StringMatchQ[styl, "TentativeExample" | "FutureExample"],
            (
              SetOptions[NotebookSelection[nb],
                Editable -> True, Deletable -> True];
              NotebookWrite[nb,
                BoxData[TooltipBox[
                  Cell[$UserName, "ModInfo", styl,
                    CellDingbat -> Cell[$UserName <> "      ", "TentativeID"]
                  ],
                  "Tentative"
                ]],
                All
              ];
              Do[FrontEndTokenExecute[nb, "MoveNext"], {2}];
            ),
          objSel && MemberQ[{"ExcludedObject", "TOCExcludedObject",
              "PrimaryObject"}, styl],
            If[FreeQ[sel, ButtonBox],
              SetOptions[NotebookSelection[nb], styl],
              (
                buttonSty = (BaseStyle /.
                  (ButtonBoxOptions /. Options[NotebookSelection[nb]]));
                SetOptions[NotebookSelection[nb],
                  ButtonBoxOptions ->
                    {BaseStyle -> {First @ Flatten @ {buttonSty}, styl}}
                ]
              )
            ],
          StringMatchQ[styl, "TentativeExample" | "FutureExample"],
            (
              otherstyl =
                First @ Complement[
                    {"FutureExample", "TentativeExample"},
                    {styl}
                  ];
              (* If the other style is present (e.g., you're trying to
                apply FutureExample to a TentativeExample), clear it out
                first. *)
              If[!FreeQ[sel, otherstyl], StyleAppend[otherstyl, nb]];
              SetOptions[NotebookSelection[nb],
                CellDingbat -> Cell[$UserName <> "      ", "TentativeID"]
              ];
              SetOptions[NotebookSelection[nb], styl]
            ),
          True,
            SetOptions[NotebookSelection[nb], styl]
        ],
      !FreeQ[sel, styl],
        If[tableSel
          ,
          FrontEndTokenExecute[nb, "ExpandSelection"];
	  SetOptions[NotebookSelection[nb],
	             Editable -> True, Deletable -> True];
	  NotebookWrite[nb, BoxData[Cell["      ", "ModInfo"]], All];
        (*  NotebookWrite[nb,
	              BoxData[TooltipBox[Cell[" ", "ModInfo"], " "]],
	              All
	            ]; *)
	(* Do[FrontEndTokenExecute[nb, "MoveNext"], {2}]; *)
	  FrontEndTokenExecute[nb, "MoveNext"];
	(* SetOptions[NotebookSelection[nb],
            Editable -> Inherited, Deletable -> Inherited] *)
          ,
          newdata =
            DeleteCases[
              DeleteCases[NotebookRead[nb], styl, Infinity],
              CellDingbat -> Cell[_, "TentativeID"], Infinity
            ] /. {
              (BaseStyle -> {sty_}) :> (BaseStyle -> sty),
              Cell[cont_, sty1_, sty2__?(!OptionQ), opts1___] :>
                Cell[cont, sty1, opts1]
            };
          newdata =
            Flatten[{newdata //.
              Cell[CellGroupData[cont_, _]] :> cont
            }];
          If[Length[newdata] == 1
            ,
            NotebookWrite[nb, #, All]
            ,
            Module[{id, seek},
              Catch[
                id = Cases[#, (CellID -> x_) :> x, Infinity];
                If[Length[id] > 0, id = First[id],
                  Throw[MessageToConsole[StyleAppend::nocellid, #]]];
                seek = NotebookFind[nb, id, All, CellID];
                If[seek =!= $Failed, NotebookWrite[nb, #, All]]
              ]
            ]
          ]& /@ newdata;
        ]
    ]
  ];
  
  
CellStyleToSearchFor[nb_]:=
 Module[{StyleDefsStylePairs = {{"FunctionPageStyles.nb", "ObjectName"}, {"GuidePageStyles.nb", "GuideTitle"}, {"TutorialPageStyles.nb", "Title"},
         {"FormatPageStyles.nb", "ObjectNameAlt"}, {"HowToPageStyles.nb", "Title"}, {"MigrationPageStyles.nb", "ObjectName"},
         {"CharacterPageStyles.nb", "CharacterImage"}, {"UpgradePageStyles.nb", "UpgradeObjectName"}, {"MarketingPageStyles.nb", "MarketingTitle"},
         {"ComparisonPageStyles.nb", "ComparisonTitle"}, {"CapabilitiesPageStyles.nb", "CapabilitiesTitle"}, {"SolutionsPageStyles.nb", "SolutionsTitle"}},
         stylesheet},
        stylesheet = If[# === {}, {}, #[[1]]] &[Options[nb, StyleDefinitions] /. (StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, a_, __]) :> a];
        If[stylesheet === {} || # === {}, {}, #[[1]]]&@Cases[StyleDefsStylePairs, {stylesheet, a_} :> a]]

StatusSet::cellnf = "A style for a cell to label with the user's name could not be found."

StatusSet["TentativeObject"] := 
 Module[{nb = NextNotebook[], style},
        SelectionMove[nb, Before, Notebook]; 
        SelectionMove[nb, Next, Cell];
        If[MatchQ[OldNotebookRead[nb], 
                  Cell[_, 
                       Alternatives["InternalFlag", "FutureFlag", "ExcisedFlag", "TemporaryFlag", "ObsoleteFlag", "SubjectToChangeFlag",
                                    "AwaitingFutureDesignReviewFlag", "PreviewFlag"], ___]], 
           SetOptions[NotebookSelection[nb], Editable -> True, Deletable -> True]; 
           NotebookDelete[nb]];
        SetOptions[nb, ScreenStyleEnvironment -> "Preview"];
        SetOptions[nb, ScreenStyleEnvironment -> "TentativeObject"];
        style = CellStyleToSearchFor[nb];
        If[style === {},
           MessageToConsole[StatusSet::cellnf],
           NotebookFind[nb, style, All, CellStyle]; 
           SetOptions[NotebookSelection[nb], CellLabel -> $UserName]]]
        
TentativeProceed::nbnotop = "The notebook being worked on is no longer open.";
TentativeProceed::nbchg = "The notebook has not been saved.";

TentativeProceed[nb_] := 
 Module[{nbi, GenerateProgressIndicator, pnb, gt}, 
  If[Not@MemberQ[Notebooks[], nb], 
     MessageToConsole[TentativeProceed::nbnotop], 
     If[(nbi = NotebookInformation[nb]; (("FileName" /. nbi) === "FileName") || ("ModifiedInMemory" /. nbi)), 
        MessageToConsole[TentativeProceed::nbchg],
        NotebookClose[];
        If[(* File size > 2 MBs. *) FileByteCount[NotebookFileName[nb]] > 2097152,
	   GenerateProgressIndicator = True;
           pnb = CreatePalette[ProgressIndicator[Dynamic[Clock[Infinity]], Indeterminate, ImageSize -> {300, 30}], WindowMargins -> Automatic,
                                           WindowTitle -> "TentifyToggle is processing the input notebook.", WindowSize -> {300, Fit}],
           GenerateProgressIndicator = False];
        gt = Quiet[Get@NotebookFileName@nb, Syntax::newl];
        NotebookPut[gt /. {re : Cell[_, _, "TentativeExample", CellDingbat -> TooltipBox[Cell[_, "ModInfo"], {_, _}], ___] :> 
         (Delete[re, 3] /. TooltipBox[Cell[a_, "ModInfo"], {_, c_}] :> TooltipBox[Cell[a, "ModInfo"], c]), 
                           ce : Cell[_, "Usage" | "2ColumnTableMod" | "3ColumnTableMod", __] :> (ce /. {TooltipBox[Cell[a_, "ModInfo"], {_, b_}] :> 
            TooltipBox[Cell[a, "ModInfo"], b], ("Rows" -> r_) :> ("Rows" -> (r /. RGBColor[__] -> None))})}, nb]; 
        StatusSet["TentativeObject"];
        If[GenerateProgressIndicator, NotebookClose[pnb]]]]]
     
GenerateTentativeProceed[nb_] := 
  Module[{nbmame = StringReplace[#, DirectoryName[#] -> ""] &[NotebookFileName[nb]], nb1}, 
  NotebookPut@Notebook[{Cell["", FontSize -> 1, CellElementSpacings -> {"CellMinHeight" -> 1}], 
      Cell[TextData[{"The notebook: \n\n", StyleBox[nbmame, FontWeight -> "Bold"], 
         "\n\nhas cells containing tentative elements. Do you want to proceed to make the entire notebook tentative? This will remove tentative elements from individual cells."}], FontFamily -> "Vedana"],
       Cell["", FontSize -> 1, CellElementSpacings -> {"CellMinHeight" -> 1}], 
      Cell[BoxData[ToBoxes[Grid[{{Button[Style["OK", Bold], TentativeProceed[nb1], Method -> "Queued"] /. nb1 -> nb, 
                                  Button[Style["Cancel", Bold], NotebookClose[]]}}]]], 
           CellContext -> "Global`"], 
      Cell["", FontSize -> 1, CellElementSpacings -> {"CellMinHeight" -> 1}]}, 
                       WindowMargins -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
                       WindowToolbars -> {}, 
                       WindowFrameElements -> {}, 
                       ShowCellBracket -> False, 
                       ClosingAutoSave -> False, 
                       WindowTitle -> "Tentative Proceed", 
                       Saveable -> False, 
                       ShowStringCharacters -> False, 
                       Selectable -> False, 
                       WindowSize -> {400, 180}, 
                       WindowFrame -> "Palette", 
                       ScrollingOptions -> {}, 
                       WindowElements -> {}]]

UntentifyNotebook::cellnf = "A style for a cell to unlabel the tentifier's name could not be found."

UntentifyNotebook[nb_] := 
 Module[{style},
 If[(* The notebook is Tentative. *)
    Options[nb, ScreenStyleEnvironment] === {ScreenStyleEnvironment -> "TentativeObject"}, 
    SetOptions[nb, ScreenStyleEnvironment -> "Preview"];
    SetOptions[nb, ScreenStyleEnvironment -> Inherited];
    style = CellStyleToSearchFor[nb];
    If[style === {},
       MessageToConsole[UntentifyNotebook::cellnf],
       NotebookFind[nb, style, All, CellStyle];
       SetOptions[NotebookSelection[nb], CellLabel -> ""]]]]

TentifyToggle::noin = "There is no open input notebook.";
TentifyToggle::cellnf = "A style for a cell to unlabel the tentifier's name could not be found."
TentifyToggle::notsav = "The cursor is between cells or not inside the input notebook so the notebook must first be saved.";
TentifyToggle::cellbrac = "The cursor is at the cell bracket. For a usage cell or table, the cursor must be inside the cell.";
TentifyToggle::mulcell = "Multiple cells have been selected.";
TentifyToggle::nottent = "This cell cannot be made Tentative.";

TentifyToggle[] := 
 Module[{nb = InputNotebook[], ci, nbi, sse, GenerateProgressIndicator, pnb, gt, a, style, Tentativeable, ReadPart, re, cellid, pos, Tentify,
         UsageWithReplacedPart, TablePartToReplace, TableWithReplacedPart},
  Catch[If[(*There is no input notebook.*)nb === $Failed, 
           Throw[MessageToConsole[TentifyToggle::noin]]];
           
        ci = CellInfo[nb];
        
        If[(* The cursor is between cells or not in the input notebook. *)ci === $Failed, 
           Throw[If[(nbi = NotebookInformation[nb]; ("FileName" /. nbi) =!= "FileName" && Not["ModifiedInMemory" /. nbi]),
           
                    sse = Options[nb, ScreenStyleEnvironment];
           
                    If[(* The screenstyle environment is already TentativeObject. *)
                       sse === {ScreenStyleEnvironment -> "TentativeObject"},
                     
                       SetOptions[nb, ScreenStyleEnvironment -> "Preview"];
                       SetOptions[nb, ScreenStyleEnvironment -> Inherited];
                       style = CellStyleToSearchFor[nb];
                       If[style === {},
                          MessageToConsole[TentifyToggle::cellnf],
                          NotebookFind[nb, style, All, CellStyle]; 
                          SetOptions[NotebookSelection[nb], CellLabel -> ""]],
                     
                       If[(* File size > 2 MBs. *) FileByteCount[NotebookFileName[nb]] > 2097152,
                          GenerateProgressIndicator = True;
                          pnb = CreatePalette[ProgressIndicator[Dynamic[Clock[Infinity]], Indeterminate, ImageSize -> {300, 30}],
                                              WindowMargins -> Automatic, WindowTitle -> "TentifyToggle is processing the input notebook.",
                                              WindowSize -> {300, Fit}],
                          GenerateProgressIndicator = False]; 
                       gt = Quiet[Get@NotebookFileName@nb, Syntax::newl];
                     
                       If[GenerateProgressIndicator, NotebookClose[pnb]];
                       If[(* No cells or parts of cells are tentative. *)
                          Cases[gt, TooltipBox[Cell[_, "ModInfo"], {_, _}], Infinity] === {}, 
                          StatusSet["TentativeObject"], 
                          GenerateTentativeProceed[nb]]],
                          
                    MessageToConsole[TentifyToggle::notsav]]]];
           
        If[(*The cursor is at the cell bracket.*)("CursorPosition" /. ci) === {"CellBracket"} && 
                                                              MemberQ[List /@ {"Usage", "2ColumnTableMod", "3ColumnTableMod"}, ("Style" /. CellInfo[nb])], 
           Throw[MessageToConsole[TentifyToggle::cellbrac]]];
           
        If[multipleCellBracketsSelected[ci], 
           Throw[MessageToConsole[TentifyToggle::mulcell]]];
           
        SetOptions[$FrontEnd, ShowSelection -> False];
        
        If[(* The cursor is inside a ModInfo cell. *)("Style" /. ci) === {"ModInfo"} && NotebookRead[nb] === {}, 
          SelectionMove[nb, All, Cell];
          FrontEndExecute[{FrontEndToken[nb, "MoveNext"]}]];
          
        If[(*The cursor is selecting part of a ModInfo cell.*)MatchQ[NotebookRead[nb], Cell[_, "ModInfo", ___]], 
           FrontEndExecute[{FrontEndToken[nb, "MoveNext"]}]];
           
        If[Cases[ci, a : ("InlineCellPosition" -> _), Infinity] =!= {},
           While[(* The cursor is in an inline cell. *)
                 Cases[ci, a : ("InlineCellPosition" -> _), Infinity] =!= {}, 
                 FrontEndExecute[{FrontEnd`FrontEndToken[nb, "ExpandSelection"]}];
                 ci = CellInfo[nb]]];
                 
        style = If[ListQ[#], #[[1]], #] &[("Style" /. CellInfo[nb])[[1]]];
        
        If[Not@MemberQ[{"Usage", "2ColumnTableMod", "3ColumnTableMod"}, style],
        
           ExpandToCell[nb];
           
           Tentativeable = If[# === TaggingRules, 
                              True, 
                              If[# === "Tentativeable", 
                                 True, 
                                 "Tentativeable" /. #]] &[TaggingRules /. CurrentValue[NotebookSelection[nb], {StyleDefinitions, style}]];
                           
           If[Not@Tentativeable, 
              Throw[SetOptions[$FrontEnd, ShowSelection -> Inherited]; MessageToConsole[TentifyToggle::nottent]]];
           
           re = NotebookRead[nb];
           cellid = (CellID /. Options[NotebookSelection[nb], CellID]);
           Which[(* The cell does not contain ModInfo *) 
                 Not@MemberQ[re, CellDingbat -> TooltipBox[Cell[_, "ModInfo"], _]],
              
                 If[IntegerQ[cellid] && cellid > 0,
                    UntentifyNotebook[nb];
                    NotebookFind[nb, cellid, All, CellID]];
                 NotebookWrite[nb, Insert[re, Unevaluated[Sequence["TentativeExample", 
            CellDingbat -> TooltipBox[Cell[ToString@$FlaggedVersion <> "+", "ModInfo"], {$UserName, ToString@$FlaggedVersion <> "+"}]]], 3], All];
                 If[Not[IntegerQ[cellid] && cellid > 0],
                    UntentifyNotebook[nb]],
         
                (* The cell is already tentative. *)
                MatchQ[re, Cell[_, _, "TentativeExample", CellDingbat -> TooltipBox[Cell[_, "ModInfo"], {_, _}], ___]],
             
                NotebookWrite[nb, Delete[re, 3] /. TooltipBox[Cell[a_, "ModInfo"], {b_, c_}] :> TooltipBox[Cell[a, "ModInfo"], c], All],
             
                (* The cell contains ModInfo but is not tentative. *)
             
                Cases[re, a : (CellDingbat -> TooltipBox[Cell[_, "ModInfo"], _])] =!= {} && Not@MatchQ[re, Cell[_, _, "TentativeExample", __]],
             
                If[IntegerQ[cellid] && cellid > 0,
		   UntentifyNotebook[nb];
                   NotebookFind[nb, cellid, All, CellID]];
                NotebookWrite[nb, 
                              Insert[re, "TentativeExample", 3] /. TooltipBox[Cell[a_, "ModInfo"], b_] :> TooltipBox[Cell[a, "ModInfo"], {$UserName, b}],
                              All];
                   If[Not[IntegerQ[cellid] && cellid > 0],
                      UntentifyNotebook[nb]]],
                           
           Which[(*The cursor is in a usage cell.*)style === "Usage",
           
                  ReadPart = NotebookRead[nb]; 
                  NotebookWrite[nb, "ToReplace"]; 
                  SelectionMove[nb, All, Cell]; 
                  re = NotebookRead[nb]; 
                  pos = Position[re[[1, 1, 1]], {_, "ToReplace"}][[1, 1]]; 
                  Tentify = True; 
                  UsageWithReplacedPart = (ReplacePart[re, {1, 1, 1, pos} -> (If[MatchQ[#, {TooltipBox[Cell[_, "ModInfo"], {$UserName, _}], _}], 
                   Tentify = False; {#, ReadPart} /. {TooltipBox[Cell[b_, "ModInfo"], {_, c_}], _} :> TooltipBox[Cell[b, "ModInfo"], c], 
                   {TooltipBox[Cell[#, "ModInfo"], {$UserName, #}], ReadPart} &[If[StringQ[#[[1, 1]]] && StringMatchQ[#[[1, 1]], Whitespace], 
                ToString@$FlaggedVersion <> "+", #[[1, 1]]]]] &[re[[1, 1, 1, pos]]])]) /. ("Rows" -> a_) :> ("Rows" -> ReplacePart[a, 
                                                                                              pos -> If[Tentify, RGBColor[0.85, 0.95, 1], None]]); 
                  NotebookWrite[nb, UsageWithReplacedPart, All],
                  
                  (* The cursor is in a table cell. *)
                  
                  MemberQ[{"2ColumnTableMod", "3ColumnTableMod"}, style],
                  
                  If[NotebookRead[nb] === {}, FrontEndExecute[{FrontEnd`FrontEndToken[nb, "ExpandSelection"]}]]; 
                  TablePartToReplace = NotebookRead[nb];
                  NotebookWrite[nb, "ToBeReplaced"];
                  ExpandToCell[nb]; 
                  re = NotebookRead[nb]; 
                  pos = Position[re, {___, TooltipBox["ToBeReplaced", _] | "ToBeReplaced", ___}][[1, 4]]; 
                  Tentify = True;
                  TableWithReplacedPart = (re /. p : {a___, TooltipBox["ToBeReplaced", _] | "ToBeReplaced", b___} :> (If[MatchQ[#[[1]], 
                   TooltipBox[Cell[_, "ModInfo"], {$UserName, _}] | TooltipBox["ToBeReplaced", {_, _}]], 
                   Tentify = False; 
                   # /. {TooltipBox[d : Cell[c_, "ModInfo"] | "ToBeReplaced", {_, f_}], e__} :> {If[MatchQ[d, Cell[_, "ModInfo"]], 
                                                                                                    TooltipBox[Cell[c, "ModInfo"], f], 
                    "ToBeReplaced"], e}, 
                    {TooltipBox[Cell[#, "ModInfo"], {$UserName, #}], 
                    Sequence @@ Take[p, {2, -1}]} &[If[StringQ[#[[1, 1]]] && StringMatchQ[#[[1, 1]], Whitespace], 
                   ToString@$FlaggedVersion <> "+", #[[1, 1]]]]] &[p])) /. {"ToBeReplaced" -> TablePartToReplace, 
                   ("Rows" -> a_) :> ("Rows" -> ReplacePart[a, pos -> If[Tentify, RGBColor[0.85, 0.95, 1], None]])};
                  NotebookWrite[nb, TableWithReplacedPart, All]];
           UntentifyNotebook[nb]]; 
                  SetOptions[$FrontEnd, ShowSelection -> Inherited]]]


MoveToCellBracket[nb_] := 
 Module[{ci}, While[(ci = CellInfo[nb]; (ci =!= $Failed) && Not[MemberQ["CursorPosition" /. ci, "CellBracket"]]), 
                    FrontEndExecute[FrontEndToken[nb, "ExpandSelection"]]]]
                    
OneOrMoreCellBracketsSelected[x_] := MatchQ[x, {{"Style" -> _, __}, {"Style" -> _, __}, ___} | {{___, "CursorPosition" -> "CellBracket", ___}}]

SetSourcePageOrCellStatus::noinputnb = "There is no input notebook.";
SetSourcePageOrCellStatus::mulcellbrack = "This function supports a selection inside a cell, at a cell bracket, between cells or no selection at all but not the selection of multiple cells.";

SetSourcePageOrCellStatus[status_String] :=
 Module[{nb = InputNotebook[], ci, re}, 
  Catch[If[nb === $Failed, 
           Throw[MessageToConsole[SetSourcePageOrCellStatus::noinputnb]]]; 
        ci = CellInfo[nb]; 
        Switch[status,
        
               "MathematicaDocument",
               
               If[ci === $Failed,
               
                  Switch[CurrentValue[nb, ScreenStyleEnvironment],
                  
                         "AlphaMathematicaDocument",
                         
                         SelectionMove[nb, Before, Notebook]; SelectionMove[nb, Next, Cell];
                         If[MatchQ[OldNotebookRead[nb], Cell[_, "AlphaMathematicaSourceFlag"|"MathematicaSourceFlag", ___]], 
                            SetOptions[NotebookSelection[nb], Editable -> True, Deletable -> True]; NotebookDelete[nb]; 
                            NotebookWrite[nb, Cell["M A T H E M A T I C A", "MathematicaSourceFlag"]]]; 
                         SetOptions[nb, ScreenStyleEnvironment -> "Preview"]; 
                         SetOptions[nb, ScreenStyleEnvironment -> "MathematicaDocument"],
                         
                         "MathematicaDocument",
                         
                         SelectionMove[nb, Before, Notebook]; SelectionMove[nb, Next, Cell];
                         If[MatchQ[OldNotebookRead[nb], Cell[_, "AlphaMathematicaSourceFlag"|"MathematicaSourceFlag", ___]], 
                            SetOptions[NotebookSelection[nb], Editable -> True, Deletable -> True]; NotebookDelete[nb]]; 
                         SetOptions[nb, ScreenStyleEnvironment -> "Preview"]; 
                         SetOptions[nb, ScreenStyleEnvironment -> "Working"], 
                         
                         _,
                         
                         SelectionMove[nb, Before, Notebook]; 
                         NotebookWrite[nb, Cell["M A T H E M A T I C A", "MathematicaSourceFlag"]]; 
                         SetOptions[nb, ScreenStyleEnvironment -> "Preview"]; 
                         SetOptions[nb, ScreenStyleEnvironment -> "MathematicaDocument"]],
                         
                  If[Not@OneOrMoreCellBracketsSelected[nb], MoveToCellBracket[nb]];
                  If[MatchQ[ci, {{"Style" -> _, __}, {"Style" -> _, __}, ___}], 
                     Throw[MessageToConsole[SetSourcePageOrCellStatus::mulcellbrack]]];
                     
                  re = OldNotebookRead[nb]; 
                  Which[MatchQ[re, Cell[_, _, "MathematicaFlag", ___]],
                  
                        NotebookWrite[nb, ReplacePart[re, 3 -> Sequence[]], All]; 
                        FrontEndExecute[FrontEnd`SelectionRemoveCellTags[nb, "Mathematica"]],
                        
                        MatchQ[re, Cell[_, _, "AlphaMathematicaFlag", ___]],
                        
                        NotebookWrite[nb, ReplacePart[re, 3 -> "MathematicaFlag"], All];
                        FrontEndExecute[FrontEnd`SelectionRemoveCellTags[nb, "Alpha & Mathematica"]]; 
                        FrontEndExecute[FrontEnd`SelectionAddCellTags[nb, "Mathematica"]],
                        
                        Not[MatchQ[re, Cell[_, _, "MathematicaFlag" | "AlphaMathematicaFlag"]]],
                        
                        SetOptions[NotebookSelection[nb], "MathematicaFlag"]; 
                        FrontEndExecute[FrontEnd`SelectionAddCellTags[nb, "Mathematica"]]]],
                        
               "AlphaMathematicaDocument",
               
               If[ci === $Failed,
               
                  Switch[CurrentValue[nb, ScreenStyleEnvironment],
                  
                         "MathematicaDocument", 
                         
                         SelectionMove[nb, Before, Notebook]; SelectionMove[nb, Next, Cell];
                         If[MatchQ[OldNotebookRead[nb], Cell[_, "AlphaMathematicaSourceFlag"|"MathematicaSourceFlag", ___]], 
                            SetOptions[NotebookSelection[nb], Editable -> True, Deletable -> True]; NotebookDelete[nb]; 
                            NotebookWrite[nb, Cell["A L P H A  &  M A T H E M A T I C A", "AlphaMathematicaSourceFlag"]]]; 
                         SetOptions[nb, ScreenStyleEnvironment -> "Preview"]; 
                         SetOptions[nb, ScreenStyleEnvironment -> "AlphaMathematicaDocument"],
                         
                         "AlphaMathematicaDocument", 
                         
                         SelectionMove[nb, Before, Notebook]; SelectionMove[nb, Next, Cell];
                         If[MatchQ[OldNotebookRead[nb], Cell[_, "AlphaMathematicaSourceFlag"|"MathematicaSourceFlag", ___]], 
                            SetOptions[NotebookSelection[nb], Editable -> True, Deletable -> True]; NotebookDelete[nb]]; 
                            SetOptions[nb, ScreenStyleEnvironment -> "Preview"]; 
                            SetOptions[nb, ScreenStyleEnvironment -> "Working"], 
                            
                         _,
                         
                         SelectionMove[nb, Before, Notebook]; 
                         NotebookWrite[nb, Cell["A L P H A  &  M A T H E M A T I C A", "AlphaMathematicaSourceFlag"]]; 
                         SetOptions[nb, ScreenStyleEnvironment -> "Preview"]; 
                         SetOptions[nb, ScreenStyleEnvironment -> "AlphaMathematicaDocument"]],
                         
                  If[Not@OneOrMoreCellBracketsSelected[nb], MoveToCellBracket[nb]];
                  If[MatchQ[ci, {{"Style" -> _, __}, {"Style" -> _, __}, ___}], 
                     Throw[MessageToConsole[SetSourcePageOrCellStatus::mulcellbrack]]];
                     
                  re = OldNotebookRead[nb]; 
                  Which[MatchQ[re, Cell[_, _, "AlphaMathematicaFlag", ___]],
                  
                        NotebookWrite[nb, ReplacePart[re, 3 -> Sequence[]], All]; 
                        FrontEndExecute[FrontEnd`SelectionRemoveCellTags[nb, "Alpha & Mathematica"]],
                        
                        MatchQ[re, Cell[_, _, "MathematicaFlag", ___]],
                        
                        NotebookWrite[nb, ReplacePart[re, 3 -> "AlphaMathematicaFlag"], All]; 
                        FrontEndExecute[FrontEnd`SelectionRemoveCellTags[nb, "Mathematica"]]; 
                        FrontEndExecute[FrontEnd`SelectionAddCellTags[nb, "Alpha & Mathematica"]],
                        
                        Not[MatchQ[re, Cell[_, _, "MathematicaFlag" | "Alpha&MathematicaFlag"]]],
                        
                        SetOptions[NotebookSelection[nb], "AlphaMathematicaFlag"]; 
                        FrontEndExecute[FrontEnd`SelectionAddCellTags[nb, "Alpha & Mathematica"]]]]]]]

$ApplicationGraphicsFile = ""

Options[GraphicInsert] = {MoveToCellBracketOfButton -> False}

GraphicInsert::noin = "There is no input notebook.";
GraphicInsert::mulcell = "Multiple cell brackets have been selected.";
GraphicInsert::graphictype = "The file selected must be one of the following types: .gif, .jpg, .png or .tif.";
GraphicInsert::cellbrac = "The cursor must be between cells inside a solutions section or at the cell bracket of either a \"SolutionsAbstractImage\" or \"SolutionsImageShifted\" cell.";
GraphicInsert::nocontent = "The notebook has no content.";
GraphicInsert::notsolutionssection = "The selection was not between cells in a solutions section or at the cell bracket of a solutions graphics cell.";

GraphicInsert[opts___] := 
 Module[{nb = InputNotebook[], move, ci, ci2, celltag, i, ct},
  Catch[move = MoveToCellBracketOfButton /. {opts} /. Options[GraphicInsert];
  
  If[(* No input notebook exists. *)
     nb === $Failed, 
     Throw[MessageToConsole[GraphicInsert::noin]]];
     
  ci = CellInfo[nb];
  If[(* Multiple cell brackets are selected. *)
     multipleCellBracketsSelected[ci], 
     Throw[MessageToConsole[GraphicInsert::mulcell]]];
     
  If[move, SelectionMove[EvaluationNotebook[], All, ButtonCell];
           ci = CellInfo[nb]];
  
  If[MatchQ[ci, {{"Style" -> "SolutionsAbstractImage" | "SolutionsImageShifted", __, "CursorPosition" -> "CellBracket", __}}] || ci === $Failed,
  
     If[# =!= Null && # =!= $Canceled, 
        If[StringMatchQ[#, __~~(".gif"|".tif"|".jpg"|".png")], $ApplicationGraphicsFile = #, Throw[MessageToConsole[GraphicInsert::graphictype]; Abort[]]],
        Abort[]] &[SystemDialogInput["FileOpen", {If[StringQ[#] && FileType[#] === File, 
                                                     DirectoryName[#], 
                                                     $DocumentationDirectory]&[$ApplicationGraphicsFile], 
                                                  {"*.gif, *.tif, *.jpg, or *.png" -> {"*.*"}}}, 
                                     WindowTitle -> "Browse for a graphics file"]],
                                     
     Throw[MessageToConsole[GraphicInsert::cellbrac]]];
     
  ci2 = CellInfo[nb];
  If[MatchQ[ci2, {{"Style" -> "SolutionsAbstractImage" | "SolutionsImageShifted", __, "CursorPosition" -> "CellBracket", __}}],
  
     NotebookWrite[nb, ToBoxes[Import[$ApplicationGraphicsFile], StandardForm]]; 
     SelectionMove[nb, All, Cell]; 
     If[MatchQ[ci2, {{"Style" -> "SolutionsAbstractImage", __}}], 
        FrontEndExecute[{FrontEnd`FrontEndToken[nb, "Style", "SolutionsAbstractImage"]}], 
        FrontEndExecute[{FrontEnd`FrontEndToken[nb, "Style", "SolutionsImageShifted"]}]],
        
     If[ci2 === $Failed,
     
        celltag = StringJoin @@ (ToString /@ Date[]); 
        NotebookWrite[nb, Cell["Position Marker", "Text", CellTags -> celltag]];
        i = 1; 
        While[i < 10,
           
              FrontEndTokenExecute[nb, "ExpandSelection"];
              If[MatchQ[CellInfo[nb], {{"Style" -> "SolutionsSection", __}, __}],
                 
                 SelectionMove[nb, Before, Cell]; 
                 SelectionMove[nb, Next, Cell]; 
                 ct = (Options[NotebookSelection[nb], CellTags] === {CellTags -> "CaptionsAndImagesForSlideshow"}); 
                 NotebookFind[nb, celltag, All, CellTags]; 
                 NotebookWrite[nb, ToBoxes[Import[$ApplicationGraphicsFile], StandardForm]]; 
                 SelectionMove[nb, All, Cell]; 
                 If[ct, 
                    FrontEndExecute[{FrontEnd`FrontEndToken[nb, "Style", "SolutionsAbstractImage"]}], 
                    FrontEndExecute[{FrontEnd`FrontEndToken[nb, "Style", "SolutionsImageShifted"]}]]; Abort[],
                       
                  i++]];
                    
        NotebookFind[nb, celltag, All, CellTags]; 
        NotebookDelete[nb]; 
        MessageToConsole[GraphicInsert::notsolutionssection]]]]]


CharacterToLongName::noin = "There is no input notebook.";
CharacterToLongName::betwcells = "The cursor is between cells or not inside an input notebook.";
CharacterToLongName::mulcell = "Multiple cells have been selected.";
CharacterToLongName::cellbrac = "A cell bracket is selected.";
CharacterToLongName::notspecchar = "The short form of a special character must be selected or the cursor must be put immediately after a special character.";
CharacterToLongName::nstruc = "This structure cannot be handled by CharacterToLongName.";

SpecialCharacterQ[x_String] := StringMatchQ[x, "\"\\[" ~~ a__?(Not@MemberQ[{"[", "]"}, #] &) ~~ "]\""]

LongNameExpressionToWrite[re1_, re_]:= 
 Module[{opts, f},
  Switch[re1,
         _String,
         TextData@Cell[TextData@f[re1, RuleDelayed @@ (ButtonData -> "paclet:ref/character/" <> StringTake[re, {4, -3}]),
                  BaseStyle -> "Link"], 
                       "InlineCharacterName"] /. f -> ButtonBox,
         BoxData[_String],
         TextData@Cell[TextData[f[re1[[1]], 
                                  RuleDelayed @@ (ButtonData -> "paclet:ref/character/" <> StringTake[re, {4, -3}]), 
                                  BaseStyle -> "Link"]], 
                       "InlineCharacterName"] /. f -> ButtonBox,
         StyleBox[_String, __],
         opts = Take[re1, {2, -1}];
         TextData@Cell[TextData@StyleBox[f[re1, 
                       RuleDelayed @@ (ButtonData -> "paclet:ref/character/" <> StringTake[re, {4, -3}]),
                       BaseStyle -> "Link"], Sequence@@opts], 
                       "InlineCharacterName"] /. f -> ButtonBox,
         BoxData[StyleBox[_String, __]],
         opts = Take[re1[[1]], {2, -1}];
         TextData@Cell[TextData@StyleBox[f[re1, 
                       RuleDelayed @@ (ButtonData -> "paclet:ref/character/" <> StringTake[re, {4, -3}]),
                       BaseStyle -> "Link"], Sequence@@opts], 
                       "InlineCharacterName"] /. f -> ButtonBox]]

CharacterToLongName[] := 
 Module[{nb = InputNotebook[], ci, re, re1, stringpart},
 
        Catch[If[(* There is no input notebook. *)
                 nb === $Failed, 
                 Throw[MessageToConsole[CharacterToLongName::noin]]];
                 
              ci = CellInfo[nb];
              
              If[(* The cursor is between cells. *)
                 ci === $Failed, 
                 Throw[MessageToConsole[CharacterToLongName::betwcells]]];
                 
              If[multipleCellBracketsSelected[ci], 
                 Throw[MessageToConsole[CharacterToLongName::mulcell]]];
                 
              If[("CursorPosition" /. ci) === {"CellBracket"}, 
                 Throw[MessageToConsole[CharacterToLongName::cellbrac]]];
                 
              If[MatchQ[("CursorPosition" /. ci), {{a_Integer, b_Integer}} /; a === b],
              
                 Throw[FrontEndExecute[{FrontEnd`FrontEndToken[nb, "SelectPrevious"]}];
                       re1 = OldNotebookRead[nb];
                       stringpart = Switch[re1, _String, re1, BoxData[_String], re1[[1]], StyleBox[_String, __],
                                                re1[[1]], BoxData[StyleBox[_String, __]], re1[[1, 1]], 
                                                _, Throw[MessageToConsole[CharacterToLongName::nstruc];
                                                         FrontEndExecute[{FrontEnd`FrontEndToken[nb, "MoveNext"]}]]];
                       re = ToString[stringpart, InputForm, CharacterEncoding -> None];
                       
                       If[Not@SpecialCharacterQ[re],
                       
                          MessageToConsole[CharacterToLongName::notspecchar];
                          FrontEndExecute[{FrontEnd`FrontEndToken[nb, "MoveNext"]}],
                          
                          NotebookWrite[nb, LongNameExpressionToWrite[re1, re]]]]];
                 
              If[MatchQ[("CursorPosition" /. ci), {{a_Integer, b_Integer}} /; b =!= a + 1], 
                 Throw[MessageToConsole[CharacterToLongName::notspecchar]]];
                 
              re1 = OldNotebookRead[nb];
              stringpart = Switch[re1, _String, re1, BoxData[_String], re1[[1]], StyleBox[_String, __],
                                                          re1[[1]], BoxData[StyleBox[_String, __]], re1[[1, 1]], 
                                                _, Throw[MessageToConsole[CharacterToLongName::nstruc];
                                                         FrontEndExecute[{FrontEnd`FrontEndToken[nb, "MoveNext"]}]]];
              re = ToString[stringpart, InputForm, CharacterEncoding -> None];
              
              If[Not@SpecialCharacterQ[re], 
                 Throw[MessageToConsole[CharacterToLongName::notspecchar]]];
                 
                 NotebookWrite[nb, LongNameExpressionToWrite[re1, re]]]]


RestoreDefault::noin = "There is no input notebook.";
RestoreDefault::betwcells = "The cursor is between cells or not inside an input notebook.";
RestoreDefault::mulcell = "Multiple cells have been selected. The intent of this function is to restore the default cell style at a cursor position inside a cell.";
RestoreDefault::cellbrac = "A cell bracket has been selected. The intent of this function is to restore the default cell style at a cursor position inside a cell.";

RestoreDefault[] := 
 Module[{nb = InputNotebook[], ci}, 
        Catch[If[(* There is no input notebook. *)
                 nb === $Failed, 
                 Throw[MessageToConsole[RestoreDefault::noin]]];
              ci = CellInfo[nb];
              If[(* The cursor is between cells. *)
                 ci === $Failed, 
                 Throw[MessageToConsole[RestoreDefault::betwcells]]];
              If[multipleCellBracketsSelected[ci], 
                 Throw[MessageToConsole[RestoreDefault::mulcell]]]; 
              If[("CursorPosition" /. ci) === {"CellBracket"}, 
                 Throw[MessageToConsole[RestoreDefault::cellbrac]]];
              If[MatchQ["CursorPosition" /. ci, {{___, a_, b_}} /; a =!= b],
                 FrontEndExecute[{FrontEnd`FrontEndToken[nb, "ClearCellOptions"]}],
                 NotebookWrite[nb, Cell[" "], All];
                 NotebookWrite[nb, ""]]]]


KeywordLabelApply::noinputnb = "There is no input notebook.";
KeywordLabelApply::selection = "The selection should be a synonym or keyword cell, a list of synonym cells, a list of keyword cells or a synonyn or keyword cell group.";
KeywordLabelApply::mixedselection = "If multiple cells are selected, all must be cells of style \"Synonyms\" or all must be of style \"Keywords\" (in addition to a possible head cell).";

KeywordLabelApply[label_String] :=
 Module[{nb = InputNotebook[], ci, re, cellids}, 
  Catch[If[nb === $Failed, Throw[MessageToConsole[KeywordLabelApply::noinputnb]]];
  ci = CellInfo[nb]; 
  If[ci === $Failed, Throw[MessageToConsole[KeywordLabelApply::selection]]]; 
  If[Not[MemberQ["CursorPosition" /. ci, "CellBracket"]], MoveToCellBracket[nb]]; 
  If[MatchQ[ci, {{"Style" -> "Synonyms" | "Keywords", __}}], 
     SetOptions[NotebookSelection[nb], CellLabel -> label]];
  If[MatchQ[ci, {{"Style" -> ("Synonyms" | "SynonymsSection"), __}, {"Style" -> "Synonyms", __} ..} | 
                {{"Style" -> ("Keywords" | "KeywordsSection"), __}, {"Style" -> "Keywords", __} ..}], 
     re = NotebookRead[nb]; 
     If[Union[MemberQ[#, CellID -> _] & /@ If[MatchQ[re, Cell[CellGroupData[__]]], Cases[re, Cell[__], {3}], re]] === {True}, 
        cellids = If[MatchQ[re, Cell[CellGroupData[__]]], 
                     Cases[re, a : (CellID -> b_) :> b, {4}], 
                     Cases[re, a : (CellID -> b_) :> b, 2]]; 
        SelectionMove[nb, Before, Cell]; 
        (NotebookFind[nb, #, All, CellID]; 
         SetOptions[NotebookSelection[nb], CellLabel -> label]) & /@ If[MatchQ[re, Cell[CellGroupData[__]]], Drop[cellids, 1], cellids]; 
        SelectionMove[nb, After, Cell]]]; 
  If[Not[MatchQ[ci, {{"Style" -> "Synonyms", __} ..} | {{"Style" -> "Keywords", __} ..} | 
                    {{"Style" -> ("Synonyms" | "SynonymsSection"), __}, {"Style" -> "Synonyms", __} ..} |
                    {{"Style" -> ("Keywords" | "KeywordsSection"), __}, {"Style" -> "Keywords", __} ..}]],
     MessageToConsole[KeywordLabelApply::selection]]]]
     
ClearKeywordLabel::noinputnb = "There is no input notebook.";
ClearKeywordLabel::selection = "The selection should be a synonym or keyword cell, a list of synonym cells or a list of keyword cells.";
ClearKeywordLabel::mixedselection = "If multiple cells are selected, all must be cells of style \"Synonyms\" or all must be of style \"Keywords\".";

ClearKeywordLabel[] := 
 Module[{nb = InputNotebook[], ci, a, re, cellids}, 
  Catch[If[nb === $Failed, Throw[MessageToConsole[ClearKeywordLabel::noinputnb]]];
  ci = CellInfo[nb]; 
  If[ci === $Failed, Throw[MessageToConsole[ClearKeywordLabel::selection]]]; 
  If[Not[MemberQ["CursorPosition" /. ci, "CellBracket"]], 
     MoveToCellBracket[nb]]; 
  If[MatchQ[ci, {{"Style" -> "Synonyms" | "Keywords", __}}], 
     If[Not[FreeQ[#, CellLabel -> _]], 
        NotebookWrite[nb, DeleteCases[#, a : (CellLabel -> _)]]] &[NotebookRead[nb]]];
  If[MatchQ[ci, {{"Style" -> ("Synonyms" | "SynonymsSection"), __}, {"Style" -> "Synonyms", __} ..} | 
                {{"Style" -> ("Keywords" | "KeywordsSection"), __}, {"Style" -> "Keywords", __} ..}], 
     re = NotebookRead[nb]; 
     If[Union[MemberQ[#, CellID -> _] & /@ If[MatchQ[re, Cell[CellGroupData[__]]], Cases[re, Cell[__], {3}], re]] === {True}, 
        cellids = If[MatchQ[re, Cell[CellGroupData[__]]], 
                     Cases[re, a : (CellID -> b_) :> b, {4}], 
                     Cases[re, a : (CellID -> b_) :> b, 2]];
        SelectionMove[nb, Before, Cell]; 
        (NotebookFind[nb, #, All, CellID]; 
         If[Not[FreeQ[#, CellLabel -> _]], 
           NotebookWrite[nb, DeleteCases[#, a : (CellLabel -> _)]]] &[NotebookRead[nb]]) & /@ If[MatchQ[re, Cell[CellGroupData[__]]], 
                                                                                                 Drop[cellids, 1], 
                                                                                                 cellids]; 
        SelectionMove[nb, After, Cell]]]; 
  If[Not[MatchQ[ci, {{"Style" -> "Synonyms", __} ..} | {{"Style" -> "Keywords", __} ..} | 
                    {{"Style" -> ("Synonyms" | "SynonymsSection"), __}, {"Style" -> "Synonyms", __} ..} |
                    {{"Style" -> ("Keywords" | "KeywordsSection"), __}, {"Style" -> "Keywords", __} ..}]], 
     MessageToConsole[ClearKeywordLabel::selection]]]]


Options[TraditionalFormCell] =
  {
    "Notebook" -> Automatic
      (* Document notebook (default: InputNotebook[]). *)
  };

TraditionalFormCell[options___?OptionQ]:=
  Module[
    {
      optNotebook, nb, data, icp
    },
    {optNotebook} =
      {"Notebook"}
        /. {options} /. Options[TraditionalFormCell];
    nb =
      If[optNotebook === Automatic,
        InputNotebook[],
        optNotebook
      ];
    (* Check that the selection (or cursor) is within a Cell. *)
    Replace[ CellInfo[nb], {
      $Failed :> (
        MessageToConsole[TraditionalFormCell::nocellsel];
        Return[$Failed]
      ),
      info_ :> (icp = Replace[ "InlineCellPosition", Flatten @ {info, _ -> Null}])
    }];
    (* Read the current selection. *)
    data = OldNotebookRead[nb];
    (* If no selection, select the previous word. *)
    If[data === {}, 
      FrontEndExecute[{
        FrontEnd`FrontEndToken[nb, "MovePreviousWord"],
        FrontEnd`FrontEndToken[nb, "MoveNextWord"],
        FrontEnd`FrontEndToken[nb, "SelectPreviousWord"]
      }]
    ];
    (* Expand selections within an inline cell to that whole inline cell.
       Expand only as far as the innermost enclosing cell. *)
    While[
      ({"InlineCellPosition", "ContentData"} /. Flatten @ CellInfo @ nb) ===
        {icp, BoxData},
      FrontEndExecute[{FrontEnd`FrontEndToken[nb, "ExpandSelection"]}]
    ];
    (* Do an updated read. *)
    data = OldNotebookRead[nb];
    (* Try to convert to TraditionalForm and apply a cell style
      (but intercept any errors) *)
    data =
      Block[
        {$Messages = {}}, 
        Check[
          ToExpression[
            data,
            StandardForm,
            Function[{expr},
              Cell[BoxData[
                FormBox[MakeBoxes[expr, TraditionalForm], TraditionalForm]
              ], "InlineMath"],
              HoldFirst
            ]
          ],
          $Failed
        ]
      ];
    If[data === $Failed,
      MessageToConsole[TraditionalFormCell::badmath];
      Return[$Failed]
    ];
    (* Convert some of sw's special notation. *)
(*
    data = data /. {
      s_String :>
    Block[{Italicization = Identity, FunctionLinkableQ = False &}, StylizeTemplatePart[s]]
    };
*)
    data = ReplacePart[ data,
      Thread[
        Position[ data, _String, {-1}] ->
        Cases[ data,
          s_String :> 
            Block[{Italicization = Identity, FunctionLinkableQ = False &}, StylizeTemplatePart[s]],
          {-1}
        ]
      ]
    ];
    (* Write the result. *)
    SetOptions[ NotebookSelection @ nb, Deletable -> True];
    NotebookWrite[nb, data]
  ];






oneOrMoreCellBracketsSelected[x_] := 
 MatchQ[x, {{"Style" -> _, __}, {"Style" -> _, __}, ___}] || (MatchQ[
     x, {{"Style" -> _, __}}] && ("CursorPosition" /. x) === {"CellBracket"})
     
SyntaxTemplateException::noin = "There is no open input notebook.";
SyntaxTemplateException::incorsel = "The initial selection must be within
an \"InlineFormula\" cell within a cell of style \"Notes\" or \"Usage\".";

SyntaxTemplateException[action: ("Exclusion" | "Inclusion")] := 
  Module[{nb = InputNotebook[], ci, style, opts, stylenames = If[$VersionNumber < 8, ToExpression["Global`StyleNames"], ToExpression["System`StyleNames"]]}, 
    Catch[
      If[(* There is no open input notebook. *)
        nb === $Failed, 
        Throw[MessageToConsole[SyntaxTemplateException::noin]]];
        
      ci = CellInfo[nb];
      
      If[(* The cursor was either not inside a notebook or between cells. *)
        ci === $Failed, 
        Throw[MessageToConsole[SyntaxTemplateException::incorsel]]];
        
      If[(* One or more cell brackets were selected. *)
        oneOrMoreCellBracketsSelected[ci], 
        Throw[MessageToConsole[SyntaxTemplateException::incorsel]]];

      (* Also allow for initial selection at end of InlineFormula... *)
      If[
        ("Style" /. First@CellInfo[nb] /. "Style" -> None)
          != "InlineFormula",
        FrontEndExecute[{FrontEnd`FrontEndToken[nb, "MovePrevious"]}]
      ];

      (* ...but if not immediately following, throw a selection error. *)
      If[
        ("Style" /. First@CellInfo[nb] /. "Style" -> None)
          != "InlineFormula",
        Throw[MessageToConsole[SyntaxTemplateException::incorsel]]
      ];

      (* Expand outward to the contents of the inline cell. *)
      While[
        (style = "Style" /. First@CellInfo[nb] /. "Style" -> None)
          == "InlineFormula",
        FrontEndExecute[{FrontEnd`FrontEndToken[nb, "ExpandSelection"]}]
      ];

      opts =
        stylenames
          /. Options[NotebookSelection[nb], stylenames]
            /. stylenames -> None;

      newopt =
        Switch[style,
          "Notes",
            Switch[action,
              "Exclusion", Inherited,
              "Inclusion", 
                Switch[opts,
                  "TemplateInclusion", Inherited,
                  _,                   "TemplateInclusion"
                ]
            ],
          "Usage",
            Switch[action,
              "Exclusion", 
                Switch[opts,
                  "TemplateExclusion", Inherited,
                  _,                   "TemplateExclusion"
                ],
              "Inclusion", Inherited
            ],
          _,
            Throw[MessageToConsole[SyntaxTemplateException::incorsel]]
        ];

      SetOptions[NotebookSelection[nb], newopt];

      FrontEndExecute[{FrontEnd`FrontEndToken[nb, "MoveNext"]}]

    ]
  ]
      
      
SetColumnWidths::noin = "There is no input notebook.";
SetColumnWidths::nonnumberarg = "The arguments of SetColumnWidths must be numeric.";
SetColumnWidths::total = "Each argument must be of the form .xy where x and y are between 0 and 9 inclusive and the sum of the arguments must be 1.00.";
SetColumnWidths::betwcells = "The cursor is between cells or not inside an input notebook.";
SetColumnWidths::notdefbox = "The cell style must be \"DefinitionBox\".";
SetColumnWidths::not2col = "The definition box must have two columns.";

SetColumnWidths[m_, n_] := 
 Module[{nb, ci}, 
        nb = InputNotebook[]; 
  Catch[If[nb === $Failed,
          (* There is no input notebook. *)
          Throw[MessageToConsole[SetColumnWidths::noin]]]; 
        If[Not[NumberQ[m] && NumberQ[n]], 
           Throw[MessageToConsole[SetColumnWidths::nonnumberarg]]]; 
        If[Round[100 Total@{m, n}] =!= 100, 
           Throw[MessageToConsole[SetColumnWidths::total]]]; 
        ci = DocumentationTools`CellInfo[nb];
        If[ci === $Failed,
          (* The cursor is between cells or not inside an input notebook. *)
          Throw[MessageToConsole[SetColumnWidths::betwcells]]]; 
        If[("Style" /. ci)[[1]] =!= "DefinitionBox",
           (* The cell style is not a "DefinitionBox". *)
           Throw[MessageToConsole[SetColumnWidths::notdefbox]]]; 
        If[Not@MatchQ[NotebookRead[nb], Cell[BoxData[GridBox[{{_, _} ..}]], "DefinitionBox", ___]], 
           Throw[MessageToConsole[SetColumnWidths::not2col]]]; 
        SetOptions[NotebookSelection[nb], GridBoxOptions -> {"ColumnWidths" -> {m, n}}]]]
    

TwoColumnToggle::noin = "There is no open input notebook.";
TwoColumnToggle::ince = "The cursor was not inside a cell or selecting one or more cell brackets.";
TwoColumnToggle::twocoltab = "The cursor is now at a cell bracket of a cell which is not a 2 column table of inline cells.";

(* Need to address the non-contiguous sequence of cells situation. *)

TwoColumnToggle[gridstyle_String] := 
  Module[{nb = InputNotebook[], ci, re, 
          gridForm = GridBox[_?((MatrixQ[#, MatchQ[#, Cell[_, _String, ___]] &] && Dimensions[#][[2]] === 2) &)], 
          form, style}, 
        form = Cell[BoxData[TagBox[gridForm, "Grid"] | FormBox[gridForm, Grid] | gridForm], __]; 
        Catch[If[(* There is no open input notebook. *)
                 nb === $Failed, Throw[MessageToConsole[TwoColumnToggle::noin]]];
                 
              ci = CellInfo[nb];
              
             If[(* The cursor was not inside a cell or selecting one or more cell brackets. *)
                ci === $Failed, Throw[MessageToConsole[TwoColumnToggle::ince]]];
                
             ExpandToCell[nb];
             re = OldNotebookRead[nb];
             
             If[(* The cursor is now at a cell bracket of a cell which is not a 2 column table of inline cells. *)
                MatchQ[re, Cell[__]] && Not@MatchQ[re, form], Throw[MessageToConsole[TwoColumnToggle::twocoltab]]];
                
             If[(* The cursor is at the cell bracket of a two column table so write the individual inline cells into
                   the notebook. *)
                MatchQ[re, form],
                
                Switch[re, Cell[BoxData[TagBox[gridForm, "Grid"]], __] | Cell[BoxData[FormBox[gridForm, Grid]], __],
                
                       NotebookWrite[nb, Join @@ Transpose[re[[1, 1, 1, 1]]] /. {a__, Cell["", __]} :> {a}, All], 
                       
                       _, 
                       
                       NotebookWrite[nb, Join @@ Transpose[re[[1, 1, 1]]] /. {a__, Cell["", __]} :> {a}, All]],
                       
                (* More than one cell bracket is selected so form a grid out of the cells. *)
                
                If[gridstyle === "", style = re[[1, 2]]];
                NotebookWrite[nb, Cell[BoxData[GridBox[Transpose@If[OddQ[Length[re]], 
                                                                    {Take[re, Ceiling[Length[re]/2]], 
                                                                     Append[Take[re, {Ceiling[Length[re]/2] + 1, -1}], 
                                                                     Cell["", re[[-1, 2]]]]}, 
                                                                    {Take[re, Length[re]/2], 
                                                                  Take[re, {Length[re]/2 + 1, -1}]}]]], 
                                       If[gridstyle === "", style, gridstyle]], All]]]]

TwoColumnToggle[ ] := TwoColumnToggle[""]

      
TableInsert::notposint = "A positive integer must be inserted into the input field.";
TableInsert::noin = "There is no input notebook.";
TableInsert::notbetwcells = "The cursor must be between cells to insert a table.";

Options[TableInsert] = {"ModInfoColumn" -> True, NumberOfRows -> 2, PlaceholderObject -> Automatic, TableStyle -> Automatic}

TableInsert[numberOfColumns_, opts___] := 
 Module[{nb = NextNotebook[], modinfo, numberofrows, placeholderObject, tableStyle, selpos, ci, style, mat, row, func},
        modinfo = "ModInfoColumn" /. {opts} /. Options[TableInsert];
        numberofrows = NumberOfRows /. {opts} /. Options[TableInsert];
        placeholderObject = PlaceholderObject /. {opts} /. Options[TableInsert];
        tableStyle = TableStyle /. {opts} /. Options[TableInsert];
  Catch[If[(* NumberOfRows is Null or not a positive integer. *)
        numberofrows === Null || Not[IntegerQ[numberofrows] && Positive[numberofrows]], 
        Throw[MessageToConsole[TableInsert::notposint]]];
        If[(* There is no input notebook. *)
        nb === $Failed, 
        Throw[MessageToConsole[TableInsert::noin]]];
        ci = CellInfo[nb];
        If[(* The cursor is between cells. *)
           ci =!= $Failed, 
           Throw[MessageToConsole[TableInsert::notbetwcells]]];
           style = If[tableStyle === Automatic,
                      ToString[numberOfColumns] <> "ColumnTableMod",
                      tableStyle];
        Which[placeholderObject === Automatic,
          mat = Which[numberOfColumns === 1,
                      Table[{Cell["XXXX", "TableText"]}, {numberofrows}],
                      numberOfColumns === 2,
                      Table[{Cell["      ", "ModInfo"], Cell["XXXX", "TableText"]}, {numberofrows}],
                      True,
                      Table[Join[{Cell["      ", "ModInfo"]}, 
                           Table["XXXX", {numberOfColumns - 2}], 
                           {Cell["XXXX", "TableText"]}], {numberofrows}]], 
          ListQ[placeholderObject],
          row = If[Length[placeholderObject] >= numberOfColumns, 
                   Take[placeholderObject, numberOfColumns],
                   Join[placeholderObject, 
                        Table[placeholderObject[[-1]], {numberOfColumns - Length[placeholderObject]}]]];
          mat = Table[row, {numberofrows}]];
          If[modinfo,
             func = StringReplace[#, LongestMatch[a : DigitCharacter ~~ b__] :> ToString[ToExpression[a] - 1] <> b] &; 
             If[MemberQ[MatchQ[#, Cell[_, x_ /; StringMatchQ[x, "ModInfo"]]] & /@ mat[[All, 1]], True] && 
          If[StringQ[style], StringMatchQ[style , DigitCharacter ~~ __], StringMatchQ[style[[1]] , 
                                                                                      DigitCharacter ~~ __]], 
          style = If[StringQ[style], func[style], MapAt[func, style, 1]]]];
        NotebookWrite[nb, 
                      Cell[BoxData[GridBox[mat]],
                           If[StringQ[style], style, Sequence@@style]], All];
                           
        selpos = If[MemberQ[mat[[All, 1]], Cell[_, "ModInfo", ___]], 2, 1];
                           
        SelectionMove[nb, Before, CellContents];
	FrontEndExecute[{FrontEnd`FrontEndToken[nb, "MoveNext"]}];
	If[selpos===2,Do[FrontEndExecute[{FrontEnd`FrontEndToken[nb, "ExpandSelection"]}], {2}]];
	
	NotebookFind[nb, "XXXX"]
        (*
        If[placeholderObject === Automatic, 
           Which[numberOfColumns === 1, 
                 NotebookFind[nb, "XXXX"], 
                 numberOfColumns === 2,
                 NotebookFind[nb, #] & /@ Take[{"      ", "XXXX"}, selpos], 
                 True, 
                 NotebookFind[nb, #] & /@ Take[Prepend[Table["XXXX", {numberOfColumns - 1}], "      "], selpos]], 
           NotebookFind[nb, #] & /@ Take[If[StringQ[#], #, Cases[#, _String, Infinity][[1]]] & /@ row, 
                                         selpos]]*)
                                         
       ]]
  
TableInsert[opts___] := TableInsert[3, opts]


TableInsertDialog[] :=
 Module[{nb, u},
 (SelectionMove[#, Before, Notebook]; 
  SelectionMove[#, Next, Cell, 2];
  SelectionMove[#, After, CellContents]; 
  FrontEndTokenExecute[#, "Tab"]; 
  SetSelectedNotebook[#]) &[nb = NotebookPut[Notebook[{Cell["", FontSize -> 1, CellElementSpacings -> {"CellMinHeight" -> 1}], 
     Cell[BoxData[ToBoxes@Style[Grid[{{Grid[{{Style["Number of Rows:", Bold, Editable -> False], 
                                              InputField[Dynamic[$NumberOfRows], Number, FieldSize -> {3, {1, Infinity}}]}}]}, 
                                      {Grid[{Flatten[Transpose[{RadioButton[Dynamic[$ColumnNumber, ($ColumnNumber = #) &], #] & /@ {"2 column", "3 column"}, 
                                                               Style[#, Editable -> False, Selectable -> False] & /@ {"2 column", "3 column"}}]]}, 
                                            Spacings -> {{0, .4, .7, .4}}]}, 
                                      {Grid[{{Checkbox[Dynamic[$TextOnly, (u = #; If[Not[ValueQ[$TextOnly]] || $TextOnly, 
                                                                                     $TextOnly = False, $TextOnly = True]) &]], "Text Format"}}, 
                                            Spacings -> {{0, .4}}]}, 
                                      {OldRow[{Button[Style["OK", Bold], (TableInsert[ToExpression[StringTake[$ColumnNumber, 1]] + 1, 
                                                                                     NumberOfRows -> $NumberOfRows, 
                PlaceholderObject -> If[Not[$TextOnly], Automatic, {Cell["      ", "ModInfo"], Cell["XXXX", "TableText"]}]];
                                                                           NotebookClose[]), Method -> "Queued"], 
                                               Button[Style["Cancel", Bold], NotebookClose[]]}, 
                                              RowAlignments -> Center]}}, 
                                     Alignment -> Left, Spacings -> {Automatic, {1 -> 1, 2 -> 1, 3 -> .5, 4 -> 1}}],
                                FontFamily -> "Verdana", FontSize -> 11]], 
          CellContext -> "Global`"], 
     Cell["", FontSize -> 1, CellElementSpacings -> {"CellMinHeight" -> 1}]}, 
                                                 WindowMargins -> {{Automatic, Automatic}, {Automatic, Automatic}},
                                                 WindowFrame -> "Palette", 
                                                 WindowElements -> {}, 
                                                 WindowFrameElements -> {}, 
                                                 ShowCellBracket -> False, 
                                                 ClosingAutoSave -> False, 
                                                 WindowTitle -> "Insert Table", 
                                                 NotebookEventActions -> {"ReturnKeyDown" :> (FrontEndTokenExecute[nb, "Tab"];
                                                                                              TableInsert[ToExpression[StringTake[$ColumnNumber, 1]] + 1, 
                                                                                                         NumberOfRows -> $NumberOfRows, 
                                              PlaceholderObject -> If[Not[$TextOnly], Automatic, {Cell["      ", "ModInfo"], Cell["XXXX", "TableText"]}]];
                                                                                              NotebookClose[])}, 
                                                 Saveable -> False, 
                                                 ShowStringCharacters -> False, 
                                                 Selectable -> False, 
                                                 WindowSize -> {200, FitAll}]]]]


$AcceptableTableStyles = {"*DefinitionBox*", "*Table*"}

TableAddColumn::noin = "There is no input notebook.";
TableAddColumn::betwcells = "The cursor is between cells or not inside an input notebook.";
TableAddColumn::mulcell = "Multiple cells have been selected.";
TableAddColumn::nottable = "The cursor is not in a table cell.";
TableAddColumn::insuffcols = "There are insufficient columns for this function to be applied.";
TableAddColumn::rowerror = "An error has occurred. Select any spurious placeholders, delete and then try a different selection/position for the cursor and click the Add Column button again.";

Options[TableAddColumn] = {"ModInfoColumn" -> True, PlaceholderObject -> "XXXX", ColumnPosition -> None, TableStyle -> Automatic}

TableAddColumn[opts___] :=
 Module[{nb = InputNotebook[], modinfo, placeHolderObject, columnPosition, tableStyle, ci, style, 
         re, re3, dims, tr, pos, newpart, rewritten, newstyle, func, ff, posOfNewCol,
         keyfindstring, findstrings},
         
        modinfo = "ModInfoColumn" /. {opts} /. Options[TableInsert];
        placeHolderObject = PlaceholderObject /. {opts} /. Options[TableAddColumn]; 
        columnPosition = ColumnPosition /. {opts} /. Options[TableAddColumn]; 
        tableStyle = TableStyle /. {opts} /. Options[TableAddColumn];
        
  Catch[If[(* There is no input notebook. *)
           nb === $Failed, 
           Throw[MessageToConsole[TableAddColumn::noin]]];
           
        ci = CellInfo[nb];
        If[(* The cursor is between cells. *)
           ci === $Failed, 
           Throw[MessageToConsole[TableAddColumn::betwcells]]];
           
        If[multipleCellBracketsSelected[ci], 
           Throw[MessageToConsole[TableAddColumn::mulcell]]];
           
        While[(* The cursor is in an inline cell. *)
              Cases[ci, a : ("InlineCellPosition" -> _), Infinity] =!= {}, 
              FrontEndExecute[{FrontEnd`FrontEndToken[nb, "ExpandSelection"]}]; 
              ci = CellInfo[nb]];
              
        style = ("Style" /. CellInfo[nb])[[1]]; 
        If[(* The cursor is not in a table cell. *)
           Not[StringMatchQ[style, Alternatives@@$AcceptableTableStyles]], 
           Throw[MessageToConsole[TableAddColumn::nottable]]];
           
        If[columnPosition === None, 
          If[OldNotebookRead[nb] =!= {}, 
             FrontEndExecute[{FrontEnd`FrontEndToken[nb, "MoveNext"]}]];
          FrontEndExecute[{FrontEnd`FrontEndToken[nb, "NewColumn"]}]];
          
        ExpandToCell[nb];
        re = OldNotebookRead[nb];
        re3 = re[[1, 1, 1]];
        dims = Dimensions[re3];
        
       If[columnPosition =!= None && columnPosition > dims[[2]] + 1, 
          Throw[MessageToConsole[TableAddColumn::insuffcols]]];
          
       tr = Transpose[re3];
       If[columnPosition === None, pos = Position[tr, {"\[Placeholder]" ..}]];
       If[columnPosition === None && Not@MatchQ[pos, {{_Integer}}], 
          Throw[MessageToConsole[TableAddColumn::rowerror]]];
          
       (* The following gives the matrix of the new table. *)
       newpart = If[columnPosition === None,
                    Transpose[tr /. {"\[Placeholder]" ..} -> Table[placeHolderObject, {dims[[1]]}]], 
                    Transpose[Insert[tr, Table[placeHolderObject, {dims[[1]]}], columnPosition]]];
                    
       (* This is the rewritten cell modulo any style(s). *)
       rewritten = Cell @@ Prepend[Cases[#, (Rule | RuleDelayed)[_, _]], #[[1]]] &[ReplacePart[re, newpart, {1, 1, 1}]];
       
       newstyle = If[tableStyle =!= Automatic, 
                     tableStyle, 
                     ToString[If[columnPosition === None, dims[[2]], dims[[2]] + 1]] <> "ColumnTableMod"];
                     
       (* If there is one or more "ModInfo" cells in the left column of the initial table we subtract one in the table's
          style if it is of the form DigitCharacter ~~ b__. *)
                     
       If[modinfo,
          func = StringReplace[#, LongestMatch[a : DigitCharacter ~~ b__] :> ToString[ToExpression[a] - 1] <> b] &; 
          If[MemberQ[MatchQ[#, Cell[_, x_ /; StringMatchQ[x, "ModInfo"], ___]] & /@ 
                                                                  (re3/."\[Placeholder]"->Sequence[])[[All, 1]], True] && 
             If[StringQ[newstyle], 
                StringMatchQ[newstyle , DigitCharacter ~~ __], 
                StringMatchQ[newstyle[[1]] , DigitCharacter ~~ __]], 
             newstyle = If[StringQ[newstyle], func[newstyle], MapAt[func, newstyle, 1]]]];
                     
       NotebookWrite[nb, Insert[rewritten, 
                                If[StringQ[newstyle], newstyle, ff[Sequence @@ newstyle]], 2] /. ff -> Sequence, All];
       posOfNewCol = If[columnPosition === None, pos[[1, 1]], columnPosition];
       
       keyfindstring = Cases[placeHolderObject, _String, {0, Infinity}][[1]];
       findstrings = Flatten[Cases[#, keyfindstring, {0, Infinity}] & /@ (If[StringQ[#], #, #[[1]]] & /@ 
                                                                                       Take[newpart[[1]], posOfNewCol])];
       SelectionMove[nb, Before, CellContents];
       NotebookFind[nb, #] & /@ findstrings]]


TableAddRow::noin = "There is no open input notebook.";
TableAddRow::betwcells = "The cursor is between cells or not inside an input notebook.";
TableAddRow::mulcell = "Multiple cells have been selected.";
TableAddRow::nottable = "The cursor is not in a table cell.";
TableAddRow::rowerror = "An error has occurred. Select any spurious placeholders, delete and then try a different selection/position for the cursor and click the Add Row button again.";
TableAddRow::notimpl = "An error has occurred. Select any spurious placeholders and delete. TableAddRow has not been implemented for a table with the structure you are working with for the given initial selection.";

SelectForAddedRow[nb_, n_, m_, firstElement_] := 
 (SelectionMove[nb, Before, CellContents]; 
  FrontEndExecute[{FrontEnd`FrontEndToken[nb, "MoveNext"]}]; 
  Do[FrontEndExecute[{FrontEnd`FrontEndToken[nb, "MoveNextLine"]}], {n}];
  Which[m === 1 && firstElement === "      ", 
        NotebookFind[nb, "      "], 
        m === 1 && firstElement =!= "      ", NotebookFind[nb, "XXXX"], 
        m > 1 && firstElement === "      ", 
        Do[NotebookFind[nb, "XXXX"], {m - 1}], 
        True, 
        Do[NotebookFind[nb, "XXXX"], {m}]])
        
RewriteAndReplacePlaceholders[nb_] := 
 Module[{formOfNewRow, re, pos, newTable, selpos, firstElement}, 
        formOfNewRow = Which[MatchQ[#, Cell[_, "ModInfo", ___]], Cell["      ", "ModInfo"], 
                             MatchQ[#, Cell[__]], ReplacePart[#, "XXXX", 1], 
                             True, "XXXX"] &; 
        ExpandToCell[nb];
        re = OldNotebookRead[nb];
        pos = Position[re[[1, 1, 1]], {"\[Placeholder]" ..}];
        If[Not[MatchQ[pos, {{n_Integer /; n > 0}}]], 
           MessageToConsole[TableAddRow::rowerror], 
           newTable = ReplacePart[re, 
                                  {1, 1, 1} -> ReplacePart[re[[1, 1, 1]], 
                                                         pos[[1, 1]] -> formOfNewRow /@ re[[1, 1, 1]][[pos[[1, 1]] - 1]]]];
           NotebookWrite[nb, newTable, All];
           selpos = If[FreeQ[newTable[[1, 1, 1]][[pos[[1, 1]]]], Cell[_, "ModInfo", ___]], 1, 2];
           firstElement = newTable[[1, 1, 1]][[pos[[1, 1]]]][[selpos]];
           SelectionMove[nb, Before, CellContents];
           FrontEndExecute[{FrontEnd`FrontEndToken[nb, "MoveNext"]}];
           Do[FrontEndExecute[{FrontEnd`FrontEndToken[nb, "MoveNextLine"]}], {pos[[1, 1]] - 1}];
           NotebookFind[nb, firstElement]]]
  
TableAddRow[] := 
 Module[{nb = InputNotebook[], ci, precp, r, cir, selpos, formOfNewRow, cp, style, re, dims, newTable, firstElement, newRow,
         pos, rowToEmulate, ReadElement, tk, mat, prepos, AddedRowInMiddleOfSpannedRow}, 
  Catch[If[(* There is no input notebook. *)
           nb === $Failed, 
           Throw[MessageToConsole[TableAddRow::noin]]];
           
        ci = CellInfo[nb];
        
        If[(* The cursor is between cells. *)
           ci === $Failed, 
           Throw[MessageToConsole[TableAddRow::betwcells]]];
           
        If[multipleCellBracketsSelected[ci], 
           Throw[MessageToConsole[TableAddRow::mulcell]]];
           
        If[(* The cursor is inside a ModInfo cell. *)
           ("Style" /. ci) === {"ModInfo"} && NotebookRead[nb] === {}, 
	   SelectionMove[nb, All, Cell]; 
           FrontEndExecute[{FrontEndToken[nb, "MoveNext"]}]];
           
        If[(* The cursor is selecting part of a ModInfo cell. *)
           tableStyleQ[ci] && MatchQ[NotebookRead[nb], Cell[_, "ModInfo", ___]], 
           FrontEndExecute[{FrontEndToken[nb, "MoveNext"]}]];
           
        formOfNewRow = Which[MatchQ[#, Cell[_, "ModInfo", ___] | TooltipBox[__]], 
                             Cell["      ", "ModInfo"], 
                             MatchQ[#, Cell[__]], 
                             ReplacePart[#, "XXXX", 1], 
                             True,
                             "XXXX"] &;

       If[Cases[ci, a : ("InlineCellPosition" -> _), Infinity] =!= {}, 
          Throw[While[(* The cursor is in an inline cell. *)
                 Cases[ci, a : ("InlineCellPosition" -> _), Infinity] =!= {}, 
                 FrontEndExecute[{FrontEnd`FrontEndToken[nb, "ExpandSelection"]}];
                 ci = CellInfo[nb]];
           style = ("Style" /. CellInfo[nb])[[1]];
	   If[(* The cursor is not in a table cell. *)
	      Not[StringMatchQ[style, Alternatives @@ $AcceptableTableStyles]], 
              Throw[MessageToConsole[TableAddRow::nottable]]];
           ReadElement = NotebookRead[nb]; 
           NotebookWrite[nb, "ToBeReplaced"]; 
           FrontEndExecute[{FrontEnd`FrontEndToken[nb, "NewRow"]}]; 
           ExpandToCell[nb];
           re = OldNotebookRead[nb] /. "ToBeReplaced" -> ReadElement;
           selpos = If[MemberQ[re[[1, 1, 1]][[All, 1]], Cell[_, "ModInfo", ___]], 2, 1];
           pos = Position[re[[1, 1, 1]], {"\[Placeholder]" ..}];
           rowToEmulate = re[[1, 1, 1]][[If[pos === {{1}}, 1, pos[[1, 1]] - 1]]];
           newRow = formOfNewRow /@ rowToEmulate;
           If[MatchQ[pos, {{_Integer}}],
              NotebookWrite[nb, 
                            re /. {"\[Placeholder]" ..} -> newRow, All];
              tk = Take[re[[1, 1, 1]], pos[[1, 1]] - 1];
              If[
   (* The table contains elements other than having form Cell[_String, ___] and _String in the rows above the added row. *)
                 MemberQ[tk[[All, If[MemberQ[tk[[All, 1]], Cell[_, "ModInfo", ___]], 2, 1]]], 
                         _?(Not[MatchQ[#, Cell[_String, ___] | _String]] &)], 
                 SelectionMove[nb, Before, CellContents];
                Do[NotebookFind[nb, "XXXX"], {Count[Map[Cases[#, _String, {0, Infinity}][[1]] &, tk, {2}], "XXXX", 2] + 1}], 
                 SelectForAddedRow[nb, pos[[1, 1]] - 1, selpos, If[MatchQ[#, Cell[__]], #[[1]], #] &[newRow[[1]]]]], 
              MessageToConsole[TableAddRow::rowerror]]]];
           
        style = ("Style" /. CellInfo[nb])[[1]]; 
        If[(* The cursor is not in a table cell. *)
           Not[StringMatchQ[style, Alternatives@@$AcceptableTableStyles]], 
           Throw[MessageToConsole[TableAddRow::nottable]]];
           
        re = OldNotebookRead[nb]; 
        If[re === {}, 
           FrontEndExecute[{FrontEnd`FrontEndToken[nb, "MoveNext"]}]; 
           ci = CellInfo[nb];
           If[(* The cursor had initially been to the right of an entire table. *)
              ci === $Failed, 
              SelectionMove[nb, Previous, Cell], 
              FrontEndExecute[{FrontEnd`FrontEndToken[nb, "MovePrevious"]}]]];
             
        (* Code to relocate cursor if to the left of first visible element of a table to right of ModInfo cell. *)
        
         If[re === {},
            precp = ("CursorPosition" /. CellInfo[nb]); 
            If[Not[precp === {"CellBracket"} || precp === {{0, 0}} || precp === {{1, 1}}], 
           FrontEndExecute[{FrontEndToken[nb, "MovePreviousWord"]}]; 
           FrontEndExecute[{FrontEndToken[nb, "SelectPreviousWord"]}]; 
           r = OldNotebookRead[nb];
           cir = CellInfo[nb];
           
           Which[MatchQ[r, BoxData[Cell[_, "ModInfo", ___]]], 
                 FrontEndExecute[{FrontEndToken[nb, "MovePrevious"]}],
                 
                 MatchQ[r, BoxData[GridBox[{{_, _}}]]], 
         Throw[FrontEndExecute[{FrontEndToken[nb, "MoveNext"]}]; 
               FrontEndExecute[{FrontEnd`FrontEndToken[nb, "NewRow"]}]; 
                       RewriteAndReplacePlaceholders[nb]],
                 
                 True,
                 FrontEndExecute[{FrontEndToken[nb, "MoveNext"]}];
                 If[("CursorPosition" /. CellInfo[nb]) =!= precp, 
                       FrontEndExecute[{FrontEndToken[nb, "MoveNextWord"]}]]]]];
                     
        If[(* Cursor was to the left of first upper left visible element of table before last section of code was run. *)
           StringMatchQ[("Style" /. ci)[[1]], Alternatives @@ $AcceptableTableStyles] && 
            Cases[cir, a : ("InlineCellPosition" -> _), Infinity] =!= {} && 
              Cases[cir, a : ("InlineCellPosition" -> _), Infinity] === {"InlineCellPosition" -> {2}}, 
           Throw[ExpandToCell[nb];
                 re = OldNotebookRead[nb];
                 mat = re[[1, 1, 1]];
                 dims = Dimensions[mat];
                 selpos = If[MemberQ[mat[[All, 1]], Cell[_, "ModInfo", ___]], 2, 1];
                 newTable = ReplacePart[re, Prepend[mat, formOfNewRow /@ mat[[1]]], {1, 1, 1}];
                 NotebookWrite[nb, newTable, All];
                 selpos = If[FreeQ[formOfNewRow /@ mat[[1]], Cell[_, "ModInfo", ___]], 1, 2];
                 firstElement = If[StringQ[#], #, #[[1]]] &[(formOfNewRow /@ mat[[1]])[[selpos]]];
                 SelectionMove[nb, Before, CellContents]; 
                 FrontEndExecute[{FrontEnd`FrontEndToken[nb, "MoveNext"]}]; 
                 NotebookFind[nb, firstElement]]];
                 
        If[(* Cursor was to the left of a visible element of table in left column but not upper left. *)
       StringMatchQ[("Style" /. ci)[[1]], Alternatives @@ $AcceptableTableStyles] && 
         Cases[cir, a : ("InlineCellPosition" -> _), Infinity] =!= {} && 
           MatchQ["InlineCellPosition" /. cir, {{0, n_Integer /; n =!= 2}} | {{n_Integer /; n =!= 2}}],
       Throw[FrontEndExecute[{FrontEnd`FrontEndToken[nb, "MoveNext"]}]; 
             FrontEndExecute[{FrontEnd`FrontEndToken[nb, "NewRow"]}];
             RewriteAndReplacePlaceholders[nb]]];
             
        cp = ("CursorPosition" /. CellInfo[nb]);
        If[cp === {"CellBracket"} || cp === {{0, 0}} || cp === {{1, 1}}, 
           Throw[If[cp =!= {"CellBracket"}, ExpandToCell[nb]];
                 re = OldNotebookRead[nb];
                 mat = re[[1, 1, 1]];
                 dims = Dimensions[mat];
                 selpos = If[MemberQ[mat[[All, 1]], Cell[_, "ModInfo", ___]], 2, 1];
                 newTable = ReplacePart[re, 
                                        If[cp === {{0, 0}} || cp === {{1, 1}}, 
                                           Prepend[mat, formOfNewRow /@ mat[[1]]], 
                                           Append[mat, formOfNewRow /@ mat[[-1]]]], 
                                        {1, 1, 1}];
                 NotebookWrite[nb, newTable, All];
                 firstElement = If[MatchQ[#, Cell[__]], #[[1]], #]&[(formOfNewRow /@ If[cp === {{0, 0}},
                                                                                mat[[1]],
                                                                                        mat[[-1]]])[[1]]];
                 If[cp === {{0, 0}} || cp === {{1, 1}},
                    SelectionMove[nb, Before, CellContents]; 
                    FrontEndExecute[{FrontEnd`FrontEndToken[nb, "MoveNext"]}];
                    If[firstElement === "      ", 
                       Do[NotebookFind[nb, "XXXX"], {selpos - 1}],
                       Do[NotebookFind[nb, "XXXX"], {selpos}]],
                    If[(* The table contains elements other than having form Cell[_String, ___] and _String *)
                       MemberQ[mat[[All, If[MemberQ[mat[[All, 1]], Cell[_, "ModInfo", ___]], 2, 1]]], 
                               _?(Not[MatchQ[#, Cell[_String, ___] | _String]] &)], 
                       SelectionMove[nb, Before, CellContents];
                       Do[NotebookFind[nb, "XXXX"], 
                          {Count[Map[Cases[#, _String, {0, Infinity}][[1]] &, mat, {2}], "XXXX", 2] + 1}], 
                       SelectForAddedRow[nb, dims[[1]], selpos, firstElement]]]]];
                       
        If[OldNotebookRead[nb] =!= {}, 
           FrontEndExecute[{FrontEnd`FrontEndToken[nb, "MoveNext"]}]];
           
        If[MatchQ[CellInfo[nb], 
           {{"InlineCellPosition" -> {_}, "Style" -> "ModInfo", "ContentData" -> TextData, "ContentDataForm" -> TextForm, 
         "Evaluating" -> False, "Rendering" -> False, "NeedsRendering" -> False, "CursorPosition" -> {0, 0}, __}}],
       FrontEndExecute[{FrontEnd`FrontEndToken[nb, "MovePrevious"]}];
       ci = CellInfo[nb];
       While[(*The cursor is in an inline cell.*)
             Cases[ci, a : ("InlineCellPosition" -> _), Infinity] =!= {}, 
             FrontEndExecute[{FrontEnd`FrontEndToken[nb, "ExpandSelection"]}];
             ci = CellInfo[nb]]; 
           FrontEndExecute[{FrontEnd`FrontEndToken[nb, "MovePrevious"]}]];
           
        FrontEndExecute[{FrontEnd`FrontEndToken[nb, "NewRow"]}];
        ExpandToCell[nb];
        re = OldNotebookRead[nb];
        selpos = If[MemberQ[re[[1, 1, 1]][[All, 1]], Cell[_, "ModInfo", ___]], 2, 1];
        prepos = Position[re[[1, 1, 1]], {"\[Placeholder]" ..}]; 
    AddedRowInMiddleOfSpannedRow = MatchQ[re[[1, 1, 1]], 
                                          {___, {__, "\[SpanFromLeft]"}, {"\[Placeholder]" ..}, {"", __}, ___}];
    If[MatchQ[prepos, {{_Integer}}], 
       pos = prepos[[1, 1]]; 
       rowToEmulate = If[AddedRowInMiddleOfSpannedRow, (* Get the first regular row above the spanning row if there is one to pattern the added row after. *)
                         i = pos - 2; 
                         While[i > 0 && MatchQ[re[[1, 1, 1, i]], {___, "\[SpanFromLeft]"} | {"", ___}], i--]; 
                         If[i > 0, 
                            re[[1, 1, 1, i]], 
                            Which[re[[2]] === "DefinitionBox" && Length[re[[1, 1, 1, 1]]] === 2, 
                                  {"XXXX", Cell["XXXX", "TableText"]}, 
                                  re[[2]] === "2ColumnTableMod" && MatchQ[re[[1, 1, 1]], 
                                                                          {{Cell[_, "ModInfo", ___], _, _} ..}], 
                                  {Cell["      ", "ModInfo"], "XXXX", Cell["XXXX", "TableText"]}, 
                                  True, 
                                  Throw[MessageToConsole[TableAddRow::notimpl]]]], 
                         re[[1, 1, 1]][[If[pos === 1, 1, pos - 1]]]];
       newRow = formOfNewRow /@ rowToEmulate;
       NotebookWrite[nb, 
        If[AddedRowInMiddleOfSpannedRow, 
           ReplacePart[re, {1, 1, 1} -> Insert[re[[1, 1, 1]] /. {"\[Placeholder]" ..} -> Sequence[], newRow, pos + 1]],
           re /. {"\[Placeholder]" ..} -> newRow], 
                     All];
       tk = Take[re[[1, 1, 1]], If[AddedRowInMiddleOfSpannedRow, pos, pos - 1]];
 If[(*The table contains elements other than having form Cell[_String,___] and _String in the rows above the added row.*)
        MemberQ[tk[[All, If[MemberQ[tk[[All, 1]], Cell[_, "ModInfo", ___]], 2, 1]]], 
                _?(Not[MatchQ[#, Cell[_String, ___] | _String]] &)], 
        SelectionMove[nb, Before, CellContents];
        Do[NotebookFind[nb, "XXXX"], 
           {Count[Map[Cases[#, _String, {0, Infinity}][[1]] &, tk, {2}], "XXXX", 2] + 1}], 
        SelectForAddedRow[nb, pos - 1, selpos, If[MatchQ[#, Cell[__]], #[[1]], #] &[newRow[[1]]]]], 
            MessageToConsole[TableAddRow::rowerror]]]]
        
        
TablePartDelete::noin = "There is no input notebook.";
TablePartDelete::stylesht = "There is no external stylesheet.";
TablePartDelete::betwcells = "The cursor is between cells or not inside an input notebook.";
TablePartDelete::mulcell = "Multiple cells have been selected.";
TablePartDelete::cellbrac = "A cell bracket is selected.";
TablePartDelete::nonempty = "A column, row, subgrid, complete element or subelement of a table must be selected.";
TablePartDelete::nottable = "The selection is a grid but not part of a recognizable table style.";

TablePartDelete[] := 
 Module[{nb = InputNotebook[], ci, styledef, re, stylesheetpath, re2, num}, 
        Catch[If[(* There is no input notebook. *)nb === $Failed, 
                 Throw[MessageToConsole[TablePartDelete::noin]]];
              ci = CellInfo[nb];
              styledef = Options[nb, StyleDefinitions]; 
              If[Not@MatchQ[styledef, {StyleDefinitions -> _, ___}], 
                 Throw[MessageToConsole[TablePartDelete::stylesht]]];
              If[(* The cursor is between cells. *)
                 ci === $Failed, 
                 Throw[MessageToConsole[TablePartDelete::betwcells]]];
              If[multipleCellBracketsSelected[ci], 
                 Throw[MessageToConsole[TablePartDelete::mulcell]]];
              If[("CursorPosition" /. ci) === {"CellBracket"}, 
                 Throw[MessageToConsole[TablePartDelete::cellbrac]]]; 
              If[Not@MatchQ[("CursorPosition" /. ci), {{___, a_Integer, b_Integer}} /; a =!= b], 
                 Throw[MessageToConsole[TablePartDelete::nonempty]]];
                 
              re = OldNotebookRead[nb];
              
        Which[MatchQ[re, _String | BoxData[_String]],
        
              NotebookDelete[nb],
              
              MatchQ[re, BoxData[GridBox[{{__} ..}, ___]]] && Not@tableStyleQ[ci],
              
              MessageToConsole[TablePartDelete::nottable],
              
              True,
                 
              Which[MatchQ[styledef, {StyleDefinitions -> Notebook[__], ___}],
              
                    SetOptions[nb, StyleDefinitions -> (styledef[[1, 2]] /. (Deletable -> _) -> (Deletable -> True))],
              
                    MatchQ[ styledef, {StyleDefinitions -> FrontEnd`FileName[{_}, _String, _]}],
                    
                    stylesheetpath = ToFileName["FileName" /. (NotebookInformation[("StyleDefinitions" /. NotebookInformation[nb])[[1]]])];
              
                    SetOptions[nb, 
                        StyleDefinitions -> 
                         Notebook[{Cell[StyleData[StyleDefinitions -> Cases[styledef, FrontEnd`FileName[{"Wolfram"}, __], Infinity][[1]]]], 
                                  Sequence @@ (Cases[Get[stylesheetpath], 
                                                     Cell[StyleData[__], ___, Deletable -> False, ___], 
                                                     Infinity] /. (Deletable -> _) -> (Deletable -> True))}]]];
             (* To pick up "ModInfo" cells. *)
             If[StringMatchQ[(num = StringReplace[("Style" /. ci)[[1]], a : NumberString ~~ __ :> a]), NumberString] &&
                 MatchQ[re, BoxData[GridBox[{{__} ..}, ___]]] && 
                  Length[re[[1, 1, 1]]] === ToExpression[num], 
           FrontEndExecute[{FrontEnd`FrontEndToken[nb, "SelectPrevious"]}];
           re2 = OldNotebookRead[nb];
           If[Not[MatchQ[re2,BoxData[GridBox[{{Cell[_String, "ModInfo"], __} ..}, ___]]]], 
              FrontEndTokenExecute["Undo"]]];
              NotebookDelete[nb]; 
              NotebookDelete[nb];
              SetOptions[nb, StyleDefinitions -> styledef[[1, 2]]]]]]
        
        
TableInlineCellsToggle::noin = "There is no input notebook.";
TableInlineCellsToggle::betwcells = "The cursor is between cells or not inside an input notebook.";
TableInlineCellsToggle::mulcell = "Multiple cells have been selected.";
TableInlineCellsToggle::cellbrac = "A cell bracket is selected. Instead select a subgrid of a table or table element.";
TableInlineCellsToggle::notgrid = "A subgrid of a table or table element must be selected.";
TableInlineCellsToggle::gridels = "One or more of the elements in the selected subgrid could not be reduced to simple text.";

Options[TableInlineCellsToggle] = {"InlineCellStyle" -> "TableText"};

TableInlineCellsToggle[opts___] := 
 Module[{nb = InputNotebook[], inlinestyle, ci, style, re, styledef, re1}, 
        inlinestyle = "InlineCellStyle" /. {opts} /. Options[TableInlineCellsToggle]; 
        Catch[If[(*There is no input notebook.*)
                 nb === $Failed, 
                 Throw[MessageToConsole[TableInlineCellsToggle::noin]]];
              ci = CellInfo[nb];
              If[(*The cursor is between cells.*)ci === $Failed, 
                 Throw[MessageToConsole[TableInlineCellsToggle::betwcells]]];
              If[multipleCellBracketsSelected[ci], 
                 Throw[MessageToConsole[TableInlineCellsToggle::mulcell]]]; 
              If[("CursorPosition" /. ci) === {"CellBracket"}, 
                 Throw[MessageToConsole[TableInlineCellsToggle::cellbrac]]];
              If[OldNotebookRead[nb] =!= {},
                 While[(*The cursor is in an inline cell.*)
                   Cases[ci, a : ("InlineCellPosition" -> _), Infinity] =!= {}, 
                   FrontEndExecute[{FrontEnd`FrontEndToken[nb, "ExpandSelection"]}];
                       ci = CellInfo[nb]]];
              style = ("Style" /. CellInfo[nb])[[1]];
          If[(*The cursor is not in a table cell.*)
             Not[StringMatchQ[style, Alternatives @@ $AcceptableTableStyles]], 
                 Throw[MessageToConsole[TableInlineCellsToggle::notgrid]]];
              re = OldNotebookRead[nb]; 
              If[re === {}, 
                 Throw[MessageToConsole[TableInlineCellsToggle::notgrid]]];
                 
              styledef = Options[nb, StyleDefinitions];
              SetOptions[nb, 
                     StyleDefinitions -> 
                         Notebook[{Cell[StyleData[StyleDefinitions -> Cases[styledef, FrontEnd`FileName[{"Wolfram"}, __], Infinity][[1]]]], 
                                   Cell[StyleData["ModInfo"], Deletable -> True], 
                                   Cell[StyleData["TableText"], Deletable -> True]}]];
                        
             If[MatchQ[re, BoxData[StyleBox[_String, __]]],
                    NotebookWrite[nb, BoxData[""], All]; (* Hack to strip the style box. *)
                    NotebookWrite[nb, BoxData[re[[1, 1]]], All],
               NotebookWrite[nb, 
                Which[
                  MatchQ[re, BoxData[Cell[_String, __]]],
                    BoxData[re[[1, 1]]],
                  MatchQ[re, BoxData[_String]],
                    BoxData[Cell[re[[1]], inlinestyle]],
                  MatchQ[re, BoxData[RowBox[{__String}]]],
                    BoxData[Cell[StringJoin @@ re[[1, 1]], inlinestyle]],
                  MatrixQ[re[[1, 1]], MatchQ[#, Cell[_String, __]] &], 
                    re /. GridBox[a_, b___] :> GridBox[Map[#[[1]] &, a, {2}], b], 
                  MatrixQ[re[[1, 1]], MatchQ[#, _String] &], 
                    re /. GridBox[a_, b___] :> GridBox[Map[Cell[#, inlinestyle] &, a, {2}], b],
                  MatrixQ[re[[1, 1]], MatchQ[#, _String | RowBox[{__String}]] &], 
                    re /. GridBox[a_, b___] :> GridBox[Map[Cell[StringJoin @@ #, "TableText"] &, a, {2}], b],
                  MatchQ[re, BoxData[GridBox[__]] | BoxData[RowBox[_]] | BoxData[Cell[__]]],
                  re1 = (((((((re /. ButtonBox[a_, __] :> a) /. StyleBox[a_, __] :> a) /. BoxData[a_String] :> a) /. 
                                 Cell[a_String, __] :> a) /. {RowBox[{a__String}] :> StringJoin[a], 
                                                              TextData[{a__String}] :> StringJoin[a]} /. 
                                 Cell[a_String, __] :> a) //. RowBox[{a__}] :> {a}) //. 
                                 BoxData[a_List] :> BoxData[Flatten[{a}]]) /. 
                                 BoxData[{a__String}] :> BoxData[StringJoin[a]]; 
          If[MatchQ[re1, BoxData[_String] | BoxData[GridBox[{{__String} ..}, ___]]], 
             If[re1 === BoxData[",etc."] || re1 === BoxData[", etc."], 
                BoxData[Cell[", etc.", inlinestyle]], 
                re1], 
                     Throw[MessageToConsole[TableInlineCellsToggle::gridels];
                           SetOptions[nb, StyleDefinitions -> styledef[[1, 2]]]]],
                  True,
                  Throw[MessageToConsole[TableInlineCellsToggle::gridels];
                        SetOptions[nb, StyleDefinitions -> styledef[[1, 2]]]]], 
                All]];
              SetOptions[nb, StyleDefinitions -> styledef[[1, 2]]]]]
              
                            
TableInlineCellsToggleUndo[] := FrontEndTokenExecute["Undo"]


TableSort::noin = "There is no open input notebook.";
TableSort::ince = "The cursor must be inside a table cell or selecting the cell bracket of a table cell.";
TableSort::notab = "The cursor must be inside a table cell.";
TableSort::intsm = "The number of columns in the table is < the integer in the argument of TableSort.";
TableSort::cellstruc = "The structure of the cell is unsuitable for sorting.";
TableSort::tabelem = "One or more of the table elements in the column TableSort is using to decide how to sort is unsupported by TableSort.";

TableSort[n_Integer?Positive, opts___]:= Module[{nb = InputNotebook[], ci, re, repart, modinfo, keycolumn, forms,
PlainStringForms, RowsWithNonQuotedSecondElement, RowsWithNonQuotedSecondElement2, RowsWithQuotedSecondElement,
RowsWithQuotedSecondElement2, newgrid, ce, cs}, 
    Catch[
    If[(* There is no open input notebook. *)
       nb === $Failed, Throw[MessageToConsole[TableSort::noin]]];
       
    ci = CellInfo[nb];
    
    If[(* The cursor was either not inside a notebook or not inside a cell or at a cell's bracket. *)
       ci === $Failed, Throw[MessageToConsole[TableSort::ince]]];
       
    ExpandToCell[nb];
    ci = CellInfo[nb];
    
    If[(* The cursor was not initially positioned inside or at the cell bracket of a cell with a table style. *)
       Not@MatchQ[ci, {{"Style" -> a_ /; MatchQ[a, {b_String /; StringMatchQ[b, Alternatives @@ $AcceptableTableStyles], __String}] || 
                                         StringMatchQ[a, Alternatives @@ $AcceptableTableStyles], __}}], 
       Throw[MessageToConsole[TableSort::notab]]];
       
    re = OldNotebookRead[nb];
    
    If[(* The cell does not have the correct structure. *)
       Not@MatchQ[re, Cell[BoxData[GridBox[_?MatrixQ, ___]], __]], Throw[MessageToConsole[TableSort::cellstruc]]];
       
    repart = re[[1, 1, 1]];
    modinfo = MemberQ[Transpose[repart][[1]], 
                    Cell[_, "ModInfo", ___] | TooltipBox[Cell[_, "ModInfo"], __] | TooltipBox[Cell[BoxData[TooltipBox[Cell[_, "ModInfo", __], _]]], ___] | Cell[BoxData[TooltipBox[Cell[_, "ModInfo"], _]]]];
    
    If[(* n is > the number of columns - 1 in the table if there is a column of "ModInfo"
          cells or otherwise > the number of columns in the table. *)
       n > If[modinfo, Dimensions[repart][[2]] - 1, Dimensions[repart][[2]]],
       Throw[MessageToConsole[TableSort::intsm]]];
       
    keycolumn = repart[[All, If[modinfo, n + 1, n]]]; 
    forms = {_String, (StyleBox | ButtonBox | Cell)[_String, __], 
             RowBox[{ButtonBox[_String, __] | _String, "[", ___, "]"}], StyleBox[RowBox[{"\"", _String, "\""}], __], 
             RowBox[{"{", RowBox[{_String, ",", __}], "}"}]};
             
    repart = If[Position[repart, {_, _, "\[SpanFromLeft]"}] =!= {}, 
                repart //. {a___, PatternSequence[x : {_, _, "\[SpanFromLeft]"}, y_], b___} :> {a, Join[x, y], b},
                repart];
                
    If[Not[And @@ (MatchQ[#, Alternatives @@ forms] & /@ keycolumn)], Throw[MessageToConsole[TableSort::tabelem]]];
    
    PlainStringForms = {x_String /; Not@StringMatchQ[x, "\"" ~~ __ ~~ "\""], 
                        StyleBox[x_String /; Not@StringMatchQ[x, "\"" ~~ __ ~~ "\""], __], 
                        ButtonBox[x_String /; Not@StringMatchQ[x, "\"" ~~ __ ~~ "\""], __], 
                        RowBox[{ButtonBox[x_String /; Not@StringMatchQ[x, "\"" ~~ __ ~~ "\""], __] | 
                                (x_String /; Not@StringMatchQ[x, "\"" ~~ __ ~~ "\""]), "[", ___, "]"}], 
                        RowBox[{"{", RowBox[{x_String /; Not@StringMatchQ[x, "\"" ~~ __ ~~ "\""], ",", __}], "}"}],
                        Cell[x_String /; Not@StringMatchQ[x, "\"" ~~ __ ~~ "\""], __]};
                        
RowsWithNonQuotedSecondElement = Cases[repart, x_ /; MatchQ[x[[If[modinfo, n + 1, n]]], Alternatives @@ PlainStringForms]]; 
        
   RowsWithNonQuotedSecondElement2 = MapAt[Switch[#, _String, {#, 1}, (StyleBox | ButtonBox | Cell)[_String, __], {#[[1]], 1}, 
                                                  RowBox[{_String, "[", ___, "]"}], {#[[1, 1]], 2}, 
                                                  RowBox[{ButtonBox[_String, __], "[", ___, "]"}], {#[[1, 1, 1]], 2}, 
                                                  RowBox[{"{", RowBox[{_String, ",", __}], "}"}], {#[[1, 2, 1, 1]], 3}, _, 
                                                  {#, 1}] &, #, If[modinfo, n + 1, n]] & /@ RowsWithNonQuotedSecondElement;
                                                  
   RowsWithQuotedSecondElement = Complement[repart, RowsWithNonQuotedSecondElement]; 
   
   RowsWithQuotedSecondElement2 = MapAt[Switch[#, _?(StringQ[#] && StringMatchQ[#, "\"" ~~ __ ~~ "\""] &), 
                                               {StringTake[#, {2, -2}], 1}, 
                                       (StyleBox | ButtonBox | Cell)[_?(StringQ[#] && StringMatchQ[#, "\"" ~~ __ ~~ "\""] &), __], 
                                               {StringTake[#[[1]], {2, -2}], 1}, 
                            RowBox[{ButtonBox[_?(StringQ[#] && StringMatchQ[#, "\"" ~~ __ ~~ "\""] &), __], "[", ___, "]"}], 
                                               {StringTake[#[[1, 1, 1]], {2, -2}], 2}, 
                             RowBox[{"{", RowBox[{_?(StringQ[#] && StringMatchQ[#, "\"" ~~ __ ~~ "\""] &), ",", __}], "}"}], 
                                               {StringTake[#[[1, 2, 1, 1]], {2, -2}], 3}, _, {#, 1}] &, #, 
                                               If[modinfo, n + 1, n]] & /@ RowsWithQuotedSecondElement;
                                               
   newgrid = Join[RowsWithNonQuotedSecondElement[[Ordering[RowsWithNonQuotedSecondElement2[[All, {If[modinfo, n + 1, n]}]], 
                                                  All, If[#1[[1]] === #2[[1]], 
                                                          OrderedQ[{#1[[1, 2]], #2[[1, 2]]}], 
                                                          OrderedQ[{#1[[1]], #2[[1]]}]] &]]], 
                  RowsWithQuotedSecondElement[[Ordering[RowsWithQuotedSecondElement2[[All, {If[modinfo, n + 1, n]}]], 
                                               All, If[#1[[1]] === #2[[1]], 
                                                       OrderedQ[{#1[[1, 2]], #2[[1, 2]]}], 
                                                    OrderedQ[{#1[[1]], #2[[1]]}]] &]]]] /. {a__, "\[SpanFromLeft]", b__} :> 
                                                                         Unevaluated[Sequence[{a, "\[SpanFromLeft]"}, {b}]];
   ce = If[MemberQ[re[[1, 1]], 
                   GridBoxBackground -> {"Columns" -> {{None}}, "Rows" -> {__}}], 
           If[(pos = Position[newgrid, {TooltipBox[Cell[_, "ModInfo", ___], {_, _}], __}]) =!= {}, 
              # /. (GridBoxBackground -> {a___, "Rows" -> b_, c___}) :> 
                     (GridBoxBackground -> {a, "Rows" -> ReplacePart[Table[None, {Length[repart]}], # -> RGBColor[0.85, 0.95, 1] & /@ pos[[1]]], c}),
              #], 
           #] &[ReplacePart[re, newgrid, {1, 1, 1}]];
   cs = Cases[ce, a : (Rule | RuleDelayed)[TaggingRules, _]];
   NotebookWrite[nb, 
                 If[cs === {}, 
                    Insert[ce, TaggingRules -> {"Alphabetized" -> True}, -1], 
                    ce /. h_[TaggingRules, k_[l__]] :> h[TaggingRules, Insert[DeleteCases[k[l], m : ("Alphabetized" -> _)], 
                                                                              "Alphabetized" -> True, -1]]], All]]]

TableSort[opts___] := TableSort[1, opts]

(**********************************************************************************************************************




Old TableSort:

TableSort[n_Integer?Positive, opts___]:= Module[{nb = InputNotebook[], ci, re, modinfo, repart, repart2, repart3}, 
    Catch[
    If[(* There is no open input notebook. *)
       nb === $Failed, Throw[MessageToConsole[TableSort::noin]]];
    ci = CellInfo[nb];
    If[(* The cursor was either not inside a notebook or not inside a cell or at a cell's bracket. *)
       ci === $Failed, Throw[MessageToConsole[TableSort::ince]]]; 
    ExpandToCell[nb];
    ci = CellInfo[nb];
    If[(* The cursor was not initially positioned inside or at the cell bracket of a cell with a table style. *)
       Not@MatchQ[ci, {{"Style" -> a_ /; StringMatchQ[a, Alternatives @@ $AcceptableTableStyles], __}}], 
       Throw[MessageToConsole[TableSort::notab]]];
    re = OldNotebookRead[nb];
    If[(* The cell does not have the correct structure. *)
       Not@MatchQ[re, Cell[BoxData[GridBox[_?MatrixQ, ___]], __]], Throw[MessageToConsole[TableSort::cellstruc]]];
    repart = re[[1, 1, 1]];
    modinfo = MemberQ[Transpose[repart][[1]], Cell[_, "ModInfo", ___]];
    If[(* n is > the number of columns - 1 in the table if there is a column of "ModInfo"
          cells or otherwise > the number of columns in the table. *)
       n > If[modinfo, Dimensions[repart][[2]] - 1, Dimensions[repart][[2]]],
       Throw[MessageToConsole[TableSort::intsm]]];
    repart = If[Position[repart, {_, _, "\[SpanFromLeft]"}] =!= {}, 
                repart //. {a___, PatternSequence[x : {_, _, "\[SpanFromLeft]"}, y_], b___} :> {a, Join[x, y], b},
                repart];
    (* Get the table of critical strings in the original subgrid.  *)  
    repart2 = Map[(cs = Cases[#, _String, {0, Infinity}];
                   Which[MatchQ[#, RowBox[{RowBox[{StyleBox[__], "[", StyleBox[__], "]"}], "[", 
                           (RowBox[{x_String /; StringMatchQ[x, "\"" ~~ __ ~~ "\""], "[", RowBox[_] | StyleBox[__], "]"}] | 
                            RowBox[{x_String /; StringMatchQ[x, "\"" ~~ __ ~~ "\""], "[", "]"}]), "]"}]],
                         Flatten[# /.{SubscriptBox[StyleBox[a_, _], b_] :> {a, b}, StyleBox[a_, _] :> a} //. 
                 RowBox[{a__}] :> {a} /. x_String /; StringMatchQ[x, "\"" ~~ __ ~~ "\""] :> 
                                                                           StringTake[x, {2, -2}] /. StyleBox[a_, _] :> a],
                         MatchQ[#, RowBox[{_, "[", __, "]", ___}]], 
                         cs[[1]], 
                         Head[#] === RowBox, 
                         cs[[2]],
                         StringQ@# && StringMatchQ[#, "\"\!*StyleBox[" ~~ __ ~~ ",*\""],
                         StringCases[#, "\"\!" ~~ __ ~~ "StyleBox[" ~~ a__ ~~ "," ~~ __ ~~ "\"" :> a][[1]], 
                         MatchQ[#, StyleBox[RowBox[{"\"", _String, "\""}], __]], 
                         #[[1, 1, 2]],
                         True, 
                         cs[[1]]]) &, 
                  repart, 
                  {2}];
    (* Reorder the rows of the matrix based on the nth or (n+1)st column and rewrite the table. *)
    repart3 = repart[[Ordering[repart2[[All, {If[modinfo, n+1, n]}]]]]] /.
                                       {a__, "\[SpanFromLeft]", b__} :> Unevaluated[Sequence[{a, "\[SpanFromLeft]"}, {b}]]; 
    NotebookWrite[nb, ReplacePart[re, repart3, {1, 1, 1}], All];
    setTaggingRulesOption[NotebookSelection[nb], "Alphabetized"->True]]]
    
    
    
***************************************************************************************************************************)


TableMerge::badmatch = "Cells without tables, more than two cells, or cells with GridBoxes of differing number of columns selected.";

TableMerge[] := Module[{ nb = InputNotebook[], cellsExp},
    cellsExp = NotebookRead[ nb];
    If[ MatchQ[ cellsExp, 
        {Cell[BoxData[GridBox[_,___]],___],
         Cell[BoxData[GridBox[_,___]],___]}],
      
      If[ MatchQ[ #, Cell[___]],
        NotebookWrite[ nb, #],
        MessageToConsole[ TableMerge::badmatch]] & [ 
          cellsExp /. { Cell[ BoxData[ GridBox[ a_List, gopts1___]], copts1___,(CellTags -> t1_)...],
                        Cell[ BoxData[ GridBox[ b_List, gopts2___]], copts2___,(CellTags -> t2_)...]} 
                        /; Dimensions[a][[2]] == Dimensions[b][[2]] :>
                           Cell[ BoxData[ GridBox[ Join[ a, b], gopts1]], 
                             Sequence[ copts1, CellTags -> Join[ Flatten @ {t1}, Flatten @ {t2}]]]],        
      MessageToConsole[ TableMerge::badmatch]]]



InsertOptions::noin = "There is no input notebook.";
InsertOptions::noobj = "There is no \"ObjectName\" cell in the input notebook.";
InsertOptions::noopts = "The symbol `1` has no options according to Options[`1`].";
InsertOptions::nooptcell = "An Options cell is not present in the input notebook.";
InsertOptions::uptodate = "The options are uptodate.";

(* wrapswitch switches the find setting for "Wraparound" between a and b. *)

wrapswitch[a_, b_] := 
 SetOptions[$FrontEnd, (Options[$FrontEnd, FindSettings] /. ("Wraparound" -> a) -> ("Wraparound" -> b))[[1]]]
 
(* writeOptions writes in an option cell together with cells corresponding to each element of the list of options opts
   as well as any existing examples that go with a particular option. *)

Options[writeOptions] = {"ReduceToName" -> True};

writeOptions[nb_, opts_, Opts___] := 
 Module[{reduce, optionCellsWithExamples, listedOptionsWithExamples, name}, 
        reduce = "ReduceToName" /. {Opts} /. Options[writeOptions];
        
        (* optionCellsWithExamples is a list of pairs consisting of option names together with a list of the option name
           cell together with any existing examples corresponding to that option.*)
        
        optionCellsWithExamples = Cases[OldNotebookRead[nb], 
                                        a:Cell[CellGroupData[{Cell[BoxData[_], "ExampleSubsection", ___], __}, _]] :> 
 {Cases[a, _String, Infinity][[1]], a}, Infinity];
     
  listedOptionsWithExamples = First /@ optionCellsWithExamples;
  
  (* We make a list of option cells corresponding to the new option list and then replace each by a cell group with the
     examples for that option if any exist. *)
  
  NotebookWrite[nb, Cell[CellGroupData[Prepend[Cell[BoxData[InterpretationBox[Cell[#, "ExampleSubsection"],
                                                                            ($Line = 0; Null)]], "ExampleSubsection"] & /@ 
  If[reduce, ToString[First[#]] & /@ opts, opts] /. a : Cell[BoxData[InterpretationBox[Cell[_, "ExampleSubsection", ___],
                                                                          ($Line = 0; Null)]], "ExampleSubsection", ___] :> 
  If[MemberQ[listedOptionsWithExamples, (name = Cases[a, _String, Infinity][[1]]; name)], 
     Cases[optionCellsWithExamples, b : {name, _} :> b[[2]]][[1]], a], 
     Cell[BoxData[InterpretationBox[Cell["Options", "ExampleSection"], ($Line = 0; Null)]], "ExampleSection"]], Open]] /. 
   {Cell[BoxData[InterpretationBox[Cell["XXXX", ___], ($Line = 0; Null)]], "ExampleSubsection", ___] -> Sequence[],
    Cell[BoxData[FormBox[InterpretationBox["XXXX", ($Line = 0; Null)], TraditionalForm]], 
         "ExampleSubsection", ___] -> Sequence[],
    Cell[BoxData[InterpretationBox[Cell[(BoxData | TextData)[ButtonBox["XXXX", __]], ___], ($Line = 0; Null)]], 
         "ExampleSubsection", ___] -> Sequence[]}, 
                All];
  SelectionMove[nb, Before, CellGroup]]
                 
InsertOptions[] := 
 Module[{nb = InputNotebook[], f, name, opts, nex, listedoptions},
  Catch[If[(* There is no input notebook. *)nb === $Failed, 
           Throw[MessageToConsole[InsertOptions::noin]]];
           
        (* We cannot assume the notebook has been saved so Get cannot be used. NotebookGet has had problems at times on
           certain notebooks even to the point of crashing 6.0 so instead we use the method that follows to examine the
           list of cells after the options section cell if any. *)
           
        SelectionMove[nb, Before, Notebook]; 
        f = NotebookFind[nb, "ObjectName", Next, CellStyle]; 
        If[f === $Failed, Throw[MessageToConsole[InsertOptions::noobj]]];
        
        name = OldNotebookRead[nb][[1]];
        
        If[(* The symbol has no options according to Options[symbol]. *)
           (opts = Options[ToExpression[name]]; opts) === {}, 
           Throw[MessageToConsole[InsertOptions::noopts, name]]]; 
           
        wrapswitch[True, False]; 
        nex = NotebookFind[nb, "ExampleSection", Next, CellStyle];
        If[nex === $Failed, 
           Throw[MessageToConsole[InsertOptions::nooptcell]; 
           wrapswitch[False, True]]];
           
        While[Not@MatchQ[OldNotebookRead[nb], Cell[BoxData[InterpretationBox[Cell["Options", "ExampleSection"], ___]], __]], 
              nex = NotebookFind[nb, "ExampleSection", Next, CellStyle]; 
              If[nex === $Failed, Throw[MessageToConsole[InsertOptions::nooptcell]; wrapswitch[False, True]]]];
              
        If[(* The options are not listed. *)(FrontEndExecute[{FrontEndToken[nb, "ExpandSelection"]}]; 
           Not[MatchQ[CellInfo[nb], {{"Style" -> "ExampleSection", __}, {"Style" -> "ExampleSubsection", __}, ___}]]),
           
          SelectionMove[nb, Before, Cell]; 
          NotebookFind[nb, "ExampleSection", Next, CellStyle];
          While[Not@MatchQ[OldNotebookRead[nb], 
                           Cell[BoxData[InterpretationBox[Cell["Options", "ExampleSection"], ___]], __]], 
                NotebookFind[nb, "ExampleSection", Next, CellStyle]]; 
          writeOptions[nb, opts]; 
          wrapswitch[False, True], 
          listedoptions = Cases[OldNotebookRead[nb], 
                               Cell[BoxData[InterpretationBox[Cell[BoxData[ButtonBox[a_, BaseStyle -> ("Link"|"FunctionLink")]], 
                                    "InlineFormula"], $Line = 0;]], "ExampleSubsection"] :> a, Infinity]; 
          If[listedoptions === (ToString[First[#]] & /@ opts), 
             Throw[MessageToConsole[InsertOptions::uptodate]; 
                   wrapswitch[False, True]], 
             writeOptions[nb, opts]; 
             wrapswitch[False, True]]]]]

                          
OptionsInspector::noin = "There is no input notebook.";
OptionsInspector::nosave = "The input notebook is not saved.";
OptionsInspector::noobj = "There is no \"ObjectName\" cell in the input notebook.";
OptionsInspector::set$LinkBase = "Set $LinkBase and then try again.";
OptionsInspector::nosymsfound = "The link base `1` appears to be incorrect for `2`. Reset $LinkBase and then try again.";
OptionsInspector::noopts = "The symbol `1` has no options according to Options[`1`] or the needed package to load is not specified in the input notebook's Context cell nor in the \"NeededPackages\" tagging rule.";
OptionsInspector::nooptcell = "An Options cell is not present in the input notebook.";
OptionsInspector::uptodate = "The options are up-to-date.";

OptionsInspector[] := 
 Module[{nb = InputNotebook[], nbName, file, f, name, g, tr, or, opts, nex, stringopts, oldre, listedoptions},
        Catch[If[(* There is no input notebook. *)
                 nb === $Failed, 
                 Throw[MessageToConsole[OptionsInspector::noin]]];
                 
              $frontend = $FrontEnd;
              nb = nb /. FrontEndObject[_] -> $frontend;
              nbName = If[(file = ("FileName" /. NotebookInformation[nb]); file) === "FileName", None, file[[2]]];
              
              If[nbName === None, Throw[MessageToConsole[OptionsInspector::nosave]]];
              
              If[MatchQ[(tr = getTaggingRulesOption[nb, "NeededPackages"]), {a_String /; StringMatchQ[a, __ ~~ "`"]}],
             Needs[tr[[1]]]];
                           
          If[Not@MatchQ[tr, {a_String /; StringMatchQ[a, __ ~~ "`"]}],
             If[NotebookFind[nb, "Context", All, CellLabel, AutoScroll -> False] =!= $Failed,
                If[MatchQ[(or = OldNotebookRead[nb]), 
                      Cell[a_String /; StringMatchQ[a, __ ~~ "`"], __]],
                       Needs[or[[1]]]]]];
                 
              SelectionMove[nb, Before, Notebook]; 
              f = NotebookFind[nb, "ObjectName", Next, CellStyle]; 
              If[f === $Failed, Throw[MessageToConsole[OptionsInspector::noobj]]]; 
              name = OldNotebookRead[nb][[1]];
              
              If[(g[name] /. g -> Context) === "Global`",
	      		         
	         If[StringMatchQ[DocumentationTools`$LinkBase, "" | Whitespace],
	      	    Throw[MessageToConsole[OptionsInspector::set$LinkBase]; SetSelectedNotebook[MessagesNotebook[]]]];
	      		      
	      	 Quiet[Needs[DocumentationTools`$LinkBase <> "`"]];
	      		         
	      	 If[(f[name] /. f -> Context) === "Global`", 
	      	     Throw[MessageToConsole[OptionsInspector::nosymsfound, DocumentationTools`$LinkBase, name]; 
		           SetSelectedNotebook[MessagesNotebook[]]]]];
                 
        Quiet[If[(* The symbol has no options according to Options[symbol] or symbol /. Options[$FrontEnd, symbol] or the
                    needed package to load is not specified in the input notebook. *)
                 (opts = Options[ToExpression[name]]; opts) === {},
                 opts = Options[$FrontEnd, ToExpression[name]];
                 If[opts === {}, Throw[MessageToConsole[OptionsInspector::noopts, name]]];
                 opts = (ToExpression[name] /. opts);
                 If[opts === {},
                    Throw[MessageToConsole[OptionsInspector::noopts, name]]]], All, {OptionsInspector::noopts}];
                    
              If[opts =!= {},
                 If[MatchQ[opts, {_ -> _}] && StringFreeQ[ToString[opts[[1, 1]]], "->"] && 
            StringMatchQ[ToString[opts[[1, 1]]], "*Box*"] && 
                    MatchQ[opts[[1, 2]], {(Rule | RuleDelayed)[_, _] ..}], 
                    opts = opts[[1, 2]]]];
                 
              wrapswitch[True, False]; 
              nex = NotebookFind[nb, "ExampleSection", Next, CellStyle];
              If[nex === $Failed, Throw[MessageToConsole[OptionsInspector::nooptcell]; wrapswitch[False, True]]];
              While[Not@MatchQ[OldNotebookRead[nb], 
                               Cell[BoxData[InterpretationBox[Cell["Options", "ExampleSection"], ___]], __]], 
                    nex = NotebookFind[nb, "ExampleSection", Next, CellStyle]; 
                    If[nex === $Failed, Throw[MessageToConsole[OptionsInspector::nooptcell]; wrapswitch[False, True]]]];
                    
              stringopts = If[StringQ[First@#], "\"" <> First@# <> "\"", ToString[First[#]]] & /@ opts; 
              If[(* The options are not listed. *)
                 (FrontEndExecute[{FrontEndToken[nb, "ExpandSelection"]}]; 
                 Not[MatchQ[CellInfo[nb], {{"Style" -> "ExampleSection", __}, {"Style" -> "ExampleSubsection", __}, ___}]]),
                 
                 SelectionMove[nb, Before, Cell]; 
                 NotebookFind[nb, "ExampleSection", Next, CellStyle];
                 While[Not@MatchQ[OldNotebookRead[nb], 
                                  Cell[BoxData[InterpretationBox[Cell["Options", "ExampleSection"], ___]], __]], 
                       NotebookFind[nb, "ExampleSection", Next, CellStyle]]; 
                 wrapswitch[False, True]; 
                 NotebookPut[SymbolOptions[nbName, name, Sort@stringopts, None, nb]],
                 
                 oldre = OldNotebookRead[nb];
                 listedoptions = Join[Cases[oldre, 
                                       a:Cell[BoxData[InterpretationBox[Cell[b : (_String | 
                                                         (BoxData | TextData)[ButtonBox[_String, 
                                                                              BaseStyle -> ("Link" | "FunctionLink")]]), 
                                                                 "InlineFormula" | "ExampleSubsection", ___], $Line = 0;]], 
                                    "InlineFormula" | "ExampleSubsection", ___] :> If[StringQ[b], b, b[[1, 1]]], Infinity],
                                      Cases[oldre, Cell[BoxData[FormBox[InterpretationBox[a_, ($Line = 0; Null)],   
                                                                        TraditionalForm]],   
                                                        "ExampleSubsection", ___] :> a, Infinity]]; 
                 If[Complement[stringopts, listedoptions] === {}, 
                    Throw[MessageToConsole[OptionsInspector::uptodate]; 
                          wrapswitch[False, True]], 
                    wrapswitch[False, True];
                    NotebookPut[SymbolOptions[nbName, name, Complement[stringopts, listedoptions], listedoptions, nb]]]]]]
                    
OmittedOptionsGrid[optionsForFunctionNotInNotebook_, nbtarget_] := 
 Module[{li}, li = optionsForFunctionNotInNotebook; 
  ToExpression["DynamicModule[" <> auxOptionsCreateTable["$", "False", Range[Length[optionsForFunctionNotInNotebook]]] <> 
  "," <> "Column[{Grid[" <> ToString[Table[StringReplace["{Checkbox[Dynamic[u,(u=#)&]]," <> "Style[" <> li[[i]] <> 
        ",11,FontFamily->\"Helvetica\", ShowStringCharacters -> True]," <> "\"" <> "                                              " <> "\"" <> "}", 
       "[u,(u" -> "[$" <> ToString[i] <> ",($" <> ToString[i]], {i, Length[optionsForFunctionNotInNotebook]}]] <> 
    ",ColumnAlignments->{Left,Left},ColumnSpacings->{1},ColumnBackgrounds->{GrayLevel[0.9]}]," <> "Grid[{#}, ##2]&[{" <> "Button[" <> 
    "\"" <> "Preview" <> "\"" <> ",PreviewOptionsToInsert[" <> ToString["$" <> # & /@ (ToString /@ 
        Range[Length[optionsForFunctionNotInNotebook]])] <> "],Method->" <> 
    "\"" <> "Queued" <> "\"" <> "],Button[" <> "\"" <> "Insert" <> "\"" <> ",InsertOptionsFromDialog[" <> 
    ToString["$" <> # & /@ (ToString /@ Range[Length[optionsForFunctionNotInNotebook]])] <> "],Method->" <> 
    "\"" <> "Queued" <> "\"" <> "],Button[" <> "\"" <> "Select All" <> "\"" <> ",CompoundExpression[" <> 
    If[Length[optionsForFunctionNotInNotebook] =!= 1, StringJoin[Riffle[# <> "=True" & /@ ("$" <> # & /@ (ToString /@ 
     Range[Length[optionsForFunctionNotInNotebook]])), ","]], "$1=True"] <> "],Method->" <> "\"" <> "Queued" <>
     "\"" <> "],Button[" <> "\"" <> "Refresh" <> "\"" <> ",RefreshOptionsInspectorDialog[],Method->" <> "\"" <> 
     "Queued" <> "\"" <> "],Button[" <> "\"" <> "Cancel" <> "\"" <> ",NotebookClose[EvaluationNotebook[]],Method->" <>
     "\"" <> "Queued" <> "\"" <> "]},ColumnSpacings->{.4,.4,.4,2}]" <> "},RowSpacings->3]" <> "]"]]
                    
SymbolOptions[nb_String, symbol_, optionsForFunctionNotInNotebook_?(VectorQ[#, StringQ[#] &] &), 
              listedoptions_?(VectorQ[#, StringQ[#] &] || # === None &), nbtarget_] := 
 Notebook[{Cell[TextData[{"Unlisted options for: ", StyleBox[nb, FontWeight -> Bold]}], 
                FontFamily -> "Helvetica", FontSize -> 12, CellMargins -> {{6, 5}, {4, 18}}], 
           Cell[TextData[{"The following options for ", 
                          StyleBox[symbol, FontWeight -> Bold], " are not in its notebook:"}], 
                FontFamily -> "Helvetica", FontSize -> 12, CellMargins -> {{6, 5}, {10, 5}}], 
           Cell[BoxData[ToBoxes[OmittedOptionsGrid[optionsForFunctionNotInNotebook, nbtarget]]],
                ShowStringCharacters->False]}, 
          Saveable -> False, 
          WindowSize -> {Fit, 300}, 
          WindowMargins -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
          WindowFrame -> "Palette", 
          WindowElements -> {"VerticalScrollBar"}, 
          WindowTitle -> "Function Options Inspector", 
          ShowCellBracket -> False, 
          Selectable -> False, 
          Editable -> False, 
          Deletable -> False, 
          Background -> GrayLevel[1], 
          WindowFrameElements -> {}, 
          TaggingRules -> {"ListedOptions" -> listedoptions, 
                           "OmittedOptions" -> optionsForFunctionNotInNotebook, 
                           "TargetNotebook" -> nbtarget}]
                           
PreviewOptionsToInsert::notebookclo = "The working notebook has closed.";
PreviewOptionsToInsert::nonecked = "One or more check boxes must be checked.";

PreviewOptionsToInsert[omittedOptsBooles_] := 
 Module[{nbe, tnb, omittedOpts, listedOpts}, 
  Catch[nbe = EvaluationNotebook[] /. FrontEndObject[_] -> $frontend; 
       tnb = getTaggingRulesOption[nbe, "TargetNotebook"];
       
       If[(*The working notebook was closed.*)
          Not@MemberQ[Notebooks[] /. FrontEndObject[_] -> $frontend, tnb /. FrontEndObject[_] -> $frontend], 
          Throw[MessageToConsole[PreviewOptionsToInsert::notebookclo]]];
          
       If[(* No check boxes have been checked. *)
          Count[omittedOptsBooles, True] === 0, 
          Throw[MessageToConsole[PreviewOptionsToInsert::nonecked]]];
          
       omittedOpts = getTaggingRulesOption[nbe, "OmittedOptions"]; 
       listedOpts = getTaggingRulesOption[nbe, "ListedOptions"];
       
       NotebookPut[Notebook[{Cell["", Selectable -> False, ShowCellBracket -> False, CellSize -> {Automatic, 1}],
                             Cell[BoxData[InterpretationBox[Cell["Options", "ExampleSection"], $Line = 0;]], 
                                         "ExampleSection"],
                             Cell[BoxData[InterpretationBox[Cell[#, "ExampleSubsection"],
                                                                             ($Line = 0; Null)]], "ExampleSubsection"] & /@ 
                                    Sort[Join[listedOpts /. "XXXX" -> Sequence[], Pick[omittedOpts, omittedOptsBooles]]], 
                             Cell["", Selectable -> False, ShowCellBracket -> False, CellSize -> {Automatic, 1}]}, 
                            WindowSize -> Fit,
                            StyleDefinitions ->
                              FrontEnd`FileName[{"Wolfram"}, "FunctionPageStyles.nb"],
                            ScreenStyleEnvironment -> "Brackets",
                            WindowMargins -> {{Automatic, Automatic}, {50, Automatic}}]]]]
                               
InsertOptionsFromDialog::nooptscked = "No additional options to add have been specified by checked checkboxes.";
InsertOptionsFromDialog::nbclosed = "The working notebook has been closed.";
InsertOptionsFromDialog::nooptcell = "An Options cell is not present in the input notebook.";

InsertOptionsFromDialog[booleList_] := 
 Module[{nbe, targetnotebook, optionsToInsert, listedoptions, nex},
 
        nbe = EvaluationNotebook[] /. FrontEndObject[_] -> $frontend;
        
        (*The notebook being worked on.*)
        targetnotebook = getTaggingRulesOption[nbe, "TargetNotebook"];
        
    (*Options to add to the "Options" section of the target notebook.*)
    optionsToInsert = Pick[getTaggingRulesOption[nbe, "OmittedOptions"], booleList];
    
    (*List of options from the target notebook.*)
    listedoptions = getTaggingRulesOption[nbe, "ListedOptions"];
        If[listedoptions === None, listedoptions = {}];
        
        Which[(* No checkboxes have been checked. *)
              optionsToInsert === {},
              
              MessageToConsole[InsertOptionsFromDialog::nooptscked],
              
              (* The notebook whose data was obtained for the options dialog has closed. *)
              Not[MemberQ[Notebooks[] /. FrontEndObject[_] -> $frontend, targetnotebook]],
              
              NotebookClose[EvaluationNotebook[]]; MessageToConsole[InsertOptionsFromDialog::nbclosed],
              
              (* The cursor is on the "Options" cell *)
              
              MatchQ[CellInfo[targetnotebook], {{"Style" -> "ExampleSection", __}}] && 
               MatchQ[OldNotebookRead[targetnotebook], 
                      Cell[BoxData[InterpretationBox[Cell["Options", "ExampleSection"], ___]], __]],
                      
              If[(* Option cells are not present. *)
                 (FrontEndExecute[{FrontEndToken[targetnotebook, "ExpandSelection"]}]; 
                 Not[MatchQ[CellInfo[targetnotebook], {{"Style" -> "ExampleSection", __}, 
                                                       {"Style" -> "ExampleSubsection", __}, ___}]]),
                                                       
                 SelectionMove[targetnotebook, Before, Cell]; 
                 NotebookFind[targetnotebook, "ExampleSection", Next, CellStyle];
                 While[Not@MatchQ[OldNotebookRead[targetnotebook], 
                                  Cell[BoxData[InterpretationBox[Cell["Options", "ExampleSection"], ___]], __]],
                                  
                       NotebookFind[targetnotebook, "ExampleSection", Next, CellStyle]]];
                       
              writeOptions[targetnotebook, Union[listedoptions, optionsToInsert], "ReduceToName" -> False]; 
              wrapswitch[False, True],
              
              (* An "Options" cell and one or more options cells are selected. *)
              MatchQ[CellInfo[targetnotebook], {{"Style" -> "ExampleSection", __}, __}] &&
               MatchQ[OldNotebookRead[targetnotebook], 
                      Cell[CellGroupData[{Cell[BoxData[InterpretationBox[Cell["Options", "ExampleSection"], _]], 
                           "ExampleSection"], __}, _]]],
                           
              SelectionMove[targetnotebook, Before, Cell]; 
              NotebookFind[targetnotebook, "ExampleSection", Next, CellStyle]; 
              FrontEndExecute[{FrontEndToken[targetnotebook, "ExpandSelection"]}]; 
              writeOptions[targetnotebook, Union[listedoptions, optionsToInsert], "ReduceToName" -> False];
              wrapswitch[False, True],
              
              (* The cursor is present elsewhere in the target notebook. *)
              
              True,
              
              SelectionMove[targetnotebook, Before, Notebook]; 
              wrapswitch[True, False]; 
              nex = NotebookFind[targetnotebook, "ExampleSection", Next, CellStyle];
              If[nex === $Failed, Throw[MessageToConsole[InsertOptionsFromDialog::nooptcell]; 
                                        wrapswitch[False, True]]];
              While[Not@MatchQ[OldNotebookRead[targetnotebook], 
                               Cell[BoxData[InterpretationBox[Cell["Options", "ExampleSection"], ___]], __]], 
                    nex = NotebookFind[targetnotebook, "ExampleSection", Next, CellStyle]; 
                   If[nex === $Failed, Throw[MessageToConsole[InsertOptionsFromDialog::nooptcell]; 
                                             wrapswitch[False, True]]]];
                                             
              If[(* Option cells are not present in the selection. *)
                 (FrontEndExecute[{FrontEndToken[targetnotebook, "ExpandSelection"]}]; 
                  Not[MatchQ[CellInfo[targetnotebook], {{"Style" -> "ExampleSection", __}, 
                                                        {"Style" -> "ExampleSubsection", __}, ___}]]), 
                 SelectionMove[targetnotebook, Before, Cell]; 
                 NotebookFind[targetnotebook, "ExampleSection", Next, CellStyle];
                 
                 (* Find the "Options cell. *)
                 While[Not@MatchQ[OldNotebookRead[targetnotebook], 
                                  Cell[BoxData[InterpretationBox[Cell["Options", "ExampleSection"], ___]], __]], 
                       NotebookFind[targetnotebook, "ExampleSection", Next, CellStyle]]];
                       
              writeOptions[targetnotebook, Union[listedoptions, optionsToInsert], "ReduceToName" -> False]; 
              wrapswitch[False, True]]]
              
              
RefreshOptionsInspectorDialog::noin = "There is no input notebook.";
RefreshOptionsInspectorDialog::nosave = "The input notebook is not saved.";
RefreshOptionsInspectorDialog::nooptcell = "The working notebook is missing an \"ObjectName\" cell.";
RefreshOptionsInspectorDialog::set$LinkBase = "Set $LinkBase and then try again.";
RefreshOptionsInspectorDialog::nosymsfound = "The link base `1` appears to be incorrect for `2`. Reset $LinkBase and then try again.";
RefreshOptionsInspectorDialog::noopts = "The symbol `1` has no options according to Options[`1`].";
RefreshOptionsInspectorDialog::optsuptodate = "The options list in the input notebook is up-to-date.";

RefreshOptionsInspectorDialog[] := 
 Module[{nb = NextNotebook[], file, nbName, tr, or, f, opts, symbol, g, nex, listedoptions, nbe, optionsForFunctionNotInNotebook},
 
  Catch[If[(* There is no input notebook. *) nb === None, 
           Throw[MessageToConsole[RefreshOptionsInspectorDialog::noin]]];
           
        nb = nb /. FrontEndObject[_] -> $frontend; 
        nbName = If[(file = ("FileName" /. NotebookInformation[nb]); file) === "FileName", None, file[[2]]];
        
        If[nbName === None, Throw[MessageToConsole[RefreshOptionsInspectorDialog::nosave]]];
        
        If[MatchQ[(tr = getTaggingRulesOption[nb, "NeededPackages"]), {a_String /; StringMatchQ[a, __ ~~ "`"]}],
       Needs[tr[[1]]]];
                               
    If[Not@MatchQ[tr, {a_String /; StringMatchQ[a, __ ~~ "`"]}],
           If[NotebookFind[nb, "Context", All, CellLabel, AutoScroll -> False] =!= $Failed,
          If[MatchQ[(or = OldNotebookRead[nb]), 
                Cell[a_String /; StringMatchQ[a, __ ~~ "`"], __]],
                 Needs[or[[1]]]]]];
        
        SelectionMove[nb, Before, Notebook];
        f = NotebookFind[nb, "ObjectName", Next, CellStyle];
        
        If[f === $Failed, 
           Throw[MessageToConsole[RefreshOptionsInspectorDialog::noobj]], 
           symbol = OldNotebookRead[nb][[1]]];
           
        If[(g[symbol] /. g -> Context) === "Global`",
		         
           If[StringMatchQ[DocumentationTools`$LinkBase, "" | Whitespace],
	      Throw[MessageToConsole[RefreshOptionsInspectorDialog::set$LinkBase]; SetSelectedNotebook[MessagesNotebook[]]]];
		      
	      Quiet[Needs[DocumentationTools`$LinkBase <> "`"]];
		         
	      If[(g[name] /. g -> Context) === "Global`", 
		 Throw[MessageToConsole[RefreshOptionsInspectorDialog::nosymsfound, DocumentationTools`$LinkBase, symbol]; 
		       SetSelectedNotebook[MessagesNotebook[]]]]];
           
        If[(* The symbol has no options. *)
           (opts = Options[ToExpression[symbol]]; opts) === {}, 
           Throw[MessageToConsole[RefreshOptionsTableCreate::noopts, symbol]]];
           
        (* We next look for the "Options" cell. *)
        
        wrapswitch[True, False];
        nex = NotebookFind[nb, "ExampleSection", Next, CellStyle];
        If[nex === $Failed, Throw[MessageToConsole[RefreshOptionsInspectorDialog::nooptcell]; wrapswitch[False, True]]];
        
        While[(* We move through the "ExampleSection" cells until we find the "Options" cell or run out of "ExampleSection"
                 cells. *)
                 
              Not@MatchQ[OldNotebookRead[nb], Cell[BoxData[InterpretationBox[Cell["Options", "ExampleSection"], ___]], __]],
              
              nex = NotebookFind[nb, "ExampleSection", Next, CellStyle];
              If[nex === $Failed, Throw[MessageToConsole[RefreshOptionsInspectorDialog::nooptcell]; wrapswitch[False, True]]]];
              
        listedoptions = 
         If[(* The options are not listed. *)
            (FrontEndExecute[{FrontEndToken[nb, "ExpandSelection"]}];
             Not[MatchQ[CellInfo[nb], {{"Style" -> "ExampleSection", __}, {"Style" -> "ExampleSubsection", __}, ___}]]),
             
            (* Find the "Options" cell again. *)
            
            SelectionMove[nb, Before, Cell];
            NotebookFind[nb, "ExampleSection", Next, CellStyle];
            While[Not@MatchQ[OldNotebookRead[nb], Cell[BoxData[InterpretationBox[Cell["Options", 
                                                                                   "ExampleSection"], ___]], __]], 
                  NotebookFind[nb, "ExampleSection", Next, CellStyle]];
                  wrapswitch[False, True]; {},
                  
            Cases[OldNotebookRead[nb], a:Cell[_, "ExampleSubsection", ___] :> Cases[a, _String, Infinity][[1]], Infinity]];
            
        wrapswitch[False, True];
        nbe = EvaluationNotebook[] /. FrontEndObject[_] -> $frontend;
        optionsForFunctionNotInNotebook = Complement[ToString[First[#]] & /@ opts, listedoptions];
        If[optionsForFunctionNotInNotebook === {}, Throw[MessageToConsole[RefreshOptionsInspectorDialog::optsuptodate]]];
        SetOptions[nbe, Editable -> True, Deletable -> True]; 
        NotebookPut[SymbolOptions[nbName, symbol, optionsForFunctionNotInNotebook, listedoptions, nb] /. 
         (WindowMargins -> _) -> (WindowMargins -> (WindowMargins /. Options[nbe, WindowMargins])), nbe]]]
              

(* Code for the Options Table Creator: *)              
              
auxOptionsCreateTable[x_, y_, intlist_] := 
 StringReplace[ToString[x <> # & /@ (ToString /@ intlist)], x ~~ a : NumberString -> x ~~ a ~~ "=" <> y]
 
(* Given a symbol that is not predetermined we need to set up a DynamicModule with 2n local variables where n is the
   number of options that the symbol has. Since dynamics are difficult to hold unevaluated combined with the fact
   that the 2n variables must not have predefined values causes us to use the following method. If a fixed number
   of local variables were all that was needed, a simpler method would suffice. *)
   
(* The number 69 comes from "Style[{...},11,FontFamily->\"Helvetica\", ShowStringCharacters -> True]" which has
   string length 69. *)

OptionsCreateTableComponent[symbol_, nbtarget_] := 
 Module[{opts, li, li2, lopts, value, strprt, flag, sty, patt}, opts = Options[symbol];
        If[opts === {},
           opts = (symbol/.Options[$FrontEnd, symbol])];
        If[opts =!= {},
           If[MatchQ[opts, {_ -> _}] && StringFreeQ[ToString[opts[[1, 1]]], "->"] && 
               StringMatchQ[ToString[opts[[1, 1]]], "*Box*"] && MatchQ[opts[[1, 2]], {(Rule | RuleDelayed)[_, _] ..}],
             opts = opts[[1, 2]]];
           li = If[StringQ[First[#]], "\"" <> First[#] <> "\"", ToString[First[#]]] & /@ opts; 
           li2 = (((value = If[MatchQ[#, RuleDelayed[_, _]], 
                            StringReplace[ToString[#], __ ~~ ":> " ~~ a_ -> a], 
                            If[StringQ[Last[#]], 
                               "\"" <> Last[#]<> "\"", 
                               ToString[Last[#]]]];
                          If[StringLength[value] > 69, 
                             flag = 1; 
                             value = If[MatchQ[#[[2]], {(Rule | RuleDelayed)[_, _] ..}] && 
                                                       StringLength[(strprt = "{" ~~ ToString[#[[2, 1]]] ~~ ",...}")] <= 69, 
                                        strprt, 
                                        "{...}"]]; 
                          value) & /@ opts) /. x_String /; 
                                              StringMatchQ[x, " " ... ~~ __ ~~ "\n" ~~ "-" .. ~~ "\n" ~~ __ ~~ " " ...] :>
                          StringReplace[x, " " ... ~~ a__ ~~ "\n" ~~ "-" .. ~~ "\n" ~~ b__ ~~ " " ... :> a <> "/" <> b])/.
                          x_String /; StringMatchQ[x, "*\n"] :> StringDrop[x, -1];
           lopts = (Last /@ opts) /. x_String /; StringMatchQ[x, "*\n"] :> StringDrop[x, -1];
           If[ValueQ[flag], MessageToConsole[OptionsTableCreate::longval]];
           ToExpression["DynamicModule[" <> StringReplace[auxOptionsCreateTable["$", "False", Range[Length[opts]]] <> 
       auxOptionsCreateTable["$$", "\"\"", Range[Length[opts]]], "}{" -> ","] <> "," <> "Column[{Grid[" <> 
       ToString[Prepend[Table[StringReplace["{Checkbox[Dynamic[u,(u=#)&]]," <> "Style[" <> li[[i]] <> 
       ",11,FontFamily->\"Helvetica\", ShowStringCharacters -> True]" <> "," <> "\"" <> " " <> "\"" <> 
          "," <> (sty = "Style[" <> li2[[i]] <> ",11,FontFamily->\"Helvetica\", ShowStringCharacters -> True]"; 
                  patt = "Style[\"{" ~~ a__ ~~ "}\",11,FontFamily->\"Helvetica\", ShowStringCharacters -> True]";
                  Which[StringMatchQ[li2[[i]], 
"{" ~~ Except[","] .. ~~ " -> " ~~ (Except[","] | ("{" ~~ Except[","] .. ~~ ", " ~~ Except[","] .. ~~ "}")) .. ~~ ",...}"], 
 "Tooltip[" <> "Style[\"" ~~ li2[[i]] ~~ "\",11,FontFamily->\"Helvetica\"]" <> "," <> "TextCell[" <> "\"" <> ToString[lopts[[i]]] <> "\"" <> "]]",
                        StringMatchQ[sty, patt] && li2[[i]] =!= "\"{...}\"", 
                        StringReplace[sty, 
                                 patt :> "Style[{" ~~ a ~~ "},11,FontFamily->\"Helvetica\", ShowStringCharacters -> True]"],
                        True,
                     Which[StringMatchQ[sty, 
                                        "Style[{...},11,FontFamily->\"Helvetica\", ShowStringCharacters -> True]"],
"Tooltip[" <> "Style[\"{...}\",11,FontFamily->\"Helvetica\"]" <> "," <> "TextCell[" <> "\"" <> ToString[lopts[[i]]] <> "\"" <> "]]", 
                           StringMatchQ[sty, 
                                        "Style[{" ~~ __ ~~ "},11,FontFamily->\"Helvetica\", ShowStringCharacters -> True]"], 
                           StringReplace[sty, 
                                     "Style[{" ~~ a__ ~~ "},11,FontFamily->\"Helvetica\", ShowStringCharacters -> True]" :> 
                                         "Style[\"{" ~~ a ~~ "}\",11,FontFamily->\"Helvetica\"]"], 
                           True, 
                           sty]]) <> 
          ",InputField[Dynamic[w,(w=#)&],String,FieldSize->{30,{1,Infinity}}," <> 
          "BaseStyle->{FontFamily->" <> "\"" <> "Helvetica" <> "\"" <> 
          ",FontSize->10}" <> "]}", {"[u,(u" -> "[$" <> ToString[i] <> ",($" <> ToString[i], 
 "[w,(w" -> "[$$" <> ToString[i] <> ",($$" <> ToString[i]}], {i, Length[opts]}], 
       "{\"\",Style[\"Option Name\",11,Bold,FontFamily->\"Helvetica\"]," <> 
       "\"\",Style[\"Default Value\",11,Bold,FontFamily->\"Helvetica\"]," <>
       "Style[\"Descriptive Text\",11,Bold,FontFamily->\"Helvetica\"]}"]] <> 
       ",ColumnAlignments->{Left,Left,Left,Left,Center},
   ColumnBackgrounds->{GrayLevel[0.7],GrayLevel[0.7],GrayLevel[0.7],GrayLevel[0.75],GrayLevel[0.85]},GridFrame->True]," <>
  "Grid[{#}, ##2]&[{"<>"Button[" <> "\"" <> "Preview" <> "\"" <> ",PreviewOptionsTable[" <> ToString[nbtarget] <> "," <> 
    ToString[symbol] <> "," <> ToString["$" <> # & /@ (ToString /@ Range[Length[opts]])] <> 
      "," <> ToString["$$" <> # & /@ (ToString /@ Range[Length[opts]])] <> 
      "],Method->" <> "\"" <> "Queued" <> "\"" <> "],Button[" <> "\"" <> "Insert" <> "\"" <> ",InsertOptionsTable[" <> 
      ToString[nbtarget] <> "," <> ToString[symbol] <>
      "," <> ToString["$" <> # & /@ (ToString /@ Range[Length[opts]])] <> 
      "," <> ToString["$$" <> # & /@ (ToString /@ Range[Length[opts]])] <> 
      "],Method->" <> "\"" <> "Queued" <> "\"" <> "],Button[" <> "\"" <> 
      "Select All" <> "\"" <> ",CompoundExpression[" <> 
     If[Length[opts] =!= 1, StringJoin[Riffle[# <> "=True" & /@ ("$" <> # & /@ (ToString /@ Range[Length[opts]])), 
       ","]], "$1=True"] <> "],Method->" <> "\"" <> "Queued" <> "\"" <> "],Button[" <> "\"" <> "Refresh" <> "\"" <> 
    ",RefreshOptionsTableCreate[],Method->" <> "\"" <> "Queued" <> "\"" <>
     "],Button[" <> "\"" <> "Cancel" <> "\"" <> 
    ",NotebookClose[EvaluationNotebook[]],Method->" <> "\"" <> "Queued" <> 
    "\"" <> "]},ColumnSpacings->{.4,.4,.4,10}]" <> "},RowSpacings->3]" <> "]"]]]
     
(* We use the notebook $rowboxnb to have the FrontEnd construct row boxes as needed for option values. *)

FunctionLinkButton[ contents_, fldata_] :=
ButtonBox[ contents, BaseStyle -> "Link", ##] & @@
  Replace[ fldata, {
    None -> {},
    s_String :> {ButtonData -> s},
    _ -> {}
  }]

auxCorrespondingOptionsTable[x_] := 
 Module[{re}, 
        Which[StringQ[x] && StringMatchQ[x, (LetterCharacter ..)], 
              "\"" ~~ x ~~ "\"",
              FunctionLinkableQ[ToString@x],
              FunctionLinkButton[ #, FunctionLinkData[ #]] & @ ToString @ x,
              StringMatchQ[ToString@x, NumberString | (LetterCharacter ..)], 
              ToString@x, 
              True, 
              If[Not[MemberQ[Notebooks[], $rowboxnb]], 
                 $rowboxnb = NotebookPut[Notebook[{Cell[BoxData[ToString[x, FormatType -> InputForm]], "Input"]},
                                                  Visible -> False]]; 
                FrontEndExecute[{FrontEndToken[$rowboxnb, "SelectAll"]}], 
                FrontEndExecute[{FrontEndToken[$rowboxnb, "SelectAll"]}]; 
                NotebookWrite[$rowboxnb, 
                              Cell[BoxData[ToString[x, FormatType -> InputForm]], "Input"], All]]; 
                re = OldNotebookRead[$rowboxnb]; 
                If[MatchQ[re, Cell[BoxData[RowBox[_]], _]], 
                   re[[1, 1]], 
                   ToString[x, FormatType -> InputForm]]]]
                   
(* Links are constructed in tables for symbols for which FunctionLinkableQ gives True. *)

CorrespondingOptionsTable[optionsrulelist_, commentlist_] :=
Module[{ma, spl}, 
       ma = MapThread[{Cell["      ", "ModInfo"], auxCorrespondingOptionsTable[#1], auxCorrespondingOptionsTable[#2], 
                       spl = StringSplit[StringReplace[#3, a:" ".. -> " "], " "]; 
                       If[MemberQ[spl, _?FunctionLinkableQ], 
                          Cell[TextData[If[Length[spl] > 1,
                                           Riffle[If[FunctionLinkableQ[#], 
                                                     Cell[BoxData[ FunctionLinkButton[ #, FunctionLinkData[#] ] ], 
                                                          "InlineFormula"], #] & /@ spl, " "],
                                           {Cell[BoxData[ButtonBox[#3, BaseStyle -> "Link"]], 
                                                 "InlineFormula"]}]], "TableText"], 
                          Cell[StringReplace[#3, a:" ".. -> " "], "TableText"]]} &, 
                      Transpose[Flatten[#, 1] & /@ Transpose[{List @@ # & /@ (If[MatchQ[#, RuleDelayed[_, _]], 
ToExpression[StringReplace[ToString[#], a__ ~~ ":> " ~~ b__ :> a ~~ ":> " ~~ b]], #] & /@ optionsrulelist), 
                                                              commentlist}]]]; 
       NotebookClose[$rowboxnb]; Clear[$rowboxnb]; 
       Cell[BoxData[GridBox[ma]], "3ColumnTableMod"]]
       
       
PreviewOptionsTable::notebookclo = "The working notebook has closed.";
PreviewOptionsTable::nonecked = "One or more check boxes must be checked.";

PreviewOptionsTable[nb_, symbol_, checkboxvaluelist_, optiondescriptionlist_] :=
 Module[{options, commentlist, optionstouse},
        Catch[If[(* The notebook was closed. *)
                 Not@MemberQ[Notebooks[] /. FrontEndObject[_] -> $frontend, nb /. FrontEndObject[_] -> $frontend], 
                 Throw[MessageToConsole[PreviewOptionsTable::notebookclo]]];
                 
              If[Count[checkboxvaluelist, True] === 0, 
                 Throw[MessageToConsole[PreviewOptionsTable::nonecked]]];
                 
              options = Options[symbol];
              If[options === {}, 
                 options = (symbol/.Options[$FrontEnd, symbol]),
                 If[MatchQ[options, {_ -> _}] && StringFreeQ[ToString[options[[1, 1]]], "->"] && 
            StringMatchQ[ToString[options[[1, 1]]], "*Box*"] && 
            MatchQ[options[[1, 2]], {(Rule | RuleDelayed)[_, _] ..}],
                    options = options[[1, 2]]]];
              commentlist = Pick[optiondescriptionlist, checkboxvaluelist] /. 
                                                                  x_String :> If[StringMatchQ[x, "" | " " ..], "XXXX", x]; 
              optionstouse = Pick[options, checkboxvaluelist]; 
              NotebookPut[Notebook[{Cell["", Selectable -> False, ShowCellBracket -> False, CellSize -> {Automatic, 1}],
                                    CorrespondingOptionsTable[optionstouse, commentlist],
                                    Cell["", Selectable -> False, ShowCellBracket -> False, CellSize -> {Automatic, 1}]},
                                   WindowSize -> Fit,
                                   StyleDefinitions ->
                                    FrontEnd`FileName[{"Wolfram"}, "FunctionPageStyles.nb"],
                                   ScreenStyleEnvironment -> "Brackets",
                                   WindowMargins -> {{Automatic, Automatic}, {50, Automatic}}]]]]
     
      
InsertOptionsTable::notebookclo = "The working notebook has closed.";
InsertOptionsTable::pos = "The cursor must be positioned between cells.";
InsertOptionsTable::nonecked = "One or more check boxes must be checked.";

InsertOptionsTable[nb_, symbol_, checkboxvaluelist_, optiondescriptionlist_] :=
   Module[{options, commentlist, optionstouse},
          Catch[If[(* The notebook was closed. *)
                   Not@MemberQ[Notebooks[] /. FrontEndObject[_] -> $frontend, 
                               nb /. FrontEndObject[_] -> $frontend], 
                   Throw[MessageToConsole[InsertOptionsTable::notebookclo]]];
                   
                If[CellInfo[nb] =!= $Failed, 
                   Throw[MessageToConsole[InsertOptionsTable::pos]]];
                   
                If[Count[checkboxvaluelist, True] === 0, 
                   Throw[MessageToConsole[InsertOptionsTable::nonecked]]];
                   
                options = Options[symbol];
                If[options === {}, 
                 options = (symbol/.Options[$FrontEnd, symbol]),
                 If[MatchQ[options, {_ -> _}] && StringFreeQ[ToString[options[[1, 1]]], "->"] && 
                    StringMatchQ[ToString[options[[1, 1]]], "*Box*"] && 
                    MatchQ[options[[1, 2]], {(Rule | RuleDelayed)[_, _] ..}],
                    options = options[[1, 2]]]];
                
   commentlist = Pick[optiondescriptionlist, checkboxvaluelist] /. x_String :> If[StringMatchQ[x, "" | " " ..], "XXXX", x]; 
               optionstouse = Pick[options, checkboxvaluelist];
               NotebookWrite[nb, CorrespondingOptionsTable[optionstouse, commentlist] /.
                {Cell[BoxData[ButtonBox["XXXX", BaseStyle -> "Link"]], "InlineFormula"] -> Cell["XXXX", "TableText"],
                 Cell[BoxData[ButtonBox[ToString@symbol, __]], "InlineFormula"]->Cell[BoxData[ToString@symbol], "InlineFormula"]}]]]
               

RefreshOptionsTableCreate::noin = "There is no input notebook.";
RefreshOptionsTableCreate::notsaved = "The working notebook is not saved.";
RefreshOptionsTableCreate::pos = "The cursor must be positioned between cells.";
RefreshOptionsTableCreate::notnotessection = "The cursor must be positioned between cells and inside the Notes section of a reference page.";
RefreshOptionsTableCreate::objnmnonstan = "The \"ObjectName\" cell has a nonstandard structure.";
RefreshOptionsTableCreate::dialognotcre = "An error occurred while trying to create the options dialog corresponding to `1`.";
RefreshOptionsTableCreate::set$LinkBase = "Set $LinkBase and then try again.";
RefreshOptionsTableCreate::nosymsfound = "The link base `1` appears to be incorrect for `2`. Reset $LinkBase and then try again.";
RefreshOptionsTableCreate::noobjnm = "The working notebook is missing an \"ObjectName\" cell.";
RefreshOptionsTableCreate::noopts = "The symbol `1` has no options according to Options[`1`].";
RefreshOptionsTableCreate::nosubopts = "The front end option `1` has no suboptions.";

RefreshOptionsTableCreate[] := 
 Module[{nb = NextNotebook[], file, ci, $bytecountthreshold, filepath, $SmallFile, SymbolPart, gt, symbol, dialog, nbe, tr, or, g, cs, tt, opts, contcell},
 
        Catch[If[(*There is no input notebook.*)nb === None, 
                 Throw[MessageToConsole[RefreshOptionsTableCreate::noin]]];
                 
              nb = nb /. FrontEndObject[_] -> $frontend;
              
              If[(file = ("FileName" /. NotebookInformation[nb]); file) === "FileName", 
                 Throw[MessageToConsole[RefreshOptionsTableCreate::notsaved]]];
                 
              (* Test that the cursor is between cells. *)
	                        
	      If[CellInfo[nb /. FrontEndObject[_] -> $frontend] =!= $Failed, 
                 Throw[MessageToConsole[RefreshOptionsTableCreate::pos]]];
                 
              (* By looking at the style of the previous cell is any we can determine if we are in a Notes section. *)
	                        
	      FrontEndExecute[{FrontEnd`SelectionMove[nb, Previous, Cell, AutoScroll -> False]}];
	                     
	      ci = CellInfo[nb /. FrontEndObject[_] -> $frontend];
	                     
	      FrontEndExecute[{FrontEnd`SelectionMove[nb, After, Cell, AutoScroll -> False]}];
	                     
	      If[ci === $Failed || Intersection[Take[#, 1] &@Flatten["Style" /. ci], 
	                                                       {"Notes", "1ColumnTableMod", "2ColumnTableMod", "3ColumnTableMod", "Usage"}] === {},
                 Throw[MessageToConsole[RefreshOptionsTableCreate::notnotessection]]];
                 
               (* Will use Get on small and medium notebooks as determined by FileByteCount being below $bytecountthreshold. *)
               
               $bytecountthreshold = 4000000;
	                         
	       filepath = ToFileName[file];
	       
	       $SmallFile = If[FileByteCount[filepath] < $bytecountthreshold, gt = Get[filepath]; True, False];
                  
               SymbolPart := Which[MatchQ[#, Cell[_String, "ObjectName", ___]], 
                                   #[[1]], 
                                  MatchQ[#, Cell[TextData[{_String, StyleBox[__]}], "ObjectName", ___]], 
                                  StringReplace[#[[1, 1, 1]], (StartOfString ~~ Whitespace) | (Whitespace ~~ EndOfString) -> ""], 
                                  True, 
                                  Throw[MessageToConsole[OptionsTableCreate::objnmnonstan]]] &;
               
               (* When the file is not too large we look for two critical cells in the notebook expression. Getting the nb expr for moderately sized
                  notebooks is sufficiently fast then. Otherwise we write a temporary cell to return to the initial position in the notebook later and do
                  some NotebookFinds and to get info from two critical cells. *)
               
               If[If[$SmallFile,
                     (cs = Cases[gt, 
                              Cell[_String, "ObjectName", ___] | Cell[TextData[{_String, StyleBox[__]}], "ObjectName", ___], Infinity]; cs) === {},
                     tt = timetag[];
                     NotebookWrite[nb, Cell["", "Notes", CellTags -> tt]];
                     If[(* The "ObjectName" cell cannot be found. *)
                        NotebookFind[nb, "ObjectName", All, CellStyle] === $Failed,
                        (* Go to the inserted empty cell and erase it. This properly relocates the cursor. *)
                        NotebookFind[nb, tt, All, CellTags];
                        NotebookDelete[nb];
                        True,
                        False]], 
                  Throw[MessageToConsole[OptionsTableCreate::noobjnm]], 
                  symbol = If[$SmallFile, SymbolPart[cs[[1]]], SymbolPart[NotebookRead[nb]]]];              
              
             Quiet[If[(* The symbol is not part of a package and has options. *)
                     Options[ToExpression[symbol]] =!= {} || Options[$FrontEnd, ToExpression[symbol]] =!= {},
                     If[Options[ToExpression[symbol]] === {} && Not@MatchQ[Options[$FrontEnd, symbol], {_ -> {((Rule | RuleDelayed)[_, _])..}}],
                        Throw[If[Not@$SmallFile, 
		                 NotebookFind[nb, tt, All, CellTags];
                                 NotebookDelete[nb]];
                              MessageToConsole[OptionsTableCreate::nosubopts, symbol]]];
                     dialog = OptionsTableDialog[file[[2]], FullForm[nb /. FrontEndObject[_] -> $frontend], ToExpression[symbol]] /. 
                                                                                      (WindowMargins -> _) -> (WindowMargins -> (WindowMargins /. opts));
                     If[Not@$SmallFile, 
		        NotebookFind[nb, tt, All, CellTags];
                        NotebookDelete[nb]];
		     If[Not@MemberQ[dialog, Cell[BoxData["$Failed"], ___], Infinity],
		        nbe = EvaluationNotebook[] /. FrontEndObject[_] -> $frontend;
			opts = Options[nbe, WindowMargins];
                        SetOptions[nbe, Editable -> True, Deletable -> True, Selectable -> True];
		        Throw[NotebookPut[dialog, nbe]],
		        Throw[MessageToConsole[OptionsTableCreate::dialognotcre, symbol]]]],
                  All, {OptionsTableCreate::noopts, OptionsTableCreate::nosubopts, OptionsTableCreate::pos}];
                  
               If[MatchQ[(tr = getTaggingRulesOption[nb, "NeededPackages"]), {a_String /; StringMatchQ[a, __ ~~ "`"]}], 
                  Needs[tr[[1]]]];
	       
	       If[Not@MatchQ[tr, {a_String /; StringMatchQ[a, __ ~~ "`"]}], 
	          If[If[$SmallFile, (contcell = 
	                Cases[gt, Cell[_, "Categorization", CellLabel -> "Context", ___], Infinity]) =!= {}, 
	                NotebookFind[nb, "Context", All, CellLabel, AutoScroll -> False] =!= $Failed], 
	             If[If[$SmallFile, 
	                   MatchQ[contcell, {Cell[a_String /; StringMatchQ[a, __ ~~ "`"], __]}], 
	                   MatchQ[(or = OldNotebookRead[nb]), Cell[a_String /; StringMatchQ[a, __ ~~ "`"], __]]], 
                        If[$SmallFile, Needs[contcell[[1, 1]]], Needs[or[[1]]]]]]];
	       
	       If[(g[symbol] /. g -> Context) === "Global`", 
	          If[StringMatchQ[DocumentationTools`$LinkBase, "" | Whitespace], 
	             Throw[If[Not[$SmallFile],
	                      NotebookFind[nb, tt, All, CellTags];
                              NotebookDelete[nb]];
	                   MessageToConsole[OptionsTableCreate::set$LinkBase]]];
	                   
	         Quiet[Needs[DocumentationTools`$LinkBase <> "`"]];
	         
	       If[(g[symbol] /. g -> Context) === "Global`", 
	          Throw[If[Not[$SmallFile],
	                   NotebookFind[nb, tt, All, CellTags];
                           NotebookDelete[nb]];
	                MessageToConsole[OptionsTableCreate::nosymsfound, DocumentationTools`$LinkBase, symbol]]]];

         Quiet[If[(* The symbol has no options. *)
                  Options[ToExpression[symbol]] === {} && Options[$FrontEnd, ToExpression[symbol]] === {},
                  Throw[MessageToConsole[OptionsTableCreate::noopts, symbol]]];
                  
               If[Options[ToExpression[symbol]] === {} && Not@MatchQ[Options[$FrontEnd, symbol], {_ -> {((Rule | RuleDelayed)[_, _])..}}],
                  Throw[MessageToConsole[OptionsTableCreate::nosubopts, symbol]]];
                  
               nbe = EvaluationNotebook[] /. FrontEndObject[_] -> $frontend;
               opts = Options[nbe, WindowMargins];
               SetOptions[nbe, Editable -> True, Deletable -> True, Selectable -> True]; 
               dialog = OptionsTableDialog[file[[2]], FullForm[nb /. FrontEndObject[_] -> $frontend], ToExpression[symbol]] /. 
                         (WindowMargins -> _) -> (WindowMargins -> (WindowMargins /. opts));
               If[Not@MemberQ[dialog, Cell[BoxData["$Failed"], ___], Infinity], 
                  NotebookPut[dialog, nbe];
                  MessageToConsole[OptionsTableCreate::dialognotcre, symbol]],
               All, {OptionsTableCreate::noopts, OptionsTableCreate::nosubopts, OptionsTableCreate::pos}]]]
              

OptionsTableCreate::noin = "There is no input notebook.";
OptionsTableCreate::notsaved = "The working notebook is not saved.";
OptionsTableCreate::noobjnm = "The working notebook is missing an \"ObjectName\" cell.";
OptionsTableCreate::set$LinkBase = "Set $LinkBase and then try again.";
OptionsTableCreate::nosymsfound = "The link base `1` appears to be incorrect for `2`. Reset $LinkBase and then try again.";
OptionsTableCreate::noopts = "The symbol `1` has no options according to Options[`1`].";
OptionsTableCreate::pos = "The cursor must be positioned between cells.";
OptionsTableCreate::notnotessection = "The cursor must be positioned between cells and inside the Notes section of a reference page.";
OptionsTableCreate::objnmnonstan = "The \"ObjectName\" cell has a nonstandard structure.";
OptionsTableCreate::longval = "One or more option values have a length of > 69 characters and will be replaced in the dialog by {...}.";
OptionsTableCreate::nosubopts = "The front end option `1` has no suboptions.";
OptionsTableCreate::dialognotcre = "An error occurred while trying to create the options dialog corresponding to `1`.";

(* Due to bug 60610 notebook objects are not correctly given by functions called from buttons with Method -> "Preemptive". 
   So we get the value which will be called $frontend from the button that calls OptionsTableCreate[] which will have
   Method -> "Queued". The button that needs Method -> "Preemptive" is in the Options table dialog and that button will
   call a function that will make use of the value of $frontend. *)
   
timetag[]:= StringJoin[ToString /@ (DateList[] /. {a__, b_} :> {a, Round[b]})]

OptionsTableCreate[] := 
  Module[{nb, file, ci, $bytecountthreshold, filepath, $SmallFile, SymbolPart, gt, symbol, dialog, contcell, tr, or, g, cs, tt},
         Catch[nb = InputNotebook[]; 
               $frontend = $FrontEnd; 
               nb = nb /. FrontEndObject[_] -> $frontend;
               
               If[(* There is no input notebook. *)
                  nb === $Failed, 
                  Throw[MessageToConsole[OptionsTableCreate::noin]]];
                  
               If[(file = ("FileName" /. NotebookInformation[nb]); file) === "FileName", 
                  Throw[MessageToConsole[OptionsTableCreate::notsaved]]];
                  
               (* Test that the cursor is between cells. *)
                  
               If[CellInfo[nb /. FrontEndObject[_] -> $frontend] =!= $Failed, 
                  Throw[MessageToConsole[OptionsTableCreate::pos]]];
                  
               (* By looking at the style of the previous cell is any we can determine if we are in a Notes section. *)
                  
               FrontEndExecute[{FrontEnd`SelectionMove[nb, Previous, Cell, AutoScroll -> False]}];
               
               ci = CellInfo[nb /. FrontEndObject[_] -> $frontend];
               
               FrontEndExecute[{FrontEnd`SelectionMove[nb, After, Cell, AutoScroll -> False]}];
               
               If[ci === $Failed || Intersection[Take[#, 1] &@Flatten["Style" /. ci], 
                                                 {"Notes", "1ColumnTableMod", "2ColumnTableMod", "3ColumnTableMod", "Usage"}] === {},
                  Throw[MessageToConsole[OptionsTableCreate::notnotessection]]];
                  
               (* Will use Get on small and medium notebooks as determined by FileByteCount being below $bytecountthreshold. *)
               
               $bytecountthreshold = 4000000;
	                         
	       filepath = ToFileName[file];
	       
	       $SmallFile = If[FileByteCount[filepath] < $bytecountthreshold, gt = Get[filepath]; True, False];
                  
               SymbolPart := Which[MatchQ[#, Cell[_String, "ObjectName", ___]], 
                                   #[[1]], 
                                  MatchQ[#, Cell[TextData[{_String, StyleBox[__]}], "ObjectName", ___]], 
                                  StringReplace[#[[1, 1, 1]], (StartOfString ~~ Whitespace) | (Whitespace ~~ EndOfString) -> ""], 
                                  True, 
                                  Throw[MessageToConsole[OptionsTableCreate::objnmnoncan]]] &;
               
               (* When the file is not too large we look for two critical cells in the notebook expression. Getting the nb expr for moderately sized
                  notebooks is sufficiently fast then. Otherwise we write a temporary cell to return to the initial position in the notebook later and do
                  some NotebookFinds and to get info from two critical cells. *)
               
               If[If[$SmallFile,
                     (cs = Cases[gt, 
                              Cell[_String, "ObjectName", ___] | Cell[TextData[{_String, StyleBox[__]}], "ObjectName", ___], Infinity]; cs) === {},
                     tt = timetag[];
                     NotebookWrite[nb, Cell["", "Notes", CellTags -> tt]];
                     If[(* The "ObjectName" cell cannot be found. *)
                        NotebookFind[nb, "ObjectName", All, CellStyle] === $Failed,
                        (* Go to the inserted empty cell and erase it. This properly relocates the cursor. *)
                        NotebookFind[nb, tt, All, CellTags];
                        NotebookDelete[nb];
                        True,
                        False]], 
                  Throw[MessageToConsole[OptionsTableCreate::noobjnm]], 
                  symbol = If[$SmallFile, SymbolPart[cs[[1]]], SymbolPart[NotebookRead[nb]]]];
                  
            Quiet[If[(* The symbol is not part of a package and has options. *)
                     Options[ToExpression[symbol]] =!= {} || Options[$FrontEnd, ToExpression[symbol]] =!= {},
                     If[Options[ToExpression[symbol]] === {} && Not@MatchQ[Options[$FrontEnd, symbol], {_ -> {((Rule | RuleDelayed)[_, _])..}}],
                        Throw[If[Not@$SmallFile, 
		                 NotebookFind[nb, tt, All, CellTags];
                                 NotebookDelete[nb]];
                              MessageToConsole[OptionsTableCreate::nosubopts, symbol]]];
                     dialog = OptionsTableDialog[file[[2]], FullForm[nb /. FrontEndObject[_] -> $frontend], ToExpression[symbol]];
                     If[Not@$SmallFile, 
		        NotebookFind[nb, tt, All, CellTags];
                        NotebookDelete[nb]];
		     If[Not@MemberQ[dialog, Cell[BoxData["$Failed"], ___], Infinity], 
		        Throw[NotebookPut@dialog],
		        Throw[MessageToConsole[OptionsTableCreate::dialognotcre, symbol]]]],
                  All, {OptionsTableCreate::noopts, OptionsTableCreate::nosubopts, OptionsTableCreate::pos}];
                  
               If[MatchQ[(tr = getTaggingRulesOption[nb, "NeededPackages"]), {a_String /; StringMatchQ[a, __ ~~ "`"]}], 
                  Needs[tr[[1]]]];
	       
	       If[Not@MatchQ[tr, {a_String /; StringMatchQ[a, __ ~~ "`"]}], 
	          If[If[$SmallFile, (contcell = 
	                Cases[gt, Cell[_, "Categorization", CellLabel -> "Context", ___], Infinity]) =!= {}, 
	                NotebookFind[nb, "Context", All, CellLabel, AutoScroll -> False] =!= $Failed], 
	             If[If[$SmallFile, 
	                   MatchQ[contcell, {Cell[a_String /; StringMatchQ[a, __ ~~ "`"], __]}], 
	                   MatchQ[(or = OldNotebookRead[nb]), Cell[a_String /; StringMatchQ[a, __ ~~ "`"], __]]], 
                        If[$SmallFile, Needs[contcell[[1, 1]]], Needs[or[[1]]]]]]];
	       
	       If[(g[symbol] /. g -> Context) === "Global`", 
	          If[StringMatchQ[DocumentationTools`$LinkBase, "" | Whitespace], 
	             Throw[If[Not[$SmallFile],
	                      NotebookFind[nb, tt, All, CellTags];
                              NotebookDelete[nb]];
	                   MessageToConsole[OptionsTableCreate::set$LinkBase]]];
	                   
	         Quiet[Needs[DocumentationTools`$LinkBase <> "`"]];
	         
	       If[(g[symbol] /. g -> Context) === "Global`", 
	          Throw[If[Not[$SmallFile],
	                   NotebookFind[nb, tt, All, CellTags];
                           NotebookDelete[nb]];
	                MessageToConsole[OptionsTableCreate::nosymsfound, DocumentationTools`$LinkBase, symbol]]]];
                  
         Quiet[If[(* The symbol has no options. *)
                  Options[ToExpression[symbol]] === {} && Options[$FrontEnd, ToExpression[symbol]] === {},
                  Throw[MessageToConsole[OptionsTableCreate::noopts, symbol]]];
                  
               If[Options[ToExpression[symbol]] === {} && Not@MatchQ[Options[$FrontEnd, symbol], {_ -> {((Rule | RuleDelayed)[_, _])..}}],
                  Throw[MessageToConsole[OptionsTableCreate::nosubopts, symbol]]];
                  
               dialog = OptionsTableDialog[file[[2]], FullForm[nb /. FrontEndObject[_] -> $frontend], ToExpression[symbol]];
               If[Not@MemberQ[dialog, Cell[BoxData["$Failed"], ___], Infinity], 
                  NotebookPut@dialog,
                  Throw[MessageToConsole[OptionsTableCreate::dialognotcre, symbol]]],
               All, {OptionsTableCreate::noopts, OptionsTableCreate::nosubopts, OptionsTableCreate::pos}]]]
                                                 
OptionsTableDialog[nb_String, nbtarget_, symbol_] := 
 Notebook[{Cell[TextData[{"Create an options table for: ", 
                          StyleBox[nb, FontWeight -> Bold]}], 
                FontFamily -> "Helvetica", 
                FontSize -> 12,
                CellMargins -> {{16, 5}, {4, 18}}], 
           Cell["Click on the check boxes and add a description for each option\n that you want to appear in the table:", 
                FontFamily -> "Helvetica", 
                FontSize -> 12, 
                CellMargins -> {{16, 5}, {10, 5}}], 
           Cell[BoxData[ToBoxes[OptionsCreateTableComponent[ToExpression@symbol, nbtarget]]],
                ShowStringCharacters->False]}, 
          Saveable -> False, 
          WindowSize -> {Fit, 300}, 
          WindowMargins -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
          WindowFrame -> "Palette", 
          WindowElements -> {"VerticalScrollBar"}, 
          ShowCellBracket -> False, 
          Selectable -> False, 
          Editable -> False, 
          Deletable -> False, 
          Background -> GrayLevel[1], 
          WindowFrameElements -> {}, 
          WindowTitle -> "Options Table Creator"]
          
          
(* Code for the Templates Inspector. *)

SyntaxTemplatesInspector::noin = "There is no input notebook.";
SyntaxTemplatesInspector::notsaved = "The working notebook is not saved.";
SyntaxTemplatesInspector::resaved = "The working notebook must be resaved.";
SyntaxTemplatesInspector::nobjnm = "There is no \"ObjectName\" cell in the input notebook.";
SyntaxTemplatesInspector::none = "There are no syntax templates present.";

SyntaxTemplatesInspector[] := 
 Module[{nb = InputNotebook[], gt, ni, file, cs, name, additionalTemplates, inlineFormulasInUsageCell,
         inlineFormulasInNotesCells}, 
         
  Catch[If[(* There is no input notebook. *)
           nb === $Failed, 
           Throw[MessageToConsole[SyntaxTemplatesInspector::noin]]];
           
        (* This function must be called from a button with Method -> "Queued" at present to get $FrontEnd correct. *)
        $frontend = $FrontEnd; 
        nb = nb /. FrontEndObject[_] -> $frontend; 
        ni = NotebookInformation[nb];
        
        If[(file = ("FileName" /. ni); file) === "FileName", 
           Throw[MessageToConsole[SyntaxTemplatesInspector::notsaved]]];
           
        If[("ModifiedInMemory" /. ni), 
           Throw[MessageToConsole[SyntaxTemplatesInspector::resaved]]];
           
        gt = Get[ToFileName[file]]; 
        If[(cs = Cases[gt, a : Cell[_, "ObjectName", ___] :> a[[1]], Infinity]; cs === {}), 
           Throw[MessageToConsole[SyntaxTemplatesInspector::nobjnm]]];
          
        name = cs[[1]]; 
        additionalTemplates = Flatten[Cases[gt, a:Cell[CellGroupData[{Cell["Syntax Templates", 
                                                                           "TemplatesSection", ___], __}, _]] :> 
                         Cases[a, Cell[_, "Template", CellLabel -> "Additional Function Template"], Infinity], Infinity]]; 
        additionalTemplates = If[MatchQ[additionalTemplates, 
                                        {Cell[BoxData[""], "Template", CellLabel -> "Additional Function Template"] ..}], 
                                 {}, 
                                 additionalTemplates];
                                 
        inlineFormulasInUsageCell = Flatten[Cases[gt, a:Cell[_, "Usage", ___] :> 
                             Cases[a, Cell[BoxData[RowBox[{name, "[", __}]], "InlineFormula", ___], Infinity], Infinity]];
                             
        inlineFormulasInNotesCells = Flatten[Cases[gt, a:Cell[_, "Notes", ___] :> 
                             Cases[a, Cell[BoxData[RowBox[{name, "[", __}]], "InlineFormula", ___], Infinity], Infinity]];
                             
        If[additionalTemplates === {} && inlineFormulasInUsageCell === {} && inlineFormulasInNotesCells === {}, 
           MessageToConsole[SyntaxTemplatesInspector::none]; 
           NotebookPut[TemplatesInspector[file[[2]], nb, additionalTemplates, inlineFormulasInUsageCell, 
                                                                                             inlineFormulasInNotesCells]], 
           NotebookPut[TemplatesInspector[name, file[[2]], nb, additionalTemplates, inlineFormulasInUsageCell, 
                                                                                           inlineFormulasInNotesCells]]]]]
                                                                                           
oppositeCheck[tagopt_, pos_, value_] := 
 Module[{nb = EvaluationNotebook[]}, 
        nb = nb /. FrontEndObject[_] -> $frontend; 
        SetOptions[nb, Editable -> True]; 
        setTaggingRulesOption[nb, tagopt -> ReplacePart[getTaggingRulesOption[nb, tagopt], pos -> value]]; 
        SetOptions[nb, Editable -> False]]
        
AddTemplateField[] := 
 Module[{nbe = EvaluationNotebook[]}, 
        NotebookFind[nbe, "TemplatesToAdd", All, CellTags]; 
        SelectionMove[nbe, After, Cell]; 
        NotebookWrite[nbe, Cell[BoxData[InputFieldBox["", String, FieldSize -> {{40, 40}, {4, 1.`}}]],
                                "Text", CellTags -> "TemplatesToAdd", CellMargins -> {{7, 3}, {2, 2}}], 
                      All]]
                      
TemplatesInspector[name_String, nbname_String, nb_, additionalTemplates_, inlineFormulasInUsageCell_, inlineFormulasInNotesCells_] := 
 Notebook[{Cell[TextData[{"Syntax templates for ", StyleBox[nbname, FontWeight -> Bold]}],
                "Text", CellMargins -> {{7, 5}, {10, 5}}, FontFamily -> "Helvetica", FontSize -> 12],
                
           Cell["Click on the check boxes to include or exclude inline formulas from\nconsideration as syntax templates. You may also add templates to\nthe Syntax Templates section of the working notebook.", 
                FontFamily -> "Helvetica", 
                FontSize -> 12, CellMargins -> {{7, 5}, {10, 5}}],
                
           If[additionalTemplates =!= {}, 
              Unevaluated[Sequence[Cell["Additional templates:", FontFamily -> "Helvetica", FontSize -> 12], 
                                   Cell[
                                    BoxData[
                                     RowBox[{ToBoxes[
                                              Column[
                                               Function[r, 
                                                DynamicModule[{u = True}, 
                                                 Checkbox[Dynamic[u, (u = #; 
                                                                      If[u, 
                                                                         oppositeCheck["AdditionalTemplates:", r, True], 
                                                                 oppositeCheck["AdditionalTemplates", r, False]]) &]]]] /@ 
                                                                                        Range[Length[additionalTemplates]], 
                                            RowSpacings -> 1.5]], 
                                               GridBox[List /@ additionalTemplates, ColumnAlignments -> Left, 
                                                       RowSpacings -> 1.5]}]], 
                                        Background -> GrayLevel[0.9]],
                                        
           Cell[BoxData[InputFieldBox["", String, FieldSize -> {{40, 40}, {4, 1.`}}]], "Text",
                CellTags -> "TemplatesToAdd", CellMargins -> {{7, 3}, {2, 2}}], 
           Cell[BoxData[ButtonBox["Add a template field", Appearance -> "DialogBox", 
                                  ButtonFrame -> "DialogBox", ButtonFunction :> AddTemplateField[], 
                                  Evaluator -> Automatic, Method -> "Preemptive"]], 
                "Text", CellMargins -> {{7, 3}, {18, 4}}]]],
                
           Unevaluated[Sequence[Cell["Additional templates", FontFamily -> "Helvetica", FontSize -> 12], 
                                Cell[BoxData[InputFieldBox["", String, FieldSize -> {{40, 40}, {4, 1.`}}]], "Text",
                                     CellTags -> "TemplatesToAdd", CellMargins -> {{7, 3}, {2, 2}}], 
                                Cell[BoxData[ButtonBox["Add a template field", Appearance -> "DialogBox", 
                                                       ButtonFrame -> "DialogBox", ButtonFunction :> AddTemplateField[], 
                                                       Evaluator -> Automatic, Method -> "Preemptive"]], 
                                     "Text", CellMargins -> {{7, 3}, {18, 4}}]]]],
                                     
           If[inlineFormulasInUsageCell =!= {}, 
              Unevaluated[Sequence[Cell["Templates in the Usage cell:", FontFamily -> "Helvetica", FontSize -> 12], 
                                   Cell[
                                    BoxData[
                                     RowBox[{ToBoxes[
                                              Column[MapIndexed[Function[{r, s}, 
                                                                 DynamicModule[{u = If[MatchQ[r, 
                                                                      Cell[_, "InlineFormula", "TemplateExclusion", ___]], 
                                                                      False,
                                                                      True]}, 
                                                                  Checkbox[Dynamic[u, (u = #; 
                                                                   If[u, 
                                                                  oppositeCheck["InlineFormulasInUsageCell", s[[1]], True], oppositeCheck["InlineFormulasInUsageCell", s[[1]], 
                                                                   False]]) &]]]], 
                                                     inlineFormulasInUsageCell], 
                                            RowSpacings -> 1.5]], 
                                             GridBox[List /@ 
                                                         (inlineFormulasInUsageCell /. "TemplateExclusion" -> Sequence[]), 
                                                     ColumnAlignments -> Left, RowSpacings -> 1.5]}]], 
                                        CellMargins -> {{7, 3}, {18, 4}}, Background -> GrayLevel[0.9]]]], 
              Unevaluated[Sequence[]]],
              
            If[inlineFormulasInNotesCells =!= {}, 
               Unevaluated[Sequence[Cell["Templates in Notes cells:", FontFamily -> "Helvetica", FontSize -> 12], 
                                    Cell[BoxData[RowBox[{ToBoxes[
                                                          Column[MapIndexed[
                                                           Function[{r, s}, 
                                                            DynamicModule[{u = If[MatchQ[r, 
                                                                       Cell[_, "InlineFormula", "TemplateInclusion", ___]], 
                                                                       True, 
                                                                       False]}, 
                                                            Checkbox[Dynamic[u, (u = #; 
                                                           If[u, 
                                                              oppositeCheck["InlineFormulasInNotesCells", s[[1]], True], 
                                                        oppositeCheck["InlineFormulasInNotesCells", s[[1]], False]]) &]]]], 
                                                                            inlineFormulasInNotesCells], 
                                                                 RowSpacings -> 1.5]], 
                                                         GridBox[List /@ 
                                                         (inlineFormulasInNotesCells /. "TemplateInclusion" -> Sequence[]), 
                                                                 ColumnAlignments -> Left, RowSpacings -> 1.5]}]], 
                                         Background -> GrayLevel[0.9], CellMargins -> {{7, 3}, {18, 4}}]]], 
               Unevaluated[Sequence[]]],
               
           Cell[BoxData[ToBoxes[OldRow[{Button["Update Input Notebook", UpdateTemplatesInInputNotebook[], Method -> "Queued"], 
                                     Button["Refresh", RefreshTemplatesDialog[]], 
                                     Button["Cancel", NotebookClose[EvaluationNotebook[]], Method -> "Queued"]}, 
                                    ColumnSpacings -> {.8, 3}]]], 
                CellMargins -> {{8, 5}, {10, 12}}]}, 
    WindowSize -> {Fit, 300}, 
    WindowMargins -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
    WindowFrame -> "Palette", 
    Saveable -> False, 
    WindowElements -> {"VerticalScrollBar"}, 
    WindowTitle -> "Templates Inspector", 
    ShowCellBracket -> False, 
    Selectable -> False, 
    Editable -> False, 
    Deletable -> False, 
    Background -> GrayLevel[1], 
    WindowFrameElements -> {}, 
    TaggingRules -> {"AdditionalTemplates" -> Table[True, {Length[additionalTemplates]}], 
                     "InlineFormulasInUsageCell" -> If[Length[inlineFormulasInUsageCell] > 0, 
      If[MatchQ[#, Cell[_, "InlineFormula", "TemplateExclusion", ___]], False, True] & /@ inlineFormulasInUsageCell, {}], 
                     "InlineFormulasInNotesCells" -> If[Length[inlineFormulasInNotesCells] > 0, 
      If[MatchQ[#, Cell[_, "InlineFormula", "TemplateInclusion", ___]], True, False] & /@ inlineFormulasInNotesCells, {}], 
                     "TargetNotebook" -> nb,
                     "Symbol" -> name,
                     "CellList" -> {"AdditionalTemplates" -> additionalTemplates, 
                                    "InlineFormulasInUsageCell" -> inlineFormulasInUsageCell, 
                                    "InlineFormulasInNotesCells" -> inlineFormulasInNotesCells}}]
                                    
boxTemplateForm[x_] := 
 (If[Not[MemberQ[Notebooks[], $templatenb]], 
     $templatenb = (NotebookCreate[Visible -> False] /. FrontEndObject[_] -> $frontend), 
     FrontEndExecute[{FrontEndToken[$templatenb, "SelectAll"]}]; 
     NotebookDelete[$templatenb]]; 
  NotebookWrite[$templatenb, x]; 
  FrontEndExecute[{FrontEndToken[$templatenb, "SelectAll"]}]; 
  OldNotebookRead[$templatenb][[1]])
  
UpdateTemplatesInInputNotebook::nbclosed = "The working notebook has been closed.";
UpdateTemplatesInInputNotebook::malformed = "One or more of the additional templates in the dialog's input fields are malformed.";
UpdateTemplatesInInputNotebook::syssymtem = "A system symbol occurs at a location other than the head in one of the checked templates drawn from the working notebook.";
UpdateTemplatesInInputNotebook::syssym = "A system symbol occurs at a location other than the head in one of the templates in an input field.";
UpdateTemplatesInInputNotebook::templatefailure = "An error has occurred in attempting to make the master template.";

UpdateTemplatesInInputNotebook[] := 
 Module[{nbe = EvaluationNotebook[], nb, celllist, name, systemnames, at, u, n, allbooles, templatesToAdd, del, bts, piat,
         allTemplatesToUse, stpatt, templatecell, ucells, reusage, ucellsplain, pos, renotes, ncells, ncellsplain, pos2}, 
         
   Catch[(* The notebook being worked on. *)
         nb = getTaggingRulesOption[nbe, "TargetNotebook"]; 
         If[(*The notebook whose data was obtained for the templates dialog has closed.*)
            Not[MemberQ[Notebooks[], nb]], 
            Throw[MessageToConsole[UpdateTemplatesInInputNotebook::nbclosed]]];
            
         nbe = nbe /. FrontEndObject[_] -> $frontend; 
         celllist = getTaggingRulesOption[nbe, "CellList"];
         
         name = getTaggingRulesOption[nbe, "Symbol"];
         systemnames = Names["System`*"];
         
         at = getTaggingRulesOption[nbe, "AdditionalTemplates"];
     u = getTaggingRulesOption[nbe, "InlineFormulasInUsageCell"];
     n = getTaggingRulesOption[nbe, "InlineFormulasInNotesCells"];
         allbooles = Join[at, u, n];
         
         If[(* One of the templates drawn from the working notebook has a System symbol at a location other than the
               template's head. *)
            MemberQ[Flatten[Function[r, MemberQ[systemnames, #] & /@ 
                                                        Cases[r, _String, Infinity]] /@ (Take[#[[1, 1, 1]], {2, -1}] & /@ 
                    Pick[Flatten[Last /@ celllist], allbooles])], 
                    True],
            Throw[MessageToConsole[UpdateTemplatesInInputNotebook::syssymtem]]];
            
         NotebookFind[nbe, "TemplatesToAdd", All, CellTags, AutoScroll -> False]; 
         
         templatesToAdd = 
          If[(del = DeleteCases[If[MatchQ[#, Cell[__]], {#[[1, 1, 1]]}, #[[1, 1, 1]] & /@ #] &[OldNotebookRead[nbe]], 
                                 x_String /; StringMatchQ[x, "" | Whitespace]]; 
              del) =!= {}, 
              If[(* One or more of the additional templates in the dialog's input fields are malformed. *)
                 Union[StringMatchQ[#, name ~~ "[]"] ||
                 (StringMatchQ[#, name ~~ "[" ~~ __ ~~ "]"] && 
               StringFreeQ[FixedPoint[StringReplace[#, 
                  ShortestMatch["{" ~~ (a__ /; StringFreeQ[a, "{" | "}"]) ~~ "}"] -> ""] &, #], "{" | "}"] && 
               StringFreeQ[FixedPoint[StringReplace[#, 
                  ShortestMatch["[" ~~ (a__ /; StringFreeQ[a, "[" | "]"]) ~~ "]"] -> ""] &, #], "[" | "]"]) & /@ 
                                                                                                  del] =!= {True},
          Throw[MessageToConsole[UpdateTemplatesInInputNotebook::malformed]]];
              bts = Cell[boxTemplateForm[#], "Template", CellLabel -> "Additional Function Template"] & /@ del;
              If[MemberQ[Flatten[Function[r, MemberQ[systemnames, #] & /@ 
               Cases[r, _String, Infinity]] /@ (Take[#[[1, 1, 1]], {2, -1}] & /@ bts)], True],
             Throw[MessageToConsole[UpdateTemplatesInInputNotebook::syssym];NotebookClose[$templatenb]]];
              NotebookClose[$templatenb]; bts, 
             {}];
             
         piat = Pick["AdditionalTemplates" /. celllist, at];
         
         allTemplatesToUse = Union[piat, 
                                   templatesToAdd, 
                                   If[u =!= {},
                                  ucells = "InlineFormulasInUsageCell" /. celllist;
                                  ucellsplain = ucells /. "TemplateExclusion" -> Sequence[];
                                  Pick[ucellsplain, u], 
                                  {}], 
                               If[n =!= {},
                                  ncells = "InlineFormulasInNotesCells" /. celllist;
                                  ncellsplain = ncells /. "TemplateInclusion" -> Sequence[];
                                      Pick[ncellsplain, n], 
                                      {}]];
                                      
         If[allTemplatesToUse =!= {},
         
            Which[(stpatt = SyntaxTemplatesToSyntaxPattern[name -> allTemplatesToUse]; stpatt) === $Failed, 
              Throw[MessageToConsole[UpdateTemplatesInInputNotebook::templatefailure]],
              
              Not@MatchQ[stpatt, {_String, _List}], 
              Throw[MessageToConsole[UpdateTemplatesInInputNotebook::templatefailure]],
              
              True,
              
              templatecell = Cell[BoxData[ToBoxes[stpatt, StandardForm]], "Template", 
                                  CellLabel -> "Automatically Generated Master Argument Pattern"];
                                  
              If[NotebookFind[nb, "Automatically Generated Master Argument Pattern", All, CellLabel] === $Failed,
              
                 NotebookFind[nb, "TemplatesSection", All, CellStyle];
                 SelectionMove[nb, After, Cell];
                     NotebookWrite[nb, templatecell],
                     
                     NotebookWrite[nb, templatecell]];
                     
                  NotebookFind[nb, "Additional Function Template", All, CellLabel]],
                  
            If[NotebookFind[nb, "Automatically Generated Master Argument Pattern", All, CellLabel] =!= $Failed, 
               NotebookDelete[nb]];
            If[NotebookFind[nb, "Additional Function Template", All, CellLabel] === $Failed, 
               NotebookFind[nb, "TemplatesSection", All, CellStyle]; 
               SelectionMove[nb, After, Cell]]]; 
             
         If[Union[at, templatesToAdd] === {}, 
            NotebookWrite[nb, Cell[BoxData[""], "Template", CellLabel -> "Additional Function Template"], All],
            (* Update additional templates. *)
            
            If[piat === {} && templatesToAdd === {}, 
               NotebookWrite[nb, Cell[BoxData[""], "Template", CellLabel -> "Additional Function Template"], All], 
               NotebookWrite[nb, Union[piat, templatesToAdd], All]]];
               
         If[u =!= {},
            NotebookFind[nb, "Usage", All, CellStyle, AutoScroll -> False]; 
            reusage = OldNotebookRead[nb]; 
            (* Update Usage cell. *)
            NotebookWrite[nb, reusage /. If[(pos = Position[u, False]; pos) === {}, 
                                            MapThread[Rule, {ucells, ucellsplain}], 
                                            MapThread[Rule, {ucells, Insert[ucellsplain, "TemplateExclusion", 
                                                                            pos /. {a_Integer} :> {a, 3}]}]], All]];
                                                                            
         If[n =!= {}, 
            NotebookFind[nb, "Notes", All, CellStyle, AutoScroll -> False]; 
            renotes = OldNotebookRead[nb]; 
            (* Update Notes cells. *)
            NotebookWrite[nb, renotes /. If[(pos2 = Position[n, True]; pos2) === {}, 
                                            MapThread[Rule, {ncells, ncellsplain}], 
                                            MapThread[Rule, {ncells, Insert[ncellsplain, "TemplateInclusion", 
                                                                                pos2 /. {a_Integer} :> {a, 3}]}]], All]]]]
                                                                                
RefreshTemplatesDialog::noin = "There is no input notebook.";
RefreshTemplatesDialog::notsaved = "The working notebook is not saved.";
RefreshTemplatesDialog::save = "The working notebook has been modified. Save it and click the Refresh button again.";
RefreshTemplatesDialog::nobjnm = "There is no \"ObjectName\" cell in the input notebook.";
RefreshTemplatesDialog::none = "There are no syntax templates present in the working notebook.";

RefreshTemplatesDialog[] := 
 Module[{nb = (NextNotebook[] /. FrontEndObject[_] -> $frontend), ni, file, nbe, gt, cs, name, additionalTemplates,
         inlineFormulasInUsageCell, 
         inlineFormulasInNotesCells}, 
         
  Catch[If[(* There is no input notebook. *)
           nb === None, 
           Throw[MessageToConsole[RefreshTemplatesDialog::noin]]];
           
        nb = nb /. FrontEndObject[_] -> $frontend; 
        ni = NotebookInformation[nb];
        If[(file = ("FileName" /. ni); file) === "FileName", 
           Throw[MessageToConsole[RefreshTemplatesDialog::notsaved]]];
           
        If["ModifiedInMemory" /. ni, 
           Throw[RefreshTemplatesDialog::save]];
           
        nbe = EvaluationNotebook[]; 
        nbe = nbe /. FrontEndObject[_] -> $frontend;
        SetOptions[nbe, Editable -> True];
        gt = Get[ToFileName[file]]; 
        If[(cs = Cases[gt, a : Cell[_, "ObjectName", ___] :> a[[1]], Infinity]; cs === {}), 
           Throw[MessageToConsole[RefreshTemplatesDialog::nobjnm]]];
           
        name = cs[[1]]; 
        additionalTemplates = Flatten[Cases[gt, a : Cell[CellGroupData[{Cell["Syntax Templates", 
                                                                                     "TemplatesSection", ___], __}, _]] :> 
                         Cases[a, Cell[_, "Template", CellLabel -> "Additional Function Template"], Infinity], Infinity]]; 
        additionalTemplates = If[MatchQ[additionalTemplates, {Cell[BoxData[""], "Template", 
                                                                   CellLabel -> "Additional Function Template"] ..}], 
                                        {}, 
                                        additionalTemplates];
                                        
        inlineFormulasInUsageCell = Flatten[Cases[gt, a : Cell[_, "Usage", ___] :> 
                             Cases[a, Cell[BoxData[RowBox[{name, "[", __}]], "InlineFormula", ___], Infinity], Infinity]];
                             
        inlineFormulasInNotesCells = Flatten[Cases[gt, a : Cell[_, "Notes", ___] :> 
                             Cases[a, Cell[BoxData[RowBox[{name, "[", __}]], "InlineFormula", ___], Infinity], Infinity]];
                             
        If[additionalTemplates === {} && inlineFormulasInUsageCell === {} && inlineFormulasInNotesCells === {}, 
           MessageToConsole[RefreshTemplatesDialog::none]; 
           NotebookPut[TemplatesInspector[file[[2]], nb, additionalTemplates, inlineFormulasInUsageCell, 
                                          inlineFormulasInNotesCells] /. (WindowMargins -> _) -> 
                                                  (WindowMargins -> (WindowMargins /. Options[nbe, WindowMargins])), nbe], 
           NotebookPut[TemplatesInspector[name, file[[2]], nb, additionalTemplates, inlineFormulasInUsageCell, 
                                          inlineFormulasInNotesCells] /. (WindowMargins -> _) -> 
                                                (WindowMargins -> (WindowMargins /. Options[nbe, WindowMargins])), nbe]]]]
                                                

ButtonStyleApply::noin = "There is no input notebook.";
ButtonStyleApply::betwcells = "The cursor is between cells or not inside an input notebook.";
ButtonStyleApply::mulcell = "Multiple cells have been selected.";
ButtonStyleApply::mulcell = "A cell bracket is selected.";
ButtonStyleApply::notbut = "The selection is not a button.";

applyStyleToButton[re_, toggleAppend_, nb_, style_] := 
 Module[{stylepart},
        
        FrontEndExecute[{FrontEnd`FrontEndToken[nb, "MoveNext"], 
                     FrontEnd`FrontEndToken[nb, "MovePrevious"], 
                         FrontEnd`FrontEndToken[nb, "ExpandSelection"]}];
        
        stylepart = Cases[re, a : (BaseStyle -> _) :> a[[2]], Infinity][[1]];
        
        Which[toggleAppend && StringQ[stylepart] && stylepart =!= style,
        
              NotebookWrite[nb, re /. BoxData[ButtonBox[a__, BaseStyle -> b_, c___]] :> 
                                       BoxData[ButtonBox[a, BaseStyle -> {b, style}, c]], All],
                                       
              toggleAppend && ListQ[stylepart] && Not[MemberQ[stylepart, style]],
              
              NotebookWrite[nb, re /. BoxData[ButtonBox[a__, BaseStyle -> b_, c___]] :> 
                                       BoxData[ButtonBox[a, BaseStyle -> Append[b, style], c]], All],
                                       
              toggleAppend && ListQ[stylepart] && MemberQ[stylepart, style],
              
              NotebookWrite[nb, re /. BoxData[ButtonBox[a__, BaseStyle -> b_, c___]] :> 
                                       BoxData[ButtonBox[a, BaseStyle -> (DeleteCases[b, style] /. {d_String} -> d), c]], 
                            All],
                            
              Not[toggleAppend] && (StringQ[stylepart] || ListQ[stylepart]),
              
              NotebookWrite[nb, re /. BoxData[ButtonBox[a__, BaseStyle -> _, b___]] :> 
                                       BoxData[ButtonBox[a, BaseStyle -> style, b]], All]]]
                                       
Options[ButtonStyleApply] = {ToggleAppend -> False};

ButtonStyleApply[style_, opts___] :=
   Module[{nb = InputNotebook[], ci, toggleAppend, re}, 
          Catch[If[(* There is no input notebook. *)
                   nb === $Failed, 
                   Throw[MessageToConsole[ButtonStyleApply::noin]]];
                   
                ci = CellInfo[nb];
                If[(* The cursor is between cells. *)ci === $Failed, 
                   Throw[MessageToConsole[ButtonStyleApply::betwcells]]];
                If[multipleCellBracketsSelected[ci], 
                   Throw[MessageToConsole[ButtonStyleApply::mulcell]]]; 
                If[("CursorPosition" /. ci) === {"CellBracket"}, 
                   Throw[MessageToConsole[ButtonStyleApply::cellbrac]]];
                   
                toggleAppend = ToggleAppend /. {opts} /. Options[ButtonStyleApply];
                
                Which[(* The cursor is inside an inline cell but not selecting anything. *)
                      Not[FreeQ[ci, "InlineCellPosition"]] && MatchQ[("CursorPosition" /. ci), {{a_Integer, a_Integer}}],
                      
                      FrontEndExecute[{FrontEnd`FrontEndToken[nb, "ExpandSelection"]}]; 
                      re = OldNotebookRead[nb]; 
                      If[MatchQ[re, BoxData[ButtonBox[__, BaseStyle -> _, ___]]], 
                         applyStyleToButton[re, toggleAppend, nb, style], 
                         MessageToConsole[ButtonStyleApply::notbut]],
                         
                      (* A portion of an inline cell is selected or a button box is selected. *)
                      re = OldNotebookRead[nb]; 
                      (Not[FreeQ[ci, "InlineCellPosition"]] && MatchQ[("CursorPosition" /. ci), {{___, a_Integer, b_Integer}} /; 
                                                                      a =!= b]) || 
                       (MatchQ[re, BoxData[ButtonBox[__, BaseStyle -> _, ___]]]),
                       
                      If[MatchQ[re, BoxData[ButtonBox[__, BaseStyle -> _, ___]]],
                         applyStyleToButton[re, toggleAppend, nb, style],
                         MessageToConsole[ButtonStyleApply::notbut]],
                         
                      (* Cursor not in an inline cell and nothing is selected. *)
                      
                      MatchQ[("CursorPosition" /. ci), {{a_Integer, a_Integer}}],
                      
                      FrontEndExecute[{FrontEnd`FrontEndToken[nb, "MovePrevious"]}];
                      ci = CellInfo[nb]; 
                      If[ci === $Failed, 
                         Do[FrontEndExecute[{FrontEnd`FrontEndToken[nb, "MoveNext"]}], {2}]; 
                         ci = CellInfo[nb]; 
                         If[MatchQ[("InlineCellPosition" /. ci), {{_Integer}}], 
                            Throw[FrontEndExecute[{FrontEnd`FrontEndToken[nb, "ExpandSelection"]}]; 
                                  re = OldNotebookRead[nb]; 
                                  If[MatchQ[re, BoxData[ButtonBox[__, BaseStyle -> _, ___]]], 
                                     applyStyleToButton[re, toggleAppend, nb, style], 
                                     MessageToConsole[ButtonStyleApply::notbut]]], 
                            FrontEndExecute[{FrontEnd`FrontEndToken[nb, "MovePrevious"]}]]];
                            
                      If[MatchQ[("InlineCellPosition" /. ci), {{_Integer}}], 
                         Throw[FrontEndExecute[{FrontEnd`FrontEndToken[nb, "ExpandSelection"]}]; 
                               re = OldNotebookRead[nb]; 
                               If[MatchQ[re, BoxData[ButtonBox[__, BaseStyle -> _, ___]]], 
                                  applyStyleToButton[re, toggleAppend, nb, style], 
                                  MessageToConsole[ButtonStyleApply::notbut]]], 
                         FrontEndExecute[{FrontEnd`FrontEndToken[nb, "MoveNext"]}]];
                         
                      If[MatchQ[("InlineCellPosition" /. ci), {{_Integer}}], 
                         Throw[FrontEndExecute[{FrontEnd`FrontEndToken[nb, "ExpandSelection"]}]; 
                               re = OldNotebookRead[nb]; 
                               If[MatchQ[re, BoxData[ButtonBox[__, BaseStyle -> _, ___]]], 
                                  applyStyleToButton[re, toggleAppend, nb, style], 
                                  MessageToConsole[ButtonStyleApply::notbut]]],
                         FrontEndExecute[{FrontEnd`FrontEndToken[nb, "MovePrevious"]}]],
                         
                       (* Cursor not in an inline cell and something is selected which is not a button box. *)
                       
                       re = OldNotebookRead[nb]; 
                       Not@MatchQ[re, BoxData[ButtonBox[__, BaseStyle -> _, ___]]],
                       
                       MessageToConsole[ButtonStyleApply::notbut]]]]


DeactivateControls::noin = "There is no input notebook.";
DeactivateControls::noobjnm = "There is no object name cell in the input notebook.";
DeactivateControls::struc = "The structure of the cell layout in input notebook is unsuitable for DeactivateControls.";

$ControlBoxesToDeactivate = {AnimatorBox, CheckboxBox, ColorSetterBox, InputFieldBox, OpenerBox, RadioButtonBox, SetterBox,
                             Slider2DBox, SliderBox, TabViewBox, TogglerBox}
                             
DeactivateControls[] := 
 Module[{nb = InputNotebook[], nf, re}, 
        Catch[If[(* There is no input notebook. *)nb === $Failed, 
                 Throw[MessageToConsole[DeactivateControls::noin]]];
              nf = NotebookFind[nb, "ObjectName", All, CellStyle];
              If[nf === $Failed, 
                 Throw[MessageToConsole[DeactivateControls::noobjnm]]];
              FrontEndExecute[{FrontEndToken[nb, "ExpandSelection"]}];
              re = OldNotebookRead[nb];
              If[Not@MatchQ[re, Cell[CellGroupData[{Cell[_, "ObjectName", ___], __}, _]]], 
                 Throw[MessageToConsole[DeactivateControls::struc]]];
              NotebookWrite[nb, re /. Cell[BoxData[a_[b__]], c___] :> 
                Cell[BoxData[TagBox[a[b], 
                              System`EventHandlerTag[{"MouseDown" -> Null, System`PassEventsDown -> Automatic, 
                                               System`PassEventsUp -> True}]]], c] /; 
                                                                                   MemberQ[$ControlBoxesToDeactivate, a]]]]



(* Tempory alias for Delimiter[] in order to force FE not to mislabel the context when
   called from the custom menu expression:  *)
(* Apparently no longer needed with recent splitting of package and related loading reconfiguration: *)
   
DelimiterHack[] := DocDelimiter[]

DocDelimiter[] := Module[{ nb = InputNotebook[], 
                       info, sel, guideLineCell, guideMoreAboutLineCell, lineCell, guidePage},

    info = CellInfo[nb];
    sel  = OldNotebookRead[nb];
    guideLineCell = Cell["\t", "GuideDelimiter"];
    guideMoreAboutLineCell = Cell["\t", "GuideMoreAboutDelimiter"];
    lineCell = Cell[ BoxData[ InterpretationBox[Cell["\t", "ExampleDelimiter"], ($Line = 0; Null)]], "ExampleDelimiter"];

    If["GuidePageStyles.nb" === (
          (StyleDefinitions /. Options[nb, StyleDefinitions])
            /. FrontEnd`FileName[dir_, name_, ___] :> name
        ),
        guidePage = True,
        guidePage = False];

    If[ guidePage,
      If[ info === $Failed,
        NotebookWrite[ nb, guideLineCell, All],
       (SelectionMove[ nb, After, Cell];
        NotebookWrite[ nb, guideLineCell, All])],
      If[ info === $Failed,
        NotebookWrite[ nb, lineCell],
       (SelectionMove[ nb, After, Cell];
        NotebookWrite[ nb, lineCell])]
      ];
      
(* If[ guidePage,
      SelectionMove[ nb, All, CellGroup];
      If[ FreeQ[ CellInfo[ nb], "GuideMoreAboutSection" | "GuideMoreAbout" | "GuideMoreAboutSub"],
       (SelectionMove[ nb, After, CellGroup];
        NotebookFind[ nb, "GuideDelimiter", Previous, CellStyle];
        SelectionMove[ nb, After, Cell]),
       (SelectionMove[ nb, Before, CellGroup];
        NotebookFind[ nb, "GuideDelimiter", Next, CellStyle];
        NotebookWrite[ nb, guideMoreAboutLineCell])]] *)
    ]


NeedsStatementInsert::noin = "There is no open input notebook.";
NeedsStatementInsert::notbe = "The cursor must be between cells.";
NeedsStatementInsert::noconcell = "No context cell was found with the correct structure.";
NeedsStatementInsert::systemcon = "The context should not be System`.";

Options[NeedsStatementInsert] = {Deemphasis -> True}

NeedsStatementInsert[opts___] := 
 Module[{nb = InputNotebook[], d, ci, cs}, 
  Catch[d = Deemphasis /. {opts} /. Options[NeedsStatementInsert];
        If[(* There is no open input notebook. *)nb === $Failed, 
           Throw[MessageToConsole[NeedsStatementInsert::noin]]];
        ci = CellInfo[nb];
        If[(* The cursor was not between cells. *)ci =!= $Failed, 
           Throw[MessageToConsole[NeedsStatementInsert::notbe]]];
        If[Not@MatchQ[(cs = Cases[NotebookGet[nb], 
              Cell[x_String /; StringMatchQ[x, __ ~~ "`"], "Categorization", ___, CellLabel -> "Context", ___], Infinity]), 
                   {Cell[x_String /; StringMatchQ[x, __ ~~ "`"], "Categorization", ___, CellLabel -> "Context", ___], ___}], 
           Throw[MessageToConsole[NeedsStatementInsert::noconcell]]]; 
        If[cs[[1, 1]] === "System`", 
           Throw[MessageToConsole[NeedsStatementInsert::systemcon]]]; 
        NotebookWrite[nb, Cell[BoxData[RowBox[{"Needs", "[", "\"" <> cs[[1, 1]] <> "\"", "]"}]], "Input", If[d, "Deemphasis", Unevaluated[Sequence[]]]]]]]
        
        
KeyWordsSort::noin = "There is no open input notebook.";
KeyWordsSort::noselection = "Nothing is selected in the input notebook."; 
KeyWordsSort::incorsel = "Select the cell bracket of a key word or an entire key word group."; 
KeyWordsSort::notinkeygrp = "The keyword cell was not in a key words group.";
KeyWordsSort::alreadysorted = "The keyword list is already sorted.";

AuxiliaryKeyWordsSort[stringlist : {{_String, _String} ..}] := 
 Module[{m = Max[StringLength /@ (First /@ stringlist)], auxf, sl, auxf2, unCapitalizedStringList, s2}, 
  auxf[string_, ext_] := (sl = StringLength[string]; If[sl < ext, Join[Characters@string, Table[" ", {ext - sl}]], Characters@string]);
  auxf2[x_] := Which[x === " ", {1, x}, x === "-", {2, x}, LetterQ[x], {3, x}, True, {4, x}];
  unCapitalizedStringList = ToLowerCase /@ (First /@ stringlist);
  s2= Take[#, -2] & /@ 
   Sort[Transpose[{unCapitalizedStringList, First /@ stringlist, Last /@ stringlist}], 
        OrderedQ[{auxf[#1[[1]], m] /. x_String :> auxf2[x], auxf[#2[[1]], m] /. x_String :> auxf2[x]}] &];
  Flatten[Sort[#, OrderedQ[{#1[[2]], #2[[2]]}] &] & /@ Split[s2, #1[[1]] === #2[[1]] &], 1]]
                               
KeyWordsSort[] := 
 Module[{nb = InputNotebook[], ci, re, keywordlist, sortedkeywordlist}, 
  Catch[If[(* There is no open input notebook. *)nb === $Failed, 
           Throw[MessageToConsole[KeyWordsSort::noin]]]; 
        ci = CellInfo[nb]; 
        If[(* The cursor was not between cells. *)ci === $Failed, 
           Throw[MessageToConsole[KeyWordsSort::noselection]]]; 
        re = NotebookRead[nb]; 
        If[Not@MatchQ[re, 
                  Cell[CellGroupData[{Cell["Keywords", "KeywordsSection", ___], Cell[_String, "Keywords", ___] ..}, _]]] && 
           Not@MatchQ[re, Cell[_String, "Keywords", ___]], 
           Throw[MessageToConsole[KeyWordsSort::incorsel]]]; 
        If[MatchQ[re, Cell[_String, "Keywords", ___]], 
           FrontEndExecute[{FrontEndToken[nb, "ExpandSelection"]}]; 
           re = NotebookRead[nb]]; 
        If[Not@MatchQ[re, 
                     Cell[CellGroupData[{Cell["Keywords", "KeywordsSection", ___], Cell[_String, "Keywords", ___] ..}, _]]], 
           Throw[MessageToConsole[KeyWordsSort::notinkeygrp]]]; 
        keywordlist = {#[[1]], If[# === {}, " ", #[[1]]] &[Cases[#, a : (CellLabel -> b_) :> b]]} & /@ Drop[re[[1, 1]], 1]; 
        sortedkeywordlist = AuxiliaryKeyWordsSort[keywordlist]; 
        If[sortedkeywordlist =!= keywordlist, 
           NotebookWrite[nb, Cell[CellGroupData[Prepend[If[#[[2]] === " ", 
                                                           Cell[#[[1]], "Keywords"],
                                                           Cell[#[[1]], "Keywords", CellLabel -> #[[2]]]] & /@ sortedkeywordlist, 
                                                        Cell["Keywords", "KeywordsSection"]], Open]], All], 
           Throw[MessageToConsole[KeyWordsSort::alreadysorted]]]]]


$SelectedCellData = None

Options[InsertLink] =
  {
    "Notebook" -> Automatic,
      (* Document notebook (default: InputNotebook[]). *)
    "Example" -> False,
      (* Example or Hyperlink style button? *)
    "ButtonText" -> Automatic,
      (* Sets the button label text (Automatic uses the link tag). *)
    "LongForm" -> True,
      (* Toggles long form (pacletURI#cellid) or short form (cellid). *)
    "PreserveSelectionContent" -> False
      (* When True, it will write the link target data to a symbol instead of the clipboard
         Another function is used to link the selection in the "paste" notebook. *)
  };

InsertLink::noin = "There is no open input notebook.";
InsertLink::nocellid = "The cell lacks a cell id and so cannot be linked to.";
InsertLink::notsav = "The input notebook has not been saved.";

InsertLink["Example", options___?OptionQ] :=
  InsertLink["Example" -> True, options];

InsertLink[options___?OptionQ] :=
  Module[
    {
      optNotebook, optExample, optButtonText, optLongForm, optPreserveSelectionContent,
      nb, buttonStyle,
      target, longtarget, pacletURI, label, link, backlink
    },
  Catch[
    {optNotebook, optExample, optButtonText, optLongForm, optPreserveSelectionContent} =
      {"Notebook", "Example", "ButtonText", "LongForm", "PreserveSelectionContent"} /. {options} /. Options[InsertLink];
    nb =
      If[optNotebook === Automatic,
        InputNotebook[],
        optNotebook
      ];
    If[(* There is no open input notebook. *)nb === $Failed, 
           Throw[MessageToConsole[InsertLink::noin]]];
    If[optExample, optLongForm = False];
      (* ...force short form for Examples. *)
    buttonStyle = If[optExample, "ExampleLink", "Link"];
    (* Expand selection to Cell level, if necessary. *)
    If[expandSelectionToCell[nb] === None,
       Throw[MessageToConsole[DocuTools::nosel, "InsertLink", "cell"]];
    ];
    (* Use CellID as link target. *)
    target = CellID /. Options[NotebookSelection[nb], CellID];
    If[target === 0, Throw[MessageToConsole[InsertLink::nocellid]]];
    If[Not@MatchQ[NotebookInformation[nb], {___, "FileName" -> _, __}], 
       Throw[MessageToConsole[InsertLink::notsav]]];
    longtarget =
      If[optLongForm
        ,
        pacletURI = PathToPacletURI[PathOfNotebook[nb]];
        pacletURI = If[$MathematicaDocs || Not[StringQ[$LinkBase]] || StringMatchQ[$LinkBase, "" | Whitespace],
                       pacletURI,
                       StringReplace[pacletURI, "paclet:" -> "paclet:" <> $LinkBase <> "/"]];
        If[Head[pacletURI] === String,
          pacletURI <> "#" <> ToString[target],
          Throw[MessageToConsole[InsertLink::badURI, ToString[pacletURI]]]; target
        ]
        ,
        target
      ];
    If[optExample,
      (* ...create a backlink button within the target.  This will search
        for the button placed on the clipboard by it's *content*. *)
      backlink =
        ButtonBox["Backlink",
          BaseStyle -> "ExampleBacklink",
          ButtonData -> ToString[target]
        ];
      SetOptions[NotebookSelection[nb], 
        CellFrameLabels -> {{None, Cell[TextData[backlink]]}, {None, None}}]
    ];
    (* Store to the clipboard a button which will find the target CellID. *)
    label=
      If[optButtonText === Automatic,
        ToString[target],
        optButtonText
      ];
    link =
      TextData[
        ButtonBox[label,
          BaseStyle -> buttonStyle,
          ButtonData -> longtarget
        ]
      ];
    If[Not@optPreserveSelectionContent,
       ClipboardPut[link],
       $SelectedCellData = longtarget]
  ]]
  
LinkSelection::nocelldata = "You must first use InsertLink to set $SelectedCellData.";
LinkSelection::notcelldata = "$SelectedCellData has an incorrect form.";
LinkSelection::noin = "There is no open input notebook.";
LinkSelection::nottext = "Some plain or styled text must be selected that includes no links.";

LinkSelection[]:=
 Module[{nb = InputNotebook[], datatype},
  Catch[If[$SelectedCellData === None, 
           Throw[MessageToConsole[LinkSelection::nocelldata]]];
        If[Not@StringQ[$SelectedCellData] || Not@StringMatchQ[$SelectedCellData, "paclet:"~~__~~"/"~~__],
           Throw[MessageToConsole[LinkSelection::notcelldata]]];
        If[(* There is no open input notebook. *)nb === $Failed, 
           Throw[MessageToConsole[LinkSelection::noin]]];
        ci = CellInfo[nb];
        If[Not@MatchQ[ci, {{___, "Style" -> _, "ContentData" -> (TextData|BoxData), __}}], 
           Throw[MessageToConsole[LinkSelection::nottext]]];
        re = NotebookRead[nb];
        If[Not@MatchQ[re, _String | {(_String | _StyleBox) ..}],
           Throw[MessageToConsole[LinkSelection::nottext]]];
        $SelectedCellData = StringReplace[$SelectedCellData, {"ReferencePages/Symbols" -> "ref", "/Tutorials/" -> "/tutorial/", "/Guides/" -> "/guide/"}];
        datatype = If[MatchQ[ci, {{___, "Style" -> _, "ContentData" -> TextData, __}}],
                      TextData,
                      BoxData];
        NotebookWrite[nb,
                      If[StringQ[re],
                         datatype@ButtonBox[re, BaseStyle->"Link",ButtonData->$SelectedCellData],
                         datatype[If[StringQ@#, 
                                     ButtonBox[#, BaseStyle -> "Link", ButtonData -> $SelectedCellData], 
                                     MapAt[ButtonBox[#, BaseStyle -> "Link", ButtonData -> $SelectedCellData] &, #, 1]] & /@ re]]]]]

(* Prefixes for link-related CellTags. *)
$XRefPrefix = "Ex-";
$LinkPrefix = "Crf-";

(* Tests for link-related CellTags. *)
XRefQ[s_String] := StringMatchQ[s, $XRefPrefix <> "*"];
LinkQ[s_String] := StringMatchQ[s, $LinkPrefix <> "*"];

expandSelectionToCell[nb_NotebookObject] :=
  (*
    Expands the current selection to the nearest enclosing Cell.
  *)
  Module[
    {
      exitTest,
      getCellInfo,
      cInfo,
      nCells,
      pos
    },
    (* Test for exiting the "expand selection" loop. *)
    exitTest[] :=
      (
        nCells != 1 || pos === "CellBracket"
      );
    getCellInfo[] :=
      (
        cInfo = CellInfo[nb];
        nCells = If[cInfo === $Failed, 0, Length[cInfo]];
        pos =
          If[nCells == 0,
            None,
            "CursorPosition" /. First[cInfo]
          ];
      );
    getCellInfo[]; (* Sets nCells & pos. *)
    If[exitTest[], Return[pos]];
    FrontEndExecute[{
      FrontEnd`SetOptions[FrontEnd`$FrontEnd, ShowSelection -> False]
    }];
    While[
      Not @ exitTest[]
      ,
      SelectionMove[nb, All, Cell];
      getCellInfo[]
    ];
    FrontEndExecute[{
      FrontEnd`SetOptions[FrontEnd`$FrontEnd, ShowSelection -> Inherited]
    }];
    pos
  ];

(*
  Generates a string based on the AbsoluteTime[] (one second granularity), encoded in base 62.
*)
TimeStamp[] := 
  StringJoin @@
    Part[
      Join[CharacterRange["0", "9"], 
          CharacterRange["a", "z"], 
          CharacterRange["A", "Z"]], 
      IntegerDigits[IntegerPart @ AbsoluteTime[], 62] + 1
    ];

(*
  Locate 'target'.
*)
FindExampleLink[target_Integer] :=
  NotebookFind[ButtonNotebook[], target, All, CellID];

(*
  Locate links pointing to 'target'.
*)
FindBacklink[target_String] :=
  NotebookFind[ButtonNotebook[], target, All];

(*
  Set the ClipboardNotebook[] content.

  Works by creating a temporary, invisible notebook containing the
  content, then using the "Copy" FE token to load the clipboard.

  Warning:  Trying to write directly to ClipboardNotebook[] (via, say,
  NotebookPut[]) doesn't seem to play well with outside applications.  They
  end up seeing an empty clipboard.
*)
ClipboardPut[content_] :=
  Module[
    {
      nb
    },
    nb = NotebookCreate[Visible -> False];
    NotebookWrite[nb, content];
    SelectionMove[nb, All, Notebook];
    FrontEndExecute[FrontEnd`FrontEndToken[nb, "Copy"]];
    NotebookClose[nb]
  ];

(*
  Converts a full pathname to a pacletURI.
  If 'path' is not a child of $DocumentationDirectory, returns $Failed.
*)
PathToPacletURI[path_String] :=
  If[StringMatchQ[path, $DocumentationDirectory ~~ ___], 
    "paclet:" <>
      ReduceToPacletPath[
        StringReplace[path, {
          $DocumentationDirectory -> "",
          $PathnameSeparator -> "/",
          ".nb" -> ""
        }]
      ],
    $Failed
  ];

(*
  Returns file path associated w/an open notebook.
  If notebook is unsaved or not open, returns $Failed.
*)
PathOfNotebook[nb_NotebookObject] :=
  Module[
    {
      info, file
    },
    info = NotebookInformation[nb];
    If[info === $Failed, Return[$Failed]];
    file = "FileName" /. info /. "FileName" -> None;
    Switch[file,
      FrontEnd`FileName[___],  ToFileName @@ Take[file, 2],
      _String,  file,
      None,  $Failed,
      _,
        MessageToConsole[DocuTools::assertion, 
          "(PathOfNotebook): unknown form for FileName option ["
          <> ToString@file <> "]"
        ]
    ]
  ];



(*
  Clears link cell tags from the selected cell.
*)

Options[ClearLink] =
  {
    "Notebook" -> Automatic
      (* Document notebook (default: InputNotebook[]). *)
  };

ClearLink[options___?OptionQ] :=
  Module[
    {
      optNotebook, nb, data
    },
    {optNotebook} =
      {"Notebook"}
        /. {options}
          /. Options[ClearLink];
    nb =
      If[optNotebook === Automatic,
        InputNotebook[],
        optNotebook
      ];
    (* Expand selection to Cell level, if necessary. *)
    If[expandSelectionToCell[nb] === None,
      MessageToConsole[DocuTools::nosel, "ClearLink", "cell"];
      Return[$Failed]
    ];
    (* Read the cell... *)
    data = OldNotebookRead[nb];
    (* ...strip out link cell tags and backlink buttons... *)
    data = data /. {
      HoldPattern[CellTags -> tag:(_String | _List)]
        :> CellTags ->
            (tag /. _String?(XRefQ[#] || LinkQ[#] &) :> Sequence[]),
      Cell[TextData[ButtonBox[___, BaseStyle -> "ExampleBacklink", ___]]]
        :> None
      };
    (* ...and write it back out. *)
    NotebookWrite[nb, data, All]
  ];


Options[BrightFlagFlip] = {
  "Flag" -> Automatic
    (*
      True -> turns flag on,
      False -> turns it off,
      Automatic -> toggles its value,
      Inherited -> leaves value as is
    *)
};

BrightFlagFlip[OptionsPattern[]] :=
  Module[
    {
      nb = InputNotebook[],
      flip, sel, tag = "$BrightFlagFlip$"
    },
    sel = Flatten[{NotebookRead[nb] //. Cell[CellGroupData[c_, _]] :> c}];
    If[!MatchQ[sel, {__Cell}]
      ,
      (* Single cell selection. *)
      flip =
        Switch[OptionValue["Flag"],
          True, True&,
          False, False&,
          Automatic, Not,
          Inherited, Identity
        ];
      BrightFlagFlipSingleCell[flip];
      ,
      (* Multiple cell selection. *)
      flip =
        Switch[OptionValue["Flag"],
          True,
            Cell[a: PatternSequence[_, "ModInfo"], b___] /;
              FreeQ[{b}, "BrightFlag"] :> Cell[a, "BrightFlag", b],
          False,
            Cell[a: PatternSequence[_, "ModInfo", ___], "BrightFlag", b___]
              :> Cell[a, b],
          Automatic, {
              Cell[a: PatternSequence[_, "ModInfo", ___], "BrightFlag", b___]
                :> Cell[a, b],
              Cell[a: PatternSequence[_, "ModInfo"], b___]
                :> Cell[a, "BrightFlag", b]
            },
          Inherited, {}
        ];
      FrontEndExecute[FrontEnd`SelectionAddCellTags[nb, tag]];
      Do[
        NotebookFind[nb, tag, Next, CellTags];
        NotebookWrite[nb, NotebookRead[nb] /. flip, All];
        ,
        {Length[sel]}
      ];
      NotebookFind[nb, tag, All, CellTags];
      FrontEndExecute[FrontEnd`SelectionRemoveCellTags[nb, tag]];
    ];
  ];

BrightFlagFlipSingleCell[flip_] :=
  (*
    Leverages the EditVersionHistory code, by locally redefining the launch
    dialog code to simply perform the action without launching the dialog
    (with an appropriate modulation of the flag setting).
  *)
  Block[{LaunchHistoryEditor},
    LaunchHistoryEditor[action_, vers_, flag_] :=
      Module[{verList},
        verList = StringSplit[vers, ","] /.
          s_String /; StringMatchQ[s, WhitespaceCharacter ...] :> Sequence[];
        ReleaseHold[action][
          If[Length[verList] > 0, Last[verList] /. "F" -> " F", ""],
          verList, flip[flag]
        ];
        FrontEndTokenExecute[InputNotebook[], "MoveNext"];
      ];
    EditVersionHistory[]
  ];


VersionAnnotate::badlabel = "VersionAnnotate was called with the
\"VersionFlagging\" option, but the argument label (`1`) was not a valid
format version number (`2`).";

VersionAnnotate::unsup = "VersionAnnotate does not support the selected
cell type.";

VersionAnnotate::badmodinfo = "The ModInfo cell is not in a supported
format.";

VersionAnnotate::oversel = "VersionAnnotate supports multiple cell
selections only for \"Notes\" style cells.";

If[ !ValueQ[ $FlaggedVersion], $FlaggedVersion = 8.2]

Options[VersionAnnotate] =
  {
    "IgnoreUsageAndTables" -> False,
    "Flag" -> None,
    "DelimitedDualStyle" -> True,
    "VersionFlagging" -> $FlaggedVersion
  }

VersionAnnotate[] :=
  VersionAnnotate["ClearAllModInfoSettings", "Flag" -> False]

VersionAnnotate[label_String, options: OptionsPattern[]] :=
  Module[
    {
      nb = InputNotebook[],
      optIgnoreUsageAndTables,
      optDelimitedDualStyle,
      info, style, pos, flag
    },
    (* Parse options. *)
    {optIgnoreUsageAndTables, optDelimitedDualStyle} =
      OptionValue[#]& /@
        {"IgnoreUsageAndTables", "DelimitedDualStyle"};
    (* Require initial selection to be within a cell. *)
    If[CellInfo[nb] === $Failed,
      MessageToConsole[DocuTools::badsel, "VersionAnnotate", "cell"];
      Return[$Failed]
    ];
    (* Step outside any InlineFormula cells,
      so we can see the main cell's style. *)
    While[
      info = CellInfo[nb];
      Head[info] === List
        && Length[info] == 1
        && MatchQ[("Style" /. First[info] /. "Style" -> None),
          "InlineFormula" | "InlineGuideFunction" ]
      ,
      FrontEndExecute[{
        FrontEnd`FrontEndToken[nb, "MovePrevious"]
      }];
    ];
    style = "Style" /. First[info] /. "Style" -> None;
    pos = "CursorPosition" /. First[info] /. "CursorPosition" -> None;
    If[optIgnoreUsageAndTables
      (* If in a Usage cell or table, do nothing. *)
        && StringMatchQ[style, {"Usage", "*Table", "*TableMod"}],
      Return[]
    ];
    If[optDelimitedDualStyle && MemberQ[$DelimitedStyles, style],
      Switch[pos,
        "CellBracket",
          VersionAnnotateCellDingbat[label, options],
        _,
          flag = ParseFlaggingOptions[label, options];
          VersionAnnotateDelimited[flag]
      ];
      Return[]
    ];
    (* If we're inside a CellDingbat-using cell, pass off elsewhere. *)
    If[Head[info] === List
        && Length[info] >= 1
        && MatchQ[("Style" /. info /. "Style" -> None),
            {(Alternatives @@ $CellDingbatVersionInfo)..}]
      ,
      VersionAnnotateCellDingbat[label, options];
      Return[];
    ];
    (* Require single cell selection for other than CellDingbat-using
      cells. *)
    If[Length[info] != 1,
      MessageToConsole[VersionAnnotate::oversel];
      Return[$Failed]
    ];
    (* If we're inside a History cell, pass off elsewhere. *)
    If[MemberQ[{"History", "HistoryData"},
            ("Style" /. First[info] /. "Style" -> None)]
      ,
      flag = ParseFlaggingOptions[label, options];
      VersionAnnotateHistory[label, flag];
      Return[];
    ];
    (* If we're inside a delimited cell, pass off elsewhere. *)
    If[MemberQ[$DelimitedStyles,
            ("Style" /. First[info] /. "Style" -> None)]
      ,
      flag = ParseFlaggingOptions[label, options];
      VersionAnnotateDelimited[flag];
      Return[];
    ];
    (* We're probably in a Usage cell or table of some kind.
      Step leftward in search of a ModInfo cell... *)
    While[
      info = CellInfo[nb];
      info =!= $Failed
        && ("Style" /. First@info /. "Style" -> None) != "ModInfo"
      ,
      FrontEndExecute[{
        FrontEnd`FrontEndToken[nb, "MovePrevious"]
      }];
    ];
    (* If we're inside a ModInfo cell, pass off elsewhere. *)
    If[info =!= $Failed,
      VersionAnnotateModInfo[label, options];
      Return[];
    ];
    (* Else, this is not a supported cell type. *)
    MessageToConsole[VersionAnnotate::unsup];
    Return[$Failed]
  ];

(*
  "Flag" and "VersionFlagging" options to VersionAnnotate work in concert
  to determine if a selection should be "BrightFlag"'ed.  A label of "F"
  requires "BrighterFlag".
  
  This returns the result None, "BrightFlag", "BrighterFlag", or Inherited.
*)
ParseFlaggingOptions[label_String, OptionsPattern[VersionAnnotate]] :=
  Module[
    {optFlag, optVersionFlagging, vers},
    (* Get option values. *)
    {optFlag, optVersionFlagging} = 
      OptionValue[#]& /@ {"Flag", "VersionFlagging"};
    Which[
      StringMatchQ[label, WhitespaceCharacter... ~~ "F"],
        "BrighterFlag",
      (* A specific "Flag" option overrides "VersionFlagging": *)
      optFlag === True,
        "BrightFlag",
      optFlag === False,
        None,
      optFlag === Inherited,
        Inherited,
      (*
        ...but if "Flag" is None, "VersionFlagging" option takes over:
      *)
      True,
        If[NumberQ[optVersionFlagging]
          ,
          (* Set flags for labels at or above the given version number. *)
          vers = GetVersionFromLabel[label];
          If[vers === $Failed,
            MessageToConsole[VersionAnnotate::badlabel,
              label, ToString[$VersionLabelPattern]];
            Return[$Failed]
          ];
          If[vers >= optVersionFlagging,
            "BrightFlag",
            None
          ]
          ,
          (* If both "Flag"/"VersionFlagging" -> None, no flags. *)
          None
        ]
    ]
  ];

$VersionLabelPattern = RegularExpression["\\d+\\.?\\d*\\D"];

GetVersionFromLabel[s_String] :=
  (
    If[StringMatchQ[s, $VersionLabelPattern],
      ToExpression[StringDrop[s, -1]],
      $Failed
    ]
  );

GetSuffixFromLabel[s_String] :=
  (
    If[StringMatchQ[s, $VersionLabelPattern], 
      StringTake[s, -1],
      $Failed
    ]
  );


(*
  Cell styles that use CellDingbat for storing version info.
*)
$CellDingbatVersionInfo =
  {"Notes", "GuideText", "GuideTutorial",
  "GuideMoreAbout", "GuideMoreAboutSub", "Text", "MathCaption",
  "DefinitionBox", "Input", "Output", {"Message", "MSG"}, "ExampleDelimiter", "ExampleText"};

VersionAnnotateCellDingbat[label_String, options: OptionsPattern[]] :=
  Module[
    {
      nb = InputNotebook[],
      cd, flip, verlist, latest
    },
    (* Expand selection to Cell level, if necessary. *)
    If[expandSelectionToCell[nb] === None,
      MessageToConsole[DocuTools::nosel, "VersionAnnotate", "cell"];
      Return[$Failed]
    ];
    (* Construct the CellLabel. *)
    If[label === "ClearAllModInfoSettings"
      ,
      cd = Inherited
      ,
      cd = CellDingbat /. Options[NotebookSelection[nb], CellDingbat];
      If[$NewModInfoFormat
        ,
        If[cd === None,
          cd = Cell[BoxData[TooltipBox[Cell[" ", "ModInfo"], " "]]]
        ];
        (* Update old format to new. *)
        If[MatchQ[cd, Cell[_, "ModInfo", ___]],
          cd =
            cd /. c: Cell[v_, "ModInfo", ___]
              :> Cell[BoxData[TooltipBox[c, v]]]
        ];
        verlist = cd /. Cell[BoxData[TooltipBox[_, v_]]] :> v;
        {verlist, latest} = UpdateVersionHistory[verlist, label];
        flip =
          Switch[ParseFlaggingOptions[latest, options],
            "BrightFlag",
              Cell[c_, s: "ModInfo", ___] :> Cell[c, s, "BrightFlag"],
            "BrighterFlag",
              Cell[c_, s: "ModInfo", ___] :> Cell[c, s, "BrighterFlag"],
            None,
              Cell[c_, s: "ModInfo", ___] :> Cell[c, s],
            Inherited,
              {}
          ];
        cd =
          cd /. flip
            /. Cell[_, s: "ModInfo", etc___] :> Cell[latest, s, etc]
            /. TooltipBox[c_, _] :> TooltipBox[c, verlist];
        ,
        If[cd === None, cd = Cell["", "ModInfo"]];
        flip =
          Switch[ParseFlaggingOptions[label, options],
            "BrightFlag" | "BrighterFlag",
              Cell[c_, s: "ModInfo", ___] :> Cell[c, s, "BrightFlag"],
            None,
              Cell[c_, s: "ModInfo", ___] :> Cell[c, s],
            Inherited,
              {}
          ];
        cd = cd /. flip /. Cell[_, other___] :> Cell[label, other];
      ];
    ];
    (* Set the CellLabel. *)
    SetOptions[NotebookSelection[nb], CellDingbat -> cd]
  ];


VersionAnnotateModInfo["ClearAllModInfoSettings", rest___] :=
  VersionAnnotateModInfo[" ", rest];
  (* Watch for the clearing "code phrase". *)

VersionAnnotateModInfo[label_String, options: OptionsPattern[]] :=
  Module[
    {
      nb = InputNotebook[],
      info, style, data, datanew, cellpos, result, flag,
      stylenames = If[$VersionNumber < 8, ToExpression["Global`StyleNames"], ToExpression["System`StyleNames"]]
    },
    info = CellInfo[nb];
    If[Length[info] != 1,
      MessageToConsole[DocuTools::badsel,
        "VersionAnnotateModInfo", "\"ModInfo\" cell"];
      Return[$Failed]
    ];
    style = "Style" /. First[info] /. "Style" -> None;
    If[Head[style] === List, style = First[style]];
    If[!MemberQ[{"UsageModInfo", "ModInfo"}, style],
      MessageToConsole[DocuTools::badsel,
        "VersionAnnotateModInfo", "\"ModInfo\" cell"];
      Return[$Failed]
    ];
    If[$NewModInfoFormat
      ,
      FrontEndTokenExecute[nb, "ExpandSelection"];
      data = NotebookRead[nb];
      FrontEndTokenExecute[nb, "ExpandSelection"];
      datanew = NotebookRead[nb];
      cellpos = "InlineCellPosition"
        /. First @ CellInfo[nb] /. "InlineCellPosition" -> None;
      If[(data === datanew) || (cellpos === None)
        ,
        ProcessModInfoOldFormat[nb, label, options];
        ,
        result = ProcessModInfoNewFormat[nb, label, options];
        If[result === $Failed, Return[$Failed]];
      ]
      ,
      SelectionMove[nb, All, CellContents];
      NotebookWrite[nb, label];
      flag = ParseFlaggingOptions[label, options];
      If[flag =!= Inherited,
        SelectionMove[nb, All, Cell];
        Switch[flag,
          "BrightFlag" | "BrighterFlag",
            SetOptions[NotebookSelection[nb], "BrightFlag"],
          _,
            SetOptions[NotebookSelection[nb], stylenames -> Inherited]
        ];
        (* Reset the selection to within the ModInfo cell,
          so the function can cycle. *)
        FrontEndExecute[{
          FrontEnd`FrontEndToken[nb, "MoveNext"],
          FrontEnd`FrontEndToken[nb, "MovePrevious"]
        }]
      ]
    ];
  ];

ProcessModInfoOldFormat[
  nb_NotebookObject,
  label_String,
  options: OptionsPattern[VersionAnnotate]
] :=
  Module[
    {verlist, latest, flag, $Sentinel = "$FOO$"},
    FrontEndTokenExecute[nb, "MoveNext"];
    FrontEndTokenExecute[nb, "MovePrevious"];
    SelectionMove[nb, All, CellContents];
    verlist = NotebookRead[nb];
    {verlist, latest} = UpdateVersionHistory[verlist, label];
    flag = ParseFlaggingOptions[latest, options]
      /. (Inherited | None) -> Sequence[];
    SelectionMove[nb, All, Cell];
    If[Head[NotebookRead[nb]] === Cell
      ,
      (*
        A workaround for the case of an old-format ModInfo within a GridBox
        (i.e., tables).  cf:
          <https://mailman.wolfram.com/archive/l-frontend/\
            2008/Mar/msg00003.html>
      *)
      NotebookWrite[nb, $Sentinel];
      expandSelectionToCell[nb];
      NotebookWrite[nb,
        NotebookRead[nb]
          /. $Sentinel ->
            Cell[BoxData[
              TooltipBox[Cell[latest, "ModInfo", flag], verlist]
            ]]
      ]
      ,
      NotebookWrite[nb,
        Cell[BoxData[
          TooltipBox[Cell[latest, "ModInfo", flag], verlist]
        ]]
      ]
    ];
  ];

ProcessModInfoNewFormat[
  nb_NotebookObject,
  label_String,
  options: OptionsPattern[VersionAnnotate]
] :=
  Module[
    {data, verlist, latest, flip, newdata},
    Catch[
      FrontEndTokenExecute[nb, "ExpandSelection"];
      data = NotebookRead[nb];
      If[Head[data] =!= TooltipBox,
        MessageToConsole[VersionAnnotate::badmodinfo];
        Throw[$Failed]
      ];
      verlist = Last[data];
      {verlist, latest} = UpdateVersionHistory[verlist, label];
      flip =
        Switch[ParseFlaggingOptions[latest, options],
          "BrightFlag",
            Cell[c_, s: "ModInfo", ___] :> Cell[c, s, "BrightFlag"],
          "BrighterFlag",
            Cell[c_, s: "ModInfo", ___] :> Cell[c, s, "BrighterFlag"],
          None,
            Cell[c_, s: "ModInfo", ___] :> Cell[c, s],
          Inherited,
            {}
        ];
      newdata =
        data /. flip
          /. Cell[_, etc___] :> Cell[latest, etc]
          /. TooltipBox[c_, _] :> TooltipBox[c, verlist];
      NotebookWrite[nb, newdata];
      FrontEndTokenExecute[nb, "MovePrevious"];
      FrontEndTokenExecute[nb, "MovePrevious"];
    ]
  ];

(* newver == " " is a call to clear the history. *)
(* WARNING:  Keep this definition before others to give it precedence. *)
UpdateVersionHistory[
  _,
  newver_String /; StringMatchQ[newver, WhitespaceCharacter ...]
] := {" ", " "};
  (* NOTE: Do *not* want these to be empty strings (i.e., {"", ""}),
  since that seems to cause the TooltipBox to be stripped (!?). *)

UpdateVersionHistory[oldvers_String, newver_String] :=
  Module[{verlist, latest},
    verlist = StringSplit[oldvers, ","];
    {verlist, latest} = UpdateVersionHistory[verlist, newver];
    {StringJoin @@ Riffle[verlist, ","], latest}
  ];

UpdateVersionHistory[oldvers: {___String}, newver_String] :=
  Module[{verlist},
    verlist = Append[oldvers, newver] /. {
      s_String /; StringMatchQ[s, WhitespaceCharacter...] :> Sequence[],
      s_String /; StringMatchQ[s, WhitespaceCharacter... ~~ "F"] :> "F"
    };
    (* Sort ("F"'s end up last). *)
    verlist = Sort[verlist];
    (* Split out version number from suffix. *)
    verlist = {StringDrop[#, -1], StringTake[#, -1]}& /@ verlist;
    (* Remove redundancies, with precedence of  x > + > ~. *)
    verlist = verlist /. {
      {a___, PatternSequence[x: {c_, "+"}, {c_, "~"}], b___} :> {a, x, b},
      {a___, PatternSequence[{c_, "~"}, x: {c_, "x"}], b___} :> {a, x, b},
      {a___, PatternSequence[{c_, "+"}, x: {c_, "x"}], b___} :> {a, x, b},
      {a___, PatternSequence[x_, x_], b___} :> {a, x, b}
    };
    (* Recombine version number and suffix. *)
    verlist = StringJoin @@@ verlist;
    (* Return values (with "latest" adjusted for special "F" case). *)
    {verlist, Last[verlist] /. "F" -> " F"}
  ];


VersionAnnotateHistory::badlabel = "VersionAnnotate was called within a
\"History\" cell, but the label (`1`) did not end in \"+\", \"~\", or
\"x\".  This last character determines which field will be set (New,
Modified, or Obsolete, respectively).";

$FutureCell = Cell["F  U  T  U  R  E", "FutureFlag"];

(*
  First, the case for clearing settings.
  This must be defined *before* the general, set-a-label case below.
  Else, it is overridden by it.
*)
VersionAnnotateHistory[
  "ClearAllModInfoSettings",
  flag: (None | "BrightFlag" | "BrighterFlag" | Inherited)
] :=
  Module[
    {
      nb = InputNotebook[],
      delim = "|",
      oldStyleDef, result, info, inNew
    },
    oldStyleDef = SetStyleDef[nb, Editable -> True, "History"];
      (* ...to allow navigation moves to work. *)
    result =
      Catch[
        info = CellInfo[nb];
        If[Head[info] =!= List
            || Length[info] != 1
            || !MemberQ[{"History", "HistoryData"},
                ("Style" /. First[info] /. "Style" -> None)]
          ,
          MessageToConsole[DocuTools::badsel,
            "VersionAnnotateHistory", "\"History\" cell"];
          Throw[$Failed]
        ];
        If[("CursorPosition" /. First[info]
            /. "CursorPosition" -> None) == "CellBracket",
          Throw[
            VersionAnnotateHistoryClearAll[flag]
          ]
        ];
        info = SelectWithinDelimiters[nb, delim];
        If[info === $Failed,
          MessageToConsole[DocuTools::badsel,
            "VersionAnnotateHistory", "\"History\" cell"];
          Throw[$Failed]
        ];
        SelectionMove[nb, All, CellContents];
        inNew =
          ("InlineCellPosition" /. First[CellInfo[nb]]
            /. "InlineCellPosition" -> None) === {9};
          (* ...a bit of a kludge to detect the first, "New in:"
            column, since we can't read the CellTags of inline cells. *)
        NotebookWrite[nb, If[inNew, "XX", " "]];
        (* The "Flag" option only takes affect on "New" settings. *)
        If[flag =!= Inherited && inNew,
          If[MemberQ[{"BrightFlag", "BrighterFlag"}, flag]
            ,
            If[NotebookFind[nb, "FutureFlag", All, CellStyle] === $Failed,
              SelectionMove[nb, Before, Notebook];
              NotebookWrite[nb, $FutureCell]
            ];
            SetOptions[nb, ScreenStyleEnvironment -> "FutureObject"];
            ,
            If[NotebookFind[nb, "FutureFlag", All, CellStyle] =!= $Failed,
              SetOptions[NotebookSelection[nb], Deletable -> True];
              NotebookDelete[nb]
            ];
            SetOptions[nb, ScreenStyleEnvironment -> "Preview"];
              (* ...a kludge, so FE updates correctly. *)
            SetOptions[nb, ScreenStyleEnvironment -> Inherited];
          ];
        ];
        (* Leave selection on the cell, so operation can cycle. *)
        NotebookFind[nb, "History", All, CellStyle];
      ];
    RestoreStyleDef[nb, oldStyleDef];
    result
  ];

VersionAnnotateHistoryClearAll[
  flag: (None | "BrightFlag" | "BrighterFlag" | Inherited)
] :=
  Module[
    {
      nb = InputNotebook[],
      data
    },
    (* Read the line, wipe all cell contents, and rewrite. *)
    data = OldNotebookRead[nb];
    data = data /. {
        Cell[_, s: "HistoryData", a___, t: (CellTags -> "New"), z___]
          :> Cell["XX", s, a, t, z],
        Cell[_, s: "HistoryData", rest___] :> Cell[" ", s, rest]
      };
    NotebookWrite[nb, data];
    (* And apply the "Flag" option. *)
    If[flag =!= Inherited,
      If[MemberQ[{"BrightFlag", "BrighterFlag"}, flag]
        ,
        If[NotebookFind[nb, "FutureFlag", All, CellStyle] === $Failed,
          SelectionMove[nb, Before, Notebook];
          NotebookWrite[nb, $FutureCell]
        ];
        SetOptions[nb, ScreenStyleEnvironment -> "FutureObject"];
        ,
        If[NotebookFind[nb, "FutureFlag", All, CellStyle] =!= $Failed, 
          SetOptions[NotebookSelection[nb], Deletable -> True];
          NotebookDelete[nb]
        ];
        SetOptions[nb, ScreenStyleEnvironment -> "Preview"];
          (* ...a kludge, so FE updates correctly. *)
        SetOptions[nb, ScreenStyleEnvironment -> Inherited];
      ];
    ];
    (* Leave selection on the cell, so operation can cycle. *)
    NotebookFind[nb, "History", All, CellStyle];
  ];

(*
  The general, set-a-label case.
  Keep this *after* the "ClearAllModInfoSettings" case above, else this
  overrides it.
*)
VersionAnnotateHistory[
  label_String,
  flag: (None | "BrightFlag" | "BrighterFlag" | Inherited)
] :=
  Module[
    {
      nb = InputNotebook[],
      info, version, suffix, tag, data
    },
    info = CellInfo[nb];
    If[Head[info] =!= List
        || Length[info] != 1
        || !MemberQ[{"History", "HistoryData"},
            ("Style" /. First[info] /. "Style" -> None)]
      ,
      MessageToConsole[DocuTools::badsel,
        "VersionAnnotateHistory", "\"History\" cell"];
      Return[$Failed]
    ];
    (* Seperate out the version number and the suffix from the label.
      (The latter determines which field to change.) *)
    If[StringMatchQ[label, WhitespaceCharacter... ~~ "F"]
      ,
      version = "F"; tag = "New";
      ,
      version = GetVersionFromLabel[label];
      If[version === $Failed,
        MessageToConsole[VersionAnnotateHistory::badlabel, label];
        Return[$Failed]
      ];
      suffix = GetSuffixFromLabel[label];
      tag =
        Switch[suffix,
          "+", "New",
          "~", "Modified",
          "x", "Obsolete",
          _,   None
        ];
    ];
    (* Expand out to the cell (twice, in case we're in an inline cell). *)
    SelectionMove[nb, All, Cell, 2];
    (* Read the line, change the target cell, and rewrite. *)
    data = OldNotebookRead[nb];
    data = data /. 
      Cell[_, s: "HistoryData", a___, t: (CellTags -> tag), z___]
        :> Cell[ToString[version], s, a, t, z];
    NotebookWrite[nb, data];
    (* The "Flag" option only takes affect on "New" settings. *)
    If[flag =!= Inherited && tag == "New",
      If[MemberQ[{"BrightFlag", "BrighterFlag"}, flag]
        ,
        If[NotebookFind[nb, "FutureFlag", All, CellStyle] === $Failed,
          SelectionMove[nb, Before, Notebook];
          NotebookWrite[nb, $FutureCell]
        ];
        SetOptions[nb, ScreenStyleEnvironment -> "FutureObject"];
        ,
        If[NotebookFind[nb, "FutureFlag", All, CellStyle] =!= $Failed, 
          SetOptions[NotebookSelection[nb], Deletable -> True];
          NotebookDelete[nb]
        ];
        SetOptions[nb, ScreenStyleEnvironment -> "Preview"];
          (* ...a kludge, so FE updates correctly. *)
        SetOptions[nb, ScreenStyleEnvironment -> Inherited];
      ];
    ];
    (* Leave selection on the cell, so operation can cycle. *)
    NotebookFind[nb, "History", All, CellStyle];
  ];


(*
  Which cell styles to treat (for purposes of version marking) as delimited
  elements (i.e., only the BrightFlag will be present (or not) on the
  selected element).
*)
$DelimitedStyles =
  {"SeeAlso", "InlineGuideFunctionListing"};

VersionAnnotateDelimited[
  flag: (None | "BrightFlag" | "BrighterFlag" | Inherited)
] :=
  Module[
    {
      nb = InputNotebook[],
      delim = "\[EmptyVerySmallSquare]",
      FlagON, FlagOFF, AssureSelection,
      result
    },
    (* Utility functions *)
    FlagON[sty_] := (
      AssureSelection[];
      If[FreeQ[result, sty], ButtonStyleApply[sty, ToggleAppend -> True]]
    );
    FlagOFF[sty_] := (
      AssureSelection[];
      If[!FreeQ[result, sty], ButtonStyleApply[sty, ToggleAppend -> True]]
    );
    AssureSelection[] := (
      FrontEndTokenExecute[nb, "MovePrevious"];
      FrontEndTokenExecute[nb, "MoveNext"];
      SelectionMove[nb, All, Cell];
    );
    (**)
    result = SelectWithinDelimiters[nb, delim];
    If[result === $Failed,
      MessageToConsole[DocuTools::badsel,
        "VersionAnnotateDelimited",
        "formatted delimited (" <>
          StringJoin @@
            Riffle[("\"" <> # <> "\"")& /@ $DelimitedStyles, ", "]
          <>") cell"];
      Return[$Failed]
    ];
    (* Check if flag already present. *)
    SelectionMove[nb, All, Cell];
    result = OldNotebookRead[nb];
    Switch[flag,
      None,
        FlagOFF["BrightFlag"];  FlagOFF["BrighterFlag"],
      "BrightFlag",
        FlagON["BrightFlag"];   FlagOFF["BrighterFlag"],
      "BrighterFlag",
        FlagON["BrighterFlag"]; FlagOFF["BrightFlag"],
      Inherited,
        Null
    ];
    (* Leave selection after the button. *)
    FrontEndExecute[{
      FrontEnd`FrontEndToken[nb, "MoveNext"]
    }];
  ];
  
  
VersionAnnotateNew::noin = "There is no input notebook.";
VersionAnnotateNew::mulcell = "Multiple cells have been selected.";
VersionAnnotateNew::cellbrac = "Handling of setting and modifying ModInfo for entire Tables and Usage cells has not been implemented yet. Insert the cursor into the relevant parts of the cell to set/modify ModInfo.";
VersionAnnotateNew::otherding = "The cell already has an explicit cell dingbat so ModInfo cannot be added.";
VersionAnnotateNew::notstrinfo = "The modinfo data in the cell is not a string.";
VersionAnnotateNew::structerr = "The modinfo construct present in the cell is defective.";
VersionAnnotateNew::Fplus = "`1` must be \[GreaterEqual] `2` since the modinfo is F.";
VersionAnnotateNew::notnewer = "The tooltip says new in `1` so it cannot be newer in an older version.";
VersionAnnotateNew::new = "If its new in `1`, it cannot be new in a later version.";
VersionAnnotateNew::new2 = "If it is modified in `1`, it cannot be new in an equal or later version.";
VersionAnnotateNew::obs1 = "Since it is marked obsolete, it cannot marked new in some version.";
VersionAnnotateNew::notmod = "Since it is marked future it cannot be marked modified.";
VersionAnnotateNew::onlyfut = "Can only be marked modified in a version greater than `1`.";
VersionAnnotateNew::wasnewin = "Could not be modified in `1` since it was new in `1`.";
VersionAnnotateNew::obs2 = "It cannot be marked obsolete since it was never in a version.";
VersionAnnotateNew::obs3 = "Since it is new in `1`, it cannot be obsolete in a version \[LessEqual] `1`.";
VersionAnnotateNew::modified = "Cannot be made obsolete since modified in `1`.";
VersionAnnotateNew::obs4 = "Since it was obsolete in `1`, it cannot be made obsolete in a version < `1`.";
VersionAnnotateNew::obs5 = "Since it was obsolete in `1`, it cannot be made obsolete in a newer version.";
VersionAnnotateNew::Fplus2 = "Cannot be marked F since it was new in `1`.";
VersionAnnotateNew::FTilde = "Cannot be marked F since it was modified in `1`.";
VersionAnnotateNew::FObs = "Cannot be marked F since it was obsolete in `1`.";

VersionAnnotateNew::nohist = "There are no history cells in the input notebook.";
VersionAnnotateNew::histstruc = "The history cell has the wrong structure.";
VersionAnnotateNew::wronghisdata = "One of more of the elements in the history cell is not of the correct type: number, F (just under New in:), white space or a concatenation of X's.";
VersionAnnotateNew::obs6 = "Since it is marked excised or obsolete, it cannot marked new in some version.";

GenerateVersionAnnotateProceedDialog[annotation_] := 
 Module[{annotation1}, 
  NotebookPut@Notebook[{Cell["", FontSize -> 1, CellElementSpacings -> {"CellMinHeight" -> 1}], 
     Cell[TextData[{"In the input notebook nothing was selected. Therefore VersionAnnotate will attempt to update the history cell."}],
          FontFamily -> "Vedana"], 
     Cell["", FontSize -> 1, CellElementSpacings -> {"CellMinHeight" -> 1}], 
     Cell[BoxData[ToBoxes[Grid[{{Button[Style["OK", Bold], 
                                        VersionAnnotateProceed[annotation1]; NotebookClose[], Method -> "Queued"] /. annotation1 -> annotation, 
                                 Button[Style["Cancel", Bold], NotebookClose[]]}}]]], 
          CellContext -> "Global`"], 
     Cell["", FontSize -> 1, CellElementSpacings -> {"CellMinHeight" -> 1}]}, 
                       WindowMargins -> {{Automatic, Automatic}, {Automatic, Automatic}},
                       WindowToolbars -> {}, 
                       WindowFrameElements -> {}, 
                       ShowCellBracket -> False, 
                       ClosingAutoSave -> False, 
                       WindowTitle -> "Annotate Proceed", 
                       Saveable -> False, 
                       ShowStringCharacters -> False, 
                       Selectable -> False, 
                       WindowSize -> {250, 120}, 
                       WindowFrame -> "Palette", 
                       ScrollingOptions -> {}, 
                       WindowElements -> {}]]
                       
VersionAnnotateProceed[annotation_String] := 
 Module[{nb = NextNotebook[], re, newin, modifiedin, obsoletein, excisedin, rules, sortedrules, m, n}, 
  Catch[If[nb === $Failed, Throw[MessageToConsole[VersionAnnotateNew::noin]]];
  
        If[NotebookFind[nb, "History", All, CellStyle] === $Failed, Throw[MessageToConsole[VersionAnnotateNew::nohist]]]; 
        
        re = NotebookRead[nb];
        If[Not@MatchQ[re, Cell[TextData[{"New in: ", Cell[_String, "HistoryData", CellTags -> "New"], " | Modified in: ", 
                            Cell[_String, "HistoryData", CellTags -> "Modified"], " | Obsolete in: ", Cell[_String, "HistoryData", CellTags -> "Obsolete"], 
                                                                " | Excised in: ", Cell[_String, "HistoryData", CellTags -> "Excised"]}], "History", ___]], 
           Throw[MessageToConsole[VersionAnnotateNew::histstruc]]];
           
        {newin, modifiedin, obsoletein, excisedin} = StringTrim /@ Cases[re, 
                                                              Cell[d_, "HistoryData", CellTags -> ("New" | "Modified" | "Obsolete" | "Excised")] :> d, 3];
                                                              
        If[Not[And @@ (StringMatchQ[#, NumberString] & /@ DeleteCases[{newin, modifiedin, obsoletein, excisedin}, 
                                          x_String /; StringMatchQ[x, "" | "X" ..]]) || {newin, modifiedin, obsoletein, excisedin} === {"F", "", "", ""}], 
           Throw[MessageToConsole[VersionAnnotateNew::wronghisdata]]];
           
        If[(* The History cell is essentially empty so just insert the annotation. *)
           And @@ (StringMatchQ[#, "" | "X" ..] & /@ {newin, modifiedin, obsoletein, excisedin}),
           
           Which[StringMatchQ[annotation, __ ~~ "+"],
           
                 NotebookWrite[nb, 
                   re /. Cell[_, "HistoryData", CellTags -> "New"] -> Cell[StringReplace[annotation, "+" -> ""], "HistoryData", CellTags -> "New"], All], 
                   
                 StringMatchQ[annotation, __ ~~ "~"],
                 
                 NotebookWrite[nb, 
                   re /. Cell[_, "HistoryData", CellTags -> "Modified"] -> Cell[StringReplace[annotation, "~" -> ""], 
                                                                                "HistoryData", CellTags -> "Modified"], All],
                                                                                
                 StringMatchQ[annotation, __ ~~ "x"], 
                 
                 NotebookWrite[nb, 
                   re /. Cell[_, "HistoryData", CellTags -> "Obsolete"] -> Cell[StringReplace[annotation, "x" -> ""], 
                                                                                "HistoryData", CellTags -> "Obsolete"], All], 
                                                                                
                 annotation === "F",
                 
                 NotebookWrite[nb, 
                   re /. Cell[_, "HistoryData", CellTags -> "New"] -> Cell["F", "HistoryData", CellTags -> "New"], All]],
                   
           rules = MapThread[Rule, {{"newin", "modifiedin", "obsoletein", "excisedin"}, {newin, modifiedin, obsoletein, excisedin}}];
           sortedrules = Sort[DeleteCases[rules, _ -> x_ /; StringMatchQ[x, "" | "X" ..]], OrderedQ[{ToExpression[#1[[2]]], ToExpression[#2[[2]]]}] &];
           
           Which[StringMatchQ[annotation, __ ~~ "+"],
           
                 n = StringReplace[annotation, "+" -> ""];
                 
                 Which[sortedrules[[-1]] === ("newin" -> "F"),
                 
                       If[ToExpression@n < $FlaggedVersion, 
                          MessageToConsole[VersionAnnotateNew::Fplus, n], 
                          NotebookWrite[nb, 
                                        Cell[TextData[{"New in: ", Cell[n, "HistoryData", CellTags -> "New"], " | Modified in: ",
                                                       Cell[" ", "HistoryData", CellTags -> "Modified"], " | Obsolete in: ", 
                                                       Cell[" ", "HistoryData", CellTags -> "Obsolete"], " | Excised in: ", 
                                                       Cell[" ", "HistoryData", CellTags -> "Excised"]}], "History"], 
                                        All]],
                                        
                       MatchQ[sortedrules[[-1]], "newin" -> _],
                       
                       m = sortedrules[[-1, 2]]; 
                       Which[ToExpression@n < ToExpression@m, 
                             MessageToConsole[VersionAnnotateNew::notnewer, m], 
                             n === m,
                             Null,
                             ToExpression@n > ToExpression@m, 
                             MessageToConsole[VersionAnnotateNew::new, m]],
                             
                       MatchQ[sortedrules[[-1]], "modifiedin" -> _],
                       
                       m = sortedrules[[-1, 2]];
                       Which[ToExpression@n < ToExpression@m, 
                             NotebookWrite[nb, 
                                           re /. Cell[_, "HistoryData", CellTags -> "Modified"] -> Cell[n, "HistoryData", CellTags -> "Modified"]], 
                             ToExpression@n >= ToExpression@m, 
                             MessageToConsole[VersionAnnotateNew::new2, m]],
                             
                       MatchQ[sortedrules[[-1]], "obsoletein" | "excisedin" -> _],
                       
                       MessageToConsole[VersionAnnotateNew::obs1]],
                       
                 StringMatchQ[annotation, __ ~~ "~"],
                 
                 n = StringReplace[annotation, "~" -> ""];
                 
                 Which[MatchQ[sortedrules, {"newin" -> "F", __}],
                 
                       MessageToConsole[VersionAnnotateNew::notmod],
                       
                       MatchQ[sortedrules[[-1]], "newin" -> _],
                       
                       m = sortedrules[[-1, 2]]; 
                       If[ToExpression@n <= ToExpression@m, 
                          MessageToConsole[VersionAnnotateNew::onlyfut, m], 
                          NotebookWrite[nb, re /. Cell[_, "HistoryData", CellTags -> "Modified"] -> Cell[n, "HistoryData", CellTags -> "Modified"]]],
                          
                       MatchQ[sortedrules[[-1]], "modifiedin" -> _],
                       
                       m = sortedrules[[-1, 2]];
                       Which[ToExpression@n <= ToExpression@m, 
                             Null, 
                             n > m, 
                             NotebookWrite[nb, re /. Cell[_, "HistoryData", CellTags -> "Modified"] -> Cell[n, "HistoryData", CellTags -> "Modified"]]],
                             
                       MatchQ[sortedrules[[-1]], "obsoletein" | "excisedin" -> _],
                             
                       MessageToConsole[VersionAnnotateNew::obs6]],
                       
                 StringMatchQ[annotation, __ ~~ "x"],
                 
                 n = StringReplace[annotation, "x" -> ""];
                 
                 Which[MatchQ[sortedrules[[-1]], "newin" -> "F"],
                 
                       MessageToConsole[VersionAnnotateNew::obs2],
                       
                       MatchQ[sortedrules[[-1]], "newin" -> _],
                       
                       m = sortedrules[[-1, 2]]; 
                       If[ToExpression@n <= ToExpression@m, 
                          MessageToConsole[VersionAnnotateNew::obs3, m], 
                          NotebookWrite[nb, re /. Cell[_, "HistoryData", CellTags -> "Obsolete"] -> Cell[n, "HistoryData", CellTags -> "Obsolete"]]],
                          
                       MatchQ[sortedrules[[-1]], "newin" -> _],
                       
                       m = sortedrules[[-1, 2]]; 
                       If[ToExpression@n <= ToExpression@m, 
                          MessageToConsole[VersionAnnotateNew::modified, m], 
                          NotebookWrite[nb, re /. Cell[_, "HistoryData", CellTags -> "Obsolete"] -> Cell[n, "HistoryData", CellTags -> "Obsolete"]]],
                          
                       MatchQ[sortedrules[[-1]], "obsoletein" | "excisedin" -> _],
                       
                       m = sortedrules[[-1, 2]];
                       Which[ToExpression@n < ToExpression@m, 
                             MessageToConsole[VersionAnnotateNew::obs4, m], 
                             ToExpression@n > ToExpression@m, 
                             MessageToConsole[VersionAnnotateNew::obs5, m]]],
                             
                 annotation === "F",
                 
                 Which[MatchQ[sortedrules[[-1]], "newin" -> "F"], 
                 
                       Null,
                       
                       MatchQ[sortedrules[[-1]], "newin" -> _],
                       
                       m = sortedrules[[-1, 2]];
                       If[ToExpression@m < $FlaggedVersion, 
                          MessageToConsole[VersionAnnotateNew::Fplus2, m], 
                          NotebookWrite[nb, re /. Cell[_, "HistoryData", CellTags -> "New"] -> Cell["F", "HistoryData", CellTags -> "New"]]],
                          
                       MatchQ[sortedrules[[-1]], "modifiedin" -> _],
                       
                       m = sortedrules[[-1, 2]];
                       MessageToConsole[VersionAnnotateNew::FTilde, m],
                       
                       MatchQ[sortedrules[[-1]], "obsoletein" | "excisedin" -> _],
                       
                       m = sortedrules[[-1, 2]];
                       MessageToConsole[VersionAnnotateNew::FObs, m]]]]]]

VersionAnnotateNew[annotation_String] := 
 Module[{nb = InputNotebook[], ci, style, re, celldingbat, $ModInfoList, modinfolist, modinfolist2, modinfosorted, m, n},
  Catch[If[nb === $Failed, Throw[MessageToConsole[VersionAnnotateNew::noin]]];
  
        ci = CellInfo[nb];
        
        If[(* The cursor in not inside the input notebook or between cells in the input notebook. *)
           ci === $Failed, 
           Throw[GenerateVersionAnnotateProceedDialog[annotation]]];
        
        If[multipleCellBracketsSelected[ci], Throw[MessageToConsole[VersionAnnotateNew::mulcell]]];
        
        If[(* The cursor is at the cell bracket. *)
           ("CursorPosition" /. ci) === {"CellBracket"} && MemberQ[List /@ {"Usage", "2ColumnTableMod", "3ColumnTableMod"}, ("Style" /. ci)], 
           Throw[MessageToConsole[VersionAnnotateNew::cellbrac]]];
           
        (* SetOptions[$FrontEnd,ShowSelection->False]; *)
        
        If[(* The cursor is inside a ModInfo cell. *)
           ("Style" /. ci) === {"ModInfo"} && NotebookRead[nb] === {}, 
           SelectionMove[nb, All, Cell];
           FrontEndExecute[{FrontEndToken[nb, "MoveNext"]}]];
            
        If[(* The cursor is selecting part of a ModInfo cell. *)
           MatchQ[NotebookRead[nb], Cell[_, "ModInfo", ___]], 
           FrontEndExecute[{FrontEndToken[nb, "MoveNext"]}]];
           
        ci = CellInfo[nb];
        
        If[Cases[ci, a : ("InlineCellPosition" -> _), Infinity] =!= {}, 
           While[(* The cursor is in an inline cell. *)
                 Cases[ci, a : ("InlineCellPosition" -> _), Infinity] =!= {}, 
                 FrontEndExecute[{FrontEnd`FrontEndToken[nb, "ExpandSelection"]}];
                 ci = CellInfo[nb]]];
                 
        style = If[ListQ[#], #[[1]], #] &[("Style" /. CellInfo[nb])[[1]]];
         
        ExpandToCell[nb];
        re = NotebookRead[nb];
        celldingbat = If[# === {}, {}, #[[1]]] &@Cases[re, a : (CellDingbat -> t_) :> t];
         
        If[celldingbat =!= {} && Not[MatchQ[celldingbat, TooltipBox[Cell[_String, "ModInfo"], _String | {_String, _String}]]], 
           Throw[MessageToConsole[VersionAnnotateNew::otherding]]];
            
        If[celldingbat === {}, 
           Throw[SetOptions[NotebookSelection[nb], CellDingbat -> TooltipBox[Cell[annotation, "ModInfo"], annotation]]]];
           
        (* $ModInfoList is a flag to specify whether a tooltip is tententative or not. *)$ModInfoList = False;
        
        modinfolist = If[# === {}, {}, #[[1]]] &@Cases[celldingbat, 
                                                       TooltipBox[Cell[_, "ModInfo"], b_] :> If[ListQ[b], $ModInfoList = True; b[[2]], b], {0}];
                                                       
        If[Not@StringQ[modinfolist], 
           Throw[MessageToConsole[VersionAnnotateNew::notstrinfo]], 
           modinfolist2 = StringSplit[StringTrim[modinfolist], ","]];
           
        If[Not[And @@ (StringMatchQ[#, NumberString ~~ ("+" | "~" | "x")] & /@ modinfolist2) || modinfolist2 === {"F"}], 
           Throw[MessageToConsole[VersionAnnotateNew::structerr]]];
           
        modinfosorted = Sort[modinfolist2, OrderedQ[StringReplace[#, {"+" -> "", "~" -> "", "x" -> ""}] & /@ {#1, #2}] &];
        
        Which[(* ModInfo to apply has form n+ *)
              StringMatchQ[annotation, __ ~~ "+"],
              
              n = StringReplace[annotation, "+" -> ""]; 
              Which[(* ModInfo present is "F" *)
                    modinfolist2 === {"F"},
                    
                    If[ToExpression@n < $FlaggedVersion, 
                       MessageToConsole[VersionAnnotateNew::Fplus, n, $FlaggedVersion],
                       celldingbat = TooltipBox[Cell[annotation, "ModInfo"], If[$ModInfoList, {$UserName, #}, #] &[annotation]]; 
                       SetOptions[NotebookSelection[nb], CellDingbat -> celldingbat]],
                       
                    (* Largest value of tooltip has form m+. *)
                    StringMatchQ[modinfosorted[[-1]], __ ~~ "+"],
                    
                    m = StringReplace[modinfosorted[[-1]], "+" -> ""]; 
                    Which[ToExpression@n < ToExpression@m, 
                          MessageToConsole[VersionAnnotateNew::notnewer, m], 
                          n === m, 
                          Null, 
                          ToExpression@n > ToExpression@m, 
                          MessageToConsole[VersionAnnotateNew::new, m]],
                          
                    (* Largest value of tooltip has form m~. *)
                    StringMatchQ[modinfosorted[[-1]], __ ~~ "~"],
                    
                    m = StringReplace[modinfosorted[[-1]], "~" -> ""]; 
                    Which[ToExpression@n < ToExpression@m, 
                          celldingbat = TooltipBox[Cell[n <> "+", "ModInfo"], 
                          If[$ModInfoList, {$UserName, #}, #] &[StringJoin @@ Riffle[Append[modinfosorted, n <> "+"], ","]]];
                          SetOptions[NotebookSelection[nb], CellDingbat -> celldingbat], 
                          ToExpression@n >= ToExpression@m, 
                          MessageToConsole[VersionAnnotateNew::new2, m]],
                          
                    (* Largest value of tooltip has form mx. *)
                    StringMatchQ[modinfosorted[[-1]], __ ~~ "x"],
                    
                    MessageToConsole[VersionAnnotateNew::obs1]],
                    
              (* ModInfo to apply has form n~ *)
              StringMatchQ[annotation, __ ~~ "~"],
              
              n = StringReplace[annotation, "~" -> ""]; 
              Which[modinfolist2 === {"F"},
              
                    MessageToConsole[VersionAnnotateNew::notmod],
                    
                    (* Largest value of tooltip has form m+. *)
                    StringMatchQ[modinfosorted[[-1]], __ ~~ "+"],
                    
                    m = StringReplace[modinfosorted[[-1]], "+" -> ""]; 
                    If[ToExpression@n <= ToExpression@m, 
                       MessageToConsole[VersionAnnotateNew::onlyfut, m], 
                       celldingbat = TooltipBox[Cell[n <> "+", "ModInfo"], 
                                                If[$ModInfoList, {$UserName, #}, #] &[StringJoin @@ Riffle[Append[modinfosorted, n <> "+"], ","]]];
                       SetOptions[NotebookSelection[nb], CellDingbat -> celldingbat]],
                       
                    (* Largest value of tooltip has form m~. *)
                    StringMatchQ[modinfosorted[[-1]], __ ~~ "~"],
                    
                    m = StringReplace[modinfosorted[[-1]], "~" -> ""];
                    Which[ToExpression@n < ToExpression@m,
                    
                          Which[MemberQ[modinfolist2, n <> "~"],
                                Null, 
                                MemberQ[modinfolist2, n <> "+"], 
                                MessageToConsole[VersionAnnotateNew::wasnewin, n],
                                True, 
                                celldingbat = TooltipBox[celldingbat[[1]], 
                                                         If[$ModInfoList, 
                                                            {$UserName, #}, 
                                                            #] &[StringJoin @@ Riffle[Sort[Append[modinfosorted, n <> "~"], 
                                                                                           OrderedQ[StringReplace[#, 
                                                                                           {"+" -> "", "~" -> "", "x" -> ""}] & /@ {#1, #2}] &], ","]]]; 
                                SetOptions[NotebookSelection[nb], CellDingbat -> celldingbat]],
                                
                          n === m, 
                          
                          Null, 
                          
                          ToExpression@n > ToExpression@m,
                          
                          
                          celldingbat = TooltipBox[Cell[n <> "~", "ModInfo"], If[$ModInfoList, 
                                                                                 {$UserName, #}, 
                                                                                 #] &[StringJoin @@ Riffle[Append[modinfosorted, n <> "~"], ","]]];
                          SetOptions[NotebookSelection[nb], CellDingbat -> celldingbat]],
                          
                    (* Largest value of tooltip has form mx. *)
                    StringMatchQ[modinfosorted[[-1]], __ ~~ "x"],
                    
                    MessageToConsole[VersionAnnotateNew::obs1]],
                    
              (* ModInfo to apply has form nx *)
              StringMatchQ[annotation, __ ~~ "x"],
              
              n = StringReplace[annotation, "x" -> ""];
              Which[modinfolist2 === {"F"},
              
                    MessageToConsole[VersionAnnotateNew::obs2],
                    
                    (* Largest value of tooltip has form m+. *)
                    StringMatchQ[modinfosorted[[-1]], __ ~~ "+"],
                    
                    m = StringReplace[modinfosorted[[-1]], "+" -> ""]; 
                    If[ToExpression@n <= ToExpression@m,
                    
                       MessageToConsole[VersionAnnotateNew::obs3, m],
                       
                       celldingbat = TooltipBox[Cell[n <> "x", "ModInfo"], 
                                                If[$ModInfoList, {$UserName, #}, #] &[StringJoin @@ Riffle[Append[modinfosorted, n <> "x"], ","]]];
                       SetOptions[NotebookSelection[nb], CellDingbat -> celldingbat]],
                       
                    (* Largest value of tooltip has form m~. *)
                    StringMatchQ[modinfosorted[[-1]], __ ~~ "~"],
                    
                    m = StringReplace[modinfosorted[[-1]], "~" -> ""]; 
                    If[ToExpression@n <= ToExpression@m,
                    
                       MessageToConsole[VersionAnnotateNew::modified, m],
                       
                       celldingbat = TooltipBox[Cell[n <> "x", "ModInfo"], 
                                                If[$ModInfoList, {$UserName, #}, #] &[StringJoin @@ Riffle[Append[modinfosorted, n <> "x"], ","]]];
                       SetOptions[NotebookSelection[nb], CellDingbat -> celldingbat]],
                       
                    (* Largest value of tooltip has form mx. *)
                    StringMatchQ[modinfosorted[[-1]], __ ~~ "x"],
                    
                    m = StringReplace[modinfosorted[[-1]], "x" -> ""];
                    Which[ToExpression@n < ToExpression@m, 
                          MessageToConsole[VersionAnnotateNew::obs4, m], 
                          ToExpression@n > ToExpression@m, 
                          MessageToConsole[VersionAnnotateNew::obs5, m]]],
                          
              annotation === "F",
              
              Which[modinfosorted[[-1]] === {"F"},
              
                    (* F is in modinfo cell-- do nothing *)
                    Null,
                    
                    (* Largest value of tooltip has form m+. *)
                    StringMatchQ[modinfosorted[[-1]], __ ~~ "+"],
                    
                    m = StringReplace[modinfosorted[[-1]], "+" -> ""];
                    If[ToExpression@m < $FlaggedVersion,
                    
                       MessageToConsole[VersionAnnotateNew::Fplus2, m],
                       
                       celldingbat = TooltipBox[Cell["F", "ModInfo"], If[$ModInfoList, {$UserName, #}, #] &[{"F"}]]; 
                       SetOptions[NotebookSelection[nb], CellDingbat -> celldingbat]],
                       
                    (* Largest value of tooltip has form m~. *)
                    StringMatchQ[modinfosorted[[-1]], __ ~~ "~"],
                    
                    m = StringReplace[modinfosorted[[-1]], "~" -> ""];
                    MessageToConsole[VersionAnnotateNew::FTilde, m],
                    
                    (* Largest value of tooltip has form mx. *)
                    StringMatchQ[modinfosorted[[-1]], __ ~~ "x"],
                    
                    m = StringReplace[modinfosorted[[-1]], "x" -> ""];
                    MessageToConsole[VersionAnnotateNew::FObs, m]]]]]


$versions =
  ToString /@ {1, 2, 2.1, 3, 3.1, 3.2, 4, 4.1, 4.2, 5, 5.1, 5.2, 6,
    6.1, 6.2, 7, 7.1, 7.2, 8, 8.1, 8.2};


SetAttributes[HistoryEditor, HoldFirst];

HistoryEditor[action_, vers_, flag: (True | False)] :=
  DynamicModule[
    {
      verList, verListPos, theFlag = flag,
      states, curr, (* memory and pointer for UnDo/ReDo *)
      AutoFlagUpdate, Remember,
      $DisplayFields, $FlagCheckbox,
      $NavRightButton, $NavLeftButton, $DeleteButton, $DeleteAllButton,
      $VersionFButton, VersionPopup,
      $OKButton, $CancelButton
    },
    (*----------+
    | Utilities |
    +----------*)
    (*
      Toggles the flag to match the latest version.
    *)
    AutoFlagUpdate[] := (
      theFlag =
        If[Length[verList] == 0
          ,
          False
          ,
          ParseFlaggingOptions[Last[verList], "Flag" -> None,
            "VersionFlagging" -> $FlaggedVersion] === "BrightFlag"
        ];
    );
    (*
      Saves the current state onto the UnDo/ReDo list (states).
    *)
    Remember[] := (
      states = 
        Append[Take[states, curr++], {verList, verListPos, theFlag}];
    );
    (*-----------+
    | Components |
    +-----------*)
    $DisplayFields :=
      Dynamic[
        If[Length[verList] == 0
          ,
          Button["no versions set", Null, Appearance -> "Palette",
            Background -> LightGray, Enabled -> False]
          ,
          Row[
            Riffle[
              MapIndexed[
                Button[#1, verListPos = First[#2],
                  Appearance -> "Palette", ImageSize -> 30,
                  Background -> If[First@#2 == verListPos, White, LightGray]
                ] &,
                verList
              ],
              Spacer[2]
            ]
          ]
        ]
      ];
    $FlagCheckbox :=
      Tooltip[
        Toggler[Dynamic[theFlag],
          MapThread[Rule, {
              {True, False},
              Graphics[{#, EdgeForm[Thin], Rectangle[]}, ImageSize -> 20]&
                /@ {Red, White}
            }
          ]
        ],
        "Click to toggle \"BrightFlag\" on/off.\n"
          <> "(Also automatially updates when appropriate versions\n"
          <> "are added to or deleted from the list above.)"
      ];
    $NavRightButton =
      GenericButton["\[FilledRightTriangle]",
        verListPos = If[verListPos >= Length[verList], 1, verListPos + 1]
      ];
    $NavLeftButton =
      GenericButton["\[FilledLeftTriangle]",
        verListPos = If[verListPos <= 1, Length[verList], verListPos - 1]
      ];
    $DeleteButton =
      GenericButton["Delete",
        verList = Drop[verList, {verListPos}];
        If[verListPos > Length[verList], verListPos = Length[verList]];
        AutoFlagUpdate[]; Remember[];
        ,
        Enabled -> Dynamic[Length[verList] > 0]
      ];
    $DeleteAllButton =
      GenericButton["Delete All",
        verList = {}; verListPos = 0;
        AutoFlagUpdate[]; Remember[];
        ,
        Enabled -> Dynamic[Length[verList] > 0]
      ];
    $UnDoButton =
      GenericButton["UnDo",
        {verList, verListPos, theFlag} = states[[--curr]];,
        Enabled -> Dynamic[curr > 1]
      ];
    $ReDoButton =
      GenericButton["ReDo",
        {verList, verListPos, theFlag} = states[[++curr]];,
        Enabled -> Dynamic[curr < Length[states]]
      ];
    $VersionFButton :=
      GenericButton["F",
        Module[{p},
          verList = First @ UpdateVersionHistory[verList, "F"];
          p = Position[verList, "F"];
          If[Length[p] > 0, verListPos = First @ First @ p];
          AutoFlagUpdate[]; Remember[];
        ]
      ];
    VersionPopup[suffix_] :=
      PopupMenu[
        Dynamic[Null,
          {Null, (
            Module[{p},
              verList = First @ UpdateVersionHistory[verList, #1];
              p = Position[verList, #1];
              If[Length[p] > 0, verListPos = First @ First @ p];
              AutoFlagUpdate[]; Remember[];
            ]
          )&}
        ],
        (# <> suffix)& /@ $versions,
        Null,
        GenericButton[suffix]
      ];
    $OKButton =
      GenericButton["OK",
        ReleaseHold[action][
          If[Length[verList] > 0,
            Last[verList] /. "F" -> " F",
            ""
          ],
          verList,
          theFlag
        ];
        NotebookClose[ButtonNotebook[]];
        FrontEndTokenExecute[InputNotebook[], "MoveNext"];
      ];
    $CancelButton =
      GenericButton[
        "Cancel",
        NotebookClose[ButtonNotebook[]];
        FrontEndTokenExecute[InputNotebook[], "MoveNext"];
      ];
    (*---------------+
    | Initialization |
    +---------------*)
    verList = StringSplit[vers, ","]
      /. s_String /; StringMatchQ[s, WhitespaceCharacter...] :> Sequence[];
    verListPos = 1;
    states = {}; curr = 0; Remember[];
    (*-----------+
    | The Dialog |
    +-----------*)
    Column[{
      $DisplayFields,
      $FlagCheckbox,
      Column[{
        Row[{
            $NavLeftButton, $DeleteButton, $DeleteAllButton, $NavRightButton
          }, Spacer[25]],
        Row[{$UnDoButton, $ReDoButton}, Spacer[10]],
        Row[{
            $VersionFButton,
              VersionPopup["+"], VersionPopup["~"], VersionPopup["x"]
          }, Spacer[10]],
        Row[{$OKButton, $CancelButton}, Spacer[25]]
      }, Center]
    }]
  ];


(*
  OSX enforces a minimum width on "DialogBox" buttons (the default style).
  The following custom rolls some buttons for OSX et al.
*)
SetAttributes[GenericButton, HoldAll];

GenericButton[args___] :=
  Switch[$OperatingSystem,
    "Windows",
      Button[args],
    _,
      Framed[Button[args, Appearance -> "Frameless"], 
        Background -> Lighter[LightGray, 0.75], FrameMargins -> 3]
  ];


SetAttributes[LaunchHistoryEditor, HoldFirst];

LaunchHistoryEditor[action_, vers_, flag_] :=
  CreateDialog[
    HistoryEditor[action, vers, flag],
    WindowTitle -> "Version History Editor",
    WindowSize -> All
  ];


EditVersionHistory[] :=
  Module[
    {
      nb = InputNotebook[],
      info, style
    },
    (* Require initial selection to be within a single cell. *)
    info = CellInfo[nb];
    If[info === $Failed || Length[info] > 1,
      MessageToConsole[DocuTools::badsel, "EditVersionHistory",
        "single cell"];
      Return[$Failed]
    ];
    (* Step outside any InlineFormula cells,
      so we can see the main cell's style. *)
    While[
      info = CellInfo[nb];
      Head[info] === List
        && Length[info] == 1
        && (style = ("Style" /. First[info] /. "Style" -> None);
           MatchQ[style, "InlineFormula" | "InlineGuideFunction"])
      ,
      FrontEndExecute[{FrontEnd`FrontEndToken[nb, "MovePrevious"]}];
    ];
    (* If we're inside a CellDingbat-using cell, pass off elsewhere.
      ($DelimitedStyles are potentially CellDingbat-using, via
      VersionAnnotate w/CellBracket selection. *)
    If[MatchQ[style,
        Alternatives @@ Join[$CellDingbatVersionInfo, $DelimitedStyles]],
      EditVersionHistoryCellDingbat[];
      Return[];
    ];
    (* We're probably in a Usage cell or table of some kind.
      Step leftward in search of a ModInfo cell... *)
    While[
      info = CellInfo[nb];
      info =!= $Failed
        && ("Style" /. First@info /. "Style" -> None) != "ModInfo"
      ,
      FrontEndExecute[{FrontEnd`FrontEndToken[nb, "MovePrevious"]}];
    ];
    (* If we're inside a ModInfo cell, pass off elsewhere. *)
    If[info =!= $Failed,
      EditVersionHistoryModInfo[];
      Return[];
    ];
    (* Else, this is not a supported cell type. *)
    MessageToConsole[VersionAnnotate::unsup];
    Return[$Failed]
  ];

EditVersionHistoryModInfo[] :=
  Module[
    {
      nb = InputNotebook[],
      info, style, data, datanew, cellpos, result
    },
    info = CellInfo[nb];
    style = "Style" /. First[info] /. "Style" -> None;
    If[Head[style] === List, style = First[style]];
    FrontEndTokenExecute[nb, "ExpandSelection"];
    data = NotebookRead[nb];
    FrontEndTokenExecute[nb, "ExpandSelection"];
    datanew = NotebookRead[nb];
    cellpos =
      "InlineCellPosition" /. First@CellInfo[nb]
        /. "InlineCellPosition" -> None;
    If[(data === datanew) || (cellpos === None)
      ,
      EditVersionHistoryModInfoOldFormat[];
      ,
      result = EditVersionHistoryModInfoNewFormat[];
      If[result === $Failed, Return[$Failed]];
    ];
  ];

EditVersionHistoryModInfoOldFormat[] :=
  Module[
    {
      nb = InputNotebook[],
      vers, data, styles, stylenames = If[$VersionNumber < 8, ToExpression["Global`StyleNames"], ToExpression["System`StyleNames"]],
      flag, action,
      $Sentinel = "$FOO$"
    },
    FrontEndTokenExecute[nb, "MoveNext"];
    FrontEndTokenExecute[nb, "MovePrevious"];
    SelectionMove[nb, All, CellContents];
    vers = NotebookRead[nb];
    SelectionMove[nb, All, Cell];
    data = NotebookRead[nb];
    styles =
      Flatten[{stylenames
        /. Options[NotebookSelection[nb], stylenames]
      }];
    flag =
      MemberQ[styles, "BrightFlag"] || !FreeQ[data, "BrightFlag"];
      (* The forgoing dual test required by the vagaries of NotebookRead &
       Options for inline cells inside or outside GridBoxes (e.g., Table
       and Usage cases, respectively).  With selection at the Cell level,
       the former reads as a full Cell expression, but carries no
       StyleNames in the Options;  the latter carries "BrightFlag" as a
       StyleNames option, but reads just the contents of the Cell, not the
       full expression.
      *)
    action =
      If[Head[data] === Cell
        ,
        (*
          A workaround for the case of an old-format ModInfo within a GridBox
          (i.e., tables).  cf:
            <https://mailman.wolfram.com/archive/l-frontend/\
              2008/Mar/msg00003.html>
        *)
        (
          NotebookWrite[nb, $Sentinel];
          expandSelectionToCell[nb];
          NotebookWrite[nb,
            NotebookRead[nb]
              /. $Sentinel ->
                If[Length[#2] > 0,
                  Cell[BoxData[TooltipBox[
                    Cell[#1, "ModInfo",
                      Which[
                        Last[#2] === "F", "BrighterFlag",
                        #3, "BrightFlag",
                       True, Sequence @@ {}
                      ]
                    ],
                    StringJoin @@ Riffle[#2, ","]
                  ]]],
                  Cell[BoxData[TooltipBox[Cell[" ", "ModInfo"], " "]]]
                ]
          ]
        )&
        ,
        NotebookWrite[
          nb,
          If[Length[#2] > 0,
            Cell[BoxData[TooltipBox[
              Cell[#1, "ModInfo",
                Which[
                  Last[#2] === "F", "BrighterFlag",
                  #3, "BrightFlag",
                  True, Sequence @@ {}
                ]
              ],
              StringJoin @@ Riffle[#2, ","]
            ]]],
            Cell[BoxData[TooltipBox[Cell[" ", "ModInfo"], " "]]]
          ]
        ]&
      ];
    LaunchHistoryEditor[action, vers, flag];
  ];

EditVersionHistoryModInfoNewFormat[] :=
  Module[
    {
      nb = InputNotebook[],
      data, vers, flag
    },
    Catch[
      FrontEndTokenExecute[nb, "ExpandSelection"];
      data = NotebookRead[nb];
      If[Head[data] =!= TooltipBox,
        MessageToConsole[VersionAnnotate::badmodinfo];
        Throw[$Failed]
      ];
      vers = Last[data];
      flag = !FreeQ[First[data], "BrightFlag"];
      LaunchHistoryEditor[
        NotebookWrite[
          nb,
          If[Length[#2] > 0,
            TooltipBox[
              Cell[#1, "ModInfo",
                Which[
                  Last[#2] === "F", "BrighterFlag",
                  #3, "BrightFlag",
                  True, Sequence @@ {}
                ]
              ],
              StringJoin @@ Riffle[#2, ","]
            ],
            TooltipBox[Cell[" ", "ModInfo"], " "]
          ]
        ]&,
        vers,
        flag
      ];
    ]
  ];

EditVersionHistoryCellDingbat[] :=
  Module[
    {
      nb = InputNotebook[],
      cd, vers, flag
    },
    (* Expand selection to Cell level,if necessary. *)
    If[expandSelectionToCell[nb] === None,
      MessageToConsole[DocuTools::nosel, "VersionAnnotate", "cell"];
      Return[$Failed]
    ];
    cd = CellDingbat /. Options[NotebookSelection[nb], CellDingbat];
    vers = cd /. {
      Cell[BoxData[TooltipBox[_, v_]]] :> v,    (* new version *)
      Cell[v_, "ModInfo", ___] :> v,            (* old version *)
      _ :> " "
    };
    flag = !FreeQ[cd, "BrightFlag"];
    LaunchHistoryEditor[
      SetOptions[
        NotebookSelection[nb],
        CellDingbat ->
          If[Length[#2] > 0,
            Cell[BoxData[TooltipBox[
              Cell[#1, "ModInfo",
                Which[
                  Last[#2] === "F", "BrighterFlag",
                  #3, "BrightFlag",
                  True, Sequence @@ {}
                ]
              ],
              StringJoin @@ Riffle[#2, ","]
            ]]],
            Inherited
          ]
      ]&,
      vers,
      flag
    ]
  ];


ImageSizeApply[width_] := ImageSizeApply[width, InputNotebook[]];

ImageSizeApply[width_?NumberQ | Inherited, nb_NotebookObject] :=
  Module[
    {
      opts, gopts, stylenames = If[$VersionNumber < 8, ToExpression["Global`StyleNames"], ToExpression["System`StyleNames"]],
      optName, oldSize, oldX, oldY, newSize
    },
    (* Expand selection to Cell level, if necessary. *)
    If[expandSelectionToCell[nb] === None,
      MessageToConsole[DocuTools::nosel,
        "ImageSizeApply", "graphics cell"];
      Return[$Failed]
    ];
    (* Check that only one cell is selected. *)
    If[Length[CellInfo[nb]] != 1,
      MessageToConsole[DocuTools::oversel,
        "ImageSizeApply", "graphics cell"];
      Return[$Failed]
    ];
    (* Then move the selection to the graphic (if any). *)
    FrontEndExecute[{
      FrontEnd`FrontEndToken[nb, "MovePrevious"],
      FrontEnd`FrontEndToken[nb, "MovePreviousGraphics"]
    }];
    opts = Options[NotebookSelection[nb]];
    If[opts === $Failed,
      MessageToConsole[DocuTools::nosel,
        "ImageSizeApply", "graphics cell"];
      Return[$Failed]
    ];
    (* Get Graphics*BoxOptions... *)
    gopts =
      Cases[opts, 
        HoldPattern[(GraphicsBoxOptions | Graphics3DBoxOptions) -> _]
      ];
    If[Length[gopts] > 0
      ,
      gopts = First[gopts]
      ,
      (* If no explicit options specified, create an empty set with the
        proper name. *)
      opts =
        stylenames
          /. Options[NotebookSelection[nb], stylenames]
            /. stylenames -> None;
      gopts =
        Switch[opts,
          "Graphics3D", Graphics3DBoxOptions -> {},
          _,            GraphicsBoxOptions -> {}
        ];
    ];
    (* Compute the new size. *)
    optName = gopts[[1]];
    newSize =
      If[width === Inherited
        ,
        Inherited
        ,
        (* Get the old ImageSize. *)
        oldSize =
          ImageSize /. gopts[[2]] /. ImageSize -> {Automatic, Automatic};
        (* Break out the components of oldSize (allowing for either one or
          two component ImageSizes). *)
        {oldX, oldY} =
          Switch[oldSize,
            {_, _}, oldSize,
            _,      {oldSize, Automatic}
          ];
        (* Compute new ImageSize, forcing the width to the user supplied
          value and preserving aspect ratio if possible. *)
        Switch[{oldX, oldY},
          {_, Automatic},         {width, Automatic},
          {_?NumberQ, _?NumberQ}, {width, width*oldY/oldX},
          {Automatic, _},         {width, width/GoldenRatio},
          _,
            MessageToConsole[ImageSizeApply::unsupsize];
            Return[$Failed]
        ]
      ];
    (* ...and set it (at the Cell level). *)
    expandSelectionToCell[nb];
    SetOptions[NotebookSelection[nb],
      optName -> {ImageSize -> newSize}
    ];
  ];


Options[CellSort] =
  {
    "Notebook" -> Automatic,
      (* Document notebook (default: InputNotebook[]). *)
    "SkipWords" -> 0,
      (* Number of words to skip at the beginning when sorting. *)
    "TrimSkips" -> False,
      (* Trim off the skipped words after sorting? *)
    "Overwrite" -> True,
      (* Overwrite the original selection with the result, or put the
    result in a pop-up notebook? *)
    "Delimiter" -> {" . ", ", "}
      (* Character string(s) delimiting words or phrases to be sorted within a
    single cell. *)
  };

CellSort[options___?OptionQ] :=
  Module[
    {
      optNotebook, optSkipWords, optTrimSkips, optOverwrite, optDelimiter,
      delims, nb, data, h
    },
    {optNotebook, optSkipWords, optTrimSkips, optOverwrite, optDelimiter} =
      {"Notebook", "SkipWords", "TrimSkips", "Overwrite", "Delimiter"}
        /. {options} /. Options[CellSort];
    nb =
      If[optNotebook === Automatic,
        InputNotebook[],
        optNotebook
      ];
    delims = First[ParseDelimiter[{optDelimiter, ""}]];
      (* ...since there's no output delimiter here, use an empty string.*)
    If[delims === $Failed, Return[$Failed]];
    (* Expand selection to Cell level, if necessary. *)
    If[expandSelectionToCell[nb] === None,
      MessageToConsole[DocuTools::nosel,
        "CellSort", "cell or cell group"];
      Return[$Failed]
    ];
    (* Read selection and process into a list of cells. *)
    data = OldNotebookRead[nb];
    data = data /. Cell[CellGroupData[c_, ___]] :> c;
    data =  Flatten[{data}];
    (* Test here for number of cells selected. *)
    Which[
      Length[data] == 1,
        (*
          A single cell
        *)
        (* Remember the head of the cell content.
          (We'll need to restore it later.) *)
        h = Head[First[data] /. Cell[c_, ___] :> c];
        If[h === String, h = TextData];
        (* Replace the data list w/just the cell contents... *)
        SelectionMove[nb, All, CellContents];
        data = OldNotebookRead[nb];
        data = Flatten[{data}];
        (* ...broken out into separate elements by the delimiter. *)
        data = Replace[data,
            s_String :>
              Sequence @@ StringSplit[s, Alternatives @@ delims], {1}]
      ,
      Length[data] > 1,
        (*
          Multiple cells
        *)
        h = Identity
      ,
      True,
        MessageToConsole[DocuTools::assertion,
          "(CellSort) Invalid Length[data]: " <> ToString[Length[data]]
        ];
        Return[$Failed]
    ];
    (* Sort the list on a "stringified" version of the content. *)
    data = {DropWord[Stringify[#], optSkipWords], #}& /@ data;
    data = Sort[data, OrderedQ[{#1[[1]], #2[[1]]}]&];
    data = #[[2]]& /@ data;
    If[optTrimSkips,
      data = data /.
        Cell[TextData[c_], o___]
          :> Cell[TextData[Drop[c, optSkipWords]], o];
    ];
    (* If it's a single cell, reinsert the delimiters. *)
    If[h =!= Identity,
      data = BoxForm`Intercalate[data, First[delims]]
    ];
    (* Write the sorted result (either in place or in a pop-up notebook). *)
    If[optOverwrite
      ,
      NotebookWrite[nb, h[data]]
      ,
      NotebookPut[
        Notebook[h[data],
          WindowTitle -> "CellSort result",
          Sequence @@ Options[nb, StyleDefinitions]
        ]
      ]
    ]
  ];

Stringify[expr_] :=
  (*
    Strips out the structure from a Mathematica expression, returning the
    string content as a single String.  (Residual nonstring parts are
    dropped.)
  *)
  Module[
    {
      data
    },
    data =
      Flatten @ {
        expr //. {
          Cell[c_, ___] :> c,
          TextData[c_] :> c,
          BoxData[c_] :> c,
          FormBox[c_, ___] :> c,
          RowBox[c_] :> c,
          SuperscriptBox[c___] :> {c},
          SubscriptBox[c___] :> {c},
          ButtonBox[c_, ___] :> c,
          StyleBox[c_, ___] :> c
        }
      };
    data = Select[data, Head[#] === String &];
    StringJoin @@ data
  ];

DropWord[s_String, n_Integer] :=
  Module[
    {
      words
    },
    words = ReadList[StringToStream[s], Word];
    words = Drop[words, n];
    StringJoin @@ BoxForm`Intercalate[words, " "]
  ];


Options[CellFunctionApply] =
  {
    "Notebook" -> Automatic,
      (* Document notebook (default: InputNotebook[]). *)
    "Action" -> "Toggle",
      (* Action to perform:
         "Format"    - Always format
         "Unformat"  - Always unformat
         "Toggle"    - Toggle between the two states
      *)
    "Overwrite" -> True,
      (* Overwrite the original selection with the result, or put the
        result in a pop-up notebook? *)
    "Delimiter" -> {{" . ", ", "}, " \[EmptyVerySmallSquare] "}
      (* Character string delimiting words or phrases to be acted upon
        within a single cell.  Can also take a 2-element list to specify
        different input and output delimiters (respectively). *)
  };

(*
  Functions to parse the "Delimiter" option, above.
  Should always return a pair {in: {__String}, out_String},
  where in_ is the input delimiter(s) and out_ the output delimiter.
*)
ParseDelimiter[both_String] := {{both}, both};
ParseDelimiter[{in_String, out_String}] := {{in}, out};
ParseDelimiter[{in: {__String}, out_String}] := {in, out};
ParseDelimiter[opt___] :=
  (
    MessageToConsole[ParseDelimiter::invdelim,
      StringReplace[ToString[{opt}], {
        StartOfString ~~ "{" -> "",
        "}" ~~ EndOfString -> ""
      }]
    ];
    {$Failed, $Failed}
  );

ParseDelimiter::invdelim = "An invalid value for the option \"Delimiter\"
was specified [`1`].  Valid forms are:
    both_String
    {in_String, out_String}
    {in: {__String}, out_String}."

CellFunctionApply[func_Function, options___?OptionQ] :=
  Module[
    {
      optNotebook, optAction, optOverwrite, optDelimiter,
      inDelimiters, outDelimiter,
      nb, data, newdata
    },
    {optNotebook, optAction, optOverwrite, optDelimiter} =
      {"Notebook", "Action", "Overwrite", "Delimiter"}
        /. {options} /. Options[CellFunctionApply];
    nb =
      If[optNotebook === Automatic,
        InputNotebook[],
        optNotebook
      ];
    {inDelimiters, outDelimiter} = ParseDelimiter[optDelimiter];
    If[inDelimiters === $Failed, Return[$Failed]];
    (* Expand selection to Cell level, if necessary. *)
    If[expandSelectionToCell[nb] === None,
      MessageToConsole[DocuTools::nosel, "CellFunctionApply", "cell"];
      Return[$Failed]
    ];
    (* Read selection and process into a list of cells. *)
    data = OldNotebookRead[nb];
    data = data /. Cell[CellGroupData[c_, ___]] :> c;
    data =  Flatten[{data}];
    (* Test here for number of cells selected. *)
    Which[
      Length[data] > 1,
        (*
          Multiple cells
        *)
        MessageToConsole[DocuTools::oversel, "CellFunctionApply", "cell"];
        Return[$Failed]
      ,
      Length[data] != 1,
        MessageToConsole[DocuTools::assertion,
          "(CellFunctionApply) Invalid Length[data]: "
            <> ToString[Length[data]]
        ];
        Return[$Failed]
    ];
    data = First[data];
    newdata = CellFunctionApplyTransform[data, inDelimiters, outDelimiter,
      func, optAction];
    If[newdata =!= data,
      (* Write the result (either in place or in a pop-up notebook). *)
      If[optOverwrite
        ,
        NotebookWrite[nb, newdata, All]
        ,
        NotebookPut[
          Notebook[newdata,
            WindowTitle -> "CellFunctionApply result",
            Sequence @@ Options[nb, StyleDefinitions]
          ]
        ]
      ]
    ]
  ];

CellFunctionApplyTransform[
  data_, inDelimiters: {__String}, outDelimiter_String, func_Function,
  action_String
] :=
  Module[
    {
      content, h, unformatted, collect
    },
    content = data /. Cell[c_, ___] :> c;
    (* Remember the head of the cell content.
      (We'll need to restore it later.) *)
    h = Head[content];
    (* Pull out content into a list. *)
    content =
      Switch[h,
        String, {content},
        TextData, content[[1]],
        _, content
      ];
    If[Head[content] =!= List, content = {content}];
    (* Depending on whether it's formatted or not, do the other. *)
    unformatted =
      Which[
        ContainsStringQ[content, outDelimiter], False,
        ContainsStringQ[content, inDelimiters], True,
        True, FreeQ[content, _ButtonBox]
      ];
    Which[
      action == "Format" || (action == "Toggle" && unformatted),
        (*------------*)
        (*---Format---*)
        (*------------*)
        (* Break out contents into separate elements by the delimiter. *)
        content = Replace[content,
          s_String :>
            Sequence @@ (
              (TrimWhiteSpace /@ StringSplit[s,
                Join[inDelimiters, {outDelimiter,
                  d: ($Continued) ~~ Whitespace... ~~ EndOfString :> d
                }]
              ]) /. "" -> Sequence[]  (* ...to drop empty elements. *)
            ),
          {1}
        ];
        (* Map the function across them. *)
        content = func /@ content;
        (* Regather main and "special operator" parts within braces. to
          guide the insertion of outDelimiters.  (Only needed when
          formatting already-formatted material.) *)
        content = 
          FixedPoint[
            Replace[#,
              {a___, x: PatternSequence[_Cell, " (", _Cell, ")"], b___} :>
                {a, {x}, b}, {0}
            ]&,
            content
          ];
        (* Post-processing of $Continued links. *)
        content = content /.
          If[$HeadPath =!= None,
            (* If $HeadPath set (by an enclosing linked head), link any
              unlinked $Continued links to the same target. *)
            ButtonBox[c: $Continued, opts___] /; FreeQ[{opts}, ButtonData]
              :> ButtonBox[c, opts, ButtonData -> $HeadPath],
            (* ...else, delink any unlinked $Continued links. *)
            ButtonBox[c: $Continued, opts___] /; FreeQ[{opts}, ButtonData]
              :> c
          ];
        (* Reinsert the delimiters. *)
        content = Riffle[content, outDelimiter]
        ,
      action == "Unformat" || (action == "Toggle" && !unformatted),
        (*--------------*)
        (*---Unformat---*)
        (*--------------*)
        (* Strip out content from formatting, break out parens as
          separate characters, and drop old delimiters and whitespace. *)
        content = StripFormatting /@ content;
        content =
          Replace[content,
            s_String :>
              Sequence @@ StringSplit[s, {
                ")" -> ")", "(" -> "(",
                Sequence @@ inDelimiters,
                outDelimiter
              }],
            {1}
          ];
        content = content /.
          s_String :> TrimWhiteSpace[s] /.
            "" -> Sequence[];
        (* Collect:
          o Any paren-delimited special operators, and group them with the
            preceding symbol.
          o Any \[...] forms (where "..." is *not* a valid longname), and
            group that parts together.
        *)
        collect[a___, b_String, "(", c___String, ")", d___] :=
          {a, {b, " (", c, ")"}, d};
        collect[a___, "\\[", b___String, "]", c___] :=
          {a, {"\\[", b, "]"}, c};
        collect[a___] := {a};
        content = FixedPoint[(collect @@ #)&, content];
            (*FIXME: Needs a limit? *)
        content =
          If[MatchQ[#, {___String}], StringJoin @@ #, #]& /@ content;
        (* Reinsert the delimiters. *)
        content = Riffle[content, First[inDelimiters]];
    ];
    data /. Cell[_, rest___] :> Cell[TextData[content], rest]
  ];


(*
  Recursive function to strip out formatting.
*)

StripFormatting[bb : ButtonBox[___, (Rule | RuleDelayed)[ButtonData, bd_], ___] /; 
   And[ValueQ[DocumentationTools`$LinkBase], Not@StringMatchQ[DocumentationTools`$LinkBase, "" | Whitespace], 
    StringMatchQ[bd, "paclet:" ~~ (c__ /; c =!= DocumentationTools`$LinkBase) ~~ "/ref/" ~~ bb[[1]]]]
] := StringReplace[bd, "paclet:" -> ""];

StripFormatting[
  char: Cell[TextData[
      ButtonBox[___, (Rule | RuleDelayed)[ButtonData, _], ___]
    ], "InlineCharacterName"]
] := char;

StripFormatting[
  bb: ButtonBox[___, (Rule | RuleDelayed)[ButtonData, bd_], ___]
    /; DocumentationTools`$LinkBase =!= "" && !StringMatchQ[bd, "paclet:" <> DocumentationTools`$LinkBase <> "*"]
] := bb;

StripFormatting[
  bb: ButtonBox[___, BaseStyle -> s_, ___]
    /; !FreeQ[s, "BrightFlag" | "BrighterFlag" | "ExcludedObject"
                    | "TOCExcludedObject" | "PrimaryObject"
        ]
] := bb;

StripFormatting[StyleBox[c_, etc___]] := StyleBox[StripFormatting[c], etc];

StripFormatting[c_List] := Sequence @@ (StripFormatting /@ c);

StripFormatting[_[c_, ___]] := StripFormatting[c];

StripFormatting[s_String] := s;

StripFormatting[___] := Sequence[];


ContainsStringQ[expr_, target_String] :=
  Not @ FreeQ[expr, s_String /; StringMatchQ[s, ___ ~~ target ~~ ___]];

ContainsStringQ[expr_, target: {__String}] :=
  Or @@ (ContainsStringQ[expr, #]& /@ target);

TrimWhiteSpace[s_String] :=
  StringReplace[s,
    {
      StartOfString ~~ Whitespace :> "",
      Whitespace ~~ EndOfString :> ""
    }
  ];



(* ConvertTeX code yanked from Publicon and modified for use with M TeX support. *)
   
ConvertTeX[ ] := Module[ { selNB = InputNotebook[], selInfo, mathExp, str, loop, ConvertTexError},
        
        ConvertTexError = "The TeX expression you tried to convert could not be interpreted. Please check it for syntax errors.";
        
        Catch[

          If[ selNB === $Failed,
            Throw[ Null]];

          selInfo = CellInfo[ selNB];

          If[ MatchQ[ selInfo, $Failed | CellInfo[ $Failed]],
            Throw[ Null]];

          If[ ("CursorPosition" /. First @ selInfo) === "CellBracket",
            Throw[ Null]];

       (* Recursive test for selecting backwards to find beginning of TeX, i.e., "$". Unfortunately, there's no way to
          stop it properly if the beginning "$" is never found, so we use TimeConstrained to keep this from running away
          stuck in a loop:

          While this is a clever idea, M becomes unstable after running this on a case where the time-out occurs.
          Not sure why, tried various Abort methods but the results were the same -- unrelated functions break down:


          If[ SameQ @@ Flatten @ ("CursorPosition" /. selInfo),
            FrontEndExecute[ FrontEnd`FrontEndToken[ selNB, "SelectPreviousWord"]];
            str = OldNotebookRead[ selNB];
            CheckAbort[
              TimeConstrained[
                While[ !StringMatchQ[ str, "*$*$*"],
                 (FrontEndExecute[ FrontEnd`FrontEndToken[ selNB, "SelectPreviousWord"]];
                  str = OldNotebookRead[ selNB])],
                1],
             Throw[ MessageToConsole[ ConvertTexError]]]];   *****)

       (* Recursive test for selecting backwards to find beginning of TeX, i.e., "$". Unfortunately, there's no way to
          stop it properly if the beginning "$" is never found. Tried to use TimeConstrained to keep this from running away,
          and while this might be a clever idea, M becomes unstable after running this on a case where the time-out occurs.
          Not sure why, and perhaps this was only true for 4.2. Tried various Abort methods but the results were the same 
          -- unrelated functions break down. So instead the same we simply limit the recursive check to a few loops: *)

          If[ SameQ @@ Flatten @ ("CursorPosition" /. selInfo),
           (FrontEndExecute[ FrontEnd`FrontEndToken[ selNB, "SelectPreviousWord"]];
            str  = OldNotebookRead[ selNB];
            loop := If[ StringMatchQ[ str, "*$*$*"],
                     False,
                     (FrontEndExecute[ FrontEnd`FrontEndToken[ selNB, "SelectPreviousWord"]];
                      str = OldNotebookRead[ selNB];
                      True)];
            If[ loop,
              If[ loop,
                If[ loop,
                  If[ loop,
                    If[ loop,
                      If[ loop,
                        If[ loop, Throw[ PrepareAsDialog[ ConvertTexError]]]]]]]]]
            )];

          If[ # === $Failed,
            Throw[ MessageToConsole[ ConvertTexError]],
            mathExp = #] & [ ToExpression[ OldNotebookRead[ selNB], TeXForm, Hold]];

          If[ ("ContentData" /. selInfo) === {TextData},
            (NotebookWrite[ selNB, Cell[ BoxData[ FormBox[ " ", TraditionalForm]], "InlineMath"], All];
             FrontEndExecute[{
               FrontEnd`FrontEndToken[ selNB, "MovePrevious"], 
               FrontEnd`FrontEndToken[ selNB, "MoveNext"], 
               FrontEnd`FrontEndToken[ selNB, "SelectNextWord"]}];
             NotebookWrite[ selNB,
               Function[{conv},
                 Cell[BoxData[ToBoxes[ Unevaluated @ conv, TraditionalForm]]],
                 HoldFirst
               ] @@ mathExp,
               All
             ];
             FrontEndExecute[ FrontEnd`FrontEndToken[ selNB, "MoveNext"]]
             )]
          ]]
          
          

SelectByDelimiter[ delim_String] :=
Module[{
   selNB = InputNotebook[],
   selInfo = CellInfo[ InputNotebook[] ],
   str,
   loop
},
        Catch[
          If[ selNB === $Failed,
            Throw[ Null] ];
          If[ Not[ MatchQ[ selInfo, {{___}}] ],
            Throw[ Null] ];
          If[ ("CursorPosition" /. First @ selInfo) === "CellBracket",
            Throw[ Null]];

       (* Recursive test for selecting backwards to find beginning of TeX, i.e., "$". Unfortunately, there's no way to
          stop it properly if the beginning "$" is never found. Tried to use TimeConstrained to keep this from running away,
          and while this might be a clever idea, M becomes unstable after running this on a case where the time-out occurs.
          Not sure why, and perhaps this was only true for 4.2. Tried various Abort methods but the results were the same 
          -- unrelated functions break down. So instead the same we simply limit the recursive check to a few loops: *)

          If[ SameQ @@ Flatten @ ("CursorPosition" /. selInfo),
           (FrontEndExecute[ FrontEnd`FrontEndToken[ selNB, "SelectPreviousWord"]];
            str  = OldNotebookRead[ selNB];
            loop := If[ StringMatchQ[ str, "*" <> delim <> "*"],
                     False,
                     (FrontEndExecute[ FrontEnd`FrontEndToken[ selNB, "SelectPreviousWord"] ];
                      str = OldNotebookRead[ selNB];
                      True)
            ];
            If[ loop,
              If[ loop,
                If[ loop,
                  If[ loop,
                    If[ loop,
                      If[ loop,
                        If[ loop, Throw[ PrepareAsDialog[ SelectByDelimiterError]]]]]]]]]
            )];
        ]
]



(* Temporary setting of global options to allow scroll bar auto setting init cell to evaluate:

SetOptions[ $FrontEnd, InitializationCellEvaluation -> True, InitializationCellWarning -> False] *)



(* Restoring back to inherited because it seemed to cause too many problems with unstable FEs, 
   we get assertion errors if not wrapped as FrontEndExecute[]: *)

If[ Head[ $FrontEnd] === FrontEndObject,
   FrontEndExecute[
      SetOptions[ $FrontEnd,
         InitializationCellEvaluation -> Inherited,
         InitializationCellWarning -> Inherited
      ]
   ]
]



(* Available screen size calculation based on .968 instead of more accurate .973 to allow a little flexibility/imprecision: *)

ScrollBarCheck[] := (If[ Round[ .968 Last @ Flatten[ ScreenRectangle /. Options[ $FrontEnd, ScreenRectangle]]] 
                          < Last[ WindowSize /. AbsoluteOptions[ EvaluationNotebook[], WindowSize]], 
                       SetOptions[ EvaluationNotebook[], 
                         Editable -> True,
                         WindowSize ->
                          If[($OperatingSystem === "MacOSX"),
                            {162,Inherited},
                            {170,Inherited}
                          ],
                         WindowMargins -> {{Automatic,0},{0,0}},
                         WindowElements -> {"VerticalScrollBar"}];
                       SetOptions[ EvaluationNotebook[], Editable -> False]];
                     SetOptions[ $FrontEnd, InitializationCellEvaluation -> Inherited, InitializationCellWarning -> Inherited])

(* ScrollBarCheck[] := If[ Round[ .973 Last @ Flatten[ ScreenRectangle /. Options[ $FrontEnd, ScreenRectangle]]] 
                          < Last[ WindowSize /. AbsoluteOptions[ EvaluationNotebook[], WindowSize]], 
                        "VerticalScrollBar"] *)

ScrollBarToggle[] := ScrollBarToggle[ "Automatic"]

ScrollBarToggle[ setting_:"Automatic"] := Module[{nb = ButtonNotebook[], scrollOn, scrollOff},
      scrollOn := (If[($OperatingSystem === "MacOSX"),
                    SetOptions[ nb, Editable -> True, WindowSize -> {164, Automatic}, WindowMargins -> {{Automatic, 0}, {Automatic, Automatic}}, 
                      WindowElements -> {"VerticalScrollBar"}],
                    SetOptions[ nb, Editable -> True, WindowSize -> {170, Automatic}, WindowMargins -> {{Automatic, 0}, {Automatic, Automatic}}, 
                      WindowElements -> {"VerticalScrollBar"}]];
                  SetOptions[ nb, Editable -> False]);
      scrollOff := (SetOptions[ nb, Editable -> True, WindowSize -> {152, Automatic}, WindowMargins -> {{Automatic, 0}, {Automatic, Automatic}}, 
                     WindowElements -> {}];
                   SetOptions[ nb, Editable -> False]);
      Which[ 
        setting === "Automatic" && FreeQ[ Options[ nb, WindowElements], "VerticalScrollBar"],
          scrollOn,
        setting === "Automatic" && !FreeQ[ Options[ nb, WindowElements], "VerticalScrollBar"],
          scrollOff,
        setting === "On" && FreeQ[ Options[ nb, WindowElements], "VerticalScrollBar"],
          scrollOn,
        setting === "On" && !FreeQ[ Options[ nb, WindowElements], "VerticalScrollBar"],
          Null,
        setting === "Off" && FreeQ[ Options[ nb, WindowElements], "VerticalScrollBar"],
          Null,
        setting === "Off" && !FreeQ[ Options[ nb, WindowElements], "VerticalScrollBar"],
          scrollOff
        ]
     ]


CellGroupToggle[] := Module[{nb = ButtonNotebook[]},
      SetOptions[ nb, Editable -> True, WindowClickSelect -> True];
      SelectionMove[ nb, All, ButtonCell];
      FrontEndExecute[ FrontEnd`FrontEndToken[ nb, "OpenCloseGroup"]];
      SetOptions[ nb, WindowClickSelect -> False];
      SetOptions[ nb, Editable -> False]
      ]
  
  
RaisedOrdinal[ ord_:"nd"] := Module[{nb = InputNotebook[], info = CellInfo[ InputNotebook[]]},
                               If[ info === $Failed, Abort[]];
                               If[ !FreeQ[ "CursorPosition" /. info, "CellBracket"], Abort[]];
                               SetOptions[ nb,
                                 DefaultNewInlineCellStyle->"None",
                                 DefaultInlineFormatType->DefaultTextInlineFormatType];
                               If[ OldNotebookRead[ nb] === {},
                                 SelectionMove[ nb, All, Word]];
                               Which[ 
                                 MatchQ[ OldNotebookRead[ nb], BoxData[_]] && FreeQ[ CellInfo[ nb], "InlineCellPosition"], 
                                   SelectionMove[ nb, After, Selection];
                                   NotebookWrite[ nb, FormBox[ SuperscriptBox[ "\[Null]", ord], TraditionalForm]],
                                 MatchQ[ OldNotebookRead[ nb], BoxData[_]],
                                   SelectionMove[ nb, All, Cell];
                                   SelectionMove[ nb, After, Selection];  (* Using this instead of After Word because of bug 66652, but this is the right thing anyway *)
                                   NotebookWrite[ nb, FormBox[ SuperscriptBox[ "\[Null]", ord], TraditionalForm]],
                                 True,
                                   SelectionMove[ nb, After, Selection];  (* Using this instead of After Word because of bug 66652, but this is the right thing anyway *)
                                   NotebookWrite[ nb, FormBox[ SuperscriptBox[ "\[Null]", ord], TraditionalForm]]];
                               SetOptions[ nb,
                                 DefaultNewInlineCellStyle->Inherited,
                                 DefaultInlineFormatType->Inherited]]



(* Functions for use as RHS for CellEvaluationFunction option, sugeested by John Fultz. Global variable sets graphics head types to test 
   on for DynamicGraphic1. DynamicGraphic2 is more robust but less efficient (evaluates twice): *)
   

WolframDocumentProlog[] := (Composition @@ $CellPrologSequence)[]

$CellPrologSequence = {(* TagEvaluatedCell, *) NeedPackages}

TagEvaluatedCell[args___] :=
(
   SelectionMove[EvaluationNotebook[], All, EvaluationCell];
   With[{
      ct =
         Replace[ CellTags,
            Options[ NotebookSelection[ EvaluationNotebook[] ], CellTags] ]
   }, 
      If[
         FreeQ[ Options[ NotebookSelection[ EvaluationNotebook[] ], CellTags],
            s_String?ExampleTagQ]
      , 
         SetOptions[ NotebookSelection[ EvaluationNotebook[] ], 
            CellTags -> Flatten[{ct, NewExampleTag[]}] ] ] ]; 
   SelectionMove[ EvaluationNotebook[], After, Cell];
   Flatten[{args}, 1]
)

ExampleTagQ[ s_String] := StringMatchQ[ s, "Ex--*,*"]

NewExampleTag[] := 
   "Ex--" <>
   ToString[ $SessionID] <>
   "," <>
   ToString[ NewExampleCounter[] ]

NewExampleCounter[] := 
Replace[ $NewExampleCounter, {
   s_Symbol :> ($NewExampleCounter = 1),
   _Integer :> ++$NewExampleCounter}]

NeedPackages[args___] := (
   Needs /@
      ("NeededPackages" /. Append[ GetTaggingRules @ EvaluationNotebook[], _ :> {}]);
   Flatten[{args}, 1]
)

GetTaggingRules[ nb_NotebookObject] :=
Cases[ TaggingRules /. Options[ nb, TaggingRules], (Rule|RuleDelayed)[_, _]]

 
$GraphicHeadList := {Plot, Plot3D, ParametricPlot, ParametricPlot3D, DensityPlot, ContourPlot, Graphics, Graphics3D}

SetAttributes[ DynamicGraphic1, HoldAll]

DynamicGraphic1[ expr_, form___] :=
      TimeConstrained[
        With[{ heldExpr = MakeExpression[ expr, form]},
          If[ MemberQ[ $GraphicHeadList, Extract[ heldExpr, {1, 0}]],
            ReleaseHold[ SnapshotDynamic[ heldExpr]],
            ReleaseHold[ heldExpr]]
          ],
        $GraphicsEvaluationSlownessLimit,
        ReleaseHold[ MakeExpression[ expr, form]]
      ]

(* Dealing with compound expression with new lines -- special box structure in that case: *)

DynamicGraphic1[ BoxData[{expr__}], form___] :=
      TimeConstrained[
        With[{ heldExpr = MakeExpression[ #, form] & /@ {expr}},
          If[ MemberQ[ $GraphicHeadList, Extract[ Last @ heldExpr, {1, 0}]],
            ReleaseHold[ SnapshotDynamic[ #] &[ Last @ heldExpr]],
            ReleaseHold[ Last @ heldExpr]]
          ],
        $GraphicsEvaluationSlownessLimit,
        ReleaseHold[ MakeExpression[ BoxData[{expr}], form]]
      ]

SetAttributes[ DynamicGraphic2, HoldAll]

DynamicGraphic2[ expr_, form___] :=
      TimeConstrained[
        With[{ heldExpr = MakeExpression[ expr, form]},
          With[{ evaluatedExpr = ReleaseHold[ heldExpr]},
            If[ MemberQ[{ Graphics, Graphics3D}, Head[ evaluatedExpr]],
              ReleaseHold[ SnapshotDynamic[ heldExpr]],
              evaluatedExpr]
          ]],
        $GraphicsEvaluationSlownessLimit,
        ReleaseHold[ MakeExpression[ expr, form]]
      ]
        
(* Dealing with ? and ?? forms *)

DynamicGraphic2[ RowBox[{"?", fn_String}], form___] :=
Information[ fn, LongForm -> False]

DynamicGraphic2[ RowBox[{"??", fn_String}], form___] :=
Information[ fn, LongForm -> True]
          
(* Dealing with compound expression with new lines -- special box structure in that case: *)

DynamicGraphic2[ BoxData[{expr__}], form___] := 
      TimeConstrained[
       With[{ heldExpr = MakeExpression[ #, form] & /@ {expr}}, 
         With[{ evaluatedExpr = ReleaseHold[ heldExpr]}, 
           If[ MemberQ[{ Graphics, Graphics3D}, Head[ Last @ evaluatedExpr]], 
             ReleaseHold[ SnapshotDynamic[ #] &[ Last @ heldExpr] ], 
             Last @ evaluatedExpr]
          ]],
        $GraphicsEvaluationSlownessLimit,
        ReleaseHold[ MakeExpression[ BoxData[{expr}], form]]
      ]


(* SnapshotDynamic[ expr_] gives a Dynamic expression whose
body is a Block that encapsulates the full definitions for all
symbols in expr that are in the current context, so that these
definitions are put into effect before each dynamic evaluation
of expr itself.
*)
SnapshotDynamic[ expr_, dynamicHead_:Dynamic] :=
Replace[
   Replace[
      Join @@
         Union @
            Cases[ expr,
               y_Symbol ? (
                  Function[{sy},
                     sy === Out || Context[sy] === $Context,
                     HoldFirst
                  ]
               )
                  :> Hold[y],
               {-1},
               Heads -> True
            ],
      Hold[syms___] :>
         {
            Hold[syms],
            Replace[ ToString[ FullDefinition[ syms], InputForm], {
               "" -> Hold[],
               s_String :>
                  DeleteCases[ ToExpression[ s, InputForm, Hold], Null]
            }]
         }
   ],
{
   {Hold[ defsyms___], Hold[ defs___]} :>
      With[{rstate = $RandomState},
         If[ FreeQ[ {expr, Hold[defs]}, $RandomFunctionsPattern],
            dynamicHead[
               Block[{defsyms},
                  CompoundExpression[ defs, expr]
               ]
            ]
         ,
            dynamicHead[
               Block[{defsyms, $RandomState = rstate},
                  CompoundExpression[ defs, expr]
               ]
            ]
         ]
      ],
   {} :> dynamicHead[ expr]
}]

SetAttributes[ `DynamicToBe, HoldFirst]

$RandomFunctionsPattern = Random | RandomReal | RandomInteger | RandomChoice

`DynamicGraphicOutputProlog[] := (
   $FunctionPageCellEvaluationTime = AbsoluteTime[0];
   $FunctionPageCellEvaluationLine = $Line;
   $ExampleRandomState = $RandomState
)

$EpilogSlownessLimit = 2

$GraphicsEvaluationSlownessLimit = 100

$GraphicsOutputTolerableSize = 5000

`DynamicGraphicOutputEpilog[] :=
With[{lag = AbsoluteTime[0] - $FunctionPageCellEvaluationTime},
   SelectionMove[ EvaluationNotebook[], After, GeneratedCell];
   SelectionMove[ EvaluationNotebook[], Previous, Cell];
   If[
      lag < $GraphicsEvaluationSlownessLimit &&
         MemberQ[{ Graphics, Graphics3D}, Head @ Out[]] &&
         ByteCount @ Out[] > $GraphicsOutputTolerableSize
   , 
      SetOptions[ NotebookSelection @ EvaluationNotebook[],
         TaggingRules ->
            TimeConstrained[
               {
               CellDynamicOutput :> Evaluate @
                  Block[{$RandomState = $ExampleRandomState},
                     ReleaseHold[
                        SnapshotDynamic[
                           ReplaceAll[
                              Hold[ In @ $Line] /.
                                 HoldPattern @ $Line -> $FunctionPageCellEvaluationLine,
                              DownValues @ In
                           ],
                           Hold
                        ]
                     ]
                  ],
               DynamicTagTime -> AbsoluteTime[0],
               GraphicsResultByteCount -> ByteCount @ Out[],
               EvaluationTimeLag -> lag
               },
               $EpilogSlownessLimit,
               Inherited
            ]
      ],
      SetOptions[ NotebookSelection @ EvaluationNotebook[],
         TaggingRules -> Inherited
      ],
      SetOptions[ NotebookSelection @ EvaluationNotebook[],
         TaggingRules -> $DynamicGraphicOutputFailed
      ]
   ];
   SelectionMove[ EvaluationNotebook[], After, Cell]
]


(* Abandoning atempts to set individual cell, cannot get it to work: 

DynamicOutputToggle[ styEnv_String:"Brackets"] := Module[{DocumentationTools`nb = InputNotebook[], DocumentationTools`info = DocumentationTools`CellInfo[ InputNotebook[]]},
    Which[ 
      DocumentationTools`info === $Failed,
        If[ FreeQ[ Options[ DocumentationTools`nb, ScreenStyleEnvironment], "NonDynamic"],
          SetOptions[ DocumentationTools`nb, ScreenStyleEnvironment -> "NonDynamic"],
          SetOptions[ DocumentationTools`nb, ScreenStyleEnvironment -> styEnv]],      
      ("CursorPosition" /. DocumentationTools`info) === {"CellBracket"} && ("Style" /. DocumentationTools`info) === {"Input"},
        If[ MatchQ[ Options[ NotebookSelection[ DocumentationTools`nb], System`CellEvaluationFunction], {System`CellEvaluationFunction -> None}|{}], 
          SetOptions[ NotebookSelection[ DocumentationTools`nb], System`CellEvaluationFunction -> Inherited, FontColor->Inherited],
          SetOptions[ NotebookSelection[ DocumentationTools`nb], System`CellEvaluationFunction -> None, FontColor -> RGBColor[ 0.3, 0, 0.3]]],
      True,
        If[ FreeQ[ Options[ DocumentationTools`nb, ScreenStyleEnvironment], "NonDynamic"],
          SetOptions[ DocumentationTools`nb, ScreenStyleEnvironment -> "NonDynamic"],
          SetOptions[ DocumentationTools`nb, ScreenStyleEnvironment -> styEnv]]
      ]
    ]     *)
    
DynamicOutputToggle[ styEnv_String:"Brackets"] := Module[{nb = InputNotebook[]},
    If[ FreeQ[ Options[ nb, ScreenStyleEnvironment], "NonDynamic"],
          SetOptions[ nb, ScreenStyleEnvironment -> "NonDynamic"],
          SetOptions[ nb, ScreenStyleEnvironment -> styEnv]] 
    ]

(* Ignoring cell selection setting check for now, see above: 

DynamicOutputStatus[] := 
  StringJoin[
    "Turn dynamic graphics on/off for selected input cell.\n\
Applies to all input cells when selection is anything other than one input cell, using environment switching.\n\
Non-dynamic environment indicated by purple input cell color.\n\n",
    If[ InputNotebook[] =!= $Failed,
      StringJoin[
        "Graphics Output Mode of Notebook: ", 
        If[ ReplaceAll[ ScreenStyleEnvironment, Options[ InputNotebook[], ScreenStyleEnvironment]] === "NonDynamic",
          "Non-dynamic",
          "Dynamic"],
        "\n",
        "Graphics Output Mode of Selection: ",
        If[
          DocumentationTools`CellInfo[] === $Failed,
            "No Cell Selected",
          If[ MatchQ[ ReplaceAll[ CellEvaluationFunction, Options[ NotebookSelection[ InputNotebook[]], CellEvaluationFunction]], None | {}],
            "Non-dynamic",
            "Dynamic"]]
        ],
      "No Input Notebook"
      ],
    "\n"
    ]    *)
 

DynamicOutputStatus[] := 
  StringJoin[
    "Turn dynamic graphics on/off for notebook, using environment switching.\n\
Non-dynamic environment indicated by purple input cell color.\n\n",
    If[ InputNotebook[] =!= $Failed,
      StringJoin[
        "Graphics Output Mode: ", 
        If[ ReplaceAll[ ScreenStyleEnvironment, Options[ InputNotebook[], ScreenStyleEnvironment]] === "NonDynamic",
          "Non-dynamic",
          "Dynamic"]
        ],
      "No Input Notebook"
      ],
    "\n"
    ]


(* Relies on new FE feature: *)

BitmapOutputApply[ arg_:""] := 
            Module[{ nb = InputNotebook[]},
              If[ arg === "All",
               FrontEndExecute[{
                 FrontEnd`NotebookFind[ FrontEnd`InputNotebook[], "Output", All, CellStyle, AutoScroll->False],
                 FrontEnd`FrontEndToken[ FrontEnd`InputNotebook[], "SelectionConvert", "BitmapConditional"]}],
               If[ MatchQ[ ("Style" /. CellInfo[ nb]), {"Output"}|{"Graphics"}],
                 FrontEndExecute[
                   FrontEnd`FrontEndToken[ FrontEnd`InputNotebook[], "SelectionConvert", "BitmapConditional"]]]]
              ]
 



(* Section of former path configuration and DocLink definitions moved to DocuLinkTools *)


    

FilenameFromButtonCont[ str_String] := StringJoin[
                                         StringReplace[
                                           StringReplacePart[#, ToUpperCase[StringTake[#, 1]], {1, 1}] & /@ StringSplit[str, " "], 
                                           {"," -> "", "." -> "", "?" -> "", ":" -> "", RegularExpression["\\(.+\\)"] -> ""}], 
                                         ".nb"]

FileNameAppend[ nb_NotebookObject, str_String] := 
    StringReplace[ ToFileName[ "FileName" /. NotebookInformation[nb]], ".nb" -> ""] <> str
  

flagList = Sequence[ "InternalFlag" | "FutureFlag" | "ExcisedFlag" | "TemporaryFlag" | "ObsoleteFlag" | "SubjectToChangeFlag" | "AwaitingFutureDesignReviewFlag" | "PreviewFlag" ]

navSequence[ nbobj_] := (
        SelectionMove[ nbobj, Before, Notebook];
        Which[
          !FreeQ[ Options[ nbobj, StyleDefinitions], "FunctionPageStyles.nb"] && $Failed =!= NotebookFind[ nbobj, "ObjectName", Next, CellStyle],
            SelectionMove[ nbobj, After, Cell],
          !FreeQ[ Options[ nbobj, StyleDefinitions], "TutorialPageStyles.nb"] && $Failed =!= NotebookFind[ nbobj, "Title", Next, CellStyle], 
            SelectionMove[ nbobj, Before, Cell],
          $Failed =!= NotebookFind[ nbobj, "DetailsSection", Next, CellStyle],
            SelectionMove[ nbobj, All, CellGroup];
            SelectionMove[ nbobj, After, CellGroup],
          True,
            SelectionMove[ nbobj, Before, Notebook]]
        )

histCellUpdate[ nbobj_] := Module[{ histCell, newVal},
        SelectionMove[ nbobj, Before, Notebook];
        SelectionMove[ nbobj, Next, Cell];
        histCell = OldNotebookRead[ nbobj];
        If[ MatchQ[ histCell, Cell[_, flagList, ___]],
         (SelectionMove[ nbobj, Next, Cell];
          histCell = OldNotebookRead[ nbobj])];
        If[MatchQ[ #, {}|{" "}|{"  "}|{"   "}|{"?"}|{"??"}|{"???"}|{"X"}|{"XX"}|{"XXX"}|{"XXXX"}],
          newVal = ToString @ $MVersion,
          newVal = First @ #] &[ Cases[ histCell, (Cell[ val_, "HistoryData", ___, CellTags -> "New", ___] :> val), Infinity]];
        SetOptions[ NotebookSelection[ nbobj], Editable -> True];
        NotebookWrite[ nbobj, histCell /. 
          Cell[ a_String, "HistoryData", b___, CellTags -> "New", c___] :> 
          Cell[ newVal, "HistoryData", b, CellTags -> "New", c]]
        ]

noteDeletion[ nbobj_] := (
        If[ $Failed =!= NotebookFind[ nbobj, "ObsolescenceNote", Next, CellStyle],
          NotebookDelete[ nbobj]];
        If[ $Failed =!= NotebookFind[ nbobj, "AwaitingReviewNote", Next, CellStyle],
          NotebookDelete[ nbobj]];
        If[ $Failed =!= NotebookFind[ nbobj, "PreviewNote", Next, CellStyle],
          NotebookDelete[ nbobj]]
        )


(* Condense more redundancies in this code with subfunctions like the above *)
SymbolStatusSet[stat_String:"Internal"] := 
    Module[{ nb = InputNotebook[], screenEnv, statCell, newVal, msgOpt},
    If[ FreeQ[{"Internal", "Future", "Obsolete", "Excised", "Temporary", "SubjectToChange", "AwaitingFutureDesignReview", "Preview", "UnderDevelopment"}, stat],
        Abort[]];
    If[ nb === $Failed, Abort[]];
  
    screenEnv = (ScreenStyleEnvironment /. AbsoluteOptions[ nb, ScreenStyleEnvironment]);
    
    Which[
      screenEnv === "InternalDocument" && stat === "Internal" ||
      screenEnv === "ObsoleteObject" && stat === "Obsolete" ||
      screenEnv === "ExcisedObject" && stat === "Excised" ||
      screenEnv === "TemporaryObject" && stat === "Temporary" ||
      screenEnv === "SubjectToChange" && stat === "SubjectToChange" ||
      screenEnv === "AwaitingFutureDesignReview" && stat === "AwaitingFutureDesignReview" ||
      screenEnv === "PreviewDocument" && stat === "Preview",
       (SetOptions[ nb, ScreenStyleEnvironment -> "Preview"]; (* required to refresh background, unrelated to PreviewDocument environment and Preview stat -- just coincidence *)
        SetOptions[ nb, ScreenStyleEnvironment -> Inherited];
        SelectionMove[ nb, Before, Notebook];
        SelectionMove[ nb, Next, Cell];
        If[ MatchQ[ OldNotebookRead[ nb], Cell[_, flagList, ___]],
          SetOptions[ NotebookSelection[ nb], Editable -> True, Deletable -> True];
          NotebookDelete[ nb]];
        noteDeletion[ nb]
        ),
      screenEnv === "FutureObject" && stat === "Future",
       (SetOptions[ nb, ScreenStyleEnvironment -> "Preview"]; (* required to refresh background *)
        SetOptions[ nb, ScreenStyleEnvironment -> Inherited]; 
        SelectionMove[ nb, Before, Notebook];
        SelectionMove[ nb, Next, Cell];
        If[ MatchQ[ OldNotebookRead[ nb], Cell[_, flagList, ___]],
          SetOptions[ NotebookSelection[ nb], Editable -> True, Deletable -> True];
          NotebookDelete[ nb];
          SelectionMove[ nb, Next, Cell]];
        histCellUpdate[ nb];
        noteDeletion[ nb] ),
      stat === "Future",
       (SetOptions[ nb, ScreenStyleEnvironment -> "Preview"]; (* required to refresh background *)
        SetOptions[ nb, ScreenStyleEnvironment -> "FutureObject"]; 
        SelectionMove[ nb, Before, Notebook];
        SelectionMove[ nb, Next, Cell];
        statCell = OldNotebookRead[ nb];
        If[ !MatchQ[ statCell, Cell[_, flagList, ___]],
         (SelectionMove[ nb, Before, Cell];
          NotebookWrite[ nb, Cell["F  U  T  U  R  E", "FutureFlag"]];
          SelectionMove[ nb, Next, Cell];
          statCell = OldNotebookRead[ nb]),
         (SetOptions[ NotebookSelection[ nb], Editable -> True, Deletable -> True];
          NotebookWrite[ nb, Cell["F  U  T  U  R  E", "FutureFlag"]];
          SelectionMove[ nb, Next, Cell];
          statCell = OldNotebookRead[ nb])];
        newVal = "??";
        NotebookWrite[ nb, statCell /. 
          Cell[ a_String, "HistoryData", b___, CellTags -> "New", c___] :> 
          Cell[ newVal, "HistoryData", b, CellTags -> "New", c]];
        noteDeletion[ nb] ),
      stat === "Internal",
       (SetOptions[ nb, ScreenStyleEnvironment -> "Preview"]; (* required to refresh background *)
        SetOptions[ nb, ScreenStyleEnvironment -> "InternalDocument"];
        SelectionMove[ nb, Before, Notebook];
        SelectionMove[ nb, Next, Cell];
        statCell = OldNotebookRead[ nb];
        If[ !MatchQ[ statCell, Cell[_, flagList, ___]],
         (SelectionMove[ nb, Before, Cell];
          NotebookWrite[ nb, Cell["I  N  T  E  R  N  A  L", "InternalFlag"]]),
         (SetOptions[ NotebookSelection[ nb], Editable -> True, Deletable -> True];
          NotebookWrite[ nb, Cell["I  N  T  E  R  N  A  L", "InternalFlag"]])];
        histCellUpdate[ nb];
        noteDeletion[ nb] ),
      stat === "Excised",
       (SetOptions[ nb, ScreenStyleEnvironment -> "Preview"]; (* required to refresh background *)
        SetOptions[ nb, ScreenStyleEnvironment -> "ExcisedObject"];
        SelectionMove[ nb, Before, Notebook];
        SelectionMove[ nb, Next, Cell];
        statCell = OldNotebookRead[ nb];
        If[ !MatchQ[ statCell, Cell[_, flagList, ___]],
         (SelectionMove[ nb, Before, Cell];
          NotebookWrite[ nb, Cell["E  X  C  I  S  E  D", "ExcisedFlag"]]),
         (SetOptions[ NotebookSelection[ nb], Editable -> True, Deletable -> True];
          NotebookWrite[ nb, Cell["E  X  C  I  S  E  D", "ExcisedFlag"]])];
        histCellUpdate[ nb];
        noteDeletion[ nb] ),
      stat === "Temporary",
       (SetOptions[ nb, ScreenStyleEnvironment -> "Preview"]; (* required to refresh background *)
        SetOptions[ nb, ScreenStyleEnvironment -> "TemporaryObject"];
        SelectionMove[ nb, Before, Notebook];
        SelectionMove[ nb, Next, Cell];
        statCell = OldNotebookRead[ nb];
        If[ !MatchQ[ statCell, Cell[_, flagList, ___]],
         (SelectionMove[ nb, Before, Cell];
          NotebookWrite[ nb, Cell["T  E  M  P  O  R  A  R  Y", "TemporaryFlag"]]),
         (SetOptions[ NotebookSelection[ nb], Editable -> True, Deletable -> True];
          NotebookWrite[ nb, Cell["T  E  M  P  O  R  A  R  Y", "TemporaryFlag"]])];
        histCellUpdate[ nb];
        noteDeletion[ nb] ),
      stat === "SubjectToChange",
       (SetOptions[ nb, ScreenStyleEnvironment -> "Preview"]; (* required to refresh background *)
        SetOptions[ nb, ScreenStyleEnvironment -> "SubjectToChange"];
        SelectionMove[ nb, Before, Notebook];
        SelectionMove[ nb, Next, Cell];
        statCell = OldNotebookRead[ nb];
        If[ !MatchQ[ statCell, Cell[_, flagList, ___]],
         (SelectionMove[ nb, Before, Cell];
          NotebookWrite[ nb, Cell["S  U  B  J  E  C  T    T  O    C  H  A  N  G  E", "SubjectToChangeFlag"]]),
         (SetOptions[ NotebookSelection[ nb], Editable -> True, Deletable -> True];
          NotebookWrite[ nb, Cell["S  U  B  J  E  C  T    T  O    C  H  A  N  G  E", "SubjectToChangeFlag"]];
          histCellUpdate[ nb];
          noteDeletion[ nb]
          )]),
      stat === "AwaitingFutureDesignReview",
       (SetOptions[ nb, ScreenStyleEnvironment -> "Preview"]; (* required to refresh background *)
        SetOptions[ nb, ScreenStyleEnvironment -> "AwaitingFutureDesignReview"];
        SelectionMove[ nb, Before, Notebook];
        SelectionMove[ nb, Next, Cell];
        statCell = OldNotebookRead[ nb];
        If[ !MatchQ[ statCell, Cell[_, flagList, ___]],
         (SelectionMove[ nb, Before, Cell];
          NotebookWrite[ nb, Cell["A  W  A  I  T  I  N  G    F  U  T  U  R  E    D  E  S  I  G  N    R  E  V  I  E  W", "AwaitingFutureDesignReviewFlag"]]),
         (SetOptions[ NotebookSelection[ nb], Editable -> True, Deletable -> True];
          NotebookWrite[ nb, Cell["A  W  A  I  T  I  N  G    F  U  T  U  R  E    D  E  S  I  G  N    R  E  V  I  E  W", "AwaitingFutureDesignReviewFlag"]])];
        histCellUpdate[ nb];
        noteDeletion[ nb];
        navSequence[ nb];
        If[ !MatchQ[ statCell, Cell[_, "AwaitingFutureDesignReviewFlag", ___]],
          NotebookWrite[ nb, 
            Cell[TextData[{ "This function has not been fully integrated into the long-term ",
              StyleBox["Mathematica", FontSlant->"Italic"], " system, and is subject to change.  ",
              ButtonBox[">>",
                ButtonData->"paclet:tutorial/ObjectsInMathematicaAwaitingFutureDesignReview",
                ButtonNote->"More Info placeholder",
                BaseStyle->"Link"]}], "AwaitingReviewNote"]]]
        ),
      stat === "Obsolete",
       (SetOptions[ nb, ScreenStyleEnvironment -> "Preview"]; (* required to refresh background *)
        SetOptions[ nb, ScreenStyleEnvironment -> "ObsoleteObject"];
        SelectionMove[ nb, Before, Notebook];
        SelectionMove[ nb, Next, Cell];
        statCell = OldNotebookRead[ nb];
        If[ !MatchQ[ statCell, Cell[_, flagList, ___]],
         (SelectionMove[ nb, Before, Cell];
          NotebookWrite[ nb, Cell["O  B  S  O  L  E  T  E", "ObsoleteFlag"]]),
         (SetOptions[ NotebookSelection[ nb], Editable -> True, Deletable -> True];
          NotebookWrite[ nb, Cell["O  B  S  O  L  E  T  E", "ObsoleteFlag"]]) ];
        histCellUpdate[ nb];
        noteDeletion[ nb];
        navSequence[ nb];
        If[ !MatchQ[ statCell, Cell[_, "ObsoleteFlag", ___]],
          NotebookWrite[ nb, Cell["XXXX", "ObsolescenceNote"], All];
          SelectionMove[ nb, All, CellContents]]
        ),
      stat === "Preview",
       (SetOptions[ nb, ScreenStyleEnvironment -> "Preview"]; (* required to refresh background *)
        SetOptions[ nb, ScreenStyleEnvironment -> "PreviewDocument"];
        SelectionMove[ nb, Before, Notebook];
        SelectionMove[ nb, Next, Cell];
        statCell = OldNotebookRead[ nb];
        If[ !MatchQ[ statCell, Cell[_, flagList, ___]],
         (SelectionMove[ nb, Before, Cell];
          NotebookWrite[ nb, Cell["P  R  E  V  I  E  W", "PreviewFlag"]]),
         (SetOptions[ NotebookSelection[ nb], Editable -> True, Deletable -> True];
          NotebookWrite[ nb, Cell["P  R  E  V  I  E  W", "PreviewFlag"]])];
        histCellUpdate[ nb];
        noteDeletion[ nb];
        navSequence[ nb];
        If[ !MatchQ[ statCell, Cell[_, "PreviewFlag", ___]],
          NotebookWrite[ nb, 
            Cell[TextData[{ "This function will be released in a future version of ",
              StyleBox["Mathematica", FontSlant->"Italic"], ".\n",
              ButtonBox["Sign up here for availability information \[RightGuillemet]",
                ButtonData->{URL["http://www.wolfram.com/common/cgi/feedback.cgi?"], None},
                ButtonNote->"More Information",
                BaseStyle->"Link"]}], "PreviewNote"]]]
        ),
      stat === "UnderDevelopment",
	   (msgOpt = MessageOptions /. Options[$FrontEnd, MessageOptions];
		SetOptions[ $FrontEnd, MessageOptions->{"WarningAction"->{}}];
		SetOptions[$FrontEnd, FindSettings -> {"Wraparound" -> True}];
		If[ NotebookFind[ nb, "UnderDevelopment", Next, CellTags] =!= $Failed,
		 (NotebookDelete[ nb];
		  Abort[])];
		If[ Select[ NotebookFind[ nb, #, Next, CellStyle] & /@ {
		    "ObjectName", "GuideTitle", "Title", "ObjectNameAlt", "ForeignFunctionLabel", 
		    "DataSourceTitle", "CharacterImage", "UpgradeLabel", "TOCDocumentTitle"}, 
		      MatchQ[ #, NotebookSelection[_]]&, 1] =!= {},
		 (SelectionMove[ nb, Before, Cell];
		  NotebookWrite[ nb, 
		    Cell["U N D E R   D E V E L O P M E N T",
 		      CellFrame->0.5,
 	          ShowCellBracket->Automatic,
 	          CellMargins->{{8, 8}, {-8, 32}},
 		      CellElementSpacings->{"ClosedGroupTopMargin"->32},
 		      CellGroupingRules->{"SectionGrouping", 50},
 		      CellFrameMargins->{{36, 12}, {8, 8}},
 		      CellFrameColor->RGBColor[0.74902, 0.694118, 0.552941],
 		      CellChangeTimes->{3.4749170196002893`*^9},
 		      FontFamily->"Verdana",
 		      FontSize->11,
 		      FontWeight->"Bold",
 		      FontColor->RGBColor[1, 0, 0],
 		      CellTags->"UnderDevelopment"], All])];
		SetOptions[$FrontEnd, MessageOptions -> msgOpt]),
 	  True,
       (SetOptions[ nb, ScreenStyleEnvironment -> "Preview"]; (* required to refresh background *)
        SetOptions[ nb, ScreenStyleEnvironment -> Inherited])
      ]
    ]





(* SelectionCapture uses FE token NotebookImage which is currently only supported on Windows.
   NotebookImage returns Graphics[] metafunction and therefore requires ToBoxes for writing
   directly to a notebook as part of a function that is not a direct evaluation in a notebook.
   Still needs heuristic for window height, and perhaps margins adjustment option.
   -- AK 1/4/07 *)

$WindowWidth = 450
$WindowName = Automatic
$CapturedImage
$VisibleSelection = Automatic

$NotebookCapturePaletteFrame = True

$OfferRevert = False (* For my use, I'll  set True--walsh, Mar 2007 *)

SelectionCapture::incompatibleOS = "The selection capture (notebook image) function is only supported on Windows.";

CaptureNotebook[] :=
First @
  Cases[ Notebooks[],
    no_NotebookObject /;
      no =!= ButtonNotebook[] &&
      FreeQ["FileName" /. NotebookInformation[ no], "DocuTools"] &&
      (Not[ WindowClickSelect /. Options[ no, WindowClickSelect] ] ||
        no === SelectedNotebook[] ), 
      {1},
      1
  ]

SelectionCapture[] :=
SelectionCapture[ CaptureNotebook[] ]

SelectionCapture[ nb_NotebookObject] :=
Module[{nbSel, cSel, styDef, nbOpts, nbBack, nbExample, nbCap, modFlag},
      Catch[
      If[ $OperatingSystem =!= "Windows",
        Throw[ MessageToConsole[ SelectionCapture::incompatibleOS]]];
      (**** Forget about this distinction for now, always capture notebook:
      If[ DocumentationTools`CellInfo[nb] === $Failed, 
       (nbSel = True;
        nbOpts = Options[nb]), 
        nbSel = False]; *****)
      If[ DocumentationTools`CellInfo[nb] === $Failed,
        cSel = False,
        cSel = True];
      nbSel = True;
      nbOpts = Options[nb];
      modFlag = "ModifiedInMemory" /. NotebookInformation[ nb];
      styDef = (StyleDefinitions /. Options[ nb, StyleDefinitions]);
      
      (* Hack for keeping rounded corners of captured window clean, moot now with setting square cornered palette window frame:
      nbBack = NotebookPut @ Notebook[{}, WindowSize -> 1000]; (* Hack to provide white background so captured window is clean *)
      NotebookWrite[ nbBack, Cell[""], All]; (* Hack to force rendering of blank notebook as white page *)
      NotebookDelete[ nbBack];
      *)

      If[ nbSel,
        (* SelectionMove[nb, Before, Notebook];
           NotebookWrite[ nb, Cell[""], All]; *** Hack to force rendering of captured notebook completely, seems moot now ***
           NotebookDelete[ nb];
           SelectionMove[nb, After, Notebook];
           SelectionMove[nb, Before, Notebook]; *)
        Replace[
          Replace[ NotebookImageTempOptions[ nbOpts, cSel, modFlag, nb], {
            optlist_List :> optlist,
            _ :>
              Replace[ NotebookImageTempOptions[ nbOpts], {
                optlist_List :> optlist,
                _ :>
                  {
                    WindowFrame -> "Palette", 
                    WindowElements -> {}, 
                    WindowFrameElements -> {"CloseBox"}, 
                    If[ (Background /. nbOpts) === Background,
                      Background -> GrayLevel[1],
                      Background -> (Background /. nbOpts)],
                    WindowSize -> {$WindowWidth, Inherited},
                    Which[ 
                      StringQ[ WindowTitle /. nbOpts] && !StringQ[ $WindowName], 
                        WindowTitle->(WindowTitle /. nbOpts), 
                      StringQ[ WindowTitle /. nbOpts] && StringQ[ $WindowName],
                        WindowTitle->$WindowName,
                      !StringQ[ WindowTitle /. nbOpts] && StringQ[ $WindowName],
                        WindowTitle->$WindowName,
                      True,
                        WindowTitle->"Untitled-1"],
                    Which[ 
                      $VisibleSelection === False, 
                        ShowSelection->False,
                      $VisibleSelection === True,
                        ShowSelection->True,
                      $VisibleSelection === Automatic && cSel,
                        ShowSelection->True,
                      True,
                        ShowSelection->False]
                  }
              }]
          }],
          {opts___} :> SetOptions[nb, opts]
        ];
        SetSelectedNotebook[ nb];
        nbCap = MathLink`CallFrontEnd[ FrontEnd`NotebookImage[ nb]];
(* NotebookClose[ nbBack];      *** Harmless artifact of moot hack above *)
        If[ Not[ modFlag] && TrueQ[ $OfferRevert],
          FrontEndExecute[ FrontEndToken[ nb, "Revert"] ]
        ];
        If[ "ModifiedInMemory" /. NotebookInformation[ nb],
(* If the notebook does not have modified status, which would be
the case if the Revert token was executed and the user clicked "yes",
then no option resetting should be done. --walsh, March 2007 *)
          SetOptions[ nb, 
            WindowFrame -> Inherited, 
            WindowElements -> Inherited, 
            WindowTitle -> Inherited,
            Background -> Inherited,
            WindowFrameElements -> Inherited, 
            WindowClickSelect -> Inherited,
            ShowSelection -> Inherited];
          SetOptions[nb, nbOpts]
        ]
      , (* else (not nbSel) *)
        nbExample = NotebookPut @ Notebook[{ Flatten @ NotebookRead[ nb]}, 
                        WindowSize -> {$WindowWidth, FitAll}, 
                        StyleDefinitions -> styDef];
        SetOptions[ nbExample, 
          WindowSize -> {$WindowWidth, (Last@(WindowSize /. AbsoluteOptions[nbExample, WindowSize])) + 20},
          If[StringQ[$WindowName], WindowTitle->$WindowName, WindowTitle->Automatic], 
          WindowFrame -> "Palette", 
          WindowElements -> {}, 
          WindowFrameElements -> {"CloseBox"}, 
          Background -> GrayLevel[1]];
        SelectionMove[ nbExample, After, Notebook];
        NotebookWrite[ nbExample, Cell[""], All]; (* Hack to force rendering of captured notebook completely *)
        NotebookDelete[ nbExample];
        SetOptions[ nbExample, ShowSelection -> False]; (* Can't do this earlier else NotebookDelete fails *)
        SelectionMove[ nbExample, After, Notebook];
        SelectionMove[ nbExample, Before, Notebook];
        nbCap = MathLink`CallFrontEnd[ FrontEnd`NotebookImage[ nbExample]];
        NotebookClose[ nbExample];
        NotebookClose[ nbBack]; (* Harmless artifact of moot hack above *)
        SelectionMove[ nb, All, CellGroup];
        SelectionMove[ nb, After, Cell]
      ];
      If[ nbSel,
        (* SetSelectedNotebook[Notebooks[][[3]]]; (* HACK: needs to be set to first regular (non-palette) NB under capture NB, or write to symbol that gets inserted via notch *)
           NotebookWrite[ InputNotebook[], Cell[ BoxData[ ToBoxes @ nbCap], "Output", 
             PageWidth->WindowWidth,
             CellTags->"Notebook Image"]];
           SetSelectedNotebook[ nb] *)
        $CapturedImage = nbCap,
      (NotebookWrite[ nb, Cell[ BoxData[ ToBoxes @ nbCap], "NotebookImage", 
          CellTags->"Notebook Image"], All];
        NotebookWrite[ nb, NotebookRead[ nb] /. 
          Cell[ BoxData[ GraphicsBox[ rastCont_, opt1___, ImageSize -> {imgSzW_, imgSzH_}, opts2___]], cellOpts___] -> 
            Cell[ BoxData[ GraphicsBox[ rastCont, opt1, ImageSize -> {imgSzW*.75, imgSzH*.75}, opts2]], cellOpts]])]
    ]]

(* SelectionCapture options management customization by Jerry Walsh. *)

(*
SelectionCapture, by way of NotebookImageTempOptions,
normally sets some options on the notebook it is capturing, we
want to let a notebook's explicit setting for certain options
override the standard capture settings.
    What are the settings SelectionCapture usually uses, and
how might someone set them differently?
    WindowFrame: Always set to "Palette" to make a narrower
frame--not overrideable.
    WindowClickSelect: Always set to True.  Otherwise, palettes
would have a nonselected appearance when captured.
    WindowSize: Leaves the height as is but sets the
width to $WindowWidth (450 by default).  Leaves both height and
width as they are if $WindowWidth is set to Automatic, or if the
original notebook has a dialog or palette frame.
    ShowSelection: Shows selection of cell brackets, but not
insertion lines. Sometimes you really want to see the insertion
point, in which case you can either set $VisibleSelection to True
or just explicitly set ShowSelection->True for the notebook.
    WindowTitle: Set to "Untitled-1" or "Untitled-1 *", the latter
being used for notebooks that have unsaved modifications. If
$WindowName evaluates to a string, that string is used, with no
added "*".  Sometimes you might want an example that creates two
untitled windows, in which case you want to set a window name of
"Untitled-2" for the second one.  Other examples might involve
notebooks with specific settings of WindowTitle.  If you want
WindowTitle -> Automatic behavior to be in effect, you can set
it at the notebook scope for the notebook being captured.
    WindowElements: Set to {} for simplicity and smallness.
It should be set differently when some window element is
essential to the illustration.
    WindowFrameElements: Set to {"CloseBox"}. Can be set otherwise
to illustrate other frame elements.
    Background: Set to GrayLevel[1.] for general windows, and to
None for dialogs and palettes.  The window frame at capture time
is always "Palette", and this would give plain documents a gray
background if it were not set by the SelectionCapture routine.
Set in the notebook to show a different background from the
usual ones.
*)
 
(*
    Optionate[ opts] returns a pure function, let us call it f,
of two arguments, such that f[ optionName, default] returns the
option setting for optionName that is in opts, if there is one;
otherwise, it returns optionName -> default.
*)
Optionate[opts_] :=
Function[{optname, dvalue},
  optname ->
       Replace[optname, Append[opts, _ -> dvalue]]
]

NotebookImageTempOptions[opts_List, cellSelected_, modFlag_, nb_] :=
Block[{origFrame = Replace[ WindowFrame, opts]},
  Flatten[{
    If[ $NotebookCapturePaletteFrame,
      WindowFrame -> "Palette",
      {},
      {}
    ],
    WindowClickSelect -> True,
    If[ origFrame === WindowFrame,
      WindowSize -> {$WindowWidth, Inherited},
      {}],
    If[ $VisibleSelection,
      ShowSelection -> True,
      ShowSelection -> False,
      Optionate[opts][ ShowSelection, cellSelected]
    ],
    Replace[ $WindowName, {
      s_String :> (WindowTitle -> s),
      _ :> Replace[ WindowTitle /. Options[ nb, WindowTitle], {
          Automatic :>
            Replace[ WindowTitle /. AbsoluteOptions[ nb, WindowTitle], {
              s_String /;
                StringMatchQ[ s, RegularExpression["Untitled-[0-9]+(\\.nb)?"] ]
              :>
                (WindowTitle -> "Untitled-1" <> If[ modFlag, " *", ""]),
              t_String :> (WindowTitle -> t <> If[ modFlag, " *", ""]),
              _ -> {}
            }],
          _ -> {}
        }],
        _ :> {}
    }],
    Optionate[opts] @@@ {
      {WindowElements, {}},
      {WindowFrameElements, {"CloseBox"}},
      {Background, 
        Replace[ origFrame, {
          "Palette" | "ModelessDialog"  | "ModalDialog" -> None,
          _ -> GrayLevel[1.]
        }]}
      }
  }]
]

(* end of SelectionCapture options management customization. *)

NotebookCaptureInsert[] := Module[{nb = InputNotebook[]},
    If[ MatchQ[ $CapturedImage, Graphics[__]],
      NotebookWrite[ nb, Cell[ BoxData[ ToBoxes[ $CapturedImage] /. 
        GraphicsBox[ rastCont_, opt1___, ImageSize -> {imgSzW_, imgSzH_}, opts2___] -> 
            GraphicsBox[ rastCont, opt1, ImageSize -> {imgSzW*.75, imgSzH*.75}, opts2]
          ], "NotebookImage", 
        CellTags->"Notebook Image"]]
      ]
    ]



(* Checkbox function for Example Status metadata. 
   Might try to use convert to literal function for extracting value of checkbox for testing purposes,
   or perhaps when checkmarked is clicked, but all attempts to exploit this function directly have failed so far:
   FrontEndExecute[{ FrontEnd`NotebookDynamicToLiteral[ FrontEnd`NotebookSelection[ FrontEnd`InputNotebook[]]]}] *)

ExampleStatusStamp[ val_] := Module[{},
 If[ val,
   (SelectionMove[ ButtonNotebook[], All, "ButtonCell"]; 
    MathLink`CallFrontEnd[ FrontEnd`SelectionAddCellTags[ ButtonNotebook[], "Status:True"]]; 
    SelectionMove[ ButtonNotebook[], After, CellContents]; 
    FrontEndTokenExecute[ ButtonNotebook[], "SelectPreviousWord"]; 
    NotebookWrite[ ButtonNotebook[], TextData[ StringJoin[ $UserName, ":", DateString[{"Year", ":", "Month", ":", "Day", ":", "Hour24", ":", "Minute", ":", "Second"}]]]]),
   (SelectionMove[ ButtonNotebook[], All, "ButtonCell"]; 
    MathLink`CallFrontEnd[ FrontEnd`SelectionRemoveCellTags[ ButtonNotebook[], "Status:True"]]; 
    SelectionMove[ ButtonNotebook[], After, CellContents]; 
    FrontEndTokenExecute[ ButtonNotebook[], "SelectPreviousWord"]; 
    NotebookWrite[ ButtonNotebook[], TextData[ StringJoin[ $UserName, ":", DateString[{"Year", ":", "Month", ":", "Day", ":", "Hour24", ":", "Minute", ":", "Second"}]]]])
   ]]


ExampleStatusSummary[n_] := Module[{nList},
nList = Union @ Cases[ DownValues[ DocumentationTools`ExampleStatus], DocumentationTools`ExampleStatus[_, id_Integer] :> id, Infinity];
With[{statuses = ExampleStatus[n, #]& /@ Flatten[{"DQA", "Authoring", nList}]},
  Which[
    MemberQ[ statuses, False], False,
    MemberQ[ statuses, True], True,
    True, Indeterminate
  ]] ]

ExampleStatusSummary[n_, checkstate_] := Module[{nList},
nList = Union @ Cases[ DownValues[ DocumentationTools`ExampleStatus], DocumentationTools`ExampleStatus[_, id_Integer] :> id, Infinity];
With[{statuses = ExampleStatus[n, #]& /@ Flatten[{"DQA", "Authoring", nList}]},
  Which[
    MemberQ[ statuses, False], False,
    MemberQ[ statuses, True], True,
    True, checkstate
  ]] ]


ExampleStatusShow[] := Module[{ nb = InputNotebook[]},
    SelectionMove[ nb, Before, Notebook];
    If[ NotebookFind[ nb, "ExampleStatus", Next, CellStyle] =!= $Failed,
      SelectionMove[ nb, All, CellGroup];
      SelectionMove[ nb, After, CellGroup]]]

ExampleStatusAuthorInsert::noselmatch = "The example status author cell(s) don't match the expected pattern and can't be selected/navigated properly.";

ExampleStatusAuthorInsert[] := Module[{ nb, authNum, authSel},
    If[ InputNotebook[] =!= $Failed,
      nb = InputNotebook[],
      Abort[]];
    Clear[ DocumentationTools`ExampleStatus];
    SelectionMove[ nb, Before, Notebook];
    If[ NotebookFind[ nb, "ExampleStatus", Next, CellStyle] =!= $Failed,
     (SelectionMove[ nb, All, CellGroup];
      authNum = Length @ Cases[ NotebookRead[ nb], Cell[_, "ExampleStatus", ___, CellLabel -> "Example Authors", ___], Infinity];
      SelectionMove[ nb, Before, CellGroup];
      If[ authNum == 0,
       (SelectionMove[ nb, Next, Cell, 4];
        SelectionMove[ nb, After, Cell];
        authSel = "NoSel"),
       (SelectionMove[ nb, Next, Cell, authNum + 4];
        authSel = NotebookRead[ nb])];
      Which[ 
        authSel === "NoSel" || MatchQ[ authSel, Cell["", "ExampleStatus", ___, CellLabel -> "Example Authors", ___]],
          ExampleStatusAuthorCellWrite[ nb],
        MatchQ[ authSel, Cell[_, "ExampleStatus", ___, CellLabel -> "Example Authors", ___]] &&  
        !MatchQ[ authSel, Cell["", "ExampleStatus", ___, CellLabel -> "Example Authors", ___]],
          SelectionMove[ nb, After, Cell];
          ExampleStatusAuthorCellWrite[ nb],
        True,
          MessageToConsole[ ExampleStatusAuthorInsert::noselmatch];
          Abort[]
        ]),
      MessageToConsole[ ExampleStatusAuthorInsert::noselmatch] ]
    ]

ExampleStatusAuthorCellWrite[ nb_] := Module[ {idNum},
    NotebookWrite[ nb, Cell["Author Status Placeholder", "ExampleStatus", CellLabel->"Example Authors"], All];
    idNum = First @ ("CellSerialNumber" /. DocumentationTools`CellInfo[ nb]);
    SelectionMove[ nb, All, CellContents];
    NotebookWrite[ nb, ExampleStatusAuthorCell[ idNum], All];
    SelectionMove[ nb, After, Cell]
    ]

ExampleStatusAuthorCell[ n_] := TextData[{ 
                                  Cell[ BoxData[ 
                                    DynamicModuleBox[{$CellContext`exStat = False}, 
                                    CheckboxBox[ Dynamic[DocumentationTools`ExampleStatus[EvaluationNotebook[], n] = $CellContext`exStat, 
                                    ($CellContext`exStat = #; DocumentationTools`ExampleStatusStamp[$CellContext`exStat]) &]], 
                                    DynamicModuleValues :> {}]]], 
                                  " ", "unsigned:undated"}]


$UndeploymentRefresh = DateString[]

UndeploymentSetter[ nb_:Notebook] := Module[ {trules, clnrules},
        If[ nb === $Failed, Abort[]];
        trules = (TaggingRules /. Options[ nb, TaggingRules]);
        Which[
          trules === None,
            SetOptions[ nb, TaggingRules -> {"UndeployInDocsBuild" -> True}];
            $UndeploymentRefresh = DateString[],
          FreeQ[ trules, "UndeployInDocsBuild" -> True],
            SetOptions[ nb, TaggingRules -> Union @ Append[ trules, "UndeployInDocsBuild" -> True]];
            $UndeploymentRefresh = DateString[],
          True,
            clnrules = DeleteCases[ trules, "UndeployInDocsBuild" -> True]; 
            SetOptions[ nb, TaggingRules -> If[ clnrules === {}, Inherited, clnrules]];
            $UndeploymentRefresh = DateString[]]
        ]

UndeploymentSetting[ nb_:Notebook] := 
       (If[ nb === $Failed, Abort[]];
        trules = CurrentValue[ nb, TaggingRules]; (* Use CurrentValue instead of Options[] until the latter is made to work with Dynamics *)
        !FreeQ[ trules, "UndeployInDocsBuild" -> True])




(* Some code from SystemResourcesFromDocs.m *)

SetAttributes[BlockMessageOff, HoldAll] 
    
BlockMessageOff[{msgnames___MessageName}, body_] := 
   With[{onMsgNames = DeleteCases[Hold[msgnames], mn_ /; Head[mn] === $Off]}, 
      Scan[Off, onMsgNames]; 
      First @ {body, Scan[On, onMsgNames]}]

GetTemplateCells::nusage = "No usage cell found for `1`."

GetTemplateCells[ nbex_, name_] :=
Module[{
   preusagecell = Cases[ nbex, Cell[_, "Usage", ___], Infinity],
   usagecell
},
   name
      ->
   Flatten[
      Join[
         If[ preusagecell =!= {},
            usagecell = preusagecell[[1]]; 
            Cases[
               Extract[ usagecell, 
                  Position[
                     usagecell,
                     x_String /; StringMatchQ[x, "\[LineSeparator]*" | " \[LineSeparator]*"]
                  ]
                     /. {a__, b_Integer} :> {a, b - 1}
               ],
                  Cell[
                     BoxData[ RowBox[{name, "[", __}] ],
                     "InlineFormula",
                     a___ /; Not @ MemberQ[{a}, "TemplateExclusion"]
                  ],
               Infinity
            ]
         , 
            MessageToConsole[GetTemplateCells::nusage, name]; $Failed
         ], 
         Cases[ nbex,
            a : Cell[_, "Notes", ___] :>
               Cases[ a,
                  Cell[BoxData[RowBox[{name, "[", __}]],
                     "FunctionTemplate" | "InlineFormula", 
                     b___ /; MemberQ[{b}, "TemplateInclusion"]
                  ],
                  Infinity
               ],
            Infinity
         ],
         Cases[ nbex,
            Cell[BoxData[RowBox[{name, "[", __}]],
               __,
               CellLabel -> "Additional Function Template",
               ___
            ],
            Infinity
         ]
      ]
   ]
]

(* Trick to avoid annoying contexts for pattern names being introduced below *)

placeholder = Global`placeholder;
options = Global`options;

(* Various utility functions for doing the conversion and merging of templates *)

CleanUpTemplate[s_]:=StringReplace[s,{":>"->":>","->"->"->",Characters["\n \"`:\\+=->"]->""}]

ConvertTemplate[s_] := 
  StringReplace[
    s, {RegularExpression["(\\w+),((\\w+),)*\[Ellipsis]+"] :> "$1..", 
      RegularExpression[",([^{}]*?),\[Ellipsis]+"] :> ",$1...", 
      RegularExpression[",([^{}]*?)\[Ellipsis]+"] :> ",placeholder...", 
      "\[Ellipsis]" -> "placeholder...", "..."->"placeholder...","." -> ""}]

GetArgs[s_] := 
  StringCases[s, 
      StringExpression[title : (WordCharacter ..), 
          args : StringExpression["[", ___, "]"]] :> args][[1]]

TranslateArgs[args_String] := 
 ToExpression[
   StringJoin["{", StringReplace[args, Characters["[]"] -> ""], "}"]] /. 
   {List -> List, (Rule | RuleDelayed)[a_, b_] :> 
    If[MatchQ[Head[b],Repeated|RepeatedNull], Head[b][
       If[Head[a]===Symbol,a,placeholder]],
    If[Head[a] === Symbol, Hold[Pattern][a, Blank[]], 
     Hold[Pattern][placeholder, Blank[]]]], 
   HoldPattern[Repeated][x_] :> Hold[Repeated][x], 
   HoldPattern[RepeatedNull][x_] :> Hold[RepeatedNull][x], 
   x_Symbol :> Hold[Pattern][x, Blank[]]}

MergeArgs[args_List]:=If[Length[args]==1,args[[1]],
      Module[{len=Length/@args, listq, rep, lists, el, opt, $$j,n},
         Table[listq=True;rep=False;lists={};el=Null;opt=False;n=0;
            Do[
               
     If[Length[args[[$$j]]]>=$$i,arg=args[[$$j,$$i]];n++;
                  If[!ListQ[arg]&&listq&&!rep,listq=False;el=arg];
                  
      If[Head[arg]==Repeated||Head[arg]==RepeatedNull,
                     listq=False;rep=True;el=arg];
                  If[ListQ[arg]&&listq,AppendTo[lists,arg]];
                  If[el===Null,el=arg],opt=True],{$$j,Length[args]}];
            If[listq,el = MergeArgs[lists]];
            If[rep&&n>1,el[[1]]=placeholder];
            If[opt,Optional[el],el]
            ,{$$i,Max[len]}]]]    
    
AddOptions[fun_,patt_]:=
   If[Options[ToExpression[fun]]=!={},Append[patt,options...], patt]/.
          {HoldPattern[Optional][
               HoldPattern[Pattern][options,Blank[]]]:>
            RepeatedNull[options],
         HoldPattern[Pattern][options,Blank[]]:>
            RepeatedNull[options]}   

(* The following function cleans up the box structure of a cell to generate 
a simple string, it might be fragile and need modification if more general
boxes start appearing in the templates *)

TemplateToString[tcell_Cell]:=
 StringJoin[(tcell[[1]]//.
    {BoxData->List,TextData->List,RowBox->List,SubscriptBox->List,SuperscriptBox->List,
      StyleBox[s_,__]:>s, ButtonBox[s_,___]:>s})
      /.s_String:>ToString[s]  (*To get rid of linear syntax *)]

(* This function takes the output from GetTemplates and returns the 
corresponding entry for FunctionTemplates.m. If a problem occurs,
no template is generated for that function. *)

SyntaxTemplatesToSyntaxPattern[function_String->cells_]:=
 TimeConstrained[Check[Module[{$$data}, $$data = cells;
    If[cells==={},Return[{}]];
    $$data = ConvertTemplate/@CleanUpTemplate/@TemplateToString/@cells;
    $$data=ReleaseHold[TranslateArgs/@GetArgs/@$$data];
    $$data=MergeArgs[$$data];
    $$data = AddOptions[function, $$data];
    {function,$$data}],
   {}],
   5,{}]

(* End of code from SystemResourcesFromDocs.m *)


SyntaxTemplateInsert::noin = "There is no input notebook.";
SyntaxTemplateInsert::notsaved = "The working notebook is not saved.";
SyntaxTemplateInsert::modified = "The working notebook has been modified. Save the notebook and then click on the Insert Syntax Template button again.";
SyntaxTemplateInsert::nobjnm = "There is no \"ObjectName\" cell in the input notebook.";
SyntaxTemplateInsert::notemplates = "The function has no templates.";
SyntaxTemplateInsert::failure = "An error has occurred in attempting to make the template.";
SyntaxTemplateInsert::templssecnf = "A templates section was not found in the input notebook.";

SyntaxTemplateInsert[] := 
 Module[{nb = InputNotebook[], ni, file, gt, cs, name, templatecells, stpatt, templatecell},
 
  Catch[If[(* There is no input notebook. *)nb === $Failed, 
           Throw[MessageToConsole[SyntaxTemplateInsert::noin]]];
           
        ni = NotebookInformation[nb];
           
        If[(file = ("FileName" /. ni); file) === "FileName", 
           Throw[MessageToConsole[SyntaxTemplateInsert::notsaved]]];
           
        If["ModifiedInMemory" /. ni,
           Throw[MessageToConsole[SyntaxTemplateInsert::modified]]];
           
        gt = BlockMessageOff[{Syntax::newl}, Get[ToFileName[file]]]; 
        If[(cs = Cases[gt, a : Cell[_, "ObjectName", ___] :> a[[1]], Infinity]; cs === {}), 
           Throw[MessageToConsole[SyntaxTemplateInsert::nobjnm]]];
           
        name = cs[[1]]; 
        templatecells = GetTemplateCells[gt, name]; 
        If[MatchQ[templatecells, _String -> {}], 
           Throw[MessageToConsole[SyntaxTemplateInsert::notemplates]]];
           
        If[(stpatt = SyntaxTemplatesToSyntaxPattern[templatecells]; stpatt) === $Failed, 
           Throw[MessageToConsole[SyntaxTemplateInsert::failure]]];
           
        If[Not@MatchQ[stpatt, {_String, _List}], 
           Throw[MessageToConsole[SyntaxTemplateInsert::failure]]];
           
        templatecell = Cell[BoxData[ToBoxes[stpatt, StandardForm]], "Template", 
                            CellLabel -> "Automatically Generated Master Argument Pattern"];
           
        If[NotebookFind[nb, "Automatically Generated Master Argument Pattern", All, CellLabel] === $Failed,
        
           If[NotebookFind[nb, "TemplatesSection", All, CellStyle] === $Failed, 
              Throw[MessageToConsole[SyntaxTemplateInsert::templssecnotfound]]];
           
           SelectionMove[nb, After, Cell]; 
           NotebookWrite[nb, templatecell, All],
           
           NotebookWrite[nb, templatecell, All]]]]


(* Code for NotebookSearch dialog. *)

(* Needs["AuthorTools`Experimental`"] *)

(*

makeDirectoriesAndButtons[xml_] := 
 Flatten[If[MatchQ[#, {Style[__]}], #, Band[{"  ", Column[#]}]] & /@ 
    Split[Flatten[{Style[#[[1, 1]], Bold], Last /@ #} & /@ 
      Split[Transpose[
        Function[u, {u[[1]], 
           MapThread[
            Function[{r, s}, 
             Button[Style[s, FontColor -> Dynamic[If[MemberQ[$purpled, s], 
                                                     Purple, 
                                                     RGBColor[0.269993, 0.308507, 0.6]]]], 
             ($purpled = Flatten[{ToExpression[#[[1]]], $purpled}]; 
              NotebookOpen[r <> s]) &, Appearance -> None]], u]}][Transpose[{DirectoryName[#], 
             StringReplace[#, DirectoryName[#] -> ""]} & /@ 
 Cases[xml, {XMLElement["category", {}, {"file"}], ___, XMLElement["url", {}, {url_}], __} :> url, 8]]]], 
            #[[1]] === #2[[1]] &]], 
          Head[#1] === Head[#2] &]]
          
makeDirectoriesAndButtons[query_, viewnumber_] := 
 makeDirectoriesAndButtons[Import[query <> "&start=" <> ToString[$resultsnumber (viewnumber - 1)], "XML"]]
 
FileCountFound[x_] := Cases[x, XMLElement["results", {"count" -> count_}, ___] :> ToExpression@count, Infinity][[1]]

SetAttributes[NextSet, HoldAll]

NextSet[display_, viewnumber_, Query_] := 
 Module[{im1}, 
        If[$resultsnumber viewnumber < $number, viewnumber++; 
           im1 = Import[Query <> "&start=" <> ToString[$resultsnumber(viewnumber - 1)], "XML"]; 
           $number = FileCountFound[im1]; 
           If[$number > $resultsnumber(viewnumber - 1), 
              display = makeDirectoriesAndButtons[im1], viewnumber--]]]
              
SetAttributes[PreviousSet, HoldAll]

PreviousSet[display_, viewnumber_, Query_] := 
 If[viewnumber > 1, 
    viewnumber--; display = makeDirectoriesAndButtons[Query, viewnumber]]

stringRiffle[expr_, object_] := StringJoin @@ Insert[expr, object, List /@ Range[2, Length[expr]]]

CreateFindsNB[searchfield_, directory_] := 
Catch[
 NotebookPut[
  Notebook[
   {Cell[
    BoxData[
     ToBoxes[
      DynamicModule[{query, im, $display}, 
       query = StringJoin[searchURL, 
                          stringRiffle[Prepend[Drop[StringSplit[directory, $PathnameSeparator], 1], 
                                               Unevaluated[Sequence[searchfield, "filetype:nb"]]], "+"], 
                          If[$sort === "Relevance", " &flags=40", Unevaluated[Sequence[]]], 
                          If[$resultsnumber =!= 10, 
                             Unevaluated[Sequence["&num=", ToString[$resultsnumber]]], 
                             Unevaluated[Sequence[]]], 
                          "&format=xml"]; 
       im = Import[query , "XML"]; 
       $number = FileCountFound[im];
       If[$number === 0, Throw[MessageToConsole[OpenNotebookSearchDialog::noresults]]];
       $display = makeDirectoriesAndButtons[query, $viewnumber];
       Column[{OldRow[{Style[Dynamic[$number], Bold], 
                    " search results for ", 
                   Style["Union", Bold], " and "}, ColumnSpacings -> 0.0], 
               directory,
               "", 
               Column[{OldRow[{"Results displayed:", 
                            OldRow[{Dynamic[1 + If[$viewnumber > 1, ($viewnumber - 1) $resultsnumber, 0]], 
                                 "-", 
                                 Dynamic[Min[$resultsnumber $viewnumber, $number]]}, 
                                ColumnSpacings -> .2]}, 
                           ColumnSpacings -> .2]}, 
                      ColumnAlignments -> Center], 
               OldRow[{Button[Tooltip[Magnify["\[LeftArrow]", 2], "Display previous results.", ActionDelay -> .35], 
                           Dynamic[PreviousSet[$display, $viewnumber, query]]], 
                    Button[Tooltip[Magnify["\[RightArrow]", 2], "Display next results.", ActionDelay -> .35], 
                           Dynamic[NextSet[$display, $viewnumber, query]]], 
                    Button["close notebook", NotebookClose[EvaluationNotebook[]]; 
                                             $purpled = {}, 
                           Method -> "Queued"]}], 
               "", 
               Dynamic[Column[$display]]}]]]], 
         FontFamily -> "Helvetica", 
         FontSize -> 11, 
         CellMargins -> {{7, 3}, {4, 4}}]}, 
           ShowCellBracket -> False, 
           WindowFrameElements -> {"ZoomBox", "MinimizeBox", "ToolbarBox", "DocumentIcon", "ResizeArea"}]]]

PossibleDirectoriesInItem[x_] := StringSplit[x, "\n"]

Search[] := 
 Module[{gsearchdir, i, max, searchdirs, customdirs, recurse, files, styles, options},
 
     If[(* The Google Desktop Search tab has been clicked *)
      
        $preTab === 2,
        
        gsearchdir = 
         Which[$gall,
         
           If[StringTake[$FunctionDirectory, 1] === StringTake[$GuideDirectory, 1] && 
               StringTake[$GuideDirectory, 1] === StringTake[$TutorialDirectory, 1], 
               
              i = 1; 
              max = Min[StringLength /@ {$FunctionDirectory, $GuideDirectory, $TutorialDirectory}]; 
              While[StringTake[$FunctionDirectory, i] === StringTake[$GuideDirectory, i] && 
                     StringTake[$GuideDirectory, i] === StringTake[$TutorialDirectory, i] && i <= max, 
                    i++]; 
              StringTake[$GuideDirectory, i - 1], 
              ""],
              
           $gfunction, $FunctionDirectory,
           $gtutorial, $TutorialDirectory,
           $gguide, $GuideDirectory,
           $gexample, $ExampleDirectory,
           $gcustom, $gitem];
           
    If[gsearchdir =!= "" && FileType[gsearchdir] === Directory && Not@StringMatchQ[$SearchFieldValue, "" | " " ..],
       If[(* Display the search results in a browser. *)
          $results === "Browser",
          NotebookLocate[{URL[StringJoin[searchURL, 
                                      stringRiffle[Prepend[Drop[StringSplit[gsearchdir, $PathnameSeparator], 1], 
                                                           Unevaluated[Sequence[$SearchFieldValue, "filetype:nb"]]], "+"], 
                                      If[$sort === "Relevance", " &flags=40", Unevaluated[Sequence[]]], 
                                      If[$resultsnumber =!= 10, 
                                         Unevaluated[Sequence["&num=", ToString[$resultsnumber]]], 
                                         Unevaluated[Sequence[]]]]], None}],
           CreateFindsNB[$SearchFieldValue, gsearchdir]], 
           MessageToConsole[OpenNotebookSearchDialog::browerr]],
 
        searchdirs = 
          If[(* The All check box was not checked. *)
             Not@$all, 
             {If[FileType[$FunctionDirectory] === Directory && $function, $FunctionDirectory, Unevaluated[Sequence[]]], 
              If[FileType[$TutorialDirectory] === Directory && $tutorial, $TutorialDirectory, Unevaluated[Sequence[]]], 
              If[FileType[$GuideDirectory] === Directory && $guide, $GuideDirectory, Unevaluated[Sequence[]]], 
              If[FileType[$ExampleDirectory] === Directory && $example, $ExampleDirectory, Unevaluated[Sequence[]]], 
              If[$item =!= "" && (customdirs = Cases[PossibleDirectoriesInItem[$item], 
                                                     x_String /; FileType[x] === Directory]; 
                                  customdirs) =!= {} && $custom, 
                 Unevaluated[Sequence @@ customdirs], 
                 Unevaluated[Sequence[]]]}, 
             {If[FileType[$FunctionDirectory] === Directory, $FunctionDirectory, Unevaluated[Sequence[]]], 
              If[FileType[$TutorialDirectory] === Directory, $TutorialDirectory, Unevaluated[Sequence[]]], 
              If[FileType[$GuideDirectory] === Directory, $GuideDirectory, Unevaluated[Sequence[]]], 
              If[FileType[$ExampleDirectory] === Directory, $ExampleDirectory, Unevaluated[Sequence[]]], 
              If[$item =!= "" && (customdirs = Cases[PossibleDirectoriesInItem[$item], 
                                                     x_String /; FileType[x] === Directory]; 
                                  customdirs) =!= {}, 
                 Unevaluated[Sequence @@ customdirs], 
                 Unevaluated[Sequence[]]]}]; 
        recurse = If[$searchnested, Infinity, 1]; 
        files = If[searchdirs === {}, 
                   {}, 
                   Flatten[If[FileType[#] === Directory, FileNames["*.nb", {#}, recurse], #] & /@ searchdirs]]; 
        styles = If[$sall, 
                    {"Text", "ExampleText", "MathCaption", "Input", "Output", "Usage"}, 
                    {If[$text, "Text", Unevaluated[Sequence[]]], 
                     If[$exampletext, "ExampleText", Unevaluated[Sequence[]]], 
                     If[$mathcaption, "MathCaption", Unevaluated[Sequence[]]], 
                     If[$input, "Input", Unevaluated[Sequence[]]], 
                     If[$output, "Output", Unevaluated[Sequence[]]], 
                     If[$usage, "Usage", Unevaluated[Sequence[]]]}]; 
        options = {If[Not@$casesensitive, IgnoreCase -> True, Unevaluated[Sequence[]]], 
                   If[$matchentire, WordSearch -> True, Unevaluated[Sequence[]]], 
                   If[Not@$highlight, HighlightSearchStrings -> False, Unevaluated[Sequence[]]]}; 
        If[files =!= {} && styles =!= {} && Not@StringMatchQ[$SearchFieldValue, "" | " " ..], 
           NotebookSearch[files, 
                          StringSplit[$SearchFieldValue], 
                          "Expressions", 
                          SelectedCellStyles -> If[$sall, All, styles], 
                          MultiWordSearch -> If[$match === "Any word", Or, And], 
                          Sequence @@ options, 
                          Verbosity -> 5]]]]
                          
$sort = "Relevance";
$results = "Browser";
$resultsnumber = 10;

$number = 0;
$viewnumber = 1;

$purpled = {};
                          
$gitem = ""; 
$gbackground = .97;
$gall = False;
$gfunction = True;
$gtutorial = False;
$gguide = False;
$gexample = False;
$gcustom = False;

SetCustomDirectory[] := 
 Module[{root, ob}, 
        root = If[$OperatingSystem === "Windows",
                  StringSplit[$InstallationDirectory, $PathnameSeparator][[1]] <> $PathnameSeparator,
                  "/"];
        If[$selecteddirectory === "",
           ob = MathLink`CallFrontEnd[FrontEnd`DirectoryBrowse[root, "Select a directory."]],
           ob = MathLink`CallFrontEnd[FrontEnd`DirectoryBrowse[$selecteddirectory, "Select a directory."]]];
           If[ob =!= Null,
              If[StringQ[ob],
                 If[ob =!= $gitem, 
                    $selecteddirectory = ob;
                    $gitem = ob;
                    $gbackground = .95],
              MessageToConsole[SetCustomDirectory::browerr]]]]
              
ClearCustomDirectory[] := ($gitem = ""; $gbackground = .97)

$background=.97;

AddDirectoryToList::browerr = "No directory was properly selected.";

(* We set up $selecteddirectory this way in case this .m file ever becomes a .mx file. *)

$selecteddirectory = "";

$NotebookSearchDialog = None;

AddDirectoryToList[] := 
 Module[{root, ob, nb2}, 
        root = If[$OperatingSystem === "Windows",
                  StringSplit[$InstallationDirectory,$PathnameSeparator][[1]]<>$PathnameSeparator,
                  "/"];
        If[$selecteddirectory === "",
           ob = MathLink`CallFrontEnd[FrontEnd`DirectoryBrowse[root, "Select a directory."]],
           ob = MathLink`CallFrontEnd[FrontEnd`DirectoryBrowse[$selecteddirectory, "Select a directory."]]];
        If[ob =!= Null,
           If[StringQ[ob],
              If[Not@MemberQ[PossibleDirectoriesInItem[$item], ob], 
                 $selecteddirectory = ob;
                 If[$item === "", 
                    $item = ob, 
                    $item = $item<>"\n"<>ob];
                 $background = .95;
                 If[$all === False, $custom = True];
                 nb2 = NotebookPut[Notebook[{Cell[BoxData[
 RowBox[{"If", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"AbsoluteOptions", "[", 
      RowBox[{"$NotebookSearchDialog", ",", "WindowSize"}], "]"}], "[", 
     RowBox[{"[", 
      RowBox[{"1", ",", "2", ",", "2"}], "]"}], "]"}], ">", ToString[$height]}], ",", 
   RowBox[{
    RowBox[{"SetOptions", "[", 
     RowBox[{"$NotebookSearchDialog", ",", 
      RowBox[{"WindowSize", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"Fit", ",", ToString[$height]}], "}"}]}]}], "]"}], ";", "\n", 
    RowBox[{"$windowElements", "=", 
     RowBox[{"{", "\"\<VerticalScrollBar\>\"", "}"}]}], ";", "\n", 
    RowBox[{"SetOptions", "[", 
     RowBox[{"$NotebookSearchDialog", ",", 
      RowBox[{"ScrollingOptions", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"\"\<VerticalScrollRange\>\"", "\[Rule]", "Fit"}], "}"}]}]}], 
     "]"}]}]}], "]"}]], "Input"],
     Cell[BoxData[
 RowBox[{"NotebookClose", "[", 
  RowBox[{"EvaluationNotebook", "[", "]"}], "]"}]], "Input"]}, Visible -> False]]; 
  FrontEndExecute[{FrontEndToken[nb2, "SelectAll"], FrontEndToken[nb2, "SelectionEvaluate"]}]],
              MessageToConsole[AddDirectoryToList::browerr]]]]

ClearDirectoryList[] := ($item = ""; $background=.97; $windowElements = None)
                         
(* SelectionMove[ButtonNotebook[], Before, Notebook] at the end of the code for ClearDirectoryList
   was causing a problem. *)

SetDefaults[] := ($background=.97;
                  $selecteddirectory = "";
                  $SearchFieldValue = ""; 
                  $match = "Any word"; 
                  $item = ""; 
                  $all = False; 
                  $function = True; 
                  $tutorial = False; 
                  $guide = False; 
                  $example = False; 
                  $custom = False; 
                  $Tab = 1; 
                  $sall = True; 
                  $text = False; 
                  $exampletext = False; 
                  $mathcaption = False; 
                  $input = False; 
                  $output = False; 
                  $usage = False; 
                  $casesensitive = True; 
                  $matchentire = False; 
                  $highlight = True; 
                  $searchnested = True; 
                  $windowElements = None)

$SearchFieldValue = ""; 

$match = "Any word"; 

$item = "";

$all = False; 
$function = True; 
$tutorial = False; 
$guide = False; 
$example = False; 
$custom = False; 
$Tab = 1; 
$sall = True; 
$text = False; 
$exampletext = False; 
$mathcaption = False; 
$input = False;
$output = False; 
$usage = False; 
$casesensitive = True; 
$matchentire = False; 
$highlight = True;
$searchnested = True; 
$windowElements = None;
        
$state = "not running";

label[x_] := If[$state === "not running" || $preTab === 2, "Search", "Cancel"]

Searching[] := 
  Module[{ca, presetMessageOptionsValues, cs, newMessageOptionsValues},
      If[(* Google Desktop Search is being used. *)
      
         $preTab === 2,
    
         If[googleAvailable, Search[], MessageToConsole[OpenNotebookSearchDialog::noGoogle]],
         
         If[$state === "running",
         
            FrontEndExecute[FrontEnd`FrontEndToken["EvaluatorAbort"]];
            If[(ca = Cases[Notebooks[], 
               x_ /; (WindowFloating /. Options[x, WindowFloating]) && 
                ((WindowTitle /. Options[x, WindowTitle]) === None) &&
                 (Cases[NotebookGet[x], 
                        BoxData[DynamicBox[AuthorTools`Common`Private`$ProgressSubcaption]], 
                        Infinity] =!= {})]; ca) =!= {}, NotebookClose[ca[[1]]]],
            
            CheckAbort[$state = "running";
                  
                       (* Get current MessageOptions to restore after message is sent to console. *)
                             
               presetMessageOptionsValues = MessageOptions /. Options[$FrontEnd, MessageOptions];
                 
               (* New MessageOptions has "KernelMessageAction" with "PrintToConsole". *)
                 
               newMessageOptionsValues = 
             If[(cs = Cases[presetMessageOptionsValues, a : ("KernelMessageAction" -> _)]; cs) === {}, 
                Append[presetMessageOptionsValues, "KernelMessageAction" -> {"Beep", "PrintToNotebook"}], 
                        presetMessageOptionsValues /. ("KernelMessageAction" -> a_) :> ("KernelMessageAction" -> 
                                                Append[DeleteCases[a, "PrintToNotebook"], "PrintToConsole"])];
                       SetOptions[$FrontEnd, MessageOptions -> newMessageOptionsValues];
                             
                       If[$matchentire, SetOptions[{Find, FindList}, WordSeparators -> {" ", "\t", "\""}]];
                       Search[]; 
                       If[$matchentire, SetOptions[{Find, FindList}, WordSeparators -> {" ", "\t"}]];
                             
                       (* Restore previous MessageOptions. *)
                             
                       SetOptions[$FrontEnd, MessageOptions -> presetMessageOptionsValues];
                             
                       $state = "not running",
                       
                       If[ValueQ[presetMessageOptionsValues], 
                          SetOptions[$FrontEnd, MessageOptions -> presetMessageOptionsValues]];
                       If[$matchentire, SetOptions[{Find, FindList}, WordSeparators -> {" ", "\t"}]];
                       $state = "not running"]]]]
                       
gridForm[rowlist1_, rowlist2_] := 
 Grid[OldRow[#, ColumnSpacings -> .5, RowAlignments -> Center] & /@ 
      Partition[#, 2] & /@ {rowlist1, rowlist2}, ColumnAlignments -> Left]

$preTab = 1;
$size = {392, 85};

(* For launching Copernic Desktop Search without the DOS window. Must use until Run is improved. *)
  
StartCopernicSearch[copernicexecutablepath_] := 
   Module[{p}, 
          If[copernicAvailable,
             p = NETLink`NETNew["System.Diagnostics.Process"]; 
             p@NETLink`StartInfo@FileName = copernicexecutablepath; 
             p@NETLink`Start[],
             MessageToConsole[OpenNotebookSearchDialog::noCopernic]]]

LoadingMessage[] := Notebook[{Cell["NETLink is being loaded...", 
                                      CellMargins -> {{0, 0}, {12, 20}}, TextAlignment -> Center, 
                                      FontFamily -> "Helvetica", FontSize -> 14]}, 
                                Saveable -> False, 
                                WindowSize -> {300, 60}, 
                                WindowMargins -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
                                WindowFrame -> "ThinFrame", WindowElements -> {}, 
                                WindowFrameElements -> {"CloseBox"}, WindowTitle -> None, 
                                ShowCellBracket -> False, Background -> GrayLevel[1]]
             
                                
(* If $netlink is False opening the search dialog will load NETLink if the OS is Windows and the .NET framework
   is present. After the dialog is initially opened $netlink is set to True. *)

$netlink = False;

searchURL = "";
copernicAvailable = True;
googleAvailable = True;

OpenNotebookSearchDialog[] :=

Module[{searchFile, mathexecutable, gacSystemDir, gac2SystemDir, verStrings, verNumbers, stream, im, copernicexecutable, ln,
        copexec, nb2},
        
DetermineHeight[] := (nb2 = NotebookPut[
  Notebook[{Cell[BoxData[RowBox[{"$height", "=", RowBox[{RowBox[{"AbsoluteOptions", "[", 
            RowBox[{"$NotebookSearchDialog", ",", "WindowSize"}], "]"}], "[", 
          RowBox[{"[", RowBox[{"1", ",", "2", ",", "2"}], "]"}], "]"}]}]], "Input"],      
    Cell[BoxData[RowBox[{"NotebookClose", "[", RowBox[{"EvaluationNotebook", "[", "]"}], "]"}]], "Input"]}, 
   Visible -> False]]; FrontEndExecute[{FrontEndToken[nb2, "SelectAll"], FrontEndToken[nb2, "SelectionEvaluate"]}]);

If[MemberQ[Notebooks[], $NotebookSearchDialog],

SetSelectedNotebook[$NotebookSearchDialog],

Catch[
 searchFile = ToFileName[$PreferencesDirectory, "GoogleSearchString.m"];
 mathexecutable = ToFileName[{$InstallationDirectory}, "mathematica.exe"];
 If[$netlink === False, 
    If[Not@StringQ[Environment["WINDIR"]], Throw[MessageToConsole[OpenNotebookSearchDialog::notWindows];
                                      Abort[]]];
    gacSystemDir = ToFileName[{Environment["WINDIR"], "assembly", "gac", "system"}];
    gac2SystemDir = ToFileName[{Environment["WINDIR"], "assembly", "gac_msil", "system"}];
    If[FileType[gacSystemDir] =!= Directory && FileType[gac2SystemDir] =!= Directory, 
                            Throw[MessageToConsole[OpenNotebookSearchDialog::noNET];
                                                    Abort[]]];
    verStrings = Join[StringTake[#, {StringLength[gacSystemDir] + 1, StringLength[gacSystemDir] + 5}] & /@ 
                        Select[FileNames["*", gacSystemDir], StringMatchQ[#, "*.*.*"] &], 
                      StringTake[#, {StringLength[gac2SystemDir] + 1, StringLength[gac2SystemDir] + 5}] & /@ 
                        Select[FileNames["*", gac2SystemDir], StringMatchQ[#, "*.*.*"] &]];
    (* verStrings looks like {"1.0.3", "1.0.5", "2.0.0"} *)
    If[Length[verStrings] == 0, 
       Throw[MessageToConsole[OpenNotebookSearchDialog::noNET];
             Abort[]]];
    verNumbers = ToExpression /@ Select[StringReplace[#, "." -> ""] & /@ verStrings, DigitQ];
    If[Max[verNumbers] < 105, 
       Throw[MessageToConsole[OpenNotebookSearchDialog::updateNET]]];
             
    (* The following which covers the situation where neither Google nor Copernic are available so no need to load
       NETLink so the message get thrown to the Catch. If just one is available the message gets generated and NETLink
       is needed. *)
             
    Which[If[FrontEndExecute[FrontEnd`Value[FEPrivate`NotebookIndexerState["Google"]]] =!= 4, 
             googleAvailable = False; True, False] &&
          If[FrontEndExecute[FrontEnd`Value[FEPrivate`NotebookIndexerState["Copernic"]]] =!= 4,
             copernicAvailable = False; True, False],
          Throw[Abort[]],
          
          FrontEndExecute[FrontEnd`Value[FEPrivate`NotebookIndexerState["Google"]]] =!= 4, 
          googleAvailable = False;
          $size = {392, 85};
          $preTab = 1,
          
          FrontEndExecute[FrontEnd`Value[FEPrivate`NotebookIndexerState["Copernic"]]] =!= 4, 
          copernicAvailable = False; 
          $size = {392, If[$gcustom, 305, 240]};
          $preTab = 2];
             
    If[FileType[searchFile] =!= File || (FileType[searchFile] === File && (ln = Length[StringSplit[Import[searchFile, "Text"], "\n"]]) =!= 3),          
             
       If[FileType[searchFile] === File && ln =!= 3, DeleteFile[searchFile]];
       
       $nb = NotebookPut[LoadingMessage[]];
       Needs["NETLink`"];
       NETLink`InstallNET[]; 
       NETLink`LoadNETType["Microsoft.Win32.Registry"]; 
       NETLink`LoadNETType["Microsoft.Win32.RegistryKey"]; 
 Microsoft`Win32`Registry`LocalMachine@CreateSubKey["Software\\Wolfram Research\\Mathematica"]@SetValue["DefaultLauncher", 
    ToFileName[{$InstallationDirectory}, "mathematica.exe"]];
    
       (* For launching Copernic Desktop Search without the DOS window. *)
       NETLink`LoadNETType["System.Diagnostics.Process"];
    
   (* The search string needed by Google Desktop Search: *)
   
       searchURL = If[googleAvailable,
                      Microsoft`Win32`Registry`CurrentUser@OpenSubKey["Software\\Google\\Google Desktop\\API"]@GetValue["search_url"],
                      ""];
       Pause[1];
       NotebookClose[$nb];
       
       copernicexecutable = If[copernicAvailable,
                               Microsoft`Win32`Registry`LocalMachine@OpenSubKey["SOFTWARE\\Copernic\\DesktopSearch"]@GetValue["RootFolder"] <> "CopernicDesktopSearch.exe",
                               ""];
       
       stream = OpenWrite[searchFile, PageWidth -> Infinity];
       Scan[WriteString[stream, #, "\n"] &, {searchURL, mathexecutable, copernicexecutable}]; 
       Close[stream],
       
       im = Import[searchFile, "Text"];
       If[googleAvailable,
          searchURL = StringSplit[im, "\n"][[1]]];
       If[copernicAvailable, 
          copernicexecutable = StringSplit[im, "\n"][[-1]];
          If[$netlink === False,
             $nb = NotebookPut[LoadingMessage[]];
             Needs["NETLink`"];
             NETLink`InstallNET[];
             Pause[1];
             NotebookClose[$nb];
             $netlink = True];
             NETLink`LoadNETType["System.Diagnostics.Process"]]];
   
   $netlink = True,
   
   im = Import[searchFile, "Text"];
   If[googleAvailable,
      searchURL = StringSplit[im, "\n"][[1]]];
   If[copernicAvailable, 
      copernicexecutable = StringSplit[im, "\n"][[-1]];
      If[$netlink === False,
         $nb = NotebookPut[LoadingMessage[]];
         Needs["NETLink`"];
         NETLink`InstallNET[];
         Pause[1];
         NotebookClose[$nb];
         $netlink = True];
      NETLink`LoadNETType["System.Diagnostics.Process"]]]];
  
   
Clear[$NotebookSearchDialog];
$NotebookSearchDialog = NotebookPut[
   Notebook[{Cell[
      BoxData[ToBoxes[
        DynamicModule[{u}, 
          Style[TabView[ 
   {Style["Copernic Search", Bold] -> 
     Column[{"Click the button to perform searches using Copernic Desktop Search.", 
             OldRow[{Button["Run", StartCopernicSearch[copexec]] /. copexec -> copernicexecutable, "  "}]},
            ColumnAlignments -> Center],
    Style["Google Search", Bold] -> 
     Column[{OldRow[{Dynamic[Button[Dynamic[label[$state]], Dynamic[Searching[]], 
                                            Method -> Dynamic[If[$state === "running" && $preTab === 3, 
                                                                 "Preemptive",
                                                                 "Queued"]]]], 
                             InputField[Dynamic[$SearchFieldValue], String, FieldSize -> {38, {1, Infinity}}]}],
             Column[{Column[{OldRow[{Style["       Sort by:", Bold], 
             OldRow[OldRow[#, ColumnSpacings -> .1, RowAlignments -> Center] & /@ 
                 Partition[Flatten[Transpose[{RadioButton[Dynamic[$sort], #] & /@ {"Relevance", "Date"}, 
                                              {"Relevance", "Date"}}]], 2]]}], 
                             OldRow[{Style["  Results in:", Bold], 
             OldRow[OldRow[#, ColumnSpacings -> .1, RowAlignments -> Center] & /@ 
                 Partition[Flatten[Transpose[{RadioButton[Dynamic[$results], #] & /@ {"Browser", "Notebook"}, 
                                              {"Browser", "Notebook"}}]], 2], 
                 ColumnSpacings -> 1.8]}]}], 
                             OldRow[{Style["        Display:", Bold], 
             OldRow[OldRow[#, ColumnSpacings -> .1, RowAlignments -> Center] & /@ 
                 Partition[Flatten[Transpose[{RadioButton[Dynamic[$resultsnumber], #] & /@ {10, 20, 40, 100}, 
                                              {10, 20, 40, 100}}]], 2], 
                 ColumnSpacings -> 1.8]}]}], 
             OldRow[{Column[{Style["           Paths: ", Bold], "          "}, RowSpacings -> 2.1, RowAlignments -> Center], 
             gridForm[{Checkbox[Dynamic[$gall, 
                                        (u = #;
                                         If[$gall, 
                                            $gall = False, 
                                            $gfunction = False; $gtutorial = False; $gguide = False;
                                            $gexample = False; $gcustom = False; $gall = True]) &]], 
                       "All Docs", 
                       Checkbox[Dynamic[$gfunction, 
                                        (u = #;
                                         If[$gfunction, 
                                            $gfunction = False, 
                                            $gfunction = True; $gall = False; $gexample = False; $gcustom = False]) &]], 
                       "Function", 
                       Checkbox[Dynamic[$gtutorial, 
                                        (u = #;
                                         If[$gtutorial, 
                                            $gtutorial = False, 
                                            $gtutorial = True; $gall = False; $gexample = False; $gcustom = False]) &]], 
                       "Tutorial"}, 
                      {Checkbox[Dynamic[$gguide, 
                                        (u = #;
                                         If[$gguide, 
                                            $gguide = False, 
                                            $gguide = True; $gall = False; $gexample = False; $gcustom = False]) &]], 
                       "Guide", 
                       Checkbox[Dynamic[$gexample, 
                                        (u = #;
                                         If[$gexample, 
                                            $gexample = False, 
                                            $gexample = True; $gall = False; $gfunction = False; $gtutorial = False;
                                            $gguide = False; $gcustom = False]) &]], 
                       "Example", 
                       Checkbox[Dynamic[$gcustom, 
                                        (u = #;
                                         If[$gcustom,
                                            $gcustom = False;
                                            $size = {392, 240};
                                            SetOptions[EvaluationNotebook[], WindowSize -> Fit], 
                                            $gcustom = True; $gall = False; $gfunction = False; $gtutorial = False;
                                            $gguide = False; $gexample = False;
                                            $size = {392, 305};
                                            SetOptions[EvaluationNotebook[], WindowSize -> Fit]]) &]], 
                       "Custom"}]}, 
                 ColumnSpacings -> .5], 
             Dynamic[If[$gcustom, 
                        Column[{OldRow[{Button["Set Custom Path", SetCustomDirectory[], Method -> "Queued"], 
                                     Button["Clear", ClearCustomDirectory[], Method -> "Queued"]}, 
                                    ColumnSpacings -> .3], 
                                TextCell[$gitem, ParagraphSpacing -> {0, 4}, ParagraphIndent -> -20, 
                                           FontFamily -> "Helvetica", CellSize -> {350, 50}, 
                                           Background -> GrayLevel[$gbackground]]}], 
                        TextCell["", CellSize -> {350, 1}, Background -> GrayLevel[.95]]]]}, 
            RowSpacings -> 2]},
          Dynamic[$preTab, 
              ($preTab = #;
               SetOptions[EvaluationNotebook[], WindowSize -> Fit, 
                                                ScrollingOptions -> {"VerticalScrollRange" -> Fit}]) &],
   ImageSize -> Automatic], 
                FontFamily -> "Helvetica", 11]]]]]}, 
            WindowSize -> Fit, 
            WindowMargins -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
            WindowFrame -> "Palette", 
            WindowFrameElements -> {"CloseBox"}, 
            WindowElements -> Dynamic[$windowElements], 
            ShowCellBracket -> False, 
            ClosingAutoSave -> False, 
            WindowTitle -> "Notebook Search", 
            Saveable -> False]]]]
            
*)

(* End of code for NotebookSearch dialog.  *)



(*
  Utility to (temporarily) reset parts of the style definitions (e.g.,
  Editable or Deletable).  Returns the original StyleDef setting.
*)
SetStyleDef[nb_NotebookObject, option_Rule, styles__String] := 
  Module[
    {oldStyleDef}, 
    oldStyleDef =
      StyleDefinitions /. Options[nb] /. StyleDefinitions -> None;
    SetOptions[nb, 
      StyleDefinitions -> 
        Notebook[{
          Cell[StyleData[StyleDefinitions -> oldStyleDef]], 
          Sequence @@ (Cell[StyleData[#], option] & /@ {styles})
        }]
    ];
    oldStyleDef
  ];

(*
  Restores original style defs (cf SetStyleDef).
*)
RestoreStyleDef[nb_NotebookObject, oldStyleDef_] := 
  SetOptions[nb, StyleDefinitions -> oldStyleDef];


(*
  Utility to scan for and select a non-String between delimiters.
*)
SelectWithinDelimiters[
  nb_NotebookObject, 
  delim_String /; StringLength[delim] == 1
] :=
  Module[
    {
      $dir = {"Next", "Previous"},
      $rev =
        Switch[#,
          "Next", "Previous",
          "Previous", "Next"
        ]&,
      data = "",
      info
    },
    (* If not within a cell, bail. *)
    If[CellInfo[nb] === $Failed,
      Return[$Failed]
    ];
    (* Collapse any selections before starting. *)
    FrontEndExecute[{
      FrontEnd`FrontEndToken[nb, "MovePrevious"]
    }];
    (* Scan for non-Strings, "bouncing" off delimiters and beginning- and
     end-of-lines. *)
    While[MatchQ[data, _String] && Length[$dir] > 0,
      FrontEndExecute[{
        FrontEnd`FrontEndToken[nb, "Move" <> $dir[[1]]]
      }];
      info = CellInfo[nb];
      If[info === $Failed,
        $dir = Drop[$dir, 1];
        Continue[]
      ];
      If[!FreeQ[info, "InlineCellPosition"],
        Break[]
      ];
      FrontEndExecute[{
        FrontEnd`FrontEndToken[nb, "Move" <> $dir[[1]]]
      }];
      info = CellInfo[nb];
      If[info === $Failed,
        $dir = Drop[$dir, 1];
        Continue[]
      ];
      If[!FreeQ[info, "InlineCellPosition"],
        Break[]
      ];
      FrontEndExecute[{
        FrontEnd`FrontEndToken[nb, "Select" <> $rev[$dir[[1]]]]
      }];
      data = OldNotebookRead[nb];
      If[data == delim,
        $dir = Drop[$dir, 1];
        Continue[]
      ];
    ];
    (* Check for failed search. *)
    If[Length[$dir] == 0, $Failed, Null]
  ];


(*
  Utility to test if cursor is within an inline cell.
*)
InlineCellQ[] := InlineCellQ[InputNotebook[]];

InlineCellQ[nb_NotebookObject] :=
  (
    "InlineCellPosition" /. (
      Module[
        {ci},
        ci = CellInfo[nb];
        If[ci === $Failed, {}, First[ci]]
      ]
    ) /. "InlineCellPosition" -> None
  ) =!= None;


(* Old version with issues in M- 8:
Options[TableSpanToggle] =
  {
    "Notebook" -> Automatic,
      (* Document notebook (default: InputNotebook[]). *)
    "StrictSelection" -> False
      (* Attempt to correct for partial selections. *)
  };

(*FIXME:
  Workaround for a crash [cf my e-mail, 2006 Jan 11].
*)
KludgeTableSpanCrash[nb_NotebookObject] :=
  RestoreStyleDef[nb,
    SetStyleDef[nb, Deletable -> True, "ModInfo", "TableText"]
  ];

TableSpanToggle[options___?OptionQ] :=
  Module[
    {
      optNotebook, optStrictSelection,
      nb, data, nrows, olddata, rows, oldStyleDef
    },
    {optNotebook, optStrictSelection} =
      {"Notebook", "StrictSelection"}
        /. {options} /. Options[TableSpanToggle];
    nb =
      If[optNotebook === Automatic,
        InputNotebook[],
        optNotebook
      ];
    KludgeTableSpanCrash[nb];
    (* Read selection and process into a list of cells. *)
    data = OldNotebookRead[nb];
    (* Check that the selection is a subset of a GridBox selection. *)
    If[!MatchQ[data, BoxData[GridBox[_]]],
      MessageToConsole[TableSpanToggle::nosel];
      Return[$Failed]
    ];
    If[!optStrictSelection,
      (*
        In case the ModInfo cell (often invisible) wasn't selected, expand
        the selection leftward until:
          - we find the ModInfo cell
          - we extend into the next row above
          - or we hit a rut
        Note this selection autocorrection works only if the first column
        is a ModInfo cell (unless we happen to be in the first row).
      *)
      nrows = Length[data /. BoxData[GridBox[c_]] :> c];
      olddata = None;
      While[
        FreeQ[data, Cell[_, "ModInfo"]]
          && Length[data /. BoxData[GridBox[c_]] :> c] == nrows
          && data =!= olddata
        ,
        FrontEndExecute[{
          FrontEnd`FrontEndToken[nb, "SelectPrevious"]
        }];
        olddata = data;
        data = OldNotebookRead[nb];
      ];
    ];
    (* Strip off the headers. *)
    rows = data[[1, 1]];
    (* Test here for number of cells selected. *)
    Switch[Length[rows],
      1, (* 1 row selected *)
        (*
          Span ON.
        *)
        rows = rows
          /. {
            {{m: Cell[_, "ModInfo"], a_, b___}}
              :> {{m, a, Sequence @@ Table["\[SpanFromLeft]", {Length[{b}]}]},
                  {"", "", b}},
            {{a_, b___}}
              :> {{a, Sequence @@ Table["\[SpanFromLeft]", {Length[{b}]}]},
                  {"", b}}
          };
        oldStyleDef =
          SetStyleDef[nb, Deletable -> True, "ModInfo", "TableText"];
        (* A hack:  Mathematica won't permit replacing one row directly
          w/two, so need to overwrite the original row with the first new
          one, open a new blank row, then select and overwrite that with
          the second new one. *)
        NotebookWrite[nb, BoxData[GridBox[{rows[[1]]}]]];
        FrontEndExecute[{
          FrontEnd`FrontEndToken[nb, "MoveNext"],
          FrontEnd`FrontEndToken[nb, "NewRow"],
          Sequence @@
            Table[
              FrontEnd`FrontEndToken[nb, "SelectNext"],
              {Length[rows[[2]]] - 1}
            ]
        }];
        NotebookWrite[nb, BoxData[GridBox[If[$VersionNumber > 7., rows, {rows[[2]]}]]], All];
        RestoreStyleDef[nb, oldStyleDef];
        (* Selection hack, required due to the writing hack above. *)
        If[$VersionNumber < 8., FrontEndExecute[{
          FrontEnd`FrontEndToken[nb, "SelectPreviousLine"]
        }]];
      ,
      2, (* 2 rows selected *)
        (*
          Span OFF.
        *)
        If[!MatchQ[rows,
              {{Cell[_, "ModInfo"], _, "\[SpanFromLeft]", ___}, {_, "", __}}
                | {{_, "\[SpanFromLeft]", ___}, {"", __}}
            ],
          MessageToConsole[TableSpanToggle::nospan];
          Return[$Failed]
        ];
        rows = rows
          /. {
            {{m: Cell[_, "ModInfo"], a_, "\[SpanFromLeft]"..},
              {_, "", b___}}
                :> {{m, a, b}},
            {{a_, "\[SpanFromLeft]"..},
              {"", b___}}
                :> {{a, b}}
          };
        oldStyleDef = 
          SetStyleDef[nb, Deletable -> True, "ModInfo", "TableText"];
        NotebookWrite[nb, BoxData[GridBox[rows]], All];
        RestoreStyleDef[nb, oldStyleDef];
      ,
      _, (* >2 rows selected *)
        MessageToConsole[TableSpanToggle::oversel];
        Return[$Failed]
    ]
  ];
*)

TableSpanToggle::noin = "There is no open input notebook.";
TableSpanToggle::betwcells = "The cursor is between cells or not inside an input notebook.";
TableSpanToggle::mulcell = "Multiple cells have been selected.";
TableSpanToggle::nottable = "The cursor is not in a table cell.";
TableSpanToggle::onecol = "One column tables cannot be spanned.";
TableSpanToggle::sel = "Select a single or spanned row in a table.";
TableSpanToggle::unspanonerow = "To unspan, the row containing spanning elements and the subsequent row must be selected.";
TableSpanToggle::ent = "Select an entire row or entire spanned row in a table.";

FirstStyleOfCell[ci : {{___, "Style" -> _, ___}}] := 
 Which[MatchQ[#, {{__String}}], #[[1, 1]], MatchQ[#, {_String}], #[[1]], True, {}] &[("Style" /. ci)]

TableSpanToggle[___] :=
  Module[{nb = InputNotebook[], ci, cellstyle, re, selectionlength, rowlength, re2, repart, pos, grid},
  
   Catch[If[(*There is no input notebook.*)nb === $Failed, Throw[MessageToConsole[TableSpanToggle::noin]]];
   
         ci = CellInfo[nb];
         
         If[(* The cursor is between cells. *)ci === $Failed, Throw[MessageToConsole[TableSpanToggle::betwcells]]];
         
         If[multipleCellBracketsSelected[ci], Throw[MessageToConsole[TableSpanToggle::mulcell]]];
         
         cellstyle = FirstStyleOfCell[ci];
         
         If[(* The cursor is not in a table cell. *)Not[StringMatchQ[cellstyle, Alternatives @@ $AcceptableTableStyles]], 
            Throw[MessageToConsole[TableSpanToggle::nottable]]];
            
         If[cellstyle === "1ColumnTableMod", Throw[MessageToConsole[TableSpanToggle::onecol]]];
         
         re = NotebookRead[nb];
         
         If[Not[MatchQ[re, GridBox[{{_, __}}, ___] | GridBox[{{__, "\[SpanFromLeft]"}, {__}}, ___]]], 
            Throw[MessageToConsole[TableSpanToggle::sel]]];
            
         If[MatchQ[re[[1]], {{___, "\[SpanFromLeft]" | "", ___}}], Throw[MessageToConsole[TableSpanToggle::unspanonerow]]];
            
         selectionlength = Length@DeleteCases[re[[1, 1]], TooltipBox[__] | Cell[_, "ModInfo"]];
         
         rowlength = Switch[cellstyle, "2ColumnTableMod", 2, "3ColumnTableMod", 3, "DefinitionBox", 2];
         
         oldStyleDef = SetStyleDef[nb, Deletable -> True, "ModInfo", "TableText"];
         
         If[selectionlength < rowlength, Throw[MessageToConsole[TableSpanToggle::ent]]];
         
         NotebookWrite[nb, "\[Placeholder]"];
         
         ExpandToCell[nb];
         re2 = OldNotebookRead[nb];
         
         repart = Replace[re2[[1, 1, 1]],
                          {a___, b : {___, "\[Placeholder]", "\[Placeholder]", ___}, {___, "\[Placeholder]", "\[Placeholder]", ___}, c___} :> {a, b, c}];
                          
         pos = Position[repart, {___, "\[Placeholder]", "\[Placeholder]", ___}][[1, 1]];
         
         (* This creates the main component of the new table. *)
    
         grid = ((repart /. a : {___, "\[Placeholder]", "\[Placeholder]", ___} :> 
          If[(* A spanned row was selected. *)
             MatchQ[re, GridBox[{{__, "\[SpanFromLeft]"}, {__}}, ___]], 
             If[Not[MatchQ[#, {TooltipBox[__] | Cell[_, "ModInfo"], __}]], 
                Prepend[#, repart[[pos, 1]]], #] &@Join[DeleteCases[re[[1, 1]], "\[SpanFromLeft]"], 
                DeleteCases[re[[1, 2]], ""]], 
             Unevaluated[Sequence[Join[If[MatchQ[re[[1, 1, 1]], TooltipBox[__] | Cell[_, "ModInfo"]], {}, {repart[[pos, 1]]}], 
                                       Take[re[[1, 1]], 
                                            If[MatchQ[re[[1, 1, 1]], TooltipBox[__] | Cell[_, "ModInfo"]], 2, 1]], 
                                       If[rowlength === 2, {"\[SpanFromLeft]"}, {"\[SpanFromLeft]", "\[SpanFromLeft]"}]], 
                                  Join[If[rowlength === 2, {""}, {"", ""}],
                                       Take[re[[1, 1]], {If[MatchQ[re[[1, 1, 1]], TooltipBox[__] | Cell[_, "ModInfo"]], 3, 2], -1}]]]]]) /.
                                                                                                          {{"", a_} :> {Cell["      ", "ModInfo"], "", a},
                                                    {Cell["      ", "ModInfo"], a_, Cell["      ", "ModInfo"], b_} :> {Cell["      ", "ModInfo"], a, b}});
         RestoreStyleDef[nb, oldStyleDef];
         NotebookWrite[nb, ReplacePart[re2, {1, 1, 1} -> DeleteCases[grid, "\[Placeholder]", 2]], All]]]
         

$ButtonContent = "";
$ButtonData = "";
$ButtonStyle = "Link";


ButtonEdit::nosel = "The initial selection was not immediately following a button.";


Options[ButtonEdit] =
  {
    "Notebook" -> Automatic
      (* Document notebook (default: InputNotebook[]). *)
  };

ButtonEdit[options___?OptionQ] :=
  Module[
    { selInfo, optNotebook, nb, data, content, bdata, bstyle, dialogNB, dataType },
    
    {optNotebook} =
      {"Notebook"}
        /. {options} /. Options[ButtonEdit];
    nb =
      If[optNotebook === Automatic,
        InputNotebook[],
        optNotebook
      ];

    selInfo = CellInfo[ nb];
    If[ selInfo === $Failed || nb === $Failed,
      MessageToConsole[ ButtonEdit::nosel];
      Abort[] ];

    dataType = "TextData"; (* Initialize this just to be safe *)
    
    (* Select and read the old button. *)
    If[ ("ContentData" /. CellInfo[ nb]) === {BoxData},
     (FrontEndExecute[ FrontEnd`FrontEndToken[ nb, "SelectPreviousWord"]];
      dataType = "BoxData"),
     (While[ InlineCellQ[ nb],  (* If inside an inline cell, step outside of it *)
        FrontEndExecute[ FrontEnd`FrontEndToken[ nb, "MoveNext"]]];
      FrontEndExecute[ FrontEnd`FrontEndToken[ nb, "SelectPreviousWord"]]; 
      data = NotebookRead[ nb];
      If[ MatchQ[ data, BoxData[ ButtonBox[_, ___]]], 
       (FrontEndExecute[{ FrontEnd`FrontEndToken[ nb, "MoveNext"], 
          FrontEnd`FrontEndToken[ nb, "MovePrevious"], 
          FrontEnd`FrontEndToken[ nb, "SelectPreviousWord"]}];
        dataType = "BoxData"), 
       (While[ MatchQ[ data, StyleBox[ButtonBox[_, ___], __] | ButtonBox[_, ___] | {ButtonBox[_, ___], __} | {StyleBox[ButtonBox[_, ___], __], __}] 
               && (First @ Flatten[ "CursorPosition" /. CellInfo[ nb]] =!= 0), 
          FrontEndExecute[ FrontEnd`FrontEndToken[ nb, "SelectPreviousWord"]];
          data = NotebookRead[ nb]];
        If[ First @ Flatten[ "CursorPosition" /. CellInfo[nb]] =!= 0,
          FrontEndExecute[ FrontEnd`FrontEndToken[ nb, "SelectNextWord"]]];
        dataType = "TextData")]
      )];
    data = NotebookRead[ nb];

    (* Check that the content does indeed contain Button expression(s). *)

    If[ !MatchQ[ data, StyleBox[ButtonBox[_, ___], __] | ButtonBox[_, ___] | {ButtonBox[_, ___], __} | {StyleBox[ButtonBox[_, ___], __], __}],
      MessageToConsole[ ButtonEdit::nosel];
      If[ dataType == "BoxData",
        FrontEndExecute[ FrontEnd`FrontEndToken[ nb, "MoveNext"]] ];
      Return[ $Failed]
    ];
    
    (* Extract the old button content and data. *)

    If[ dataType === "BoxData",
      content = (data /. ButtonBox[c_, ___] :> c),
      content = TextData[ Flatten[{ data /. ButtonBox[c_, ___] :> c }]] ];
    
    bdata = First @ Flatten[{ data /. StyleBox[ButtonBox[___, _[ButtonData, a_], ___], __] :> a /. ButtonBox[___, _[ButtonData, b_], ___] :> b /. _ButtonBox -> ""}];
    bstyle = First @ Flatten[ Cases[ data, (BaseStyle -> sty_) :> sty, Infinity] ];
    
    $ButtonContent = content;
    $ButtonStyle = bstyle;
    $ButtonData = 
      Which[ 
        MatchQ[ bdata, URL[_]], 
          bdata[[1]],
        MatchQ[ bdata, FrontEnd`FileName[{_String}]], (* Malformed buttons *)
          bdata /. FrontEnd`FileName[{str_}] -> str,
        MatchQ[ bdata, FrontEnd`FileName[_]],
          ToFileName @ bdata,
        True, 
          bdata];
    
    DocumentationTools`Test1 = $ButtonContent;
    DocumentationTools`Test2 = $ButtonStyle;
    DocumentationTools`Test3 = $ButtonData;
    
    dialogNB = NotebookPut @ ButtonEditDialog[ nb, dataType];

    SelectionMove[ dialogNB, Before, Notebook];
    NotebookFind[ dialogNB, "ContentField", CellTags];
    SelectionMove[ dialogNB, All, CellContents];
    SetSelectedNotebook[ dialogNB]
  ];


(* InputField does not allow styled text, so punt on this approach for now, as it is a particular issue for the content field:

ButtonEditDialog[ nb_NotebookObject, dataType_:"TextData"] :=
  Notebook[{
    Cell[ BoxData[
      InputFieldBox[ 
        Dynamic[ DocumentationTools`Private`$ButtonContent], 
          FieldSize -> {40, 1.2}, ContinuousAction->True]], "Text",
      CellFrameLabels -> {{Cell["Content:", FontSize->10, TextAlignment->Right, CellSize->{48,14}], None}, {None, None}},
      CellMargins->{{16,10},{6,18}}, 
      FontFamily -> "Verdana", 
      ShowStringCharacters -> False,
      CellTags -> {"ContentField", "Field"}], 
    Cell[ BoxData[
      InputFieldBox[ 
        Dynamic[ DocumentationTools`Private`$ButtonData], 
          FieldSize -> {40, 1.2}, ContinuousAction->True]], "Text",
      CellFrameLabels -> {{Cell["Data:", FontFamily -> "Verdana", FontSize->10, TextAlignment->Right, CellSize->{48,14}], None}, {None, None}}, 
      CellMargins -> {{16, 10}, {6, 6}},
      FontFamily -> "Verdana", 
      AutoItalicWords -> {},
      ShowStringCharacters -> False,
      CellTags -> {"DataField", "Field"}], 
   Cell[BoxData[
      RowBox[{ ButtonBox["Change", ButtonFunction :> ButtonEditChangeAction[ nb, dataType], Method -> "Queued", ButtonFrame->"DialogBox"], 
               " ",
               ButtonBox["Cancel", ButtonFunction :> ButtonEditCancelAction[ nb, dataType], Method -> "Queued", ButtonFrame->"DialogBox"]}]], 
      "Text", 
      FontFamily -> "Verdana", 
      ShowStringCharacters -> False, 
      CellMargins->{{62,10},{6,20}}]},  
   WindowTitle -> "Change Button Contents and/or Data", 
   WindowSize -> {500, 180}, 
   WindowFrame -> "Palette", 
   WindowFrameElements -> {}, 
   WindowElements -> {}, 
   FontFamily -> "Verdana", 
   ButtonBoxOptions->{Active->True, Evaluator->Automatic},
   ShowCellBracket -> False, 
   ClosingAutoSave -> False, 
   Saveable -> False,
   NotebookEventActions -> {"ReturnKeyDown" :> CompoundExpression[
                                                 ButtonEditChangeAction[ nb, dataType],
                                                 NotebookClose[ EvaluationNotebook[]]],
                            "TabKeyDown" :> CompoundExpression[
                                              SetOptions[ $FrontEnd, FindSettings -> {"Wraparound" -> True}],
                                              NotebookFind[ EvaluationNotebook[], "Field", CellTags],
                                              SelectionMove[ EvaluationNotebook[], After, CellContents],
                                              SelectionMove[ EvaluationNotebook[], Previous, Character, 2],
                                              SelectionMove[ EvaluationNotebook[], All, CellContents]]}];
*)

ButtonEditDialog[ nb_NotebookObject, dataType_:"TextData"] :=
 Notebook[{
  Cell[ $ButtonContent, "Text", 
   CellFrame -> True, 
   CellFrameLabels -> {{Cell["Content:", FontSize -> 10, FontWeight -> "Bold",
     TextAlignment -> Right, CellSize -> {48, 14}, Background -> None], None}, {None, None}}, 
   CellMargins -> {{16, 10}, {6, 18}},
   Background -> GrayLevel[0.99],
   CellTags -> {"ContentField", "Field"}], 
  Cell[ $ButtonData, "Text", CellFrame -> True, 
   CellFrameLabels -> {{Cell["Data:", FontSize -> 10, FontWeight -> "Bold", 
     TextAlignment -> Right, CellSize -> {48, 14}, Background -> None], None}, {None, None}}, CellMargins -> {{16, 10}, {6, 6}},
   AutoItalicWords -> {},
   Background -> GrayLevel[0.99],
   CellTags -> {"DataField", "Field"}], 
  Cell[ BoxData[
    RowBox[{ 
      ButtonBox["Change", 
        ButtonFunction :> ButtonEditChangeAction[ nb, dataType], 
        Method -> "Queued", ButtonFrame -> "DialogBox"], " ", 
      ButtonBox["Cancel", 
       ButtonFunction :> ButtonEditCancelAction[ nb, dataType], 
       Method -> "Queued", ButtonFrame -> "DialogBox"]}]], 
   "Text", 
 ShowStringCharacters -> False, 
 CellMargins -> {{68, 10}, {6, 6}}]}, 
 CellFrameMargins -> 5,
 WindowTitle -> "Change Button Contents and/or Data", 
 WindowSize -> {500, 140}, 
 WindowFrame -> "Palette", 
 WindowFrameElements -> {}, 
 WindowElements -> {}, 
 FontFamily -> "Verdana", 
 FontSize -> 11, ButtonBoxOptions -> {Active -> True, 
 Evaluator -> Automatic},
 ShowCellBracket -> False, 
 ClosingAutoSave -> False, 
 Saveable -> False,
 NotebookEventActions -> {"ReturnKeyDown" :> CompoundExpression[
                                                 ButtonEditChangeAction[ nb, dataType],
                                                 NotebookClose[ EvaluationNotebook[]]],
                          "DownArrowKeyDown" :> CompoundExpression[
                                                  SetOptions[ $FrontEnd, FindSettings -> {"Wraparound" -> True}],
                                                  SelectionMove[ EvaluationNotebook[], After, Cell],
                                                  NotebookFind[ EvaluationNotebook[], "Field", Next, CellTags, AutoScroll -> False],
                                                  SelectionMove[ EvaluationNotebook[], All, CellContents]] }];

ButtonEditChangeAction[ nb_NotebookObject, dataType_:"TextData"] :=
  Module[{ diaExp, newcont, newdata, bstyle, newExp},
    diaExp = NotebookGet[ ButtonNotebook[]];
    NotebookClose[ ButtonNotebook[]];
    
    newcont = (diaExp /. { Notebook[{___, Cell[ TextData[{cont_}], __, CellTags -> {"ContentField", __}, ___], ___}, ___] -> {cont},
                           Notebook[{___, Cell[ TextData[cont_], __, CellTags -> {"ContentField", __}, ___], ___}, ___] -> cont,
                           Notebook[{___, Cell[ cont_, __, CellTags -> {"ContentField", __}, ___], ___}, ___] -> cont} );
    newdata = (diaExp /. Notebook[{___, Cell[ data_, __, CellTags -> {"DataField", __}, ___], ___}, ___] -> data);
    bstyle = $ButtonStyle;

    newExp =
      Which[
        dataType === "TextData" && StringMatchQ[newdata, "http:*"],
          TextData[
            ButtonBox[ newcont,
              ButtonData -> {URL[newdata], None},
              BaseStyle -> bstyle
            ] 
          ],
        dataType === "TextData",
          TextData[
            ButtonBox[ newcont,
              If[ newdata =!= "", ButtonData -> newdata, Sequence@@{}],
              BaseStyle -> bstyle
            ]
          ],
        dataType === "BoxData" && StringMatchQ[newdata, "http:*"],
          ButtonBox[newcont,
            ButtonData -> {URL[newdata], None},
            BaseStyle -> bstyle
          ],
        dataType === "BoxData",
          ButtonBox[newcont,
            If[newdata =!= "", ButtonData -> newdata, Sequence@@{}],
            BaseStyle -> bstyle
          ],
        True,
          ButtonBox[newcont,
            If[newdata =!= "", ButtonData -> newdata, Sequence@@{}],
            BaseStyle -> bstyle
          ]
        ];

    NotebookWrite[ nb, newExp];

    If[ InlineCellQ[ nb],
      SetSelectedNotebook[ nb];
      FrontEndExecute[ FrontEnd`FrontEndToken[ nb, "MoveNext"]],
      RestoreDefault[]];

    $ButtonContent = "";
    $ButtonData = "";
    $ButtonStyle = "Link";
  ];


ButtonEditCancelAction[ nb_NotebookObject, dataType_:"TextData"] :=
  (
  NotebookClose[ ButtonNotebook[]];
  SetSelectedNotebook[ nb];
    Which[
      dataType == "TextData",
        FrontEndExecute[ FrontEnd`FrontEndToken[ nb, "MoveNext"]];
        RestoreDefault[],
      dataType == "BoxData",
        FrontEndExecute[{
          FrontEnd`FrontEndToken[ nb, "MoveNext"],
          FrontEnd`FrontEndToken[ nb, "MoveNext"]}]
      ];
      
  $ButtonContent = "";
  $ButtonData = "";
  $ButtonStyle = "Link";

  )





(*
  Function to toggle between 1- and 2-line forms of GuideText cells.
*)

GuideTextToggle[] :=
  Module[
    {
      nb = InputNotebook[],
      data
    },
    expandSelectionToCell[nb];
    data = OldNotebookRead[nb];
    Which[
      MatchQ[data, $GuideText1LinePattern],
        NotebookWrite[nb, data /. $1LineTo2Line, All]
      ,
      MatchQ[data, $GuideText2LinePattern],
        NotebookWrite[nb, data /. $2LineTo1Line, All]
      ,
      MatchQ[data, $GuideFunctionCellPattern],
        (* Maybe selection 1st in a 2-line;  extend select and recall. *)
        FrontEndExecute[FrontEnd`FrontEndToken[nb, "SelectNextLine"]];
        GuideTextToggle[]
      ,
      MatchQ[data, $GuideTextCellPattern],
        (* Maybe selection 2nd in a 2-line;  extend select and recall. *)
        FrontEndExecute[FrontEnd`FrontEndToken[nb, "SelectPreviousLine"]];
        GuideTextToggle[]
      ,
      True,
        MessageToConsole[DocuTools::nosel, "GuideTextToggle",
          "1- or 2-line GuideText entry"];
    ]
  ];


(* Patterns defining the 1- and 2-line forms. *)

$GuideFunctionCellPattern = Cell[_, "GuideFunction", ___];

$GuideTextCellPattern = Cell[_, "GuideText", ___];

$GuideText1LinePattern = 
  Cell[TextData[{_, _String?(StringMatchQ[#, " \[LongDash] *"] &), ___}], 
    "GuideText", ___
  ];

$GuideText2LinePattern =
  Cell[CellGroupData[
    {$GuideFunctionCellPattern, $GuideTextCellPattern}, _
  ]];


(* Transformation rules between 1- and 2-line forms. *)

$1LineTo2Line =
  {
    Cell[TextData[{
      Cell[BoxData[c_], "InlineGuideFunction"], 
      t_String?(StringMatchQ[#, " \[LongDash] *"]&),
      more___
    }], "GuideText", opts___]
      :>
        {
          Cell[BoxData[c], "GuideFunction"],
          Cell[TextData[{
            StringReplace[t, StartOfString ~~ " \[LongDash] " -> ""],
            more
          }], "GuideText", opts]
        },
    Cell[TextData[{
      c_, t_String?(StringMatchQ[#, " \[LongDash] *"]&), more___
    }], "GuideText", opts___]
      :>
        {
          Cell[TextData[c], "GuideFunction"],
          Cell[TextData[{
            StringReplace[t, StartOfString ~~ " \[LongDash] " -> ""],
            more
          }], "GuideText", opts]
        }
  };

$StripTextData =
  {
    TextData[{c___}] :> Sequence[c],
    TextData[c_] :> c
  };

$2LineTo1Line =
  {
    Cell[CellGroupData[{
      Cell[TextData[c_StyleBox], "GuideFunction", ___],
      Cell[t_, "GuideText", opts___]
    }, _]]
      :>
        Cell[TextData[{
          c, " \[LongDash] ", t /. $StripTextData
        }], "GuideText", opts]
    ,
    Cell[CellGroupData[{
      Cell[(BoxData | TextData)[c_], "GuideFunction", ___],
      Cell[t_, "GuideText", opts___]
    }, _]]
      :>
        Cell[TextData[{
          Cell[BoxData[c], "InlineGuideFunction"],
          " \[LongDash] ",
          t /. $StripTextData
        }], "GuideText", opts]
    ,
    Cell[CellGroupData[{
      Cell[c_String, "GuideFunction", ___],
      Cell[t_, "GuideText", opts___]
    }, _]]
      :>
        Cell[TextData[{
          Cell[BoxData[c], "InlineGuideFunction"],
          " \[LongDash] ",
          t /. $StripTextData
        }], "GuideText", opts]
  };



$OneLineFunctionTemplate =
  Cell[
    TextData[{
      Cell[BoxData["XXXX"], "InlineGuideFunction"],
      " \[LongDash] XXXX"
    }], 
    "GuideText"
  ];

$TwoLineFunctionTemplate =
    {
      Cell[BoxData["XXXX"], "GuideFunction"], 
      Cell["XXXX", "GuideText"]
    };


OneLineFunction::noin = "There is no open input notebook.";
OneLineFunction::mulcell = "Multiple cells have been selected.";
OneLineFunction::badsel = "Selection must be between cells or within a \"GuideText\" cell.";

OneLineFunction[] :=
  Module[
    {
      nb = InputNotebook[],
      ci, i, style
    },
Catch[
    ci = CellInfo[nb];
    If[nb === $Failed, Throw[MessageToConsole[OneLineFunction::noin]; Return[$Failed]]];
    If[multipleCellBracketsSelected[ci], Throw[MessageToConsole[OneLineFunction::mulcell]; Return[$Failed]]];
    If[ci === $Failed
      ,
      NotebookWrite[nb, $OneLineFunctionTemplate];
      ,
      If[MatchQ[CellInfo[nb], {{___, "InlineCellPosition" -> _, ___}}], 
         i = 1; While[i < 100 && MatchQ[CellInfo[nb], {{___, "InlineCellPosition" -> _, ___}}], 
                      FrontEndExecute[{FrontEndToken[nb, "ExpandSelection"]}]; i++]];
      style = "Style" /. First@CellInfo[nb] /. "Style" -> None;
      If[style != "GuideText",
        MessageToConsole[OneLineFunction::badsel];
        Return[$Failed]
      ];
      GuideTextFormat["CalledFromOneLineFunction"->True]
    ]]]


TwoLineFunction[] :=
  Module[
    {
      nb = InputNotebook[],
      ci
    },
    ci = CellInfo[nb];
    If[ci =!= $Failed,
      MessageToConsole[TwoLineFunction::badsel];
      Return[$Failed]
    ];
    NotebookWrite[
      InputNotebook[],
      $TwoLineFunctionTemplate
    ];
  ];

TwoLineFunction::badsel = "Selection must be between cells.";


(* Separator for one-line function listing. *)
$MainSep = " \[LongDash] ";

(* Separator for elements on lefthand side of one-line function listing. *)
$LeftSep = ", ";

(*
  Function to toggle between formatted and unformatted 1-line function
  listing.  (Assumes selection is in or on a "GuideText" cell.)
*)

Options[GuideTextFormat] =
  {
    "Notebook" -> Automatic,
      (* Document notebook (default: InputNotebook[]). *)
    "Action" -> "Toggle",
      (* Action to perform:
         "Format"    - Always format
         "Unformat"  - Always unformat
         "Toggle"    - Toggle between the two states
      *)
    "CalledFromOneLineFunction" -> False
  };

GuideTextFormat[options___?OptionQ] :=
  Module[
    {
      optNotebook, optAction, calledfromOneline,
      nb, data, newdata
    },
    {optNotebook, optAction, calledfromOneline} =
      {"Notebook", "Action", "CalledFromOneLineFunction"} /. {options} /. Options[GuideTextFormat];
    nb =
      If[optNotebook === Automatic,
        InputNotebook[],
        optNotebook
      ];
    CheckForEnclosingLinkedHead[nb];
    expandSelectionToCell[nb];
    data = NotebookRead[nb];
    newdata = GuideTextFormatTransform[data, optAction, "CalledFromOneLineFunction" -> calledfromOneline];
    If[newdata =!= data,
      NotebookWrite[nb, newdata, All]
    ];
  ];
  
Options[GuideTextFormatTransform] = {"CalledFromOneLineFunction" -> False}

GuideTextFormatTransform[data_, action_String, Opts___] :=
  Module[
    {
      calledfromOneline, content, lhs, rhs, AlreadyButtonized, collect, pnms, newcontent
    },
    calledfromOneline = "CalledFromOneLineFunction" /. {Opts} /. Options[GuideTextFormatTransform];
    content = data /. Cell[c_, ___] :> c;
    content =
      Switch[Head[content],
        String,
          {content},
        TextData | BoxData,
          First[content],
        _,
          MessageToConsole[GuideTextFormat::badcontent];
          Return[data]
      ];
    (* Split out any separators embedded in other strings into a separate
      element. *)
    content =
      If[Head[#] === String,
        Sequence @@ StringSplit[#, $MainSep -> $MainSep],
        #
      ]& /@ content;
    (* Split into left/right parts (separator goes w/the right) *)
    content = Split[content, (#2 =!= $MainSep)&];
    Which[
      Length[content] < 2,
        MessageToConsole[GuideTextFormat::noseps];
        Return[data];
      ,
      Length[content] > 2,
        MessageToConsole[GuideTextFormat::toomanyseps];
        Return[data];
    ];
    {lhs, rhs} = content;
    
    (* The following value is only of concern when calledfromOneline is True *)
    
    AlreadyButtonized = MatchQ[lhs, {Cell[BoxData[ButtonBox[__]], "InlineGuideFunction"]}];    
    
    (* Format or unformat, as appropriate. *)
    If[MatchQ[lhs, {(_String | _ButtonBox)...}]
      ,
      (* Currently unformatted... *)
      If[action == "Unformat", Return[data]];
      (*------------*)
      (*---Format---*)
      (*------------*)
      (* Join runs of strings... *)
      lhs = Split[lhs, (Head[#1] === Head[#2] === String)&];
      lhs =
        If[MatchQ[#, {___String}],
          StringJoin @@ #,
          Sequence @@ #
        ]& /@ lhs;
      (* ...then split them at the delimiter. *)
      lhs =
        If[Head[#] === String,
          Sequence @@ (
            StringSplit[#, {
              $LeftSep,
              d: ($Continued) ~~ Whitespace... ~~ EndOfString :> d
            }] /. "" -> Sequence[]  (* ...to drop empty elements. *)
          ),
          #
        ]& /@ lhs;
      lhs =
        InlineListingButtons[#, "Link", "InlineGuideFunction", None]& /@ lhs;
        
      lhs = If[calledfromOneline,
      
               lhs /. b : ButtonBox[a_String, BaseStyle -> "Link"] :> Which[MemberQ[Names["System`*"], a], b,
               
           If[Or[Not[ValueQ[$ApplicationName]], StringMatchQ[$ApplicationName, "" | Whitespace], 
             Not[ValueQ[$LinkBase]], StringMatchQ[$LinkBase, "" | Whitespace], (Quiet[Needs[$LinkBase <> "`"]];
              pnms = DeleteCases[Union[Names[$ApplicationName <> "`*"], Names[$ApplicationName <> "`*" <> "`*"]], 
                                 x_ /; StringMatchQ[x, __ ~~ "Private" ~~ __]];
              Not[MemberQ[pnms, a]])], False, True], 
           Insert[b, ButtonData -> StringJoin["paclet:", $LinkBase, "/ref/", a], -1],
           
           ValueQ[$ApplicationName] && Not@StringMatchQ[$ApplicationName, "" | Whitespace] && ValueQ[$LinkBase] && 
            Not@StringMatchQ[$LinkBase, "" | Whitespace] && (Quiet[Needs[$LinkBase <> "`"]];
             pnms = DeleteCases[Union[Names[$ApplicationName <> "`*"], Names[$ApplicationName <> "`*" <> "`*"]], 
                                x_ /; StringMatchQ[x, __ ~~ "Private" ~~ __]];
             Not[MemberQ[pnms, a]]),
             
           Insert[b, ButtonData -> StringJoin["paclet:", $LinkBase, "/ref/", a], -1],
           
           True, b], 
           
               lhs];
        
      (* Post-processing of $Continued links. *)
      lhs = lhs /.
        If[$HeadPath =!= None,
          (* If $HeadPath set (by an enclosing linked head), link any
            unlinked $Continued links to the same target. *)
          ButtonBox[c: $Continued, opts___] /; FreeQ[{opts}, ButtonData]
            :> ButtonBox[c, opts, ButtonData -> $HeadPath],
          (* ...else, delink any unlinked $Continued links. *)
          ButtonBox[c: $Continued, opts___] /; FreeQ[{opts}, ButtonData]
            :> c
        ];
      ,
      (* Currently formatted... *)
      If[action == "Format", Return[data]];
      (*--------------*)
      (*---Unformat---*)
      (*--------------*)
      (* Strip out content from formatting, break out parens as
        separate characters, and drop old delimiters and whitespace. *)
      lhs = StripFormatting /@ lhs;
      lhs =
        Replace[lhs,
          s_String :> Sequence @@ StringSplit[s, {")" -> ")", "(" -> "("}],
          {1}
        ];
      lhs = lhs /. {
          ws_String /; StringMatchQ[ws, Whitespace] :> Sequence[],
          $LeftSep -> Sequence[]
        };
      (* Collect:
        o Any paren-delimited special operators, and group them with the
          preceding symbol.
        o Any \[...] forms (where "..." is *not* a valid longname), and
          group that parts together.
      *)
      collect[a___, b_String, "(", c___String, ")", d___] :=
        {a, {b, " (", c, ")"}, d};
      collect[a___, "\\[", b___String, "]", c___] :=
        {a, {"\\[", b, "]"}, c};
      collect[a___] := {a};
      lhs = FixedPoint[(collect @@ #)&, lhs]; (*FIXME: Needs a limit? *)
      lhs =
        If[MatchQ[#, _String | {___String}],
          StringJoin[#],
          #
        ]& /@ lhs;
        
      (* The following piece of code is only for use when GuideTextFormatTransform is called by GuideTextFormat called from OneLineFunction. *)
      
      If[calledfromOneline && Not[AlreadyButtonized],
         lhs = Which[StringQ[#] && MemberQ[Names["System`*"], #],
         
	             Cell[BoxData[ButtonBox[#, BaseStyle -> "Link"]], "InlineGuideFunction"],
	             
	             StringQ[#] && If[Or[Not[ValueQ[$ApplicationName]], StringMatchQ[$ApplicationName, "" | Whitespace], 
	                                 Not[ValueQ[$LinkBase]], StringMatchQ[$LinkBase, "" | Whitespace], 
	                                 (Quiet[Needs[$LinkBase <> "`"]]; 
	                                  pnms = DeleteCases[Union[Names[$ApplicationName <> "`*"], Names[$ApplicationName <> "`*" <> "`*"]], 
	                                                     x_ /; StringMatchQ[x, __ ~~ "Private" ~~ __]]; 
	                                  Not[MemberQ[pnms, #]])], False, True],
	                                  
	             Cell[BoxData[ButtonBox[#, BaseStyle -> "Link", ButtonData -> StringJoin["paclet:", $LinkBase, "/ref/", #]]], "InlineGuideFunction"],
	             
                     StringQ[#] && ValueQ[$ApplicationName] && Not@StringMatchQ[$ApplicationName, "" | Whitespace] && ValueQ[$LinkBase] && 
		      Not@StringMatchQ[$LinkBase, "" | Whitespace] && (Quiet[Needs[$LinkBase <> "`"]];
		       pnms = DeleteCases[Union[Names[$ApplicationName <> "`*"], Names[$ApplicationName <> "`*" <> "`*"]], 
		                          x_ /; StringMatchQ[x, __ ~~ "Private" ~~ __]];
		       Not[MemberQ[pnms, #]]),
		       
		     Cell[BoxData[ButtonBox[#, BaseStyle -> "Link", ButtonData -> StringJoin["paclet:", $LinkBase, "/ref/", #]]], "InlineGuideFunction"],
                     
                     True,
                     
                     #] & /@ lhs,
         lhs = Cell[BoxData[If[StringQ[#], #, #[[1]]]], "InlineGuideFunction"] & /@ lhs]
        
    ];
    (* Reinsert separators, rejoin left/right and replace content. *)
    lhs = Riffle[lhs, $LeftSep];
    newcontent = Join[lhs, rhs];
    data /. Cell[_, rest___] :> Cell[TextData[newcontent], rest]
  ];

GuideTextFormat::badcontent = "Content of cell was neither String,
TextData, nor BoxData.";

GuideTextFormat::noseps = "There is no main
separator (" <> $MainSep <> ") in the one-line function listing.";

GuideTextFormat::toomanyseps = "There is more than one main
separator (" <> $MainSep <> ") in the one-line function listing.";


FormatAll[action: ("Format" | "Unformat" | "Toggle")] :=
  Module[
    {
      theAction = action,
      nb = InputNotebook[],
      FormatCells,
      optDelimiter, inDelims, outDelim, isFormatted, data, newdata
    },
    (*----- Recursive function to format at the Cell level. -----*)
    FormatCells[
      Cell[CellGroupData[{
        head: Cell[_, "GuideFunctionsSubsection", ___],
        cells: (___Cell)
      }, oc_]]
    ]:=
      Cell[CellGroupData[{
        ProcessHead[head, theAction],
        Sequence @@ (FormatCells /@ {cells})
      }, oc]];
    FormatCells[Cell[CellGroupData[cells_, oc_]]]:=
      Cell[CellGroupData[FormatCells /@ cells, oc]];
    FormatCells[c: Cell[_, "GuideText", ___]] :=
      GuideTextFormatTransform[c, theAction];
    FormatCells[
      c: Cell[_, "InlineGuideFunctionListing", ___]
    ] :=
      CellFunctionApplyTransform[c, inDelims, outDelim,
        InlineListingButtons[#, "Link", "InlineFormula", None]&,
        theAction
      ];
    FormatCells[else_] := else;
    (*-----------------------------------------------------------*)
    {optDelimiter} =
      {"Delimiter"}
        /.  Options[InlineListingToggle];
    {inDelims, outDelim} = ParseDelimiter[optDelimiter];
    If[inDelims === $Failed, Return[$Failed]];
    If[theAction == "Toggle",
      (* Check the notebook for the last action performed. *)
      isFormatted = getTaggingRulesOption[nb, $FormattedTag];
      theAction =
        Switch[isFormatted,
          True,  "Unformat",
          False, "Format",
          _,     $DefaultFormatToggleAction
        ];
    ];
    SelectionMove[nb, All, Notebook, AutoScroll -> False];
    data = NotebookRead[nb];
    BlockMessageOff[
      {
        GuideTextFormat::badcontent,
        GuideTextFormat::noseps,
        GuideTextFormat::toomanyseps
      },
      $HeadPath = None;
        (* ...Global variable to carry link information from a section
          head to enclosed inline listings (cf ProcessHead). *)
      newdata = FormatCells /@ data;
    ];
    SetOptions[NotebookSelection[nb], Deletable -> True];
    NotebookWrite[nb, newdata, AutoScroll -> False];
    (* Tag the notebook, recording this action. *)
    setTaggingRulesOption[nb, $FormattedTag ->
      Switch[theAction,
        "Format",   True,
        "Unformat", False
      ]
    ];
  ];

$FormattedTag = "Formatted";
$DefaultFormatToggleAction = "Format";


(*
  Following is to support links of ellipses in inline function listings to
  the targets of the enclosing sectional headers (cf the global transfer
  variable $HeadPath).
*)

(* Suffix to append to the end of the sectional head. *)
$HeadSuffix = " \[RightGuillemet]";
(* String in an inline listing to be linked. *)
$Continued = "...";

ProcessHead[head_Cell, "Format"] :=
  Module[
    {bOpts, style},
    (* Remember the link destination if section head's a button. *)
    bOpts =
      Flatten @ Cases[head, ButtonBox[_, opts___] :> {opts}, Infinity];
    {$HeadPath, style} =
      {ButtonData, BaseStyle}
        /. bOpts /. {ButtonData -> None, BaseStyle -> "Link"};
    (* Add $HeadSuffix if it's missing. *)
    If[$HeadPath === None
      ,
      head
      ,
      head /. {
        Cell[TextData[{
          pre___,
          ButtonBox[c_String?(!StringMatchQ[#, "*" <> $HeadSuffix]&), opts___]
        }], etc___] :>
          Cell[TextData[{pre, ButtonBox[c <> $HeadSuffix, opts]}], etc]
        ,
        Cell[TextData[
          ButtonBox[c_String?(!StringMatchQ[#, "*" <> $HeadSuffix]&), opts___]
        ], etc___] :>
          Cell[TextData[ButtonBox[c <> $HeadSuffix, opts]], etc]
        ,
        Cell[TextData[{pre___, end_ /; Head[end] =!= ButtonBox}], etc___] :>
          Cell[TextData[{
            pre,
            end,
            ButtonBox[$HeadSuffix,
              ButtonData -> $HeadPath, BaseStyle -> style]
          }], etc]
        ,
        Cell[TextData[
          end_ /; Not[MemberQ[{ButtonBox, List}, Head[end]]]
        ], etc___] :>
          Cell[TextData[{
            end,
            ButtonBox[$HeadSuffix,
              ButtonData -> $HeadPath, BaseStyle -> style]
          }], etc]
      }
    ]
  ];

(* Don't do anything when unformatting. *)
ProcessHead[head_Cell, "Unformat"] := head;


CheckForEnclosingLinkedHead[nb_NotebookObject] :=
  Module[
    {posID, data, newdata},
    SetOptions[nb, ShowSelection -> False];
    (* Remember current selection (via CellID). *)
    expandSelectionToCell[nb];
    posID = CellID /. Options[NotebookSelection[nb]];
    (* Expand outward to enclosing cell group. *)
    data = NotebookRead[nb];
    While[Head[data] =!= List && !MatchQ[data, Cell[CellGroupData[___]]],
      FrontEndTokenExecute[nb, "ExpandSelection"];
      data = NotebookRead[nb];
    ];
    (* If we found a cell group... *)
    If[Head[data] =!= List,
      (* ...select the head cell and process it
        (possibly setting $HeadPath). *)
      SelectionMove[nb, Before, Cell];
      SelectionMove[nb, Next, Cell];
      data = NotebookRead[nb];
      newdata = ProcessHead[data, "Format"];
      If[newdata =!= data, NotebookWrite[nb, newdata]];
    ];
    (* Restore initial selection. *)
    NotebookFind[nb, posID, All, CellID];
    SetOptions[nb, ShowSelection -> Inherited];
  ];
  

SelectionWordSort::noin = "There is no input notebook.";
SelectionWordSort::plaintext = "Plain text or a sequence of cells all containing plain text must be selected.";
SelectionWordSort::noin = "The selection must consist of words all of which start with capital letters.";

SelectionWordSort[] := 
 Module[{nb = InputNotebook[], ci, re, li, list}, 
  Catch[If[nb === $Failed, 
           Throw[MessageToConsole[SelectionWordSort::noin]]];
        ci = CellInfo[nb]; 
       If[(* The cursor is between cells. *)ci === $Failed, 
          Throw[MessageToConsole[SelectionWordSort::plaintext]]];
       re = NotebookRead[nb];
       If[(* One or more cell brackets is selected or a string is selected. *)
          MatchQ[ci, {{__, "CursorPosition" -> "CellBracket", __} ..}],
          If[Not[(MatchQ[re, Cell[_String, __]] || MatchQ[re , {Cell[_String, __] ..}])],
             Throw[MessageToConsole[SelectionWordSort::plaintext]]]];
       If[MatchQ[re, {Cell[_String, __] ..}],
          li = Sort[re, OrderedQ[{#1[[1]], #2[[1]]}] &];
          Throw[NotebookWrite[nb, li, All]]];
       If[MatchQ[re, Cell[_String, __]], Throw[Null]];
       If[Not@StringQ@re, Throw[MessageToConsole[SelectionWordSort::plaintext]]];
       list = StringReplace[#, (StartOfString ~~ Whitespace) | (Whitespace ~~ EndOfString) -> ""] & /@ 
                                                                                    StringSplit[re, {","}]; 
       If[Not[And @@ (StringMatchQ[#, ("" | "\"") ~~ a_?UpperCaseQ ~~ ___] & /@ list)], 
          Throw[MessageToConsole[SelectionWordSort::noin]]]; 
       NotebookWrite[nb, StringJoin @@ Riffle[Sort@list, ", "], All]]]


Options[CycleNotebookSelection] =
  {
    "Clickable" -> True,
    "Visible" -> True
  };

$CurrentNotebook = 0;

CycleNotebookSelection[OptionsPattern[]] :=
  Module[{opts},
    opts = OptionValue[#]& /@ {"Clickable", "Visible"};
    opts = Pick[{WindowClickSelect, Visible}, opts];
    $CurrentNotebook++;
    SetSelectedNotebook @
      First @ RotateLeft[
        Select[Sort @ Notebooks[], And @@ (opts /. Options[#, opts])&],
        $CurrentNotebook
      ]
  ];
  
  
Traditionalize[text_String] := 
 FormBox[Function[{expr}, MakeBoxes[expr, StandardForm], HoldFirst] @@
    MakeExpression[text, StandardForm], TraditionalForm]
    
TraditionalFormSelectionConvert::noinputnb = "There is no input notebook.";
TraditionalFormSelectionConvert::emptysel = "The selection is empty.";
TraditionalFormSelectionConvert::notstr = "The selection is not a string.";

TraditionalFormSelectionConvert[] := 
 Module[{nb = NextNotebook[], re}, 
  Catch[If[nb === None, Throw[MessageToConsole[TraditionalFormSelectionConvert::noinputnb]]]; 
        re = NotebookRead[nb]; 
        If[re === {}, Throw[MessageToConsole[TraditionalFormSelectionConvert::emptysel]]]; 
        If[Not@StringQ[re], Throw[MessageToConsole[TraditionalFormSelectionConvert::notstr]]];
        NotebookWrite[nb, Cell[BoxData[Traditionalize[re]], "InlineMath"]]]]
      
      
(* Code for step be step construction of overviews. *)

BrowseToTutorialAndOpen::pacvarsnotset = "$ApplicationName, $LinkBase and $TutorialDirectory must first be set. Use the Set Paclet Name & Path button to do this.";
BrowseToTutorialAndOpen::notapptutorial = "You must select a tutorial in the Tutorials directory of `1`. Use the Set Paclet Name & Path button first in the DocumentationTools palette if you want to work on another project.";

BrowseToTutorialAndOpen[] := 
If[Or[Not[StringQ[$TutorialDirectory]], FileType[$TutorialDirectory]=!=Directory, Not[StringQ[$ApplicationName]], Not[StringQ[$LinkBase]],
            StringMatchQ[$ApplicationName, "" | Whitespace], StringMatchQ[$LinkBase, "" | Whitespace]], 
      MessageToConsole[BrowseToTutorialAndOpen::pacvarsnotset], 
      Catch[If[# =!= Null && # =!= $Canceled, 
            If[Not[StringMatchQ[#, 
                   StringExpression[__ , $LinkBase, $PathnameSeparator, "Documentation", $PathnameSeparator, $Language, $PathnameSeparator, "Tutorials",
                                    $PathnameSeparator, (a__ /; StringFreeQ[a, $PathnameSeparator]), ".nb"]]], 
                  Throw[MessageToConsole[BrowseToTutorialAndOpen::notapptutorial, $LinkBase]]]; 
         $ApplicationTutorialsFile = #; 
         NotebookOpen[$ApplicationTutorialsFile], Abort[]] &[SystemDialogInput["FileOpen", $TutorialDirectory, 
                                                                               WindowTitle -> "Browse for tutorial link file"]]]]
                                                                               
$CellData = {}

CopyTutorialCellData::noin = "There is no input notebook.";
CopyTutorialCellData::pacvarsnotset = "$ApplicationName and $LinkBase must first be set.";
CopyTutorialCellData::notbrowsedtutorial = "You must first browse to a tutorial in the Tutorials directory of `1`."
CopyTutorialCellData::betwcells = "The cursor is between cells or not inside an input notebook.";
CopyTutorialCellData::mulcell = "Multiple cells have been selected.";
CopyTutorialCellData::notatbrac = "The cursor is not at a single cell bracket.";
CopyTutorialCellData::nocellid = "The selected cell has no CellID.";
CopyTutorialCellData::cell = "The cell selected must only contain plain or styled text.";

CopyTutorialCellData[] := 
 Module[{nb = InputNotebook[], ci, cellid, re}, 
  Catch[If[nb === $Failed, 
           Throw[MessageToConsole[CopyTutorialCellData::noin]]]; 
        If[Or[Not[StringQ[$ApplicationName]], Not[StringQ[$LinkBase]], StringMatchQ[$ApplicationName, "" | Whitespace], 
           StringMatchQ[$LinkBase, "" | Whitespace]], 
           Throw[MessageToConsole[CopyTutorialCellData::pacvarsnotset]]]; 
        If[Or[Quiet[NotebookFileName[nb] === $Failed], Not@StringQ[$ApplicationTutorialsFile], NotebookFileName[nb] =!= $ApplicationTutorialsFile, 
              Not[StringMatchQ[$ApplicationTutorialsFile, 
                               StringExpression[__, $LinkBase, $PathnameSeparator, "Documentation", $PathnameSeparator, $Language,
                                                $PathnameSeparator, "Tutorials", $PathnameSeparator, (a__ /; StringFreeQ[a, $PathnameSeparator]), ".nb"]]]], 
           Throw[MessageToConsole[CopyTutorialCellData::notbrowsedtutorial, $LinkBase]]]; 
        ci = CellInfo[nb];
        If[ci === $Failed, Throw[MessageToConsole[CopyTutorialCellData::betwcells]]]; 
        If[multipleCellBracketsSelected[ci], 
          Throw[MessageToConsole[CopyTutorialCellData::mulcell]]]; 
        If[Not@MatchQ[ci, {{__, "CursorPosition" -> "CellBracket", __}}], 
           Throw[MessageToConsole[CopyTutorialCellData::notatbrac]]]; 
        cellid = CellID /. Options[NotebookSelection[nb], CellID]; 
        If[cellid === 0, 
           Throw[MessageToConsole[CopyTutorialCellData::nocellid]]]; 
        re = NotebookRead[nb][[1]]; 
        If[Not@MatchQ[re, _String | TextData[StyleBox[_String, __]] | TextData[{(_String | StyleBox[_String, __]) ..}]], 
           Throw[MessageToConsole[CopyTutorialCellData::cell]]]; 
        $CellData = {NotebookRead[nb][[1]], ("Style" /. ci)[[1]], cellid}]]
        
PasteTutorialCell::noin = "There is no input notebook.";
PasteTutorialCell::notoverview = "The notebook being pasted into does not have a metadata cell with Entity Type Overview.";
PasteTutorialCell::pacvarsnotset = "$ApplicationName and $LinkBase must first be set."; 
PasteTutorialCell::notbrowsedtutorial = "You must first browse to a tutorial in the Tutorials directory of `1` and select a cell using the Select Cell button."; 
PasteTutorialCell::celldata = "You must use the Browse and Select Cell buttons to select a text data cell. After each use of Paste, a cell must again be selected from a tutorial via the Select Cell button."; 
PasteTutorialCell::mulcell = "Multiple cells have been selected."; 
PasteTutorialCell::style = "Select a cell in the overview notebook being constructed since the cell style of the cell selected in `1` is not one of \"Section\", \"Subsection\" or \"Subsubsection\". Then click the Paste button again."; 

PasteTutorialCell[] := 
 Module[{nb = InputNotebook[], ci, rules = {"Section" -> "TOCSection", "Subsection" -> "TOCSubsection", "Subsubsection" -> "TOCSubsubsection"}, buttondata,
         style}, 
  Catch[If[nb === $Failed, 
           Throw[MessageToConsole[PasteTutorialCell::noin]]];
        If[Cases[NotebookGet[nb], Cell["Overview", "Categorization", CellLabel -> "Entity Type", ___], Infinity] === {},
           Throw[MessageToConsole[PasteTutorialCell::notoverview]]];
        If[Or[Not[StringQ[$ApplicationName]], Not[StringQ[$LinkBase]], StringMatchQ[$ApplicationName, "" | Whitespace], 
              StringMatchQ[$LinkBase, "" | Whitespace]], 
           Throw[MessageToConsole[PasteTutorialCell::pacvarsnotset]]]; 
        If[Or[Not@StringQ[$ApplicationTutorialsFile], 
            Not[StringMatchQ[$ApplicationTutorialsFile, 
             StringExpression[__, $LinkBase, $PathnameSeparator, "Documentation", $PathnameSeparator, $Language,
                              $PathnameSeparator, "Tutorials", $PathnameSeparator, (a__ /; StringFreeQ[a, $PathnameSeparator]), ".nb"]]]], 
           Throw[MessageToConsole[PasteTutorialCell::notbrowsedtutorial, $LinkBase]]]; 
        If[Not@MatchQ[$CellData, {_String | TextData[StyleBox[_String, __]] | TextData[{(_String | StyleBox[_String, __]) ..}], _String, _Integer}], 
           Throw[MessageToConsole[PasteTutorialCell::celldata]]]; 
        ci = CellInfo[nb]; 
        If[multipleCellBracketsSelected[ci], 
           Throw[MessageToConsole[PasteTutorialCell::mulcell]]]; 
        If[CellInfo[nb] === $Failed && Not[MemberQ[{"Section", "Subsection", "Subsubsection"}, $CellData[[2]]]], 
           Throw[MessageToConsole[PasteTutorialCell::style, StringReplace [#, DirectoryName[#] -> ""] &[$ApplicationTutorialsFile]]]]; 
        buttondata = StringJoin["paclet:", $LinkBase, "/tutorial/", 
                                (StringReplace[#, {DirectoryName[#] -> "", ".nb" -> ""}] &[$ApplicationTutorialsFile]), "#", ToString[$CellData[[3]]]];
        style = If[ci === $Failed, $CellData[[2]] /. rules, ("Style" /. ci)[[1]]];
        NotebookWrite[nb, 
           DeleteCases[Switch[$CellData[[1]], 
                      _String, 
                      Cell[TextData[ButtonBox[$CellData[[1]], BaseStyle -> "Link", ButtonData -> buttondata]], style], 
                      TextData[StyleBox[_String, __]], 
                      Cell[TextData[StyleBox[ButtonBox[$CellData[[1, 1, 1]], BaseStyle -> "Link", ButtonData -> buttondata], 
                           Sequence @@ Take[$CellData[[1, 1]], {2, -1}]]], style], 
                      _, 
                      Cell[TextData[If[MatchQ[#, StyleBox[__]], 
                                       StyleBox[ButtonBox[#[[1]], BaseStyle -> "Link", ButtonData -> buttondata], Sequence @@ Take[#, {2, -1}]], 
                                        ButtonBox[#, BaseStyle -> "Link", ButtonData -> buttondata]] & /@ $CellData[[1, 1]]], style]],
                      (CellChangeTimes->_)]]; 
        $CellData = {}]]
  

(* Code for tutorial division and Overview creation. *)

OverviewRules[tutorialpath_, linkbase_] := 
  Module[{nm, oldheadstyles = {"Section", "Subsection", "Subsubsection"}, 
          newheadstyles = {"TOCSection", "TOCSubsection", "TOCSubsubsection"}}, 
   nm = StringReplace[tutorialpath, {DirectoryName[tutorialpath] -> "", ".nb" -> ""}]; 
    {Cell[a_String, b_, ___, CellID -> c_, ___] :> Cell[TextData[ButtonBox[a, BaseStyle -> "Link", 
        ButtonData -> "paclet:" <> linkbase <> "/tutorial/" <> nm <> "#" <> ToString[c]]], 
                                                        Extract[newheadstyles, Position[oldheadstyles, b][[1]]]], 
     Cell[TextData[StyleBox[a_String, FontSlant -> "Italic"]], b_, ___, CellID -> c_, ___] :> 
      Cell[TextData[StyleBox[ButtonBox[a, BaseStyle -> "Link", 
              ButtonData -> "paclet:" <> linkbase <> "/tutorial/" <> nm <> "#" <> ToString[c]], FontSlant -> "Italic"]], 
           Extract[newheadstyles, Position[oldheadstyles, b][[1]]]], 
     Cell[TextData[{a__}], b_, ___, CellID -> c_, ___] :> 
      Cell[TextData[If[StringQ[#], 
                       ButtonBox[#, BaseStyle -> "Link", 
                                       ButtonData -> "paclet:" <> linkbase <> "/tutorial/" <> nm <> "#" <> ToString[c]], 
                       StyleBox[ButtonBox[#, BaseStyle -> "Link", 
                                       ButtonData -> "paclet:" <> linkbase <> "/tutorial/" <> nm <> "#" <> ToString[c]], 
                                FontSlant -> "Italic"]] & /@ {a}], 
           Extract[newheadstyles, Position[oldheadstyles, b][[1]]]]}]
           
           
GenerateOverview[tutorialdir_String /; FileType[tutorialdir] === Directory && 
                StringMatchQ[tutorialdir, __ ~~ ("Tutorials" | "Tutorials" ~~ $PathnameSeparator)], 
                linkbase_String,
                application_String] := 
 Module[{tutorials, fl, gt, cs, title, cells, nb, fl2}, 
  tutorials = DeleteCases[FileNames["*.nb", {tutorialdir}], 
                          x_String /; StringMatchQ[StringReplace[x, DirectoryName[x] -> ""], 
                                                   "*Overview*" | "*UndefinedStyles*", IgnoreCase -> True]]; 
  Quiet[fl = Flatten[(gt = Get[#]; cs = Cases[gt, Cell[_, "Section" | "Subsection" | "Subsubsection", __], Infinity]; 
        title = Cases[gt, Cell[_, "Title", __], Infinity]; 
        cells = Prepend[cs /. OverviewRules[#, linkbase], 
           Cell[TextData[ButtonBox[If[title =!= {}, 
                                      title[[1, 1]], 
                                      StringReplace[#, {DirectoryName[#] -> "", ".nb" -> ""}]], BaseStyle -> "Link", 
       ButtonData -> "paclet:" <> linkbase <> "/tutorial/" <> StringReplace[#, {DirectoryName[#] -> "", ".nb" -> ""}]]], 
               "TOCChapter"]] /. StyleBox[a_, "TB"] :> a) & /@ tutorials]];
  nb = CreateWindow[StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "TutorialPageStyles.nb"]]; 
  NotebookWrite[nb, Prepend[fl2, Cell[application, "Title"]]];
  FrontEndExecute[{FrontEndToken[nb, "SelectAll"]}]; 
  FrontEndExecute[{FrontEndToken[nb, "SelectionCloseAllGroups"]}];
 NotebookSave[nb, ToFileName[{tutorialdir, application}, "Overview.nb"]];
  NotebookClose[nb]]
  

TutorialDivider::firstarg = "The first argument must be either a file or directory path.";
TutorialDivider::emptysourcedir = "The source directory contains no notebooks at its top level.";
TutorialDivider::nottutorialsdir = "The output directory must be some Tutorials directory.";
(* TutorialDivider::tutdivnotinstyles = "The tutorial divider you have selected is valid but is not in the tutorials style sheet. Use $StyleReplacements to specify a replacement. For example, if \"Chapter\" must be replaced you could try setting $StyleReplacements = {\"Chapter\" -> \"Title\"} and then click the OK button again."; *)
TutorialDivider::stylereplacementsform = "The list of style replacements must be of the form: {string11 -> string12, string21 -> string22, ...}.";
TutorialDivider::identicalheadings = "At least one heading in a divider cell occurs in more than one tutorial. (If you have chosen to remove section numbering this would be after section numbering has been removed.) Each divider heading should occur only once among all of the tutorials. Here is the data regarding repetitions where each heading that occurs more than once is followed by the notebooks in which it appears: (`1`).";
TutorialDivider::heading = "One or more cells for the selected heading has no children.";
TutorialDivider::overwrite = "The process will be halted since one or more of the notebooks being created will overwrite one or more notebooks that already exists in the output directory.";
TutorialDivider::notpriorsix = "The tutorial divider is intended for dividing pre-Mathematica 6 tutorials - tutorials without metadata, a More About section etc..";

Options[TutorialDivider] = {StripSectionNumbering -> False, RetainOriginalTableFormatting -> False, RetainOriginalTextCellFormatting -> False}

$StyleReplacements = {}

(*  dp = FileNames["DocuTools", $Path];     
    If[dp =!= {} && (file = ToFileName[{dp[[1]], "FrontEnd", "StyleSheets", "Wolfram"}, "TutorialPageStyles.nb"]; 
                        FileType[file] === File) && 
             (styles = Union@Cases[Get[file], Cell[StyleData[a_ /; a =!= All, ___], __] :> a, Infinity]; 
              Not@MemberQ[styles, If[$StyleReplacements === {}, $TutorialDivider, $TutorialDivider /.$StyleReplacements]]), 
          Throw[MessageToConsole[TutorialDivider::tutdivnotinstyles]]]  *)
          
(* FixStyleHierarchy makes for example "Subsection" cells after a "Title" cell all become "Section". *)

UpgradeSomeSubsectionHeadings[nbexpr_, nb_] := 
 Module[{SubsectionsNeedingUpgrading, i}, 
  SubsectionsNeedingUpgrading = Cases[DeleteCases[nbexpr, 
                                                  Cell[CellGroupData[{Cell[_, "Section", ___], ___}, ___]], Infinity], 
                                      Cell[_, "Subsection", ___, CellID -> c_] :> c, Infinity]; 
  If[Length@SubsectionsNeedingUpgrading > 0,
    (* Upgrade some Subsection headings. *)i = 1; 
   While[i <= Length@SubsectionsNeedingUpgrading, 
         NotebookFind[nb, SubsectionsNeedingUpgrading[[i]], All, CellID]; 
         FrontEndExecute[{FrontEndToken[nb, "Style", "Section"]}]; i++]]]
    
UpgradeSomeSubsubsectionHeadings[nbexpr_, nb_] := 
 Module[{SubsubsectionsNeedingUpgrading, i}, 
  SubsubsectionsNeedingUpgrading = Cases[DeleteCases[nbexpr, 
                                                     Cell[CellGroupData[{Cell[_, "Subsection", ___], ___}, ___]], Infinity], 
                                         Cell[_, "Subsubsection", ___, CellID -> c_] :> c, Infinity]; 
  If[Length@SubsubsectionsNeedingUpgrading > 0,
    (* Upgrade some Subsubsection headings. *)i = 1; 
   While[i <= Length@SubsubsectionsNeedingUpgrading, 
         NotebookFind[nb, SubsubsectionsNeedingUpgrading[[i]], All, CellID]; 
         FrontEndExecute[{FrontEndToken[nb, "Style", "Subsection"]}]; i++]]]
    
FixStyleHierarchy[nb_] := 
 Module[{prenbexpr, prenbexpr2, nbexpr}, 
        prenbexpr = NotebookGet[nb]; 
        UpgradeSomeSubsectionHeadings[prenbexpr, nb]; 
        prenbexpr2 = NotebookGet[nb]; 
        UpgradeSomeSubsubsectionHeadings[prenbexpr2, nb]; 
        nbexpr = NotebookGet[nb]; 
        While[prenbexpr =!= nbexpr, 
              nbexpr = NotebookGet[nb]; 
              UpgradeSomeSubsectionHeadings[nbexpr, nb]; 
              prenbexpr2 = NotebookGet[nb]; 
              UpgradeSomeSubsubsectionHeadings[prenbexpr2, nb]; 
              prenbexpr = NotebookGet[nb]]]
                                                              
TutorialMetaDataCells[application_, linkbase_, filename_] := 
                        {Cell[TextData[{"New in: ", Cell["XX", "HistoryData", CellTags -> "New"], " | Modified in: ", 
                         Cell[" ", "HistoryData", CellTags -> "Modified"], " | Obsolete in: ", 
                         Cell[" ", "HistoryData", CellTags -> "Obsolete"], " | Excised in: ", 
                         Cell[" ", "HistoryData", CellTags -> "Excised"]}], "History"], 
                         Cell[CellGroupData[{Cell["Categorization", "CategorizationSection"], 
                         Cell[If[filename === "Overview", "Overview", "Tutorial"], "Categorization", CellLabel -> "Entity Type"], 
                         Cell[linkbase <> " Package", "Categorization", CellLabel -> "Paclet Name"], 
                         Cell[application <> "`", "Categorization", CellLabel -> "Context"],
                         Cell[linkbase <> "/tutorial/" <> filename, "Categorization", CellLabel->"URI"]}, Closed]], 
                         Cell[CellGroupData[{Cell["Keywords", "KeywordsSection"], Cell["XXXX", "Keywords"]}, Closed]], 
                         Cell[CellGroupData[{Cell["Details", "DetailsSection"], 
                         Cell["XXXX", "Details", CellLabel -> "Developers"], 
                         Cell["XXXX", "Details", CellLabel -> "Comments"]}, Closed]]}
                         
TutorialPostDataCells = {Cell[CellGroupData[{Cell["More About", "TutorialMoreAboutSection"], Cell["XXXX", "TutorialMoreAbout"]}, Open]], 
                         Cell[CellGroupData[{Cell["Related Tutorials", "RelatedTutorialsSection"], Cell["XXXX", "RelatedTutorials"]}, Open]], 
                         Cell[CellGroupData[{Cell["Related Wolfram Education Group Courses", "TutorialRelatedLinksSection"], 
                                             Cell["XXXX", "TutorialRelatedLinks"]}, Open]]}
                         
ConvertStringToListWithBasicButtons[str_String, applicationname_, linkbase_] := 
 Quiet@Module[{ApplicationNames, strsplt, appnms, appbutrules, rules}, 
   ApplicationNames = DeleteCases[Union[Names[applicationname <> "`*"], Names[applicationname <> "`*`*"]], 
                                  a_String /; StringMatchQ[a, __ ~~ "Private`" ~~ __] || StringMatchQ[a, (b_ /; LowerCaseQ[b]) ~~ ___]]; 
   strsplt = StringSplit[str, " " | ")" | "(" | "." | "," | ";" | ":"]; 
   appnms = Intersection[ApplicationNames, strsplt]; 
   If[appnms =!= {},
   
      appbutrules = 
       {a : (StartOfString | (b_ /; Not@StringMatchQ[b, WordCharacter])) ~~ # ~~ br : ("[ ]" | "[\[NonBreakingSpace]]") ~~ c : (Whitespace | ")" | "(" | "." | "," | ";" | ":") -> 
 a ~~ Cell[BoxData[RowBox[{ButtonBox[#, BaseStyle -> "Link", ButtonData -> "paclet:" <> linkbase <> "/ref/" <> #], "[", "]"}]], "InlineFormula"] ~~ c,
 
 a : (StartOfString | (b_ /; Not@StringMatchQ[b, WordCharacter])) ~~ # ~~ c : (EndOfString | (d_ /; Not@StringMatchQ[d, WordCharacter | "["])) -> 
        a ~~ Cell[BoxData[ButtonBox[#, BaseStyle -> "Link", ButtonData -> "paclet:" <> linkbase <> "/ref/" <> #]], "InlineFormula"] ~~ c} & /@ appnms;
        
    rules = RuleDelayed @@@ Flatten[Evaluate[appbutrules]]; 
    List @@ StringReplace[str, rules], str]]

UniformizeTableCell[ce_Cell, applicationname_, linkbase_, systemexceptionslist_:{}] := 
 Module[{systemnames = Complement[Names["System`*"], systemexceptionslist], ThreeColumnQ, i},
 If[MatchQ[ce /. FormBox[a_, _] :> a, Cell[BoxData[GridBox[{{_, _} .. | {_, _, _} ..}, ___]], 
    x_ /; StringMatchQ[x, Alternatives @@ $AcceptableTableStyles], ___]],
    ThreeColumnQ = Length[(ce /. FormBox[a_, _] :> a)[[1, 1, 1, 1]]] === 3;
   (((((((((((((((Map[# //. {a___, Longest[b__String], c___} :> {a, StringJoin[b], c} &,
    ((MapAt[Map[(i = 0; (If[(i =!= 2 && ThreeColumnQ) || AtomQ[#], 
                            i++; #, i++; 
                            Flatten[# //. RowBox[{a__}] :> {a}]]) & /@ #) &, #] &,
            (((ce //. StyleBox[a_, ___] :> a) /. FormBox[a_, _] :> a)), {1, 1, 1}])), {5}]) (*/.
    c : Cell[_, x_ /; StringMatchQ[x, Alternatives @@ $AcceptableTableStyles], ___, 
             GridBoxOptions -> {g__}, ___] :> c /. (GridBoxOptions -> {gbo__}) :> If[FreeQ[{gbo},
             GridBoxDividers -> _] || (Not@FreeQ[{gbo}, GridBoxDividers -> _] && Union@Flatten[GridBoxDividers /. {gbo}] === {False}), 
           Unevaluated[Sequence[]], 
           GridBoxOptions -> {GridBoxDividers -> (GridBoxDividers /. {gbo})}]*)) /. {GridBox[nl : {{_, _} ..}] :> 
         GridBox[{If[MatchQ[#[[1]], {_String}], #[[1, 1]], RowBox[#[[1]]]],
                  Which[MatchQ[#[[2]], Cell[_, "TableText", ___]],
                        #[[2]],
                        MatchQ[#[[2]], {_String}], 
                        Cell[If[StringQ[#], #, TextData[{#}]] &@ConvertStringToListWithBasicButtons[#[[2, 1]], applicationname, linkbase], "TableText"],
                        True,
                        Cell[TextData[If[StringQ@#, #, Flatten@#] &[If[StringQ[#],
                                                                    ConvertStringToListWithBasicButtons[#, applicationname, linkbase],
                                                                    #] & /@ (If[StringQ[#], #, 
                          Cell[BoxData[#], "InlineFormula"]] & /@ #[[2]])]], "TableText"]]} & /@ nl], 
        GridBox[nl : {{_, _, _} ..}] :> GridBox[{If[MatchQ[#[[1]], {_String}], #[[1, 1]], RowBox[#[[1]]]],
                                                 #[[2]],
                                                 If[AtomQ[#[[-1]]] || MatchQ[#[[-1]], Cell[_, "TableText", ___]],
                                                    #[[-1]],
                                                    If[MatchQ[#[[-1]], {_String}], 
               Cell[If[StringQ[#], #, TextData[{#}]] &@ConvertStringToListWithBasicButtons[#[[-1, 1]], applicationname, linkbase], "TableText"], 
               Cell[TextData[If[StringQ@#, #, Flatten@#] &[If[StringQ[#],
                                                              ConvertStringToListWithBasicButtons[#, applicationname, linkbase],
                                                              #] & /@ (If[StringQ[#], #, 
                    Cell[BoxData[#], "InlineFormula"]] & /@ #[[-1]])]],
                    "TableText"]]]} & /@ nl]}) /. {RowBox[a_ /; MemberQ[{String, Cell},
                    Head@a]], b_, c_} :> {a, b, c}) /. StyleBox[a_String, _] :> If[MemberQ[$ApplicationSymbolsWithUsage, a], 
     ButtonBox[a, BaseStyle -> "Link",
               ButtonData -> "paclet:" <> $LinkBase <> "/ref/" <> a],
               a]) /. GridBox[g : {{_String | Cell[_String | TextData[_String], ___], _String | Cell[_String | TextData[_String], ___], 
     a_ /; StringMatchQ[a, "" | Whitespace]}, {_, _, _} ..}] :> GridBox[MapAt[# /. {b_, c_, d_} :> {Switch[b, _String, StyleBox[b, "TableHeader"], 
        Cell[_String, ___], StyleBox[b[[1]], "TableHeader"], 
        Cell[TextData[_String], ___], StyleBox[b[[1, 1]], "TableHeader"], _, b], 
       Switch[c, _String, StyleBox[c, "TableHeader"], Cell[_String, ___], StyleBox[c[[1]], "TableHeader"], 
        Cell[TextData[_String], ___], StyleBox[c[[1, 1]], "TableHeader"], _, c], d} &, g, 1]]) /. GridBox[nl : {{_, _, _} ..}] :> 
  GridBox[Composition[MapAt[If[StringQ@# && MemberQ[systemnames, #],
                               ButtonBox[#, BaseStyle -> "Link"],
                               #] &, #, 2] &, 
     MapAt[Which[StringQ@# && MemberQ[$ApplicationSymbolsWithUsage, #],
                 ButtonBox[#, BaseStyle -> "Link", ButtonData -> "paclet:" <> $LinkBase <> "/ref/" <> #],
                 StringQ@# && MemberQ[systemnames, #],
                 ButtonBox[#, BaseStyle -> "Link"],
                 True,
                 #] &, #, 1] &] /@ nl]) /. {Cell[BoxData[{a__String}], "InlineFormula"] :> 
 Unevaluated[Sequence @@ (Cell[BoxData[#], "InlineFormula"] & /@ {a})], Cell[BoxData[StyleBox[{a__String}]], "InlineFormula"] :> 
 Unevaluated[Sequence @@ (Cell[BoxData[#], "InlineFormula"] & /@ {a})]}) /. {Cell[BoxData[a_String /; LowerCaseQ[StringTake[a, 1]]], "InlineFormula"] :> a, 
 Cell[BoxData[a_String /; MemberQ[systemnames, a]], "InlineFormula"] :> ButtonBox[a, BaseStyle -> "Link"], Cell[BoxData[a_String], "InlineFormula"] :> a}) /.
 {RowBox[StyleBox[RowBox[{a_String}], "TableHeader"]] :> StyleBox[a, "TableHeader"],
  StyleBox[RowBox[{a_String}], "TableHeader"] :> StyleBox[a, "TableHeader"], RowBox[ButtonBox[a__]] :> ButtonBox[a],
  RowBox[StyleBox[{a_String}, "TableHeader"]] :> StyleBox[a, "TableHeader"], StyleBox[{a_String}, "TableHeader"] :> StyleBox[a, "TableHeader"]})/.
  {RowBox[a_String], Cell[b_, "TableText", c___]} :> {If[MemberQ[$ApplicationSymbolsWithUsage, a],
                                   ButtonBox[a, BaseStyle -> "Link", ButtonData -> "paclet:" <> $LinkBase <> "/ref/" <> a], a], Cell[b, "TableText", c]})/.
  {RowBox[a_String], m_, Cell[b_, "TableText", c___]} :> {If[MemberQ[$ApplicationSymbolsWithUsage, a], ButtonBox[a, BaseStyle -> "Link", 
                                                                ButtonData -> "paclet:" <> $LinkBase <> "/ref/" <> a], a], m, Cell[b, "TableText", c]})//.
   {{RowBox[RowBox[a_]], b_, Cell[c_, "TableText", d___]} :> {RowBox[a], b, Cell[c, "TableText", d]},
    {RowBox[RowBox[a_]], Cell[b_, "TableText", c___]} :> {RowBox[a], Cell[b, "TableText", c]}}) //.
   {{RowBox[Cell[a__]], b_, Cell[c_, "TableText", d___]} :> {Cell[a], b, Cell[c, "TableText", d]},
    {RowBox[Cell[a__]], Cell[b_, "TableText", c___]} :> {Cell[a], Cell[b, "TableText", c]}})/.
    Cell[TextData[{a___,
                   Cell[BoxData[Cell[TextData[{b___, Cell[BoxData[FormBox[c_List, TraditionalForm]]], d___}]]], "InlineFormula"], e___}], "TableText"] :> 
 Cell[TextData[{a, b, Cell[BoxData[FormBox[RowBox[c], TraditionalForm]], "InlineFormula"], d, e}], "TableText"])/.Cell[BoxData[GridBox[c_, g___]], e__] :> 
 Cell[BoxData[GridBox[MapAt[If[MatchQ[#, Cell[_]], Insert[#, "TableText", 2], #] &, #, -1] & /@ c, g]], e],
 ce]]
 
GenerateTransformedTable::noin = "There is no input notebook.";
GenerateTransformedTable::betwcells = "The cursor is between cells or not inside an input notebook.";
GenerateTransformedTable::mulcell = "Multiple cells have been selected.";
GenerateTransformedTable::notdefbox = "The cell does not have the style \"DefinitionBox\" or \"DefinitionBox3Col\".";
GenerateTransformedTable::nottable = "The cell does not have a table of the correct structure.";
GenerateTransformedTable::$ApplicationNamenotset = "$ApplicationName needs to be set.";
GenerateTransformedTable::$LinkBasenotset = "$LinkBase needs to be set.";
GenerateTransformedTable::failure = "Unable to load the package specified by $LinkBase.";

$SystemSymbolExceptions = {}
$TableCell = None
$OldTableCell = None

GenerateTransformedTable[] := 
 Module[{nb = InputNotebook[], ci, i, style, ce, cellid, cellid1, nb1, nb2}, 
  Catch[If[(* There is no input notebook. *)nb === $Failed, Throw[MessageToConsole[GenerateTransformedTable::noin]]]; 
        ci = CellInfo[nb];
        If[(* The cursor is between cells or not inside an input notebook. *)ci === $Failed, 
           Throw[MessageToConsole[GenerateTransformedTable::betwcells]]];
        If[multipleCellBracketsSelected[ci], Throw[MessageToConsole[GenerateTransformedTable::mulcell]]]; 
        If[Cases[ci, a : ("InlineCellPosition" -> _), Infinity] =!= {}, 
           i=1; While[(* The cursor is in an inline cell. *)
                      i < 1000 && Cases[ci, a : ("InlineCellPosition" -> _), Infinity] =!= {}, 
                      FrontEndExecute[{FrontEnd`FrontEndToken[nb, "ExpandSelection"]}];
                      ci = CellInfo[nb];
                      i++]];
   style = If[ListQ[#], #[[1]], #] &[("Style" /. CellInfo[nb])[[1]]];
   If[(* The cursor is not in a 2 or 3 column definition box. *)Not@MemberQ[{"DefinitionBox", "DefinitionBox3Col"}, style], 
      Throw[MessageToConsole[GenerateTransformedTable::notdefbox]]]; 
   SelectionMove[nb, All, Cell];
   ce = NotebookRead[nb]; 
   If[Not@MatchQ[ce /. FormBox[a_, _] :> a, Cell[BoxData[GridBox[{{_, _} .. | {_, _, _} ..}, ___]], ___]], 
      Throw[MessageToConsole[GenerateTransformedTable::nottable]]]; 
   If[(* $ApplicationName is not set. *)StringMatchQ[$ApplicationName, "" | Whitespace], 
      Throw[MessageToConsole[GenerateTransformedTable::$ApplicationNamenotset]]];
   If[(* $LinkBase is not set. *)StringMatchQ[$LinkBase, "" | Whitespace], 
      Throw[MessageToConsole[GenerateTransformedTable::$LinkBasenotset]]];
   $OldTableCell = ce;
   cellid = Options[NotebookSelection[nb], CellID][[1, 2]];
   $Old$Path = $Path;
   If[StringQ[$ApplicationDirectory] && FileType[$ApplicationDirectory] === Directory && Not@MemberQ[$Path, $ApplicationDirectory], 
      AppendTo[$Path, $ApplicationDirectory]];
   $PresentBeginTime = Round[AbsoluteTime[]];
   $LoadApplicationNotebook = NotebookPut[Notebook[{}, Visible -> False, 
      NotebookDynamicExpression :> Refresh[Catch[If[Round[AbsoluteTime[]] > $PresentBeginTime + 1, 
          Which[(* The package does not exist or has the wrong structure. *)
                Not[MemberQ[$Packages, $ApplicationName <> "`"] || MemberQ[$Packages, x_String /; StringMatchQ[x, $ApplicationName <> "`*`"]]], 
                Throw[MessageToConsole[GenerateTransformedTable::failure]; 
                      NotebookClose[];
                      $Path = $Old$Path], 
                Not@MemberQ[$ContextPath, $ApplicationName <> "`"], $ApplicationLoadPalette[];
                NotebookClose[]]]], 
                                           UpdateInterval -> 1]]];
   Quiet[Needs[$LinkBase <> "`"]];
   If[MemberQ[Notebooks[], $LoadApplicationNotebook], 
      NotebookClose[$LoadApplicationNotebook]];
   If[Not[MemberQ[$Packages, $ApplicationName <> "`"] || MemberQ[$Packages, x_String /; StringMatchQ[x, $ApplicationName <> "`*`"]]], 
      Throw[MessageToConsole[GenerateTransformedTable::failure];
            $Path = $Old$Path]];
   $ApplicationSymbolsWithUsage = SymbolsWithUsage[$ApplicationName]; 
   nb2 = NotebookPut[Notebook[{Cell["If the transformed table is as desired, click the first button to overwrite the table in the original notebook. If you want to revert the change, click the second button.",
                              "Text", FontSize -> 14], 
                         Cell[BoxData[GridBox[{{ButtonBox["Insert Transformed Table", 
                                                           Appearance -> {Automatic, "DialogBox"}, 
                                                           ButtonFunction :> DocumentationTools`InsertTransformedTable[nb1, cellid1], 
                                                           Active -> True, Evaluator -> Automatic, Method -> "Queued"], 
                                                ButtonBox["Revert",
                                                           Appearance -> {Automatic, "DialogBox"}, 
                                                           ButtonFunction :> DocumentationTools`RevertTransformedTable[nb1, cellid1], 
                                                           Active -> True, Evaluator -> Automatic,
                                                           Method -> "Queued"]}}] /.{nb1 -> nb, cellid1 -> cellid}], "Text"], 
                         $TableCell = UniformizeTableCell[ce, $ApplicationName, $LinkBase, $SystemSymbolExceptions]}, 
                        WindowTitle -> "Regularize Table Preview",
                        WindowSize -> {689, Automatic},
                        StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "TutorialPageStyles.nb"]]];
   SetOptions[nb2, ScrollingOptions -> {"VerticalScrollRange" -> Automatic}]]]
                        
InsertTransformedTable::notebookclosed = "The tutorial containing the original table has closed.";
InsertTransformedTable::tablene = "The original table cell no longer exists.";
InsertTransformedTable::betwcells = "The cursor is between cells or not inside an input notebook.";
InsertTransformedTable::mulcell = "Multiple cells have been selected.";
InsertTransformedTable::notdefbox = "The cell does not have the style \"DefinitionBox\" or \"DefinitionBox3Col\".";

InsertTransformedTable[nb_, cellid_]:=
 Module[{ci, i, style},
 Catch[If[Not[MemberQ[Notebooks[], nb]],
          Throw[MessageToConsole[InsertTransformedTable::notebookclosed]; NotebookClose[]],
          SetSelectedNotebook[nb]];
       If[cellid =!= 0 && NotebookFind[nb, cellid, All, CellID] === $Failed,
          Throw[MessageToConsole[InsertTransformedTable::tablene]; NotebookClose[]]];
       If[cellid =!= 0, NotebookWrite[nb, $TableCell, All],
          ci = CellInfo[nb];
          If[(* The cursor is between cells or not inside an input notebook. *)ci === $Failed, 
             Throw[MessageToConsole[InsertTransformedTable::betwcells]]];
          If[multipleCellBracketsSelected[ci], Throw[MessageToConsole[InsertTransformedTable::mulcell]]]; 
          If[Cases[ci, a : ("InlineCellPosition" -> _), Infinity] =!= {}, 
             i=1; While[(* The cursor is in an inline cell. *)
                        i < 1000 && Cases[ci, a : ("InlineCellPosition" -> _), Infinity] =!= {}, 
                        FrontEndExecute[{FrontEnd`FrontEndToken[nb, "ExpandSelection"]}];
                        ci = CellInfo[nb];
                        i++];
             SelectionMove[nb, All, Cell]];
          style = If[ListQ[#], #[[1]], #] &[("Style" /. CellInfo[nb])[[1]]];
          If[(* The cursor is not in a 2 or 3 column definition box. *)Not@MemberQ[{"DefinitionBox", "DefinitionBox3Col"}, style], 
             Throw[MessageToConsole[InsertTransformedTable::notdefbox]]]; 
          NotebookWrite[nb, $TableCell, All]]]]
          
RevertTransformedTable::notebookclosed = "The tutorial containing the original table has closed.";
RevertTransformedTable::tablene = "The original table cell no longer exists.";
RevertTransformedTable::betwcells = "The cursor is between cells or not inside an input notebook.";
RevertTransformedTable::mulcell = "Multiple cells have been selected.";
RevertTransformedTable::notdefbox = "The cell does not have the style \"DefinitionBox\" or \"DefinitionBox3Col\".";
          
RevertTransformedTable[nb_, cellid_]:=
 Module[{ci, i, style},
 Catch[If[Not[MemberQ[Notebooks[], nb]],
          Throw[MessageToConsole[RevertTransformedTable::notebookclosed]; NotebookClose[]],
          SetSelectedNotebook[nb]];
       If[cellid =!= 0 && NotebookFind[nb, cellid, All, CellID] === $Failed,
          Throw[MessageToConsole[RevertTransformedTable::tablene]; NotebookClose[]]];
       If[cellid =!= 0, NotebookWrite[nb, $OldTableCell, All],
          ci = CellInfo[nb];
          If[(* The cursor is between cells or not inside an input notebook. *)ci === $Failed, 
             Throw[MessageToConsole[RevertTransformedTable::betwcells]]];
          If[multipleCellBracketsSelected[ci], Throw[MessageToConsole[RevertTransformedTable::mulcell]]]; 
          If[Cases[ci, a : ("InlineCellPosition" -> _), Infinity] =!= {}, 
             i=1; While[(* The cursor is in an inline cell. *)
                        i < 1000 && Cases[ci, a : ("InlineCellPosition" -> _), Infinity] =!= {}, 
                        FrontEndExecute[{FrontEnd`FrontEndToken[nb, "ExpandSelection"]}];
                        ci = CellInfo[nb];
                        i++];
             SelectionMove[nb, All, Cell]];
          style = If[ListQ[#], #[[1]], #] &[("Style" /. CellInfo[nb])[[1]]];
          If[(* The cursor is not in a 2 or 3 column definition box. *)Not@MemberQ[{"DefinitionBox", "DefinitionBox3Col"}, style], 
             Throw[MessageToConsole[RevertTransformedTable::notdefbox]]]; 
          NotebookWrite[nb, $OldTableCell, All]]]]
    
UniformizeTextCell[ce_Cell, applicationname_, linkbase_] := 
 Module[{c, li}, 
  Which[MatchQ[ce, Cell[_String, "Text", ___]],
  
        c = ConvertStringToListWithBasicButtons[ce[[1]], applicationname, linkbase]; 
        If[StringQ[c], ce, ReplacePart[ce, 1 -> TextData[c]]],
        
        MatchQ[ce, Cell[TextData[{__}], __]], 
        li = If[StringQ[#], ConvertStringToListWithBasicButtons[#, applicationname, linkbase], #] & /@ ce[[1, 1]]; 
        If[li === ce[[1, 1]], ce, ReplacePart[ce, {1, 1} -> Flatten[li]]],
        
        True, 
        ce]]

$ApplicationTutorialTableTypes = {"DefinitionBox3Col", "DefinitionBox"};

ClearFormattingInTables[nb_] := 
 Module[{gopts}, 
  SetOptions[$FrontEnd, (Options[$FrontEnd, FindSettings] /. ("Wraparound" -> True) -> ("Wraparound" -> False))[[1]]];
  (SelectionMove[nb, Before, Notebook]; 
     While[NotebookFind[nb, #, Next, CellStyle] =!= $Failed, 
      If[(gopts = Cases[Take[NotebookRead[nb], {2, -1}], 
                        a : (GridBoxOptions -> _)] /. (GridBoxOptions -> {gbo__}) :> If[FreeQ[{gbo}, GridBoxDividers -> _] || 
                        (Not@FreeQ[{gbo}, GridBoxDividers -> _] && Union@Flatten[GridBoxDividers /. {gbo}] === {False}), 
          Unevaluated[Sequence[]], GridBoxOptions -> {GridBoxDividers -> (GridBoxDividers /. {gbo})}]) =!= {}, gopts = gopts[[1]], gopts = {}]; 
      FrontEndExecute[FrontEndToken[nb, "ClearCellOptions"]]; 
      If[gopts =!= {}, 
       SetOptions[NotebookSelection[nb], gopts]]]) & /@ $ApplicationTutorialTableTypes;
  SetOptions[$FrontEnd, (Options[$FrontEnd, FindSettings] /. ("Wraparound" -> False) -> ("Wraparound" -> True))[[1]]]]
  
ClearFormattingInTextCells[nb_] := 
 (SetOptions[$FrontEnd, (Options[$FrontEnd, FindSettings] /. ("Wraparound" -> True) -> ("Wraparound" -> False))[[1]]];
  (SelectionMove[nb, Before, Notebook]; 
   While[NotebookFind[nb, "Text", Next, CellStyle] =!= $Failed, FrontEndExecute[FrontEndToken[nb, "ClearCellOptions"]]]);
  SetOptions[$FrontEnd, (Options[$FrontEnd, FindSettings] /. ("Wraparound" -> False) -> ("Wraparound" -> True))[[1]]])
  
StylesNotInStyleSheet[filepath_String /; FileType[filepath] === File, stylesheetpath_String /; FileType[stylesheetpath] === File] := 
 Quiet@Module[{nbsstyles, cs}, 
   nbsstyles = Cases[Get[filepath], a : Cell[b_ /; FreeQ[b, CellGroupData], __] | StyleBox[_, __] :> If[StringQ[a[[2]]], a[[2]], Unevaluated[Sequence[]]], 
                     Infinity]; 
   cs = Cases[Get[stylesheetpath], Cell[StyleData[a_ /; a =!= All, ___], __] :> a, Infinity]; 
   Union@Complement[nbsstyles, cs]]
   
StylesInStyleSheets[stylesheets : {_?(StringQ[#] && FileType[#] === File &) ..}] := 
 Union[Flatten[Cases[Get[#], 
                     Cell[StyleData[a_ /; a =!= All, ___], __] :> If[StringQ[a], a, Unevaluated[Sequence[]]], Infinity] & /@ stylesheets]]
                     
StylesInNotebook[filepath_String /; FileType[filepath] === File] := 
Union@Cases[Get[filepath], a : Cell[b_ /; FreeQ[b, CellGroupData], __] | StyleBox[_, __] :> If[StringQ[a[[2]]], a[[2]], Unevaluated[Sequence[]]], Infinity]
   
GenerateNotebookWithLinksToCellsContainingUndefinedStyles::def$DocuToolsDir = "$DocuToolsDir should be set to the installation directory for the DocumentationTools package.";
  
GenerateNotebookWithLinksToCellsContainingUndefinedStyles[dir_String /; FileType[dir] === Directory] := 
 Module[{data, siss, data2, gt, data3, dir1, r},
  Catch[If[Not@StringQ[$DocuToolsDir] ||
           FileType[$DocuToolsDir] =!= Directory ||
           Not[StringReplace[$DocuToolsDir, DirectoryName[$DocuToolsDir] -> ""] === ToFileName["DocumentationTools"]] ||
           Not[MemberQ[FileNames["*.nb", {$DocuToolsDir}, Infinity], ToFileName[{$DocuToolsDir, "FrontEnd", "StyleSheets", "Wolfram"}, "TutorialPageStyles.nb"]]], 
           Throw[MessageToConsole[GenerateNotebookWithLinksToCellsContainingUndefinedStyles::def$DocuToolsDir]]];
           
  siss = StylesInStyleSheets[{ToFileName[{$DocuToolsDir, "FrontEnd", "StyleSheets", "Wolfram"}, "TutorialPageStyles.nb"], 
                              ToFileName[{$InstallationDirectory, "SystemFiles", "FrontEnd", "StyleSheets"}, "Core.nb"]}];
                              
  data = DeleteCases[{#, Complement[StylesInNotebook@#, siss]} & /@ FileNames["*.nb", {dir}], {_, {}}];
  
  $UndefinedStyleData = data;
  $Undefinedstyles = Union[Flatten[Last /@ data]];
  
  If[data =!= {},
  
   data2 = {#[[1]], 
            (gt = Get[#[[1]]]; 
             {#, Flatten@Cases[gt, x_Cell /; FreeQ[x, CellGroupData] && Not@FreeQ[x, Cell[_, #, ___] | StyleBox[_, #, ___], {0, Infinity}] :> 
              Cases[x, a : (CellID -> b_) :> b], Infinity]} & /@ #[[2]])} & /@ data; 
   data3 = Split[SortBy[Flatten[#[[2]] /. {a_String, b_} :> {#[[1]], a, b} & /@ data2, 1], #[[2]] &], #[[2]] === #2[[2]] &] /. 
                                                                     t : {{_String, s_String, _} ..} :> {s, t /. a : {_String, _, _} :> {a[[1]], a[[3]]}}; 
   Notebook[{Cell["Undefined Styles", "Title"],
             Cell["This notebook is saved in the same directory as the new tutorials which have been created. The directory may be moved and the hyperlinks here will continue to work. However if this notebook is moved out to a different directory, then the hyperlinks will no longer function properly.", "Text", FontFamily->"Verdana", FontSize->11],
             Cell["Styles, tutorials and corresponding cells containing undefined styles for the tutorials in:", "Text", FontFamily->"Verdana", FontSize->11],
             Cell[dir, "Text", FontFamily->"Verdana", FontSize->11],
             Cell["Undefined styles may be at the level of an entire cell, an inline cell or in a style box.", "Text", FontFamily->"Verdana", FontSize->11],
             Cell[TextData[{Cell[BoxData[ButtonBox[RowBox[{"Style", " ", "Substitutions"}],
	                                           Appearance->Automatic, Active->True, Evaluator->Automatic, Method->"Preemptive",
	                                           (ButtonFunction:>UndefinedStyleReplacementsDialog[dir1])/.dir1->dir]], "Text"],
	                    " Style replacement wizard"}], "Text", FontFamily->"Verdana", FontSize->11],
             Sequence @@ (Cell[BoxData[ToBoxes[#]], If[Head@# === Style, "Section", "Text"], ShowStringCharacters -> False] & /@ 
    Flatten[{Style["Style: " <> #[[1]], "Section"], 
            Grid[List/@ Flatten[Function[t, (u = StringReplace[#, DirectoryName[#] -> ""] &[t[[1]]];
                         Button[StringReplace[t[[1]], DirectoryName[t[[1]]] -> ""] <> ": CellID: " <> ToString[#], 
                                NotebookFind[NotebookOpen[ToFileName[{ParentDirectory@NotebookDirectory[EvaluationNotebook[]]}, r]], #, All, CellID],
                                Method -> "Queued", ImageSize -> Inherited] /. r -> u) & /@ 
          t[[2]]] /@ #[[2]]]]} & /@ data3])}, ShowCellBracket -> Automatic, Deletable -> False, Editable -> False, Selectable -> False],
          
     {}]]]
     
 PossibleTutorialPageStyleReplacements[] := 
  Module[{file = ToFileName[{$DocuToolsDir, "FrontEnd", "StyleSheets", "Wolfram"}, "TutorialPageStyles.nb"], fl}, 
   If[FileType@file === File, 
      fl = Flatten@Cases[Get@file, r : Cell[CellGroupData[{Cell["Tutorial Page Styles", "Section", ___], __}, _]] :> 
        Cases[DeleteCases[r, Cell[CellGroupData[{Cell["Definition Boxes and Other Highlighting Styles" | "Overview TOC Styles", 
                                                      "Subsection", ___], __}, _]], Infinity], 
                         Cell[StyleData[a_ /; a =!= All], __] :> a, Infinity], Infinity]; 
      Take[fl, {Position[fl, "Title"][[1, 1]], -1}], 
      {}]]
      
ReplaceStyles::notdef = "No style replacements have been defined.";

ReplaceStyles[] := 
 Module[{stylereplacements = Cases[Rule @@@ Transpose[{$Undefinedstyles, Last /@ $UndefinedStyleDialogData}], s : (_ -> _String)], gt}, 
  If[stylereplacements === {}, 
     MessageToConsole[ReplaceStyles::notdef], 
     If[Intersection[First /@ stylereplacements, #[[2]]] =!= {}, 
        gt = (Get[#[[1]]] /. (RuleDelayed @@ (StyleBox[a_, #[[1]], o1___] -> StyleBox[a, #[[2]], o1]) & /@ stylereplacements)) /. 
                          (RuleDelayed @@ (Cell[b_, #[[1]], o2___] -> Cell[b, #[[2]], o2]) & /@ stylereplacements); Put[gt, #[[1]]]] & /@ $UndefinedStyleData]]
        
prebutton[st_, i_, styles_] := 
 Dynamic[If[$ButtonNumber > 0 && $UndefinedStyleDialogData[[i, 2]] === 1, 
            Framed[#, FrameMargins -> 1], #] &@Button[Dynamic[If[(* If a defined style is specified for this undefined style button label. *)
                                                                 $ButtonNumber > 0 && StringQ[$UndefinedStyleDialogData[[i, 3]]], 
                                                                 st <> " \[Rule] " <> $UndefinedStyleDialogData[[i, 3]], 
                                                                 st]], 
                                                      $ButtonNumber = i; 
                                                      $UndefinedStyleDialogData[[All, 2]] = 0; 
                                                      $UndefinedStyleDialogData[[i, 2]] = 1; 
                                                      $ButtonNumber2 = 0, 
                                                      BaseStyle -> "Hyperlink", Appearance -> "Frameless", 
                                                      Active -> True, Evaluator -> Automatic]]
                                                      
prebutton2[st_, i_, styles_] := 
 Button[st, 
        $ButtonNumber2 = i; 
        If[(* One of the undefined style buttons is highlighted. *)
           $ButtonNumber > 0,
           (* Assign the style specified by the defined style button lable to the last element of the $ButtonNumber of $UndefinedStyleDialogData *)
           $UndefinedStyleDialogData[[$ButtonNumber, 3]] = styles[[$ButtonNumber2]]],
        BaseStyle -> "Hyperlink", Appearance -> "FramedPalette", Active -> True]
        
UndefinedStyleReplacementsDialog[dir_String /; FileType[dir] === Directory] := 
 Module[{len, potentialreplacementstyles, len2}, 
        len = Length@$Undefinedstyles; 
        potentialreplacementstyles = PossibleTutorialPageStyleReplacements[]; 
        len2 = Length@potentialreplacementstyles; 
        $ButtonNumber = 0; $ButtonNumber2 = 0; $UndefinedStyleDialogData = {#, 0, 0} & /@ Range@len; 
  CreateDialog[Column[{Style["Select an undefined style:", Bold], 
                       Panel[Column[{Pane[Column[prebutton[#[[1]], #[[2]], potentialreplacementstyles] & /@ 
                                  Transpose[{$Undefinedstyles, Range@len}]], ImageSize -> {400, 100}, Scrollbars -> True, AppearanceElements -> None]}], 
                             BaseStyle -> {Background -> White}], 
                       Style["Select a replacement style:", Bold], 
                       Panel[Column[{Pane[Grid[Prepend[Transpose[{prebutton2[#[[1]], #[[2]], potentialreplacementstyles] & /@ 
                                                                                                       Transpose[{potentialreplacementstyles, Range@len2}], 
                                                                  Table[Style["This is an example", potentialreplacementstyles[[i]]], {i, len2}]}], 
                                                       Style[#, Bold, GrayLevel[.4]] & /@ {"Style", "Appearance"}], 
                                               Alignment -> {{Center, Left}, Automatic}], 
                                          ImageSize -> {400, 200}, Scrollbars -> True, AppearanceElements -> None]}], 
                             BaseStyle -> {Background -> White}], 
                             OpenerView[{" Processing Directory", TextCell[dir, ParagraphIndent -> 0]}], 
                       Row[{DefaultButton[ReplaceStyles[];
                                          NotebookClose[EvaluationNotebook[]];
                                          Clear[$ButtonNumber, $ButtonNumber2];
                                          CreateWindow[MessageDialog["The style replacements have been made.", 
                                                                     WindowFloating -> True, WindowFrame -> "Palette", WindowFrameElements -> {}]]], 
                            CancelButton[NotebookClose[EvaluationNotebook[]]; Clear[$ButtonNumber, $ButtonNumber2]]}]}, 
                      Spacings -> {Automatic, {3 -> 2, 5 -> 1, 6 -> 1}}], 
               StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "TutorialPageStyles.nb", CharacterEncoding -> "WindowsANSI"], 
               WindowFrame -> "Palette", 
               WindowElements -> {}, 
               WindowFrameElements -> {}, 
               ShowCellBracket -> False, 
               ClosingAutoSave -> False, 
               Saveable -> False, 
               WindowTitle -> "Style Substitutions", 
               WindowSize -> {480, FitAll}, 
               Editable -> False, 
               Selectable -> False]]

TutorialDivider[Source_String, 
                OutputDirectory_String, 
                tutorialDivider_String, opts___] := 
 Module[{
          gt, files, SourceDirectory, nb, stripSectionNumbering, retainOriginalTableFormatting, retainOriginalTextCellFormatting, a,
          stylereplacements, Pairs, SameHeadingsData, f, fp, pnb, pairs, an, ext,
          files2, mo, ea, pnb2, NewTutorialsInOrder, fl, cs, title, cells, nb2, gn, nb3, del, cflabels, ff, rpd, rpf
        },
  Quiet[stripSectionNumbering = StripSectionNumbering /. {opts} /. Options[TutorialDivider];
        retainOriginalTableFormatting = RetainOriginalTableFormatting /. {opts} /. Options[TutorialDivider];
        retainOriginalTextCellFormatting = RetainOriginalTextCellFormatting /. {opts} /. Options[TutorialDivider];
      If[FileType[Source] === Directory, 
         SourceDirectory = Source; 
       files = DeleteCases[FileNames["*.nb", {SourceDirectory}], x_String/;StringMatchQ[StringReplace[x, DirectoryName[x] -> ""], 
                                                                                        "*Overview*" | "*UndefinedStyles*", 
                                                                                        IgnoreCase -> True]]];
 Catch[If[FileType[Source] =!= Directory && FileType[Source] =!= File, 
          Throw[MessageToConsole[TutorialDivider::firstarg]]];
       If[ValueQ[files] && files === {}, Throw[MessageToConsole[TutorialDivider::emptysourcedir]]];
       If[Not@StringMatchQ[OutputDirectory, ___~~("Tutorials" | ("Tutorials" ~~ $PathnameSeparator))], 
          Throw[MessageToConsole[TutorialDivider::nottutorialsdir]]];
   If[$StyleReplacements =!= {} && Not@VectorQ[$StyleReplacements, MatchQ[#, _String -> _String] &], 
      Throw[MessageToConsole[TutorialDivider::stylereplacementsform]]];
      
   (* Getting all the nbs in $SourceDirectory and processing them may take a noticeable amount of time so put up a progress
      indicator to show that nbs are being processed. Similarly for a single notebook being processed. *)
      
   pnb = CreatePalette[ProgressIndicator[Dynamic[Clock[Infinity]], Indeterminate, ImageSize -> {250, 30}], 
          WindowMargins -> Automatic, WindowTitle -> "DivideTutorials is processing notebooks.", WindowSize -> {250, Fit}];
          
   (* pairs has the form {{tutorial path, CellGroupData[{Cell[_, tutorialDivider, ___], __}, Open]}, ..}. A given tutorial will many times have more than
      one instance of CellGroupData[{Cell[_, tutorialDivider, ___], __}, Open] so Length[pairs] > number of tutorials before division. *)
   
   pairs = {}; 
   an = (Function[t, gt = Get[t];
   
          If[Not@FreeQ[gt, Cell[_, a_ /; MemberQ[{"History", "CategorizationSection", "Categorization", "KeywordsSection", "Keywords", "DetailsSection",
                                                  "Details", "TutorialMoreAboutSection", "TutorialMoreAbout", "RelatedTutorialsSection",
                                                  "RelatedTutorials", "TutorialRelatedLinksSection", "TutorialRelatedLinks"}, a], ___]], 
             Throw[NotebookClose[pnb];
                   MessageToConsole[TutorialDivider::notpriorsix]]];
          
          (Union[Head[ext = Extract[gt, #]; AppendTo[pairs, {t, ext}]; ext] & /@ (Drop[#, -2] & /@ 
          Position[gt, Cell[_, tutorialDivider, ___], Infinity])] === {CellGroupData})] /@ If[ValueQ[files], files, {Source}]);
          
   SameHeadingsData = Cases[Split[Sort[Reverse /@ Cases[pairs, {a_String, CellGroupData[{Cell[b_, tutorialDivider, ___], ___}, Open]} :> 
         {StringReplace[a, DirectoryName[a] -> ""], 
          StringReplace[StringReplace[StringReplace[If[stripSectionNumbering, StringReplace[#, {NumberString ~~ " " -> "", 
                                                           ((NumberString ~~ ".") ..) ~~ NumberString ~~ " " -> ""}], #] &[
    Which[StringQ@b, 
          b, 
          Head@b === TextData && Union[MatchQ[#, _String | StyleBox[_String, __]] & /@ (b[[1]] /. CounterBox[_] -> Sequence[])] === {True}, 
          StringJoin @@ (b /. {StyleBox[c_String, __] :> c, CounterBox[_] -> Sequence[]})[[1]], 
          MatchQ[b, TextData[StyleBox[_String, __]]], b[[1, 1]], 
          True, 
          StringJoin @@ Cases[b /. CounterBox[_] -> Sequence[], _String, {0, Infinity}]]], 
                                                    StartOfString ~~ "." ~~ (" " | "") .. -> ""], 
                                      WordBoundary ~~ x_ :> ToUpperCase[x]], 
                        {" " -> "", "_" -> "-", ":" -> "", "," -> "", "\t" -> "", "\n" -> ""}]}]], 
                                  #1[[1]] === #2[[1]] &], x_ /; Length@x > 1];
                                  
   If[(* One or more divider headings occurs more than once among the tutorials being processed. *)
      SameHeadingsData =!= {}, 
      Throw[MessageToConsole[TutorialDivider::identicalheadings, ToString[{#[[1, 1]], Last /@ #} & /@ SameHeadingsData]];
            NotebookClose[pnb]]];
          
   If[And @@ an,
      
     If[ValueQ[files]
       && $OutputDirectory === ToFileName[{$SourceDirectory, "Tutorials"}]
       && FileType[$OutputDirectory] === None, 
                                                        CreateDirectory[$OutputDirectory]];
     If[FileType[Source] === File
       && FileType[ToFileName[{DirectoryName[Source], "Tutorials"}]] === None, 
        $OutputDirectory = ToFileName[{DirectoryName[Source], "Tutorials"}];
        CreateDirectory[$OutputDirectory]];
     If[$StyleReplacements =!= {},
        stylereplacements = Flatten[{RuleDelayed @@ (Cell[a_, #[[1]], b___] -> Cell[a, #[[2]], b]), 
        RuleDelayed @@ (StyleBox[a_, #[[1]], b___] -> StyleBox[a, #[[2]], b])} & /@ $StyleReplacements]];
     (* Pairs of file paths to save new nbs in and corresponding content. *)  
     Pairs = ((With[{e = StringReplace[If[stripSectionNumbering, 
                                          StringReplace[#, {NumberString ~~ " " -> "", 
                                          ((NumberString ~~ ".") ..) ~~ NumberString ~~ " " -> ""}], #] &[(a = #[[2, 1, 1, 1]]; 
        Which[StringQ@a, 
              a, 
              Head@a === TextData && Union[MatchQ[#, _String | StyleBox[_String, __]] & /@ (a[[1]] /. CounterBox[_] -> Sequence[])] === {True}, 
              StringJoin @@ (a /. {StyleBox[b_String, __] :> b, 
              CounterBox[_] -> Sequence[]})[[1]], 
              MatchQ[a, TextData[StyleBox[_String, __]]], 
              a[[1, 1]], 
              True, 
              StringJoin @@ Cases[a /. CounterBox[_] -> Sequence[], _String, {0, Infinity}]])], 
                                       StartOfString ~~ "." ~~ (" " | "") .. -> ""]}, 
                    f = StringReplace[StringReplace[e, WordBoundary ~~ x_ :> ToUpperCase[x]], 
                                      {" " -> "", "_" -> "-", ":" -> "", "," -> "", "\t" -> "", "\n" -> ""}];
                    {OutputDirectory <> f <> "-" <> StringReplace[#[[1]], If[ValueQ[files], SourceDirectory, DirectoryName[Source]] -> ""], 
                        ReplacePart[#[[2]], {1, 1, 1} -> StringReplace[e, {"\t" -> "", "\n" -> ""}]]}] & /@ pairs) /. 
     {a_String, b_} :> {a, If[$StyleReplacements === {}, b /. $TutorialDivider -> "Title", (b /. $TutorialDivider -> "Title") /. stylereplacements]}) /.
     Cell[a_, s_String /; StringMatchQ[s, "*Section*" | "*Subsection*" | "*Subsubsection*"], b___] :> 
     Cell[a, StringReplace[s, {___ ~~ "Section" ~~ ___ -> "Section", 
                               ___ ~~ "Subsection" ~~ ___ -> "Subsection", 
                               ___ ~~ "Subsubsection" ~~ ___ -> "Subsubsection"}], b];
     
     fp = First /@ Pairs;
     If[(* Removing the appended file name does not result in file name collisions. *)
        Length[Union[StringReplace[#, Longest[a__] ~~ "-" ~~ __ ~~ ".nb" :> a ~~ ".nb"] & /@ fp]] === Length[fp],
        Pairs = Pairs /. {a_String, b_} :> {StringReplace[a, Longest[c__] ~~ "-" ~~ __ ~~ ".nb" :> c ~~ ".nb"], b}];
           
     If[stripSectionNumbering, 
        Pairs = Pairs /. {a_String, b_} :> 
                          {a, b /. Cell[d_String, s : ("Section" | "Subsection" | "Subsubsection"), e___] :> 
                              Cell[StringReplace[d, {NumberString ~~ " " -> "", 
                                                     ((NumberString ~~ ".") ..) ~~ NumberString ~~ " " -> ""}], s, e]}];
           
     (* The processing of the notebooks has been completed so close the progress indicator before generating the new
        notebooks. *)
        
     NotebookClose[pnb];
     
     files2 = FileNames["*.nb", {OutputDirectory}];
     
     If[Intersection[files2, First/@Pairs] =!= {}, Throw[MessageToConsole[TutorialDivider::overwrite]]];
     
     (* Older docs need CellIDs added. Some styles in source notebooks may not be defined in the Tutorials style sheet so
       turn off "ErrorAction" *)
       
     mo = MessageOptions /. Options[$FrontEnd];
     ea = "ErrorAction" /. mo;
     SetOptions[$FrontEnd, MessageOptions -> (mo /. ("ErrorAction" -> _) -> ("ErrorAction" -> {}))];
     
     (* Have another progress indicator run while new versions of tutorial notebooks are being created. *)
     
     (* pnb2 = CreatePalette[ProgressIndicator[Dynamic[Clock[Infinity]], Indeterminate, ImageSize -> {250, 30}], WindowMargins -> Automatic, 
                          WindowTitle -> "DivideTutorials is processing notebooks.", WindowSize -> {250, Fit}]; *)
                          
     (* There might be a bug in Mathematica so changing pnb2 for now. *)                     
                          
      pnb2 = NotebookPut@
       Notebook[{Cell["The tutorials are being processed.", "NotebookDefault", "DialogStyle", "ControlStyle", FontSize -> 20]}, 
                ClosingAutoSave -> False, Editable -> False, 
                Saveable -> False, WindowToolbars -> {}, Evaluator -> "Local", 
                Selectable -> False, WindowSize -> {350, FitAll}, 
                WindowFrame -> "Palette", WindowElements -> {}, 
                WindowFrameElements -> {}, WindowFloating -> True, 
                WindowTitle -> None, 
                ScrollingOptions -> {"VerticalScrollRange" -> Fit}, 
                PrivateNotebookOptions -> {"FileOutlineCache" -> False}, 
                ShowCellBracket -> False, CellMargins -> {{8, 8}, {8, 8}}, 
                ImageMargins -> {{0, 0}, {0, 0}}];
     
     (nb = CreateWindow[StyleDefinitions ->FrontEnd`FileName[{"Wolfram"}, "TutorialPageStyles.nb"]];
     
     (* ReformattingFunction := 
       Which[Not@retainOriginalTableFormatting || Not@retainOriginalTextCellFormatting, 
        (# /. c : Cell[_, x_ /; StringMatchQ[x, Alternatives @@ $AcceptableTableStyles], ___] :> UniformizeTableCell[c, DocumentationTools`$ApplicationName, DocumentationTools`$LinkBase]) /. 
                                                                             ce : Cell[a_String, "Text", ___] :> UniformizeTextCell[ce, DocumentationTools`$ApplicationName, DocumentationTools`$LinkBase], 
             Not@retainOriginalTableFormatting, 
             # /. c : Cell[_, x_ /; StringMatchQ[x, Alternatives @@ $AcceptableTableStyles], ___] :> UniformizeTableCell[c, DocumentationTools`$ApplicationName, DocumentationTools`$LinkBase], 
             Not@retainOriginalTextCellFormatting, 
             # /. ce : Cell[a_String, "Text", ___] :> UniformizeTextCell[ce, DocumentationTools`$ApplicationName, DocumentationTools`$LinkBase], 
             True, 
             #] &;
             
      NotebookWrite[nb, ReformattingFunction[{#[[2]] /. {Closed -> Open, (CellGroupingRules -> _) -> Sequence[]}}]]; *)
     
      (* Doing it this way creates cell ids if necessary. *)
      NotebookWrite[nb, {#[[2]] /. {Closed -> Open, (CellGroupingRules -> _) -> Sequence[]}}];
      FixStyleHierarchy[nb];
      SelectionMove[nb, After, Notebook];
      NotebookWrite[nb, TutorialPostDataCells];
      SelectionMove[nb, Before, Notebook];
      NotebookWrite[nb, TutorialMetaDataCells[DocumentationTools`$ApplicationName, DocumentationTools`$LinkBase, StringReplace[#[[1]], {DirectoryName[#[[1]]] -> "", ".nb" -> ""}]]];
      If[Not@retainOriginalTableFormatting, ClearFormattingInTables[nb]];
      If[Not@retainOriginalTextCellFormatting, ClearFormattingInTextCells[nb]];
      
      (*  So that if the tutorials contain initialization cells, the package autosave dialog will not come up. *)
      SetOptions[nb, AutoGeneratedPackage->None];
      NotebookSave[nb, #[[1]]]; NotebookClose[nb]) & /@ Pairs;
      
      SetOptions[$FrontEnd, MessageOptions -> (mo /. ("ErrorAction" -> _) -> ("ErrorAction" -> ea))];
      
      (* Overview creation: *)
      
      NewTutorialsInOrder = #[[1]] &/@ Pairs;
      Quiet[fl = Flatten[(gt = Get[#]; cs = Cases[gt, Cell[_, "Section" | "Subsection" | "Subsubsection", __], Infinity]; 
              title = Cases[gt, Cell[_, "Title", __], Infinity]; 
              cells = Prepend[cs /. OverviewRules[#, DocumentationTools`$LinkBase], 
                 Cell[TextData[ButtonBox[If[title =!= {}, 
                                            title[[1, 1]], 
                                            StringReplace[#, {DirectoryName[#] -> "", ".nb" -> ""}]], BaseStyle -> "Link", 
        ButtonData -> "paclet:" <> DocumentationTools`$LinkBase <> "/tutorial/" <> StringReplace[#, {DirectoryName[#] -> "", ".nb" -> ""}]]], 
               "TOCChapter"]] /. StyleBox[a_, "TB"] :> a) & /@ NewTutorialsInOrder]];
      nb2 = CreateWindow[StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "TutorialPageStyles.nb"]]; 
      NotebookWrite[nb2, Prepend[fl, Cell[DocumentationTools`$LinkBase, "Title"]]];
      NotebookWrite[nb2, TutorialPostDataCells];
      FrontEndExecute[{FrontEndToken[nb, "SelectAll"]}]; 
      FrontEndExecute[{FrontEndToken[nb, "SelectionCloseAllGroups"]}];
      SelectionMove[nb2, Before, Notebook];
      NotebookWrite[nb2, TutorialMetaDataCells[DocumentationTools`$ApplicationName, DocumentationTools`$LinkBase, "Overview"]];
      NotebookSave[nb2, 
        ToFileName[{OutputDirectory}, "Overview.nb"]]; 
      NotebookClose[nb2];
      
      gn = GenerateNotebookWithLinksToCellsContainingUndefinedStyles[OutputDirectory];
      If[gn =!= {} && FileType[rpd = ToFileName[{OutputDirectory, "AuxiliaryMaterial"}]] =!= Directory,
         CreateDirectory[rpd]];
      If[gn =!= {} && (FileType[rpf = ToFileName[{OutputDirectory, "AuxiliaryMaterial"}, "UndefinedStyles.nb"]] === File),
         DeleteFile[rpf]];
      If[gn =!= {}, nb3 = NotebookPut[gn]; NotebookSave[nb3, ToFileName[{OutputDirectory, "AuxiliaryMaterial"}, "UndefinedStyles.nb"]]];
      
     NotebookClose[pnb2];
     CreateWindow[MessageDialog["The tutorials processing has finished.", WindowFloating -> True, WindowFrame -> "Palette", WindowFrameElements -> {}]];
     
     (* The following contains a notebook of unused material if any. For example if $TutorialDivider is "Section", the material in a tutorial
        between the title cell and the first section heading will not get used. *)
     
     del = DeleteCases[{#, Flatten[DeleteCases[Get[#][[1]], Cell[CellGroupData[{Cell[_, $TutorialDivider, ___], ___}, _]], Infinity] //. 
             Cell[CellGroupData[c : {_?(FreeQ[#, CellGroupData] &)..}, _]] :> c]} & /@ 
         If[ValueQ[files], files, {Source}], {_, {}}] /. {s_String /; FileType[s] === File, 
         t : {_Cell ..}} :> (t /. (cflabels = ({{None, Cell[TextData[StyleBox[ButtonBox["Source", 
                                                ButtonFunction :> NotebookOpen[ToFileName[{ ParentDirectory@ParentDirectory@NotebookDirectory[EvaluationNotebook[]]}, ff]], 
                                         Evaluator -> Automatic, Method -> "Queued", BaseStyle->"Title"], 
                 FontColor -> RGBColor[.333, .333, 1]]]]}, {None, None}} /. ff -> StringReplace[s, DirectoryName[s] -> ""]); 
              {Cell[b_, st : ("Title" | "Section" | "Subsection" | "Subsubsection"| "Chapter"), c___] :> Cell[b, st, c, CellFrameLabels -> cflabels,
                                                                                                   FontFamily -> "Helvetica"]}));
     
     If[del =!= {} && FileType[rpd = ToFileName[{$OutputDirectory, "AuxiliaryMaterial"}]] =!= Directory,
        CreateDirectory[rpd]];
     If[del =!= {} && FileType[rpf = ToFileName[{$OutputDirectory, "AuxiliaryMaterial"},"UnusedMaterial.nb"]] === File,
        DeleteFile[rpf]];
     If[del =!= {}, 
        (NotebookSave[#, ToFileName[{$OutputDirectory, "AuxiliaryMaterial"}, "UnusedMaterial.nb"]];
         SelectionMove[#, Before, Notebook]) &[NotebookPut@Notebook[Prepend[Flatten[del], 
    Cell["The following material with links to source notebooks was not used in tutorial construction.", "Text", CellMargins -> {{28, 27}, {14, 40}}]], 
                                                 StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "TutorialPageStyles.nb"], WindowSize -> {675, 750}]]],
     
     (* Processing the notebooks has revealed that one or more cells for the selected heading has no children.
        Close the progress indicator and put up a message. *)
        
     NotebookClose[pnb];
     MessageToConsole[TutorialDivider::heading]]], {Syntax::newl}]]
     
$SourceDirectory = ""

Set$SourceDirectory["Browse"] := 
 If[# =!= Null && # =!= $Canceled, $SourceDirectory = #, Abort[]] &[
  SystemDialogInput["Directory", $DocumentationDirectory, 
   WindowTitle -> "Set Source Directory"]]
   
$OutputDirectory = ""
   
Set$OutputDirectory["Browse"] := 
 If[# =!= Null && # =!= $Canceled, $OutputDirectory = #, Abort[]] &[
  SystemDialogInput["Directory", $DocumentationDirectory, 
   WindowTitle -> "Set Output Directory"]]
   
$TutorialDivider = "Section"

(* ValidHeadingQ determines which cell styles in a notebook expression nbexpr are heads of groups in all occurrences. *)

ValidHeadingQ[heading_String, nbexpr_Notebook] := 
 Module[{positions = Position[nbexpr, Cell[_, heading, ___]]}, 
        If[Count[positions, x_ /; Length[x] < 4] > 0, 
           False, 
           Union[MatchQ[#, Cell[CellGroupData[{Cell[ _, heading, ___], __}, ___]]] & /@ 
                                                                  Extract[nbexpr, Drop[#, -3] & /@ positions]] === {True}]]

DivideTutorials::$LinkBasedef = "$LinkBase must be a non-empty string and be free of backquotes (`)."
DivideTutorials::additionaltutorialdividersectionsform = "$AdditionalTutorialDividerSections must be either the empty list or a list of strings.";
DivideTutorials::emptysourcedir = "The source directory contains no notebooks at its top level.";
DivideTutorials::nouseableheadings = "There are no headings useable as dividers for all notebooks in $SourceDirectory. Note that for a cell style to be considered as a usable heading, all instances must have cells grouped underneath.";
DivideTutorials::nouseableheadings2 = "There are no headings useable as dividers for the input notebook.";
DivideTutorials::directories = "$SourceDirectory and $OutputDirectory must be a directories.";
DivideTutorials::nofilesel = "No file is selected.";
DivideTutorials::nouseableheadings3 = "There are no headings useable as dividers for the chosen notebook.";

Options[DivideTutorials] = {DivideTutorialsScope -> Directory}

$AdditionalTutorialDividerSections = {}
  

$StripTutorialDividerNumberPrefixing = False;
$RetainOriginalTableFormatting = True;
$RetainOriginalTextCellFormatting = True;
$File = ""

(* The FE token "ClearCellOptions" is defective so taking out unformatting checkboxes for now. *)

DivideTutorialsNotebookAndDirectoryDialog[file_, sections_] := 
 Module[{sn, fi, s, t, a, b, u, v}, a = DocumentationTools`$ApplicationName; b = DocumentationTools`$LinkBase;
  Notebook[{Cell["", FontSize -> 1, CellElementSpacings -> {"CellMinHeight" -> 1}, Selectable -> False],
    Cell["The notebook and directory in this dialog were determined by the input notebook. If this\nis not what is desired, click on the Extract Tutorials button with no saved notebooks open.", 
         "Text", FontFamily -> "Verdana", FontSize -> 11, CellMargins -> {{8, 8}, {7, 1}}], 
    Cell[BoxData[ToBoxes@Style[Grid[{{Style["Source Notebook: ", Bold, Editable -> False, Selectable -> False], 
                                      TextCell[file]}, 
                                     {Style["Output Directory: ", Bold, Editable -> False, Selectable -> False], 
                                      TextCell[$OutputDirectory]},
                                     {Style["Application Name: ", Bold, Editable -> False, Selectable -> False],
                                      InputField[Dynamic[DocumentationTools`$ApplicationName], String, FieldSize -> {42, {1, Infinity}}]},
                                     {Style["Link Base: ", Bold, Editable -> False, Selectable -> False],
                                      InputField[Dynamic[DocumentationTools`$LinkBase], String, FieldSize -> {42, {1, Infinity}}]},
                                     {Style["Tutorial Divider: ", Bold, Editable -> False, Selectable -> False], 
                                      PopupMenu[Dynamic[$TutorialDivider, ($TutorialDivider = #1) &], 
                                                Join[sections, $AdditionalTutorialDividerSections]]},
                                     {"", 
                                      Row[{"Eliminate numbering prefixes from headings: ", 
                                           Checkbox[Dynamic[$StripTutorialDividerNumberPrefixing, 
                                                            (sn = #;
                                                             If[$StripTutorialDividerNumberPrefixing, 
                                                                $StripTutorialDividerNumberPrefixing = False, 
                                                                $StripTutorialDividerNumberPrefixing = True]) &]]}]},
                                  (* {"", 
                                      Row[{"Retain original table formatting: ", 
                                           Checkbox[Dynamic[$RetainOriginalTableFormatting, 
                                                            (tn = #;
                                                             If[$RetainOriginalTableFormatting, 
                                                                $RetainOriginalTableFormatting = False, 
                                                                $RetainOriginalTableFormatting = True]) &]]}]},
                                     {"", 
                                      Row[{"Retain original text cell formatting: ", 
                                           Checkbox[Dynamic[$RetainOriginalTextCellFormatting, 
                                                            (un = #;
                                                             If[$RetainOriginalTextCellFormatting, 
                                                                $RetainOriginalTextCellFormatting = False, 
                                                                $RetainOriginalTextCellFormatting = True]) &]]}]}, *)
                                     {"", OldRow[{Button[Style["OK", Bold],
                                                         UpdatePacletVariables[s, t];
                                                         NotebookClose[EvaluationNotebook[]];
                                                         TutorialDivider[fi, $OutputDirectory, $TutorialDivider, 
                                                                         StripSectionNumbering -> $StripTutorialDividerNumberPrefixing,
                                                                         RetainOriginalTableFormatting -> $RetainOriginalTableFormatting,
                                                                         RetainOriginalTextCellFormatting -> $RetainOriginalTextCellFormatting], 
                                                         Method -> "Queued"] /. {s -> a, t -> b, fi -> file}, 
                                                  Button[Style["Cancel", Bold], 
                                                         (DocumentationTools`$ApplicationName = u; DocumentationTools`$LinkBase = v;
                                                          NotebookClose[EvaluationNotebook[]]), 
                                                         Method -> "Queued"] /. {u -> a, v -> b}}, 
                                                 RowAlignments -> Center]}}, 
                                    Alignment -> Left, Spacings -> {Automatic, {5 -> .5, 6 -> 1, 7 -> 1}}], 
                               FontFamily -> "Verdana", FontSize -> 11]]], 
            Cell["", FontSize -> 1, CellElementSpacings -> {"CellMinHeight" -> 1}, Selectable -> False]}, 
           WindowMargins -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
           WindowFrame -> "Palette", 
           WindowElements -> {}, 
           WindowFrameElements -> {}, 
           ShowCellBracket -> False, 
           ClosingAutoSave -> False, 
           WindowTitle -> "Extract Tutorials From Notebook", 
           Saveable -> False, 
           ShowStringCharacters -> False, 
           Selectable -> False,
           WindowSize -> {580, FitAll}]]

DivideTutorialsBothDirectoriesFixedDialog[sections_] := 
 Module[{sn, s, t, a, b, u, v}, a = DocumentationTools`$ApplicationName; b = DocumentationTools`$LinkBase;
  Notebook[{Cell["", FontSize -> 1, CellElementSpacings -> {"CellMinHeight" -> 1}, Selectable -> False],
            Cell["The directories in this dialog were determined by the input notebook. If these are not the\ndirectories desired, click on the Extract Tutorials button with no saved notebooks open.", 
                 "Text", FontFamily -> "Verdana", FontSize -> 11, CellMargins -> {{8, 8}, {7, 1}}], 
            Cell[BoxData[ToBoxes@Style[Grid[{{Style["Source Directory: ", Bold, Editable -> False, Selectable -> False], 
                                              TextCell[$SourceDirectory]}, 
                                             {Style["Output Directory: ", Bold, Editable -> False, Selectable -> False], 
                                              TextCell[$OutputDirectory]},
                                             {Style["Application Name: ", Bold, Editable -> False, Selectable -> False],
                                              InputField[Dynamic[DocumentationTools`$ApplicationName], String, FieldSize -> {42, {1, Infinity}}]},
                                             {Style["Link Base: ", Bold, Editable -> False, Selectable -> False],
                                              InputField[Dynamic[DocumentationTools`$LinkBase], String, FieldSize -> {42, {1, Infinity}}]},
                                             {Style["Tutorial Divider: ", Bold, Editable -> False, Selectable -> False], 
                                               PopupMenu[Dynamic[$TutorialDivider, ($TutorialDivider = #1) &], 
                                                         Join[sections, $AdditionalTutorialDividerSections]]},
                                             {"",
					      Row[{"Eliminate numbering prefixes from headings: ", 
					           Checkbox[Dynamic[$StripTutorialDividerNumberPrefixing, 
					                            (sn = #;
					                             If[$StripTutorialDividerNumberPrefixing, 
					                                $StripTutorialDividerNumberPrefixing = False, 
                                                                        $StripTutorialDividerNumberPrefixing = True]) &]]}]},
                                   (*        {"", 
                                              Row[{"Retain original table formatting: ", 
                                                   Checkbox[Dynamic[$RetainOriginalTableFormatting, 
                                                                   (tn = #;
                                                                    If[$RetainOriginalTableFormatting, 
                                                                       $RetainOriginalTableFormatting = False, 
                                                                       $RetainOriginalTableFormatting = True]) &]]}]},
                                             {"", 
                                              Row[{"Retain original text cell formatting: ", 
                                                   Checkbox[Dynamic[$RetainOriginalTextCellFormatting, 
                                                                    (un = #;
                                                                     If[$RetainOriginalTextCellFormatting, 
                                                                        $RetainOriginalTextCellFormatting = False, 
                                                                        $RetainOriginalTextCellFormatting = True]) &]]}]}, *)
                                              {"", OldRow[{Button[Style["OK", Bold],
                                                                  If[FileType[$SourceDirectory] =!= Directory || 
                                                                      StringMatchQ[$OutputDirectory, "" | Whitespace] || 
                                                                      (FileType[$SourceDirectory] === Directory && 
                                                                     Not@StringMatchQ[$OutputDirectory, "" | Whitespace] && 
                                                                     $OutputDirectory =!= ToFileName[{$SourceDirectory, "Tutorials"}] && 
                                                                      FileType[$OutputDirectory] =!= Directory), 
                                                                     MessageToConsole[DivideTutorials::directories],
                                                                     UpdatePacletVariables[s, t];
                                                                     NotebookClose[EvaluationNotebook[]];
                                                                     TutorialDivider[$SourceDirectory, $OutputDirectory, 
                                                                                     $TutorialDivider, 
                                                                                     StripSectionNumbering -> $StripTutorialDividerNumberPrefixing,
                                                                                     RetainOriginalTableFormatting -> $RetainOriginalTableFormatting,
                                                                                    RetainOriginalTextCellFormatting -> $RetainOriginalTextCellFormatting]], 
                                                                  Method -> "Queued"] /. {s -> a, t -> b}, 
                                                           Button[Style["Cancel", Bold], 
                                                                  (DocumentationTools`$ApplicationName = u; DocumentationTools`$LinkBase = v;
                                                                   NotebookClose[EvaluationNotebook[]]), 
                                                                  Method -> "Queued"] /. {u -> a, v -> b}}, 
                                                            RowAlignments -> Center]}}, 
                                                          Alignment -> Left, Spacings -> {Automatic, {5 -> .5, 6 -> 1, 7 -> 1}}], 
                                       FontFamily -> "Verdana",
                                       FontSize -> 11]]], 
                                  
            Cell["", FontSize -> 1, CellElementSpacings -> {"CellMinHeight" -> 1}, Selectable -> False]}, 
           WindowMargins -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
           WindowFrame -> "Palette", 
           WindowElements -> {}, 
           WindowFrameElements -> {}, 
           ShowCellBracket -> False, 
           ClosingAutoSave -> False, 
           WindowTitle -> "Extract Tutorials From Directory", 
           Saveable -> False, 
           ShowStringCharacters -> False, 
           Selectable -> False,
           WindowSize -> {580, FitAll}]]
           
DivideTutorialsBothDirectoriesVariableDialog[sections_] := 
 Module[{sn, s, t, a, b, u, v}, a = DocumentationTools`$ApplicationName; b = DocumentationTools`$LinkBase; 
  Notebook[{Cell["", FontSize -> 1, CellElementSpacings -> {"CellMinHeight" -> 1}, Selectable -> False], 
    Cell[BoxData[ToBoxes@Style[Grid[{{Style["Source Directory: ", Bold, Editable -> False, Selectable -> False], 
                                      InputField[Dynamic[$SourceDirectory], String, FieldSize -> {40, {1, Infinity}}], 
                                      Button["Browse", Set$SourceDirectory["Browse"], Method -> "Queued", ImageSize -> 65]}, 
                                     {Style["Output Directory: ", Bold, Editable -> False, Selectable -> False], 
                                      InputField[Dynamic[$OutputDirectory], String, FieldSize -> {40, {1, Infinity}}], 
                                      Button["Browse", Set$OutputDirectory["Browse"], Method -> "Queued", ImageSize -> 65]}, 
                                     {Style["Application Name: ", Bold, Editable -> False, Selectable -> False], 
                                      InputField[Dynamic[DocumentationTools`$ApplicationName], String, FieldSize -> {40, {1, Infinity}}], ""},
                                     {Style["Link Base: ", Bold, Editable -> False, Selectable -> False],
                                      InputField[Dynamic[DocumentationTools`$LinkBase], String, FieldSize -> {40, {1, Infinity}}], ""}, 
                                     {Style["Tutorial Divider: ", Bold, Editable -> False, Selectable -> False], 
                                      PopupMenu[Dynamic[$TutorialDivider, ($TutorialDivider = #1) &], 
                                                Join[sections, $AdditionalTutorialDividerSections]], ""},
                                     {"",
				      Row[{"Eliminate numbering prefixes from headings: ", 
				           Checkbox[Dynamic[$StripTutorialDividerNumberPrefixing, 
				                            (sn = #;
				                             If[$StripTutorialDividerNumberPrefixing, 
				                                $StripTutorialDividerNumberPrefixing = False, 
				                                $StripTutorialDividerNumberPrefixing = True]) &]]}], 
                                      ""},
                                  (* {"", 
                                      Row[{"Retain original table formatting: ", 
                                           Checkbox[Dynamic[$RetainOriginalTableFormatting, 
                                                            (tn = #;
                                                             If[$RetainOriginalTableFormatting, 
                                                                $RetainOriginalTableFormatting = False, 
                                                                $RetainOriginalTableFormatting = True]) &]]}],
                                      ""},
                                     {"", 
                                      Row[{"Retain original text cell formatting: ", 
                                           Checkbox[Dynamic[$RetainOriginalTextCellFormatting, 
                                                            (un = #;
                                                             If[$RetainOriginalTextCellFormatting, 
                                                                $RetainOriginalTextCellFormatting = False, 
                                                                $RetainOriginalTextCellFormatting = True]) &]]}],
                                      ""},   *)
                                     {"", OldRow[{Button[Style["OK", Bold], 
                                                         If[Not@StringMatchQ[$SourceDirectory, "" | Whitespace] && 
                                                            Not@StringMatchQ[$SourceDirectory, __ ~~ $PathnameSeparator], 
                                                            $SourceDirectory = $SourceDirectory ~~ $PathnameSeparator];
                                                         If[Not@StringMatchQ[$OutputDirectory, "" | Whitespace] && 
                                                            Not@StringMatchQ[$OutputDirectory, __ ~~ $PathnameSeparator], 
                                                            $OutputDirectory = $OutputDirectory ~~ $PathnameSeparator];
                                                         If[FileType[$SourceDirectory] =!= Directory || 
                                                            StringMatchQ[$OutputDirectory, "" | Whitespace] || 
                                                            (FileType[$SourceDirectory] === Directory && 
                                                             Not@StringMatchQ[$OutputDirectory, "" | Whitespace] && 
                                                             $OutputDirectory =!= ToFileName[{$SourceDirectory, "Tutorials"}] && 
                                                             FileType[$OutputDirectory] =!= Directory), 
                                                            MessageToConsole[DivideTutorials::directories],
                                                            UpdatePacletVariables[s, t];
                                                            NotebookClose[EvaluationNotebook[]];
                                                            TutorialDivider[$SourceDirectory, $OutputDirectory, 
                                                                            $TutorialDivider, 
                                                                            StripSectionNumbering -> $StripTutorialDividerNumberPrefixing,
                                                                            RetainOriginalTableFormatting -> $RetainOriginalTableFormatting,
                                                                            RetainOriginalTextCellFormatting -> $RetainOriginalTextCellFormatting]], 
                                                         Method -> "Queued"] /. {s -> a, t -> b}, 
                                                  Button[Style["Cancel", Bold], 
                                                         (DocumentationTools`$ApplicationName = u; DocumentationTools`$LinkBase = v;
                                                          NotebookClose[EvaluationNotebook[]]), 
                                                         Method -> "Queued"] /. {u -> a, v -> b}}, 
                                                 RowAlignments -> Center], ""}}, 
                                    Alignment -> Left, Spacings -> {Automatic, {5 -> .5, 6 -> 1, 7 -> 1}}], 
                               FontFamily -> "Verdana", FontSize -> 11]]], 
            Cell["", FontSize -> 1, CellElementSpacings -> {"CellMinHeight" -> 1}, Selectable -> False]}, 
           WindowSize -> FitAll, 
           WindowMargins -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
           WindowFrame -> "Palette", 
           WindowElements -> {}, 
           WindowFrameElements -> {}, 
           ShowCellBracket -> False, 
           ClosingAutoSave -> False, 
           WindowTitle -> "Extract Tutorials", 
           Saveable -> False, 
           ShowStringCharacters -> False, 
           Selectable -> False]]
           
NotebookFilePath[nb_] := 
 Module[{nbi = NotebookInformation[nb], file}, 
        If[ListQ[nbi], 
           file = "FileName" /. nbi; 
           If[Head[file] === FrontEnd`FileName, 
              ToFileName["FileName" /. nbi],
              $Failed], 
           $Failed]]
                                                           
DivideTutorials[opts___] := 
 Module[{sn, s, t, a, b, u, v, PotentialSourceDirectory, file, divideTutorialsScope, nn, files, pnb, fi, sections},
  a = DocumentationTools`$ApplicationName; b = DocumentationTools`$LinkBase;
Quiet[
If[$AdditionalTutorialDividerSections =!= {} && Not@VectorQ[$AdditionalTutorialDividerSections, StringQ],
   MessageToConsole[DivideTutorials::additionaltutorialdividersectionsform],
  divideTutorialsScope = DivideTutorialsScope /. {opts} /. Options[DivideTutorials];
  nn = NextNotebook[];
Quiet[Catch[If[StringMatchQ[DocumentationTools`$LinkBase, "" | (" "..)] || Not@StringFreeQ[DocumentationTools`$LinkBase, "`"],
               Throw[MessageToConsole[DivideTutorials::$LinkBasedef]]];
   If[nn =!= None,
     PotentialSourceDirectory = Quiet[NotebookDirectory[NextNotebook[]]];
     If[(* The input notebook is saved. *) PotentialSourceDirectory =!= $Failed,
        $SourceDirectory = PotentialSourceDirectory;
        $OutputDirectory = ToFileName[{$SourceDirectory, "Tutorials"}];
  Throw[If[(* Just divide saved input notebook. *)divideTutorialsScope =!= Directory,
     
              file = NotebookFilePath[nn];
              pnb = CreatePalette[ProgressIndicator[Dynamic[Clock[Infinity]], Indeterminate, ImageSize -> {250, 30}], 
           WindowMargins -> Automatic, WindowTitle -> "DivideTutorials is processing notebooks.", WindowSize -> {250, Fit}];
              sections = Function[t, Select[Union[Cases[t, Cell[CellGroupData[{Cell[_, a_, ___], __}, ___]] :> a, 
                                                        Infinity]], ValidHeadingQ[#, t] &]][Get[file]];
              NotebookClose[pnb];
              sections = DeleteCases[sections, "TOCTitle"];
              If[sections === {}, Throw[MessageToConsole[DivideTutorials::nouseableheadings2]]];
              If[Not@MemberQ[sections, $TutorialDivider], $TutorialDivider = sections[[1]]];
NotebookPut[DivideTutorialsNotebookAndDirectoryDialog[file, sections]],
     
       If[# =!= Null && # =!= $Canceled, $SourceDirectory = #, Abort[]] &[SystemDialogInput["Directory", $SourceDirectory, 
                                                                                            WindowTitle -> "Set Source Directory"]]; 
       If[FileType[$SourceDirectory] === Directory, 
          $OutputDirectory = ToFileName[{$SourceDirectory, "Tutorials"}];
          files = DeleteCases[FileNames["*.nb", {$SourceDirectory}], 
                              x_String /; StringMatchQ[StringReplace[x, DirectoryName[x] -> ""], 
                                                       "*Overview*" | "*UndefinedStyles*", IgnoreCase -> True]];
          If[files === {}, 
             Throw[MessageToConsole[DivideTutorials::emptysourcedir]]];
          pnb = CreatePalette[ProgressIndicator[Dynamic[Clock[Infinity]], Indeterminate, ImageSize -> {250, 30}], 
                              WindowMargins -> Automatic, WindowTitle -> "DivideTutorials is processing notebooks.", 
                              WindowSize -> {250, Fit}];
          sections = Intersection @@ Function[t, Select[Union[Cases[t, Cell[CellGroupData[{Cell[_, a_, ___], __}, ___]] :> a, Infinity]], 
                                                        ValidHeadingQ[#, t] &]] /@ (Get /@ files);
          NotebookClose[pnb];
          sections = DeleteCases[sections, "TOCTitle"];
          If[sections === {}, Throw[MessageToConsole[DivideTutorials::nouseableheadings]]];
          If[Not@MemberQ[sections, $TutorialDivider], $TutorialDivider = sections[[1]]];
          NotebookPut[DivideTutorialsBothDirectoriesVariableDialog[sections]]]]],
              
  If[divideTutorialsScope === Directory,
     
     If[$SourceDirectory =!= "" && FileType[$SourceDirectory] === Directory, 
        If[# =!= Null && # =!= $Canceled, 
           $SourceDirectory = #, 
           Abort[]] &[SystemDialogInput["Directory", $SourceDirectory, WindowTitle -> "Set Source Directory"]],
        While[FileType[$SourceDirectory] =!= Directory, 
              If[# =!= Null && # =!= $Canceled, 
                 $SourceDirectory = #, 
                 Abort[]] &[SystemDialogInput["Directory", $DocumentationDirectory, WindowTitle -> "Set Source Directory"]]]],
                 
Throw[If[$File =!= "" && FileType[$File] === File, 
        If[# =!= Null && # =!= $Canceled, 
          $File = #, 
          Abort[]] &[SystemDialogInput["FileOpen", $DocumentationDirectory, WindowTitle -> "Select a notebook"]], 
        While[FileType[$File] === None || Not@ValueQ[$File] || $File === "",
              If[# =!= Null && # =!= $Canceled, 
                 $File = #, 
                 Abort[]] &[SystemDialogInput["FileOpen", $DocumentationDirectory, WindowTitle -> "Select a notebook"]]]];
     If[$File === "" || $File === $Canceled || FileType[$File] === None, 
        Throw[MessageToConsole[DivideTutorials::nofilesel]]];
     pnb = CreatePalette[ProgressIndicator[Dynamic[Clock[Infinity]], Indeterminate, ImageSize -> {250, 30}], 
                         WindowMargins -> Automatic, WindowTitle -> "DivideTutorials is processing notebooks.", 
                         WindowSize -> {250, Fit}];
     sections = Function[t, Select[Union[Cases[t, Cell[CellGroupData[{Cell[_, a_, ___], __}, ___]] :> a, 
                                               Infinity]], ValidHeadingQ[#, t] &]][Get[$File]];
     $OutputDirectory =
       ToFileName[{DirectoryName[$File], "Tutorials"}];
     NotebookClose[pnb];
     sections = DeleteCases[sections, "TOCTitle"];
     If[sections === {}, Throw[MessageToConsole[DivideTutorials::nouseableheadings3]]];
     If[Not@MemberQ[sections, $TutorialDivider], $TutorialDivider = sections[[1]]];
     a = DocumentationTools`$ApplicationName; b = DocumentationTools`$LinkBase;
     NotebookPut[Notebook[{Cell["", FontSize -> 1, CellElementSpacings -> {"CellMinHeight" -> 1}, Selectable -> False], 
                           Cell["The notebook and directory in this dialog were determined by the chosen notebook. If this\nis not what is desired, click on the Extract Tutorials button with no saved notebooks open.", 
                           "Text", FontFamily -> "Verdana", FontSize -> 11, CellMargins -> {{8, 8}, {7, 1}}], 
       Cell[BoxData[ToBoxes@Style[Grid[{{Style["Source Notebook: ", Bold, Editable -> False, Selectable -> False], 
                                         TextCell[$File]}, 
                                        {Style["Output Directory: ", Bold, Editable -> False, Selectable -> False], 
                                         TextCell[$OutputDirectory]}, 
                                        {Style["Application Name: ", Bold, Editable -> False, Selectable -> False], 
                                         InputField[Dynamic[DocumentationTools`$ApplicationName], String, FieldSize -> {42, {1, Infinity}}]},
                                        {Style["Link Base: ", Bold, Editable -> False, Selectable -> False], 
                                         InputField[Dynamic[DocumentationTools`$LinkBase], String, FieldSize -> {42, {1, Infinity}}]},
                                        {Style["Tutorial Divider: ", Bold, Editable -> False, Selectable -> False], 
                                         PopupMenu[Dynamic[$TutorialDivider, ($TutorialDivider = #1) &], 
                                                   Join[sections, $AdditionalTutorialDividerSections]]},
                                        {"", 
                                         Row[{"Eliminate numbering prefixes from headings: ", 
                                              Checkbox[Dynamic[$StripTutorialDividerNumberPrefixing, 
                                                               (sn = #;
                                                                If[$StripTutorialDividerNumberPrefixing, 
                                                                   $StripTutorialDividerNumberPrefixing = False, 
                                                                   $StripTutorialDividerNumberPrefixing = True]) &]]}]},
                                   (*   {"", 
                                         Row[{"Retain original table formatting: ", 
                                              Checkbox[Dynamic[$RetainOriginalTableFormatting, 
                                                               (tn = #;
                                                                If[$RetainOriginalTableFormatting, 
                                                                   $RetainOriginalTableFormatting = False, 
                                                                   $RetainOriginalTableFormatting = True]) &]]}]},
                                        {"", 
                                         Row[{"Retain original text cell formatting: ", 
                                              Checkbox[Dynamic[$RetainOriginalTextCellFormatting, 
                                                               (un = #;
                                                                If[$RetainOriginalTextCellFormatting, 
                                                                   $RetainOriginalTextCellFormatting = False, 
                                                                   $RetainOriginalTextCellFormatting = True]) &]]}]}, *)
                                        {"", OldRow[{Button[Style["OK", Bold],
                                                            UpdatePacletVariables[s, t];
                                                            NotebookClose[EvaluationNotebook[]];
                                                            TutorialDivider[fi, $OutputDirectory, $TutorialDivider, 
                                                                            StripSectionNumbering -> $StripTutorialDividerNumberPrefixing,
                                                                            RetainOriginalTableFormatting -> $RetainOriginalTableFormatting,
                                                                            RetainOriginalTextCellFormatting -> $RetainOriginalTextCellFormatting], 
                                                            Method -> "Queued"] /. {s -> a, t -> b, fi -> $File}, 
                                                     Button[Style["Cancel", Bold], 
                                                            (DocumentationTools`$ApplicationName = u; DocumentationTools`$LinkBase = v;
                                                             NotebookClose[EvaluationNotebook[]]), 
                                                            Method -> "Queued"] /. {u -> a, v -> b}}, 
                                                    RowAlignments -> Center]}}, 
                                       Alignment -> Left, Spacings -> {Automatic, {5 -> .5, 6 -> 1, 7 -> 1}}], 
            FontFamily -> "Verdana", FontSize -> 11]]], 
                           Cell["", FontSize -> 1, CellElementSpacings -> {"CellMinHeight" -> 1}, Selectable -> False]}, 
                          WindowMargins -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
                          WindowFrame -> "Palette", 
                          WindowElements -> {}, 
                          WindowFrameElements -> {}, 
                          ShowCellBracket -> False, 
                          ClosingAutoSave -> False, 
                          WindowTitle -> "Extract Tutorials From Notebook", 
                          Saveable -> False, 
                          ShowStringCharacters -> False, 
                          Selectable -> False, 
                          WindowSize -> {580, FitAll}]]]]];
                 
     If[FileType[$SourceDirectory] === Directory, 
        $OutputDirectory = ToFileName[{$SourceDirectory, "Tutorials"}];
        files = DeleteCases[FileNames["*.nb", {$SourceDirectory}], x_String/;StringMatchQ[StringReplace[x, DirectoryName[x] -> ""], 
                                                                                          "*Overview*" | "*UndefinedStyles*", 
                                                                                          IgnoreCase -> True]];
        If[files === {}, Throw[MessageToConsole[DivideTutorials::emptysourcedir]]];
        pnb = CreatePalette[ProgressIndicator[Dynamic[Clock[Infinity]], Indeterminate, ImageSize -> {250, 30}], 
          WindowMargins -> Automatic, WindowTitle -> "DivideTutorials is processing notebooks.", WindowSize -> {250, Fit}];
        sections = Intersection @@ Function[t, Select[Union[Cases[t, Cell[CellGroupData[{Cell[_, a_, ___], __}, ___]] :> 
                                                                  a, Infinity]], ValidHeadingQ[#, t] &]] /@ (Get /@ files);
        NotebookClose[pnb];
        sections = DeleteCases[sections, "TOCTitle"];
        If[sections === {}, Throw[MessageToConsole[DivideTutorials::nouseableheadings]]];
        If[Not@MemberQ[sections, $TutorialDivider], $TutorialDivider = sections[[1]]];
        NotebookPut[DivideTutorialsBothDirectoriesVariableDialog[sections]]],
                 
  If[divideTutorialsScope === Directory,

     If[$SourceDirectory =!= "" && FileType[$SourceDirectory] === Directory, 
    If[# =!= Null && # =!= $Canceled, 
       $SourceDirectory = #, 
       Abort[]] &[SystemDialogInput["Directory", $SourceDirectory, WindowTitle -> "Set Source Directory"]],
        While[FileType[$SourceDirectory] =!= Directory, 
              If[# =!= Null && # =!= $Canceled, 
                 $SourceDirectory = #, 
                 Abort[]] &[SystemDialogInput["Directory", $DocumentationDirectory, WindowTitle -> "Set Source Directory"]]]],
                 
     If[$File =!= "" && FileType[$File] === File, 
        If[# =!= Null && # =!= $Canceled, 
           $File = #, 
           Abort[]] &[SystemDialogInput["FileOpen", $DocumentationDirectory, WindowTitle -> "Select a notebook"]], 
        While[FileType[$File] === None || Not@ValueQ[$File] || $File === "", 
              If[# =!= Null && # =!= $Canceled, 
                 $File = #, 
                 Abort[]] &[SystemDialogInput["FileOpen", $DocumentationDirectory, WindowTitle -> "Select a notebook"]]]]];
                 
If[divideTutorialsScope === Directory,
    
  files = DeleteCases[FileNames["*.nb", {$SourceDirectory}], x_String/;StringMatchQ[StringReplace[x, DirectoryName[x] -> ""], 
                                                                                    "*Overview*" | "*UndefinedStyles*", 
                                                                                    IgnoreCase -> True]];
If[files === {}, Throw[MessageToConsole[DivideTutorials::emptysourcedir]]];
  (* Getting all the nbs in $SourceDirectory may take a while so put up a progress indicator to show that nbs are being
     processed. *)
  pnb = CreatePalette[ProgressIndicator[Dynamic[Clock[Infinity]], Indeterminate, ImageSize -> {250, 30}], 
          WindowMargins -> Automatic, WindowTitle -> "DivideTutorials is processing notebooks.", WindowSize -> {250, Fit}];
  (* Get the headings valid for all notebooks in $SourceDirectory. *)
  sections = Intersection @@ Function[t, Select[Union[Cases[t, Cell[CellGroupData[{Cell[_, a_, ___], __}, ___]] :> 
                                                                  a, Infinity]], ValidHeadingQ[#, t] &]] /@ (Get /@ files);
  NotebookClose[pnb];
  sections = DeleteCases[sections, "TOCTitle"];
  If[sections === {}, Throw[MessageToConsole[DivideTutorials::nouseableheadings]]];
  (* If using the DivideTutorials dialog and $TutorialDivider gets set to a style and the DivideTutorials dialog gets
     used again in the same Mathematica session on a directory for which $TutorialDivider is not an acceptable style,
     $TutorialDivider must be set to one of the acceptable styles. *)
  If[Not@MemberQ[sections, $TutorialDivider], $TutorialDivider = sections[[1]]];
  $OutputDirectory = ToFileName[{$SourceDirectory, "Tutorials"}];
  
  NotebookPut[DivideTutorialsBothDirectoriesVariableDialog[sections]],
                            
If[$File === "" || $File === $Canceled || FileType[$File] === None, Throw[MessageToConsole[DivideTutorials::nofilesel]]];
pnb = CreatePalette[ProgressIndicator[Dynamic[Clock[Infinity]], Indeterminate, ImageSize -> {250, 30}], 
          WindowMargins -> Automatic, WindowTitle -> "DivideTutorials is processing notebooks.", WindowSize -> {250, Fit}];
sections = Function[t, Select[Union[Cases[t, Cell[CellGroupData[{Cell[_, a_, ___], __}, ___]] :> a, 
                                                        Infinity]], ValidHeadingQ[#, t] &]][Get[$File]];
$OutputDirectory = ToFileName[{DirectoryName[$File], "Tutorials"}];
NotebookClose[pnb];
sections = DeleteCases[sections, "TOCTitle"];
If[sections === {}, Throw[MessageToConsole[DivideTutorials::nouseableheadings3]]];
If[Not@MemberQ[sections, $TutorialDivider], $TutorialDivider = sections[[1]]];
a = DocumentationTools`$ApplicationName; b = DocumentationTools`$LinkBase;
NotebookPut[Notebook[{Cell["", FontSize -> 1, CellElementSpacings -> {"CellMinHeight" -> 1}, Selectable -> False],
                      Cell["The notebook and directory in this dialog were determined by the chosen notebook. If this\nis not what is desired, click on the Extract Tutorials button with no saved notebooks open.", 
                       "Text", FontFamily -> "Verdana", FontSize -> 11, CellMargins -> {{8, 8}, {7, 1}}], 
                  Cell[BoxData[ToBoxes@Style[Grid[{
                                              {Style["Source Notebook: ", Bold, Editable -> False, Selectable -> False], 
                                               TextCell[$File]}, 
                                              {Style["Output Directory: ", Bold, Editable -> False, Selectable -> False], 
                                               TextCell[$OutputDirectory]},
                                              {Style["Application Name: ", Bold, Editable -> False, Selectable -> False],
                                               InputField[Dynamic[DocumentationTools`$ApplicationName], String, FieldSize -> {40, {1, Infinity}}]},
                                              {Style["Link Base: ", Bold, Editable -> False, Selectable -> False],
                                               InputField[Dynamic[DocumentationTools`$LinkBase], String, FieldSize -> {40, {1, Infinity}}]},
                                              {Style["Tutorial Divider: ", Bold, Editable -> False, Selectable -> False], 
                                               PopupMenu[Dynamic[$TutorialDivider, ($TutorialDivider = #1) &], 
                                                         Join[sections, $AdditionalTutorialDividerSections]]},
                                              {"", 
					       Row[{"Eliminate numbering prefixes from headings: ", 
					            Checkbox[Dynamic[$StripTutorialDividerNumberPrefixing, 
					                             (sn = #;
					                              If[$StripTutorialDividerNumberPrefixing, 
					                                 $StripTutorialDividerNumberPrefixing = False, 
                                                                         $StripTutorialDividerNumberPrefixing = True]) &]]}]},
                                        (*    {"", 
                                               Row[{"Retain original table formatting: ", 
                                                    Checkbox[Dynamic[$RetainOriginalTableFormatting, 
                                                                     (tn = #;
                                                                      If[$RetainOriginalTableFormatting, 
                                                                         $RetainOriginalTableFormatting = False, 
                                                                         $RetainOriginalTableFormatting = True]) &]]}]},
                                              {"", 
                                               Row[{"Retain original text cell formatting: ", 
                                                    Checkbox[Dynamic[$RetainOriginalTextCellFormatting, 
                                                                     (un = #;
                                                                      If[$RetainOriginalTextCellFormatting, 
                                                                         $RetainOriginalTextCellFormatting = False, 
                                                                         $RetainOriginalTextCellFormatting = True]) &]]}]}, *)
                                              {"", OldRow[{Button[Style["OK", Bold],
                                                                  UpdatePacletVariables[s, t];
                                                                  NotebookClose[EvaluationNotebook[]];
                                                                  TutorialDivider[fi, 
                                                                                  $OutputDirectory, 
                                                                                  $TutorialDivider, 
                                                                                  StripSectionNumbering -> $StripTutorialDividerNumberPrefixing,
                                                                                  RetainOriginalTableFormatting -> $RetainOriginalTableFormatting,
                                                                                  RetainOriginalTextCellFormatting -> $RetainOriginalTextCellFormatting], 
                                                                  Method -> "Queued"] /. {s -> a, t -> b, fi -> $File}, 
                                                           Button[Style["Cancel", Bold], 
                                                                  (DocumentationTools`$ApplicationName = u; DocumentationTools`$LinkBase = v;
                                                                   NotebookClose[EvaluationNotebook[]]), 
                                                                  Method -> "Queued"] /. {u -> a, v -> b}}, 
                                                          RowAlignments -> Center]}}, 
                                                  Alignment -> Left, Spacings -> {Automatic, {5 -> .5, 6 -> 1, 7 -> 1}}], 
                                             FontFamily -> "Verdana",
                                             FontSize -> 11]]], 
                  Cell["", FontSize -> 1, CellElementSpacings -> {"CellMinHeight" -> 1}, Selectable -> False]}, 
                 WindowMargins -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
                 WindowFrame -> "Palette", 
                 WindowElements -> {}, 
                 WindowFrameElements -> {}, 
                 ShowCellBracket -> False, 
                 ClosingAutoSave -> False, 
                 WindowTitle -> "Extract Tutorials From Notebook", 
                 Saveable -> False, 
                 ShowStringCharacters -> False, 
                 Selectable -> False,
                     WindowSize -> {580, FitAll}]]]]], {FileType::fstr}]], {Syntax::newl, StringMatchQ::strse, StringFreeQ::strse}]]
                     
                     
(** Code to add button data as needed to application symbol buttons. **)


$ApplicationSymbolsLinkFixDirectory = ""

ApplicationSymbolsLinkFix[] := 
 Quiet[If[$ApplicationSymbolsLinkFixDirectory =!= "" && FileType[$ApplicationSymbolsLinkFixDirectory] === Directory, 
     If[# =!= Null && # =!= $Canceled, 
        $ApplicationSymbolsLinkFixDirectory = #, 
        Abort[]] &[SystemDialogInput["Directory", 
                                     $ApplicationSymbolsLinkFixDirectory, 
                                     WindowTitle -> "Set Directory For Application Link Fixes"]], 
     While[FileType[$ApplicationSymbolsLinkFixDirectory] =!= Directory, 
           If[# =!= Null && # =!= $Canceled, 
              $ApplicationSymbolsLinkFixDirectory = #, 
              Abort[]] &[SystemDialogInput["Directory", 
                                           $DocumentationDirectory, 
                                           WindowTitle -> "Set Directory For Application Link Fixes"]]]]; 
       If[FileType[$ApplicationSymbolsLinkFixDirectory] === Directory,
          NotebookPut[ApplicationSymbolsLinkFixDialog[]]], 
       FileType::"fstr"]
        
ApplicationSymbolsLinkFixDialog[] :=
Module[{a, b, s, t, u, v}, a = DocumentationTools`$ApplicationName; b = DocumentationTools`$LinkBase;
 Notebook[{Cell["", FontSize -> 1, CellElementSpacings -> {"CellMinHeight" -> 1}, Selectable -> False], 
           Cell["Fix links in the specified applications directory. If both \
$ExcludedApplicationSymbols and $IncludedApplicationSymbols are left \
with their initial values of {}, FixApplicationSymbolsLinks will be \
applied to all symbols in the package. If this is not what you want, \
define one of $ExcludedApplicationSymbols and \
$IncludedApplicationSymbols to be a nonempty list of (string) symbols \
in the package. The link base will be used in the button data \
additions and replacements.", "Text", FontFamily -> "Verdana", FontSize -> 11, 
                CellMargins -> {{8, 8}, {7, 1}}],
           Cell[BoxData[ToBoxes@Style[Grid[{{Style["Source Directory: ", Bold, Editable -> False, Selectable -> False], 
                                             TextCell[$ApplicationSymbolsLinkFixDirectory]}, 
                                            {Style["Application Name: ", Bold, Editable -> False, Selectable -> False], 
                                             InputField[Dynamic[DocumentationTools`$ApplicationName], String, 
                                                        FieldSize -> {40, {1, Infinity}}]}, 
                                            {Style["Link Base: ", Bold, Editable -> False, Selectable -> False], 
                                             InputField[Dynamic[DocumentationTools`$LinkBase], String, 
                                                        FieldSize -> {40, {1, Infinity}}]},
                                            {"", OldRow[{Button[Style["OK", Bold],
                                                                UpdatePacletVariables[s, t];
                                                   FixApplicationSymbolsLinks[$ApplicationSymbolsLinkFixDirectory], Method -> "Queued"] /. {s -> a, t -> b}, 
                                                         Button[Style["Cancel", Bold], 
                                                                (DocumentationTools`$ApplicationName = u; DocumentationTools`$LinkBase = v;
                                                                 NotebookClose[EvaluationNotebook[]]), 
                                                                Method -> "Queued"] /. {u -> a, v -> b}}, 
                                                        RowAlignments -> Center]}}, 
                                                        Alignment -> Left, 
                                                        Spacings -> {Automatic, 3 -> 1}], 
                FontFamily -> "Verdana", FontSize -> 11]]], 
           Cell["", FontSize -> 1, CellElementSpacings -> {"CellMinHeight" -> 1}, Selectable -> False]}, 
          WindowMargins -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
          WindowFrame -> "Palette", 
          WindowElements -> {}, 
          WindowFrameElements -> {}, 
          ShowCellBracket -> False, 
          ClosingAutoSave -> False, 
          WindowTitle -> "Fix Application Links", 
          Saveable -> False, 
          ShowStringCharacters -> False, 
          Selectable -> False, 
          WindowSize -> {570, FitAll}]]
          
$ExcludedApplicationSymbols = {}
$IncludedApplicationSymbols = {}
$ApplicationSymbolsWithUsage = {}

FixApplicationSymbolsLinks::noappname = "No application name has been specified. $ApplicationName must be set.";
FixApplicationSymbolsLinks::nolinkbase = "No link base has been specified. $LinkBase must be set.";
FixApplicationSymbolsLinks::backquote = "The application name should not contain a backquote (`).";
FixApplicationSymbolsLinks::nosymsfound = "No symbols with usage messages were found for `1`. `1` may first need to be loaded or $LinkBase may need to be reset.";
FixApplicationSymbolsLinks::incexc = "At least one of $ExcludedApplicationSymbols and $IncludedApplicationSymbols must be {}. If one is non-empty it must be contained in the list given by $ApplicationSymbolsWithUsage.";
FixApplicationSymbolsLinks::$inpackage = "$IncludedApplicationSymbols must be a list of symbols in the package `1`."; 
FixApplicationSymbolsLinks::$expackage = "$ExcludedApplicationSymbols must be a list of symbols in the package `1`."; 
FixApplicationSymbolsLinks::allexc = "Not all package symbols may be excluded.";

FixApplicationSymbolsLinks[sourcedir_] := 
 Module[{presetMessageOptionsValues, newMessageOptionsValues, cs, pnb, fi, orignotebooksdir, gt, nm, nb}, 
  Catch[If[StringMatchQ[DocumentationTools`$ApplicationName, "" | Whitespace], 
           Throw[MessageToConsole[FixApplicationSymbolsLinks::noappname]]];
           
        If[StringMatchQ[DocumentationTools`$LinkBase, "" | Whitespace], 
           Throw[MessageToConsole[FixApplicationSymbolsLinks::nolinkbase]]];
           
        If[Not@StringFreeQ[DocumentationTools`$ApplicationName, "`"], 
           Throw[MessageToConsole[FixApplicationSymbolsLinks::backquote]]];
        
        presetMessageOptionsValues = MessageOptions /. Options[$FrontEnd, MessageOptions];
	(*New MessageOptions has "KernelMessageAction" with "PrintToConsole".*)
	newMessageOptionsValues = 
	  If[(cs = Cases[presetMessageOptionsValues, a : ("KernelMessageAction" -> _)]; cs) === {}, 
	     Append[presetMessageOptionsValues, "KernelMessageAction" -> {"Beep", "PrintToNotebook"}], 
	presetMessageOptionsValues /. ("KernelMessageAction" -> a_) :> ("KernelMessageAction" -> 
	       If[StringQ[a], "PrintToConsole", Append[DeleteCases[a, "PrintToNotebook"], "PrintToConsole"]])];
        SetOptions[$FrontEnd, MessageOptions -> newMessageOptionsValues];
        
        pnb = CreatePalette[ProgressIndicator[Dynamic[Clock[Infinity]], Indeterminate, ImageSize -> {250, 30}], 
          WindowMargins -> Automatic, WindowTitle -> "Getting application data.", WindowSize -> {250, Fit}];
        
        Quiet[Needs[DocumentationTools`$LinkBase <> "`"]];
        
        $ApplicationSymbolsWithUsage = SymbolsWithUsage[DocumentationTools`$ApplicationName];
           
        NotebookClose[pnb];
           
        If[$ApplicationSymbolsWithUsage === {}, Throw[MessageToConsole[FixApplicationSymbolsLinks::nosymsfound, DocumentationTools`$LinkBase]]];
        
        SetSelectedNotebook[MessagesNotebook[]];
	(*Restore previous MessageOptions.*)
        SetOptions[$FrontEnd, MessageOptions -> presetMessageOptionsValues];
        
        If[$ExcludedApplicationSymbols =!= {} && $IncludedApplicationSymbols =!= {}, 
           Throw[MessageToConsole[FixApplicationSymbolsLinks::incexc]]]; 
        If[$IncludedApplicationSymbols =!= {}, 
           If[Not[VectorQ[$IncludedApplicationSymbols, StringQ] || Complement[$IncludedApplicationSymbols, $ApplicationSymbolsWithUsage] === {}], 
              Throw[MessageToConsole[FixApplicationSymbolsLinks::$inpackage, DocumentationTools`$LinkBase]]]]; 
        If[$ExcludedApplicationSymbols =!= {}, 
           If[Not[VectorQ[$ExcludedApplicationSymbols, StringQ] || Complement[$ExcludedApplicationSymbols, $ApplicationSymbolsWithUsage] === {}], 
              Throw[MessageToConsole[FixApplicationSymbolsLinks::$expackage, DocumentationTools`$LinkBase]]]]; 
        If[$ExcludedApplicationSymbols === $ApplicationSymbolsWithUsage, 
           Throw[MessageToConsole[FixApplicationSymbolsLinks::allexc]]]; 
        NotebookClose[EvaluationNotebook[]];
        
        If[(fi = FileNames["*.nb", {sourcedir}]) =!= {}, 
	   orignotebooksdir = ToFileName[{sourcedir, "OriginalNotebooks"}];
	   CreateDirectory[orignotebooksdir];
	   CopyFile[#, ToFileName[{DirectoryName@#, "OriginalNotebooks"}, StringReplace[#, DirectoryName[#] -> ""]]] & /@ fi;
           DeleteFile[fi]];
        
        SetOptions[$FrontEnd, DynamicUpdating -> False]; 
        (gt = Get[#]; 
         nm = Cases[gt, Cell[a_String, "ObjectName", ___] :> a, Infinity]; 
         If[Cases[gt, 
                  ButtonBox[b_String /; 
                            Which[$IncludedApplicationSymbols =!= {},
                                  MemberQ[$IncludedApplicationSymbols, b],
                                  $ExcludedApplicationSymbols =!= {},
                                  MemberQ[$ExcludedApplicationSymbols, b],
                                  True,
                                  MemberQ[$ApplicationSymbolsWithUsage, b]], 
                            BaseStyle -> "Link"], Infinity] =!= {}, 
         nb = NotebookOpen[#]; 
         NotebookPut[gt /. {ButtonBox[b_String /; MemberQ[$IncludedApplicationSymbols, b] && If[nm =!= {}, 
                                                                                                b =!= nm[[1]], True], 
                                      BaseStyle -> "Link"] :> 
                            ButtonBox[b, ButtonData -> "paclet:" <> DocumentationTools`$LinkBase <> "/ref/" <> b, 
                                      BaseStyle -> "Link"],
                            ButtonBox[b_String /; ($IncludedApplicationSymbols =!= {}) && 
                                                   Not@MemberQ[$IncludedApplicationSymbols, b] &&
                                                   MemberQ[$ApplicationSymbolsWithUsage, b], ___,
                                      BaseStyle -> "Link", ___] :> b,
                            ButtonBox[b_String /; MemberQ[$ExcludedApplicationSymbols, b], ___,
                                      BaseStyle -> "Link", ___] :> b,
                            ButtonBox[b_String /; Not@MemberQ[$ExcludedApplicationSymbols, b] && 
                                                  MemberQ[$ApplicationSymbolsWithUsage, b], 
                                      BaseStyle -> "Link"] :> 
                            ButtonBox[b, ButtonData -> "paclet:" <> DocumentationTools`$LinkBase <> "/ref/" <> b, 
                                      BaseStyle -> "Link"],
                            ButtonBox[b_String /; $ExcludedApplicationSymbols === {} && 
                                                   $IncludedApplicationSymbols === {} && 
                                                    MemberQ[$ApplicationSymbolsWithUsage, b] &&
                                                    If[nm =!= {}, b =!= nm[[1]], True], 
                                      BaseStyle -> "Link"] :>
                            ButtonBox[b, ButtonData -> "paclet:" <> DocumentationTools`$LinkBase <> "/ref/" <> b, 
                                      BaseStyle -> "Link"]}, 
                     nb]; 
         NotebookSave[nb, ToFileName[{sourcedir}, StringReplace[#, DirectoryName[#] -> ""]]]; 
         NotebookClose[nb]]) & /@ FileNames["*.nb", ToFileName[{sourcedir, "OriginalNotebooks"}]]; 
        SetOptions[$FrontEnd, DynamicUpdating -> True]]]
        
        
$ReplacePacletBaseDirectory = ""
$PackageName = ""
$NewPackageName = ""
$PresentContext = ""
$NewContext = ""
$PacletBase = ""
$NewPacletBase = ""

ReplacePacletBase[] :=
Module[{files, c1, c2, c3},
 Quiet[If[$ReplacePacletBaseDirectory =!= "" && FileType[$ReplacePacletBaseDirectory] === Directory, 
          If[# =!= Null && # =!= $Canceled, 
             $ReplacePacletBaseDirectory = #, 
             Abort[]] &[SystemDialogInput["Directory", $ReplacePacletBaseDirectory, 
                                          WindowTitle -> "Set Directory for Replacing the Paclet base"]], 
          While[Not[FileType[$ReplacePacletBaseDirectory] === Directory], 
                If[# =!= Null && # =!= $Canceled, 
                   $ReplacePacletBaseDirectory = #,
                   Abort[]] &[SystemDialogInput["Directory", $DocumentationDirectory, 
                                                WindowTitle -> "Set Directory for Replacing the Paclet base"]]]]; 
       If[FileType[$ReplacePacletBaseDirectory] === Directory,
          files = FileNames["*.nb", {$ReplacePacletBaseDirectory}];
	  If[files =!= {}, 
	     Quiet[g = Get[files[[1]]]]; 
	     c1 = Cases[g, Cell[_String, "Categorization", CellLabel -> "Paclet Name", ___], Infinity];
	     If[MatchQ[c1, {Cell[a_String /; StringMatchQ[a, __ ~~ " Package"], "Categorization", 
	                         CellLabel -> "Paclet Name", ___]}], 
	        $PackageName = StringReplace[c1[[1, 1]], b__ ~~ Longest[" " ..] ~~ "Package" :> b]];
	     c2 = Cases[g, Cell[_, "Categorization", CellLabel -> "Context", ___], Infinity];
	     If[MatchQ[c2, {Cell[a_String /; StringMatchQ[a, __ ~~ "`"], "Categorization", CellLabel -> "Context", ___]}], 
	        $PresentContext = c2[[1, 1]]];
	     c3 = Cases[g, Cell[_, "Categorization", CellLabel -> "URI", ___], Infinity];
	     If[MatchQ[c3, {Cell[a_String /; StringMatchQ[a, __ ~~ "/" ~~ __], "Categorization", CellLabel -> "URI", ___]}], 
                $PacletBase = StringReplace[c3[[1, 1]], Shortest[a__] ~~ "/" ~~ __ :> a]]];
          NotebookPut[ReplacePacletBaseDialog[]]], FileType::"fstr"]]
          
CancelReplacePacletBaseDialog[previous$PackageName_, previous$NewPackageName_, previous$PresentContext_, 
                              previous$NewContext_, previous$PacletBase_, previous$NewPacletBase_] := 
 ($PackageName = previous$PackageName; $NewPackageName = previous$NewPackageName; $PresentContext = previous$PresentContext; 
  $NewContext = previous$NewContext; $PacletBase = previous$PacletBase; $NewPacletBase = previous$NewPacletBase)
          
ReplacePacletBaseDialog[] := 
 Module[{present$PackageName, present$NewPackageName, present$PresentContext, present$NewContext, present$PacletBase,
         present$NewPacletBase, r, s, t, u, v, w},
  present$PackageName = $PackageName;
  present$NewPackageName = $NewPackageName;
  present$PresentContext = $PresentContext;
  present$NewContext = $NewContext;
  present$PacletBase = $PacletBase;
  present$NewPacletBase = $NewPacletBase;
  Notebook[{Cell["", FontSize -> 1, CellElementSpacings -> {"CellMinHeight" -> 1}, Selectable -> False], 
   Cell["Replace the application name, context and link base as needed. Enter the \
package name and link base into the appropriate fields. Enter the context \
using the backquote where appropriate. Usually the link base is the same as \
the application name, but it does not have to be. If the old link base field \
is left blank, the new link base will be inserted into the paclet URIs and no \
link base replacement will take place.", "Text", FontFamily -> "Verdana", FontSize -> 11, CellMargins -> {{8, 125}, {7, 1}}], 
   Cell[BoxData[ToBoxes@Style[Grid[{{Style["Replace Paclet Data In: ", Bold, Editable -> False, Selectable -> False], 
                                     TextCell[$ReplacePacletBaseDirectory]}, 
                                    {Style["Application Name: ", Bold, Editable -> False, Selectable -> False], 
                                     InputField[Dynamic[$PackageName], String, FieldSize -> {40, {1, Infinity}}]}, 
                                    {Style["New Application Name: ", Bold, Editable -> False, Selectable -> False], 
                                     InputField[Dynamic[$NewPackageName], String, FieldSize -> {40, {1, Infinity}}]}, 
                                    {Style["Present Context: ", Bold, Editable -> False, Selectable -> False], 
                                     InputField[Dynamic[$PresentContext], String, FieldSize -> {40, {1, Infinity}}]}, 
                                    {Style["New Context: ", Bold, Editable -> False, Selectable -> False], 
                                     InputField[Dynamic[$NewContext], String, FieldSize -> {40, {1, Infinity}}]}, 
                                    {Style["Paclet Base: ", Bold, Editable -> False, Selectable -> False], 
                                     InputField[Dynamic[$PacletBase], String, FieldSize -> {40, {1, Infinity}}]}, 
                                    {Style["New Paclet Base: ", Bold, Editable -> False, Selectable -> False], 
                                     InputField[Dynamic[$NewPacletBase], String, FieldSize -> {40, {1, Infinity}}]}, 
                                    {"", OldRow[{Button[Style["OK", Bold],
                                                        If[StringMatchQ[$PacletBase, "" | Whitespace],
                                                           auxReplacePacletBase[$ReplacePacletBaseDirectory];
                                                           NotebookClose[EvaluationNotebook[]],
                                                           ReplacePacletBase[$ReplacePacletBaseDirectory]], 
                                                        Method -> "Queued"], 
                                                 Button[Style["Cancel", Bold],
                                                        CancelReplacePacletBaseDialog[r, s, t, u, v, w];
                                                        NotebookClose[EvaluationNotebook[]], 
                                                        Method -> "Queued"] /. {r -> present$PackageName,
                                                                                s -> present$NewPackageName,
                                                                                t -> present$PresentContext,
                                                                                u -> present$NewContext,
                                                                                v -> present$PacletBase,
                                                                                w -> present$NewPacletBase}}, 
                                                RowAlignments -> Center]}}, 
                                   Alignment -> Left, 
                                   Spacings -> {Automatic, {2 -> 1, 4 -> 1, 6 -> 1, 8 -> 1}}], 
        FontFamily -> "Verdana", FontSize -> 11]]], 
   Cell["", FontSize -> 1, CellElementSpacings -> {"CellMinHeight" -> 1}, Selectable -> False]}, 
          WindowMargins -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
          WindowFrame -> "Palette", 
          WindowElements -> {}, 
          WindowFrameElements -> {}, 
          ShowCellBracket -> False, 
          ClosingAutoSave -> False, 
          WindowTitle -> "Replace Paclet Base", 
          Saveable -> False, 
          ShowStringCharacters -> False, 
          Selectable -> False, 
          WindowSize -> {580, FitAll}]]
          
auxReplacePacletBase[replacePacletBaseDirectory_String] :=
 Module[{r}, 
  NotebookPut[Notebook[{Cell["", FontSize -> 1, CellElementSpacings -> {"CellMinHeight" -> 1}, Selectable -> False], 
     Cell[BoxData[ToBoxes@Style[Grid[{{Style["Do you intend that the new link base be inserted into paclet URIs without a link base?", 
                                             Editable -> False, Selectable -> False]}, 
                                      {Style["", Editable -> False, Selectable -> False]}, 
                                      {OldRow[{Button[Style["OK", Editable -> False, Deletable -> False, Bold], 
                                                      ReplacePacletBase[r], Method -> "Queued"] /. r -> replacePacletBaseDirectory, 
                                               Button[Style["Cancel", Editable -> False, Deletable -> False, Bold], 
                                                      NotebookClose[EvaluationNotebook[]], 
                                                      Method -> "Queued"]}]}}, ColumnAlignments -> Left], 
                               FontFamily -> "Helvetica"]]], 
                        Cell["", FontSize -> 1, CellElementSpacings -> {"CellMinHeight" -> 1}, Selectable -> False]}, 
                       WindowSize -> {500, FitAll}, 
                       WindowMargins -> {{Automatic, Automatic}, {Automatic, Automatic}},
                       WindowFrame -> "Palette", 
                       WindowElements -> {}, 
                       WindowFrameElements -> {}, 
                       ShowCellBracket -> False, 
                       ClosingAutoSave -> False, 
                       WindowTitle -> "Insert Link Base", 
                       Saveable -> False, 
                       ShowStringCharacters -> False]]]
          
ReplacePacletBase::empty = "At least one of the dialog fields besides the link base field is empty.";
ReplacePacletBase::backquote = "The package name fields as well as the paclet base fields should not contain a backquote (`).";
ReplacePacletBase::nobackquote = "The context fields must contain properly positioned backquotes (`).";

ReplacePacletBase[dir_String /; FileType[dir] === Directory] :=
 Module[{fi, orignotebooksdir, writeintometadata, pn, cs, cs2, str, gt, nb, gt2}, 
  Catch[If[StringMatchQ[$PackageName, "" | Whitespace] || StringMatchQ[$NewPackageName, "" | Whitespace] || 
           StringMatchQ[$PresentContext, "" | Whitespace] || StringMatchQ[$NewContext, "" | Whitespace] || 
           StringMatchQ[$NewPacletBase, "" | Whitespace], 
           Throw[MessageToConsole[ReplacePacletBase::empty]]];
        If[Not[And@@(StringFreeQ[#, "`"]&/@{$PackageName, $NewPackageName, $PacletBase, $NewPacletBase})],
           Throw[MessageToConsole[ReplacePacletBase::backquote]]];
        If[Not[And@@(StringMatchQ[#, __ ~~ "`"]&/@{$PresentContext, $NewContext})],
           Throw[MessageToConsole[ReplacePacletBase::nobackquote]]];
   SetOptions[$FrontEnd, DynamicUpdating -> False];
   
   If[(fi = FileNames["*.nb", {dir}]) =!= {}, 
   	   orignotebooksdir = ToFileName[{dir, "OriginalNotebooks"}];
   	   CreateDirectory[orignotebooksdir];
   	   CopyFile[#, ToFileName[{DirectoryName@#, "OriginalNotebooks"}, StringReplace[#, DirectoryName[#] -> ""]]] & /@ fi;
           DeleteFile[fi]];

  (writeintometadata = False; 
   Quiet[gt = Get[#]];
   
   If[(pn = Cases[gt, Cell[_String, "Categorization", ___, CellLabel -> "Paclet Name", ___], Infinity]) =!= {} && 
       $NewPackageName =!= StringReplace[pn[[1, 1]], " Package" -> ""],
       
      nb = NotebookOpen[#]; 
      NotebookFind[nb, "Paclet Name", All, CellLabel];
      NotebookWrite[nb, Cell[$NewPackageName <> " Package", "Categorization", CellLabel -> "Paclet Name"], All]; 
      writeintometadata = True];
      
   If[(cs = Cases[gt, Cell[_String, "Categorization", ___, CellLabel -> "Context", ___] | 
                      Cell[TextData[{__}], "Categorization", ___, CellLabel -> "Context", ___], Infinity]) =!= {} && 
          $NewContext =!= StringJoin @@ (If[StringQ[#], 
                                            #, 
                                            If[Head@# === StyleBox, #[[1]], #] & /@ #] &@(If[MatchQ[#, Cell[TextData[_], __]], 
                                                                                             #[[1, 1]], 
                                                                                             #[[1]]] &[cs[[1]]])),
      
      nb = NotebookOpen[#]; 
      NotebookFind[nb, "Context", All, CellLabel];
      NotebookWrite[nb, Cell[$NewContext, "Categorization", CellLabel -> "Context"], All]; 
      writeintometadata = True];
      
   If[((cs2 = Cases[gt, Cell[_String, "Categorization", ___, CellLabel -> "URI", ___] | 
                      Cell[TextData[{__}], "Categorization", ___, CellLabel -> "URI", ___], Infinity]) =!= {}) && 
      (((str = StringJoin @@ (If[StringQ[#], 
                              #, 
                              If[Head@# === StyleBox, #[[1]], #]] & /@ If[MatchQ[#, Cell[TextData[_], "Categorization", ___, CellLabel -> "URI", ___]], 
                                                                          #[[1, 1]], 
                                                                          #[[1]]] &[cs2[[1]]]))); 
      $NewPacletBase =!= StringReplace[str, Shortest[a__] ~~ "/" ~~ __ :> a]),
      
      nb = NotebookOpen[#];
      NotebookFind[nb, "URI", All, CellLabel];
      NotebookWrite[nb, Cell[StringReplace[str, $PacletBase ~~ a__ :> $NewPacletBase <> a], 
                             "Categorization", CellLabel -> "URI"], All];
      writeintometadata = True];
      
   If[writeintometadata, 
      FrontEndExecute[{FrontEndToken[nb, "ExpandSelection"]}];
      FrontEndExecute[{FrontEndToken[nb, "OpenCloseGroup"]}]; 
      NotebookSave[nb, ToFileName[{$ReplacePacletBaseDirectory}, StringReplace[#, DirectoryName[#] -> ""]]]
   ];
       
   Quiet[
     gt = Get[
        If[writeintometadata, 
          ToFileName[{$ReplacePacletBaseDirectory}, StringReplace[#, DirectoryName[#] -> ""]],
          #
        ]
      ]
    ];
   
   If[Cases[gt, ButtonBox[_String, ___, 
                          ButtonData -> x_String /; StringMatchQ[x, "paclet:" ~~ $PacletBase ~~ "/" ~~ __], ___] |
                ButtonBox[a_String, b___, 
                          ButtonData -> x_String /; StringMatchQ[x, "paclet:" ~~ _?LowerCaseQ ~~ (d___ /; StringFreeQ[d, "/"]) ~~ "/" ~~ __], c___], 
            Infinity] =!= {}, 
      nb = NotebookOpen[
        If[writeintometadata, 
          ToFileName[{$ReplacePacletBaseDirectory}, StringReplace[#, DirectoryName[#] -> ""]],
          #
        ]
      ];
      gt2 = gt /. {ButtonBox[a_String, b___, 
                             ButtonData -> x_String /; StringMatchQ[x, "paclet:" ~~ $PacletBase ~~ "/" ~~ __], c___] :> 
                   ButtonBox[a, b, ButtonData -> StringReplace[x, ("paclet:" ~~ $PacletBase ~~ "/" ~~ p__) :> 
                                                                              "paclet:" ~~ $NewPacletBase ~~ "/" ~~ p], c],
                   ButtonBox[a_String, b___, 
                             ButtonData -> x_String /; StringMatchQ[x, "paclet:" ~~ _?LowerCaseQ ~~ (d___ /; StringFreeQ[d, "/"]) ~~ "/" ~~ __], c___] :> 
                   ButtonBox[a, b, ButtonData -> StringReplace[x, "paclet:" -> "paclet:" <> $NewPacletBase <> "/"], c]}; 
      NotebookPut[gt2, nb]; 
      NotebookSave[nb,
        ToFileName[{$ReplacePacletBaseDirectory}, StringReplace[#, DirectoryName[#] -> ""]]
      ]
   ]; 
   writeintometadata = False; 
   If[Head[nb] === NotebookObject, NotebookClose[nb]]) & /@ FileNames["*.nb", ToFileName[{$ReplacePacletBaseDirectory, "OriginalNotebooks"}]]; 
   NotebookClose[EvaluationNotebook[]]; 
   SetOptions[$FrontEnd, DynamicUpdating -> True]]]
   
 
$NewSymbolName = ""

$NewGuideTitle = ""

$NewOverviewTitle = ""

$NewTutorialTitle = ""

DisplayBlankPage[pagetype_] := 
 Module[{nb}, 
  nb = DocumentTemplate[
  Switch[pagetype, "Reference", "FunctionBaseTemplateExt.nb", "Guide", "GuideBaseTemplateExt.nb", "Overview", "OverviewBaseTemplate.nb", 
         _, "TutorialBaseTemplateExt.nb"]];
  If[Cases[Options[$FrontEnd, TaggingRules], a : ("ShowMetaDataMessage2" -> b_) :> b, 5] =!= {"False"}, 
     NotebookFind[nb, "Entity Type", All, CellLabel];
     FrontEndTokenExecute[nb, "ExpandSelection"];
     DisplayMetadataMessage2[]];
  Switch[pagetype, "Reference", $NewSymbolName = "", "Guide", $NewGuideTitle = "", "Overview", $NewOverviewTitle = "", _, $NewTutorialTitle = ""];
  NotebookClose[EvaluationNotebook[]]]

CreateNewPage::missingtemplate = "The `1` Page template is missing from the DocuTools layout."; 
CreateNewPage::symname = "The Function Name field must contain a nonempty string free of white space."; 
CreateNewPage::page = "The `1` Page field must contain a nonempty string.";
CreateNewPage::alreadyexists = "The `1` directory already contains a file corresponding to `2`.";

CreateNewPage[nameortitle_String, pagetype_String] := 
 Module[{templatefile, gt, filename, nb}, 
  templatefile = ToFileName[{$DocuToolsDir, "FrontEnd", "TextResources"}, 
                          Switch[pagetype, "Reference", "FunctionBaseTemplateExt.nb", "Guide", "GuideBaseTemplateExt.nb", "Overview", 
                                 "OverviewBaseTemplate.nb", _, "TutorialBaseTemplateExt.nb"]];
                          
  Catch[If[FileType[templatefile] === File, 
           gt = Get[templatefile], 
           Throw[MessageToConsole[CreateNewPage::missingtemplate, pagetype]]];
        
        Switch[pagetype, 
               "Reference", 
               If[Not[StringQ[$NewSymbolName]] || $NewSymbolName === "" || Not@StringFreeQ[$NewSymbolName, Whitespace], 
                  Throw[DisplayBlankPage["Reference"]]], 
               "Guide", 
               If[Not[StringQ[$NewGuideTitle]] || StringMatchQ[$NewGuideTitle, "" | Whitespace], 
                  Throw[DisplayBlankPage["Guide"]]], 
               "Overview", 
               If[Not[StringQ[$NewOverviewTitle]] || StringMatchQ[$NewOverviewTitle, "" | Whitespace], 
                  Throw[DisplayBlankPage["Overview"]]], 
               _, 
               If[Not[StringQ[$NewTutorialTitle]] || StringMatchQ[$NewTutorialTitle, "" | Whitespace], 
                  Throw[DisplayBlankPage["Tutorial"]]]];
                  
        filename = If[MemberQ[{"Guide", "Tutorial"}, pagetype],
                      ReplaceAmpersand@#,
                      #] &[TitleReduce[nameortitle]];
                  
        Switch[pagetype, 
               "Reference", 
               If[MemberQ[FileNames["*.nb", {$FunctionDirectory}], ToFileName[{$FunctionDirectory}, filename <> ".nb"]], 
                  Throw[MessageToConsole[CreateNewPage::alreadyexists, "Symbols", $NewSymbolName]]], 
               "Guide", 
               If[MemberQ[FileNames["*.nb", {$GuideDirectory}], ToFileName[{$GuideDirectory}, filename <> ".nb"]], 
                  Throw[MessageToConsole[CreateNewPage::alreadyexists, "Guides", $NewGuideTitle]]], 
               "Overview", 
               If[MemberQ[FileNames["*.nb", {$TutorialDirectory}], ToFileName[{$TutorialDirectory}, filename <> ".nb"]], 
                  Throw[MessageToConsole[CreateNewPage::alreadyexists, "Guides", $NewOverviewTitle]]], 
               _, 
               If[MemberQ[FileNames["*.nb", {$TutorialDirectory}], ToFileName[{$TutorialDirectory}, filename <> ".nb"]], 
                  Throw[MessageToConsole[CreateNewPage::alreadyexists, "Tutorials", $NewTutorialTitle]]]];
                  
        nb = NotebookPut[gt /. {RuleDelayed @@ (Cell["", "Categorization", CellLabel -> "Paclet Name", a__] -> 
                                 Cell[$LinkBase <> " Package", "Categorization", CellLabel -> "Paclet Name", a]),
                                RuleDelayed @@ (Cell["", "Categorization", CellLabel -> "Context", a__] -> 
                                 Cell[$ApplicationName <> "`", "Categorization", CellLabel -> "Context", a]),
                                RuleDelayed @@ (Cell["XXXX", "Categorization", CellLabel -> "URI", a___] -> 
                                 Cell[StringJoin[$LinkBase, 
                                                 Switch[pagetype, "Reference", "/ref/", "Guide", "/guide/", _, "/tutorial/"],
                                                 filename], "Categorization", CellLabel -> "URI", a]), 
                                RuleDelayed @@ (Cell["XXXX", "ObjectName", a___] -> Cell[nameortitle, "ObjectName", a]), 
                                RuleDelayed @@ (Cell[TextData[{Cell["   ", "ModInfo"], Cell[BoxData[RowBox[{"XXXX", "[", "]"}]], "InlineFormula"], 
                                                               " \[LineSeparator]XXXX"}], "Usage", a___] -> 
                                 Cell[TextData[{Cell["   ", "ModInfo"], Cell[BoxData[RowBox[{StringTrim[nameortitle], "[", "]"}]], "InlineFormula"], 
                                                " \[LineSeparator]XXXX"}], "Usage", a]), 
                                RuleDelayed @@ (Cell["XXXX", "GuideTitle", a___] -> Cell[StringTrim[nameortitle], 
                                                                                         "GuideTitle", a]), 
                                RuleDelayed @@ (Cell["XXXX", "Title", a___] -> Cell[StringTrim[nameortitle], "Title", a]),
                                RuleDelayed @@ (Cell["XXXX", "TOCDocumentTitle", a___] -> Cell[StringTrim[nameortitle], "TOCDocumentTitle", a])}];
                                
         NotebookSave[nb, Switch[pagetype, 
                                 "Reference", 
                                 ToFileName[{$FunctionDirectory}, filename <> ".nb"], 
                                 "Guide", 
                                 ToFileName[{$GuideDirectory}, filename <> ".nb"], 
                                 _, 
                                 ToFileName[{$TutorialDirectory}, filename <> ".nb"]]];       
                                                                                                  
        Switch[pagetype, "Reference", $NewSymbolName = "", "Guide", $NewGuideTitle = "", "Overview", $NewOverviewTitle = "", _, $NewTutorialTitle = ""];
                                
        If[Cases[Options[$FrontEnd, TaggingRules], a:("ShowMetaDataMessage" -> b_) :> b, 5] =!= {"False"}, 
           NotebookFind[nb, "Entity Type", All, CellLabel]; 
           FrontEndTokenExecute[nb, "ExpandSelection"]; 
           DisplayMetadataMessage[]];
           
        NotebookClose[EvaluationNotebook[]]]]
    
DisplayMetadataMessage[] := 
 NotebookPut@Notebook[{Cell["", FontSize -> 1, CellElementSpacings -> {"CellMinHeight" -> 1}], 
    Cell["The metadata at the top of this new page is based on current application name settings. This metadata is important for build system processes. For reference pages in particular, if you intend that the documented symbol appear in a subcontext, modify the Context cell.", 
         "Text", FontFamily -> "Verdana", FontSize -> 11, CellMargins -> {{8, 30}, {7, 1}}], 
    Cell[BoxData[ToBoxes@Style[
        Grid[{{"", OldRow[{DefaultButton[], CancelButton[" Don't Show Again ", 
                                                         SetDocuToolsParametersInFEInit[{"ShowMetaDataMessage" -> "False"}]; 
                                                         NotebookClose[EvaluationNotebook[]]]}, 
             RowAlignments -> Center]}}, 
             Alignment -> Left, 
            Spacings -> {Automatic, {4 -> .5, 5 -> 1}}], 
        FontFamily -> "Verdana", FontSize -> 11]]], 
    Cell["", FontSize -> 1, CellElementSpacings -> {"CellMinHeight" -> 1}]}, 
                      WindowMargins -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
                      WindowFrame -> "Palette", 
                      WindowElements -> {}, 
                      WindowFrameElements -> {}, 
                      ShowCellBracket -> False, 
                      ClosingAutoSave -> False, 
                      WindowTitle -> "", 
                      NotebookEventActions -> {"ReturnKeyDown" :> (NotebookClose[EvaluationNotebook[]])}, 
                      Saveable -> False, 
                      ShowStringCharacters -> False, 
                      Selectable -> False, 
                      WindowSize -> {500, FitAll}]
                      
DisplayMetadataMessage2[] := 
 NotebookPut@Notebook[{Cell["", FontSize -> 1, CellElementSpacings -> {"CellMinHeight" -> 1}], 
    Cell["You must add appropriate metadata to this new page. The metadata is important for build system processes.", 
         "Text", FontFamily -> "Verdana", FontSize -> 11, CellMargins -> {{8, 30}, {7, 1}}], 
    Cell[BoxData[ToBoxes@Style[
        Grid[{{"", OldRow[{DefaultButton[], CancelButton[" Don't Show Again ", 
                                                         SetDocuToolsParametersInFEInit[{"ShowMetaDataMessage2" -> "False"}]; 
                                                         NotebookClose[EvaluationNotebook[]]]}, 
             RowAlignments -> Center]}}, 
             Alignment -> Left, 
            Spacings -> {Automatic, {4 -> .5, 5 -> 1}}], 
        FontFamily -> "Verdana", FontSize -> 11]]], 
    Cell["", FontSize -> 1, CellElementSpacings -> {"CellMinHeight" -> 1}]}, 
                      WindowMargins -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
                      WindowFrame -> "Palette", 
                      WindowElements -> {}, 
                      WindowFrameElements -> {}, 
                      ShowCellBracket -> False, 
                      ClosingAutoSave -> False, 
                      WindowTitle -> "", 
                      NotebookEventActions -> {"ReturnKeyDown" :> (NotebookClose[EvaluationNotebook[]])}, 
                      Saveable -> False, 
                      ShowStringCharacters -> False, 
                      Selectable -> False, 
                      WindowSize -> {430, FitAll}]
   
AuxiliaryCreateNewPageDialog[pagetype_]:=
Switch[pagetype, "Reference", CreateNewPage[$NewSymbolName, pagetype], "Guide", CreateNewPage[$NewGuideTitle, pagetype],
       _, CreateNewPage[$NewTutorialTitle, pagetype]]
       
AuxiliaryCreateNewPageDialog2[pagetype_String] := 
 Module[{nb}, 
  NotebookPut[Notebook[{Cell["", FontSize -> 1, CellElementSpacings -> {"CellMinHeight" -> 1}], 
      Cell[BoxData[ToBoxes@Style[Grid[{{"First set the paclet directory for your application."}, 
                                       {OldRow[{Button[Style["OK", Bold], NotebookClose[EvaluationNotebook[]];
                                                                          DocumentationDirSelect["Interactive" -> True], 
                                                       Method -> "Queued"], 
                                                Button[Style["Ignore", Bold], 
                                                       (nb = DocumentTemplate[Switch[pagetype, "Reference", "FunctionBaseTemplateExt.nb", "Guide", 
                                                                                     "GuideBaseTemplateExt.nb", "Overview", "OverviewBaseTemplate.nb", _, 
                                                                                     "TutorialBaseTemplateExt.nb"]];
                 
                                                       If[Cases[Options[$FrontEnd, TaggingRules], a : ("ShowMetaDataMessage2" -> b_) :> b, 5] =!= {"False"}, 
                                                       NotebookFind[nb, "Entity Type", All, CellLabel];
                                                       FrontEndTokenExecute[nb, "ExpandSelection"];
                                                       DisplayMetadataMessage2[]];
                                                       NotebookClose[EvaluationNotebook[]]), 
                                                       Method -> "Queued"], 
                                                Button[Style["Cancel", Bold], 
                                                       NotebookClose[EvaluationNotebook[]]]}, 
                                               RowAlignments -> Center]}}, 
                                      Alignment -> Left, 
                                      Spacings -> {Automatic, {1 -> .5, 2 -> 1}}], 
                                 FontFamily -> "Verdana", FontSize -> 11]], 
           CellContext -> "Global`"], 
                             Cell["", FontSize -> 1, CellElementSpacings -> {"CellMinHeight" -> 1}]}, 
                            WindowMargins -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
                            WindowFrame -> "Palette", 
                            WindowElements -> {}, 
                            WindowFrameElements -> {}, 
                            ShowCellBracket -> False, 
                            ClosingAutoSave -> False, 
                            WindowTitle -> "New " <> pagetype <> " Page", 
                            NotebookEventActions -> ({"ReturnKeyDown" :> 
                            DocumentationDirSelect["Interactive" -> True]}), 
                            Saveable -> False, ShowStringCharacters -> False, 
                            Selectable -> False, 
                            WindowSize -> {530, FitAll}]]]

(* FrontEndTokenExecute[nb, "Tab"] is put into NotebookEventActions because without it the changed value of $NewSymbolName for example in the input field
   does not register. *)

CreateNewPageDialog[pagetype_String] := 
 Module[{nb, pt},
  If[Not@StringQ[$ApplicationName] || StringMatchQ[$ApplicationName, "" | Whitespace] || Not@StringQ[$LinkBase] || StringMatchQ[$LinkBase, "" | Whitespace], 
     AuxiliaryCreateNewPageDialog2[pagetype],
nb = NotebookPut[Notebook[{Cell["", FontSize -> 1, CellElementSpacings -> {"CellMinHeight" -> 1}], 
                           Cell[BoxData[ToBoxes@Style[
                                         Grid[{{Style[Switch[pagetype, "Reference", "Function Name", "Guide", "Guide Title", "Overview", "Overview Title", 
                                                             _, "Tutorial Title"] <> ": ", 
                           Bold, Editable -> False], 
                                                Switch[pagetype, "Reference", InputField[Dynamic[$NewSymbolName], String, FieldSize -> {41, {1, Infinity}}], 
                                                                 "Guide", InputField[Dynamic[$NewGuideTitle], String, FieldSize -> {41, {1, Infinity}}],
                                                                 "Overview", InputField[Dynamic[$NewOverviewTitle], String, FieldSize -> {41, {1, Infinity}}],
                                                                 _, InputField[Dynamic[$NewTutorialTitle], String, FieldSize -> {41, {1, Infinity}}]]}, 
                                               {"", OldRow[{Button[Style["OK", Bold],
            Switch[pt, "Reference", CreateNewPage[$NewSymbolName, pt], "Guide", CreateNewPage[$NewGuideTitle, pt], "Overview", 
                   CreateNewPage[$NewOverviewTitle, pt], _, CreateNewPage[$NewTutorialTitle, pt]], 
                                                                   Method -> "Queued"] /. pt -> pagetype, 
                                                            Button[Style["Ignore", Bold], 
                                                                   DisplayBlankPage[pt], Method -> "Queued"] /. pt -> pagetype, 
                                                            Button[Style["Cancel", Bold], 
                                                    (Switch[pt, "Reference", $NewSymbolName = "", "Guide", $NewGuideTitle = "", "Overview", 
                                                            $NewOverviewTitle = "", _, $NewTutorialTitle = ""];
                                                     NotebookClose[EvaluationNotebook[]]), 
                                                                   Method -> "Queued"] /. pt -> pagetype}, 
                                                           RowAlignments -> Center]}}, 
                                              Alignment -> Left, 
                                              Spacings -> {Automatic, {4 -> .5, 5 -> 1}}], 
                                                      FontFamily -> "Verdana", FontSize -> 11]], 
                                CellContext -> "Global`"], 
                           Cell["", FontSize -> 1, CellElementSpacings -> {"CellMinHeight" -> 1}]}, 
                          WindowMargins -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
                          WindowFrame -> "Palette", 
                          WindowElements -> {}, 
                          WindowFrameElements -> {}, 
                          ShowCellBracket -> False, 
                          ClosingAutoSave -> False, 
                          WindowTitle -> "New " <> pagetype <> " Page", 
        NotebookEventActions -> ({"ReturnKeyDown" :> (FrontEndTokenExecute[nb, "Tab"];AuxiliaryCreateNewPageDialog[pt])} /. pt -> pagetype), 
                          Saveable -> False, ShowStringCharacters -> False, 
                          Selectable -> False, 
                          WindowSize -> {530, FitAll}]];
 SelectionMove[nb, Before, Notebook]; 
 SelectionMove[nb, Next, Cell, 2]; 
 SelectionMove[nb, After, CellContents]; 
 FrontEndTokenExecute[nb, "Tab"];
 SetSelectedNotebook[nb]]]

(* Functions for creating all reference pages for an application using a dialog. *)

$ReferencePagesDirectory = "";
$Templatize = True;
      
CreateReferencePages[] :=
 Quiet[$ReferencePagesDirectory = SystemDialogInput["Directory", $FunctionDirectory, WindowTitle -> "Choose a directory to create reference pages in."]; 
       If[FileType[$ReferencePagesDirectory] === Directory, 
          NotebookPut[CreateReferencePagesDialog[]],
          $ReferencePagesDirectory = ""],
       FileType::"fstr"]
       
CreateReferencePagesDialog[] := 
 Module[{s, t, u, v}, 
 s = DocumentationTools`$ApplicationName; t = DocumentationTools`$LinkBase;
 Notebook[{Cell["", FontSize -> 1, CellElementSpacings -> {"CellMinHeight" -> 1}, Selectable -> False], 
           Cell["Reference Pages will be created in the indicated directory.", 
                "Text", FontFamily -> "Verdana", FontSize -> 11, CellMargins -> {{8, 30}, {7, 1}}], 
           Cell[BoxData[ToBoxes@Style[Grid[{{Style["Directory: ", Bold, Editable -> False, Selectable -> False], 
                                             TextCell[$ReferencePagesDirectory]}, 
                                            {Style["Application Name: ", Bold, Editable -> False, Selectable -> False],
                                             InputField[Dynamic[DocumentationTools`$ApplicationName], String, FieldSize -> {41, {1, Infinity}}]}, 
                                            {Style["Link Base: ", Bold, Editable -> False, Selectable -> False],
                                             InputField[Dynamic[DocumentationTools`$LinkBase], String, FieldSize -> {41, {1, Infinity}}]},
                                            {Style["Format templates: ", Bold, Editable -> False, Selectable -> False],
                                             Checkbox[Dynamic[$Templatize]]}, 
                                            {"", OldRow[{Button[Style["OK", Bold],
                                                                UpdatePacletVariables[u, v];
                                                                NotebookClose[];
                                                                AuxiliaryCreateReferencePages[$ReferencePagesDirectory], 
                                                                Method -> "Queued"] /. {u -> s, v -> t}, 
                                                         Button[Style["Cancel", Bold], 
                                                                (DocumentationTools`$ApplicationName = u; DocumentationTools`$LinkBase = v;
                                                                 NotebookClose[EvaluationNotebook[]]), 
                                                                Method -> "Queued"] /. {u -> s, v -> t}}, 
                                                        RowAlignments -> Center]}}, 
                                           Alignment -> Left, Spacings -> {Automatic, {4 -> .5, 5 -> 1}}], 
                                      FontFamily -> "Verdana", FontSize -> 11]]], 
          Cell["", FontSize -> 1, CellElementSpacings -> {"CellMinHeight" -> 1}, Selectable -> False]}, 
          WindowMargins -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
          WindowFrame -> "Palette", 
          WindowElements -> {}, 
          WindowFrameElements -> {}, 
          ShowCellBracket -> False, 
          ClosingAutoSave -> False, 
          WindowTitle -> "Create Reference Pages", 
          Saveable -> False, 
          ShowStringCharacters -> False, 
          Selectable -> False, 
          WindowSize -> {530, FitAll}]]
          

SymbolsWithUsage[applicationname_] := 
 Select[Union[Complement[#, Flatten@StringCases[#, __ ~~ "`Private`" ~~ __]] &[Names[DocumentationTools`$ApplicationName <> "`*`*"]], 
              Names[DocumentationTools`$ApplicationName <> "`*"]], 
        Function[{symname}, ToExpression[symname, InputForm, Function[{symb}, Messages[symb] =!= {} && StringQ@MessageName[symb, "usage"], 
                 HoldFirst]]]]
                 
OldPartitionUsageString[usagepart_, pagesymbol_] := 
 Partition[
  Flatten[StringSplit[usagepart, {c : StartOfString ~~ b : (pagesymbol <> "[" ~~ Longest[(a___ /; StringFreeQ[a, "]"])] ~~ "]") :> c ~~ b, 
      c : Longest[(__ ~~ ". ")] ~~ b : (pagesymbol <> "[" ~~ Longest[(a___ /; StringFreeQ[a, "]"])] ~~ "]") :> {c, b}, 
      StartOfString ~~ pagesymbol -> StartOfString ~~ pagesymbol}] /. "" -> Sequence[]], 2]
    
(* This partitions a usage string into pairs. Each pair consists of a usage template followed by the string giving the functionality for that template. *)

PartitionUsageString[usagepart_, pagesymbol_] := 
 Partition[
  Flatten[FixedPoint[StringSplit[#, {c : StartOfString ~~ b : (pagesymbol <> "[" ~~ Longest[(a___ /; StringFreeQ[a, "]"])] ~~ "]") :> c ~~ b, 
                                     c : Longest[(__ ~~ ". ")] ~~ b : (pagesymbol <> "[" ~~ Longest[(a___ /; StringFreeQ[a, "]"])] ~~ "]") :> {c, b},
                 StartOfString ~~ pagesymbol :> StartOfString ~~ pagesymbol}] /. "" -> Sequence[] & /@ If[StringQ[#], {#}, Flatten[#]] &, usagepart]], 2]

link[x_]:= 
 If[MemberQ[$ApplicationSymbolsWithUsage, x], 
     ButtonBox[x, BaseStyle -> "Link", ButtonData -> "paclet:" <> DocumentationTools`$LinkBase <> "/ref/" <> x], 
     x]
        
ModifyStringPairSymbolNameAndUse[pair_] := 
 If[Not[StringQ[#[[-1]]]] || (StringQ[#[[-1]]] && StringFreeQ[#[[-1]], "\n"]),
    #, 
    Replace[#, {a__, b_} :> {a, StringReplace[b, "\n" -> ""]}]] &[Flatten[{Cell["   ", "ModInfo"], #[[1]], 
         link/@ 
          Prepend[FixedPoint[
            Replace[#, {a___, b_, " ", "->", " ", c_, d___} :> 
             {a, Cell[BoxData[RowBox[{link[b], "->", link[c]}]], "InlineFormula"], d}] &, 
            StringSplit[#[[2]], {" " -> " ", "," -> ",", "." -> ".", ":" -> ":"}]], "\[LineSeparator]"]} //. 
            {Longest[b__String], c___} :> {StringJoin[b], c} //. {a___, Longest[b__String]} :> {a, StringJoin[b]} //. 
            {a___, Longest[b__String], c___} :> {a, StringJoin[b], c}]&[pair]]
            
StringReplaceRepeated[s_String, rules___] := FixedPoint[StringReplace[#, rules] &, s]

InsertDollarsInString[str_String, pagesymbol_] := 
 StringReplaceRepeated[
  StringReplaceRepeated[str, 
             pagesymbol <> "[" ~~ a___ ~~ b : LetterCharacter ~~ c : DigitCharacter ~~ d___ ~~ "]" :> pagesymbol <> "[" ~~ a ~~ b ~~ "$" ~~ c ~~ d ~~ "]"], 
                       pagesymbol <> "[" ~~ a__ ~~ "..." ~~ b___ ~~ "]" :> pagesymbol <> "[" ~~ a ~~ " $$" ~~ b ~~ "]"]

(* This cannot be used due to a transient FE token bug: *)

ExpandToExpressionWithBalancedBrackets[nb_] := 
 Module[{re, i}, i = 1; 
        While[re = NotebookRead[nb]; 
              StringCount[re, "["] =!= StringCount[re, "]"] && i < 500, 
              FrontEndExecute[FrontEndExecute[FrontEndToken[nb, "SelectNext"]]]; 
              i++]; re]
              
BracketList[symbollist_, string_] := 
 Join[Flatten[Function[t, {t, #} & /@ StringPosition[string, t]] /@ symbollist, 1], {"[", #} & /@ StringPosition[string, "["], {"]", #} & /@ 
                                                                                                                              StringPosition[string, "]"]]
                                                                                                                              
(* The following function will be used instead: *)

SubstringsWithSymbolsToTemplatize[string_, symbollist_] := 
 Module[{ss = SortBy[BracketList[symbollist, string], Max@#[[2]] &], numberpairs, a1, a2, j1, len1, s1, s2, len, i},
 
        (* The first piece of code handles situations such as
        
           {{"DataList2QuantileList", {1, 21}}, {"QuantileList", {10, 21}}, {"[", {22, 22}}, {"]", {31, 31}}, {"la", {117, 118}}, 
            {"QuantileRange", {195, 207}}} 
            
            and eliminates {"QuantileList", {10, 21}}. *)
 
        numberpairs = Last /@ ss;
        
        len1 = Length@numberpairs; 
        If[len1 > 0, a1 = {numberpairs[[1]]}; a2 = {}; j1 = 2;
           If[len1 > 1, 
	      While[j1 <= len1, 
	            If[IntervalUnion[Interval[Sequence @@ a1], Interval[numberpairs[[j1]]]] === Interval[Sequence @@ a1], 
	               AppendTo[a2, numberpairs[[j1]]], 
	               AppendTo[a1, numberpairs[[j1]]]]; 
	            j1++]]; 
	   ss = If[len1 > 1 && a2 =!= {}, ss /. ({_, #} -> Sequence[] & /@ a2), ss]];
 
        s1 = {}; s2 = {}; len = Length@ss; i = 1; 
        Catch[While[i <= len + 1, 
                    Which[FreeQ[s1, "["], 
                          If[MatchQ[ss, {{_?(MemberQ[symbollist, #] &), _} ..}], Throw[Null], AppendTo[s1, ss[[i]]]; i++], 
                          Count[s1, "[", 2] =!= Count[s1, "]", 2], 
                          AppendTo[s1, ss[[i]]]; i++, 
                          True, 
                          If[i <= len, 
                             AppendTo[s2, s1]; s1 = {}; ss = Take[ss, {i, len}]; len = len - (i - 1); i = 1, 
                             AppendTo[s2, s1]; i++]]]];
                             
       (* This comes from an application
       
       {{{"QuarterWavelengthAmplification", {1, 30}}, {"[", {31, 31}}, {"]", {49, 49}}}, {{"fo", {80, 81}}, {"[", {162, 162}}, {"]", {195, 195}}}}
       
          where "fo" is a symbol in the application. It should be eliminated because 81 and 162 indicate that "[" does not immediately follow "fo". *)
                             
       s2 = DeleteCases[s2 /. {{_?(MemberQ[symbollist, #] &), _} .., c : {b_String /; MemberQ[symbollist, b], _}, {"[", d_}, e__} :> {c, {"[", d}, e},
                        {{_?(MemberQ[symbollist, #] &), _} ..., 
                         {b_String /; MemberQ[symbollist, b], {c_, d_Integer}}, {"[", {e_Integer, f_}}, g__} /; e > d + 1];
       
       StringTake[string, #] & /@ Cases[s2, a : {{b_ /; MemberQ[symbollist, b], _}, __} :> ({Min@#, Max@#} &@Cases[a, _Integer, 3])]]
                    
(* An enhancement of the following function could also be used in addition to the previous to catch strings like f[h[x]]. *)
       
OtherSubstringsWithBracketsToTemplatize[string_, symbollist_] := 
 Module[{spl}, 
        spl = StringSplit[string]; 
        Cases[Pick[spl, StringMatchQ[spl, ___ ~~ "[" | "]" ~~ ___]], 
              x_ /; StringCount[x, "["] === StringCount[x, "]"] && Not@StringMatchQ[x, StartOfString ~~ (b__ /; MemberQ[symbollist, b]) ~~ __]] /. 
                                                                   x_String /; StringMatchQ[x, __ ~~ "]" ~~ ("." | "," | ";" | ":")] :> StringDrop[x, -1]]

buttonCell[stringsymbol_] := 
 Cell[BoxData[ButtonBox[stringsymbol, 
                        ButtonFunction :> NotebookOpen[ToFileName[{ParentDirectory[NotebookDirectory[EvaluationNotebook[]]]}, stringsymbol<>".nb"]], 
                        ButtonFrame -> "DialogBox",
                        Active->True,
                        Evaluator->Automatic]], "Text"]
                        
(* LoadApplicationName is designed to be used within the body of code for other functions that will have a Catch. *)

LoadApplicationName[]:=
    ($Old$Path = $Path;
    If[StringQ[$ApplicationDirectory] && FileType[$ApplicationDirectory] === Directory && Not@MemberQ[$Path, $ApplicationDirectory], 
       AppendTo[$Path, $ApplicationDirectory]];
       DocumentationTools`$PresentBeginTime = Round[AbsoluteTime[]];
       $LoadApplicationNotebook = (NotebookPut[Notebook[{Cell["x","Text"]}, Visible -> False,
    NotebookDynamicExpression :> Refresh[Catch[If[(* 1 second has passed since the Load button has been clicked. *)
                                                  Round[AbsoluteTime[]] > DocumentationTools`$PresentBeginTime + 1, 
      Which[(* The package does not exist or has the wrong structure. *)
            Not[MemberQ[$Packages, DocumentationTools`$ApplicationName <> "`"] || MemberQ[$Packages, x_String /; StringMatchQ[x, DocumentationTools`$ApplicationName <> "`*`"]]], 
            Throw[DocumentationTools`MessageToConsole[LoadApplication::failure]; NotebookClose[]; $Path = DocumentationTools`$Old$Path], 
            Not@MemberQ[$ContextPath, DocumentationTools`$ApplicationName <> "`"], 
            $ApplicationLoadPalette[]; NotebookClose[]]]],
                                         UpdateInterval -> 1]]]);
       Quiet[Needs[DocumentationTools`$LinkBase <> "`"]];
       If[MemberQ[Notebooks[], $LoadApplicationNotebook], NotebookClose[$LoadApplicationNotebook]];
       If[Not[MemberQ[$Packages, DocumentationTools`$ApplicationName <> "`"] || MemberQ[$Packages, x_String /; StringMatchQ[x, DocumentationTools`$ApplicationName <> "`*`"]]], 
          Throw[DocumentationTools`MessageToConsole[LoadApplication::failure]; $Path = DocumentationTools`$Old$Path]])

AuxiliaryCreateReferencePages::noappname = "The application name has not been specified. Define $ApplicationName.";
AuxiliaryCreateReferencePages::nolinkbase = "The link base has not been specified. Define $LinkBase.";
AuxiliaryCreateReferencePages::backquote = "The application name should not contain a backquote (`).";
AuxiliaryCreateReferencePages::nosymbolswithusage = "No symbols have been found with usage messages for `1`.";

Options[AuxiliaryCreateReferencePages] = {JustAddNonexistingPages -> False, OverwriteSymbolPages -> False}

(* The argument of AuxiliaryCreateReferencePages takes a directory or a function name (string) that is one of $LinkBase's symbols. *)

AuxiliaryCreateReferencePages[s_, opts___] /; (StringQ[s] && Quiet[FileType[s] === Directory]) || VectorQ[s, StringQ] :=
 Module[{justadd, overwrite, presetMessageOptionsValues, newMessageOptionsValues, cs, origrefpagesdir, SystemNames, fi, filenames,
         ToStringFromInlineFormulaRules, TransformListOfStrings, UsageComments1, UsageNotString, UsageCommentsNewline, UsageContainsNewLine,
         UsageComments2, UsageBeginningNotSymbol, UsageComments3, UsageContainsSubscript, nb, usage1, usage2, usage3, nbexpr, pagesymbol,
         usage, usagepart, table, g, id, sws, cf, strings, stringstotemplatizeintable, rpd, rpf, rpnb},
         
  justadd = JustAddNonexistingPages /. {opts} /. Options[AuxiliaryCreateReferencePages];
  overwrite = OverwriteSymbolPages /. {opts} /. Options[AuxiliaryCreateReferencePages];
         
  (* In the case that the argument is a string which is not a directory, the code will skip some steps and assume $ApplicationName and $LinkBase have been
     properly defined. It also assumes $ReferencePagesDirectory has been defined as well -- the reference page for s will be created in 
     $ReferencePagesDirectory. Also assumed is that $LinkBase has been loaded. In addition $ApplicationSymbolsWithUsage should be computed before
     using AuxiliaryCreateReferencePages via $ApplicationSymbolsWithUsage = Sort[SymbolsWithUsage[$ApplicationName], StringLength@#1 > StringLength@#2 &]. *)
  
 Quiet[Catch[If[FileType[s] === Directory,
  
          If[Not@StringQ[DocumentationTools`$ApplicationName] || StringMatchQ[DocumentationTools`$ApplicationName, "" | Whitespace], 
             Throw[MessageToConsole[AuxiliaryCreateReferencePages::noappname]; 
                   SetSelectedNotebook[MessagesNotebook[]]]];
                 
          If[Not@StringQ[DocumentationTools`$LinkBase] || StringMatchQ[DocumentationTools`$LinkBase, "" | Whitespace], 
	     Throw[MessageToConsole[AuxiliaryCreateReferencePages::nolinkbase]; 
                   SetSelectedNotebook[MessagesNotebook[]]]];
                 
          If[Not@StringFreeQ[DocumentationTools`$ApplicationName, "`"], 
             Throw[MessageToConsole[AuxiliaryCreateReferencePages::backquote]; 
                   SetSelectedNotebook[MessagesNotebook[]]]];
                 
          presetMessageOptionsValues = MessageOptions /. Options[$FrontEnd, MessageOptions];
        
          (* New MessageOptions has "KernelMessageAction" with "PrintToConsole". *)
        
          newMessageOptionsValues = If[(cs = Cases[presetMessageOptionsValues, a : ("KernelMessageAction" -> _)]; cs) === {}, 
                                       Append[presetMessageOptionsValues, 
                                              "KernelMessageAction" -> {"Beep", "PrintToNotebook"}], 
presetMessageOptionsValues /. ("KernelMessageAction" -> a_) :> ("KernelMessageAction" -> If[StringQ[a], 
                                                                                            "PrintToConsole", 
                                                                                   Append[DeleteCases[a, "PrintToNotebook"], 
                                                                                          "PrintToConsole"]])]; 
          SetOptions[$FrontEnd, MessageOptions -> newMessageOptionsValues];
        
          LoadApplicationName[];
        
          (* The sorting is done for templatizing purposes. *)
        
          $ApplicationSymbolsWithUsage = Sort[SymbolsWithUsage[DocumentationTools`$ApplicationName], StringLength@#1 > StringLength@#2 &];
	           
          If[$ApplicationSymbolsWithUsage === {}, 
             Throw[MessageToConsole[AuxiliaryCreateReferencePages::nosymbolswithusage, DocumentationTools`$LinkBase]]];
        
          (* Restore previous MessageOptions. *)
        
          SetOptions[$FrontEnd, MessageOptions -> presetMessageOptionsValues]];
          
        If[VectorQ[s, StringQ], 
           Quiet[LoadApplicationName[];
           $ApplicationSymbolsWithUsage = Sort[SymbolsWithUsage[DocumentationTools`$ApplicationName], StringLength@#1 > StringLength@#2 &]]];
        
        SystemNames = Names["System`*"];
        
        If[(fi=FileNames["*.nb", {$ReferencePagesDirectory}])=!={} && Not@justadd && Not@overwrite,
           origrefpagesdir = ToFileName[{$ReferencePagesDirectory, "OriginalReferencePages"}];
           CreateDirectory[origrefpagesdir];
           CopyFile[#, ToFileName[{DirectoryName@#, "OriginalReferencePages"}, StringReplace[#, DirectoryName[#]->""]]]&/@fi;
           DeleteFile[fi]];
           
        If[overwrite, 
           If[MemberQ[If[FileType@s === Directory, $ApplicationSymbolsWithUsage, s], 
              StringReplace[#, {DirectoryName[#] -> "", ".nb" -> ""}]], 
              DeleteFile[#]] & /@ fi];
        filenames = StringReplace[#, {DirectoryName[#] -> "", ".nb" -> ""}] & /@ fi;
           
        (* SetOptions[$FrontEnd, DynamicUpdating -> False]; *)
        
        (* If a package symbol is immediately preceded or succeeded by a word beginning with a capital letter, the symbol
           should not be made into an inline cell - example: Computer Arithmetic Package - should not have Arithmetic made
           into an inline cell (with a button box) even though it is a symbol in the Computer Arithmetic package. *)
        
        ToStringFromInlineFormulaRules = 
          {{k__, l_String /; StringMatchQ[l, _?UpperCaseQ ~~ __], w_String /; StringMatchQ[w, Whitespace], 
	    m : (Cell[BoxData[_String], "InlineFormula"] | 
	         Cell[BoxData[ButtonBox[_String, BaseStyle -> "Link", ButtonData -> _]], "InlineFormula"]), n___} :> 
	   {k, l, w, If[MatchQ[m, Cell[BoxData[_String], "InlineFormula"]], m[[1, 1]], m[[1, 1, 1]]], n}, 
	   {k__, m : (Cell[BoxData[_String], "InlineFormula"] | 
	              Cell[BoxData[ButtonBox[_String, BaseStyle -> "Link", ButtonData -> _]], "InlineFormula"]), 
	    w_String /; StringMatchQ[w, Whitespace], l_String /; StringMatchQ[l, _?UpperCaseQ ~~ __], n___} :> 
	   {k, If[MatchQ[m, Cell[BoxData[_String], "InlineFormula"]], m[[1, 1]], m[[1, 1, 1]]], w, l, n}};
	   
	TransformListOfStrings[listofstrings_, nms_, pagesymbol_] := 
	    Sequence @@ ((Which[StringQ[#] && MemberQ[nms, #] && # =!= pagesymbol, 
	                        Cell[BoxData[ButtonBox[#, BaseStyle -> "Link", 
	                                               ButtonData -> "paclet:" <> DocumentationTools`$LinkBase <> "/ref/" <> #]], 
	                             "InlineFormula"], 
	                        StringQ[#] && MemberQ[SystemNames, #], 
	                        Cell[BoxData[ButtonBox[#, BaseStyle -> "Link"]], "InlineFormula"],
	                        # === pagesymbol, 
	                        Cell[BoxData[#], "InlineFormula"],
	                        True, 
	                        #] & /@ listofstrings) //. {e__, Longest[f__String], g___} :> {e, StringJoin[f], g});
        
       UsageCommentsNewline = {}; UsageContainsNewLine = "Usage messages for the following symbols contain newlines and should not:";
       UsageComments1 = {}; UsageNotString = "Usage messages for the following symbols are not plain strings:";
       UsageComments2 = {}; UsageBeginningNotSymbol = "Usage messages for the following symbols do not begin with their symbol name:";
       UsageComments3 = {}; UsageContainsSubscript = "Usage message contains Subscript and should not:";
       
       (nb = NotebookPut[nbexpr = FunctionPageForSymbol[#, "TemplateFile" -> "FunctionBaseTemplateExt"];
       
                         usage1 = If[# === {}, {}, #[[1]]] &@Cases[nbexpr, Cell[_, "Usage", ___], Infinity];
                         If[MatchQ[usage1, 
			           Cell[TextData[{Cell["   ", "ModInfo"], _String, "\n", Cell["   ", "ModInfo"], _String, ___}], "Usage"]], 
			    usage2 = usage1 /. "\n" -> Sequence[];
			    usage3 = Cell[TextData[{Cell["   ", "ModInfo"], 
			                            StringJoin @@ Riffle[Cases[usage2[[1, 1]], _String], " "]}], "Usage"];
			    nbexpr = nbexpr /. Cell[_, "Usage", ___] -> usage3];
    
                          pagesymbol = #;
                          usage = Cases[nbexpr, Cell[_, "Usage", ___], Infinity];
                          
                         (* If[Not@StringFreeQ[ToExpression[pagesymbol<>"::usage"], "\n"],
			     AppendTo[UsageCommentsNewline, pagesymbol]]; *)
			     
			 (* If[MatchQ[usage, {Cell[TextData[{Cell["   ", "ModInfo"], _String, "\n", Cell["   ", "ModInfo"], _String, ___}], "Usage"]}], 
			     usage = usage /. "\n" -> Sequence[]; 
			     usage = {Cell[TextData[{Cell["   ", "ModInfo"], StringJoin @@ Riffle[Cases[usage[[1, 1, 1]], _String], " "]}], "Usage"]}]; *)
			                            
                          If[Not@MemberQ[UsageCommentsNewline,pagesymbol] && Not@MatchQ[usage, {Cell[TextData[{Cell["   ", "ModInfo"], _String}], "Usage"]}],
                             AppendTo[UsageComments1, pagesymbol],
                             usagepart = usage[[1, 1, 1, 2]]];
                             
                          If[Not@MemberQ[UsageComments1, pagesymbol] && Not@StringMatchQ[usagepart, pagesymbol ~~ __],
                             AppendTo[UsageComments2, pagesymbol]];
                             
                          If[Not@MemberQ[UsageComments1, pagesymbol] && Not@StringFreeQ[usagepart, "Subscript"],
                             AppendTo[UsageComments3, pagesymbol]];
                          
                      (If[MemberQ[Join[UsageCommentsNewline, UsageComments1, UsageComments2, UsageComments3], pagesymbol],
                          
                          nbexpr /. Cell[_, "Usage", ___] -> Cell[TextData[{Cell["   ", "ModInfo"], ToExpression[pagesymbol <> "::usage"]}], "Usage"],
                          
                          (((nbexpr /. usage[[1]] -> Cell[TextData[If[MatchQ[#, {_String, _String}], 
    If[StringMatchQ[usagepart, pagesymbol ~~ " " ~~ __] && Not[StringMatchQ[usagepart, pagesymbol ~~ " " ~~ "->" ~~ __]], 
       ModifyStringPairSymbolNameAndUse[#] //. {Cell["   ", "ModInfo"], a_, b___, Longest[c__String], d___} :> 
                                                                                                         {Cell["   ", "ModInfo"], a, b, StringJoin[c], d}, 
       ModifyStringPairSymbolNameAndUse[#]], 
    Replace[Flatten[(Prepend[#, Cell["   ", "ModInfo"]] & /@ 
    (PartitionUsageString[usagepart, pagesymbol] /. 
    {x_String, y_String} :> {x, link/@ Append[Prepend[FixedPoint[Replace[#, {a___, b_, " ", "->", " ", c_, d___} :> 
    {a, Cell[BoxData[RowBox[{link[b], "->", link[c]}]], "InlineFormula"], d}] &, 
                 StringSplit[y, {" " -> " ", "," -> ",", "." -> ".", ":" -> ":"}]], "\[LineSeparator]"], "\n"]})) /. 
                 {{Longest[b__String], c___} :> {StringJoin[b], c}, {a___, Longest[b__String]} :> {a, StringJoin[b]}}], {a__, b_} :> 
{a, StringReplace[b, "\n" -> ""]}]] &[(If[StringMatchQ[usagepart, pagesymbol ~~ " " ~~ __] && Not[StringMatchQ[usagepart, pagesymbol ~~ " " ~~ "->" ~~ __]], 
    StringReplace[usagepart, pagesymbol ~~ " " ~~ a__ :> {pagesymbol, a}][[1]], 
    If[StringMatchQ[usagepart, pagesymbol ~~ " " ~~ "->" ~~ " " ~~ __], 
       If[Length@# > 2, 
          {StringTake[usagepart, {1, #[[3, 1]] - 1}], StringTake[usagepart, {#[[3, 1]] + 1, -1}]}, {1, -1}] &[StringPosition[usagepart, " "]], 
     PartitionUsageString[usagepart, pagesymbol]]])] /. 
 x_String /; StringMatchQ[x, "\[LineSeparator]" ~~ Whitespace ~~ __] :> StringReplace[x, "\[LineSeparator]" ~~ Longest[" " ..] -> "\[LineSeparator]"]], 
                                                                                                                      "Usage"]) /. 
{Cell[TextData[{Cell["   ", "ModInfo"], a_String /; MemberQ[$ApplicationSymbolsWithUsage, a], b__}], "Usage"] :> 
  Cell[TextData[{Cell["   ", "ModInfo"], Cell[BoxData[a], "InlineFormula"], b}], "Usage"],
Cell[TextData[{Cell["   ", "ModInfo"], a_String /; MemberQ[$ApplicationSymbolsWithUsage, StringReplace[a, " -> " ~~ __ -> ""]], c__}], 
"Usage"] :> 
  Cell[TextData[{Cell["   ", "ModInfo"], Cell[BoxData[RowBox[{link[StringReplace[a, " -> " ~~ __ -> ""]], "->", 
                                 link[StringReplace[a, __ ~~ " -> " -> ""]]}]], "InlineFormula"], c}], "Usage"]}) //. 
Cell[TextData[{Cell["   ", "ModInfo"], a_, b___, c : ButtonBox[_, BaseStyle -> "Link", ___], d___}], "Usage"] :> 
                                 Cell[TextData[{Cell["   ", "ModInfo"], a, b, Cell[BoxData[c], "InlineFormula"], d}], "Usage"])/. Cell[c_, "TableText"] :> 
   (Cell[If[ListQ[#], TextData[#], #], 
        "TableText"] &[Which[StringQ@c, 
                             If[MatchQ[#, {_String}], 
                                #[[1]], 
                                #] &[List @@ TransformListOfStrings[StringSplit[c, 
                                                                          {" " -> " ", "," -> ",", "." -> ".", ":" -> ":"}],
                                                                    $ApplicationSymbolsWithUsage, pagesymbol]], 
                              MatchQ[c, TextData[_List]], 
                              If[MatchQ[#, {__String}], TransformListOfStrings[#, $ApplicationSymbolsWithUsage, pagesymbol], #] & /@ 
           (If[StringQ[#], StringSplit[#, {" " -> " ", "," -> ",", "." -> ".", ":" -> ":"}], #] & /@ c[[1]]), True, c]]) /.
            Cell[a_/;FreeQ[a,ButtonBox], "InlineFormula"] :> (Cell[a, "InlineFormula"] /. 
   b_String /; (MemberQ[$ApplicationSymbolsWithUsage, b] && b =!= pagesymbol) :> 
                           ButtonBox[b, BaseStyle -> "Link", ButtonData -> "paclet:" <> DocumentationTools`$LinkBase <> "/ref/" <> b]) /.
       Cell[BoxData[ButtonBox[a_String /; MemberQ[SystemNames, a], BaseStyle -> "Link"]], "InlineFormula"] :> a] /. 
   {ButtonBox[a_String /; MemberQ[$ApplicationSymbolsWithUsage, a], BaseStyle -> "Link", ButtonData -> b_String /; StringMatchQ[b, __ ~~ "/ref/" ~~ __]] :> 
    ButtonBox[a, BaseStyle -> "Link", ButtonData -> "paclet:" <> DocumentationTools`$LinkBase <> "/ref/" <> StringReplace[b, __ ~~ "/ref/" -> ""]], 
    ButtonBox[a_String /; MemberQ[$ApplicationSymbolsWithUsage, a], ButtonData -> b_String /; StringMatchQ[b, __ ~~ "/ref/" ~~ __], BaseStyle -> "Link"] :> 
    ButtonBox[a, BaseStyle -> "Link", ButtonData -> "paclet:" <> DocumentationTools`$LinkBase <> "/ref/" <> StringReplace[b, __ ~~ "/ref/" -> ""]]})];
              
         NotebookFind[nb, "Paclet Name", All, CellLabel];
	 NotebookWrite[nb, Cell[DocumentationTools`$LinkBase <> " Package", "Categorization", CellLabel -> "Paclet Name"], All]; 
	 SelectionMove[nb, Next, Cell];
	 NotebookWrite[nb, Cell[Context[#], "Categorization", CellLabel -> "Context"], All];
	 SelectionMove[nb, Next, Cell];
	 NotebookWrite[nb, Cell[StringJoin[DocumentationTools`$LinkBase, "/ref/", #], "Categorization", CellLabel -> "URI"], All];
	 FrontEndExecute[{FrontEndToken[nb, "ExpandSelection"]}];
	 FrontEndExecute[{FrontEndToken[nb, "OpenCloseGroup"]}];
	 
	 (* Templatizing (to some extent) in usage cell: *)
	 
	 (* This cannot be used due to a transient FE token bug:
	 
	 If[(cs1 = StringCases[usagepart, Shortest[pagesymbol <> "[" ~~ (a__ /; StringFreeQ[a, "]"]) ~~ "]"]]) =!= {}, 
	    (f = NotebookFind[nb, "ObjectName", All, CellStyle]); 
	     If[f =!= $Failed, 
	        SelectionMove[nb, After, Cell]; 
	        (g = NotebookFind[nb, #, Next]; 
	         If[g =!= $Failed,
	            If[(* Left/right brackets are not balanced in number. *) StringCount[#, "["] =!= StringCount[#, "]"],
	            
	               re = ExpandToExpressionWithBalancedBrackets[nb];
	               id = InsertDollarsInString[re, pagesymbol];
	               If[id =!= re, NotebookWrite[nb, id, All]],
	               
	               id = InsertDollarsInString[#, pagesymbol]; 
	               If[id =!= NotebookRead[nb], NotebookWrite[nb, id, All]]];
	               
	            FunctionTemplateToggle[]]) & /@ cs1]];  
	            
	  *)
	            
         If[Not[MemberQ[Join[UsageCommentsNewline, UsageComments1, UsageComments2, UsageComments3], pagesymbol]] && $Templatize === True,
	 
	    sws = If[StringCount[usagepart, "["] > 0 && StringCount[usagepart, "["] === StringCount[usagepart, "]"],
	             SubstringsWithSymbolsToTemplatize[usagepart, $ApplicationSymbolsWithUsage],
	             {}];
	 
	    If[sws =!= {} && StringCount[usagepart, "["] === StringCount[usagepart, "]"],
	       (g = NotebookFind[nb, #, Next]; 
	        If[g =!= $Failed, 
	           id = InsertDollarsInString[#, pagesymbol];
	           If[id =!= #, NotebookWrite[nb, id, All]];
	           FunctionTemplateToggle[]])&/@sws]];
	           
	 If[Options@ToExpression@# =!= {} && $Templatize === True,
	 
	    SelectionMove[nb, Before, Notebook];
	    cf = NotebookFind[nb, "3ColumnTableMod", Next, CellStyle];
	    
	    If[cf =!= {},
	    
	       table = NotebookRead[nb];
	       SelectionMove[nb, Before, Cell];
	       strings = Flatten[Cases[table, c : Cell[BoxData[GridBox[{{__} .. }]], "3ColumnTableMod", ___] :> 
                                      Cases[c[[1, 1, 1]], d : {Cell[_, "ModInfo", ___], _, _, Cell[_String, "TableText", ___]} :> d[[-1, 1]]], 
                                            {0, Infinity}]]; 
               stringstotemplatizeintable = If[strings =!= {}, 
                                               Flatten[If[StringCount[#, "["] > 0 && StringCount[#, "["] === StringCount[#, "]"], 
                                                          SubstringsWithSymbolsToTemplatize[#, $ApplicationSymbolsWithUsage], 
                                                          {}] & /@ strings], {}];
                                                    
               If[stringstotemplatizeintable =!= {}, 
	          If[NotebookFind[nb, "Usage", All, CellStyle] =!= {}, 
	            (g = NotebookFind[nb, #, Next];
	             If[g =!= $Failed, 
	                id = InsertDollarsInString[#, pagesymbol];
	                If[id =!= #, NotebookWrite[nb, id, All]];
                        FunctionTemplateToggle[]]) & /@ stringstotemplatizeintable]]]];
	        
	 
	 NotebookSave[nb, ToFileName[{$ReferencePagesDirectory}, 
                                     If[StringMatchQ[ToString[#, CharacterEncoding -> None], ___ ~~ "\\[" ~~ __ ~~ "]" ~~ ___], 
                                        StringReplaceRepeated[ToString[#, CharacterEncoding -> None], 
                                                              a___ ~~ "\\[" ~~ b__ ~~ "]" ~~ c___ :> a <> b <> c],
                                        #] <> ".nb"]]; 
         NotebookClose[nb]) & /@ If[justadd, Complement[#, filenames], #]&[If[FileType@s === Directory, $ApplicationSymbolsWithUsage, s]];
         
         If[UsageComments1 =!= {} || UsageComments2 =!= {} || UsageComments3 =!= {}, 
            rpnb = NotebookPut[Notebook[Flatten@Join[{Cell["Information About Usage Messages of Symbols Whose Reference Pages Were Left With No Templatizing.", "Section"],
                                                      Cell["This notebook is saved in the same directory as the reference pages which have been created. The directory may be moved and the hyperlinks here will continue to work. However if this notebook is moved out to a different directory, then the hyperlinks will no longer function properly.", "Text"]},
           Flatten[{If[UsageCommentsNewline =!= {}, Unevaluated[Sequence[Cell[UsageContainsNewLine, "Subsection"],buttonCell/@UsageCommentsNewline]], {}],
                    If[UsageComments1 =!= {}, Unevaluated[Sequence[Cell[UsageNotString, "Subsection"],buttonCell/@UsageComments1]], {}],
                    If[UsageComments2 =!= {}, Unevaluated[Sequence[Cell[UsageBeginningNotSymbol, "Subsection"],buttonCell/@UsageComments2]], {}],
                    If[UsageComments3 =!= {}, Unevaluated[Sequence[Cell[UsageContainsSubscript, "Subsection"],buttonCell/@UsageComments3]], {}]}]]]];
           If[FileType[rpd = ToFileName[{$ReferencePagesDirectory},"ReferencePagesReport"]] =!= Directory,
              CreateDirectory[rpd]];
           If[FileType[rpf = ToFileName[{$ReferencePagesDirectory,"ReferencePagesReport"},"ReferencePagesReport.nb"]] === File,
              DeleteFile[rpf]];
           NotebookSave[rpnb, rpf]];
         
        (* SetOptions[$FrontEnd, DynamicUpdating -> True]; *)
        NotebookClose[EvaluationNotebook[]]],FileType::"fstr"]]

        
WriteApplicationSymbolsToPrefs[]:= SetDocuToolsParametersInFEInit[{"$ApplicationName" -> $ApplicationName, "$LinkBase" -> $LinkBase}]

UpdatePacletVariables::noappname = "The application name has not been specified.";
UpdatePacletVariables::nolinkbase = "The link base has not been specified.";
UpdatePacletVariables::backquote = "The application name should not contain a backquote (`).";

UpdatePacletVariables[previous$ApplicationName_, previous$LinkBase_] :=
 Catch[If[StringMatchQ[$ApplicationName, "" | Whitespace], 
          Throw[MessageToConsole[UpdatePacletVariables::noappname]; 
                SetSelectedNotebook[MessagesNotebook[]]]];
       If[StringMatchQ[$LinkBase, "" | Whitespace], 
	       Throw[MessageToConsole[UpdatePacletVariables::nolinkbase]; 
                SetSelectedNotebook[MessagesNotebook[]]]];
       If[Not@StringFreeQ[$ApplicationName, "`"], 
          Throw[MessageToConsole[UpdatePacletVariables::backquote]; 
                SetSelectedNotebook[MessagesNotebook[]]]];
       If[previous$ApplicationName =!= $ApplicationName, 
          DocumentationDirSelect[StringReplace[$DocumentationDirectory, previous$ApplicationName -> $ApplicationName]]]; 
       If[previous$LinkBase =!= $LinkBase && $LinkBase =!= $ApplicationName, 
          DocumentationTools`Utilities`$LinkBase = $LinkBase;
          SetDocuToolsParametersInFEInit[{"$LinkBase" -> $LinkBase}]]]

        
CancelSetPacletVariables[previous$ApplicationName_, previous$LinkBase_] := (DocumentationTools`$ApplicationName = previous$ApplicationName; DocumentationTools`$LinkBase = previous$LinkBase)

SetPacletVariables[] := 
 Module[{presentname, presentbase, nb, s, t}, presentname = DocumentationTools`$ApplicationName; presentbase = DocumentationTools`$LinkBase;
  nb = NotebookPut[Notebook[{Cell["", FontSize -> 1, CellElementSpacings -> {"CellMinHeight" -> 1}, Selectable -> False], 
      Cell[BoxData[ToBoxes@Style[Grid[{{Style["Application Name: ", Bold, Editable -> False, Selectable -> False], 
                                        InputField[Dynamic[DocumentationTools`$ApplicationName], String, FieldSize -> {40, {1, Infinity}}]},
                                       {Style["Link Base: ", Bold, Editable -> False, Selectable -> False], 
                                        InputField[Dynamic[DocumentationTools`$LinkBase], String, FieldSize -> {40, {1, Infinity}}]},
                                       {Style["", Editable -> False, Selectable -> False], 
                                        OldRow[{Button[Style["OK", Editable -> False, Deletable -> False, Bold], 
                                                       UpdatePacletVariables[s, t];
                                                       NotebookClose[EvaluationNotebook[]], 
                                                       Method -> "Queued"] /. {s -> presentname, t -> presentbase}, 
                                                Button[Style["Cancel", Editable -> False, Deletable -> False, Bold], 
                                                       CancelSetPacletVariables[s, t]; 
                                                       NotebookClose[EvaluationNotebook[]], 
                                                       Method -> "Queued"] /. {s -> presentname, t -> presentbase}}, 
                                               RowAlignments -> Center]}}, 
                                      ColumnAlignments -> Left, ColumnSpacings -> .2], 
           FontFamily -> "Helvetica"]]], 
                             Cell["", FontSize -> 1, CellElementSpacings -> {"CellMinHeight" -> 1}, Selectable -> False]}, 
                            WindowSize -> FitAll, 
                            WindowMargins -> {{Automatic, 100}, {Automatic, Automatic}}, 
                            WindowFrame -> "Palette", 
                            WindowElements -> {}, 
                            WindowFrameElements -> {}, 
                            ShowCellBracket -> False, 
                            ClosingAutoSave -> False, 
                            WindowTitle -> "Set Paclet Variables", 
                            Saveable -> False, 
                            ShowStringCharacters -> False]];
  SelectionMove[nb, Before, Notebook];
  SelectionMove[nb, Next, Cell, 2];
  SelectionMove[nb, After, CellContents];
  FrontEndTokenExecute[nb, "Tab"];
  SetSelectedNotebook[nb]]


(****************************************************************
  Some tools to autogenerate a function page for a given symbol
****************************************************************)

(*-------------------------------------------------------
  Generates a Usage cell from a symbol's usage message
-------------------------------------------------------*)

UsageCellForSymbol::nousage = "No usage message for symbol `1`.";

UsageCellForSymbol[symbol_String, OptionsPattern[FunctionPageForSymbol]] :=
  Module[
    {data},
    Catch[
      data = ToExpression[symbol ~~ "::usage"];
      If[Head[data] =!= String,
        MessageToConsole[UsageCellForSymbol::nousage, symbol]; Throw[$Failed]
      ];
      If[OptionValue["Version"] >= 6,
        (*********
        * ver 6+ *
        *********)
        data = StringSplit[data, Whitespace... ~~ "\n"];
        data =
          StringSplit[#,
            "\!\(\*" ~~ x: Except["\)"]... ~~ "\)" :>
              Cell[BoxData[ToExpression[x]], "InlineFormula"]
          ]& /@ data;
        data =
          (# /.
            {a_, b_String, c___} :>
              {a,
              StringReplace[b,
                StartOfString ~~ Whitespace... :> " \[LineSeparator]"],
              c}
          )& /@ data;
        data = Prepend[#, Cell["   ", "ModInfo"]]& /@ data;
        ,
        (************
        * pre ver 6 *
        ************)
        data = StringReplace[data, Whitespace... ~~ "\n" -> " "];
        data =
          StringSplit[data,
            "." ~~ Whitespace
              ~~ x: (LetterCharacter .. ~~ "[" ~~ Except["]"] ... ~~ "]")
                :> x
          ];
        data[[1]] =
          Sequence @@
            StringSplit[data[[1]],
              x: (StartOfString ~~ LetterCharacter..
                  ~~ "[" ~~ Except["]"] ... ~~ "]")
                :> x
            ];
        If[OddQ@Length[data],
          data = StringSplit[StringJoin @@ data, Whitespace, 2]
        ];
        data =
          StringReplace[#, {
            StartOfString ~~ Whitespace -> "",
            Whitespace ~~ EndOfString -> ""
          }]& /@ data;
        data = Partition[data, 2];
        data =
          {
            Cell["   ", "ModInfo"],
            Cell[BoxData[
              FEmogrify[RowBox[{#[[1]]}]] /. TemplatizeRules[symbol]
            ], "InlineFormula"],
            " \[LineSeparator]",
            Module[
              {args, rules},
              (* Extract arguments from the syntactic (lefthand) side... *)
              args = StringReplace[#[[1]], "..." -> "Sequence[]"];
              args = ToExpression["FOO" <> args];
                (* ..."FOO" added to create a bogus symbol name that
                  doesn't evaluate. *)
              args = If[AtomQ[args], {}, Flatten[List @@ args]];
              args = ToString /@ Select[args, (Head[#] === Symbol)&];
              (* ...and construct rules to split and format them on the
                descriptive (righthand) side. *)
              rules =
                (d: (WordBoundary ~~ # ~~ WordBoundary) :>
                  Cell[BoxData[StyleBox[d, "TI"]], "InlineFormula"])&
                    /@ args;
              Sequence @@ Flatten[{StringSplit[#[[2]], rules]}]
            ],
            If[StringTake[#[[2]], -1] != ".", ".", ""]
          }& /@ data;
        (**********************
        * End of "Version" If *
        **********************)
      ];
      data = Flatten[Riffle[data, "\n"]];
      Cell[TextData[data], "Usage"]
    ]
  ];

(*
  Rules for syntactically marking-up ("templatizing") a function call
  (see also FunctionTemplate).
*)
TemplatizeRules[symbol_String] :=
  {
    btn_ButtonBox :> btn,
    st_StyleBox :> st,
    symbol -> symbol,
    c_Cell :> c,
    SubscriptBox[base_, sub_] :>
      StylizeSubscriptedArgument[base, sub],
    strg_String :> StylizeTemplatePart[strg],
    RowBox[{msgObjName_String, "::", msgTag: Except["tag", _String]}] :>
      StylizeMessageName[msgObjName, msgTag, symbol]
  };

(*
  Passes an expression thru the FE, to allow any "automagical" transforms.
  Specifically need this here to cause (e.g.)

    RowBox[{"foo[x,y,z]"}]

  to be expanded to

    RowBox[{"foo", "[", RowBox[{"x", ",", "y", ",", "z"}], "]"}].
*)
FEmogrify[expr_] :=
  Module[
    {nb, data},
    nb = NotebookCreate[Visible -> False];
    NotebookWrite[nb, expr, All];
    data = NotebookRead[nb];
    NotebookClose[nb];
    data
  ]


(*----------------------------------------------------------------------
  Generates an options table from a symbol's Options[] values.
  (Similar to the interactive OptionsTableCreate[], with all selected.)
----------------------------------------------------------------------*)

OptionsTableForSymbol[
  symbol_String,
  OptionsPattern[FunctionPageForSymbol]
] :=
  Module[
    {data, uri},
    data = Options[ToExpression[symbol]];
    Catch[
      If[Length[data] == 0, Throw[$Failed]];
      data = {
        Cell["   ", "ModInfo"],
        Sequence @@ (
            (
              uri = "URI" /. GetCategorizationMetadata[#] /. "URI" -> None;
              If[uri === None
                ,
                #
                ,
                ButtonBox[#,
                  If[StringMatchQ[uri, StartOfString ~~ "ref/" ~~ ___],
                    Sequence @@ {},
                    ButtonData -> "paclet:" <> uri
                  ],
                  BaseStyle -> "Link"
                ]
              ]
            )& /@ OptionNameAndValue[#]
          ),
        Module[
          {name, usage},
          name = OptionNameAndValue[#][[1]];
          usage = ToExpression[name ~~ "::usage"];
          usage =
            If[Head[usage] === String,
              If[OptionValue["Version"] >= 6
                ,
                TextData[
                  StringSplit[usage,
                    "\!\(\*" ~~ x: Except["\)"]... ~~ "\)" :>
                      Cell[BoxData[ToExpression[x]], "InlineFormula"]
                  ]
                ]
                ,
                StringReplace[usage, Whitespace... ~~ "\n" -> " "]
              ]
              ,
              "XXXX"
            ];
          Cell[usage, "TableText"]
        ]
      }& /@ data;
      {
        Cell["The following options can be given: ", "Notes"],
        Cell[BoxData[GridBox[data]], "3ColumnTableMod"]
      }
    ]
  ];

(*
  Returns the {name, default_value} pair for a given rule from Options.
  Has the advantage that, when the rule uses RuleDelayed, it returns the
  default_value unevaluated.
*)

SetAttributes[OptionNameAndValue, HoldAll]

OptionNameAndValue[Rule[name_, value_]] :=
  {ToString[name], ToString @ value};

OptionNameAndValue[RuleDelayed[name_, value_]] :=
  {
    ToString[name],
    StringReplace[
      ToString[Hold @ value], {
        StartOfString ~~ "Hold[" -> "",
        "]" ~~ EndOfString -> ""
      }
    ]
  };


(*--------------------------------------------------------------------------
  Generates an "Options" example section from a symbol's Options[] values.
  (Similar to the interactive OptionsInspector[], with all selected.)
--------------------------------------------------------------------------*)

OptionsSectionForSymbol[symbol_String] :=
  Module[
    {data},
    data = Options[ToExpression[symbol]];
    Catch[
      If[Length[data] == 0, Throw[$Failed]];
      data =
        With[
          {new = Cell[First@OptionNameAndValue[#], "ExampleSubsection"]},
          Cell[BoxData[InterpretationBox[new, $Line = 0;]],
            "ExampleSubsection"]
        ]& /@ data;
      data =
        Prepend[data,
          Cell[BoxData[
            InterpretationBox[Cell["Options", "ExampleSection"], $Line = 0;]
          ], "ExampleSection"]
        ];
      Cell[CellGroupData[data, Closed]]
    ]
  ];


(*--------------------------------------------------------------------------
  Generates probable Categorization metadata values from the symbol's
  context.  Values returned as rules, keyed to the corresponding metadata
  cell's CellLabel.
--------------------------------------------------------------------------*)

GetCategorizationMetadata[symbol_String] :=
  Module[
    {context, package, uri},
    context = Quiet[Context[symbol]];
    Catch[
      If[Head[context] =!= String, Throw[{}]];
      package =
        StringReplace[context, {
          "System`" -> "",
          "Global`" -> "",
          "`" -> ""
        }];
      If[StringLength[package] > 0
        ,
        uri = package <> "/ref/" <> symbol;
        package = package <> " Package"
        ,
        uri = "ref/" <> symbol
      ];
      {
        "Paclet Name" -> package,
        "Context" -> context,
        "URI" -> uri
      }
    ]
  ];


(*------------------------------------------------------------
  Drawing all the above together...
  Generates an (initial) function page for a given symbol.
------------------------------------------------------------*)

Options[FunctionPageForSymbol] =
  {
    "TemplateFile" :>
      ToFileName[{$DocuToolsDir, "FrontEnd", "TextResources"},
        "FunctionBaseTemplate.nb"],
    "Version" -> 6
  };

FunctionPageForSymbol[symbol_String, opts: OptionsPattern[]] :=
  Module[
    {
      resDir = ToFileName[{$DocuToolsDir, "FrontEnd", "TextResources"}],
      file, data, metadata, new
    },
    file = OptionValue["TemplateFile"];
    (* If "TemplateFile" doesn't work as an absolute path,
      try relative to the TextResources directory. *)
    If[FileType[file] =!= File,
      If[! StringMatchQ[file, ___ ~~ ".nb"], file = file <> ".nb"];
      file = ToFileName[{resDir}, file]
    ];
    (* ...and if that fails, throw a message and go with a default. *)
    If[FileType[file] =!= File,
      file = ToFileName[{resDir}, "FunctionBaseTemplate.nb"];
      MessageToConsole[FunctionPageForSymbol::notemplate,
        OptionValue["TemplateFile"], resDir, file];
    ];
    (**)
    data = Get[file];
    metadata = GetCategorizationMetadata[symbol];
    data = data /. {
      Cell[old_,
        etc: PatternSequence[
          "Categorization",
          ___,
          CellLabel -> label: ("Paclet Name" | "Context" | "URI"),
          ___
        ]
      ] :>
        Cell[label /. metadata /. label -> old, etc],
      Cell[_, sty: "ObjectName", etc___] :> Cell[symbol, sty, etc],
      old: Cell[_, "Usage", ___] :>
        If[(new = UsageCellForSymbol[symbol, opts]) =!= $Failed, new, old],
      old: Cell[_, "Notes", ___] :>
        If[(new = OptionsTableForSymbol[symbol, opts]) =!= $Failed,
          Sequence @@ new, old],
      old:
        Cell[CellGroupData[{
          Cell[c_ /; !FreeQ[c, Cell["Options", "ExampleSection"]],
            "ExampleSection", ___],
          ___
        }, _]] :>
          If[(new = OptionsSectionForSymbol[symbol]) =!= $Failed, new, old]
    };
    data
  ];


(*------------------------------------------
  Some tools for cutting/pasting examples.
------------------------------------------*)

(*
  Copies selected example section to the clipboard, translating to
  "newdocs" styles.
*)

CopyExample[nb_NotebookObject] :=
  ClipboardPut[
    NotebookRead[nb] /. {
      (* Cell-level transforms. *)
      Cell[c_, "MathCaption" | "Text", ___] :> Cell[c, "ExampleText"],
      Cell[c_, s: ("Input" | "Output"), opts___] :>
        Cell[c, s, Sequence @@ Cases[{opts}, _[CellLabel, _]]],
      Cell[c_, s_, ___] :> Cell[c, s]
    } /. {
      (* Transforms internal to cells. *)
      StyleBox[s_String, "MR"] :> Cell[BoxData[s], "InlineFormula"],
      StyleBox[s_String, "TI"] :> StyleBox[s, FontSlant -> "Italic"]
    }
  ];

CopyExample[] := CopyExample[InputNotebook[]];


(***************************************************************)


(****************************************************************
  Multiple file selector dialog.

  Overall design is two side-by-side panels:  a directory listing
  on the left and a list of selected files on the right.
  Filenames in the listings are buttons which, when clicked, move
  the file to the other list.
  
  List of selected files is returned in the global variable
  $SelectedFiles.
****************************************************************)

(*------------------------------------------
  Global variables
------------------------------------------*)

(* List of unselected files in current directory (left panel). *)
$AllFiles = {};

$NumberOfFiles = Length[$AllFiles];

(* List of selected files (right panel). *)
$SelectedFiles = {};

(* Current directory path. *)
$Directory := $DocumentationDirectory;


(*------------------------------------------
  Filename button functions...
------------------------------------------*)

SelectFile[s_String] := (
  $AllFiles = DeleteCases[$AllFiles, s];
  AppendTo[$SelectedFiles, s];
);

DeselectFile[s_String] := (
  $SelectedFiles = DeleteCases[$SelectedFiles, s];
  AppendTo[$AllFiles, s];
);


(*------------------------------------------
  ...and the filename button itself.
------------------------------------------*)

FileButton[s_String, action_Function] :=
  Button[Style[s, FontSize -> 10], action,
    Evaluator -> Automatic, ButtonData -> s, ButtonFrame -> None];


(*------------------------------------------
  Dialog buttons
------------------------------------------*)

DeselectAll[] := (
  $AllFiles = Join[$AllFiles, $SelectedFiles];
  $SelectedFiles = {};
);

SetDirectoryDialog[init_] :=
  Module[{dir},
    dir = SystemDialogInput["Directory", init];
    If[dir =!= $Canceled,
      If[Length[DirectoryStack[]] > 0, ResetDirectory[]];
        (* ...to keep DirectoryStack[] from growing.
          The dialog opens w/a SetDirectory[], so DirectoryStack[] should
          not be empty at this point.  Dialog closes w/a ResetDirectory[],
          so the SetDirectory below should also guarantee a non-empty
          stack. *)
      $Directory = SetDirectory[dir];
      DirectoryChangeRefresh[];
    ]
  ];


(*------------------------------------------
  Directory-change-related utilities.
------------------------------------------*)

DirectoryChangeRefresh[] := (
  $AllFiles =
    DeleteCases[
      Quiet[FileNames["*.nb"], $CharacterEncoding::utf8],
      s_String /; StringMatchQ[s, ".*"]
    ];
  $NumberOfFiles = Length[$AllFiles];
  $SelectedFiles = {};
);


(*------------------------------------------
  A vertically-scrollable panel workaround
  (pending native scroll bars in Mathematica)
  [...from an idea by lou]
------------------------------------------*)

ScrollingPanel1D[expr_, {w_, h_}, opts___] :=
  DynamicModule[{x = -1, y = 1},
    Grid[{{
      Panel[expr, ImageSize -> {w, h}, Alignment -> Dynamic[{x, y}], opts],
      VerticalSlider[Dynamic[y], {-1, 1}, ImageSize -> {Small, h}]
    }}]
  ];


(*------------------------------------------
  The file selector dialog
------------------------------------------*)

SetAttributes[FileSelectorDialog, HoldAll];

FileSelectorDialog[title_String, OKlabel_String, OKaction_] :=
  CreateDialog[
    SetDirectory[$Directory];
    DirectoryChangeRefresh[];
    Column[{
      Dynamic[$Directory],
      Dynamic["(" <> ToString[$NumberOfFiles] <> " files)"],
      Row[{
        Column[
          {
            Button["Select Directory...", SetDirectoryDialog[$Directory],
              Method -> "Queued", ImageSize -> 150],
            "Click files below to add to the selected list (at right).",
            ScrollingPanel1D[
              Dynamic @ Column[
                Sort @ (FileButton[#, SelectFile[#]&]& /@ $AllFiles)
              ],
              {300, 300}
            ],
            Row[{
              Button[OKlabel, OKaction, ImageSize -> 150],
              Button["Close",
                If[Length[DirectoryStack[]] > 0, ResetDirectory[]];
                NotebookClose[ButtonNotebook[]],
                ImageSize -> 150]
            }]
          },
          BaselinePosition -> Top
        ],
        Column[
          {
            Button["Deselect All", DeselectAll[], ImageSize -> 150],
            "Click files below to deselect them.",
            ScrollingPanel1D[
              Dynamic @ Column[
                FileButton[#, DeselectFile[#]&]& /@ $SelectedFiles
              ],
              {300, 300}
            ]
          },
          BaselinePosition -> Top
        ]
      }],
      Spacer[{0, 0}]
    }],
    WindowTitle -> title
  ];
  
  $FileSelectorDialogFieldInput = ""
  
FileSelectorDialog[title_String, inputfieldlabel_String, OKlabel_String, OKaction_] :=
    CreateDialog[
      SetDirectory[$Directory];
      DirectoryChangeRefresh[];
      Column[{
        Dynamic[$Directory],
        Row[{TextCell[inputfieldlabel], InputField[Dynamic[$FileSelectorDialogFieldInput], String, FieldSize -> {41, {1, Infinity}}]}],
        Dynamic["(" <> ToString[$NumberOfFiles] <> " files)"],
        Row[{
          Column[
            {
              Button["Select Directory...", SetDirectoryDialog[$Directory],
                Method -> "Queued", ImageSize -> 150],
              "Click files below to add to the selected list (at right).",
              Framed@Pane[
                Dynamic @ Column[
                  Sort @ (FileButton[#, SelectFile[#]&]& /@ $AllFiles)
                ],
                ImageSize ->{300, 300}, Scrollbars -> {False, True}, BaseStyle -> {Background -> White},
                AppearanceElements -> None
              ]
            },
            BaselinePosition -> Top
          ],
          Column[
            {
              Button["Deselect All", DeselectAll[], ImageSize -> 150],
              "Click files below to deselect them.",
              Framed@Pane[
                Dynamic @ Column[
                  FileButton[#, DeselectFile[#]&]& /@ $SelectedFiles
                ],
                ImageSize ->{300, 300}, Scrollbars -> {False, True}, BaseStyle -> {Background -> White},
                AppearanceElements -> None
              ]
            },
            BaselinePosition -> Top
          ]
        }],
        Row[{Button[OKlabel, OKaction, ImageSize -> 140], Button["Close",
	     If[Length[DirectoryStack[]] > 0, ResetDirectory[]];
	                NotebookClose[ButtonNotebook[]],
                      ImageSize -> 140]}],
        Spacer[{0, 0}]
      }],
      WindowTitle -> title
  ]

(***************************************************************)


(****************************************************************
  Source file browser.

  A file browser with filtering options.

  List of selected files is returned in the global variable
  $SelectedFiles.

  Shares some variables and code w/FileSelectorDialog.
****************************************************************)

(*------------------------------------------
  Global variables
------------------------------------------*)

$Updating = False;

$FilterControlsOpen = False;


(*------------------------------------------
  The filename entries are buttons:
------------------------------------------*)

FileButtonSB[s_String] :=
  Button[
    Style[s, FontSize -> 10,
      Background -> If[MemberQ[$SelectedFiles, s], Yellow, White]
    ],
    $SelectedFiles =
      If[MemberQ[$SelectedFiles, s],
        DeleteCases[$SelectedFiles, s],
        Append[$SelectedFiles, s]
      ],
    Evaluator -> Automatic, ButtonData -> s, ButtonFrame -> None
  ];


(*------------------------------------------
  Directory-change-related utilities.
------------------------------------------*)

DirectoryChangeRefreshSB[
  opts: OptionsPattern[SourceBrowser]
] := (
  $Updating = True;
  $AllFiles =
    DeleteCases[Quiet[FileNames["*.nb"], $CharacterEncoding::utf8],
      s_String /; StringMatchQ[s, ".*"]];
  $NumberOfFiles = Length[$AllFiles];
  $SelectedFiles = {};
  $FileInfo = GetFileInfo /@ $AllFiles;
  $AllVersions =
    Union[#[[2]]& /@ $FileInfo /.
      s_String /; StringMatchQ[s, WhitespaceCharacter...]
        -> "Empty"
    ];
  $AllStatus = Prepend[$SourceStatus, "None"];
  If[!ValueQ[$FilterVersion] || MemberQ[{opts}, _["VersionInitial", _]],
    $FilterVersion =
      OptionValue[SourceBrowser, {opts}, "VersionInitial"]
        /. All -> $AllVersions;
  ];
  If[!ValueQ[$FilterStatus] || MemberQ[{opts}, _["StatusInitial", _]],
    $FilterStatus =
      OptionValue[SourceBrowser, {opts}, "StatusInitial"]
        /. All -> $AllStatus;
  ];
  $Updating = False;
);


(*------------------------------------------
  File filters
------------------------------------------*)

GetFileInfo[file_String] :=
  Module[{str, data, newIn, status},
    str = OpenRead[FileNameJoin[{$Directory, file}]];
    data = StringJoin @ Read[str, Table[String, {50}]];
    Close[str];
    newIn =
      StringCases[data,
          "Cell[\"" ~~ c: Except["\""]... ~~ "\"" ~~ Except["]"]... ~~
          "\"HistoryData\"" ~~ Except["]"]... ~~ "CellTags->\"New\"" ~~
          Except["]"]... ~~ "]" :> c] //
        Quiet @ Check[First[#], ""]&;
    status =
      StringCases[data,
          "Cell[" ~~ Except[","] ... ~~ "," ~~ WhitespaceCharacter ... ~~
          "\"" ~~ s: Alternatives @@ $SourceStatus ~~ "Flag\"" ~~
          Except["]"] ... ~~ "]" :> s] //
        Quiet @ Check[First[#], ""]&;
    {file, newIn, status}
  ];

$SourceStatus = {
  "Obsolete",
  "Internal",
  "Temporary",
  "Future",
  "AwaitingFutureDesignReview",
  "Preview",
  "Excised"
};


FilterFiles[files_List] :=
  Cases[$FileInfo,
    {
      f_,
      Alternatives @@ (
        $FilterVersion /.
          "Empty" -> s_String /; StringMatchQ[s, WhitespaceCharacter...]
      ),
      Alternatives @@ ($FilterStatus /. "None" -> "")
    } :> f
  ];



(*------------------------------------------
  The file selector dialog
------------------------------------------*)

SetAttributes[SourceBrowser, HoldAll];

Options[SourceBrowser] =
  {
    "Title" -> "File Browse by History/Status",
    "OKlabel" -> "OK",
    "OKaction" :> (
      NotebookClose[ButtonNotebook[]]; 
      NotebookOpen[FileNameJoin[{$Directory, #}]]& /@ $SelectedFiles
    ),
    "VersionInitial" -> All,
    "StatusInitial" -> All
  };

SourceBrowser[opts: OptionsPattern[]] :=
  CreateDialog[
    If[FileType[$Directory] === Directory,
      SetDirectory[$Directory];
      DirectoryChangeRefreshSB[opts];
    ];
    Column[{
      Dynamic[$Directory],
      If[FileType[$Directory] =!= Directory,
        Style["---Directory does NOT exist---", Red],
        Sequence @@ {}
      ],
      Button["Select Directory...",
        Block[{DirectoryChangeRefresh = Sequence},
          SetDirectoryDialog[$Directory];
          DirectoryChangeRefreshSB[opts]
        ],
        Method -> "Queued", ImageSize -> 150],
      Dynamic @
        Which[
          $Updating,
            ProgressIndicator[Dynamic[5*Clock[Infinity]], Indeterminate],
          Length[$AllVersions] > 0,
            OpenerView[
              {
                "Filters",
                Column[{
                  Row[{
                    "New In: ",
                    CheckboxBar[Dynamic[$FilterVersion], $AllVersions],
                    " ",
                    Button["All", $FilterVersion = $AllVersions],
                    Button["None", $FilterVersion = {}]
                  }],
                  Row[{
                    "Status: ",
                    CheckboxBar[Dynamic[$FilterStatus], $AllStatus],
                    " ",
                    Button["All", $FilterStatus = $AllStatus],
                    Button["None", $FilterStatus = {}]
                  }]
                }]
              },
              Dynamic[$FilterControlsOpen]
            ],
          True, (*else*)
            "no source files"
        ],
      Dynamic["(" <> ToString[FilterFiles[$AllFiles] // Length] <> " files)"],
      ScrollingPanel1D[
        Dynamic @ Column[
          Sort @ (FileButtonSB[#]& /@ FilterFiles[$AllFiles])
        ],
        {300, 300}
      ],
      Row[{
        Button[OptionValue["OKlabel"], OptionValue["OKaction"],
          ImageSize -> 150],
        Button["Close", If[Length[DirectoryStack[]] > 0, ResetDirectory[]];
          NotebookClose[ButtonNotebook[]], ImageSize -> 150]
      }],
      Spacer[{0, 0}]
    }],
    WindowTitle -> OptionValue["Title"],
    WindowSize -> {Inherited, FitAll}
  ];



SourceBrowse[type_String, vers___String] := Module[{},
    Which[ 
       (DocumentationTools`AuxiliaryPaths`$UserSpecial === True) && StringMatchQ[ type, "MarketingPages" | "ComparisonPages"],
        $Directory = FileNameJoin[{ DirectoryName @ DirectoryName @ $DocumentationDirectory, "WebsiteConstruction", type}];
        SourceBrowser["VersionInitial" -> {vers}],
       (DocumentationTools`AuxiliaryPaths`$UserSpecial === True) && StringMatchQ[ type, "CapabilitiesPages"],
        MathLink`CallFrontEnd[ FrontEnd`DirectoryBrowse[ 
          FileNameJoin[{ DirectoryName @ DirectoryName @ $DocumentationDirectory, "WebsiteConstruction", type}], 
            "Browse for a capabilities page source file:"]],
      StringMatchQ[ type, "CapabilitiesPages"],
        MathLink`CallFrontEnd[ FrontEnd`DirectoryBrowse[ 
          FileNameJoin[{ $DocumentationDirectory, type}], 
            "Browse for a capabilities page source file:"]],
      True,
        $Directory = FileNameJoin[{ $DocumentationDirectory, type}];
        SourceBrowser["VersionInitial" -> {vers}]
      ]]




(****************************************************************
  Tutorial Overview generator (function and dialog)
****************************************************************)

TitleReduce[title_String] :=
 StringReplace[StringTake[ToString[#, InputForm, CharacterEncoding -> None], {2, -2}], Shortest["\\[" ~~ a__ ~~ "]"] :> a] &[StringReplace[
  StringReplace[StringTrim[title], 
   WordBoundary ~~ x_ :> ToUpperCase[x]], 
               Join[# -> "" & /@ {"`", "~", "!", "@", "#", "$", "%", "^", "*", "(", ")", ":", ";", "\"", "'", "<", ",", ">", ".", "?", "/", "\n", "\t"}, 
                       {Whitespace -> "", "_" -> "-"}]]]

GenerateOverviewFromList::emptylist = "The list of selected tutorials is empty.";
GenerateOverviewFromList::emptyinfield = "The title field is empty.";
GenerateOverviewFromList::pacvarsset = "$ApplicationName and $LinkBase must first be set.";
GenerateOverviewFromList::heading = "Headings in `1` do not exist or are missing cell ids.";

Options[GenerateOverviewFromList] = {CloseDialogNotebook -> True}

GenerateOverviewFromList[files_List, otherFiles_List, Opts___] :=
  Module[{new, uri, headings, file, nb},
    Catch[If[$SelectedFiles === {}, 
             Throw[MessageToConsole[GenerateOverviewFromList::emptylist]]];
    If[StringMatchQ[$FileSelectorDialogFieldInput, "" | Whitespace], 
       Throw[MessageToConsole[GenerateOverviewFromList::emptyinfield]]];
       
    If[Not[StringQ[$ApplicationName]] || Not[StringQ[$LinkBase]] || 
        StringMatchQ[$ApplicationName, "" | Whitespace] || StringMatchQ[$LinkBase, "" | Whitespace],
       Throw[MessageToConsole[GenerateOverviewFromList::pacvarsset]]];
    new =
      (
        uri = "paclet:"
          <> If[$MathematicaDocs, "", DocumentationTools`$LinkBase <> "/"]
          <> "tutorial/" <> StringReplace[#, ".nb" -> ""] <> "#";
        headings =
          Cases[Quiet[Get[#], Syntax::newl],
            Cell[content_,
              style: ("Title" | "Section" | "Subsection" |
                "Subsubsection"), ___, CellID -> cellid_, ___] :>
                  {
                    content /. {
                      TextData[c : {___}] :> c,
                      TextData[c_] :> {c},
                      c_String :> {c}
                    },
                    style /. {
                      "Title" -> "TOCChapter",
                      s_ :> "TOC" <> s
                    },
                    cellid
                  },
            Infinity
          ];
        If[Length[headings] == 0,
          Throw[MessageToConsole[GenerateOverviewFromList::heading, #]]
        ];
        Sequence @@ (
          Function[s, 
           Cell[TextData[ButtonBox[#, BaseStyle -> "Link", 
	                           ButtonData -> uri <> ToString[s[[3]]]] & /@ s[[1]]], 
                s[[2]]]] /@ headings
        )
      )& /@ files;
    new = Join[ new, overviewOtherFiles[ otherFiles]];	   
    new = Prepend[new, Cell["Overview Title", "TOCDocumentTitle"]];
    file =
      ToFileName[{$DocuToolsDir, "FrontEnd", "TextResources"},
        "OverviewBaseTemplate.nb"];
    nb = NotebookPut[
      (Get[file] /.
        Notebook[c_, opts___] :>
          Notebook[Take[c, 5] ~Join~ new, opts])/.
          {RuleDelayed @@ (Cell["", "Categorization", CellLabel -> "Paclet Name", a___] -> 
                            Cell[If[$MathematicaDocs, "Mathematica", $LinkBase <> " Package"], "Categorization", CellLabel -> "Paclet Name", a]), 
            RuleDelayed @@ (Cell["", "Categorization", CellLabel -> "Context", a___] -> 
                            Cell[If[$MathematicaDocs, "", $ApplicationName <> "`"], "Categorization", CellLabel -> "Context", a]), 
            RuleDelayed @@ (Cell["XXXX", "Categorization", CellLabel -> "URI", a___] -> 
                            Cell[StringJoin[If[$MathematicaDocs, "tutorial/", Unevaluated[Sequence[$LinkBase, "/tutorial/"]]], 
                                            TitleReduce[$FileSelectorDialogFieldInput]], "Categorization", 
                                 CellLabel -> "URI", a]), 
            Cell[_, "TOCDocumentTitle", a___] :> Cell[$FileSelectorDialogFieldInput, "TOCDocumentTitle", a]}
    ];
    NotebookSave[nb, ToFileName[{$Directory}, TitleReduce[$FileSelectorDialogFieldInput] <> ".nb"]];
    (* FrontEndTokenExecute[nb, "SelectAll"];
       FrontEndTokenExecute[nb, "SelectionCloseAllGroups"]; *)
    SelectionMove[nb, After, Notebook];
    If[CloseDialogNotebook /. {Opts} /. Options[GenerateOverviewFromList], NotebookClose[]];
    $FileSelectorDialogFieldInput = "";
  ]];



(*  
 Create contents for an Overview Notebook from otherFiles which is a 
 list of files all relative to DocumentationBase/Language.
*)
overviewOtherFiles[ otherFiles_List] :=
	Module[ {data},
		(* Split up otherFiles according to base *)
		data = Map[ FileNameSplit, otherFiles];
		(* Only work with segmented files *)
		data = Select[ data, MatchQ[#,{_,__}] &];
		data = Split[ data, Drop[#1, -1] === Drop[#2, -1] &];
		data = Map[ {Part[#, 1, 1 ;; -2], Part[#, All, -1]} &, data];
		data = MapAt[Apply[StringJoin, Riffle[#, "/"]] &, data, Table[{i, 1}, {i, Length[data]}]];
		(* Now each element of data is {base, {file1, file2}} *)
		Flatten[ Map[ getOverviewSection, data]]
	]


linkTypeMap[ "Guides"] = "guide"
linkTypeMap[ "ReferencePages/Symbols"] = "ref"
linkTypeMap[ x_] = x

(*

*)
getOverviewSection[ {base_, nbs_List}] :=
	Module[{linkBase, uri, data, nbList},
		nbList = Map[ FileBaseName, nbs];
		linkBase = "paclet:" <> DocumentationTools`$LinkBase <> "/" <> linkTypeMap[ base];
		data = Map[ 
				(uri = linkBase <> "/" <> #;
				Cell[TextData[ButtonBox[#, BaseStyle -> "Link",ButtonData -> uri]],"TOCSection"]) &
				, nbList];
		Flatten[
			{
			uri = linkBase <> "/" <>  First[ nbList];
			Cell[TextData[ButtonBox[base, BaseStyle -> "Link",ButtonData -> uri]],"TOCChapter"]	
			,
			data
			}]
	]

getOverviewSection[ {base_, {}}] := {}	
	
GenerateOverviewDialog[] :=
 (SelectionMove[#, Before, Notebook];
  SelectionMove[#, Next, Cell, 2];
  SelectionMove[#, After, CellContents];
  FrontEndTokenExecute[#, "Tab"];
  SetSelectedNotebook[nb])&[FileSelectorDialog[
    "Tutorial Overview Generator",
    "Overview Title: ",
    "Generate Overview",
    GenerateOverviewFromList[$SelectedFiles, {}]
  ]];

(***************************************************************)

(*                    Applications RefGuide Divider            *)

(*  Example after loading this package:

<< DocumentationTools`

Set $ApplicationName to name of application as a string for example:

$ApplicationName = "ImageProcessing";

$LinkBase will usually be the same. This is what goes into the button data.

$LinkBase = "ImageProcessing";

If a number of notebooks must be combined into a single ref guide use MergeRefGuideNotebooks first.

Then:

ParseApplicationRefGuide[application ref guide];
  
ExportApplicationRefGuideEntryNotebooks[directory to output function pages to, {}] *)

(** keywords **)
$DocEntry[keywords,___] = {Cell[CellGroupData[{
   Cell["Keywords", "KeywordsSection"],
   Cell["XXXX", "Keywords"]
}, Closed] ]};

(** doc status **)
$DocEntry[status,___] = {Cell[CellGroupData[{Cell["Document Status", "DocumentStatusSection"], 
    Cell["XXXX", "DocumentStatus", CellLabel -> "Author"], 
    Cell["XXXX", "DocumentStatus", CellLabel -> "Authoring Notes"], 
    Cell["XXXX", "DocumentStatus", CellLabel -> "Reviewers Assigned"], 
    Cell["XXXX", "DocumentStatus", CellLabel -> "Review History"], 
    Cell["XXXX", "DocumentStatus", CellLabel -> "DQA Checks"], 
    Cell["XXXX", "DocumentStatus", CellLabel -> "Comments/To Do"]}, Closed]]};

(** related links **)
$DocEntry[relatedlinks,lang_:Automatic] := 
Cell[ CellGroupData[{
   Cell[Switch[lang,
     "Japanese","\:95a2\:9023\:30ea\:30f3\:30af", (* kanren linku *)
     _,"Related Links"
     ], "RelatedLinksSection"],
   Cell[ "XXXX", "RelatedLinks"]
}, Open] ]

(** application notes **)
$DocEntry[appnotes,lang_:Automatic] :=
Cell[ CellGroupData[{
   Cell[Switch[lang, 
     "Japanese", "\:30a2\:30d7\:30ea\:30b1\:30fc\:30b7\:30e7\:30f3\:30ce\:30fc\:30c8", (* apurike-shon no-to *)
     _, "Application Notes"], "ApplicationNotesSection"],
   Cell[ "XXXX", "ApplicationNotes"]
}, Open] ]

(** design discussion **)
$DocEntry[designdisc,lang_:Automatic] :=
Cell[ CellGroupData[{
   Cell[Switch[lang,
     "Japanese","\:30c7\:30b6\:30a4\:30f3\:306b\:3064\:3044\:3066", (* dezain nituite *)
     _, "Design Discussion"], "DesignDiscussionSection"],
   Cell[ "XXXX", "DesignDiscussion"]
}, Open] ]

(** examples **)
$DocEntry[examples,lang_:Automatic] := 
{
   Apply[
      Function[{
         text1,
         text2
      },
         Cell[BoxData[
            InterpretationBox[
               GridBox[{{
                  StyleBox[ text1, "PrimaryExamplesSection"], 
                  ButtonBox[
                     RowBox[{text2, " ", "\[RightTriangle]"}],
                     ButtonData:>"ExtendedExamples",
                     BaseStyle->"ExtendedExamplesLink"
                  ]
               }}],
               ($Line = 0; Null)
            ]
         ], "PrimaryExamplesSection"]
      ],
      Replace[ lang, {
         "Japanese" :> {"\:4f8b\:984c", "\:8ffd\:52a0\:4f8b\:984c"}, (* reidai, tuika reidai *)
         _ :> {
                  "Examples",
                  RowBox[{"More", " ", "Examples"}]
                  }
      }]
   ]
,
   Cell[CellGroupData[
      Join[
         {
            Cell[
               Switch[ lang, 
                 "Japanese", "\:8ffd\:52a0\:4f8b\:984c", (* tuika reidai *)
                 _, "More Examples"],
               "ExtendedExamplesSection",
               CellTags->"ExtendedExamples"
            ]
         },
         Map[
            Function[{headText},
               Cell[
                  BoxData[
                     InterpretationBox[
                        Cell[ headText, "ExampleSection"],
                        ($Line = 0; Null)
                     ]
                  ],
                  "ExampleSection"
               ]
            ],
            Replace[ lang, {
               "Japanese" -> {
                  "\:30b9\:30b3\:30fc\:30d7", (* suko-pu *)
                  "\:4e00\:822c\:5316\:3068\:62e1\:5f35", (* ippanka to kakuchou *)
                  "\:30aa\:30d7\:30b7\:30e7\:30f3", (* opushon *)
                  "\:30a2\:30d7\:30ea\:30b1\:30fc\:30b7\:30e7\:30f3", (* apurike-shon *)
                  "\:7279\:6027\:3068\:95a2\:4fc2", (* tokusei to kankei *)
                  "\:6271\:3044\:306b\:304f\:3044\:554f\:984c", (* atsukainikui mondai *)
                  "\:30a4\:30f3\:30bf\:30e9\:30af\:30c6\:30a3\:30d6\:306a\:4f8b\:984c", (* interactive-na reidai *)
                  "\:683c\:597d\:3044\:3044\:4f8b\:984c" (* kakkouii reidai *)
               }
                 ,
               _ ->
                  {
                  "Scope",
                  "Generalizations & Extensions",
                  "Options",
                  "Applications",
                  "Properties & Relations",
                  "Possible Issues",
                  "Interactive Examples",
                  "Neat Examples"
                  }
            }]
         ]
      ],
   Open] ]
};

(** in-product parts **)
$DocEntry["PrimaryExamplesSectionText", language_:Automatic] :=
  Switch[language, 
    "Japanese", "\:4f8b",
     _, "Examples"
  ];
(* FIXME: Basic Examples for ExtendedExamplesSection? *)
$DocEntry["ExtendedExamplesSectionText", language_:Automatic] :=
  Switch[language, 
    "Japanese", "\:4f8b",
     _, "Basic Examples"
  ];
$DocEntry["BasicExamplesSectionText", language_:Automatic] :=
  Switch[language, 
    "Japanese", "\:4f8b",
     _, "Basic Examples"
  ];
$DocEntry["TutorialsSectionText", language_:Automatic] :=
  Switch[language, 
    "Japanese", "\:30c1\:30e5\:30fc\:30c8\:30ea\:30a2\:30eb",
     _, "Tutorials"
  ];
$DocEntry["SeeAlsoSectionText", language_:Automatic] :=
  Switch[language, 
    "Japanese", "\:95a2\:9023\:9805\:76ee",
     _, "See Also"
  ];
$DocEntry["RelatedLinksSectionText", language_:Automatic] :=
  Switch[language, 
    "Japanese", "\:95a2\:9023\:30ea\:30f3\:30af",
     _, "Related Links"
  ];
$DocEntry["OptionsSectionText", language_:Automatic] :=
  Switch[language, 
    "Japanese", "\:4f8b",
     _, "Options"
  ];
$DocEntry["ImportExportSectionText", language_:Automatic] :=
  Switch[language, 
    "Japanese", "\:4f8b",
     _, "Import and Export"
  ];
$DocEntry["NotebookInterfaceSectionText", language_:Automatic] :=
  Switch[language, 
    "Japanese", "\:4f8b",
     _, "Notebook Interface"
  ];
$DocEntry["ElementsSectionText", language_:Automatic] :=
  Switch[language, 
    "Japanese", "\:4f8b",
     _, "Elements"
  ];


$DocEntry[anchorbar, language_:Automatic] :=
Cell[TextData[
  Switch[language, 
    "Japanese", { 
        ButtonBox["\:4f8b", 
          ButtonFunction:>FrontEnd`NotebookFind[ FrontEnd`InputNotebook[], 
          "PrimaryExamplesSection", Next, CellStyle],  BaseStyle->"AnchorLink"],
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\[ThickSpace]", 
        ButtonBox["\:30c1\:30e5\:30fc\:30c8\:30ea\:30a2\:30eb", 
          ButtonFunction:>FrontEnd`NotebookFind[ FrontEnd`InputNotebook[], 
          "TutorialsSection", Next, CellStyle], BaseStyle->"AnchorLink"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\[ThickSpace]", 
        ButtonBox["\:95a2\:9023\:9805\:76ee", 
          ButtonFunction:>FrontEnd`NotebookFind[ FrontEnd`InputNotebook[], 
          "SeeAlsoSection", Next, CellStyle], BaseStyle->"AnchorLink"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\[ThickSpace]", 
        ButtonBox["\:95a2\:9023\:30ea\:30f3\:30af", 
          ButtonFunction:>FrontEnd`NotebookFind[ FrontEnd`InputNotebook[], 
          "RelatedLinksSection", Next, CellStyle], BaseStyle->"AnchorLink"] },
     _, {
        ButtonBox["Examples", 
          ButtonFunction:>FrontEnd`NotebookFind[ FrontEnd`InputNotebook[], 
          "PrimaryExamplesSection", Next, CellStyle], BaseStyle->"AnchorLink"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\[ThickSpace]",
        ButtonBox["Tutorials", 
          ButtonFunction:>FrontEnd`NotebookFind[ FrontEnd`InputNotebook[], 
          "TutorialsSection", Next, CellStyle], BaseStyle->"AnchorLink"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\[ThickSpace]", 
        ButtonBox["See Also", 
          ButtonFunction:>FrontEnd`NotebookFind[ FrontEnd`InputNotebook[], 
          "SeeAlsoSection", Next, CellStyle], BaseStyle->"AnchorLink"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\[ThickSpace]", 
        ButtonBox["Related Links", 
          ButtonFunction:>FrontEnd`NotebookFind[ FrontEnd`InputNotebook[], 
          "RelatedLinksSection", Next, CellStyle], BaseStyle->"AnchorLink"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\[ThickSpace]"
        }]
], "AnchorBar"];


(** in-product parts **)
$DocEntry[linktrail, language_:Automatic] :=
Cell[TextData[
  Switch[language, 
    "Japanese", { ButtonBox["\:30db\:30fc\:30e0", ButtonData->"paclet:Guides/Mathematica", BaseStyle->"TrailLink"],
      " > " (*,
      ButtonBox["\:30a2\:30eb\:30d5\:30a1\:30d9\:30c3\:30c8\:9806\:306e\:95a2\:6570\:30ea\:30b9\:30c8", ButtonData->"paclet:Guides/AlphabeticalListing", BaseStyle->"TrailLink"],
      " > " *)},
     _, { ButtonBox["Home", ButtonData->"paclet:Guides/Mathematica", BaseStyle->"TrailLink"],
     " > ",
     Cell[BoxData[
       DynamicModuleBox[{Global`destination$$ = 0}, 
       DynamicBox[
         FEPrivate`If[ FEPrivate`HistoryList["Back"] === {}, RowBox[{" "}], 
           RowBox[{
             ButtonBox[FEPrivate`Part[FEPrivate`HistoryList["Back"], 1,2], 
               ButtonFunction :> FrontEndToken[ButtonNotebook[], "HyperlinkGoBack"], 
               Evaluator -> None, BaseStyle->"TrailLink"], 
             " > "}
           ]
         ]
       ]] 
     ]]
  }]
], "LinkTrail"];


(** end $DocEntry defs **)

SplitAndRefineTextDataList[z_List] := 
 (Split[z, FreeQ[#, x_String /; StringMatchQ[x, "*\n*"]] &] /. {"\[FilledSmallSquare]" -> Sequence[], 
     x_String /; Not@StringFreeQ[x, "\n"] && Not@StringFreeQ[x, "\[FilledSmallSquare]"] :> 
      StringReplace[x, "\[FilledSmallSquare]" -> ""]}) /. 
     {{StyleBox[x_String /; StringMatchQ[x, " " ~~ __], "MR"], b__} :> {StyleBox[StringDrop[x, 1], "MR"], b}, 
      {StyleBox[" ", "MR"], b__} :> {b}}
      
PositionOfFirstOccurrenceOfNoteInTextDataList[z_List] := 
 Min@Flatten[Position[z, {_String | StyleBox[a_String /; 
                                        Not@StringMatchQ[a, Alternatives @@ CharacterRange["A", "Z"] ~~ ___], _], __}, 1]]
                                        
CriticalPartsOfRefGuide[nb_Notebook] := 
 Cases[nb, Cell[CellGroupData[{u : Cell[_, "ObjectName", ___], ce_, ex___}, Open]] :> 
 {u, {#, PositionOfFirstOccurrenceOfNoteInTextDataList[#], 
                                                        Length@#} &[SplitAndRefineTextDataList[ce[[1, 1]]]], ex}, Infinity]
                                                        
RegularizeReducedRefGuideEntry[rgecg_] := 
 Which[rgecg[[2, 2]] === \[Infinity] && Length[rgecg] === 2, 
       Cell[CellGroupData[{rgecg[[1]], Cell[TextData[Flatten[rgecg[[2, 1]]]], "Usage"]}, Open]], 
       rgecg[[2, 2]] === \[Infinity] && Length[rgecg] === 3, 
       Cell[CellGroupData[{rgecg[[1]], Cell[TextData[Flatten[rgecg[[2, 1]]]], "Usage"], rgecg[[3]]}, Open]], 
       rgecg[[2, 2]] === rgecg[[2, 3]] && Length[rgecg] === 2, 
       Cell[CellGroupData[{rgecg[[1]], Cell[TextData[Flatten[Take[rgecg[[2, 1]], rgecg[[2, 2]] - 1]]], "Usage"], 
                           Cell[TextData[Flatten[rgecg[[2, 1]][[-1]]]], "Notes"] /. x_String /; StringMatchQ[x, "*\n*"] :> 
                                                                                     StringReplace[x, "\n" -> ""]}, Open]], 
       rgecg[[2, 2]] === rgecg[[2, 3]] && Length[rgecg] === 3, 
       Cell[CellGroupData[{rgecg[[1]], Cell[TextData[Flatten[Take[rgecg[[2, 1]], rgecg[[2, 2]] - 1]]], "Usage"], 
                           Cell[TextData[Flatten[rgecg[[2, 1]][[-1]]]], "Notes"] /. x_String /; StringMatchQ[x, "*\n*"] :> 
                                                                          StringReplace[x, "\n" -> ""], rgecg[[3]]}, Open]], 
       rgecg[[2, 2]] < rgecg[[2, 3]] && Length[rgecg] === 2, 
       Cell[CellGroupData[{rgecg[[1]], Cell[TextData[Flatten[Take[rgecg[[2, 1]], rgecg[[2, 2]] - 1]]], "Usage"], 
Sequence @@ ((Cell[TextData[#], "Notes"] & /@ Take[rgecg[[2, 1]], {rgecg[[2, 2]], -1}]) /. 
                                             x_String /; StringMatchQ[x, "*\n*"] :> StringReplace[x, "\n" -> ""])}, Open]], 
       rgecg[[2, 2]] < rgecg[[2, 3]] && Length[rgecg] === 3, 
       Cell[CellGroupData[{rgecg[[1]], Cell[TextData[Flatten[Take[rgecg[[2, 1]], rgecg[[2, 2]] - 1]]], "Usage"], 
      Sequence @@ ((Cell[TextData[#], "Notes"] & /@ Take[rgecg[[2, 1]], {rgecg[[2, 2]], -1}]) /. 
                                 x_String /; StringMatchQ[x, "*\n*"] :> StringReplace[x, "\n" -> ""]), rgecg[[3]]}, Open]], 
       True, 
       rgecg] /. Cell[TextData[{a__, b_String}], "Usage"] :> Cell[TextData[{a, StringReplace[b, "\n" -> ""]}], "Usage"]
       
(* CreateRegularizedRefGuide can be used to preprocess application refguides and then use DivideRefGuide[] on the result.
   It was designed with the Geometrica RefGuide in mind. *)

CreateRegularizedRefGuide[nbpath_] := 
 NotebookPut@Notebook[RegularizeReducedRefGuideEntry /@ CriticalPartsOfRefGuide[Get[nbpath]], 
                                                                                      StyleDefinitions -> "HelpBrowser.nb"]

$RefGuidePath = ""

DivideRefGuide[] := 
 Module[{nn = NextNotebook[]},
  If[nn =!= None && NotebookFilePath[nn] =!= $Failed,
  
     $RefGuidePath = NotebookFilePath[nn]; 
     NotebookPut[CreateReferencePagesFromRefGuideDialog[$RefGuidePath, "input"]],
     
     If[$RefGuidePath =!= "" && FileType[$RefGuidePath] === File, 
        If[# =!= Null && # =!= $Canceled, 
           $RefGuidePath = #, 
           Abort[]] &[SystemDialogInput["FileOpen", $RefGuidePath, WindowTitle -> "Select a notebook"]], 
     Quiet[While[FileType[$RefGuidePath] === None || Not@ValueQ[$RefGuidePath] || $RefGuidePath === "", 
              If[# =!= Null && # =!= $Canceled, 
                 $RefGuidePath = #, 
                 Abort[]] &[SystemDialogInput["FileOpen", $DocumentationDirectory, WindowTitle -> "Select a notebook"]]],
           FileType::fstr]]; 
     NotebookPut[CreateReferencePagesFromRefGuideDialog[$RefGuidePath, "browsed for"]]]]
     
CancelCreateReferencePagesFromRefGuideDialogVariables[previous$ApplicationName_, previous$LinkBase_] := (DocumentationTools`$ApplicationName = previous$ApplicationName; 
                                                                                                         DocumentationTools`$LinkBase = previous$LinkBase)
     
CreateReferencePagesFromRefGuideDialog[refguide_, nbselected_] := 
 Module[{u, v, s, t}, s = DocumentationTools`$ApplicationName; t = DocumentationTools`$LinkBase;
 Notebook[{Cell["", FontSize -> 1, CellElementSpacings -> {"CellMinHeight" -> 1}, Selectable -> False], 
   Cell[TextData[{"The notebook in this dialog was determined by the ", StyleBox[nbselected, FontWeight -> "Bold"], "\nnotebook. If this is not what is desired, click on the Extract\nFunction Pages button with no saved notebooks open."}], 
        "Text", FontFamily -> "Verdana", FontSize -> 11, CellMargins -> {{8, 8}, {7, 1}}], 
   Cell[BoxData[ToBoxes@Style[Grid[{{Style["Source Notebook: ", Bold, Editable -> False, Selectable -> False], 
                                     TextCell[refguide]}, 
                                    {Style["Application Name: ", Bold, Editable -> False, Selectable -> False], 
                                     InputField[Dynamic[DocumentationTools`$ApplicationName], String, FieldSize -> {40, {1, Infinity}}]},
                                    {Style["Link Base: ", Bold, Editable -> False, Selectable -> False], 
                                     InputField[Dynamic[DocumentationTools`$LinkBase], String, FieldSize -> {40, {1, Infinity}}]},
                                    {"", OldRow[{Button[Style["OK", Bold], 
                                                        UpdatePacletVariables[u, v];
                                                        CreateReferencePagesFromRefGuide[refguide], 
                                                        Method -> "Queued"] /. {u -> s, v -> t}, 
                                                 Button[Style["Cancel", Bold], 
                                                        (CancelCreateReferencePagesFromRefGuideDialogVariables[u, v] /. {u -> s, v -> t});
                                                        NotebookClose[EvaluationNotebook[]], 
                                                        Method -> "Queued"]}, RowAlignments -> Center]}}, 
                                   Alignment -> Left, Spacings -> {Automatic, 3 -> 1}], 
                              FontFamily -> "Verdana", FontSize -> 11]]], 
   Cell["", FontSize -> 1, CellElementSpacings -> {"CellMinHeight" -> 1}, Selectable -> False]}, 
          WindowMargins -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
          WindowFrame -> "Palette", 
          WindowElements -> {}, 
          WindowFrameElements -> {}, 
          ShowCellBracket -> False, 
          ClosingAutoSave -> False, 
          WindowTitle -> "Create Reference Pages From RefGuide", 
          Saveable -> False, 
          ShowStringCharacters -> False, 
          Selectable -> False, 
          WindowSize -> {580, FitAll}]]
          
CreateReferencePagesFromRefGuide::$ApplicationNameError = "$ApplicationName must be a nonempty string containing no backquotes (`).";
CreateReferencePagesFromRefGuide::$LinkBaseError = "$LinkBase must be a nonempty string containing no backquotes (`).";
CreateReferencePagesFromRefGuide::nosymbolswithusage = "$ApplicationName has no symbols with usage messages.";
CreateReferencePagesFromRefGuide::notsymbolswithusage = "There are RefGuide entries that are not symbols with usage messages.";

CreateReferencePagesFromRefGuide[refguide_] :=
 Module[{presetMessageOptionsValues, newMessageOptionsValues, refpagesdir, pnb}, 
  Catch[Which[Not@StringQ[DocumentationTools`$ApplicationName] || StringMatchQ[DocumentationTools`$ApplicationName, "" | " " ..] || 
                                                                                      Not@StringFreeQ[DocumentationTools`$ApplicationName, "`"],
  
     MessageToConsole[CreateReferencePagesFromRefGuide::$ApplicationNameError],
     
     Not@StringQ[DocumentationTools`$LinkBase] || StringMatchQ[DocumentationTools`$LinkBase, "" | " " ..] || Not@StringFreeQ[DocumentationTools`$LinkBase, "`"],
       
     MessageToConsole[CreateReferencePagesFromRefGuide::$LinkBaseError],
     
     True,
     
     presetMessageOptionsValues = MessageOptions /. Options[$FrontEnd, MessageOptions];
     (* New MessageOptions has "KernelMessageAction" with "PrintToConsole". *)
     newMessageOptionsValues = If[(cs = Cases[presetMessageOptionsValues, a : ("KernelMessageAction" -> _)]; cs) === {}, 
                                  Append[presetMessageOptionsValues, 
                                         "KernelMessageAction" -> {"Beep", "PrintToNotebook"}], 
     presetMessageOptionsValues /. ("KernelMessageAction" -> a_) :> ("KernelMessageAction" -> If[StringQ[a], 
                                                                                                 "PrintToConsole", 
                                                                                   Append[DeleteCases[a, "PrintToNotebook"], 
                                                                                          "PrintToConsole"]])]; 
     SetOptions[$FrontEnd, MessageOptions -> newMessageOptionsValues];
             
     Needs[DocumentationTools`$ApplicationName <> "`"];
             
     $ApplicationSymbolsWithUsage  = SymbolsWithUsage[DocumentationTools`$ApplicationName];
     	           
    If[$ApplicationSymbolsWithUsage === {}, Throw[MessageToConsole[CreateReferencePagesFromRefGuide::nosymbolswithusage, DocumentationTools`$ApplicationName]]];
             
             (* Restore previous MessageOptions. *)
    SetOptions[$FrontEnd, MessageOptions -> presetMessageOptionsValues];
     
     NotebookClose[EvaluationNotebook[]]; 
     ParseApplicationRefGuide[refguide];
     If[Complement[$FunctionNames, $ApplicationSymbolsWithUsage] =!= {}, 
        Throw[MessageToConsole[CreateReferencePagesFromRefGuide::notsymbolswithusage]]];
     refpagesdir = DirectoryName[refguide] <> "ReferencePages";
     If[FileType[refpagesdir] =!= Directory, CreateDirectory[refpagesdir]]; 
     pnb = CreatePalette[ProgressIndicator[Dynamic[Clock[Infinity]], Indeterminate, ImageSize -> {300, 30}], 
                         WindowMargins -> Automatic, WindowTitle -> "DivideRefGuide is Constructing Reference Pages", 
                         WindowSize -> {300, Fit}];
     ExportApplicationRefGuideEntryNotebooks[refpagesdir, {}]; 
     NotebookClose[pnb]]]]


MergeRefGuideNotebooks[listofpaths_List, outnbpath_String]:=
  Module[{nb},
         Quiet[nb = NotebookPut[Notebook[Flatten[First /@ (Get /@ listofpaths)], 
                               Sequence @@ Take[Get[listofpaths[[1]]], {2, -1}]]]];
         NotebookSave[nb, outnbpath]]
         
checkRef[opts___?OptionQ]:= Module[{f = RefGuide /. {opts} /. Options[ConvertApplicationRefGuideEntry]},
    Which[
        !MatchQ[f,_String|Automatic],
        MessageToConsole[DocumentationConversion::rgfile, f];
        False
        ,
        f===Automatic && imported[$RefGuideFileName] === True,
        True
        ,
        f===$RefGuideFileName && imported[f] === True,
        True,
        True,
        ParseApplicationRefGuide[f]=!=$Failed
    ]
]

Options[ParseApplicationRefGuide] = {ForceImport->False}
(* get refguide *)
ParseApplicationRefGuide[opts___?OptionQ] := ParseApplicationRefGuide[Automatic, opts];
ParseApplicationRefGuide[file:(_String|Automatic), opts___?OptionQ]:= Module[{f=file, nb, tmp, force},
    Catch[
        If[f===Automatic,
           f=ToFileName[{$InstallationDirectory,"Documentation","English","RefGuide"},"RefGuide.nb"]
        ];
      gt = Get[file];
      nb = If[Not@FreeQ[gt, Cell["Example"|"Examples", ___]],
              NotebookPut[gt/.
                Cell[CellGroupData[{Cell["Example" | "Examples", _, e___], a__}, o_]] :> 
                  (Cell[CellGroupData[{Cell["Further Examples", "ExampleSection", e], a}, o]] /. 
                                                                      Cell[t_, "Text", s___] :> Cell[t, "ExampleText", s])],
              NotebookPut[gt]];
        NotebookSave[nb, StringReplace[file, ".nb" ->"temp.nb"]];
        NotebookClose[nb];
        f = StringReplace[file, ".nb" ->"temp.nb"];
        $TempRefGuide = f;
        force = ForceImport /. {opts} /. Options[ParseApplicationRefGuide];
        If[force || imported[f]=!=True,
            If[(tmp=Get[escape@f])===$Failed,
                Throw[$Failed]
                ,
                (* set up some internal info *)
                imported[f]=True;
                $RefGuideFileName = f;
                $RefGuide = tmp;
                
                (* remove examples *)
                $RefGuide = DeleteCases[$RefGuide, 
                    Cell[CellGroupData[{Cell[_, "ExampleSection", ___], ___}], ___], 
                    Infinity];
                (* make list of functions *)
                $FunctionNames = Cases[$RefGuide, Cell[CellGroupData[{Cell[f_, "ObjectName", ___], ___}, ___], ___] :> (f/.TextData[StyleBox[s_,_]]:>s), Infinity] /.  { "JacobiSN, JacobiCN, \[Ellipsis] " -> "Jacobi", "InverseJacobiSN, InverseJacobiCN, \[Ellipsis] " -> "InverseJacobi"}
            ]
        ]
    ]
]

Options[ConvertApplicationRefGuideEntry] = 
    Options[ExportRefGuideEntry] = 
    Options[ExportRefGuideEntryNotebooks] = 
      {RefGuide->Automatic, SymbolContext->"System`",Language->"English",
      EnglishDocPath->None}

ConvertApplicationRefGuideEntry[functions_List, opts___?OptionQ]:=
    If[checkRef[opts], 
        ConvertApplicationRefGuideEntry[#,opts]&/@functions,
        $Failed
    ]
    
ConvertApplicationRefGuideEntry::tpltxt = "Text data `1` encountered as contents of
a \"FunctionTemplate\" cell, at a point in processing where it should
have already been transformed to box data."

ConvertApplicationRefGuideEntry::lang = "Language option must be a String of a valid language,\
 like \"English\" or \"Japanese\"."


ConvertApplicationRefGuideEntry[function_String, opts___?OptionQ]:= 
  Module[{retval,language,content},
    If[checkRef[opts],
        language = Language /. {opts} /. Options[ExportApplicationRefGuideEntry];

        (** snag refguide entry from the $RefGuide nb **)
        
        content = DeleteCases[
          InlineFormulaRegularize[
(*  Must change old "InlineFormula" to "InlineMath" style. 
    Before InlineFormulaRegularize can be applied the usage and notes cells must have structure very similar to
    those in the 5.2 ref guide -- the transformation rules below are applied with that in mind. *)
            ReplaceRepeated[
              Cases[$RefGuide, 
(*  Changes to avoid making bogus cell group. *)
                Switch[language,
                  "Japanese",
                    Cell[CellGroupData[
                      cellList:{Cell[TextData[StyleBox[function,"JT"]],"ObjectName",___],___},
                        ___], ___] :> cellList,
                  _,
                    Cell[CellGroupData[
                      cellList:{Cell[function, "ObjectName", ___], ___},
                        ___], ___] :> cellList
                ],
                Infinity
              ],
              Cell[ con_, "InlineFormula", copts___] :> Cell[ con, "InlineMath", copts]
            ] // OnslaughtOfReplacementRules
          ], _[CellTags,_], Infinity];

        (** title **)
        $DocEntry[title, language] = Cases[content,
            Switch[language,
              "Japanese", 
                Cell[TextData[StyleBox[function,"JT"]],"ObjectName",___],
              _,
                Cell[function,"ObjectName",___]
            ],Infinity
        ];

        (** usage **)
        $DocEntry[usage,language] = ReplaceRepeated[
          Cases[
            content, Cell[c_,"Usage",___]:>Cell[c,"Usage"],
            Infinity
          ]
          /.
            TextData[ {tdelems___} ] :>
              TextData[
                Flatten[
                  Take[
                    Replace[
                      Partition[ {"\n", tdelems}, 2, 1],
                    {
                      {
                        s_String /;
                          AtomQ[s] && StringMatchQ[s, ___ ~~ "\n"],
                        Cell[ ucont_, "FunctionTemplate" | "InlineFormula", uopts___]
                      } :>
                        {
                        s,
                        Cell["      ", "ModInfo"],
                        Cell[ ucont, "InlineFormula", uopts],
                        "\[LineSeparator]"
                        } ,
                      {
                        s_String /;
                          AtomQ[s] && StringMatchQ[s, ___ ~~ "\n"],
                        Cell[ ucont_, "InlineFormula", uopts___]
                      } :>
                        {
                        s,
                        Cell["      ", "ModInfo"],
                        Cell[ ucont, "InlineFormula", "TemplateExclusion", uopts],
                        "\[LineSeparator]"
                        }
                    },
                      {1}
                    ],
                    All,
                    {2, -1}
                  ]
                ]
              ],
          {
            (* TODO - remove jp ha from usage def *)
            (* merge *[* \[LineSeparator] with next string, remove unnecessary spaces *)
            h_[
            {
              f___, c : Cell[___, "InlineFormula", ___], "\[LineSeparator]", s_String|StyleBox[s_String,"JT"], l___
            }] :> 
              h[{f, c, StringReplace[s, 
                RegularExpression["^\\s*(?:\:306f(?:\:ff0c)?)?"] -> "\[LineSeparator]"], l}],
            StyleBox[s__,"MR"]:>s
          }
        ];

        (** notes **)
        $DocEntry[notes,language] = Cases[
          content,Cell[c_,"Notes",___]:>Cell[c,"Notes"],
          Infinity
        ];

        (** see also **)
        $DocEntry[seealso,language] = (Cell[CellGroupData[
            { Cell[
              Switch[language,
                "Japanese","\:95a2\:9023\:9805\:76ee", (* kanren mokuji *)
                _,"See Also"
              ], "SeeAlsoSection"], Sequence@@# }
        ]]& [
            (* This turns the old see also: stuff into the new style *)
          DeleteCases[
            Cases[content, 
              (* find old see also cell *)
              Cell[TextData[{
                Switch[language,
                  "Japanese",
                  (* jt stlyeboxes that match ^(tsugimo)?sansho *)
                  StyleBox[s_String,"JT"]/;!StringFreeQ[s, RegularExpression["^\:6b21\:3082\:53c2\:7167"]],
                  _,s_String/;!StringFreeQ[s, "See also:"]
                ],
                b___}], "Notes", l___] :>
              (* and turn it into the new cell style *)
              Cell[TextData[{b}], "SeeAlso"]
              ,Infinity
            ] /. {
              (* create new buttons, add new line between them *)
              ButtonBox[f_String, o___?OptionQ] :>
                ButtonBox[f, BaseStyle -> "FunctionLink",
                  Sequence @@ DeleteCases[{o}, _[BaseStyle, _]]],

              (* remove old punctuation *)
              x_String /; StringMatchQ[x, RegularExpression["(?:[,.]|\:ff0c)\\s*"]] -> Null,
              StyleBox[_,"JT"]->Null
            }
            , Null, Infinity
          ] /. c:Cell[_,"InlineFormula"]:>Sequence@@{c," \[EmptyVerySmallSquare] "}
            /. TextData[{f__, " \[EmptyVerySmallSquare] "}]:>TextData[{f}]
        ]);

        (** packages **)
        (* these still have StyleBox[,"MR"]'s around the entries *)
        $DocEntry[packages,language] = Cell[CellGroupData[{
            Cell[
              Switch[language,
                "Japanese", "\:62e1\:5f35/\:95a2\:9023\:30d1\:30c3\:30b1\:30fc\:30b8", (* kakuchou / kanren pakke-ji *)
                _, "Extensions / Related Packages"], "ExtensionsSection"],
            Sequence@@(
              Cases[$DocEntry[notes], Cell[TextData[{
                s_String /; !StringFreeQ[s,StartOfString~~"Related package"],
                r___}],
                "Notes",___]:>Cell[TextData[{r}],"Extensions"]
                ,Infinity
              ] /. {
                {} -> {Cell[ "XXXX", "Extensions"]},
                Cell[TextData[l_List],r___] :>
                   Cell[TextData[
                      DeleteCases[
                         Replace[ l, {", " -> " \[EmptyVerySmallSquare] "}, {1}],
                         Except[ " \[EmptyVerySmallSquare] ", _String]
                      ]
                   ], r]
              }
            )
          }
        ]];
        
        (** tutorials a.k.a - mainbook links **)

        $DocEntry[tutorials,language] = Cell[ CellGroupData[{
          Cell[Switch[language,
            "Japanese","\:30c1\:30e5\:30fc\:30c8\:30ea\:30a2\:30eb", (* chuutoriarusu *)
            _,"Tutorials"
            ],"TutorialsSection"],
          Cell["XXXX","Tutorials"]
        }, Open] ];

        (** old stuff **)
        $DocEntry[legacy,language] = Cell[CellGroupData[{
            Cell["XXXX Legacy Material XXXX", "LegacyMaterialSection"],
            Sequence@@#
        }]]& [
            Select[$DocEntry[notes,language], legacyNotesQ] /.
              Cell[TextData[
              {
                Switch[language,
                  "Japanese",
                  StyleBox[s,"JT"] /; ! StringFreeQ[s, "\:30bb\:308f\:30b7\:30e7\:30f3"],
                  _, s_String /; !StringFreeQ[s,"See "]
                ],
                b:ButtonBox[s2_String /; !StringFreeQ[s2,
                  RegularExpression["^(?:Section|[A\\d]\\d*\\.|Page)"]],o___],r___
              }], "Notes", ___] :> Cell[TextData[{s,b,r}],"Notes"]
              
              /. 
              {              
                ButtonBox[s_String,o___]:>ButtonBox[
                  StringReplace[s,
                    RegularExpression["(?:Section\\s+)?([A\\d]\\d*\\.\\d+\\.\\d+).*"]
                    :>("$1"/.$SectionToTitles)],
                  ButtonData->
                    StringReplace[s,
                       RegularExpression["(?:Section\\s+)?([A\\d]\\d*\\.\\d+\\.\\d+).*"]
                       :>("$1"/.$SectionToFileNames)],
                  BaseStyle->"TutorialLink"
                ]
              }
              /. TextData[{f__,"\n"}]:>TextData@f
        ];
        
        (** create regular content by deleting everything else... **)
        (* there should be a more constructive way to do this... *)
        
       $DocEntry[content,language] = Fold[
            DeleteCases[#1,#2,Infinity]&,
            content,
            {
              Cell[_,"ObjectName",___],
              (* history *)
              Cell[TextData[{Cell[_, "History"], ___}], "Text"],
              Cell[TextData[Cell[_, "History"], ___], "Text"],
              Cell[_,"History",___],
              (* usagemessages *)
              Cell[TextData[Cell[_, "UsageMessagesSection"], ___], "Text"],
              Cell[_,"UsageMessages",___],
              Cell[TextData[Cell[_, "TemplatesSection"], ___], "Text"],
              (* usage *)
              Cell[_,"Usage",___],
              (* template *)
              Cell[TextData[{___, Cell[_, "TemplatesSection"], ___}], "Text"],
              (* old notes *)
              expr_/;oldNotesQ[expr]
            }
        ];

        $DocEntry[maincomplex,language] =
            Cell[
                CellGroupData[
                    Flatten[ Thread[$DocEntry[{title, usage, content},language]]],
                    Open
                ]
            ];

        (* put everything back together again *)
        
        retval = Flatten[
                Thread[$DocEntry[
                  { 
                    maincomplex (*title, usage, content*), 
                    tutorials, 
                    relatedlinks,
                    seealso,
                    packages,
                    examples,
                    designdisc,
                    appnotes,
                    legacy
                  }, 
                  language
                ]]
        ]; 
        
        (* do some final post processing... *)
        retval = retval //.
        {
            (* kill FormBox's *)
            FormBox[stuff_GridBox,TraditionalForm] :> stuff,
            FormBox[stuff_,ProgramForm] :> stuff,

            (* button rules *)
            ButtonBox[s_, BaseStyle->"RefGuideLink"]:>
              ButtonBox[s,BaseStyle->"FunctionLink"],

            (* remove JT style boxes? *)
            StyleBox[s_String,"JT"]:>s

            (* more global processing here *)
        }
        ,
        $Failed
    ]
  ]
    

OnslaughtOfReplacementRules[ expr_] := (
expr
 //.
(* *)
(* Change Text cells to Notes cells. *)
(* *)
 {a___, Cell[b_, "Text", c___], d___} :> {a, Cell[b, "Notes", c], d}
(* *)
(*
Turn styleless tradform cells for subscripted variables
into the "InlineMath" forms expected by InlineFormulaRegularize.
*)
/.
Cell[ BoxData[
  FormBox[ SubscriptBox[ a_String, b_String], TraditionalForm] 
] ] :> 
  Cell[ BoxData[
    FormBox[
      SubscriptBox[
        StyleBox[ a, "TI"],
        StyleBox[ b,If[ DigitQ @ b, "TR", "TI"] ] ],
      TraditionalForm
    ]
    ], "InlineMath"]
(*
     Commenting out this transformation from Jay Warendorff.
It's too soon to make InlineFormula cells here.  If there
are lots of these multiple subscripted variable forms, we
might have to put in a rule to split them up. --walsh
*)
(*
  Cell[BoxData[
    FormBox[
      RowBox[{
        "{",
        RowBox[{SubscriptBox[a_String, "1"], ",", SubscriptBox[a_String, "2"]}],
        "}"
      }],
      TraditionalForm
    ]
  ] ] :> 
    Cell[BoxData[
      RowBox[{
        "{",
        RowBox[{
          SubscriptBox[ StyleBox[ a, "TI"], StyleBox["1", "TR"] ],
      ",",
          SubscriptBox[ StyleBox[ a, "TI"], StyleBox["2", "TR"] ]
        }],
        "}"
      }]
    ], "InlineFormula"]
} *)
/.
(*  *)
ce:
  Cell[ CellGroupData[{Cell[_, "ObjectName", ___], __}, Open]] |
  Cell[_, "Usage"|"Notes", e___] :> 
(
ce /.
(* Change ellipses in three-period form to ellipsis characters *)
{
  a__,
  StyleBox[",", "MR"],
  StyleBox[" ...", "TI"],
  StyleBox["}]", "MR"],
  b___
} :> 
  {
    a,
    StyleBox[",", "MR"],
    " ",
    "\[Ellipsis]",
    " ",
    StyleBox["}]", "MR"],
    b
  }
(*
  Eliminate explicit FontSize specifications.
*)
/. 
{
(* Do not take away "Text" or "TI" styling on " "--it tells us
  when a space is part of an InlineFormula representation.
*)
(*  StyleBox[" ", "Text" | "TI")] -> " ", *)
  StyleBox[a_String, b_String, FontSize->_] :> StyleBox[a, b]
}
(* Already been done, seems like. Commenting out. *)
(*
/. 
Cell[a_, "Text", b___] :> Cell[a, "Notes", b]
*)
(* Italicizing quotation marks around an italic string seems wrong *)
(*
/. 
Cell[
  TextData[{
    a___,
    "\"",
    StyleBox[b_String, FontSlant -> "Italic"],
    "\"",
    c___
  }],
  s : ("Usage" | "Notes"),
  d___
] :> 
                               Cell[TextData[{a, StyleBox["\"" <> b <> "\"", FontSlant -> "Italic"],c}], s, d]
*)
)
/. 
(* "TI" or italicized spaces need to keep that style, because they are
probably part of an expression representation. *)
{
  StyleBox[" ", "TR"] -> " ",
  StyleBox["\[Rule]", "MR"] -> StyleBox["->", "MR"],
  StyleBox[", ... ","TI"] ->
    Sequence[ StyleBox[",", "MR"], StyleBox[" ", "TI"], StyleBox["\[Ellipsis]", "TR"] ],
  StyleBox[x_String /; StringMatchQ[x, " " ~~ __], FontSlant -> "Italic"] :> 
    Sequence[ StyleBox[" ", FontSlant -> "Italic"], StyleBox[ StringDrop[x, 1], FontSlant -> "Italic"] ],
  StyleBox[x_String /; StringMatchQ[x, " " ~~ __], "TI"] :> 
    Sequence[ StyleBox[" ", "TI"], StyleBox[StringDrop[x, 1], "TI"]]
}
/.
(* Bring careless style directives to heel *)
{
  StyleBox[" ", FontSlant->"Italic"] -> " ",
  StyleBox[",",FontFamily->"Courier New"] -> StyleBox[",","MR"],
  (FontFamily->"Courier") -> "MR",
  (FontSlant->"Italic") -> "TI"
}
(* Consolidate expression representation stuff amid textdata *)
//.
$consolidateAmidRule
)

$consolidateAmidRule = (
(* Consolidate expression representation stuff amid textdata *)
   Cell[
      TextData[{
         preOther:
            (
               " " |
               Except[ $expressionRepresentationElement,
                  _String | _Cell | _ButtonBox | _StyleBox
               ]
            )..., 
         ss1:
            (
               " " |
               Except[ $expressionRepresentationElement |
StyleBox[" ", ___] | $stylelessTraditionalFormCell,
                  _String | _Cell | _ButtonBox | _StyleBox
               ]
            )..., 
         inl: (
           $expressionRepresentationElement |
           StyleBox[" ", ___] |
           $stylelessTraditionalFormCell).. /;
             Not[ MemberQ[ {inl}[[{1,-1}]], " "] ],
         ss2:(" " |
           Except[ $expressionRepresentationElement |
StyleBox[" ", ___] | $stylelessTraditionalFormCell,
             _String | _Cell | _ButtonBox | _StyleBox ] )..,
         other___
      }
      ], 
      tsopts___
   ] :>
      Cell[ TextData[{
        preOther,
        ss1,
          MakeInlineMExpression[
            {inl} /. StyleBox[" ", ___]-> " "],
        ss2,
        other
      }], tsopts]
)

$stylelessTraditionalFormCell =
Cell[ BoxData[ FormBox[ _, TraditionalForm] ] ]


ExportApplicationRefGuideEntry[file_String, f_String, opts___?OptionQ] := 
  Module[
    {
      content, context, lang, engdocs, eng, pex, eex, examplesCell, cs, content2, content3, content4, content5, content6,
      content7, content8, content9, nb
    },
    If[checkRef[opts],
      {context,lang,engdocs} = {SymbolContext,Language,EnglishDocPath} 
        /. {opts} /. Options[ExportRefGuideEntry];
  
      If[!StringQ[context],
        context = "System`";
      ];

      (* do the actual conversion *)
      content = ConvertApplicationRefGuideEntry[f, SymbolContext->context, Language->lang];

      (* continue processing only if we got something to process *)
      If[ content =!= {},

        (* for the japanese docs, i am snagging sw's examples from the 
           corresponding (already converted) english doc.  This doc is
           assumed to live in the path pointed to by the option 
           EnglishDocPath *)
        If[ lang === "Japanese" && FileType[engdocs/.None->""] === Directory,

          (* merge examples from english docs.  the use of Get[]
             should be ok here because the english docs have already
             been saved by the frontend at one point, so grouping and
             everything should be kosher. *)
          If[(eng = Get[escape@ToFileName[{engdocs},f<>".nb"]])===$Failed, 
            Return[$Failed]];

          {pex, eex} = Cases[eng, Cell[CellGroupData[{
            Cell[_,#,___],ex___},___],___]:>ex,Infinity]&/@
            {"PrimaryExamplesSection","ExtendedExamplesSection"};
          
          If[Length[pex]>0,
            content = content /. {
              c:Cell[_,"PrimaryExamplesSection",___]:>
              Cell[CellGroupData[{c,Sequence@@pex},Open]]
            }
          ];
  
          (* translate the english section headers.  Note that the InterpretationBox is
             keeps being set to HoldAllComplete by the FE.  lame... *)
          ClearAttributes[InterpretationBox,HoldAllComplete];
          SetAttributes[InterpretationBox,HoldRest];
          eex = eex /. InterpretationBox[Cell[title_String,"ExampleSection",tag___],_] :> 
          
            InterpretationBox[Cell[title /. $e2j,"ExampleSection"], ($Line = 0; Null)];
          
          (* replace extended example section *)
          content = content /. {
            Cell[CellGroupData[{h:Cell[_,"ExtendedExamplesSection",___],___},open___],tag___]
            :>Cell[CellGroupData[{h,Sequence@@eex},open],tag]
          }
        ];
        
        examplesCell = Cell[BoxData[InterpretationBox[GridBox[{{StyleBox["Examples", "PrimaryExamplesSection"], 
                 ButtonBox[RowBox[{RowBox[{"More", " ", "Examples"}], " ", "\[RightTriangle]"}],
                   BaseStyle -> "ExtendedExamplesLink",
                   ButtonData :> "ExtendedExamples"]}}], $Line = 0; Null]], "PrimaryExamplesSection"];
       
        (* Get the Further Examples if any. *)
        
        cs = Cases[content, 
         Cell[CellGroupData[{Cell["Further Examples", "ExampleSection"], a__}, Open]] :> {a}, Infinity];
         
       (* Put the Further Examples in the correct location. *)
         
       content2 = (If[cs =!= {}, 
          content /. {Cell[CellGroupData[{Cell["Further Examples", "ExampleSection"], __}, Open]] -> Sequence[], 
                    Cell[_, "PrimaryExamplesSection"] -> Cell[CellGroupData[Insert[cs[[1]], examplesCell, 1], Open]]}, 
          content /. Cell[_, "PrimaryExamplesSection"] -> examplesCell] /. 
Cell[TextData[{x_String/;StringMatchQ[x, "\[FilledSmallSquare] See also:" ~~ Whitespace], __}], 
                                                                                              "Notes", ___] -> Sequence[]);
          
        (* Buttonize application function names and fix See Also cell. *)
        
        content3 = content2 /. {Cell[TextData[l_], s : ("Notes" | "Usage" | "ExampleText"), e___] :> 
                    Cell[TextData[l /. ButtonBox[a_ /; MemberQ[$FunctionNames, a], __] :> 
                                         Cell[BoxData[ButtonBox[a, BaseStyle -> "Link", 
                                      ButtonData -> "paclet:" <> DocumentationTools`$LinkBase <> "/ref/" <> a]], "InlineFormula"]], s, e],
                               Cell[TextData[b : {ButtonBox[__] ..}], "SeeAlso", e___] :> 
                    Cell[TextData[Riffle[Cell[BoxData[ButtonBox[#[[1]], BaseStyle -> "Link", 
                            ButtonData -> "paclet:" <> DocumentationTools`$LinkBase <> "/ref/" <> #[[1]]]], 
                          "InlineFormula"] & /@ b, " \[EmptyVerySmallSquare] "]], "SeeAlso", e],
                   Cell[TextData[ButtonBox[a_, BaseStyle -> "AddOnsLink", _]], "SeeAlso", e___] :> 
                    Cell[TextData[Cell[BoxData[ButtonBox[a, BaseStyle -> "Link", 
                         ButtonData -> "paclet:" <> DocumentationTools`$LinkBase <> "/ref/" <> a]], "InlineFormula"]], 
                         "SeeAlso", e]};
                         
    (* Remove \[FilledSmallSquare] instances from usage cell.  *)
    
        content4 = content3 /. {Cell[TextData[{"\[FilledSmallSquare] ", a__}], "Usage"] :> 
        (Cell[TextData[{a}], "Usage"] /. x_String :> StringReplace[x, "\[FilledSmallSquare]" -> ""]),
                                Cell[TextData[{"\[FilledSmallSquare] ", a__}], "Notes"] :> Cell[TextData[{a}], "Notes"],
                              Cell[TextData[{x_String /; StringMatchQ[x, "\[FilledSmallSquare] " ~~ __], a__}], "Notes"] :>
                                Cell[TextData[{StringDrop[x, 2], a}], "Notes"],
                                Cell[x_String /; StringMatchQ[x, "\[FilledSmallSquare] " ~~ __], "Notes", e___] :> 
                               Cell[StringDrop[x, 2], "Notes", e]};
                               
        content5 = Join[{Cell[TextData[{"New in: ", Cell[" ", "HistoryData", CellTags -> "New"], " | Modified in: ", 
                         Cell[" ", "HistoryData", CellTags -> "Modified"], " | Obsolete in: ", 
                         Cell[" ", "HistoryData", CellTags -> "Obsolete"], " | Excised in: ", 
                         Cell[" ", "HistoryData", CellTags -> "Excised"]}], "History"], 
                         Cell[CellGroupData[{Cell["Categorization", "CategorizationSection"], 
                         Cell["Symbol", "Categorization", CellLabel -> "Entity Type"], 
                         Cell[DocumentationTools`$ApplicationName <> " Package", "Categorization", CellLabel -> "Paclet Name"], 
                         Cell[Context[f], "Categorization", CellLabel -> "Context"]}, Closed]], 
                         Cell[CellGroupData[{Cell["Synonyms", "SynonymsSection"], Cell["XXXX", "Synonyms"]}, Closed]], 
                         Cell[CellGroupData[{Cell["Keywords", "KeywordsSection"], Cell["XXXX", "Keywords"]}, Closed]], 
                         Cell[CellGroupData[{Cell["Syntax Templates", "TemplatesSection"], Cell[BoxData[""], "Template", 
                              CellLabel -> "Additional Function Template"], 
                         Cell[BoxData[""], "Template", CellLabel -> "Arguments Pattern"], 
                         Cell[BoxData[""], "Template", CellLabel -> "Local Variables"], 
                         Cell[BoxData[""], "Template", CellLabel -> "Color Equal Signs"]}, Closed]], 
                         Cell[CellGroupData[{Cell["Details", "DetailsSection"], 
                         Cell["XXXX", "Details", CellLabel -> "Developers"], 
                         Cell["XXXX", "Details", CellLabel -> "Comments"]}, Closed]]}, content4];
                         
       content6 = content5 /. Cell[TextData[{x_String /; StringMatchQ[x, "See also" ~~ ___], __}], "Notes"] -> Sequence[];
       
       content7 = content6 //. Cell[TextData[{pre___, Cell[BoxData[RowBox[{StyleBox[x_String, "TI"], StyleBox["TI"]}]], 
                                                           "InlineFormula"], post___}], st:("Notes"|"Usage"), ___] :> 
                               Cell[TextData[{pre, Cell[BoxData[StyleBox[x, "TI"]], "InlineFormula"], post}], st];
                               
       content8 = content7 //. Cell[TextData[{pre___, cb : Cell[BoxData[_], "InlineFormula"], 
                                              t_String /; Not@StringMatchQ[t, Whitespace ~~ __] && 
                                                                          Not@StringMatchQ[t, "." ~~ ___], post___}], 
                                    st:("Notes"|"Usage"), ___] :> 
                               Cell[TextData[{pre, cb, " " <> t, post}], st];
                                     
       content9 = content8 //. Cell[TextData[{pre___, s_String/; Not@StringMatchQ[s, __ ~~ Whitespace], 
                                               cb : Cell[BoxData[_], "InlineFormula"], post___}], 
				     st:("Notes"|"Usage"), ___] :> 
			       Cell[TextData[{pre, s <> " ", cb, post}], st];
			       
       nb = CreateWindow[StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "FunctionPageStyles.nb"],
                         WindowMargins -> {{0, Automatic}, {Automatic, 0}},
                         WindowSize -> {720, 860}]; 
       NotebookWrite[nb, content9];
       NotebookSave[nb, escape@file];
       NotebookClose[nb],
       $Failed
      ]
    ]
  ]

ExportApplicationRefGuideEntry[f_String, opts___?OptionQ]:=
    If[checkRef[opts],
        ExportApplicationRefGuideEntry[f<>".nb", f, opts],
        $Failed
    ]

ExportApplicationRefGuideEntry[l_List, opts___?OptionQ]:=
    If[checkRef[opts],
        ExportApplicationRefGuideEntry[#,opts]&/@l
        ,
        $Failed
    ]


ExportApplicationRefGuideEntryNotebooks::atnm = "Exporting entry for ``."
ExportApplicationRefGuideEntryNotebooks::appnotspec = "$ApplicationName and $LinkBase must first be defined as strings and be free of `."


ExportApplicationRefGuideEntryNotebooks[dir_String:"", funcs_List:{}, opts___?OptionQ]:=
 If[Not@StringQ[DocumentationTools`$ApplicationName] || StringMatchQ[DocumentationTools`$ApplicationName, "" | " " ..] || Not@StringFreeQ[DocumentationTools`$ApplicationName, "`"] || Not@StringQ[DocumentationTools`$LinkBase] || 
    StringMatchQ[DocumentationTools`$LinkBase, "" | " " ..] || Not@StringFreeQ[DocumentationTools`$LinkBase, "`"],
    MessageToConsole[ExportApplicationRefGuideEntryNotebooks::appnotspec],
    If[checkRef[opts],
        (
           (* Message[ ExportApplicationRefGuideEntryNotebooks::atnm, #]; *)
            ExportApplicationRefGuideEntry[ ToFileName[{dir}, #<>".nb"], #, opts]
        ) &
            /@
        If[funcs=!={}, funcs, $FunctionNames]; If[FileType[$TempRefGuide] === File, DeleteFile[$TempRefGuide];
                                                                                    imported[$TempRefGuide] = False]
        ,
        $Failed
    ]
   ]
   
InlineFormulaRegularize[ nbstruc_ ] :=
ReplaceAll[
   nbstruc //. $InlineFormulaRules,
   $GridFixRules
]


$GridFixRules = 
{
   leavealone:Cell[ _, "Input" | "Output", ___] :> leavealone,
   GridBox[gridContents_, gopts___] :> 
      GridBox[
         Replace[
            gridContents,
         {
            StyleBox[ cont_, sopts___ ] :>
               StyleBox[ Replace[ cont, $GridFixElementRules], sopts],
            other_ :>
               Replace[ other, $GridFixElementRules]
         },
            {2}
         ],
         gopts
      ]
}

$GridFixElementRules = 
{
   Cell[ TextData[{Cell[ BoxData[box_], "InlineFormula"]}], tcsopts___] :>
      box,
   Cell[
      TextData[ tdlist:{Cell[_BoxData, "InlineFormula"], ___}], 
      ts_String:"TableText",
      tcopts___?OptionQ
   ] :>
      RowBox[
         Replace[ StripSpaceAfter[ tdlist],
         {
            Cell[BoxData@box_, "InlineFormula"] :> box, 
            s_String :> Cell[s, ts, tcopts]
         },
            {1}
         ]
      ],
   Cell[ TextData[ td_] | td_String, tcopts___?OptionQ] :> 
      Cell[ TextData[ StripSpaceAfter[ td] ], "TableText", tcopts]
}

$expressionRepresentationElement = 
   StyleBox[_, "TI" | "MR"] |
(* "Inline math" that probably is Mathematica expr. representation: *)
   Cell[ BoxData[
      FormBox[ $ArgLabelPattern | $CurlyBracketPattern, TraditionalForm]
   ], "InlineMath"] |
   ButtonBox[__, BaseStyle -> "RefGuideLink"] |
   " " |
   "\[Ellipsis]"

NonconvertibleButtonQ[ expr_] :=
Not[ MatchQ[ expr, ButtonBox[__, BaseStyle -> "RefGuideLink"] ] ]

$InlineFormulaRules =
{
(* Input and Output cells should be passed over. *)
   leavealone:Cell[ _, "Input" | "Output", ___] :> leavealone,
(* FunctionTemplate textdata cell *)
   Cell[
      TextData[{
         inl:$expressionRepresentationElement..}], 
      tmplStyle:("FunctionTemplate" | "NoPrintFunctionTemplate")
   ] :>
      MakeInlineMExpression[{inl}, tmplStyle],
(* Textdata that is all one expression-style sequence *)
   Cell[
      TextData[
         tdlist:
         Except[ {" ", ___} | {___, " "},
            {$expressionRepresentationElement..}
         ]
      ],
      tsopts___
   ] :>
      Cell[ TextData[{MakeInlineMExpression[ tdlist]}], tsopts],
(* Textdata ending with an expression-style sequence *)
   Cell[
      TextData[{
         ss:
            (
               " " |
               Except[ $expressionRepresentationElement,
                  _String | _Cell | _ButtonBox | _StyleBox
               ]
            )..., 
         notblank: Except[" ", $expressionRepresentationElement],
         inl: $expressionRepresentationElement..
      }
      ], 
      tsopts___
   ] :>
      Cell[ TextData[{ss, MakeInlineMExpression[{notblank, inl}]}], tsopts],
(* Textdata with expression-style sequence followed by more elements *)
   Cell[
      TextData[{
         ss:
            (
               " " |
               Except[ $expressionRepresentationElement,
                  _String | _Cell | _ButtonBox | _StyleBox
               ]
            )..., 
         inl: $expressionRepresentationElement..
            /;
         Not[ MatchQ[{inl},
            {" ", ___}
               |
            {___, " "}
               |
            {Cell[_BoxData, "InlineFormula", ___]}
               |
            {Cell[_BoxData, "InlineFormula", ___], " ", Cell[_BoxData, "InlineFormula", ___]}
         ] ],
         sp:" "...,
         ss2: Except[ $expressionRepresentationElement,
                  _String | _Cell | _ButtonBox | _StyleBox
               ], 
         mor___
      }],
      tsopts___
   ] :>
      Cell[TextData[Flatten @ {ss, MakeInlineMExpression[{inl}], sp, ss2, mor}], tsopts],
(* InlineMath cell not containing an argument label form *)
   inmath:Cell[ BoxData[ FormBox[ Except[ $ArgLabelPattern], TraditionalForm] ], "InlineMath", ___] :>
      ReplaceAll[ inmath, StyleBox[ s_String, "TI"] :> s]
}

$ArgLabelPattern = StyleBox[ _String, "TI"] | SubscriptBox[ StyleBox[ _String, "TI"], _]

$CurlyBracketPattern = "{" | "}"

$FactorPattern = $ArgLabelPattern |
   _RowBox |
   (
   s_String /;
      StringLength[s] >= 1 &&
      Apply[ And,
         (LetterQ[#] || DigitQ[#] || # === "$" &) /@
         Characters[ s]
      ]
   )

MakeInlineMExpression[ elems_List, sty_String:"InlineFormula"] :=(
(*Print["IN:",elems];Print["OUT:",#];#)&@*)
ReplaceAll[
   DeleteCases[
      ReplaceRepeated[
         Replace[
            TextDataToParsedBox[
               elems /.
                  {
                     StyleBox[thing_, "MR"] :> StripSpaceAfter[thing], 
                     Cell[ BoxData[
                        FormBox[
                           argy:(StyleBox[_String, "TI"] | _SubscriptBox),
                           TraditionalForm
                        ]
                     ], "InlineMath"]
                        :>
                           Replace[ argy,
                              SubscriptBox[ b_, d_String?DigitQ] :>
                                 SubscriptBox[ b, StyleBox[ d, "TR"] ]
                           ],
                     Cell[ BoxData[ box_], "InlineFormula" | "InlineMath"] :> box,
                     "\[Ellipsis]" -> StyleBox["\[Ellipsis]", "TR"]
                  }
            ],
         {
            RowBox[{a1:$ArgLabelPattern, " ", a2:$ArgLabelPattern}] :>
               {Cell[ BoxData[ a1], sty], " ", Cell[ BoxData[ a2], sty]},
            b_ :>
               Cell[ BoxData[ b], sty]
         }],
      {
         RowBox[{a___, a1:$FactorPattern, " ", a2:$FactorPattern, b___}] :>
            RowBox[{a, a1, `preserveSpace, a2, b}]
      }],
      " ",
      {2, -1}
   ],
   `preserveSpace -> " "
])

StripSpaceAfter[s_String] := StringReplace[s,RegularExpression["\\s*$"]->""]

StripSpaceAfter[{t___, " "}] := {t}

StripSpaceAfter[{t___, s_String}] := {t, StripSpaceAfter[ s]}

StripSpaceAfter[other_] := other


`StylizedElement /:
MakeBoxes[ `StylizedElement[ bx_], StandardForm|TraditionalForm] := bx

Protect[
Evaluate[
      First[{
         Unprotect[ TagBox],
         TagBox /:
         MakeExpression[
            TagBox[ bx_, `StylizedElement],
            StandardForm | TraditionalForm
         ] :=
            HoldComplete[ `StylizedElement[ bx] ]
      }]
   ]
]

$SpecialOpToAscii = {
   "\[Rule]" -> "->",
   "\[RuleDelayed]" -> ":>",
   "\[GreaterEqual]" -> ">=",
   "\[LessEqual]" -> "<=",
   "\[Equal]" -> "==",
   RowBox[{a___, "\[LeftDoubleBracket]", b_, "\[RightDoubleBracket]", c___}] :>
      RowBox[{a, "[", RowBox[{"[", b, "]"}], "]", c}],
   "\[NotEqual]" -> "!=",
   SuperscriptBox[ b_, "\[Prime]", o___] :> RowBox[{b, "'"}],
Sequence[]
}

TextDataToParsedBox[ tdl_List ] := Module[
  {scratch = ScratchNotebook[]},
  Replace[
      Scan[ NotebookWrite[ scratch, #]&, tdl];
      SelectionMove[ scratch, All, CellContents];
      First[{
         NotebookRead[ scratch],
         NotebookDelete[ scratch]
      }]
    ,
{
   BoxData[ b_] :> b /. $SpecialOpToAscii
}]
]

(*
TextDataToParsedBox[ tdl_List ] :=
      MathLink`CallFrontEnd @ FrontEnd`ReparseBoxStructurePacket @ tpl,
*)

escape[s_String] := s;

(*********************************  End of application doc conversion functions  ***********************************)


End[]

EndPackage[]
