
(* :Title: WolframAlphaAPI.m *)

(* :Author:
  Greg Martel, gregm@wolfram.com
*)

(* :Mathematica Version: 8 *)



XMLTransform[{

(* Transform Notebook *)
{Notebook} :>  Block[{nbExpression,aLang,langExt,sectionheads, valignProp, fileName, getFiles},

	sectionheads=Cases[SelectSelf[], Cell[_, "Section", ___], Infinity];
	valignProp="-10%";
	aLang=GetParameter["Language"];
    langExt = Switch[tmjLang,
    	"ChineseSimplified","zh",
    	"Spanish","es",
    	"Japanese","ja",
    	_,"en"];  

     fileName = StringReplace[GetFileNameBase[], "."<>langExt -> ""]<>"_";

	 getFiles = Export[ToFileName[{"Files"},"AlphaAPISection.gif"], 
Import[ToFileName[{DocumentationBuild`Common`$DocumentationBuildDirectory, "Internal", "web", "html", "images", "images"}, "AlphaAPISection.gif"]]
];
    
FillInLayout[
    GetParameter["layoutfile"],
    "Text",

    "body"->
    ExportString[
       	 XMLElement["div", {"style"->"margin-left:100px; width:800px;"}, {Recurse[]}] , "XML",
          "AttributeQuoting"->"\"", "Entities"->{"\[LongDash]"->"&mdash;", (*"\n"->"<br/>",*) "\n"->" ", 
          (*"'" -> "'", "'" -> "'",*) "\"" -> "\"", "\"" -> "\"", "\[Apostrophe]" -> "'",
          "\[ClosedCurlyQuote]" -> "'", 
          "\[OpenCurlyDoubleQuote]" -> "\"", "\[CloseCurlyDoubleQuote]" -> "\"", 
          "\[Dash]" -> "--", "\[LongDash]"->"---"},
          "ElementFormatting"->Automatic(*None*)]
  ]
],


(* Abstract and o styles *)
{Cell, "Section"} :> XMLElement["div", {"class"->"Section"}, {Recurse[]}],
{Cell, "Subsection"} :> XMLElement["div", {"class"->"Subsection"}, {Recurse[]}],
{Cell, "Subsubsection"} :> XMLElement["div", {"class"->"Subsubsection"}, {Recurse[]}],
{Cell, "Subsubsubsection"} :> XMLElement["div", {"class"->"Subsubsubsection"}, {Recurse[]}],
{Cell, "Text"} :> XMLElement["p", {}, {Recurse[]}],

{Cell, "Abstract"} :> XMLElement["p", {}, {Recurse[],
	XML`RawXML["<!--more-->"](*, <!--more-->*)}],
(*
{Cell, "NextPage"} :> XML`RawXML["<!--nextpage-->"],
{CellGroupData, "Item"} :> XMLElement["ul", {}, {Recurse[]}],
{CellGroupData, "ItemNumbered"} :> XMLElement["ol", {"class"->"ItemNumbered"}, {Recurse[]}],
{Cell, "Item" | "ItemNumbered"} :> XMLElement["li", {}, {Recurse[]}],
{Cell, "Section"} :> XMLElement["h3", {}, {Recurse[]}],
{Cell, "Subsection"} :> XMLElement["h4", {}, {Recurse[]}],
{CellGroupData, "Reference"} :> XMLElement["table", {"class"->"ReferenceTable"}, {Recurse[]}],
{Cell, "Reference"} :> Module[{content,col1,col2, tag},
 content = SelectSelf[][[1,1]];
	col1 = Partition[content, 3][[1]];
	col2 = Drop[content, 3];
	tag = GetOption[CellTags];
	
XMLElement["tr", {}, {
	XMLElement["td", {"class"->"Reference"}, {
		XMLElement["a", {"name"->tag}, {
		Transmogrify[col1]
		}]
		}],
	XMLElement["td", {}, {Transmogrify[col2]}]
}]
],
*)

{Cell, "SectionAboutAuthor"} :> XMLElement["h3", {"class"->"SectionAboutAuthor"}, {Recurse[]}],
{Cell, "TextAboutAuthor"} :> XMLElement["p", {"class"->"TextAboutAuthor"}, {Recurse[]}],
{Cell, "Example"} :> XMLElement["p", {"class"->"Example"}, {Recurse[]}],
{Cell, "FigureCaption"} :> XMLElement["p", {"class"->"FigureCaption"}, {Recurse[]}],

       
{CounterBox} :> Module[{counterStyle},
counterStyle=SelectSelf[][[1]];
IncrementCounter[counterStyle]
],



{Cell, "Program" | "Code"} :>
WithParameters[{"newline2br" -> True},

If[  htmlBoxesQ[SelectLiteral[SelectSelf[]]],
XMLElement["div", {"class" -> (GetStyle[]/.None->"FIXME"), "name" -> (GetStyle[]/.None->"FIXME")}, {
	XMLElement["pre", {}, Flatten@{
  If[HasOption[CellTags],
  Flatten[ {
    Map[
    (XMLElement["a", {"name" -> #}, {}])&, Flatten[{GetOption[CellTags]}] ],
    Recurse[]  }],
  {Recurse[]  }  ]    }]} ],

DIV[{"class" -> GetStyle[]}, {
  (
    XMLElement["img", { 
      "class" -> "FlushInput", "src" -> ("URL" /. #), 
      "width" -> ("Width" /. #), "height" -> ("Height" /. #),  
      "alt" -> " "  }, {}]&[
      BoxToImage[ToFileName[{"Files", GetFileNameBase[]},
    "Box_" <> IncrementCounter["Inline"] <> ".gif"],
    Inline -> False, CropImage -> False]
    ]
  )}]
]
],


{Cell, "ImageGraphics"} :> Module[{inc, eqnum, filepath, filedir, displayImageName, image, url, tag},
	eqnum=GetOption[CellTags];
	inc=IncrementCounter["DisplayFormulaNumbered"];
	filedir=GetParameter["ImageFileDirectory"];
	filepath=GetParameter["ImageFilePath"];
	displayImageName = FileNameJoin[{filedir, fileName<>"DisplayFormulaNumbered_"<> inc <> ".gif"}];
	image = BoxToImage[StringReplace[displayImageName, ".gif"->".gif"],
            Inline -> True, MaxImageSize->580, CropImage -> False];
    url = If[filepath==="",
    	FileNameJoin[{filedir, fileName<>"DisplayFormulaNumbered_"<> inc <> ".gif"}],
    	FileNameJoin[{filepath, filedir, fileName<>"DisplayFormulaNumbered_"<> inc <> ".gif"}]
		];
	tag = GetOption[CellTags];
		
	XMLElement["table", {"class"->"DisplayFormulaNumbered"}, {
		XMLElement["tr", {}, {
			XMLElement["td", {}, {
				XMLElement["img", {
            "src" -> url, "width" -> ("Width" /. #), 
            "height" -> ("Height" /. #), "alt" -> ""
          }, {}]&[image]
				}],
			XMLElement["td", {"class"->"DisplayFormulaNumberedLabel"}, 
				{XMLElement["a", {"name"->tag}, {
						"("<>StringReplace[eqnum, {"numeq"->"",
				"eq:"->"", "Eq"->""}]<>")"
				}]
				}
				]
		}]
	}]
],


{CellGroupData, "Input"} :> Recurse[],


{Cell, "Math"|"MCode"} :> Module[{inc, filepath, filedir, displayImageName, image, url, height},
	inc = IncrementCounter["Math"];
	filedir = GetParameter["ImageFileDirectory"];
	filepath = GetParameter["ImageFilePath"];
	displayImageName = FileNameJoin[{filedir, fileName<>"Math_"<> inc <> ".gif"}];
	image = BoxToImage[StringReplace[displayImageName, ".gif"->".gif"],
            Inline -> True, CropImage -> True];
    url = If[filepath==="",
    	FileNameJoin[{filedir, fileName<>"Math_"<> inc <> ".gif"}],
    	FileNameJoin[{filepath, filedir, fileName<>"Math_"<> inc <> ".gif"}]
		];
	height = ("Height" /. #)&[image];
	height = fudgeValignProp[height];

	XMLElement["img", {
            "src" -> url, "width" -> ("Width" /. #), "style"->"vertical-align:middle",
            "height" -> ("Height" /. #), "alt" -> ""
          }, {}]&[image]
],


{Cell, "PlacedGraphics"} :> Module[{inc, filepath, filedir, displayImageName, image, url},
	inc = IncrementCounter["PlacedGraphics"];
	filedir = GetParameter["ImageFileDirectory"];
	filepath = GetParameter["ImageFilePath"];
	displayImageName = FileNameJoin[{filedir, fileName<>"PlacedGraphics_"<> inc <> ".gif"}];
	image = BoxToImage[StringReplace[displayImageName, ".gif"->".gif"],
            Inline -> False, MaxImageSize->580, CropImage -> False];
    url = If[filepath==="",
    	FileNameJoin[{filedir, fileName<>"PlacedGraphics_"<> inc <> ".gif"}],
    	FileNameJoin[{filepath, filedir, fileName<>"PlacedGraphics_"<> inc <> ".gif"}]
		];
	XMLElement["img", {
			"src" -> url, "width" -> ("Width" /. #), 
            "height" -> ("Height" /. #), "alt" -> ""
          }, {}]&[image]
],


{Cell, "2ColumnTableMod"} :> DIV[{"class"->"ColumnTableMod"}, {Recurse[]}],

{Cell, "InlineFormula"} :> 
Module[{inc, filepath, filedir, displayImageName, image, url},
	inc = IncrementCounter["InlineFormula"];
	filedir = GetParameter["ImageFileDirectory"];
	filepath = GetParameter["ImageFilePath"];
	displayImageName = FileNameJoin[{filedir, fileName<>"IF_"<> inc <> ".gif"}];
	image = BoxToImage[StringReplace[displayImageName, ".gif"->".gif"],
            Inline -> True, MaxImageSize->580, CropImage -> False];
    url = If[filepath==="",
    	FileNameJoin[{filedir, fileName<>"IF_"<> inc <> ".gif"}],
    	FileNameJoin[{filepath, filedir, fileName<>"IF_"<> inc <> ".gif"}]
		];		
		
(*XMLElement["span", {"class"->"IF"}, *)
XMLElement["tt", {},
  If[htmlBoxesQ[SelectLiteral[SelectSelf[]]],
    {DocumentationBuild`Utils`AddSpaces[ Recurse[] ]},
    { 
    	XMLElement["img", {
			"src" -> url, "width" -> ("Width" /. #), "style" -> "vertical-align:middle;",
            "height" -> ("Height" /. #), "alt" -> ""
          }, {}]&[image]
    }
  ]
]
], 


{Cell,None} :> Module[{
  tmp1=SelectChildren[],
  tmp2=Recurse[], 
  inc, filepath, filedir, displayImageName, image, url, height
},
	inc = IncrementCounter["Image"];
	filedir = GetParameter["ImageFileDirectory"];
	filepath = GetParameter["ImageFilePath"];
	displayImageName = FileNameJoin[{filedir, fileName<>"Image_"<> inc <> ".gif"}];
	image = BoxToImage[StringReplace[displayImageName, ".gif"->".gif"],
            Inline -> True, CropImage -> False];
    url = If[filepath==="",
    	FileNameJoin[{filedir, fileName<>"Image_"<> inc <> ".gif"}], 
    	FileNameJoin[{filepath, filedir, fileName<>"Image_"<> inc <> ".gif"}]
		];
	height = ("Height" /. #)&[image];
	height = fudgeValignProp[height];

  If[
    Head[tmp1[[1]]]===CellGroupData, 
    If[Cases[tmp1, __]==={CellGroupData[{}, Open]}, "", tmp2 ],
    If[tmp2===Null, "",
    XMLElement["span", {}, {  
	Which[htmlBoxesQ[SelectLiteral[SelectSelf[]]], tmp2, 
		Cases[tmp1, _CheckboxBox, Infinity]=!={}, tmp2,
		Cases[tmp1, _RadioButtonBox, Infinity]=!={}, tmp2,
		True,
			XMLElement["img", {
			"src" -> url, "width" -> ("Width" /. #), "style"->"vertical-align:middle",
            "height" -> ("Height" /. #), "alt" -> ""
          }, {}]&[image]
      ]
    }]
  ]
  ]
],  


{StyleBox, "ReferenceCounterBox"} :> Module[{sbContent,bBox,bdata},
sbContent = SelectSelf[];
bBox = sbContent[[1,1]];
bdata = Cases[sbContent,Rule[ButtonData, a_]:>a,Infinity];

XMLElement["a", {"href"->StringJoin["#", bdata]}, {Transmogrify[bBox]}]
],





StyleBox :> Module[{sbstyle},
	
sbstyle = If[HasStyle[], GetStyle[], ""];

(* Make sure we don't return a list *)
If[Head[#] === List, Apply[Sequence, #], #]&@

    (* First do <div> processing if necessary... *)
    If[
      MatchQ[
        GetOption[GridElementStyleOptions],
        {___, ColumnAlignments->Left, ___}
      ]
      && (Head[SelectParent[2]] === GridBox),
      XMLElement["div", {"style" -> "text-align: left;"},Flatten[{#}]],
      #
    ]& [
      (* wrap stuff in style span if it's got a style *)
      If[HasStyle[],
      	Which[
      		sbstyle==="ExampleLabel",
      		XMLElement["strong", {}, {
      			XMLElement["strong", {}, Flatten[{#}]]
      		}], 
      		sbstyle==="Code",XMLElement["tt", {},Flatten[{#}]], 
      		sbstyle==="SB",XMLElement["strong", {},Flatten[{#}]], 
      		sbstyle==="AboutAuthorB",XMLElement["strong", {},Flatten[{#}]], 
      		sbstyle==="AboutAuthorI",XMLElement["em", {},Flatten[{#}]], 
       		True, XMLElement["span", {"class" -> GetStyle[]},Flatten[{#}]]
      	],
        #
      ]& [
        (* now process whatever options exist if we have to *)
        If[
          Length[Options[SelectLiteral[SelectSelf[]]]] > 0,
          Switch[
              GetOption[FontFamily], 
        "Courier" | "Courier New" | "Courier New (OEM)" | "WriCourier" | "courier",
              XMLElement["font", {"face" -> "monospace"},Flatten[{#}]]
              ,
      
        "Helvetica" | "L Futura Light" | "ExtraLight" | "Helv" | "C Futura Condensed" | "Arial" | "Lucida Grande" | "Chicago" | "Futura" | "Geneva" | "Monaco" | "MS Sans Serif" | "New York",
              XMLElement["font", {"face" -> "sans-serif"},Flatten[{#}]]
              ,
      
        "Times" | "Century" | "Osaka" | "Times New Roman" | "Palatino" | "Texte" | "Plain",
              XMLElement["font", {"face" -> "serif"},Flatten[{#}]]
              ,
              _,
              #
          ]& [
            If[
              GetOption[FontSlant]==="Italic", 
              XMLElement["em",{},Flatten[{#}]],
              #
            ]& [
              If[GetOption[FontWeight]==="Bold", 
                XMLElement["strong",{},Flatten[{#}]],
                #
              ]& [     
                If[
                  GetOption[FontVariations, "Underline"]===True,
                  XMLElement["u",{},Flatten[{#}]],
                  #
                ] & [ {Transmogrify[SelectChildren[]]} ]
              ]
            ]
          ]
          ,
          {Transmogrify[SelectChildren[]]}
        ] 
      ]
    ]
(*]*)
]


}, 

IncludeXMLTransforms -> {{"HTML","Components","Includes.m"}},
DefaultParameters -> { "newline2br" -> False, "newline2div" -> False}

]
