(* :Title: Tutorials.m *)

(* :Author:
	Andrew Hunt, andy@wolfram.com
	Greg Martel, gregm@wolfram.com
*)

(* :Mathematica Version: 5 *)
(* :Package Version: $Revision: 1.12 $ $Date: 2016/05/31 19:35:59 $ *)                  
(* :Copyright: (c) 2005, Wolfram Research, Inc. All rights reserved. *)
(* :Summary: Add-ons specific rules and general transform for Mathematica Documentation *)


XMLTransform[{
(* Remove in-product decorations *)
{Cell, "AnchorBar"} :> Unevaluated[Sequence[]],

{Cell, "UpgradeSummary"} :>
		XMLElement["p",{"class" -> "UpgradeSummary"}, { 
		Recurse[]
		 }],

{Cell, "UpgradePackageListing"} :>
		XMLElement["p", {"class" -> "UpgradePackageListing"}, { 
		Recurse[]
		 }],
		 
{Cell, "UpgradeMessage"} :>
		XMLElement["span", {"class" -> "UpgradeMessage"}, { 
		Recurse[]
		 }],

{CellGroupData, "MathCaption"} :> 
	XMLElement["table", {"class" -> "MCapTab"}, {
		XMLElement["tr", {}, {
			XMLElement["td", {}, {Recurse[]}   ]
		 }]    
	}],  

{Cell, "DataSourceTitle"} :>
		XMLElement["h1", {"class" -> "DataSourceTitle"}, { 
		Recurse[]
		 }],
		 
{Cell, "DataSourceSummary"} :>
		XMLElement["p", {"class" -> "DataSourceSummary"}, { 
		Recurse[]
		 }],
		 
{Cell, "DataSourceSection"} :>
		XMLElement["p", {"class" -> "DataSourceSection"}, { 
		Recurse[]
		 }],

{Cell, "DataSourceContact"} :>
		XMLElement["p", {"class" -> "DataSourceContact"}, { 
		Recurse[]
		 }],


{Cell, "DataSourceText"} :>
		XMLElement["p", {"class" -> "DataSourceText"}, { 
		Recurse[]
		 }],

{Cell, "Title"} :> (ResetCounters["ItemizedText"]; ResetCounters["ItemNumbered"];  H1[{"class" -> "Title"}, {Recurse[]}]),
{Cell, "UpgradeObjectName"} :> XMLElement["h1", {"class" -> "UpgradeObjectName"}, {Recurse[]}],
{Cell, "Section"} :> (ResetCounters["ItemizedText"];  ResetCounters["ItemNumbered"]; H2[{"class" -> "Section"}, {Recurse[]}]),
{Cell, "Subsection"} :> (ResetCounters["ItemizedText"]; ResetCounters["ItemNumbered"]; H3[{"class" -> "Subsection"}, {Recurse[]}]),
{Cell, "UpgradeDetailLabel"} :> H3[{"class" -> "UpgradeDetailLabel"}, {Recurse[]}],
{Cell, "Subsubsection"} :> (ResetCounters["ItemizedText"]; ResetCounters["ItemNumbered"]; H4[{"class" -> "Subsubsection"}, {Recurse[]}]),
{Cell, "Subsubsubsection"} :> (ResetCounters["ItemizedText"]; ResetCounters["ItemNumbered"]; XMLElement["H5", {"class" -> "Subsubsubsection"}, {Recurse[]}]),

{Cell, "Text"} :> WithParameters[{"newline2br" -> True},
	If[MatchQ[SelectParent[], Cell[BoxData[PopupMenuBox[a__]], b___]], 
		Span[{"class" -> "Text"}, {Recurse[]}], 
	P[{"class" -> "Text"}, {Recurse[]}]
	] 
],


{Cell,  "2ColumnTable" | "3ColumnTable"} :>
 				WithParameters[{"tableStyle" -> GetStyle[]},
					(
XMLElement["div", {"class" -> "FTab", "id"-> GetStyle[]}, {
	If[HasOption[CellTags], 
		Map[XMLElement["a", {"name" -> #}, {}] &, 
		StringReplace[Flatten[{GetOption[CellTags]}], ":" -> "_"]     ]],
	Recurse[]	}] 
)  ], 



{Cell, "Picture" | "Table"} :>
Module[{iCounter},
iCounter = IncrementCounter["Image"];

P[{"class" -> "Picture"}, {
  transmogrifyImage[ToFileName[{"Files", GetFileNameBase[]},
   iCounter <> ".gif"], {"alt" -> iCounter <> ".gif", "title" -> iCounter <> ".gif"}, 
    Inline -> True, CropImage -> False]
}]
],

{Cell, "ExampleDelimiter"} :> 
DIV[{"class" -> "ExLine"}, {XML`RawXML["<!-- -->"]}],

{Cell, "Subsection" | "SubsectionIcon" | "SubsectionFirst" | "Command" | 
"ContentsTitle" | "InspectorLevel1"} :>
		H2[{"id" -> (GetStyle[]/.None->"FIXME")}, {Recurse[]}],


{Cell, "FlushInput"} :>
	WithParameters[{"newline2br" -> True},
		P[{"class" -> "StandardForm", "id" -> GetStyle[]}, {
			XMLElement["b", {}, {Recurse[]}]  }
			] ], 


{Cell, "ItemizedText"} :> P[{"class" -> (GetStyle[]/.None->"FIXME")}, 
Sequence@{XMLElement["span", {}, {IncrementCounter["ItemizedText"] <> ". ", XML`RawXML["&nbsp;"]}],
Recurse[]
} ],

{Cell, "ItemNumbered"} :> P[{"class" -> (GetStyle[]/.None->"FIXME")}, 
Sequence@{XMLElement["span", {}, {IncrementCounter["ItemNumbered"] <> ". ", XML`RawXML["&nbsp;"]}],
Recurse[]
} ],

{Cell, "Notes"} :> XMLElement["ul", {"class"->"Notes"}, {Li[Flatten[
	{If[HasOption[Background], 
          If[MatchQ[ GetOption[Background], _Dynamic], {"class" -> "modified-text"}, {}], {}]}
          ], {Recurse[]}]}],

{Cell, "ItemizedTextParagraph"} :> P[{"class" -> (GetStyle[]/.None->"FIXME")}, {Recurse[]} ], 

{Cell, "ItemParagraph"} :> P[{"class" -> (GetStyle[]/.None->"FIXME")}, {Recurse[]} ], 
(* {CellGroupData, "TOCSection" | "TOCSubsection"} :> Recurse[], 


{Cell,  "TOCSection" | "TOCSubsection" | "TOCSubsubsection"} :> 
	Ol[{"id"->GetStyle[]}, {Li[{"id"->GetStyle[]}, {Recurse[]}]
	}], *)



(***** Cell Definitions *****)

{CellGroupData, "RelatedTutorialsSection" } :> XMLElement["div", {"class"->"expandWrap", "id"->"RelatedTutorials"},
	{XMLElement["div", {"class"->"expandOuter"},{
		XMLElement["h2", {"class"->"expandInner"}, {
			XMLElement["a", {"class"->"expand hide", "title"->Localized["show", GetParameter["language"]], "href"->"#"},{Localized["RelatedTutorialsSectionText", GetParameter["language"]]}], 
			XMLElement["a", {"class"->"collapse", "title"->Localized["hide", GetParameter["language"]], "href"->"#"},{Localized["RelatedTutorialsSectionText", GetParameter["language"]]}]}], 
			XMLElement["div",{"class"->"expanded"},{XMLElement["ul",{"class"->"functionList"},{Recurse[]}]}]}]}],

{Cell, "RelatedTutorialsSection" } :> Unevaluated[Sequence[]],

{CellGroupData, "TutorialMoreAboutSection" } :> XMLElement["div", {"class"->"expandWrap", "id"->"RelatedGuides"},
	{XMLElement["div", {"class"->"expandOuter"},{
		XMLElement["h2", {"class"->"expandInner"}, {
			XMLElement["a", {"class"->"expand hide", "title"->Localized["show", GetParameter["language"]], "href"->"#"},{Localized["MoreAboutSectionText", GetParameter["language"]]}], 
			XMLElement["a", {"class"->"collapse", "title"->Localized["hide", GetParameter["language"]], "href"->"#"},{Localized["MoreAboutSectionText", GetParameter["language"]]}]}], 
			XMLElement["div",{"class"->"expanded"},{XMLElement["ul",{"class"->"functionList"},{Recurse[]}]}]}]}],

{Cell, "TutorialMoreAboutSection" } :> Unevaluated[Sequence[]],

{CellGroupData, "TutorialRelatedLinksSection" } :> XMLElement["div", {"class"->"expandWrap", "id"->"RelatedLinks"},
	{XMLElement["div", {"class"->"expandOuter"},{
		XMLElement["h2", {"class"->"expandInner"}, {
			XMLElement["a", {"class"->"expand hide", "title"->Localized["show", GetParameter["language"]], "href"->"#"},{Localized["RelatedLinksSectionText", GetParameter["language"]]}], 
			XMLElement["a", {"class"->"collapse", "title"->Localized["hide", GetParameter["language"]], "href"->"#"},{Localized["RelatedLinksSectionText", GetParameter["language"]]}]}], 
			XMLElement["div",{"class"->"expanded"},{XMLElement["ul",{"class"->"functionList"},{Recurse[]}]}]}]}],

{Cell, "TutorialRelatedLinksSection" } :> Unevaluated[Sequence[]],

{CellGroupData, "TutorialsTutorialCollectionSection" } :> XMLElement["div", {"class"->"expandWrap", "id"->"TutorialCollection"},
	{XMLElement["div", {"class"->"expandOuter"},{
		XMLElement["h2", {"class"->"expandInner"}, {
			XMLElement["a", {"class"->"expand hide", "title"->Localized["show", GetParameter["language"]], "href"->"#"},{Localized["TutorialCollectionSectionText", GetParameter["language"]]}], 
			XMLElement["a", {"class"->"collapse", "title"->Localized["hide", GetParameter["language"]], "href"->"#"},{Localized["TutorialCollectionSectionText", GetParameter["language"]]}]}], 
			XMLElement["div",{"class"->"expanded"},{XMLElement["ul",{"class"->"functionList"},{Recurse[]}]}]}]}],

{Cell, "TutorialsTutorialCollectionSection" } :> Unevaluated[Sequence[]],

{CellGroupData, "TutorialCollectionSection" } :> XMLElement["div", {"class"->"expandWrap", "id"->"TutorialCollection"},
	{XMLElement["div", {"class"->"expandOuter"},{
		XMLElement["h2", {"class"->"expandInner"}, {
			XMLElement["a", {"class"->"expand hide", "title"->Localized["show", GetParameter["language"]], "href"->"#"},{Localized["TutorialCollectionSectionText", GetParameter["language"]]}], 
			XMLElement["a", {"class"->"collapse", "title"->Localized["hide", GetParameter["language"]], "href"->"#"},{Localized["TutorialCollectionSectionText", GetParameter["language"]]}]}], 
			XMLElement["div",{"class"->"expanded"},{XMLElement["ul",{"class"->"functionList"},{Recurse[]}]}]}]}],

{Cell, "TutorialCollectionSection" } :> Unevaluated[Sequence[]],

{Cell, "RelatedTutorials" | "TutorialRelatedLinks" | "TutorialMoreAbout" | "TutorialCollection"} :> Li[{Recurse[]}],

{Cell, "Graphics" | "ItemizedPicture" | "ItemPicture"} :> 
P[{"class"->GetStyle[]}, {
transmogrifyImage[ToFileName[{"Files", GetFileNameBase[]},
    IncrementCounter["TutorialGraphics"] <> "_tg.gif"],{"alt"->""},
    Inline -> True, CropImage -> False
]}],

{OutputFormData} :> Transmogrify[SelectChildren[][[2]]]

},

IncludeXMLTransforms -> {{"HTML","Components","Includes.m"}},

DefaultParameters -> {
	(*  "newline2br" -> False,  *)
	"newline2br" -> False,
	"newline2div" -> False,
	"styleUsageMessageBreak" -> "</div>\n<div class='UsageMessage'>",

	(* No Operation code *)
	"noop" -> {
		$CreateCompleteHTMLFile = False;
		$LanguageExtension = "en";


		(* routines for graphic popup *)
		largeImageQ[w___]:= False;
		largeImageQ[{w_, h_}, n_]:=
			If[(w > n) || (h > n), True, False];

		thumbnailImageSize[w_, h_, n_]:=
			Block[{mag},
				If[w > h,
					mag = N[n/w];
					{"width" -> ToString[Ceiling[mag*w]], "height" -> ToString[Ceiling[mag*h]]}
				,
					mag = N[n/h];
					{"width" -> ToString[Ceiling[mag*w]], "height" -> ToString[Ceiling[mag*h]]}
				]
			];

	}
},

CounterReassignments -> {{"Chapter", "Section"}, {"Section", "Subsection"}, {"Subsection", "Subsubsection"}, {"Subsection", "ItemizedText"}     }

]
