
(* :Title: SolutionsPages.m *)

(* :Author:
  Greg Martel, gregm@wolfram.com
*)

(* :Mathematica Version: 7 *)
(* :Package Version: $Revision: 1.46 $ $Date: 2014/06/17 19:32:11 $ *)                  
(* :Copyright: (c) 2009, Wolfram Research, Inc. All rights reserved. *)
(* :Summary: General transform for Mathematica Solution Pages *)


XMLTransform[{

(* Transform Notebook *)
{Notebook} :>  Block[{nbExpression,tmjLang,langExt,sectionheads, valignProp, fileName},

	sectionheads=Cases[SelectSelf[], Cell[_, "Section", ___], Infinity];
	valignProp="-10%";
	tmjLang=GetParameter["Language"];
    langExt = Switch[tmjLang,
    	"ChineseSimplified","zh",
    	"Spanish","es",
    	"Japanese","ja",
    	_,"en"];  
    	(*Which[
            m1 && m2, OrderedQ[{s1, s2}],
            m1, False,
            m2, True,
            True, OrderedQ[{s1, s2}] ]*)
     fileName = StringReplace[GetFileNameBase[], "."<>langExt -> ""]<>"_";

tmjindentFunction[{"", "table"}] := Automatic;
tmjindentFunction[{"", "a"}] := False;
tmjindentFunction[{"", "div"}] := Automatic;
tmjindentFunction[{"", "ul"}] := True;
tmjindentFunction[{"", "li"}] := Automatic;
tmjindentFunction[{"", "span"}] := False;
tmjindentFunction[{"", "p"}] := False;
tmjindentFunction[{"", "img"}] := False;

FillInLayout[
    GetParameter["layoutfile"],
    "Text",

    "body"->
    ExportString[
       	 XMLElement["div", {}, {Recurse[]}] , "XML",
          "AttributeQuoting"->"\"", "Entities"->{"\[LongDash]"->"&mdash;", "\n"->"<br/>", 
          (*"'" -> "'", "'" -> "'",*) "\"" -> "\"", "\"" -> "\"", "\[Apostrophe]" -> "'",
          "\[ClosedCurlyQuote]" -> "'", 
          "\[OpenCurlyDoubleQuote]" -> "\"", "\[CloseCurlyDoubleQuote]" -> "\"", 
          "\[Dash]" -> "--", "\[LongDash]"->"---"},
          "ElementFormatting"->tmjindentFunction(*None*)]
       (*ExportString[
       	 XMLElement["div", {}, {Recurse[]}] , "XML",
          "AttributeQuoting"->"\"", "Entities"->{"\[LongDash]"->"&mdash;", "\n"->"<br/>", "\[CloseCurlyQuote]" -> "'", 
          "\[OpenCurlyDoubleQuote]" -> "\"", "\[CloseCurlyDoubleQuote]" -> "\"", "\[Dash]" -> "--", "\[LongDash]"->"---"},
          "ElementFormatting"->Automatic(*None*)]*)
  ]
],


(* Abstract and o styles *)
{Cell, "Title" | "Author" | "OnlineHeader"} :> Unevaluated[Sequence[]],
{Cell, "Abstract"} :> XMLElement["p", {}, {Recurse[],
	XML`RawXML["<!--more-->"](*, <!--more-->*)}],
{Cell, "Text"} :> XMLElement["p", {}, {Recurse[]}],
{Cell, "NextPage"} :> XML`RawXML["<!--nextpage-->"],
{CellGroupData, "Item"} :> XMLElement["ul", {}, {Recurse[]}],
{CellGroupData, "ItemNumbered"} :> XMLElement["ol", {"class"->"ItemNumbered"}, {Recurse[]}],
{Cell, "Item" | "ItemNumbered"} :> XMLElement["li", {}, {Recurse[]}],
{Cell, "Section"} :> XMLElement["h3", {}, {Recurse[]}],
{Cell, "Subsection"} :> XMLElement["h4", {}, {Recurse[]}],
{Cell, "Subsubsection"} :> XMLElement["h5", {}, {Recurse[]}],
{Cell, "Subsubsubsection"} :> XMLElement["h6", {}, {Recurse[]}],
{CellGroupData, "Reference"} :> XMLElement["table", {"class"->"ReferenceTable"}, {Recurse[]}],
{Cell, "Reference"} :> Module[{content,col1,col2, tag},
 content = SelectSelf[][[1,1]];
	col1 = Partition[content, 3][[1]];
	col2 = Drop[content, 3];
	tag = GetOption[CellTags];
	
XMLElement["tr", {}, {
	XMLElement["td", {"class"->"Reference"}, {
		XMLElement["a", {"name"->tag}, {
		Transmogrify[col1]
		}]
		}],
	XMLElement["td", {}, {Transmogrify[col2]}]
}]
],


{Cell, "SectionAboutAuthor"} :> XMLElement["h3", {"class"->"SectionAboutAuthor"}, {Recurse[]}],
{Cell, "TextAboutAuthor"} :> XMLElement["p", {"class"->"TextAboutAuthor"}, {Recurse[]}],
{Cell, "Example"} :> XMLElement["p", {"class"->"Example"}, {Recurse[]}],
{Cell, "NumberedFigureCaption"} :> XMLElement["p", {"class"->"NumberedFigureCaption"}, {Recurse[]}],

       
{CounterBox} :> Module[{counterStyle},
counterStyle=SelectSelf[][[1]];
IncrementCounter[counterStyle]
],


{Cell, "DisplayFormulaNumbered"} :> Module[{inc, (*eqnum,*) filepath, filedir, displayImageName, image, url, tag, style},
	style=GetStyle[];
	(*eqnum=GetOption[CellTags];*)
	inc=IncrementCounter["DisplayFormulaNumbered"];
	filedir=GetParameter["ImageFileDirectory"];
	filepath=GetParameter["ImageFilePath"];
	displayImageName = FileNameJoin[{filedir, fileName <> style <> "_" <> inc <> ".gif"}];
	image = BoxToImage[StringReplace[displayImageName, ".gif"->".gif"],
            Inline -> True, MaxImageSize->580, CropImage -> False];
    url = If[filepath==="",
    	FileNameJoin[{filedir, fileName <> style <> "_" <> inc <> ".gif"}],
    	FileNameJoin[{filepath, filedir, fileName <> style <> "_" <> inc <> ".gif"}]
		];
	tag = If[GetOption[CellTags]===None,"Unspecified",ToString@GetOption[CellTags]];
		
	XMLElement["table", {"class"->"DisplayFormulaNumbered"}, {
		XMLElement["tr", {}, {
			XMLElement["td", {}, {
				XMLElement["img", {
            "src" -> url, "width" -> ("Width" /. #), 
            "height" -> ("Height" /. #), "alt" -> ""
          }, {}]&[image]
				}],
			XMLElement["td", {"class"->"DisplayFormulaNumberedLabel"}, 
				{XMLElement["a", {"name"->tag}, {
						"("<>inc(*StringReplace[eqnum, {"numeq"->"",
				"eq:"->"", "Eq:"->"", "Eq"->""}]*)<>")"
				}]
				}
				]
		}]
	}]
],


{CellGroupData, "Input"} :> Recurse[],


{Cell, "Input" | "Print" | "DisplayFormula" | "Message"} :> Module[{inc, filepath, filedir, displayImageName, 
	image, url,style},
	style=GetStyle[]<>"_";
	inc = IncrementCounter["Input"];
	filedir = GetParameter["ImageFileDirectory"];
	filepath = GetParameter["ImageFilePath"];
	displayImageName = FileNameJoin[{filedir, fileName<>style<>inc <> ".gif"}];
	image = BoxToImage[StringReplace[displayImageName, ".gif"->".gif"],
            Inline -> False, MaxImageSize->580, CropImage -> False];
    url = If[filepath==="",
    	FileNameJoin[{filedir, fileName<>style<> inc <> ".gif"}],
    	FileNameJoin[{filepath, filedir, fileName<>style<> inc <> ".gif"}]
		];
	XMLElement["p", {"class"->"input"}, {
	XMLElement["img", {
            "src" -> url, "width" -> ("Width" /. #), 
            "height" -> ("Height" /. #), "alt" -> ""
          }, {}]&[image]
}]
],


{Cell, "Output"} :> Module[{inc, filepath, filedir, displayImageName, image, url},
	inc = IncrementCounter["Output"];
	filedir = GetParameter["ImageFileDirectory"];
	filepath = GetParameter["ImageFilePath"];
	displayImageName = FileNameJoin[{filedir, fileName<>"Output_"<> inc <> ".gif"}];
	image = BoxToImage[StringReplace[displayImageName, ".gif"->".gif"],
            Inline -> False, MaxImageSize->580, CropImage -> False];
    url = If[filepath==="",
    	FileNameJoin[{filedir, fileName<>"Output_"<> inc <> ".gif"}],
    	FileNameJoin[{filepath, filedir, fileName<>"Output_"<> inc <> ".gif"}]
		];
	XMLElement["p", {"class"->"output"}, {
	XMLElement["img", {
            "src" -> url, "width" -> ("Width" /. #), 
            "height" -> ("Height" /. #), "alt" -> ""
          }, {}]&[image]
}]
],


{Cell, "Math"|"MCode"} :> Module[{inc, filepath, filedir, displayImageName, image, url, height},
	inc = IncrementCounter["Math"];
	filedir = GetParameter["ImageFileDirectory"];
	filepath = GetParameter["ImageFilePath"];
	displayImageName = FileNameJoin[{filedir, fileName<>"Math_"<> inc <> ".gif"}];
	image = BoxToImage[StringReplace[displayImageName, ".gif"->".gif"],
            Inline -> True, CropImage -> True];
    url = If[filepath==="",
    	FileNameJoin[{filedir, fileName<>"Math_"<> inc <> ".gif"}],
    	FileNameJoin[{filepath, filedir, fileName<>"Math_"<> inc <> ".gif"}]
		];
	height = ("Height" /. #)&[image];
	height = fudgeValignProp[height];

	XMLElement["img", {
            "src" -> url, "width" -> ("Width" /. #), "style"->"vertical-align:middle",
            "height" -> ("Height" /. #), "alt" -> ""
          }, {}]&[image]
],


{Cell, "PlacedGraphics"} :> Module[{inc, filepath, filedir, displayImageName, image, url},
	inc = IncrementCounter["PlacedGraphics"];
	filedir = GetParameter["ImageFileDirectory"];
	filepath = GetParameter["ImageFilePath"];
	displayImageName = FileNameJoin[{filedir, fileName<>"PlacedGraphics_"<> inc <> ".gif"}];
	image = BoxToImage[StringReplace[displayImageName, ".gif"->".gif"],
            Inline -> False, MaxImageSize->580, CropImage -> False];
    url = If[filepath==="",
    	FileNameJoin[{filedir, fileName<>"PlacedGraphics_"<> inc <> ".gif"}],
    	FileNameJoin[{filepath, filedir, fileName<>"PlacedGraphics_"<> inc <> ".gif"}]
		];
	XMLElement["img", {
			"src" -> url, "width" -> ("Width" /. #), 
            "height" -> ("Height" /. #), "alt" -> ""
          }, {}]&[image]
],


{Cell, "PlacedGraphics"} :> Module[{inc, filepath, filedir, displayImageName, image, url},
	inc = IncrementCounter["PlacedGraphics"];
	filedir = GetParameter["ImageFileDirectory"];
	filepath = GetParameter["ImageFilePath"];
	displayImageName = FileNameJoin[{filedir, fileName<>"PlacedGraphics_"<> inc <> ".gif"}];
	image = BoxToImage[StringReplace[displayImageName, ".gif"->".gif"],
            Inline -> False, MaxImageSize->580, CropImage -> False];
    url = If[filepath==="",
    	FileNameJoin[{filedir, fileName<>"PlacedGraphics_"<> inc <> ".gif"}],
    	FileNameJoin[{filepath, filedir, fileName<>"PlacedGraphics_"<> inc <> ".gif"}]
		];
	XMLElement["img", {
			"src" -> url, "width" -> ("Width" /. #), 
            "height" -> ("Height" /. #), "alt" -> ""
          }, {}]&[image]
],

(*{Cell, "ProgramMakeDisplayImage"} :> Module[{inc, filepath, filedir, displayImageName, image, url},
	inc = IncrementCounter["PlacedGraphics"];
	filedir = GetParameter["ImageFileDirectory"];
	filepath = GetParameter["ImageFilePath"];
	displayImageName = FileNameJoin[{filedir, fileName<>"PlacedGraphics_"<> inc <> ".gif"}];
	image = BoxToImage[StringReplace[displayImageName, ".gif"->".gif"],
            Inline -> False, MaxImageSize->580, CropImage -> False];
    url = If[filepath==="",
    	FileNameJoin[{filedir, fileName<>"PlacedGraphics_"<> inc <> ".gif"}],
    	FileNameJoin[{filepath, filedir, fileName<>"PlacedGraphics_"<> inc <> ".gif"}]
		];
	XMLElement["img", {
			"src" -> url, "width" -> ("Width" /. #), 
            "height" -> ("Height" /. #), "alt" -> ""
          }, {}]&[image]
],*)

(*{Cell, "Program", "MakeDisplayImage"} :> Module[{inc, filepath, filedir, displayImageName, image, url},
	inc = IncrementCounter["PlacedGraphics"];  
	filedir = GetParameter["ImageFileDirectory"];
	filepath = GetParameter["ImageFilePath"];
	displayImageName = FileNameJoin[{filedir, fileName<>"PlacedGraphics_"<> inc <> ".gif"}];
	image = BoxToImage[StringReplace[displayImageName, ".gif"->".gif"],
            Inline -> False, MaxImageSize->580, CropImage -> False];
    url = If[filepath==="",
    	FileNameJoin[{filedir, fileName<>"PlacedGraphics_"<> inc <> ".gif"}],
    	FileNameJoin[{filepath, filedir, fileName<>"PlacedGraphics_"<> inc <> ".gif"}]
		];
	XMLElement["img", {
			"src" -> url, "width" -> ("Width" /. #), 
            "height" -> ("Height" /. #), "alt" -> ""
          }, {}]&[image]
],*)

GetParameter["ExtraRules"] :> Module[{inc, filepath, filedir, displayImageName, image, url},
	inc = IncrementCounter["PlacedGraphics"];  
	filedir = GetParameter["ImageFileDirectory"];
	filepath = GetParameter["ImageFilePath"];
	displayImageName = FileNameJoin[{filedir, fileName<>"PlacedGraphics_"<> inc <> ".gif"}];
	image = BoxToImage[StringReplace[displayImageName, ".gif"->".gif"],
            Inline -> False, MaxImageSize->580, CropImage -> False];
    url = If[filepath==="",
    	FileNameJoin[{filedir, fileName<>"PlacedGraphics_"<> inc <> ".gif"}],
    	FileNameJoin[{filepath, filedir, fileName<>"PlacedGraphics_"<> inc <> ".gif"}]
		];
	XMLElement["img", {
			"src" -> url, "width" -> ("Width" /. #), 
            "height" -> ("Height" /. #), "alt" -> ""
          }, {}]&[image]
],

{Cell, "InlineFormula"} :> 
Module[{inc, filepath, filedir, displayImageName, image, url},
	inc = IncrementCounter["InlineFormula"];
	filedir = GetParameter["ImageFileDirectory"];
	filepath = GetParameter["ImageFilePath"];
	displayImageName = FileNameJoin[{filedir, fileName<>"IF_"<> inc <> ".gif"}];
	image = BoxToImage[StringReplace[displayImageName, ".gif"->".gif"],
            Inline -> True, MaxImageSize->580, CropImage -> False];
    url = If[filepath==="",
    	FileNameJoin[{filedir, fileName<>"IF_"<> inc <> ".gif"}],
    	FileNameJoin[{filepath, filedir, fileName<>"IF_"<> inc <> ".gif"}]
		];		
		
(*XMLElement["span", {"class"->"IF"}, *)
XMLElement["tt", {},
  If[htmlBoxesQ[SelectLiteral[SelectSelf[]]],
    {DocumentationBuild`Utils`AddSpaces[ Recurse[] ]},
    { 
    	XMLElement["img", {
			"src" -> url, "width" -> ("Width" /. #), "style" -> "vertical-align:middle;",
            "height" -> ("Height" /. #), "alt" -> ""
          }, {}]&[image]
    }
  ]
]
], 


{Cell,None} :> Module[{
  tmp1=SelectChildren[],
  tmp2=Recurse[], 
  inc, filepath, filedir, displayImageName, image, url, height
},
	inc = IncrementCounter["Image"];
	filedir = GetParameter["ImageFileDirectory"];
	filepath = GetParameter["ImageFilePath"];
	displayImageName = FileNameJoin[{filedir, fileName<>"Image_"<> inc <> ".gif"}];
	image = BoxToImage[StringReplace[displayImageName, ".gif"->".gif"],
            Inline -> True, CropImage -> False];
    url = If[filepath==="",
    	FileNameJoin[{filedir, fileName<>"Image_"<> inc <> ".gif"}], 
    	FileNameJoin[{filepath, filedir, fileName<>"Image_"<> inc <> ".gif"}]
		];
	height = ("Height" /. #)&[image];
	height = fudgeValignProp[height];

  If[
    Head[tmp1[[1]]]===CellGroupData, 
    If[Cases[tmp1, __]==={CellGroupData[{}, Open]}, "", tmp2 ],
    If[tmp2===Null, "",
    XMLElement["span", {}, {  
	Which[htmlBoxesQ[SelectLiteral[SelectSelf[]]], tmp2, 
		Cases[tmp1, _CheckboxBox, Infinity]=!={}, tmp2,
		Cases[tmp1, _RadioButtonBox, Infinity]=!={}, tmp2,
		True,
			XMLElement["img", {
			"src" -> url, "width" -> ("Width" /. #), "style"->"vertical-align:middle",
            "height" -> ("Height" /. #), "alt" -> ""
          }, {}]&[image]
      ]
    }]
  ]
  ]
],  


{StyleBox, "ReferenceCounterBox"} :> Module[{sbContent,bBox,bdata},
sbContent = SelectSelf[];
bBox = sbContent[[1,1]];
bdata = Cases[sbContent,Rule[ButtonData, a_]:>a,Infinity];

XMLElement["a", {"href"->StringJoin["#", bdata]}, {Transmogrify[bBox]}]
],



{StyleBox, "DisplayFormulaNumbered"} :> Module[{sbContent,bBox,bdata},
sbContent = SelectSelf[];
bBox = sbContent[[1,1]];
bdata = Cases[sbContent,Rule[ButtonData, a_]:>a,Infinity];

XMLElement["a", {"href"->StringJoin["#", bdata[[1]]]}, {Transmogrify[bBox]}]
],

(*StyleBox[ButtonBox[1,ButtonData->eq:1],DisplayFormulaNumbered,NodeID->270]*)
(*Cell[a__, "Reference", b___,CellTags->"Wolfram2003",c___]*)


{FormBox} :> Module[{boxChildren,altTag,
	inc, filepath, filedir, displayImageName, image, url, height
	},
boxChildren=SelectChildren[];
altTag = DocumentationBuild`Utils`CellToString@SelectSelf[];
inc = IncrementCounter["Image"];
filedir = GetParameter["ImageFileDirectory"];
filepath = GetParameter["ImageFilePath"];
displayImageName = FileNameJoin[{filedir, fileName<>"Image_"<> inc <> ".gif"}];
image = BoxToImage[StringReplace[displayImageName, ".gif"->".gif"],  "TransparentColor" -> White,
            Inline -> If[GetStyle[]===TraditionalForm, True, False] MaxImageSize->580, CropImage -> False];
url = If[filepath==="",
    	FileNameJoin[{filedir, fileName<>"Image_"<> inc <> ".gif"}],
    	FileNameJoin[{filepath, filedir, fileName<>"Image_"<> inc <> ".gif"}]
		];
height = ("Height" /. #)&[image];
height = fudgeValignProp[height];

If[MatchQ[boxChildren, {"Mathematica"}],Transmogrify[StyleBox["Mathematica", FontSlant->"Italic"]],
If[MatchQ[boxChildren, {StyleBox[_, "KeyEvent", ___]}], Transmogrify[boxChildren],
	
	XMLElement["img", {"style"->"vertical-align:middle", "title"->altTag, 
			"src" -> url, "width" -> ("Width" /. #), 
            "height" -> ("Height" /. #), "alt"->altTag
          }, {}]&[image]
]
]
],


StyleBox :> Module[{sbstyle},
	
sbstyle = If[HasStyle[], GetStyle[], ""];

(* Make sure we don't return a list *)
If[Head[#] === List, Apply[Sequence, #], #]&@

    (* First do <div> processing if necessary... *)
    If[
      MatchQ[
        GetOption[GridElementStyleOptions],
        {___, ColumnAlignments->Left, ___}
      ]
      && (Head[SelectParent[2]] === GridBox),
      XMLElement["div", {"style" -> "text-align: left;"},Flatten[{#}]],
      #
    ]& [
      (* wrap stuff in style span if it's got a style *)
      If[HasStyle[],
      	Which[
      		sbstyle==="ExampleLabel",
      		XMLElement["strong", {}, {
      			XMLElement["strong", {}, Flatten[{#}]]
      		}], 
      		sbstyle==="Code",XMLElement["tt", {},Flatten[{#}]], 
      		sbstyle==="SB",XMLElement["strong", {},Flatten[{#}]], 
      		sbstyle==="AboutAuthorB",XMLElement["strong", {},Flatten[{#}]], 
      		sbstyle==="AboutAuthorI",XMLElement["em", {},Flatten[{#}]], 
       		True, XMLElement["span", {"class" -> GetStyle[]},Flatten[{#}]]
      	],
        #
      ]& [
        (* now process whatever options exist if we have to *)
        If[
          Length[Options[SelectLiteral[SelectSelf[]]]] > 0,
          Switch[
              GetOption[FontFamily], 
        "Courier" | "Courier New" | "Courier New (OEM)" | "WriCourier" | "courier",
              XMLElement["font", {"face" -> "monospace"},Flatten[{#}]]
              ,
      
        "Helvetica" | "L Futura Light" | "ExtraLight" | "Helv" | "C Futura Condensed" | "Arial" | "Lucida Grande" | "Chicago" | "Futura" | "Geneva" | "Monaco" | "MS Sans Serif" | "New York",
              XMLElement["font", {"face" -> "sans-serif"},Flatten[{#}]]
              ,
      
        "Times" | "Century" | "Osaka" | "Times New Roman" | "Palatino" | "Texte" | "Plain",
              XMLElement["font", {"face" -> "serif"},Flatten[{#}]]
              ,
              _,
              #
          ]& [
            If[
              GetOption[FontSlant]==="Italic", 
              XMLElement["em",{},Flatten[{#}]],
              #
            ]& [
              If[GetOption[FontWeight]==="Bold", 
                XMLElement["strong",{},Flatten[{#}]],
                #
              ]& [     
                If[
                  GetOption[FontVariations, "Underline"]===True,
                  XMLElement["u",{},Flatten[{#}]],
                  #
                ] & [ {Transmogrify[SelectChildren[]]} ]
              ]
            ]
          ]
          ,
          {Transmogrify[SelectChildren[]]}
        ] 
      ]
    ]
(*]*)
]


}, 

IncludeXMLTransforms -> {{"HTML","Components","Includes.m"}},
DefaultParameters -> { "newline2br" -> False, "newline2div" -> False}

]
