(* :Title: Guides.m *)

(* :Author:
	Andrew Hunt, andy@wolfram.com
	Greg Martel, gregm@wolfram.com
*)

(* :Mathematica Version: 6.0 *)

(* :Package Version: $Revision: 1.8.2.1 $ $Date: 2016/08/16 20:57:17 $ *)
                  
(* :Copyright: (c) 2005, Wolfram Research, Inc. All rights reserved. *)

(* :Summary: XMLTransform for Documentation Guide pages *)

(* :ToDo: 

*)


XMLTransform[{


(***** Match Notebook expression *****)


(***** Cell Definitions *****)
{Cell, "AnchorBar" | "History"} :> Unevaluated[Sequence[]],

{Cell, "RootSearch" | "RootTitle" | "RootFooterSep"} :> Unevaluated[Sequence[]],

{Cell, "RootFooterRedLink"} :> 
XMLElement["span",{},{Recurse[]}],

{Cell, "RootHeader"} :> Unevaluated[Sequence[]],

{Cell, "RootFooter"} :> Module[{allLinks,shadowbar,language},
	language=GetParameter["language"];
	allLinks=Cases[SelectSelf[], Cell[_, "RootFooterRedLink", ___], Infinity];
	shadowbar=XMLElement["img", {"src"->"/mathematicaImages/shadowbottom.gif","class"->"RootShadowBar"}, {}];
	DIV[{}, {
	DIV[{"class"->"RootFooter"}, {
		(*shadowbar,*)
		DIV[{"class"->"RootFooterTable"}, {
			XMLElement["table",{"class"->"RootFooterTableTab"}, {
				XMLElement["tr",{},{  
					XMLElement["td", {"colspan"->"3"}, {" "}]
				}],
				
				XMLElement["tr",{},{
					TD[{},{
						DIV[{"class"->"FooterRedLink"}, {
						A[{"href"->"/language/guide/AlphabeticalListing.html"}, {Transmogrify[allLinks[[1]]]}]
						}]
					}],
					TD[{},{
						DIV[{"class"->"FooterRedLink"}, {
						A[{"href"->"/language/guide/StandardExtraPackages.html"}, {Transmogrify[allLinks[[2]]]}]
						}]
					}],
					TD[{},{
						DIV[{"class"->"FooterRedLink"}, {
						A[{"href"->"http://www.wolfram.com/products/"}, {
							Transmogrify[allLinks[[3]]]
							}]
						}]
					}]
				}],
				
				XMLElement["tr",{},{
					TD[{},{
						DIV[{"class"->"FooterRedLink"}, {
						A[{"href"->"http://reference.wolfram.com/legacy/"}, {
							Transmogrify@Localized["Legacy Documentation", language]
							}]
						}]
					}],
					TD[{},{
						DIV[{"class"->"FooterRedLink"}, {
						A[{"href"->"http://demonstrations.wolfram.com/"}, {Transmogrify[allLinks[[5]]]}]
						}]
					}],
					TD[{},{
						DIV[{"class"->"FooterRedLink"}, {
						A[{"href"->"http://www.wolfram.com/language/"}, {
							Transmogrify@Localized["More About Mathematica", language]
							}]
						}]
					}]
				}]

				}](* end Table *)
			}](* end RootFooterTable Div *)
		}]
	}]

],

{Cell, "RootLinkText"}:>  Recurse[],

{Cell, "Picture"} :> 
transmogrifyImage[ToFileName[{"Files", GetFileNameBase[]},
    IncrementCounter["Image"] <> ".gif"],
    Inline -> True, CropImage -> False
], 


{Cell,  "2ColumnTable" | "3ColumnTable" | "2ColumnTableMod" | "3ColumnTableMod" | "3ColumnIllustratedTableMod"} :>
  DIV[ {"class" -> "FunctionTable", "name" -> (GetStyle[]/.None->"FIXME")}, 
  {{Recurse[] }}
], 


{Cell, "GuideTOCTitle"} :> 
H1[{},  {Recurse[]}],  


{Cell, "GuideTOCLink"} :> XMLElement["h3", {}, {Recurse[]}],


{Cell, "GuideTOCAbstract"} :>
P[{"class" -> "intro"}, {Recurse[]}],

{CellGroupData, "RootSection"} :> {
    DIV[{"class" -> "RootSection"}, {Recurse[]}],
    XMLElement["img",{"src" -> "/mathematicaImages/shadowbottom.gif", "class"->"RootSectionBar"},{}]
},
  
  {Cell, "RootSection"} :>
  Module[{id, inc1, inc2, iconName, caption, rootLinkList},
  	inc1 = IncrementCounter["RootIcon"];
  	inc2 = IncrementCounter["RootSection"];
    iconName = "/mathematicaImages/RootIcon"<>inc1<>".gif";
    id = "scenarios" <> inc2;
    caption = GetParameter["rootCaptions"][[ToExpression[inc2]]];
    rootLinkList = {"1"->"LanguageOverview","2"->"MathematicsAndAlgorithmsOverview",
    "3"->"VisualizationAndGraphicsOverview","4"->"DataManipulationOverview","5"->"ComputableDataOverview",
    "6"->"DynamicInteractivityOverview","7"->"NotebooksAndDocumentsOverview","8"->"SystemsInterfacesAndDeploymentOverview"};

    XMLElement["table",{"class" -> "RootBox", "id" -> (id <> "-link"), "href" -> "javascript:;",
         "onmousedown" -> ("toggleSlide('" <> id <> "');"),
         "onmouseover" -> ("highlightOn('" <> id <> "');"),
         "onmouseout" -> ("highlightOff('" <> id <> "');")
      }, {
      XMLElement["tr", {}, {
      	XMLElement["noscript", {}, {
      			XML`RawXML["<a href=\"/language/guide/"<>StringReplace[inc2, rootLinkList]<>".html\">"
      			]
      			}],
      TD[{},{
      XMLElement["img", {"align" -> "left", "class"->"RootIcon","src" -> iconName, "alt" -> ""}, {}]
            }],
      TD[{"width"->"595px;", "class" -> "RootTitle"},{
      DIV[{"class" -> "RootTitle", "id" -> (id <> "-title")}, {
      	
      	DIV[{"id"->"JShidden", "class"->"display:none;"}, {
      		
      		DIV[{"style"->"RootDarkLink"}, {
      		Transmogrify@Cases[SelectSelf[], Cell[a_, "RootSectionTitle", __], Infinity][[1,1]]
      		}]
		}]
      }],
      DIV[{"class" -> "RootSubtitle"},
        {Transmogrify@caption[[1]],
        	Transmogrify@Cases[SelectSelf[], Cell[a_, "RootSectionCaption"]->a, Infinity] }]
            }],
      TD[{},{
      DIV[{"class" -> "RootArrow", "id" -> (id <> "-plus")}, {" "}]
            }]
        }],
        
      		XMLElement["noscript", {}, {
      				XML`RawXML["</a>"]
      		}]
    }]
  ],

{Cell, "RootGrid2Column"} :>
  Module[{row},
    row = SelectNearestDescendants[GridBox][[1, 1]];
    DIV[{"class" -> "RootGrid2Column"}, {
      XMLElement["table", {}, {XMLElement["tr", {}, {
        XMLElement["td", {}, {Transmogrify@First[row]}],
        XMLElement["td", {}, {
          XML`RawXML["<!--#include virtual=\"/searchbar.html\"-->"],
          Transmogrify@Last[row]
        }]
      }] }]
    }]
  ],

{Cell, "RootGrid3Column"} :>
  Module[{row},
    row = SelectNearestDescendants[GridBox][[1, 1, 1]];
    DIV[{"class" -> "RootGrid3Column",  "id"->If[language==="Japanese","ja","en"] }, {
      XMLElement["table", {}, {XMLElement["tr", {}, {
        XMLElement["td", {}, {
          XML`RawXML["<!--#include virtual=\"/searchbar.html\"-->"],
          Transmogrify[row[[1]]]}],
        XMLElement["td", {}, {Transmogrify[row[[2]]]}],
        XMLElement["td", {}, {Transmogrify@Last[row]}]
      }] }]
    }]
  ],

{Cell, "RootGrid"} :>
Block[{flag = GetParameter["flag"], cellflag, cont},
	cellflag = GetStyle[];
	(*cont= SelectChildren[][[1]];*)
  If[flag =!= "RootGuidePage",
    Recurse[],
    DIV[{"class"->"GuideFunctionsSectionBar"}, {
     XMLElement["table", {"class"->"GuideFunctionsSectionTable"}, {
		XMLElement["tr", {}, {XMLElement["td", {}, {Recurse[]}]}]
		}] 
	 }]
   ] ], 


(* {Cell, "RootHeading"}:> DIV[{"class"->"GuideFunctionsSection"}, {
	Span[{"class"->"GuideFunctionsSection"}, {Recurse[]}]
}], *)

{Cell, "RootHeading"}:> XMLElement["div", {"class"->"GuideFunctionsSection"}, {
	Span[{"class"->"GuideFunctionsSection"}, {Recurse[]}]
}],

{BoxData}:> Recurse[],

{Cell, "GuideTitle"} :> 
Module[{flag = GetParameter["flag"]},
  If[flag =!= "RootGuidePage",
    H1[{}, {Recurse[] } ],
    DIV[{}, {}]
  ]
],

{Cell, "GuideTitleGrid"} :>  Block[{objgrid = True}, 
  DIV[{"class"->"GuideTitleGrid"}, {Recurse[]}] ],

{Cell, "IntroLinkCell"} :> Sequence[],
(*
XMLObject["Comment"][ToString@DIV[{"class"->"IntroLinkCell"}, {Recurse[] } ] ],
*)

{StyleBox, "GuideFunctionsSubsection"} :> Recurse[],

{Cell, "GuideAbstract"} :> 
Module[{flag = GetParameter["flag"]}, 
  If[flag =!= "RootGuidePage",
    WithParameters[{"newline2br" -> False, "newline2div" -> True, "styleUsageMessageBreak" -> "<span class='br'>&nbsp;</span>"},P[{"class"->"intro"}, {Recurse[]} ]],
    DIV[{},{}]
  ]
],

{Cell, "GuideFunctionsSubsection"} :> 
Module[{flag = GetParameter["flag"]}, 
  If[flag =!= "RootGuidePage",
    H2[{}, {Recurse[]} ],
    DIV[{},{}]
  ]
],

{Cell, "GuideDelimiterSubsection"} :> 
Module[{flag = GetParameter["flag"]}, 
  If[flag =!= "RootGuidePage",
    XMLElement["div", {"class"->"GuideDelimiterSubsection"}, {XML`RawXML["<!-- -->"]} ],
    DIV[{},{}]
  ]
],

{Cell, "GuideDelimiter"} :> 
Module[{flag = GetParameter["flag"]}, 
  If[flag =!= "RootGuidePage",
    XMLElement["div", {"class"->"GuideDelimiter"}, {XML`RawXML["<!-- -->"]} ],
    DIV[{},{}]
  ]
],


{Cell, "GuideFunctionsSection" | "GuideMainTutorial" | "GuideTestDrive" | "GuideTitle" |
"GuideFunctionGroupCaption"} :> 
Module[{flag = GetParameter["flag"]}, 
  If[flag =!= "RootGuidePage",
    DIV[{"class"->GetStyle[]}, {
    	Recurse[]
    	(*A[{"name" -> StringReplace[GetStyle[], {"Guide"->""} ]}, {Recurse[]}]*)
    	} ],
    DIV[{},{}]
  ]
],

{CellGroupData, "GuideTutorialsSection" } :> XMLElement["div", {"class"->"expandWrap", "id"->"RelatedTutorials"},
	{XMLElement["div", {"class"->"expandOuter"},{
		XMLElement["h2", {"class"->"expandInner"}, {
			XMLElement["a", {"class"->"expand hide", "title"->Localized["show", GetParameter["language"]], "href"->"#"},{Localized["RelatedTutorialsSectionText", GetParameter["language"]]}], 
			XMLElement["a", {"class"->"collapse", "title"->Localized["hide", GetParameter["language"]], "href"->"#"},{Localized["RelatedTutorialsSectionText", GetParameter["language"]]}]}], 
			XMLElement["div",{"class"->"expanded"},{XMLElement["ul",{"class"->"functionList"},{Recurse[]}]}]}]}],

{Cell, "GuideTutorialsSection" } :> Unevaluated[Sequence[]],

{CellGroupData, "GuideMoreAboutSection" } :> XMLElement["div", {"class"->"expandWrap", "id"->"RelatedGuides"},
	{XMLElement["div", {"class"->"expandOuter"},{
		XMLElement["h2", {"class"->"expandInner"}, {
			XMLElement["a", {"class"->"expand hide", "title"->Localized["show", GetParameter["language"]], "href"->"#"},{Localized["MoreAboutSectionText", GetParameter["language"]]}], 
			XMLElement["a", {"class"->"collapse", "title"->Localized["hide", GetParameter["language"]], "href"->"#"},{Localized["MoreAboutSectionText", GetParameter["language"]]}]}], 
			XMLElement["div",{"class"->"expanded"},{XMLElement["ul",{"class"->"functionList"},{Recurse[]}]}]}]}],

{Cell, "GuideMoreAboutSection" } :> Unevaluated[Sequence[]],

{CellGroupData, "GuideRelatedLinksSection" } :> XMLElement["div", {"class"->"expandWrap", "id"->"RelatedLinks"},
	{XMLElement["div", {"class"->"expandOuter"},{
		XMLElement["h2", {"class"->"expandInner"}, {
			XMLElement["a", {"class"->"expand hide", "title"->Localized["show", GetParameter["language"]], "href"->"#"},{Localized["RelatedLinksSectionText", GetParameter["language"]]}], 
			XMLElement["a", {"class"->"collapse", "title"->Localized["hide", GetParameter["language"]], "href"->"#"},{Localized["RelatedLinksSectionText", GetParameter["language"]]}]}], 
			XMLElement["div",{"class"->"expanded"},{XMLElement["ul",{"class"->"functionList"},{Recurse[]}]}]}]}],

{Cell, "GuideRelatedLinksSection" } :> Unevaluated[Sequence[]],

{CellGroupData, "GuideTutorialCollectionSection" } :> XMLElement["div", {"class"->"expandWrap", "id"->"TutorialCollection"},
	{XMLElement["div", {"class"->"expandOuter"},{
		XMLElement["h2", {"class"->"expandInner"}, {
			XMLElement["a", {"class"->"expand hide", "title"->Localized["show", GetParameter["language"]], "href"->"#"},{Localized["TutorialCollectionSectionText", GetParameter["language"]]}], 
			XMLElement["a", {"class"->"collapse", "title"->Localized["hide", GetParameter["language"]], "href"->"#"},{Localized["TutorialCollectionSectionText", GetParameter["language"]]}]}], 
			XMLElement["div",{"class"->"expanded"},{XMLElement["ul",{"class"->"functionList"},{Recurse[]}]}]}]}],

{Cell, "GuideTutorialCollectionSection" } :> Unevaluated[Sequence[]],

(* {Cell, "RootMoreAboutDelimiter"} :> 
    DIV[{"class"->"GuideDelimiter"}, {Recurse[] } ],  *)
    
{CellGroupData, "FeaturedExampleSection"} :> XMLElement["div", {"class"->"expandWrap", "id"->"FeaturedExamples"},
	{XMLElement["div", {"class"->"expandOuter", "id"->"mycarousel"},{
		XMLElement["h2", {"class"->"expandInner"}, Flatten[{
			XMLElement["a", {"class"->"expand hide", "title"->Localized["show", GetParameter["language"]], "href"->"#"},{Localized["GuideFeaturedExamplesSectionText", GetParameter["language"]]}], 
			XMLElement["a", {"class"->"collapse", "title"->Localized["hide", GetParameter["language"]], "href"->"#"},{Localized["GuideFeaturedExamplesSectionText", GetParameter["language"]]}], 
			If[Cases[SelectSelf[], TaggingRules~(Rule | RuleDelayed)~a_:>a, Infinity][[1]]>4, XMLElement["div", {"class" -> "jcarousel-scroll"}, {
				XMLElement["a", {"href" -> "#", "class" -> "buttons prev"}, {XML`RawXML["<!-- -->"]}], 
				XML`RawXML["<span class=\"page-out-of\"></span><span class=\"divider\">|</span><span class=\"total-pages\"></span>"], 
				XMLElement["a", {"href" -> "#", "class" -> "buttons next"}, {XML`RawXML["<!-- -->"]}], 
				XMLElement["a", {"href" -> "#", "class" -> "buttons", "id" -> "mycarousel-minimize"}, {XML`RawXML["<!-- -->"]}], 
				XMLElement["a", {"href" -> "#", "class" -> "buttons", "id" -> "mycarousel-show-all"}, {XML`RawXML["<!-- -->"]}]}], {}]
			}]], 
			XMLElement["div",{"class"->"expanded"},{XMLElement["div",{"class"->"viewport"},{XMLElement["ul",{"class"->"overview"},{Recurse[]}]}]}]}]}],
			
{Cell, "FeaturedExampleSection"} :> Unevaluated[Sequence[]],

{CellGroupData, "FeaturedExampleLink"} :> XMLElement["li", {},{XMLElement["a", {"href"->Cases[SelectSelf[], Cell[a_, "FeaturedExampleLink", ___]:>a, Infinity][[1]]},{Recurse[]}]}],
			
{Cell, "FeaturedExampleLink"} :> Unevaluated[Sequence[]],

{Cell, "FeaturedExampleThumbnailImage"} :> transmogrifyImage[ToFileName[{"Files", GetFileNameBase[]},
    "featured_example"<>IncrementCounter["FeaturedExampleThumbnail"] <> ".png"], {"alt"->"carousel-img"<>GetCounter["FeaturedExampleThumbnail"]},
    Inline -> True, CropImage -> False, ImageFormat->"PNG"],

{Cell, "FeaturedExampleText"} :> XMLElement["span", {},{Recurse[]}],
    
{CellGroupData, "GuideLearningResourcesSection"} :> XMLElement["div", {"class"->"expandWrap closed", "id"->"LearningResources"},
	{XMLElement["div", {"class"->"expandOuter"},{
		XMLElement["h2", {"class"->"expandInner"}, {
			XMLElement["a", {"class"->"expand hide", "title"->Localized["show", GetParameter["language"]], "href"->"#"},{Localized["GuideLearningResourcesSectionText", GetParameter["language"]]}], 
			XMLElement["a", {"class"->"collapse", "title"->Localized["hide", GetParameter["language"]], "href"->"#"},{Localized["GuideLearningResourcesSectionText", GetParameter["language"]]}]}], 
			XMLElement["div",{"class"->"expanded"}, 
				{XMLElement["table", {"cellspacing" -> "0", "cellpadding" -> "0", "border" -> "0"}, {XMLElement["tr", {}, {Recurse[]}]}]}]}]}],
			
{Cell, "GuideLearningResourcesSection"} :> Unevaluated[Sequence[]],

{CellGroupData, "GuideLearningResourcesLeftSection"} :> XMLElement["td", {"class" -> "resourcesLeft"}, {XMLElement["div", {}, {Recurse[]}]}],

{Cell, "GuideLearningResourcesLeftSection"} :> Unevaluated[Sequence[]],

{Cell, "GuideLearningResourcesTutorialSection"} :> XMLElement["h3", {}, {Recurse[]}],

{Cell, "LearningResourceTutorial"} :> XMLElement["div", {}, {Recurse[]}], 

{Cell, "GuideLearningResourcesHowToSection"} :> XMLElement["h3", {}, {Recurse[]}],

{Cell, "LearningResourceHowTo"} :> XMLElement["div", {}, {Recurse[]}],

{CellGroupData, "GuideLearningResourcesRightSection"} :> XMLElement["td", {"class" -> "resourcesRight"}, {Recurse[]}],

{Cell, "GuideLearningResourcesRightSection"} :> Unevaluated[Sequence[]],

{Cell, "SmallTitle"} :> XMLElement["p", {"class"->"smallTitle"}, {Recurse[]}],

{Cell, "ResourceTraining"} :> Recurse[],
{Cell, "ResourceVideos"} :> Recurse[],
{Cell, "ResourceDemonstrations"} :> Recurse[],
{Cell, "ResourceCommunity"} :> Recurse[],

{Cell, "RootMoreAboutDelimiter"} :> 
    DIV[{"class"->"RootMoreAboutDelimiter"}, {Recurse[] } ],

{Cell, "RootSectionCaption"} :> 
    DIV[{"class"->"GuideFunctionGroupCaption"}, {Recurse[] } ],


{Cell, "GuideMoreAbout" | "GuideMoreAboutSub" | "GuideTutorial" | "GuideRelatedLinks" | "GuideTutorialCollection"} :>
Module[{flag = GetParameter["flag"]},
  If[flag =!= "RootGuidePage",
	Li[{Recurse[]}],
    DIV[{"class"->"OtherItems"},  {
	UL[{"class"->GetStyle[]}, { 
  	Li[{ Recurse[] }]
 		 }]
		}]
	] ],
	

{Cell, "RootMoreAbout"} :> {},

{Cell, "GuideText"} :> 
Module[{flag = GetParameter["flag"]},
  If[flag =!= "RootGuidePage",
    P[{"class"->"singleFunction"},  { Recurse[] }],
    Module[{guidelinks,guidelinksNew678,class="left"},
      guidelinks = Cases[SelectSelf[], _ButtonBox, Infinity];
      (*guidelinksNew678 = Insert[Take[guidelinks, {-3, -2, -1}], " | ", 2];*)
      guidelinksNew678 = Riffle[Take[guidelinks, {-3, -1}], " | "];
      guidelinks=Join[Drop[guidelinks, -3], {guidelinksNew678}];
	  guidelinks=If[EvenQ@Length@guidelinks === True, guidelinks, Append[guidelinks, {}]];
	  guidelinks = Partition[guidelinks, 2];
	  guidelinks = Transpose[guidelinks];
      guidelinks = Map[
        DIV[{"class" -> (class="right";#)&[class]}, {XMLElement["ul", {},
          Map[Li[{"class" -> "redlink"}, {Transmogrify[#]}]&, #]
        ]}]&,
        guidelinks];
      XMLElement["table",{
          "id" -> ("scenarios" <> GetCounter["RootSection"]),
          "class" -> "RootLinks",
          "style" -> "display: none"
        }, {
        XMLElement["tr",{}, {
        TD[{"class"->"rootLinkCol"}, {guidelinks[[1]]}],
        TD[{"class"->"rootLinkCol"}, {DeleteCases[guidelinks[[2]], XMLElement["li",{__},{}], Infinity]}]
        }]
      }]
    ]
]],

{Cell, "RootLinks" | "RootLink"} :> 
Module[{flag = GetParameter["flag"]},
  If[flag =!= "RootGuidePage",
    DIV[{"class"->"GuideText"},  { Recurse[] }],
    Module[{guidelinks,guidelinksNew678,class="left"},
      guidelinks = Cases[SelectSelf[], _ButtonBox, Infinity];
      (*guidelinksNew678 = Insert[Take[guidelinks, {-3, -2, -1}], " | ", 2];*)
      guidelinksNew678 = Riffle[Take[guidelinks, {-3, -1}], " | "];
      guidelinks=Join[Drop[guidelinks, -3], {guidelinksNew678}];
	  guidelinks=If[EvenQ@Length@guidelinks === True, guidelinks, Append[guidelinks, {}]];
	  guidelinks = Partition[guidelinks, 2];
	  guidelinks = Transpose[guidelinks];
      guidelinks = Map[
        DIV[{"class" -> (class="right";#)&[class]}, {XMLElement["ul", {},
          Map[Li[{"class" -> "redlink"}, {Transmogrify[#]}]&, #]
        ]}]&,
        guidelinks];
      XMLElement["table",{
          "id" -> ("scenarios" <> GetCounter["RootSection"]),
          "class" -> "RootLinks",
          "style" -> "display: none"
        }, {
        XMLElement["tr",{}, {
        TD[{"class"->"rootLinkCol"}, {guidelinks[[1]]}],
        TD[{"class"->"rootLinkCol"}, {DeleteCases[guidelinks[[2]], XMLElement["li",{__},{}], Infinity]}]
        }]
      }]
    ]
]],


{Cell, "RootText"} :> 
Module[{rows},
  rows = First@First@SelectNearestDescendants[GridBox];
  DIV[{"class" -> "GuideText"}, {
    XMLElement["ul", {"class" -> "RootText"}, Flatten[{
      Map[
        XMLElement["li", {}, 
          If[MatchQ[#, {_, Cell[TextData[_List, ___], ___]}],
            Flatten@Map[
              If[MatchQ[#, {StyleBox[" \[FilledSmallSquare] ", ___]}],
                {" ", XMLElement["img",
                  {"src" -> "http://reference.wolfram.com/mathematicaImages/bullet.gif",
                   "style" -> "vertical-align: middle", "alt"->"bullet", "title"->"bullet"},
                  {}], " "},
                Transmogrify /@ #
              ]&,
              Split[#[[2, 1, 1]], Not[Apply[Or, Map[
                MatchQ[#, StyleBox[" \[FilledSmallSquare] ", ___]]&,
                {#1, #2}]]]&]
            ],
            (* Else *)
            {Transmogrify[#]}
        ]]&,
        Most[rows] ],
      XMLElement["li", {}, {
        Transmogrify[rows[[-1, 2]]] /. XMLElement["a", atr_, cnt_] :>
          XMLElement["a", atr, {
            XMLElement["span", {"style" -> "color:#454545"}, {
              StringDrop[cnt[[1]], -1] }],
            StringTake[cnt[[1]], -1]
          }]
      }]
    }] ]
  }]
],

{StyleBox, "InlineSeparator"} :>If[StringReplace[GetFileNameBase[], {".en"->"", ".ja"->""}]==="Mathematica",
Span[{"class" -> "inlineBullet"}, {XML`RawXML["&nbsp;"], XML`RawXML["&#9642;"], XML`RawXML["&nbsp;"]}],
Span[{"class" -> "inlineBullet"}, {XML`RawXML["&nbsp;"], XML`RawXML["&#9642;"], XML`RawXML["&nbsp;"]}]
],


{StyleBox, "LeadingBullet"} :>
Span[{"class" -> "LeadingBullet"}, {
    Img[{"src" -> htmlBase<>"/mathematicaImages/bullet.gif", "width"->"4", "height"->"4", "style"->"vertical-align:middle;", "alt"->"bullet", "title"->"bullet"}] }],

{Cell, "InlineListing"} :>
DIV[{"class" -> "InlineListing"}, {Recurse[] }],

{Cell, "InlineListing3Col"} :>
DIV[{"class" -> "InlineListing3Col"}, {Recurse[] }],

{Cell, "InlineListing4Col"} :>
DIV[{"class" -> "InlineListing4Col"}, {Recurse[] }],


{Cell, "InlineGuideFunction"} :> 
Span[{"class"->"InlineGuideFunction"}, {Recurse[]} ],


{Cell, "InlineGuideFunctionListing"} :> 
Module[{ml},
  ml = Recurse[];
  If[(Length@{ml} === 1) && (Head@ml === String),
   ml = StringSplit[ml, RegularExpression["\\s+\\.\\s+"] ];
   ml = Span[{"class"->"InlineGuideFunction"}, 
          {XMLElement["a", {"href"->"/language/ref/"<>#}, {#}] }]&/@ ml;
   ml = Riffle[ml,  
     Span[{"class" -> "inlineGuideFunctionListingBullet"}, 
       {" ", Img[{"src" -> htmlBase<>"/mathematicaImages/bullet-guide.gif", "width"->"6", "height"->"12", "style"->"vertical-align:middle;", "alt"->"bullet-guide", "title"->"bullet-guide"}],
       " "}]
     ] ];
  P[{"class"->"inlineFunctionList"}, Flatten@{ml}]
],

PaneSelectorBox:>Transmogrify@SelectSelf[][[1,2,2]]


},

IncludeXMLTransforms -> {{"HTML","Components","Includes.m"}},

DefaultParameters -> {
  "newline2br" -> True,
  "newline2div" -> False,
  "styleUsageMessageBreak" -> "</div>\n<div class='UsageMessage'>",
  "noop" -> {
    $CreateCompleteHTMLFile = False;
    $LanguageExtension = "en";
   }
},

CounterReassignments -> {{"Chapter", "Section"}, {"Section", "Subsection"}, {"Subsection", "Subsubsection"} }

]
