(* :Title: Report.m *)

(* :Author:
  Bill White, billw@wolfram.com
  Andrew Hunt, andy@wolfram.com
*)

(* :Mathematica Version: 5 *)
(* :Package Version: $Revision: 1.2 $ $Date: 2012/08/16 19:50:36 $ *)                  
(* :Copyright: (c) 2006, Wolfram Research, Inc. All rights reserved. *)
(* :Summary: Specific rules and general transform for Mathematica Documentation Report *)


XMLTransform[{
(* ---------------------------------------------------------------------- *)
  {Notebook} :> XMLElement["div", {}, {XML`RawXML["
<script language='javascript'>
<!--
function toggle (id) {
el = document.getElementById (id);
cls = el.className;
action = 0;
if (cls.lastIndexOf ('_Co') == cls.length - 3) {
clsPre = cls.substring (0, cls.length - 3);
el.className = clsPre + '_Ex';
action = 1;
}
else if (cls.lastIndexOf ('_Ex') == cls.length - 3) {
clsPre = cls.substring (0, cls.length - 3);
el.className = clsPre + '_Co';
action = 2;
}
if (action == 1) {
img = document.getElementById (id + '_');
img.src = img.src.replace ('closed', 'open');
}
else if (action == 2) {
img = document.getElementById (id + '_');
img.src = img.src.replace ('open', 'closed');
}
}
-->
</script>

<style type='text/css'>
<!--
.Section {font-family:sans-serif; margin:6 0 36 0; font-size:18px;}
.SectionGroup {margin:24 10 0 24; }
.Subsection {display:block; font-family:sans-serif; margin:6 0 12 0; font-size:12px;}
.Output {font-family:monospace; margin:3 0 3 0; font-size:12px;}
.text {font-family:serif; margin:3 0 6 0; font-size:12px;}
div.Subsection_Co { display:none; padding-top:5px; }
div.Subsection_Ex { display:block; padding-top:5px; }

-->
</style>
       "],
        Recurse[]}],
(* ---------------------------------------------------------------------- *)
      {Cell, "Section"} :> DIV[{"class" -> "Section"}, {Recurse[]}],
(* ---------------------------------------------------------------------- *)
      {Cell, "SubsubsectionIcon"} :>
        DIV[{"class" -> "Subsection"}, {
          A[{
            "href" -> 
              (StringJoin["javascript:toggle('Subsection_", ToString[IncrementCounter["Subsection1"]], "')"])
          }, {
            Img[{
              "src" -> "/pubs/online/images/closedGroup.gif",
              "id"->"Subsection_1_",
              "border"->"0",
              "width"->"8",
              "height"->"8"}], 
            " ",
            Recurse[]
          }]}],
(* ---------------------------------------------------------------------- *)
      {CellGroupData} :> DIV[{
          "class" -> "Subsection_Co",
          "id" -> StringJoin["Subsection_", ToString[GetCounter["Subsection1"]]]
        }, {Recurse[]}],
(* ---------------------------------------------------------------------- *)
      {Cell, "Text"} :> 
        DIV[{
          DIV[{"class" -> "Text"},
            {Recurse[]}
        ]}],
(* ---------------------------------------------------------------------- *)
      {Cell, "Output"} :>
          DIV[{"class" -> "Output"}, {Recurse[]}],
(* ---------------------------------------------------------------------- *)
      {StyleBox} :> Span[{"class" -> GetStyle[]}, {Recurse[]}],
(* ---------------------------------------------------------------------- *)
{ButtonBox} :> 
Block[{output = Recurse[]},

If[output==="...", output = Span[{"class"->"inlineEllipsis"}, {output}]];
(* first create an <a> tag,
   here "#" is replaced with the actual URL computed
   below *)
XMLElement["a", Flatten[{"href"->#, 
Which[
	If[Head[GetOption[DefaultContentStyle]]=!=String, GetOption[DefaultStyle],GetOption[DefaultContentStyle]]==="AnchorLink", "class"->"anchorLink",
	If[Head[GetOption[DefaultContentStyle]]=!=String, GetOption[DefaultStyle],GetOption[DefaultContentStyle]]==="ExampleLink", {"class"->"ExampleButtonLink", 
	  "onclick"->"expandToId('"<> 
	    If[HasOption[ButtonData], StringReplace[ToString@GetOption[ButtonData], ":" -> "_"], "NONE" ] <>
	  "')" },
	If[Head[GetOption[DefaultContentStyle]]=!=String, GetOption[DefaultStyle],GetOption[DefaultContentStyle]]==="NewInLink", {"class"->"NewInLink", "title"->"Toggle extended in 6"},
      True, Unevaluated@Sequence[]
  ]   
(*  If[
	GetOption[DefaultStyle]==="ExampleLink", 
      "class"->"ExampleButtonLink",
      Unevaluated@Sequence[]
  ] *)
}],
{output}]& 
  [  
    Which[
      (** get link address based off of DefaultStyle **)
      HasOption[DefaultStyle|DefaultContentStyle|DefaultStyle],
        Switch[If[Head[GetOption[DefaultContentStyle]]=!=String, GetOption[DefaultStyle],GetOption[DefaultContentStyle]],

          "Link",
            If[HasOption[ButtonData],
	        StringReplace[GetOption[ButtonData], {"paclet://"->"http://documents.devel.wolfram.com/mathematica/", "paclet:"->"http://documents.devel.wolfram.com/mathematica/"}] <> ".html"
	      ,
                StringJoin["http://documents.devel.wolfram.com/mathematica/ref/", ToString@output, ".html"]
	    ],

          "FunctionLink" | "TutorialLink" | "CharacterLink",
            (* ExportWebPage turns these into paclet:// links *)
            StringReplace[GetOption[ButtonData], {"paclet://"->"http://documents.devel.wolfram.com/mathematica/", "paclet:"->"http://documents.devel.wolfram.com/mathematica/"}] <> ".html",

          "ExampleLink",
            (* example links should point to the appropriate anchor on the same page *)
            (* check for ButtonData just in case... *)
            If[HasOption[ButtonData],
	        StringJoin["#", StringReplace[ToString@GetOption[ButtonData], ":" -> "_"] ],
              "#"
	    ],

          "AnchorLink", 
            anchorButtons = SelectSelf[];
            anchorContent = First[Extract[anchorButtons, Position[anchorButtons, __ :> __]]];
            StringJoin["#", 
              Extract[
                Cases[First[Rest[Cases[anchorContent, _]]], _], 2]
            ], 

          "NewInLink", 
            "javascript:toggleModInfo('ModInfo_6')",

          "GuideLink",
            StringJoin["http://documents.devel.wolfram.com/mathematica/guide/",
              output, ".html"],

          "MathWorldLink"|"FunctionsSiteLink",
            GetOption[ButtonData][[1, 1]],

          "MainBookLink",
            Replace[
              output, 
              GetParameter["urlRedirectRules"]],
          _,
            "/ButtonBox/FIXME"
        ], (* end Switch[] *)
      
      HasOption[ButtonData],

        (** otherwise handle regular URL's in the ButtonData **)
        Switch[GetOption[ButtonData],
          URL[_], 
            GetOption[ButtonData][[1]],

          {URL[_], _},
            GetOption[ButtonData][[1, 1]],

          {___, _String?((StringLength[#] >= 3 && StringTake[#, {-3,-1}] == ".nb")&)}, 
            Last[GetOption[ButtonData]],

          _String?((StringTake[#, {-3,-1}] == ".nb")&),
            GetOption[ButtonData],

          {___, _String},
            StringJoin[Last[GetOption[ButtonData]], ".html"],
          
          _String,  
		    Replace[
			  StringJoin[GetOption[ButtonData], ".html"],
			  GetParameter["urlRedirectRules"]][[1]],

          _, 
            "FIXME"
        ] (* end URL Switch[] *),

      (** otherwise, we can't decide URL from ButtonBox[] **)
      True,
        "/NO/BUTTONDATA/FIXME"
    ] (* end Which *)
  ]  
]
}
]


