(* :Title: MarketingPages.m *)

(* :Author:
  Andrew Hunt, andy@wolfram.com
*)

(* :Mathematica Version: 6 *)
(* :Package Version: $Revision: 1.209 $ $Date: 2016/05/31 19:35:59 $ *)                  
(* :Copyright: (c) 2006, Wolfram Research, Inc. All rights reserved. *)
(* :Summary: General transform for Mathematica Marketing Pages *)


XMLTransform[{

(* Transform Notebook *)
_Notebook :>  Block[{title, nbExpr, restNBExpr, mainPrev, mainNext, 
	exampleholder, mainFileNameBase, popupFileNames, iNumber, mainFileNameNumber, 
	filename, buildNumber, $NewIn7MarketingNBList, ext, descriptionfile, descriptionfileQ, descriptionfromfile},

Global`AntLog["** Inside Transform Code **"];

$NewIn7SortedList =  {
  "BuiltInImageProcessing",
  "BuiltInParallelComputing",
(* Visualization & Graphics *)
  "AutomatedChartingGraphics",
  "NewGraphicsPrimitives",
  "VectorAndFieldVisualization",
  "ComprehensiveSplineSupport",
(* Mathematics & Algorithms *)
  "IndustrialStrengthBooleanComputation",
  "DiscreteCalculus",
  "DelayDifferentialEquations",
  "DifferentialAndDifferenceRoots",
  "TranscendentalRoots",
  "FiniteGroupTheory",
  "IntegerSequenceAnalysis",
  "NewNumberTheoryCapabilities",
  "NewCategoriesOfSpecialFunctions",
  "EnhancedFourierAnalysis",
(* Computable Data *)
  "IntegratedGenomicAndProteinData",
  "DynamicAstronomicalComputation",
  "CurrentAndHistoricalWeatherData",
  "ExtendedChemicalData",
  "IntegratedGeodesyAndGIS",
(* Data Operations Innovations *)
  "StatisticalModelAnalysis",
  "AutomaticHistogramGeneration",
  "IntegratedProgrammaticEmail",
  "SecureWebsiteImport",
(* Core Language *)
  "SequenceAlignmentAndAnalysis",
(* Interface & User Experience Innovations *)
  "SpeechOutput",
  "EnhancedTypesettingAutomation",
  "OptimizedNotebookErgonomics",
  "QuickStartAssistantPalettes",
  "NewInterfaceElements"
};

$NewIn7MarketingNBList = If[Length[MarketingNBList]<=0,
$NewIn7SortedList,
Sort[MarketingNBList,
  OrderedQ[Map[
    If[Length[#]>0, #[[1, 1]], Infinity]&[Position[$NewIn7SortedList, #]]&,
    {#1, #2}]]&
]];

ext = Switch[GetParameter["Language"], 
	"ChineseSimplified", "zh", 
	"Japanese", "ja", 
	"Spanish", "es", 
	"Russian", "ru",
	"Korean", "ko",
	"Portuguese", "pt-br",
	"German", "de",
	"French", "fr",
	 _, "en"];

speaktext[filename_String, id_String]:="
<script language=\"JavaScript\" type=\"text/javaScript\">
function loadurl(url,frame) {document.getElementById(frame).src=url;}
</script>

<div id=\"sound\">
 <a href=\"#\" onClick=\"javascript:loadurl('../../flash/flashSound.cgi?sound="<>filename<>"','soundFrame"<>id<>"'); return true\"<img src=\"../../images/playbutton.gif\" alt=\"Listen to Output\" border=\"0\">&nbsp;Listen to Output</a>
 </div>
 
<iframe frameborder=\"0\" width=\"1\" height=\"1\" src=\"../../flash/blank.html\" id=\"soundFrame"<>id<>"\" style=\"width:1px; height:1px; border:0px; scrolling:no\" scrolling=\"no\" name=\"soundFrame"<>id<>"\"></iframe>";


  nbExpr = SelectSelf[];
  
  MarketingTitleSubheaderString = ExportString[Recurse @ Cases[nbExpr, Cell[___,"MarketingTitleSubheader", ___], Infinity],"XML","AttributeQuoting"->"\"", "Entities"->{"\[LongDash]"->"&mdash;","\[LeftGuillemet]"->"<span class=\"chevron\">&laquo;</span>", "\[RightGuillemet]"->"<span class=\"chevron\">&#187;</span>"}, "ElementFormatting"->None];
  MarketingTitleAltString = ExportString[Recurse @ Cases[nbExpr, Cell[___,"MarketingTitleAlt", ___], Infinity],"XML", "AttributeQuoting"->"\"", "Entities"->{"\[LongDash]"->"&mdash;","\[LeftGuillemet]"->"<span class=\"chevron\">&laquo;</span>","\[RightGuillemet]"->"<span class=\"chevron\">&#187;</span>"}, "ElementFormatting"->None];

  topBody = First@DeleteCases[nbExpr, 
             Cell[CellGroupData[{Cell[_, "MarketingSubpageSection", ___], ___}, ___], ___], Infinity];
  exampleholder = 0;
  title = GetParameter["titleName"];
  mainFileNameBase = GetFileNameBase[];
  mainFileNameNumber = 0;
  filename = StringReplace[DirectoryName@GetParameter["filename"], {DirectoryName@DirectoryName@GetParameter["filename"]->"", "/" | "\\" -> ""}];
  (* find prev/next links *)  
  {mainPrev, mainNext} = DocumentationBuild`Utils`PreviousNextElementList[filename, $NewIn7MarketingNBList];
  iNumber = 0;
  popupFileNames = Switch[GetParameter["Language"], 
  	"Spanish",Flatten @ Cases[nbExpr, Cell[c_, "MarketingSubpageSection", ___,Rule[CellLabel,d_], ___] :> d, Infinity], 
  	"Japanese",Flatten @ Cases[nbExpr, Cell[c_, "MarketingSubpageSection", ___,Rule[CellLabel,d_], ___] :> d, Infinity], 
  	"Korean",Flatten @ Cases[nbExpr, Cell[c_, "MarketingSubpageSection", ___,Rule[CellLabel,d_], ___] :> d, Infinity], 
  	"French",Flatten @ Cases[nbExpr, Cell[c_, "MarketingSubpageSection", ___,Rule[CellLabel,d_], ___] :> d, Infinity], 
    "German",Flatten @ Cases[nbExpr, Cell[c_, "MarketingSubpageSection", ___,Rule[CellLabel,d_], ___] :> d, Infinity],   	  	
  	"Russian",Flatten @ Cases[nbExpr, Cell[c_, "MarketingSubpageSection", ___,Rule[CellLabel,d_], ___] :> d, Infinity], 
  	"Portuguese",Flatten @ Cases[nbExpr, Cell[c_, "MarketingSubpageSection", ___,Rule[CellLabel,d_], ___] :> d, Infinity], 
  	"ChineseSimplified", Flatten @ Cases[nbExpr, Cell[c_, "MarketingSubpageSection", ___,Rule[CellLabel,d_], ___] :> d, Infinity], 
  	_, Flatten @ Cases[nbExpr, Cell[c_, "MarketingSubpageSection", ___] :> c, Infinity]];
  popupFileNames = 
    Flatten[ 
      {
      name = ToLowerCase[StringReplace[ Transmogrify`ConvertToString[#], {"|"->"",","->"","."->"","\""->"", "'"->"","\'"->"", "^"->"", "&" -> "And", "\[CloseCurlyQuote]"->"", "\[CloseCurlyDoubleQuote]"->"", "\[OpenCurlyQuote]"->"", "\[OpenCurlyDoubleQuote]"->"", " "->"-","\[EAcute]"->"e","\[ScriptCapitalD]"->"D", ""->"e", "\[Hyphen]"->"-", "\[Dash]"->"-", "\[LongDash]"->"-","-"->"-","/"->"-"}]];
      name = If[StringLength[name]>50, StringTake[name, 50], name];
      name = StringTrim[name, ("+" | "-" | ".") ...];
      name = deleteNonASCII[name];
      If[ (name ===
          "MarketingSubpageTitle" || name ===
          "Marketing Subpage Title..."), "marketing-subpage-title-"<>IncrementCounter["CommonTitle"], name]
      }& /@ popupFileNames ];

  (* determine build number *)
  buildNumber = StringCases[GetAbsoluteFileName[], RegularExpression["\\d\\d\\d\\d\\d\\d"]];
  buildNumber = If[Length@buildNumber > 0, First@buildNumber, "Indeterminable"];
  descriptionfile = FileNameJoin[Flatten[{FileNameSplit[DirectoryName[FileNameJoin[Flatten[{FileNameSplit[AbsoluteFileName[GetParameter["ExamplesRawMaterialDir"]]]}]]]], "Descriptions.m"}]];
  descriptionfileQ = FileExistsQ[descriptionfile];
  descriptionfromfile = If[descriptionfileQ, filename /. Import[descriptionfile, "Package"], filename];
  (* create a .html-head file if there's a filename *)
  If[mainFileNameBase =!= "",
    Export[ 
      StringJoin[mainFileNameBase, ".html-head"],
      XML`RawXML[ StringJoin[ExportString[#, "XML"] & /@ 
        Flatten[{
          XMLElement["title", {}, {title<>": "<>Localized["MarketingTitleAddition", GetParameter["Language"]]}],
          XMLElement["meta", {"name"->"original-source", "content"->FileBaseName[GetParameter["InFileName"]]<>".nb" }, {}],
          Which[
          	StringLength[GetParameter["description"]] > 0, 
            XMLElement["meta", {
            "name"->"description", 
            "content"->GetParameter["description"] }, {}], 
            descriptionfromfile =!= filename ,
            XMLElement["meta", {
            "name"->"description", 
            "content"->descriptionfromfile }, {}],
            True, {}],
          If[Length@GetParameter["keywords"] > 0, 
            XMLElement["meta", {
            "name"->"keywords", 
            "content"->StringList[GetParameter["keywords"]] }, {}], {}],
          If[Length@GetParameter["synonyms"] > 0, 
            XMLElement["meta", {
            "name"->"synonyms", 
            "content"->StringList[GetParameter["synonyms"]] }, {}], {}],
          If[GetParameter["Language"] ==="Russian", 
            XMLElement["meta", {
            "http-equiv"->"Content-Type", 
            "content"->"text/html; charset=utf-8" }, {}], {}],
            If[GetParameter["Language"] ==="German", 
            XMLElement["meta", {
            "http-equiv"->"Content-Type", 
            "content"->"text/html; charset=utf-8" }, {}], {}],
            If[GetParameter["Language"] ==="French", 
            XMLElement["meta", {
            "http-equiv"->"Content-Type", 
            "content"->"text/html; charset=utf-8" }, {}], {}],
            If[GetParameter["Language"] ==="Korean", 
            XMLElement["meta", {
            "http-equiv"->"Content-Type", 
            "content"->"text/html; charset=utf-8" }, {}], {}]
        }]]], 
      "XML"];
  ];  

  If[mainFileNameBase =!= "",
    Export[ 
      StringJoin[mainFileNameBase, ".html-conf"],
      "SetEnv STYLE_Body '<body id=\"whatsnew\" >'",
      "Text"];
  ];

  (* layout file *)
  FillInLayout[
    GetParameter["layoutfile"],
    "Text",
   (* "localcss" -> GetParameter["localcss"], *)
    "langext"->Switch[GetParameter["Language"], 
    	"ChineseSimplified", ".zh", 
    	"Spanish", ".es", 
    	"Japanese", ".ja",
    	"Korean", ".ko",
    	"Russian", ".ru",
    	"Portuguese", ".pt-br",
    	"German", ".de",
    	"French", ".fr",
    	 _, ""],
    "categoryname"->"",
    "additionalsidebarmaterial"->
    Switch[filename,
    	"combine-knowledge-and-computation",
       "<div id='sidebar' style=\"margin-top: 0;\"><!--#include virtual=\"/solutions/includes/wa-appliance3.html\"--></div>",
    	"free-form-linguistic-input",
       "<div id='sidebar' style=\"margin-top: 0;\"><!--#include virtual=\"/solutions/includes/wa-appliance3.html\"--></div>",
       _, 
       ""],
       "additionalfootermaterial"->
    Switch[filename,
       "combine-knowledge-and-computation",
       "<!--#include virtual=\"/mathematica/includes/newsitem3.html\"-->",
    	"free-form-linguistic-input",
       "<!--#include virtual=\"/mathematica/includes/newsitem3.html\"-->",
       "comprehensive-image-processing-environment",
       "<!--#include virtual=\"/mathematica/includes/newsitem1.html\"-->",
       "graph-and-network-modeling",
       "<!--#include virtual=\"/mathematica/includes/newsitem1.html\"-->",
       "graph-and-network-analysis",
       "<!--#include virtual=\"/mathematica/includes/newsitem1.html\"-->",
       "integrated-control-systems-design",
       "<!--#include virtual=\"/mathematica/includes/newsitem1.html\"-->",
       "wavelet-analysis",
       "<!--#include virtual=\"/mathematica/includes/newsitem1.html\"-->",
       "built-in-financial-computations",
       "<!--#include virtual=\"/mathematica/includes/newsitem1.html\"-->",
       "import-and-export-formats",
       "<!--#include virtual=\"/mathematica/includes/newsitem1.html\"-->",
       "integrated-c-workflow",
       "<!--#include virtual=\"/mathematica/includes/newsitem1.html\"-->",
       "symbolicc",
       "<!--#include virtual=\"/mathematica/includes/newsitem1.html\"-->",
       "dynamic-library-loading",
       "<!--#include virtual=\"/mathematica/includes/newsitem1.html\"-->",
       "mathematica-shell-scripts",
       "<!--#include virtual=\"/mathematica/includes/newsitem1.html\"-->",
       "cuda-and-opencl-support",
       "<!--#include virtual=\"/mathematica/includes/newsitem2.html\"-->",
       "compiler-performance-enhancements",
       "<!--#include virtual=\"/mathematica/includes/newsitem2.html\"-->",
       _, 
       ""],
    "titleandmeta"->ExportString[
      XML`RawXML[ StringJoin[ExportString[#, "XML"] & /@ 
        Flatten[{
          XMLElement["title", {}, {title<>": "<>Localized["MarketingTitleAddition", GetParameter["Language"]]}],
          XMLElement["meta", {"name"->"original-source", "content"->FileBaseName[GetParameter["InFileName"]]<>".nb" }, {}],
          Which[
          	StringLength[GetParameter["description"]] > 0, 
            XMLElement["meta", {
            "name"->"description", 
            "content"->GetParameter["description"] }, {}], 
            descriptionfromfile =!= filename ,
            XMLElement["meta", {
            "name"->"description", 
            "content"->descriptionfromfile }, {}],
            True, {}],
          If[Length@GetParameter["keywords"] > 0, 
            XMLElement["meta", {
            "name"->"keywords", 
            "content"->StringList[GetParameter["keywords"]] }, {}], {}],
          If[Length@GetParameter["synonyms"] > 0, 
            XMLElement["meta", {
            "name"->"synonyms", 
            "content"->StringList[GetParameter["synonyms"]] }, {}], {}],
          If[GetParameter["Language"] ==="Russian", 
            XMLElement["meta", {
            "http-equiv"->"Content-Type", 
            "content"->"text/html; charset=utf-8" }, {}], {}],
          If[GetParameter["Language"] ==="German", 
            XMLElement["meta", {
            "http-equiv"->"Content-Type", 
            "content"->"text/html; charset=utf-8" }, {}], {}],
          If[GetParameter["Language"] ==="French", 
            XMLElement["meta", {
            "http-equiv"->"Content-Type", 
            "content"->"text/html; charset=utf-8" }, {}], {}],
          If[GetParameter["Language"] ==="Korean", 
            XMLElement["meta", {
            "http-equiv"->"Content-Type", 
            "content"->"text/html; charset=utf-8" }, {}], {}]
        }]]], 
      "XML"],
    "topicname"->"",
    "body"->
       StringReplace[ExportString[
         DIV[{"id"->"mainWrap"}, Flatten@{
           Recurse [DeleteCases[topBody, Cell[___,"MarketingTitleAlt"|"MarketingTitleSubheader", ___], Infinity]]
           (*,
           Recurse /@ Cases[nbExpr, 
             Cell[CellGroupData[{Cell[_, "MarketingRelatedLinksSection" | "MarketingRelatedDemonstrationsSection" | "MarketingMoreAboutSection" | "MarketingSeeAlsoSection" | "MarketingRelatedFunctionsSection", ___], ___}, ___], ___], Infinity] *)
         }],
        "XML",
          "AttributeQuoting"->"\"", "Entities"->{"\[LongDash]"->"&mdash;","\[LeftGuillemet]"->"<span class=\"chevron\">&laquo;</span>","\[RightGuillemet]"->"<span class=\"chevron\">&#187;</span>"}, "ElementFormatting"->None],
          {"VIRTUAL-INCLUDES-BEGIN"->"<!--#include virtual='","VIRTUAL-INCLUDES-END"->"'-->"}]
  ] 
],


(************************

Define cell transforms 

************************)

(* General styles *)

{Cell,"MarketingTitleSubheader"} :> XMLElement["div", {"class"->"breadcrumb"},{XMLElement["a", {"href"->"/language/v11/"}, {Transmogrify[Localized["MarketingAboveTitleAddition", GetParameter["Language"]]]}], XML`RawXML[" <span class=\"chevron\">&rsaquo;</span> "]}],

{Cell,"MarketingTitleAlt"} :> H1[{}, {Recurse[]} ],

{Cell, "MarketingTitle"} :> Sequence[],

{CellGroupData,"MarketingMainSection"} :> DIV[{"id" -> "main"}, {Recurse[]}],

{Cell, "MarketingMainSection"} :> Sequence[], 

{CellGroupData, "MarketingText"} :>
  {Export["thumbnails."<>ext<>".html", MakeMarketingThumbnailList[ Transpose[{
             Recurse /@ Cases[nbExpr, Cell[CellGroupData[{Cell[_, "MarketingSubpageSection", ___], ___}, ___], ___], Infinity],
             Recurse /@ Cases[nbExpr, Cell[_, "MarketingSubpageSection", ___], Infinity]
             }], GetParameter["Language"]], "XML"]; 
   Recurse[]},

{Cell, "MarketingText"} :> XMLElement["div", {"class"->"introWrap"}, {
	XMLElement["div", {"class"->"introinner"}, {
	  XML`RawXML[MarketingTitleSubheaderString],
	  XML`RawXML[MarketingTitleAltString],
	Export["introparagraph."<>ext<>".html", P[{"class" -> "intro smaller"}, {Recurse[]}], "XML"];
	XML`RawXML["<!--#include virtual=\"introparagraph.html\"-->"], 
	"VIRTUAL-INCLUDES-BEGIN"<>"/mathematica/includes/introrightcontent.php?uri="<>filename<>"VIRTUAL-INCLUDES-END" }]}],

{Cell, "Delimiter"} :> DIV[{"class" -> "line"}, {" "}],


(* Thumnails and Popup pages *)
{Cell, "MarketingSubpageSection"} :> 
Module[{r, f, sn},
  r = Recurse[];
  sn = Switch[GetParameter["Language"], 
  	"Spanish", Cases[SelectSelf[], Rule[CellLabel,d_]:>d, Infinity][[1]], 
  	"Japanese", Cases[SelectSelf[], Rule[CellLabel,d_]:>d, Infinity][[1]], 
  	"ChineseSimplified", Cases[SelectSelf[], Rule[CellLabel,d_]:>d, Infinity][[1]], 
  	"Russian", Cases[SelectSelf[], Rule[CellLabel,d_]:>d, Infinity][[1]], 
  	"Korean", Cases[SelectSelf[], Rule[CellLabel,d_]:>d, Infinity][[1]],
    "German", Cases[SelectSelf[], Rule[CellLabel,d_]:>d, Infinity][[1]], 
  	"French", Cases[SelectSelf[], Rule[CellLabel,d_]:>d, Infinity][[1]], 
  	"Portuguese", Cases[SelectSelf[], Rule[CellLabel,d_]:>d, Infinity][[1]], 
  	_, SelectSelf[]];
  sn = ToLowerCase[StringReplace[ Transmogrify`ConvertToString[sn], {"|"->"",","->"", "."->"", "\""->"", "'"->"", "\'"->"", "^"->"", "&" -> "And"," "->"-","\[CloseCurlyQuote]"->"", "\[CloseCurlyDoubleQuote]"->"", "\[OpenCurlyQuote]"->"", "\[OpenCurlyDoubleQuote]"->"", "\[EAcute]"->"e","\[ScriptCapitalD]"->"D",""->"e", "\[Hyphen]"->"-", "\[Dash]"->"-","\[LongDash]"->"-", "-"->"-", "/"->"-"}]];
  sn = If[StringLength[sn]>50, StringTake[sn, 50], sn];
  sn = StringTrim[sn, ("+" | "-" | ".") ...];
  sn = deleteNonASCII[sn];
  sn = If[(sn === "MarketingSubpageTitle" || sn ==="Marketing Subpage Title..."), "marketing-subpage-title-"<>IncrementCounter["CommonTitle"], sn];
  XMLElement["a",{"href"->sn<>".html", "onclick"->"return pop('"<>sn<>".html"<>"')"},{r, XML`RawXML["&nbsp;"], XMLElement["span",{"class"->"chevron"},{"\[RightGuillemet]"}]}]
 ], 

{CellGroupData, "MarketingSubpageSection"} :> 
Block[{sectionSource, initialcaptionSource, captionSource, styleList, caption, styles, windowSize, file, inputType, stuff, 
vTemp, hTemp, prev, next, thumb, popup, group, textGroup, sectionName, popupOutput, thumFilename,thumURL,
thumbnail, srcThumb, wThumb, hThumb, count, srcHR, wHR, hHR, labelClass, filepathname, thumbnailfilepathname, ext, isInputHiddenQ},
ext = Switch[GetParameter["Language"], 
	"ChineseSimplified", "zh", 
	"Japanese", "ja", 
	"Spanish", "es", 
	"Russian", "ru",
	"Korean", "ko",
	"German", "de",
	"French", "fr",
	"Portuguese", "pt-br",
	 _, "en"];
  sectionSource = SelectSelf[];
  initialcaptionSource=First@SelectChildren[];
  captionSource = initialcaptionSource;
  captionSource = Switch[GetParameter["Language"], 
  	"Spanish", Cases[captionSource, Rule[CellLabel,d_]:>d, Infinity][[1]], 
  	"Japanese", Cases[captionSource, Rule[CellLabel,d_]:>d, Infinity][[1]], 
  	"ChineseSimplified", Cases[captionSource, Rule[CellLabel,d_]:>d, Infinity][[1]], 
  	"Russian", Cases[captionSource, Rule[CellLabel,d_]:>d, Infinity][[1]], 
  	"Korean", Cases[captionSource, Rule[CellLabel,d_]:>d, Infinity][[1]], 
  	"German", Cases[captionSource, Rule[CellLabel,d_]:>d, Infinity][[1]], 
  	"French", Cases[captionSource, Rule[CellLabel,d_]:>d, Infinity][[1]], 
  	"Portuguese", Cases[captionSource, Rule[CellLabel,d_]:>d, Infinity][[1]], 
  	_, captionSource];
  caption = Recurse@initialcaptionSource;
  If[ DocumentationBuild`Transform`debug, Global`AntLog["*", ToString@caption ] ];
  isInputHiddenQ = If[Length@Cases[sectionSource, "InputHiddenMaterial", Infinity] > 0, True, False];

  (* custom WindowSize? *)
  windowSize = DocumentationBuild`Make`Private`GetWindowSizeCellTag[sectionSource];

  windowSize = 
    If[Length@windowSize>0, 
    If[ DocumentationBuild`Transform`debug, Global`AntLog["___Custom WindowSize -> : " <> ToString@windowSize ] ];
    windowSize, 
    {595, 700} ];
  
  mainFileNameNumber++;

  sectionName = ToLowerCase[StringReplace[ Transmogrify`ConvertToString[captionSource], {"|"->"",","->"","."->"","\""->"", "'"->"", "\'"->"", "\[CloseCurlyQuote]"->"", "\[CloseCurlyDoubleQuote]"->"", "\[OpenCurlyQuote]"->"", "\[OpenCurlyDoubleQuote]"->"","^"->"", "&" -> "And"," "->"-","\[EAcute]"->"e","\[ScriptCapitalD]"->"D", ""->"e", "\[Hyphen]"->"-", "\[LongDash]"->"-","\[Dash]"->"-", "-"->"-", "/"->"-"}]];
  sectionName = If[StringLength[sectionName] > 50, StringTake[sectionName, 50], sectionName];
  sectionName = StringTrim[sectionName, ("+" | "-" | ".") ...];
  sectionName = deleteNonASCII[sectionName];
  sectionName = If[(sectionName === "MarketingSubpageTitle" || sectionName ==="Marketing Subpage Title..."), "marketing-subpage-title-"<>IncrementCounter["CommonTitle"], sectionName];
  (* styles used in group *)
  Global`AntLog[ToString[sectionName]];
  Global`AntLog[ToString[Date[]]];
  styleList = DocumentationBuild`Utils`GetBlockStyleList[Cell@sectionSource];
  labelClass = If[ DocumentationBuild`Make`Private`HideCellLabelQ[styleList], "label_Hide", "label_Show"];
  
  (* find prev/next links *)  
  {prev, next} = DocumentationBuild`Utils`PreviousNextElementList[sectionName, popupFileNames];
  
  AppendTo[DocumentationBuild`ConversionList, 
      { "\"Filename\" -> \"" <> filename <> "\", \"PopupFilename\" -> \"" <> sectionName <> "\", \"Styles\" -> {\"" <> StringJoin @@ Riffle[styleList, "\",\""] <> "\"}, \"HiddenInputQ\"->" <> ToString@DocumentationBuild`Make`Private`HiddenInputQ[styleList] <> ", \"HideCellLabelQ\"->" <> ToString@DocumentationBuild`Make`Private`HideCellLabelQ[styleList] <> ", CellLabel->\"" <> labelClass <> "\"}" }];

  file = sectionName <>"."<>ext<>".html";
  count = IncrementCounter["Image"];
  group = Rest[SelectChildren[]];
  group = group /. Cell[c_, "MarketingText", o___] :> Cell[c,"PopupCaptionText", o];
(*  group = group /. Cell[BoxData[InterpretationBox[stuff:Cell[a_, b___], ___]], o___] :> Cell[a, o]; *)
  
  textGroup = Cases[group, Cell[_, "PopupCaptionText", ___], Infinity];
  group = DeleteCases[group, Cell[_, "PopupCaptionText", ___], Infinity];

  popupOutput = Cases[group, Cell[CellGroupData[{Cell[_,"InputThumbnailMaterial", ___], ___}, ___], ___], Infinity];
 
  If[Length@popupOutput < 1,
    popupOutput = Cases[ group, Cell[_, "InputThumbnailMaterial", ___], Infinity]
  ];
  (* no marked cells for thumbnail *)
  If[Length@popupOutput < 1,
    popupOutput = Cases[  DeleteCases[group, Cell[___, "WolframAlphaShortInput"|"WolframAlphaLong", ___], Infinity], 
        Cell[_, Alternatives@@{"ContentOutput", "Output", "Picture", "Print", "Graphics", "NotebookImage", "AltThumbnail", "AlternateThumbnail"}, ___], Infinity] 
  ];
  
  group = group /. { Cell[con_, sty_String, o___] -> Cell[con, sty, o] };
  popupOutput = thumbnail = { Flatten[popupOutput /. Cell[a_, "ContentOutput", b___] :> Cell[a, "Output", b] ] };

  group = DeleteCases[group, Cell[__, CellTags -> tags_ /; MemberQ[Flatten[{tags}], "SuppressInput"], ___], Infinity];

  thumbnail = DeleteCases[thumbnail, Cell[___, "OutputSpecial", ___], Infinity];
  
  thumbnail = If[Length[Cases[thumbnail, Cell[___, "AlternateThumbnail", ___], Infinity]]>0, Cases[thumbnail, Cell[___, "AlternateThumbnail", ___], Infinity],thumbnail];

  thumbnail = Cell[BoxData[ToBoxes@Rasterize[
    Notebook[Flatten[{thumbnail}], 
           WindowSize -> windowSize, ShowCellLabel->False, ShowCellBracket->False, CellBracketOptions->{"Color"->GrayLevel[1]}, (*PageWidth->WindowWidth,*)
           StyleDefinitions -> 
             Notebook[{(*Cell[ StyleData[ StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "MarketingPageStyles.nb"]]],*) 
               Cell[StyleData[All, "Working"], ShowCellBracket->False, CellBracketOptions->{"Color"->GrayLevel[1]}],
               Cell[StyleData["InlineFormula"], FontFamily->"Source Sans Pro", FontSize->Inherited 1.08],
               Cell[StyleData["MR"], FontFamily->"Source Sans Pro"],
               Cell[StyleData["StandardForm"],FontFamily->"Source Sans Pro"],
               Cell[StyleData["InputForm"],FontFamily->"Source Sans Pro"],
               Cell[StyleData["Input"],  FontFamily->"Source Sans Pro", FontSize->13, LineSpacing->{1.2, 0}, PageWidth->525],
               Cell[StyleData["Output"], FontSize->13],
               Cell[StyleData["Graphics"], CellID -> 1], 
               Cell[StyleData["Picture"], CellID -> 1], 
               Cell[StyleData["InputHiddenMaterial", StyleDefinitions->StyleData["Input"]], CellID -> 1], 
               Cell[StyleData["InputSuppressedMaterial", StyleDefinitions->StyleData["Input"]], CellID -> 1], 
               Cell[StyleData["InputThumbnailMaterial", StyleDefinitions->StyleData["Input"]], CellID -> 1]
             }]]]], "Output", ShowCellLabel->False, ShowCellBracket->False];


filepathname=Transmogrify`Utilities`Private`createDirectory[ToFileName[{"HTMLImages"<>"."<>ext, sectionName}]];
Export[FileNameJoin[Flatten[{FileNameSplit[filepathname], "smallthumb_" <> count <> ".png"}]], Rasterize[thumbnail, ImageSize->{{300},{300}}], "PNG"];
  srcThumb = StringJoin["HTMLImages"<>"."<>ext<>"/", sectionName, "/smallthumb_" <> count <> ".png"];
 {wThumb, hThumb} = Import[FileNameJoin[Flatten[{FileNameSplit[filepathname], "smallthumb_" <> count <> ".png"}]], "ImageSize"];

  Export[ file <> "-conf", 
"SetEnv AutoIncludes off", "Text"];

  (* Popup layout *)
  Export[ file, 
  FillInLayout[
    GetParameter["popupLayoutfile"],
    "Text",
    "title" -> ExportString[XMLElement["title", {}, {Transmogrify`ConvertToString[initialcaptionSource]<>": "<>Localized["MarketingTitleAddition", GetParameter["Language"]]}], "XML","AttributeQuoting"->"\"", "Entities"->{"\[LongDash]"->"&mdash;"}, "ElementFormatting"->None],
    "newin" -> ExportString[ Span[{"class"->"popupTitle"}, { XMLElement["a",{"href"->"/language/v11/"}, {Transmogrify[Localized["MarketingTitleAdditionPopUp", GetParameter["Language"]]] }] }], "XML"],
    "newin8" -> ExportString[ Span[{"class"->"popupTitle"}, { A[{"href"->"index.html", "onclick"->"main()"}, {
    	Transmogrify[Localized["MarketingTitleAdditionPopUp", GetParameter["Language"]]], ": ", Recurse@GetParameter["titleName"] }] }], "XML"], 
    "navigation" -> ExportString[XMLElement["div", {"class"->"breadcrumb"},{XMLElement["a", {"href"->"/language/v11/"}, {Transmogrify[Localized["MarketingAboveTitleAddition", GetParameter["Language"]]]}], XML`RawXML[" <span class=\"chevron\">&rsaquo;</span> "], XMLElement["a", {"href"->"index.html"}, {Recurse@GetParameter["titleName"]}],XML`RawXML[" <span class=\"chevron\">&rsaquo;</span>"]}], "XML"],
    "body"->
       StringReplace[ExportString[
         XMLElement["div", {"class"->"content-wrapper"}, {XMLElement["div",{"class"->"previous-article"}, {XMLElement["a", {"href"->prev<>".html"},{XML`RawXML["&lsaquo;"]}]}], DIV[{"class"->"content"}, {DIV[{"class"->"content-inner"}, {
            H1[{}, Flatten@{DeleteCases[DeleteCases[Last[caption], XMLElement["span",{"class"->"chevron"},{_}], Infinity], "\[RightGuillemet]", Infinity]}],
           Recurse@textGroup,
           FixedPoint[Replace[#, {x___, y : Longest@PatternSequence[XMLElement["table", {"class" -> "inputTable hidden"}, {___}] ..], z___} :> 
           	{x, XMLElement["div", {"class" -> "showhidewrapper"}, Flatten[{
           		XMLElement["div", {"class" -> "togglerbuttons"}, {
           			XMLElement["span", {"class" -> "togglebutton"}, {XMLElement["span", {"class"->"icon plusbutton"}, {""}], Localized["MarketingShowInput", GetParameter["Language"]]}], 
           			XMLElement["span", {"class" -> "togglebutton hidden"}, {XMLElement["span", {"class"->"icon minusbutton"}, {""}], Localized["MarketingHideInput", GetParameter["Language"]]}]}], y}]], z}] &, Flatten@{Recurse[group]}]
         }]}], XML`RawXML["<!--#include virtual=\"thumbnails.html\"-->"], XMLElement["div",{"class"->"next-article"}, {XMLElement["a", {"href"->next<>".html"},{XML`RawXML["&rsaquo;"]}]}]}],
        "XML",
          "AttributeQuoting"->"\"", "Entities"->{"\[LongDash]"->"&mdash;"}, "ElementFormatting"->None], "href=\"http://"->"target=\"_blank\" href=\"http://"]
    ], "Text"
  ];

  If[(Length@popupOutput > 0),
    A[{"href"->StringReplace[file, {".en."->".",".ja."->".",".zh."->"."}]}, { 
        (*popupOutput,*)
        Img[{"src"->srcThumb, "height"->ToString[Floor[hThumb/2]], "width"->ToString[Floor[wThumb/2]], "border"->"0", "alt"->""}] (*,
        DIV[{"class"->"thumbcaption"}, {caption}]*)
        }],
    ""
  ]
],



(** Input Cell Groups **)
{CellGroupData, "Input" | "InputHiddenMaterial" | "InputSuppressedMaterial" | "InputThumbnailMaterial" | "InputPopupMaterial" | "InputMainPageMaterial" | "InputMainPopupMaterial"} :> 
Block[{style, showInput=True (*, labelClass="sessionLabel"*)},
  style = GetStyle[];
  Flatten@{
    Recurse@Cases[SelectSelf[], Cell[_, "calloutbox", ___], Infinity],
    Flatten@{
      Recurse@Cases[SelectSelf[], Cell[_, "Input"|"Output"|"Message"|"NotebookImage"|"InputHiddenMaterial" | "InputSuppressedMaterial" | "InputThumbnailMaterial" | "Picture" | "Print" | "ShowLinkedFile" | "Graphics", ___], 5]
      }
  }
],

(*  Input / Output Images *)
{Cell, "Input" | "WolframAlphaShortInput" | "WolframAlphaLong" | "InputHiddenMaterial" | "InputThumbnailMaterial" | "InputPopupMaterial" | "InputMainPageMaterial" | "InputMainPopupMaterial"} :> 
Module[{expr, data, w, h, thumb, inputCell, inManipulateCount, graphic, duration, incount, iId, ext, iInner, iOuter, inputForm, inputFormQueue, animatedGifQ, isManipulate, style, cTags, suppressInputPopup, altText, hasGraphicQ, isHiddenQ},
  ext = Switch[GetParameter["Language"], 
	"ChineseSimplified", "zh", 
	"Japanese", "ja", 
	"Spanish", "es", 
	"Russian", "ru",
	"Korean", "ko",
	"German", "de",
	"French", "fr",
	"Portuguese", "pt-br",
	 _, "en"];
  expr = SelectSelf[];
  style = GetStyle[];
  iNumber++;
  cTags = If[HasOption[CellTags], Flatten[ {GetOption[CellTags]}], {}];
    If[ DocumentationBuild`Transform`debug && Length@cTags>0, Global`AntLog["___CellTags: "<>ToString@cTags]];
  suppressInputPopup = MemberQ[cTags, "SuppressPopup"];
  altText = If[ !suppressInputPopup, "Click for copyable input", ""];
  animatedGifQ = MemberQ[cTags, "AnimatedGIF"];
  cTags = cTags //. {a___, sty_String /; StringMatchQ[sty, "SuppressPopup" | "{WindowSize*"], b___} :> {a, b};

  iId = StringJoin["i_", ToString@iNumber];
  iInner = StringJoin[iId, "_in"];
  iOuter = StringJoin[iId, "_out"];
  inputForm = CreateInputForm[ SelectSelf[] ];
  inputForm = If[Head@inputForm === String, inputForm, ToString@inputForm];
  inputFormQueue = inputQueue[inputForm, GetOption[CellLabel]];

  isManipulate = DocumentationBuild`Utils`IsManipulateQ[ SelectSelf[] ];
  hasGraphicQ = If[Length@Cases[expr, GraphicsBox[___], Infinity] > 0, True, False];
  isHiddenQ = If[Length@Cases[expr, "InputHiddenMaterial", Infinity] > 0, True, False];

Sequence@@Flatten@{  

XMLElement["table", {"class" -> "inputTable"<>If[isHiddenQ," hidden",""]},  {  
    XMLElement["tr", {}, {

      (* cell label <td> *)
      XMLElement["td", {"class" -> "number"}, 
      
      Sequence@@{

       Flatten[ { 
        If[HasOption[CellLabel],
          (* fill it with the CellLabel text *)
          { 
            Span[Flatten[{If[isHiddenQ, {}, {}]}], {GetOption[CellLabel]}] 
          }
          ,
          (* otherwise it's empty *)
          {""}
        ] (* end If *)
     }]
}   (*  end sequence  *)
], (* end cell label <td> *) 
    
      (* input <td> *)
XMLElement["td", {"class"->"right-content"}, Flatten@{

  DIV[{"class"->"showHideInputCont"}, {
    XMLElement["div", {"class"->"showHideInput"}, 
      {
      
    (* Check for Manipulate *) 
    Which[
      isManipulate, 
      ( 
      Print["<"<>mainFileNameBase <> ": Manipulate Input cell>"]; 
      (* Do something with Input Manipulate? *)
      inManipulateCount = IncrementCounter["InManipulate"];
      inputCell=Notebook[Flatten[{AppendTo[expr, AutoStyleOptions->{"HighlightExcessArguments"->False,"HighlightUnknownOptions"->False, "UnknownOptionStyle"->{FontColor -> RGBColor[0., 0., 0.]}}]}], 
           WindowSize -> windowSize, ShowCellLabel->False, ShowCellBracket->False, CellBracketOptions->{"Color"->GrayLevel[1]}, (*PageWidth->WindowWidth,*)
           StyleDefinitions -> 
             Notebook[{Cell[ StyleData[ StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "MarketingPageStyles.nb"]]], 
               Cell[StyleData[All, "Working"], ShowCellBracket->False, CellBracketOptions->{"Color"->GrayLevel[1]}],
               Cell[StyleData["InlineFormula"], FontFamily->"Source Sans Pro", FontSize->Inherited 1.08],
               Cell[StyleData["MR"], FontFamily->"Source Sans Pro"],
               Cell[StyleData["StandardForm"],FontFamily->"Source Sans Pro"],
               Cell[StyleData["InputForm"],FontFamily->"Source Sans Pro"],
               Cell[StyleData["Input"],  FontFamily->"Source Sans Pro", FontSize->13, LineSpacing->{1.2, 0}, PageWidth->525],
               Cell[StyleData["Output", StyleDefinitions->StyleData["Output"]], FontSize->13],
               Cell[StyleData["Graphics"],  CellID -> 1], 
               Cell[StyleData["Picture"], CellID -> 1], 
               Cell[StyleData["Print"],  CellID -> 1], 
               Cell[StyleData["InputHiddenMaterial", StyleDefinitions->StyleData["Input"]], CellID -> 1], 
               Cell[StyleData["InputSuppressedMaterial", StyleDefinitions->StyleData["Input"]], CellID -> 1], 
               Cell[StyleData["InputThumbnailMaterial", StyleDefinitions->StyleData["Input"]], CellID -> 1]
             }]];
      Export[ToFileName[{"HTMLImages"<>"."<>ext, sectionName}, "InManipulate_" <> inManipulateCount <> ".png"], inputCell, "PNG"];
          {w, h} = Import[ToFileName[{"HTMLImages"<>"."<>ext, sectionName}, "InManipulate_" <> inManipulateCount <> ".png"], "ImageSize"];
          Img[{"src" -> StringJoin["HTMLImages"<>"."<>ext<>"/", sectionName, "/InManipulate_" <> inManipulateCount <> ".png"], 
          	"border"->"0", "alt"->altText, "width" -> ToString@w, "height" -> ToString@h} ]
      ),
      animatedGifQ, 
      (
        data = Evaluate@ReleaseHold @ MakeExpression[StripBoxes[First@expr], StandardForm];
        graphic = First /@ data;
        duration = 1/(Part[#, 2] & /@ data/4.);
        incount = IncrementCounter["iInner"];
        Export[ToFileName[{"HTMLImages"<>"."<>ext, sectionName}, 
          "In_" <> incount <> ".gif"],
          graphic, "GIF", "DisplayDurations" -> duration];
        {w, h} = Import[ToFileName[{"HTMLImages"<>"."<>ext, sectionName}, "In_" <> incount <> ".gif"], "ImageSize"];
        thumb = Last @ Import[  ToFileName[{"HTMLImages"<>"."<>ext, sectionName}, "In_" <> incount <> ".gif"],  "GIF"];
        Img[{"src" -> StringJoin["HTMLImages"<>"."<>ext<>"/", sectionName, "/In_" <> incount <> ".gif"],
            "width" -> ToString@w, "height" -> ToString@h} ]
       ),
      True,
      ((*Put[SelectSelf[], "/tmp/"<>sectionName<>ToString[AbsoluteTime[]/10^9]<>".txt"]; *)
      incount = IncrementCounter["iInner"];
      inputCell=Notebook[Flatten[{AppendTo[expr, AutoStyleOptions->{"HighlightExcessArguments"->False,"HighlightUnknownOptions"->False, "UnknownOptionStyle"->{FontColor -> RGBColor[0., 0., 0.]}}]}], 
           WindowSize -> windowSize, ShowCellLabel->False, ShowCellBracket->False, CellBracketOptions->{"Color"->GrayLevel[1]}, (*PageWidth->WindowWidth,*)
           StyleDefinitions -> 
             Notebook[{Cell[ StyleData[ StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "MarketingPageStyles.nb"]]], 
               Cell[StyleData[All, "Working"], ShowCellBracket->False, CellBracketOptions->{"Color"->GrayLevel[1]}],
               Cell[StyleData["InlineFormula"], FontFamily->"Source Sans Pro", FontSize->Inherited 1.08],
               Cell[StyleData["MR"], FontFamily->"Source Sans Pro"],
               Cell[StyleData["StandardForm"],FontFamily->"Source Sans Pro"],
               Cell[StyleData["InputForm"],FontFamily->"Source Sans Pro"],
               Cell[StyleData["Input"],  FontFamily->"Source Sans Pro", FontSize->13, LineSpacing->{1.2, 0}, PageWidth->525],
               Cell[StyleData["Output"], FontSize->13],
               Cell[StyleData["Graphics"],  CellID -> 1], 
               Cell[StyleData["Picture"], CellID -> 1], 
               Cell[StyleData["Print"],  CellID -> 1], 
               Cell[StyleData["InputHiddenMaterial", StyleDefinitions->StyleData["Input"]], CellID -> 1], 
               Cell[StyleData["InputSuppressedMaterial", StyleDefinitions->StyleData["Input"]], CellID -> 1], 
               Cell[StyleData["InputThumbnailMaterial", StyleDefinitions->StyleData["Input"]], CellID -> 1]
             }]];
      Export[ToFileName[{"HTMLImages"<>"."<>ext, sectionName}, "In_" <> incount <> ".png"], inputCell, "PNG"];
          {w, h} = Import[ToFileName[{"HTMLImages"<>"."<>ext, sectionName}, "In_" <> incount <> ".png"], "ImageSize"];
          Img[{"src" -> StringJoin["HTMLImages"<>"."<>ext<>"/", sectionName, "/In_" <> incount <> ".png"], 
          	"border"->"0", "alt"->altText, "width" -> ToString@w, "height" -> ToString@h} ]
    )
    ]
  }], If[ !suppressInputPopup, {
    DIV[{"class"->"hideInput"}, Flatten[{ 
    	DIV[{"class"->"closeX" }, {Span[{},{"X"}]}],
      DIV[{"class"->"inputCode"},{XMLElement["textarea", {}, {If[StringLength[inputFormQueue]>1000000, "-Graphics-", inputFormQueue]}]}]
    }]] },
    {}
  ] }] (* end <div><a> *) 
  }] (* end <td> *) 
  }] (* end <tr> *) 

}]
  }
], 
{Cell, "ShowLinkedVideo"}:>Module[{vimeonumber},
	If[StringMatchQ[Transmogrify`ConvertToString[SelectSelf[]], "*vimeo*"],
	  vimeonumber = Last[StringSplit[Transmogrify`ConvertToString[SelectSelf[]], "/"]];
	  XMLElement["div", {"class"->"embeddedvideo"}, {XMLElement["iframe", {"src" -> "//player.vimeo.com/video/"<>vimeonumber, "width" -> "550", "height" -> "309", "frameborder" -> "0", "webkitallowfullscreen" -> "", "mozallowfullscreen" -> "", "allowfullscreen" -> ""}, {" "}]}],
	  {}]],
{Cell, "ShowLinkedFile"}:>Module[{swfCopyQ, swfPath, swfcount, jpgPath, width=400, height=400, slfexpr, vimeonumber},
	If[StringMatchQ[Transmogrify`ConvertToString[SelectSelf[]], "*vimeo*"],
	  vimeonumber = Last[StringSplit[Transmogrify`ConvertToString[SelectSelf[]], "/"]];
	  XMLElement["div", {"class"->"embeddedvideo"}, {XMLElement["iframe", {"src" -> "//player.vimeo.com/video/"<>vimeonumber, "width" -> "550", "height" -> "309", "frameborder" -> "0", "webkitallowfullscreen" -> "", "mozallowfullscreen" -> "", "allowfullscreen" -> ""}, {" "}]}],
	swfcount = IncrementCounter["swfcount"];
	slfexpr=DeleteCases[SelectSelf[], Rule[PageWidth, _], Infinity];
	CreateDirectory[ToFileName[{"HTMLImages"<>"."<>ext, sectionName}]];
	Export[ToFileName[{"HTMLImages"<>"."<>ext, sectionName}, "swf_" <> swfcount <> ".png"], slfexpr, "PNG"];
    {width, height} = Import[ToFileName[{"HTMLImages"<>"."<>ext, sectionName},"swf_" <> swfcount <> ".png"], "ImageSize"];
    jpgPath= Img[{"src"->StringReplace[ToFileName[{"HTMLImages"<>"."<>ext, sectionName}, "swf_" <> swfcount <> ".png"], {"\\" -> "/"}], "title"->"Click to play animation", "alt"->"Click to play animation", "height"->ToString[height], "width"->ToString[width]}];
	Global`AntLog["Copy file from: "<>FileNameJoin[Flatten[{FileNameSplit[AbsoluteFileName[GetParameter["ExamplesRawMaterialDir"]]],
		Cases[{SelectSelf[]}, Cell[a___,Rule[CellLabel,c_],___]:>c , Infinity][[1]]}]]];
	swfCopyQ=CopyFile[FileNameJoin[Flatten[{FileNameSplit[AbsoluteFileName[GetParameter["ExamplesRawMaterialDir"]]],
		Cases[{SelectSelf[]}, Cell[a___,Rule[CellLabel,c_],___]:>c , Infinity][[1]]}]],
		ToFileName[{"HTMLImages"<>"."<>ext, sectionName}, "swf_" <> swfcount <> ".swf"]];
	If[swfCopyQ =!= $Failed, Global`AntLog["Flash file copied"], Global`AntLog["Flash file not copied"]];
	swfPath = "HTMLImages"<>"."<>ext<>"/"<>sectionName<>"/"<>"swf_" <> swfcount <> ".swf";
	Global`AntLog["Flash file path: "<>swfPath];
		XMLElement["table",{"class"->"outputTable linkedfile"}, {
   XMLElement["tr",{}, {XMLElement["td", {"class" -> "number"}, {XML`RawXML[
   "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;"]}], XMLElement["td",{},{
XMLElement["table",{},{
	XMLElement["tr",{},{
		XMLElement["td",{"class"->"right-content"},{
DIV[{"class"->"flashImage clickImage"}, {jpgPath}],
DIV[{"class"->"flash clickFlash"}, {
               XML`RawXML["
<object classid=\"clsid:d27cdb6e-ae6d-11cf-96b8-444553540000\" 
codebase=\"http://fpdownload.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=7,0,0,0\" width=\""<> ToString@width <>"\" height=\""<> ToString@height <>"\" id=\"benefits\" align=\"middle\">
<param name=\"allowScriptAccess\" value=\"sameDomain\" >
<param name=\"movie\" value=\""<> ToString[swfPath] <>"\" >
<param name=\"loop\" value=\"true\" >
<param name=\"menu\" value=\"false\" >
<param name=\"quality\" value=\"high\" >
<param name=\"wmode\" value=\"transparent\" >
<param name=\"scale\" value=\"noscale\" >
<param name=\"bgcolor\" value=\"#ffffff\" >
<embed src=\""<> ToString[swfPath] <>"\" loop=\"true\" menu=\"false\" scale=\"noscale\" quality=\"high\" bgcolor=\"#ffffff\" width=\""<> ToString[ToExpression[width]] <>"\" height=\""<>ToString[ToExpression[height]] <>"\" name=\"benefits\" allowScriptAccess=\"sameDomain\" type=\"application/x-shockwave-flash\" pluginspage=\"http://www.macromedia.com/go/getflashplayer\" ></object>"]
             }]}],
        XMLElement["td",{},{
XMLElement["div", {"class" -> "playAnimation"}, {XMLElement[
   "span", {"class" -> "callout"}, {XMLElement[
     "a", {"id" -> "vid-callout"}, {XMLElement[
       "span", {"class" -> "animationtext"}, {Localized["MarketingPlayAnimation", GetParameter["Language"]]}]}]}]}],
XMLElement["div", {"class" -> "stopAnimation"}, {XMLElement[
   "span", {"class" -> "callout"}, {XMLElement[
     "a", {"id" -> "vid-callout"}, {XMLElement[
       "span", {"class" -> "animationtext"}, {Localized["MarketingStopAnimation", GetParameter["Language"]]}]}]}]}]}]}]}]}]
             }]}]]],
             
{Cell, "Message"} :>
Module[{ext}, 
	ext = Switch[GetParameter["Language"], 
	"ChineseSimplified", "zh", 
	"Japanese", "ja", 
	"Spanish", "es", 
	"Russian", "ru",
	"Korean", "ko",
	"German", "de",
	"French", "fr",
	"Portuguese", "pt-br",
	 _, "en"];
	DIV[{"class" -> "Message"}, {
  Export[ToFileName[{"HTMLImages"<>"."<>ext, GetFileNameBase[]},
      "M_" <> IncrementCounter["iMessage"] <> ".gif"], outCell];
  transmogrifyImage[ToFileName[{"HTMLImages"<>"."<>ext, GetFileNameBase[]},
      "M_" <> GetCounter["iMessage"] <> ".gif"], {"border"->"0"},
      Inline -> True, CropImage -> False,
      ImageFormat -> "GIF"]
}]],


{Cell, "Output" | "Graphics" | "Picture" | "Print" |"OutputSpecial" | "OutputOnly"} :> 
Module[{style, cTags, outCell, ext, manipulatetimingvalue, isManipulate, isPrint, isPicture, isSound, isSoundNote, soundPath, soundID, soundExpr, manipulateExpr, ret, val, outputVals, outBase, width, height, w1, h1, flashID, swfPath, opts},

ext = Switch[GetParameter["Language"], 
	"ChineseSimplified", "zh", 
	"Japanese", "ja", 
	"Spanish", "es", 
	"Russian", "ru",
	"Korean", "ko",
	"German", "de",
	"French", "fr",
	"Portuguese", "pt-br",
	 _, "en"]; 
outCell = SelectSelf[];
style = GetStyle[];

cTags = Flatten[{Cases[outCell, Rule[CellTags, s_] :> s, Infinity]}]; 
isManipulate = DocumentationBuild`Utils`IsManipulateQ[ outCell ] && !MemberQ[cTags, "NoFlash"];
(*isManipulate = If[style === "OutputSpecial", isManipulate = False, isManipulate];*)

isPrint = If[Length[Cases[{outCell}, Cell[___, "Print", ___], Infinity]]>0, True, False];
isPicture = If[Length[Cases[{outCell}, Cell[___, "Picture", ___], Infinity]]>0, True, False];

isSound = DocumentationBuild`Utils`IsSoundQ[ outCell];
isSoundNote = !FreeQ[ outCell, _SoundNote];

If[HasOption[CellLabel] && StringMatchQ[GetOption[CellLabel], "*Form*" |"*Short*"],

  (* handle //*Form output *)
  XMLElement["table", {"class"->"outputTable"}, {
    XMLElement["tr", {}, {
      XMLElement["td", {"colspan"->"2", "class"->"number specialoutputform"}, Flatten@{
      (* this extra span just snags the inline styles from the celllabel
         block styles. width is overridden in the colspan="2" attribute *)
        If[ HasOption[CellLabel] && !isPrint && !isPicture, {
              Span[Flatten[{If[isInputHiddenQ, {}, {}]}], { GetOption[CellLabel] }]
               }, {""} ]
      }] 
    }], (* end tr  *)
  
    XMLElement["tr", {}, {
    	XMLElement["td", {"class"->"number"}, {" "}],
        XMLElement["td", {"class"->"right-content"}, { 
        (
           XMLElement["img", {
            "src" -> ("URL" /. #), "width" -> ("Width" /. #), 
            "height" -> ("Height" /. #)
          }, {}]&[
            BoxToImage[ToFileName[{"HTMLImages"<>"."<>ext, sectionName},
              "O_" <> IncrementCounter["iOutput"] <> ".png"],
            Inline -> True, CropImage -> False, ImageFormat -> "PNG"]
          ]
      )
      }] (*  close td *)
    }] (*  close tr *)
  }] (*  close table *)
  ,

  (* otherwise handle normal output *)
  XMLElement["table", {"class"->"outputTable"}, {
  XMLElement["tr", {}, {
      (* cell label <td> *)
      XMLElement["td", {"class" -> "number"}, 
        If[ HasOption[CellLabel] && !isPrint && !isPicture, {
              Span[Flatten[{If[isInputHiddenQ, {}, {}]}], { GetOption[CellLabel] }]
               }, {""} ] (* end If *)
      ], (* end cell label <td> *)


      XMLElement["td", {"class"->"right-content"}, Flatten@{

        Which[
          (isManipulate (*&& !DocumentationBuild`Transform`debug*) ), (
            Print["<" <> GetFileNameBase[] <> ": Manipulate Output cell>"]; 
            flashID = "Flash_" <> IncrementCounter["flash"];
            CreateDirectory[FileNameJoin[{"HTMLImages"<>"."<>ext, GetFileNameBase[]}]];
            swfPath = StringReplace[ToFileName[{"HTMLImages"<>"."<>ext, GetFileNameBase[]}, flashID <> ".swf"],  {"\\" -> "/"}];
            opts = {"ShowControls" -> True, "ControlAppearance" -> Automatic,  "AnimationParameters"->Hold[val] };
            manipulateExpr = ReleaseHold@MakeExpression[First@outCell, StandardForm];
            {w1, h1} = Import[Export[ StringReplace[swfPath, ".swf"->".png"], manipulateExpr, "PNG"], "ImageSize"];
            manipulatetimingvalue=AbsoluteTiming[ret = Export[swfPath, manipulateExpr, "SWF", Sequence@@opts]];
            Global`AntLog[ToString[manipulatetimingvalue]];
            	{width, height} = ImageSize /. val;
            {width, height} = If[ Not[And @@ IntegerQ /@ {width, height}], {w1, h1}];
(*
            A[{"href"->"javascript:swap(this," <> ToString[width] <> "," <> ToString[height] <> ",'" <> swfPath <> "', '" <> flashID <> "')",  "onmouseover"->" window.status=''; return true", "onmouseout"->"window.status=''; return true"}, {
	          (*Span[{"class" -> "playAnimation"}, {"Play Animation ", XML`RawXML["&#9642;"]}],*)
              DIV[{"id"->flashID, "name"->flashID}, {
                transmogrifyImage[ToFileName[{"HTMLImages", GetFileNameBase[]},
                  IncrementCounter["Image"] <> ".gif"],
                  Inline -> True, CropImage -> False, "border"->"0"
            ]}]}]
*)

{XMLElement["table",{},{
	XMLElement["tr",{},{
		XMLElement["td",{},{
DIV[{"class"->"flashImage clickImage"}, {Img[{"src"->StringReplace[swfPath, ".swf"->".png"], "title"->"Click to play animation", "alt"->"Click to play animation"}]}],
DIV[{"class"->"flash clickFlash"}, {
               XML`RawXML["
<object classid=\"clsid:d27cdb6e-ae6d-11cf-96b8-444553540000\" 
codebase=\"http://fpdownload.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=7,0,0,0\" width=\""<> ToString@width <>"\" height=\""<> ToString@height <>"\" id=\"benefits\" align=\"middle\">
<param name=\"allowScriptAccess\" value=\"sameDomain\" >
<param name=\"movie\" value=\""<> ToString[swfPath] <>"\" >
<param name=\"loop\" value=\"true\" >
<param name=\"menu\" value=\"false\" >
<param name=\"quality\" value=\"high\" >
<param name=\"wmode\" value=\"transparent\" >
<param name=\"scale\" value=\"noscale\" >
<param name=\"bgcolor\" value=\"#ffffff\" >
<embed src=\""<> ToString[swfPath] <>"\" loop=\"true\" menu=\"false\" scale=\"noscale\" quality=\"high\" bgcolor=\"#ffffff\" width=\""<> ToString[ToExpression[width]] <>"\" height=\""<>ToString[ToExpression[height]] <>"\" name=\"benefits\" allowScriptAccess=\"sameDomain\" type=\"application/x-shockwave-flash\" pluginspage=\"http://www.macromedia.com/go/getflashplayer\" ></object>"]
             }]}],
        XMLElement["td",{},{
XMLElement["div", {"class" -> "playAnimation"}, {XMLElement[
   "span", {"class" -> "callout"}, {XMLElement[
     "a", {"id" -> "vid-callout"}, {XMLElement[
       "span", {"class" -> "animationtext"}, {Localized["MarketingPlayAnimation", GetParameter["Language"]]}]}]}]}],
XMLElement["div", {"class" -> "stopAnimation"}, {XMLElement[
   "span", {"class" -> "callout"}, {XMLElement[
     "a", {"id" -> "vid-callout"}, {XMLElement[
       "span", {"class" -> "animationtext"}, {Localized["MarketingStopAnimation", GetParameter["Language"]]}]}]}]}]}]}]}]}
             ), 
          isSoundNote, (
            Print["<" <> GetFileNameBase[] <> ": SoundNote Output cell>"]; 
            soundID = "SoundNote_" <> IncrementCounter["soundnote"];
            soundPath = StringReplace[ToFileName[{"HTMLImages"<>"."<>ext, GetFileNameBase[]}, soundID <> ".mid"],  {"\\" -> "/"}];
            soundExpr = Sound@@Cases[First@SelectChildren[], _Sound, Infinity];
            ret = Export[soundPath, soundExpr];
            A[{"href"->soundPath, "target"->"_blank"}, {
	          (*Span[{"class" -> "playSound"}, {"Play Sound ", XML`RawXML["&#9642;"]}],*)
              DIV[{"id"->soundID}, {
                transmogrifyImage[ToFileName[{"HTMLImages"<>"."<>ext, GetFileNameBase[]},
                  IncrementCounter["Image"] <> ".gif"], {"border"->"0"},
                  Inline -> True, CropImage -> False
            ]}]}] ), 
          isSound, (
            Print["<" <> GetFileNameBase[] <> ": Sound Output cell>"]; 
            soundID = "Sound_" <> IncrementCounter["sound"];
            soundPath = StringReplace[ToFileName[{"HTMLImages"<>"."<>ext, GetFileNameBase[]}, soundID <> ".wav"],  {"\\" -> "/"}];
            soundExpr = Sound@@Cases[First@SelectChildren[], _Sound, Infinity];
            ret = Export[soundPath, soundExpr];
            A[{"href"->soundPath, "target"->"_blank"}, {
	          (*Span[{"class" -> "playSound"}, {"Play Sound ", XML`RawXML["&#9642;"]}],*)
              DIV[{"id"->soundID}, {
                transmogrifyImage[ToFileName[{"HTMLImages"<>"."<>ext, GetFileNameBase[]},
                  IncrementCounter["Image"] <> ".gif"], {"border"->"0"},
                  Inline -> True, CropImage -> False
            ]}]}] ), 
          True, (
           XMLElement["img", {
            "src" -> ("URL" /. #), "width" -> ("Width" /. #), 
            "height" -> ("Height" /. #), "border" ->"0"
          }, {}]&[
            BoxToImage[ToFileName[{"HTMLImages"<>"."<>ext, sectionName},
              "O_" <> IncrementCounter["iOutput"] <> ".png"],
            Inline -> True, CropImage -> False, ImageFormat -> "PNG"]
          ]
      )
       ] 

    }] (* end Output <td> *)

    }] (*  close tr  *)  
  }] (*  close table  *) 
] ], (* end "Output" rule *)



{StyleBox, "InlineSeparator"} :> 
  Img[{"src"->"/mathematica/images/red_bullet.gif","border"->"0"}],


(* Bulleted lists *)
{CellGroupData, "HighlightSection"} :> Module[{hghlghttm}, 
	hghlghttm=Cases[SelectSelf[], Cell[___, "HighlightItem", ___], Infinity];
	If[Length[hghlghttm]>0,
	 {XMLElement["div", {"class"->"topList"}, Map[XMLElement["ul", {}, {Transmogrify[#]}]&, Partition[hghlghttm, Ceiling[Length[hghlghttm]/2], Ceiling[Length[hghlghttm]/2], 1, {}]]], XML`RawXML["<!--#include virtual=\"thumbnails.html\"-->"]}
	 ]],
{Cell, "FutureFlag"} :> Sequence[],
{Cell, "PrintTemporary"} :> Sequence[],
{Cell, "HighlightSection"} :> Sequence[],
{Cell, "HighlightItem"} :> 
Module[{u, cell, res},
  res = Recurse[];
  cell = SelectSelf[];
  u = Cases[cell, ButtonBox[">>" | "\[RightGuillemet]", ___, 
                    Rule[ButtonData, d_String | {URL[d_String, ___], ___}], ___] :> d, Infinity];
  XMLElement["li", {}, {
    If[Length@u > 0, 
      If[Length[u]===1, res,
      res],
      res
    ]
  }] 
],


{StyleBox, "InlineSeparator"} :>
Span[{"class" -> "separator"}, {XML`RawXML["&nbsp;"], XML`RawXML["&#9642;"], " "}],

{Cell, "Delimiter" | "ExampleDelimiter"} :> Sequence[],


{Cell, "InputSuppressedMaterial"} :> 
  DIV[{"class" -> "InputSuppressedMaterial"}, {" "}],

{Cell, "ProgramHiddenMaterial" | "Program" | "Code"} :>
If[htmlBoxesQ[SelectLiteral[SelectSelf[]]],
XMLElement["div", {"class" -> (GetStyle[]/.None->"FIXME")}, {
	XMLElement["pre", {}, Flatten@{
  If[HasOption[CellTags],
  Flatten[ {
    Map[
    (XMLElement["a", {"name" -> #}, {}])&, Flatten[{GetOption[CellTags]}] ],
    Recurse[]  }],
  {Recurse[]  }  ]    }]} ],

DIV[{"class" -> GetStyle[]}, {
  (
    XMLElement["img", { 
      "class" -> "FlushInput", "src" -> ("URL" /. #), 
      "width" -> ("Width" /. #), "height" -> ("Height" /. #),  
      "alt" -> " "  }, {}]&[
      BoxToImage[ToFileName[{"HTMLImages"<>"."<>ext, sectionName},
    "Box_" <> IncrementCounter["Inline"] <> ".gif"],
    Inline -> False, CropImage -> False]
    ]
  )}]
],

(* Callouts *)
{Cell, "calloutbox" } :>
Module[{calloutID},
  exampleholder++;
  (*  Define callout counter *)
  calloutID  = "cbox"<>ToString@exampleholder<>"-"<>IncrementCounter["callout"];
  DIV[{"class" -> "callout", "id" -> calloutID, "name" -> calloutID }, {
    DIV[{"class" -> "calloutbox"}, {
      Recurse[]
    }],
  DIV[{"class"->"calloutline", "id"->calloutID, "name"->calloutID}, {
    Img[{"src"->"/common/images2003/spacer.gif", "height"->"1", "width"->"1", "border"->"0"}]
    }]
  }]
],

{Cell, "MarketingExampleDetail"} :>
Module[{myexpr},
	myexpr = DeleteCases[SelectSelf[],"MarketingExampleDetail", Infinity];
  XMLElement["p", {"class" -> "caption"}, {Transmogrify[myexpr]}]
],

{GraphicsBox | PanelBox | PaneBox} :> 
transmogrifyImage[ToFileName[{"Files", GetFileNameBase[]},
    "GB_"<>IncrementCounter["GBImage"] <> ".png"], {"alt"->""},
         Inline -> True, CropImage -> False, ImageFormat -> "PNG",
         TransparentBackground->True, ConversionOptions->{Background->None}
      ], 
      
 {Cell,None} :> Module[{
  tmp1=SelectChildren[],
  tmp2=Recurse[]
  (*tmp3=SelectAncestors[Cell] *)
},
  If[
    Head[tmp1[[1]]]===CellGroupData, 
    If[Cases[tmp1, __]==={CellGroupData[{}, Open]}, "", tmp2 ],
    If[tmp2===Null, "",
    Which[htmlBoxesQ[SelectLiteral[SelectSelf[]]], tmp2, 
		Cases[tmp1, _CheckboxBox, Infinity]=!={}, tmp2,
		Cases[tmp1, _RadioButtonBox, Infinity]=!={}, tmp2,
		True,
        transmogrifyImage[ToFileName[{"Files", GetFileNameBase[]},
          "CellNone_" <> IncrementCounter["Image"] <> ".gif"], {"style"->"vertical-align:middle;", "alt"->"", "title"->""},
          Inline -> True, CropImage -> False, ImageFormat -> "PNG",
         TransparentBackground->True, ConversionOptions->{Background->None}
        ]
      ]
  ]
  ]
],

{Cell,  "MarketingExampleCaption"} :>
H3[{"class" -> "MarketingSubsubsection"}, {
      Recurse[]
    }],

{File} :> 
  DIV[{"class" -> "file"}, { "content"}],

{Cell, "PopupCaptionText"} :> 
  XMLElement["p", {"class" -> "caption"}, {Recurse[]}],
 


{Cell, "MarketingThumbnailSection" | "MarketingThumnailSection" | "MarketingContentsSection"} :> Sequence[],
(*
{Cell, "ThumbOutput" | "ThumbnailOutput" | "ThumnailOutput"} :> 
  transmogrifyImage[ToFileName[{"HTMLImages", mainFileNameBase},
    "smallthumb_" <> IncrementCounter["Images"] <> ".gif"],
     Inline -> True, CropImage -> False],
*)
{Cell, "ContentOutput"} :> 
Module[{ext},  
	ext = Switch[GetParameter["Language"], 
	"ChineseSimplified", "zh", 
	"Japanese", "ja", 
	"Spanish", "es", 
	"Russian", "ru",
	"Korean", "ko",
	"German", "de",
	"French", "fr",
	"Portuguese", "pt-br",
	 _, "en"];
	transmogrifyImage[ToFileName[{"HTMLImages"<>"."<>ext, mainFileNameBase},
    "content_" <> IncrementCounter["Images"] <> ".gif"],
     Inline -> True, CropImage -> False, ImageFormat -> "GIF"]],

{Cell, "NotebookImage"} :> 
Module[{ext},
  ext = Switch[GetParameter["Language"], 
	"ChineseSimplified", "zh", 
	"Japanese", "ja", 
	"Spanish", "es", 
	"Russian", "ru",
	"Korean", "ko",
	"German", "de",
	"French", "fr",
	"Portuguese", "pt-br",
	 _, "en"];
  transmogrifyImage[ToFileName[{"HTMLImages"<>"."<>ext, mainFileNameBase},
    "G_" <> IncrementCounter["Graphics"] <> ".gif"],
     Inline -> True, CropImage -> False, ImageFormat -> "GIF"]],

{Cell, "AltThumbnail"} :> {},
{Cell, "AlternateThumbnail"} :> {},

{CellGroupData, "MarketingRelatedLinksSection"|"MarketingMoreAboutSection"|"MarketingSeeAlsoSection"|"MarketingRelatedFunctionsSection"|"MarketingRelatedDemonstrationsSection"} :> 
DIV[{"class"->"relatedLinks"}, {
      Recurse[First[SelectChildren[]]],
      Recurse[Rest[SelectChildren[]]]
  }],

{Cell, "MarketingRelatedLinksSection"|"MarketingMoreAboutSection"|"MarketingSeeAlsoSection"|"MarketingRelatedFunctionsSection"|"MarketingRelatedDemonstrationsSection"} :> 
  Span[{"class" -> "allCapSubHeader"}, {Recurse[]}],

{CellGroupData, "MarketingUnorderedList"} :> 
Module[{marketinglist}, XMLElement["div", {"class"->"new-in-listing"}, marketinglist = {Recurse[]}; If[Length[marketinglist] < 2, Flatten[marketinglist], Flatten[Riffle[marketinglist, {{XMLElement["span", {"class"->"special-character NonBreakingSpace"}, {XML`RawXML["&#160"]}], Img[{"src"->"/mathematica/images/red_bullet.gif","border"->"0"}], " "}}]]]]],

{Cell, "MarketingUnorderedList"} :> Sequence[],

{Cell, "MarketingRelatedLinks"|"MarketingMoreAbout"|"MarketingSeeAlso"|"MarketingRelatedDemonstrations"} :> 
XMLElement["span", {}, {Recurse[] }],

{Cell, "MarketingRelatedFunctions"} :>   Module[{}, Flatten[{XMLElement["div", {},{XML`RawXML["<!-- -->"]}], Recurse[]}]/.XMLElement["a", {a___},{b___}]:>XMLElement["a", {a, Rule["class","inlineLink"]}, {b}]],

(* Some basic styles*)
{Cell, "InlineFormula" | "InlineCode" | "FunctionTemplate"} :> 
Module[{thestyle, ext},
ext = Switch[GetParameter["Language"], 
	"ChineseSimplified", "zh", 
	"Japanese", "ja", 
	"Spanish", "es", 
	"Russian", "ru",
	"Korean", "ko",
    "German", "de",
	"French", "fr",
	"Portuguese", "pt-br",
	 _, "en"];
thestyle = GetStyle[];
Span[{}, 
  If[htmlBoxesQ[SelectSelf[]],
    {  DocumentationBuild`Utils`AddSpaces[ Recurse[] ]
      },
    { CreateDirectory[ToFileName[{"HTMLImages"<>"."<>ext, mainFileNameBase}]];
    	Export[ToFileName[{"HTMLImages"<>"."<>ext, mainFileNameBase},
         "IM_"<>IncrementCounter["IMimage"] <> ".gif"], SelectSelf[]];
        Img[{"src" -> StringJoin["HTMLImages"<>"."<>ext<>"/", mainFileNameBase, "/IM_" <> GetCounter["IMimage"] <> ".gif"], "style"->"vertical-align:middle;", "border"->"0"
            } ]
      }
    ]
  ]
],

{Cell, "InlineOutput" | "InlineMath" } :> 
Module[{thestyle, ext},
ext = Switch[GetParameter["Language"], 
	"ChineseSimplified", "zh", 
	"Japanese", "ja", 
	"Spanish", "es", 
	"Russian", "ru",
	"Korean", "ko",
	"German", "de",
	"French", "fr",
	"Portuguese", "pt-br",
	 _, "en"];
thestyle = GetStyle[];
Span[{}, 
  If[htmlBoxesQ[SelectSelf[]],
    { CreateDirectory[ToFileName[{"HTMLImages"<>"."<>ext, mainFileNameBase}]];
    	Export[ToFileName[{"HTMLImages"<>"."<>ext, mainFileNameBase},
         "IM_"<>IncrementCounter["IMimage"] <> ".gif"], SelectSelf[]];
        Img[{"src" -> StringJoin["HTMLImages"<>"."<>ext<>"/", mainFileNameBase, "/IM_" <> GetCounter["IMimage"] <> ".gif"], "style"->"vertical-align:middle;", "border"->"0"
            } ]
      },
    { CreateDirectory[ToFileName[{"HTMLImages"<>"."<>ext, mainFileNameBase}]];
    	Export[ToFileName[{"HTMLImages"<>"."<>ext, mainFileNameBase},
         "IM_"<>IncrementCounter["IMimage"] <> ".gif"], SelectSelf[]];
        Img[{"src" -> StringJoin["HTMLImages"<>"."<>ext<>"/", mainFileNameBase, "/IM_" <> GetCounter["IMimage"] <> ".gif"], "border"->"0","style"->"vertical-align:middle;"
            } ]
      }
    ]
  ]
],

(* {Cell, "WolframAlphaShortInput" | "WolframAlphaLong"} :> 
Module[{thestyle, ext},
ext = Switch[GetParameter["Language"], "ChineseSimplified", "zh", "Japanese", "ja", _, "en"];
thestyle = GetStyle[];
Span[{}, 
  If[htmlBoxesQ[SelectSelf[]],
    {  CreateDirectory[ToFileName[{"HTMLImages"<>"."<>ext, mainFileNameBase}]];
    	Export[ToFileName[{"HTMLImages"<>"."<>ext, mainFileNameBase},
         "WA_"<>IncrementCounter["WAimage"] <> ".gif"], SelectSelf[]];
        Img[{"src" -> StringJoin["HTMLImages"<>"."<>ext<>"/", mainFileNameBase, "/WA_" <> GetCounter["WAimage"] <> ".gif"]
            } ]
      },
    { CreateDirectory[ToFileName[{"HTMLImages"<>"."<>ext, mainFileNameBase}]];
    	Export[ToFileName[{"HTMLImages"<>"."<>ext, mainFileNameBase},
         "WA_"<>IncrementCounter["WAimage"] <> ".gif"], SelectSelf[]];
        Img[{"src" -> StringJoin["HTMLImages"<>"."<>ext<>"/", mainFileNameBase, "/WA_" <> GetCounter["WAimage"] <> ".gif"]
            } ]
      }
    ]
  ]
],
*)
{FormBox} :> 
Module[{boxChildren,traditionalFormQ,altTag,image,height,fudge,width, url},
	fudgeValignProp[x_]:= Module[{var,newvar},
    	var=ToExpression[x];
    	newvar=Which[
    	var<14, "-10",
    	13<var<18, "-12",
    	17<var<20, "-16",
    	19<var<23, "-22",
    	22<var<27, "-35",
    	26<var<30, "-45",
    	29<var<32, "-55",
        31<var<35, "-65",
    	True, "-75"
    ];
    newvar
    ];
	
boxChildren=SelectChildren[];
traditionalFormQ = If[GetStyle[] === TraditionalForm, True, False];
altTag = DocumentationBuild`Utils`CellToString@SelectSelf[];
(* image = BoxToImage[ToFileName[{"HTMLImages"<>"."<>ext, mainFileNameBase},
         "FB_"<>IncrementCounter["FBimage"] <> ".gif"],  "TransparentColor" -> White,
            Inline -> If[GetStyle[]===TraditionalForm, True, False], CropImage -> False];  
height = ("Height" /. #)&[image];
width = ("Width" /. #)&[image];
url = ("URL" /. #)&[image];
fudge = fudgeValignProp[height];*)
If[MatchQ[boxChildren, {"Mathematica"}],Transmogrify[StyleBox["Mathematica", FontSlant->"Italic"]],
If[MatchQ[boxChildren, {StyleBox[_, "KeyEvent", ___]}], Transmogrify[boxChildren],          
          transmogrifyImage[ToFileName[{"HTMLImages"<>"."<>ext, mainFileNameBase},
         "FB_"<>IncrementCounter["FBimage"] <> ".png"], {"style"->"vertical-align:middle;", "alt"->altTag},
         Inline -> True, CropImage -> False, ImageFormat -> "PNG", 
         TransparentBackground->True, ConversionOptions->{Background->None}
      ]
]
]
]

}, 

IncludeXMLTransforms -> {{"HTML","Components","Includes.m"}},
DefaultParameters -> { "newline2br" -> False, "newline2div" -> False}

]
