
XMLTransform[{
  {Notebook} :> Module[{cattitle, marketingnblink, marketingpagesubsectiontitle}, {Recurse[]}],
  {CellGroupData, "MarketingCategoryTitle"} :> 
   Module[{recursed }, 
   	CreateDirectory[FileNameJoin[Flatten[{FileNameSplit[GetParameter["outputDir"]],"new-in-9"}]]];
    ResetCounters["MarketingCategorySubpageSection"]; 
    IncrementCounter["MarketingCategoryTitle"]; 
    cattitle = ToString[SelectSelf[][[1, 1, 1]]]; 
    Export[FileNameJoin[Flatten[{FileNameSplit[GetParameter["outputDir"]], "new-in-9" , DocumentationBuild`Utils`titlemaker[cattitle] <> ".en.html"}]], 
     FillInLayout[
      GetParameter["layoutfile"], "Text", 
      "body" -> 
       ExportString[
        XMLElement["div", {"id" -> "mainWrap"}, {Recurse[]}], 
        "XML", "AttributeQuoting" -> "\"", 
        "Entities" -> {"\[LongDash]" -> "&mdash;"}, 
        "ElementFormatting" -> Automatic]], "Text"];
   Export[
     FileNameJoin[Flatten[{FileNameSplit[GetParameter["outputDir"]],"new-in-9" , DocumentationBuild`Utils`titlemaker[cattitle] <> ".en.html-conf"}]], 
     "SetEnv STYLE_Body '<body id=\"whatsnew\" class=\"" <> 
      "whatsnew1" <> 
      DocumentationBuild`Utils`NumberToLetter[GetCounter["MarketingCategoryTitle"]] <> "\">'", "Text"]; Sequence[]]
    ,
  {Cell, "MarketingCategoryTitle"} :> 
   Module[{}, 
    XMLElement[
     "h1", {}, {ToString[Recurse[]]}]], 
  {Cell, "MarketingCategoryTitleCaption"} :> 
   Module[{}, 
    XMLElement[
     "h1", {"class" -> "belowHeader"}, {ToString[Recurse[]]}]],
  {Cell, "Input"} :> Sequence[],
  {Cell, "MarketingNBLink"} :> Sequence[],
  {Cell, "MarketingCategoryDetail"} :> 
   XMLElement[
    "div", {"class" -> "featureDesc"}, {marketingpagesubsectiontitle, Recurse[], XMLElement[
     "div", {"class" -> "learnMore"}, {XMLElement[
     "a", {"class" -> "inlineLink", 
      "href" -> marketingnblink <> "/index.html"}, {"Learn more", XML`RawXML["&nbsp;"], XMLElement["span",{"class"->"chevron"}, { XML`RawXML["&#187;"]}]}]}]}],
  {Cell, "MarketingCategoryText"} :> 
   Module[{}, 
    XMLElement["p", {"class" -> "intro"}, {Recurse[]}]],
  {Cell, "Output"} :> 
   Module[{w, h}, 
    CreateDirectory[FileNameJoin[Flatten[{FileNameSplit[GetParameter["outputDir"]], "new-in-9","HTMLImages.en","Categories"}]]]; 
    XMLElement[
     "div", {"class" -> 
       "featureImage"}, {Export[FileNameJoin[Flatten[{FileNameSplit[GetParameter["outputDir"]], "new-in-9","HTMLImages.en","Categories","O_" <> 
          IncrementCounter["iOutput"] <> ".jpg"}]], SelectSelf[], "JPEG", ImageSize -> {{250}, {250}}];
          {w, h} = Import[FileNameJoin[Flatten[{FileNameSplit[GetParameter["outputDir"]], "new-in-9","HTMLImages.en","Categories","O_" <> 
          GetCounter["iOutput"] <> ".jpg"}]], "ImageSize"];
          Img[{"src" -> 
            "HTMLImages.en/Categories/O_" <> GetCounter["iOutput"] <> 
             ".jpg", "border"->"0", "alt"->"", "title"->"", "width" -> ToString@w, "height" -> ToString@h} ]}]
         ],
  {Cell, "MarketingCategoryDetail"} :> Sequence[],
  {CellGroupData, "FeaturedContentSection"} :> 
   Module[{}, 
    XMLElement["div", {"id" -> "main"}, {Recurse[]}]],
  {Cell, "FeaturedContentSection"} :> Sequence[],
  {CellGroupData, "MarketingCategorySubpageSection"} :> 
   Module[{}, 
   	marketingnblink=DocumentationBuild`Utils`titlemaker[
         Transmogrify`ConvertToString[
          Cases[Get[FileNameJoin[Flatten[{FileNameSplit[GetParameter["marketingpagefolder"]], ToString[Cases[SelectSelf[], Cell[nblink___, "MarketingNBLink", ___]:>nblink, Infinity][[1]]]}]]], 
            Cell[___, "MarketingTitle", ___], Infinity][[1]]]];
     marketingpagesubsectiontitle = XMLElement[
     "h3", {}, {XMLElement[
       "a", {"href" -> 
         "/mathematica/new-in-9/" <> 
          marketingnblink <> 
          "/index.html"}, {Transmogrify`ConvertToString[
          Cases[SelectSelf[], 
            Cell[___, "MarketingCategorySubpageSection", ___], Infinity][[1]]]}]}];
    CreateDirectory[
     FileNameJoin[Flatten[{FileNameSplit[GetParameter["outputDir"]], "new-in-9",marketingnblink}]]]; 
    Export[FileNameJoin[Flatten[{FileNameSplit[GetParameter["outputDir"]], "new-in-9",marketingnblink, "index.en.html-conf"}]], 
     "SetEnv STYLE_Body '<body id=\"whatsnew\" class=\"" <> 
      "whatsnew1" <> 
      DocumentationBuild`Utils`NumberToLetter[GetCounter["MarketingCategoryTitle"]] <> 
      IncrementCounter["MarketingCategorySubpageSection"] <> "\">'", 
     "Text"];
    Export[
     FileNameJoin[Flatten[{FileNameSplit[GetParameter["outputDir"]], "new-in-9",marketingnblink, "index.en.txt"}]], cattitle, "Text"];
    XMLElement["div", {"class" -> "featureCont"}, {Recurse[]}]],
  {Cell, "MarketingCategorySubpageSection"} :> Sequence[],
  {Cell, "Delimiter"} :> Sequence[],
  {Cell, "HistoryData"} :> Sequence[],
  {Cell, "History"} :> Sequence[],
  {Cell, "KeywordsSection"} :> Sequence[],
  {Cell, "Keywords"} :> Sequence[],
  {String} :> 
   Module[{stringContent, stringTest}, 
    stringContent = ReplaceSpecialCharacters[SelectSelf[]];
    stringTest[x_] := 
     Which[Head[x] === XMLElement, x, Head[x] === RawXML, x, 
      StringLength[x] === 1 && 
       StringMatchQ[x, RegularExpression["[a-z]"]], 
      XMLElement["I", {}, {x}], True, x];
    (*handle inline formatted strings...*)
    Which[InlineFormattedQ[SelectLiteral[SelectSelf[]]], 
     Transmogrify[FromInlineString[SelectSelf[]]], 
     traditionalFormQ === True, 
     Sequence @@ Map[stringTest[#] &, {stringContent}], True, 
     stringContent]]
  },
 IncludeXMLTransforms -> {{"HTML", "Components", "Includes.m"}}, 
 DefaultParameters -> {"newline2br" -> False, "newline2div" -> False}
 ]