(* :Title: Functions.m *)

(* :Author:
  Andrew Hunt, andy@wolfram.com
  Greg Martel, gregm@wolfram.com
*)

(* :Mathematica Version: 5 *)
(* :Package Version: $Revision: 1.11.2.1 $ $Date: 2016/08/16 20:55:40 $ *)                  
(* :Copyright: (c) 2005, Wolfram Research, Inc. All rights reserved. *)
(* :Summary: Add-ons specific rules and general transform for Mathematica Documentation *)

(* :Title: Functions.m *)

XMLTransform[{
{Cell, "BrighterFlag"}:> DIV[{"class"->"BrighterFlag"},{
	XMLElement["img", {"src"->"/mathematicaImages/FutureFlag.gif"}, {}]}
	],

(*{Cell, "ExampleText"} :>*)
Cell[__, "ExampleText", "TentativeExample", ___] :>
Module[{id}, 
id = If[HasOption[CellID], "id" -> ToString[GetOption[CellID]], Hold[Sequence[]]];
XMLElement["table", {}, {
	XMLElement["tr", {}, {
		XMLElement["td", {"class"->"TentativExampleTextNote"}, {StringTrim[GetOption[CellDingbat][[1]]]}],
		XMLElement["td", {}, {
	DIV[{"class" -> "TentativeExampleText", ReleaseHold[id]}, {Recurse[]}]
			}]
		}]
	}]
],

(* not changed *)
{Cell, "Notes"} :>Module[{ding,title},
	If[HasOption[CellDingbat], ding=GetOption[CellDingbat];
	Which[
        ding==="BrighterFlag", 
        		XMLElement["ul", {"class" -> ding<>"Notes"}, {XMLElement["li", {},{Recurse[]}]  }],
        MatchQ[ding, Cell[_String, "ModInfo","BrighterFlag"]],
        		XMLElement["ul", {"class" -> ding[[3]]<>"Notes"}, {XMLElement["li", {},{Recurse[]}]  }],
        MatchQ[ding, Cell[_String, "TentativeID"]], title=ding[[1]]; 
        		XMLElement["table", {"class"->"TentativeNotesTable"}, {
        			XMLElement["tr", {},{
        				XMLElement["td", {"class"->"TentativeAuthorCol"}, {StringTrim[title]}],
        				XMLElement["td", {"class"->"TentativeTextCol"}, {Recurse[]}],
        				XMLElement["td", {"class"->"TentativeBracketCol"}, {" "}]
        				}]
        			}],
        True, 
        		XMLElement["ul", {"class"->"Notes"}, {XMLElement["li", {},{Recurse[]}]}]
        		],
 
  XMLElement["ul", {Which[
        HasOption[Background], 
          If[MatchQ[ GetOption[Background], _Dynamic],
           Sequence@@{"class" -> "Notes", "id"->"ModInfo_6", "name"->"ModInfo_6"}, 
          "class" -> "Notes"], 
        HasOption[CellDingbat], Which[
        	GetOption[CellDingbat]==="BrighterFlag",
        		"class" -> GetOption[CellDingbat][[3]]<>"Notes",
        	True, "class"->"Notes"
        		],
        True, "class" -> "Notes"]}, {
      XMLElement["li", {}, {Recurse[]}] 
  }]
]
], 

(* TODO USe popup info as alt/title tags? *)
(* TODO test for links & add a/link wrapper if positive test. *)
{Cell, "FlushInput" | "Input" | "InputOnly"} :>  
Module[
  {
    iId = StringJoin["i_", IncrementCounter["iInner"]],
    iInner, iOuter, inputForm, inputFormQueue, IsManipulate, isManipulate, id, urlOrig, urlEncoded,
(*inputVals,base,inBase,*)  celtag, dingbat, ding
  },
 
IsManipulate = GetParameter["IsManipulate"];
 dingbat=GetOption[CellDingbat];
  	ding=If[dingbat===None,None,dingbat[[2]]
  	];
iInner = StringJoin[iId, "_in"];
iOuter = StringJoin[iId, "_out"];
inputForm = CreateInputForm[ SelectSelf[] ];
preservedInputForm = inputForm;
inputForm = If[Head@inputForm === String, inputForm, ToString@inputForm];
inputFormQueue = inputQueue[inputForm, GetOption[CellLabel]];
celtag = If[HasOption[CellTags], GetOption[CellTags],
False];


isManipulate = If[IsManipulate===True, 
(DocumentationBuild`Utils`IsManipulateQ[ SelectLiteral[SelectSelf[] ]] (*&& GetParameter["entityType"] === "Symbol"*)  ),
False];

id = If[HasOption[CellID], "#"<>ToString@GetOption[CellID], ""];
urlOrig = "http://reference.wolfram.com/language/" <> GetParameter["url"] <> ".html" <> id;
urlEncoded = If[StringQ[urlOrig], Pubs`ShortenURL@urlOrig, ""];

Sequence@@{  
(*XMLElement["table", {"class" -> "InCell"},  {  *)
XMLElement["table", {"class" -> If[celtag==="ErrorCellBracket","InCellBracket","InCell"], "id"->If[ding==="TentativeID", "TentativeExample", ""]},  {  
    XMLElement["tr", {}, {
(* add tentative ID if tentative example *)
If[ding==="TentativeID",XMLElement["td", {"class" -> "lab"}, {StringTrim[dingbat[[1]]]}],""],
      (* cell label <td> *)
      XMLElement["td", {"class" -> "lab" (* , ""-""<> *)}, 
Sequence@@{
     If[HasOption[CellTags],
       Flatten[ {   Map[
      (XMLElement["a", {"name" -> #}, {}])&, Flatten[{GetOption[CellTags]}]  
             ], 
        If[HasOption[CellLabel],
          (* fill it with the CellLabel text *)
          { XMLElement["a", {
"name" -> "inoutlink", "href" -> "javascript:input('" <> iId <> "')" , "onmouseover" -> "javascript:return(true);"
            }, {GetOption[CellLabel]} ] }
          ,
          (* otherwise it's empty *)
          {}
        ] (* end If *)
               }],  

        If[HasOption[CellLabel],
          (* fill it with the CellLabel text *)
          { XMLElement["a", {
"name" -> "inoutlink", "href" -> "javascript:input('" <> iId <> "')" , "onmouseover" -> "javascript:return(true);"
            }, {GetOption[CellLabel]} ] }
          ,
          (* otherwise it's empty *)
          {}
        ] (* end If *)

  ] 
}   (*  end sequence  *)
], (* end cell label <td> *) 
    
      (* input <td> *)
XMLElement["td", {"class" -> "Input"},
	 {

  (* hidden input layer *)
  DIV[{}, {XMLElement["a", { "href" -> "javascript:input('" <> iId <> "')" , "onmouseover" -> "javascript:return(true);"}, {
  (* Check for Manipulate *) 
    If[isManipulate, 
    ( 
    (*Print["<"<>GetFileNameBase[] <> ": Manipulate Input cell>"]; *)
    (* Do something with Input Manipulate? *)
    transmogrifyImage[ToFileName[{"Files", GetFileNameBase[]}, 
          "I_" <> IncrementCounter["iInner"] <> ".gif"],
          { "alt" -> "Click for copyable input" },
          Inline -> True, CropImage -> False
      ]
      ), 
    ( 
    transmogrifyImage[ToFileName[{"Files", GetFileNameBase[]}, 
          "I_" <> IncrementCounter["iInner"] <> ".gif"],
      {"alt" -> "Click for copyable input" },
          Inline -> True, CropImage -> False
     ]
    )
    ]
  }] }], (* end <div><a> *) 
  Module[{str},
    str = StringJoin @@ Map[ExportString[#, "XML"]&, {
      XMLElement["pre", {"name" -> iInner,  "id" -> iInner,  "class"->"IFT" }, {inputFormQueue}],
      DIV[{"class"->"IFU" }, { urlEncoded }]
    }];
    CreateDirectory[ToFileName[{"Files", GetFileNameBase[]}]];
    Export[
      ToFileName[{"Files", GetFileNameBase[]}, iId<>".txt"],
      str, "Text"];    
    DIV[{"name" -> iOuter, "id" -> iOuter, "class"->"IFL"}, {""}]
  ]
  }], (* end <td> *) 
  If[celtag==="ErrorCellBracket", XMLElement["td", {"class" -> "RedCellBracket"}, {}], Unevaluated@Sequence[]]
  }] (* end <tr> *) 

}] (* end <table> *)

  }   
],(* end WithParameters *)
    



(** 
  Output Cells
  right now turn all output cells into images.
**)

(* TODO USe Brendan's code alt/title tags? *)
(* TODO test for links & add a/link wrapper if positive test. *)
{Cell, "Output" | "OutputOnly"} :> 
Module[{outCell, IsManipulate, isManipulate, isSound, isSoundNote, soundPath, soundID, soundExpr, manipulateExpr, manipulatetiming, ret, val, outputVals, outBase, multipleSWFQ},

outCell = SelectLiteral[SelectSelf[] ];
IsManipulate = GetParameter["IsManipulate"];
multipleSWFQ = If[StringLength@preservedInputForm > 9, 
TrueQ[StringTake[preservedInputForm,10]==="Manipulate"], 
False];

isManipulate = If[IsManipulate===True, 
(DocumentationBuild`Utils`IsManipulateQ[ outCell] && (*GetParameter["entityType"] === "Symbol" &&*) multipleSWFQ),
False];

isSound = DocumentationBuild`Utils`IsSoundQ[ outCell];
isSoundNote = !FreeQ[ outCell, _SoundNote];

(* Use ImageList[...] to obtain Baseline value *)
(* TODO *)
(*
outputVals=First@Cases[ImageList[
      BoxToImage[ToFileName[{"Files", GetFileNameBase[]},
    "Box_" <> IncrementCounter["Inline"] <> ".gif"],
    Inline -> True, CropImage -> False]
], _];
outBase=StringDrop[Cases[outputVals, "Baseline"~(Rule|RuleDelayed)~x_ -> x], -1];
*)
If[
(*  HasOption[CellLabel] && StringMatchQ[GetOption[CellLabel], "*Form*"],  *)
    HasOption[CellLabel] && StringMatchQ[GetOption[CellLabel], "*Form*" |"*Short*"],


  (* handle //*Form output *)
  XMLElement["table", {"class"->"OCell"}, {
    XMLElement["tr", {}, {
      XMLElement["td", {"colspan" -> "2"}, {
      (* this extra span just snags the inline styles from the celllabel
         block styles. width is overridden in the colspan="2" attribute *)
        XMLElement["div",{"class"->"celllabelTableForm"},
          If[ HasOption[CellLabel], {GetOption[CellLabel]}, {} ]
        ]
      }] 
  }], (* end tr  *)
  
  XMLElement["tr", {}, {
      (* empty td for fixed width *)
    XMLElement["td", {"class" -> "lab"}, {" "}],
        XMLElement["td", {"class" -> "Output"}, { 
        (
            If[MemberQ[{"SQLColumnInformation", "SupportedDataTypes", "SQLTableInformation", "SQLDataTypeInformation"}, StringDrop[GetFileNameBase[], -3]], 
            	Module[{imageName, imageExport, imageSizes, xportInfo},
            		imageName = ToFileName[{"Files", GetFileNameBase[]},
            "O_" <> IncrementCounter["iOutput"] <> ".gif"];  
            
                    xportInfo = System`ConvertersDump`ToRasterDataPacket[Evaluate[DeleteCases[Transmogrify`Private`mangleCell[SelectSelf[], True], Rule[GridBoxOptions, __], Infinity]], "GIF"];
                    imageExport =
                    Export[imageName, System`ConvertersDump`FromRasterDataPacket[ReplacePart[xportInfo, Take[xportInfo[[3]], All, Min[550, Dimensions[xportInfo[[3]]][[2]]]], 3]], "GIF"];
                    imageSizes = Import[ToFileName[{Directory[]}, imageName], "ImageSize"];
              
            	XMLElement["img", {
            "src" -> StringReplace[imageName, {"\\"->"/"}], "width" -> ToString@First@imageSizes, 
            "height" -> ToString@Last@imageSizes, "alt" -> ""
          }, {}]
            
          ], 
           XMLElement["img", {
            "src" -> ("URL" /. #), "width" -> ("Width" /. #), 
            "height" -> ("Height" /. #), "alt" -> ""
          }, {}]&[
           BoxToImage[ToFileName[{"Files", GetFileNameBase[]},
              "O_" <> IncrementCounter["iOutput"] <> ".gif"],
            Inline -> True, MaxImageSize->580, CropImage -> False]
            
          ] ]
    )
      }] (*  close td *)
    }] (*  close tr *)
  }] (*  close table *)
  ,

  (* otherwise handle normal output *)
  XMLElement["table", {"class"->"OCell"}, {
  XMLElement["tr", {}, {
      (* cell label <td> *)
      XMLElement["td", {"class" -> "lab"}, 
        If[HasOption[CellLabel],
          (* fill it with the CellLabel text *)
          {GetOption[CellLabel]}
          ,
          (* otherwise it's empty *)
          {}
        ] (* end If *)
      ], (* end cell label <td> *)


      XMLElement["td", {"class" -> "Output"}, {

        Which[
          isManipulate, (
            (*Print["<" <> GetFileNameBase[] <> ": Manipulate Output cell>"];*) 
            flashID = "Flash_" <> IncrementCounter["flash"];
            swfPath = StringReplace[ToFileName[{"Files", GetFileNameBase[]}, flashID <> ".swf"],  {"\\" -> "/"}];
            opts = {"ShowControls" -> True, "ControlAppearance" -> Automatic,  "AnimationParameters"->Hold[val] };
            manipulateExpr = ReleaseHold@MakeExpression[First@SelectLiteral[SelectChildren[]], StandardForm];
If[cache,
	AntLog["caching is set"]; 
  If[ToString[
   Quiet[Import[
     "http://reference.devel2.wolfram.com/language/cache/" <> 
      ToString[Hash[manipulateExpr, "MD5"]] <> "_" <> 
      ToString[
       Hash[SystemInformation["Kernel", "ReleaseID"], "MD5"]] <> 
      ".swf", "Byte"]]] === "$Failed", 
 manipulatetiming=AbsoluteTiming[ret = Export[swfPath, manipulateExpr, Sequence @@ opts]];
 AntLog["Manipulate conversion time: "<>ToString[manipulatetiming]];
 CreateDirectory[FileNameJoin[Flatten[{FileNameSplit[cachelocation], "cache"}]]]; 
 CopyFile[ret, FileNameJoin[Flatten[{FileNameSplit[cachelocation], "cache", ToString[Hash[manipulateExpr, "MD5"]] <> "_" <> 
     ToString[Hash[SystemInformation["Kernel", "ReleaseID"], "MD5"]] <>
      ".swf"}]]];
      Export[FileNameJoin[Flatten[{FileNameSplit[cachelocation], "cache", ToString[Hash[manipulateExpr, "MD5"]] <> "_" <> 
     ToString[Hash[SystemInformation["Kernel", "ReleaseID"], "MD5"]] <>
      ".swf.txt"}]], ImageSize /. val, "CSV"];
      {width, height} = ImageSize /. val;
      AntLog["cached in cache folder"];
      ,
      AntLog["using cached swf from devel2"]; 
 ret = Export[swfPath, 
  Import["http://reference.devel2.wolfram.com/language/cache/" <> 
    ToString[Hash[manipulateExpr, "MD5"]] <> "_" <> 
    ToString[Hash[SystemInformation["Kernel", "ReleaseID"], "MD5"]] <>
     ".swf", "Byte"], "Byte"];
     {width, height} = Import["http://reference.devel2.wolfram.com/language/cache/" <> 
    ToString[Hash[manipulateExpr, "MD5"]] <> "_" <> 
    ToString[Hash[SystemInformation["Kernel", "ReleaseID"], "MD5"]] <>
     ".swf.txt", "CSV"];
     ], 
     ret = Export[swfPath, manipulateExpr, Sequence @@ opts];
     ];
     
            A[{"href"->"javascript:swap(this," <> ToString[width] <> "," <> ToString[height] <> ",'" <> swfPath <> "', '" <> flashID <> "')"}, {
	          Span[{"class" -> "playAnimation"}, {"Play Animation"}],
              DIV[{"id"->flashID}, {
                transmogrifyImage[ToFileName[{"Files", GetFileNameBase[]},
                  IncrementCounter["Image"] <> ".gif"],
                  Inline -> True, CropImage -> False
            ]}]}] ), 
          isSoundNote, (
            (*Print["<" <> GetFileNameBase[] <> ": SoundNote Output cell>"]; *)
            soundID = "SoundNote_" <> IncrementCounter["soundnote"];
            soundPath = StringReplace[ToFileName[{"Files", GetFileNameBase[]}, soundID <> ".mid"],  {"\\" -> "/"}];
            If[Length[Cases[First@outCell, _Sound, Infinity]]===1,
            soundExpr = First@Cases[outCell, _Sound, Infinity];
            ret = Export[soundPath, soundExpr];
            A[{"href"->soundPath}, {
              XMLElement["div", {"id"->soundID}, {
                transmogrifyImage[ToFileName[{"Files", GetFileNameBase[]},
                  IncrementCounter["Image"] <> ".gif"],
                  Inline -> True, CropImage -> False
            ]}]}], XMLElement["div", {"id"->soundID}, {
                transmogrifyImage[ToFileName[{"Files", GetFileNameBase[]},
                  IncrementCounter["Image"] <> ".gif"],
                  Inline -> True, CropImage -> False
            ]}]
            ] ), 
          isSound, (
            (*Print["<" <> GetFileNameBase[] <> ": Sound Output cell>"]; *)
            soundID = "Sound_" <> IncrementCounter["sound"];
            soundPath = StringReplace[ToFileName[{"Files", GetFileNameBase[]}, soundID <> ".wav"],  {"\\" -> "/"}];
            Which[StringDrop[GetFileNameBase[], -3]==="Music",
            	XMLElement["div", {"id"->soundID}, {
                transmogrifyImage[ToFileName[{"Files", GetFileNameBase[]},
                  IncrementCounter["Image"] <> ".gif"],
                  Inline -> True, CropImage -> False
            ]}],Length[Cases[First@outCell, _Sound, Infinity]]===1,
            soundExpr=Sound@@Cases[First@outCell, _Sound, Infinity];
            Quiet[ret = Export[soundPath, soundExpr]];
            A[{"href"->soundPath}, {
              XMLElement["div", {"id"->soundID}, {
                transmogrifyImage[ToFileName[{"Files", GetFileNameBase[]},
                  IncrementCounter["Image"] <> ".gif"],
                  Inline -> True, CropImage -> False
            ]}]}],
            	(* Length@Cases[outCell, CompressedData[a__], Infinity]>0, Last@Cases[outCell, _Sound, Infinity],*)
             True, XMLElement["div", {"id"->soundID}, {
                transmogrifyImage[ToFileName[{"Files", GetFileNameBase[]},
                  IncrementCounter["Image"] <> ".gif"],
                  Inline -> True, CropImage -> False
            ]}]
             ]
             ), 
          True, (
            transmogrifyImage[ToFileName[{"Files", GetFileNameBase[]},
              "O_" <> IncrementCounter["iOutput"] <> ".gif"], {"alt"->""},
              Inline -> True, MaxImageSize->580, CropImage -> False] )
       ] 

    }] (* end Output <td> *)

    }] (*  close tr  *)  
  }] (*  close table  *) 
] ],(* end "Output" rule *)


{Cell, "NotebookImage"} :> 
Span[{"class"->"NotebookImage"}, {
  transmogrifyImage[ToFileName[{"Files", GetFileNameBase[]},
   IncrementCounter["Image"] <> ".gif"],
   Inline -> True
  ]
}],

{Cell, "PackageHeader"} :> Unevaluated[Sequence[]],

{Cell, "ObjectNameGrid"} :>  Block[{objgrid = True}, 
If[MemberQ[exceptionsList, GetParameter["entityType"] ],
  DIV[{"class" -> "FlShdBar"}, {
  DIV[{"id" -> "CntTabMid", "class"->$LanguageExtension}, {
  DIV[{"class"->"ObjectNameGrid"}, {Recurse[]}] 
  }]
  }],
   DIV[{"class"->"ObjectNameGrid"}, {Recurse[]}]   ]
  ],
  


{Cell, "ObjectName" | "ObjectNameSmall" | "ObjectNameAlt"} :> 
 ( 
 If[MemberQ[exceptionsList, GetParameter["entityType"] ] &&
 	GetStyle@SelectNearestAncestor[_Cell] =!= "ObjectNameGrid",
	DIV[{"class" -> "FlShdBar"}, { 
		DIV[{"id" -> "CntTabMid", "class"->$LanguageExtension}, { 
			H1[{"class"->"ObjectName"}, {Recurse[]}] 
		}] 
	}],  

	H1[{"class"->"ObjectName"}, {Recurse[]}] 
 ] ),

  
(* HowTo styles *)
{Cell, "HowToTitle"} :> DIV[{"class" -> GetStyle[]}, {Recurse[]}],
{Cell, "HowToTitlePrefix"} :> Span[{"class" -> GetStyle[]}, {Recurse[], 
	Span[{"class"->GetStyle[]<>"Sep"}, {" |"}]
	}],
{Cell, "HowToAbstract"} :> DIV[{"class" -> GetStyle[]}, {
  If[Head[First[SelectSelf[]]] === BoxData,
    Module[{grid},
      grid = SelectNearestDescendants[GridBox];
      XMLElement["table", {}, {XMLElement["tr", {}, {
        XMLElement["td", {"class" -> "HowToAbstract"}, {
          Recurse[grid[[1, 1, 1, 1]]]
        }],
        XMLElement["td", {"class" -> "HowToScreencastLink"}, {
          Recurse[grid[[1, 1, 1, 2]]]
        }]
      }] }]
    ],
    Recurse[]
  ]
}],
{Cell, "HowToScreencastLink"} :> Module[{iconText,iconSource,bdata,h="100px",w="100px"},
  iconSource = "/mathematicaImages/ScreencastLink.png";
  iconText = Cases[SelectSelf[], StyleBox[a_String, "HowToScreencastLink"]->a, Infinity];
  bdata = First[Cases[SelectSelf[], (ButtonData->{URL[bbdd_], _}) :> bbdd, Infinity, 1]];
  DIV[{"class" -> GetStyle[]}, {
    A[{"href" -> bdata, "class"->"HowToIconGroup"}, {
      DIV[{"class" -> "HowToIconGroup"}, {
        DIV[{"class" -> "HowToIcon"}, {XMLElement["img", {"src"->iconSource(*,"height"->h,"weight"->w*)}, {}]}],
        DIV[{"class" -> "HowToIconText"}, {Transmogrify[iconText]}]
      }], 
      Recurse[]
    }]
  }]
],

  
{Cell, "History"} :>  
If[MemberQ[exceptionsList, GetParameter["entityType"] ],
  DIV[{"class" -> "FlShdBar"}, {
  DIV[{"id" -> "CntTabMid", "class"->$LanguageExtension}, {
  DIV[{"class"->"History"}, {Recurse[]}] 
  }]
  }], 
  
  DIV[{"class"->"History"}, {Recurse[]}]   
  ],
  
  
 {Cell, "AwaitingReviewNote"} :>  
If[MemberQ[exceptionsList, GetParameter["entityType"] ],
  DIV[{"class" -> "FlShdBar"}, {
  DIV[{"id" -> "CntTabMid", "class"->$LanguageExtension}, {
  DIV[{"class"->GetStyle[]}, {Recurse[]}] 
  }]
  }], 
  
  DIV[{"class"->GetStyle[]}, {Recurse[]}]   
  ],


{CellGroupData, "CharacterImage"}:> 
Block[{CharacterImageData},
CharacterImageData = Recurse[];
Sequence@@{  
		First[Rest[{CharacterImageData}]], 
		DIV[	{"class" -> "CharacterUsageTable"}, {
		XMLElement["table", {}, { 	
			XMLElement["tr", {}, { 			
				XMLElement["td", {"class" -> "CharacterImageLeft"}, {First[{CharacterImageData}]}  ], 	
				XMLElement["td", {"class" -> "CharacterImageRight"}, {
					DIV[ {"class" -> "CharacterUsageList"}, {Sequence@@Rest[Rest[{CharacterImageData}]]} ]
				} ]   		
			}]    	
		}]   
	}]   
} ],   


(* TODO find way to get Alt/Title tags here. Cell2String does not work for this *)
{Cell, "CharacterImage"}:> 
transmogrifyImage[ToFileName[{"Files", GetFileNameBase[]},
  IncrementCounter["Image"] <> ".gif"], {"alt"->" ", "title"->" "},
  Inline -> True, CropImage -> True
], 


{Cell, "CharacterName"}:> 	
H1[{"class" -> "CharacterObjectName"}, {Recurse[]} ],
 



{Cell, "1ColumnTableMod" | "2ColumnTable" | "3ColumnTable" | "2ColumnTableMod" | "3ColumnTableMod" | "3ColumnIllustratedTableMod"} :>
DIV[ {"class" -> "FunctionTable", "name" -> (GetStyle[]/.None->"FIXME"),
 "id" -> StringReplace[ToString[(GetStyle[]/.None->"FIXME")], {"1"->"One", "2"->"Two", "3"->"Three", "4"->"Four", "5"->"Five", "6"->"Six"}]}, 
  {Recurse[]}
], 


{Cell,  "AlphabeticalListingTable"} :>
P[ {"class" -> "MathTable", "name" -> (GetStyle[]/.None->"FIXME")}, 
  {Recurse[]}
], 


(***** Cell Definitions *****)

{Cell, "Usage"} :> (
usageContent := DIV[{"id" -> "UT"},
Block[{usagegrid = True},
    Module[{xml = {Recurse[]}, pos, repl, first = True, versionNumber},
    versionNumber = StringSplit[$Version, "."][[1]];
    pos = Position[xml, XMLElement["tr", _, _], Infinity];
    repl = Map[
        Module[{tr, attr, children, modinfo},
            tr = Extract[xml, #];
            modinfo = False;
            modinfo = MatchQ[tr[[3, 1]],
                XMLElement["td", _, {
                    XMLElement["span", {___, "id"->"ModInfo_"<>versionNumber, ___}, _] }] ];
            attr = Join[
                DeleteCases[tr[[2]], _["name"|"id", _]],
                If[modinfo, {"name"->"ModInfo_"<>versionNumber, "id"->"ModInfo_"<>versionNumber}, {}] ];
            If[first,
                first = False,
                attr = Join[
                    DeleteCases[attr, _["class", _]],
                    {"class" -> ("class" /. attr /. {"class" -> ""}) <> " lineAbove"}]];
            children = Map[
                Function[{td}, Module[{attr},
                    attr = td[[2]];
                    If[MatchQ[attr, {___, "class" -> _, ___}],
                        attr = ReplaceAll[attr, _["class", _] -> ("class" -> "UM")],
                        attr = Join[attr, {"class" -> "UM"}]];
                    attr = Join[
                        DeleteCases[attr, _["name"|"id", _]],
                        If[modinfo, {"name"->"ModInfo_"<>versionNumber, "id"->"ModInfo_"<>versionNumber}, {}] ];
                    XMLElement["td", attr, td[[3]]]
                ]],
                Rest[tr[[3]]] ];
            (# -> XMLElement["tr", attr, children])
        ]&,
        pos];
    ReplacePart[xml, repl] ]]
];

If[MemberQ[exceptionsList, GetParameter["entityType"] ],
(* If[GetParameter["entityType"]==="Symbol",  *)

DIV[{"class" -> "FlShdBar"}, {
	DIV[{"id" -> "CntTabMid", "class"->$LanguageExtension}, {usageContent}]
}],

usageContent ]
), 




{CellGroupData, "MoreAboutSection" | "UsageSection" | "NotesSection" | "SeeAlsoSection"  | "TutorialsSection" | "RelatedLinksSection" | 
"LegacyMaterialSection" | "ApplicationNotesSection" | "DesignDiscussionSection" | "ExtensionsSection" | "RelatedDemonstrationsSection" | 
"ElementsSection" | "ImportExportSection" | "NotebookInterfaceSection" | "DesignDiscussionSection" | 
"OptionsSection"} :> 
Module[{name, style, ex, sectionContents},
style = GetStyle[];
Which[ 
style === "ElementsSection", name = "ELMS",  
style === "ExtensionsSection", name = "EXTS",  
True, name = StringJoin@Flatten@{If[First@ToCharacterCode[#] < 91, #, ""] & /@ Characters[ GetStyle[] ]};
];
ex = If[MemberQ[{"NotesSection", "ImportExportSection", "NotebookInterfaceSection", "ElementsSection", "OptionsSection"}, style], "_Co", "_Ex"];

sectionContents := DIV[{"class" -> name<>ex, "id" -> name}, {
Transmogrify[First[SelectChildren[]]],
DIV[{"class" -> name, "name" -> name<>"G", "id" -> name<>"G" },{
  Transmogrify[Rest[SelectChildren[]]] }]
}] 
;
If[MemberQ[exceptionsList, GetParameter["entityType"] ],
DIV[{"class" -> "FlShdBar"}, {
DIV[{"id" -> "CntTabMid", "class"->$LanguageExtension}, {sectionContents}]
}],
sectionContents ]
],  



{Cell, "MoreAboutSection" | "UsageSection" | "NotesSection" | "SeeAlsoSection"  | "TutorialsSection" | "RelatedLinksSection" | 
"LegacyMaterialSection" | "ApplicationNotesSection" | "DesignDiscussionSection" | "ExtensionsSection" | 
"ElementsSection" | "ImportExportSection" | "NotebookInterfaceSection" | "DesignDiscussionSection" | 
"OptionsSection"
} :> 
Module[{name, style, ex, versionNumber},
versionNumber = StringSplit[$Version, "."][[1]];
style = GetStyle[];
Which[ style === "ElementsSection", name = "ELMS",  
style === "ExtensionsSection", name = "EXTS",  
True, name = StringJoin@Flatten@{If[First@ToCharacterCode[#] < 91, #, ""] & /@ Characters[ GetStyle[] ]};
];
ex = If[MemberQ[
  {"NotesSection", "ImportExportSection", "NotebookInterfaceSection", "ElementsSection", "OptionsSection"},
  style], "closed", "open"];
A[{"name" -> GetStyle[] }, {
  DIV[ 
  	If[name==="NS",{"class" -> name<>"H", "id"->"ModInfo_"<>versionNumber, "name"->"ModInfo_"<>versionNumber},{"class" -> name<>"H" }]
  	, {
    A[{"href" -> ("javascript:toggle('" <> name <> "')"), "onmouseover" -> "javascript:return(true);" }, {
    Img[{"src"->(GetParameter["htmlBase"]<>"/mathematicaImages/"<>ex<>"SectionGroup.gif"), "id"->name<>"_", "border"->"0", "width"->"8", "height"->"8", "alt"->""}], 
      " ",
      Span[{"class"->name<>"Span"}, { Recurse[] }]
    }]
  }]
}] ],




(* for some reason <p class="ExampleDelimiter" /> doesn't bode well with browsers.
   therefore, I have added a " " *)
Cell[_, "ExampleDelimiter", "TentativeExample", ___] :> 
DIV[{"class"->"TentativeExLine"}, {
DIV[{"class" -> "ExLine"}, {XML`RawXML["&nbsp;"]}]
}],

{Cell, "ExampleDelimiter"} :> 
DIV[{"class" -> "ExLine"}, {XML`RawXML["&nbsp;"]}],

{Cell, "ExampleDelimiterInput"} :> 
DIV[{"class" -> "ExLineI"}, {XML`RawXML["&nbsp;"]}],
  


{Cell, "MoreAbout" | "Tutorials" | "RelatedDemonstrations" | "RelatedLinks" | "LegacyMaterial" | "ApplicationNotes" | "DesignDiscussion" | "Extensions"} :> 
  UL[{"class"->"IndentedNote"}, {
    Li[{Recurse[]}]
  }],

(* Scale picture smaller *)
(* TODO find more suitable alt & title tags for GraphicsData and RawData *)
{Cell, "Picture"} :> 
transmogrifyImage[ToFileName[{"Files", GetFileNameBase[]},
    IncrementCounter["Image"] <> ".gif"],
  {
  "src" -> GetParameter["linkTrailPath"] <> ("URL" /. #),
  "width" -> ToString[Floor[.89 ToExpression["Width" /. #]]],
  "height" -> ToString[Floor[.89 ToExpression["Height" /. #]]], 
  "alt" -> " ", 
  "title" -> " "
  },
  Inline -> True
], 
  


{Cell, "FlushInput"} :>
  WithParameters[{"newline2br" -> True},
    XMLElement["p", {"class" -> "StandardForm", "id" -> GetStyle[]}, {
      XMLElement["b", {}, {Recurse[]}]}
      ] ],


(* Change bullets between 'see also' items *)

{StyleBox, "InlineSeparator"} :> 
  Span[{"class" -> "inlineSeparator"}, {
    Img[{"src" -> GetParameter["htmlBase"]<>"/mathematicaImages/bullet.gif", "style"->"vertical-align:middle;", "width"->"4", "height"->"4", "alt"->"bullet", "title"->"bullet"}] }],

{Cell, "SeeAlso"} :> 
  UL[{"class"->"SeeAlso"}, {
    Li[{ Recurse[]} ]
  }],
   

{FormBox} :> Module[{boxChildren,traditionalFormQ,altTag},
boxChildren=SelectChildren[];
traditionalFormQ = If[GetStyle[] === TraditionalForm, True, False];
altTag = DocumentationBuild`Utils`CellToString@SelectSelf[];
If[MatchQ[boxChildren, {"Mathematica"}],Transmogrify[StyleBox["Mathematica", FontSlant->"Italic"]],
If[MatchQ[boxChildren, {StyleBox[_, "KeyEvent", ___]}], Transmogrify[boxChildren],
transmogrifyImage[ToFileName[{"Files", GetFileNameBase[]},
  IncrementCounter["Image"] <> ".gif"], {"style"->"vertical-align:middle;", "alt"->altTag, "title"->altTag}, "TransparentColor" -> White, 
  Inline -> If[GetStyle[]===TraditionalForm, True, False]
]
]
]
],

 
(* TODO find more suitable alt & title tags for GraphicsData and RawData *)
{GraphicsData | RawData} :>  
transmogrifyImage[ToFileName[{"Files", GetFileNameBase[]},
  IncrementCounter["Image"] <> ".gif"], {"alt" -> "", "title" -> ""},
  Inline -> True
],


{OutputFormData} :> Transmogrify[SelectChildren[][[2]]]  

},

IncludeXMLTransforms -> {{"HTML","Components","Includes.m"}},

DefaultParameters -> {
  (*  "newline2br" -> False,  *)
  "newline2br" -> False,
  "newline2div" -> False,
  "styleUsageMessageBreak" -> "</div>\n<div class=\"usageDelimiter\" > </div><div class=\"UM\">",


  (* No Operation code *)
  "noop" -> {
    $CreateCompleteHTMLFile = False;
    $LanguageExtension := Switch[GetParameter["language"], "Japanese", "ja", "ChineseSimplified", "zh",  "Spanish", "es", _, "en"];
(* exceptionsList:= {True}, *)
    exceptionsList:= {"Symbol", "Menu Item", "File", "System Program", "Front End Object", "LibraryLink C Function","MathLink C Function", "System Program", "Widget", "Message"}; 
  }
},

CounterReassignments -> {{"Chapter", "Section"}, {"Section", "Subsection"}, {"Subsection", "Subsubsection"}}

]