(* :Title: FAQ.m *)

(* :Author:
  Brendan Elli, brendane@wolfram.com
  Greg Martel, gregm@wolfram.com
*)

(* :Mathematica Version: 6 *)
(* :Package Version: $Revision: 1.1 $ $Date: 2008/03/14 00:08:52 $ *)                  
(* :Copyright: (c) 2005, Wolfram Research, Inc. All rights reserved. *)
(* :Summary: Complete transform for Tech Support FAQ*)

XMLTransform[{

   {Notebook}:> (
Print["Notebook"];
Recurse[]),

   {CellGroupData,"Subsection"}:> 
		(Print["SubsectionCellGroup"];
			Print[htmlfile<>"-info"];Export[htmlfile<>"-info", pmetadata, "Table"]),  

 (*  {CellGroupData,"Subsection"}:> 
	Module[{metadata, pmetadata},
Print["SubsectionCellGroup"];
		metadata = List[Recurse[]] //.  {XMLElement["i", {}, {a_String}] -> a};  
		pmetadata = metadata //. {
			XMLElement["h2", {}, {x_String}] -> x <> "\r",
		     {XMLElement["h3", {}, {x_}], XMLElement["p", {}, {y_}]}->
						x <> ": "  <> y <> "\r"}; 
		(Print[htmlfile<>"-info"];Export[htmlfile<>"-info", pmetadata, "Table"])
	],   *)


     {CellGroupData,"Subsubsection"}:> (
Print["SubsubsectionCellGroup"];
List[Recurse[]]),



    {CellGroupData,"Title"}:> (
      Print["Title"];
      Print[htmlfile<>"-head"];
      Export[htmlfile<>"-head",Transmogrify[SelectDescendants[{Cell,"Title"}]], "XML"];
      Print[htmlfile];
        Export[htmlfile,XMLElement["body", {},{Recurse[]}], "XML"]),  


    {Cell,"AddToDocumentation"}:> XMLElement["p",{Print["AddToDocumentation"];},{Recurse[]}],

    {Cell,"BlockQuote"}:> XMLElement["p",{Print["BlockQuote"];},{Recurse[]}],

    {Cell,"TSNumberedItem"}:> XMLElement["p",{"class"->"TSNumberedItem"},{Recurse[]}],

    {Cell,"Descriptor"}:> XMLElement["p", {"class" -> "Descriptor"}, {Recurse[]}],

    {Cell,"FileDownloads"}:> XMLElement["p", {"class" -> "FileDownloads"}, {Recurse[]}],

    {Cell,"Graphics"}:> XMLElement["img",
	{gif=MathLink`CallFrontEnd[ExportPacket[SelectSelf[],"GIF",imagefile<>IncrementCounter["image"]<>".gif"]]; 	dim=gif[[2,2]]-gif[[2,1]]; "src"->imagefile<>GetCounter["image"]<>".gif", 
	"width"->ToString[IntegerPart[dim[[1]]]] ,
	"height"->ToString[IntegerPart[dim[[2]]]]},{}],

    {Cell,"IndexTitleBar"}:> XMLElement["p",{},{Recurse[]}],

    {Cell,"Input" | "Output"}:> Sequence@@{
	XMLElement["table",{"class"->"InputCell"},{
		XMLElement["tr",{},{
		XMLElement["td",{"class"->"celllabel"},
			If[HasOption[CellLabel],{GetOption[CellLabel]},{" "}] ],
			TD[{"class"->GetOption[Style]},{
				(XMLElement["img",{"src"->("URL"/.#),"width"->("Width"/.#),"height"->("Height"/.#),"alt"->" "},{}]&[BoxToImage[ToFileName[{"HTMLImages",GetFileNameBase[]},GetFileNameBase[]<>"_i_"<>IncrementCounter["Input"]<>".gif"],Inline->True]])}]
		 }]  
}] },

    {Cell,"InternalNotes"}:> XMLElement["p", {"class" -> "InternalNotes"}, {Recurse[]}],

    {Cell,"Keywords"}:> XMLElement["p", {"class" -> "Keywords"},  {Recurse[]}],

    {Cell,"ModificationHistory"}:> XMLElement["p", {"class" -> "ModificationHistory"}, {Recurse[]}],

    {Cell,"OriginalAuthor"}:> XMLElement["p", {"class" -> "OriginalAuthor"}, {Recurse[]}],

    {Cell,"OriginalCreationDate"}:> XMLElement["p", {"class" -> "OriginalCreationDate"}, {Recurse[]}],

    {Cell,"OriginalSource"}:> XMLElement["p", {"class" -> "OriginalSource"}, {Recurse[]}],

    {Cell,"ProductName"}:> XMLElement["p", {"class" -> "ProductName"}, {Recurse[]}],

    {Cell,"ProductVersions"}:> XMLElement["p", {"class" -> "ProductVersions"}, {Recurse[]}],

    {Cell,"ReviseForNewVersionRelease"}:> XMLElement["p", {"class" -> "ReviseForNewVersionRelease"},  {Recurse[]}],

    {Cell,"Subsection"}:> XMLElement["h2", {"class" -> "Subsection"},  {Recurse[]}],

    {Cell,"Subsubsection"}:> XMLElement["h3", {"class" -> "Subsubsection"}, {Recurse[]}],

    {Cell,"Text"}:> XMLElement["p", {"class" -> "Text"}, {Recurse[]}],

    {Cell,"Title"}:> XMLElement["h1",{"class" -> "Title"},{Recurse[]}],

    {Cell,"TitleHead"}:> XMLElement["p", {"class" -> "TitleHead"}, {Recurse[]}],

    {StyleBox,"DirFileName"}:> XMLElement["tt", {},{Recurse[]}],

    {StyleBox,"MB"}:> XMLElement["tt", {},{Recurse[]}],

    {StyleBox,"MR"}:> XMLElement["tt", {},{Recurse[]}],

    {StyleBox,"Product"}:> XMLElement["i", {},{Recurse[]}],

    {String}:> Module[{stringcontent},
		stringcontent = SelectChildren[];
		Print["String"];
			Transmogrify[stringcontent]
	],  


    {ButtonBox}:> Switch[
	GetOption[ButtonData],None,Recurse[],
			URL[_],XMLElement["a",{"href"->GetOption[ButtonData][[1,1]],"class"->"Hyperlink"},{Recurse[]}], 			{URL[_],___}, XMLElement["a",{"href"->GetOption[ButtonData][[1,1]],"class"->"Hyperlink"},		{Recurse[]}]]

    }]