(* :Title: MarketingPages.m *)

(* :Author:
  Andrew Hunt, andy@wolfram.com
*)

(* :Mathematica Version: 6 *)
(* :Package Version: $Revision: 1.4 $ $Date: 2013/11/12 21:33:48 $ *)                  
(* :Copyright: (c) 2006, Wolfram Research, Inc. All rights reserved. *)
(* :Summary: General transform for Mathematica Marketing Pages *)


XMLTransform[{

(* Transform Notebook *)
{Notebook} :>  Module[ {pagetitle, pagetitlemodifier, searchquerystring, citehead, language, languagepage, languageimage, buildNumber, 
	history, l, completeHTMLQ, htmlBase, urlBaseRemote, linkTrail, dashboard, summary, fileBase, searchHeader, tagrules, 
	flag,  keywords, specialKeywords,insertedKeywords,listLength,listDivisor, subtractor, buildmode, tutorialcollection, 
	marketingBlurb, entityrules, filledinlayoutexpr},

entityrules = {"\[LongDash]"->"&mdash;", "\[FilledRightTriangle]"->"&#9658;", "\[FilledLeftTriangle]"->"&#9668;"};

pagetitlemodifier = GetParameter["titlemodifier"];
pagetitle = GetParameter["title"];
pagetitle = StringReplace[pagetitle, 
	Prepend[Get[ToFileName[{$DocumentationBuildDirectory}, "TextCharacterReplacementRules.m"]], "\[Rule]"->"->"] ];

keywords=GetParameter["keywords"];
specialKeywords=GetParameter["specialKeywords"];
keywords=Complement[Flatten[{StringSplit[keywords, ","]}],specialKeywords];
listLength=Length[keywords];
listDivisor=If[listLength>0, Round[Extract[Solve[listLength/x == 20, x], {{1, 1, 2}}]][[1]], 1];
subtractor=listDivisor-1;
keywords=If[Length@keywords<24,keywords,
	Extract[keywords, 
Partition[Table[listDivisor(i)-subtractor, {i,Round[listLength/listDivisor]}], 1] ]];
insertedKeywords=ToStringList[keywords];

buildmode = GetParameter["buildmode"];
buildNumber = GetParameter["BuildNumber"];
history = GetParameter["HistoryData"];
IsManipulate = GetParameter["IsManipulate"];
language = GetParameter["language"];
linkTrail = GetParameter["linkTrail"];

Print@buildmode;

fudgeValignProp[x_]:= Module[{var,newvar},
    	var=ToExpression[x];
    	newvar=Which[
    	var<14, "-10",
    	13<var<18, "-12",
    	17<var<20, "-16",
    	19<var<23, "-22",
    	22<var<27, "-35",
    	26<var<30, "-45",
    	29<var<32, "-55",
        31<var<35, "-65",
    	True, "-75"
    ];
    newvar
    ];

(* convert charaacters to entities - IE Windows won't render pages if meta description contains escaped characters *)
summary = GetParameter["summary"];
summary = ExportString[XMLElement["String", {}, { GetParameter["summary"] }], "XML", "Entities" -> "HTML"];
summary = If[Head@summary === String,
			StringReplace[summary, {"<String>" -> "", "</String>" -> ""}],
			""];
summary = CleanSummaryForWeb[summary];
fileBase = GetFileNameBase[];

linkTrail = 
If[ !MemberQ[{None, {}, $Failed, ""}, linkTrail], 
	 Which[
	 	MatchQ[linkTrail, {Cell[CellGroupData[{}]]}], "", 
	 	GetParameter["entityType"]==="Note", "",
	 	True, ExportString[ DIV[ {"class" -> "breadcrumb"}, {Recurse@linkTrail}], "XML", "AttributeQuoting"->"\"", "Entities"->entityrules, "ElementFormatting" -> DocumentationBuild`Utils`Private`indentFunction]], 
"" ];

WithParameters[
  { "FileName"-> StringReplace[GetAbsoluteFileName[], {".en"->"", ".ja"->""}] 
},  


(
  
Block[{styleswitch},
    
  (* symbolic XML template *)
 filledinlayoutexpr = FillInLayout[
    GetParameter["layoutfile"],
    "Text",
    "pageTitle" -> pagetitle,
    "BuildNumber" -> buildNumber,
    "title" -> ExportString[XMLElement["title", {}, { pagetitle }], "XML", "Entities"->entityrules],
    "metabuildnumber" -> "<meta name=\"buildnumber\" content=\""<>buildNumber<>"\" />",
    "metahistorydata" -> ExportString[XMLElement["meta", {"name"->"historydata","content"->ToString[history] }, {}], "XML", "AttributeQuoting"->"\"", "Entities"->entityrules],
    "metakeywords" ->If[Length@keywords > 0, ExportString[XMLElement["meta", {"name"->"keywords", "content"->insertedKeywords}, {}], "XML", "AttributeQuoting"->"\"", "Entities"->entityrules], ""],
	"metasynonyms" ->If[Length@GetParameter["synonyms"] > 0, ExportString[XMLElement["meta", {"name"->"synonyms", "content"->ToStringList[GetParameter["synonyms"]] }, {}], "XML", "AttributeQuoting"->"\"", "Entities"->entityrules], ""],
    "metadescription" ->If[MatchQ[summary, List[_String]|_String], ExportString[XMLElement["meta", {"name"->"description", "content"->If[MatchQ[summary, List[_String]], summary[[1]], summary] }, {}], "XML", "AttributeQuoting"->"\"", "Entities"->entityrules], ""],
    "baselangline" -> ExportString[XMLElement["script", {"language" -> "JavaScript", "type" -> "text/javascript"},{XML`RawXML["baselang='"<>fileBase<>"';"]}], "XML", "AttributeQuoting"->"\"", "Entities"->entityrules],
    "htmlBase" -> htmlBase,
    "linkTrail" -> linkTrail,
    "search" -> ExportString[searchHeader,
        "XML",
    "AttributeQuoting"->"\"", "Entities"->{"\[LongDash]"->"&mdash;", "\[FilledRightTriangle]"->"&#9658;", "\[FilledLeftTriangle]"->"&#9668;"},    
"ElementFormatting" -> DocumentationBuild`Utils`Private`indentFunction],
    "langTag" -> "\""<>If[language==="Japanese","ja","en"]<>"\"",
    "dashboard" -> dashboard,
    "keywords" -> insertedKeywords, 

    "body"-> If[
   MemberQ[exceptionsList, GetParameter["entityType"]], 

   StringJoin@Map[ExportString[#,
        "XML",
     "AttributeQuoting"->"\"", "Entities"->{"\[LongDash]"->"&mdash;", "\[FilledRightTriangle]"->"&#9658;", "\[FilledLeftTriangle]"->"&#9668;"},    
"ElementFormatting" -> DocumentationBuild`Utils`Private`indentFunction]&, 
	{XMLElement["div", {"class"-> "mainContent"}, {Transmogrify[SelectChildren[] //. Cell[linkContent__, "LinkTrail", linkOptions___] :> Unevaluated[Sequence[]](* Cell["","FooterCell"]  *) ]}]
		 }],
      ExportString[
        XMLElement["div", {"class"-> "mainContent"}, {Recurse[]}],
        "XML",
     "AttributeQuoting"->"\"", "Entities"->{"\[RightGuillemet]"->"<span class=\"rightguillemet\">&#187;</span>", "\[LongDash]"->"&mdash;", "\[FilledRightTriangle]"->"&#9658;", "\[FilledLeftTriangle]"->"&#9668;"},    
"ElementFormatting" -> DocumentationBuild`Utils`Private`indentFunction] 
] 

]; 
StringReplace[filledinlayoutexpr, {
	"&#160;<span class=\"inlineBullet\">&nbsp;&#9642;&nbsp;</span> <"->"<span class=\"inlineBullet\">&nbsp;&#9642; </span><", 
	"<span class=\"ThinSpace\"><!-- --></span>"->"<span class=\"ThinSpace\"></span>",
	"&#160;&#160;<span>("->"&#160;<span>(",
	"BUILT-IN MATHEMATICA SYMBOL"->"Built-in Mathematica Symbol",
	"OBSOLETE MATHEMATICA SYMBOL"->"Obsolete Mathematica Symbol",
	"<span class=\"MenuNameDelimiter\"> &#9658; </span>"->"<span class=\"MenuNameDelimiter\">&nbsp;&#9658;&nbsp;</span>",
		"<div class=\"breadcrumb\">
 <div class=\"wrapper\">
  <em><a href=\"/language/guide/Mathematica.html\">Mathematica</a></em>
 </div>
</div>"->"", "<div class=\"breadcrumb\">
 <div class=\"wrapper\">
  <em><a href=\"/language/guide/Mathematica.html\">Mathematica</a></em>
 </div>
</div>"->"", "<em><a href=\"/language/guide/Mathematica.html\">Mathematica</a></em>
  <span class=\"breadcrumbSep\">&gt;</span>"->"", "(<a href=\"http://www.wolframscience.com/nksonline/\">A New Kind of Science</a>)"->"(<a href=\"http://www.wolframscience.com/nksonline/\"><em>A New Kind of Science</em></a>)"}] 
  ]
)
]  (* end WithParam *)
],


(************************

Define cell transforms 

************************)

(* General styles *)

{Cell, "FeaturedExampleTitle"} :> XMLElement["h1", {}, {Recurse[]} ],

{Cell, "FeaturedExampleText"} :> P[{"class" -> "intro"}, {Recurse[]} ],

{Cell, "FeaturedExampleDetail"} :> DIV[{"class"->"Text"}, {Recurse[]} ],

{CellGroupData, "Delimiter"} :> XMLElement["div", {"class"->"examples"}, {Recurse[]} ],

{Cell, "Delimiter"} :> XMLElement["div", {"class"->"ExampleDelimiter"}, {XML`RawXML["<!-- -->"]} ], 

{CellGroupData, "WeightingSection"} :> Unevaluated[Sequence[]],

{Cell, "WeightingSection"} :> Unevaluated[Sequence[]],

{Cell, "Weight"} :> Unevaluated[Sequence[]],

{CellGroupData, "ContributorSection"} :> Unevaluated[Sequence[]],

{Cell, "ContributorSection"} :> Unevaluated[Sequence[]],

{Cell, "Contributor"} :> Unevaluated[Sequence[]],

{CellGroupData, "FeaturedExampleRelatedTutorialsSection" } :> XMLElement["div", {"class"->"expandWrap", "id"->"RelatedTutorials"},
	{XMLElement["div", {"class"->"expandOuter"},{
		XMLElement["h2", {"class"->"expandInner"}, {
			XMLElement["a", {"class"->"expand hide", "title"->Localized["show", GetParameter["language"]], "href"->"#"},{Localized["RelatedTutorialsSectionText", GetParameter["language"]]}], 
			XMLElement["a", {"class"->"collapse", "title"->Localized["hide", GetParameter["language"]], "href"->"#"},{Localized["RelatedTutorialsSectionText", GetParameter["language"]]}]}], 
			XMLElement["div",{"class"->"expanded"},{XMLElement["ul",{"class"->"functionList"},{Recurse[]}]}]}]}],

{Cell, "FeaturedExampleRelatedTutorialsSection" } :> Unevaluated[Sequence[]],

{CellGroupData, "FeaturedExampleMoreAboutSection" } :> XMLElement["div", {"class"->"expandWrap", "id"->"RelatedGuides"},
	{XMLElement["div", {"class"->"expandOuter"},{
		XMLElement["h2", {"class"->"expandInner"}, {
			XMLElement["a", {"class"->"expand hide", "title"->Localized["show", GetParameter["language"]], "href"->"#"},{Localized["MoreAboutSectionText", GetParameter["language"]]}], 
			XMLElement["a", {"class"->"collapse", "title"->Localized["hide", GetParameter["language"]], "href"->"#"},{Localized["MoreAboutSectionText", GetParameter["language"]]}]}], 
			XMLElement["div",{"class"->"expanded"},{XMLElement["ul",{"class"->"functionList"},{Recurse[]}]}]}]}],

{Cell, "FeaturedExampleMoreAboutSection" } :> Unevaluated[Sequence[]],

{CellGroupData, "FeaturedExampleRelatedLinksSection" } :> XMLElement["div", {"class"->"expandWrap", "id"->"RelatedLinks"},
	{XMLElement["div", {"class"->"expandOuter"},{
		XMLElement["h2", {"class"->"expandInner"}, {
			XMLElement["a", {"class"->"expand hide", "title"->Localized["show", GetParameter["language"]], "href"->"#"},{Localized["RelatedLinksSectionText", GetParameter["language"]]}], 
			XMLElement["a", {"class"->"collapse", "title"->Localized["hide", GetParameter["language"]], "href"->"#"},{Localized["RelatedLinksSectionText", GetParameter["language"]]}]}], 
			XMLElement["div",{"class"->"expanded"},{XMLElement["ul",{"class"->"functionList"},{Recurse[]}]}]}]}],

{Cell, "FeaturedExampleRelatedLinksSection" } :> Unevaluated[Sequence[]],

{CellGroupData, "FeaturedExampleTutorialCollectionSection" } :> XMLElement["div", {"class"->"expandWrap", "id"->"TutorialCollection"},
	{XMLElement["div", {"class"->"expandOuter"},{
		XMLElement["h2", {"class"->"expandInner"}, {
			XMLElement["a", {"class"->"expand hide", "title"->Localized["show", GetParameter["language"]], "href"->"#"},{Localized["TutorialCollectionSectionText", GetParameter["language"]]}], 
			XMLElement["a", {"class"->"collapse", "title"->Localized["hide", GetParameter["language"]], "href"->"#"},{Localized["TutorialCollectionSectionText", GetParameter["language"]]}]}], 
			XMLElement["div",{"class"->"expanded"},{XMLElement["ul",{"class"->"functionList"},{Recurse[]}]}]}]}],

{Cell, "FeaturedExampleTutorialCollectionSection" } :> Unevaluated[Sequence[]],

{CellGroupData, "FeaturedExampleCollectionSection" } :> XMLElement["div", {"class"->"expandWrap", "id"->"TutorialCollection"},
	{XMLElement["div", {"class"->"expandOuter"},{
		XMLElement["h2", {"class"->"expandInner"}, {
			XMLElement["a", {"class"->"expand hide", "title"->Localized["show", GetParameter["language"]], "href"->"#"},{Localized["TutorialCollectionSectionText", GetParameter["language"]]}], 
			XMLElement["a", {"class"->"collapse", "title"->Localized["hide", GetParameter["language"]], "href"->"#"},{Localized["TutorialCollectionSectionText", GetParameter["language"]]}]}], 
			XMLElement["div",{"class"->"expanded"},{XMLElement["ul",{"class"->"functionList"},{Recurse[]}]}]}]}],

{Cell, "FeaturedExampleCollectionSection" } :> Unevaluated[Sequence[]],

{Cell, "FeaturedExampleRelatedTutorials" | "FeaturedExampleRelatedLinks" | "FeaturedExampleMoreAbout" | "FeaturedExampleCollection"} :> Li[{Recurse[]}]



}, 
    

IncludeXMLTransforms -> {{"HTML","Components","Includes.m"}},
DefaultParameters -> { "newline2br" -> False, "newline2div" -> False}

]