(* 
  Title: ButtonBox XMLTransform
  Authors: Greg Martel, Andy Hunt, Stephen Layland
*)



XMLTransform[{

{TemplateBox} :> 
Block[{output, 
	urlBaseRemote = GetParameter["urlBaseRemote"], 
	htmlBase = GetParameter["htmlBase"],
	pacletName = GetParameter["pacletName"], 
	completeHTMLQ = GetParameter["CompleteHTMLQ"], 
	uriDepth, 
	isALink,
  isAPackageLink,
	link,
	versionNumber, 
	hasOptionBaseStyle,
	getOptionBaseStyle,
	hasOptionButtonData,
	getOptionButtonData, 
	anchorButtons, 
	anchorContent,
	hasOptionButtonFrame, 
	uri = GetParameter["url"],
	link2
	},
versionNumber = StringSplit[$Version, "."][[1]];

uriDepth = If[Head@uri === String, Length@StringSplit[uri, "/"] ];

isALink = If[Length[SelectSelf[]]>1,
	If[MemberQ[{"GrayLink", "GrayWebLink", "OrangeLink", "RefLink", "MenuGrayLink", "WebLink", "GrayLinkWithIcon"}, SelectSelf[][[2]]],
	True, False],
	False
	];

{output, link}=If[isALink, If[Head[SelectSelf[][[1]]]===List, 
	If[Length[SelectSelf[][[1]]]>1, 
		{{Transmogrify[SelectSelf[][[1,1]]]}, SelectSelf[][[1,2]]}, {"FIXME","FIXME"}],
		{"FIXME", "FIXME"}], {transmogrifyImage[ToFileName[{"Files", GetFileNameBase[]},
         IncrementCounter["Image"] <> ".png"], {"alt"->""},
         Inline -> True, CropImage -> False, ImageFormat -> "PNG", TransparentBackground->True, ConversionOptions->{Background->None}
      ], transmogrifyImage[ToFileName[{"Files", GetFileNameBase[]},
         IncrementCounter["Image"] <> ".png"], {"alt"->""},
         Inline -> True, CropImage -> False, ImageFormat -> "PNG", TransparentBackground->True, ConversionOptions->{Background->None}
      ]}];

link = If[isALink,
Switch[SelectSelf[][[2]],
	"RefLink" | "GrayLink" | "OrangeLink",
	Which[
		(completeHTMLQ === True) && !StringFreeQ[link, pacletName],
		DocumentationBuild`Utils`DotHTML@StringReplace[link, {pacletName<>"/"->"", "paclet:"->StringJoin @@ Flatten@Table[{"../"}, {uriDepth - 2}] }],
	    StringMatchQ[link, "*NETLink/ref/net/*"],
                  DocumentationBuild`Utils`DotHTML@ 
                    StringReplace[StringReplace[link, 
                      {"paclet:"->urlBaseRemote, 
                      	"NETLink/ref/net/"->"NETLink/ref/net/Wolfram.NETLink.","IKernelLink/" -> "IKernelLink."}], 
                      	{"NETLink/ref/net/Wolfram.NETLink.NETLink" ->"NETLink/ref/net/Wolfram.NETLink", 
                      	"Wolfram.NETLink.IKernelLink.EvaluateToOutputForm"->"Wolfram.NETLink.IKernelLink.EvaluateToOutputForm_overloads",
                      	"Wolfram.NETLink.IKernelLink.EvaluateToImage"->"Wolfram.NETLink.IKernelLink.EvaluateToImage_overloads",
                      	"Wolfram.NETLink.IKernelLink.Evaluate"->"Wolfram.NETLink.IKernelLink.Evaluate_overloads",
                      	"Wolfram.NETLink.IKernelLink.GetInteger"->"Wolfram.NETLink.IMathLink.GetInteger",
                      	"Wolfram.NETLink.ConsoleWindow"->"Wolfram.NETLink.UI.ConsoleWindow",
                      	"Wolfram.NETLink.DoubleBufferedPanel"->"Wolfram.NETLink.UI.DoubleBufferedPanel",
                      	"Wolfram.NETLink.MathPictureBox"->"Wolfram.NETLink.UI.MathPictureBox",
                      	"Wolfram.NETLink.MathLinkFactory/CreateKernelLink"->"Wolfram.NETLink.MathLinkFactory.CreateKernelLink_overloads",
                      	(*"Wolfram.NETLink.NETLink"<>""->"index",*)
                      	"NETLink/ref/net/DotNETInterface"->"NETLink/guide/DotNETInterface"
                      	}],
	    True,
	    DocumentationBuild`Utils`DotHTML@StringReplace[link, {"paclet://"->urlBaseRemote, "paclet:"->urlBaseRemote}]
	    ],
	"WebLink" | "GrayWebLink",
    If[!completeHTMLQ,
      convertWSMLink @ convertModelicaLink @ ConvertToString[link],
      link],

	"MenuGrayLink",
	DocumentationBuild`Utils`DotHTML@StringReplace[ConvertToString[link], 
	                	If[ (completeHTMLQ === True) && !StringFreeQ[ConvertToString[link], pacletName],
		                  {pacletName<>"/"->"", "paclet:"->StringJoin @@ Flatten@Table[{"../"}, {uriDepth - 2}] },
		                  {"paclet://"->urlBaseRemote, "paclet:"->urlBaseRemote}
	                	]
	                ],
	"GrayLinkWithIcon",
	DocumentationBuild`Utils`DotHTML@StringReplace[ConvertToString[link], 
	                	If[ (completeHTMLQ === True) && !StringFreeQ[ConvertToString[link], pacletName],
		                  {pacletName<>"/"->"", "paclet:"->StringJoin @@ Flatten@Table[{"../"}, {uriDepth - 2}] },
		                  {"paclet://"->urlBaseRemote, "paclet:"->urlBaseRemote}
	                	]
	                ],
	_, link],
	transmogrifyImage[ToFileName[{"Files", GetFileNameBase[]},
         IncrementCounter["Image"] <> ".png"], {"alt"->""},
         Inline -> True, CropImage -> False, ImageFormat -> "PNG", TransparentBackground->True, ConversionOptions->{Background->None}
      ]];

(* https://jira.wolfram.com/jira/browse/WLDOCS-1022: links to packages should have a different style. *)
(* links to packages match ^paclet:[A-Z]; other links match ^paclet:[a-z] *)
isAPackageLink = Positive @ Length @ Cases[SelectSelf[], s_String /; StringMatchQ[s, StartOfString ~~ "paclet:" ~~ CharacterRange["A", "Z"] ~~ ___], Infinity];

If[isALink,
  XMLElement[
    "a",
    If[isAPackageLink, {"class" -> "package-symbol", "href"->link}, {"href"->link}],
    Flatten[{output}]
  ],
  output
]
](* end WithParameters *)
}

] 

