(*          StyleBox to HTML transformation rules               *)
(*
   Authors:  andyh, gregm, shaunm.  cleaned up and optimized 
             by layland.
             
   Parameter Dependencies:  "MRLinkReplacements", "properties"

   Limitations:  the StyleBox href links work by assuming the Entry described
                 in the propertyFile is the current page.  In otherwords, 
                 "string" in Entry["string",...].  Systems that don't use
                 propertyFiles might need other adjustments.

   Version: $Id: StyleBox.m,v 1.15 2016/05/31 19:35:59 brendane Exp $ 

   TODO:  remove enclosing <span> when unnecessary, i.e. - 
      <span class="MR">
        <a href="blah"><span class="MR">link text</span></a>
      </span>
   this is only around for IE 5 compatibility.
*)

XMLTransform[{


(* translations for all other styleboxes... *)
{StyleBox, All} :> 
  (
  (*If[Head[Recurse[]]=!= String && HasStyle[] && GetStyle[]==="NewIn6Graphic", 
		XMLElement["img", {"src" -> GetParameter["htmlBase"]<>"/mathematicaImages/NewIn6.gif", "height" -> "20", "width" -> "67"}, {""}]

  , *)

(* Make sure we don't return a list *)
If[Head[#] === List, Apply[Sequence, #], #]&@

    (* First do <div> processing if necessary... *)
    If[
      MatchQ[
        GetOption[GridElementStyleOptions],
        {___, ColumnAlignments->Left, ___}
      ]
      && (Head[SelectParent[2]] === GridBox),
      XMLElement["div", {"style" -> "text-align: left;"},Flatten[{#}]],
      #
    ]& [
      (* wrap stuff in style span if it's got a style *)
      If[HasStyle[],
      	(*If[GetStyle[]==="CompetitorEmphasis",
      		XMLElement["strong", {"class" -> "CompetitorEmphasis"},Flatten[{#}]],
			XMLElement["span", {"class" -> GetStyle[]},Flatten[{#}]]],*)
      	Which[GetStyle[]==="CompetitorEmphasis",
      		XMLElement["strong", {"class" -> "CompetitorEmphasis"},Flatten[{#}]],
      		GetStyle[]==="LinkTrailSeparator",
      		XMLElement["span", {"class" -> "breadcrumbSep"},{">"}],
      		GetStyle[]==="GuideEmDash",
      		XMLElement["span", {"class" -> "dash"},{XML`RawXML["&mdash;"]}],
      		GetStyle[]==="NewIn10Graphic", 
      		XMLElement["span", {"class"->"NewIn10Graphic"}, {XML`RawXML[""]}],
      		GetStyle[]==="RootDarkLink",
      		XMLElement["span", {},Flatten[{#}]],
      		GetStyle[]==="InlineCode" && SelectSelf[][[1]]==="\[ThinSpace]",
      		Flatten[{#}],
      		GetStyle[]==="TradFormChar",
      		transmogrifyImage[ToFileName[{"Files", GetFileNameBase[]},
  "char"<>IncrementCounter["OperatorCharacter"] <> ".gif"], {"alt"->"", "title"->""},
  "TransparentColor" -> White, Inline -> True, CropImage -> False
],
      		GetStyle[]==="StandFormChar",
      		transmogrifyImage[ToFileName[{"Files", GetFileNameBase[]},
  "char"<>IncrementCounter["OperatorCharacter"] <> ".gif"], {"alt"->"", "title"->""},
  "TransparentColor" -> White, Inline -> True, CropImage -> False
],    		
      		GetStyle[]==="OperatorCharacter",
      		XMLElement["span", {"class" -> GetStyle[]},
      			{transmogrifyImage[ToFileName[{"Files", GetFileNameBase[]},
  "char"<>IncrementCounter["OperatorCharacter"] <> ".gif"], {"style"->"vertical-align:text-top;", "alt"->"", "title"->""},
  "TransparentColor" -> White, Inline -> True, CropImage -> False
]}
      			],
      		GetStyle[]==="OperatorCharacterText",
      		XMLElement["span", {"class" -> "OperatorCharacter"},Flatten[{#}]],
      		GetStyle[]==="NewIn9Graphic",
      		XMLElement["span", {"class" -> "NewInGraphic"},Flatten[{#}]],
      		
			True, XMLElement["span", {"class" -> GetStyle[]},Flatten[{#}]]],
        #
      ]& [
        (* now process whatever options exist if we have to *)
        If[
          Length[Options[SelectLiteral[SelectSelf[]]]] > 0,
          Switch[
              GetOption[FontFamily], 
        "Courier" | "Courier New" | "Courier New (OEM)" | "WriCourier" | "courier",
              XMLElement["span", {"class" -> "monospace"},Flatten[{#}]]
              ,
      
        "Helvetica" | "L Futura Light" | "ExtraLight" | "Helv" | "C Futura Condensed" | "Arial" | "Lucida Grande" | "Chicago" | "Futura" | "Geneva" | "Monaco" | "MS Sans Serif" | "New York",
              XMLElement["span", {"class" -> "sans-serif"},Flatten[{#}]]
              ,
      
        "Times" | "Century" | "Osaka" | "Times New Roman" | "Palatino" | "Texte" | "Plain",
              XMLElement["span", {"class" -> "serif"},Flatten[{#}]]
              ,
              _,
              #
          ]& [
            Which[
              GetOption[FontSlant]==="Italic" || GetOption[FontSlant]===Italic,
                XMLElement["em",{},Flatten[{#}]],
              GetOption[FontSlant]==="Plain" || GetOption[FontSlant]===Plain,
                XMLElement["span", {"class"->"plain"}, Flatten[{#}]],
              True, #
            ]& [
              If[GetOption[FontWeight]==="Bold" || GetOption[FontWeight]===Bold,
                XMLElement["strong",{},Flatten[{#}]],
                #
              ]& [     
                If[
                  GetOption[FontVariations, "Underline"]===True,
                  XMLElement["u",{},Flatten[{#}]],
                  #
                ] & [ {Transmogrify[SelectChildren[]]} ]
              ]
            ]
          ]
          ,
          {Transmogrify[SelectChildren[]]}
        ] 
      ]
    ]
(*]*)
  )

},
    
DefaultParameters-> {
  "MRLinkReplacements" -> Flatten@Transmogrify`ImportCache`FastImport[ToFileName[{
    DocumentationBuild`Common`$DocumentationBuildDirectory,"Internal", "web", "data"},"MRReplacementList.m"]]
}]
