(* :Title: Functions.m *)

(* :Author:
	Andrew Hunt, andy@wolfram.com
	Greg Martel, gregm@wolfram.com
    Stephen Layland, layland@wolfram.com
*)

(* :Mathematica Version: 5.1 *)
(* :Package Version: $Revision: 1.13 $ $Date: 2013/11/05 22:17:52 $ *)
(* :Copyright: (c) 2005, Wolfram Research, Inc. All rights reserved. *)
(* :Summary: Add-ons specific rules and general transform for Mathematica Documentation *)



XMLTransform[{

(** Primary Examples **)
{CellGroupData, "PrimaryExamplesSection"} :> 
XMLElement["div", {"class"->"expandWrap", "id"->"Examples"},
	{XMLElement["div", {"class"->"expandOuter"},{
		XMLElement["h2", {"class"->"expandInner"}, {
			XMLElement["a", {"class"->"expand hide", "title"->Localized["show", GetParameter["language"]], "href"->"#"},{Localized["ExamplesSectionText", GetParameter["language"]]}], 
			XMLElement["a", {"class"->"collapse", "title"->Localized["hide", GetParameter["language"]], "href"->"#"},{Localized["ExamplesSectionText", GetParameter["language"]]}],
			XMLElement["a", {"class"->"all opener", "title"->ToLowerCase[Localized["Open All", GetParameter["language"]]], "href"->"#"},{
				XMLElement["span", {}, {ToLowerCase[Localized["Open All", GetParameter["language"]]]}]}], 
			XMLElement["a", {"class"->"all closer hide", "title"->ToLowerCase[Localized["Close All", GetParameter["language"]]], "href"->"#"},
				{
					XMLElement["span", {}, {ToLowerCase[Localized["Close All", GetParameter["language"]]]}]}]}], 
					XMLElement["div",{"class"->"expanded"},{
						Recurse[],
						XMLElement["div",{"class"->"toplink"},{
							XMLElement["a",{"href"->"#top"}, {Localized["Top", GetParameter["language"]]}]}], 
							XMLElement["div",{"class"->"clear"},{XML`RawXML["<!-- -->"]}]}]}]}], 

(** Primary Examples **)
{CellGroupData, "IndicatorExampleSection"} :> 
XMLElement["div", {"class"->"expandWrap first", "id"->"Example"},
	{XMLElement["div", {"class"->"expandOuter"},{
		XMLElement["h2", {"class"->"expandInner"}, {
			XMLElement["a", {"class"->"expand hide", "title"->Localized["show", GetParameter["language"]], "href"->"#"},{"Example"}], 
			XMLElement["a", {"class"->"collapse", "title"->Localized["hide", GetParameter["language"]], "href"->"#"},{"Example"}]}], 
					XMLElement["div",{"class"->"expanded"},{
						Recurse[]}]}]}], 
							
{Cell, "PrimaryExamplesSection"| "IndicatorExampleSection"} :> Unevaluated[Sequence[]],


{CellGroupData, "ExampleSection" | "ExtendedExamplesSection"}:> 
WithParameters[
  {"ExampleSectionCounter" -> IncrementCounter["ExampleSectionCounter"]},
XMLElement["div", {If[Length[Cases[First[SelectChildren[]], Localized["BasicExamplesSectionText", GetParameter["language"]], Infinity]]>0, "class" -> "expandSubWrap", "class" -> "expandSubWrap closed"]}, {XMLElement[
   "div", {"class" -> "expandSubOuter"}, {Transmogrify[First[SelectChildren[]]], 
    XMLElement["div", {"class" -> "expanded"}, {
  If[GetParameter["ExampleSectionCounter"]==="1", 
  	Transmogrify[Rest[SelectChildren[]]], 
  	CreateDirectory[ToFileName[{"Files", GetFileNameBase[]}]];
  	Export[
  	ToFileName[{"Files", GetFileNameBase[]}, 
  		FileBaseName[ToLowerCase[GetFileNameBase[]]]<>ToString[ToExpression[GetParameter["ExampleSectionCounter"]]-1]<>".html"], 
  		StringReplace[
  			ExportString[
  				XMLElement["examplesectiontemp", {}, {
  					If[GetParameter["CompleteHTMLQ"]===True,
  					XML`RawXML["<script type=\"text/javascript\" src=\""<>StringJoin @@ Flatten@{ Table["../", { (Length@StringCases[GetParameter["url"], "/"])-1 }] }<>"javascript/sub-pages.js\"></script>"],
  					XML`RawXML["<script type=\"text/javascript\" src=\"/2013/javascript/sub-pages.js\"></script>"]
  					], 
  					Transmogrify[Rest[SelectChildren[]]]}],
  				"XML", "AttributeQuoting"->"\"", "Entities"->{"\[LongDash]"->"&mdash;", "\[FilledRightTriangle]"->"&#9658;", "\[FilledLeftTriangle]"->"&#9668;"}, "ElementFormatting" -> DocumentationBuild`Utils`Private`indentFunction], 
  					{"<examplesectiontemp>"->"", "</examplesectiontemp>"->""}], "Text"];
  					XML`RawXML[""]]}]}]}]], 

{Cell, "ExampleSection" | "ExtendedExamplesSection"} :> 
XMLElement[
     "h3", {"class" -> "expandSubInner"}, {XMLElement[
       "a", {"class" -> "expand hide", "href" -> "#", 
        "title" -> Localized["show", GetParameter["language"]]}, {Recurse[]}], 
      XMLElement[
       "a", {"class" -> "collapse", "href" -> "#", 
        "title" -> Localized["hide", GetParameter["language"]]}, {Recurse[]}]}], (* end table *)  


{CellGroupData, "ExampleSubsection"} :> 
XMLElement["div", {"class" -> "expandSubsubWrap closed"}, {XMLElement[
   "div", {"class" -> "expandSubsubOuter"}, {Transmogrify[First[SelectChildren[]]], 
    XMLElement["div", {"class" -> "expanded hide"}, {Transmogrify[Rest[SelectChildren[]]]}]}]}], 


{Cell, "ExampleSubsection"} :> 
	XMLElement[
     "h4", {"class" -> "expandSubsubInner"}, {XMLElement[
       "a", {"class" -> "expand", "href" -> "#", 
        "title" -> Localized["show", GetParameter["language"]]}, {Recurse[]}], 
      XMLElement[
       "a", {"class" -> "collapse hide", "href" -> "#", 
        "title" -> Localized["hide", GetParameter["language"]]}, {Recurse[]}]}], (* end table *)  
        
{CellGroupData, "ExampleSubsubsection"} :> 
XMLElement["div", {"class" -> "expandSubsubsubWrap closed"}, {XMLElement[
   "div", {"class" -> "expandSubsubsubOuter"}, {Transmogrify[First[SelectChildren[]]], 
    XMLElement["div", {"class" -> "expanded hide"}, {Transmogrify[Rest[SelectChildren[]]]}]}]}], 


{Cell, "ExampleSubsubsection"} :> 
	XMLElement["h5", {"class" -> "expandSubsubsubInner"}, {
		XMLElement["a", {"class" -> "expand", "href" -> "#", "title" -> Localized["show", GetParameter["language"]]}, {Recurse[]}], 
		XMLElement["a", {"class" -> "collapse hide", "href" -> "#", "title" -> Localized["hide", GetParameter["language"]]}, {Recurse[]}]}],


{Cell, "ExampleCount"} :> XMLElement["span", {}, {Recurse[]}]

}]
