(* 
  Title: ButtonBox XMLTransform
  Authors: Greg Martel, Andy Hunt, Stephen Layland
*)



XMLTransform[{

{ButtonBox} :> 
Block[{output = Recurse[], urlBaseRemote = GetParameter["urlBaseRemote"], htmlBase = GetParameter["htmlBase"],
	pacletName = GetParameter["pacletName"], completeHTMLQ = GetParameter["CompleteHTMLQ"], uriDepth,
	versionNumber, hasOptionBaseStyle,getOptionBaseStyle,hasOptionButtonData,getOptionButtonData, anchorButtons, anchorContent,hasOptionButtonFrame, uri = GetParameter["url"]},
versionNumber = StringSplit[$Version, "."][[1]];
hasOptionButtonFrame = HasOption[ButtonFrame];
hasOptionBaseStyle = HasOption[BaseStyle];
getOptionBaseStyle = If[hasOptionBaseStyle, GetOption[BaseStyle], Null];
hasOptionButtonData = HasOption[ButtonData]; 
getOptionButtonData = If[hasOptionButtonData, GetOption[ButtonData], Null];

uriDepth = If[Head@uri === String, 
	Length@StringSplit[uri, "/"] ];
(*
Global`AntLog["getOptionBaseStyle: "<>getOptionBaseStyle];
Global`AntLog["getOptionButtonData: "<>getOptionButtonData];
Global`AntLog["linkDepth: "<>ToString@uriDepth];
Global`AntLog["uri: "<>ToString@uri];
*)


Which[ 
	output==="...", output = Span[{"class"->"inlineEllipsis"}, {output}],
	hasOptionButtonFrame && 
	Not[MemberQ[{"SEE ALSO", "TUTORIALS", "MORE ABOUT", "EXAMPLES", "MORE INFORMATION"}, output]],
	output = transmogrifyImage[ToFileName[{"Files", GetFileNameBase[]},
  IncrementCounter["Button"] <> "_button.gif"], {"alt"->"", "title"->""},
  Inline -> True, CropImage -> False
],
		True, output = output
];

(* first create an <a> tag,
   here "#" is replaced with the actual URL computed
   below *)
XMLElement["a", Flatten[{"href"->#, 
		
	If[hasOptionButtonData,
		If[Head[getOptionButtonData]===List,
				If[getOptionButtonData[[2]]==="External",{"target"->"blank"},{}], 
				{}],
			{}],
	
If[StringQ[tooltip], {"title"->tooltip}, {}],
Which[
	getOptionBaseStyle==="bluelink", "class"->"bluelink",
	getOptionBaseStyle==="AnchorLink", "class"->"anchorLink",
	getOptionBaseStyle==="ResourceTraining", "id"->"res-training",
	getOptionBaseStyle==="ResourceVideos", "id"->"res-videos",
	getOptionBaseStyle==="ResourceDemonstrations", "id"->"res-demonstrations",
	getOptionBaseStyle==="ResourceCommunity", "id"->"res-community",
	
	(*getOptionBaseStyle==="NewInVersionLink", {"class"->"newInVersionLink", "id"->"ModInfo_"<>versionNumber,"name"->"ModInfo_"<>versionNumber,"onmouseover"->"javascript:return(true);"},
    getOptionBaseStyle==="ModifiedInVersionLink", {"onmouseover"->"javascript:return(true);"},*)
	getOptionBaseStyle==="ExampleLink", {"class"->"ExampleButtonLink"},
	(*getOptionBaseStyle==="NewInLink", {"class"->"NewInLink", "title"->"Toggle extended in 6"},*)
      True, Unevaluated@Sequence[]
  ]   
}],
{output}]& 
(* {output}]&   *)
  [  Which[ 
  	   GetOption[ButtonNote]==="Show Palette"
            	 ,
            	 "/language/notebooks/"<>SelectChildren[][[1]]
            	 ,
      (** get link address based off of BaseStyle **)
      hasOptionBaseStyle,
        Switch[ 
          getOptionBaseStyle, 
            (* 
          {"Link"} , DocumentationBuild`Utils`DotHTML@StringJoin["/language/ref/", ToString@output],
          *)
          "Link" | {"Link"} | {{"Link"}, "ExcludedObject"} | "RootNewInLink",
            If[hasOptionButtonData,
              (* Check for JLink/ref/java/... exception *)
              Which[
              	GetOption[ButtonFunction]==="DEADFUNCTION", 
            	 "#", 
            	 StringQ[getOptionButtonData] && StringMatchQ[getOptionButtonData, "*Make Project"],
            	 "#REMOVELINK#",
            	 StringQ[getOptionButtonData] && StringMatchQ[getOptionButtonData, "*Paginate"],
            	 "#REMOVELINK#",
            	 StringQ[getOptionButtonData] && StringMatchQ[getOptionButtonData, "*Make Contents"],
            	 "#REMOVELINK#",
            	 StringQ[getOptionButtonData] && StringMatchQ[getOptionButtonData, "*Make Index"],
            	 "#REMOVELINK#",
            	 StringQ[getOptionButtonData] && StringMatchQ[getOptionButtonData, "*Export Cells"],
            	 "#REMOVELINK#",
            	 StringQ[getOptionButtonData] && StringMatchQ[getOptionButtonData, "*Insert Value"],
            	 "#REMOVELINK#",
            	 StringQ[getOptionButtonData] && StringMatchQ[getOptionButtonData, "*Printing Options"],
            	 "#REMOVELINK#",
              	StringQ[getOptionButtonData] && StringMatchQ[getOptionButtonData, "*NETLink/example/Part1/*"],
            	 "/language/notebooks/"<>SelectChildren[][[1]]
            	 ,
            	StringQ[getOptionButtonData] && StringMatchQ[getOptionButtonData, "*JLink/example/Part1/*"],
            	 "/language/notebooks/"<>SelectChildren[][[1]]
            	 ,
                 StringQ[getOptionButtonData] && StringMatchQ[getOptionButtonData, "*JLink/ref/java/*"],
                  DocumentationBuild`Utils`DotHTML@ 
                    StringReplace[StringReplace[getOptionButtonData, 
                      {"paclet:"->urlBaseRemote, "JLink/ref/java/"->"JLink/ref/java/com/wolfram/jlink/"}], 
                      	{"JLink/ref/java/com/wolfram/jlink/BracketMatcher"->"JLink/ref/java/com/wolfram/jlink/ui/BracketMatcher",
                      	 "JLink/ref/java/com/wolfram/jlink/ConsoleWindow"->"JLink/ref/java/com/wolfram/jlink/ui/ConsoleWindow", 
                      	 "JLink/ref/java/com/wolfram/jlink/InterruptDialog"->"JLink/ref/java/com/wolfram/jlink/ui/InterruptDialog", 
                      	 "JLink/ref/java/com/wolfram/jlink/MathSessionPane"->"JLink/ref/java/com/wolfram/jlink/ui/MathSessionPane", 
                      	 "JLink/ref/java/com/wolfram/jlink/SyntaxTokenizer"->"JLink/ref/java/com/wolfram/jlink/ui/SyntaxTokenizer",
                      	 "JLink/ref/java/com/wolfram/jlink/LinkSnooper"->"JLink/ref/java/com/wolfram/jlink/util/LinkSnooper", 
                      	 "JLink/ref/java/com/wolfram/jlink/MathematicaTask"->"JLink/ref/java/com/wolfram/jlink/util/MathematicaTask"
                      	}]     	
              ,
                StringQ[getOptionButtonData] && StringMatchQ[getOptionButtonData, "*NETLink/ref/net/*"],
                  DocumentationBuild`Utils`DotHTML@ 
                    StringReplace[StringReplace[getOptionButtonData, 
                      {"paclet:"->urlBaseRemote, 
                      	"NETLink/ref/net/"->"NETLink/ref/net/Wolfram.NETLink.","IKernelLink/" -> "IKernelLink."}], 
                      	{"NETLink/ref/net/Wolfram.NETLink.NETLink" ->"NETLink/ref/net/Wolfram.NETLink", 
                      	"Wolfram.NETLink.IKernelLink.EvaluateToOutputForm"->"Wolfram.NETLink.IKernelLink.EvaluateToOutputForm_overloads",
                      	"Wolfram.NETLink.IKernelLink.EvaluateToImage"->"Wolfram.NETLink.IKernelLink.EvaluateToImage_overloads",
                      	"Wolfram.NETLink.IKernelLink.Evaluate"->"Wolfram.NETLink.IKernelLink.Evaluate_overloads",
                      	"Wolfram.NETLink.IKernelLink.GetInteger"->"Wolfram.NETLink.IMathLink.GetInteger",
                      	"Wolfram.NETLink.ConsoleWindow"->"Wolfram.NETLink.UI.ConsoleWindow",
                      	"Wolfram.NETLink.DoubleBufferedPanel"->"Wolfram.NETLink.UI.DoubleBufferedPanel",
                      	"Wolfram.NETLink.MathPictureBox"->"Wolfram.NETLink.UI.MathPictureBox",
                      	"Wolfram.NETLink.MathLinkFactory/CreateKernelLink"->"Wolfram.NETLink.MathLinkFactory.CreateKernelLink_overloads",
                      	(*"Wolfram.NETLink.NETLink"<>""->"index",*)
                      	"NETLink/ref/net/DotNETInterface"->"NETLink/guide/DotNETInterface"
                      	}]
              , 

              StringQ[getOptionButtonData]
              && StringMatchQ[pacletName, "*SystemModeler*"]
              (* WSM web docs, not in-product docs *)
              && completeHTMLQ === False
              && StringMatchQ[getOptionButtonData, "paclet:"~~"/"...~~Alternatives["BioChem", "GettingStarted", "UserGuide", "WSMLink", "WhatsNew"]~~"/*"],
                DocumentationBuild`Utils`DotHTML[
                  (* point paclets to /system-modeler/ without munging the value of urlBaseRemote *)
                  StringReplace[getOptionButtonData, {"paclet://"->"/system-modeler/", "paclet:"->"/system-modeler/"}]
                ],

	            StringQ[getOptionButtonData],  (*Global`AntLog@ToString[{pacletName, getOptionButtonData, uriDepth}];*)
	              DocumentationBuild`Utils`DotHTML@
	                StringReplace[getOptionButtonData, 
	                	If[ (completeHTMLQ === True) && !StringFreeQ[getOptionButtonData, pacletName],
		                  {pacletName<>"/"->"", "paclet:"->StringJoin @@ Flatten@Table[{"../"}, {uriDepth - 2}] },
		                  {"paclet://"->urlBaseRemote, "paclet:"->urlBaseRemote}
	                	]
	                ]
	          ,
	            (* If we get this far ButtonData is probably a URL and Link style needs to change to Hyperlink *)
	            True, "/ButtonBox/FIXME"
	          ]
	        ,
              DocumentationBuild`Utils`DotHTML@StringJoin[urlBaseRemote, "ref/", ToString@output]

	    ],

         "RootLink", 
            If[hasOptionButtonData,
	        DocumentationBuild`Utils`DotHTML@StringReplace[getOptionButtonData, {"paclet://"->urlBaseRemote, "paclet:"->urlBaseRemote}]
	      ,
                DocumentationBuild`Utils`DotHTML@StringJoin[urlBaseRemote, "ref/", ToString@output]
	    ],    

          "NewInVersionLink",
            If[hasOptionButtonData,
	        DocumentationBuild`Utils`DotHTML@StringReplace[getOptionButtonData, {"paclet://"->urlBaseRemote, "paclet:"->urlBaseRemote}]
	      ,
                DocumentationBuild`Utils`DotHTML@StringJoin[urlBaseRemote, "ref/", ToString@output]
	    ],

          "FunctionLink" | "TutorialLink" | "CharacterLink",
            (* ExportWebPage turns these into paclet:// links *)
            DocumentationBuild`Utils`DotHTML@StringReplace[getOptionButtonData, {"paclet://"->urlBaseRemote, "paclet:"->urlBaseRemote}],

          "ExampleLink",
            (* example links should point to the appropriate anchor on the same page *)
            (* check for ButtonData just in case... *)
            If[hasOptionButtonData,
	        StringJoin["#", StringReplace[ToString@getOptionButtonData, ":" -> "_"] ],
              "#"
	    ],

          "AnchorLink", 
            anchorButtons = SelectSelf[];
            anchorContent = First[Extract[anchorButtons, Position[anchorButtons, __ :> __]]];
            StringJoin["#", 
              Extract[
                Cases[First[Rest[Cases[anchorContent, _]]], _], 2]
            ], 

          "NewInLink", 
            "javascript:toggleModInfo('ModInfo_"<>versionNumber<>"')",

          "ModifiedInVersionLink", 
            "javascript:toggleModInfo('ModInfo_"<>versionNumber<>"')",

          "NewInVersionLink",
          DocumentationBuild`Utils`DotHTML@StringJoin[urlBaseRemote, "ref/", ToString@output],
		 (*"/language/guide/NewInVersion6.html",*)

          "GuideLink", 
            DocumentationBuild`Utils`DotHTML@StringJoin[urlBaseRemote, "guide/", output],
            
          "HowToScreencastLink", 
          getOptionButtonData[[1,1]] ,
           
           
          {"Link", "LinkTrail"}, Which[
 GetParameter["pacletName"] === "Mathematica", 
  DocumentationBuild`Utils`DotHTML@
  StringJoin[urlBaseRemote, 
   StringReplace[getOptionButtonData, {"paclet:" -> ""}]],
 GetParameter["pacletName"] === "webMathematica",
 DocumentationBuild`Utils`DotHTML@
  StringReplace[getOptionButtonData, 
	                	If[ (completeHTMLQ === True) && !StringFreeQ[getOptionButtonData, pacletName],
		                  {pacletName<>"/"->"", "paclet:"->StringJoin @@ Flatten@Table[{"../"}, {uriDepth - 2}] },
		                  {"paclet://"->urlBaseRemote, "paclet:"->urlBaseRemote}
	                	]
	                ],
   True,   
   DocumentationBuild`Utils`DotHTML@
  StringJoin[urlBaseRemote, 
   StringReplace[getOptionButtonData, {"paclet:" -> ""}]]
 ],
 
          {"Link", "LinkTrail"} | {{"Link"}, "ExcludedObject"}, 
            DocumentationBuild`Utils`DotHTML@StringJoin[urlBaseRemote, 
   StringReplace[getOptionButtonData, {"paclet:" -> ""}]],

          "MathWorldLink"|"FunctionsSiteLink",
            getOptionButtonData[[1, 1]],
            
            "ResourceTraining"|"ResourceVideos"|"ResourceDemonstrations"|"ResourceCommunity",
            getOptionButtonData[[1]],

          "MainBookLink",
              output,
              
          "Hyperlink"|"bluelink"|{"Hyperlink",_}, 
        Switch[getOptionButtonData,
        	
          URL[_] , 
            getOptionButtonData[[1]],
          {URL[__]} , 
            getOptionButtonData[[1, 1]],
          {URL[_], _}, 
          Which[MatchQ[Cases[SelectSelf[], _RuleDelayed, Infinity],
          	List[RuleDelayed[ButtonData, 
  List[URL[ToFileName[
     List[$InstallationDirectory, "SystemFiles", "Links", "NETLink", 
      "Examples", "Part2", "SimpleLink"]]], None]]] ],"/language/notebooks/SimpleLink.tar.gz" , 
      		MatchQ[Cases[SelectSelf[], _RuleDelayed, Infinity],
          	List[RuleDelayed[ButtonData, 
  List[URL[ToFileName[
     List[$InstallationDirectory, "SystemFiles", "Links", "NETLink", 
      "Examples", "Part2", "MathKernelApp"]]], None]]] ] ,"/language/notebooks/MathKernelApp.tar.gz" , 
      MatchQ[Cases[SelectSelf[], _RuleDelayed, Infinity],
          	List[RuleDelayed[ButtonData, 
  List[URL[ToFileName[
     List[$InstallationDirectory, "SystemFiles", "Links", "NETLink", 
      "Examples", "Part2"]]], None]]] ] ,"/language/notebooks/Part2.tar.gz" , 
      True, StringReplace[getOptionButtonData[[1, 1]],
                      {"http://reference.wolfram.com/alphaindex"->"/alphaindex"}]],
          (*{URL[_], _}, 
            StringReplace[getOptionButtonData[[1, 1]],
                      {"http://reference.wolfram.com/alphaindex"->"/alphaindex"}],*)
          {___, _String?((StringLength[#] >= 3 && StringTake[#, {-3,-1}] == ".nb")&)},  
            Last[getOptionButtonData],

          _String?((StringTake[#, {-3,-1}] == ".nb")&), 
            getOptionButtonData,

          {___, _String}, 
            DocumentationBuild`Utils`DotHTML@Last[getOptionButtonData],
          
          _String,   
		getOptionButtonData, 

          _,  Which[ getOptionButtonData==={"demonstrations.wolfram.com", None},"http://" <> getOptionButtonData[[1]],
          	StringTake[First[SelectChildren[]], {-3,-1}] === ".nb", "/language/notebooks/" <> SelectChildren[][[1]],
         	MemberQ[{"notation templates", "notation palette", "\:8868\:8a18\:6cd5\:30d1\:30ec\:30c3\:30c8", "\:8868\:8a18\:6cd5\:30c6\:30f3\:30d7\:30ec\:30fc\:30c8"}, First[SelectChildren[]]], "#",
         	True, "FIXME"]
          	
          (*_,   If[StringTake[First[SelectChildren[]], {-3,-1}] === ".nb",
          	"/language/notebooks/" <> SelectChildren[][[1]],"FIXME"]*)
            
        ] (* end URL Switch[] *),
        
      		
          _,   "#REMOVELINK#"
        ], (* end Switch[] *)
      
   
      		    hasOptionButtonData && GetOption[ButtonFunction]==="DEADFUNCTION", 
      		"#",
      		
      		    hasOptionButtonData,
      		    

        (** otherwise handle regular URL's in the ButtonData **)
        Switch[getOptionButtonData,
          URL[_],
            getOptionButtonData[[1]],

          {URL[_], _},
            getOptionButtonData[[1, 1]],

          {___, _String?((StringLength[#] >= 3 && StringTake[#, {-3,-1}] == ".nb")&)}, 
            Last[getOptionButtonData],

          _String?((StringTake[#, {-3,-1}] == ".nb")&),
            getOptionButtonData,

          {___, _String},
            DocumentationBuild`Utils`DotHTML@Last[getOptionButtonData],
          
          _String,  
			  DocumentationBuild`Utils`DotHTML@getOptionButtonData[[1]],

          _, 
            "FIXME"
        ] (* end URL Switch[] *),

      (** otherwise, we can't decide URL from ButtonBox[] **)
      True, 
        "/NO/BUTTONDATA/FIXME"
    ] (* end Which *)
  ]  //. {XMLElement["a", {a___, Rule["href","#REMOVELINK#"], b___}, {c___}]:>XMLElement["span", {a, b}, {c}]}
],(* end WithParameters *)

{TogglerBox} :> Module[{versionNumber, languageExtension},
versionNumber = StringSplit[$Version, "."][[1]];
languageExtension=Switch[language,
	"Spanish", ".es", 
	"ChineseSimplified", ".zh",
    "Japanese", ".ja",
    _, ""
];
XML`RawXML["<a href=\"#\" class=\"highlight-link\"></a>"]

]
}

] 

